/*
 * Decompiled with CFR 0.152.
 */
package javax.management.monitor;

import com.caucho.jmx.JobManager;
import javax.management.ObjectName;
import javax.management.monitor.Monitor;
import javax.management.monitor.MonitorNotification;
import javax.management.monitor.StringMonitorMBean;

public class StringMonitor
extends Monitor
implements StringMonitorMBean {
    private boolean _notifyDiffer;
    private boolean _notifyMatch;
    private String _stringToCompare = "";
    private long _sequence;

    public String getDerivedGauge(ObjectName name) {
        Monitor.ObjectValue value = this.getObjectValue(name);
        if (value == null) {
            return null;
        }
        return (String)value.getValue();
    }

    public String getStringToCompare() {
        return this._stringToCompare;
    }

    public void setStringToCompare(String value) throws IllegalArgumentException {
        this._stringToCompare = value;
    }

    public boolean getNotifyMatch() {
        return this._notifyMatch;
    }

    public void setNotifyMatch(boolean value) throws IllegalArgumentException {
        this._notifyMatch = value;
    }

    public boolean getNotifyDiffer() {
        return this._notifyDiffer;
    }

    public void setNotifyDiffer(boolean value) throws IllegalArgumentException {
        this._notifyDiffer = value;
    }

    public String getDerivedGauge() {
        return this.getDerivedGauge(this.getObservedObject());
    }

    public long getDerivedGaugeTimeStamp() {
        return this.getDerivedGaugeTimeStamp(this.getObservedObject());
    }

    protected void checkUpdate(Monitor.ObjectValue value, Object newValue) {
        String matchType = null;
        if (this._stringToCompare.equals(newValue)) {
            if (this._notifyMatch) {
                matchType = "jmx.monitor.string.matches";
            }
        } else if (this._notifyDiffer) {
            matchType = "jmx.monitor.string.differs";
        }
        if (matchType == null) {
            return;
        }
        MonitorNotification notif = new MonitorNotification(matchType, this.getName(), this._sequence, JobManager.getCurrentTime(), "change message", value.getName(), this.getObservedAttribute(), "gauge", "trigger");
        this.sendNotification(notif);
    }
}

