/*
 * Decompiled with CFR 0.152.
 */
package javax.management.openmbean;

import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;

public class ArrayType
extends OpenType {
    private int dimension;
    private OpenType elementType;

    public ArrayType(int dimension, OpenType elementType) throws OpenDataException {
        super(ArrayType.arrayName(dimension, elementType.getClassName()), ArrayType.arrayName(dimension, elementType.getTypeName()), dimension + "-dimension array of " + elementType.getDescription());
        this.dimension = dimension;
        this.elementType = elementType;
    }

    private static String arrayName(int dimension, String type) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < dimension; ++i) {
            sb.append("[");
        }
        sb.append(type);
        sb.append(";");
        return sb.toString();
    }

    public int getDimension() {
        return this.dimension;
    }

    public OpenType getElementType() {
        return this.elementType;
    }

    public boolean isValue(Object obj) {
        if (obj == null) {
            return false;
        }
        Class<?> cl = obj.getClass();
        for (int i = this.dimension - 1; i >= 0; --i) {
            if (!cl.isArray()) {
                return false;
            }
            cl = cl.getComponentType();
        }
        return true;
    }

    public boolean equals(Object o) {
        if (!(o instanceof ArrayType)) {
            return false;
        }
        ArrayType type = (ArrayType)o;
        return this.dimension == type.dimension && this.elementType.equals(type.elementType);
    }

    public int hashCode() {
        return this.dimension + this.elementType.hashCode();
    }
}

