/*
 * Decompiled with CFR 0.152.
 */
package javax.management.openmbean;

import java.util.Set;
import java.util.TreeMap;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;

public class CompositeType
extends OpenType {
    private TreeMap nameToDescription = new TreeMap();
    private TreeMap nameToType = new TreeMap();

    public CompositeType(String typeName, String description, String[] itemNames, String[] itemDescriptions, OpenType[] itemTypes) throws OpenDataException {
        super(CompositeType.class.getName(), typeName, description);
        for (int i = 0; i < itemNames.length; ++i) {
            this.nameToDescription.put(itemNames[i], itemDescriptions[i]);
            this.nameToType.put(itemNames[i], itemTypes[i]);
        }
    }

    public boolean containsKey(String name) {
        return this.nameToDescription.keySet().contains(name);
    }

    public String getDescription(String name) {
        return (String)this.nameToDescription.get(name);
    }

    public OpenType getType(String name) {
        return (OpenType)this.nameToType.get(name);
    }

    public Set keySet() {
        return this.nameToDescription.keySet();
    }

    public boolean isValue(Object value) {
        if (!(value instanceof CompositeData)) {
            return false;
        }
        CompositeData data = (CompositeData)value;
        return this.equals(data.getCompositeType());
    }

    public boolean equals(Object o) {
        if (!(o instanceof CompositeType)) {
            return false;
        }
        CompositeType type = (CompositeType)o;
        return this.nameToType.equals(type.nameToType);
    }

    public int hashCode() {
        return this.nameToType.hashCode();
    }

    public String toString() {
        return this.getClass().getName() + this.nameToType;
    }
}

