/*
 * Decompiled with CFR 0.152.
 */
package javax.management.openmbean;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.management.MBeanAttributeInfo;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenMBeanAttributeInfo;
import javax.management.openmbean.OpenType;

public class OpenMBeanAttributeInfoSupport
extends MBeanAttributeInfo
implements OpenMBeanAttributeInfo {
    private OpenType openType;
    private Object defaultValue;
    private Set legalValues;
    private Comparable minValue;
    private Comparable maxValue;

    public OpenMBeanAttributeInfoSupport(String name, String description, OpenType openType, boolean isReadable, boolean isWritable, boolean isIs) throws OpenDataException {
        super(name, openType.getTypeName(), description, isReadable, isWritable, isIs);
        this.openType = openType;
    }

    public OpenMBeanAttributeInfoSupport(String name, String description, OpenType openType, boolean isReadable, boolean isWritable, boolean isIs, Object defaultValue) throws OpenDataException {
        this(name, description, openType, isReadable, isWritable, isIs);
        this.defaultValue = defaultValue;
    }

    public OpenMBeanAttributeInfoSupport(String name, String description, OpenType openType, boolean isReadable, boolean isWritable, boolean isIs, Object defaultValue, Object[] legalValues) throws OpenDataException {
        this(name, description, openType, isReadable, isWritable, isIs);
        this.defaultValue = defaultValue;
        this.legalValues = new HashSet();
        for (int i = 0; i < legalValues.length; ++i) {
            this.legalValues.add(legalValues[i]);
        }
        this.legalValues = Collections.unmodifiableSet(this.legalValues);
    }

    public OpenMBeanAttributeInfoSupport(String name, String description, OpenType openType, boolean isReadable, boolean isWritable, boolean isIs, Object defaultValue, Comparable minValue, Comparable maxValue) throws OpenDataException {
        this(name, description, openType, isReadable, isWritable, isIs);
        this.defaultValue = defaultValue;
        this.minValue = minValue;
        this.maxValue = maxValue;
    }

    public OpenType getOpenType() {
        return this.openType;
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public Set getLegalValues() {
        return this.legalValues;
    }

    public Comparable getMinValue() {
        return this.minValue;
    }

    public Comparable getMaxValue() {
        return this.maxValue;
    }

    public boolean hasDefaultValue() {
        return this.defaultValue != null;
    }

    public boolean hasLegalValues() {
        return this.legalValues != null;
    }

    public boolean hasMinValue() {
        return this.minValue != null;
    }

    public boolean hasMaxValue() {
        return this.maxValue != null;
    }

    public boolean isValue(Object obj) {
        return this.getOpenType().isValue(obj);
    }

    public boolean equals(Object o) {
        if (!(o instanceof OpenMBeanAttributeInfoSupport)) {
            return false;
        }
        OpenMBeanAttributeInfoSupport info = (OpenMBeanAttributeInfoSupport)o;
        if (!this.getOpenType().equals(info.getOpenType())) {
            return false;
        }
        return this.getName().equals(info.getName());
    }

    public int hashCode() {
        return this.getOpenType().hashCode() + this.getName().hashCode();
    }
}

