/*
 * Decompiled with CFR 0.152.
 */
package javax.management.openmbean;

import java.io.ObjectStreamException;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;

public class SimpleType
extends OpenType {
    public static final SimpleType VOID = SimpleType.create("java.lang.Void");
    public static final SimpleType BOOLEAN = SimpleType.create("java.lang.Boolean");
    public static final SimpleType CHARACTER = SimpleType.create("java.lang.Character");
    public static final SimpleType BYTE = SimpleType.create("java.lang.Byte");
    public static final SimpleType SHORT = SimpleType.create("java.lang.Short");
    public static final SimpleType INTEGER = SimpleType.create("java.lang.Integer");
    public static final SimpleType LONG = SimpleType.create("java.lang.Long");
    public static final SimpleType FLOAT = SimpleType.create("java.lang.Float");
    public static final SimpleType DOUBLE = SimpleType.create("java.lang.Double");
    public static final SimpleType STRING = SimpleType.create("java.lang.String");
    public static final SimpleType BIGDECIMAL = SimpleType.create("java.math.BigDecimal");
    public static final SimpleType BIGINTEGER = SimpleType.create("java.math.BigInteger");
    public static final SimpleType DATE = SimpleType.create("java.lang.util");
    public static final SimpleType OBJECTNAME = SimpleType.create("javax.management.ObjectName");

    private SimpleType(String type) throws OpenDataException {
        super(type, type, type);
    }

    public boolean isValue(Object obj) {
        if (obj == null) {
            return false;
        }
        return obj.getClass().getName().equals(this.getTypeName());
    }

    public boolean equals(Object o) {
        if (!(o instanceof SimpleType)) {
            return false;
        }
        SimpleType simple = (SimpleType)o;
        return this.getTypeName().equals(simple.getTypeName());
    }

    public int hashCode() {
        return this.getTypeName().hashCode();
    }

    public Object readResolve() throws ObjectStreamException {
        String typeName = this.getTypeName();
        if (VOID.getTypeName().equals(typeName)) {
            return VOID;
        }
        if (BOOLEAN.getTypeName().equals(typeName)) {
            return BOOLEAN;
        }
        if (BYTE.getTypeName().equals(typeName)) {
            return BYTE;
        }
        if (SHORT.getTypeName().equals(typeName)) {
            return SHORT;
        }
        if (INTEGER.getTypeName().equals(typeName)) {
            return INTEGER;
        }
        if (LONG.getTypeName().equals(typeName)) {
            return LONG;
        }
        if (FLOAT.getTypeName().equals(typeName)) {
            return FLOAT;
        }
        if (DOUBLE.getTypeName().equals(typeName)) {
            return DOUBLE;
        }
        if (STRING.getTypeName().equals(typeName)) {
            return STRING;
        }
        if (BIGDECIMAL.getTypeName().equals(typeName)) {
            return BIGDECIMAL;
        }
        if (BIGINTEGER.getTypeName().equals(typeName)) {
            return BIGINTEGER;
        }
        if (DATE.getTypeName().equals(typeName)) {
            return DATE;
        }
        if (OBJECTNAME.getTypeName().equals(typeName)) {
            return OBJECTNAME;
        }
        return this;
    }

    private static SimpleType create(String type) {
        try {
            return new SimpleType(type);
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }
}

