/*
 * Decompiled with CFR 0.152.
 */
package javax.management.openmbean;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularType;

public class TabularDataSupport
implements TabularData,
Map,
Cloneable,
Serializable {
    private HashMap dataMap;
    private TabularType tabularType;

    public TabularDataSupport(TabularType tabularType) throws OpenDataException {
        this(tabularType, 101, 0.75f);
    }

    public TabularDataSupport(TabularType tabularType, int initialCapacity, float loadFactor) throws OpenDataException {
        this.tabularType = tabularType;
        this.dataMap = new HashMap(initialCapacity, loadFactor);
    }

    public TabularType getTabularType() {
        return this.tabularType;
    }

    public Object[] calculateIndex(CompositeData value) {
        List names = this.getTabularType().getIndexNames();
        Object[] key = new Object[names.size()];
        for (int i = 0; i < key.length; ++i) {
            key[i] = value.get((String)names.get(i));
        }
        return key;
    }

    public boolean containsKey(Object key) {
        if (key == null || !key.getClass().isArray()) {
            return false;
        }
        return this.containsKey((Object[])key);
    }

    public boolean containsKey(Object[] key) {
        return this.dataMap.containsKey(this.createKey(key));
    }

    public boolean containsValue(Object value) {
        if (!(value instanceof CompositeData)) {
            return false;
        }
        return this.dataMap.containsValue(value);
    }

    public boolean containsValue(CompositeData value) {
        return this.dataMap.containsValue(value);
    }

    public Object get(Object key) {
        return this.get((Object[])key);
    }

    public CompositeData get(Object[] key) {
        return (CompositeData)this.dataMap.get(this.createKey(key));
    }

    public Object put(Object key, Object value) {
        this.put((CompositeData)value);
        return null;
    }

    public void put(CompositeData value) {
        this.dataMap.put(this.createKey(this.calculateIndex(value)), value);
    }

    public Object remove(Object key) {
        return this.remove((Object[])key);
    }

    public CompositeData remove(Object[] key) {
        return (CompositeData)this.dataMap.remove(this.createKey(key));
    }

    public void putAll(Map t) {
        Iterator iter = t.values().iterator();
        while (iter.hasNext()) {
            CompositeData data = (CompositeData)iter.next();
            this.put(data);
        }
    }

    public void putAll(CompositeData[] values) {
        for (int i = 0; i < values.length; ++i) {
            this.put(values[i]);
        }
    }

    public void clear() {
        this.dataMap.clear();
    }

    public int size() {
        return this.dataMap.size();
    }

    public boolean isEmpty() {
        return this.dataMap.isEmpty();
    }

    public Set keySet() {
        return this.dataMap.keySet();
    }

    public Collection values() {
        return this.dataMap.values();
    }

    public Set entrySet() {
        return this.dataMap.entrySet();
    }

    public Object clone() {
        return this;
    }

    public boolean equals(Object o) {
        if (!(o instanceof TabularDataSupport)) {
            return false;
        }
        TabularDataSupport data = (TabularDataSupport)o;
        if (!this.tabularType.equals(data.tabularType)) {
            return false;
        }
        return this.dataMap.equals(data.dataMap);
    }

    public int hashCode() {
        return this.tabularType.hashCode();
    }

    private List createKey(Object[] key) {
        ArrayList<Object> keyList = new ArrayList<Object>();
        for (int i = 0; i < key.length; ++i) {
            keyList.add(key[i]);
        }
        return keyList;
    }
}

