/*
 * Decompiled with CFR 0.152.
 */
package javax.management.openmbean;

import java.util.ArrayList;
import java.util.List;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.TabularData;

public class TabularType
extends OpenType {
    private CompositeType rowType;
    private ArrayList indexNames = new ArrayList();

    public TabularType(String typeName, String description, CompositeType rowType, String[] indexNames) throws OpenDataException {
        super(TabularType.class.getName(), typeName, description);
        this.rowType = rowType;
        for (int i = 0; i < indexNames.length; ++i) {
            this.indexNames.add(indexNames[i]);
        }
    }

    public List getIndexNames() {
        return this.indexNames;
    }

    public CompositeType getRowType() {
        return this.rowType;
    }

    public boolean isValue(Object obj) {
        if (!(obj instanceof TabularData)) {
            return false;
        }
        TabularData data = (TabularData)obj;
        return this.equals(data.getTabularType());
    }

    public boolean equals(Object o) {
        if (!(o instanceof TabularType)) {
            return false;
        }
        TabularType type = (TabularType)o;
        return this.rowType.equals(type.rowType) && this.indexNames.equals(type.indexNames);
    }

    public int hashCode() {
        return this.rowType.hashCode();
    }

    public String toString() {
        return this.getClass().getName() + "[" + this.rowType + "," + this.indexNames + "]";
    }
}

