/*
 * Decompiled with CFR 0.152.
 */
package javax.management.relation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.Notification;
import javax.management.NotificationBroadcasterSupport;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.relation.InvalidRelationIdException;
import javax.management.relation.InvalidRelationServiceException;
import javax.management.relation.InvalidRelationTypeException;
import javax.management.relation.InvalidRoleValueException;
import javax.management.relation.Relation;
import javax.management.relation.RelationNotFoundException;
import javax.management.relation.RelationServiceMBean;
import javax.management.relation.RelationServiceNotRegisteredException;
import javax.management.relation.RelationSupport;
import javax.management.relation.RelationType;
import javax.management.relation.RelationTypeNotFoundException;
import javax.management.relation.RelationTypeSupport;
import javax.management.relation.Role;
import javax.management.relation.RoleInfo;
import javax.management.relation.RoleInfoNotFoundException;
import javax.management.relation.RoleList;
import javax.management.relation.RoleNotFoundException;
import javax.management.relation.RoleResult;

public class RelationService
extends NotificationBroadcasterSupport
implements RelationServiceMBean,
MBeanRegistration,
NotificationListener {
    private boolean _purgeFlag;
    private MBeanServer _server;
    private ObjectName _name;
    private HashMap _typeMap = new HashMap();
    private HashMap _relationMap = new HashMap();

    public RelationService(boolean immediatePurge) {
        this.setPurgeFlag(immediatePurge);
    }

    public boolean isActive() throws RelationServiceNotRegisteredException {
        return this._server != null;
    }

    public boolean getPurgeFlag() {
        return this._purgeFlag;
    }

    public void setPurgeFlag(boolean purgeFlag) {
        this._purgeFlag = purgeFlag;
    }

    public void createRelationType(String typeName, RoleInfo[] roleInfos) throws InvalidRelationTypeException {
        RelationType type = (RelationType)this._typeMap.get(typeName);
        if (type != null) {
            throw new InvalidRelationTypeException("duplicate relation " + typeName);
        }
        type = new RelationTypeSupport(typeName, roleInfos);
        this._typeMap.put(typeName, type);
    }

    public void addRelationType(RelationType relationType) throws InvalidRelationTypeException {
        String name = relationType.getRelationTypeName();
        if (this._typeMap.get(name) != null) {
            throw new InvalidRelationTypeException("duplicate relation " + name);
        }
        this._typeMap.put(name, relationType);
    }

    public List getAllRelationTypeNames() {
        ArrayList names = new ArrayList();
        names.addAll(this._typeMap.keySet());
        return names;
    }

    public List getRoleInfos(String relationType) throws RelationTypeNotFoundException {
        RelationType type = (RelationType)this._typeMap.get(relationType);
        if (type == null) {
            throw new RelationTypeNotFoundException(relationType);
        }
        ArrayList roles = new ArrayList();
        roles.addAll(type.getRoleInfos());
        return roles;
    }

    public RoleInfo getRoleInfo(String relationType, String roleInfo) throws RelationTypeNotFoundException, RoleInfoNotFoundException {
        RelationType type = (RelationType)this._typeMap.get(relationType);
        if (type == null) {
            throw new RelationTypeNotFoundException(relationType);
        }
        List roles = type.getRoleInfos();
        for (int i = roles.size() - 1; i >= 0; --i) {
            RoleInfo role = (RoleInfo)roles.get(i);
            if (!role.getName().equals(roleInfo)) continue;
            return role;
        }
        throw new RoleInfoNotFoundException(roleInfo);
    }

    public void removeRelationType(String relationType) throws RelationTypeNotFoundException {
        RelationType type = (RelationType)this._typeMap.remove(relationType);
        if (type == null) {
            throw new RelationTypeNotFoundException(relationType);
        }
    }

    public void createRelation(String id, String relationType, RoleList roleList) throws RelationServiceNotRegisteredException, RoleNotFoundException, InvalidRelationIdException, RelationTypeNotFoundException, InvalidRoleValueException {
        if (this._server == null) {
            throw new RelationServiceNotRegisteredException();
        }
        RelationType type = (RelationType)this._typeMap.get(relationType);
        if (type == null) {
            throw new RelationTypeNotFoundException(relationType);
        }
        for (int i = roleList.size() - 1; i >= 0; --i) {
            Role role = (Role)roleList.get(i);
            try {
                if (type.getRoleInfo(role.getRoleName()) != null) continue;
                throw new RoleNotFoundException(role.getRoleName());
            }
            catch (RoleInfoNotFoundException e) {
                throw new RoleNotFoundException(role.getRoleName());
            }
        }
        this._relationMap.put(id, new RelationSupport(id, this._name, this._server, type.getRelationTypeName(), roleList));
    }

    public void addRelation(ObjectName objectName) throws RelationServiceNotRegisteredException, InvalidRelationIdException, InstanceNotFoundException, InvalidRelationServiceException, RelationTypeNotFoundException, RoleNotFoundException, InvalidRoleValueException {
        throw new UnsupportedOperationException();
    }

    public ObjectName isRelationMBean(String id) throws RelationNotFoundException {
        return null;
    }

    public String isRelation(ObjectName objName) {
        return null;
    }

    public Boolean hasRelation(String id) {
        return new Boolean(this._relationMap.get(id) != null);
    }

    public List getAllRelationIds() {
        ArrayList relationIds = new ArrayList();
        relationIds.addAll(this._relationMap.keySet());
        return relationIds;
    }

    public Integer checkRoleReading(String roleName, String relationType) throws RelationTypeNotFoundException {
        RelationType type = (RelationType)this._typeMap.get(relationType);
        if (type == null) {
            throw new RelationTypeNotFoundException(relationType);
        }
        List roles = type.getRoleInfos();
        for (int i = roles.size() - 1; i >= 0; --i) {
            RoleInfo role = (RoleInfo)roles.get(i);
            if (!role.getName().equals(roleName)) continue;
            if (role.isReadable()) {
                return new Integer(0);
            }
            return new Integer(2);
        }
        return new Integer(1);
    }

    public Integer checkRoleWriting(Role role, String relationType, Boolean initFlag) throws RelationTypeNotFoundException {
        RelationType type = (RelationType)this._typeMap.get(relationType);
        if (type == null) {
            throw new RelationTypeNotFoundException(relationType);
        }
        List roles = type.getRoleInfos();
        for (int i = roles.size() - 1; i >= 0; --i) {
            RoleInfo roleInfo = (RoleInfo)roles.get(i);
            if (!roleInfo.getName().equals(role.getRoleName())) continue;
            if (initFlag != null && !initFlag.equals(Boolean.FALSE) && !roleInfo.isReadable()) {
                return new Integer(3);
            }
            if (role.getRoleValue().size() < roleInfo.getMinDegree()) {
                return new Integer(4);
            }
            if (roleInfo.getMaxDegree() >= role.getRoleValue().size()) continue;
            return new Integer(5);
        }
        return new Integer(1);
    }

    public void sendRelationCreationNotification(String id) throws RelationNotFoundException {
    }

    public void sendRoleUpdateNotification(String id, Role newRole, List oldRoles) throws RelationNotFoundException {
    }

    public void sendRelationRemovalNotification(String id, List unregMBeanList) throws RelationNotFoundException {
    }

    public void updateRoleMap(String id, Role newRole, List oldRoleValue) throws RelationServiceNotRegisteredException, RelationNotFoundException {
        throw new UnsupportedOperationException();
    }

    public void removeRelation(String id) throws RelationServiceNotRegisteredException, RelationNotFoundException {
        if (this._server == null) {
            throw new RelationServiceNotRegisteredException();
        }
        Relation relation = (Relation)this._relationMap.remove(id);
        if (relation == null) {
            throw new RelationNotFoundException(id);
        }
    }

    public void purgeRelations() throws RelationServiceNotRegisteredException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map findReferencingRelations(ObjectName mbeanName, String type, String roleName) {
        HashMap map = new HashMap();
        HashMap hashMap = this._relationMap;
        synchronized (hashMap) {
            Iterator iter = this._relationMap.values().iterator();
            while (iter.hasNext()) {
                RoleResult roles;
                Relation relation = (Relation)iter.next();
                if (type != null && !type.equals(relation.getRelationTypeName())) continue;
                ArrayList<String> roleNames = null;
                try {
                    roles = relation.getAllRoles();
                }
                catch (Exception e) {
                    continue;
                }
                RoleList roleList = roles.getRoles();
                for (int i = roleList.size() - 1; i >= 0; --i) {
                    List names;
                    Role role = (Role)roleList.get(i);
                    if (roleName != null && !role.getRoleName().equals(roleName) || !(names = role.getRoleValue()).contains(mbeanName)) continue;
                    if (roleNames == null) {
                        roleNames = new ArrayList<String>();
                        map.put(relation.getRelationId(), roleNames);
                    }
                    roleNames.add(role.getRoleName());
                }
            }
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map findAssociatedMBeans(ObjectName mbeanName, String type, String roleName) {
        HashMap<ObjectName, ArrayList<String>> map = new HashMap<ObjectName, ArrayList<String>>();
        HashMap hashMap = this._relationMap;
        synchronized (hashMap) {
            Iterator iter = this._relationMap.values().iterator();
            while (iter.hasNext()) {
                RoleResult roles;
                Relation relation = (Relation)iter.next();
                if (type != null && !type.equals(relation.getRelationTypeName())) continue;
                try {
                    roles = relation.getAllRoles();
                }
                catch (Exception e) {
                    continue;
                }
                RoleList roleList = roles.getRoles();
                for (int i = roleList.size() - 1; i >= 0; --i) {
                    List names;
                    Role role = (Role)roleList.get(i);
                    if (roleName != null && !role.getRoleName().equals(roleName) || !(names = role.getRoleValue()).contains(mbeanName)) continue;
                    for (int j = names.size() - 1; j >= 0; --j) {
                        ObjectName name = (ObjectName)names.get(j);
                        if (name.equals(mbeanName)) continue;
                        ArrayList<String> roleNames = (ArrayList<String>)map.get(name);
                        if (roleNames == null) {
                            roleNames = new ArrayList<String>();
                            map.put(name, roleNames);
                        }
                        roleNames.add(role.getRoleName());
                    }
                }
            }
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List findRelationsOfType(String relationType) throws RelationTypeNotFoundException {
        ArrayList<String> relationNames = new ArrayList<String>();
        HashMap hashMap = this._relationMap;
        synchronized (hashMap) {
            Iterator iter = this._relationMap.values().iterator();
            while (iter.hasNext()) {
                Relation rel = (Relation)iter.next();
                if (!rel.getRelationTypeName().equals(relationType)) continue;
                relationNames.add(rel.getRelationId());
            }
        }
        return relationNames;
    }

    public List getRole(String id, String roleName) throws RelationServiceNotRegisteredException, RelationNotFoundException, RoleNotFoundException {
        if (this._server == null) {
            throw new RelationServiceNotRegisteredException();
        }
        Relation relation = (Relation)this._relationMap.get(id);
        if (relation == null) {
            throw new RelationNotFoundException(id);
        }
        return relation.getRole(roleName);
    }

    public RoleResult getRoles(String id, String[] roleNames) throws RelationServiceNotRegisteredException, RelationNotFoundException {
        if (this._server == null) {
            throw new RelationServiceNotRegisteredException();
        }
        Relation relation = (Relation)this._relationMap.get(id);
        if (relation == null) {
            throw new RelationNotFoundException(id);
        }
        return relation.getRoles(roleNames);
    }

    public RoleResult getAllRoles(String relationId) throws RelationServiceNotRegisteredException, RelationNotFoundException {
        if (this._server == null) {
            throw new RelationServiceNotRegisteredException();
        }
        Relation relation = (Relation)this._relationMap.get(relationId);
        if (relation == null) {
            throw new RelationNotFoundException(relationId);
        }
        return relation.getAllRoles();
    }

    public Integer getRoleCardinality(String relationId, String roleName) throws RelationNotFoundException, RoleNotFoundException {
        Relation relation = (Relation)this._relationMap.get(relationId);
        if (relation == null) {
            throw new RelationNotFoundException(relationId);
        }
        return relation.getRoleCardinality(roleName);
    }

    public void setRole(String relationId, Role role) throws RelationServiceNotRegisteredException, RelationNotFoundException, RoleNotFoundException, InvalidRoleValueException, RelationTypeNotFoundException {
        Relation relation = (Relation)this._relationMap.get(relationId);
        if (relation == null) {
            throw new RelationNotFoundException(relationId);
        }
        relation.setRole(role);
    }

    public RoleResult setRoles(String relationId, RoleList roles) throws RelationServiceNotRegisteredException, RelationNotFoundException {
        Relation relation = (Relation)this._relationMap.get(relationId);
        if (relation == null) {
            throw new RelationNotFoundException(relationId);
        }
        try {
            return relation.setRoles(roles);
        }
        catch (RelationTypeNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public Map getReferencedMBeans(String relationId) throws RelationNotFoundException {
        Relation relation = (Relation)this._relationMap.get(relationId);
        if (relation == null) {
            throw new RelationNotFoundException(relationId);
        }
        return relation.getReferencedMBeans();
    }

    public String getRelationTypeName(String relationId) throws RelationNotFoundException {
        Relation relation = (Relation)this._relationMap.get(relationId);
        if (relation == null) {
            throw new RelationNotFoundException(relationId);
        }
        return relation.getRelationTypeName();
    }

    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        this._server = server;
        this._name = name;
        return name;
    }

    public void postRegister(Boolean registrationDone) {
    }

    public void preDeregister() throws Exception {
    }

    public void postDeregister() {
        this._server = null;
    }

    public void handleNotification(Notification notification, Object handback) {
    }
}

