/*
 * Decompiled with CFR 0.152.
 */
package javax.management.relation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.relation.InvalidRoleValueException;
import javax.management.relation.RelationNotFoundException;
import javax.management.relation.RelationServiceNotRegisteredException;
import javax.management.relation.RelationSupportMBean;
import javax.management.relation.RelationTypeNotFoundException;
import javax.management.relation.Role;
import javax.management.relation.RoleList;
import javax.management.relation.RoleNotFoundException;
import javax.management.relation.RoleResult;
import javax.management.relation.RoleUnresolved;
import javax.management.relation.RoleUnresolvedList;

public class RelationSupport
implements RelationSupportMBean,
MBeanRegistration {
    private String _id;
    private ObjectName _serviceName;
    private String _relationType;
    private RoleList _roleList;
    private MBeanServer _server;
    private Boolean _isInRelationService;

    public RelationSupport(String id, ObjectName serviceName, String relationType, RoleList roleList) throws InvalidRoleValueException {
        this._id = id;
        this._serviceName = serviceName;
        this._relationType = relationType;
        this._roleList = roleList;
    }

    public RelationSupport(String id, ObjectName serviceName, MBeanServer mbeanServer, String relationType, RoleList roleList) throws InvalidRoleValueException {
        this._id = id;
        this._serviceName = serviceName;
        this._relationType = relationType;
        this._roleList = roleList;
        this._server = mbeanServer;
    }

    public List getRole(String roleName) throws RoleNotFoundException, RelationServiceNotRegisteredException {
        for (int i = this._roleList.size() - 1; i >= 0; --i) {
            Role role = (Role)this._roleList.get(i);
            if (!role.getRoleName().equals(roleName)) continue;
            return role.getRoleValue();
        }
        return null;
    }

    public RoleResult getRoles(String[] roleNames) throws RelationServiceNotRegisteredException {
        RoleList roleList = new RoleList();
        RoleUnresolvedList unresolvedList = new RoleUnresolvedList();
        for (int i = 0; i < roleNames.length; ++i) {
            this.getRole(roleNames[i], roleList, unresolvedList);
        }
        return new RoleResult(roleList, unresolvedList);
    }

    private void getRole(String roleName, RoleList roleList, RoleUnresolvedList unresolvedList) {
        for (int i = this._roleList.size() - 1; i >= 0; --i) {
            Role role = (Role)this._roleList.get(i);
            if (!role.getRoleName().equals(roleName)) continue;
            roleList.add(role);
            return;
        }
        unresolvedList.add(new RoleUnresolved(roleName, null, 1));
    }

    public Integer getRoleCardinality(String roleName) throws RoleNotFoundException {
        for (int i = this._roleList.size() - 1; i >= 0; --i) {
            Role role = (Role)this._roleList.get(i);
            if (!role.getRoleName().equals(roleName)) continue;
            return new Integer(role.getRoleValue().size());
        }
        return null;
    }

    public RoleResult getAllRoles() throws RelationServiceNotRegisteredException {
        RoleList roleList = new RoleList();
        RoleUnresolvedList unresolvedList = new RoleUnresolvedList();
        roleList.addAll(this._roleList);
        return new RoleResult(roleList, unresolvedList);
    }

    public RoleList retrieveAllRoles() {
        RoleList roleList = new RoleList();
        roleList.addAll(this._roleList);
        return roleList;
    }

    public void setRole(Role role) throws RoleNotFoundException, RelationTypeNotFoundException, InvalidRoleValueException, RelationServiceNotRegisteredException, RelationTypeNotFoundException, RelationNotFoundException {
        for (int i = this._roleList.size() - 1; i >= 0; --i) {
            Role oldRole = (Role)this._roleList.get(i);
            if (!role.getRoleName().equals(oldRole.getRoleName())) continue;
            this._roleList.set(i, (Role)role.clone());
            return;
        }
        this._roleList.add((Role)role.clone());
    }

    public RoleResult setRoles(RoleList roleList) throws RelationServiceNotRegisteredException, RelationTypeNotFoundException, RelationNotFoundException {
        RoleList setRoles = new RoleList();
        RoleUnresolvedList unsetRoles = new RoleUnresolvedList();
        block0: for (int j = roleList.size() - 1; j >= 0; --j) {
            Role role = (Role)roleList.get(j);
            for (int i = this._roleList.size() - 1; i >= 0; --i) {
                Role oldRole = (Role)this._roleList.get(i);
                if (!role.getRoleName().equals(oldRole.getRoleName())) continue;
                this._roleList.set(i, (Role)role.clone());
                setRoles.add(role);
                continue block0;
            }
            this._roleList.add((Role)role.clone());
            setRoles.add(role);
        }
        return new RoleResult(setRoles, unsetRoles);
    }

    public void handleMBeanUnregistration(ObjectName objectName, String roleName) throws RoleNotFoundException, InvalidRoleValueException, RelationServiceNotRegisteredException, RelationTypeNotFoundException, RelationNotFoundException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getReferencedMBeans() {
        HashMap<ObjectName, ArrayList<String>> map = new HashMap<ObjectName, ArrayList<String>>();
        RoleList roleList = this._roleList;
        synchronized (roleList) {
            for (int i = this._roleList.size() - 1; i >= 0; --i) {
                Role role = (Role)this._roleList.get(i);
                List value = role.getRoleValue();
                if (value == null) continue;
                Iterator iter = value.iterator();
                while (iter.hasNext()) {
                    ObjectName name = (ObjectName)iter.next();
                    ArrayList<String> roles = (ArrayList<String>)map.get(name);
                    if (roles == null) {
                        roles = new ArrayList<String>();
                        map.put(name, roles);
                    }
                    roles.add(role.getRoleName());
                }
            }
        }
        return map;
    }

    public String getRelationTypeName() {
        return this._relationType;
    }

    public ObjectName getRelationServiceName() {
        return this._serviceName;
    }

    public String getRelationId() {
        return this._id;
    }

    public Boolean isInRelationService() {
        return this._isInRelationService;
    }

    public void setRelationServiceManagementFlag(Boolean flag) {
        this._isInRelationService = flag;
    }

    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        this._server = server;
        this._serviceName = name;
        return name;
    }

    public void postRegister(Boolean registrationDone) {
    }

    public void preDeregister() throws Exception {
    }

    public void postDeregister() {
    }
}

