/*
 * Decompiled with CFR 0.152.
 */
package javax.management.relation;

import java.io.Serializable;
import javax.management.NotCompliantMBeanException;
import javax.management.relation.InvalidRoleInfoException;

public class RoleInfo
implements Serializable {
    public static final int ROLE_CARDINALITY_INFINITY = Integer.MAX_VALUE;
    private String _description;
    private boolean _isReadable;
    private boolean _isWritable;
    private int _maxDegree = Integer.MAX_VALUE;
    private int _minDegree;
    private String _name;
    private String _refMBeanClassName;

    public RoleInfo(RoleInfo info) throws IllegalArgumentException {
        this._description = info.getDescription();
        this._isReadable = info.isReadable();
        this._isWritable = info.isWritable();
        this._maxDegree = info.getMaxDegree();
        this._minDegree = info.getMinDegree();
        this._name = info.getName();
        this._refMBeanClassName = info.getRefMBeanClassName();
    }

    public RoleInfo(String name, String className) throws IllegalArgumentException, ClassNotFoundException, NotCompliantMBeanException {
        this._name = name;
        this._refMBeanClassName = className;
    }

    public RoleInfo(String name, String className, boolean isReadable, boolean isWritable) throws IllegalArgumentException, ClassNotFoundException, NotCompliantMBeanException {
        this._name = name;
        this._refMBeanClassName = className;
        this._isReadable = isReadable;
        this._isWritable = isWritable;
    }

    public RoleInfo(String name, String className, boolean isReadable, boolean isWritable, int minDegree, int maxDegree, String description) throws IllegalArgumentException, InvalidRoleInfoException, ClassNotFoundException, NotCompliantMBeanException {
        this._name = name;
        this._refMBeanClassName = className;
        this._isReadable = isReadable;
        this._isWritable = isWritable;
        this._minDegree = minDegree;
        this._maxDegree = maxDegree;
        this._description = description;
    }

    public String getName() {
        return this._name;
    }

    public boolean isReadable() {
        return this._isReadable;
    }

    public boolean isWritable() {
        return this._isWritable;
    }

    public String getDescription() {
        return this._description;
    }

    public int getMinDegree() {
        return this._minDegree;
    }

    public int getMaxDegree() {
        return this._maxDegree;
    }

    public String getRefMBeanClassName() {
        return this._refMBeanClassName;
    }

    public boolean checkMinDegree(int degree) {
        return this._minDegree <= degree;
    }

    public boolean checkMaxDegree(int degree) {
        return degree <= this._maxDegree;
    }

    public String toString() {
        return "RoleInfo[name=" + this._name + "]";
    }
}

