/*
 * Decompiled with CFR 0.152.
 */
package javax.management.timer;

import com.caucho.jmx.JobManager;
import java.util.ArrayList;
import java.util.Date;
import java.util.TimerTask;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.NotificationBroadcasterSupport;
import javax.management.ObjectName;
import javax.management.timer.TimerMBean;
import javax.management.timer.TimerNotification;

public class Timer
extends NotificationBroadcasterSupport
implements TimerMBean,
MBeanRegistration {
    private static final Logger log = Logger.getLogger(Timer.class.getName());
    public static final long ONE_SECOND = 1000L;
    public static final long ONE_MINUTE = 60000L;
    public static final long ONE_HOUR = 3600000L;
    public static final long ONE_DAY = 86400000L;
    public static final long ONE_WEEK = 604800000L;
    private int _notificationId;
    private ArrayList _notifications = new ArrayList();
    private ArrayList _runJobs = new ArrayList();
    private boolean _isSendPastNotifications;
    private long _sequenceNumber;
    private boolean _isActive;
    private Job _job = new Job(this);

    public void start() {
        if (this._isActive) {
            return;
        }
        this._isActive = true;
        this.queue();
    }

    public void stop() {
        this._isActive = false;
        this.cancelTimer();
    }

    private void cancelTimer() {
        JobManager.dequeue(this._job);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer addNotification(String type, String message, Object userData, Date date, long period, long nbOccurences, boolean fixedRate) throws IllegalArgumentException {
        Integer value;
        Timer timer = this;
        synchronized (timer) {
            TimerJob job = new TimerJob(this.generateId(), type, message, userData, date, period, nbOccurences, fixedRate);
            this._notifications.add(job);
            value = new Integer(job.getId());
        }
        this.queue();
        return value;
    }

    public Integer addNotification(String type, String message, Object userData, Date date, long period, long nbOccurences) throws IllegalArgumentException {
        return this.addNotification(type, message, userData, date, period, nbOccurences, true);
    }

    public Integer addNotification(String type, String message, Object userData, Date date, long period) throws IllegalArgumentException {
        return this.addNotification(type, message, userData, date, period, 0x3FFFFFFFFFFFFFFFL, true);
    }

    public Integer addNotification(String type, String message, Object userData, Date date) throws IllegalArgumentException {
        return this.addNotification(type, message, userData, date, 0L, 1L, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int generateId() {
        Timer timer = this;
        synchronized (timer) {
            return this._notificationId++;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeNotification(Integer idObj) throws InstanceNotFoundException {
        int id = idObj;
        Timer timer = this;
        synchronized (timer) {
            for (int i = this._notifications.size() - 1; i >= 0; --i) {
                TimerJob job = (TimerJob)this._notifications.get(i);
                if (job.getId() != id) continue;
                this._notifications.remove(i);
                return;
            }
        }
        throw new InstanceNotFoundException(id + " is an unknown timer notification");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeNotifications(String type) throws InstanceNotFoundException {
        Timer timer = this;
        synchronized (timer) {
            for (int i = this._notifications.size() - 1; i >= 0; --i) {
                TimerJob job = (TimerJob)this._notifications.get(i);
                if (!job.getType().equals(type)) continue;
                this._notifications.remove(i);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllNotifications() {
        Timer timer = this;
        synchronized (timer) {
            this._notifications.clear();
            this._notificationId = 0;
            this.cancelTimer();
        }
    }

    public int getNbNotifications() {
        return this._notifications.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getAllNotificationIDs() {
        Vector<Integer> ids = new Vector<Integer>();
        Timer timer = this;
        synchronized (timer) {
            for (int i = this._notifications.size() - 1; i >= 0; --i) {
                TimerJob job = (TimerJob)this._notifications.get(i);
                ids.add(new Integer(job.getId()));
            }
        }
        return ids;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getNotificationIDs(String type) {
        Vector<Integer> ids = new Vector<Integer>();
        Timer timer = this;
        synchronized (timer) {
            for (int i = this._notifications.size() - 1; i >= 0; --i) {
                TimerJob job = (TimerJob)this._notifications.get(i);
                if (!job.getType().equals(type)) continue;
                ids.add(new Integer(job.getId()));
            }
        }
        return ids;
    }

    public String getNotificationType(Integer id) {
        TimerJob job = this.getNotification(id);
        if (job == null) {
            return null;
        }
        return job.getType();
    }

    public String getNotificationMessage(Integer id) {
        TimerJob job = this.getNotification(id);
        if (job == null) {
            return null;
        }
        return job.getMessage();
    }

    public Object getNotificationUserData(Integer id) {
        TimerJob job = this.getNotification(id);
        if (job == null) {
            return null;
        }
        return job.getUserData();
    }

    public Date getDate(Integer id) {
        TimerJob job = this.getNotification(id);
        if (job == null) {
            return null;
        }
        return job.getDate();
    }

    public Long getPeriod(Integer id) {
        TimerJob job = this.getNotification(id);
        if (job == null) {
            return null;
        }
        return new Long(job.getPeriod());
    }

    public Long getNbOccurences(Integer id) {
        TimerJob job = this.getNotification(id);
        if (job == null) {
            return null;
        }
        return new Long(job.getNbOccurences());
    }

    public boolean getSendPastNotifications() {
        return this._isSendPastNotifications;
    }

    public void setSendPastNotifications(boolean value) {
        this._isSendPastNotifications = value;
    }

    public Boolean getFixedRate(Integer id) {
        TimerJob job = this.getNotification(id);
        if (job == null) {
            return null;
        }
        return new Boolean(job.getFixedRate());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TimerJob getNotification(Integer idObj) {
        int id = idObj;
        Timer timer = this;
        synchronized (timer) {
            for (int i = this._notifications.size() - 1; i >= 0; --i) {
                TimerJob job = (TimerJob)this._notifications.get(i);
                if (job.getId() != id) continue;
                return job;
            }
        }
        return null;
    }

    public boolean isActive() {
        return this._isActive;
    }

    public boolean isEmpty() {
        return this._notifications.size() == 0;
    }

    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        return name;
    }

    public void postRegister(Boolean registrationDone) {
    }

    public void preDeregister() throws Exception {
        this.stop();
    }

    public void postDeregister() {
    }

    private void queue() {
        if (!this._isActive) {
            return;
        }
        this.run();
        long time = this.nextTime();
        if (time < Long.MAX_VALUE) {
            JobManager.queueAbsolute(this._job, time);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long nextTime() {
        long now = JobManager.getCurrentTime();
        long nextTime = Long.MAX_VALUE;
        Timer timer = this;
        synchronized (timer) {
            for (int i = this._notifications.size() - 1; i >= 0; --i) {
                TimerJob job = (TimerJob)this._notifications.get(i);
                long next = job.nextTime();
                if (next == Long.MAX_VALUE) {
                    this._notifications.remove(i);
                    continue;
                }
                if (next >= nextTime) continue;
                nextTime = next;
            }
        }
        return nextTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void run() {
        this._runJobs.clear();
        long now = JobManager.getCurrentTime();
        Timer timer = this;
        synchronized (timer) {
            for (int i = this._notifications.size() - 1; i >= 0; --i) {
                TimerJob job = (TimerJob)this._notifications.get(i);
                long nextTime = job.nextTime();
                if (0x3FFFFFFFFFFFFFFFL <= nextTime) {
                    this._notifications.remove(i);
                    continue;
                }
                if (nextTime > now) continue;
                this._runJobs.add(job);
                job.setLastTime(now);
                if (0x3FFFFFFFFFFFFFFFL > job.nextTime()) continue;
                this._notifications.remove(i);
            }
        }
        for (int i = this._runJobs.size() - 1; i >= 0; --i) {
            TimerJob job = (TimerJob)this._runJobs.get(i);
            TimerNotification notif = new TimerNotification(job.getType(), this, this._sequenceNumber++, now, job.getMessage(), new Integer(job.getId()));
            this.sendNotification(notif);
        }
    }

    static class Job
    extends TimerTask {
        private Timer _timer;

        Job(Timer timer) {
            this._timer = timer;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                this._timer.run();
            }
            finally {
                try {
                    long nextTime;
                    if (this._timer.isActive() && (nextTime = this._timer.nextTime()) < 0x3FFFFFFFFFFFFFFFL) {
                        JobManager.queueAbsolute(this, nextTime);
                    }
                }
                catch (Throwable e) {
                    log.log(Level.WARNING, e.toString(), e);
                }
            }
        }
    }

    static class TimerJob {
        private int _id;
        private String _type;
        private String _message;
        private Object _userData;
        private Date _date;
        private long _startDate;
        private long _period;
        private long _nbOccurences;
        private boolean _fixedRate;
        private long _lastTime;

        TimerJob(int id, String type, String message, Object userData, Date date, long period, long nbOccurences, boolean fixedRate) {
            this._id = id;
            this._type = type;
            this._message = message;
            this._userData = userData;
            this._date = date;
            this._startDate = date.getTime();
            this._period = period;
            this._nbOccurences = this._nbOccurences;
            this._fixedRate = fixedRate;
            this._lastTime = JobManager.getCurrentTime();
        }

        int getId() {
            return this._id;
        }

        String getType() {
            return this._type;
        }

        String getMessage() {
            return this._message;
        }

        Object getUserData() {
            return this._userData;
        }

        Date getDate() {
            return this._date;
        }

        long getPeriod() {
            return this._period;
        }

        long getNbOccurences() {
            return this._nbOccurences;
        }

        boolean getFixedRate() {
            return this._fixedRate;
        }

        long getLastTime() {
            return this._lastTime;
        }

        void setLastTime(long lastTime) {
            this._lastTime = lastTime;
        }

        long nextTime() {
            if (this._lastTime < this._startDate) {
                return this._startDate;
            }
            if (this._nbOccurences < 0L || 0x3FFFFFFFFFFFFFFFL <= this._nbOccurences) {
                return this._lastTime + this._period;
            }
            if (this._lastTime < this._startDate + this._period * this._nbOccurences) {
                return this._lastTime + this._period;
            }
            return Long.MAX_VALUE;
        }
    }
}

