/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.rpc;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Properties;
import javax.xml.namespace.QName;
import javax.xml.rpc.Service;
import javax.xml.rpc.ServiceException;

public abstract class ServiceFactory {
    public static final String SERVICEFACTORY_PROPERTY = "javax.xml.rpc.ServiceFactory";
    private static final String DEFAULT_FACTORY = "com.caucho.soap.rpc.ServiceFactory";

    protected ServiceFactory() {
    }

    public static ServiceFactory newInstance() throws ServiceException {
        String className = ServiceFactory.getFactoryClassName();
        Class<?> cl = null;
        try {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            if (loader != null) {
                cl = Class.forName(className, false, loader);
            }
        }
        catch (NoSuchMethodError e) {
        }
        catch (ClassNotFoundException e) {
            throw new ServiceException(e);
        }
        if (cl == null) {
            try {
                cl = Class.forName(className);
            }
            catch (ClassNotFoundException e) {
                throw new ServiceException(e);
            }
        }
        try {
            return (ServiceFactory)cl.newInstance();
        }
        catch (IllegalAccessException e) {
            throw new ServiceException(e);
        }
        catch (InstantiationException e) {
            throw new ServiceException(e);
        }
    }

    private static String getFactoryClassName() {
        String className = null;
        try {
            className = System.getProperty(SERVICEFACTORY_PROPERTY);
            if (className != null) {
                return className;
            }
        }
        catch (SecurityException e) {
            // empty catch block
        }
        String serviceName = "META-INF/services/javax.xml.rpc.ServiceFactory";
        try {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            InputStream is = loader != null ? loader.getResourceAsStream(serviceName) : ClassLoader.getSystemResourceAsStream(serviceName);
            InputStreamReader rawReader = new InputStreamReader(is);
            BufferedReader reader = new BufferedReader(rawReader);
            className = reader.readLine();
            reader.close();
            is.close();
            if (className != null) {
                className = className.trim();
            }
            if (className != null && !"".equals(className)) {
                return className;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return DEFAULT_FACTORY;
    }

    public abstract Service createService(URL var1, QName var2) throws ServiceException;

    public abstract Service createService(QName var1) throws ServiceException;

    public abstract Service loadService(Class var1) throws ServiceException;

    public abstract Service loadService(URL var1, Class var2, Properties var3) throws ServiceException;

    public abstract Service loadService(URL var1, QName var2, Properties var3) throws ServiceException;
}

