#include <stdio.h>
#include <unistd.h>
#include <errno.h>
#include <string.h>
#include <stdlib.h>
#include <sys/time.h>
/* Local defines */
#include "config.h"
#include "netconfig.h"
#include "functions.h"
#include <netinet/udp.h>


extern u_short FlgDebug;
extern u_short FlgExtraDebug;
extern u_short PcapOffset;
extern u_long TO;
extern struct icmp_item *ICMP_Recv;
extern struct udp_item *UDP_Recv;
u_short ICMPMIN=sizeof(struct icmp) + sizeof(struct ip);
u_short UDPMIN=sizeof(struct udphdr) + sizeof(struct ip);


void dolisten(pcap_t *pd)
{
u_char 		*recvpack;
struct timeval 	now;
struct timeval 	start;
int		n;
  if(FlgExtraDebug)
	printf("Starting listener. Data offset = %d\n", PcapOffset);

   gettimeofday(&start, NULL);
   now.tv_sec = start.tv_sec;
   now.tv_usec = start.tv_usec;

 while(getppid()!=1){
   do {
     switch(pcap_dispatch(pd, 1, (pcap_handler )read_processor, recvpack))
     {
           case 0: /* read nothing. decrement counter below */ 
		gettimeofday(&now, NULL);
		break;
           case -1: /* Error */
                fprintf(stderr, "pcap_dispatch error: %s\n",
                        pcap_geterr(pd));
		gettimeofday(&now, NULL);
                break;
           default: /* Read something. reset timer */
                 gettimeofday(&start, NULL); break;
		 now.tv_sec=start.tv_sec;
		 now.tv_usec=start.tv_usec;
		 break;
      }
   } while(TIMEVAL_SUBTRACT(now, start) < (TO*3000000));
 }
}

void read_processor(u_char *disp, struct pcap_pkthdr *h, u_char *data)
{
struct ip	*srcip;
  data+=PcapOffset;	/* Skip device header */
  srcip = (struct ip *)data;
  if((long)srcip & 3){
	printf("Fragmented packet encountered. I don't deal with these.\n");
	return;
  }
  if(srcip->ip_p == IPPROTO_ICMP){
	check_icmp(data, h->caplen - PcapOffset);
  }
  if(srcip->ip_p == IPPROTO_UDP){
	check_udp(data, h->caplen - PcapOffset);
  }
}

void check_udp(u_char *data, u_short len)
{
struct udphdr	*iudp;
struct ip	*sip;
struct udp_item *current;
char		*temp;
int		status;

  current=UDP_Recv;
  sip = (struct ip *)data;
  iudp = (struct udphdr *) (data + (sizeof(struct ip)));
  while(current){
	status=0;
	if(iudp->uh_sport == current->sport) status++;
	if(iudp->uh_dport == current->dport) status++;
	if(len > UDPMIN && current->string != NULL){
	   temp = (char *) iudp + sizeof(struct udphdr);
	   if(strstr(temp, current->string) != NULL) status++;
	}
        if(FlgExtraDebug)
	  printf("%s UDP Status: %d\n", inet_ntoa(sip->ip_src), status);
  	if(status >=current->nmatch)
	  printf("%s infected with %s\n", inet_ntoa(sip->ip_src), current->name);
	current=current->Next;
  }
}

void check_icmp(u_char *data, u_short len)
{
struct icmp	*icp;
struct ip	*sip;
struct icmp_item *current;
char		*temp;
int		status;		/* Status of check */

  current = ICMP_Recv;
  sip=(struct ip *)data;
  icp = (struct icmp *) (data + (sizeof(struct ip)));
  while(current){
	status = 0;
	if(icp->icmp_type == current->type) status++;
	if(icp->icmp_id == htons(current->id)) status++;
	if(icp->icmp_seq == current->seq) status++;
	if(icp->icmp_code == current->code) status++;
	if(len > ICMPMIN && current->string!=NULL){
	  temp = (char *) icp + sizeof(struct icmp);
	  if(strstr(temp, current->string) != NULL) status++;
	}
        if(FlgExtraDebug)
	  printf("%s ICMP status: %d\n", inet_ntoa(sip->ip_src), status);
  	if(status >=current->nmatch)
	  printf("%s infected with %s\n", inet_ntoa(sip->ip_src), current->name);
	current=current->Next;
  }
}
