#ifndef NETCONFIG_H
#define NETCONFIG_H
#define __FAVOR_BSD

#include <stdio.h>
#include <unistd.h>
#include <errno.h>
#include <string.h>
#include <stdlib.h>
#include <sys/time.h>
/* Network includes */
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/param.h>
#include <netinet/in_systm.h>
#include <netinet/in.h>
#include <netdb.h>
#include <signal.h>
#include <arpa/inet.h>
#include <netinet/ip.h>
#include <netinet/ip_icmp.h>
#ifdef __LINUX
#include <pcap/pcap.h>
#else
#include <pcap.h>
#endif

/* 
 *  This is the maximum hdr size for any tcp/ip protocol.  I just picked
 *  a large size at random on the safe side 
 */
#define MAX_PACK IP_MAXPACKET - 1024

/* 
 *   This ends up being a snap length, which to be safe should be your 
 *   maximum network MTU.  1500 is pretty standard 
 */
#define DEFAULT_MAXMTU 1500

/* 
 * default batch size of packets to send out at once before pause
 */
#define DEFAULT_BATCHSIZE 128

/* 
 * Default pause between sending batches - Designed not to flood network
 * This is in usec
 */
#define DEFAULT_SENDPAUSE 4

/* 
 * Default timeout for pcap_open_live command. From PCAP man page:
 * "specifies the read timeout in  milliseconds" though nothing
 * seems to really obey this.
 */
#define DEFAULT_PCAPTO 20

/*
 * Default timeout for select calls.  This is in microseconds (10^-6)
 */
#define DEFAULT_TO 1000000

/* 
 * Default time to sleep waiting for replies
 *
 */
#define DEFAULT_SLEEP 30

/* 
 * Default Number of ICMP's needed to determine whether a host is 
 * alive. Increasing this number yields better chance of hitting all
 * hosts
 */
#define DEFAULT_NUMPINGS 3
#define DEFAULT_NUMSENDS 1

/*
 * Maximum receive size.  This is large on some systems, but solaris
 * defaults to this.  So I went with the least common denominator
 */
#define MAX_RECV_BUF 1024*255

/* 
 * Simple link list to keep track of all icmp packets we're sending
 * and what we're looking for in icmp packets we're receiving.
 */

struct icmp_item {
        char name[BUFSIZE];	/* Name of check */
	char *string;		/* What data to set/look for */
	long seq, id, type, code;	/* What options to set/look for */
	long nmatch;		/* Number of matches needed for positive */
        struct icmp_item *Next;	 /* Next item in link list */
};

/* 
 * Simple link list to keep track of all udp packets we're sending
 * and what we're looking for in a udp packet we receive
 */

struct udp_item {
	char name[BUFSIZE];	/* Name of check */
	char *string;		/* Data we set/look for */
	long sport, dport;	/* What options to set/look for */
	long nmatch;		/* Number of matches needed for positive */
	struct udp_item *Next;	/* Next item in link list */
};

/* 
 * Define a simple link list of hosts that are alive. 
 */
struct host {
        struct sockaddr_in sad; /* Socket address */
        int alive;  	        /* Is it alive */
        struct host *Next;      /* Guess what */
};


/* Fix udp header information to be what we expect */
#ifdef __LINUX
typedef struct udphdr_bsd {
	unsigned short uh_sport;
	unsigned short uh_dport;
	unsigned short uh_ulen;
	unsigned short uh_sum;
} udphdr_bsd;
#else
  typedef struct udphdr udphdr_bsd;
#endif

#endif
