#include <stdio.h>
#include <unistd.h>
#include <errno.h>
#include <string.h>
#include <stdlib.h>
#include <sys/time.h>
/* Local defines */
#include "config.h"
#include "netconfig.h"
#include "functions.h"

extern int FlgDebug;
extern int FlgExtraDebug;
extern pid_t PidSender;
extern u_short NumSends;

extern struct host *Head;
extern struct icmp_item *ICMP_Send;
extern struct udp_item *UDP_Send;

int RawSock;
int TcpSock;
int UdpSock;

void sender()
{
  struct protoent *proto;
  int i;


/* Set up our sockets */
  proto=getprotobyname("icmp");
  if(proto==NULL){ 
	fprintf(stderr, "getprotbyname(icmp) failed. *aborting*.\n"); 
	exit(FAILURE);
  }
  RawSock = socket(AF_INET, SOCK_RAW, proto->p_proto);
  if(RawSock < 0){
	fprintf(stderr, "Couldn't get raw socket. *aborting*\n");
	exit(FAILURE);
  }

  proto=getprotobyname("tcp");
  if(proto==NULL){ 
	fprintf(stderr, "getprotbyname(tcp) failed. *aborting*.\n"); 
	exit(FAILURE);
  }
  TcpSock = socket(AF_INET, SOCK_STREAM, proto->p_proto);
  if(TcpSock < 0){
	fprintf(stderr, "Couldn't get tcp socket. *aborting*\n");
	exit(FAILURE);
  }

  proto=getprotobyname("udp");
  if(proto==NULL){ 
	fprintf(stderr, "getprotbyname(udp) failed. *aborting*.\n"); 
	exit(FAILURE);
  }
  UdpSock = socket(AF_INET, SOCK_DGRAM, proto->p_proto);
  if(UdpSock < 0){
	fprintf(stderr, "Couldn't get udp socket. *aborting*\n");
	exit(FAILURE);
  }

  for(i=0; i<NumSends; i++){
	icmp_send();
	udp_send();
  }
  close(UdpSock); close(RawSock); close(TcpSock);
}

void icmp_send(){ 
  struct host *current;
  struct icmp_item *icmp_current;
  static u_char outpack[IP_MAXPACKET];
  register struct icmp *icp = (struct icmp *)outpack;
  char *data = &outpack[8];
  int cc, i;

  current = Head;
  while(current)
  {
     icmp_current = ICMP_Send;
     while(icmp_current){
	bzero(outpack,IP_MAXPACKET);
	if(icmp_current->string != NULL){
	    memcpy(outpack + sizeof(struct icmp), 
		icmp_current->string, strlen(icmp_current->string));
	    cc = sizeof(struct icmp) + strlen(icmp_current->string);
         } else 
	    cc = sizeof(struct icmp);
	/* If value isn't set, set to zero. (-1 is not set) */
	if(icmp_current->type != -1)
	  icp->icmp_type = icmp_current->type;
	else
	  icp->icmp_type = 0;
	if(icmp_current->id != -1)
	  icp->icmp_id = htons(icmp_current->id);
	else
	  icp->icmp_id = htons(0);
	if(icmp_current->code != -1)
	  icp->icmp_code = icmp_current->code;
	else
	  icp->icmp_code = 0;
	if(icmp_current->seq != -1)
	  icp->icmp_seq = icmp_current->seq;
	else
	  icp->icmp_seq = 0;

	icp->icmp_cksum = ip_cksum((u_short *) icp, cc);
	i = sendto(RawSock, outpack, cc, 0, (struct sockaddr *) &current->sad, 
			sizeof(current->sad));
	if(i != cc || i < 0){
	  fprintf(stderr, "error sending %s packet\n", icmp_current->name);
	}
	icmp_current=icmp_current->Next;
     }
     current=current->Next;
  }
}

void udp_send() {
 struct host *current;
 struct udp_item *udp_current;
 char *buf;
 int i, cc;
 
  current = Head;
  while(current){
    udp_current = UDP_Send;
    while(udp_current){
	buf = udp_current->string;
	cc = strlen(buf);
	current->sad.sin_port = htons(udp_current->dport);
	i = sendto(UdpSock, buf, strlen(buf), 0, 
		  (struct sockaddr *) &current->sad, sizeof(current->sad));
	if(i!=cc){
		fprintf(stderr, "Trouble sending packet\n");
	}
	udp_current=udp_current->Next;
    } 
    current=current->Next;
  }
}
