/* Code to get discid for a cddb query.

  *** Linux Version ***

  $Id: discid.c,v 1.3 2001/04/14 17:54:53 jzawodn Exp $

  Copyright (c) 1998-2000 Jeremy D. Zawodny <Jeremy@Zawodny.com>

  This software is covered by the GPL.

  August 2001: This file was modified by Keenan Brock to add
     support for a command line argument containing a different
     Cd device other than /dev/cdrom

  Is is based on code found in:

    To: code-review@azure.humbug.org.au
    Subject: CDDB database reader
    From: Byron Ellacott <rodent@route-qn.uqnga.org.au>
    Date: Fri, 5 Jun 1998 17:32:40 +1000

*/

/* Stripped net code, 'cause I only care about the discid */

#include <stdio.h>
#include <stdlib.h>
#include <fcntl.h>
#include <sys/ioctl.h>
#include <linux/cdrom.h>
/*
#include <stdarg.h>
#include <errno.h>
#include <netdb.h>
#include <unistd.h>
#include <string.h>
#include <sys/types.h>
*/

struct toc {
    int sec, frame;
} cdtoc[100];

int read_toc(char *device) {
    int drive = open(device, O_RDONLY | O_NONBLOCK);
    struct cdrom_tochdr tochdr;		//query info
    struct cdrom_tocentry tocentry;	//retrieved information
    int i, tot_trks;

    ioctl(drive, CDROMREADTOCHDR, &tochdr);
    tot_trks=tochdr.cdth_trk1;

    for (i = tochdr.cdth_trk0-1; i <= tot_trks; i++) {
        tocentry.cdte_track = (i==tot_trks)?0xAA:i+1;
        tocentry.cdte_format = CDROM_MSF;
        ioctl(drive, CDROMREADTOCENTRY, &tocentry);
        cdtoc[i].sec = tocentry.cdte_addr.msf.minute * 60 + 
tocentry.cdte_addr.msf.second;
        cdtoc[i].frame = tocentry.cdte_addr.msf.frame + cdtoc[i].sec*75;
    }
    close(drive);
    return tot_trks;
}

unsigned int cddb_sum(int seconds) {
    unsigned int ret=0;

    while (seconds > 0) {
        ret += (seconds % 10);
        seconds /= 10;
    }
    return ret;
}

unsigned long cddb_discid(int tot_trks) {
    unsigned int i, t = 0, n = 0;

    for(i=0; i < tot_trks; i++)
        n += cddb_sum(cdtoc[i].sec);

    t = cdtoc[tot_trks].sec - cdtoc[0].sec;
    return ((n % 0xff) << 24 | t << 8 | tot_trks);
}

int main(int argc, char **argv) {
    char *devname="/dev/cdrom";
    unsigned long discid;
    int tracks, i;
    if(argc>1) {
        devname=argv[1];
    }
    tracks = read_toc(devname);
    discid = cddb_discid(tracks);
    printf("%08x %d", discid, tracks);
    for (i = 0; i < tracks; i++)
        printf(" %d", cdtoc[i].frame);
    printf(" %d\n", (cdtoc[tracks].frame)/75);
    exit(0);
}

