#!/bin/sh

BINPATHS="/bin /sbin /usr/bin /usr/sbin /usr/local/bin /usr/local/sbin /usr/local/libexec /usr/libexec"

SCANFILES="
clamd:ClamAV:
exim:Exim%%MTA:
gpg:GnuPG:
httpd:Apache:
mc:Midnight%%Commander:
named:Bind%%DNS:
php:PHP:
procmail:Procmail%%MTA:
proftpd:ProFTPd:
sshd:OpenSSH:
"

LINUX_KERNELS="
vulnerable:%2.4.22%2.4.23%
nonvulnerable:%2.4.24%
"

logtext()
  {
    a="test"
#    echo $1
  }

for J in ${SCANFILES}; do
    APPLICATION=`echo ${J} | cut -d ':' -f1`
    APPLICATIONNAME=`echo ${J} | cut -d ':' -f2`
    VULNERABLE=`cat programs_bad.dat | cut -d ':' -f2`
    NONVULNERABLE=`cat programs_good.dat | cut -d ':' -f2`
    logtext -n "Scanning ${APPLICATIONNAME}..."

  FILEFOUND=0
  for I in ${BINPATHS}; do

    if [ -f "${I}/${APPLICATION}" ]
      then
        FILEFOUND=1
        logtext "Found"
        VERSION=""
        case ${APPLICATION} in
          clamd)
                VERSION=`${I}/clamd --version | grep 'ClamAV version' | awk '{ print $5 }'`
                ;;

          exim)
                VERSION=`${I}/exim -bV | grep 'Exim version' | awk '{ print $3 }'`
                ;;
          gpg)
                VERSION=`${I}/gpg --version | grep 'GnuPG' | awk '{ print $3 }'`
                ;;
          httpd)
                VERSION=`${I}/httpd -v | grep 'Apache' | cut -d ' ' -f3 | cut -d '/' -f2`
                ;;
          mc)
#                VERSION=`${I}/mc -V 2> /tmp/mc.txt && cat /tmp/mc.txt | grep 'Midnight Commander' | awk '{ print $4 }' && rm -f /tmp/mc.txt`
                VERSION=`${I}/mc -V | head -n 1 2> /tmp/mc.txt && cat /tmp/mc.txt | grep 'Midnight Commander' | awk '{ print $4 }'`


                ;;
          named)
                VERSION=`${I}/named -v | grep 'named' | grep -v '/' | awk '{ print $2 }'`
	        if [ ! "`echo ${VERSION} | grep "-"`" = "" ]
		  then
		    VERSION=`echo ${VERSION} | cut -d '-' -f1`
		fi
                ;;
	  php)
	        VERSION=`php -v | head -n 1 | awk '{ print $2 }'`
		;;
          procmail)
                VERSION=`${I}/procmail -v 2> /tmp/procmail.txt && cat /tmp/procmail.txt | grep 'procmail v' | awk '{ print $2 }' | tr -d 'v' && rm -f /tmp/procmail.txt`
                ;;
	  proftpd)
	        VERSION=`${I}/proftpd -v 2> /tmp/proftpd.txt && cat /tmp/proftpd.txt | awk '{ print $4 }' && rm -f /tmp/proftpd.txt`
		;;
	  squid)
		VERSION=`${I}/squid -v | grep 'Squid Cache' | awk '{ print $4 }'`
		;;
          sshd)
                VERSION=`${I}/sshd -t -d 2> /tmp/openssh.txt && cat /tmp/openssh.txt | head -n 1 | awk '{ print $4 }' | cut -d '_' -f2 && rm -f /tmp/openssh.txt`
                ;;
          *)
                echo "Unknown"
                VERSION="NA"
                ;;
        esac

	VERSION=`echo ${VERSION} | tr -d '\r'`

        if [ "${VERSION}" = "" ]
          then
            echo "No version found"
          else
	    APPLICATIONNAME=`echo ${APPLICATIONNAME} | tr -s '%' ' '`
                echo -n "Found ${APPLICATIONNAME} ${VERSION}... "
                logtext "Vulnerable versions: ${VULNERABLE}"
                logtext "Non-vulnerable versions: ${NONVULNERABLE}"
                ISVULNERABLE=`echo ${VULNERABLE} | grep "%${VERSION}%"`
                if [ "${ISVULNERABLE}" = "" ]
                  then
                    ISNONVULNERABLE=`echo ${NONVULNERABLE} | grep "%${VERSION}%"`
                    if [ "${ISNONVULNERABLE}" = "" ]
                      then
                        logtext "No information available for this version"
			echo "[ Unknown ]"
                      else
                        logtext "Is available in non-vulnerable group and seems to be OK!"
			echo "[ OK ]"
                    fi
                  else
                    logtext "This version seems to be vulnerable!"
		    echo "[ BAD ]"
                fi
        fi

	logtext "-------------"

    fi
  done

if [ ${FILEFOUND} -eq 0 ]
  then
    logtext "Not found"
fi



done

if [ `uname` = "Linux" ]
  then
    KERNELVERSION=`uname -r`
      # Strip hypens (-)
      if [ ! `echo ${KERNELVERSION} | grep '-'` = "" ]
        then
          KERNELVERSION=`echo ${KERNELVERSION} | cut -d '-' -f1`
      fi

    echo -n "Search information for Linux kernel ${KERNELVERSION}..."

    FOUND=0
    VULNERABLE=0
    for I in ${LINUX_KERNELS}; do
      TYPE=`echo ${I} | cut -d ':' -f1`
      INFO=`echo ${I} | cut -d ':' -f2`

      if [ "${TYPE}" = "nonvulnerable" ]
        then
          GOODVERSIONS=`echo ${INFO} | sed -e "s/%/, /g" | sed -e "s/^, //"  | sed -e "s/, $//"`
      fi

      if [ ! "`echo ${INFO} | grep "${KERNELVERSION}"`" = "" -o ! "`echo ${INFO} | grep "${KERNELVERSION}-"`" = "" ]
        then
          if [ "${TYPE}" = "vulnerable" ]
            then
              FOUND=1
              VULNERABLE=1
              echo "Possible vulnerable kernel version!"


          fi

          if [ "${TYPE}" = "nonvulnerable" ]
            then
              FOUND=1
              echo "Found a non-vulnerable kernel version"
          fi
      fi
    done
    if [ "${FOUND}" -eq 0 ]
      then
        echo "Unknown version"
      else
        if [ "${VULNERABLE}" -eq 1 ]
          then
            echo "Please upgrade to a higher version like ${GOODVERSIONS}"
        fi
    fi


  else
    echo "Linux kernel check skipped"
fi


# The end


