# $Id: test_broken_classes.rb 49 2005-05-30 19:52:36Z tilman $

class BrokenTestData1
end

class BrokenTestData2
	def to_eet_properties
	end
end

class BrokenTestData3
	def to_eet_properties
		["blah"]
	end
end

class BrokenTestData4
	def to_eet_properties
		{}
	end
end

class BrokenTestData5
	def to_eet_name
		"blah"
	end

	def to_eet_properties
		{"" => nil}
	end
end

class BrokenTestData6
	def to_eet_name
		"blah"
	end

	def to_eet_properties
		{"blah" => nil}
	end
end

class BrokenTestData7
	def to_eet_properties
		{"blah" => [nil]}
	end
end

class BrokenTestData8
	def to_eet_name
	end

	def to_eet_properties
		{"blah" => [nil]}
	end
end

class BrokenTestData9
	def to_eet_name
		""
	end

	def to_eet_properties
		{"blah" => [nil]}
	end
end

class BrokenTest < Test::Unit::TestCase
	def test_broken_properties
		(1..6).each do |i|
			assert_raise(Eet::PropertyError) do
				Object.const_get("BrokenTestData#{i}").new.to_eet
			end
		end
	end

	def test_broken_eet_names
		assert_raise(TypeError) do
			BrokenTestData8.new.to_eet
		end

		assert_raise(Eet::NameError) do
			BrokenTestData9.new.to_eet
		end
	end
end
