# $Id: test_chunk.rb 44 2005-05-25 19:51:25Z tilman $

require "eet"
require "test/unit"

class ChunkTest < Test::Unit::TestCase
	def setup
		@data = Eet::Chunk.new("tag", "foo\0bar\0baz").serialize
	end

	def test_serialize
		assert_equal("CHnK\017\0\0\0tag\0foo\0bar\0baz", @data)
	end

	def test_deserialize
		chunk = nil

		assert_nothing_raised do
			chunk, = Eet::Chunk.deserialize(@data)
		end

		assert_equal("tag", chunk.tag)
		assert_equal("foo\0bar\0baz", chunk.data)
	end

	def test_deserialize_invalid
		assert_raise(Eet::ChunkError) do
			Eet::Chunk.deserialize("foobar" << "\377" * 4 << "tagdata")
		end

		assert_raise(Eet::ChunkError) do
			Eet::Chunk.deserialize("CHnK" << "\377" * 4 << "tagdata")
		end

		assert_raise(Eet::ChunkError) do
			Eet::Chunk.deserialize("CHnK\010\0\0\0tag0data")
		end

		assert_nothing_raised do
			Eet::Chunk.deserialize("CHnK\10\0\0\0tag\0data")
		end
	end

	def test_catch_invalid_tag
		assert_raise(ArgumentError) do
			Eet::Chunk.new("foo\0bar", "data")
		end
	end
end
