# $Id: test_hash.rb 1 2005-03-26 01:45:38Z tilman $

require "eet"
require "test/unit"
require "common"

class HashEntry
	def initialize(key, value)
		@key = key.to_str.dup.freeze
		@value = value.to_str.dup.freeze
	end
end

class HashTestData
	def initialize
		@hash = {"artist" => HashEntry.new("artist", "Amon Amarth"),
		         "title" => HashEntry.new("title", "Death In Fire")}
	end

	private
	def to_eet_name
		"HashTest"
	end

	def to_eet_properties
		{"hash" => [@hash]}
	end
end

class HashTest < Test::Unit::TestCase
	def test_hash
		data = HashTestData.new.to_eet
		assert_not_nil(data)

		stream = nil

		assert_nothing_raised do
			stream = Eet::Stream.deserialize(data)
		end

		assert_equal(1, stream.length)
		assert_equal("HashTest", stream.first.tag)


		assert_nothing_raised do
			stream = Eet::Stream.deserialize(stream.first.data)
		end

		assert_equal(2, stream.length)

		2.times do
			hashlist = stream.find_all { |c| c.tag == "hash" }
			assert_equal(2, hashlist.length)

			hash = {"artist" => "Amon Amarth",
			        "title" => "Death In Fire"}
			hash.each do |key, value|
				str_stream = nil

				assert_nothing_raised do
					d = hashlist.shift.data
					str_stream = Eet::Stream.deserialize(d)
				end

				assert_equal(1, str_stream.length)
				assert_equal("HashEntry", str_stream.first.tag)

				foo = nil

				assert_nothing_raised do
					foo = Eet::Stream.deserialize(str_stream.first.data)
				end

				assert_equal(2, foo.length)

				{"key" => key, "value" => value}.each do |tag, data|
					found = foo.find { |i| i.tag == tag }
					assert_not_nil(found)
					assert_equal(data + "\0", found.data)
				end
			end

			assert_equal([], hashlist)
		end
	end
end
