# $Id: test_sub.rb 1 2005-03-26 01:45:38Z tilman $

require "eet"
require "test/unit"
require "common"

class SubTestData
	def initialize
		@string = WrappedString.new("foobar")
	end

	private
	def to_eet_name
		"SubTest"
	end

	def to_eet_properties
		{"sub_test" => [@string],
		 "nil_test" => [nil]}
	end
end

class SubTest < Test::Unit::TestCase
	def test_sub
		data = SubTestData.new.to_eet
		assert_not_nil(data)

		stream = nil

		assert_nothing_raised do
			stream = Eet::Stream.deserialize(data)
		end

		assert_equal(1, stream.length)
		assert_equal("SubTest", stream.first.tag)

		assert_nothing_raised do
			stream = Eet::Stream.deserialize(stream.first.data)
		end

		assert_equal(1, stream.length)
		assert_equal("sub_test", stream.first.tag)

		assert_nothing_raised do
			stream = Eet::Stream.deserialize(stream.first.data)
		end

		assert_equal(1, stream.length)
		assert_equal("String", stream.first.tag)

		assert_nothing_raised do
			stream = Eet::Stream.deserialize(stream.first.data)
		end

		assert_equal(1, stream.length)
		assert_equal("buf", stream.first.tag)
		assert_equal("foobar\0", stream.first.data)
	end
end
