/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 1.3.22
 * 
 * This file is not intended to be easily readable and contains a number of 
 * coding conventions designed to improve portability and efficiency. Do not make
 * changes to this file unless you know what you are doing--modify the SWIG 
 * interface file instead. 
 * ----------------------------------------------------------------------------- */

#define SWIG_NOINCLUDE

#ifdef __cplusplus
template<class T> class SwigValueWrapper {
    T *tt;
public:
    SwigValueWrapper() : tt(0) { }
    SwigValueWrapper(const SwigValueWrapper<T>& rhs) : tt(new T(*rhs.tt)) { }
    SwigValueWrapper(const T& t) : tt(new T(t)) { }
    ~SwigValueWrapper() { delete tt; } 
    SwigValueWrapper& operator=(const T& t) { delete tt; tt = new T(t); return *this; }
    operator T&() const { return *tt; }
    T *operator&() { return tt; }
private:
    SwigValueWrapper& operator=(const SwigValueWrapper<T>& rhs);
};                                                    
#endif

/* ruby.swg */
/* Implementation : RUBY */
#define SWIGRUBY 1

#include "ruby.h"

/* Flags for pointer conversion */
#define SWIG_POINTER_EXCEPTION     0x1
#define SWIG_POINTER_DISOWN        0x2

#define NUM2USHRT(n) (\
    (0 <= NUM2UINT(n) && NUM2UINT(n) <= USHRT_MAX)\
    ? (unsigned short) NUM2UINT(n) \
    : (rb_raise(rb_eArgError, "integer %d out of range of `unsigned short'",\
               NUM2UINT(n)), (short)0)\
)

#define NUM2SHRT(n) (\
    (SHRT_MIN <= NUM2INT(n) && NUM2INT(n) <= SHRT_MAX)\
    ? (short)NUM2INT(n)\
    : (rb_raise(rb_eArgError, "integer %d out of range of `short'",\
               NUM2INT(n)), (short)0)\
)

/* Ruby 1.7 defines NUM2LL(), LL2NUM() and ULL2NUM() macros */
#ifndef NUM2LL
#define NUM2LL(x) NUM2LONG((x))
#endif
#ifndef LL2NUM
#define LL2NUM(x) INT2NUM((long) (x))
#endif
#ifndef ULL2NUM
#define ULL2NUM(x) UINT2NUM((unsigned long) (x))
#endif

/* Ruby 1.7 doesn't (yet) define NUM2ULL() */
#ifndef NUM2ULL
#ifdef HAVE_LONG_LONG
#define NUM2ULL(x) rb_num2ull((x))
#else
#define NUM2ULL(x) NUM2ULONG(x)
#endif
#endif

/*
 * Need to be very careful about how these macros are defined, especially
 * when compiling C++ code or C code with an ANSI C compiler.
 *
 * VALUEFUNC(f) is a macro used to typecast a C function that implements
 * a Ruby method so that it can be passed as an argument to API functions
 * like rb_define_method() and rb_define_singleton_method().
 *
 * VOIDFUNC(f) is a macro used to typecast a C function that implements
 * either the "mark" or "free" stuff for a Ruby Data object, so that it
 * can be passed as an argument to API functions like Data_Wrap_Struct()
 * and Data_Make_Struct().
 */
 
#ifdef __cplusplus
#  ifndef RUBY_METHOD_FUNC /* These definitions should work for Ruby 1.4.6 */
#    define PROTECTFUNC(f) ((VALUE (*)()) f)
#    define VALUEFUNC(f) ((VALUE (*)()) f)
#    define VOIDFUNC(f)  ((void (*)()) f)
#  else
#    ifndef ANYARGS /* These definitions should work for Ruby 1.6 */
#      define PROTECTFUNC(f) ((VALUE (*)()) f)
#      define VALUEFUNC(f) ((VALUE (*)()) f)
#      define VOIDFUNC(f)  ((RUBY_DATA_FUNC) f)
#    else /* These definitions should work for Ruby 1.7+ */
#      define PROTECTFUNC(f) ((VALUE (*)(VALUE)) f)
#      define VALUEFUNC(f) ((VALUE (*)(ANYARGS)) f)
#      define VOIDFUNC(f)  ((RUBY_DATA_FUNC) f)
#    endif
#  endif
#else
#  define VALUEFUNC(f) (f)
#  define VOIDFUNC(f) (f)
#endif

typedef struct {
  VALUE klass;
  VALUE mImpl;
  void  (*mark)(void *);
  void  (*destroy)(void *);
} swig_class;

/* Don't use for expressions have side effect */
#ifndef RB_STRING_VALUE
#define RB_STRING_VALUE(s) (TYPE(s) == T_STRING ? (s) : (*(volatile VALUE *)&(s) = rb_str_to_str(s)))
#endif
#ifndef StringValue
#define StringValue(s) RB_STRING_VALUE(s)
#endif
#ifndef StringValuePtr
#define StringValuePtr(s) RSTRING(RB_STRING_VALUE(s))->ptr
#endif
#ifndef StringValueLen
#define StringValueLen(s) RSTRING(RB_STRING_VALUE(s))->len
#endif
#ifndef SafeStringValue
#define SafeStringValue(v) do {\
    StringValue(v);\
    rb_check_safe_str(v);\
} while (0)
#endif

#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
#define rb_define_alloc_func(klass, func) rb_define_singleton_method((klass), "new", VALUEFUNC((func)), -1)
#define rb_undef_alloc_func(klass) rb_undef_method(CLASS_OF((klass)), "new")
#endif

/* Contract support */

#define SWIG_contract_assert(expr, msg) if (!(expr)) { rb_raise(rb_eRuntimeError, (char *) msg ); } else


/*************************************************************** -*- c -*-
 * ruby/precommon.swg
 *
 * Rename all exported symbols from common.swg, to avoid symbol
 * clashes if multiple interpreters are included
 *
 ************************************************************************/

#define SWIG_TypeRegister    SWIG_Ruby_TypeRegister
#define SWIG_TypeCheck       SWIG_Ruby_TypeCheck
#define SWIG_TypeCast        SWIG_Ruby_TypeCast
#define SWIG_TypeDynamicCast SWIG_Ruby_TypeDynamicCast
#define SWIG_TypeName        SWIG_Ruby_TypeName
#define SWIG_TypePrettyName  SWIG_Ruby_TypePrettyName
#define SWIG_TypeQuery       SWIG_Ruby_TypeQuery
#define SWIG_TypeClientData  SWIG_Ruby_TypeClientData
#define SWIG_PackData        SWIG_Ruby_PackData 
#define SWIG_UnpackData      SWIG_Ruby_UnpackData 

/* Also rename all exported symbols from rubydef.swig */

/* Common SWIG API */
#define SWIG_ConvertPtr(obj, pp, type, flags) \
  SWIG_Ruby_ConvertPtr(obj, pp, type, flags)
#define SWIG_NewPointerObj(p, type, flags) \
  SWIG_Ruby_NewPointerObj(p, type, flags)
#define SWIG_MustGetPtr(p, type, argnum, flags) \
  SWIG_Ruby_MustGetPtr(p, type, argnum, flags)

/* Ruby-specific SWIG API */

#define SWIG_InitRuntime() \
  SWIG_Ruby_InitRuntime()
#define SWIG_define_class(ty) \
  SWIG_Ruby_define_class(ty)
#define SWIG_NewClassInstance(value, ty) \
  SWIG_Ruby_NewClassInstance(value, ty)
#define SWIG_MangleStr(value) \
  SWIG_Ruby_MangleStr(value)
#define SWIG_CheckConvert(value, ty) \
  SWIG_Ruby_CheckConvert(value, ty)
#define SWIG_NewPackedObj(ptr, sz, ty) \
  SWIG_Ruby_NewPackedObj(ptr, sz, ty)
#define SWIG_ConvertPacked(obj, ptr, sz, ty, flags) \
  SWIG_Ruby_ConvertPacked(obj, ptr, sz, ty, flags)


/***********************************************************************
 * common.swg
 *
 *     This file contains generic SWIG runtime support for pointer
 *     type checking as well as a few commonly used macros to control
 *     external linkage.
 *
 * Author : David Beazley (beazley@cs.uchicago.edu)
 *
 * Copyright (c) 1999-2000, The University of Chicago
 * 
 * This file may be freely redistributed without license or fee provided
 * this copyright message remains intact.
 ************************************************************************/

#include <string.h>

#if defined(_WIN32) || defined(__WIN32__) || defined(__CYGWIN__)
#  if defined(_MSC_VER) || defined(__GNUC__)
#    if defined(STATIC_LINKED)
#      define SWIGEXPORT(a) a
#      define SWIGIMPORT(a) extern a
#    else
#      define SWIGEXPORT(a) __declspec(dllexport) a
#      define SWIGIMPORT(a) extern a
#    endif
#  else
#    if defined(__BORLANDC__)
#      define SWIGEXPORT(a) a _export
#      define SWIGIMPORT(a) a _export
#    else
#      define SWIGEXPORT(a) a
#      define SWIGIMPORT(a) a
#    endif
#  endif
#else
#  define SWIGEXPORT(a) a
#  define SWIGIMPORT(a) a
#endif

#ifdef SWIG_GLOBAL
#  define SWIGRUNTIME(a) SWIGEXPORT(a)
#else
#  define SWIGRUNTIME(a) static a
#endif

#ifdef __cplusplus
extern "C" {
#endif

typedef void *(*swig_converter_func)(void *);
typedef struct swig_type_info *(*swig_dycast_func)(void **);

typedef struct swig_type_info {
  const char             *name;
  swig_converter_func     converter;
  const char             *str;
  void                   *clientdata;
  swig_dycast_func        dcast;
  struct swig_type_info  *next;
  struct swig_type_info  *prev;
} swig_type_info;

#ifdef SWIG_NOINCLUDE

SWIGIMPORT(swig_type_info *) SWIG_TypeRegister(swig_type_info *);
SWIGIMPORT(swig_type_info *) SWIG_TypeCheck(char *c, swig_type_info *);
SWIGIMPORT(void *)           SWIG_TypeCast(swig_type_info *, void *);
SWIGIMPORT(swig_type_info *) SWIG_TypeDynamicCast(swig_type_info *, void **);
SWIGIMPORT(const char *)     SWIG_TypeName(const swig_type_info *);
SWIGIMPORT(const char *)     SWIG_TypePrettyName(const swig_type_info *);
SWIGIMPORT(swig_type_info *) SWIG_TypeQuery(const char *);
SWIGIMPORT(void)             SWIG_TypeClientData(swig_type_info *, void *);
SWIGIMPORT(char *)           SWIG_PackData(char *, void *, int);
SWIGIMPORT(char *)           SWIG_UnpackData(char *, void *, int);

#else

static swig_type_info *swig_type_list = 0;
static swig_type_info **swig_type_list_handle = &swig_type_list;

/* Register a type mapping with the type-checking */
SWIGRUNTIME(swig_type_info *)
SWIG_TypeRegister(swig_type_info *ti) {
  swig_type_info *tc, *head, *ret, *next;
  /* Check to see if this type has already been registered */
  tc = *swig_type_list_handle;
  while (tc) {
    if (strcmp(tc->name, ti->name) == 0) {
      /* Already exists in the table.  Just add additional types to the list */
      if (tc->clientdata) ti->clientdata = tc->clientdata;
      head = tc;
      next = tc->next;
      goto l1;
    }
    tc = tc->prev;
  }
  head = ti;
  next = 0;

  /* Place in list */
  ti->prev = *swig_type_list_handle;
  *swig_type_list_handle = ti;

  /* Build linked lists */
  l1:
  ret = head;
  tc = ti + 1;
  /* Patch up the rest of the links */
  while (tc->name) {
    head->next = tc;
    tc->prev = head;
    head = tc;
    tc++;
  }
  if (next) next->prev = head;
  head->next = next;
  return ret;
}

/* Check the typename */
SWIGRUNTIME(swig_type_info *) 
SWIG_TypeCheck(char *c, swig_type_info *ty) {
  swig_type_info *s;
  if (!ty) return 0;        /* Void pointer */
  s = ty->next;             /* First element always just a name */
  do {
    if (strcmp(s->name,c) == 0) {
      if (s == ty->next) return s;
      /* Move s to the top of the linked list */
      s->prev->next = s->next;
      if (s->next) {
        s->next->prev = s->prev;
      }
      /* Insert s as second element in the list */
      s->next = ty->next;
      if (ty->next) ty->next->prev = s;
      ty->next = s;
      s->prev = ty;
      return s;
    }
    s = s->next;
  } while (s && (s != ty->next));
  return 0;
}

/* Cast a pointer up an inheritance hierarchy */
SWIGRUNTIME(void *) 
SWIG_TypeCast(swig_type_info *ty, void *ptr) {
  if ((!ty) || (!ty->converter)) return ptr;
  return (*ty->converter)(ptr);
}

/* Dynamic pointer casting. Down an inheritance hierarchy */
SWIGRUNTIME(swig_type_info *) 
SWIG_TypeDynamicCast(swig_type_info *ty, void **ptr) {
  swig_type_info *lastty = ty;
  if (!ty || !ty->dcast) return ty;
  while (ty && (ty->dcast)) {
    ty = (*ty->dcast)(ptr);
    if (ty) lastty = ty;
  }
  return lastty;
}

/* Return the name associated with this type */
SWIGRUNTIME(const char *)
SWIG_TypeName(const swig_type_info *ty) {
  return ty->name;
}

/* Return the pretty name associated with this type,
   that is an unmangled type name in a form presentable to the user.
*/
SWIGRUNTIME(const char *)
SWIG_TypePrettyName(const swig_type_info *type) {
  /* The "str" field contains the equivalent pretty names of the
     type, separated by vertical-bar characters.  We choose
     to print the last name, as it is often (?) the most
     specific. */
  if (type->str != NULL) {
    const char *last_name = type->str;
    const char *s;
    for (s = type->str; *s; s++)
      if (*s == '|') last_name = s+1;
    return last_name;
  }
  else
    return type->name;
}

/* 
   Compare two type names skipping the space characters, therefore
   "char*" == "char *" and "Class<int>" == "Class<int >", etc.

   Return 0 when the two name types are equivalent, as in
   strncmp, but skipping ' '.
*/
static int
SWIG_TypeNameComp(const char *f1, const char *l1,
		  const char *f2, const char *l2) {
  for (;(f1 != l1) && (f2 != l2); ++f1, ++f2) {
    while ((*f1 == ' ') && (f1 != l1)) ++f1;
    while ((*f2 == ' ') && (f2 != l2)) ++f2;
    if (*f1 != *f2) return *f1 - *f2;
  }
  return (l1 - f1) - (l2 - f2);
}

/*
  Check type equivalence in a name list like <name1>|<name2>|...
*/
static int
SWIG_TypeEquiv(const char *nb, const char *tb) {
  int equiv = 0;
  const char* te = tb + strlen(tb);
  const char* ne = nb;
  while (!equiv && *ne) {
    for (nb = ne; *ne; ++ne) {
      if (*ne == '|') break;
    }
    equiv = SWIG_TypeNameComp(nb, ne, tb, te) == 0;
    if (*ne) ++ne;
  }
  return equiv;
}
  

/* Search for a swig_type_info structure */
SWIGRUNTIME(swig_type_info *)
SWIG_TypeQuery(const char *name) {
  swig_type_info *ty = *swig_type_list_handle;
  while (ty) {
    if (ty->str && (SWIG_TypeEquiv(ty->str,name))) return ty;
    if (ty->name && (strcmp(name,ty->name) == 0)) return ty;
    ty = ty->prev;
  }
  return 0;
}

/* Set the clientdata field for a type */
SWIGRUNTIME(void)
SWIG_TypeClientData(swig_type_info *ti, void *clientdata) {
  swig_type_info *tc, *equiv;
  if (ti->clientdata == clientdata) return;
  ti->clientdata = clientdata;
  equiv = ti->next;
  while (equiv) {
    if (!equiv->converter) {
      tc = *swig_type_list_handle;
      while (tc) {
        if ((strcmp(tc->name, equiv->name) == 0))
          SWIG_TypeClientData(tc,clientdata);
        tc = tc->prev;
      }
    }
    equiv = equiv->next;
  }
}

/* Pack binary data into a string */
SWIGRUNTIME(char *)
SWIG_PackData(char *c, void *ptr, int sz) {
  static char hex[17] = "0123456789abcdef";
  unsigned char *u = (unsigned char *) ptr;
  const unsigned char *eu =  u + sz;
  register unsigned char uu;
  for (; u != eu; ++u) {
    uu = *u;
    *(c++) = hex[(uu & 0xf0) >> 4];
    *(c++) = hex[uu & 0xf];
  }
  return c;
}

/* Unpack binary data from a string */
SWIGRUNTIME(char *)
SWIG_UnpackData(char *c, void *ptr, int sz) {
  register unsigned char uu = 0;
  register int d;
  unsigned char *u = (unsigned char *) ptr;
  const unsigned char *eu =  u + sz;
  for (; u != eu; ++u) {
    d = *(c++);
    if ((d >= '0') && (d <= '9'))
      uu = ((d - '0') << 4);
    else if ((d >= 'a') && (d <= 'f'))
      uu = ((d - ('a'-10)) << 4);
    d = *(c++);
    if ((d >= '0') && (d <= '9'))
      uu |= (d - '0');
    else if ((d >= 'a') && (d <= 'f'))
      uu |= (d - ('a'-10));
    *u = uu;
  }
  return c;
}

#endif

#ifdef __cplusplus
}
#endif

/* rubydec.swg -*- c -*- */
#ifdef __cplusplus
extern "C" {
#endif

SWIGIMPORT(void)   SWIG_Ruby_InitRuntime(void);
SWIGIMPORT(void)   SWIG_Ruby_define_class(swig_type_info *);
SWIGIMPORT(VALUE)  SWIG_Ruby_NewPointerObj(void *, swig_type_info *, int);
SWIGIMPORT(VALUE)  SWIG_Ruby_NewClassInstance(VALUE, swig_type_info *);
SWIGIMPORT(char *) SWIG_Ruby_MangleStr(VALUE);
SWIGIMPORT(int)    SWIG_Ruby_ConvertPtr(VALUE, void**, swig_type_info *, int);
SWIGIMPORT(void *) SWIG_Ruby_MustGetPtr(VALUE, swig_type_info *, int, int);
SWIGIMPORT(int)    SWIG_Ruby_CheckConvert(VALUE, swig_type_info *);
SWIGIMPORT(VALUE)  SWIG_Ruby_NewPackedObj(void *ptr, int sz, swig_type_info *type);
SWIGIMPORT(void)   SWIG_Ruby_ConvertPacked(VALUE obj, void *ptr, int sz, swig_type_info *ty, int flags);

#ifdef __cplusplus
}
#endif


/* -------- TYPES TABLE (BEGIN) -------- */

#define  SWIGTYPE_p_FXDict swig_types[0] 
#define  SWIGTYPE_p_FXSettings swig_types[1] 
#define  SWIGTYPE_p_FXAccelTable swig_types[2] 
#define  SWIGTYPE_p_FXuchar swig_types[3] 
#define  SWIGTYPE_p_FXComposite swig_types[4] 
#define  SWIGTYPE_p_FXRegistry swig_types[5] 
#define  SWIGTYPE_p_FXId swig_types[6] 
#define  SWIGTYPE_p_FXIconDict swig_types[7] 
#define  SWIGTYPE_p_FXShell swig_types[8] 
#define  SWIGTYPE_p_FXPopup swig_types[9] 
#define  SWIGTYPE_p_FXTimer swig_types[10] 
#define  SWIGTYPE_p_FXRootWindow swig_types[11] 
#define  SWIGTYPE_p_FXWindow swig_types[12] 
#define  SWIGTYPE_p_FXTopWindow swig_types[13] 
#define  SWIGTYPE_p_void swig_types[14] 
#define  SWIGTYPE_p_FXDocument swig_types[15] 
#define  SWIGTYPE_p_FXRecentFiles swig_types[16] 
#define  SWIGTYPE_p_FXMainWindow swig_types[17] 
#define  SWIGTYPE_p_FXIcon swig_types[18] 
#define  SWIGTYPE_p_FXID swig_types[19] 
#define  SWIGTYPE_p_FXEvent swig_types[20] 
#define  SWIGTYPE_p_FXObject swig_types[21] 
#define  SWIGTYPE_p_FXStringDict swig_types[22] 
#define  SWIGTYPE_p_FXRectangle swig_types[23] 
#define  SWIGTYPE_p_FXString swig_types[24] 
#define  SWIGTYPE_p_FXPoint swig_types[25] 
#define  SWIGTYPE_p_FXFileDict swig_types[26] 
#define  SWIGTYPE_p_FXDebugTarget swig_types[27] 
#define  SWIGTYPE_p_FXDataTarget swig_types[28] 
#define  SWIGTYPE_p_FXDelegator swig_types[29] 
#define  SWIGTYPE_p_FXDrawable swig_types[30] 
#define  SWIGTYPE_p_FXCursor swig_types[31] 
#define  SWIGTYPE_p_FXCURCursor swig_types[32] 
#define  SWIGTYPE_p_FXGIFCursor swig_types[33] 
#define  SWIGTYPE_p_FXStream swig_types[34] 
#define  SWIGTYPE_p_FXFontDesc swig_types[35] 
#define  SWIGTYPE_p_FXApp swig_types[36] 
#define  SWIGTYPE_p_FXChore swig_types[37] 
#define  SWIGTYPE_p_FXRegion swig_types[38] 
#define  SWIGTYPE_p_FXColor swig_types[39] 
#define  SWIGTYPE_p_FXSize swig_types[40] 
#define  SWIGTYPE_p_p_FXchar swig_types[41] 
#define  SWIGTYPE_p_FXFont swig_types[42] 
#define  SWIGTYPE_p_FXchar swig_types[43] 
#define  SWIGTYPE_p_FXFrame swig_types[44] 
#define  SWIGTYPE_p_FXFileAssoc swig_types[45] 
#define  SWIGTYPE_p_FXVisual swig_types[46] 
#define  SWIGTYPE_p_FXuint swig_types[47] 
#define  SWIGTYPE_p_FXFileStream swig_types[48] 
#define  SWIGTYPE_p_FXMemoryStream swig_types[49] 
static swig_type_info *swig_types[51];

/* -------- TYPES TABLE (END) -------- */

#define SWIG_init    Init_core
#define SWIG_name    "Core"

VALUE mFox;

static void SWIG_AsVal(VALUE obj, int *val)
{
    *val = (int) NUM2INT(obj);
}


#include "FXRbCommon.h"


inline FXColor to_FXColor(VALUE obj){
  if(TYPE(obj)==T_STRING){
    return fxcolorfromname(StringValuePtr(obj));
    }
  else if(TYPE(obj)==T_SYMBOL){
    return fxcolorfromname(rb_id2name(SYM2ID(obj)));
    }
  else{
    return NUM2ULONG(obj);
    }
  }


inline FXString to_FXString(VALUE obj){
  if(!NIL_P(obj)){
    Check_Type(obj,T_STRING);
    return FXString(STR2CSTR(obj));
    }
  else{
    return FXString::null;
    }
  }


inline FXbool to_FXbool(VALUE obj){
  if (obj == Qtrue || obj == Qfalse){
    return (obj == Qtrue) ? TRUE : FALSE;
    }
  else{
    return static_cast<FXbool>(NUM2UINT(obj));
    }
  }


static swig_type_info* FXEventTypeInfo=0;

inline void* to_FXEvent(VALUE obj){
  void* ptr;
  if(!FXEventTypeInfo){
    FXEventTypeInfo=SWIG_TypeQuery("FXEvent *");
    FXASSERT(FXEventTypeInfo!=0);
    }
  SWIG_ConvertPtr(obj,&ptr,FXEventTypeInfo,1);
  return ptr;
  }


void setIgnoreExceptions(VALUE ignore){
  extern FXbool FXRbCatchExceptions;
  FXRbCatchExceptions=(ignore==Qtrue)? TRUE : FALSE;
  }


static FXuint _MKUINT(FXushort l,FXushort h){
  return MKUINT(l,h);
  }

static FXuint _FXSEL(FXushort type,FXushort id){
  return FXSEL(type,id);
  }
 
static FXushort _FXSELTYPE(FXuint s){
  return FXSELTYPE(s);
  }

static FXushort _FXSELID(FXuint s){
  return FXSELID(s);
  }


static FXuint _FXRGB(FXuchar r,FXuchar g,FXuchar b){
  return FXRGB(r,g,b);
  }

static FXuint _FXRGBA(FXuchar r,FXuchar g,FXuchar b,FXuchar a){
  return FXRGBA(r,g,b,a);
  }

static FXuchar _FXREDVAL(FXuint rgba){
  return FXREDVAL(rgba);
  }

static FXuchar _FXGREENVAL(FXuint rgba){
  return FXGREENVAL(rgba);
  }

static FXuchar _FXBLUEVAL(FXuint rgba){
  return FXBLUEVAL(rgba);
  }

static FXuchar _FXALPHAVAL(FXuint rgba){
  return FXALPHAVAL(rgba);
  }

static FXuchar _FXRGBACOMPVAL(FXuint rgba,FXuchar comp){
  return FXRGBACOMPVAL(rgba,comp);
  }


  /// Get name of (closest) color to RGB
  FXchar* fxnamefromcolor(FXColor color){
    static FXchar colorname[128]; // should be large enough, but still a buffer overflow risk!
    return fxnamefromcolor(colorname,color);
    }


/// Convert RGB to HSV
VALUE fxrgb_to_hsv(FXfloat r,FXfloat g,FXfloat b){
  FXfloat h,s,v;
  fxrgb_to_hsv(h,s,v,r,g,b);
  VALUE ary=rb_ary_new();
  rb_ary_push(ary,rb_float_new(h));
  rb_ary_push(ary,rb_float_new(s));
  rb_ary_push(ary,rb_float_new(v));
  return ary;
  }

/// Convert HSV to RGB
VALUE fxhsv_to_rgb(FXfloat h,FXfloat s,FXfloat v){
  FXfloat r,g,b;
  fxhsv_to_rgb(r,g,b,h,s,v);
  VALUE ary=rb_ary_new();
  rb_ary_push(ary,rb_float_new(r));
  rb_ary_push(ary,rb_float_new(g));
  rb_ary_push(ary,rb_float_new(b));
  return ary;
  }


VALUE fxparsegeometry(const FXchar *string){
  FXint x,y,w,h;
  FXint result=fxparsegeometry(string,x,y,w,h);
  VALUE ary=rb_ary_new();
  rb_ary_push(ary,INT2NUM(result));
  rb_ary_push(ary,INT2NUM(x));
  rb_ary_push(ary,INT2NUM(y));
  rb_ary_push(ary,INT2NUM(w));
  rb_ary_push(ary,INT2NUM(h));
  return ary;
  }


/// Version number that the library has been compiled with
VALUE _fxversion(){
  FXString version=FXStringFormat("%d.%d.%d",fxversion[0],fxversion[1],fxversion[2]);
  return rb_str_new2(version.text());
  }

FXStream *new_FXStream(FXObject const *cont){
      return new FXRbStream(cont);
      }

swig_class cFXStream;
static void free_FXStream(FXStream *);
FXFileStream *new_FXFileStream(FXObject const *cont){
      return new FXRbFileStream(cont);
      }

swig_class cFXFileStream;
static void free_FXFileStream(FXFileStream *);
FXMemoryStream *new_FXMemoryStream(FXObject const *cont){
      return new FXRbMemoryStream(cont);
      }
FXbool FXMemoryStream_open(FXMemoryStream *self,FXStreamDirection save_or_load,VALUE str){
      unsigned long size=0;
      FXuchar *data=0;
      if(!NIL_P(str)){
        size=RSTRING(str)->len;
        data=reinterpret_cast<FXuchar*>(STR2CSTR(str));
        return self->open(save_or_load,size,data);
        }
      else{
        return self->open(save_or_load,data);
        }
      }
VALUE FXMemoryStream_takeBuffer(FXMemoryStream *self){
      FXuchar* buffer;
      unsigned long sp;
      self->takeBuffer(buffer,sp);
      VALUE result=rb_str_new(const_cast<const char *>(reinterpret_cast<char*>(buffer)),sp);
      FXFREE(&buffer);
      return result;
      }
void FXMemoryStream_giveBuffer(FXMemoryStream *self,VALUE str){
      Check_Type(str,T_STRING);
      FXuchar* buffer=reinterpret_cast<FXuchar*>(StringValuePtr(str));
      unsigned long sp=RSTRING(str)->len;
      self->giveBuffer(buffer,sp);
      }

swig_class cFXMemoryStream;
static void free_FXMemoryStream(FXMemoryStream *);
FXbool FXSize_operator_Se__Se_(FXSize const *self,FXSize const &s){ return (*self == s); }
FXSize FXSize_operator_Sa_(FXSize const *self,FXSize const &s){ return *self + s; }
FXSize FXSize_operator_Ss_(FXSize const *self,FXSize const &s){ return *self - s; }
FXSize FXSize_operator_Sm_(FXSize const *self,FXshort c){ return *self * c; }
FXSize FXSize_operator_Sd_(FXSize const *self,FXshort c){ return *self / c; }

swig_class cFXSize;
FXbool FXPoint_operator_Se__Se_(FXPoint const *self,FXPoint const &p){ return *self == p; }
FXPoint FXPoint_operator_Sa___SWIG_0(FXPoint const *self,FXPoint const &p){ return *self + p; }
FXPoint FXPoint_operator_Sa___SWIG_1(FXPoint const *self,FXSize const &s){ return *self + s; }
FXPoint FXPoint_operator_Ss___SWIG_0(FXPoint const *self,FXPoint const &p){ return *self - p; }
FXPoint FXPoint_operator_Ss___SWIG_1(FXPoint const *self,FXSize const &s){ return *self - s; }
FXPoint FXPoint_operator_Sm_(FXPoint const *self,FXshort c){ return *self * c; }
FXPoint FXPoint_operator_Sd_(FXPoint const *self,FXshort c){ return *self / c; }

swig_class cFXPoint;
FXbool FXRectangle_operator_Se__Se_(FXRectangle const *self,FXRectangle const &p){
      return *self == p;
      }
FXbool FXRectangle_overlap(FXRectangle const *self,FXRectangle const &p){
      return overlap(*self,p);
      }
FXRectangle FXRectangle_operator_Sa_(FXRectangle const *self,FXRectangle const &p){
      return *self + p;
      }
FXRectangle FXRectangle_operator_Sm_(FXRectangle const *self,FXRectangle const &p){
      return *self * p;
      }

swig_class cFXRectangle;
FXRectangle FXRegion_bounds(FXRegion const *self){
      FXRectangle r;
      self->bounds(r);
      return r;
      }
FXRegion FXRegion_operator_Sa_(FXRegion const *self,FXRegion const &other){ return (*self)+other; }
FXRegion FXRegion_operator_Sm_(FXRegion const *self,FXRegion const &other){ return (*self)*other; }
FXRegion FXRegion_operator_Ss_(FXRegion const *self,FXRegion const &other){ return (*self)-other; }
FXRegion FXRegion_operator_Sx_(FXRegion const *self,FXRegion const &other){ return (*self)^other; }
FXbool FXRegion_operator_Se__Se_(FXRegion const *self,FXRegion const &other){ return (*self)==other; }

swig_class cFXRegion;
static void free_FXRegion(FXRegion *);
FXObject *new_FXObject(){
      return new FXRbObject();
      }

swig_class cFXObject;
static void free_FXObject(FXObject *);

static swig_type_info *FXObject_dynamic_cast(void **ptr) {
    FXObject **ppObject = reinterpret_cast<FXObject **>(ptr);
    FXAccelTable *pAccelTable=dynamic_cast<FXAccelTable*>(*ppObject);
    if(pAccelTable){
      *ptr=reinterpret_cast<void*>(pAccelTable);
      return SWIG_TypeQuery("FXAccelTable *");
      }
    FXApp *pApp=dynamic_cast<FXApp*>(*ppObject);
    if(pApp){
      *ptr=reinterpret_cast<void*>(pApp);
      return SWIG_TypeQuery("FXApp *");
      }
    FXDataTarget *pDataTarget=dynamic_cast<FXDataTarget*>(*ppObject);
    if(pDataTarget){
      *ptr=reinterpret_cast<void*>(pDataTarget);
      return SWIG_TypeQuery("FXDataTarget *");
      }
    FXDebugTarget *pDebugTarget=dynamic_cast<FXDebugTarget*>(*ppObject);
    if(pDebugTarget){
      *ptr=reinterpret_cast<void*>(pDebugTarget);
      return SWIG_TypeQuery("FXDebugTarget *");
      }
    FXDelegator *pDelegator=dynamic_cast<FXDelegator*>(*ppObject);
    if(pDelegator){
      *ptr=reinterpret_cast<void*>(pDelegator);
      return SWIG_TypeQuery("FXDelegator *");
      }
    FXDict *pDict=dynamic_cast<FXDict*>(*ppObject);
    if(pDict){
      *ptr=reinterpret_cast<void*>(pDict);
      return SWIG_TypeQuery("FXDict *");
      }
    FXDocument *pDocument=dynamic_cast<FXDocument*>(*ppObject);
    if(pDocument){
      *ptr=reinterpret_cast<void*>(pDocument);
      return SWIG_TypeQuery("FXDocument *");
      }
    FXGLObject *pGLObject=dynamic_cast<FXGLObject*>(*ppObject);
    if(pGLObject){
      *ptr=reinterpret_cast<void*>(pGLObject);
      return SWIG_TypeQuery("FXGLObject *");
      }
    FXHeaderItem *pHeaderItem=dynamic_cast<FXHeaderItem*>(*ppObject);
    if(pHeaderItem){
      *ptr=reinterpret_cast<void*>(pHeaderItem);
      return SWIG_TypeQuery("FXHeaderItem *");
      }
    FXIconItem *pIconItem=dynamic_cast<FXIconItem*>(*ppObject);
    if(pIconItem){
      *ptr=reinterpret_cast<void*>(pIconItem);
      return SWIG_TypeQuery("FXIconItem *");
      }
    FXId *pId=dynamic_cast<FXId*>(*ppObject);
    if(pId){
      *ptr=reinterpret_cast<void*>(pId);
      return SWIG_TypeQuery("FXId *");
      }
    FXListItem *pListItem=dynamic_cast<FXListItem*>(*ppObject);
    if(pListItem){
      *ptr=reinterpret_cast<void*>(pListItem);
      return SWIG_TypeQuery("FXListItem *");
      }
    FXRecentFiles *pRecentFiles=dynamic_cast<FXRecentFiles*>(*ppObject);
    if(pRecentFiles){
      *ptr=reinterpret_cast<void*>(pRecentFiles);
      return SWIG_TypeQuery("FXRecentFiles *");
      }
    FXTableItem *pTableItem=dynamic_cast<FXTableItem*>(*ppObject);
    if(pTableItem){
      *ptr=reinterpret_cast<void*>(pTableItem);
      return SWIG_TypeQuery("FXTableItem *");
      }
    FXTreeItem *pTreeItem=dynamic_cast<FXTreeItem*>(*ppObject);
    if(pTreeItem){
      *ptr=reinterpret_cast<void*>(pTreeItem);
      return SWIG_TypeQuery("FXTreeItem *");
      }
    return 0;
}

FXAccelTable *new_FXAccelTable(){
      return new FXRbAccelTable();
      }

swig_class cFXAccelTable;
static void free_FXAccelTable(FXAccelTable *);

swig_class cFXEvent;
static void free_FXEvent(FXEvent *);

swig_class cFXChore;

swig_class cFXTimer;
VALUE FXApp_copyright(){
      return rb_str_new2((const char *) FXApp::copyright);
    }
FXApp *new_FXApp(FXchar const *name,FXchar const *vendor){
      return FXRbApp::constructAndInit(name,vendor);
      }
unsigned long FXApp_getDisplay(FXApp const *self){
      return reinterpret_cast<unsigned long>(self->getDisplay());
      }
void FXApp_setDefaultVisual(FXApp *self,FXVisual *vis){
      FXASSERT(vis);
      if(vis->isMemberOf(FXMETACLASS(FXRbVisual))){
        dynamic_cast<FXRbVisual*>(vis)->ownedByApp=1;
        }
      else if(vis->isMemberOf(FXMETACLASS(FXRbGLVisual))){
        dynamic_cast<FXRbGLVisual*>(vis)->ownedByApp=1;
        }
      self->setDefaultVisual(vis);
      }
void FXApp_addSignal(FXApp *self,VALUE sigObj,FXObject *tgt,FXSelector sel,FXbool immediate,FXuint flags){
      const char *s;
      FXint sig;
      switch(TYPE(sigObj)){
        case T_STRING:
          s=STR2CSTR(sigObj);
          sig=FXRbSignalNameToNumber(s);
          if(sig==0) rb_raise(rb_eArgError,"unrecognized signal name `%s'",s);
          break;
        case T_FIXNUM:
          sig=(FXint)NUM2INT(sigObj);
          break;
        default:
          rb_raise(rb_eArgError,"bad signal type %s",rb_class2name(CLASS_OF(sigObj)));
          break;
        }
      self->addSignal(sig,tgt,sel,immediate,flags);
      }
void FXApp_removeSignal(FXApp *self,VALUE sigObj){
      const char *s;
      FXint sig;
      switch(TYPE(sigObj)){
        case T_STRING:
          s=STR2CSTR(sigObj);
          sig=FXRbSignalNameToNumber(s);
          if(sig==0) rb_raise(rb_eArgError,"unrecognized signal name `%s'",s);
          break;
        case T_FIXNUM:
          sig=(FXint)NUM2INT(sigObj);
          break;
        default:
          rb_raise(rb_eArgError,"bad signal type %s",rb_class2name(CLASS_OF(sigObj)));
          break;
        }
      self->removeSignal(sig);
      }
FXbool FXApp_addInput(FXApp *self,VALUE obj,FXuint mode,FXObject *tgt,FXSelector sel){
      FXInputHandle fd;
      FXuint m;
      if(mode&INPUT_READ){
        m=INPUT_READ;
	if(mode&INPUT_EXCEPT) m|=INPUT_EXCEPT;
        fd=FXRbGetReadFileHandle(obj);
	self->addInput(fd,m,tgt,sel);
        }
      if(mode&INPUT_WRITE){
        m=INPUT_WRITE;
	if(mode&INPUT_EXCEPT) m|=INPUT_EXCEPT;
        fd=FXRbGetWriteFileHandle(obj);
	self->addInput(fd,m,tgt,sel);
        }
      return 1;
      }
FXbool FXApp_removeInput(FXApp *self,VALUE obj,FXuint mode){
      FXInputHandle fd;
      FXuint m;
      if(mode&INPUT_READ){
        m=INPUT_READ;
	if(mode&INPUT_EXCEPT) m|=INPUT_EXCEPT;
        fd=FXRbGetReadFileHandle(obj);
	self->removeInput(fd,m);
        }
      if(mode&INPUT_WRITE){
        m=INPUT_WRITE;
	if(mode&INPUT_EXCEPT) m|=INPUT_EXCEPT;
        fd=FXRbGetWriteFileHandle(obj);
	self->removeInput(fd,m);
        }
      return 1;
      }
void FXApp_setNormalFont(FXApp *self,FXFont *font){
      FXASSERT(font);
      if(font->isMemberOf(FXMETACLASS(FXRbFont))){
        dynamic_cast<FXRbFont*>(font)->ownedByApp=1;
	}
      self->setNormalFont(font);
      }
void FXApp_setWaitCursor(FXApp *self,FXCursor *cur){
      FXASSERT(cur);
      if(cur->isMemberOf(FXMETACLASS(FXRbCursor))){
        dynamic_cast<FXRbCursor*>(cur)->ownedByApp=1;
	}
      else if(cur->isMemberOf(FXMETACLASS(FXRbCURCursor))){
        dynamic_cast<FXRbCURCursor*>(cur)->ownedByApp=1;
	}
      else if(cur->isMemberOf(FXMETACLASS(FXRbGIFCursor))){
        dynamic_cast<FXRbGIFCursor*>(cur)->ownedByApp=1;
	}
      self->setWaitCursor(cur);
      }
void FXApp_setDefaultCursor(FXApp *self,FXDefaultCursor which,FXCursor *cur){
      FXASSERT(cur);
      if(cur->isMemberOf(FXMETACLASS(FXRbCursor))){
        dynamic_cast<FXRbCursor*>(cur)->ownedByApp=1;
	}
      else if(cur->isMemberOf(FXMETACLASS(FXRbCURCursor))){
        dynamic_cast<FXRbCURCursor*>(cur)->ownedByApp=1;
	}
      else if(cur->isMemberOf(FXMETACLASS(FXRbGIFCursor))){
        dynamic_cast<FXRbGIFCursor*>(cur)->ownedByApp=1;
	}
      self->setDefaultCursor(which,cur);
      }
void FXApp_setThreadsEnabled(FXApp *self,FXbool enabled){
    FXASSERT(self->isMemberOf(FXMETACLASS(FXRbApp)));
    dynamic_cast<FXRbApp*>(self)->setThreadsEnabled(enabled);
    }
FXbool FXApp_threadsEnabled(FXApp const *self){
    FXASSERT(self->isMemberOf(FXMETACLASS(FXRbApp)));
    return dynamic_cast<const FXRbApp*>(self)->threadsEnabled();
    }
void FXApp_setSleepTime(FXApp *self,FXuint sleepTime){
    FXASSERT(self->isMemberOf(FXMETACLASS(FXRbApp)));
    dynamic_cast<FXRbApp*>(self)->setSleepTime(sleepTime);
    }
FXuint FXApp_getSleepTime(FXApp const *self){
    FXASSERT(self->isMemberOf(FXMETACLASS(FXRbApp)));
    return dynamic_cast<const FXRbApp*>(self)->getSleepTime();
    }

swig_class cFXApp;
static void free_FXApp(FXApp *);
FXDataTarget *new_FXDataTarget(VALUE value,FXObject *tgt,FXSelector sel){
      return new FXRbDataTarget(value,tgt,sel);
      }
VALUE FXDataTarget_getValue(FXDataTarget const *self){
      FXASSERT(self->isMemberOf(FXMETACLASS(FXRbDataTarget)));
      return dynamic_cast<const FXRbDataTarget*>(self)->getValue();
      }
void FXDataTarget_setValue(FXDataTarget *self,VALUE value){
      FXASSERT(self->isMemberOf(FXMETACLASS(FXRbDataTarget)));
      dynamic_cast<FXRbDataTarget*>(self)->setValue(value);
      }

swig_class cFXDataTarget;
static void free_FXDataTarget(FXDataTarget *);
VALUE FXDebugTarget_messageTypeName(){
          VALUE messageTypeNames = rb_ary_new();
          for (int i = 0; i < SEL_LAST; i++) {
              rb_ary_push(messageTypeNames,
                  to_ruby(FXDebugTarget::messageTypeName[i]));
          }
          return messageTypeNames;
      }
FXDebugTarget *new_FXDebugTarget(){
      return new FXRbDebugTarget();
      }

swig_class cFXDebugTarget;
FXDelegator *new_FXDelegator(FXObject *target){
      return new FXRbDelegator(target);
      }

swig_class cFXDelegator;
static void free_FXDelegator(FXDelegator *);
FXDict *new_FXDict(){
      return new FXRbDict();
      }
FXbool FXDict_has_key(FXDict const *self,FXchar const *ky){
      return (self->find(ky) != 0);
    }

swig_class cFXDict;
static void free_FXDict(FXDict *);

static swig_type_info *FXDict_dynamic_cast(void **ptr) {
    FXDict **ppDict = reinterpret_cast<FXDict **>(ptr);
    FXFileDict *pFileDict=dynamic_cast<FXFileDict*>(*ppDict);
    if(pFileDict){
      *ptr=reinterpret_cast<void*>(pFileDict);
      return SWIG_TypeQuery("FXFileDict *");
      }
    FXIconDict *pIconDict=dynamic_cast<FXIconDict*>(*ppDict);
    if(pIconDict){
      *ptr=reinterpret_cast<void*>(pIconDict);
      return SWIG_TypeQuery("FXIconDict *");
      }
    FXSettings *pSettings=dynamic_cast<FXSettings*>(*ppDict);
    if(pSettings){
      *ptr=reinterpret_cast<void*>(pSettings);
      return SWIG_TypeQuery("FXSettings *");
      }
    FXStringDict *pStringDict=dynamic_cast<FXStringDict*>(*ppDict);
    if(pStringDict){
      *ptr=reinterpret_cast<void*>(pStringDict);
      return SWIG_TypeQuery("FXStringDict *");
      }
    return 0;
}


swig_class cFXFileAssoc;
static void free_FXFileAssoc(FXFileAssoc *);
VALUE FXIconDict_defaultIconPath(){
      return rb_str_new2(FXIconDict::defaultIconPath);
      }
FXIconDict *new_FXIconDict(FXApp *a,FXString const &p){
      return new FXRbIconDict(a,p);
      }

swig_class cFXIconDict;
static void free_FXIconDict(FXIconDict *);
VALUE FXFileDict_defaultExecBinding(){
      return to_ruby(FXFileDict::defaultExecBinding);
      }
VALUE FXFileDict_defaultDirBinding(){
      return to_ruby(FXFileDict::defaultDirBinding);
      }
VALUE FXFileDict_defaultFileBinding(){
      return to_ruby(FXFileDict::defaultFileBinding);
      }
FXFileDict *new_FXFileDict__SWIG_0(FXApp *a){
      return new FXRbFileDict(a);
      }
FXFileDict *new_FXFileDict__SWIG_1(FXApp *a,FXSettings *db){
      return new FXRbFileDict(a,db);
      }

swig_class cFXFileDict;
static void free_FXFileDict(FXFileDict *);
FXStringDict *new_FXStringDict(){
      return new FXRbStringDict();
      }

swig_class cFXStringDict;
static void free_FXStringDict(FXStringDict *);
FXSettings *new_FXSettings(){
      return new FXRbSettings();
      }

swig_class cFXSettings;
static void free_FXSettings(FXSettings *);

static swig_type_info *FXSettings_dynamic_cast(void **ptr) {
    FXSettings **ppSettings = reinterpret_cast<FXSettings **>(ptr);
    FXRegistry *pRegistry=dynamic_cast<FXRegistry*>(*ppSettings);
    if(pRegistry){
      *ptr=reinterpret_cast<void*>(pRegistry);
      return SWIG_TypeQuery("FXRegistry *");
      }
    return 0;
}

FXRegistry *new_FXRegistry(FXString const &akey,FXString const &vkey){
      return new FXRbRegistry(akey,vkey);
      }

swig_class cFXRegistry;
static void free_FXRegistry(FXRegistry *);
FXDocument *new_FXDocument(){
      return new FXRbDocument();
      }

swig_class cFXDocument;
static void free_FXDocument(FXDocument *);
FXRecentFiles *new_FXRecentFiles__SWIG_0(){
      return new FXRbRecentFiles();
      }
FXRecentFiles *new_FXRecentFiles__SWIG_1(FXString const &gp,FXObject *tgt,FXSelector sel){
      return new FXRbRecentFiles(gp,tgt,sel);
      }

swig_class cFXRecentFiles;
static void free_FXRecentFiles(FXRecentFiles *);
bool FXId_created(FXId const *self){
      return self->id() != 0;
      }
void FXId_setUserData(FXId *self,VALUE ptr){
      self->setUserData(reinterpret_cast<void*>(ptr));
      }
VALUE FXId_getUserData(FXId const *self){
      return self->getUserData() ? reinterpret_cast<VALUE>(self->getUserData()) : Qnil;
      }

swig_class cFXId;
static void free_FXId(FXId *);

static swig_type_info *FXId_dynamic_cast(void **ptr) {
    FXId **ppId = reinterpret_cast<FXId **>(ptr);
    FXCursor *pCursor=dynamic_cast<FXCursor*>(*ppId);
    if(pCursor){
      *ptr=reinterpret_cast<void*>(pCursor);
      return SWIG_TypeQuery("FXCursor *");
      }
    FXDrawable *pDrawable=dynamic_cast<FXDrawable*>(*ppId);
    if(pDrawable){
      *ptr=reinterpret_cast<void*>(pDrawable);
      return SWIG_TypeQuery("FXDrawable *");
      }
    FXFont *pFont=dynamic_cast<FXFont*>(*ppId);
    if(pFont){
      *ptr=reinterpret_cast<void*>(pFont);
      return SWIG_TypeQuery("FXFont *");
      }
    FXGLContext *pGLContext=dynamic_cast<FXGLContext*>(*ppId);
    if(pGLContext){
      *ptr=reinterpret_cast<void*>(pGLContext);
      return SWIG_TypeQuery("FXGLContext *");
      }
    FXVisual *pVisual=dynamic_cast<FXVisual*>(*ppId);
    if(pVisual){
      *ptr=reinterpret_cast<void*>(pVisual);
      return SWIG_TypeQuery("FXVisual *");
      }
    return 0;
}

FXCursor *new_FXCursor__SWIG_0(FXApp *a,FXStockCursor curid){
      return new FXRbCursor(a,curid);
      }
FXCursor *new_FXCursor__SWIG_1(FXApp *a,FXuchar const *src,FXuchar const *msk,FXint w,FXint h,FXint hx,FXint hy){
      return new FXRbCursor(a,src,msk,w,h,hx,hy);
      }
FXCursor *new_FXCursor__SWIG_2(FXApp *a,FXColor const *pix,FXint w,FXint h,FXint hx,FXint hy){
      return new FXRbCursor(a,pix,w,h,hx,hy);
      }

swig_class cFXCursor;
static void free_FXCursor(FXCursor *);

static swig_type_info *FXCursor_dynamic_cast(void **ptr) {
    FXCursor **ppCursor = reinterpret_cast<FXCursor **>(ptr);
    FXCURCursor *pCURCursor=dynamic_cast<FXCURCursor*>(*ppCursor);
    if(pCURCursor){
      *ptr=reinterpret_cast<void*>(pCURCursor);
      return SWIG_TypeQuery("FXCURCursor *");
      }
    FXGIFCursor *pGIFCursor=dynamic_cast<FXGIFCursor*>(*ppCursor);
    if(pGIFCursor){
      *ptr=reinterpret_cast<void*>(pGIFCursor);
      return SWIG_TypeQuery("FXGIFCursor *");
      }
    return 0;
}

FXCURCursor *new_FXCURCursor(FXApp *a,void const *pix){
      return new FXRbCURCursor(a,pix);
      }

swig_class cFXCURCursor;
static void free_FXCURCursor(FXCURCursor *);
FXGIFCursor *new_FXGIFCursor(FXApp *a,void const *pix,FXint hx,FXint hy){
      return new FXRbGIFCursor(a,pix,hx,hy);
      }

swig_class cFXGIFCursor;
static void free_FXGIFCursor(FXGIFCursor *);

  /**
   * Load an GIF (Graphics Interchange Format) file from a stream.
   * Upon successful return, the pixel array and size are returned.
   * If an error occurred, the pixel array is set to NULL.
   */
  VALUE fxloadGIF(FXStream& store){
    FXColor* data;
    FXint width;
    FXint height;
    if(fxloadGIF(store,data,width,height)){
      VALUE ary=rb_ary_new();
      rb_ary_push(ary,FXRbMakeColorArray(data,width,height));
      FXFREE(&data);
      rb_ary_push(ary,to_ruby(width));
      rb_ary_push(ary,to_ruby(height));
      return ary;
      }
    else{
      return Qnil;
      }
    }

FXDrawable *new_FXDrawable(FXApp *a,FXint w,FXint h){
      return new FXRbDrawable(a,w,h);
      }

swig_class cFXDrawable;
static void free_FXDrawable(FXDrawable *);

static swig_type_info *FXDrawable_dynamic_cast(void **ptr) {
    FXDrawable **ppDrawable = reinterpret_cast<FXDrawable **>(ptr);
    FXBitmap *pBitmap=dynamic_cast<FXBitmap*>(*ppDrawable);
    if(pBitmap){
      *ptr=reinterpret_cast<void*>(pBitmap);
      return SWIG_TypeQuery("FXBitmap *");
      }
    FXImage *pImage=dynamic_cast<FXImage*>(*ppDrawable);
    if(pImage){
      *ptr=reinterpret_cast<void*>(pImage);
      return SWIG_TypeQuery("FXImage *");
      }
    FXWindow *pWindow=dynamic_cast<FXWindow*>(*ppDrawable);
    if(pWindow){
      *ptr=reinterpret_cast<void*>(pWindow);
      return SWIG_TypeQuery("FXWindow *");
      }
    return 0;
}

FXVisual *new_FXVisual(FXApp *a,FXuint flgs,FXuint d){
      return new FXRbVisual(a,flgs,d);
      }

swig_class cFXVisual;
static void free_FXVisual(FXVisual *);

static swig_type_info *FXVisual_dynamic_cast(void **ptr) {
    FXVisual **ppVisual = reinterpret_cast<FXVisual **>(ptr);
    FXGLVisual *pGLVisual=dynamic_cast<FXGLVisual*>(*ppVisual);
    if(pGLVisual){
      *ptr=reinterpret_cast<void*>(pGLVisual);
      return SWIG_TypeQuery("FXGLVisual *");
      }
    return 0;
}


swig_class cFXFontDesc;
static void free_FXFontDesc(FXFontDesc *);
FXFont *new_FXFont__SWIG_0(FXApp *a,FXString const &string){
      return new FXRbFont(a,string);
      }
FXFont *new_FXFont__SWIG_1(FXApp *a,FXString const &face,FXuint sz,FXuint wt,FXuint sl,FXuint enc,FXuint setw,FXuint h){
      return new FXRbFont(a,face,sz,wt,sl,enc,setw,h);
      }
FXFont *new_FXFont__SWIG_2(FXApp *a,FXFontDesc const &fontdesc){
      return new FXRbFont(a,fontdesc);
      }
FXFontDesc FXFont_getFontDesc(FXFont const *self){
      FXFontDesc fontdesc;
      self->getFontDesc(fontdesc);
      return fontdesc;
    }
FXbool FXFont_hasChar(FXFont const *self,VALUE ch){
      if(TYPE(ch)==T_STRING){
        if(RSTRING(ch)->len==1){
          return self->hasChar(*(STR2CSTR(ch)));
	  }
	else{
	  rb_raise(rb_eArgError,"expected a string of length one");
	  }
        }
      else{
        return self->hasChar(NUM2INT(ch));
        }
      }
FXint FXFont_getTextWidth(FXFont const *self,VALUE str){
      Check_Type(str,T_STRING);
      return self->getTextWidth(RSTRING(str)->ptr,RSTRING(str)->len);
      }
FXint FXFont_getTextHeight(FXFont const *self,VALUE str){
      Check_Type(str,T_STRING);
      return self->getTextHeight(RSTRING(str)->ptr,RSTRING(str)->len);
      }
VALUE FXFont_listFonts(FXString const &face,FXuint wt,FXuint sl,FXuint sw,FXuint en,FXuint h){
      FXFontDesc* fonts;
      FXuint numfonts;
      VALUE results = rb_ary_new();
      if (FXFont::listFonts(fonts, numfonts, face, wt, sl, sw, en, h)) {
        for (FXuint i = 0; i < numfonts; i++)
          rb_ary_push(results, to_ruby(new FXFontDesc(fonts[i])));
        FXFREE(&fonts);
      }
      return results;
    }

swig_class cFXFont;
static void free_FXFont(FXFont *);

/// Parse font description from a string
FXFontDesc* fxparsefontdesc2(const FXchar* string){
  FXFontDesc* fontdesc=new FXFontDesc;
  if(fxparsefontdesc(*fontdesc,string))
    return fontdesc;
  else{
    delete fontdesc;
    return 0;
    } 
  }

/// Unparse font description into a string
FXString fxunparsefontdesc2(const FXFontDesc& fontdesc){
  FXchar s[1024];
  if(fxunparsefontdesc(s,fontdesc))
    return FXString(s);
  else
    return FXString::null;
  }

VALUE FXWindow_deleteTypeName(){
      return to_ruby(FXWindow::deleteTypeName);
    }
VALUE FXWindow_textTypeName(){
      return to_ruby(FXWindow::textTypeName);
    }
VALUE FXWindow_colorTypeName(){
      return to_ruby(FXWindow::colorTypeName);
    }
VALUE FXWindow_urilistTypeName(){
      return to_ruby(FXWindow::urilistTypeName);
    }
FXWindow *new_FXWindow__SWIG_0(FXComposite *p,FXuint opts,FXint x,FXint y,FXint w,FXint h){
      return new FXRbWindow(p,opts,x,y,w,h);
      }
FXWindow *new_FXWindow__SWIG_1(FXApp *a,FXVisual *vis){
      return new FXRbWindow(a,vis);
      }
FXWindow *new_FXWindow__SWIG_2(FXApp *a,FXWindow *own,FXuint opts,FXint x,FXint y,FXint w,FXint h){
      return new FXRbWindow(a,own,opts,x,y,w,h);
      }
FXbool FXWindow_removeChild(FXWindow *self,FXWindow *child){
      if(self->containsChild(child)){
        delete child;
        return 1;
        }
      else{
        return 0;
        }
      }
VALUE FXWindow_getChildren(FXWindow const *self){
      VALUE ary=rb_ary_new();
      for(FXWindow* child=self->getFirst();child;child=child->getNext()){
        rb_ary_push(ary,FXRbGetRubyObj(child, "FXWindow *"));
        }
      return ary;
      }
VALUE FXWindow_getCursorPosition(FXWindow const *self){
      FXint x, y;
      FXuint buttons;
      self->getCursorPosition(x, y, buttons);
      VALUE arr = rb_ary_new();
      rb_ary_push(arr, INT2NUM(x));
      rb_ary_push(arr, INT2NUM(y));
      rb_ary_push(arr, UINT2NUM(buttons));
      return arr;
    }
FXbool FXWindow_acquireSelection(FXWindow *self,VALUE typesArray){
      Check_Type(typesArray,T_ARRAY);
      FXDragType *types=0;
      FXuint numtypes=RARRAY(typesArray)->len;
      if(numtypes>0){
        types=new FXDragType[numtypes];
        for(FXuint i=0;i<numtypes;i++){
          types[i]=(FXDragType) NUM2USHRT(rb_ary_entry(typesArray,i));
          }
      }
      FXbool result=self->acquireSelection(types,numtypes);
      delete [] types;
      return result;
      }
FXbool FXWindow_acquireClipboard(FXWindow *self,VALUE typesArray){
      Check_Type(typesArray,T_ARRAY);
      FXDragType *types=0;
      FXuint numtypes=RARRAY(typesArray)->len;
      if(numtypes>0){
        types=new FXDragType[numtypes];
        for(FXuint i=0;i<numtypes;i++){
          types[i]=(FXDragType) NUM2USHRT(rb_ary_entry(typesArray,i));
          }
      }
      FXbool result=self->acquireClipboard(types,numtypes);
      delete [] types;
      return result;
      }
FXbool FXWindow_beginDrag(FXWindow *self,VALUE typesArray){
      Check_Type(typesArray,T_ARRAY);
      FXDragType *types=0;
      FXuint numtypes=RARRAY(typesArray)->len;
      if(numtypes>0){
        types=new FXDragType[numtypes];
        for(FXuint i=0;i<numtypes;i++){
          types[i]=(FXDragType) NUM2USHRT(rb_ary_entry(typesArray,i));
          }
      }
      FXbool result=self->beginDrag(types,numtypes);
      delete [] types;
      return result;
      }
VALUE FXWindow_inquireDNDTypes(FXWindow const *self,FXDNDOrigin origin){
      FXDragType* types;
      FXuint numtypes;
      VALUE arr = rb_ary_new();
      if (self->inquireDNDTypes(origin, types, numtypes)) {
        for (FXuint i = 0; i < numtypes; i++)
          rb_ary_push(arr, to_ruby(types[i]));
        FXFREE(&types);
      }
      return arr;
    }
void FXWindow_setDNDData(FXWindow const *self,FXDNDOrigin origin,FXDragType type,VALUE str){
      Check_Type(str, T_STRING);
      FXuchar* data;
      FXuint size = RSTRING(str)->len;
      if (FXMALLOC(&data, FXuchar, size)) {
        memcpy((void *) data, (void *) RSTRING(str)->ptr, size);
        self->setDNDData(origin, type, data, size);
      } else {
        rb_raise(rb_eNoMemError, "couldn't copy drag-and-drop data");
      }
    }
VALUE FXWindow_getDNDData(FXWindow const *self,FXDNDOrigin origin,FXDragType type){
      FXuchar* data;
      FXuint size;
      VALUE result = Qnil;
      if (self->getDNDData(origin, type, data, size)) {
        result = rb_str_new((const FXchar *) data, size);
        FXFREE(&data);
      }
      return result;
    }
VALUE FXWindow_translateCoordinatesFrom(FXWindow const *self,FXWindow const *fromwindow,FXint fromx,FXint fromy){
      FXint tox, toy;
      self->translateCoordinatesFrom(tox, toy, fromwindow, fromx, fromy);
      VALUE result = rb_ary_new();
      rb_ary_push(result, INT2NUM(tox));
      rb_ary_push(result, INT2NUM(toy));
      return result;
    }
VALUE FXWindow_translateCoordinatesTo(FXWindow const *self,FXWindow const *towindow,FXint fromx,FXint fromy){
      FXint tox, toy;
      self->translateCoordinatesTo(tox, toy, towindow, fromx, fromy);
      VALUE result = rb_ary_new();
      rb_ary_push(result, INT2NUM(tox));
      rb_ary_push(result, INT2NUM(toy));
      return result;
    }

swig_class cFXWindow;
static void free_FXWindow(FXWindow *);

static swig_type_info *FXWindow_dynamic_cast(void **ptr) {
    FXWindow **ppWindow = reinterpret_cast<FXWindow **>(ptr);
    FXCanvas *pCanvas=dynamic_cast<FXCanvas*>(*ppWindow);
    if(pCanvas){
      *ptr=reinterpret_cast<void*>(pCanvas);
      return SWIG_TypeQuery("FXCanvas *");
      }
    FXComposite *pComposite=dynamic_cast<FXComposite*>(*ppWindow);
    if(pComposite){
      *ptr=reinterpret_cast<void*>(pComposite);
      return SWIG_TypeQuery("FXComposite *");
      }
    FXDragCorner *pDragCorner=dynamic_cast<FXDragCorner*>(*ppWindow);
    if(pDragCorner){
      *ptr=reinterpret_cast<void*>(pDragCorner);
      return SWIG_TypeQuery("FXDragCorner *");
      }
    FXFrame *pFrame=dynamic_cast<FXFrame*>(*ppWindow);
    if(pFrame){
      *ptr=reinterpret_cast<void*>(pFrame);
      return SWIG_TypeQuery("FXFrame *");
      }
    FXMenuCaption *pMenuCaption=dynamic_cast<FXMenuCaption*>(*ppWindow);
    if(pMenuCaption){
      *ptr=reinterpret_cast<void*>(pMenuCaption);
      return SWIG_TypeQuery("FXMenuCaption *");
      }
    FXMenuSeparator *pMenuSeparator=dynamic_cast<FXMenuSeparator*>(*ppWindow);
    if(pMenuSeparator){
      *ptr=reinterpret_cast<void*>(pMenuSeparator);
      return SWIG_TypeQuery("FXMenuSeparator *");
      }
    FXScrollBar *pScrollBar=dynamic_cast<FXScrollBar*>(*ppWindow);
    if(pScrollBar){
      *ptr=reinterpret_cast<void*>(pScrollBar);
      return SWIG_TypeQuery("FXScrollBar *");
      }
    FXScrollCorner *pScrollCorner=dynamic_cast<FXScrollCorner*>(*ppWindow);
    if(pScrollCorner){
      *ptr=reinterpret_cast<void*>(pScrollCorner);
      return SWIG_TypeQuery("FXScrollCorner *");
      }
    FXToolBarGrip *pToolBarGrip=dynamic_cast<FXToolBarGrip*>(*ppWindow);
    if(pToolBarGrip){
      *ptr=reinterpret_cast<void*>(pToolBarGrip);
      return SWIG_TypeQuery("FXToolBarGrip *");
      }
    return 0;
}

FXFrame *new_FXFrame(FXComposite *p,FXuint opts,FXint x,FXint y,FXint w,FXint h,FXint pl,FXint pr,FXint pt,FXint pb){
      return new FXRbFrame(p,opts,x,y,w,h,pl,pr,pt,pb);
      }

swig_class cFXFrame;
static void free_FXFrame(FXFrame *);

static swig_type_info *FXFrame_dynamic_cast(void **ptr) {
    FXFrame **ppFrame = reinterpret_cast<FXFrame **>(ptr);
    FXArrowButton *pArrowButton=dynamic_cast<FXArrowButton*>(*ppFrame);
    if(pArrowButton){
      *ptr=reinterpret_cast<void*>(pArrowButton);
      return SWIG_TypeQuery("FXArrowButton *");
      }
    FXBitmapFrame *pBitmapFrame=dynamic_cast<FXBitmapFrame*>(*ppFrame);
    if(pBitmapFrame){
      *ptr=reinterpret_cast<void*>(pBitmapFrame);
      return SWIG_TypeQuery("FXBitmapFrame *");
      }
    FXColorBar *pColorBar=dynamic_cast<FXColorBar*>(*ppFrame);
    if(pColorBar){
      *ptr=reinterpret_cast<void*>(pColorBar);
      return SWIG_TypeQuery("FXColorBar *");
      }
    FXColorWell *pColorWell=dynamic_cast<FXColorWell*>(*ppFrame);
    if(pColorWell){
      *ptr=reinterpret_cast<void*>(pColorWell);
      return SWIG_TypeQuery("FXColorWell *");
      }
    FXColorWheel *pColorWheel=dynamic_cast<FXColorWheel*>(*ppFrame);
    if(pColorWheel){
      *ptr=reinterpret_cast<void*>(pColorWheel);
      return SWIG_TypeQuery("FXColorWheel *");
      }
    FXDial *pDial=dynamic_cast<FXDial*>(*ppFrame);
    if(pDial){
      *ptr=reinterpret_cast<void*>(pDial);
      return SWIG_TypeQuery("FXDial *");
      }
    FXHeader *pHeader=dynamic_cast<FXHeader*>(*ppFrame);
    if(pHeader){
      *ptr=reinterpret_cast<void*>(pHeader);
      return SWIG_TypeQuery("FXHeader *");
      }
    FXHorizontalSeparator *pHorizontalSeparator=dynamic_cast<FXHorizontalSeparator*>(*ppFrame);
    if(pHorizontalSeparator){
      *ptr=reinterpret_cast<void*>(pHorizontalSeparator);
      return SWIG_TypeQuery("FXHorizontalSeparator *");
      }
    FXImageFrame *pImageFrame=dynamic_cast<FXImageFrame*>(*ppFrame);
    if(pImageFrame){
      *ptr=reinterpret_cast<void*>(pImageFrame);
      return SWIG_TypeQuery("FXImageFrame *");
      }
    FXLabel *pLabel=dynamic_cast<FXLabel*>(*ppFrame);
    if(pLabel){
      *ptr=reinterpret_cast<void*>(pLabel);
      return SWIG_TypeQuery("FXLabel *");
      }
    FXProgressBar *pProgressBar=dynamic_cast<FXProgressBar*>(*ppFrame);
    if(pProgressBar){
      *ptr=reinterpret_cast<void*>(pProgressBar);
      return SWIG_TypeQuery("FXProgressBar *");
      }
    FXRealSlider *pRealSlider=dynamic_cast<FXRealSlider*>(*ppFrame);
    if(pRealSlider){
      *ptr=reinterpret_cast<void*>(pRealSlider);
      return SWIG_TypeQuery("FXRealSlider *");
      }
    FXSlider *pSlider=dynamic_cast<FXSlider*>(*ppFrame);
    if(pSlider){
      *ptr=reinterpret_cast<void*>(pSlider);
      return SWIG_TypeQuery("FXSlider *");
      }
    FXStatusLine *pStatusLine=dynamic_cast<FXStatusLine*>(*ppFrame);
    if(pStatusLine){
      *ptr=reinterpret_cast<void*>(pStatusLine);
      return SWIG_TypeQuery("FXStatusLine *");
      }
    FXTextField *pTextField=dynamic_cast<FXTextField*>(*ppFrame);
    if(pTextField){
      *ptr=reinterpret_cast<void*>(pTextField);
      return SWIG_TypeQuery("FXTextField *");
      }
    FXToolBarTab *pToolBarTab=dynamic_cast<FXToolBarTab*>(*ppFrame);
    if(pToolBarTab){
      *ptr=reinterpret_cast<void*>(pToolBarTab);
      return SWIG_TypeQuery("FXToolBarTab *");
      }
    FXVerticalSeparator *pVerticalSeparator=dynamic_cast<FXVerticalSeparator*>(*ppFrame);
    if(pVerticalSeparator){
      *ptr=reinterpret_cast<void*>(pVerticalSeparator);
      return SWIG_TypeQuery("FXVerticalSeparator *");
      }
    return 0;
}

FXComposite *new_FXComposite(FXComposite *p,FXuint opts,FXint x,FXint y,FXint w,FXint h){
      return new FXRbComposite(p,opts,x,y,w,h);
      }

swig_class cFXComposite;
static void free_FXComposite(FXComposite *);

static swig_type_info *FXComposite_dynamic_cast(void **ptr) {
    FXComposite **ppComposite = reinterpret_cast<FXComposite **>(ptr);
    FX4Splitter *p4Splitter=dynamic_cast<FX4Splitter*>(*ppComposite);
    if(p4Splitter){
      *ptr=reinterpret_cast<void*>(p4Splitter);
      return SWIG_TypeQuery("FX4Splitter *");
      }
    FXMDIChild *pMDIChild=dynamic_cast<FXMDIChild*>(*ppComposite);
    if(pMDIChild){
      *ptr=reinterpret_cast<void*>(pMDIChild);
      return SWIG_TypeQuery("FXMDIChild *");
      }
    FXPacker *pPacker=dynamic_cast<FXPacker*>(*ppComposite);
    if(pPacker){
      *ptr=reinterpret_cast<void*>(pPacker);
      return SWIG_TypeQuery("FXPacker *");
      }
    FXRootWindow *pRootWindow=dynamic_cast<FXRootWindow*>(*ppComposite);
    if(pRootWindow){
      *ptr=reinterpret_cast<void*>(pRootWindow);
      return SWIG_TypeQuery("FXRootWindow *");
      }
    FXScrollArea *pScrollArea=dynamic_cast<FXScrollArea*>(*ppComposite);
    if(pScrollArea){
      *ptr=reinterpret_cast<void*>(pScrollArea);
      return SWIG_TypeQuery("FXScrollArea *");
      }
    FXShell *pShell=dynamic_cast<FXShell*>(*ppComposite);
    if(pShell){
      *ptr=reinterpret_cast<void*>(pShell);
      return SWIG_TypeQuery("FXShell *");
      }
    FXSplitter *pSplitter=dynamic_cast<FXSplitter*>(*ppComposite);
    if(pSplitter){
      *ptr=reinterpret_cast<void*>(pSplitter);
      return SWIG_TypeQuery("FXSplitter *");
      }
    return 0;
}

FXRootWindow *new_FXRootWindow(FXApp *a,FXVisual *vis){
      return new FXRbRootWindow(a,vis);
      }

swig_class cFXRootWindow;
static void free_FXRootWindow(FXRootWindow *);
FXShell *new_FXShell__SWIG_0(FXApp *a,FXuint opts,FXint x,FXint y,FXint w,FXint h){
      return new FXRbShell(a,opts,x,y,w,h);
      }
FXShell *new_FXShell__SWIG_1(FXWindow *own,FXuint opts,FXint x,FXint y,FXint w,FXint h){
      return new FXRbShell(own,opts,x,y,w,h);
      }

swig_class cFXShell;
static void free_FXShell(FXShell *);

static swig_type_info *FXShell_dynamic_cast(void **ptr) {
    FXShell **ppShell = reinterpret_cast<FXShell **>(ptr);
    FXPopup *pPopup=dynamic_cast<FXPopup*>(*ppShell);
    if(pPopup){
      *ptr=reinterpret_cast<void*>(pPopup);
      return SWIG_TypeQuery("FXPopup *");
      }
    FXToolTip *pToolTip=dynamic_cast<FXToolTip*>(*ppShell);
    if(pToolTip){
      *ptr=reinterpret_cast<void*>(pToolTip);
      return SWIG_TypeQuery("FXToolTip *");
      }
    FXTopWindow *pTopWindow=dynamic_cast<FXTopWindow*>(*ppShell);
    if(pTopWindow){
      *ptr=reinterpret_cast<void*>(pTopWindow);
      return SWIG_TypeQuery("FXTopWindow *");
      }
    return 0;
}

FXPopup *new_FXPopup(FXWindow *owner,FXuint opts,FXint x,FXint y,FXint w,FXint h){
      return new FXRbPopup(owner,opts,x,y,w,h);
      }

swig_class cFXPopup;
static void free_FXPopup(FXPopup *);

static swig_type_info *FXPopup_dynamic_cast(void **ptr) {
    FXPopup **ppPopup = reinterpret_cast<FXPopup **>(ptr);
    FXMenuPane *pMenuPane=dynamic_cast<FXMenuPane*>(*ppPopup);
    if(pMenuPane){
      *ptr=reinterpret_cast<void*>(pMenuPane);
      return SWIG_TypeQuery("FXMenuPane *");
      }
    return 0;
}

FXTopWindow *new_FXTopWindow__SWIG_0(FXApp *a,FXString const &name,FXIcon *ic,FXIcon *mi,FXuint opts,FXint x,FXint y,FXint w,FXint h,FXint pl,FXint pr,FXint pt,FXint pb,FXint hs,FXint vs){
      return new FXRbTopWindow(a,name,ic,mi,opts,x,y,w,h,pl,pr,pt,pb,hs,vs);
      }
FXTopWindow *new_FXTopWindow__SWIG_1(FXWindow *owner,FXString const &name,FXIcon *ic,FXIcon *mi,FXuint opts,FXint x,FXint y,FXint w,FXint h,FXint pl,FXint pr,FXint pt,FXint pb,FXint hs,FXint vs){
      return new FXRbTopWindow(owner,name,ic,mi,opts,x,y,w,h,pl,pr,pt,pb,hs,vs);
      }

swig_class cFXTopWindow;
static void free_FXTopWindow(FXTopWindow *);

static swig_type_info *FXTopWindow_dynamic_cast(void **ptr) {
    FXTopWindow **ppTopWindow = reinterpret_cast<FXTopWindow **>(ptr);
    FXDialogBox *pDialogBox=dynamic_cast<FXDialogBox*>(*ppTopWindow);
    if(pDialogBox){
      *ptr=reinterpret_cast<void*>(pDialogBox);
      return SWIG_TypeQuery("FXDialogBox *");
      }
    FXMainWindow *pMainWindow=dynamic_cast<FXMainWindow*>(*ppTopWindow);
    if(pMainWindow){
      *ptr=reinterpret_cast<void*>(pMainWindow);
      return SWIG_TypeQuery("FXMainWindow *");
      }
    FXToolBarShell *pToolBarShell=dynamic_cast<FXToolBarShell*>(*ppTopWindow);
    if(pToolBarShell){
      *ptr=reinterpret_cast<void*>(pToolBarShell);
      return SWIG_TypeQuery("FXToolBarShell *");
      }
    return 0;
}

FXMainWindow *new_FXMainWindow(FXApp *a,FXString const &name,FXIcon *ic,FXIcon *mi,FXuint opts,FXint x,FXint y,FXint w,FXint h,FXint pl,FXint pr,FXint pt,FXint pb,FXint hs,FXint vs){
      return new FXRbMainWindow(a,name,ic,mi,opts,x,y,w,h,pl,pr,pt,pb,hs,vs);
      }

swig_class cFXMainWindow;
static void free_FXMainWindow(FXMainWindow *);
static VALUE _wrap_setIgnoreExceptions(int argc, VALUE *argv, VALUE self) { VALUE arg1 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc); arg1 = argv[0]; setIgnoreExceptions(arg1); return Qnil; }
static VALUE _wrap_MKUINT(int argc, VALUE *argv, VALUE self) { FXushort arg1 ; FXushort arg2 ; FXuint result;
    VALUE vresult = Qnil; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    arg1 = NUM2USHRT(argv[0]); arg2 = NUM2USHRT(argv[1]); result = (FXuint)_MKUINT(arg1,arg2); vresult = UINT2NUM(result);
    return vresult; }
static VALUE _wrap_FXSEL(int argc, VALUE *argv, VALUE self) { FXushort arg1 ; FXushort arg2 ; FXuint result;
    VALUE vresult = Qnil; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    arg1 = NUM2USHRT(argv[0]); arg2 = NUM2USHRT(argv[1]); result = (FXuint)_FXSEL(arg1,arg2); vresult = UINT2NUM(result);
    return vresult; }
static VALUE _wrap_FXSELTYPE(int argc, VALUE *argv, VALUE self) { FXuint arg1 ; FXushort result; VALUE vresult = Qnil;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc); arg1 = NUM2UINT(argv[0]);
    result = (FXushort)_FXSELTYPE(arg1); vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXSELID(int argc, VALUE *argv, VALUE self) { FXuint arg1 ; FXushort result; VALUE vresult = Qnil;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc); arg1 = NUM2UINT(argv[0]);
    result = (FXushort)_FXSELID(arg1); vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXRGB(int argc, VALUE *argv, VALUE self) { FXuchar arg1 ; FXuchar arg2 ; FXuchar arg3 ; FXuint result;
    VALUE vresult = Qnil; if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    arg1 = (FXuchar) NUM2INT(argv[0]); arg2 = (FXuchar) NUM2INT(argv[1]); arg3 = (FXuchar) NUM2INT(argv[2]);
    result = (FXuint)_FXRGB(arg1,arg2,arg3); vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXRGBA(int argc, VALUE *argv, VALUE self) { FXuchar arg1 ; FXuchar arg2 ; FXuchar arg3 ; FXuchar arg4 ;
    FXuint result; VALUE vresult = Qnil; if ((argc < 4) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc); arg1 = (FXuchar) NUM2INT(argv[0]);
    arg2 = (FXuchar) NUM2INT(argv[1]); arg3 = (FXuchar) NUM2INT(argv[2]); arg4 = (FXuchar) NUM2INT(argv[3]);
    result = (FXuint)_FXRGBA(arg1,arg2,arg3,arg4); vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXREDVAL(int argc, VALUE *argv, VALUE self) { FXuint arg1 ; FXuchar result; VALUE vresult = Qnil;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc); arg1 = NUM2UINT(argv[0]);
    result = (FXuchar)_FXREDVAL(arg1); vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXGREENVAL(int argc, VALUE *argv, VALUE self) { FXuint arg1 ; FXuchar result; VALUE vresult = Qnil;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc); arg1 = NUM2UINT(argv[0]);
    result = (FXuchar)_FXGREENVAL(arg1); vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXBLUEVAL(int argc, VALUE *argv, VALUE self) { FXuint arg1 ; FXuchar result; VALUE vresult = Qnil;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc); arg1 = NUM2UINT(argv[0]);
    result = (FXuchar)_FXBLUEVAL(arg1); vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXALPHAVAL(int argc, VALUE *argv, VALUE self) { FXuint arg1 ; FXuchar result; VALUE vresult = Qnil;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc); arg1 = NUM2UINT(argv[0]);
    result = (FXuchar)_FXALPHAVAL(arg1); vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXRGBACOMPVAL(int argc, VALUE *argv, VALUE self) { FXuint arg1 ; FXuchar arg2 ; FXuchar result;
    VALUE vresult = Qnil; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    arg1 = NUM2UINT(argv[0]); arg2 = (FXuchar) NUM2INT(argv[1]); result = (FXuchar)_FXRGBACOMPVAL(arg1,arg2);
    vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_fxsleep(int argc, VALUE *argv, VALUE self) { unsigned int arg1 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc); arg1 = NUM2UINT(argv[0]); fxsleep(arg1); return Qnil; }
static VALUE _wrap_fxfilematch(int argc, VALUE *argv, VALUE self) { char *arg1 ; char *arg2 ;
    FXuint arg3 = (FXuint) (FILEMATCH_NOESCAPE|FILEMATCH_FILE_NAME) ; FXint result; VALUE vresult = Qnil;
    if ((argc < 2) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc); arg1 = StringValuePtr(argv[0]);
    arg2 = StringValuePtr(argv[1]); if (argc > 2) { arg3 = NUM2UINT(argv[2]); } 
    result = (FXint)fxfilematch((char const *)arg1,(char const *)arg2,arg3); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_makeHiliteColor(int argc, VALUE *argv, VALUE self) { FXColor arg1 ; FXColor result; VALUE vresult = Qnil;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc); arg1 = to_FXColor(argv[0]);
    result = (FXColor)makeHiliteColor(arg1); vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_makeShadowColor(int argc, VALUE *argv, VALUE self) { FXColor arg1 ; FXColor result; VALUE vresult = Qnil;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc); arg1 = to_FXColor(argv[0]);
    result = (FXColor)makeShadowColor(arg1); vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_fxcolorfromname(int argc, VALUE *argv, VALUE self) { FXchar *arg1 ; FXColor result; VALUE vresult = Qnil;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc); arg1 = StringValuePtr(argv[0]);
    result = (FXColor)fxcolorfromname((FXchar const *)arg1); vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_fxnamefromcolor(int argc, VALUE *argv, VALUE self) { FXColor arg1 ; FXchar *result; VALUE vresult = Qnil;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc); arg1 = to_FXColor(argv[0]);
    result = (FXchar *)fxnamefromcolor(arg1); vresult = rb_str_new2(result); return vresult; }
static VALUE _wrap_fxrgb_to_hsv(int argc, VALUE *argv, VALUE self) { FXfloat arg1 ; FXfloat arg2 ; FXfloat arg3 ; VALUE result;
    VALUE vresult = Qnil; if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    arg1 = (FXfloat) NUM2DBL(argv[0]); arg2 = (FXfloat) NUM2DBL(argv[1]); arg3 = (FXfloat) NUM2DBL(argv[2]);
    result = (VALUE)fxrgb_to_hsv(arg1,arg2,arg3); vresult = result; return vresult; }
static VALUE _wrap_fxhsv_to_rgb(int argc, VALUE *argv, VALUE self) { FXfloat arg1 ; FXfloat arg2 ; FXfloat arg3 ; VALUE result;
    VALUE vresult = Qnil; if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    arg1 = (FXfloat) NUM2DBL(argv[0]); arg2 = (FXfloat) NUM2DBL(argv[1]); arg3 = (FXfloat) NUM2DBL(argv[2]);
    result = (VALUE)fxhsv_to_rgb(arg1,arg2,arg3); vresult = result; return vresult; }
static VALUE _wrap_fxisconsole(int argc, VALUE *argv, VALUE self) { FXchar *arg1 ; FXbool result; VALUE vresult = Qnil;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc); arg1 = StringValuePtr(argv[0]);
    result = (FXbool)fxisconsole((FXchar const *)arg1); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_fxversion(int argc, VALUE *argv, VALUE self) { VALUE result; VALUE vresult = Qnil;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc); result = (VALUE)_fxversion();
    vresult = result; return vresult; }
static VALUE fxTraceLevel_get(VALUE self) { VALUE _val; _val = UINT2NUM(fxTraceLevel);    return _val; }
static VALUE fxTraceLevel_set(VALUE self, VALUE _val) { fxTraceLevel = NUM2UINT(_val); return _val; }
static VALUE _wrap_fxparseAccel(int argc, VALUE *argv, VALUE self) { FXString *arg1 = 0 ; FXHotKey result;
    SwigValueWrapper<FXString > p1 ; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc); p1 = to_FXString(argv[0]); arg1 = &p1;
    result = (FXHotKey)fxparseAccel((FXString const &)*arg1); vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_fxparseHotKey(int argc, VALUE *argv, VALUE self) { FXString *arg1 = 0 ; FXHotKey result;
    SwigValueWrapper<FXString > p1 ; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc); p1 = to_FXString(argv[0]); arg1 = &p1;
    result = (FXHotKey)fxparseHotKey((FXString const &)*arg1); vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_fxfindHotKey(int argc, VALUE *argv, VALUE self) { FXString *arg1 = 0 ; FXint result;
    SwigValueWrapper<FXString > p1 ; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc); p1 = to_FXString(argv[0]); arg1 = &p1;
    result = (FXint)fxfindHotKey((FXString const &)*arg1); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_fxstripHotKey(int argc, VALUE *argv, VALUE self) { FXString *arg1 = 0 ; FXString result;
    SwigValueWrapper<FXString > p1 ; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc); p1 = to_FXString(argv[0]); arg1 = &p1;
    result = fxstripHotKey((FXString const &)*arg1); vresult = rb_str_new2((&result)->text()); return vresult; }
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE _wrap_FXStream_allocate(VALUE self) {
#else
     static VALUE _wrap_FXStream_allocate(int argc, VALUE *argv, VALUE self) {
#endif
         VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_FXStream);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
         return vresult; }
static VALUE _wrap_new_FXStream(int argc, VALUE *argv, VALUE self) { FXObject *arg1 = (FXObject *) 0 ; FXStream *result;
    if ((argc < 0) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc); if (argc > 0) {
        SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXObject, 1); }  {
        result = (FXStream *)new_FXStream((FXObject const *)arg1); DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result);
        if(rb_block_given_p()){ rb_yield(self); }  }  return self; }
static VALUE _wrap_FXStream_open(int argc, VALUE *argv, VALUE self) { FXStream *arg1 = (FXStream *) 0 ; int arg2 ;
    unsigned long arg3 = (unsigned long) 8192 ; FXuchar *arg4 = (FXuchar *) 0 ; FXbool result; VALUE vresult = Qnil;
    if ((argc < 1) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXStream, 1); arg2 = (int) NUM2INT(argv[0]); if (argc > 1) {
        arg3 = NUM2ULONG(argv[1]); }  if (argc > 2) {
        arg4 = NIL_P(argv[2]) ? 0 : reinterpret_cast<FXuchar*>(STR2CSTR(argv[2])); } 
    result = (FXbool)(arg1)->open((FXStreamDirection )arg2,arg3,arg4); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXStream_getSpace(int argc, VALUE *argv, VALUE self) { FXStream *arg1 = (FXStream *) 0 ;
    unsigned long result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXStream, 1);
    result = (unsigned long)((FXStream const *)arg1)->getSpace(); vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXStream_setSpace(int argc, VALUE *argv, VALUE self) { FXStream *arg1 = (FXStream *) 0 ; unsigned long arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXStream, 1); arg2 = NUM2ULONG(argv[0]); (arg1)->setSpace(arg2);
    return Qnil; }
static VALUE _wrap_FXStream_status(int argc, VALUE *argv, VALUE self) { FXStream *arg1 = (FXStream *) 0 ; int result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXStream, 1); result = (int)((FXStream const *)arg1)->status();
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXStream_eofq___(int argc, VALUE *argv, VALUE self) { FXStream *arg1 = (FXStream *) 0 ; FXbool result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXStream, 1); result = (FXbool)((FXStream const *)arg1)->eof();
    vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXStream_setError(int argc, VALUE *argv, VALUE self) { FXStream *arg1 = (FXStream *) 0 ; int arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXStream, 1); arg2 = (int) NUM2INT(argv[0]);
    (arg1)->setError((FXStreamStatus )arg2); return Qnil; }
static VALUE _wrap_FXStream_direction(int argc, VALUE *argv, VALUE self) { FXStream *arg1 = (FXStream *) 0 ; int result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXStream, 1); result = (int)((FXStream const *)arg1)->direction();
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXStream_container(int argc, VALUE *argv, VALUE self) { FXStream *arg1 = (FXStream *) 0 ; FXObject *result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXStream, 1); result = (FXObject *)((FXStream const *)arg1)->container();
    { swig_type_info *ty = SWIG_TypeDynamicCast(SWIGTYPE_p_FXObject, (void **) &result); vresult = FXRbGetRubyObj(result, ty); }
     return vresult; }
static VALUE _wrap_FXStream_getPosition(int argc, VALUE *argv, VALUE self) { FXStream *arg1 = (FXStream *) 0 ;
    unsigned long result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXStream, 1);
    result = (unsigned long)((FXStream const *)arg1)->position(); vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXStream_swapBytes__SWIG_0(int argc, VALUE *argv, VALUE self) { FXStream *arg1 = (FXStream *) 0 ;
    FXbool arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXStream, 1); arg2 = to_FXbool(argv[0]); (arg1)->swapBytes(arg2);
    return Qnil; }
static VALUE _wrap_FXStream_swapBytes__SWIG_1(int argc, VALUE *argv, VALUE self) { FXStream *arg1 = (FXStream *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXStream, 1); result = (FXbool)((FXStream const *)arg1)->swapBytes();
    vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXStream_swapBytes(int nargs, VALUE *args, VALUE self) { int argc; VALUE argv[3]; int ii; argc = nargs + 1;
    argv[0] = self; for (ii = 1; (ii < argc) && (ii < 2); ii++) { argv[ii] = args[ii-1]; }  if (argc == 1) { int _v; {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXStream, 0) != -1)) ? 1 : 0; }
         if (_v) { return _wrap_FXStream_swapBytes__SWIG_1(nargs, args, self);}  }  if (argc == 2) { int _v; { void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXStream, 0) != -1)) ? 1 : 0; }
         if (_v) { { _v = (argv[1] == Qtrue || argv[1] == Qfalse) ? 1 : 0; }  if (_v) {
                return _wrap_FXStream_swapBytes__SWIG_0(nargs, args, self);}  }  } 
    rb_raise(rb_eArgError, "No matching function for overloaded 'FXStream_swapBytes'"); return Qnil; }
static VALUE _wrap_FXStream_isLittleEndian(int argc, VALUE *argv, VALUE self) { FXbool result; VALUE vresult = Qnil;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    result = (FXbool)FXStream::isLittleEndian(); vresult = result ? Qtrue : Qfalse; return vresult; }
static void
free_FXStream(FXStream *arg1) {
    delete arg1;
}
static VALUE _wrap_FXStream_close(int argc, VALUE *argv, VALUE self) { FXStream *arg1 = (FXStream *) 0 ; FXbool result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXStream, 1); result = (FXbool)FXStream_close(arg1);
    vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXStream_flush(int argc, VALUE *argv, VALUE self) { FXStream *arg1 = (FXStream *) 0 ; FXbool result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXStream, 1); result = (FXbool)FXStream_flush(arg1);
    vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXStream_setPosition(int argc, VALUE *argv, VALUE self) { FXStream *arg1 = (FXStream *) 0 ; long arg2 ;
    int arg3 = (int) FXFromStart ; FXbool result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXStream, 1); arg2 = NUM2LONG(argv[0]); if (argc > 1) {
        arg3 = (int) NUM2INT(argv[1]); }  result = (FXbool)FXStream_position(arg1,arg2,(FXWhence )arg3);
    vresult = result ? Qtrue : Qfalse; return vresult; }
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE _wrap_FXFileStream_allocate(VALUE self) {
#else
     static VALUE _wrap_FXFileStream_allocate(int argc, VALUE *argv, VALUE self) {
#endif
         VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_FXFileStream);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
         return vresult; }
static VALUE _wrap_new_FXFileStream(int argc, VALUE *argv, VALUE self) { FXObject *arg1 = (FXObject *) 0 ; FXFileStream *result;
    if ((argc < 0) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc); if (argc > 0) {
        SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXObject, 1); }  {
        result = (FXFileStream *)new_FXFileStream((FXObject const *)arg1);
        DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result); if(rb_block_given_p()){ rb_yield(self); }  }  return self; }
static VALUE _wrap_FXFileStream_open(int argc, VALUE *argv, VALUE self) { FXFileStream *arg1 = (FXFileStream *) 0 ;
    FXString *arg2 = 0 ; int arg3 ; unsigned long arg4 = (unsigned long) 8192 ; FXbool result; SwigValueWrapper<FXString > p2 ;
    VALUE vresult = Qnil; if ((argc < 2) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileStream, 1); p2 = to_FXString(argv[0]); arg2 = &p2;
    arg3 = (int) NUM2INT(argv[1]); if (argc > 2) { arg4 = NUM2ULONG(argv[2]); } 
    result = (FXbool)(arg1)->open((FXString const &)*arg2,(FXStreamDirection )arg3,arg4); vresult = result ? Qtrue : Qfalse;
    return vresult; }
static void
free_FXFileStream(FXFileStream *arg1) {
    delete arg1;
}
static VALUE _wrap_FXFileStream_close(int argc, VALUE *argv, VALUE self) { FXFileStream *arg1 = (FXFileStream *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileStream, 1); result = (FXbool)FXFileStream_close(arg1);
    vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXFileStream_flush(int argc, VALUE *argv, VALUE self) { FXFileStream *arg1 = (FXFileStream *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileStream, 1); result = (FXbool)FXFileStream_flush(arg1);
    vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXFileStream_setPosition(int argc, VALUE *argv, VALUE self) { FXFileStream *arg1 = (FXFileStream *) 0 ;
    long arg2 ; int arg3 = (int) FXFromStart ; FXbool result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileStream, 1); arg2 = NUM2LONG(argv[0]); if (argc > 1) {
        arg3 = (int) NUM2INT(argv[1]); }  result = (FXbool)FXFileStream_position(arg1,arg2,(FXWhence )arg3);
    vresult = result ? Qtrue : Qfalse; return vresult; }
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE _wrap_FXMemoryStream_allocate(VALUE self) {
#else
     static VALUE _wrap_FXMemoryStream_allocate(int argc, VALUE *argv, VALUE self) {
#endif
         VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_FXMemoryStream);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
         return vresult; }
static VALUE _wrap_new_FXMemoryStream(int argc, VALUE *argv, VALUE self) { FXObject *arg1 = (FXObject *) 0 ;
    FXMemoryStream *result; if ((argc < 0) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    if (argc > 0) { SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXObject, 1); }  {
        result = (FXMemoryStream *)new_FXMemoryStream((FXObject const *)arg1);
        DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result); if(rb_block_given_p()){ rb_yield(self); }  }  return self; }
static VALUE _wrap_FXMemoryStream_open(int argc, VALUE *argv, VALUE self) { FXMemoryStream *arg1 = (FXMemoryStream *) 0 ;
    int arg2 ; VALUE arg3 ; FXbool result; VALUE vresult = Qnil; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMemoryStream, 1); arg2 = (int) NUM2INT(argv[0]); arg3 = argv[1];
    result = (FXbool)FXMemoryStream_open(arg1,(FXStreamDirection )arg2,arg3); vresult = result ? Qtrue : Qfalse;
    return vresult; }
static VALUE _wrap_FXMemoryStream_takeBuffer(int argc, VALUE *argv, VALUE self) { FXMemoryStream *arg1 = (FXMemoryStream *) 0 ;
    VALUE result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMemoryStream, 1); result = (VALUE)FXMemoryStream_takeBuffer(arg1);
    vresult = result; return vresult; }
static VALUE _wrap_FXMemoryStream_giveBuffer(int argc, VALUE *argv, VALUE self) { FXMemoryStream *arg1 = (FXMemoryStream *) 0 ;
    VALUE arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMemoryStream, 1); arg2 = argv[0]; FXMemoryStream_giveBuffer(arg1,arg2);
    return Qnil; }
static void
free_FXMemoryStream(FXMemoryStream *arg1) {
    delete arg1;
}
static VALUE _wrap_FXSize_w_set(int argc, VALUE *argv, VALUE self) { FXSize *arg1 = (FXSize *) 0 ; FXshort arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSize, 1); arg2 = NUM2SHRT(argv[0]); if (arg1) (arg1)->w = arg2;
    return Qnil; }
static VALUE _wrap_FXSize_w_get(int argc, VALUE *argv, VALUE self) { FXSize *arg1 = (FXSize *) 0 ; FXshort result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSize, 1); result = (FXshort) ((arg1)->w); vresult = INT2NUM(result);
    return vresult; }
static VALUE _wrap_FXSize_h_set(int argc, VALUE *argv, VALUE self) { FXSize *arg1 = (FXSize *) 0 ; FXshort arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSize, 1); arg2 = NUM2SHRT(argv[0]); if (arg1) (arg1)->h = arg2;
    return Qnil; }
static VALUE _wrap_FXSize_h_get(int argc, VALUE *argv, VALUE self) { FXSize *arg1 = (FXSize *) 0 ; FXshort result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSize, 1); result = (FXshort) ((arg1)->h); vresult = INT2NUM(result);
    return vresult; }
static VALUE _wrap_new_FXSize__SWIG_0(int argc, VALUE *argv, VALUE self) { FXSize *result; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc); { result = (FXSize *)new FXSize();
        DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result); if(rb_block_given_p()){ rb_yield(self); }  }  return self; }
static VALUE _wrap_new_FXSize__SWIG_1(int argc, VALUE *argv, VALUE self) { FXSize *arg1 = 0 ; FXSize *result;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXSize, 1); if (arg1 == NULL) rb_raise(rb_eTypeError, "null reference");
    { result = (FXSize *)new FXSize((FXSize const &)*arg1); DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result);
        if(rb_block_given_p()){ rb_yield(self); }  }  return self; }
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE _wrap_FXSize_allocate(VALUE self) {
#else
     static VALUE _wrap_FXSize_allocate(int argc, VALUE *argv, VALUE self) {
#endif
         VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_FXSize);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
         return vresult; }
static VALUE _wrap_new_FXSize__SWIG_2(int argc, VALUE *argv, VALUE self) { FXshort arg1 ; FXshort arg2 ; FXSize *result;
    if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc); arg1 = NUM2SHRT(argv[0]);
    arg2 = NUM2SHRT(argv[1]); { result = (FXSize *)new FXSize(arg1,arg2);
        DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result); if(rb_block_given_p()){ rb_yield(self); }  }  return self; }
static VALUE _wrap_new_FXSize(int nargs, VALUE *args, VALUE self) { int argc; VALUE argv[2]; int ii; argc = nargs;
    for (ii = 0; (ii < argc) && (ii < 2); ii++) { argv[ii] = args[ii]; }  if (argc == 0) {
        return _wrap_new_FXSize__SWIG_0(nargs, args, self);}  if (argc == 1) { int _v; { void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXSize, 0) != -1)) ? 1 : 0; }
         if (_v) { return _wrap_new_FXSize__SWIG_1(nargs, args, self);}  }  if (argc == 2) { int _v; {
            _v = ((TYPE(argv[0]) == T_FIXNUM) || (TYPE(argv[0]) == T_BIGNUM)) ? 1 : 0; }  if (_v) { {
                _v = ((TYPE(argv[1]) == T_FIXNUM) || (TYPE(argv[1]) == T_BIGNUM)) ? 1 : 0; }  if (_v) {
                return _wrap_new_FXSize__SWIG_2(nargs, args, self);}  }  } 
    rb_raise(rb_eArgError, "No matching function for overloaded 'new_FXSize'"); return Qnil; }
static VALUE _wrap_FXSize___eq__(int argc, VALUE *argv, VALUE self) { FXSize *arg1 = (FXSize *) 0 ; FXSize *arg2 = 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc); SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSize, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXSize, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    result = (FXbool)FXSize_operator_Se__Se_((FXSize const *)arg1,(FXSize const &)*arg2); vresult = result ? Qtrue : Qfalse;
    return vresult; }
static VALUE _wrap_FXSize___neg__(int argc, VALUE *argv, VALUE self) { FXSize *arg1 = (FXSize *) 0 ; FXSize result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSize, 1); result = (arg1)->operator -(); { FXSize * resultptr;
        resultptr = new FXSize((FXSize &)result); vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_FXSize, 1); } 
    return vresult; }
static VALUE _wrap_FXSize___add__(int argc, VALUE *argv, VALUE self) { FXSize *arg1 = (FXSize *) 0 ; FXSize *arg2 = 0 ;
    FXSize result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc); SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSize, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXSize, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    result = FXSize_operator_Sa_((FXSize const *)arg1,(FXSize const &)*arg2); { FXSize * resultptr;
        resultptr = new FXSize((FXSize &)result); vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_FXSize, 1); } 
    return vresult; }
static VALUE _wrap_FXSize___sub__(int argc, VALUE *argv, VALUE self) { FXSize *arg1 = (FXSize *) 0 ; FXSize *arg2 = 0 ;
    FXSize result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc); SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSize, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXSize, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    result = FXSize_operator_Ss_((FXSize const *)arg1,(FXSize const &)*arg2); { FXSize * resultptr;
        resultptr = new FXSize((FXSize &)result); vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_FXSize, 1); } 
    return vresult; }
static VALUE _wrap_FXSize___mul__(int argc, VALUE *argv, VALUE self) { FXSize *arg1 = (FXSize *) 0 ; FXshort arg2 ;
    FXSize result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc); SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSize, 1);
    arg2 = NUM2SHRT(argv[0]); result = FXSize_operator_Sm_((FXSize const *)arg1,arg2); { FXSize * resultptr;
        resultptr = new FXSize((FXSize &)result); vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_FXSize, 1); } 
    return vresult; }
static VALUE _wrap_FXSize___div__(int argc, VALUE *argv, VALUE self) { FXSize *arg1 = (FXSize *) 0 ; FXshort arg2 ;
    FXSize result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc); SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSize, 1);
    arg2 = NUM2SHRT(argv[0]); result = FXSize_operator_Sd_((FXSize const *)arg1,arg2); { FXSize * resultptr;
        resultptr = new FXSize((FXSize &)result); vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_FXSize, 1); } 
    return vresult; }
static VALUE _wrap_FXPoint_x_set(int argc, VALUE *argv, VALUE self) { FXPoint *arg1 = (FXPoint *) 0 ; FXshort arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPoint, 1); arg2 = NUM2SHRT(argv[0]); if (arg1) (arg1)->x = arg2;
    return Qnil; }
static VALUE _wrap_FXPoint_x_get(int argc, VALUE *argv, VALUE self) { FXPoint *arg1 = (FXPoint *) 0 ; FXshort result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPoint, 1); result = (FXshort) ((arg1)->x); vresult = INT2NUM(result);
    return vresult; }
static VALUE _wrap_FXPoint_y_set(int argc, VALUE *argv, VALUE self) { FXPoint *arg1 = (FXPoint *) 0 ; FXshort arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPoint, 1); arg2 = NUM2SHRT(argv[0]); if (arg1) (arg1)->y = arg2;
    return Qnil; }
static VALUE _wrap_FXPoint_y_get(int argc, VALUE *argv, VALUE self) { FXPoint *arg1 = (FXPoint *) 0 ; FXshort result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPoint, 1); result = (FXshort) ((arg1)->y); vresult = INT2NUM(result);
    return vresult; }
static VALUE _wrap_new_FXPoint__SWIG_0(int argc, VALUE *argv, VALUE self) { FXPoint *result; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc); { result = (FXPoint *)new FXPoint();
        DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result); if(rb_block_given_p()){ rb_yield(self); }  }  return self; }
static VALUE _wrap_new_FXPoint__SWIG_1(int argc, VALUE *argv, VALUE self) { FXSize *arg1 = 0 ; FXPoint *result;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXSize, 1); if (arg1 == NULL) rb_raise(rb_eTypeError, "null reference");
    { result = (FXPoint *)new FXPoint((FXSize const &)*arg1); DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result);
        if(rb_block_given_p()){ rb_yield(self); }  }  return self; }
static VALUE _wrap_new_FXPoint__SWIG_2(int argc, VALUE *argv, VALUE self) { FXPoint *arg1 = 0 ; FXPoint *result;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXPoint, 1); if (arg1 == NULL) rb_raise(rb_eTypeError, "null reference");
    { result = (FXPoint *)new FXPoint((FXPoint const &)*arg1); DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result);
        if(rb_block_given_p()){ rb_yield(self); }  }  return self; }
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE _wrap_FXPoint_allocate(VALUE self) {
#else
     static VALUE _wrap_FXPoint_allocate(int argc, VALUE *argv, VALUE self) {
#endif
         VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_FXPoint);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
         return vresult; }
static VALUE _wrap_new_FXPoint__SWIG_3(int argc, VALUE *argv, VALUE self) { FXshort arg1 ; FXshort arg2 ; FXPoint *result;
    if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc); arg1 = NUM2SHRT(argv[0]);
    arg2 = NUM2SHRT(argv[1]); { result = (FXPoint *)new FXPoint(arg1,arg2);
        DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result); if(rb_block_given_p()){ rb_yield(self); }  }  return self; }
static VALUE _wrap_new_FXPoint(int nargs, VALUE *args, VALUE self) { int argc; VALUE argv[2]; int ii; argc = nargs;
    for (ii = 0; (ii < argc) && (ii < 2); ii++) { argv[ii] = args[ii]; }  if (argc == 0) {
        return _wrap_new_FXPoint__SWIG_0(nargs, args, self);}  if (argc == 1) { int _v; { void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXSize, 0) != -1)) ? 1 : 0; }
         if (_v) { return _wrap_new_FXPoint__SWIG_1(nargs, args, self);}  }  if (argc == 1) { int _v; { void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXPoint, 0) != -1)) ? 1 : 0; }
         if (_v) { return _wrap_new_FXPoint__SWIG_2(nargs, args, self);}  }  if (argc == 2) { int _v; {
            _v = ((TYPE(argv[0]) == T_FIXNUM) || (TYPE(argv[0]) == T_BIGNUM)) ? 1 : 0; }  if (_v) { {
                _v = ((TYPE(argv[1]) == T_FIXNUM) || (TYPE(argv[1]) == T_BIGNUM)) ? 1 : 0; }  if (_v) {
                return _wrap_new_FXPoint__SWIG_3(nargs, args, self);}  }  } 
    rb_raise(rb_eArgError, "No matching function for overloaded 'new_FXPoint'"); return Qnil; }
static VALUE _wrap_FXPoint___eq__(int argc, VALUE *argv, VALUE self) { FXPoint *arg1 = (FXPoint *) 0 ; FXPoint *arg2 = 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPoint, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXPoint, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    result = (FXbool)FXPoint_operator_Se__Se_((FXPoint const *)arg1,(FXPoint const &)*arg2); vresult = result ? Qtrue : Qfalse;
    return vresult; }
static VALUE _wrap_FXPoint___neg__(int argc, VALUE *argv, VALUE self) { FXPoint *arg1 = (FXPoint *) 0 ; FXPoint result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPoint, 1); result = (arg1)->operator -(); { FXPoint * resultptr;
        resultptr = new FXPoint((FXPoint &)result); vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_FXPoint, 1); } 
    return vresult; }
static VALUE _wrap_FXPoint___add____SWIG_0(int argc, VALUE *argv, VALUE self) { FXPoint *arg1 = (FXPoint *) 0 ;
    FXPoint *arg2 = 0 ; FXPoint result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPoint, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXPoint, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    result = FXPoint_operator_Sa___SWIG_0((FXPoint const *)arg1,(FXPoint const &)*arg2); { FXPoint * resultptr;
        resultptr = new FXPoint((FXPoint &)result); vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_FXPoint, 1); } 
    return vresult; }
static VALUE _wrap_FXPoint___add____SWIG_1(int argc, VALUE *argv, VALUE self) { FXPoint *arg1 = (FXPoint *) 0 ;
    FXSize *arg2 = 0 ; FXPoint result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPoint, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXSize, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    result = FXPoint_operator_Sa___SWIG_1((FXPoint const *)arg1,(FXSize const &)*arg2); { FXPoint * resultptr;
        resultptr = new FXPoint((FXPoint &)result); vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_FXPoint, 1); } 
    return vresult; }
static VALUE _wrap_FXPoint___add__(int nargs, VALUE *args, VALUE self) { int argc; VALUE argv[3]; int ii; argc = nargs + 1;
    argv[0] = self; for (ii = 1; (ii < argc) && (ii < 2); ii++) { argv[ii] = args[ii-1]; }  if (argc == 2) { int _v; {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXPoint, 0) != -1)) ? 1 : 0; }
         if (_v) { { void *ptr;
                _v = (NIL_P(argv[1]) || (TYPE(argv[1]) == T_DATA && SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_FXPoint, 0) != -1)) ? 1 : 0; }
             if (_v) { return _wrap_FXPoint___add____SWIG_0(nargs, args, self);}  }  }  if (argc == 2) { int _v; { void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXPoint, 0) != -1)) ? 1 : 0; }
         if (_v) { { void *ptr;
                _v = (NIL_P(argv[1]) || (TYPE(argv[1]) == T_DATA && SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_FXSize, 0) != -1)) ? 1 : 0; }
             if (_v) { return _wrap_FXPoint___add____SWIG_1(nargs, args, self);}  }  } 
    rb_raise(rb_eArgError, "No matching function for overloaded 'FXPoint___add__'"); return Qnil; }
static VALUE _wrap_FXPoint___sub____SWIG_0(int argc, VALUE *argv, VALUE self) { FXPoint *arg1 = (FXPoint *) 0 ;
    FXPoint *arg2 = 0 ; FXPoint result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPoint, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXPoint, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    result = FXPoint_operator_Ss___SWIG_0((FXPoint const *)arg1,(FXPoint const &)*arg2); { FXPoint * resultptr;
        resultptr = new FXPoint((FXPoint &)result); vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_FXPoint, 1); } 
    return vresult; }
static VALUE _wrap_FXPoint___sub____SWIG_1(int argc, VALUE *argv, VALUE self) { FXPoint *arg1 = (FXPoint *) 0 ;
    FXSize *arg2 = 0 ; FXPoint result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPoint, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXSize, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    result = FXPoint_operator_Ss___SWIG_1((FXPoint const *)arg1,(FXSize const &)*arg2); { FXPoint * resultptr;
        resultptr = new FXPoint((FXPoint &)result); vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_FXPoint, 1); } 
    return vresult; }
static VALUE _wrap_FXPoint___sub__(int nargs, VALUE *args, VALUE self) { int argc; VALUE argv[3]; int ii; argc = nargs + 1;
    argv[0] = self; for (ii = 1; (ii < argc) && (ii < 2); ii++) { argv[ii] = args[ii-1]; }  if (argc == 2) { int _v; {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXPoint, 0) != -1)) ? 1 : 0; }
         if (_v) { { void *ptr;
                _v = (NIL_P(argv[1]) || (TYPE(argv[1]) == T_DATA && SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_FXPoint, 0) != -1)) ? 1 : 0; }
             if (_v) { return _wrap_FXPoint___sub____SWIG_0(nargs, args, self);}  }  }  if (argc == 2) { int _v; { void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXPoint, 0) != -1)) ? 1 : 0; }
         if (_v) { { void *ptr;
                _v = (NIL_P(argv[1]) || (TYPE(argv[1]) == T_DATA && SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_FXSize, 0) != -1)) ? 1 : 0; }
             if (_v) { return _wrap_FXPoint___sub____SWIG_1(nargs, args, self);}  }  } 
    rb_raise(rb_eArgError, "No matching function for overloaded 'FXPoint___sub__'"); return Qnil; }
static VALUE _wrap_FXPoint___mul__(int argc, VALUE *argv, VALUE self) { FXPoint *arg1 = (FXPoint *) 0 ; FXshort arg2 ;
    FXPoint result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPoint, 1); arg2 = NUM2SHRT(argv[0]);
    result = FXPoint_operator_Sm_((FXPoint const *)arg1,arg2); { FXPoint * resultptr;
        resultptr = new FXPoint((FXPoint &)result); vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_FXPoint, 1); } 
    return vresult; }
static VALUE _wrap_FXPoint___div__(int argc, VALUE *argv, VALUE self) { FXPoint *arg1 = (FXPoint *) 0 ; FXshort arg2 ;
    FXPoint result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPoint, 1); arg2 = NUM2SHRT(argv[0]);
    result = FXPoint_operator_Sd_((FXPoint const *)arg1,arg2); { FXPoint * resultptr;
        resultptr = new FXPoint((FXPoint &)result); vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_FXPoint, 1); } 
    return vresult; }
static VALUE _wrap_FXRectangle_x_set(int argc, VALUE *argv, VALUE self) { FXRectangle *arg1 = (FXRectangle *) 0 ; FXshort arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRectangle, 1); arg2 = NUM2SHRT(argv[0]); if (arg1) (arg1)->x = arg2;
    return Qnil; }
static VALUE _wrap_FXRectangle_x_get(int argc, VALUE *argv, VALUE self) { FXRectangle *arg1 = (FXRectangle *) 0 ;
    FXshort result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRectangle, 1); result = (FXshort) ((arg1)->x);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXRectangle_y_set(int argc, VALUE *argv, VALUE self) { FXRectangle *arg1 = (FXRectangle *) 0 ; FXshort arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRectangle, 1); arg2 = NUM2SHRT(argv[0]); if (arg1) (arg1)->y = arg2;
    return Qnil; }
static VALUE _wrap_FXRectangle_y_get(int argc, VALUE *argv, VALUE self) { FXRectangle *arg1 = (FXRectangle *) 0 ;
    FXshort result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRectangle, 1); result = (FXshort) ((arg1)->y);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXRectangle_w_set(int argc, VALUE *argv, VALUE self) { FXRectangle *arg1 = (FXRectangle *) 0 ; FXshort arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRectangle, 1); arg2 = NUM2SHRT(argv[0]); if (arg1) (arg1)->w = arg2;
    return Qnil; }
static VALUE _wrap_FXRectangle_w_get(int argc, VALUE *argv, VALUE self) { FXRectangle *arg1 = (FXRectangle *) 0 ;
    FXshort result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRectangle, 1); result = (FXshort) ((arg1)->w);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXRectangle_h_set(int argc, VALUE *argv, VALUE self) { FXRectangle *arg1 = (FXRectangle *) 0 ; FXshort arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRectangle, 1); arg2 = NUM2SHRT(argv[0]); if (arg1) (arg1)->h = arg2;
    return Qnil; }
static VALUE _wrap_FXRectangle_h_get(int argc, VALUE *argv, VALUE self) { FXRectangle *arg1 = (FXRectangle *) 0 ;
    FXshort result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRectangle, 1); result = (FXshort) ((arg1)->h);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_new_FXRectangle__SWIG_0(int argc, VALUE *argv, VALUE self) { FXRectangle *result;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc); {
        result = (FXRectangle *)new FXRectangle(); DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result);
        if(rb_block_given_p()){ rb_yield(self); }  }  return self; }
static VALUE _wrap_new_FXRectangle__SWIG_1(int argc, VALUE *argv, VALUE self) { FXshort arg1 ; FXshort arg2 ; FXshort arg3 ;
    FXshort arg4 ; FXRectangle *result; if ((argc < 4) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc); arg1 = NUM2SHRT(argv[0]); arg2 = NUM2SHRT(argv[1]);
    arg3 = NUM2SHRT(argv[2]); arg4 = NUM2SHRT(argv[3]); { result = (FXRectangle *)new FXRectangle(arg1,arg2,arg3,arg4);
        DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result); if(rb_block_given_p()){ rb_yield(self); }  }  return self; }
static VALUE _wrap_new_FXRectangle__SWIG_2(int argc, VALUE *argv, VALUE self) { FXPoint *arg1 = 0 ; FXSize *arg2 = 0 ;
    FXRectangle *result; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXPoint, 1); if (arg1 == NULL) rb_raise(rb_eTypeError, "null reference");
    SWIG_ConvertPtr(argv[1], (void **) &arg2, SWIGTYPE_p_FXSize, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    { result = (FXRectangle *)new FXRectangle((FXPoint const &)*arg1,(FXSize const &)*arg2);
        DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result); if(rb_block_given_p()){ rb_yield(self); }  }  return self; }
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE _wrap_FXRectangle_allocate(VALUE self) {
#else
     static VALUE _wrap_FXRectangle_allocate(int argc, VALUE *argv, VALUE self) {
#endif
         VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_FXRectangle);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
         return vresult; }
static VALUE _wrap_new_FXRectangle__SWIG_3(int argc, VALUE *argv, VALUE self) { FXPoint *arg1 = 0 ; FXPoint *arg2 = 0 ;
    FXRectangle *result; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXPoint, 1); if (arg1 == NULL) rb_raise(rb_eTypeError, "null reference");
    SWIG_ConvertPtr(argv[1], (void **) &arg2, SWIGTYPE_p_FXPoint, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    { result = (FXRectangle *)new FXRectangle((FXPoint const &)*arg1,(FXPoint const &)*arg2);
        DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result); if(rb_block_given_p()){ rb_yield(self); }  }  return self; }
static VALUE _wrap_new_FXRectangle(int nargs, VALUE *args, VALUE self) { int argc; VALUE argv[4]; int ii; argc = nargs;
    for (ii = 0; (ii < argc) && (ii < 4); ii++) { argv[ii] = args[ii]; }  if (argc == 0) {
        return _wrap_new_FXRectangle__SWIG_0(nargs, args, self);}  if (argc == 2) { int _v; { void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXPoint, 0) != -1)) ? 1 : 0; }
         if (_v) { { void *ptr;
                _v = (NIL_P(argv[1]) || (TYPE(argv[1]) == T_DATA && SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_FXSize, 0) != -1)) ? 1 : 0; }
             if (_v) { return _wrap_new_FXRectangle__SWIG_2(nargs, args, self);}  }  }  if (argc == 2) { int _v; { void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXPoint, 0) != -1)) ? 1 : 0; }
         if (_v) { { void *ptr;
                _v = (NIL_P(argv[1]) || (TYPE(argv[1]) == T_DATA && SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_FXPoint, 0) != -1)) ? 1 : 0; }
             if (_v) { return _wrap_new_FXRectangle__SWIG_3(nargs, args, self);}  }  }  if (argc == 4) { int _v; {
            _v = ((TYPE(argv[0]) == T_FIXNUM) || (TYPE(argv[0]) == T_BIGNUM)) ? 1 : 0; }  if (_v) { {
                _v = ((TYPE(argv[1]) == T_FIXNUM) || (TYPE(argv[1]) == T_BIGNUM)) ? 1 : 0; }  if (_v) { {
                    _v = ((TYPE(argv[2]) == T_FIXNUM) || (TYPE(argv[2]) == T_BIGNUM)) ? 1 : 0; }  if (_v) { {
                        _v = ((TYPE(argv[3]) == T_FIXNUM) || (TYPE(argv[3]) == T_BIGNUM)) ? 1 : 0; }  if (_v) {
                        return _wrap_new_FXRectangle__SWIG_1(nargs, args, self);}  }  }  }  } 
    rb_raise(rb_eArgError, "No matching function for overloaded 'new_FXRectangle'"); return Qnil; }
static VALUE _wrap_FXRectangle___eq__(int argc, VALUE *argv, VALUE self) { FXRectangle *arg1 = (FXRectangle *) 0 ;
    FXRectangle *arg2 = 0 ; FXbool result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRectangle, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXRectangle, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    result = (FXbool)FXRectangle_operator_Se__Se_((FXRectangle const *)arg1,(FXRectangle const &)*arg2);
    vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXRectangle_containsq_____SWIG_0(int argc, VALUE *argv, VALUE self) { FXRectangle *arg1 = (FXRectangle *) 0 ;
    FXPoint *arg2 = 0 ; FXbool result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRectangle, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXPoint, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    result = (FXbool)((FXRectangle const *)arg1)->contains((FXPoint const &)*arg2); vresult = result ? Qtrue : Qfalse;
    return vresult; }
static VALUE _wrap_FXRectangle_containsq_____SWIG_1(int argc, VALUE *argv, VALUE self) { FXRectangle *arg1 = (FXRectangle *) 0 ;
    FXshort arg2 ; FXshort arg3 ; FXbool result; VALUE vresult = Qnil; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRectangle, 1); arg2 = NUM2SHRT(argv[0]); arg3 = NUM2SHRT(argv[1]);
    result = (FXbool)((FXRectangle const *)arg1)->contains(arg2,arg3); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXRectangle_containsq_____SWIG_2(int argc, VALUE *argv, VALUE self) { FXRectangle *arg1 = (FXRectangle *) 0 ;
    FXRectangle *arg2 = 0 ; FXbool result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRectangle, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXRectangle, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    result = (FXbool)((FXRectangle const *)arg1)->contains((FXRectangle const &)*arg2); vresult = result ? Qtrue : Qfalse;
    return vresult; }
static VALUE _wrap_FXRectangle_containsq___(int nargs, VALUE *args, VALUE self) { int argc; VALUE argv[4]; int ii;
    argc = nargs + 1; argv[0] = self; for (ii = 1; (ii < argc) && (ii < 3); ii++) { argv[ii] = args[ii-1]; }  if (argc == 2) {
        int _v; { void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXRectangle, 0) != -1)) ? 1 : 0; }
         if (_v) { { void *ptr;
                _v = (NIL_P(argv[1]) || (TYPE(argv[1]) == T_DATA && SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_FXPoint, 0) != -1)) ? 1 : 0; }
             if (_v) { return _wrap_FXRectangle_containsq_____SWIG_0(nargs, args, self);}  }  }  if (argc == 2) { int _v; {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXRectangle, 0) != -1)) ? 1 : 0; }
         if (_v) { { void *ptr;
                _v = (NIL_P(argv[1]) || (TYPE(argv[1]) == T_DATA && SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_FXRectangle, 0) != -1)) ? 1 : 0; }
             if (_v) { return _wrap_FXRectangle_containsq_____SWIG_2(nargs, args, self);}  }  }  if (argc == 3) { int _v; {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXRectangle, 0) != -1)) ? 1 : 0; }
         if (_v) { { _v = ((TYPE(argv[1]) == T_FIXNUM) || (TYPE(argv[1]) == T_BIGNUM)) ? 1 : 0; }  if (_v) { {
                    _v = ((TYPE(argv[2]) == T_FIXNUM) || (TYPE(argv[2]) == T_BIGNUM)) ? 1 : 0; }  if (_v) {
                    return _wrap_FXRectangle_containsq_____SWIG_1(nargs, args, self);}  }  }  } 
    rb_raise(rb_eArgError, "No matching function for overloaded 'FXRectangle_contains?'"); return Qnil; }
static VALUE _wrap_FXRectangle_overlapsq___(int argc, VALUE *argv, VALUE self) { FXRectangle *arg1 = (FXRectangle *) 0 ;
    FXRectangle *arg2 = 0 ; FXbool result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRectangle, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXRectangle, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    result = (FXbool)FXRectangle_overlap((FXRectangle const *)arg1,(FXRectangle const &)*arg2);
    vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXRectangle_moveN___(int argc, VALUE *argv, VALUE self) { FXRectangle *arg1 = (FXRectangle *) 0 ;
    FXshort arg2 ; FXshort arg3 ; FXRectangle *result; VALUE vresult = Qnil; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRectangle, 1); arg2 = NUM2SHRT(argv[0]); arg3 = NUM2SHRT(argv[1]); {
        FXRectangle &_result_ref = (arg1)->move(arg2,arg3); result = (FXRectangle *) &_result_ref; } 
    vresult = FXRbGetRubyObj(result, "FXRectangle *"); return vresult; }
static VALUE _wrap_FXRectangle_growN_____SWIG_0(int argc, VALUE *argv, VALUE self) { FXRectangle *arg1 = (FXRectangle *) 0 ;
    FXshort arg2 ; FXRectangle *result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRectangle, 1); arg2 = NUM2SHRT(argv[0]); {
        FXRectangle &_result_ref = (arg1)->grow(arg2); result = (FXRectangle *) &_result_ref; } 
    vresult = FXRbGetRubyObj(result, "FXRectangle *"); return vresult; }
static VALUE _wrap_FXRectangle_growN_____SWIG_1(int argc, VALUE *argv, VALUE self) { FXRectangle *arg1 = (FXRectangle *) 0 ;
    FXshort arg2 ; FXshort arg3 ; FXRectangle *result; VALUE vresult = Qnil; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRectangle, 1); arg2 = NUM2SHRT(argv[0]); arg3 = NUM2SHRT(argv[1]); {
        FXRectangle &_result_ref = (arg1)->grow(arg2,arg3); result = (FXRectangle *) &_result_ref; } 
    vresult = FXRbGetRubyObj(result, "FXRectangle *"); return vresult; }
static VALUE _wrap_FXRectangle_growN_____SWIG_2(int argc, VALUE *argv, VALUE self) { FXRectangle *arg1 = (FXRectangle *) 0 ;
    FXshort arg2 ; FXshort arg3 ; FXshort arg4 ; FXshort arg5 ; FXRectangle *result; VALUE vresult = Qnil;
    if ((argc < 4) || (argc > 4)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRectangle, 1); arg2 = NUM2SHRT(argv[0]); arg3 = NUM2SHRT(argv[1]);
    arg4 = NUM2SHRT(argv[2]); arg5 = NUM2SHRT(argv[3]); { FXRectangle &_result_ref = (arg1)->grow(arg2,arg3,arg4,arg5);
        result = (FXRectangle *) &_result_ref; }  vresult = FXRbGetRubyObj(result, "FXRectangle *"); return vresult; }
static VALUE _wrap_FXRectangle_growN___(int nargs, VALUE *args, VALUE self) { int argc; VALUE argv[6]; int ii; argc = nargs + 1;
    argv[0] = self; for (ii = 1; (ii < argc) && (ii < 5); ii++) { argv[ii] = args[ii-1]; }  if (argc == 2) { int _v; {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXRectangle, 0) != -1)) ? 1 : 0; }
         if (_v) { { _v = ((TYPE(argv[1]) == T_FIXNUM) || (TYPE(argv[1]) == T_BIGNUM)) ? 1 : 0; }  if (_v) {
                return _wrap_FXRectangle_growN_____SWIG_0(nargs, args, self);}  }  }  if (argc == 3) { int _v; { void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXRectangle, 0) != -1)) ? 1 : 0; }
         if (_v) { { _v = ((TYPE(argv[1]) == T_FIXNUM) || (TYPE(argv[1]) == T_BIGNUM)) ? 1 : 0; }  if (_v) { {
                    _v = ((TYPE(argv[2]) == T_FIXNUM) || (TYPE(argv[2]) == T_BIGNUM)) ? 1 : 0; }  if (_v) {
                    return _wrap_FXRectangle_growN_____SWIG_1(nargs, args, self);}  }  }  }  if (argc == 5) { int _v; {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXRectangle, 0) != -1)) ? 1 : 0; }
         if (_v) { { _v = ((TYPE(argv[1]) == T_FIXNUM) || (TYPE(argv[1]) == T_BIGNUM)) ? 1 : 0; }  if (_v) { {
                    _v = ((TYPE(argv[2]) == T_FIXNUM) || (TYPE(argv[2]) == T_BIGNUM)) ? 1 : 0; }  if (_v) { {
                        _v = ((TYPE(argv[3]) == T_FIXNUM) || (TYPE(argv[3]) == T_BIGNUM)) ? 1 : 0; }  if (_v) { {
                            _v = ((TYPE(argv[4]) == T_FIXNUM) || (TYPE(argv[4]) == T_BIGNUM)) ? 1 : 0; }  if (_v) {
                            return _wrap_FXRectangle_growN_____SWIG_2(nargs, args, self);}  }  }  }  }  } 
    rb_raise(rb_eArgError, "No matching function for overloaded 'FXRectangle_grow!'"); return Qnil; }
static VALUE _wrap_FXRectangle_shrinkN_____SWIG_0(int argc, VALUE *argv, VALUE self) { FXRectangle *arg1 = (FXRectangle *) 0 ;
    FXshort arg2 ; FXRectangle *result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRectangle, 1); arg2 = NUM2SHRT(argv[0]); {
        FXRectangle &_result_ref = (arg1)->shrink(arg2); result = (FXRectangle *) &_result_ref; } 
    vresult = FXRbGetRubyObj(result, "FXRectangle *"); return vresult; }
static VALUE _wrap_FXRectangle_shrinkN_____SWIG_1(int argc, VALUE *argv, VALUE self) { FXRectangle *arg1 = (FXRectangle *) 0 ;
    FXshort arg2 ; FXshort arg3 ; FXRectangle *result; VALUE vresult = Qnil; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRectangle, 1); arg2 = NUM2SHRT(argv[0]); arg3 = NUM2SHRT(argv[1]); {
        FXRectangle &_result_ref = (arg1)->shrink(arg2,arg3); result = (FXRectangle *) &_result_ref; } 
    vresult = FXRbGetRubyObj(result, "FXRectangle *"); return vresult; }
static VALUE _wrap_FXRectangle_shrinkN_____SWIG_2(int argc, VALUE *argv, VALUE self) { FXRectangle *arg1 = (FXRectangle *) 0 ;
    FXshort arg2 ; FXshort arg3 ; FXshort arg4 ; FXshort arg5 ; FXRectangle *result; VALUE vresult = Qnil;
    if ((argc < 4) || (argc > 4)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRectangle, 1); arg2 = NUM2SHRT(argv[0]); arg3 = NUM2SHRT(argv[1]);
    arg4 = NUM2SHRT(argv[2]); arg5 = NUM2SHRT(argv[3]); { FXRectangle &_result_ref = (arg1)->shrink(arg2,arg3,arg4,arg5);
        result = (FXRectangle *) &_result_ref; }  vresult = FXRbGetRubyObj(result, "FXRectangle *"); return vresult; }
static VALUE _wrap_FXRectangle_shrinkN___(int nargs, VALUE *args, VALUE self) { int argc; VALUE argv[6]; int ii;
    argc = nargs + 1; argv[0] = self; for (ii = 1; (ii < argc) && (ii < 5); ii++) { argv[ii] = args[ii-1]; }  if (argc == 2) {
        int _v; { void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXRectangle, 0) != -1)) ? 1 : 0; }
         if (_v) { { _v = ((TYPE(argv[1]) == T_FIXNUM) || (TYPE(argv[1]) == T_BIGNUM)) ? 1 : 0; }  if (_v) {
                return _wrap_FXRectangle_shrinkN_____SWIG_0(nargs, args, self);}  }  }  if (argc == 3) { int _v; { void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXRectangle, 0) != -1)) ? 1 : 0; }
         if (_v) { { _v = ((TYPE(argv[1]) == T_FIXNUM) || (TYPE(argv[1]) == T_BIGNUM)) ? 1 : 0; }  if (_v) { {
                    _v = ((TYPE(argv[2]) == T_FIXNUM) || (TYPE(argv[2]) == T_BIGNUM)) ? 1 : 0; }  if (_v) {
                    return _wrap_FXRectangle_shrinkN_____SWIG_1(nargs, args, self);}  }  }  }  if (argc == 5) { int _v; {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXRectangle, 0) != -1)) ? 1 : 0; }
         if (_v) { { _v = ((TYPE(argv[1]) == T_FIXNUM) || (TYPE(argv[1]) == T_BIGNUM)) ? 1 : 0; }  if (_v) { {
                    _v = ((TYPE(argv[2]) == T_FIXNUM) || (TYPE(argv[2]) == T_BIGNUM)) ? 1 : 0; }  if (_v) { {
                        _v = ((TYPE(argv[3]) == T_FIXNUM) || (TYPE(argv[3]) == T_BIGNUM)) ? 1 : 0; }  if (_v) { {
                            _v = ((TYPE(argv[4]) == T_FIXNUM) || (TYPE(argv[4]) == T_BIGNUM)) ? 1 : 0; }  if (_v) {
                            return _wrap_FXRectangle_shrinkN_____SWIG_2(nargs, args, self);}  }  }  }  }  } 
    rb_raise(rb_eArgError, "No matching function for overloaded 'FXRectangle_shrink!'"); return Qnil; }
static VALUE _wrap_FXRectangle_tl(int argc, VALUE *argv, VALUE self) { FXRectangle *arg1 = (FXRectangle *) 0 ; FXPoint result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRectangle, 1); result = ((FXRectangle const *)arg1)->tl(); {
        FXPoint * resultptr; resultptr = new FXPoint((FXPoint &)result);
        vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_FXPoint, 1); }  return vresult; }
static VALUE _wrap_FXRectangle_tr(int argc, VALUE *argv, VALUE self) { FXRectangle *arg1 = (FXRectangle *) 0 ; FXPoint result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRectangle, 1); result = ((FXRectangle const *)arg1)->tr(); {
        FXPoint * resultptr; resultptr = new FXPoint((FXPoint &)result);
        vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_FXPoint, 1); }  return vresult; }
static VALUE _wrap_FXRectangle_bl(int argc, VALUE *argv, VALUE self) { FXRectangle *arg1 = (FXRectangle *) 0 ; FXPoint result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRectangle, 1); result = ((FXRectangle const *)arg1)->bl(); {
        FXPoint * resultptr; resultptr = new FXPoint((FXPoint &)result);
        vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_FXPoint, 1); }  return vresult; }
static VALUE _wrap_FXRectangle_br(int argc, VALUE *argv, VALUE self) { FXRectangle *arg1 = (FXRectangle *) 0 ; FXPoint result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRectangle, 1); result = ((FXRectangle const *)arg1)->br(); {
        FXPoint * resultptr; resultptr = new FXPoint((FXPoint &)result);
        vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_FXPoint, 1); }  return vresult; }
static VALUE _wrap_FXRectangle___add__(int argc, VALUE *argv, VALUE self) { FXRectangle *arg1 = (FXRectangle *) 0 ;
    FXRectangle *arg2 = 0 ; FXRectangle result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRectangle, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXRectangle, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    result = FXRectangle_operator_Sa_((FXRectangle const *)arg1,(FXRectangle const &)*arg2); {
        FXRectangle* resultptr = new FXRectangle(result); vresult = FXRbGetRubyObj(resultptr, "FXRectangle *"); } 
    return vresult; }
static VALUE _wrap_FXRectangle___mul__(int argc, VALUE *argv, VALUE self) { FXRectangle *arg1 = (FXRectangle *) 0 ;
    FXRectangle *arg2 = 0 ; FXRectangle result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRectangle, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXRectangle, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    result = FXRectangle_operator_Sm_((FXRectangle const *)arg1,(FXRectangle const &)*arg2); {
        FXRectangle* resultptr = new FXRectangle(result); vresult = FXRbGetRubyObj(resultptr, "FXRectangle *"); } 
    return vresult; }
static VALUE _wrap_new_FXRegion__SWIG_0(int argc, VALUE *argv, VALUE self) { FXRegion *result; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc); { result = (FXRegion *)new FXRegion();
        DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result); if(rb_block_given_p()){ rb_yield(self); }  }  return self; }
static VALUE _wrap_new_FXRegion__SWIG_1(int argc, VALUE *argv, VALUE self) { FXRegion *arg1 = 0 ; FXRegion *result;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXRegion, 1); if (arg1 == NULL) rb_raise(rb_eTypeError, "null reference");
    { result = (FXRegion *)new FXRegion((FXRegion const &)*arg1); DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result);
        if(rb_block_given_p()){ rb_yield(self); }  }  return self; }
static VALUE _wrap_new_FXRegion__SWIG_2(int argc, VALUE *argv, VALUE self) { FXRectangle *arg1 = 0 ; FXRegion *result;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXRectangle, 1); if (arg1 == NULL) rb_raise(rb_eTypeError, "null reference");
    { result = (FXRegion *)new FXRegion((FXRectangle const &)*arg1); DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result);
        if(rb_block_given_p()){ rb_yield(self); }  }  return self; }
static VALUE _wrap_new_FXRegion__SWIG_3(int argc, VALUE *argv, VALUE self) { FXint arg1 ; FXint arg2 ; FXint arg3 ; FXint arg4 ;
    FXRegion *result; if ((argc < 4) || (argc > 4)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    arg1 = NUM2INT(argv[0]); arg2 = NUM2INT(argv[1]); arg3 = NUM2INT(argv[2]); arg4 = NUM2INT(argv[3]); {
        result = (FXRegion *)new FXRegion(arg1,arg2,arg3,arg4); DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result);
        if(rb_block_given_p()){ rb_yield(self); }  }  return self; }
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE _wrap_FXRegion_allocate(VALUE self) {
#else
     static VALUE _wrap_FXRegion_allocate(int argc, VALUE *argv, VALUE self) {
#endif
         VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_FXRegion);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
         return vresult; }
static VALUE _wrap_new_FXRegion__SWIG_4(int argc, VALUE *argv, VALUE self) { FXPoint *arg1 = (FXPoint *) 0 ; FXuint arg2 ;
    FXbool arg3 = (FXbool) 0 ; FXRegion *result; if ((argc < 1) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc); { Check_Type(argv[0], T_ARRAY);
        arg1 = new FXPoint[RARRAY(argv[0])->len]; arg2 = static_cast<FXuint>( RARRAY(argv[0])->len );
        for (FXuint i = 0; i < arg2; i++) { FXPoint *pPoint; Data_Get_Struct(rb_ary_entry(argv[0], i), FXPoint, pPoint);
            arg1[i] = *pPoint; }  }  if (argc > 1) { arg3 = to_FXbool(argv[1]); }  {
        result = (FXRegion *)new FXRegion((FXPoint const *)arg1,arg2,arg3);
        DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result); if(rb_block_given_p()){ rb_yield(self); }  }  {
        delete [] arg1; }  return self; }
static VALUE _wrap_new_FXRegion(int nargs, VALUE *args, VALUE self) { int argc; VALUE argv[4]; int ii; argc = nargs;
    for (ii = 0; (ii < argc) && (ii < 4); ii++) { argv[ii] = args[ii]; }  if (argc == 0) {
        return _wrap_new_FXRegion__SWIG_0(nargs, args, self);}  if (argc == 1) { int _v; { void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXRegion, 0) != -1)) ? 1 : 0; }
         if (_v) { return _wrap_new_FXRegion__SWIG_1(nargs, args, self);}  }  if (argc == 1) { int _v; { void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXRectangle, 0) != -1)) ? 1 : 0; }
         if (_v) { return _wrap_new_FXRegion__SWIG_2(nargs, args, self);}  }  if ((argc >= 1) && (argc <= 2)) { int _v; {
            _v = (TYPE(argv[0]) == T_ARRAY) ? 1 : 0; }  if (_v) { if (argc <= 1) {
                return _wrap_new_FXRegion__SWIG_4(nargs, args, self);}  { _v = (argv[1] == Qtrue || argv[1] == Qfalse) ? 1 : 0; }
             if (_v) { return _wrap_new_FXRegion__SWIG_4(nargs, args, self);}  }  }  if (argc == 4) { int _v; {
            _v = ((TYPE(argv[0]) == T_FIXNUM) || (TYPE(argv[0]) == T_BIGNUM)) ? 1 : 0; }  if (_v) { {
                _v = ((TYPE(argv[1]) == T_FIXNUM) || (TYPE(argv[1]) == T_BIGNUM)) ? 1 : 0; }  if (_v) { {
                    _v = ((TYPE(argv[2]) == T_FIXNUM) || (TYPE(argv[2]) == T_BIGNUM)) ? 1 : 0; }  if (_v) { {
                        _v = ((TYPE(argv[3]) == T_FIXNUM) || (TYPE(argv[3]) == T_BIGNUM)) ? 1 : 0; }  if (_v) {
                        return _wrap_new_FXRegion__SWIG_3(nargs, args, self);}  }  }  }  } 
    rb_raise(rb_eArgError, "No matching function for overloaded 'new_FXRegion'"); return Qnil; }
static VALUE _wrap_FXRegion_emptyq___(int argc, VALUE *argv, VALUE self) { FXRegion *arg1 = (FXRegion *) 0 ; FXbool result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRegion, 1); result = (FXbool)((FXRegion const *)arg1)->empty();
    vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXRegion_containsq_____SWIG_0(int argc, VALUE *argv, VALUE self) { FXRegion *arg1 = (FXRegion *) 0 ;
    FXint arg2 ; FXint arg3 ; FXbool result; VALUE vresult = Qnil; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRegion, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    result = (FXbool)((FXRegion const *)arg1)->contains(arg2,arg3); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXRegion_containsq_____SWIG_1(int argc, VALUE *argv, VALUE self) { FXRegion *arg1 = (FXRegion *) 0 ;
    FXint arg2 ; FXint arg3 ; FXint arg4 ; FXint arg5 ; FXbool result; VALUE vresult = Qnil; if ((argc < 4) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRegion, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    arg4 = NUM2INT(argv[2]); arg5 = NUM2INT(argv[3]); result = (FXbool)((FXRegion const *)arg1)->contains(arg2,arg3,arg4,arg5);
    vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXRegion_containsq___(int nargs, VALUE *args, VALUE self) { int argc; VALUE argv[6]; int ii;
    argc = nargs + 1; argv[0] = self; for (ii = 1; (ii < argc) && (ii < 5); ii++) { argv[ii] = args[ii-1]; }  if (argc == 3) {
        int _v; { void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXRegion, 0) != -1)) ? 1 : 0; }
         if (_v) { { _v = ((TYPE(argv[1]) == T_FIXNUM) || (TYPE(argv[1]) == T_BIGNUM)) ? 1 : 0; }  if (_v) { {
                    _v = ((TYPE(argv[2]) == T_FIXNUM) || (TYPE(argv[2]) == T_BIGNUM)) ? 1 : 0; }  if (_v) {
                    return _wrap_FXRegion_containsq_____SWIG_0(nargs, args, self);}  }  }  }  if (argc == 5) { int _v; {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXRegion, 0) != -1)) ? 1 : 0; }
         if (_v) { { _v = ((TYPE(argv[1]) == T_FIXNUM) || (TYPE(argv[1]) == T_BIGNUM)) ? 1 : 0; }  if (_v) { {
                    _v = ((TYPE(argv[2]) == T_FIXNUM) || (TYPE(argv[2]) == T_BIGNUM)) ? 1 : 0; }  if (_v) { {
                        _v = ((TYPE(argv[3]) == T_FIXNUM) || (TYPE(argv[3]) == T_BIGNUM)) ? 1 : 0; }  if (_v) { {
                            _v = ((TYPE(argv[4]) == T_FIXNUM) || (TYPE(argv[4]) == T_BIGNUM)) ? 1 : 0; }  if (_v) {
                            return _wrap_FXRegion_containsq_____SWIG_1(nargs, args, self);}  }  }  }  }  } 
    rb_raise(rb_eArgError, "No matching function for overloaded 'FXRegion_contains?'"); return Qnil; }
static VALUE _wrap_FXRegion_bounds(int argc, VALUE *argv, VALUE self) { FXRegion *arg1 = (FXRegion *) 0 ; FXRectangle result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRegion, 1); result = FXRegion_bounds((FXRegion const *)arg1); {
        FXRectangle* resultptr = new FXRectangle(result); vresult = FXRbGetRubyObj(resultptr, "FXRectangle *"); } 
    return vresult; }
static VALUE _wrap_FXRegion_offsetN___(int argc, VALUE *argv, VALUE self) { FXRegion *arg1 = (FXRegion *) 0 ; FXint arg2 ;
    FXint arg3 ; FXRegion *result; VALUE vresult = Qnil; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRegion, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]); {
        FXRegion &_result_ref = (arg1)->offset(arg2,arg3); result = (FXRegion *) &_result_ref; } 
    vresult = FXRbGetRubyObj(result, "FXRegion *"); return vresult; }
static VALUE _wrap_FXRegion___add__(int argc, VALUE *argv, VALUE self) { FXRegion *arg1 = (FXRegion *) 0 ; FXRegion *arg2 = 0 ;
    FXRegion result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRegion, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXRegion, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    result = FXRegion_operator_Sa_((FXRegion const *)arg1,(FXRegion const &)*arg2); {
        FXRegion* resultptr = new FXRegion(result); vresult = FXRbGetRubyObj(resultptr, "FXRegion *"); }  return vresult; }
static VALUE _wrap_FXRegion___mul__(int argc, VALUE *argv, VALUE self) { FXRegion *arg1 = (FXRegion *) 0 ; FXRegion *arg2 = 0 ;
    FXRegion result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRegion, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXRegion, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    result = FXRegion_operator_Sm_((FXRegion const *)arg1,(FXRegion const &)*arg2); {
        FXRegion* resultptr = new FXRegion(result); vresult = FXRbGetRubyObj(resultptr, "FXRegion *"); }  return vresult; }
static VALUE _wrap_FXRegion___sub__(int argc, VALUE *argv, VALUE self) { FXRegion *arg1 = (FXRegion *) 0 ; FXRegion *arg2 = 0 ;
    FXRegion result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRegion, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXRegion, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    result = FXRegion_operator_Ss_((FXRegion const *)arg1,(FXRegion const &)*arg2); {
        FXRegion* resultptr = new FXRegion(result); vresult = FXRbGetRubyObj(resultptr, "FXRegion *"); }  return vresult; }
static VALUE _wrap_FXRegion___xor__(int argc, VALUE *argv, VALUE self) { FXRegion *arg1 = (FXRegion *) 0 ; FXRegion *arg2 = 0 ;
    FXRegion result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRegion, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXRegion, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    result = FXRegion_operator_Sx_((FXRegion const *)arg1,(FXRegion const &)*arg2); {
        FXRegion* resultptr = new FXRegion(result); vresult = FXRbGetRubyObj(resultptr, "FXRegion *"); }  return vresult; }
static VALUE _wrap_FXRegion___eq__(int argc, VALUE *argv, VALUE self) { FXRegion *arg1 = (FXRegion *) 0 ; FXRegion *arg2 = 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRegion, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXRegion, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    result = (FXbool)FXRegion_operator_Se__Se_((FXRegion const *)arg1,(FXRegion const &)*arg2);
    vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXRegion_reset(int argc, VALUE *argv, VALUE self) { FXRegion *arg1 = (FXRegion *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRegion, 1); (arg1)->reset(); return Qnil; }
static void
free_FXRegion(FXRegion *arg1) {
    delete arg1;
}
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE _wrap_FXObject_allocate(VALUE self) {
#else
     static VALUE _wrap_FXObject_allocate(int argc, VALUE *argv, VALUE self) {
#endif
         VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_FXObject);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
         return vresult; }
static VALUE _wrap_new_FXObject(int argc, VALUE *argv, VALUE self) { FXObject *result; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc); { result = (FXObject *)new_FXObject();
        DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result); if(rb_block_given_p()){ rb_yield(self); }  }  return self; }
static VALUE _wrap_FXObject_handle(int argc, VALUE *argv, VALUE self) { FXObject *arg1 = (FXObject *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXObject, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]);
    arg4 = FXRbGetExpectedData(self, arg3, argv[2]); result = (long)(arg1)->handle(arg2,arg3,arg4); vresult = INT2NUM(result);
    return vresult; }
static void
free_FXObject(FXObject *arg1) {
    delete arg1;
}
static VALUE _wrap_FXObject_save(int argc, VALUE *argv, VALUE self) { FXObject *arg1 = (FXObject *) 0 ; FXStream *arg2 = 0 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXObject, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXObject_save((FXObject const *)arg1,*arg2); return Qnil; }
static VALUE _wrap_FXObject_load(int argc, VALUE *argv, VALUE self) { FXObject *arg1 = (FXObject *) 0 ; FXStream *arg2 = 0 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXObject, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXObject_load(arg1,*arg2); return Qnil; }
static VALUE _wrap_FXAccelTable_onKeyPress(int argc, VALUE *argv, VALUE self) { FXAccelTable *arg1 = (FXAccelTable *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXAccelTable, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onKeyPress(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXAccelTable_onKeyRelease(int argc, VALUE *argv, VALUE self) { FXAccelTable *arg1 = (FXAccelTable *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXAccelTable, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onKeyRelease(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE _wrap_FXAccelTable_allocate(VALUE self) {
#else
     static VALUE _wrap_FXAccelTable_allocate(int argc, VALUE *argv, VALUE self) {
#endif
         VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_FXAccelTable);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
         return vresult; }
static VALUE _wrap_new_FXAccelTable(int argc, VALUE *argv, VALUE self) { FXAccelTable *result; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc); { result = (FXAccelTable *)new_FXAccelTable();
        DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result); if(rb_block_given_p()){ rb_yield(self); }  }  return self; }
static VALUE _wrap_FXAccelTable_addAccel(int argc, VALUE *argv, VALUE self) { FXAccelTable *arg1 = (FXAccelTable *) 0 ;
    FXHotKey arg2 ; FXObject *arg3 = (FXObject *) 0 ; FXSelector arg4 = (FXSelector) 0 ; FXSelector arg5 = (FXSelector) 0 ;
    if ((argc < 1) || (argc > 4)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXAccelTable, 1); arg2 = NUM2UINT(argv[0]); if (argc > 1) {
        SWIG_ConvertPtr(argv[1], (void **) &arg3, SWIGTYPE_p_FXObject, 1); }  if (argc > 2) { arg4 = NUM2UINT(argv[2]); } 
    if (argc > 3) { arg5 = NUM2UINT(argv[3]); }  (arg1)->addAccel(arg2,arg3,arg4,arg5); return Qnil; }
static VALUE _wrap_FXAccelTable_removeAccel(int argc, VALUE *argv, VALUE self) { FXAccelTable *arg1 = (FXAccelTable *) 0 ;
    FXHotKey arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXAccelTable, 1); arg2 = NUM2UINT(argv[0]); (arg1)->removeAccel(arg2);
    return Qnil; }
static VALUE _wrap_FXAccelTable_hasAccel(int argc, VALUE *argv, VALUE self) { FXAccelTable *arg1 = (FXAccelTable *) 0 ;
    FXHotKey arg2 ; FXbool result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXAccelTable, 1); arg2 = NUM2UINT(argv[0]);
    result = (FXbool)((FXAccelTable const *)arg1)->hasAccel(arg2); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXAccelTable_targetOfAccel(int argc, VALUE *argv, VALUE self) { FXAccelTable *arg1 = (FXAccelTable *) 0 ;
    FXHotKey arg2 ; FXObject *result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXAccelTable, 1); arg2 = NUM2UINT(argv[0]);
    result = (FXObject *)((FXAccelTable const *)arg1)->targetOfAccel(arg2); {
        swig_type_info *ty = SWIG_TypeDynamicCast(SWIGTYPE_p_FXObject, (void **) &result);
        vresult = FXRbGetRubyObj(result, ty); }  return vresult; }
static void
free_FXAccelTable(FXAccelTable *arg1) {
    delete arg1;
}
static VALUE _wrap_FXAccelTable_save(int argc, VALUE *argv, VALUE self) { FXAccelTable *arg1 = (FXAccelTable *) 0 ;
    FXStream *arg2 = 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXAccelTable, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXAccelTable_save((FXAccelTable const *)arg1,*arg2); return Qnil; }
static VALUE _wrap_FXAccelTable_load(int argc, VALUE *argv, VALUE self) { FXAccelTable *arg1 = (FXAccelTable *) 0 ;
    FXStream *arg2 = 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXAccelTable, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXAccelTable_load(arg1,*arg2); return Qnil; }
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE _wrap_FXEvent_allocate(VALUE self) {
#else
     static VALUE _wrap_FXEvent_allocate(int argc, VALUE *argv, VALUE self) {
#endif
         VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_FXEvent);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
         return vresult; }
static VALUE _wrap_new_FXEvent(int argc, VALUE *argv, VALUE self) { FXEvent *result; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc); result = (FXEvent *)new FXEvent(); DATA_PTR(self) = result;
    return self; }
static VALUE _wrap_FXEvent_type_set(int argc, VALUE *argv, VALUE self) { FXEvent *arg1 = (FXEvent *) 0 ; FXuint arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXEvent, 1); arg2 = NUM2UINT(argv[0]); if (arg1) (arg1)->type = arg2;
    return Qnil; }
static VALUE _wrap_FXEvent_type_get(int argc, VALUE *argv, VALUE self) { FXEvent *arg1 = (FXEvent *) 0 ; FXuint result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXEvent, 1); result = (FXuint) ((arg1)->type); vresult = UINT2NUM(result);
    return vresult; }
static VALUE _wrap_FXEvent_time_set(int argc, VALUE *argv, VALUE self) { FXEvent *arg1 = (FXEvent *) 0 ; FXuint arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXEvent, 1); arg2 = NUM2UINT(argv[0]); if (arg1) (arg1)->time = arg2;
    return Qnil; }
static VALUE _wrap_FXEvent_time_get(int argc, VALUE *argv, VALUE self) { FXEvent *arg1 = (FXEvent *) 0 ; FXuint result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXEvent, 1); result = (FXuint) ((arg1)->time); vresult = UINT2NUM(result);
    return vresult; }
static VALUE _wrap_FXEvent_win_x_set(int argc, VALUE *argv, VALUE self) { FXEvent *arg1 = (FXEvent *) 0 ; FXint arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXEvent, 1); arg2 = NUM2INT(argv[0]); if (arg1) (arg1)->win_x = arg2;
    return Qnil; }
static VALUE _wrap_FXEvent_win_x_get(int argc, VALUE *argv, VALUE self) { FXEvent *arg1 = (FXEvent *) 0 ; FXint result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXEvent, 1); result = (FXint) ((arg1)->win_x); vresult = INT2NUM(result);
    return vresult; }
static VALUE _wrap_FXEvent_win_y_set(int argc, VALUE *argv, VALUE self) { FXEvent *arg1 = (FXEvent *) 0 ; FXint arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXEvent, 1); arg2 = NUM2INT(argv[0]); if (arg1) (arg1)->win_y = arg2;
    return Qnil; }
static VALUE _wrap_FXEvent_win_y_get(int argc, VALUE *argv, VALUE self) { FXEvent *arg1 = (FXEvent *) 0 ; FXint result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXEvent, 1); result = (FXint) ((arg1)->win_y); vresult = INT2NUM(result);
    return vresult; }
static VALUE _wrap_FXEvent_root_x_set(int argc, VALUE *argv, VALUE self) { FXEvent *arg1 = (FXEvent *) 0 ; FXint arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXEvent, 1); arg2 = NUM2INT(argv[0]); if (arg1) (arg1)->root_x = arg2;
    return Qnil; }
static VALUE _wrap_FXEvent_root_x_get(int argc, VALUE *argv, VALUE self) { FXEvent *arg1 = (FXEvent *) 0 ; FXint result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXEvent, 1); result = (FXint) ((arg1)->root_x); vresult = INT2NUM(result);
    return vresult; }
static VALUE _wrap_FXEvent_root_y_set(int argc, VALUE *argv, VALUE self) { FXEvent *arg1 = (FXEvent *) 0 ; FXint arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXEvent, 1); arg2 = NUM2INT(argv[0]); if (arg1) (arg1)->root_y = arg2;
    return Qnil; }
static VALUE _wrap_FXEvent_root_y_get(int argc, VALUE *argv, VALUE self) { FXEvent *arg1 = (FXEvent *) 0 ; FXint result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXEvent, 1); result = (FXint) ((arg1)->root_y); vresult = INT2NUM(result);
    return vresult; }
static VALUE _wrap_FXEvent_state_set(int argc, VALUE *argv, VALUE self) { FXEvent *arg1 = (FXEvent *) 0 ; FXint arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXEvent, 1); arg2 = NUM2INT(argv[0]); if (arg1) (arg1)->state = arg2;
    return Qnil; }
static VALUE _wrap_FXEvent_state_get(int argc, VALUE *argv, VALUE self) { FXEvent *arg1 = (FXEvent *) 0 ; FXint result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXEvent, 1); result = (FXint) ((arg1)->state); vresult = INT2NUM(result);
    return vresult; }
static VALUE _wrap_FXEvent_code_set(int argc, VALUE *argv, VALUE self) { FXEvent *arg1 = (FXEvent *) 0 ; FXint arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXEvent, 1); arg2 = NUM2INT(argv[0]); if (arg1) (arg1)->code = arg2;
    return Qnil; }
static VALUE _wrap_FXEvent_code_get(int argc, VALUE *argv, VALUE self) { FXEvent *arg1 = (FXEvent *) 0 ; FXint result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXEvent, 1); result = (FXint) ((arg1)->code); vresult = INT2NUM(result);
    return vresult; }
static VALUE _wrap_FXEvent_text_set(int argc, VALUE *argv, VALUE self) { FXEvent *arg1 = (FXEvent *) 0 ; FXString arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXEvent, 1); arg2 = to_FXString(argv[0]); if (arg1) (arg1)->text = arg2;
    return Qnil; }
static VALUE _wrap_FXEvent_text_get(int argc, VALUE *argv, VALUE self) { FXEvent *arg1 = (FXEvent *) 0 ; FXString result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXEvent, 1); result =  ((arg1)->text);
    vresult = rb_str_new2((&result)->text()); return vresult; }
static VALUE _wrap_FXEvent_last_x_set(int argc, VALUE *argv, VALUE self) { FXEvent *arg1 = (FXEvent *) 0 ; FXint arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXEvent, 1); arg2 = NUM2INT(argv[0]); if (arg1) (arg1)->last_x = arg2;
    return Qnil; }
static VALUE _wrap_FXEvent_last_x_get(int argc, VALUE *argv, VALUE self) { FXEvent *arg1 = (FXEvent *) 0 ; FXint result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXEvent, 1); result = (FXint) ((arg1)->last_x); vresult = INT2NUM(result);
    return vresult; }
static VALUE _wrap_FXEvent_last_y_set(int argc, VALUE *argv, VALUE self) { FXEvent *arg1 = (FXEvent *) 0 ; FXint arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXEvent, 1); arg2 = NUM2INT(argv[0]); if (arg1) (arg1)->last_y = arg2;
    return Qnil; }
static VALUE _wrap_FXEvent_last_y_get(int argc, VALUE *argv, VALUE self) { FXEvent *arg1 = (FXEvent *) 0 ; FXint result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXEvent, 1); result = (FXint) ((arg1)->last_y); vresult = INT2NUM(result);
    return vresult; }
static VALUE _wrap_FXEvent_click_x_set(int argc, VALUE *argv, VALUE self) { FXEvent *arg1 = (FXEvent *) 0 ; FXint arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXEvent, 1); arg2 = NUM2INT(argv[0]); if (arg1) (arg1)->click_x = arg2;
    return Qnil; }
static VALUE _wrap_FXEvent_click_x_get(int argc, VALUE *argv, VALUE self) { FXEvent *arg1 = (FXEvent *) 0 ; FXint result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXEvent, 1); result = (FXint) ((arg1)->click_x);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXEvent_click_y_set(int argc, VALUE *argv, VALUE self) { FXEvent *arg1 = (FXEvent *) 0 ; FXint arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXEvent, 1); arg2 = NUM2INT(argv[0]); if (arg1) (arg1)->click_y = arg2;
    return Qnil; }
static VALUE _wrap_FXEvent_click_y_get(int argc, VALUE *argv, VALUE self) { FXEvent *arg1 = (FXEvent *) 0 ; FXint result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXEvent, 1); result = (FXint) ((arg1)->click_y);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXEvent_rootclick_x_set(int argc, VALUE *argv, VALUE self) { FXEvent *arg1 = (FXEvent *) 0 ; FXint arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXEvent, 1); arg2 = NUM2INT(argv[0]);
    if (arg1) (arg1)->rootclick_x = arg2; return Qnil; }
static VALUE _wrap_FXEvent_rootclick_x_get(int argc, VALUE *argv, VALUE self) { FXEvent *arg1 = (FXEvent *) 0 ; FXint result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXEvent, 1); result = (FXint) ((arg1)->rootclick_x);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXEvent_rootclick_y_set(int argc, VALUE *argv, VALUE self) { FXEvent *arg1 = (FXEvent *) 0 ; FXint arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXEvent, 1); arg2 = NUM2INT(argv[0]);
    if (arg1) (arg1)->rootclick_y = arg2; return Qnil; }
static VALUE _wrap_FXEvent_rootclick_y_get(int argc, VALUE *argv, VALUE self) { FXEvent *arg1 = (FXEvent *) 0 ; FXint result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXEvent, 1); result = (FXint) ((arg1)->rootclick_y);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXEvent_click_time_set(int argc, VALUE *argv, VALUE self) { FXEvent *arg1 = (FXEvent *) 0 ; FXuint arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXEvent, 1); arg2 = NUM2UINT(argv[0]);
    if (arg1) (arg1)->click_time = arg2; return Qnil; }
static VALUE _wrap_FXEvent_click_time_get(int argc, VALUE *argv, VALUE self) { FXEvent *arg1 = (FXEvent *) 0 ; FXuint result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXEvent, 1); result = (FXuint) ((arg1)->click_time);
    vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXEvent_click_button_set(int argc, VALUE *argv, VALUE self) { FXEvent *arg1 = (FXEvent *) 0 ; FXuint arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXEvent, 1); arg2 = NUM2UINT(argv[0]);
    if (arg1) (arg1)->click_button = arg2; return Qnil; }
static VALUE _wrap_FXEvent_click_button_get(int argc, VALUE *argv, VALUE self) { FXEvent *arg1 = (FXEvent *) 0 ; FXuint result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXEvent, 1); result = (FXuint) ((arg1)->click_button);
    vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXEvent_click_count_set(int argc, VALUE *argv, VALUE self) { FXEvent *arg1 = (FXEvent *) 0 ; FXint arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXEvent, 1); arg2 = NUM2INT(argv[0]);
    if (arg1) (arg1)->click_count = arg2; return Qnil; }
static VALUE _wrap_FXEvent_click_count_get(int argc, VALUE *argv, VALUE self) { FXEvent *arg1 = (FXEvent *) 0 ; FXint result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXEvent, 1); result = (FXint) ((arg1)->click_count);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXEvent_moved_set(int argc, VALUE *argv, VALUE self) { FXEvent *arg1 = (FXEvent *) 0 ; FXbool arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXEvent, 1); arg2 = to_FXbool(argv[0]); if (arg1) (arg1)->moved = arg2;
    return Qnil; }
static VALUE _wrap_FXEvent_moved_get(int argc, VALUE *argv, VALUE self) { FXEvent *arg1 = (FXEvent *) 0 ; FXbool result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXEvent, 1); result = (FXbool) ((arg1)->moved);
    vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXEvent_rect_set(int argc, VALUE *argv, VALUE self) { FXEvent *arg1 = (FXEvent *) 0 ;
    FXRectangle *arg2 = (FXRectangle *) 0 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXEvent, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXRectangle, 1); if (arg1) (arg1)->rect = *arg2; return Qnil; }
static VALUE _wrap_FXEvent_rect_get(int argc, VALUE *argv, VALUE self) { FXEvent *arg1 = (FXEvent *) 0 ; FXRectangle *result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXEvent, 1); result = (FXRectangle *)& ((arg1)->rect);
    vresult = FXRbGetRubyObj(result, "FXRectangle *"); return vresult; }
static VALUE _wrap_FXEvent_synthetic_set(int argc, VALUE *argv, VALUE self) { FXEvent *arg1 = (FXEvent *) 0 ; FXbool arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXEvent, 1); arg2 = to_FXbool(argv[0]);
    if (arg1) (arg1)->synthetic = arg2; return Qnil; }
static VALUE _wrap_FXEvent_synthetic_get(int argc, VALUE *argv, VALUE self) { FXEvent *arg1 = (FXEvent *) 0 ; FXbool result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXEvent, 1); result = (FXbool) ((arg1)->synthetic);
    vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXEvent_target_set(int argc, VALUE *argv, VALUE self) { FXEvent *arg1 = (FXEvent *) 0 ; FXDragType arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXEvent, 1); arg2 = NUM2UINT(argv[0]); if (arg1) (arg1)->target = arg2;
    return Qnil; }
static VALUE _wrap_FXEvent_target_get(int argc, VALUE *argv, VALUE self) { FXEvent *arg1 = (FXEvent *) 0 ; FXDragType result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXEvent, 1); result = (FXDragType) ((arg1)->target);
    vresult = UINT2NUM(result); return vresult; }
static void
free_FXEvent(FXEvent *arg1) {
    delete arg1;
}
static VALUE _wrap_FXApp_onCmdQuit(int argc, VALUE *argv, VALUE self) { FXApp *arg1 = (FXApp *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXApp, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdQuit(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXApp_onCmdDump(int argc, VALUE *argv, VALUE self) { FXApp *arg1 = (FXApp *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXApp, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdDump(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXApp_copyright(int argc, VALUE *argv, VALUE self) { VALUE result; VALUE vresult = Qnil;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    result = (VALUE)FXApp_copyright(); vresult = result; return vresult; }
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE _wrap_FXApp_allocate(VALUE self) {
#else
     static VALUE _wrap_FXApp_allocate(int argc, VALUE *argv, VALUE self) {
#endif
         VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_FXApp);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
         return vresult; }
static VALUE _wrap_new_FXApp(int argc, VALUE *argv, VALUE self) { FXchar *arg1 = (FXchar *) "Application" ;
    FXchar *arg2 = (FXchar *) "FoxDefault" ; FXApp *result; if ((argc < 0) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc); if (argc > 0) { arg1 = StringValuePtr(argv[0]); } 
    if (argc > 1) { arg2 = StringValuePtr(argv[1]); }  { result = (FXApp *)new_FXApp((FXchar const *)arg1,(FXchar const *)arg2);
        DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result); if(rb_block_given_p()){ rb_yield(self); }  }  return self; }
static VALUE _wrap_FXApp_getAppName(int argc, VALUE *argv, VALUE self) { FXApp *arg1 = (FXApp *) 0 ; FXString result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXApp, 1); result = ((FXApp const *)arg1)->getAppName();
    vresult = rb_str_new2((&result)->text()); return vresult; }
static VALUE _wrap_FXApp_getVendorName(int argc, VALUE *argv, VALUE self) { FXApp *arg1 = (FXApp *) 0 ; FXString result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXApp, 1); result = ((FXApp const *)arg1)->getVendorName();
    vresult = rb_str_new2((&result)->text()); return vresult; }
static VALUE _wrap_FXApp_openDisplay(int argc, VALUE *argv, VALUE self) { FXApp *arg1 = (FXApp *) 0 ;
    FXchar *arg2 = (FXchar *) 0 ; FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc); SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXApp, 1);
    if (argc > 0) { arg2 = StringValuePtr(argv[0]); }  result = (FXbool)(arg1)->openDisplay((FXchar const *)arg2);
    vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXApp_closeDisplay(int argc, VALUE *argv, VALUE self) { FXApp *arg1 = (FXApp *) 0 ; FXbool result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXApp, 1); result = (FXbool)(arg1)->closeDisplay();
    vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXApp_getDisplay(int argc, VALUE *argv, VALUE self) { FXApp *arg1 = (FXApp *) 0 ; unsigned long result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXApp, 1); result = (unsigned long)FXApp_getDisplay((FXApp const *)arg1);
    vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXApp_isInitialized(int argc, VALUE *argv, VALUE self) { FXApp *arg1 = (FXApp *) 0 ; FXbool result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXApp, 1); result = (FXbool)((FXApp const *)arg1)->isInitialized();
    vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXApp_getArgc(int argc, VALUE *argv, VALUE self) { FXApp *arg1 = (FXApp *) 0 ; FXint result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXApp, 1); result = (FXint)((FXApp const *)arg1)->getArgc();
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXApp_getArgv(int argc, VALUE *argv, VALUE self) { FXApp *arg1 = (FXApp *) 0 ; FXchar **result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXApp, 1); result = (FXchar **)((FXApp const *)arg1)->getArgv();
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_p_FXchar,0); return vresult; }
static VALUE _wrap_FXApp_getDefaultVisual(int argc, VALUE *argv, VALUE self) { FXApp *arg1 = (FXApp *) 0 ; FXVisual *result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXApp, 1); result = (FXVisual *)((FXApp const *)arg1)->getDefaultVisual();
    { swig_type_info *ty = SWIG_TypeDynamicCast(SWIGTYPE_p_FXVisual, (void **) &result); vresult = FXRbGetRubyObj(result, ty); }
     return vresult; }
static VALUE _wrap_FXApp_setDefaultVisual(int argc, VALUE *argv, VALUE self) { FXApp *arg1 = (FXApp *) 0 ;
    FXVisual *arg2 = (FXVisual *) 0 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc); SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXApp, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXVisual, 1); FXApp_setDefaultVisual(arg1,arg2); return Qnil; }
static VALUE _wrap_FXApp_getMonoVisual(int argc, VALUE *argv, VALUE self) { FXApp *arg1 = (FXApp *) 0 ; FXVisual *result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXApp, 1); result = (FXVisual *)((FXApp const *)arg1)->getMonoVisual(); {
        swig_type_info *ty = SWIG_TypeDynamicCast(SWIGTYPE_p_FXVisual, (void **) &result);
        vresult = FXRbGetRubyObj(result, ty); }  return vresult; }
static VALUE _wrap_FXApp_getRootWindow(int argc, VALUE *argv, VALUE self) { FXApp *arg1 = (FXApp *) 0 ; FXRootWindow *result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXApp, 1);
    result = (FXRootWindow *)((FXApp const *)arg1)->getRootWindow(); {
        swig_type_info *ty = SWIG_TypeDynamicCast(SWIGTYPE_p_FXRootWindow, (void **) &result);
        vresult = FXRbGetRubyObj(result, ty); }  return vresult; }
static VALUE _wrap_FXApp_getCursorWindow(int argc, VALUE *argv, VALUE self) { FXApp *arg1 = (FXApp *) 0 ; FXWindow *result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXApp, 1); result = (FXWindow *)((FXApp const *)arg1)->getCursorWindow();
    { swig_type_info *ty = SWIG_TypeDynamicCast(SWIGTYPE_p_FXWindow, (void **) &result); vresult = FXRbGetRubyObj(result, ty); }
     return vresult; }
static VALUE _wrap_FXApp_getFocusWindow(int argc, VALUE *argv, VALUE self) { FXApp *arg1 = (FXApp *) 0 ; FXWindow *result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXApp, 1); result = (FXWindow *)((FXApp const *)arg1)->getFocusWindow(); {
        swig_type_info *ty = SWIG_TypeDynamicCast(SWIGTYPE_p_FXWindow, (void **) &result);
        vresult = FXRbGetRubyObj(result, ty); }  return vresult; }
static VALUE _wrap_FXApp_getPopupWindow(int argc, VALUE *argv, VALUE self) { FXApp *arg1 = (FXApp *) 0 ; FXPopup *result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXApp, 1); result = (FXPopup *)((FXApp const *)arg1)->getPopupWindow(); {
        swig_type_info *ty = SWIG_TypeDynamicCast(SWIGTYPE_p_FXPopup, (void **) &result); vresult = FXRbGetRubyObj(result, ty); }
     return vresult; }
static VALUE _wrap_FXApp_findWindowWithId(int argc, VALUE *argv, VALUE self) { FXApp *arg1 = (FXApp *) 0 ; FXID arg2 ;
    FXWindow *result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc); SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXApp, 1);
    arg2 = int_to_fxid(argv[0]); result = (FXWindow *)((FXApp const *)arg1)->findWindowWithId(arg2); {
        swig_type_info *ty = SWIG_TypeDynamicCast(SWIGTYPE_p_FXWindow, (void **) &result);
        vresult = FXRbGetRubyObj(result, ty); }  return vresult; }
static VALUE _wrap_FXApp_findWindowAt(int argc, VALUE *argv, VALUE self) { FXApp *arg1 = (FXApp *) 0 ; FXint arg2 ; FXint arg3 ;
    FXID arg4 = (FXID) 0 ; FXWindow *result; VALUE vresult = Qnil; if ((argc < 2) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc); SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXApp, 1);
    arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]); if (argc > 2) { arg4 = int_to_fxid(argv[2]); } 
    result = (FXWindow *)((FXApp const *)arg1)->findWindowAt(arg2,arg3,arg4); {
        swig_type_info *ty = SWIG_TypeDynamicCast(SWIGTYPE_p_FXWindow, (void **) &result);
        vresult = FXRbGetRubyObj(result, ty); }  return vresult; }
static VALUE _wrap_FXApp_addTimeout(int argc, VALUE *argv, VALUE self) { FXApp *arg1 = (FXApp *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; FXuint arg4 = (FXuint) 1000 ; void *arg5 = (void *) 0 ; FXTimer *result;
    VALUE vresult = Qnil; if ((argc < 2) || (argc > 4)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXApp, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); if (argc > 2) {
        arg4 = NUM2UINT(argv[2]); }  if (argc > 3) { SWIG_ConvertPtr(argv[3], (void **) &arg5, 0, 1); } 
    result = (FXTimer *)(arg1)->addTimeout(arg2,arg3,arg4,arg5); vresult = FXRbGetRubyObj(result, "FXTimer *"); return vresult; }
static VALUE _wrap_FXApp_removeTimeout__SWIG_0(int argc, VALUE *argv, VALUE self) { FXApp *arg1 = (FXApp *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; FXTimer *result; VALUE vresult = Qnil; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc); SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXApp, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]);
    result = (FXTimer *)(arg1)->removeTimeout(arg2,arg3); vresult = FXRbGetRubyObj(result, "FXTimer *"); return vresult; }
static VALUE _wrap_FXApp_removeTimeout__SWIG_1(int argc, VALUE *argv, VALUE self) { FXApp *arg1 = (FXApp *) 0 ;
    FXTimer *arg2 = (FXTimer *) 0 ; FXTimer *result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc); SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXApp, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXTimer, 1); result = (FXTimer *)(arg1)->removeTimeout(arg2);
    vresult = FXRbGetRubyObj(result, "FXTimer *"); return vresult; }
static VALUE _wrap_FXApp_removeTimeout(int nargs, VALUE *args, VALUE self) { int argc; VALUE argv[4]; int ii; argc = nargs + 1;
    argv[0] = self; for (ii = 1; (ii < argc) && (ii < 3); ii++) { argv[ii] = args[ii-1]; }  if (argc == 2) { int _v; {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXApp, 0) != -1)) ? 1 : 0; }
         if (_v) { { void *ptr;
                _v = (NIL_P(argv[1]) || (TYPE(argv[1]) == T_DATA && SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_FXTimer, 0) != -1)) ? 1 : 0; }
             if (_v) { return _wrap_FXApp_removeTimeout__SWIG_1(nargs, args, self);}  }  }  if (argc == 3) { int _v; {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXApp, 0) != -1)) ? 1 : 0; }
         if (_v) { { void *ptr;
                _v = (NIL_P(argv[1]) || (TYPE(argv[1]) == T_DATA && SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_FXObject, 0) != -1)) ? 1 : 0; }
             if (_v) { { _v = ((TYPE(argv[2]) == T_FIXNUM) || (TYPE(argv[2]) == T_BIGNUM)) ? 1 : 0; }  if (_v) {
                    return _wrap_FXApp_removeTimeout__SWIG_0(nargs, args, self);}  }  }  } 
    rb_raise(rb_eArgError, "No matching function for overloaded 'FXApp_removeTimeout'"); return Qnil; }
static VALUE _wrap_FXApp_hasTimeoutq___(int argc, VALUE *argv, VALUE self) { FXApp *arg1 = (FXApp *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; FXbool result; VALUE vresult = Qnil; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc); SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXApp, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]);
    result = (FXbool)((FXApp const *)arg1)->hasTimeout(arg2,arg3); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXApp_remainingTimeout__SWIG_0(int argc, VALUE *argv, VALUE self) { FXApp *arg1 = (FXApp *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; FXuint result; VALUE vresult = Qnil; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc); SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXApp, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]);
    result = (FXuint)((FXApp const *)arg1)->remainingTimeout(arg2,arg3); vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXApp_remainingTimeout__SWIG_1(int argc, VALUE *argv, VALUE self) { FXApp *arg1 = (FXApp *) 0 ;
    FXTimer *arg2 = (FXTimer *) 0 ; FXuint result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc); SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXApp, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXTimer, 1);
    result = (FXuint)((FXApp const *)arg1)->remainingTimeout(arg2); vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXApp_remainingTimeout(int nargs, VALUE *args, VALUE self) { int argc; VALUE argv[4]; int ii;
    argc = nargs + 1; argv[0] = self; for (ii = 1; (ii < argc) && (ii < 3); ii++) { argv[ii] = args[ii-1]; }  if (argc == 2) {
        int _v; { void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXApp, 0) != -1)) ? 1 : 0; }
         if (_v) { { void *ptr;
                _v = (NIL_P(argv[1]) || (TYPE(argv[1]) == T_DATA && SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_FXTimer, 0) != -1)) ? 1 : 0; }
             if (_v) { return _wrap_FXApp_remainingTimeout__SWIG_1(nargs, args, self);}  }  }  if (argc == 3) { int _v; {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXApp, 0) != -1)) ? 1 : 0; }
         if (_v) { { void *ptr;
                _v = (NIL_P(argv[1]) || (TYPE(argv[1]) == T_DATA && SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_FXObject, 0) != -1)) ? 1 : 0; }
             if (_v) { { _v = ((TYPE(argv[2]) == T_FIXNUM) || (TYPE(argv[2]) == T_BIGNUM)) ? 1 : 0; }  if (_v) {
                    return _wrap_FXApp_remainingTimeout__SWIG_0(nargs, args, self);}  }  }  } 
    rb_raise(rb_eArgError, "No matching function for overloaded 'FXApp_remainingTimeout'"); return Qnil; }
static VALUE _wrap_FXApp_addChore(int argc, VALUE *argv, VALUE self) { FXApp *arg1 = (FXApp *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; FXChore *result; VALUE vresult = Qnil;
    if ((argc < 2) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXApp, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); if (argc > 2) {
        SWIG_ConvertPtr(argv[2], (void **) &arg4, 0, 1); }  result = (FXChore *)(arg1)->addChore(arg2,arg3,arg4);
    vresult = FXRbGetRubyObj(result, "FXChore *"); return vresult; }
static VALUE _wrap_FXApp_removeChore__SWIG_0(int argc, VALUE *argv, VALUE self) { FXApp *arg1 = (FXApp *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; FXChore *result; VALUE vresult = Qnil; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc); SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXApp, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]);
    result = (FXChore *)(arg1)->removeChore(arg2,arg3); vresult = FXRbGetRubyObj(result, "FXChore *"); return vresult; }
static VALUE _wrap_FXApp_removeChore__SWIG_1(int argc, VALUE *argv, VALUE self) { FXApp *arg1 = (FXApp *) 0 ;
    FXChore *arg2 = (FXChore *) 0 ; FXChore *result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc); SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXApp, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXChore, 1); result = (FXChore *)(arg1)->removeChore(arg2);
    vresult = FXRbGetRubyObj(result, "FXChore *"); return vresult; }
static VALUE _wrap_FXApp_removeChore(int nargs, VALUE *args, VALUE self) { int argc; VALUE argv[4]; int ii; argc = nargs + 1;
    argv[0] = self; for (ii = 1; (ii < argc) && (ii < 3); ii++) { argv[ii] = args[ii-1]; }  if (argc == 2) { int _v; {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXApp, 0) != -1)) ? 1 : 0; }
         if (_v) { { void *ptr;
                _v = (NIL_P(argv[1]) || (TYPE(argv[1]) == T_DATA && SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_FXChore, 0) != -1)) ? 1 : 0; }
             if (_v) { return _wrap_FXApp_removeChore__SWIG_1(nargs, args, self);}  }  }  if (argc == 3) { int _v; { void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXApp, 0) != -1)) ? 1 : 0; }
         if (_v) { { void *ptr;
                _v = (NIL_P(argv[1]) || (TYPE(argv[1]) == T_DATA && SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_FXObject, 0) != -1)) ? 1 : 0; }
             if (_v) { { _v = ((TYPE(argv[2]) == T_FIXNUM) || (TYPE(argv[2]) == T_BIGNUM)) ? 1 : 0; }  if (_v) {
                    return _wrap_FXApp_removeChore__SWIG_0(nargs, args, self);}  }  }  } 
    rb_raise(rb_eArgError, "No matching function for overloaded 'FXApp_removeChore'"); return Qnil; }
static VALUE _wrap_FXApp_hasChoreq___(int argc, VALUE *argv, VALUE self) { FXApp *arg1 = (FXApp *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; FXbool result; VALUE vresult = Qnil; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc); SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXApp, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]);
    result = (FXbool)((FXApp const *)arg1)->hasChore(arg2,arg3); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXApp_addSignal(int argc, VALUE *argv, VALUE self) { FXApp *arg1 = (FXApp *) 0 ; VALUE arg2 ;
    FXObject *arg3 = (FXObject *) 0 ; FXSelector arg4 ; FXbool arg5 = (FXbool) 0 ; FXuint arg6 = (FXuint) 0 ;
    if ((argc < 3) || (argc > 5)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXApp, 1); arg2 = argv[0];
    SWIG_ConvertPtr(argv[1], (void **) &arg3, SWIGTYPE_p_FXObject, 1); arg4 = NUM2UINT(argv[2]); if (argc > 3) {
        arg5 = to_FXbool(argv[3]); }  if (argc > 4) { arg6 = NUM2UINT(argv[4]); } 
    FXApp_addSignal(arg1,arg2,arg3,arg4,arg5,arg6); return Qnil; }
static VALUE _wrap_FXApp_removeSignal(int argc, VALUE *argv, VALUE self) { FXApp *arg1 = (FXApp *) 0 ; VALUE arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXApp, 1); arg2 = argv[0]; FXApp_removeSignal(arg1,arg2); return Qnil; }
static VALUE _wrap_FXApp_addInput(int argc, VALUE *argv, VALUE self) { FXApp *arg1 = (FXApp *) 0 ; VALUE arg2 ; FXuint arg3 ;
    FXObject *arg4 = (FXObject *) 0 ; FXSelector arg5 ; FXbool result; VALUE vresult = Qnil; if ((argc < 4) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc); SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXApp, 1);
    arg2 = argv[0]; arg3 = NUM2UINT(argv[1]); SWIG_ConvertPtr(argv[2], (void **) &arg4, SWIGTYPE_p_FXObject, 1);
    arg5 = NUM2UINT(argv[3]); result = (FXbool)FXApp_addInput(arg1,arg2,arg3,arg4,arg5); vresult = result ? Qtrue : Qfalse;
    return vresult; }
static VALUE _wrap_FXApp_removeInput(int argc, VALUE *argv, VALUE self) { FXApp *arg1 = (FXApp *) 0 ; VALUE arg2 ; FXuint arg3 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc); SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXApp, 1);
    arg2 = argv[0]; arg3 = NUM2UINT(argv[1]); result = (FXbool)FXApp_removeInput(arg1,arg2,arg3);
    vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXApp_peekEvent(int argc, VALUE *argv, VALUE self) { FXApp *arg1 = (FXApp *) 0 ; FXbool result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXApp, 1); result = (FXbool)(arg1)->peekEvent();
    vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXApp_runOneEvent(int argc, VALUE *argv, VALUE self) { FXApp *arg1 = (FXApp *) 0 ; FXbool arg2 = (FXbool) 1 ;
    if ((argc < 0) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXApp, 1); if (argc > 0) { arg2 = to_FXbool(argv[0]); } 
    (arg1)->runOneEvent(arg2); return Qnil; }
static VALUE _wrap_FXApp_run(int argc, VALUE *argv, VALUE self) { FXApp *arg1 = (FXApp *) 0 ; FXint result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXApp, 1); result = (FXint)(arg1)->run(); vresult = INT2NUM(result);
    return vresult; }
static VALUE _wrap_FXApp_runUntil(int argc, VALUE *argv, VALUE self) { FXApp *arg1 = (FXApp *) 0 ; FXuint *arg2 = 0 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc); SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXApp, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXuint, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    result = (FXint)(arg1)->runUntil(*arg2); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXApp_runWhileEvents(int argc, VALUE *argv, VALUE self) { FXApp *arg1 = (FXApp *) 0 ; FXint result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXApp, 1); result = (FXint)(arg1)->runWhileEvents();
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXApp_runModalWhileEvents(int argc, VALUE *argv, VALUE self) { FXApp *arg1 = (FXApp *) 0 ;
    FXWindow *arg2 = (FXWindow *) 0 ; FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc); SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXApp, 1);
    if (argc > 0) { SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXWindow, 1); } 
    result = (FXint)(arg1)->runModalWhileEvents(arg2); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXApp_runModal(int argc, VALUE *argv, VALUE self) { FXApp *arg1 = (FXApp *) 0 ; FXint result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXApp, 1); result = (FXint)(arg1)->runModal(); vresult = INT2NUM(result);
    return vresult; }
static VALUE _wrap_FXApp_runModalFor(int argc, VALUE *argv, VALUE self) { FXApp *arg1 = (FXApp *) 0 ;
    FXWindow *arg2 = (FXWindow *) 0 ; FXint result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc); SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXApp, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXWindow, 1); result = (FXint)(arg1)->runModalFor(arg2);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXApp_runModalWhileShown(int argc, VALUE *argv, VALUE self) { FXApp *arg1 = (FXApp *) 0 ;
    FXWindow *arg2 = (FXWindow *) 0 ; FXint result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc); SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXApp, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXWindow, 1); result = (FXint)(arg1)->runModalWhileShown(arg2);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXApp_runPopup(int argc, VALUE *argv, VALUE self) { FXApp *arg1 = (FXApp *) 0 ;
    FXWindow *arg2 = (FXWindow *) 0 ; FXint result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc); SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXApp, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXWindow, 1); result = (FXint)(arg1)->runPopup(arg2);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXApp_isModal(int argc, VALUE *argv, VALUE self) { FXApp *arg1 = (FXApp *) 0 ;
    FXWindow *arg2 = (FXWindow *) 0 ; FXbool result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc); SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXApp, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXWindow, 1); result = (FXbool)((FXApp const *)arg1)->isModal(arg2);
    vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXApp_getModalWindow(int argc, VALUE *argv, VALUE self) { FXApp *arg1 = (FXApp *) 0 ; FXWindow *result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXApp, 1); result = (FXWindow *)((FXApp const *)arg1)->getModalWindow(); {
        swig_type_info *ty = SWIG_TypeDynamicCast(SWIGTYPE_p_FXWindow, (void **) &result);
        vresult = FXRbGetRubyObj(result, ty); }  return vresult; }
static VALUE _wrap_FXApp_getModality(int argc, VALUE *argv, VALUE self) { FXApp *arg1 = (FXApp *) 0 ; int result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXApp, 1); result = (int)((FXApp const *)arg1)->getModality();
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXApp_stop(int argc, VALUE *argv, VALUE self) { FXApp *arg1 = (FXApp *) 0 ; FXint arg2 = (FXint) 0 ;
    if ((argc < 0) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXApp, 1); if (argc > 0) { arg2 = NUM2INT(argv[0]); }  (arg1)->stop(arg2);
    return Qnil; }
static VALUE _wrap_FXApp_stopModal__SWIG_0(int argc, VALUE *argv, VALUE self) { FXApp *arg1 = (FXApp *) 0 ;
    FXWindow *arg2 = (FXWindow *) 0 ; FXint arg3 = (FXint) 0 ; if ((argc < 1) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc); SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXApp, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXWindow, 1); if (argc > 1) { arg3 = NUM2INT(argv[1]); } 
    (arg1)->stopModal(arg2,arg3); return Qnil; }
static VALUE _wrap_FXApp_stopModal__SWIG_1(int argc, VALUE *argv, VALUE self) { FXApp *arg1 = (FXApp *) 0 ;
    FXint arg2 = (FXint) 0 ; if ((argc < 0) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXApp, 1); if (argc > 0) { arg2 = NUM2INT(argv[0]); } 
    (arg1)->stopModal(arg2); return Qnil; }
static VALUE _wrap_FXApp_stopModal(int nargs, VALUE *args, VALUE self) { int argc; VALUE argv[4]; int ii; argc = nargs + 1;
    argv[0] = self; for (ii = 1; (ii < argc) && (ii < 3); ii++) { argv[ii] = args[ii-1]; }  if ((argc >= 1) && (argc <= 2)) {
        int _v; { void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXApp, 0) != -1)) ? 1 : 0; }
         if (_v) { if (argc <= 1) { return _wrap_FXApp_stopModal__SWIG_1(nargs, args, self);}  {
                _v = ((TYPE(argv[1]) == T_FIXNUM) || (TYPE(argv[1]) == T_BIGNUM)) ? 1 : 0; }  if (_v) {
                return _wrap_FXApp_stopModal__SWIG_1(nargs, args, self);}  }  }  if ((argc >= 2) && (argc <= 3)) { int _v; {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXApp, 0) != -1)) ? 1 : 0; }
         if (_v) { { void *ptr;
                _v = (NIL_P(argv[1]) || (TYPE(argv[1]) == T_DATA && SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_FXWindow, 0) != -1)) ? 1 : 0; }
             if (_v) { if (argc <= 2) { return _wrap_FXApp_stopModal__SWIG_0(nargs, args, self);}  {
                    _v = ((TYPE(argv[2]) == T_FIXNUM) || (TYPE(argv[2]) == T_BIGNUM)) ? 1 : 0; }  if (_v) {
                    return _wrap_FXApp_stopModal__SWIG_0(nargs, args, self);}  }  }  } 
    rb_raise(rb_eArgError, "No matching function for overloaded 'FXApp_stopModal'"); return Qnil; }
static VALUE _wrap_FXApp_forceRefresh(int argc, VALUE *argv, VALUE self) { FXApp *arg1 = (FXApp *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXApp, 1); (arg1)->forceRefresh(); return Qnil; }
static VALUE _wrap_FXApp_refresh(int argc, VALUE *argv, VALUE self) { FXApp *arg1 = (FXApp *) 0 ; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc); SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXApp, 1);
    (arg1)->refresh(); return Qnil; }
static VALUE _wrap_FXApp_flush(int argc, VALUE *argv, VALUE self) { FXApp *arg1 = (FXApp *) 0 ; FXbool arg2 = (FXbool) 0 ;
    if ((argc < 0) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXApp, 1); if (argc > 0) { arg2 = to_FXbool(argv[0]); } 
    (arg1)->flush(arg2); return Qnil; }
static VALUE _wrap_FXApp_repaint(int argc, VALUE *argv, VALUE self) { FXApp *arg1 = (FXApp *) 0 ; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc); SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXApp, 1);
    (arg1)->repaint(); return Qnil; }
static VALUE _wrap_FXApp_reg(int argc, VALUE *argv, VALUE self) { FXApp *arg1 = (FXApp *) 0 ; FXRegistry *result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXApp, 1); { FXRegistry &_result_ref = (arg1)->reg();
        result = (FXRegistry *) &_result_ref; }  {
        swig_type_info *ty = SWIG_TypeDynamicCast(SWIGTYPE_p_FXRegistry, (void **) &result);
        vresult = FXRbGetRubyObj(result, ty); }  return vresult; }
static VALUE _wrap_FXApp_registerDragType(int argc, VALUE *argv, VALUE self) { FXApp *arg1 = (FXApp *) 0 ; FXString *arg2 = 0 ;
    FXDragType result; SwigValueWrapper<FXString > p2 ; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc); SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXApp, 1);
    p2 = to_FXString(argv[0]); arg2 = &p2;
    result = (FXDragType)((FXApp const *)arg1)->registerDragType((FXString const &)*arg2); vresult = UINT2NUM(result);
    return vresult; }
static VALUE _wrap_FXApp_getDragTypeName(int argc, VALUE *argv, VALUE self) { FXApp *arg1 = (FXApp *) 0 ; FXDragType arg2 ;
    FXString result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc); SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXApp, 1);
    arg2 = NUM2UINT(argv[0]); result = ((FXApp const *)arg1)->getDragTypeName(arg2); vresult = rb_str_new2((&result)->text());
    return vresult; }
static VALUE _wrap_FXApp_getDragWindow(int argc, VALUE *argv, VALUE self) { FXApp *arg1 = (FXApp *) 0 ; FXWindow *result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXApp, 1); result = (FXWindow *)((FXApp const *)arg1)->getDragWindow(); {
        swig_type_info *ty = SWIG_TypeDynamicCast(SWIGTYPE_p_FXWindow, (void **) &result);
        vresult = FXRbGetRubyObj(result, ty); }  return vresult; }
static VALUE _wrap_FXApp_beep(int argc, VALUE *argv, VALUE self) { FXApp *arg1 = (FXApp *) 0 ; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc); SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXApp, 1);
    (arg1)->beep(); return Qnil; }
static VALUE _wrap_FXApp_instance(int argc, VALUE *argv, VALUE self) { FXApp *result; VALUE vresult = Qnil;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    result = (FXApp *)FXApp::instance(); { swig_type_info *ty = SWIG_TypeDynamicCast(SWIGTYPE_p_FXApp, (void **) &result);
        vresult = FXRbGetRubyObj(result, ty); }  return vresult; }
static VALUE _wrap_FXApp_setNormalFont(int argc, VALUE *argv, VALUE self) { FXApp *arg1 = (FXApp *) 0 ;
    FXFont *arg2 = (FXFont *) 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXApp, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXFont, 1); FXApp_setNormalFont(arg1,arg2); return Qnil; }
static VALUE _wrap_FXApp_getNormalFont(int argc, VALUE *argv, VALUE self) { FXApp *arg1 = (FXApp *) 0 ; FXFont *result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXApp, 1); result = (FXFont *)((FXApp const *)arg1)->getNormalFont(); {
        swig_type_info *ty = SWIG_TypeDynamicCast(SWIGTYPE_p_FXFont, (void **) &result); vresult = FXRbGetRubyObj(result, ty); }
     return vresult; }
static VALUE _wrap_FXApp_beginWaitCursor(int argc, VALUE *argv, VALUE self) { FXApp *arg1 = (FXApp *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXApp, 1); (arg1)->beginWaitCursor(); return Qnil; }
static VALUE _wrap_FXApp_endWaitCursor(int argc, VALUE *argv, VALUE self) { FXApp *arg1 = (FXApp *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXApp, 1); (arg1)->endWaitCursor(); return Qnil; }
static VALUE _wrap_FXApp_setWaitCursor(int argc, VALUE *argv, VALUE self) { FXApp *arg1 = (FXApp *) 0 ;
    FXCursor *arg2 = (FXCursor *) 0 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc); SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXApp, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXCursor, 1); FXApp_setWaitCursor(arg1,arg2); return Qnil; }
static VALUE _wrap_FXApp_getWaitCursor(int argc, VALUE *argv, VALUE self) { FXApp *arg1 = (FXApp *) 0 ; FXCursor *result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXApp, 1); result = (FXCursor *)((FXApp const *)arg1)->getWaitCursor(); {
        swig_type_info *ty = SWIG_TypeDynamicCast(SWIGTYPE_p_FXCursor, (void **) &result);
        vresult = FXRbGetRubyObj(result, ty); }  return vresult; }
static VALUE _wrap_FXApp_getDefaultCursor(int argc, VALUE *argv, VALUE self) { FXApp *arg1 = (FXApp *) 0 ; int arg2 ;
    FXCursor *result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc); SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXApp, 1);
    arg2 = (int) NUM2INT(argv[0]); result = (FXCursor *)((FXApp const *)arg1)->getDefaultCursor((FXDefaultCursor )arg2); {
        swig_type_info *ty = SWIG_TypeDynamicCast(SWIGTYPE_p_FXCursor, (void **) &result);
        vresult = FXRbGetRubyObj(result, ty); }  return vresult; }
static VALUE _wrap_FXApp_setDefaultCursor(int argc, VALUE *argv, VALUE self) { FXApp *arg1 = (FXApp *) 0 ; int arg2 ;
    FXCursor *arg3 = (FXCursor *) 0 ; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc); SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXApp, 1);
    arg2 = (int) NUM2INT(argv[0]); SWIG_ConvertPtr(argv[1], (void **) &arg3, SWIGTYPE_p_FXCursor, 1);
    FXApp_setDefaultCursor(arg1,(FXDefaultCursor )arg2,arg3); return Qnil; }
static VALUE _wrap_FXApp_getTypingSpeed(int argc, VALUE *argv, VALUE self) { FXApp *arg1 = (FXApp *) 0 ; FXuint result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXApp, 1); result = (FXuint)((FXApp const *)arg1)->getTypingSpeed();
    vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXApp_getClickSpeed(int argc, VALUE *argv, VALUE self) { FXApp *arg1 = (FXApp *) 0 ; FXuint result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXApp, 1); result = (FXuint)((FXApp const *)arg1)->getClickSpeed();
    vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXApp_getScrollSpeed(int argc, VALUE *argv, VALUE self) { FXApp *arg1 = (FXApp *) 0 ; FXuint result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXApp, 1); result = (FXuint)((FXApp const *)arg1)->getScrollSpeed();
    vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXApp_getScrollDelay(int argc, VALUE *argv, VALUE self) { FXApp *arg1 = (FXApp *) 0 ; FXuint result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXApp, 1); result = (FXuint)((FXApp const *)arg1)->getScrollDelay();
    vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXApp_getBlinkSpeed(int argc, VALUE *argv, VALUE self) { FXApp *arg1 = (FXApp *) 0 ; FXuint result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXApp, 1); result = (FXuint)((FXApp const *)arg1)->getBlinkSpeed();
    vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXApp_getAnimSpeed(int argc, VALUE *argv, VALUE self) { FXApp *arg1 = (FXApp *) 0 ; FXuint result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXApp, 1); result = (FXuint)((FXApp const *)arg1)->getAnimSpeed();
    vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXApp_getMenuPause(int argc, VALUE *argv, VALUE self) { FXApp *arg1 = (FXApp *) 0 ; FXuint result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXApp, 1); result = (FXuint)((FXApp const *)arg1)->getMenuPause();
    vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXApp_getTooltipPause(int argc, VALUE *argv, VALUE self) { FXApp *arg1 = (FXApp *) 0 ; FXuint result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXApp, 1); result = (FXuint)((FXApp const *)arg1)->getTooltipPause();
    vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXApp_getTooltipTime(int argc, VALUE *argv, VALUE self) { FXApp *arg1 = (FXApp *) 0 ; FXuint result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXApp, 1); result = (FXuint)((FXApp const *)arg1)->getTooltipTime();
    vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXApp_getDragDelta(int argc, VALUE *argv, VALUE self) { FXApp *arg1 = (FXApp *) 0 ; FXint result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXApp, 1); result = (FXint)((FXApp const *)arg1)->getDragDelta();
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXApp_getWheelLines(int argc, VALUE *argv, VALUE self) { FXApp *arg1 = (FXApp *) 0 ; FXint result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXApp, 1); result = (FXint)((FXApp const *)arg1)->getWheelLines();
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXApp_setTypingSpeed(int argc, VALUE *argv, VALUE self) { FXApp *arg1 = (FXApp *) 0 ; FXuint arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXApp, 1); arg2 = NUM2UINT(argv[0]); (arg1)->setTypingSpeed(arg2);
    return Qnil; }
static VALUE _wrap_FXApp_setClickSpeed(int argc, VALUE *argv, VALUE self) { FXApp *arg1 = (FXApp *) 0 ; FXuint arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXApp, 1); arg2 = NUM2UINT(argv[0]); (arg1)->setClickSpeed(arg2);
    return Qnil; }
static VALUE _wrap_FXApp_setScrollSpeed(int argc, VALUE *argv, VALUE self) { FXApp *arg1 = (FXApp *) 0 ; FXuint arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXApp, 1); arg2 = NUM2UINT(argv[0]); (arg1)->setScrollSpeed(arg2);
    return Qnil; }
static VALUE _wrap_FXApp_setScrollDelay(int argc, VALUE *argv, VALUE self) { FXApp *arg1 = (FXApp *) 0 ; FXuint arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXApp, 1); arg2 = NUM2UINT(argv[0]); (arg1)->setScrollDelay(arg2);
    return Qnil; }
static VALUE _wrap_FXApp_setBlinkSpeed(int argc, VALUE *argv, VALUE self) { FXApp *arg1 = (FXApp *) 0 ; FXuint arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXApp, 1); arg2 = NUM2UINT(argv[0]); (arg1)->setBlinkSpeed(arg2);
    return Qnil; }
static VALUE _wrap_FXApp_setAnimSpeed(int argc, VALUE *argv, VALUE self) { FXApp *arg1 = (FXApp *) 0 ; FXuint arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXApp, 1); arg2 = NUM2UINT(argv[0]); (arg1)->setAnimSpeed(arg2);
    return Qnil; }
static VALUE _wrap_FXApp_setMenuPause(int argc, VALUE *argv, VALUE self) { FXApp *arg1 = (FXApp *) 0 ; FXuint arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXApp, 1); arg2 = NUM2UINT(argv[0]); (arg1)->setMenuPause(arg2);
    return Qnil; }
static VALUE _wrap_FXApp_setTooltipPause(int argc, VALUE *argv, VALUE self) { FXApp *arg1 = (FXApp *) 0 ; FXuint arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXApp, 1); arg2 = NUM2UINT(argv[0]); (arg1)->setTooltipPause(arg2);
    return Qnil; }
static VALUE _wrap_FXApp_setTooltipTime(int argc, VALUE *argv, VALUE self) { FXApp *arg1 = (FXApp *) 0 ; FXuint arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXApp, 1); arg2 = NUM2UINT(argv[0]); (arg1)->setTooltipTime(arg2);
    return Qnil; }
static VALUE _wrap_FXApp_setDragDelta(int argc, VALUE *argv, VALUE self) { FXApp *arg1 = (FXApp *) 0 ; FXint arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXApp, 1); arg2 = NUM2INT(argv[0]); (arg1)->setDragDelta(arg2);
    return Qnil; }
static VALUE _wrap_FXApp_setWheelLines(int argc, VALUE *argv, VALUE self) { FXApp *arg1 = (FXApp *) 0 ; FXint arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXApp, 1); arg2 = NUM2INT(argv[0]); (arg1)->setWheelLines(arg2);
    return Qnil; }
static VALUE _wrap_FXApp_getBorderColor(int argc, VALUE *argv, VALUE self) { FXApp *arg1 = (FXApp *) 0 ; FXColor result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXApp, 1); result = (FXColor)((FXApp const *)arg1)->getBorderColor();
    vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXApp_getBaseColor(int argc, VALUE *argv, VALUE self) { FXApp *arg1 = (FXApp *) 0 ; FXColor result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXApp, 1); result = (FXColor)((FXApp const *)arg1)->getBaseColor();
    vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXApp_getHiliteColor(int argc, VALUE *argv, VALUE self) { FXApp *arg1 = (FXApp *) 0 ; FXColor result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXApp, 1); result = (FXColor)((FXApp const *)arg1)->getHiliteColor();
    vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXApp_getShadowColor(int argc, VALUE *argv, VALUE self) { FXApp *arg1 = (FXApp *) 0 ; FXColor result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXApp, 1); result = (FXColor)((FXApp const *)arg1)->getShadowColor();
    vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXApp_getBackColor(int argc, VALUE *argv, VALUE self) { FXApp *arg1 = (FXApp *) 0 ; FXColor result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXApp, 1); result = (FXColor)((FXApp const *)arg1)->getBackColor();
    vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXApp_getForeColor(int argc, VALUE *argv, VALUE self) { FXApp *arg1 = (FXApp *) 0 ; FXColor result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXApp, 1); result = (FXColor)((FXApp const *)arg1)->getForeColor();
    vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXApp_getSelforeColor(int argc, VALUE *argv, VALUE self) { FXApp *arg1 = (FXApp *) 0 ; FXColor result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXApp, 1); result = (FXColor)((FXApp const *)arg1)->getSelforeColor();
    vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXApp_getSelbackColor(int argc, VALUE *argv, VALUE self) { FXApp *arg1 = (FXApp *) 0 ; FXColor result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXApp, 1); result = (FXColor)((FXApp const *)arg1)->getSelbackColor();
    vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXApp_getTipforeColor(int argc, VALUE *argv, VALUE self) { FXApp *arg1 = (FXApp *) 0 ; FXColor result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXApp, 1); result = (FXColor)((FXApp const *)arg1)->getTipforeColor();
    vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXApp_getTipbackColor(int argc, VALUE *argv, VALUE self) { FXApp *arg1 = (FXApp *) 0 ; FXColor result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXApp, 1); result = (FXColor)((FXApp const *)arg1)->getTipbackColor();
    vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXApp_setBorderColor(int argc, VALUE *argv, VALUE self) { FXApp *arg1 = (FXApp *) 0 ; FXColor arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXApp, 1); arg2 = to_FXColor(argv[0]); (arg1)->setBorderColor(arg2);
    return Qnil; }
static VALUE _wrap_FXApp_setBaseColor(int argc, VALUE *argv, VALUE self) { FXApp *arg1 = (FXApp *) 0 ; FXColor arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXApp, 1); arg2 = to_FXColor(argv[0]); (arg1)->setBaseColor(arg2);
    return Qnil; }
static VALUE _wrap_FXApp_setHiliteColor(int argc, VALUE *argv, VALUE self) { FXApp *arg1 = (FXApp *) 0 ; FXColor arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXApp, 1); arg2 = to_FXColor(argv[0]); (arg1)->setHiliteColor(arg2);
    return Qnil; }
static VALUE _wrap_FXApp_setShadowColor(int argc, VALUE *argv, VALUE self) { FXApp *arg1 = (FXApp *) 0 ; FXColor arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXApp, 1); arg2 = to_FXColor(argv[0]); (arg1)->setShadowColor(arg2);
    return Qnil; }
static VALUE _wrap_FXApp_setBackColor(int argc, VALUE *argv, VALUE self) { FXApp *arg1 = (FXApp *) 0 ; FXColor arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXApp, 1); arg2 = to_FXColor(argv[0]); (arg1)->setBackColor(arg2);
    return Qnil; }
static VALUE _wrap_FXApp_setForeColor(int argc, VALUE *argv, VALUE self) { FXApp *arg1 = (FXApp *) 0 ; FXColor arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXApp, 1); arg2 = to_FXColor(argv[0]); (arg1)->setForeColor(arg2);
    return Qnil; }
static VALUE _wrap_FXApp_setSelforeColor(int argc, VALUE *argv, VALUE self) { FXApp *arg1 = (FXApp *) 0 ; FXColor arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXApp, 1); arg2 = to_FXColor(argv[0]); (arg1)->setSelforeColor(arg2);
    return Qnil; }
static VALUE _wrap_FXApp_setSelbackColor(int argc, VALUE *argv, VALUE self) { FXApp *arg1 = (FXApp *) 0 ; FXColor arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXApp, 1); arg2 = to_FXColor(argv[0]); (arg1)->setSelbackColor(arg2);
    return Qnil; }
static VALUE _wrap_FXApp_setTipforeColor(int argc, VALUE *argv, VALUE self) { FXApp *arg1 = (FXApp *) 0 ; FXColor arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXApp, 1); arg2 = to_FXColor(argv[0]); (arg1)->setTipforeColor(arg2);
    return Qnil; }
static VALUE _wrap_FXApp_setTipbackColor(int argc, VALUE *argv, VALUE self) { FXApp *arg1 = (FXApp *) 0 ; FXColor arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXApp, 1); arg2 = to_FXColor(argv[0]); (arg1)->setTipbackColor(arg2);
    return Qnil; }
static VALUE _wrap_FXApp_dumpWidgets(int argc, VALUE *argv, VALUE self) { FXApp *arg1 = (FXApp *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXApp, 1); ((FXApp const *)arg1)->dumpWidgets(); return Qnil; }
static void
free_FXApp(FXApp *arg1) {
    delete arg1;
}
static VALUE _wrap_FXApp_save(int argc, VALUE *argv, VALUE self) { FXApp *arg1 = (FXApp *) 0 ; FXStream *arg2 = 0 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXApp, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXApp_save((FXApp const *)arg1,*arg2); return Qnil; }
static VALUE _wrap_FXApp_load(int argc, VALUE *argv, VALUE self) { FXApp *arg1 = (FXApp *) 0 ; FXStream *arg2 = 0 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXApp, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXApp_load(arg1,*arg2); return Qnil; }
static VALUE _wrap_FXApp_create(int argc, VALUE *argv, VALUE self) { FXApp *arg1 = (FXApp *) 0 ; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc); SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXApp, 1);
    FXApp_create(arg1); return Qnil; }
static VALUE _wrap_FXApp_destroy(int argc, VALUE *argv, VALUE self) { FXApp *arg1 = (FXApp *) 0 ; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc); SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXApp, 1);
    FXApp_destroy(arg1); return Qnil; }
static VALUE _wrap_FXApp_detach(int argc, VALUE *argv, VALUE self) { FXApp *arg1 = (FXApp *) 0 ; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc); SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXApp, 1);
    FXApp_detach(arg1); return Qnil; }
static VALUE _wrap_FXApp_init(int argc, VALUE *argv, VALUE self) { FXApp *arg1 = (FXApp *) 0 ; VALUE arg2 ;
    FXbool arg3 = (FXbool) 1 ; if ((argc < 1) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXApp, 1); arg2 = argv[0]; if (argc > 1) { arg3 = to_FXbool(argv[1]); } 
    FXApp_init(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXApp_exit(int argc, VALUE *argv, VALUE self) { FXApp *arg1 = (FXApp *) 0 ; FXint arg2 = (FXint) 0 ;
    if ((argc < 0) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXApp, 1); if (argc > 0) { arg2 = NUM2INT(argv[0]); } 
    FXApp_exit(arg1,arg2); return Qnil; }
static VALUE _wrap_FXApp_threadsEnablede___(int argc, VALUE *argv, VALUE self) { FXApp *arg1 = (FXApp *) 0 ; FXbool arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXApp, 1); arg2 = to_FXbool(argv[0]); FXApp_setThreadsEnabled(arg1,arg2);
    return Qnil; }
static VALUE _wrap_FXApp_threadsEnabledq___(int argc, VALUE *argv, VALUE self) { FXApp *arg1 = (FXApp *) 0 ; FXbool result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXApp, 1); result = (FXbool)FXApp_threadsEnabled((FXApp const *)arg1);
    vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXApp_setSleepTime(int argc, VALUE *argv, VALUE self) { FXApp *arg1 = (FXApp *) 0 ; FXuint arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXApp, 1); arg2 = NUM2UINT(argv[0]); FXApp_setSleepTime(arg1,arg2);
    return Qnil; }
static VALUE _wrap_FXApp_getSleepTime(int argc, VALUE *argv, VALUE self) { FXApp *arg1 = (FXApp *) 0 ; FXuint result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXApp, 1); result = (FXuint)FXApp_getSleepTime((FXApp const *)arg1);
    vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXDataTarget_onCmdValue(int argc, VALUE *argv, VALUE self) { FXDataTarget *arg1 = (FXDataTarget *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDataTarget, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdValue(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXDataTarget_onUpdValue(int argc, VALUE *argv, VALUE self) { FXDataTarget *arg1 = (FXDataTarget *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDataTarget, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onUpdValue(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXDataTarget_onCmdOption(int argc, VALUE *argv, VALUE self) { FXDataTarget *arg1 = (FXDataTarget *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDataTarget, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdOption(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXDataTarget_onUpdOption(int argc, VALUE *argv, VALUE self) { FXDataTarget *arg1 = (FXDataTarget *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDataTarget, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onUpdOption(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE _wrap_FXDataTarget_allocate(VALUE self) {
#else
     static VALUE _wrap_FXDataTarget_allocate(int argc, VALUE *argv, VALUE self) {
#endif
         VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_FXDataTarget);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
         return vresult; }
static VALUE _wrap_new_FXDataTarget(int argc, VALUE *argv, VALUE self) { VALUE arg1 = (VALUE) Qnil ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 = (FXSelector) 0 ; FXDataTarget *result; if ((argc < 0) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc); if (argc > 0) { arg1 = argv[0]; }  if (argc > 1) {
        SWIG_ConvertPtr(argv[1], (void **) &arg2, SWIGTYPE_p_FXObject, 1); }  if (argc > 2) { arg3 = NUM2UINT(argv[2]); }  {
        result = (FXDataTarget *)new_FXDataTarget(arg1,arg2,arg3); DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result);
        if(rb_block_given_p()){ rb_yield(self); }  }  return self; }
static VALUE _wrap_FXDataTarget_setTarget(int argc, VALUE *argv, VALUE self) { FXDataTarget *arg1 = (FXDataTarget *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDataTarget, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); (arg1)->setTarget(arg2); return Qnil; }
static VALUE _wrap_FXDataTarget_getTarget(int argc, VALUE *argv, VALUE self) { FXDataTarget *arg1 = (FXDataTarget *) 0 ;
    FXObject *result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDataTarget, 1);
    result = (FXObject *)((FXDataTarget const *)arg1)->getTarget(); {
        swig_type_info *ty = SWIG_TypeDynamicCast(SWIGTYPE_p_FXObject, (void **) &result);
        vresult = FXRbGetRubyObj(result, ty); }  return vresult; }
static VALUE _wrap_FXDataTarget_setSelector(int argc, VALUE *argv, VALUE self) { FXDataTarget *arg1 = (FXDataTarget *) 0 ;
    FXSelector arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDataTarget, 1); arg2 = NUM2UINT(argv[0]); (arg1)->setSelector(arg2);
    return Qnil; }
static VALUE _wrap_FXDataTarget_getSelector(int argc, VALUE *argv, VALUE self) { FXDataTarget *arg1 = (FXDataTarget *) 0 ;
    FXSelector result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDataTarget, 1);
    result = (FXSelector)((FXDataTarget const *)arg1)->getSelector(); vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXDataTarget_getType(int argc, VALUE *argv, VALUE self) { FXDataTarget *arg1 = (FXDataTarget *) 0 ;
    FXuint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDataTarget, 1);
    result = (FXuint)((FXDataTarget const *)arg1)->getType(); vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXDataTarget_getValue(int argc, VALUE *argv, VALUE self) { FXDataTarget *arg1 = (FXDataTarget *) 0 ;
    VALUE result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDataTarget, 1);
    result = (VALUE)FXDataTarget_getValue((FXDataTarget const *)arg1); vresult = result; return vresult; }
static VALUE _wrap_FXDataTarget_setValue(int argc, VALUE *argv, VALUE self) { FXDataTarget *arg1 = (FXDataTarget *) 0 ;
    VALUE arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDataTarget, 1); arg2 = argv[0]; FXDataTarget_setValue(arg1,arg2);
    return Qnil; }
static void
free_FXDataTarget(FXDataTarget *arg1) {
    delete arg1;
}
static VALUE _wrap_FXDataTarget_save(int argc, VALUE *argv, VALUE self) { FXDataTarget *arg1 = (FXDataTarget *) 0 ;
    FXStream *arg2 = 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDataTarget, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXDataTarget_save((FXDataTarget const *)arg1,*arg2); return Qnil; }
static VALUE _wrap_FXDataTarget_load(int argc, VALUE *argv, VALUE self) { FXDataTarget *arg1 = (FXDataTarget *) 0 ;
    FXStream *arg2 = 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDataTarget, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXDataTarget_load(arg1,*arg2); return Qnil; }
static VALUE _wrap_FXDebugTarget_messageTypeName(int argc, VALUE *argv, VALUE self) { VALUE result; VALUE vresult = Qnil;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    result = (VALUE)FXDebugTarget_messageTypeName(); vresult = result; return vresult; }
static VALUE _wrap_FXDebugTarget_onMessage(int argc, VALUE *argv, VALUE self) { FXDebugTarget *arg1 = (FXDebugTarget *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDebugTarget, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onMessage(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE _wrap_FXDebugTarget_allocate(VALUE self) {
#else
     static VALUE _wrap_FXDebugTarget_allocate(int argc, VALUE *argv, VALUE self) {
#endif
         VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_FXDebugTarget);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
         return vresult; }
static VALUE _wrap_new_FXDebugTarget(int argc, VALUE *argv, VALUE self) { FXDebugTarget *result; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc); { result = (FXDebugTarget *)new_FXDebugTarget();
        DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result); if(rb_block_given_p()){ rb_yield(self); }  }  return self; }
static VALUE _wrap_FXDebugTarget_save(int argc, VALUE *argv, VALUE self) { FXDebugTarget *arg1 = (FXDebugTarget *) 0 ;
    FXStream *arg2 = 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDebugTarget, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXDebugTarget_save((FXDebugTarget const *)arg1,*arg2); return Qnil; }
static VALUE _wrap_FXDebugTarget_load(int argc, VALUE *argv, VALUE self) { FXDebugTarget *arg1 = (FXDebugTarget *) 0 ;
    FXStream *arg2 = 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDebugTarget, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXDebugTarget_load(arg1,*arg2); return Qnil; }
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE _wrap_FXDelegator_allocate(VALUE self) {
#else
     static VALUE _wrap_FXDelegator_allocate(int argc, VALUE *argv, VALUE self) {
#endif
         VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_FXDelegator);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
         return vresult; }
static VALUE _wrap_new_FXDelegator(int argc, VALUE *argv, VALUE self) { FXObject *arg1 = (FXObject *) 0 ; FXDelegator *result;
    if ((argc < 0) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc); if (argc > 0) {
        SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXObject, 1); }  { result = (FXDelegator *)new_FXDelegator(arg1);
        DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result); if(rb_block_given_p()){ rb_yield(self); }  }  return self; }
static VALUE _wrap_FXDelegator_getDelegate(int argc, VALUE *argv, VALUE self) { FXDelegator *arg1 = (FXDelegator *) 0 ;
    FXObject *result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDelegator, 1);
    result = (FXObject *)((FXDelegator const *)arg1)->getDelegate(); {
        swig_type_info *ty = SWIG_TypeDynamicCast(SWIGTYPE_p_FXObject, (void **) &result);
        vresult = FXRbGetRubyObj(result, ty); }  return vresult; }
static VALUE _wrap_FXDelegator_setDelegate(int argc, VALUE *argv, VALUE self) { FXDelegator *arg1 = (FXDelegator *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDelegator, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); (arg1)->setDelegate(arg2); return Qnil; }
static void
free_FXDelegator(FXDelegator *arg1) {
    delete arg1;
}
static VALUE _wrap_FXDelegator_save(int argc, VALUE *argv, VALUE self) { FXDelegator *arg1 = (FXDelegator *) 0 ;
    FXStream *arg2 = 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDelegator, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXDelegator_save((FXDelegator const *)arg1,*arg2); return Qnil; }
static VALUE _wrap_FXDelegator_load(int argc, VALUE *argv, VALUE self) { FXDelegator *arg1 = (FXDelegator *) 0 ;
    FXStream *arg2 = 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDelegator, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXDelegator_load(arg1,*arg2); return Qnil; }
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE _wrap_FXDict_allocate(VALUE self) {
#else
     static VALUE _wrap_FXDict_allocate(int argc, VALUE *argv, VALUE self) {
#endif
         VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_FXDict);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
         return vresult; }
static VALUE _wrap_new_FXDict(int argc, VALUE *argv, VALUE self) { FXDict *result; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc); { result = (FXDict *)new_FXDict();
        DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result); if(rb_block_given_p()){ rb_yield(self); }  }  return self; }
static VALUE _wrap_FXDict_getTotalSize(int argc, VALUE *argv, VALUE self) { FXDict *arg1 = (FXDict *) 0 ; FXint result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDict, 1); result = (FXint)((FXDict const *)arg1)->size();
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXDict_setTotalSize(int argc, VALUE *argv, VALUE self) { FXDict *arg1 = (FXDict *) 0 ; FXint arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDict, 1); arg2 = NUM2INT(argv[0]); (arg1)->size(arg2); return Qnil; }
static VALUE _wrap_FXDict_length(int argc, VALUE *argv, VALUE self) { FXDict *arg1 = (FXDict *) 0 ; FXint result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDict, 1); result = (FXint)((FXDict const *)arg1)->no();
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXDict_remove(int argc, VALUE *argv, VALUE self) { FXDict *arg1 = (FXDict *) 0 ; FXchar *arg2 ; void *result;
    VALUE vresult = Qnil; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDict, 1); arg2 = StringValuePtr(argv[0]);
    result = (void *)(arg1)->remove((FXchar const *)arg2); vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_void,0);
    return vresult; }
static VALUE _wrap_FXDict_key(int argc, VALUE *argv, VALUE self) { FXDict *arg1 = (FXDict *) 0 ; FXuint arg2 ; FXchar *result;
    VALUE vresult = Qnil; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDict, 1); arg2 = NUM2UINT(argv[0]);
    result = (FXchar *)((FXDict const *)arg1)->key(arg2); vresult = rb_str_new2(result); return vresult; }
static VALUE _wrap_FXDict_mark(int argc, VALUE *argv, VALUE self) { FXDict *arg1 = (FXDict *) 0 ; FXuint arg2 ; FXbool result;
    VALUE vresult = Qnil; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDict, 1); arg2 = NUM2UINT(argv[0]);
    result = (FXbool)((FXDict const *)arg1)->mark(arg2); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXDict_first(int argc, VALUE *argv, VALUE self) { FXDict *arg1 = (FXDict *) 0 ; FXint result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDict, 1); result = (FXint)((FXDict const *)arg1)->first();
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXDict_last(int argc, VALUE *argv, VALUE self) { FXDict *arg1 = (FXDict *) 0 ; FXint result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDict, 1); result = (FXint)((FXDict const *)arg1)->last();
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXDict_next(int argc, VALUE *argv, VALUE self) { FXDict *arg1 = (FXDict *) 0 ; FXint arg2 ; FXint result;
    VALUE vresult = Qnil; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDict, 1); arg2 = NUM2INT(argv[0]);
    result = (FXint)((FXDict const *)arg1)->next(arg2); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXDict_prev(int argc, VALUE *argv, VALUE self) { FXDict *arg1 = (FXDict *) 0 ; FXint arg2 ; FXint result;
    VALUE vresult = Qnil; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDict, 1); arg2 = NUM2INT(argv[0]);
    result = (FXint)((FXDict const *)arg1)->prev(arg2); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXDict_clear(int argc, VALUE *argv, VALUE self) { FXDict *arg1 = (FXDict *) 0 ; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc); SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDict, 1);
    (arg1)->clear(); return Qnil; }
static VALUE _wrap_FXDict_has_keyq___(int argc, VALUE *argv, VALUE self) { FXDict *arg1 = (FXDict *) 0 ; FXchar *arg2 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc); SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDict, 1);
    arg2 = StringValuePtr(argv[0]); result = (FXbool)FXDict_has_key((FXDict const *)arg1,(FXchar const *)arg2);
    vresult = (result ? Qtrue : Qfalse); return vresult; }
static void
free_FXDict(FXDict *arg1) {
    delete arg1;
}
static VALUE _wrap_FXDict_save(int argc, VALUE *argv, VALUE self) { FXDict *arg1 = (FXDict *) 0 ; FXStream *arg2 = 0 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDict, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXDict_save((FXDict const *)arg1,*arg2); return Qnil; }
static VALUE _wrap_FXDict_load(int argc, VALUE *argv, VALUE self) { FXDict *arg1 = (FXDict *) 0 ; FXStream *arg2 = 0 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDict, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXDict_load(arg1,*arg2); return Qnil; }
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE _wrap_FXFileAssoc_allocate(VALUE self) {
#else
     static VALUE _wrap_FXFileAssoc_allocate(int argc, VALUE *argv, VALUE self) {
#endif
         VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_FXFileAssoc);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
         return vresult; }
static VALUE _wrap_new_FXFileAssoc(int argc, VALUE *argv, VALUE self) { FXFileAssoc *result; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc); result = (FXFileAssoc *)new FXFileAssoc();
    DATA_PTR(self) = result; return self; }
static VALUE _wrap_FXFileAssoc_command_set(int argc, VALUE *argv, VALUE self) { FXFileAssoc *arg1 = (FXFileAssoc *) 0 ;
    FXString arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileAssoc, 1); arg2 = to_FXString(argv[0]);
    if (arg1) (arg1)->command = arg2; return Qnil; }
static VALUE _wrap_FXFileAssoc_command_get(int argc, VALUE *argv, VALUE self) { FXFileAssoc *arg1 = (FXFileAssoc *) 0 ;
    FXString result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileAssoc, 1); result =  ((arg1)->command);
    vresult = rb_str_new2((&result)->text()); return vresult; }
static VALUE _wrap_FXFileAssoc_extension_set(int argc, VALUE *argv, VALUE self) { FXFileAssoc *arg1 = (FXFileAssoc *) 0 ;
    FXString arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileAssoc, 1); arg2 = to_FXString(argv[0]);
    if (arg1) (arg1)->extension = arg2; return Qnil; }
static VALUE _wrap_FXFileAssoc_extension_get(int argc, VALUE *argv, VALUE self) { FXFileAssoc *arg1 = (FXFileAssoc *) 0 ;
    FXString result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileAssoc, 1); result =  ((arg1)->extension);
    vresult = rb_str_new2((&result)->text()); return vresult; }
static VALUE _wrap_FXFileAssoc_mimetype_set(int argc, VALUE *argv, VALUE self) { FXFileAssoc *arg1 = (FXFileAssoc *) 0 ;
    FXString arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileAssoc, 1); arg2 = to_FXString(argv[0]);
    if (arg1) (arg1)->mimetype = arg2; return Qnil; }
static VALUE _wrap_FXFileAssoc_mimetype_get(int argc, VALUE *argv, VALUE self) { FXFileAssoc *arg1 = (FXFileAssoc *) 0 ;
    FXString result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileAssoc, 1); result =  ((arg1)->mimetype);
    vresult = rb_str_new2((&result)->text()); return vresult; }
static VALUE _wrap_FXFileAssoc_bigicon_set(int argc, VALUE *argv, VALUE self) { FXFileAssoc *arg1 = (FXFileAssoc *) 0 ;
    FXIcon *arg2 = (FXIcon *) 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileAssoc, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXIcon, 1); if (arg1) (arg1)->bigicon = arg2; return Qnil; }
static VALUE _wrap_FXFileAssoc_bigicon_get(int argc, VALUE *argv, VALUE self) { FXFileAssoc *arg1 = (FXFileAssoc *) 0 ;
    FXIcon *result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileAssoc, 1); result = (FXIcon *) ((arg1)->bigicon); {
        swig_type_info *ty = SWIG_TypeDynamicCast(SWIGTYPE_p_FXIcon, (void **) &result); vresult = FXRbGetRubyObj(result, ty); }
     return vresult; }
static VALUE _wrap_FXFileAssoc_bigiconopen_set(int argc, VALUE *argv, VALUE self) { FXFileAssoc *arg1 = (FXFileAssoc *) 0 ;
    FXIcon *arg2 = (FXIcon *) 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileAssoc, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXIcon, 1); if (arg1) (arg1)->bigiconopen = arg2; return Qnil; }
static VALUE _wrap_FXFileAssoc_bigiconopen_get(int argc, VALUE *argv, VALUE self) { FXFileAssoc *arg1 = (FXFileAssoc *) 0 ;
    FXIcon *result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileAssoc, 1); result = (FXIcon *) ((arg1)->bigiconopen); {
        swig_type_info *ty = SWIG_TypeDynamicCast(SWIGTYPE_p_FXIcon, (void **) &result); vresult = FXRbGetRubyObj(result, ty); }
     return vresult; }
static VALUE _wrap_FXFileAssoc_miniicon_set(int argc, VALUE *argv, VALUE self) { FXFileAssoc *arg1 = (FXFileAssoc *) 0 ;
    FXIcon *arg2 = (FXIcon *) 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileAssoc, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXIcon, 1); if (arg1) (arg1)->miniicon = arg2; return Qnil; }
static VALUE _wrap_FXFileAssoc_miniicon_get(int argc, VALUE *argv, VALUE self) { FXFileAssoc *arg1 = (FXFileAssoc *) 0 ;
    FXIcon *result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileAssoc, 1); result = (FXIcon *) ((arg1)->miniicon); {
        swig_type_info *ty = SWIG_TypeDynamicCast(SWIGTYPE_p_FXIcon, (void **) &result); vresult = FXRbGetRubyObj(result, ty); }
     return vresult; }
static VALUE _wrap_FXFileAssoc_miniiconopen_set(int argc, VALUE *argv, VALUE self) { FXFileAssoc *arg1 = (FXFileAssoc *) 0 ;
    FXIcon *arg2 = (FXIcon *) 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileAssoc, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXIcon, 1); if (arg1) (arg1)->miniiconopen = arg2; return Qnil; }
static VALUE _wrap_FXFileAssoc_miniiconopen_get(int argc, VALUE *argv, VALUE self) { FXFileAssoc *arg1 = (FXFileAssoc *) 0 ;
    FXIcon *result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileAssoc, 1); result = (FXIcon *) ((arg1)->miniiconopen); {
        swig_type_info *ty = SWIG_TypeDynamicCast(SWIGTYPE_p_FXIcon, (void **) &result); vresult = FXRbGetRubyObj(result, ty); }
     return vresult; }
static VALUE _wrap_FXFileAssoc_dragtype_set(int argc, VALUE *argv, VALUE self) { FXFileAssoc *arg1 = (FXFileAssoc *) 0 ;
    FXDragType arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileAssoc, 1); arg2 = NUM2UINT(argv[0]);
    if (arg1) (arg1)->dragtype = arg2; return Qnil; }
static VALUE _wrap_FXFileAssoc_dragtype_get(int argc, VALUE *argv, VALUE self) { FXFileAssoc *arg1 = (FXFileAssoc *) 0 ;
    FXDragType result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileAssoc, 1); result = (FXDragType) ((arg1)->dragtype);
    vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXFileAssoc_flags_set(int argc, VALUE *argv, VALUE self) { FXFileAssoc *arg1 = (FXFileAssoc *) 0 ;
    FXuint arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileAssoc, 1); arg2 = NUM2UINT(argv[0]); if (arg1) (arg1)->flags = arg2;
    return Qnil; }
static VALUE _wrap_FXFileAssoc_flags_get(int argc, VALUE *argv, VALUE self) { FXFileAssoc *arg1 = (FXFileAssoc *) 0 ;
    FXuint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileAssoc, 1); result = (FXuint) ((arg1)->flags);
    vresult = UINT2NUM(result); return vresult; }
static void
free_FXFileAssoc(FXFileAssoc *arg1) {
    delete arg1;
}
static VALUE _wrap_FXIconDict_defaultIconPath(int argc, VALUE *argv, VALUE self) { VALUE result; VALUE vresult = Qnil;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    result = (VALUE)FXIconDict_defaultIconPath(); vresult = result; return vresult; }
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE _wrap_FXIconDict_allocate(VALUE self) {
#else
     static VALUE _wrap_FXIconDict_allocate(int argc, VALUE *argv, VALUE self) {
#endif
         VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_FXIconDict);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
         return vresult; }
static VALUE _wrap_new_FXIconDict(int argc, VALUE *argv, VALUE self) { FXApp *arg1 = (FXApp *) 0 ;
    FXString const &arg2_defvalue = FXIconDict::defaultIconPath ; FXString *arg2 = (FXString *) &arg2_defvalue ;
    FXIconDict *result; SwigValueWrapper<FXString > p2 ; if ((argc < 1) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXApp, 1); if (argc > 1) { p2 = to_FXString(argv[1]); arg2 = &p2; }  {
        result = (FXIconDict *)new_FXIconDict(arg1,(FXString const &)*arg2);
        DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result); if(rb_block_given_p()){ rb_yield(self); }  }  return self; }
static VALUE _wrap_FXIconDict_getApp(int argc, VALUE *argv, VALUE self) { FXIconDict *arg1 = (FXIconDict *) 0 ; FXApp *result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXIconDict, 1); result = (FXApp *)((FXIconDict const *)arg1)->getApp(); {
        swig_type_info *ty = SWIG_TypeDynamicCast(SWIGTYPE_p_FXApp, (void **) &result); vresult = FXRbGetRubyObj(result, ty); } 
    return vresult; }
static VALUE _wrap_FXIconDict_setIconPath(int argc, VALUE *argv, VALUE self) { FXIconDict *arg1 = (FXIconDict *) 0 ;
    FXString *arg2 = 0 ; SwigValueWrapper<FXString > p2 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXIconDict, 1); p2 = to_FXString(argv[0]); arg2 = &p2;
    (arg1)->setIconPath((FXString const &)*arg2); return Qnil; }
static VALUE _wrap_FXIconDict_getIconPath(int argc, VALUE *argv, VALUE self) { FXIconDict *arg1 = (FXIconDict *) 0 ;
    FXString result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXIconDict, 1); result = ((FXIconDict const *)arg1)->getIconPath();
    vresult = rb_str_new2((&result)->text()); return vresult; }
static VALUE _wrap_FXIconDict_insert(int argc, VALUE *argv, VALUE self) { FXIconDict *arg1 = (FXIconDict *) 0 ; FXchar *arg2 ;
    FXIcon *result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXIconDict, 1); arg2 = StringValuePtr(argv[0]);
    result = (FXIcon *)(arg1)->insert((FXchar const *)arg2); {
        swig_type_info *ty = SWIG_TypeDynamicCast(SWIGTYPE_p_FXIcon, (void **) &result); vresult = FXRbGetRubyObj(result, ty); }
     return vresult; }
static VALUE _wrap_FXIconDict_remove(int argc, VALUE *argv, VALUE self) { FXIconDict *arg1 = (FXIconDict *) 0 ; FXchar *arg2 ;
    FXIcon *result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXIconDict, 1); arg2 = StringValuePtr(argv[0]);
    result = (FXIcon *)(arg1)->remove((FXchar const *)arg2); {
        swig_type_info *ty = SWIG_TypeDynamicCast(SWIGTYPE_p_FXIcon, (void **) &result); vresult = FXRbGetRubyObj(result, ty); }
     return vresult; }
static VALUE _wrap_FXIconDict_find(int argc, VALUE *argv, VALUE self) { FXIconDict *arg1 = (FXIconDict *) 0 ; FXchar *arg2 ;
    FXIcon *result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXIconDict, 1); arg2 = StringValuePtr(argv[0]);
    result = (FXIcon *)(arg1)->find((FXchar const *)arg2); {
        swig_type_info *ty = SWIG_TypeDynamicCast(SWIGTYPE_p_FXIcon, (void **) &result); vresult = FXRbGetRubyObj(result, ty); }
     return vresult; }
static void
free_FXIconDict(FXIconDict *arg1) {
    delete arg1;
}
static VALUE _wrap_FXIconDict_save(int argc, VALUE *argv, VALUE self) { FXIconDict *arg1 = (FXIconDict *) 0 ;
    FXStream *arg2 = 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXIconDict, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXIconDict_save((FXIconDict const *)arg1,*arg2); return Qnil; }
static VALUE _wrap_FXIconDict_load(int argc, VALUE *argv, VALUE self) { FXIconDict *arg1 = (FXIconDict *) 0 ;
    FXStream *arg2 = 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXIconDict, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXIconDict_load(arg1,*arg2); return Qnil; }
static VALUE _wrap_FXFileDict_defaultExecBinding(int argc, VALUE *argv, VALUE self) { VALUE result; VALUE vresult = Qnil;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    result = (VALUE)FXFileDict_defaultExecBinding(); vresult = result; return vresult; }
static VALUE _wrap_FXFileDict_defaultDirBinding(int argc, VALUE *argv, VALUE self) { VALUE result; VALUE vresult = Qnil;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    result = (VALUE)FXFileDict_defaultDirBinding(); vresult = result; return vresult; }
static VALUE _wrap_FXFileDict_defaultFileBinding(int argc, VALUE *argv, VALUE self) { VALUE result; VALUE vresult = Qnil;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    result = (VALUE)FXFileDict_defaultFileBinding(); vresult = result; return vresult; }
static VALUE _wrap_new_FXFileDict__SWIG_0(int argc, VALUE *argv, VALUE self) { FXApp *arg1 = (FXApp *) 0 ; FXFileDict *result;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXApp, 1); { result = (FXFileDict *)new_FXFileDict__SWIG_0(arg1);
        DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result); if(rb_block_given_p()){ rb_yield(self); }  }  return self; }
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE _wrap_FXFileDict_allocate(VALUE self) {
#else
     static VALUE _wrap_FXFileDict_allocate(int argc, VALUE *argv, VALUE self) {
#endif
         VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_FXFileDict);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
         return vresult; }
static VALUE _wrap_new_FXFileDict__SWIG_1(int argc, VALUE *argv, VALUE self) { FXApp *arg1 = (FXApp *) 0 ;
    FXSettings *arg2 = (FXSettings *) 0 ; FXFileDict *result; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXApp, 1);
    SWIG_ConvertPtr(argv[1], (void **) &arg2, SWIGTYPE_p_FXSettings, 1); {
        result = (FXFileDict *)new_FXFileDict__SWIG_1(arg1,arg2); DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result);
        if(rb_block_given_p()){ rb_yield(self); }  }  return self; }
static VALUE _wrap_new_FXFileDict(int nargs, VALUE *args, VALUE self) { int argc; VALUE argv[2]; int ii; argc = nargs;
    for (ii = 0; (ii < argc) && (ii < 2); ii++) { argv[ii] = args[ii]; }  if (argc == 1) { int _v; { void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXApp, 0) != -1)) ? 1 : 0; }
         if (_v) { return _wrap_new_FXFileDict__SWIG_0(nargs, args, self);}  }  if (argc == 2) { int _v; { void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXApp, 0) != -1)) ? 1 : 0; }
         if (_v) { { void *ptr;
                _v = (NIL_P(argv[1]) || (TYPE(argv[1]) == T_DATA && SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_FXSettings, 0) != -1)) ? 1 : 0; }
             if (_v) { return _wrap_new_FXFileDict__SWIG_1(nargs, args, self);}  }  } 
    rb_raise(rb_eArgError, "No matching function for overloaded 'new_FXFileDict'"); return Qnil; }
static VALUE _wrap_FXFileDict_getApp(int argc, VALUE *argv, VALUE self) { FXFileDict *arg1 = (FXFileDict *) 0 ; FXApp *result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileDict, 1); result = (FXApp *)((FXFileDict const *)arg1)->getApp(); {
        swig_type_info *ty = SWIG_TypeDynamicCast(SWIGTYPE_p_FXApp, (void **) &result); vresult = FXRbGetRubyObj(result, ty); } 
    return vresult; }
static VALUE _wrap_FXFileDict_setIconPath(int argc, VALUE *argv, VALUE self) { FXFileDict *arg1 = (FXFileDict *) 0 ;
    FXString *arg2 = 0 ; SwigValueWrapper<FXString > p2 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileDict, 1); p2 = to_FXString(argv[0]); arg2 = &p2;
    (arg1)->setIconPath((FXString const &)*arg2); return Qnil; }
static VALUE _wrap_FXFileDict_getIconPath(int argc, VALUE *argv, VALUE self) { FXFileDict *arg1 = (FXFileDict *) 0 ;
    FXString result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileDict, 1); result = ((FXFileDict const *)arg1)->getIconPath();
    vresult = rb_str_new2((&result)->text()); return vresult; }
static VALUE _wrap_FXFileDict_replace(int argc, VALUE *argv, VALUE self) { FXFileDict *arg1 = (FXFileDict *) 0 ; FXchar *arg2 ;
    FXchar *arg3 ; FXFileAssoc *result; VALUE vresult = Qnil; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileDict, 1); arg2 = StringValuePtr(argv[0]);
    arg3 = StringValuePtr(argv[1]); result = (FXFileAssoc *)(arg1)->replace((FXchar const *)arg2,(FXchar const *)arg3);
    vresult = FXRbGetRubyObj(result, "FXFileAssoc *"); return vresult; }
static VALUE _wrap_FXFileDict_remove(int argc, VALUE *argv, VALUE self) { FXFileDict *arg1 = (FXFileDict *) 0 ; FXchar *arg2 ;
    FXFileAssoc *result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileDict, 1); arg2 = StringValuePtr(argv[0]);
    result = (FXFileAssoc *)(arg1)->remove((FXchar const *)arg2); vresult = FXRbGetRubyObj(result, "FXFileAssoc *");
    return vresult; }
static VALUE _wrap_FXFileDict_find(int argc, VALUE *argv, VALUE self) { FXFileDict *arg1 = (FXFileDict *) 0 ; FXchar *arg2 ;
    FXFileAssoc *result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileDict, 1); arg2 = StringValuePtr(argv[0]);
    result = (FXFileAssoc *)(arg1)->find((FXchar const *)arg2); vresult = FXRbGetRubyObj(result, "FXFileAssoc *");
    return vresult; }
static VALUE _wrap_FXFileDict_associate(int argc, VALUE *argv, VALUE self) { FXFileDict *arg1 = (FXFileDict *) 0 ;
    FXchar *arg2 ; FXFileAssoc *result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileDict, 1); arg2 = StringValuePtr(argv[0]);
    result = (FXFileAssoc *)(arg1)->associate((FXchar const *)arg2); vresult = FXRbGetRubyObj(result, "FXFileAssoc *");
    return vresult; }
static void
free_FXFileDict(FXFileDict *arg1) {
    delete arg1;
}
static VALUE _wrap_FXFileDict_save(int argc, VALUE *argv, VALUE self) { FXFileDict *arg1 = (FXFileDict *) 0 ;
    FXStream *arg2 = 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileDict, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXFileDict_save((FXFileDict const *)arg1,*arg2); return Qnil; }
static VALUE _wrap_FXFileDict_load(int argc, VALUE *argv, VALUE self) { FXFileDict *arg1 = (FXFileDict *) 0 ;
    FXStream *arg2 = 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileDict, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXFileDict_load(arg1,*arg2); return Qnil; }
static VALUE _wrap_FXFileDict_findFileBinding(int argc, VALUE *argv, VALUE self) { FXFileDict *arg1 = (FXFileDict *) 0 ;
    FXchar *arg2 ; FXFileAssoc *result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileDict, 1); arg2 = StringValuePtr(argv[0]);
    result = (FXFileAssoc *)FXFileDict_findFileBinding(arg1,(FXchar const *)arg2);
    vresult = FXRbGetRubyObj(result, "FXFileAssoc *"); return vresult; }
static VALUE _wrap_FXFileDict_findDirBinding(int argc, VALUE *argv, VALUE self) { FXFileDict *arg1 = (FXFileDict *) 0 ;
    FXchar *arg2 ; FXFileAssoc *result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileDict, 1); arg2 = StringValuePtr(argv[0]);
    result = (FXFileAssoc *)FXFileDict_findDirBinding(arg1,(FXchar const *)arg2);
    vresult = FXRbGetRubyObj(result, "FXFileAssoc *"); return vresult; }
static VALUE _wrap_FXFileDict_findExecBinding(int argc, VALUE *argv, VALUE self) { FXFileDict *arg1 = (FXFileDict *) 0 ;
    FXchar *arg2 ; FXFileAssoc *result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileDict, 1); arg2 = StringValuePtr(argv[0]);
    result = (FXFileAssoc *)FXFileDict_findExecBinding(arg1,(FXchar const *)arg2);
    vresult = FXRbGetRubyObj(result, "FXFileAssoc *"); return vresult; }
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE _wrap_FXStringDict_allocate(VALUE self) {
#else
     static VALUE _wrap_FXStringDict_allocate(int argc, VALUE *argv, VALUE self) {
#endif
         VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_FXStringDict);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
         return vresult; }
static VALUE _wrap_new_FXStringDict(int argc, VALUE *argv, VALUE self) { FXStringDict *result; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc); { result = (FXStringDict *)new_FXStringDict();
        DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result); if(rb_block_given_p()){ rb_yield(self); }  }  return self; }
static VALUE _wrap_FXStringDict_insert(int argc, VALUE *argv, VALUE self) { FXStringDict *arg1 = (FXStringDict *) 0 ;
    FXchar *arg2 ; FXchar *arg3 ; FXbool arg4 = (FXbool) 0 ; FXchar *result; VALUE vresult = Qnil; if ((argc < 2) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXStringDict, 1); arg2 = StringValuePtr(argv[0]);
    arg3 = StringValuePtr(argv[1]); if (argc > 2) { arg4 = to_FXbool(argv[2]); } 
    result = (FXchar *)(arg1)->insert((FXchar const *)arg2,(FXchar const *)arg3,arg4); vresult = rb_str_new2(result);
    return vresult; }
static VALUE _wrap_FXStringDict_replace(int argc, VALUE *argv, VALUE self) { FXStringDict *arg1 = (FXStringDict *) 0 ;
    FXchar *arg2 ; FXchar *arg3 ; FXbool arg4 = (FXbool) 0 ; FXchar *result; VALUE vresult = Qnil; if ((argc < 2) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXStringDict, 1); arg2 = StringValuePtr(argv[0]);
    arg3 = StringValuePtr(argv[1]); if (argc > 2) { arg4 = to_FXbool(argv[2]); } 
    result = (FXchar *)(arg1)->replace((FXchar const *)arg2,(FXchar const *)arg3,arg4); vresult = rb_str_new2(result);
    return vresult; }
static VALUE _wrap_FXStringDict_remove(int argc, VALUE *argv, VALUE self) { FXStringDict *arg1 = (FXStringDict *) 0 ;
    FXchar *arg2 ; FXchar *result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXStringDict, 1); arg2 = StringValuePtr(argv[0]);
    result = (FXchar *)(arg1)->remove((FXchar const *)arg2); vresult = rb_str_new2(result); return vresult; }
static VALUE _wrap_FXStringDict_find(int argc, VALUE *argv, VALUE self) { FXStringDict *arg1 = (FXStringDict *) 0 ;
    FXchar *arg2 ; FXchar *result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXStringDict, 1); arg2 = StringValuePtr(argv[0]);
    result = (FXchar *)((FXStringDict const *)arg1)->find((FXchar const *)arg2); vresult = rb_str_new2(result); return vresult; }
static VALUE _wrap_FXStringDict_data(int argc, VALUE *argv, VALUE self) { FXStringDict *arg1 = (FXStringDict *) 0 ;
    FXuint arg2 ; FXchar *result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXStringDict, 1); arg2 = NUM2UINT(argv[0]);
    result = (FXchar *)((FXStringDict const *)arg1)->data(arg2); vresult = rb_str_new2(result); return vresult; }
static void
free_FXStringDict(FXStringDict *arg1) {
    delete arg1;
}
static VALUE _wrap_FXStringDict_save(int argc, VALUE *argv, VALUE self) { FXStringDict *arg1 = (FXStringDict *) 0 ;
    FXStream *arg2 = 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXStringDict, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXStringDict_save((FXStringDict const *)arg1,*arg2); return Qnil; }
static VALUE _wrap_FXStringDict_load(int argc, VALUE *argv, VALUE self) { FXStringDict *arg1 = (FXStringDict *) 0 ;
    FXStream *arg2 = 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXStringDict, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXStringDict_load(arg1,*arg2); return Qnil; }
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE _wrap_FXSettings_allocate(VALUE self) {
#else
     static VALUE _wrap_FXSettings_allocate(int argc, VALUE *argv, VALUE self) {
#endif
         VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_FXSettings);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
         return vresult; }
static VALUE _wrap_new_FXSettings(int argc, VALUE *argv, VALUE self) { FXSettings *result; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc); { result = (FXSettings *)new_FXSettings();
        DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result); if(rb_block_given_p()){ rb_yield(self); }  }  return self; }
static VALUE _wrap_FXSettings_parseFile(int argc, VALUE *argv, VALUE self) { FXSettings *arg1 = (FXSettings *) 0 ;
    FXString *arg2 = 0 ; FXbool arg3 ; FXbool result; SwigValueWrapper<FXString > p2 ; VALUE vresult = Qnil;
    if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSettings, 1); p2 = to_FXString(argv[0]); arg2 = &p2;
    arg3 = to_FXbool(argv[1]); result = (FXbool)(arg1)->parseFile((FXString const &)*arg2,arg3);
    vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXSettings_unparseFile(int argc, VALUE *argv, VALUE self) { FXSettings *arg1 = (FXSettings *) 0 ;
    FXString *arg2 = 0 ; FXbool result; SwigValueWrapper<FXString > p2 ; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSettings, 1); p2 = to_FXString(argv[0]); arg2 = &p2;
    result = (FXbool)(arg1)->unparseFile((FXString const &)*arg2); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXSettings_data(int argc, VALUE *argv, VALUE self) { FXSettings *arg1 = (FXSettings *) 0 ; FXuint arg2 ;
    FXStringDict *result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSettings, 1); arg2 = NUM2UINT(argv[0]);
    result = (FXStringDict *)((FXSettings const *)arg1)->data(arg2); {
        swig_type_info *ty = SWIG_TypeDynamicCast(SWIGTYPE_p_FXStringDict, (void **) &result);
        vresult = FXRbGetRubyObj(result, ty); }  return vresult; }
static VALUE _wrap_FXSettings_find(int argc, VALUE *argv, VALUE self) { FXSettings *arg1 = (FXSettings *) 0 ; FXchar *arg2 ;
    FXStringDict *result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSettings, 1); arg2 = StringValuePtr(argv[0]);
    result = (FXStringDict *)((FXSettings const *)arg1)->find((FXchar const *)arg2); {
        swig_type_info *ty = SWIG_TypeDynamicCast(SWIGTYPE_p_FXStringDict, (void **) &result);
        vresult = FXRbGetRubyObj(result, ty); }  return vresult; }
static VALUE _wrap_FXSettings_readStringEntry(int argc, VALUE *argv, VALUE self) { FXSettings *arg1 = (FXSettings *) 0 ;
    FXchar *arg2 ; FXchar *arg3 ; FXchar *arg4 = (FXchar *) 0 ; FXchar *result; VALUE vresult = Qnil;
    if ((argc < 2) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSettings, 1); arg2 = StringValuePtr(argv[0]);
    arg3 = StringValuePtr(argv[1]); if (argc > 2) { arg4 = StringValuePtr(argv[2]); } 
    result = (FXchar *)(arg1)->readStringEntry((FXchar const *)arg2,(FXchar const *)arg3,(FXchar const *)arg4);
    vresult = rb_str_new2(result); return vresult; }
static VALUE _wrap_FXSettings_readIntEntry(int argc, VALUE *argv, VALUE self) { FXSettings *arg1 = (FXSettings *) 0 ;
    FXchar *arg2 ; FXchar *arg3 ; FXint arg4 = (FXint) 0 ; FXint result; VALUE vresult = Qnil; if ((argc < 2) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSettings, 1); arg2 = StringValuePtr(argv[0]);
    arg3 = StringValuePtr(argv[1]); if (argc > 2) { arg4 = NUM2INT(argv[2]); } 
    result = (FXint)(arg1)->readIntEntry((FXchar const *)arg2,(FXchar const *)arg3,arg4); vresult = INT2NUM(result);
    return vresult; }
static VALUE _wrap_FXSettings_readUnsignedEntry(int argc, VALUE *argv, VALUE self) { FXSettings *arg1 = (FXSettings *) 0 ;
    FXchar *arg2 ; FXchar *arg3 ; FXuint arg4 = (FXuint) 0 ; FXuint result; VALUE vresult = Qnil; if ((argc < 2) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSettings, 1); arg2 = StringValuePtr(argv[0]);
    arg3 = StringValuePtr(argv[1]); if (argc > 2) { arg4 = NUM2UINT(argv[2]); } 
    result = (FXuint)(arg1)->readUnsignedEntry((FXchar const *)arg2,(FXchar const *)arg3,arg4); vresult = UINT2NUM(result);
    return vresult; }
static VALUE _wrap_FXSettings_readRealEntry(int argc, VALUE *argv, VALUE self) { FXSettings *arg1 = (FXSettings *) 0 ;
    FXchar *arg2 ; FXchar *arg3 ; FXdouble arg4 = (FXdouble) 0.0 ; FXdouble result; VALUE vresult = Qnil;
    if ((argc < 2) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSettings, 1); arg2 = StringValuePtr(argv[0]);
    arg3 = StringValuePtr(argv[1]); if (argc > 2) { arg4 = (FXdouble) NUM2DBL(argv[2]); } 
    result = (FXdouble)(arg1)->readRealEntry((FXchar const *)arg2,(FXchar const *)arg3,arg4); vresult = rb_float_new(result);
    return vresult; }
static VALUE _wrap_FXSettings_readColorEntry(int argc, VALUE *argv, VALUE self) { FXSettings *arg1 = (FXSettings *) 0 ;
    FXchar *arg2 ; FXchar *arg3 ; FXColor arg4 = (FXColor) 0 ; FXColor result; VALUE vresult = Qnil;
    if ((argc < 2) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSettings, 1); arg2 = StringValuePtr(argv[0]);
    arg3 = StringValuePtr(argv[1]); if (argc > 2) { arg4 = to_FXColor(argv[2]); } 
    result = (FXColor)(arg1)->readColorEntry((FXchar const *)arg2,(FXchar const *)arg3,arg4); vresult = UINT2NUM(result);
    return vresult; }
static VALUE _wrap_FXSettings_writeStringEntry(int argc, VALUE *argv, VALUE self) { FXSettings *arg1 = (FXSettings *) 0 ;
    FXchar *arg2 ; FXchar *arg3 ; FXchar *arg4 ; FXbool result; VALUE vresult = Qnil; if ((argc < 3) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSettings, 1); arg2 = StringValuePtr(argv[0]);
    arg3 = StringValuePtr(argv[1]); arg4 = StringValuePtr(argv[2]);
    result = (FXbool)(arg1)->writeStringEntry((FXchar const *)arg2,(FXchar const *)arg3,(FXchar const *)arg4);
    vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXSettings_writeIntEntry(int argc, VALUE *argv, VALUE self) { FXSettings *arg1 = (FXSettings *) 0 ;
    FXchar *arg2 ; FXchar *arg3 ; FXint arg4 ; FXbool result; VALUE vresult = Qnil; if ((argc < 3) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSettings, 1); arg2 = StringValuePtr(argv[0]);
    arg3 = StringValuePtr(argv[1]); arg4 = NUM2INT(argv[2]);
    result = (FXbool)(arg1)->writeIntEntry((FXchar const *)arg2,(FXchar const *)arg3,arg4); vresult = result ? Qtrue : Qfalse;
    return vresult; }
static VALUE _wrap_FXSettings_writeUnsignedEntry(int argc, VALUE *argv, VALUE self) { FXSettings *arg1 = (FXSettings *) 0 ;
    FXchar *arg2 ; FXchar *arg3 ; FXuint arg4 ; FXbool result; VALUE vresult = Qnil; if ((argc < 3) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSettings, 1); arg2 = StringValuePtr(argv[0]);
    arg3 = StringValuePtr(argv[1]); arg4 = NUM2UINT(argv[2]);
    result = (FXbool)(arg1)->writeUnsignedEntry((FXchar const *)arg2,(FXchar const *)arg3,arg4);
    vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXSettings_writeRealEntry(int argc, VALUE *argv, VALUE self) { FXSettings *arg1 = (FXSettings *) 0 ;
    FXchar *arg2 ; FXchar *arg3 ; FXdouble arg4 ; FXbool result; VALUE vresult = Qnil; if ((argc < 3) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSettings, 1); arg2 = StringValuePtr(argv[0]);
    arg3 = StringValuePtr(argv[1]); arg4 = (FXdouble) NUM2DBL(argv[2]);
    result = (FXbool)(arg1)->writeRealEntry((FXchar const *)arg2,(FXchar const *)arg3,arg4); vresult = result ? Qtrue : Qfalse;
    return vresult; }
static VALUE _wrap_FXSettings_writeColorEntry(int argc, VALUE *argv, VALUE self) { FXSettings *arg1 = (FXSettings *) 0 ;
    FXchar *arg2 ; FXchar *arg3 ; FXColor arg4 ; FXbool result; VALUE vresult = Qnil; if ((argc < 3) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSettings, 1); arg2 = StringValuePtr(argv[0]);
    arg3 = StringValuePtr(argv[1]); arg4 = to_FXColor(argv[2]);
    result = (FXbool)(arg1)->writeColorEntry((FXchar const *)arg2,(FXchar const *)arg3,arg4); vresult = result ? Qtrue : Qfalse;
    return vresult; }
static VALUE _wrap_FXSettings_deleteEntry(int argc, VALUE *argv, VALUE self) { FXSettings *arg1 = (FXSettings *) 0 ;
    FXchar *arg2 ; FXchar *arg3 ; FXbool result; VALUE vresult = Qnil; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSettings, 1); arg2 = StringValuePtr(argv[0]);
    arg3 = StringValuePtr(argv[1]); result = (FXbool)(arg1)->deleteEntry((FXchar const *)arg2,(FXchar const *)arg3);
    vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXSettings_existingEntry(int argc, VALUE *argv, VALUE self) { FXSettings *arg1 = (FXSettings *) 0 ;
    FXchar *arg2 ; FXchar *arg3 ; FXbool result; VALUE vresult = Qnil; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSettings, 1); arg2 = StringValuePtr(argv[0]);
    arg3 = StringValuePtr(argv[1]); result = (FXbool)(arg1)->existingEntry((FXchar const *)arg2,(FXchar const *)arg3);
    vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXSettings_deleteSection(int argc, VALUE *argv, VALUE self) { FXSettings *arg1 = (FXSettings *) 0 ;
    FXchar *arg2 ; FXbool result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSettings, 1); arg2 = StringValuePtr(argv[0]);
    result = (FXbool)(arg1)->deleteSection((FXchar const *)arg2); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXSettings_existingSection(int argc, VALUE *argv, VALUE self) { FXSettings *arg1 = (FXSettings *) 0 ;
    FXchar *arg2 ; FXbool result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSettings, 1); arg2 = StringValuePtr(argv[0]);
    result = (FXbool)(arg1)->existingSection((FXchar const *)arg2); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXSettings_clear(int argc, VALUE *argv, VALUE self) { FXSettings *arg1 = (FXSettings *) 0 ; FXbool result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSettings, 1); result = (FXbool)(arg1)->clear();
    vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXSettings_setModified(int argc, VALUE *argv, VALUE self) { FXSettings *arg1 = (FXSettings *) 0 ;
    FXbool arg2 = (FXbool) 1 ; if ((argc < 0) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSettings, 1); if (argc > 0) { arg2 = to_FXbool(argv[0]); } 
    (arg1)->setModified(arg2); return Qnil; }
static VALUE _wrap_FXSettings_isModified(int argc, VALUE *argv, VALUE self) { FXSettings *arg1 = (FXSettings *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSettings, 1); result = (FXbool)((FXSettings const *)arg1)->isModified();
    vresult = result ? Qtrue : Qfalse; return vresult; }
static void
free_FXSettings(FXSettings *arg1) {
    delete arg1;
}
static VALUE _wrap_FXSettings_save(int argc, VALUE *argv, VALUE self) { FXSettings *arg1 = (FXSettings *) 0 ;
    FXStream *arg2 = 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSettings, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXSettings_save((FXSettings const *)arg1,*arg2); return Qnil; }
static VALUE _wrap_FXSettings_load(int argc, VALUE *argv, VALUE self) { FXSettings *arg1 = (FXSettings *) 0 ;
    FXStream *arg2 = 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSettings, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXSettings_load(arg1,*arg2); return Qnil; }
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE _wrap_FXRegistry_allocate(VALUE self) {
#else
     static VALUE _wrap_FXRegistry_allocate(int argc, VALUE *argv, VALUE self) {
#endif
         VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_FXRegistry);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
         return vresult; }
static VALUE _wrap_new_FXRegistry(int argc, VALUE *argv, VALUE self) { FXString const &arg1_defvalue = FXString::null ;
    FXString *arg1 = (FXString *) &arg1_defvalue ; FXString const &arg2_defvalue = FXString::null ;
    FXString *arg2 = (FXString *) &arg2_defvalue ; FXRegistry *result; SwigValueWrapper<FXString > p1 ;
    SwigValueWrapper<FXString > p2 ; if ((argc < 0) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc); if (argc > 0) { p1 = to_FXString(argv[0]); arg1 = &p1; } 
    if (argc > 1) { p2 = to_FXString(argv[1]); arg2 = &p2; }  {
        result = (FXRegistry *)new_FXRegistry((FXString const &)*arg1,(FXString const &)*arg2);
        DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result); if(rb_block_given_p()){ rb_yield(self); }  }  return self; }
static VALUE _wrap_FXRegistry_read(int argc, VALUE *argv, VALUE self) { FXRegistry *arg1 = (FXRegistry *) 0 ; FXbool result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRegistry, 1); result = (FXbool)(arg1)->read();
    vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXRegistry_write(int argc, VALUE *argv, VALUE self) { FXRegistry *arg1 = (FXRegistry *) 0 ; FXbool result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRegistry, 1); result = (FXbool)(arg1)->write();
    vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXRegistry_getAppKey(int argc, VALUE *argv, VALUE self) { FXRegistry *arg1 = (FXRegistry *) 0 ;
    FXString result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRegistry, 1); result = ((FXRegistry const *)arg1)->getAppKey();
    vresult = rb_str_new2((&result)->text()); return vresult; }
static VALUE _wrap_FXRegistry_getVendorKey(int argc, VALUE *argv, VALUE self) { FXRegistry *arg1 = (FXRegistry *) 0 ;
    FXString result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRegistry, 1); result = ((FXRegistry const *)arg1)->getVendorKey();
    vresult = rb_str_new2((&result)->text()); return vresult; }
static VALUE _wrap_FXRegistry_setAsciiMode(int argc, VALUE *argv, VALUE self) { FXRegistry *arg1 = (FXRegistry *) 0 ;
    FXbool arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRegistry, 1); arg2 = to_FXbool(argv[0]); (arg1)->setAsciiMode(arg2);
    return Qnil; }
static VALUE _wrap_FXRegistry_getAsciiMode(int argc, VALUE *argv, VALUE self) { FXRegistry *arg1 = (FXRegistry *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRegistry, 1);
    result = (FXbool)((FXRegistry const *)arg1)->getAsciiMode(); vresult = result ? Qtrue : Qfalse; return vresult; }
static void
free_FXRegistry(FXRegistry *arg1) {
    delete arg1;
}
static VALUE _wrap_FXRegistry_save(int argc, VALUE *argv, VALUE self) { FXRegistry *arg1 = (FXRegistry *) 0 ;
    FXStream *arg2 = 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRegistry, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXRegistry_save((FXRegistry const *)arg1,*arg2); return Qnil; }
static VALUE _wrap_FXRegistry_load(int argc, VALUE *argv, VALUE self) { FXRegistry *arg1 = (FXRegistry *) 0 ;
    FXStream *arg2 = 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRegistry, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXRegistry_load(arg1,*arg2); return Qnil; }
static VALUE _wrap_FXDocument_onUpdTitle(int argc, VALUE *argv, VALUE self) { FXDocument *arg1 = (FXDocument *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDocument, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onUpdTitle(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXDocument_onUpdFilename(int argc, VALUE *argv, VALUE self) { FXDocument *arg1 = (FXDocument *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDocument, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onUpdFilename(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE _wrap_FXDocument_allocate(VALUE self) {
#else
     static VALUE _wrap_FXDocument_allocate(int argc, VALUE *argv, VALUE self) {
#endif
         VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_FXDocument);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
         return vresult; }
static VALUE _wrap_new_FXDocument(int argc, VALUE *argv, VALUE self) { FXDocument *result; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc); { result = (FXDocument *)new_FXDocument();
        DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result); if(rb_block_given_p()){ rb_yield(self); }  }  return self; }
static VALUE _wrap_FXDocument_isModified(int argc, VALUE *argv, VALUE self) { FXDocument *arg1 = (FXDocument *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDocument, 1); result = (FXbool)((FXDocument const *)arg1)->isModified();
    vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXDocument_setModified(int argc, VALUE *argv, VALUE self) { FXDocument *arg1 = (FXDocument *) 0 ;
    FXbool arg2 = (FXbool) 1 ; if ((argc < 0) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDocument, 1); if (argc > 0) { arg2 = to_FXbool(argv[0]); } 
    (arg1)->setModified(arg2); return Qnil; }
static VALUE _wrap_FXDocument_setTitle(int argc, VALUE *argv, VALUE self) { FXDocument *arg1 = (FXDocument *) 0 ;
    FXString *arg2 = 0 ; SwigValueWrapper<FXString > p2 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDocument, 1); p2 = to_FXString(argv[0]); arg2 = &p2;
    (arg1)->setTitle((FXString const &)*arg2); return Qnil; }
static VALUE _wrap_FXDocument_getTitle(int argc, VALUE *argv, VALUE self) { FXDocument *arg1 = (FXDocument *) 0 ;
    FXString result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDocument, 1); result = ((FXDocument const *)arg1)->getTitle();
    vresult = rb_str_new2((&result)->text()); return vresult; }
static VALUE _wrap_FXDocument_setFilename(int argc, VALUE *argv, VALUE self) { FXDocument *arg1 = (FXDocument *) 0 ;
    FXString *arg2 = 0 ; SwigValueWrapper<FXString > p2 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDocument, 1); p2 = to_FXString(argv[0]); arg2 = &p2;
    (arg1)->setFilename((FXString const &)*arg2); return Qnil; }
static VALUE _wrap_FXDocument_getFilename(int argc, VALUE *argv, VALUE self) { FXDocument *arg1 = (FXDocument *) 0 ;
    FXString result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDocument, 1); result = ((FXDocument const *)arg1)->getFilename();
    vresult = rb_str_new2((&result)->text()); return vresult; }
static void
free_FXDocument(FXDocument *arg1) {
    delete arg1;
}
static VALUE _wrap_FXDocument_save(int argc, VALUE *argv, VALUE self) { FXDocument *arg1 = (FXDocument *) 0 ;
    FXStream *arg2 = 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDocument, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXDocument_save((FXDocument const *)arg1,*arg2); return Qnil; }
static VALUE _wrap_FXDocument_load(int argc, VALUE *argv, VALUE self) { FXDocument *arg1 = (FXDocument *) 0 ;
    FXStream *arg2 = 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDocument, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXDocument_load(arg1,*arg2); return Qnil; }
static VALUE _wrap_FXRecentFiles_onCmdClear(int argc, VALUE *argv, VALUE self) { FXRecentFiles *arg1 = (FXRecentFiles *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRecentFiles, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdClear(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXRecentFiles_onCmdFile(int argc, VALUE *argv, VALUE self) { FXRecentFiles *arg1 = (FXRecentFiles *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRecentFiles, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdFile(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXRecentFiles_onUpdFile(int argc, VALUE *argv, VALUE self) { FXRecentFiles *arg1 = (FXRecentFiles *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRecentFiles, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onUpdFile(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXRecentFiles_onUpdAnyFiles(int argc, VALUE *argv, VALUE self) { FXRecentFiles *arg1 = (FXRecentFiles *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRecentFiles, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onUpdAnyFiles(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_new_FXRecentFiles__SWIG_0(int argc, VALUE *argv, VALUE self) { FXRecentFiles *result;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc); {
        result = (FXRecentFiles *)new_FXRecentFiles__SWIG_0(); DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result);
        if(rb_block_given_p()){ rb_yield(self); }  }  return self; }
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE _wrap_FXRecentFiles_allocate(VALUE self) {
#else
     static VALUE _wrap_FXRecentFiles_allocate(int argc, VALUE *argv, VALUE self) {
#endif
         VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_FXRecentFiles);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
         return vresult; }
static VALUE _wrap_new_FXRecentFiles__SWIG_1(int argc, VALUE *argv, VALUE self) { FXString *arg1 = 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 = (FXSelector) 0 ; FXRecentFiles *result; SwigValueWrapper<FXString > p1 ;
    if ((argc < 1) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    p1 = to_FXString(argv[0]); arg1 = &p1; if (argc > 1) { SWIG_ConvertPtr(argv[1], (void **) &arg2, SWIGTYPE_p_FXObject, 1); } 
    if (argc > 2) { arg3 = NUM2UINT(argv[2]); }  {
        result = (FXRecentFiles *)new_FXRecentFiles__SWIG_1((FXString const &)*arg1,arg2,arg3);
        DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result); if(rb_block_given_p()){ rb_yield(self); }  }  return self; }
static VALUE _wrap_new_FXRecentFiles(int nargs, VALUE *args, VALUE self) { int argc; VALUE argv[3]; int ii; argc = nargs;
    for (ii = 0; (ii < argc) && (ii < 3); ii++) { argv[ii] = args[ii]; }  if (argc == 0) {
        return _wrap_new_FXRecentFiles__SWIG_0(nargs, args, self);}  if ((argc >= 1) && (argc <= 3)) { int _v; {
            _v = (NIL_P(argv[0]) || TYPE(argv[0]) == T_STRING) ? 1 : 0; }  if (_v) { if (argc <= 1) {
                return _wrap_new_FXRecentFiles__SWIG_1(nargs, args, self);}  { void *ptr;
                _v = (NIL_P(argv[1]) || (TYPE(argv[1]) == T_DATA && SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_FXObject, 0) != -1)) ? 1 : 0; }
             if (_v) { if (argc <= 2) { return _wrap_new_FXRecentFiles__SWIG_1(nargs, args, self);}  {
                    _v = ((TYPE(argv[2]) == T_FIXNUM) || (TYPE(argv[2]) == T_BIGNUM)) ? 1 : 0; }  if (_v) {
                    return _wrap_new_FXRecentFiles__SWIG_1(nargs, args, self);}  }  }  } 
    rb_raise(rb_eArgError, "No matching function for overloaded 'new_FXRecentFiles'"); return Qnil; }
static VALUE _wrap_FXRecentFiles_setMaxFiles(int argc, VALUE *argv, VALUE self) { FXRecentFiles *arg1 = (FXRecentFiles *) 0 ;
    FXint arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRecentFiles, 1); arg2 = NUM2INT(argv[0]); (arg1)->setMaxFiles(arg2);
    return Qnil; }
static VALUE _wrap_FXRecentFiles_getMaxFiles(int argc, VALUE *argv, VALUE self) { FXRecentFiles *arg1 = (FXRecentFiles *) 0 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRecentFiles, 1);
    result = (FXint)((FXRecentFiles const *)arg1)->getMaxFiles(); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXRecentFiles_setGroupName(int argc, VALUE *argv, VALUE self) { FXRecentFiles *arg1 = (FXRecentFiles *) 0 ;
    FXString *arg2 = 0 ; SwigValueWrapper<FXString > p2 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRecentFiles, 1); p2 = to_FXString(argv[0]); arg2 = &p2;
    (arg1)->setGroupName((FXString const &)*arg2); return Qnil; }
static VALUE _wrap_FXRecentFiles_getGroupName(int argc, VALUE *argv, VALUE self) { FXRecentFiles *arg1 = (FXRecentFiles *) 0 ;
    FXString result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRecentFiles, 1); result = ((FXRecentFiles const *)arg1)->getGroupName();
    vresult = rb_str_new2((&result)->text()); return vresult; }
static VALUE _wrap_FXRecentFiles_setTarget(int argc, VALUE *argv, VALUE self) { FXRecentFiles *arg1 = (FXRecentFiles *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRecentFiles, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); (arg1)->setTarget(arg2); return Qnil; }
static VALUE _wrap_FXRecentFiles_getTarget(int argc, VALUE *argv, VALUE self) { FXRecentFiles *arg1 = (FXRecentFiles *) 0 ;
    FXObject *result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRecentFiles, 1);
    result = (FXObject *)((FXRecentFiles const *)arg1)->getTarget(); {
        swig_type_info *ty = SWIG_TypeDynamicCast(SWIGTYPE_p_FXObject, (void **) &result);
        vresult = FXRbGetRubyObj(result, ty); }  return vresult; }
static VALUE _wrap_FXRecentFiles_setSelector(int argc, VALUE *argv, VALUE self) { FXRecentFiles *arg1 = (FXRecentFiles *) 0 ;
    FXSelector arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRecentFiles, 1); arg2 = NUM2UINT(argv[0]); (arg1)->setSelector(arg2);
    return Qnil; }
static VALUE _wrap_FXRecentFiles_getSelector(int argc, VALUE *argv, VALUE self) { FXRecentFiles *arg1 = (FXRecentFiles *) 0 ;
    FXSelector result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRecentFiles, 1);
    result = (FXSelector)((FXRecentFiles const *)arg1)->getSelector(); vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXRecentFiles_getFile(int argc, VALUE *argv, VALUE self) { FXRecentFiles *arg1 = (FXRecentFiles *) 0 ;
    FXint arg2 ; FXString result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRecentFiles, 1); arg2 = NUM2INT(argv[0]);
    result = ((FXRecentFiles const *)arg1)->getFile(arg2); vresult = rb_str_new2((&result)->text()); return vresult; }
static VALUE _wrap_FXRecentFiles_setFile(int argc, VALUE *argv, VALUE self) { FXRecentFiles *arg1 = (FXRecentFiles *) 0 ;
    FXint arg2 ; FXString *arg3 = 0 ; SwigValueWrapper<FXString > p3 ; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRecentFiles, 1); arg2 = NUM2INT(argv[0]);
    p3 = to_FXString(argv[1]); arg3 = &p3; (arg1)->setFile(arg2,(FXString const &)*arg3); return Qnil; }
static VALUE _wrap_FXRecentFiles_appendFile(int argc, VALUE *argv, VALUE self) { FXRecentFiles *arg1 = (FXRecentFiles *) 0 ;
    FXString *arg2 = 0 ; SwigValueWrapper<FXString > p2 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRecentFiles, 1); p2 = to_FXString(argv[0]); arg2 = &p2;
    (arg1)->appendFile((FXString const &)*arg2); return Qnil; }
static VALUE _wrap_FXRecentFiles_removeFile(int argc, VALUE *argv, VALUE self) { FXRecentFiles *arg1 = (FXRecentFiles *) 0 ;
    FXString *arg2 = 0 ; SwigValueWrapper<FXString > p2 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRecentFiles, 1); p2 = to_FXString(argv[0]); arg2 = &p2;
    (arg1)->removeFile((FXString const &)*arg2); return Qnil; }
static VALUE _wrap_FXRecentFiles_clear(int argc, VALUE *argv, VALUE self) { FXRecentFiles *arg1 = (FXRecentFiles *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRecentFiles, 1); (arg1)->clear(); return Qnil; }
static void
free_FXRecentFiles(FXRecentFiles *arg1) {
    delete arg1;
}
static VALUE _wrap_FXRecentFiles_save(int argc, VALUE *argv, VALUE self) { FXRecentFiles *arg1 = (FXRecentFiles *) 0 ;
    FXStream *arg2 = 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRecentFiles, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXRecentFiles_save((FXRecentFiles const *)arg1,*arg2); return Qnil; }
static VALUE _wrap_FXRecentFiles_load(int argc, VALUE *argv, VALUE self) { FXRecentFiles *arg1 = (FXRecentFiles *) 0 ;
    FXStream *arg2 = 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRecentFiles, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXRecentFiles_load(arg1,*arg2); return Qnil; }
static VALUE _wrap_FXId_getApp(int argc, VALUE *argv, VALUE self) { FXId *arg1 = (FXId *) 0 ; FXApp *result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXId, 1); result = (FXApp *)((FXId const *)arg1)->getApp(); {
        swig_type_info *ty = SWIG_TypeDynamicCast(SWIGTYPE_p_FXApp, (void **) &result); vresult = FXRbGetRubyObj(result, ty); } 
    return vresult; }
static VALUE _wrap_FXId_xid(int argc, VALUE *argv, VALUE self) { FXId *arg1 = (FXId *) 0 ; FXID result; VALUE vresult = Qnil;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXId, 1); result = ((FXId const *)arg1)->id();
    vresult = fxid_to_int(result); return vresult; }
static VALUE _wrap_FXId_createdq___(int argc, VALUE *argv, VALUE self) { FXId *arg1 = (FXId *) 0 ; bool result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXId, 1); result = (bool)FXId_created((FXId const *)arg1);
    vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXId_setUserData(int argc, VALUE *argv, VALUE self) { FXId *arg1 = (FXId *) 0 ; VALUE arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXId, 1); arg2 = argv[0]; FXId_setUserData(arg1,arg2); return Qnil; }
static VALUE _wrap_FXId_getUserData(int argc, VALUE *argv, VALUE self) { FXId *arg1 = (FXId *) 0 ; VALUE result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXId, 1); result = (VALUE)FXId_getUserData((FXId const *)arg1);
    vresult = result; return vresult; }
static void
free_FXId(FXId *arg1) {
    delete arg1;
}
static VALUE _wrap_FXId_save(int argc, VALUE *argv, VALUE self) { FXId *arg1 = (FXId *) 0 ; FXStream *arg2 = 0 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXId, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXId_save((FXId const *)arg1,*arg2); return Qnil; }
static VALUE _wrap_FXId_load(int argc, VALUE *argv, VALUE self) { FXId *arg1 = (FXId *) 0 ; FXStream *arg2 = 0 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXId, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXId_load(arg1,*arg2); return Qnil; }
static VALUE _wrap_FXId_create(int argc, VALUE *argv, VALUE self) { FXId *arg1 = (FXId *) 0 ; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc); SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXId, 1);
    FXId_create(arg1); return Qnil; }
static VALUE _wrap_FXId_detach(int argc, VALUE *argv, VALUE self) { FXId *arg1 = (FXId *) 0 ; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc); SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXId, 1);
    FXId_detach(arg1); return Qnil; }
static VALUE _wrap_FXId_destroy(int argc, VALUE *argv, VALUE self) { FXId *arg1 = (FXId *) 0 ; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc); SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXId, 1);
    FXId_destroy(arg1); return Qnil; }
static VALUE _wrap_new_FXCursor__SWIG_0(int argc, VALUE *argv, VALUE self) { FXApp *arg1 = (FXApp *) 0 ;
    int arg2 = (int) CURSOR_ARROW ; FXCursor *result; if ((argc < 1) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXApp, 1); if (argc > 1) { arg2 = (int) NUM2INT(argv[1]); }  {
        result = (FXCursor *)new_FXCursor__SWIG_0(arg1,(FXStockCursor )arg2);
        DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result); if(rb_block_given_p()){ rb_yield(self); }  }  return self; }
static VALUE _wrap_new_FXCursor__SWIG_1(int argc, VALUE *argv, VALUE self) { FXApp *arg1 = (FXApp *) 0 ;
    FXuchar *arg2 = (FXuchar *) 0 ; FXuchar *arg3 = (FXuchar *) 0 ; FXint arg4 = (FXint) 32 ; FXint arg5 = (FXint) 32 ;
    FXint arg6 = (FXint) 0 ; FXint arg7 = (FXint) 0 ; FXCursor *result; if ((argc < 3) || (argc > 7))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXApp, 1);
    SWIG_ConvertPtr(argv[1], (void **) &arg2, SWIGTYPE_p_FXuchar, 1);
    SWIG_ConvertPtr(argv[2], (void **) &arg3, SWIGTYPE_p_FXuchar, 1); if (argc > 3) { arg4 = NUM2INT(argv[3]); } 
    if (argc > 4) { arg5 = NUM2INT(argv[4]); }  if (argc > 5) { arg6 = NUM2INT(argv[5]); }  if (argc > 6) {
        arg7 = NUM2INT(argv[6]); }  {
        result = (FXCursor *)new_FXCursor__SWIG_1(arg1,(FXuchar const *)arg2,(FXuchar const *)arg3,arg4,arg5,arg6,arg7);
        DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result); if(rb_block_given_p()){ rb_yield(self); }  }  return self; }
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE _wrap_FXCursor_allocate(VALUE self) {
#else
     static VALUE _wrap_FXCursor_allocate(int argc, VALUE *argv, VALUE self) {
#endif
         VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_FXCursor);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
         return vresult; }
static VALUE _wrap_new_FXCursor__SWIG_2(int argc, VALUE *argv, VALUE self) { FXApp *arg1 = (FXApp *) 0 ;
    FXColor *arg2 = (FXColor *) 0 ; FXint arg3 = (FXint) 32 ; FXint arg4 = (FXint) 32 ; FXint arg5 = (FXint) 0 ;
    FXint arg6 = (FXint) 0 ; FXCursor *result; if ((argc < 2) || (argc > 6))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXApp, 1);
    SWIG_ConvertPtr(argv[1], (void **) &arg2, SWIGTYPE_p_FXColor, 1); if (argc > 2) { arg3 = NUM2INT(argv[2]); } 
    if (argc > 3) { arg4 = NUM2INT(argv[3]); }  if (argc > 4) { arg5 = NUM2INT(argv[4]); }  if (argc > 5) {
        arg6 = NUM2INT(argv[5]); }  { result = (FXCursor *)new_FXCursor__SWIG_2(arg1,(FXColor const *)arg2,arg3,arg4,arg5,arg6);
        DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result); if(rb_block_given_p()){ rb_yield(self); }  }  return self; }
static VALUE _wrap_new_FXCursor(int nargs, VALUE *args, VALUE self) { int argc; VALUE argv[7]; int ii; argc = nargs;
    for (ii = 0; (ii < argc) && (ii < 7); ii++) { argv[ii] = args[ii]; }  if ((argc >= 1) && (argc <= 2)) { int _v; { void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXApp, 0) != -1)) ? 1 : 0; }
         if (_v) { if (argc <= 1) { return _wrap_new_FXCursor__SWIG_0(nargs, args, self);}  {
                _v = ((TYPE(argv[1]) == T_FIXNUM) || (TYPE(argv[1]) == T_BIGNUM)) ? 1 : 0; }  if (_v) {
                return _wrap_new_FXCursor__SWIG_0(nargs, args, self);}  }  }  if ((argc >= 2) && (argc <= 6)) { int _v; {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXApp, 0) != -1)) ? 1 : 0; }
         if (_v) { { void *ptr;
                _v = (NIL_P(argv[1]) || (TYPE(argv[1]) == T_DATA && SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_FXColor, 0) != -1)) ? 1 : 0; }
             if (_v) { if (argc <= 2) { return _wrap_new_FXCursor__SWIG_2(nargs, args, self);}  {
                    _v = ((TYPE(argv[2]) == T_FIXNUM) || (TYPE(argv[2]) == T_BIGNUM)) ? 1 : 0; }  if (_v) { if (argc <= 3) {
                        return _wrap_new_FXCursor__SWIG_2(nargs, args, self);}  {
                        _v = ((TYPE(argv[3]) == T_FIXNUM) || (TYPE(argv[3]) == T_BIGNUM)) ? 1 : 0; }  if (_v) { if (argc <= 4) {
                            return _wrap_new_FXCursor__SWIG_2(nargs, args, self);}  {
                            _v = ((TYPE(argv[4]) == T_FIXNUM) || (TYPE(argv[4]) == T_BIGNUM)) ? 1 : 0; }  if (_v) {
                            if (argc <= 5) { return _wrap_new_FXCursor__SWIG_2(nargs, args, self);}  {
                                _v = ((TYPE(argv[5]) == T_FIXNUM) || (TYPE(argv[5]) == T_BIGNUM)) ? 1 : 0; }  if (_v) {
                                return _wrap_new_FXCursor__SWIG_2(nargs, args, self);}  }  }  }  }  }  } 
    if ((argc >= 3) && (argc <= 7)) { int _v; { void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXApp, 0) != -1)) ? 1 : 0; }
         if (_v) { { void *ptr;
                _v = (NIL_P(argv[1]) || (TYPE(argv[1]) == T_DATA && SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_FXuchar, 0) != -1)) ? 1 : 0; }
             if (_v) { { void *ptr;
                    _v = (NIL_P(argv[2]) || (TYPE(argv[2]) == T_DATA && SWIG_ConvertPtr(argv[2], &ptr, SWIGTYPE_p_FXuchar, 0) != -1)) ? 1 : 0; }
                 if (_v) { if (argc <= 3) { return _wrap_new_FXCursor__SWIG_1(nargs, args, self);}  {
                        _v = ((TYPE(argv[3]) == T_FIXNUM) || (TYPE(argv[3]) == T_BIGNUM)) ? 1 : 0; }  if (_v) { if (argc <= 4) {
                            return _wrap_new_FXCursor__SWIG_1(nargs, args, self);}  {
                            _v = ((TYPE(argv[4]) == T_FIXNUM) || (TYPE(argv[4]) == T_BIGNUM)) ? 1 : 0; }  if (_v) {
                            if (argc <= 5) { return _wrap_new_FXCursor__SWIG_1(nargs, args, self);}  {
                                _v = ((TYPE(argv[5]) == T_FIXNUM) || (TYPE(argv[5]) == T_BIGNUM)) ? 1 : 0; }  if (_v) {
                                if (argc <= 6) { return _wrap_new_FXCursor__SWIG_1(nargs, args, self);}  {
                                    _v = ((TYPE(argv[6]) == T_FIXNUM) || (TYPE(argv[6]) == T_BIGNUM)) ? 1 : 0; }  if (_v) {
                                    return _wrap_new_FXCursor__SWIG_1(nargs, args, self);}  }  }  }  }  }  }  } 
    rb_raise(rb_eArgError, "No matching function for overloaded 'new_FXCursor'"); return Qnil; }
static VALUE _wrap_FXCursor_getWidth(int argc, VALUE *argv, VALUE self) { FXCursor *arg1 = (FXCursor *) 0 ; FXint result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXCursor, 1); result = (FXint)((FXCursor const *)arg1)->getWidth();
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXCursor_getHeight(int argc, VALUE *argv, VALUE self) { FXCursor *arg1 = (FXCursor *) 0 ; FXint result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXCursor, 1); result = (FXint)((FXCursor const *)arg1)->getHeight();
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXCursor_getHotX(int argc, VALUE *argv, VALUE self) { FXCursor *arg1 = (FXCursor *) 0 ; FXint result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXCursor, 1); result = (FXint)((FXCursor const *)arg1)->getHotX();
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXCursor_getHotY(int argc, VALUE *argv, VALUE self) { FXCursor *arg1 = (FXCursor *) 0 ; FXint result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXCursor, 1); result = (FXint)((FXCursor const *)arg1)->getHotY();
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXCursor_isColor(int argc, VALUE *argv, VALUE self) { FXCursor *arg1 = (FXCursor *) 0 ; FXbool result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXCursor, 1); result = (FXbool)((FXCursor const *)arg1)->isColor();
    vresult = result ? Qtrue : Qfalse; return vresult; }
static void
free_FXCursor(FXCursor *arg1) {
    delete arg1;
}
static VALUE _wrap_FXCursor_save(int argc, VALUE *argv, VALUE self) { FXCursor *arg1 = (FXCursor *) 0 ; FXStream *arg2 = 0 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXCursor, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXCursor_save((FXCursor const *)arg1,*arg2); return Qnil; }
static VALUE _wrap_FXCursor_load(int argc, VALUE *argv, VALUE self) { FXCursor *arg1 = (FXCursor *) 0 ; FXStream *arg2 = 0 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXCursor, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXCursor_load(arg1,*arg2); return Qnil; }
static VALUE _wrap_FXCursor_create(int argc, VALUE *argv, VALUE self) { FXCursor *arg1 = (FXCursor *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXCursor, 1); FXCursor_create(arg1); return Qnil; }
static VALUE _wrap_FXCursor_detach(int argc, VALUE *argv, VALUE self) { FXCursor *arg1 = (FXCursor *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXCursor, 1); FXCursor_detach(arg1); return Qnil; }
static VALUE _wrap_FXCursor_destroy(int argc, VALUE *argv, VALUE self) { FXCursor *arg1 = (FXCursor *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXCursor, 1); FXCursor_destroy(arg1); return Qnil; }
static VALUE _wrap_FXCursor_savePixels(int argc, VALUE *argv, VALUE self) { FXCursor *arg1 = (FXCursor *) 0 ;
    FXStream *arg2 = 0 ; FXbool result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXCursor, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    result = (FXbool)FXCursor_savePixels((FXCursor const *)arg1,*arg2); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXCursor_loadPixels(int argc, VALUE *argv, VALUE self) { FXCursor *arg1 = (FXCursor *) 0 ;
    FXStream *arg2 = 0 ; FXbool result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXCursor, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    result = (FXbool)FXCursor_loadPixels(arg1,*arg2); vresult = result ? Qtrue : Qfalse; return vresult; }
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE _wrap_FXCURCursor_allocate(VALUE self) {
#else
     static VALUE _wrap_FXCURCursor_allocate(int argc, VALUE *argv, VALUE self) {
#endif
         VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_FXCURCursor);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
         return vresult; }
static VALUE _wrap_new_FXCURCursor(int argc, VALUE *argv, VALUE self) { FXApp *arg1 = (FXApp *) 0 ; void *arg2 = (void *) 0 ;
    FXCURCursor *result; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXApp, 1); { if (argv[1] != Qnil) { Check_Type(argv[1], T_STRING);
            arg2 = reinterpret_cast<void *>(RSTRING(argv[1])->ptr); }  else { arg2 = NULL; }  }  {
        result = (FXCURCursor *)new_FXCURCursor(arg1,(void const *)arg2);
        DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result); if(rb_block_given_p()){ rb_yield(self); }  }  return self; }
static void
free_FXCURCursor(FXCURCursor *arg1) {
    delete arg1;
}
static VALUE _wrap_FXCURCursor_save(int argc, VALUE *argv, VALUE self) { FXCURCursor *arg1 = (FXCURCursor *) 0 ;
    FXStream *arg2 = 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXCURCursor, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXCURCursor_save((FXCURCursor const *)arg1,*arg2); return Qnil; }
static VALUE _wrap_FXCURCursor_load(int argc, VALUE *argv, VALUE self) { FXCURCursor *arg1 = (FXCURCursor *) 0 ;
    FXStream *arg2 = 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXCURCursor, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXCURCursor_load(arg1,*arg2); return Qnil; }
static VALUE _wrap_FXCURCursor_create(int argc, VALUE *argv, VALUE self) { FXCURCursor *arg1 = (FXCURCursor *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXCURCursor, 1); FXCURCursor_create(arg1); return Qnil; }
static VALUE _wrap_FXCURCursor_detach(int argc, VALUE *argv, VALUE self) { FXCURCursor *arg1 = (FXCURCursor *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXCURCursor, 1); FXCURCursor_detach(arg1); return Qnil; }
static VALUE _wrap_FXCURCursor_destroy(int argc, VALUE *argv, VALUE self) { FXCURCursor *arg1 = (FXCURCursor *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXCURCursor, 1); FXCURCursor_destroy(arg1); return Qnil; }
static VALUE _wrap_FXCURCursor_savePixels(int argc, VALUE *argv, VALUE self) { FXCURCursor *arg1 = (FXCURCursor *) 0 ;
    FXStream *arg2 = 0 ; FXbool result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXCURCursor, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    result = (FXbool)FXCURCursor_savePixels((FXCURCursor const *)arg1,*arg2); vresult = result ? Qtrue : Qfalse;
    return vresult; }
static VALUE _wrap_FXCURCursor_loadPixels(int argc, VALUE *argv, VALUE self) { FXCURCursor *arg1 = (FXCURCursor *) 0 ;
    FXStream *arg2 = 0 ; FXbool result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXCURCursor, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    result = (FXbool)FXCURCursor_loadPixels(arg1,*arg2); vresult = result ? Qtrue : Qfalse; return vresult; }
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE _wrap_FXGIFCursor_allocate(VALUE self) {
#else
     static VALUE _wrap_FXGIFCursor_allocate(int argc, VALUE *argv, VALUE self) {
#endif
         VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_FXGIFCursor);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
         return vresult; }
static VALUE _wrap_new_FXGIFCursor(int argc, VALUE *argv, VALUE self) { FXApp *arg1 = (FXApp *) 0 ; void *arg2 = (void *) 0 ;
    FXint arg3 = (FXint) -1 ; FXint arg4 = (FXint) -1 ; FXGIFCursor *result; if ((argc < 2) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXApp, 1); { if (argv[1] != Qnil) { Check_Type(argv[1], T_STRING);
            arg2 = reinterpret_cast<void *>(RSTRING(argv[1])->ptr); }  else { arg2 = NULL; }  }  if (argc > 2) {
        arg3 = NUM2INT(argv[2]); }  if (argc > 3) { arg4 = NUM2INT(argv[3]); }  {
        result = (FXGIFCursor *)new_FXGIFCursor(arg1,(void const *)arg2,arg3,arg4);
        DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result); if(rb_block_given_p()){ rb_yield(self); }  }  return self; }
static void
free_FXGIFCursor(FXGIFCursor *arg1) {
    delete arg1;
}
static VALUE _wrap_FXGIFCursor_save(int argc, VALUE *argv, VALUE self) { FXGIFCursor *arg1 = (FXGIFCursor *) 0 ;
    FXStream *arg2 = 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGIFCursor, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXGIFCursor_save((FXGIFCursor const *)arg1,*arg2); return Qnil; }
static VALUE _wrap_FXGIFCursor_load(int argc, VALUE *argv, VALUE self) { FXGIFCursor *arg1 = (FXGIFCursor *) 0 ;
    FXStream *arg2 = 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGIFCursor, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXGIFCursor_load(arg1,*arg2); return Qnil; }
static VALUE _wrap_FXGIFCursor_create(int argc, VALUE *argv, VALUE self) { FXGIFCursor *arg1 = (FXGIFCursor *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGIFCursor, 1); FXGIFCursor_create(arg1); return Qnil; }
static VALUE _wrap_FXGIFCursor_detach(int argc, VALUE *argv, VALUE self) { FXGIFCursor *arg1 = (FXGIFCursor *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGIFCursor, 1); FXGIFCursor_detach(arg1); return Qnil; }
static VALUE _wrap_FXGIFCursor_destroy(int argc, VALUE *argv, VALUE self) { FXGIFCursor *arg1 = (FXGIFCursor *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGIFCursor, 1); FXGIFCursor_destroy(arg1); return Qnil; }
static VALUE _wrap_FXGIFCursor_savePixels(int argc, VALUE *argv, VALUE self) { FXGIFCursor *arg1 = (FXGIFCursor *) 0 ;
    FXStream *arg2 = 0 ; FXbool result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGIFCursor, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    result = (FXbool)FXGIFCursor_savePixels((FXGIFCursor const *)arg1,*arg2); vresult = result ? Qtrue : Qfalse;
    return vresult; }
static VALUE _wrap_FXGIFCursor_loadPixels(int argc, VALUE *argv, VALUE self) { FXGIFCursor *arg1 = (FXGIFCursor *) 0 ;
    FXStream *arg2 = 0 ; FXbool result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGIFCursor, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    result = (FXbool)FXGIFCursor_loadPixels(arg1,*arg2); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_fxsaveGIF(int argc, VALUE *argv, VALUE self) { FXStream *arg1 = 0 ; FXColor *arg2 = (FXColor *) 0 ;
    FXint arg3 ; FXint arg4 ; FXbool arg5 = (FXbool) 1 ; FXbool result; VALUE vresult = Qnil; if ((argc < 4) || (argc > 5))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXStream, 1); if (arg1 == NULL) rb_raise(rb_eTypeError, "null reference");
    { arg2=NULL; if(argv[1]!=Qnil){ Check_Type(argv[1],T_ARRAY); if(FXMALLOC(&arg2,FXColor,RARRAY(argv[1])->len)){
                for(long i=0; i<RARRAY(argv[1])->len; i++){ arg2[i]=static_cast<FXColor>(NUM2UINT(rb_ary_entry(argv[1],i))); }  }
             }  }  arg3 = NUM2INT(argv[2]); arg4 = NUM2INT(argv[3]); if (argc > 4) { arg5 = to_FXbool(argv[4]); } 
    result = (FXbool)fxsaveGIF(*arg1,(FXColor const *)arg2,arg3,arg4,arg5); vresult = result ? Qtrue : Qfalse; FXFREE(&arg2);
    return vresult; }
static VALUE _wrap_fxloadGIF(int argc, VALUE *argv, VALUE self) { FXStream *arg1 = 0 ; VALUE result; VALUE vresult = Qnil;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXStream, 1); if (arg1 == NULL) rb_raise(rb_eTypeError, "null reference");
    result = (VALUE)fxloadGIF(*arg1); vresult = result; return vresult; }
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE _wrap_FXDrawable_allocate(VALUE self) {
#else
     static VALUE _wrap_FXDrawable_allocate(int argc, VALUE *argv, VALUE self) {
#endif
         VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_FXDrawable);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
         return vresult; }
static VALUE _wrap_new_FXDrawable(int argc, VALUE *argv, VALUE self) { FXApp *arg1 = (FXApp *) 0 ; FXint arg2 ; FXint arg3 ;
    FXDrawable *result; if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXApp, 1); arg2 = NUM2INT(argv[1]); arg3 = NUM2INT(argv[2]); {
        result = (FXDrawable *)new_FXDrawable(arg1,arg2,arg3); DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result);
        if(rb_block_given_p()){ rb_yield(self); }  }  return self; }
static VALUE _wrap_FXDrawable_getWidth(int argc, VALUE *argv, VALUE self) { FXDrawable *arg1 = (FXDrawable *) 0 ; FXint result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDrawable, 1); result = (FXint)((FXDrawable const *)arg1)->getWidth();
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXDrawable_getHeight(int argc, VALUE *argv, VALUE self) { FXDrawable *arg1 = (FXDrawable *) 0 ; FXint result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDrawable, 1); result = (FXint)((FXDrawable const *)arg1)->getHeight();
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXDrawable_getVisual(int argc, VALUE *argv, VALUE self) { FXDrawable *arg1 = (FXDrawable *) 0 ;
    FXVisual *result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDrawable, 1);
    result = (FXVisual *)((FXDrawable const *)arg1)->getVisual(); {
        swig_type_info *ty = SWIG_TypeDynamicCast(SWIGTYPE_p_FXVisual, (void **) &result);
        vresult = FXRbGetRubyObj(result, ty); }  return vresult; }
static VALUE _wrap_FXDrawable_setVisual(int argc, VALUE *argv, VALUE self) { FXDrawable *arg1 = (FXDrawable *) 0 ;
    FXVisual *arg2 = (FXVisual *) 0 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDrawable, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXVisual, 1); (arg1)->setVisual(arg2); return Qnil; }
static void
free_FXDrawable(FXDrawable *arg1) {
    delete arg1;
}
static VALUE _wrap_FXDrawable_save(int argc, VALUE *argv, VALUE self) { FXDrawable *arg1 = (FXDrawable *) 0 ;
    FXStream *arg2 = 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDrawable, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXDrawable_save((FXDrawable const *)arg1,*arg2); return Qnil; }
static VALUE _wrap_FXDrawable_load(int argc, VALUE *argv, VALUE self) { FXDrawable *arg1 = (FXDrawable *) 0 ;
    FXStream *arg2 = 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDrawable, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXDrawable_load(arg1,*arg2); return Qnil; }
static VALUE _wrap_FXDrawable_create(int argc, VALUE *argv, VALUE self) { FXDrawable *arg1 = (FXDrawable *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDrawable, 1); FXDrawable_create(arg1); return Qnil; }
static VALUE _wrap_FXDrawable_detach(int argc, VALUE *argv, VALUE self) { FXDrawable *arg1 = (FXDrawable *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDrawable, 1); FXDrawable_detach(arg1); return Qnil; }
static VALUE _wrap_FXDrawable_destroy(int argc, VALUE *argv, VALUE self) { FXDrawable *arg1 = (FXDrawable *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDrawable, 1); FXDrawable_destroy(arg1); return Qnil; }
static VALUE _wrap_FXDrawable_resize(int argc, VALUE *argv, VALUE self) { FXDrawable *arg1 = (FXDrawable *) 0 ; FXint arg2 ;
    FXint arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDrawable, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    FXDrawable_resize(arg1,arg2,arg3); return Qnil; }
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE _wrap_FXVisual_allocate(VALUE self) {
#else
     static VALUE _wrap_FXVisual_allocate(int argc, VALUE *argv, VALUE self) {
#endif
         VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_FXVisual);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
         return vresult; }
static VALUE _wrap_new_FXVisual(int argc, VALUE *argv, VALUE self) { FXApp *arg1 = (FXApp *) 0 ; FXuint arg2 ;
    FXuint arg3 = (FXuint) 32 ; FXVisual *result; if ((argc < 2) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXApp, 1); arg2 = NUM2UINT(argv[1]); if (argc > 2) {
        arg3 = NUM2UINT(argv[2]); }  { result = (FXVisual *)new_FXVisual(arg1,arg2,arg3);
        DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result); if(rb_block_given_p()){ rb_yield(self); }  }  return self; }
static VALUE _wrap_FXVisual_visualType(int argc, VALUE *argv, VALUE self) { FXVisual *arg1 = (FXVisual *) 0 ; int result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXVisual, 1); result = (int)((FXVisual const *)arg1)->getType();
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXVisual_getFlags(int argc, VALUE *argv, VALUE self) { FXVisual *arg1 = (FXVisual *) 0 ; FXuint result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXVisual, 1); result = (FXuint)((FXVisual const *)arg1)->getFlags();
    vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXVisual_getDepth(int argc, VALUE *argv, VALUE self) { FXVisual *arg1 = (FXVisual *) 0 ; FXuint result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXVisual, 1); result = (FXuint)((FXVisual const *)arg1)->getDepth();
    vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXVisual_getNumColors(int argc, VALUE *argv, VALUE self) { FXVisual *arg1 = (FXVisual *) 0 ; FXuint result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXVisual, 1); result = (FXuint)((FXVisual const *)arg1)->getNumColors();
    vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXVisual_getNumRed(int argc, VALUE *argv, VALUE self) { FXVisual *arg1 = (FXVisual *) 0 ; FXuint result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXVisual, 1); result = (FXuint)((FXVisual const *)arg1)->getNumRed();
    vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXVisual_getNumGreen(int argc, VALUE *argv, VALUE self) { FXVisual *arg1 = (FXVisual *) 0 ; FXuint result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXVisual, 1); result = (FXuint)((FXVisual const *)arg1)->getNumGreen();
    vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXVisual_getNumBlue(int argc, VALUE *argv, VALUE self) { FXVisual *arg1 = (FXVisual *) 0 ; FXuint result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXVisual, 1); result = (FXuint)((FXVisual const *)arg1)->getNumBlue();
    vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXVisual_getPixel(int argc, VALUE *argv, VALUE self) { FXVisual *arg1 = (FXVisual *) 0 ; FXColor arg2 ;
    FXPixel result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXVisual, 1); arg2 = to_FXColor(argv[0]);
    result = (FXPixel)(arg1)->getPixel(arg2); vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXVisual_getColor(int argc, VALUE *argv, VALUE self) { FXVisual *arg1 = (FXVisual *) 0 ; FXPixel arg2 ;
    FXColor result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXVisual, 1); arg2 = NUM2ULONG(argv[0]);
    result = (FXColor)(arg1)->getColor(arg2); vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXVisual_setMaxColors(int argc, VALUE *argv, VALUE self) { FXVisual *arg1 = (FXVisual *) 0 ; FXuint arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXVisual, 1); arg2 = NUM2UINT(argv[0]); (arg1)->setMaxColors(arg2);
    return Qnil; }
static VALUE _wrap_FXVisual_getMaxColors(int argc, VALUE *argv, VALUE self) { FXVisual *arg1 = (FXVisual *) 0 ; FXuint result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXVisual, 1); result = (FXuint)((FXVisual const *)arg1)->getMaxColors();
    vresult = UINT2NUM(result); return vresult; }
static void
free_FXVisual(FXVisual *arg1) {
    delete arg1;
}
static VALUE _wrap_FXVisual_save(int argc, VALUE *argv, VALUE self) { FXVisual *arg1 = (FXVisual *) 0 ; FXStream *arg2 = 0 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXVisual, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXVisual_save((FXVisual const *)arg1,*arg2); return Qnil; }
static VALUE _wrap_FXVisual_load(int argc, VALUE *argv, VALUE self) { FXVisual *arg1 = (FXVisual *) 0 ; FXStream *arg2 = 0 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXVisual, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXVisual_load(arg1,*arg2); return Qnil; }
static VALUE _wrap_FXVisual_create(int argc, VALUE *argv, VALUE self) { FXVisual *arg1 = (FXVisual *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXVisual, 1); FXVisual_create(arg1); return Qnil; }
static VALUE _wrap_FXVisual_detach(int argc, VALUE *argv, VALUE self) { FXVisual *arg1 = (FXVisual *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXVisual, 1); FXVisual_detach(arg1); return Qnil; }
static VALUE _wrap_FXVisual_destroy(int argc, VALUE *argv, VALUE self) { FXVisual *arg1 = (FXVisual *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXVisual, 1); FXVisual_destroy(arg1); return Qnil; }
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE _wrap_FXFontDesc_allocate(VALUE self) {
#else
     static VALUE _wrap_FXFontDesc_allocate(int argc, VALUE *argv, VALUE self) {
#endif
         VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_FXFontDesc);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
         return vresult; }
static VALUE _wrap_new_FXFontDesc(int argc, VALUE *argv, VALUE self) { FXFontDesc *result; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc); result = (FXFontDesc *)new FXFontDesc();
    DATA_PTR(self) = result; return self; }
static VALUE _wrap_FXFontDesc_face_set(int argc, VALUE *argv, VALUE self) { FXFontDesc *arg1 = (FXFontDesc *) 0 ; FXchar *arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFontDesc, 1); arg2 = StringValuePtr(argv[0]); {
        if (arg2) strncpy(arg1->face,arg2,104); else arg1->face[0] = 0; }  return Qnil; }
static VALUE _wrap_FXFontDesc_face_get(int argc, VALUE *argv, VALUE self) { FXFontDesc *arg1 = (FXFontDesc *) 0 ;
    FXchar *result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFontDesc, 1); result = (FXchar *)(FXchar *) ((arg1)->face);
    vresult = rb_str_new2(result); return vresult; }
static VALUE _wrap_FXFontDesc_size_set(int argc, VALUE *argv, VALUE self) { FXFontDesc *arg1 = (FXFontDesc *) 0 ; FXuint arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFontDesc, 1); arg2 = NUM2UINT(argv[0]); if (arg1) (arg1)->size = arg2;
    return Qnil; }
static VALUE _wrap_FXFontDesc_size_get(int argc, VALUE *argv, VALUE self) { FXFontDesc *arg1 = (FXFontDesc *) 0 ; FXuint result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFontDesc, 1); result = (FXuint) ((arg1)->size);
    vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXFontDesc_weight_set(int argc, VALUE *argv, VALUE self) { FXFontDesc *arg1 = (FXFontDesc *) 0 ;
    FXuint arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFontDesc, 1); arg2 = NUM2UINT(argv[0]); if (arg1) (arg1)->weight = arg2;
    return Qnil; }
static VALUE _wrap_FXFontDesc_weight_get(int argc, VALUE *argv, VALUE self) { FXFontDesc *arg1 = (FXFontDesc *) 0 ;
    FXuint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFontDesc, 1); result = (FXuint) ((arg1)->weight);
    vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXFontDesc_slant_set(int argc, VALUE *argv, VALUE self) { FXFontDesc *arg1 = (FXFontDesc *) 0 ; FXuint arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFontDesc, 1); arg2 = NUM2UINT(argv[0]); if (arg1) (arg1)->slant = arg2;
    return Qnil; }
static VALUE _wrap_FXFontDesc_slant_get(int argc, VALUE *argv, VALUE self) { FXFontDesc *arg1 = (FXFontDesc *) 0 ;
    FXuint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFontDesc, 1); result = (FXuint) ((arg1)->slant);
    vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXFontDesc_setwidth_set(int argc, VALUE *argv, VALUE self) { FXFontDesc *arg1 = (FXFontDesc *) 0 ;
    FXuint arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFontDesc, 1); arg2 = NUM2UINT(argv[0]);
    if (arg1) (arg1)->setwidth = arg2; return Qnil; }
static VALUE _wrap_FXFontDesc_setwidth_get(int argc, VALUE *argv, VALUE self) { FXFontDesc *arg1 = (FXFontDesc *) 0 ;
    FXuint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFontDesc, 1); result = (FXuint) ((arg1)->setwidth);
    vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXFontDesc_encoding_set(int argc, VALUE *argv, VALUE self) { FXFontDesc *arg1 = (FXFontDesc *) 0 ;
    FXuint arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFontDesc, 1); arg2 = NUM2UINT(argv[0]);
    if (arg1) (arg1)->encoding = arg2; return Qnil; }
static VALUE _wrap_FXFontDesc_encoding_get(int argc, VALUE *argv, VALUE self) { FXFontDesc *arg1 = (FXFontDesc *) 0 ;
    FXuint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFontDesc, 1); result = (FXuint) ((arg1)->encoding);
    vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXFontDesc_flags_set(int argc, VALUE *argv, VALUE self) { FXFontDesc *arg1 = (FXFontDesc *) 0 ; FXuint arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFontDesc, 1); arg2 = NUM2UINT(argv[0]); if (arg1) (arg1)->flags = arg2;
    return Qnil; }
static VALUE _wrap_FXFontDesc_flags_get(int argc, VALUE *argv, VALUE self) { FXFontDesc *arg1 = (FXFontDesc *) 0 ;
    FXuint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFontDesc, 1); result = (FXuint) ((arg1)->flags);
    vresult = UINT2NUM(result); return vresult; }
static void
free_FXFontDesc(FXFontDesc *arg1) {
    delete arg1;
}
static VALUE _wrap_new_FXFont__SWIG_0(int argc, VALUE *argv, VALUE self) { FXApp *arg1 = (FXApp *) 0 ; FXString *arg2 = 0 ;
    FXFont *result; SwigValueWrapper<FXString > p2 ; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXApp, 1); p2 = to_FXString(argv[1]); arg2 = &p2; {
        result = (FXFont *)new_FXFont__SWIG_0(arg1,(FXString const &)*arg2);
        DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result); if(rb_block_given_p()){ rb_yield(self); }  }  return self; }
static VALUE _wrap_new_FXFont__SWIG_1(int argc, VALUE *argv, VALUE self) { FXApp *arg1 = (FXApp *) 0 ; FXString *arg2 = 0 ;
    FXuint arg3 ; FXuint arg4 = (FXuint) FONTWEIGHT_NORMAL ; FXuint arg5 = (FXuint) FONTSLANT_REGULAR ;
    FXuint arg6 = (FXuint) FONTENCODING_DEFAULT ; FXuint arg7 = (FXuint) FONTSETWIDTH_DONTCARE ; FXuint arg8 = (FXuint) 0 ;
    FXFont *result; SwigValueWrapper<FXString > p2 ; if ((argc < 3) || (argc > 8))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXApp, 1); p2 = to_FXString(argv[1]); arg2 = &p2;
    arg3 = NUM2UINT(argv[2]); if (argc > 3) { arg4 = NUM2UINT(argv[3]); }  if (argc > 4) { arg5 = NUM2UINT(argv[4]); } 
    if (argc > 5) { arg6 = NUM2UINT(argv[5]); }  if (argc > 6) { arg7 = NUM2UINT(argv[6]); }  if (argc > 7) {
        arg8 = NUM2UINT(argv[7]); }  {
        result = (FXFont *)new_FXFont__SWIG_1(arg1,(FXString const &)*arg2,arg3,arg4,arg5,arg6,arg7,arg8);
        DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result); if(rb_block_given_p()){ rb_yield(self); }  }  return self; }
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE _wrap_FXFont_allocate(VALUE self) {
#else
     static VALUE _wrap_FXFont_allocate(int argc, VALUE *argv, VALUE self) {
#endif
         VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_FXFont);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
         return vresult; }
static VALUE _wrap_new_FXFont__SWIG_2(int argc, VALUE *argv, VALUE self) { FXApp *arg1 = (FXApp *) 0 ; FXFontDesc *arg2 = 0 ;
    FXFont *result; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXApp, 1);
    SWIG_ConvertPtr(argv[1], (void **) &arg2, SWIGTYPE_p_FXFontDesc, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    { result = (FXFont *)new_FXFont__SWIG_2(arg1,(FXFontDesc const &)*arg2);
        DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result); if(rb_block_given_p()){ rb_yield(self); }  }  return self; }
static VALUE _wrap_new_FXFont(int nargs, VALUE *args, VALUE self) { int argc; VALUE argv[8]; int ii; argc = nargs;
    for (ii = 0; (ii < argc) && (ii < 8); ii++) { argv[ii] = args[ii]; }  if (argc == 2) { int _v; { void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXApp, 0) != -1)) ? 1 : 0; }
         if (_v) { { void *ptr;
                _v = (NIL_P(argv[1]) || (TYPE(argv[1]) == T_DATA && SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_FXFontDesc, 0) != -1)) ? 1 : 0; }
             if (_v) { return _wrap_new_FXFont__SWIG_2(nargs, args, self);}  }  }  if (argc == 2) { int _v; { void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXApp, 0) != -1)) ? 1 : 0; }
         if (_v) { { _v = (NIL_P(argv[1]) || TYPE(argv[1]) == T_STRING) ? 1 : 0; }  if (_v) {
                return _wrap_new_FXFont__SWIG_0(nargs, args, self);}  }  }  if ((argc >= 3) && (argc <= 8)) { int _v; {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXApp, 0) != -1)) ? 1 : 0; }
         if (_v) { { _v = (NIL_P(argv[1]) || TYPE(argv[1]) == T_STRING) ? 1 : 0; }  if (_v) { {
                    _v = ((TYPE(argv[2]) == T_FIXNUM) || (TYPE(argv[2]) == T_BIGNUM)) ? 1 : 0; }  if (_v) { if (argc <= 3) {
                        return _wrap_new_FXFont__SWIG_1(nargs, args, self);}  {
                        _v = ((TYPE(argv[3]) == T_FIXNUM) || (TYPE(argv[3]) == T_BIGNUM)) ? 1 : 0; }  if (_v) { if (argc <= 4) {
                            return _wrap_new_FXFont__SWIG_1(nargs, args, self);}  {
                            _v = ((TYPE(argv[4]) == T_FIXNUM) || (TYPE(argv[4]) == T_BIGNUM)) ? 1 : 0; }  if (_v) {
                            if (argc <= 5) { return _wrap_new_FXFont__SWIG_1(nargs, args, self);}  {
                                _v = ((TYPE(argv[5]) == T_FIXNUM) || (TYPE(argv[5]) == T_BIGNUM)) ? 1 : 0; }  if (_v) {
                                if (argc <= 6) { return _wrap_new_FXFont__SWIG_1(nargs, args, self);}  {
                                    _v = ((TYPE(argv[6]) == T_FIXNUM) || (TYPE(argv[6]) == T_BIGNUM)) ? 1 : 0; }  if (_v) {
                                    if (argc <= 7) { return _wrap_new_FXFont__SWIG_1(nargs, args, self);}  {
                                        _v = ((TYPE(argv[7]) == T_FIXNUM) || (TYPE(argv[7]) == T_BIGNUM)) ? 1 : 0; }  if (_v) {
                                        return _wrap_new_FXFont__SWIG_1(nargs, args, self);}  }  }  }  }  }  }  }  } 
    rb_raise(rb_eArgError, "No matching function for overloaded 'new_FXFont'"); return Qnil; }
static VALUE _wrap_FXFont_getName(int argc, VALUE *argv, VALUE self) { FXFont *arg1 = (FXFont *) 0 ; FXString result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFont, 1); result = ((FXFont const *)arg1)->getName();
    vresult = rb_str_new2((&result)->text()); return vresult; }
static VALUE _wrap_FXFont_getActualName(int argc, VALUE *argv, VALUE self) { FXFont *arg1 = (FXFont *) 0 ; FXString result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFont, 1); result = ((FXFont const *)arg1)->getActualName();
    vresult = rb_str_new2((&result)->text()); return vresult; }
static VALUE _wrap_FXFont_getSize(int argc, VALUE *argv, VALUE self) { FXFont *arg1 = (FXFont *) 0 ; FXuint result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFont, 1); result = (FXuint)((FXFont const *)arg1)->getSize();
    vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXFont_getActualSize(int argc, VALUE *argv, VALUE self) { FXFont *arg1 = (FXFont *) 0 ; FXuint result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFont, 1); result = (FXuint)((FXFont const *)arg1)->getActualSize();
    vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXFont_getWeight(int argc, VALUE *argv, VALUE self) { FXFont *arg1 = (FXFont *) 0 ; FXuint result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFont, 1); result = (FXuint)((FXFont const *)arg1)->getWeight();
    vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXFont_getActualWeight(int argc, VALUE *argv, VALUE self) { FXFont *arg1 = (FXFont *) 0 ; FXuint result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFont, 1); result = (FXuint)((FXFont const *)arg1)->getActualWeight();
    vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXFont_getSlant(int argc, VALUE *argv, VALUE self) { FXFont *arg1 = (FXFont *) 0 ; FXuint result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFont, 1); result = (FXuint)((FXFont const *)arg1)->getSlant();
    vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXFont_getActualSlant(int argc, VALUE *argv, VALUE self) { FXFont *arg1 = (FXFont *) 0 ; FXuint result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFont, 1); result = (FXuint)((FXFont const *)arg1)->getActualSlant();
    vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXFont_getEncoding(int argc, VALUE *argv, VALUE self) { FXFont *arg1 = (FXFont *) 0 ; FXuint result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFont, 1); result = (FXuint)((FXFont const *)arg1)->getEncoding();
    vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXFont_getActualEncoding(int argc, VALUE *argv, VALUE self) { FXFont *arg1 = (FXFont *) 0 ; FXuint result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFont, 1); result = (FXuint)((FXFont const *)arg1)->getActualEncoding();
    vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXFont_getSetWidth(int argc, VALUE *argv, VALUE self) { FXFont *arg1 = (FXFont *) 0 ; FXuint result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFont, 1); result = (FXuint)((FXFont const *)arg1)->getSetWidth();
    vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXFont_getActualSetWidth(int argc, VALUE *argv, VALUE self) { FXFont *arg1 = (FXFont *) 0 ; FXuint result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFont, 1); result = (FXuint)((FXFont const *)arg1)->getActualSetWidth();
    vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXFont_getHints(int argc, VALUE *argv, VALUE self) { FXFont *arg1 = (FXFont *) 0 ; FXuint result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFont, 1); result = (FXuint)((FXFont const *)arg1)->getHints();
    vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXFont_setFontDesc(int argc, VALUE *argv, VALUE self) { FXFont *arg1 = (FXFont *) 0 ; FXFontDesc *arg2 = 0 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFont, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXFontDesc, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    (arg1)->setFontDesc((FXFontDesc const &)*arg2); return Qnil; }
static VALUE _wrap_FXFont_getFontDesc(int argc, VALUE *argv, VALUE self) { FXFont *arg1 = (FXFont *) 0 ; FXFontDesc result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFont, 1); result = FXFont_getFontDesc((FXFont const *)arg1); {
        FXFontDesc* resultptr = new FXFontDesc(result); vresult = FXRbGetRubyObj(resultptr, "FXFontDesc *"); }  return vresult; }
static VALUE _wrap_FXFont_setFont(int argc, VALUE *argv, VALUE self) { FXFont *arg1 = (FXFont *) 0 ; FXString *arg2 = 0 ;
    FXbool result; SwigValueWrapper<FXString > p2 ; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc); SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFont, 1);
    p2 = to_FXString(argv[0]); arg2 = &p2; result = (FXbool)(arg1)->setFont((FXString const &)*arg2);
    vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXFont_getFont(int argc, VALUE *argv, VALUE self) { FXFont *arg1 = (FXFont *) 0 ; FXString result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFont, 1); result = ((FXFont const *)arg1)->getFont();
    vresult = rb_str_new2((&result)->text()); return vresult; }
static VALUE _wrap_FXFont_isFontMono(int argc, VALUE *argv, VALUE self) { FXFont *arg1 = (FXFont *) 0 ; FXbool result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFont, 1); result = (FXbool)((FXFont const *)arg1)->isFontMono();
    vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXFont_hasChar(int argc, VALUE *argv, VALUE self) { FXFont *arg1 = (FXFont *) 0 ; VALUE arg2 ; FXbool result;
    VALUE vresult = Qnil; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFont, 1); arg2 = argv[0];
    result = (FXbool)FXFont_hasChar((FXFont const *)arg1,arg2); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXFont_getMinChar(int argc, VALUE *argv, VALUE self) { FXFont *arg1 = (FXFont *) 0 ; FXint result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFont, 1); result = (FXint)((FXFont const *)arg1)->getMinChar();
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXFont_getMaxChar(int argc, VALUE *argv, VALUE self) { FXFont *arg1 = (FXFont *) 0 ; FXint result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFont, 1); result = (FXint)((FXFont const *)arg1)->getMaxChar();
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXFont_leftBearing(int argc, VALUE *argv, VALUE self) { FXFont *arg1 = (FXFont *) 0 ; FXchar arg2 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc); SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFont, 1);
    arg2 = NUM2CHR(argv[0]); result = (FXint)((FXFont const *)arg1)->leftBearing(arg2); vresult = INT2NUM(result);
    return vresult; }
static VALUE _wrap_FXFont_rightBearing(int argc, VALUE *argv, VALUE self) { FXFont *arg1 = (FXFont *) 0 ; FXchar arg2 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc); SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFont, 1);
    arg2 = NUM2CHR(argv[0]); result = (FXint)((FXFont const *)arg1)->rightBearing(arg2); vresult = INT2NUM(result);
    return vresult; }
static VALUE _wrap_FXFont_getFontWidth(int argc, VALUE *argv, VALUE self) { FXFont *arg1 = (FXFont *) 0 ; FXint result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFont, 1); result = (FXint)((FXFont const *)arg1)->getFontWidth();
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXFont_getFontHeight(int argc, VALUE *argv, VALUE self) { FXFont *arg1 = (FXFont *) 0 ; FXint result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFont, 1); result = (FXint)((FXFont const *)arg1)->getFontHeight();
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXFont_getFontAscent(int argc, VALUE *argv, VALUE self) { FXFont *arg1 = (FXFont *) 0 ; FXint result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFont, 1); result = (FXint)((FXFont const *)arg1)->getFontAscent();
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXFont_getFontDescent(int argc, VALUE *argv, VALUE self) { FXFont *arg1 = (FXFont *) 0 ; FXint result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFont, 1); result = (FXint)((FXFont const *)arg1)->getFontDescent();
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXFont_getFontLeading(int argc, VALUE *argv, VALUE self) { FXFont *arg1 = (FXFont *) 0 ; FXint result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFont, 1); result = (FXint)((FXFont const *)arg1)->getFontLeading();
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXFont_getFontSpacing(int argc, VALUE *argv, VALUE self) { FXFont *arg1 = (FXFont *) 0 ; FXint result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFont, 1); result = (FXint)((FXFont const *)arg1)->getFontSpacing();
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXFont_getTextWidth(int argc, VALUE *argv, VALUE self) { FXFont *arg1 = (FXFont *) 0 ; VALUE arg2 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc); SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFont, 1);
    arg2 = argv[0]; result = (FXint)FXFont_getTextWidth((FXFont const *)arg1,arg2); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXFont_getTextHeight(int argc, VALUE *argv, VALUE self) { FXFont *arg1 = (FXFont *) 0 ; VALUE arg2 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc); SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFont, 1);
    arg2 = argv[0]; result = (FXint)FXFont_getTextHeight((FXFont const *)arg1,arg2); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXFont_listFonts(int argc, VALUE *argv, VALUE self) { FXString *arg1 = 0 ;
    FXuint arg2 = (FXuint) FONTWEIGHT_DONTCARE ; FXuint arg3 = (FXuint) FONTSLANT_DONTCARE ;
    FXuint arg4 = (FXuint) FONTSETWIDTH_DONTCARE ; FXuint arg5 = (FXuint) FONTENCODING_DEFAULT ; FXuint arg6 = (FXuint) 0 ;
    VALUE result; SwigValueWrapper<FXString > p1 ; VALUE vresult = Qnil; if ((argc < 1) || (argc > 6))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc); p1 = to_FXString(argv[0]); arg1 = &p1; if (argc > 1) {
        arg2 = NUM2UINT(argv[1]); }  if (argc > 2) { arg3 = NUM2UINT(argv[2]); }  if (argc > 3) { arg4 = NUM2UINT(argv[3]); } 
    if (argc > 4) { arg5 = NUM2UINT(argv[4]); }  if (argc > 5) { arg6 = NUM2UINT(argv[5]); } 
    result = (VALUE)FXFont_listFonts((FXString const &)*arg1,arg2,arg3,arg4,arg5,arg6); vresult = result; return vresult; }
static void
free_FXFont(FXFont *arg1) {
    delete arg1;
}
static VALUE _wrap_FXFont_save(int argc, VALUE *argv, VALUE self) { FXFont *arg1 = (FXFont *) 0 ; FXStream *arg2 = 0 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFont, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXFont_save((FXFont const *)arg1,*arg2); return Qnil; }
static VALUE _wrap_FXFont_load(int argc, VALUE *argv, VALUE self) { FXFont *arg1 = (FXFont *) 0 ; FXStream *arg2 = 0 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFont, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXFont_load(arg1,*arg2); return Qnil; }
static VALUE _wrap_FXFont_create(int argc, VALUE *argv, VALUE self) { FXFont *arg1 = (FXFont *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFont, 1); FXFont_create(arg1); return Qnil; }
static VALUE _wrap_FXFont_detach(int argc, VALUE *argv, VALUE self) { FXFont *arg1 = (FXFont *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFont, 1); FXFont_detach(arg1); return Qnil; }
static VALUE _wrap_FXFont_destroy(int argc, VALUE *argv, VALUE self) { FXFont *arg1 = (FXFont *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFont, 1); FXFont_destroy(arg1); return Qnil; }
static VALUE _wrap_fxparsefontdesc(int argc, VALUE *argv, VALUE self) { FXchar *arg1 ; FXFontDesc *result; VALUE vresult = Qnil;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc); arg1 = StringValuePtr(argv[0]);
    result = (FXFontDesc *)fxparsefontdesc2((FXchar const *)arg1); vresult = FXRbGetRubyObj(result, "FXFontDesc *");
    return vresult; }
static VALUE _wrap_fxunparsefontdesc(int argc, VALUE *argv, VALUE self) { FXFontDesc *arg1 = 0 ; FXString result;
    VALUE vresult = Qnil; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXFontDesc, 1); if (arg1 == NULL) rb_raise(rb_eTypeError, "null reference");
    result = fxunparsefontdesc2((FXFontDesc const &)*arg1); vresult = rb_str_new2((&result)->text()); return vresult; }
static VALUE FXWindow_deleteType_get(VALUE self) { VALUE _val; _val = UINT2NUM(FXWindow::deleteType);    return _val; }
static VALUE FXWindow_deleteType_set(VALUE self, VALUE _val) { FXWindow::deleteType = NUM2UINT(_val); return _val; }
static VALUE FXWindow_textType_get(VALUE self) { VALUE _val; _val = UINT2NUM(FXWindow::textType);    return _val; }
static VALUE FXWindow_textType_set(VALUE self, VALUE _val) { FXWindow::textType = NUM2UINT(_val); return _val; }
static VALUE FXWindow_colorType_get(VALUE self) { VALUE _val; _val = UINT2NUM(FXWindow::colorType);    return _val; }
static VALUE FXWindow_colorType_set(VALUE self, VALUE _val) { FXWindow::colorType = NUM2UINT(_val); return _val; }
static VALUE FXWindow_urilistType_get(VALUE self) { VALUE _val; _val = UINT2NUM(FXWindow::urilistType);    return _val; }
static VALUE FXWindow_urilistType_set(VALUE self, VALUE _val) { FXWindow::urilistType = NUM2UINT(_val); return _val; }
static VALUE FXWindow_stringType_get(VALUE self) { VALUE _val; _val = UINT2NUM(FXWindow::stringType);    return _val; }
static VALUE FXWindow_imageType_get(VALUE self) { VALUE _val; _val = UINT2NUM(FXWindow::imageType);    return _val; }
static VALUE _wrap_FXWindow_onPaint(int argc, VALUE *argv, VALUE self) { FXWindow *arg1 = (FXWindow *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXWindow, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onPaint(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXWindow_onMap(int argc, VALUE *argv, VALUE self) { FXWindow *arg1 = (FXWindow *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXWindow, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onMap(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXWindow_onUnmap(int argc, VALUE *argv, VALUE self) { FXWindow *arg1 = (FXWindow *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXWindow, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onUnmap(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXWindow_onConfigure(int argc, VALUE *argv, VALUE self) { FXWindow *arg1 = (FXWindow *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXWindow, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onConfigure(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXWindow_onUpdate(int argc, VALUE *argv, VALUE self) { FXWindow *arg1 = (FXWindow *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXWindow, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onUpdate(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXWindow_onMotion(int argc, VALUE *argv, VALUE self) { FXWindow *arg1 = (FXWindow *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXWindow, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onMotion(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXWindow_onMouseWheel(int argc, VALUE *argv, VALUE self) { FXWindow *arg1 = (FXWindow *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXWindow, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onMouseWheel(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXWindow_onEnter(int argc, VALUE *argv, VALUE self) { FXWindow *arg1 = (FXWindow *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXWindow, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onEnter(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXWindow_onLeave(int argc, VALUE *argv, VALUE self) { FXWindow *arg1 = (FXWindow *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXWindow, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onLeave(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXWindow_onLeftBtnPress(int argc, VALUE *argv, VALUE self) { FXWindow *arg1 = (FXWindow *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXWindow, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onLeftBtnPress(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXWindow_onLeftBtnRelease(int argc, VALUE *argv, VALUE self) { FXWindow *arg1 = (FXWindow *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXWindow, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onLeftBtnRelease(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXWindow_onMiddleBtnPress(int argc, VALUE *argv, VALUE self) { FXWindow *arg1 = (FXWindow *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXWindow, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onMiddleBtnPress(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXWindow_onMiddleBtnRelease(int argc, VALUE *argv, VALUE self) { FXWindow *arg1 = (FXWindow *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXWindow, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onMiddleBtnRelease(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXWindow_onRightBtnPress(int argc, VALUE *argv, VALUE self) { FXWindow *arg1 = (FXWindow *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXWindow, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onRightBtnPress(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXWindow_onRightBtnRelease(int argc, VALUE *argv, VALUE self) { FXWindow *arg1 = (FXWindow *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXWindow, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onRightBtnRelease(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXWindow_onBeginDrag(int argc, VALUE *argv, VALUE self) { FXWindow *arg1 = (FXWindow *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXWindow, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onBeginDrag(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXWindow_onEndDrag(int argc, VALUE *argv, VALUE self) { FXWindow *arg1 = (FXWindow *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXWindow, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onEndDrag(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXWindow_onDragged(int argc, VALUE *argv, VALUE self) { FXWindow *arg1 = (FXWindow *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXWindow, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onDragged(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXWindow_onKeyPress(int argc, VALUE *argv, VALUE self) { FXWindow *arg1 = (FXWindow *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXWindow, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onKeyPress(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXWindow_onKeyRelease(int argc, VALUE *argv, VALUE self) { FXWindow *arg1 = (FXWindow *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXWindow, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onKeyRelease(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXWindow_onUngrabbed(int argc, VALUE *argv, VALUE self) { FXWindow *arg1 = (FXWindow *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXWindow, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onUngrabbed(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXWindow_onDestroy(int argc, VALUE *argv, VALUE self) { FXWindow *arg1 = (FXWindow *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXWindow, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onDestroy(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXWindow_onFocusSelf(int argc, VALUE *argv, VALUE self) { FXWindow *arg1 = (FXWindow *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXWindow, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onFocusSelf(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXWindow_onFocusIn(int argc, VALUE *argv, VALUE self) { FXWindow *arg1 = (FXWindow *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXWindow, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onFocusIn(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXWindow_onFocusOut(int argc, VALUE *argv, VALUE self) { FXWindow *arg1 = (FXWindow *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXWindow, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onFocusOut(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXWindow_onSelectionLost(int argc, VALUE *argv, VALUE self) { FXWindow *arg1 = (FXWindow *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXWindow, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onSelectionLost(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXWindow_onSelectionGained(int argc, VALUE *argv, VALUE self) { FXWindow *arg1 = (FXWindow *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXWindow, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onSelectionGained(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXWindow_onSelectionRequest(int argc, VALUE *argv, VALUE self) { FXWindow *arg1 = (FXWindow *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXWindow, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onSelectionRequest(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXWindow_onClipboardLost(int argc, VALUE *argv, VALUE self) { FXWindow *arg1 = (FXWindow *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXWindow, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onClipboardLost(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXWindow_onClipboardGained(int argc, VALUE *argv, VALUE self) { FXWindow *arg1 = (FXWindow *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXWindow, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onClipboardGained(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXWindow_onClipboardRequest(int argc, VALUE *argv, VALUE self) { FXWindow *arg1 = (FXWindow *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXWindow, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onClipboardRequest(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXWindow_onDNDEnter(int argc, VALUE *argv, VALUE self) { FXWindow *arg1 = (FXWindow *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXWindow, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onDNDEnter(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXWindow_onDNDLeave(int argc, VALUE *argv, VALUE self) { FXWindow *arg1 = (FXWindow *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXWindow, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onDNDLeave(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXWindow_onDNDMotion(int argc, VALUE *argv, VALUE self) { FXWindow *arg1 = (FXWindow *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXWindow, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onDNDMotion(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXWindow_onDNDDrop(int argc, VALUE *argv, VALUE self) { FXWindow *arg1 = (FXWindow *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXWindow, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onDNDDrop(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXWindow_onDNDRequest(int argc, VALUE *argv, VALUE self) { FXWindow *arg1 = (FXWindow *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXWindow, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onDNDRequest(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXWindow_onCmdShow(int argc, VALUE *argv, VALUE self) { FXWindow *arg1 = (FXWindow *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXWindow, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdShow(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXWindow_onCmdHide(int argc, VALUE *argv, VALUE self) { FXWindow *arg1 = (FXWindow *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXWindow, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdHide(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXWindow_onUpdToggleShown(int argc, VALUE *argv, VALUE self) { FXWindow *arg1 = (FXWindow *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXWindow, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onUpdToggleShown(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXWindow_onCmdToggleShown(int argc, VALUE *argv, VALUE self) { FXWindow *arg1 = (FXWindow *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXWindow, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdToggleShown(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXWindow_onCmdRaise(int argc, VALUE *argv, VALUE self) { FXWindow *arg1 = (FXWindow *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXWindow, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdRaise(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXWindow_onCmdLower(int argc, VALUE *argv, VALUE self) { FXWindow *arg1 = (FXWindow *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXWindow, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdLower(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXWindow_onCmdEnable(int argc, VALUE *argv, VALUE self) { FXWindow *arg1 = (FXWindow *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXWindow, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdEnable(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXWindow_onCmdDisable(int argc, VALUE *argv, VALUE self) { FXWindow *arg1 = (FXWindow *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXWindow, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdDisable(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXWindow_onCmdUpdate(int argc, VALUE *argv, VALUE self) { FXWindow *arg1 = (FXWindow *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXWindow, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdUpdate(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXWindow_onUpdYes(int argc, VALUE *argv, VALUE self) { FXWindow *arg1 = (FXWindow *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXWindow, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onUpdYes(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXWindow_onCmdDelete(int argc, VALUE *argv, VALUE self) { FXWindow *arg1 = (FXWindow *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXWindow, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdDelete(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXWindow_deleteTypeName(int argc, VALUE *argv, VALUE self) { VALUE result; VALUE vresult = Qnil;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    result = (VALUE)FXWindow_deleteTypeName(); vresult = result; return vresult; }
static VALUE _wrap_FXWindow_textTypeName(int argc, VALUE *argv, VALUE self) { VALUE result; VALUE vresult = Qnil;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    result = (VALUE)FXWindow_textTypeName(); vresult = result; return vresult; }
static VALUE _wrap_FXWindow_colorTypeName(int argc, VALUE *argv, VALUE self) { VALUE result; VALUE vresult = Qnil;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    result = (VALUE)FXWindow_colorTypeName(); vresult = result; return vresult; }
static VALUE _wrap_FXWindow_urilistTypeName(int argc, VALUE *argv, VALUE self) { VALUE result; VALUE vresult = Qnil;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    result = (VALUE)FXWindow_urilistTypeName(); vresult = result; return vresult; }
static VALUE _wrap_new_FXWindow__SWIG_0(int argc, VALUE *argv, VALUE self) { FXComposite *arg1 = (FXComposite *) 0 ;
    FXuint arg2 = (FXuint) 0 ; FXint arg3 = (FXint) 0 ; FXint arg4 = (FXint) 0 ; FXint arg5 = (FXint) 0 ;
    FXint arg6 = (FXint) 0 ; FXWindow *result; if ((argc < 1) || (argc > 6))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXComposite, 1); if (argc > 1) { arg2 = NUM2UINT(argv[1]); } 
    if (argc > 2) { arg3 = NUM2INT(argv[2]); }  if (argc > 3) { arg4 = NUM2INT(argv[3]); }  if (argc > 4) {
        arg5 = NUM2INT(argv[4]); }  if (argc > 5) { arg6 = NUM2INT(argv[5]); }  {
        result = (FXWindow *)new_FXWindow__SWIG_0(arg1,arg2,arg3,arg4,arg5,arg6);
        DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result); if(rb_block_given_p()){ rb_yield(self); }  }  return self; }
static VALUE _wrap_new_FXWindow__SWIG_1(int argc, VALUE *argv, VALUE self) { FXApp *arg1 = (FXApp *) 0 ;
    FXVisual *arg2 = (FXVisual *) 0 ; FXWindow *result; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXApp, 1);
    SWIG_ConvertPtr(argv[1], (void **) &arg2, SWIGTYPE_p_FXVisual, 1); { result = (FXWindow *)new_FXWindow__SWIG_1(arg1,arg2);
        DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result); if(rb_block_given_p()){ rb_yield(self); }  }  return self; }
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE _wrap_FXWindow_allocate(VALUE self) {
#else
     static VALUE _wrap_FXWindow_allocate(int argc, VALUE *argv, VALUE self) {
#endif
         VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_FXWindow);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
         return vresult; }
static VALUE _wrap_new_FXWindow__SWIG_2(int argc, VALUE *argv, VALUE self) { FXApp *arg1 = (FXApp *) 0 ;
    FXWindow *arg2 = (FXWindow *) 0 ; FXuint arg3 ; FXint arg4 ; FXint arg5 ; FXint arg6 ; FXint arg7 ; FXWindow *result;
    if ((argc < 7) || (argc > 7)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 7)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXApp, 1);
    SWIG_ConvertPtr(argv[1], (void **) &arg2, SWIGTYPE_p_FXWindow, 1); arg3 = NUM2UINT(argv[2]); arg4 = NUM2INT(argv[3]);
    arg5 = NUM2INT(argv[4]); arg6 = NUM2INT(argv[5]); arg7 = NUM2INT(argv[6]); {
        result = (FXWindow *)new_FXWindow__SWIG_2(arg1,arg2,arg3,arg4,arg5,arg6,arg7);
        DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result); if(rb_block_given_p()){ rb_yield(self); }  }  return self; }
static VALUE _wrap_new_FXWindow(int nargs, VALUE *args, VALUE self) { int argc; VALUE argv[7]; int ii; argc = nargs;
    for (ii = 0; (ii < argc) && (ii < 7); ii++) { argv[ii] = args[ii]; }  if ((argc >= 1) && (argc <= 6)) { int _v; { void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXComposite, 0) != -1)) ? 1 : 0; }
         if (_v) { if (argc <= 1) { return _wrap_new_FXWindow__SWIG_0(nargs, args, self);}  {
                _v = ((TYPE(argv[1]) == T_FIXNUM) || (TYPE(argv[1]) == T_BIGNUM)) ? 1 : 0; }  if (_v) { if (argc <= 2) {
                    return _wrap_new_FXWindow__SWIG_0(nargs, args, self);}  {
                    _v = ((TYPE(argv[2]) == T_FIXNUM) || (TYPE(argv[2]) == T_BIGNUM)) ? 1 : 0; }  if (_v) { if (argc <= 3) {
                        return _wrap_new_FXWindow__SWIG_0(nargs, args, self);}  {
                        _v = ((TYPE(argv[3]) == T_FIXNUM) || (TYPE(argv[3]) == T_BIGNUM)) ? 1 : 0; }  if (_v) { if (argc <= 4) {
                            return _wrap_new_FXWindow__SWIG_0(nargs, args, self);}  {
                            _v = ((TYPE(argv[4]) == T_FIXNUM) || (TYPE(argv[4]) == T_BIGNUM)) ? 1 : 0; }  if (_v) {
                            if (argc <= 5) { return _wrap_new_FXWindow__SWIG_0(nargs, args, self);}  {
                                _v = ((TYPE(argv[5]) == T_FIXNUM) || (TYPE(argv[5]) == T_BIGNUM)) ? 1 : 0; }  if (_v) {
                                return _wrap_new_FXWindow__SWIG_0(nargs, args, self);}  }  }  }  }  }  }  if (argc == 2) {
        int _v; { void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXApp, 0) != -1)) ? 1 : 0; }
         if (_v) { { void *ptr;
                _v = (NIL_P(argv[1]) || (TYPE(argv[1]) == T_DATA && SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_FXVisual, 0) != -1)) ? 1 : 0; }
             if (_v) { return _wrap_new_FXWindow__SWIG_1(nargs, args, self);}  }  }  if (argc == 7) { int _v; { void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXApp, 0) != -1)) ? 1 : 0; }
         if (_v) { { void *ptr;
                _v = (NIL_P(argv[1]) || (TYPE(argv[1]) == T_DATA && SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_FXWindow, 0) != -1)) ? 1 : 0; }
             if (_v) { { _v = ((TYPE(argv[2]) == T_FIXNUM) || (TYPE(argv[2]) == T_BIGNUM)) ? 1 : 0; }  if (_v) { {
                        _v = ((TYPE(argv[3]) == T_FIXNUM) || (TYPE(argv[3]) == T_BIGNUM)) ? 1 : 0; }  if (_v) { {
                            _v = ((TYPE(argv[4]) == T_FIXNUM) || (TYPE(argv[4]) == T_BIGNUM)) ? 1 : 0; }  if (_v) { {
                                _v = ((TYPE(argv[5]) == T_FIXNUM) || (TYPE(argv[5]) == T_BIGNUM)) ? 1 : 0; }  if (_v) { {
                                    _v = ((TYPE(argv[6]) == T_FIXNUM) || (TYPE(argv[6]) == T_BIGNUM)) ? 1 : 0; }  if (_v) {
                                    return _wrap_new_FXWindow__SWIG_2(nargs, args, self);}  }  }  }  }  }  }  } 
    rb_raise(rb_eArgError, "No matching function for overloaded 'new_FXWindow'"); return Qnil; }
static VALUE _wrap_FXWindow_getParent(int argc, VALUE *argv, VALUE self) { FXWindow *arg1 = (FXWindow *) 0 ; FXWindow *result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXWindow, 1); result = (FXWindow *)((FXWindow const *)arg1)->getParent();
    { swig_type_info *ty = SWIG_TypeDynamicCast(SWIGTYPE_p_FXWindow, (void **) &result); vresult = FXRbGetRubyObj(result, ty); }
     return vresult; }
static VALUE _wrap_FXWindow_getOwner(int argc, VALUE *argv, VALUE self) { FXWindow *arg1 = (FXWindow *) 0 ; FXWindow *result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXWindow, 1); result = (FXWindow *)((FXWindow const *)arg1)->getOwner(); {
        swig_type_info *ty = SWIG_TypeDynamicCast(SWIGTYPE_p_FXWindow, (void **) &result);
        vresult = FXRbGetRubyObj(result, ty); }  return vresult; }
static VALUE _wrap_FXWindow_getShell(int argc, VALUE *argv, VALUE self) { FXWindow *arg1 = (FXWindow *) 0 ; FXWindow *result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXWindow, 1); result = (FXWindow *)((FXWindow const *)arg1)->getShell(); {
        swig_type_info *ty = SWIG_TypeDynamicCast(SWIGTYPE_p_FXWindow, (void **) &result);
        vresult = FXRbGetRubyObj(result, ty); }  return vresult; }
static VALUE _wrap_FXWindow_getRoot(int argc, VALUE *argv, VALUE self) { FXWindow *arg1 = (FXWindow *) 0 ; FXWindow *result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXWindow, 1); result = (FXWindow *)((FXWindow const *)arg1)->getRoot(); {
        swig_type_info *ty = SWIG_TypeDynamicCast(SWIGTYPE_p_FXWindow, (void **) &result);
        vresult = FXRbGetRubyObj(result, ty); }  return vresult; }
static VALUE _wrap_FXWindow_getNext(int argc, VALUE *argv, VALUE self) { FXWindow *arg1 = (FXWindow *) 0 ; FXWindow *result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXWindow, 1); result = (FXWindow *)((FXWindow const *)arg1)->getNext(); {
        swig_type_info *ty = SWIG_TypeDynamicCast(SWIGTYPE_p_FXWindow, (void **) &result);
        vresult = FXRbGetRubyObj(result, ty); }  return vresult; }
static VALUE _wrap_FXWindow_getPrev(int argc, VALUE *argv, VALUE self) { FXWindow *arg1 = (FXWindow *) 0 ; FXWindow *result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXWindow, 1); result = (FXWindow *)((FXWindow const *)arg1)->getPrev(); {
        swig_type_info *ty = SWIG_TypeDynamicCast(SWIGTYPE_p_FXWindow, (void **) &result);
        vresult = FXRbGetRubyObj(result, ty); }  return vresult; }
static VALUE _wrap_FXWindow_getFirst(int argc, VALUE *argv, VALUE self) { FXWindow *arg1 = (FXWindow *) 0 ; FXWindow *result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXWindow, 1); result = (FXWindow *)((FXWindow const *)arg1)->getFirst(); {
        swig_type_info *ty = SWIG_TypeDynamicCast(SWIGTYPE_p_FXWindow, (void **) &result);
        vresult = FXRbGetRubyObj(result, ty); }  return vresult; }
static VALUE _wrap_FXWindow_getLast(int argc, VALUE *argv, VALUE self) { FXWindow *arg1 = (FXWindow *) 0 ; FXWindow *result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXWindow, 1); result = (FXWindow *)((FXWindow const *)arg1)->getLast(); {
        swig_type_info *ty = SWIG_TypeDynamicCast(SWIGTYPE_p_FXWindow, (void **) &result);
        vresult = FXRbGetRubyObj(result, ty); }  return vresult; }
static VALUE _wrap_FXWindow_getFocus(int argc, VALUE *argv, VALUE self) { FXWindow *arg1 = (FXWindow *) 0 ; FXWindow *result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXWindow, 1); result = (FXWindow *)((FXWindow const *)arg1)->getFocus(); {
        swig_type_info *ty = SWIG_TypeDynamicCast(SWIGTYPE_p_FXWindow, (void **) &result);
        vresult = FXRbGetRubyObj(result, ty); }  return vresult; }
static VALUE _wrap_FXWindow_setKey(int argc, VALUE *argv, VALUE self) { FXWindow *arg1 = (FXWindow *) 0 ; FXuint arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXWindow, 1); arg2 = NUM2UINT(argv[0]); (arg1)->setKey(arg2);
    return Qnil; }
static VALUE _wrap_FXWindow_getKey(int argc, VALUE *argv, VALUE self) { FXWindow *arg1 = (FXWindow *) 0 ; FXuint result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXWindow, 1); result = (FXuint)((FXWindow const *)arg1)->getKey();
    vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXWindow_setTarget(int argc, VALUE *argv, VALUE self) { FXWindow *arg1 = (FXWindow *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXWindow, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); (arg1)->setTarget(arg2); return Qnil; }
static VALUE _wrap_FXWindow_getTarget(int argc, VALUE *argv, VALUE self) { FXWindow *arg1 = (FXWindow *) 0 ; FXObject *result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXWindow, 1); result = (FXObject *)((FXWindow const *)arg1)->getTarget();
    { swig_type_info *ty = SWIG_TypeDynamicCast(SWIGTYPE_p_FXObject, (void **) &result); vresult = FXRbGetRubyObj(result, ty); }
     return vresult; }
static VALUE _wrap_FXWindow_setSelector(int argc, VALUE *argv, VALUE self) { FXWindow *arg1 = (FXWindow *) 0 ; FXSelector arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXWindow, 1); arg2 = NUM2UINT(argv[0]); (arg1)->setSelector(arg2);
    return Qnil; }
static VALUE _wrap_FXWindow_getSelector(int argc, VALUE *argv, VALUE self) { FXWindow *arg1 = (FXWindow *) 0 ;
    FXSelector result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXWindow, 1);
    result = (FXSelector)((FXWindow const *)arg1)->getSelector(); vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXWindow_getX(int argc, VALUE *argv, VALUE self) { FXWindow *arg1 = (FXWindow *) 0 ; FXint result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXWindow, 1); result = (FXint)((FXWindow const *)arg1)->getX();
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXWindow_getY(int argc, VALUE *argv, VALUE self) { FXWindow *arg1 = (FXWindow *) 0 ; FXint result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXWindow, 1); result = (FXint)((FXWindow const *)arg1)->getY();
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXWindow_setX(int argc, VALUE *argv, VALUE self) { FXWindow *arg1 = (FXWindow *) 0 ; FXint arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXWindow, 1); arg2 = NUM2INT(argv[0]); (arg1)->setX(arg2); return Qnil; }
static VALUE _wrap_FXWindow_setY(int argc, VALUE *argv, VALUE self) { FXWindow *arg1 = (FXWindow *) 0 ; FXint arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXWindow, 1); arg2 = NUM2INT(argv[0]); (arg1)->setY(arg2); return Qnil; }
static VALUE _wrap_FXWindow_setWidth(int argc, VALUE *argv, VALUE self) { FXWindow *arg1 = (FXWindow *) 0 ; FXint arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXWindow, 1); arg2 = NUM2INT(argv[0]); (arg1)->setWidth(arg2);
    return Qnil; }
static VALUE _wrap_FXWindow_setHeight(int argc, VALUE *argv, VALUE self) { FXWindow *arg1 = (FXWindow *) 0 ; FXint arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXWindow, 1); arg2 = NUM2INT(argv[0]); (arg1)->setHeight(arg2);
    return Qnil; }
static VALUE _wrap_FXWindow_setLayoutHints(int argc, VALUE *argv, VALUE self) { FXWindow *arg1 = (FXWindow *) 0 ; FXuint arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXWindow, 1); arg2 = NUM2UINT(argv[0]); (arg1)->setLayoutHints(arg2);
    return Qnil; }
static VALUE _wrap_FXWindow_getLayoutHints(int argc, VALUE *argv, VALUE self) { FXWindow *arg1 = (FXWindow *) 0 ; FXuint result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXWindow, 1); result = (FXuint)((FXWindow const *)arg1)->getLayoutHints();
    vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXWindow_getAccelTable(int argc, VALUE *argv, VALUE self) { FXWindow *arg1 = (FXWindow *) 0 ;
    FXAccelTable *result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXWindow, 1);
    result = (FXAccelTable *)((FXWindow const *)arg1)->getAccelTable(); {
        swig_type_info *ty = SWIG_TypeDynamicCast(SWIGTYPE_p_FXAccelTable, (void **) &result);
        vresult = FXRbGetRubyObj(result, ty); }  return vresult; }
static VALUE _wrap_FXWindow_setAccelTable(int argc, VALUE *argv, VALUE self) { FXWindow *arg1 = (FXWindow *) 0 ;
    FXAccelTable *arg2 = (FXAccelTable *) 0 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXWindow, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXAccelTable, 1); (arg1)->setAccelTable(arg2); return Qnil; }
static VALUE _wrap_FXWindow_addHotKey(int argc, VALUE *argv, VALUE self) { FXWindow *arg1 = (FXWindow *) 0 ; FXHotKey arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXWindow, 1); arg2 = NUM2UINT(argv[0]); (arg1)->addHotKey(arg2);
    return Qnil; }
static VALUE _wrap_FXWindow_remHotKey(int argc, VALUE *argv, VALUE self) { FXWindow *arg1 = (FXWindow *) 0 ; FXHotKey arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXWindow, 1); arg2 = NUM2UINT(argv[0]); (arg1)->remHotKey(arg2);
    return Qnil; }
static VALUE _wrap_FXWindow_setHelpTag(int argc, VALUE *argv, VALUE self) { FXWindow *arg1 = (FXWindow *) 0 ;
    FXString *arg2 = 0 ; SwigValueWrapper<FXString > p2 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXWindow, 1); p2 = to_FXString(argv[0]); arg2 = &p2;
    (arg1)->setHelpTag((FXString const &)*arg2); return Qnil; }
static VALUE _wrap_FXWindow_getHelpTag(int argc, VALUE *argv, VALUE self) { FXWindow *arg1 = (FXWindow *) 0 ; FXString result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXWindow, 1); result = ((FXWindow const *)arg1)->getHelpTag();
    vresult = rb_str_new2((&result)->text()); return vresult; }
static VALUE _wrap_FXWindow_isShell(int argc, VALUE *argv, VALUE self) { FXWindow *arg1 = (FXWindow *) 0 ; FXbool result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXWindow, 1); result = (FXbool)((FXWindow const *)arg1)->isShell();
    vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXWindow_isOwnerOf(int argc, VALUE *argv, VALUE self) { FXWindow *arg1 = (FXWindow *) 0 ;
    FXWindow *arg2 = (FXWindow *) 0 ; FXbool result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXWindow, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXWindow, 1);
    result = (FXbool)((FXWindow const *)arg1)->isOwnerOf((FXWindow const *)arg2); vresult = result ? Qtrue : Qfalse;
    return vresult; }
static VALUE _wrap_FXWindow_isChildOf(int argc, VALUE *argv, VALUE self) { FXWindow *arg1 = (FXWindow *) 0 ;
    FXWindow *arg2 = (FXWindow *) 0 ; FXbool result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXWindow, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXWindow, 1);
    result = (FXbool)((FXWindow const *)arg1)->isChildOf((FXWindow const *)arg2); vresult = result ? Qtrue : Qfalse;
    return vresult; }
static VALUE _wrap_FXWindow_containsChild(int argc, VALUE *argv, VALUE self) { FXWindow *arg1 = (FXWindow *) 0 ;
    FXWindow *arg2 = (FXWindow *) 0 ; FXbool result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXWindow, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXWindow, 1);
    result = (FXbool)((FXWindow const *)arg1)->containsChild((FXWindow const *)arg2); vresult = result ? Qtrue : Qfalse;
    return vresult; }
static VALUE _wrap_FXWindow_getChildAt(int argc, VALUE *argv, VALUE self) { FXWindow *arg1 = (FXWindow *) 0 ; FXint arg2 ;
    FXint arg3 ; FXWindow *result; VALUE vresult = Qnil; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXWindow, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    result = (FXWindow *)((FXWindow const *)arg1)->getChildAt(arg2,arg3); {
        swig_type_info *ty = SWIG_TypeDynamicCast(SWIGTYPE_p_FXWindow, (void **) &result);
        vresult = FXRbGetRubyObj(result, ty); }  return vresult; }
static VALUE _wrap_FXWindow_numChildren(int argc, VALUE *argv, VALUE self) { FXWindow *arg1 = (FXWindow *) 0 ; FXint result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXWindow, 1); result = (FXint)((FXWindow const *)arg1)->numChildren();
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXWindow_indexOfChild(int argc, VALUE *argv, VALUE self) { FXWindow *arg1 = (FXWindow *) 0 ;
    FXWindow *arg2 = (FXWindow *) 0 ; FXint result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXWindow, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXWindow, 1);
    result = (FXint)((FXWindow const *)arg1)->indexOfChild((FXWindow const *)arg2); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXWindow_removeChild(int argc, VALUE *argv, VALUE self) { FXWindow *arg1 = (FXWindow *) 0 ;
    FXWindow *arg2 = (FXWindow *) 0 ; FXbool result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXWindow, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXWindow, 1); result = (FXbool)FXWindow_removeChild(arg1,arg2);
    vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXWindow_getChildren(int argc, VALUE *argv, VALUE self) { FXWindow *arg1 = (FXWindow *) 0 ; VALUE result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXWindow, 1);
    result = (VALUE)FXWindow_getChildren((FXWindow const *)arg1); vresult = result; return vresult; }
static VALUE _wrap_FXWindow_childAtIndex(int argc, VALUE *argv, VALUE self) { FXWindow *arg1 = (FXWindow *) 0 ; FXint arg2 ;
    FXWindow *result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXWindow, 1); arg2 = NUM2INT(argv[0]); {
        if (arg2 < 0 || arg2 >= arg1->numChildren()) { rb_raise(rb_eIndexError, "child window index out of bounds"); }  } 
    result = (FXWindow *)((FXWindow const *)arg1)->childAtIndex(arg2); {
        swig_type_info *ty = SWIG_TypeDynamicCast(SWIGTYPE_p_FXWindow, (void **) &result);
        vresult = FXRbGetRubyObj(result, ty); }  return vresult; }
static VALUE _wrap_FXWindow_commonAncestor(int argc, VALUE *argv, VALUE self) { FXWindow *arg1 = (FXWindow *) 0 ;
    FXWindow *arg2 = (FXWindow *) 0 ; FXWindow *result; VALUE vresult = Qnil; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXWindow, 1);
    SWIG_ConvertPtr(argv[1], (void **) &arg2, SWIGTYPE_p_FXWindow, 1); result = (FXWindow *)FXWindow::commonAncestor(arg1,arg2);
    { swig_type_info *ty = SWIG_TypeDynamicCast(SWIGTYPE_p_FXWindow, (void **) &result); vresult = FXRbGetRubyObj(result, ty); }
     return vresult; }
static VALUE _wrap_FXWindow_windowCount(int argc, VALUE *argv, VALUE self) { FXint result; VALUE vresult = Qnil;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    result = (FXint)FXWindow::getWindowCount(); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXWindow_setDefaultCursor(int argc, VALUE *argv, VALUE self) { FXWindow *arg1 = (FXWindow *) 0 ;
    FXCursor *arg2 = (FXCursor *) 0 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXWindow, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXCursor, 1); (arg1)->setDefaultCursor(arg2); return Qnil; }
static VALUE _wrap_FXWindow_getDefaultCursor(int argc, VALUE *argv, VALUE self) { FXWindow *arg1 = (FXWindow *) 0 ;
    FXCursor *result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXWindow, 1);
    result = (FXCursor *)((FXWindow const *)arg1)->getDefaultCursor(); {
        swig_type_info *ty = SWIG_TypeDynamicCast(SWIGTYPE_p_FXCursor, (void **) &result);
        vresult = FXRbGetRubyObj(result, ty); }  return vresult; }
static VALUE _wrap_FXWindow_setDragCursor(int argc, VALUE *argv, VALUE self) { FXWindow *arg1 = (FXWindow *) 0 ;
    FXCursor *arg2 = (FXCursor *) 0 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXWindow, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXCursor, 1); (arg1)->setDragCursor(arg2); return Qnil; }
static VALUE _wrap_FXWindow_getDragCursor(int argc, VALUE *argv, VALUE self) { FXWindow *arg1 = (FXWindow *) 0 ;
    FXCursor *result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXWindow, 1);
    result = (FXCursor *)((FXWindow const *)arg1)->getDragCursor(); {
        swig_type_info *ty = SWIG_TypeDynamicCast(SWIGTYPE_p_FXCursor, (void **) &result);
        vresult = FXRbGetRubyObj(result, ty); }  return vresult; }
static VALUE _wrap_FXWindow_getCursorPosition(int argc, VALUE *argv, VALUE self) { FXWindow *arg1 = (FXWindow *) 0 ;
    VALUE result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXWindow, 1);
    result = (VALUE)FXWindow_getCursorPosition((FXWindow const *)arg1); vresult = result; return vresult; }
static VALUE _wrap_FXWindow_setCursorPosition(int argc, VALUE *argv, VALUE self) { FXWindow *arg1 = (FXWindow *) 0 ;
    FXint arg2 ; FXint arg3 ; FXint result; VALUE vresult = Qnil; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXWindow, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    result = (FXint)(arg1)->setCursorPosition(arg2,arg3); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXWindow_isEnabled(int argc, VALUE *argv, VALUE self) { FXWindow *arg1 = (FXWindow *) 0 ; FXbool result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXWindow, 1); result = (FXbool)((FXWindow const *)arg1)->isEnabled();
    vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXWindow_isActive(int argc, VALUE *argv, VALUE self) { FXWindow *arg1 = (FXWindow *) 0 ; FXbool result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXWindow, 1); result = (FXbool)((FXWindow const *)arg1)->isActive();
    vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXWindow_hasFocus(int argc, VALUE *argv, VALUE self) { FXWindow *arg1 = (FXWindow *) 0 ; FXbool result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXWindow, 1); result = (FXbool)((FXWindow const *)arg1)->hasFocus();
    vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXWindow_isDefault(int argc, VALUE *argv, VALUE self) { FXWindow *arg1 = (FXWindow *) 0 ; FXbool result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXWindow, 1); result = (FXbool)((FXWindow const *)arg1)->isDefault();
    vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXWindow_setInitial(int argc, VALUE *argv, VALUE self) { FXWindow *arg1 = (FXWindow *) 0 ;
    FXbool arg2 = (FXbool) 1 ; if ((argc < 0) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXWindow, 1); if (argc > 0) { arg2 = to_FXbool(argv[0]); } 
    (arg1)->setInitial(arg2); return Qnil; }
static VALUE _wrap_FXWindow_isInitial(int argc, VALUE *argv, VALUE self) { FXWindow *arg1 = (FXWindow *) 0 ; FXbool result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXWindow, 1); result = (FXbool)((FXWindow const *)arg1)->isInitial();
    vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXWindow_forceRefresh(int argc, VALUE *argv, VALUE self) { FXWindow *arg1 = (FXWindow *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXWindow, 1); (arg1)->forceRefresh(); return Qnil; }
static VALUE _wrap_FXWindow_scroll(int argc, VALUE *argv, VALUE self) { FXWindow *arg1 = (FXWindow *) 0 ; FXint arg2 ;
    FXint arg3 ; FXint arg4 ; FXint arg5 ; FXint arg6 ; FXint arg7 ; if ((argc < 6) || (argc > 6))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 6)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXWindow, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    arg4 = NUM2INT(argv[2]); arg5 = NUM2INT(argv[3]); arg6 = NUM2INT(argv[4]); arg7 = NUM2INT(argv[5]);
    ((FXWindow const *)arg1)->scroll(arg2,arg3,arg4,arg5,arg6,arg7); return Qnil; }
static VALUE _wrap_FXWindow_update__SWIG_0(int argc, VALUE *argv, VALUE self) { FXWindow *arg1 = (FXWindow *) 0 ; FXint arg2 ;
    FXint arg3 ; FXint arg4 ; FXint arg5 ; if ((argc < 4) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXWindow, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    arg4 = NUM2INT(argv[2]); arg5 = NUM2INT(argv[3]); ((FXWindow const *)arg1)->update(arg2,arg3,arg4,arg5); return Qnil; }
static VALUE _wrap_FXWindow_update__SWIG_1(int argc, VALUE *argv, VALUE self) { FXWindow *arg1 = (FXWindow *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXWindow, 1); ((FXWindow const *)arg1)->update(); return Qnil; }
static VALUE _wrap_FXWindow_update(int nargs, VALUE *args, VALUE self) { int argc; VALUE argv[6]; int ii; argc = nargs + 1;
    argv[0] = self; for (ii = 1; (ii < argc) && (ii < 5); ii++) { argv[ii] = args[ii-1]; }  if (argc == 1) { int _v; {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXWindow, 0) != -1)) ? 1 : 0; }
         if (_v) { return _wrap_FXWindow_update__SWIG_1(nargs, args, self);}  }  if (argc == 5) { int _v; { void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXWindow, 0) != -1)) ? 1 : 0; }
         if (_v) { { _v = ((TYPE(argv[1]) == T_FIXNUM) || (TYPE(argv[1]) == T_BIGNUM)) ? 1 : 0; }  if (_v) { {
                    _v = ((TYPE(argv[2]) == T_FIXNUM) || (TYPE(argv[2]) == T_BIGNUM)) ? 1 : 0; }  if (_v) { {
                        _v = ((TYPE(argv[3]) == T_FIXNUM) || (TYPE(argv[3]) == T_BIGNUM)) ? 1 : 0; }  if (_v) { {
                            _v = ((TYPE(argv[4]) == T_FIXNUM) || (TYPE(argv[4]) == T_BIGNUM)) ? 1 : 0; }  if (_v) {
                            return _wrap_FXWindow_update__SWIG_0(nargs, args, self);}  }  }  }  }  } 
    rb_raise(rb_eArgError, "No matching function for overloaded 'FXWindow_update'"); return Qnil; }
static VALUE _wrap_FXWindow_repaint__SWIG_0(int argc, VALUE *argv, VALUE self) { FXWindow *arg1 = (FXWindow *) 0 ; FXint arg2 ;
    FXint arg3 ; FXint arg4 ; FXint arg5 ; if ((argc < 4) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXWindow, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    arg4 = NUM2INT(argv[2]); arg5 = NUM2INT(argv[3]); ((FXWindow const *)arg1)->repaint(arg2,arg3,arg4,arg5); return Qnil; }
static VALUE _wrap_FXWindow_repaint__SWIG_1(int argc, VALUE *argv, VALUE self) { FXWindow *arg1 = (FXWindow *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXWindow, 1); ((FXWindow const *)arg1)->repaint(); return Qnil; }
static VALUE _wrap_FXWindow_repaint(int nargs, VALUE *args, VALUE self) { int argc; VALUE argv[6]; int ii; argc = nargs + 1;
    argv[0] = self; for (ii = 1; (ii < argc) && (ii < 5); ii++) { argv[ii] = args[ii-1]; }  if (argc == 1) { int _v; {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXWindow, 0) != -1)) ? 1 : 0; }
         if (_v) { return _wrap_FXWindow_repaint__SWIG_1(nargs, args, self);}  }  if (argc == 5) { int _v; { void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXWindow, 0) != -1)) ? 1 : 0; }
         if (_v) { { _v = ((TYPE(argv[1]) == T_FIXNUM) || (TYPE(argv[1]) == T_BIGNUM)) ? 1 : 0; }  if (_v) { {
                    _v = ((TYPE(argv[2]) == T_FIXNUM) || (TYPE(argv[2]) == T_BIGNUM)) ? 1 : 0; }  if (_v) { {
                        _v = ((TYPE(argv[3]) == T_FIXNUM) || (TYPE(argv[3]) == T_BIGNUM)) ? 1 : 0; }  if (_v) { {
                            _v = ((TYPE(argv[4]) == T_FIXNUM) || (TYPE(argv[4]) == T_BIGNUM)) ? 1 : 0; }  if (_v) {
                            return _wrap_FXWindow_repaint__SWIG_0(nargs, args, self);}  }  }  }  }  } 
    rb_raise(rb_eArgError, "No matching function for overloaded 'FXWindow_repaint'"); return Qnil; }
static VALUE _wrap_FXWindow_grab(int argc, VALUE *argv, VALUE self) { FXWindow *arg1 = (FXWindow *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXWindow, 1); (arg1)->grab(); return Qnil; }
static VALUE _wrap_FXWindow_ungrab(int argc, VALUE *argv, VALUE self) { FXWindow *arg1 = (FXWindow *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXWindow, 1); (arg1)->ungrab(); return Qnil; }
static VALUE _wrap_FXWindow_grabbed(int argc, VALUE *argv, VALUE self) { FXWindow *arg1 = (FXWindow *) 0 ; FXbool result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXWindow, 1); result = (FXbool)((FXWindow const *)arg1)->grabbed();
    vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXWindow_grabKeyboard(int argc, VALUE *argv, VALUE self) { FXWindow *arg1 = (FXWindow *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXWindow, 1); (arg1)->grabKeyboard(); return Qnil; }
static VALUE _wrap_FXWindow_ungrabKeyboard(int argc, VALUE *argv, VALUE self) { FXWindow *arg1 = (FXWindow *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXWindow, 1); (arg1)->ungrabKeyboard(); return Qnil; }
static VALUE _wrap_FXWindow_grabbedKeyboard(int argc, VALUE *argv, VALUE self) { FXWindow *arg1 = (FXWindow *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXWindow, 1);
    result = (FXbool)((FXWindow const *)arg1)->grabbedKeyboard(); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXWindow_shown(int argc, VALUE *argv, VALUE self) { FXWindow *arg1 = (FXWindow *) 0 ; FXbool result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXWindow, 1); result = (FXbool)((FXWindow const *)arg1)->shown();
    vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXWindow_underCursor(int argc, VALUE *argv, VALUE self) { FXWindow *arg1 = (FXWindow *) 0 ; FXbool result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXWindow, 1); result = (FXbool)((FXWindow const *)arg1)->underCursor();
    vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXWindow_hasSelection(int argc, VALUE *argv, VALUE self) { FXWindow *arg1 = (FXWindow *) 0 ; FXbool result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXWindow, 1); result = (FXbool)((FXWindow const *)arg1)->hasSelection();
    vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXWindow_acquireSelection(int argc, VALUE *argv, VALUE self) { FXWindow *arg1 = (FXWindow *) 0 ; VALUE arg2 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXWindow, 1); arg2 = argv[0];
    result = (FXbool)FXWindow_acquireSelection(arg1,arg2); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXWindow_releaseSelection(int argc, VALUE *argv, VALUE self) { FXWindow *arg1 = (FXWindow *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXWindow, 1); result = (FXbool)(arg1)->releaseSelection();
    vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXWindow_hasClipboard(int argc, VALUE *argv, VALUE self) { FXWindow *arg1 = (FXWindow *) 0 ; FXbool result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXWindow, 1); result = (FXbool)((FXWindow const *)arg1)->hasClipboard();
    vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXWindow_acquireClipboard(int argc, VALUE *argv, VALUE self) { FXWindow *arg1 = (FXWindow *) 0 ; VALUE arg2 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXWindow, 1); arg2 = argv[0];
    result = (FXbool)FXWindow_acquireClipboard(arg1,arg2); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXWindow_releaseClipboard(int argc, VALUE *argv, VALUE self) { FXWindow *arg1 = (FXWindow *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXWindow, 1); result = (FXbool)(arg1)->releaseClipboard();
    vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXWindow_dropEnable(int argc, VALUE *argv, VALUE self) { FXWindow *arg1 = (FXWindow *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXWindow, 1); (arg1)->dropEnable(); return Qnil; }
static VALUE _wrap_FXWindow_dropDisable(int argc, VALUE *argv, VALUE self) { FXWindow *arg1 = (FXWindow *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXWindow, 1); (arg1)->dropDisable(); return Qnil; }
static VALUE _wrap_FXWindow_isDropEnabled(int argc, VALUE *argv, VALUE self) { FXWindow *arg1 = (FXWindow *) 0 ; FXbool result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXWindow, 1); result = (FXbool)((FXWindow const *)arg1)->isDropEnabled();
    vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXWindow_isDragging(int argc, VALUE *argv, VALUE self) { FXWindow *arg1 = (FXWindow *) 0 ; FXbool result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXWindow, 1); result = (FXbool)((FXWindow const *)arg1)->isDragging();
    vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXWindow_beginDrag(int argc, VALUE *argv, VALUE self) { FXWindow *arg1 = (FXWindow *) 0 ; VALUE arg2 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXWindow, 1); arg2 = argv[0];
    result = (FXbool)FXWindow_beginDrag(arg1,arg2); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXWindow_handleDrag(int argc, VALUE *argv, VALUE self) { FXWindow *arg1 = (FXWindow *) 0 ; FXint arg2 ;
    FXint arg3 ; int arg4 = (int) DRAG_COPY ; FXbool result; VALUE vresult = Qnil; if ((argc < 2) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXWindow, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    if (argc > 2) { arg4 = (int) NUM2INT(argv[2]); }  result = (FXbool)(arg1)->handleDrag(arg2,arg3,(FXDragAction )arg4);
    vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXWindow_endDrag(int argc, VALUE *argv, VALUE self) { FXWindow *arg1 = (FXWindow *) 0 ;
    FXbool arg2 = (FXbool) 1 ; FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXWindow, 1); if (argc > 0) { arg2 = to_FXbool(argv[0]); } 
    result = (FXbool)(arg1)->endDrag(arg2); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXWindow_isDropTarget(int argc, VALUE *argv, VALUE self) { FXWindow *arg1 = (FXWindow *) 0 ; FXbool result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXWindow, 1); result = (FXbool)((FXWindow const *)arg1)->isDropTarget();
    vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXWindow_setDragRectangle(int argc, VALUE *argv, VALUE self) { FXWindow *arg1 = (FXWindow *) 0 ; FXint arg2 ;
    FXint arg3 ; FXint arg4 ; FXint arg5 ; FXbool arg6 = (FXbool) 1 ; if ((argc < 4) || (argc > 5))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXWindow, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    arg4 = NUM2INT(argv[2]); arg5 = NUM2INT(argv[3]); if (argc > 4) { arg6 = to_FXbool(argv[4]); } 
    ((FXWindow const *)arg1)->setDragRectangle(arg2,arg3,arg4,arg5,arg6); return Qnil; }
static VALUE _wrap_FXWindow_clearDragRectangle(int argc, VALUE *argv, VALUE self) { FXWindow *arg1 = (FXWindow *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXWindow, 1); ((FXWindow const *)arg1)->clearDragRectangle();
    return Qnil; }
static VALUE _wrap_FXWindow_acceptDrop(int argc, VALUE *argv, VALUE self) { FXWindow *arg1 = (FXWindow *) 0 ;
    int arg2 = (int) DRAG_ACCEPT ; if ((argc < 0) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXWindow, 1); if (argc > 0) { arg2 = (int) NUM2INT(argv[0]); } 
    ((FXWindow const *)arg1)->acceptDrop((FXDragAction )arg2); return Qnil; }
static VALUE _wrap_FXWindow_didAccept(int argc, VALUE *argv, VALUE self) { FXWindow *arg1 = (FXWindow *) 0 ; int result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXWindow, 1); result = (int)((FXWindow const *)arg1)->didAccept();
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXWindow_inquireDNDTypes(int argc, VALUE *argv, VALUE self) { FXWindow *arg1 = (FXWindow *) 0 ; int arg2 ;
    VALUE result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXWindow, 1); arg2 = (int) NUM2INT(argv[0]);
    result = (VALUE)FXWindow_inquireDNDTypes((FXWindow const *)arg1,(FXDNDOrigin )arg2); vresult = result; return vresult; }
static VALUE _wrap_FXWindow_offeredDNDType(int argc, VALUE *argv, VALUE self) { FXWindow *arg1 = (FXWindow *) 0 ; int arg2 ;
    FXDragType arg3 ; FXbool result; VALUE vresult = Qnil; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXWindow, 1); arg2 = (int) NUM2INT(argv[0]); arg3 = NUM2UINT(argv[1]);
    result = (FXbool)((FXWindow const *)arg1)->offeredDNDType((FXDNDOrigin )arg2,arg3); vresult = result ? Qtrue : Qfalse;
    return vresult; }
static VALUE _wrap_FXWindow_inquireDNDAction(int argc, VALUE *argv, VALUE self) { FXWindow *arg1 = (FXWindow *) 0 ; int result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXWindow, 1); result = (int)((FXWindow const *)arg1)->inquireDNDAction();
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXWindow_setDNDData(int argc, VALUE *argv, VALUE self) { FXWindow *arg1 = (FXWindow *) 0 ; int arg2 ;
    FXDragType arg3 ; VALUE arg4 ; if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXWindow, 1); arg2 = (int) NUM2INT(argv[0]); arg3 = NUM2UINT(argv[1]);
    arg4 = argv[2]; FXWindow_setDNDData((FXWindow const *)arg1,(FXDNDOrigin )arg2,arg3,arg4); return Qnil; }
static VALUE _wrap_FXWindow_getDNDData(int argc, VALUE *argv, VALUE self) { FXWindow *arg1 = (FXWindow *) 0 ; int arg2 ;
    FXDragType arg3 ; VALUE result; VALUE vresult = Qnil; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXWindow, 1); arg2 = (int) NUM2INT(argv[0]); arg3 = NUM2UINT(argv[1]);
    result = (VALUE)FXWindow_getDNDData((FXWindow const *)arg1,(FXDNDOrigin )arg2,arg3); vresult = result; return vresult; }
static VALUE _wrap_FXWindow_translateCoordinatesFrom(int argc, VALUE *argv, VALUE self) { FXWindow *arg1 = (FXWindow *) 0 ;
    FXWindow *arg2 = (FXWindow *) 0 ; FXint arg3 ; FXint arg4 ; VALUE result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXWindow, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXWindow, 1); arg3 = NUM2INT(argv[1]); arg4 = NUM2INT(argv[2]);
    result = (VALUE)FXWindow_translateCoordinatesFrom((FXWindow const *)arg1,(FXWindow const *)arg2,arg3,arg4);
    vresult = result; return vresult; }
static VALUE _wrap_FXWindow_translateCoordinatesTo(int argc, VALUE *argv, VALUE self) { FXWindow *arg1 = (FXWindow *) 0 ;
    FXWindow *arg2 = (FXWindow *) 0 ; FXint arg3 ; FXint arg4 ; VALUE result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXWindow, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXWindow, 1); arg3 = NUM2INT(argv[1]); arg4 = NUM2INT(argv[2]);
    result = (VALUE)FXWindow_translateCoordinatesTo((FXWindow const *)arg1,(FXWindow const *)arg2,arg3,arg4); vresult = result;
    return vresult; }
static VALUE _wrap_FXWindow_getBackColor(int argc, VALUE *argv, VALUE self) { FXWindow *arg1 = (FXWindow *) 0 ; FXColor result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXWindow, 1); result = (FXColor)((FXWindow const *)arg1)->getBackColor();
    vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXWindow_linkBefore(int argc, VALUE *argv, VALUE self) { FXWindow *arg1 = (FXWindow *) 0 ;
    FXWindow *arg2 = (FXWindow *) 0 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXWindow, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXWindow, 1); (arg1)->linkBefore(arg2); return Qnil; }
static VALUE _wrap_FXWindow_linkAfter(int argc, VALUE *argv, VALUE self) { FXWindow *arg1 = (FXWindow *) 0 ;
    FXWindow *arg2 = (FXWindow *) 0 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXWindow, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXWindow, 1); (arg1)->linkAfter(arg2); return Qnil; }
static void
free_FXWindow(FXWindow *arg1) {
    delete arg1;
}
static VALUE _wrap_FXWindow_save(int argc, VALUE *argv, VALUE self) { FXWindow *arg1 = (FXWindow *) 0 ; FXStream *arg2 = 0 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXWindow, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXWindow_save((FXWindow const *)arg1,*arg2); return Qnil; }
static VALUE _wrap_FXWindow_load(int argc, VALUE *argv, VALUE self) { FXWindow *arg1 = (FXWindow *) 0 ; FXStream *arg2 = 0 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXWindow, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXWindow_load(arg1,*arg2); return Qnil; }
static VALUE _wrap_FXWindow_create(int argc, VALUE *argv, VALUE self) { FXWindow *arg1 = (FXWindow *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXWindow, 1); FXWindow_create(arg1); return Qnil; }
static VALUE _wrap_FXWindow_detach(int argc, VALUE *argv, VALUE self) { FXWindow *arg1 = (FXWindow *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXWindow, 1); FXWindow_detach(arg1); return Qnil; }
static VALUE _wrap_FXWindow_destroy(int argc, VALUE *argv, VALUE self) { FXWindow *arg1 = (FXWindow *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXWindow, 1); FXWindow_destroy(arg1); return Qnil; }
static VALUE _wrap_FXWindow_resize(int argc, VALUE *argv, VALUE self) { FXWindow *arg1 = (FXWindow *) 0 ; FXint arg2 ;
    FXint arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXWindow, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    FXWindow_resize(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXWindow_getDefaultWidth(int argc, VALUE *argv, VALUE self) { FXWindow *arg1 = (FXWindow *) 0 ; FXint result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXWindow, 1); result = (FXint)FXWindow_getDefaultWidth(arg1);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXWindow_getDefaultHeight(int argc, VALUE *argv, VALUE self) { FXWindow *arg1 = (FXWindow *) 0 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXWindow, 1); result = (FXint)FXWindow_getDefaultHeight(arg1);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXWindow_getWidthForHeight(int argc, VALUE *argv, VALUE self) { FXWindow *arg1 = (FXWindow *) 0 ;
    FXint arg2 ; FXint result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXWindow, 1); arg2 = NUM2INT(argv[0]);
    result = (FXint)FXWindow_getWidthForHeight(arg1,arg2); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXWindow_getHeightForWidth(int argc, VALUE *argv, VALUE self) { FXWindow *arg1 = (FXWindow *) 0 ;
    FXint arg2 ; FXint result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXWindow, 1); arg2 = NUM2INT(argv[0]);
    result = (FXint)FXWindow_getHeightForWidth(arg1,arg2); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXWindow_canFocus(int argc, VALUE *argv, VALUE self) { FXWindow *arg1 = (FXWindow *) 0 ; FXbool result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXWindow, 1); result = (FXbool)FXWindow_canFocus((FXWindow const *)arg1);
    vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXWindow_setFocus(int argc, VALUE *argv, VALUE self) { FXWindow *arg1 = (FXWindow *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXWindow, 1); FXWindow_setFocus(arg1); return Qnil; }
static VALUE _wrap_FXWindow_killFocus(int argc, VALUE *argv, VALUE self) { FXWindow *arg1 = (FXWindow *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXWindow, 1); FXWindow_killFocus(arg1); return Qnil; }
static VALUE _wrap_FXWindow_setDefault(int argc, VALUE *argv, VALUE self) { FXWindow *arg1 = (FXWindow *) 0 ;
    FXbool arg2 = (FXbool) 1 ; if ((argc < 0) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXWindow, 1); if (argc > 0) { arg2 = to_FXbool(argv[0]); } 
    FXWindow_setDefault(arg1,arg2); return Qnil; }
static VALUE _wrap_FXWindow_enable(int argc, VALUE *argv, VALUE self) { FXWindow *arg1 = (FXWindow *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXWindow, 1); FXWindow_enable(arg1); return Qnil; }
static VALUE _wrap_FXWindow_disable(int argc, VALUE *argv, VALUE self) { FXWindow *arg1 = (FXWindow *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXWindow, 1); FXWindow_disable(arg1); return Qnil; }
static VALUE _wrap_FXWindow_raiseWindow(int argc, VALUE *argv, VALUE self) { FXWindow *arg1 = (FXWindow *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXWindow, 1); FXWindow_raise(arg1); return Qnil; }
static VALUE _wrap_FXWindow_lower(int argc, VALUE *argv, VALUE self) { FXWindow *arg1 = (FXWindow *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXWindow, 1); FXWindow_lower(arg1); return Qnil; }
static VALUE _wrap_FXWindow_move(int argc, VALUE *argv, VALUE self) { FXWindow *arg1 = (FXWindow *) 0 ; FXint arg2 ;
    FXint arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXWindow, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    FXWindow_move(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXWindow_position(int argc, VALUE *argv, VALUE self) { FXWindow *arg1 = (FXWindow *) 0 ; FXint arg2 ;
    FXint arg3 ; FXint arg4 ; FXint arg5 ; if ((argc < 4) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXWindow, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    arg4 = NUM2INT(argv[2]); arg5 = NUM2INT(argv[3]); FXWindow_position(arg1,arg2,arg3,arg4,arg5); return Qnil; }
static VALUE _wrap_FXWindow_layout(int argc, VALUE *argv, VALUE self) { FXWindow *arg1 = (FXWindow *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXWindow, 1); FXWindow_layout(arg1); return Qnil; }
static VALUE _wrap_FXWindow_recalc(int argc, VALUE *argv, VALUE self) { FXWindow *arg1 = (FXWindow *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXWindow, 1); FXWindow_recalc(arg1); return Qnil; }
static VALUE _wrap_FXWindow_reparent(int argc, VALUE *argv, VALUE self) { FXWindow *arg1 = (FXWindow *) 0 ;
    FXComposite *arg2 = (FXComposite *) 0 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXWindow, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXComposite, 1); FXWindow_reparent(arg1,arg2); return Qnil; }
static VALUE _wrap_FXWindow_show(int argc, VALUE *argv, VALUE self) { FXWindow *arg1 = (FXWindow *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXWindow, 1); FXWindow_show(arg1); return Qnil; }
static VALUE _wrap_FXWindow_hide(int argc, VALUE *argv, VALUE self) { FXWindow *arg1 = (FXWindow *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXWindow, 1); FXWindow_hide(arg1); return Qnil; }
static VALUE _wrap_FXWindow_isComposite(int argc, VALUE *argv, VALUE self) { FXWindow *arg1 = (FXWindow *) 0 ; FXbool result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXWindow, 1);
    result = (FXbool)FXWindow_isComposite((FXWindow const *)arg1); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXWindow_contains(int argc, VALUE *argv, VALUE self) { FXWindow *arg1 = (FXWindow *) 0 ; FXint arg2 ;
    FXint arg3 ; FXbool result; VALUE vresult = Qnil; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXWindow, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    result = (FXbool)FXWindow_contains((FXWindow const *)arg1,arg2,arg3); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXWindow_doesSaveUnder(int argc, VALUE *argv, VALUE self) { FXWindow *arg1 = (FXWindow *) 0 ; FXbool result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXWindow, 1);
    result = (FXbool)FXWindow_doesSaveUnder((FXWindow const *)arg1); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXWindow_setBackColor(int argc, VALUE *argv, VALUE self) { FXWindow *arg1 = (FXWindow *) 0 ; FXColor arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXWindow, 1); arg2 = to_FXColor(argv[0]);
    FXWindow_setBackColor(arg1,arg2); return Qnil; }
static VALUE _wrap_FXFrame_onPaint(int argc, VALUE *argv, VALUE self) { FXFrame *arg1 = (FXFrame *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFrame, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onPaint(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE _wrap_FXFrame_allocate(VALUE self) {
#else
     static VALUE _wrap_FXFrame_allocate(int argc, VALUE *argv, VALUE self) {
#endif
         VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_FXFrame);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
         return vresult; }
static VALUE _wrap_new_FXFrame(int argc, VALUE *argv, VALUE self) { FXComposite *arg1 = (FXComposite *) 0 ;
    FXuint arg2 = (FXuint) FRAME_NORMAL ; FXint arg3 = (FXint) 0 ; FXint arg4 = (FXint) 0 ; FXint arg5 = (FXint) 0 ;
    FXint arg6 = (FXint) 0 ; FXint arg7 = (FXint) DEFAULT_PAD ; FXint arg8 = (FXint) DEFAULT_PAD ;
    FXint arg9 = (FXint) DEFAULT_PAD ; FXint arg10 = (FXint) DEFAULT_PAD ; FXFrame *result; if ((argc < 1) || (argc > 10))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXComposite, 1); if (argc > 1) { arg2 = NUM2UINT(argv[1]); } 
    if (argc > 2) { arg3 = NUM2INT(argv[2]); }  if (argc > 3) { arg4 = NUM2INT(argv[3]); }  if (argc > 4) {
        arg5 = NUM2INT(argv[4]); }  if (argc > 5) { arg6 = NUM2INT(argv[5]); }  if (argc > 6) { arg7 = NUM2INT(argv[6]); } 
    if (argc > 7) { arg8 = NUM2INT(argv[7]); }  if (argc > 8) { arg9 = NUM2INT(argv[8]); }  if (argc > 9) {
        arg10 = NUM2INT(argv[9]); }  { result = (FXFrame *)new_FXFrame(arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8,arg9,arg10);
        DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result); if(rb_block_given_p()){ rb_yield(self); }  }  return self; }
static VALUE _wrap_FXFrame_setFrameStyle(int argc, VALUE *argv, VALUE self) { FXFrame *arg1 = (FXFrame *) 0 ; FXuint arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFrame, 1); arg2 = NUM2UINT(argv[0]); (arg1)->setFrameStyle(arg2);
    return Qnil; }
static VALUE _wrap_FXFrame_getFrameStyle(int argc, VALUE *argv, VALUE self) { FXFrame *arg1 = (FXFrame *) 0 ; FXuint result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFrame, 1); result = (FXuint)((FXFrame const *)arg1)->getFrameStyle();
    vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXFrame_getBorderWidth(int argc, VALUE *argv, VALUE self) { FXFrame *arg1 = (FXFrame *) 0 ; FXint result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFrame, 1); result = (FXint)((FXFrame const *)arg1)->getBorderWidth();
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXFrame_setPadTop(int argc, VALUE *argv, VALUE self) { FXFrame *arg1 = (FXFrame *) 0 ; FXint arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFrame, 1); arg2 = NUM2INT(argv[0]); (arg1)->setPadTop(arg2);
    return Qnil; }
static VALUE _wrap_FXFrame_getPadTop(int argc, VALUE *argv, VALUE self) { FXFrame *arg1 = (FXFrame *) 0 ; FXint result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFrame, 1); result = (FXint)((FXFrame const *)arg1)->getPadTop();
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXFrame_setPadBottom(int argc, VALUE *argv, VALUE self) { FXFrame *arg1 = (FXFrame *) 0 ; FXint arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFrame, 1); arg2 = NUM2INT(argv[0]); (arg1)->setPadBottom(arg2);
    return Qnil; }
static VALUE _wrap_FXFrame_getPadBottom(int argc, VALUE *argv, VALUE self) { FXFrame *arg1 = (FXFrame *) 0 ; FXint result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFrame, 1); result = (FXint)((FXFrame const *)arg1)->getPadBottom();
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXFrame_setPadLeft(int argc, VALUE *argv, VALUE self) { FXFrame *arg1 = (FXFrame *) 0 ; FXint arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFrame, 1); arg2 = NUM2INT(argv[0]); (arg1)->setPadLeft(arg2);
    return Qnil; }
static VALUE _wrap_FXFrame_getPadLeft(int argc, VALUE *argv, VALUE self) { FXFrame *arg1 = (FXFrame *) 0 ; FXint result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFrame, 1); result = (FXint)((FXFrame const *)arg1)->getPadLeft();
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXFrame_setPadRight(int argc, VALUE *argv, VALUE self) { FXFrame *arg1 = (FXFrame *) 0 ; FXint arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFrame, 1); arg2 = NUM2INT(argv[0]); (arg1)->setPadRight(arg2);
    return Qnil; }
static VALUE _wrap_FXFrame_getPadRight(int argc, VALUE *argv, VALUE self) { FXFrame *arg1 = (FXFrame *) 0 ; FXint result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFrame, 1); result = (FXint)((FXFrame const *)arg1)->getPadRight();
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXFrame_setHiliteColor(int argc, VALUE *argv, VALUE self) { FXFrame *arg1 = (FXFrame *) 0 ; FXColor arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFrame, 1); arg2 = to_FXColor(argv[0]); (arg1)->setHiliteColor(arg2);
    return Qnil; }
static VALUE _wrap_FXFrame_getHiliteColor(int argc, VALUE *argv, VALUE self) { FXFrame *arg1 = (FXFrame *) 0 ; FXColor result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFrame, 1); result = (FXColor)((FXFrame const *)arg1)->getHiliteColor();
    vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXFrame_setShadowColor(int argc, VALUE *argv, VALUE self) { FXFrame *arg1 = (FXFrame *) 0 ; FXColor arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFrame, 1); arg2 = to_FXColor(argv[0]); (arg1)->setShadowColor(arg2);
    return Qnil; }
static VALUE _wrap_FXFrame_getShadowColor(int argc, VALUE *argv, VALUE self) { FXFrame *arg1 = (FXFrame *) 0 ; FXColor result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFrame, 1); result = (FXColor)((FXFrame const *)arg1)->getShadowColor();
    vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXFrame_setBorderColor(int argc, VALUE *argv, VALUE self) { FXFrame *arg1 = (FXFrame *) 0 ; FXColor arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFrame, 1); arg2 = to_FXColor(argv[0]); (arg1)->setBorderColor(arg2);
    return Qnil; }
static VALUE _wrap_FXFrame_getBorderColor(int argc, VALUE *argv, VALUE self) { FXFrame *arg1 = (FXFrame *) 0 ; FXColor result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFrame, 1); result = (FXColor)((FXFrame const *)arg1)->getBorderColor();
    vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXFrame_setBaseColor(int argc, VALUE *argv, VALUE self) { FXFrame *arg1 = (FXFrame *) 0 ; FXColor arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFrame, 1); arg2 = to_FXColor(argv[0]); (arg1)->setBaseColor(arg2);
    return Qnil; }
static VALUE _wrap_FXFrame_getBaseColor(int argc, VALUE *argv, VALUE self) { FXFrame *arg1 = (FXFrame *) 0 ; FXColor result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFrame, 1); result = (FXColor)((FXFrame const *)arg1)->getBaseColor();
    vresult = UINT2NUM(result); return vresult; }
static void
free_FXFrame(FXFrame *arg1) {
    delete arg1;
}
static VALUE _wrap_FXFrame_save(int argc, VALUE *argv, VALUE self) { FXFrame *arg1 = (FXFrame *) 0 ; FXStream *arg2 = 0 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFrame, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXFrame_save((FXFrame const *)arg1,*arg2); return Qnil; }
static VALUE _wrap_FXFrame_load(int argc, VALUE *argv, VALUE self) { FXFrame *arg1 = (FXFrame *) 0 ; FXStream *arg2 = 0 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFrame, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXFrame_load(arg1,*arg2); return Qnil; }
static VALUE _wrap_FXFrame_create(int argc, VALUE *argv, VALUE self) { FXFrame *arg1 = (FXFrame *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFrame, 1); FXFrame_create(arg1); return Qnil; }
static VALUE _wrap_FXFrame_detach(int argc, VALUE *argv, VALUE self) { FXFrame *arg1 = (FXFrame *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFrame, 1); FXFrame_detach(arg1); return Qnil; }
static VALUE _wrap_FXFrame_destroy(int argc, VALUE *argv, VALUE self) { FXFrame *arg1 = (FXFrame *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFrame, 1); FXFrame_destroy(arg1); return Qnil; }
static VALUE _wrap_FXFrame_resize(int argc, VALUE *argv, VALUE self) { FXFrame *arg1 = (FXFrame *) 0 ; FXint arg2 ; FXint arg3 ;
    if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFrame, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    FXFrame_resize(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXFrame_getDefaultWidth(int argc, VALUE *argv, VALUE self) { FXFrame *arg1 = (FXFrame *) 0 ; FXint result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFrame, 1); result = (FXint)FXFrame_getDefaultWidth(arg1);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXFrame_getDefaultHeight(int argc, VALUE *argv, VALUE self) { FXFrame *arg1 = (FXFrame *) 0 ; FXint result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFrame, 1); result = (FXint)FXFrame_getDefaultHeight(arg1);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXFrame_getWidthForHeight(int argc, VALUE *argv, VALUE self) { FXFrame *arg1 = (FXFrame *) 0 ; FXint arg2 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFrame, 1); arg2 = NUM2INT(argv[0]);
    result = (FXint)FXFrame_getWidthForHeight(arg1,arg2); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXFrame_getHeightForWidth(int argc, VALUE *argv, VALUE self) { FXFrame *arg1 = (FXFrame *) 0 ; FXint arg2 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFrame, 1); arg2 = NUM2INT(argv[0]);
    result = (FXint)FXFrame_getHeightForWidth(arg1,arg2); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXFrame_canFocus(int argc, VALUE *argv, VALUE self) { FXFrame *arg1 = (FXFrame *) 0 ; FXbool result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFrame, 1); result = (FXbool)FXFrame_canFocus((FXFrame const *)arg1);
    vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXFrame_setFocus(int argc, VALUE *argv, VALUE self) { FXFrame *arg1 = (FXFrame *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFrame, 1); FXFrame_setFocus(arg1); return Qnil; }
static VALUE _wrap_FXFrame_killFocus(int argc, VALUE *argv, VALUE self) { FXFrame *arg1 = (FXFrame *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFrame, 1); FXFrame_killFocus(arg1); return Qnil; }
static VALUE _wrap_FXFrame_setDefault(int argc, VALUE *argv, VALUE self) { FXFrame *arg1 = (FXFrame *) 0 ;
    FXbool arg2 = (FXbool) 1 ; if ((argc < 0) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFrame, 1); if (argc > 0) { arg2 = to_FXbool(argv[0]); } 
    FXFrame_setDefault(arg1,arg2); return Qnil; }
static VALUE _wrap_FXFrame_enable(int argc, VALUE *argv, VALUE self) { FXFrame *arg1 = (FXFrame *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFrame, 1); FXFrame_enable(arg1); return Qnil; }
static VALUE _wrap_FXFrame_disable(int argc, VALUE *argv, VALUE self) { FXFrame *arg1 = (FXFrame *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFrame, 1); FXFrame_disable(arg1); return Qnil; }
static VALUE _wrap_FXFrame_raiseWindow(int argc, VALUE *argv, VALUE self) { FXFrame *arg1 = (FXFrame *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFrame, 1); FXFrame_raise(arg1); return Qnil; }
static VALUE _wrap_FXFrame_lower(int argc, VALUE *argv, VALUE self) { FXFrame *arg1 = (FXFrame *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFrame, 1); FXFrame_lower(arg1); return Qnil; }
static VALUE _wrap_FXFrame_move(int argc, VALUE *argv, VALUE self) { FXFrame *arg1 = (FXFrame *) 0 ; FXint arg2 ; FXint arg3 ;
    if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFrame, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    FXFrame_move(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXFrame_position(int argc, VALUE *argv, VALUE self) { FXFrame *arg1 = (FXFrame *) 0 ; FXint arg2 ;
    FXint arg3 ; FXint arg4 ; FXint arg5 ; if ((argc < 4) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFrame, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    arg4 = NUM2INT(argv[2]); arg5 = NUM2INT(argv[3]); FXFrame_position(arg1,arg2,arg3,arg4,arg5); return Qnil; }
static VALUE _wrap_FXFrame_layout(int argc, VALUE *argv, VALUE self) { FXFrame *arg1 = (FXFrame *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFrame, 1); FXFrame_layout(arg1); return Qnil; }
static VALUE _wrap_FXFrame_recalc(int argc, VALUE *argv, VALUE self) { FXFrame *arg1 = (FXFrame *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFrame, 1); FXFrame_recalc(arg1); return Qnil; }
static VALUE _wrap_FXFrame_reparent(int argc, VALUE *argv, VALUE self) { FXFrame *arg1 = (FXFrame *) 0 ;
    FXComposite *arg2 = (FXComposite *) 0 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFrame, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXComposite, 1); FXFrame_reparent(arg1,arg2); return Qnil; }
static VALUE _wrap_FXFrame_show(int argc, VALUE *argv, VALUE self) { FXFrame *arg1 = (FXFrame *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFrame, 1); FXFrame_show(arg1); return Qnil; }
static VALUE _wrap_FXFrame_hide(int argc, VALUE *argv, VALUE self) { FXFrame *arg1 = (FXFrame *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFrame, 1); FXFrame_hide(arg1); return Qnil; }
static VALUE _wrap_FXFrame_isComposite(int argc, VALUE *argv, VALUE self) { FXFrame *arg1 = (FXFrame *) 0 ; FXbool result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFrame, 1); result = (FXbool)FXFrame_isComposite((FXFrame const *)arg1);
    vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXFrame_contains(int argc, VALUE *argv, VALUE self) { FXFrame *arg1 = (FXFrame *) 0 ; FXint arg2 ;
    FXint arg3 ; FXbool result; VALUE vresult = Qnil; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFrame, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    result = (FXbool)FXFrame_contains((FXFrame const *)arg1,arg2,arg3); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXFrame_doesSaveUnder(int argc, VALUE *argv, VALUE self) { FXFrame *arg1 = (FXFrame *) 0 ; FXbool result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFrame, 1);
    result = (FXbool)FXFrame_doesSaveUnder((FXFrame const *)arg1); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXFrame_setBackColor(int argc, VALUE *argv, VALUE self) { FXFrame *arg1 = (FXFrame *) 0 ; FXColor arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFrame, 1); arg2 = to_FXColor(argv[0]); FXFrame_setBackColor(arg1,arg2);
    return Qnil; }
static VALUE _wrap_FXComposite_onKeyPress(int argc, VALUE *argv, VALUE self) { FXComposite *arg1 = (FXComposite *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXComposite, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onKeyPress(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXComposite_onKeyRelease(int argc, VALUE *argv, VALUE self) { FXComposite *arg1 = (FXComposite *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXComposite, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onKeyRelease(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXComposite_onFocusNext(int argc, VALUE *argv, VALUE self) { FXComposite *arg1 = (FXComposite *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXComposite, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onFocusNext(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXComposite_onFocusPrev(int argc, VALUE *argv, VALUE self) { FXComposite *arg1 = (FXComposite *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXComposite, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onFocusPrev(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXComposite_onCmdUpdate(int argc, VALUE *argv, VALUE self) { FXComposite *arg1 = (FXComposite *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXComposite, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onCmdUpdate(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE _wrap_FXComposite_allocate(VALUE self) {
#else
     static VALUE _wrap_FXComposite_allocate(int argc, VALUE *argv, VALUE self) {
#endif
         VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_FXComposite);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
         return vresult; }
static VALUE _wrap_new_FXComposite(int argc, VALUE *argv, VALUE self) { FXComposite *arg1 = (FXComposite *) 0 ;
    FXuint arg2 = (FXuint) 0 ; FXint arg3 = (FXint) 0 ; FXint arg4 = (FXint) 0 ; FXint arg5 = (FXint) 0 ;
    FXint arg6 = (FXint) 0 ; FXComposite *result; if ((argc < 1) || (argc > 6))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXComposite, 1); if (argc > 1) { arg2 = NUM2UINT(argv[1]); } 
    if (argc > 2) { arg3 = NUM2INT(argv[2]); }  if (argc > 3) { arg4 = NUM2INT(argv[3]); }  if (argc > 4) {
        arg5 = NUM2INT(argv[4]); }  if (argc > 5) { arg6 = NUM2INT(argv[5]); }  {
        result = (FXComposite *)new_FXComposite(arg1,arg2,arg3,arg4,arg5,arg6);
        DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result); if(rb_block_given_p()){ rb_yield(self); }  }  return self; }
static VALUE _wrap_FXComposite_maxChildWidth(int argc, VALUE *argv, VALUE self) { FXComposite *arg1 = (FXComposite *) 0 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXComposite, 1);
    result = (FXint)((FXComposite const *)arg1)->maxChildWidth(); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXComposite_maxChildHeight(int argc, VALUE *argv, VALUE self) { FXComposite *arg1 = (FXComposite *) 0 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXComposite, 1);
    result = (FXint)((FXComposite const *)arg1)->maxChildHeight(); vresult = INT2NUM(result); return vresult; }
static void
free_FXComposite(FXComposite *arg1) {
    delete arg1;
}
static VALUE _wrap_FXComposite_save(int argc, VALUE *argv, VALUE self) { FXComposite *arg1 = (FXComposite *) 0 ;
    FXStream *arg2 = 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXComposite, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXComposite_save((FXComposite const *)arg1,*arg2); return Qnil; }
static VALUE _wrap_FXComposite_load(int argc, VALUE *argv, VALUE self) { FXComposite *arg1 = (FXComposite *) 0 ;
    FXStream *arg2 = 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXComposite, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXComposite_load(arg1,*arg2); return Qnil; }
static VALUE _wrap_FXComposite_create(int argc, VALUE *argv, VALUE self) { FXComposite *arg1 = (FXComposite *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXComposite, 1); FXComposite_create(arg1); return Qnil; }
static VALUE _wrap_FXComposite_detach(int argc, VALUE *argv, VALUE self) { FXComposite *arg1 = (FXComposite *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXComposite, 1); FXComposite_detach(arg1); return Qnil; }
static VALUE _wrap_FXComposite_destroy(int argc, VALUE *argv, VALUE self) { FXComposite *arg1 = (FXComposite *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXComposite, 1); FXComposite_destroy(arg1); return Qnil; }
static VALUE _wrap_FXComposite_resize(int argc, VALUE *argv, VALUE self) { FXComposite *arg1 = (FXComposite *) 0 ; FXint arg2 ;
    FXint arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXComposite, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    FXComposite_resize(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXComposite_getDefaultWidth(int argc, VALUE *argv, VALUE self) { FXComposite *arg1 = (FXComposite *) 0 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXComposite, 1); result = (FXint)FXComposite_getDefaultWidth(arg1);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXComposite_getDefaultHeight(int argc, VALUE *argv, VALUE self) { FXComposite *arg1 = (FXComposite *) 0 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXComposite, 1); result = (FXint)FXComposite_getDefaultHeight(arg1);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXComposite_getWidthForHeight(int argc, VALUE *argv, VALUE self) { FXComposite *arg1 = (FXComposite *) 0 ;
    FXint arg2 ; FXint result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXComposite, 1); arg2 = NUM2INT(argv[0]);
    result = (FXint)FXComposite_getWidthForHeight(arg1,arg2); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXComposite_getHeightForWidth(int argc, VALUE *argv, VALUE self) { FXComposite *arg1 = (FXComposite *) 0 ;
    FXint arg2 ; FXint result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXComposite, 1); arg2 = NUM2INT(argv[0]);
    result = (FXint)FXComposite_getHeightForWidth(arg1,arg2); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXComposite_canFocus(int argc, VALUE *argv, VALUE self) { FXComposite *arg1 = (FXComposite *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXComposite, 1);
    result = (FXbool)FXComposite_canFocus((FXComposite const *)arg1); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXComposite_setFocus(int argc, VALUE *argv, VALUE self) { FXComposite *arg1 = (FXComposite *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXComposite, 1); FXComposite_setFocus(arg1); return Qnil; }
static VALUE _wrap_FXComposite_killFocus(int argc, VALUE *argv, VALUE self) { FXComposite *arg1 = (FXComposite *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXComposite, 1); FXComposite_killFocus(arg1); return Qnil; }
static VALUE _wrap_FXComposite_setDefault(int argc, VALUE *argv, VALUE self) { FXComposite *arg1 = (FXComposite *) 0 ;
    FXbool arg2 = (FXbool) 1 ; if ((argc < 0) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXComposite, 1); if (argc > 0) { arg2 = to_FXbool(argv[0]); } 
    FXComposite_setDefault(arg1,arg2); return Qnil; }
static VALUE _wrap_FXComposite_enable(int argc, VALUE *argv, VALUE self) { FXComposite *arg1 = (FXComposite *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXComposite, 1); FXComposite_enable(arg1); return Qnil; }
static VALUE _wrap_FXComposite_disable(int argc, VALUE *argv, VALUE self) { FXComposite *arg1 = (FXComposite *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXComposite, 1); FXComposite_disable(arg1); return Qnil; }
static VALUE _wrap_FXComposite_raiseWindow(int argc, VALUE *argv, VALUE self) { FXComposite *arg1 = (FXComposite *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXComposite, 1); FXComposite_raise(arg1); return Qnil; }
static VALUE _wrap_FXComposite_lower(int argc, VALUE *argv, VALUE self) { FXComposite *arg1 = (FXComposite *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXComposite, 1); FXComposite_lower(arg1); return Qnil; }
static VALUE _wrap_FXComposite_move(int argc, VALUE *argv, VALUE self) { FXComposite *arg1 = (FXComposite *) 0 ; FXint arg2 ;
    FXint arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXComposite, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    FXComposite_move(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXComposite_position(int argc, VALUE *argv, VALUE self) { FXComposite *arg1 = (FXComposite *) 0 ;
    FXint arg2 ; FXint arg3 ; FXint arg4 ; FXint arg5 ; if ((argc < 4) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXComposite, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    arg4 = NUM2INT(argv[2]); arg5 = NUM2INT(argv[3]); FXComposite_position(arg1,arg2,arg3,arg4,arg5); return Qnil; }
static VALUE _wrap_FXComposite_layout(int argc, VALUE *argv, VALUE self) { FXComposite *arg1 = (FXComposite *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXComposite, 1); FXComposite_layout(arg1); return Qnil; }
static VALUE _wrap_FXComposite_recalc(int argc, VALUE *argv, VALUE self) { FXComposite *arg1 = (FXComposite *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXComposite, 1); FXComposite_recalc(arg1); return Qnil; }
static VALUE _wrap_FXComposite_reparent(int argc, VALUE *argv, VALUE self) { FXComposite *arg1 = (FXComposite *) 0 ;
    FXComposite *arg2 = (FXComposite *) 0 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXComposite, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXComposite, 1); FXComposite_reparent(arg1,arg2); return Qnil; }
static VALUE _wrap_FXComposite_show(int argc, VALUE *argv, VALUE self) { FXComposite *arg1 = (FXComposite *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXComposite, 1); FXComposite_show(arg1); return Qnil; }
static VALUE _wrap_FXComposite_hide(int argc, VALUE *argv, VALUE self) { FXComposite *arg1 = (FXComposite *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXComposite, 1); FXComposite_hide(arg1); return Qnil; }
static VALUE _wrap_FXComposite_isComposite(int argc, VALUE *argv, VALUE self) { FXComposite *arg1 = (FXComposite *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXComposite, 1);
    result = (FXbool)FXComposite_isComposite((FXComposite const *)arg1); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXComposite_contains(int argc, VALUE *argv, VALUE self) { FXComposite *arg1 = (FXComposite *) 0 ;
    FXint arg2 ; FXint arg3 ; FXbool result; VALUE vresult = Qnil; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXComposite, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    result = (FXbool)FXComposite_contains((FXComposite const *)arg1,arg2,arg3); vresult = result ? Qtrue : Qfalse;
    return vresult; }
static VALUE _wrap_FXComposite_doesSaveUnder(int argc, VALUE *argv, VALUE self) { FXComposite *arg1 = (FXComposite *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXComposite, 1);
    result = (FXbool)FXComposite_doesSaveUnder((FXComposite const *)arg1); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXComposite_setBackColor(int argc, VALUE *argv, VALUE self) { FXComposite *arg1 = (FXComposite *) 0 ;
    FXColor arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXComposite, 1); arg2 = to_FXColor(argv[0]);
    FXComposite_setBackColor(arg1,arg2); return Qnil; }
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE _wrap_FXRootWindow_allocate(VALUE self) {
#else
     static VALUE _wrap_FXRootWindow_allocate(int argc, VALUE *argv, VALUE self) {
#endif
         VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_FXRootWindow);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
         return vresult; }
static VALUE _wrap_new_FXRootWindow(int argc, VALUE *argv, VALUE self) { FXApp *arg1 = (FXApp *) 0 ;
    FXVisual *arg2 = (FXVisual *) 0 ; FXRootWindow *result; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXApp, 1);
    SWIG_ConvertPtr(argv[1], (void **) &arg2, SWIGTYPE_p_FXVisual, 1); { result = (FXRootWindow *)new_FXRootWindow(arg1,arg2);
        DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result); if(rb_block_given_p()){ rb_yield(self); }  }  return self; }
static void
free_FXRootWindow(FXRootWindow *arg1) {
    delete arg1;
}
static VALUE _wrap_FXRootWindow_save(int argc, VALUE *argv, VALUE self) { FXRootWindow *arg1 = (FXRootWindow *) 0 ;
    FXStream *arg2 = 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRootWindow, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXRootWindow_save((FXRootWindow const *)arg1,*arg2); return Qnil; }
static VALUE _wrap_FXRootWindow_load(int argc, VALUE *argv, VALUE self) { FXRootWindow *arg1 = (FXRootWindow *) 0 ;
    FXStream *arg2 = 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRootWindow, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXRootWindow_load(arg1,*arg2); return Qnil; }
static VALUE _wrap_FXRootWindow_create(int argc, VALUE *argv, VALUE self) { FXRootWindow *arg1 = (FXRootWindow *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRootWindow, 1); FXRootWindow_create(arg1); return Qnil; }
static VALUE _wrap_FXRootWindow_detach(int argc, VALUE *argv, VALUE self) { FXRootWindow *arg1 = (FXRootWindow *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRootWindow, 1); FXRootWindow_detach(arg1); return Qnil; }
static VALUE _wrap_FXRootWindow_destroy(int argc, VALUE *argv, VALUE self) { FXRootWindow *arg1 = (FXRootWindow *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRootWindow, 1); FXRootWindow_destroy(arg1); return Qnil; }
static VALUE _wrap_FXRootWindow_resize(int argc, VALUE *argv, VALUE self) { FXRootWindow *arg1 = (FXRootWindow *) 0 ;
    FXint arg2 ; FXint arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRootWindow, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    FXRootWindow_resize(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXRootWindow_getDefaultWidth(int argc, VALUE *argv, VALUE self) { FXRootWindow *arg1 = (FXRootWindow *) 0 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRootWindow, 1); result = (FXint)FXRootWindow_getDefaultWidth(arg1);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXRootWindow_getDefaultHeight(int argc, VALUE *argv, VALUE self) { FXRootWindow *arg1 = (FXRootWindow *) 0 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRootWindow, 1); result = (FXint)FXRootWindow_getDefaultHeight(arg1);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXRootWindow_getWidthForHeight(int argc, VALUE *argv, VALUE self) { FXRootWindow *arg1 = (FXRootWindow *) 0 ;
    FXint arg2 ; FXint result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRootWindow, 1); arg2 = NUM2INT(argv[0]);
    result = (FXint)FXRootWindow_getWidthForHeight(arg1,arg2); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXRootWindow_getHeightForWidth(int argc, VALUE *argv, VALUE self) { FXRootWindow *arg1 = (FXRootWindow *) 0 ;
    FXint arg2 ; FXint result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRootWindow, 1); arg2 = NUM2INT(argv[0]);
    result = (FXint)FXRootWindow_getHeightForWidth(arg1,arg2); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXRootWindow_canFocus(int argc, VALUE *argv, VALUE self) { FXRootWindow *arg1 = (FXRootWindow *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRootWindow, 1);
    result = (FXbool)FXRootWindow_canFocus((FXRootWindow const *)arg1); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXRootWindow_setFocus(int argc, VALUE *argv, VALUE self) { FXRootWindow *arg1 = (FXRootWindow *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRootWindow, 1); FXRootWindow_setFocus(arg1); return Qnil; }
static VALUE _wrap_FXRootWindow_killFocus(int argc, VALUE *argv, VALUE self) { FXRootWindow *arg1 = (FXRootWindow *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRootWindow, 1); FXRootWindow_killFocus(arg1); return Qnil; }
static VALUE _wrap_FXRootWindow_setDefault(int argc, VALUE *argv, VALUE self) { FXRootWindow *arg1 = (FXRootWindow *) 0 ;
    FXbool arg2 = (FXbool) 1 ; if ((argc < 0) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRootWindow, 1); if (argc > 0) { arg2 = to_FXbool(argv[0]); } 
    FXRootWindow_setDefault(arg1,arg2); return Qnil; }
static VALUE _wrap_FXRootWindow_enable(int argc, VALUE *argv, VALUE self) { FXRootWindow *arg1 = (FXRootWindow *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRootWindow, 1); FXRootWindow_enable(arg1); return Qnil; }
static VALUE _wrap_FXRootWindow_disable(int argc, VALUE *argv, VALUE self) { FXRootWindow *arg1 = (FXRootWindow *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRootWindow, 1); FXRootWindow_disable(arg1); return Qnil; }
static VALUE _wrap_FXRootWindow_raiseWindow(int argc, VALUE *argv, VALUE self) { FXRootWindow *arg1 = (FXRootWindow *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRootWindow, 1); FXRootWindow_raise(arg1); return Qnil; }
static VALUE _wrap_FXRootWindow_lower(int argc, VALUE *argv, VALUE self) { FXRootWindow *arg1 = (FXRootWindow *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRootWindow, 1); FXRootWindow_lower(arg1); return Qnil; }
static VALUE _wrap_FXRootWindow_move(int argc, VALUE *argv, VALUE self) { FXRootWindow *arg1 = (FXRootWindow *) 0 ; FXint arg2 ;
    FXint arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRootWindow, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    FXRootWindow_move(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXRootWindow_position(int argc, VALUE *argv, VALUE self) { FXRootWindow *arg1 = (FXRootWindow *) 0 ;
    FXint arg2 ; FXint arg3 ; FXint arg4 ; FXint arg5 ; if ((argc < 4) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRootWindow, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    arg4 = NUM2INT(argv[2]); arg5 = NUM2INT(argv[3]); FXRootWindow_position(arg1,arg2,arg3,arg4,arg5); return Qnil; }
static VALUE _wrap_FXRootWindow_layout(int argc, VALUE *argv, VALUE self) { FXRootWindow *arg1 = (FXRootWindow *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRootWindow, 1); FXRootWindow_layout(arg1); return Qnil; }
static VALUE _wrap_FXRootWindow_recalc(int argc, VALUE *argv, VALUE self) { FXRootWindow *arg1 = (FXRootWindow *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRootWindow, 1); FXRootWindow_recalc(arg1); return Qnil; }
static VALUE _wrap_FXRootWindow_reparent(int argc, VALUE *argv, VALUE self) { FXRootWindow *arg1 = (FXRootWindow *) 0 ;
    FXComposite *arg2 = (FXComposite *) 0 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRootWindow, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXComposite, 1); FXRootWindow_reparent(arg1,arg2); return Qnil; }
static VALUE _wrap_FXRootWindow_show(int argc, VALUE *argv, VALUE self) { FXRootWindow *arg1 = (FXRootWindow *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRootWindow, 1); FXRootWindow_show(arg1); return Qnil; }
static VALUE _wrap_FXRootWindow_hide(int argc, VALUE *argv, VALUE self) { FXRootWindow *arg1 = (FXRootWindow *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRootWindow, 1); FXRootWindow_hide(arg1); return Qnil; }
static VALUE _wrap_FXRootWindow_isComposite(int argc, VALUE *argv, VALUE self) { FXRootWindow *arg1 = (FXRootWindow *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRootWindow, 1);
    result = (FXbool)FXRootWindow_isComposite((FXRootWindow const *)arg1); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXRootWindow_contains(int argc, VALUE *argv, VALUE self) { FXRootWindow *arg1 = (FXRootWindow *) 0 ;
    FXint arg2 ; FXint arg3 ; FXbool result; VALUE vresult = Qnil; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRootWindow, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    result = (FXbool)FXRootWindow_contains((FXRootWindow const *)arg1,arg2,arg3); vresult = result ? Qtrue : Qfalse;
    return vresult; }
static VALUE _wrap_FXRootWindow_doesSaveUnder(int argc, VALUE *argv, VALUE self) { FXRootWindow *arg1 = (FXRootWindow *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRootWindow, 1);
    result = (FXbool)FXRootWindow_doesSaveUnder((FXRootWindow const *)arg1); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXRootWindow_setBackColor(int argc, VALUE *argv, VALUE self) { FXRootWindow *arg1 = (FXRootWindow *) 0 ;
    FXColor arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRootWindow, 1); arg2 = to_FXColor(argv[0]);
    FXRootWindow_setBackColor(arg1,arg2); return Qnil; }
static VALUE _wrap_FXShell_onLayout(int argc, VALUE *argv, VALUE self) { FXShell *arg1 = (FXShell *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXShell, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onLayout(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXShell_onConfigure(int argc, VALUE *argv, VALUE self) { FXShell *arg1 = (FXShell *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXShell, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onConfigure(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXShell_onKeyPress(int argc, VALUE *argv, VALUE self) { FXShell *arg1 = (FXShell *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXShell, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onKeyPress(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXShell_onKeyRelease(int argc, VALUE *argv, VALUE self) { FXShell *arg1 = (FXShell *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXShell, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onKeyRelease(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXShell_onFocusNext(int argc, VALUE *argv, VALUE self) { FXShell *arg1 = (FXShell *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXShell, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onFocusNext(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXShell_onFocusPrev(int argc, VALUE *argv, VALUE self) { FXShell *arg1 = (FXShell *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXShell, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onFocusPrev(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_new_FXShell__SWIG_0(int argc, VALUE *argv, VALUE self) { FXApp *arg1 = (FXApp *) 0 ; FXuint arg2 ;
    FXint arg3 ; FXint arg4 ; FXint arg5 ; FXint arg6 ; FXShell *result; if ((argc < 6) || (argc > 6))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 6)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXApp, 1); arg2 = NUM2UINT(argv[1]); arg3 = NUM2INT(argv[2]);
    arg4 = NUM2INT(argv[3]); arg5 = NUM2INT(argv[4]); arg6 = NUM2INT(argv[5]); {
        result = (FXShell *)new_FXShell__SWIG_0(arg1,arg2,arg3,arg4,arg5,arg6);
        DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result); if(rb_block_given_p()){ rb_yield(self); }  }  return self; }
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE _wrap_FXShell_allocate(VALUE self) {
#else
     static VALUE _wrap_FXShell_allocate(int argc, VALUE *argv, VALUE self) {
#endif
         VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_FXShell);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
         return vresult; }
static VALUE _wrap_new_FXShell__SWIG_1(int argc, VALUE *argv, VALUE self) { FXWindow *arg1 = (FXWindow *) 0 ; FXuint arg2 ;
    FXint arg3 ; FXint arg4 ; FXint arg5 ; FXint arg6 ; FXShell *result; if ((argc < 6) || (argc > 6))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 6)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXWindow, 1); arg2 = NUM2UINT(argv[1]); arg3 = NUM2INT(argv[2]);
    arg4 = NUM2INT(argv[3]); arg5 = NUM2INT(argv[4]); arg6 = NUM2INT(argv[5]); {
        result = (FXShell *)new_FXShell__SWIG_1(arg1,arg2,arg3,arg4,arg5,arg6);
        DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result); if(rb_block_given_p()){ rb_yield(self); }  }  return self; }
static VALUE _wrap_new_FXShell(int nargs, VALUE *args, VALUE self) { int argc; VALUE argv[6]; int ii; argc = nargs;
    for (ii = 0; (ii < argc) && (ii < 6); ii++) { argv[ii] = args[ii]; }  if (argc == 6) { int _v; { void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXApp, 0) != -1)) ? 1 : 0; }
         if (_v) { { _v = ((TYPE(argv[1]) == T_FIXNUM) || (TYPE(argv[1]) == T_BIGNUM)) ? 1 : 0; }  if (_v) { {
                    _v = ((TYPE(argv[2]) == T_FIXNUM) || (TYPE(argv[2]) == T_BIGNUM)) ? 1 : 0; }  if (_v) { {
                        _v = ((TYPE(argv[3]) == T_FIXNUM) || (TYPE(argv[3]) == T_BIGNUM)) ? 1 : 0; }  if (_v) { {
                            _v = ((TYPE(argv[4]) == T_FIXNUM) || (TYPE(argv[4]) == T_BIGNUM)) ? 1 : 0; }  if (_v) { {
                                _v = ((TYPE(argv[5]) == T_FIXNUM) || (TYPE(argv[5]) == T_BIGNUM)) ? 1 : 0; }  if (_v) {
                                return _wrap_new_FXShell__SWIG_0(nargs, args, self);}  }  }  }  }  }  }  if (argc == 6) {
        int _v; { void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXWindow, 0) != -1)) ? 1 : 0; }
         if (_v) { { _v = ((TYPE(argv[1]) == T_FIXNUM) || (TYPE(argv[1]) == T_BIGNUM)) ? 1 : 0; }  if (_v) { {
                    _v = ((TYPE(argv[2]) == T_FIXNUM) || (TYPE(argv[2]) == T_BIGNUM)) ? 1 : 0; }  if (_v) { {
                        _v = ((TYPE(argv[3]) == T_FIXNUM) || (TYPE(argv[3]) == T_BIGNUM)) ? 1 : 0; }  if (_v) { {
                            _v = ((TYPE(argv[4]) == T_FIXNUM) || (TYPE(argv[4]) == T_BIGNUM)) ? 1 : 0; }  if (_v) { {
                                _v = ((TYPE(argv[5]) == T_FIXNUM) || (TYPE(argv[5]) == T_BIGNUM)) ? 1 : 0; }  if (_v) {
                                return _wrap_new_FXShell__SWIG_1(nargs, args, self);}  }  }  }  }  }  } 
    rb_raise(rb_eArgError, "No matching function for overloaded 'new_FXShell'"); return Qnil; }
static void
free_FXShell(FXShell *arg1) {
    delete arg1;
}
static VALUE _wrap_FXShell_save(int argc, VALUE *argv, VALUE self) { FXShell *arg1 = (FXShell *) 0 ; FXStream *arg2 = 0 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXShell, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXShell_save((FXShell const *)arg1,*arg2); return Qnil; }
static VALUE _wrap_FXShell_load(int argc, VALUE *argv, VALUE self) { FXShell *arg1 = (FXShell *) 0 ; FXStream *arg2 = 0 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXShell, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXShell_load(arg1,*arg2); return Qnil; }
static VALUE _wrap_FXShell_create(int argc, VALUE *argv, VALUE self) { FXShell *arg1 = (FXShell *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXShell, 1); FXShell_create(arg1); return Qnil; }
static VALUE _wrap_FXShell_detach(int argc, VALUE *argv, VALUE self) { FXShell *arg1 = (FXShell *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXShell, 1); FXShell_detach(arg1); return Qnil; }
static VALUE _wrap_FXShell_destroy(int argc, VALUE *argv, VALUE self) { FXShell *arg1 = (FXShell *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXShell, 1); FXShell_destroy(arg1); return Qnil; }
static VALUE _wrap_FXShell_resize(int argc, VALUE *argv, VALUE self) { FXShell *arg1 = (FXShell *) 0 ; FXint arg2 ; FXint arg3 ;
    if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXShell, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    FXShell_resize(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXShell_getDefaultWidth(int argc, VALUE *argv, VALUE self) { FXShell *arg1 = (FXShell *) 0 ; FXint result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXShell, 1); result = (FXint)FXShell_getDefaultWidth(arg1);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXShell_getDefaultHeight(int argc, VALUE *argv, VALUE self) { FXShell *arg1 = (FXShell *) 0 ; FXint result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXShell, 1); result = (FXint)FXShell_getDefaultHeight(arg1);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXShell_getWidthForHeight(int argc, VALUE *argv, VALUE self) { FXShell *arg1 = (FXShell *) 0 ; FXint arg2 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXShell, 1); arg2 = NUM2INT(argv[0]);
    result = (FXint)FXShell_getWidthForHeight(arg1,arg2); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXShell_getHeightForWidth(int argc, VALUE *argv, VALUE self) { FXShell *arg1 = (FXShell *) 0 ; FXint arg2 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXShell, 1); arg2 = NUM2INT(argv[0]);
    result = (FXint)FXShell_getHeightForWidth(arg1,arg2); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXShell_canFocus(int argc, VALUE *argv, VALUE self) { FXShell *arg1 = (FXShell *) 0 ; FXbool result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXShell, 1); result = (FXbool)FXShell_canFocus((FXShell const *)arg1);
    vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXShell_setFocus(int argc, VALUE *argv, VALUE self) { FXShell *arg1 = (FXShell *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXShell, 1); FXShell_setFocus(arg1); return Qnil; }
static VALUE _wrap_FXShell_killFocus(int argc, VALUE *argv, VALUE self) { FXShell *arg1 = (FXShell *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXShell, 1); FXShell_killFocus(arg1); return Qnil; }
static VALUE _wrap_FXShell_setDefault(int argc, VALUE *argv, VALUE self) { FXShell *arg1 = (FXShell *) 0 ;
    FXbool arg2 = (FXbool) 1 ; if ((argc < 0) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXShell, 1); if (argc > 0) { arg2 = to_FXbool(argv[0]); } 
    FXShell_setDefault(arg1,arg2); return Qnil; }
static VALUE _wrap_FXShell_enable(int argc, VALUE *argv, VALUE self) { FXShell *arg1 = (FXShell *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXShell, 1); FXShell_enable(arg1); return Qnil; }
static VALUE _wrap_FXShell_disable(int argc, VALUE *argv, VALUE self) { FXShell *arg1 = (FXShell *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXShell, 1); FXShell_disable(arg1); return Qnil; }
static VALUE _wrap_FXShell_raiseWindow(int argc, VALUE *argv, VALUE self) { FXShell *arg1 = (FXShell *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXShell, 1); FXShell_raise(arg1); return Qnil; }
static VALUE _wrap_FXShell_lower(int argc, VALUE *argv, VALUE self) { FXShell *arg1 = (FXShell *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXShell, 1); FXShell_lower(arg1); return Qnil; }
static VALUE _wrap_FXShell_move(int argc, VALUE *argv, VALUE self) { FXShell *arg1 = (FXShell *) 0 ; FXint arg2 ; FXint arg3 ;
    if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXShell, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    FXShell_move(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXShell_position(int argc, VALUE *argv, VALUE self) { FXShell *arg1 = (FXShell *) 0 ; FXint arg2 ;
    FXint arg3 ; FXint arg4 ; FXint arg5 ; if ((argc < 4) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXShell, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    arg4 = NUM2INT(argv[2]); arg5 = NUM2INT(argv[3]); FXShell_position(arg1,arg2,arg3,arg4,arg5); return Qnil; }
static VALUE _wrap_FXShell_layout(int argc, VALUE *argv, VALUE self) { FXShell *arg1 = (FXShell *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXShell, 1); FXShell_layout(arg1); return Qnil; }
static VALUE _wrap_FXShell_recalc(int argc, VALUE *argv, VALUE self) { FXShell *arg1 = (FXShell *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXShell, 1); FXShell_recalc(arg1); return Qnil; }
static VALUE _wrap_FXShell_reparent(int argc, VALUE *argv, VALUE self) { FXShell *arg1 = (FXShell *) 0 ;
    FXComposite *arg2 = (FXComposite *) 0 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXShell, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXComposite, 1); FXShell_reparent(arg1,arg2); return Qnil; }
static VALUE _wrap_FXShell_show(int argc, VALUE *argv, VALUE self) { FXShell *arg1 = (FXShell *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXShell, 1); FXShell_show(arg1); return Qnil; }
static VALUE _wrap_FXShell_hide(int argc, VALUE *argv, VALUE self) { FXShell *arg1 = (FXShell *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXShell, 1); FXShell_hide(arg1); return Qnil; }
static VALUE _wrap_FXShell_isComposite(int argc, VALUE *argv, VALUE self) { FXShell *arg1 = (FXShell *) 0 ; FXbool result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXShell, 1); result = (FXbool)FXShell_isComposite((FXShell const *)arg1);
    vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXShell_contains(int argc, VALUE *argv, VALUE self) { FXShell *arg1 = (FXShell *) 0 ; FXint arg2 ;
    FXint arg3 ; FXbool result; VALUE vresult = Qnil; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXShell, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    result = (FXbool)FXShell_contains((FXShell const *)arg1,arg2,arg3); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXShell_doesSaveUnder(int argc, VALUE *argv, VALUE self) { FXShell *arg1 = (FXShell *) 0 ; FXbool result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXShell, 1);
    result = (FXbool)FXShell_doesSaveUnder((FXShell const *)arg1); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXShell_setBackColor(int argc, VALUE *argv, VALUE self) { FXShell *arg1 = (FXShell *) 0 ; FXColor arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXShell, 1); arg2 = to_FXColor(argv[0]); FXShell_setBackColor(arg1,arg2);
    return Qnil; }
static VALUE _wrap_FXPopup_onPaint(int argc, VALUE *argv, VALUE self) { FXPopup *arg1 = (FXPopup *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPopup, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onPaint(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXPopup_onFocusUp(int argc, VALUE *argv, VALUE self) { FXPopup *arg1 = (FXPopup *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPopup, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onFocusUp(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXPopup_onFocusDown(int argc, VALUE *argv, VALUE self) { FXPopup *arg1 = (FXPopup *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPopup, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onFocusDown(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXPopup_onFocusLeft(int argc, VALUE *argv, VALUE self) { FXPopup *arg1 = (FXPopup *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPopup, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onFocusLeft(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXPopup_onFocusRight(int argc, VALUE *argv, VALUE self) { FXPopup *arg1 = (FXPopup *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPopup, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onFocusRight(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXPopup_onFocusNext(int argc, VALUE *argv, VALUE self) { FXPopup *arg1 = (FXPopup *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPopup, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onFocusNext(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXPopup_onFocusPrev(int argc, VALUE *argv, VALUE self) { FXPopup *arg1 = (FXPopup *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPopup, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onFocusPrev(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXPopup_onEnter(int argc, VALUE *argv, VALUE self) { FXPopup *arg1 = (FXPopup *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPopup, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onEnter(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXPopup_onLeave(int argc, VALUE *argv, VALUE self) { FXPopup *arg1 = (FXPopup *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPopup, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onLeave(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXPopup_onMotion(int argc, VALUE *argv, VALUE self) { FXPopup *arg1 = (FXPopup *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPopup, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onMotion(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXPopup_onMap(int argc, VALUE *argv, VALUE self) { FXPopup *arg1 = (FXPopup *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPopup, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onMap(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXPopup_onButtonPress(int argc, VALUE *argv, VALUE self) { FXPopup *arg1 = (FXPopup *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPopup, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onButtonPress(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXPopup_onButtonRelease(int argc, VALUE *argv, VALUE self) { FXPopup *arg1 = (FXPopup *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPopup, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onButtonRelease(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXPopup_onUngrabbed(int argc, VALUE *argv, VALUE self) { FXPopup *arg1 = (FXPopup *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPopup, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onUngrabbed(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXPopup_onCmdUnpost(int argc, VALUE *argv, VALUE self) { FXPopup *arg1 = (FXPopup *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPopup, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdUnpost(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXPopup_onKeyPress(int argc, VALUE *argv, VALUE self) { FXPopup *arg1 = (FXPopup *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPopup, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onKeyPress(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXPopup_onKeyRelease(int argc, VALUE *argv, VALUE self) { FXPopup *arg1 = (FXPopup *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPopup, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onKeyRelease(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXPopup_onCmdChoice(int argc, VALUE *argv, VALUE self) { FXPopup *arg1 = (FXPopup *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPopup, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdChoice(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE _wrap_FXPopup_allocate(VALUE self) {
#else
     static VALUE _wrap_FXPopup_allocate(int argc, VALUE *argv, VALUE self) {
#endif
         VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_FXPopup);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
         return vresult; }
static VALUE _wrap_new_FXPopup(int argc, VALUE *argv, VALUE self) { FXWindow *arg1 = (FXWindow *) 0 ;
    FXuint arg2 = (FXuint) POPUP_VERTICAL|FRAME_RAISED|FRAME_THICK ; FXint arg3 = (FXint) 0 ; FXint arg4 = (FXint) 0 ;
    FXint arg5 = (FXint) 0 ; FXint arg6 = (FXint) 0 ; FXPopup *result; if ((argc < 1) || (argc > 6))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXWindow, 1); if (argc > 1) { arg2 = NUM2UINT(argv[1]); } 
    if (argc > 2) { arg3 = NUM2INT(argv[2]); }  if (argc > 3) { arg4 = NUM2INT(argv[3]); }  if (argc > 4) {
        arg5 = NUM2INT(argv[4]); }  if (argc > 5) { arg6 = NUM2INT(argv[5]); }  {
        result = (FXPopup *)new_FXPopup(arg1,arg2,arg3,arg4,arg5,arg6);
        DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result); if(rb_block_given_p()){ rb_yield(self); }  }  return self; }
static VALUE _wrap_FXPopup_getPrevActive(int argc, VALUE *argv, VALUE self) { FXPopup *arg1 = (FXPopup *) 0 ; FXPopup *result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPopup, 1); result = (FXPopup *)((FXPopup const *)arg1)->getPrevActive();
    { swig_type_info *ty = SWIG_TypeDynamicCast(SWIGTYPE_p_FXPopup, (void **) &result); vresult = FXRbGetRubyObj(result, ty); } 
    return vresult; }
static VALUE _wrap_FXPopup_getNextActive(int argc, VALUE *argv, VALUE self) { FXPopup *arg1 = (FXPopup *) 0 ; FXPopup *result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPopup, 1); result = (FXPopup *)((FXPopup const *)arg1)->getNextActive();
    { swig_type_info *ty = SWIG_TypeDynamicCast(SWIGTYPE_p_FXPopup, (void **) &result); vresult = FXRbGetRubyObj(result, ty); } 
    return vresult; }
static VALUE _wrap_FXPopup_setFrameStyle(int argc, VALUE *argv, VALUE self) { FXPopup *arg1 = (FXPopup *) 0 ; FXuint arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPopup, 1); arg2 = NUM2UINT(argv[0]); (arg1)->setFrameStyle(arg2);
    return Qnil; }
static VALUE _wrap_FXPopup_getFrameStyle(int argc, VALUE *argv, VALUE self) { FXPopup *arg1 = (FXPopup *) 0 ; FXuint result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPopup, 1); result = (FXuint)((FXPopup const *)arg1)->getFrameStyle();
    vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXPopup_getBorderWidth(int argc, VALUE *argv, VALUE self) { FXPopup *arg1 = (FXPopup *) 0 ; FXint result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPopup, 1); result = (FXint)((FXPopup const *)arg1)->getBorderWidth();
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXPopup_setHiliteColor(int argc, VALUE *argv, VALUE self) { FXPopup *arg1 = (FXPopup *) 0 ; FXColor arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPopup, 1); arg2 = to_FXColor(argv[0]); (arg1)->setHiliteColor(arg2);
    return Qnil; }
static VALUE _wrap_FXPopup_getHiliteColor(int argc, VALUE *argv, VALUE self) { FXPopup *arg1 = (FXPopup *) 0 ; FXColor result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPopup, 1); result = (FXColor)((FXPopup const *)arg1)->getHiliteColor();
    vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXPopup_setShadowColor(int argc, VALUE *argv, VALUE self) { FXPopup *arg1 = (FXPopup *) 0 ; FXColor arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPopup, 1); arg2 = to_FXColor(argv[0]); (arg1)->setShadowColor(arg2);
    return Qnil; }
static VALUE _wrap_FXPopup_getShadowColor(int argc, VALUE *argv, VALUE self) { FXPopup *arg1 = (FXPopup *) 0 ; FXColor result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPopup, 1); result = (FXColor)((FXPopup const *)arg1)->getShadowColor();
    vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXPopup_setBorderColor(int argc, VALUE *argv, VALUE self) { FXPopup *arg1 = (FXPopup *) 0 ; FXColor arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPopup, 1); arg2 = to_FXColor(argv[0]); (arg1)->setBorderColor(arg2);
    return Qnil; }
static VALUE _wrap_FXPopup_getBorderColor(int argc, VALUE *argv, VALUE self) { FXPopup *arg1 = (FXPopup *) 0 ; FXColor result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPopup, 1); result = (FXColor)((FXPopup const *)arg1)->getBorderColor();
    vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXPopup_setBaseColor(int argc, VALUE *argv, VALUE self) { FXPopup *arg1 = (FXPopup *) 0 ; FXColor arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPopup, 1); arg2 = to_FXColor(argv[0]); (arg1)->setBaseColor(arg2);
    return Qnil; }
static VALUE _wrap_FXPopup_getBaseColor(int argc, VALUE *argv, VALUE self) { FXPopup *arg1 = (FXPopup *) 0 ; FXColor result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPopup, 1); result = (FXColor)((FXPopup const *)arg1)->getBaseColor();
    vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXPopup_getGrabOwner(int argc, VALUE *argv, VALUE self) { FXPopup *arg1 = (FXPopup *) 0 ; FXWindow *result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPopup, 1); result = (FXWindow *)((FXPopup const *)arg1)->getGrabOwner();
    { swig_type_info *ty = SWIG_TypeDynamicCast(SWIGTYPE_p_FXWindow, (void **) &result); vresult = FXRbGetRubyObj(result, ty); }
     return vresult; }
static VALUE _wrap_FXPopup_getOrientation(int argc, VALUE *argv, VALUE self) { FXPopup *arg1 = (FXPopup *) 0 ; FXuint result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPopup, 1); result = (FXuint)((FXPopup const *)arg1)->getOrientation();
    vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXPopup_setOrientation(int argc, VALUE *argv, VALUE self) { FXPopup *arg1 = (FXPopup *) 0 ; FXuint arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPopup, 1); arg2 = NUM2UINT(argv[0]); (arg1)->setOrientation(arg2);
    return Qnil; }
static VALUE _wrap_FXPopup_getShrinkWrap(int argc, VALUE *argv, VALUE self) { FXPopup *arg1 = (FXPopup *) 0 ; FXbool result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPopup, 1); result = (FXbool)((FXPopup const *)arg1)->getShrinkWrap();
    vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXPopup_setShrinkWrap(int argc, VALUE *argv, VALUE self) { FXPopup *arg1 = (FXPopup *) 0 ; FXbool arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPopup, 1); arg2 = to_FXbool(argv[0]); (arg1)->setShrinkWrap(arg2);
    return Qnil; }
static void
free_FXPopup(FXPopup *arg1) {
    delete arg1;
}
static VALUE _wrap_FXPopup_save(int argc, VALUE *argv, VALUE self) { FXPopup *arg1 = (FXPopup *) 0 ; FXStream *arg2 = 0 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPopup, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXPopup_save((FXPopup const *)arg1,*arg2); return Qnil; }
static VALUE _wrap_FXPopup_load(int argc, VALUE *argv, VALUE self) { FXPopup *arg1 = (FXPopup *) 0 ; FXStream *arg2 = 0 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPopup, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXPopup_load(arg1,*arg2); return Qnil; }
static VALUE _wrap_FXPopup_create(int argc, VALUE *argv, VALUE self) { FXPopup *arg1 = (FXPopup *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPopup, 1); FXPopup_create(arg1); return Qnil; }
static VALUE _wrap_FXPopup_detach(int argc, VALUE *argv, VALUE self) { FXPopup *arg1 = (FXPopup *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPopup, 1); FXPopup_detach(arg1); return Qnil; }
static VALUE _wrap_FXPopup_destroy(int argc, VALUE *argv, VALUE self) { FXPopup *arg1 = (FXPopup *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPopup, 1); FXPopup_destroy(arg1); return Qnil; }
static VALUE _wrap_FXPopup_resize(int argc, VALUE *argv, VALUE self) { FXPopup *arg1 = (FXPopup *) 0 ; FXint arg2 ; FXint arg3 ;
    if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPopup, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    FXPopup_resize(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXPopup_getDefaultWidth(int argc, VALUE *argv, VALUE self) { FXPopup *arg1 = (FXPopup *) 0 ; FXint result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPopup, 1); result = (FXint)FXPopup_getDefaultWidth(arg1);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXPopup_getDefaultHeight(int argc, VALUE *argv, VALUE self) { FXPopup *arg1 = (FXPopup *) 0 ; FXint result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPopup, 1); result = (FXint)FXPopup_getDefaultHeight(arg1);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXPopup_getWidthForHeight(int argc, VALUE *argv, VALUE self) { FXPopup *arg1 = (FXPopup *) 0 ; FXint arg2 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPopup, 1); arg2 = NUM2INT(argv[0]);
    result = (FXint)FXPopup_getWidthForHeight(arg1,arg2); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXPopup_getHeightForWidth(int argc, VALUE *argv, VALUE self) { FXPopup *arg1 = (FXPopup *) 0 ; FXint arg2 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPopup, 1); arg2 = NUM2INT(argv[0]);
    result = (FXint)FXPopup_getHeightForWidth(arg1,arg2); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXPopup_canFocus(int argc, VALUE *argv, VALUE self) { FXPopup *arg1 = (FXPopup *) 0 ; FXbool result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPopup, 1); result = (FXbool)FXPopup_canFocus((FXPopup const *)arg1);
    vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXPopup_setFocus(int argc, VALUE *argv, VALUE self) { FXPopup *arg1 = (FXPopup *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPopup, 1); FXPopup_setFocus(arg1); return Qnil; }
static VALUE _wrap_FXPopup_killFocus(int argc, VALUE *argv, VALUE self) { FXPopup *arg1 = (FXPopup *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPopup, 1); FXPopup_killFocus(arg1); return Qnil; }
static VALUE _wrap_FXPopup_setDefault(int argc, VALUE *argv, VALUE self) { FXPopup *arg1 = (FXPopup *) 0 ;
    FXbool arg2 = (FXbool) 1 ; if ((argc < 0) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPopup, 1); if (argc > 0) { arg2 = to_FXbool(argv[0]); } 
    FXPopup_setDefault(arg1,arg2); return Qnil; }
static VALUE _wrap_FXPopup_enable(int argc, VALUE *argv, VALUE self) { FXPopup *arg1 = (FXPopup *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPopup, 1); FXPopup_enable(arg1); return Qnil; }
static VALUE _wrap_FXPopup_disable(int argc, VALUE *argv, VALUE self) { FXPopup *arg1 = (FXPopup *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPopup, 1); FXPopup_disable(arg1); return Qnil; }
static VALUE _wrap_FXPopup_raiseWindow(int argc, VALUE *argv, VALUE self) { FXPopup *arg1 = (FXPopup *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPopup, 1); FXPopup_raise(arg1); return Qnil; }
static VALUE _wrap_FXPopup_lower(int argc, VALUE *argv, VALUE self) { FXPopup *arg1 = (FXPopup *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPopup, 1); FXPopup_lower(arg1); return Qnil; }
static VALUE _wrap_FXPopup_move(int argc, VALUE *argv, VALUE self) { FXPopup *arg1 = (FXPopup *) 0 ; FXint arg2 ; FXint arg3 ;
    if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPopup, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    FXPopup_move(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXPopup_position(int argc, VALUE *argv, VALUE self) { FXPopup *arg1 = (FXPopup *) 0 ; FXint arg2 ;
    FXint arg3 ; FXint arg4 ; FXint arg5 ; if ((argc < 4) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPopup, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    arg4 = NUM2INT(argv[2]); arg5 = NUM2INT(argv[3]); FXPopup_position(arg1,arg2,arg3,arg4,arg5); return Qnil; }
static VALUE _wrap_FXPopup_layout(int argc, VALUE *argv, VALUE self) { FXPopup *arg1 = (FXPopup *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPopup, 1); FXPopup_layout(arg1); return Qnil; }
static VALUE _wrap_FXPopup_recalc(int argc, VALUE *argv, VALUE self) { FXPopup *arg1 = (FXPopup *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPopup, 1); FXPopup_recalc(arg1); return Qnil; }
static VALUE _wrap_FXPopup_reparent(int argc, VALUE *argv, VALUE self) { FXPopup *arg1 = (FXPopup *) 0 ;
    FXComposite *arg2 = (FXComposite *) 0 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPopup, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXComposite, 1); FXPopup_reparent(arg1,arg2); return Qnil; }
static VALUE _wrap_FXPopup_show(int argc, VALUE *argv, VALUE self) { FXPopup *arg1 = (FXPopup *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPopup, 1); FXPopup_show(arg1); return Qnil; }
static VALUE _wrap_FXPopup_hide(int argc, VALUE *argv, VALUE self) { FXPopup *arg1 = (FXPopup *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPopup, 1); FXPopup_hide(arg1); return Qnil; }
static VALUE _wrap_FXPopup_isComposite(int argc, VALUE *argv, VALUE self) { FXPopup *arg1 = (FXPopup *) 0 ; FXbool result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPopup, 1); result = (FXbool)FXPopup_isComposite((FXPopup const *)arg1);
    vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXPopup_contains(int argc, VALUE *argv, VALUE self) { FXPopup *arg1 = (FXPopup *) 0 ; FXint arg2 ;
    FXint arg3 ; FXbool result; VALUE vresult = Qnil; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPopup, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    result = (FXbool)FXPopup_contains((FXPopup const *)arg1,arg2,arg3); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXPopup_doesSaveUnder(int argc, VALUE *argv, VALUE self) { FXPopup *arg1 = (FXPopup *) 0 ; FXbool result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPopup, 1);
    result = (FXbool)FXPopup_doesSaveUnder((FXPopup const *)arg1); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXPopup_setBackColor(int argc, VALUE *argv, VALUE self) { FXPopup *arg1 = (FXPopup *) 0 ; FXColor arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPopup, 1); arg2 = to_FXColor(argv[0]); FXPopup_setBackColor(arg1,arg2);
    return Qnil; }
static VALUE _wrap_FXPopup_popup(int argc, VALUE *argv, VALUE self) { FXPopup *arg1 = (FXPopup *) 0 ;
    FXWindow *arg2 = (FXWindow *) 0 ; FXint arg3 ; FXint arg4 ; FXint arg5 = (FXint) 0 ; FXint arg6 = (FXint) 0 ;
    if ((argc < 3) || (argc > 5)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPopup, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXWindow, 1); arg3 = NUM2INT(argv[1]); arg4 = NUM2INT(argv[2]);
    if (argc > 3) { arg5 = NUM2INT(argv[3]); }  if (argc > 4) { arg6 = NUM2INT(argv[4]); } 
    FXPopup_popup(arg1,arg2,arg3,arg4,arg5,arg6); return Qnil; }
static VALUE _wrap_FXPopup_popdown(int argc, VALUE *argv, VALUE self) { FXPopup *arg1 = (FXPopup *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPopup, 1); FXPopup_popdown(arg1); return Qnil; }
static VALUE _wrap_FXTopWindow_onFocusUp(int argc, VALUE *argv, VALUE self) { FXTopWindow *arg1 = (FXTopWindow *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTopWindow, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onFocusUp(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTopWindow_onFocusDown(int argc, VALUE *argv, VALUE self) { FXTopWindow *arg1 = (FXTopWindow *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTopWindow, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onFocusDown(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTopWindow_onFocusLeft(int argc, VALUE *argv, VALUE self) { FXTopWindow *arg1 = (FXTopWindow *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTopWindow, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onFocusLeft(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTopWindow_onFocusRight(int argc, VALUE *argv, VALUE self) { FXTopWindow *arg1 = (FXTopWindow *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTopWindow, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onFocusRight(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTopWindow_onCmdMaximize(int argc, VALUE *argv, VALUE self) { FXTopWindow *arg1 = (FXTopWindow *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTopWindow, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]);
    SWIG_ConvertPtr(argv[2], (void **) &arg4, 0, 1); result = (long)(arg1)->onCmdMaximize(arg2,arg3,arg4);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTopWindow_onCmdMinimize(int argc, VALUE *argv, VALUE self) { FXTopWindow *arg1 = (FXTopWindow *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTopWindow, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]);
    SWIG_ConvertPtr(argv[2], (void **) &arg4, 0, 1); result = (long)(arg1)->onCmdMinimize(arg2,arg3,arg4);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTopWindow_onCmdRestore(int argc, VALUE *argv, VALUE self) { FXTopWindow *arg1 = (FXTopWindow *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTopWindow, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]);
    SWIG_ConvertPtr(argv[2], (void **) &arg4, 0, 1); result = (long)(arg1)->onCmdRestore(arg2,arg3,arg4);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTopWindow_onCmdClose(int argc, VALUE *argv, VALUE self) { FXTopWindow *arg1 = (FXTopWindow *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTopWindow, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]);
    SWIG_ConvertPtr(argv[2], (void **) &arg4, 0, 1); result = (long)(arg1)->onCmdClose(arg2,arg3,arg4);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTopWindow_onCmdSetStringValue(int argc, VALUE *argv, VALUE self) { FXTopWindow *arg1 = (FXTopWindow *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTopWindow, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]);
    SWIG_ConvertPtr(argv[2], (void **) &arg4, 0, 1); result = (long)(arg1)->onCmdSetStringValue(arg2,arg3,arg4);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTopWindow_onCmdGetStringValue(int argc, VALUE *argv, VALUE self) { FXTopWindow *arg1 = (FXTopWindow *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTopWindow, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]);
    SWIG_ConvertPtr(argv[2], (void **) &arg4, 0, 1); result = (long)(arg1)->onCmdGetStringValue(arg2,arg3,arg4);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTopWindow_onCmdSetIconValue(int argc, VALUE *argv, VALUE self) { FXTopWindow *arg1 = (FXTopWindow *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTopWindow, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]);
    SWIG_ConvertPtr(argv[2], (void **) &arg4, 0, 1); result = (long)(arg1)->onCmdSetIconValue(arg2,arg3,arg4);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTopWindow_onCmdGetIconValue(int argc, VALUE *argv, VALUE self) { FXTopWindow *arg1 = (FXTopWindow *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTopWindow, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]);
    SWIG_ConvertPtr(argv[2], (void **) &arg4, 0, 1); result = (long)(arg1)->onCmdGetIconValue(arg2,arg3,arg4);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_new_FXTopWindow__SWIG_0(int argc, VALUE *argv, VALUE self) { FXApp *arg1 = (FXApp *) 0 ; FXString *arg2 = 0 ;
    FXIcon *arg3 = (FXIcon *) 0 ; FXIcon *arg4 = (FXIcon *) 0 ; FXuint arg5 ; FXint arg6 ; FXint arg7 ; FXint arg8 ;
    FXint arg9 ; FXint arg10 ; FXint arg11 ; FXint arg12 ; FXint arg13 ; FXint arg14 ; FXint arg15 ; FXTopWindow *result;
    SwigValueWrapper<FXString > p2 ; if ((argc < 15) || (argc > 15))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 15)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXApp, 1); p2 = to_FXString(argv[1]); arg2 = &p2;
    SWIG_ConvertPtr(argv[2], (void **) &arg3, SWIGTYPE_p_FXIcon, 1);
    SWIG_ConvertPtr(argv[3], (void **) &arg4, SWIGTYPE_p_FXIcon, 1); arg5 = NUM2UINT(argv[4]); arg6 = NUM2INT(argv[5]);
    arg7 = NUM2INT(argv[6]); arg8 = NUM2INT(argv[7]); arg9 = NUM2INT(argv[8]); arg10 = NUM2INT(argv[9]);
    arg11 = NUM2INT(argv[10]); arg12 = NUM2INT(argv[11]); arg13 = NUM2INT(argv[12]); arg14 = NUM2INT(argv[13]);
    arg15 = NUM2INT(argv[14]); {
        result = (FXTopWindow *)new_FXTopWindow__SWIG_0(arg1,(FXString const &)*arg2,arg3,arg4,arg5,arg6,arg7,arg8,arg9,arg10,arg11,arg12,arg13,arg14,arg15);
        DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result); if(rb_block_given_p()){ rb_yield(self); }  }  return self; }
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE _wrap_FXTopWindow_allocate(VALUE self) {
#else
     static VALUE _wrap_FXTopWindow_allocate(int argc, VALUE *argv, VALUE self) {
#endif
         VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_FXTopWindow);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
         return vresult; }
static VALUE _wrap_new_FXTopWindow__SWIG_1(int argc, VALUE *argv, VALUE self) { FXWindow *arg1 = (FXWindow *) 0 ;
    FXString *arg2 = 0 ; FXIcon *arg3 = (FXIcon *) 0 ; FXIcon *arg4 = (FXIcon *) 0 ; FXuint arg5 ; FXint arg6 ; FXint arg7 ;
    FXint arg8 ; FXint arg9 ; FXint arg10 ; FXint arg11 ; FXint arg12 ; FXint arg13 ; FXint arg14 ; FXint arg15 ;
    FXTopWindow *result; SwigValueWrapper<FXString > p2 ; if ((argc < 15) || (argc > 15))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 15)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXWindow, 1); p2 = to_FXString(argv[1]); arg2 = &p2;
    SWIG_ConvertPtr(argv[2], (void **) &arg3, SWIGTYPE_p_FXIcon, 1);
    SWIG_ConvertPtr(argv[3], (void **) &arg4, SWIGTYPE_p_FXIcon, 1); arg5 = NUM2UINT(argv[4]); arg6 = NUM2INT(argv[5]);
    arg7 = NUM2INT(argv[6]); arg8 = NUM2INT(argv[7]); arg9 = NUM2INT(argv[8]); arg10 = NUM2INT(argv[9]);
    arg11 = NUM2INT(argv[10]); arg12 = NUM2INT(argv[11]); arg13 = NUM2INT(argv[12]); arg14 = NUM2INT(argv[13]);
    arg15 = NUM2INT(argv[14]); {
        result = (FXTopWindow *)new_FXTopWindow__SWIG_1(arg1,(FXString const &)*arg2,arg3,arg4,arg5,arg6,arg7,arg8,arg9,arg10,arg11,arg12,arg13,arg14,arg15);
        DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result); if(rb_block_given_p()){ rb_yield(self); }  }  return self; }
static VALUE _wrap_new_FXTopWindow(int nargs, VALUE *args, VALUE self) { int argc; VALUE argv[15]; int ii; argc = nargs;
    for (ii = 0; (ii < argc) && (ii < 15); ii++) { argv[ii] = args[ii]; }  if (argc == 15) { int _v; { void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXApp, 0) != -1)) ? 1 : 0; }
         if (_v) { { _v = (NIL_P(argv[1]) || TYPE(argv[1]) == T_STRING) ? 1 : 0; }  if (_v) { { void *ptr;
                    _v = (NIL_P(argv[2]) || (TYPE(argv[2]) == T_DATA && SWIG_ConvertPtr(argv[2], &ptr, SWIGTYPE_p_FXIcon, 0) != -1)) ? 1 : 0; }
                 if (_v) { { void *ptr;
                        _v = (NIL_P(argv[3]) || (TYPE(argv[3]) == T_DATA && SWIG_ConvertPtr(argv[3], &ptr, SWIGTYPE_p_FXIcon, 0) != -1)) ? 1 : 0; }
                     if (_v) { { _v = ((TYPE(argv[4]) == T_FIXNUM) || (TYPE(argv[4]) == T_BIGNUM)) ? 1 : 0; }  if (_v) { {
                                _v = ((TYPE(argv[5]) == T_FIXNUM) || (TYPE(argv[5]) == T_BIGNUM)) ? 1 : 0; }  if (_v) { {
                                    _v = ((TYPE(argv[6]) == T_FIXNUM) || (TYPE(argv[6]) == T_BIGNUM)) ? 1 : 0; }  if (_v) { {
                                        _v = ((TYPE(argv[7]) == T_FIXNUM) || (TYPE(argv[7]) == T_BIGNUM)) ? 1 : 0; }  if (_v) {
                                        { _v = ((TYPE(argv[8]) == T_FIXNUM) || (TYPE(argv[8]) == T_BIGNUM)) ? 1 : 0; } 
                                        if (_v) { { _v = ((TYPE(argv[9]) == T_FIXNUM) || (TYPE(argv[9]) == T_BIGNUM)) ? 1 : 0; }
                                             if (_v) { {
                                                    _v = ((TYPE(argv[10]) == T_FIXNUM) || (TYPE(argv[10]) == T_BIGNUM)) ? 1 : 0; }
                                                 if (_v) { {
                                                        _v = ((TYPE(argv[11]) == T_FIXNUM) || (TYPE(argv[11]) == T_BIGNUM)) ? 1 : 0; }
                                                     if (_v) { {
                                                            _v = ((TYPE(argv[12]) == T_FIXNUM) || (TYPE(argv[12]) == T_BIGNUM)) ? 1 : 0; }
                                                         if (_v) { {
                                                                _v = ((TYPE(argv[13]) == T_FIXNUM) || (TYPE(argv[13]) == T_BIGNUM)) ? 1 : 0; }
                                                             if (_v) { {
                                                                    _v = ((TYPE(argv[14]) == T_FIXNUM) || (TYPE(argv[14]) == T_BIGNUM)) ? 1 : 0; }
                                                                 if (_v) {
                                                                    return _wrap_new_FXTopWindow__SWIG_0(nargs, args, self);}  }
                                                             }  }  }  }  }  }  }  }  }  }  }  }  }  }  if (argc == 15) { int _v;
        { void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXWindow, 0) != -1)) ? 1 : 0; }
         if (_v) { { _v = (NIL_P(argv[1]) || TYPE(argv[1]) == T_STRING) ? 1 : 0; }  if (_v) { { void *ptr;
                    _v = (NIL_P(argv[2]) || (TYPE(argv[2]) == T_DATA && SWIG_ConvertPtr(argv[2], &ptr, SWIGTYPE_p_FXIcon, 0) != -1)) ? 1 : 0; }
                 if (_v) { { void *ptr;
                        _v = (NIL_P(argv[3]) || (TYPE(argv[3]) == T_DATA && SWIG_ConvertPtr(argv[3], &ptr, SWIGTYPE_p_FXIcon, 0) != -1)) ? 1 : 0; }
                     if (_v) { { _v = ((TYPE(argv[4]) == T_FIXNUM) || (TYPE(argv[4]) == T_BIGNUM)) ? 1 : 0; }  if (_v) { {
                                _v = ((TYPE(argv[5]) == T_FIXNUM) || (TYPE(argv[5]) == T_BIGNUM)) ? 1 : 0; }  if (_v) { {
                                    _v = ((TYPE(argv[6]) == T_FIXNUM) || (TYPE(argv[6]) == T_BIGNUM)) ? 1 : 0; }  if (_v) { {
                                        _v = ((TYPE(argv[7]) == T_FIXNUM) || (TYPE(argv[7]) == T_BIGNUM)) ? 1 : 0; }  if (_v) {
                                        { _v = ((TYPE(argv[8]) == T_FIXNUM) || (TYPE(argv[8]) == T_BIGNUM)) ? 1 : 0; } 
                                        if (_v) { { _v = ((TYPE(argv[9]) == T_FIXNUM) || (TYPE(argv[9]) == T_BIGNUM)) ? 1 : 0; }
                                             if (_v) { {
                                                    _v = ((TYPE(argv[10]) == T_FIXNUM) || (TYPE(argv[10]) == T_BIGNUM)) ? 1 : 0; }
                                                 if (_v) { {
                                                        _v = ((TYPE(argv[11]) == T_FIXNUM) || (TYPE(argv[11]) == T_BIGNUM)) ? 1 : 0; }
                                                     if (_v) { {
                                                            _v = ((TYPE(argv[12]) == T_FIXNUM) || (TYPE(argv[12]) == T_BIGNUM)) ? 1 : 0; }
                                                         if (_v) { {
                                                                _v = ((TYPE(argv[13]) == T_FIXNUM) || (TYPE(argv[13]) == T_BIGNUM)) ? 1 : 0; }
                                                             if (_v) { {
                                                                    _v = ((TYPE(argv[14]) == T_FIXNUM) || (TYPE(argv[14]) == T_BIGNUM)) ? 1 : 0; }
                                                                 if (_v) {
                                                                    return _wrap_new_FXTopWindow__SWIG_1(nargs, args, self);}  }
                                                             }  }  }  }  }  }  }  }  }  }  }  }  }  } 
    rb_raise(rb_eArgError, "No matching function for overloaded 'new_FXTopWindow'"); return Qnil; }
static VALUE _wrap_FXTopWindow_place(int argc, VALUE *argv, VALUE self) { FXTopWindow *arg1 = (FXTopWindow *) 0 ; FXuint arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTopWindow, 1); arg2 = NUM2UINT(argv[0]); (arg1)->place(arg2);
    return Qnil; }
static VALUE _wrap_FXTopWindow_isMaximized(int argc, VALUE *argv, VALUE self) { FXTopWindow *arg1 = (FXTopWindow *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTopWindow, 1);
    result = (FXbool)((FXTopWindow const *)arg1)->isMaximized(); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXTopWindow_isMinimized(int argc, VALUE *argv, VALUE self) { FXTopWindow *arg1 = (FXTopWindow *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTopWindow, 1);
    result = (FXbool)((FXTopWindow const *)arg1)->isMinimized(); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXTopWindow_setTitle(int argc, VALUE *argv, VALUE self) { FXTopWindow *arg1 = (FXTopWindow *) 0 ;
    FXString *arg2 = 0 ; SwigValueWrapper<FXString > p2 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTopWindow, 1); p2 = to_FXString(argv[0]); arg2 = &p2;
    (arg1)->setTitle((FXString const &)*arg2); return Qnil; }
static VALUE _wrap_FXTopWindow_getTitle(int argc, VALUE *argv, VALUE self) { FXTopWindow *arg1 = (FXTopWindow *) 0 ;
    FXString result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTopWindow, 1); result = ((FXTopWindow const *)arg1)->getTitle();
    vresult = rb_str_new2((&result)->text()); return vresult; }
static VALUE _wrap_FXTopWindow_setPadTop(int argc, VALUE *argv, VALUE self) { FXTopWindow *arg1 = (FXTopWindow *) 0 ;
    FXint arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTopWindow, 1); arg2 = NUM2INT(argv[0]); (arg1)->setPadTop(arg2);
    return Qnil; }
static VALUE _wrap_FXTopWindow_getPadTop(int argc, VALUE *argv, VALUE self) { FXTopWindow *arg1 = (FXTopWindow *) 0 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTopWindow, 1); result = (FXint)((FXTopWindow const *)arg1)->getPadTop();
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTopWindow_setPadBottom(int argc, VALUE *argv, VALUE self) { FXTopWindow *arg1 = (FXTopWindow *) 0 ;
    FXint arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTopWindow, 1); arg2 = NUM2INT(argv[0]); (arg1)->setPadBottom(arg2);
    return Qnil; }
static VALUE _wrap_FXTopWindow_getPadBottom(int argc, VALUE *argv, VALUE self) { FXTopWindow *arg1 = (FXTopWindow *) 0 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTopWindow, 1);
    result = (FXint)((FXTopWindow const *)arg1)->getPadBottom(); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTopWindow_setPadLeft(int argc, VALUE *argv, VALUE self) { FXTopWindow *arg1 = (FXTopWindow *) 0 ;
    FXint arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTopWindow, 1); arg2 = NUM2INT(argv[0]); (arg1)->setPadLeft(arg2);
    return Qnil; }
static VALUE _wrap_FXTopWindow_getPadLeft(int argc, VALUE *argv, VALUE self) { FXTopWindow *arg1 = (FXTopWindow *) 0 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTopWindow, 1);
    result = (FXint)((FXTopWindow const *)arg1)->getPadLeft(); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTopWindow_setPadRight(int argc, VALUE *argv, VALUE self) { FXTopWindow *arg1 = (FXTopWindow *) 0 ;
    FXint arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTopWindow, 1); arg2 = NUM2INT(argv[0]); (arg1)->setPadRight(arg2);
    return Qnil; }
static VALUE _wrap_FXTopWindow_getPadRight(int argc, VALUE *argv, VALUE self) { FXTopWindow *arg1 = (FXTopWindow *) 0 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTopWindow, 1);
    result = (FXint)((FXTopWindow const *)arg1)->getPadRight(); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTopWindow_getHSpacing(int argc, VALUE *argv, VALUE self) { FXTopWindow *arg1 = (FXTopWindow *) 0 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTopWindow, 1);
    result = (FXint)((FXTopWindow const *)arg1)->getHSpacing(); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTopWindow_getVSpacing(int argc, VALUE *argv, VALUE self) { FXTopWindow *arg1 = (FXTopWindow *) 0 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTopWindow, 1);
    result = (FXint)((FXTopWindow const *)arg1)->getVSpacing(); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTopWindow_setHSpacing(int argc, VALUE *argv, VALUE self) { FXTopWindow *arg1 = (FXTopWindow *) 0 ;
    FXint arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTopWindow, 1); arg2 = NUM2INT(argv[0]); (arg1)->setHSpacing(arg2);
    return Qnil; }
static VALUE _wrap_FXTopWindow_setVSpacing(int argc, VALUE *argv, VALUE self) { FXTopWindow *arg1 = (FXTopWindow *) 0 ;
    FXint arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTopWindow, 1); arg2 = NUM2INT(argv[0]); (arg1)->setVSpacing(arg2);
    return Qnil; }
static VALUE _wrap_FXTopWindow_setPackingHints(int argc, VALUE *argv, VALUE self) { FXTopWindow *arg1 = (FXTopWindow *) 0 ;
    FXuint arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTopWindow, 1); arg2 = NUM2UINT(argv[0]); (arg1)->setPackingHints(arg2);
    return Qnil; }
static VALUE _wrap_FXTopWindow_getPackingHints(int argc, VALUE *argv, VALUE self) { FXTopWindow *arg1 = (FXTopWindow *) 0 ;
    FXuint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTopWindow, 1);
    result = (FXuint)((FXTopWindow const *)arg1)->getPackingHints(); vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXTopWindow_setDecorations(int argc, VALUE *argv, VALUE self) { FXTopWindow *arg1 = (FXTopWindow *) 0 ;
    FXuint arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTopWindow, 1); arg2 = NUM2UINT(argv[0]); (arg1)->setDecorations(arg2);
    return Qnil; }
static VALUE _wrap_FXTopWindow_getDecorations(int argc, VALUE *argv, VALUE self) { FXTopWindow *arg1 = (FXTopWindow *) 0 ;
    FXuint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTopWindow, 1);
    result = (FXuint)((FXTopWindow const *)arg1)->getDecorations(); vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXTopWindow_getIcon(int argc, VALUE *argv, VALUE self) { FXTopWindow *arg1 = (FXTopWindow *) 0 ;
    FXIcon *result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTopWindow, 1);
    result = (FXIcon *)((FXTopWindow const *)arg1)->getIcon(); {
        swig_type_info *ty = SWIG_TypeDynamicCast(SWIGTYPE_p_FXIcon, (void **) &result); vresult = FXRbGetRubyObj(result, ty); }
     return vresult; }
static VALUE _wrap_FXTopWindow_setIcon(int argc, VALUE *argv, VALUE self) { FXTopWindow *arg1 = (FXTopWindow *) 0 ;
    FXIcon *arg2 = (FXIcon *) 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTopWindow, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXIcon, 1); (arg1)->setIcon(arg2); return Qnil; }
static VALUE _wrap_FXTopWindow_getMiniIcon(int argc, VALUE *argv, VALUE self) { FXTopWindow *arg1 = (FXTopWindow *) 0 ;
    FXIcon *result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTopWindow, 1);
    result = (FXIcon *)((FXTopWindow const *)arg1)->getMiniIcon(); {
        swig_type_info *ty = SWIG_TypeDynamicCast(SWIGTYPE_p_FXIcon, (void **) &result); vresult = FXRbGetRubyObj(result, ty); }
     return vresult; }
static VALUE _wrap_FXTopWindow_setMiniIcon(int argc, VALUE *argv, VALUE self) { FXTopWindow *arg1 = (FXTopWindow *) 0 ;
    FXIcon *arg2 = (FXIcon *) 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTopWindow, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXIcon, 1); (arg1)->setMiniIcon(arg2); return Qnil; }
static void
free_FXTopWindow(FXTopWindow *arg1) {
    delete arg1;
}
static VALUE _wrap_FXTopWindow_save(int argc, VALUE *argv, VALUE self) { FXTopWindow *arg1 = (FXTopWindow *) 0 ;
    FXStream *arg2 = 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTopWindow, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXTopWindow_save((FXTopWindow const *)arg1,*arg2); return Qnil; }
static VALUE _wrap_FXTopWindow_load(int argc, VALUE *argv, VALUE self) { FXTopWindow *arg1 = (FXTopWindow *) 0 ;
    FXStream *arg2 = 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTopWindow, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXTopWindow_load(arg1,*arg2); return Qnil; }
static VALUE _wrap_FXTopWindow_create(int argc, VALUE *argv, VALUE self) { FXTopWindow *arg1 = (FXTopWindow *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTopWindow, 1); FXTopWindow_create(arg1); return Qnil; }
static VALUE _wrap_FXTopWindow_detach(int argc, VALUE *argv, VALUE self) { FXTopWindow *arg1 = (FXTopWindow *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTopWindow, 1); FXTopWindow_detach(arg1); return Qnil; }
static VALUE _wrap_FXTopWindow_destroy(int argc, VALUE *argv, VALUE self) { FXTopWindow *arg1 = (FXTopWindow *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTopWindow, 1); FXTopWindow_destroy(arg1); return Qnil; }
static VALUE _wrap_FXTopWindow_resize(int argc, VALUE *argv, VALUE self) { FXTopWindow *arg1 = (FXTopWindow *) 0 ; FXint arg2 ;
    FXint arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTopWindow, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    FXTopWindow_resize(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXTopWindow_getDefaultWidth(int argc, VALUE *argv, VALUE self) { FXTopWindow *arg1 = (FXTopWindow *) 0 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTopWindow, 1); result = (FXint)FXTopWindow_getDefaultWidth(arg1);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTopWindow_getDefaultHeight(int argc, VALUE *argv, VALUE self) { FXTopWindow *arg1 = (FXTopWindow *) 0 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTopWindow, 1); result = (FXint)FXTopWindow_getDefaultHeight(arg1);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTopWindow_getWidthForHeight(int argc, VALUE *argv, VALUE self) { FXTopWindow *arg1 = (FXTopWindow *) 0 ;
    FXint arg2 ; FXint result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTopWindow, 1); arg2 = NUM2INT(argv[0]);
    result = (FXint)FXTopWindow_getWidthForHeight(arg1,arg2); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTopWindow_getHeightForWidth(int argc, VALUE *argv, VALUE self) { FXTopWindow *arg1 = (FXTopWindow *) 0 ;
    FXint arg2 ; FXint result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTopWindow, 1); arg2 = NUM2INT(argv[0]);
    result = (FXint)FXTopWindow_getHeightForWidth(arg1,arg2); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTopWindow_canFocus(int argc, VALUE *argv, VALUE self) { FXTopWindow *arg1 = (FXTopWindow *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTopWindow, 1);
    result = (FXbool)FXTopWindow_canFocus((FXTopWindow const *)arg1); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXTopWindow_setFocus(int argc, VALUE *argv, VALUE self) { FXTopWindow *arg1 = (FXTopWindow *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTopWindow, 1); FXTopWindow_setFocus(arg1); return Qnil; }
static VALUE _wrap_FXTopWindow_killFocus(int argc, VALUE *argv, VALUE self) { FXTopWindow *arg1 = (FXTopWindow *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTopWindow, 1); FXTopWindow_killFocus(arg1); return Qnil; }
static VALUE _wrap_FXTopWindow_setDefault(int argc, VALUE *argv, VALUE self) { FXTopWindow *arg1 = (FXTopWindow *) 0 ;
    FXbool arg2 = (FXbool) 1 ; if ((argc < 0) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTopWindow, 1); if (argc > 0) { arg2 = to_FXbool(argv[0]); } 
    FXTopWindow_setDefault(arg1,arg2); return Qnil; }
static VALUE _wrap_FXTopWindow_enable(int argc, VALUE *argv, VALUE self) { FXTopWindow *arg1 = (FXTopWindow *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTopWindow, 1); FXTopWindow_enable(arg1); return Qnil; }
static VALUE _wrap_FXTopWindow_disable(int argc, VALUE *argv, VALUE self) { FXTopWindow *arg1 = (FXTopWindow *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTopWindow, 1); FXTopWindow_disable(arg1); return Qnil; }
static VALUE _wrap_FXTopWindow_raiseWindow(int argc, VALUE *argv, VALUE self) { FXTopWindow *arg1 = (FXTopWindow *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTopWindow, 1); FXTopWindow_raise(arg1); return Qnil; }
static VALUE _wrap_FXTopWindow_lower(int argc, VALUE *argv, VALUE self) { FXTopWindow *arg1 = (FXTopWindow *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTopWindow, 1); FXTopWindow_lower(arg1); return Qnil; }
static VALUE _wrap_FXTopWindow_move(int argc, VALUE *argv, VALUE self) { FXTopWindow *arg1 = (FXTopWindow *) 0 ; FXint arg2 ;
    FXint arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTopWindow, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    FXTopWindow_move(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXTopWindow_position(int argc, VALUE *argv, VALUE self) { FXTopWindow *arg1 = (FXTopWindow *) 0 ;
    FXint arg2 ; FXint arg3 ; FXint arg4 ; FXint arg5 ; if ((argc < 4) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTopWindow, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    arg4 = NUM2INT(argv[2]); arg5 = NUM2INT(argv[3]); FXTopWindow_position(arg1,arg2,arg3,arg4,arg5); return Qnil; }
static VALUE _wrap_FXTopWindow_layout(int argc, VALUE *argv, VALUE self) { FXTopWindow *arg1 = (FXTopWindow *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTopWindow, 1); FXTopWindow_layout(arg1); return Qnil; }
static VALUE _wrap_FXTopWindow_recalc(int argc, VALUE *argv, VALUE self) { FXTopWindow *arg1 = (FXTopWindow *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTopWindow, 1); FXTopWindow_recalc(arg1); return Qnil; }
static VALUE _wrap_FXTopWindow_reparent(int argc, VALUE *argv, VALUE self) { FXTopWindow *arg1 = (FXTopWindow *) 0 ;
    FXComposite *arg2 = (FXComposite *) 0 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTopWindow, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXComposite, 1); FXTopWindow_reparent(arg1,arg2); return Qnil; }
static VALUE _wrap_FXTopWindow_show__SWIG_0(int argc, VALUE *argv, VALUE self) { FXTopWindow *arg1 = (FXTopWindow *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTopWindow, 1); FXTopWindow_show(arg1); return Qnil; }
static VALUE _wrap_FXTopWindow_hide(int argc, VALUE *argv, VALUE self) { FXTopWindow *arg1 = (FXTopWindow *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTopWindow, 1); FXTopWindow_hide(arg1); return Qnil; }
static VALUE _wrap_FXTopWindow_isComposite(int argc, VALUE *argv, VALUE self) { FXTopWindow *arg1 = (FXTopWindow *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTopWindow, 1);
    result = (FXbool)FXTopWindow_isComposite((FXTopWindow const *)arg1); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXTopWindow_contains(int argc, VALUE *argv, VALUE self) { FXTopWindow *arg1 = (FXTopWindow *) 0 ;
    FXint arg2 ; FXint arg3 ; FXbool result; VALUE vresult = Qnil; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTopWindow, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    result = (FXbool)FXTopWindow_contains((FXTopWindow const *)arg1,arg2,arg3); vresult = result ? Qtrue : Qfalse;
    return vresult; }
static VALUE _wrap_FXTopWindow_doesSaveUnder(int argc, VALUE *argv, VALUE self) { FXTopWindow *arg1 = (FXTopWindow *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTopWindow, 1);
    result = (FXbool)FXTopWindow_doesSaveUnder((FXTopWindow const *)arg1); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXTopWindow_setBackColor(int argc, VALUE *argv, VALUE self) { FXTopWindow *arg1 = (FXTopWindow *) 0 ;
    FXColor arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTopWindow, 1); arg2 = to_FXColor(argv[0]);
    FXTopWindow_setBackColor(arg1,arg2); return Qnil; }
static VALUE _wrap_FXTopWindow_show__SWIG_1(int argc, VALUE *argv, VALUE self) { FXTopWindow *arg1 = (FXTopWindow *) 0 ;
    FXuint arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTopWindow, 1); arg2 = NUM2UINT(argv[0]); FXTopWindow_show(arg1,arg2);
    return Qnil; }
static VALUE _wrap_FXTopWindow_show(int nargs, VALUE *args, VALUE self) { int argc; VALUE argv[3]; int ii; argc = nargs + 1;
    argv[0] = self; for (ii = 1; (ii < argc) && (ii < 2); ii++) { argv[ii] = args[ii-1]; }  if (argc == 1) { int _v; {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXTopWindow, 0) != -1)) ? 1 : 0; }
         if (_v) { return _wrap_FXTopWindow_show__SWIG_0(nargs, args, self);}  }  if (argc == 2) { int _v; { void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXTopWindow, 0) != -1)) ? 1 : 0; }
         if (_v) { { _v = ((TYPE(argv[1]) == T_FIXNUM) || (TYPE(argv[1]) == T_BIGNUM)) ? 1 : 0; }  if (_v) {
                return _wrap_FXTopWindow_show__SWIG_1(nargs, args, self);}  }  } 
    rb_raise(rb_eArgError, "No matching function for overloaded 'FXTopWindow_show'"); return Qnil; }
static VALUE _wrap_FXTopWindow_maximize(int argc, VALUE *argv, VALUE self) { FXTopWindow *arg1 = (FXTopWindow *) 0 ;
    FXbool arg2 = (FXbool) 0 ; FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTopWindow, 1); if (argc > 0) { arg2 = to_FXbool(argv[0]); } 
    result = (FXbool)FXTopWindow_maximize(arg1,arg2); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXTopWindow_minimize(int argc, VALUE *argv, VALUE self) { FXTopWindow *arg1 = (FXTopWindow *) 0 ;
    FXbool arg2 = (FXbool) 0 ; FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTopWindow, 1); if (argc > 0) { arg2 = to_FXbool(argv[0]); } 
    result = (FXbool)FXTopWindow_minimize(arg1,arg2); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXTopWindow_restore(int argc, VALUE *argv, VALUE self) { FXTopWindow *arg1 = (FXTopWindow *) 0 ;
    FXbool arg2 = (FXbool) 0 ; FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTopWindow, 1); if (argc > 0) { arg2 = to_FXbool(argv[0]); } 
    result = (FXbool)FXTopWindow_restore(arg1,arg2); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXTopWindow_close(int argc, VALUE *argv, VALUE self) { FXTopWindow *arg1 = (FXTopWindow *) 0 ;
    FXbool arg2 = (FXbool) 0 ; FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTopWindow, 1); if (argc > 0) { arg2 = to_FXbool(argv[0]); } 
    result = (FXbool)FXTopWindow_close(arg1,arg2); vresult = result ? Qtrue : Qfalse; return vresult; }
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE _wrap_FXMainWindow_allocate(VALUE self) {
#else
     static VALUE _wrap_FXMainWindow_allocate(int argc, VALUE *argv, VALUE self) {
#endif
         VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_FXMainWindow);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
         return vresult; }
static VALUE _wrap_new_FXMainWindow(int argc, VALUE *argv, VALUE self) { FXApp *arg1 = (FXApp *) 0 ; FXString *arg2 = 0 ;
    FXIcon *arg3 = (FXIcon *) 0 ; FXIcon *arg4 = (FXIcon *) 0 ; FXuint arg5 = (FXuint) DECOR_ALL ; FXint arg6 = (FXint) 0 ;
    FXint arg7 = (FXint) 0 ; FXint arg8 = (FXint) 0 ; FXint arg9 = (FXint) 0 ; FXint arg10 = (FXint) 0 ;
    FXint arg11 = (FXint) 0 ; FXint arg12 = (FXint) 0 ; FXint arg13 = (FXint) 0 ; FXint arg14 = (FXint) 0 ;
    FXint arg15 = (FXint) 0 ; FXMainWindow *result; SwigValueWrapper<FXString > p2 ; if ((argc < 2) || (argc > 15))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXApp, 1); p2 = to_FXString(argv[1]); arg2 = &p2; if (argc > 2) {
        SWIG_ConvertPtr(argv[2], (void **) &arg3, SWIGTYPE_p_FXIcon, 1); }  if (argc > 3) {
        SWIG_ConvertPtr(argv[3], (void **) &arg4, SWIGTYPE_p_FXIcon, 1); }  if (argc > 4) { arg5 = NUM2UINT(argv[4]); } 
    if (argc > 5) { arg6 = NUM2INT(argv[5]); }  if (argc > 6) { arg7 = NUM2INT(argv[6]); }  if (argc > 7) {
        arg8 = NUM2INT(argv[7]); }  if (argc > 8) { arg9 = NUM2INT(argv[8]); }  if (argc > 9) { arg10 = NUM2INT(argv[9]); } 
    if (argc > 10) { arg11 = NUM2INT(argv[10]); }  if (argc > 11) { arg12 = NUM2INT(argv[11]); }  if (argc > 12) {
        arg13 = NUM2INT(argv[12]); }  if (argc > 13) { arg14 = NUM2INT(argv[13]); }  if (argc > 14) {
        arg15 = NUM2INT(argv[14]); }  {
        result = (FXMainWindow *)new_FXMainWindow(arg1,(FXString const &)*arg2,arg3,arg4,arg5,arg6,arg7,arg8,arg9,arg10,arg11,arg12,arg13,arg14,arg15);
        DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result); if(rb_block_given_p()){ rb_yield(self); }  }  return self; }
static void
free_FXMainWindow(FXMainWindow *arg1) {
    delete arg1;
}
static VALUE _wrap_FXMainWindow_save(int argc, VALUE *argv, VALUE self) { FXMainWindow *arg1 = (FXMainWindow *) 0 ;
    FXStream *arg2 = 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMainWindow, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXMainWindow_save((FXMainWindow const *)arg1,*arg2); return Qnil; }
static VALUE _wrap_FXMainWindow_load(int argc, VALUE *argv, VALUE self) { FXMainWindow *arg1 = (FXMainWindow *) 0 ;
    FXStream *arg2 = 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMainWindow, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXMainWindow_load(arg1,*arg2); return Qnil; }
static VALUE _wrap_FXMainWindow_create(int argc, VALUE *argv, VALUE self) { FXMainWindow *arg1 = (FXMainWindow *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMainWindow, 1); FXMainWindow_create(arg1); return Qnil; }
static VALUE _wrap_FXMainWindow_detach(int argc, VALUE *argv, VALUE self) { FXMainWindow *arg1 = (FXMainWindow *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMainWindow, 1); FXMainWindow_detach(arg1); return Qnil; }
static VALUE _wrap_FXMainWindow_destroy(int argc, VALUE *argv, VALUE self) { FXMainWindow *arg1 = (FXMainWindow *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMainWindow, 1); FXMainWindow_destroy(arg1); return Qnil; }
static VALUE _wrap_FXMainWindow_resize(int argc, VALUE *argv, VALUE self) { FXMainWindow *arg1 = (FXMainWindow *) 0 ;
    FXint arg2 ; FXint arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMainWindow, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    FXMainWindow_resize(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXMainWindow_getDefaultWidth(int argc, VALUE *argv, VALUE self) { FXMainWindow *arg1 = (FXMainWindow *) 0 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMainWindow, 1); result = (FXint)FXMainWindow_getDefaultWidth(arg1);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXMainWindow_getDefaultHeight(int argc, VALUE *argv, VALUE self) { FXMainWindow *arg1 = (FXMainWindow *) 0 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMainWindow, 1); result = (FXint)FXMainWindow_getDefaultHeight(arg1);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXMainWindow_getWidthForHeight(int argc, VALUE *argv, VALUE self) { FXMainWindow *arg1 = (FXMainWindow *) 0 ;
    FXint arg2 ; FXint result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMainWindow, 1); arg2 = NUM2INT(argv[0]);
    result = (FXint)FXMainWindow_getWidthForHeight(arg1,arg2); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXMainWindow_getHeightForWidth(int argc, VALUE *argv, VALUE self) { FXMainWindow *arg1 = (FXMainWindow *) 0 ;
    FXint arg2 ; FXint result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMainWindow, 1); arg2 = NUM2INT(argv[0]);
    result = (FXint)FXMainWindow_getHeightForWidth(arg1,arg2); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXMainWindow_canFocus(int argc, VALUE *argv, VALUE self) { FXMainWindow *arg1 = (FXMainWindow *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMainWindow, 1);
    result = (FXbool)FXMainWindow_canFocus((FXMainWindow const *)arg1); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXMainWindow_setFocus(int argc, VALUE *argv, VALUE self) { FXMainWindow *arg1 = (FXMainWindow *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMainWindow, 1); FXMainWindow_setFocus(arg1); return Qnil; }
static VALUE _wrap_FXMainWindow_killFocus(int argc, VALUE *argv, VALUE self) { FXMainWindow *arg1 = (FXMainWindow *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMainWindow, 1); FXMainWindow_killFocus(arg1); return Qnil; }
static VALUE _wrap_FXMainWindow_setDefault(int argc, VALUE *argv, VALUE self) { FXMainWindow *arg1 = (FXMainWindow *) 0 ;
    FXbool arg2 = (FXbool) 1 ; if ((argc < 0) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMainWindow, 1); if (argc > 0) { arg2 = to_FXbool(argv[0]); } 
    FXMainWindow_setDefault(arg1,arg2); return Qnil; }
static VALUE _wrap_FXMainWindow_enable(int argc, VALUE *argv, VALUE self) { FXMainWindow *arg1 = (FXMainWindow *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMainWindow, 1); FXMainWindow_enable(arg1); return Qnil; }
static VALUE _wrap_FXMainWindow_disable(int argc, VALUE *argv, VALUE self) { FXMainWindow *arg1 = (FXMainWindow *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMainWindow, 1); FXMainWindow_disable(arg1); return Qnil; }
static VALUE _wrap_FXMainWindow_raiseWindow(int argc, VALUE *argv, VALUE self) { FXMainWindow *arg1 = (FXMainWindow *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMainWindow, 1); FXMainWindow_raise(arg1); return Qnil; }
static VALUE _wrap_FXMainWindow_lower(int argc, VALUE *argv, VALUE self) { FXMainWindow *arg1 = (FXMainWindow *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMainWindow, 1); FXMainWindow_lower(arg1); return Qnil; }
static VALUE _wrap_FXMainWindow_move(int argc, VALUE *argv, VALUE self) { FXMainWindow *arg1 = (FXMainWindow *) 0 ; FXint arg2 ;
    FXint arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMainWindow, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    FXMainWindow_move(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXMainWindow_position(int argc, VALUE *argv, VALUE self) { FXMainWindow *arg1 = (FXMainWindow *) 0 ;
    FXint arg2 ; FXint arg3 ; FXint arg4 ; FXint arg5 ; if ((argc < 4) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMainWindow, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    arg4 = NUM2INT(argv[2]); arg5 = NUM2INT(argv[3]); FXMainWindow_position(arg1,arg2,arg3,arg4,arg5); return Qnil; }
static VALUE _wrap_FXMainWindow_layout(int argc, VALUE *argv, VALUE self) { FXMainWindow *arg1 = (FXMainWindow *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMainWindow, 1); FXMainWindow_layout(arg1); return Qnil; }
static VALUE _wrap_FXMainWindow_recalc(int argc, VALUE *argv, VALUE self) { FXMainWindow *arg1 = (FXMainWindow *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMainWindow, 1); FXMainWindow_recalc(arg1); return Qnil; }
static VALUE _wrap_FXMainWindow_reparent(int argc, VALUE *argv, VALUE self) { FXMainWindow *arg1 = (FXMainWindow *) 0 ;
    FXComposite *arg2 = (FXComposite *) 0 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMainWindow, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXComposite, 1); FXMainWindow_reparent(arg1,arg2); return Qnil; }
static VALUE _wrap_FXMainWindow_show__SWIG_0(int argc, VALUE *argv, VALUE self) { FXMainWindow *arg1 = (FXMainWindow *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMainWindow, 1); FXMainWindow_show(arg1); return Qnil; }
static VALUE _wrap_FXMainWindow_hide(int argc, VALUE *argv, VALUE self) { FXMainWindow *arg1 = (FXMainWindow *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMainWindow, 1); FXMainWindow_hide(arg1); return Qnil; }
static VALUE _wrap_FXMainWindow_isComposite(int argc, VALUE *argv, VALUE self) { FXMainWindow *arg1 = (FXMainWindow *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMainWindow, 1);
    result = (FXbool)FXMainWindow_isComposite((FXMainWindow const *)arg1); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXMainWindow_contains(int argc, VALUE *argv, VALUE self) { FXMainWindow *arg1 = (FXMainWindow *) 0 ;
    FXint arg2 ; FXint arg3 ; FXbool result; VALUE vresult = Qnil; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMainWindow, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    result = (FXbool)FXMainWindow_contains((FXMainWindow const *)arg1,arg2,arg3); vresult = result ? Qtrue : Qfalse;
    return vresult; }
static VALUE _wrap_FXMainWindow_doesSaveUnder(int argc, VALUE *argv, VALUE self) { FXMainWindow *arg1 = (FXMainWindow *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMainWindow, 1);
    result = (FXbool)FXMainWindow_doesSaveUnder((FXMainWindow const *)arg1); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXMainWindow_setBackColor(int argc, VALUE *argv, VALUE self) { FXMainWindow *arg1 = (FXMainWindow *) 0 ;
    FXColor arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMainWindow, 1); arg2 = to_FXColor(argv[0]);
    FXMainWindow_setBackColor(arg1,arg2); return Qnil; }
static VALUE _wrap_FXMainWindow_show__SWIG_1(int argc, VALUE *argv, VALUE self) { FXMainWindow *arg1 = (FXMainWindow *) 0 ;
    FXuint arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMainWindow, 1); arg2 = NUM2UINT(argv[0]); FXMainWindow_show(arg1,arg2);
    return Qnil; }
static VALUE _wrap_FXMainWindow_show(int nargs, VALUE *args, VALUE self) { int argc; VALUE argv[3]; int ii; argc = nargs + 1;
    argv[0] = self; for (ii = 1; (ii < argc) && (ii < 2); ii++) { argv[ii] = args[ii-1]; }  if (argc == 1) { int _v; {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXMainWindow, 0) != -1)) ? 1 : 0; }
         if (_v) { return _wrap_FXMainWindow_show__SWIG_0(nargs, args, self);}  }  if (argc == 2) { int _v; { void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXMainWindow, 0) != -1)) ? 1 : 0; }
         if (_v) { { _v = ((TYPE(argv[1]) == T_FIXNUM) || (TYPE(argv[1]) == T_BIGNUM)) ? 1 : 0; }  if (_v) {
                return _wrap_FXMainWindow_show__SWIG_1(nargs, args, self);}  }  } 
    rb_raise(rb_eArgError, "No matching function for overloaded 'FXMainWindow_show'"); return Qnil; }
static VALUE _wrap_FXMainWindow_maximize(int argc, VALUE *argv, VALUE self) { FXMainWindow *arg1 = (FXMainWindow *) 0 ;
    FXbool arg2 = (FXbool) 0 ; FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMainWindow, 1); if (argc > 0) { arg2 = to_FXbool(argv[0]); } 
    result = (FXbool)FXMainWindow_maximize(arg1,arg2); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXMainWindow_minimize(int argc, VALUE *argv, VALUE self) { FXMainWindow *arg1 = (FXMainWindow *) 0 ;
    FXbool arg2 = (FXbool) 0 ; FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMainWindow, 1); if (argc > 0) { arg2 = to_FXbool(argv[0]); } 
    result = (FXbool)FXMainWindow_minimize(arg1,arg2); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXMainWindow_restore(int argc, VALUE *argv, VALUE self) { FXMainWindow *arg1 = (FXMainWindow *) 0 ;
    FXbool arg2 = (FXbool) 0 ; FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMainWindow, 1); if (argc > 0) { arg2 = to_FXbool(argv[0]); } 
    result = (FXbool)FXMainWindow_restore(arg1,arg2); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXMainWindow_close(int argc, VALUE *argv, VALUE self) { FXMainWindow *arg1 = (FXMainWindow *) 0 ;
    FXbool arg2 = (FXbool) 0 ; FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMainWindow, 1); if (argc > 0) { arg2 = to_FXbool(argv[0]); } 
    result = (FXbool)FXMainWindow_close(arg1,arg2); vresult = result ? Qtrue : Qfalse; return vresult; }

/* -------- TYPE CONVERSION AND EQUIVALENCE RULES (BEGIN) -------- */

static void *_p_FXRegistryTo_p_FXSettings(void *x) {
    return (void *)((FXSettings *)  ((FXRegistry *) x));
}
static void *_p_FXShellTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *)  ((FXShell *) x));
}
static void *_p_FXRootWindowTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *)  ((FXRootWindow *) x));
}
static void *_p_FXPopupTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXShell *) ((FXPopup *) x));
}
static void *_p_FXTopWindowTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXShell *) ((FXTopWindow *) x));
}
static void *_p_FXMainWindowTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXShell *)(FXTopWindow *) ((FXMainWindow *) x));
}
static void *_p_FXPopupTo_p_FXShell(void *x) {
    return (void *)((FXShell *)  ((FXPopup *) x));
}
static void *_p_FXTopWindowTo_p_FXShell(void *x) {
    return (void *)((FXShell *)  ((FXTopWindow *) x));
}
static void *_p_FXMainWindowTo_p_FXShell(void *x) {
    return (void *)((FXShell *) (FXTopWindow *) ((FXMainWindow *) x));
}
static void *_p_FXCompositeTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *)  ((FXComposite *) x));
}
static void *_p_FXShellTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *) ((FXShell *) x));
}
static void *_p_FXRootWindowTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *) ((FXRootWindow *) x));
}
static void *_p_FXPopupTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXShell *) ((FXPopup *) x));
}
static void *_p_FXTopWindowTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXShell *) ((FXTopWindow *) x));
}
static void *_p_FXMainWindowTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXShell *)(FXTopWindow *) ((FXMainWindow *) x));
}
static void *_p_FXFrameTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *)  ((FXFrame *) x));
}
static void *_p_FXMainWindowTo_p_FXTopWindow(void *x) {
    return (void *)((FXTopWindow *)  ((FXMainWindow *) x));
}
static void *_p_FXFrameTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *) ((FXFrame *) x));
}
static void *_p_FXIdTo_p_FXObject(void *x) {
    return (void *)((FXObject *)  ((FXId *) x));
}
static void *_p_FXPopupTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXShell *) ((FXPopup *) x));
}
static void *_p_FXAccelTableTo_p_FXObject(void *x) {
    return (void *)((FXObject *)  ((FXAccelTable *) x));
}
static void *_p_FXAppTo_p_FXObject(void *x) {
    return (void *)((FXObject *)  ((FXApp *) x));
}
static void *_p_FXIconDictTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXDict *) ((FXIconDict *) x));
}
static void *_p_FXWindowTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *) ((FXWindow *) x));
}
static void *_p_FXCompositeTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *) ((FXComposite *) x));
}
static void *_p_FXRootWindowTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *) ((FXRootWindow *) x));
}
static void *_p_FXTopWindowTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXShell *) ((FXTopWindow *) x));
}
static void *_p_FXMainWindowTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXShell *)(FXTopWindow *) ((FXMainWindow *) x));
}
static void *_p_FXFileDictTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXDict *) ((FXFileDict *) x));
}
static void *_p_FXDictTo_p_FXObject(void *x) {
    return (void *)((FXObject *)  ((FXDict *) x));
}
static void *_p_FXShellTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *) ((FXShell *) x));
}
static void *_p_FXStringDictTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXDict *) ((FXStringDict *) x));
}
static void *_p_FXRegistryTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXDict *)(FXSettings *) ((FXRegistry *) x));
}
static void *_p_FXCursorTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *) ((FXCursor *) x));
}
static void *_p_FXCURCursorTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXCursor *) ((FXCURCursor *) x));
}
static void *_p_FXGIFCursorTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXCursor *) ((FXGIFCursor *) x));
}
static void *_p_FXDrawableTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *) ((FXDrawable *) x));
}
static void *_p_FXDelegatorTo_p_FXObject(void *x) {
    return (void *)((FXObject *)  ((FXDelegator *) x));
}
static void *_p_FXFontTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *) ((FXFont *) x));
}
static void *_p_FXSettingsTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXDict *) ((FXSettings *) x));
}
static void *_p_FXVisualTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *) ((FXVisual *) x));
}
static void *_p_FXDocumentTo_p_FXObject(void *x) {
    return (void *)((FXObject *)  ((FXDocument *) x));
}
static void *_p_FXRecentFilesTo_p_FXObject(void *x) {
    return (void *)((FXObject *)  ((FXRecentFiles *) x));
}
static void *_p_FXDebugTargetTo_p_FXObject(void *x) {
    return (void *)((FXObject *)  ((FXDebugTarget *) x));
}
static void *_p_FXDataTargetTo_p_FXObject(void *x) {
    return (void *)((FXObject *)  ((FXDataTarget *) x));
}
static void *_p_FXCompositeTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *) ((FXComposite *) x));
}
static void *_p_FXShellTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *) ((FXShell *) x));
}
static void *_p_FXWindowTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *)  ((FXWindow *) x));
}
static void *_p_FXRootWindowTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *) ((FXRootWindow *) x));
}
static void *_p_FXPopupTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXShell *) ((FXPopup *) x));
}
static void *_p_FXTopWindowTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXShell *) ((FXTopWindow *) x));
}
static void *_p_FXMainWindowTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXShell *)(FXTopWindow *) ((FXMainWindow *) x));
}
static void *_p_FXFrameTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *) ((FXFrame *) x));
}
static void *_p_FXCURCursorTo_p_FXCursor(void *x) {
    return (void *)((FXCursor *)  ((FXCURCursor *) x));
}
static void *_p_FXGIFCursorTo_p_FXCursor(void *x) {
    return (void *)((FXCursor *)  ((FXGIFCursor *) x));
}
static void *_p_FXFileStreamTo_p_FXStream(void *x) {
    return (void *)((FXStream *)  ((FXFileStream *) x));
}
static void *_p_FXMemoryStreamTo_p_FXStream(void *x) {
    return (void *)((FXStream *)  ((FXMemoryStream *) x));
}
static void *_p_FXIconDictTo_p_FXDict(void *x) {
    return (void *)((FXDict *)  ((FXIconDict *) x));
}
static void *_p_FXFileDictTo_p_FXDict(void *x) {
    return (void *)((FXDict *)  ((FXFileDict *) x));
}
static void *_p_FXRegistryTo_p_FXDict(void *x) {
    return (void *)((FXDict *) (FXSettings *) ((FXRegistry *) x));
}
static void *_p_FXStringDictTo_p_FXDict(void *x) {
    return (void *)((FXDict *)  ((FXStringDict *) x));
}
static void *_p_FXSettingsTo_p_FXDict(void *x) {
    return (void *)((FXDict *)  ((FXSettings *) x));
}
static void *_p_FXFrameTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *) ((FXFrame *) x));
}
static void *_p_FXPopupTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXShell *) ((FXPopup *) x));
}
static void *_p_FXMainWindowTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXShell *)(FXTopWindow *) ((FXMainWindow *) x));
}
static void *_p_FXTopWindowTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXShell *) ((FXTopWindow *) x));
}
static void *_p_FXRootWindowTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *) ((FXRootWindow *) x));
}
static void *_p_FXWindowTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *) ((FXWindow *) x));
}
static void *_p_FXCompositeTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *) ((FXComposite *) x));
}
static void *_p_FXShellTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *) ((FXShell *) x));
}
static void *_p_FXGIFCursorTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXCursor *) ((FXGIFCursor *) x));
}
static void *_p_FXCURCursorTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXCursor *) ((FXCURCursor *) x));
}
static void *_p_FXCursorTo_p_FXId(void *x) {
    return (void *)((FXId *)  ((FXCursor *) x));
}
static void *_p_FXDrawableTo_p_FXId(void *x) {
    return (void *)((FXId *)  ((FXDrawable *) x));
}
static void *_p_FXFontTo_p_FXId(void *x) {
    return (void *)((FXId *)  ((FXFont *) x));
}
static void *_p_FXVisualTo_p_FXId(void *x) {
    return (void *)((FXId *)  ((FXVisual *) x));
}
static swig_type_info _swigt__p_FXDict[] = {{"_p_FXDict", 0, "FXDict *", 0, 0, 0, 0},{"_p_FXDict", 0, 0, 0, 0, 0, 0},{"_p_FXIconDict", _p_FXIconDictTo_p_FXDict, 0, 0, 0, 0, 0},{"_p_FXFileDict", _p_FXFileDictTo_p_FXDict, 0, 0, 0, 0, 0},{"_p_FXRegistry", _p_FXRegistryTo_p_FXDict, 0, 0, 0, 0, 0},{"_p_FXStringDict", _p_FXStringDictTo_p_FXDict, 0, 0, 0, 0, 0},{"_p_FXSettings", _p_FXSettingsTo_p_FXDict, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXSettings[] = {{"_p_FXSettings", 0, "FXSettings *", 0, 0, 0, 0},{"_p_FXRegistry", _p_FXRegistryTo_p_FXSettings, 0, 0, 0, 0, 0},{"_p_FXSettings", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXAccelTable[] = {{"_p_FXAccelTable", 0, "FXAccelTable *", 0, 0, 0, 0},{"_p_FXAccelTable", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXuchar[] = {{"_p_FXuchar", 0, "unsigned char const *|FXuchar const *", 0, 0, 0, 0},{"_p_FXuchar", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXComposite[] = {{"_p_FXComposite", 0, "FXComposite *", 0, 0, 0, 0},{"_p_FXComposite", 0, 0, 0, 0, 0, 0},{"_p_FXShell", _p_FXShellTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXPopup", _p_FXPopupTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXTopWindow", _p_FXTopWindowTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXMainWindow", _p_FXMainWindowTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXRootWindow", _p_FXRootWindowTo_p_FXComposite, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXRegistry[] = {{"_p_FXRegistry", 0, "FXRegistry *", 0, 0, 0, 0},{"_p_FXRegistry", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXId[] = {{"_p_FXId", 0, "FXId *", 0, 0, 0, 0},{"_p_FXFrame", _p_FXFrameTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXPopup", _p_FXPopupTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXRootWindow", _p_FXRootWindowTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXMainWindow", _p_FXMainWindowTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXTopWindow", _p_FXTopWindowTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXWindow", _p_FXWindowTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXComposite", _p_FXCompositeTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXFont", _p_FXFontTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXId", 0, 0, 0, 0, 0, 0},{"_p_FXShell", _p_FXShellTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXGIFCursor", _p_FXGIFCursorTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXCURCursor", _p_FXCURCursorTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXCursor", _p_FXCursorTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXDrawable", _p_FXDrawableTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXVisual", _p_FXVisualTo_p_FXId, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXIconDict[] = {{"_p_FXIconDict", 0, "FXIconDict *", 0, 0, 0, 0},{"_p_FXIconDict", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXShell[] = {{"_p_FXShell", 0, "FXShell *", 0, 0, 0, 0},{"_p_FXShell", 0, 0, 0, 0, 0, 0},{"_p_FXPopup", _p_FXPopupTo_p_FXShell, 0, 0, 0, 0, 0},{"_p_FXTopWindow", _p_FXTopWindowTo_p_FXShell, 0, 0, 0, 0, 0},{"_p_FXMainWindow", _p_FXMainWindowTo_p_FXShell, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXPopup[] = {{"_p_FXPopup", 0, "FXPopup *", 0, 0, 0, 0},{"_p_FXPopup", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXTimer[] = {{"_p_FXTimer", 0, "FXTimer *", 0, 0, 0, 0},{"_p_FXTimer", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXRootWindow[] = {{"_p_FXRootWindow", 0, "FXRootWindow *", 0, 0, 0, 0},{"_p_FXRootWindow", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXWindow[] = {{"_p_FXWindow", 0, "FXWindow *", 0, 0, 0, 0},{"_p_FXComposite", _p_FXCompositeTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXShell", _p_FXShellTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXWindow", 0, 0, 0, 0, 0, 0},{"_p_FXPopup", _p_FXPopupTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXTopWindow", _p_FXTopWindowTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXMainWindow", _p_FXMainWindowTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXRootWindow", _p_FXRootWindowTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXFrame", _p_FXFrameTo_p_FXWindow, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXTopWindow[] = {{"_p_FXTopWindow", 0, "FXTopWindow *", 0, 0, 0, 0},{"_p_FXTopWindow", 0, 0, 0, 0, 0, 0},{"_p_FXMainWindow", _p_FXMainWindowTo_p_FXTopWindow, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_void[] = {{"_p_void", 0, "void *", 0, 0, 0, 0},{"_p_void", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXDocument[] = {{"_p_FXDocument", 0, "FXDocument *", 0, 0, 0, 0},{"_p_FXDocument", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXRecentFiles[] = {{"_p_FXRecentFiles", 0, "FXRecentFiles *", 0, 0, 0, 0},{"_p_FXRecentFiles", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXMainWindow[] = {{"_p_FXMainWindow", 0, "FXMainWindow *", 0, 0, 0, 0},{"_p_FXMainWindow", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXIcon[] = {{"_p_FXIcon", 0, "FXIcon *", 0, 0, 0, 0},{"_p_FXIcon", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXID[] = {{"_p_FXID", 0, "FXID *", 0, 0, 0, 0},{"_p_FXID", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXEvent[] = {{"_p_FXEvent", 0, "FXEvent *", 0, 0, 0, 0},{"_p_FXEvent", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXObject[] = {{"_p_FXObject", 0, "FXObject *", 0, 0, 0, 0},{"_p_FXFrame", _p_FXFrameTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXObject", 0, 0, 0, 0, 0, 0},{"_p_FXPopup", _p_FXPopupTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXAccelTable", _p_FXAccelTableTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXIconDict", _p_FXIconDictTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXDict", _p_FXDictTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXWindow", _p_FXWindowTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXRootWindow", _p_FXRootWindowTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXTopWindow", _p_FXTopWindowTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXMainWindow", _p_FXMainWindowTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXComposite", _p_FXCompositeTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXFileDict", _p_FXFileDictTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXId", _p_FXIdTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXFont", _p_FXFontTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXShell", _p_FXShellTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXStringDict", _p_FXStringDictTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXRegistry", _p_FXRegistryTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXCursor", _p_FXCursorTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXCURCursor", _p_FXCURCursorTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXGIFCursor", _p_FXGIFCursorTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXDrawable", _p_FXDrawableTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXDelegator", _p_FXDelegatorTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXSettings", _p_FXSettingsTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXVisual", _p_FXVisualTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXApp", _p_FXAppTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXDocument", _p_FXDocumentTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXRecentFiles", _p_FXRecentFilesTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXDebugTarget", _p_FXDebugTargetTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXDataTarget", _p_FXDataTargetTo_p_FXObject, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXStringDict[] = {{"_p_FXStringDict", 0, "FXStringDict *", 0, 0, 0, 0},{"_p_FXStringDict", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXRectangle[] = {{"_p_FXRectangle", 0, "FXRectangle *", 0, 0, 0, 0},{"_p_FXRectangle", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXString[] = {{"_p_FXString", 0, "FXString *", 0, 0, 0, 0},{"_p_FXString", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXPoint[] = {{"_p_FXPoint", 0, "FXPoint *", 0, 0, 0, 0},{"_p_FXPoint", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXFileDict[] = {{"_p_FXFileDict", 0, "FXFileDict *", 0, 0, 0, 0},{"_p_FXFileDict", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXDebugTarget[] = {{"_p_FXDebugTarget", 0, "FXDebugTarget *", 0, 0, 0, 0},{"_p_FXDebugTarget", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXDataTarget[] = {{"_p_FXDataTarget", 0, "FXDataTarget *", 0, 0, 0, 0},{"_p_FXDataTarget", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXDelegator[] = {{"_p_FXDelegator", 0, "FXDelegator *", 0, 0, 0, 0},{"_p_FXDelegator", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXDrawable[] = {{"_p_FXDrawable", 0, "FXDrawable *", 0, 0, 0, 0},{"_p_FXComposite", _p_FXCompositeTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXShell", _p_FXShellTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXPopup", _p_FXPopupTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXTopWindow", _p_FXTopWindowTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXMainWindow", _p_FXMainWindowTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXRootWindow", _p_FXRootWindowTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXWindow", _p_FXWindowTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXDrawable", 0, 0, 0, 0, 0, 0},{"_p_FXFrame", _p_FXFrameTo_p_FXDrawable, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXCursor[] = {{"_p_FXCursor", 0, "FXCursor *", 0, 0, 0, 0},{"_p_FXCursor", 0, 0, 0, 0, 0, 0},{"_p_FXCURCursor", _p_FXCURCursorTo_p_FXCursor, 0, 0, 0, 0, 0},{"_p_FXGIFCursor", _p_FXGIFCursorTo_p_FXCursor, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXCURCursor[] = {{"_p_FXCURCursor", 0, "FXCURCursor *", 0, 0, 0, 0},{"_p_FXCURCursor", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXGIFCursor[] = {{"_p_FXGIFCursor", 0, "FXGIFCursor *", 0, 0, 0, 0},{"_p_FXGIFCursor", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXStream[] = {{"_p_FXStream", 0, "FXStream *", 0, 0, 0, 0},{"_p_FXFileStream", _p_FXFileStreamTo_p_FXStream, 0, 0, 0, 0, 0},{"_p_FXMemoryStream", _p_FXMemoryStreamTo_p_FXStream, 0, 0, 0, 0, 0},{"_p_FXStream", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXFontDesc[] = {{"_p_FXFontDesc", 0, "FXFontDesc *", 0, 0, 0, 0},{"_p_FXFontDesc", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXApp[] = {{"_p_FXApp", 0, "FXApp *", 0, 0, 0, 0},{"_p_FXApp", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXChore[] = {{"_p_FXChore", 0, "FXChore *", 0, 0, 0, 0},{"_p_FXChore", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXRegion[] = {{"_p_FXRegion", 0, "FXRegion *", 0, 0, 0, 0},{"_p_FXRegion", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXColor[] = {{"_p_FXColor", 0, "unsigned int const *|FXColor const *", 0, 0, 0, 0},{"_p_FXuint", 0, 0, 0, 0, 0, 0},{"_p_FXColor", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXSize[] = {{"_p_FXSize", 0, "FXSize *", 0, 0, 0, 0},{"_p_FXSize", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_p_FXchar[] = {{"_p_p_FXchar", 0, "char const *const *|FXchar const *const *", 0, 0, 0, 0},{"_p_p_FXchar", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXFont[] = {{"_p_FXFont", 0, "FXFont *", 0, 0, 0, 0},{"_p_FXFont", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXchar[] = {{"_p_FXchar", 0, "char [104]|FXchar [104]", 0, 0, 0, 0},{"_p_FXchar", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXFrame[] = {{"_p_FXFrame", 0, "FXFrame *", 0, 0, 0, 0},{"_p_FXFrame", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXFileAssoc[] = {{"_p_FXFileAssoc", 0, "FXFileAssoc *", 0, 0, 0, 0},{"_p_FXFileAssoc", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXVisual[] = {{"_p_FXVisual", 0, "FXVisual *", 0, 0, 0, 0},{"_p_FXVisual", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXuint[] = {{"_p_FXuint", 0, "unsigned int *|FXuint *", 0, 0, 0, 0},{"_p_FXuint", 0, 0, 0, 0, 0, 0},{"_p_FXColor", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXFileStream[] = {{"_p_FXFileStream", 0, "FXFileStream *", 0, 0, 0, 0},{"_p_FXFileStream", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXMemoryStream[] = {{"_p_FXMemoryStream", 0, "FXMemoryStream *", 0, 0, 0, 0},{"_p_FXMemoryStream", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};

static swig_type_info *swig_types_initial[] = {
_swigt__p_FXDict, 
_swigt__p_FXSettings, 
_swigt__p_FXAccelTable, 
_swigt__p_FXuchar, 
_swigt__p_FXComposite, 
_swigt__p_FXRegistry, 
_swigt__p_FXId, 
_swigt__p_FXIconDict, 
_swigt__p_FXShell, 
_swigt__p_FXPopup, 
_swigt__p_FXTimer, 
_swigt__p_FXRootWindow, 
_swigt__p_FXWindow, 
_swigt__p_FXTopWindow, 
_swigt__p_void, 
_swigt__p_FXDocument, 
_swigt__p_FXRecentFiles, 
_swigt__p_FXMainWindow, 
_swigt__p_FXIcon, 
_swigt__p_FXID, 
_swigt__p_FXEvent, 
_swigt__p_FXObject, 
_swigt__p_FXStringDict, 
_swigt__p_FXRectangle, 
_swigt__p_FXString, 
_swigt__p_FXPoint, 
_swigt__p_FXFileDict, 
_swigt__p_FXDebugTarget, 
_swigt__p_FXDataTarget, 
_swigt__p_FXDelegator, 
_swigt__p_FXDrawable, 
_swigt__p_FXCursor, 
_swigt__p_FXCURCursor, 
_swigt__p_FXGIFCursor, 
_swigt__p_FXStream, 
_swigt__p_FXFontDesc, 
_swigt__p_FXApp, 
_swigt__p_FXChore, 
_swigt__p_FXRegion, 
_swigt__p_FXColor, 
_swigt__p_FXSize, 
_swigt__p_p_FXchar, 
_swigt__p_FXFont, 
_swigt__p_FXchar, 
_swigt__p_FXFrame, 
_swigt__p_FXFileAssoc, 
_swigt__p_FXVisual, 
_swigt__p_FXuint, 
_swigt__p_FXFileStream, 
_swigt__p_FXMemoryStream, 
0
};


/* -------- TYPE CONVERSION AND EQUIVALENCE RULES (END) -------- */


#ifdef __cplusplus
extern "C"
#endif
SWIGEXPORT(void) Init_core(void) {
    int i;
    
    SWIG_InitRuntime();
    mFox = rb_define_module("Fox");
    
    for (i = 0; swig_types_initial[i]; i++) {
        swig_types[i] = SWIG_TypeRegister(swig_types_initial[i]);
        SWIG_define_class(swig_types[i]);
    }
    
    rb_define_module_function(mFox, "setIgnoreExceptions", VALUEFUNC(_wrap_setIgnoreExceptions), -1);
    rb_define_const(mFox,"TRUE", INT2NUM(1));
    rb_define_const(mFox,"FALSE", INT2NUM(0));
    rb_define_const(mFox,"MAYBE", INT2NUM(2));
    rb_define_const(mFox,"NULL", INT2NUM(0));
    rb_define_const(mFox,"SEL_NONE", INT2NUM(SEL_NONE));
    rb_define_const(mFox,"SEL_KEYPRESS", INT2NUM(SEL_KEYPRESS));
    rb_define_const(mFox,"SEL_KEYRELEASE", INT2NUM(SEL_KEYRELEASE));
    rb_define_const(mFox,"SEL_LEFTBUTTONPRESS", INT2NUM(SEL_LEFTBUTTONPRESS));
    rb_define_const(mFox,"SEL_LEFTBUTTONRELEASE", INT2NUM(SEL_LEFTBUTTONRELEASE));
    rb_define_const(mFox,"SEL_MIDDLEBUTTONPRESS", INT2NUM(SEL_MIDDLEBUTTONPRESS));
    rb_define_const(mFox,"SEL_MIDDLEBUTTONRELEASE", INT2NUM(SEL_MIDDLEBUTTONRELEASE));
    rb_define_const(mFox,"SEL_RIGHTBUTTONPRESS", INT2NUM(SEL_RIGHTBUTTONPRESS));
    rb_define_const(mFox,"SEL_RIGHTBUTTONRELEASE", INT2NUM(SEL_RIGHTBUTTONRELEASE));
    rb_define_const(mFox,"SEL_MOTION", INT2NUM(SEL_MOTION));
    rb_define_const(mFox,"SEL_ENTER", INT2NUM(SEL_ENTER));
    rb_define_const(mFox,"SEL_LEAVE", INT2NUM(SEL_LEAVE));
    rb_define_const(mFox,"SEL_FOCUSIN", INT2NUM(SEL_FOCUSIN));
    rb_define_const(mFox,"SEL_FOCUSOUT", INT2NUM(SEL_FOCUSOUT));
    rb_define_const(mFox,"SEL_KEYMAP", INT2NUM(SEL_KEYMAP));
    rb_define_const(mFox,"SEL_UNGRABBED", INT2NUM(SEL_UNGRABBED));
    rb_define_const(mFox,"SEL_PAINT", INT2NUM(SEL_PAINT));
    rb_define_const(mFox,"SEL_CREATE", INT2NUM(SEL_CREATE));
    rb_define_const(mFox,"SEL_DESTROY", INT2NUM(SEL_DESTROY));
    rb_define_const(mFox,"SEL_UNMAP", INT2NUM(SEL_UNMAP));
    rb_define_const(mFox,"SEL_MAP", INT2NUM(SEL_MAP));
    rb_define_const(mFox,"SEL_CONFIGURE", INT2NUM(SEL_CONFIGURE));
    rb_define_const(mFox,"SEL_SELECTION_LOST", INT2NUM(SEL_SELECTION_LOST));
    rb_define_const(mFox,"SEL_SELECTION_GAINED", INT2NUM(SEL_SELECTION_GAINED));
    rb_define_const(mFox,"SEL_SELECTION_REQUEST", INT2NUM(SEL_SELECTION_REQUEST));
    rb_define_const(mFox,"SEL_RAISED", INT2NUM(SEL_RAISED));
    rb_define_const(mFox,"SEL_LOWERED", INT2NUM(SEL_LOWERED));
    rb_define_const(mFox,"SEL_CLOSE", INT2NUM(SEL_CLOSE));
    rb_define_const(mFox,"SEL_DELETE", INT2NUM(SEL_DELETE));
    rb_define_const(mFox,"SEL_MINIMIZE", INT2NUM(SEL_MINIMIZE));
    rb_define_const(mFox,"SEL_RESTORE", INT2NUM(SEL_RESTORE));
    rb_define_const(mFox,"SEL_MAXIMIZE", INT2NUM(SEL_MAXIMIZE));
    rb_define_const(mFox,"SEL_UPDATE", INT2NUM(SEL_UPDATE));
    rb_define_const(mFox,"SEL_COMMAND", INT2NUM(SEL_COMMAND));
    rb_define_const(mFox,"SEL_CLICKED", INT2NUM(SEL_CLICKED));
    rb_define_const(mFox,"SEL_DOUBLECLICKED", INT2NUM(SEL_DOUBLECLICKED));
    rb_define_const(mFox,"SEL_TRIPLECLICKED", INT2NUM(SEL_TRIPLECLICKED));
    rb_define_const(mFox,"SEL_MOUSEWHEEL", INT2NUM(SEL_MOUSEWHEEL));
    rb_define_const(mFox,"SEL_CHANGED", INT2NUM(SEL_CHANGED));
    rb_define_const(mFox,"SEL_VERIFY", INT2NUM(SEL_VERIFY));
    rb_define_const(mFox,"SEL_DESELECTED", INT2NUM(SEL_DESELECTED));
    rb_define_const(mFox,"SEL_SELECTED", INT2NUM(SEL_SELECTED));
    rb_define_const(mFox,"SEL_INSERTED", INT2NUM(SEL_INSERTED));
    rb_define_const(mFox,"SEL_REPLACED", INT2NUM(SEL_REPLACED));
    rb_define_const(mFox,"SEL_DELETED", INT2NUM(SEL_DELETED));
    rb_define_const(mFox,"SEL_OPENED", INT2NUM(SEL_OPENED));
    rb_define_const(mFox,"SEL_CLOSED", INT2NUM(SEL_CLOSED));
    rb_define_const(mFox,"SEL_EXPANDED", INT2NUM(SEL_EXPANDED));
    rb_define_const(mFox,"SEL_COLLAPSED", INT2NUM(SEL_COLLAPSED));
    rb_define_const(mFox,"SEL_BEGINDRAG", INT2NUM(SEL_BEGINDRAG));
    rb_define_const(mFox,"SEL_ENDDRAG", INT2NUM(SEL_ENDDRAG));
    rb_define_const(mFox,"SEL_DRAGGED", INT2NUM(SEL_DRAGGED));
    rb_define_const(mFox,"SEL_LASSOED", INT2NUM(SEL_LASSOED));
    rb_define_const(mFox,"SEL_TIMEOUT", INT2NUM(SEL_TIMEOUT));
    rb_define_const(mFox,"SEL_SIGNAL", INT2NUM(SEL_SIGNAL));
    rb_define_const(mFox,"SEL_CLIPBOARD_LOST", INT2NUM(SEL_CLIPBOARD_LOST));
    rb_define_const(mFox,"SEL_CLIPBOARD_GAINED", INT2NUM(SEL_CLIPBOARD_GAINED));
    rb_define_const(mFox,"SEL_CLIPBOARD_REQUEST", INT2NUM(SEL_CLIPBOARD_REQUEST));
    rb_define_const(mFox,"SEL_CHORE", INT2NUM(SEL_CHORE));
    rb_define_const(mFox,"SEL_FOCUS_SELF", INT2NUM(SEL_FOCUS_SELF));
    rb_define_const(mFox,"SEL_FOCUS_RIGHT", INT2NUM(SEL_FOCUS_RIGHT));
    rb_define_const(mFox,"SEL_FOCUS_LEFT", INT2NUM(SEL_FOCUS_LEFT));
    rb_define_const(mFox,"SEL_FOCUS_DOWN", INT2NUM(SEL_FOCUS_DOWN));
    rb_define_const(mFox,"SEL_FOCUS_UP", INT2NUM(SEL_FOCUS_UP));
    rb_define_const(mFox,"SEL_FOCUS_NEXT", INT2NUM(SEL_FOCUS_NEXT));
    rb_define_const(mFox,"SEL_FOCUS_PREV", INT2NUM(SEL_FOCUS_PREV));
    rb_define_const(mFox,"SEL_DND_ENTER", INT2NUM(SEL_DND_ENTER));
    rb_define_const(mFox,"SEL_DND_LEAVE", INT2NUM(SEL_DND_LEAVE));
    rb_define_const(mFox,"SEL_DND_DROP", INT2NUM(SEL_DND_DROP));
    rb_define_const(mFox,"SEL_DND_MOTION", INT2NUM(SEL_DND_MOTION));
    rb_define_const(mFox,"SEL_DND_REQUEST", INT2NUM(SEL_DND_REQUEST));
    rb_define_const(mFox,"SEL_IO_READ", INT2NUM(SEL_IO_READ));
    rb_define_const(mFox,"SEL_IO_WRITE", INT2NUM(SEL_IO_WRITE));
    rb_define_const(mFox,"SEL_IO_EXCEPT", INT2NUM(SEL_IO_EXCEPT));
    rb_define_const(mFox,"SEL_PICKED", INT2NUM(SEL_PICKED));
    rb_define_const(mFox,"SEL_LAST", INT2NUM(SEL_LAST));
    rb_define_const(mFox,"SHIFTMASK", INT2NUM(SHIFTMASK));
    rb_define_const(mFox,"CAPSLOCKMASK", INT2NUM(CAPSLOCKMASK));
    rb_define_const(mFox,"CONTROLMASK", INT2NUM(CONTROLMASK));
    rb_define_const(mFox,"ALTMASK", INT2NUM(ALTMASK));
    rb_define_const(mFox,"METAMASK", INT2NUM(METAMASK));
    rb_define_const(mFox,"NUMLOCKMASK", INT2NUM(NUMLOCKMASK));
    rb_define_const(mFox,"SCROLLLOCKMASK", INT2NUM(SCROLLLOCKMASK));
    rb_define_const(mFox,"LEFTBUTTONMASK", INT2NUM(LEFTBUTTONMASK));
    rb_define_const(mFox,"MIDDLEBUTTONMASK", INT2NUM(MIDDLEBUTTONMASK));
    rb_define_const(mFox,"RIGHTBUTTONMASK", INT2NUM(RIGHTBUTTONMASK));
    rb_define_const(mFox,"LEFTBUTTON", INT2NUM(LEFTBUTTON));
    rb_define_const(mFox,"MIDDLEBUTTON", INT2NUM(MIDDLEBUTTON));
    rb_define_const(mFox,"RIGHTBUTTON", INT2NUM(RIGHTBUTTON));
    rb_define_const(mFox,"CROSSINGNORMAL", INT2NUM(CROSSINGNORMAL));
    rb_define_const(mFox,"CROSSINGGRAB", INT2NUM(CROSSINGGRAB));
    rb_define_const(mFox,"CROSSINGUNGRAB", INT2NUM(CROSSINGUNGRAB));
    rb_define_const(mFox,"VISIBILITYTOTAL", INT2NUM(VISIBILITYTOTAL));
    rb_define_const(mFox,"VISIBILITYPARTIAL", INT2NUM(VISIBILITYPARTIAL));
    rb_define_const(mFox,"VISIBILITYNONE", INT2NUM(VISIBILITYNONE));
    rb_define_const(mFox,"FILEMATCH_FILE_NAME", INT2NUM(FILEMATCH_FILE_NAME));
    rb_define_const(mFox,"FILEMATCH_NOESCAPE", INT2NUM(FILEMATCH_NOESCAPE));
    rb_define_const(mFox,"FILEMATCH_PERIOD", INT2NUM(FILEMATCH_PERIOD));
    rb_define_const(mFox,"FILEMATCH_LEADING_DIR", INT2NUM(FILEMATCH_LEADING_DIR));
    rb_define_const(mFox,"FILEMATCH_CASEFOLD", INT2NUM(FILEMATCH_CASEFOLD));
    rb_define_const(mFox,"DRAG_REJECT", INT2NUM(DRAG_REJECT));
    rb_define_const(mFox,"DRAG_ACCEPT", INT2NUM(DRAG_ACCEPT));
    rb_define_const(mFox,"DRAG_COPY", INT2NUM(DRAG_COPY));
    rb_define_const(mFox,"DRAG_MOVE", INT2NUM(DRAG_MOVE));
    rb_define_const(mFox,"DRAG_LINK", INT2NUM(DRAG_LINK));
    rb_define_const(mFox,"DRAG_PRIVATE", INT2NUM(DRAG_PRIVATE));
    rb_define_const(mFox,"FROM_SELECTION", INT2NUM(FROM_SELECTION));
    rb_define_const(mFox,"FROM_CLIPBOARD", INT2NUM(FROM_CLIPBOARD));
    rb_define_const(mFox,"FROM_DRAGNDROP", INT2NUM(FROM_DRAGNDROP));
    rb_define_const(mFox,"EXP_NEVER", INT2NUM(EXP_NEVER));
    rb_define_const(mFox,"EXP_ALWAYS", INT2NUM(EXP_ALWAYS));
    rb_define_const(mFox,"EXP_AUTO", INT2NUM(EXP_AUTO));
    rb_define_const(mFox,"SEARCH_FORWARD", INT2NUM(SEARCH_FORWARD));
    rb_define_const(mFox,"SEARCH_BACKWARD", INT2NUM(SEARCH_BACKWARD));
    rb_define_const(mFox,"SEARCH_NOWRAP", INT2NUM(SEARCH_NOWRAP));
    rb_define_const(mFox,"SEARCH_WRAP", INT2NUM(SEARCH_WRAP));
    rb_define_const(mFox,"SEARCH_EXACT", INT2NUM(SEARCH_EXACT));
    rb_define_const(mFox,"SEARCH_IGNORECASE", INT2NUM(SEARCH_IGNORECASE));
    rb_define_const(mFox,"SEARCH_REGEX", INT2NUM(SEARCH_REGEX));
    rb_define_const(mFox,"SEARCH_PREFIX", INT2NUM(SEARCH_PREFIX));
    rb_define_module_function(mFox, "MKUINT", VALUEFUNC(_wrap_MKUINT), -1);
    rb_define_module_function(mFox, "FXSEL", VALUEFUNC(_wrap_FXSEL), -1);
    rb_define_module_function(mFox, "FXSELTYPE", VALUEFUNC(_wrap_FXSELTYPE), -1);
    rb_define_module_function(mFox, "FXSELID", VALUEFUNC(_wrap_FXSELID), -1);
    rb_define_module_function(mFox, "FXRGB", VALUEFUNC(_wrap_FXRGB), -1);
    rb_define_module_function(mFox, "FXRGBA", VALUEFUNC(_wrap_FXRGBA), -1);
    rb_define_module_function(mFox, "FXREDVAL", VALUEFUNC(_wrap_FXREDVAL), -1);
    rb_define_module_function(mFox, "FXGREENVAL", VALUEFUNC(_wrap_FXGREENVAL), -1);
    rb_define_module_function(mFox, "FXBLUEVAL", VALUEFUNC(_wrap_FXBLUEVAL), -1);
    rb_define_module_function(mFox, "FXALPHAVAL", VALUEFUNC(_wrap_FXALPHAVAL), -1);
    rb_define_module_function(mFox, "FXRGBACOMPVAL", VALUEFUNC(_wrap_FXRGBACOMPVAL), -1);
    rb_define_module_function(mFox, "fxsleep", VALUEFUNC(_wrap_fxsleep), -1);
    rb_define_module_function(mFox, "fxfilematch", VALUEFUNC(_wrap_fxfilematch), -1);
    rb_define_module_function(mFox, "makeHiliteColor", VALUEFUNC(_wrap_makeHiliteColor), -1);
    rb_define_module_function(mFox, "makeShadowColor", VALUEFUNC(_wrap_makeShadowColor), -1);
    rb_define_module_function(mFox, "fxcolorfromname", VALUEFUNC(_wrap_fxcolorfromname), -1);
    rb_define_module_function(mFox, "fxnamefromcolor", VALUEFUNC(_wrap_fxnamefromcolor), -1);
    rb_define_module_function(mFox, "fxrgb_to_hsv", VALUEFUNC(_wrap_fxrgb_to_hsv), -1);
    rb_define_module_function(mFox, "fxhsv_to_rgb", VALUEFUNC(_wrap_fxhsv_to_rgb), -1);
    rb_define_module_function(mFox, "fxisconsole", VALUEFUNC(_wrap_fxisconsole), -1);
    rb_define_module_function(mFox, "fxversion", VALUEFUNC(_wrap_fxversion), -1);
    rb_define_singleton_method(mFox, "fxTraceLevel", VALUEFUNC(fxTraceLevel_get), 0);
    rb_define_singleton_method(mFox, "fxTraceLevel=", VALUEFUNC(fxTraceLevel_set), 1);
    rb_define_module_function(mFox, "fxparseAccel", VALUEFUNC(_wrap_fxparseAccel), -1);
    rb_define_module_function(mFox, "fxparseHotKey", VALUEFUNC(_wrap_fxparseHotKey), -1);
    rb_define_module_function(mFox, "fxfindHotKey", VALUEFUNC(_wrap_fxfindHotKey), -1);
    rb_define_module_function(mFox, "fxstripHotKey", VALUEFUNC(_wrap_fxstripHotKey), -1);
    rb_define_const(mFox,"FXStreamDead", INT2NUM(FXStreamDead));
    rb_define_const(mFox,"FXStreamSave", INT2NUM(FXStreamSave));
    rb_define_const(mFox,"FXStreamLoad", INT2NUM(FXStreamLoad));
    rb_define_const(mFox,"FXStreamOK", INT2NUM(FXStreamOK));
    rb_define_const(mFox,"FXStreamEnd", INT2NUM(FXStreamEnd));
    rb_define_const(mFox,"FXStreamFull", INT2NUM(FXStreamFull));
    rb_define_const(mFox,"FXStreamNoWrite", INT2NUM(FXStreamNoWrite));
    rb_define_const(mFox,"FXStreamNoRead", INT2NUM(FXStreamNoRead));
    rb_define_const(mFox,"FXStreamFormat", INT2NUM(FXStreamFormat));
    rb_define_const(mFox,"FXStreamUnknown", INT2NUM(FXStreamUnknown));
    rb_define_const(mFox,"FXStreamAlloc", INT2NUM(FXStreamAlloc));
    rb_define_const(mFox,"FXStreamFailure", INT2NUM(FXStreamFailure));
    rb_define_const(mFox,"FXFromStart", INT2NUM(FXFromStart));
    rb_define_const(mFox,"FXFromCurrent", INT2NUM(FXFromCurrent));
    rb_define_const(mFox,"FXFromEnd", INT2NUM(FXFromEnd));
    
    cFXStream.klass = rb_define_class_under(mFox, "FXStream", rb_cObject);
    SWIG_TypeClientData(SWIGTYPE_p_FXStream, (void *) &cFXStream);
    rb_define_alloc_func(cFXStream.klass, _wrap_FXStream_allocate);
    rb_define_method(cFXStream.klass, "initialize", VALUEFUNC(_wrap_new_FXStream), -1);
    rb_define_method(cFXStream.klass, "open", VALUEFUNC(_wrap_FXStream_open), -1);
    rb_define_method(cFXStream.klass, "getSpace", VALUEFUNC(_wrap_FXStream_getSpace), -1);
    rb_define_method(cFXStream.klass, "setSpace", VALUEFUNC(_wrap_FXStream_setSpace), -1);
    rb_define_method(cFXStream.klass, "status", VALUEFUNC(_wrap_FXStream_status), -1);
    rb_define_method(cFXStream.klass, "eof?", VALUEFUNC(_wrap_FXStream_eofq___), -1);
    rb_define_method(cFXStream.klass, "setError", VALUEFUNC(_wrap_FXStream_setError), -1);
    rb_define_method(cFXStream.klass, "direction", VALUEFUNC(_wrap_FXStream_direction), -1);
    rb_define_method(cFXStream.klass, "container", VALUEFUNC(_wrap_FXStream_container), -1);
    rb_define_method(cFXStream.klass, "getPosition", VALUEFUNC(_wrap_FXStream_getPosition), -1);
    rb_define_method(cFXStream.klass, "swapBytes", VALUEFUNC(_wrap_FXStream_swapBytes), -1);
    rb_define_singleton_method(cFXStream.klass, "isLittleEndian", VALUEFUNC(_wrap_FXStream_isLittleEndian), -1);
    rb_define_method(cFXStream.klass, "close", VALUEFUNC(_wrap_FXStream_close), -1);
    rb_define_method(cFXStream.klass, "flush", VALUEFUNC(_wrap_FXStream_flush), -1);
    rb_define_method(cFXStream.klass, "setPosition", VALUEFUNC(_wrap_FXStream_setPosition), -1);
    cFXStream.mark = (void (*)(void *)) FXRbStream::markfunc;
    cFXStream.destroy = (void (*)(void *)) FXRbUnregisterRubyObj;
    
    cFXFileStream.klass = rb_define_class_under(mFox, "FXFileStream", ((swig_class *) SWIGTYPE_p_FXStream->clientdata)->klass);
    SWIG_TypeClientData(SWIGTYPE_p_FXFileStream, (void *) &cFXFileStream);
    rb_define_alloc_func(cFXFileStream.klass, _wrap_FXFileStream_allocate);
    rb_define_method(cFXFileStream.klass, "initialize", VALUEFUNC(_wrap_new_FXFileStream), -1);
    rb_define_method(cFXFileStream.klass, "open", VALUEFUNC(_wrap_FXFileStream_open), -1);
    rb_define_method(cFXFileStream.klass, "close", VALUEFUNC(_wrap_FXFileStream_close), -1);
    rb_define_method(cFXFileStream.klass, "flush", VALUEFUNC(_wrap_FXFileStream_flush), -1);
    rb_define_method(cFXFileStream.klass, "setPosition", VALUEFUNC(_wrap_FXFileStream_setPosition), -1);
    cFXFileStream.mark = (void (*)(void *)) FXRbFileStream::markfunc;
    cFXFileStream.destroy = (void (*)(void *)) FXRbUnregisterRubyObj;
    
    cFXMemoryStream.klass = rb_define_class_under(mFox, "FXMemoryStream", ((swig_class *) SWIGTYPE_p_FXStream->clientdata)->klass);
    SWIG_TypeClientData(SWIGTYPE_p_FXMemoryStream, (void *) &cFXMemoryStream);
    rb_define_alloc_func(cFXMemoryStream.klass, _wrap_FXMemoryStream_allocate);
    rb_define_method(cFXMemoryStream.klass, "initialize", VALUEFUNC(_wrap_new_FXMemoryStream), -1);
    rb_define_method(cFXMemoryStream.klass, "open", VALUEFUNC(_wrap_FXMemoryStream_open), -1);
    rb_define_method(cFXMemoryStream.klass, "takeBuffer", VALUEFUNC(_wrap_FXMemoryStream_takeBuffer), -1);
    rb_define_method(cFXMemoryStream.klass, "giveBuffer", VALUEFUNC(_wrap_FXMemoryStream_giveBuffer), -1);
    cFXMemoryStream.mark = (void (*)(void *)) FXRbMemoryStream::markfunc;
    cFXMemoryStream.destroy = (void (*)(void *)) FXRbUnregisterRubyObj;
    
    cFXSize.klass = rb_define_class_under(mFox, "FXSize", rb_cObject);
    SWIG_TypeClientData(SWIGTYPE_p_FXSize, (void *) &cFXSize);
    rb_define_alloc_func(cFXSize.klass, _wrap_FXSize_allocate);
    rb_define_method(cFXSize.klass, "initialize", VALUEFUNC(_wrap_new_FXSize), -1);
    rb_define_method(cFXSize.klass, "w=", VALUEFUNC(_wrap_FXSize_w_set), -1);
    rb_define_method(cFXSize.klass, "w", VALUEFUNC(_wrap_FXSize_w_get), -1);
    rb_define_method(cFXSize.klass, "h=", VALUEFUNC(_wrap_FXSize_h_set), -1);
    rb_define_method(cFXSize.klass, "h", VALUEFUNC(_wrap_FXSize_h_get), -1);
    rb_define_method(cFXSize.klass, "==", VALUEFUNC(_wrap_FXSize___eq__), -1);
    rb_define_method(cFXSize.klass, "-@", VALUEFUNC(_wrap_FXSize___neg__), -1);
    rb_define_method(cFXSize.klass, "+", VALUEFUNC(_wrap_FXSize___add__), -1);
    rb_define_method(cFXSize.klass, "-", VALUEFUNC(_wrap_FXSize___sub__), -1);
    rb_define_method(cFXSize.klass, "*", VALUEFUNC(_wrap_FXSize___mul__), -1);
    rb_define_method(cFXSize.klass, "/", VALUEFUNC(_wrap_FXSize___div__), -1);
    cFXSize.mark = 0;
    cFXSize.destroy = (void (*)(void *)) FXRbUnregisterRubyObj;
    
    cFXPoint.klass = rb_define_class_under(mFox, "FXPoint", rb_cObject);
    SWIG_TypeClientData(SWIGTYPE_p_FXPoint, (void *) &cFXPoint);
    rb_define_alloc_func(cFXPoint.klass, _wrap_FXPoint_allocate);
    rb_define_method(cFXPoint.klass, "initialize", VALUEFUNC(_wrap_new_FXPoint), -1);
    rb_define_method(cFXPoint.klass, "x=", VALUEFUNC(_wrap_FXPoint_x_set), -1);
    rb_define_method(cFXPoint.klass, "x", VALUEFUNC(_wrap_FXPoint_x_get), -1);
    rb_define_method(cFXPoint.klass, "y=", VALUEFUNC(_wrap_FXPoint_y_set), -1);
    rb_define_method(cFXPoint.klass, "y", VALUEFUNC(_wrap_FXPoint_y_get), -1);
    rb_define_method(cFXPoint.klass, "==", VALUEFUNC(_wrap_FXPoint___eq__), -1);
    rb_define_method(cFXPoint.klass, "-@", VALUEFUNC(_wrap_FXPoint___neg__), -1);
    rb_define_method(cFXPoint.klass, "+", VALUEFUNC(_wrap_FXPoint___add__), -1);
    rb_define_method(cFXPoint.klass, "-", VALUEFUNC(_wrap_FXPoint___sub__), -1);
    rb_define_method(cFXPoint.klass, "*", VALUEFUNC(_wrap_FXPoint___mul__), -1);
    rb_define_method(cFXPoint.klass, "/", VALUEFUNC(_wrap_FXPoint___div__), -1);
    cFXPoint.mark = 0;
    cFXPoint.destroy = (void (*)(void *)) FXRbUnregisterRubyObj;
    
    cFXRectangle.klass = rb_define_class_under(mFox, "FXRectangle", rb_cObject);
    SWIG_TypeClientData(SWIGTYPE_p_FXRectangle, (void *) &cFXRectangle);
    rb_define_alloc_func(cFXRectangle.klass, _wrap_FXRectangle_allocate);
    rb_define_method(cFXRectangle.klass, "initialize", VALUEFUNC(_wrap_new_FXRectangle), -1);
    rb_define_method(cFXRectangle.klass, "x=", VALUEFUNC(_wrap_FXRectangle_x_set), -1);
    rb_define_method(cFXRectangle.klass, "x", VALUEFUNC(_wrap_FXRectangle_x_get), -1);
    rb_define_method(cFXRectangle.klass, "y=", VALUEFUNC(_wrap_FXRectangle_y_set), -1);
    rb_define_method(cFXRectangle.klass, "y", VALUEFUNC(_wrap_FXRectangle_y_get), -1);
    rb_define_method(cFXRectangle.klass, "w=", VALUEFUNC(_wrap_FXRectangle_w_set), -1);
    rb_define_method(cFXRectangle.klass, "w", VALUEFUNC(_wrap_FXRectangle_w_get), -1);
    rb_define_method(cFXRectangle.klass, "h=", VALUEFUNC(_wrap_FXRectangle_h_set), -1);
    rb_define_method(cFXRectangle.klass, "h", VALUEFUNC(_wrap_FXRectangle_h_get), -1);
    rb_define_method(cFXRectangle.klass, "==", VALUEFUNC(_wrap_FXRectangle___eq__), -1);
    rb_define_method(cFXRectangle.klass, "contains?", VALUEFUNC(_wrap_FXRectangle_containsq___), -1);
    rb_define_method(cFXRectangle.klass, "overlaps?", VALUEFUNC(_wrap_FXRectangle_overlapsq___), -1);
    rb_define_method(cFXRectangle.klass, "move!", VALUEFUNC(_wrap_FXRectangle_moveN___), -1);
    rb_define_method(cFXRectangle.klass, "grow!", VALUEFUNC(_wrap_FXRectangle_growN___), -1);
    rb_define_method(cFXRectangle.klass, "shrink!", VALUEFUNC(_wrap_FXRectangle_shrinkN___), -1);
    rb_define_method(cFXRectangle.klass, "tl", VALUEFUNC(_wrap_FXRectangle_tl), -1);
    rb_define_method(cFXRectangle.klass, "tr", VALUEFUNC(_wrap_FXRectangle_tr), -1);
    rb_define_method(cFXRectangle.klass, "bl", VALUEFUNC(_wrap_FXRectangle_bl), -1);
    rb_define_method(cFXRectangle.klass, "br", VALUEFUNC(_wrap_FXRectangle_br), -1);
    rb_define_method(cFXRectangle.klass, "+", VALUEFUNC(_wrap_FXRectangle___add__), -1);
    rb_define_method(cFXRectangle.klass, "*", VALUEFUNC(_wrap_FXRectangle___mul__), -1);
    cFXRectangle.mark = 0;
    cFXRectangle.destroy = (void (*)(void *)) FXRbUnregisterRubyObj;
    
    cFXRegion.klass = rb_define_class_under(mFox, "FXRegion", rb_cObject);
    SWIG_TypeClientData(SWIGTYPE_p_FXRegion, (void *) &cFXRegion);
    rb_define_alloc_func(cFXRegion.klass, _wrap_FXRegion_allocate);
    rb_define_method(cFXRegion.klass, "initialize", VALUEFUNC(_wrap_new_FXRegion), -1);
    rb_define_method(cFXRegion.klass, "empty?", VALUEFUNC(_wrap_FXRegion_emptyq___), -1);
    rb_define_method(cFXRegion.klass, "contains?", VALUEFUNC(_wrap_FXRegion_containsq___), -1);
    rb_define_method(cFXRegion.klass, "bounds", VALUEFUNC(_wrap_FXRegion_bounds), -1);
    rb_define_method(cFXRegion.klass, "offset!", VALUEFUNC(_wrap_FXRegion_offsetN___), -1);
    rb_define_method(cFXRegion.klass, "+", VALUEFUNC(_wrap_FXRegion___add__), -1);
    rb_define_method(cFXRegion.klass, "*", VALUEFUNC(_wrap_FXRegion___mul__), -1);
    rb_define_method(cFXRegion.klass, "-", VALUEFUNC(_wrap_FXRegion___sub__), -1);
    rb_define_method(cFXRegion.klass, "^", VALUEFUNC(_wrap_FXRegion___xor__), -1);
    rb_define_method(cFXRegion.klass, "==", VALUEFUNC(_wrap_FXRegion___eq__), -1);
    rb_define_method(cFXRegion.klass, "reset", VALUEFUNC(_wrap_FXRegion_reset), -1);
    cFXRegion.mark = 0;
    cFXRegion.destroy = (void (*)(void *)) FXRbUnregisterRubyObj;
    rb_define_const(mFox,"MINKEY", INT2NUM(MINKEY));
    rb_define_const(mFox,"MAXKEY", INT2NUM(MAXKEY));
    rb_define_const(mFox,"MINTYPE", INT2NUM(MINTYPE));
    rb_define_const(mFox,"MAXTYPE", INT2NUM(MAXTYPE));
    
    cFXObject.klass = rb_define_class_under(mFox, "FXObject", rb_cObject);
    SWIG_TypeClientData(SWIGTYPE_p_FXObject, (void *) &cFXObject);
    rb_define_alloc_func(cFXObject.klass, _wrap_FXObject_allocate);
    rb_define_method(cFXObject.klass, "initialize", VALUEFUNC(_wrap_new_FXObject), -1);
    rb_define_method(cFXObject.klass, "handle", VALUEFUNC(_wrap_FXObject_handle), -1);
    rb_define_method(cFXObject.klass, "save", VALUEFUNC(_wrap_FXObject_save), -1);
    rb_define_method(cFXObject.klass, "load", VALUEFUNC(_wrap_FXObject_load), -1);
    cFXObject.mark = (void (*)(void *)) FXRbObject::markfunc;
    cFXObject.destroy = (void (*)(void *)) FXRbObject::freefunc;
    
    SWIGTYPE_p_FXObject->dcast = (swig_dycast_func) FXObject_dynamic_cast;
    
    
    cFXAccelTable.klass = rb_define_class_under(mFox, "FXAccelTable", ((swig_class *) SWIGTYPE_p_FXObject->clientdata)->klass);
    SWIG_TypeClientData(SWIGTYPE_p_FXAccelTable, (void *) &cFXAccelTable);
    rb_define_alloc_func(cFXAccelTable.klass, _wrap_FXAccelTable_allocate);
    rb_define_method(cFXAccelTable.klass, "initialize", VALUEFUNC(_wrap_new_FXAccelTable), -1);
    rb_define_method(cFXAccelTable.klass, "onKeyPress", VALUEFUNC(_wrap_FXAccelTable_onKeyPress), -1);
    rb_define_method(cFXAccelTable.klass, "onKeyRelease", VALUEFUNC(_wrap_FXAccelTable_onKeyRelease), -1);
    rb_define_method(cFXAccelTable.klass, "addAccel", VALUEFUNC(_wrap_FXAccelTable_addAccel), -1);
    rb_define_method(cFXAccelTable.klass, "removeAccel", VALUEFUNC(_wrap_FXAccelTable_removeAccel), -1);
    rb_define_method(cFXAccelTable.klass, "hasAccel", VALUEFUNC(_wrap_FXAccelTable_hasAccel), -1);
    rb_define_method(cFXAccelTable.klass, "targetOfAccel", VALUEFUNC(_wrap_FXAccelTable_targetOfAccel), -1);
    rb_define_method(cFXAccelTable.klass, "save", VALUEFUNC(_wrap_FXAccelTable_save), -1);
    rb_define_method(cFXAccelTable.klass, "load", VALUEFUNC(_wrap_FXAccelTable_load), -1);
    cFXAccelTable.mark = (void (*)(void *)) FXRbAccelTable::markfunc;
    cFXAccelTable.destroy = (void (*)(void *)) FXRbObject::freefunc;
    rb_define_const(mFox,"INPUT_NONE", INT2NUM(INPUT_NONE));
    rb_define_const(mFox,"INPUT_READ", INT2NUM(INPUT_READ));
    rb_define_const(mFox,"INPUT_WRITE", INT2NUM(INPUT_WRITE));
    rb_define_const(mFox,"INPUT_EXCEPT", INT2NUM(INPUT_EXCEPT));
    rb_define_const(mFox,"MODAL_FOR_NONE", INT2NUM(MODAL_FOR_NONE));
    rb_define_const(mFox,"MODAL_FOR_WINDOW", INT2NUM(MODAL_FOR_WINDOW));
    rb_define_const(mFox,"MODAL_FOR_POPUP", INT2NUM(MODAL_FOR_POPUP));
    rb_define_const(mFox,"DEF_ARROW_CURSOR", INT2NUM(DEF_ARROW_CURSOR));
    rb_define_const(mFox,"DEF_RARROW_CURSOR", INT2NUM(DEF_RARROW_CURSOR));
    rb_define_const(mFox,"DEF_TEXT_CURSOR", INT2NUM(DEF_TEXT_CURSOR));
    rb_define_const(mFox,"DEF_HSPLIT_CURSOR", INT2NUM(DEF_HSPLIT_CURSOR));
    rb_define_const(mFox,"DEF_VSPLIT_CURSOR", INT2NUM(DEF_VSPLIT_CURSOR));
    rb_define_const(mFox,"DEF_XSPLIT_CURSOR", INT2NUM(DEF_XSPLIT_CURSOR));
    rb_define_const(mFox,"DEF_SWATCH_CURSOR", INT2NUM(DEF_SWATCH_CURSOR));
    rb_define_const(mFox,"DEF_MOVE_CURSOR", INT2NUM(DEF_MOVE_CURSOR));
    rb_define_const(mFox,"DEF_DRAGH_CURSOR", INT2NUM(DEF_DRAGH_CURSOR));
    rb_define_const(mFox,"DEF_DRAGV_CURSOR", INT2NUM(DEF_DRAGV_CURSOR));
    rb_define_const(mFox,"DEF_DRAGTL_CURSOR", INT2NUM(DEF_DRAGTL_CURSOR));
    rb_define_const(mFox,"DEF_DRAGBR_CURSOR", INT2NUM(DEF_DRAGBR_CURSOR));
    rb_define_const(mFox,"DEF_DRAGTR_CURSOR", INT2NUM(DEF_DRAGTR_CURSOR));
    rb_define_const(mFox,"DEF_DRAGBL_CURSOR", INT2NUM(DEF_DRAGBL_CURSOR));
    rb_define_const(mFox,"DEF_DNDSTOP_CURSOR", INT2NUM(DEF_DNDSTOP_CURSOR));
    rb_define_const(mFox,"DEF_DNDCOPY_CURSOR", INT2NUM(DEF_DNDCOPY_CURSOR));
    rb_define_const(mFox,"DEF_DNDMOVE_CURSOR", INT2NUM(DEF_DNDMOVE_CURSOR));
    rb_define_const(mFox,"DEF_DNDLINK_CURSOR", INT2NUM(DEF_DNDLINK_CURSOR));
    rb_define_const(mFox,"DEF_CROSSHAIR_CURSOR", INT2NUM(DEF_CROSSHAIR_CURSOR));
    rb_define_const(mFox,"DEF_CORNERNE_CURSOR", INT2NUM(DEF_CORNERNE_CURSOR));
    rb_define_const(mFox,"DEF_CORNERNW_CURSOR", INT2NUM(DEF_CORNERNW_CURSOR));
    rb_define_const(mFox,"DEF_CORNERSE_CURSOR", INT2NUM(DEF_CORNERSE_CURSOR));
    rb_define_const(mFox,"DEF_CORNERSW_CURSOR", INT2NUM(DEF_CORNERSW_CURSOR));
    rb_define_const(mFox,"DEF_HELP_CURSOR", INT2NUM(DEF_HELP_CURSOR));
    rb_define_const(mFox,"DEF_HAND_CURSOR", INT2NUM(DEF_HAND_CURSOR));
    rb_define_const(mFox,"DEF_ROTATE_CURSOR", INT2NUM(DEF_ROTATE_CURSOR));
    
    cFXEvent.klass = rb_define_class_under(mFox, "FXEvent", rb_cObject);
    SWIG_TypeClientData(SWIGTYPE_p_FXEvent, (void *) &cFXEvent);
    rb_define_alloc_func(cFXEvent.klass, _wrap_FXEvent_allocate);
    rb_define_method(cFXEvent.klass, "initialize", VALUEFUNC(_wrap_new_FXEvent), -1);
    rb_define_method(cFXEvent.klass, "type=", VALUEFUNC(_wrap_FXEvent_type_set), -1);
    rb_define_method(cFXEvent.klass, "type", VALUEFUNC(_wrap_FXEvent_type_get), -1);
    rb_define_method(cFXEvent.klass, "time=", VALUEFUNC(_wrap_FXEvent_time_set), -1);
    rb_define_method(cFXEvent.klass, "time", VALUEFUNC(_wrap_FXEvent_time_get), -1);
    rb_define_method(cFXEvent.klass, "win_x=", VALUEFUNC(_wrap_FXEvent_win_x_set), -1);
    rb_define_method(cFXEvent.klass, "win_x", VALUEFUNC(_wrap_FXEvent_win_x_get), -1);
    rb_define_method(cFXEvent.klass, "win_y=", VALUEFUNC(_wrap_FXEvent_win_y_set), -1);
    rb_define_method(cFXEvent.klass, "win_y", VALUEFUNC(_wrap_FXEvent_win_y_get), -1);
    rb_define_method(cFXEvent.klass, "root_x=", VALUEFUNC(_wrap_FXEvent_root_x_set), -1);
    rb_define_method(cFXEvent.klass, "root_x", VALUEFUNC(_wrap_FXEvent_root_x_get), -1);
    rb_define_method(cFXEvent.klass, "root_y=", VALUEFUNC(_wrap_FXEvent_root_y_set), -1);
    rb_define_method(cFXEvent.klass, "root_y", VALUEFUNC(_wrap_FXEvent_root_y_get), -1);
    rb_define_method(cFXEvent.klass, "state=", VALUEFUNC(_wrap_FXEvent_state_set), -1);
    rb_define_method(cFXEvent.klass, "state", VALUEFUNC(_wrap_FXEvent_state_get), -1);
    rb_define_method(cFXEvent.klass, "code=", VALUEFUNC(_wrap_FXEvent_code_set), -1);
    rb_define_method(cFXEvent.klass, "code", VALUEFUNC(_wrap_FXEvent_code_get), -1);
    rb_define_method(cFXEvent.klass, "text=", VALUEFUNC(_wrap_FXEvent_text_set), -1);
    rb_define_method(cFXEvent.klass, "text", VALUEFUNC(_wrap_FXEvent_text_get), -1);
    rb_define_method(cFXEvent.klass, "last_x=", VALUEFUNC(_wrap_FXEvent_last_x_set), -1);
    rb_define_method(cFXEvent.klass, "last_x", VALUEFUNC(_wrap_FXEvent_last_x_get), -1);
    rb_define_method(cFXEvent.klass, "last_y=", VALUEFUNC(_wrap_FXEvent_last_y_set), -1);
    rb_define_method(cFXEvent.klass, "last_y", VALUEFUNC(_wrap_FXEvent_last_y_get), -1);
    rb_define_method(cFXEvent.klass, "click_x=", VALUEFUNC(_wrap_FXEvent_click_x_set), -1);
    rb_define_method(cFXEvent.klass, "click_x", VALUEFUNC(_wrap_FXEvent_click_x_get), -1);
    rb_define_method(cFXEvent.klass, "click_y=", VALUEFUNC(_wrap_FXEvent_click_y_set), -1);
    rb_define_method(cFXEvent.klass, "click_y", VALUEFUNC(_wrap_FXEvent_click_y_get), -1);
    rb_define_method(cFXEvent.klass, "rootclick_x=", VALUEFUNC(_wrap_FXEvent_rootclick_x_set), -1);
    rb_define_method(cFXEvent.klass, "rootclick_x", VALUEFUNC(_wrap_FXEvent_rootclick_x_get), -1);
    rb_define_method(cFXEvent.klass, "rootclick_y=", VALUEFUNC(_wrap_FXEvent_rootclick_y_set), -1);
    rb_define_method(cFXEvent.klass, "rootclick_y", VALUEFUNC(_wrap_FXEvent_rootclick_y_get), -1);
    rb_define_method(cFXEvent.klass, "click_time=", VALUEFUNC(_wrap_FXEvent_click_time_set), -1);
    rb_define_method(cFXEvent.klass, "click_time", VALUEFUNC(_wrap_FXEvent_click_time_get), -1);
    rb_define_method(cFXEvent.klass, "click_button=", VALUEFUNC(_wrap_FXEvent_click_button_set), -1);
    rb_define_method(cFXEvent.klass, "click_button", VALUEFUNC(_wrap_FXEvent_click_button_get), -1);
    rb_define_method(cFXEvent.klass, "click_count=", VALUEFUNC(_wrap_FXEvent_click_count_set), -1);
    rb_define_method(cFXEvent.klass, "click_count", VALUEFUNC(_wrap_FXEvent_click_count_get), -1);
    rb_define_method(cFXEvent.klass, "moved=", VALUEFUNC(_wrap_FXEvent_moved_set), -1);
    rb_define_method(cFXEvent.klass, "moved", VALUEFUNC(_wrap_FXEvent_moved_get), -1);
    rb_define_method(cFXEvent.klass, "rect=", VALUEFUNC(_wrap_FXEvent_rect_set), -1);
    rb_define_method(cFXEvent.klass, "rect", VALUEFUNC(_wrap_FXEvent_rect_get), -1);
    rb_define_method(cFXEvent.klass, "synthetic=", VALUEFUNC(_wrap_FXEvent_synthetic_set), -1);
    rb_define_method(cFXEvent.klass, "synthetic", VALUEFUNC(_wrap_FXEvent_synthetic_get), -1);
    rb_define_method(cFXEvent.klass, "target=", VALUEFUNC(_wrap_FXEvent_target_set), -1);
    rb_define_method(cFXEvent.klass, "target", VALUEFUNC(_wrap_FXEvent_target_get), -1);
    cFXEvent.mark = 0;
    cFXEvent.destroy = (void (*)(void *)) FXRbUnregisterRubyObj;
    
    cFXChore.klass = rb_define_class_under(mFox, "FXChore", rb_cObject);
    SWIG_TypeClientData(SWIGTYPE_p_FXChore, (void *) &cFXChore);
    rb_undef_alloc_func(cFXChore.klass);
    cFXChore.mark = 0;
    cFXChore.destroy = (void (*)(void *)) FXRbUnregisterRubyObj;
    
    cFXTimer.klass = rb_define_class_under(mFox, "FXTimer", rb_cObject);
    SWIG_TypeClientData(SWIGTYPE_p_FXTimer, (void *) &cFXTimer);
    rb_undef_alloc_func(cFXTimer.klass);
    cFXTimer.mark = 0;
    cFXTimer.destroy = (void (*)(void *)) FXRbUnregisterRubyObj;
    
    cFXApp.klass = rb_define_class_under(mFox, "FXApp", ((swig_class *) SWIGTYPE_p_FXObject->clientdata)->klass);
    SWIG_TypeClientData(SWIGTYPE_p_FXApp, (void *) &cFXApp);
    rb_define_alloc_func(cFXApp.klass, _wrap_FXApp_allocate);
    rb_define_method(cFXApp.klass, "initialize", VALUEFUNC(_wrap_new_FXApp), -1);
    rb_define_method(cFXApp.klass, "onCmdQuit", VALUEFUNC(_wrap_FXApp_onCmdQuit), -1);
    rb_define_method(cFXApp.klass, "onCmdDump", VALUEFUNC(_wrap_FXApp_onCmdDump), -1);
    rb_define_const(cFXApp.klass,"ID_QUIT", INT2NUM(FXApp::ID_QUIT));
    rb_define_const(cFXApp.klass,"ID_DUMP", INT2NUM(FXApp::ID_DUMP));
    rb_define_const(cFXApp.klass,"ID_LAST", INT2NUM(FXApp::ID_LAST));
    rb_define_singleton_method(cFXApp.klass, "copyright", VALUEFUNC(_wrap_FXApp_copyright), -1);
    rb_define_method(cFXApp.klass, "getAppName", VALUEFUNC(_wrap_FXApp_getAppName), -1);
    rb_define_method(cFXApp.klass, "getVendorName", VALUEFUNC(_wrap_FXApp_getVendorName), -1);
    rb_define_method(cFXApp.klass, "openDisplay", VALUEFUNC(_wrap_FXApp_openDisplay), -1);
    rb_define_method(cFXApp.klass, "closeDisplay", VALUEFUNC(_wrap_FXApp_closeDisplay), -1);
    rb_define_method(cFXApp.klass, "getDisplay", VALUEFUNC(_wrap_FXApp_getDisplay), -1);
    rb_define_method(cFXApp.klass, "isInitialized", VALUEFUNC(_wrap_FXApp_isInitialized), -1);
    rb_define_method(cFXApp.klass, "getArgc", VALUEFUNC(_wrap_FXApp_getArgc), -1);
    rb_define_method(cFXApp.klass, "getArgv", VALUEFUNC(_wrap_FXApp_getArgv), -1);
    rb_define_method(cFXApp.klass, "getDefaultVisual", VALUEFUNC(_wrap_FXApp_getDefaultVisual), -1);
    rb_define_method(cFXApp.klass, "setDefaultVisual", VALUEFUNC(_wrap_FXApp_setDefaultVisual), -1);
    rb_define_method(cFXApp.klass, "getMonoVisual", VALUEFUNC(_wrap_FXApp_getMonoVisual), -1);
    rb_define_method(cFXApp.klass, "getRootWindow", VALUEFUNC(_wrap_FXApp_getRootWindow), -1);
    rb_define_method(cFXApp.klass, "getCursorWindow", VALUEFUNC(_wrap_FXApp_getCursorWindow), -1);
    rb_define_method(cFXApp.klass, "getFocusWindow", VALUEFUNC(_wrap_FXApp_getFocusWindow), -1);
    rb_define_method(cFXApp.klass, "getPopupWindow", VALUEFUNC(_wrap_FXApp_getPopupWindow), -1);
    rb_define_method(cFXApp.klass, "findWindowWithId", VALUEFUNC(_wrap_FXApp_findWindowWithId), -1);
    rb_define_method(cFXApp.klass, "findWindowAt", VALUEFUNC(_wrap_FXApp_findWindowAt), -1);
    rb_define_method(cFXApp.klass, "addTimeout", VALUEFUNC(_wrap_FXApp_addTimeout), -1);
    rb_define_method(cFXApp.klass, "removeTimeout", VALUEFUNC(_wrap_FXApp_removeTimeout), -1);
    rb_define_method(cFXApp.klass, "hasTimeout?", VALUEFUNC(_wrap_FXApp_hasTimeoutq___), -1);
    rb_define_method(cFXApp.klass, "remainingTimeout", VALUEFUNC(_wrap_FXApp_remainingTimeout), -1);
    rb_define_method(cFXApp.klass, "addChore", VALUEFUNC(_wrap_FXApp_addChore), -1);
    rb_define_method(cFXApp.klass, "removeChore", VALUEFUNC(_wrap_FXApp_removeChore), -1);
    rb_define_method(cFXApp.klass, "hasChore?", VALUEFUNC(_wrap_FXApp_hasChoreq___), -1);
    rb_define_method(cFXApp.klass, "addSignal", VALUEFUNC(_wrap_FXApp_addSignal), -1);
    rb_define_method(cFXApp.klass, "removeSignal", VALUEFUNC(_wrap_FXApp_removeSignal), -1);
    rb_define_method(cFXApp.klass, "addInput", VALUEFUNC(_wrap_FXApp_addInput), -1);
    rb_define_method(cFXApp.klass, "removeInput", VALUEFUNC(_wrap_FXApp_removeInput), -1);
    rb_define_method(cFXApp.klass, "peekEvent", VALUEFUNC(_wrap_FXApp_peekEvent), -1);
    rb_define_method(cFXApp.klass, "runOneEvent", VALUEFUNC(_wrap_FXApp_runOneEvent), -1);
    rb_define_method(cFXApp.klass, "run", VALUEFUNC(_wrap_FXApp_run), -1);
    rb_define_method(cFXApp.klass, "runUntil", VALUEFUNC(_wrap_FXApp_runUntil), -1);
    rb_define_method(cFXApp.klass, "runWhileEvents", VALUEFUNC(_wrap_FXApp_runWhileEvents), -1);
    rb_define_method(cFXApp.klass, "runModalWhileEvents", VALUEFUNC(_wrap_FXApp_runModalWhileEvents), -1);
    rb_define_method(cFXApp.klass, "runModal", VALUEFUNC(_wrap_FXApp_runModal), -1);
    rb_define_method(cFXApp.klass, "runModalFor", VALUEFUNC(_wrap_FXApp_runModalFor), -1);
    rb_define_method(cFXApp.klass, "runModalWhileShown", VALUEFUNC(_wrap_FXApp_runModalWhileShown), -1);
    rb_define_method(cFXApp.klass, "runPopup", VALUEFUNC(_wrap_FXApp_runPopup), -1);
    rb_define_method(cFXApp.klass, "isModal", VALUEFUNC(_wrap_FXApp_isModal), -1);
    rb_define_method(cFXApp.klass, "getModalWindow", VALUEFUNC(_wrap_FXApp_getModalWindow), -1);
    rb_define_method(cFXApp.klass, "getModality", VALUEFUNC(_wrap_FXApp_getModality), -1);
    rb_define_method(cFXApp.klass, "stop", VALUEFUNC(_wrap_FXApp_stop), -1);
    rb_define_method(cFXApp.klass, "stopModal", VALUEFUNC(_wrap_FXApp_stopModal), -1);
    rb_define_method(cFXApp.klass, "forceRefresh", VALUEFUNC(_wrap_FXApp_forceRefresh), -1);
    rb_define_method(cFXApp.klass, "refresh", VALUEFUNC(_wrap_FXApp_refresh), -1);
    rb_define_method(cFXApp.klass, "flush", VALUEFUNC(_wrap_FXApp_flush), -1);
    rb_define_method(cFXApp.klass, "repaint", VALUEFUNC(_wrap_FXApp_repaint), -1);
    rb_define_method(cFXApp.klass, "reg", VALUEFUNC(_wrap_FXApp_reg), -1);
    rb_define_method(cFXApp.klass, "registerDragType", VALUEFUNC(_wrap_FXApp_registerDragType), -1);
    rb_define_method(cFXApp.klass, "getDragTypeName", VALUEFUNC(_wrap_FXApp_getDragTypeName), -1);
    rb_define_method(cFXApp.klass, "getDragWindow", VALUEFUNC(_wrap_FXApp_getDragWindow), -1);
    rb_define_method(cFXApp.klass, "beep", VALUEFUNC(_wrap_FXApp_beep), -1);
    rb_define_singleton_method(cFXApp.klass, "instance", VALUEFUNC(_wrap_FXApp_instance), -1);
    rb_define_method(cFXApp.klass, "setNormalFont", VALUEFUNC(_wrap_FXApp_setNormalFont), -1);
    rb_define_method(cFXApp.klass, "getNormalFont", VALUEFUNC(_wrap_FXApp_getNormalFont), -1);
    rb_define_method(cFXApp.klass, "beginWaitCursor", VALUEFUNC(_wrap_FXApp_beginWaitCursor), -1);
    rb_define_method(cFXApp.klass, "endWaitCursor", VALUEFUNC(_wrap_FXApp_endWaitCursor), -1);
    rb_define_method(cFXApp.klass, "setWaitCursor", VALUEFUNC(_wrap_FXApp_setWaitCursor), -1);
    rb_define_method(cFXApp.klass, "getWaitCursor", VALUEFUNC(_wrap_FXApp_getWaitCursor), -1);
    rb_define_method(cFXApp.klass, "getDefaultCursor", VALUEFUNC(_wrap_FXApp_getDefaultCursor), -1);
    rb_define_method(cFXApp.klass, "setDefaultCursor", VALUEFUNC(_wrap_FXApp_setDefaultCursor), -1);
    rb_define_method(cFXApp.klass, "getTypingSpeed", VALUEFUNC(_wrap_FXApp_getTypingSpeed), -1);
    rb_define_method(cFXApp.klass, "getClickSpeed", VALUEFUNC(_wrap_FXApp_getClickSpeed), -1);
    rb_define_method(cFXApp.klass, "getScrollSpeed", VALUEFUNC(_wrap_FXApp_getScrollSpeed), -1);
    rb_define_method(cFXApp.klass, "getScrollDelay", VALUEFUNC(_wrap_FXApp_getScrollDelay), -1);
    rb_define_method(cFXApp.klass, "getBlinkSpeed", VALUEFUNC(_wrap_FXApp_getBlinkSpeed), -1);
    rb_define_method(cFXApp.klass, "getAnimSpeed", VALUEFUNC(_wrap_FXApp_getAnimSpeed), -1);
    rb_define_method(cFXApp.klass, "getMenuPause", VALUEFUNC(_wrap_FXApp_getMenuPause), -1);
    rb_define_method(cFXApp.klass, "getTooltipPause", VALUEFUNC(_wrap_FXApp_getTooltipPause), -1);
    rb_define_method(cFXApp.klass, "getTooltipTime", VALUEFUNC(_wrap_FXApp_getTooltipTime), -1);
    rb_define_method(cFXApp.klass, "getDragDelta", VALUEFUNC(_wrap_FXApp_getDragDelta), -1);
    rb_define_method(cFXApp.klass, "getWheelLines", VALUEFUNC(_wrap_FXApp_getWheelLines), -1);
    rb_define_method(cFXApp.klass, "setTypingSpeed", VALUEFUNC(_wrap_FXApp_setTypingSpeed), -1);
    rb_define_method(cFXApp.klass, "setClickSpeed", VALUEFUNC(_wrap_FXApp_setClickSpeed), -1);
    rb_define_method(cFXApp.klass, "setScrollSpeed", VALUEFUNC(_wrap_FXApp_setScrollSpeed), -1);
    rb_define_method(cFXApp.klass, "setScrollDelay", VALUEFUNC(_wrap_FXApp_setScrollDelay), -1);
    rb_define_method(cFXApp.klass, "setBlinkSpeed", VALUEFUNC(_wrap_FXApp_setBlinkSpeed), -1);
    rb_define_method(cFXApp.klass, "setAnimSpeed", VALUEFUNC(_wrap_FXApp_setAnimSpeed), -1);
    rb_define_method(cFXApp.klass, "setMenuPause", VALUEFUNC(_wrap_FXApp_setMenuPause), -1);
    rb_define_method(cFXApp.klass, "setTooltipPause", VALUEFUNC(_wrap_FXApp_setTooltipPause), -1);
    rb_define_method(cFXApp.klass, "setTooltipTime", VALUEFUNC(_wrap_FXApp_setTooltipTime), -1);
    rb_define_method(cFXApp.klass, "setDragDelta", VALUEFUNC(_wrap_FXApp_setDragDelta), -1);
    rb_define_method(cFXApp.klass, "setWheelLines", VALUEFUNC(_wrap_FXApp_setWheelLines), -1);
    rb_define_method(cFXApp.klass, "getBorderColor", VALUEFUNC(_wrap_FXApp_getBorderColor), -1);
    rb_define_method(cFXApp.klass, "getBaseColor", VALUEFUNC(_wrap_FXApp_getBaseColor), -1);
    rb_define_method(cFXApp.klass, "getHiliteColor", VALUEFUNC(_wrap_FXApp_getHiliteColor), -1);
    rb_define_method(cFXApp.klass, "getShadowColor", VALUEFUNC(_wrap_FXApp_getShadowColor), -1);
    rb_define_method(cFXApp.klass, "getBackColor", VALUEFUNC(_wrap_FXApp_getBackColor), -1);
    rb_define_method(cFXApp.klass, "getForeColor", VALUEFUNC(_wrap_FXApp_getForeColor), -1);
    rb_define_method(cFXApp.klass, "getSelforeColor", VALUEFUNC(_wrap_FXApp_getSelforeColor), -1);
    rb_define_method(cFXApp.klass, "getSelbackColor", VALUEFUNC(_wrap_FXApp_getSelbackColor), -1);
    rb_define_method(cFXApp.klass, "getTipforeColor", VALUEFUNC(_wrap_FXApp_getTipforeColor), -1);
    rb_define_method(cFXApp.klass, "getTipbackColor", VALUEFUNC(_wrap_FXApp_getTipbackColor), -1);
    rb_define_method(cFXApp.klass, "setBorderColor", VALUEFUNC(_wrap_FXApp_setBorderColor), -1);
    rb_define_method(cFXApp.klass, "setBaseColor", VALUEFUNC(_wrap_FXApp_setBaseColor), -1);
    rb_define_method(cFXApp.klass, "setHiliteColor", VALUEFUNC(_wrap_FXApp_setHiliteColor), -1);
    rb_define_method(cFXApp.klass, "setShadowColor", VALUEFUNC(_wrap_FXApp_setShadowColor), -1);
    rb_define_method(cFXApp.klass, "setBackColor", VALUEFUNC(_wrap_FXApp_setBackColor), -1);
    rb_define_method(cFXApp.klass, "setForeColor", VALUEFUNC(_wrap_FXApp_setForeColor), -1);
    rb_define_method(cFXApp.klass, "setSelforeColor", VALUEFUNC(_wrap_FXApp_setSelforeColor), -1);
    rb_define_method(cFXApp.klass, "setSelbackColor", VALUEFUNC(_wrap_FXApp_setSelbackColor), -1);
    rb_define_method(cFXApp.klass, "setTipforeColor", VALUEFUNC(_wrap_FXApp_setTipforeColor), -1);
    rb_define_method(cFXApp.klass, "setTipbackColor", VALUEFUNC(_wrap_FXApp_setTipbackColor), -1);
    rb_define_method(cFXApp.klass, "dumpWidgets", VALUEFUNC(_wrap_FXApp_dumpWidgets), -1);
    rb_define_method(cFXApp.klass, "save", VALUEFUNC(_wrap_FXApp_save), -1);
    rb_define_method(cFXApp.klass, "load", VALUEFUNC(_wrap_FXApp_load), -1);
    rb_define_method(cFXApp.klass, "create", VALUEFUNC(_wrap_FXApp_create), -1);
    rb_define_method(cFXApp.klass, "destroy", VALUEFUNC(_wrap_FXApp_destroy), -1);
    rb_define_method(cFXApp.klass, "detach", VALUEFUNC(_wrap_FXApp_detach), -1);
    rb_define_method(cFXApp.klass, "init", VALUEFUNC(_wrap_FXApp_init), -1);
    rb_define_method(cFXApp.klass, "exit", VALUEFUNC(_wrap_FXApp_exit), -1);
    rb_define_method(cFXApp.klass, "threadsEnabled=", VALUEFUNC(_wrap_FXApp_threadsEnablede___), -1);
    rb_define_method(cFXApp.klass, "threadsEnabled?", VALUEFUNC(_wrap_FXApp_threadsEnabledq___), -1);
    rb_define_method(cFXApp.klass, "setSleepTime", VALUEFUNC(_wrap_FXApp_setSleepTime), -1);
    rb_define_method(cFXApp.klass, "getSleepTime", VALUEFUNC(_wrap_FXApp_getSleepTime), -1);
    cFXApp.mark = (void (*)(void *)) FXRbApp::markfunc;
    cFXApp.destroy = (void (*)(void *)) FXRbObject::freefunc;
    
    cFXDataTarget.klass = rb_define_class_under(mFox, "FXDataTarget", ((swig_class *) SWIGTYPE_p_FXObject->clientdata)->klass);
    SWIG_TypeClientData(SWIGTYPE_p_FXDataTarget, (void *) &cFXDataTarget);
    rb_define_alloc_func(cFXDataTarget.klass, _wrap_FXDataTarget_allocate);
    rb_define_method(cFXDataTarget.klass, "initialize", VALUEFUNC(_wrap_new_FXDataTarget), -1);
    rb_define_method(cFXDataTarget.klass, "onCmdValue", VALUEFUNC(_wrap_FXDataTarget_onCmdValue), -1);
    rb_define_method(cFXDataTarget.klass, "onUpdValue", VALUEFUNC(_wrap_FXDataTarget_onUpdValue), -1);
    rb_define_method(cFXDataTarget.klass, "onCmdOption", VALUEFUNC(_wrap_FXDataTarget_onCmdOption), -1);
    rb_define_method(cFXDataTarget.klass, "onUpdOption", VALUEFUNC(_wrap_FXDataTarget_onUpdOption), -1);
    rb_define_const(cFXDataTarget.klass,"DT_VOID", INT2NUM(FXDataTarget::DT_VOID));
    rb_define_const(cFXDataTarget.klass,"DT_CHAR", INT2NUM(FXDataTarget::DT_CHAR));
    rb_define_const(cFXDataTarget.klass,"DT_UCHAR", INT2NUM(FXDataTarget::DT_UCHAR));
    rb_define_const(cFXDataTarget.klass,"DT_SHORT", INT2NUM(FXDataTarget::DT_SHORT));
    rb_define_const(cFXDataTarget.klass,"DT_USHORT", INT2NUM(FXDataTarget::DT_USHORT));
    rb_define_const(cFXDataTarget.klass,"DT_INT", INT2NUM(FXDataTarget::DT_INT));
    rb_define_const(cFXDataTarget.klass,"DT_UINT", INT2NUM(FXDataTarget::DT_UINT));
    rb_define_const(cFXDataTarget.klass,"DT_FLOAT", INT2NUM(FXDataTarget::DT_FLOAT));
    rb_define_const(cFXDataTarget.klass,"DT_DOUBLE", INT2NUM(FXDataTarget::DT_DOUBLE));
    rb_define_const(cFXDataTarget.klass,"DT_STRING", INT2NUM(FXDataTarget::DT_STRING));
    rb_define_const(cFXDataTarget.klass,"DT_LAST", INT2NUM(FXDataTarget::DT_LAST));
    rb_define_const(cFXDataTarget.klass,"ID_VALUE", INT2NUM(FXDataTarget::ID_VALUE));
    rb_define_const(cFXDataTarget.klass,"ID_OPTION", INT2NUM(FXDataTarget::ID_OPTION));
    rb_define_const(cFXDataTarget.klass,"ID_LAST", INT2NUM(FXDataTarget::ID_LAST));
    rb_define_method(cFXDataTarget.klass, "setTarget", VALUEFUNC(_wrap_FXDataTarget_setTarget), -1);
    rb_define_method(cFXDataTarget.klass, "getTarget", VALUEFUNC(_wrap_FXDataTarget_getTarget), -1);
    rb_define_method(cFXDataTarget.klass, "setSelector", VALUEFUNC(_wrap_FXDataTarget_setSelector), -1);
    rb_define_method(cFXDataTarget.klass, "getSelector", VALUEFUNC(_wrap_FXDataTarget_getSelector), -1);
    rb_define_method(cFXDataTarget.klass, "getType", VALUEFUNC(_wrap_FXDataTarget_getType), -1);
    rb_define_method(cFXDataTarget.klass, "getValue", VALUEFUNC(_wrap_FXDataTarget_getValue), -1);
    rb_define_method(cFXDataTarget.klass, "setValue", VALUEFUNC(_wrap_FXDataTarget_setValue), -1);
    rb_define_method(cFXDataTarget.klass, "save", VALUEFUNC(_wrap_FXDataTarget_save), -1);
    rb_define_method(cFXDataTarget.klass, "load", VALUEFUNC(_wrap_FXDataTarget_load), -1);
    cFXDataTarget.mark = (void (*)(void *)) FXRbDataTarget::markfunc;
    cFXDataTarget.destroy = (void (*)(void *)) FXRbObject::freefunc;
    
    cFXDebugTarget.klass = rb_define_class_under(mFox, "FXDebugTarget", ((swig_class *) SWIGTYPE_p_FXObject->clientdata)->klass);
    SWIG_TypeClientData(SWIGTYPE_p_FXDebugTarget, (void *) &cFXDebugTarget);
    rb_define_alloc_func(cFXDebugTarget.klass, _wrap_FXDebugTarget_allocate);
    rb_define_method(cFXDebugTarget.klass, "initialize", VALUEFUNC(_wrap_new_FXDebugTarget), -1);
    rb_define_singleton_method(cFXDebugTarget.klass, "messageTypeName", VALUEFUNC(_wrap_FXDebugTarget_messageTypeName), -1);
    rb_define_method(cFXDebugTarget.klass, "onMessage", VALUEFUNC(_wrap_FXDebugTarget_onMessage), -1);
    rb_define_method(cFXDebugTarget.klass, "save", VALUEFUNC(_wrap_FXDebugTarget_save), -1);
    rb_define_method(cFXDebugTarget.klass, "load", VALUEFUNC(_wrap_FXDebugTarget_load), -1);
    cFXDebugTarget.mark = (void (*)(void *)) FXRbDebugTarget::markfunc;
    cFXDebugTarget.destroy = (void (*)(void *)) FXRbObject::freefunc;
    
    cFXDelegator.klass = rb_define_class_under(mFox, "FXDelegator", ((swig_class *) SWIGTYPE_p_FXObject->clientdata)->klass);
    SWIG_TypeClientData(SWIGTYPE_p_FXDelegator, (void *) &cFXDelegator);
    rb_define_alloc_func(cFXDelegator.klass, _wrap_FXDelegator_allocate);
    rb_define_method(cFXDelegator.klass, "initialize", VALUEFUNC(_wrap_new_FXDelegator), -1);
    rb_define_method(cFXDelegator.klass, "getDelegate", VALUEFUNC(_wrap_FXDelegator_getDelegate), -1);
    rb_define_method(cFXDelegator.klass, "setDelegate", VALUEFUNC(_wrap_FXDelegator_setDelegate), -1);
    rb_define_method(cFXDelegator.klass, "save", VALUEFUNC(_wrap_FXDelegator_save), -1);
    rb_define_method(cFXDelegator.klass, "load", VALUEFUNC(_wrap_FXDelegator_load), -1);
    cFXDelegator.mark = (void (*)(void *)) FXRbDelegator::markfunc;
    cFXDelegator.destroy = (void (*)(void *)) FXRbObject::freefunc;
    
    cFXDict.klass = rb_define_class_under(mFox, "FXDict", ((swig_class *) SWIGTYPE_p_FXObject->clientdata)->klass);
    SWIG_TypeClientData(SWIGTYPE_p_FXDict, (void *) &cFXDict);
    rb_define_alloc_func(cFXDict.klass, _wrap_FXDict_allocate);
    rb_define_method(cFXDict.klass, "initialize", VALUEFUNC(_wrap_new_FXDict), -1);
    rb_define_method(cFXDict.klass, "getTotalSize", VALUEFUNC(_wrap_FXDict_getTotalSize), -1);
    rb_define_method(cFXDict.klass, "setTotalSize", VALUEFUNC(_wrap_FXDict_setTotalSize), -1);
    rb_define_method(cFXDict.klass, "length", VALUEFUNC(_wrap_FXDict_length), -1);
    rb_define_method(cFXDict.klass, "remove", VALUEFUNC(_wrap_FXDict_remove), -1);
    rb_define_method(cFXDict.klass, "key", VALUEFUNC(_wrap_FXDict_key), -1);
    rb_define_method(cFXDict.klass, "mark", VALUEFUNC(_wrap_FXDict_mark), -1);
    rb_define_method(cFXDict.klass, "first", VALUEFUNC(_wrap_FXDict_first), -1);
    rb_define_method(cFXDict.klass, "last", VALUEFUNC(_wrap_FXDict_last), -1);
    rb_define_method(cFXDict.klass, "next", VALUEFUNC(_wrap_FXDict_next), -1);
    rb_define_method(cFXDict.klass, "prev", VALUEFUNC(_wrap_FXDict_prev), -1);
    rb_define_method(cFXDict.klass, "clear", VALUEFUNC(_wrap_FXDict_clear), -1);
    rb_define_method(cFXDict.klass, "has_key?", VALUEFUNC(_wrap_FXDict_has_keyq___), -1);
    rb_define_method(cFXDict.klass, "save", VALUEFUNC(_wrap_FXDict_save), -1);
    rb_define_method(cFXDict.klass, "load", VALUEFUNC(_wrap_FXDict_load), -1);
    cFXDict.mark = (void (*)(void *)) FXRbDict::markfunc;
    cFXDict.destroy = (void (*)(void *)) FXRbObject::freefunc;
    
    SWIGTYPE_p_FXDict->dcast = (swig_dycast_func) FXDict_dynamic_cast;
    
    
    cFXFileAssoc.klass = rb_define_class_under(mFox, "FXFileAssoc", rb_cObject);
    SWIG_TypeClientData(SWIGTYPE_p_FXFileAssoc, (void *) &cFXFileAssoc);
    rb_define_alloc_func(cFXFileAssoc.klass, _wrap_FXFileAssoc_allocate);
    rb_define_method(cFXFileAssoc.klass, "initialize", VALUEFUNC(_wrap_new_FXFileAssoc), -1);
    rb_define_method(cFXFileAssoc.klass, "command=", VALUEFUNC(_wrap_FXFileAssoc_command_set), -1);
    rb_define_method(cFXFileAssoc.klass, "command", VALUEFUNC(_wrap_FXFileAssoc_command_get), -1);
    rb_define_method(cFXFileAssoc.klass, "extension=", VALUEFUNC(_wrap_FXFileAssoc_extension_set), -1);
    rb_define_method(cFXFileAssoc.klass, "extension", VALUEFUNC(_wrap_FXFileAssoc_extension_get), -1);
    rb_define_method(cFXFileAssoc.klass, "mimetype=", VALUEFUNC(_wrap_FXFileAssoc_mimetype_set), -1);
    rb_define_method(cFXFileAssoc.klass, "mimetype", VALUEFUNC(_wrap_FXFileAssoc_mimetype_get), -1);
    rb_define_method(cFXFileAssoc.klass, "bigicon=", VALUEFUNC(_wrap_FXFileAssoc_bigicon_set), -1);
    rb_define_method(cFXFileAssoc.klass, "bigicon", VALUEFUNC(_wrap_FXFileAssoc_bigicon_get), -1);
    rb_define_method(cFXFileAssoc.klass, "bigiconopen=", VALUEFUNC(_wrap_FXFileAssoc_bigiconopen_set), -1);
    rb_define_method(cFXFileAssoc.klass, "bigiconopen", VALUEFUNC(_wrap_FXFileAssoc_bigiconopen_get), -1);
    rb_define_method(cFXFileAssoc.klass, "miniicon=", VALUEFUNC(_wrap_FXFileAssoc_miniicon_set), -1);
    rb_define_method(cFXFileAssoc.klass, "miniicon", VALUEFUNC(_wrap_FXFileAssoc_miniicon_get), -1);
    rb_define_method(cFXFileAssoc.klass, "miniiconopen=", VALUEFUNC(_wrap_FXFileAssoc_miniiconopen_set), -1);
    rb_define_method(cFXFileAssoc.klass, "miniiconopen", VALUEFUNC(_wrap_FXFileAssoc_miniiconopen_get), -1);
    rb_define_method(cFXFileAssoc.klass, "dragtype=", VALUEFUNC(_wrap_FXFileAssoc_dragtype_set), -1);
    rb_define_method(cFXFileAssoc.klass, "dragtype", VALUEFUNC(_wrap_FXFileAssoc_dragtype_get), -1);
    rb_define_method(cFXFileAssoc.klass, "flags=", VALUEFUNC(_wrap_FXFileAssoc_flags_set), -1);
    rb_define_method(cFXFileAssoc.klass, "flags", VALUEFUNC(_wrap_FXFileAssoc_flags_get), -1);
    cFXFileAssoc.mark = 0;
    cFXFileAssoc.destroy = (void (*)(void *)) FXRbUnregisterRubyObj;
    
    cFXIconDict.klass = rb_define_class_under(mFox, "FXIconDict", ((swig_class *) SWIGTYPE_p_FXDict->clientdata)->klass);
    SWIG_TypeClientData(SWIGTYPE_p_FXIconDict, (void *) &cFXIconDict);
    rb_define_alloc_func(cFXIconDict.klass, _wrap_FXIconDict_allocate);
    rb_define_method(cFXIconDict.klass, "initialize", VALUEFUNC(_wrap_new_FXIconDict), -1);
    rb_define_singleton_method(cFXIconDict.klass, "defaultIconPath", VALUEFUNC(_wrap_FXIconDict_defaultIconPath), -1);
    rb_define_method(cFXIconDict.klass, "getApp", VALUEFUNC(_wrap_FXIconDict_getApp), -1);
    rb_define_method(cFXIconDict.klass, "setIconPath", VALUEFUNC(_wrap_FXIconDict_setIconPath), -1);
    rb_define_method(cFXIconDict.klass, "getIconPath", VALUEFUNC(_wrap_FXIconDict_getIconPath), -1);
    rb_define_method(cFXIconDict.klass, "insert", VALUEFUNC(_wrap_FXIconDict_insert), -1);
    rb_define_method(cFXIconDict.klass, "remove", VALUEFUNC(_wrap_FXIconDict_remove), -1);
    rb_define_method(cFXIconDict.klass, "find", VALUEFUNC(_wrap_FXIconDict_find), -1);
    rb_define_method(cFXIconDict.klass, "save", VALUEFUNC(_wrap_FXIconDict_save), -1);
    rb_define_method(cFXIconDict.klass, "load", VALUEFUNC(_wrap_FXIconDict_load), -1);
    cFXIconDict.mark = (void (*)(void *)) FXRbIconDict::markfunc;
    cFXIconDict.destroy = (void (*)(void *)) FXRbObject::freefunc;
    
    cFXFileDict.klass = rb_define_class_under(mFox, "FXFileDict", ((swig_class *) SWIGTYPE_p_FXDict->clientdata)->klass);
    SWIG_TypeClientData(SWIGTYPE_p_FXFileDict, (void *) &cFXFileDict);
    rb_define_alloc_func(cFXFileDict.klass, _wrap_FXFileDict_allocate);
    rb_define_method(cFXFileDict.klass, "initialize", VALUEFUNC(_wrap_new_FXFileDict), -1);
    rb_define_singleton_method(cFXFileDict.klass, "defaultExecBinding", VALUEFUNC(_wrap_FXFileDict_defaultExecBinding), -1);
    rb_define_singleton_method(cFXFileDict.klass, "defaultDirBinding", VALUEFUNC(_wrap_FXFileDict_defaultDirBinding), -1);
    rb_define_singleton_method(cFXFileDict.klass, "defaultFileBinding", VALUEFUNC(_wrap_FXFileDict_defaultFileBinding), -1);
    rb_define_method(cFXFileDict.klass, "getApp", VALUEFUNC(_wrap_FXFileDict_getApp), -1);
    rb_define_method(cFXFileDict.klass, "setIconPath", VALUEFUNC(_wrap_FXFileDict_setIconPath), -1);
    rb_define_method(cFXFileDict.klass, "getIconPath", VALUEFUNC(_wrap_FXFileDict_getIconPath), -1);
    rb_define_method(cFXFileDict.klass, "replace", VALUEFUNC(_wrap_FXFileDict_replace), -1);
    rb_define_method(cFXFileDict.klass, "remove", VALUEFUNC(_wrap_FXFileDict_remove), -1);
    rb_define_method(cFXFileDict.klass, "find", VALUEFUNC(_wrap_FXFileDict_find), -1);
    rb_define_method(cFXFileDict.klass, "associate", VALUEFUNC(_wrap_FXFileDict_associate), -1);
    rb_define_method(cFXFileDict.klass, "save", VALUEFUNC(_wrap_FXFileDict_save), -1);
    rb_define_method(cFXFileDict.klass, "load", VALUEFUNC(_wrap_FXFileDict_load), -1);
    rb_define_method(cFXFileDict.klass, "findFileBinding", VALUEFUNC(_wrap_FXFileDict_findFileBinding), -1);
    rb_define_method(cFXFileDict.klass, "findDirBinding", VALUEFUNC(_wrap_FXFileDict_findDirBinding), -1);
    rb_define_method(cFXFileDict.klass, "findExecBinding", VALUEFUNC(_wrap_FXFileDict_findExecBinding), -1);
    cFXFileDict.mark = (void (*)(void *)) FXRbFileDict::markfunc;
    cFXFileDict.destroy = (void (*)(void *)) FXRbObject::freefunc;
    
    cFXStringDict.klass = rb_define_class_under(mFox, "FXStringDict", ((swig_class *) SWIGTYPE_p_FXDict->clientdata)->klass);
    SWIG_TypeClientData(SWIGTYPE_p_FXStringDict, (void *) &cFXStringDict);
    rb_define_alloc_func(cFXStringDict.klass, _wrap_FXStringDict_allocate);
    rb_define_method(cFXStringDict.klass, "initialize", VALUEFUNC(_wrap_new_FXStringDict), -1);
    rb_define_method(cFXStringDict.klass, "insert", VALUEFUNC(_wrap_FXStringDict_insert), -1);
    rb_define_method(cFXStringDict.klass, "replace", VALUEFUNC(_wrap_FXStringDict_replace), -1);
    rb_define_method(cFXStringDict.klass, "remove", VALUEFUNC(_wrap_FXStringDict_remove), -1);
    rb_define_method(cFXStringDict.klass, "find", VALUEFUNC(_wrap_FXStringDict_find), -1);
    rb_define_method(cFXStringDict.klass, "data", VALUEFUNC(_wrap_FXStringDict_data), -1);
    rb_define_method(cFXStringDict.klass, "save", VALUEFUNC(_wrap_FXStringDict_save), -1);
    rb_define_method(cFXStringDict.klass, "load", VALUEFUNC(_wrap_FXStringDict_load), -1);
    cFXStringDict.mark = (void (*)(void *)) FXRbStringDict::markfunc;
    cFXStringDict.destroy = (void (*)(void *)) FXRbObject::freefunc;
    
    cFXSettings.klass = rb_define_class_under(mFox, "FXSettings", ((swig_class *) SWIGTYPE_p_FXDict->clientdata)->klass);
    SWIG_TypeClientData(SWIGTYPE_p_FXSettings, (void *) &cFXSettings);
    rb_define_alloc_func(cFXSettings.klass, _wrap_FXSettings_allocate);
    rb_define_method(cFXSettings.klass, "initialize", VALUEFUNC(_wrap_new_FXSettings), -1);
    rb_define_method(cFXSettings.klass, "parseFile", VALUEFUNC(_wrap_FXSettings_parseFile), -1);
    rb_define_method(cFXSettings.klass, "unparseFile", VALUEFUNC(_wrap_FXSettings_unparseFile), -1);
    rb_define_method(cFXSettings.klass, "data", VALUEFUNC(_wrap_FXSettings_data), -1);
    rb_define_method(cFXSettings.klass, "find", VALUEFUNC(_wrap_FXSettings_find), -1);
    rb_define_method(cFXSettings.klass, "readStringEntry", VALUEFUNC(_wrap_FXSettings_readStringEntry), -1);
    rb_define_method(cFXSettings.klass, "readIntEntry", VALUEFUNC(_wrap_FXSettings_readIntEntry), -1);
    rb_define_method(cFXSettings.klass, "readUnsignedEntry", VALUEFUNC(_wrap_FXSettings_readUnsignedEntry), -1);
    rb_define_method(cFXSettings.klass, "readRealEntry", VALUEFUNC(_wrap_FXSettings_readRealEntry), -1);
    rb_define_method(cFXSettings.klass, "readColorEntry", VALUEFUNC(_wrap_FXSettings_readColorEntry), -1);
    rb_define_method(cFXSettings.klass, "writeStringEntry", VALUEFUNC(_wrap_FXSettings_writeStringEntry), -1);
    rb_define_method(cFXSettings.klass, "writeIntEntry", VALUEFUNC(_wrap_FXSettings_writeIntEntry), -1);
    rb_define_method(cFXSettings.klass, "writeUnsignedEntry", VALUEFUNC(_wrap_FXSettings_writeUnsignedEntry), -1);
    rb_define_method(cFXSettings.klass, "writeRealEntry", VALUEFUNC(_wrap_FXSettings_writeRealEntry), -1);
    rb_define_method(cFXSettings.klass, "writeColorEntry", VALUEFUNC(_wrap_FXSettings_writeColorEntry), -1);
    rb_define_method(cFXSettings.klass, "deleteEntry", VALUEFUNC(_wrap_FXSettings_deleteEntry), -1);
    rb_define_method(cFXSettings.klass, "existingEntry", VALUEFUNC(_wrap_FXSettings_existingEntry), -1);
    rb_define_method(cFXSettings.klass, "deleteSection", VALUEFUNC(_wrap_FXSettings_deleteSection), -1);
    rb_define_method(cFXSettings.klass, "existingSection", VALUEFUNC(_wrap_FXSettings_existingSection), -1);
    rb_define_method(cFXSettings.klass, "clear", VALUEFUNC(_wrap_FXSettings_clear), -1);
    rb_define_method(cFXSettings.klass, "setModified", VALUEFUNC(_wrap_FXSettings_setModified), -1);
    rb_define_method(cFXSettings.klass, "isModified", VALUEFUNC(_wrap_FXSettings_isModified), -1);
    rb_define_method(cFXSettings.klass, "save", VALUEFUNC(_wrap_FXSettings_save), -1);
    rb_define_method(cFXSettings.klass, "load", VALUEFUNC(_wrap_FXSettings_load), -1);
    cFXSettings.mark = (void (*)(void *)) FXRbSettings::markfunc;
    cFXSettings.destroy = (void (*)(void *)) FXRbObject::freefunc;
    
    SWIGTYPE_p_FXSettings->dcast = (swig_dycast_func) FXSettings_dynamic_cast;
    
    
    cFXRegistry.klass = rb_define_class_under(mFox, "FXRegistry", ((swig_class *) SWIGTYPE_p_FXSettings->clientdata)->klass);
    SWIG_TypeClientData(SWIGTYPE_p_FXRegistry, (void *) &cFXRegistry);
    rb_define_alloc_func(cFXRegistry.klass, _wrap_FXRegistry_allocate);
    rb_define_method(cFXRegistry.klass, "initialize", VALUEFUNC(_wrap_new_FXRegistry), -1);
    rb_define_method(cFXRegistry.klass, "read", VALUEFUNC(_wrap_FXRegistry_read), -1);
    rb_define_method(cFXRegistry.klass, "write", VALUEFUNC(_wrap_FXRegistry_write), -1);
    rb_define_method(cFXRegistry.klass, "getAppKey", VALUEFUNC(_wrap_FXRegistry_getAppKey), -1);
    rb_define_method(cFXRegistry.klass, "getVendorKey", VALUEFUNC(_wrap_FXRegistry_getVendorKey), -1);
    rb_define_method(cFXRegistry.klass, "setAsciiMode", VALUEFUNC(_wrap_FXRegistry_setAsciiMode), -1);
    rb_define_method(cFXRegistry.klass, "getAsciiMode", VALUEFUNC(_wrap_FXRegistry_getAsciiMode), -1);
    rb_define_method(cFXRegistry.klass, "save", VALUEFUNC(_wrap_FXRegistry_save), -1);
    rb_define_method(cFXRegistry.klass, "load", VALUEFUNC(_wrap_FXRegistry_load), -1);
    cFXRegistry.mark = (void (*)(void *)) FXRbRegistry::markfunc;
    cFXRegistry.destroy = (void (*)(void *)) FXRbObject::freefunc;
    
    cFXDocument.klass = rb_define_class_under(mFox, "FXDocument", ((swig_class *) SWIGTYPE_p_FXObject->clientdata)->klass);
    SWIG_TypeClientData(SWIGTYPE_p_FXDocument, (void *) &cFXDocument);
    rb_define_alloc_func(cFXDocument.klass, _wrap_FXDocument_allocate);
    rb_define_method(cFXDocument.klass, "initialize", VALUEFUNC(_wrap_new_FXDocument), -1);
    rb_define_method(cFXDocument.klass, "onUpdTitle", VALUEFUNC(_wrap_FXDocument_onUpdTitle), -1);
    rb_define_method(cFXDocument.klass, "onUpdFilename", VALUEFUNC(_wrap_FXDocument_onUpdFilename), -1);
    rb_define_const(cFXDocument.klass,"ID_TITLE", INT2NUM(FXDocument::ID_TITLE));
    rb_define_const(cFXDocument.klass,"ID_FILENAME", INT2NUM(FXDocument::ID_FILENAME));
    rb_define_const(cFXDocument.klass,"ID_LAST", INT2NUM(FXDocument::ID_LAST));
    rb_define_method(cFXDocument.klass, "isModified", VALUEFUNC(_wrap_FXDocument_isModified), -1);
    rb_define_method(cFXDocument.klass, "setModified", VALUEFUNC(_wrap_FXDocument_setModified), -1);
    rb_define_method(cFXDocument.klass, "setTitle", VALUEFUNC(_wrap_FXDocument_setTitle), -1);
    rb_define_method(cFXDocument.klass, "getTitle", VALUEFUNC(_wrap_FXDocument_getTitle), -1);
    rb_define_method(cFXDocument.klass, "setFilename", VALUEFUNC(_wrap_FXDocument_setFilename), -1);
    rb_define_method(cFXDocument.klass, "getFilename", VALUEFUNC(_wrap_FXDocument_getFilename), -1);
    rb_define_method(cFXDocument.klass, "save", VALUEFUNC(_wrap_FXDocument_save), -1);
    rb_define_method(cFXDocument.klass, "load", VALUEFUNC(_wrap_FXDocument_load), -1);
    cFXDocument.mark = (void (*)(void *)) FXRbDocument::markfunc;
    cFXDocument.destroy = (void (*)(void *)) FXRbObject::freefunc;
    
    cFXRecentFiles.klass = rb_define_class_under(mFox, "FXRecentFiles", ((swig_class *) SWIGTYPE_p_FXObject->clientdata)->klass);
    SWIG_TypeClientData(SWIGTYPE_p_FXRecentFiles, (void *) &cFXRecentFiles);
    rb_define_alloc_func(cFXRecentFiles.klass, _wrap_FXRecentFiles_allocate);
    rb_define_method(cFXRecentFiles.klass, "initialize", VALUEFUNC(_wrap_new_FXRecentFiles), -1);
    rb_define_method(cFXRecentFiles.klass, "onCmdClear", VALUEFUNC(_wrap_FXRecentFiles_onCmdClear), -1);
    rb_define_method(cFXRecentFiles.klass, "onCmdFile", VALUEFUNC(_wrap_FXRecentFiles_onCmdFile), -1);
    rb_define_method(cFXRecentFiles.klass, "onUpdFile", VALUEFUNC(_wrap_FXRecentFiles_onUpdFile), -1);
    rb_define_method(cFXRecentFiles.klass, "onUpdAnyFiles", VALUEFUNC(_wrap_FXRecentFiles_onUpdAnyFiles), -1);
    rb_define_const(cFXRecentFiles.klass,"ID_CLEAR", INT2NUM(FXRecentFiles::ID_CLEAR));
    rb_define_const(cFXRecentFiles.klass,"ID_ANYFILES", INT2NUM(FXRecentFiles::ID_ANYFILES));
    rb_define_const(cFXRecentFiles.klass,"ID_FILE_1", INT2NUM(FXRecentFiles::ID_FILE_1));
    rb_define_const(cFXRecentFiles.klass,"ID_FILE_2", INT2NUM(FXRecentFiles::ID_FILE_2));
    rb_define_const(cFXRecentFiles.klass,"ID_FILE_3", INT2NUM(FXRecentFiles::ID_FILE_3));
    rb_define_const(cFXRecentFiles.klass,"ID_FILE_4", INT2NUM(FXRecentFiles::ID_FILE_4));
    rb_define_const(cFXRecentFiles.klass,"ID_FILE_5", INT2NUM(FXRecentFiles::ID_FILE_5));
    rb_define_const(cFXRecentFiles.klass,"ID_FILE_6", INT2NUM(FXRecentFiles::ID_FILE_6));
    rb_define_const(cFXRecentFiles.klass,"ID_FILE_7", INT2NUM(FXRecentFiles::ID_FILE_7));
    rb_define_const(cFXRecentFiles.klass,"ID_FILE_8", INT2NUM(FXRecentFiles::ID_FILE_8));
    rb_define_const(cFXRecentFiles.klass,"ID_FILE_9", INT2NUM(FXRecentFiles::ID_FILE_9));
    rb_define_const(cFXRecentFiles.klass,"ID_FILE_10", INT2NUM(FXRecentFiles::ID_FILE_10));
    rb_define_method(cFXRecentFiles.klass, "setMaxFiles", VALUEFUNC(_wrap_FXRecentFiles_setMaxFiles), -1);
    rb_define_method(cFXRecentFiles.klass, "getMaxFiles", VALUEFUNC(_wrap_FXRecentFiles_getMaxFiles), -1);
    rb_define_method(cFXRecentFiles.klass, "setGroupName", VALUEFUNC(_wrap_FXRecentFiles_setGroupName), -1);
    rb_define_method(cFXRecentFiles.klass, "getGroupName", VALUEFUNC(_wrap_FXRecentFiles_getGroupName), -1);
    rb_define_method(cFXRecentFiles.klass, "setTarget", VALUEFUNC(_wrap_FXRecentFiles_setTarget), -1);
    rb_define_method(cFXRecentFiles.klass, "getTarget", VALUEFUNC(_wrap_FXRecentFiles_getTarget), -1);
    rb_define_method(cFXRecentFiles.klass, "setSelector", VALUEFUNC(_wrap_FXRecentFiles_setSelector), -1);
    rb_define_method(cFXRecentFiles.klass, "getSelector", VALUEFUNC(_wrap_FXRecentFiles_getSelector), -1);
    rb_define_method(cFXRecentFiles.klass, "getFile", VALUEFUNC(_wrap_FXRecentFiles_getFile), -1);
    rb_define_method(cFXRecentFiles.klass, "setFile", VALUEFUNC(_wrap_FXRecentFiles_setFile), -1);
    rb_define_method(cFXRecentFiles.klass, "appendFile", VALUEFUNC(_wrap_FXRecentFiles_appendFile), -1);
    rb_define_method(cFXRecentFiles.klass, "removeFile", VALUEFUNC(_wrap_FXRecentFiles_removeFile), -1);
    rb_define_method(cFXRecentFiles.klass, "clear", VALUEFUNC(_wrap_FXRecentFiles_clear), -1);
    rb_define_method(cFXRecentFiles.klass, "save", VALUEFUNC(_wrap_FXRecentFiles_save), -1);
    rb_define_method(cFXRecentFiles.klass, "load", VALUEFUNC(_wrap_FXRecentFiles_load), -1);
    cFXRecentFiles.mark = (void (*)(void *)) FXRbRecentFiles::markfunc;
    cFXRecentFiles.destroy = (void (*)(void *)) FXRbObject::freefunc;
    
    cFXId.klass = rb_define_class_under(mFox, "FXId", ((swig_class *) SWIGTYPE_p_FXObject->clientdata)->klass);
    SWIG_TypeClientData(SWIGTYPE_p_FXId, (void *) &cFXId);
    rb_undef_alloc_func(cFXId.klass);
    rb_define_method(cFXId.klass, "getApp", VALUEFUNC(_wrap_FXId_getApp), -1);
    rb_define_method(cFXId.klass, "xid", VALUEFUNC(_wrap_FXId_xid), -1);
    rb_define_method(cFXId.klass, "created?", VALUEFUNC(_wrap_FXId_createdq___), -1);
    rb_define_method(cFXId.klass, "setUserData", VALUEFUNC(_wrap_FXId_setUserData), -1);
    rb_define_method(cFXId.klass, "getUserData", VALUEFUNC(_wrap_FXId_getUserData), -1);
    rb_define_method(cFXId.klass, "save", VALUEFUNC(_wrap_FXId_save), -1);
    rb_define_method(cFXId.klass, "load", VALUEFUNC(_wrap_FXId_load), -1);
    rb_define_method(cFXId.klass, "create", VALUEFUNC(_wrap_FXId_create), -1);
    rb_define_method(cFXId.klass, "detach", VALUEFUNC(_wrap_FXId_detach), -1);
    rb_define_method(cFXId.klass, "destroy", VALUEFUNC(_wrap_FXId_destroy), -1);
    cFXId.mark = (void (*)(void *)) FXRbId::markfunc;
    cFXId.destroy = (void (*)(void *)) FXRbObject::freefunc;
    
    SWIGTYPE_p_FXId->dcast = (swig_dycast_func) FXId_dynamic_cast;
    
    rb_define_const(mFox,"CURSOR_ARROW", INT2NUM(CURSOR_ARROW));
    rb_define_const(mFox,"CURSOR_RARROW", INT2NUM(CURSOR_RARROW));
    rb_define_const(mFox,"CURSOR_IBEAM", INT2NUM(CURSOR_IBEAM));
    rb_define_const(mFox,"CURSOR_WATCH", INT2NUM(CURSOR_WATCH));
    rb_define_const(mFox,"CURSOR_CROSS", INT2NUM(CURSOR_CROSS));
    rb_define_const(mFox,"CURSOR_UPDOWN", INT2NUM(CURSOR_UPDOWN));
    rb_define_const(mFox,"CURSOR_LEFTRIGHT", INT2NUM(CURSOR_LEFTRIGHT));
    rb_define_const(mFox,"CURSOR_MOVE", INT2NUM(CURSOR_MOVE));
    rb_define_const(mFox,"CURSOR_KEEP", INT2NUM(CURSOR_KEEP));
    rb_define_const(mFox,"CURSOR_OWNED", INT2NUM(CURSOR_OWNED));
    
    cFXCursor.klass = rb_define_class_under(mFox, "FXCursor", ((swig_class *) SWIGTYPE_p_FXId->clientdata)->klass);
    SWIG_TypeClientData(SWIGTYPE_p_FXCursor, (void *) &cFXCursor);
    rb_define_alloc_func(cFXCursor.klass, _wrap_FXCursor_allocate);
    rb_define_method(cFXCursor.klass, "initialize", VALUEFUNC(_wrap_new_FXCursor), -1);
    rb_define_method(cFXCursor.klass, "getWidth", VALUEFUNC(_wrap_FXCursor_getWidth), -1);
    rb_define_method(cFXCursor.klass, "getHeight", VALUEFUNC(_wrap_FXCursor_getHeight), -1);
    rb_define_method(cFXCursor.klass, "getHotX", VALUEFUNC(_wrap_FXCursor_getHotX), -1);
    rb_define_method(cFXCursor.klass, "getHotY", VALUEFUNC(_wrap_FXCursor_getHotY), -1);
    rb_define_method(cFXCursor.klass, "isColor", VALUEFUNC(_wrap_FXCursor_isColor), -1);
    rb_define_method(cFXCursor.klass, "save", VALUEFUNC(_wrap_FXCursor_save), -1);
    rb_define_method(cFXCursor.klass, "load", VALUEFUNC(_wrap_FXCursor_load), -1);
    rb_define_method(cFXCursor.klass, "create", VALUEFUNC(_wrap_FXCursor_create), -1);
    rb_define_method(cFXCursor.klass, "detach", VALUEFUNC(_wrap_FXCursor_detach), -1);
    rb_define_method(cFXCursor.klass, "destroy", VALUEFUNC(_wrap_FXCursor_destroy), -1);
    rb_define_method(cFXCursor.klass, "savePixels", VALUEFUNC(_wrap_FXCursor_savePixels), -1);
    rb_define_method(cFXCursor.klass, "loadPixels", VALUEFUNC(_wrap_FXCursor_loadPixels), -1);
    cFXCursor.mark = (void (*)(void *)) FXRbCursor::markfunc;
    cFXCursor.destroy = (void (*)(void *)) FXRbCursor::freefunc;
    
    SWIGTYPE_p_FXCursor->dcast = (swig_dycast_func) FXCursor_dynamic_cast;
    
    
    cFXCURCursor.klass = rb_define_class_under(mFox, "FXCURCursor", ((swig_class *) SWIGTYPE_p_FXCursor->clientdata)->klass);
    SWIG_TypeClientData(SWIGTYPE_p_FXCURCursor, (void *) &cFXCURCursor);
    rb_define_alloc_func(cFXCURCursor.klass, _wrap_FXCURCursor_allocate);
    rb_define_method(cFXCURCursor.klass, "initialize", VALUEFUNC(_wrap_new_FXCURCursor), -1);
    rb_define_method(cFXCURCursor.klass, "save", VALUEFUNC(_wrap_FXCURCursor_save), -1);
    rb_define_method(cFXCURCursor.klass, "load", VALUEFUNC(_wrap_FXCURCursor_load), -1);
    rb_define_method(cFXCURCursor.klass, "create", VALUEFUNC(_wrap_FXCURCursor_create), -1);
    rb_define_method(cFXCURCursor.klass, "detach", VALUEFUNC(_wrap_FXCURCursor_detach), -1);
    rb_define_method(cFXCURCursor.klass, "destroy", VALUEFUNC(_wrap_FXCURCursor_destroy), -1);
    rb_define_method(cFXCURCursor.klass, "savePixels", VALUEFUNC(_wrap_FXCURCursor_savePixels), -1);
    rb_define_method(cFXCURCursor.klass, "loadPixels", VALUEFUNC(_wrap_FXCURCursor_loadPixels), -1);
    cFXCURCursor.mark = (void (*)(void *)) FXRbCURCursor::markfunc;
    cFXCURCursor.destroy = (void (*)(void *)) FXRbCURCursor::freefunc;
    
    cFXGIFCursor.klass = rb_define_class_under(mFox, "FXGIFCursor", ((swig_class *) SWIGTYPE_p_FXCursor->clientdata)->klass);
    SWIG_TypeClientData(SWIGTYPE_p_FXGIFCursor, (void *) &cFXGIFCursor);
    rb_define_alloc_func(cFXGIFCursor.klass, _wrap_FXGIFCursor_allocate);
    rb_define_method(cFXGIFCursor.klass, "initialize", VALUEFUNC(_wrap_new_FXGIFCursor), -1);
    rb_define_method(cFXGIFCursor.klass, "save", VALUEFUNC(_wrap_FXGIFCursor_save), -1);
    rb_define_method(cFXGIFCursor.klass, "load", VALUEFUNC(_wrap_FXGIFCursor_load), -1);
    rb_define_method(cFXGIFCursor.klass, "create", VALUEFUNC(_wrap_FXGIFCursor_create), -1);
    rb_define_method(cFXGIFCursor.klass, "detach", VALUEFUNC(_wrap_FXGIFCursor_detach), -1);
    rb_define_method(cFXGIFCursor.klass, "destroy", VALUEFUNC(_wrap_FXGIFCursor_destroy), -1);
    rb_define_method(cFXGIFCursor.klass, "savePixels", VALUEFUNC(_wrap_FXGIFCursor_savePixels), -1);
    rb_define_method(cFXGIFCursor.klass, "loadPixels", VALUEFUNC(_wrap_FXGIFCursor_loadPixels), -1);
    cFXGIFCursor.mark = (void (*)(void *)) FXRbGIFCursor::markfunc;
    cFXGIFCursor.destroy = (void (*)(void *)) FXRbGIFCursor::freefunc;
    rb_define_module_function(mFox, "fxsaveGIF", VALUEFUNC(_wrap_fxsaveGIF), -1);
    rb_define_module_function(mFox, "fxloadGIF", VALUEFUNC(_wrap_fxloadGIF), -1);
    
    cFXDrawable.klass = rb_define_class_under(mFox, "FXDrawable", ((swig_class *) SWIGTYPE_p_FXId->clientdata)->klass);
    SWIG_TypeClientData(SWIGTYPE_p_FXDrawable, (void *) &cFXDrawable);
    rb_define_alloc_func(cFXDrawable.klass, _wrap_FXDrawable_allocate);
    rb_define_method(cFXDrawable.klass, "initialize", VALUEFUNC(_wrap_new_FXDrawable), -1);
    rb_define_method(cFXDrawable.klass, "getWidth", VALUEFUNC(_wrap_FXDrawable_getWidth), -1);
    rb_define_method(cFXDrawable.klass, "getHeight", VALUEFUNC(_wrap_FXDrawable_getHeight), -1);
    rb_define_method(cFXDrawable.klass, "getVisual", VALUEFUNC(_wrap_FXDrawable_getVisual), -1);
    rb_define_method(cFXDrawable.klass, "setVisual", VALUEFUNC(_wrap_FXDrawable_setVisual), -1);
    rb_define_method(cFXDrawable.klass, "save", VALUEFUNC(_wrap_FXDrawable_save), -1);
    rb_define_method(cFXDrawable.klass, "load", VALUEFUNC(_wrap_FXDrawable_load), -1);
    rb_define_method(cFXDrawable.klass, "create", VALUEFUNC(_wrap_FXDrawable_create), -1);
    rb_define_method(cFXDrawable.klass, "detach", VALUEFUNC(_wrap_FXDrawable_detach), -1);
    rb_define_method(cFXDrawable.klass, "destroy", VALUEFUNC(_wrap_FXDrawable_destroy), -1);
    rb_define_method(cFXDrawable.klass, "resize", VALUEFUNC(_wrap_FXDrawable_resize), -1);
    cFXDrawable.mark = (void (*)(void *)) FXRbDrawable::markfunc;
    cFXDrawable.destroy = (void (*)(void *)) FXRbObject::freefunc;
    
    SWIGTYPE_p_FXDrawable->dcast = (swig_dycast_func) FXDrawable_dynamic_cast;
    
    rb_define_const(mFox,"VISUAL_DEFAULT", INT2NUM(VISUAL_DEFAULT));
    rb_define_const(mFox,"VISUAL_MONOCHROME", INT2NUM(VISUAL_MONOCHROME));
    rb_define_const(mFox,"VISUAL_BEST", INT2NUM(VISUAL_BEST));
    rb_define_const(mFox,"VISUAL_INDEXCOLOR", INT2NUM(VISUAL_INDEXCOLOR));
    rb_define_const(mFox,"VISUAL_GRAYSCALE", INT2NUM(VISUAL_GRAYSCALE));
    rb_define_const(mFox,"VISUAL_TRUECOLOR", INT2NUM(VISUAL_TRUECOLOR));
    rb_define_const(mFox,"VISUAL_OWNCOLORMAP", INT2NUM(VISUAL_OWNCOLORMAP));
    rb_define_const(mFox,"VISUAL_DOUBLEBUFFER", INT2NUM(VISUAL_DOUBLEBUFFER));
    rb_define_const(mFox,"VISUAL_STEREO", INT2NUM(VISUAL_STEREO));
    rb_define_const(mFox,"VISUAL_NOACCEL", INT2NUM(VISUAL_NOACCEL));
    rb_define_const(mFox,"VISUAL_SWAP_COPY", INT2NUM(VISUAL_SWAP_COPY));
    rb_define_const(mFox,"VISUALTYPE_UNKNOWN", INT2NUM(VISUALTYPE_UNKNOWN));
    rb_define_const(mFox,"VISUALTYPE_MONO", INT2NUM(VISUALTYPE_MONO));
    rb_define_const(mFox,"VISUALTYPE_TRUE", INT2NUM(VISUALTYPE_TRUE));
    rb_define_const(mFox,"VISUALTYPE_INDEX", INT2NUM(VISUALTYPE_INDEX));
    rb_define_const(mFox,"VISUALTYPE_GRAY", INT2NUM(VISUALTYPE_GRAY));
    
    cFXVisual.klass = rb_define_class_under(mFox, "FXVisual", ((swig_class *) SWIGTYPE_p_FXId->clientdata)->klass);
    SWIG_TypeClientData(SWIGTYPE_p_FXVisual, (void *) &cFXVisual);
    rb_define_alloc_func(cFXVisual.klass, _wrap_FXVisual_allocate);
    rb_define_method(cFXVisual.klass, "initialize", VALUEFUNC(_wrap_new_FXVisual), -1);
    rb_define_method(cFXVisual.klass, "visualType", VALUEFUNC(_wrap_FXVisual_visualType), -1);
    rb_define_method(cFXVisual.klass, "getFlags", VALUEFUNC(_wrap_FXVisual_getFlags), -1);
    rb_define_method(cFXVisual.klass, "getDepth", VALUEFUNC(_wrap_FXVisual_getDepth), -1);
    rb_define_method(cFXVisual.klass, "getNumColors", VALUEFUNC(_wrap_FXVisual_getNumColors), -1);
    rb_define_method(cFXVisual.klass, "getNumRed", VALUEFUNC(_wrap_FXVisual_getNumRed), -1);
    rb_define_method(cFXVisual.klass, "getNumGreen", VALUEFUNC(_wrap_FXVisual_getNumGreen), -1);
    rb_define_method(cFXVisual.klass, "getNumBlue", VALUEFUNC(_wrap_FXVisual_getNumBlue), -1);
    rb_define_method(cFXVisual.klass, "getPixel", VALUEFUNC(_wrap_FXVisual_getPixel), -1);
    rb_define_method(cFXVisual.klass, "getColor", VALUEFUNC(_wrap_FXVisual_getColor), -1);
    rb_define_method(cFXVisual.klass, "setMaxColors", VALUEFUNC(_wrap_FXVisual_setMaxColors), -1);
    rb_define_method(cFXVisual.klass, "getMaxColors", VALUEFUNC(_wrap_FXVisual_getMaxColors), -1);
    rb_define_method(cFXVisual.klass, "save", VALUEFUNC(_wrap_FXVisual_save), -1);
    rb_define_method(cFXVisual.klass, "load", VALUEFUNC(_wrap_FXVisual_load), -1);
    rb_define_method(cFXVisual.klass, "create", VALUEFUNC(_wrap_FXVisual_create), -1);
    rb_define_method(cFXVisual.klass, "detach", VALUEFUNC(_wrap_FXVisual_detach), -1);
    rb_define_method(cFXVisual.klass, "destroy", VALUEFUNC(_wrap_FXVisual_destroy), -1);
    cFXVisual.mark = (void (*)(void *)) FXRbVisual::markfunc;
    cFXVisual.destroy = (void (*)(void *)) FXRbVisual::freefunc;
    
    SWIGTYPE_p_FXVisual->dcast = (swig_dycast_func) FXVisual_dynamic_cast;
    
    rb_define_const(mFox,"FONTPITCH_DEFAULT", INT2NUM(FONTPITCH_DEFAULT));
    rb_define_const(mFox,"FONTPITCH_FIXED", INT2NUM(FONTPITCH_FIXED));
    rb_define_const(mFox,"FONTPITCH_VARIABLE", INT2NUM(FONTPITCH_VARIABLE));
    rb_define_const(mFox,"FONTHINT_DONTCARE", INT2NUM(FONTHINT_DONTCARE));
    rb_define_const(mFox,"FONTHINT_DECORATIVE", INT2NUM(FONTHINT_DECORATIVE));
    rb_define_const(mFox,"FONTHINT_MODERN", INT2NUM(FONTHINT_MODERN));
    rb_define_const(mFox,"FONTHINT_ROMAN", INT2NUM(FONTHINT_ROMAN));
    rb_define_const(mFox,"FONTHINT_SCRIPT", INT2NUM(FONTHINT_SCRIPT));
    rb_define_const(mFox,"FONTHINT_SWISS", INT2NUM(FONTHINT_SWISS));
    rb_define_const(mFox,"FONTHINT_SYSTEM", INT2NUM(FONTHINT_SYSTEM));
    rb_define_const(mFox,"FONTHINT_X11", INT2NUM(FONTHINT_X11));
    rb_define_const(mFox,"FONTHINT_SCALABLE", INT2NUM(FONTHINT_SCALABLE));
    rb_define_const(mFox,"FONTHINT_POLYMORPHIC", INT2NUM(FONTHINT_POLYMORPHIC));
    rb_define_const(mFox,"FONTSLANT_DONTCARE", INT2NUM(FONTSLANT_DONTCARE));
    rb_define_const(mFox,"FONTSLANT_REGULAR", INT2NUM(FONTSLANT_REGULAR));
    rb_define_const(mFox,"FONTSLANT_ITALIC", INT2NUM(FONTSLANT_ITALIC));
    rb_define_const(mFox,"FONTSLANT_OBLIQUE", INT2NUM(FONTSLANT_OBLIQUE));
    rb_define_const(mFox,"FONTSLANT_REVERSE_ITALIC", INT2NUM(FONTSLANT_REVERSE_ITALIC));
    rb_define_const(mFox,"FONTSLANT_REVERSE_OBLIQUE", INT2NUM(FONTSLANT_REVERSE_OBLIQUE));
    rb_define_const(mFox,"FONTENCODING_DEFAULT", INT2NUM(FONTENCODING_DEFAULT));
    rb_define_const(mFox,"FONTENCODING_ISO_8859_1", INT2NUM(FONTENCODING_ISO_8859_1));
    rb_define_const(mFox,"FONTENCODING_ISO_8859_2", INT2NUM(FONTENCODING_ISO_8859_2));
    rb_define_const(mFox,"FONTENCODING_ISO_8859_3", INT2NUM(FONTENCODING_ISO_8859_3));
    rb_define_const(mFox,"FONTENCODING_ISO_8859_4", INT2NUM(FONTENCODING_ISO_8859_4));
    rb_define_const(mFox,"FONTENCODING_ISO_8859_5", INT2NUM(FONTENCODING_ISO_8859_5));
    rb_define_const(mFox,"FONTENCODING_ISO_8859_6", INT2NUM(FONTENCODING_ISO_8859_6));
    rb_define_const(mFox,"FONTENCODING_ISO_8859_7", INT2NUM(FONTENCODING_ISO_8859_7));
    rb_define_const(mFox,"FONTENCODING_ISO_8859_8", INT2NUM(FONTENCODING_ISO_8859_8));
    rb_define_const(mFox,"FONTENCODING_ISO_8859_9", INT2NUM(FONTENCODING_ISO_8859_9));
    rb_define_const(mFox,"FONTENCODING_ISO_8859_10", INT2NUM(FONTENCODING_ISO_8859_10));
    rb_define_const(mFox,"FONTENCODING_ISO_8859_11", INT2NUM(FONTENCODING_ISO_8859_11));
    rb_define_const(mFox,"FONTENCODING_ISO_8859_13", INT2NUM(FONTENCODING_ISO_8859_13));
    rb_define_const(mFox,"FONTENCODING_ISO_8859_14", INT2NUM(FONTENCODING_ISO_8859_14));
    rb_define_const(mFox,"FONTENCODING_ISO_8859_15", INT2NUM(FONTENCODING_ISO_8859_15));
    rb_define_const(mFox,"FONTENCODING_ISO_8859_16", INT2NUM(FONTENCODING_ISO_8859_16));
    rb_define_const(mFox,"FONTENCODING_KOI8", INT2NUM(FONTENCODING_KOI8));
    rb_define_const(mFox,"FONTENCODING_KOI8_R", INT2NUM(FONTENCODING_KOI8_R));
    rb_define_const(mFox,"FONTENCODING_KOI8_U", INT2NUM(FONTENCODING_KOI8_U));
    rb_define_const(mFox,"FONTENCODING_KOI8_UNIFIED", INT2NUM(FONTENCODING_KOI8_UNIFIED));
    rb_define_const(mFox,"FONTENCODING_CP437", INT2NUM(FONTENCODING_CP437));
    rb_define_const(mFox,"FONTENCODING_CP850", INT2NUM(FONTENCODING_CP850));
    rb_define_const(mFox,"FONTENCODING_CP851", INT2NUM(FONTENCODING_CP851));
    rb_define_const(mFox,"FONTENCODING_CP852", INT2NUM(FONTENCODING_CP852));
    rb_define_const(mFox,"FONTENCODING_CP855", INT2NUM(FONTENCODING_CP855));
    rb_define_const(mFox,"FONTENCODING_CP856", INT2NUM(FONTENCODING_CP856));
    rb_define_const(mFox,"FONTENCODING_CP857", INT2NUM(FONTENCODING_CP857));
    rb_define_const(mFox,"FONTENCODING_CP860", INT2NUM(FONTENCODING_CP860));
    rb_define_const(mFox,"FONTENCODING_CP861", INT2NUM(FONTENCODING_CP861));
    rb_define_const(mFox,"FONTENCODING_CP862", INT2NUM(FONTENCODING_CP862));
    rb_define_const(mFox,"FONTENCODING_CP863", INT2NUM(FONTENCODING_CP863));
    rb_define_const(mFox,"FONTENCODING_CP864", INT2NUM(FONTENCODING_CP864));
    rb_define_const(mFox,"FONTENCODING_CP865", INT2NUM(FONTENCODING_CP865));
    rb_define_const(mFox,"FONTENCODING_CP866", INT2NUM(FONTENCODING_CP866));
    rb_define_const(mFox,"FONTENCODING_CP869", INT2NUM(FONTENCODING_CP869));
    rb_define_const(mFox,"FONTENCODING_CP870", INT2NUM(FONTENCODING_CP870));
    rb_define_const(mFox,"FONTENCODING_CP1250", INT2NUM(FONTENCODING_CP1250));
    rb_define_const(mFox,"FONTENCODING_CP1251", INT2NUM(FONTENCODING_CP1251));
    rb_define_const(mFox,"FONTENCODING_CP1252", INT2NUM(FONTENCODING_CP1252));
    rb_define_const(mFox,"FONTENCODING_CP1253", INT2NUM(FONTENCODING_CP1253));
    rb_define_const(mFox,"FONTENCODING_CP1254", INT2NUM(FONTENCODING_CP1254));
    rb_define_const(mFox,"FONTENCODING_CP1255", INT2NUM(FONTENCODING_CP1255));
    rb_define_const(mFox,"FONTENCODING_CP1256", INT2NUM(FONTENCODING_CP1256));
    rb_define_const(mFox,"FONTENCODING_CP1257", INT2NUM(FONTENCODING_CP1257));
    rb_define_const(mFox,"FONTENCODING_CP1258", INT2NUM(FONTENCODING_CP1258));
    rb_define_const(mFox,"FONTENCODING_CP874", INT2NUM(FONTENCODING_CP874));
    rb_define_const(mFox,"FONTENCODING_LATIN1", INT2NUM(FONTENCODING_LATIN1));
    rb_define_const(mFox,"FONTENCODING_LATIN2", INT2NUM(FONTENCODING_LATIN2));
    rb_define_const(mFox,"FONTENCODING_LATIN3", INT2NUM(FONTENCODING_LATIN3));
    rb_define_const(mFox,"FONTENCODING_LATIN4", INT2NUM(FONTENCODING_LATIN4));
    rb_define_const(mFox,"FONTENCODING_LATIN5", INT2NUM(FONTENCODING_LATIN5));
    rb_define_const(mFox,"FONTENCODING_LATIN6", INT2NUM(FONTENCODING_LATIN6));
    rb_define_const(mFox,"FONTENCODING_LATIN7", INT2NUM(FONTENCODING_LATIN7));
    rb_define_const(mFox,"FONTENCODING_LATIN8", INT2NUM(FONTENCODING_LATIN8));
    rb_define_const(mFox,"FONTENCODING_LATIN9", INT2NUM(FONTENCODING_LATIN9));
    rb_define_const(mFox,"FONTENCODING_LATIN10", INT2NUM(FONTENCODING_LATIN10));
    rb_define_const(mFox,"FONTENCODING_USASCII", INT2NUM(FONTENCODING_USASCII));
    rb_define_const(mFox,"FONTENCODING_WESTEUROPE", INT2NUM(FONTENCODING_WESTEUROPE));
    rb_define_const(mFox,"FONTENCODING_EASTEUROPE", INT2NUM(FONTENCODING_EASTEUROPE));
    rb_define_const(mFox,"FONTENCODING_SOUTHEUROPE", INT2NUM(FONTENCODING_SOUTHEUROPE));
    rb_define_const(mFox,"FONTENCODING_NORTHEUROPE", INT2NUM(FONTENCODING_NORTHEUROPE));
    rb_define_const(mFox,"FONTENCODING_CYRILLIC", INT2NUM(FONTENCODING_CYRILLIC));
    rb_define_const(mFox,"FONTENCODING_RUSSIAN", INT2NUM(FONTENCODING_RUSSIAN));
    rb_define_const(mFox,"FONTENCODING_ARABIC", INT2NUM(FONTENCODING_ARABIC));
    rb_define_const(mFox,"FONTENCODING_GREEK", INT2NUM(FONTENCODING_GREEK));
    rb_define_const(mFox,"FONTENCODING_HEBREW", INT2NUM(FONTENCODING_HEBREW));
    rb_define_const(mFox,"FONTENCODING_TURKISH", INT2NUM(FONTENCODING_TURKISH));
    rb_define_const(mFox,"FONTENCODING_NORDIC", INT2NUM(FONTENCODING_NORDIC));
    rb_define_const(mFox,"FONTENCODING_THAI", INT2NUM(FONTENCODING_THAI));
    rb_define_const(mFox,"FONTENCODING_BALTIC", INT2NUM(FONTENCODING_BALTIC));
    rb_define_const(mFox,"FONTENCODING_CELTIC", INT2NUM(FONTENCODING_CELTIC));
    rb_define_const(mFox,"FONTWEIGHT_DONTCARE", INT2NUM(FONTWEIGHT_DONTCARE));
    rb_define_const(mFox,"FONTWEIGHT_THIN", INT2NUM(FONTWEIGHT_THIN));
    rb_define_const(mFox,"FONTWEIGHT_EXTRALIGHT", INT2NUM(FONTWEIGHT_EXTRALIGHT));
    rb_define_const(mFox,"FONTWEIGHT_LIGHT", INT2NUM(FONTWEIGHT_LIGHT));
    rb_define_const(mFox,"FONTWEIGHT_NORMAL", INT2NUM(FONTWEIGHT_NORMAL));
    rb_define_const(mFox,"FONTWEIGHT_REGULAR", INT2NUM(FONTWEIGHT_REGULAR));
    rb_define_const(mFox,"FONTWEIGHT_MEDIUM", INT2NUM(FONTWEIGHT_MEDIUM));
    rb_define_const(mFox,"FONTWEIGHT_DEMIBOLD", INT2NUM(FONTWEIGHT_DEMIBOLD));
    rb_define_const(mFox,"FONTWEIGHT_BOLD", INT2NUM(FONTWEIGHT_BOLD));
    rb_define_const(mFox,"FONTWEIGHT_EXTRABOLD", INT2NUM(FONTWEIGHT_EXTRABOLD));
    rb_define_const(mFox,"FONTWEIGHT_HEAVY", INT2NUM(FONTWEIGHT_HEAVY));
    rb_define_const(mFox,"FONTWEIGHT_BLACK", INT2NUM(FONTWEIGHT_BLACK));
    rb_define_const(mFox,"FONTSETWIDTH_DONTCARE", INT2NUM(FONTSETWIDTH_DONTCARE));
    rb_define_const(mFox,"FONTSETWIDTH_ULTRACONDENSED", INT2NUM(FONTSETWIDTH_ULTRACONDENSED));
    rb_define_const(mFox,"FONTSETWIDTH_EXTRACONDENSED", INT2NUM(FONTSETWIDTH_EXTRACONDENSED));
    rb_define_const(mFox,"FONTSETWIDTH_CONDENSED", INT2NUM(FONTSETWIDTH_CONDENSED));
    rb_define_const(mFox,"FONTSETWIDTH_NARROW", INT2NUM(FONTSETWIDTH_NARROW));
    rb_define_const(mFox,"FONTSETWIDTH_COMPRESSED", INT2NUM(FONTSETWIDTH_COMPRESSED));
    rb_define_const(mFox,"FONTSETWIDTH_SEMICONDENSED", INT2NUM(FONTSETWIDTH_SEMICONDENSED));
    rb_define_const(mFox,"FONTSETWIDTH_MEDIUM", INT2NUM(FONTSETWIDTH_MEDIUM));
    rb_define_const(mFox,"FONTSETWIDTH_NORMAL", INT2NUM(FONTSETWIDTH_NORMAL));
    rb_define_const(mFox,"FONTSETWIDTH_REGULAR", INT2NUM(FONTSETWIDTH_REGULAR));
    rb_define_const(mFox,"FONTSETWIDTH_SEMIEXPANDED", INT2NUM(FONTSETWIDTH_SEMIEXPANDED));
    rb_define_const(mFox,"FONTSETWIDTH_EXPANDED", INT2NUM(FONTSETWIDTH_EXPANDED));
    rb_define_const(mFox,"FONTSETWIDTH_WIDE", INT2NUM(FONTSETWIDTH_WIDE));
    rb_define_const(mFox,"FONTSETWIDTH_EXTRAEXPANDED", INT2NUM(FONTSETWIDTH_EXTRAEXPANDED));
    rb_define_const(mFox,"FONTSETWIDTH_ULTRAEXPANDED", INT2NUM(FONTSETWIDTH_ULTRAEXPANDED));
    
    cFXFontDesc.klass = rb_define_class_under(mFox, "FXFontDesc", rb_cObject);
    SWIG_TypeClientData(SWIGTYPE_p_FXFontDesc, (void *) &cFXFontDesc);
    rb_define_alloc_func(cFXFontDesc.klass, _wrap_FXFontDesc_allocate);
    rb_define_method(cFXFontDesc.klass, "initialize", VALUEFUNC(_wrap_new_FXFontDesc), -1);
    rb_define_method(cFXFontDesc.klass, "face=", VALUEFUNC(_wrap_FXFontDesc_face_set), -1);
    rb_define_method(cFXFontDesc.klass, "face", VALUEFUNC(_wrap_FXFontDesc_face_get), -1);
    rb_define_method(cFXFontDesc.klass, "size=", VALUEFUNC(_wrap_FXFontDesc_size_set), -1);
    rb_define_method(cFXFontDesc.klass, "size", VALUEFUNC(_wrap_FXFontDesc_size_get), -1);
    rb_define_method(cFXFontDesc.klass, "weight=", VALUEFUNC(_wrap_FXFontDesc_weight_set), -1);
    rb_define_method(cFXFontDesc.klass, "weight", VALUEFUNC(_wrap_FXFontDesc_weight_get), -1);
    rb_define_method(cFXFontDesc.klass, "slant=", VALUEFUNC(_wrap_FXFontDesc_slant_set), -1);
    rb_define_method(cFXFontDesc.klass, "slant", VALUEFUNC(_wrap_FXFontDesc_slant_get), -1);
    rb_define_method(cFXFontDesc.klass, "setwidth=", VALUEFUNC(_wrap_FXFontDesc_setwidth_set), -1);
    rb_define_method(cFXFontDesc.klass, "setwidth", VALUEFUNC(_wrap_FXFontDesc_setwidth_get), -1);
    rb_define_method(cFXFontDesc.klass, "encoding=", VALUEFUNC(_wrap_FXFontDesc_encoding_set), -1);
    rb_define_method(cFXFontDesc.klass, "encoding", VALUEFUNC(_wrap_FXFontDesc_encoding_get), -1);
    rb_define_method(cFXFontDesc.klass, "flags=", VALUEFUNC(_wrap_FXFontDesc_flags_set), -1);
    rb_define_method(cFXFontDesc.klass, "flags", VALUEFUNC(_wrap_FXFontDesc_flags_get), -1);
    cFXFontDesc.mark = 0;
    cFXFontDesc.destroy = (void (*)(void *)) FXRbUnregisterRubyObj;
    
    cFXFont.klass = rb_define_class_under(mFox, "FXFont", ((swig_class *) SWIGTYPE_p_FXId->clientdata)->klass);
    SWIG_TypeClientData(SWIGTYPE_p_FXFont, (void *) &cFXFont);
    rb_define_alloc_func(cFXFont.klass, _wrap_FXFont_allocate);
    rb_define_method(cFXFont.klass, "initialize", VALUEFUNC(_wrap_new_FXFont), -1);
    rb_define_method(cFXFont.klass, "getName", VALUEFUNC(_wrap_FXFont_getName), -1);
    rb_define_method(cFXFont.klass, "getActualName", VALUEFUNC(_wrap_FXFont_getActualName), -1);
    rb_define_method(cFXFont.klass, "getSize", VALUEFUNC(_wrap_FXFont_getSize), -1);
    rb_define_method(cFXFont.klass, "getActualSize", VALUEFUNC(_wrap_FXFont_getActualSize), -1);
    rb_define_method(cFXFont.klass, "getWeight", VALUEFUNC(_wrap_FXFont_getWeight), -1);
    rb_define_method(cFXFont.klass, "getActualWeight", VALUEFUNC(_wrap_FXFont_getActualWeight), -1);
    rb_define_method(cFXFont.klass, "getSlant", VALUEFUNC(_wrap_FXFont_getSlant), -1);
    rb_define_method(cFXFont.klass, "getActualSlant", VALUEFUNC(_wrap_FXFont_getActualSlant), -1);
    rb_define_method(cFXFont.klass, "getEncoding", VALUEFUNC(_wrap_FXFont_getEncoding), -1);
    rb_define_method(cFXFont.klass, "getActualEncoding", VALUEFUNC(_wrap_FXFont_getActualEncoding), -1);
    rb_define_method(cFXFont.klass, "getSetWidth", VALUEFUNC(_wrap_FXFont_getSetWidth), -1);
    rb_define_method(cFXFont.klass, "getActualSetWidth", VALUEFUNC(_wrap_FXFont_getActualSetWidth), -1);
    rb_define_method(cFXFont.klass, "getHints", VALUEFUNC(_wrap_FXFont_getHints), -1);
    rb_define_method(cFXFont.klass, "setFontDesc", VALUEFUNC(_wrap_FXFont_setFontDesc), -1);
    rb_define_method(cFXFont.klass, "getFontDesc", VALUEFUNC(_wrap_FXFont_getFontDesc), -1);
    rb_define_method(cFXFont.klass, "setFont", VALUEFUNC(_wrap_FXFont_setFont), -1);
    rb_define_method(cFXFont.klass, "getFont", VALUEFUNC(_wrap_FXFont_getFont), -1);
    rb_define_method(cFXFont.klass, "isFontMono", VALUEFUNC(_wrap_FXFont_isFontMono), -1);
    rb_define_method(cFXFont.klass, "hasChar", VALUEFUNC(_wrap_FXFont_hasChar), -1);
    rb_define_method(cFXFont.klass, "getMinChar", VALUEFUNC(_wrap_FXFont_getMinChar), -1);
    rb_define_method(cFXFont.klass, "getMaxChar", VALUEFUNC(_wrap_FXFont_getMaxChar), -1);
    rb_define_method(cFXFont.klass, "leftBearing", VALUEFUNC(_wrap_FXFont_leftBearing), -1);
    rb_define_method(cFXFont.klass, "rightBearing", VALUEFUNC(_wrap_FXFont_rightBearing), -1);
    rb_define_method(cFXFont.klass, "getFontWidth", VALUEFUNC(_wrap_FXFont_getFontWidth), -1);
    rb_define_method(cFXFont.klass, "getFontHeight", VALUEFUNC(_wrap_FXFont_getFontHeight), -1);
    rb_define_method(cFXFont.klass, "getFontAscent", VALUEFUNC(_wrap_FXFont_getFontAscent), -1);
    rb_define_method(cFXFont.klass, "getFontDescent", VALUEFUNC(_wrap_FXFont_getFontDescent), -1);
    rb_define_method(cFXFont.klass, "getFontLeading", VALUEFUNC(_wrap_FXFont_getFontLeading), -1);
    rb_define_method(cFXFont.klass, "getFontSpacing", VALUEFUNC(_wrap_FXFont_getFontSpacing), -1);
    rb_define_method(cFXFont.klass, "getTextWidth", VALUEFUNC(_wrap_FXFont_getTextWidth), -1);
    rb_define_method(cFXFont.klass, "getTextHeight", VALUEFUNC(_wrap_FXFont_getTextHeight), -1);
    rb_define_singleton_method(cFXFont.klass, "listFonts", VALUEFUNC(_wrap_FXFont_listFonts), -1);
    rb_define_method(cFXFont.klass, "save", VALUEFUNC(_wrap_FXFont_save), -1);
    rb_define_method(cFXFont.klass, "load", VALUEFUNC(_wrap_FXFont_load), -1);
    rb_define_method(cFXFont.klass, "create", VALUEFUNC(_wrap_FXFont_create), -1);
    rb_define_method(cFXFont.klass, "detach", VALUEFUNC(_wrap_FXFont_detach), -1);
    rb_define_method(cFXFont.klass, "destroy", VALUEFUNC(_wrap_FXFont_destroy), -1);
    cFXFont.mark = (void (*)(void *)) FXRbFont::markfunc;
    cFXFont.destroy = (void (*)(void *)) FXRbFont::freefunc;
    rb_define_module_function(mFox, "fxparsefontdesc", VALUEFUNC(_wrap_fxparsefontdesc), -1);
    rb_define_module_function(mFox, "fxunparsefontdesc", VALUEFUNC(_wrap_fxunparsefontdesc), -1);
    rb_define_const(mFox,"LAYOUT_NORMAL", INT2NUM(LAYOUT_NORMAL));
    rb_define_const(mFox,"LAYOUT_SIDE_TOP", INT2NUM(LAYOUT_SIDE_TOP));
    rb_define_const(mFox,"LAYOUT_SIDE_BOTTOM", INT2NUM(LAYOUT_SIDE_BOTTOM));
    rb_define_const(mFox,"LAYOUT_SIDE_LEFT", INT2NUM(LAYOUT_SIDE_LEFT));
    rb_define_const(mFox,"LAYOUT_SIDE_RIGHT", INT2NUM(LAYOUT_SIDE_RIGHT));
    rb_define_const(mFox,"LAYOUT_FILL_COLUMN", INT2NUM(LAYOUT_FILL_COLUMN));
    rb_define_const(mFox,"LAYOUT_FILL_ROW", INT2NUM(LAYOUT_FILL_ROW));
    rb_define_const(mFox,"LAYOUT_LEFT", INT2NUM(LAYOUT_LEFT));
    rb_define_const(mFox,"LAYOUT_RIGHT", INT2NUM(LAYOUT_RIGHT));
    rb_define_const(mFox,"LAYOUT_CENTER_X", INT2NUM(LAYOUT_CENTER_X));
    rb_define_const(mFox,"LAYOUT_FIX_X", INT2NUM(LAYOUT_FIX_X));
    rb_define_const(mFox,"LAYOUT_TOP", INT2NUM(LAYOUT_TOP));
    rb_define_const(mFox,"LAYOUT_BOTTOM", INT2NUM(LAYOUT_BOTTOM));
    rb_define_const(mFox,"LAYOUT_CENTER_Y", INT2NUM(LAYOUT_CENTER_Y));
    rb_define_const(mFox,"LAYOUT_FIX_Y", INT2NUM(LAYOUT_FIX_Y));
    rb_define_const(mFox,"LAYOUT_RESERVED_1", INT2NUM(LAYOUT_RESERVED_1));
    rb_define_const(mFox,"LAYOUT_RESERVED_2", INT2NUM(LAYOUT_RESERVED_2));
    rb_define_const(mFox,"LAYOUT_FIX_WIDTH", INT2NUM(LAYOUT_FIX_WIDTH));
    rb_define_const(mFox,"LAYOUT_FIX_HEIGHT", INT2NUM(LAYOUT_FIX_HEIGHT));
    rb_define_const(mFox,"LAYOUT_MIN_WIDTH", INT2NUM(LAYOUT_MIN_WIDTH));
    rb_define_const(mFox,"LAYOUT_MIN_HEIGHT", INT2NUM(LAYOUT_MIN_HEIGHT));
    rb_define_const(mFox,"LAYOUT_FILL_X", INT2NUM(LAYOUT_FILL_X));
    rb_define_const(mFox,"LAYOUT_FILL_Y", INT2NUM(LAYOUT_FILL_Y));
    rb_define_const(mFox,"LAYOUT_FILL", INT2NUM(LAYOUT_FILL));
    rb_define_const(mFox,"LAYOUT_EXPLICIT", INT2NUM(LAYOUT_EXPLICIT));
    rb_define_const(mFox,"FRAME_NONE", INT2NUM(FRAME_NONE));
    rb_define_const(mFox,"FRAME_SUNKEN", INT2NUM(FRAME_SUNKEN));
    rb_define_const(mFox,"FRAME_RAISED", INT2NUM(FRAME_RAISED));
    rb_define_const(mFox,"FRAME_THICK", INT2NUM(FRAME_THICK));
    rb_define_const(mFox,"FRAME_GROOVE", INT2NUM(FRAME_GROOVE));
    rb_define_const(mFox,"FRAME_RIDGE", INT2NUM(FRAME_RIDGE));
    rb_define_const(mFox,"FRAME_LINE", INT2NUM(FRAME_LINE));
    rb_define_const(mFox,"FRAME_NORMAL", INT2NUM(FRAME_NORMAL));
    rb_define_const(mFox,"PACK_NORMAL", INT2NUM(PACK_NORMAL));
    rb_define_const(mFox,"PACK_UNIFORM_HEIGHT", INT2NUM(PACK_UNIFORM_HEIGHT));
    rb_define_const(mFox,"PACK_UNIFORM_WIDTH", INT2NUM(PACK_UNIFORM_WIDTH));
    
    cFXWindow.klass = rb_define_class_under(mFox, "FXWindow", ((swig_class *) SWIGTYPE_p_FXDrawable->clientdata)->klass);
    SWIG_TypeClientData(SWIGTYPE_p_FXWindow, (void *) &cFXWindow);
    rb_define_alloc_func(cFXWindow.klass, _wrap_FXWindow_allocate);
    rb_define_method(cFXWindow.klass, "initialize", VALUEFUNC(_wrap_new_FXWindow), -1);
    rb_define_singleton_method(cFXWindow.klass, "deleteType", VALUEFUNC(FXWindow_deleteType_get), 0);
    rb_define_singleton_method(cFXWindow.klass, "deleteType=", VALUEFUNC(FXWindow_deleteType_set), 1);
    rb_define_singleton_method(cFXWindow.klass, "textType", VALUEFUNC(FXWindow_textType_get), 0);
    rb_define_singleton_method(cFXWindow.klass, "textType=", VALUEFUNC(FXWindow_textType_set), 1);
    rb_define_singleton_method(cFXWindow.klass, "colorType", VALUEFUNC(FXWindow_colorType_get), 0);
    rb_define_singleton_method(cFXWindow.klass, "colorType=", VALUEFUNC(FXWindow_colorType_set), 1);
    rb_define_singleton_method(cFXWindow.klass, "urilistType", VALUEFUNC(FXWindow_urilistType_get), 0);
    rb_define_singleton_method(cFXWindow.klass, "urilistType=", VALUEFUNC(FXWindow_urilistType_set), 1);
    rb_define_singleton_method(cFXWindow.klass, "stringType", VALUEFUNC(FXWindow_stringType_get), 0);
    rb_define_singleton_method(cFXWindow.klass, "imageType", VALUEFUNC(FXWindow_imageType_get), 0);
    rb_define_method(cFXWindow.klass, "onPaint", VALUEFUNC(_wrap_FXWindow_onPaint), -1);
    rb_define_method(cFXWindow.klass, "onMap", VALUEFUNC(_wrap_FXWindow_onMap), -1);
    rb_define_method(cFXWindow.klass, "onUnmap", VALUEFUNC(_wrap_FXWindow_onUnmap), -1);
    rb_define_method(cFXWindow.klass, "onConfigure", VALUEFUNC(_wrap_FXWindow_onConfigure), -1);
    rb_define_method(cFXWindow.klass, "onUpdate", VALUEFUNC(_wrap_FXWindow_onUpdate), -1);
    rb_define_method(cFXWindow.klass, "onMotion", VALUEFUNC(_wrap_FXWindow_onMotion), -1);
    rb_define_method(cFXWindow.klass, "onMouseWheel", VALUEFUNC(_wrap_FXWindow_onMouseWheel), -1);
    rb_define_method(cFXWindow.klass, "onEnter", VALUEFUNC(_wrap_FXWindow_onEnter), -1);
    rb_define_method(cFXWindow.klass, "onLeave", VALUEFUNC(_wrap_FXWindow_onLeave), -1);
    rb_define_method(cFXWindow.klass, "onLeftBtnPress", VALUEFUNC(_wrap_FXWindow_onLeftBtnPress), -1);
    rb_define_method(cFXWindow.klass, "onLeftBtnRelease", VALUEFUNC(_wrap_FXWindow_onLeftBtnRelease), -1);
    rb_define_method(cFXWindow.klass, "onMiddleBtnPress", VALUEFUNC(_wrap_FXWindow_onMiddleBtnPress), -1);
    rb_define_method(cFXWindow.klass, "onMiddleBtnRelease", VALUEFUNC(_wrap_FXWindow_onMiddleBtnRelease), -1);
    rb_define_method(cFXWindow.klass, "onRightBtnPress", VALUEFUNC(_wrap_FXWindow_onRightBtnPress), -1);
    rb_define_method(cFXWindow.klass, "onRightBtnRelease", VALUEFUNC(_wrap_FXWindow_onRightBtnRelease), -1);
    rb_define_method(cFXWindow.klass, "onBeginDrag", VALUEFUNC(_wrap_FXWindow_onBeginDrag), -1);
    rb_define_method(cFXWindow.klass, "onEndDrag", VALUEFUNC(_wrap_FXWindow_onEndDrag), -1);
    rb_define_method(cFXWindow.klass, "onDragged", VALUEFUNC(_wrap_FXWindow_onDragged), -1);
    rb_define_method(cFXWindow.klass, "onKeyPress", VALUEFUNC(_wrap_FXWindow_onKeyPress), -1);
    rb_define_method(cFXWindow.klass, "onKeyRelease", VALUEFUNC(_wrap_FXWindow_onKeyRelease), -1);
    rb_define_method(cFXWindow.klass, "onUngrabbed", VALUEFUNC(_wrap_FXWindow_onUngrabbed), -1);
    rb_define_method(cFXWindow.klass, "onDestroy", VALUEFUNC(_wrap_FXWindow_onDestroy), -1);
    rb_define_method(cFXWindow.klass, "onFocusSelf", VALUEFUNC(_wrap_FXWindow_onFocusSelf), -1);
    rb_define_method(cFXWindow.klass, "onFocusIn", VALUEFUNC(_wrap_FXWindow_onFocusIn), -1);
    rb_define_method(cFXWindow.klass, "onFocusOut", VALUEFUNC(_wrap_FXWindow_onFocusOut), -1);
    rb_define_method(cFXWindow.klass, "onSelectionLost", VALUEFUNC(_wrap_FXWindow_onSelectionLost), -1);
    rb_define_method(cFXWindow.klass, "onSelectionGained", VALUEFUNC(_wrap_FXWindow_onSelectionGained), -1);
    rb_define_method(cFXWindow.klass, "onSelectionRequest", VALUEFUNC(_wrap_FXWindow_onSelectionRequest), -1);
    rb_define_method(cFXWindow.klass, "onClipboardLost", VALUEFUNC(_wrap_FXWindow_onClipboardLost), -1);
    rb_define_method(cFXWindow.klass, "onClipboardGained", VALUEFUNC(_wrap_FXWindow_onClipboardGained), -1);
    rb_define_method(cFXWindow.klass, "onClipboardRequest", VALUEFUNC(_wrap_FXWindow_onClipboardRequest), -1);
    rb_define_method(cFXWindow.klass, "onDNDEnter", VALUEFUNC(_wrap_FXWindow_onDNDEnter), -1);
    rb_define_method(cFXWindow.klass, "onDNDLeave", VALUEFUNC(_wrap_FXWindow_onDNDLeave), -1);
    rb_define_method(cFXWindow.klass, "onDNDMotion", VALUEFUNC(_wrap_FXWindow_onDNDMotion), -1);
    rb_define_method(cFXWindow.klass, "onDNDDrop", VALUEFUNC(_wrap_FXWindow_onDNDDrop), -1);
    rb_define_method(cFXWindow.klass, "onDNDRequest", VALUEFUNC(_wrap_FXWindow_onDNDRequest), -1);
    rb_define_method(cFXWindow.klass, "onCmdShow", VALUEFUNC(_wrap_FXWindow_onCmdShow), -1);
    rb_define_method(cFXWindow.klass, "onCmdHide", VALUEFUNC(_wrap_FXWindow_onCmdHide), -1);
    rb_define_method(cFXWindow.klass, "onUpdToggleShown", VALUEFUNC(_wrap_FXWindow_onUpdToggleShown), -1);
    rb_define_method(cFXWindow.klass, "onCmdToggleShown", VALUEFUNC(_wrap_FXWindow_onCmdToggleShown), -1);
    rb_define_method(cFXWindow.klass, "onCmdRaise", VALUEFUNC(_wrap_FXWindow_onCmdRaise), -1);
    rb_define_method(cFXWindow.klass, "onCmdLower", VALUEFUNC(_wrap_FXWindow_onCmdLower), -1);
    rb_define_method(cFXWindow.klass, "onCmdEnable", VALUEFUNC(_wrap_FXWindow_onCmdEnable), -1);
    rb_define_method(cFXWindow.klass, "onCmdDisable", VALUEFUNC(_wrap_FXWindow_onCmdDisable), -1);
    rb_define_method(cFXWindow.klass, "onCmdUpdate", VALUEFUNC(_wrap_FXWindow_onCmdUpdate), -1);
    rb_define_method(cFXWindow.klass, "onUpdYes", VALUEFUNC(_wrap_FXWindow_onUpdYes), -1);
    rb_define_method(cFXWindow.klass, "onCmdDelete", VALUEFUNC(_wrap_FXWindow_onCmdDelete), -1);
    rb_define_const(cFXWindow.klass,"ID_NONE", INT2NUM(FXWindow::ID_NONE));
    rb_define_const(cFXWindow.klass,"ID_HIDE", INT2NUM(FXWindow::ID_HIDE));
    rb_define_const(cFXWindow.klass,"ID_SHOW", INT2NUM(FXWindow::ID_SHOW));
    rb_define_const(cFXWindow.klass,"ID_TOGGLESHOWN", INT2NUM(FXWindow::ID_TOGGLESHOWN));
    rb_define_const(cFXWindow.klass,"ID_LOWER", INT2NUM(FXWindow::ID_LOWER));
    rb_define_const(cFXWindow.klass,"ID_RAISE", INT2NUM(FXWindow::ID_RAISE));
    rb_define_const(cFXWindow.klass,"ID_DELETE", INT2NUM(FXWindow::ID_DELETE));
    rb_define_const(cFXWindow.klass,"ID_DISABLE", INT2NUM(FXWindow::ID_DISABLE));
    rb_define_const(cFXWindow.klass,"ID_ENABLE", INT2NUM(FXWindow::ID_ENABLE));
    rb_define_const(cFXWindow.klass,"ID_UNCHECK", INT2NUM(FXWindow::ID_UNCHECK));
    rb_define_const(cFXWindow.klass,"ID_CHECK", INT2NUM(FXWindow::ID_CHECK));
    rb_define_const(cFXWindow.klass,"ID_UNKNOWN", INT2NUM(FXWindow::ID_UNKNOWN));
    rb_define_const(cFXWindow.klass,"ID_UPDATE", INT2NUM(FXWindow::ID_UPDATE));
    rb_define_const(cFXWindow.klass,"ID_AUTOSCROLL", INT2NUM(FXWindow::ID_AUTOSCROLL));
    rb_define_const(cFXWindow.klass,"ID_TIPTIMER", INT2NUM(FXWindow::ID_TIPTIMER));
    rb_define_const(cFXWindow.klass,"ID_HSCROLLED", INT2NUM(FXWindow::ID_HSCROLLED));
    rb_define_const(cFXWindow.klass,"ID_VSCROLLED", INT2NUM(FXWindow::ID_VSCROLLED));
    rb_define_const(cFXWindow.klass,"ID_SETVALUE", INT2NUM(FXWindow::ID_SETVALUE));
    rb_define_const(cFXWindow.klass,"ID_SETINTVALUE", INT2NUM(FXWindow::ID_SETINTVALUE));
    rb_define_const(cFXWindow.klass,"ID_SETREALVALUE", INT2NUM(FXWindow::ID_SETREALVALUE));
    rb_define_const(cFXWindow.klass,"ID_SETSTRINGVALUE", INT2NUM(FXWindow::ID_SETSTRINGVALUE));
    rb_define_const(cFXWindow.klass,"ID_SETICONVALUE", INT2NUM(FXWindow::ID_SETICONVALUE));
    rb_define_const(cFXWindow.klass,"ID_SETINTRANGE", INT2NUM(FXWindow::ID_SETINTRANGE));
    rb_define_const(cFXWindow.klass,"ID_SETREALRANGE", INT2NUM(FXWindow::ID_SETREALRANGE));
    rb_define_const(cFXWindow.klass,"ID_GETINTVALUE", INT2NUM(FXWindow::ID_GETINTVALUE));
    rb_define_const(cFXWindow.klass,"ID_GETREALVALUE", INT2NUM(FXWindow::ID_GETREALVALUE));
    rb_define_const(cFXWindow.klass,"ID_GETSTRINGVALUE", INT2NUM(FXWindow::ID_GETSTRINGVALUE));
    rb_define_const(cFXWindow.klass,"ID_GETICONVALUE", INT2NUM(FXWindow::ID_GETICONVALUE));
    rb_define_const(cFXWindow.klass,"ID_GETINTRANGE", INT2NUM(FXWindow::ID_GETINTRANGE));
    rb_define_const(cFXWindow.klass,"ID_GETREALRANGE", INT2NUM(FXWindow::ID_GETREALRANGE));
    rb_define_const(cFXWindow.klass,"ID_SETHELPSTRING", INT2NUM(FXWindow::ID_SETHELPSTRING));
    rb_define_const(cFXWindow.klass,"ID_GETHELPSTRING", INT2NUM(FXWindow::ID_GETHELPSTRING));
    rb_define_const(cFXWindow.klass,"ID_SETTIPSTRING", INT2NUM(FXWindow::ID_SETTIPSTRING));
    rb_define_const(cFXWindow.klass,"ID_GETTIPSTRING", INT2NUM(FXWindow::ID_GETTIPSTRING));
    rb_define_const(cFXWindow.klass,"ID_QUERY_TIP", INT2NUM(FXWindow::ID_QUERY_TIP));
    rb_define_const(cFXWindow.klass,"ID_QUERY_HELP", INT2NUM(FXWindow::ID_QUERY_HELP));
    rb_define_const(cFXWindow.klass,"ID_QUERY_MENU", INT2NUM(FXWindow::ID_QUERY_MENU));
    rb_define_const(cFXWindow.klass,"ID_HOTKEY", INT2NUM(FXWindow::ID_HOTKEY));
    rb_define_const(cFXWindow.klass,"ID_ACCEL", INT2NUM(FXWindow::ID_ACCEL));
    rb_define_const(cFXWindow.klass,"ID_UNPOST", INT2NUM(FXWindow::ID_UNPOST));
    rb_define_const(cFXWindow.klass,"ID_POST", INT2NUM(FXWindow::ID_POST));
    rb_define_const(cFXWindow.klass,"ID_MDI_TILEHORIZONTAL", INT2NUM(FXWindow::ID_MDI_TILEHORIZONTAL));
    rb_define_const(cFXWindow.klass,"ID_MDI_TILEVERTICAL", INT2NUM(FXWindow::ID_MDI_TILEVERTICAL));
    rb_define_const(cFXWindow.klass,"ID_MDI_CASCADE", INT2NUM(FXWindow::ID_MDI_CASCADE));
    rb_define_const(cFXWindow.klass,"ID_MDI_MAXIMIZE", INT2NUM(FXWindow::ID_MDI_MAXIMIZE));
    rb_define_const(cFXWindow.klass,"ID_MDI_MINIMIZE", INT2NUM(FXWindow::ID_MDI_MINIMIZE));
    rb_define_const(cFXWindow.klass,"ID_MDI_RESTORE", INT2NUM(FXWindow::ID_MDI_RESTORE));
    rb_define_const(cFXWindow.klass,"ID_MDI_CLOSE", INT2NUM(FXWindow::ID_MDI_CLOSE));
    rb_define_const(cFXWindow.klass,"ID_MDI_WINDOW", INT2NUM(FXWindow::ID_MDI_WINDOW));
    rb_define_const(cFXWindow.klass,"ID_MDI_MENUWINDOW", INT2NUM(FXWindow::ID_MDI_MENUWINDOW));
    rb_define_const(cFXWindow.klass,"ID_MDI_MENUMINIMIZE", INT2NUM(FXWindow::ID_MDI_MENUMINIMIZE));
    rb_define_const(cFXWindow.klass,"ID_MDI_MENURESTORE", INT2NUM(FXWindow::ID_MDI_MENURESTORE));
    rb_define_const(cFXWindow.klass,"ID_MDI_MENUCLOSE", INT2NUM(FXWindow::ID_MDI_MENUCLOSE));
    rb_define_const(cFXWindow.klass,"ID_MDI_NEXT", INT2NUM(FXWindow::ID_MDI_NEXT));
    rb_define_const(cFXWindow.klass,"ID_MDI_PREV", INT2NUM(FXWindow::ID_MDI_PREV));
    rb_define_const(cFXWindow.klass,"ID_LAST", INT2NUM(FXWindow::ID_LAST));
    rb_define_singleton_method(cFXWindow.klass, "deleteTypeName", VALUEFUNC(_wrap_FXWindow_deleteTypeName), -1);
    rb_define_singleton_method(cFXWindow.klass, "textTypeName", VALUEFUNC(_wrap_FXWindow_textTypeName), -1);
    rb_define_singleton_method(cFXWindow.klass, "colorTypeName", VALUEFUNC(_wrap_FXWindow_colorTypeName), -1);
    rb_define_singleton_method(cFXWindow.klass, "urilistTypeName", VALUEFUNC(_wrap_FXWindow_urilistTypeName), -1);
    rb_define_method(cFXWindow.klass, "getParent", VALUEFUNC(_wrap_FXWindow_getParent), -1);
    rb_define_method(cFXWindow.klass, "getOwner", VALUEFUNC(_wrap_FXWindow_getOwner), -1);
    rb_define_method(cFXWindow.klass, "getShell", VALUEFUNC(_wrap_FXWindow_getShell), -1);
    rb_define_method(cFXWindow.klass, "getRoot", VALUEFUNC(_wrap_FXWindow_getRoot), -1);
    rb_define_method(cFXWindow.klass, "getNext", VALUEFUNC(_wrap_FXWindow_getNext), -1);
    rb_define_method(cFXWindow.klass, "getPrev", VALUEFUNC(_wrap_FXWindow_getPrev), -1);
    rb_define_method(cFXWindow.klass, "getFirst", VALUEFUNC(_wrap_FXWindow_getFirst), -1);
    rb_define_method(cFXWindow.klass, "getLast", VALUEFUNC(_wrap_FXWindow_getLast), -1);
    rb_define_method(cFXWindow.klass, "getFocus", VALUEFUNC(_wrap_FXWindow_getFocus), -1);
    rb_define_method(cFXWindow.klass, "setKey", VALUEFUNC(_wrap_FXWindow_setKey), -1);
    rb_define_method(cFXWindow.klass, "getKey", VALUEFUNC(_wrap_FXWindow_getKey), -1);
    rb_define_method(cFXWindow.klass, "setTarget", VALUEFUNC(_wrap_FXWindow_setTarget), -1);
    rb_define_method(cFXWindow.klass, "getTarget", VALUEFUNC(_wrap_FXWindow_getTarget), -1);
    rb_define_method(cFXWindow.klass, "setSelector", VALUEFUNC(_wrap_FXWindow_setSelector), -1);
    rb_define_method(cFXWindow.klass, "getSelector", VALUEFUNC(_wrap_FXWindow_getSelector), -1);
    rb_define_method(cFXWindow.klass, "getX", VALUEFUNC(_wrap_FXWindow_getX), -1);
    rb_define_method(cFXWindow.klass, "getY", VALUEFUNC(_wrap_FXWindow_getY), -1);
    rb_define_method(cFXWindow.klass, "setX", VALUEFUNC(_wrap_FXWindow_setX), -1);
    rb_define_method(cFXWindow.klass, "setY", VALUEFUNC(_wrap_FXWindow_setY), -1);
    rb_define_method(cFXWindow.klass, "setWidth", VALUEFUNC(_wrap_FXWindow_setWidth), -1);
    rb_define_method(cFXWindow.klass, "setHeight", VALUEFUNC(_wrap_FXWindow_setHeight), -1);
    rb_define_method(cFXWindow.klass, "setLayoutHints", VALUEFUNC(_wrap_FXWindow_setLayoutHints), -1);
    rb_define_method(cFXWindow.klass, "getLayoutHints", VALUEFUNC(_wrap_FXWindow_getLayoutHints), -1);
    rb_define_method(cFXWindow.klass, "getAccelTable", VALUEFUNC(_wrap_FXWindow_getAccelTable), -1);
    rb_define_method(cFXWindow.klass, "setAccelTable", VALUEFUNC(_wrap_FXWindow_setAccelTable), -1);
    rb_define_method(cFXWindow.klass, "addHotKey", VALUEFUNC(_wrap_FXWindow_addHotKey), -1);
    rb_define_method(cFXWindow.klass, "remHotKey", VALUEFUNC(_wrap_FXWindow_remHotKey), -1);
    rb_define_method(cFXWindow.klass, "setHelpTag", VALUEFUNC(_wrap_FXWindow_setHelpTag), -1);
    rb_define_method(cFXWindow.klass, "getHelpTag", VALUEFUNC(_wrap_FXWindow_getHelpTag), -1);
    rb_define_method(cFXWindow.klass, "isShell", VALUEFUNC(_wrap_FXWindow_isShell), -1);
    rb_define_method(cFXWindow.klass, "isOwnerOf", VALUEFUNC(_wrap_FXWindow_isOwnerOf), -1);
    rb_define_method(cFXWindow.klass, "isChildOf", VALUEFUNC(_wrap_FXWindow_isChildOf), -1);
    rb_define_method(cFXWindow.klass, "containsChild", VALUEFUNC(_wrap_FXWindow_containsChild), -1);
    rb_define_method(cFXWindow.klass, "getChildAt", VALUEFUNC(_wrap_FXWindow_getChildAt), -1);
    rb_define_method(cFXWindow.klass, "numChildren", VALUEFUNC(_wrap_FXWindow_numChildren), -1);
    rb_define_method(cFXWindow.klass, "indexOfChild", VALUEFUNC(_wrap_FXWindow_indexOfChild), -1);
    rb_define_method(cFXWindow.klass, "removeChild", VALUEFUNC(_wrap_FXWindow_removeChild), -1);
    rb_define_method(cFXWindow.klass, "getChildren", VALUEFUNC(_wrap_FXWindow_getChildren), -1);
    rb_define_method(cFXWindow.klass, "childAtIndex", VALUEFUNC(_wrap_FXWindow_childAtIndex), -1);
    rb_define_singleton_method(cFXWindow.klass, "commonAncestor", VALUEFUNC(_wrap_FXWindow_commonAncestor), -1);
    rb_define_singleton_method(cFXWindow.klass, "windowCount", VALUEFUNC(_wrap_FXWindow_windowCount), -1);
    rb_define_method(cFXWindow.klass, "setDefaultCursor", VALUEFUNC(_wrap_FXWindow_setDefaultCursor), -1);
    rb_define_method(cFXWindow.klass, "getDefaultCursor", VALUEFUNC(_wrap_FXWindow_getDefaultCursor), -1);
    rb_define_method(cFXWindow.klass, "setDragCursor", VALUEFUNC(_wrap_FXWindow_setDragCursor), -1);
    rb_define_method(cFXWindow.klass, "getDragCursor", VALUEFUNC(_wrap_FXWindow_getDragCursor), -1);
    rb_define_method(cFXWindow.klass, "getCursorPosition", VALUEFUNC(_wrap_FXWindow_getCursorPosition), -1);
    rb_define_method(cFXWindow.klass, "setCursorPosition", VALUEFUNC(_wrap_FXWindow_setCursorPosition), -1);
    rb_define_method(cFXWindow.klass, "isEnabled", VALUEFUNC(_wrap_FXWindow_isEnabled), -1);
    rb_define_method(cFXWindow.klass, "isActive", VALUEFUNC(_wrap_FXWindow_isActive), -1);
    rb_define_method(cFXWindow.klass, "hasFocus", VALUEFUNC(_wrap_FXWindow_hasFocus), -1);
    rb_define_method(cFXWindow.klass, "isDefault", VALUEFUNC(_wrap_FXWindow_isDefault), -1);
    rb_define_method(cFXWindow.klass, "setInitial", VALUEFUNC(_wrap_FXWindow_setInitial), -1);
    rb_define_method(cFXWindow.klass, "isInitial", VALUEFUNC(_wrap_FXWindow_isInitial), -1);
    rb_define_method(cFXWindow.klass, "forceRefresh", VALUEFUNC(_wrap_FXWindow_forceRefresh), -1);
    rb_define_method(cFXWindow.klass, "scroll", VALUEFUNC(_wrap_FXWindow_scroll), -1);
    rb_define_method(cFXWindow.klass, "update", VALUEFUNC(_wrap_FXWindow_update), -1);
    rb_define_method(cFXWindow.klass, "repaint", VALUEFUNC(_wrap_FXWindow_repaint), -1);
    rb_define_method(cFXWindow.klass, "grab", VALUEFUNC(_wrap_FXWindow_grab), -1);
    rb_define_method(cFXWindow.klass, "ungrab", VALUEFUNC(_wrap_FXWindow_ungrab), -1);
    rb_define_method(cFXWindow.klass, "grabbed", VALUEFUNC(_wrap_FXWindow_grabbed), -1);
    rb_define_method(cFXWindow.klass, "grabKeyboard", VALUEFUNC(_wrap_FXWindow_grabKeyboard), -1);
    rb_define_method(cFXWindow.klass, "ungrabKeyboard", VALUEFUNC(_wrap_FXWindow_ungrabKeyboard), -1);
    rb_define_method(cFXWindow.klass, "grabbedKeyboard", VALUEFUNC(_wrap_FXWindow_grabbedKeyboard), -1);
    rb_define_method(cFXWindow.klass, "shown", VALUEFUNC(_wrap_FXWindow_shown), -1);
    rb_define_method(cFXWindow.klass, "underCursor", VALUEFUNC(_wrap_FXWindow_underCursor), -1);
    rb_define_method(cFXWindow.klass, "hasSelection", VALUEFUNC(_wrap_FXWindow_hasSelection), -1);
    rb_define_method(cFXWindow.klass, "acquireSelection", VALUEFUNC(_wrap_FXWindow_acquireSelection), -1);
    rb_define_method(cFXWindow.klass, "releaseSelection", VALUEFUNC(_wrap_FXWindow_releaseSelection), -1);
    rb_define_method(cFXWindow.klass, "hasClipboard", VALUEFUNC(_wrap_FXWindow_hasClipboard), -1);
    rb_define_method(cFXWindow.klass, "acquireClipboard", VALUEFUNC(_wrap_FXWindow_acquireClipboard), -1);
    rb_define_method(cFXWindow.klass, "releaseClipboard", VALUEFUNC(_wrap_FXWindow_releaseClipboard), -1);
    rb_define_method(cFXWindow.klass, "dropEnable", VALUEFUNC(_wrap_FXWindow_dropEnable), -1);
    rb_define_method(cFXWindow.klass, "dropDisable", VALUEFUNC(_wrap_FXWindow_dropDisable), -1);
    rb_define_method(cFXWindow.klass, "isDropEnabled", VALUEFUNC(_wrap_FXWindow_isDropEnabled), -1);
    rb_define_method(cFXWindow.klass, "isDragging", VALUEFUNC(_wrap_FXWindow_isDragging), -1);
    rb_define_method(cFXWindow.klass, "beginDrag", VALUEFUNC(_wrap_FXWindow_beginDrag), -1);
    rb_define_method(cFXWindow.klass, "handleDrag", VALUEFUNC(_wrap_FXWindow_handleDrag), -1);
    rb_define_method(cFXWindow.klass, "endDrag", VALUEFUNC(_wrap_FXWindow_endDrag), -1);
    rb_define_method(cFXWindow.klass, "isDropTarget", VALUEFUNC(_wrap_FXWindow_isDropTarget), -1);
    rb_define_method(cFXWindow.klass, "setDragRectangle", VALUEFUNC(_wrap_FXWindow_setDragRectangle), -1);
    rb_define_method(cFXWindow.klass, "clearDragRectangle", VALUEFUNC(_wrap_FXWindow_clearDragRectangle), -1);
    rb_define_method(cFXWindow.klass, "acceptDrop", VALUEFUNC(_wrap_FXWindow_acceptDrop), -1);
    rb_define_method(cFXWindow.klass, "didAccept", VALUEFUNC(_wrap_FXWindow_didAccept), -1);
    rb_define_method(cFXWindow.klass, "inquireDNDTypes", VALUEFUNC(_wrap_FXWindow_inquireDNDTypes), -1);
    rb_define_method(cFXWindow.klass, "offeredDNDType", VALUEFUNC(_wrap_FXWindow_offeredDNDType), -1);
    rb_define_method(cFXWindow.klass, "inquireDNDAction", VALUEFUNC(_wrap_FXWindow_inquireDNDAction), -1);
    rb_define_method(cFXWindow.klass, "setDNDData", VALUEFUNC(_wrap_FXWindow_setDNDData), -1);
    rb_define_method(cFXWindow.klass, "getDNDData", VALUEFUNC(_wrap_FXWindow_getDNDData), -1);
    rb_define_method(cFXWindow.klass, "translateCoordinatesFrom", VALUEFUNC(_wrap_FXWindow_translateCoordinatesFrom), -1);
    rb_define_method(cFXWindow.klass, "translateCoordinatesTo", VALUEFUNC(_wrap_FXWindow_translateCoordinatesTo), -1);
    rb_define_method(cFXWindow.klass, "getBackColor", VALUEFUNC(_wrap_FXWindow_getBackColor), -1);
    rb_define_method(cFXWindow.klass, "linkBefore", VALUEFUNC(_wrap_FXWindow_linkBefore), -1);
    rb_define_method(cFXWindow.klass, "linkAfter", VALUEFUNC(_wrap_FXWindow_linkAfter), -1);
    rb_define_method(cFXWindow.klass, "save", VALUEFUNC(_wrap_FXWindow_save), -1);
    rb_define_method(cFXWindow.klass, "load", VALUEFUNC(_wrap_FXWindow_load), -1);
    rb_define_method(cFXWindow.klass, "create", VALUEFUNC(_wrap_FXWindow_create), -1);
    rb_define_method(cFXWindow.klass, "detach", VALUEFUNC(_wrap_FXWindow_detach), -1);
    rb_define_method(cFXWindow.klass, "destroy", VALUEFUNC(_wrap_FXWindow_destroy), -1);
    rb_define_method(cFXWindow.klass, "resize", VALUEFUNC(_wrap_FXWindow_resize), -1);
    rb_define_method(cFXWindow.klass, "getDefaultWidth", VALUEFUNC(_wrap_FXWindow_getDefaultWidth), -1);
    rb_define_method(cFXWindow.klass, "getDefaultHeight", VALUEFUNC(_wrap_FXWindow_getDefaultHeight), -1);
    rb_define_method(cFXWindow.klass, "getWidthForHeight", VALUEFUNC(_wrap_FXWindow_getWidthForHeight), -1);
    rb_define_method(cFXWindow.klass, "getHeightForWidth", VALUEFUNC(_wrap_FXWindow_getHeightForWidth), -1);
    rb_define_method(cFXWindow.klass, "canFocus", VALUEFUNC(_wrap_FXWindow_canFocus), -1);
    rb_define_method(cFXWindow.klass, "setFocus", VALUEFUNC(_wrap_FXWindow_setFocus), -1);
    rb_define_method(cFXWindow.klass, "killFocus", VALUEFUNC(_wrap_FXWindow_killFocus), -1);
    rb_define_method(cFXWindow.klass, "setDefault", VALUEFUNC(_wrap_FXWindow_setDefault), -1);
    rb_define_method(cFXWindow.klass, "enable", VALUEFUNC(_wrap_FXWindow_enable), -1);
    rb_define_method(cFXWindow.klass, "disable", VALUEFUNC(_wrap_FXWindow_disable), -1);
    rb_define_method(cFXWindow.klass, "raiseWindow", VALUEFUNC(_wrap_FXWindow_raiseWindow), -1);
    rb_define_method(cFXWindow.klass, "lower", VALUEFUNC(_wrap_FXWindow_lower), -1);
    rb_define_method(cFXWindow.klass, "move", VALUEFUNC(_wrap_FXWindow_move), -1);
    rb_define_method(cFXWindow.klass, "position", VALUEFUNC(_wrap_FXWindow_position), -1);
    rb_define_method(cFXWindow.klass, "layout", VALUEFUNC(_wrap_FXWindow_layout), -1);
    rb_define_method(cFXWindow.klass, "recalc", VALUEFUNC(_wrap_FXWindow_recalc), -1);
    rb_define_method(cFXWindow.klass, "reparent", VALUEFUNC(_wrap_FXWindow_reparent), -1);
    rb_define_method(cFXWindow.klass, "show", VALUEFUNC(_wrap_FXWindow_show), -1);
    rb_define_method(cFXWindow.klass, "hide", VALUEFUNC(_wrap_FXWindow_hide), -1);
    rb_define_method(cFXWindow.klass, "isComposite", VALUEFUNC(_wrap_FXWindow_isComposite), -1);
    rb_define_method(cFXWindow.klass, "contains", VALUEFUNC(_wrap_FXWindow_contains), -1);
    rb_define_method(cFXWindow.klass, "doesSaveUnder", VALUEFUNC(_wrap_FXWindow_doesSaveUnder), -1);
    rb_define_method(cFXWindow.klass, "setBackColor", VALUEFUNC(_wrap_FXWindow_setBackColor), -1);
    cFXWindow.mark = (void (*)(void *)) FXRbWindow::markfunc;
    cFXWindow.destroy = (void (*)(void *)) FXRbObject::freefunc;
    
    SWIGTYPE_p_FXWindow->dcast = (swig_dycast_func) FXWindow_dynamic_cast;
    
    rb_define_const(mFox,"JUSTIFY_NORMAL", INT2NUM(JUSTIFY_NORMAL));
    rb_define_const(mFox,"JUSTIFY_CENTER_X", INT2NUM(JUSTIFY_CENTER_X));
    rb_define_const(mFox,"JUSTIFY_LEFT", INT2NUM(JUSTIFY_LEFT));
    rb_define_const(mFox,"JUSTIFY_RIGHT", INT2NUM(JUSTIFY_RIGHT));
    rb_define_const(mFox,"JUSTIFY_HZ_APART", INT2NUM(JUSTIFY_HZ_APART));
    rb_define_const(mFox,"JUSTIFY_CENTER_Y", INT2NUM(JUSTIFY_CENTER_Y));
    rb_define_const(mFox,"JUSTIFY_TOP", INT2NUM(JUSTIFY_TOP));
    rb_define_const(mFox,"JUSTIFY_BOTTOM", INT2NUM(JUSTIFY_BOTTOM));
    rb_define_const(mFox,"JUSTIFY_VT_APART", INT2NUM(JUSTIFY_VT_APART));
    rb_define_const(mFox,"DEFAULT_PAD", INT2NUM(DEFAULT_PAD));
    
    cFXFrame.klass = rb_define_class_under(mFox, "FXFrame", ((swig_class *) SWIGTYPE_p_FXWindow->clientdata)->klass);
    SWIG_TypeClientData(SWIGTYPE_p_FXFrame, (void *) &cFXFrame);
    rb_define_alloc_func(cFXFrame.klass, _wrap_FXFrame_allocate);
    rb_define_method(cFXFrame.klass, "initialize", VALUEFUNC(_wrap_new_FXFrame), -1);
    rb_define_method(cFXFrame.klass, "onPaint", VALUEFUNC(_wrap_FXFrame_onPaint), -1);
    rb_define_method(cFXFrame.klass, "setFrameStyle", VALUEFUNC(_wrap_FXFrame_setFrameStyle), -1);
    rb_define_method(cFXFrame.klass, "getFrameStyle", VALUEFUNC(_wrap_FXFrame_getFrameStyle), -1);
    rb_define_method(cFXFrame.klass, "getBorderWidth", VALUEFUNC(_wrap_FXFrame_getBorderWidth), -1);
    rb_define_method(cFXFrame.klass, "setPadTop", VALUEFUNC(_wrap_FXFrame_setPadTop), -1);
    rb_define_method(cFXFrame.klass, "getPadTop", VALUEFUNC(_wrap_FXFrame_getPadTop), -1);
    rb_define_method(cFXFrame.klass, "setPadBottom", VALUEFUNC(_wrap_FXFrame_setPadBottom), -1);
    rb_define_method(cFXFrame.klass, "getPadBottom", VALUEFUNC(_wrap_FXFrame_getPadBottom), -1);
    rb_define_method(cFXFrame.klass, "setPadLeft", VALUEFUNC(_wrap_FXFrame_setPadLeft), -1);
    rb_define_method(cFXFrame.klass, "getPadLeft", VALUEFUNC(_wrap_FXFrame_getPadLeft), -1);
    rb_define_method(cFXFrame.klass, "setPadRight", VALUEFUNC(_wrap_FXFrame_setPadRight), -1);
    rb_define_method(cFXFrame.klass, "getPadRight", VALUEFUNC(_wrap_FXFrame_getPadRight), -1);
    rb_define_method(cFXFrame.klass, "setHiliteColor", VALUEFUNC(_wrap_FXFrame_setHiliteColor), -1);
    rb_define_method(cFXFrame.klass, "getHiliteColor", VALUEFUNC(_wrap_FXFrame_getHiliteColor), -1);
    rb_define_method(cFXFrame.klass, "setShadowColor", VALUEFUNC(_wrap_FXFrame_setShadowColor), -1);
    rb_define_method(cFXFrame.klass, "getShadowColor", VALUEFUNC(_wrap_FXFrame_getShadowColor), -1);
    rb_define_method(cFXFrame.klass, "setBorderColor", VALUEFUNC(_wrap_FXFrame_setBorderColor), -1);
    rb_define_method(cFXFrame.klass, "getBorderColor", VALUEFUNC(_wrap_FXFrame_getBorderColor), -1);
    rb_define_method(cFXFrame.klass, "setBaseColor", VALUEFUNC(_wrap_FXFrame_setBaseColor), -1);
    rb_define_method(cFXFrame.klass, "getBaseColor", VALUEFUNC(_wrap_FXFrame_getBaseColor), -1);
    rb_define_method(cFXFrame.klass, "save", VALUEFUNC(_wrap_FXFrame_save), -1);
    rb_define_method(cFXFrame.klass, "load", VALUEFUNC(_wrap_FXFrame_load), -1);
    rb_define_method(cFXFrame.klass, "create", VALUEFUNC(_wrap_FXFrame_create), -1);
    rb_define_method(cFXFrame.klass, "detach", VALUEFUNC(_wrap_FXFrame_detach), -1);
    rb_define_method(cFXFrame.klass, "destroy", VALUEFUNC(_wrap_FXFrame_destroy), -1);
    rb_define_method(cFXFrame.klass, "resize", VALUEFUNC(_wrap_FXFrame_resize), -1);
    rb_define_method(cFXFrame.klass, "getDefaultWidth", VALUEFUNC(_wrap_FXFrame_getDefaultWidth), -1);
    rb_define_method(cFXFrame.klass, "getDefaultHeight", VALUEFUNC(_wrap_FXFrame_getDefaultHeight), -1);
    rb_define_method(cFXFrame.klass, "getWidthForHeight", VALUEFUNC(_wrap_FXFrame_getWidthForHeight), -1);
    rb_define_method(cFXFrame.klass, "getHeightForWidth", VALUEFUNC(_wrap_FXFrame_getHeightForWidth), -1);
    rb_define_method(cFXFrame.klass, "canFocus", VALUEFUNC(_wrap_FXFrame_canFocus), -1);
    rb_define_method(cFXFrame.klass, "setFocus", VALUEFUNC(_wrap_FXFrame_setFocus), -1);
    rb_define_method(cFXFrame.klass, "killFocus", VALUEFUNC(_wrap_FXFrame_killFocus), -1);
    rb_define_method(cFXFrame.klass, "setDefault", VALUEFUNC(_wrap_FXFrame_setDefault), -1);
    rb_define_method(cFXFrame.klass, "enable", VALUEFUNC(_wrap_FXFrame_enable), -1);
    rb_define_method(cFXFrame.klass, "disable", VALUEFUNC(_wrap_FXFrame_disable), -1);
    rb_define_method(cFXFrame.klass, "raiseWindow", VALUEFUNC(_wrap_FXFrame_raiseWindow), -1);
    rb_define_method(cFXFrame.klass, "lower", VALUEFUNC(_wrap_FXFrame_lower), -1);
    rb_define_method(cFXFrame.klass, "move", VALUEFUNC(_wrap_FXFrame_move), -1);
    rb_define_method(cFXFrame.klass, "position", VALUEFUNC(_wrap_FXFrame_position), -1);
    rb_define_method(cFXFrame.klass, "layout", VALUEFUNC(_wrap_FXFrame_layout), -1);
    rb_define_method(cFXFrame.klass, "recalc", VALUEFUNC(_wrap_FXFrame_recalc), -1);
    rb_define_method(cFXFrame.klass, "reparent", VALUEFUNC(_wrap_FXFrame_reparent), -1);
    rb_define_method(cFXFrame.klass, "show", VALUEFUNC(_wrap_FXFrame_show), -1);
    rb_define_method(cFXFrame.klass, "hide", VALUEFUNC(_wrap_FXFrame_hide), -1);
    rb_define_method(cFXFrame.klass, "isComposite", VALUEFUNC(_wrap_FXFrame_isComposite), -1);
    rb_define_method(cFXFrame.klass, "contains", VALUEFUNC(_wrap_FXFrame_contains), -1);
    rb_define_method(cFXFrame.klass, "doesSaveUnder", VALUEFUNC(_wrap_FXFrame_doesSaveUnder), -1);
    rb_define_method(cFXFrame.klass, "setBackColor", VALUEFUNC(_wrap_FXFrame_setBackColor), -1);
    cFXFrame.mark = (void (*)(void *)) FXRbFrame::markfunc;
    cFXFrame.destroy = (void (*)(void *)) FXRbObject::freefunc;
    
    SWIGTYPE_p_FXFrame->dcast = (swig_dycast_func) FXFrame_dynamic_cast;
    
    
    cFXComposite.klass = rb_define_class_under(mFox, "FXComposite", ((swig_class *) SWIGTYPE_p_FXWindow->clientdata)->klass);
    SWIG_TypeClientData(SWIGTYPE_p_FXComposite, (void *) &cFXComposite);
    rb_define_alloc_func(cFXComposite.klass, _wrap_FXComposite_allocate);
    rb_define_method(cFXComposite.klass, "initialize", VALUEFUNC(_wrap_new_FXComposite), -1);
    rb_define_method(cFXComposite.klass, "onKeyPress", VALUEFUNC(_wrap_FXComposite_onKeyPress), -1);
    rb_define_method(cFXComposite.klass, "onKeyRelease", VALUEFUNC(_wrap_FXComposite_onKeyRelease), -1);
    rb_define_method(cFXComposite.klass, "onFocusNext", VALUEFUNC(_wrap_FXComposite_onFocusNext), -1);
    rb_define_method(cFXComposite.klass, "onFocusPrev", VALUEFUNC(_wrap_FXComposite_onFocusPrev), -1);
    rb_define_method(cFXComposite.klass, "onCmdUpdate", VALUEFUNC(_wrap_FXComposite_onCmdUpdate), -1);
    rb_define_method(cFXComposite.klass, "maxChildWidth", VALUEFUNC(_wrap_FXComposite_maxChildWidth), -1);
    rb_define_method(cFXComposite.klass, "maxChildHeight", VALUEFUNC(_wrap_FXComposite_maxChildHeight), -1);
    rb_define_method(cFXComposite.klass, "save", VALUEFUNC(_wrap_FXComposite_save), -1);
    rb_define_method(cFXComposite.klass, "load", VALUEFUNC(_wrap_FXComposite_load), -1);
    rb_define_method(cFXComposite.klass, "create", VALUEFUNC(_wrap_FXComposite_create), -1);
    rb_define_method(cFXComposite.klass, "detach", VALUEFUNC(_wrap_FXComposite_detach), -1);
    rb_define_method(cFXComposite.klass, "destroy", VALUEFUNC(_wrap_FXComposite_destroy), -1);
    rb_define_method(cFXComposite.klass, "resize", VALUEFUNC(_wrap_FXComposite_resize), -1);
    rb_define_method(cFXComposite.klass, "getDefaultWidth", VALUEFUNC(_wrap_FXComposite_getDefaultWidth), -1);
    rb_define_method(cFXComposite.klass, "getDefaultHeight", VALUEFUNC(_wrap_FXComposite_getDefaultHeight), -1);
    rb_define_method(cFXComposite.klass, "getWidthForHeight", VALUEFUNC(_wrap_FXComposite_getWidthForHeight), -1);
    rb_define_method(cFXComposite.klass, "getHeightForWidth", VALUEFUNC(_wrap_FXComposite_getHeightForWidth), -1);
    rb_define_method(cFXComposite.klass, "canFocus", VALUEFUNC(_wrap_FXComposite_canFocus), -1);
    rb_define_method(cFXComposite.klass, "setFocus", VALUEFUNC(_wrap_FXComposite_setFocus), -1);
    rb_define_method(cFXComposite.klass, "killFocus", VALUEFUNC(_wrap_FXComposite_killFocus), -1);
    rb_define_method(cFXComposite.klass, "setDefault", VALUEFUNC(_wrap_FXComposite_setDefault), -1);
    rb_define_method(cFXComposite.klass, "enable", VALUEFUNC(_wrap_FXComposite_enable), -1);
    rb_define_method(cFXComposite.klass, "disable", VALUEFUNC(_wrap_FXComposite_disable), -1);
    rb_define_method(cFXComposite.klass, "raiseWindow", VALUEFUNC(_wrap_FXComposite_raiseWindow), -1);
    rb_define_method(cFXComposite.klass, "lower", VALUEFUNC(_wrap_FXComposite_lower), -1);
    rb_define_method(cFXComposite.klass, "move", VALUEFUNC(_wrap_FXComposite_move), -1);
    rb_define_method(cFXComposite.klass, "position", VALUEFUNC(_wrap_FXComposite_position), -1);
    rb_define_method(cFXComposite.klass, "layout", VALUEFUNC(_wrap_FXComposite_layout), -1);
    rb_define_method(cFXComposite.klass, "recalc", VALUEFUNC(_wrap_FXComposite_recalc), -1);
    rb_define_method(cFXComposite.klass, "reparent", VALUEFUNC(_wrap_FXComposite_reparent), -1);
    rb_define_method(cFXComposite.klass, "show", VALUEFUNC(_wrap_FXComposite_show), -1);
    rb_define_method(cFXComposite.klass, "hide", VALUEFUNC(_wrap_FXComposite_hide), -1);
    rb_define_method(cFXComposite.klass, "isComposite", VALUEFUNC(_wrap_FXComposite_isComposite), -1);
    rb_define_method(cFXComposite.klass, "contains", VALUEFUNC(_wrap_FXComposite_contains), -1);
    rb_define_method(cFXComposite.klass, "doesSaveUnder", VALUEFUNC(_wrap_FXComposite_doesSaveUnder), -1);
    rb_define_method(cFXComposite.klass, "setBackColor", VALUEFUNC(_wrap_FXComposite_setBackColor), -1);
    cFXComposite.mark = (void (*)(void *)) FXRbComposite::markfunc;
    cFXComposite.destroy = (void (*)(void *)) FXRbObject::freefunc;
    
    SWIGTYPE_p_FXComposite->dcast = (swig_dycast_func) FXComposite_dynamic_cast;
    
    
    cFXRootWindow.klass = rb_define_class_under(mFox, "FXRootWindow", ((swig_class *) SWIGTYPE_p_FXComposite->clientdata)->klass);
    SWIG_TypeClientData(SWIGTYPE_p_FXRootWindow, (void *) &cFXRootWindow);
    rb_define_alloc_func(cFXRootWindow.klass, _wrap_FXRootWindow_allocate);
    rb_define_method(cFXRootWindow.klass, "initialize", VALUEFUNC(_wrap_new_FXRootWindow), -1);
    rb_define_method(cFXRootWindow.klass, "save", VALUEFUNC(_wrap_FXRootWindow_save), -1);
    rb_define_method(cFXRootWindow.klass, "load", VALUEFUNC(_wrap_FXRootWindow_load), -1);
    rb_define_method(cFXRootWindow.klass, "create", VALUEFUNC(_wrap_FXRootWindow_create), -1);
    rb_define_method(cFXRootWindow.klass, "detach", VALUEFUNC(_wrap_FXRootWindow_detach), -1);
    rb_define_method(cFXRootWindow.klass, "destroy", VALUEFUNC(_wrap_FXRootWindow_destroy), -1);
    rb_define_method(cFXRootWindow.klass, "resize", VALUEFUNC(_wrap_FXRootWindow_resize), -1);
    rb_define_method(cFXRootWindow.klass, "getDefaultWidth", VALUEFUNC(_wrap_FXRootWindow_getDefaultWidth), -1);
    rb_define_method(cFXRootWindow.klass, "getDefaultHeight", VALUEFUNC(_wrap_FXRootWindow_getDefaultHeight), -1);
    rb_define_method(cFXRootWindow.klass, "getWidthForHeight", VALUEFUNC(_wrap_FXRootWindow_getWidthForHeight), -1);
    rb_define_method(cFXRootWindow.klass, "getHeightForWidth", VALUEFUNC(_wrap_FXRootWindow_getHeightForWidth), -1);
    rb_define_method(cFXRootWindow.klass, "canFocus", VALUEFUNC(_wrap_FXRootWindow_canFocus), -1);
    rb_define_method(cFXRootWindow.klass, "setFocus", VALUEFUNC(_wrap_FXRootWindow_setFocus), -1);
    rb_define_method(cFXRootWindow.klass, "killFocus", VALUEFUNC(_wrap_FXRootWindow_killFocus), -1);
    rb_define_method(cFXRootWindow.klass, "setDefault", VALUEFUNC(_wrap_FXRootWindow_setDefault), -1);
    rb_define_method(cFXRootWindow.klass, "enable", VALUEFUNC(_wrap_FXRootWindow_enable), -1);
    rb_define_method(cFXRootWindow.klass, "disable", VALUEFUNC(_wrap_FXRootWindow_disable), -1);
    rb_define_method(cFXRootWindow.klass, "raiseWindow", VALUEFUNC(_wrap_FXRootWindow_raiseWindow), -1);
    rb_define_method(cFXRootWindow.klass, "lower", VALUEFUNC(_wrap_FXRootWindow_lower), -1);
    rb_define_method(cFXRootWindow.klass, "move", VALUEFUNC(_wrap_FXRootWindow_move), -1);
    rb_define_method(cFXRootWindow.klass, "position", VALUEFUNC(_wrap_FXRootWindow_position), -1);
    rb_define_method(cFXRootWindow.klass, "layout", VALUEFUNC(_wrap_FXRootWindow_layout), -1);
    rb_define_method(cFXRootWindow.klass, "recalc", VALUEFUNC(_wrap_FXRootWindow_recalc), -1);
    rb_define_method(cFXRootWindow.klass, "reparent", VALUEFUNC(_wrap_FXRootWindow_reparent), -1);
    rb_define_method(cFXRootWindow.klass, "show", VALUEFUNC(_wrap_FXRootWindow_show), -1);
    rb_define_method(cFXRootWindow.klass, "hide", VALUEFUNC(_wrap_FXRootWindow_hide), -1);
    rb_define_method(cFXRootWindow.klass, "isComposite", VALUEFUNC(_wrap_FXRootWindow_isComposite), -1);
    rb_define_method(cFXRootWindow.klass, "contains", VALUEFUNC(_wrap_FXRootWindow_contains), -1);
    rb_define_method(cFXRootWindow.klass, "doesSaveUnder", VALUEFUNC(_wrap_FXRootWindow_doesSaveUnder), -1);
    rb_define_method(cFXRootWindow.klass, "setBackColor", VALUEFUNC(_wrap_FXRootWindow_setBackColor), -1);
    cFXRootWindow.mark = (void (*)(void *)) FXRbRootWindow::markfunc;
    cFXRootWindow.destroy = (void (*)(void *)) FXRbObject::freefunc;
    
    cFXShell.klass = rb_define_class_under(mFox, "FXShell", ((swig_class *) SWIGTYPE_p_FXComposite->clientdata)->klass);
    SWIG_TypeClientData(SWIGTYPE_p_FXShell, (void *) &cFXShell);
    rb_define_alloc_func(cFXShell.klass, _wrap_FXShell_allocate);
    rb_define_method(cFXShell.klass, "initialize", VALUEFUNC(_wrap_new_FXShell), -1);
    rb_define_method(cFXShell.klass, "onLayout", VALUEFUNC(_wrap_FXShell_onLayout), -1);
    rb_define_method(cFXShell.klass, "onConfigure", VALUEFUNC(_wrap_FXShell_onConfigure), -1);
    rb_define_method(cFXShell.klass, "onKeyPress", VALUEFUNC(_wrap_FXShell_onKeyPress), -1);
    rb_define_method(cFXShell.klass, "onKeyRelease", VALUEFUNC(_wrap_FXShell_onKeyRelease), -1);
    rb_define_method(cFXShell.klass, "onFocusNext", VALUEFUNC(_wrap_FXShell_onFocusNext), -1);
    rb_define_method(cFXShell.klass, "onFocusPrev", VALUEFUNC(_wrap_FXShell_onFocusPrev), -1);
    rb_define_const(cFXShell.klass,"ID_LAYOUT", INT2NUM(FXShell::ID_LAYOUT));
    rb_define_const(cFXShell.klass,"ID_LAST", INT2NUM(FXShell::ID_LAST));
    rb_define_method(cFXShell.klass, "save", VALUEFUNC(_wrap_FXShell_save), -1);
    rb_define_method(cFXShell.klass, "load", VALUEFUNC(_wrap_FXShell_load), -1);
    rb_define_method(cFXShell.klass, "create", VALUEFUNC(_wrap_FXShell_create), -1);
    rb_define_method(cFXShell.klass, "detach", VALUEFUNC(_wrap_FXShell_detach), -1);
    rb_define_method(cFXShell.klass, "destroy", VALUEFUNC(_wrap_FXShell_destroy), -1);
    rb_define_method(cFXShell.klass, "resize", VALUEFUNC(_wrap_FXShell_resize), -1);
    rb_define_method(cFXShell.klass, "getDefaultWidth", VALUEFUNC(_wrap_FXShell_getDefaultWidth), -1);
    rb_define_method(cFXShell.klass, "getDefaultHeight", VALUEFUNC(_wrap_FXShell_getDefaultHeight), -1);
    rb_define_method(cFXShell.klass, "getWidthForHeight", VALUEFUNC(_wrap_FXShell_getWidthForHeight), -1);
    rb_define_method(cFXShell.klass, "getHeightForWidth", VALUEFUNC(_wrap_FXShell_getHeightForWidth), -1);
    rb_define_method(cFXShell.klass, "canFocus", VALUEFUNC(_wrap_FXShell_canFocus), -1);
    rb_define_method(cFXShell.klass, "setFocus", VALUEFUNC(_wrap_FXShell_setFocus), -1);
    rb_define_method(cFXShell.klass, "killFocus", VALUEFUNC(_wrap_FXShell_killFocus), -1);
    rb_define_method(cFXShell.klass, "setDefault", VALUEFUNC(_wrap_FXShell_setDefault), -1);
    rb_define_method(cFXShell.klass, "enable", VALUEFUNC(_wrap_FXShell_enable), -1);
    rb_define_method(cFXShell.klass, "disable", VALUEFUNC(_wrap_FXShell_disable), -1);
    rb_define_method(cFXShell.klass, "raiseWindow", VALUEFUNC(_wrap_FXShell_raiseWindow), -1);
    rb_define_method(cFXShell.klass, "lower", VALUEFUNC(_wrap_FXShell_lower), -1);
    rb_define_method(cFXShell.klass, "move", VALUEFUNC(_wrap_FXShell_move), -1);
    rb_define_method(cFXShell.klass, "position", VALUEFUNC(_wrap_FXShell_position), -1);
    rb_define_method(cFXShell.klass, "layout", VALUEFUNC(_wrap_FXShell_layout), -1);
    rb_define_method(cFXShell.klass, "recalc", VALUEFUNC(_wrap_FXShell_recalc), -1);
    rb_define_method(cFXShell.klass, "reparent", VALUEFUNC(_wrap_FXShell_reparent), -1);
    rb_define_method(cFXShell.klass, "show", VALUEFUNC(_wrap_FXShell_show), -1);
    rb_define_method(cFXShell.klass, "hide", VALUEFUNC(_wrap_FXShell_hide), -1);
    rb_define_method(cFXShell.klass, "isComposite", VALUEFUNC(_wrap_FXShell_isComposite), -1);
    rb_define_method(cFXShell.klass, "contains", VALUEFUNC(_wrap_FXShell_contains), -1);
    rb_define_method(cFXShell.klass, "doesSaveUnder", VALUEFUNC(_wrap_FXShell_doesSaveUnder), -1);
    rb_define_method(cFXShell.klass, "setBackColor", VALUEFUNC(_wrap_FXShell_setBackColor), -1);
    cFXShell.mark = (void (*)(void *)) FXRbShell::markfunc;
    cFXShell.destroy = (void (*)(void *)) FXRbObject::freefunc;
    
    SWIGTYPE_p_FXShell->dcast = (swig_dycast_func) FXShell_dynamic_cast;
    
    rb_define_const(mFox,"POPUP_VERTICAL", INT2NUM(POPUP_VERTICAL));
    rb_define_const(mFox,"POPUP_HORIZONTAL", INT2NUM(POPUP_HORIZONTAL));
    rb_define_const(mFox,"POPUP_SHRINKWRAP", INT2NUM(POPUP_SHRINKWRAP));
    
    cFXPopup.klass = rb_define_class_under(mFox, "FXPopup", ((swig_class *) SWIGTYPE_p_FXShell->clientdata)->klass);
    SWIG_TypeClientData(SWIGTYPE_p_FXPopup, (void *) &cFXPopup);
    rb_define_alloc_func(cFXPopup.klass, _wrap_FXPopup_allocate);
    rb_define_method(cFXPopup.klass, "initialize", VALUEFUNC(_wrap_new_FXPopup), -1);
    rb_define_method(cFXPopup.klass, "onPaint", VALUEFUNC(_wrap_FXPopup_onPaint), -1);
    rb_define_method(cFXPopup.klass, "onFocusUp", VALUEFUNC(_wrap_FXPopup_onFocusUp), -1);
    rb_define_method(cFXPopup.klass, "onFocusDown", VALUEFUNC(_wrap_FXPopup_onFocusDown), -1);
    rb_define_method(cFXPopup.klass, "onFocusLeft", VALUEFUNC(_wrap_FXPopup_onFocusLeft), -1);
    rb_define_method(cFXPopup.klass, "onFocusRight", VALUEFUNC(_wrap_FXPopup_onFocusRight), -1);
    rb_define_method(cFXPopup.klass, "onFocusNext", VALUEFUNC(_wrap_FXPopup_onFocusNext), -1);
    rb_define_method(cFXPopup.klass, "onFocusPrev", VALUEFUNC(_wrap_FXPopup_onFocusPrev), -1);
    rb_define_method(cFXPopup.klass, "onEnter", VALUEFUNC(_wrap_FXPopup_onEnter), -1);
    rb_define_method(cFXPopup.klass, "onLeave", VALUEFUNC(_wrap_FXPopup_onLeave), -1);
    rb_define_method(cFXPopup.klass, "onMotion", VALUEFUNC(_wrap_FXPopup_onMotion), -1);
    rb_define_method(cFXPopup.klass, "onMap", VALUEFUNC(_wrap_FXPopup_onMap), -1);
    rb_define_method(cFXPopup.klass, "onButtonPress", VALUEFUNC(_wrap_FXPopup_onButtonPress), -1);
    rb_define_method(cFXPopup.klass, "onButtonRelease", VALUEFUNC(_wrap_FXPopup_onButtonRelease), -1);
    rb_define_method(cFXPopup.klass, "onUngrabbed", VALUEFUNC(_wrap_FXPopup_onUngrabbed), -1);
    rb_define_method(cFXPopup.klass, "onCmdUnpost", VALUEFUNC(_wrap_FXPopup_onCmdUnpost), -1);
    rb_define_method(cFXPopup.klass, "onKeyPress", VALUEFUNC(_wrap_FXPopup_onKeyPress), -1);
    rb_define_method(cFXPopup.klass, "onKeyRelease", VALUEFUNC(_wrap_FXPopup_onKeyRelease), -1);
    rb_define_method(cFXPopup.klass, "onCmdChoice", VALUEFUNC(_wrap_FXPopup_onCmdChoice), -1);
    rb_define_const(cFXPopup.klass,"ID_CHOICE", INT2NUM(FXPopup::ID_CHOICE));
    rb_define_const(cFXPopup.klass,"ID_LAST", INT2NUM(FXPopup::ID_LAST));
    rb_define_method(cFXPopup.klass, "getPrevActive", VALUEFUNC(_wrap_FXPopup_getPrevActive), -1);
    rb_define_method(cFXPopup.klass, "getNextActive", VALUEFUNC(_wrap_FXPopup_getNextActive), -1);
    rb_define_method(cFXPopup.klass, "setFrameStyle", VALUEFUNC(_wrap_FXPopup_setFrameStyle), -1);
    rb_define_method(cFXPopup.klass, "getFrameStyle", VALUEFUNC(_wrap_FXPopup_getFrameStyle), -1);
    rb_define_method(cFXPopup.klass, "getBorderWidth", VALUEFUNC(_wrap_FXPopup_getBorderWidth), -1);
    rb_define_method(cFXPopup.klass, "setHiliteColor", VALUEFUNC(_wrap_FXPopup_setHiliteColor), -1);
    rb_define_method(cFXPopup.klass, "getHiliteColor", VALUEFUNC(_wrap_FXPopup_getHiliteColor), -1);
    rb_define_method(cFXPopup.klass, "setShadowColor", VALUEFUNC(_wrap_FXPopup_setShadowColor), -1);
    rb_define_method(cFXPopup.klass, "getShadowColor", VALUEFUNC(_wrap_FXPopup_getShadowColor), -1);
    rb_define_method(cFXPopup.klass, "setBorderColor", VALUEFUNC(_wrap_FXPopup_setBorderColor), -1);
    rb_define_method(cFXPopup.klass, "getBorderColor", VALUEFUNC(_wrap_FXPopup_getBorderColor), -1);
    rb_define_method(cFXPopup.klass, "setBaseColor", VALUEFUNC(_wrap_FXPopup_setBaseColor), -1);
    rb_define_method(cFXPopup.klass, "getBaseColor", VALUEFUNC(_wrap_FXPopup_getBaseColor), -1);
    rb_define_method(cFXPopup.klass, "getGrabOwner", VALUEFUNC(_wrap_FXPopup_getGrabOwner), -1);
    rb_define_method(cFXPopup.klass, "getOrientation", VALUEFUNC(_wrap_FXPopup_getOrientation), -1);
    rb_define_method(cFXPopup.klass, "setOrientation", VALUEFUNC(_wrap_FXPopup_setOrientation), -1);
    rb_define_method(cFXPopup.klass, "getShrinkWrap", VALUEFUNC(_wrap_FXPopup_getShrinkWrap), -1);
    rb_define_method(cFXPopup.klass, "setShrinkWrap", VALUEFUNC(_wrap_FXPopup_setShrinkWrap), -1);
    rb_define_method(cFXPopup.klass, "save", VALUEFUNC(_wrap_FXPopup_save), -1);
    rb_define_method(cFXPopup.klass, "load", VALUEFUNC(_wrap_FXPopup_load), -1);
    rb_define_method(cFXPopup.klass, "create", VALUEFUNC(_wrap_FXPopup_create), -1);
    rb_define_method(cFXPopup.klass, "detach", VALUEFUNC(_wrap_FXPopup_detach), -1);
    rb_define_method(cFXPopup.klass, "destroy", VALUEFUNC(_wrap_FXPopup_destroy), -1);
    rb_define_method(cFXPopup.klass, "resize", VALUEFUNC(_wrap_FXPopup_resize), -1);
    rb_define_method(cFXPopup.klass, "getDefaultWidth", VALUEFUNC(_wrap_FXPopup_getDefaultWidth), -1);
    rb_define_method(cFXPopup.klass, "getDefaultHeight", VALUEFUNC(_wrap_FXPopup_getDefaultHeight), -1);
    rb_define_method(cFXPopup.klass, "getWidthForHeight", VALUEFUNC(_wrap_FXPopup_getWidthForHeight), -1);
    rb_define_method(cFXPopup.klass, "getHeightForWidth", VALUEFUNC(_wrap_FXPopup_getHeightForWidth), -1);
    rb_define_method(cFXPopup.klass, "canFocus", VALUEFUNC(_wrap_FXPopup_canFocus), -1);
    rb_define_method(cFXPopup.klass, "setFocus", VALUEFUNC(_wrap_FXPopup_setFocus), -1);
    rb_define_method(cFXPopup.klass, "killFocus", VALUEFUNC(_wrap_FXPopup_killFocus), -1);
    rb_define_method(cFXPopup.klass, "setDefault", VALUEFUNC(_wrap_FXPopup_setDefault), -1);
    rb_define_method(cFXPopup.klass, "enable", VALUEFUNC(_wrap_FXPopup_enable), -1);
    rb_define_method(cFXPopup.klass, "disable", VALUEFUNC(_wrap_FXPopup_disable), -1);
    rb_define_method(cFXPopup.klass, "raiseWindow", VALUEFUNC(_wrap_FXPopup_raiseWindow), -1);
    rb_define_method(cFXPopup.klass, "lower", VALUEFUNC(_wrap_FXPopup_lower), -1);
    rb_define_method(cFXPopup.klass, "move", VALUEFUNC(_wrap_FXPopup_move), -1);
    rb_define_method(cFXPopup.klass, "position", VALUEFUNC(_wrap_FXPopup_position), -1);
    rb_define_method(cFXPopup.klass, "layout", VALUEFUNC(_wrap_FXPopup_layout), -1);
    rb_define_method(cFXPopup.klass, "recalc", VALUEFUNC(_wrap_FXPopup_recalc), -1);
    rb_define_method(cFXPopup.klass, "reparent", VALUEFUNC(_wrap_FXPopup_reparent), -1);
    rb_define_method(cFXPopup.klass, "show", VALUEFUNC(_wrap_FXPopup_show), -1);
    rb_define_method(cFXPopup.klass, "hide", VALUEFUNC(_wrap_FXPopup_hide), -1);
    rb_define_method(cFXPopup.klass, "isComposite", VALUEFUNC(_wrap_FXPopup_isComposite), -1);
    rb_define_method(cFXPopup.klass, "contains", VALUEFUNC(_wrap_FXPopup_contains), -1);
    rb_define_method(cFXPopup.klass, "doesSaveUnder", VALUEFUNC(_wrap_FXPopup_doesSaveUnder), -1);
    rb_define_method(cFXPopup.klass, "setBackColor", VALUEFUNC(_wrap_FXPopup_setBackColor), -1);
    rb_define_method(cFXPopup.klass, "popup", VALUEFUNC(_wrap_FXPopup_popup), -1);
    rb_define_method(cFXPopup.klass, "popdown", VALUEFUNC(_wrap_FXPopup_popdown), -1);
    cFXPopup.mark = (void (*)(void *)) FXRbPopup::markfunc;
    cFXPopup.destroy = (void (*)(void *)) FXRbObject::freefunc;
    
    SWIGTYPE_p_FXPopup->dcast = (swig_dycast_func) FXPopup_dynamic_cast;
    
    rb_define_const(mFox,"DECOR_NONE", INT2NUM(DECOR_NONE));
    rb_define_const(mFox,"DECOR_TITLE", INT2NUM(DECOR_TITLE));
    rb_define_const(mFox,"DECOR_MINIMIZE", INT2NUM(DECOR_MINIMIZE));
    rb_define_const(mFox,"DECOR_MAXIMIZE", INT2NUM(DECOR_MAXIMIZE));
    rb_define_const(mFox,"DECOR_CLOSE", INT2NUM(DECOR_CLOSE));
    rb_define_const(mFox,"DECOR_BORDER", INT2NUM(DECOR_BORDER));
    rb_define_const(mFox,"DECOR_SHRINKABLE", INT2NUM(DECOR_SHRINKABLE));
    rb_define_const(mFox,"DECOR_STRETCHABLE", INT2NUM(DECOR_STRETCHABLE));
    rb_define_const(mFox,"DECOR_RESIZE", INT2NUM(DECOR_RESIZE));
    rb_define_const(mFox,"DECOR_MENU", INT2NUM(DECOR_MENU));
    rb_define_const(mFox,"DECOR_ALL", INT2NUM(DECOR_ALL));
    rb_define_const(mFox,"PLACEMENT_DEFAULT", INT2NUM(PLACEMENT_DEFAULT));
    rb_define_const(mFox,"PLACEMENT_VISIBLE", INT2NUM(PLACEMENT_VISIBLE));
    rb_define_const(mFox,"PLACEMENT_CURSOR", INT2NUM(PLACEMENT_CURSOR));
    rb_define_const(mFox,"PLACEMENT_OWNER", INT2NUM(PLACEMENT_OWNER));
    rb_define_const(mFox,"PLACEMENT_SCREEN", INT2NUM(PLACEMENT_SCREEN));
    rb_define_const(mFox,"PLACEMENT_MAXIMIZED", INT2NUM(PLACEMENT_MAXIMIZED));
    
    cFXTopWindow.klass = rb_define_class_under(mFox, "FXTopWindow", ((swig_class *) SWIGTYPE_p_FXShell->clientdata)->klass);
    SWIG_TypeClientData(SWIGTYPE_p_FXTopWindow, (void *) &cFXTopWindow);
    rb_define_alloc_func(cFXTopWindow.klass, _wrap_FXTopWindow_allocate);
    rb_define_method(cFXTopWindow.klass, "initialize", VALUEFUNC(_wrap_new_FXTopWindow), -1);
    rb_define_method(cFXTopWindow.klass, "onFocusUp", VALUEFUNC(_wrap_FXTopWindow_onFocusUp), -1);
    rb_define_method(cFXTopWindow.klass, "onFocusDown", VALUEFUNC(_wrap_FXTopWindow_onFocusDown), -1);
    rb_define_method(cFXTopWindow.klass, "onFocusLeft", VALUEFUNC(_wrap_FXTopWindow_onFocusLeft), -1);
    rb_define_method(cFXTopWindow.klass, "onFocusRight", VALUEFUNC(_wrap_FXTopWindow_onFocusRight), -1);
    rb_define_method(cFXTopWindow.klass, "onCmdMaximize", VALUEFUNC(_wrap_FXTopWindow_onCmdMaximize), -1);
    rb_define_method(cFXTopWindow.klass, "onCmdMinimize", VALUEFUNC(_wrap_FXTopWindow_onCmdMinimize), -1);
    rb_define_method(cFXTopWindow.klass, "onCmdRestore", VALUEFUNC(_wrap_FXTopWindow_onCmdRestore), -1);
    rb_define_method(cFXTopWindow.klass, "onCmdClose", VALUEFUNC(_wrap_FXTopWindow_onCmdClose), -1);
    rb_define_method(cFXTopWindow.klass, "onCmdSetStringValue", VALUEFUNC(_wrap_FXTopWindow_onCmdSetStringValue), -1);
    rb_define_method(cFXTopWindow.klass, "onCmdGetStringValue", VALUEFUNC(_wrap_FXTopWindow_onCmdGetStringValue), -1);
    rb_define_method(cFXTopWindow.klass, "onCmdSetIconValue", VALUEFUNC(_wrap_FXTopWindow_onCmdSetIconValue), -1);
    rb_define_method(cFXTopWindow.klass, "onCmdGetIconValue", VALUEFUNC(_wrap_FXTopWindow_onCmdGetIconValue), -1);
    rb_define_const(cFXTopWindow.klass,"ID_MAXIMIZE", INT2NUM(FXTopWindow::ID_MAXIMIZE));
    rb_define_const(cFXTopWindow.klass,"ID_MINIMIZE", INT2NUM(FXTopWindow::ID_MINIMIZE));
    rb_define_const(cFXTopWindow.klass,"ID_RESTORE", INT2NUM(FXTopWindow::ID_RESTORE));
    rb_define_const(cFXTopWindow.klass,"ID_CLOSE", INT2NUM(FXTopWindow::ID_CLOSE));
    rb_define_const(cFXTopWindow.klass,"ID_QUERY_DOCK", INT2NUM(FXTopWindow::ID_QUERY_DOCK));
    rb_define_const(cFXTopWindow.klass,"ID_LAST", INT2NUM(FXTopWindow::ID_LAST));
    rb_define_method(cFXTopWindow.klass, "place", VALUEFUNC(_wrap_FXTopWindow_place), -1);
    rb_define_method(cFXTopWindow.klass, "isMaximized", VALUEFUNC(_wrap_FXTopWindow_isMaximized), -1);
    rb_define_method(cFXTopWindow.klass, "isMinimized", VALUEFUNC(_wrap_FXTopWindow_isMinimized), -1);
    rb_define_method(cFXTopWindow.klass, "setTitle", VALUEFUNC(_wrap_FXTopWindow_setTitle), -1);
    rb_define_method(cFXTopWindow.klass, "getTitle", VALUEFUNC(_wrap_FXTopWindow_getTitle), -1);
    rb_define_method(cFXTopWindow.klass, "setPadTop", VALUEFUNC(_wrap_FXTopWindow_setPadTop), -1);
    rb_define_method(cFXTopWindow.klass, "getPadTop", VALUEFUNC(_wrap_FXTopWindow_getPadTop), -1);
    rb_define_method(cFXTopWindow.klass, "setPadBottom", VALUEFUNC(_wrap_FXTopWindow_setPadBottom), -1);
    rb_define_method(cFXTopWindow.klass, "getPadBottom", VALUEFUNC(_wrap_FXTopWindow_getPadBottom), -1);
    rb_define_method(cFXTopWindow.klass, "setPadLeft", VALUEFUNC(_wrap_FXTopWindow_setPadLeft), -1);
    rb_define_method(cFXTopWindow.klass, "getPadLeft", VALUEFUNC(_wrap_FXTopWindow_getPadLeft), -1);
    rb_define_method(cFXTopWindow.klass, "setPadRight", VALUEFUNC(_wrap_FXTopWindow_setPadRight), -1);
    rb_define_method(cFXTopWindow.klass, "getPadRight", VALUEFUNC(_wrap_FXTopWindow_getPadRight), -1);
    rb_define_method(cFXTopWindow.klass, "getHSpacing", VALUEFUNC(_wrap_FXTopWindow_getHSpacing), -1);
    rb_define_method(cFXTopWindow.klass, "getVSpacing", VALUEFUNC(_wrap_FXTopWindow_getVSpacing), -1);
    rb_define_method(cFXTopWindow.klass, "setHSpacing", VALUEFUNC(_wrap_FXTopWindow_setHSpacing), -1);
    rb_define_method(cFXTopWindow.klass, "setVSpacing", VALUEFUNC(_wrap_FXTopWindow_setVSpacing), -1);
    rb_define_method(cFXTopWindow.klass, "setPackingHints", VALUEFUNC(_wrap_FXTopWindow_setPackingHints), -1);
    rb_define_method(cFXTopWindow.klass, "getPackingHints", VALUEFUNC(_wrap_FXTopWindow_getPackingHints), -1);
    rb_define_method(cFXTopWindow.klass, "setDecorations", VALUEFUNC(_wrap_FXTopWindow_setDecorations), -1);
    rb_define_method(cFXTopWindow.klass, "getDecorations", VALUEFUNC(_wrap_FXTopWindow_getDecorations), -1);
    rb_define_method(cFXTopWindow.klass, "getIcon", VALUEFUNC(_wrap_FXTopWindow_getIcon), -1);
    rb_define_method(cFXTopWindow.klass, "setIcon", VALUEFUNC(_wrap_FXTopWindow_setIcon), -1);
    rb_define_method(cFXTopWindow.klass, "getMiniIcon", VALUEFUNC(_wrap_FXTopWindow_getMiniIcon), -1);
    rb_define_method(cFXTopWindow.klass, "setMiniIcon", VALUEFUNC(_wrap_FXTopWindow_setMiniIcon), -1);
    rb_define_method(cFXTopWindow.klass, "save", VALUEFUNC(_wrap_FXTopWindow_save), -1);
    rb_define_method(cFXTopWindow.klass, "load", VALUEFUNC(_wrap_FXTopWindow_load), -1);
    rb_define_method(cFXTopWindow.klass, "create", VALUEFUNC(_wrap_FXTopWindow_create), -1);
    rb_define_method(cFXTopWindow.klass, "detach", VALUEFUNC(_wrap_FXTopWindow_detach), -1);
    rb_define_method(cFXTopWindow.klass, "destroy", VALUEFUNC(_wrap_FXTopWindow_destroy), -1);
    rb_define_method(cFXTopWindow.klass, "resize", VALUEFUNC(_wrap_FXTopWindow_resize), -1);
    rb_define_method(cFXTopWindow.klass, "getDefaultWidth", VALUEFUNC(_wrap_FXTopWindow_getDefaultWidth), -1);
    rb_define_method(cFXTopWindow.klass, "getDefaultHeight", VALUEFUNC(_wrap_FXTopWindow_getDefaultHeight), -1);
    rb_define_method(cFXTopWindow.klass, "getWidthForHeight", VALUEFUNC(_wrap_FXTopWindow_getWidthForHeight), -1);
    rb_define_method(cFXTopWindow.klass, "getHeightForWidth", VALUEFUNC(_wrap_FXTopWindow_getHeightForWidth), -1);
    rb_define_method(cFXTopWindow.klass, "canFocus", VALUEFUNC(_wrap_FXTopWindow_canFocus), -1);
    rb_define_method(cFXTopWindow.klass, "setFocus", VALUEFUNC(_wrap_FXTopWindow_setFocus), -1);
    rb_define_method(cFXTopWindow.klass, "killFocus", VALUEFUNC(_wrap_FXTopWindow_killFocus), -1);
    rb_define_method(cFXTopWindow.klass, "setDefault", VALUEFUNC(_wrap_FXTopWindow_setDefault), -1);
    rb_define_method(cFXTopWindow.klass, "enable", VALUEFUNC(_wrap_FXTopWindow_enable), -1);
    rb_define_method(cFXTopWindow.klass, "disable", VALUEFUNC(_wrap_FXTopWindow_disable), -1);
    rb_define_method(cFXTopWindow.klass, "raiseWindow", VALUEFUNC(_wrap_FXTopWindow_raiseWindow), -1);
    rb_define_method(cFXTopWindow.klass, "lower", VALUEFUNC(_wrap_FXTopWindow_lower), -1);
    rb_define_method(cFXTopWindow.klass, "move", VALUEFUNC(_wrap_FXTopWindow_move), -1);
    rb_define_method(cFXTopWindow.klass, "position", VALUEFUNC(_wrap_FXTopWindow_position), -1);
    rb_define_method(cFXTopWindow.klass, "layout", VALUEFUNC(_wrap_FXTopWindow_layout), -1);
    rb_define_method(cFXTopWindow.klass, "recalc", VALUEFUNC(_wrap_FXTopWindow_recalc), -1);
    rb_define_method(cFXTopWindow.klass, "reparent", VALUEFUNC(_wrap_FXTopWindow_reparent), -1);
    rb_define_method(cFXTopWindow.klass, "hide", VALUEFUNC(_wrap_FXTopWindow_hide), -1);
    rb_define_method(cFXTopWindow.klass, "isComposite", VALUEFUNC(_wrap_FXTopWindow_isComposite), -1);
    rb_define_method(cFXTopWindow.klass, "contains", VALUEFUNC(_wrap_FXTopWindow_contains), -1);
    rb_define_method(cFXTopWindow.klass, "doesSaveUnder", VALUEFUNC(_wrap_FXTopWindow_doesSaveUnder), -1);
    rb_define_method(cFXTopWindow.klass, "setBackColor", VALUEFUNC(_wrap_FXTopWindow_setBackColor), -1);
    rb_define_method(cFXTopWindow.klass, "show", VALUEFUNC(_wrap_FXTopWindow_show), -1);
    rb_define_method(cFXTopWindow.klass, "maximize", VALUEFUNC(_wrap_FXTopWindow_maximize), -1);
    rb_define_method(cFXTopWindow.klass, "minimize", VALUEFUNC(_wrap_FXTopWindow_minimize), -1);
    rb_define_method(cFXTopWindow.klass, "restore", VALUEFUNC(_wrap_FXTopWindow_restore), -1);
    rb_define_method(cFXTopWindow.klass, "close", VALUEFUNC(_wrap_FXTopWindow_close), -1);
    cFXTopWindow.mark = (void (*)(void *)) FXRbTopWindow::markfunc;
    cFXTopWindow.destroy = (void (*)(void *)) FXRbObject::freefunc;
    
    SWIGTYPE_p_FXTopWindow->dcast = (swig_dycast_func) FXTopWindow_dynamic_cast;
    
    
    cFXMainWindow.klass = rb_define_class_under(mFox, "FXMainWindow", ((swig_class *) SWIGTYPE_p_FXTopWindow->clientdata)->klass);
    SWIG_TypeClientData(SWIGTYPE_p_FXMainWindow, (void *) &cFXMainWindow);
    rb_define_alloc_func(cFXMainWindow.klass, _wrap_FXMainWindow_allocate);
    rb_define_method(cFXMainWindow.klass, "initialize", VALUEFUNC(_wrap_new_FXMainWindow), -1);
    rb_define_method(cFXMainWindow.klass, "save", VALUEFUNC(_wrap_FXMainWindow_save), -1);
    rb_define_method(cFXMainWindow.klass, "load", VALUEFUNC(_wrap_FXMainWindow_load), -1);
    rb_define_method(cFXMainWindow.klass, "create", VALUEFUNC(_wrap_FXMainWindow_create), -1);
    rb_define_method(cFXMainWindow.klass, "detach", VALUEFUNC(_wrap_FXMainWindow_detach), -1);
    rb_define_method(cFXMainWindow.klass, "destroy", VALUEFUNC(_wrap_FXMainWindow_destroy), -1);
    rb_define_method(cFXMainWindow.klass, "resize", VALUEFUNC(_wrap_FXMainWindow_resize), -1);
    rb_define_method(cFXMainWindow.klass, "getDefaultWidth", VALUEFUNC(_wrap_FXMainWindow_getDefaultWidth), -1);
    rb_define_method(cFXMainWindow.klass, "getDefaultHeight", VALUEFUNC(_wrap_FXMainWindow_getDefaultHeight), -1);
    rb_define_method(cFXMainWindow.klass, "getWidthForHeight", VALUEFUNC(_wrap_FXMainWindow_getWidthForHeight), -1);
    rb_define_method(cFXMainWindow.klass, "getHeightForWidth", VALUEFUNC(_wrap_FXMainWindow_getHeightForWidth), -1);
    rb_define_method(cFXMainWindow.klass, "canFocus", VALUEFUNC(_wrap_FXMainWindow_canFocus), -1);
    rb_define_method(cFXMainWindow.klass, "setFocus", VALUEFUNC(_wrap_FXMainWindow_setFocus), -1);
    rb_define_method(cFXMainWindow.klass, "killFocus", VALUEFUNC(_wrap_FXMainWindow_killFocus), -1);
    rb_define_method(cFXMainWindow.klass, "setDefault", VALUEFUNC(_wrap_FXMainWindow_setDefault), -1);
    rb_define_method(cFXMainWindow.klass, "enable", VALUEFUNC(_wrap_FXMainWindow_enable), -1);
    rb_define_method(cFXMainWindow.klass, "disable", VALUEFUNC(_wrap_FXMainWindow_disable), -1);
    rb_define_method(cFXMainWindow.klass, "raiseWindow", VALUEFUNC(_wrap_FXMainWindow_raiseWindow), -1);
    rb_define_method(cFXMainWindow.klass, "lower", VALUEFUNC(_wrap_FXMainWindow_lower), -1);
    rb_define_method(cFXMainWindow.klass, "move", VALUEFUNC(_wrap_FXMainWindow_move), -1);
    rb_define_method(cFXMainWindow.klass, "position", VALUEFUNC(_wrap_FXMainWindow_position), -1);
    rb_define_method(cFXMainWindow.klass, "layout", VALUEFUNC(_wrap_FXMainWindow_layout), -1);
    rb_define_method(cFXMainWindow.klass, "recalc", VALUEFUNC(_wrap_FXMainWindow_recalc), -1);
    rb_define_method(cFXMainWindow.klass, "reparent", VALUEFUNC(_wrap_FXMainWindow_reparent), -1);
    rb_define_method(cFXMainWindow.klass, "hide", VALUEFUNC(_wrap_FXMainWindow_hide), -1);
    rb_define_method(cFXMainWindow.klass, "isComposite", VALUEFUNC(_wrap_FXMainWindow_isComposite), -1);
    rb_define_method(cFXMainWindow.klass, "contains", VALUEFUNC(_wrap_FXMainWindow_contains), -1);
    rb_define_method(cFXMainWindow.klass, "doesSaveUnder", VALUEFUNC(_wrap_FXMainWindow_doesSaveUnder), -1);
    rb_define_method(cFXMainWindow.klass, "setBackColor", VALUEFUNC(_wrap_FXMainWindow_setBackColor), -1);
    rb_define_method(cFXMainWindow.klass, "show", VALUEFUNC(_wrap_FXMainWindow_show), -1);
    rb_define_method(cFXMainWindow.klass, "maximize", VALUEFUNC(_wrap_FXMainWindow_maximize), -1);
    rb_define_method(cFXMainWindow.klass, "minimize", VALUEFUNC(_wrap_FXMainWindow_minimize), -1);
    rb_define_method(cFXMainWindow.klass, "restore", VALUEFUNC(_wrap_FXMainWindow_restore), -1);
    rb_define_method(cFXMainWindow.klass, "close", VALUEFUNC(_wrap_FXMainWindow_close), -1);
    cFXMainWindow.mark = (void (*)(void *)) FXRbMainWindow::markfunc;
    cFXMainWindow.destroy = (void (*)(void *)) FXRbObject::freefunc;
}

