/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 1.3.22
 * 
 * This file is not intended to be easily readable and contains a number of 
 * coding conventions designed to improve portability and efficiency. Do not make
 * changes to this file unless you know what you are doing--modify the SWIG 
 * interface file instead. 
 * ----------------------------------------------------------------------------- */

#define SWIG_NOINCLUDE

#ifdef __cplusplus
template<class T> class SwigValueWrapper {
    T *tt;
public:
    SwigValueWrapper() : tt(0) { }
    SwigValueWrapper(const SwigValueWrapper<T>& rhs) : tt(new T(*rhs.tt)) { }
    SwigValueWrapper(const T& t) : tt(new T(t)) { }
    ~SwigValueWrapper() { delete tt; } 
    SwigValueWrapper& operator=(const T& t) { delete tt; tt = new T(t); return *this; }
    operator T&() const { return *tt; }
    T *operator&() { return tt; }
private:
    SwigValueWrapper& operator=(const SwigValueWrapper<T>& rhs);
};                                                    
#endif

/* ruby.swg */
/* Implementation : RUBY */
#define SWIGRUBY 1

#include "ruby.h"

/* Flags for pointer conversion */
#define SWIG_POINTER_EXCEPTION     0x1
#define SWIG_POINTER_DISOWN        0x2

#define NUM2USHRT(n) (\
    (0 <= NUM2UINT(n) && NUM2UINT(n) <= USHRT_MAX)\
    ? (unsigned short) NUM2UINT(n) \
    : (rb_raise(rb_eArgError, "integer %d out of range of `unsigned short'",\
               NUM2UINT(n)), (short)0)\
)

#define NUM2SHRT(n) (\
    (SHRT_MIN <= NUM2INT(n) && NUM2INT(n) <= SHRT_MAX)\
    ? (short)NUM2INT(n)\
    : (rb_raise(rb_eArgError, "integer %d out of range of `short'",\
               NUM2INT(n)), (short)0)\
)

/* Ruby 1.7 defines NUM2LL(), LL2NUM() and ULL2NUM() macros */
#ifndef NUM2LL
#define NUM2LL(x) NUM2LONG((x))
#endif
#ifndef LL2NUM
#define LL2NUM(x) INT2NUM((long) (x))
#endif
#ifndef ULL2NUM
#define ULL2NUM(x) UINT2NUM((unsigned long) (x))
#endif

/* Ruby 1.7 doesn't (yet) define NUM2ULL() */
#ifndef NUM2ULL
#ifdef HAVE_LONG_LONG
#define NUM2ULL(x) rb_num2ull((x))
#else
#define NUM2ULL(x) NUM2ULONG(x)
#endif
#endif

/*
 * Need to be very careful about how these macros are defined, especially
 * when compiling C++ code or C code with an ANSI C compiler.
 *
 * VALUEFUNC(f) is a macro used to typecast a C function that implements
 * a Ruby method so that it can be passed as an argument to API functions
 * like rb_define_method() and rb_define_singleton_method().
 *
 * VOIDFUNC(f) is a macro used to typecast a C function that implements
 * either the "mark" or "free" stuff for a Ruby Data object, so that it
 * can be passed as an argument to API functions like Data_Wrap_Struct()
 * and Data_Make_Struct().
 */
 
#ifdef __cplusplus
#  ifndef RUBY_METHOD_FUNC /* These definitions should work for Ruby 1.4.6 */
#    define PROTECTFUNC(f) ((VALUE (*)()) f)
#    define VALUEFUNC(f) ((VALUE (*)()) f)
#    define VOIDFUNC(f)  ((void (*)()) f)
#  else
#    ifndef ANYARGS /* These definitions should work for Ruby 1.6 */
#      define PROTECTFUNC(f) ((VALUE (*)()) f)
#      define VALUEFUNC(f) ((VALUE (*)()) f)
#      define VOIDFUNC(f)  ((RUBY_DATA_FUNC) f)
#    else /* These definitions should work for Ruby 1.7+ */
#      define PROTECTFUNC(f) ((VALUE (*)(VALUE)) f)
#      define VALUEFUNC(f) ((VALUE (*)(ANYARGS)) f)
#      define VOIDFUNC(f)  ((RUBY_DATA_FUNC) f)
#    endif
#  endif
#else
#  define VALUEFUNC(f) (f)
#  define VOIDFUNC(f) (f)
#endif

typedef struct {
  VALUE klass;
  VALUE mImpl;
  void  (*mark)(void *);
  void  (*destroy)(void *);
} swig_class;

/* Don't use for expressions have side effect */
#ifndef RB_STRING_VALUE
#define RB_STRING_VALUE(s) (TYPE(s) == T_STRING ? (s) : (*(volatile VALUE *)&(s) = rb_str_to_str(s)))
#endif
#ifndef StringValue
#define StringValue(s) RB_STRING_VALUE(s)
#endif
#ifndef StringValuePtr
#define StringValuePtr(s) RSTRING(RB_STRING_VALUE(s))->ptr
#endif
#ifndef StringValueLen
#define StringValueLen(s) RSTRING(RB_STRING_VALUE(s))->len
#endif
#ifndef SafeStringValue
#define SafeStringValue(v) do {\
    StringValue(v);\
    rb_check_safe_str(v);\
} while (0)
#endif

#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
#define rb_define_alloc_func(klass, func) rb_define_singleton_method((klass), "new", VALUEFUNC((func)), -1)
#define rb_undef_alloc_func(klass) rb_undef_method(CLASS_OF((klass)), "new")
#endif

/* Contract support */

#define SWIG_contract_assert(expr, msg) if (!(expr)) { rb_raise(rb_eRuntimeError, (char *) msg ); } else


/*************************************************************** -*- c -*-
 * ruby/precommon.swg
 *
 * Rename all exported symbols from common.swg, to avoid symbol
 * clashes if multiple interpreters are included
 *
 ************************************************************************/

#define SWIG_TypeRegister    SWIG_Ruby_TypeRegister
#define SWIG_TypeCheck       SWIG_Ruby_TypeCheck
#define SWIG_TypeCast        SWIG_Ruby_TypeCast
#define SWIG_TypeDynamicCast SWIG_Ruby_TypeDynamicCast
#define SWIG_TypeName        SWIG_Ruby_TypeName
#define SWIG_TypePrettyName  SWIG_Ruby_TypePrettyName
#define SWIG_TypeQuery       SWIG_Ruby_TypeQuery
#define SWIG_TypeClientData  SWIG_Ruby_TypeClientData
#define SWIG_PackData        SWIG_Ruby_PackData 
#define SWIG_UnpackData      SWIG_Ruby_UnpackData 

/* Also rename all exported symbols from rubydef.swig */

/* Common SWIG API */
#define SWIG_ConvertPtr(obj, pp, type, flags) \
  SWIG_Ruby_ConvertPtr(obj, pp, type, flags)
#define SWIG_NewPointerObj(p, type, flags) \
  SWIG_Ruby_NewPointerObj(p, type, flags)
#define SWIG_MustGetPtr(p, type, argnum, flags) \
  SWIG_Ruby_MustGetPtr(p, type, argnum, flags)

/* Ruby-specific SWIG API */

#define SWIG_InitRuntime() \
  SWIG_Ruby_InitRuntime()
#define SWIG_define_class(ty) \
  SWIG_Ruby_define_class(ty)
#define SWIG_NewClassInstance(value, ty) \
  SWIG_Ruby_NewClassInstance(value, ty)
#define SWIG_MangleStr(value) \
  SWIG_Ruby_MangleStr(value)
#define SWIG_CheckConvert(value, ty) \
  SWIG_Ruby_CheckConvert(value, ty)
#define SWIG_NewPackedObj(ptr, sz, ty) \
  SWIG_Ruby_NewPackedObj(ptr, sz, ty)
#define SWIG_ConvertPacked(obj, ptr, sz, ty, flags) \
  SWIG_Ruby_ConvertPacked(obj, ptr, sz, ty, flags)


/***********************************************************************
 * common.swg
 *
 *     This file contains generic SWIG runtime support for pointer
 *     type checking as well as a few commonly used macros to control
 *     external linkage.
 *
 * Author : David Beazley (beazley@cs.uchicago.edu)
 *
 * Copyright (c) 1999-2000, The University of Chicago
 * 
 * This file may be freely redistributed without license or fee provided
 * this copyright message remains intact.
 ************************************************************************/

#include <string.h>

#if defined(_WIN32) || defined(__WIN32__) || defined(__CYGWIN__)
#  if defined(_MSC_VER) || defined(__GNUC__)
#    if defined(STATIC_LINKED)
#      define SWIGEXPORT(a) a
#      define SWIGIMPORT(a) extern a
#    else
#      define SWIGEXPORT(a) __declspec(dllexport) a
#      define SWIGIMPORT(a) extern a
#    endif
#  else
#    if defined(__BORLANDC__)
#      define SWIGEXPORT(a) a _export
#      define SWIGIMPORT(a) a _export
#    else
#      define SWIGEXPORT(a) a
#      define SWIGIMPORT(a) a
#    endif
#  endif
#else
#  define SWIGEXPORT(a) a
#  define SWIGIMPORT(a) a
#endif

#ifdef SWIG_GLOBAL
#  define SWIGRUNTIME(a) SWIGEXPORT(a)
#else
#  define SWIGRUNTIME(a) static a
#endif

#ifdef __cplusplus
extern "C" {
#endif

typedef void *(*swig_converter_func)(void *);
typedef struct swig_type_info *(*swig_dycast_func)(void **);

typedef struct swig_type_info {
  const char             *name;
  swig_converter_func     converter;
  const char             *str;
  void                   *clientdata;
  swig_dycast_func        dcast;
  struct swig_type_info  *next;
  struct swig_type_info  *prev;
} swig_type_info;

#ifdef SWIG_NOINCLUDE

SWIGIMPORT(swig_type_info *) SWIG_TypeRegister(swig_type_info *);
SWIGIMPORT(swig_type_info *) SWIG_TypeCheck(char *c, swig_type_info *);
SWIGIMPORT(void *)           SWIG_TypeCast(swig_type_info *, void *);
SWIGIMPORT(swig_type_info *) SWIG_TypeDynamicCast(swig_type_info *, void **);
SWIGIMPORT(const char *)     SWIG_TypeName(const swig_type_info *);
SWIGIMPORT(const char *)     SWIG_TypePrettyName(const swig_type_info *);
SWIGIMPORT(swig_type_info *) SWIG_TypeQuery(const char *);
SWIGIMPORT(void)             SWIG_TypeClientData(swig_type_info *, void *);
SWIGIMPORT(char *)           SWIG_PackData(char *, void *, int);
SWIGIMPORT(char *)           SWIG_UnpackData(char *, void *, int);

#else

static swig_type_info *swig_type_list = 0;
static swig_type_info **swig_type_list_handle = &swig_type_list;

/* Register a type mapping with the type-checking */
SWIGRUNTIME(swig_type_info *)
SWIG_TypeRegister(swig_type_info *ti) {
  swig_type_info *tc, *head, *ret, *next;
  /* Check to see if this type has already been registered */
  tc = *swig_type_list_handle;
  while (tc) {
    if (strcmp(tc->name, ti->name) == 0) {
      /* Already exists in the table.  Just add additional types to the list */
      if (tc->clientdata) ti->clientdata = tc->clientdata;
      head = tc;
      next = tc->next;
      goto l1;
    }
    tc = tc->prev;
  }
  head = ti;
  next = 0;

  /* Place in list */
  ti->prev = *swig_type_list_handle;
  *swig_type_list_handle = ti;

  /* Build linked lists */
  l1:
  ret = head;
  tc = ti + 1;
  /* Patch up the rest of the links */
  while (tc->name) {
    head->next = tc;
    tc->prev = head;
    head = tc;
    tc++;
  }
  if (next) next->prev = head;
  head->next = next;
  return ret;
}

/* Check the typename */
SWIGRUNTIME(swig_type_info *) 
SWIG_TypeCheck(char *c, swig_type_info *ty) {
  swig_type_info *s;
  if (!ty) return 0;        /* Void pointer */
  s = ty->next;             /* First element always just a name */
  do {
    if (strcmp(s->name,c) == 0) {
      if (s == ty->next) return s;
      /* Move s to the top of the linked list */
      s->prev->next = s->next;
      if (s->next) {
        s->next->prev = s->prev;
      }
      /* Insert s as second element in the list */
      s->next = ty->next;
      if (ty->next) ty->next->prev = s;
      ty->next = s;
      s->prev = ty;
      return s;
    }
    s = s->next;
  } while (s && (s != ty->next));
  return 0;
}

/* Cast a pointer up an inheritance hierarchy */
SWIGRUNTIME(void *) 
SWIG_TypeCast(swig_type_info *ty, void *ptr) {
  if ((!ty) || (!ty->converter)) return ptr;
  return (*ty->converter)(ptr);
}

/* Dynamic pointer casting. Down an inheritance hierarchy */
SWIGRUNTIME(swig_type_info *) 
SWIG_TypeDynamicCast(swig_type_info *ty, void **ptr) {
  swig_type_info *lastty = ty;
  if (!ty || !ty->dcast) return ty;
  while (ty && (ty->dcast)) {
    ty = (*ty->dcast)(ptr);
    if (ty) lastty = ty;
  }
  return lastty;
}

/* Return the name associated with this type */
SWIGRUNTIME(const char *)
SWIG_TypeName(const swig_type_info *ty) {
  return ty->name;
}

/* Return the pretty name associated with this type,
   that is an unmangled type name in a form presentable to the user.
*/
SWIGRUNTIME(const char *)
SWIG_TypePrettyName(const swig_type_info *type) {
  /* The "str" field contains the equivalent pretty names of the
     type, separated by vertical-bar characters.  We choose
     to print the last name, as it is often (?) the most
     specific. */
  if (type->str != NULL) {
    const char *last_name = type->str;
    const char *s;
    for (s = type->str; *s; s++)
      if (*s == '|') last_name = s+1;
    return last_name;
  }
  else
    return type->name;
}

/* 
   Compare two type names skipping the space characters, therefore
   "char*" == "char *" and "Class<int>" == "Class<int >", etc.

   Return 0 when the two name types are equivalent, as in
   strncmp, but skipping ' '.
*/
static int
SWIG_TypeNameComp(const char *f1, const char *l1,
		  const char *f2, const char *l2) {
  for (;(f1 != l1) && (f2 != l2); ++f1, ++f2) {
    while ((*f1 == ' ') && (f1 != l1)) ++f1;
    while ((*f2 == ' ') && (f2 != l2)) ++f2;
    if (*f1 != *f2) return *f1 - *f2;
  }
  return (l1 - f1) - (l2 - f2);
}

/*
  Check type equivalence in a name list like <name1>|<name2>|...
*/
static int
SWIG_TypeEquiv(const char *nb, const char *tb) {
  int equiv = 0;
  const char* te = tb + strlen(tb);
  const char* ne = nb;
  while (!equiv && *ne) {
    for (nb = ne; *ne; ++ne) {
      if (*ne == '|') break;
    }
    equiv = SWIG_TypeNameComp(nb, ne, tb, te) == 0;
    if (*ne) ++ne;
  }
  return equiv;
}
  

/* Search for a swig_type_info structure */
SWIGRUNTIME(swig_type_info *)
SWIG_TypeQuery(const char *name) {
  swig_type_info *ty = *swig_type_list_handle;
  while (ty) {
    if (ty->str && (SWIG_TypeEquiv(ty->str,name))) return ty;
    if (ty->name && (strcmp(name,ty->name) == 0)) return ty;
    ty = ty->prev;
  }
  return 0;
}

/* Set the clientdata field for a type */
SWIGRUNTIME(void)
SWIG_TypeClientData(swig_type_info *ti, void *clientdata) {
  swig_type_info *tc, *equiv;
  if (ti->clientdata == clientdata) return;
  ti->clientdata = clientdata;
  equiv = ti->next;
  while (equiv) {
    if (!equiv->converter) {
      tc = *swig_type_list_handle;
      while (tc) {
        if ((strcmp(tc->name, equiv->name) == 0))
          SWIG_TypeClientData(tc,clientdata);
        tc = tc->prev;
      }
    }
    equiv = equiv->next;
  }
}

/* Pack binary data into a string */
SWIGRUNTIME(char *)
SWIG_PackData(char *c, void *ptr, int sz) {
  static char hex[17] = "0123456789abcdef";
  unsigned char *u = (unsigned char *) ptr;
  const unsigned char *eu =  u + sz;
  register unsigned char uu;
  for (; u != eu; ++u) {
    uu = *u;
    *(c++) = hex[(uu & 0xf0) >> 4];
    *(c++) = hex[uu & 0xf];
  }
  return c;
}

/* Unpack binary data from a string */
SWIGRUNTIME(char *)
SWIG_UnpackData(char *c, void *ptr, int sz) {
  register unsigned char uu = 0;
  register int d;
  unsigned char *u = (unsigned char *) ptr;
  const unsigned char *eu =  u + sz;
  for (; u != eu; ++u) {
    d = *(c++);
    if ((d >= '0') && (d <= '9'))
      uu = ((d - '0') << 4);
    else if ((d >= 'a') && (d <= 'f'))
      uu = ((d - ('a'-10)) << 4);
    d = *(c++);
    if ((d >= '0') && (d <= '9'))
      uu |= (d - '0');
    else if ((d >= 'a') && (d <= 'f'))
      uu |= (d - ('a'-10));
    *u = uu;
  }
  return c;
}

#endif

#ifdef __cplusplus
}
#endif

/* rubydec.swg -*- c -*- */
#ifdef __cplusplus
extern "C" {
#endif

SWIGIMPORT(void)   SWIG_Ruby_InitRuntime(void);
SWIGIMPORT(void)   SWIG_Ruby_define_class(swig_type_info *);
SWIGIMPORT(VALUE)  SWIG_Ruby_NewPointerObj(void *, swig_type_info *, int);
SWIGIMPORT(VALUE)  SWIG_Ruby_NewClassInstance(VALUE, swig_type_info *);
SWIGIMPORT(char *) SWIG_Ruby_MangleStr(VALUE);
SWIGIMPORT(int)    SWIG_Ruby_ConvertPtr(VALUE, void**, swig_type_info *, int);
SWIGIMPORT(void *) SWIG_Ruby_MustGetPtr(VALUE, swig_type_info *, int, int);
SWIGIMPORT(int)    SWIG_Ruby_CheckConvert(VALUE, swig_type_info *);
SWIGIMPORT(VALUE)  SWIG_Ruby_NewPackedObj(void *ptr, int sz, swig_type_info *type);
SWIGIMPORT(void)   SWIG_Ruby_ConvertPacked(VALUE obj, void *ptr, int sz, swig_type_info *ty, int flags);

#ifdef __cplusplus
}
#endif


/* -------- TYPES TABLE (BEGIN) -------- */

#define  SWIGTYPE_p_FXDCWindow swig_types[0] 
#define  SWIGTYPE_p_FXDC swig_types[1] 
#define  SWIGTYPE_p_FXPrinter swig_types[2] 
#define  SWIGTYPE_p_FXPSBounds swig_types[3] 
#define  SWIGTYPE_p_FXBitmap swig_types[4] 
#define  SWIGTYPE_p_FXRectangle swig_types[5] 
#define  SWIGTYPE_p_FXFont swig_types[6] 
#define  SWIGTYPE_p_FXDrawable swig_types[7] 
#define  SWIGTYPE_p_FXString swig_types[8] 
#define  SWIGTYPE_p_FXDCPrint swig_types[9] 
#define  SWIGTYPE_p_FXIcon swig_types[10] 
#define  SWIGTYPE_p_FXRegion swig_types[11] 
#define  SWIGTYPE_p_FXArc swig_types[12] 
#define  SWIGTYPE_p_FXApp swig_types[13] 
#define  SWIGTYPE_p_FXEvent swig_types[14] 
#define  SWIGTYPE_p_FXImage swig_types[15] 
#define  SWIGTYPE_p_FXSegment swig_types[16] 
static swig_type_info *swig_types[18];

/* -------- TYPES TABLE (END) -------- */

#define SWIG_init    Init_dc
#define SWIG_name    "Dc"


static void SWIG_AsVal(VALUE obj, int *val)
{
    *val = (int) NUM2INT(obj);
}


#include "FXRbCommon.h"


inline FXColor to_FXColor(VALUE obj){
  if(TYPE(obj)==T_STRING){
    return fxcolorfromname(StringValuePtr(obj));
    }
  else if(TYPE(obj)==T_SYMBOL){
    return fxcolorfromname(rb_id2name(SYM2ID(obj)));
    }
  else{
    return NUM2ULONG(obj);
    }
  }


inline FXString to_FXString(VALUE obj){
  if(!NIL_P(obj)){
    Check_Type(obj,T_STRING);
    return FXString(STR2CSTR(obj));
    }
  else{
    return FXString::null;
    }
  }


inline FXbool to_FXbool(VALUE obj){
  if (obj == Qtrue || obj == Qfalse){
    return (obj == Qtrue) ? TRUE : FALSE;
    }
  else{
    return static_cast<FXbool>(NUM2UINT(obj));
    }
  }


static swig_type_info* FXEventTypeInfo=0;

inline void* to_FXEvent(VALUE obj){
  void* ptr;
  if(!FXEventTypeInfo){
    FXEventTypeInfo=SWIG_TypeQuery("FXEvent *");
    FXASSERT(FXEventTypeInfo!=0);
    }
  SWIG_ConvertPtr(obj,&ptr,FXEventTypeInfo,1);
  return ptr;
  }

FXSegment *new_FXSegment(FXshort x1,FXshort y1,FXshort x2,FXshort y2){
      FXSegment* seg=new FXSegment;
      seg->x1=x1; seg->y1=y1; seg->x2=x2; seg->y2=y2;
      return seg;
      }

swig_class cFXSegment;
static void free_FXSegment(FXSegment *);
FXArc *new_FXArc(FXshort x,FXshort y,FXshort w,FXshort h,FXshort a,FXshort b){
      FXArc* arc=new FXArc;
      arc->x=x; arc->y=y; arc->w=w; arc->h=h; arc->a=a; arc->b=b;
      return arc;
      }

swig_class cFXArc;
static void free_FXArc(FXArc *);
FXDC *new_FXDC(FXApp *a){
      return new FXRbDC(a);
      }
VALUE FXDC_getDashPattern(FXDC const *self){
      return FXRbMakeArray(self->getDashPattern(), self->getDashLength());
      }

swig_class cFXDC;
static void free_FXDC(FXDC *);
FXDCWindow *new_FXDCWindow__SWIG_0(FXDrawable *drawable,FXEvent *event){
      return new FXRbDCWindow(drawable,event);
      }
FXDCWindow *new_FXDCWindow__SWIG_1(FXDrawable *drawable){
      return new FXRbDCWindow(drawable);
      }

swig_class cFXDCWindow;
static void free_FXDCWindow(FXDCWindow *);

swig_class cFXPSBounds;
static void free_FXPSBounds(FXPSBounds *);

swig_class cFXPrinter;
static void free_FXPrinter(FXPrinter *);
FXDCPrint *new_FXDCPrint(FXApp *a){
      return new FXRbDCPrint(a);
      }

swig_class cFXDCPrint;
static void free_FXDCPrint(FXDCPrint *);
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE _wrap_FXSegment_allocate(VALUE self) {
#else
     static VALUE _wrap_FXSegment_allocate(int argc, VALUE *argv, VALUE self) {
#endif
         VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_FXSegment);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
         return vresult; }
static VALUE _wrap_new_FXSegment(int argc, VALUE *argv, VALUE self) { FXshort arg1 = (FXshort) 0 ; FXshort arg2 = (FXshort) 0 ;
    FXshort arg3 = (FXshort) 0 ; FXshort arg4 = (FXshort) 0 ; FXSegment *result; if ((argc < 0) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc); if (argc > 0) { arg1 = NUM2SHRT(argv[0]); }  if (argc > 1) {
        arg2 = NUM2SHRT(argv[1]); }  if (argc > 2) { arg3 = NUM2SHRT(argv[2]); }  if (argc > 3) { arg4 = NUM2SHRT(argv[3]); } 
    result = (FXSegment *)new_FXSegment(arg1,arg2,arg3,arg4); DATA_PTR(self) = result; return self; }
static VALUE _wrap_FXSegment_x1_set(int argc, VALUE *argv, VALUE self) { FXSegment *arg1 = (FXSegment *) 0 ; FXshort arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSegment, 1); arg2 = NUM2SHRT(argv[0]); if (arg1) (arg1)->x1 = arg2;
    return Qnil; }
static VALUE _wrap_FXSegment_x1_get(int argc, VALUE *argv, VALUE self) { FXSegment *arg1 = (FXSegment *) 0 ; FXshort result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSegment, 1); result = (FXshort) ((arg1)->x1); vresult = INT2NUM(result);
    return vresult; }
static VALUE _wrap_FXSegment_y1_set(int argc, VALUE *argv, VALUE self) { FXSegment *arg1 = (FXSegment *) 0 ; FXshort arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSegment, 1); arg2 = NUM2SHRT(argv[0]); if (arg1) (arg1)->y1 = arg2;
    return Qnil; }
static VALUE _wrap_FXSegment_y1_get(int argc, VALUE *argv, VALUE self) { FXSegment *arg1 = (FXSegment *) 0 ; FXshort result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSegment, 1); result = (FXshort) ((arg1)->y1); vresult = INT2NUM(result);
    return vresult; }
static VALUE _wrap_FXSegment_x2_set(int argc, VALUE *argv, VALUE self) { FXSegment *arg1 = (FXSegment *) 0 ; FXshort arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSegment, 1); arg2 = NUM2SHRT(argv[0]); if (arg1) (arg1)->x2 = arg2;
    return Qnil; }
static VALUE _wrap_FXSegment_x2_get(int argc, VALUE *argv, VALUE self) { FXSegment *arg1 = (FXSegment *) 0 ; FXshort result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSegment, 1); result = (FXshort) ((arg1)->x2); vresult = INT2NUM(result);
    return vresult; }
static VALUE _wrap_FXSegment_y2_set(int argc, VALUE *argv, VALUE self) { FXSegment *arg1 = (FXSegment *) 0 ; FXshort arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSegment, 1); arg2 = NUM2SHRT(argv[0]); if (arg1) (arg1)->y2 = arg2;
    return Qnil; }
static VALUE _wrap_FXSegment_y2_get(int argc, VALUE *argv, VALUE self) { FXSegment *arg1 = (FXSegment *) 0 ; FXshort result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSegment, 1); result = (FXshort) ((arg1)->y2); vresult = INT2NUM(result);
    return vresult; }
static void
free_FXSegment(FXSegment *arg1) {
    delete arg1;
}
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE _wrap_FXArc_allocate(VALUE self) {
#else
     static VALUE _wrap_FXArc_allocate(int argc, VALUE *argv, VALUE self) {
#endif
         VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_FXArc);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
         return vresult; }
static VALUE _wrap_new_FXArc(int argc, VALUE *argv, VALUE self) { FXshort arg1 = (FXshort) 0 ; FXshort arg2 = (FXshort) 0 ;
    FXshort arg3 = (FXshort) 0 ; FXshort arg4 = (FXshort) 0 ; FXshort arg5 = (FXshort) 0 ; FXshort arg6 = (FXshort) 0 ;
    FXArc *result; if ((argc < 0) || (argc > 6)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc); if (argc > 0) {
        arg1 = NUM2SHRT(argv[0]); }  if (argc > 1) { arg2 = NUM2SHRT(argv[1]); }  if (argc > 2) { arg3 = NUM2SHRT(argv[2]); } 
    if (argc > 3) { arg4 = NUM2SHRT(argv[3]); }  if (argc > 4) { arg5 = NUM2SHRT(argv[4]); }  if (argc > 5) {
        arg6 = NUM2SHRT(argv[5]); }  result = (FXArc *)new_FXArc(arg1,arg2,arg3,arg4,arg5,arg6); DATA_PTR(self) = result;
    return self; }
static VALUE _wrap_FXArc_x_set(int argc, VALUE *argv, VALUE self) { FXArc *arg1 = (FXArc *) 0 ; FXshort arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXArc, 1); arg2 = NUM2SHRT(argv[0]); if (arg1) (arg1)->x = arg2;
    return Qnil; }
static VALUE _wrap_FXArc_x_get(int argc, VALUE *argv, VALUE self) { FXArc *arg1 = (FXArc *) 0 ; FXshort result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXArc, 1); result = (FXshort) ((arg1)->x); vresult = INT2NUM(result);
    return vresult; }
static VALUE _wrap_FXArc_y_set(int argc, VALUE *argv, VALUE self) { FXArc *arg1 = (FXArc *) 0 ; FXshort arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXArc, 1); arg2 = NUM2SHRT(argv[0]); if (arg1) (arg1)->y = arg2;
    return Qnil; }
static VALUE _wrap_FXArc_y_get(int argc, VALUE *argv, VALUE self) { FXArc *arg1 = (FXArc *) 0 ; FXshort result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXArc, 1); result = (FXshort) ((arg1)->y); vresult = INT2NUM(result);
    return vresult; }
static VALUE _wrap_FXArc_w_set(int argc, VALUE *argv, VALUE self) { FXArc *arg1 = (FXArc *) 0 ; FXshort arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXArc, 1); arg2 = NUM2SHRT(argv[0]); if (arg1) (arg1)->w = arg2;
    return Qnil; }
static VALUE _wrap_FXArc_w_get(int argc, VALUE *argv, VALUE self) { FXArc *arg1 = (FXArc *) 0 ; FXshort result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXArc, 1); result = (FXshort) ((arg1)->w); vresult = INT2NUM(result);
    return vresult; }
static VALUE _wrap_FXArc_h_set(int argc, VALUE *argv, VALUE self) { FXArc *arg1 = (FXArc *) 0 ; FXshort arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXArc, 1); arg2 = NUM2SHRT(argv[0]); if (arg1) (arg1)->h = arg2;
    return Qnil; }
static VALUE _wrap_FXArc_h_get(int argc, VALUE *argv, VALUE self) { FXArc *arg1 = (FXArc *) 0 ; FXshort result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXArc, 1); result = (FXshort) ((arg1)->h); vresult = INT2NUM(result);
    return vresult; }
static VALUE _wrap_FXArc_a_set(int argc, VALUE *argv, VALUE self) { FXArc *arg1 = (FXArc *) 0 ; FXshort arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXArc, 1); arg2 = NUM2SHRT(argv[0]); if (arg1) (arg1)->a = arg2;
    return Qnil; }
static VALUE _wrap_FXArc_a_get(int argc, VALUE *argv, VALUE self) { FXArc *arg1 = (FXArc *) 0 ; FXshort result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXArc, 1); result = (FXshort) ((arg1)->a); vresult = INT2NUM(result);
    return vresult; }
static VALUE _wrap_FXArc_b_set(int argc, VALUE *argv, VALUE self) { FXArc *arg1 = (FXArc *) 0 ; FXshort arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXArc, 1); arg2 = NUM2SHRT(argv[0]); if (arg1) (arg1)->b = arg2;
    return Qnil; }
static VALUE _wrap_FXArc_b_get(int argc, VALUE *argv, VALUE self) { FXArc *arg1 = (FXArc *) 0 ; FXshort result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXArc, 1); result = (FXshort) ((arg1)->b); vresult = INT2NUM(result);
    return vresult; }
static void
free_FXArc(FXArc *arg1) {
    delete arg1;
}
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE _wrap_FXDC_allocate(VALUE self) {
#else
     static VALUE _wrap_FXDC_allocate(int argc, VALUE *argv, VALUE self) {
#endif
         VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_FXDC);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
         return vresult; }
static VALUE _wrap_new_FXDC(int argc, VALUE *argv, VALUE self) { FXApp *arg1 = (FXApp *) 0 ; FXDC *result;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXApp, 1); { result = (FXDC *)new_FXDC(arg1);
        DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result); if(rb_block_given_p()){ rb_yield(self); }  }  return self; }
static VALUE _wrap_FXDC_getApp(int argc, VALUE *argv, VALUE self) { FXDC *arg1 = (FXDC *) 0 ; FXApp *result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDC, 1); result = (FXApp *)((FXDC const *)arg1)->getApp(); {
        swig_type_info *ty = SWIG_TypeDynamicCast(SWIGTYPE_p_FXApp, (void **) &result); vresult = FXRbGetRubyObj(result, ty); } 
    return vresult; }
static VALUE _wrap_FXDC_getForeground(int argc, VALUE *argv, VALUE self) { FXDC *arg1 = (FXDC *) 0 ; FXColor result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDC, 1); result = (FXColor)((FXDC const *)arg1)->getForeground();
    vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXDC_getBackground(int argc, VALUE *argv, VALUE self) { FXDC *arg1 = (FXDC *) 0 ; FXColor result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDC, 1); result = (FXColor)((FXDC const *)arg1)->getBackground();
    vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXDC_getDashPattern(int argc, VALUE *argv, VALUE self) { FXDC *arg1 = (FXDC *) 0 ; VALUE result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDC, 1); result = (VALUE)FXDC_getDashPattern((FXDC const *)arg1);
    vresult = result; return vresult; }
static VALUE _wrap_FXDC_getDashOffset(int argc, VALUE *argv, VALUE self) { FXDC *arg1 = (FXDC *) 0 ; FXuint result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDC, 1); result = (FXuint)((FXDC const *)arg1)->getDashOffset();
    vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXDC_getLineWidth(int argc, VALUE *argv, VALUE self) { FXDC *arg1 = (FXDC *) 0 ; FXuint result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDC, 1); result = (FXuint)((FXDC const *)arg1)->getLineWidth();
    vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXDC_getLineCap(int argc, VALUE *argv, VALUE self) { FXDC *arg1 = (FXDC *) 0 ; int result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDC, 1); result = (int)((FXDC const *)arg1)->getLineCap();
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXDC_getLineJoin(int argc, VALUE *argv, VALUE self) { FXDC *arg1 = (FXDC *) 0 ; int result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDC, 1); result = (int)((FXDC const *)arg1)->getLineJoin();
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXDC_getLineStyle(int argc, VALUE *argv, VALUE self) { FXDC *arg1 = (FXDC *) 0 ; int result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDC, 1); result = (int)((FXDC const *)arg1)->getLineStyle();
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXDC_getFillStyle(int argc, VALUE *argv, VALUE self) { FXDC *arg1 = (FXDC *) 0 ; int result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDC, 1); result = (int)((FXDC const *)arg1)->getFillStyle();
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXDC_getFillRule(int argc, VALUE *argv, VALUE self) { FXDC *arg1 = (FXDC *) 0 ; int result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDC, 1); result = (int)((FXDC const *)arg1)->getFillRule();
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXDC_getFunction(int argc, VALUE *argv, VALUE self) { FXDC *arg1 = (FXDC *) 0 ; int result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDC, 1); result = (int)((FXDC const *)arg1)->getFunction();
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXDC_getTile(int argc, VALUE *argv, VALUE self) { FXDC *arg1 = (FXDC *) 0 ; FXImage *result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDC, 1); result = (FXImage *)((FXDC const *)arg1)->getTile(); {
        swig_type_info *ty = SWIG_TypeDynamicCast(SWIGTYPE_p_FXImage, (void **) &result); vresult = FXRbGetRubyObj(result, ty); }
     return vresult; }
static VALUE _wrap_FXDC_getStippleBitmap(int argc, VALUE *argv, VALUE self) { FXDC *arg1 = (FXDC *) 0 ; FXBitmap *result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDC, 1); result = (FXBitmap *)((FXDC const *)arg1)->getStippleBitmap(); {
        swig_type_info *ty = SWIG_TypeDynamicCast(SWIGTYPE_p_FXBitmap, (void **) &result);
        vresult = FXRbGetRubyObj(result, ty); }  return vresult; }
static VALUE _wrap_FXDC_getStipplePattern(int argc, VALUE *argv, VALUE self) { FXDC *arg1 = (FXDC *) 0 ; int result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDC, 1); result = (int)((FXDC const *)arg1)->getStipplePattern();
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXDC_getClipRectangle(int argc, VALUE *argv, VALUE self) { FXDC *arg1 = (FXDC *) 0 ; FXRectangle *result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDC, 1); {
        FXRectangle const &_result_ref = ((FXDC const *)arg1)->getClipRectangle(); result = (FXRectangle *) &_result_ref; } 
    vresult = FXRbGetRubyObj(result, "FXRectangle *"); return vresult; }
static VALUE _wrap_FXDC_getClipX(int argc, VALUE *argv, VALUE self) { FXDC *arg1 = (FXDC *) 0 ; FXint result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDC, 1); result = (FXint)((FXDC const *)arg1)->getClipX();
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXDC_getClipY(int argc, VALUE *argv, VALUE self) { FXDC *arg1 = (FXDC *) 0 ; FXint result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDC, 1); result = (FXint)((FXDC const *)arg1)->getClipY();
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXDC_getClipWidth(int argc, VALUE *argv, VALUE self) { FXDC *arg1 = (FXDC *) 0 ; FXint result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDC, 1); result = (FXint)((FXDC const *)arg1)->getClipWidth();
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXDC_getClipHeight(int argc, VALUE *argv, VALUE self) { FXDC *arg1 = (FXDC *) 0 ; FXint result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDC, 1); result = (FXint)((FXDC const *)arg1)->getClipHeight();
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXDC_getFont(int argc, VALUE *argv, VALUE self) { FXDC *arg1 = (FXDC *) 0 ; FXFont *result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDC, 1); result = (FXFont *)((FXDC const *)arg1)->getFont(); {
        swig_type_info *ty = SWIG_TypeDynamicCast(SWIGTYPE_p_FXFont, (void **) &result); vresult = FXRbGetRubyObj(result, ty); }
     return vresult; }
static void
free_FXDC(FXDC *arg1) {
    delete arg1;
}
static VALUE _wrap_FXDC_readPixel(int argc, VALUE *argv, VALUE self) { FXDC *arg1 = (FXDC *) 0 ; FXint arg2 ; FXint arg3 ;
    FXColor result; VALUE vresult = Qnil; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc); SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDC, 1);
    arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]); result = (FXColor)FXDC_readPixel(arg1,arg2,arg3);
    vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXDC_drawPoint(int argc, VALUE *argv, VALUE self) { FXDC *arg1 = (FXDC *) 0 ; FXint arg2 ; FXint arg3 ;
    if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDC, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    FXDC_drawPoint(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXDC_drawPoints(int argc, VALUE *argv, VALUE self) { FXDC *arg1 = (FXDC *) 0 ;
    FXPoint *arg2 = (FXPoint *) 0 ; FXuint arg3 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc); SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDC, 1); {
        Check_Type(argv[0], T_ARRAY); arg2 = new FXPoint[RARRAY(argv[0])->len];
        arg3 = static_cast<FXuint>( RARRAY(argv[0])->len ); for (FXuint i = 0; i < arg3; i++) { FXPoint *pPoint;
            Data_Get_Struct(rb_ary_entry(argv[0], i), FXPoint, pPoint); arg2[i] = *pPoint; }  } 
    FXDC_drawPoints(arg1,(FXPoint const *)arg2,arg3); { delete [] arg2; }  return Qnil; }
static VALUE _wrap_FXDC_drawPointsRel(int argc, VALUE *argv, VALUE self) { FXDC *arg1 = (FXDC *) 0 ;
    FXPoint *arg2 = (FXPoint *) 0 ; FXuint arg3 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc); SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDC, 1); {
        Check_Type(argv[0], T_ARRAY); arg2 = new FXPoint[RARRAY(argv[0])->len];
        arg3 = static_cast<FXuint>( RARRAY(argv[0])->len ); for (FXuint i = 0; i < arg3; i++) { FXPoint *pPoint;
            Data_Get_Struct(rb_ary_entry(argv[0], i), FXPoint, pPoint); arg2[i] = *pPoint; }  } 
    FXDC_drawPointsRel(arg1,(FXPoint const *)arg2,arg3); { delete [] arg2; }  return Qnil; }
static VALUE _wrap_FXDC_drawLine(int argc, VALUE *argv, VALUE self) { FXDC *arg1 = (FXDC *) 0 ; FXint arg2 ; FXint arg3 ;
    FXint arg4 ; FXint arg5 ; if ((argc < 4) || (argc > 4)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDC, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    arg4 = NUM2INT(argv[2]); arg5 = NUM2INT(argv[3]); FXDC_drawLine(arg1,arg2,arg3,arg4,arg5); return Qnil; }
static VALUE _wrap_FXDC_drawLines(int argc, VALUE *argv, VALUE self) { FXDC *arg1 = (FXDC *) 0 ; FXPoint *arg2 = (FXPoint *) 0 ;
    FXuint arg3 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDC, 1); { Check_Type(argv[0], T_ARRAY);
        arg2 = new FXPoint[RARRAY(argv[0])->len]; arg3 = static_cast<FXuint>( RARRAY(argv[0])->len );
        for (FXuint i = 0; i < arg3; i++) { FXPoint *pPoint; Data_Get_Struct(rb_ary_entry(argv[0], i), FXPoint, pPoint);
            arg2[i] = *pPoint; }  }  FXDC_drawLines(arg1,(FXPoint const *)arg2,arg3); { delete [] arg2; }  return Qnil; }
static VALUE _wrap_FXDC_drawLinesRel(int argc, VALUE *argv, VALUE self) { FXDC *arg1 = (FXDC *) 0 ;
    FXPoint *arg2 = (FXPoint *) 0 ; FXuint arg3 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc); SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDC, 1); {
        Check_Type(argv[0], T_ARRAY); arg2 = new FXPoint[RARRAY(argv[0])->len];
        arg3 = static_cast<FXuint>( RARRAY(argv[0])->len ); for (FXuint i = 0; i < arg3; i++) { FXPoint *pPoint;
            Data_Get_Struct(rb_ary_entry(argv[0], i), FXPoint, pPoint); arg2[i] = *pPoint; }  } 
    FXDC_drawLinesRel(arg1,(FXPoint const *)arg2,arg3); { delete [] arg2; }  return Qnil; }
static VALUE _wrap_FXDC_drawLineSegments(int argc, VALUE *argv, VALUE self) { FXDC *arg1 = (FXDC *) 0 ;
    FXSegment *arg2 = (FXSegment *) 0 ; FXuint arg3 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc); SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDC, 1); {
        Check_Type(argv[0], T_ARRAY); arg2 = new FXSegment[RARRAY(argv[0])->len];
        arg3 = static_cast<FXuint>( RARRAY(argv[0])->len ); for (FXuint i = 0; i < arg3; i++) { FXSegment *pSeg;
            Data_Get_Struct(rb_ary_entry(argv[0], i), FXSegment, pSeg); arg2[i] = *pSeg; }  } 
    FXDC_drawLineSegments(arg1,(FXSegment const *)arg2,arg3); { delete [] arg2; }  return Qnil; }
static VALUE _wrap_FXDC_drawRectangle(int argc, VALUE *argv, VALUE self) { FXDC *arg1 = (FXDC *) 0 ; FXint arg2 ; FXint arg3 ;
    FXint arg4 ; FXint arg5 ; if ((argc < 4) || (argc > 4)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDC, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    arg4 = NUM2INT(argv[2]); arg5 = NUM2INT(argv[3]); FXDC_drawRectangle(arg1,arg2,arg3,arg4,arg5); return Qnil; }
static VALUE _wrap_FXDC_drawRectangles(int argc, VALUE *argv, VALUE self) { FXDC *arg1 = (FXDC *) 0 ;
    FXRectangle *arg2 = (FXRectangle *) 0 ; FXuint arg3 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc); SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDC, 1); {
        Check_Type(argv[0], T_ARRAY); arg2 = new FXRectangle[RARRAY(argv[0])->len];
        arg3 = static_cast<FXuint>( RARRAY(argv[0])->len ); for (FXuint i = 0; i < arg3; i++) { FXRectangle *pRect;
            Data_Get_Struct(rb_ary_entry(argv[0], i), FXRectangle, pRect); arg2[i] = *pRect; }  } 
    FXDC_drawRectangles(arg1,(FXRectangle const *)arg2,arg3); { delete [] arg2; }  return Qnil; }
static VALUE _wrap_FXDC_drawArc(int argc, VALUE *argv, VALUE self) { FXDC *arg1 = (FXDC *) 0 ; FXint arg2 ; FXint arg3 ;
    FXint arg4 ; FXint arg5 ; FXint arg6 ; FXint arg7 ; if ((argc < 6) || (argc > 6))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 6)",argc); SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDC, 1);
    arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]); arg4 = NUM2INT(argv[2]); arg5 = NUM2INT(argv[3]); arg6 = NUM2INT(argv[4]);
    arg7 = NUM2INT(argv[5]); FXDC_drawArc(arg1,arg2,arg3,arg4,arg5,arg6,arg7); return Qnil; }
static VALUE _wrap_FXDC_drawArcs(int argc, VALUE *argv, VALUE self) { FXDC *arg1 = (FXDC *) 0 ; FXArc *arg2 = (FXArc *) 0 ;
    FXuint arg3 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDC, 1); { Check_Type(argv[0], T_ARRAY);
        arg2 = new FXArc[RARRAY(argv[0])->len]; arg3 = static_cast<FXuint>( RARRAY(argv[0])->len );
        for (FXuint i = 0; i < arg3; i++) { FXArc *pArc; Data_Get_Struct(rb_ary_entry(argv[0], i), FXArc, pArc);
            arg2[i] = *pArc; }  }  FXDC_drawArcs(arg1,(FXArc const *)arg2,arg3); return Qnil; }
static VALUE _wrap_FXDC_fillRectangle(int argc, VALUE *argv, VALUE self) { FXDC *arg1 = (FXDC *) 0 ; FXint arg2 ; FXint arg3 ;
    FXint arg4 ; FXint arg5 ; if ((argc < 4) || (argc > 4)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDC, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    arg4 = NUM2INT(argv[2]); arg5 = NUM2INT(argv[3]); FXDC_fillRectangle(arg1,arg2,arg3,arg4,arg5); return Qnil; }
static VALUE _wrap_FXDC_fillRectangles(int argc, VALUE *argv, VALUE self) { FXDC *arg1 = (FXDC *) 0 ;
    FXRectangle *arg2 = (FXRectangle *) 0 ; FXuint arg3 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc); SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDC, 1); {
        Check_Type(argv[0], T_ARRAY); arg2 = new FXRectangle[RARRAY(argv[0])->len];
        arg3 = static_cast<FXuint>( RARRAY(argv[0])->len ); for (FXuint i = 0; i < arg3; i++) { FXRectangle *pRect;
            Data_Get_Struct(rb_ary_entry(argv[0], i), FXRectangle, pRect); arg2[i] = *pRect; }  } 
    FXDC_fillRectangles(arg1,(FXRectangle const *)arg2,arg3); { delete [] arg2; }  return Qnil; }
static VALUE _wrap_FXDC_fillChord(int argc, VALUE *argv, VALUE self) { FXDC *arg1 = (FXDC *) 0 ; FXint arg2 ; FXint arg3 ;
    FXint arg4 ; FXint arg5 ; FXint arg6 ; FXint arg7 ; if ((argc < 6) || (argc > 6))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 6)",argc); SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDC, 1);
    arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]); arg4 = NUM2INT(argv[2]); arg5 = NUM2INT(argv[3]); arg6 = NUM2INT(argv[4]);
    arg7 = NUM2INT(argv[5]); FXDC_fillChord(arg1,arg2,arg3,arg4,arg5,arg6,arg7); return Qnil; }
static VALUE _wrap_FXDC_fillChords(int argc, VALUE *argv, VALUE self) { FXDC *arg1 = (FXDC *) 0 ; FXArc *arg2 = (FXArc *) 0 ;
    FXuint arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDC, 1); SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXArc, 1);
    arg3 = NUM2UINT(argv[1]); FXDC_fillChords(arg1,(FXArc const *)arg2,arg3); return Qnil; }
static VALUE _wrap_FXDC_fillArc(int argc, VALUE *argv, VALUE self) { FXDC *arg1 = (FXDC *) 0 ; FXint arg2 ; FXint arg3 ;
    FXint arg4 ; FXint arg5 ; FXint arg6 ; FXint arg7 ; if ((argc < 6) || (argc > 6))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 6)",argc); SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDC, 1);
    arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]); arg4 = NUM2INT(argv[2]); arg5 = NUM2INT(argv[3]); arg6 = NUM2INT(argv[4]);
    arg7 = NUM2INT(argv[5]); FXDC_fillArc(arg1,arg2,arg3,arg4,arg5,arg6,arg7); return Qnil; }
static VALUE _wrap_FXDC_fillArcs(int argc, VALUE *argv, VALUE self) { FXDC *arg1 = (FXDC *) 0 ; FXArc *arg2 = (FXArc *) 0 ;
    FXuint arg3 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDC, 1); { Check_Type(argv[0], T_ARRAY);
        arg2 = new FXArc[RARRAY(argv[0])->len]; arg3 = static_cast<FXuint>( RARRAY(argv[0])->len );
        for (FXuint i = 0; i < arg3; i++) { FXArc *pArc; Data_Get_Struct(rb_ary_entry(argv[0], i), FXArc, pArc);
            arg2[i] = *pArc; }  }  FXDC_fillArcs(arg1,(FXArc const *)arg2,arg3); return Qnil; }
static VALUE _wrap_FXDC_fillPolygon(int argc, VALUE *argv, VALUE self) { FXDC *arg1 = (FXDC *) 0 ;
    FXPoint *arg2 = (FXPoint *) 0 ; FXuint arg3 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc); SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDC, 1); {
        Check_Type(argv[0], T_ARRAY); arg2 = new FXPoint[RARRAY(argv[0])->len];
        arg3 = static_cast<FXuint>( RARRAY(argv[0])->len ); for (FXuint i = 0; i < arg3; i++) { FXPoint *pPoint;
            Data_Get_Struct(rb_ary_entry(argv[0], i), FXPoint, pPoint); arg2[i] = *pPoint; }  } 
    FXDC_fillPolygon(arg1,(FXPoint const *)arg2,arg3); { delete [] arg2; }  return Qnil; }
static VALUE _wrap_FXDC_fillConcavePolygon(int argc, VALUE *argv, VALUE self) { FXDC *arg1 = (FXDC *) 0 ;
    FXPoint *arg2 = (FXPoint *) 0 ; FXuint arg3 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc); SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDC, 1); {
        Check_Type(argv[0], T_ARRAY); arg2 = new FXPoint[RARRAY(argv[0])->len];
        arg3 = static_cast<FXuint>( RARRAY(argv[0])->len ); for (FXuint i = 0; i < arg3; i++) { FXPoint *pPoint;
            Data_Get_Struct(rb_ary_entry(argv[0], i), FXPoint, pPoint); arg2[i] = *pPoint; }  } 
    FXDC_fillConcavePolygon(arg1,(FXPoint const *)arg2,arg3); { delete [] arg2; }  return Qnil; }
static VALUE _wrap_FXDC_fillComplexPolygon(int argc, VALUE *argv, VALUE self) { FXDC *arg1 = (FXDC *) 0 ;
    FXPoint *arg2 = (FXPoint *) 0 ; FXuint arg3 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc); SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDC, 1); {
        Check_Type(argv[0], T_ARRAY); arg2 = new FXPoint[RARRAY(argv[0])->len];
        arg3 = static_cast<FXuint>( RARRAY(argv[0])->len ); for (FXuint i = 0; i < arg3; i++) { FXPoint *pPoint;
            Data_Get_Struct(rb_ary_entry(argv[0], i), FXPoint, pPoint); arg2[i] = *pPoint; }  } 
    FXDC_fillComplexPolygon(arg1,(FXPoint const *)arg2,arg3); { delete [] arg2; }  return Qnil; }
static VALUE _wrap_FXDC_fillPolygonRel(int argc, VALUE *argv, VALUE self) { FXDC *arg1 = (FXDC *) 0 ;
    FXPoint *arg2 = (FXPoint *) 0 ; FXuint arg3 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc); SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDC, 1); {
        Check_Type(argv[0], T_ARRAY); arg2 = new FXPoint[RARRAY(argv[0])->len];
        arg3 = static_cast<FXuint>( RARRAY(argv[0])->len ); for (FXuint i = 0; i < arg3; i++) { FXPoint *pPoint;
            Data_Get_Struct(rb_ary_entry(argv[0], i), FXPoint, pPoint); arg2[i] = *pPoint; }  } 
    FXDC_fillPolygonRel(arg1,(FXPoint const *)arg2,arg3); { delete [] arg2; }  return Qnil; }
static VALUE _wrap_FXDC_fillConcavePolygonRel(int argc, VALUE *argv, VALUE self) { FXDC *arg1 = (FXDC *) 0 ;
    FXPoint *arg2 = (FXPoint *) 0 ; FXuint arg3 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc); SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDC, 1); {
        Check_Type(argv[0], T_ARRAY); arg2 = new FXPoint[RARRAY(argv[0])->len];
        arg3 = static_cast<FXuint>( RARRAY(argv[0])->len ); for (FXuint i = 0; i < arg3; i++) { FXPoint *pPoint;
            Data_Get_Struct(rb_ary_entry(argv[0], i), FXPoint, pPoint); arg2[i] = *pPoint; }  } 
    FXDC_fillConcavePolygonRel(arg1,(FXPoint const *)arg2,arg3); { delete [] arg2; }  return Qnil; }
static VALUE _wrap_FXDC_fillComplexPolygonRel(int argc, VALUE *argv, VALUE self) { FXDC *arg1 = (FXDC *) 0 ;
    FXPoint *arg2 = (FXPoint *) 0 ; FXuint arg3 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc); SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDC, 1); {
        Check_Type(argv[0], T_ARRAY); arg2 = new FXPoint[RARRAY(argv[0])->len];
        arg3 = static_cast<FXuint>( RARRAY(argv[0])->len ); for (FXuint i = 0; i < arg3; i++) { FXPoint *pPoint;
            Data_Get_Struct(rb_ary_entry(argv[0], i), FXPoint, pPoint); arg2[i] = *pPoint; }  } 
    FXDC_fillComplexPolygonRel(arg1,(FXPoint const *)arg2,arg3); { delete [] arg2; }  return Qnil; }
static VALUE _wrap_FXDC_drawHashBox(int argc, VALUE *argv, VALUE self) { FXDC *arg1 = (FXDC *) 0 ; FXint arg2 ; FXint arg3 ;
    FXint arg4 ; FXint arg5 ; FXint arg6 = (FXint) 1 ; if ((argc < 4) || (argc > 5))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc); SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDC, 1);
    arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]); arg4 = NUM2INT(argv[2]); arg5 = NUM2INT(argv[3]); if (argc > 4) {
        arg6 = NUM2INT(argv[4]); }  FXDC_drawHashBox(arg1,arg2,arg3,arg4,arg5,arg6); return Qnil; }
static VALUE _wrap_FXDC_drawFocusRectangle(int argc, VALUE *argv, VALUE self) { FXDC *arg1 = (FXDC *) 0 ; FXint arg2 ;
    FXint arg3 ; FXint arg4 ; FXint arg5 ; if ((argc < 4) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc); SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDC, 1);
    arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]); arg4 = NUM2INT(argv[2]); arg5 = NUM2INT(argv[3]);
    FXDC_drawFocusRectangle(arg1,arg2,arg3,arg4,arg5); return Qnil; }
static VALUE _wrap_FXDC_drawArea(int argc, VALUE *argv, VALUE self) { FXDC *arg1 = (FXDC *) 0 ;
    FXDrawable *arg2 = (FXDrawable *) 0 ; FXint arg3 ; FXint arg4 ; FXint arg5 ; FXint arg6 ; FXint arg7 ; FXint arg8 ;
    if ((argc < 7) || (argc > 7)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 7)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDC, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXDrawable, 1); arg3 = NUM2INT(argv[1]); arg4 = NUM2INT(argv[2]);
    arg5 = NUM2INT(argv[3]); arg6 = NUM2INT(argv[4]); arg7 = NUM2INT(argv[5]); arg8 = NUM2INT(argv[6]);
    FXDC_drawArea(arg1,(FXDrawable const *)arg2,arg3,arg4,arg5,arg6,arg7,arg8); return Qnil; }
static VALUE _wrap_FXDC_drawImage(int argc, VALUE *argv, VALUE self) { FXDC *arg1 = (FXDC *) 0 ; FXImage *arg2 = (FXImage *) 0 ;
    FXint arg3 ; FXint arg4 ; if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDC, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXImage, 1); arg3 = NUM2INT(argv[1]); arg4 = NUM2INT(argv[2]);
    FXDC_drawImage(arg1,(FXImage const *)arg2,arg3,arg4); return Qnil; }
static VALUE _wrap_FXDC_drawBitmap(int argc, VALUE *argv, VALUE self) { FXDC *arg1 = (FXDC *) 0 ;
    FXBitmap *arg2 = (FXBitmap *) 0 ; FXint arg3 ; FXint arg4 ; if ((argc < 3) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc); SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDC, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXBitmap, 1); arg3 = NUM2INT(argv[1]); arg4 = NUM2INT(argv[2]);
    FXDC_drawBitmap(arg1,(FXBitmap const *)arg2,arg3,arg4); return Qnil; }
static VALUE _wrap_FXDC_drawIcon(int argc, VALUE *argv, VALUE self) { FXDC *arg1 = (FXDC *) 0 ; FXIcon *arg2 = (FXIcon *) 0 ;
    FXint arg3 ; FXint arg4 ; if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDC, 1); SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXIcon, 1);
    arg3 = NUM2INT(argv[1]); arg4 = NUM2INT(argv[2]); FXDC_drawIcon(arg1,(FXIcon const *)arg2,arg3,arg4); return Qnil; }
static VALUE _wrap_FXDC_drawIconShaded(int argc, VALUE *argv, VALUE self) { FXDC *arg1 = (FXDC *) 0 ;
    FXIcon *arg2 = (FXIcon *) 0 ; FXint arg3 ; FXint arg4 ; if ((argc < 3) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc); SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDC, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXIcon, 1); arg3 = NUM2INT(argv[1]); arg4 = NUM2INT(argv[2]);
    FXDC_drawIconShaded(arg1,(FXIcon const *)arg2,arg3,arg4); return Qnil; }
static VALUE _wrap_FXDC_drawIconSunken(int argc, VALUE *argv, VALUE self) { FXDC *arg1 = (FXDC *) 0 ;
    FXIcon *arg2 = (FXIcon *) 0 ; FXint arg3 ; FXint arg4 ; if ((argc < 3) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc); SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDC, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXIcon, 1); arg3 = NUM2INT(argv[1]); arg4 = NUM2INT(argv[2]);
    FXDC_drawIconSunken(arg1,(FXIcon const *)arg2,arg3,arg4); return Qnil; }
static VALUE _wrap_FXDC_drawText(int argc, VALUE *argv, VALUE self) { FXDC *arg1 = (FXDC *) 0 ; FXint arg2 ; FXint arg3 ;
    FXchar *arg4 ; FXuint arg5 ; if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDC, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]); {
        Check_Type(argv[2], T_STRING); arg4 = STR2CSTR(argv[2]); arg5 = RSTRING(argv[2])->len; } 
    FXDC_drawText(arg1,arg2,arg3,(FXchar const *)arg4,arg5); return Qnil; }
static VALUE _wrap_FXDC_drawImageText(int argc, VALUE *argv, VALUE self) { FXDC *arg1 = (FXDC *) 0 ; FXint arg2 ; FXint arg3 ;
    FXchar *arg4 ; FXuint arg5 ; if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDC, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]); {
        Check_Type(argv[2], T_STRING); arg4 = STR2CSTR(argv[2]); arg5 = RSTRING(argv[2])->len; } 
    FXDC_drawImageText(arg1,arg2,arg3,(FXchar const *)arg4,arg5); return Qnil; }
static VALUE _wrap_FXDC_setForeground(int argc, VALUE *argv, VALUE self) { FXDC *arg1 = (FXDC *) 0 ; FXColor arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDC, 1); arg2 = to_FXColor(argv[0]); FXDC_setForeground(arg1,arg2);
    return Qnil; }
static VALUE _wrap_FXDC_setBackground(int argc, VALUE *argv, VALUE self) { FXDC *arg1 = (FXDC *) 0 ; FXColor arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDC, 1); arg2 = to_FXColor(argv[0]); FXDC_setBackground(arg1,arg2);
    return Qnil; }
static VALUE _wrap_FXDC_setDashes(int argc, VALUE *argv, VALUE self) { FXDC *arg1 = (FXDC *) 0 ; FXuint arg2 ; FXchar *arg3 ;
    FXuint arg4 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDC, 1); arg2 = NUM2UINT(argv[0]); { Check_Type(argv[1], T_ARRAY);
        arg3 = new FXchar[RARRAY(argv[1])->len]; arg4 = static_cast<FXuint>( RARRAY(argv[1])->len );
        for (FXuint i = 0; i < arg4; i++) { arg3[i] = NUM2INT(rb_ary_entry(argv[1], i)); }  } 
    FXDC_setDashes(arg1,arg2,(FXchar const *)arg3,arg4); { delete [] arg3; }  return Qnil; }
static VALUE _wrap_FXDC_setLineWidth(int argc, VALUE *argv, VALUE self) { FXDC *arg1 = (FXDC *) 0 ; FXuint arg2 = (FXuint) 0 ;
    if ((argc < 0) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDC, 1); if (argc > 0) { arg2 = NUM2UINT(argv[0]); } 
    FXDC_setLineWidth(arg1,arg2); return Qnil; }
static VALUE _wrap_FXDC_setLineCap(int argc, VALUE *argv, VALUE self) { FXDC *arg1 = (FXDC *) 0 ; int arg2 = (int) CAP_BUTT ;
    if ((argc < 0) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDC, 1); if (argc > 0) { arg2 = (int) NUM2INT(argv[0]); } 
    FXDC_setLineCap(arg1,(FXCapStyle )arg2); return Qnil; }
static VALUE _wrap_FXDC_setLineJoin(int argc, VALUE *argv, VALUE self) { FXDC *arg1 = (FXDC *) 0 ; int arg2 = (int) JOIN_MITER ;
    if ((argc < 0) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDC, 1); if (argc > 0) { arg2 = (int) NUM2INT(argv[0]); } 
    FXDC_setLineJoin(arg1,(FXJoinStyle )arg2); return Qnil; }
static VALUE _wrap_FXDC_setLineStyle(int argc, VALUE *argv, VALUE self) { FXDC *arg1 = (FXDC *) 0 ;
    int arg2 = (int) LINE_SOLID ; if ((argc < 0) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDC, 1); if (argc > 0) { arg2 = (int) NUM2INT(argv[0]); } 
    FXDC_setLineStyle(arg1,(FXLineStyle )arg2); return Qnil; }
static VALUE _wrap_FXDC_setFillStyle(int argc, VALUE *argv, VALUE self) { FXDC *arg1 = (FXDC *) 0 ;
    int arg2 = (int) FILL_SOLID ; if ((argc < 0) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDC, 1); if (argc > 0) { arg2 = (int) NUM2INT(argv[0]); } 
    FXDC_setFillStyle(arg1,(FXFillStyle )arg2); return Qnil; }
static VALUE _wrap_FXDC_setFillRule(int argc, VALUE *argv, VALUE self) { FXDC *arg1 = (FXDC *) 0 ;
    int arg2 = (int) RULE_EVEN_ODD ; if ((argc < 0) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc); SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDC, 1);
    if (argc > 0) { arg2 = (int) NUM2INT(argv[0]); }  FXDC_setFillRule(arg1,(FXFillRule )arg2); return Qnil; }
static VALUE _wrap_FXDC_setFunction(int argc, VALUE *argv, VALUE self) { FXDC *arg1 = (FXDC *) 0 ; int arg2 = (int) BLT_SRC ;
    if ((argc < 0) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDC, 1); if (argc > 0) { arg2 = (int) NUM2INT(argv[0]); } 
    FXDC_setFunction(arg1,(FXFunction )arg2); return Qnil; }
static VALUE _wrap_FXDC_setTile(int argc, VALUE *argv, VALUE self) { FXDC *arg1 = (FXDC *) 0 ; FXImage *arg2 = (FXImage *) 0 ;
    FXint arg3 = (FXint) 0 ; FXint arg4 = (FXint) 0 ; if ((argc < 1) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc); SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDC, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXImage, 1); if (argc > 1) { arg3 = NUM2INT(argv[1]); } 
    if (argc > 2) { arg4 = NUM2INT(argv[2]); }  FXDC_setTile(arg1,arg2,arg3,arg4); return Qnil; }
static VALUE _wrap_FXDC_setStipple__SWIG_0(int argc, VALUE *argv, VALUE self) { FXDC *arg1 = (FXDC *) 0 ;
    FXBitmap *arg2 = (FXBitmap *) 0 ; FXint arg3 = (FXint) 0 ; FXint arg4 = (FXint) 0 ; if ((argc < 1) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc); SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDC, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXBitmap, 1); if (argc > 1) { arg3 = NUM2INT(argv[1]); } 
    if (argc > 2) { arg4 = NUM2INT(argv[2]); }  FXDC_setStipple(arg1,arg2,arg3,arg4); return Qnil; }
static VALUE _wrap_FXDC_setStipple__SWIG_1(int argc, VALUE *argv, VALUE self) { FXDC *arg1 = (FXDC *) 0 ; int arg2 ;
    FXint arg3 = (FXint) 0 ; FXint arg4 = (FXint) 0 ; if ((argc < 1) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc); SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDC, 1);
    arg2 = (int) NUM2INT(argv[0]); if (argc > 1) { arg3 = NUM2INT(argv[1]); }  if (argc > 2) { arg4 = NUM2INT(argv[2]); } 
    FXDC_setStipple(arg1,(FXStipplePattern )arg2,arg3,arg4); return Qnil; }
static VALUE _wrap_FXDC_setStipple(int nargs, VALUE *args, VALUE self) { int argc; VALUE argv[5]; int ii; argc = nargs + 1;
    argv[0] = self; for (ii = 1; (ii < argc) && (ii < 4); ii++) { argv[ii] = args[ii-1]; }  if ((argc >= 2) && (argc <= 4)) {
        int _v; { void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXDC, 0) != -1)) ? 1 : 0; }
         if (_v) { { void *ptr;
                _v = (NIL_P(argv[1]) || (TYPE(argv[1]) == T_DATA && SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_FXBitmap, 0) != -1)) ? 1 : 0; }
             if (_v) { if (argc <= 2) { return _wrap_FXDC_setStipple__SWIG_0(nargs, args, self);}  {
                    _v = ((TYPE(argv[2]) == T_FIXNUM) || (TYPE(argv[2]) == T_BIGNUM)) ? 1 : 0; }  if (_v) { if (argc <= 3) {
                        return _wrap_FXDC_setStipple__SWIG_0(nargs, args, self);}  {
                        _v = ((TYPE(argv[3]) == T_FIXNUM) || (TYPE(argv[3]) == T_BIGNUM)) ? 1 : 0; }  if (_v) {
                        return _wrap_FXDC_setStipple__SWIG_0(nargs, args, self);}  }  }  }  }  if ((argc >= 2) && (argc <= 4)) {
        int _v; { void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXDC, 0) != -1)) ? 1 : 0; }
         if (_v) { { _v = ((TYPE(argv[1]) == T_FIXNUM) || (TYPE(argv[1]) == T_BIGNUM)) ? 1 : 0; }  if (_v) { if (argc <= 2) {
                    return _wrap_FXDC_setStipple__SWIG_1(nargs, args, self);}  {
                    _v = ((TYPE(argv[2]) == T_FIXNUM) || (TYPE(argv[2]) == T_BIGNUM)) ? 1 : 0; }  if (_v) { if (argc <= 3) {
                        return _wrap_FXDC_setStipple__SWIG_1(nargs, args, self);}  {
                        _v = ((TYPE(argv[3]) == T_FIXNUM) || (TYPE(argv[3]) == T_BIGNUM)) ? 1 : 0; }  if (_v) {
                        return _wrap_FXDC_setStipple__SWIG_1(nargs, args, self);}  }  }  }  } 
    rb_raise(rb_eArgError, "No matching function for overloaded 'FXDC_setStipple'"); return Qnil; }
static VALUE _wrap_FXDC_setClipRegion(int argc, VALUE *argv, VALUE self) { FXDC *arg1 = (FXDC *) 0 ; FXRegion *arg2 = 0 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDC, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXRegion, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXDC_setClipRegion(arg1,(FXRegion const &)*arg2); return Qnil; }
static VALUE _wrap_FXDC_setClipRectangle__SWIG_0(int argc, VALUE *argv, VALUE self) { FXDC *arg1 = (FXDC *) 0 ; FXint arg2 ;
    FXint arg3 ; FXint arg4 ; FXint arg5 ; if ((argc < 4) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc); SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDC, 1);
    arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]); arg4 = NUM2INT(argv[2]); arg5 = NUM2INT(argv[3]);
    FXDC_setClipRectangle(arg1,arg2,arg3,arg4,arg5); return Qnil; }
static VALUE _wrap_FXDC_setClipRectangle__SWIG_1(int argc, VALUE *argv, VALUE self) { FXDC *arg1 = (FXDC *) 0 ;
    FXRectangle *arg2 = 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDC, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXRectangle, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXDC_setClipRectangle(arg1,(FXRectangle const &)*arg2); return Qnil; }
static VALUE _wrap_FXDC_setClipRectangle(int nargs, VALUE *args, VALUE self) { int argc; VALUE argv[6]; int ii;
    argc = nargs + 1; argv[0] = self; for (ii = 1; (ii < argc) && (ii < 5); ii++) { argv[ii] = args[ii-1]; }  if (argc == 2) {
        int _v; { void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXDC, 0) != -1)) ? 1 : 0; }
         if (_v) { { void *ptr;
                _v = (NIL_P(argv[1]) || (TYPE(argv[1]) == T_DATA && SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_FXRectangle, 0) != -1)) ? 1 : 0; }
             if (_v) { return _wrap_FXDC_setClipRectangle__SWIG_1(nargs, args, self);}  }  }  if (argc == 5) { int _v; {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXDC, 0) != -1)) ? 1 : 0; }
         if (_v) { { _v = ((TYPE(argv[1]) == T_FIXNUM) || (TYPE(argv[1]) == T_BIGNUM)) ? 1 : 0; }  if (_v) { {
                    _v = ((TYPE(argv[2]) == T_FIXNUM) || (TYPE(argv[2]) == T_BIGNUM)) ? 1 : 0; }  if (_v) { {
                        _v = ((TYPE(argv[3]) == T_FIXNUM) || (TYPE(argv[3]) == T_BIGNUM)) ? 1 : 0; }  if (_v) { {
                            _v = ((TYPE(argv[4]) == T_FIXNUM) || (TYPE(argv[4]) == T_BIGNUM)) ? 1 : 0; }  if (_v) {
                            return _wrap_FXDC_setClipRectangle__SWIG_0(nargs, args, self);}  }  }  }  }  } 
    rb_raise(rb_eArgError, "No matching function for overloaded 'FXDC_setClipRectangle'"); return Qnil; }
static VALUE _wrap_FXDC_clearClipRectangle(int argc, VALUE *argv, VALUE self) { FXDC *arg1 = (FXDC *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDC, 1); FXDC_clearClipRectangle(arg1); return Qnil; }
static VALUE _wrap_FXDC_setClipMask(int argc, VALUE *argv, VALUE self) { FXDC *arg1 = (FXDC *) 0 ;
    FXBitmap *arg2 = (FXBitmap *) 0 ; FXint arg3 = (FXint) 0 ; FXint arg4 = (FXint) 0 ; if ((argc < 1) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc); SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDC, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXBitmap, 1); if (argc > 1) { arg3 = NUM2INT(argv[1]); } 
    if (argc > 2) { arg4 = NUM2INT(argv[2]); }  FXDC_setClipMask(arg1,arg2,arg3,arg4); return Qnil; }
static VALUE _wrap_FXDC_clearClipMask(int argc, VALUE *argv, VALUE self) { FXDC *arg1 = (FXDC *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDC, 1); FXDC_clearClipMask(arg1); return Qnil; }
static VALUE _wrap_FXDC_setFont(int argc, VALUE *argv, VALUE self) { FXDC *arg1 = (FXDC *) 0 ; FXFont *arg2 = (FXFont *) 0 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDC, 1); SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXFont, 1);
    FXDC_setFont(arg1,arg2); return Qnil; }
static VALUE _wrap_FXDC_clipChildren(int argc, VALUE *argv, VALUE self) { FXDC *arg1 = (FXDC *) 0 ; FXbool arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDC, 1); arg2 = to_FXbool(argv[0]); FXDC_clipChildren(arg1,arg2);
    return Qnil; }
static VALUE _wrap_new_FXDCWindow__SWIG_0(int argc, VALUE *argv, VALUE self) { FXDrawable *arg1 = (FXDrawable *) 0 ;
    FXEvent *arg2 = (FXEvent *) 0 ; FXDCWindow *result; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXDrawable, 1);
    SWIG_ConvertPtr(argv[1], (void **) &arg2, SWIGTYPE_p_FXEvent, 1); {
        result = (FXDCWindow *)new_FXDCWindow__SWIG_0(arg1,arg2); DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result);
        if(rb_block_given_p()){ rb_ensure(VALUEFUNC(rb_yield), self, VALUEFUNC(FXRbDCWindow::endit), self); }  }  return self; }
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE _wrap_FXDCWindow_allocate(VALUE self) {
#else
     static VALUE _wrap_FXDCWindow_allocate(int argc, VALUE *argv, VALUE self) {
#endif
         VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_FXDCWindow);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
         return vresult; }
static VALUE _wrap_new_FXDCWindow__SWIG_1(int argc, VALUE *argv, VALUE self) { FXDrawable *arg1 = (FXDrawable *) 0 ;
    FXDCWindow *result; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXDrawable, 1); { result = (FXDCWindow *)new_FXDCWindow__SWIG_1(arg1);
        DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result); if(rb_block_given_p()){
            rb_ensure(VALUEFUNC(rb_yield), self, VALUEFUNC(FXRbDCWindow::endit), self); }  }  return self; }
static VALUE _wrap_new_FXDCWindow(int nargs, VALUE *args, VALUE self) { int argc; VALUE argv[2]; int ii; argc = nargs;
    for (ii = 0; (ii < argc) && (ii < 2); ii++) { argv[ii] = args[ii]; }  if (argc == 1) { int _v; { void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXDrawable, 0) != -1)) ? 1 : 0; }
         if (_v) { return _wrap_new_FXDCWindow__SWIG_1(nargs, args, self);}  }  if (argc == 2) { int _v; { void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXDrawable, 0) != -1)) ? 1 : 0; }
         if (_v) { { void *ptr;
                _v = (NIL_P(argv[1]) || (TYPE(argv[1]) == T_DATA && SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_FXEvent, 0) != -1)) ? 1 : 0; }
             if (_v) { return _wrap_new_FXDCWindow__SWIG_0(nargs, args, self);}  }  } 
    rb_raise(rb_eArgError, "No matching function for overloaded 'new_FXDCWindow'"); return Qnil; }
static VALUE _wrap_FXDCWindow_begin(int argc, VALUE *argv, VALUE self) { FXDCWindow *arg1 = (FXDCWindow *) 0 ;
    FXDrawable *arg2 = (FXDrawable *) 0 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDCWindow, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXDrawable, 1); (arg1)->begin(arg2); return Qnil; }
static VALUE _wrap_FXDCWindow_end(int argc, VALUE *argv, VALUE self) { FXDCWindow *arg1 = (FXDCWindow *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDCWindow, 1); (arg1)->end(); return Qnil; }
static void
free_FXDCWindow(FXDCWindow *arg1) {
    delete arg1;
}
static VALUE _wrap_FXDCWindow_readPixel(int argc, VALUE *argv, VALUE self) { FXDCWindow *arg1 = (FXDCWindow *) 0 ; FXint arg2 ;
    FXint arg3 ; FXColor result; VALUE vresult = Qnil; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDCWindow, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    result = (FXColor)FXDCWindow_readPixel(arg1,arg2,arg3); vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXDCWindow_drawPoint(int argc, VALUE *argv, VALUE self) { FXDCWindow *arg1 = (FXDCWindow *) 0 ; FXint arg2 ;
    FXint arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDCWindow, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    FXDCWindow_drawPoint(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXDCWindow_drawPoints(int argc, VALUE *argv, VALUE self) { FXDCWindow *arg1 = (FXDCWindow *) 0 ;
    FXPoint *arg2 = (FXPoint *) 0 ; FXuint arg3 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDCWindow, 1); { Check_Type(argv[0], T_ARRAY);
        arg2 = new FXPoint[RARRAY(argv[0])->len]; arg3 = static_cast<FXuint>( RARRAY(argv[0])->len );
        for (FXuint i = 0; i < arg3; i++) { FXPoint *pPoint; Data_Get_Struct(rb_ary_entry(argv[0], i), FXPoint, pPoint);
            arg2[i] = *pPoint; }  }  FXDCWindow_drawPoints(arg1,(FXPoint const *)arg2,arg3); { delete [] arg2; }  return Qnil; }
static VALUE _wrap_FXDCWindow_drawPointsRel(int argc, VALUE *argv, VALUE self) { FXDCWindow *arg1 = (FXDCWindow *) 0 ;
    FXPoint *arg2 = (FXPoint *) 0 ; FXuint arg3 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDCWindow, 1); { Check_Type(argv[0], T_ARRAY);
        arg2 = new FXPoint[RARRAY(argv[0])->len]; arg3 = static_cast<FXuint>( RARRAY(argv[0])->len );
        for (FXuint i = 0; i < arg3; i++) { FXPoint *pPoint; Data_Get_Struct(rb_ary_entry(argv[0], i), FXPoint, pPoint);
            arg2[i] = *pPoint; }  }  FXDCWindow_drawPointsRel(arg1,(FXPoint const *)arg2,arg3); { delete [] arg2; } 
    return Qnil; }
static VALUE _wrap_FXDCWindow_drawLine(int argc, VALUE *argv, VALUE self) { FXDCWindow *arg1 = (FXDCWindow *) 0 ; FXint arg2 ;
    FXint arg3 ; FXint arg4 ; FXint arg5 ; if ((argc < 4) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDCWindow, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    arg4 = NUM2INT(argv[2]); arg5 = NUM2INT(argv[3]); FXDCWindow_drawLine(arg1,arg2,arg3,arg4,arg5); return Qnil; }
static VALUE _wrap_FXDCWindow_drawLines(int argc, VALUE *argv, VALUE self) { FXDCWindow *arg1 = (FXDCWindow *) 0 ;
    FXPoint *arg2 = (FXPoint *) 0 ; FXuint arg3 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDCWindow, 1); { Check_Type(argv[0], T_ARRAY);
        arg2 = new FXPoint[RARRAY(argv[0])->len]; arg3 = static_cast<FXuint>( RARRAY(argv[0])->len );
        for (FXuint i = 0; i < arg3; i++) { FXPoint *pPoint; Data_Get_Struct(rb_ary_entry(argv[0], i), FXPoint, pPoint);
            arg2[i] = *pPoint; }  }  FXDCWindow_drawLines(arg1,(FXPoint const *)arg2,arg3); { delete [] arg2; }  return Qnil; }
static VALUE _wrap_FXDCWindow_drawLinesRel(int argc, VALUE *argv, VALUE self) { FXDCWindow *arg1 = (FXDCWindow *) 0 ;
    FXPoint *arg2 = (FXPoint *) 0 ; FXuint arg3 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDCWindow, 1); { Check_Type(argv[0], T_ARRAY);
        arg2 = new FXPoint[RARRAY(argv[0])->len]; arg3 = static_cast<FXuint>( RARRAY(argv[0])->len );
        for (FXuint i = 0; i < arg3; i++) { FXPoint *pPoint; Data_Get_Struct(rb_ary_entry(argv[0], i), FXPoint, pPoint);
            arg2[i] = *pPoint; }  }  FXDCWindow_drawLinesRel(arg1,(FXPoint const *)arg2,arg3); { delete [] arg2; } 
    return Qnil; }
static VALUE _wrap_FXDCWindow_drawLineSegments(int argc, VALUE *argv, VALUE self) { FXDCWindow *arg1 = (FXDCWindow *) 0 ;
    FXSegment *arg2 = (FXSegment *) 0 ; FXuint arg3 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDCWindow, 1); { Check_Type(argv[0], T_ARRAY);
        arg2 = new FXSegment[RARRAY(argv[0])->len]; arg3 = static_cast<FXuint>( RARRAY(argv[0])->len );
        for (FXuint i = 0; i < arg3; i++) { FXSegment *pSeg; Data_Get_Struct(rb_ary_entry(argv[0], i), FXSegment, pSeg);
            arg2[i] = *pSeg; }  }  FXDCWindow_drawLineSegments(arg1,(FXSegment const *)arg2,arg3); { delete [] arg2; } 
    return Qnil; }
static VALUE _wrap_FXDCWindow_drawRectangle(int argc, VALUE *argv, VALUE self) { FXDCWindow *arg1 = (FXDCWindow *) 0 ;
    FXint arg2 ; FXint arg3 ; FXint arg4 ; FXint arg5 ; if ((argc < 4) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDCWindow, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    arg4 = NUM2INT(argv[2]); arg5 = NUM2INT(argv[3]); FXDCWindow_drawRectangle(arg1,arg2,arg3,arg4,arg5); return Qnil; }
static VALUE _wrap_FXDCWindow_drawRectangles(int argc, VALUE *argv, VALUE self) { FXDCWindow *arg1 = (FXDCWindow *) 0 ;
    FXRectangle *arg2 = (FXRectangle *) 0 ; FXuint arg3 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDCWindow, 1); { Check_Type(argv[0], T_ARRAY);
        arg2 = new FXRectangle[RARRAY(argv[0])->len]; arg3 = static_cast<FXuint>( RARRAY(argv[0])->len );
        for (FXuint i = 0; i < arg3; i++) { FXRectangle *pRect; Data_Get_Struct(rb_ary_entry(argv[0], i), FXRectangle, pRect);
            arg2[i] = *pRect; }  }  FXDCWindow_drawRectangles(arg1,(FXRectangle const *)arg2,arg3); { delete [] arg2; } 
    return Qnil; }
static VALUE _wrap_FXDCWindow_drawArc(int argc, VALUE *argv, VALUE self) { FXDCWindow *arg1 = (FXDCWindow *) 0 ; FXint arg2 ;
    FXint arg3 ; FXint arg4 ; FXint arg5 ; FXint arg6 ; FXint arg7 ; if ((argc < 6) || (argc > 6))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 6)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDCWindow, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    arg4 = NUM2INT(argv[2]); arg5 = NUM2INT(argv[3]); arg6 = NUM2INT(argv[4]); arg7 = NUM2INT(argv[5]);
    FXDCWindow_drawArc(arg1,arg2,arg3,arg4,arg5,arg6,arg7); return Qnil; }
static VALUE _wrap_FXDCWindow_drawArcs(int argc, VALUE *argv, VALUE self) { FXDCWindow *arg1 = (FXDCWindow *) 0 ;
    FXArc *arg2 = (FXArc *) 0 ; FXuint arg3 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDCWindow, 1); { Check_Type(argv[0], T_ARRAY);
        arg2 = new FXArc[RARRAY(argv[0])->len]; arg3 = static_cast<FXuint>( RARRAY(argv[0])->len );
        for (FXuint i = 0; i < arg3; i++) { FXArc *pArc; Data_Get_Struct(rb_ary_entry(argv[0], i), FXArc, pArc);
            arg2[i] = *pArc; }  }  FXDCWindow_drawArcs(arg1,(FXArc const *)arg2,arg3); return Qnil; }
static VALUE _wrap_FXDCWindow_fillRectangle(int argc, VALUE *argv, VALUE self) { FXDCWindow *arg1 = (FXDCWindow *) 0 ;
    FXint arg2 ; FXint arg3 ; FXint arg4 ; FXint arg5 ; if ((argc < 4) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDCWindow, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    arg4 = NUM2INT(argv[2]); arg5 = NUM2INT(argv[3]); FXDCWindow_fillRectangle(arg1,arg2,arg3,arg4,arg5); return Qnil; }
static VALUE _wrap_FXDCWindow_fillRectangles(int argc, VALUE *argv, VALUE self) { FXDCWindow *arg1 = (FXDCWindow *) 0 ;
    FXRectangle *arg2 = (FXRectangle *) 0 ; FXuint arg3 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDCWindow, 1); { Check_Type(argv[0], T_ARRAY);
        arg2 = new FXRectangle[RARRAY(argv[0])->len]; arg3 = static_cast<FXuint>( RARRAY(argv[0])->len );
        for (FXuint i = 0; i < arg3; i++) { FXRectangle *pRect; Data_Get_Struct(rb_ary_entry(argv[0], i), FXRectangle, pRect);
            arg2[i] = *pRect; }  }  FXDCWindow_fillRectangles(arg1,(FXRectangle const *)arg2,arg3); { delete [] arg2; } 
    return Qnil; }
static VALUE _wrap_FXDCWindow_fillChord(int argc, VALUE *argv, VALUE self) { FXDCWindow *arg1 = (FXDCWindow *) 0 ; FXint arg2 ;
    FXint arg3 ; FXint arg4 ; FXint arg5 ; FXint arg6 ; FXint arg7 ; if ((argc < 6) || (argc > 6))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 6)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDCWindow, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    arg4 = NUM2INT(argv[2]); arg5 = NUM2INT(argv[3]); arg6 = NUM2INT(argv[4]); arg7 = NUM2INT(argv[5]);
    FXDCWindow_fillChord(arg1,arg2,arg3,arg4,arg5,arg6,arg7); return Qnil; }
static VALUE _wrap_FXDCWindow_fillChords(int argc, VALUE *argv, VALUE self) { FXDCWindow *arg1 = (FXDCWindow *) 0 ;
    FXArc *arg2 = (FXArc *) 0 ; FXuint arg3 ; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDCWindow, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXArc, 1); arg3 = NUM2UINT(argv[1]);
    FXDCWindow_fillChords(arg1,(FXArc const *)arg2,arg3); return Qnil; }
static VALUE _wrap_FXDCWindow_fillArc(int argc, VALUE *argv, VALUE self) { FXDCWindow *arg1 = (FXDCWindow *) 0 ; FXint arg2 ;
    FXint arg3 ; FXint arg4 ; FXint arg5 ; FXint arg6 ; FXint arg7 ; if ((argc < 6) || (argc > 6))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 6)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDCWindow, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    arg4 = NUM2INT(argv[2]); arg5 = NUM2INT(argv[3]); arg6 = NUM2INT(argv[4]); arg7 = NUM2INT(argv[5]);
    FXDCWindow_fillArc(arg1,arg2,arg3,arg4,arg5,arg6,arg7); return Qnil; }
static VALUE _wrap_FXDCWindow_fillArcs(int argc, VALUE *argv, VALUE self) { FXDCWindow *arg1 = (FXDCWindow *) 0 ;
    FXArc *arg2 = (FXArc *) 0 ; FXuint arg3 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDCWindow, 1); { Check_Type(argv[0], T_ARRAY);
        arg2 = new FXArc[RARRAY(argv[0])->len]; arg3 = static_cast<FXuint>( RARRAY(argv[0])->len );
        for (FXuint i = 0; i < arg3; i++) { FXArc *pArc; Data_Get_Struct(rb_ary_entry(argv[0], i), FXArc, pArc);
            arg2[i] = *pArc; }  }  FXDCWindow_fillArcs(arg1,(FXArc const *)arg2,arg3); return Qnil; }
static VALUE _wrap_FXDCWindow_fillPolygon(int argc, VALUE *argv, VALUE self) { FXDCWindow *arg1 = (FXDCWindow *) 0 ;
    FXPoint *arg2 = (FXPoint *) 0 ; FXuint arg3 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDCWindow, 1); { Check_Type(argv[0], T_ARRAY);
        arg2 = new FXPoint[RARRAY(argv[0])->len]; arg3 = static_cast<FXuint>( RARRAY(argv[0])->len );
        for (FXuint i = 0; i < arg3; i++) { FXPoint *pPoint; Data_Get_Struct(rb_ary_entry(argv[0], i), FXPoint, pPoint);
            arg2[i] = *pPoint; }  }  FXDCWindow_fillPolygon(arg1,(FXPoint const *)arg2,arg3); { delete [] arg2; }  return Qnil; }
static VALUE _wrap_FXDCWindow_fillConcavePolygon(int argc, VALUE *argv, VALUE self) { FXDCWindow *arg1 = (FXDCWindow *) 0 ;
    FXPoint *arg2 = (FXPoint *) 0 ; FXuint arg3 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDCWindow, 1); { Check_Type(argv[0], T_ARRAY);
        arg2 = new FXPoint[RARRAY(argv[0])->len]; arg3 = static_cast<FXuint>( RARRAY(argv[0])->len );
        for (FXuint i = 0; i < arg3; i++) { FXPoint *pPoint; Data_Get_Struct(rb_ary_entry(argv[0], i), FXPoint, pPoint);
            arg2[i] = *pPoint; }  }  FXDCWindow_fillConcavePolygon(arg1,(FXPoint const *)arg2,arg3); { delete [] arg2; } 
    return Qnil; }
static VALUE _wrap_FXDCWindow_fillComplexPolygon(int argc, VALUE *argv, VALUE self) { FXDCWindow *arg1 = (FXDCWindow *) 0 ;
    FXPoint *arg2 = (FXPoint *) 0 ; FXuint arg3 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDCWindow, 1); { Check_Type(argv[0], T_ARRAY);
        arg2 = new FXPoint[RARRAY(argv[0])->len]; arg3 = static_cast<FXuint>( RARRAY(argv[0])->len );
        for (FXuint i = 0; i < arg3; i++) { FXPoint *pPoint; Data_Get_Struct(rb_ary_entry(argv[0], i), FXPoint, pPoint);
            arg2[i] = *pPoint; }  }  FXDCWindow_fillComplexPolygon(arg1,(FXPoint const *)arg2,arg3); { delete [] arg2; } 
    return Qnil; }
static VALUE _wrap_FXDCWindow_fillPolygonRel(int argc, VALUE *argv, VALUE self) { FXDCWindow *arg1 = (FXDCWindow *) 0 ;
    FXPoint *arg2 = (FXPoint *) 0 ; FXuint arg3 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDCWindow, 1); { Check_Type(argv[0], T_ARRAY);
        arg2 = new FXPoint[RARRAY(argv[0])->len]; arg3 = static_cast<FXuint>( RARRAY(argv[0])->len );
        for (FXuint i = 0; i < arg3; i++) { FXPoint *pPoint; Data_Get_Struct(rb_ary_entry(argv[0], i), FXPoint, pPoint);
            arg2[i] = *pPoint; }  }  FXDCWindow_fillPolygonRel(arg1,(FXPoint const *)arg2,arg3); { delete [] arg2; } 
    return Qnil; }
static VALUE _wrap_FXDCWindow_fillConcavePolygonRel(int argc, VALUE *argv, VALUE self) { FXDCWindow *arg1 = (FXDCWindow *) 0 ;
    FXPoint *arg2 = (FXPoint *) 0 ; FXuint arg3 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDCWindow, 1); { Check_Type(argv[0], T_ARRAY);
        arg2 = new FXPoint[RARRAY(argv[0])->len]; arg3 = static_cast<FXuint>( RARRAY(argv[0])->len );
        for (FXuint i = 0; i < arg3; i++) { FXPoint *pPoint; Data_Get_Struct(rb_ary_entry(argv[0], i), FXPoint, pPoint);
            arg2[i] = *pPoint; }  }  FXDCWindow_fillConcavePolygonRel(arg1,(FXPoint const *)arg2,arg3); { delete [] arg2; } 
    return Qnil; }
static VALUE _wrap_FXDCWindow_fillComplexPolygonRel(int argc, VALUE *argv, VALUE self) { FXDCWindow *arg1 = (FXDCWindow *) 0 ;
    FXPoint *arg2 = (FXPoint *) 0 ; FXuint arg3 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDCWindow, 1); { Check_Type(argv[0], T_ARRAY);
        arg2 = new FXPoint[RARRAY(argv[0])->len]; arg3 = static_cast<FXuint>( RARRAY(argv[0])->len );
        for (FXuint i = 0; i < arg3; i++) { FXPoint *pPoint; Data_Get_Struct(rb_ary_entry(argv[0], i), FXPoint, pPoint);
            arg2[i] = *pPoint; }  }  FXDCWindow_fillComplexPolygonRel(arg1,(FXPoint const *)arg2,arg3); { delete [] arg2; } 
    return Qnil; }
static VALUE _wrap_FXDCWindow_drawHashBox(int argc, VALUE *argv, VALUE self) { FXDCWindow *arg1 = (FXDCWindow *) 0 ;
    FXint arg2 ; FXint arg3 ; FXint arg4 ; FXint arg5 ; FXint arg6 = (FXint) 1 ; if ((argc < 4) || (argc > 5))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDCWindow, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    arg4 = NUM2INT(argv[2]); arg5 = NUM2INT(argv[3]); if (argc > 4) { arg6 = NUM2INT(argv[4]); } 
    FXDCWindow_drawHashBox(arg1,arg2,arg3,arg4,arg5,arg6); return Qnil; }
static VALUE _wrap_FXDCWindow_drawFocusRectangle(int argc, VALUE *argv, VALUE self) { FXDCWindow *arg1 = (FXDCWindow *) 0 ;
    FXint arg2 ; FXint arg3 ; FXint arg4 ; FXint arg5 ; if ((argc < 4) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDCWindow, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    arg4 = NUM2INT(argv[2]); arg5 = NUM2INT(argv[3]); FXDCWindow_drawFocusRectangle(arg1,arg2,arg3,arg4,arg5); return Qnil; }
static VALUE _wrap_FXDCWindow_drawArea(int argc, VALUE *argv, VALUE self) { FXDCWindow *arg1 = (FXDCWindow *) 0 ;
    FXDrawable *arg2 = (FXDrawable *) 0 ; FXint arg3 ; FXint arg4 ; FXint arg5 ; FXint arg6 ; FXint arg7 ; FXint arg8 ;
    if ((argc < 7) || (argc > 7)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 7)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDCWindow, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXDrawable, 1); arg3 = NUM2INT(argv[1]); arg4 = NUM2INT(argv[2]);
    arg5 = NUM2INT(argv[3]); arg6 = NUM2INT(argv[4]); arg7 = NUM2INT(argv[5]); arg8 = NUM2INT(argv[6]);
    FXDCWindow_drawArea(arg1,(FXDrawable const *)arg2,arg3,arg4,arg5,arg6,arg7,arg8); return Qnil; }
static VALUE _wrap_FXDCWindow_drawImage(int argc, VALUE *argv, VALUE self) { FXDCWindow *arg1 = (FXDCWindow *) 0 ;
    FXImage *arg2 = (FXImage *) 0 ; FXint arg3 ; FXint arg4 ; if ((argc < 3) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDCWindow, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXImage, 1); arg3 = NUM2INT(argv[1]); arg4 = NUM2INT(argv[2]);
    FXDCWindow_drawImage(arg1,(FXImage const *)arg2,arg3,arg4); return Qnil; }
static VALUE _wrap_FXDCWindow_drawBitmap(int argc, VALUE *argv, VALUE self) { FXDCWindow *arg1 = (FXDCWindow *) 0 ;
    FXBitmap *arg2 = (FXBitmap *) 0 ; FXint arg3 ; FXint arg4 ; if ((argc < 3) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDCWindow, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXBitmap, 1); arg3 = NUM2INT(argv[1]); arg4 = NUM2INT(argv[2]);
    FXDCWindow_drawBitmap(arg1,(FXBitmap const *)arg2,arg3,arg4); return Qnil; }
static VALUE _wrap_FXDCWindow_drawIcon(int argc, VALUE *argv, VALUE self) { FXDCWindow *arg1 = (FXDCWindow *) 0 ;
    FXIcon *arg2 = (FXIcon *) 0 ; FXint arg3 ; FXint arg4 ; if ((argc < 3) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDCWindow, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXIcon, 1); arg3 = NUM2INT(argv[1]); arg4 = NUM2INT(argv[2]);
    FXDCWindow_drawIcon(arg1,(FXIcon const *)arg2,arg3,arg4); return Qnil; }
static VALUE _wrap_FXDCWindow_drawIconShaded(int argc, VALUE *argv, VALUE self) { FXDCWindow *arg1 = (FXDCWindow *) 0 ;
    FXIcon *arg2 = (FXIcon *) 0 ; FXint arg3 ; FXint arg4 ; if ((argc < 3) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDCWindow, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXIcon, 1); arg3 = NUM2INT(argv[1]); arg4 = NUM2INT(argv[2]);
    FXDCWindow_drawIconShaded(arg1,(FXIcon const *)arg2,arg3,arg4); return Qnil; }
static VALUE _wrap_FXDCWindow_drawIconSunken(int argc, VALUE *argv, VALUE self) { FXDCWindow *arg1 = (FXDCWindow *) 0 ;
    FXIcon *arg2 = (FXIcon *) 0 ; FXint arg3 ; FXint arg4 ; if ((argc < 3) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDCWindow, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXIcon, 1); arg3 = NUM2INT(argv[1]); arg4 = NUM2INT(argv[2]);
    FXDCWindow_drawIconSunken(arg1,(FXIcon const *)arg2,arg3,arg4); return Qnil; }
static VALUE _wrap_FXDCWindow_drawText(int argc, VALUE *argv, VALUE self) { FXDCWindow *arg1 = (FXDCWindow *) 0 ; FXint arg2 ;
    FXint arg3 ; FXchar *arg4 ; FXuint arg5 ; if ((argc < 3) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDCWindow, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]); {
        Check_Type(argv[2], T_STRING); arg4 = STR2CSTR(argv[2]); arg5 = RSTRING(argv[2])->len; } 
    FXDCWindow_drawText(arg1,arg2,arg3,(FXchar const *)arg4,arg5); return Qnil; }
static VALUE _wrap_FXDCWindow_drawImageText(int argc, VALUE *argv, VALUE self) { FXDCWindow *arg1 = (FXDCWindow *) 0 ;
    FXint arg2 ; FXint arg3 ; FXchar *arg4 ; FXuint arg5 ; if ((argc < 3) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDCWindow, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]); {
        Check_Type(argv[2], T_STRING); arg4 = STR2CSTR(argv[2]); arg5 = RSTRING(argv[2])->len; } 
    FXDCWindow_drawImageText(arg1,arg2,arg3,(FXchar const *)arg4,arg5); return Qnil; }
static VALUE _wrap_FXDCWindow_setForeground(int argc, VALUE *argv, VALUE self) { FXDCWindow *arg1 = (FXDCWindow *) 0 ;
    FXColor arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDCWindow, 1); arg2 = to_FXColor(argv[0]);
    FXDCWindow_setForeground(arg1,arg2); return Qnil; }
static VALUE _wrap_FXDCWindow_setBackground(int argc, VALUE *argv, VALUE self) { FXDCWindow *arg1 = (FXDCWindow *) 0 ;
    FXColor arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDCWindow, 1); arg2 = to_FXColor(argv[0]);
    FXDCWindow_setBackground(arg1,arg2); return Qnil; }
static VALUE _wrap_FXDCWindow_setDashes(int argc, VALUE *argv, VALUE self) { FXDCWindow *arg1 = (FXDCWindow *) 0 ; FXuint arg2 ;
    FXchar *arg3 ; FXuint arg4 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDCWindow, 1); arg2 = NUM2UINT(argv[0]); { Check_Type(argv[1], T_ARRAY);
        arg3 = new FXchar[RARRAY(argv[1])->len]; arg4 = static_cast<FXuint>( RARRAY(argv[1])->len );
        for (FXuint i = 0; i < arg4; i++) { arg3[i] = NUM2INT(rb_ary_entry(argv[1], i)); }  } 
    FXDCWindow_setDashes(arg1,arg2,(FXchar const *)arg3,arg4); { delete [] arg3; }  return Qnil; }
static VALUE _wrap_FXDCWindow_setLineWidth(int argc, VALUE *argv, VALUE self) { FXDCWindow *arg1 = (FXDCWindow *) 0 ;
    FXuint arg2 = (FXuint) 0 ; if ((argc < 0) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDCWindow, 1); if (argc > 0) { arg2 = NUM2UINT(argv[0]); } 
    FXDCWindow_setLineWidth(arg1,arg2); return Qnil; }
static VALUE _wrap_FXDCWindow_setLineCap(int argc, VALUE *argv, VALUE self) { FXDCWindow *arg1 = (FXDCWindow *) 0 ;
    int arg2 = (int) CAP_BUTT ; if ((argc < 0) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDCWindow, 1); if (argc > 0) { arg2 = (int) NUM2INT(argv[0]); } 
    FXDCWindow_setLineCap(arg1,(FXCapStyle )arg2); return Qnil; }
static VALUE _wrap_FXDCWindow_setLineJoin(int argc, VALUE *argv, VALUE self) { FXDCWindow *arg1 = (FXDCWindow *) 0 ;
    int arg2 = (int) JOIN_MITER ; if ((argc < 0) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDCWindow, 1); if (argc > 0) { arg2 = (int) NUM2INT(argv[0]); } 
    FXDCWindow_setLineJoin(arg1,(FXJoinStyle )arg2); return Qnil; }
static VALUE _wrap_FXDCWindow_setLineStyle(int argc, VALUE *argv, VALUE self) { FXDCWindow *arg1 = (FXDCWindow *) 0 ;
    int arg2 = (int) LINE_SOLID ; if ((argc < 0) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDCWindow, 1); if (argc > 0) { arg2 = (int) NUM2INT(argv[0]); } 
    FXDCWindow_setLineStyle(arg1,(FXLineStyle )arg2); return Qnil; }
static VALUE _wrap_FXDCWindow_setFillStyle(int argc, VALUE *argv, VALUE self) { FXDCWindow *arg1 = (FXDCWindow *) 0 ;
    int arg2 = (int) FILL_SOLID ; if ((argc < 0) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDCWindow, 1); if (argc > 0) { arg2 = (int) NUM2INT(argv[0]); } 
    FXDCWindow_setFillStyle(arg1,(FXFillStyle )arg2); return Qnil; }
static VALUE _wrap_FXDCWindow_setFillRule(int argc, VALUE *argv, VALUE self) { FXDCWindow *arg1 = (FXDCWindow *) 0 ;
    int arg2 = (int) RULE_EVEN_ODD ; if ((argc < 0) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDCWindow, 1); if (argc > 0) { arg2 = (int) NUM2INT(argv[0]); } 
    FXDCWindow_setFillRule(arg1,(FXFillRule )arg2); return Qnil; }
static VALUE _wrap_FXDCWindow_setFunction(int argc, VALUE *argv, VALUE self) { FXDCWindow *arg1 = (FXDCWindow *) 0 ;
    int arg2 = (int) BLT_SRC ; if ((argc < 0) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDCWindow, 1); if (argc > 0) { arg2 = (int) NUM2INT(argv[0]); } 
    FXDCWindow_setFunction(arg1,(FXFunction )arg2); return Qnil; }
static VALUE _wrap_FXDCWindow_setTile(int argc, VALUE *argv, VALUE self) { FXDCWindow *arg1 = (FXDCWindow *) 0 ;
    FXImage *arg2 = (FXImage *) 0 ; FXint arg3 = (FXint) 0 ; FXint arg4 = (FXint) 0 ; if ((argc < 1) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDCWindow, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXImage, 1); if (argc > 1) { arg3 = NUM2INT(argv[1]); } 
    if (argc > 2) { arg4 = NUM2INT(argv[2]); }  FXDCWindow_setTile(arg1,arg2,arg3,arg4); return Qnil; }
static VALUE _wrap_FXDCWindow_setStipple__SWIG_0(int argc, VALUE *argv, VALUE self) { FXDCWindow *arg1 = (FXDCWindow *) 0 ;
    FXBitmap *arg2 = (FXBitmap *) 0 ; FXint arg3 = (FXint) 0 ; FXint arg4 = (FXint) 0 ; if ((argc < 1) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDCWindow, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXBitmap, 1); if (argc > 1) { arg3 = NUM2INT(argv[1]); } 
    if (argc > 2) { arg4 = NUM2INT(argv[2]); }  FXDCWindow_setStipple(arg1,arg2,arg3,arg4); return Qnil; }
static VALUE _wrap_FXDCWindow_setStipple__SWIG_1(int argc, VALUE *argv, VALUE self) { FXDCWindow *arg1 = (FXDCWindow *) 0 ;
    int arg2 ; FXint arg3 = (FXint) 0 ; FXint arg4 = (FXint) 0 ; if ((argc < 1) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDCWindow, 1); arg2 = (int) NUM2INT(argv[0]); if (argc > 1) {
        arg3 = NUM2INT(argv[1]); }  if (argc > 2) { arg4 = NUM2INT(argv[2]); } 
    FXDCWindow_setStipple(arg1,(FXStipplePattern )arg2,arg3,arg4); return Qnil; }
static VALUE _wrap_FXDCWindow_setStipple(int nargs, VALUE *args, VALUE self) { int argc; VALUE argv[5]; int ii;
    argc = nargs + 1; argv[0] = self; for (ii = 1; (ii < argc) && (ii < 4); ii++) { argv[ii] = args[ii-1]; } 
    if ((argc >= 2) && (argc <= 4)) { int _v; { void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXDCWindow, 0) != -1)) ? 1 : 0; }
         if (_v) { { void *ptr;
                _v = (NIL_P(argv[1]) || (TYPE(argv[1]) == T_DATA && SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_FXBitmap, 0) != -1)) ? 1 : 0; }
             if (_v) { if (argc <= 2) { return _wrap_FXDCWindow_setStipple__SWIG_0(nargs, args, self);}  {
                    _v = ((TYPE(argv[2]) == T_FIXNUM) || (TYPE(argv[2]) == T_BIGNUM)) ? 1 : 0; }  if (_v) { if (argc <= 3) {
                        return _wrap_FXDCWindow_setStipple__SWIG_0(nargs, args, self);}  {
                        _v = ((TYPE(argv[3]) == T_FIXNUM) || (TYPE(argv[3]) == T_BIGNUM)) ? 1 : 0; }  if (_v) {
                        return _wrap_FXDCWindow_setStipple__SWIG_0(nargs, args, self);}  }  }  }  } 
    if ((argc >= 2) && (argc <= 4)) { int _v; { void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXDCWindow, 0) != -1)) ? 1 : 0; }
         if (_v) { { _v = ((TYPE(argv[1]) == T_FIXNUM) || (TYPE(argv[1]) == T_BIGNUM)) ? 1 : 0; }  if (_v) { if (argc <= 2) {
                    return _wrap_FXDCWindow_setStipple__SWIG_1(nargs, args, self);}  {
                    _v = ((TYPE(argv[2]) == T_FIXNUM) || (TYPE(argv[2]) == T_BIGNUM)) ? 1 : 0; }  if (_v) { if (argc <= 3) {
                        return _wrap_FXDCWindow_setStipple__SWIG_1(nargs, args, self);}  {
                        _v = ((TYPE(argv[3]) == T_FIXNUM) || (TYPE(argv[3]) == T_BIGNUM)) ? 1 : 0; }  if (_v) {
                        return _wrap_FXDCWindow_setStipple__SWIG_1(nargs, args, self);}  }  }  }  } 
    rb_raise(rb_eArgError, "No matching function for overloaded 'FXDCWindow_setStipple'"); return Qnil; }
static VALUE _wrap_FXDCWindow_setClipRegion(int argc, VALUE *argv, VALUE self) { FXDCWindow *arg1 = (FXDCWindow *) 0 ;
    FXRegion *arg2 = 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDCWindow, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXRegion, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXDCWindow_setClipRegion(arg1,(FXRegion const &)*arg2); return Qnil; }
static VALUE _wrap_FXDCWindow_setClipRectangle__SWIG_0(int argc, VALUE *argv, VALUE self) {
    FXDCWindow *arg1 = (FXDCWindow *) 0 ; FXint arg2 ; FXint arg3 ; FXint arg4 ; FXint arg5 ; if ((argc < 4) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDCWindow, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    arg4 = NUM2INT(argv[2]); arg5 = NUM2INT(argv[3]); FXDCWindow_setClipRectangle(arg1,arg2,arg3,arg4,arg5); return Qnil; }
static VALUE _wrap_FXDCWindow_setClipRectangle__SWIG_1(int argc, VALUE *argv, VALUE self) {
    FXDCWindow *arg1 = (FXDCWindow *) 0 ; FXRectangle *arg2 = 0 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDCWindow, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXRectangle, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXDCWindow_setClipRectangle(arg1,(FXRectangle const &)*arg2); return Qnil; }
static VALUE _wrap_FXDCWindow_setClipRectangle(int nargs, VALUE *args, VALUE self) { int argc; VALUE argv[6]; int ii;
    argc = nargs + 1; argv[0] = self; for (ii = 1; (ii < argc) && (ii < 5); ii++) { argv[ii] = args[ii-1]; }  if (argc == 2) {
        int _v; { void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXDCWindow, 0) != -1)) ? 1 : 0; }
         if (_v) { { void *ptr;
                _v = (NIL_P(argv[1]) || (TYPE(argv[1]) == T_DATA && SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_FXRectangle, 0) != -1)) ? 1 : 0; }
             if (_v) { return _wrap_FXDCWindow_setClipRectangle__SWIG_1(nargs, args, self);}  }  }  if (argc == 5) { int _v; {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXDCWindow, 0) != -1)) ? 1 : 0; }
         if (_v) { { _v = ((TYPE(argv[1]) == T_FIXNUM) || (TYPE(argv[1]) == T_BIGNUM)) ? 1 : 0; }  if (_v) { {
                    _v = ((TYPE(argv[2]) == T_FIXNUM) || (TYPE(argv[2]) == T_BIGNUM)) ? 1 : 0; }  if (_v) { {
                        _v = ((TYPE(argv[3]) == T_FIXNUM) || (TYPE(argv[3]) == T_BIGNUM)) ? 1 : 0; }  if (_v) { {
                            _v = ((TYPE(argv[4]) == T_FIXNUM) || (TYPE(argv[4]) == T_BIGNUM)) ? 1 : 0; }  if (_v) {
                            return _wrap_FXDCWindow_setClipRectangle__SWIG_0(nargs, args, self);}  }  }  }  }  } 
    rb_raise(rb_eArgError, "No matching function for overloaded 'FXDCWindow_setClipRectangle'"); return Qnil; }
static VALUE _wrap_FXDCWindow_clearClipRectangle(int argc, VALUE *argv, VALUE self) { FXDCWindow *arg1 = (FXDCWindow *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDCWindow, 1); FXDCWindow_clearClipRectangle(arg1); return Qnil; }
static VALUE _wrap_FXDCWindow_setClipMask(int argc, VALUE *argv, VALUE self) { FXDCWindow *arg1 = (FXDCWindow *) 0 ;
    FXBitmap *arg2 = (FXBitmap *) 0 ; FXint arg3 = (FXint) 0 ; FXint arg4 = (FXint) 0 ; if ((argc < 1) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDCWindow, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXBitmap, 1); if (argc > 1) { arg3 = NUM2INT(argv[1]); } 
    if (argc > 2) { arg4 = NUM2INT(argv[2]); }  FXDCWindow_setClipMask(arg1,arg2,arg3,arg4); return Qnil; }
static VALUE _wrap_FXDCWindow_clearClipMask(int argc, VALUE *argv, VALUE self) { FXDCWindow *arg1 = (FXDCWindow *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDCWindow, 1); FXDCWindow_clearClipMask(arg1); return Qnil; }
static VALUE _wrap_FXDCWindow_setFont(int argc, VALUE *argv, VALUE self) { FXDCWindow *arg1 = (FXDCWindow *) 0 ;
    FXFont *arg2 = (FXFont *) 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDCWindow, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXFont, 1); FXDCWindow_setFont(arg1,arg2); return Qnil; }
static VALUE _wrap_FXDCWindow_clipChildren(int argc, VALUE *argv, VALUE self) { FXDCWindow *arg1 = (FXDCWindow *) 0 ;
    FXbool arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDCWindow, 1); arg2 = to_FXbool(argv[0]);
    FXDCWindow_clipChildren(arg1,arg2); return Qnil; }
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE _wrap_FXPSBounds_allocate(VALUE self) {
#else
     static VALUE _wrap_FXPSBounds_allocate(int argc, VALUE *argv, VALUE self) {
#endif
         VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_FXPSBounds);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
         return vresult; }
static VALUE _wrap_new_FXPSBounds(int argc, VALUE *argv, VALUE self) { FXPSBounds *result; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc); result = (FXPSBounds *)new FXPSBounds();
    DATA_PTR(self) = result; return self; }
static VALUE _wrap_FXPSBounds_xmin_set(int argc, VALUE *argv, VALUE self) { FXPSBounds *arg1 = (FXPSBounds *) 0 ;
    FXdouble arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPSBounds, 1); arg2 = (FXdouble) NUM2DBL(argv[0]);
    if (arg1) (arg1)->xmin = arg2; return Qnil; }
static VALUE _wrap_FXPSBounds_xmin_get(int argc, VALUE *argv, VALUE self) { FXPSBounds *arg1 = (FXPSBounds *) 0 ;
    FXdouble result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPSBounds, 1); result = (FXdouble) ((arg1)->xmin);
    vresult = rb_float_new(result); return vresult; }
static VALUE _wrap_FXPSBounds_xmax_set(int argc, VALUE *argv, VALUE self) { FXPSBounds *arg1 = (FXPSBounds *) 0 ;
    FXdouble arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPSBounds, 1); arg2 = (FXdouble) NUM2DBL(argv[0]);
    if (arg1) (arg1)->xmax = arg2; return Qnil; }
static VALUE _wrap_FXPSBounds_xmax_get(int argc, VALUE *argv, VALUE self) { FXPSBounds *arg1 = (FXPSBounds *) 0 ;
    FXdouble result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPSBounds, 1); result = (FXdouble) ((arg1)->xmax);
    vresult = rb_float_new(result); return vresult; }
static VALUE _wrap_FXPSBounds_ymin_set(int argc, VALUE *argv, VALUE self) { FXPSBounds *arg1 = (FXPSBounds *) 0 ;
    FXdouble arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPSBounds, 1); arg2 = (FXdouble) NUM2DBL(argv[0]);
    if (arg1) (arg1)->ymin = arg2; return Qnil; }
static VALUE _wrap_FXPSBounds_ymin_get(int argc, VALUE *argv, VALUE self) { FXPSBounds *arg1 = (FXPSBounds *) 0 ;
    FXdouble result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPSBounds, 1); result = (FXdouble) ((arg1)->ymin);
    vresult = rb_float_new(result); return vresult; }
static VALUE _wrap_FXPSBounds_ymax_set(int argc, VALUE *argv, VALUE self) { FXPSBounds *arg1 = (FXPSBounds *) 0 ;
    FXdouble arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPSBounds, 1); arg2 = (FXdouble) NUM2DBL(argv[0]);
    if (arg1) (arg1)->ymax = arg2; return Qnil; }
static VALUE _wrap_FXPSBounds_ymax_get(int argc, VALUE *argv, VALUE self) { FXPSBounds *arg1 = (FXPSBounds *) 0 ;
    FXdouble result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPSBounds, 1); result = (FXdouble) ((arg1)->ymax);
    vresult = rb_float_new(result); return vresult; }
static void
free_FXPSBounds(FXPSBounds *arg1) {
    delete arg1;
}
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE _wrap_FXPrinter_allocate(VALUE self) {
#else
     static VALUE _wrap_FXPrinter_allocate(int argc, VALUE *argv, VALUE self) {
#endif
         VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_FXPrinter);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
         return vresult; }
static VALUE _wrap_new_FXPrinter(int argc, VALUE *argv, VALUE self) { FXPrinter *result; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc); result = (FXPrinter *)new FXPrinter();
    DATA_PTR(self) = result; return self; }
static VALUE _wrap_FXPrinter_name_set(int argc, VALUE *argv, VALUE self) { FXPrinter *arg1 = (FXPrinter *) 0 ; FXString arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPrinter, 1); arg2 = to_FXString(argv[0]); if (arg1) (arg1)->name = arg2;
    return Qnil; }
static VALUE _wrap_FXPrinter_name_get(int argc, VALUE *argv, VALUE self) { FXPrinter *arg1 = (FXPrinter *) 0 ; FXString result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPrinter, 1); result =  ((arg1)->name);
    vresult = rb_str_new2((&result)->text()); return vresult; }
static VALUE _wrap_FXPrinter_firstpage_set(int argc, VALUE *argv, VALUE self) { FXPrinter *arg1 = (FXPrinter *) 0 ;
    FXuint arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPrinter, 1); arg2 = NUM2UINT(argv[0]);
    if (arg1) (arg1)->firstpage = arg2; return Qnil; }
static VALUE _wrap_FXPrinter_firstpage_get(int argc, VALUE *argv, VALUE self) { FXPrinter *arg1 = (FXPrinter *) 0 ;
    FXuint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPrinter, 1); result = (FXuint) ((arg1)->firstpage);
    vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXPrinter_lastpage_set(int argc, VALUE *argv, VALUE self) { FXPrinter *arg1 = (FXPrinter *) 0 ; FXuint arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPrinter, 1); arg2 = NUM2UINT(argv[0]);
    if (arg1) (arg1)->lastpage = arg2; return Qnil; }
static VALUE _wrap_FXPrinter_lastpage_get(int argc, VALUE *argv, VALUE self) { FXPrinter *arg1 = (FXPrinter *) 0 ;
    FXuint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPrinter, 1); result = (FXuint) ((arg1)->lastpage);
    vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXPrinter_currentpage_set(int argc, VALUE *argv, VALUE self) { FXPrinter *arg1 = (FXPrinter *) 0 ;
    FXuint arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPrinter, 1); arg2 = NUM2UINT(argv[0]);
    if (arg1) (arg1)->currentpage = arg2; return Qnil; }
static VALUE _wrap_FXPrinter_currentpage_get(int argc, VALUE *argv, VALUE self) { FXPrinter *arg1 = (FXPrinter *) 0 ;
    FXuint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPrinter, 1); result = (FXuint) ((arg1)->currentpage);
    vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXPrinter_frompage_set(int argc, VALUE *argv, VALUE self) { FXPrinter *arg1 = (FXPrinter *) 0 ; FXuint arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPrinter, 1); arg2 = NUM2UINT(argv[0]);
    if (arg1) (arg1)->frompage = arg2; return Qnil; }
static VALUE _wrap_FXPrinter_frompage_get(int argc, VALUE *argv, VALUE self) { FXPrinter *arg1 = (FXPrinter *) 0 ;
    FXuint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPrinter, 1); result = (FXuint) ((arg1)->frompage);
    vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXPrinter_topage_set(int argc, VALUE *argv, VALUE self) { FXPrinter *arg1 = (FXPrinter *) 0 ; FXuint arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPrinter, 1); arg2 = NUM2UINT(argv[0]); if (arg1) (arg1)->topage = arg2;
    return Qnil; }
static VALUE _wrap_FXPrinter_topage_get(int argc, VALUE *argv, VALUE self) { FXPrinter *arg1 = (FXPrinter *) 0 ; FXuint result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPrinter, 1); result = (FXuint) ((arg1)->topage);
    vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXPrinter_mediasize_set(int argc, VALUE *argv, VALUE self) { FXPrinter *arg1 = (FXPrinter *) 0 ;
    FXuint arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPrinter, 1); arg2 = NUM2UINT(argv[0]);
    if (arg1) (arg1)->mediasize = arg2; return Qnil; }
static VALUE _wrap_FXPrinter_mediasize_get(int argc, VALUE *argv, VALUE self) { FXPrinter *arg1 = (FXPrinter *) 0 ;
    FXuint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPrinter, 1); result = (FXuint) ((arg1)->mediasize);
    vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXPrinter_mediawidth_set(int argc, VALUE *argv, VALUE self) { FXPrinter *arg1 = (FXPrinter *) 0 ;
    FXdouble arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPrinter, 1); arg2 = (FXdouble) NUM2DBL(argv[0]);
    if (arg1) (arg1)->mediawidth = arg2; return Qnil; }
static VALUE _wrap_FXPrinter_mediawidth_get(int argc, VALUE *argv, VALUE self) { FXPrinter *arg1 = (FXPrinter *) 0 ;
    FXdouble result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPrinter, 1); result = (FXdouble) ((arg1)->mediawidth);
    vresult = rb_float_new(result); return vresult; }
static VALUE _wrap_FXPrinter_mediaheight_set(int argc, VALUE *argv, VALUE self) { FXPrinter *arg1 = (FXPrinter *) 0 ;
    FXdouble arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPrinter, 1); arg2 = (FXdouble) NUM2DBL(argv[0]);
    if (arg1) (arg1)->mediaheight = arg2; return Qnil; }
static VALUE _wrap_FXPrinter_mediaheight_get(int argc, VALUE *argv, VALUE self) { FXPrinter *arg1 = (FXPrinter *) 0 ;
    FXdouble result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPrinter, 1); result = (FXdouble) ((arg1)->mediaheight);
    vresult = rb_float_new(result); return vresult; }
static VALUE _wrap_FXPrinter_leftmargin_set(int argc, VALUE *argv, VALUE self) { FXPrinter *arg1 = (FXPrinter *) 0 ;
    FXdouble arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPrinter, 1); arg2 = (FXdouble) NUM2DBL(argv[0]);
    if (arg1) (arg1)->leftmargin = arg2; return Qnil; }
static VALUE _wrap_FXPrinter_leftmargin_get(int argc, VALUE *argv, VALUE self) { FXPrinter *arg1 = (FXPrinter *) 0 ;
    FXdouble result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPrinter, 1); result = (FXdouble) ((arg1)->leftmargin);
    vresult = rb_float_new(result); return vresult; }
static VALUE _wrap_FXPrinter_rightmargin_set(int argc, VALUE *argv, VALUE self) { FXPrinter *arg1 = (FXPrinter *) 0 ;
    FXdouble arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPrinter, 1); arg2 = (FXdouble) NUM2DBL(argv[0]);
    if (arg1) (arg1)->rightmargin = arg2; return Qnil; }
static VALUE _wrap_FXPrinter_rightmargin_get(int argc, VALUE *argv, VALUE self) { FXPrinter *arg1 = (FXPrinter *) 0 ;
    FXdouble result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPrinter, 1); result = (FXdouble) ((arg1)->rightmargin);
    vresult = rb_float_new(result); return vresult; }
static VALUE _wrap_FXPrinter_topmargin_set(int argc, VALUE *argv, VALUE self) { FXPrinter *arg1 = (FXPrinter *) 0 ;
    FXdouble arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPrinter, 1); arg2 = (FXdouble) NUM2DBL(argv[0]);
    if (arg1) (arg1)->topmargin = arg2; return Qnil; }
static VALUE _wrap_FXPrinter_topmargin_get(int argc, VALUE *argv, VALUE self) { FXPrinter *arg1 = (FXPrinter *) 0 ;
    FXdouble result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPrinter, 1); result = (FXdouble) ((arg1)->topmargin);
    vresult = rb_float_new(result); return vresult; }
static VALUE _wrap_FXPrinter_bottommargin_set(int argc, VALUE *argv, VALUE self) { FXPrinter *arg1 = (FXPrinter *) 0 ;
    FXdouble arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPrinter, 1); arg2 = (FXdouble) NUM2DBL(argv[0]);
    if (arg1) (arg1)->bottommargin = arg2; return Qnil; }
static VALUE _wrap_FXPrinter_bottommargin_get(int argc, VALUE *argv, VALUE self) { FXPrinter *arg1 = (FXPrinter *) 0 ;
    FXdouble result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPrinter, 1); result = (FXdouble) ((arg1)->bottommargin);
    vresult = rb_float_new(result); return vresult; }
static VALUE _wrap_FXPrinter_numcopies_set(int argc, VALUE *argv, VALUE self) { FXPrinter *arg1 = (FXPrinter *) 0 ;
    FXuint arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPrinter, 1); arg2 = NUM2UINT(argv[0]);
    if (arg1) (arg1)->numcopies = arg2; return Qnil; }
static VALUE _wrap_FXPrinter_numcopies_get(int argc, VALUE *argv, VALUE self) { FXPrinter *arg1 = (FXPrinter *) 0 ;
    FXuint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPrinter, 1); result = (FXuint) ((arg1)->numcopies);
    vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXPrinter_flags_set(int argc, VALUE *argv, VALUE self) { FXPrinter *arg1 = (FXPrinter *) 0 ; FXuint arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPrinter, 1); arg2 = NUM2UINT(argv[0]); if (arg1) (arg1)->flags = arg2;
    return Qnil; }
static VALUE _wrap_FXPrinter_flags_get(int argc, VALUE *argv, VALUE self) { FXPrinter *arg1 = (FXPrinter *) 0 ; FXuint result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPrinter, 1); result = (FXuint) ((arg1)->flags);
    vresult = UINT2NUM(result); return vresult; }
static void
free_FXPrinter(FXPrinter *arg1) {
    delete arg1;
}
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE _wrap_FXDCPrint_allocate(VALUE self) {
#else
     static VALUE _wrap_FXDCPrint_allocate(int argc, VALUE *argv, VALUE self) {
#endif
         VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_FXDCPrint);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
         return vresult; }
static VALUE _wrap_new_FXDCPrint(int argc, VALUE *argv, VALUE self) { FXApp *arg1 = (FXApp *) 0 ; FXDCPrint *result;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXApp, 1); { result = (FXDCPrint *)new_FXDCPrint(arg1);
        DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result); if(rb_block_given_p()){ rb_yield(self); }  }  return self; }
static VALUE _wrap_FXDCPrint_beginPrint(int argc, VALUE *argv, VALUE self) { FXDCPrint *arg1 = (FXDCPrint *) 0 ;
    FXPrinter *arg2 = 0 ; FXbool result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDCPrint, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXPrinter, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    result = (FXbool)(arg1)->beginPrint(*arg2); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXDCPrint_endPrint(int argc, VALUE *argv, VALUE self) { FXDCPrint *arg1 = (FXDCPrint *) 0 ; FXbool result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDCPrint, 1); result = (FXbool)(arg1)->endPrint();
    vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXDCPrint_beginPage(int argc, VALUE *argv, VALUE self) { FXDCPrint *arg1 = (FXDCPrint *) 0 ;
    FXuint arg2 = (FXuint) 1 ; FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDCPrint, 1); if (argc > 0) { arg2 = NUM2UINT(argv[0]); } 
    result = (FXbool)(arg1)->beginPage(arg2); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXDCPrint_endPage(int argc, VALUE *argv, VALUE self) { FXDCPrint *arg1 = (FXDCPrint *) 0 ; FXbool result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDCPrint, 1); result = (FXbool)(arg1)->endPage();
    vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXDCPrint_setContentRange(int argc, VALUE *argv, VALUE self) { FXDCPrint *arg1 = (FXDCPrint *) 0 ;
    FXint arg2 ; FXint arg3 ; FXint arg4 ; FXint arg5 ; FXbool result; VALUE vresult = Qnil; if ((argc < 4) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDCPrint, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    arg4 = NUM2INT(argv[2]); arg5 = NUM2INT(argv[3]); result = (FXbool)(arg1)->setContentRange(arg2,arg3,arg4,arg5);
    vresult = result ? Qtrue : Qfalse; return vresult; }
static void
free_FXDCPrint(FXDCPrint *arg1) {
    delete arg1;
}
static VALUE _wrap_FXDCPrint_readPixel(int argc, VALUE *argv, VALUE self) { FXDCPrint *arg1 = (FXDCPrint *) 0 ; FXint arg2 ;
    FXint arg3 ; FXColor result; VALUE vresult = Qnil; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDCPrint, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    result = (FXColor)FXDCPrint_readPixel(arg1,arg2,arg3); vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXDCPrint_drawPoint(int argc, VALUE *argv, VALUE self) { FXDCPrint *arg1 = (FXDCPrint *) 0 ; FXint arg2 ;
    FXint arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDCPrint, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    FXDCPrint_drawPoint(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXDCPrint_drawPoints(int argc, VALUE *argv, VALUE self) { FXDCPrint *arg1 = (FXDCPrint *) 0 ;
    FXPoint *arg2 = (FXPoint *) 0 ; FXuint arg3 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDCPrint, 1); { Check_Type(argv[0], T_ARRAY);
        arg2 = new FXPoint[RARRAY(argv[0])->len]; arg3 = static_cast<FXuint>( RARRAY(argv[0])->len );
        for (FXuint i = 0; i < arg3; i++) { FXPoint *pPoint; Data_Get_Struct(rb_ary_entry(argv[0], i), FXPoint, pPoint);
            arg2[i] = *pPoint; }  }  FXDCPrint_drawPoints(arg1,(FXPoint const *)arg2,arg3); { delete [] arg2; }  return Qnil; }
static VALUE _wrap_FXDCPrint_drawPointsRel(int argc, VALUE *argv, VALUE self) { FXDCPrint *arg1 = (FXDCPrint *) 0 ;
    FXPoint *arg2 = (FXPoint *) 0 ; FXuint arg3 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDCPrint, 1); { Check_Type(argv[0], T_ARRAY);
        arg2 = new FXPoint[RARRAY(argv[0])->len]; arg3 = static_cast<FXuint>( RARRAY(argv[0])->len );
        for (FXuint i = 0; i < arg3; i++) { FXPoint *pPoint; Data_Get_Struct(rb_ary_entry(argv[0], i), FXPoint, pPoint);
            arg2[i] = *pPoint; }  }  FXDCPrint_drawPointsRel(arg1,(FXPoint const *)arg2,arg3); { delete [] arg2; } 
    return Qnil; }
static VALUE _wrap_FXDCPrint_drawLine(int argc, VALUE *argv, VALUE self) { FXDCPrint *arg1 = (FXDCPrint *) 0 ; FXint arg2 ;
    FXint arg3 ; FXint arg4 ; FXint arg5 ; if ((argc < 4) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDCPrint, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    arg4 = NUM2INT(argv[2]); arg5 = NUM2INT(argv[3]); FXDCPrint_drawLine(arg1,arg2,arg3,arg4,arg5); return Qnil; }
static VALUE _wrap_FXDCPrint_drawLines(int argc, VALUE *argv, VALUE self) { FXDCPrint *arg1 = (FXDCPrint *) 0 ;
    FXPoint *arg2 = (FXPoint *) 0 ; FXuint arg3 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDCPrint, 1); { Check_Type(argv[0], T_ARRAY);
        arg2 = new FXPoint[RARRAY(argv[0])->len]; arg3 = static_cast<FXuint>( RARRAY(argv[0])->len );
        for (FXuint i = 0; i < arg3; i++) { FXPoint *pPoint; Data_Get_Struct(rb_ary_entry(argv[0], i), FXPoint, pPoint);
            arg2[i] = *pPoint; }  }  FXDCPrint_drawLines(arg1,(FXPoint const *)arg2,arg3); { delete [] arg2; }  return Qnil; }
static VALUE _wrap_FXDCPrint_drawLinesRel(int argc, VALUE *argv, VALUE self) { FXDCPrint *arg1 = (FXDCPrint *) 0 ;
    FXPoint *arg2 = (FXPoint *) 0 ; FXuint arg3 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDCPrint, 1); { Check_Type(argv[0], T_ARRAY);
        arg2 = new FXPoint[RARRAY(argv[0])->len]; arg3 = static_cast<FXuint>( RARRAY(argv[0])->len );
        for (FXuint i = 0; i < arg3; i++) { FXPoint *pPoint; Data_Get_Struct(rb_ary_entry(argv[0], i), FXPoint, pPoint);
            arg2[i] = *pPoint; }  }  FXDCPrint_drawLinesRel(arg1,(FXPoint const *)arg2,arg3); { delete [] arg2; }  return Qnil; }
static VALUE _wrap_FXDCPrint_drawLineSegments(int argc, VALUE *argv, VALUE self) { FXDCPrint *arg1 = (FXDCPrint *) 0 ;
    FXSegment *arg2 = (FXSegment *) 0 ; FXuint arg3 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDCPrint, 1); { Check_Type(argv[0], T_ARRAY);
        arg2 = new FXSegment[RARRAY(argv[0])->len]; arg3 = static_cast<FXuint>( RARRAY(argv[0])->len );
        for (FXuint i = 0; i < arg3; i++) { FXSegment *pSeg; Data_Get_Struct(rb_ary_entry(argv[0], i), FXSegment, pSeg);
            arg2[i] = *pSeg; }  }  FXDCPrint_drawLineSegments(arg1,(FXSegment const *)arg2,arg3); { delete [] arg2; } 
    return Qnil; }
static VALUE _wrap_FXDCPrint_drawRectangle(int argc, VALUE *argv, VALUE self) { FXDCPrint *arg1 = (FXDCPrint *) 0 ; FXint arg2 ;
    FXint arg3 ; FXint arg4 ; FXint arg5 ; if ((argc < 4) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDCPrint, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    arg4 = NUM2INT(argv[2]); arg5 = NUM2INT(argv[3]); FXDCPrint_drawRectangle(arg1,arg2,arg3,arg4,arg5); return Qnil; }
static VALUE _wrap_FXDCPrint_drawRectangles(int argc, VALUE *argv, VALUE self) { FXDCPrint *arg1 = (FXDCPrint *) 0 ;
    FXRectangle *arg2 = (FXRectangle *) 0 ; FXuint arg3 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDCPrint, 1); { Check_Type(argv[0], T_ARRAY);
        arg2 = new FXRectangle[RARRAY(argv[0])->len]; arg3 = static_cast<FXuint>( RARRAY(argv[0])->len );
        for (FXuint i = 0; i < arg3; i++) { FXRectangle *pRect; Data_Get_Struct(rb_ary_entry(argv[0], i), FXRectangle, pRect);
            arg2[i] = *pRect; }  }  FXDCPrint_drawRectangles(arg1,(FXRectangle const *)arg2,arg3); { delete [] arg2; } 
    return Qnil; }
static VALUE _wrap_FXDCPrint_drawArc(int argc, VALUE *argv, VALUE self) { FXDCPrint *arg1 = (FXDCPrint *) 0 ; FXint arg2 ;
    FXint arg3 ; FXint arg4 ; FXint arg5 ; FXint arg6 ; FXint arg7 ; if ((argc < 6) || (argc > 6))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 6)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDCPrint, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    arg4 = NUM2INT(argv[2]); arg5 = NUM2INT(argv[3]); arg6 = NUM2INT(argv[4]); arg7 = NUM2INT(argv[5]);
    FXDCPrint_drawArc(arg1,arg2,arg3,arg4,arg5,arg6,arg7); return Qnil; }
static VALUE _wrap_FXDCPrint_drawArcs(int argc, VALUE *argv, VALUE self) { FXDCPrint *arg1 = (FXDCPrint *) 0 ;
    FXArc *arg2 = (FXArc *) 0 ; FXuint arg3 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDCPrint, 1); { Check_Type(argv[0], T_ARRAY);
        arg2 = new FXArc[RARRAY(argv[0])->len]; arg3 = static_cast<FXuint>( RARRAY(argv[0])->len );
        for (FXuint i = 0; i < arg3; i++) { FXArc *pArc; Data_Get_Struct(rb_ary_entry(argv[0], i), FXArc, pArc);
            arg2[i] = *pArc; }  }  FXDCPrint_drawArcs(arg1,(FXArc const *)arg2,arg3); return Qnil; }
static VALUE _wrap_FXDCPrint_fillRectangle(int argc, VALUE *argv, VALUE self) { FXDCPrint *arg1 = (FXDCPrint *) 0 ; FXint arg2 ;
    FXint arg3 ; FXint arg4 ; FXint arg5 ; if ((argc < 4) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDCPrint, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    arg4 = NUM2INT(argv[2]); arg5 = NUM2INT(argv[3]); FXDCPrint_fillRectangle(arg1,arg2,arg3,arg4,arg5); return Qnil; }
static VALUE _wrap_FXDCPrint_fillRectangles(int argc, VALUE *argv, VALUE self) { FXDCPrint *arg1 = (FXDCPrint *) 0 ;
    FXRectangle *arg2 = (FXRectangle *) 0 ; FXuint arg3 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDCPrint, 1); { Check_Type(argv[0], T_ARRAY);
        arg2 = new FXRectangle[RARRAY(argv[0])->len]; arg3 = static_cast<FXuint>( RARRAY(argv[0])->len );
        for (FXuint i = 0; i < arg3; i++) { FXRectangle *pRect; Data_Get_Struct(rb_ary_entry(argv[0], i), FXRectangle, pRect);
            arg2[i] = *pRect; }  }  FXDCPrint_fillRectangles(arg1,(FXRectangle const *)arg2,arg3); { delete [] arg2; } 
    return Qnil; }
static VALUE _wrap_FXDCPrint_fillChord(int argc, VALUE *argv, VALUE self) { FXDCPrint *arg1 = (FXDCPrint *) 0 ; FXint arg2 ;
    FXint arg3 ; FXint arg4 ; FXint arg5 ; FXint arg6 ; FXint arg7 ; if ((argc < 6) || (argc > 6))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 6)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDCPrint, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    arg4 = NUM2INT(argv[2]); arg5 = NUM2INT(argv[3]); arg6 = NUM2INT(argv[4]); arg7 = NUM2INT(argv[5]);
    FXDCPrint_fillChord(arg1,arg2,arg3,arg4,arg5,arg6,arg7); return Qnil; }
static VALUE _wrap_FXDCPrint_fillChords(int argc, VALUE *argv, VALUE self) { FXDCPrint *arg1 = (FXDCPrint *) 0 ;
    FXArc *arg2 = (FXArc *) 0 ; FXuint arg3 ; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDCPrint, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXArc, 1); arg3 = NUM2UINT(argv[1]);
    FXDCPrint_fillChords(arg1,(FXArc const *)arg2,arg3); return Qnil; }
static VALUE _wrap_FXDCPrint_fillArc(int argc, VALUE *argv, VALUE self) { FXDCPrint *arg1 = (FXDCPrint *) 0 ; FXint arg2 ;
    FXint arg3 ; FXint arg4 ; FXint arg5 ; FXint arg6 ; FXint arg7 ; if ((argc < 6) || (argc > 6))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 6)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDCPrint, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    arg4 = NUM2INT(argv[2]); arg5 = NUM2INT(argv[3]); arg6 = NUM2INT(argv[4]); arg7 = NUM2INT(argv[5]);
    FXDCPrint_fillArc(arg1,arg2,arg3,arg4,arg5,arg6,arg7); return Qnil; }
static VALUE _wrap_FXDCPrint_fillArcs(int argc, VALUE *argv, VALUE self) { FXDCPrint *arg1 = (FXDCPrint *) 0 ;
    FXArc *arg2 = (FXArc *) 0 ; FXuint arg3 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDCPrint, 1); { Check_Type(argv[0], T_ARRAY);
        arg2 = new FXArc[RARRAY(argv[0])->len]; arg3 = static_cast<FXuint>( RARRAY(argv[0])->len );
        for (FXuint i = 0; i < arg3; i++) { FXArc *pArc; Data_Get_Struct(rb_ary_entry(argv[0], i), FXArc, pArc);
            arg2[i] = *pArc; }  }  FXDCPrint_fillArcs(arg1,(FXArc const *)arg2,arg3); return Qnil; }
static VALUE _wrap_FXDCPrint_fillPolygon(int argc, VALUE *argv, VALUE self) { FXDCPrint *arg1 = (FXDCPrint *) 0 ;
    FXPoint *arg2 = (FXPoint *) 0 ; FXuint arg3 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDCPrint, 1); { Check_Type(argv[0], T_ARRAY);
        arg2 = new FXPoint[RARRAY(argv[0])->len]; arg3 = static_cast<FXuint>( RARRAY(argv[0])->len );
        for (FXuint i = 0; i < arg3; i++) { FXPoint *pPoint; Data_Get_Struct(rb_ary_entry(argv[0], i), FXPoint, pPoint);
            arg2[i] = *pPoint; }  }  FXDCPrint_fillPolygon(arg1,(FXPoint const *)arg2,arg3); { delete [] arg2; }  return Qnil; }
static VALUE _wrap_FXDCPrint_fillConcavePolygon(int argc, VALUE *argv, VALUE self) { FXDCPrint *arg1 = (FXDCPrint *) 0 ;
    FXPoint *arg2 = (FXPoint *) 0 ; FXuint arg3 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDCPrint, 1); { Check_Type(argv[0], T_ARRAY);
        arg2 = new FXPoint[RARRAY(argv[0])->len]; arg3 = static_cast<FXuint>( RARRAY(argv[0])->len );
        for (FXuint i = 0; i < arg3; i++) { FXPoint *pPoint; Data_Get_Struct(rb_ary_entry(argv[0], i), FXPoint, pPoint);
            arg2[i] = *pPoint; }  }  FXDCPrint_fillConcavePolygon(arg1,(FXPoint const *)arg2,arg3); { delete [] arg2; } 
    return Qnil; }
static VALUE _wrap_FXDCPrint_fillComplexPolygon(int argc, VALUE *argv, VALUE self) { FXDCPrint *arg1 = (FXDCPrint *) 0 ;
    FXPoint *arg2 = (FXPoint *) 0 ; FXuint arg3 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDCPrint, 1); { Check_Type(argv[0], T_ARRAY);
        arg2 = new FXPoint[RARRAY(argv[0])->len]; arg3 = static_cast<FXuint>( RARRAY(argv[0])->len );
        for (FXuint i = 0; i < arg3; i++) { FXPoint *pPoint; Data_Get_Struct(rb_ary_entry(argv[0], i), FXPoint, pPoint);
            arg2[i] = *pPoint; }  }  FXDCPrint_fillComplexPolygon(arg1,(FXPoint const *)arg2,arg3); { delete [] arg2; } 
    return Qnil; }
static VALUE _wrap_FXDCPrint_fillPolygonRel(int argc, VALUE *argv, VALUE self) { FXDCPrint *arg1 = (FXDCPrint *) 0 ;
    FXPoint *arg2 = (FXPoint *) 0 ; FXuint arg3 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDCPrint, 1); { Check_Type(argv[0], T_ARRAY);
        arg2 = new FXPoint[RARRAY(argv[0])->len]; arg3 = static_cast<FXuint>( RARRAY(argv[0])->len );
        for (FXuint i = 0; i < arg3; i++) { FXPoint *pPoint; Data_Get_Struct(rb_ary_entry(argv[0], i), FXPoint, pPoint);
            arg2[i] = *pPoint; }  }  FXDCPrint_fillPolygonRel(arg1,(FXPoint const *)arg2,arg3); { delete [] arg2; } 
    return Qnil; }
static VALUE _wrap_FXDCPrint_fillConcavePolygonRel(int argc, VALUE *argv, VALUE self) { FXDCPrint *arg1 = (FXDCPrint *) 0 ;
    FXPoint *arg2 = (FXPoint *) 0 ; FXuint arg3 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDCPrint, 1); { Check_Type(argv[0], T_ARRAY);
        arg2 = new FXPoint[RARRAY(argv[0])->len]; arg3 = static_cast<FXuint>( RARRAY(argv[0])->len );
        for (FXuint i = 0; i < arg3; i++) { FXPoint *pPoint; Data_Get_Struct(rb_ary_entry(argv[0], i), FXPoint, pPoint);
            arg2[i] = *pPoint; }  }  FXDCPrint_fillConcavePolygonRel(arg1,(FXPoint const *)arg2,arg3); { delete [] arg2; } 
    return Qnil; }
static VALUE _wrap_FXDCPrint_fillComplexPolygonRel(int argc, VALUE *argv, VALUE self) { FXDCPrint *arg1 = (FXDCPrint *) 0 ;
    FXPoint *arg2 = (FXPoint *) 0 ; FXuint arg3 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDCPrint, 1); { Check_Type(argv[0], T_ARRAY);
        arg2 = new FXPoint[RARRAY(argv[0])->len]; arg3 = static_cast<FXuint>( RARRAY(argv[0])->len );
        for (FXuint i = 0; i < arg3; i++) { FXPoint *pPoint; Data_Get_Struct(rb_ary_entry(argv[0], i), FXPoint, pPoint);
            arg2[i] = *pPoint; }  }  FXDCPrint_fillComplexPolygonRel(arg1,(FXPoint const *)arg2,arg3); { delete [] arg2; } 
    return Qnil; }
static VALUE _wrap_FXDCPrint_drawHashBox(int argc, VALUE *argv, VALUE self) { FXDCPrint *arg1 = (FXDCPrint *) 0 ; FXint arg2 ;
    FXint arg3 ; FXint arg4 ; FXint arg5 ; FXint arg6 = (FXint) 1 ; if ((argc < 4) || (argc > 5))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDCPrint, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    arg4 = NUM2INT(argv[2]); arg5 = NUM2INT(argv[3]); if (argc > 4) { arg6 = NUM2INT(argv[4]); } 
    FXDCPrint_drawHashBox(arg1,arg2,arg3,arg4,arg5,arg6); return Qnil; }
static VALUE _wrap_FXDCPrint_drawFocusRectangle(int argc, VALUE *argv, VALUE self) { FXDCPrint *arg1 = (FXDCPrint *) 0 ;
    FXint arg2 ; FXint arg3 ; FXint arg4 ; FXint arg5 ; if ((argc < 4) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDCPrint, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    arg4 = NUM2INT(argv[2]); arg5 = NUM2INT(argv[3]); FXDCPrint_drawFocusRectangle(arg1,arg2,arg3,arg4,arg5); return Qnil; }
static VALUE _wrap_FXDCPrint_drawArea(int argc, VALUE *argv, VALUE self) { FXDCPrint *arg1 = (FXDCPrint *) 0 ;
    FXDrawable *arg2 = (FXDrawable *) 0 ; FXint arg3 ; FXint arg4 ; FXint arg5 ; FXint arg6 ; FXint arg7 ; FXint arg8 ;
    if ((argc < 7) || (argc > 7)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 7)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDCPrint, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXDrawable, 1); arg3 = NUM2INT(argv[1]); arg4 = NUM2INT(argv[2]);
    arg5 = NUM2INT(argv[3]); arg6 = NUM2INT(argv[4]); arg7 = NUM2INT(argv[5]); arg8 = NUM2INT(argv[6]);
    FXDCPrint_drawArea(arg1,(FXDrawable const *)arg2,arg3,arg4,arg5,arg6,arg7,arg8); return Qnil; }
static VALUE _wrap_FXDCPrint_drawImage(int argc, VALUE *argv, VALUE self) { FXDCPrint *arg1 = (FXDCPrint *) 0 ;
    FXImage *arg2 = (FXImage *) 0 ; FXint arg3 ; FXint arg4 ; if ((argc < 3) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDCPrint, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXImage, 1); arg3 = NUM2INT(argv[1]); arg4 = NUM2INT(argv[2]);
    FXDCPrint_drawImage(arg1,(FXImage const *)arg2,arg3,arg4); return Qnil; }
static VALUE _wrap_FXDCPrint_drawBitmap(int argc, VALUE *argv, VALUE self) { FXDCPrint *arg1 = (FXDCPrint *) 0 ;
    FXBitmap *arg2 = (FXBitmap *) 0 ; FXint arg3 ; FXint arg4 ; if ((argc < 3) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDCPrint, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXBitmap, 1); arg3 = NUM2INT(argv[1]); arg4 = NUM2INT(argv[2]);
    FXDCPrint_drawBitmap(arg1,(FXBitmap const *)arg2,arg3,arg4); return Qnil; }
static VALUE _wrap_FXDCPrint_drawIcon(int argc, VALUE *argv, VALUE self) { FXDCPrint *arg1 = (FXDCPrint *) 0 ;
    FXIcon *arg2 = (FXIcon *) 0 ; FXint arg3 ; FXint arg4 ; if ((argc < 3) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDCPrint, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXIcon, 1); arg3 = NUM2INT(argv[1]); arg4 = NUM2INT(argv[2]);
    FXDCPrint_drawIcon(arg1,(FXIcon const *)arg2,arg3,arg4); return Qnil; }
static VALUE _wrap_FXDCPrint_drawIconShaded(int argc, VALUE *argv, VALUE self) { FXDCPrint *arg1 = (FXDCPrint *) 0 ;
    FXIcon *arg2 = (FXIcon *) 0 ; FXint arg3 ; FXint arg4 ; if ((argc < 3) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDCPrint, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXIcon, 1); arg3 = NUM2INT(argv[1]); arg4 = NUM2INT(argv[2]);
    FXDCPrint_drawIconShaded(arg1,(FXIcon const *)arg2,arg3,arg4); return Qnil; }
static VALUE _wrap_FXDCPrint_drawIconSunken(int argc, VALUE *argv, VALUE self) { FXDCPrint *arg1 = (FXDCPrint *) 0 ;
    FXIcon *arg2 = (FXIcon *) 0 ; FXint arg3 ; FXint arg4 ; if ((argc < 3) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDCPrint, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXIcon, 1); arg3 = NUM2INT(argv[1]); arg4 = NUM2INT(argv[2]);
    FXDCPrint_drawIconSunken(arg1,(FXIcon const *)arg2,arg3,arg4); return Qnil; }
static VALUE _wrap_FXDCPrint_drawText(int argc, VALUE *argv, VALUE self) { FXDCPrint *arg1 = (FXDCPrint *) 0 ; FXint arg2 ;
    FXint arg3 ; FXchar *arg4 ; FXuint arg5 ; if ((argc < 3) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDCPrint, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]); {
        Check_Type(argv[2], T_STRING); arg4 = STR2CSTR(argv[2]); arg5 = RSTRING(argv[2])->len; } 
    FXDCPrint_drawText(arg1,arg2,arg3,(FXchar const *)arg4,arg5); return Qnil; }
static VALUE _wrap_FXDCPrint_drawImageText(int argc, VALUE *argv, VALUE self) { FXDCPrint *arg1 = (FXDCPrint *) 0 ; FXint arg2 ;
    FXint arg3 ; FXchar *arg4 ; FXuint arg5 ; if ((argc < 3) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDCPrint, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]); {
        Check_Type(argv[2], T_STRING); arg4 = STR2CSTR(argv[2]); arg5 = RSTRING(argv[2])->len; } 
    FXDCPrint_drawImageText(arg1,arg2,arg3,(FXchar const *)arg4,arg5); return Qnil; }
static VALUE _wrap_FXDCPrint_setForeground(int argc, VALUE *argv, VALUE self) { FXDCPrint *arg1 = (FXDCPrint *) 0 ;
    FXColor arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDCPrint, 1); arg2 = to_FXColor(argv[0]);
    FXDCPrint_setForeground(arg1,arg2); return Qnil; }
static VALUE _wrap_FXDCPrint_setBackground(int argc, VALUE *argv, VALUE self) { FXDCPrint *arg1 = (FXDCPrint *) 0 ;
    FXColor arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDCPrint, 1); arg2 = to_FXColor(argv[0]);
    FXDCPrint_setBackground(arg1,arg2); return Qnil; }
static VALUE _wrap_FXDCPrint_setDashes(int argc, VALUE *argv, VALUE self) { FXDCPrint *arg1 = (FXDCPrint *) 0 ; FXuint arg2 ;
    FXchar *arg3 ; FXuint arg4 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDCPrint, 1); arg2 = NUM2UINT(argv[0]); { Check_Type(argv[1], T_ARRAY);
        arg3 = new FXchar[RARRAY(argv[1])->len]; arg4 = static_cast<FXuint>( RARRAY(argv[1])->len );
        for (FXuint i = 0; i < arg4; i++) { arg3[i] = NUM2INT(rb_ary_entry(argv[1], i)); }  } 
    FXDCPrint_setDashes(arg1,arg2,(FXchar const *)arg3,arg4); { delete [] arg3; }  return Qnil; }
static VALUE _wrap_FXDCPrint_setLineWidth(int argc, VALUE *argv, VALUE self) { FXDCPrint *arg1 = (FXDCPrint *) 0 ;
    FXuint arg2 = (FXuint) 0 ; if ((argc < 0) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDCPrint, 1); if (argc > 0) { arg2 = NUM2UINT(argv[0]); } 
    FXDCPrint_setLineWidth(arg1,arg2); return Qnil; }
static VALUE _wrap_FXDCPrint_setLineCap(int argc, VALUE *argv, VALUE self) { FXDCPrint *arg1 = (FXDCPrint *) 0 ;
    int arg2 = (int) CAP_BUTT ; if ((argc < 0) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDCPrint, 1); if (argc > 0) { arg2 = (int) NUM2INT(argv[0]); } 
    FXDCPrint_setLineCap(arg1,(FXCapStyle )arg2); return Qnil; }
static VALUE _wrap_FXDCPrint_setLineJoin(int argc, VALUE *argv, VALUE self) { FXDCPrint *arg1 = (FXDCPrint *) 0 ;
    int arg2 = (int) JOIN_MITER ; if ((argc < 0) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDCPrint, 1); if (argc > 0) { arg2 = (int) NUM2INT(argv[0]); } 
    FXDCPrint_setLineJoin(arg1,(FXJoinStyle )arg2); return Qnil; }
static VALUE _wrap_FXDCPrint_setLineStyle(int argc, VALUE *argv, VALUE self) { FXDCPrint *arg1 = (FXDCPrint *) 0 ;
    int arg2 = (int) LINE_SOLID ; if ((argc < 0) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDCPrint, 1); if (argc > 0) { arg2 = (int) NUM2INT(argv[0]); } 
    FXDCPrint_setLineStyle(arg1,(FXLineStyle )arg2); return Qnil; }
static VALUE _wrap_FXDCPrint_setFillStyle(int argc, VALUE *argv, VALUE self) { FXDCPrint *arg1 = (FXDCPrint *) 0 ;
    int arg2 = (int) FILL_SOLID ; if ((argc < 0) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDCPrint, 1); if (argc > 0) { arg2 = (int) NUM2INT(argv[0]); } 
    FXDCPrint_setFillStyle(arg1,(FXFillStyle )arg2); return Qnil; }
static VALUE _wrap_FXDCPrint_setFillRule(int argc, VALUE *argv, VALUE self) { FXDCPrint *arg1 = (FXDCPrint *) 0 ;
    int arg2 = (int) RULE_EVEN_ODD ; if ((argc < 0) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDCPrint, 1); if (argc > 0) { arg2 = (int) NUM2INT(argv[0]); } 
    FXDCPrint_setFillRule(arg1,(FXFillRule )arg2); return Qnil; }
static VALUE _wrap_FXDCPrint_setFunction(int argc, VALUE *argv, VALUE self) { FXDCPrint *arg1 = (FXDCPrint *) 0 ;
    int arg2 = (int) BLT_SRC ; if ((argc < 0) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDCPrint, 1); if (argc > 0) { arg2 = (int) NUM2INT(argv[0]); } 
    FXDCPrint_setFunction(arg1,(FXFunction )arg2); return Qnil; }
static VALUE _wrap_FXDCPrint_setTile(int argc, VALUE *argv, VALUE self) { FXDCPrint *arg1 = (FXDCPrint *) 0 ;
    FXImage *arg2 = (FXImage *) 0 ; FXint arg3 = (FXint) 0 ; FXint arg4 = (FXint) 0 ; if ((argc < 1) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDCPrint, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXImage, 1); if (argc > 1) { arg3 = NUM2INT(argv[1]); } 
    if (argc > 2) { arg4 = NUM2INT(argv[2]); }  FXDCPrint_setTile(arg1,arg2,arg3,arg4); return Qnil; }
static VALUE _wrap_FXDCPrint_setStipple__SWIG_0(int argc, VALUE *argv, VALUE self) { FXDCPrint *arg1 = (FXDCPrint *) 0 ;
    FXBitmap *arg2 = (FXBitmap *) 0 ; FXint arg3 = (FXint) 0 ; FXint arg4 = (FXint) 0 ; if ((argc < 1) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDCPrint, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXBitmap, 1); if (argc > 1) { arg3 = NUM2INT(argv[1]); } 
    if (argc > 2) { arg4 = NUM2INT(argv[2]); }  FXDCPrint_setStipple(arg1,arg2,arg3,arg4); return Qnil; }
static VALUE _wrap_FXDCPrint_setStipple__SWIG_1(int argc, VALUE *argv, VALUE self) { FXDCPrint *arg1 = (FXDCPrint *) 0 ;
    int arg2 ; FXint arg3 = (FXint) 0 ; FXint arg4 = (FXint) 0 ; if ((argc < 1) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDCPrint, 1); arg2 = (int) NUM2INT(argv[0]); if (argc > 1) {
        arg3 = NUM2INT(argv[1]); }  if (argc > 2) { arg4 = NUM2INT(argv[2]); } 
    FXDCPrint_setStipple(arg1,(FXStipplePattern )arg2,arg3,arg4); return Qnil; }
static VALUE _wrap_FXDCPrint_setStipple(int nargs, VALUE *args, VALUE self) { int argc; VALUE argv[5]; int ii; argc = nargs + 1;
    argv[0] = self; for (ii = 1; (ii < argc) && (ii < 4); ii++) { argv[ii] = args[ii-1]; }  if ((argc >= 2) && (argc <= 4)) {
        int _v; { void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXDCPrint, 0) != -1)) ? 1 : 0; }
         if (_v) { { void *ptr;
                _v = (NIL_P(argv[1]) || (TYPE(argv[1]) == T_DATA && SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_FXBitmap, 0) != -1)) ? 1 : 0; }
             if (_v) { if (argc <= 2) { return _wrap_FXDCPrint_setStipple__SWIG_0(nargs, args, self);}  {
                    _v = ((TYPE(argv[2]) == T_FIXNUM) || (TYPE(argv[2]) == T_BIGNUM)) ? 1 : 0; }  if (_v) { if (argc <= 3) {
                        return _wrap_FXDCPrint_setStipple__SWIG_0(nargs, args, self);}  {
                        _v = ((TYPE(argv[3]) == T_FIXNUM) || (TYPE(argv[3]) == T_BIGNUM)) ? 1 : 0; }  if (_v) {
                        return _wrap_FXDCPrint_setStipple__SWIG_0(nargs, args, self);}  }  }  }  } 
    if ((argc >= 2) && (argc <= 4)) { int _v; { void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXDCPrint, 0) != -1)) ? 1 : 0; }
         if (_v) { { _v = ((TYPE(argv[1]) == T_FIXNUM) || (TYPE(argv[1]) == T_BIGNUM)) ? 1 : 0; }  if (_v) { if (argc <= 2) {
                    return _wrap_FXDCPrint_setStipple__SWIG_1(nargs, args, self);}  {
                    _v = ((TYPE(argv[2]) == T_FIXNUM) || (TYPE(argv[2]) == T_BIGNUM)) ? 1 : 0; }  if (_v) { if (argc <= 3) {
                        return _wrap_FXDCPrint_setStipple__SWIG_1(nargs, args, self);}  {
                        _v = ((TYPE(argv[3]) == T_FIXNUM) || (TYPE(argv[3]) == T_BIGNUM)) ? 1 : 0; }  if (_v) {
                        return _wrap_FXDCPrint_setStipple__SWIG_1(nargs, args, self);}  }  }  }  } 
    rb_raise(rb_eArgError, "No matching function for overloaded 'FXDCPrint_setStipple'"); return Qnil; }
static VALUE _wrap_FXDCPrint_setClipRegion(int argc, VALUE *argv, VALUE self) { FXDCPrint *arg1 = (FXDCPrint *) 0 ;
    FXRegion *arg2 = 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDCPrint, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXRegion, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXDCPrint_setClipRegion(arg1,(FXRegion const &)*arg2); return Qnil; }
static VALUE _wrap_FXDCPrint_setClipRectangle__SWIG_0(int argc, VALUE *argv, VALUE self) { FXDCPrint *arg1 = (FXDCPrint *) 0 ;
    FXint arg2 ; FXint arg3 ; FXint arg4 ; FXint arg5 ; if ((argc < 4) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDCPrint, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    arg4 = NUM2INT(argv[2]); arg5 = NUM2INT(argv[3]); FXDCPrint_setClipRectangle(arg1,arg2,arg3,arg4,arg5); return Qnil; }
static VALUE _wrap_FXDCPrint_setClipRectangle__SWIG_1(int argc, VALUE *argv, VALUE self) { FXDCPrint *arg1 = (FXDCPrint *) 0 ;
    FXRectangle *arg2 = 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDCPrint, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXRectangle, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXDCPrint_setClipRectangle(arg1,(FXRectangle const &)*arg2); return Qnil; }
static VALUE _wrap_FXDCPrint_setClipRectangle(int nargs, VALUE *args, VALUE self) { int argc; VALUE argv[6]; int ii;
    argc = nargs + 1; argv[0] = self; for (ii = 1; (ii < argc) && (ii < 5); ii++) { argv[ii] = args[ii-1]; }  if (argc == 2) {
        int _v; { void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXDCPrint, 0) != -1)) ? 1 : 0; }
         if (_v) { { void *ptr;
                _v = (NIL_P(argv[1]) || (TYPE(argv[1]) == T_DATA && SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_FXRectangle, 0) != -1)) ? 1 : 0; }
             if (_v) { return _wrap_FXDCPrint_setClipRectangle__SWIG_1(nargs, args, self);}  }  }  if (argc == 5) { int _v; {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXDCPrint, 0) != -1)) ? 1 : 0; }
         if (_v) { { _v = ((TYPE(argv[1]) == T_FIXNUM) || (TYPE(argv[1]) == T_BIGNUM)) ? 1 : 0; }  if (_v) { {
                    _v = ((TYPE(argv[2]) == T_FIXNUM) || (TYPE(argv[2]) == T_BIGNUM)) ? 1 : 0; }  if (_v) { {
                        _v = ((TYPE(argv[3]) == T_FIXNUM) || (TYPE(argv[3]) == T_BIGNUM)) ? 1 : 0; }  if (_v) { {
                            _v = ((TYPE(argv[4]) == T_FIXNUM) || (TYPE(argv[4]) == T_BIGNUM)) ? 1 : 0; }  if (_v) {
                            return _wrap_FXDCPrint_setClipRectangle__SWIG_0(nargs, args, self);}  }  }  }  }  } 
    rb_raise(rb_eArgError, "No matching function for overloaded 'FXDCPrint_setClipRectangle'"); return Qnil; }
static VALUE _wrap_FXDCPrint_clearClipRectangle(int argc, VALUE *argv, VALUE self) { FXDCPrint *arg1 = (FXDCPrint *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDCPrint, 1); FXDCPrint_clearClipRectangle(arg1); return Qnil; }
static VALUE _wrap_FXDCPrint_setClipMask(int argc, VALUE *argv, VALUE self) { FXDCPrint *arg1 = (FXDCPrint *) 0 ;
    FXBitmap *arg2 = (FXBitmap *) 0 ; FXint arg3 = (FXint) 0 ; FXint arg4 = (FXint) 0 ; if ((argc < 1) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDCPrint, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXBitmap, 1); if (argc > 1) { arg3 = NUM2INT(argv[1]); } 
    if (argc > 2) { arg4 = NUM2INT(argv[2]); }  FXDCPrint_setClipMask(arg1,arg2,arg3,arg4); return Qnil; }
static VALUE _wrap_FXDCPrint_clearClipMask(int argc, VALUE *argv, VALUE self) { FXDCPrint *arg1 = (FXDCPrint *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDCPrint, 1); FXDCPrint_clearClipMask(arg1); return Qnil; }
static VALUE _wrap_FXDCPrint_setFont(int argc, VALUE *argv, VALUE self) { FXDCPrint *arg1 = (FXDCPrint *) 0 ;
    FXFont *arg2 = (FXFont *) 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDCPrint, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXFont, 1); FXDCPrint_setFont(arg1,arg2); return Qnil; }
static VALUE _wrap_FXDCPrint_clipChildren(int argc, VALUE *argv, VALUE self) { FXDCPrint *arg1 = (FXDCPrint *) 0 ; FXbool arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDCPrint, 1); arg2 = to_FXbool(argv[0]);
    FXDCPrint_clipChildren(arg1,arg2); return Qnil; }

/* -------- TYPE CONVERSION AND EQUIVALENCE RULES (BEGIN) -------- */

static void *_p_FXCompositeTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *) ((FXComposite *) x));
}
static void *_p_FXShellTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *) ((FXShell *) x));
}
static void *_p_FXWindowTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *)  ((FXWindow *) x));
}
static void *_p_FXRootWindowTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *) ((FXRootWindow *) x));
}
static void *_p_FXPopupTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXShell *) ((FXPopup *) x));
}
static void *_p_FXTopWindowTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXShell *) ((FXTopWindow *) x));
}
static void *_p_FXMainWindowTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXShell *)(FXTopWindow *) ((FXMainWindow *) x));
}
static void *_p_FXFrameTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *) ((FXFrame *) x));
}
static void *_p_FXDCPrintTo_p_FXDC(void *x) {
    return (void *)((FXDC *)  ((FXDCPrint *) x));
}
static void *_p_FXDCWindowTo_p_FXDC(void *x) {
    return (void *)((FXDC *)  ((FXDCWindow *) x));
}
static swig_type_info _swigt__p_FXDCWindow[] = {{"_p_FXDCWindow", 0, "FXDCWindow *", 0, 0, 0, 0},{"_p_FXDCWindow", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXDC[] = {{"_p_FXDC", 0, "FXDC *", 0, 0, 0, 0},{"_p_FXDCPrint", _p_FXDCPrintTo_p_FXDC, 0, 0, 0, 0, 0},{"_p_FXDC", 0, 0, 0, 0, 0, 0},{"_p_FXDCWindow", _p_FXDCWindowTo_p_FXDC, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXPrinter[] = {{"_p_FXPrinter", 0, "FXPrinter *", 0, 0, 0, 0},{"_p_FXPrinter", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXPSBounds[] = {{"_p_FXPSBounds", 0, "FXPSBounds *", 0, 0, 0, 0},{"_p_FXPSBounds", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXBitmap[] = {{"_p_FXBitmap", 0, "FXBitmap *", 0, 0, 0, 0},{"_p_FXBitmap", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXRectangle[] = {{"_p_FXRectangle", 0, "FXRectangle *", 0, 0, 0, 0},{"_p_FXRectangle", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXFont[] = {{"_p_FXFont", 0, "FXFont *", 0, 0, 0, 0},{"_p_FXFont", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXDrawable[] = {{"_p_FXDrawable", 0, "FXDrawable *", 0, 0, 0, 0},{"_p_FXComposite", _p_FXCompositeTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXShell", _p_FXShellTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXWindow", _p_FXWindowTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXRootWindow", _p_FXRootWindowTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXPopup", _p_FXPopupTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXTopWindow", _p_FXTopWindowTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXMainWindow", _p_FXMainWindowTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXDrawable", 0, 0, 0, 0, 0, 0},{"_p_FXFrame", _p_FXFrameTo_p_FXDrawable, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXString[] = {{"_p_FXString", 0, "FXString *", 0, 0, 0, 0},{"_p_FXString", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXDCPrint[] = {{"_p_FXDCPrint", 0, "FXDCPrint *", 0, 0, 0, 0},{"_p_FXDCPrint", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXIcon[] = {{"_p_FXIcon", 0, "FXIcon *", 0, 0, 0, 0},{"_p_FXIcon", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXRegion[] = {{"_p_FXRegion", 0, "FXRegion *", 0, 0, 0, 0},{"_p_FXRegion", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXArc[] = {{"_p_FXArc", 0, "FXArc *", 0, 0, 0, 0},{"_p_FXArc", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXApp[] = {{"_p_FXApp", 0, "FXApp *", 0, 0, 0, 0},{"_p_FXApp", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXEvent[] = {{"_p_FXEvent", 0, "FXEvent *", 0, 0, 0, 0},{"_p_FXEvent", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXImage[] = {{"_p_FXImage", 0, "FXImage *", 0, 0, 0, 0},{"_p_FXImage", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXSegment[] = {{"_p_FXSegment", 0, "FXSegment *", 0, 0, 0, 0},{"_p_FXSegment", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};

static swig_type_info *swig_types_initial[] = {
_swigt__p_FXDCWindow, 
_swigt__p_FXDC, 
_swigt__p_FXPrinter, 
_swigt__p_FXPSBounds, 
_swigt__p_FXBitmap, 
_swigt__p_FXRectangle, 
_swigt__p_FXFont, 
_swigt__p_FXDrawable, 
_swigt__p_FXString, 
_swigt__p_FXDCPrint, 
_swigt__p_FXIcon, 
_swigt__p_FXRegion, 
_swigt__p_FXArc, 
_swigt__p_FXApp, 
_swigt__p_FXEvent, 
_swigt__p_FXImage, 
_swigt__p_FXSegment, 
0
};


/* -------- TYPE CONVERSION AND EQUIVALENCE RULES (END) -------- */


#ifdef __cplusplus
extern "C"
#endif
SWIGEXPORT(void) Init_dc(void) {
    int i;
    
    SWIG_InitRuntime();
    
    for (i = 0; swig_types_initial[i]; i++) {
        swig_types[i] = SWIG_TypeRegister(swig_types_initial[i]);
        SWIG_define_class(swig_types[i]);
    }
    
    rb_define_const(mFox,"BLT_CLR", INT2NUM(BLT_CLR));
    rb_define_const(mFox,"BLT_SRC_AND_DST", INT2NUM(BLT_SRC_AND_DST));
    rb_define_const(mFox,"BLT_SRC_AND_NOT_DST", INT2NUM(BLT_SRC_AND_NOT_DST));
    rb_define_const(mFox,"BLT_SRC", INT2NUM(BLT_SRC));
    rb_define_const(mFox,"BLT_NOT_SRC_AND_DST", INT2NUM(BLT_NOT_SRC_AND_DST));
    rb_define_const(mFox,"BLT_DST", INT2NUM(BLT_DST));
    rb_define_const(mFox,"BLT_SRC_XOR_DST", INT2NUM(BLT_SRC_XOR_DST));
    rb_define_const(mFox,"BLT_SRC_OR_DST", INT2NUM(BLT_SRC_OR_DST));
    rb_define_const(mFox,"BLT_NOT_SRC_AND_NOT_DST", INT2NUM(BLT_NOT_SRC_AND_NOT_DST));
    rb_define_const(mFox,"BLT_NOT_SRC_XOR_DST", INT2NUM(BLT_NOT_SRC_XOR_DST));
    rb_define_const(mFox,"BLT_NOT_DST", INT2NUM(BLT_NOT_DST));
    rb_define_const(mFox,"BLT_SRC_OR_NOT_DST", INT2NUM(BLT_SRC_OR_NOT_DST));
    rb_define_const(mFox,"BLT_NOT_SRC", INT2NUM(BLT_NOT_SRC));
    rb_define_const(mFox,"BLT_NOT_SRC_OR_DST", INT2NUM(BLT_NOT_SRC_OR_DST));
    rb_define_const(mFox,"BLT_NOT_SRC_OR_NOT_DST", INT2NUM(BLT_NOT_SRC_OR_NOT_DST));
    rb_define_const(mFox,"BLT_SET", INT2NUM(BLT_SET));
    rb_define_const(mFox,"LINE_SOLID", INT2NUM(LINE_SOLID));
    rb_define_const(mFox,"LINE_ONOFF_DASH", INT2NUM(LINE_ONOFF_DASH));
    rb_define_const(mFox,"LINE_DOUBLE_DASH", INT2NUM(LINE_DOUBLE_DASH));
    rb_define_const(mFox,"CAP_NOT_LAST", INT2NUM(CAP_NOT_LAST));
    rb_define_const(mFox,"CAP_BUTT", INT2NUM(CAP_BUTT));
    rb_define_const(mFox,"CAP_ROUND", INT2NUM(CAP_ROUND));
    rb_define_const(mFox,"CAP_PROJECTING", INT2NUM(CAP_PROJECTING));
    rb_define_const(mFox,"JOIN_MITER", INT2NUM(JOIN_MITER));
    rb_define_const(mFox,"JOIN_ROUND", INT2NUM(JOIN_ROUND));
    rb_define_const(mFox,"JOIN_BEVEL", INT2NUM(JOIN_BEVEL));
    rb_define_const(mFox,"FILL_SOLID", INT2NUM(FILL_SOLID));
    rb_define_const(mFox,"FILL_TILED", INT2NUM(FILL_TILED));
    rb_define_const(mFox,"FILL_STIPPLED", INT2NUM(FILL_STIPPLED));
    rb_define_const(mFox,"FILL_OPAQUESTIPPLED", INT2NUM(FILL_OPAQUESTIPPLED));
    rb_define_const(mFox,"RULE_EVEN_ODD", INT2NUM(RULE_EVEN_ODD));
    rb_define_const(mFox,"RULE_WINDING", INT2NUM(RULE_WINDING));
    rb_define_const(mFox,"STIPPLE_0", INT2NUM(STIPPLE_0));
    rb_define_const(mFox,"STIPPLE_NONE", INT2NUM(STIPPLE_NONE));
    rb_define_const(mFox,"STIPPLE_BLACK", INT2NUM(STIPPLE_BLACK));
    rb_define_const(mFox,"STIPPLE_1", INT2NUM(STIPPLE_1));
    rb_define_const(mFox,"STIPPLE_2", INT2NUM(STIPPLE_2));
    rb_define_const(mFox,"STIPPLE_3", INT2NUM(STIPPLE_3));
    rb_define_const(mFox,"STIPPLE_4", INT2NUM(STIPPLE_4));
    rb_define_const(mFox,"STIPPLE_5", INT2NUM(STIPPLE_5));
    rb_define_const(mFox,"STIPPLE_6", INT2NUM(STIPPLE_6));
    rb_define_const(mFox,"STIPPLE_7", INT2NUM(STIPPLE_7));
    rb_define_const(mFox,"STIPPLE_8", INT2NUM(STIPPLE_8));
    rb_define_const(mFox,"STIPPLE_GRAY", INT2NUM(STIPPLE_GRAY));
    rb_define_const(mFox,"STIPPLE_9", INT2NUM(STIPPLE_9));
    rb_define_const(mFox,"STIPPLE_10", INT2NUM(STIPPLE_10));
    rb_define_const(mFox,"STIPPLE_11", INT2NUM(STIPPLE_11));
    rb_define_const(mFox,"STIPPLE_12", INT2NUM(STIPPLE_12));
    rb_define_const(mFox,"STIPPLE_13", INT2NUM(STIPPLE_13));
    rb_define_const(mFox,"STIPPLE_14", INT2NUM(STIPPLE_14));
    rb_define_const(mFox,"STIPPLE_15", INT2NUM(STIPPLE_15));
    rb_define_const(mFox,"STIPPLE_16", INT2NUM(STIPPLE_16));
    rb_define_const(mFox,"STIPPLE_WHITE", INT2NUM(STIPPLE_WHITE));
    rb_define_const(mFox,"STIPPLE_HORZ", INT2NUM(STIPPLE_HORZ));
    rb_define_const(mFox,"STIPPLE_VERT", INT2NUM(STIPPLE_VERT));
    rb_define_const(mFox,"STIPPLE_CROSS", INT2NUM(STIPPLE_CROSS));
    rb_define_const(mFox,"STIPPLE_DIAG", INT2NUM(STIPPLE_DIAG));
    rb_define_const(mFox,"STIPPLE_REVDIAG", INT2NUM(STIPPLE_REVDIAG));
    rb_define_const(mFox,"STIPPLE_CROSSDIAG", INT2NUM(STIPPLE_CROSSDIAG));
    
    cFXSegment.klass = rb_define_class_under(mFox, "FXSegment", rb_cObject);
    SWIG_TypeClientData(SWIGTYPE_p_FXSegment, (void *) &cFXSegment);
    rb_define_alloc_func(cFXSegment.klass, _wrap_FXSegment_allocate);
    rb_define_method(cFXSegment.klass, "initialize", VALUEFUNC(_wrap_new_FXSegment), -1);
    rb_define_method(cFXSegment.klass, "x1=", VALUEFUNC(_wrap_FXSegment_x1_set), -1);
    rb_define_method(cFXSegment.klass, "x1", VALUEFUNC(_wrap_FXSegment_x1_get), -1);
    rb_define_method(cFXSegment.klass, "y1=", VALUEFUNC(_wrap_FXSegment_y1_set), -1);
    rb_define_method(cFXSegment.klass, "y1", VALUEFUNC(_wrap_FXSegment_y1_get), -1);
    rb_define_method(cFXSegment.klass, "x2=", VALUEFUNC(_wrap_FXSegment_x2_set), -1);
    rb_define_method(cFXSegment.klass, "x2", VALUEFUNC(_wrap_FXSegment_x2_get), -1);
    rb_define_method(cFXSegment.klass, "y2=", VALUEFUNC(_wrap_FXSegment_y2_set), -1);
    rb_define_method(cFXSegment.klass, "y2", VALUEFUNC(_wrap_FXSegment_y2_get), -1);
    cFXSegment.mark = 0;
    cFXSegment.destroy = (void (*)(void *)) free_FXSegment;
    
    cFXArc.klass = rb_define_class_under(mFox, "FXArc", rb_cObject);
    SWIG_TypeClientData(SWIGTYPE_p_FXArc, (void *) &cFXArc);
    rb_define_alloc_func(cFXArc.klass, _wrap_FXArc_allocate);
    rb_define_method(cFXArc.klass, "initialize", VALUEFUNC(_wrap_new_FXArc), -1);
    rb_define_method(cFXArc.klass, "x=", VALUEFUNC(_wrap_FXArc_x_set), -1);
    rb_define_method(cFXArc.klass, "x", VALUEFUNC(_wrap_FXArc_x_get), -1);
    rb_define_method(cFXArc.klass, "y=", VALUEFUNC(_wrap_FXArc_y_set), -1);
    rb_define_method(cFXArc.klass, "y", VALUEFUNC(_wrap_FXArc_y_get), -1);
    rb_define_method(cFXArc.klass, "w=", VALUEFUNC(_wrap_FXArc_w_set), -1);
    rb_define_method(cFXArc.klass, "w", VALUEFUNC(_wrap_FXArc_w_get), -1);
    rb_define_method(cFXArc.klass, "h=", VALUEFUNC(_wrap_FXArc_h_set), -1);
    rb_define_method(cFXArc.klass, "h", VALUEFUNC(_wrap_FXArc_h_get), -1);
    rb_define_method(cFXArc.klass, "a=", VALUEFUNC(_wrap_FXArc_a_set), -1);
    rb_define_method(cFXArc.klass, "a", VALUEFUNC(_wrap_FXArc_a_get), -1);
    rb_define_method(cFXArc.klass, "b=", VALUEFUNC(_wrap_FXArc_b_set), -1);
    rb_define_method(cFXArc.klass, "b", VALUEFUNC(_wrap_FXArc_b_get), -1);
    cFXArc.mark = 0;
    cFXArc.destroy = (void (*)(void *)) free_FXArc;
    
    cFXDC.klass = rb_define_class_under(mFox, "FXDC", rb_cObject);
    SWIG_TypeClientData(SWIGTYPE_p_FXDC, (void *) &cFXDC);
    rb_define_alloc_func(cFXDC.klass, _wrap_FXDC_allocate);
    rb_define_method(cFXDC.klass, "initialize", VALUEFUNC(_wrap_new_FXDC), -1);
    rb_define_method(cFXDC.klass, "getApp", VALUEFUNC(_wrap_FXDC_getApp), -1);
    rb_define_method(cFXDC.klass, "getForeground", VALUEFUNC(_wrap_FXDC_getForeground), -1);
    rb_define_method(cFXDC.klass, "getBackground", VALUEFUNC(_wrap_FXDC_getBackground), -1);
    rb_define_method(cFXDC.klass, "getDashPattern", VALUEFUNC(_wrap_FXDC_getDashPattern), -1);
    rb_define_method(cFXDC.klass, "getDashOffset", VALUEFUNC(_wrap_FXDC_getDashOffset), -1);
    rb_define_method(cFXDC.klass, "getLineWidth", VALUEFUNC(_wrap_FXDC_getLineWidth), -1);
    rb_define_method(cFXDC.klass, "getLineCap", VALUEFUNC(_wrap_FXDC_getLineCap), -1);
    rb_define_method(cFXDC.klass, "getLineJoin", VALUEFUNC(_wrap_FXDC_getLineJoin), -1);
    rb_define_method(cFXDC.klass, "getLineStyle", VALUEFUNC(_wrap_FXDC_getLineStyle), -1);
    rb_define_method(cFXDC.klass, "getFillStyle", VALUEFUNC(_wrap_FXDC_getFillStyle), -1);
    rb_define_method(cFXDC.klass, "getFillRule", VALUEFUNC(_wrap_FXDC_getFillRule), -1);
    rb_define_method(cFXDC.klass, "getFunction", VALUEFUNC(_wrap_FXDC_getFunction), -1);
    rb_define_method(cFXDC.klass, "getTile", VALUEFUNC(_wrap_FXDC_getTile), -1);
    rb_define_method(cFXDC.klass, "getStippleBitmap", VALUEFUNC(_wrap_FXDC_getStippleBitmap), -1);
    rb_define_method(cFXDC.klass, "getStipplePattern", VALUEFUNC(_wrap_FXDC_getStipplePattern), -1);
    rb_define_method(cFXDC.klass, "getClipRectangle", VALUEFUNC(_wrap_FXDC_getClipRectangle), -1);
    rb_define_method(cFXDC.klass, "getClipX", VALUEFUNC(_wrap_FXDC_getClipX), -1);
    rb_define_method(cFXDC.klass, "getClipY", VALUEFUNC(_wrap_FXDC_getClipY), -1);
    rb_define_method(cFXDC.klass, "getClipWidth", VALUEFUNC(_wrap_FXDC_getClipWidth), -1);
    rb_define_method(cFXDC.klass, "getClipHeight", VALUEFUNC(_wrap_FXDC_getClipHeight), -1);
    rb_define_method(cFXDC.klass, "getFont", VALUEFUNC(_wrap_FXDC_getFont), -1);
    rb_define_method(cFXDC.klass, "readPixel", VALUEFUNC(_wrap_FXDC_readPixel), -1);
    rb_define_method(cFXDC.klass, "drawPoint", VALUEFUNC(_wrap_FXDC_drawPoint), -1);
    rb_define_method(cFXDC.klass, "drawPoints", VALUEFUNC(_wrap_FXDC_drawPoints), -1);
    rb_define_method(cFXDC.klass, "drawPointsRel", VALUEFUNC(_wrap_FXDC_drawPointsRel), -1);
    rb_define_method(cFXDC.klass, "drawLine", VALUEFUNC(_wrap_FXDC_drawLine), -1);
    rb_define_method(cFXDC.klass, "drawLines", VALUEFUNC(_wrap_FXDC_drawLines), -1);
    rb_define_method(cFXDC.klass, "drawLinesRel", VALUEFUNC(_wrap_FXDC_drawLinesRel), -1);
    rb_define_method(cFXDC.klass, "drawLineSegments", VALUEFUNC(_wrap_FXDC_drawLineSegments), -1);
    rb_define_method(cFXDC.klass, "drawRectangle", VALUEFUNC(_wrap_FXDC_drawRectangle), -1);
    rb_define_method(cFXDC.klass, "drawRectangles", VALUEFUNC(_wrap_FXDC_drawRectangles), -1);
    rb_define_method(cFXDC.klass, "drawArc", VALUEFUNC(_wrap_FXDC_drawArc), -1);
    rb_define_method(cFXDC.klass, "drawArcs", VALUEFUNC(_wrap_FXDC_drawArcs), -1);
    rb_define_method(cFXDC.klass, "fillRectangle", VALUEFUNC(_wrap_FXDC_fillRectangle), -1);
    rb_define_method(cFXDC.klass, "fillRectangles", VALUEFUNC(_wrap_FXDC_fillRectangles), -1);
    rb_define_method(cFXDC.klass, "fillChord", VALUEFUNC(_wrap_FXDC_fillChord), -1);
    rb_define_method(cFXDC.klass, "fillChords", VALUEFUNC(_wrap_FXDC_fillChords), -1);
    rb_define_method(cFXDC.klass, "fillArc", VALUEFUNC(_wrap_FXDC_fillArc), -1);
    rb_define_method(cFXDC.klass, "fillArcs", VALUEFUNC(_wrap_FXDC_fillArcs), -1);
    rb_define_method(cFXDC.klass, "fillPolygon", VALUEFUNC(_wrap_FXDC_fillPolygon), -1);
    rb_define_method(cFXDC.klass, "fillConcavePolygon", VALUEFUNC(_wrap_FXDC_fillConcavePolygon), -1);
    rb_define_method(cFXDC.klass, "fillComplexPolygon", VALUEFUNC(_wrap_FXDC_fillComplexPolygon), -1);
    rb_define_method(cFXDC.klass, "fillPolygonRel", VALUEFUNC(_wrap_FXDC_fillPolygonRel), -1);
    rb_define_method(cFXDC.klass, "fillConcavePolygonRel", VALUEFUNC(_wrap_FXDC_fillConcavePolygonRel), -1);
    rb_define_method(cFXDC.klass, "fillComplexPolygonRel", VALUEFUNC(_wrap_FXDC_fillComplexPolygonRel), -1);
    rb_define_method(cFXDC.klass, "drawHashBox", VALUEFUNC(_wrap_FXDC_drawHashBox), -1);
    rb_define_method(cFXDC.klass, "drawFocusRectangle", VALUEFUNC(_wrap_FXDC_drawFocusRectangle), -1);
    rb_define_method(cFXDC.klass, "drawArea", VALUEFUNC(_wrap_FXDC_drawArea), -1);
    rb_define_method(cFXDC.klass, "drawImage", VALUEFUNC(_wrap_FXDC_drawImage), -1);
    rb_define_method(cFXDC.klass, "drawBitmap", VALUEFUNC(_wrap_FXDC_drawBitmap), -1);
    rb_define_method(cFXDC.klass, "drawIcon", VALUEFUNC(_wrap_FXDC_drawIcon), -1);
    rb_define_method(cFXDC.klass, "drawIconShaded", VALUEFUNC(_wrap_FXDC_drawIconShaded), -1);
    rb_define_method(cFXDC.klass, "drawIconSunken", VALUEFUNC(_wrap_FXDC_drawIconSunken), -1);
    rb_define_method(cFXDC.klass, "drawText", VALUEFUNC(_wrap_FXDC_drawText), -1);
    rb_define_method(cFXDC.klass, "drawImageText", VALUEFUNC(_wrap_FXDC_drawImageText), -1);
    rb_define_method(cFXDC.klass, "setForeground", VALUEFUNC(_wrap_FXDC_setForeground), -1);
    rb_define_method(cFXDC.klass, "setBackground", VALUEFUNC(_wrap_FXDC_setBackground), -1);
    rb_define_method(cFXDC.klass, "setDashes", VALUEFUNC(_wrap_FXDC_setDashes), -1);
    rb_define_method(cFXDC.klass, "setLineWidth", VALUEFUNC(_wrap_FXDC_setLineWidth), -1);
    rb_define_method(cFXDC.klass, "setLineCap", VALUEFUNC(_wrap_FXDC_setLineCap), -1);
    rb_define_method(cFXDC.klass, "setLineJoin", VALUEFUNC(_wrap_FXDC_setLineJoin), -1);
    rb_define_method(cFXDC.klass, "setLineStyle", VALUEFUNC(_wrap_FXDC_setLineStyle), -1);
    rb_define_method(cFXDC.klass, "setFillStyle", VALUEFUNC(_wrap_FXDC_setFillStyle), -1);
    rb_define_method(cFXDC.klass, "setFillRule", VALUEFUNC(_wrap_FXDC_setFillRule), -1);
    rb_define_method(cFXDC.klass, "setFunction", VALUEFUNC(_wrap_FXDC_setFunction), -1);
    rb_define_method(cFXDC.klass, "setTile", VALUEFUNC(_wrap_FXDC_setTile), -1);
    rb_define_method(cFXDC.klass, "setStipple", VALUEFUNC(_wrap_FXDC_setStipple), -1);
    rb_define_method(cFXDC.klass, "setClipRegion", VALUEFUNC(_wrap_FXDC_setClipRegion), -1);
    rb_define_method(cFXDC.klass, "setClipRectangle", VALUEFUNC(_wrap_FXDC_setClipRectangle), -1);
    rb_define_method(cFXDC.klass, "clearClipRectangle", VALUEFUNC(_wrap_FXDC_clearClipRectangle), -1);
    rb_define_method(cFXDC.klass, "setClipMask", VALUEFUNC(_wrap_FXDC_setClipMask), -1);
    rb_define_method(cFXDC.klass, "clearClipMask", VALUEFUNC(_wrap_FXDC_clearClipMask), -1);
    rb_define_method(cFXDC.klass, "setFont", VALUEFUNC(_wrap_FXDC_setFont), -1);
    rb_define_method(cFXDC.klass, "clipChildren", VALUEFUNC(_wrap_FXDC_clipChildren), -1);
    cFXDC.mark = (void (*)(void *)) FXRbDC::markfunc;
    cFXDC.destroy = (void (*)(void *)) FXRbUnregisterRubyObj;
    
    cFXDCWindow.klass = rb_define_class_under(mFox, "FXDCWindow", ((swig_class *) SWIGTYPE_p_FXDC->clientdata)->klass);
    SWIG_TypeClientData(SWIGTYPE_p_FXDCWindow, (void *) &cFXDCWindow);
    rb_define_alloc_func(cFXDCWindow.klass, _wrap_FXDCWindow_allocate);
    rb_define_method(cFXDCWindow.klass, "initialize", VALUEFUNC(_wrap_new_FXDCWindow), -1);
    rb_define_method(cFXDCWindow.klass, "begin", VALUEFUNC(_wrap_FXDCWindow_begin), -1);
    rb_define_method(cFXDCWindow.klass, "end", VALUEFUNC(_wrap_FXDCWindow_end), -1);
    rb_define_method(cFXDCWindow.klass, "readPixel", VALUEFUNC(_wrap_FXDCWindow_readPixel), -1);
    rb_define_method(cFXDCWindow.klass, "drawPoint", VALUEFUNC(_wrap_FXDCWindow_drawPoint), -1);
    rb_define_method(cFXDCWindow.klass, "drawPoints", VALUEFUNC(_wrap_FXDCWindow_drawPoints), -1);
    rb_define_method(cFXDCWindow.klass, "drawPointsRel", VALUEFUNC(_wrap_FXDCWindow_drawPointsRel), -1);
    rb_define_method(cFXDCWindow.klass, "drawLine", VALUEFUNC(_wrap_FXDCWindow_drawLine), -1);
    rb_define_method(cFXDCWindow.klass, "drawLines", VALUEFUNC(_wrap_FXDCWindow_drawLines), -1);
    rb_define_method(cFXDCWindow.klass, "drawLinesRel", VALUEFUNC(_wrap_FXDCWindow_drawLinesRel), -1);
    rb_define_method(cFXDCWindow.klass, "drawLineSegments", VALUEFUNC(_wrap_FXDCWindow_drawLineSegments), -1);
    rb_define_method(cFXDCWindow.klass, "drawRectangle", VALUEFUNC(_wrap_FXDCWindow_drawRectangle), -1);
    rb_define_method(cFXDCWindow.klass, "drawRectangles", VALUEFUNC(_wrap_FXDCWindow_drawRectangles), -1);
    rb_define_method(cFXDCWindow.klass, "drawArc", VALUEFUNC(_wrap_FXDCWindow_drawArc), -1);
    rb_define_method(cFXDCWindow.klass, "drawArcs", VALUEFUNC(_wrap_FXDCWindow_drawArcs), -1);
    rb_define_method(cFXDCWindow.klass, "fillRectangle", VALUEFUNC(_wrap_FXDCWindow_fillRectangle), -1);
    rb_define_method(cFXDCWindow.klass, "fillRectangles", VALUEFUNC(_wrap_FXDCWindow_fillRectangles), -1);
    rb_define_method(cFXDCWindow.klass, "fillChord", VALUEFUNC(_wrap_FXDCWindow_fillChord), -1);
    rb_define_method(cFXDCWindow.klass, "fillChords", VALUEFUNC(_wrap_FXDCWindow_fillChords), -1);
    rb_define_method(cFXDCWindow.klass, "fillArc", VALUEFUNC(_wrap_FXDCWindow_fillArc), -1);
    rb_define_method(cFXDCWindow.klass, "fillArcs", VALUEFUNC(_wrap_FXDCWindow_fillArcs), -1);
    rb_define_method(cFXDCWindow.klass, "fillPolygon", VALUEFUNC(_wrap_FXDCWindow_fillPolygon), -1);
    rb_define_method(cFXDCWindow.klass, "fillConcavePolygon", VALUEFUNC(_wrap_FXDCWindow_fillConcavePolygon), -1);
    rb_define_method(cFXDCWindow.klass, "fillComplexPolygon", VALUEFUNC(_wrap_FXDCWindow_fillComplexPolygon), -1);
    rb_define_method(cFXDCWindow.klass, "fillPolygonRel", VALUEFUNC(_wrap_FXDCWindow_fillPolygonRel), -1);
    rb_define_method(cFXDCWindow.klass, "fillConcavePolygonRel", VALUEFUNC(_wrap_FXDCWindow_fillConcavePolygonRel), -1);
    rb_define_method(cFXDCWindow.klass, "fillComplexPolygonRel", VALUEFUNC(_wrap_FXDCWindow_fillComplexPolygonRel), -1);
    rb_define_method(cFXDCWindow.klass, "drawHashBox", VALUEFUNC(_wrap_FXDCWindow_drawHashBox), -1);
    rb_define_method(cFXDCWindow.klass, "drawFocusRectangle", VALUEFUNC(_wrap_FXDCWindow_drawFocusRectangle), -1);
    rb_define_method(cFXDCWindow.klass, "drawArea", VALUEFUNC(_wrap_FXDCWindow_drawArea), -1);
    rb_define_method(cFXDCWindow.klass, "drawImage", VALUEFUNC(_wrap_FXDCWindow_drawImage), -1);
    rb_define_method(cFXDCWindow.klass, "drawBitmap", VALUEFUNC(_wrap_FXDCWindow_drawBitmap), -1);
    rb_define_method(cFXDCWindow.klass, "drawIcon", VALUEFUNC(_wrap_FXDCWindow_drawIcon), -1);
    rb_define_method(cFXDCWindow.klass, "drawIconShaded", VALUEFUNC(_wrap_FXDCWindow_drawIconShaded), -1);
    rb_define_method(cFXDCWindow.klass, "drawIconSunken", VALUEFUNC(_wrap_FXDCWindow_drawIconSunken), -1);
    rb_define_method(cFXDCWindow.klass, "drawText", VALUEFUNC(_wrap_FXDCWindow_drawText), -1);
    rb_define_method(cFXDCWindow.klass, "drawImageText", VALUEFUNC(_wrap_FXDCWindow_drawImageText), -1);
    rb_define_method(cFXDCWindow.klass, "setForeground", VALUEFUNC(_wrap_FXDCWindow_setForeground), -1);
    rb_define_method(cFXDCWindow.klass, "setBackground", VALUEFUNC(_wrap_FXDCWindow_setBackground), -1);
    rb_define_method(cFXDCWindow.klass, "setDashes", VALUEFUNC(_wrap_FXDCWindow_setDashes), -1);
    rb_define_method(cFXDCWindow.klass, "setLineWidth", VALUEFUNC(_wrap_FXDCWindow_setLineWidth), -1);
    rb_define_method(cFXDCWindow.klass, "setLineCap", VALUEFUNC(_wrap_FXDCWindow_setLineCap), -1);
    rb_define_method(cFXDCWindow.klass, "setLineJoin", VALUEFUNC(_wrap_FXDCWindow_setLineJoin), -1);
    rb_define_method(cFXDCWindow.klass, "setLineStyle", VALUEFUNC(_wrap_FXDCWindow_setLineStyle), -1);
    rb_define_method(cFXDCWindow.klass, "setFillStyle", VALUEFUNC(_wrap_FXDCWindow_setFillStyle), -1);
    rb_define_method(cFXDCWindow.klass, "setFillRule", VALUEFUNC(_wrap_FXDCWindow_setFillRule), -1);
    rb_define_method(cFXDCWindow.klass, "setFunction", VALUEFUNC(_wrap_FXDCWindow_setFunction), -1);
    rb_define_method(cFXDCWindow.klass, "setTile", VALUEFUNC(_wrap_FXDCWindow_setTile), -1);
    rb_define_method(cFXDCWindow.klass, "setStipple", VALUEFUNC(_wrap_FXDCWindow_setStipple), -1);
    rb_define_method(cFXDCWindow.klass, "setClipRegion", VALUEFUNC(_wrap_FXDCWindow_setClipRegion), -1);
    rb_define_method(cFXDCWindow.klass, "setClipRectangle", VALUEFUNC(_wrap_FXDCWindow_setClipRectangle), -1);
    rb_define_method(cFXDCWindow.klass, "clearClipRectangle", VALUEFUNC(_wrap_FXDCWindow_clearClipRectangle), -1);
    rb_define_method(cFXDCWindow.klass, "setClipMask", VALUEFUNC(_wrap_FXDCWindow_setClipMask), -1);
    rb_define_method(cFXDCWindow.klass, "clearClipMask", VALUEFUNC(_wrap_FXDCWindow_clearClipMask), -1);
    rb_define_method(cFXDCWindow.klass, "setFont", VALUEFUNC(_wrap_FXDCWindow_setFont), -1);
    rb_define_method(cFXDCWindow.klass, "clipChildren", VALUEFUNC(_wrap_FXDCWindow_clipChildren), -1);
    cFXDCWindow.mark = (void (*)(void *)) FXRbDCWindow::markfunc;
    cFXDCWindow.destroy = (void (*)(void *)) free_FXDCWindow;
    rb_define_const(mFox,"PRINT_DEST_PAPER", INT2NUM(PRINT_DEST_PAPER));
    rb_define_const(mFox,"PRINT_DEST_FILE", INT2NUM(PRINT_DEST_FILE));
    rb_define_const(mFox,"PRINT_PAGES_ALL", INT2NUM(PRINT_PAGES_ALL));
    rb_define_const(mFox,"PRINT_PAGES_EVEN", INT2NUM(PRINT_PAGES_EVEN));
    rb_define_const(mFox,"PRINT_PAGES_ODD", INT2NUM(PRINT_PAGES_ODD));
    rb_define_const(mFox,"PRINT_PAGES_RANGE", INT2NUM(PRINT_PAGES_RANGE));
    rb_define_const(mFox,"PRINT_COLLATE_NORMAL", INT2NUM(PRINT_COLLATE_NORMAL));
    rb_define_const(mFox,"PRINT_COLLATE_REVERSED", INT2NUM(PRINT_COLLATE_REVERSED));
    rb_define_const(mFox,"PRINT_PORTRAIT", INT2NUM(PRINT_PORTRAIT));
    rb_define_const(mFox,"PRINT_LANDSCAPE", INT2NUM(PRINT_LANDSCAPE));
    rb_define_const(mFox,"PRINT_BLACKANDWHITE", INT2NUM(PRINT_BLACKANDWHITE));
    rb_define_const(mFox,"PRINT_COLOR", INT2NUM(PRINT_COLOR));
    rb_define_const(mFox,"PRINT_NOBOUNDS", INT2NUM(PRINT_NOBOUNDS));
    rb_define_const(mFox,"MEDIA_CUSTOM", INT2NUM(MEDIA_CUSTOM));
    rb_define_const(mFox,"MEDIA_USLETTER", INT2NUM(MEDIA_USLETTER));
    rb_define_const(mFox,"MEDIA_LEGAL", INT2NUM(MEDIA_LEGAL));
    rb_define_const(mFox,"MEDIA_A4", INT2NUM(MEDIA_A4));
    rb_define_const(mFox,"MEDIA_ENVELOPE", INT2NUM(MEDIA_ENVELOPE));
    
    cFXPSBounds.klass = rb_define_class_under(mFox, "FXPSBounds", rb_cObject);
    SWIG_TypeClientData(SWIGTYPE_p_FXPSBounds, (void *) &cFXPSBounds);
    rb_define_alloc_func(cFXPSBounds.klass, _wrap_FXPSBounds_allocate);
    rb_define_method(cFXPSBounds.klass, "initialize", VALUEFUNC(_wrap_new_FXPSBounds), -1);
    rb_define_method(cFXPSBounds.klass, "xmin=", VALUEFUNC(_wrap_FXPSBounds_xmin_set), -1);
    rb_define_method(cFXPSBounds.klass, "xmin", VALUEFUNC(_wrap_FXPSBounds_xmin_get), -1);
    rb_define_method(cFXPSBounds.klass, "xmax=", VALUEFUNC(_wrap_FXPSBounds_xmax_set), -1);
    rb_define_method(cFXPSBounds.klass, "xmax", VALUEFUNC(_wrap_FXPSBounds_xmax_get), -1);
    rb_define_method(cFXPSBounds.klass, "ymin=", VALUEFUNC(_wrap_FXPSBounds_ymin_set), -1);
    rb_define_method(cFXPSBounds.klass, "ymin", VALUEFUNC(_wrap_FXPSBounds_ymin_get), -1);
    rb_define_method(cFXPSBounds.klass, "ymax=", VALUEFUNC(_wrap_FXPSBounds_ymax_set), -1);
    rb_define_method(cFXPSBounds.klass, "ymax", VALUEFUNC(_wrap_FXPSBounds_ymax_get), -1);
    cFXPSBounds.mark = 0;
    cFXPSBounds.destroy = (void (*)(void *)) free_FXPSBounds;
    
    cFXPrinter.klass = rb_define_class_under(mFox, "FXPrinter", rb_cObject);
    SWIG_TypeClientData(SWIGTYPE_p_FXPrinter, (void *) &cFXPrinter);
    rb_define_alloc_func(cFXPrinter.klass, _wrap_FXPrinter_allocate);
    rb_define_method(cFXPrinter.klass, "initialize", VALUEFUNC(_wrap_new_FXPrinter), -1);
    rb_define_method(cFXPrinter.klass, "name=", VALUEFUNC(_wrap_FXPrinter_name_set), -1);
    rb_define_method(cFXPrinter.klass, "name", VALUEFUNC(_wrap_FXPrinter_name_get), -1);
    rb_define_method(cFXPrinter.klass, "firstpage=", VALUEFUNC(_wrap_FXPrinter_firstpage_set), -1);
    rb_define_method(cFXPrinter.klass, "firstpage", VALUEFUNC(_wrap_FXPrinter_firstpage_get), -1);
    rb_define_method(cFXPrinter.klass, "lastpage=", VALUEFUNC(_wrap_FXPrinter_lastpage_set), -1);
    rb_define_method(cFXPrinter.klass, "lastpage", VALUEFUNC(_wrap_FXPrinter_lastpage_get), -1);
    rb_define_method(cFXPrinter.klass, "currentpage=", VALUEFUNC(_wrap_FXPrinter_currentpage_set), -1);
    rb_define_method(cFXPrinter.klass, "currentpage", VALUEFUNC(_wrap_FXPrinter_currentpage_get), -1);
    rb_define_method(cFXPrinter.klass, "frompage=", VALUEFUNC(_wrap_FXPrinter_frompage_set), -1);
    rb_define_method(cFXPrinter.klass, "frompage", VALUEFUNC(_wrap_FXPrinter_frompage_get), -1);
    rb_define_method(cFXPrinter.klass, "topage=", VALUEFUNC(_wrap_FXPrinter_topage_set), -1);
    rb_define_method(cFXPrinter.klass, "topage", VALUEFUNC(_wrap_FXPrinter_topage_get), -1);
    rb_define_method(cFXPrinter.klass, "mediasize=", VALUEFUNC(_wrap_FXPrinter_mediasize_set), -1);
    rb_define_method(cFXPrinter.klass, "mediasize", VALUEFUNC(_wrap_FXPrinter_mediasize_get), -1);
    rb_define_method(cFXPrinter.klass, "mediawidth=", VALUEFUNC(_wrap_FXPrinter_mediawidth_set), -1);
    rb_define_method(cFXPrinter.klass, "mediawidth", VALUEFUNC(_wrap_FXPrinter_mediawidth_get), -1);
    rb_define_method(cFXPrinter.klass, "mediaheight=", VALUEFUNC(_wrap_FXPrinter_mediaheight_set), -1);
    rb_define_method(cFXPrinter.klass, "mediaheight", VALUEFUNC(_wrap_FXPrinter_mediaheight_get), -1);
    rb_define_method(cFXPrinter.klass, "leftmargin=", VALUEFUNC(_wrap_FXPrinter_leftmargin_set), -1);
    rb_define_method(cFXPrinter.klass, "leftmargin", VALUEFUNC(_wrap_FXPrinter_leftmargin_get), -1);
    rb_define_method(cFXPrinter.klass, "rightmargin=", VALUEFUNC(_wrap_FXPrinter_rightmargin_set), -1);
    rb_define_method(cFXPrinter.klass, "rightmargin", VALUEFUNC(_wrap_FXPrinter_rightmargin_get), -1);
    rb_define_method(cFXPrinter.klass, "topmargin=", VALUEFUNC(_wrap_FXPrinter_topmargin_set), -1);
    rb_define_method(cFXPrinter.klass, "topmargin", VALUEFUNC(_wrap_FXPrinter_topmargin_get), -1);
    rb_define_method(cFXPrinter.klass, "bottommargin=", VALUEFUNC(_wrap_FXPrinter_bottommargin_set), -1);
    rb_define_method(cFXPrinter.klass, "bottommargin", VALUEFUNC(_wrap_FXPrinter_bottommargin_get), -1);
    rb_define_method(cFXPrinter.klass, "numcopies=", VALUEFUNC(_wrap_FXPrinter_numcopies_set), -1);
    rb_define_method(cFXPrinter.klass, "numcopies", VALUEFUNC(_wrap_FXPrinter_numcopies_get), -1);
    rb_define_method(cFXPrinter.klass, "flags=", VALUEFUNC(_wrap_FXPrinter_flags_set), -1);
    rb_define_method(cFXPrinter.klass, "flags", VALUEFUNC(_wrap_FXPrinter_flags_get), -1);
    cFXPrinter.mark = 0;
    cFXPrinter.destroy = (void (*)(void *)) FXRbUnregisterRubyObj;
    
    cFXDCPrint.klass = rb_define_class_under(mFox, "FXDCPrint", ((swig_class *) SWIGTYPE_p_FXDC->clientdata)->klass);
    SWIG_TypeClientData(SWIGTYPE_p_FXDCPrint, (void *) &cFXDCPrint);
    rb_define_alloc_func(cFXDCPrint.klass, _wrap_FXDCPrint_allocate);
    rb_define_method(cFXDCPrint.klass, "initialize", VALUEFUNC(_wrap_new_FXDCPrint), -1);
    rb_define_method(cFXDCPrint.klass, "beginPrint", VALUEFUNC(_wrap_FXDCPrint_beginPrint), -1);
    rb_define_method(cFXDCPrint.klass, "endPrint", VALUEFUNC(_wrap_FXDCPrint_endPrint), -1);
    rb_define_method(cFXDCPrint.klass, "beginPage", VALUEFUNC(_wrap_FXDCPrint_beginPage), -1);
    rb_define_method(cFXDCPrint.klass, "endPage", VALUEFUNC(_wrap_FXDCPrint_endPage), -1);
    rb_define_method(cFXDCPrint.klass, "setContentRange", VALUEFUNC(_wrap_FXDCPrint_setContentRange), -1);
    rb_define_method(cFXDCPrint.klass, "readPixel", VALUEFUNC(_wrap_FXDCPrint_readPixel), -1);
    rb_define_method(cFXDCPrint.klass, "drawPoint", VALUEFUNC(_wrap_FXDCPrint_drawPoint), -1);
    rb_define_method(cFXDCPrint.klass, "drawPoints", VALUEFUNC(_wrap_FXDCPrint_drawPoints), -1);
    rb_define_method(cFXDCPrint.klass, "drawPointsRel", VALUEFUNC(_wrap_FXDCPrint_drawPointsRel), -1);
    rb_define_method(cFXDCPrint.klass, "drawLine", VALUEFUNC(_wrap_FXDCPrint_drawLine), -1);
    rb_define_method(cFXDCPrint.klass, "drawLines", VALUEFUNC(_wrap_FXDCPrint_drawLines), -1);
    rb_define_method(cFXDCPrint.klass, "drawLinesRel", VALUEFUNC(_wrap_FXDCPrint_drawLinesRel), -1);
    rb_define_method(cFXDCPrint.klass, "drawLineSegments", VALUEFUNC(_wrap_FXDCPrint_drawLineSegments), -1);
    rb_define_method(cFXDCPrint.klass, "drawRectangle", VALUEFUNC(_wrap_FXDCPrint_drawRectangle), -1);
    rb_define_method(cFXDCPrint.klass, "drawRectangles", VALUEFUNC(_wrap_FXDCPrint_drawRectangles), -1);
    rb_define_method(cFXDCPrint.klass, "drawArc", VALUEFUNC(_wrap_FXDCPrint_drawArc), -1);
    rb_define_method(cFXDCPrint.klass, "drawArcs", VALUEFUNC(_wrap_FXDCPrint_drawArcs), -1);
    rb_define_method(cFXDCPrint.klass, "fillRectangle", VALUEFUNC(_wrap_FXDCPrint_fillRectangle), -1);
    rb_define_method(cFXDCPrint.klass, "fillRectangles", VALUEFUNC(_wrap_FXDCPrint_fillRectangles), -1);
    rb_define_method(cFXDCPrint.klass, "fillChord", VALUEFUNC(_wrap_FXDCPrint_fillChord), -1);
    rb_define_method(cFXDCPrint.klass, "fillChords", VALUEFUNC(_wrap_FXDCPrint_fillChords), -1);
    rb_define_method(cFXDCPrint.klass, "fillArc", VALUEFUNC(_wrap_FXDCPrint_fillArc), -1);
    rb_define_method(cFXDCPrint.klass, "fillArcs", VALUEFUNC(_wrap_FXDCPrint_fillArcs), -1);
    rb_define_method(cFXDCPrint.klass, "fillPolygon", VALUEFUNC(_wrap_FXDCPrint_fillPolygon), -1);
    rb_define_method(cFXDCPrint.klass, "fillConcavePolygon", VALUEFUNC(_wrap_FXDCPrint_fillConcavePolygon), -1);
    rb_define_method(cFXDCPrint.klass, "fillComplexPolygon", VALUEFUNC(_wrap_FXDCPrint_fillComplexPolygon), -1);
    rb_define_method(cFXDCPrint.klass, "fillPolygonRel", VALUEFUNC(_wrap_FXDCPrint_fillPolygonRel), -1);
    rb_define_method(cFXDCPrint.klass, "fillConcavePolygonRel", VALUEFUNC(_wrap_FXDCPrint_fillConcavePolygonRel), -1);
    rb_define_method(cFXDCPrint.klass, "fillComplexPolygonRel", VALUEFUNC(_wrap_FXDCPrint_fillComplexPolygonRel), -1);
    rb_define_method(cFXDCPrint.klass, "drawHashBox", VALUEFUNC(_wrap_FXDCPrint_drawHashBox), -1);
    rb_define_method(cFXDCPrint.klass, "drawFocusRectangle", VALUEFUNC(_wrap_FXDCPrint_drawFocusRectangle), -1);
    rb_define_method(cFXDCPrint.klass, "drawArea", VALUEFUNC(_wrap_FXDCPrint_drawArea), -1);
    rb_define_method(cFXDCPrint.klass, "drawImage", VALUEFUNC(_wrap_FXDCPrint_drawImage), -1);
    rb_define_method(cFXDCPrint.klass, "drawBitmap", VALUEFUNC(_wrap_FXDCPrint_drawBitmap), -1);
    rb_define_method(cFXDCPrint.klass, "drawIcon", VALUEFUNC(_wrap_FXDCPrint_drawIcon), -1);
    rb_define_method(cFXDCPrint.klass, "drawIconShaded", VALUEFUNC(_wrap_FXDCPrint_drawIconShaded), -1);
    rb_define_method(cFXDCPrint.klass, "drawIconSunken", VALUEFUNC(_wrap_FXDCPrint_drawIconSunken), -1);
    rb_define_method(cFXDCPrint.klass, "drawText", VALUEFUNC(_wrap_FXDCPrint_drawText), -1);
    rb_define_method(cFXDCPrint.klass, "drawImageText", VALUEFUNC(_wrap_FXDCPrint_drawImageText), -1);
    rb_define_method(cFXDCPrint.klass, "setForeground", VALUEFUNC(_wrap_FXDCPrint_setForeground), -1);
    rb_define_method(cFXDCPrint.klass, "setBackground", VALUEFUNC(_wrap_FXDCPrint_setBackground), -1);
    rb_define_method(cFXDCPrint.klass, "setDashes", VALUEFUNC(_wrap_FXDCPrint_setDashes), -1);
    rb_define_method(cFXDCPrint.klass, "setLineWidth", VALUEFUNC(_wrap_FXDCPrint_setLineWidth), -1);
    rb_define_method(cFXDCPrint.klass, "setLineCap", VALUEFUNC(_wrap_FXDCPrint_setLineCap), -1);
    rb_define_method(cFXDCPrint.klass, "setLineJoin", VALUEFUNC(_wrap_FXDCPrint_setLineJoin), -1);
    rb_define_method(cFXDCPrint.klass, "setLineStyle", VALUEFUNC(_wrap_FXDCPrint_setLineStyle), -1);
    rb_define_method(cFXDCPrint.klass, "setFillStyle", VALUEFUNC(_wrap_FXDCPrint_setFillStyle), -1);
    rb_define_method(cFXDCPrint.klass, "setFillRule", VALUEFUNC(_wrap_FXDCPrint_setFillRule), -1);
    rb_define_method(cFXDCPrint.klass, "setFunction", VALUEFUNC(_wrap_FXDCPrint_setFunction), -1);
    rb_define_method(cFXDCPrint.klass, "setTile", VALUEFUNC(_wrap_FXDCPrint_setTile), -1);
    rb_define_method(cFXDCPrint.klass, "setStipple", VALUEFUNC(_wrap_FXDCPrint_setStipple), -1);
    rb_define_method(cFXDCPrint.klass, "setClipRegion", VALUEFUNC(_wrap_FXDCPrint_setClipRegion), -1);
    rb_define_method(cFXDCPrint.klass, "setClipRectangle", VALUEFUNC(_wrap_FXDCPrint_setClipRectangle), -1);
    rb_define_method(cFXDCPrint.klass, "clearClipRectangle", VALUEFUNC(_wrap_FXDCPrint_clearClipRectangle), -1);
    rb_define_method(cFXDCPrint.klass, "setClipMask", VALUEFUNC(_wrap_FXDCPrint_setClipMask), -1);
    rb_define_method(cFXDCPrint.klass, "clearClipMask", VALUEFUNC(_wrap_FXDCPrint_clearClipMask), -1);
    rb_define_method(cFXDCPrint.klass, "setFont", VALUEFUNC(_wrap_FXDCPrint_setFont), -1);
    rb_define_method(cFXDCPrint.klass, "clipChildren", VALUEFUNC(_wrap_FXDCPrint_clipChildren), -1);
    cFXDCPrint.mark = (void (*)(void *)) FXRbDCPrint::markfunc;
    cFXDCPrint.destroy = (void (*)(void *)) FXRbUnregisterRubyObj;
}

