/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 1.3.22
 * 
 * This file is not intended to be easily readable and contains a number of 
 * coding conventions designed to improve portability and efficiency. Do not make
 * changes to this file unless you know what you are doing--modify the SWIG 
 * interface file instead. 
 * ----------------------------------------------------------------------------- */

#define SWIG_NOINCLUDE

#ifdef __cplusplus
template<class T> class SwigValueWrapper {
    T *tt;
public:
    SwigValueWrapper() : tt(0) { }
    SwigValueWrapper(const SwigValueWrapper<T>& rhs) : tt(new T(*rhs.tt)) { }
    SwigValueWrapper(const T& t) : tt(new T(t)) { }
    ~SwigValueWrapper() { delete tt; } 
    SwigValueWrapper& operator=(const T& t) { delete tt; tt = new T(t); return *this; }
    operator T&() const { return *tt; }
    T *operator&() { return tt; }
private:
    SwigValueWrapper& operator=(const SwigValueWrapper<T>& rhs);
};                                                    
#endif

/* ruby.swg */
/* Implementation : RUBY */
#define SWIGRUBY 1

#include "ruby.h"

/* Flags for pointer conversion */
#define SWIG_POINTER_EXCEPTION     0x1
#define SWIG_POINTER_DISOWN        0x2

#define NUM2USHRT(n) (\
    (0 <= NUM2UINT(n) && NUM2UINT(n) <= USHRT_MAX)\
    ? (unsigned short) NUM2UINT(n) \
    : (rb_raise(rb_eArgError, "integer %d out of range of `unsigned short'",\
               NUM2UINT(n)), (short)0)\
)

#define NUM2SHRT(n) (\
    (SHRT_MIN <= NUM2INT(n) && NUM2INT(n) <= SHRT_MAX)\
    ? (short)NUM2INT(n)\
    : (rb_raise(rb_eArgError, "integer %d out of range of `short'",\
               NUM2INT(n)), (short)0)\
)

/* Ruby 1.7 defines NUM2LL(), LL2NUM() and ULL2NUM() macros */
#ifndef NUM2LL
#define NUM2LL(x) NUM2LONG((x))
#endif
#ifndef LL2NUM
#define LL2NUM(x) INT2NUM((long) (x))
#endif
#ifndef ULL2NUM
#define ULL2NUM(x) UINT2NUM((unsigned long) (x))
#endif

/* Ruby 1.7 doesn't (yet) define NUM2ULL() */
#ifndef NUM2ULL
#ifdef HAVE_LONG_LONG
#define NUM2ULL(x) rb_num2ull((x))
#else
#define NUM2ULL(x) NUM2ULONG(x)
#endif
#endif

/*
 * Need to be very careful about how these macros are defined, especially
 * when compiling C++ code or C code with an ANSI C compiler.
 *
 * VALUEFUNC(f) is a macro used to typecast a C function that implements
 * a Ruby method so that it can be passed as an argument to API functions
 * like rb_define_method() and rb_define_singleton_method().
 *
 * VOIDFUNC(f) is a macro used to typecast a C function that implements
 * either the "mark" or "free" stuff for a Ruby Data object, so that it
 * can be passed as an argument to API functions like Data_Wrap_Struct()
 * and Data_Make_Struct().
 */
 
#ifdef __cplusplus
#  ifndef RUBY_METHOD_FUNC /* These definitions should work for Ruby 1.4.6 */
#    define PROTECTFUNC(f) ((VALUE (*)()) f)
#    define VALUEFUNC(f) ((VALUE (*)()) f)
#    define VOIDFUNC(f)  ((void (*)()) f)
#  else
#    ifndef ANYARGS /* These definitions should work for Ruby 1.6 */
#      define PROTECTFUNC(f) ((VALUE (*)()) f)
#      define VALUEFUNC(f) ((VALUE (*)()) f)
#      define VOIDFUNC(f)  ((RUBY_DATA_FUNC) f)
#    else /* These definitions should work for Ruby 1.7+ */
#      define PROTECTFUNC(f) ((VALUE (*)(VALUE)) f)
#      define VALUEFUNC(f) ((VALUE (*)(ANYARGS)) f)
#      define VOIDFUNC(f)  ((RUBY_DATA_FUNC) f)
#    endif
#  endif
#else
#  define VALUEFUNC(f) (f)
#  define VOIDFUNC(f) (f)
#endif

typedef struct {
  VALUE klass;
  VALUE mImpl;
  void  (*mark)(void *);
  void  (*destroy)(void *);
} swig_class;

/* Don't use for expressions have side effect */
#ifndef RB_STRING_VALUE
#define RB_STRING_VALUE(s) (TYPE(s) == T_STRING ? (s) : (*(volatile VALUE *)&(s) = rb_str_to_str(s)))
#endif
#ifndef StringValue
#define StringValue(s) RB_STRING_VALUE(s)
#endif
#ifndef StringValuePtr
#define StringValuePtr(s) RSTRING(RB_STRING_VALUE(s))->ptr
#endif
#ifndef StringValueLen
#define StringValueLen(s) RSTRING(RB_STRING_VALUE(s))->len
#endif
#ifndef SafeStringValue
#define SafeStringValue(v) do {\
    StringValue(v);\
    rb_check_safe_str(v);\
} while (0)
#endif

#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
#define rb_define_alloc_func(klass, func) rb_define_singleton_method((klass), "new", VALUEFUNC((func)), -1)
#define rb_undef_alloc_func(klass) rb_undef_method(CLASS_OF((klass)), "new")
#endif

/* Contract support */

#define SWIG_contract_assert(expr, msg) if (!(expr)) { rb_raise(rb_eRuntimeError, (char *) msg ); } else


/*************************************************************** -*- c -*-
 * ruby/precommon.swg
 *
 * Rename all exported symbols from common.swg, to avoid symbol
 * clashes if multiple interpreters are included
 *
 ************************************************************************/

#define SWIG_TypeRegister    SWIG_Ruby_TypeRegister
#define SWIG_TypeCheck       SWIG_Ruby_TypeCheck
#define SWIG_TypeCast        SWIG_Ruby_TypeCast
#define SWIG_TypeDynamicCast SWIG_Ruby_TypeDynamicCast
#define SWIG_TypeName        SWIG_Ruby_TypeName
#define SWIG_TypePrettyName  SWIG_Ruby_TypePrettyName
#define SWIG_TypeQuery       SWIG_Ruby_TypeQuery
#define SWIG_TypeClientData  SWIG_Ruby_TypeClientData
#define SWIG_PackData        SWIG_Ruby_PackData 
#define SWIG_UnpackData      SWIG_Ruby_UnpackData 

/* Also rename all exported symbols from rubydef.swig */

/* Common SWIG API */
#define SWIG_ConvertPtr(obj, pp, type, flags) \
  SWIG_Ruby_ConvertPtr(obj, pp, type, flags)
#define SWIG_NewPointerObj(p, type, flags) \
  SWIG_Ruby_NewPointerObj(p, type, flags)
#define SWIG_MustGetPtr(p, type, argnum, flags) \
  SWIG_Ruby_MustGetPtr(p, type, argnum, flags)

/* Ruby-specific SWIG API */

#define SWIG_InitRuntime() \
  SWIG_Ruby_InitRuntime()
#define SWIG_define_class(ty) \
  SWIG_Ruby_define_class(ty)
#define SWIG_NewClassInstance(value, ty) \
  SWIG_Ruby_NewClassInstance(value, ty)
#define SWIG_MangleStr(value) \
  SWIG_Ruby_MangleStr(value)
#define SWIG_CheckConvert(value, ty) \
  SWIG_Ruby_CheckConvert(value, ty)
#define SWIG_NewPackedObj(ptr, sz, ty) \
  SWIG_Ruby_NewPackedObj(ptr, sz, ty)
#define SWIG_ConvertPacked(obj, ptr, sz, ty, flags) \
  SWIG_Ruby_ConvertPacked(obj, ptr, sz, ty, flags)


/***********************************************************************
 * common.swg
 *
 *     This file contains generic SWIG runtime support for pointer
 *     type checking as well as a few commonly used macros to control
 *     external linkage.
 *
 * Author : David Beazley (beazley@cs.uchicago.edu)
 *
 * Copyright (c) 1999-2000, The University of Chicago
 * 
 * This file may be freely redistributed without license or fee provided
 * this copyright message remains intact.
 ************************************************************************/

#include <string.h>

#if defined(_WIN32) || defined(__WIN32__) || defined(__CYGWIN__)
#  if defined(_MSC_VER) || defined(__GNUC__)
#    if defined(STATIC_LINKED)
#      define SWIGEXPORT(a) a
#      define SWIGIMPORT(a) extern a
#    else
#      define SWIGEXPORT(a) __declspec(dllexport) a
#      define SWIGIMPORT(a) extern a
#    endif
#  else
#    if defined(__BORLANDC__)
#      define SWIGEXPORT(a) a _export
#      define SWIGIMPORT(a) a _export
#    else
#      define SWIGEXPORT(a) a
#      define SWIGIMPORT(a) a
#    endif
#  endif
#else
#  define SWIGEXPORT(a) a
#  define SWIGIMPORT(a) a
#endif

#ifdef SWIG_GLOBAL
#  define SWIGRUNTIME(a) SWIGEXPORT(a)
#else
#  define SWIGRUNTIME(a) static a
#endif

#ifdef __cplusplus
extern "C" {
#endif

typedef void *(*swig_converter_func)(void *);
typedef struct swig_type_info *(*swig_dycast_func)(void **);

typedef struct swig_type_info {
  const char             *name;
  swig_converter_func     converter;
  const char             *str;
  void                   *clientdata;
  swig_dycast_func        dcast;
  struct swig_type_info  *next;
  struct swig_type_info  *prev;
} swig_type_info;

#ifdef SWIG_NOINCLUDE

SWIGIMPORT(swig_type_info *) SWIG_TypeRegister(swig_type_info *);
SWIGIMPORT(swig_type_info *) SWIG_TypeCheck(char *c, swig_type_info *);
SWIGIMPORT(void *)           SWIG_TypeCast(swig_type_info *, void *);
SWIGIMPORT(swig_type_info *) SWIG_TypeDynamicCast(swig_type_info *, void **);
SWIGIMPORT(const char *)     SWIG_TypeName(const swig_type_info *);
SWIGIMPORT(const char *)     SWIG_TypePrettyName(const swig_type_info *);
SWIGIMPORT(swig_type_info *) SWIG_TypeQuery(const char *);
SWIGIMPORT(void)             SWIG_TypeClientData(swig_type_info *, void *);
SWIGIMPORT(char *)           SWIG_PackData(char *, void *, int);
SWIGIMPORT(char *)           SWIG_UnpackData(char *, void *, int);

#else

static swig_type_info *swig_type_list = 0;
static swig_type_info **swig_type_list_handle = &swig_type_list;

/* Register a type mapping with the type-checking */
SWIGRUNTIME(swig_type_info *)
SWIG_TypeRegister(swig_type_info *ti) {
  swig_type_info *tc, *head, *ret, *next;
  /* Check to see if this type has already been registered */
  tc = *swig_type_list_handle;
  while (tc) {
    if (strcmp(tc->name, ti->name) == 0) {
      /* Already exists in the table.  Just add additional types to the list */
      if (tc->clientdata) ti->clientdata = tc->clientdata;
      head = tc;
      next = tc->next;
      goto l1;
    }
    tc = tc->prev;
  }
  head = ti;
  next = 0;

  /* Place in list */
  ti->prev = *swig_type_list_handle;
  *swig_type_list_handle = ti;

  /* Build linked lists */
  l1:
  ret = head;
  tc = ti + 1;
  /* Patch up the rest of the links */
  while (tc->name) {
    head->next = tc;
    tc->prev = head;
    head = tc;
    tc++;
  }
  if (next) next->prev = head;
  head->next = next;
  return ret;
}

/* Check the typename */
SWIGRUNTIME(swig_type_info *) 
SWIG_TypeCheck(char *c, swig_type_info *ty) {
  swig_type_info *s;
  if (!ty) return 0;        /* Void pointer */
  s = ty->next;             /* First element always just a name */
  do {
    if (strcmp(s->name,c) == 0) {
      if (s == ty->next) return s;
      /* Move s to the top of the linked list */
      s->prev->next = s->next;
      if (s->next) {
        s->next->prev = s->prev;
      }
      /* Insert s as second element in the list */
      s->next = ty->next;
      if (ty->next) ty->next->prev = s;
      ty->next = s;
      s->prev = ty;
      return s;
    }
    s = s->next;
  } while (s && (s != ty->next));
  return 0;
}

/* Cast a pointer up an inheritance hierarchy */
SWIGRUNTIME(void *) 
SWIG_TypeCast(swig_type_info *ty, void *ptr) {
  if ((!ty) || (!ty->converter)) return ptr;
  return (*ty->converter)(ptr);
}

/* Dynamic pointer casting. Down an inheritance hierarchy */
SWIGRUNTIME(swig_type_info *) 
SWIG_TypeDynamicCast(swig_type_info *ty, void **ptr) {
  swig_type_info *lastty = ty;
  if (!ty || !ty->dcast) return ty;
  while (ty && (ty->dcast)) {
    ty = (*ty->dcast)(ptr);
    if (ty) lastty = ty;
  }
  return lastty;
}

/* Return the name associated with this type */
SWIGRUNTIME(const char *)
SWIG_TypeName(const swig_type_info *ty) {
  return ty->name;
}

/* Return the pretty name associated with this type,
   that is an unmangled type name in a form presentable to the user.
*/
SWIGRUNTIME(const char *)
SWIG_TypePrettyName(const swig_type_info *type) {
  /* The "str" field contains the equivalent pretty names of the
     type, separated by vertical-bar characters.  We choose
     to print the last name, as it is often (?) the most
     specific. */
  if (type->str != NULL) {
    const char *last_name = type->str;
    const char *s;
    for (s = type->str; *s; s++)
      if (*s == '|') last_name = s+1;
    return last_name;
  }
  else
    return type->name;
}

/* 
   Compare two type names skipping the space characters, therefore
   "char*" == "char *" and "Class<int>" == "Class<int >", etc.

   Return 0 when the two name types are equivalent, as in
   strncmp, but skipping ' '.
*/
static int
SWIG_TypeNameComp(const char *f1, const char *l1,
		  const char *f2, const char *l2) {
  for (;(f1 != l1) && (f2 != l2); ++f1, ++f2) {
    while ((*f1 == ' ') && (f1 != l1)) ++f1;
    while ((*f2 == ' ') && (f2 != l2)) ++f2;
    if (*f1 != *f2) return *f1 - *f2;
  }
  return (l1 - f1) - (l2 - f2);
}

/*
  Check type equivalence in a name list like <name1>|<name2>|...
*/
static int
SWIG_TypeEquiv(const char *nb, const char *tb) {
  int equiv = 0;
  const char* te = tb + strlen(tb);
  const char* ne = nb;
  while (!equiv && *ne) {
    for (nb = ne; *ne; ++ne) {
      if (*ne == '|') break;
    }
    equiv = SWIG_TypeNameComp(nb, ne, tb, te) == 0;
    if (*ne) ++ne;
  }
  return equiv;
}
  

/* Search for a swig_type_info structure */
SWIGRUNTIME(swig_type_info *)
SWIG_TypeQuery(const char *name) {
  swig_type_info *ty = *swig_type_list_handle;
  while (ty) {
    if (ty->str && (SWIG_TypeEquiv(ty->str,name))) return ty;
    if (ty->name && (strcmp(name,ty->name) == 0)) return ty;
    ty = ty->prev;
  }
  return 0;
}

/* Set the clientdata field for a type */
SWIGRUNTIME(void)
SWIG_TypeClientData(swig_type_info *ti, void *clientdata) {
  swig_type_info *tc, *equiv;
  if (ti->clientdata == clientdata) return;
  ti->clientdata = clientdata;
  equiv = ti->next;
  while (equiv) {
    if (!equiv->converter) {
      tc = *swig_type_list_handle;
      while (tc) {
        if ((strcmp(tc->name, equiv->name) == 0))
          SWIG_TypeClientData(tc,clientdata);
        tc = tc->prev;
      }
    }
    equiv = equiv->next;
  }
}

/* Pack binary data into a string */
SWIGRUNTIME(char *)
SWIG_PackData(char *c, void *ptr, int sz) {
  static char hex[17] = "0123456789abcdef";
  unsigned char *u = (unsigned char *) ptr;
  const unsigned char *eu =  u + sz;
  register unsigned char uu;
  for (; u != eu; ++u) {
    uu = *u;
    *(c++) = hex[(uu & 0xf0) >> 4];
    *(c++) = hex[uu & 0xf];
  }
  return c;
}

/* Unpack binary data from a string */
SWIGRUNTIME(char *)
SWIG_UnpackData(char *c, void *ptr, int sz) {
  register unsigned char uu = 0;
  register int d;
  unsigned char *u = (unsigned char *) ptr;
  const unsigned char *eu =  u + sz;
  for (; u != eu; ++u) {
    d = *(c++);
    if ((d >= '0') && (d <= '9'))
      uu = ((d - '0') << 4);
    else if ((d >= 'a') && (d <= 'f'))
      uu = ((d - ('a'-10)) << 4);
    d = *(c++);
    if ((d >= '0') && (d <= '9'))
      uu |= (d - '0');
    else if ((d >= 'a') && (d <= 'f'))
      uu |= (d - ('a'-10));
    *u = uu;
  }
  return c;
}

#endif

#ifdef __cplusplus
}
#endif

/* rubydec.swg -*- c -*- */
#ifdef __cplusplus
extern "C" {
#endif

SWIGIMPORT(void)   SWIG_Ruby_InitRuntime(void);
SWIGIMPORT(void)   SWIG_Ruby_define_class(swig_type_info *);
SWIGIMPORT(VALUE)  SWIG_Ruby_NewPointerObj(void *, swig_type_info *, int);
SWIGIMPORT(VALUE)  SWIG_Ruby_NewClassInstance(VALUE, swig_type_info *);
SWIGIMPORT(char *) SWIG_Ruby_MangleStr(VALUE);
SWIGIMPORT(int)    SWIG_Ruby_ConvertPtr(VALUE, void**, swig_type_info *, int);
SWIGIMPORT(void *) SWIG_Ruby_MustGetPtr(VALUE, swig_type_info *, int, int);
SWIGIMPORT(int)    SWIG_Ruby_CheckConvert(VALUE, swig_type_info *);
SWIGIMPORT(VALUE)  SWIG_Ruby_NewPackedObj(void *ptr, int sz, swig_type_info *type);
SWIGIMPORT(void)   SWIG_Ruby_ConvertPacked(VALUE obj, void *ptr, int sz, swig_type_info *ty, int flags);

#ifdef __cplusplus
}
#endif


/* -------- TYPES TABLE (BEGIN) -------- */

#define  SWIGTYPE_p_FXFrame swig_types[0] 
#define  SWIGTYPE_p_FXToolBarTab swig_types[1] 
#define  SWIGTYPE_p_FXColorBar swig_types[2] 
#define  SWIGTYPE_p_FXObject swig_types[3] 
#define  SWIGTYPE_p_FXBitmapFrame swig_types[4] 
#define  SWIGTYPE_p_FXHeaderItem swig_types[5] 
#define  SWIGTYPE_p_FXRuler swig_types[6] 
#define  SWIGTYPE_p_FXArrowButton swig_types[7] 
#define  SWIGTYPE_p_FXWindow swig_types[8] 
#define  SWIGTYPE_p_FXComposite swig_types[9] 
#define  SWIGTYPE_p_FXColorWheel swig_types[10] 
#define  SWIGTYPE_p_FXColorWell swig_types[11] 
#define  SWIGTYPE_p_FXBitmap swig_types[12] 
#define  SWIGTYPE_p_FXProgressBar swig_types[13] 
#define  SWIGTYPE_p_FXId swig_types[14] 
#define  SWIGTYPE_p_FXFont swig_types[15] 
#define  SWIGTYPE_p_FXStatusLine swig_types[16] 
#define  SWIGTYPE_p_FXSeparator swig_types[17] 
#define  SWIGTYPE_p_FXHorizontalSeparator swig_types[18] 
#define  SWIGTYPE_p_FXVerticalSeparator swig_types[19] 
#define  SWIGTYPE_p_FXStream swig_types[20] 
#define  SWIGTYPE_p_FXDrawable swig_types[21] 
#define  SWIGTYPE_p_FXTextField swig_types[22] 
#define  SWIGTYPE_p_FXIcon swig_types[23] 
#define  SWIGTYPE_p_FXHeader swig_types[24] 
#define  SWIGTYPE_p_FXImageFrame swig_types[25] 
#define  SWIGTYPE_p_FXSlider swig_types[26] 
#define  SWIGTYPE_p_FXRealSlider swig_types[27] 
#define  SWIGTYPE_p_FXImage swig_types[28] 
#define  SWIGTYPE_p_FXDial swig_types[29] 
static swig_type_info *swig_types[31];

/* -------- TYPES TABLE (END) -------- */

#define SWIG_init    Init_frames
#define SWIG_name    "Frames"


static void SWIG_AsVal(VALUE obj, int *val)
{
    *val = (int) NUM2INT(obj);
}


#include "FXRbCommon.h"


inline FXColor to_FXColor(VALUE obj){
  if(TYPE(obj)==T_STRING){
    return fxcolorfromname(StringValuePtr(obj));
    }
  else if(TYPE(obj)==T_SYMBOL){
    return fxcolorfromname(rb_id2name(SYM2ID(obj)));
    }
  else{
    return NUM2ULONG(obj);
    }
  }


inline FXString to_FXString(VALUE obj){
  if(!NIL_P(obj)){
    Check_Type(obj,T_STRING);
    return FXString(STR2CSTR(obj));
    }
  else{
    return FXString::null;
    }
  }


inline FXbool to_FXbool(VALUE obj){
  if (obj == Qtrue || obj == Qfalse){
    return (obj == Qtrue) ? TRUE : FALSE;
    }
  else{
    return static_cast<FXbool>(NUM2UINT(obj));
    }
  }


static swig_type_info* FXEventTypeInfo=0;

inline void* to_FXEvent(VALUE obj){
  void* ptr;
  if(!FXEventTypeInfo){
    FXEventTypeInfo=SWIG_TypeQuery("FXEvent *");
    FXASSERT(FXEventTypeInfo!=0);
    }
  SWIG_ConvertPtr(obj,&ptr,FXEventTypeInfo,1);
  return ptr;
  }

FXArrowButton *new_FXArrowButton(FXComposite *p,FXObject *tgt,FXSelector sel,FXuint opts,FXint x,FXint y,FXint w,FXint h,FXint pl,FXint pr,FXint pt,FXint pb){
      return new FXRbArrowButton(p,tgt,sel,opts,x,y,w,h,pl,pr,pt,pb);
      }

swig_class cFXArrowButton;
static void free_FXArrowButton(FXArrowButton *);
FXColorBar *new_FXColorBar(FXComposite *p,FXObject *tgt,FXSelector sel,FXuint opts,FXint x,FXint y,FXint w,FXint h,FXint pl,FXint pr,FXint pt,FXint pb){
      return new FXRbColorBar(p,tgt,sel,opts,x,y,w,h,pl,pr,pt,pb);
      }

swig_class cFXColorBar;
static void free_FXColorBar(FXColorBar *);
FXColorWell *new_FXColorWell(FXComposite *p,FXColor clr,FXObject *tgt,FXSelector sel,FXuint opts,FXint x,FXint y,FXint w,FXint h,FXint pl,FXint pr,FXint pt,FXint pb){
      return new FXRbColorWell(p,clr,tgt,sel,opts,x,y,w,h,pl,pr,pt,pb);
      }

swig_class cFXColorWell;
static void free_FXColorWell(FXColorWell *);
FXColorWheel *new_FXColorWheel(FXComposite *p,FXObject *tgt,FXSelector sel,FXuint opts,FXint x,FXint y,FXint w,FXint h,FXint pl,FXint pr,FXint pt,FXint pb){
      return new FXRbColorWheel(p,tgt,sel,opts,x,y,w,h,pl,pr,pt,pb);
      }

swig_class cFXColorWheel;
static void free_FXColorWheel(FXColorWheel *);
FXDial *new_FXDial(FXComposite *p,FXObject *tgt,FXSelector sel,FXuint opts,FXint x,FXint y,FXint w,FXint h,FXint pl,FXint pr,FXint pt,FXint pb){
      return new FXRbDial(p,tgt,sel,opts,x,y,w,h,pl,pr,pt,pb);
      }
void FXDial_setRange(FXDial *self,VALUE range){
      FXint lo,hi;
      FXRbRange2LoHi(range,lo,hi);
      self->setRange(lo,hi);
      }
VALUE FXDial_getRange(FXDial const *self){
      FXint lo,hi;
      self->getRange(lo,hi);
      return rb_range_new(INT2NUM(lo),INT2NUM(hi),0);
      }

swig_class cFXDial;
static void free_FXDial(FXDial *);
FXHeaderItem *new_FXHeaderItem(FXString const &text,FXIcon *ic,FXint s,void *ptr){
      return new FXRbHeaderItem(text,ic,s,ptr);
      }
void FXHeaderItem_setData(FXHeaderItem *self,VALUE ptr){
      self->setData((void*) ptr);
      }
VALUE FXHeaderItem_getData(FXHeaderItem const *self){
      return self->getData() ? (VALUE) self->getData() : Qnil;
      }

swig_class cFXHeaderItem;
static void free_FXHeaderItem(FXHeaderItem *);
FXHeader *new_FXHeader(FXComposite *p,FXObject *tgt,FXSelector sel,FXuint opts,FXint x,FXint y,FXint w,FXint h,FXint pl,FXint pr,FXint pt,FXint pb){
      return new FXRbHeader(p,tgt,sel,opts,x,y,w,h,pl,pr,pt,pb);
      }
FXint FXHeader_setItem__SWIG_0(FXHeader *self,FXint index,FXHeaderItem *item,FXbool notify){
      // Save pointer to the soon-to-be-destroyed item
      FXHeaderItem* oldItem=self->getItem(index);

      // Do the deed
      if(item->isMemberOf(FXMETACLASS(FXRbHeaderItem)))
	dynamic_cast<FXRbHeaderItem*>(item)->owned=1;
      FXint result=self->setItem(index,item,notify);

      // Now zero-out pointers held by still-alive Ruby objects
      FXRbUnregisterRubyObj(oldItem);

      // Done
      return result;
      }
FXint FXHeader_setItem__SWIG_1(FXHeader *self,FXint index,FXString const &text,FXIcon *icon,FXint size,void *ITEMDATA,FXbool notify){
      // Save pointer to the soon-to-be-destroyed item
      FXHeaderItem* oldItem=self->getItem(index);

      // Do the deed
      FXint result=self->setItem(index,text,icon,size,ITEMDATA,notify);

      // Now zero-out pointers held by still-alive Ruby objects
      FXRbUnregisterRubyObj(oldItem);

      // Done
      return result;
      }
FXint FXHeader_insertItem__SWIG_0(FXHeader *self,FXint index,FXHeaderItem *item,FXbool notify){
      if(item->isMemberOf(FXMETACLASS(FXRbHeaderItem)))
        dynamic_cast<FXRbHeaderItem*>(item)->owned=1;
      return self->insertItem(index,item,notify);
      }
FXint FXHeader_appendItem__SWIG_0(FXHeader *self,FXHeaderItem *item,FXbool notify){
      if(item->isMemberOf(FXMETACLASS(FXRbHeaderItem)))
        dynamic_cast<FXRbHeaderItem*>(item)->owned=1;
      return self->appendItem(item,notify);
      }
FXint FXHeader_prependItem__SWIG_0(FXHeader *self,FXHeaderItem *item,FXbool notify){
      if(item->isMemberOf(FXMETACLASS(FXRbHeaderItem)))
        dynamic_cast<FXRbHeaderItem*>(item)->owned=1;
      return self->prependItem(item,notify);
      }
void FXHeader_removeItem(FXHeader *self,FXint index,FXbool notify){
      // Save pointer to the soon-to-be-destroyed item
      FXHeaderItem* item=self->getItem(index);

      // Do the deed
      self->removeItem(index,notify);

      // Now zero-out pointers held by still-alive Ruby objects
      FXRbUnregisterRubyObj(item);
      }
void FXHeader_clearItems(FXHeader *self,FXbool notify){
      // Save pointers to the soon-to-be-destroyed items
      FXObjectListOf<FXHeaderItem> items;
      for (FXint i = 0; i < self->getNumItems(); i++) items.append(self->getItem(i));

      // Do the deed
      self->clearItems(notify);

      // Now zero-out pointers held by still-alive Ruby objects
      for (FXint j = 0; j < items.no(); j++) FXRbUnregisterRubyObj(items[j]);
      }
void FXHeader_setItemData(FXHeader *self,FXint index,VALUE ptr){
      self->setItemData(index, (void*) ptr);
      }
VALUE FXHeader_getItemData(FXHeader const *self,FXint index){
      return self->getItemData(index) ? (VALUE) self->getItemData(index) : Qnil;
      }

swig_class cFXHeader;
static void free_FXHeader(FXHeader *);
FXImageFrame *new_FXImageFrame(FXComposite *p,FXImage *img,FXuint opts,FXint x,FXint y,FXint w,FXint h,FXint pl,FXint pr,FXint pt,FXint pb){
      return new FXRbImageFrame(p,img,opts,x,y,w,h,pl,pr,pt,pb);
      }

swig_class cFXImageFrame;
static void free_FXImageFrame(FXImageFrame *);
FXBitmapFrame *new_FXBitmapFrame(FXComposite *p,FXBitmap *bmp,FXuint opts,FXint x,FXint y,FXint w,FXint h,FXint pl,FXint pr,FXint pt,FXint pb){
      return new FXRbBitmapFrame(p,bmp,opts,x,y,w,h,pl,pr,pt,pb);
    }

swig_class cFXBitmapFrame;
static void free_FXBitmapFrame(FXBitmapFrame *);
FXProgressBar *new_FXProgressBar(FXComposite *p,FXObject *target,FXSelector sel,FXuint opts,FXint x,FXint y,FXint w,FXint h,FXint pl,FXint pr,FXint pt,FXint pb){
      return new FXRbProgressBar(p,target,sel,opts,x,y,w,h,pl,pr,pt,pb);
      }

swig_class cFXProgressBar;
static void free_FXProgressBar(FXProgressBar *);
FXRuler *new_FXRuler(FXComposite *p,FXObject *tgt,FXSelector sel,FXuint opts,FXint x,FXint y,FXint w,FXint h,FXint pl,FXint pr,FXint pt,FXint pb){
      return new FXRbRuler(p,tgt,sel,opts,x,y,w,h,pl,pr,pt,pb);
      }

swig_class cFXRuler;
static void free_FXRuler(FXRuler *);
FXSeparator *new_FXSeparator(FXComposite *p,FXuint opts,FXint x,FXint y,FXint w,FXint h,FXint pl,FXint pr,FXint pt,FXint pb){
      return new FXRbSeparator(p,opts,x,y,w,h,pl,pr,pt,pb);
      }

swig_class cFXSeparator;
static void free_FXSeparator(FXSeparator *);
FXHorizontalSeparator *new_FXHorizontalSeparator(FXComposite *p,FXuint opts,FXint x,FXint y,FXint w,FXint h,FXint pl,FXint pr,FXint pt,FXint pb){
      return new FXRbHorizontalSeparator(p,opts,x,y,w,h,pl,pr,pt,pb);
      }

swig_class cFXHorizontalSeparator;
static void free_FXHorizontalSeparator(FXHorizontalSeparator *);
FXVerticalSeparator *new_FXVerticalSeparator(FXComposite *p,FXuint opts,FXint x,FXint y,FXint w,FXint h,FXint pl,FXint pr,FXint pt,FXint pb){
      return new FXRbVerticalSeparator(p,opts,x,y,w,h,pl,pr,pt,pb);
      }

swig_class cFXVerticalSeparator;
static void free_FXVerticalSeparator(FXVerticalSeparator *);
FXSlider *new_FXSlider(FXComposite *p,FXObject *tgt,FXSelector sel,FXuint opts,FXint x,FXint y,FXint w,FXint h,FXint pl,FXint pr,FXint pt,FXint pb){
      return new FXRbSlider(p,tgt,sel,opts,x,y,w,h,pl,pr,pt,pb);
      }
void FXSlider_setRange(FXSlider *self,VALUE range){
      FXint lo,hi;
      FXRbRange2LoHi(range,lo,hi);
      self->setRange(lo,hi);
      }
VALUE FXSlider_getRange(FXSlider const *self){
      FXint lo,hi;
      self->getRange(lo,hi);
      return rb_range_new(INT2NUM(lo),INT2NUM(hi),0);
      }

swig_class cFXSlider;
static void free_FXSlider(FXSlider *);
FXRealSlider *new_FXRealSlider(FXComposite *p,FXObject *tgt,FXSelector sel,FXuint opts,FXint x,FXint y,FXint w,FXint h,FXint pl,FXint pr,FXint pt,FXint pb){
      return new FXRbRealSlider(p,tgt,sel,opts,x,y,w,h,pl,pr,pt,pb);
      }
VALUE FXRealSlider_getRange(FXRealSlider const *self){
      FXdouble lo,hi;
      self->getRange(lo,hi);
      return rb_ary_new3(2,rb_float_new(lo),rb_float_new(hi));
      }

swig_class cFXRealSlider;
static void free_FXRealSlider(FXRealSlider *);
FXStatusLine *new_FXStatusLine(FXComposite *p,FXObject *tgt,FXSelector sel){
      return new FXRbStatusLine(p,tgt,sel);
      }

swig_class cFXStatusLine;
static void free_FXStatusLine(FXStatusLine *);
FXTextField *new_FXTextField(FXComposite *p,FXint ncols,FXObject *tgt,FXSelector sel,FXuint opts,FXint x,FXint y,FXint w,FXint h,FXint pl,FXint pr,FXint pt,FXint pb){
      return new FXRbTextField(p,ncols,tgt,sel,opts,x,y,w,h,pl,pr,pt,pb);
      }

swig_class cFXTextField;
static void free_FXTextField(FXTextField *);
FXToolBarTab *new_FXToolBarTab(FXComposite *p,FXObject *tgt,FXSelector sel,FXuint opts,FXint x,FXint y,FXint w,FXint h){
     return new FXRbToolBarTab(p,tgt,sel,opts,x,y,w,h);
     }

swig_class cFXToolBarTab;
static void free_FXToolBarTab(FXToolBarTab *);
static VALUE _wrap_FXArrowButton_onPaint(int argc, VALUE *argv, VALUE self) { FXArrowButton *arg1 = (FXArrowButton *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXArrowButton, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onPaint(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXArrowButton_onUpdate(int argc, VALUE *argv, VALUE self) { FXArrowButton *arg1 = (FXArrowButton *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXArrowButton, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onUpdate(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXArrowButton_onEnter(int argc, VALUE *argv, VALUE self) { FXArrowButton *arg1 = (FXArrowButton *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXArrowButton, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onEnter(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXArrowButton_onLeave(int argc, VALUE *argv, VALUE self) { FXArrowButton *arg1 = (FXArrowButton *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXArrowButton, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onLeave(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXArrowButton_onLeftBtnPress(int argc, VALUE *argv, VALUE self) { FXArrowButton *arg1 = (FXArrowButton *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXArrowButton, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onLeftBtnPress(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXArrowButton_onLeftBtnRelease(int argc, VALUE *argv, VALUE self) {
    FXArrowButton *arg1 = (FXArrowButton *) 0 ; FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ;
    long result; VALUE vresult = Qnil; if ((argc < 3) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXArrowButton, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onLeftBtnRelease(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXArrowButton_onUngrabbed(int argc, VALUE *argv, VALUE self) { FXArrowButton *arg1 = (FXArrowButton *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXArrowButton, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onUngrabbed(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXArrowButton_onRepeat(int argc, VALUE *argv, VALUE self) { FXArrowButton *arg1 = (FXArrowButton *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXArrowButton, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onRepeat(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXArrowButton_onAuto(int argc, VALUE *argv, VALUE self) { FXArrowButton *arg1 = (FXArrowButton *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXArrowButton, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onAuto(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXArrowButton_onKeyPress(int argc, VALUE *argv, VALUE self) { FXArrowButton *arg1 = (FXArrowButton *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXArrowButton, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onKeyPress(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXArrowButton_onKeyRelease(int argc, VALUE *argv, VALUE self) { FXArrowButton *arg1 = (FXArrowButton *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXArrowButton, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onKeyRelease(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXArrowButton_onHotKeyPress(int argc, VALUE *argv, VALUE self) { FXArrowButton *arg1 = (FXArrowButton *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXArrowButton, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onHotKeyPress(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXArrowButton_onHotKeyRelease(int argc, VALUE *argv, VALUE self) {
    FXArrowButton *arg1 = (FXArrowButton *) 0 ; FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ;
    long result; VALUE vresult = Qnil; if ((argc < 3) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXArrowButton, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onHotKeyRelease(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXArrowButton_onCmdSetHelp(int argc, VALUE *argv, VALUE self) { FXArrowButton *arg1 = (FXArrowButton *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; FXString value4 ;
    VALUE vresult = Qnil; if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXArrowButton, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); {
        value4 = FXString(STR2CSTR(argv[2])); arg4 = (void *) &value4; }  result = (long)(arg1)->onCmdSetHelp(arg2,arg3,arg4);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXArrowButton_onCmdGetHelp(int argc, VALUE *argv, VALUE self) { FXArrowButton *arg1 = (FXArrowButton *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXArrowButton, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdGetHelp(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXArrowButton_onCmdSetTip(int argc, VALUE *argv, VALUE self) { FXArrowButton *arg1 = (FXArrowButton *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; FXString value4 ;
    VALUE vresult = Qnil; if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXArrowButton, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); {
        value4 = FXString(STR2CSTR(argv[2])); arg4 = (void *) &value4; }  result = (long)(arg1)->onCmdSetTip(arg2,arg3,arg4);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXArrowButton_onCmdGetTip(int argc, VALUE *argv, VALUE self) { FXArrowButton *arg1 = (FXArrowButton *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXArrowButton, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdGetTip(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXArrowButton_onQueryHelp(int argc, VALUE *argv, VALUE self) { FXArrowButton *arg1 = (FXArrowButton *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXArrowButton, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onQueryHelp(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXArrowButton_onQueryTip(int argc, VALUE *argv, VALUE self) { FXArrowButton *arg1 = (FXArrowButton *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXArrowButton, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onQueryTip(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE _wrap_FXArrowButton_allocate(VALUE self) {
#else
     static VALUE _wrap_FXArrowButton_allocate(int argc, VALUE *argv, VALUE self) {
#endif
         VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_FXArrowButton);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
         return vresult; }
static VALUE _wrap_new_FXArrowButton(int argc, VALUE *argv, VALUE self) { FXComposite *arg1 = (FXComposite *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 = (FXSelector) 0 ; FXuint arg4 = (FXuint) ARROW_NORMAL ;
    FXint arg5 = (FXint) 0 ; FXint arg6 = (FXint) 0 ; FXint arg7 = (FXint) 0 ; FXint arg8 = (FXint) 0 ;
    FXint arg9 = (FXint) DEFAULT_PAD ; FXint arg10 = (FXint) DEFAULT_PAD ; FXint arg11 = (FXint) DEFAULT_PAD ;
    FXint arg12 = (FXint) DEFAULT_PAD ; FXArrowButton *result; if ((argc < 1) || (argc > 12))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXComposite, 1); if (argc > 1) {
        SWIG_ConvertPtr(argv[1], (void **) &arg2, SWIGTYPE_p_FXObject, 1); }  if (argc > 2) { arg3 = NUM2UINT(argv[2]); } 
    if (argc > 3) { arg4 = NUM2UINT(argv[3]); }  if (argc > 4) { arg5 = NUM2INT(argv[4]); }  if (argc > 5) {
        arg6 = NUM2INT(argv[5]); }  if (argc > 6) { arg7 = NUM2INT(argv[6]); }  if (argc > 7) { arg8 = NUM2INT(argv[7]); } 
    if (argc > 8) { arg9 = NUM2INT(argv[8]); }  if (argc > 9) { arg10 = NUM2INT(argv[9]); }  if (argc > 10) {
        arg11 = NUM2INT(argv[10]); }  if (argc > 11) { arg12 = NUM2INT(argv[11]); }  {
        result = (FXArrowButton *)new_FXArrowButton(arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8,arg9,arg10,arg11,arg12);
        DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result); if(rb_block_given_p()){ rb_yield(self); }  }  return self; }
static VALUE _wrap_FXArrowButton_setState(int argc, VALUE *argv, VALUE self) { FXArrowButton *arg1 = (FXArrowButton *) 0 ;
    FXbool arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXArrowButton, 1); arg2 = to_FXbool(argv[0]); (arg1)->setState(arg2);
    return Qnil; }
static VALUE _wrap_FXArrowButton_getState(int argc, VALUE *argv, VALUE self) { FXArrowButton *arg1 = (FXArrowButton *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXArrowButton, 1);
    result = (FXbool)((FXArrowButton const *)arg1)->getState(); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXArrowButton_setHelpText(int argc, VALUE *argv, VALUE self) { FXArrowButton *arg1 = (FXArrowButton *) 0 ;
    FXString *arg2 = 0 ; SwigValueWrapper<FXString > p2 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXArrowButton, 1); p2 = to_FXString(argv[0]); arg2 = &p2;
    (arg1)->setHelpText((FXString const &)*arg2); return Qnil; }
static VALUE _wrap_FXArrowButton_getHelpText(int argc, VALUE *argv, VALUE self) { FXArrowButton *arg1 = (FXArrowButton *) 0 ;
    FXString result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXArrowButton, 1); result = ((FXArrowButton const *)arg1)->getHelpText();
    vresult = rb_str_new2((&result)->text()); return vresult; }
static VALUE _wrap_FXArrowButton_setTipText(int argc, VALUE *argv, VALUE self) { FXArrowButton *arg1 = (FXArrowButton *) 0 ;
    FXString *arg2 = 0 ; SwigValueWrapper<FXString > p2 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXArrowButton, 1); p2 = to_FXString(argv[0]); arg2 = &p2;
    (arg1)->setTipText((FXString const &)*arg2); return Qnil; }
static VALUE _wrap_FXArrowButton_getTipText(int argc, VALUE *argv, VALUE self) { FXArrowButton *arg1 = (FXArrowButton *) 0 ;
    FXString result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXArrowButton, 1); result = ((FXArrowButton const *)arg1)->getTipText();
    vresult = rb_str_new2((&result)->text()); return vresult; }
static VALUE _wrap_FXArrowButton_setArrowStyle(int argc, VALUE *argv, VALUE self) { FXArrowButton *arg1 = (FXArrowButton *) 0 ;
    FXuint arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXArrowButton, 1); arg2 = NUM2UINT(argv[0]); (arg1)->setArrowStyle(arg2);
    return Qnil; }
static VALUE _wrap_FXArrowButton_getArrowStyle(int argc, VALUE *argv, VALUE self) { FXArrowButton *arg1 = (FXArrowButton *) 0 ;
    FXuint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXArrowButton, 1);
    result = (FXuint)((FXArrowButton const *)arg1)->getArrowStyle(); vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXArrowButton_setArrowSize(int argc, VALUE *argv, VALUE self) { FXArrowButton *arg1 = (FXArrowButton *) 0 ;
    FXint arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXArrowButton, 1); arg2 = NUM2INT(argv[0]); (arg1)->setArrowSize(arg2);
    return Qnil; }
static VALUE _wrap_FXArrowButton_getArrowSize(int argc, VALUE *argv, VALUE self) { FXArrowButton *arg1 = (FXArrowButton *) 0 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXArrowButton, 1);
    result = (FXint)((FXArrowButton const *)arg1)->getArrowSize(); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXArrowButton_setJustify(int argc, VALUE *argv, VALUE self) { FXArrowButton *arg1 = (FXArrowButton *) 0 ;
    FXuint arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXArrowButton, 1); arg2 = NUM2UINT(argv[0]); (arg1)->setJustify(arg2);
    return Qnil; }
static VALUE _wrap_FXArrowButton_getJustify(int argc, VALUE *argv, VALUE self) { FXArrowButton *arg1 = (FXArrowButton *) 0 ;
    FXuint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXArrowButton, 1);
    result = (FXuint)((FXArrowButton const *)arg1)->getJustify(); vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXArrowButton_getArrowColor(int argc, VALUE *argv, VALUE self) { FXArrowButton *arg1 = (FXArrowButton *) 0 ;
    FXColor result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXArrowButton, 1);
    result = (FXColor)((FXArrowButton const *)arg1)->getArrowColor(); vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXArrowButton_setArrowColor(int argc, VALUE *argv, VALUE self) { FXArrowButton *arg1 = (FXArrowButton *) 0 ;
    FXColor arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXArrowButton, 1); arg2 = to_FXColor(argv[0]);
    (arg1)->setArrowColor(arg2); return Qnil; }
static void
free_FXArrowButton(FXArrowButton *arg1) {
    delete arg1;
}
static VALUE _wrap_FXArrowButton_save(int argc, VALUE *argv, VALUE self) { FXArrowButton *arg1 = (FXArrowButton *) 0 ;
    FXStream *arg2 = 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXArrowButton, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXArrowButton_save((FXArrowButton const *)arg1,*arg2); return Qnil; }
static VALUE _wrap_FXArrowButton_load(int argc, VALUE *argv, VALUE self) { FXArrowButton *arg1 = (FXArrowButton *) 0 ;
    FXStream *arg2 = 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXArrowButton, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXArrowButton_load(arg1,*arg2); return Qnil; }
static VALUE _wrap_FXArrowButton_create(int argc, VALUE *argv, VALUE self) { FXArrowButton *arg1 = (FXArrowButton *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXArrowButton, 1); FXArrowButton_create(arg1); return Qnil; }
static VALUE _wrap_FXArrowButton_detach(int argc, VALUE *argv, VALUE self) { FXArrowButton *arg1 = (FXArrowButton *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXArrowButton, 1); FXArrowButton_detach(arg1); return Qnil; }
static VALUE _wrap_FXArrowButton_destroy(int argc, VALUE *argv, VALUE self) { FXArrowButton *arg1 = (FXArrowButton *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXArrowButton, 1); FXArrowButton_destroy(arg1); return Qnil; }
static VALUE _wrap_FXArrowButton_resize(int argc, VALUE *argv, VALUE self) { FXArrowButton *arg1 = (FXArrowButton *) 0 ;
    FXint arg2 ; FXint arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXArrowButton, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    FXArrowButton_resize(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXArrowButton_getDefaultWidth(int argc, VALUE *argv, VALUE self) {
    FXArrowButton *arg1 = (FXArrowButton *) 0 ; FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXArrowButton, 1); result = (FXint)FXArrowButton_getDefaultWidth(arg1);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXArrowButton_getDefaultHeight(int argc, VALUE *argv, VALUE self) {
    FXArrowButton *arg1 = (FXArrowButton *) 0 ; FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXArrowButton, 1); result = (FXint)FXArrowButton_getDefaultHeight(arg1);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXArrowButton_getWidthForHeight(int argc, VALUE *argv, VALUE self) {
    FXArrowButton *arg1 = (FXArrowButton *) 0 ; FXint arg2 ; FXint result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXArrowButton, 1); arg2 = NUM2INT(argv[0]);
    result = (FXint)FXArrowButton_getWidthForHeight(arg1,arg2); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXArrowButton_getHeightForWidth(int argc, VALUE *argv, VALUE self) {
    FXArrowButton *arg1 = (FXArrowButton *) 0 ; FXint arg2 ; FXint result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXArrowButton, 1); arg2 = NUM2INT(argv[0]);
    result = (FXint)FXArrowButton_getHeightForWidth(arg1,arg2); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXArrowButton_canFocus(int argc, VALUE *argv, VALUE self) { FXArrowButton *arg1 = (FXArrowButton *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXArrowButton, 1);
    result = (FXbool)FXArrowButton_canFocus((FXArrowButton const *)arg1); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXArrowButton_setFocus(int argc, VALUE *argv, VALUE self) { FXArrowButton *arg1 = (FXArrowButton *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXArrowButton, 1); FXArrowButton_setFocus(arg1); return Qnil; }
static VALUE _wrap_FXArrowButton_killFocus(int argc, VALUE *argv, VALUE self) { FXArrowButton *arg1 = (FXArrowButton *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXArrowButton, 1); FXArrowButton_killFocus(arg1); return Qnil; }
static VALUE _wrap_FXArrowButton_setDefault(int argc, VALUE *argv, VALUE self) { FXArrowButton *arg1 = (FXArrowButton *) 0 ;
    FXbool arg2 = (FXbool) 1 ; if ((argc < 0) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXArrowButton, 1); if (argc > 0) { arg2 = to_FXbool(argv[0]); } 
    FXArrowButton_setDefault(arg1,arg2); return Qnil; }
static VALUE _wrap_FXArrowButton_enable(int argc, VALUE *argv, VALUE self) { FXArrowButton *arg1 = (FXArrowButton *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXArrowButton, 1); FXArrowButton_enable(arg1); return Qnil; }
static VALUE _wrap_FXArrowButton_disable(int argc, VALUE *argv, VALUE self) { FXArrowButton *arg1 = (FXArrowButton *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXArrowButton, 1); FXArrowButton_disable(arg1); return Qnil; }
static VALUE _wrap_FXArrowButton_raiseWindow(int argc, VALUE *argv, VALUE self) { FXArrowButton *arg1 = (FXArrowButton *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXArrowButton, 1); FXArrowButton_raise(arg1); return Qnil; }
static VALUE _wrap_FXArrowButton_lower(int argc, VALUE *argv, VALUE self) { FXArrowButton *arg1 = (FXArrowButton *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXArrowButton, 1); FXArrowButton_lower(arg1); return Qnil; }
static VALUE _wrap_FXArrowButton_move(int argc, VALUE *argv, VALUE self) { FXArrowButton *arg1 = (FXArrowButton *) 0 ;
    FXint arg2 ; FXint arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXArrowButton, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    FXArrowButton_move(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXArrowButton_position(int argc, VALUE *argv, VALUE self) { FXArrowButton *arg1 = (FXArrowButton *) 0 ;
    FXint arg2 ; FXint arg3 ; FXint arg4 ; FXint arg5 ; if ((argc < 4) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXArrowButton, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    arg4 = NUM2INT(argv[2]); arg5 = NUM2INT(argv[3]); FXArrowButton_position(arg1,arg2,arg3,arg4,arg5); return Qnil; }
static VALUE _wrap_FXArrowButton_layout(int argc, VALUE *argv, VALUE self) { FXArrowButton *arg1 = (FXArrowButton *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXArrowButton, 1); FXArrowButton_layout(arg1); return Qnil; }
static VALUE _wrap_FXArrowButton_recalc(int argc, VALUE *argv, VALUE self) { FXArrowButton *arg1 = (FXArrowButton *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXArrowButton, 1); FXArrowButton_recalc(arg1); return Qnil; }
static VALUE _wrap_FXArrowButton_reparent(int argc, VALUE *argv, VALUE self) { FXArrowButton *arg1 = (FXArrowButton *) 0 ;
    FXComposite *arg2 = (FXComposite *) 0 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXArrowButton, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXComposite, 1); FXArrowButton_reparent(arg1,arg2); return Qnil; }
static VALUE _wrap_FXArrowButton_show(int argc, VALUE *argv, VALUE self) { FXArrowButton *arg1 = (FXArrowButton *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXArrowButton, 1); FXArrowButton_show(arg1); return Qnil; }
static VALUE _wrap_FXArrowButton_hide(int argc, VALUE *argv, VALUE self) { FXArrowButton *arg1 = (FXArrowButton *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXArrowButton, 1); FXArrowButton_hide(arg1); return Qnil; }
static VALUE _wrap_FXArrowButton_isComposite(int argc, VALUE *argv, VALUE self) { FXArrowButton *arg1 = (FXArrowButton *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXArrowButton, 1);
    result = (FXbool)FXArrowButton_isComposite((FXArrowButton const *)arg1); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXArrowButton_contains(int argc, VALUE *argv, VALUE self) { FXArrowButton *arg1 = (FXArrowButton *) 0 ;
    FXint arg2 ; FXint arg3 ; FXbool result; VALUE vresult = Qnil; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXArrowButton, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    result = (FXbool)FXArrowButton_contains((FXArrowButton const *)arg1,arg2,arg3); vresult = result ? Qtrue : Qfalse;
    return vresult; }
static VALUE _wrap_FXArrowButton_doesSaveUnder(int argc, VALUE *argv, VALUE self) { FXArrowButton *arg1 = (FXArrowButton *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXArrowButton, 1);
    result = (FXbool)FXArrowButton_doesSaveUnder((FXArrowButton const *)arg1); vresult = result ? Qtrue : Qfalse;
    return vresult; }
static VALUE _wrap_FXArrowButton_setBackColor(int argc, VALUE *argv, VALUE self) { FXArrowButton *arg1 = (FXArrowButton *) 0 ;
    FXColor arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXArrowButton, 1); arg2 = to_FXColor(argv[0]);
    FXArrowButton_setBackColor(arg1,arg2); return Qnil; }
static VALUE _wrap_FXColorBar_onPaint(int argc, VALUE *argv, VALUE self) { FXColorBar *arg1 = (FXColorBar *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorBar, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onPaint(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXColorBar_onLeftBtnPress(int argc, VALUE *argv, VALUE self) { FXColorBar *arg1 = (FXColorBar *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorBar, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onLeftBtnPress(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXColorBar_onLeftBtnRelease(int argc, VALUE *argv, VALUE self) { FXColorBar *arg1 = (FXColorBar *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorBar, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onLeftBtnRelease(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXColorBar_onMotion(int argc, VALUE *argv, VALUE self) { FXColorBar *arg1 = (FXColorBar *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorBar, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onMotion(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXColorBar_onCmdSetHelp(int argc, VALUE *argv, VALUE self) { FXColorBar *arg1 = (FXColorBar *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; FXString value4 ;
    VALUE vresult = Qnil; if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorBar, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); {
        value4 = FXString(STR2CSTR(argv[2])); arg4 = (void *) &value4; }  result = (long)(arg1)->onCmdSetHelp(arg2,arg3,arg4);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXColorBar_onCmdGetHelp(int argc, VALUE *argv, VALUE self) { FXColorBar *arg1 = (FXColorBar *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorBar, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdGetHelp(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXColorBar_onCmdSetTip(int argc, VALUE *argv, VALUE self) { FXColorBar *arg1 = (FXColorBar *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; FXString value4 ;
    VALUE vresult = Qnil; if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorBar, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); {
        value4 = FXString(STR2CSTR(argv[2])); arg4 = (void *) &value4; }  result = (long)(arg1)->onCmdSetTip(arg2,arg3,arg4);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXColorBar_onCmdGetTip(int argc, VALUE *argv, VALUE self) { FXColorBar *arg1 = (FXColorBar *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorBar, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdGetTip(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXColorBar_onQueryHelp(int argc, VALUE *argv, VALUE self) { FXColorBar *arg1 = (FXColorBar *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorBar, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onQueryHelp(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXColorBar_onQueryTip(int argc, VALUE *argv, VALUE self) { FXColorBar *arg1 = (FXColorBar *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorBar, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onQueryTip(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE _wrap_FXColorBar_allocate(VALUE self) {
#else
     static VALUE _wrap_FXColorBar_allocate(int argc, VALUE *argv, VALUE self) {
#endif
         VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_FXColorBar);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
         return vresult; }
static VALUE _wrap_new_FXColorBar(int argc, VALUE *argv, VALUE self) { FXComposite *arg1 = (FXComposite *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 = (FXSelector) 0 ; FXuint arg4 = (FXuint) FRAME_NORMAL ;
    FXint arg5 = (FXint) 0 ; FXint arg6 = (FXint) 0 ; FXint arg7 = (FXint) 0 ; FXint arg8 = (FXint) 0 ;
    FXint arg9 = (FXint) DEFAULT_PAD ; FXint arg10 = (FXint) DEFAULT_PAD ; FXint arg11 = (FXint) DEFAULT_PAD ;
    FXint arg12 = (FXint) DEFAULT_PAD ; FXColorBar *result; if ((argc < 1) || (argc > 12))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXComposite, 1); if (argc > 1) {
        SWIG_ConvertPtr(argv[1], (void **) &arg2, SWIGTYPE_p_FXObject, 1); }  if (argc > 2) { arg3 = NUM2UINT(argv[2]); } 
    if (argc > 3) { arg4 = NUM2UINT(argv[3]); }  if (argc > 4) { arg5 = NUM2INT(argv[4]); }  if (argc > 5) {
        arg6 = NUM2INT(argv[5]); }  if (argc > 6) { arg7 = NUM2INT(argv[6]); }  if (argc > 7) { arg8 = NUM2INT(argv[7]); } 
    if (argc > 8) { arg9 = NUM2INT(argv[8]); }  if (argc > 9) { arg10 = NUM2INT(argv[9]); }  if (argc > 10) {
        arg11 = NUM2INT(argv[10]); }  if (argc > 11) { arg12 = NUM2INT(argv[11]); }  {
        result = (FXColorBar *)new_FXColorBar(arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8,arg9,arg10,arg11,arg12);
        DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result); if(rb_block_given_p()){ rb_yield(self); }  }  return self; }
static VALUE _wrap_FXColorBar_setHue(int argc, VALUE *argv, VALUE self) { FXColorBar *arg1 = (FXColorBar *) 0 ; FXfloat arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorBar, 1); arg2 = (FXfloat) NUM2DBL(argv[0]); (arg1)->setHue(arg2);
    return Qnil; }
static VALUE _wrap_FXColorBar_getHue(int argc, VALUE *argv, VALUE self) { FXColorBar *arg1 = (FXColorBar *) 0 ; FXfloat result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorBar, 1); result = (FXfloat)((FXColorBar const *)arg1)->getHue();
    vresult = rb_float_new(result); return vresult; }
static VALUE _wrap_FXColorBar_setSat(int argc, VALUE *argv, VALUE self) { FXColorBar *arg1 = (FXColorBar *) 0 ; FXfloat arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorBar, 1); arg2 = (FXfloat) NUM2DBL(argv[0]); (arg1)->setSat(arg2);
    return Qnil; }
static VALUE _wrap_FXColorBar_getSat(int argc, VALUE *argv, VALUE self) { FXColorBar *arg1 = (FXColorBar *) 0 ; FXfloat result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorBar, 1); result = (FXfloat)((FXColorBar const *)arg1)->getSat();
    vresult = rb_float_new(result); return vresult; }
static VALUE _wrap_FXColorBar_setVal(int argc, VALUE *argv, VALUE self) { FXColorBar *arg1 = (FXColorBar *) 0 ; FXfloat arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorBar, 1); arg2 = (FXfloat) NUM2DBL(argv[0]); (arg1)->setVal(arg2);
    return Qnil; }
static VALUE _wrap_FXColorBar_getVal(int argc, VALUE *argv, VALUE self) { FXColorBar *arg1 = (FXColorBar *) 0 ; FXfloat result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorBar, 1); result = (FXfloat)((FXColorBar const *)arg1)->getVal();
    vresult = rb_float_new(result); return vresult; }
static VALUE _wrap_FXColorBar_getBarStyle(int argc, VALUE *argv, VALUE self) { FXColorBar *arg1 = (FXColorBar *) 0 ;
    FXuint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorBar, 1);
    result = (FXuint)((FXColorBar const *)arg1)->getBarStyle(); vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXColorBar_setBarStyle(int argc, VALUE *argv, VALUE self) { FXColorBar *arg1 = (FXColorBar *) 0 ;
    FXuint arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorBar, 1); arg2 = NUM2UINT(argv[0]); (arg1)->setBarStyle(arg2);
    return Qnil; }
static VALUE _wrap_FXColorBar_setHelpText(int argc, VALUE *argv, VALUE self) { FXColorBar *arg1 = (FXColorBar *) 0 ;
    FXString *arg2 = 0 ; SwigValueWrapper<FXString > p2 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorBar, 1); p2 = to_FXString(argv[0]); arg2 = &p2;
    (arg1)->setHelpText((FXString const &)*arg2); return Qnil; }
static VALUE _wrap_FXColorBar_getHelpText(int argc, VALUE *argv, VALUE self) { FXColorBar *arg1 = (FXColorBar *) 0 ;
    FXString result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorBar, 1); result = ((FXColorBar const *)arg1)->getHelpText();
    vresult = rb_str_new2((&result)->text()); return vresult; }
static VALUE _wrap_FXColorBar_setTipText(int argc, VALUE *argv, VALUE self) { FXColorBar *arg1 = (FXColorBar *) 0 ;
    FXString *arg2 = 0 ; SwigValueWrapper<FXString > p2 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorBar, 1); p2 = to_FXString(argv[0]); arg2 = &p2;
    (arg1)->setTipText((FXString const &)*arg2); return Qnil; }
static VALUE _wrap_FXColorBar_getTipText(int argc, VALUE *argv, VALUE self) { FXColorBar *arg1 = (FXColorBar *) 0 ;
    FXString result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorBar, 1); result = ((FXColorBar const *)arg1)->getTipText();
    vresult = rb_str_new2((&result)->text()); return vresult; }
static void
free_FXColorBar(FXColorBar *arg1) {
    delete arg1;
}
static VALUE _wrap_FXColorBar_save(int argc, VALUE *argv, VALUE self) { FXColorBar *arg1 = (FXColorBar *) 0 ;
    FXStream *arg2 = 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorBar, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXColorBar_save((FXColorBar const *)arg1,*arg2); return Qnil; }
static VALUE _wrap_FXColorBar_load(int argc, VALUE *argv, VALUE self) { FXColorBar *arg1 = (FXColorBar *) 0 ;
    FXStream *arg2 = 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorBar, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXColorBar_load(arg1,*arg2); return Qnil; }
static VALUE _wrap_FXColorBar_create(int argc, VALUE *argv, VALUE self) { FXColorBar *arg1 = (FXColorBar *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorBar, 1); FXColorBar_create(arg1); return Qnil; }
static VALUE _wrap_FXColorBar_detach(int argc, VALUE *argv, VALUE self) { FXColorBar *arg1 = (FXColorBar *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorBar, 1); FXColorBar_detach(arg1); return Qnil; }
static VALUE _wrap_FXColorBar_destroy(int argc, VALUE *argv, VALUE self) { FXColorBar *arg1 = (FXColorBar *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorBar, 1); FXColorBar_destroy(arg1); return Qnil; }
static VALUE _wrap_FXColorBar_resize(int argc, VALUE *argv, VALUE self) { FXColorBar *arg1 = (FXColorBar *) 0 ; FXint arg2 ;
    FXint arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorBar, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    FXColorBar_resize(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXColorBar_getDefaultWidth(int argc, VALUE *argv, VALUE self) { FXColorBar *arg1 = (FXColorBar *) 0 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorBar, 1); result = (FXint)FXColorBar_getDefaultWidth(arg1);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXColorBar_getDefaultHeight(int argc, VALUE *argv, VALUE self) { FXColorBar *arg1 = (FXColorBar *) 0 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorBar, 1); result = (FXint)FXColorBar_getDefaultHeight(arg1);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXColorBar_getWidthForHeight(int argc, VALUE *argv, VALUE self) { FXColorBar *arg1 = (FXColorBar *) 0 ;
    FXint arg2 ; FXint result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorBar, 1); arg2 = NUM2INT(argv[0]);
    result = (FXint)FXColorBar_getWidthForHeight(arg1,arg2); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXColorBar_getHeightForWidth(int argc, VALUE *argv, VALUE self) { FXColorBar *arg1 = (FXColorBar *) 0 ;
    FXint arg2 ; FXint result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorBar, 1); arg2 = NUM2INT(argv[0]);
    result = (FXint)FXColorBar_getHeightForWidth(arg1,arg2); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXColorBar_canFocus(int argc, VALUE *argv, VALUE self) { FXColorBar *arg1 = (FXColorBar *) 0 ; FXbool result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorBar, 1);
    result = (FXbool)FXColorBar_canFocus((FXColorBar const *)arg1); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXColorBar_setFocus(int argc, VALUE *argv, VALUE self) { FXColorBar *arg1 = (FXColorBar *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorBar, 1); FXColorBar_setFocus(arg1); return Qnil; }
static VALUE _wrap_FXColorBar_killFocus(int argc, VALUE *argv, VALUE self) { FXColorBar *arg1 = (FXColorBar *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorBar, 1); FXColorBar_killFocus(arg1); return Qnil; }
static VALUE _wrap_FXColorBar_setDefault(int argc, VALUE *argv, VALUE self) { FXColorBar *arg1 = (FXColorBar *) 0 ;
    FXbool arg2 = (FXbool) 1 ; if ((argc < 0) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorBar, 1); if (argc > 0) { arg2 = to_FXbool(argv[0]); } 
    FXColorBar_setDefault(arg1,arg2); return Qnil; }
static VALUE _wrap_FXColorBar_enable(int argc, VALUE *argv, VALUE self) { FXColorBar *arg1 = (FXColorBar *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorBar, 1); FXColorBar_enable(arg1); return Qnil; }
static VALUE _wrap_FXColorBar_disable(int argc, VALUE *argv, VALUE self) { FXColorBar *arg1 = (FXColorBar *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorBar, 1); FXColorBar_disable(arg1); return Qnil; }
static VALUE _wrap_FXColorBar_raiseWindow(int argc, VALUE *argv, VALUE self) { FXColorBar *arg1 = (FXColorBar *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorBar, 1); FXColorBar_raise(arg1); return Qnil; }
static VALUE _wrap_FXColorBar_lower(int argc, VALUE *argv, VALUE self) { FXColorBar *arg1 = (FXColorBar *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorBar, 1); FXColorBar_lower(arg1); return Qnil; }
static VALUE _wrap_FXColorBar_move(int argc, VALUE *argv, VALUE self) { FXColorBar *arg1 = (FXColorBar *) 0 ; FXint arg2 ;
    FXint arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorBar, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    FXColorBar_move(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXColorBar_position(int argc, VALUE *argv, VALUE self) { FXColorBar *arg1 = (FXColorBar *) 0 ; FXint arg2 ;
    FXint arg3 ; FXint arg4 ; FXint arg5 ; if ((argc < 4) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorBar, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    arg4 = NUM2INT(argv[2]); arg5 = NUM2INT(argv[3]); FXColorBar_position(arg1,arg2,arg3,arg4,arg5); return Qnil; }
static VALUE _wrap_FXColorBar_layout(int argc, VALUE *argv, VALUE self) { FXColorBar *arg1 = (FXColorBar *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorBar, 1); FXColorBar_layout(arg1); return Qnil; }
static VALUE _wrap_FXColorBar_recalc(int argc, VALUE *argv, VALUE self) { FXColorBar *arg1 = (FXColorBar *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorBar, 1); FXColorBar_recalc(arg1); return Qnil; }
static VALUE _wrap_FXColorBar_reparent(int argc, VALUE *argv, VALUE self) { FXColorBar *arg1 = (FXColorBar *) 0 ;
    FXComposite *arg2 = (FXComposite *) 0 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorBar, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXComposite, 1); FXColorBar_reparent(arg1,arg2); return Qnil; }
static VALUE _wrap_FXColorBar_show(int argc, VALUE *argv, VALUE self) { FXColorBar *arg1 = (FXColorBar *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorBar, 1); FXColorBar_show(arg1); return Qnil; }
static VALUE _wrap_FXColorBar_hide(int argc, VALUE *argv, VALUE self) { FXColorBar *arg1 = (FXColorBar *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorBar, 1); FXColorBar_hide(arg1); return Qnil; }
static VALUE _wrap_FXColorBar_isComposite(int argc, VALUE *argv, VALUE self) { FXColorBar *arg1 = (FXColorBar *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorBar, 1);
    result = (FXbool)FXColorBar_isComposite((FXColorBar const *)arg1); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXColorBar_contains(int argc, VALUE *argv, VALUE self) { FXColorBar *arg1 = (FXColorBar *) 0 ; FXint arg2 ;
    FXint arg3 ; FXbool result; VALUE vresult = Qnil; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorBar, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    result = (FXbool)FXColorBar_contains((FXColorBar const *)arg1,arg2,arg3); vresult = result ? Qtrue : Qfalse;
    return vresult; }
static VALUE _wrap_FXColorBar_doesSaveUnder(int argc, VALUE *argv, VALUE self) { FXColorBar *arg1 = (FXColorBar *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorBar, 1);
    result = (FXbool)FXColorBar_doesSaveUnder((FXColorBar const *)arg1); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXColorBar_setBackColor(int argc, VALUE *argv, VALUE self) { FXColorBar *arg1 = (FXColorBar *) 0 ;
    FXColor arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorBar, 1); arg2 = to_FXColor(argv[0]);
    FXColorBar_setBackColor(arg1,arg2); return Qnil; }
static VALUE _wrap_FXColorWell_onPaint(int argc, VALUE *argv, VALUE self) { FXColorWell *arg1 = (FXColorWell *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorWell, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onPaint(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXColorWell_onLeftBtnPress(int argc, VALUE *argv, VALUE self) { FXColorWell *arg1 = (FXColorWell *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorWell, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onLeftBtnPress(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXColorWell_onLeftBtnRelease(int argc, VALUE *argv, VALUE self) { FXColorWell *arg1 = (FXColorWell *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorWell, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onLeftBtnRelease(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXColorWell_onMiddleBtnPress(int argc, VALUE *argv, VALUE self) { FXColorWell *arg1 = (FXColorWell *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorWell, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onMiddleBtnPress(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXColorWell_onMiddleBtnRelease(int argc, VALUE *argv, VALUE self) { FXColorWell *arg1 = (FXColorWell *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorWell, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onMiddleBtnRelease(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXColorWell_onKeyPress(int argc, VALUE *argv, VALUE self) { FXColorWell *arg1 = (FXColorWell *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorWell, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onKeyPress(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXColorWell_onKeyRelease(int argc, VALUE *argv, VALUE self) { FXColorWell *arg1 = (FXColorWell *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorWell, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onKeyRelease(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXColorWell_onUngrabbed(int argc, VALUE *argv, VALUE self) { FXColorWell *arg1 = (FXColorWell *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorWell, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onUngrabbed(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXColorWell_onMotion(int argc, VALUE *argv, VALUE self) { FXColorWell *arg1 = (FXColorWell *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorWell, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onMotion(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXColorWell_onBeginDrag(int argc, VALUE *argv, VALUE self) { FXColorWell *arg1 = (FXColorWell *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorWell, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onBeginDrag(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXColorWell_onEndDrag(int argc, VALUE *argv, VALUE self) { FXColorWell *arg1 = (FXColorWell *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorWell, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onEndDrag(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXColorWell_onDragged(int argc, VALUE *argv, VALUE self) { FXColorWell *arg1 = (FXColorWell *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorWell, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onDragged(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXColorWell_onFocusIn(int argc, VALUE *argv, VALUE self) { FXColorWell *arg1 = (FXColorWell *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorWell, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onFocusIn(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXColorWell_onFocusOut(int argc, VALUE *argv, VALUE self) { FXColorWell *arg1 = (FXColorWell *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorWell, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onFocusOut(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXColorWell_onDNDEnter(int argc, VALUE *argv, VALUE self) { FXColorWell *arg1 = (FXColorWell *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorWell, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onDNDEnter(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXColorWell_onDNDLeave(int argc, VALUE *argv, VALUE self) { FXColorWell *arg1 = (FXColorWell *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorWell, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onDNDLeave(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXColorWell_onDNDMotion(int argc, VALUE *argv, VALUE self) { FXColorWell *arg1 = (FXColorWell *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorWell, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onDNDMotion(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXColorWell_onDNDDrop(int argc, VALUE *argv, VALUE self) { FXColorWell *arg1 = (FXColorWell *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorWell, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onDNDDrop(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXColorWell_onDNDRequest(int argc, VALUE *argv, VALUE self) { FXColorWell *arg1 = (FXColorWell *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorWell, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onDNDRequest(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXColorWell_onSelectionLost(int argc, VALUE *argv, VALUE self) { FXColorWell *arg1 = (FXColorWell *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorWell, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onSelectionLost(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXColorWell_onSelectionGained(int argc, VALUE *argv, VALUE self) { FXColorWell *arg1 = (FXColorWell *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorWell, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onSelectionGained(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXColorWell_onSelectionRequest(int argc, VALUE *argv, VALUE self) { FXColorWell *arg1 = (FXColorWell *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorWell, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onSelectionRequest(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXColorWell_onChanged(int argc, VALUE *argv, VALUE self) { FXColorWell *arg1 = (FXColorWell *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorWell, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]);
    arg4 = reinterpret_cast<void*>(NUM2UINT(argv[2])); result = (long)(arg1)->onChanged(arg2,arg3,arg4);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXColorWell_onCommand(int argc, VALUE *argv, VALUE self) { FXColorWell *arg1 = (FXColorWell *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorWell, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCommand(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXColorWell_onClicked(int argc, VALUE *argv, VALUE self) { FXColorWell *arg1 = (FXColorWell *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorWell, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onClicked(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXColorWell_onDoubleClicked(int argc, VALUE *argv, VALUE self) { FXColorWell *arg1 = (FXColorWell *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorWell, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onDoubleClicked(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXColorWell_onTripleClicked(int argc, VALUE *argv, VALUE self) { FXColorWell *arg1 = (FXColorWell *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorWell, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onTripleClicked(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXColorWell_onCmdSetValue(int argc, VALUE *argv, VALUE self) { FXColorWell *arg1 = (FXColorWell *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorWell, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]);
    arg4 = reinterpret_cast<void*>(NUM2UINT(argv[2])); result = (long)(arg1)->onCmdSetValue(arg2,arg3,arg4);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXColorWell_onCmdSetIntValue(int argc, VALUE *argv, VALUE self) { FXColorWell *arg1 = (FXColorWell *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorWell, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdSetIntValue(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXColorWell_onCmdGetIntValue(int argc, VALUE *argv, VALUE self) { FXColorWell *arg1 = (FXColorWell *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorWell, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdGetIntValue(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXColorWell_onCmdColorWell(int argc, VALUE *argv, VALUE self) { FXColorWell *arg1 = (FXColorWell *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorWell, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]);
    arg4 = reinterpret_cast<void*>(NUM2UINT(argv[2])); result = (long)(arg1)->onCmdColorWell(arg2,arg3,arg4);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXColorWell_onChgColorWell(int argc, VALUE *argv, VALUE self) { FXColorWell *arg1 = (FXColorWell *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorWell, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]);
    arg4 = reinterpret_cast<void*>(NUM2UINT(argv[2])); result = (long)(arg1)->onChgColorWell(arg2,arg3,arg4);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXColorWell_onCmdSetHelp(int argc, VALUE *argv, VALUE self) { FXColorWell *arg1 = (FXColorWell *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; FXString value4 ;
    VALUE vresult = Qnil; if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorWell, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); {
        value4 = FXString(STR2CSTR(argv[2])); arg4 = (void *) &value4; }  result = (long)(arg1)->onCmdSetHelp(arg2,arg3,arg4);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXColorWell_onCmdGetHelp(int argc, VALUE *argv, VALUE self) { FXColorWell *arg1 = (FXColorWell *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorWell, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdGetHelp(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXColorWell_onCmdSetTip(int argc, VALUE *argv, VALUE self) { FXColorWell *arg1 = (FXColorWell *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; FXString value4 ;
    VALUE vresult = Qnil; if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorWell, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); {
        value4 = FXString(STR2CSTR(argv[2])); arg4 = (void *) &value4; }  result = (long)(arg1)->onCmdSetTip(arg2,arg3,arg4);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXColorWell_onCmdGetTip(int argc, VALUE *argv, VALUE self) { FXColorWell *arg1 = (FXColorWell *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorWell, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdGetTip(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXColorWell_onQueryHelp(int argc, VALUE *argv, VALUE self) { FXColorWell *arg1 = (FXColorWell *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorWell, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onQueryHelp(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXColorWell_onQueryTip(int argc, VALUE *argv, VALUE self) { FXColorWell *arg1 = (FXColorWell *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorWell, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onQueryTip(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE _wrap_FXColorWell_allocate(VALUE self) {
#else
     static VALUE _wrap_FXColorWell_allocate(int argc, VALUE *argv, VALUE self) {
#endif
         VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_FXColorWell);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
         return vresult; }
static VALUE _wrap_new_FXColorWell(int argc, VALUE *argv, VALUE self) { FXComposite *arg1 = (FXComposite *) 0 ;
    FXColor arg2 = (FXColor) 0 ; FXObject *arg3 = (FXObject *) 0 ; FXSelector arg4 = (FXSelector) 0 ;
    FXuint arg5 = (FXuint) COLORWELL_NORMAL ; FXint arg6 = (FXint) 0 ; FXint arg7 = (FXint) 0 ; FXint arg8 = (FXint) 0 ;
    FXint arg9 = (FXint) 0 ; FXint arg10 = (FXint) DEFAULT_PAD ; FXint arg11 = (FXint) DEFAULT_PAD ;
    FXint arg12 = (FXint) DEFAULT_PAD ; FXint arg13 = (FXint) DEFAULT_PAD ; FXColorWell *result; if ((argc < 1) || (argc > 13))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXComposite, 1); if (argc > 1) { arg2 = to_FXColor(argv[1]); } 
    if (argc > 2) { SWIG_ConvertPtr(argv[2], (void **) &arg3, SWIGTYPE_p_FXObject, 1); }  if (argc > 3) {
        arg4 = NUM2UINT(argv[3]); }  if (argc > 4) { arg5 = NUM2UINT(argv[4]); }  if (argc > 5) { arg6 = NUM2INT(argv[5]); } 
    if (argc > 6) { arg7 = NUM2INT(argv[6]); }  if (argc > 7) { arg8 = NUM2INT(argv[7]); }  if (argc > 8) {
        arg9 = NUM2INT(argv[8]); }  if (argc > 9) { arg10 = NUM2INT(argv[9]); }  if (argc > 10) { arg11 = NUM2INT(argv[10]); } 
    if (argc > 11) { arg12 = NUM2INT(argv[11]); }  if (argc > 12) { arg13 = NUM2INT(argv[12]); }  {
        result = (FXColorWell *)new_FXColorWell(arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8,arg9,arg10,arg11,arg12,arg13);
        DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result); if(rb_block_given_p()){ rb_yield(self); }  }  return self; }
static VALUE _wrap_FXColorWell_setRGBA(int argc, VALUE *argv, VALUE self) { FXColorWell *arg1 = (FXColorWell *) 0 ;
    FXColor arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorWell, 1); arg2 = to_FXColor(argv[0]); (arg1)->setRGBA(arg2);
    return Qnil; }
static VALUE _wrap_FXColorWell_getRGBA(int argc, VALUE *argv, VALUE self) { FXColorWell *arg1 = (FXColorWell *) 0 ;
    FXColor result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorWell, 1); result = (FXColor)((FXColorWell const *)arg1)->getRGBA();
    vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXColorWell_setHelpText(int argc, VALUE *argv, VALUE self) { FXColorWell *arg1 = (FXColorWell *) 0 ;
    FXString *arg2 = 0 ; SwigValueWrapper<FXString > p2 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorWell, 1); p2 = to_FXString(argv[0]); arg2 = &p2;
    (arg1)->setHelpText((FXString const &)*arg2); return Qnil; }
static VALUE _wrap_FXColorWell_getHelpText(int argc, VALUE *argv, VALUE self) { FXColorWell *arg1 = (FXColorWell *) 0 ;
    FXString result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorWell, 1); result = ((FXColorWell const *)arg1)->getHelpText();
    vresult = rb_str_new2((&result)->text()); return vresult; }
static VALUE _wrap_FXColorWell_setTipText(int argc, VALUE *argv, VALUE self) { FXColorWell *arg1 = (FXColorWell *) 0 ;
    FXString *arg2 = 0 ; SwigValueWrapper<FXString > p2 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorWell, 1); p2 = to_FXString(argv[0]); arg2 = &p2;
    (arg1)->setTipText((FXString const &)*arg2); return Qnil; }
static VALUE _wrap_FXColorWell_getTipText(int argc, VALUE *argv, VALUE self) { FXColorWell *arg1 = (FXColorWell *) 0 ;
    FXString result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorWell, 1); result = ((FXColorWell const *)arg1)->getTipText();
    vresult = rb_str_new2((&result)->text()); return vresult; }
static VALUE _wrap_FXColorWell_isOpaqueOnly(int argc, VALUE *argv, VALUE self) { FXColorWell *arg1 = (FXColorWell *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorWell, 1);
    result = (FXbool)((FXColorWell const *)arg1)->isOpaqueOnly(); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXColorWell_setOpaqueOnly(int argc, VALUE *argv, VALUE self) { FXColorWell *arg1 = (FXColorWell *) 0 ;
    FXbool arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorWell, 1); arg2 = to_FXbool(argv[0]); (arg1)->setOpaqueOnly(arg2);
    return Qnil; }
static void
free_FXColorWell(FXColorWell *arg1) {
    delete arg1;
}
static VALUE _wrap_FXColorWell_save(int argc, VALUE *argv, VALUE self) { FXColorWell *arg1 = (FXColorWell *) 0 ;
    FXStream *arg2 = 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorWell, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXColorWell_save((FXColorWell const *)arg1,*arg2); return Qnil; }
static VALUE _wrap_FXColorWell_load(int argc, VALUE *argv, VALUE self) { FXColorWell *arg1 = (FXColorWell *) 0 ;
    FXStream *arg2 = 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorWell, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXColorWell_load(arg1,*arg2); return Qnil; }
static VALUE _wrap_FXColorWell_create(int argc, VALUE *argv, VALUE self) { FXColorWell *arg1 = (FXColorWell *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorWell, 1); FXColorWell_create(arg1); return Qnil; }
static VALUE _wrap_FXColorWell_detach(int argc, VALUE *argv, VALUE self) { FXColorWell *arg1 = (FXColorWell *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorWell, 1); FXColorWell_detach(arg1); return Qnil; }
static VALUE _wrap_FXColorWell_destroy(int argc, VALUE *argv, VALUE self) { FXColorWell *arg1 = (FXColorWell *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorWell, 1); FXColorWell_destroy(arg1); return Qnil; }
static VALUE _wrap_FXColorWell_resize(int argc, VALUE *argv, VALUE self) { FXColorWell *arg1 = (FXColorWell *) 0 ; FXint arg2 ;
    FXint arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorWell, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    FXColorWell_resize(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXColorWell_getDefaultWidth(int argc, VALUE *argv, VALUE self) { FXColorWell *arg1 = (FXColorWell *) 0 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorWell, 1); result = (FXint)FXColorWell_getDefaultWidth(arg1);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXColorWell_getDefaultHeight(int argc, VALUE *argv, VALUE self) { FXColorWell *arg1 = (FXColorWell *) 0 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorWell, 1); result = (FXint)FXColorWell_getDefaultHeight(arg1);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXColorWell_getWidthForHeight(int argc, VALUE *argv, VALUE self) { FXColorWell *arg1 = (FXColorWell *) 0 ;
    FXint arg2 ; FXint result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorWell, 1); arg2 = NUM2INT(argv[0]);
    result = (FXint)FXColorWell_getWidthForHeight(arg1,arg2); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXColorWell_getHeightForWidth(int argc, VALUE *argv, VALUE self) { FXColorWell *arg1 = (FXColorWell *) 0 ;
    FXint arg2 ; FXint result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorWell, 1); arg2 = NUM2INT(argv[0]);
    result = (FXint)FXColorWell_getHeightForWidth(arg1,arg2); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXColorWell_canFocus(int argc, VALUE *argv, VALUE self) { FXColorWell *arg1 = (FXColorWell *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorWell, 1);
    result = (FXbool)FXColorWell_canFocus((FXColorWell const *)arg1); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXColorWell_setFocus(int argc, VALUE *argv, VALUE self) { FXColorWell *arg1 = (FXColorWell *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorWell, 1); FXColorWell_setFocus(arg1); return Qnil; }
static VALUE _wrap_FXColorWell_killFocus(int argc, VALUE *argv, VALUE self) { FXColorWell *arg1 = (FXColorWell *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorWell, 1); FXColorWell_killFocus(arg1); return Qnil; }
static VALUE _wrap_FXColorWell_setDefault(int argc, VALUE *argv, VALUE self) { FXColorWell *arg1 = (FXColorWell *) 0 ;
    FXbool arg2 = (FXbool) 1 ; if ((argc < 0) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorWell, 1); if (argc > 0) { arg2 = to_FXbool(argv[0]); } 
    FXColorWell_setDefault(arg1,arg2); return Qnil; }
static VALUE _wrap_FXColorWell_enable(int argc, VALUE *argv, VALUE self) { FXColorWell *arg1 = (FXColorWell *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorWell, 1); FXColorWell_enable(arg1); return Qnil; }
static VALUE _wrap_FXColorWell_disable(int argc, VALUE *argv, VALUE self) { FXColorWell *arg1 = (FXColorWell *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorWell, 1); FXColorWell_disable(arg1); return Qnil; }
static VALUE _wrap_FXColorWell_raiseWindow(int argc, VALUE *argv, VALUE self) { FXColorWell *arg1 = (FXColorWell *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorWell, 1); FXColorWell_raise(arg1); return Qnil; }
static VALUE _wrap_FXColorWell_lower(int argc, VALUE *argv, VALUE self) { FXColorWell *arg1 = (FXColorWell *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorWell, 1); FXColorWell_lower(arg1); return Qnil; }
static VALUE _wrap_FXColorWell_move(int argc, VALUE *argv, VALUE self) { FXColorWell *arg1 = (FXColorWell *) 0 ; FXint arg2 ;
    FXint arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorWell, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    FXColorWell_move(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXColorWell_position(int argc, VALUE *argv, VALUE self) { FXColorWell *arg1 = (FXColorWell *) 0 ;
    FXint arg2 ; FXint arg3 ; FXint arg4 ; FXint arg5 ; if ((argc < 4) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorWell, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    arg4 = NUM2INT(argv[2]); arg5 = NUM2INT(argv[3]); FXColorWell_position(arg1,arg2,arg3,arg4,arg5); return Qnil; }
static VALUE _wrap_FXColorWell_layout(int argc, VALUE *argv, VALUE self) { FXColorWell *arg1 = (FXColorWell *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorWell, 1); FXColorWell_layout(arg1); return Qnil; }
static VALUE _wrap_FXColorWell_recalc(int argc, VALUE *argv, VALUE self) { FXColorWell *arg1 = (FXColorWell *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorWell, 1); FXColorWell_recalc(arg1); return Qnil; }
static VALUE _wrap_FXColorWell_reparent(int argc, VALUE *argv, VALUE self) { FXColorWell *arg1 = (FXColorWell *) 0 ;
    FXComposite *arg2 = (FXComposite *) 0 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorWell, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXComposite, 1); FXColorWell_reparent(arg1,arg2); return Qnil; }
static VALUE _wrap_FXColorWell_show(int argc, VALUE *argv, VALUE self) { FXColorWell *arg1 = (FXColorWell *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorWell, 1); FXColorWell_show(arg1); return Qnil; }
static VALUE _wrap_FXColorWell_hide(int argc, VALUE *argv, VALUE self) { FXColorWell *arg1 = (FXColorWell *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorWell, 1); FXColorWell_hide(arg1); return Qnil; }
static VALUE _wrap_FXColorWell_isComposite(int argc, VALUE *argv, VALUE self) { FXColorWell *arg1 = (FXColorWell *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorWell, 1);
    result = (FXbool)FXColorWell_isComposite((FXColorWell const *)arg1); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXColorWell_contains(int argc, VALUE *argv, VALUE self) { FXColorWell *arg1 = (FXColorWell *) 0 ;
    FXint arg2 ; FXint arg3 ; FXbool result; VALUE vresult = Qnil; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorWell, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    result = (FXbool)FXColorWell_contains((FXColorWell const *)arg1,arg2,arg3); vresult = result ? Qtrue : Qfalse;
    return vresult; }
static VALUE _wrap_FXColorWell_doesSaveUnder(int argc, VALUE *argv, VALUE self) { FXColorWell *arg1 = (FXColorWell *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorWell, 1);
    result = (FXbool)FXColorWell_doesSaveUnder((FXColorWell const *)arg1); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXColorWell_setBackColor(int argc, VALUE *argv, VALUE self) { FXColorWell *arg1 = (FXColorWell *) 0 ;
    FXColor arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorWell, 1); arg2 = to_FXColor(argv[0]);
    FXColorWell_setBackColor(arg1,arg2); return Qnil; }
static VALUE _wrap_FXColorWheel_onPaint(int argc, VALUE *argv, VALUE self) { FXColorWheel *arg1 = (FXColorWheel *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorWheel, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onPaint(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXColorWheel_onLeftBtnPress(int argc, VALUE *argv, VALUE self) { FXColorWheel *arg1 = (FXColorWheel *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorWheel, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onLeftBtnPress(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXColorWheel_onLeftBtnRelease(int argc, VALUE *argv, VALUE self) { FXColorWheel *arg1 = (FXColorWheel *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorWheel, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onLeftBtnRelease(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXColorWheel_onMotion(int argc, VALUE *argv, VALUE self) { FXColorWheel *arg1 = (FXColorWheel *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorWheel, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onMotion(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXColorWheel_onMouseWheel(int argc, VALUE *argv, VALUE self) { FXColorWheel *arg1 = (FXColorWheel *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorWheel, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onMouseWheel(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXColorWheel_onCmdSetHelp(int argc, VALUE *argv, VALUE self) { FXColorWheel *arg1 = (FXColorWheel *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; FXString value4 ;
    VALUE vresult = Qnil; if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorWheel, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); {
        value4 = FXString(STR2CSTR(argv[2])); arg4 = (void *) &value4; }  result = (long)(arg1)->onCmdSetHelp(arg2,arg3,arg4);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXColorWheel_onCmdGetHelp(int argc, VALUE *argv, VALUE self) { FXColorWheel *arg1 = (FXColorWheel *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorWheel, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdGetHelp(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXColorWheel_onCmdSetTip(int argc, VALUE *argv, VALUE self) { FXColorWheel *arg1 = (FXColorWheel *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; FXString value4 ;
    VALUE vresult = Qnil; if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorWheel, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); {
        value4 = FXString(STR2CSTR(argv[2])); arg4 = (void *) &value4; }  result = (long)(arg1)->onCmdSetTip(arg2,arg3,arg4);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXColorWheel_onCmdGetTip(int argc, VALUE *argv, VALUE self) { FXColorWheel *arg1 = (FXColorWheel *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorWheel, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdGetTip(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXColorWheel_onQueryHelp(int argc, VALUE *argv, VALUE self) { FXColorWheel *arg1 = (FXColorWheel *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorWheel, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onQueryHelp(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXColorWheel_onQueryTip(int argc, VALUE *argv, VALUE self) { FXColorWheel *arg1 = (FXColorWheel *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorWheel, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onQueryTip(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE _wrap_FXColorWheel_allocate(VALUE self) {
#else
     static VALUE _wrap_FXColorWheel_allocate(int argc, VALUE *argv, VALUE self) {
#endif
         VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_FXColorWheel);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
         return vresult; }
static VALUE _wrap_new_FXColorWheel(int argc, VALUE *argv, VALUE self) { FXComposite *arg1 = (FXComposite *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 = (FXSelector) 0 ; FXuint arg4 = (FXuint) FRAME_NORMAL ;
    FXint arg5 = (FXint) 0 ; FXint arg6 = (FXint) 0 ; FXint arg7 = (FXint) 0 ; FXint arg8 = (FXint) 0 ;
    FXint arg9 = (FXint) DEFAULT_PAD ; FXint arg10 = (FXint) DEFAULT_PAD ; FXint arg11 = (FXint) DEFAULT_PAD ;
    FXint arg12 = (FXint) DEFAULT_PAD ; FXColorWheel *result; if ((argc < 1) || (argc > 12))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXComposite, 1); if (argc > 1) {
        SWIG_ConvertPtr(argv[1], (void **) &arg2, SWIGTYPE_p_FXObject, 1); }  if (argc > 2) { arg3 = NUM2UINT(argv[2]); } 
    if (argc > 3) { arg4 = NUM2UINT(argv[3]); }  if (argc > 4) { arg5 = NUM2INT(argv[4]); }  if (argc > 5) {
        arg6 = NUM2INT(argv[5]); }  if (argc > 6) { arg7 = NUM2INT(argv[6]); }  if (argc > 7) { arg8 = NUM2INT(argv[7]); } 
    if (argc > 8) { arg9 = NUM2INT(argv[8]); }  if (argc > 9) { arg10 = NUM2INT(argv[9]); }  if (argc > 10) {
        arg11 = NUM2INT(argv[10]); }  if (argc > 11) { arg12 = NUM2INT(argv[11]); }  {
        result = (FXColorWheel *)new_FXColorWheel(arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8,arg9,arg10,arg11,arg12);
        DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result); if(rb_block_given_p()){ rb_yield(self); }  }  return self; }
static VALUE _wrap_FXColorWheel_setHue(int argc, VALUE *argv, VALUE self) { FXColorWheel *arg1 = (FXColorWheel *) 0 ;
    FXfloat arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorWheel, 1); arg2 = (FXfloat) NUM2DBL(argv[0]); (arg1)->setHue(arg2);
    return Qnil; }
static VALUE _wrap_FXColorWheel_getHue(int argc, VALUE *argv, VALUE self) { FXColorWheel *arg1 = (FXColorWheel *) 0 ;
    FXfloat result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorWheel, 1);
    result = (FXfloat)((FXColorWheel const *)arg1)->getHue(); vresult = rb_float_new(result); return vresult; }
static VALUE _wrap_FXColorWheel_setSat(int argc, VALUE *argv, VALUE self) { FXColorWheel *arg1 = (FXColorWheel *) 0 ;
    FXfloat arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorWheel, 1); arg2 = (FXfloat) NUM2DBL(argv[0]); (arg1)->setSat(arg2);
    return Qnil; }
static VALUE _wrap_FXColorWheel_getSat(int argc, VALUE *argv, VALUE self) { FXColorWheel *arg1 = (FXColorWheel *) 0 ;
    FXfloat result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorWheel, 1);
    result = (FXfloat)((FXColorWheel const *)arg1)->getSat(); vresult = rb_float_new(result); return vresult; }
static VALUE _wrap_FXColorWheel_setVal(int argc, VALUE *argv, VALUE self) { FXColorWheel *arg1 = (FXColorWheel *) 0 ;
    FXfloat arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorWheel, 1); arg2 = (FXfloat) NUM2DBL(argv[0]); (arg1)->setVal(arg2);
    return Qnil; }
static VALUE _wrap_FXColorWheel_getVal(int argc, VALUE *argv, VALUE self) { FXColorWheel *arg1 = (FXColorWheel *) 0 ;
    FXfloat result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorWheel, 1);
    result = (FXfloat)((FXColorWheel const *)arg1)->getVal(); vresult = rb_float_new(result); return vresult; }
static VALUE _wrap_FXColorWheel_setHelpText(int argc, VALUE *argv, VALUE self) { FXColorWheel *arg1 = (FXColorWheel *) 0 ;
    FXString *arg2 = 0 ; SwigValueWrapper<FXString > p2 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorWheel, 1); p2 = to_FXString(argv[0]); arg2 = &p2;
    (arg1)->setHelpText((FXString const &)*arg2); return Qnil; }
static VALUE _wrap_FXColorWheel_getHelpText(int argc, VALUE *argv, VALUE self) { FXColorWheel *arg1 = (FXColorWheel *) 0 ;
    FXString result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorWheel, 1); result = ((FXColorWheel const *)arg1)->getHelpText();
    vresult = rb_str_new2((&result)->text()); return vresult; }
static VALUE _wrap_FXColorWheel_setTipText(int argc, VALUE *argv, VALUE self) { FXColorWheel *arg1 = (FXColorWheel *) 0 ;
    FXString *arg2 = 0 ; SwigValueWrapper<FXString > p2 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorWheel, 1); p2 = to_FXString(argv[0]); arg2 = &p2;
    (arg1)->setTipText((FXString const &)*arg2); return Qnil; }
static VALUE _wrap_FXColorWheel_getTipText(int argc, VALUE *argv, VALUE self) { FXColorWheel *arg1 = (FXColorWheel *) 0 ;
    FXString result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorWheel, 1); result = ((FXColorWheel const *)arg1)->getTipText();
    vresult = rb_str_new2((&result)->text()); return vresult; }
static void
free_FXColorWheel(FXColorWheel *arg1) {
    delete arg1;
}
static VALUE _wrap_FXColorWheel_save(int argc, VALUE *argv, VALUE self) { FXColorWheel *arg1 = (FXColorWheel *) 0 ;
    FXStream *arg2 = 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorWheel, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXColorWheel_save((FXColorWheel const *)arg1,*arg2); return Qnil; }
static VALUE _wrap_FXColorWheel_load(int argc, VALUE *argv, VALUE self) { FXColorWheel *arg1 = (FXColorWheel *) 0 ;
    FXStream *arg2 = 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorWheel, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXColorWheel_load(arg1,*arg2); return Qnil; }
static VALUE _wrap_FXColorWheel_create(int argc, VALUE *argv, VALUE self) { FXColorWheel *arg1 = (FXColorWheel *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorWheel, 1); FXColorWheel_create(arg1); return Qnil; }
static VALUE _wrap_FXColorWheel_detach(int argc, VALUE *argv, VALUE self) { FXColorWheel *arg1 = (FXColorWheel *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorWheel, 1); FXColorWheel_detach(arg1); return Qnil; }
static VALUE _wrap_FXColorWheel_destroy(int argc, VALUE *argv, VALUE self) { FXColorWheel *arg1 = (FXColorWheel *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorWheel, 1); FXColorWheel_destroy(arg1); return Qnil; }
static VALUE _wrap_FXColorWheel_resize(int argc, VALUE *argv, VALUE self) { FXColorWheel *arg1 = (FXColorWheel *) 0 ;
    FXint arg2 ; FXint arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorWheel, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    FXColorWheel_resize(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXColorWheel_getDefaultWidth(int argc, VALUE *argv, VALUE self) { FXColorWheel *arg1 = (FXColorWheel *) 0 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorWheel, 1); result = (FXint)FXColorWheel_getDefaultWidth(arg1);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXColorWheel_getDefaultHeight(int argc, VALUE *argv, VALUE self) { FXColorWheel *arg1 = (FXColorWheel *) 0 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorWheel, 1); result = (FXint)FXColorWheel_getDefaultHeight(arg1);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXColorWheel_getWidthForHeight(int argc, VALUE *argv, VALUE self) { FXColorWheel *arg1 = (FXColorWheel *) 0 ;
    FXint arg2 ; FXint result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorWheel, 1); arg2 = NUM2INT(argv[0]);
    result = (FXint)FXColorWheel_getWidthForHeight(arg1,arg2); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXColorWheel_getHeightForWidth(int argc, VALUE *argv, VALUE self) { FXColorWheel *arg1 = (FXColorWheel *) 0 ;
    FXint arg2 ; FXint result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorWheel, 1); arg2 = NUM2INT(argv[0]);
    result = (FXint)FXColorWheel_getHeightForWidth(arg1,arg2); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXColorWheel_canFocus(int argc, VALUE *argv, VALUE self) { FXColorWheel *arg1 = (FXColorWheel *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorWheel, 1);
    result = (FXbool)FXColorWheel_canFocus((FXColorWheel const *)arg1); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXColorWheel_setFocus(int argc, VALUE *argv, VALUE self) { FXColorWheel *arg1 = (FXColorWheel *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorWheel, 1); FXColorWheel_setFocus(arg1); return Qnil; }
static VALUE _wrap_FXColorWheel_killFocus(int argc, VALUE *argv, VALUE self) { FXColorWheel *arg1 = (FXColorWheel *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorWheel, 1); FXColorWheel_killFocus(arg1); return Qnil; }
static VALUE _wrap_FXColorWheel_setDefault(int argc, VALUE *argv, VALUE self) { FXColorWheel *arg1 = (FXColorWheel *) 0 ;
    FXbool arg2 = (FXbool) 1 ; if ((argc < 0) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorWheel, 1); if (argc > 0) { arg2 = to_FXbool(argv[0]); } 
    FXColorWheel_setDefault(arg1,arg2); return Qnil; }
static VALUE _wrap_FXColorWheel_enable(int argc, VALUE *argv, VALUE self) { FXColorWheel *arg1 = (FXColorWheel *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorWheel, 1); FXColorWheel_enable(arg1); return Qnil; }
static VALUE _wrap_FXColorWheel_disable(int argc, VALUE *argv, VALUE self) { FXColorWheel *arg1 = (FXColorWheel *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorWheel, 1); FXColorWheel_disable(arg1); return Qnil; }
static VALUE _wrap_FXColorWheel_raiseWindow(int argc, VALUE *argv, VALUE self) { FXColorWheel *arg1 = (FXColorWheel *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorWheel, 1); FXColorWheel_raise(arg1); return Qnil; }
static VALUE _wrap_FXColorWheel_lower(int argc, VALUE *argv, VALUE self) { FXColorWheel *arg1 = (FXColorWheel *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorWheel, 1); FXColorWheel_lower(arg1); return Qnil; }
static VALUE _wrap_FXColorWheel_move(int argc, VALUE *argv, VALUE self) { FXColorWheel *arg1 = (FXColorWheel *) 0 ; FXint arg2 ;
    FXint arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorWheel, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    FXColorWheel_move(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXColorWheel_position(int argc, VALUE *argv, VALUE self) { FXColorWheel *arg1 = (FXColorWheel *) 0 ;
    FXint arg2 ; FXint arg3 ; FXint arg4 ; FXint arg5 ; if ((argc < 4) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorWheel, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    arg4 = NUM2INT(argv[2]); arg5 = NUM2INT(argv[3]); FXColorWheel_position(arg1,arg2,arg3,arg4,arg5); return Qnil; }
static VALUE _wrap_FXColorWheel_layout(int argc, VALUE *argv, VALUE self) { FXColorWheel *arg1 = (FXColorWheel *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorWheel, 1); FXColorWheel_layout(arg1); return Qnil; }
static VALUE _wrap_FXColorWheel_recalc(int argc, VALUE *argv, VALUE self) { FXColorWheel *arg1 = (FXColorWheel *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorWheel, 1); FXColorWheel_recalc(arg1); return Qnil; }
static VALUE _wrap_FXColorWheel_reparent(int argc, VALUE *argv, VALUE self) { FXColorWheel *arg1 = (FXColorWheel *) 0 ;
    FXComposite *arg2 = (FXComposite *) 0 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorWheel, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXComposite, 1); FXColorWheel_reparent(arg1,arg2); return Qnil; }
static VALUE _wrap_FXColorWheel_show(int argc, VALUE *argv, VALUE self) { FXColorWheel *arg1 = (FXColorWheel *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorWheel, 1); FXColorWheel_show(arg1); return Qnil; }
static VALUE _wrap_FXColorWheel_hide(int argc, VALUE *argv, VALUE self) { FXColorWheel *arg1 = (FXColorWheel *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorWheel, 1); FXColorWheel_hide(arg1); return Qnil; }
static VALUE _wrap_FXColorWheel_isComposite(int argc, VALUE *argv, VALUE self) { FXColorWheel *arg1 = (FXColorWheel *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorWheel, 1);
    result = (FXbool)FXColorWheel_isComposite((FXColorWheel const *)arg1); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXColorWheel_contains(int argc, VALUE *argv, VALUE self) { FXColorWheel *arg1 = (FXColorWheel *) 0 ;
    FXint arg2 ; FXint arg3 ; FXbool result; VALUE vresult = Qnil; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorWheel, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    result = (FXbool)FXColorWheel_contains((FXColorWheel const *)arg1,arg2,arg3); vresult = result ? Qtrue : Qfalse;
    return vresult; }
static VALUE _wrap_FXColorWheel_doesSaveUnder(int argc, VALUE *argv, VALUE self) { FXColorWheel *arg1 = (FXColorWheel *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorWheel, 1);
    result = (FXbool)FXColorWheel_doesSaveUnder((FXColorWheel const *)arg1); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXColorWheel_setBackColor(int argc, VALUE *argv, VALUE self) { FXColorWheel *arg1 = (FXColorWheel *) 0 ;
    FXColor arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorWheel, 1); arg2 = to_FXColor(argv[0]);
    FXColorWheel_setBackColor(arg1,arg2); return Qnil; }
static VALUE _wrap_FXDial_onPaint(int argc, VALUE *argv, VALUE self) { FXDial *arg1 = (FXDial *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDial, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onPaint(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXDial_onMotion(int argc, VALUE *argv, VALUE self) { FXDial *arg1 = (FXDial *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDial, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onMotion(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXDial_onMouseWheel(int argc, VALUE *argv, VALUE self) { FXDial *arg1 = (FXDial *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDial, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onMouseWheel(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXDial_onLeftBtnPress(int argc, VALUE *argv, VALUE self) { FXDial *arg1 = (FXDial *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDial, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onLeftBtnPress(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXDial_onLeftBtnRelease(int argc, VALUE *argv, VALUE self) { FXDial *arg1 = (FXDial *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDial, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onLeftBtnRelease(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXDial_onUngrabbed(int argc, VALUE *argv, VALUE self) { FXDial *arg1 = (FXDial *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDial, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onUngrabbed(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXDial_onCmdSetValue(int argc, VALUE *argv, VALUE self) { FXDial *arg1 = (FXDial *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDial, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]);
    arg4 = reinterpret_cast<void*>(NUM2INT(argv[2])); result = (long)(arg1)->onCmdSetValue(arg2,arg3,arg4);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXDial_onCmdSetIntValue(int argc, VALUE *argv, VALUE self) { FXDial *arg1 = (FXDial *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; FXint value4 ;
    VALUE vresult = Qnil; if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDial, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); {
        value4 = (FXint) NUM2INT(argv[2]); arg4 = static_cast<void*>(&value4); } 
    result = (long)(arg1)->onCmdSetIntValue(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXDial_onCmdGetIntValue(int argc, VALUE *argv, VALUE self) { FXDial *arg1 = (FXDial *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDial, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdGetIntValue(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXDial_onCmdSetRealValue(int argc, VALUE *argv, VALUE self) { FXDial *arg1 = (FXDial *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; FXdouble value4 ;
    VALUE vresult = Qnil; if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDial, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); {
        value4 = (FXdouble) NUM2DBL(argv[2]); arg4 = (void *) &value4; } 
    result = (long)(arg1)->onCmdSetRealValue(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXDial_onCmdGetRealValue(int argc, VALUE *argv, VALUE self) { FXDial *arg1 = (FXDial *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDial, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdGetRealValue(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXDial_onCmdSetIntRange(int argc, VALUE *argv, VALUE self) { FXDial *arg1 = (FXDial *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; FXint values4[2] ;
    VALUE vresult = Qnil; if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDial, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); { Check_Type(argv[2], T_ARRAY);
        values4[0] = (FXint) NUM2INT(rb_ary_entry(argv[2], 0)); values4[1] = (FXint) NUM2INT(rb_ary_entry(argv[2], 1));
        arg4 = static_cast<void*>(values4); }  result = (long)(arg1)->onCmdSetIntRange(arg2,arg3,arg4);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXDial_onCmdGetIntRange(int argc, VALUE *argv, VALUE self) { FXDial *arg1 = (FXDial *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDial, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]);
    SWIG_ConvertPtr(argv[2], (void **) &arg4, 0, 1); result = (long)(arg1)->onCmdGetIntRange(arg2,arg3,arg4);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXDial_onCmdSetRealRange(int argc, VALUE *argv, VALUE self) { FXDial *arg1 = (FXDial *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; FXdouble values4[2] ;
    VALUE vresult = Qnil; if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDial, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); { Check_Type(argv[2], T_ARRAY);
        values4[0] = (FXdouble) NUM2DBL(rb_ary_entry(argv[2], 0)); values4[1] = (FXdouble) NUM2DBL(rb_ary_entry(argv[2], 1));
        arg4 = (void *) values4; }  result = (long)(arg1)->onCmdSetRealRange(arg2,arg3,arg4); vresult = INT2NUM(result);
    return vresult; }
static VALUE _wrap_FXDial_onCmdGetRealRange(int argc, VALUE *argv, VALUE self) { FXDial *arg1 = (FXDial *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDial, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]);
    SWIG_ConvertPtr(argv[2], (void **) &arg4, 0, 1); result = (long)(arg1)->onCmdGetRealRange(arg2,arg3,arg4);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXDial_onCmdSetHelp(int argc, VALUE *argv, VALUE self) { FXDial *arg1 = (FXDial *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; FXString value4 ;
    VALUE vresult = Qnil; if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDial, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); {
        value4 = FXString(STR2CSTR(argv[2])); arg4 = (void *) &value4; }  result = (long)(arg1)->onCmdSetHelp(arg2,arg3,arg4);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXDial_onCmdGetHelp(int argc, VALUE *argv, VALUE self) { FXDial *arg1 = (FXDial *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDial, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdGetHelp(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXDial_onCmdSetTip(int argc, VALUE *argv, VALUE self) { FXDial *arg1 = (FXDial *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; FXString value4 ;
    VALUE vresult = Qnil; if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDial, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); {
        value4 = FXString(STR2CSTR(argv[2])); arg4 = (void *) &value4; }  result = (long)(arg1)->onCmdSetTip(arg2,arg3,arg4);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXDial_onCmdGetTip(int argc, VALUE *argv, VALUE self) { FXDial *arg1 = (FXDial *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDial, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdGetTip(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXDial_onQueryHelp(int argc, VALUE *argv, VALUE self) { FXDial *arg1 = (FXDial *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDial, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onQueryHelp(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXDial_onQueryTip(int argc, VALUE *argv, VALUE self) { FXDial *arg1 = (FXDial *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDial, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onQueryTip(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE _wrap_FXDial_allocate(VALUE self) {
#else
     static VALUE _wrap_FXDial_allocate(int argc, VALUE *argv, VALUE self) {
#endif
         VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_FXDial);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
         return vresult; }
static VALUE _wrap_new_FXDial(int argc, VALUE *argv, VALUE self) { FXComposite *arg1 = (FXComposite *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 = (FXSelector) 0 ; FXuint arg4 = (FXuint) DIAL_NORMAL ;
    FXint arg5 = (FXint) 0 ; FXint arg6 = (FXint) 0 ; FXint arg7 = (FXint) 0 ; FXint arg8 = (FXint) 0 ;
    FXint arg9 = (FXint) DEFAULT_PAD ; FXint arg10 = (FXint) DEFAULT_PAD ; FXint arg11 = (FXint) DEFAULT_PAD ;
    FXint arg12 = (FXint) DEFAULT_PAD ; FXDial *result; if ((argc < 1) || (argc > 12))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXComposite, 1); if (argc > 1) {
        SWIG_ConvertPtr(argv[1], (void **) &arg2, SWIGTYPE_p_FXObject, 1); }  if (argc > 2) { arg3 = NUM2UINT(argv[2]); } 
    if (argc > 3) { arg4 = NUM2UINT(argv[3]); }  if (argc > 4) { arg5 = NUM2INT(argv[4]); }  if (argc > 5) {
        arg6 = NUM2INT(argv[5]); }  if (argc > 6) { arg7 = NUM2INT(argv[6]); }  if (argc > 7) { arg8 = NUM2INT(argv[7]); } 
    if (argc > 8) { arg9 = NUM2INT(argv[8]); }  if (argc > 9) { arg10 = NUM2INT(argv[9]); }  if (argc > 10) {
        arg11 = NUM2INT(argv[10]); }  if (argc > 11) { arg12 = NUM2INT(argv[11]); }  {
        result = (FXDial *)new_FXDial(arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8,arg9,arg10,arg11,arg12);
        DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result); if(rb_block_given_p()){ rb_yield(self); }  }  return self; }
static VALUE _wrap_FXDial_setValue(int argc, VALUE *argv, VALUE self) { FXDial *arg1 = (FXDial *) 0 ; FXint arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDial, 1); arg2 = NUM2INT(argv[0]); (arg1)->setValue(arg2); return Qnil; }
static VALUE _wrap_FXDial_getValue(int argc, VALUE *argv, VALUE self) { FXDial *arg1 = (FXDial *) 0 ; FXint result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDial, 1); result = (FXint)((FXDial const *)arg1)->getValue();
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXDial_setRange(int argc, VALUE *argv, VALUE self) { FXDial *arg1 = (FXDial *) 0 ; VALUE arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDial, 1); arg2 = argv[0]; FXDial_setRange(arg1,arg2); return Qnil; }
static VALUE _wrap_FXDial_getRange(int argc, VALUE *argv, VALUE self) { FXDial *arg1 = (FXDial *) 0 ; VALUE result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDial, 1); result = (VALUE)FXDial_getRange((FXDial const *)arg1);
    vresult = result; return vresult; }
static VALUE _wrap_FXDial_setRevolutionIncrement(int argc, VALUE *argv, VALUE self) { FXDial *arg1 = (FXDial *) 0 ; FXint arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDial, 1); arg2 = NUM2INT(argv[0]); (arg1)->setRevolutionIncrement(arg2);
    return Qnil; }
static VALUE _wrap_FXDial_getRevolutionIncrement(int argc, VALUE *argv, VALUE self) { FXDial *arg1 = (FXDial *) 0 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc); SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDial, 1);
    result = (FXint)((FXDial const *)arg1)->getRevolutionIncrement(); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXDial_setNotchSpacing(int argc, VALUE *argv, VALUE self) { FXDial *arg1 = (FXDial *) 0 ; FXint arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDial, 1); arg2 = NUM2INT(argv[0]); (arg1)->setNotchSpacing(arg2);
    return Qnil; }
static VALUE _wrap_FXDial_getNotchSpacing(int argc, VALUE *argv, VALUE self) { FXDial *arg1 = (FXDial *) 0 ; FXint result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDial, 1); result = (FXint)((FXDial const *)arg1)->getNotchSpacing();
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXDial_setNotchOffset(int argc, VALUE *argv, VALUE self) { FXDial *arg1 = (FXDial *) 0 ; FXint arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDial, 1); arg2 = NUM2INT(argv[0]); (arg1)->setNotchOffset(arg2);
    return Qnil; }
static VALUE _wrap_FXDial_getNotchOffset(int argc, VALUE *argv, VALUE self) { FXDial *arg1 = (FXDial *) 0 ; FXint result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDial, 1); result = (FXint)((FXDial const *)arg1)->getNotchOffset();
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXDial_setDialStyle(int argc, VALUE *argv, VALUE self) { FXDial *arg1 = (FXDial *) 0 ; FXuint arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDial, 1); arg2 = NUM2UINT(argv[0]); (arg1)->setDialStyle(arg2);
    return Qnil; }
static VALUE _wrap_FXDial_getDialStyle(int argc, VALUE *argv, VALUE self) { FXDial *arg1 = (FXDial *) 0 ; FXuint result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDial, 1); result = (FXuint)((FXDial const *)arg1)->getDialStyle();
    vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXDial_setNotchColor(int argc, VALUE *argv, VALUE self) { FXDial *arg1 = (FXDial *) 0 ; FXColor arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDial, 1); arg2 = to_FXColor(argv[0]); (arg1)->setNotchColor(arg2);
    return Qnil; }
static VALUE _wrap_FXDial_getNotchColor(int argc, VALUE *argv, VALUE self) { FXDial *arg1 = (FXDial *) 0 ; FXColor result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDial, 1); result = (FXColor)((FXDial const *)arg1)->getNotchColor();
    vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXDial_setHelpText(int argc, VALUE *argv, VALUE self) { FXDial *arg1 = (FXDial *) 0 ; FXString *arg2 = 0 ;
    SwigValueWrapper<FXString > p2 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc); SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDial, 1);
    p2 = to_FXString(argv[0]); arg2 = &p2; (arg1)->setHelpText((FXString const &)*arg2); return Qnil; }
static VALUE _wrap_FXDial_getHelpText(int argc, VALUE *argv, VALUE self) { FXDial *arg1 = (FXDial *) 0 ; FXString result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDial, 1); result = ((FXDial const *)arg1)->getHelpText();
    vresult = rb_str_new2((&result)->text()); return vresult; }
static VALUE _wrap_FXDial_setTipText(int argc, VALUE *argv, VALUE self) { FXDial *arg1 = (FXDial *) 0 ; FXString *arg2 = 0 ;
    SwigValueWrapper<FXString > p2 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc); SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDial, 1);
    p2 = to_FXString(argv[0]); arg2 = &p2; (arg1)->setTipText((FXString const &)*arg2); return Qnil; }
static VALUE _wrap_FXDial_getTipText(int argc, VALUE *argv, VALUE self) { FXDial *arg1 = (FXDial *) 0 ; FXString result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDial, 1); result = ((FXDial const *)arg1)->getTipText();
    vresult = rb_str_new2((&result)->text()); return vresult; }
static void
free_FXDial(FXDial *arg1) {
    delete arg1;
}
static VALUE _wrap_FXDial_save(int argc, VALUE *argv, VALUE self) { FXDial *arg1 = (FXDial *) 0 ; FXStream *arg2 = 0 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDial, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXDial_save((FXDial const *)arg1,*arg2); return Qnil; }
static VALUE _wrap_FXDial_load(int argc, VALUE *argv, VALUE self) { FXDial *arg1 = (FXDial *) 0 ; FXStream *arg2 = 0 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDial, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXDial_load(arg1,*arg2); return Qnil; }
static VALUE _wrap_FXDial_create(int argc, VALUE *argv, VALUE self) { FXDial *arg1 = (FXDial *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDial, 1); FXDial_create(arg1); return Qnil; }
static VALUE _wrap_FXDial_detach(int argc, VALUE *argv, VALUE self) { FXDial *arg1 = (FXDial *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDial, 1); FXDial_detach(arg1); return Qnil; }
static VALUE _wrap_FXDial_destroy(int argc, VALUE *argv, VALUE self) { FXDial *arg1 = (FXDial *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDial, 1); FXDial_destroy(arg1); return Qnil; }
static VALUE _wrap_FXDial_resize(int argc, VALUE *argv, VALUE self) { FXDial *arg1 = (FXDial *) 0 ; FXint arg2 ; FXint arg3 ;
    if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDial, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    FXDial_resize(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXDial_getDefaultWidth(int argc, VALUE *argv, VALUE self) { FXDial *arg1 = (FXDial *) 0 ; FXint result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDial, 1); result = (FXint)FXDial_getDefaultWidth(arg1);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXDial_getDefaultHeight(int argc, VALUE *argv, VALUE self) { FXDial *arg1 = (FXDial *) 0 ; FXint result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDial, 1); result = (FXint)FXDial_getDefaultHeight(arg1);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXDial_getWidthForHeight(int argc, VALUE *argv, VALUE self) { FXDial *arg1 = (FXDial *) 0 ; FXint arg2 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc); SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDial, 1);
    arg2 = NUM2INT(argv[0]); result = (FXint)FXDial_getWidthForHeight(arg1,arg2); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXDial_getHeightForWidth(int argc, VALUE *argv, VALUE self) { FXDial *arg1 = (FXDial *) 0 ; FXint arg2 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc); SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDial, 1);
    arg2 = NUM2INT(argv[0]); result = (FXint)FXDial_getHeightForWidth(arg1,arg2); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXDial_canFocus(int argc, VALUE *argv, VALUE self) { FXDial *arg1 = (FXDial *) 0 ; FXbool result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDial, 1); result = (FXbool)FXDial_canFocus((FXDial const *)arg1);
    vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXDial_setFocus(int argc, VALUE *argv, VALUE self) { FXDial *arg1 = (FXDial *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDial, 1); FXDial_setFocus(arg1); return Qnil; }
static VALUE _wrap_FXDial_killFocus(int argc, VALUE *argv, VALUE self) { FXDial *arg1 = (FXDial *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDial, 1); FXDial_killFocus(arg1); return Qnil; }
static VALUE _wrap_FXDial_setDefault(int argc, VALUE *argv, VALUE self) { FXDial *arg1 = (FXDial *) 0 ;
    FXbool arg2 = (FXbool) 1 ; if ((argc < 0) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDial, 1); if (argc > 0) { arg2 = to_FXbool(argv[0]); } 
    FXDial_setDefault(arg1,arg2); return Qnil; }
static VALUE _wrap_FXDial_enable(int argc, VALUE *argv, VALUE self) { FXDial *arg1 = (FXDial *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDial, 1); FXDial_enable(arg1); return Qnil; }
static VALUE _wrap_FXDial_disable(int argc, VALUE *argv, VALUE self) { FXDial *arg1 = (FXDial *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDial, 1); FXDial_disable(arg1); return Qnil; }
static VALUE _wrap_FXDial_raiseWindow(int argc, VALUE *argv, VALUE self) { FXDial *arg1 = (FXDial *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDial, 1); FXDial_raise(arg1); return Qnil; }
static VALUE _wrap_FXDial_lower(int argc, VALUE *argv, VALUE self) { FXDial *arg1 = (FXDial *) 0 ; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc); SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDial, 1);
    FXDial_lower(arg1); return Qnil; }
static VALUE _wrap_FXDial_move(int argc, VALUE *argv, VALUE self) { FXDial *arg1 = (FXDial *) 0 ; FXint arg2 ; FXint arg3 ;
    if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDial, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    FXDial_move(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXDial_position(int argc, VALUE *argv, VALUE self) { FXDial *arg1 = (FXDial *) 0 ; FXint arg2 ; FXint arg3 ;
    FXint arg4 ; FXint arg5 ; if ((argc < 4) || (argc > 4)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDial, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    arg4 = NUM2INT(argv[2]); arg5 = NUM2INT(argv[3]); FXDial_position(arg1,arg2,arg3,arg4,arg5); return Qnil; }
static VALUE _wrap_FXDial_layout(int argc, VALUE *argv, VALUE self) { FXDial *arg1 = (FXDial *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDial, 1); FXDial_layout(arg1); return Qnil; }
static VALUE _wrap_FXDial_recalc(int argc, VALUE *argv, VALUE self) { FXDial *arg1 = (FXDial *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDial, 1); FXDial_recalc(arg1); return Qnil; }
static VALUE _wrap_FXDial_reparent(int argc, VALUE *argv, VALUE self) { FXDial *arg1 = (FXDial *) 0 ;
    FXComposite *arg2 = (FXComposite *) 0 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc); SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDial, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXComposite, 1); FXDial_reparent(arg1,arg2); return Qnil; }
static VALUE _wrap_FXDial_show(int argc, VALUE *argv, VALUE self) { FXDial *arg1 = (FXDial *) 0 ; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc); SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDial, 1);
    FXDial_show(arg1); return Qnil; }
static VALUE _wrap_FXDial_hide(int argc, VALUE *argv, VALUE self) { FXDial *arg1 = (FXDial *) 0 ; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc); SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDial, 1);
    FXDial_hide(arg1); return Qnil; }
static VALUE _wrap_FXDial_isComposite(int argc, VALUE *argv, VALUE self) { FXDial *arg1 = (FXDial *) 0 ; FXbool result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDial, 1); result = (FXbool)FXDial_isComposite((FXDial const *)arg1);
    vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXDial_contains(int argc, VALUE *argv, VALUE self) { FXDial *arg1 = (FXDial *) 0 ; FXint arg2 ; FXint arg3 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc); SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDial, 1);
    arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]); result = (FXbool)FXDial_contains((FXDial const *)arg1,arg2,arg3);
    vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXDial_doesSaveUnder(int argc, VALUE *argv, VALUE self) { FXDial *arg1 = (FXDial *) 0 ; FXbool result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDial, 1); result = (FXbool)FXDial_doesSaveUnder((FXDial const *)arg1);
    vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXDial_setBackColor(int argc, VALUE *argv, VALUE self) { FXDial *arg1 = (FXDial *) 0 ; FXColor arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDial, 1); arg2 = to_FXColor(argv[0]); FXDial_setBackColor(arg1,arg2);
    return Qnil; }
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE _wrap_FXHeaderItem_allocate(VALUE self) {
#else
     static VALUE _wrap_FXHeaderItem_allocate(int argc, VALUE *argv, VALUE self) {
#endif
         VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_FXHeaderItem);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
         return vresult; }
static VALUE _wrap_new_FXHeaderItem(int argc, VALUE *argv, VALUE self) { FXString *arg1 = 0 ; FXIcon *arg2 = (FXIcon *) 0 ;
    FXint arg3 = (FXint) 0 ; void *arg4 = (void *) 0 ; FXHeaderItem *result; SwigValueWrapper<FXString > p1 ;
    if ((argc < 1) || (argc > 4)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    p1 = to_FXString(argv[0]); arg1 = &p1; if (argc > 1) { SWIG_ConvertPtr(argv[1], (void **) &arg2, SWIGTYPE_p_FXIcon, 1); } 
    if (argc > 2) { arg3 = NUM2INT(argv[2]); }  if (argc > 3) { SWIG_ConvertPtr(argv[3], (void **) &arg4, 0, 1); }  {
        result = (FXHeaderItem *)new_FXHeaderItem((FXString const &)*arg1,arg2,arg3,arg4);
        DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result); if(rb_block_given_p()){ rb_yield(self); }  }  return self; }
static VALUE _wrap_FXHeaderItem_getText(int argc, VALUE *argv, VALUE self) { FXHeaderItem *arg1 = (FXHeaderItem *) 0 ;
    FXString *result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXHeaderItem, 1); {
        FXString const &_result_ref = ((FXHeaderItem const *)arg1)->getText(); result = (FXString *) &_result_ref; } 
    vresult = rb_str_new2(result->text()); return vresult; }
static VALUE _wrap_FXHeaderItem_getIcon(int argc, VALUE *argv, VALUE self) { FXHeaderItem *arg1 = (FXHeaderItem *) 0 ;
    FXIcon *result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXHeaderItem, 1);
    result = (FXIcon *)((FXHeaderItem const *)arg1)->getIcon(); {
        swig_type_info *ty = SWIG_TypeDynamicCast(SWIGTYPE_p_FXIcon, (void **) &result); vresult = FXRbGetRubyObj(result, ty); }
     return vresult; }
static VALUE _wrap_FXHeaderItem_setData(int argc, VALUE *argv, VALUE self) { FXHeaderItem *arg1 = (FXHeaderItem *) 0 ;
    VALUE arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXHeaderItem, 1); arg2 = argv[0]; FXHeaderItem_setData(arg1,arg2);
    return Qnil; }
static VALUE _wrap_FXHeaderItem_getData(int argc, VALUE *argv, VALUE self) { FXHeaderItem *arg1 = (FXHeaderItem *) 0 ;
    VALUE result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXHeaderItem, 1);
    result = (VALUE)FXHeaderItem_getData((FXHeaderItem const *)arg1); vresult = result; return vresult; }
static VALUE _wrap_FXHeaderItem_setSize(int argc, VALUE *argv, VALUE self) { FXHeaderItem *arg1 = (FXHeaderItem *) 0 ;
    FXint arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXHeaderItem, 1); arg2 = NUM2INT(argv[0]); (arg1)->setSize(arg2);
    return Qnil; }
static VALUE _wrap_FXHeaderItem_getSize(int argc, VALUE *argv, VALUE self) { FXHeaderItem *arg1 = (FXHeaderItem *) 0 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXHeaderItem, 1); result = (FXint)((FXHeaderItem const *)arg1)->getSize();
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXHeaderItem_setPos(int argc, VALUE *argv, VALUE self) { FXHeaderItem *arg1 = (FXHeaderItem *) 0 ;
    FXint arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXHeaderItem, 1); arg2 = NUM2INT(argv[0]); (arg1)->setPos(arg2);
    return Qnil; }
static VALUE _wrap_FXHeaderItem_getPos(int argc, VALUE *argv, VALUE self) { FXHeaderItem *arg1 = (FXHeaderItem *) 0 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXHeaderItem, 1); result = (FXint)((FXHeaderItem const *)arg1)->getPos();
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXHeaderItem_setArrowDir(int argc, VALUE *argv, VALUE self) { FXHeaderItem *arg1 = (FXHeaderItem *) 0 ;
    FXuint arg2 = (FXuint) 2 ; if ((argc < 0) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXHeaderItem, 1); if (argc > 0) { arg2 = NUM2UINT(argv[0]); } 
    (arg1)->setArrowDir(arg2); return Qnil; }
static VALUE _wrap_FXHeaderItem_getArrowDir(int argc, VALUE *argv, VALUE self) { FXHeaderItem *arg1 = (FXHeaderItem *) 0 ;
    FXuint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXHeaderItem, 1);
    result = (FXuint)((FXHeaderItem const *)arg1)->getArrowDir(); vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXHeaderItem_setJustify(int argc, VALUE *argv, VALUE self) { FXHeaderItem *arg1 = (FXHeaderItem *) 0 ;
    FXuint arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXHeaderItem, 1); arg2 = NUM2UINT(argv[0]); (arg1)->setJustify(arg2);
    return Qnil; }
static VALUE _wrap_FXHeaderItem_getJustify(int argc, VALUE *argv, VALUE self) { FXHeaderItem *arg1 = (FXHeaderItem *) 0 ;
    FXuint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXHeaderItem, 1);
    result = (FXuint)((FXHeaderItem const *)arg1)->getJustify(); vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXHeaderItem_setIconPosition(int argc, VALUE *argv, VALUE self) { FXHeaderItem *arg1 = (FXHeaderItem *) 0 ;
    FXuint arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXHeaderItem, 1); arg2 = NUM2UINT(argv[0]); (arg1)->setIconPosition(arg2);
    return Qnil; }
static VALUE _wrap_FXHeaderItem_getIconPosition(int argc, VALUE *argv, VALUE self) { FXHeaderItem *arg1 = (FXHeaderItem *) 0 ;
    FXuint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXHeaderItem, 1);
    result = (FXuint)((FXHeaderItem const *)arg1)->getIconPosition(); vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXHeaderItem_setPressed(int argc, VALUE *argv, VALUE self) { FXHeaderItem *arg1 = (FXHeaderItem *) 0 ;
    FXbool arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXHeaderItem, 1); arg2 = to_FXbool(argv[0]); (arg1)->setPressed(arg2);
    return Qnil; }
static VALUE _wrap_FXHeaderItem_isPressed(int argc, VALUE *argv, VALUE self) { FXHeaderItem *arg1 = (FXHeaderItem *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXHeaderItem, 1);
    result = (FXbool)((FXHeaderItem const *)arg1)->isPressed(); vresult = result ? Qtrue : Qfalse; return vresult; }
static void
free_FXHeaderItem(FXHeaderItem *arg1) {
    delete arg1;
}
static VALUE _wrap_FXHeaderItem_save(int argc, VALUE *argv, VALUE self) { FXHeaderItem *arg1 = (FXHeaderItem *) 0 ;
    FXStream *arg2 = 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXHeaderItem, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXHeaderItem_save((FXHeaderItem const *)arg1,*arg2); return Qnil; }
static VALUE _wrap_FXHeaderItem_load(int argc, VALUE *argv, VALUE self) { FXHeaderItem *arg1 = (FXHeaderItem *) 0 ;
    FXStream *arg2 = 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXHeaderItem, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXHeaderItem_load(arg1,*arg2); return Qnil; }
static VALUE _wrap_FXHeaderItem_setText(int argc, VALUE *argv, VALUE self) { FXHeaderItem *arg1 = (FXHeaderItem *) 0 ;
    FXString *arg2 = 0 ; SwigValueWrapper<FXString > p2 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXHeaderItem, 1); p2 = to_FXString(argv[0]); arg2 = &p2;
    FXHeaderItem_setText(arg1,(FXString const &)*arg2); return Qnil; }
static VALUE _wrap_FXHeaderItem_setIcon(int argc, VALUE *argv, VALUE self) { FXHeaderItem *arg1 = (FXHeaderItem *) 0 ;
    FXIcon *arg2 = (FXIcon *) 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXHeaderItem, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXIcon, 1); FXHeaderItem_setIcon(arg1,arg2); return Qnil; }
static VALUE _wrap_FXHeaderItem_getWidth(int argc, VALUE *argv, VALUE self) { FXHeaderItem *arg1 = (FXHeaderItem *) 0 ;
    FXHeader *arg2 = (FXHeader *) 0 ; FXint result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXHeaderItem, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXHeader, 1);
    result = (FXint)FXHeaderItem_getWidth((FXHeaderItem const *)arg1,(FXHeader const *)arg2); vresult = INT2NUM(result);
    return vresult; }
static VALUE _wrap_FXHeaderItem_getHeight(int argc, VALUE *argv, VALUE self) { FXHeaderItem *arg1 = (FXHeaderItem *) 0 ;
    FXHeader *arg2 = (FXHeader *) 0 ; FXint result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXHeaderItem, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXHeader, 1);
    result = (FXint)FXHeaderItem_getHeight((FXHeaderItem const *)arg1,(FXHeader const *)arg2); vresult = INT2NUM(result);
    return vresult; }
static VALUE _wrap_FXHeaderItem_create(int argc, VALUE *argv, VALUE self) { FXHeaderItem *arg1 = (FXHeaderItem *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXHeaderItem, 1); FXHeaderItem_create(arg1); return Qnil; }
static VALUE _wrap_FXHeaderItem_detach(int argc, VALUE *argv, VALUE self) { FXHeaderItem *arg1 = (FXHeaderItem *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXHeaderItem, 1); FXHeaderItem_detach(arg1); return Qnil; }
static VALUE _wrap_FXHeaderItem_destroy(int argc, VALUE *argv, VALUE self) { FXHeaderItem *arg1 = (FXHeaderItem *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXHeaderItem, 1); FXHeaderItem_destroy(arg1); return Qnil; }
static VALUE _wrap_FXHeader_onPaint(int argc, VALUE *argv, VALUE self) { FXHeader *arg1 = (FXHeader *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXHeader, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onPaint(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXHeader_onLeftBtnPress(int argc, VALUE *argv, VALUE self) { FXHeader *arg1 = (FXHeader *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXHeader, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onLeftBtnPress(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXHeader_onLeftBtnRelease(int argc, VALUE *argv, VALUE self) { FXHeader *arg1 = (FXHeader *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXHeader, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onLeftBtnRelease(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXHeader_onUngrabbed(int argc, VALUE *argv, VALUE self) { FXHeader *arg1 = (FXHeader *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXHeader, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onUngrabbed(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXHeader_onMotion(int argc, VALUE *argv, VALUE self) { FXHeader *arg1 = (FXHeader *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXHeader, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onMotion(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXHeader_onTipTimer(int argc, VALUE *argv, VALUE self) { FXHeader *arg1 = (FXHeader *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXHeader, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onTipTimer(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXHeader_onQueryTip(int argc, VALUE *argv, VALUE self) { FXHeader *arg1 = (FXHeader *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXHeader, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onQueryTip(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXHeader_onQueryHelp(int argc, VALUE *argv, VALUE self) { FXHeader *arg1 = (FXHeader *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXHeader, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onQueryHelp(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE _wrap_FXHeader_allocate(VALUE self) {
#else
     static VALUE _wrap_FXHeader_allocate(int argc, VALUE *argv, VALUE self) {
#endif
         VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_FXHeader);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
         return vresult; }
static VALUE _wrap_new_FXHeader(int argc, VALUE *argv, VALUE self) { FXComposite *arg1 = (FXComposite *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 = (FXSelector) 0 ; FXuint arg4 = (FXuint) HEADER_NORMAL ;
    FXint arg5 = (FXint) 0 ; FXint arg6 = (FXint) 0 ; FXint arg7 = (FXint) 0 ; FXint arg8 = (FXint) 0 ;
    FXint arg9 = (FXint) DEFAULT_PAD ; FXint arg10 = (FXint) DEFAULT_PAD ; FXint arg11 = (FXint) DEFAULT_PAD ;
    FXint arg12 = (FXint) DEFAULT_PAD ; FXHeader *result; if ((argc < 1) || (argc > 12))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXComposite, 1); if (argc > 1) {
        SWIG_ConvertPtr(argv[1], (void **) &arg2, SWIGTYPE_p_FXObject, 1); }  if (argc > 2) { arg3 = NUM2UINT(argv[2]); } 
    if (argc > 3) { arg4 = NUM2UINT(argv[3]); }  if (argc > 4) { arg5 = NUM2INT(argv[4]); }  if (argc > 5) {
        arg6 = NUM2INT(argv[5]); }  if (argc > 6) { arg7 = NUM2INT(argv[6]); }  if (argc > 7) { arg8 = NUM2INT(argv[7]); } 
    if (argc > 8) { arg9 = NUM2INT(argv[8]); }  if (argc > 9) { arg10 = NUM2INT(argv[9]); }  if (argc > 10) {
        arg11 = NUM2INT(argv[10]); }  if (argc > 11) { arg12 = NUM2INT(argv[11]); }  {
        result = (FXHeader *)new_FXHeader(arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8,arg9,arg10,arg11,arg12);
        DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result); if(rb_block_given_p()){ rb_yield(self); }  }  return self; }
static VALUE _wrap_FXHeader_getNumItems(int argc, VALUE *argv, VALUE self) { FXHeader *arg1 = (FXHeader *) 0 ; FXint result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXHeader, 1); result = (FXint)((FXHeader const *)arg1)->getNumItems();
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXHeader_getTotalSize(int argc, VALUE *argv, VALUE self) { FXHeader *arg1 = (FXHeader *) 0 ; FXint result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXHeader, 1); result = (FXint)((FXHeader const *)arg1)->getTotalSize();
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXHeader_setPosition(int argc, VALUE *argv, VALUE self) { FXHeader *arg1 = (FXHeader *) 0 ; FXint arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXHeader, 1); arg2 = NUM2INT(argv[0]); (arg1)->setPosition(arg2);
    return Qnil; }
static VALUE _wrap_FXHeader_getPosition(int argc, VALUE *argv, VALUE self) { FXHeader *arg1 = (FXHeader *) 0 ; FXint result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXHeader, 1); result = (FXint)((FXHeader const *)arg1)->getPosition();
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXHeader_getItem(int argc, VALUE *argv, VALUE self) { FXHeader *arg1 = (FXHeader *) 0 ; FXint arg2 ;
    FXHeaderItem *result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXHeader, 1); arg2 = NUM2INT(argv[0]); {
        if (arg2 < 0 || arg2 >= arg1->getNumItems()) { rb_raise(rb_eIndexError, "header item index out of bounds"); }  } 
    result = (FXHeaderItem *)((FXHeader const *)arg1)->getItem(arg2); {
        swig_type_info *ty = SWIG_TypeDynamicCast(SWIGTYPE_p_FXHeaderItem, (void **) &result);
        vresult = FXRbGetRubyObj(result, ty); }  return vresult; }
static VALUE _wrap_FXHeader_getItemAt(int argc, VALUE *argv, VALUE self) { FXHeader *arg1 = (FXHeader *) 0 ; FXint arg2 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXHeader, 1); arg2 = NUM2INT(argv[0]);
    result = (FXint)((FXHeader const *)arg1)->getItemAt(arg2); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXHeader_setItem__SWIG_0(int argc, VALUE *argv, VALUE self) { FXHeader *arg1 = (FXHeader *) 0 ; FXint arg2 ;
    FXHeaderItem *arg3 = (FXHeaderItem *) 0 ; FXbool arg4 = (FXbool) 0 ; FXint result; VALUE vresult = Qnil;
    if ((argc < 2) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXHeader, 1); arg2 = NUM2INT(argv[0]);
    SWIG_ConvertPtr(argv[1], (void **) &arg3, SWIGTYPE_p_FXHeaderItem, 1); if (argc > 2) { arg4 = to_FXbool(argv[2]); }  {
        if (arg2 < 0 || arg2 >= arg1->getNumItems()) { rb_raise(rb_eIndexError, "header item index out of bounds"); }  } 
    result = (FXint)FXHeader_setItem__SWIG_0(arg1,arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXHeader_setItem__SWIG_1(int argc, VALUE *argv, VALUE self) { FXHeader *arg1 = (FXHeader *) 0 ; FXint arg2 ;
    FXString *arg3 = 0 ; FXIcon *arg4 = (FXIcon *) 0 ; FXint arg5 = (FXint) 0 ; void *arg6 = (void *) 0 ;
    FXbool arg7 = (FXbool) 0 ; FXint result; SwigValueWrapper<FXString > p3 ; VALUE vresult = Qnil;
    if ((argc < 2) || (argc > 6)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXHeader, 1); arg2 = NUM2INT(argv[0]);
    p3 = to_FXString(argv[1]); arg3 = &p3; if (argc > 2) { SWIG_ConvertPtr(argv[2], (void **) &arg4, SWIGTYPE_p_FXIcon, 1); } 
    if (argc > 3) { arg5 = NUM2INT(argv[3]); }  if (argc > 4) { arg6 = (argv[4] == Qnil) ? NULL : (void *) argv[4]; } 
    if (argc > 5) { arg7 = to_FXbool(argv[5]); }  { if (arg2 < 0 || arg2 >= arg1->getNumItems()) {
            rb_raise(rb_eIndexError, "header item index out of bounds"); }  } 
    result = (FXint)FXHeader_setItem__SWIG_1(arg1,arg2,(FXString const &)*arg3,arg4,arg5,arg6,arg7); vresult = INT2NUM(result);
    return vresult; }
static VALUE _wrap_FXHeader_setItem(int nargs, VALUE *args, VALUE self) { int argc; VALUE argv[8]; int ii; argc = nargs + 1;
    argv[0] = self; for (ii = 1; (ii < argc) && (ii < 7); ii++) { argv[ii] = args[ii-1]; }  if ((argc >= 3) && (argc <= 4)) {
        int _v; { void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXHeader, 0) != -1)) ? 1 : 0; }
         if (_v) { { _v = ((TYPE(argv[1]) == T_FIXNUM) || (TYPE(argv[1]) == T_BIGNUM)) ? 1 : 0; }  if (_v) { { void *ptr;
                    _v = (NIL_P(argv[2]) || (TYPE(argv[2]) == T_DATA && SWIG_ConvertPtr(argv[2], &ptr, SWIGTYPE_p_FXHeaderItem, 0) != -1)) ? 1 : 0; }
                 if (_v) { if (argc <= 3) { return _wrap_FXHeader_setItem__SWIG_0(nargs, args, self);}  {
                        _v = (argv[3] == Qtrue || argv[3] == Qfalse) ? 1 : 0; }  if (_v) {
                        return _wrap_FXHeader_setItem__SWIG_0(nargs, args, self);}  }  }  }  } 
    if ((argc >= 3) && (argc <= 7)) { int _v; { void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXHeader, 0) != -1)) ? 1 : 0; }
         if (_v) { { _v = ((TYPE(argv[1]) == T_FIXNUM) || (TYPE(argv[1]) == T_BIGNUM)) ? 1 : 0; }  if (_v) { {
                    _v = (NIL_P(argv[2]) || TYPE(argv[2]) == T_STRING) ? 1 : 0; }  if (_v) { if (argc <= 3) {
                        return _wrap_FXHeader_setItem__SWIG_1(nargs, args, self);}  { void *ptr;
                        _v = (NIL_P(argv[3]) || (TYPE(argv[3]) == T_DATA && SWIG_ConvertPtr(argv[3], &ptr, SWIGTYPE_p_FXIcon, 0) != -1)) ? 1 : 0; }
                     if (_v) { if (argc <= 4) { return _wrap_FXHeader_setItem__SWIG_1(nargs, args, self);}  {
                            _v = ((TYPE(argv[4]) == T_FIXNUM) || (TYPE(argv[4]) == T_BIGNUM)) ? 1 : 0; }  if (_v) {
                            if (argc <= 5) { return _wrap_FXHeader_setItem__SWIG_1(nargs, args, self);}  { _v = 1; }  if (_v) {
                                if (argc <= 6) { return _wrap_FXHeader_setItem__SWIG_1(nargs, args, self);}  {
                                    _v = (argv[6] == Qtrue || argv[6] == Qfalse) ? 1 : 0; }  if (_v) {
                                    return _wrap_FXHeader_setItem__SWIG_1(nargs, args, self);}  }  }  }  }  }  }  } 
    rb_raise(rb_eArgError, "No matching function for overloaded 'FXHeader_setItem'"); return Qnil; }
static VALUE _wrap_FXHeader_insertItem__SWIG_0(int argc, VALUE *argv, VALUE self) { FXHeader *arg1 = (FXHeader *) 0 ;
    FXint arg2 ; FXHeaderItem *arg3 = (FXHeaderItem *) 0 ; FXbool arg4 = (FXbool) 0 ; FXint result; VALUE vresult = Qnil;
    if ((argc < 2) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXHeader, 1); arg2 = NUM2INT(argv[0]);
    SWIG_ConvertPtr(argv[1], (void **) &arg3, SWIGTYPE_p_FXHeaderItem, 1); if (argc > 2) { arg4 = to_FXbool(argv[2]); }  {
        if (arg2 < 0 || arg2 >= arg1->getNumItems()) { rb_raise(rb_eIndexError, "header item index out of bounds"); }  } 
    result = (FXint)FXHeader_insertItem__SWIG_0(arg1,arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXHeader_insertItem__SWIG_1(int argc, VALUE *argv, VALUE self) { FXHeader *arg1 = (FXHeader *) 0 ;
    FXint arg2 ; FXString *arg3 = 0 ; FXIcon *arg4 = (FXIcon *) 0 ; FXint arg5 = (FXint) 0 ; void *arg6 = (void *) 0 ;
    FXbool arg7 = (FXbool) 0 ; FXint result; SwigValueWrapper<FXString > p3 ; VALUE vresult = Qnil;
    if ((argc < 2) || (argc > 6)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXHeader, 1); arg2 = NUM2INT(argv[0]);
    p3 = to_FXString(argv[1]); arg3 = &p3; if (argc > 2) { SWIG_ConvertPtr(argv[2], (void **) &arg4, SWIGTYPE_p_FXIcon, 1); } 
    if (argc > 3) { arg5 = NUM2INT(argv[3]); }  if (argc > 4) { arg6 = (argv[4] == Qnil) ? NULL : (void *) argv[4]; } 
    if (argc > 5) { arg7 = to_FXbool(argv[5]); }  { if (arg2 < 0 || arg2 >= arg1->getNumItems()) {
            rb_raise(rb_eIndexError, "header item index out of bounds"); }  } 
    result = (FXint)(arg1)->insertItem(arg2,(FXString const &)*arg3,arg4,arg5,arg6,arg7); vresult = INT2NUM(result);
    return vresult; }
static VALUE _wrap_FXHeader_insertItem(int nargs, VALUE *args, VALUE self) { int argc; VALUE argv[8]; int ii; argc = nargs + 1;
    argv[0] = self; for (ii = 1; (ii < argc) && (ii < 7); ii++) { argv[ii] = args[ii-1]; }  if ((argc >= 3) && (argc <= 4)) {
        int _v; { void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXHeader, 0) != -1)) ? 1 : 0; }
         if (_v) { { _v = ((TYPE(argv[1]) == T_FIXNUM) || (TYPE(argv[1]) == T_BIGNUM)) ? 1 : 0; }  if (_v) { { void *ptr;
                    _v = (NIL_P(argv[2]) || (TYPE(argv[2]) == T_DATA && SWIG_ConvertPtr(argv[2], &ptr, SWIGTYPE_p_FXHeaderItem, 0) != -1)) ? 1 : 0; }
                 if (_v) { if (argc <= 3) { return _wrap_FXHeader_insertItem__SWIG_0(nargs, args, self);}  {
                        _v = (argv[3] == Qtrue || argv[3] == Qfalse) ? 1 : 0; }  if (_v) {
                        return _wrap_FXHeader_insertItem__SWIG_0(nargs, args, self);}  }  }  }  } 
    if ((argc >= 3) && (argc <= 7)) { int _v; { void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXHeader, 0) != -1)) ? 1 : 0; }
         if (_v) { { _v = ((TYPE(argv[1]) == T_FIXNUM) || (TYPE(argv[1]) == T_BIGNUM)) ? 1 : 0; }  if (_v) { {
                    _v = (NIL_P(argv[2]) || TYPE(argv[2]) == T_STRING) ? 1 : 0; }  if (_v) { if (argc <= 3) {
                        return _wrap_FXHeader_insertItem__SWIG_1(nargs, args, self);}  { void *ptr;
                        _v = (NIL_P(argv[3]) || (TYPE(argv[3]) == T_DATA && SWIG_ConvertPtr(argv[3], &ptr, SWIGTYPE_p_FXIcon, 0) != -1)) ? 1 : 0; }
                     if (_v) { if (argc <= 4) { return _wrap_FXHeader_insertItem__SWIG_1(nargs, args, self);}  {
                            _v = ((TYPE(argv[4]) == T_FIXNUM) || (TYPE(argv[4]) == T_BIGNUM)) ? 1 : 0; }  if (_v) {
                            if (argc <= 5) { return _wrap_FXHeader_insertItem__SWIG_1(nargs, args, self);}  { _v = 1; } 
                            if (_v) { if (argc <= 6) { return _wrap_FXHeader_insertItem__SWIG_1(nargs, args, self);}  {
                                    _v = (argv[6] == Qtrue || argv[6] == Qfalse) ? 1 : 0; }  if (_v) {
                                    return _wrap_FXHeader_insertItem__SWIG_1(nargs, args, self);}  }  }  }  }  }  }  } 
    rb_raise(rb_eArgError, "No matching function for overloaded 'FXHeader_insertItem'"); return Qnil; }
static VALUE _wrap_FXHeader_appendItem__SWIG_0(int argc, VALUE *argv, VALUE self) { FXHeader *arg1 = (FXHeader *) 0 ;
    FXHeaderItem *arg2 = (FXHeaderItem *) 0 ; FXbool arg3 = (FXbool) 0 ; FXint result; VALUE vresult = Qnil;
    if ((argc < 1) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXHeader, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXHeaderItem, 1); if (argc > 1) { arg3 = to_FXbool(argv[1]); } 
    result = (FXint)FXHeader_appendItem__SWIG_0(arg1,arg2,arg3); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXHeader_appendItem__SWIG_1(int argc, VALUE *argv, VALUE self) { FXHeader *arg1 = (FXHeader *) 0 ;
    FXString *arg2 = 0 ; FXIcon *arg3 = (FXIcon *) 0 ; FXint arg4 = (FXint) 0 ; void *arg5 = (void *) 0 ;
    FXbool arg6 = (FXbool) 0 ; FXint result; SwigValueWrapper<FXString > p2 ; VALUE vresult = Qnil;
    if ((argc < 1) || (argc > 5)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXHeader, 1); p2 = to_FXString(argv[0]); arg2 = &p2; if (argc > 1) {
        SWIG_ConvertPtr(argv[1], (void **) &arg3, SWIGTYPE_p_FXIcon, 1); }  if (argc > 2) { arg4 = NUM2INT(argv[2]); } 
    if (argc > 3) { arg5 = (argv[3] == Qnil) ? NULL : (void *) argv[3]; }  if (argc > 4) { arg6 = to_FXbool(argv[4]); } 
    result = (FXint)(arg1)->appendItem((FXString const &)*arg2,arg3,arg4,arg5,arg6); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXHeader_appendItem(int nargs, VALUE *args, VALUE self) { int argc; VALUE argv[7]; int ii; argc = nargs + 1;
    argv[0] = self; for (ii = 1; (ii < argc) && (ii < 6); ii++) { argv[ii] = args[ii-1]; }  if ((argc >= 2) && (argc <= 3)) {
        int _v; { void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXHeader, 0) != -1)) ? 1 : 0; }
         if (_v) { { void *ptr;
                _v = (NIL_P(argv[1]) || (TYPE(argv[1]) == T_DATA && SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_FXHeaderItem, 0) != -1)) ? 1 : 0; }
             if (_v) { if (argc <= 2) { return _wrap_FXHeader_appendItem__SWIG_0(nargs, args, self);}  {
                    _v = (argv[2] == Qtrue || argv[2] == Qfalse) ? 1 : 0; }  if (_v) {
                    return _wrap_FXHeader_appendItem__SWIG_0(nargs, args, self);}  }  }  }  if ((argc >= 2) && (argc <= 6)) {
        int _v; { void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXHeader, 0) != -1)) ? 1 : 0; }
         if (_v) { { _v = (NIL_P(argv[1]) || TYPE(argv[1]) == T_STRING) ? 1 : 0; }  if (_v) { if (argc <= 2) {
                    return _wrap_FXHeader_appendItem__SWIG_1(nargs, args, self);}  { void *ptr;
                    _v = (NIL_P(argv[2]) || (TYPE(argv[2]) == T_DATA && SWIG_ConvertPtr(argv[2], &ptr, SWIGTYPE_p_FXIcon, 0) != -1)) ? 1 : 0; }
                 if (_v) { if (argc <= 3) { return _wrap_FXHeader_appendItem__SWIG_1(nargs, args, self);}  {
                        _v = ((TYPE(argv[3]) == T_FIXNUM) || (TYPE(argv[3]) == T_BIGNUM)) ? 1 : 0; }  if (_v) { if (argc <= 4) {
                            return _wrap_FXHeader_appendItem__SWIG_1(nargs, args, self);}  { _v = 1; }  if (_v) {
                            if (argc <= 5) { return _wrap_FXHeader_appendItem__SWIG_1(nargs, args, self);}  {
                                _v = (argv[5] == Qtrue || argv[5] == Qfalse) ? 1 : 0; }  if (_v) {
                                return _wrap_FXHeader_appendItem__SWIG_1(nargs, args, self);}  }  }  }  }  }  } 
    rb_raise(rb_eArgError, "No matching function for overloaded 'FXHeader_appendItem'"); return Qnil; }
static VALUE _wrap_FXHeader_prependItem__SWIG_0(int argc, VALUE *argv, VALUE self) { FXHeader *arg1 = (FXHeader *) 0 ;
    FXHeaderItem *arg2 = (FXHeaderItem *) 0 ; FXbool arg3 = (FXbool) 0 ; FXint result; VALUE vresult = Qnil;
    if ((argc < 1) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXHeader, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXHeaderItem, 1); if (argc > 1) { arg3 = to_FXbool(argv[1]); } 
    result = (FXint)FXHeader_prependItem__SWIG_0(arg1,arg2,arg3); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXHeader_prependItem__SWIG_1(int argc, VALUE *argv, VALUE self) { FXHeader *arg1 = (FXHeader *) 0 ;
    FXString *arg2 = 0 ; FXIcon *arg3 = (FXIcon *) 0 ; FXint arg4 = (FXint) 0 ; void *arg5 = (void *) 0 ;
    FXbool arg6 = (FXbool) 0 ; FXint result; SwigValueWrapper<FXString > p2 ; VALUE vresult = Qnil;
    if ((argc < 1) || (argc > 5)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXHeader, 1); p2 = to_FXString(argv[0]); arg2 = &p2; if (argc > 1) {
        SWIG_ConvertPtr(argv[1], (void **) &arg3, SWIGTYPE_p_FXIcon, 1); }  if (argc > 2) { arg4 = NUM2INT(argv[2]); } 
    if (argc > 3) { arg5 = (argv[3] == Qnil) ? NULL : (void *) argv[3]; }  if (argc > 4) { arg6 = to_FXbool(argv[4]); } 
    result = (FXint)(arg1)->prependItem((FXString const &)*arg2,arg3,arg4,arg5,arg6); vresult = INT2NUM(result);
    return vresult; }
static VALUE _wrap_FXHeader_prependItem(int nargs, VALUE *args, VALUE self) { int argc; VALUE argv[7]; int ii; argc = nargs + 1;
    argv[0] = self; for (ii = 1; (ii < argc) && (ii < 6); ii++) { argv[ii] = args[ii-1]; }  if ((argc >= 2) && (argc <= 3)) {
        int _v; { void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXHeader, 0) != -1)) ? 1 : 0; }
         if (_v) { { void *ptr;
                _v = (NIL_P(argv[1]) || (TYPE(argv[1]) == T_DATA && SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_FXHeaderItem, 0) != -1)) ? 1 : 0; }
             if (_v) { if (argc <= 2) { return _wrap_FXHeader_prependItem__SWIG_0(nargs, args, self);}  {
                    _v = (argv[2] == Qtrue || argv[2] == Qfalse) ? 1 : 0; }  if (_v) {
                    return _wrap_FXHeader_prependItem__SWIG_0(nargs, args, self);}  }  }  }  if ((argc >= 2) && (argc <= 6)) {
        int _v; { void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXHeader, 0) != -1)) ? 1 : 0; }
         if (_v) { { _v = (NIL_P(argv[1]) || TYPE(argv[1]) == T_STRING) ? 1 : 0; }  if (_v) { if (argc <= 2) {
                    return _wrap_FXHeader_prependItem__SWIG_1(nargs, args, self);}  { void *ptr;
                    _v = (NIL_P(argv[2]) || (TYPE(argv[2]) == T_DATA && SWIG_ConvertPtr(argv[2], &ptr, SWIGTYPE_p_FXIcon, 0) != -1)) ? 1 : 0; }
                 if (_v) { if (argc <= 3) { return _wrap_FXHeader_prependItem__SWIG_1(nargs, args, self);}  {
                        _v = ((TYPE(argv[3]) == T_FIXNUM) || (TYPE(argv[3]) == T_BIGNUM)) ? 1 : 0; }  if (_v) { if (argc <= 4) {
                            return _wrap_FXHeader_prependItem__SWIG_1(nargs, args, self);}  { _v = 1; }  if (_v) {
                            if (argc <= 5) { return _wrap_FXHeader_prependItem__SWIG_1(nargs, args, self);}  {
                                _v = (argv[5] == Qtrue || argv[5] == Qfalse) ? 1 : 0; }  if (_v) {
                                return _wrap_FXHeader_prependItem__SWIG_1(nargs, args, self);}  }  }  }  }  }  } 
    rb_raise(rb_eArgError, "No matching function for overloaded 'FXHeader_prependItem'"); return Qnil; }
static VALUE _wrap_FXHeader_removeItem(int argc, VALUE *argv, VALUE self) { FXHeader *arg1 = (FXHeader *) 0 ; FXint arg2 ;
    FXbool arg3 = (FXbool) 0 ; if ((argc < 1) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXHeader, 1); arg2 = NUM2INT(argv[0]); if (argc > 1) {
        arg3 = to_FXbool(argv[1]); }  { if (arg2 < 0 || arg2 >= arg1->getNumItems()) {
            rb_raise(rb_eIndexError, "header item index out of bounds"); }  }  FXHeader_removeItem(arg1,arg2,arg3);
    return Qnil; }
static VALUE _wrap_FXHeader_clearItems(int argc, VALUE *argv, VALUE self) { FXHeader *arg1 = (FXHeader *) 0 ;
    FXbool arg2 = (FXbool) 0 ; if ((argc < 0) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXHeader, 1); if (argc > 0) { arg2 = to_FXbool(argv[0]); } 
    FXHeader_clearItems(arg1,arg2); return Qnil; }
static VALUE _wrap_FXHeader_setItemText(int argc, VALUE *argv, VALUE self) { FXHeader *arg1 = (FXHeader *) 0 ; FXint arg2 ;
    FXString *arg3 = 0 ; SwigValueWrapper<FXString > p3 ; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXHeader, 1); arg2 = NUM2INT(argv[0]);
    p3 = to_FXString(argv[1]); arg3 = &p3; { if (arg2 < 0 || arg2 >= arg1->getNumItems()) {
            rb_raise(rb_eIndexError, "header item index out of bounds"); }  } 
    (arg1)->setItemText(arg2,(FXString const &)*arg3); return Qnil; }
static VALUE _wrap_FXHeader_getItemText(int argc, VALUE *argv, VALUE self) { FXHeader *arg1 = (FXHeader *) 0 ; FXint arg2 ;
    FXString result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXHeader, 1); arg2 = NUM2INT(argv[0]); {
        if (arg2 < 0 || arg2 >= arg1->getNumItems()) { rb_raise(rb_eIndexError, "header item index out of bounds"); }  } 
    result = ((FXHeader const *)arg1)->getItemText(arg2); vresult = rb_str_new2((&result)->text()); return vresult; }
static VALUE _wrap_FXHeader_setItemIcon(int argc, VALUE *argv, VALUE self) { FXHeader *arg1 = (FXHeader *) 0 ; FXint arg2 ;
    FXIcon *arg3 = (FXIcon *) 0 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXHeader, 1); arg2 = NUM2INT(argv[0]);
    SWIG_ConvertPtr(argv[1], (void **) &arg3, SWIGTYPE_p_FXIcon, 1); { if (arg2 < 0 || arg2 >= arg1->getNumItems()) {
            rb_raise(rb_eIndexError, "header item index out of bounds"); }  }  (arg1)->setItemIcon(arg2,arg3); return Qnil; }
static VALUE _wrap_FXHeader_getItemIcon(int argc, VALUE *argv, VALUE self) { FXHeader *arg1 = (FXHeader *) 0 ; FXint arg2 ;
    FXIcon *result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXHeader, 1); arg2 = NUM2INT(argv[0]); {
        if (arg2 < 0 || arg2 >= arg1->getNumItems()) { rb_raise(rb_eIndexError, "header item index out of bounds"); }  } 
    result = (FXIcon *)((FXHeader const *)arg1)->getItemIcon(arg2); {
        swig_type_info *ty = SWIG_TypeDynamicCast(SWIGTYPE_p_FXIcon, (void **) &result); vresult = FXRbGetRubyObj(result, ty); }
     return vresult; }
static VALUE _wrap_FXHeader_setItemSize(int argc, VALUE *argv, VALUE self) { FXHeader *arg1 = (FXHeader *) 0 ; FXint arg2 ;
    FXint arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXHeader, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]); {
        if (arg2 < 0 || arg2 >= arg1->getNumItems()) { rb_raise(rb_eIndexError, "header item index out of bounds"); }  } 
    (arg1)->setItemSize(arg2,arg3); return Qnil; }
static VALUE _wrap_FXHeader_getItemSize(int argc, VALUE *argv, VALUE self) { FXHeader *arg1 = (FXHeader *) 0 ; FXint arg2 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXHeader, 1); arg2 = NUM2INT(argv[0]); {
        if (arg2 < 0 || arg2 >= arg1->getNumItems()) { rb_raise(rb_eIndexError, "header item index out of bounds"); }  } 
    result = (FXint)((FXHeader const *)arg1)->getItemSize(arg2); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXHeader_getItemOffset(int argc, VALUE *argv, VALUE self) { FXHeader *arg1 = (FXHeader *) 0 ; FXint arg2 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXHeader, 1); arg2 = NUM2INT(argv[0]); {
        if (arg2 < 0 || arg2 >= arg1->getNumItems()) { rb_raise(rb_eIndexError, "header item index out of bounds"); }  } 
    result = (FXint)((FXHeader const *)arg1)->getItemOffset(arg2); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXHeader_setItemData(int argc, VALUE *argv, VALUE self) { FXHeader *arg1 = (FXHeader *) 0 ; FXint arg2 ;
    VALUE arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXHeader, 1); arg2 = NUM2INT(argv[0]); arg3 = argv[1]; {
        if (arg2 < 0 || arg2 >= arg1->getNumItems()) { rb_raise(rb_eIndexError, "header item index out of bounds"); }  } 
    FXHeader_setItemData(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXHeader_getItemData(int argc, VALUE *argv, VALUE self) { FXHeader *arg1 = (FXHeader *) 0 ; FXint arg2 ;
    VALUE result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXHeader, 1); arg2 = NUM2INT(argv[0]); {
        if (arg2 < 0 || arg2 >= arg1->getNumItems()) { rb_raise(rb_eIndexError, "header item index out of bounds"); }  } 
    result = (VALUE)FXHeader_getItemData((FXHeader const *)arg1,arg2); vresult = result; return vresult; }
static VALUE _wrap_FXHeader_setArrowDir(int argc, VALUE *argv, VALUE self) { FXHeader *arg1 = (FXHeader *) 0 ; FXint arg2 ;
    FXbool arg3 = (FXbool) 2 ; if ((argc < 1) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXHeader, 1); arg2 = NUM2INT(argv[0]); if (argc > 1) {
        arg3 = to_FXbool(argv[1]); }  { if (arg2 < 0 || arg2 >= arg1->getNumItems()) {
            rb_raise(rb_eIndexError, "header item index out of bounds"); }  }  (arg1)->setArrowDir(arg2,arg3); return Qnil; }
static VALUE _wrap_FXHeader_getArrowDir(int argc, VALUE *argv, VALUE self) { FXHeader *arg1 = (FXHeader *) 0 ; FXint arg2 ;
    FXuint result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXHeader, 1); arg2 = NUM2INT(argv[0]); {
        if (arg2 < 0 || arg2 >= arg1->getNumItems()) { rb_raise(rb_eIndexError, "header item index out of bounds"); }  } 
    result = (FXuint)((FXHeader const *)arg1)->getArrowDir(arg2); vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXHeader_setItemJustify(int argc, VALUE *argv, VALUE self) { FXHeader *arg1 = (FXHeader *) 0 ; FXint arg2 ;
    FXuint arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXHeader, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2UINT(argv[1]); {
        if (arg2 < 0 || arg2 >= arg1->getNumItems()) { rb_raise(rb_eIndexError, "header item index out of bounds"); }  } 
    (arg1)->setItemJustify(arg2,arg3); return Qnil; }
static VALUE _wrap_FXHeader_getItemJustify(int argc, VALUE *argv, VALUE self) { FXHeader *arg1 = (FXHeader *) 0 ; FXint arg2 ;
    FXuint result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXHeader, 1); arg2 = NUM2INT(argv[0]); {
        if (arg2 < 0 || arg2 >= arg1->getNumItems()) { rb_raise(rb_eIndexError, "header item index out of bounds"); }  } 
    result = (FXuint)((FXHeader const *)arg1)->getItemJustify(arg2); vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXHeader_setItemIconPosition(int argc, VALUE *argv, VALUE self) { FXHeader *arg1 = (FXHeader *) 0 ;
    FXint arg2 ; FXuint arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXHeader, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2UINT(argv[1]); {
        if (arg2 < 0 || arg2 >= arg1->getNumItems()) { rb_raise(rb_eIndexError, "header item index out of bounds"); }  } 
    (arg1)->setItemIconPosition(arg2,arg3); return Qnil; }
static VALUE _wrap_FXHeader_getItemIconPosition(int argc, VALUE *argv, VALUE self) { FXHeader *arg1 = (FXHeader *) 0 ;
    FXint arg2 ; FXuint result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXHeader, 1); arg2 = NUM2INT(argv[0]); {
        if (arg2 < 0 || arg2 >= arg1->getNumItems()) { rb_raise(rb_eIndexError, "header item index out of bounds"); }  } 
    result = (FXuint)((FXHeader const *)arg1)->getItemIconPosition(arg2); vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXHeader_setItemPressed(int argc, VALUE *argv, VALUE self) { FXHeader *arg1 = (FXHeader *) 0 ; FXint arg2 ;
    FXbool arg3 = (FXbool) 1 ; if ((argc < 1) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXHeader, 1); arg2 = NUM2INT(argv[0]); if (argc > 1) {
        arg3 = to_FXbool(argv[1]); }  { if (arg2 < 0 || arg2 >= arg1->getNumItems()) {
            rb_raise(rb_eIndexError, "header item index out of bounds"); }  }  (arg1)->setItemPressed(arg2,arg3); return Qnil; }
static VALUE _wrap_FXHeader_isItemPressed(int argc, VALUE *argv, VALUE self) { FXHeader *arg1 = (FXHeader *) 0 ; FXint arg2 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXHeader, 1); arg2 = NUM2INT(argv[0]); {
        if (arg2 < 0 || arg2 >= arg1->getNumItems()) { rb_raise(rb_eIndexError, "header item index out of bounds"); }  } 
    result = (FXbool)((FXHeader const *)arg1)->isItemPressed(arg2); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXHeader_makeItemVisible(int argc, VALUE *argv, VALUE self) { FXHeader *arg1 = (FXHeader *) 0 ; FXint arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXHeader, 1); arg2 = NUM2INT(argv[0]); {
        if (arg2 < 0 || arg2 >= arg1->getNumItems()) { rb_raise(rb_eIndexError, "header item index out of bounds"); }  } 
    (arg1)->makeItemVisible(arg2); return Qnil; }
static VALUE _wrap_FXHeader_updateItem(int argc, VALUE *argv, VALUE self) { FXHeader *arg1 = (FXHeader *) 0 ; FXint arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXHeader, 1); arg2 = NUM2INT(argv[0]); {
        if (arg2 < 0 || arg2 >= arg1->getNumItems()) { rb_raise(rb_eIndexError, "header item index out of bounds"); }  } 
    ((FXHeader const *)arg1)->updateItem(arg2); return Qnil; }
static VALUE _wrap_FXHeader_setFont(int argc, VALUE *argv, VALUE self) { FXHeader *arg1 = (FXHeader *) 0 ;
    FXFont *arg2 = (FXFont *) 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXHeader, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXFont, 1); (arg1)->setFont(arg2); return Qnil; }
static VALUE _wrap_FXHeader_getFont(int argc, VALUE *argv, VALUE self) { FXHeader *arg1 = (FXHeader *) 0 ; FXFont *result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXHeader, 1); result = (FXFont *)((FXHeader const *)arg1)->getFont(); {
        swig_type_info *ty = SWIG_TypeDynamicCast(SWIGTYPE_p_FXFont, (void **) &result); vresult = FXRbGetRubyObj(result, ty); }
     return vresult; }
static VALUE _wrap_FXHeader_getTextColor(int argc, VALUE *argv, VALUE self) { FXHeader *arg1 = (FXHeader *) 0 ; FXColor result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXHeader, 1); result = (FXColor)((FXHeader const *)arg1)->getTextColor();
    vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXHeader_setTextColor(int argc, VALUE *argv, VALUE self) { FXHeader *arg1 = (FXHeader *) 0 ; FXColor arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXHeader, 1); arg2 = to_FXColor(argv[0]); (arg1)->setTextColor(arg2);
    return Qnil; }
static VALUE _wrap_FXHeader_setHeaderStyle(int argc, VALUE *argv, VALUE self) { FXHeader *arg1 = (FXHeader *) 0 ; FXuint arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXHeader, 1); arg2 = NUM2UINT(argv[0]); (arg1)->setHeaderStyle(arg2);
    return Qnil; }
static VALUE _wrap_FXHeader_getHeaderStyle(int argc, VALUE *argv, VALUE self) { FXHeader *arg1 = (FXHeader *) 0 ; FXuint result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXHeader, 1); result = (FXuint)((FXHeader const *)arg1)->getHeaderStyle();
    vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXHeader_setHelpText(int argc, VALUE *argv, VALUE self) { FXHeader *arg1 = (FXHeader *) 0 ;
    FXString *arg2 = 0 ; SwigValueWrapper<FXString > p2 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXHeader, 1); p2 = to_FXString(argv[0]); arg2 = &p2;
    (arg1)->setHelpText((FXString const &)*arg2); return Qnil; }
static VALUE _wrap_FXHeader_getHelpText(int argc, VALUE *argv, VALUE self) { FXHeader *arg1 = (FXHeader *) 0 ; FXString result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXHeader, 1); result = ((FXHeader const *)arg1)->getHelpText();
    vresult = rb_str_new2((&result)->text()); return vresult; }
static void
free_FXHeader(FXHeader *arg1) {
    delete arg1;
}
static VALUE _wrap_FXHeader_save(int argc, VALUE *argv, VALUE self) { FXHeader *arg1 = (FXHeader *) 0 ; FXStream *arg2 = 0 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXHeader, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXHeader_save((FXHeader const *)arg1,*arg2); return Qnil; }
static VALUE _wrap_FXHeader_load(int argc, VALUE *argv, VALUE self) { FXHeader *arg1 = (FXHeader *) 0 ; FXStream *arg2 = 0 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXHeader, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXHeader_load(arg1,*arg2); return Qnil; }
static VALUE _wrap_FXHeader_create(int argc, VALUE *argv, VALUE self) { FXHeader *arg1 = (FXHeader *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXHeader, 1); FXHeader_create(arg1); return Qnil; }
static VALUE _wrap_FXHeader_detach(int argc, VALUE *argv, VALUE self) { FXHeader *arg1 = (FXHeader *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXHeader, 1); FXHeader_detach(arg1); return Qnil; }
static VALUE _wrap_FXHeader_destroy(int argc, VALUE *argv, VALUE self) { FXHeader *arg1 = (FXHeader *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXHeader, 1); FXHeader_destroy(arg1); return Qnil; }
static VALUE _wrap_FXHeader_resize(int argc, VALUE *argv, VALUE self) { FXHeader *arg1 = (FXHeader *) 0 ; FXint arg2 ;
    FXint arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXHeader, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    FXHeader_resize(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXHeader_getDefaultWidth(int argc, VALUE *argv, VALUE self) { FXHeader *arg1 = (FXHeader *) 0 ; FXint result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXHeader, 1); result = (FXint)FXHeader_getDefaultWidth(arg1);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXHeader_getDefaultHeight(int argc, VALUE *argv, VALUE self) { FXHeader *arg1 = (FXHeader *) 0 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXHeader, 1); result = (FXint)FXHeader_getDefaultHeight(arg1);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXHeader_getWidthForHeight(int argc, VALUE *argv, VALUE self) { FXHeader *arg1 = (FXHeader *) 0 ;
    FXint arg2 ; FXint result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXHeader, 1); arg2 = NUM2INT(argv[0]);
    result = (FXint)FXHeader_getWidthForHeight(arg1,arg2); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXHeader_getHeightForWidth(int argc, VALUE *argv, VALUE self) { FXHeader *arg1 = (FXHeader *) 0 ;
    FXint arg2 ; FXint result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXHeader, 1); arg2 = NUM2INT(argv[0]);
    result = (FXint)FXHeader_getHeightForWidth(arg1,arg2); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXHeader_canFocus(int argc, VALUE *argv, VALUE self) { FXHeader *arg1 = (FXHeader *) 0 ; FXbool result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXHeader, 1); result = (FXbool)FXHeader_canFocus((FXHeader const *)arg1);
    vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXHeader_setFocus(int argc, VALUE *argv, VALUE self) { FXHeader *arg1 = (FXHeader *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXHeader, 1); FXHeader_setFocus(arg1); return Qnil; }
static VALUE _wrap_FXHeader_killFocus(int argc, VALUE *argv, VALUE self) { FXHeader *arg1 = (FXHeader *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXHeader, 1); FXHeader_killFocus(arg1); return Qnil; }
static VALUE _wrap_FXHeader_setDefault(int argc, VALUE *argv, VALUE self) { FXHeader *arg1 = (FXHeader *) 0 ;
    FXbool arg2 = (FXbool) 1 ; if ((argc < 0) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXHeader, 1); if (argc > 0) { arg2 = to_FXbool(argv[0]); } 
    FXHeader_setDefault(arg1,arg2); return Qnil; }
static VALUE _wrap_FXHeader_enable(int argc, VALUE *argv, VALUE self) { FXHeader *arg1 = (FXHeader *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXHeader, 1); FXHeader_enable(arg1); return Qnil; }
static VALUE _wrap_FXHeader_disable(int argc, VALUE *argv, VALUE self) { FXHeader *arg1 = (FXHeader *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXHeader, 1); FXHeader_disable(arg1); return Qnil; }
static VALUE _wrap_FXHeader_raiseWindow(int argc, VALUE *argv, VALUE self) { FXHeader *arg1 = (FXHeader *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXHeader, 1); FXHeader_raise(arg1); return Qnil; }
static VALUE _wrap_FXHeader_lower(int argc, VALUE *argv, VALUE self) { FXHeader *arg1 = (FXHeader *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXHeader, 1); FXHeader_lower(arg1); return Qnil; }
static VALUE _wrap_FXHeader_move(int argc, VALUE *argv, VALUE self) { FXHeader *arg1 = (FXHeader *) 0 ; FXint arg2 ;
    FXint arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXHeader, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    FXHeader_move(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXHeader_position(int argc, VALUE *argv, VALUE self) { FXHeader *arg1 = (FXHeader *) 0 ; FXint arg2 ;
    FXint arg3 ; FXint arg4 ; FXint arg5 ; if ((argc < 4) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXHeader, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    arg4 = NUM2INT(argv[2]); arg5 = NUM2INT(argv[3]); FXHeader_position(arg1,arg2,arg3,arg4,arg5); return Qnil; }
static VALUE _wrap_FXHeader_layout(int argc, VALUE *argv, VALUE self) { FXHeader *arg1 = (FXHeader *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXHeader, 1); FXHeader_layout(arg1); return Qnil; }
static VALUE _wrap_FXHeader_recalc(int argc, VALUE *argv, VALUE self) { FXHeader *arg1 = (FXHeader *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXHeader, 1); FXHeader_recalc(arg1); return Qnil; }
static VALUE _wrap_FXHeader_reparent(int argc, VALUE *argv, VALUE self) { FXHeader *arg1 = (FXHeader *) 0 ;
    FXComposite *arg2 = (FXComposite *) 0 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXHeader, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXComposite, 1); FXHeader_reparent(arg1,arg2); return Qnil; }
static VALUE _wrap_FXHeader_show(int argc, VALUE *argv, VALUE self) { FXHeader *arg1 = (FXHeader *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXHeader, 1); FXHeader_show(arg1); return Qnil; }
static VALUE _wrap_FXHeader_hide(int argc, VALUE *argv, VALUE self) { FXHeader *arg1 = (FXHeader *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXHeader, 1); FXHeader_hide(arg1); return Qnil; }
static VALUE _wrap_FXHeader_isComposite(int argc, VALUE *argv, VALUE self) { FXHeader *arg1 = (FXHeader *) 0 ; FXbool result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXHeader, 1);
    result = (FXbool)FXHeader_isComposite((FXHeader const *)arg1); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXHeader_contains(int argc, VALUE *argv, VALUE self) { FXHeader *arg1 = (FXHeader *) 0 ; FXint arg2 ;
    FXint arg3 ; FXbool result; VALUE vresult = Qnil; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXHeader, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    result = (FXbool)FXHeader_contains((FXHeader const *)arg1,arg2,arg3); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXHeader_doesSaveUnder(int argc, VALUE *argv, VALUE self) { FXHeader *arg1 = (FXHeader *) 0 ; FXbool result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXHeader, 1);
    result = (FXbool)FXHeader_doesSaveUnder((FXHeader const *)arg1); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXHeader_setBackColor(int argc, VALUE *argv, VALUE self) { FXHeader *arg1 = (FXHeader *) 0 ; FXColor arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXHeader, 1); arg2 = to_FXColor(argv[0]);
    FXHeader_setBackColor(arg1,arg2); return Qnil; }
static VALUE _wrap_FXImageFrame_onPaint(int argc, VALUE *argv, VALUE self) { FXImageFrame *arg1 = (FXImageFrame *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXImageFrame, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onPaint(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE _wrap_FXImageFrame_allocate(VALUE self) {
#else
     static VALUE _wrap_FXImageFrame_allocate(int argc, VALUE *argv, VALUE self) {
#endif
         VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_FXImageFrame);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
         return vresult; }
static VALUE _wrap_new_FXImageFrame(int argc, VALUE *argv, VALUE self) { FXComposite *arg1 = (FXComposite *) 0 ;
    FXImage *arg2 = (FXImage *) 0 ; FXuint arg3 = (FXuint) FRAME_SUNKEN|FRAME_THICK ; FXint arg4 = (FXint) 0 ;
    FXint arg5 = (FXint) 0 ; FXint arg6 = (FXint) 0 ; FXint arg7 = (FXint) 0 ; FXint arg8 = (FXint) 0 ; FXint arg9 = (FXint) 0 ;
    FXint arg10 = (FXint) 0 ; FXint arg11 = (FXint) 0 ; FXImageFrame *result; if ((argc < 2) || (argc > 11))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXComposite, 1);
    SWIG_ConvertPtr(argv[1], (void **) &arg2, SWIGTYPE_p_FXImage, 1); if (argc > 2) { arg3 = NUM2UINT(argv[2]); } 
    if (argc > 3) { arg4 = NUM2INT(argv[3]); }  if (argc > 4) { arg5 = NUM2INT(argv[4]); }  if (argc > 5) {
        arg6 = NUM2INT(argv[5]); }  if (argc > 6) { arg7 = NUM2INT(argv[6]); }  if (argc > 7) { arg8 = NUM2INT(argv[7]); } 
    if (argc > 8) { arg9 = NUM2INT(argv[8]); }  if (argc > 9) { arg10 = NUM2INT(argv[9]); }  if (argc > 10) {
        arg11 = NUM2INT(argv[10]); }  {
        result = (FXImageFrame *)new_FXImageFrame(arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8,arg9,arg10,arg11);
        DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result); if(rb_block_given_p()){ rb_yield(self); }  }  return self; }
static VALUE _wrap_FXImageFrame_setImage(int argc, VALUE *argv, VALUE self) { FXImageFrame *arg1 = (FXImageFrame *) 0 ;
    FXImage *arg2 = (FXImage *) 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXImageFrame, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXImage, 1); (arg1)->setImage(arg2); return Qnil; }
static VALUE _wrap_FXImageFrame_getImage(int argc, VALUE *argv, VALUE self) { FXImageFrame *arg1 = (FXImageFrame *) 0 ;
    FXImage *result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXImageFrame, 1);
    result = (FXImage *)((FXImageFrame const *)arg1)->getImage(); {
        swig_type_info *ty = SWIG_TypeDynamicCast(SWIGTYPE_p_FXImage, (void **) &result); vresult = FXRbGetRubyObj(result, ty); }
     return vresult; }
static VALUE _wrap_FXImageFrame_setJustify(int argc, VALUE *argv, VALUE self) { FXImageFrame *arg1 = (FXImageFrame *) 0 ;
    FXuint arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXImageFrame, 1); arg2 = NUM2UINT(argv[0]); (arg1)->setJustify(arg2);
    return Qnil; }
static VALUE _wrap_FXImageFrame_getJustify(int argc, VALUE *argv, VALUE self) { FXImageFrame *arg1 = (FXImageFrame *) 0 ;
    FXuint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXImageFrame, 1);
    result = (FXuint)((FXImageFrame const *)arg1)->getJustify(); vresult = UINT2NUM(result); return vresult; }
static void
free_FXImageFrame(FXImageFrame *arg1) {
    delete arg1;
}
static VALUE _wrap_FXImageFrame_save(int argc, VALUE *argv, VALUE self) { FXImageFrame *arg1 = (FXImageFrame *) 0 ;
    FXStream *arg2 = 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXImageFrame, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXImageFrame_save((FXImageFrame const *)arg1,*arg2); return Qnil; }
static VALUE _wrap_FXImageFrame_load(int argc, VALUE *argv, VALUE self) { FXImageFrame *arg1 = (FXImageFrame *) 0 ;
    FXStream *arg2 = 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXImageFrame, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXImageFrame_load(arg1,*arg2); return Qnil; }
static VALUE _wrap_FXImageFrame_create(int argc, VALUE *argv, VALUE self) { FXImageFrame *arg1 = (FXImageFrame *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXImageFrame, 1); FXImageFrame_create(arg1); return Qnil; }
static VALUE _wrap_FXImageFrame_detach(int argc, VALUE *argv, VALUE self) { FXImageFrame *arg1 = (FXImageFrame *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXImageFrame, 1); FXImageFrame_detach(arg1); return Qnil; }
static VALUE _wrap_FXImageFrame_destroy(int argc, VALUE *argv, VALUE self) { FXImageFrame *arg1 = (FXImageFrame *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXImageFrame, 1); FXImageFrame_destroy(arg1); return Qnil; }
static VALUE _wrap_FXImageFrame_resize(int argc, VALUE *argv, VALUE self) { FXImageFrame *arg1 = (FXImageFrame *) 0 ;
    FXint arg2 ; FXint arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXImageFrame, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    FXImageFrame_resize(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXImageFrame_getDefaultWidth(int argc, VALUE *argv, VALUE self) { FXImageFrame *arg1 = (FXImageFrame *) 0 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXImageFrame, 1); result = (FXint)FXImageFrame_getDefaultWidth(arg1);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXImageFrame_getDefaultHeight(int argc, VALUE *argv, VALUE self) { FXImageFrame *arg1 = (FXImageFrame *) 0 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXImageFrame, 1); result = (FXint)FXImageFrame_getDefaultHeight(arg1);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXImageFrame_getWidthForHeight(int argc, VALUE *argv, VALUE self) { FXImageFrame *arg1 = (FXImageFrame *) 0 ;
    FXint arg2 ; FXint result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXImageFrame, 1); arg2 = NUM2INT(argv[0]);
    result = (FXint)FXImageFrame_getWidthForHeight(arg1,arg2); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXImageFrame_getHeightForWidth(int argc, VALUE *argv, VALUE self) { FXImageFrame *arg1 = (FXImageFrame *) 0 ;
    FXint arg2 ; FXint result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXImageFrame, 1); arg2 = NUM2INT(argv[0]);
    result = (FXint)FXImageFrame_getHeightForWidth(arg1,arg2); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXImageFrame_canFocus(int argc, VALUE *argv, VALUE self) { FXImageFrame *arg1 = (FXImageFrame *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXImageFrame, 1);
    result = (FXbool)FXImageFrame_canFocus((FXImageFrame const *)arg1); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXImageFrame_setFocus(int argc, VALUE *argv, VALUE self) { FXImageFrame *arg1 = (FXImageFrame *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXImageFrame, 1); FXImageFrame_setFocus(arg1); return Qnil; }
static VALUE _wrap_FXImageFrame_killFocus(int argc, VALUE *argv, VALUE self) { FXImageFrame *arg1 = (FXImageFrame *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXImageFrame, 1); FXImageFrame_killFocus(arg1); return Qnil; }
static VALUE _wrap_FXImageFrame_setDefault(int argc, VALUE *argv, VALUE self) { FXImageFrame *arg1 = (FXImageFrame *) 0 ;
    FXbool arg2 = (FXbool) 1 ; if ((argc < 0) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXImageFrame, 1); if (argc > 0) { arg2 = to_FXbool(argv[0]); } 
    FXImageFrame_setDefault(arg1,arg2); return Qnil; }
static VALUE _wrap_FXImageFrame_enable(int argc, VALUE *argv, VALUE self) { FXImageFrame *arg1 = (FXImageFrame *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXImageFrame, 1); FXImageFrame_enable(arg1); return Qnil; }
static VALUE _wrap_FXImageFrame_disable(int argc, VALUE *argv, VALUE self) { FXImageFrame *arg1 = (FXImageFrame *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXImageFrame, 1); FXImageFrame_disable(arg1); return Qnil; }
static VALUE _wrap_FXImageFrame_raiseWindow(int argc, VALUE *argv, VALUE self) { FXImageFrame *arg1 = (FXImageFrame *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXImageFrame, 1); FXImageFrame_raise(arg1); return Qnil; }
static VALUE _wrap_FXImageFrame_lower(int argc, VALUE *argv, VALUE self) { FXImageFrame *arg1 = (FXImageFrame *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXImageFrame, 1); FXImageFrame_lower(arg1); return Qnil; }
static VALUE _wrap_FXImageFrame_move(int argc, VALUE *argv, VALUE self) { FXImageFrame *arg1 = (FXImageFrame *) 0 ; FXint arg2 ;
    FXint arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXImageFrame, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    FXImageFrame_move(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXImageFrame_position(int argc, VALUE *argv, VALUE self) { FXImageFrame *arg1 = (FXImageFrame *) 0 ;
    FXint arg2 ; FXint arg3 ; FXint arg4 ; FXint arg5 ; if ((argc < 4) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXImageFrame, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    arg4 = NUM2INT(argv[2]); arg5 = NUM2INT(argv[3]); FXImageFrame_position(arg1,arg2,arg3,arg4,arg5); return Qnil; }
static VALUE _wrap_FXImageFrame_layout(int argc, VALUE *argv, VALUE self) { FXImageFrame *arg1 = (FXImageFrame *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXImageFrame, 1); FXImageFrame_layout(arg1); return Qnil; }
static VALUE _wrap_FXImageFrame_recalc(int argc, VALUE *argv, VALUE self) { FXImageFrame *arg1 = (FXImageFrame *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXImageFrame, 1); FXImageFrame_recalc(arg1); return Qnil; }
static VALUE _wrap_FXImageFrame_reparent(int argc, VALUE *argv, VALUE self) { FXImageFrame *arg1 = (FXImageFrame *) 0 ;
    FXComposite *arg2 = (FXComposite *) 0 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXImageFrame, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXComposite, 1); FXImageFrame_reparent(arg1,arg2); return Qnil; }
static VALUE _wrap_FXImageFrame_show(int argc, VALUE *argv, VALUE self) { FXImageFrame *arg1 = (FXImageFrame *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXImageFrame, 1); FXImageFrame_show(arg1); return Qnil; }
static VALUE _wrap_FXImageFrame_hide(int argc, VALUE *argv, VALUE self) { FXImageFrame *arg1 = (FXImageFrame *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXImageFrame, 1); FXImageFrame_hide(arg1); return Qnil; }
static VALUE _wrap_FXImageFrame_isComposite(int argc, VALUE *argv, VALUE self) { FXImageFrame *arg1 = (FXImageFrame *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXImageFrame, 1);
    result = (FXbool)FXImageFrame_isComposite((FXImageFrame const *)arg1); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXImageFrame_contains(int argc, VALUE *argv, VALUE self) { FXImageFrame *arg1 = (FXImageFrame *) 0 ;
    FXint arg2 ; FXint arg3 ; FXbool result; VALUE vresult = Qnil; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXImageFrame, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    result = (FXbool)FXImageFrame_contains((FXImageFrame const *)arg1,arg2,arg3); vresult = result ? Qtrue : Qfalse;
    return vresult; }
static VALUE _wrap_FXImageFrame_doesSaveUnder(int argc, VALUE *argv, VALUE self) { FXImageFrame *arg1 = (FXImageFrame *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXImageFrame, 1);
    result = (FXbool)FXImageFrame_doesSaveUnder((FXImageFrame const *)arg1); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXImageFrame_setBackColor(int argc, VALUE *argv, VALUE self) { FXImageFrame *arg1 = (FXImageFrame *) 0 ;
    FXColor arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXImageFrame, 1); arg2 = to_FXColor(argv[0]);
    FXImageFrame_setBackColor(arg1,arg2); return Qnil; }
static VALUE _wrap_FXBitmapFrame_onPaint(int argc, VALUE *argv, VALUE self) { FXBitmapFrame *arg1 = (FXBitmapFrame *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXBitmapFrame, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onPaint(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE _wrap_FXBitmapFrame_allocate(VALUE self) {
#else
     static VALUE _wrap_FXBitmapFrame_allocate(int argc, VALUE *argv, VALUE self) {
#endif
         VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_FXBitmapFrame);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
         return vresult; }
static VALUE _wrap_new_FXBitmapFrame(int argc, VALUE *argv, VALUE self) { FXComposite *arg1 = (FXComposite *) 0 ;
    FXBitmap *arg2 = (FXBitmap *) 0 ; FXuint arg3 = (FXuint) FRAME_SUNKEN|FRAME_THICK ; FXint arg4 = (FXint) 0 ;
    FXint arg5 = (FXint) 0 ; FXint arg6 = (FXint) 0 ; FXint arg7 = (FXint) 0 ; FXint arg8 = (FXint) 0 ; FXint arg9 = (FXint) 0 ;
    FXint arg10 = (FXint) 0 ; FXint arg11 = (FXint) 0 ; FXBitmapFrame *result; if ((argc < 2) || (argc > 11))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXComposite, 1);
    SWIG_ConvertPtr(argv[1], (void **) &arg2, SWIGTYPE_p_FXBitmap, 1); if (argc > 2) { arg3 = NUM2UINT(argv[2]); } 
    if (argc > 3) { arg4 = NUM2INT(argv[3]); }  if (argc > 4) { arg5 = NUM2INT(argv[4]); }  if (argc > 5) {
        arg6 = NUM2INT(argv[5]); }  if (argc > 6) { arg7 = NUM2INT(argv[6]); }  if (argc > 7) { arg8 = NUM2INT(argv[7]); } 
    if (argc > 8) { arg9 = NUM2INT(argv[8]); }  if (argc > 9) { arg10 = NUM2INT(argv[9]); }  if (argc > 10) {
        arg11 = NUM2INT(argv[10]); }  {
        result = (FXBitmapFrame *)new_FXBitmapFrame(arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8,arg9,arg10,arg11);
        DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result); if(rb_block_given_p()){ rb_yield(self); }  }  return self; }
static VALUE _wrap_FXBitmapFrame_setBitmap(int argc, VALUE *argv, VALUE self) { FXBitmapFrame *arg1 = (FXBitmapFrame *) 0 ;
    FXBitmap *arg2 = (FXBitmap *) 0 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXBitmapFrame, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXBitmap, 1); (arg1)->setBitmap(arg2); return Qnil; }
static VALUE _wrap_FXBitmapFrame_getBitmap(int argc, VALUE *argv, VALUE self) { FXBitmapFrame *arg1 = (FXBitmapFrame *) 0 ;
    FXBitmap *result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXBitmapFrame, 1);
    result = (FXBitmap *)((FXBitmapFrame const *)arg1)->getBitmap(); {
        swig_type_info *ty = SWIG_TypeDynamicCast(SWIGTYPE_p_FXBitmap, (void **) &result);
        vresult = FXRbGetRubyObj(result, ty); }  return vresult; }
static VALUE _wrap_FXBitmapFrame_setOnColor(int argc, VALUE *argv, VALUE self) { FXBitmapFrame *arg1 = (FXBitmapFrame *) 0 ;
    FXColor arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXBitmapFrame, 1); arg2 = to_FXColor(argv[0]); (arg1)->setOnColor(arg2);
    return Qnil; }
static VALUE _wrap_FXBitmapFrame_getOnColor(int argc, VALUE *argv, VALUE self) { FXBitmapFrame *arg1 = (FXBitmapFrame *) 0 ;
    FXColor result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXBitmapFrame, 1);
    result = (FXColor)((FXBitmapFrame const *)arg1)->getOnColor(); vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXBitmapFrame_setOffColor(int argc, VALUE *argv, VALUE self) { FXBitmapFrame *arg1 = (FXBitmapFrame *) 0 ;
    FXColor arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXBitmapFrame, 1); arg2 = to_FXColor(argv[0]); (arg1)->setOffColor(arg2);
    return Qnil; }
static VALUE _wrap_FXBitmapFrame_getOffColor(int argc, VALUE *argv, VALUE self) { FXBitmapFrame *arg1 = (FXBitmapFrame *) 0 ;
    FXColor result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXBitmapFrame, 1);
    result = (FXColor)((FXBitmapFrame const *)arg1)->getOffColor(); vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXBitmapFrame_setJustify(int argc, VALUE *argv, VALUE self) { FXBitmapFrame *arg1 = (FXBitmapFrame *) 0 ;
    FXuint arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXBitmapFrame, 1); arg2 = NUM2UINT(argv[0]); (arg1)->setJustify(arg2);
    return Qnil; }
static VALUE _wrap_FXBitmapFrame_getJustify(int argc, VALUE *argv, VALUE self) { FXBitmapFrame *arg1 = (FXBitmapFrame *) 0 ;
    FXuint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXBitmapFrame, 1);
    result = (FXuint)((FXBitmapFrame const *)arg1)->getJustify(); vresult = UINT2NUM(result); return vresult; }
static void
free_FXBitmapFrame(FXBitmapFrame *arg1) {
    delete arg1;
}
static VALUE _wrap_FXBitmapFrame_save(int argc, VALUE *argv, VALUE self) { FXBitmapFrame *arg1 = (FXBitmapFrame *) 0 ;
    FXStream *arg2 = 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXBitmapFrame, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXBitmapFrame_save((FXBitmapFrame const *)arg1,*arg2); return Qnil; }
static VALUE _wrap_FXBitmapFrame_load(int argc, VALUE *argv, VALUE self) { FXBitmapFrame *arg1 = (FXBitmapFrame *) 0 ;
    FXStream *arg2 = 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXBitmapFrame, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXBitmapFrame_load(arg1,*arg2); return Qnil; }
static VALUE _wrap_FXBitmapFrame_create(int argc, VALUE *argv, VALUE self) { FXBitmapFrame *arg1 = (FXBitmapFrame *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXBitmapFrame, 1); FXBitmapFrame_create(arg1); return Qnil; }
static VALUE _wrap_FXBitmapFrame_detach(int argc, VALUE *argv, VALUE self) { FXBitmapFrame *arg1 = (FXBitmapFrame *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXBitmapFrame, 1); FXBitmapFrame_detach(arg1); return Qnil; }
static VALUE _wrap_FXBitmapFrame_destroy(int argc, VALUE *argv, VALUE self) { FXBitmapFrame *arg1 = (FXBitmapFrame *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXBitmapFrame, 1); FXBitmapFrame_destroy(arg1); return Qnil; }
static VALUE _wrap_FXBitmapFrame_resize(int argc, VALUE *argv, VALUE self) { FXBitmapFrame *arg1 = (FXBitmapFrame *) 0 ;
    FXint arg2 ; FXint arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXBitmapFrame, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    FXBitmapFrame_resize(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXBitmapFrame_getDefaultWidth(int argc, VALUE *argv, VALUE self) {
    FXBitmapFrame *arg1 = (FXBitmapFrame *) 0 ; FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXBitmapFrame, 1); result = (FXint)FXBitmapFrame_getDefaultWidth(arg1);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXBitmapFrame_getDefaultHeight(int argc, VALUE *argv, VALUE self) {
    FXBitmapFrame *arg1 = (FXBitmapFrame *) 0 ; FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXBitmapFrame, 1); result = (FXint)FXBitmapFrame_getDefaultHeight(arg1);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXBitmapFrame_getWidthForHeight(int argc, VALUE *argv, VALUE self) {
    FXBitmapFrame *arg1 = (FXBitmapFrame *) 0 ; FXint arg2 ; FXint result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXBitmapFrame, 1); arg2 = NUM2INT(argv[0]);
    result = (FXint)FXBitmapFrame_getWidthForHeight(arg1,arg2); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXBitmapFrame_getHeightForWidth(int argc, VALUE *argv, VALUE self) {
    FXBitmapFrame *arg1 = (FXBitmapFrame *) 0 ; FXint arg2 ; FXint result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXBitmapFrame, 1); arg2 = NUM2INT(argv[0]);
    result = (FXint)FXBitmapFrame_getHeightForWidth(arg1,arg2); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXBitmapFrame_canFocus(int argc, VALUE *argv, VALUE self) { FXBitmapFrame *arg1 = (FXBitmapFrame *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXBitmapFrame, 1);
    result = (FXbool)FXBitmapFrame_canFocus((FXBitmapFrame const *)arg1); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXBitmapFrame_setFocus(int argc, VALUE *argv, VALUE self) { FXBitmapFrame *arg1 = (FXBitmapFrame *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXBitmapFrame, 1); FXBitmapFrame_setFocus(arg1); return Qnil; }
static VALUE _wrap_FXBitmapFrame_killFocus(int argc, VALUE *argv, VALUE self) { FXBitmapFrame *arg1 = (FXBitmapFrame *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXBitmapFrame, 1); FXBitmapFrame_killFocus(arg1); return Qnil; }
static VALUE _wrap_FXBitmapFrame_setDefault(int argc, VALUE *argv, VALUE self) { FXBitmapFrame *arg1 = (FXBitmapFrame *) 0 ;
    FXbool arg2 = (FXbool) 1 ; if ((argc < 0) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXBitmapFrame, 1); if (argc > 0) { arg2 = to_FXbool(argv[0]); } 
    FXBitmapFrame_setDefault(arg1,arg2); return Qnil; }
static VALUE _wrap_FXBitmapFrame_enable(int argc, VALUE *argv, VALUE self) { FXBitmapFrame *arg1 = (FXBitmapFrame *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXBitmapFrame, 1); FXBitmapFrame_enable(arg1); return Qnil; }
static VALUE _wrap_FXBitmapFrame_disable(int argc, VALUE *argv, VALUE self) { FXBitmapFrame *arg1 = (FXBitmapFrame *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXBitmapFrame, 1); FXBitmapFrame_disable(arg1); return Qnil; }
static VALUE _wrap_FXBitmapFrame_raiseWindow(int argc, VALUE *argv, VALUE self) { FXBitmapFrame *arg1 = (FXBitmapFrame *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXBitmapFrame, 1); FXBitmapFrame_raise(arg1); return Qnil; }
static VALUE _wrap_FXBitmapFrame_lower(int argc, VALUE *argv, VALUE self) { FXBitmapFrame *arg1 = (FXBitmapFrame *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXBitmapFrame, 1); FXBitmapFrame_lower(arg1); return Qnil; }
static VALUE _wrap_FXBitmapFrame_move(int argc, VALUE *argv, VALUE self) { FXBitmapFrame *arg1 = (FXBitmapFrame *) 0 ;
    FXint arg2 ; FXint arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXBitmapFrame, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    FXBitmapFrame_move(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXBitmapFrame_position(int argc, VALUE *argv, VALUE self) { FXBitmapFrame *arg1 = (FXBitmapFrame *) 0 ;
    FXint arg2 ; FXint arg3 ; FXint arg4 ; FXint arg5 ; if ((argc < 4) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXBitmapFrame, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    arg4 = NUM2INT(argv[2]); arg5 = NUM2INT(argv[3]); FXBitmapFrame_position(arg1,arg2,arg3,arg4,arg5); return Qnil; }
static VALUE _wrap_FXBitmapFrame_layout(int argc, VALUE *argv, VALUE self) { FXBitmapFrame *arg1 = (FXBitmapFrame *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXBitmapFrame, 1); FXBitmapFrame_layout(arg1); return Qnil; }
static VALUE _wrap_FXBitmapFrame_recalc(int argc, VALUE *argv, VALUE self) { FXBitmapFrame *arg1 = (FXBitmapFrame *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXBitmapFrame, 1); FXBitmapFrame_recalc(arg1); return Qnil; }
static VALUE _wrap_FXBitmapFrame_reparent(int argc, VALUE *argv, VALUE self) { FXBitmapFrame *arg1 = (FXBitmapFrame *) 0 ;
    FXComposite *arg2 = (FXComposite *) 0 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXBitmapFrame, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXComposite, 1); FXBitmapFrame_reparent(arg1,arg2); return Qnil; }
static VALUE _wrap_FXBitmapFrame_show(int argc, VALUE *argv, VALUE self) { FXBitmapFrame *arg1 = (FXBitmapFrame *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXBitmapFrame, 1); FXBitmapFrame_show(arg1); return Qnil; }
static VALUE _wrap_FXBitmapFrame_hide(int argc, VALUE *argv, VALUE self) { FXBitmapFrame *arg1 = (FXBitmapFrame *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXBitmapFrame, 1); FXBitmapFrame_hide(arg1); return Qnil; }
static VALUE _wrap_FXBitmapFrame_isComposite(int argc, VALUE *argv, VALUE self) { FXBitmapFrame *arg1 = (FXBitmapFrame *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXBitmapFrame, 1);
    result = (FXbool)FXBitmapFrame_isComposite((FXBitmapFrame const *)arg1); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXBitmapFrame_contains(int argc, VALUE *argv, VALUE self) { FXBitmapFrame *arg1 = (FXBitmapFrame *) 0 ;
    FXint arg2 ; FXint arg3 ; FXbool result; VALUE vresult = Qnil; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXBitmapFrame, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    result = (FXbool)FXBitmapFrame_contains((FXBitmapFrame const *)arg1,arg2,arg3); vresult = result ? Qtrue : Qfalse;
    return vresult; }
static VALUE _wrap_FXBitmapFrame_doesSaveUnder(int argc, VALUE *argv, VALUE self) { FXBitmapFrame *arg1 = (FXBitmapFrame *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXBitmapFrame, 1);
    result = (FXbool)FXBitmapFrame_doesSaveUnder((FXBitmapFrame const *)arg1); vresult = result ? Qtrue : Qfalse;
    return vresult; }
static VALUE _wrap_FXBitmapFrame_setBackColor(int argc, VALUE *argv, VALUE self) { FXBitmapFrame *arg1 = (FXBitmapFrame *) 0 ;
    FXColor arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXBitmapFrame, 1); arg2 = to_FXColor(argv[0]);
    FXBitmapFrame_setBackColor(arg1,arg2); return Qnil; }
static VALUE _wrap_FXProgressBar_onPaint(int argc, VALUE *argv, VALUE self) { FXProgressBar *arg1 = (FXProgressBar *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXProgressBar, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onPaint(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXProgressBar_onCmdSetValue(int argc, VALUE *argv, VALUE self) { FXProgressBar *arg1 = (FXProgressBar *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXProgressBar, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]);
    arg4 = reinterpret_cast<void*>(NUM2UINT(argv[2])); result = (long)(arg1)->onCmdSetValue(arg2,arg3,arg4);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXProgressBar_onCmdSetIntValue(int argc, VALUE *argv, VALUE self) {
    FXProgressBar *arg1 = (FXProgressBar *) 0 ; FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ;
    long result; FXint value4 ; VALUE vresult = Qnil; if ((argc < 3) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXProgressBar, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); {
        value4 = (FXint) NUM2INT(argv[2]); arg4 = static_cast<void*>(&value4); } 
    result = (long)(arg1)->onCmdSetIntValue(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXProgressBar_onCmdGetIntValue(int argc, VALUE *argv, VALUE self) {
    FXProgressBar *arg1 = (FXProgressBar *) 0 ; FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ;
    long result; VALUE vresult = Qnil; if ((argc < 3) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXProgressBar, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdGetIntValue(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE _wrap_FXProgressBar_allocate(VALUE self) {
#else
     static VALUE _wrap_FXProgressBar_allocate(int argc, VALUE *argv, VALUE self) {
#endif
         VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_FXProgressBar);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
         return vresult; }
static VALUE _wrap_new_FXProgressBar(int argc, VALUE *argv, VALUE self) { FXComposite *arg1 = (FXComposite *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 = (FXSelector) 0 ; FXuint arg4 = (FXuint) PROGRESSBAR_NORMAL ;
    FXint arg5 = (FXint) 0 ; FXint arg6 = (FXint) 0 ; FXint arg7 = (FXint) 0 ; FXint arg8 = (FXint) 0 ;
    FXint arg9 = (FXint) DEFAULT_PAD ; FXint arg10 = (FXint) DEFAULT_PAD ; FXint arg11 = (FXint) DEFAULT_PAD ;
    FXint arg12 = (FXint) DEFAULT_PAD ; FXProgressBar *result; if ((argc < 1) || (argc > 12))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXComposite, 1); if (argc > 1) {
        SWIG_ConvertPtr(argv[1], (void **) &arg2, SWIGTYPE_p_FXObject, 1); }  if (argc > 2) { arg3 = NUM2UINT(argv[2]); } 
    if (argc > 3) { arg4 = NUM2UINT(argv[3]); }  if (argc > 4) { arg5 = NUM2INT(argv[4]); }  if (argc > 5) {
        arg6 = NUM2INT(argv[5]); }  if (argc > 6) { arg7 = NUM2INT(argv[6]); }  if (argc > 7) { arg8 = NUM2INT(argv[7]); } 
    if (argc > 8) { arg9 = NUM2INT(argv[8]); }  if (argc > 9) { arg10 = NUM2INT(argv[9]); }  if (argc > 10) {
        arg11 = NUM2INT(argv[10]); }  if (argc > 11) { arg12 = NUM2INT(argv[11]); }  {
        result = (FXProgressBar *)new_FXProgressBar(arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8,arg9,arg10,arg11,arg12);
        DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result); if(rb_block_given_p()){ rb_yield(self); }  }  return self; }
static VALUE _wrap_FXProgressBar_setProgress(int argc, VALUE *argv, VALUE self) { FXProgressBar *arg1 = (FXProgressBar *) 0 ;
    FXuint arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXProgressBar, 1); arg2 = NUM2UINT(argv[0]); (arg1)->setProgress(arg2);
    return Qnil; }
static VALUE _wrap_FXProgressBar_getProgress(int argc, VALUE *argv, VALUE self) { FXProgressBar *arg1 = (FXProgressBar *) 0 ;
    FXuint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXProgressBar, 1);
    result = (FXuint)((FXProgressBar const *)arg1)->getProgress(); vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXProgressBar_setTotal(int argc, VALUE *argv, VALUE self) { FXProgressBar *arg1 = (FXProgressBar *) 0 ;
    FXuint arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXProgressBar, 1); arg2 = NUM2UINT(argv[0]); (arg1)->setTotal(arg2);
    return Qnil; }
static VALUE _wrap_FXProgressBar_getTotal(int argc, VALUE *argv, VALUE self) { FXProgressBar *arg1 = (FXProgressBar *) 0 ;
    FXuint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXProgressBar, 1);
    result = (FXuint)((FXProgressBar const *)arg1)->getTotal(); vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXProgressBar_increment(int argc, VALUE *argv, VALUE self) { FXProgressBar *arg1 = (FXProgressBar *) 0 ;
    FXuint arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXProgressBar, 1); arg2 = NUM2UINT(argv[0]); (arg1)->increment(arg2);
    return Qnil; }
static VALUE _wrap_FXProgressBar_hideNumber(int argc, VALUE *argv, VALUE self) { FXProgressBar *arg1 = (FXProgressBar *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXProgressBar, 1); (arg1)->hideNumber(); return Qnil; }
static VALUE _wrap_FXProgressBar_showNumber(int argc, VALUE *argv, VALUE self) { FXProgressBar *arg1 = (FXProgressBar *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXProgressBar, 1); (arg1)->showNumber(); return Qnil; }
static VALUE _wrap_FXProgressBar_setBarSize(int argc, VALUE *argv, VALUE self) { FXProgressBar *arg1 = (FXProgressBar *) 0 ;
    FXint arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXProgressBar, 1); arg2 = NUM2INT(argv[0]); (arg1)->setBarSize(arg2);
    return Qnil; }
static VALUE _wrap_FXProgressBar_getBarSize(int argc, VALUE *argv, VALUE self) { FXProgressBar *arg1 = (FXProgressBar *) 0 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXProgressBar, 1);
    result = (FXint)((FXProgressBar const *)arg1)->getBarSize(); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXProgressBar_setBarBGColor(int argc, VALUE *argv, VALUE self) { FXProgressBar *arg1 = (FXProgressBar *) 0 ;
    FXColor arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXProgressBar, 1); arg2 = to_FXColor(argv[0]);
    (arg1)->setBarBGColor(arg2); return Qnil; }
static VALUE _wrap_FXProgressBar_getBarBGColor(int argc, VALUE *argv, VALUE self) { FXProgressBar *arg1 = (FXProgressBar *) 0 ;
    FXColor result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXProgressBar, 1);
    result = (FXColor)((FXProgressBar const *)arg1)->getBarBGColor(); vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXProgressBar_setBarColor(int argc, VALUE *argv, VALUE self) { FXProgressBar *arg1 = (FXProgressBar *) 0 ;
    FXColor arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXProgressBar, 1); arg2 = to_FXColor(argv[0]); (arg1)->setBarColor(arg2);
    return Qnil; }
static VALUE _wrap_FXProgressBar_getBarColor(int argc, VALUE *argv, VALUE self) { FXProgressBar *arg1 = (FXProgressBar *) 0 ;
    FXColor result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXProgressBar, 1);
    result = (FXColor)((FXProgressBar const *)arg1)->getBarColor(); vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXProgressBar_setTextColor(int argc, VALUE *argv, VALUE self) { FXProgressBar *arg1 = (FXProgressBar *) 0 ;
    FXColor arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXProgressBar, 1); arg2 = to_FXColor(argv[0]); (arg1)->setTextColor(arg2);
    return Qnil; }
static VALUE _wrap_FXProgressBar_getTextColor(int argc, VALUE *argv, VALUE self) { FXProgressBar *arg1 = (FXProgressBar *) 0 ;
    FXColor result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXProgressBar, 1);
    result = (FXColor)((FXProgressBar const *)arg1)->getTextColor(); vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXProgressBar_setTextAltColor(int argc, VALUE *argv, VALUE self) {
    FXProgressBar *arg1 = (FXProgressBar *) 0 ; FXColor arg2 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXProgressBar, 1); arg2 = to_FXColor(argv[0]);
    (arg1)->setTextAltColor(arg2); return Qnil; }
static VALUE _wrap_FXProgressBar_getTextAltColor(int argc, VALUE *argv, VALUE self) {
    FXProgressBar *arg1 = (FXProgressBar *) 0 ; FXColor result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXProgressBar, 1);
    result = (FXColor)((FXProgressBar const *)arg1)->getTextAltColor(); vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXProgressBar_setFont(int argc, VALUE *argv, VALUE self) { FXProgressBar *arg1 = (FXProgressBar *) 0 ;
    FXFont *arg2 = (FXFont *) 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXProgressBar, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXFont, 1); (arg1)->setFont(arg2); return Qnil; }
static VALUE _wrap_FXProgressBar_getFont(int argc, VALUE *argv, VALUE self) { FXProgressBar *arg1 = (FXProgressBar *) 0 ;
    FXFont *result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXProgressBar, 1);
    result = (FXFont *)((FXProgressBar const *)arg1)->getFont(); {
        swig_type_info *ty = SWIG_TypeDynamicCast(SWIGTYPE_p_FXFont, (void **) &result); vresult = FXRbGetRubyObj(result, ty); }
     return vresult; }
static VALUE _wrap_FXProgressBar_setBarStyle(int argc, VALUE *argv, VALUE self) { FXProgressBar *arg1 = (FXProgressBar *) 0 ;
    FXuint arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXProgressBar, 1); arg2 = NUM2UINT(argv[0]); (arg1)->setBarStyle(arg2);
    return Qnil; }
static VALUE _wrap_FXProgressBar_getBarStyle(int argc, VALUE *argv, VALUE self) { FXProgressBar *arg1 = (FXProgressBar *) 0 ;
    FXuint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXProgressBar, 1);
    result = (FXuint)((FXProgressBar const *)arg1)->getBarStyle(); vresult = UINT2NUM(result); return vresult; }
static void
free_FXProgressBar(FXProgressBar *arg1) {
    delete arg1;
}
static VALUE _wrap_FXProgressBar_save(int argc, VALUE *argv, VALUE self) { FXProgressBar *arg1 = (FXProgressBar *) 0 ;
    FXStream *arg2 = 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXProgressBar, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXProgressBar_save((FXProgressBar const *)arg1,*arg2); return Qnil; }
static VALUE _wrap_FXProgressBar_load(int argc, VALUE *argv, VALUE self) { FXProgressBar *arg1 = (FXProgressBar *) 0 ;
    FXStream *arg2 = 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXProgressBar, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXProgressBar_load(arg1,*arg2); return Qnil; }
static VALUE _wrap_FXProgressBar_create(int argc, VALUE *argv, VALUE self) { FXProgressBar *arg1 = (FXProgressBar *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXProgressBar, 1); FXProgressBar_create(arg1); return Qnil; }
static VALUE _wrap_FXProgressBar_detach(int argc, VALUE *argv, VALUE self) { FXProgressBar *arg1 = (FXProgressBar *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXProgressBar, 1); FXProgressBar_detach(arg1); return Qnil; }
static VALUE _wrap_FXProgressBar_destroy(int argc, VALUE *argv, VALUE self) { FXProgressBar *arg1 = (FXProgressBar *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXProgressBar, 1); FXProgressBar_destroy(arg1); return Qnil; }
static VALUE _wrap_FXProgressBar_resize(int argc, VALUE *argv, VALUE self) { FXProgressBar *arg1 = (FXProgressBar *) 0 ;
    FXint arg2 ; FXint arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXProgressBar, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    FXProgressBar_resize(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXProgressBar_getDefaultWidth(int argc, VALUE *argv, VALUE self) {
    FXProgressBar *arg1 = (FXProgressBar *) 0 ; FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXProgressBar, 1); result = (FXint)FXProgressBar_getDefaultWidth(arg1);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXProgressBar_getDefaultHeight(int argc, VALUE *argv, VALUE self) {
    FXProgressBar *arg1 = (FXProgressBar *) 0 ; FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXProgressBar, 1); result = (FXint)FXProgressBar_getDefaultHeight(arg1);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXProgressBar_getWidthForHeight(int argc, VALUE *argv, VALUE self) {
    FXProgressBar *arg1 = (FXProgressBar *) 0 ; FXint arg2 ; FXint result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXProgressBar, 1); arg2 = NUM2INT(argv[0]);
    result = (FXint)FXProgressBar_getWidthForHeight(arg1,arg2); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXProgressBar_getHeightForWidth(int argc, VALUE *argv, VALUE self) {
    FXProgressBar *arg1 = (FXProgressBar *) 0 ; FXint arg2 ; FXint result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXProgressBar, 1); arg2 = NUM2INT(argv[0]);
    result = (FXint)FXProgressBar_getHeightForWidth(arg1,arg2); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXProgressBar_canFocus(int argc, VALUE *argv, VALUE self) { FXProgressBar *arg1 = (FXProgressBar *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXProgressBar, 1);
    result = (FXbool)FXProgressBar_canFocus((FXProgressBar const *)arg1); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXProgressBar_setFocus(int argc, VALUE *argv, VALUE self) { FXProgressBar *arg1 = (FXProgressBar *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXProgressBar, 1); FXProgressBar_setFocus(arg1); return Qnil; }
static VALUE _wrap_FXProgressBar_killFocus(int argc, VALUE *argv, VALUE self) { FXProgressBar *arg1 = (FXProgressBar *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXProgressBar, 1); FXProgressBar_killFocus(arg1); return Qnil; }
static VALUE _wrap_FXProgressBar_setDefault(int argc, VALUE *argv, VALUE self) { FXProgressBar *arg1 = (FXProgressBar *) 0 ;
    FXbool arg2 = (FXbool) 1 ; if ((argc < 0) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXProgressBar, 1); if (argc > 0) { arg2 = to_FXbool(argv[0]); } 
    FXProgressBar_setDefault(arg1,arg2); return Qnil; }
static VALUE _wrap_FXProgressBar_enable(int argc, VALUE *argv, VALUE self) { FXProgressBar *arg1 = (FXProgressBar *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXProgressBar, 1); FXProgressBar_enable(arg1); return Qnil; }
static VALUE _wrap_FXProgressBar_disable(int argc, VALUE *argv, VALUE self) { FXProgressBar *arg1 = (FXProgressBar *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXProgressBar, 1); FXProgressBar_disable(arg1); return Qnil; }
static VALUE _wrap_FXProgressBar_raiseWindow(int argc, VALUE *argv, VALUE self) { FXProgressBar *arg1 = (FXProgressBar *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXProgressBar, 1); FXProgressBar_raise(arg1); return Qnil; }
static VALUE _wrap_FXProgressBar_lower(int argc, VALUE *argv, VALUE self) { FXProgressBar *arg1 = (FXProgressBar *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXProgressBar, 1); FXProgressBar_lower(arg1); return Qnil; }
static VALUE _wrap_FXProgressBar_move(int argc, VALUE *argv, VALUE self) { FXProgressBar *arg1 = (FXProgressBar *) 0 ;
    FXint arg2 ; FXint arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXProgressBar, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    FXProgressBar_move(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXProgressBar_position(int argc, VALUE *argv, VALUE self) { FXProgressBar *arg1 = (FXProgressBar *) 0 ;
    FXint arg2 ; FXint arg3 ; FXint arg4 ; FXint arg5 ; if ((argc < 4) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXProgressBar, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    arg4 = NUM2INT(argv[2]); arg5 = NUM2INT(argv[3]); FXProgressBar_position(arg1,arg2,arg3,arg4,arg5); return Qnil; }
static VALUE _wrap_FXProgressBar_layout(int argc, VALUE *argv, VALUE self) { FXProgressBar *arg1 = (FXProgressBar *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXProgressBar, 1); FXProgressBar_layout(arg1); return Qnil; }
static VALUE _wrap_FXProgressBar_recalc(int argc, VALUE *argv, VALUE self) { FXProgressBar *arg1 = (FXProgressBar *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXProgressBar, 1); FXProgressBar_recalc(arg1); return Qnil; }
static VALUE _wrap_FXProgressBar_reparent(int argc, VALUE *argv, VALUE self) { FXProgressBar *arg1 = (FXProgressBar *) 0 ;
    FXComposite *arg2 = (FXComposite *) 0 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXProgressBar, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXComposite, 1); FXProgressBar_reparent(arg1,arg2); return Qnil; }
static VALUE _wrap_FXProgressBar_show(int argc, VALUE *argv, VALUE self) { FXProgressBar *arg1 = (FXProgressBar *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXProgressBar, 1); FXProgressBar_show(arg1); return Qnil; }
static VALUE _wrap_FXProgressBar_hide(int argc, VALUE *argv, VALUE self) { FXProgressBar *arg1 = (FXProgressBar *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXProgressBar, 1); FXProgressBar_hide(arg1); return Qnil; }
static VALUE _wrap_FXProgressBar_isComposite(int argc, VALUE *argv, VALUE self) { FXProgressBar *arg1 = (FXProgressBar *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXProgressBar, 1);
    result = (FXbool)FXProgressBar_isComposite((FXProgressBar const *)arg1); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXProgressBar_contains(int argc, VALUE *argv, VALUE self) { FXProgressBar *arg1 = (FXProgressBar *) 0 ;
    FXint arg2 ; FXint arg3 ; FXbool result; VALUE vresult = Qnil; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXProgressBar, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    result = (FXbool)FXProgressBar_contains((FXProgressBar const *)arg1,arg2,arg3); vresult = result ? Qtrue : Qfalse;
    return vresult; }
static VALUE _wrap_FXProgressBar_doesSaveUnder(int argc, VALUE *argv, VALUE self) { FXProgressBar *arg1 = (FXProgressBar *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXProgressBar, 1);
    result = (FXbool)FXProgressBar_doesSaveUnder((FXProgressBar const *)arg1); vresult = result ? Qtrue : Qfalse;
    return vresult; }
static VALUE _wrap_FXProgressBar_setBackColor(int argc, VALUE *argv, VALUE self) { FXProgressBar *arg1 = (FXProgressBar *) 0 ;
    FXColor arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXProgressBar, 1); arg2 = to_FXColor(argv[0]);
    FXProgressBar_setBackColor(arg1,arg2); return Qnil; }
static VALUE _wrap_FXRuler_onPaint(int argc, VALUE *argv, VALUE self) { FXRuler *arg1 = (FXRuler *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRuler, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onPaint(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXRuler_onLeftBtnPress(int argc, VALUE *argv, VALUE self) { FXRuler *arg1 = (FXRuler *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRuler, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onLeftBtnPress(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXRuler_onLeftBtnRelease(int argc, VALUE *argv, VALUE self) { FXRuler *arg1 = (FXRuler *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRuler, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onLeftBtnRelease(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXRuler_onMotion(int argc, VALUE *argv, VALUE self) { FXRuler *arg1 = (FXRuler *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRuler, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onMotion(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXRuler_onCmdSetValue(int argc, VALUE *argv, VALUE self) { FXRuler *arg1 = (FXRuler *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRuler, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]);
    SWIG_ConvertPtr(argv[2], (void **) &arg4, 0, 1); result = (long)(arg1)->onCmdSetValue(arg2,arg3,arg4);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXRuler_onCmdSetIntValue(int argc, VALUE *argv, VALUE self) { FXRuler *arg1 = (FXRuler *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRuler, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]);
    SWIG_ConvertPtr(argv[2], (void **) &arg4, 0, 1); result = (long)(arg1)->onCmdSetIntValue(arg2,arg3,arg4);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXRuler_onCmdGetIntValue(int argc, VALUE *argv, VALUE self) { FXRuler *arg1 = (FXRuler *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRuler, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]);
    SWIG_ConvertPtr(argv[2], (void **) &arg4, 0, 1); result = (long)(arg1)->onCmdGetIntValue(arg2,arg3,arg4);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXRuler_onCmdSetHelp(int argc, VALUE *argv, VALUE self) { FXRuler *arg1 = (FXRuler *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; FXString value4 ;
    VALUE vresult = Qnil; if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRuler, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); {
        value4 = FXString(STR2CSTR(argv[2])); arg4 = (void *) &value4; }  result = (long)(arg1)->onCmdSetHelp(arg2,arg3,arg4);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXRuler_onCmdGetHelp(int argc, VALUE *argv, VALUE self) { FXRuler *arg1 = (FXRuler *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRuler, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdGetHelp(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXRuler_onCmdSetTip(int argc, VALUE *argv, VALUE self) { FXRuler *arg1 = (FXRuler *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; FXString value4 ;
    VALUE vresult = Qnil; if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRuler, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); {
        value4 = FXString(STR2CSTR(argv[2])); arg4 = (void *) &value4; }  result = (long)(arg1)->onCmdSetTip(arg2,arg3,arg4);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXRuler_onCmdGetTip(int argc, VALUE *argv, VALUE self) { FXRuler *arg1 = (FXRuler *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRuler, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdGetTip(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXRuler_onQueryHelp(int argc, VALUE *argv, VALUE self) { FXRuler *arg1 = (FXRuler *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRuler, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onQueryHelp(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXRuler_onQueryTip(int argc, VALUE *argv, VALUE self) { FXRuler *arg1 = (FXRuler *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRuler, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onQueryTip(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE _wrap_FXRuler_allocate(VALUE self) {
#else
     static VALUE _wrap_FXRuler_allocate(int argc, VALUE *argv, VALUE self) {
#endif
         VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_FXRuler);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
         return vresult; }
static VALUE _wrap_new_FXRuler(int argc, VALUE *argv, VALUE self) { FXComposite *arg1 = (FXComposite *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 = (FXSelector) 0 ; FXuint arg4 = (FXuint) RULER_NORMAL ;
    FXint arg5 = (FXint) 0 ; FXint arg6 = (FXint) 0 ; FXint arg7 = (FXint) 0 ; FXint arg8 = (FXint) 0 ;
    FXint arg9 = (FXint) DEFAULT_PAD ; FXint arg10 = (FXint) DEFAULT_PAD ; FXint arg11 = (FXint) DEFAULT_PAD ;
    FXint arg12 = (FXint) DEFAULT_PAD ; FXRuler *result; if ((argc < 1) || (argc > 12))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXComposite, 1); if (argc > 1) {
        SWIG_ConvertPtr(argv[1], (void **) &arg2, SWIGTYPE_p_FXObject, 1); }  if (argc > 2) { arg3 = NUM2UINT(argv[2]); } 
    if (argc > 3) { arg4 = NUM2UINT(argv[3]); }  if (argc > 4) { arg5 = NUM2INT(argv[4]); }  if (argc > 5) {
        arg6 = NUM2INT(argv[5]); }  if (argc > 6) { arg7 = NUM2INT(argv[6]); }  if (argc > 7) { arg8 = NUM2INT(argv[7]); } 
    if (argc > 8) { arg9 = NUM2INT(argv[8]); }  if (argc > 9) { arg10 = NUM2INT(argv[9]); }  if (argc > 10) {
        arg11 = NUM2INT(argv[10]); }  if (argc > 11) { arg12 = NUM2INT(argv[11]); }  {
        result = (FXRuler *)new_FXRuler(arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8,arg9,arg10,arg11,arg12);
        DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result); if(rb_block_given_p()){ rb_yield(self); }  }  return self; }
static VALUE _wrap_FXRuler_setFont(int argc, VALUE *argv, VALUE self) { FXRuler *arg1 = (FXRuler *) 0 ;
    FXFont *arg2 = (FXFont *) 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRuler, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXFont, 1); (arg1)->setFont(arg2); return Qnil; }
static VALUE _wrap_FXRuler_getFont(int argc, VALUE *argv, VALUE self) { FXRuler *arg1 = (FXRuler *) 0 ; FXFont *result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRuler, 1); result = (FXFont *)((FXRuler const *)arg1)->getFont(); {
        swig_type_info *ty = SWIG_TypeDynamicCast(SWIGTYPE_p_FXFont, (void **) &result); vresult = FXRbGetRubyObj(result, ty); }
     return vresult; }
static VALUE _wrap_FXRuler_setValue(int argc, VALUE *argv, VALUE self) { FXRuler *arg1 = (FXRuler *) 0 ; FXint arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRuler, 1); arg2 = NUM2INT(argv[0]); (arg1)->setValue(arg2);
    return Qnil; }
static VALUE _wrap_FXRuler_getValue(int argc, VALUE *argv, VALUE self) { FXRuler *arg1 = (FXRuler *) 0 ; FXint result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRuler, 1); result = (FXint)((FXRuler const *)arg1)->getValue();
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXRuler_setRulerStyle(int argc, VALUE *argv, VALUE self) { FXRuler *arg1 = (FXRuler *) 0 ; FXuint arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRuler, 1); arg2 = NUM2UINT(argv[0]); (arg1)->setRulerStyle(arg2);
    return Qnil; }
static VALUE _wrap_FXRuler_getRulerStyle(int argc, VALUE *argv, VALUE self) { FXRuler *arg1 = (FXRuler *) 0 ; FXuint result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRuler, 1); result = (FXuint)((FXRuler const *)arg1)->getRulerStyle();
    vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXRuler_getTextColor(int argc, VALUE *argv, VALUE self) { FXRuler *arg1 = (FXRuler *) 0 ; FXColor result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRuler, 1); result = (FXColor)((FXRuler const *)arg1)->getTextColor();
    vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXRuler_setTextColor(int argc, VALUE *argv, VALUE self) { FXRuler *arg1 = (FXRuler *) 0 ; FXColor arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRuler, 1); arg2 = to_FXColor(argv[0]); (arg1)->setTextColor(arg2);
    return Qnil; }
static VALUE _wrap_FXRuler_setHelpText(int argc, VALUE *argv, VALUE self) { FXRuler *arg1 = (FXRuler *) 0 ; FXString *arg2 = 0 ;
    SwigValueWrapper<FXString > p2 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRuler, 1); p2 = to_FXString(argv[0]); arg2 = &p2;
    (arg1)->setHelpText((FXString const &)*arg2); return Qnil; }
static VALUE _wrap_FXRuler_getHelpText(int argc, VALUE *argv, VALUE self) { FXRuler *arg1 = (FXRuler *) 0 ; FXString result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRuler, 1); result = ((FXRuler const *)arg1)->getHelpText();
    vresult = rb_str_new2((&result)->text()); return vresult; }
static VALUE _wrap_FXRuler_setTipText(int argc, VALUE *argv, VALUE self) { FXRuler *arg1 = (FXRuler *) 0 ; FXString *arg2 = 0 ;
    SwigValueWrapper<FXString > p2 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRuler, 1); p2 = to_FXString(argv[0]); arg2 = &p2;
    (arg1)->setTipText((FXString const &)*arg2); return Qnil; }
static VALUE _wrap_FXRuler_getTipText(int argc, VALUE *argv, VALUE self) { FXRuler *arg1 = (FXRuler *) 0 ; FXString result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRuler, 1); result = ((FXRuler const *)arg1)->getTipText();
    vresult = rb_str_new2((&result)->text()); return vresult; }
static void
free_FXRuler(FXRuler *arg1) {
    delete arg1;
}
static VALUE _wrap_FXRuler_save(int argc, VALUE *argv, VALUE self) { FXRuler *arg1 = (FXRuler *) 0 ; FXStream *arg2 = 0 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRuler, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXRuler_save((FXRuler const *)arg1,*arg2); return Qnil; }
static VALUE _wrap_FXRuler_load(int argc, VALUE *argv, VALUE self) { FXRuler *arg1 = (FXRuler *) 0 ; FXStream *arg2 = 0 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRuler, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXRuler_load(arg1,*arg2); return Qnil; }
static VALUE _wrap_FXRuler_create(int argc, VALUE *argv, VALUE self) { FXRuler *arg1 = (FXRuler *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRuler, 1); FXRuler_create(arg1); return Qnil; }
static VALUE _wrap_FXRuler_detach(int argc, VALUE *argv, VALUE self) { FXRuler *arg1 = (FXRuler *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRuler, 1); FXRuler_detach(arg1); return Qnil; }
static VALUE _wrap_FXRuler_destroy(int argc, VALUE *argv, VALUE self) { FXRuler *arg1 = (FXRuler *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRuler, 1); FXRuler_destroy(arg1); return Qnil; }
static VALUE _wrap_FXRuler_resize(int argc, VALUE *argv, VALUE self) { FXRuler *arg1 = (FXRuler *) 0 ; FXint arg2 ; FXint arg3 ;
    if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRuler, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    FXRuler_resize(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXRuler_getDefaultWidth(int argc, VALUE *argv, VALUE self) { FXRuler *arg1 = (FXRuler *) 0 ; FXint result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRuler, 1); result = (FXint)FXRuler_getDefaultWidth(arg1);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXRuler_getDefaultHeight(int argc, VALUE *argv, VALUE self) { FXRuler *arg1 = (FXRuler *) 0 ; FXint result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRuler, 1); result = (FXint)FXRuler_getDefaultHeight(arg1);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXRuler_getWidthForHeight(int argc, VALUE *argv, VALUE self) { FXRuler *arg1 = (FXRuler *) 0 ; FXint arg2 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRuler, 1); arg2 = NUM2INT(argv[0]);
    result = (FXint)FXRuler_getWidthForHeight(arg1,arg2); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXRuler_getHeightForWidth(int argc, VALUE *argv, VALUE self) { FXRuler *arg1 = (FXRuler *) 0 ; FXint arg2 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRuler, 1); arg2 = NUM2INT(argv[0]);
    result = (FXint)FXRuler_getHeightForWidth(arg1,arg2); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXRuler_canFocus(int argc, VALUE *argv, VALUE self) { FXRuler *arg1 = (FXRuler *) 0 ; FXbool result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRuler, 1); result = (FXbool)FXRuler_canFocus((FXRuler const *)arg1);
    vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXRuler_setFocus(int argc, VALUE *argv, VALUE self) { FXRuler *arg1 = (FXRuler *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRuler, 1); FXRuler_setFocus(arg1); return Qnil; }
static VALUE _wrap_FXRuler_killFocus(int argc, VALUE *argv, VALUE self) { FXRuler *arg1 = (FXRuler *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRuler, 1); FXRuler_killFocus(arg1); return Qnil; }
static VALUE _wrap_FXRuler_setDefault(int argc, VALUE *argv, VALUE self) { FXRuler *arg1 = (FXRuler *) 0 ;
    FXbool arg2 = (FXbool) 1 ; if ((argc < 0) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRuler, 1); if (argc > 0) { arg2 = to_FXbool(argv[0]); } 
    FXRuler_setDefault(arg1,arg2); return Qnil; }
static VALUE _wrap_FXRuler_enable(int argc, VALUE *argv, VALUE self) { FXRuler *arg1 = (FXRuler *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRuler, 1); FXRuler_enable(arg1); return Qnil; }
static VALUE _wrap_FXRuler_disable(int argc, VALUE *argv, VALUE self) { FXRuler *arg1 = (FXRuler *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRuler, 1); FXRuler_disable(arg1); return Qnil; }
static VALUE _wrap_FXRuler_raiseWindow(int argc, VALUE *argv, VALUE self) { FXRuler *arg1 = (FXRuler *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRuler, 1); FXRuler_raise(arg1); return Qnil; }
static VALUE _wrap_FXRuler_lower(int argc, VALUE *argv, VALUE self) { FXRuler *arg1 = (FXRuler *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRuler, 1); FXRuler_lower(arg1); return Qnil; }
static VALUE _wrap_FXRuler_move(int argc, VALUE *argv, VALUE self) { FXRuler *arg1 = (FXRuler *) 0 ; FXint arg2 ; FXint arg3 ;
    if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRuler, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    FXRuler_move(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXRuler_position(int argc, VALUE *argv, VALUE self) { FXRuler *arg1 = (FXRuler *) 0 ; FXint arg2 ;
    FXint arg3 ; FXint arg4 ; FXint arg5 ; if ((argc < 4) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRuler, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    arg4 = NUM2INT(argv[2]); arg5 = NUM2INT(argv[3]); FXRuler_position(arg1,arg2,arg3,arg4,arg5); return Qnil; }
static VALUE _wrap_FXRuler_layout(int argc, VALUE *argv, VALUE self) { FXRuler *arg1 = (FXRuler *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRuler, 1); FXRuler_layout(arg1); return Qnil; }
static VALUE _wrap_FXRuler_recalc(int argc, VALUE *argv, VALUE self) { FXRuler *arg1 = (FXRuler *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRuler, 1); FXRuler_recalc(arg1); return Qnil; }
static VALUE _wrap_FXRuler_reparent(int argc, VALUE *argv, VALUE self) { FXRuler *arg1 = (FXRuler *) 0 ;
    FXComposite *arg2 = (FXComposite *) 0 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRuler, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXComposite, 1); FXRuler_reparent(arg1,arg2); return Qnil; }
static VALUE _wrap_FXRuler_show(int argc, VALUE *argv, VALUE self) { FXRuler *arg1 = (FXRuler *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRuler, 1); FXRuler_show(arg1); return Qnil; }
static VALUE _wrap_FXRuler_hide(int argc, VALUE *argv, VALUE self) { FXRuler *arg1 = (FXRuler *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRuler, 1); FXRuler_hide(arg1); return Qnil; }
static VALUE _wrap_FXRuler_isComposite(int argc, VALUE *argv, VALUE self) { FXRuler *arg1 = (FXRuler *) 0 ; FXbool result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRuler, 1); result = (FXbool)FXRuler_isComposite((FXRuler const *)arg1);
    vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXRuler_contains(int argc, VALUE *argv, VALUE self) { FXRuler *arg1 = (FXRuler *) 0 ; FXint arg2 ;
    FXint arg3 ; FXbool result; VALUE vresult = Qnil; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRuler, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    result = (FXbool)FXRuler_contains((FXRuler const *)arg1,arg2,arg3); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXRuler_doesSaveUnder(int argc, VALUE *argv, VALUE self) { FXRuler *arg1 = (FXRuler *) 0 ; FXbool result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRuler, 1);
    result = (FXbool)FXRuler_doesSaveUnder((FXRuler const *)arg1); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXRuler_setBackColor(int argc, VALUE *argv, VALUE self) { FXRuler *arg1 = (FXRuler *) 0 ; FXColor arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRuler, 1); arg2 = to_FXColor(argv[0]); FXRuler_setBackColor(arg1,arg2);
    return Qnil; }
static VALUE _wrap_FXSeparator_onPaint(int argc, VALUE *argv, VALUE self) { FXSeparator *arg1 = (FXSeparator *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSeparator, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onPaint(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE _wrap_FXSeparator_allocate(VALUE self) {
#else
     static VALUE _wrap_FXSeparator_allocate(int argc, VALUE *argv, VALUE self) {
#endif
         VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_FXSeparator);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
         return vresult; }
static VALUE _wrap_new_FXSeparator(int argc, VALUE *argv, VALUE self) { FXComposite *arg1 = (FXComposite *) 0 ;
    FXuint arg2 = (FXuint) SEPARATOR_GROOVE|LAYOUT_FILL_X ; FXint arg3 = (FXint) 0 ; FXint arg4 = (FXint) 0 ;
    FXint arg5 = (FXint) 0 ; FXint arg6 = (FXint) 0 ; FXint arg7 = (FXint) 0 ; FXint arg8 = (FXint) 0 ; FXint arg9 = (FXint) 0 ;
    FXint arg10 = (FXint) 0 ; FXSeparator *result; if ((argc < 1) || (argc > 10))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXComposite, 1); if (argc > 1) { arg2 = NUM2UINT(argv[1]); } 
    if (argc > 2) { arg3 = NUM2INT(argv[2]); }  if (argc > 3) { arg4 = NUM2INT(argv[3]); }  if (argc > 4) {
        arg5 = NUM2INT(argv[4]); }  if (argc > 5) { arg6 = NUM2INT(argv[5]); }  if (argc > 6) { arg7 = NUM2INT(argv[6]); } 
    if (argc > 7) { arg8 = NUM2INT(argv[7]); }  if (argc > 8) { arg9 = NUM2INT(argv[8]); }  if (argc > 9) {
        arg10 = NUM2INT(argv[9]); } 
    result = (FXSeparator *)new_FXSeparator(arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8,arg9,arg10); DATA_PTR(self) = result;
    return self; }
static VALUE _wrap_FXSeparator_setSeparatorStyle(int argc, VALUE *argv, VALUE self) { FXSeparator *arg1 = (FXSeparator *) 0 ;
    FXuint arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSeparator, 1); arg2 = NUM2UINT(argv[0]);
    (arg1)->setSeparatorStyle(arg2); return Qnil; }
static VALUE _wrap_FXSeparator_getSeparatorStyle(int argc, VALUE *argv, VALUE self) { FXSeparator *arg1 = (FXSeparator *) 0 ;
    FXuint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSeparator, 1);
    result = (FXuint)((FXSeparator const *)arg1)->getSeparatorStyle(); vresult = UINT2NUM(result); return vresult; }
static void
free_FXSeparator(FXSeparator *arg1) {
    delete arg1;
}
static VALUE _wrap_FXSeparator_save(int argc, VALUE *argv, VALUE self) { FXSeparator *arg1 = (FXSeparator *) 0 ;
    FXStream *arg2 = 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSeparator, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXSeparator_save((FXSeparator const *)arg1,*arg2); return Qnil; }
static VALUE _wrap_FXSeparator_load(int argc, VALUE *argv, VALUE self) { FXSeparator *arg1 = (FXSeparator *) 0 ;
    FXStream *arg2 = 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSeparator, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXSeparator_load(arg1,*arg2); return Qnil; }
static VALUE _wrap_FXSeparator_create(int argc, VALUE *argv, VALUE self) { FXSeparator *arg1 = (FXSeparator *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSeparator, 1); FXSeparator_create(arg1); return Qnil; }
static VALUE _wrap_FXSeparator_detach(int argc, VALUE *argv, VALUE self) { FXSeparator *arg1 = (FXSeparator *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSeparator, 1); FXSeparator_detach(arg1); return Qnil; }
static VALUE _wrap_FXSeparator_destroy(int argc, VALUE *argv, VALUE self) { FXSeparator *arg1 = (FXSeparator *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSeparator, 1); FXSeparator_destroy(arg1); return Qnil; }
static VALUE _wrap_FXSeparator_resize(int argc, VALUE *argv, VALUE self) { FXSeparator *arg1 = (FXSeparator *) 0 ; FXint arg2 ;
    FXint arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSeparator, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    FXSeparator_resize(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXSeparator_getDefaultWidth(int argc, VALUE *argv, VALUE self) { FXSeparator *arg1 = (FXSeparator *) 0 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSeparator, 1); result = (FXint)FXSeparator_getDefaultWidth(arg1);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXSeparator_getDefaultHeight(int argc, VALUE *argv, VALUE self) { FXSeparator *arg1 = (FXSeparator *) 0 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSeparator, 1); result = (FXint)FXSeparator_getDefaultHeight(arg1);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXSeparator_getWidthForHeight(int argc, VALUE *argv, VALUE self) { FXSeparator *arg1 = (FXSeparator *) 0 ;
    FXint arg2 ; FXint result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSeparator, 1); arg2 = NUM2INT(argv[0]);
    result = (FXint)FXSeparator_getWidthForHeight(arg1,arg2); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXSeparator_getHeightForWidth(int argc, VALUE *argv, VALUE self) { FXSeparator *arg1 = (FXSeparator *) 0 ;
    FXint arg2 ; FXint result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSeparator, 1); arg2 = NUM2INT(argv[0]);
    result = (FXint)FXSeparator_getHeightForWidth(arg1,arg2); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXSeparator_canFocus(int argc, VALUE *argv, VALUE self) { FXSeparator *arg1 = (FXSeparator *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSeparator, 1);
    result = (FXbool)FXSeparator_canFocus((FXSeparator const *)arg1); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXSeparator_setFocus(int argc, VALUE *argv, VALUE self) { FXSeparator *arg1 = (FXSeparator *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSeparator, 1); FXSeparator_setFocus(arg1); return Qnil; }
static VALUE _wrap_FXSeparator_killFocus(int argc, VALUE *argv, VALUE self) { FXSeparator *arg1 = (FXSeparator *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSeparator, 1); FXSeparator_killFocus(arg1); return Qnil; }
static VALUE _wrap_FXSeparator_setDefault(int argc, VALUE *argv, VALUE self) { FXSeparator *arg1 = (FXSeparator *) 0 ;
    FXbool arg2 = (FXbool) 1 ; if ((argc < 0) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSeparator, 1); if (argc > 0) { arg2 = to_FXbool(argv[0]); } 
    FXSeparator_setDefault(arg1,arg2); return Qnil; }
static VALUE _wrap_FXSeparator_enable(int argc, VALUE *argv, VALUE self) { FXSeparator *arg1 = (FXSeparator *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSeparator, 1); FXSeparator_enable(arg1); return Qnil; }
static VALUE _wrap_FXSeparator_disable(int argc, VALUE *argv, VALUE self) { FXSeparator *arg1 = (FXSeparator *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSeparator, 1); FXSeparator_disable(arg1); return Qnil; }
static VALUE _wrap_FXSeparator_raiseWindow(int argc, VALUE *argv, VALUE self) { FXSeparator *arg1 = (FXSeparator *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSeparator, 1); FXSeparator_raise(arg1); return Qnil; }
static VALUE _wrap_FXSeparator_lower(int argc, VALUE *argv, VALUE self) { FXSeparator *arg1 = (FXSeparator *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSeparator, 1); FXSeparator_lower(arg1); return Qnil; }
static VALUE _wrap_FXSeparator_move(int argc, VALUE *argv, VALUE self) { FXSeparator *arg1 = (FXSeparator *) 0 ; FXint arg2 ;
    FXint arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSeparator, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    FXSeparator_move(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXSeparator_position(int argc, VALUE *argv, VALUE self) { FXSeparator *arg1 = (FXSeparator *) 0 ;
    FXint arg2 ; FXint arg3 ; FXint arg4 ; FXint arg5 ; if ((argc < 4) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSeparator, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    arg4 = NUM2INT(argv[2]); arg5 = NUM2INT(argv[3]); FXSeparator_position(arg1,arg2,arg3,arg4,arg5); return Qnil; }
static VALUE _wrap_FXSeparator_layout(int argc, VALUE *argv, VALUE self) { FXSeparator *arg1 = (FXSeparator *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSeparator, 1); FXSeparator_layout(arg1); return Qnil; }
static VALUE _wrap_FXSeparator_recalc(int argc, VALUE *argv, VALUE self) { FXSeparator *arg1 = (FXSeparator *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSeparator, 1); FXSeparator_recalc(arg1); return Qnil; }
static VALUE _wrap_FXSeparator_reparent(int argc, VALUE *argv, VALUE self) { FXSeparator *arg1 = (FXSeparator *) 0 ;
    FXComposite *arg2 = (FXComposite *) 0 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSeparator, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXComposite, 1); FXSeparator_reparent(arg1,arg2); return Qnil; }
static VALUE _wrap_FXSeparator_show(int argc, VALUE *argv, VALUE self) { FXSeparator *arg1 = (FXSeparator *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSeparator, 1); FXSeparator_show(arg1); return Qnil; }
static VALUE _wrap_FXSeparator_hide(int argc, VALUE *argv, VALUE self) { FXSeparator *arg1 = (FXSeparator *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSeparator, 1); FXSeparator_hide(arg1); return Qnil; }
static VALUE _wrap_FXSeparator_isComposite(int argc, VALUE *argv, VALUE self) { FXSeparator *arg1 = (FXSeparator *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSeparator, 1);
    result = (FXbool)FXSeparator_isComposite((FXSeparator const *)arg1); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXSeparator_contains(int argc, VALUE *argv, VALUE self) { FXSeparator *arg1 = (FXSeparator *) 0 ;
    FXint arg2 ; FXint arg3 ; FXbool result; VALUE vresult = Qnil; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSeparator, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    result = (FXbool)FXSeparator_contains((FXSeparator const *)arg1,arg2,arg3); vresult = result ? Qtrue : Qfalse;
    return vresult; }
static VALUE _wrap_FXSeparator_doesSaveUnder(int argc, VALUE *argv, VALUE self) { FXSeparator *arg1 = (FXSeparator *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSeparator, 1);
    result = (FXbool)FXSeparator_doesSaveUnder((FXSeparator const *)arg1); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXSeparator_setBackColor(int argc, VALUE *argv, VALUE self) { FXSeparator *arg1 = (FXSeparator *) 0 ;
    FXColor arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSeparator, 1); arg2 = to_FXColor(argv[0]);
    FXSeparator_setBackColor(arg1,arg2); return Qnil; }
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE _wrap_FXHorizontalSeparator_allocate(VALUE self) {
#else
     static VALUE _wrap_FXHorizontalSeparator_allocate(int argc, VALUE *argv, VALUE self) {
#endif
         VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_FXHorizontalSeparator);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
         return vresult; }
static VALUE _wrap_new_FXHorizontalSeparator(int argc, VALUE *argv, VALUE self) { FXComposite *arg1 = (FXComposite *) 0 ;
    FXuint arg2 = (FXuint) SEPARATOR_GROOVE|LAYOUT_FILL_X ; FXint arg3 = (FXint) 0 ; FXint arg4 = (FXint) 0 ;
    FXint arg5 = (FXint) 0 ; FXint arg6 = (FXint) 0 ; FXint arg7 = (FXint) 1 ; FXint arg8 = (FXint) 1 ; FXint arg9 = (FXint) 0 ;
    FXint arg10 = (FXint) 0 ; FXHorizontalSeparator *result; if ((argc < 1) || (argc > 10))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXComposite, 1); if (argc > 1) { arg2 = NUM2UINT(argv[1]); } 
    if (argc > 2) { arg3 = NUM2INT(argv[2]); }  if (argc > 3) { arg4 = NUM2INT(argv[3]); }  if (argc > 4) {
        arg5 = NUM2INT(argv[4]); }  if (argc > 5) { arg6 = NUM2INT(argv[5]); }  if (argc > 6) { arg7 = NUM2INT(argv[6]); } 
    if (argc > 7) { arg8 = NUM2INT(argv[7]); }  if (argc > 8) { arg9 = NUM2INT(argv[8]); }  if (argc > 9) {
        arg10 = NUM2INT(argv[9]); }  {
        result = (FXHorizontalSeparator *)new_FXHorizontalSeparator(arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8,arg9,arg10);
        DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result); if(rb_block_given_p()){ rb_yield(self); }  }  return self; }
static void
free_FXHorizontalSeparator(FXHorizontalSeparator *arg1) {
    delete arg1;
}
static VALUE _wrap_FXHorizontalSeparator_save(int argc, VALUE *argv, VALUE self) {
    FXHorizontalSeparator *arg1 = (FXHorizontalSeparator *) 0 ; FXStream *arg2 = 0 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXHorizontalSeparator, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXHorizontalSeparator_save((FXHorizontalSeparator const *)arg1,*arg2); return Qnil; }
static VALUE _wrap_FXHorizontalSeparator_load(int argc, VALUE *argv, VALUE self) {
    FXHorizontalSeparator *arg1 = (FXHorizontalSeparator *) 0 ; FXStream *arg2 = 0 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXHorizontalSeparator, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXHorizontalSeparator_load(arg1,*arg2); return Qnil; }
static VALUE _wrap_FXHorizontalSeparator_create(int argc, VALUE *argv, VALUE self) {
    FXHorizontalSeparator *arg1 = (FXHorizontalSeparator *) 0 ; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXHorizontalSeparator, 1); FXHorizontalSeparator_create(arg1);
    return Qnil; }
static VALUE _wrap_FXHorizontalSeparator_detach(int argc, VALUE *argv, VALUE self) {
    FXHorizontalSeparator *arg1 = (FXHorizontalSeparator *) 0 ; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXHorizontalSeparator, 1); FXHorizontalSeparator_detach(arg1);
    return Qnil; }
static VALUE _wrap_FXHorizontalSeparator_destroy(int argc, VALUE *argv, VALUE self) {
    FXHorizontalSeparator *arg1 = (FXHorizontalSeparator *) 0 ; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXHorizontalSeparator, 1); FXHorizontalSeparator_destroy(arg1);
    return Qnil; }
static VALUE _wrap_FXHorizontalSeparator_resize(int argc, VALUE *argv, VALUE self) {
    FXHorizontalSeparator *arg1 = (FXHorizontalSeparator *) 0 ; FXint arg2 ; FXint arg3 ; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXHorizontalSeparator, 1); arg2 = NUM2INT(argv[0]);
    arg3 = NUM2INT(argv[1]); FXHorizontalSeparator_resize(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXHorizontalSeparator_getDefaultWidth(int argc, VALUE *argv, VALUE self) {
    FXHorizontalSeparator *arg1 = (FXHorizontalSeparator *) 0 ; FXint result; VALUE vresult = Qnil;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXHorizontalSeparator, 1);
    result = (FXint)FXHorizontalSeparator_getDefaultWidth(arg1); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXHorizontalSeparator_getDefaultHeight(int argc, VALUE *argv, VALUE self) {
    FXHorizontalSeparator *arg1 = (FXHorizontalSeparator *) 0 ; FXint result; VALUE vresult = Qnil;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXHorizontalSeparator, 1);
    result = (FXint)FXHorizontalSeparator_getDefaultHeight(arg1); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXHorizontalSeparator_getWidthForHeight(int argc, VALUE *argv, VALUE self) {
    FXHorizontalSeparator *arg1 = (FXHorizontalSeparator *) 0 ; FXint arg2 ; FXint result; VALUE vresult = Qnil;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXHorizontalSeparator, 1); arg2 = NUM2INT(argv[0]);
    result = (FXint)FXHorizontalSeparator_getWidthForHeight(arg1,arg2); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXHorizontalSeparator_getHeightForWidth(int argc, VALUE *argv, VALUE self) {
    FXHorizontalSeparator *arg1 = (FXHorizontalSeparator *) 0 ; FXint arg2 ; FXint result; VALUE vresult = Qnil;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXHorizontalSeparator, 1); arg2 = NUM2INT(argv[0]);
    result = (FXint)FXHorizontalSeparator_getHeightForWidth(arg1,arg2); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXHorizontalSeparator_canFocus(int argc, VALUE *argv, VALUE self) {
    FXHorizontalSeparator *arg1 = (FXHorizontalSeparator *) 0 ; FXbool result; VALUE vresult = Qnil;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXHorizontalSeparator, 1);
    result = (FXbool)FXHorizontalSeparator_canFocus((FXHorizontalSeparator const *)arg1); vresult = result ? Qtrue : Qfalse;
    return vresult; }
static VALUE _wrap_FXHorizontalSeparator_setFocus(int argc, VALUE *argv, VALUE self) {
    FXHorizontalSeparator *arg1 = (FXHorizontalSeparator *) 0 ; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXHorizontalSeparator, 1); FXHorizontalSeparator_setFocus(arg1);
    return Qnil; }
static VALUE _wrap_FXHorizontalSeparator_killFocus(int argc, VALUE *argv, VALUE self) {
    FXHorizontalSeparator *arg1 = (FXHorizontalSeparator *) 0 ; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXHorizontalSeparator, 1); FXHorizontalSeparator_killFocus(arg1);
    return Qnil; }
static VALUE _wrap_FXHorizontalSeparator_setDefault(int argc, VALUE *argv, VALUE self) {
    FXHorizontalSeparator *arg1 = (FXHorizontalSeparator *) 0 ; FXbool arg2 = (FXbool) 1 ; if ((argc < 0) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXHorizontalSeparator, 1); if (argc > 0) { arg2 = to_FXbool(argv[0]); } 
    FXHorizontalSeparator_setDefault(arg1,arg2); return Qnil; }
static VALUE _wrap_FXHorizontalSeparator_enable(int argc, VALUE *argv, VALUE self) {
    FXHorizontalSeparator *arg1 = (FXHorizontalSeparator *) 0 ; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXHorizontalSeparator, 1); FXHorizontalSeparator_enable(arg1);
    return Qnil; }
static VALUE _wrap_FXHorizontalSeparator_disable(int argc, VALUE *argv, VALUE self) {
    FXHorizontalSeparator *arg1 = (FXHorizontalSeparator *) 0 ; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXHorizontalSeparator, 1); FXHorizontalSeparator_disable(arg1);
    return Qnil; }
static VALUE _wrap_FXHorizontalSeparator_raiseWindow(int argc, VALUE *argv, VALUE self) {
    FXHorizontalSeparator *arg1 = (FXHorizontalSeparator *) 0 ; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXHorizontalSeparator, 1); FXHorizontalSeparator_raise(arg1);
    return Qnil; }
static VALUE _wrap_FXHorizontalSeparator_lower(int argc, VALUE *argv, VALUE self) {
    FXHorizontalSeparator *arg1 = (FXHorizontalSeparator *) 0 ; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXHorizontalSeparator, 1); FXHorizontalSeparator_lower(arg1);
    return Qnil; }
static VALUE _wrap_FXHorizontalSeparator_move(int argc, VALUE *argv, VALUE self) {
    FXHorizontalSeparator *arg1 = (FXHorizontalSeparator *) 0 ; FXint arg2 ; FXint arg3 ; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXHorizontalSeparator, 1); arg2 = NUM2INT(argv[0]);
    arg3 = NUM2INT(argv[1]); FXHorizontalSeparator_move(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXHorizontalSeparator_position(int argc, VALUE *argv, VALUE self) {
    FXHorizontalSeparator *arg1 = (FXHorizontalSeparator *) 0 ; FXint arg2 ; FXint arg3 ; FXint arg4 ; FXint arg5 ;
    if ((argc < 4) || (argc > 4)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXHorizontalSeparator, 1); arg2 = NUM2INT(argv[0]);
    arg3 = NUM2INT(argv[1]); arg4 = NUM2INT(argv[2]); arg5 = NUM2INT(argv[3]);
    FXHorizontalSeparator_position(arg1,arg2,arg3,arg4,arg5); return Qnil; }
static VALUE _wrap_FXHorizontalSeparator_layout(int argc, VALUE *argv, VALUE self) {
    FXHorizontalSeparator *arg1 = (FXHorizontalSeparator *) 0 ; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXHorizontalSeparator, 1); FXHorizontalSeparator_layout(arg1);
    return Qnil; }
static VALUE _wrap_FXHorizontalSeparator_recalc(int argc, VALUE *argv, VALUE self) {
    FXHorizontalSeparator *arg1 = (FXHorizontalSeparator *) 0 ; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXHorizontalSeparator, 1); FXHorizontalSeparator_recalc(arg1);
    return Qnil; }
static VALUE _wrap_FXHorizontalSeparator_reparent(int argc, VALUE *argv, VALUE self) {
    FXHorizontalSeparator *arg1 = (FXHorizontalSeparator *) 0 ; FXComposite *arg2 = (FXComposite *) 0 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXHorizontalSeparator, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXComposite, 1); FXHorizontalSeparator_reparent(arg1,arg2);
    return Qnil; }
static VALUE _wrap_FXHorizontalSeparator_show(int argc, VALUE *argv, VALUE self) {
    FXHorizontalSeparator *arg1 = (FXHorizontalSeparator *) 0 ; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXHorizontalSeparator, 1); FXHorizontalSeparator_show(arg1); return Qnil; }
static VALUE _wrap_FXHorizontalSeparator_hide(int argc, VALUE *argv, VALUE self) {
    FXHorizontalSeparator *arg1 = (FXHorizontalSeparator *) 0 ; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXHorizontalSeparator, 1); FXHorizontalSeparator_hide(arg1); return Qnil; }
static VALUE _wrap_FXHorizontalSeparator_isComposite(int argc, VALUE *argv, VALUE self) {
    FXHorizontalSeparator *arg1 = (FXHorizontalSeparator *) 0 ; FXbool result; VALUE vresult = Qnil;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXHorizontalSeparator, 1);
    result = (FXbool)FXHorizontalSeparator_isComposite((FXHorizontalSeparator const *)arg1); vresult = result ? Qtrue : Qfalse;
    return vresult; }
static VALUE _wrap_FXHorizontalSeparator_contains(int argc, VALUE *argv, VALUE self) {
    FXHorizontalSeparator *arg1 = (FXHorizontalSeparator *) 0 ; FXint arg2 ; FXint arg3 ; FXbool result; VALUE vresult = Qnil;
    if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXHorizontalSeparator, 1); arg2 = NUM2INT(argv[0]);
    arg3 = NUM2INT(argv[1]); result = (FXbool)FXHorizontalSeparator_contains((FXHorizontalSeparator const *)arg1,arg2,arg3);
    vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXHorizontalSeparator_doesSaveUnder(int argc, VALUE *argv, VALUE self) {
    FXHorizontalSeparator *arg1 = (FXHorizontalSeparator *) 0 ; FXbool result; VALUE vresult = Qnil;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXHorizontalSeparator, 1);
    result = (FXbool)FXHorizontalSeparator_doesSaveUnder((FXHorizontalSeparator const *)arg1);
    vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXHorizontalSeparator_setBackColor(int argc, VALUE *argv, VALUE self) {
    FXHorizontalSeparator *arg1 = (FXHorizontalSeparator *) 0 ; FXColor arg2 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXHorizontalSeparator, 1); arg2 = to_FXColor(argv[0]);
    FXHorizontalSeparator_setBackColor(arg1,arg2); return Qnil; }
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE _wrap_FXVerticalSeparator_allocate(VALUE self) {
#else
     static VALUE _wrap_FXVerticalSeparator_allocate(int argc, VALUE *argv, VALUE self) {
#endif
         VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_FXVerticalSeparator);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
         return vresult; }
static VALUE _wrap_new_FXVerticalSeparator(int argc, VALUE *argv, VALUE self) { FXComposite *arg1 = (FXComposite *) 0 ;
    FXuint arg2 = (FXuint) SEPARATOR_GROOVE|LAYOUT_FILL_Y ; FXint arg3 = (FXint) 0 ; FXint arg4 = (FXint) 0 ;
    FXint arg5 = (FXint) 0 ; FXint arg6 = (FXint) 0 ; FXint arg7 = (FXint) 0 ; FXint arg8 = (FXint) 0 ; FXint arg9 = (FXint) 1 ;
    FXint arg10 = (FXint) 1 ; FXVerticalSeparator *result; if ((argc < 1) || (argc > 10))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXComposite, 1); if (argc > 1) { arg2 = NUM2UINT(argv[1]); } 
    if (argc > 2) { arg3 = NUM2INT(argv[2]); }  if (argc > 3) { arg4 = NUM2INT(argv[3]); }  if (argc > 4) {
        arg5 = NUM2INT(argv[4]); }  if (argc > 5) { arg6 = NUM2INT(argv[5]); }  if (argc > 6) { arg7 = NUM2INT(argv[6]); } 
    if (argc > 7) { arg8 = NUM2INT(argv[7]); }  if (argc > 8) { arg9 = NUM2INT(argv[8]); }  if (argc > 9) {
        arg10 = NUM2INT(argv[9]); }  {
        result = (FXVerticalSeparator *)new_FXVerticalSeparator(arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8,arg9,arg10);
        DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result); if(rb_block_given_p()){ rb_yield(self); }  }  return self; }
static void
free_FXVerticalSeparator(FXVerticalSeparator *arg1) {
    delete arg1;
}
static VALUE _wrap_FXVerticalSeparator_save(int argc, VALUE *argv, VALUE self) {
    FXVerticalSeparator *arg1 = (FXVerticalSeparator *) 0 ; FXStream *arg2 = 0 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXVerticalSeparator, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXVerticalSeparator_save((FXVerticalSeparator const *)arg1,*arg2); return Qnil; }
static VALUE _wrap_FXVerticalSeparator_load(int argc, VALUE *argv, VALUE self) {
    FXVerticalSeparator *arg1 = (FXVerticalSeparator *) 0 ; FXStream *arg2 = 0 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXVerticalSeparator, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXVerticalSeparator_load(arg1,*arg2); return Qnil; }
static VALUE _wrap_FXVerticalSeparator_create(int argc, VALUE *argv, VALUE self) {
    FXVerticalSeparator *arg1 = (FXVerticalSeparator *) 0 ; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXVerticalSeparator, 1); FXVerticalSeparator_create(arg1); return Qnil; }
static VALUE _wrap_FXVerticalSeparator_detach(int argc, VALUE *argv, VALUE self) {
    FXVerticalSeparator *arg1 = (FXVerticalSeparator *) 0 ; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXVerticalSeparator, 1); FXVerticalSeparator_detach(arg1); return Qnil; }
static VALUE _wrap_FXVerticalSeparator_destroy(int argc, VALUE *argv, VALUE self) {
    FXVerticalSeparator *arg1 = (FXVerticalSeparator *) 0 ; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXVerticalSeparator, 1); FXVerticalSeparator_destroy(arg1); return Qnil; }
static VALUE _wrap_FXVerticalSeparator_resize(int argc, VALUE *argv, VALUE self) {
    FXVerticalSeparator *arg1 = (FXVerticalSeparator *) 0 ; FXint arg2 ; FXint arg3 ; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXVerticalSeparator, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    FXVerticalSeparator_resize(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXVerticalSeparator_getDefaultWidth(int argc, VALUE *argv, VALUE self) {
    FXVerticalSeparator *arg1 = (FXVerticalSeparator *) 0 ; FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXVerticalSeparator, 1);
    result = (FXint)FXVerticalSeparator_getDefaultWidth(arg1); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXVerticalSeparator_getDefaultHeight(int argc, VALUE *argv, VALUE self) {
    FXVerticalSeparator *arg1 = (FXVerticalSeparator *) 0 ; FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXVerticalSeparator, 1);
    result = (FXint)FXVerticalSeparator_getDefaultHeight(arg1); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXVerticalSeparator_getWidthForHeight(int argc, VALUE *argv, VALUE self) {
    FXVerticalSeparator *arg1 = (FXVerticalSeparator *) 0 ; FXint arg2 ; FXint result; VALUE vresult = Qnil;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXVerticalSeparator, 1); arg2 = NUM2INT(argv[0]);
    result = (FXint)FXVerticalSeparator_getWidthForHeight(arg1,arg2); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXVerticalSeparator_getHeightForWidth(int argc, VALUE *argv, VALUE self) {
    FXVerticalSeparator *arg1 = (FXVerticalSeparator *) 0 ; FXint arg2 ; FXint result; VALUE vresult = Qnil;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXVerticalSeparator, 1); arg2 = NUM2INT(argv[0]);
    result = (FXint)FXVerticalSeparator_getHeightForWidth(arg1,arg2); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXVerticalSeparator_canFocus(int argc, VALUE *argv, VALUE self) {
    FXVerticalSeparator *arg1 = (FXVerticalSeparator *) 0 ; FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXVerticalSeparator, 1);
    result = (FXbool)FXVerticalSeparator_canFocus((FXVerticalSeparator const *)arg1); vresult = result ? Qtrue : Qfalse;
    return vresult; }
static VALUE _wrap_FXVerticalSeparator_setFocus(int argc, VALUE *argv, VALUE self) {
    FXVerticalSeparator *arg1 = (FXVerticalSeparator *) 0 ; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXVerticalSeparator, 1); FXVerticalSeparator_setFocus(arg1); return Qnil; }
static VALUE _wrap_FXVerticalSeparator_killFocus(int argc, VALUE *argv, VALUE self) {
    FXVerticalSeparator *arg1 = (FXVerticalSeparator *) 0 ; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXVerticalSeparator, 1); FXVerticalSeparator_killFocus(arg1);
    return Qnil; }
static VALUE _wrap_FXVerticalSeparator_setDefault(int argc, VALUE *argv, VALUE self) {
    FXVerticalSeparator *arg1 = (FXVerticalSeparator *) 0 ; FXbool arg2 = (FXbool) 1 ; if ((argc < 0) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXVerticalSeparator, 1); if (argc > 0) { arg2 = to_FXbool(argv[0]); } 
    FXVerticalSeparator_setDefault(arg1,arg2); return Qnil; }
static VALUE _wrap_FXVerticalSeparator_enable(int argc, VALUE *argv, VALUE self) {
    FXVerticalSeparator *arg1 = (FXVerticalSeparator *) 0 ; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXVerticalSeparator, 1); FXVerticalSeparator_enable(arg1); return Qnil; }
static VALUE _wrap_FXVerticalSeparator_disable(int argc, VALUE *argv, VALUE self) {
    FXVerticalSeparator *arg1 = (FXVerticalSeparator *) 0 ; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXVerticalSeparator, 1); FXVerticalSeparator_disable(arg1); return Qnil; }
static VALUE _wrap_FXVerticalSeparator_raiseWindow(int argc, VALUE *argv, VALUE self) {
    FXVerticalSeparator *arg1 = (FXVerticalSeparator *) 0 ; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXVerticalSeparator, 1); FXVerticalSeparator_raise(arg1); return Qnil; }
static VALUE _wrap_FXVerticalSeparator_lower(int argc, VALUE *argv, VALUE self) {
    FXVerticalSeparator *arg1 = (FXVerticalSeparator *) 0 ; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXVerticalSeparator, 1); FXVerticalSeparator_lower(arg1); return Qnil; }
static VALUE _wrap_FXVerticalSeparator_move(int argc, VALUE *argv, VALUE self) {
    FXVerticalSeparator *arg1 = (FXVerticalSeparator *) 0 ; FXint arg2 ; FXint arg3 ; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXVerticalSeparator, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    FXVerticalSeparator_move(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXVerticalSeparator_position(int argc, VALUE *argv, VALUE self) {
    FXVerticalSeparator *arg1 = (FXVerticalSeparator *) 0 ; FXint arg2 ; FXint arg3 ; FXint arg4 ; FXint arg5 ;
    if ((argc < 4) || (argc > 4)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXVerticalSeparator, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    arg4 = NUM2INT(argv[2]); arg5 = NUM2INT(argv[3]); FXVerticalSeparator_position(arg1,arg2,arg3,arg4,arg5); return Qnil; }
static VALUE _wrap_FXVerticalSeparator_layout(int argc, VALUE *argv, VALUE self) {
    FXVerticalSeparator *arg1 = (FXVerticalSeparator *) 0 ; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXVerticalSeparator, 1); FXVerticalSeparator_layout(arg1); return Qnil; }
static VALUE _wrap_FXVerticalSeparator_recalc(int argc, VALUE *argv, VALUE self) {
    FXVerticalSeparator *arg1 = (FXVerticalSeparator *) 0 ; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXVerticalSeparator, 1); FXVerticalSeparator_recalc(arg1); return Qnil; }
static VALUE _wrap_FXVerticalSeparator_reparent(int argc, VALUE *argv, VALUE self) {
    FXVerticalSeparator *arg1 = (FXVerticalSeparator *) 0 ; FXComposite *arg2 = (FXComposite *) 0 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXVerticalSeparator, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXComposite, 1); FXVerticalSeparator_reparent(arg1,arg2); return Qnil; }
static VALUE _wrap_FXVerticalSeparator_show(int argc, VALUE *argv, VALUE self) {
    FXVerticalSeparator *arg1 = (FXVerticalSeparator *) 0 ; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXVerticalSeparator, 1); FXVerticalSeparator_show(arg1); return Qnil; }
static VALUE _wrap_FXVerticalSeparator_hide(int argc, VALUE *argv, VALUE self) {
    FXVerticalSeparator *arg1 = (FXVerticalSeparator *) 0 ; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXVerticalSeparator, 1); FXVerticalSeparator_hide(arg1); return Qnil; }
static VALUE _wrap_FXVerticalSeparator_isComposite(int argc, VALUE *argv, VALUE self) {
    FXVerticalSeparator *arg1 = (FXVerticalSeparator *) 0 ; FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXVerticalSeparator, 1);
    result = (FXbool)FXVerticalSeparator_isComposite((FXVerticalSeparator const *)arg1); vresult = result ? Qtrue : Qfalse;
    return vresult; }
static VALUE _wrap_FXVerticalSeparator_contains(int argc, VALUE *argv, VALUE self) {
    FXVerticalSeparator *arg1 = (FXVerticalSeparator *) 0 ; FXint arg2 ; FXint arg3 ; FXbool result; VALUE vresult = Qnil;
    if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXVerticalSeparator, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    result = (FXbool)FXVerticalSeparator_contains((FXVerticalSeparator const *)arg1,arg2,arg3);
    vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXVerticalSeparator_doesSaveUnder(int argc, VALUE *argv, VALUE self) {
    FXVerticalSeparator *arg1 = (FXVerticalSeparator *) 0 ; FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXVerticalSeparator, 1);
    result = (FXbool)FXVerticalSeparator_doesSaveUnder((FXVerticalSeparator const *)arg1); vresult = result ? Qtrue : Qfalse;
    return vresult; }
static VALUE _wrap_FXVerticalSeparator_setBackColor(int argc, VALUE *argv, VALUE self) {
    FXVerticalSeparator *arg1 = (FXVerticalSeparator *) 0 ; FXColor arg2 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXVerticalSeparator, 1); arg2 = to_FXColor(argv[0]);
    FXVerticalSeparator_setBackColor(arg1,arg2); return Qnil; }
static VALUE _wrap_FXSlider_onPaint(int argc, VALUE *argv, VALUE self) { FXSlider *arg1 = (FXSlider *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSlider, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onPaint(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXSlider_onLeftBtnPress(int argc, VALUE *argv, VALUE self) { FXSlider *arg1 = (FXSlider *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSlider, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onLeftBtnPress(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXSlider_onLeftBtnRelease(int argc, VALUE *argv, VALUE self) { FXSlider *arg1 = (FXSlider *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSlider, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onLeftBtnRelease(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXSlider_onMiddleBtnPress(int argc, VALUE *argv, VALUE self) { FXSlider *arg1 = (FXSlider *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSlider, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onMiddleBtnPress(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXSlider_onMiddleBtnRelease(int argc, VALUE *argv, VALUE self) { FXSlider *arg1 = (FXSlider *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSlider, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onMiddleBtnRelease(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXSlider_onMouseWheel(int argc, VALUE *argv, VALUE self) { FXSlider *arg1 = (FXSlider *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSlider, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onMouseWheel(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXSlider_onUngrabbed(int argc, VALUE *argv, VALUE self) { FXSlider *arg1 = (FXSlider *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSlider, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onUngrabbed(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXSlider_onMotion(int argc, VALUE *argv, VALUE self) { FXSlider *arg1 = (FXSlider *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSlider, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onMotion(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXSlider_onAutoSlide(int argc, VALUE *argv, VALUE self) { FXSlider *arg1 = (FXSlider *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSlider, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]);
    arg4 = reinterpret_cast<void*>(NUM2INT(argv[2])); result = (long)(arg1)->onAutoSlide(arg2,arg3,arg4);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXSlider_onCmdSetValue(int argc, VALUE *argv, VALUE self) { FXSlider *arg1 = (FXSlider *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSlider, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]);
    arg4 = reinterpret_cast<void*>(NUM2INT(argv[2])); result = (long)(arg1)->onCmdSetValue(arg2,arg3,arg4);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXSlider_onCmdSetIntValue(int argc, VALUE *argv, VALUE self) { FXSlider *arg1 = (FXSlider *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; FXint value4 ;
    VALUE vresult = Qnil; if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSlider, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); {
        value4 = (FXint) NUM2INT(argv[2]); arg4 = static_cast<void*>(&value4); } 
    result = (long)(arg1)->onCmdSetIntValue(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXSlider_onCmdGetIntValue(int argc, VALUE *argv, VALUE self) { FXSlider *arg1 = (FXSlider *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSlider, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdGetIntValue(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXSlider_onCmdSetRealValue(int argc, VALUE *argv, VALUE self) { FXSlider *arg1 = (FXSlider *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; FXdouble value4 ;
    VALUE vresult = Qnil; if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSlider, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); {
        value4 = (FXdouble) NUM2DBL(argv[2]); arg4 = (void *) &value4; } 
    result = (long)(arg1)->onCmdSetRealValue(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXSlider_onCmdGetRealValue(int argc, VALUE *argv, VALUE self) { FXSlider *arg1 = (FXSlider *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSlider, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdGetRealValue(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXSlider_onCmdSetIntRange(int argc, VALUE *argv, VALUE self) { FXSlider *arg1 = (FXSlider *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; FXint values4[2] ;
    VALUE vresult = Qnil; if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSlider, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); { Check_Type(argv[2], T_ARRAY);
        values4[0] = (FXint) NUM2INT(rb_ary_entry(argv[2], 0)); values4[1] = (FXint) NUM2INT(rb_ary_entry(argv[2], 1));
        arg4 = static_cast<void*>(values4); }  result = (long)(arg1)->onCmdSetIntRange(arg2,arg3,arg4);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXSlider_onCmdGetIntRange(int argc, VALUE *argv, VALUE self) { FXSlider *arg1 = (FXSlider *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSlider, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]);
    SWIG_ConvertPtr(argv[2], (void **) &arg4, 0, 1); result = (long)(arg1)->onCmdGetIntRange(arg2,arg3,arg4);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXSlider_onCmdSetRealRange(int argc, VALUE *argv, VALUE self) { FXSlider *arg1 = (FXSlider *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; FXdouble values4[2] ;
    VALUE vresult = Qnil; if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSlider, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); { Check_Type(argv[2], T_ARRAY);
        values4[0] = (FXdouble) NUM2DBL(rb_ary_entry(argv[2], 0)); values4[1] = (FXdouble) NUM2DBL(rb_ary_entry(argv[2], 1));
        arg4 = (void *) values4; }  result = (long)(arg1)->onCmdSetRealRange(arg2,arg3,arg4); vresult = INT2NUM(result);
    return vresult; }
static VALUE _wrap_FXSlider_onCmdGetRealRange(int argc, VALUE *argv, VALUE self) { FXSlider *arg1 = (FXSlider *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSlider, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]);
    SWIG_ConvertPtr(argv[2], (void **) &arg4, 0, 1); result = (long)(arg1)->onCmdGetRealRange(arg2,arg3,arg4);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXSlider_onCmdSetHelp(int argc, VALUE *argv, VALUE self) { FXSlider *arg1 = (FXSlider *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; FXString value4 ;
    VALUE vresult = Qnil; if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSlider, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); {
        value4 = FXString(STR2CSTR(argv[2])); arg4 = (void *) &value4; }  result = (long)(arg1)->onCmdSetHelp(arg2,arg3,arg4);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXSlider_onCmdGetHelp(int argc, VALUE *argv, VALUE self) { FXSlider *arg1 = (FXSlider *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSlider, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdGetHelp(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXSlider_onCmdSetTip(int argc, VALUE *argv, VALUE self) { FXSlider *arg1 = (FXSlider *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; FXString value4 ;
    VALUE vresult = Qnil; if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSlider, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); {
        value4 = FXString(STR2CSTR(argv[2])); arg4 = (void *) &value4; }  result = (long)(arg1)->onCmdSetTip(arg2,arg3,arg4);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXSlider_onCmdGetTip(int argc, VALUE *argv, VALUE self) { FXSlider *arg1 = (FXSlider *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSlider, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdGetTip(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXSlider_onQueryHelp(int argc, VALUE *argv, VALUE self) { FXSlider *arg1 = (FXSlider *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSlider, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onQueryHelp(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXSlider_onQueryTip(int argc, VALUE *argv, VALUE self) { FXSlider *arg1 = (FXSlider *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSlider, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onQueryTip(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE _wrap_FXSlider_allocate(VALUE self) {
#else
     static VALUE _wrap_FXSlider_allocate(int argc, VALUE *argv, VALUE self) {
#endif
         VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_FXSlider);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
         return vresult; }
static VALUE _wrap_new_FXSlider(int argc, VALUE *argv, VALUE self) { FXComposite *arg1 = (FXComposite *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 = (FXSelector) 0 ; FXuint arg4 = (FXuint) SLIDER_NORMAL ;
    FXint arg5 = (FXint) 0 ; FXint arg6 = (FXint) 0 ; FXint arg7 = (FXint) 0 ; FXint arg8 = (FXint) 0 ; FXint arg9 = (FXint) 0 ;
    FXint arg10 = (FXint) 0 ; FXint arg11 = (FXint) 0 ; FXint arg12 = (FXint) 0 ; FXSlider *result;
    if ((argc < 1) || (argc > 12)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXComposite, 1); if (argc > 1) {
        SWIG_ConvertPtr(argv[1], (void **) &arg2, SWIGTYPE_p_FXObject, 1); }  if (argc > 2) { arg3 = NUM2UINT(argv[2]); } 
    if (argc > 3) { arg4 = NUM2UINT(argv[3]); }  if (argc > 4) { arg5 = NUM2INT(argv[4]); }  if (argc > 5) {
        arg6 = NUM2INT(argv[5]); }  if (argc > 6) { arg7 = NUM2INT(argv[6]); }  if (argc > 7) { arg8 = NUM2INT(argv[7]); } 
    if (argc > 8) { arg9 = NUM2INT(argv[8]); }  if (argc > 9) { arg10 = NUM2INT(argv[9]); }  if (argc > 10) {
        arg11 = NUM2INT(argv[10]); }  if (argc > 11) { arg12 = NUM2INT(argv[11]); }  {
        result = (FXSlider *)new_FXSlider(arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8,arg9,arg10,arg11,arg12);
        DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result); if(rb_block_given_p()){ rb_yield(self); }  }  return self; }
static VALUE _wrap_FXSlider_setValue(int argc, VALUE *argv, VALUE self) { FXSlider *arg1 = (FXSlider *) 0 ; FXint arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSlider, 1); arg2 = NUM2INT(argv[0]); (arg1)->setValue(arg2);
    return Qnil; }
static VALUE _wrap_FXSlider_getValue(int argc, VALUE *argv, VALUE self) { FXSlider *arg1 = (FXSlider *) 0 ; FXint result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSlider, 1); result = (FXint)((FXSlider const *)arg1)->getValue();
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXSlider_setRange(int argc, VALUE *argv, VALUE self) { FXSlider *arg1 = (FXSlider *) 0 ; VALUE arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSlider, 1); arg2 = argv[0]; FXSlider_setRange(arg1,arg2); return Qnil; }
static VALUE _wrap_FXSlider_getRange(int argc, VALUE *argv, VALUE self) { FXSlider *arg1 = (FXSlider *) 0 ; VALUE result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSlider, 1); result = (VALUE)FXSlider_getRange((FXSlider const *)arg1);
    vresult = result; return vresult; }
static VALUE _wrap_FXSlider_getSliderStyle(int argc, VALUE *argv, VALUE self) { FXSlider *arg1 = (FXSlider *) 0 ; FXuint result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSlider, 1); result = (FXuint)((FXSlider const *)arg1)->getSliderStyle();
    vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXSlider_setSliderStyle(int argc, VALUE *argv, VALUE self) { FXSlider *arg1 = (FXSlider *) 0 ; FXuint arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSlider, 1); arg2 = NUM2UINT(argv[0]); (arg1)->setSliderStyle(arg2);
    return Qnil; }
static VALUE _wrap_FXSlider_getHeadSize(int argc, VALUE *argv, VALUE self) { FXSlider *arg1 = (FXSlider *) 0 ; FXint result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSlider, 1); result = (FXint)((FXSlider const *)arg1)->getHeadSize();
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXSlider_setHeadSize(int argc, VALUE *argv, VALUE self) { FXSlider *arg1 = (FXSlider *) 0 ; FXint arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSlider, 1); arg2 = NUM2INT(argv[0]); (arg1)->setHeadSize(arg2);
    return Qnil; }
static VALUE _wrap_FXSlider_getSlotSize(int argc, VALUE *argv, VALUE self) { FXSlider *arg1 = (FXSlider *) 0 ; FXint result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSlider, 1); result = (FXint)((FXSlider const *)arg1)->getSlotSize();
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXSlider_setSlotSize(int argc, VALUE *argv, VALUE self) { FXSlider *arg1 = (FXSlider *) 0 ; FXint arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSlider, 1); arg2 = NUM2INT(argv[0]); (arg1)->setSlotSize(arg2);
    return Qnil; }
static VALUE _wrap_FXSlider_getIncrement(int argc, VALUE *argv, VALUE self) { FXSlider *arg1 = (FXSlider *) 0 ; FXint result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSlider, 1); result = (FXint)((FXSlider const *)arg1)->getIncrement();
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXSlider_setIncrement(int argc, VALUE *argv, VALUE self) { FXSlider *arg1 = (FXSlider *) 0 ; FXint arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSlider, 1); arg2 = NUM2INT(argv[0]); (arg1)->setIncrement(arg2);
    return Qnil; }
static VALUE _wrap_FXSlider_setTickDelta(int argc, VALUE *argv, VALUE self) { FXSlider *arg1 = (FXSlider *) 0 ; FXint arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSlider, 1); arg2 = NUM2INT(argv[0]); (arg1)->setTickDelta(arg2);
    return Qnil; }
static VALUE _wrap_FXSlider_getTickDelta(int argc, VALUE *argv, VALUE self) { FXSlider *arg1 = (FXSlider *) 0 ; FXint result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSlider, 1); result = (FXint)((FXSlider const *)arg1)->getTickDelta();
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXSlider_setSlotColor(int argc, VALUE *argv, VALUE self) { FXSlider *arg1 = (FXSlider *) 0 ; FXColor arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSlider, 1); arg2 = to_FXColor(argv[0]); (arg1)->setSlotColor(arg2);
    return Qnil; }
static VALUE _wrap_FXSlider_getSlotColor(int argc, VALUE *argv, VALUE self) { FXSlider *arg1 = (FXSlider *) 0 ; FXColor result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSlider, 1); result = (FXColor)((FXSlider const *)arg1)->getSlotColor();
    vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXSlider_setHelpText(int argc, VALUE *argv, VALUE self) { FXSlider *arg1 = (FXSlider *) 0 ;
    FXString *arg2 = 0 ; SwigValueWrapper<FXString > p2 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSlider, 1); p2 = to_FXString(argv[0]); arg2 = &p2;
    (arg1)->setHelpText((FXString const &)*arg2); return Qnil; }
static VALUE _wrap_FXSlider_getHelpText(int argc, VALUE *argv, VALUE self) { FXSlider *arg1 = (FXSlider *) 0 ; FXString result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSlider, 1); result = ((FXSlider const *)arg1)->getHelpText();
    vresult = rb_str_new2((&result)->text()); return vresult; }
static VALUE _wrap_FXSlider_setTipText(int argc, VALUE *argv, VALUE self) { FXSlider *arg1 = (FXSlider *) 0 ;
    FXString *arg2 = 0 ; SwigValueWrapper<FXString > p2 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSlider, 1); p2 = to_FXString(argv[0]); arg2 = &p2;
    (arg1)->setTipText((FXString const &)*arg2); return Qnil; }
static VALUE _wrap_FXSlider_getTipText(int argc, VALUE *argv, VALUE self) { FXSlider *arg1 = (FXSlider *) 0 ; FXString result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSlider, 1); result = ((FXSlider const *)arg1)->getTipText();
    vresult = rb_str_new2((&result)->text()); return vresult; }
static void
free_FXSlider(FXSlider *arg1) {
    delete arg1;
}
static VALUE _wrap_FXSlider_save(int argc, VALUE *argv, VALUE self) { FXSlider *arg1 = (FXSlider *) 0 ; FXStream *arg2 = 0 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSlider, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXSlider_save((FXSlider const *)arg1,*arg2); return Qnil; }
static VALUE _wrap_FXSlider_load(int argc, VALUE *argv, VALUE self) { FXSlider *arg1 = (FXSlider *) 0 ; FXStream *arg2 = 0 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSlider, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXSlider_load(arg1,*arg2); return Qnil; }
static VALUE _wrap_FXSlider_create(int argc, VALUE *argv, VALUE self) { FXSlider *arg1 = (FXSlider *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSlider, 1); FXSlider_create(arg1); return Qnil; }
static VALUE _wrap_FXSlider_detach(int argc, VALUE *argv, VALUE self) { FXSlider *arg1 = (FXSlider *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSlider, 1); FXSlider_detach(arg1); return Qnil; }
static VALUE _wrap_FXSlider_destroy(int argc, VALUE *argv, VALUE self) { FXSlider *arg1 = (FXSlider *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSlider, 1); FXSlider_destroy(arg1); return Qnil; }
static VALUE _wrap_FXSlider_resize(int argc, VALUE *argv, VALUE self) { FXSlider *arg1 = (FXSlider *) 0 ; FXint arg2 ;
    FXint arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSlider, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    FXSlider_resize(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXSlider_getDefaultWidth(int argc, VALUE *argv, VALUE self) { FXSlider *arg1 = (FXSlider *) 0 ; FXint result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSlider, 1); result = (FXint)FXSlider_getDefaultWidth(arg1);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXSlider_getDefaultHeight(int argc, VALUE *argv, VALUE self) { FXSlider *arg1 = (FXSlider *) 0 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSlider, 1); result = (FXint)FXSlider_getDefaultHeight(arg1);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXSlider_getWidthForHeight(int argc, VALUE *argv, VALUE self) { FXSlider *arg1 = (FXSlider *) 0 ;
    FXint arg2 ; FXint result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSlider, 1); arg2 = NUM2INT(argv[0]);
    result = (FXint)FXSlider_getWidthForHeight(arg1,arg2); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXSlider_getHeightForWidth(int argc, VALUE *argv, VALUE self) { FXSlider *arg1 = (FXSlider *) 0 ;
    FXint arg2 ; FXint result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSlider, 1); arg2 = NUM2INT(argv[0]);
    result = (FXint)FXSlider_getHeightForWidth(arg1,arg2); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXSlider_canFocus(int argc, VALUE *argv, VALUE self) { FXSlider *arg1 = (FXSlider *) 0 ; FXbool result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSlider, 1); result = (FXbool)FXSlider_canFocus((FXSlider const *)arg1);
    vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXSlider_setFocus(int argc, VALUE *argv, VALUE self) { FXSlider *arg1 = (FXSlider *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSlider, 1); FXSlider_setFocus(arg1); return Qnil; }
static VALUE _wrap_FXSlider_killFocus(int argc, VALUE *argv, VALUE self) { FXSlider *arg1 = (FXSlider *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSlider, 1); FXSlider_killFocus(arg1); return Qnil; }
static VALUE _wrap_FXSlider_setDefault(int argc, VALUE *argv, VALUE self) { FXSlider *arg1 = (FXSlider *) 0 ;
    FXbool arg2 = (FXbool) 1 ; if ((argc < 0) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSlider, 1); if (argc > 0) { arg2 = to_FXbool(argv[0]); } 
    FXSlider_setDefault(arg1,arg2); return Qnil; }
static VALUE _wrap_FXSlider_enable(int argc, VALUE *argv, VALUE self) { FXSlider *arg1 = (FXSlider *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSlider, 1); FXSlider_enable(arg1); return Qnil; }
static VALUE _wrap_FXSlider_disable(int argc, VALUE *argv, VALUE self) { FXSlider *arg1 = (FXSlider *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSlider, 1); FXSlider_disable(arg1); return Qnil; }
static VALUE _wrap_FXSlider_raiseWindow(int argc, VALUE *argv, VALUE self) { FXSlider *arg1 = (FXSlider *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSlider, 1); FXSlider_raise(arg1); return Qnil; }
static VALUE _wrap_FXSlider_lower(int argc, VALUE *argv, VALUE self) { FXSlider *arg1 = (FXSlider *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSlider, 1); FXSlider_lower(arg1); return Qnil; }
static VALUE _wrap_FXSlider_move(int argc, VALUE *argv, VALUE self) { FXSlider *arg1 = (FXSlider *) 0 ; FXint arg2 ;
    FXint arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSlider, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    FXSlider_move(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXSlider_position(int argc, VALUE *argv, VALUE self) { FXSlider *arg1 = (FXSlider *) 0 ; FXint arg2 ;
    FXint arg3 ; FXint arg4 ; FXint arg5 ; if ((argc < 4) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSlider, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    arg4 = NUM2INT(argv[2]); arg5 = NUM2INT(argv[3]); FXSlider_position(arg1,arg2,arg3,arg4,arg5); return Qnil; }
static VALUE _wrap_FXSlider_layout(int argc, VALUE *argv, VALUE self) { FXSlider *arg1 = (FXSlider *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSlider, 1); FXSlider_layout(arg1); return Qnil; }
static VALUE _wrap_FXSlider_recalc(int argc, VALUE *argv, VALUE self) { FXSlider *arg1 = (FXSlider *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSlider, 1); FXSlider_recalc(arg1); return Qnil; }
static VALUE _wrap_FXSlider_reparent(int argc, VALUE *argv, VALUE self) { FXSlider *arg1 = (FXSlider *) 0 ;
    FXComposite *arg2 = (FXComposite *) 0 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSlider, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXComposite, 1); FXSlider_reparent(arg1,arg2); return Qnil; }
static VALUE _wrap_FXSlider_show(int argc, VALUE *argv, VALUE self) { FXSlider *arg1 = (FXSlider *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSlider, 1); FXSlider_show(arg1); return Qnil; }
static VALUE _wrap_FXSlider_hide(int argc, VALUE *argv, VALUE self) { FXSlider *arg1 = (FXSlider *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSlider, 1); FXSlider_hide(arg1); return Qnil; }
static VALUE _wrap_FXSlider_isComposite(int argc, VALUE *argv, VALUE self) { FXSlider *arg1 = (FXSlider *) 0 ; FXbool result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSlider, 1);
    result = (FXbool)FXSlider_isComposite((FXSlider const *)arg1); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXSlider_contains(int argc, VALUE *argv, VALUE self) { FXSlider *arg1 = (FXSlider *) 0 ; FXint arg2 ;
    FXint arg3 ; FXbool result; VALUE vresult = Qnil; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSlider, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    result = (FXbool)FXSlider_contains((FXSlider const *)arg1,arg2,arg3); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXSlider_doesSaveUnder(int argc, VALUE *argv, VALUE self) { FXSlider *arg1 = (FXSlider *) 0 ; FXbool result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSlider, 1);
    result = (FXbool)FXSlider_doesSaveUnder((FXSlider const *)arg1); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXSlider_setBackColor(int argc, VALUE *argv, VALUE self) { FXSlider *arg1 = (FXSlider *) 0 ; FXColor arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSlider, 1); arg2 = to_FXColor(argv[0]);
    FXSlider_setBackColor(arg1,arg2); return Qnil; }
static VALUE _wrap_FXRealSlider_onPaint(int argc, VALUE *argv, VALUE self) { FXRealSlider *arg1 = (FXRealSlider *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRealSlider, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onPaint(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXRealSlider_onLeftBtnPress(int argc, VALUE *argv, VALUE self) { FXRealSlider *arg1 = (FXRealSlider *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRealSlider, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onLeftBtnPress(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXRealSlider_onLeftBtnRelease(int argc, VALUE *argv, VALUE self) { FXRealSlider *arg1 = (FXRealSlider *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRealSlider, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onLeftBtnRelease(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXRealSlider_onMiddleBtnPress(int argc, VALUE *argv, VALUE self) { FXRealSlider *arg1 = (FXRealSlider *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRealSlider, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onMiddleBtnPress(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXRealSlider_onMiddleBtnRelease(int argc, VALUE *argv, VALUE self) {
    FXRealSlider *arg1 = (FXRealSlider *) 0 ; FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ;
    long result; VALUE vresult = Qnil; if ((argc < 3) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRealSlider, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onMiddleBtnRelease(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXRealSlider_onMouseWheel(int argc, VALUE *argv, VALUE self) { FXRealSlider *arg1 = (FXRealSlider *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRealSlider, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onMouseWheel(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXRealSlider_onUngrabbed(int argc, VALUE *argv, VALUE self) { FXRealSlider *arg1 = (FXRealSlider *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRealSlider, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onUngrabbed(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXRealSlider_onMotion(int argc, VALUE *argv, VALUE self) { FXRealSlider *arg1 = (FXRealSlider *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRealSlider, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onMotion(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXRealSlider_onAutoSlide(int argc, VALUE *argv, VALUE self) { FXRealSlider *arg1 = (FXRealSlider *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRealSlider, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]);
    arg4 = reinterpret_cast<void*>(NUM2INT(argv[2])); result = (long)(arg1)->onAutoSlide(arg2,arg3,arg4);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXRealSlider_onCmdSetValue(int argc, VALUE *argv, VALUE self) { FXRealSlider *arg1 = (FXRealSlider *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRealSlider, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]);
    arg4 = reinterpret_cast<void*>(NUM2INT(argv[2])); result = (long)(arg1)->onCmdSetValue(arg2,arg3,arg4);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXRealSlider_onCmdSetIntValue(int argc, VALUE *argv, VALUE self) { FXRealSlider *arg1 = (FXRealSlider *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; FXint value4 ;
    VALUE vresult = Qnil; if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRealSlider, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); {
        value4 = (FXint) NUM2INT(argv[2]); arg4 = static_cast<void*>(&value4); } 
    result = (long)(arg1)->onCmdSetIntValue(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXRealSlider_onCmdGetIntValue(int argc, VALUE *argv, VALUE self) { FXRealSlider *arg1 = (FXRealSlider *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRealSlider, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdGetIntValue(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXRealSlider_onCmdSetRealValue(int argc, VALUE *argv, VALUE self) { FXRealSlider *arg1 = (FXRealSlider *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; FXdouble value4 ;
    VALUE vresult = Qnil; if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRealSlider, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); {
        value4 = (FXdouble) NUM2DBL(argv[2]); arg4 = (void *) &value4; } 
    result = (long)(arg1)->onCmdSetRealValue(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXRealSlider_onCmdGetRealValue(int argc, VALUE *argv, VALUE self) { FXRealSlider *arg1 = (FXRealSlider *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRealSlider, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdGetRealValue(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXRealSlider_onCmdSetIntRange(int argc, VALUE *argv, VALUE self) { FXRealSlider *arg1 = (FXRealSlider *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; FXint values4[2] ;
    VALUE vresult = Qnil; if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRealSlider, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); { Check_Type(argv[2], T_ARRAY);
        values4[0] = (FXint) NUM2INT(rb_ary_entry(argv[2], 0)); values4[1] = (FXint) NUM2INT(rb_ary_entry(argv[2], 1));
        arg4 = static_cast<void*>(values4); }  result = (long)(arg1)->onCmdSetIntRange(arg2,arg3,arg4);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXRealSlider_onCmdGetIntRange(int argc, VALUE *argv, VALUE self) { FXRealSlider *arg1 = (FXRealSlider *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRealSlider, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]);
    SWIG_ConvertPtr(argv[2], (void **) &arg4, 0, 1); result = (long)(arg1)->onCmdGetIntRange(arg2,arg3,arg4);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXRealSlider_onCmdSetRealRange(int argc, VALUE *argv, VALUE self) { FXRealSlider *arg1 = (FXRealSlider *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; FXdouble values4[2] ;
    VALUE vresult = Qnil; if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRealSlider, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); { Check_Type(argv[2], T_ARRAY);
        values4[0] = (FXdouble) NUM2DBL(rb_ary_entry(argv[2], 0)); values4[1] = (FXdouble) NUM2DBL(rb_ary_entry(argv[2], 1));
        arg4 = (void *) values4; }  result = (long)(arg1)->onCmdSetRealRange(arg2,arg3,arg4); vresult = INT2NUM(result);
    return vresult; }
static VALUE _wrap_FXRealSlider_onCmdGetRealRange(int argc, VALUE *argv, VALUE self) { FXRealSlider *arg1 = (FXRealSlider *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRealSlider, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]);
    SWIG_ConvertPtr(argv[2], (void **) &arg4, 0, 1); result = (long)(arg1)->onCmdGetRealRange(arg2,arg3,arg4);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXRealSlider_onCmdSetHelp(int argc, VALUE *argv, VALUE self) { FXRealSlider *arg1 = (FXRealSlider *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; FXString value4 ;
    VALUE vresult = Qnil; if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRealSlider, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); {
        value4 = FXString(STR2CSTR(argv[2])); arg4 = (void *) &value4; }  result = (long)(arg1)->onCmdSetHelp(arg2,arg3,arg4);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXRealSlider_onCmdGetHelp(int argc, VALUE *argv, VALUE self) { FXRealSlider *arg1 = (FXRealSlider *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRealSlider, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdGetHelp(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXRealSlider_onCmdSetTip(int argc, VALUE *argv, VALUE self) { FXRealSlider *arg1 = (FXRealSlider *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; FXString value4 ;
    VALUE vresult = Qnil; if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRealSlider, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); {
        value4 = FXString(STR2CSTR(argv[2])); arg4 = (void *) &value4; }  result = (long)(arg1)->onCmdSetTip(arg2,arg3,arg4);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXRealSlider_onCmdGetTip(int argc, VALUE *argv, VALUE self) { FXRealSlider *arg1 = (FXRealSlider *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRealSlider, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdGetTip(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXRealSlider_onQueryHelp(int argc, VALUE *argv, VALUE self) { FXRealSlider *arg1 = (FXRealSlider *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRealSlider, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onQueryHelp(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXRealSlider_onQueryTip(int argc, VALUE *argv, VALUE self) { FXRealSlider *arg1 = (FXRealSlider *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRealSlider, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onQueryTip(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE _wrap_FXRealSlider_allocate(VALUE self) {
#else
     static VALUE _wrap_FXRealSlider_allocate(int argc, VALUE *argv, VALUE self) {
#endif
         VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_FXRealSlider);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
         return vresult; }
static VALUE _wrap_new_FXRealSlider(int argc, VALUE *argv, VALUE self) { FXComposite *arg1 = (FXComposite *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 = (FXSelector) 0 ; FXuint arg4 = (FXuint) REALSLIDER_NORMAL ;
    FXint arg5 = (FXint) 0 ; FXint arg6 = (FXint) 0 ; FXint arg7 = (FXint) 0 ; FXint arg8 = (FXint) 0 ; FXint arg9 = (FXint) 0 ;
    FXint arg10 = (FXint) 0 ; FXint arg11 = (FXint) 0 ; FXint arg12 = (FXint) 0 ; FXRealSlider *result;
    if ((argc < 1) || (argc > 12)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXComposite, 1); if (argc > 1) {
        SWIG_ConvertPtr(argv[1], (void **) &arg2, SWIGTYPE_p_FXObject, 1); }  if (argc > 2) { arg3 = NUM2UINT(argv[2]); } 
    if (argc > 3) { arg4 = NUM2UINT(argv[3]); }  if (argc > 4) { arg5 = NUM2INT(argv[4]); }  if (argc > 5) {
        arg6 = NUM2INT(argv[5]); }  if (argc > 6) { arg7 = NUM2INT(argv[6]); }  if (argc > 7) { arg8 = NUM2INT(argv[7]); } 
    if (argc > 8) { arg9 = NUM2INT(argv[8]); }  if (argc > 9) { arg10 = NUM2INT(argv[9]); }  if (argc > 10) {
        arg11 = NUM2INT(argv[10]); }  if (argc > 11) { arg12 = NUM2INT(argv[11]); }  {
        result = (FXRealSlider *)new_FXRealSlider(arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8,arg9,arg10,arg11,arg12);
        DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result); if(rb_block_given_p()){ rb_yield(self); }  }  return self; }
static VALUE _wrap_FXRealSlider_setValue(int argc, VALUE *argv, VALUE self) { FXRealSlider *arg1 = (FXRealSlider *) 0 ;
    FXdouble arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRealSlider, 1); arg2 = (FXdouble) NUM2DBL(argv[0]);
    (arg1)->setValue(arg2); return Qnil; }
static VALUE _wrap_FXRealSlider_getValue(int argc, VALUE *argv, VALUE self) { FXRealSlider *arg1 = (FXRealSlider *) 0 ;
    FXdouble result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRealSlider, 1);
    result = (FXdouble)((FXRealSlider const *)arg1)->getValue(); vresult = rb_float_new(result); return vresult; }
static VALUE _wrap_FXRealSlider_setRange(int argc, VALUE *argv, VALUE self) { FXRealSlider *arg1 = (FXRealSlider *) 0 ;
    FXdouble arg2 ; FXdouble arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRealSlider, 1); arg2 = (FXdouble) NUM2DBL(argv[0]);
    arg3 = (FXdouble) NUM2DBL(argv[1]); (arg1)->setRange(arg2,arg3); return Qnil; }
static VALUE _wrap_FXRealSlider_getRange(int argc, VALUE *argv, VALUE self) { FXRealSlider *arg1 = (FXRealSlider *) 0 ;
    VALUE result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRealSlider, 1);
    result = (VALUE)FXRealSlider_getRange((FXRealSlider const *)arg1); vresult = result; return vresult; }
static VALUE _wrap_FXRealSlider_getSliderStyle(int argc, VALUE *argv, VALUE self) { FXRealSlider *arg1 = (FXRealSlider *) 0 ;
    FXuint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRealSlider, 1);
    result = (FXuint)((FXRealSlider const *)arg1)->getSliderStyle(); vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXRealSlider_setSliderStyle(int argc, VALUE *argv, VALUE self) { FXRealSlider *arg1 = (FXRealSlider *) 0 ;
    FXuint arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRealSlider, 1); arg2 = NUM2UINT(argv[0]); (arg1)->setSliderStyle(arg2);
    return Qnil; }
static VALUE _wrap_FXRealSlider_getHeadSize(int argc, VALUE *argv, VALUE self) { FXRealSlider *arg1 = (FXRealSlider *) 0 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRealSlider, 1);
    result = (FXint)((FXRealSlider const *)arg1)->getHeadSize(); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXRealSlider_setHeadSize(int argc, VALUE *argv, VALUE self) { FXRealSlider *arg1 = (FXRealSlider *) 0 ;
    FXint arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRealSlider, 1); arg2 = NUM2INT(argv[0]); (arg1)->setHeadSize(arg2);
    return Qnil; }
static VALUE _wrap_FXRealSlider_getSlotSize(int argc, VALUE *argv, VALUE self) { FXRealSlider *arg1 = (FXRealSlider *) 0 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRealSlider, 1);
    result = (FXint)((FXRealSlider const *)arg1)->getSlotSize(); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXRealSlider_setSlotSize(int argc, VALUE *argv, VALUE self) { FXRealSlider *arg1 = (FXRealSlider *) 0 ;
    FXint arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRealSlider, 1); arg2 = NUM2INT(argv[0]); (arg1)->setSlotSize(arg2);
    return Qnil; }
static VALUE _wrap_FXRealSlider_getIncrement(int argc, VALUE *argv, VALUE self) { FXRealSlider *arg1 = (FXRealSlider *) 0 ;
    FXdouble result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRealSlider, 1);
    result = (FXdouble)((FXRealSlider const *)arg1)->getIncrement(); vresult = rb_float_new(result); return vresult; }
static VALUE _wrap_FXRealSlider_setIncrement(int argc, VALUE *argv, VALUE self) { FXRealSlider *arg1 = (FXRealSlider *) 0 ;
    FXdouble arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRealSlider, 1); arg2 = (FXdouble) NUM2DBL(argv[0]);
    (arg1)->setIncrement(arg2); return Qnil; }
static VALUE _wrap_FXRealSlider_setTickDelta(int argc, VALUE *argv, VALUE self) { FXRealSlider *arg1 = (FXRealSlider *) 0 ;
    FXdouble arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRealSlider, 1); arg2 = (FXdouble) NUM2DBL(argv[0]);
    (arg1)->setTickDelta(arg2); return Qnil; }
static VALUE _wrap_FXRealSlider_getTickDelta(int argc, VALUE *argv, VALUE self) { FXRealSlider *arg1 = (FXRealSlider *) 0 ;
    FXdouble result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRealSlider, 1);
    result = (FXdouble)((FXRealSlider const *)arg1)->getTickDelta(); vresult = rb_float_new(result); return vresult; }
static VALUE _wrap_FXRealSlider_setSlotColor(int argc, VALUE *argv, VALUE self) { FXRealSlider *arg1 = (FXRealSlider *) 0 ;
    FXColor arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRealSlider, 1); arg2 = to_FXColor(argv[0]); (arg1)->setSlotColor(arg2);
    return Qnil; }
static VALUE _wrap_FXRealSlider_getSlotColor(int argc, VALUE *argv, VALUE self) { FXRealSlider *arg1 = (FXRealSlider *) 0 ;
    FXColor result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRealSlider, 1);
    result = (FXColor)((FXRealSlider const *)arg1)->getSlotColor(); vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXRealSlider_setHelpText(int argc, VALUE *argv, VALUE self) { FXRealSlider *arg1 = (FXRealSlider *) 0 ;
    FXString *arg2 = 0 ; SwigValueWrapper<FXString > p2 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRealSlider, 1); p2 = to_FXString(argv[0]); arg2 = &p2;
    (arg1)->setHelpText((FXString const &)*arg2); return Qnil; }
static VALUE _wrap_FXRealSlider_getHelpText(int argc, VALUE *argv, VALUE self) { FXRealSlider *arg1 = (FXRealSlider *) 0 ;
    FXString result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRealSlider, 1); result = ((FXRealSlider const *)arg1)->getHelpText();
    vresult = rb_str_new2((&result)->text()); return vresult; }
static VALUE _wrap_FXRealSlider_setTipText(int argc, VALUE *argv, VALUE self) { FXRealSlider *arg1 = (FXRealSlider *) 0 ;
    FXString *arg2 = 0 ; SwigValueWrapper<FXString > p2 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRealSlider, 1); p2 = to_FXString(argv[0]); arg2 = &p2;
    (arg1)->setTipText((FXString const &)*arg2); return Qnil; }
static VALUE _wrap_FXRealSlider_getTipText(int argc, VALUE *argv, VALUE self) { FXRealSlider *arg1 = (FXRealSlider *) 0 ;
    FXString result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRealSlider, 1); result = ((FXRealSlider const *)arg1)->getTipText();
    vresult = rb_str_new2((&result)->text()); return vresult; }
static void
free_FXRealSlider(FXRealSlider *arg1) {
    delete arg1;
}
static VALUE _wrap_FXRealSlider_save(int argc, VALUE *argv, VALUE self) { FXRealSlider *arg1 = (FXRealSlider *) 0 ;
    FXStream *arg2 = 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRealSlider, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXRealSlider_save((FXRealSlider const *)arg1,*arg2); return Qnil; }
static VALUE _wrap_FXRealSlider_load(int argc, VALUE *argv, VALUE self) { FXRealSlider *arg1 = (FXRealSlider *) 0 ;
    FXStream *arg2 = 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRealSlider, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXRealSlider_load(arg1,*arg2); return Qnil; }
static VALUE _wrap_FXRealSlider_create(int argc, VALUE *argv, VALUE self) { FXRealSlider *arg1 = (FXRealSlider *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRealSlider, 1); FXRealSlider_create(arg1); return Qnil; }
static VALUE _wrap_FXRealSlider_detach(int argc, VALUE *argv, VALUE self) { FXRealSlider *arg1 = (FXRealSlider *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRealSlider, 1); FXRealSlider_detach(arg1); return Qnil; }
static VALUE _wrap_FXRealSlider_destroy(int argc, VALUE *argv, VALUE self) { FXRealSlider *arg1 = (FXRealSlider *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRealSlider, 1); FXRealSlider_destroy(arg1); return Qnil; }
static VALUE _wrap_FXRealSlider_resize(int argc, VALUE *argv, VALUE self) { FXRealSlider *arg1 = (FXRealSlider *) 0 ;
    FXint arg2 ; FXint arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRealSlider, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    FXRealSlider_resize(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXRealSlider_getDefaultWidth(int argc, VALUE *argv, VALUE self) { FXRealSlider *arg1 = (FXRealSlider *) 0 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRealSlider, 1); result = (FXint)FXRealSlider_getDefaultWidth(arg1);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXRealSlider_getDefaultHeight(int argc, VALUE *argv, VALUE self) { FXRealSlider *arg1 = (FXRealSlider *) 0 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRealSlider, 1); result = (FXint)FXRealSlider_getDefaultHeight(arg1);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXRealSlider_getWidthForHeight(int argc, VALUE *argv, VALUE self) { FXRealSlider *arg1 = (FXRealSlider *) 0 ;
    FXint arg2 ; FXint result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRealSlider, 1); arg2 = NUM2INT(argv[0]);
    result = (FXint)FXRealSlider_getWidthForHeight(arg1,arg2); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXRealSlider_getHeightForWidth(int argc, VALUE *argv, VALUE self) { FXRealSlider *arg1 = (FXRealSlider *) 0 ;
    FXint arg2 ; FXint result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRealSlider, 1); arg2 = NUM2INT(argv[0]);
    result = (FXint)FXRealSlider_getHeightForWidth(arg1,arg2); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXRealSlider_canFocus(int argc, VALUE *argv, VALUE self) { FXRealSlider *arg1 = (FXRealSlider *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRealSlider, 1);
    result = (FXbool)FXRealSlider_canFocus((FXRealSlider const *)arg1); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXRealSlider_setFocus(int argc, VALUE *argv, VALUE self) { FXRealSlider *arg1 = (FXRealSlider *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRealSlider, 1); FXRealSlider_setFocus(arg1); return Qnil; }
static VALUE _wrap_FXRealSlider_killFocus(int argc, VALUE *argv, VALUE self) { FXRealSlider *arg1 = (FXRealSlider *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRealSlider, 1); FXRealSlider_killFocus(arg1); return Qnil; }
static VALUE _wrap_FXRealSlider_setDefault(int argc, VALUE *argv, VALUE self) { FXRealSlider *arg1 = (FXRealSlider *) 0 ;
    FXbool arg2 = (FXbool) 1 ; if ((argc < 0) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRealSlider, 1); if (argc > 0) { arg2 = to_FXbool(argv[0]); } 
    FXRealSlider_setDefault(arg1,arg2); return Qnil; }
static VALUE _wrap_FXRealSlider_enable(int argc, VALUE *argv, VALUE self) { FXRealSlider *arg1 = (FXRealSlider *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRealSlider, 1); FXRealSlider_enable(arg1); return Qnil; }
static VALUE _wrap_FXRealSlider_disable(int argc, VALUE *argv, VALUE self) { FXRealSlider *arg1 = (FXRealSlider *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRealSlider, 1); FXRealSlider_disable(arg1); return Qnil; }
static VALUE _wrap_FXRealSlider_raiseWindow(int argc, VALUE *argv, VALUE self) { FXRealSlider *arg1 = (FXRealSlider *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRealSlider, 1); FXRealSlider_raise(arg1); return Qnil; }
static VALUE _wrap_FXRealSlider_lower(int argc, VALUE *argv, VALUE self) { FXRealSlider *arg1 = (FXRealSlider *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRealSlider, 1); FXRealSlider_lower(arg1); return Qnil; }
static VALUE _wrap_FXRealSlider_move(int argc, VALUE *argv, VALUE self) { FXRealSlider *arg1 = (FXRealSlider *) 0 ; FXint arg2 ;
    FXint arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRealSlider, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    FXRealSlider_move(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXRealSlider_position(int argc, VALUE *argv, VALUE self) { FXRealSlider *arg1 = (FXRealSlider *) 0 ;
    FXint arg2 ; FXint arg3 ; FXint arg4 ; FXint arg5 ; if ((argc < 4) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRealSlider, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    arg4 = NUM2INT(argv[2]); arg5 = NUM2INT(argv[3]); FXRealSlider_position(arg1,arg2,arg3,arg4,arg5); return Qnil; }
static VALUE _wrap_FXRealSlider_layout(int argc, VALUE *argv, VALUE self) { FXRealSlider *arg1 = (FXRealSlider *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRealSlider, 1); FXRealSlider_layout(arg1); return Qnil; }
static VALUE _wrap_FXRealSlider_recalc(int argc, VALUE *argv, VALUE self) { FXRealSlider *arg1 = (FXRealSlider *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRealSlider, 1); FXRealSlider_recalc(arg1); return Qnil; }
static VALUE _wrap_FXRealSlider_reparent(int argc, VALUE *argv, VALUE self) { FXRealSlider *arg1 = (FXRealSlider *) 0 ;
    FXComposite *arg2 = (FXComposite *) 0 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRealSlider, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXComposite, 1); FXRealSlider_reparent(arg1,arg2); return Qnil; }
static VALUE _wrap_FXRealSlider_show(int argc, VALUE *argv, VALUE self) { FXRealSlider *arg1 = (FXRealSlider *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRealSlider, 1); FXRealSlider_show(arg1); return Qnil; }
static VALUE _wrap_FXRealSlider_hide(int argc, VALUE *argv, VALUE self) { FXRealSlider *arg1 = (FXRealSlider *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRealSlider, 1); FXRealSlider_hide(arg1); return Qnil; }
static VALUE _wrap_FXRealSlider_isComposite(int argc, VALUE *argv, VALUE self) { FXRealSlider *arg1 = (FXRealSlider *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRealSlider, 1);
    result = (FXbool)FXRealSlider_isComposite((FXRealSlider const *)arg1); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXRealSlider_contains(int argc, VALUE *argv, VALUE self) { FXRealSlider *arg1 = (FXRealSlider *) 0 ;
    FXint arg2 ; FXint arg3 ; FXbool result; VALUE vresult = Qnil; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRealSlider, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    result = (FXbool)FXRealSlider_contains((FXRealSlider const *)arg1,arg2,arg3); vresult = result ? Qtrue : Qfalse;
    return vresult; }
static VALUE _wrap_FXRealSlider_doesSaveUnder(int argc, VALUE *argv, VALUE self) { FXRealSlider *arg1 = (FXRealSlider *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRealSlider, 1);
    result = (FXbool)FXRealSlider_doesSaveUnder((FXRealSlider const *)arg1); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXRealSlider_setBackColor(int argc, VALUE *argv, VALUE self) { FXRealSlider *arg1 = (FXRealSlider *) 0 ;
    FXColor arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRealSlider, 1); arg2 = to_FXColor(argv[0]);
    FXRealSlider_setBackColor(arg1,arg2); return Qnil; }
static VALUE _wrap_FXStatusLine_onPaint(int argc, VALUE *argv, VALUE self) { FXStatusLine *arg1 = (FXStatusLine *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXStatusLine, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onPaint(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXStatusLine_onUpdate(int argc, VALUE *argv, VALUE self) { FXStatusLine *arg1 = (FXStatusLine *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXStatusLine, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onUpdate(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXStatusLine_onCmdGetStringValue(int argc, VALUE *argv, VALUE self) {
    FXStatusLine *arg1 = (FXStatusLine *) 0 ; FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ;
    long result; VALUE vresult = Qnil; if ((argc < 3) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXStatusLine, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdGetStringValue(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXStatusLine_onCmdSetStringValue(int argc, VALUE *argv, VALUE self) {
    FXStatusLine *arg1 = (FXStatusLine *) 0 ; FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ;
    long result; FXString value4 ; VALUE vresult = Qnil; if ((argc < 3) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXStatusLine, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); {
        value4 = FXString(STR2CSTR(argv[2])); arg4 = (void *) &value4; } 
    result = (long)(arg1)->onCmdSetStringValue(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE _wrap_FXStatusLine_allocate(VALUE self) {
#else
     static VALUE _wrap_FXStatusLine_allocate(int argc, VALUE *argv, VALUE self) {
#endif
         VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_FXStatusLine);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
         return vresult; }
static VALUE _wrap_new_FXStatusLine(int argc, VALUE *argv, VALUE self) { FXComposite *arg1 = (FXComposite *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 = (FXSelector) 0 ; FXStatusLine *result; if ((argc < 1) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXComposite, 1); if (argc > 1) {
        SWIG_ConvertPtr(argv[1], (void **) &arg2, SWIGTYPE_p_FXObject, 1); }  if (argc > 2) { arg3 = NUM2UINT(argv[2]); }  {
        result = (FXStatusLine *)new_FXStatusLine(arg1,arg2,arg3); DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result);
        if(rb_block_given_p()){ rb_yield(self); }  }  return self; }
static VALUE _wrap_FXStatusLine_setText(int argc, VALUE *argv, VALUE self) { FXStatusLine *arg1 = (FXStatusLine *) 0 ;
    FXString *arg2 = 0 ; SwigValueWrapper<FXString > p2 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXStatusLine, 1); p2 = to_FXString(argv[0]); arg2 = &p2;
    (arg1)->setText((FXString const &)*arg2); return Qnil; }
static VALUE _wrap_FXStatusLine_getText(int argc, VALUE *argv, VALUE self) { FXStatusLine *arg1 = (FXStatusLine *) 0 ;
    FXString result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXStatusLine, 1); result = ((FXStatusLine const *)arg1)->getText();
    vresult = rb_str_new2((&result)->text()); return vresult; }
static VALUE _wrap_FXStatusLine_setNormalText(int argc, VALUE *argv, VALUE self) { FXStatusLine *arg1 = (FXStatusLine *) 0 ;
    FXString *arg2 = 0 ; SwigValueWrapper<FXString > p2 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXStatusLine, 1); p2 = to_FXString(argv[0]); arg2 = &p2;
    (arg1)->setNormalText((FXString const &)*arg2); return Qnil; }
static VALUE _wrap_FXStatusLine_getNormalText(int argc, VALUE *argv, VALUE self) { FXStatusLine *arg1 = (FXStatusLine *) 0 ;
    FXString result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXStatusLine, 1); result = ((FXStatusLine const *)arg1)->getNormalText();
    vresult = rb_str_new2((&result)->text()); return vresult; }
static VALUE _wrap_FXStatusLine_setFont(int argc, VALUE *argv, VALUE self) { FXStatusLine *arg1 = (FXStatusLine *) 0 ;
    FXFont *arg2 = (FXFont *) 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXStatusLine, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXFont, 1); (arg1)->setFont(arg2); return Qnil; }
static VALUE _wrap_FXStatusLine_getFont(int argc, VALUE *argv, VALUE self) { FXStatusLine *arg1 = (FXStatusLine *) 0 ;
    FXFont *result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXStatusLine, 1);
    result = (FXFont *)((FXStatusLine const *)arg1)->getFont(); {
        swig_type_info *ty = SWIG_TypeDynamicCast(SWIGTYPE_p_FXFont, (void **) &result); vresult = FXRbGetRubyObj(result, ty); }
     return vresult; }
static VALUE _wrap_FXStatusLine_getTextColor(int argc, VALUE *argv, VALUE self) { FXStatusLine *arg1 = (FXStatusLine *) 0 ;
    FXColor result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXStatusLine, 1);
    result = (FXColor)((FXStatusLine const *)arg1)->getTextColor(); vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXStatusLine_setTextColor(int argc, VALUE *argv, VALUE self) { FXStatusLine *arg1 = (FXStatusLine *) 0 ;
    FXColor arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXStatusLine, 1); arg2 = to_FXColor(argv[0]); (arg1)->setTextColor(arg2);
    return Qnil; }
static VALUE _wrap_FXStatusLine_getTextHighlightColor(int argc, VALUE *argv, VALUE self) {
    FXStatusLine *arg1 = (FXStatusLine *) 0 ; FXColor result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXStatusLine, 1);
    result = (FXColor)((FXStatusLine const *)arg1)->getTextHighlightColor(); vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXStatusLine_setTextHighlightColor(int argc, VALUE *argv, VALUE self) {
    FXStatusLine *arg1 = (FXStatusLine *) 0 ; FXColor arg2 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXStatusLine, 1); arg2 = to_FXColor(argv[0]);
    (arg1)->setTextHighlightColor(arg2); return Qnil; }
static void
free_FXStatusLine(FXStatusLine *arg1) {
    delete arg1;
}
static VALUE _wrap_FXStatusLine_save(int argc, VALUE *argv, VALUE self) { FXStatusLine *arg1 = (FXStatusLine *) 0 ;
    FXStream *arg2 = 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXStatusLine, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXStatusLine_save((FXStatusLine const *)arg1,*arg2); return Qnil; }
static VALUE _wrap_FXStatusLine_load(int argc, VALUE *argv, VALUE self) { FXStatusLine *arg1 = (FXStatusLine *) 0 ;
    FXStream *arg2 = 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXStatusLine, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXStatusLine_load(arg1,*arg2); return Qnil; }
static VALUE _wrap_FXStatusLine_create(int argc, VALUE *argv, VALUE self) { FXStatusLine *arg1 = (FXStatusLine *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXStatusLine, 1); FXStatusLine_create(arg1); return Qnil; }
static VALUE _wrap_FXStatusLine_detach(int argc, VALUE *argv, VALUE self) { FXStatusLine *arg1 = (FXStatusLine *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXStatusLine, 1); FXStatusLine_detach(arg1); return Qnil; }
static VALUE _wrap_FXStatusLine_destroy(int argc, VALUE *argv, VALUE self) { FXStatusLine *arg1 = (FXStatusLine *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXStatusLine, 1); FXStatusLine_destroy(arg1); return Qnil; }
static VALUE _wrap_FXStatusLine_resize(int argc, VALUE *argv, VALUE self) { FXStatusLine *arg1 = (FXStatusLine *) 0 ;
    FXint arg2 ; FXint arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXStatusLine, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    FXStatusLine_resize(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXStatusLine_getDefaultWidth(int argc, VALUE *argv, VALUE self) { FXStatusLine *arg1 = (FXStatusLine *) 0 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXStatusLine, 1); result = (FXint)FXStatusLine_getDefaultWidth(arg1);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXStatusLine_getDefaultHeight(int argc, VALUE *argv, VALUE self) { FXStatusLine *arg1 = (FXStatusLine *) 0 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXStatusLine, 1); result = (FXint)FXStatusLine_getDefaultHeight(arg1);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXStatusLine_getWidthForHeight(int argc, VALUE *argv, VALUE self) { FXStatusLine *arg1 = (FXStatusLine *) 0 ;
    FXint arg2 ; FXint result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXStatusLine, 1); arg2 = NUM2INT(argv[0]);
    result = (FXint)FXStatusLine_getWidthForHeight(arg1,arg2); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXStatusLine_getHeightForWidth(int argc, VALUE *argv, VALUE self) { FXStatusLine *arg1 = (FXStatusLine *) 0 ;
    FXint arg2 ; FXint result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXStatusLine, 1); arg2 = NUM2INT(argv[0]);
    result = (FXint)FXStatusLine_getHeightForWidth(arg1,arg2); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXStatusLine_canFocus(int argc, VALUE *argv, VALUE self) { FXStatusLine *arg1 = (FXStatusLine *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXStatusLine, 1);
    result = (FXbool)FXStatusLine_canFocus((FXStatusLine const *)arg1); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXStatusLine_setFocus(int argc, VALUE *argv, VALUE self) { FXStatusLine *arg1 = (FXStatusLine *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXStatusLine, 1); FXStatusLine_setFocus(arg1); return Qnil; }
static VALUE _wrap_FXStatusLine_killFocus(int argc, VALUE *argv, VALUE self) { FXStatusLine *arg1 = (FXStatusLine *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXStatusLine, 1); FXStatusLine_killFocus(arg1); return Qnil; }
static VALUE _wrap_FXStatusLine_setDefault(int argc, VALUE *argv, VALUE self) { FXStatusLine *arg1 = (FXStatusLine *) 0 ;
    FXbool arg2 = (FXbool) 1 ; if ((argc < 0) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXStatusLine, 1); if (argc > 0) { arg2 = to_FXbool(argv[0]); } 
    FXStatusLine_setDefault(arg1,arg2); return Qnil; }
static VALUE _wrap_FXStatusLine_enable(int argc, VALUE *argv, VALUE self) { FXStatusLine *arg1 = (FXStatusLine *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXStatusLine, 1); FXStatusLine_enable(arg1); return Qnil; }
static VALUE _wrap_FXStatusLine_disable(int argc, VALUE *argv, VALUE self) { FXStatusLine *arg1 = (FXStatusLine *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXStatusLine, 1); FXStatusLine_disable(arg1); return Qnil; }
static VALUE _wrap_FXStatusLine_raiseWindow(int argc, VALUE *argv, VALUE self) { FXStatusLine *arg1 = (FXStatusLine *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXStatusLine, 1); FXStatusLine_raise(arg1); return Qnil; }
static VALUE _wrap_FXStatusLine_lower(int argc, VALUE *argv, VALUE self) { FXStatusLine *arg1 = (FXStatusLine *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXStatusLine, 1); FXStatusLine_lower(arg1); return Qnil; }
static VALUE _wrap_FXStatusLine_move(int argc, VALUE *argv, VALUE self) { FXStatusLine *arg1 = (FXStatusLine *) 0 ; FXint arg2 ;
    FXint arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXStatusLine, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    FXStatusLine_move(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXStatusLine_position(int argc, VALUE *argv, VALUE self) { FXStatusLine *arg1 = (FXStatusLine *) 0 ;
    FXint arg2 ; FXint arg3 ; FXint arg4 ; FXint arg5 ; if ((argc < 4) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXStatusLine, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    arg4 = NUM2INT(argv[2]); arg5 = NUM2INT(argv[3]); FXStatusLine_position(arg1,arg2,arg3,arg4,arg5); return Qnil; }
static VALUE _wrap_FXStatusLine_layout(int argc, VALUE *argv, VALUE self) { FXStatusLine *arg1 = (FXStatusLine *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXStatusLine, 1); FXStatusLine_layout(arg1); return Qnil; }
static VALUE _wrap_FXStatusLine_recalc(int argc, VALUE *argv, VALUE self) { FXStatusLine *arg1 = (FXStatusLine *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXStatusLine, 1); FXStatusLine_recalc(arg1); return Qnil; }
static VALUE _wrap_FXStatusLine_reparent(int argc, VALUE *argv, VALUE self) { FXStatusLine *arg1 = (FXStatusLine *) 0 ;
    FXComposite *arg2 = (FXComposite *) 0 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXStatusLine, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXComposite, 1); FXStatusLine_reparent(arg1,arg2); return Qnil; }
static VALUE _wrap_FXStatusLine_show(int argc, VALUE *argv, VALUE self) { FXStatusLine *arg1 = (FXStatusLine *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXStatusLine, 1); FXStatusLine_show(arg1); return Qnil; }
static VALUE _wrap_FXStatusLine_hide(int argc, VALUE *argv, VALUE self) { FXStatusLine *arg1 = (FXStatusLine *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXStatusLine, 1); FXStatusLine_hide(arg1); return Qnil; }
static VALUE _wrap_FXStatusLine_isComposite(int argc, VALUE *argv, VALUE self) { FXStatusLine *arg1 = (FXStatusLine *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXStatusLine, 1);
    result = (FXbool)FXStatusLine_isComposite((FXStatusLine const *)arg1); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXStatusLine_contains(int argc, VALUE *argv, VALUE self) { FXStatusLine *arg1 = (FXStatusLine *) 0 ;
    FXint arg2 ; FXint arg3 ; FXbool result; VALUE vresult = Qnil; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXStatusLine, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    result = (FXbool)FXStatusLine_contains((FXStatusLine const *)arg1,arg2,arg3); vresult = result ? Qtrue : Qfalse;
    return vresult; }
static VALUE _wrap_FXStatusLine_doesSaveUnder(int argc, VALUE *argv, VALUE self) { FXStatusLine *arg1 = (FXStatusLine *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXStatusLine, 1);
    result = (FXbool)FXStatusLine_doesSaveUnder((FXStatusLine const *)arg1); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXStatusLine_setBackColor(int argc, VALUE *argv, VALUE self) { FXStatusLine *arg1 = (FXStatusLine *) 0 ;
    FXColor arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXStatusLine, 1); arg2 = to_FXColor(argv[0]);
    FXStatusLine_setBackColor(arg1,arg2); return Qnil; }
static VALUE _wrap_FXTextField_onPaint(int argc, VALUE *argv, VALUE self) { FXTextField *arg1 = (FXTextField *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTextField, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onPaint(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTextField_onUpdate(int argc, VALUE *argv, VALUE self) { FXTextField *arg1 = (FXTextField *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTextField, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onUpdate(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTextField_onKeyPress(int argc, VALUE *argv, VALUE self) { FXTextField *arg1 = (FXTextField *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTextField, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onKeyPress(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTextField_onKeyRelease(int argc, VALUE *argv, VALUE self) { FXTextField *arg1 = (FXTextField *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTextField, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onKeyRelease(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTextField_onLeftBtnPress(int argc, VALUE *argv, VALUE self) { FXTextField *arg1 = (FXTextField *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTextField, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onLeftBtnPress(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTextField_onLeftBtnRelease(int argc, VALUE *argv, VALUE self) { FXTextField *arg1 = (FXTextField *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTextField, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onLeftBtnRelease(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTextField_onMiddleBtnPress(int argc, VALUE *argv, VALUE self) { FXTextField *arg1 = (FXTextField *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTextField, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onMiddleBtnPress(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTextField_onMiddleBtnRelease(int argc, VALUE *argv, VALUE self) { FXTextField *arg1 = (FXTextField *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTextField, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onMiddleBtnRelease(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTextField_onVerify(int argc, VALUE *argv, VALUE self) { FXTextField *arg1 = (FXTextField *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTextField, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]);
    arg4 = static_cast<void*>(STR2CSTR(argv[2])); result = (long)(arg1)->onVerify(arg2,arg3,arg4); vresult = INT2NUM(result);
    return vresult; }
static VALUE _wrap_FXTextField_onMotion(int argc, VALUE *argv, VALUE self) { FXTextField *arg1 = (FXTextField *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTextField, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onMotion(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTextField_onSelectionLost(int argc, VALUE *argv, VALUE self) { FXTextField *arg1 = (FXTextField *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTextField, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onSelectionLost(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTextField_onSelectionGained(int argc, VALUE *argv, VALUE self) { FXTextField *arg1 = (FXTextField *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTextField, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onSelectionGained(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTextField_onSelectionRequest(int argc, VALUE *argv, VALUE self) { FXTextField *arg1 = (FXTextField *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTextField, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]);
    SWIG_ConvertPtr(argv[2], (void **) &arg4, 0, 1); result = (long)(arg1)->onSelectionRequest(arg2,arg3,arg4);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTextField_onClipboardLost(int argc, VALUE *argv, VALUE self) { FXTextField *arg1 = (FXTextField *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTextField, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onClipboardLost(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTextField_onClipboardGained(int argc, VALUE *argv, VALUE self) { FXTextField *arg1 = (FXTextField *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTextField, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onClipboardGained(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTextField_onClipboardRequest(int argc, VALUE *argv, VALUE self) { FXTextField *arg1 = (FXTextField *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTextField, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onClipboardRequest(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTextField_onFocusSelf(int argc, VALUE *argv, VALUE self) { FXTextField *arg1 = (FXTextField *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTextField, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onFocusSelf(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTextField_onFocusIn(int argc, VALUE *argv, VALUE self) { FXTextField *arg1 = (FXTextField *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTextField, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onFocusIn(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTextField_onFocusOut(int argc, VALUE *argv, VALUE self) { FXTextField *arg1 = (FXTextField *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTextField, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onFocusOut(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTextField_onBlink(int argc, VALUE *argv, VALUE self) { FXTextField *arg1 = (FXTextField *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTextField, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onBlink(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTextField_onAutoScroll(int argc, VALUE *argv, VALUE self) { FXTextField *arg1 = (FXTextField *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTextField, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onAutoScroll(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTextField_onCmdSetValue(int argc, VALUE *argv, VALUE self) { FXTextField *arg1 = (FXTextField *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTextField, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]);
    arg4 = static_cast<void*>(STR2CSTR(argv[2])); result = (long)(arg1)->onCmdSetValue(arg2,arg3,arg4);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTextField_onCmdSetIntValue(int argc, VALUE *argv, VALUE self) { FXTextField *arg1 = (FXTextField *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; FXint value4 ;
    VALUE vresult = Qnil; if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTextField, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); {
        value4 = (FXint) NUM2INT(argv[2]); arg4 = static_cast<void*>(&value4); } 
    result = (long)(arg1)->onCmdSetIntValue(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTextField_onCmdSetRealValue(int argc, VALUE *argv, VALUE self) { FXTextField *arg1 = (FXTextField *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; FXdouble value4 ;
    VALUE vresult = Qnil; if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTextField, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); {
        value4 = (FXdouble) NUM2DBL(argv[2]); arg4 = (void *) &value4; } 
    result = (long)(arg1)->onCmdSetRealValue(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTextField_onCmdSetStringValue(int argc, VALUE *argv, VALUE self) { FXTextField *arg1 = (FXTextField *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; FXString value4 ;
    VALUE vresult = Qnil; if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTextField, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); {
        value4 = FXString(STR2CSTR(argv[2])); arg4 = (void *) &value4; } 
    result = (long)(arg1)->onCmdSetStringValue(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTextField_onCmdGetIntValue(int argc, VALUE *argv, VALUE self) { FXTextField *arg1 = (FXTextField *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTextField, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdGetIntValue(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTextField_onCmdGetRealValue(int argc, VALUE *argv, VALUE self) { FXTextField *arg1 = (FXTextField *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTextField, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdGetRealValue(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTextField_onCmdGetStringValue(int argc, VALUE *argv, VALUE self) { FXTextField *arg1 = (FXTextField *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTextField, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdGetStringValue(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTextField_onCmdCursorHome(int argc, VALUE *argv, VALUE self) { FXTextField *arg1 = (FXTextField *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTextField, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdCursorHome(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTextField_onCmdCursorEnd(int argc, VALUE *argv, VALUE self) { FXTextField *arg1 = (FXTextField *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTextField, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdCursorEnd(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTextField_onCmdCursorRight(int argc, VALUE *argv, VALUE self) { FXTextField *arg1 = (FXTextField *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTextField, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdCursorRight(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTextField_onCmdCursorLeft(int argc, VALUE *argv, VALUE self) { FXTextField *arg1 = (FXTextField *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTextField, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdCursorLeft(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTextField_onCmdCursorWordLeft(int argc, VALUE *argv, VALUE self) { FXTextField *arg1 = (FXTextField *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTextField, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdCursorWordLeft(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTextField_onCmdCursorWordRight(int argc, VALUE *argv, VALUE self) { FXTextField *arg1 = (FXTextField *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTextField, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdCursorWordRight(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTextField_onCmdCursorWordStart(int argc, VALUE *argv, VALUE self) { FXTextField *arg1 = (FXTextField *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTextField, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdCursorWordStart(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTextField_onCmdCursorWordEnd(int argc, VALUE *argv, VALUE self) { FXTextField *arg1 = (FXTextField *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTextField, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdCursorWordEnd(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTextField_onCmdMark(int argc, VALUE *argv, VALUE self) { FXTextField *arg1 = (FXTextField *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTextField, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdMark(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTextField_onCmdExtend(int argc, VALUE *argv, VALUE self) { FXTextField *arg1 = (FXTextField *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTextField, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdExtend(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTextField_onCmdSelectAll(int argc, VALUE *argv, VALUE self) { FXTextField *arg1 = (FXTextField *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTextField, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdSelectAll(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTextField_onCmdDeselectAll(int argc, VALUE *argv, VALUE self) { FXTextField *arg1 = (FXTextField *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTextField, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdDeselectAll(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTextField_onCmdCutSel(int argc, VALUE *argv, VALUE self) { FXTextField *arg1 = (FXTextField *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTextField, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdCutSel(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTextField_onCmdCopySel(int argc, VALUE *argv, VALUE self) { FXTextField *arg1 = (FXTextField *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTextField, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdCopySel(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTextField_onCmdPasteSel(int argc, VALUE *argv, VALUE self) { FXTextField *arg1 = (FXTextField *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTextField, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdPasteSel(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTextField_onCmdDeleteSel(int argc, VALUE *argv, VALUE self) { FXTextField *arg1 = (FXTextField *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTextField, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdDeleteSel(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTextField_onCmdDeleteAll(int argc, VALUE *argv, VALUE self) { FXTextField *arg1 = (FXTextField *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTextField, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdDeleteAll(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTextField_onCmdOverstString(int argc, VALUE *argv, VALUE self) { FXTextField *arg1 = (FXTextField *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTextField, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]);
    SWIG_ConvertPtr(argv[2], (void **) &arg4, 0, 1); result = (long)(arg1)->onCmdOverstString(arg2,arg3,arg4);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTextField_onCmdInsertString(int argc, VALUE *argv, VALUE self) { FXTextField *arg1 = (FXTextField *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTextField, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]);
    arg4 = static_cast<void*>(STR2CSTR(argv[2])); result = (long)(arg1)->onCmdInsertString(arg2,arg3,arg4);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTextField_onCmdBackspace(int argc, VALUE *argv, VALUE self) { FXTextField *arg1 = (FXTextField *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTextField, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdBackspace(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTextField_onCmdDelete(int argc, VALUE *argv, VALUE self) { FXTextField *arg1 = (FXTextField *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTextField, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdDelete(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTextField_onCmdToggleEditable(int argc, VALUE *argv, VALUE self) { FXTextField *arg1 = (FXTextField *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTextField, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdToggleEditable(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTextField_onUpdToggleEditable(int argc, VALUE *argv, VALUE self) { FXTextField *arg1 = (FXTextField *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTextField, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onUpdToggleEditable(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTextField_onCmdToggleOverstrike(int argc, VALUE *argv, VALUE self) {
    FXTextField *arg1 = (FXTextField *) 0 ; FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ;
    long result; VALUE vresult = Qnil; if ((argc < 3) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTextField, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdToggleOverstrike(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTextField_onUpdToggleOverstrike(int argc, VALUE *argv, VALUE self) {
    FXTextField *arg1 = (FXTextField *) 0 ; FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ;
    long result; VALUE vresult = Qnil; if ((argc < 3) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTextField, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onUpdToggleOverstrike(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTextField_onUpdHaveSelection(int argc, VALUE *argv, VALUE self) { FXTextField *arg1 = (FXTextField *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTextField, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onUpdHaveSelection(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTextField_onUpdSelectAll(int argc, VALUE *argv, VALUE self) { FXTextField *arg1 = (FXTextField *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTextField, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onUpdSelectAll(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTextField_onCmdSetHelp(int argc, VALUE *argv, VALUE self) { FXTextField *arg1 = (FXTextField *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; FXString value4 ;
    VALUE vresult = Qnil; if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTextField, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); {
        value4 = FXString(STR2CSTR(argv[2])); arg4 = (void *) &value4; }  result = (long)(arg1)->onCmdSetHelp(arg2,arg3,arg4);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTextField_onCmdGetHelp(int argc, VALUE *argv, VALUE self) { FXTextField *arg1 = (FXTextField *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTextField, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdGetHelp(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTextField_onCmdSetTip(int argc, VALUE *argv, VALUE self) { FXTextField *arg1 = (FXTextField *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; FXString value4 ;
    VALUE vresult = Qnil; if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTextField, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); {
        value4 = FXString(STR2CSTR(argv[2])); arg4 = (void *) &value4; }  result = (long)(arg1)->onCmdSetTip(arg2,arg3,arg4);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTextField_onCmdGetTip(int argc, VALUE *argv, VALUE self) { FXTextField *arg1 = (FXTextField *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTextField, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdGetTip(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTextField_onQueryHelp(int argc, VALUE *argv, VALUE self) { FXTextField *arg1 = (FXTextField *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTextField, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onQueryHelp(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTextField_onQueryTip(int argc, VALUE *argv, VALUE self) { FXTextField *arg1 = (FXTextField *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTextField, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onQueryTip(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE FXTextField_textDelimiters_get(VALUE self) { VALUE _val;
    _val = rb_str_new2(FXTextField::textDelimiters);    return _val; }
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE _wrap_FXTextField_allocate(VALUE self) {
#else
     static VALUE _wrap_FXTextField_allocate(int argc, VALUE *argv, VALUE self) {
#endif
         VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_FXTextField);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
         return vresult; }
static VALUE _wrap_new_FXTextField(int argc, VALUE *argv, VALUE self) { FXComposite *arg1 = (FXComposite *) 0 ; FXint arg2 ;
    FXObject *arg3 = (FXObject *) 0 ; FXSelector arg4 = (FXSelector) 0 ; FXuint arg5 = (FXuint) TEXTFIELD_NORMAL ;
    FXint arg6 = (FXint) 0 ; FXint arg7 = (FXint) 0 ; FXint arg8 = (FXint) 0 ; FXint arg9 = (FXint) 0 ;
    FXint arg10 = (FXint) DEFAULT_PAD ; FXint arg11 = (FXint) DEFAULT_PAD ; FXint arg12 = (FXint) DEFAULT_PAD ;
    FXint arg13 = (FXint) DEFAULT_PAD ; FXTextField *result; if ((argc < 2) || (argc > 13))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXComposite, 1); arg2 = NUM2INT(argv[1]); if (argc > 2) {
        SWIG_ConvertPtr(argv[2], (void **) &arg3, SWIGTYPE_p_FXObject, 1); }  if (argc > 3) { arg4 = NUM2UINT(argv[3]); } 
    if (argc > 4) { arg5 = NUM2UINT(argv[4]); }  if (argc > 5) { arg6 = NUM2INT(argv[5]); }  if (argc > 6) {
        arg7 = NUM2INT(argv[6]); }  if (argc > 7) { arg8 = NUM2INT(argv[7]); }  if (argc > 8) { arg9 = NUM2INT(argv[8]); } 
    if (argc > 9) { arg10 = NUM2INT(argv[9]); }  if (argc > 10) { arg11 = NUM2INT(argv[10]); }  if (argc > 11) {
        arg12 = NUM2INT(argv[11]); }  if (argc > 12) { arg13 = NUM2INT(argv[12]); }  {
        result = (FXTextField *)new_FXTextField(arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8,arg9,arg10,arg11,arg12,arg13);
        DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result); if(rb_block_given_p()){ rb_yield(self); }  }  return self; }
static VALUE _wrap_FXTextField_isEditable(int argc, VALUE *argv, VALUE self) { FXTextField *arg1 = (FXTextField *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTextField, 1);
    result = (FXbool)((FXTextField const *)arg1)->isEditable(); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXTextField_setEditable(int argc, VALUE *argv, VALUE self) { FXTextField *arg1 = (FXTextField *) 0 ;
    FXbool arg2 = (FXbool) 1 ; if ((argc < 0) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTextField, 1); if (argc > 0) { arg2 = to_FXbool(argv[0]); } 
    (arg1)->setEditable(arg2); return Qnil; }
static VALUE _wrap_FXTextField_setCursorPos(int argc, VALUE *argv, VALUE self) { FXTextField *arg1 = (FXTextField *) 0 ;
    FXint arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTextField, 1); arg2 = NUM2INT(argv[0]); (arg1)->setCursorPos(arg2);
    return Qnil; }
static VALUE _wrap_FXTextField_getCursorPos(int argc, VALUE *argv, VALUE self) { FXTextField *arg1 = (FXTextField *) 0 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTextField, 1);
    result = (FXint)((FXTextField const *)arg1)->getCursorPos(); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTextField_setAnchorPos(int argc, VALUE *argv, VALUE self) { FXTextField *arg1 = (FXTextField *) 0 ;
    FXint arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTextField, 1); arg2 = NUM2INT(argv[0]); (arg1)->setAnchorPos(arg2);
    return Qnil; }
static VALUE _wrap_FXTextField_getAnchorPos(int argc, VALUE *argv, VALUE self) { FXTextField *arg1 = (FXTextField *) 0 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTextField, 1);
    result = (FXint)((FXTextField const *)arg1)->getAnchorPos(); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTextField_setText(int argc, VALUE *argv, VALUE self) { FXTextField *arg1 = (FXTextField *) 0 ;
    FXString *arg2 = 0 ; SwigValueWrapper<FXString > p2 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTextField, 1); p2 = to_FXString(argv[0]); arg2 = &p2;
    (arg1)->setText((FXString const &)*arg2); return Qnil; }
static VALUE _wrap_FXTextField_getText(int argc, VALUE *argv, VALUE self) { FXTextField *arg1 = (FXTextField *) 0 ;
    FXString result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTextField, 1); result = ((FXTextField const *)arg1)->getText();
    vresult = rb_str_new2((&result)->text()); return vresult; }
static VALUE _wrap_FXTextField_setFont(int argc, VALUE *argv, VALUE self) { FXTextField *arg1 = (FXTextField *) 0 ;
    FXFont *arg2 = (FXFont *) 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTextField, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXFont, 1); (arg1)->setFont(arg2); return Qnil; }
static VALUE _wrap_FXTextField_getFont(int argc, VALUE *argv, VALUE self) { FXTextField *arg1 = (FXTextField *) 0 ;
    FXFont *result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTextField, 1);
    result = (FXFont *)((FXTextField const *)arg1)->getFont(); {
        swig_type_info *ty = SWIG_TypeDynamicCast(SWIGTYPE_p_FXFont, (void **) &result); vresult = FXRbGetRubyObj(result, ty); }
     return vresult; }
static VALUE _wrap_FXTextField_setTextColor(int argc, VALUE *argv, VALUE self) { FXTextField *arg1 = (FXTextField *) 0 ;
    FXColor arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTextField, 1); arg2 = to_FXColor(argv[0]); (arg1)->setTextColor(arg2);
    return Qnil; }
static VALUE _wrap_FXTextField_getTextColor(int argc, VALUE *argv, VALUE self) { FXTextField *arg1 = (FXTextField *) 0 ;
    FXColor result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTextField, 1);
    result = (FXColor)((FXTextField const *)arg1)->getTextColor(); vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXTextField_setSelBackColor(int argc, VALUE *argv, VALUE self) { FXTextField *arg1 = (FXTextField *) 0 ;
    FXColor arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTextField, 1); arg2 = to_FXColor(argv[0]);
    (arg1)->setSelBackColor(arg2); return Qnil; }
static VALUE _wrap_FXTextField_getSelBackColor(int argc, VALUE *argv, VALUE self) { FXTextField *arg1 = (FXTextField *) 0 ;
    FXColor result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTextField, 1);
    result = (FXColor)((FXTextField const *)arg1)->getSelBackColor(); vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXTextField_setSelTextColor(int argc, VALUE *argv, VALUE self) { FXTextField *arg1 = (FXTextField *) 0 ;
    FXColor arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTextField, 1); arg2 = to_FXColor(argv[0]);
    (arg1)->setSelTextColor(arg2); return Qnil; }
static VALUE _wrap_FXTextField_getSelTextColor(int argc, VALUE *argv, VALUE self) { FXTextField *arg1 = (FXTextField *) 0 ;
    FXColor result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTextField, 1);
    result = (FXColor)((FXTextField const *)arg1)->getSelTextColor(); vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXTextField_setCursorColor(int argc, VALUE *argv, VALUE self) { FXTextField *arg1 = (FXTextField *) 0 ;
    FXColor arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTextField, 1); arg2 = to_FXColor(argv[0]); (arg1)->setCursorColor(arg2);
    return Qnil; }
static VALUE _wrap_FXTextField_getCursorColor(int argc, VALUE *argv, VALUE self) { FXTextField *arg1 = (FXTextField *) 0 ;
    FXColor result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTextField, 1);
    result = (FXColor)((FXTextField const *)arg1)->getCursorColor(); vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXTextField_setNumColumns(int argc, VALUE *argv, VALUE self) { FXTextField *arg1 = (FXTextField *) 0 ;
    FXint arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTextField, 1); arg2 = NUM2INT(argv[0]); (arg1)->setNumColumns(arg2);
    return Qnil; }
static VALUE _wrap_FXTextField_getNumColumns(int argc, VALUE *argv, VALUE self) { FXTextField *arg1 = (FXTextField *) 0 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTextField, 1);
    result = (FXint)((FXTextField const *)arg1)->getNumColumns(); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTextField_setJustify(int argc, VALUE *argv, VALUE self) { FXTextField *arg1 = (FXTextField *) 0 ;
    FXuint arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTextField, 1); arg2 = NUM2UINT(argv[0]); (arg1)->setJustify(arg2);
    return Qnil; }
static VALUE _wrap_FXTextField_getJustify(int argc, VALUE *argv, VALUE self) { FXTextField *arg1 = (FXTextField *) 0 ;
    FXuint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTextField, 1);
    result = (FXuint)((FXTextField const *)arg1)->getJustify(); vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXTextField_setDelimiters(int argc, VALUE *argv, VALUE self) { FXTextField *arg1 = (FXTextField *) 0 ;
    FXchar *arg2 = (FXchar *) FXTextField::textDelimiters ; if ((argc < 0) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTextField, 1); if (argc > 0) { arg2 = StringValuePtr(argv[0]); } 
    (arg1)->setDelimiters((FXchar const *)arg2); return Qnil; }
static VALUE _wrap_FXTextField_getDelimiters(int argc, VALUE *argv, VALUE self) { FXTextField *arg1 = (FXTextField *) 0 ;
    FXchar *result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTextField, 1);
    result = (FXchar *)((FXTextField const *)arg1)->getDelimiters(); vresult = rb_str_new2(result); return vresult; }
static VALUE _wrap_FXTextField_setHelpText(int argc, VALUE *argv, VALUE self) { FXTextField *arg1 = (FXTextField *) 0 ;
    FXString *arg2 = 0 ; SwigValueWrapper<FXString > p2 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTextField, 1); p2 = to_FXString(argv[0]); arg2 = &p2;
    (arg1)->setHelpText((FXString const &)*arg2); return Qnil; }
static VALUE _wrap_FXTextField_getHelpText(int argc, VALUE *argv, VALUE self) { FXTextField *arg1 = (FXTextField *) 0 ;
    FXString result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTextField, 1); result = ((FXTextField const *)arg1)->getHelpText();
    vresult = rb_str_new2((&result)->text()); return vresult; }
static VALUE _wrap_FXTextField_setTipText(int argc, VALUE *argv, VALUE self) { FXTextField *arg1 = (FXTextField *) 0 ;
    FXString *arg2 = 0 ; SwigValueWrapper<FXString > p2 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTextField, 1); p2 = to_FXString(argv[0]); arg2 = &p2;
    (arg1)->setTipText((FXString const &)*arg2); return Qnil; }
static VALUE _wrap_FXTextField_getTipText(int argc, VALUE *argv, VALUE self) { FXTextField *arg1 = (FXTextField *) 0 ;
    FXString result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTextField, 1); result = ((FXTextField const *)arg1)->getTipText();
    vresult = rb_str_new2((&result)->text()); return vresult; }
static VALUE _wrap_FXTextField_setTextStyle(int argc, VALUE *argv, VALUE self) { FXTextField *arg1 = (FXTextField *) 0 ;
    FXuint arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTextField, 1); arg2 = NUM2UINT(argv[0]); (arg1)->setTextStyle(arg2);
    return Qnil; }
static VALUE _wrap_FXTextField_getTextStyle(int argc, VALUE *argv, VALUE self) { FXTextField *arg1 = (FXTextField *) 0 ;
    FXuint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTextField, 1);
    result = (FXuint)((FXTextField const *)arg1)->getTextStyle(); vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXTextField_selectAll(int argc, VALUE *argv, VALUE self) { FXTextField *arg1 = (FXTextField *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTextField, 1); result = (FXbool)(arg1)->selectAll();
    vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXTextField_setSelection(int argc, VALUE *argv, VALUE self) { FXTextField *arg1 = (FXTextField *) 0 ;
    FXint arg2 ; FXint arg3 ; FXbool result; VALUE vresult = Qnil; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTextField, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    result = (FXbool)(arg1)->setSelection(arg2,arg3); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXTextField_extendSelection(int argc, VALUE *argv, VALUE self) { FXTextField *arg1 = (FXTextField *) 0 ;
    FXint arg2 ; FXbool result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTextField, 1); arg2 = NUM2INT(argv[0]);
    result = (FXbool)(arg1)->extendSelection(arg2); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXTextField_killSelection(int argc, VALUE *argv, VALUE self) { FXTextField *arg1 = (FXTextField *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTextField, 1); result = (FXbool)(arg1)->killSelection();
    vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXTextField_isPosSelected(int argc, VALUE *argv, VALUE self) { FXTextField *arg1 = (FXTextField *) 0 ;
    FXint arg2 ; FXbool result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTextField, 1); arg2 = NUM2INT(argv[0]);
    result = (FXbool)((FXTextField const *)arg1)->isPosSelected(arg2); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXTextField_isPosVisible(int argc, VALUE *argv, VALUE self) { FXTextField *arg1 = (FXTextField *) 0 ;
    FXint arg2 ; FXbool result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTextField, 1); arg2 = NUM2INT(argv[0]);
    result = (FXbool)((FXTextField const *)arg1)->isPosVisible(arg2); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXTextField_makePositionVisible(int argc, VALUE *argv, VALUE self) { FXTextField *arg1 = (FXTextField *) 0 ;
    FXint arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTextField, 1); arg2 = NUM2INT(argv[0]);
    (arg1)->makePositionVisible(arg2); return Qnil; }
static void
free_FXTextField(FXTextField *arg1) {
    delete arg1;
}
static VALUE _wrap_FXTextField_save(int argc, VALUE *argv, VALUE self) { FXTextField *arg1 = (FXTextField *) 0 ;
    FXStream *arg2 = 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTextField, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXTextField_save((FXTextField const *)arg1,*arg2); return Qnil; }
static VALUE _wrap_FXTextField_load(int argc, VALUE *argv, VALUE self) { FXTextField *arg1 = (FXTextField *) 0 ;
    FXStream *arg2 = 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTextField, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXTextField_load(arg1,*arg2); return Qnil; }
static VALUE _wrap_FXTextField_create(int argc, VALUE *argv, VALUE self) { FXTextField *arg1 = (FXTextField *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTextField, 1); FXTextField_create(arg1); return Qnil; }
static VALUE _wrap_FXTextField_detach(int argc, VALUE *argv, VALUE self) { FXTextField *arg1 = (FXTextField *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTextField, 1); FXTextField_detach(arg1); return Qnil; }
static VALUE _wrap_FXTextField_destroy(int argc, VALUE *argv, VALUE self) { FXTextField *arg1 = (FXTextField *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTextField, 1); FXTextField_destroy(arg1); return Qnil; }
static VALUE _wrap_FXTextField_resize(int argc, VALUE *argv, VALUE self) { FXTextField *arg1 = (FXTextField *) 0 ; FXint arg2 ;
    FXint arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTextField, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    FXTextField_resize(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXTextField_getDefaultWidth(int argc, VALUE *argv, VALUE self) { FXTextField *arg1 = (FXTextField *) 0 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTextField, 1); result = (FXint)FXTextField_getDefaultWidth(arg1);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTextField_getDefaultHeight(int argc, VALUE *argv, VALUE self) { FXTextField *arg1 = (FXTextField *) 0 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTextField, 1); result = (FXint)FXTextField_getDefaultHeight(arg1);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTextField_getWidthForHeight(int argc, VALUE *argv, VALUE self) { FXTextField *arg1 = (FXTextField *) 0 ;
    FXint arg2 ; FXint result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTextField, 1); arg2 = NUM2INT(argv[0]);
    result = (FXint)FXTextField_getWidthForHeight(arg1,arg2); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTextField_getHeightForWidth(int argc, VALUE *argv, VALUE self) { FXTextField *arg1 = (FXTextField *) 0 ;
    FXint arg2 ; FXint result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTextField, 1); arg2 = NUM2INT(argv[0]);
    result = (FXint)FXTextField_getHeightForWidth(arg1,arg2); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTextField_canFocus(int argc, VALUE *argv, VALUE self) { FXTextField *arg1 = (FXTextField *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTextField, 1);
    result = (FXbool)FXTextField_canFocus((FXTextField const *)arg1); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXTextField_setFocus(int argc, VALUE *argv, VALUE self) { FXTextField *arg1 = (FXTextField *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTextField, 1); FXTextField_setFocus(arg1); return Qnil; }
static VALUE _wrap_FXTextField_killFocus(int argc, VALUE *argv, VALUE self) { FXTextField *arg1 = (FXTextField *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTextField, 1); FXTextField_killFocus(arg1); return Qnil; }
static VALUE _wrap_FXTextField_setDefault(int argc, VALUE *argv, VALUE self) { FXTextField *arg1 = (FXTextField *) 0 ;
    FXbool arg2 = (FXbool) 1 ; if ((argc < 0) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTextField, 1); if (argc > 0) { arg2 = to_FXbool(argv[0]); } 
    FXTextField_setDefault(arg1,arg2); return Qnil; }
static VALUE _wrap_FXTextField_enable(int argc, VALUE *argv, VALUE self) { FXTextField *arg1 = (FXTextField *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTextField, 1); FXTextField_enable(arg1); return Qnil; }
static VALUE _wrap_FXTextField_disable(int argc, VALUE *argv, VALUE self) { FXTextField *arg1 = (FXTextField *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTextField, 1); FXTextField_disable(arg1); return Qnil; }
static VALUE _wrap_FXTextField_raiseWindow(int argc, VALUE *argv, VALUE self) { FXTextField *arg1 = (FXTextField *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTextField, 1); FXTextField_raise(arg1); return Qnil; }
static VALUE _wrap_FXTextField_lower(int argc, VALUE *argv, VALUE self) { FXTextField *arg1 = (FXTextField *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTextField, 1); FXTextField_lower(arg1); return Qnil; }
static VALUE _wrap_FXTextField_move(int argc, VALUE *argv, VALUE self) { FXTextField *arg1 = (FXTextField *) 0 ; FXint arg2 ;
    FXint arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTextField, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    FXTextField_move(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXTextField_position(int argc, VALUE *argv, VALUE self) { FXTextField *arg1 = (FXTextField *) 0 ;
    FXint arg2 ; FXint arg3 ; FXint arg4 ; FXint arg5 ; if ((argc < 4) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTextField, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    arg4 = NUM2INT(argv[2]); arg5 = NUM2INT(argv[3]); FXTextField_position(arg1,arg2,arg3,arg4,arg5); return Qnil; }
static VALUE _wrap_FXTextField_layout(int argc, VALUE *argv, VALUE self) { FXTextField *arg1 = (FXTextField *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTextField, 1); FXTextField_layout(arg1); return Qnil; }
static VALUE _wrap_FXTextField_recalc(int argc, VALUE *argv, VALUE self) { FXTextField *arg1 = (FXTextField *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTextField, 1); FXTextField_recalc(arg1); return Qnil; }
static VALUE _wrap_FXTextField_reparent(int argc, VALUE *argv, VALUE self) { FXTextField *arg1 = (FXTextField *) 0 ;
    FXComposite *arg2 = (FXComposite *) 0 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTextField, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXComposite, 1); FXTextField_reparent(arg1,arg2); return Qnil; }
static VALUE _wrap_FXTextField_show(int argc, VALUE *argv, VALUE self) { FXTextField *arg1 = (FXTextField *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTextField, 1); FXTextField_show(arg1); return Qnil; }
static VALUE _wrap_FXTextField_hide(int argc, VALUE *argv, VALUE self) { FXTextField *arg1 = (FXTextField *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTextField, 1); FXTextField_hide(arg1); return Qnil; }
static VALUE _wrap_FXTextField_isComposite(int argc, VALUE *argv, VALUE self) { FXTextField *arg1 = (FXTextField *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTextField, 1);
    result = (FXbool)FXTextField_isComposite((FXTextField const *)arg1); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXTextField_contains(int argc, VALUE *argv, VALUE self) { FXTextField *arg1 = (FXTextField *) 0 ;
    FXint arg2 ; FXint arg3 ; FXbool result; VALUE vresult = Qnil; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTextField, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    result = (FXbool)FXTextField_contains((FXTextField const *)arg1,arg2,arg3); vresult = result ? Qtrue : Qfalse;
    return vresult; }
static VALUE _wrap_FXTextField_doesSaveUnder(int argc, VALUE *argv, VALUE self) { FXTextField *arg1 = (FXTextField *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTextField, 1);
    result = (FXbool)FXTextField_doesSaveUnder((FXTextField const *)arg1); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXTextField_setBackColor(int argc, VALUE *argv, VALUE self) { FXTextField *arg1 = (FXTextField *) 0 ;
    FXColor arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTextField, 1); arg2 = to_FXColor(argv[0]);
    FXTextField_setBackColor(arg1,arg2); return Qnil; }
static VALUE _wrap_FXToolBarTab_onPaint(int argc, VALUE *argv, VALUE self) { FXToolBarTab *arg1 = (FXToolBarTab *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToolBarTab, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onPaint(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXToolBarTab_onUpdate(int argc, VALUE *argv, VALUE self) { FXToolBarTab *arg1 = (FXToolBarTab *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToolBarTab, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onUpdate(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXToolBarTab_onEnter(int argc, VALUE *argv, VALUE self) { FXToolBarTab *arg1 = (FXToolBarTab *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToolBarTab, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onEnter(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXToolBarTab_onLeave(int argc, VALUE *argv, VALUE self) { FXToolBarTab *arg1 = (FXToolBarTab *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToolBarTab, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onLeave(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXToolBarTab_onUngrabbed(int argc, VALUE *argv, VALUE self) { FXToolBarTab *arg1 = (FXToolBarTab *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToolBarTab, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onUngrabbed(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXToolBarTab_onLeftBtnPress(int argc, VALUE *argv, VALUE self) { FXToolBarTab *arg1 = (FXToolBarTab *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToolBarTab, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onLeftBtnPress(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXToolBarTab_onLeftBtnRelease(int argc, VALUE *argv, VALUE self) { FXToolBarTab *arg1 = (FXToolBarTab *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToolBarTab, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onLeftBtnRelease(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXToolBarTab_onKeyPress(int argc, VALUE *argv, VALUE self) { FXToolBarTab *arg1 = (FXToolBarTab *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToolBarTab, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onKeyPress(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXToolBarTab_onKeyRelease(int argc, VALUE *argv, VALUE self) { FXToolBarTab *arg1 = (FXToolBarTab *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToolBarTab, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onKeyRelease(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXToolBarTab_onCmdCollapse(int argc, VALUE *argv, VALUE self) { FXToolBarTab *arg1 = (FXToolBarTab *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToolBarTab, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdCollapse(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXToolBarTab_onUpdCollapse(int argc, VALUE *argv, VALUE self) { FXToolBarTab *arg1 = (FXToolBarTab *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToolBarTab, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onUpdCollapse(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXToolBarTab_onCmdUncollapse(int argc, VALUE *argv, VALUE self) { FXToolBarTab *arg1 = (FXToolBarTab *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToolBarTab, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdUncollapse(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXToolBarTab_onUpdUncollapse(int argc, VALUE *argv, VALUE self) { FXToolBarTab *arg1 = (FXToolBarTab *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToolBarTab, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onUpdUncollapse(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE _wrap_FXToolBarTab_allocate(VALUE self) {
#else
     static VALUE _wrap_FXToolBarTab_allocate(int argc, VALUE *argv, VALUE self) {
#endif
         VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_FXToolBarTab);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
         return vresult; }
static VALUE _wrap_new_FXToolBarTab(int argc, VALUE *argv, VALUE self) { FXComposite *arg1 = (FXComposite *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 = (FXSelector) 0 ; FXuint arg4 = (FXuint) FRAME_RAISED ;
    FXint arg5 = (FXint) 0 ; FXint arg6 = (FXint) 0 ; FXint arg7 = (FXint) 0 ; FXint arg8 = (FXint) 0 ; FXToolBarTab *result;
    if ((argc < 1) || (argc > 8)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXComposite, 1); if (argc > 1) {
        SWIG_ConvertPtr(argv[1], (void **) &arg2, SWIGTYPE_p_FXObject, 1); }  if (argc > 2) { arg3 = NUM2UINT(argv[2]); } 
    if (argc > 3) { arg4 = NUM2UINT(argv[3]); }  if (argc > 4) { arg5 = NUM2INT(argv[4]); }  if (argc > 5) {
        arg6 = NUM2INT(argv[5]); }  if (argc > 6) { arg7 = NUM2INT(argv[6]); }  if (argc > 7) { arg8 = NUM2INT(argv[7]); }  {
        result = (FXToolBarTab *)new_FXToolBarTab(arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8);
        DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result); if(rb_block_given_p()){ rb_yield(self); }  }  return self; }
static VALUE _wrap_FXToolBarTab_collapse(int argc, VALUE *argv, VALUE self) { FXToolBarTab *arg1 = (FXToolBarTab *) 0 ;
    FXbool arg2 = (FXbool) 1 ; if ((argc < 0) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToolBarTab, 1); if (argc > 0) { arg2 = to_FXbool(argv[0]); } 
    (arg1)->collapse(arg2); return Qnil; }
static VALUE _wrap_FXToolBarTab_isCollapsed(int argc, VALUE *argv, VALUE self) { FXToolBarTab *arg1 = (FXToolBarTab *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToolBarTab, 1);
    result = (FXbool)((FXToolBarTab const *)arg1)->isCollapsed(); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXToolBarTab_setTabStyle(int argc, VALUE *argv, VALUE self) { FXToolBarTab *arg1 = (FXToolBarTab *) 0 ;
    FXuint arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToolBarTab, 1); arg2 = NUM2UINT(argv[0]); (arg1)->setTabStyle(arg2);
    return Qnil; }
static VALUE _wrap_FXToolBarTab_getTabStyle(int argc, VALUE *argv, VALUE self) { FXToolBarTab *arg1 = (FXToolBarTab *) 0 ;
    FXuint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToolBarTab, 1);
    result = (FXuint)((FXToolBarTab const *)arg1)->getTabStyle(); vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXToolBarTab_getActiveColor(int argc, VALUE *argv, VALUE self) { FXToolBarTab *arg1 = (FXToolBarTab *) 0 ;
    FXColor result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToolBarTab, 1);
    result = (FXColor)((FXToolBarTab const *)arg1)->getActiveColor(); vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXToolBarTab_setActiveColor(int argc, VALUE *argv, VALUE self) { FXToolBarTab *arg1 = (FXToolBarTab *) 0 ;
    FXColor arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToolBarTab, 1); arg2 = to_FXColor(argv[0]);
    (arg1)->setActiveColor(arg2); return Qnil; }
static void
free_FXToolBarTab(FXToolBarTab *arg1) {
    delete arg1;
}
static VALUE _wrap_FXToolBarTab_save(int argc, VALUE *argv, VALUE self) { FXToolBarTab *arg1 = (FXToolBarTab *) 0 ;
    FXStream *arg2 = 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToolBarTab, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXToolBarTab_save((FXToolBarTab const *)arg1,*arg2); return Qnil; }
static VALUE _wrap_FXToolBarTab_load(int argc, VALUE *argv, VALUE self) { FXToolBarTab *arg1 = (FXToolBarTab *) 0 ;
    FXStream *arg2 = 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToolBarTab, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXToolBarTab_load(arg1,*arg2); return Qnil; }
static VALUE _wrap_FXToolBarTab_create(int argc, VALUE *argv, VALUE self) { FXToolBarTab *arg1 = (FXToolBarTab *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToolBarTab, 1); FXToolBarTab_create(arg1); return Qnil; }
static VALUE _wrap_FXToolBarTab_detach(int argc, VALUE *argv, VALUE self) { FXToolBarTab *arg1 = (FXToolBarTab *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToolBarTab, 1); FXToolBarTab_detach(arg1); return Qnil; }
static VALUE _wrap_FXToolBarTab_destroy(int argc, VALUE *argv, VALUE self) { FXToolBarTab *arg1 = (FXToolBarTab *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToolBarTab, 1); FXToolBarTab_destroy(arg1); return Qnil; }
static VALUE _wrap_FXToolBarTab_resize(int argc, VALUE *argv, VALUE self) { FXToolBarTab *arg1 = (FXToolBarTab *) 0 ;
    FXint arg2 ; FXint arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToolBarTab, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    FXToolBarTab_resize(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXToolBarTab_getDefaultWidth(int argc, VALUE *argv, VALUE self) { FXToolBarTab *arg1 = (FXToolBarTab *) 0 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToolBarTab, 1); result = (FXint)FXToolBarTab_getDefaultWidth(arg1);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXToolBarTab_getDefaultHeight(int argc, VALUE *argv, VALUE self) { FXToolBarTab *arg1 = (FXToolBarTab *) 0 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToolBarTab, 1); result = (FXint)FXToolBarTab_getDefaultHeight(arg1);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXToolBarTab_getWidthForHeight(int argc, VALUE *argv, VALUE self) { FXToolBarTab *arg1 = (FXToolBarTab *) 0 ;
    FXint arg2 ; FXint result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToolBarTab, 1); arg2 = NUM2INT(argv[0]);
    result = (FXint)FXToolBarTab_getWidthForHeight(arg1,arg2); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXToolBarTab_getHeightForWidth(int argc, VALUE *argv, VALUE self) { FXToolBarTab *arg1 = (FXToolBarTab *) 0 ;
    FXint arg2 ; FXint result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToolBarTab, 1); arg2 = NUM2INT(argv[0]);
    result = (FXint)FXToolBarTab_getHeightForWidth(arg1,arg2); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXToolBarTab_canFocus(int argc, VALUE *argv, VALUE self) { FXToolBarTab *arg1 = (FXToolBarTab *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToolBarTab, 1);
    result = (FXbool)FXToolBarTab_canFocus((FXToolBarTab const *)arg1); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXToolBarTab_setFocus(int argc, VALUE *argv, VALUE self) { FXToolBarTab *arg1 = (FXToolBarTab *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToolBarTab, 1); FXToolBarTab_setFocus(arg1); return Qnil; }
static VALUE _wrap_FXToolBarTab_killFocus(int argc, VALUE *argv, VALUE self) { FXToolBarTab *arg1 = (FXToolBarTab *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToolBarTab, 1); FXToolBarTab_killFocus(arg1); return Qnil; }
static VALUE _wrap_FXToolBarTab_setDefault(int argc, VALUE *argv, VALUE self) { FXToolBarTab *arg1 = (FXToolBarTab *) 0 ;
    FXbool arg2 = (FXbool) 1 ; if ((argc < 0) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToolBarTab, 1); if (argc > 0) { arg2 = to_FXbool(argv[0]); } 
    FXToolBarTab_setDefault(arg1,arg2); return Qnil; }
static VALUE _wrap_FXToolBarTab_enable(int argc, VALUE *argv, VALUE self) { FXToolBarTab *arg1 = (FXToolBarTab *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToolBarTab, 1); FXToolBarTab_enable(arg1); return Qnil; }
static VALUE _wrap_FXToolBarTab_disable(int argc, VALUE *argv, VALUE self) { FXToolBarTab *arg1 = (FXToolBarTab *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToolBarTab, 1); FXToolBarTab_disable(arg1); return Qnil; }
static VALUE _wrap_FXToolBarTab_raiseWindow(int argc, VALUE *argv, VALUE self) { FXToolBarTab *arg1 = (FXToolBarTab *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToolBarTab, 1); FXToolBarTab_raise(arg1); return Qnil; }
static VALUE _wrap_FXToolBarTab_lower(int argc, VALUE *argv, VALUE self) { FXToolBarTab *arg1 = (FXToolBarTab *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToolBarTab, 1); FXToolBarTab_lower(arg1); return Qnil; }
static VALUE _wrap_FXToolBarTab_move(int argc, VALUE *argv, VALUE self) { FXToolBarTab *arg1 = (FXToolBarTab *) 0 ; FXint arg2 ;
    FXint arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToolBarTab, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    FXToolBarTab_move(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXToolBarTab_position(int argc, VALUE *argv, VALUE self) { FXToolBarTab *arg1 = (FXToolBarTab *) 0 ;
    FXint arg2 ; FXint arg3 ; FXint arg4 ; FXint arg5 ; if ((argc < 4) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToolBarTab, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    arg4 = NUM2INT(argv[2]); arg5 = NUM2INT(argv[3]); FXToolBarTab_position(arg1,arg2,arg3,arg4,arg5); return Qnil; }
static VALUE _wrap_FXToolBarTab_layout(int argc, VALUE *argv, VALUE self) { FXToolBarTab *arg1 = (FXToolBarTab *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToolBarTab, 1); FXToolBarTab_layout(arg1); return Qnil; }
static VALUE _wrap_FXToolBarTab_recalc(int argc, VALUE *argv, VALUE self) { FXToolBarTab *arg1 = (FXToolBarTab *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToolBarTab, 1); FXToolBarTab_recalc(arg1); return Qnil; }
static VALUE _wrap_FXToolBarTab_reparent(int argc, VALUE *argv, VALUE self) { FXToolBarTab *arg1 = (FXToolBarTab *) 0 ;
    FXComposite *arg2 = (FXComposite *) 0 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToolBarTab, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXComposite, 1); FXToolBarTab_reparent(arg1,arg2); return Qnil; }
static VALUE _wrap_FXToolBarTab_show(int argc, VALUE *argv, VALUE self) { FXToolBarTab *arg1 = (FXToolBarTab *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToolBarTab, 1); FXToolBarTab_show(arg1); return Qnil; }
static VALUE _wrap_FXToolBarTab_hide(int argc, VALUE *argv, VALUE self) { FXToolBarTab *arg1 = (FXToolBarTab *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToolBarTab, 1); FXToolBarTab_hide(arg1); return Qnil; }
static VALUE _wrap_FXToolBarTab_isComposite(int argc, VALUE *argv, VALUE self) { FXToolBarTab *arg1 = (FXToolBarTab *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToolBarTab, 1);
    result = (FXbool)FXToolBarTab_isComposite((FXToolBarTab const *)arg1); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXToolBarTab_contains(int argc, VALUE *argv, VALUE self) { FXToolBarTab *arg1 = (FXToolBarTab *) 0 ;
    FXint arg2 ; FXint arg3 ; FXbool result; VALUE vresult = Qnil; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToolBarTab, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    result = (FXbool)FXToolBarTab_contains((FXToolBarTab const *)arg1,arg2,arg3); vresult = result ? Qtrue : Qfalse;
    return vresult; }
static VALUE _wrap_FXToolBarTab_doesSaveUnder(int argc, VALUE *argv, VALUE self) { FXToolBarTab *arg1 = (FXToolBarTab *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToolBarTab, 1);
    result = (FXbool)FXToolBarTab_doesSaveUnder((FXToolBarTab const *)arg1); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXToolBarTab_setBackColor(int argc, VALUE *argv, VALUE self) { FXToolBarTab *arg1 = (FXToolBarTab *) 0 ;
    FXColor arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToolBarTab, 1); arg2 = to_FXColor(argv[0]);
    FXToolBarTab_setBackColor(arg1,arg2); return Qnil; }

/* -------- TYPE CONVERSION AND EQUIVALENCE RULES (BEGIN) -------- */

static void *_p_FXToolBarTabTo_p_FXFrame(void *x) {
    return (void *)((FXFrame *)  ((FXToolBarTab *) x));
}
static void *_p_FXColorBarTo_p_FXFrame(void *x) {
    return (void *)((FXFrame *)  ((FXColorBar *) x));
}
static void *_p_FXBitmapFrameTo_p_FXFrame(void *x) {
    return (void *)((FXFrame *)  ((FXBitmapFrame *) x));
}
static void *_p_FXDialTo_p_FXFrame(void *x) {
    return (void *)((FXFrame *)  ((FXDial *) x));
}
static void *_p_FXRulerTo_p_FXFrame(void *x) {
    return (void *)((FXFrame *)  ((FXRuler *) x));
}
static void *_p_FXArrowButtonTo_p_FXFrame(void *x) {
    return (void *)((FXFrame *)  ((FXArrowButton *) x));
}
static void *_p_FXColorWheelTo_p_FXFrame(void *x) {
    return (void *)((FXFrame *)  ((FXColorWheel *) x));
}
static void *_p_FXProgressBarTo_p_FXFrame(void *x) {
    return (void *)((FXFrame *)  ((FXProgressBar *) x));
}
static void *_p_FXColorWellTo_p_FXFrame(void *x) {
    return (void *)((FXFrame *)  ((FXColorWell *) x));
}
static void *_p_FXStatusLineTo_p_FXFrame(void *x) {
    return (void *)((FXFrame *)  ((FXStatusLine *) x));
}
static void *_p_FXVerticalSeparatorTo_p_FXFrame(void *x) {
    return (void *)((FXFrame *) (FXSeparator *) ((FXVerticalSeparator *) x));
}
static void *_p_FXHorizontalSeparatorTo_p_FXFrame(void *x) {
    return (void *)((FXFrame *) (FXSeparator *) ((FXHorizontalSeparator *) x));
}
static void *_p_FXSeparatorTo_p_FXFrame(void *x) {
    return (void *)((FXFrame *)  ((FXSeparator *) x));
}
static void *_p_FXTextFieldTo_p_FXFrame(void *x) {
    return (void *)((FXFrame *)  ((FXTextField *) x));
}
static void *_p_FXHeaderTo_p_FXFrame(void *x) {
    return (void *)((FXFrame *)  ((FXHeader *) x));
}
static void *_p_FXImageFrameTo_p_FXFrame(void *x) {
    return (void *)((FXFrame *)  ((FXImageFrame *) x));
}
static void *_p_FXSliderTo_p_FXFrame(void *x) {
    return (void *)((FXFrame *)  ((FXSlider *) x));
}
static void *_p_FXRealSliderTo_p_FXFrame(void *x) {
    return (void *)((FXFrame *)  ((FXRealSlider *) x));
}
static void *_p_FXFrameTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *) ((FXFrame *) x));
}
static void *_p_FXToolBarTabTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXFrame *) ((FXToolBarTab *) x));
}
static void *_p_FXPopupTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXShell *) ((FXPopup *) x));
}
static void *_p_FXColorBarTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXFrame *) ((FXColorBar *) x));
}
static void *_p_FXBitmapFrameTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXFrame *) ((FXBitmapFrame *) x));
}
static void *_p_FXDialTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXFrame *) ((FXDial *) x));
}
static void *_p_FXRulerTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXFrame *) ((FXRuler *) x));
}
static void *_p_FXMainWindowTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXShell *)(FXTopWindow *) ((FXMainWindow *) x));
}
static void *_p_FXTopWindowTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXShell *) ((FXTopWindow *) x));
}
static void *_p_FXRootWindowTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *) ((FXRootWindow *) x));
}
static void *_p_FXWindowTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *) ((FXWindow *) x));
}
static void *_p_FXCompositeTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *) ((FXComposite *) x));
}
static void *_p_FXArrowButtonTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXFrame *) ((FXArrowButton *) x));
}
static void *_p_FXColorWellTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXFrame *) ((FXColorWell *) x));
}
static void *_p_FXColorWheelTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXFrame *) ((FXColorWheel *) x));
}
static void *_p_FXProgressBarTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXFrame *) ((FXProgressBar *) x));
}
static void *_p_FXShellTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *) ((FXShell *) x));
}
static void *_p_FXStatusLineTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXFrame *) ((FXStatusLine *) x));
}
static void *_p_FXSeparatorTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXFrame *) ((FXSeparator *) x));
}
static void *_p_FXHorizontalSeparatorTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXFrame *)(FXSeparator *) ((FXHorizontalSeparator *) x));
}
static void *_p_FXVerticalSeparatorTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXFrame *)(FXSeparator *) ((FXVerticalSeparator *) x));
}
static void *_p_FXGIFCursorTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXCursor *) ((FXGIFCursor *) x));
}
static void *_p_FXCURCursorTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXCursor *) ((FXCURCursor *) x));
}
static void *_p_FXCursorTo_p_FXId(void *x) {
    return (void *)((FXId *)  ((FXCursor *) x));
}
static void *_p_FXDrawableTo_p_FXId(void *x) {
    return (void *)((FXId *)  ((FXDrawable *) x));
}
static void *_p_FXTextFieldTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXFrame *) ((FXTextField *) x));
}
static void *_p_FXFontTo_p_FXId(void *x) {
    return (void *)((FXId *)  ((FXFont *) x));
}
static void *_p_FXHeaderTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXFrame *) ((FXHeader *) x));
}
static void *_p_FXVisualTo_p_FXId(void *x) {
    return (void *)((FXId *)  ((FXVisual *) x));
}
static void *_p_FXImageFrameTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXFrame *) ((FXImageFrame *) x));
}
static void *_p_FXSliderTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXFrame *) ((FXSlider *) x));
}
static void *_p_FXRealSliderTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXFrame *) ((FXRealSlider *) x));
}
static void *_p_FXSettingsTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXDict *) ((FXSettings *) x));
}
static void *_p_FXAccelTableTo_p_FXObject(void *x) {
    return (void *)((FXObject *)  ((FXAccelTable *) x));
}
static void *_p_FXCompositeTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *) ((FXComposite *) x));
}
static void *_p_FXRegistryTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXDict *)(FXSettings *) ((FXRegistry *) x));
}
static void *_p_FXTextFieldTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXFrame *) ((FXTextField *) x));
}
static void *_p_FXArrowButtonTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXFrame *) ((FXArrowButton *) x));
}
static void *_p_FXIconDictTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXDict *) ((FXIconDict *) x));
}
static void *_p_FXShellTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *) ((FXShell *) x));
}
static void *_p_FXPopupTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXShell *) ((FXPopup *) x));
}
static void *_p_FXRecentFilesTo_p_FXObject(void *x) {
    return (void *)((FXObject *)  ((FXRecentFiles *) x));
}
static void *_p_FXDocumentTo_p_FXObject(void *x) {
    return (void *)((FXObject *)  ((FXDocument *) x));
}
static void *_p_FXMainWindowTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXShell *)(FXTopWindow *) ((FXMainWindow *) x));
}
static void *_p_FXTopWindowTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXShell *) ((FXTopWindow *) x));
}
static void *_p_FXRootWindowTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *) ((FXRootWindow *) x));
}
static void *_p_FXWindowTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *) ((FXWindow *) x));
}
static void *_p_FXRulerTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXFrame *) ((FXRuler *) x));
}
static void *_p_FXSeparatorTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXFrame *) ((FXSeparator *) x));
}
static void *_p_FXHorizontalSeparatorTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXFrame *)(FXSeparator *) ((FXHorizontalSeparator *) x));
}
static void *_p_FXVerticalSeparatorTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXFrame *)(FXSeparator *) ((FXVerticalSeparator *) x));
}
static void *_p_FXStatusLineTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXFrame *) ((FXStatusLine *) x));
}
static void *_p_FXStringDictTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXDict *) ((FXStringDict *) x));
}
static void *_p_FXColorWheelTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXFrame *) ((FXColorWheel *) x));
}
static void *_p_FXBitmapFrameTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXFrame *) ((FXBitmapFrame *) x));
}
static void *_p_FXFontTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *) ((FXFont *) x));
}
static void *_p_FXFileDictTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXDict *) ((FXFileDict *) x));
}
static void *_p_FXImageFrameTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXFrame *) ((FXImageFrame *) x));
}
static void *_p_FXDataTargetTo_p_FXObject(void *x) {
    return (void *)((FXObject *)  ((FXDataTarget *) x));
}
static void *_p_FXDebugTargetTo_p_FXObject(void *x) {
    return (void *)((FXObject *)  ((FXDebugTarget *) x));
}
static void *_p_FXDelegatorTo_p_FXObject(void *x) {
    return (void *)((FXObject *)  ((FXDelegator *) x));
}
static void *_p_FXDrawableTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *) ((FXDrawable *) x));
}
static void *_p_FXGIFCursorTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXCursor *) ((FXGIFCursor *) x));
}
static void *_p_FXCURCursorTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXCursor *) ((FXCURCursor *) x));
}
static void *_p_FXCursorTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *) ((FXCursor *) x));
}
static void *_p_FXProgressBarTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXFrame *) ((FXProgressBar *) x));
}
static void *_p_FXDictTo_p_FXObject(void *x) {
    return (void *)((FXObject *)  ((FXDict *) x));
}
static void *_p_FXHeaderTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXFrame *) ((FXHeader *) x));
}
static void *_p_FXColorWellTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXFrame *) ((FXColorWell *) x));
}
static void *_p_FXHeaderItemTo_p_FXObject(void *x) {
    return (void *)((FXObject *)  ((FXHeaderItem *) x));
}
static void *_p_FXDialTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXFrame *) ((FXDial *) x));
}
static void *_p_FXToolBarTabTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXFrame *) ((FXToolBarTab *) x));
}
static void *_p_FXIdTo_p_FXObject(void *x) {
    return (void *)((FXObject *)  ((FXId *) x));
}
static void *_p_FXFrameTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *) ((FXFrame *) x));
}
static void *_p_FXSliderTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXFrame *) ((FXSlider *) x));
}
static void *_p_FXRealSliderTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXFrame *) ((FXRealSlider *) x));
}
static void *_p_FXVisualTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *) ((FXVisual *) x));
}
static void *_p_FXColorBarTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXFrame *) ((FXColorBar *) x));
}
static void *_p_FXAppTo_p_FXObject(void *x) {
    return (void *)((FXObject *)  ((FXApp *) x));
}
static void *_p_FXFrameTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *)  ((FXFrame *) x));
}
static void *_p_FXToolBarTabTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXFrame *) ((FXToolBarTab *) x));
}
static void *_p_FXColorBarTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXFrame *) ((FXColorBar *) x));
}
static void *_p_FXPopupTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXShell *) ((FXPopup *) x));
}
static void *_p_FXBitmapFrameTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXFrame *) ((FXBitmapFrame *) x));
}
static void *_p_FXDialTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXFrame *) ((FXDial *) x));
}
static void *_p_FXRulerTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXFrame *) ((FXRuler *) x));
}
static void *_p_FXArrowButtonTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXFrame *) ((FXArrowButton *) x));
}
static void *_p_FXMainWindowTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXShell *)(FXTopWindow *) ((FXMainWindow *) x));
}
static void *_p_FXTopWindowTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXShell *) ((FXTopWindow *) x));
}
static void *_p_FXRootWindowTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *) ((FXRootWindow *) x));
}
static void *_p_FXCompositeTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *)  ((FXComposite *) x));
}
static void *_p_FXColorWheelTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXFrame *) ((FXColorWheel *) x));
}
static void *_p_FXColorWellTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXFrame *) ((FXColorWell *) x));
}
static void *_p_FXProgressBarTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXFrame *) ((FXProgressBar *) x));
}
static void *_p_FXShellTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *) ((FXShell *) x));
}
static void *_p_FXStatusLineTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXFrame *) ((FXStatusLine *) x));
}
static void *_p_FXSeparatorTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXFrame *) ((FXSeparator *) x));
}
static void *_p_FXHorizontalSeparatorTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXFrame *)(FXSeparator *) ((FXHorizontalSeparator *) x));
}
static void *_p_FXVerticalSeparatorTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXFrame *)(FXSeparator *) ((FXVerticalSeparator *) x));
}
static void *_p_FXTextFieldTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXFrame *) ((FXTextField *) x));
}
static void *_p_FXHeaderTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXFrame *) ((FXHeader *) x));
}
static void *_p_FXImageFrameTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXFrame *) ((FXImageFrame *) x));
}
static void *_p_FXSliderTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXFrame *) ((FXSlider *) x));
}
static void *_p_FXRealSliderTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXFrame *) ((FXRealSlider *) x));
}
static void *_p_FXShellTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *)  ((FXShell *) x));
}
static void *_p_FXRootWindowTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *)  ((FXRootWindow *) x));
}
static void *_p_FXPopupTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXShell *) ((FXPopup *) x));
}
static void *_p_FXTopWindowTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXShell *) ((FXTopWindow *) x));
}
static void *_p_FXMainWindowTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXShell *)(FXTopWindow *) ((FXMainWindow *) x));
}
static void *_p_FXHorizontalSeparatorTo_p_FXSeparator(void *x) {
    return (void *)((FXSeparator *)  ((FXHorizontalSeparator *) x));
}
static void *_p_FXVerticalSeparatorTo_p_FXSeparator(void *x) {
    return (void *)((FXSeparator *)  ((FXVerticalSeparator *) x));
}
static void *_p_FXFileStreamTo_p_FXStream(void *x) {
    return (void *)((FXStream *)  ((FXFileStream *) x));
}
static void *_p_FXMemoryStreamTo_p_FXStream(void *x) {
    return (void *)((FXStream *)  ((FXMemoryStream *) x));
}
static void *_p_FXFrameTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *) ((FXFrame *) x));
}
static void *_p_FXToolBarTabTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXFrame *) ((FXToolBarTab *) x));
}
static void *_p_FXColorBarTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXFrame *) ((FXColorBar *) x));
}
static void *_p_FXPopupTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXShell *) ((FXPopup *) x));
}
static void *_p_FXBitmapFrameTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXFrame *) ((FXBitmapFrame *) x));
}
static void *_p_FXDialTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXFrame *) ((FXDial *) x));
}
static void *_p_FXRulerTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXFrame *) ((FXRuler *) x));
}
static void *_p_FXArrowButtonTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXFrame *) ((FXArrowButton *) x));
}
static void *_p_FXMainWindowTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXShell *)(FXTopWindow *) ((FXMainWindow *) x));
}
static void *_p_FXTopWindowTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXShell *) ((FXTopWindow *) x));
}
static void *_p_FXRootWindowTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *) ((FXRootWindow *) x));
}
static void *_p_FXWindowTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *)  ((FXWindow *) x));
}
static void *_p_FXCompositeTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *) ((FXComposite *) x));
}
static void *_p_FXColorWheelTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXFrame *) ((FXColorWheel *) x));
}
static void *_p_FXColorWellTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXFrame *) ((FXColorWell *) x));
}
static void *_p_FXProgressBarTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXFrame *) ((FXProgressBar *) x));
}
static void *_p_FXShellTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *) ((FXShell *) x));
}
static void *_p_FXStatusLineTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXFrame *) ((FXStatusLine *) x));
}
static void *_p_FXSeparatorTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXFrame *) ((FXSeparator *) x));
}
static void *_p_FXHorizontalSeparatorTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXFrame *)(FXSeparator *) ((FXHorizontalSeparator *) x));
}
static void *_p_FXVerticalSeparatorTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXFrame *)(FXSeparator *) ((FXVerticalSeparator *) x));
}
static void *_p_FXTextFieldTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXFrame *) ((FXTextField *) x));
}
static void *_p_FXHeaderTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXFrame *) ((FXHeader *) x));
}
static void *_p_FXImageFrameTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXFrame *) ((FXImageFrame *) x));
}
static void *_p_FXSliderTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXFrame *) ((FXSlider *) x));
}
static void *_p_FXRealSliderTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXFrame *) ((FXRealSlider *) x));
}
static swig_type_info _swigt__p_FXFrame[] = {{"_p_FXFrame", 0, "FXFrame *", 0, 0, 0, 0},{"_p_FXToolBarTab", _p_FXToolBarTabTo_p_FXFrame, 0, 0, 0, 0, 0},{"_p_FXFrame", 0, 0, 0, 0, 0, 0},{"_p_FXColorBar", _p_FXColorBarTo_p_FXFrame, 0, 0, 0, 0, 0},{"_p_FXBitmapFrame", _p_FXBitmapFrameTo_p_FXFrame, 0, 0, 0, 0, 0},{"_p_FXRuler", _p_FXRulerTo_p_FXFrame, 0, 0, 0, 0, 0},{"_p_FXArrowButton", _p_FXArrowButtonTo_p_FXFrame, 0, 0, 0, 0, 0},{"_p_FXColorWheel", _p_FXColorWheelTo_p_FXFrame, 0, 0, 0, 0, 0},{"_p_FXProgressBar", _p_FXProgressBarTo_p_FXFrame, 0, 0, 0, 0, 0},{"_p_FXColorWell", _p_FXColorWellTo_p_FXFrame, 0, 0, 0, 0, 0},{"_p_FXStatusLine", _p_FXStatusLineTo_p_FXFrame, 0, 0, 0, 0, 0},{"_p_FXVerticalSeparator", _p_FXVerticalSeparatorTo_p_FXFrame, 0, 0, 0, 0, 0},{"_p_FXHorizontalSeparator", _p_FXHorizontalSeparatorTo_p_FXFrame, 0, 0, 0, 0, 0},{"_p_FXSeparator", _p_FXSeparatorTo_p_FXFrame, 0, 0, 0, 0, 0},{"_p_FXTextField", _p_FXTextFieldTo_p_FXFrame, 0, 0, 0, 0, 0},{"_p_FXHeader", _p_FXHeaderTo_p_FXFrame, 0, 0, 0, 0, 0},{"_p_FXImageFrame", _p_FXImageFrameTo_p_FXFrame, 0, 0, 0, 0, 0},{"_p_FXSlider", _p_FXSliderTo_p_FXFrame, 0, 0, 0, 0, 0},{"_p_FXRealSlider", _p_FXRealSliderTo_p_FXFrame, 0, 0, 0, 0, 0},{"_p_FXDial", _p_FXDialTo_p_FXFrame, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXToolBarTab[] = {{"_p_FXToolBarTab", 0, "FXToolBarTab *", 0, 0, 0, 0},{"_p_FXToolBarTab", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXColorBar[] = {{"_p_FXColorBar", 0, "FXColorBar *", 0, 0, 0, 0},{"_p_FXColorBar", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXObject[] = {{"_p_FXObject", 0, "FXObject *", 0, 0, 0, 0},{"_p_FXDict", _p_FXDictTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXDial", _p_FXDialTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXSettings", _p_FXSettingsTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXAccelTable", _p_FXAccelTableTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXComposite", _p_FXCompositeTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXRegistry", _p_FXRegistryTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXTextField", _p_FXTextFieldTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXId", _p_FXIdTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXArrowButton", _p_FXArrowButtonTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXIconDict", _p_FXIconDictTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXShell", _p_FXShellTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXPopup", _p_FXPopupTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXWindow", _p_FXWindowTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXRootWindow", _p_FXRootWindowTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXTopWindow", _p_FXTopWindowTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXMainWindow", _p_FXMainWindowTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXRuler", _p_FXRulerTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXRecentFiles", _p_FXRecentFilesTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXDocument", _p_FXDocumentTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXVerticalSeparator", _p_FXVerticalSeparatorTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXHorizontalSeparator", _p_FXHorizontalSeparatorTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXSeparator", _p_FXSeparatorTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXStatusLine", _p_FXStatusLineTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXObject", 0, 0, 0, 0, 0, 0},{"_p_FXStringDict", _p_FXStringDictTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXColorWheel", _p_FXColorWheelTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXBitmapFrame", _p_FXBitmapFrameTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXImageFrame", _p_FXImageFrameTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXFileDict", _p_FXFileDictTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXDebugTarget", _p_FXDebugTargetTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXDataTarget", _p_FXDataTargetTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXProgressBar", _p_FXProgressBarTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXGIFCursor", _p_FXGIFCursorTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXCURCursor", _p_FXCURCursorTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXCursor", _p_FXCursorTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXDrawable", _p_FXDrawableTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXDelegator", _p_FXDelegatorTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXHeader", _p_FXHeaderTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXApp", _p_FXAppTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXColorWell", _p_FXColorWellTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXHeaderItem", _p_FXHeaderItemTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXToolBarTab", _p_FXToolBarTabTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXFont", _p_FXFontTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXFrame", _p_FXFrameTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXRealSlider", _p_FXRealSliderTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXSlider", _p_FXSliderTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXVisual", _p_FXVisualTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXColorBar", _p_FXColorBarTo_p_FXObject, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXBitmapFrame[] = {{"_p_FXBitmapFrame", 0, "FXBitmapFrame *", 0, 0, 0, 0},{"_p_FXBitmapFrame", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXHeaderItem[] = {{"_p_FXHeaderItem", 0, "FXHeaderItem *", 0, 0, 0, 0},{"_p_FXHeaderItem", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXRuler[] = {{"_p_FXRuler", 0, "FXRuler *", 0, 0, 0, 0},{"_p_FXRuler", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXArrowButton[] = {{"_p_FXArrowButton", 0, "FXArrowButton *", 0, 0, 0, 0},{"_p_FXArrowButton", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXWindow[] = {{"_p_FXWindow", 0, "FXWindow *", 0, 0, 0, 0},{"_p_FXToolBarTab", _p_FXToolBarTabTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXFrame", _p_FXFrameTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXColorBar", _p_FXColorBarTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXBitmapFrame", _p_FXBitmapFrameTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXPopup", _p_FXPopupTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXRuler", _p_FXRulerTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXArrowButton", _p_FXArrowButtonTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXWindow", 0, 0, 0, 0, 0, 0},{"_p_FXRootWindow", _p_FXRootWindowTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXTopWindow", _p_FXTopWindowTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXMainWindow", _p_FXMainWindowTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXComposite", _p_FXCompositeTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXColorWheel", _p_FXColorWheelTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXProgressBar", _p_FXProgressBarTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXColorWell", _p_FXColorWellTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXStatusLine", _p_FXStatusLineTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXShell", _p_FXShellTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXVerticalSeparator", _p_FXVerticalSeparatorTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXHorizontalSeparator", _p_FXHorizontalSeparatorTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXSeparator", _p_FXSeparatorTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXTextField", _p_FXTextFieldTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXHeader", _p_FXHeaderTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXImageFrame", _p_FXImageFrameTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXSlider", _p_FXSliderTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXRealSlider", _p_FXRealSliderTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXDial", _p_FXDialTo_p_FXWindow, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXComposite[] = {{"_p_FXComposite", 0, "FXComposite *", 0, 0, 0, 0},{"_p_FXComposite", 0, 0, 0, 0, 0, 0},{"_p_FXShell", _p_FXShellTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXRootWindow", _p_FXRootWindowTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXPopup", _p_FXPopupTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXTopWindow", _p_FXTopWindowTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXMainWindow", _p_FXMainWindowTo_p_FXComposite, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXColorWheel[] = {{"_p_FXColorWheel", 0, "FXColorWheel *", 0, 0, 0, 0},{"_p_FXColorWheel", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXColorWell[] = {{"_p_FXColorWell", 0, "FXColorWell *", 0, 0, 0, 0},{"_p_FXColorWell", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXBitmap[] = {{"_p_FXBitmap", 0, "FXBitmap *", 0, 0, 0, 0},{"_p_FXBitmap", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXProgressBar[] = {{"_p_FXProgressBar", 0, "FXProgressBar *", 0, 0, 0, 0},{"_p_FXProgressBar", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXId[] = {{"_p_FXId", 0, "FXId *", 0, 0, 0, 0},{"_p_FXToolBarTab", _p_FXToolBarTabTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXFrame", _p_FXFrameTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXColorBar", _p_FXColorBarTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXBitmapFrame", _p_FXBitmapFrameTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXPopup", _p_FXPopupTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXRuler", _p_FXRulerTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXArrowButton", _p_FXArrowButtonTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXWindow", _p_FXWindowTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXRootWindow", _p_FXRootWindowTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXTopWindow", _p_FXTopWindowTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXMainWindow", _p_FXMainWindowTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXComposite", _p_FXCompositeTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXColorWheel", _p_FXColorWheelTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXProgressBar", _p_FXProgressBarTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXColorWell", _p_FXColorWellTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXId", 0, 0, 0, 0, 0, 0},{"_p_FXFont", _p_FXFontTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXStatusLine", _p_FXStatusLineTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXShell", _p_FXShellTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXVerticalSeparator", _p_FXVerticalSeparatorTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXHorizontalSeparator", _p_FXHorizontalSeparatorTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXSeparator", _p_FXSeparatorTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXTextField", _p_FXTextFieldTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXGIFCursor", _p_FXGIFCursorTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXCURCursor", _p_FXCURCursorTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXCursor", _p_FXCursorTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXDrawable", _p_FXDrawableTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXHeader", _p_FXHeaderTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXImageFrame", _p_FXImageFrameTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXVisual", _p_FXVisualTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXSlider", _p_FXSliderTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXRealSlider", _p_FXRealSliderTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXDial", _p_FXDialTo_p_FXId, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXFont[] = {{"_p_FXFont", 0, "FXFont *", 0, 0, 0, 0},{"_p_FXFont", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXStatusLine[] = {{"_p_FXStatusLine", 0, "FXStatusLine *", 0, 0, 0, 0},{"_p_FXStatusLine", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXSeparator[] = {{"_p_FXSeparator", 0, "FXSeparator *", 0, 0, 0, 0},{"_p_FXSeparator", 0, 0, 0, 0, 0, 0},{"_p_FXHorizontalSeparator", _p_FXHorizontalSeparatorTo_p_FXSeparator, 0, 0, 0, 0, 0},{"_p_FXVerticalSeparator", _p_FXVerticalSeparatorTo_p_FXSeparator, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXHorizontalSeparator[] = {{"_p_FXHorizontalSeparator", 0, "FXHorizontalSeparator *", 0, 0, 0, 0},{"_p_FXHorizontalSeparator", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXVerticalSeparator[] = {{"_p_FXVerticalSeparator", 0, "FXVerticalSeparator *", 0, 0, 0, 0},{"_p_FXVerticalSeparator", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXStream[] = {{"_p_FXStream", 0, "FXStream *", 0, 0, 0, 0},{"_p_FXFileStream", _p_FXFileStreamTo_p_FXStream, 0, 0, 0, 0, 0},{"_p_FXMemoryStream", _p_FXMemoryStreamTo_p_FXStream, 0, 0, 0, 0, 0},{"_p_FXStream", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXDrawable[] = {{"_p_FXDrawable", 0, "FXDrawable *", 0, 0, 0, 0},{"_p_FXToolBarTab", _p_FXToolBarTabTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXFrame", _p_FXFrameTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXColorBar", _p_FXColorBarTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXBitmapFrame", _p_FXBitmapFrameTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXPopup", _p_FXPopupTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXRuler", _p_FXRulerTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXArrowButton", _p_FXArrowButtonTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXWindow", _p_FXWindowTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXRootWindow", _p_FXRootWindowTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXTopWindow", _p_FXTopWindowTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXMainWindow", _p_FXMainWindowTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXComposite", _p_FXCompositeTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXColorWheel", _p_FXColorWheelTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXProgressBar", _p_FXProgressBarTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXColorWell", _p_FXColorWellTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXStatusLine", _p_FXStatusLineTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXShell", _p_FXShellTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXVerticalSeparator", _p_FXVerticalSeparatorTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXHorizontalSeparator", _p_FXHorizontalSeparatorTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXSeparator", _p_FXSeparatorTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXDrawable", 0, 0, 0, 0, 0, 0},{"_p_FXTextField", _p_FXTextFieldTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXHeader", _p_FXHeaderTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXImageFrame", _p_FXImageFrameTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXSlider", _p_FXSliderTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXRealSlider", _p_FXRealSliderTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXDial", _p_FXDialTo_p_FXDrawable, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXTextField[] = {{"_p_FXTextField", 0, "FXTextField *", 0, 0, 0, 0},{"_p_FXTextField", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXIcon[] = {{"_p_FXIcon", 0, "FXIcon *", 0, 0, 0, 0},{"_p_FXIcon", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXHeader[] = {{"_p_FXHeader", 0, "FXHeader *", 0, 0, 0, 0},{"_p_FXHeader", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXImageFrame[] = {{"_p_FXImageFrame", 0, "FXImageFrame *", 0, 0, 0, 0},{"_p_FXImageFrame", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXSlider[] = {{"_p_FXSlider", 0, "FXSlider *", 0, 0, 0, 0},{"_p_FXSlider", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXRealSlider[] = {{"_p_FXRealSlider", 0, "FXRealSlider *", 0, 0, 0, 0},{"_p_FXRealSlider", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXImage[] = {{"_p_FXImage", 0, "FXImage *", 0, 0, 0, 0},{"_p_FXImage", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXDial[] = {{"_p_FXDial", 0, "FXDial *", 0, 0, 0, 0},{"_p_FXDial", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};

static swig_type_info *swig_types_initial[] = {
_swigt__p_FXFrame, 
_swigt__p_FXToolBarTab, 
_swigt__p_FXColorBar, 
_swigt__p_FXObject, 
_swigt__p_FXBitmapFrame, 
_swigt__p_FXHeaderItem, 
_swigt__p_FXRuler, 
_swigt__p_FXArrowButton, 
_swigt__p_FXWindow, 
_swigt__p_FXComposite, 
_swigt__p_FXColorWheel, 
_swigt__p_FXColorWell, 
_swigt__p_FXBitmap, 
_swigt__p_FXProgressBar, 
_swigt__p_FXId, 
_swigt__p_FXFont, 
_swigt__p_FXStatusLine, 
_swigt__p_FXSeparator, 
_swigt__p_FXHorizontalSeparator, 
_swigt__p_FXVerticalSeparator, 
_swigt__p_FXStream, 
_swigt__p_FXDrawable, 
_swigt__p_FXTextField, 
_swigt__p_FXIcon, 
_swigt__p_FXHeader, 
_swigt__p_FXImageFrame, 
_swigt__p_FXSlider, 
_swigt__p_FXRealSlider, 
_swigt__p_FXImage, 
_swigt__p_FXDial, 
0
};


/* -------- TYPE CONVERSION AND EQUIVALENCE RULES (END) -------- */


#ifdef __cplusplus
extern "C"
#endif
SWIGEXPORT(void) Init_frames(void) {
    int i;
    
    SWIG_InitRuntime();
    
    for (i = 0; swig_types_initial[i]; i++) {
        swig_types[i] = SWIG_TypeRegister(swig_types_initial[i]);
        SWIG_define_class(swig_types[i]);
    }
    
    rb_define_const(mFox,"ARROW_NONE", INT2NUM(ARROW_NONE));
    rb_define_const(mFox,"ARROW_UP", INT2NUM(ARROW_UP));
    rb_define_const(mFox,"ARROW_DOWN", INT2NUM(ARROW_DOWN));
    rb_define_const(mFox,"ARROW_LEFT", INT2NUM(ARROW_LEFT));
    rb_define_const(mFox,"ARROW_RIGHT", INT2NUM(ARROW_RIGHT));
    rb_define_const(mFox,"ARROW_AUTO", INT2NUM(ARROW_AUTO));
    rb_define_const(mFox,"ARROW_REPEAT", INT2NUM(ARROW_REPEAT));
    rb_define_const(mFox,"ARROW_AUTOGRAY", INT2NUM(ARROW_AUTOGRAY));
    rb_define_const(mFox,"ARROW_AUTOHIDE", INT2NUM(ARROW_AUTOHIDE));
    rb_define_const(mFox,"ARROW_TOOLBAR", INT2NUM(ARROW_TOOLBAR));
    rb_define_const(mFox,"ARROW_NORMAL", INT2NUM(ARROW_NORMAL));
    
    cFXArrowButton.klass = rb_define_class_under(mFox, "FXArrowButton", ((swig_class *) SWIGTYPE_p_FXFrame->clientdata)->klass);
    SWIG_TypeClientData(SWIGTYPE_p_FXArrowButton, (void *) &cFXArrowButton);
    rb_define_alloc_func(cFXArrowButton.klass, _wrap_FXArrowButton_allocate);
    rb_define_method(cFXArrowButton.klass, "initialize", VALUEFUNC(_wrap_new_FXArrowButton), -1);
    rb_define_method(cFXArrowButton.klass, "onPaint", VALUEFUNC(_wrap_FXArrowButton_onPaint), -1);
    rb_define_method(cFXArrowButton.klass, "onUpdate", VALUEFUNC(_wrap_FXArrowButton_onUpdate), -1);
    rb_define_method(cFXArrowButton.klass, "onEnter", VALUEFUNC(_wrap_FXArrowButton_onEnter), -1);
    rb_define_method(cFXArrowButton.klass, "onLeave", VALUEFUNC(_wrap_FXArrowButton_onLeave), -1);
    rb_define_method(cFXArrowButton.klass, "onLeftBtnPress", VALUEFUNC(_wrap_FXArrowButton_onLeftBtnPress), -1);
    rb_define_method(cFXArrowButton.klass, "onLeftBtnRelease", VALUEFUNC(_wrap_FXArrowButton_onLeftBtnRelease), -1);
    rb_define_method(cFXArrowButton.klass, "onUngrabbed", VALUEFUNC(_wrap_FXArrowButton_onUngrabbed), -1);
    rb_define_method(cFXArrowButton.klass, "onRepeat", VALUEFUNC(_wrap_FXArrowButton_onRepeat), -1);
    rb_define_method(cFXArrowButton.klass, "onAuto", VALUEFUNC(_wrap_FXArrowButton_onAuto), -1);
    rb_define_method(cFXArrowButton.klass, "onKeyPress", VALUEFUNC(_wrap_FXArrowButton_onKeyPress), -1);
    rb_define_method(cFXArrowButton.klass, "onKeyRelease", VALUEFUNC(_wrap_FXArrowButton_onKeyRelease), -1);
    rb_define_method(cFXArrowButton.klass, "onHotKeyPress", VALUEFUNC(_wrap_FXArrowButton_onHotKeyPress), -1);
    rb_define_method(cFXArrowButton.klass, "onHotKeyRelease", VALUEFUNC(_wrap_FXArrowButton_onHotKeyRelease), -1);
    rb_define_method(cFXArrowButton.klass, "onCmdSetHelp", VALUEFUNC(_wrap_FXArrowButton_onCmdSetHelp), -1);
    rb_define_method(cFXArrowButton.klass, "onCmdGetHelp", VALUEFUNC(_wrap_FXArrowButton_onCmdGetHelp), -1);
    rb_define_method(cFXArrowButton.klass, "onCmdSetTip", VALUEFUNC(_wrap_FXArrowButton_onCmdSetTip), -1);
    rb_define_method(cFXArrowButton.klass, "onCmdGetTip", VALUEFUNC(_wrap_FXArrowButton_onCmdGetTip), -1);
    rb_define_method(cFXArrowButton.klass, "onQueryHelp", VALUEFUNC(_wrap_FXArrowButton_onQueryHelp), -1);
    rb_define_method(cFXArrowButton.klass, "onQueryTip", VALUEFUNC(_wrap_FXArrowButton_onQueryTip), -1);
    rb_define_const(cFXArrowButton.klass,"ID_REPEAT", INT2NUM(FXArrowButton::ID_REPEAT));
    rb_define_const(cFXArrowButton.klass,"ID_AUTO", INT2NUM(FXArrowButton::ID_AUTO));
    rb_define_const(cFXArrowButton.klass,"ID_LAST", INT2NUM(FXArrowButton::ID_LAST));
    rb_define_method(cFXArrowButton.klass, "setState", VALUEFUNC(_wrap_FXArrowButton_setState), -1);
    rb_define_method(cFXArrowButton.klass, "getState", VALUEFUNC(_wrap_FXArrowButton_getState), -1);
    rb_define_method(cFXArrowButton.klass, "setHelpText", VALUEFUNC(_wrap_FXArrowButton_setHelpText), -1);
    rb_define_method(cFXArrowButton.klass, "getHelpText", VALUEFUNC(_wrap_FXArrowButton_getHelpText), -1);
    rb_define_method(cFXArrowButton.klass, "setTipText", VALUEFUNC(_wrap_FXArrowButton_setTipText), -1);
    rb_define_method(cFXArrowButton.klass, "getTipText", VALUEFUNC(_wrap_FXArrowButton_getTipText), -1);
    rb_define_method(cFXArrowButton.klass, "setArrowStyle", VALUEFUNC(_wrap_FXArrowButton_setArrowStyle), -1);
    rb_define_method(cFXArrowButton.klass, "getArrowStyle", VALUEFUNC(_wrap_FXArrowButton_getArrowStyle), -1);
    rb_define_method(cFXArrowButton.klass, "setArrowSize", VALUEFUNC(_wrap_FXArrowButton_setArrowSize), -1);
    rb_define_method(cFXArrowButton.klass, "getArrowSize", VALUEFUNC(_wrap_FXArrowButton_getArrowSize), -1);
    rb_define_method(cFXArrowButton.klass, "setJustify", VALUEFUNC(_wrap_FXArrowButton_setJustify), -1);
    rb_define_method(cFXArrowButton.klass, "getJustify", VALUEFUNC(_wrap_FXArrowButton_getJustify), -1);
    rb_define_method(cFXArrowButton.klass, "getArrowColor", VALUEFUNC(_wrap_FXArrowButton_getArrowColor), -1);
    rb_define_method(cFXArrowButton.klass, "setArrowColor", VALUEFUNC(_wrap_FXArrowButton_setArrowColor), -1);
    rb_define_method(cFXArrowButton.klass, "save", VALUEFUNC(_wrap_FXArrowButton_save), -1);
    rb_define_method(cFXArrowButton.klass, "load", VALUEFUNC(_wrap_FXArrowButton_load), -1);
    rb_define_method(cFXArrowButton.klass, "create", VALUEFUNC(_wrap_FXArrowButton_create), -1);
    rb_define_method(cFXArrowButton.klass, "detach", VALUEFUNC(_wrap_FXArrowButton_detach), -1);
    rb_define_method(cFXArrowButton.klass, "destroy", VALUEFUNC(_wrap_FXArrowButton_destroy), -1);
    rb_define_method(cFXArrowButton.klass, "resize", VALUEFUNC(_wrap_FXArrowButton_resize), -1);
    rb_define_method(cFXArrowButton.klass, "getDefaultWidth", VALUEFUNC(_wrap_FXArrowButton_getDefaultWidth), -1);
    rb_define_method(cFXArrowButton.klass, "getDefaultHeight", VALUEFUNC(_wrap_FXArrowButton_getDefaultHeight), -1);
    rb_define_method(cFXArrowButton.klass, "getWidthForHeight", VALUEFUNC(_wrap_FXArrowButton_getWidthForHeight), -1);
    rb_define_method(cFXArrowButton.klass, "getHeightForWidth", VALUEFUNC(_wrap_FXArrowButton_getHeightForWidth), -1);
    rb_define_method(cFXArrowButton.klass, "canFocus", VALUEFUNC(_wrap_FXArrowButton_canFocus), -1);
    rb_define_method(cFXArrowButton.klass, "setFocus", VALUEFUNC(_wrap_FXArrowButton_setFocus), -1);
    rb_define_method(cFXArrowButton.klass, "killFocus", VALUEFUNC(_wrap_FXArrowButton_killFocus), -1);
    rb_define_method(cFXArrowButton.klass, "setDefault", VALUEFUNC(_wrap_FXArrowButton_setDefault), -1);
    rb_define_method(cFXArrowButton.klass, "enable", VALUEFUNC(_wrap_FXArrowButton_enable), -1);
    rb_define_method(cFXArrowButton.klass, "disable", VALUEFUNC(_wrap_FXArrowButton_disable), -1);
    rb_define_method(cFXArrowButton.klass, "raiseWindow", VALUEFUNC(_wrap_FXArrowButton_raiseWindow), -1);
    rb_define_method(cFXArrowButton.klass, "lower", VALUEFUNC(_wrap_FXArrowButton_lower), -1);
    rb_define_method(cFXArrowButton.klass, "move", VALUEFUNC(_wrap_FXArrowButton_move), -1);
    rb_define_method(cFXArrowButton.klass, "position", VALUEFUNC(_wrap_FXArrowButton_position), -1);
    rb_define_method(cFXArrowButton.klass, "layout", VALUEFUNC(_wrap_FXArrowButton_layout), -1);
    rb_define_method(cFXArrowButton.klass, "recalc", VALUEFUNC(_wrap_FXArrowButton_recalc), -1);
    rb_define_method(cFXArrowButton.klass, "reparent", VALUEFUNC(_wrap_FXArrowButton_reparent), -1);
    rb_define_method(cFXArrowButton.klass, "show", VALUEFUNC(_wrap_FXArrowButton_show), -1);
    rb_define_method(cFXArrowButton.klass, "hide", VALUEFUNC(_wrap_FXArrowButton_hide), -1);
    rb_define_method(cFXArrowButton.klass, "isComposite", VALUEFUNC(_wrap_FXArrowButton_isComposite), -1);
    rb_define_method(cFXArrowButton.klass, "contains", VALUEFUNC(_wrap_FXArrowButton_contains), -1);
    rb_define_method(cFXArrowButton.klass, "doesSaveUnder", VALUEFUNC(_wrap_FXArrowButton_doesSaveUnder), -1);
    rb_define_method(cFXArrowButton.klass, "setBackColor", VALUEFUNC(_wrap_FXArrowButton_setBackColor), -1);
    cFXArrowButton.mark = (void (*)(void *)) FXRbArrowButton::markfunc;
    cFXArrowButton.destroy = (void (*)(void *)) FXRbObject::freefunc;
    rb_define_const(mFox,"COLORBAR_HORIZONTAL", INT2NUM(COLORBAR_HORIZONTAL));
    rb_define_const(mFox,"COLORBAR_VERTICAL", INT2NUM(COLORBAR_VERTICAL));
    
    cFXColorBar.klass = rb_define_class_under(mFox, "FXColorBar", ((swig_class *) SWIGTYPE_p_FXFrame->clientdata)->klass);
    SWIG_TypeClientData(SWIGTYPE_p_FXColorBar, (void *) &cFXColorBar);
    rb_define_alloc_func(cFXColorBar.klass, _wrap_FXColorBar_allocate);
    rb_define_method(cFXColorBar.klass, "initialize", VALUEFUNC(_wrap_new_FXColorBar), -1);
    rb_define_method(cFXColorBar.klass, "onPaint", VALUEFUNC(_wrap_FXColorBar_onPaint), -1);
    rb_define_method(cFXColorBar.klass, "onLeftBtnPress", VALUEFUNC(_wrap_FXColorBar_onLeftBtnPress), -1);
    rb_define_method(cFXColorBar.klass, "onLeftBtnRelease", VALUEFUNC(_wrap_FXColorBar_onLeftBtnRelease), -1);
    rb_define_method(cFXColorBar.klass, "onMotion", VALUEFUNC(_wrap_FXColorBar_onMotion), -1);
    rb_define_method(cFXColorBar.klass, "onCmdSetHelp", VALUEFUNC(_wrap_FXColorBar_onCmdSetHelp), -1);
    rb_define_method(cFXColorBar.klass, "onCmdGetHelp", VALUEFUNC(_wrap_FXColorBar_onCmdGetHelp), -1);
    rb_define_method(cFXColorBar.klass, "onCmdSetTip", VALUEFUNC(_wrap_FXColorBar_onCmdSetTip), -1);
    rb_define_method(cFXColorBar.klass, "onCmdGetTip", VALUEFUNC(_wrap_FXColorBar_onCmdGetTip), -1);
    rb_define_method(cFXColorBar.klass, "onQueryHelp", VALUEFUNC(_wrap_FXColorBar_onQueryHelp), -1);
    rb_define_method(cFXColorBar.klass, "onQueryTip", VALUEFUNC(_wrap_FXColorBar_onQueryTip), -1);
    rb_define_method(cFXColorBar.klass, "setHue", VALUEFUNC(_wrap_FXColorBar_setHue), -1);
    rb_define_method(cFXColorBar.klass, "getHue", VALUEFUNC(_wrap_FXColorBar_getHue), -1);
    rb_define_method(cFXColorBar.klass, "setSat", VALUEFUNC(_wrap_FXColorBar_setSat), -1);
    rb_define_method(cFXColorBar.klass, "getSat", VALUEFUNC(_wrap_FXColorBar_getSat), -1);
    rb_define_method(cFXColorBar.klass, "setVal", VALUEFUNC(_wrap_FXColorBar_setVal), -1);
    rb_define_method(cFXColorBar.klass, "getVal", VALUEFUNC(_wrap_FXColorBar_getVal), -1);
    rb_define_method(cFXColorBar.klass, "getBarStyle", VALUEFUNC(_wrap_FXColorBar_getBarStyle), -1);
    rb_define_method(cFXColorBar.klass, "setBarStyle", VALUEFUNC(_wrap_FXColorBar_setBarStyle), -1);
    rb_define_method(cFXColorBar.klass, "setHelpText", VALUEFUNC(_wrap_FXColorBar_setHelpText), -1);
    rb_define_method(cFXColorBar.klass, "getHelpText", VALUEFUNC(_wrap_FXColorBar_getHelpText), -1);
    rb_define_method(cFXColorBar.klass, "setTipText", VALUEFUNC(_wrap_FXColorBar_setTipText), -1);
    rb_define_method(cFXColorBar.klass, "getTipText", VALUEFUNC(_wrap_FXColorBar_getTipText), -1);
    rb_define_method(cFXColorBar.klass, "save", VALUEFUNC(_wrap_FXColorBar_save), -1);
    rb_define_method(cFXColorBar.klass, "load", VALUEFUNC(_wrap_FXColorBar_load), -1);
    rb_define_method(cFXColorBar.klass, "create", VALUEFUNC(_wrap_FXColorBar_create), -1);
    rb_define_method(cFXColorBar.klass, "detach", VALUEFUNC(_wrap_FXColorBar_detach), -1);
    rb_define_method(cFXColorBar.klass, "destroy", VALUEFUNC(_wrap_FXColorBar_destroy), -1);
    rb_define_method(cFXColorBar.klass, "resize", VALUEFUNC(_wrap_FXColorBar_resize), -1);
    rb_define_method(cFXColorBar.klass, "getDefaultWidth", VALUEFUNC(_wrap_FXColorBar_getDefaultWidth), -1);
    rb_define_method(cFXColorBar.klass, "getDefaultHeight", VALUEFUNC(_wrap_FXColorBar_getDefaultHeight), -1);
    rb_define_method(cFXColorBar.klass, "getWidthForHeight", VALUEFUNC(_wrap_FXColorBar_getWidthForHeight), -1);
    rb_define_method(cFXColorBar.klass, "getHeightForWidth", VALUEFUNC(_wrap_FXColorBar_getHeightForWidth), -1);
    rb_define_method(cFXColorBar.klass, "canFocus", VALUEFUNC(_wrap_FXColorBar_canFocus), -1);
    rb_define_method(cFXColorBar.klass, "setFocus", VALUEFUNC(_wrap_FXColorBar_setFocus), -1);
    rb_define_method(cFXColorBar.klass, "killFocus", VALUEFUNC(_wrap_FXColorBar_killFocus), -1);
    rb_define_method(cFXColorBar.klass, "setDefault", VALUEFUNC(_wrap_FXColorBar_setDefault), -1);
    rb_define_method(cFXColorBar.klass, "enable", VALUEFUNC(_wrap_FXColorBar_enable), -1);
    rb_define_method(cFXColorBar.klass, "disable", VALUEFUNC(_wrap_FXColorBar_disable), -1);
    rb_define_method(cFXColorBar.klass, "raiseWindow", VALUEFUNC(_wrap_FXColorBar_raiseWindow), -1);
    rb_define_method(cFXColorBar.klass, "lower", VALUEFUNC(_wrap_FXColorBar_lower), -1);
    rb_define_method(cFXColorBar.klass, "move", VALUEFUNC(_wrap_FXColorBar_move), -1);
    rb_define_method(cFXColorBar.klass, "position", VALUEFUNC(_wrap_FXColorBar_position), -1);
    rb_define_method(cFXColorBar.klass, "layout", VALUEFUNC(_wrap_FXColorBar_layout), -1);
    rb_define_method(cFXColorBar.klass, "recalc", VALUEFUNC(_wrap_FXColorBar_recalc), -1);
    rb_define_method(cFXColorBar.klass, "reparent", VALUEFUNC(_wrap_FXColorBar_reparent), -1);
    rb_define_method(cFXColorBar.klass, "show", VALUEFUNC(_wrap_FXColorBar_show), -1);
    rb_define_method(cFXColorBar.klass, "hide", VALUEFUNC(_wrap_FXColorBar_hide), -1);
    rb_define_method(cFXColorBar.klass, "isComposite", VALUEFUNC(_wrap_FXColorBar_isComposite), -1);
    rb_define_method(cFXColorBar.klass, "contains", VALUEFUNC(_wrap_FXColorBar_contains), -1);
    rb_define_method(cFXColorBar.klass, "doesSaveUnder", VALUEFUNC(_wrap_FXColorBar_doesSaveUnder), -1);
    rb_define_method(cFXColorBar.klass, "setBackColor", VALUEFUNC(_wrap_FXColorBar_setBackColor), -1);
    cFXColorBar.mark = (void (*)(void *)) FXRbColorBar::markfunc;
    cFXColorBar.destroy = (void (*)(void *)) FXRbObject::freefunc;
    rb_define_const(mFox,"COLORWELL_OPAQUEONLY", INT2NUM(COLORWELL_OPAQUEONLY));
    rb_define_const(mFox,"COLORWELL_SOURCEONLY", INT2NUM(COLORWELL_SOURCEONLY));
    rb_define_const(mFox,"COLORWELL_NORMAL", INT2NUM(COLORWELL_NORMAL));
    
    cFXColorWell.klass = rb_define_class_under(mFox, "FXColorWell", ((swig_class *) SWIGTYPE_p_FXFrame->clientdata)->klass);
    SWIG_TypeClientData(SWIGTYPE_p_FXColorWell, (void *) &cFXColorWell);
    rb_define_alloc_func(cFXColorWell.klass, _wrap_FXColorWell_allocate);
    rb_define_method(cFXColorWell.klass, "initialize", VALUEFUNC(_wrap_new_FXColorWell), -1);
    rb_define_method(cFXColorWell.klass, "onPaint", VALUEFUNC(_wrap_FXColorWell_onPaint), -1);
    rb_define_method(cFXColorWell.klass, "onLeftBtnPress", VALUEFUNC(_wrap_FXColorWell_onLeftBtnPress), -1);
    rb_define_method(cFXColorWell.klass, "onLeftBtnRelease", VALUEFUNC(_wrap_FXColorWell_onLeftBtnRelease), -1);
    rb_define_method(cFXColorWell.klass, "onMiddleBtnPress", VALUEFUNC(_wrap_FXColorWell_onMiddleBtnPress), -1);
    rb_define_method(cFXColorWell.klass, "onMiddleBtnRelease", VALUEFUNC(_wrap_FXColorWell_onMiddleBtnRelease), -1);
    rb_define_method(cFXColorWell.klass, "onKeyPress", VALUEFUNC(_wrap_FXColorWell_onKeyPress), -1);
    rb_define_method(cFXColorWell.klass, "onKeyRelease", VALUEFUNC(_wrap_FXColorWell_onKeyRelease), -1);
    rb_define_method(cFXColorWell.klass, "onUngrabbed", VALUEFUNC(_wrap_FXColorWell_onUngrabbed), -1);
    rb_define_method(cFXColorWell.klass, "onMotion", VALUEFUNC(_wrap_FXColorWell_onMotion), -1);
    rb_define_method(cFXColorWell.klass, "onBeginDrag", VALUEFUNC(_wrap_FXColorWell_onBeginDrag), -1);
    rb_define_method(cFXColorWell.klass, "onEndDrag", VALUEFUNC(_wrap_FXColorWell_onEndDrag), -1);
    rb_define_method(cFXColorWell.klass, "onDragged", VALUEFUNC(_wrap_FXColorWell_onDragged), -1);
    rb_define_method(cFXColorWell.klass, "onFocusIn", VALUEFUNC(_wrap_FXColorWell_onFocusIn), -1);
    rb_define_method(cFXColorWell.klass, "onFocusOut", VALUEFUNC(_wrap_FXColorWell_onFocusOut), -1);
    rb_define_method(cFXColorWell.klass, "onDNDEnter", VALUEFUNC(_wrap_FXColorWell_onDNDEnter), -1);
    rb_define_method(cFXColorWell.klass, "onDNDLeave", VALUEFUNC(_wrap_FXColorWell_onDNDLeave), -1);
    rb_define_method(cFXColorWell.klass, "onDNDMotion", VALUEFUNC(_wrap_FXColorWell_onDNDMotion), -1);
    rb_define_method(cFXColorWell.klass, "onDNDDrop", VALUEFUNC(_wrap_FXColorWell_onDNDDrop), -1);
    rb_define_method(cFXColorWell.klass, "onDNDRequest", VALUEFUNC(_wrap_FXColorWell_onDNDRequest), -1);
    rb_define_method(cFXColorWell.klass, "onSelectionLost", VALUEFUNC(_wrap_FXColorWell_onSelectionLost), -1);
    rb_define_method(cFXColorWell.klass, "onSelectionGained", VALUEFUNC(_wrap_FXColorWell_onSelectionGained), -1);
    rb_define_method(cFXColorWell.klass, "onSelectionRequest", VALUEFUNC(_wrap_FXColorWell_onSelectionRequest), -1);
    rb_define_method(cFXColorWell.klass, "onChanged", VALUEFUNC(_wrap_FXColorWell_onChanged), -1);
    rb_define_method(cFXColorWell.klass, "onCommand", VALUEFUNC(_wrap_FXColorWell_onCommand), -1);
    rb_define_method(cFXColorWell.klass, "onClicked", VALUEFUNC(_wrap_FXColorWell_onClicked), -1);
    rb_define_method(cFXColorWell.klass, "onDoubleClicked", VALUEFUNC(_wrap_FXColorWell_onDoubleClicked), -1);
    rb_define_method(cFXColorWell.klass, "onTripleClicked", VALUEFUNC(_wrap_FXColorWell_onTripleClicked), -1);
    rb_define_method(cFXColorWell.klass, "onCmdSetValue", VALUEFUNC(_wrap_FXColorWell_onCmdSetValue), -1);
    rb_define_method(cFXColorWell.klass, "onCmdSetIntValue", VALUEFUNC(_wrap_FXColorWell_onCmdSetIntValue), -1);
    rb_define_method(cFXColorWell.klass, "onCmdGetIntValue", VALUEFUNC(_wrap_FXColorWell_onCmdGetIntValue), -1);
    rb_define_method(cFXColorWell.klass, "onCmdColorWell", VALUEFUNC(_wrap_FXColorWell_onCmdColorWell), -1);
    rb_define_method(cFXColorWell.klass, "onChgColorWell", VALUEFUNC(_wrap_FXColorWell_onChgColorWell), -1);
    rb_define_method(cFXColorWell.klass, "onCmdSetHelp", VALUEFUNC(_wrap_FXColorWell_onCmdSetHelp), -1);
    rb_define_method(cFXColorWell.klass, "onCmdGetHelp", VALUEFUNC(_wrap_FXColorWell_onCmdGetHelp), -1);
    rb_define_method(cFXColorWell.klass, "onCmdSetTip", VALUEFUNC(_wrap_FXColorWell_onCmdSetTip), -1);
    rb_define_method(cFXColorWell.klass, "onCmdGetTip", VALUEFUNC(_wrap_FXColorWell_onCmdGetTip), -1);
    rb_define_method(cFXColorWell.klass, "onQueryHelp", VALUEFUNC(_wrap_FXColorWell_onQueryHelp), -1);
    rb_define_method(cFXColorWell.klass, "onQueryTip", VALUEFUNC(_wrap_FXColorWell_onQueryTip), -1);
    rb_define_const(cFXColorWell.klass,"ID_COLORDIALOG", INT2NUM(FXColorWell::ID_COLORDIALOG));
    rb_define_const(cFXColorWell.klass,"ID_LAST", INT2NUM(FXColorWell::ID_LAST));
    rb_define_method(cFXColorWell.klass, "setRGBA", VALUEFUNC(_wrap_FXColorWell_setRGBA), -1);
    rb_define_method(cFXColorWell.klass, "getRGBA", VALUEFUNC(_wrap_FXColorWell_getRGBA), -1);
    rb_define_method(cFXColorWell.klass, "setHelpText", VALUEFUNC(_wrap_FXColorWell_setHelpText), -1);
    rb_define_method(cFXColorWell.klass, "getHelpText", VALUEFUNC(_wrap_FXColorWell_getHelpText), -1);
    rb_define_method(cFXColorWell.klass, "setTipText", VALUEFUNC(_wrap_FXColorWell_setTipText), -1);
    rb_define_method(cFXColorWell.klass, "getTipText", VALUEFUNC(_wrap_FXColorWell_getTipText), -1);
    rb_define_method(cFXColorWell.klass, "isOpaqueOnly", VALUEFUNC(_wrap_FXColorWell_isOpaqueOnly), -1);
    rb_define_method(cFXColorWell.klass, "setOpaqueOnly", VALUEFUNC(_wrap_FXColorWell_setOpaqueOnly), -1);
    rb_define_method(cFXColorWell.klass, "save", VALUEFUNC(_wrap_FXColorWell_save), -1);
    rb_define_method(cFXColorWell.klass, "load", VALUEFUNC(_wrap_FXColorWell_load), -1);
    rb_define_method(cFXColorWell.klass, "create", VALUEFUNC(_wrap_FXColorWell_create), -1);
    rb_define_method(cFXColorWell.klass, "detach", VALUEFUNC(_wrap_FXColorWell_detach), -1);
    rb_define_method(cFXColorWell.klass, "destroy", VALUEFUNC(_wrap_FXColorWell_destroy), -1);
    rb_define_method(cFXColorWell.klass, "resize", VALUEFUNC(_wrap_FXColorWell_resize), -1);
    rb_define_method(cFXColorWell.klass, "getDefaultWidth", VALUEFUNC(_wrap_FXColorWell_getDefaultWidth), -1);
    rb_define_method(cFXColorWell.klass, "getDefaultHeight", VALUEFUNC(_wrap_FXColorWell_getDefaultHeight), -1);
    rb_define_method(cFXColorWell.klass, "getWidthForHeight", VALUEFUNC(_wrap_FXColorWell_getWidthForHeight), -1);
    rb_define_method(cFXColorWell.klass, "getHeightForWidth", VALUEFUNC(_wrap_FXColorWell_getHeightForWidth), -1);
    rb_define_method(cFXColorWell.klass, "canFocus", VALUEFUNC(_wrap_FXColorWell_canFocus), -1);
    rb_define_method(cFXColorWell.klass, "setFocus", VALUEFUNC(_wrap_FXColorWell_setFocus), -1);
    rb_define_method(cFXColorWell.klass, "killFocus", VALUEFUNC(_wrap_FXColorWell_killFocus), -1);
    rb_define_method(cFXColorWell.klass, "setDefault", VALUEFUNC(_wrap_FXColorWell_setDefault), -1);
    rb_define_method(cFXColorWell.klass, "enable", VALUEFUNC(_wrap_FXColorWell_enable), -1);
    rb_define_method(cFXColorWell.klass, "disable", VALUEFUNC(_wrap_FXColorWell_disable), -1);
    rb_define_method(cFXColorWell.klass, "raiseWindow", VALUEFUNC(_wrap_FXColorWell_raiseWindow), -1);
    rb_define_method(cFXColorWell.klass, "lower", VALUEFUNC(_wrap_FXColorWell_lower), -1);
    rb_define_method(cFXColorWell.klass, "move", VALUEFUNC(_wrap_FXColorWell_move), -1);
    rb_define_method(cFXColorWell.klass, "position", VALUEFUNC(_wrap_FXColorWell_position), -1);
    rb_define_method(cFXColorWell.klass, "layout", VALUEFUNC(_wrap_FXColorWell_layout), -1);
    rb_define_method(cFXColorWell.klass, "recalc", VALUEFUNC(_wrap_FXColorWell_recalc), -1);
    rb_define_method(cFXColorWell.klass, "reparent", VALUEFUNC(_wrap_FXColorWell_reparent), -1);
    rb_define_method(cFXColorWell.klass, "show", VALUEFUNC(_wrap_FXColorWell_show), -1);
    rb_define_method(cFXColorWell.klass, "hide", VALUEFUNC(_wrap_FXColorWell_hide), -1);
    rb_define_method(cFXColorWell.klass, "isComposite", VALUEFUNC(_wrap_FXColorWell_isComposite), -1);
    rb_define_method(cFXColorWell.klass, "contains", VALUEFUNC(_wrap_FXColorWell_contains), -1);
    rb_define_method(cFXColorWell.klass, "doesSaveUnder", VALUEFUNC(_wrap_FXColorWell_doesSaveUnder), -1);
    rb_define_method(cFXColorWell.klass, "setBackColor", VALUEFUNC(_wrap_FXColorWell_setBackColor), -1);
    cFXColorWell.mark = (void (*)(void *)) FXRbColorWell::markfunc;
    cFXColorWell.destroy = (void (*)(void *)) FXRbObject::freefunc;
    
    cFXColorWheel.klass = rb_define_class_under(mFox, "FXColorWheel", ((swig_class *) SWIGTYPE_p_FXFrame->clientdata)->klass);
    SWIG_TypeClientData(SWIGTYPE_p_FXColorWheel, (void *) &cFXColorWheel);
    rb_define_alloc_func(cFXColorWheel.klass, _wrap_FXColorWheel_allocate);
    rb_define_method(cFXColorWheel.klass, "initialize", VALUEFUNC(_wrap_new_FXColorWheel), -1);
    rb_define_method(cFXColorWheel.klass, "onPaint", VALUEFUNC(_wrap_FXColorWheel_onPaint), -1);
    rb_define_method(cFXColorWheel.klass, "onLeftBtnPress", VALUEFUNC(_wrap_FXColorWheel_onLeftBtnPress), -1);
    rb_define_method(cFXColorWheel.klass, "onLeftBtnRelease", VALUEFUNC(_wrap_FXColorWheel_onLeftBtnRelease), -1);
    rb_define_method(cFXColorWheel.klass, "onMotion", VALUEFUNC(_wrap_FXColorWheel_onMotion), -1);
    rb_define_method(cFXColorWheel.klass, "onMouseWheel", VALUEFUNC(_wrap_FXColorWheel_onMouseWheel), -1);
    rb_define_method(cFXColorWheel.klass, "onCmdSetHelp", VALUEFUNC(_wrap_FXColorWheel_onCmdSetHelp), -1);
    rb_define_method(cFXColorWheel.klass, "onCmdGetHelp", VALUEFUNC(_wrap_FXColorWheel_onCmdGetHelp), -1);
    rb_define_method(cFXColorWheel.klass, "onCmdSetTip", VALUEFUNC(_wrap_FXColorWheel_onCmdSetTip), -1);
    rb_define_method(cFXColorWheel.klass, "onCmdGetTip", VALUEFUNC(_wrap_FXColorWheel_onCmdGetTip), -1);
    rb_define_method(cFXColorWheel.klass, "onQueryHelp", VALUEFUNC(_wrap_FXColorWheel_onQueryHelp), -1);
    rb_define_method(cFXColorWheel.klass, "onQueryTip", VALUEFUNC(_wrap_FXColorWheel_onQueryTip), -1);
    rb_define_method(cFXColorWheel.klass, "setHue", VALUEFUNC(_wrap_FXColorWheel_setHue), -1);
    rb_define_method(cFXColorWheel.klass, "getHue", VALUEFUNC(_wrap_FXColorWheel_getHue), -1);
    rb_define_method(cFXColorWheel.klass, "setSat", VALUEFUNC(_wrap_FXColorWheel_setSat), -1);
    rb_define_method(cFXColorWheel.klass, "getSat", VALUEFUNC(_wrap_FXColorWheel_getSat), -1);
    rb_define_method(cFXColorWheel.klass, "setVal", VALUEFUNC(_wrap_FXColorWheel_setVal), -1);
    rb_define_method(cFXColorWheel.klass, "getVal", VALUEFUNC(_wrap_FXColorWheel_getVal), -1);
    rb_define_method(cFXColorWheel.klass, "setHelpText", VALUEFUNC(_wrap_FXColorWheel_setHelpText), -1);
    rb_define_method(cFXColorWheel.klass, "getHelpText", VALUEFUNC(_wrap_FXColorWheel_getHelpText), -1);
    rb_define_method(cFXColorWheel.klass, "setTipText", VALUEFUNC(_wrap_FXColorWheel_setTipText), -1);
    rb_define_method(cFXColorWheel.klass, "getTipText", VALUEFUNC(_wrap_FXColorWheel_getTipText), -1);
    rb_define_method(cFXColorWheel.klass, "save", VALUEFUNC(_wrap_FXColorWheel_save), -1);
    rb_define_method(cFXColorWheel.klass, "load", VALUEFUNC(_wrap_FXColorWheel_load), -1);
    rb_define_method(cFXColorWheel.klass, "create", VALUEFUNC(_wrap_FXColorWheel_create), -1);
    rb_define_method(cFXColorWheel.klass, "detach", VALUEFUNC(_wrap_FXColorWheel_detach), -1);
    rb_define_method(cFXColorWheel.klass, "destroy", VALUEFUNC(_wrap_FXColorWheel_destroy), -1);
    rb_define_method(cFXColorWheel.klass, "resize", VALUEFUNC(_wrap_FXColorWheel_resize), -1);
    rb_define_method(cFXColorWheel.klass, "getDefaultWidth", VALUEFUNC(_wrap_FXColorWheel_getDefaultWidth), -1);
    rb_define_method(cFXColorWheel.klass, "getDefaultHeight", VALUEFUNC(_wrap_FXColorWheel_getDefaultHeight), -1);
    rb_define_method(cFXColorWheel.klass, "getWidthForHeight", VALUEFUNC(_wrap_FXColorWheel_getWidthForHeight), -1);
    rb_define_method(cFXColorWheel.klass, "getHeightForWidth", VALUEFUNC(_wrap_FXColorWheel_getHeightForWidth), -1);
    rb_define_method(cFXColorWheel.klass, "canFocus", VALUEFUNC(_wrap_FXColorWheel_canFocus), -1);
    rb_define_method(cFXColorWheel.klass, "setFocus", VALUEFUNC(_wrap_FXColorWheel_setFocus), -1);
    rb_define_method(cFXColorWheel.klass, "killFocus", VALUEFUNC(_wrap_FXColorWheel_killFocus), -1);
    rb_define_method(cFXColorWheel.klass, "setDefault", VALUEFUNC(_wrap_FXColorWheel_setDefault), -1);
    rb_define_method(cFXColorWheel.klass, "enable", VALUEFUNC(_wrap_FXColorWheel_enable), -1);
    rb_define_method(cFXColorWheel.klass, "disable", VALUEFUNC(_wrap_FXColorWheel_disable), -1);
    rb_define_method(cFXColorWheel.klass, "raiseWindow", VALUEFUNC(_wrap_FXColorWheel_raiseWindow), -1);
    rb_define_method(cFXColorWheel.klass, "lower", VALUEFUNC(_wrap_FXColorWheel_lower), -1);
    rb_define_method(cFXColorWheel.klass, "move", VALUEFUNC(_wrap_FXColorWheel_move), -1);
    rb_define_method(cFXColorWheel.klass, "position", VALUEFUNC(_wrap_FXColorWheel_position), -1);
    rb_define_method(cFXColorWheel.klass, "layout", VALUEFUNC(_wrap_FXColorWheel_layout), -1);
    rb_define_method(cFXColorWheel.klass, "recalc", VALUEFUNC(_wrap_FXColorWheel_recalc), -1);
    rb_define_method(cFXColorWheel.klass, "reparent", VALUEFUNC(_wrap_FXColorWheel_reparent), -1);
    rb_define_method(cFXColorWheel.klass, "show", VALUEFUNC(_wrap_FXColorWheel_show), -1);
    rb_define_method(cFXColorWheel.klass, "hide", VALUEFUNC(_wrap_FXColorWheel_hide), -1);
    rb_define_method(cFXColorWheel.klass, "isComposite", VALUEFUNC(_wrap_FXColorWheel_isComposite), -1);
    rb_define_method(cFXColorWheel.klass, "contains", VALUEFUNC(_wrap_FXColorWheel_contains), -1);
    rb_define_method(cFXColorWheel.klass, "doesSaveUnder", VALUEFUNC(_wrap_FXColorWheel_doesSaveUnder), -1);
    rb_define_method(cFXColorWheel.klass, "setBackColor", VALUEFUNC(_wrap_FXColorWheel_setBackColor), -1);
    cFXColorWheel.mark = (void (*)(void *)) FXRbColorWheel::markfunc;
    cFXColorWheel.destroy = (void (*)(void *)) FXRbObject::freefunc;
    rb_define_const(mFox,"DIAL_VERTICAL", INT2NUM(DIAL_VERTICAL));
    rb_define_const(mFox,"DIAL_HORIZONTAL", INT2NUM(DIAL_HORIZONTAL));
    rb_define_const(mFox,"DIAL_CYCLIC", INT2NUM(DIAL_CYCLIC));
    rb_define_const(mFox,"DIAL_HAS_NOTCH", INT2NUM(DIAL_HAS_NOTCH));
    rb_define_const(mFox,"DIAL_NORMAL", INT2NUM(DIAL_NORMAL));
    
    cFXDial.klass = rb_define_class_under(mFox, "FXDial", ((swig_class *) SWIGTYPE_p_FXFrame->clientdata)->klass);
    SWIG_TypeClientData(SWIGTYPE_p_FXDial, (void *) &cFXDial);
    rb_define_alloc_func(cFXDial.klass, _wrap_FXDial_allocate);
    rb_define_method(cFXDial.klass, "initialize", VALUEFUNC(_wrap_new_FXDial), -1);
    rb_define_method(cFXDial.klass, "onPaint", VALUEFUNC(_wrap_FXDial_onPaint), -1);
    rb_define_method(cFXDial.klass, "onMotion", VALUEFUNC(_wrap_FXDial_onMotion), -1);
    rb_define_method(cFXDial.klass, "onMouseWheel", VALUEFUNC(_wrap_FXDial_onMouseWheel), -1);
    rb_define_method(cFXDial.klass, "onLeftBtnPress", VALUEFUNC(_wrap_FXDial_onLeftBtnPress), -1);
    rb_define_method(cFXDial.klass, "onLeftBtnRelease", VALUEFUNC(_wrap_FXDial_onLeftBtnRelease), -1);
    rb_define_method(cFXDial.klass, "onUngrabbed", VALUEFUNC(_wrap_FXDial_onUngrabbed), -1);
    rb_define_method(cFXDial.klass, "onCmdSetValue", VALUEFUNC(_wrap_FXDial_onCmdSetValue), -1);
    rb_define_method(cFXDial.klass, "onCmdSetIntValue", VALUEFUNC(_wrap_FXDial_onCmdSetIntValue), -1);
    rb_define_method(cFXDial.klass, "onCmdGetIntValue", VALUEFUNC(_wrap_FXDial_onCmdGetIntValue), -1);
    rb_define_method(cFXDial.klass, "onCmdSetRealValue", VALUEFUNC(_wrap_FXDial_onCmdSetRealValue), -1);
    rb_define_method(cFXDial.klass, "onCmdGetRealValue", VALUEFUNC(_wrap_FXDial_onCmdGetRealValue), -1);
    rb_define_method(cFXDial.klass, "onCmdSetIntRange", VALUEFUNC(_wrap_FXDial_onCmdSetIntRange), -1);
    rb_define_method(cFXDial.klass, "onCmdGetIntRange", VALUEFUNC(_wrap_FXDial_onCmdGetIntRange), -1);
    rb_define_method(cFXDial.klass, "onCmdSetRealRange", VALUEFUNC(_wrap_FXDial_onCmdSetRealRange), -1);
    rb_define_method(cFXDial.klass, "onCmdGetRealRange", VALUEFUNC(_wrap_FXDial_onCmdGetRealRange), -1);
    rb_define_method(cFXDial.klass, "onCmdSetHelp", VALUEFUNC(_wrap_FXDial_onCmdSetHelp), -1);
    rb_define_method(cFXDial.klass, "onCmdGetHelp", VALUEFUNC(_wrap_FXDial_onCmdGetHelp), -1);
    rb_define_method(cFXDial.klass, "onCmdSetTip", VALUEFUNC(_wrap_FXDial_onCmdSetTip), -1);
    rb_define_method(cFXDial.klass, "onCmdGetTip", VALUEFUNC(_wrap_FXDial_onCmdGetTip), -1);
    rb_define_method(cFXDial.klass, "onQueryHelp", VALUEFUNC(_wrap_FXDial_onQueryHelp), -1);
    rb_define_method(cFXDial.klass, "onQueryTip", VALUEFUNC(_wrap_FXDial_onQueryTip), -1);
    rb_define_method(cFXDial.klass, "setValue", VALUEFUNC(_wrap_FXDial_setValue), -1);
    rb_define_method(cFXDial.klass, "getValue", VALUEFUNC(_wrap_FXDial_getValue), -1);
    rb_define_method(cFXDial.klass, "setRange", VALUEFUNC(_wrap_FXDial_setRange), -1);
    rb_define_method(cFXDial.klass, "getRange", VALUEFUNC(_wrap_FXDial_getRange), -1);
    rb_define_method(cFXDial.klass, "setRevolutionIncrement", VALUEFUNC(_wrap_FXDial_setRevolutionIncrement), -1);
    rb_define_method(cFXDial.klass, "getRevolutionIncrement", VALUEFUNC(_wrap_FXDial_getRevolutionIncrement), -1);
    rb_define_method(cFXDial.klass, "setNotchSpacing", VALUEFUNC(_wrap_FXDial_setNotchSpacing), -1);
    rb_define_method(cFXDial.klass, "getNotchSpacing", VALUEFUNC(_wrap_FXDial_getNotchSpacing), -1);
    rb_define_method(cFXDial.klass, "setNotchOffset", VALUEFUNC(_wrap_FXDial_setNotchOffset), -1);
    rb_define_method(cFXDial.klass, "getNotchOffset", VALUEFUNC(_wrap_FXDial_getNotchOffset), -1);
    rb_define_method(cFXDial.klass, "setDialStyle", VALUEFUNC(_wrap_FXDial_setDialStyle), -1);
    rb_define_method(cFXDial.klass, "getDialStyle", VALUEFUNC(_wrap_FXDial_getDialStyle), -1);
    rb_define_method(cFXDial.klass, "setNotchColor", VALUEFUNC(_wrap_FXDial_setNotchColor), -1);
    rb_define_method(cFXDial.klass, "getNotchColor", VALUEFUNC(_wrap_FXDial_getNotchColor), -1);
    rb_define_method(cFXDial.klass, "setHelpText", VALUEFUNC(_wrap_FXDial_setHelpText), -1);
    rb_define_method(cFXDial.klass, "getHelpText", VALUEFUNC(_wrap_FXDial_getHelpText), -1);
    rb_define_method(cFXDial.klass, "setTipText", VALUEFUNC(_wrap_FXDial_setTipText), -1);
    rb_define_method(cFXDial.klass, "getTipText", VALUEFUNC(_wrap_FXDial_getTipText), -1);
    rb_define_method(cFXDial.klass, "save", VALUEFUNC(_wrap_FXDial_save), -1);
    rb_define_method(cFXDial.klass, "load", VALUEFUNC(_wrap_FXDial_load), -1);
    rb_define_method(cFXDial.klass, "create", VALUEFUNC(_wrap_FXDial_create), -1);
    rb_define_method(cFXDial.klass, "detach", VALUEFUNC(_wrap_FXDial_detach), -1);
    rb_define_method(cFXDial.klass, "destroy", VALUEFUNC(_wrap_FXDial_destroy), -1);
    rb_define_method(cFXDial.klass, "resize", VALUEFUNC(_wrap_FXDial_resize), -1);
    rb_define_method(cFXDial.klass, "getDefaultWidth", VALUEFUNC(_wrap_FXDial_getDefaultWidth), -1);
    rb_define_method(cFXDial.klass, "getDefaultHeight", VALUEFUNC(_wrap_FXDial_getDefaultHeight), -1);
    rb_define_method(cFXDial.klass, "getWidthForHeight", VALUEFUNC(_wrap_FXDial_getWidthForHeight), -1);
    rb_define_method(cFXDial.klass, "getHeightForWidth", VALUEFUNC(_wrap_FXDial_getHeightForWidth), -1);
    rb_define_method(cFXDial.klass, "canFocus", VALUEFUNC(_wrap_FXDial_canFocus), -1);
    rb_define_method(cFXDial.klass, "setFocus", VALUEFUNC(_wrap_FXDial_setFocus), -1);
    rb_define_method(cFXDial.klass, "killFocus", VALUEFUNC(_wrap_FXDial_killFocus), -1);
    rb_define_method(cFXDial.klass, "setDefault", VALUEFUNC(_wrap_FXDial_setDefault), -1);
    rb_define_method(cFXDial.klass, "enable", VALUEFUNC(_wrap_FXDial_enable), -1);
    rb_define_method(cFXDial.klass, "disable", VALUEFUNC(_wrap_FXDial_disable), -1);
    rb_define_method(cFXDial.klass, "raiseWindow", VALUEFUNC(_wrap_FXDial_raiseWindow), -1);
    rb_define_method(cFXDial.klass, "lower", VALUEFUNC(_wrap_FXDial_lower), -1);
    rb_define_method(cFXDial.klass, "move", VALUEFUNC(_wrap_FXDial_move), -1);
    rb_define_method(cFXDial.klass, "position", VALUEFUNC(_wrap_FXDial_position), -1);
    rb_define_method(cFXDial.klass, "layout", VALUEFUNC(_wrap_FXDial_layout), -1);
    rb_define_method(cFXDial.klass, "recalc", VALUEFUNC(_wrap_FXDial_recalc), -1);
    rb_define_method(cFXDial.klass, "reparent", VALUEFUNC(_wrap_FXDial_reparent), -1);
    rb_define_method(cFXDial.klass, "show", VALUEFUNC(_wrap_FXDial_show), -1);
    rb_define_method(cFXDial.klass, "hide", VALUEFUNC(_wrap_FXDial_hide), -1);
    rb_define_method(cFXDial.klass, "isComposite", VALUEFUNC(_wrap_FXDial_isComposite), -1);
    rb_define_method(cFXDial.klass, "contains", VALUEFUNC(_wrap_FXDial_contains), -1);
    rb_define_method(cFXDial.klass, "doesSaveUnder", VALUEFUNC(_wrap_FXDial_doesSaveUnder), -1);
    rb_define_method(cFXDial.klass, "setBackColor", VALUEFUNC(_wrap_FXDial_setBackColor), -1);
    cFXDial.mark = (void (*)(void *)) FXRbDial::markfunc;
    cFXDial.destroy = (void (*)(void *)) FXRbObject::freefunc;
    rb_define_const(mFox,"HEADER_BUTTON", INT2NUM(HEADER_BUTTON));
    rb_define_const(mFox,"HEADER_HORIZONTAL", INT2NUM(HEADER_HORIZONTAL));
    rb_define_const(mFox,"HEADER_VERTICAL", INT2NUM(HEADER_VERTICAL));
    rb_define_const(mFox,"HEADER_TRACKING", INT2NUM(HEADER_TRACKING));
    rb_define_const(mFox,"HEADER_NORMAL", INT2NUM(HEADER_NORMAL));
    
    cFXHeaderItem.klass = rb_define_class_under(mFox, "FXHeaderItem", ((swig_class *) SWIGTYPE_p_FXObject->clientdata)->klass);
    SWIG_TypeClientData(SWIGTYPE_p_FXHeaderItem, (void *) &cFXHeaderItem);
    rb_define_alloc_func(cFXHeaderItem.klass, _wrap_FXHeaderItem_allocate);
    rb_define_method(cFXHeaderItem.klass, "initialize", VALUEFUNC(_wrap_new_FXHeaderItem), -1);
    rb_define_const(cFXHeaderItem.klass,"RIGHT", INT2NUM(FXHeaderItem::RIGHT));
    rb_define_const(cFXHeaderItem.klass,"LEFT", INT2NUM(FXHeaderItem::LEFT));
    rb_define_const(cFXHeaderItem.klass,"CENTER_X", INT2NUM(FXHeaderItem::CENTER_X));
    rb_define_const(cFXHeaderItem.klass,"TOP", INT2NUM(FXHeaderItem::TOP));
    rb_define_const(cFXHeaderItem.klass,"BOTTOM", INT2NUM(FXHeaderItem::BOTTOM));
    rb_define_const(cFXHeaderItem.klass,"CENTER_Y", INT2NUM(FXHeaderItem::CENTER_Y));
    rb_define_const(cFXHeaderItem.klass,"BEFORE", INT2NUM(FXHeaderItem::BEFORE));
    rb_define_const(cFXHeaderItem.klass,"AFTER", INT2NUM(FXHeaderItem::AFTER));
    rb_define_const(cFXHeaderItem.klass,"ABOVE", INT2NUM(FXHeaderItem::ABOVE));
    rb_define_const(cFXHeaderItem.klass,"BELOW", INT2NUM(FXHeaderItem::BELOW));
    rb_define_method(cFXHeaderItem.klass, "getText", VALUEFUNC(_wrap_FXHeaderItem_getText), -1);
    rb_define_method(cFXHeaderItem.klass, "getIcon", VALUEFUNC(_wrap_FXHeaderItem_getIcon), -1);
    rb_define_method(cFXHeaderItem.klass, "setData", VALUEFUNC(_wrap_FXHeaderItem_setData), -1);
    rb_define_method(cFXHeaderItem.klass, "getData", VALUEFUNC(_wrap_FXHeaderItem_getData), -1);
    rb_define_method(cFXHeaderItem.klass, "setSize", VALUEFUNC(_wrap_FXHeaderItem_setSize), -1);
    rb_define_method(cFXHeaderItem.klass, "getSize", VALUEFUNC(_wrap_FXHeaderItem_getSize), -1);
    rb_define_method(cFXHeaderItem.klass, "setPos", VALUEFUNC(_wrap_FXHeaderItem_setPos), -1);
    rb_define_method(cFXHeaderItem.klass, "getPos", VALUEFUNC(_wrap_FXHeaderItem_getPos), -1);
    rb_define_method(cFXHeaderItem.klass, "setArrowDir", VALUEFUNC(_wrap_FXHeaderItem_setArrowDir), -1);
    rb_define_method(cFXHeaderItem.klass, "getArrowDir", VALUEFUNC(_wrap_FXHeaderItem_getArrowDir), -1);
    rb_define_method(cFXHeaderItem.klass, "setJustify", VALUEFUNC(_wrap_FXHeaderItem_setJustify), -1);
    rb_define_method(cFXHeaderItem.klass, "getJustify", VALUEFUNC(_wrap_FXHeaderItem_getJustify), -1);
    rb_define_method(cFXHeaderItem.klass, "setIconPosition", VALUEFUNC(_wrap_FXHeaderItem_setIconPosition), -1);
    rb_define_method(cFXHeaderItem.klass, "getIconPosition", VALUEFUNC(_wrap_FXHeaderItem_getIconPosition), -1);
    rb_define_method(cFXHeaderItem.klass, "setPressed", VALUEFUNC(_wrap_FXHeaderItem_setPressed), -1);
    rb_define_method(cFXHeaderItem.klass, "isPressed", VALUEFUNC(_wrap_FXHeaderItem_isPressed), -1);
    rb_define_method(cFXHeaderItem.klass, "save", VALUEFUNC(_wrap_FXHeaderItem_save), -1);
    rb_define_method(cFXHeaderItem.klass, "load", VALUEFUNC(_wrap_FXHeaderItem_load), -1);
    rb_define_method(cFXHeaderItem.klass, "setText", VALUEFUNC(_wrap_FXHeaderItem_setText), -1);
    rb_define_method(cFXHeaderItem.klass, "setIcon", VALUEFUNC(_wrap_FXHeaderItem_setIcon), -1);
    rb_define_method(cFXHeaderItem.klass, "getWidth", VALUEFUNC(_wrap_FXHeaderItem_getWidth), -1);
    rb_define_method(cFXHeaderItem.klass, "getHeight", VALUEFUNC(_wrap_FXHeaderItem_getHeight), -1);
    rb_define_method(cFXHeaderItem.klass, "create", VALUEFUNC(_wrap_FXHeaderItem_create), -1);
    rb_define_method(cFXHeaderItem.klass, "detach", VALUEFUNC(_wrap_FXHeaderItem_detach), -1);
    rb_define_method(cFXHeaderItem.klass, "destroy", VALUEFUNC(_wrap_FXHeaderItem_destroy), -1);
    cFXHeaderItem.mark = (void (*)(void *)) FXRbHeaderItem::markfunc;
    cFXHeaderItem.destroy = (void (*)(void *)) FXRbHeaderItem::freefunc;
    
    cFXHeader.klass = rb_define_class_under(mFox, "FXHeader", ((swig_class *) SWIGTYPE_p_FXFrame->clientdata)->klass);
    SWIG_TypeClientData(SWIGTYPE_p_FXHeader, (void *) &cFXHeader);
    rb_define_alloc_func(cFXHeader.klass, _wrap_FXHeader_allocate);
    rb_define_method(cFXHeader.klass, "initialize", VALUEFUNC(_wrap_new_FXHeader), -1);
    rb_define_method(cFXHeader.klass, "onPaint", VALUEFUNC(_wrap_FXHeader_onPaint), -1);
    rb_define_method(cFXHeader.klass, "onLeftBtnPress", VALUEFUNC(_wrap_FXHeader_onLeftBtnPress), -1);
    rb_define_method(cFXHeader.klass, "onLeftBtnRelease", VALUEFUNC(_wrap_FXHeader_onLeftBtnRelease), -1);
    rb_define_method(cFXHeader.klass, "onUngrabbed", VALUEFUNC(_wrap_FXHeader_onUngrabbed), -1);
    rb_define_method(cFXHeader.klass, "onMotion", VALUEFUNC(_wrap_FXHeader_onMotion), -1);
    rb_define_method(cFXHeader.klass, "onTipTimer", VALUEFUNC(_wrap_FXHeader_onTipTimer), -1);
    rb_define_method(cFXHeader.klass, "onQueryTip", VALUEFUNC(_wrap_FXHeader_onQueryTip), -1);
    rb_define_method(cFXHeader.klass, "onQueryHelp", VALUEFUNC(_wrap_FXHeader_onQueryHelp), -1);
    rb_define_method(cFXHeader.klass, "getNumItems", VALUEFUNC(_wrap_FXHeader_getNumItems), -1);
    rb_define_method(cFXHeader.klass, "getTotalSize", VALUEFUNC(_wrap_FXHeader_getTotalSize), -1);
    rb_define_method(cFXHeader.klass, "setPosition", VALUEFUNC(_wrap_FXHeader_setPosition), -1);
    rb_define_method(cFXHeader.klass, "getPosition", VALUEFUNC(_wrap_FXHeader_getPosition), -1);
    rb_define_method(cFXHeader.klass, "getItem", VALUEFUNC(_wrap_FXHeader_getItem), -1);
    rb_define_method(cFXHeader.klass, "getItemAt", VALUEFUNC(_wrap_FXHeader_getItemAt), -1);
    rb_define_method(cFXHeader.klass, "setItem", VALUEFUNC(_wrap_FXHeader_setItem), -1);
    rb_define_method(cFXHeader.klass, "insertItem", VALUEFUNC(_wrap_FXHeader_insertItem), -1);
    rb_define_method(cFXHeader.klass, "appendItem", VALUEFUNC(_wrap_FXHeader_appendItem), -1);
    rb_define_method(cFXHeader.klass, "prependItem", VALUEFUNC(_wrap_FXHeader_prependItem), -1);
    rb_define_method(cFXHeader.klass, "removeItem", VALUEFUNC(_wrap_FXHeader_removeItem), -1);
    rb_define_method(cFXHeader.klass, "clearItems", VALUEFUNC(_wrap_FXHeader_clearItems), -1);
    rb_define_method(cFXHeader.klass, "setItemText", VALUEFUNC(_wrap_FXHeader_setItemText), -1);
    rb_define_method(cFXHeader.klass, "getItemText", VALUEFUNC(_wrap_FXHeader_getItemText), -1);
    rb_define_method(cFXHeader.klass, "setItemIcon", VALUEFUNC(_wrap_FXHeader_setItemIcon), -1);
    rb_define_method(cFXHeader.klass, "getItemIcon", VALUEFUNC(_wrap_FXHeader_getItemIcon), -1);
    rb_define_method(cFXHeader.klass, "setItemSize", VALUEFUNC(_wrap_FXHeader_setItemSize), -1);
    rb_define_method(cFXHeader.klass, "getItemSize", VALUEFUNC(_wrap_FXHeader_getItemSize), -1);
    rb_define_method(cFXHeader.klass, "getItemOffset", VALUEFUNC(_wrap_FXHeader_getItemOffset), -1);
    rb_define_method(cFXHeader.klass, "setItemData", VALUEFUNC(_wrap_FXHeader_setItemData), -1);
    rb_define_method(cFXHeader.klass, "getItemData", VALUEFUNC(_wrap_FXHeader_getItemData), -1);
    rb_define_method(cFXHeader.klass, "setArrowDir", VALUEFUNC(_wrap_FXHeader_setArrowDir), -1);
    rb_define_method(cFXHeader.klass, "getArrowDir", VALUEFUNC(_wrap_FXHeader_getArrowDir), -1);
    rb_define_method(cFXHeader.klass, "setItemJustify", VALUEFUNC(_wrap_FXHeader_setItemJustify), -1);
    rb_define_method(cFXHeader.klass, "getItemJustify", VALUEFUNC(_wrap_FXHeader_getItemJustify), -1);
    rb_define_method(cFXHeader.klass, "setItemIconPosition", VALUEFUNC(_wrap_FXHeader_setItemIconPosition), -1);
    rb_define_method(cFXHeader.klass, "getItemIconPosition", VALUEFUNC(_wrap_FXHeader_getItemIconPosition), -1);
    rb_define_method(cFXHeader.klass, "setItemPressed", VALUEFUNC(_wrap_FXHeader_setItemPressed), -1);
    rb_define_method(cFXHeader.klass, "isItemPressed", VALUEFUNC(_wrap_FXHeader_isItemPressed), -1);
    rb_define_method(cFXHeader.klass, "makeItemVisible", VALUEFUNC(_wrap_FXHeader_makeItemVisible), -1);
    rb_define_method(cFXHeader.klass, "updateItem", VALUEFUNC(_wrap_FXHeader_updateItem), -1);
    rb_define_method(cFXHeader.klass, "setFont", VALUEFUNC(_wrap_FXHeader_setFont), -1);
    rb_define_method(cFXHeader.klass, "getFont", VALUEFUNC(_wrap_FXHeader_getFont), -1);
    rb_define_method(cFXHeader.klass, "getTextColor", VALUEFUNC(_wrap_FXHeader_getTextColor), -1);
    rb_define_method(cFXHeader.klass, "setTextColor", VALUEFUNC(_wrap_FXHeader_setTextColor), -1);
    rb_define_method(cFXHeader.klass, "setHeaderStyle", VALUEFUNC(_wrap_FXHeader_setHeaderStyle), -1);
    rb_define_method(cFXHeader.klass, "getHeaderStyle", VALUEFUNC(_wrap_FXHeader_getHeaderStyle), -1);
    rb_define_method(cFXHeader.klass, "setHelpText", VALUEFUNC(_wrap_FXHeader_setHelpText), -1);
    rb_define_method(cFXHeader.klass, "getHelpText", VALUEFUNC(_wrap_FXHeader_getHelpText), -1);
    rb_define_method(cFXHeader.klass, "save", VALUEFUNC(_wrap_FXHeader_save), -1);
    rb_define_method(cFXHeader.klass, "load", VALUEFUNC(_wrap_FXHeader_load), -1);
    rb_define_method(cFXHeader.klass, "create", VALUEFUNC(_wrap_FXHeader_create), -1);
    rb_define_method(cFXHeader.klass, "detach", VALUEFUNC(_wrap_FXHeader_detach), -1);
    rb_define_method(cFXHeader.klass, "destroy", VALUEFUNC(_wrap_FXHeader_destroy), -1);
    rb_define_method(cFXHeader.klass, "resize", VALUEFUNC(_wrap_FXHeader_resize), -1);
    rb_define_method(cFXHeader.klass, "getDefaultWidth", VALUEFUNC(_wrap_FXHeader_getDefaultWidth), -1);
    rb_define_method(cFXHeader.klass, "getDefaultHeight", VALUEFUNC(_wrap_FXHeader_getDefaultHeight), -1);
    rb_define_method(cFXHeader.klass, "getWidthForHeight", VALUEFUNC(_wrap_FXHeader_getWidthForHeight), -1);
    rb_define_method(cFXHeader.klass, "getHeightForWidth", VALUEFUNC(_wrap_FXHeader_getHeightForWidth), -1);
    rb_define_method(cFXHeader.klass, "canFocus", VALUEFUNC(_wrap_FXHeader_canFocus), -1);
    rb_define_method(cFXHeader.klass, "setFocus", VALUEFUNC(_wrap_FXHeader_setFocus), -1);
    rb_define_method(cFXHeader.klass, "killFocus", VALUEFUNC(_wrap_FXHeader_killFocus), -1);
    rb_define_method(cFXHeader.klass, "setDefault", VALUEFUNC(_wrap_FXHeader_setDefault), -1);
    rb_define_method(cFXHeader.klass, "enable", VALUEFUNC(_wrap_FXHeader_enable), -1);
    rb_define_method(cFXHeader.klass, "disable", VALUEFUNC(_wrap_FXHeader_disable), -1);
    rb_define_method(cFXHeader.klass, "raiseWindow", VALUEFUNC(_wrap_FXHeader_raiseWindow), -1);
    rb_define_method(cFXHeader.klass, "lower", VALUEFUNC(_wrap_FXHeader_lower), -1);
    rb_define_method(cFXHeader.klass, "move", VALUEFUNC(_wrap_FXHeader_move), -1);
    rb_define_method(cFXHeader.klass, "position", VALUEFUNC(_wrap_FXHeader_position), -1);
    rb_define_method(cFXHeader.klass, "layout", VALUEFUNC(_wrap_FXHeader_layout), -1);
    rb_define_method(cFXHeader.klass, "recalc", VALUEFUNC(_wrap_FXHeader_recalc), -1);
    rb_define_method(cFXHeader.klass, "reparent", VALUEFUNC(_wrap_FXHeader_reparent), -1);
    rb_define_method(cFXHeader.klass, "show", VALUEFUNC(_wrap_FXHeader_show), -1);
    rb_define_method(cFXHeader.klass, "hide", VALUEFUNC(_wrap_FXHeader_hide), -1);
    rb_define_method(cFXHeader.klass, "isComposite", VALUEFUNC(_wrap_FXHeader_isComposite), -1);
    rb_define_method(cFXHeader.klass, "contains", VALUEFUNC(_wrap_FXHeader_contains), -1);
    rb_define_method(cFXHeader.klass, "doesSaveUnder", VALUEFUNC(_wrap_FXHeader_doesSaveUnder), -1);
    rb_define_method(cFXHeader.klass, "setBackColor", VALUEFUNC(_wrap_FXHeader_setBackColor), -1);
    cFXHeader.mark = (void (*)(void *)) FXRbHeader::markfunc;
    cFXHeader.destroy = (void (*)(void *)) FXRbObject::freefunc;
    
    cFXImageFrame.klass = rb_define_class_under(mFox, "FXImageFrame", ((swig_class *) SWIGTYPE_p_FXFrame->clientdata)->klass);
    SWIG_TypeClientData(SWIGTYPE_p_FXImageFrame, (void *) &cFXImageFrame);
    rb_define_alloc_func(cFXImageFrame.klass, _wrap_FXImageFrame_allocate);
    rb_define_method(cFXImageFrame.klass, "initialize", VALUEFUNC(_wrap_new_FXImageFrame), -1);
    rb_define_method(cFXImageFrame.klass, "onPaint", VALUEFUNC(_wrap_FXImageFrame_onPaint), -1);
    rb_define_method(cFXImageFrame.klass, "setImage", VALUEFUNC(_wrap_FXImageFrame_setImage), -1);
    rb_define_method(cFXImageFrame.klass, "getImage", VALUEFUNC(_wrap_FXImageFrame_getImage), -1);
    rb_define_method(cFXImageFrame.klass, "setJustify", VALUEFUNC(_wrap_FXImageFrame_setJustify), -1);
    rb_define_method(cFXImageFrame.klass, "getJustify", VALUEFUNC(_wrap_FXImageFrame_getJustify), -1);
    rb_define_method(cFXImageFrame.klass, "save", VALUEFUNC(_wrap_FXImageFrame_save), -1);
    rb_define_method(cFXImageFrame.klass, "load", VALUEFUNC(_wrap_FXImageFrame_load), -1);
    rb_define_method(cFXImageFrame.klass, "create", VALUEFUNC(_wrap_FXImageFrame_create), -1);
    rb_define_method(cFXImageFrame.klass, "detach", VALUEFUNC(_wrap_FXImageFrame_detach), -1);
    rb_define_method(cFXImageFrame.klass, "destroy", VALUEFUNC(_wrap_FXImageFrame_destroy), -1);
    rb_define_method(cFXImageFrame.klass, "resize", VALUEFUNC(_wrap_FXImageFrame_resize), -1);
    rb_define_method(cFXImageFrame.klass, "getDefaultWidth", VALUEFUNC(_wrap_FXImageFrame_getDefaultWidth), -1);
    rb_define_method(cFXImageFrame.klass, "getDefaultHeight", VALUEFUNC(_wrap_FXImageFrame_getDefaultHeight), -1);
    rb_define_method(cFXImageFrame.klass, "getWidthForHeight", VALUEFUNC(_wrap_FXImageFrame_getWidthForHeight), -1);
    rb_define_method(cFXImageFrame.klass, "getHeightForWidth", VALUEFUNC(_wrap_FXImageFrame_getHeightForWidth), -1);
    rb_define_method(cFXImageFrame.klass, "canFocus", VALUEFUNC(_wrap_FXImageFrame_canFocus), -1);
    rb_define_method(cFXImageFrame.klass, "setFocus", VALUEFUNC(_wrap_FXImageFrame_setFocus), -1);
    rb_define_method(cFXImageFrame.klass, "killFocus", VALUEFUNC(_wrap_FXImageFrame_killFocus), -1);
    rb_define_method(cFXImageFrame.klass, "setDefault", VALUEFUNC(_wrap_FXImageFrame_setDefault), -1);
    rb_define_method(cFXImageFrame.klass, "enable", VALUEFUNC(_wrap_FXImageFrame_enable), -1);
    rb_define_method(cFXImageFrame.klass, "disable", VALUEFUNC(_wrap_FXImageFrame_disable), -1);
    rb_define_method(cFXImageFrame.klass, "raiseWindow", VALUEFUNC(_wrap_FXImageFrame_raiseWindow), -1);
    rb_define_method(cFXImageFrame.klass, "lower", VALUEFUNC(_wrap_FXImageFrame_lower), -1);
    rb_define_method(cFXImageFrame.klass, "move", VALUEFUNC(_wrap_FXImageFrame_move), -1);
    rb_define_method(cFXImageFrame.klass, "position", VALUEFUNC(_wrap_FXImageFrame_position), -1);
    rb_define_method(cFXImageFrame.klass, "layout", VALUEFUNC(_wrap_FXImageFrame_layout), -1);
    rb_define_method(cFXImageFrame.klass, "recalc", VALUEFUNC(_wrap_FXImageFrame_recalc), -1);
    rb_define_method(cFXImageFrame.klass, "reparent", VALUEFUNC(_wrap_FXImageFrame_reparent), -1);
    rb_define_method(cFXImageFrame.klass, "show", VALUEFUNC(_wrap_FXImageFrame_show), -1);
    rb_define_method(cFXImageFrame.klass, "hide", VALUEFUNC(_wrap_FXImageFrame_hide), -1);
    rb_define_method(cFXImageFrame.klass, "isComposite", VALUEFUNC(_wrap_FXImageFrame_isComposite), -1);
    rb_define_method(cFXImageFrame.klass, "contains", VALUEFUNC(_wrap_FXImageFrame_contains), -1);
    rb_define_method(cFXImageFrame.klass, "doesSaveUnder", VALUEFUNC(_wrap_FXImageFrame_doesSaveUnder), -1);
    rb_define_method(cFXImageFrame.klass, "setBackColor", VALUEFUNC(_wrap_FXImageFrame_setBackColor), -1);
    cFXImageFrame.mark = (void (*)(void *)) FXRbImageFrame::markfunc;
    cFXImageFrame.destroy = (void (*)(void *)) FXRbObject::freefunc;
    
    cFXBitmapFrame.klass = rb_define_class_under(mFox, "FXBitmapFrame", ((swig_class *) SWIGTYPE_p_FXFrame->clientdata)->klass);
    SWIG_TypeClientData(SWIGTYPE_p_FXBitmapFrame, (void *) &cFXBitmapFrame);
    rb_define_alloc_func(cFXBitmapFrame.klass, _wrap_FXBitmapFrame_allocate);
    rb_define_method(cFXBitmapFrame.klass, "initialize", VALUEFUNC(_wrap_new_FXBitmapFrame), -1);
    rb_define_method(cFXBitmapFrame.klass, "onPaint", VALUEFUNC(_wrap_FXBitmapFrame_onPaint), -1);
    rb_define_method(cFXBitmapFrame.klass, "setBitmap", VALUEFUNC(_wrap_FXBitmapFrame_setBitmap), -1);
    rb_define_method(cFXBitmapFrame.klass, "getBitmap", VALUEFUNC(_wrap_FXBitmapFrame_getBitmap), -1);
    rb_define_method(cFXBitmapFrame.klass, "setOnColor", VALUEFUNC(_wrap_FXBitmapFrame_setOnColor), -1);
    rb_define_method(cFXBitmapFrame.klass, "getOnColor", VALUEFUNC(_wrap_FXBitmapFrame_getOnColor), -1);
    rb_define_method(cFXBitmapFrame.klass, "setOffColor", VALUEFUNC(_wrap_FXBitmapFrame_setOffColor), -1);
    rb_define_method(cFXBitmapFrame.klass, "getOffColor", VALUEFUNC(_wrap_FXBitmapFrame_getOffColor), -1);
    rb_define_method(cFXBitmapFrame.klass, "setJustify", VALUEFUNC(_wrap_FXBitmapFrame_setJustify), -1);
    rb_define_method(cFXBitmapFrame.klass, "getJustify", VALUEFUNC(_wrap_FXBitmapFrame_getJustify), -1);
    rb_define_method(cFXBitmapFrame.klass, "save", VALUEFUNC(_wrap_FXBitmapFrame_save), -1);
    rb_define_method(cFXBitmapFrame.klass, "load", VALUEFUNC(_wrap_FXBitmapFrame_load), -1);
    rb_define_method(cFXBitmapFrame.klass, "create", VALUEFUNC(_wrap_FXBitmapFrame_create), -1);
    rb_define_method(cFXBitmapFrame.klass, "detach", VALUEFUNC(_wrap_FXBitmapFrame_detach), -1);
    rb_define_method(cFXBitmapFrame.klass, "destroy", VALUEFUNC(_wrap_FXBitmapFrame_destroy), -1);
    rb_define_method(cFXBitmapFrame.klass, "resize", VALUEFUNC(_wrap_FXBitmapFrame_resize), -1);
    rb_define_method(cFXBitmapFrame.klass, "getDefaultWidth", VALUEFUNC(_wrap_FXBitmapFrame_getDefaultWidth), -1);
    rb_define_method(cFXBitmapFrame.klass, "getDefaultHeight", VALUEFUNC(_wrap_FXBitmapFrame_getDefaultHeight), -1);
    rb_define_method(cFXBitmapFrame.klass, "getWidthForHeight", VALUEFUNC(_wrap_FXBitmapFrame_getWidthForHeight), -1);
    rb_define_method(cFXBitmapFrame.klass, "getHeightForWidth", VALUEFUNC(_wrap_FXBitmapFrame_getHeightForWidth), -1);
    rb_define_method(cFXBitmapFrame.klass, "canFocus", VALUEFUNC(_wrap_FXBitmapFrame_canFocus), -1);
    rb_define_method(cFXBitmapFrame.klass, "setFocus", VALUEFUNC(_wrap_FXBitmapFrame_setFocus), -1);
    rb_define_method(cFXBitmapFrame.klass, "killFocus", VALUEFUNC(_wrap_FXBitmapFrame_killFocus), -1);
    rb_define_method(cFXBitmapFrame.klass, "setDefault", VALUEFUNC(_wrap_FXBitmapFrame_setDefault), -1);
    rb_define_method(cFXBitmapFrame.klass, "enable", VALUEFUNC(_wrap_FXBitmapFrame_enable), -1);
    rb_define_method(cFXBitmapFrame.klass, "disable", VALUEFUNC(_wrap_FXBitmapFrame_disable), -1);
    rb_define_method(cFXBitmapFrame.klass, "raiseWindow", VALUEFUNC(_wrap_FXBitmapFrame_raiseWindow), -1);
    rb_define_method(cFXBitmapFrame.klass, "lower", VALUEFUNC(_wrap_FXBitmapFrame_lower), -1);
    rb_define_method(cFXBitmapFrame.klass, "move", VALUEFUNC(_wrap_FXBitmapFrame_move), -1);
    rb_define_method(cFXBitmapFrame.klass, "position", VALUEFUNC(_wrap_FXBitmapFrame_position), -1);
    rb_define_method(cFXBitmapFrame.klass, "layout", VALUEFUNC(_wrap_FXBitmapFrame_layout), -1);
    rb_define_method(cFXBitmapFrame.klass, "recalc", VALUEFUNC(_wrap_FXBitmapFrame_recalc), -1);
    rb_define_method(cFXBitmapFrame.klass, "reparent", VALUEFUNC(_wrap_FXBitmapFrame_reparent), -1);
    rb_define_method(cFXBitmapFrame.klass, "show", VALUEFUNC(_wrap_FXBitmapFrame_show), -1);
    rb_define_method(cFXBitmapFrame.klass, "hide", VALUEFUNC(_wrap_FXBitmapFrame_hide), -1);
    rb_define_method(cFXBitmapFrame.klass, "isComposite", VALUEFUNC(_wrap_FXBitmapFrame_isComposite), -1);
    rb_define_method(cFXBitmapFrame.klass, "contains", VALUEFUNC(_wrap_FXBitmapFrame_contains), -1);
    rb_define_method(cFXBitmapFrame.klass, "doesSaveUnder", VALUEFUNC(_wrap_FXBitmapFrame_doesSaveUnder), -1);
    rb_define_method(cFXBitmapFrame.klass, "setBackColor", VALUEFUNC(_wrap_FXBitmapFrame_setBackColor), -1);
    cFXBitmapFrame.mark = (void (*)(void *)) FXRbBitmapFrame::markfunc;
    cFXBitmapFrame.destroy = (void (*)(void *)) FXRbObject::freefunc;
    rb_define_const(mFox,"PROGRESSBAR_HORIZONTAL", INT2NUM(PROGRESSBAR_HORIZONTAL));
    rb_define_const(mFox,"PROGRESSBAR_VERTICAL", INT2NUM(PROGRESSBAR_VERTICAL));
    rb_define_const(mFox,"PROGRESSBAR_PERCENTAGE", INT2NUM(PROGRESSBAR_PERCENTAGE));
    rb_define_const(mFox,"PROGRESSBAR_DIAL", INT2NUM(PROGRESSBAR_DIAL));
    rb_define_const(mFox,"PROGRESSBAR_NORMAL", INT2NUM(PROGRESSBAR_NORMAL));
    
    cFXProgressBar.klass = rb_define_class_under(mFox, "FXProgressBar", ((swig_class *) SWIGTYPE_p_FXFrame->clientdata)->klass);
    SWIG_TypeClientData(SWIGTYPE_p_FXProgressBar, (void *) &cFXProgressBar);
    rb_define_alloc_func(cFXProgressBar.klass, _wrap_FXProgressBar_allocate);
    rb_define_method(cFXProgressBar.klass, "initialize", VALUEFUNC(_wrap_new_FXProgressBar), -1);
    rb_define_method(cFXProgressBar.klass, "onPaint", VALUEFUNC(_wrap_FXProgressBar_onPaint), -1);
    rb_define_method(cFXProgressBar.klass, "onCmdSetValue", VALUEFUNC(_wrap_FXProgressBar_onCmdSetValue), -1);
    rb_define_method(cFXProgressBar.klass, "onCmdSetIntValue", VALUEFUNC(_wrap_FXProgressBar_onCmdSetIntValue), -1);
    rb_define_method(cFXProgressBar.klass, "onCmdGetIntValue", VALUEFUNC(_wrap_FXProgressBar_onCmdGetIntValue), -1);
    rb_define_method(cFXProgressBar.klass, "setProgress", VALUEFUNC(_wrap_FXProgressBar_setProgress), -1);
    rb_define_method(cFXProgressBar.klass, "getProgress", VALUEFUNC(_wrap_FXProgressBar_getProgress), -1);
    rb_define_method(cFXProgressBar.klass, "setTotal", VALUEFUNC(_wrap_FXProgressBar_setTotal), -1);
    rb_define_method(cFXProgressBar.klass, "getTotal", VALUEFUNC(_wrap_FXProgressBar_getTotal), -1);
    rb_define_method(cFXProgressBar.klass, "increment", VALUEFUNC(_wrap_FXProgressBar_increment), -1);
    rb_define_method(cFXProgressBar.klass, "hideNumber", VALUEFUNC(_wrap_FXProgressBar_hideNumber), -1);
    rb_define_method(cFXProgressBar.klass, "showNumber", VALUEFUNC(_wrap_FXProgressBar_showNumber), -1);
    rb_define_method(cFXProgressBar.klass, "setBarSize", VALUEFUNC(_wrap_FXProgressBar_setBarSize), -1);
    rb_define_method(cFXProgressBar.klass, "getBarSize", VALUEFUNC(_wrap_FXProgressBar_getBarSize), -1);
    rb_define_method(cFXProgressBar.klass, "setBarBGColor", VALUEFUNC(_wrap_FXProgressBar_setBarBGColor), -1);
    rb_define_method(cFXProgressBar.klass, "getBarBGColor", VALUEFUNC(_wrap_FXProgressBar_getBarBGColor), -1);
    rb_define_method(cFXProgressBar.klass, "setBarColor", VALUEFUNC(_wrap_FXProgressBar_setBarColor), -1);
    rb_define_method(cFXProgressBar.klass, "getBarColor", VALUEFUNC(_wrap_FXProgressBar_getBarColor), -1);
    rb_define_method(cFXProgressBar.klass, "setTextColor", VALUEFUNC(_wrap_FXProgressBar_setTextColor), -1);
    rb_define_method(cFXProgressBar.klass, "getTextColor", VALUEFUNC(_wrap_FXProgressBar_getTextColor), -1);
    rb_define_method(cFXProgressBar.klass, "setTextAltColor", VALUEFUNC(_wrap_FXProgressBar_setTextAltColor), -1);
    rb_define_method(cFXProgressBar.klass, "getTextAltColor", VALUEFUNC(_wrap_FXProgressBar_getTextAltColor), -1);
    rb_define_method(cFXProgressBar.klass, "setFont", VALUEFUNC(_wrap_FXProgressBar_setFont), -1);
    rb_define_method(cFXProgressBar.klass, "getFont", VALUEFUNC(_wrap_FXProgressBar_getFont), -1);
    rb_define_method(cFXProgressBar.klass, "setBarStyle", VALUEFUNC(_wrap_FXProgressBar_setBarStyle), -1);
    rb_define_method(cFXProgressBar.klass, "getBarStyle", VALUEFUNC(_wrap_FXProgressBar_getBarStyle), -1);
    rb_define_method(cFXProgressBar.klass, "save", VALUEFUNC(_wrap_FXProgressBar_save), -1);
    rb_define_method(cFXProgressBar.klass, "load", VALUEFUNC(_wrap_FXProgressBar_load), -1);
    rb_define_method(cFXProgressBar.klass, "create", VALUEFUNC(_wrap_FXProgressBar_create), -1);
    rb_define_method(cFXProgressBar.klass, "detach", VALUEFUNC(_wrap_FXProgressBar_detach), -1);
    rb_define_method(cFXProgressBar.klass, "destroy", VALUEFUNC(_wrap_FXProgressBar_destroy), -1);
    rb_define_method(cFXProgressBar.klass, "resize", VALUEFUNC(_wrap_FXProgressBar_resize), -1);
    rb_define_method(cFXProgressBar.klass, "getDefaultWidth", VALUEFUNC(_wrap_FXProgressBar_getDefaultWidth), -1);
    rb_define_method(cFXProgressBar.klass, "getDefaultHeight", VALUEFUNC(_wrap_FXProgressBar_getDefaultHeight), -1);
    rb_define_method(cFXProgressBar.klass, "getWidthForHeight", VALUEFUNC(_wrap_FXProgressBar_getWidthForHeight), -1);
    rb_define_method(cFXProgressBar.klass, "getHeightForWidth", VALUEFUNC(_wrap_FXProgressBar_getHeightForWidth), -1);
    rb_define_method(cFXProgressBar.klass, "canFocus", VALUEFUNC(_wrap_FXProgressBar_canFocus), -1);
    rb_define_method(cFXProgressBar.klass, "setFocus", VALUEFUNC(_wrap_FXProgressBar_setFocus), -1);
    rb_define_method(cFXProgressBar.klass, "killFocus", VALUEFUNC(_wrap_FXProgressBar_killFocus), -1);
    rb_define_method(cFXProgressBar.klass, "setDefault", VALUEFUNC(_wrap_FXProgressBar_setDefault), -1);
    rb_define_method(cFXProgressBar.klass, "enable", VALUEFUNC(_wrap_FXProgressBar_enable), -1);
    rb_define_method(cFXProgressBar.klass, "disable", VALUEFUNC(_wrap_FXProgressBar_disable), -1);
    rb_define_method(cFXProgressBar.klass, "raiseWindow", VALUEFUNC(_wrap_FXProgressBar_raiseWindow), -1);
    rb_define_method(cFXProgressBar.klass, "lower", VALUEFUNC(_wrap_FXProgressBar_lower), -1);
    rb_define_method(cFXProgressBar.klass, "move", VALUEFUNC(_wrap_FXProgressBar_move), -1);
    rb_define_method(cFXProgressBar.klass, "position", VALUEFUNC(_wrap_FXProgressBar_position), -1);
    rb_define_method(cFXProgressBar.klass, "layout", VALUEFUNC(_wrap_FXProgressBar_layout), -1);
    rb_define_method(cFXProgressBar.klass, "recalc", VALUEFUNC(_wrap_FXProgressBar_recalc), -1);
    rb_define_method(cFXProgressBar.klass, "reparent", VALUEFUNC(_wrap_FXProgressBar_reparent), -1);
    rb_define_method(cFXProgressBar.klass, "show", VALUEFUNC(_wrap_FXProgressBar_show), -1);
    rb_define_method(cFXProgressBar.klass, "hide", VALUEFUNC(_wrap_FXProgressBar_hide), -1);
    rb_define_method(cFXProgressBar.klass, "isComposite", VALUEFUNC(_wrap_FXProgressBar_isComposite), -1);
    rb_define_method(cFXProgressBar.klass, "contains", VALUEFUNC(_wrap_FXProgressBar_contains), -1);
    rb_define_method(cFXProgressBar.klass, "doesSaveUnder", VALUEFUNC(_wrap_FXProgressBar_doesSaveUnder), -1);
    rb_define_method(cFXProgressBar.klass, "setBackColor", VALUEFUNC(_wrap_FXProgressBar_setBackColor), -1);
    cFXProgressBar.mark = (void (*)(void *)) FXRbProgressBar::markfunc;
    cFXProgressBar.destroy = (void (*)(void *)) FXRbObject::freefunc;
    rb_define_const(mFox,"RULER_NORMAL", INT2NUM(RULER_NORMAL));
    rb_define_const(mFox,"RULER_HORIZONTAL", INT2NUM(RULER_HORIZONTAL));
    rb_define_const(mFox,"RULER_VERTICAL", INT2NUM(RULER_VERTICAL));
    rb_define_const(mFox,"RULER_TICKS_OFF", INT2NUM(RULER_TICKS_OFF));
    rb_define_const(mFox,"RULER_TICKS_TOP", INT2NUM(RULER_TICKS_TOP));
    rb_define_const(mFox,"RULER_TICKS_BOTTOM", INT2NUM(RULER_TICKS_BOTTOM));
    rb_define_const(mFox,"RULER_TICKS_LEFT", INT2NUM(RULER_TICKS_LEFT));
    rb_define_const(mFox,"RULER_TICKS_RIGHT", INT2NUM(RULER_TICKS_RIGHT));
    rb_define_const(mFox,"RULER_TICKS_CENTER", INT2NUM(RULER_TICKS_CENTER));
    rb_define_const(mFox,"RULER_NUMBERS", INT2NUM(RULER_NUMBERS));
    rb_define_const(mFox,"RULER_ARROW", INT2NUM(RULER_ARROW));
    rb_define_const(mFox,"RULER_MARKERS", INT2NUM(RULER_MARKERS));
    rb_define_const(mFox,"RULER_METRIC", INT2NUM(RULER_METRIC));
    rb_define_const(mFox,"RULER_ENGLISH", INT2NUM(RULER_ENGLISH));
    
    cFXRuler.klass = rb_define_class_under(mFox, "FXRuler", ((swig_class *) SWIGTYPE_p_FXFrame->clientdata)->klass);
    SWIG_TypeClientData(SWIGTYPE_p_FXRuler, (void *) &cFXRuler);
    rb_define_alloc_func(cFXRuler.klass, _wrap_FXRuler_allocate);
    rb_define_method(cFXRuler.klass, "initialize", VALUEFUNC(_wrap_new_FXRuler), -1);
    rb_define_method(cFXRuler.klass, "onPaint", VALUEFUNC(_wrap_FXRuler_onPaint), -1);
    rb_define_method(cFXRuler.klass, "onLeftBtnPress", VALUEFUNC(_wrap_FXRuler_onLeftBtnPress), -1);
    rb_define_method(cFXRuler.klass, "onLeftBtnRelease", VALUEFUNC(_wrap_FXRuler_onLeftBtnRelease), -1);
    rb_define_method(cFXRuler.klass, "onMotion", VALUEFUNC(_wrap_FXRuler_onMotion), -1);
    rb_define_method(cFXRuler.klass, "onCmdSetValue", VALUEFUNC(_wrap_FXRuler_onCmdSetValue), -1);
    rb_define_method(cFXRuler.klass, "onCmdSetIntValue", VALUEFUNC(_wrap_FXRuler_onCmdSetIntValue), -1);
    rb_define_method(cFXRuler.klass, "onCmdGetIntValue", VALUEFUNC(_wrap_FXRuler_onCmdGetIntValue), -1);
    rb_define_method(cFXRuler.klass, "onCmdSetHelp", VALUEFUNC(_wrap_FXRuler_onCmdSetHelp), -1);
    rb_define_method(cFXRuler.klass, "onCmdGetHelp", VALUEFUNC(_wrap_FXRuler_onCmdGetHelp), -1);
    rb_define_method(cFXRuler.klass, "onCmdSetTip", VALUEFUNC(_wrap_FXRuler_onCmdSetTip), -1);
    rb_define_method(cFXRuler.klass, "onCmdGetTip", VALUEFUNC(_wrap_FXRuler_onCmdGetTip), -1);
    rb_define_method(cFXRuler.klass, "onQueryHelp", VALUEFUNC(_wrap_FXRuler_onQueryHelp), -1);
    rb_define_method(cFXRuler.klass, "onQueryTip", VALUEFUNC(_wrap_FXRuler_onQueryTip), -1);
    rb_define_const(cFXRuler.klass,"ID_ARROW", INT2NUM(FXRuler::ID_ARROW));
    rb_define_const(cFXRuler.klass,"ID_LAST", INT2NUM(FXRuler::ID_LAST));
    rb_define_method(cFXRuler.klass, "setFont", VALUEFUNC(_wrap_FXRuler_setFont), -1);
    rb_define_method(cFXRuler.klass, "getFont", VALUEFUNC(_wrap_FXRuler_getFont), -1);
    rb_define_method(cFXRuler.klass, "setValue", VALUEFUNC(_wrap_FXRuler_setValue), -1);
    rb_define_method(cFXRuler.klass, "getValue", VALUEFUNC(_wrap_FXRuler_getValue), -1);
    rb_define_method(cFXRuler.klass, "setRulerStyle", VALUEFUNC(_wrap_FXRuler_setRulerStyle), -1);
    rb_define_method(cFXRuler.klass, "getRulerStyle", VALUEFUNC(_wrap_FXRuler_getRulerStyle), -1);
    rb_define_method(cFXRuler.klass, "getTextColor", VALUEFUNC(_wrap_FXRuler_getTextColor), -1);
    rb_define_method(cFXRuler.klass, "setTextColor", VALUEFUNC(_wrap_FXRuler_setTextColor), -1);
    rb_define_method(cFXRuler.klass, "setHelpText", VALUEFUNC(_wrap_FXRuler_setHelpText), -1);
    rb_define_method(cFXRuler.klass, "getHelpText", VALUEFUNC(_wrap_FXRuler_getHelpText), -1);
    rb_define_method(cFXRuler.klass, "setTipText", VALUEFUNC(_wrap_FXRuler_setTipText), -1);
    rb_define_method(cFXRuler.klass, "getTipText", VALUEFUNC(_wrap_FXRuler_getTipText), -1);
    rb_define_method(cFXRuler.klass, "save", VALUEFUNC(_wrap_FXRuler_save), -1);
    rb_define_method(cFXRuler.klass, "load", VALUEFUNC(_wrap_FXRuler_load), -1);
    rb_define_method(cFXRuler.klass, "create", VALUEFUNC(_wrap_FXRuler_create), -1);
    rb_define_method(cFXRuler.klass, "detach", VALUEFUNC(_wrap_FXRuler_detach), -1);
    rb_define_method(cFXRuler.klass, "destroy", VALUEFUNC(_wrap_FXRuler_destroy), -1);
    rb_define_method(cFXRuler.klass, "resize", VALUEFUNC(_wrap_FXRuler_resize), -1);
    rb_define_method(cFXRuler.klass, "getDefaultWidth", VALUEFUNC(_wrap_FXRuler_getDefaultWidth), -1);
    rb_define_method(cFXRuler.klass, "getDefaultHeight", VALUEFUNC(_wrap_FXRuler_getDefaultHeight), -1);
    rb_define_method(cFXRuler.klass, "getWidthForHeight", VALUEFUNC(_wrap_FXRuler_getWidthForHeight), -1);
    rb_define_method(cFXRuler.klass, "getHeightForWidth", VALUEFUNC(_wrap_FXRuler_getHeightForWidth), -1);
    rb_define_method(cFXRuler.klass, "canFocus", VALUEFUNC(_wrap_FXRuler_canFocus), -1);
    rb_define_method(cFXRuler.klass, "setFocus", VALUEFUNC(_wrap_FXRuler_setFocus), -1);
    rb_define_method(cFXRuler.klass, "killFocus", VALUEFUNC(_wrap_FXRuler_killFocus), -1);
    rb_define_method(cFXRuler.klass, "setDefault", VALUEFUNC(_wrap_FXRuler_setDefault), -1);
    rb_define_method(cFXRuler.klass, "enable", VALUEFUNC(_wrap_FXRuler_enable), -1);
    rb_define_method(cFXRuler.klass, "disable", VALUEFUNC(_wrap_FXRuler_disable), -1);
    rb_define_method(cFXRuler.klass, "raiseWindow", VALUEFUNC(_wrap_FXRuler_raiseWindow), -1);
    rb_define_method(cFXRuler.klass, "lower", VALUEFUNC(_wrap_FXRuler_lower), -1);
    rb_define_method(cFXRuler.klass, "move", VALUEFUNC(_wrap_FXRuler_move), -1);
    rb_define_method(cFXRuler.klass, "position", VALUEFUNC(_wrap_FXRuler_position), -1);
    rb_define_method(cFXRuler.klass, "layout", VALUEFUNC(_wrap_FXRuler_layout), -1);
    rb_define_method(cFXRuler.klass, "recalc", VALUEFUNC(_wrap_FXRuler_recalc), -1);
    rb_define_method(cFXRuler.klass, "reparent", VALUEFUNC(_wrap_FXRuler_reparent), -1);
    rb_define_method(cFXRuler.klass, "show", VALUEFUNC(_wrap_FXRuler_show), -1);
    rb_define_method(cFXRuler.klass, "hide", VALUEFUNC(_wrap_FXRuler_hide), -1);
    rb_define_method(cFXRuler.klass, "isComposite", VALUEFUNC(_wrap_FXRuler_isComposite), -1);
    rb_define_method(cFXRuler.klass, "contains", VALUEFUNC(_wrap_FXRuler_contains), -1);
    rb_define_method(cFXRuler.klass, "doesSaveUnder", VALUEFUNC(_wrap_FXRuler_doesSaveUnder), -1);
    rb_define_method(cFXRuler.klass, "setBackColor", VALUEFUNC(_wrap_FXRuler_setBackColor), -1);
    cFXRuler.mark = (void (*)(void *)) FXRbRuler::markfunc;
    cFXRuler.destroy = (void (*)(void *)) FXRbObject::freefunc;
    rb_define_const(mFox,"SEPARATOR_NONE", INT2NUM(SEPARATOR_NONE));
    rb_define_const(mFox,"SEPARATOR_GROOVE", INT2NUM(SEPARATOR_GROOVE));
    rb_define_const(mFox,"SEPARATOR_RIDGE", INT2NUM(SEPARATOR_RIDGE));
    rb_define_const(mFox,"SEPARATOR_LINE", INT2NUM(SEPARATOR_LINE));
    
    cFXSeparator.klass = rb_define_class_under(mFox, "FXSeparator", ((swig_class *) SWIGTYPE_p_FXFrame->clientdata)->klass);
    SWIG_TypeClientData(SWIGTYPE_p_FXSeparator, (void *) &cFXSeparator);
    rb_define_alloc_func(cFXSeparator.klass, _wrap_FXSeparator_allocate);
    rb_define_method(cFXSeparator.klass, "initialize", VALUEFUNC(_wrap_new_FXSeparator), -1);
    rb_define_method(cFXSeparator.klass, "onPaint", VALUEFUNC(_wrap_FXSeparator_onPaint), -1);
    rb_define_method(cFXSeparator.klass, "setSeparatorStyle", VALUEFUNC(_wrap_FXSeparator_setSeparatorStyle), -1);
    rb_define_method(cFXSeparator.klass, "getSeparatorStyle", VALUEFUNC(_wrap_FXSeparator_getSeparatorStyle), -1);
    rb_define_method(cFXSeparator.klass, "save", VALUEFUNC(_wrap_FXSeparator_save), -1);
    rb_define_method(cFXSeparator.klass, "load", VALUEFUNC(_wrap_FXSeparator_load), -1);
    rb_define_method(cFXSeparator.klass, "create", VALUEFUNC(_wrap_FXSeparator_create), -1);
    rb_define_method(cFXSeparator.klass, "detach", VALUEFUNC(_wrap_FXSeparator_detach), -1);
    rb_define_method(cFXSeparator.klass, "destroy", VALUEFUNC(_wrap_FXSeparator_destroy), -1);
    rb_define_method(cFXSeparator.klass, "resize", VALUEFUNC(_wrap_FXSeparator_resize), -1);
    rb_define_method(cFXSeparator.klass, "getDefaultWidth", VALUEFUNC(_wrap_FXSeparator_getDefaultWidth), -1);
    rb_define_method(cFXSeparator.klass, "getDefaultHeight", VALUEFUNC(_wrap_FXSeparator_getDefaultHeight), -1);
    rb_define_method(cFXSeparator.klass, "getWidthForHeight", VALUEFUNC(_wrap_FXSeparator_getWidthForHeight), -1);
    rb_define_method(cFXSeparator.klass, "getHeightForWidth", VALUEFUNC(_wrap_FXSeparator_getHeightForWidth), -1);
    rb_define_method(cFXSeparator.klass, "canFocus", VALUEFUNC(_wrap_FXSeparator_canFocus), -1);
    rb_define_method(cFXSeparator.klass, "setFocus", VALUEFUNC(_wrap_FXSeparator_setFocus), -1);
    rb_define_method(cFXSeparator.klass, "killFocus", VALUEFUNC(_wrap_FXSeparator_killFocus), -1);
    rb_define_method(cFXSeparator.klass, "setDefault", VALUEFUNC(_wrap_FXSeparator_setDefault), -1);
    rb_define_method(cFXSeparator.klass, "enable", VALUEFUNC(_wrap_FXSeparator_enable), -1);
    rb_define_method(cFXSeparator.klass, "disable", VALUEFUNC(_wrap_FXSeparator_disable), -1);
    rb_define_method(cFXSeparator.klass, "raiseWindow", VALUEFUNC(_wrap_FXSeparator_raiseWindow), -1);
    rb_define_method(cFXSeparator.klass, "lower", VALUEFUNC(_wrap_FXSeparator_lower), -1);
    rb_define_method(cFXSeparator.klass, "move", VALUEFUNC(_wrap_FXSeparator_move), -1);
    rb_define_method(cFXSeparator.klass, "position", VALUEFUNC(_wrap_FXSeparator_position), -1);
    rb_define_method(cFXSeparator.klass, "layout", VALUEFUNC(_wrap_FXSeparator_layout), -1);
    rb_define_method(cFXSeparator.klass, "recalc", VALUEFUNC(_wrap_FXSeparator_recalc), -1);
    rb_define_method(cFXSeparator.klass, "reparent", VALUEFUNC(_wrap_FXSeparator_reparent), -1);
    rb_define_method(cFXSeparator.klass, "show", VALUEFUNC(_wrap_FXSeparator_show), -1);
    rb_define_method(cFXSeparator.klass, "hide", VALUEFUNC(_wrap_FXSeparator_hide), -1);
    rb_define_method(cFXSeparator.klass, "isComposite", VALUEFUNC(_wrap_FXSeparator_isComposite), -1);
    rb_define_method(cFXSeparator.klass, "contains", VALUEFUNC(_wrap_FXSeparator_contains), -1);
    rb_define_method(cFXSeparator.klass, "doesSaveUnder", VALUEFUNC(_wrap_FXSeparator_doesSaveUnder), -1);
    rb_define_method(cFXSeparator.klass, "setBackColor", VALUEFUNC(_wrap_FXSeparator_setBackColor), -1);
    cFXSeparator.mark = 0;
    cFXSeparator.destroy = (void (*)(void *)) free_FXSeparator;
    
    cFXHorizontalSeparator.klass = rb_define_class_under(mFox, "FXHorizontalSeparator", ((swig_class *) SWIGTYPE_p_FXSeparator->clientdata)->klass);
    SWIG_TypeClientData(SWIGTYPE_p_FXHorizontalSeparator, (void *) &cFXHorizontalSeparator);
    rb_define_alloc_func(cFXHorizontalSeparator.klass, _wrap_FXHorizontalSeparator_allocate);
    rb_define_method(cFXHorizontalSeparator.klass, "initialize", VALUEFUNC(_wrap_new_FXHorizontalSeparator), -1);
    rb_define_method(cFXHorizontalSeparator.klass, "save", VALUEFUNC(_wrap_FXHorizontalSeparator_save), -1);
    rb_define_method(cFXHorizontalSeparator.klass, "load", VALUEFUNC(_wrap_FXHorizontalSeparator_load), -1);
    rb_define_method(cFXHorizontalSeparator.klass, "create", VALUEFUNC(_wrap_FXHorizontalSeparator_create), -1);
    rb_define_method(cFXHorizontalSeparator.klass, "detach", VALUEFUNC(_wrap_FXHorizontalSeparator_detach), -1);
    rb_define_method(cFXHorizontalSeparator.klass, "destroy", VALUEFUNC(_wrap_FXHorizontalSeparator_destroy), -1);
    rb_define_method(cFXHorizontalSeparator.klass, "resize", VALUEFUNC(_wrap_FXHorizontalSeparator_resize), -1);
    rb_define_method(cFXHorizontalSeparator.klass, "getDefaultWidth", VALUEFUNC(_wrap_FXHorizontalSeparator_getDefaultWidth), -1);
    rb_define_method(cFXHorizontalSeparator.klass, "getDefaultHeight", VALUEFUNC(_wrap_FXHorizontalSeparator_getDefaultHeight), -1);
    rb_define_method(cFXHorizontalSeparator.klass, "getWidthForHeight", VALUEFUNC(_wrap_FXHorizontalSeparator_getWidthForHeight), -1);
    rb_define_method(cFXHorizontalSeparator.klass, "getHeightForWidth", VALUEFUNC(_wrap_FXHorizontalSeparator_getHeightForWidth), -1);
    rb_define_method(cFXHorizontalSeparator.klass, "canFocus", VALUEFUNC(_wrap_FXHorizontalSeparator_canFocus), -1);
    rb_define_method(cFXHorizontalSeparator.klass, "setFocus", VALUEFUNC(_wrap_FXHorizontalSeparator_setFocus), -1);
    rb_define_method(cFXHorizontalSeparator.klass, "killFocus", VALUEFUNC(_wrap_FXHorizontalSeparator_killFocus), -1);
    rb_define_method(cFXHorizontalSeparator.klass, "setDefault", VALUEFUNC(_wrap_FXHorizontalSeparator_setDefault), -1);
    rb_define_method(cFXHorizontalSeparator.klass, "enable", VALUEFUNC(_wrap_FXHorizontalSeparator_enable), -1);
    rb_define_method(cFXHorizontalSeparator.klass, "disable", VALUEFUNC(_wrap_FXHorizontalSeparator_disable), -1);
    rb_define_method(cFXHorizontalSeparator.klass, "raiseWindow", VALUEFUNC(_wrap_FXHorizontalSeparator_raiseWindow), -1);
    rb_define_method(cFXHorizontalSeparator.klass, "lower", VALUEFUNC(_wrap_FXHorizontalSeparator_lower), -1);
    rb_define_method(cFXHorizontalSeparator.klass, "move", VALUEFUNC(_wrap_FXHorizontalSeparator_move), -1);
    rb_define_method(cFXHorizontalSeparator.klass, "position", VALUEFUNC(_wrap_FXHorizontalSeparator_position), -1);
    rb_define_method(cFXHorizontalSeparator.klass, "layout", VALUEFUNC(_wrap_FXHorizontalSeparator_layout), -1);
    rb_define_method(cFXHorizontalSeparator.klass, "recalc", VALUEFUNC(_wrap_FXHorizontalSeparator_recalc), -1);
    rb_define_method(cFXHorizontalSeparator.klass, "reparent", VALUEFUNC(_wrap_FXHorizontalSeparator_reparent), -1);
    rb_define_method(cFXHorizontalSeparator.klass, "show", VALUEFUNC(_wrap_FXHorizontalSeparator_show), -1);
    rb_define_method(cFXHorizontalSeparator.klass, "hide", VALUEFUNC(_wrap_FXHorizontalSeparator_hide), -1);
    rb_define_method(cFXHorizontalSeparator.klass, "isComposite", VALUEFUNC(_wrap_FXHorizontalSeparator_isComposite), -1);
    rb_define_method(cFXHorizontalSeparator.klass, "contains", VALUEFUNC(_wrap_FXHorizontalSeparator_contains), -1);
    rb_define_method(cFXHorizontalSeparator.klass, "doesSaveUnder", VALUEFUNC(_wrap_FXHorizontalSeparator_doesSaveUnder), -1);
    rb_define_method(cFXHorizontalSeparator.klass, "setBackColor", VALUEFUNC(_wrap_FXHorizontalSeparator_setBackColor), -1);
    cFXHorizontalSeparator.mark = (void (*)(void *)) FXRbHorizontalSeparator::markfunc;
    cFXHorizontalSeparator.destroy = (void (*)(void *)) FXRbObject::freefunc;
    
    cFXVerticalSeparator.klass = rb_define_class_under(mFox, "FXVerticalSeparator", ((swig_class *) SWIGTYPE_p_FXSeparator->clientdata)->klass);
    SWIG_TypeClientData(SWIGTYPE_p_FXVerticalSeparator, (void *) &cFXVerticalSeparator);
    rb_define_alloc_func(cFXVerticalSeparator.klass, _wrap_FXVerticalSeparator_allocate);
    rb_define_method(cFXVerticalSeparator.klass, "initialize", VALUEFUNC(_wrap_new_FXVerticalSeparator), -1);
    rb_define_method(cFXVerticalSeparator.klass, "save", VALUEFUNC(_wrap_FXVerticalSeparator_save), -1);
    rb_define_method(cFXVerticalSeparator.klass, "load", VALUEFUNC(_wrap_FXVerticalSeparator_load), -1);
    rb_define_method(cFXVerticalSeparator.klass, "create", VALUEFUNC(_wrap_FXVerticalSeparator_create), -1);
    rb_define_method(cFXVerticalSeparator.klass, "detach", VALUEFUNC(_wrap_FXVerticalSeparator_detach), -1);
    rb_define_method(cFXVerticalSeparator.klass, "destroy", VALUEFUNC(_wrap_FXVerticalSeparator_destroy), -1);
    rb_define_method(cFXVerticalSeparator.klass, "resize", VALUEFUNC(_wrap_FXVerticalSeparator_resize), -1);
    rb_define_method(cFXVerticalSeparator.klass, "getDefaultWidth", VALUEFUNC(_wrap_FXVerticalSeparator_getDefaultWidth), -1);
    rb_define_method(cFXVerticalSeparator.klass, "getDefaultHeight", VALUEFUNC(_wrap_FXVerticalSeparator_getDefaultHeight), -1);
    rb_define_method(cFXVerticalSeparator.klass, "getWidthForHeight", VALUEFUNC(_wrap_FXVerticalSeparator_getWidthForHeight), -1);
    rb_define_method(cFXVerticalSeparator.klass, "getHeightForWidth", VALUEFUNC(_wrap_FXVerticalSeparator_getHeightForWidth), -1);
    rb_define_method(cFXVerticalSeparator.klass, "canFocus", VALUEFUNC(_wrap_FXVerticalSeparator_canFocus), -1);
    rb_define_method(cFXVerticalSeparator.klass, "setFocus", VALUEFUNC(_wrap_FXVerticalSeparator_setFocus), -1);
    rb_define_method(cFXVerticalSeparator.klass, "killFocus", VALUEFUNC(_wrap_FXVerticalSeparator_killFocus), -1);
    rb_define_method(cFXVerticalSeparator.klass, "setDefault", VALUEFUNC(_wrap_FXVerticalSeparator_setDefault), -1);
    rb_define_method(cFXVerticalSeparator.klass, "enable", VALUEFUNC(_wrap_FXVerticalSeparator_enable), -1);
    rb_define_method(cFXVerticalSeparator.klass, "disable", VALUEFUNC(_wrap_FXVerticalSeparator_disable), -1);
    rb_define_method(cFXVerticalSeparator.klass, "raiseWindow", VALUEFUNC(_wrap_FXVerticalSeparator_raiseWindow), -1);
    rb_define_method(cFXVerticalSeparator.klass, "lower", VALUEFUNC(_wrap_FXVerticalSeparator_lower), -1);
    rb_define_method(cFXVerticalSeparator.klass, "move", VALUEFUNC(_wrap_FXVerticalSeparator_move), -1);
    rb_define_method(cFXVerticalSeparator.klass, "position", VALUEFUNC(_wrap_FXVerticalSeparator_position), -1);
    rb_define_method(cFXVerticalSeparator.klass, "layout", VALUEFUNC(_wrap_FXVerticalSeparator_layout), -1);
    rb_define_method(cFXVerticalSeparator.klass, "recalc", VALUEFUNC(_wrap_FXVerticalSeparator_recalc), -1);
    rb_define_method(cFXVerticalSeparator.klass, "reparent", VALUEFUNC(_wrap_FXVerticalSeparator_reparent), -1);
    rb_define_method(cFXVerticalSeparator.klass, "show", VALUEFUNC(_wrap_FXVerticalSeparator_show), -1);
    rb_define_method(cFXVerticalSeparator.klass, "hide", VALUEFUNC(_wrap_FXVerticalSeparator_hide), -1);
    rb_define_method(cFXVerticalSeparator.klass, "isComposite", VALUEFUNC(_wrap_FXVerticalSeparator_isComposite), -1);
    rb_define_method(cFXVerticalSeparator.klass, "contains", VALUEFUNC(_wrap_FXVerticalSeparator_contains), -1);
    rb_define_method(cFXVerticalSeparator.klass, "doesSaveUnder", VALUEFUNC(_wrap_FXVerticalSeparator_doesSaveUnder), -1);
    rb_define_method(cFXVerticalSeparator.klass, "setBackColor", VALUEFUNC(_wrap_FXVerticalSeparator_setBackColor), -1);
    cFXVerticalSeparator.mark = (void (*)(void *)) FXRbVerticalSeparator::markfunc;
    cFXVerticalSeparator.destroy = (void (*)(void *)) FXRbObject::freefunc;
    rb_define_const(mFox,"SLIDER_HORIZONTAL", INT2NUM(SLIDER_HORIZONTAL));
    rb_define_const(mFox,"SLIDER_VERTICAL", INT2NUM(SLIDER_VERTICAL));
    rb_define_const(mFox,"SLIDER_ARROW_UP", INT2NUM(SLIDER_ARROW_UP));
    rb_define_const(mFox,"SLIDER_ARROW_DOWN", INT2NUM(SLIDER_ARROW_DOWN));
    rb_define_const(mFox,"SLIDER_ARROW_LEFT", INT2NUM(SLIDER_ARROW_LEFT));
    rb_define_const(mFox,"SLIDER_ARROW_RIGHT", INT2NUM(SLIDER_ARROW_RIGHT));
    rb_define_const(mFox,"SLIDER_INSIDE_BAR", INT2NUM(SLIDER_INSIDE_BAR));
    rb_define_const(mFox,"SLIDER_TICKS_TOP", INT2NUM(SLIDER_TICKS_TOP));
    rb_define_const(mFox,"SLIDER_TICKS_BOTTOM", INT2NUM(SLIDER_TICKS_BOTTOM));
    rb_define_const(mFox,"SLIDER_TICKS_LEFT", INT2NUM(SLIDER_TICKS_LEFT));
    rb_define_const(mFox,"SLIDER_TICKS_RIGHT", INT2NUM(SLIDER_TICKS_RIGHT));
    rb_define_const(mFox,"SLIDER_NORMAL", INT2NUM(SLIDER_NORMAL));
    
    cFXSlider.klass = rb_define_class_under(mFox, "FXSlider", ((swig_class *) SWIGTYPE_p_FXFrame->clientdata)->klass);
    SWIG_TypeClientData(SWIGTYPE_p_FXSlider, (void *) &cFXSlider);
    rb_define_alloc_func(cFXSlider.klass, _wrap_FXSlider_allocate);
    rb_define_method(cFXSlider.klass, "initialize", VALUEFUNC(_wrap_new_FXSlider), -1);
    rb_define_method(cFXSlider.klass, "onPaint", VALUEFUNC(_wrap_FXSlider_onPaint), -1);
    rb_define_method(cFXSlider.klass, "onLeftBtnPress", VALUEFUNC(_wrap_FXSlider_onLeftBtnPress), -1);
    rb_define_method(cFXSlider.klass, "onLeftBtnRelease", VALUEFUNC(_wrap_FXSlider_onLeftBtnRelease), -1);
    rb_define_method(cFXSlider.klass, "onMiddleBtnPress", VALUEFUNC(_wrap_FXSlider_onMiddleBtnPress), -1);
    rb_define_method(cFXSlider.klass, "onMiddleBtnRelease", VALUEFUNC(_wrap_FXSlider_onMiddleBtnRelease), -1);
    rb_define_method(cFXSlider.klass, "onMouseWheel", VALUEFUNC(_wrap_FXSlider_onMouseWheel), -1);
    rb_define_method(cFXSlider.klass, "onUngrabbed", VALUEFUNC(_wrap_FXSlider_onUngrabbed), -1);
    rb_define_method(cFXSlider.klass, "onMotion", VALUEFUNC(_wrap_FXSlider_onMotion), -1);
    rb_define_method(cFXSlider.klass, "onAutoSlide", VALUEFUNC(_wrap_FXSlider_onAutoSlide), -1);
    rb_define_method(cFXSlider.klass, "onCmdSetValue", VALUEFUNC(_wrap_FXSlider_onCmdSetValue), -1);
    rb_define_method(cFXSlider.klass, "onCmdSetIntValue", VALUEFUNC(_wrap_FXSlider_onCmdSetIntValue), -1);
    rb_define_method(cFXSlider.klass, "onCmdGetIntValue", VALUEFUNC(_wrap_FXSlider_onCmdGetIntValue), -1);
    rb_define_method(cFXSlider.klass, "onCmdSetRealValue", VALUEFUNC(_wrap_FXSlider_onCmdSetRealValue), -1);
    rb_define_method(cFXSlider.klass, "onCmdGetRealValue", VALUEFUNC(_wrap_FXSlider_onCmdGetRealValue), -1);
    rb_define_method(cFXSlider.klass, "onCmdSetIntRange", VALUEFUNC(_wrap_FXSlider_onCmdSetIntRange), -1);
    rb_define_method(cFXSlider.klass, "onCmdGetIntRange", VALUEFUNC(_wrap_FXSlider_onCmdGetIntRange), -1);
    rb_define_method(cFXSlider.klass, "onCmdSetRealRange", VALUEFUNC(_wrap_FXSlider_onCmdSetRealRange), -1);
    rb_define_method(cFXSlider.klass, "onCmdGetRealRange", VALUEFUNC(_wrap_FXSlider_onCmdGetRealRange), -1);
    rb_define_method(cFXSlider.klass, "onCmdSetHelp", VALUEFUNC(_wrap_FXSlider_onCmdSetHelp), -1);
    rb_define_method(cFXSlider.klass, "onCmdGetHelp", VALUEFUNC(_wrap_FXSlider_onCmdGetHelp), -1);
    rb_define_method(cFXSlider.klass, "onCmdSetTip", VALUEFUNC(_wrap_FXSlider_onCmdSetTip), -1);
    rb_define_method(cFXSlider.klass, "onCmdGetTip", VALUEFUNC(_wrap_FXSlider_onCmdGetTip), -1);
    rb_define_method(cFXSlider.klass, "onQueryHelp", VALUEFUNC(_wrap_FXSlider_onQueryHelp), -1);
    rb_define_method(cFXSlider.klass, "onQueryTip", VALUEFUNC(_wrap_FXSlider_onQueryTip), -1);
    rb_define_const(cFXSlider.klass,"ID_AUTOSLIDE", INT2NUM(FXSlider::ID_AUTOSLIDE));
    rb_define_const(cFXSlider.klass,"ID_LAST", INT2NUM(FXSlider::ID_LAST));
    rb_define_method(cFXSlider.klass, "setValue", VALUEFUNC(_wrap_FXSlider_setValue), -1);
    rb_define_method(cFXSlider.klass, "getValue", VALUEFUNC(_wrap_FXSlider_getValue), -1);
    rb_define_method(cFXSlider.klass, "setRange", VALUEFUNC(_wrap_FXSlider_setRange), -1);
    rb_define_method(cFXSlider.klass, "getRange", VALUEFUNC(_wrap_FXSlider_getRange), -1);
    rb_define_method(cFXSlider.klass, "getSliderStyle", VALUEFUNC(_wrap_FXSlider_getSliderStyle), -1);
    rb_define_method(cFXSlider.klass, "setSliderStyle", VALUEFUNC(_wrap_FXSlider_setSliderStyle), -1);
    rb_define_method(cFXSlider.klass, "getHeadSize", VALUEFUNC(_wrap_FXSlider_getHeadSize), -1);
    rb_define_method(cFXSlider.klass, "setHeadSize", VALUEFUNC(_wrap_FXSlider_setHeadSize), -1);
    rb_define_method(cFXSlider.klass, "getSlotSize", VALUEFUNC(_wrap_FXSlider_getSlotSize), -1);
    rb_define_method(cFXSlider.klass, "setSlotSize", VALUEFUNC(_wrap_FXSlider_setSlotSize), -1);
    rb_define_method(cFXSlider.klass, "getIncrement", VALUEFUNC(_wrap_FXSlider_getIncrement), -1);
    rb_define_method(cFXSlider.klass, "setIncrement", VALUEFUNC(_wrap_FXSlider_setIncrement), -1);
    rb_define_method(cFXSlider.klass, "setTickDelta", VALUEFUNC(_wrap_FXSlider_setTickDelta), -1);
    rb_define_method(cFXSlider.klass, "getTickDelta", VALUEFUNC(_wrap_FXSlider_getTickDelta), -1);
    rb_define_method(cFXSlider.klass, "setSlotColor", VALUEFUNC(_wrap_FXSlider_setSlotColor), -1);
    rb_define_method(cFXSlider.klass, "getSlotColor", VALUEFUNC(_wrap_FXSlider_getSlotColor), -1);
    rb_define_method(cFXSlider.klass, "setHelpText", VALUEFUNC(_wrap_FXSlider_setHelpText), -1);
    rb_define_method(cFXSlider.klass, "getHelpText", VALUEFUNC(_wrap_FXSlider_getHelpText), -1);
    rb_define_method(cFXSlider.klass, "setTipText", VALUEFUNC(_wrap_FXSlider_setTipText), -1);
    rb_define_method(cFXSlider.klass, "getTipText", VALUEFUNC(_wrap_FXSlider_getTipText), -1);
    rb_define_method(cFXSlider.klass, "save", VALUEFUNC(_wrap_FXSlider_save), -1);
    rb_define_method(cFXSlider.klass, "load", VALUEFUNC(_wrap_FXSlider_load), -1);
    rb_define_method(cFXSlider.klass, "create", VALUEFUNC(_wrap_FXSlider_create), -1);
    rb_define_method(cFXSlider.klass, "detach", VALUEFUNC(_wrap_FXSlider_detach), -1);
    rb_define_method(cFXSlider.klass, "destroy", VALUEFUNC(_wrap_FXSlider_destroy), -1);
    rb_define_method(cFXSlider.klass, "resize", VALUEFUNC(_wrap_FXSlider_resize), -1);
    rb_define_method(cFXSlider.klass, "getDefaultWidth", VALUEFUNC(_wrap_FXSlider_getDefaultWidth), -1);
    rb_define_method(cFXSlider.klass, "getDefaultHeight", VALUEFUNC(_wrap_FXSlider_getDefaultHeight), -1);
    rb_define_method(cFXSlider.klass, "getWidthForHeight", VALUEFUNC(_wrap_FXSlider_getWidthForHeight), -1);
    rb_define_method(cFXSlider.klass, "getHeightForWidth", VALUEFUNC(_wrap_FXSlider_getHeightForWidth), -1);
    rb_define_method(cFXSlider.klass, "canFocus", VALUEFUNC(_wrap_FXSlider_canFocus), -1);
    rb_define_method(cFXSlider.klass, "setFocus", VALUEFUNC(_wrap_FXSlider_setFocus), -1);
    rb_define_method(cFXSlider.klass, "killFocus", VALUEFUNC(_wrap_FXSlider_killFocus), -1);
    rb_define_method(cFXSlider.klass, "setDefault", VALUEFUNC(_wrap_FXSlider_setDefault), -1);
    rb_define_method(cFXSlider.klass, "enable", VALUEFUNC(_wrap_FXSlider_enable), -1);
    rb_define_method(cFXSlider.klass, "disable", VALUEFUNC(_wrap_FXSlider_disable), -1);
    rb_define_method(cFXSlider.klass, "raiseWindow", VALUEFUNC(_wrap_FXSlider_raiseWindow), -1);
    rb_define_method(cFXSlider.klass, "lower", VALUEFUNC(_wrap_FXSlider_lower), -1);
    rb_define_method(cFXSlider.klass, "move", VALUEFUNC(_wrap_FXSlider_move), -1);
    rb_define_method(cFXSlider.klass, "position", VALUEFUNC(_wrap_FXSlider_position), -1);
    rb_define_method(cFXSlider.klass, "layout", VALUEFUNC(_wrap_FXSlider_layout), -1);
    rb_define_method(cFXSlider.klass, "recalc", VALUEFUNC(_wrap_FXSlider_recalc), -1);
    rb_define_method(cFXSlider.klass, "reparent", VALUEFUNC(_wrap_FXSlider_reparent), -1);
    rb_define_method(cFXSlider.klass, "show", VALUEFUNC(_wrap_FXSlider_show), -1);
    rb_define_method(cFXSlider.klass, "hide", VALUEFUNC(_wrap_FXSlider_hide), -1);
    rb_define_method(cFXSlider.klass, "isComposite", VALUEFUNC(_wrap_FXSlider_isComposite), -1);
    rb_define_method(cFXSlider.klass, "contains", VALUEFUNC(_wrap_FXSlider_contains), -1);
    rb_define_method(cFXSlider.klass, "doesSaveUnder", VALUEFUNC(_wrap_FXSlider_doesSaveUnder), -1);
    rb_define_method(cFXSlider.klass, "setBackColor", VALUEFUNC(_wrap_FXSlider_setBackColor), -1);
    cFXSlider.mark = (void (*)(void *)) FXRbSlider::markfunc;
    cFXSlider.destroy = (void (*)(void *)) FXRbObject::freefunc;
    rb_define_const(mFox,"REALSLIDER_HORIZONTAL", INT2NUM(REALSLIDER_HORIZONTAL));
    rb_define_const(mFox,"REALSLIDER_VERTICAL", INT2NUM(REALSLIDER_VERTICAL));
    rb_define_const(mFox,"REALSLIDER_ARROW_UP", INT2NUM(REALSLIDER_ARROW_UP));
    rb_define_const(mFox,"REALSLIDER_ARROW_DOWN", INT2NUM(REALSLIDER_ARROW_DOWN));
    rb_define_const(mFox,"REALSLIDER_ARROW_LEFT", INT2NUM(REALSLIDER_ARROW_LEFT));
    rb_define_const(mFox,"REALSLIDER_ARROW_RIGHT", INT2NUM(REALSLIDER_ARROW_RIGHT));
    rb_define_const(mFox,"REALSLIDER_INSIDE_BAR", INT2NUM(REALSLIDER_INSIDE_BAR));
    rb_define_const(mFox,"REALSLIDER_TICKS_TOP", INT2NUM(REALSLIDER_TICKS_TOP));
    rb_define_const(mFox,"REALSLIDER_TICKS_BOTTOM", INT2NUM(REALSLIDER_TICKS_BOTTOM));
    rb_define_const(mFox,"REALSLIDER_TICKS_LEFT", INT2NUM(REALSLIDER_TICKS_LEFT));
    rb_define_const(mFox,"REALSLIDER_TICKS_RIGHT", INT2NUM(REALSLIDER_TICKS_RIGHT));
    rb_define_const(mFox,"REALSLIDER_NORMAL", INT2NUM(REALSLIDER_NORMAL));
    
    cFXRealSlider.klass = rb_define_class_under(mFox, "FXRealSlider", ((swig_class *) SWIGTYPE_p_FXFrame->clientdata)->klass);
    SWIG_TypeClientData(SWIGTYPE_p_FXRealSlider, (void *) &cFXRealSlider);
    rb_define_alloc_func(cFXRealSlider.klass, _wrap_FXRealSlider_allocate);
    rb_define_method(cFXRealSlider.klass, "initialize", VALUEFUNC(_wrap_new_FXRealSlider), -1);
    rb_define_method(cFXRealSlider.klass, "onPaint", VALUEFUNC(_wrap_FXRealSlider_onPaint), -1);
    rb_define_method(cFXRealSlider.klass, "onLeftBtnPress", VALUEFUNC(_wrap_FXRealSlider_onLeftBtnPress), -1);
    rb_define_method(cFXRealSlider.klass, "onLeftBtnRelease", VALUEFUNC(_wrap_FXRealSlider_onLeftBtnRelease), -1);
    rb_define_method(cFXRealSlider.klass, "onMiddleBtnPress", VALUEFUNC(_wrap_FXRealSlider_onMiddleBtnPress), -1);
    rb_define_method(cFXRealSlider.klass, "onMiddleBtnRelease", VALUEFUNC(_wrap_FXRealSlider_onMiddleBtnRelease), -1);
    rb_define_method(cFXRealSlider.klass, "onMouseWheel", VALUEFUNC(_wrap_FXRealSlider_onMouseWheel), -1);
    rb_define_method(cFXRealSlider.klass, "onUngrabbed", VALUEFUNC(_wrap_FXRealSlider_onUngrabbed), -1);
    rb_define_method(cFXRealSlider.klass, "onMotion", VALUEFUNC(_wrap_FXRealSlider_onMotion), -1);
    rb_define_method(cFXRealSlider.klass, "onAutoSlide", VALUEFUNC(_wrap_FXRealSlider_onAutoSlide), -1);
    rb_define_method(cFXRealSlider.klass, "onCmdSetValue", VALUEFUNC(_wrap_FXRealSlider_onCmdSetValue), -1);
    rb_define_method(cFXRealSlider.klass, "onCmdSetIntValue", VALUEFUNC(_wrap_FXRealSlider_onCmdSetIntValue), -1);
    rb_define_method(cFXRealSlider.klass, "onCmdGetIntValue", VALUEFUNC(_wrap_FXRealSlider_onCmdGetIntValue), -1);
    rb_define_method(cFXRealSlider.klass, "onCmdSetRealValue", VALUEFUNC(_wrap_FXRealSlider_onCmdSetRealValue), -1);
    rb_define_method(cFXRealSlider.klass, "onCmdGetRealValue", VALUEFUNC(_wrap_FXRealSlider_onCmdGetRealValue), -1);
    rb_define_method(cFXRealSlider.klass, "onCmdSetIntRange", VALUEFUNC(_wrap_FXRealSlider_onCmdSetIntRange), -1);
    rb_define_method(cFXRealSlider.klass, "onCmdGetIntRange", VALUEFUNC(_wrap_FXRealSlider_onCmdGetIntRange), -1);
    rb_define_method(cFXRealSlider.klass, "onCmdSetRealRange", VALUEFUNC(_wrap_FXRealSlider_onCmdSetRealRange), -1);
    rb_define_method(cFXRealSlider.klass, "onCmdGetRealRange", VALUEFUNC(_wrap_FXRealSlider_onCmdGetRealRange), -1);
    rb_define_method(cFXRealSlider.klass, "onCmdSetHelp", VALUEFUNC(_wrap_FXRealSlider_onCmdSetHelp), -1);
    rb_define_method(cFXRealSlider.klass, "onCmdGetHelp", VALUEFUNC(_wrap_FXRealSlider_onCmdGetHelp), -1);
    rb_define_method(cFXRealSlider.klass, "onCmdSetTip", VALUEFUNC(_wrap_FXRealSlider_onCmdSetTip), -1);
    rb_define_method(cFXRealSlider.klass, "onCmdGetTip", VALUEFUNC(_wrap_FXRealSlider_onCmdGetTip), -1);
    rb_define_method(cFXRealSlider.klass, "onQueryHelp", VALUEFUNC(_wrap_FXRealSlider_onQueryHelp), -1);
    rb_define_method(cFXRealSlider.klass, "onQueryTip", VALUEFUNC(_wrap_FXRealSlider_onQueryTip), -1);
    rb_define_const(cFXRealSlider.klass,"ID_AUTOSLIDE", INT2NUM(FXRealSlider::ID_AUTOSLIDE));
    rb_define_const(cFXRealSlider.klass,"ID_LAST", INT2NUM(FXRealSlider::ID_LAST));
    rb_define_method(cFXRealSlider.klass, "setValue", VALUEFUNC(_wrap_FXRealSlider_setValue), -1);
    rb_define_method(cFXRealSlider.klass, "getValue", VALUEFUNC(_wrap_FXRealSlider_getValue), -1);
    rb_define_method(cFXRealSlider.klass, "setRange", VALUEFUNC(_wrap_FXRealSlider_setRange), -1);
    rb_define_method(cFXRealSlider.klass, "getRange", VALUEFUNC(_wrap_FXRealSlider_getRange), -1);
    rb_define_method(cFXRealSlider.klass, "getSliderStyle", VALUEFUNC(_wrap_FXRealSlider_getSliderStyle), -1);
    rb_define_method(cFXRealSlider.klass, "setSliderStyle", VALUEFUNC(_wrap_FXRealSlider_setSliderStyle), -1);
    rb_define_method(cFXRealSlider.klass, "getHeadSize", VALUEFUNC(_wrap_FXRealSlider_getHeadSize), -1);
    rb_define_method(cFXRealSlider.klass, "setHeadSize", VALUEFUNC(_wrap_FXRealSlider_setHeadSize), -1);
    rb_define_method(cFXRealSlider.klass, "getSlotSize", VALUEFUNC(_wrap_FXRealSlider_getSlotSize), -1);
    rb_define_method(cFXRealSlider.klass, "setSlotSize", VALUEFUNC(_wrap_FXRealSlider_setSlotSize), -1);
    rb_define_method(cFXRealSlider.klass, "getIncrement", VALUEFUNC(_wrap_FXRealSlider_getIncrement), -1);
    rb_define_method(cFXRealSlider.klass, "setIncrement", VALUEFUNC(_wrap_FXRealSlider_setIncrement), -1);
    rb_define_method(cFXRealSlider.klass, "setTickDelta", VALUEFUNC(_wrap_FXRealSlider_setTickDelta), -1);
    rb_define_method(cFXRealSlider.klass, "getTickDelta", VALUEFUNC(_wrap_FXRealSlider_getTickDelta), -1);
    rb_define_method(cFXRealSlider.klass, "setSlotColor", VALUEFUNC(_wrap_FXRealSlider_setSlotColor), -1);
    rb_define_method(cFXRealSlider.klass, "getSlotColor", VALUEFUNC(_wrap_FXRealSlider_getSlotColor), -1);
    rb_define_method(cFXRealSlider.klass, "setHelpText", VALUEFUNC(_wrap_FXRealSlider_setHelpText), -1);
    rb_define_method(cFXRealSlider.klass, "getHelpText", VALUEFUNC(_wrap_FXRealSlider_getHelpText), -1);
    rb_define_method(cFXRealSlider.klass, "setTipText", VALUEFUNC(_wrap_FXRealSlider_setTipText), -1);
    rb_define_method(cFXRealSlider.klass, "getTipText", VALUEFUNC(_wrap_FXRealSlider_getTipText), -1);
    rb_define_method(cFXRealSlider.klass, "save", VALUEFUNC(_wrap_FXRealSlider_save), -1);
    rb_define_method(cFXRealSlider.klass, "load", VALUEFUNC(_wrap_FXRealSlider_load), -1);
    rb_define_method(cFXRealSlider.klass, "create", VALUEFUNC(_wrap_FXRealSlider_create), -1);
    rb_define_method(cFXRealSlider.klass, "detach", VALUEFUNC(_wrap_FXRealSlider_detach), -1);
    rb_define_method(cFXRealSlider.klass, "destroy", VALUEFUNC(_wrap_FXRealSlider_destroy), -1);
    rb_define_method(cFXRealSlider.klass, "resize", VALUEFUNC(_wrap_FXRealSlider_resize), -1);
    rb_define_method(cFXRealSlider.klass, "getDefaultWidth", VALUEFUNC(_wrap_FXRealSlider_getDefaultWidth), -1);
    rb_define_method(cFXRealSlider.klass, "getDefaultHeight", VALUEFUNC(_wrap_FXRealSlider_getDefaultHeight), -1);
    rb_define_method(cFXRealSlider.klass, "getWidthForHeight", VALUEFUNC(_wrap_FXRealSlider_getWidthForHeight), -1);
    rb_define_method(cFXRealSlider.klass, "getHeightForWidth", VALUEFUNC(_wrap_FXRealSlider_getHeightForWidth), -1);
    rb_define_method(cFXRealSlider.klass, "canFocus", VALUEFUNC(_wrap_FXRealSlider_canFocus), -1);
    rb_define_method(cFXRealSlider.klass, "setFocus", VALUEFUNC(_wrap_FXRealSlider_setFocus), -1);
    rb_define_method(cFXRealSlider.klass, "killFocus", VALUEFUNC(_wrap_FXRealSlider_killFocus), -1);
    rb_define_method(cFXRealSlider.klass, "setDefault", VALUEFUNC(_wrap_FXRealSlider_setDefault), -1);
    rb_define_method(cFXRealSlider.klass, "enable", VALUEFUNC(_wrap_FXRealSlider_enable), -1);
    rb_define_method(cFXRealSlider.klass, "disable", VALUEFUNC(_wrap_FXRealSlider_disable), -1);
    rb_define_method(cFXRealSlider.klass, "raiseWindow", VALUEFUNC(_wrap_FXRealSlider_raiseWindow), -1);
    rb_define_method(cFXRealSlider.klass, "lower", VALUEFUNC(_wrap_FXRealSlider_lower), -1);
    rb_define_method(cFXRealSlider.klass, "move", VALUEFUNC(_wrap_FXRealSlider_move), -1);
    rb_define_method(cFXRealSlider.klass, "position", VALUEFUNC(_wrap_FXRealSlider_position), -1);
    rb_define_method(cFXRealSlider.klass, "layout", VALUEFUNC(_wrap_FXRealSlider_layout), -1);
    rb_define_method(cFXRealSlider.klass, "recalc", VALUEFUNC(_wrap_FXRealSlider_recalc), -1);
    rb_define_method(cFXRealSlider.klass, "reparent", VALUEFUNC(_wrap_FXRealSlider_reparent), -1);
    rb_define_method(cFXRealSlider.klass, "show", VALUEFUNC(_wrap_FXRealSlider_show), -1);
    rb_define_method(cFXRealSlider.klass, "hide", VALUEFUNC(_wrap_FXRealSlider_hide), -1);
    rb_define_method(cFXRealSlider.klass, "isComposite", VALUEFUNC(_wrap_FXRealSlider_isComposite), -1);
    rb_define_method(cFXRealSlider.klass, "contains", VALUEFUNC(_wrap_FXRealSlider_contains), -1);
    rb_define_method(cFXRealSlider.klass, "doesSaveUnder", VALUEFUNC(_wrap_FXRealSlider_doesSaveUnder), -1);
    rb_define_method(cFXRealSlider.klass, "setBackColor", VALUEFUNC(_wrap_FXRealSlider_setBackColor), -1);
    cFXRealSlider.mark = (void (*)(void *)) FXRbRealSlider::markfunc;
    cFXRealSlider.destroy = (void (*)(void *)) FXRbObject::freefunc;
    
    cFXStatusLine.klass = rb_define_class_under(mFox, "FXStatusLine", ((swig_class *) SWIGTYPE_p_FXFrame->clientdata)->klass);
    SWIG_TypeClientData(SWIGTYPE_p_FXStatusLine, (void *) &cFXStatusLine);
    rb_define_alloc_func(cFXStatusLine.klass, _wrap_FXStatusLine_allocate);
    rb_define_method(cFXStatusLine.klass, "initialize", VALUEFUNC(_wrap_new_FXStatusLine), -1);
    rb_define_method(cFXStatusLine.klass, "onPaint", VALUEFUNC(_wrap_FXStatusLine_onPaint), -1);
    rb_define_method(cFXStatusLine.klass, "onUpdate", VALUEFUNC(_wrap_FXStatusLine_onUpdate), -1);
    rb_define_method(cFXStatusLine.klass, "onCmdGetStringValue", VALUEFUNC(_wrap_FXStatusLine_onCmdGetStringValue), -1);
    rb_define_method(cFXStatusLine.klass, "onCmdSetStringValue", VALUEFUNC(_wrap_FXStatusLine_onCmdSetStringValue), -1);
    rb_define_method(cFXStatusLine.klass, "setText", VALUEFUNC(_wrap_FXStatusLine_setText), -1);
    rb_define_method(cFXStatusLine.klass, "getText", VALUEFUNC(_wrap_FXStatusLine_getText), -1);
    rb_define_method(cFXStatusLine.klass, "setNormalText", VALUEFUNC(_wrap_FXStatusLine_setNormalText), -1);
    rb_define_method(cFXStatusLine.klass, "getNormalText", VALUEFUNC(_wrap_FXStatusLine_getNormalText), -1);
    rb_define_method(cFXStatusLine.klass, "setFont", VALUEFUNC(_wrap_FXStatusLine_setFont), -1);
    rb_define_method(cFXStatusLine.klass, "getFont", VALUEFUNC(_wrap_FXStatusLine_getFont), -1);
    rb_define_method(cFXStatusLine.klass, "getTextColor", VALUEFUNC(_wrap_FXStatusLine_getTextColor), -1);
    rb_define_method(cFXStatusLine.klass, "setTextColor", VALUEFUNC(_wrap_FXStatusLine_setTextColor), -1);
    rb_define_method(cFXStatusLine.klass, "getTextHighlightColor", VALUEFUNC(_wrap_FXStatusLine_getTextHighlightColor), -1);
    rb_define_method(cFXStatusLine.klass, "setTextHighlightColor", VALUEFUNC(_wrap_FXStatusLine_setTextHighlightColor), -1);
    rb_define_method(cFXStatusLine.klass, "save", VALUEFUNC(_wrap_FXStatusLine_save), -1);
    rb_define_method(cFXStatusLine.klass, "load", VALUEFUNC(_wrap_FXStatusLine_load), -1);
    rb_define_method(cFXStatusLine.klass, "create", VALUEFUNC(_wrap_FXStatusLine_create), -1);
    rb_define_method(cFXStatusLine.klass, "detach", VALUEFUNC(_wrap_FXStatusLine_detach), -1);
    rb_define_method(cFXStatusLine.klass, "destroy", VALUEFUNC(_wrap_FXStatusLine_destroy), -1);
    rb_define_method(cFXStatusLine.klass, "resize", VALUEFUNC(_wrap_FXStatusLine_resize), -1);
    rb_define_method(cFXStatusLine.klass, "getDefaultWidth", VALUEFUNC(_wrap_FXStatusLine_getDefaultWidth), -1);
    rb_define_method(cFXStatusLine.klass, "getDefaultHeight", VALUEFUNC(_wrap_FXStatusLine_getDefaultHeight), -1);
    rb_define_method(cFXStatusLine.klass, "getWidthForHeight", VALUEFUNC(_wrap_FXStatusLine_getWidthForHeight), -1);
    rb_define_method(cFXStatusLine.klass, "getHeightForWidth", VALUEFUNC(_wrap_FXStatusLine_getHeightForWidth), -1);
    rb_define_method(cFXStatusLine.klass, "canFocus", VALUEFUNC(_wrap_FXStatusLine_canFocus), -1);
    rb_define_method(cFXStatusLine.klass, "setFocus", VALUEFUNC(_wrap_FXStatusLine_setFocus), -1);
    rb_define_method(cFXStatusLine.klass, "killFocus", VALUEFUNC(_wrap_FXStatusLine_killFocus), -1);
    rb_define_method(cFXStatusLine.klass, "setDefault", VALUEFUNC(_wrap_FXStatusLine_setDefault), -1);
    rb_define_method(cFXStatusLine.klass, "enable", VALUEFUNC(_wrap_FXStatusLine_enable), -1);
    rb_define_method(cFXStatusLine.klass, "disable", VALUEFUNC(_wrap_FXStatusLine_disable), -1);
    rb_define_method(cFXStatusLine.klass, "raiseWindow", VALUEFUNC(_wrap_FXStatusLine_raiseWindow), -1);
    rb_define_method(cFXStatusLine.klass, "lower", VALUEFUNC(_wrap_FXStatusLine_lower), -1);
    rb_define_method(cFXStatusLine.klass, "move", VALUEFUNC(_wrap_FXStatusLine_move), -1);
    rb_define_method(cFXStatusLine.klass, "position", VALUEFUNC(_wrap_FXStatusLine_position), -1);
    rb_define_method(cFXStatusLine.klass, "layout", VALUEFUNC(_wrap_FXStatusLine_layout), -1);
    rb_define_method(cFXStatusLine.klass, "recalc", VALUEFUNC(_wrap_FXStatusLine_recalc), -1);
    rb_define_method(cFXStatusLine.klass, "reparent", VALUEFUNC(_wrap_FXStatusLine_reparent), -1);
    rb_define_method(cFXStatusLine.klass, "show", VALUEFUNC(_wrap_FXStatusLine_show), -1);
    rb_define_method(cFXStatusLine.klass, "hide", VALUEFUNC(_wrap_FXStatusLine_hide), -1);
    rb_define_method(cFXStatusLine.klass, "isComposite", VALUEFUNC(_wrap_FXStatusLine_isComposite), -1);
    rb_define_method(cFXStatusLine.klass, "contains", VALUEFUNC(_wrap_FXStatusLine_contains), -1);
    rb_define_method(cFXStatusLine.klass, "doesSaveUnder", VALUEFUNC(_wrap_FXStatusLine_doesSaveUnder), -1);
    rb_define_method(cFXStatusLine.klass, "setBackColor", VALUEFUNC(_wrap_FXStatusLine_setBackColor), -1);
    cFXStatusLine.mark = (void (*)(void *)) FXRbStatusLine::markfunc;
    cFXStatusLine.destroy = (void (*)(void *)) FXRbObject::freefunc;
    rb_define_const(mFox,"TEXTFIELD_PASSWD", INT2NUM(TEXTFIELD_PASSWD));
    rb_define_const(mFox,"TEXTFIELD_INTEGER", INT2NUM(TEXTFIELD_INTEGER));
    rb_define_const(mFox,"TEXTFIELD_REAL", INT2NUM(TEXTFIELD_REAL));
    rb_define_const(mFox,"TEXTFIELD_READONLY", INT2NUM(TEXTFIELD_READONLY));
    rb_define_const(mFox,"TEXTFIELD_ENTER_ONLY", INT2NUM(TEXTFIELD_ENTER_ONLY));
    rb_define_const(mFox,"TEXTFIELD_LIMITED", INT2NUM(TEXTFIELD_LIMITED));
    rb_define_const(mFox,"TEXTFIELD_OVERSTRIKE", INT2NUM(TEXTFIELD_OVERSTRIKE));
    rb_define_const(mFox,"TEXTFIELD_AUTOGRAY", INT2NUM(TEXTFIELD_AUTOGRAY));
    rb_define_const(mFox,"TEXTFIELD_AUTOHIDE", INT2NUM(TEXTFIELD_AUTOHIDE));
    rb_define_const(mFox,"TEXTFIELD_NORMAL", INT2NUM(TEXTFIELD_NORMAL));
    
    cFXTextField.klass = rb_define_class_under(mFox, "FXTextField", ((swig_class *) SWIGTYPE_p_FXFrame->clientdata)->klass);
    SWIG_TypeClientData(SWIGTYPE_p_FXTextField, (void *) &cFXTextField);
    rb_define_alloc_func(cFXTextField.klass, _wrap_FXTextField_allocate);
    rb_define_method(cFXTextField.klass, "initialize", VALUEFUNC(_wrap_new_FXTextField), -1);
    rb_define_method(cFXTextField.klass, "onPaint", VALUEFUNC(_wrap_FXTextField_onPaint), -1);
    rb_define_method(cFXTextField.klass, "onUpdate", VALUEFUNC(_wrap_FXTextField_onUpdate), -1);
    rb_define_method(cFXTextField.klass, "onKeyPress", VALUEFUNC(_wrap_FXTextField_onKeyPress), -1);
    rb_define_method(cFXTextField.klass, "onKeyRelease", VALUEFUNC(_wrap_FXTextField_onKeyRelease), -1);
    rb_define_method(cFXTextField.klass, "onLeftBtnPress", VALUEFUNC(_wrap_FXTextField_onLeftBtnPress), -1);
    rb_define_method(cFXTextField.klass, "onLeftBtnRelease", VALUEFUNC(_wrap_FXTextField_onLeftBtnRelease), -1);
    rb_define_method(cFXTextField.klass, "onMiddleBtnPress", VALUEFUNC(_wrap_FXTextField_onMiddleBtnPress), -1);
    rb_define_method(cFXTextField.klass, "onMiddleBtnRelease", VALUEFUNC(_wrap_FXTextField_onMiddleBtnRelease), -1);
    rb_define_method(cFXTextField.klass, "onVerify", VALUEFUNC(_wrap_FXTextField_onVerify), -1);
    rb_define_method(cFXTextField.klass, "onMotion", VALUEFUNC(_wrap_FXTextField_onMotion), -1);
    rb_define_method(cFXTextField.klass, "onSelectionLost", VALUEFUNC(_wrap_FXTextField_onSelectionLost), -1);
    rb_define_method(cFXTextField.klass, "onSelectionGained", VALUEFUNC(_wrap_FXTextField_onSelectionGained), -1);
    rb_define_method(cFXTextField.klass, "onSelectionRequest", VALUEFUNC(_wrap_FXTextField_onSelectionRequest), -1);
    rb_define_method(cFXTextField.klass, "onClipboardLost", VALUEFUNC(_wrap_FXTextField_onClipboardLost), -1);
    rb_define_method(cFXTextField.klass, "onClipboardGained", VALUEFUNC(_wrap_FXTextField_onClipboardGained), -1);
    rb_define_method(cFXTextField.klass, "onClipboardRequest", VALUEFUNC(_wrap_FXTextField_onClipboardRequest), -1);
    rb_define_method(cFXTextField.klass, "onFocusSelf", VALUEFUNC(_wrap_FXTextField_onFocusSelf), -1);
    rb_define_method(cFXTextField.klass, "onFocusIn", VALUEFUNC(_wrap_FXTextField_onFocusIn), -1);
    rb_define_method(cFXTextField.klass, "onFocusOut", VALUEFUNC(_wrap_FXTextField_onFocusOut), -1);
    rb_define_method(cFXTextField.klass, "onBlink", VALUEFUNC(_wrap_FXTextField_onBlink), -1);
    rb_define_method(cFXTextField.klass, "onAutoScroll", VALUEFUNC(_wrap_FXTextField_onAutoScroll), -1);
    rb_define_method(cFXTextField.klass, "onCmdSetValue", VALUEFUNC(_wrap_FXTextField_onCmdSetValue), -1);
    rb_define_method(cFXTextField.klass, "onCmdSetIntValue", VALUEFUNC(_wrap_FXTextField_onCmdSetIntValue), -1);
    rb_define_method(cFXTextField.klass, "onCmdSetRealValue", VALUEFUNC(_wrap_FXTextField_onCmdSetRealValue), -1);
    rb_define_method(cFXTextField.klass, "onCmdSetStringValue", VALUEFUNC(_wrap_FXTextField_onCmdSetStringValue), -1);
    rb_define_method(cFXTextField.klass, "onCmdGetIntValue", VALUEFUNC(_wrap_FXTextField_onCmdGetIntValue), -1);
    rb_define_method(cFXTextField.klass, "onCmdGetRealValue", VALUEFUNC(_wrap_FXTextField_onCmdGetRealValue), -1);
    rb_define_method(cFXTextField.klass, "onCmdGetStringValue", VALUEFUNC(_wrap_FXTextField_onCmdGetStringValue), -1);
    rb_define_method(cFXTextField.klass, "onCmdCursorHome", VALUEFUNC(_wrap_FXTextField_onCmdCursorHome), -1);
    rb_define_method(cFXTextField.klass, "onCmdCursorEnd", VALUEFUNC(_wrap_FXTextField_onCmdCursorEnd), -1);
    rb_define_method(cFXTextField.klass, "onCmdCursorRight", VALUEFUNC(_wrap_FXTextField_onCmdCursorRight), -1);
    rb_define_method(cFXTextField.klass, "onCmdCursorLeft", VALUEFUNC(_wrap_FXTextField_onCmdCursorLeft), -1);
    rb_define_method(cFXTextField.klass, "onCmdCursorWordLeft", VALUEFUNC(_wrap_FXTextField_onCmdCursorWordLeft), -1);
    rb_define_method(cFXTextField.klass, "onCmdCursorWordRight", VALUEFUNC(_wrap_FXTextField_onCmdCursorWordRight), -1);
    rb_define_method(cFXTextField.klass, "onCmdCursorWordStart", VALUEFUNC(_wrap_FXTextField_onCmdCursorWordStart), -1);
    rb_define_method(cFXTextField.klass, "onCmdCursorWordEnd", VALUEFUNC(_wrap_FXTextField_onCmdCursorWordEnd), -1);
    rb_define_method(cFXTextField.klass, "onCmdMark", VALUEFUNC(_wrap_FXTextField_onCmdMark), -1);
    rb_define_method(cFXTextField.klass, "onCmdExtend", VALUEFUNC(_wrap_FXTextField_onCmdExtend), -1);
    rb_define_method(cFXTextField.klass, "onCmdSelectAll", VALUEFUNC(_wrap_FXTextField_onCmdSelectAll), -1);
    rb_define_method(cFXTextField.klass, "onCmdDeselectAll", VALUEFUNC(_wrap_FXTextField_onCmdDeselectAll), -1);
    rb_define_method(cFXTextField.klass, "onCmdCutSel", VALUEFUNC(_wrap_FXTextField_onCmdCutSel), -1);
    rb_define_method(cFXTextField.klass, "onCmdCopySel", VALUEFUNC(_wrap_FXTextField_onCmdCopySel), -1);
    rb_define_method(cFXTextField.klass, "onCmdPasteSel", VALUEFUNC(_wrap_FXTextField_onCmdPasteSel), -1);
    rb_define_method(cFXTextField.klass, "onCmdDeleteSel", VALUEFUNC(_wrap_FXTextField_onCmdDeleteSel), -1);
    rb_define_method(cFXTextField.klass, "onCmdDeleteAll", VALUEFUNC(_wrap_FXTextField_onCmdDeleteAll), -1);
    rb_define_method(cFXTextField.klass, "onCmdOverstString", VALUEFUNC(_wrap_FXTextField_onCmdOverstString), -1);
    rb_define_method(cFXTextField.klass, "onCmdInsertString", VALUEFUNC(_wrap_FXTextField_onCmdInsertString), -1);
    rb_define_method(cFXTextField.klass, "onCmdBackspace", VALUEFUNC(_wrap_FXTextField_onCmdBackspace), -1);
    rb_define_method(cFXTextField.klass, "onCmdDelete", VALUEFUNC(_wrap_FXTextField_onCmdDelete), -1);
    rb_define_method(cFXTextField.klass, "onCmdToggleEditable", VALUEFUNC(_wrap_FXTextField_onCmdToggleEditable), -1);
    rb_define_method(cFXTextField.klass, "onUpdToggleEditable", VALUEFUNC(_wrap_FXTextField_onUpdToggleEditable), -1);
    rb_define_method(cFXTextField.klass, "onCmdToggleOverstrike", VALUEFUNC(_wrap_FXTextField_onCmdToggleOverstrike), -1);
    rb_define_method(cFXTextField.klass, "onUpdToggleOverstrike", VALUEFUNC(_wrap_FXTextField_onUpdToggleOverstrike), -1);
    rb_define_method(cFXTextField.klass, "onUpdHaveSelection", VALUEFUNC(_wrap_FXTextField_onUpdHaveSelection), -1);
    rb_define_method(cFXTextField.klass, "onUpdSelectAll", VALUEFUNC(_wrap_FXTextField_onUpdSelectAll), -1);
    rb_define_method(cFXTextField.klass, "onCmdSetHelp", VALUEFUNC(_wrap_FXTextField_onCmdSetHelp), -1);
    rb_define_method(cFXTextField.klass, "onCmdGetHelp", VALUEFUNC(_wrap_FXTextField_onCmdGetHelp), -1);
    rb_define_method(cFXTextField.klass, "onCmdSetTip", VALUEFUNC(_wrap_FXTextField_onCmdSetTip), -1);
    rb_define_method(cFXTextField.klass, "onCmdGetTip", VALUEFUNC(_wrap_FXTextField_onCmdGetTip), -1);
    rb_define_method(cFXTextField.klass, "onQueryHelp", VALUEFUNC(_wrap_FXTextField_onQueryHelp), -1);
    rb_define_method(cFXTextField.klass, "onQueryTip", VALUEFUNC(_wrap_FXTextField_onQueryTip), -1);
    rb_define_singleton_method(cFXTextField.klass, "textDelimiters", VALUEFUNC(FXTextField_textDelimiters_get), 0);
    rb_define_const(cFXTextField.klass,"ID_CURSOR_HOME", INT2NUM(FXTextField::ID_CURSOR_HOME));
    rb_define_const(cFXTextField.klass,"ID_CURSOR_END", INT2NUM(FXTextField::ID_CURSOR_END));
    rb_define_const(cFXTextField.klass,"ID_CURSOR_RIGHT", INT2NUM(FXTextField::ID_CURSOR_RIGHT));
    rb_define_const(cFXTextField.klass,"ID_CURSOR_LEFT", INT2NUM(FXTextField::ID_CURSOR_LEFT));
    rb_define_const(cFXTextField.klass,"ID_CURSOR_WORD_LEFT", INT2NUM(FXTextField::ID_CURSOR_WORD_LEFT));
    rb_define_const(cFXTextField.klass,"ID_CURSOR_WORD_RIGHT", INT2NUM(FXTextField::ID_CURSOR_WORD_RIGHT));
    rb_define_const(cFXTextField.klass,"ID_CURSOR_WORD_START", INT2NUM(FXTextField::ID_CURSOR_WORD_START));
    rb_define_const(cFXTextField.klass,"ID_CURSOR_WORD_END", INT2NUM(FXTextField::ID_CURSOR_WORD_END));
    rb_define_const(cFXTextField.klass,"ID_MARK", INT2NUM(FXTextField::ID_MARK));
    rb_define_const(cFXTextField.klass,"ID_EXTEND", INT2NUM(FXTextField::ID_EXTEND));
    rb_define_const(cFXTextField.klass,"ID_SELECT_ALL", INT2NUM(FXTextField::ID_SELECT_ALL));
    rb_define_const(cFXTextField.klass,"ID_DESELECT_ALL", INT2NUM(FXTextField::ID_DESELECT_ALL));
    rb_define_const(cFXTextField.klass,"ID_CUT_SEL", INT2NUM(FXTextField::ID_CUT_SEL));
    rb_define_const(cFXTextField.klass,"ID_COPY_SEL", INT2NUM(FXTextField::ID_COPY_SEL));
    rb_define_const(cFXTextField.klass,"ID_PASTE_SEL", INT2NUM(FXTextField::ID_PASTE_SEL));
    rb_define_const(cFXTextField.klass,"ID_DELETE_SEL", INT2NUM(FXTextField::ID_DELETE_SEL));
    rb_define_const(cFXTextField.klass,"ID_DELETE_ALL", INT2NUM(FXTextField::ID_DELETE_ALL));
    rb_define_const(cFXTextField.klass,"ID_OVERST_STRING", INT2NUM(FXTextField::ID_OVERST_STRING));
    rb_define_const(cFXTextField.klass,"ID_INSERT_STRING", INT2NUM(FXTextField::ID_INSERT_STRING));
    rb_define_const(cFXTextField.klass,"ID_BACKSPACE", INT2NUM(FXTextField::ID_BACKSPACE));
    rb_define_const(cFXTextField.klass,"ID_DELETE", INT2NUM(FXTextField::ID_DELETE));
    rb_define_const(cFXTextField.klass,"ID_TOGGLE_EDITABLE", INT2NUM(FXTextField::ID_TOGGLE_EDITABLE));
    rb_define_const(cFXTextField.klass,"ID_TOGGLE_OVERSTRIKE", INT2NUM(FXTextField::ID_TOGGLE_OVERSTRIKE));
    rb_define_const(cFXTextField.klass,"ID_BLINK", INT2NUM(FXTextField::ID_BLINK));
    rb_define_const(cFXTextField.klass,"ID_LAST", INT2NUM(FXTextField::ID_LAST));
    rb_define_method(cFXTextField.klass, "isEditable", VALUEFUNC(_wrap_FXTextField_isEditable), -1);
    rb_define_method(cFXTextField.klass, "setEditable", VALUEFUNC(_wrap_FXTextField_setEditable), -1);
    rb_define_method(cFXTextField.klass, "setCursorPos", VALUEFUNC(_wrap_FXTextField_setCursorPos), -1);
    rb_define_method(cFXTextField.klass, "getCursorPos", VALUEFUNC(_wrap_FXTextField_getCursorPos), -1);
    rb_define_method(cFXTextField.klass, "setAnchorPos", VALUEFUNC(_wrap_FXTextField_setAnchorPos), -1);
    rb_define_method(cFXTextField.klass, "getAnchorPos", VALUEFUNC(_wrap_FXTextField_getAnchorPos), -1);
    rb_define_method(cFXTextField.klass, "setText", VALUEFUNC(_wrap_FXTextField_setText), -1);
    rb_define_method(cFXTextField.klass, "getText", VALUEFUNC(_wrap_FXTextField_getText), -1);
    rb_define_method(cFXTextField.klass, "setFont", VALUEFUNC(_wrap_FXTextField_setFont), -1);
    rb_define_method(cFXTextField.klass, "getFont", VALUEFUNC(_wrap_FXTextField_getFont), -1);
    rb_define_method(cFXTextField.klass, "setTextColor", VALUEFUNC(_wrap_FXTextField_setTextColor), -1);
    rb_define_method(cFXTextField.klass, "getTextColor", VALUEFUNC(_wrap_FXTextField_getTextColor), -1);
    rb_define_method(cFXTextField.klass, "setSelBackColor", VALUEFUNC(_wrap_FXTextField_setSelBackColor), -1);
    rb_define_method(cFXTextField.klass, "getSelBackColor", VALUEFUNC(_wrap_FXTextField_getSelBackColor), -1);
    rb_define_method(cFXTextField.klass, "setSelTextColor", VALUEFUNC(_wrap_FXTextField_setSelTextColor), -1);
    rb_define_method(cFXTextField.klass, "getSelTextColor", VALUEFUNC(_wrap_FXTextField_getSelTextColor), -1);
    rb_define_method(cFXTextField.klass, "setCursorColor", VALUEFUNC(_wrap_FXTextField_setCursorColor), -1);
    rb_define_method(cFXTextField.klass, "getCursorColor", VALUEFUNC(_wrap_FXTextField_getCursorColor), -1);
    rb_define_method(cFXTextField.klass, "setNumColumns", VALUEFUNC(_wrap_FXTextField_setNumColumns), -1);
    rb_define_method(cFXTextField.klass, "getNumColumns", VALUEFUNC(_wrap_FXTextField_getNumColumns), -1);
    rb_define_method(cFXTextField.klass, "setJustify", VALUEFUNC(_wrap_FXTextField_setJustify), -1);
    rb_define_method(cFXTextField.klass, "getJustify", VALUEFUNC(_wrap_FXTextField_getJustify), -1);
    rb_define_method(cFXTextField.klass, "setDelimiters", VALUEFUNC(_wrap_FXTextField_setDelimiters), -1);
    rb_define_method(cFXTextField.klass, "getDelimiters", VALUEFUNC(_wrap_FXTextField_getDelimiters), -1);
    rb_define_method(cFXTextField.klass, "setHelpText", VALUEFUNC(_wrap_FXTextField_setHelpText), -1);
    rb_define_method(cFXTextField.klass, "getHelpText", VALUEFUNC(_wrap_FXTextField_getHelpText), -1);
    rb_define_method(cFXTextField.klass, "setTipText", VALUEFUNC(_wrap_FXTextField_setTipText), -1);
    rb_define_method(cFXTextField.klass, "getTipText", VALUEFUNC(_wrap_FXTextField_getTipText), -1);
    rb_define_method(cFXTextField.klass, "setTextStyle", VALUEFUNC(_wrap_FXTextField_setTextStyle), -1);
    rb_define_method(cFXTextField.klass, "getTextStyle", VALUEFUNC(_wrap_FXTextField_getTextStyle), -1);
    rb_define_method(cFXTextField.klass, "selectAll", VALUEFUNC(_wrap_FXTextField_selectAll), -1);
    rb_define_method(cFXTextField.klass, "setSelection", VALUEFUNC(_wrap_FXTextField_setSelection), -1);
    rb_define_method(cFXTextField.klass, "extendSelection", VALUEFUNC(_wrap_FXTextField_extendSelection), -1);
    rb_define_method(cFXTextField.klass, "killSelection", VALUEFUNC(_wrap_FXTextField_killSelection), -1);
    rb_define_method(cFXTextField.klass, "isPosSelected", VALUEFUNC(_wrap_FXTextField_isPosSelected), -1);
    rb_define_method(cFXTextField.klass, "isPosVisible", VALUEFUNC(_wrap_FXTextField_isPosVisible), -1);
    rb_define_method(cFXTextField.klass, "makePositionVisible", VALUEFUNC(_wrap_FXTextField_makePositionVisible), -1);
    rb_define_method(cFXTextField.klass, "save", VALUEFUNC(_wrap_FXTextField_save), -1);
    rb_define_method(cFXTextField.klass, "load", VALUEFUNC(_wrap_FXTextField_load), -1);
    rb_define_method(cFXTextField.klass, "create", VALUEFUNC(_wrap_FXTextField_create), -1);
    rb_define_method(cFXTextField.klass, "detach", VALUEFUNC(_wrap_FXTextField_detach), -1);
    rb_define_method(cFXTextField.klass, "destroy", VALUEFUNC(_wrap_FXTextField_destroy), -1);
    rb_define_method(cFXTextField.klass, "resize", VALUEFUNC(_wrap_FXTextField_resize), -1);
    rb_define_method(cFXTextField.klass, "getDefaultWidth", VALUEFUNC(_wrap_FXTextField_getDefaultWidth), -1);
    rb_define_method(cFXTextField.klass, "getDefaultHeight", VALUEFUNC(_wrap_FXTextField_getDefaultHeight), -1);
    rb_define_method(cFXTextField.klass, "getWidthForHeight", VALUEFUNC(_wrap_FXTextField_getWidthForHeight), -1);
    rb_define_method(cFXTextField.klass, "getHeightForWidth", VALUEFUNC(_wrap_FXTextField_getHeightForWidth), -1);
    rb_define_method(cFXTextField.klass, "canFocus", VALUEFUNC(_wrap_FXTextField_canFocus), -1);
    rb_define_method(cFXTextField.klass, "setFocus", VALUEFUNC(_wrap_FXTextField_setFocus), -1);
    rb_define_method(cFXTextField.klass, "killFocus", VALUEFUNC(_wrap_FXTextField_killFocus), -1);
    rb_define_method(cFXTextField.klass, "setDefault", VALUEFUNC(_wrap_FXTextField_setDefault), -1);
    rb_define_method(cFXTextField.klass, "enable", VALUEFUNC(_wrap_FXTextField_enable), -1);
    rb_define_method(cFXTextField.klass, "disable", VALUEFUNC(_wrap_FXTextField_disable), -1);
    rb_define_method(cFXTextField.klass, "raiseWindow", VALUEFUNC(_wrap_FXTextField_raiseWindow), -1);
    rb_define_method(cFXTextField.klass, "lower", VALUEFUNC(_wrap_FXTextField_lower), -1);
    rb_define_method(cFXTextField.klass, "move", VALUEFUNC(_wrap_FXTextField_move), -1);
    rb_define_method(cFXTextField.klass, "position", VALUEFUNC(_wrap_FXTextField_position), -1);
    rb_define_method(cFXTextField.klass, "layout", VALUEFUNC(_wrap_FXTextField_layout), -1);
    rb_define_method(cFXTextField.klass, "recalc", VALUEFUNC(_wrap_FXTextField_recalc), -1);
    rb_define_method(cFXTextField.klass, "reparent", VALUEFUNC(_wrap_FXTextField_reparent), -1);
    rb_define_method(cFXTextField.klass, "show", VALUEFUNC(_wrap_FXTextField_show), -1);
    rb_define_method(cFXTextField.klass, "hide", VALUEFUNC(_wrap_FXTextField_hide), -1);
    rb_define_method(cFXTextField.klass, "isComposite", VALUEFUNC(_wrap_FXTextField_isComposite), -1);
    rb_define_method(cFXTextField.klass, "contains", VALUEFUNC(_wrap_FXTextField_contains), -1);
    rb_define_method(cFXTextField.klass, "doesSaveUnder", VALUEFUNC(_wrap_FXTextField_doesSaveUnder), -1);
    rb_define_method(cFXTextField.klass, "setBackColor", VALUEFUNC(_wrap_FXTextField_setBackColor), -1);
    cFXTextField.mark = (void (*)(void *)) FXRbTextField::markfunc;
    cFXTextField.destroy = (void (*)(void *)) FXRbObject::freefunc;
    rb_define_const(mFox,"TOOLBARTAB_HORIZONTAL", INT2NUM(TOOLBARTAB_HORIZONTAL));
    rb_define_const(mFox,"TOOLBARTAB_VERTICAL", INT2NUM(TOOLBARTAB_VERTICAL));
    
    cFXToolBarTab.klass = rb_define_class_under(mFox, "FXToolBarTab", ((swig_class *) SWIGTYPE_p_FXFrame->clientdata)->klass);
    SWIG_TypeClientData(SWIGTYPE_p_FXToolBarTab, (void *) &cFXToolBarTab);
    rb_define_alloc_func(cFXToolBarTab.klass, _wrap_FXToolBarTab_allocate);
    rb_define_method(cFXToolBarTab.klass, "initialize", VALUEFUNC(_wrap_new_FXToolBarTab), -1);
    rb_define_method(cFXToolBarTab.klass, "onPaint", VALUEFUNC(_wrap_FXToolBarTab_onPaint), -1);
    rb_define_method(cFXToolBarTab.klass, "onUpdate", VALUEFUNC(_wrap_FXToolBarTab_onUpdate), -1);
    rb_define_method(cFXToolBarTab.klass, "onEnter", VALUEFUNC(_wrap_FXToolBarTab_onEnter), -1);
    rb_define_method(cFXToolBarTab.klass, "onLeave", VALUEFUNC(_wrap_FXToolBarTab_onLeave), -1);
    rb_define_method(cFXToolBarTab.klass, "onUngrabbed", VALUEFUNC(_wrap_FXToolBarTab_onUngrabbed), -1);
    rb_define_method(cFXToolBarTab.klass, "onLeftBtnPress", VALUEFUNC(_wrap_FXToolBarTab_onLeftBtnPress), -1);
    rb_define_method(cFXToolBarTab.klass, "onLeftBtnRelease", VALUEFUNC(_wrap_FXToolBarTab_onLeftBtnRelease), -1);
    rb_define_method(cFXToolBarTab.klass, "onKeyPress", VALUEFUNC(_wrap_FXToolBarTab_onKeyPress), -1);
    rb_define_method(cFXToolBarTab.klass, "onKeyRelease", VALUEFUNC(_wrap_FXToolBarTab_onKeyRelease), -1);
    rb_define_method(cFXToolBarTab.klass, "onCmdCollapse", VALUEFUNC(_wrap_FXToolBarTab_onCmdCollapse), -1);
    rb_define_method(cFXToolBarTab.klass, "onUpdCollapse", VALUEFUNC(_wrap_FXToolBarTab_onUpdCollapse), -1);
    rb_define_method(cFXToolBarTab.klass, "onCmdUncollapse", VALUEFUNC(_wrap_FXToolBarTab_onCmdUncollapse), -1);
    rb_define_method(cFXToolBarTab.klass, "onUpdUncollapse", VALUEFUNC(_wrap_FXToolBarTab_onUpdUncollapse), -1);
    rb_define_const(cFXToolBarTab.klass,"ID_COLLAPSE", INT2NUM(FXToolBarTab::ID_COLLAPSE));
    rb_define_const(cFXToolBarTab.klass,"ID_UNCOLLAPSE", INT2NUM(FXToolBarTab::ID_UNCOLLAPSE));
    rb_define_const(cFXToolBarTab.klass,"ID_LAST", INT2NUM(FXToolBarTab::ID_LAST));
    rb_define_method(cFXToolBarTab.klass, "collapse", VALUEFUNC(_wrap_FXToolBarTab_collapse), -1);
    rb_define_method(cFXToolBarTab.klass, "isCollapsed", VALUEFUNC(_wrap_FXToolBarTab_isCollapsed), -1);
    rb_define_method(cFXToolBarTab.klass, "setTabStyle", VALUEFUNC(_wrap_FXToolBarTab_setTabStyle), -1);
    rb_define_method(cFXToolBarTab.klass, "getTabStyle", VALUEFUNC(_wrap_FXToolBarTab_getTabStyle), -1);
    rb_define_method(cFXToolBarTab.klass, "getActiveColor", VALUEFUNC(_wrap_FXToolBarTab_getActiveColor), -1);
    rb_define_method(cFXToolBarTab.klass, "setActiveColor", VALUEFUNC(_wrap_FXToolBarTab_setActiveColor), -1);
    rb_define_method(cFXToolBarTab.klass, "save", VALUEFUNC(_wrap_FXToolBarTab_save), -1);
    rb_define_method(cFXToolBarTab.klass, "load", VALUEFUNC(_wrap_FXToolBarTab_load), -1);
    rb_define_method(cFXToolBarTab.klass, "create", VALUEFUNC(_wrap_FXToolBarTab_create), -1);
    rb_define_method(cFXToolBarTab.klass, "detach", VALUEFUNC(_wrap_FXToolBarTab_detach), -1);
    rb_define_method(cFXToolBarTab.klass, "destroy", VALUEFUNC(_wrap_FXToolBarTab_destroy), -1);
    rb_define_method(cFXToolBarTab.klass, "resize", VALUEFUNC(_wrap_FXToolBarTab_resize), -1);
    rb_define_method(cFXToolBarTab.klass, "getDefaultWidth", VALUEFUNC(_wrap_FXToolBarTab_getDefaultWidth), -1);
    rb_define_method(cFXToolBarTab.klass, "getDefaultHeight", VALUEFUNC(_wrap_FXToolBarTab_getDefaultHeight), -1);
    rb_define_method(cFXToolBarTab.klass, "getWidthForHeight", VALUEFUNC(_wrap_FXToolBarTab_getWidthForHeight), -1);
    rb_define_method(cFXToolBarTab.klass, "getHeightForWidth", VALUEFUNC(_wrap_FXToolBarTab_getHeightForWidth), -1);
    rb_define_method(cFXToolBarTab.klass, "canFocus", VALUEFUNC(_wrap_FXToolBarTab_canFocus), -1);
    rb_define_method(cFXToolBarTab.klass, "setFocus", VALUEFUNC(_wrap_FXToolBarTab_setFocus), -1);
    rb_define_method(cFXToolBarTab.klass, "killFocus", VALUEFUNC(_wrap_FXToolBarTab_killFocus), -1);
    rb_define_method(cFXToolBarTab.klass, "setDefault", VALUEFUNC(_wrap_FXToolBarTab_setDefault), -1);
    rb_define_method(cFXToolBarTab.klass, "enable", VALUEFUNC(_wrap_FXToolBarTab_enable), -1);
    rb_define_method(cFXToolBarTab.klass, "disable", VALUEFUNC(_wrap_FXToolBarTab_disable), -1);
    rb_define_method(cFXToolBarTab.klass, "raiseWindow", VALUEFUNC(_wrap_FXToolBarTab_raiseWindow), -1);
    rb_define_method(cFXToolBarTab.klass, "lower", VALUEFUNC(_wrap_FXToolBarTab_lower), -1);
    rb_define_method(cFXToolBarTab.klass, "move", VALUEFUNC(_wrap_FXToolBarTab_move), -1);
    rb_define_method(cFXToolBarTab.klass, "position", VALUEFUNC(_wrap_FXToolBarTab_position), -1);
    rb_define_method(cFXToolBarTab.klass, "layout", VALUEFUNC(_wrap_FXToolBarTab_layout), -1);
    rb_define_method(cFXToolBarTab.klass, "recalc", VALUEFUNC(_wrap_FXToolBarTab_recalc), -1);
    rb_define_method(cFXToolBarTab.klass, "reparent", VALUEFUNC(_wrap_FXToolBarTab_reparent), -1);
    rb_define_method(cFXToolBarTab.klass, "show", VALUEFUNC(_wrap_FXToolBarTab_show), -1);
    rb_define_method(cFXToolBarTab.klass, "hide", VALUEFUNC(_wrap_FXToolBarTab_hide), -1);
    rb_define_method(cFXToolBarTab.klass, "isComposite", VALUEFUNC(_wrap_FXToolBarTab_isComposite), -1);
    rb_define_method(cFXToolBarTab.klass, "contains", VALUEFUNC(_wrap_FXToolBarTab_contains), -1);
    rb_define_method(cFXToolBarTab.klass, "doesSaveUnder", VALUEFUNC(_wrap_FXToolBarTab_doesSaveUnder), -1);
    rb_define_method(cFXToolBarTab.klass, "setBackColor", VALUEFUNC(_wrap_FXToolBarTab_setBackColor), -1);
    cFXToolBarTab.mark = (void (*)(void *)) FXRbToolBarTab::markfunc;
    cFXToolBarTab.destroy = (void (*)(void *)) FXRbObject::freefunc;
}

