/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 1.3.22
 * 
 * This file is not intended to be easily readable and contains a number of 
 * coding conventions designed to improve portability and efficiency. Do not make
 * changes to this file unless you know what you are doing--modify the SWIG 
 * interface file instead. 
 * ----------------------------------------------------------------------------- */

#define SWIG_NOINCLUDE

#ifdef __cplusplus
template<class T> class SwigValueWrapper {
    T *tt;
public:
    SwigValueWrapper() : tt(0) { }
    SwigValueWrapper(const SwigValueWrapper<T>& rhs) : tt(new T(*rhs.tt)) { }
    SwigValueWrapper(const T& t) : tt(new T(t)) { }
    ~SwigValueWrapper() { delete tt; } 
    SwigValueWrapper& operator=(const T& t) { delete tt; tt = new T(t); return *this; }
    operator T&() const { return *tt; }
    T *operator&() { return tt; }
private:
    SwigValueWrapper& operator=(const SwigValueWrapper<T>& rhs);
};                                                    
#endif

/* ruby.swg */
/* Implementation : RUBY */
#define SWIGRUBY 1

#include "ruby.h"

/* Flags for pointer conversion */
#define SWIG_POINTER_EXCEPTION     0x1
#define SWIG_POINTER_DISOWN        0x2

#define NUM2USHRT(n) (\
    (0 <= NUM2UINT(n) && NUM2UINT(n) <= USHRT_MAX)\
    ? (unsigned short) NUM2UINT(n) \
    : (rb_raise(rb_eArgError, "integer %d out of range of `unsigned short'",\
               NUM2UINT(n)), (short)0)\
)

#define NUM2SHRT(n) (\
    (SHRT_MIN <= NUM2INT(n) && NUM2INT(n) <= SHRT_MAX)\
    ? (short)NUM2INT(n)\
    : (rb_raise(rb_eArgError, "integer %d out of range of `short'",\
               NUM2INT(n)), (short)0)\
)

/* Ruby 1.7 defines NUM2LL(), LL2NUM() and ULL2NUM() macros */
#ifndef NUM2LL
#define NUM2LL(x) NUM2LONG((x))
#endif
#ifndef LL2NUM
#define LL2NUM(x) INT2NUM((long) (x))
#endif
#ifndef ULL2NUM
#define ULL2NUM(x) UINT2NUM((unsigned long) (x))
#endif

/* Ruby 1.7 doesn't (yet) define NUM2ULL() */
#ifndef NUM2ULL
#ifdef HAVE_LONG_LONG
#define NUM2ULL(x) rb_num2ull((x))
#else
#define NUM2ULL(x) NUM2ULONG(x)
#endif
#endif

/*
 * Need to be very careful about how these macros are defined, especially
 * when compiling C++ code or C code with an ANSI C compiler.
 *
 * VALUEFUNC(f) is a macro used to typecast a C function that implements
 * a Ruby method so that it can be passed as an argument to API functions
 * like rb_define_method() and rb_define_singleton_method().
 *
 * VOIDFUNC(f) is a macro used to typecast a C function that implements
 * either the "mark" or "free" stuff for a Ruby Data object, so that it
 * can be passed as an argument to API functions like Data_Wrap_Struct()
 * and Data_Make_Struct().
 */
 
#ifdef __cplusplus
#  ifndef RUBY_METHOD_FUNC /* These definitions should work for Ruby 1.4.6 */
#    define PROTECTFUNC(f) ((VALUE (*)()) f)
#    define VALUEFUNC(f) ((VALUE (*)()) f)
#    define VOIDFUNC(f)  ((void (*)()) f)
#  else
#    ifndef ANYARGS /* These definitions should work for Ruby 1.6 */
#      define PROTECTFUNC(f) ((VALUE (*)()) f)
#      define VALUEFUNC(f) ((VALUE (*)()) f)
#      define VOIDFUNC(f)  ((RUBY_DATA_FUNC) f)
#    else /* These definitions should work for Ruby 1.7+ */
#      define PROTECTFUNC(f) ((VALUE (*)(VALUE)) f)
#      define VALUEFUNC(f) ((VALUE (*)(ANYARGS)) f)
#      define VOIDFUNC(f)  ((RUBY_DATA_FUNC) f)
#    endif
#  endif
#else
#  define VALUEFUNC(f) (f)
#  define VOIDFUNC(f) (f)
#endif

typedef struct {
  VALUE klass;
  VALUE mImpl;
  void  (*mark)(void *);
  void  (*destroy)(void *);
} swig_class;

/* Don't use for expressions have side effect */
#ifndef RB_STRING_VALUE
#define RB_STRING_VALUE(s) (TYPE(s) == T_STRING ? (s) : (*(volatile VALUE *)&(s) = rb_str_to_str(s)))
#endif
#ifndef StringValue
#define StringValue(s) RB_STRING_VALUE(s)
#endif
#ifndef StringValuePtr
#define StringValuePtr(s) RSTRING(RB_STRING_VALUE(s))->ptr
#endif
#ifndef StringValueLen
#define StringValueLen(s) RSTRING(RB_STRING_VALUE(s))->len
#endif
#ifndef SafeStringValue
#define SafeStringValue(v) do {\
    StringValue(v);\
    rb_check_safe_str(v);\
} while (0)
#endif

#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
#define rb_define_alloc_func(klass, func) rb_define_singleton_method((klass), "new", VALUEFUNC((func)), -1)
#define rb_undef_alloc_func(klass) rb_undef_method(CLASS_OF((klass)), "new")
#endif

/* Contract support */

#define SWIG_contract_assert(expr, msg) if (!(expr)) { rb_raise(rb_eRuntimeError, (char *) msg ); } else


/*************************************************************** -*- c -*-
 * ruby/precommon.swg
 *
 * Rename all exported symbols from common.swg, to avoid symbol
 * clashes if multiple interpreters are included
 *
 ************************************************************************/

#define SWIG_TypeRegister    SWIG_Ruby_TypeRegister
#define SWIG_TypeCheck       SWIG_Ruby_TypeCheck
#define SWIG_TypeCast        SWIG_Ruby_TypeCast
#define SWIG_TypeDynamicCast SWIG_Ruby_TypeDynamicCast
#define SWIG_TypeName        SWIG_Ruby_TypeName
#define SWIG_TypePrettyName  SWIG_Ruby_TypePrettyName
#define SWIG_TypeQuery       SWIG_Ruby_TypeQuery
#define SWIG_TypeClientData  SWIG_Ruby_TypeClientData
#define SWIG_PackData        SWIG_Ruby_PackData 
#define SWIG_UnpackData      SWIG_Ruby_UnpackData 

/* Also rename all exported symbols from rubydef.swig */

/* Common SWIG API */
#define SWIG_ConvertPtr(obj, pp, type, flags) \
  SWIG_Ruby_ConvertPtr(obj, pp, type, flags)
#define SWIG_NewPointerObj(p, type, flags) \
  SWIG_Ruby_NewPointerObj(p, type, flags)
#define SWIG_MustGetPtr(p, type, argnum, flags) \
  SWIG_Ruby_MustGetPtr(p, type, argnum, flags)

/* Ruby-specific SWIG API */

#define SWIG_InitRuntime() \
  SWIG_Ruby_InitRuntime()
#define SWIG_define_class(ty) \
  SWIG_Ruby_define_class(ty)
#define SWIG_NewClassInstance(value, ty) \
  SWIG_Ruby_NewClassInstance(value, ty)
#define SWIG_MangleStr(value) \
  SWIG_Ruby_MangleStr(value)
#define SWIG_CheckConvert(value, ty) \
  SWIG_Ruby_CheckConvert(value, ty)
#define SWIG_NewPackedObj(ptr, sz, ty) \
  SWIG_Ruby_NewPackedObj(ptr, sz, ty)
#define SWIG_ConvertPacked(obj, ptr, sz, ty, flags) \
  SWIG_Ruby_ConvertPacked(obj, ptr, sz, ty, flags)


/***********************************************************************
 * common.swg
 *
 *     This file contains generic SWIG runtime support for pointer
 *     type checking as well as a few commonly used macros to control
 *     external linkage.
 *
 * Author : David Beazley (beazley@cs.uchicago.edu)
 *
 * Copyright (c) 1999-2000, The University of Chicago
 * 
 * This file may be freely redistributed without license or fee provided
 * this copyright message remains intact.
 ************************************************************************/

#include <string.h>

#if defined(_WIN32) || defined(__WIN32__) || defined(__CYGWIN__)
#  if defined(_MSC_VER) || defined(__GNUC__)
#    if defined(STATIC_LINKED)
#      define SWIGEXPORT(a) a
#      define SWIGIMPORT(a) extern a
#    else
#      define SWIGEXPORT(a) __declspec(dllexport) a
#      define SWIGIMPORT(a) extern a
#    endif
#  else
#    if defined(__BORLANDC__)
#      define SWIGEXPORT(a) a _export
#      define SWIGIMPORT(a) a _export
#    else
#      define SWIGEXPORT(a) a
#      define SWIGIMPORT(a) a
#    endif
#  endif
#else
#  define SWIGEXPORT(a) a
#  define SWIGIMPORT(a) a
#endif

#ifdef SWIG_GLOBAL
#  define SWIGRUNTIME(a) SWIGEXPORT(a)
#else
#  define SWIGRUNTIME(a) static a
#endif

#ifdef __cplusplus
extern "C" {
#endif

typedef void *(*swig_converter_func)(void *);
typedef struct swig_type_info *(*swig_dycast_func)(void **);

typedef struct swig_type_info {
  const char             *name;
  swig_converter_func     converter;
  const char             *str;
  void                   *clientdata;
  swig_dycast_func        dcast;
  struct swig_type_info  *next;
  struct swig_type_info  *prev;
} swig_type_info;

#ifdef SWIG_NOINCLUDE

SWIGIMPORT(swig_type_info *) SWIG_TypeRegister(swig_type_info *);
SWIGIMPORT(swig_type_info *) SWIG_TypeCheck(char *c, swig_type_info *);
SWIGIMPORT(void *)           SWIG_TypeCast(swig_type_info *, void *);
SWIGIMPORT(swig_type_info *) SWIG_TypeDynamicCast(swig_type_info *, void **);
SWIGIMPORT(const char *)     SWIG_TypeName(const swig_type_info *);
SWIGIMPORT(const char *)     SWIG_TypePrettyName(const swig_type_info *);
SWIGIMPORT(swig_type_info *) SWIG_TypeQuery(const char *);
SWIGIMPORT(void)             SWIG_TypeClientData(swig_type_info *, void *);
SWIGIMPORT(char *)           SWIG_PackData(char *, void *, int);
SWIGIMPORT(char *)           SWIG_UnpackData(char *, void *, int);

#else

static swig_type_info *swig_type_list = 0;
static swig_type_info **swig_type_list_handle = &swig_type_list;

/* Register a type mapping with the type-checking */
SWIGRUNTIME(swig_type_info *)
SWIG_TypeRegister(swig_type_info *ti) {
  swig_type_info *tc, *head, *ret, *next;
  /* Check to see if this type has already been registered */
  tc = *swig_type_list_handle;
  while (tc) {
    if (strcmp(tc->name, ti->name) == 0) {
      /* Already exists in the table.  Just add additional types to the list */
      if (tc->clientdata) ti->clientdata = tc->clientdata;
      head = tc;
      next = tc->next;
      goto l1;
    }
    tc = tc->prev;
  }
  head = ti;
  next = 0;

  /* Place in list */
  ti->prev = *swig_type_list_handle;
  *swig_type_list_handle = ti;

  /* Build linked lists */
  l1:
  ret = head;
  tc = ti + 1;
  /* Patch up the rest of the links */
  while (tc->name) {
    head->next = tc;
    tc->prev = head;
    head = tc;
    tc++;
  }
  if (next) next->prev = head;
  head->next = next;
  return ret;
}

/* Check the typename */
SWIGRUNTIME(swig_type_info *) 
SWIG_TypeCheck(char *c, swig_type_info *ty) {
  swig_type_info *s;
  if (!ty) return 0;        /* Void pointer */
  s = ty->next;             /* First element always just a name */
  do {
    if (strcmp(s->name,c) == 0) {
      if (s == ty->next) return s;
      /* Move s to the top of the linked list */
      s->prev->next = s->next;
      if (s->next) {
        s->next->prev = s->prev;
      }
      /* Insert s as second element in the list */
      s->next = ty->next;
      if (ty->next) ty->next->prev = s;
      ty->next = s;
      s->prev = ty;
      return s;
    }
    s = s->next;
  } while (s && (s != ty->next));
  return 0;
}

/* Cast a pointer up an inheritance hierarchy */
SWIGRUNTIME(void *) 
SWIG_TypeCast(swig_type_info *ty, void *ptr) {
  if ((!ty) || (!ty->converter)) return ptr;
  return (*ty->converter)(ptr);
}

/* Dynamic pointer casting. Down an inheritance hierarchy */
SWIGRUNTIME(swig_type_info *) 
SWIG_TypeDynamicCast(swig_type_info *ty, void **ptr) {
  swig_type_info *lastty = ty;
  if (!ty || !ty->dcast) return ty;
  while (ty && (ty->dcast)) {
    ty = (*ty->dcast)(ptr);
    if (ty) lastty = ty;
  }
  return lastty;
}

/* Return the name associated with this type */
SWIGRUNTIME(const char *)
SWIG_TypeName(const swig_type_info *ty) {
  return ty->name;
}

/* Return the pretty name associated with this type,
   that is an unmangled type name in a form presentable to the user.
*/
SWIGRUNTIME(const char *)
SWIG_TypePrettyName(const swig_type_info *type) {
  /* The "str" field contains the equivalent pretty names of the
     type, separated by vertical-bar characters.  We choose
     to print the last name, as it is often (?) the most
     specific. */
  if (type->str != NULL) {
    const char *last_name = type->str;
    const char *s;
    for (s = type->str; *s; s++)
      if (*s == '|') last_name = s+1;
    return last_name;
  }
  else
    return type->name;
}

/* 
   Compare two type names skipping the space characters, therefore
   "char*" == "char *" and "Class<int>" == "Class<int >", etc.

   Return 0 when the two name types are equivalent, as in
   strncmp, but skipping ' '.
*/
static int
SWIG_TypeNameComp(const char *f1, const char *l1,
		  const char *f2, const char *l2) {
  for (;(f1 != l1) && (f2 != l2); ++f1, ++f2) {
    while ((*f1 == ' ') && (f1 != l1)) ++f1;
    while ((*f2 == ' ') && (f2 != l2)) ++f2;
    if (*f1 != *f2) return *f1 - *f2;
  }
  return (l1 - f1) - (l2 - f2);
}

/*
  Check type equivalence in a name list like <name1>|<name2>|...
*/
static int
SWIG_TypeEquiv(const char *nb, const char *tb) {
  int equiv = 0;
  const char* te = tb + strlen(tb);
  const char* ne = nb;
  while (!equiv && *ne) {
    for (nb = ne; *ne; ++ne) {
      if (*ne == '|') break;
    }
    equiv = SWIG_TypeNameComp(nb, ne, tb, te) == 0;
    if (*ne) ++ne;
  }
  return equiv;
}
  

/* Search for a swig_type_info structure */
SWIGRUNTIME(swig_type_info *)
SWIG_TypeQuery(const char *name) {
  swig_type_info *ty = *swig_type_list_handle;
  while (ty) {
    if (ty->str && (SWIG_TypeEquiv(ty->str,name))) return ty;
    if (ty->name && (strcmp(name,ty->name) == 0)) return ty;
    ty = ty->prev;
  }
  return 0;
}

/* Set the clientdata field for a type */
SWIGRUNTIME(void)
SWIG_TypeClientData(swig_type_info *ti, void *clientdata) {
  swig_type_info *tc, *equiv;
  if (ti->clientdata == clientdata) return;
  ti->clientdata = clientdata;
  equiv = ti->next;
  while (equiv) {
    if (!equiv->converter) {
      tc = *swig_type_list_handle;
      while (tc) {
        if ((strcmp(tc->name, equiv->name) == 0))
          SWIG_TypeClientData(tc,clientdata);
        tc = tc->prev;
      }
    }
    equiv = equiv->next;
  }
}

/* Pack binary data into a string */
SWIGRUNTIME(char *)
SWIG_PackData(char *c, void *ptr, int sz) {
  static char hex[17] = "0123456789abcdef";
  unsigned char *u = (unsigned char *) ptr;
  const unsigned char *eu =  u + sz;
  register unsigned char uu;
  for (; u != eu; ++u) {
    uu = *u;
    *(c++) = hex[(uu & 0xf0) >> 4];
    *(c++) = hex[uu & 0xf];
  }
  return c;
}

/* Unpack binary data from a string */
SWIGRUNTIME(char *)
SWIG_UnpackData(char *c, void *ptr, int sz) {
  register unsigned char uu = 0;
  register int d;
  unsigned char *u = (unsigned char *) ptr;
  const unsigned char *eu =  u + sz;
  for (; u != eu; ++u) {
    d = *(c++);
    if ((d >= '0') && (d <= '9'))
      uu = ((d - '0') << 4);
    else if ((d >= 'a') && (d <= 'f'))
      uu = ((d - ('a'-10)) << 4);
    d = *(c++);
    if ((d >= '0') && (d <= '9'))
      uu |= (d - '0');
    else if ((d >= 'a') && (d <= 'f'))
      uu |= (d - ('a'-10));
    *u = uu;
  }
  return c;
}

#endif

#ifdef __cplusplus
}
#endif

/* rubydec.swg -*- c -*- */
#ifdef __cplusplus
extern "C" {
#endif

SWIGIMPORT(void)   SWIG_Ruby_InitRuntime(void);
SWIGIMPORT(void)   SWIG_Ruby_define_class(swig_type_info *);
SWIGIMPORT(VALUE)  SWIG_Ruby_NewPointerObj(void *, swig_type_info *, int);
SWIGIMPORT(VALUE)  SWIG_Ruby_NewClassInstance(VALUE, swig_type_info *);
SWIGIMPORT(char *) SWIG_Ruby_MangleStr(VALUE);
SWIGIMPORT(int)    SWIG_Ruby_ConvertPtr(VALUE, void**, swig_type_info *, int);
SWIGIMPORT(void *) SWIG_Ruby_MustGetPtr(VALUE, swig_type_info *, int, int);
SWIGIMPORT(int)    SWIG_Ruby_CheckConvert(VALUE, swig_type_info *);
SWIGIMPORT(VALUE)  SWIG_Ruby_NewPackedObj(void *ptr, int sz, swig_type_info *type);
SWIGIMPORT(void)   SWIG_Ruby_ConvertPacked(VALUE obj, void *ptr, int sz, swig_type_info *ty, int flags);

#ifdef __cplusplus
}
#endif


/* -------- TYPES TABLE (BEGIN) -------- */

#define  SWIGTYPE_p_FXDC swig_types[0] 
#define  SWIGTYPE_p_FXObject swig_types[1] 
#define  SWIGTYPE_p_FXScrollArea swig_types[2] 
#define  SWIGTYPE_p_FXWindow swig_types[3] 
#define  SWIGTYPE_p_FXComposite swig_types[4] 
#define  SWIGTYPE_p_FXFont swig_types[5] 
#define  SWIGTYPE_p_FXId swig_types[6] 
#define  SWIGTYPE_p_FXFileDict swig_types[7] 
#define  SWIGTYPE_p_FXStream swig_types[8] 
#define  SWIGTYPE_p_FXDrawable swig_types[9] 
#define  SWIGTYPE_p_FXIconList swig_types[10] 
#define  SWIGTYPE_p_FXIcon swig_types[11] 
#define  SWIGTYPE_p_FXHeader swig_types[12] 
#define  SWIGTYPE_p_FXFileList swig_types[13] 
#define  SWIGTYPE_p_FXIconItem swig_types[14] 
#define  SWIGTYPE_p_FXFileItem swig_types[15] 
static swig_type_info *swig_types[17];

/* -------- TYPES TABLE (END) -------- */

#define SWIG_init    Init_iconlist
#define SWIG_name    "Iconlist"


static void SWIG_AsVal(VALUE obj, int *val)
{
    *val = (int) NUM2INT(obj);
}


#include "FXRbCommon.h"


inline FXColor to_FXColor(VALUE obj){
  if(TYPE(obj)==T_STRING){
    return fxcolorfromname(StringValuePtr(obj));
    }
  else if(TYPE(obj)==T_SYMBOL){
    return fxcolorfromname(rb_id2name(SYM2ID(obj)));
    }
  else{
    return NUM2ULONG(obj);
    }
  }


inline FXString to_FXString(VALUE obj){
  if(!NIL_P(obj)){
    Check_Type(obj,T_STRING);
    return FXString(STR2CSTR(obj));
    }
  else{
    return FXString::null;
    }
  }


inline FXbool to_FXbool(VALUE obj){
  if (obj == Qtrue || obj == Qfalse){
    return (obj == Qtrue) ? TRUE : FALSE;
    }
  else{
    return static_cast<FXbool>(NUM2UINT(obj));
    }
  }


static swig_type_info* FXEventTypeInfo=0;

inline void* to_FXEvent(VALUE obj){
  void* ptr;
  if(!FXEventTypeInfo){
    FXEventTypeInfo=SWIG_TypeQuery("FXEvent *");
    FXASSERT(FXEventTypeInfo!=0);
    }
  SWIG_ConvertPtr(obj,&ptr,FXEventTypeInfo,1);
  return ptr;
  }

FXIconItem *new_FXIconItem(FXString const &text,FXIcon *bi,FXIcon *mi,void *ptr){
      return new FXRbIconItem(text,bi,mi,ptr);
      }
void FXIconItem_setData(FXIconItem *self,VALUE ptr){
      self->setData((void*) ptr);
      }
VALUE FXIconItem_getData(FXIconItem const *self){
      return self->getData() ? (VALUE) self->getData() : Qnil;
      }

swig_class cFXIconItem;
static void free_FXIconItem(FXIconItem *);

static swig_type_info *FXIconItem_dynamic_cast(void **ptr) {
    FXIconItem **ppIconItem = reinterpret_cast<FXIconItem **>(ptr);
    FXFileItem *pFileItem=dynamic_cast<FXFileItem*>(*ppIconItem);
    if(pFileItem){
      *ptr=reinterpret_cast<void*>(pFileItem);
      return SWIG_TypeQuery("FXFileItem *");
      }
    return 0;
}

FXIconList *new_FXIconList(FXComposite *p,FXObject *tgt,FXSelector sel,FXuint opts,FXint x,FXint y,FXint w,FXint h){
      return new FXRbIconList(p,tgt,sel,opts,x,y,w,h);
      }
FXint FXIconList_setItem__SWIG_0(FXIconList *self,FXint index,FXIconItem *item,FXbool notify){
      // Save pointer to the soon-to-be-destroyed item
      FXIconItem* oldItem=self->getItem(index);

      // Do the deed
      if(item->isMemberOf(FXMETACLASS(FXRbIconItem)))
        dynamic_cast<FXRbIconItem*>(item)->owned=1;
      FXint result=self->setItem(index,item,notify);

      // Now zero-out pointers held by still-alive Ruby objects
      FXRbUnregisterRubyObj(oldItem);

      // Done
      return result;
      }
FXint FXIconList_setItem__SWIG_1(FXIconList *self,FXint index,FXString const &text,FXIcon *big,FXIcon *mini,void *ITEMDATA,FXbool notify){
      // Save pointer to the soon-to-be-destroyed item
      FXIconItem* oldItem=self->getItem(index);

      // Do the deed
      FXint result=self->setItem(index,text,big,mini,ITEMDATA,notify);
      
      // Now zero-out pointers held by still-alive Ruby objects
      FXRbUnregisterRubyObj(oldItem);

      // Done
      return result;
      }
FXint FXIconList_insertItem__SWIG_0(FXIconList *self,FXint index,FXIconItem *item,FXbool notify){
      if(item->isMemberOf(FXMETACLASS(FXRbIconItem)))
        dynamic_cast<FXRbIconItem*>(item)->owned=1;
      return self->insertItem(index,item,notify);
      }
FXint FXIconList_appendItem__SWIG_0(FXIconList *self,FXIconItem *item,FXbool notify){
      if(item->isMemberOf(FXMETACLASS(FXRbIconItem)))
        dynamic_cast<FXRbIconItem*>(item)->owned=1;
      return self->appendItem(item,notify);
      }
FXint FXIconList_prependItem__SWIG_0(FXIconList *self,FXIconItem *item,FXbool notify){
      if(item->isMemberOf(FXMETACLASS(FXRbIconItem)))
        dynamic_cast<FXRbIconItem*>(item)->owned=1;
      return self->prependItem(item,notify);
      }
void FXIconList_removeItem(FXIconList *self,FXint index,FXbool notify){
      // Save pointer to the soon-to-be-destroyed item
      FXIconItem* item=self->getItem(index);

      // Do the deed
      self->removeItem(index,notify);

      // Now zero-out pointers held by still-alive Ruby objects
      FXRbUnregisterRubyObj(item);
      }
void FXIconList_clearItems(FXIconList *self,FXbool notify){
      // Save pointers to the soon-to-be-destroyed items
      FXObjectListOf<FXIconItem> items;
      FXint numItems = self->getNumItems();
      for (FXint i = 0; i< numItems; i++) items.append(self->getItem(i));

      // Do the deed
      self->clearItems(notify);

      // Now zero-out pointers held by still-alive Ruby objects
      for (FXint j = 0; j < items.no(); j++) FXRbUnregisterRubyObj(items[j]);
      }
void FXIconList_makeItemVisible__SWIG_1(FXIconList *self,FXIconItem *item){
      FXint numItems=self->getNumItems();
      for(FXint i=0; i<numItems; i++){
        if(self->getItem(i)==item){
          self->makeItemVisible(i);
	  break;
	  }
	}
      }
void FXIconList_setItemData(FXIconList *self,FXint index,VALUE ptr){
      self->setItemData(index, (void*) ptr);
      }
VALUE FXIconList_getItemData(FXIconList const *self,FXint index){
      return self->getItemData(index) ? (VALUE) self->getItemData(index) : Qnil;
      }
VALUE FXIconList_position__SWIG_1(FXIconList const *self){
    FXint x, y;
    self->getPosition(x, y);
    VALUE pos = rb_ary_new();
    rb_ary_push(pos, INT2NUM(x));
    rb_ary_push(pos, INT2NUM(y));
    return pos;
  }

swig_class cFXIconList;
static void free_FXIconList(FXIconList *);

static swig_type_info *FXIconList_dynamic_cast(void **ptr) {
    FXIconList **ppIconList = reinterpret_cast<FXIconList **>(ptr);
    FXFileList *pFileList=dynamic_cast<FXFileList*>(*ppIconList);
    if(pFileList){
      *ptr=reinterpret_cast<void*>(pFileList);
      return SWIG_TypeQuery("FXFileList *");
      }
    return 0;
}

FXFileItem *new_FXFileItem(FXString const &text,FXIcon *bi,FXIcon *mi,void *ptr){
      return new FXRbFileItem(text,bi,mi,ptr);
      }

swig_class cFXFileItem;
static void free_FXFileItem(FXFileItem *);
FXFileList *new_FXFileList(FXComposite *p,FXObject *tgt,FXSelector sel,FXuint opts,FXint x,FXint y,FXint w,FXint h){
      return new FXRbFileList(p,tgt,sel,opts,x,y,w,h);
      }
VALUE FXFileList_position__SWIG_1(FXFileList const *self){
    FXint x, y;
    self->getPosition(x, y);
    VALUE pos = rb_ary_new();
    rb_ary_push(pos, INT2NUM(x));
    rb_ary_push(pos, INT2NUM(y));
    return pos;
  }

swig_class cFXFileList;
static void free_FXFileList(FXFileList *);
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE _wrap_FXIconItem_allocate(VALUE self) {
#else
     static VALUE _wrap_FXIconItem_allocate(int argc, VALUE *argv, VALUE self) {
#endif
         VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_FXIconItem);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
         return vresult; }
static VALUE _wrap_new_FXIconItem(int argc, VALUE *argv, VALUE self) { FXString *arg1 = 0 ; FXIcon *arg2 = (FXIcon *) 0 ;
    FXIcon *arg3 = (FXIcon *) 0 ; void *arg4 = (void *) 0 ; FXIconItem *result; SwigValueWrapper<FXString > p1 ;
    if ((argc < 1) || (argc > 4)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    p1 = to_FXString(argv[0]); arg1 = &p1; if (argc > 1) { SWIG_ConvertPtr(argv[1], (void **) &arg2, SWIGTYPE_p_FXIcon, 1); } 
    if (argc > 2) { SWIG_ConvertPtr(argv[2], (void **) &arg3, SWIGTYPE_p_FXIcon, 1); }  if (argc > 3) {
        SWIG_ConvertPtr(argv[3], (void **) &arg4, 0, 1); }  {
        result = (FXIconItem *)new_FXIconItem((FXString const &)*arg1,arg2,arg3,arg4);
        DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result); if(rb_block_given_p()){ rb_yield(self); }  }  return self; }
static VALUE _wrap_FXIconItem_getText(int argc, VALUE *argv, VALUE self) { FXIconItem *arg1 = (FXIconItem *) 0 ;
    FXString *result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXIconItem, 1); {
        FXString const &_result_ref = ((FXIconItem const *)arg1)->getText(); result = (FXString *) &_result_ref; } 
    vresult = rb_str_new2(result->text()); return vresult; }
static VALUE _wrap_FXIconItem_getBigIcon(int argc, VALUE *argv, VALUE self) { FXIconItem *arg1 = (FXIconItem *) 0 ;
    FXIcon *result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXIconItem, 1);
    result = (FXIcon *)((FXIconItem const *)arg1)->getBigIcon(); {
        swig_type_info *ty = SWIG_TypeDynamicCast(SWIGTYPE_p_FXIcon, (void **) &result); vresult = FXRbGetRubyObj(result, ty); }
     return vresult; }
static VALUE _wrap_FXIconItem_getMiniIcon(int argc, VALUE *argv, VALUE self) { FXIconItem *arg1 = (FXIconItem *) 0 ;
    FXIcon *result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXIconItem, 1);
    result = (FXIcon *)((FXIconItem const *)arg1)->getMiniIcon(); {
        swig_type_info *ty = SWIG_TypeDynamicCast(SWIGTYPE_p_FXIcon, (void **) &result); vresult = FXRbGetRubyObj(result, ty); }
     return vresult; }
static VALUE _wrap_FXIconItem_setData(int argc, VALUE *argv, VALUE self) { FXIconItem *arg1 = (FXIconItem *) 0 ; VALUE arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXIconItem, 1); arg2 = argv[0]; FXIconItem_setData(arg1,arg2);
    return Qnil; }
static VALUE _wrap_FXIconItem_getData(int argc, VALUE *argv, VALUE self) { FXIconItem *arg1 = (FXIconItem *) 0 ; VALUE result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXIconItem, 1);
    result = (VALUE)FXIconItem_getData((FXIconItem const *)arg1); vresult = result; return vresult; }
static VALUE _wrap_FXIconItem_hasFocus(int argc, VALUE *argv, VALUE self) { FXIconItem *arg1 = (FXIconItem *) 0 ; FXbool result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXIconItem, 1); result = (FXbool)((FXIconItem const *)arg1)->hasFocus();
    vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXIconItem_isSelected(int argc, VALUE *argv, VALUE self) { FXIconItem *arg1 = (FXIconItem *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXIconItem, 1); result = (FXbool)((FXIconItem const *)arg1)->isSelected();
    vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXIconItem_isEnabled(int argc, VALUE *argv, VALUE self) { FXIconItem *arg1 = (FXIconItem *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXIconItem, 1); result = (FXbool)((FXIconItem const *)arg1)->isEnabled();
    vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXIconItem_isDraggable(int argc, VALUE *argv, VALUE self) { FXIconItem *arg1 = (FXIconItem *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXIconItem, 1);
    result = (FXbool)((FXIconItem const *)arg1)->isDraggable(); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXIconItem_isIconOwned(int argc, VALUE *argv, VALUE self) { FXIconItem *arg1 = (FXIconItem *) 0 ;
    FXuint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXIconItem, 1);
    result = (FXuint)((FXIconItem const *)arg1)->isIconOwned(); vresult = UINT2NUM(result); return vresult; }
static void
free_FXIconItem(FXIconItem *arg1) {
    delete arg1;
}
static VALUE _wrap_FXIconItem_save(int argc, VALUE *argv, VALUE self) { FXIconItem *arg1 = (FXIconItem *) 0 ;
    FXStream *arg2 = 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXIconItem, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXIconItem_save((FXIconItem const *)arg1,*arg2); return Qnil; }
static VALUE _wrap_FXIconItem_load(int argc, VALUE *argv, VALUE self) { FXIconItem *arg1 = (FXIconItem *) 0 ;
    FXStream *arg2 = 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXIconItem, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXIconItem_load(arg1,*arg2); return Qnil; }
static VALUE _wrap_FXIconItem_draw(int argc, VALUE *argv, VALUE self) { FXIconItem *arg1 = (FXIconItem *) 0 ;
    FXIconList *arg2 = (FXIconList *) 0 ; FXDC *arg3 = 0 ; FXint arg4 ; FXint arg5 ; FXint arg6 ; FXint arg7 ;
    if ((argc < 6) || (argc > 6)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 6)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXIconItem, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXIconList, 1);
    SWIG_ConvertPtr(argv[1], (void **) &arg3, SWIGTYPE_p_FXDC, 1); if (arg3 == NULL) rb_raise(rb_eTypeError, "null reference");
    arg4 = NUM2INT(argv[2]); arg5 = NUM2INT(argv[3]); arg6 = NUM2INT(argv[4]); arg7 = NUM2INT(argv[5]);
    FXIconItem_draw((FXIconItem const *)arg1,(FXIconList const *)arg2,*arg3,arg4,arg5,arg6,arg7); return Qnil; }
static VALUE _wrap_FXIconItem_hitItem(int argc, VALUE *argv, VALUE self) { FXIconItem *arg1 = (FXIconItem *) 0 ;
    FXIconList *arg2 = (FXIconList *) 0 ; FXint arg3 ; FXint arg4 ; FXint arg5 = (FXint) 1 ; FXint arg6 = (FXint) 1 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 3) || (argc > 5))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXIconItem, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXIconList, 1); arg3 = NUM2INT(argv[1]); arg4 = NUM2INT(argv[2]);
    if (argc > 3) { arg5 = NUM2INT(argv[3]); }  if (argc > 4) { arg6 = NUM2INT(argv[4]); } 
    result = (FXint)FXIconItem_hitItem((FXIconItem const *)arg1,(FXIconList const *)arg2,arg3,arg4,arg5,arg6);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXIconItem_drawBigIcon(int argc, VALUE *argv, VALUE self) { FXIconItem *arg1 = (FXIconItem *) 0 ;
    FXIconList *arg2 = (FXIconList *) 0 ; FXDC *arg3 = 0 ; FXint arg4 ; FXint arg5 ; FXint arg6 ; FXint arg7 ;
    if ((argc < 6) || (argc > 6)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 6)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXIconItem, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXIconList, 1);
    SWIG_ConvertPtr(argv[1], (void **) &arg3, SWIGTYPE_p_FXDC, 1); if (arg3 == NULL) rb_raise(rb_eTypeError, "null reference");
    arg4 = NUM2INT(argv[2]); arg5 = NUM2INT(argv[3]); arg6 = NUM2INT(argv[4]); arg7 = NUM2INT(argv[5]);
    FXIconItem_drawBigIcon((FXIconItem const *)arg1,(FXIconList const *)arg2,*arg3,arg4,arg5,arg6,arg7); return Qnil; }
static VALUE _wrap_FXIconItem_drawMiniIcon(int argc, VALUE *argv, VALUE self) { FXIconItem *arg1 = (FXIconItem *) 0 ;
    FXIconList *arg2 = (FXIconList *) 0 ; FXDC *arg3 = 0 ; FXint arg4 ; FXint arg5 ; FXint arg6 ; FXint arg7 ;
    if ((argc < 6) || (argc > 6)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 6)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXIconItem, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXIconList, 1);
    SWIG_ConvertPtr(argv[1], (void **) &arg3, SWIGTYPE_p_FXDC, 1); if (arg3 == NULL) rb_raise(rb_eTypeError, "null reference");
    arg4 = NUM2INT(argv[2]); arg5 = NUM2INT(argv[3]); arg6 = NUM2INT(argv[4]); arg7 = NUM2INT(argv[5]);
    FXIconItem_drawMiniIcon((FXIconItem const *)arg1,(FXIconList const *)arg2,*arg3,arg4,arg5,arg6,arg7); return Qnil; }
static VALUE _wrap_FXIconItem_drawDetails(int argc, VALUE *argv, VALUE self) { FXIconItem *arg1 = (FXIconItem *) 0 ;
    FXIconList *arg2 = (FXIconList *) 0 ; FXDC *arg3 = 0 ; FXint arg4 ; FXint arg5 ; FXint arg6 ; FXint arg7 ;
    if ((argc < 6) || (argc > 6)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 6)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXIconItem, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXIconList, 1);
    SWIG_ConvertPtr(argv[1], (void **) &arg3, SWIGTYPE_p_FXDC, 1); if (arg3 == NULL) rb_raise(rb_eTypeError, "null reference");
    arg4 = NUM2INT(argv[2]); arg5 = NUM2INT(argv[3]); arg6 = NUM2INT(argv[4]); arg7 = NUM2INT(argv[5]);
    FXIconItem_drawDetails((FXIconItem const *)arg1,(FXIconList const *)arg2,*arg3,arg4,arg5,arg6,arg7); return Qnil; }
static VALUE _wrap_FXIconItem_setText(int argc, VALUE *argv, VALUE self) { FXIconItem *arg1 = (FXIconItem *) 0 ;
    FXString *arg2 = 0 ; SwigValueWrapper<FXString > p2 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXIconItem, 1); p2 = to_FXString(argv[0]); arg2 = &p2;
    FXIconItem_setText(arg1,(FXString const &)*arg2); return Qnil; }
static VALUE _wrap_FXIconItem_setBigIcon(int argc, VALUE *argv, VALUE self) { FXIconItem *arg1 = (FXIconItem *) 0 ;
    FXIcon *arg2 = (FXIcon *) 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXIconItem, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXIcon, 1); FXIconItem_setBigIcon(arg1,arg2); return Qnil; }
static VALUE _wrap_FXIconItem_setMiniIcon(int argc, VALUE *argv, VALUE self) { FXIconItem *arg1 = (FXIconItem *) 0 ;
    FXIcon *arg2 = (FXIcon *) 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXIconItem, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXIcon, 1); FXIconItem_setMiniIcon(arg1,arg2); return Qnil; }
static VALUE _wrap_FXIconItem_setFocus(int argc, VALUE *argv, VALUE self) { FXIconItem *arg1 = (FXIconItem *) 0 ; FXbool arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXIconItem, 1); arg2 = to_FXbool(argv[0]); FXIconItem_setFocus(arg1,arg2);
    return Qnil; }
static VALUE _wrap_FXIconItem_setSelected(int argc, VALUE *argv, VALUE self) { FXIconItem *arg1 = (FXIconItem *) 0 ;
    FXbool arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXIconItem, 1); arg2 = to_FXbool(argv[0]);
    FXIconItem_setSelected(arg1,arg2); return Qnil; }
static VALUE _wrap_FXIconItem_setEnabled(int argc, VALUE *argv, VALUE self) { FXIconItem *arg1 = (FXIconItem *) 0 ;
    FXbool arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXIconItem, 1); arg2 = to_FXbool(argv[0]);
    FXIconItem_setEnabled(arg1,arg2); return Qnil; }
static VALUE _wrap_FXIconItem_setDraggable(int argc, VALUE *argv, VALUE self) { FXIconItem *arg1 = (FXIconItem *) 0 ;
    FXbool arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXIconItem, 1); arg2 = to_FXbool(argv[0]);
    FXIconItem_setDraggable(arg1,arg2); return Qnil; }
static VALUE _wrap_FXIconItem_setIconOwned(int argc, VALUE *argv, VALUE self) { FXIconItem *arg1 = (FXIconItem *) 0 ;
    FXuint arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXIconItem, 1); arg2 = NUM2UINT(argv[0]);
    FXIconItem_setIconOwned(arg1,arg2); return Qnil; }
static VALUE _wrap_FXIconItem_getWidth(int argc, VALUE *argv, VALUE self) { FXIconItem *arg1 = (FXIconItem *) 0 ;
    FXIconList *arg2 = (FXIconList *) 0 ; FXint result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXIconItem, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXIconList, 1);
    result = (FXint)FXIconItem_getWidth((FXIconItem const *)arg1,(FXIconList const *)arg2); vresult = INT2NUM(result);
    return vresult; }
static VALUE _wrap_FXIconItem_getHeight(int argc, VALUE *argv, VALUE self) { FXIconItem *arg1 = (FXIconItem *) 0 ;
    FXIconList *arg2 = (FXIconList *) 0 ; FXint result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXIconItem, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXIconList, 1);
    result = (FXint)FXIconItem_getHeight((FXIconItem const *)arg1,(FXIconList const *)arg2); vresult = INT2NUM(result);
    return vresult; }
static VALUE _wrap_FXIconItem_create(int argc, VALUE *argv, VALUE self) { FXIconItem *arg1 = (FXIconItem *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXIconItem, 1); FXIconItem_create(arg1); return Qnil; }
static VALUE _wrap_FXIconItem_detach(int argc, VALUE *argv, VALUE self) { FXIconItem *arg1 = (FXIconItem *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXIconItem, 1); FXIconItem_detach(arg1); return Qnil; }
static VALUE _wrap_FXIconItem_destroy(int argc, VALUE *argv, VALUE self) { FXIconItem *arg1 = (FXIconItem *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXIconItem, 1); FXIconItem_destroy(arg1); return Qnil; }
static VALUE _wrap_FXIconList_onPaint(int argc, VALUE *argv, VALUE self) { FXIconList *arg1 = (FXIconList *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXIconList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onPaint(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXIconList_onEnter(int argc, VALUE *argv, VALUE self) { FXIconList *arg1 = (FXIconList *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXIconList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onEnter(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXIconList_onLeave(int argc, VALUE *argv, VALUE self) { FXIconList *arg1 = (FXIconList *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXIconList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onLeave(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXIconList_onUngrabbed(int argc, VALUE *argv, VALUE self) { FXIconList *arg1 = (FXIconList *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXIconList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onUngrabbed(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXIconList_onKeyPress(int argc, VALUE *argv, VALUE self) { FXIconList *arg1 = (FXIconList *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXIconList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onKeyPress(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXIconList_onKeyRelease(int argc, VALUE *argv, VALUE self) { FXIconList *arg1 = (FXIconList *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXIconList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onKeyRelease(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXIconList_onLeftBtnPress(int argc, VALUE *argv, VALUE self) { FXIconList *arg1 = (FXIconList *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXIconList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onLeftBtnPress(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXIconList_onLeftBtnRelease(int argc, VALUE *argv, VALUE self) { FXIconList *arg1 = (FXIconList *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXIconList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onLeftBtnRelease(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXIconList_onRightBtnPress(int argc, VALUE *argv, VALUE self) { FXIconList *arg1 = (FXIconList *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXIconList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onRightBtnPress(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXIconList_onRightBtnRelease(int argc, VALUE *argv, VALUE self) { FXIconList *arg1 = (FXIconList *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXIconList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onRightBtnRelease(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXIconList_onMotion(int argc, VALUE *argv, VALUE self) { FXIconList *arg1 = (FXIconList *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXIconList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onMotion(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXIconList_onQueryTip(int argc, VALUE *argv, VALUE self) { FXIconList *arg1 = (FXIconList *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXIconList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onQueryTip(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXIconList_onQueryHelp(int argc, VALUE *argv, VALUE self) { FXIconList *arg1 = (FXIconList *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXIconList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onQueryHelp(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXIconList_onTipTimer(int argc, VALUE *argv, VALUE self) { FXIconList *arg1 = (FXIconList *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXIconList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onTipTimer(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXIconList_onCmdSelectAll(int argc, VALUE *argv, VALUE self) { FXIconList *arg1 = (FXIconList *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXIconList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdSelectAll(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXIconList_onCmdDeselectAll(int argc, VALUE *argv, VALUE self) { FXIconList *arg1 = (FXIconList *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXIconList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdDeselectAll(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXIconList_onCmdSelectInverse(int argc, VALUE *argv, VALUE self) { FXIconList *arg1 = (FXIconList *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXIconList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdSelectInverse(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXIconList_onCmdArrangeByRows(int argc, VALUE *argv, VALUE self) { FXIconList *arg1 = (FXIconList *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXIconList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdArrangeByRows(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXIconList_onUpdArrangeByRows(int argc, VALUE *argv, VALUE self) { FXIconList *arg1 = (FXIconList *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXIconList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onUpdArrangeByRows(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXIconList_onCmdArrangeByColumns(int argc, VALUE *argv, VALUE self) { FXIconList *arg1 = (FXIconList *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXIconList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdArrangeByColumns(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXIconList_onUpdArrangeByColumns(int argc, VALUE *argv, VALUE self) { FXIconList *arg1 = (FXIconList *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXIconList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onUpdArrangeByColumns(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXIconList_onCmdShowDetails(int argc, VALUE *argv, VALUE self) { FXIconList *arg1 = (FXIconList *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXIconList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdShowDetails(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXIconList_onUpdShowDetails(int argc, VALUE *argv, VALUE self) { FXIconList *arg1 = (FXIconList *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXIconList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onUpdShowDetails(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXIconList_onCmdShowBigIcons(int argc, VALUE *argv, VALUE self) { FXIconList *arg1 = (FXIconList *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXIconList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdShowBigIcons(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXIconList_onUpdShowBigIcons(int argc, VALUE *argv, VALUE self) { FXIconList *arg1 = (FXIconList *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXIconList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onUpdShowBigIcons(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXIconList_onCmdShowMiniIcons(int argc, VALUE *argv, VALUE self) { FXIconList *arg1 = (FXIconList *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXIconList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdShowMiniIcons(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXIconList_onUpdShowMiniIcons(int argc, VALUE *argv, VALUE self) { FXIconList *arg1 = (FXIconList *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXIconList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onUpdShowMiniIcons(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXIconList_onHeaderChanged(int argc, VALUE *argv, VALUE self) { FXIconList *arg1 = (FXIconList *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXIconList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onHeaderChanged(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXIconList_onHeaderResize(int argc, VALUE *argv, VALUE self) { FXIconList *arg1 = (FXIconList *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXIconList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]);
    arg4 = reinterpret_cast<void*>(NUM2INT(argv[2])); result = (long)(arg1)->onHeaderResize(arg2,arg3,arg4);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXIconList_onFocusIn(int argc, VALUE *argv, VALUE self) { FXIconList *arg1 = (FXIconList *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXIconList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onFocusIn(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXIconList_onFocusOut(int argc, VALUE *argv, VALUE self) { FXIconList *arg1 = (FXIconList *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXIconList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onFocusOut(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXIconList_onClicked(int argc, VALUE *argv, VALUE self) { FXIconList *arg1 = (FXIconList *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXIconList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]);
    arg4 = reinterpret_cast<void*>(NUM2INT(argv[2])); result = (long)(arg1)->onClicked(arg2,arg3,arg4);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXIconList_onDoubleClicked(int argc, VALUE *argv, VALUE self) { FXIconList *arg1 = (FXIconList *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXIconList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]);
    arg4 = reinterpret_cast<void*>(NUM2INT(argv[2])); result = (long)(arg1)->onDoubleClicked(arg2,arg3,arg4);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXIconList_onTripleClicked(int argc, VALUE *argv, VALUE self) { FXIconList *arg1 = (FXIconList *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXIconList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]);
    arg4 = reinterpret_cast<void*>(NUM2INT(argv[2])); result = (long)(arg1)->onTripleClicked(arg2,arg3,arg4);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXIconList_onCommand(int argc, VALUE *argv, VALUE self) { FXIconList *arg1 = (FXIconList *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXIconList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]);
    arg4 = reinterpret_cast<void*>(NUM2INT(argv[2])); result = (long)(arg1)->onCommand(arg2,arg3,arg4);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXIconList_onAutoScroll(int argc, VALUE *argv, VALUE self) { FXIconList *arg1 = (FXIconList *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXIconList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onAutoScroll(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXIconList_onLookupTimer(int argc, VALUE *argv, VALUE self) { FXIconList *arg1 = (FXIconList *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXIconList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onLookupTimer(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXIconList_onCmdSetValue(int argc, VALUE *argv, VALUE self) { FXIconList *arg1 = (FXIconList *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXIconList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]);
    arg4 = reinterpret_cast<void*>(NUM2INT(argv[2])); result = (long)(arg1)->onCmdSetValue(arg2,arg3,arg4);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXIconList_onCmdGetIntValue(int argc, VALUE *argv, VALUE self) { FXIconList *arg1 = (FXIconList *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXIconList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdGetIntValue(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXIconList_onCmdSetIntValue(int argc, VALUE *argv, VALUE self) { FXIconList *arg1 = (FXIconList *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; FXint value4 ;
    VALUE vresult = Qnil; if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXIconList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); {
        value4 = (FXint) NUM2INT(argv[2]); arg4 = static_cast<void*>(&value4); } 
    result = (long)(arg1)->onCmdSetIntValue(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXIconList_ascending(int argc, VALUE *argv, VALUE self) { FXIconItem *arg1 = (FXIconItem *) 0 ;
    FXIconItem *arg2 = (FXIconItem *) 0 ; FXint result; VALUE vresult = Qnil; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXIconItem, 1);
    SWIG_ConvertPtr(argv[1], (void **) &arg2, SWIGTYPE_p_FXIconItem, 1);
    result = (FXint)FXIconList::ascending((FXIconItem const *)arg1,(FXIconItem const *)arg2); vresult = INT2NUM(result);
    return vresult; }
static VALUE _wrap_FXIconList_descending(int argc, VALUE *argv, VALUE self) { FXIconItem *arg1 = (FXIconItem *) 0 ;
    FXIconItem *arg2 = (FXIconItem *) 0 ; FXint result; VALUE vresult = Qnil; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXIconItem, 1);
    SWIG_ConvertPtr(argv[1], (void **) &arg2, SWIGTYPE_p_FXIconItem, 1);
    result = (FXint)FXIconList::descending((FXIconItem const *)arg1,(FXIconItem const *)arg2); vresult = INT2NUM(result);
    return vresult; }
static VALUE _wrap_FXIconList_ascendingCase(int argc, VALUE *argv, VALUE self) { FXIconItem *arg1 = (FXIconItem *) 0 ;
    FXIconItem *arg2 = (FXIconItem *) 0 ; FXint result; VALUE vresult = Qnil; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXIconItem, 1);
    SWIG_ConvertPtr(argv[1], (void **) &arg2, SWIGTYPE_p_FXIconItem, 1);
    result = (FXint)FXIconList::ascendingCase((FXIconItem const *)arg1,(FXIconItem const *)arg2); vresult = INT2NUM(result);
    return vresult; }
static VALUE _wrap_FXIconList_descendingCase(int argc, VALUE *argv, VALUE self) { FXIconItem *arg1 = (FXIconItem *) 0 ;
    FXIconItem *arg2 = (FXIconItem *) 0 ; FXint result; VALUE vresult = Qnil; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXIconItem, 1);
    SWIG_ConvertPtr(argv[1], (void **) &arg2, SWIGTYPE_p_FXIconItem, 1);
    result = (FXint)FXIconList::descendingCase((FXIconItem const *)arg1,(FXIconItem const *)arg2); vresult = INT2NUM(result);
    return vresult; }
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE _wrap_FXIconList_allocate(VALUE self) {
#else
     static VALUE _wrap_FXIconList_allocate(int argc, VALUE *argv, VALUE self) {
#endif
         VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_FXIconList);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
         return vresult; }
static VALUE _wrap_new_FXIconList(int argc, VALUE *argv, VALUE self) { FXComposite *arg1 = (FXComposite *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 = (FXSelector) 0 ; FXuint arg4 = (FXuint) ICONLIST_NORMAL ;
    FXint arg5 = (FXint) 0 ; FXint arg6 = (FXint) 0 ; FXint arg7 = (FXint) 0 ; FXint arg8 = (FXint) 0 ; FXIconList *result;
    if ((argc < 1) || (argc > 8)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXComposite, 1); if (argc > 1) {
        SWIG_ConvertPtr(argv[1], (void **) &arg2, SWIGTYPE_p_FXObject, 1); }  if (argc > 2) { arg3 = NUM2UINT(argv[2]); } 
    if (argc > 3) { arg4 = NUM2UINT(argv[3]); }  if (argc > 4) { arg5 = NUM2INT(argv[4]); }  if (argc > 5) {
        arg6 = NUM2INT(argv[5]); }  if (argc > 6) { arg7 = NUM2INT(argv[6]); }  if (argc > 7) { arg8 = NUM2INT(argv[7]); }  {
        result = (FXIconList *)new_FXIconList(arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8);
        DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result); if(rb_block_given_p()){ rb_yield(self); }  }  return self; }
static VALUE _wrap_FXIconList_getNumItems(int argc, VALUE *argv, VALUE self) { FXIconList *arg1 = (FXIconList *) 0 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXIconList, 1); result = (FXint)((FXIconList const *)arg1)->getNumItems();
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXIconList_getNumRows(int argc, VALUE *argv, VALUE self) { FXIconList *arg1 = (FXIconList *) 0 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXIconList, 1); result = (FXint)((FXIconList const *)arg1)->getNumRows();
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXIconList_getNumCols(int argc, VALUE *argv, VALUE self) { FXIconList *arg1 = (FXIconList *) 0 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXIconList, 1); result = (FXint)((FXIconList const *)arg1)->getNumCols();
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXIconList_getHeader(int argc, VALUE *argv, VALUE self) { FXIconList *arg1 = (FXIconList *) 0 ;
    FXHeader *result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXIconList, 1);
    result = (FXHeader *)((FXIconList const *)arg1)->getHeader(); {
        swig_type_info *ty = SWIG_TypeDynamicCast(SWIGTYPE_p_FXHeader, (void **) &result);
        vresult = FXRbGetRubyObj(result, ty); }  return vresult; }
static VALUE _wrap_FXIconList_appendHeader(int argc, VALUE *argv, VALUE self) { FXIconList *arg1 = (FXIconList *) 0 ;
    FXString *arg2 = 0 ; FXIcon *arg3 = (FXIcon *) 0 ; FXint arg4 = (FXint) 1 ; SwigValueWrapper<FXString > p2 ;
    if ((argc < 1) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXIconList, 1); p2 = to_FXString(argv[0]); arg2 = &p2; if (argc > 1) {
        SWIG_ConvertPtr(argv[1], (void **) &arg3, SWIGTYPE_p_FXIcon, 1); }  if (argc > 2) { arg4 = NUM2INT(argv[2]); } 
    (arg1)->appendHeader((FXString const &)*arg2,arg3,arg4); return Qnil; }
static VALUE _wrap_FXIconList_removeHeader(int argc, VALUE *argv, VALUE self) { FXIconList *arg1 = (FXIconList *) 0 ;
    FXint arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXIconList, 1); arg2 = NUM2INT(argv[0]); {
        if (arg2 < 0 || arg2 >= arg1->getNumHeaders()) { rb_raise(rb_eIndexError, "icon list header index out of bounds"); }  } 
    (arg1)->removeHeader(arg2); return Qnil; }
static VALUE _wrap_FXIconList_setHeaderText(int argc, VALUE *argv, VALUE self) { FXIconList *arg1 = (FXIconList *) 0 ;
    FXint arg2 ; FXString *arg3 = 0 ; SwigValueWrapper<FXString > p3 ; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXIconList, 1); arg2 = NUM2INT(argv[0]);
    p3 = to_FXString(argv[1]); arg3 = &p3; { if (arg2 < 0 || arg2 >= arg1->getNumHeaders()) {
            rb_raise(rb_eIndexError, "icon list header index out of bounds"); }  } 
    (arg1)->setHeaderText(arg2,(FXString const &)*arg3); return Qnil; }
static VALUE _wrap_FXIconList_getHeaderText(int argc, VALUE *argv, VALUE self) { FXIconList *arg1 = (FXIconList *) 0 ;
    FXint arg2 ; FXString result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXIconList, 1); arg2 = NUM2INT(argv[0]); {
        if (arg2 < 0 || arg2 >= arg1->getNumHeaders()) { rb_raise(rb_eIndexError, "icon list header index out of bounds"); }  } 
    result = ((FXIconList const *)arg1)->getHeaderText(arg2); vresult = rb_str_new2((&result)->text()); return vresult; }
static VALUE _wrap_FXIconList_setHeaderIcon(int argc, VALUE *argv, VALUE self) { FXIconList *arg1 = (FXIconList *) 0 ;
    FXint arg2 ; FXIcon *arg3 = (FXIcon *) 0 ; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXIconList, 1); arg2 = NUM2INT(argv[0]);
    SWIG_ConvertPtr(argv[1], (void **) &arg3, SWIGTYPE_p_FXIcon, 1); { if (arg2 < 0 || arg2 >= arg1->getNumHeaders()) {
            rb_raise(rb_eIndexError, "icon list header index out of bounds"); }  }  (arg1)->setHeaderIcon(arg2,arg3);
    return Qnil; }
static VALUE _wrap_FXIconList_getHeaderIcon(int argc, VALUE *argv, VALUE self) { FXIconList *arg1 = (FXIconList *) 0 ;
    FXint arg2 ; FXIcon *result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXIconList, 1); arg2 = NUM2INT(argv[0]); {
        if (arg2 < 0 || arg2 >= arg1->getNumHeaders()) { rb_raise(rb_eIndexError, "icon list header index out of bounds"); }  } 
    result = (FXIcon *)((FXIconList const *)arg1)->getHeaderIcon(arg2); {
        swig_type_info *ty = SWIG_TypeDynamicCast(SWIGTYPE_p_FXIcon, (void **) &result); vresult = FXRbGetRubyObj(result, ty); }
     return vresult; }
static VALUE _wrap_FXIconList_setHeaderSize(int argc, VALUE *argv, VALUE self) { FXIconList *arg1 = (FXIconList *) 0 ;
    FXint arg2 ; FXint arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXIconList, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]); {
        if (arg2 < 0 || arg2 >= arg1->getNumHeaders()) { rb_raise(rb_eIndexError, "icon list header index out of bounds"); }  } 
    (arg1)->setHeaderSize(arg2,arg3); return Qnil; }
static VALUE _wrap_FXIconList_getHeaderSize(int argc, VALUE *argv, VALUE self) { FXIconList *arg1 = (FXIconList *) 0 ;
    FXint arg2 ; FXint result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXIconList, 1); arg2 = NUM2INT(argv[0]); {
        if (arg2 < 0 || arg2 >= arg1->getNumHeaders()) { rb_raise(rb_eIndexError, "icon list header index out of bounds"); }  } 
    result = (FXint)((FXIconList const *)arg1)->getHeaderSize(arg2); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXIconList_getNumHeaders(int argc, VALUE *argv, VALUE self) { FXIconList *arg1 = (FXIconList *) 0 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXIconList, 1);
    result = (FXint)((FXIconList const *)arg1)->getNumHeaders(); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXIconList_getItem(int argc, VALUE *argv, VALUE self) { FXIconList *arg1 = (FXIconList *) 0 ; FXint arg2 ;
    FXIconItem *result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXIconList, 1); arg2 = NUM2INT(argv[0]); {
        if (arg2 < 0 || arg2 >= arg1->getNumItems()) { rb_raise(rb_eIndexError, "icon list item index out of bounds"); }  } 
    result = (FXIconItem *)((FXIconList const *)arg1)->getItem(arg2); {
        swig_type_info *ty = SWIG_TypeDynamicCast(SWIGTYPE_p_FXIconItem, (void **) &result);
        vresult = FXRbGetRubyObj(result, ty); }  return vresult; }
static VALUE _wrap_FXIconList_setItem__SWIG_0(int argc, VALUE *argv, VALUE self) { FXIconList *arg1 = (FXIconList *) 0 ;
    FXint arg2 ; FXIconItem *arg3 = (FXIconItem *) 0 ; FXbool arg4 = (FXbool) 0 ; FXint result; VALUE vresult = Qnil;
    if ((argc < 2) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXIconList, 1); arg2 = NUM2INT(argv[0]);
    SWIG_ConvertPtr(argv[1], (void **) &arg3, SWIGTYPE_p_FXIconItem, 1); if (argc > 2) { arg4 = to_FXbool(argv[2]); }  {
        if (arg2 < 0 || arg2 >= arg1->getNumItems()) { rb_raise(rb_eIndexError, "icon list item index out of bounds"); }  } 
    result = (FXint)FXIconList_setItem__SWIG_0(arg1,arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXIconList_setItem__SWIG_1(int argc, VALUE *argv, VALUE self) { FXIconList *arg1 = (FXIconList *) 0 ;
    FXint arg2 ; FXString *arg3 = 0 ; FXIcon *arg4 = (FXIcon *) 0 ; FXIcon *arg5 = (FXIcon *) 0 ; void *arg6 = (void *) 0 ;
    FXbool arg7 = (FXbool) 0 ; FXint result; SwigValueWrapper<FXString > p3 ; VALUE vresult = Qnil;
    if ((argc < 2) || (argc > 6)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXIconList, 1); arg2 = NUM2INT(argv[0]);
    p3 = to_FXString(argv[1]); arg3 = &p3; if (argc > 2) { SWIG_ConvertPtr(argv[2], (void **) &arg4, SWIGTYPE_p_FXIcon, 1); } 
    if (argc > 3) { SWIG_ConvertPtr(argv[3], (void **) &arg5, SWIGTYPE_p_FXIcon, 1); }  if (argc > 4) {
        arg6 = (argv[4] == Qnil) ? NULL : (void *) argv[4]; }  if (argc > 5) { arg7 = to_FXbool(argv[5]); }  {
        if (arg2 < 0 || arg2 >= arg1->getNumItems()) { rb_raise(rb_eIndexError, "icon list item index out of bounds"); }  } 
    result = (FXint)FXIconList_setItem__SWIG_1(arg1,arg2,(FXString const &)*arg3,arg4,arg5,arg6,arg7);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXIconList_setItem(int nargs, VALUE *args, VALUE self) { int argc; VALUE argv[8]; int ii; argc = nargs + 1;
    argv[0] = self; for (ii = 1; (ii < argc) && (ii < 7); ii++) { argv[ii] = args[ii-1]; }  if ((argc >= 3) && (argc <= 4)) {
        int _v; { void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXIconList, 0) != -1)) ? 1 : 0; }
         if (_v) { { _v = ((TYPE(argv[1]) == T_FIXNUM) || (TYPE(argv[1]) == T_BIGNUM)) ? 1 : 0; }  if (_v) { { void *ptr;
                    _v = (NIL_P(argv[2]) || (TYPE(argv[2]) == T_DATA && SWIG_ConvertPtr(argv[2], &ptr, SWIGTYPE_p_FXIconItem, 0) != -1)) ? 1 : 0; }
                 if (_v) { if (argc <= 3) { return _wrap_FXIconList_setItem__SWIG_0(nargs, args, self);}  {
                        _v = (argv[3] == Qtrue || argv[3] == Qfalse) ? 1 : 0; }  if (_v) {
                        return _wrap_FXIconList_setItem__SWIG_0(nargs, args, self);}  }  }  }  } 
    if ((argc >= 3) && (argc <= 7)) { int _v; { void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXIconList, 0) != -1)) ? 1 : 0; }
         if (_v) { { _v = ((TYPE(argv[1]) == T_FIXNUM) || (TYPE(argv[1]) == T_BIGNUM)) ? 1 : 0; }  if (_v) { {
                    _v = (NIL_P(argv[2]) || TYPE(argv[2]) == T_STRING) ? 1 : 0; }  if (_v) { if (argc <= 3) {
                        return _wrap_FXIconList_setItem__SWIG_1(nargs, args, self);}  { void *ptr;
                        _v = (NIL_P(argv[3]) || (TYPE(argv[3]) == T_DATA && SWIG_ConvertPtr(argv[3], &ptr, SWIGTYPE_p_FXIcon, 0) != -1)) ? 1 : 0; }
                     if (_v) { if (argc <= 4) { return _wrap_FXIconList_setItem__SWIG_1(nargs, args, self);}  { void *ptr;
                            _v = (NIL_P(argv[4]) || (TYPE(argv[4]) == T_DATA && SWIG_ConvertPtr(argv[4], &ptr, SWIGTYPE_p_FXIcon, 0) != -1)) ? 1 : 0; }
                         if (_v) { if (argc <= 5) { return _wrap_FXIconList_setItem__SWIG_1(nargs, args, self);}  { _v = 1; } 
                            if (_v) { if (argc <= 6) { return _wrap_FXIconList_setItem__SWIG_1(nargs, args, self);}  {
                                    _v = (argv[6] == Qtrue || argv[6] == Qfalse) ? 1 : 0; }  if (_v) {
                                    return _wrap_FXIconList_setItem__SWIG_1(nargs, args, self);}  }  }  }  }  }  }  } 
    rb_raise(rb_eArgError, "No matching function for overloaded 'FXIconList_setItem'"); return Qnil; }
static VALUE _wrap_FXIconList_insertItem__SWIG_0(int argc, VALUE *argv, VALUE self) { FXIconList *arg1 = (FXIconList *) 0 ;
    FXint arg2 ; FXIconItem *arg3 = (FXIconItem *) 0 ; FXbool arg4 = (FXbool) 0 ; FXint result; VALUE vresult = Qnil;
    if ((argc < 2) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXIconList, 1); arg2 = NUM2INT(argv[0]);
    SWIG_ConvertPtr(argv[1], (void **) &arg3, SWIGTYPE_p_FXIconItem, 1); if (argc > 2) { arg4 = to_FXbool(argv[2]); }  {
        if (arg2 < 0 || arg2 >= arg1->getNumItems()) { rb_raise(rb_eIndexError, "icon list item index out of bounds"); }  } 
    result = (FXint)FXIconList_insertItem__SWIG_0(arg1,arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXIconList_insertItem__SWIG_1(int argc, VALUE *argv, VALUE self) { FXIconList *arg1 = (FXIconList *) 0 ;
    FXint arg2 ; FXString *arg3 = 0 ; FXIcon *arg4 = (FXIcon *) 0 ; FXIcon *arg5 = (FXIcon *) 0 ; void *arg6 = (void *) 0 ;
    FXbool arg7 = (FXbool) 0 ; FXint result; SwigValueWrapper<FXString > p3 ; VALUE vresult = Qnil;
    if ((argc < 2) || (argc > 6)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXIconList, 1); arg2 = NUM2INT(argv[0]);
    p3 = to_FXString(argv[1]); arg3 = &p3; if (argc > 2) { SWIG_ConvertPtr(argv[2], (void **) &arg4, SWIGTYPE_p_FXIcon, 1); } 
    if (argc > 3) { SWIG_ConvertPtr(argv[3], (void **) &arg5, SWIGTYPE_p_FXIcon, 1); }  if (argc > 4) {
        arg6 = (argv[4] == Qnil) ? NULL : (void *) argv[4]; }  if (argc > 5) { arg7 = to_FXbool(argv[5]); }  {
        if (arg2 < 0 || arg2 >= arg1->getNumItems()) { rb_raise(rb_eIndexError, "icon list item index out of bounds"); }  } 
    result = (FXint)(arg1)->insertItem(arg2,(FXString const &)*arg3,arg4,arg5,arg6,arg7); vresult = INT2NUM(result);
    return vresult; }
static VALUE _wrap_FXIconList_insertItem(int nargs, VALUE *args, VALUE self) { int argc; VALUE argv[8]; int ii;
    argc = nargs + 1; argv[0] = self; for (ii = 1; (ii < argc) && (ii < 7); ii++) { argv[ii] = args[ii-1]; } 
    if ((argc >= 3) && (argc <= 4)) { int _v; { void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXIconList, 0) != -1)) ? 1 : 0; }
         if (_v) { { _v = ((TYPE(argv[1]) == T_FIXNUM) || (TYPE(argv[1]) == T_BIGNUM)) ? 1 : 0; }  if (_v) { { void *ptr;
                    _v = (NIL_P(argv[2]) || (TYPE(argv[2]) == T_DATA && SWIG_ConvertPtr(argv[2], &ptr, SWIGTYPE_p_FXIconItem, 0) != -1)) ? 1 : 0; }
                 if (_v) { if (argc <= 3) { return _wrap_FXIconList_insertItem__SWIG_0(nargs, args, self);}  {
                        _v = (argv[3] == Qtrue || argv[3] == Qfalse) ? 1 : 0; }  if (_v) {
                        return _wrap_FXIconList_insertItem__SWIG_0(nargs, args, self);}  }  }  }  } 
    if ((argc >= 3) && (argc <= 7)) { int _v; { void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXIconList, 0) != -1)) ? 1 : 0; }
         if (_v) { { _v = ((TYPE(argv[1]) == T_FIXNUM) || (TYPE(argv[1]) == T_BIGNUM)) ? 1 : 0; }  if (_v) { {
                    _v = (NIL_P(argv[2]) || TYPE(argv[2]) == T_STRING) ? 1 : 0; }  if (_v) { if (argc <= 3) {
                        return _wrap_FXIconList_insertItem__SWIG_1(nargs, args, self);}  { void *ptr;
                        _v = (NIL_P(argv[3]) || (TYPE(argv[3]) == T_DATA && SWIG_ConvertPtr(argv[3], &ptr, SWIGTYPE_p_FXIcon, 0) != -1)) ? 1 : 0; }
                     if (_v) { if (argc <= 4) { return _wrap_FXIconList_insertItem__SWIG_1(nargs, args, self);}  { void *ptr;
                            _v = (NIL_P(argv[4]) || (TYPE(argv[4]) == T_DATA && SWIG_ConvertPtr(argv[4], &ptr, SWIGTYPE_p_FXIcon, 0) != -1)) ? 1 : 0; }
                         if (_v) { if (argc <= 5) { return _wrap_FXIconList_insertItem__SWIG_1(nargs, args, self);}  { _v = 1; }
                             if (_v) { if (argc <= 6) { return _wrap_FXIconList_insertItem__SWIG_1(nargs, args, self);}  {
                                    _v = (argv[6] == Qtrue || argv[6] == Qfalse) ? 1 : 0; }  if (_v) {
                                    return _wrap_FXIconList_insertItem__SWIG_1(nargs, args, self);}  }  }  }  }  }  }  } 
    rb_raise(rb_eArgError, "No matching function for overloaded 'FXIconList_insertItem'"); return Qnil; }
static VALUE _wrap_FXIconList_appendItem__SWIG_0(int argc, VALUE *argv, VALUE self) { FXIconList *arg1 = (FXIconList *) 0 ;
    FXIconItem *arg2 = (FXIconItem *) 0 ; FXbool arg3 = (FXbool) 0 ; FXint result; VALUE vresult = Qnil;
    if ((argc < 1) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXIconList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXIconItem, 1); if (argc > 1) { arg3 = to_FXbool(argv[1]); } 
    result = (FXint)FXIconList_appendItem__SWIG_0(arg1,arg2,arg3); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXIconList_appendItem__SWIG_1(int argc, VALUE *argv, VALUE self) { FXIconList *arg1 = (FXIconList *) 0 ;
    FXString *arg2 = 0 ; FXIcon *arg3 = (FXIcon *) 0 ; FXIcon *arg4 = (FXIcon *) 0 ; void *arg5 = (void *) 0 ;
    FXbool arg6 = (FXbool) 0 ; FXint result; SwigValueWrapper<FXString > p2 ; VALUE vresult = Qnil;
    if ((argc < 1) || (argc > 5)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXIconList, 1); p2 = to_FXString(argv[0]); arg2 = &p2; if (argc > 1) {
        SWIG_ConvertPtr(argv[1], (void **) &arg3, SWIGTYPE_p_FXIcon, 1); }  if (argc > 2) {
        SWIG_ConvertPtr(argv[2], (void **) &arg4, SWIGTYPE_p_FXIcon, 1); }  if (argc > 3) {
        arg5 = (argv[3] == Qnil) ? NULL : (void *) argv[3]; }  if (argc > 4) { arg6 = to_FXbool(argv[4]); } 
    result = (FXint)(arg1)->appendItem((FXString const &)*arg2,arg3,arg4,arg5,arg6); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXIconList_appendItem(int nargs, VALUE *args, VALUE self) { int argc; VALUE argv[7]; int ii;
    argc = nargs + 1; argv[0] = self; for (ii = 1; (ii < argc) && (ii < 6); ii++) { argv[ii] = args[ii-1]; } 
    if ((argc >= 2) && (argc <= 3)) { int _v; { void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXIconList, 0) != -1)) ? 1 : 0; }
         if (_v) { { void *ptr;
                _v = (NIL_P(argv[1]) || (TYPE(argv[1]) == T_DATA && SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_FXIconItem, 0) != -1)) ? 1 : 0; }
             if (_v) { if (argc <= 2) { return _wrap_FXIconList_appendItem__SWIG_0(nargs, args, self);}  {
                    _v = (argv[2] == Qtrue || argv[2] == Qfalse) ? 1 : 0; }  if (_v) {
                    return _wrap_FXIconList_appendItem__SWIG_0(nargs, args, self);}  }  }  }  if ((argc >= 2) && (argc <= 6)) {
        int _v; { void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXIconList, 0) != -1)) ? 1 : 0; }
         if (_v) { { _v = (NIL_P(argv[1]) || TYPE(argv[1]) == T_STRING) ? 1 : 0; }  if (_v) { if (argc <= 2) {
                    return _wrap_FXIconList_appendItem__SWIG_1(nargs, args, self);}  { void *ptr;
                    _v = (NIL_P(argv[2]) || (TYPE(argv[2]) == T_DATA && SWIG_ConvertPtr(argv[2], &ptr, SWIGTYPE_p_FXIcon, 0) != -1)) ? 1 : 0; }
                 if (_v) { if (argc <= 3) { return _wrap_FXIconList_appendItem__SWIG_1(nargs, args, self);}  { void *ptr;
                        _v = (NIL_P(argv[3]) || (TYPE(argv[3]) == T_DATA && SWIG_ConvertPtr(argv[3], &ptr, SWIGTYPE_p_FXIcon, 0) != -1)) ? 1 : 0; }
                     if (_v) { if (argc <= 4) { return _wrap_FXIconList_appendItem__SWIG_1(nargs, args, self);}  { _v = 1; } 
                        if (_v) { if (argc <= 5) { return _wrap_FXIconList_appendItem__SWIG_1(nargs, args, self);}  {
                                _v = (argv[5] == Qtrue || argv[5] == Qfalse) ? 1 : 0; }  if (_v) {
                                return _wrap_FXIconList_appendItem__SWIG_1(nargs, args, self);}  }  }  }  }  }  } 
    rb_raise(rb_eArgError, "No matching function for overloaded 'FXIconList_appendItem'"); return Qnil; }
static VALUE _wrap_FXIconList_prependItem__SWIG_0(int argc, VALUE *argv, VALUE self) { FXIconList *arg1 = (FXIconList *) 0 ;
    FXIconItem *arg2 = (FXIconItem *) 0 ; FXbool arg3 = (FXbool) 0 ; FXint result; VALUE vresult = Qnil;
    if ((argc < 1) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXIconList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXIconItem, 1); if (argc > 1) { arg3 = to_FXbool(argv[1]); } 
    result = (FXint)FXIconList_prependItem__SWIG_0(arg1,arg2,arg3); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXIconList_prependItem__SWIG_1(int argc, VALUE *argv, VALUE self) { FXIconList *arg1 = (FXIconList *) 0 ;
    FXString *arg2 = 0 ; FXIcon *arg3 = (FXIcon *) 0 ; FXIcon *arg4 = (FXIcon *) 0 ; void *arg5 = (void *) 0 ;
    FXbool arg6 = (FXbool) 0 ; FXint result; SwigValueWrapper<FXString > p2 ; VALUE vresult = Qnil;
    if ((argc < 1) || (argc > 5)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXIconList, 1); p2 = to_FXString(argv[0]); arg2 = &p2; if (argc > 1) {
        SWIG_ConvertPtr(argv[1], (void **) &arg3, SWIGTYPE_p_FXIcon, 1); }  if (argc > 2) {
        SWIG_ConvertPtr(argv[2], (void **) &arg4, SWIGTYPE_p_FXIcon, 1); }  if (argc > 3) {
        arg5 = (argv[3] == Qnil) ? NULL : (void *) argv[3]; }  if (argc > 4) { arg6 = to_FXbool(argv[4]); } 
    result = (FXint)(arg1)->prependItem((FXString const &)*arg2,arg3,arg4,arg5,arg6); vresult = INT2NUM(result);
    return vresult; }
static VALUE _wrap_FXIconList_prependItem(int nargs, VALUE *args, VALUE self) { int argc; VALUE argv[7]; int ii;
    argc = nargs + 1; argv[0] = self; for (ii = 1; (ii < argc) && (ii < 6); ii++) { argv[ii] = args[ii-1]; } 
    if ((argc >= 2) && (argc <= 3)) { int _v; { void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXIconList, 0) != -1)) ? 1 : 0; }
         if (_v) { { void *ptr;
                _v = (NIL_P(argv[1]) || (TYPE(argv[1]) == T_DATA && SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_FXIconItem, 0) != -1)) ? 1 : 0; }
             if (_v) { if (argc <= 2) { return _wrap_FXIconList_prependItem__SWIG_0(nargs, args, self);}  {
                    _v = (argv[2] == Qtrue || argv[2] == Qfalse) ? 1 : 0; }  if (_v) {
                    return _wrap_FXIconList_prependItem__SWIG_0(nargs, args, self);}  }  }  }  if ((argc >= 2) && (argc <= 6)) {
        int _v; { void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXIconList, 0) != -1)) ? 1 : 0; }
         if (_v) { { _v = (NIL_P(argv[1]) || TYPE(argv[1]) == T_STRING) ? 1 : 0; }  if (_v) { if (argc <= 2) {
                    return _wrap_FXIconList_prependItem__SWIG_1(nargs, args, self);}  { void *ptr;
                    _v = (NIL_P(argv[2]) || (TYPE(argv[2]) == T_DATA && SWIG_ConvertPtr(argv[2], &ptr, SWIGTYPE_p_FXIcon, 0) != -1)) ? 1 : 0; }
                 if (_v) { if (argc <= 3) { return _wrap_FXIconList_prependItem__SWIG_1(nargs, args, self);}  { void *ptr;
                        _v = (NIL_P(argv[3]) || (TYPE(argv[3]) == T_DATA && SWIG_ConvertPtr(argv[3], &ptr, SWIGTYPE_p_FXIcon, 0) != -1)) ? 1 : 0; }
                     if (_v) { if (argc <= 4) { return _wrap_FXIconList_prependItem__SWIG_1(nargs, args, self);}  { _v = 1; } 
                        if (_v) { if (argc <= 5) { return _wrap_FXIconList_prependItem__SWIG_1(nargs, args, self);}  {
                                _v = (argv[5] == Qtrue || argv[5] == Qfalse) ? 1 : 0; }  if (_v) {
                                return _wrap_FXIconList_prependItem__SWIG_1(nargs, args, self);}  }  }  }  }  }  } 
    rb_raise(rb_eArgError, "No matching function for overloaded 'FXIconList_prependItem'"); return Qnil; }
static VALUE _wrap_FXIconList_moveItem(int argc, VALUE *argv, VALUE self) { FXIconList *arg1 = (FXIconList *) 0 ; FXint arg2 ;
    FXint arg3 ; FXbool arg4 = (FXbool) 0 ; FXint result; VALUE vresult = Qnil; if ((argc < 2) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXIconList, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    if (argc > 2) { arg4 = to_FXbool(argv[2]); }  { if (arg2 < 0 || arg2 >= arg1->getNumItems()) {
            rb_raise(rb_eIndexError, "icon list item index out of bounds"); }  }  {
        if (arg3 < 0 || arg3 >= arg1->getNumItems()) { rb_raise(rb_eIndexError, "icon list item index out of bounds"); }  } 
    result = (FXint)(arg1)->moveItem(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXIconList_removeItem(int argc, VALUE *argv, VALUE self) { FXIconList *arg1 = (FXIconList *) 0 ; FXint arg2 ;
    FXbool arg3 = (FXbool) 0 ; if ((argc < 1) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXIconList, 1); arg2 = NUM2INT(argv[0]); if (argc > 1) {
        arg3 = to_FXbool(argv[1]); }  { if (arg2 < 0 || arg2 >= arg1->getNumItems()) {
            rb_raise(rb_eIndexError, "icon list item index out of bounds"); }  }  FXIconList_removeItem(arg1,arg2,arg3);
    return Qnil; }
static VALUE _wrap_FXIconList_clearItems(int argc, VALUE *argv, VALUE self) { FXIconList *arg1 = (FXIconList *) 0 ;
    FXbool arg2 = (FXbool) 0 ; if ((argc < 0) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXIconList, 1); if (argc > 0) { arg2 = to_FXbool(argv[0]); } 
    FXIconList_clearItems(arg1,arg2); return Qnil; }
static VALUE _wrap_FXIconList_getItemWidth(int argc, VALUE *argv, VALUE self) { FXIconList *arg1 = (FXIconList *) 0 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXIconList, 1);
    result = (FXint)((FXIconList const *)arg1)->getItemWidth(); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXIconList_getItemHeight(int argc, VALUE *argv, VALUE self) { FXIconList *arg1 = (FXIconList *) 0 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXIconList, 1);
    result = (FXint)((FXIconList const *)arg1)->getItemHeight(); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXIconList_getItemAt(int argc, VALUE *argv, VALUE self) { FXIconList *arg1 = (FXIconList *) 0 ; FXint arg2 ;
    FXint arg3 ; FXint result; VALUE vresult = Qnil; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXIconList, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    result = (FXint)((FXIconList const *)arg1)->getItemAt(arg2,arg3); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXIconList_findItem(int argc, VALUE *argv, VALUE self) { FXIconList *arg1 = (FXIconList *) 0 ;
    FXString *arg2 = 0 ; FXint arg3 = (FXint) -1 ; FXuint arg4 = (FXuint) SEARCH_FORWARD|SEARCH_WRAP ; FXint result;
    SwigValueWrapper<FXString > p2 ; VALUE vresult = Qnil; if ((argc < 1) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXIconList, 1); p2 = to_FXString(argv[0]); arg2 = &p2; if (argc > 1) {
        arg3 = NUM2INT(argv[1]); }  if (argc > 2) { arg4 = NUM2UINT(argv[2]); } 
    result = (FXint)((FXIconList const *)arg1)->findItem((FXString const &)*arg2,arg3,arg4); vresult = INT2NUM(result);
    return vresult; }
static VALUE _wrap_FXIconList_makeItemVisible__SWIG_0(int argc, VALUE *argv, VALUE self) { FXIconList *arg1 = (FXIconList *) 0 ;
    FXint arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXIconList, 1); arg2 = NUM2INT(argv[0]); {
        if (arg2 < 0 || arg2 >= arg1->getNumItems()) { rb_raise(rb_eIndexError, "icon list item index out of bounds"); }  } 
    (arg1)->makeItemVisible(arg2); return Qnil; }
static VALUE _wrap_FXIconList_makeItemVisible__SWIG_1(int argc, VALUE *argv, VALUE self) { FXIconList *arg1 = (FXIconList *) 0 ;
    FXIconItem *arg2 = (FXIconItem *) 0 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXIconList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXIconItem, 1); FXIconList_makeItemVisible__SWIG_1(arg1,arg2);
    return Qnil; }
static VALUE _wrap_FXIconList_makeItemVisible(int nargs, VALUE *args, VALUE self) { int argc; VALUE argv[3]; int ii;
    argc = nargs + 1; argv[0] = self; for (ii = 1; (ii < argc) && (ii < 2); ii++) { argv[ii] = args[ii-1]; }  if (argc == 2) {
        int _v; { void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXIconList, 0) != -1)) ? 1 : 0; }
         if (_v) { { void *ptr;
                _v = (NIL_P(argv[1]) || (TYPE(argv[1]) == T_DATA && SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_FXIconItem, 0) != -1)) ? 1 : 0; }
             if (_v) { return _wrap_FXIconList_makeItemVisible__SWIG_1(nargs, args, self);}  }  }  if (argc == 2) { int _v; {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXIconList, 0) != -1)) ? 1 : 0; }
         if (_v) { { _v = ((TYPE(argv[1]) == T_FIXNUM) || (TYPE(argv[1]) == T_BIGNUM)) ? 1 : 0; }  if (_v) {
                return _wrap_FXIconList_makeItemVisible__SWIG_0(nargs, args, self);}  }  } 
    rb_raise(rb_eArgError, "No matching function for overloaded 'FXIconList_makeItemVisible'"); return Qnil; }
static VALUE _wrap_FXIconList_setItemText(int argc, VALUE *argv, VALUE self) { FXIconList *arg1 = (FXIconList *) 0 ;
    FXint arg2 ; FXString *arg3 = 0 ; SwigValueWrapper<FXString > p3 ; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXIconList, 1); arg2 = NUM2INT(argv[0]);
    p3 = to_FXString(argv[1]); arg3 = &p3; { if (arg2 < 0 || arg2 >= arg1->getNumItems()) {
            rb_raise(rb_eIndexError, "icon list item index out of bounds"); }  } 
    (arg1)->setItemText(arg2,(FXString const &)*arg3); return Qnil; }
static VALUE _wrap_FXIconList_getItemText(int argc, VALUE *argv, VALUE self) { FXIconList *arg1 = (FXIconList *) 0 ;
    FXint arg2 ; FXString result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXIconList, 1); arg2 = NUM2INT(argv[0]); {
        if (arg2 < 0 || arg2 >= arg1->getNumItems()) { rb_raise(rb_eIndexError, "icon list item index out of bounds"); }  } 
    result = ((FXIconList const *)arg1)->getItemText(arg2); vresult = rb_str_new2((&result)->text()); return vresult; }
static VALUE _wrap_FXIconList_setItemBigIcon(int argc, VALUE *argv, VALUE self) { FXIconList *arg1 = (FXIconList *) 0 ;
    FXint arg2 ; FXIcon *arg3 = (FXIcon *) 0 ; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXIconList, 1); arg2 = NUM2INT(argv[0]);
    SWIG_ConvertPtr(argv[1], (void **) &arg3, SWIGTYPE_p_FXIcon, 1); { if (arg2 < 0 || arg2 >= arg1->getNumItems()) {
            rb_raise(rb_eIndexError, "icon list item index out of bounds"); }  }  (arg1)->setItemBigIcon(arg2,arg3);
    return Qnil; }
static VALUE _wrap_FXIconList_getItemBigIcon(int argc, VALUE *argv, VALUE self) { FXIconList *arg1 = (FXIconList *) 0 ;
    FXint arg2 ; FXIcon *result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXIconList, 1); arg2 = NUM2INT(argv[0]); {
        if (arg2 < 0 || arg2 >= arg1->getNumItems()) { rb_raise(rb_eIndexError, "icon list item index out of bounds"); }  } 
    result = (FXIcon *)((FXIconList const *)arg1)->getItemBigIcon(arg2); {
        swig_type_info *ty = SWIG_TypeDynamicCast(SWIGTYPE_p_FXIcon, (void **) &result); vresult = FXRbGetRubyObj(result, ty); }
     return vresult; }
static VALUE _wrap_FXIconList_setItemMiniIcon(int argc, VALUE *argv, VALUE self) { FXIconList *arg1 = (FXIconList *) 0 ;
    FXint arg2 ; FXIcon *arg3 = (FXIcon *) 0 ; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXIconList, 1); arg2 = NUM2INT(argv[0]);
    SWIG_ConvertPtr(argv[1], (void **) &arg3, SWIGTYPE_p_FXIcon, 1); { if (arg2 < 0 || arg2 >= arg1->getNumItems()) {
            rb_raise(rb_eIndexError, "icon list item index out of bounds"); }  }  (arg1)->setItemMiniIcon(arg2,arg3);
    return Qnil; }
static VALUE _wrap_FXIconList_getItemMiniIcon(int argc, VALUE *argv, VALUE self) { FXIconList *arg1 = (FXIconList *) 0 ;
    FXint arg2 ; FXIcon *result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXIconList, 1); arg2 = NUM2INT(argv[0]); {
        if (arg2 < 0 || arg2 >= arg1->getNumItems()) { rb_raise(rb_eIndexError, "icon list item index out of bounds"); }  } 
    result = (FXIcon *)((FXIconList const *)arg1)->getItemMiniIcon(arg2); {
        swig_type_info *ty = SWIG_TypeDynamicCast(SWIGTYPE_p_FXIcon, (void **) &result); vresult = FXRbGetRubyObj(result, ty); }
     return vresult; }
static VALUE _wrap_FXIconList_setItemData(int argc, VALUE *argv, VALUE self) { FXIconList *arg1 = (FXIconList *) 0 ;
    FXint arg2 ; VALUE arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXIconList, 1); arg2 = NUM2INT(argv[0]); arg3 = argv[1]; {
        if (arg2 < 0 || arg2 >= arg1->getNumItems()) { rb_raise(rb_eIndexError, "icon list item index out of bounds"); }  } 
    FXIconList_setItemData(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXIconList_getItemData(int argc, VALUE *argv, VALUE self) { FXIconList *arg1 = (FXIconList *) 0 ;
    FXint arg2 ; VALUE result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXIconList, 1); arg2 = NUM2INT(argv[0]); {
        if (arg2 < 0 || arg2 >= arg1->getNumItems()) { rb_raise(rb_eIndexError, "icon list item index out of bounds"); }  } 
    result = (VALUE)FXIconList_getItemData((FXIconList const *)arg1,arg2); vresult = result; return vresult; }
static VALUE _wrap_FXIconList_isItemSelected(int argc, VALUE *argv, VALUE self) { FXIconList *arg1 = (FXIconList *) 0 ;
    FXint arg2 ; FXbool result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXIconList, 1); arg2 = NUM2INT(argv[0]); {
        if (arg2 < 0 || arg2 >= arg1->getNumItems()) { rb_raise(rb_eIndexError, "icon list item index out of bounds"); }  } 
    result = (FXbool)((FXIconList const *)arg1)->isItemSelected(arg2); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXIconList_isItemCurrent(int argc, VALUE *argv, VALUE self) { FXIconList *arg1 = (FXIconList *) 0 ;
    FXint arg2 ; FXbool result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXIconList, 1); arg2 = NUM2INT(argv[0]); {
        if (arg2 < 0 || arg2 >= arg1->getNumItems()) { rb_raise(rb_eIndexError, "icon list item index out of bounds"); }  } 
    result = (FXbool)((FXIconList const *)arg1)->isItemCurrent(arg2); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXIconList_isItemVisible(int argc, VALUE *argv, VALUE self) { FXIconList *arg1 = (FXIconList *) 0 ;
    FXint arg2 ; FXbool result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXIconList, 1); arg2 = NUM2INT(argv[0]); {
        if (arg2 < 0 || arg2 >= arg1->getNumItems()) { rb_raise(rb_eIndexError, "icon list item index out of bounds"); }  } 
    result = (FXbool)((FXIconList const *)arg1)->isItemVisible(arg2); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXIconList_isItemEnabled(int argc, VALUE *argv, VALUE self) { FXIconList *arg1 = (FXIconList *) 0 ;
    FXint arg2 ; FXbool result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXIconList, 1); arg2 = NUM2INT(argv[0]); {
        if (arg2 < 0 || arg2 >= arg1->getNumItems()) { rb_raise(rb_eIndexError, "icon list item index out of bounds"); }  } 
    result = (FXbool)((FXIconList const *)arg1)->isItemEnabled(arg2); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXIconList_hitItem(int argc, VALUE *argv, VALUE self) { FXIconList *arg1 = (FXIconList *) 0 ; FXint arg2 ;
    FXint arg3 ; FXint arg4 ; FXint arg5 = (FXint) 1 ; FXint arg6 = (FXint) 1 ; FXint result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 5)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXIconList, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    arg4 = NUM2INT(argv[2]); if (argc > 3) { arg5 = NUM2INT(argv[3]); }  if (argc > 4) { arg6 = NUM2INT(argv[4]); }  {
        if (arg2 < 0 || arg2 >= arg1->getNumItems()) { rb_raise(rb_eIndexError, "icon list item index out of bounds"); }  } 
    result = (FXint)((FXIconList const *)arg1)->hitItem(arg2,arg3,arg4,arg5,arg6); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXIconList_updateItem(int argc, VALUE *argv, VALUE self) { FXIconList *arg1 = (FXIconList *) 0 ; FXint arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXIconList, 1); arg2 = NUM2INT(argv[0]); {
        if (arg2 < 0 || arg2 >= arg1->getNumItems()) { rb_raise(rb_eIndexError, "icon list item index out of bounds"); }  } 
    ((FXIconList const *)arg1)->updateItem(arg2); return Qnil; }
static VALUE _wrap_FXIconList_enableItem(int argc, VALUE *argv, VALUE self) { FXIconList *arg1 = (FXIconList *) 0 ; FXint arg2 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXIconList, 1); arg2 = NUM2INT(argv[0]); {
        if (arg2 < 0 || arg2 >= arg1->getNumItems()) { rb_raise(rb_eIndexError, "icon list item index out of bounds"); }  } 
    result = (FXbool)(arg1)->enableItem(arg2); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXIconList_disableItem(int argc, VALUE *argv, VALUE self) { FXIconList *arg1 = (FXIconList *) 0 ;
    FXint arg2 ; FXbool result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXIconList, 1); arg2 = NUM2INT(argv[0]); {
        if (arg2 < 0 || arg2 >= arg1->getNumItems()) { rb_raise(rb_eIndexError, "icon list item index out of bounds"); }  } 
    result = (FXbool)(arg1)->disableItem(arg2); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXIconList_getCurrentItem(int argc, VALUE *argv, VALUE self) { FXIconList *arg1 = (FXIconList *) 0 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXIconList, 1);
    result = (FXint)((FXIconList const *)arg1)->getCurrentItem(); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXIconList_setAnchorItem(int argc, VALUE *argv, VALUE self) { FXIconList *arg1 = (FXIconList *) 0 ;
    FXint arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXIconList, 1); arg2 = NUM2INT(argv[0]); {
        if (arg2 < 0 || arg2 >= arg1->getNumItems()) { rb_raise(rb_eIndexError, "icon list item index out of bounds"); }  } 
    (arg1)->setAnchorItem(arg2); return Qnil; }
static VALUE _wrap_FXIconList_getAnchorItem(int argc, VALUE *argv, VALUE self) { FXIconList *arg1 = (FXIconList *) 0 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXIconList, 1);
    result = (FXint)((FXIconList const *)arg1)->getAnchorItem(); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXIconList_getCursorItem(int argc, VALUE *argv, VALUE self) { FXIconList *arg1 = (FXIconList *) 0 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXIconList, 1);
    result = (FXint)((FXIconList const *)arg1)->getCursorItem(); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXIconList_sortItems(int argc, VALUE *argv, VALUE self) { FXIconList *arg1 = (FXIconList *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXIconList, 1); (arg1)->sortItems(); return Qnil; }
static VALUE _wrap_FXIconList_setFont(int argc, VALUE *argv, VALUE self) { FXIconList *arg1 = (FXIconList *) 0 ;
    FXFont *arg2 = (FXFont *) 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXIconList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXFont, 1); (arg1)->setFont(arg2); return Qnil; }
static VALUE _wrap_FXIconList_getFont(int argc, VALUE *argv, VALUE self) { FXIconList *arg1 = (FXIconList *) 0 ; FXFont *result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXIconList, 1); result = (FXFont *)((FXIconList const *)arg1)->getFont();
    { swig_type_info *ty = SWIG_TypeDynamicCast(SWIGTYPE_p_FXFont, (void **) &result); vresult = FXRbGetRubyObj(result, ty); } 
    return vresult; }
static VALUE _wrap_FXIconList_getTextColor(int argc, VALUE *argv, VALUE self) { FXIconList *arg1 = (FXIconList *) 0 ;
    FXColor result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXIconList, 1);
    result = (FXColor)((FXIconList const *)arg1)->getTextColor(); vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXIconList_setTextColor(int argc, VALUE *argv, VALUE self) { FXIconList *arg1 = (FXIconList *) 0 ;
    FXColor arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXIconList, 1); arg2 = to_FXColor(argv[0]); (arg1)->setTextColor(arg2);
    return Qnil; }
static VALUE _wrap_FXIconList_getSelBackColor(int argc, VALUE *argv, VALUE self) { FXIconList *arg1 = (FXIconList *) 0 ;
    FXColor result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXIconList, 1);
    result = (FXColor)((FXIconList const *)arg1)->getSelBackColor(); vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXIconList_setSelBackColor(int argc, VALUE *argv, VALUE self) { FXIconList *arg1 = (FXIconList *) 0 ;
    FXColor arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXIconList, 1); arg2 = to_FXColor(argv[0]); (arg1)->setSelBackColor(arg2);
    return Qnil; }
static VALUE _wrap_FXIconList_getSelTextColor(int argc, VALUE *argv, VALUE self) { FXIconList *arg1 = (FXIconList *) 0 ;
    FXColor result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXIconList, 1);
    result = (FXColor)((FXIconList const *)arg1)->getSelTextColor(); vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXIconList_setSelTextColor(int argc, VALUE *argv, VALUE self) { FXIconList *arg1 = (FXIconList *) 0 ;
    FXColor arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXIconList, 1); arg2 = to_FXColor(argv[0]); (arg1)->setSelTextColor(arg2);
    return Qnil; }
static VALUE _wrap_FXIconList_setItemSpace(int argc, VALUE *argv, VALUE self) { FXIconList *arg1 = (FXIconList *) 0 ;
    FXint arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXIconList, 1); arg2 = NUM2INT(argv[0]); (arg1)->setItemSpace(arg2);
    return Qnil; }
static VALUE _wrap_FXIconList_getItemSpace(int argc, VALUE *argv, VALUE self) { FXIconList *arg1 = (FXIconList *) 0 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXIconList, 1);
    result = (FXint)((FXIconList const *)arg1)->getItemSpace(); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXIconList_getListStyle(int argc, VALUE *argv, VALUE self) { FXIconList *arg1 = (FXIconList *) 0 ;
    FXuint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXIconList, 1);
    result = (FXuint)((FXIconList const *)arg1)->getListStyle(); vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXIconList_setListStyle(int argc, VALUE *argv, VALUE self) { FXIconList *arg1 = (FXIconList *) 0 ;
    FXuint arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXIconList, 1); arg2 = NUM2UINT(argv[0]); (arg1)->setListStyle(arg2);
    return Qnil; }
static VALUE _wrap_FXIconList_setHelpText(int argc, VALUE *argv, VALUE self) { FXIconList *arg1 = (FXIconList *) 0 ;
    FXString *arg2 = 0 ; SwigValueWrapper<FXString > p2 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXIconList, 1); p2 = to_FXString(argv[0]); arg2 = &p2;
    (arg1)->setHelpText((FXString const &)*arg2); return Qnil; }
static VALUE _wrap_FXIconList_getHelpText(int argc, VALUE *argv, VALUE self) { FXIconList *arg1 = (FXIconList *) 0 ;
    FXString result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXIconList, 1); result = ((FXIconList const *)arg1)->getHelpText();
    vresult = rb_str_new2((&result)->text()); return vresult; }
static void
free_FXIconList(FXIconList *arg1) {
    delete arg1;
}
static VALUE _wrap_FXIconList_save(int argc, VALUE *argv, VALUE self) { FXIconList *arg1 = (FXIconList *) 0 ;
    FXStream *arg2 = 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXIconList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXIconList_save((FXIconList const *)arg1,*arg2); return Qnil; }
static VALUE _wrap_FXIconList_load(int argc, VALUE *argv, VALUE self) { FXIconList *arg1 = (FXIconList *) 0 ;
    FXStream *arg2 = 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXIconList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXIconList_load(arg1,*arg2); return Qnil; }
static VALUE _wrap_FXIconList_create(int argc, VALUE *argv, VALUE self) { FXIconList *arg1 = (FXIconList *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXIconList, 1); FXIconList_create(arg1); return Qnil; }
static VALUE _wrap_FXIconList_detach(int argc, VALUE *argv, VALUE self) { FXIconList *arg1 = (FXIconList *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXIconList, 1); FXIconList_detach(arg1); return Qnil; }
static VALUE _wrap_FXIconList_destroy(int argc, VALUE *argv, VALUE self) { FXIconList *arg1 = (FXIconList *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXIconList, 1); FXIconList_destroy(arg1); return Qnil; }
static VALUE _wrap_FXIconList_resize(int argc, VALUE *argv, VALUE self) { FXIconList *arg1 = (FXIconList *) 0 ; FXint arg2 ;
    FXint arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXIconList, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    FXIconList_resize(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXIconList_getDefaultWidth(int argc, VALUE *argv, VALUE self) { FXIconList *arg1 = (FXIconList *) 0 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXIconList, 1); result = (FXint)FXIconList_getDefaultWidth(arg1);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXIconList_getDefaultHeight(int argc, VALUE *argv, VALUE self) { FXIconList *arg1 = (FXIconList *) 0 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXIconList, 1); result = (FXint)FXIconList_getDefaultHeight(arg1);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXIconList_getWidthForHeight(int argc, VALUE *argv, VALUE self) { FXIconList *arg1 = (FXIconList *) 0 ;
    FXint arg2 ; FXint result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXIconList, 1); arg2 = NUM2INT(argv[0]);
    result = (FXint)FXIconList_getWidthForHeight(arg1,arg2); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXIconList_getHeightForWidth(int argc, VALUE *argv, VALUE self) { FXIconList *arg1 = (FXIconList *) 0 ;
    FXint arg2 ; FXint result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXIconList, 1); arg2 = NUM2INT(argv[0]);
    result = (FXint)FXIconList_getHeightForWidth(arg1,arg2); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXIconList_canFocus(int argc, VALUE *argv, VALUE self) { FXIconList *arg1 = (FXIconList *) 0 ; FXbool result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXIconList, 1);
    result = (FXbool)FXIconList_canFocus((FXIconList const *)arg1); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXIconList_setFocus(int argc, VALUE *argv, VALUE self) { FXIconList *arg1 = (FXIconList *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXIconList, 1); FXIconList_setFocus(arg1); return Qnil; }
static VALUE _wrap_FXIconList_killFocus(int argc, VALUE *argv, VALUE self) { FXIconList *arg1 = (FXIconList *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXIconList, 1); FXIconList_killFocus(arg1); return Qnil; }
static VALUE _wrap_FXIconList_setDefault(int argc, VALUE *argv, VALUE self) { FXIconList *arg1 = (FXIconList *) 0 ;
    FXbool arg2 = (FXbool) 1 ; if ((argc < 0) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXIconList, 1); if (argc > 0) { arg2 = to_FXbool(argv[0]); } 
    FXIconList_setDefault(arg1,arg2); return Qnil; }
static VALUE _wrap_FXIconList_enable(int argc, VALUE *argv, VALUE self) { FXIconList *arg1 = (FXIconList *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXIconList, 1); FXIconList_enable(arg1); return Qnil; }
static VALUE _wrap_FXIconList_disable(int argc, VALUE *argv, VALUE self) { FXIconList *arg1 = (FXIconList *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXIconList, 1); FXIconList_disable(arg1); return Qnil; }
static VALUE _wrap_FXIconList_raiseWindow(int argc, VALUE *argv, VALUE self) { FXIconList *arg1 = (FXIconList *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXIconList, 1); FXIconList_raise(arg1); return Qnil; }
static VALUE _wrap_FXIconList_lower(int argc, VALUE *argv, VALUE self) { FXIconList *arg1 = (FXIconList *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXIconList, 1); FXIconList_lower(arg1); return Qnil; }
static VALUE _wrap_FXIconList_move(int argc, VALUE *argv, VALUE self) { FXIconList *arg1 = (FXIconList *) 0 ; FXint arg2 ;
    FXint arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXIconList, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    FXIconList_move(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXIconList_position__SWIG_0(int argc, VALUE *argv, VALUE self) { FXIconList *arg1 = (FXIconList *) 0 ;
    FXint arg2 ; FXint arg3 ; FXint arg4 ; FXint arg5 ; if ((argc < 4) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXIconList, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    arg4 = NUM2INT(argv[2]); arg5 = NUM2INT(argv[3]); FXIconList_position(arg1,arg2,arg3,arg4,arg5); return Qnil; }
static VALUE _wrap_FXIconList_layout(int argc, VALUE *argv, VALUE self) { FXIconList *arg1 = (FXIconList *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXIconList, 1); FXIconList_layout(arg1); return Qnil; }
static VALUE _wrap_FXIconList_recalc(int argc, VALUE *argv, VALUE self) { FXIconList *arg1 = (FXIconList *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXIconList, 1); FXIconList_recalc(arg1); return Qnil; }
static VALUE _wrap_FXIconList_reparent(int argc, VALUE *argv, VALUE self) { FXIconList *arg1 = (FXIconList *) 0 ;
    FXComposite *arg2 = (FXComposite *) 0 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXIconList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXComposite, 1); FXIconList_reparent(arg1,arg2); return Qnil; }
static VALUE _wrap_FXIconList_show(int argc, VALUE *argv, VALUE self) { FXIconList *arg1 = (FXIconList *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXIconList, 1); FXIconList_show(arg1); return Qnil; }
static VALUE _wrap_FXIconList_hide(int argc, VALUE *argv, VALUE self) { FXIconList *arg1 = (FXIconList *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXIconList, 1); FXIconList_hide(arg1); return Qnil; }
static VALUE _wrap_FXIconList_isComposite(int argc, VALUE *argv, VALUE self) { FXIconList *arg1 = (FXIconList *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXIconList, 1);
    result = (FXbool)FXIconList_isComposite((FXIconList const *)arg1); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXIconList_contains(int argc, VALUE *argv, VALUE self) { FXIconList *arg1 = (FXIconList *) 0 ; FXint arg2 ;
    FXint arg3 ; FXbool result; VALUE vresult = Qnil; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXIconList, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    result = (FXbool)FXIconList_contains((FXIconList const *)arg1,arg2,arg3); vresult = result ? Qtrue : Qfalse;
    return vresult; }
static VALUE _wrap_FXIconList_doesSaveUnder(int argc, VALUE *argv, VALUE self) { FXIconList *arg1 = (FXIconList *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXIconList, 1);
    result = (FXbool)FXIconList_doesSaveUnder((FXIconList const *)arg1); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXIconList_setBackColor(int argc, VALUE *argv, VALUE self) { FXIconList *arg1 = (FXIconList *) 0 ;
    FXColor arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXIconList, 1); arg2 = to_FXColor(argv[0]);
    FXIconList_setBackColor(arg1,arg2); return Qnil; }
static VALUE _wrap_FXIconList_getViewportHeight(int argc, VALUE *argv, VALUE self) { FXIconList *arg1 = (FXIconList *) 0 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXIconList, 1); result = (FXint)FXIconList_getViewportHeight(arg1);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXIconList_getViewportWidth(int argc, VALUE *argv, VALUE self) { FXIconList *arg1 = (FXIconList *) 0 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXIconList, 1); result = (FXint)FXIconList_getViewportWidth(arg1);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXIconList_getContentHeight(int argc, VALUE *argv, VALUE self) { FXIconList *arg1 = (FXIconList *) 0 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXIconList, 1); result = (FXint)FXIconList_getContentHeight(arg1);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXIconList_getContentWidth(int argc, VALUE *argv, VALUE self) { FXIconList *arg1 = (FXIconList *) 0 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXIconList, 1); result = (FXint)FXIconList_getContentWidth(arg1);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXIconList_position__SWIG_1(int argc, VALUE *argv, VALUE self) { FXIconList *arg1 = (FXIconList *) 0 ;
    VALUE result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXIconList, 1);
    result = (VALUE)FXIconList_position__SWIG_1((FXIconList const *)arg1); vresult = result; return vresult; }
static VALUE _wrap_FXIconList_position(int nargs, VALUE *args, VALUE self) { int argc; VALUE argv[6]; int ii; argc = nargs + 1;
    argv[0] = self; for (ii = 1; (ii < argc) && (ii < 5); ii++) { argv[ii] = args[ii-1]; }  if (argc == 1) { int _v; {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXIconList, 0) != -1)) ? 1 : 0; }
         if (_v) { return _wrap_FXIconList_position__SWIG_1(nargs, args, self);}  }  if (argc == 5) { int _v; { void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXIconList, 0) != -1)) ? 1 : 0; }
         if (_v) { { _v = ((TYPE(argv[1]) == T_FIXNUM) || (TYPE(argv[1]) == T_BIGNUM)) ? 1 : 0; }  if (_v) { {
                    _v = ((TYPE(argv[2]) == T_FIXNUM) || (TYPE(argv[2]) == T_BIGNUM)) ? 1 : 0; }  if (_v) { {
                        _v = ((TYPE(argv[3]) == T_FIXNUM) || (TYPE(argv[3]) == T_BIGNUM)) ? 1 : 0; }  if (_v) { {
                            _v = ((TYPE(argv[4]) == T_FIXNUM) || (TYPE(argv[4]) == T_BIGNUM)) ? 1 : 0; }  if (_v) {
                            return _wrap_FXIconList_position__SWIG_0(nargs, args, self);}  }  }  }  }  } 
    rb_raise(rb_eArgError, "No matching function for overloaded 'FXIconList_position'"); return Qnil; }
static VALUE _wrap_FXIconList_selectItem(int argc, VALUE *argv, VALUE self) { FXIconList *arg1 = (FXIconList *) 0 ; FXint arg2 ;
    FXbool arg3 = (FXbool) 0 ; FXbool result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXIconList, 1); arg2 = NUM2INT(argv[0]); if (argc > 1) {
        arg3 = to_FXbool(argv[1]); }  { if (arg2 < 0 || arg2 >= arg1->getNumItems()) {
            rb_raise(rb_eIndexError, "icon list item index out of bounds"); }  } 
    result = (FXbool)FXIconList_selectItem(arg1,arg2,arg3); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXIconList_deselectItem(int argc, VALUE *argv, VALUE self) { FXIconList *arg1 = (FXIconList *) 0 ;
    FXint arg2 ; FXbool arg3 = (FXbool) 0 ; FXbool result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXIconList, 1); arg2 = NUM2INT(argv[0]); if (argc > 1) {
        arg3 = to_FXbool(argv[1]); }  { if (arg2 < 0 || arg2 >= arg1->getNumItems()) {
            rb_raise(rb_eIndexError, "icon list item index out of bounds"); }  } 
    result = (FXbool)FXIconList_deselectItem(arg1,arg2,arg3); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXIconList_toggleItem(int argc, VALUE *argv, VALUE self) { FXIconList *arg1 = (FXIconList *) 0 ; FXint arg2 ;
    FXbool arg3 = (FXbool) 0 ; FXbool result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXIconList, 1); arg2 = NUM2INT(argv[0]); if (argc > 1) {
        arg3 = to_FXbool(argv[1]); }  { if (arg2 < 0 || arg2 >= arg1->getNumItems()) {
            rb_raise(rb_eIndexError, "icon list item index out of bounds"); }  } 
    result = (FXbool)FXIconList_toggleItem(arg1,arg2,arg3); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXIconList_selectInRectangle(int argc, VALUE *argv, VALUE self) { FXIconList *arg1 = (FXIconList *) 0 ;
    FXint arg2 ; FXint arg3 ; FXint arg4 ; FXint arg5 ; FXbool arg6 = (FXbool) 0 ; FXbool result; VALUE vresult = Qnil;
    if ((argc < 4) || (argc > 5)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXIconList, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    arg4 = NUM2INT(argv[2]); arg5 = NUM2INT(argv[3]); if (argc > 4) { arg6 = to_FXbool(argv[4]); } 
    result = (FXbool)FXIconList_selectInRectangle(arg1,arg2,arg3,arg4,arg5,arg6); vresult = result ? Qtrue : Qfalse;
    return vresult; }
static VALUE _wrap_FXIconList_extendSelection(int argc, VALUE *argv, VALUE self) { FXIconList *arg1 = (FXIconList *) 0 ;
    FXint arg2 ; FXbool arg3 = (FXbool) 0 ; FXbool result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXIconList, 1); arg2 = NUM2INT(argv[0]); if (argc > 1) {
        arg3 = to_FXbool(argv[1]); }  { if (arg2 < 0 || arg2 >= arg1->getNumItems()) {
            rb_raise(rb_eIndexError, "icon list item index out of bounds"); }  } 
    result = (FXbool)FXIconList_extendSelection(arg1,arg2,arg3); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXIconList_killSelection(int argc, VALUE *argv, VALUE self) { FXIconList *arg1 = (FXIconList *) 0 ;
    FXbool arg2 = (FXbool) 0 ; FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXIconList, 1); if (argc > 0) { arg2 = to_FXbool(argv[0]); } 
    result = (FXbool)FXIconList_killSelection(arg1,arg2); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXIconList_setCurrentItem(int argc, VALUE *argv, VALUE self) { FXIconList *arg1 = (FXIconList *) 0 ;
    FXint arg2 ; FXbool arg3 = (FXbool) 0 ; if ((argc < 1) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXIconList, 1); arg2 = NUM2INT(argv[0]); if (argc > 1) {
        arg3 = to_FXbool(argv[1]); }  { if (arg2 < 0 || arg2 >= arg1->getNumItems()) {
            rb_raise(rb_eIndexError, "icon list item index out of bounds"); }  }  FXIconList_setCurrentItem(arg1,arg2,arg3);
    return Qnil; }
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE _wrap_FXFileItem_allocate(VALUE self) {
#else
     static VALUE _wrap_FXFileItem_allocate(int argc, VALUE *argv, VALUE self) {
#endif
         VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_FXFileItem);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
         return vresult; }
static VALUE _wrap_new_FXFileItem(int argc, VALUE *argv, VALUE self) { FXString *arg1 = 0 ; FXIcon *arg2 = (FXIcon *) 0 ;
    FXIcon *arg3 = (FXIcon *) 0 ; void *arg4 = (void *) 0 ; FXFileItem *result; SwigValueWrapper<FXString > p1 ;
    if ((argc < 1) || (argc > 4)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    p1 = to_FXString(argv[0]); arg1 = &p1; if (argc > 1) { SWIG_ConvertPtr(argv[1], (void **) &arg2, SWIGTYPE_p_FXIcon, 1); } 
    if (argc > 2) { SWIG_ConvertPtr(argv[2], (void **) &arg3, SWIGTYPE_p_FXIcon, 1); }  if (argc > 3) {
        SWIG_ConvertPtr(argv[3], (void **) &arg4, 0, 1); }  {
        result = (FXFileItem *)new_FXFileItem((FXString const &)*arg1,arg2,arg3,arg4);
        DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result); if(rb_block_given_p()){ rb_yield(self); }  }  return self; }
static VALUE _wrap_FXFileItem_isFile(int argc, VALUE *argv, VALUE self) { FXFileItem *arg1 = (FXFileItem *) 0 ; FXbool result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileItem, 1); result = (FXbool)((FXFileItem const *)arg1)->isFile();
    vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXFileItem_isDirectory(int argc, VALUE *argv, VALUE self) { FXFileItem *arg1 = (FXFileItem *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileItem, 1);
    result = (FXbool)((FXFileItem const *)arg1)->isDirectory(); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXFileItem_isShare(int argc, VALUE *argv, VALUE self) { FXFileItem *arg1 = (FXFileItem *) 0 ; FXbool result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileItem, 1); result = (FXbool)((FXFileItem const *)arg1)->isShare();
    vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXFileItem_isExecutable(int argc, VALUE *argv, VALUE self) { FXFileItem *arg1 = (FXFileItem *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileItem, 1);
    result = (FXbool)((FXFileItem const *)arg1)->isExecutable(); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXFileItem_isSymlink(int argc, VALUE *argv, VALUE self) { FXFileItem *arg1 = (FXFileItem *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileItem, 1); result = (FXbool)((FXFileItem const *)arg1)->isSymlink();
    vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXFileItem_isChardev(int argc, VALUE *argv, VALUE self) { FXFileItem *arg1 = (FXFileItem *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileItem, 1); result = (FXbool)((FXFileItem const *)arg1)->isChardev();
    vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXFileItem_isBlockdev(int argc, VALUE *argv, VALUE self) { FXFileItem *arg1 = (FXFileItem *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileItem, 1); result = (FXbool)((FXFileItem const *)arg1)->isBlockdev();
    vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXFileItem_isFifo(int argc, VALUE *argv, VALUE self) { FXFileItem *arg1 = (FXFileItem *) 0 ; FXbool result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileItem, 1); result = (FXbool)((FXFileItem const *)arg1)->isFifo();
    vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXFileItem_isSocket(int argc, VALUE *argv, VALUE self) { FXFileItem *arg1 = (FXFileItem *) 0 ; FXbool result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileItem, 1); result = (FXbool)((FXFileItem const *)arg1)->isSocket();
    vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXFileItem_getAssoc(int argc, VALUE *argv, VALUE self) { FXFileItem *arg1 = (FXFileItem *) 0 ;
    FXFileAssoc *result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileItem, 1);
    result = (FXFileAssoc *)((FXFileItem const *)arg1)->getAssoc(); vresult = FXRbGetRubyObj(result, "FXFileAssoc *");
    return vresult; }
static VALUE _wrap_FXFileItem_getSize(int argc, VALUE *argv, VALUE self) { FXFileItem *arg1 = (FXFileItem *) 0 ;
    unsigned long result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileItem, 1);
    result = (unsigned long)((FXFileItem const *)arg1)->getSize(); vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXFileItem_getDate(int argc, VALUE *argv, VALUE self) { FXFileItem *arg1 = (FXFileItem *) 0 ; FXTime result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileItem, 1); result = (FXTime)((FXFileItem const *)arg1)->getDate();
    vresult = INT2NUM(result); return vresult; }
static void
free_FXFileItem(FXFileItem *arg1) {
    delete arg1;
}
static VALUE _wrap_FXFileItem_save(int argc, VALUE *argv, VALUE self) { FXFileItem *arg1 = (FXFileItem *) 0 ;
    FXStream *arg2 = 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileItem, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXFileItem_save((FXFileItem const *)arg1,*arg2); return Qnil; }
static VALUE _wrap_FXFileItem_load(int argc, VALUE *argv, VALUE self) { FXFileItem *arg1 = (FXFileItem *) 0 ;
    FXStream *arg2 = 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileItem, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXFileItem_load(arg1,*arg2); return Qnil; }
static VALUE _wrap_FXFileItem_draw(int argc, VALUE *argv, VALUE self) { FXFileItem *arg1 = (FXFileItem *) 0 ;
    FXIconList *arg2 = (FXIconList *) 0 ; FXDC *arg3 = 0 ; FXint arg4 ; FXint arg5 ; FXint arg6 ; FXint arg7 ;
    if ((argc < 6) || (argc > 6)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 6)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileItem, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXIconList, 1);
    SWIG_ConvertPtr(argv[1], (void **) &arg3, SWIGTYPE_p_FXDC, 1); if (arg3 == NULL) rb_raise(rb_eTypeError, "null reference");
    arg4 = NUM2INT(argv[2]); arg5 = NUM2INT(argv[3]); arg6 = NUM2INT(argv[4]); arg7 = NUM2INT(argv[5]);
    FXFileItem_draw((FXFileItem const *)arg1,(FXIconList const *)arg2,*arg3,arg4,arg5,arg6,arg7); return Qnil; }
static VALUE _wrap_FXFileItem_hitItem(int argc, VALUE *argv, VALUE self) { FXFileItem *arg1 = (FXFileItem *) 0 ;
    FXIconList *arg2 = (FXIconList *) 0 ; FXint arg3 ; FXint arg4 ; FXint arg5 = (FXint) 1 ; FXint arg6 = (FXint) 1 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 3) || (argc > 5))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileItem, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXIconList, 1); arg3 = NUM2INT(argv[1]); arg4 = NUM2INT(argv[2]);
    if (argc > 3) { arg5 = NUM2INT(argv[3]); }  if (argc > 4) { arg6 = NUM2INT(argv[4]); } 
    result = (FXint)FXFileItem_hitItem((FXFileItem const *)arg1,(FXIconList const *)arg2,arg3,arg4,arg5,arg6);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXFileItem_drawBigIcon(int argc, VALUE *argv, VALUE self) { FXFileItem *arg1 = (FXFileItem *) 0 ;
    FXIconList *arg2 = (FXIconList *) 0 ; FXDC *arg3 = 0 ; FXint arg4 ; FXint arg5 ; FXint arg6 ; FXint arg7 ;
    if ((argc < 6) || (argc > 6)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 6)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileItem, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXIconList, 1);
    SWIG_ConvertPtr(argv[1], (void **) &arg3, SWIGTYPE_p_FXDC, 1); if (arg3 == NULL) rb_raise(rb_eTypeError, "null reference");
    arg4 = NUM2INT(argv[2]); arg5 = NUM2INT(argv[3]); arg6 = NUM2INT(argv[4]); arg7 = NUM2INT(argv[5]);
    FXFileItem_drawBigIcon((FXFileItem const *)arg1,(FXIconList const *)arg2,*arg3,arg4,arg5,arg6,arg7); return Qnil; }
static VALUE _wrap_FXFileItem_drawMiniIcon(int argc, VALUE *argv, VALUE self) { FXFileItem *arg1 = (FXFileItem *) 0 ;
    FXIconList *arg2 = (FXIconList *) 0 ; FXDC *arg3 = 0 ; FXint arg4 ; FXint arg5 ; FXint arg6 ; FXint arg7 ;
    if ((argc < 6) || (argc > 6)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 6)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileItem, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXIconList, 1);
    SWIG_ConvertPtr(argv[1], (void **) &arg3, SWIGTYPE_p_FXDC, 1); if (arg3 == NULL) rb_raise(rb_eTypeError, "null reference");
    arg4 = NUM2INT(argv[2]); arg5 = NUM2INT(argv[3]); arg6 = NUM2INT(argv[4]); arg7 = NUM2INT(argv[5]);
    FXFileItem_drawMiniIcon((FXFileItem const *)arg1,(FXIconList const *)arg2,*arg3,arg4,arg5,arg6,arg7); return Qnil; }
static VALUE _wrap_FXFileItem_drawDetails(int argc, VALUE *argv, VALUE self) { FXFileItem *arg1 = (FXFileItem *) 0 ;
    FXIconList *arg2 = (FXIconList *) 0 ; FXDC *arg3 = 0 ; FXint arg4 ; FXint arg5 ; FXint arg6 ; FXint arg7 ;
    if ((argc < 6) || (argc > 6)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 6)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileItem, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXIconList, 1);
    SWIG_ConvertPtr(argv[1], (void **) &arg3, SWIGTYPE_p_FXDC, 1); if (arg3 == NULL) rb_raise(rb_eTypeError, "null reference");
    arg4 = NUM2INT(argv[2]); arg5 = NUM2INT(argv[3]); arg6 = NUM2INT(argv[4]); arg7 = NUM2INT(argv[5]);
    FXFileItem_drawDetails((FXFileItem const *)arg1,(FXIconList const *)arg2,*arg3,arg4,arg5,arg6,arg7); return Qnil; }
static VALUE _wrap_FXFileItem_setText(int argc, VALUE *argv, VALUE self) { FXFileItem *arg1 = (FXFileItem *) 0 ;
    FXString *arg2 = 0 ; SwigValueWrapper<FXString > p2 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileItem, 1); p2 = to_FXString(argv[0]); arg2 = &p2;
    FXFileItem_setText(arg1,(FXString const &)*arg2); return Qnil; }
static VALUE _wrap_FXFileItem_setBigIcon(int argc, VALUE *argv, VALUE self) { FXFileItem *arg1 = (FXFileItem *) 0 ;
    FXIcon *arg2 = (FXIcon *) 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileItem, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXIcon, 1); FXFileItem_setBigIcon(arg1,arg2); return Qnil; }
static VALUE _wrap_FXFileItem_setMiniIcon(int argc, VALUE *argv, VALUE self) { FXFileItem *arg1 = (FXFileItem *) 0 ;
    FXIcon *arg2 = (FXIcon *) 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileItem, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXIcon, 1); FXFileItem_setMiniIcon(arg1,arg2); return Qnil; }
static VALUE _wrap_FXFileItem_setFocus(int argc, VALUE *argv, VALUE self) { FXFileItem *arg1 = (FXFileItem *) 0 ; FXbool arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileItem, 1); arg2 = to_FXbool(argv[0]); FXFileItem_setFocus(arg1,arg2);
    return Qnil; }
static VALUE _wrap_FXFileItem_setSelected(int argc, VALUE *argv, VALUE self) { FXFileItem *arg1 = (FXFileItem *) 0 ;
    FXbool arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileItem, 1); arg2 = to_FXbool(argv[0]);
    FXFileItem_setSelected(arg1,arg2); return Qnil; }
static VALUE _wrap_FXFileItem_setEnabled(int argc, VALUE *argv, VALUE self) { FXFileItem *arg1 = (FXFileItem *) 0 ;
    FXbool arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileItem, 1); arg2 = to_FXbool(argv[0]);
    FXFileItem_setEnabled(arg1,arg2); return Qnil; }
static VALUE _wrap_FXFileItem_setDraggable(int argc, VALUE *argv, VALUE self) { FXFileItem *arg1 = (FXFileItem *) 0 ;
    FXbool arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileItem, 1); arg2 = to_FXbool(argv[0]);
    FXFileItem_setDraggable(arg1,arg2); return Qnil; }
static VALUE _wrap_FXFileItem_setIconOwned(int argc, VALUE *argv, VALUE self) { FXFileItem *arg1 = (FXFileItem *) 0 ;
    FXuint arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileItem, 1); arg2 = NUM2UINT(argv[0]);
    FXFileItem_setIconOwned(arg1,arg2); return Qnil; }
static VALUE _wrap_FXFileItem_getWidth(int argc, VALUE *argv, VALUE self) { FXFileItem *arg1 = (FXFileItem *) 0 ;
    FXIconList *arg2 = (FXIconList *) 0 ; FXint result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileItem, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXIconList, 1);
    result = (FXint)FXFileItem_getWidth((FXFileItem const *)arg1,(FXIconList const *)arg2); vresult = INT2NUM(result);
    return vresult; }
static VALUE _wrap_FXFileItem_getHeight(int argc, VALUE *argv, VALUE self) { FXFileItem *arg1 = (FXFileItem *) 0 ;
    FXIconList *arg2 = (FXIconList *) 0 ; FXint result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileItem, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXIconList, 1);
    result = (FXint)FXFileItem_getHeight((FXFileItem const *)arg1,(FXIconList const *)arg2); vresult = INT2NUM(result);
    return vresult; }
static VALUE _wrap_FXFileItem_create(int argc, VALUE *argv, VALUE self) { FXFileItem *arg1 = (FXFileItem *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileItem, 1); FXFileItem_create(arg1); return Qnil; }
static VALUE _wrap_FXFileItem_detach(int argc, VALUE *argv, VALUE self) { FXFileItem *arg1 = (FXFileItem *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileItem, 1); FXFileItem_detach(arg1); return Qnil; }
static VALUE _wrap_FXFileItem_destroy(int argc, VALUE *argv, VALUE self) { FXFileItem *arg1 = (FXFileItem *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileItem, 1); FXFileItem_destroy(arg1); return Qnil; }
static VALUE _wrap_FXFileList_onRefreshTimer(int argc, VALUE *argv, VALUE self) { FXFileList *arg1 = (FXFileList *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onRefreshTimer(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXFileList_onOpenTimer(int argc, VALUE *argv, VALUE self) { FXFileList *arg1 = (FXFileList *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onOpenTimer(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXFileList_onDNDEnter(int argc, VALUE *argv, VALUE self) { FXFileList *arg1 = (FXFileList *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onDNDEnter(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXFileList_onDNDLeave(int argc, VALUE *argv, VALUE self) { FXFileList *arg1 = (FXFileList *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onDNDLeave(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXFileList_onDNDMotion(int argc, VALUE *argv, VALUE self) { FXFileList *arg1 = (FXFileList *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onDNDMotion(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXFileList_onDNDDrop(int argc, VALUE *argv, VALUE self) { FXFileList *arg1 = (FXFileList *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onDNDDrop(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXFileList_onDNDRequest(int argc, VALUE *argv, VALUE self) { FXFileList *arg1 = (FXFileList *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onDNDRequest(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXFileList_onBeginDrag(int argc, VALUE *argv, VALUE self) { FXFileList *arg1 = (FXFileList *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onBeginDrag(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXFileList_onEndDrag(int argc, VALUE *argv, VALUE self) { FXFileList *arg1 = (FXFileList *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onEndDrag(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXFileList_onDragged(int argc, VALUE *argv, VALUE self) { FXFileList *arg1 = (FXFileList *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onDragged(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXFileList_onCmdSetValue(int argc, VALUE *argv, VALUE self) { FXFileList *arg1 = (FXFileList *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]);
    arg4 = static_cast<void*>(STR2CSTR(argv[2])); result = (long)(arg1)->onCmdSetValue(arg2,arg3,arg4);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXFileList_onCmdGetStringValue(int argc, VALUE *argv, VALUE self) { FXFileList *arg1 = (FXFileList *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; FXString value4 ;
    VALUE vresult = Qnil; if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); {
        value4 = FXString(STR2CSTR(argv[2])); arg4 = (void *) &value4; } 
    result = (long)(arg1)->onCmdGetStringValue(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXFileList_onCmdSetStringValue(int argc, VALUE *argv, VALUE self) { FXFileList *arg1 = (FXFileList *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdSetStringValue(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXFileList_onCmdDirectoryUp(int argc, VALUE *argv, VALUE self) { FXFileList *arg1 = (FXFileList *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdDirectoryUp(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXFileList_onUpdDirectoryUp(int argc, VALUE *argv, VALUE self) { FXFileList *arg1 = (FXFileList *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onUpdDirectoryUp(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXFileList_onCmdSortByName(int argc, VALUE *argv, VALUE self) { FXFileList *arg1 = (FXFileList *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdSortByName(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXFileList_onUpdSortByName(int argc, VALUE *argv, VALUE self) { FXFileList *arg1 = (FXFileList *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onUpdSortByName(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXFileList_onCmdSortByType(int argc, VALUE *argv, VALUE self) { FXFileList *arg1 = (FXFileList *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdSortByType(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXFileList_onUpdSortByType(int argc, VALUE *argv, VALUE self) { FXFileList *arg1 = (FXFileList *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onUpdSortByType(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXFileList_onCmdSortBySize(int argc, VALUE *argv, VALUE self) { FXFileList *arg1 = (FXFileList *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdSortBySize(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXFileList_onUpdSortBySize(int argc, VALUE *argv, VALUE self) { FXFileList *arg1 = (FXFileList *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onUpdSortBySize(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXFileList_onCmdSortByTime(int argc, VALUE *argv, VALUE self) { FXFileList *arg1 = (FXFileList *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdSortByTime(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXFileList_onUpdSortByTime(int argc, VALUE *argv, VALUE self) { FXFileList *arg1 = (FXFileList *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onUpdSortByTime(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXFileList_onCmdSortByUser(int argc, VALUE *argv, VALUE self) { FXFileList *arg1 = (FXFileList *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdSortByUser(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXFileList_onUpdSortByUser(int argc, VALUE *argv, VALUE self) { FXFileList *arg1 = (FXFileList *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onUpdSortByUser(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXFileList_onCmdSortByGroup(int argc, VALUE *argv, VALUE self) { FXFileList *arg1 = (FXFileList *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdSortByGroup(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXFileList_onUpdSortByGroup(int argc, VALUE *argv, VALUE self) { FXFileList *arg1 = (FXFileList *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onUpdSortByGroup(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXFileList_onCmdSortReverse(int argc, VALUE *argv, VALUE self) { FXFileList *arg1 = (FXFileList *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdSortReverse(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXFileList_onUpdSortReverse(int argc, VALUE *argv, VALUE self) { FXFileList *arg1 = (FXFileList *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onUpdSortReverse(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXFileList_onCmdSortCase(int argc, VALUE *argv, VALUE self) { FXFileList *arg1 = (FXFileList *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdSortCase(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXFileList_onUpdSortCase(int argc, VALUE *argv, VALUE self) { FXFileList *arg1 = (FXFileList *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onUpdSortCase(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXFileList_onCmdSetPattern(int argc, VALUE *argv, VALUE self) { FXFileList *arg1 = (FXFileList *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]);
    arg4 = static_cast<void*>(STR2CSTR(argv[2])); result = (long)(arg1)->onCmdSetPattern(arg2,arg3,arg4);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXFileList_onUpdSetPattern(int argc, VALUE *argv, VALUE self) { FXFileList *arg1 = (FXFileList *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onUpdSetPattern(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXFileList_onCmdSetDirectory(int argc, VALUE *argv, VALUE self) { FXFileList *arg1 = (FXFileList *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]);
    arg4 = static_cast<void*>(STR2CSTR(argv[2])); result = (long)(arg1)->onCmdSetDirectory(arg2,arg3,arg4);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXFileList_onUpdSetDirectory(int argc, VALUE *argv, VALUE self) { FXFileList *arg1 = (FXFileList *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onUpdSetDirectory(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXFileList_onCmdToggleHidden(int argc, VALUE *argv, VALUE self) { FXFileList *arg1 = (FXFileList *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdToggleHidden(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXFileList_onUpdToggleHidden(int argc, VALUE *argv, VALUE self) { FXFileList *arg1 = (FXFileList *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onUpdToggleHidden(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXFileList_onCmdShowHidden(int argc, VALUE *argv, VALUE self) { FXFileList *arg1 = (FXFileList *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdShowHidden(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXFileList_onUpdShowHidden(int argc, VALUE *argv, VALUE self) { FXFileList *arg1 = (FXFileList *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onUpdShowHidden(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXFileList_onCmdHideHidden(int argc, VALUE *argv, VALUE self) { FXFileList *arg1 = (FXFileList *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdHideHidden(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXFileList_onUpdHideHidden(int argc, VALUE *argv, VALUE self) { FXFileList *arg1 = (FXFileList *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onUpdHideHidden(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXFileList_onCmdHeader(int argc, VALUE *argv, VALUE self) { FXFileList *arg1 = (FXFileList *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]);
    arg4 = reinterpret_cast<void*>(NUM2UINT(argv[2])); result = (long)(arg1)->onCmdHeader(arg2,arg3,arg4);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXFileList_onUpdHeader(int argc, VALUE *argv, VALUE self) { FXFileList *arg1 = (FXFileList *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onUpdHeader(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXFileList_onCmdRefresh(int argc, VALUE *argv, VALUE self) { FXFileList *arg1 = (FXFileList *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdRefresh(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXFileList_ascending(int argc, VALUE *argv, VALUE self) { FXIconItem *arg1 = (FXIconItem *) 0 ;
    FXIconItem *arg2 = (FXIconItem *) 0 ; FXint result; VALUE vresult = Qnil; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXIconItem, 1);
    SWIG_ConvertPtr(argv[1], (void **) &arg2, SWIGTYPE_p_FXIconItem, 1);
    result = (FXint)FXFileList::ascending((FXIconItem const *)arg1,(FXIconItem const *)arg2); vresult = INT2NUM(result);
    return vresult; }
static VALUE _wrap_FXFileList_descending(int argc, VALUE *argv, VALUE self) { FXIconItem *arg1 = (FXIconItem *) 0 ;
    FXIconItem *arg2 = (FXIconItem *) 0 ; FXint result; VALUE vresult = Qnil; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXIconItem, 1);
    SWIG_ConvertPtr(argv[1], (void **) &arg2, SWIGTYPE_p_FXIconItem, 1);
    result = (FXint)FXFileList::descending((FXIconItem const *)arg1,(FXIconItem const *)arg2); vresult = INT2NUM(result);
    return vresult; }
static VALUE _wrap_FXFileList_ascendingCase(int argc, VALUE *argv, VALUE self) { FXIconItem *arg1 = (FXIconItem *) 0 ;
    FXIconItem *arg2 = (FXIconItem *) 0 ; FXint result; VALUE vresult = Qnil; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXIconItem, 1);
    SWIG_ConvertPtr(argv[1], (void **) &arg2, SWIGTYPE_p_FXIconItem, 1);
    result = (FXint)FXFileList::ascendingCase((FXIconItem const *)arg1,(FXIconItem const *)arg2); vresult = INT2NUM(result);
    return vresult; }
static VALUE _wrap_FXFileList_descendingCase(int argc, VALUE *argv, VALUE self) { FXIconItem *arg1 = (FXIconItem *) 0 ;
    FXIconItem *arg2 = (FXIconItem *) 0 ; FXint result; VALUE vresult = Qnil; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXIconItem, 1);
    SWIG_ConvertPtr(argv[1], (void **) &arg2, SWIGTYPE_p_FXIconItem, 1);
    result = (FXint)FXFileList::descendingCase((FXIconItem const *)arg1,(FXIconItem const *)arg2); vresult = INT2NUM(result);
    return vresult; }
static VALUE _wrap_FXFileList_ascendingType(int argc, VALUE *argv, VALUE self) { FXIconItem *arg1 = (FXIconItem *) 0 ;
    FXIconItem *arg2 = (FXIconItem *) 0 ; FXint result; VALUE vresult = Qnil; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXIconItem, 1);
    SWIG_ConvertPtr(argv[1], (void **) &arg2, SWIGTYPE_p_FXIconItem, 1);
    result = (FXint)FXFileList::ascendingType((FXIconItem const *)arg1,(FXIconItem const *)arg2); vresult = INT2NUM(result);
    return vresult; }
static VALUE _wrap_FXFileList_descendingType(int argc, VALUE *argv, VALUE self) { FXIconItem *arg1 = (FXIconItem *) 0 ;
    FXIconItem *arg2 = (FXIconItem *) 0 ; FXint result; VALUE vresult = Qnil; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXIconItem, 1);
    SWIG_ConvertPtr(argv[1], (void **) &arg2, SWIGTYPE_p_FXIconItem, 1);
    result = (FXint)FXFileList::descendingType((FXIconItem const *)arg1,(FXIconItem const *)arg2); vresult = INT2NUM(result);
    return vresult; }
static VALUE _wrap_FXFileList_ascendingSize(int argc, VALUE *argv, VALUE self) { FXIconItem *arg1 = (FXIconItem *) 0 ;
    FXIconItem *arg2 = (FXIconItem *) 0 ; FXint result; VALUE vresult = Qnil; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXIconItem, 1);
    SWIG_ConvertPtr(argv[1], (void **) &arg2, SWIGTYPE_p_FXIconItem, 1);
    result = (FXint)FXFileList::ascendingSize((FXIconItem const *)arg1,(FXIconItem const *)arg2); vresult = INT2NUM(result);
    return vresult; }
static VALUE _wrap_FXFileList_descendingSize(int argc, VALUE *argv, VALUE self) { FXIconItem *arg1 = (FXIconItem *) 0 ;
    FXIconItem *arg2 = (FXIconItem *) 0 ; FXint result; VALUE vresult = Qnil; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXIconItem, 1);
    SWIG_ConvertPtr(argv[1], (void **) &arg2, SWIGTYPE_p_FXIconItem, 1);
    result = (FXint)FXFileList::descendingSize((FXIconItem const *)arg1,(FXIconItem const *)arg2); vresult = INT2NUM(result);
    return vresult; }
static VALUE _wrap_FXFileList_ascendingTime(int argc, VALUE *argv, VALUE self) { FXIconItem *arg1 = (FXIconItem *) 0 ;
    FXIconItem *arg2 = (FXIconItem *) 0 ; FXint result; VALUE vresult = Qnil; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXIconItem, 1);
    SWIG_ConvertPtr(argv[1], (void **) &arg2, SWIGTYPE_p_FXIconItem, 1);
    result = (FXint)FXFileList::ascendingTime((FXIconItem const *)arg1,(FXIconItem const *)arg2); vresult = INT2NUM(result);
    return vresult; }
static VALUE _wrap_FXFileList_descendingTime(int argc, VALUE *argv, VALUE self) { FXIconItem *arg1 = (FXIconItem *) 0 ;
    FXIconItem *arg2 = (FXIconItem *) 0 ; FXint result; VALUE vresult = Qnil; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXIconItem, 1);
    SWIG_ConvertPtr(argv[1], (void **) &arg2, SWIGTYPE_p_FXIconItem, 1);
    result = (FXint)FXFileList::descendingTime((FXIconItem const *)arg1,(FXIconItem const *)arg2); vresult = INT2NUM(result);
    return vresult; }
static VALUE _wrap_FXFileList_ascendingUser(int argc, VALUE *argv, VALUE self) { FXIconItem *arg1 = (FXIconItem *) 0 ;
    FXIconItem *arg2 = (FXIconItem *) 0 ; FXint result; VALUE vresult = Qnil; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXIconItem, 1);
    SWIG_ConvertPtr(argv[1], (void **) &arg2, SWIGTYPE_p_FXIconItem, 1);
    result = (FXint)FXFileList::ascendingUser((FXIconItem const *)arg1,(FXIconItem const *)arg2); vresult = INT2NUM(result);
    return vresult; }
static VALUE _wrap_FXFileList_descendingUser(int argc, VALUE *argv, VALUE self) { FXIconItem *arg1 = (FXIconItem *) 0 ;
    FXIconItem *arg2 = (FXIconItem *) 0 ; FXint result; VALUE vresult = Qnil; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXIconItem, 1);
    SWIG_ConvertPtr(argv[1], (void **) &arg2, SWIGTYPE_p_FXIconItem, 1);
    result = (FXint)FXFileList::descendingUser((FXIconItem const *)arg1,(FXIconItem const *)arg2); vresult = INT2NUM(result);
    return vresult; }
static VALUE _wrap_FXFileList_ascendingGroup(int argc, VALUE *argv, VALUE self) { FXIconItem *arg1 = (FXIconItem *) 0 ;
    FXIconItem *arg2 = (FXIconItem *) 0 ; FXint result; VALUE vresult = Qnil; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXIconItem, 1);
    SWIG_ConvertPtr(argv[1], (void **) &arg2, SWIGTYPE_p_FXIconItem, 1);
    result = (FXint)FXFileList::ascendingGroup((FXIconItem const *)arg1,(FXIconItem const *)arg2); vresult = INT2NUM(result);
    return vresult; }
static VALUE _wrap_FXFileList_descendingGroup(int argc, VALUE *argv, VALUE self) { FXIconItem *arg1 = (FXIconItem *) 0 ;
    FXIconItem *arg2 = (FXIconItem *) 0 ; FXint result; VALUE vresult = Qnil; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXIconItem, 1);
    SWIG_ConvertPtr(argv[1], (void **) &arg2, SWIGTYPE_p_FXIconItem, 1);
    result = (FXint)FXFileList::descendingGroup((FXIconItem const *)arg1,(FXIconItem const *)arg2); vresult = INT2NUM(result);
    return vresult; }
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE _wrap_FXFileList_allocate(VALUE self) {
#else
     static VALUE _wrap_FXFileList_allocate(int argc, VALUE *argv, VALUE self) {
#endif
         VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_FXFileList);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
         return vresult; }
static VALUE _wrap_new_FXFileList(int argc, VALUE *argv, VALUE self) { FXComposite *arg1 = (FXComposite *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 = (FXSelector) 0 ; FXuint arg4 = (FXuint) 0 ; FXint arg5 = (FXint) 0 ;
    FXint arg6 = (FXint) 0 ; FXint arg7 = (FXint) 0 ; FXint arg8 = (FXint) 0 ; FXFileList *result; if ((argc < 1) || (argc > 8))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXComposite, 1); if (argc > 1) {
        SWIG_ConvertPtr(argv[1], (void **) &arg2, SWIGTYPE_p_FXObject, 1); }  if (argc > 2) { arg3 = NUM2UINT(argv[2]); } 
    if (argc > 3) { arg4 = NUM2UINT(argv[3]); }  if (argc > 4) { arg5 = NUM2INT(argv[4]); }  if (argc > 5) {
        arg6 = NUM2INT(argv[5]); }  if (argc > 6) { arg7 = NUM2INT(argv[6]); }  if (argc > 7) { arg8 = NUM2INT(argv[7]); }  {
        result = (FXFileList *)new_FXFileList(arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8);
        DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result); if(rb_block_given_p()){ rb_yield(self); }  }  return self; }
static VALUE _wrap_FXFileList_scan(int argc, VALUE *argv, VALUE self) { FXFileList *arg1 = (FXFileList *) 0 ;
    FXbool arg2 = (FXbool) 1 ; if ((argc < 0) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileList, 1); if (argc > 0) { arg2 = to_FXbool(argv[0]); } 
    (arg1)->scan(arg2); return Qnil; }
static VALUE _wrap_FXFileList_setCurrentFile(int argc, VALUE *argv, VALUE self) { FXFileList *arg1 = (FXFileList *) 0 ;
    FXString *arg2 = 0 ; SwigValueWrapper<FXString > p2 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileList, 1); p2 = to_FXString(argv[0]); arg2 = &p2;
    (arg1)->setCurrentFile((FXString const &)*arg2); return Qnil; }
static VALUE _wrap_FXFileList_getCurrentFile(int argc, VALUE *argv, VALUE self) { FXFileList *arg1 = (FXFileList *) 0 ;
    FXString result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileList, 1); result = ((FXFileList const *)arg1)->getCurrentFile();
    vresult = rb_str_new2((&result)->text()); return vresult; }
static VALUE _wrap_FXFileList_setDirectory(int argc, VALUE *argv, VALUE self) { FXFileList *arg1 = (FXFileList *) 0 ;
    FXString *arg2 = 0 ; SwigValueWrapper<FXString > p2 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileList, 1); p2 = to_FXString(argv[0]); arg2 = &p2;
    (arg1)->setDirectory((FXString const &)*arg2); return Qnil; }
static VALUE _wrap_FXFileList_getDirectory(int argc, VALUE *argv, VALUE self) { FXFileList *arg1 = (FXFileList *) 0 ;
    FXString result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileList, 1); result = ((FXFileList const *)arg1)->getDirectory();
    vresult = rb_str_new2((&result)->text()); return vresult; }
static VALUE _wrap_FXFileList_setPattern(int argc, VALUE *argv, VALUE self) { FXFileList *arg1 = (FXFileList *) 0 ;
    FXString *arg2 = 0 ; SwigValueWrapper<FXString > p2 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileList, 1); p2 = to_FXString(argv[0]); arg2 = &p2;
    (arg1)->setPattern((FXString const &)*arg2); return Qnil; }
static VALUE _wrap_FXFileList_getPattern(int argc, VALUE *argv, VALUE self) { FXFileList *arg1 = (FXFileList *) 0 ;
    FXString result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileList, 1); result = ((FXFileList const *)arg1)->getPattern();
    vresult = rb_str_new2((&result)->text()); return vresult; }
static VALUE _wrap_FXFileList_isItemDirectory(int argc, VALUE *argv, VALUE self) { FXFileList *arg1 = (FXFileList *) 0 ;
    FXint arg2 ; FXbool result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileList, 1); arg2 = NUM2INT(argv[0]); {
        if (arg2 < 0 || arg2 >= arg1->getNumItems()) { rb_raise(rb_eIndexError, "file list item index out of bounds"); }  } 
    result = (FXbool)((FXFileList const *)arg1)->isItemDirectory(arg2); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXFileList_isItemShare(int argc, VALUE *argv, VALUE self) { FXFileList *arg1 = (FXFileList *) 0 ;
    FXint arg2 ; FXbool result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileList, 1); arg2 = NUM2INT(argv[0]); {
        if (arg2 < 0 || arg2 >= arg1->getNumItems()) { rb_raise(rb_eIndexError, "file list item index out of bounds"); }  } 
    result = (FXbool)((FXFileList const *)arg1)->isItemShare(arg2); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXFileList_isItemFile(int argc, VALUE *argv, VALUE self) { FXFileList *arg1 = (FXFileList *) 0 ; FXint arg2 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileList, 1); arg2 = NUM2INT(argv[0]); {
        if (arg2 < 0 || arg2 >= arg1->getNumItems()) { rb_raise(rb_eIndexError, "file list item index out of bounds"); }  } 
    result = (FXbool)((FXFileList const *)arg1)->isItemFile(arg2); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXFileList_isItemExecutable(int argc, VALUE *argv, VALUE self) { FXFileList *arg1 = (FXFileList *) 0 ;
    FXint arg2 ; FXbool result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileList, 1); arg2 = NUM2INT(argv[0]); {
        if (arg2 < 0 || arg2 >= arg1->getNumItems()) { rb_raise(rb_eIndexError, "file list item index out of bounds"); }  } 
    result = (FXbool)((FXFileList const *)arg1)->isItemExecutable(arg2); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXFileList_getItemFilename(int argc, VALUE *argv, VALUE self) { FXFileList *arg1 = (FXFileList *) 0 ;
    FXint arg2 ; FXString result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileList, 1); arg2 = NUM2INT(argv[0]); {
        if (arg2 < 0 || arg2 >= arg1->getNumItems()) { rb_raise(rb_eIndexError, "file list item index out of bounds"); }  } 
    result = ((FXFileList const *)arg1)->getItemFilename(arg2); vresult = rb_str_new2((&result)->text()); return vresult; }
static VALUE _wrap_FXFileList_getItemPathname(int argc, VALUE *argv, VALUE self) { FXFileList *arg1 = (FXFileList *) 0 ;
    FXint arg2 ; FXString result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileList, 1); arg2 = NUM2INT(argv[0]); {
        if (arg2 < 0 || arg2 >= arg1->getNumItems()) { rb_raise(rb_eIndexError, "file list item index out of bounds"); }  } 
    result = ((FXFileList const *)arg1)->getItemPathname(arg2); vresult = rb_str_new2((&result)->text()); return vresult; }
static VALUE _wrap_FXFileList_getItemAssoc(int argc, VALUE *argv, VALUE self) { FXFileList *arg1 = (FXFileList *) 0 ;
    FXint arg2 ; FXFileAssoc *result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileList, 1); arg2 = NUM2INT(argv[0]); {
        if (arg2 < 0 || arg2 >= arg1->getNumItems()) { rb_raise(rb_eIndexError, "file list item index out of bounds"); }  } 
    result = (FXFileAssoc *)((FXFileList const *)arg1)->getItemAssoc(arg2); vresult = FXRbGetRubyObj(result, "FXFileAssoc *");
    return vresult; }
static VALUE _wrap_FXFileList_getMatchMode(int argc, VALUE *argv, VALUE self) { FXFileList *arg1 = (FXFileList *) 0 ;
    FXuint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileList, 1);
    result = (FXuint)((FXFileList const *)arg1)->getMatchMode(); vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXFileList_setMatchMode(int argc, VALUE *argv, VALUE self) { FXFileList *arg1 = (FXFileList *) 0 ;
    FXuint arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileList, 1); arg2 = NUM2UINT(argv[0]); (arg1)->setMatchMode(arg2);
    return Qnil; }
static VALUE _wrap_FXFileList_getHiddenFilesShown(int argc, VALUE *argv, VALUE self) { FXFileList *arg1 = (FXFileList *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileList, 1);
    result = (FXbool)((FXFileList const *)arg1)->showHiddenFiles(); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXFileList_setHiddenFilesShown(int argc, VALUE *argv, VALUE self) { FXFileList *arg1 = (FXFileList *) 0 ;
    FXbool arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileList, 1); arg2 = to_FXbool(argv[0]); (arg1)->showHiddenFiles(arg2);
    return Qnil; }
static VALUE _wrap_FXFileList_getOnlyDirectoriesShown(int argc, VALUE *argv, VALUE self) { FXFileList *arg1 = (FXFileList *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileList, 1);
    result = (FXbool)((FXFileList const *)arg1)->showOnlyDirectories(); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXFileList_setOnlyDirectoriesShown(int argc, VALUE *argv, VALUE self) { FXFileList *arg1 = (FXFileList *) 0 ;
    FXbool arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileList, 1); arg2 = to_FXbool(argv[0]);
    (arg1)->showOnlyDirectories(arg2); return Qnil; }
static VALUE _wrap_FXFileList_showOnlyFiles__SWIG_0(int argc, VALUE *argv, VALUE self) { FXFileList *arg1 = (FXFileList *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileList, 1);
    result = (FXbool)((FXFileList const *)arg1)->showOnlyFiles(); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXFileList_showOnlyFiles__SWIG_1(int argc, VALUE *argv, VALUE self) { FXFileList *arg1 = (FXFileList *) 0 ;
    FXbool arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileList, 1); arg2 = to_FXbool(argv[0]); (arg1)->showOnlyFiles(arg2);
    return Qnil; }
static VALUE _wrap_FXFileList_showOnlyFiles(int nargs, VALUE *args, VALUE self) { int argc; VALUE argv[3]; int ii;
    argc = nargs + 1; argv[0] = self; for (ii = 1; (ii < argc) && (ii < 2); ii++) { argv[ii] = args[ii-1]; }  if (argc == 1) {
        int _v; { void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXFileList, 0) != -1)) ? 1 : 0; }
         if (_v) { return _wrap_FXFileList_showOnlyFiles__SWIG_0(nargs, args, self);}  }  if (argc == 2) { int _v; { void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXFileList, 0) != -1)) ? 1 : 0; }
         if (_v) { { _v = (argv[1] == Qtrue || argv[1] == Qfalse) ? 1 : 0; }  if (_v) {
                return _wrap_FXFileList_showOnlyFiles__SWIG_1(nargs, args, self);}  }  } 
    rb_raise(rb_eArgError, "No matching function for overloaded 'FXFileList_showOnlyFiles'"); return Qnil; }
static VALUE _wrap_FXFileList_setAssociations(int argc, VALUE *argv, VALUE self) { FXFileList *arg1 = (FXFileList *) 0 ;
    FXFileDict *arg2 = (FXFileDict *) 0 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXFileDict, 1); (arg1)->setAssociations(arg2); return Qnil; }
static VALUE _wrap_FXFileList_getAssociations(int argc, VALUE *argv, VALUE self) { FXFileList *arg1 = (FXFileList *) 0 ;
    FXFileDict *result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileList, 1);
    result = (FXFileDict *)((FXFileList const *)arg1)->getAssociations(); {
        swig_type_info *ty = SWIG_TypeDynamicCast(SWIGTYPE_p_FXFileDict, (void **) &result);
        vresult = FXRbGetRubyObj(result, ty); }  return vresult; }
static void
free_FXFileList(FXFileList *arg1) {
    delete arg1;
}
static VALUE _wrap_FXFileList_save(int argc, VALUE *argv, VALUE self) { FXFileList *arg1 = (FXFileList *) 0 ;
    FXStream *arg2 = 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXFileList_save((FXFileList const *)arg1,*arg2); return Qnil; }
static VALUE _wrap_FXFileList_load(int argc, VALUE *argv, VALUE self) { FXFileList *arg1 = (FXFileList *) 0 ;
    FXStream *arg2 = 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXFileList_load(arg1,*arg2); return Qnil; }
static VALUE _wrap_FXFileList_create(int argc, VALUE *argv, VALUE self) { FXFileList *arg1 = (FXFileList *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileList, 1); FXFileList_create(arg1); return Qnil; }
static VALUE _wrap_FXFileList_detach(int argc, VALUE *argv, VALUE self) { FXFileList *arg1 = (FXFileList *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileList, 1); FXFileList_detach(arg1); return Qnil; }
static VALUE _wrap_FXFileList_destroy(int argc, VALUE *argv, VALUE self) { FXFileList *arg1 = (FXFileList *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileList, 1); FXFileList_destroy(arg1); return Qnil; }
static VALUE _wrap_FXFileList_resize(int argc, VALUE *argv, VALUE self) { FXFileList *arg1 = (FXFileList *) 0 ; FXint arg2 ;
    FXint arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileList, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    FXFileList_resize(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXFileList_getDefaultWidth(int argc, VALUE *argv, VALUE self) { FXFileList *arg1 = (FXFileList *) 0 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileList, 1); result = (FXint)FXFileList_getDefaultWidth(arg1);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXFileList_getDefaultHeight(int argc, VALUE *argv, VALUE self) { FXFileList *arg1 = (FXFileList *) 0 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileList, 1); result = (FXint)FXFileList_getDefaultHeight(arg1);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXFileList_getWidthForHeight(int argc, VALUE *argv, VALUE self) { FXFileList *arg1 = (FXFileList *) 0 ;
    FXint arg2 ; FXint result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileList, 1); arg2 = NUM2INT(argv[0]);
    result = (FXint)FXFileList_getWidthForHeight(arg1,arg2); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXFileList_getHeightForWidth(int argc, VALUE *argv, VALUE self) { FXFileList *arg1 = (FXFileList *) 0 ;
    FXint arg2 ; FXint result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileList, 1); arg2 = NUM2INT(argv[0]);
    result = (FXint)FXFileList_getHeightForWidth(arg1,arg2); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXFileList_canFocus(int argc, VALUE *argv, VALUE self) { FXFileList *arg1 = (FXFileList *) 0 ; FXbool result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileList, 1);
    result = (FXbool)FXFileList_canFocus((FXFileList const *)arg1); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXFileList_setFocus(int argc, VALUE *argv, VALUE self) { FXFileList *arg1 = (FXFileList *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileList, 1); FXFileList_setFocus(arg1); return Qnil; }
static VALUE _wrap_FXFileList_killFocus(int argc, VALUE *argv, VALUE self) { FXFileList *arg1 = (FXFileList *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileList, 1); FXFileList_killFocus(arg1); return Qnil; }
static VALUE _wrap_FXFileList_setDefault(int argc, VALUE *argv, VALUE self) { FXFileList *arg1 = (FXFileList *) 0 ;
    FXbool arg2 = (FXbool) 1 ; if ((argc < 0) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileList, 1); if (argc > 0) { arg2 = to_FXbool(argv[0]); } 
    FXFileList_setDefault(arg1,arg2); return Qnil; }
static VALUE _wrap_FXFileList_enable(int argc, VALUE *argv, VALUE self) { FXFileList *arg1 = (FXFileList *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileList, 1); FXFileList_enable(arg1); return Qnil; }
static VALUE _wrap_FXFileList_disable(int argc, VALUE *argv, VALUE self) { FXFileList *arg1 = (FXFileList *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileList, 1); FXFileList_disable(arg1); return Qnil; }
static VALUE _wrap_FXFileList_raiseWindow(int argc, VALUE *argv, VALUE self) { FXFileList *arg1 = (FXFileList *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileList, 1); FXFileList_raise(arg1); return Qnil; }
static VALUE _wrap_FXFileList_lower(int argc, VALUE *argv, VALUE self) { FXFileList *arg1 = (FXFileList *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileList, 1); FXFileList_lower(arg1); return Qnil; }
static VALUE _wrap_FXFileList_move(int argc, VALUE *argv, VALUE self) { FXFileList *arg1 = (FXFileList *) 0 ; FXint arg2 ;
    FXint arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileList, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    FXFileList_move(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXFileList_position__SWIG_0(int argc, VALUE *argv, VALUE self) { FXFileList *arg1 = (FXFileList *) 0 ;
    FXint arg2 ; FXint arg3 ; FXint arg4 ; FXint arg5 ; if ((argc < 4) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileList, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    arg4 = NUM2INT(argv[2]); arg5 = NUM2INT(argv[3]); FXFileList_position(arg1,arg2,arg3,arg4,arg5); return Qnil; }
static VALUE _wrap_FXFileList_layout(int argc, VALUE *argv, VALUE self) { FXFileList *arg1 = (FXFileList *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileList, 1); FXFileList_layout(arg1); return Qnil; }
static VALUE _wrap_FXFileList_recalc(int argc, VALUE *argv, VALUE self) { FXFileList *arg1 = (FXFileList *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileList, 1); FXFileList_recalc(arg1); return Qnil; }
static VALUE _wrap_FXFileList_reparent(int argc, VALUE *argv, VALUE self) { FXFileList *arg1 = (FXFileList *) 0 ;
    FXComposite *arg2 = (FXComposite *) 0 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXComposite, 1); FXFileList_reparent(arg1,arg2); return Qnil; }
static VALUE _wrap_FXFileList_show(int argc, VALUE *argv, VALUE self) { FXFileList *arg1 = (FXFileList *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileList, 1); FXFileList_show(arg1); return Qnil; }
static VALUE _wrap_FXFileList_hide(int argc, VALUE *argv, VALUE self) { FXFileList *arg1 = (FXFileList *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileList, 1); FXFileList_hide(arg1); return Qnil; }
static VALUE _wrap_FXFileList_isComposite(int argc, VALUE *argv, VALUE self) { FXFileList *arg1 = (FXFileList *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileList, 1);
    result = (FXbool)FXFileList_isComposite((FXFileList const *)arg1); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXFileList_contains(int argc, VALUE *argv, VALUE self) { FXFileList *arg1 = (FXFileList *) 0 ; FXint arg2 ;
    FXint arg3 ; FXbool result; VALUE vresult = Qnil; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileList, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    result = (FXbool)FXFileList_contains((FXFileList const *)arg1,arg2,arg3); vresult = result ? Qtrue : Qfalse;
    return vresult; }
static VALUE _wrap_FXFileList_doesSaveUnder(int argc, VALUE *argv, VALUE self) { FXFileList *arg1 = (FXFileList *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileList, 1);
    result = (FXbool)FXFileList_doesSaveUnder((FXFileList const *)arg1); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXFileList_setBackColor(int argc, VALUE *argv, VALUE self) { FXFileList *arg1 = (FXFileList *) 0 ;
    FXColor arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileList, 1); arg2 = to_FXColor(argv[0]);
    FXFileList_setBackColor(arg1,arg2); return Qnil; }
static VALUE _wrap_FXFileList_getViewportHeight(int argc, VALUE *argv, VALUE self) { FXFileList *arg1 = (FXFileList *) 0 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileList, 1); result = (FXint)FXFileList_getViewportHeight(arg1);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXFileList_getViewportWidth(int argc, VALUE *argv, VALUE self) { FXFileList *arg1 = (FXFileList *) 0 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileList, 1); result = (FXint)FXFileList_getViewportWidth(arg1);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXFileList_getContentHeight(int argc, VALUE *argv, VALUE self) { FXFileList *arg1 = (FXFileList *) 0 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileList, 1); result = (FXint)FXFileList_getContentHeight(arg1);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXFileList_getContentWidth(int argc, VALUE *argv, VALUE self) { FXFileList *arg1 = (FXFileList *) 0 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileList, 1); result = (FXint)FXFileList_getContentWidth(arg1);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXFileList_position__SWIG_1(int argc, VALUE *argv, VALUE self) { FXFileList *arg1 = (FXFileList *) 0 ;
    VALUE result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileList, 1);
    result = (VALUE)FXFileList_position__SWIG_1((FXFileList const *)arg1); vresult = result; return vresult; }
static VALUE _wrap_FXFileList_position(int nargs, VALUE *args, VALUE self) { int argc; VALUE argv[6]; int ii; argc = nargs + 1;
    argv[0] = self; for (ii = 1; (ii < argc) && (ii < 5); ii++) { argv[ii] = args[ii-1]; }  if (argc == 1) { int _v; {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXFileList, 0) != -1)) ? 1 : 0; }
         if (_v) { return _wrap_FXFileList_position__SWIG_1(nargs, args, self);}  }  if (argc == 5) { int _v; { void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXFileList, 0) != -1)) ? 1 : 0; }
         if (_v) { { _v = ((TYPE(argv[1]) == T_FIXNUM) || (TYPE(argv[1]) == T_BIGNUM)) ? 1 : 0; }  if (_v) { {
                    _v = ((TYPE(argv[2]) == T_FIXNUM) || (TYPE(argv[2]) == T_BIGNUM)) ? 1 : 0; }  if (_v) { {
                        _v = ((TYPE(argv[3]) == T_FIXNUM) || (TYPE(argv[3]) == T_BIGNUM)) ? 1 : 0; }  if (_v) { {
                            _v = ((TYPE(argv[4]) == T_FIXNUM) || (TYPE(argv[4]) == T_BIGNUM)) ? 1 : 0; }  if (_v) {
                            return _wrap_FXFileList_position__SWIG_0(nargs, args, self);}  }  }  }  }  } 
    rb_raise(rb_eArgError, "No matching function for overloaded 'FXFileList_position'"); return Qnil; }
static VALUE _wrap_FXFileList_selectItem(int argc, VALUE *argv, VALUE self) { FXFileList *arg1 = (FXFileList *) 0 ; FXint arg2 ;
    FXbool arg3 = (FXbool) 0 ; FXbool result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileList, 1); arg2 = NUM2INT(argv[0]); if (argc > 1) {
        arg3 = to_FXbool(argv[1]); }  { if (arg2 < 0 || arg2 >= arg1->getNumItems()) {
            rb_raise(rb_eIndexError, "file list item index out of bounds"); }  } 
    result = (FXbool)FXFileList_selectItem(arg1,arg2,arg3); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXFileList_deselectItem(int argc, VALUE *argv, VALUE self) { FXFileList *arg1 = (FXFileList *) 0 ;
    FXint arg2 ; FXbool arg3 = (FXbool) 0 ; FXbool result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileList, 1); arg2 = NUM2INT(argv[0]); if (argc > 1) {
        arg3 = to_FXbool(argv[1]); }  { if (arg2 < 0 || arg2 >= arg1->getNumItems()) {
            rb_raise(rb_eIndexError, "file list item index out of bounds"); }  } 
    result = (FXbool)FXFileList_deselectItem(arg1,arg2,arg3); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXFileList_toggleItem(int argc, VALUE *argv, VALUE self) { FXFileList *arg1 = (FXFileList *) 0 ; FXint arg2 ;
    FXbool arg3 = (FXbool) 0 ; FXbool result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileList, 1); arg2 = NUM2INT(argv[0]); if (argc > 1) {
        arg3 = to_FXbool(argv[1]); }  { if (arg2 < 0 || arg2 >= arg1->getNumItems()) {
            rb_raise(rb_eIndexError, "file list item index out of bounds"); }  } 
    result = (FXbool)FXFileList_toggleItem(arg1,arg2,arg3); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXFileList_selectInRectangle(int argc, VALUE *argv, VALUE self) { FXFileList *arg1 = (FXFileList *) 0 ;
    FXint arg2 ; FXint arg3 ; FXint arg4 ; FXint arg5 ; FXbool arg6 = (FXbool) 0 ; FXbool result; VALUE vresult = Qnil;
    if ((argc < 4) || (argc > 5)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileList, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    arg4 = NUM2INT(argv[2]); arg5 = NUM2INT(argv[3]); if (argc > 4) { arg6 = to_FXbool(argv[4]); } 
    result = (FXbool)FXFileList_selectInRectangle(arg1,arg2,arg3,arg4,arg5,arg6); vresult = result ? Qtrue : Qfalse;
    return vresult; }
static VALUE _wrap_FXFileList_extendSelection(int argc, VALUE *argv, VALUE self) { FXFileList *arg1 = (FXFileList *) 0 ;
    FXint arg2 ; FXbool arg3 = (FXbool) 0 ; FXbool result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileList, 1); arg2 = NUM2INT(argv[0]); if (argc > 1) {
        arg3 = to_FXbool(argv[1]); }  { if (arg2 < 0 || arg2 >= arg1->getNumItems()) {
            rb_raise(rb_eIndexError, "file list item index out of bounds"); }  } 
    result = (FXbool)FXFileList_extendSelection(arg1,arg2,arg3); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXFileList_killSelection(int argc, VALUE *argv, VALUE self) { FXFileList *arg1 = (FXFileList *) 0 ;
    FXbool arg2 = (FXbool) 0 ; FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileList, 1); if (argc > 0) { arg2 = to_FXbool(argv[0]); } 
    result = (FXbool)FXFileList_killSelection(arg1,arg2); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXFileList_setCurrentItem(int argc, VALUE *argv, VALUE self) { FXFileList *arg1 = (FXFileList *) 0 ;
    FXint arg2 ; FXbool arg3 = (FXbool) 0 ; if ((argc < 1) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileList, 1); arg2 = NUM2INT(argv[0]); if (argc > 1) {
        arg3 = to_FXbool(argv[1]); }  { if (arg2 < 0 || arg2 >= arg1->getNumItems()) {
            rb_raise(rb_eIndexError, "file list item index out of bounds"); }  }  FXFileList_setCurrentItem(arg1,arg2,arg3);
    return Qnil; }

/* -------- TYPE CONVERSION AND EQUIVALENCE RULES (BEGIN) -------- */

static void *_p_FXFrameTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *) ((FXFrame *) x));
}
static void *_p_FXPopupTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXShell *) ((FXPopup *) x));
}
static void *_p_FXShutterItemTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *)(FXVerticalFrame *) ((FXShutterItem *) x));
}
static void *_p_FXScrollAreaTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *) ((FXScrollArea *) x));
}
static void *_p_FXStatusBarTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *)(FXHorizontalFrame *) ((FXStatusBar *) x));
}
static void *_p_FXMainWindowTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXShell *)(FXTopWindow *) ((FXMainWindow *) x));
}
static void *_p_FXTopWindowTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXShell *) ((FXTopWindow *) x));
}
static void *_p_FXRootWindowTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *) ((FXRootWindow *) x));
}
static void *_p_FXWindowTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *) ((FXWindow *) x));
}
static void *_p_FXCompositeTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *) ((FXComposite *) x));
}
static void *_p_FXScrollWindowTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXScrollArea *) ((FXScrollWindow *) x));
}
static void *_p_FXShellTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *) ((FXShell *) x));
}
static void *_p_FXGroupBoxTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXGroupBox *) x));
}
static void *_p_FXGIFCursorTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXCursor *) ((FXGIFCursor *) x));
}
static void *_p_FXCURCursorTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXCursor *) ((FXCURCursor *) x));
}
static void *_p_FXCursorTo_p_FXId(void *x) {
    return (void *)((FXId *)  ((FXCursor *) x));
}
static void *_p_FXDrawableTo_p_FXId(void *x) {
    return (void *)((FXId *)  ((FXDrawable *) x));
}
static void *_p_FXSplitterTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *) ((FXSplitter *) x));
}
static void *_p_FX4SplitterTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *) ((FX4Splitter *) x));
}
static void *_p_FXIconListTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXScrollArea *) ((FXIconList *) x));
}
static void *_p_FXFontTo_p_FXId(void *x) {
    return (void *)((FXId *)  ((FXFont *) x));
}
static void *_p_FXPackerTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *) ((FXPacker *) x));
}
static void *_p_FXHorizontalFrameTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXHorizontalFrame *) x));
}
static void *_p_FXVerticalFrameTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXVerticalFrame *) x));
}
static void *_p_FXShutterTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *)(FXVerticalFrame *) ((FXShutter *) x));
}
static void *_p_FXFileListTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXScrollArea *)(FXIconList *) ((FXFileList *) x));
}
static void *_p_FXVisualTo_p_FXId(void *x) {
    return (void *)((FXId *)  ((FXVisual *) x));
}
static void *_p_FXMatrixTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXMatrix *) x));
}
static void *_p_FXSpringTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXSpring *) x));
}
static void *_p_FXSwitcherTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXSwitcher *) x));
}
static void *_p_FXIconListTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXScrollArea *) ((FXIconList *) x));
}
static void *_p_FXSettingsTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXDict *) ((FXSettings *) x));
}
static void *_p_FXAccelTableTo_p_FXObject(void *x) {
    return (void *)((FXObject *)  ((FXAccelTable *) x));
}
static void *_p_FXCompositeTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *) ((FXComposite *) x));
}
static void *_p_FXRegistryTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXDict *)(FXSettings *) ((FXRegistry *) x));
}
static void *_p_FXIconDictTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXDict *) ((FXIconDict *) x));
}
static void *_p_FXGroupBoxTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXGroupBox *) x));
}
static void *_p_FXShellTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *) ((FXShell *) x));
}
static void *_p_FXPopupTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXShell *) ((FXPopup *) x));
}
static void *_p_FXStatusBarTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *)(FXHorizontalFrame *) ((FXStatusBar *) x));
}
static void *_p_FXScrollAreaTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *) ((FXScrollArea *) x));
}
static void *_p_FXRecentFilesTo_p_FXObject(void *x) {
    return (void *)((FXObject *)  ((FXRecentFiles *) x));
}
static void *_p_FXDocumentTo_p_FXObject(void *x) {
    return (void *)((FXObject *)  ((FXDocument *) x));
}
static void *_p_FXMainWindowTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXShell *)(FXTopWindow *) ((FXMainWindow *) x));
}
static void *_p_FXTopWindowTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXShell *) ((FXTopWindow *) x));
}
static void *_p_FXRootWindowTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *) ((FXRootWindow *) x));
}
static void *_p_FXWindowTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *) ((FXWindow *) x));
}
static void *_p_FXScrollWindowTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXScrollArea *) ((FXScrollWindow *) x));
}
static void *_p_FXIconItemTo_p_FXObject(void *x) {
    return (void *)((FXObject *)  ((FXIconItem *) x));
}
static void *_p_FXVerticalFrameTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXVerticalFrame *) x));
}
static void *_p_FXHorizontalFrameTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXHorizontalFrame *) x));
}
static void *_p_FXSplitterTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *) ((FXSplitter *) x));
}
static void *_p_FX4SplitterTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *) ((FX4Splitter *) x));
}
static void *_p_FXFileListTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXScrollArea *)(FXIconList *) ((FXFileList *) x));
}
static void *_p_FXStringDictTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXDict *) ((FXStringDict *) x));
}
static void *_p_FXPackerTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *) ((FXPacker *) x));
}
static void *_p_FXFontTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *) ((FXFont *) x));
}
static void *_p_FXFileDictTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXDict *) ((FXFileDict *) x));
}
static void *_p_FXDataTargetTo_p_FXObject(void *x) {
    return (void *)((FXObject *)  ((FXDataTarget *) x));
}
static void *_p_FXDebugTargetTo_p_FXObject(void *x) {
    return (void *)((FXObject *)  ((FXDebugTarget *) x));
}
static void *_p_FXSwitcherTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXSwitcher *) x));
}
static void *_p_FXShutterTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *)(FXVerticalFrame *) ((FXShutter *) x));
}
static void *_p_FXDelegatorTo_p_FXObject(void *x) {
    return (void *)((FXObject *)  ((FXDelegator *) x));
}
static void *_p_FXDrawableTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *) ((FXDrawable *) x));
}
static void *_p_FXGIFCursorTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXCursor *) ((FXGIFCursor *) x));
}
static void *_p_FXCURCursorTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXCursor *) ((FXCURCursor *) x));
}
static void *_p_FXCursorTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *) ((FXCursor *) x));
}
static void *_p_FXFileItemTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXIconItem *) ((FXFileItem *) x));
}
static void *_p_FXDictTo_p_FXObject(void *x) {
    return (void *)((FXObject *)  ((FXDict *) x));
}
static void *_p_FXMatrixTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXMatrix *) x));
}
static void *_p_FXShutterItemTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *)(FXVerticalFrame *) ((FXShutterItem *) x));
}
static void *_p_FXIdTo_p_FXObject(void *x) {
    return (void *)((FXObject *)  ((FXId *) x));
}
static void *_p_FXFrameTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *) ((FXFrame *) x));
}
static void *_p_FXSpringTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXSpring *) x));
}
static void *_p_FXVisualTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *) ((FXVisual *) x));
}
static void *_p_FXAppTo_p_FXObject(void *x) {
    return (void *)((FXObject *)  ((FXApp *) x));
}
static void *_p_FXScrollWindowTo_p_FXScrollArea(void *x) {
    return (void *)((FXScrollArea *)  ((FXScrollWindow *) x));
}
static void *_p_FXIconListTo_p_FXScrollArea(void *x) {
    return (void *)((FXScrollArea *)  ((FXIconList *) x));
}
static void *_p_FXFileListTo_p_FXScrollArea(void *x) {
    return (void *)((FXScrollArea *) (FXIconList *) ((FXFileList *) x));
}
static void *_p_FXFrameTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *)  ((FXFrame *) x));
}
static void *_p_FXPopupTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXShell *) ((FXPopup *) x));
}
static void *_p_FXShutterItemTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXPacker *)(FXVerticalFrame *) ((FXShutterItem *) x));
}
static void *_p_FXScrollAreaTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *) ((FXScrollArea *) x));
}
static void *_p_FXStatusBarTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXPacker *)(FXHorizontalFrame *) ((FXStatusBar *) x));
}
static void *_p_FXMainWindowTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXShell *)(FXTopWindow *) ((FXMainWindow *) x));
}
static void *_p_FXTopWindowTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXShell *) ((FXTopWindow *) x));
}
static void *_p_FXRootWindowTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *) ((FXRootWindow *) x));
}
static void *_p_FXCompositeTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *)  ((FXComposite *) x));
}
static void *_p_FXScrollWindowTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXScrollArea *) ((FXScrollWindow *) x));
}
static void *_p_FXShellTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *) ((FXShell *) x));
}
static void *_p_FXGroupBoxTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXPacker *) ((FXGroupBox *) x));
}
static void *_p_FXSplitterTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *) ((FXSplitter *) x));
}
static void *_p_FX4SplitterTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *) ((FX4Splitter *) x));
}
static void *_p_FXIconListTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXScrollArea *) ((FXIconList *) x));
}
static void *_p_FXPackerTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *) ((FXPacker *) x));
}
static void *_p_FXVerticalFrameTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXPacker *) ((FXVerticalFrame *) x));
}
static void *_p_FXHorizontalFrameTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXPacker *) ((FXHorizontalFrame *) x));
}
static void *_p_FXShutterTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXPacker *)(FXVerticalFrame *) ((FXShutter *) x));
}
static void *_p_FXFileListTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXScrollArea *)(FXIconList *) ((FXFileList *) x));
}
static void *_p_FXMatrixTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXPacker *) ((FXMatrix *) x));
}
static void *_p_FXSpringTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXPacker *) ((FXSpring *) x));
}
static void *_p_FXSwitcherTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXPacker *) ((FXSwitcher *) x));
}
static void *_p_FXPopupTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXShell *) ((FXPopup *) x));
}
static void *_p_FXShutterItemTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXPacker *)(FXVerticalFrame *) ((FXShutterItem *) x));
}
static void *_p_FXScrollAreaTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *)  ((FXScrollArea *) x));
}
static void *_p_FXStatusBarTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXPacker *)(FXHorizontalFrame *) ((FXStatusBar *) x));
}
static void *_p_FXMainWindowTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXShell *)(FXTopWindow *) ((FXMainWindow *) x));
}
static void *_p_FXTopWindowTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXShell *) ((FXTopWindow *) x));
}
static void *_p_FXRootWindowTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *)  ((FXRootWindow *) x));
}
static void *_p_FXScrollWindowTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXScrollArea *) ((FXScrollWindow *) x));
}
static void *_p_FXShellTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *)  ((FXShell *) x));
}
static void *_p_FXGroupBoxTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXPacker *) ((FXGroupBox *) x));
}
static void *_p_FXSplitterTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *)  ((FXSplitter *) x));
}
static void *_p_FX4SplitterTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *)  ((FX4Splitter *) x));
}
static void *_p_FXIconListTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXScrollArea *) ((FXIconList *) x));
}
static void *_p_FXShutterTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXPacker *)(FXVerticalFrame *) ((FXShutter *) x));
}
static void *_p_FXPackerTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *)  ((FXPacker *) x));
}
static void *_p_FXVerticalFrameTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXPacker *) ((FXVerticalFrame *) x));
}
static void *_p_FXHorizontalFrameTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXPacker *) ((FXHorizontalFrame *) x));
}
static void *_p_FXFileListTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXScrollArea *)(FXIconList *) ((FXFileList *) x));
}
static void *_p_FXMatrixTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXPacker *) ((FXMatrix *) x));
}
static void *_p_FXSpringTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXPacker *) ((FXSpring *) x));
}
static void *_p_FXSwitcherTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXPacker *) ((FXSwitcher *) x));
}
static void *_p_FXFileStreamTo_p_FXStream(void *x) {
    return (void *)((FXStream *)  ((FXFileStream *) x));
}
static void *_p_FXMemoryStreamTo_p_FXStream(void *x) {
    return (void *)((FXStream *)  ((FXMemoryStream *) x));
}
static void *_p_FXFrameTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *) ((FXFrame *) x));
}
static void *_p_FXPopupTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXShell *) ((FXPopup *) x));
}
static void *_p_FXShutterItemTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *)(FXVerticalFrame *) ((FXShutterItem *) x));
}
static void *_p_FXScrollAreaTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *) ((FXScrollArea *) x));
}
static void *_p_FXStatusBarTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *)(FXHorizontalFrame *) ((FXStatusBar *) x));
}
static void *_p_FXMainWindowTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXShell *)(FXTopWindow *) ((FXMainWindow *) x));
}
static void *_p_FXTopWindowTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXShell *) ((FXTopWindow *) x));
}
static void *_p_FXRootWindowTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *) ((FXRootWindow *) x));
}
static void *_p_FXWindowTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *)  ((FXWindow *) x));
}
static void *_p_FXCompositeTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *) ((FXComposite *) x));
}
static void *_p_FXScrollWindowTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXScrollArea *) ((FXScrollWindow *) x));
}
static void *_p_FXShellTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *) ((FXShell *) x));
}
static void *_p_FXGroupBoxTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *) ((FXGroupBox *) x));
}
static void *_p_FXSplitterTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *) ((FXSplitter *) x));
}
static void *_p_FX4SplitterTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *) ((FX4Splitter *) x));
}
static void *_p_FXIconListTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXScrollArea *) ((FXIconList *) x));
}
static void *_p_FXPackerTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *) ((FXPacker *) x));
}
static void *_p_FXVerticalFrameTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *) ((FXVerticalFrame *) x));
}
static void *_p_FXHorizontalFrameTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *) ((FXHorizontalFrame *) x));
}
static void *_p_FXShutterTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *)(FXVerticalFrame *) ((FXShutter *) x));
}
static void *_p_FXFileListTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXScrollArea *)(FXIconList *) ((FXFileList *) x));
}
static void *_p_FXMatrixTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *) ((FXMatrix *) x));
}
static void *_p_FXSpringTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *) ((FXSpring *) x));
}
static void *_p_FXSwitcherTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *) ((FXSwitcher *) x));
}
static void *_p_FXFileListTo_p_FXIconList(void *x) {
    return (void *)((FXIconList *)  ((FXFileList *) x));
}
static void *_p_FXFileItemTo_p_FXIconItem(void *x) {
    return (void *)((FXIconItem *)  ((FXFileItem *) x));
}
static swig_type_info _swigt__p_FXDC[] = {{"_p_FXDC", 0, "FXDC *", 0, 0, 0, 0},{"_p_FXDC", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXObject[] = {{"_p_FXObject", 0, "FXObject *", 0, 0, 0, 0},{"_p_FXIconList", _p_FXIconListTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXDict", _p_FXDictTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXSettings", _p_FXSettingsTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXAccelTable", _p_FXAccelTableTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXComposite", _p_FXCompositeTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXRegistry", _p_FXRegistryTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXId", _p_FXIdTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXIconDict", _p_FXIconDictTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXGroupBox", _p_FXGroupBoxTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXShell", _p_FXShellTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXStatusBar", _p_FXStatusBarTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXScrollArea", _p_FXScrollAreaTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXPopup", _p_FXPopupTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXWindow", _p_FXWindowTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXMainWindow", _p_FXMainWindowTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXScrollWindow", _p_FXScrollWindowTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXRootWindow", _p_FXRootWindowTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXTopWindow", _p_FXTopWindowTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXRecentFiles", _p_FXRecentFilesTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXDocument", _p_FXDocumentTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXIconItem", _p_FXIconItemTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXHorizontalFrame", _p_FXHorizontalFrameTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXVerticalFrame", _p_FXVerticalFrameTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXFileList", _p_FXFileListTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXSplitter", _p_FXSplitterTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FX4Splitter", _p_FX4SplitterTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXObject", 0, 0, 0, 0, 0, 0},{"_p_FXStringDict", _p_FXStringDictTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXPacker", _p_FXPackerTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXFileDict", _p_FXFileDictTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXSwitcher", _p_FXSwitcherTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXDebugTarget", _p_FXDebugTargetTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXDataTarget", _p_FXDataTargetTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXShutter", _p_FXShutterTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXCURCursor", _p_FXCURCursorTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXGIFCursor", _p_FXGIFCursorTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXCursor", _p_FXCursorTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXDrawable", _p_FXDrawableTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXFileItem", _p_FXFileItemTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXDelegator", _p_FXDelegatorTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXApp", _p_FXAppTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXMatrix", _p_FXMatrixTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXShutterItem", _p_FXShutterItemTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXFont", _p_FXFontTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXFrame", _p_FXFrameTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXSpring", _p_FXSpringTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXVisual", _p_FXVisualTo_p_FXObject, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXScrollArea[] = {{"_p_FXScrollArea", 0, "FXScrollArea *", 0, 0, 0, 0},{"_p_FXScrollWindow", _p_FXScrollWindowTo_p_FXScrollArea, 0, 0, 0, 0, 0},{"_p_FXIconList", _p_FXIconListTo_p_FXScrollArea, 0, 0, 0, 0, 0},{"_p_FXFileList", _p_FXFileListTo_p_FXScrollArea, 0, 0, 0, 0, 0},{"_p_FXScrollArea", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXWindow[] = {{"_p_FXWindow", 0, "FXWindow *", 0, 0, 0, 0},{"_p_FXFrame", _p_FXFrameTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXPopup", _p_FXPopupTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXShutterItem", _p_FXShutterItemTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXScrollArea", _p_FXScrollAreaTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXStatusBar", _p_FXStatusBarTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXMainWindow", _p_FXMainWindowTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXTopWindow", _p_FXTopWindowTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXRootWindow", _p_FXRootWindowTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXScrollWindow", _p_FXScrollWindowTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXWindow", 0, 0, 0, 0, 0, 0},{"_p_FXComposite", _p_FXCompositeTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXShell", _p_FXShellTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXGroupBox", _p_FXGroupBoxTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXIconList", _p_FXIconListTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FX4Splitter", _p_FX4SplitterTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXSplitter", _p_FXSplitterTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXShutter", _p_FXShutterTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXPacker", _p_FXPackerTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXVerticalFrame", _p_FXVerticalFrameTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXHorizontalFrame", _p_FXHorizontalFrameTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXFileList", _p_FXFileListTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXMatrix", _p_FXMatrixTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXSpring", _p_FXSpringTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXSwitcher", _p_FXSwitcherTo_p_FXWindow, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXComposite[] = {{"_p_FXComposite", 0, "FXComposite *", 0, 0, 0, 0},{"_p_FXPopup", _p_FXPopupTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXShutterItem", _p_FXShutterItemTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXScrollArea", _p_FXScrollAreaTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXStatusBar", _p_FXStatusBarTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXMainWindow", _p_FXMainWindowTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXTopWindow", _p_FXTopWindowTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXRootWindow", _p_FXRootWindowTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXScrollWindow", _p_FXScrollWindowTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXComposite", 0, 0, 0, 0, 0, 0},{"_p_FXShell", _p_FXShellTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXGroupBox", _p_FXGroupBoxTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FX4Splitter", _p_FX4SplitterTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXIconList", _p_FXIconListTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXSplitter", _p_FXSplitterTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXShutter", _p_FXShutterTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXPacker", _p_FXPackerTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXVerticalFrame", _p_FXVerticalFrameTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXHorizontalFrame", _p_FXHorizontalFrameTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXFileList", _p_FXFileListTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXMatrix", _p_FXMatrixTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXSpring", _p_FXSpringTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXSwitcher", _p_FXSwitcherTo_p_FXComposite, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXFont[] = {{"_p_FXFont", 0, "FXFont *", 0, 0, 0, 0},{"_p_FXFont", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXId[] = {{"_p_FXId", 0, "FXId *", 0, 0, 0, 0},{"_p_FXFrame", _p_FXFrameTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXPopup", _p_FXPopupTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXShutterItem", _p_FXShutterItemTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXScrollArea", _p_FXScrollAreaTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXStatusBar", _p_FXStatusBarTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXMainWindow", _p_FXMainWindowTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXTopWindow", _p_FXTopWindowTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXRootWindow", _p_FXRootWindowTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXWindow", _p_FXWindowTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXScrollWindow", _p_FXScrollWindowTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXComposite", _p_FXCompositeTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXId", 0, 0, 0, 0, 0, 0},{"_p_FXFont", _p_FXFontTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXShell", _p_FXShellTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXGroupBox", _p_FXGroupBoxTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXIconList", _p_FXIconListTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FX4Splitter", _p_FX4SplitterTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXSplitter", _p_FXSplitterTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXGIFCursor", _p_FXGIFCursorTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXCURCursor", _p_FXCURCursorTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXCursor", _p_FXCursorTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXDrawable", _p_FXDrawableTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXShutter", _p_FXShutterTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXPacker", _p_FXPackerTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXVerticalFrame", _p_FXVerticalFrameTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXHorizontalFrame", _p_FXHorizontalFrameTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXFileList", _p_FXFileListTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXMatrix", _p_FXMatrixTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXVisual", _p_FXVisualTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXSpring", _p_FXSpringTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXSwitcher", _p_FXSwitcherTo_p_FXId, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXFileDict[] = {{"_p_FXFileDict", 0, "FXFileDict *", 0, 0, 0, 0},{"_p_FXFileDict", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXStream[] = {{"_p_FXStream", 0, "FXStream *", 0, 0, 0, 0},{"_p_FXFileStream", _p_FXFileStreamTo_p_FXStream, 0, 0, 0, 0, 0},{"_p_FXMemoryStream", _p_FXMemoryStreamTo_p_FXStream, 0, 0, 0, 0, 0},{"_p_FXStream", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXDrawable[] = {{"_p_FXDrawable", 0, "FXDrawable *", 0, 0, 0, 0},{"_p_FXFrame", _p_FXFrameTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXPopup", _p_FXPopupTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXShutterItem", _p_FXShutterItemTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXScrollArea", _p_FXScrollAreaTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXStatusBar", _p_FXStatusBarTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXMainWindow", _p_FXMainWindowTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXTopWindow", _p_FXTopWindowTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXRootWindow", _p_FXRootWindowTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXWindow", _p_FXWindowTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXScrollWindow", _p_FXScrollWindowTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXComposite", _p_FXCompositeTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXShell", _p_FXShellTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXGroupBox", _p_FXGroupBoxTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXDrawable", 0, 0, 0, 0, 0, 0},{"_p_FXIconList", _p_FXIconListTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FX4Splitter", _p_FX4SplitterTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXSplitter", _p_FXSplitterTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXShutter", _p_FXShutterTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXPacker", _p_FXPackerTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXVerticalFrame", _p_FXVerticalFrameTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXHorizontalFrame", _p_FXHorizontalFrameTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXFileList", _p_FXFileListTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXMatrix", _p_FXMatrixTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXSpring", _p_FXSpringTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXSwitcher", _p_FXSwitcherTo_p_FXDrawable, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXIconList[] = {{"_p_FXIconList", 0, "FXIconList *", 0, 0, 0, 0},{"_p_FXIconList", 0, 0, 0, 0, 0, 0},{"_p_FXFileList", _p_FXFileListTo_p_FXIconList, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXIcon[] = {{"_p_FXIcon", 0, "FXIcon *", 0, 0, 0, 0},{"_p_FXIcon", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXHeader[] = {{"_p_FXHeader", 0, "FXHeader *", 0, 0, 0, 0},{"_p_FXHeader", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXFileList[] = {{"_p_FXFileList", 0, "FXFileList *", 0, 0, 0, 0},{"_p_FXFileList", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXIconItem[] = {{"_p_FXIconItem", 0, "FXIconItem *", 0, 0, 0, 0},{"_p_FXIconItem", 0, 0, 0, 0, 0, 0},{"_p_FXFileItem", _p_FXFileItemTo_p_FXIconItem, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXFileItem[] = {{"_p_FXFileItem", 0, "FXFileItem *", 0, 0, 0, 0},{"_p_FXFileItem", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};

static swig_type_info *swig_types_initial[] = {
_swigt__p_FXDC, 
_swigt__p_FXObject, 
_swigt__p_FXScrollArea, 
_swigt__p_FXWindow, 
_swigt__p_FXComposite, 
_swigt__p_FXFont, 
_swigt__p_FXId, 
_swigt__p_FXFileDict, 
_swigt__p_FXStream, 
_swigt__p_FXDrawable, 
_swigt__p_FXIconList, 
_swigt__p_FXIcon, 
_swigt__p_FXHeader, 
_swigt__p_FXFileList, 
_swigt__p_FXIconItem, 
_swigt__p_FXFileItem, 
0
};


/* -------- TYPE CONVERSION AND EQUIVALENCE RULES (END) -------- */


#ifdef __cplusplus
extern "C"
#endif
SWIGEXPORT(void) Init_iconlist(void) {
    int i;
    
    SWIG_InitRuntime();
    
    for (i = 0; swig_types_initial[i]; i++) {
        swig_types[i] = SWIG_TypeRegister(swig_types_initial[i]);
        SWIG_define_class(swig_types[i]);
    }
    
    rb_define_const(mFox,"ICONLIST_EXTENDEDSELECT", INT2NUM(ICONLIST_EXTENDEDSELECT));
    rb_define_const(mFox,"ICONLIST_SINGLESELECT", INT2NUM(ICONLIST_SINGLESELECT));
    rb_define_const(mFox,"ICONLIST_BROWSESELECT", INT2NUM(ICONLIST_BROWSESELECT));
    rb_define_const(mFox,"ICONLIST_MULTIPLESELECT", INT2NUM(ICONLIST_MULTIPLESELECT));
    rb_define_const(mFox,"ICONLIST_AUTOSIZE", INT2NUM(ICONLIST_AUTOSIZE));
    rb_define_const(mFox,"ICONLIST_DETAILED", INT2NUM(ICONLIST_DETAILED));
    rb_define_const(mFox,"ICONLIST_MINI_ICONS", INT2NUM(ICONLIST_MINI_ICONS));
    rb_define_const(mFox,"ICONLIST_BIG_ICONS", INT2NUM(ICONLIST_BIG_ICONS));
    rb_define_const(mFox,"ICONLIST_ROWS", INT2NUM(ICONLIST_ROWS));
    rb_define_const(mFox,"ICONLIST_COLUMNS", INT2NUM(ICONLIST_COLUMNS));
    rb_define_const(mFox,"ICONLIST_NORMAL", INT2NUM(ICONLIST_NORMAL));
    
    cFXIconItem.klass = rb_define_class_under(mFox, "FXIconItem", ((swig_class *) SWIGTYPE_p_FXObject->clientdata)->klass);
    SWIG_TypeClientData(SWIGTYPE_p_FXIconItem, (void *) &cFXIconItem);
    rb_define_alloc_func(cFXIconItem.klass, _wrap_FXIconItem_allocate);
    rb_define_method(cFXIconItem.klass, "initialize", VALUEFUNC(_wrap_new_FXIconItem), -1);
    rb_define_method(cFXIconItem.klass, "getText", VALUEFUNC(_wrap_FXIconItem_getText), -1);
    rb_define_method(cFXIconItem.klass, "getBigIcon", VALUEFUNC(_wrap_FXIconItem_getBigIcon), -1);
    rb_define_method(cFXIconItem.klass, "getMiniIcon", VALUEFUNC(_wrap_FXIconItem_getMiniIcon), -1);
    rb_define_method(cFXIconItem.klass, "setData", VALUEFUNC(_wrap_FXIconItem_setData), -1);
    rb_define_method(cFXIconItem.klass, "getData", VALUEFUNC(_wrap_FXIconItem_getData), -1);
    rb_define_method(cFXIconItem.klass, "hasFocus", VALUEFUNC(_wrap_FXIconItem_hasFocus), -1);
    rb_define_method(cFXIconItem.klass, "isSelected", VALUEFUNC(_wrap_FXIconItem_isSelected), -1);
    rb_define_method(cFXIconItem.klass, "isEnabled", VALUEFUNC(_wrap_FXIconItem_isEnabled), -1);
    rb_define_method(cFXIconItem.klass, "isDraggable", VALUEFUNC(_wrap_FXIconItem_isDraggable), -1);
    rb_define_method(cFXIconItem.klass, "isIconOwned", VALUEFUNC(_wrap_FXIconItem_isIconOwned), -1);
    rb_define_method(cFXIconItem.klass, "save", VALUEFUNC(_wrap_FXIconItem_save), -1);
    rb_define_method(cFXIconItem.klass, "load", VALUEFUNC(_wrap_FXIconItem_load), -1);
    rb_define_method(cFXIconItem.klass, "draw", VALUEFUNC(_wrap_FXIconItem_draw), -1);
    rb_define_method(cFXIconItem.klass, "hitItem", VALUEFUNC(_wrap_FXIconItem_hitItem), -1);
    rb_define_method(cFXIconItem.klass, "drawBigIcon", VALUEFUNC(_wrap_FXIconItem_drawBigIcon), -1);
    rb_define_method(cFXIconItem.klass, "drawMiniIcon", VALUEFUNC(_wrap_FXIconItem_drawMiniIcon), -1);
    rb_define_method(cFXIconItem.klass, "drawDetails", VALUEFUNC(_wrap_FXIconItem_drawDetails), -1);
    rb_define_method(cFXIconItem.klass, "setText", VALUEFUNC(_wrap_FXIconItem_setText), -1);
    rb_define_method(cFXIconItem.klass, "setBigIcon", VALUEFUNC(_wrap_FXIconItem_setBigIcon), -1);
    rb_define_method(cFXIconItem.klass, "setMiniIcon", VALUEFUNC(_wrap_FXIconItem_setMiniIcon), -1);
    rb_define_method(cFXIconItem.klass, "setFocus", VALUEFUNC(_wrap_FXIconItem_setFocus), -1);
    rb_define_method(cFXIconItem.klass, "setSelected", VALUEFUNC(_wrap_FXIconItem_setSelected), -1);
    rb_define_method(cFXIconItem.klass, "setEnabled", VALUEFUNC(_wrap_FXIconItem_setEnabled), -1);
    rb_define_method(cFXIconItem.klass, "setDraggable", VALUEFUNC(_wrap_FXIconItem_setDraggable), -1);
    rb_define_method(cFXIconItem.klass, "setIconOwned", VALUEFUNC(_wrap_FXIconItem_setIconOwned), -1);
    rb_define_method(cFXIconItem.klass, "getWidth", VALUEFUNC(_wrap_FXIconItem_getWidth), -1);
    rb_define_method(cFXIconItem.klass, "getHeight", VALUEFUNC(_wrap_FXIconItem_getHeight), -1);
    rb_define_method(cFXIconItem.klass, "create", VALUEFUNC(_wrap_FXIconItem_create), -1);
    rb_define_method(cFXIconItem.klass, "detach", VALUEFUNC(_wrap_FXIconItem_detach), -1);
    rb_define_method(cFXIconItem.klass, "destroy", VALUEFUNC(_wrap_FXIconItem_destroy), -1);
    cFXIconItem.mark = (void (*)(void *)) FXRbIconItem::markfunc;
    cFXIconItem.destroy = (void (*)(void *)) FXRbIconItem::freefunc;
    
    SWIGTYPE_p_FXIconItem->dcast = (swig_dycast_func) FXIconItem_dynamic_cast;
    
    
    cFXIconList.klass = rb_define_class_under(mFox, "FXIconList", ((swig_class *) SWIGTYPE_p_FXScrollArea->clientdata)->klass);
    SWIG_TypeClientData(SWIGTYPE_p_FXIconList, (void *) &cFXIconList);
    rb_define_alloc_func(cFXIconList.klass, _wrap_FXIconList_allocate);
    rb_define_method(cFXIconList.klass, "initialize", VALUEFUNC(_wrap_new_FXIconList), -1);
    rb_define_method(cFXIconList.klass, "onPaint", VALUEFUNC(_wrap_FXIconList_onPaint), -1);
    rb_define_method(cFXIconList.klass, "onEnter", VALUEFUNC(_wrap_FXIconList_onEnter), -1);
    rb_define_method(cFXIconList.klass, "onLeave", VALUEFUNC(_wrap_FXIconList_onLeave), -1);
    rb_define_method(cFXIconList.klass, "onUngrabbed", VALUEFUNC(_wrap_FXIconList_onUngrabbed), -1);
    rb_define_method(cFXIconList.klass, "onKeyPress", VALUEFUNC(_wrap_FXIconList_onKeyPress), -1);
    rb_define_method(cFXIconList.klass, "onKeyRelease", VALUEFUNC(_wrap_FXIconList_onKeyRelease), -1);
    rb_define_method(cFXIconList.klass, "onLeftBtnPress", VALUEFUNC(_wrap_FXIconList_onLeftBtnPress), -1);
    rb_define_method(cFXIconList.klass, "onLeftBtnRelease", VALUEFUNC(_wrap_FXIconList_onLeftBtnRelease), -1);
    rb_define_method(cFXIconList.klass, "onRightBtnPress", VALUEFUNC(_wrap_FXIconList_onRightBtnPress), -1);
    rb_define_method(cFXIconList.klass, "onRightBtnRelease", VALUEFUNC(_wrap_FXIconList_onRightBtnRelease), -1);
    rb_define_method(cFXIconList.klass, "onMotion", VALUEFUNC(_wrap_FXIconList_onMotion), -1);
    rb_define_method(cFXIconList.klass, "onQueryTip", VALUEFUNC(_wrap_FXIconList_onQueryTip), -1);
    rb_define_method(cFXIconList.klass, "onQueryHelp", VALUEFUNC(_wrap_FXIconList_onQueryHelp), -1);
    rb_define_method(cFXIconList.klass, "onTipTimer", VALUEFUNC(_wrap_FXIconList_onTipTimer), -1);
    rb_define_method(cFXIconList.klass, "onCmdSelectAll", VALUEFUNC(_wrap_FXIconList_onCmdSelectAll), -1);
    rb_define_method(cFXIconList.klass, "onCmdDeselectAll", VALUEFUNC(_wrap_FXIconList_onCmdDeselectAll), -1);
    rb_define_method(cFXIconList.klass, "onCmdSelectInverse", VALUEFUNC(_wrap_FXIconList_onCmdSelectInverse), -1);
    rb_define_method(cFXIconList.klass, "onCmdArrangeByRows", VALUEFUNC(_wrap_FXIconList_onCmdArrangeByRows), -1);
    rb_define_method(cFXIconList.klass, "onUpdArrangeByRows", VALUEFUNC(_wrap_FXIconList_onUpdArrangeByRows), -1);
    rb_define_method(cFXIconList.klass, "onCmdArrangeByColumns", VALUEFUNC(_wrap_FXIconList_onCmdArrangeByColumns), -1);
    rb_define_method(cFXIconList.klass, "onUpdArrangeByColumns", VALUEFUNC(_wrap_FXIconList_onUpdArrangeByColumns), -1);
    rb_define_method(cFXIconList.klass, "onCmdShowDetails", VALUEFUNC(_wrap_FXIconList_onCmdShowDetails), -1);
    rb_define_method(cFXIconList.klass, "onUpdShowDetails", VALUEFUNC(_wrap_FXIconList_onUpdShowDetails), -1);
    rb_define_method(cFXIconList.klass, "onCmdShowBigIcons", VALUEFUNC(_wrap_FXIconList_onCmdShowBigIcons), -1);
    rb_define_method(cFXIconList.klass, "onUpdShowBigIcons", VALUEFUNC(_wrap_FXIconList_onUpdShowBigIcons), -1);
    rb_define_method(cFXIconList.klass, "onCmdShowMiniIcons", VALUEFUNC(_wrap_FXIconList_onCmdShowMiniIcons), -1);
    rb_define_method(cFXIconList.klass, "onUpdShowMiniIcons", VALUEFUNC(_wrap_FXIconList_onUpdShowMiniIcons), -1);
    rb_define_method(cFXIconList.klass, "onHeaderChanged", VALUEFUNC(_wrap_FXIconList_onHeaderChanged), -1);
    rb_define_method(cFXIconList.klass, "onHeaderResize", VALUEFUNC(_wrap_FXIconList_onHeaderResize), -1);
    rb_define_method(cFXIconList.klass, "onFocusIn", VALUEFUNC(_wrap_FXIconList_onFocusIn), -1);
    rb_define_method(cFXIconList.klass, "onFocusOut", VALUEFUNC(_wrap_FXIconList_onFocusOut), -1);
    rb_define_method(cFXIconList.klass, "onClicked", VALUEFUNC(_wrap_FXIconList_onClicked), -1);
    rb_define_method(cFXIconList.klass, "onDoubleClicked", VALUEFUNC(_wrap_FXIconList_onDoubleClicked), -1);
    rb_define_method(cFXIconList.klass, "onTripleClicked", VALUEFUNC(_wrap_FXIconList_onTripleClicked), -1);
    rb_define_method(cFXIconList.klass, "onCommand", VALUEFUNC(_wrap_FXIconList_onCommand), -1);
    rb_define_method(cFXIconList.klass, "onAutoScroll", VALUEFUNC(_wrap_FXIconList_onAutoScroll), -1);
    rb_define_method(cFXIconList.klass, "onLookupTimer", VALUEFUNC(_wrap_FXIconList_onLookupTimer), -1);
    rb_define_method(cFXIconList.klass, "onCmdSetValue", VALUEFUNC(_wrap_FXIconList_onCmdSetValue), -1);
    rb_define_method(cFXIconList.klass, "onCmdGetIntValue", VALUEFUNC(_wrap_FXIconList_onCmdGetIntValue), -1);
    rb_define_method(cFXIconList.klass, "onCmdSetIntValue", VALUEFUNC(_wrap_FXIconList_onCmdSetIntValue), -1);
    rb_define_singleton_method(cFXIconList.klass, "ascending", VALUEFUNC(_wrap_FXIconList_ascending), -1);
    rb_define_singleton_method(cFXIconList.klass, "descending", VALUEFUNC(_wrap_FXIconList_descending), -1);
    rb_define_singleton_method(cFXIconList.klass, "ascendingCase", VALUEFUNC(_wrap_FXIconList_ascendingCase), -1);
    rb_define_singleton_method(cFXIconList.klass, "descendingCase", VALUEFUNC(_wrap_FXIconList_descendingCase), -1);
    rb_define_const(cFXIconList.klass,"ID_SHOW_DETAILS", INT2NUM(FXIconList::ID_SHOW_DETAILS));
    rb_define_const(cFXIconList.klass,"ID_SHOW_MINI_ICONS", INT2NUM(FXIconList::ID_SHOW_MINI_ICONS));
    rb_define_const(cFXIconList.klass,"ID_SHOW_BIG_ICONS", INT2NUM(FXIconList::ID_SHOW_BIG_ICONS));
    rb_define_const(cFXIconList.klass,"ID_ARRANGE_BY_ROWS", INT2NUM(FXIconList::ID_ARRANGE_BY_ROWS));
    rb_define_const(cFXIconList.klass,"ID_ARRANGE_BY_COLUMNS", INT2NUM(FXIconList::ID_ARRANGE_BY_COLUMNS));
    rb_define_const(cFXIconList.klass,"ID_HEADER_CHANGE", INT2NUM(FXIconList::ID_HEADER_CHANGE));
    rb_define_const(cFXIconList.klass,"ID_LOOKUPTIMER", INT2NUM(FXIconList::ID_LOOKUPTIMER));
    rb_define_const(cFXIconList.klass,"ID_SELECT_ALL", INT2NUM(FXIconList::ID_SELECT_ALL));
    rb_define_const(cFXIconList.klass,"ID_DESELECT_ALL", INT2NUM(FXIconList::ID_DESELECT_ALL));
    rb_define_const(cFXIconList.klass,"ID_SELECT_INVERSE", INT2NUM(FXIconList::ID_SELECT_INVERSE));
    rb_define_const(cFXIconList.klass,"ID_LAST", INT2NUM(FXIconList::ID_LAST));
    rb_define_method(cFXIconList.klass, "getNumItems", VALUEFUNC(_wrap_FXIconList_getNumItems), -1);
    rb_define_method(cFXIconList.klass, "getNumRows", VALUEFUNC(_wrap_FXIconList_getNumRows), -1);
    rb_define_method(cFXIconList.klass, "getNumCols", VALUEFUNC(_wrap_FXIconList_getNumCols), -1);
    rb_define_method(cFXIconList.klass, "getHeader", VALUEFUNC(_wrap_FXIconList_getHeader), -1);
    rb_define_method(cFXIconList.klass, "appendHeader", VALUEFUNC(_wrap_FXIconList_appendHeader), -1);
    rb_define_method(cFXIconList.klass, "removeHeader", VALUEFUNC(_wrap_FXIconList_removeHeader), -1);
    rb_define_method(cFXIconList.klass, "setHeaderText", VALUEFUNC(_wrap_FXIconList_setHeaderText), -1);
    rb_define_method(cFXIconList.klass, "getHeaderText", VALUEFUNC(_wrap_FXIconList_getHeaderText), -1);
    rb_define_method(cFXIconList.klass, "setHeaderIcon", VALUEFUNC(_wrap_FXIconList_setHeaderIcon), -1);
    rb_define_method(cFXIconList.klass, "getHeaderIcon", VALUEFUNC(_wrap_FXIconList_getHeaderIcon), -1);
    rb_define_method(cFXIconList.klass, "setHeaderSize", VALUEFUNC(_wrap_FXIconList_setHeaderSize), -1);
    rb_define_method(cFXIconList.klass, "getHeaderSize", VALUEFUNC(_wrap_FXIconList_getHeaderSize), -1);
    rb_define_method(cFXIconList.klass, "getNumHeaders", VALUEFUNC(_wrap_FXIconList_getNumHeaders), -1);
    rb_define_method(cFXIconList.klass, "getItem", VALUEFUNC(_wrap_FXIconList_getItem), -1);
    rb_define_method(cFXIconList.klass, "setItem", VALUEFUNC(_wrap_FXIconList_setItem), -1);
    rb_define_method(cFXIconList.klass, "insertItem", VALUEFUNC(_wrap_FXIconList_insertItem), -1);
    rb_define_method(cFXIconList.klass, "appendItem", VALUEFUNC(_wrap_FXIconList_appendItem), -1);
    rb_define_alias(cFXIconList.klass, "<<", "appendItem");
    rb_define_method(cFXIconList.klass, "prependItem", VALUEFUNC(_wrap_FXIconList_prependItem), -1);
    rb_define_method(cFXIconList.klass, "moveItem", VALUEFUNC(_wrap_FXIconList_moveItem), -1);
    rb_define_method(cFXIconList.klass, "removeItem", VALUEFUNC(_wrap_FXIconList_removeItem), -1);
    rb_define_method(cFXIconList.klass, "clearItems", VALUEFUNC(_wrap_FXIconList_clearItems), -1);
    rb_define_method(cFXIconList.klass, "getItemWidth", VALUEFUNC(_wrap_FXIconList_getItemWidth), -1);
    rb_define_method(cFXIconList.klass, "getItemHeight", VALUEFUNC(_wrap_FXIconList_getItemHeight), -1);
    rb_define_method(cFXIconList.klass, "getItemAt", VALUEFUNC(_wrap_FXIconList_getItemAt), -1);
    rb_define_method(cFXIconList.klass, "findItem", VALUEFUNC(_wrap_FXIconList_findItem), -1);
    rb_define_method(cFXIconList.klass, "makeItemVisible", VALUEFUNC(_wrap_FXIconList_makeItemVisible), -1);
    rb_define_method(cFXIconList.klass, "setItemText", VALUEFUNC(_wrap_FXIconList_setItemText), -1);
    rb_define_method(cFXIconList.klass, "getItemText", VALUEFUNC(_wrap_FXIconList_getItemText), -1);
    rb_define_method(cFXIconList.klass, "setItemBigIcon", VALUEFUNC(_wrap_FXIconList_setItemBigIcon), -1);
    rb_define_method(cFXIconList.klass, "getItemBigIcon", VALUEFUNC(_wrap_FXIconList_getItemBigIcon), -1);
    rb_define_method(cFXIconList.klass, "setItemMiniIcon", VALUEFUNC(_wrap_FXIconList_setItemMiniIcon), -1);
    rb_define_method(cFXIconList.klass, "getItemMiniIcon", VALUEFUNC(_wrap_FXIconList_getItemMiniIcon), -1);
    rb_define_method(cFXIconList.klass, "setItemData", VALUEFUNC(_wrap_FXIconList_setItemData), -1);
    rb_define_method(cFXIconList.klass, "getItemData", VALUEFUNC(_wrap_FXIconList_getItemData), -1);
    rb_define_method(cFXIconList.klass, "isItemSelected", VALUEFUNC(_wrap_FXIconList_isItemSelected), -1);
    rb_define_method(cFXIconList.klass, "isItemCurrent", VALUEFUNC(_wrap_FXIconList_isItemCurrent), -1);
    rb_define_method(cFXIconList.klass, "isItemVisible", VALUEFUNC(_wrap_FXIconList_isItemVisible), -1);
    rb_define_method(cFXIconList.klass, "isItemEnabled", VALUEFUNC(_wrap_FXIconList_isItemEnabled), -1);
    rb_define_method(cFXIconList.klass, "hitItem", VALUEFUNC(_wrap_FXIconList_hitItem), -1);
    rb_define_method(cFXIconList.klass, "updateItem", VALUEFUNC(_wrap_FXIconList_updateItem), -1);
    rb_define_method(cFXIconList.klass, "enableItem", VALUEFUNC(_wrap_FXIconList_enableItem), -1);
    rb_define_method(cFXIconList.klass, "disableItem", VALUEFUNC(_wrap_FXIconList_disableItem), -1);
    rb_define_method(cFXIconList.klass, "getCurrentItem", VALUEFUNC(_wrap_FXIconList_getCurrentItem), -1);
    rb_define_method(cFXIconList.klass, "setAnchorItem", VALUEFUNC(_wrap_FXIconList_setAnchorItem), -1);
    rb_define_method(cFXIconList.klass, "getAnchorItem", VALUEFUNC(_wrap_FXIconList_getAnchorItem), -1);
    rb_define_method(cFXIconList.klass, "getCursorItem", VALUEFUNC(_wrap_FXIconList_getCursorItem), -1);
    rb_define_method(cFXIconList.klass, "sortItems", VALUEFUNC(_wrap_FXIconList_sortItems), -1);
    rb_define_method(cFXIconList.klass, "setFont", VALUEFUNC(_wrap_FXIconList_setFont), -1);
    rb_define_method(cFXIconList.klass, "getFont", VALUEFUNC(_wrap_FXIconList_getFont), -1);
    rb_define_method(cFXIconList.klass, "getTextColor", VALUEFUNC(_wrap_FXIconList_getTextColor), -1);
    rb_define_method(cFXIconList.klass, "setTextColor", VALUEFUNC(_wrap_FXIconList_setTextColor), -1);
    rb_define_method(cFXIconList.klass, "getSelBackColor", VALUEFUNC(_wrap_FXIconList_getSelBackColor), -1);
    rb_define_method(cFXIconList.klass, "setSelBackColor", VALUEFUNC(_wrap_FXIconList_setSelBackColor), -1);
    rb_define_method(cFXIconList.klass, "getSelTextColor", VALUEFUNC(_wrap_FXIconList_getSelTextColor), -1);
    rb_define_method(cFXIconList.klass, "setSelTextColor", VALUEFUNC(_wrap_FXIconList_setSelTextColor), -1);
    rb_define_method(cFXIconList.klass, "setItemSpace", VALUEFUNC(_wrap_FXIconList_setItemSpace), -1);
    rb_define_method(cFXIconList.klass, "getItemSpace", VALUEFUNC(_wrap_FXIconList_getItemSpace), -1);
    rb_define_method(cFXIconList.klass, "getListStyle", VALUEFUNC(_wrap_FXIconList_getListStyle), -1);
    rb_define_method(cFXIconList.klass, "setListStyle", VALUEFUNC(_wrap_FXIconList_setListStyle), -1);
    rb_define_method(cFXIconList.klass, "setHelpText", VALUEFUNC(_wrap_FXIconList_setHelpText), -1);
    rb_define_method(cFXIconList.klass, "getHelpText", VALUEFUNC(_wrap_FXIconList_getHelpText), -1);
    rb_define_method(cFXIconList.klass, "save", VALUEFUNC(_wrap_FXIconList_save), -1);
    rb_define_method(cFXIconList.klass, "load", VALUEFUNC(_wrap_FXIconList_load), -1);
    rb_define_method(cFXIconList.klass, "create", VALUEFUNC(_wrap_FXIconList_create), -1);
    rb_define_method(cFXIconList.klass, "detach", VALUEFUNC(_wrap_FXIconList_detach), -1);
    rb_define_method(cFXIconList.klass, "destroy", VALUEFUNC(_wrap_FXIconList_destroy), -1);
    rb_define_method(cFXIconList.klass, "resize", VALUEFUNC(_wrap_FXIconList_resize), -1);
    rb_define_method(cFXIconList.klass, "getDefaultWidth", VALUEFUNC(_wrap_FXIconList_getDefaultWidth), -1);
    rb_define_method(cFXIconList.klass, "getDefaultHeight", VALUEFUNC(_wrap_FXIconList_getDefaultHeight), -1);
    rb_define_method(cFXIconList.klass, "getWidthForHeight", VALUEFUNC(_wrap_FXIconList_getWidthForHeight), -1);
    rb_define_method(cFXIconList.klass, "getHeightForWidth", VALUEFUNC(_wrap_FXIconList_getHeightForWidth), -1);
    rb_define_method(cFXIconList.klass, "canFocus", VALUEFUNC(_wrap_FXIconList_canFocus), -1);
    rb_define_method(cFXIconList.klass, "setFocus", VALUEFUNC(_wrap_FXIconList_setFocus), -1);
    rb_define_method(cFXIconList.klass, "killFocus", VALUEFUNC(_wrap_FXIconList_killFocus), -1);
    rb_define_method(cFXIconList.klass, "setDefault", VALUEFUNC(_wrap_FXIconList_setDefault), -1);
    rb_define_method(cFXIconList.klass, "enable", VALUEFUNC(_wrap_FXIconList_enable), -1);
    rb_define_method(cFXIconList.klass, "disable", VALUEFUNC(_wrap_FXIconList_disable), -1);
    rb_define_method(cFXIconList.klass, "raiseWindow", VALUEFUNC(_wrap_FXIconList_raiseWindow), -1);
    rb_define_method(cFXIconList.klass, "lower", VALUEFUNC(_wrap_FXIconList_lower), -1);
    rb_define_method(cFXIconList.klass, "move", VALUEFUNC(_wrap_FXIconList_move), -1);
    rb_define_method(cFXIconList.klass, "layout", VALUEFUNC(_wrap_FXIconList_layout), -1);
    rb_define_method(cFXIconList.klass, "recalc", VALUEFUNC(_wrap_FXIconList_recalc), -1);
    rb_define_method(cFXIconList.klass, "reparent", VALUEFUNC(_wrap_FXIconList_reparent), -1);
    rb_define_method(cFXIconList.klass, "show", VALUEFUNC(_wrap_FXIconList_show), -1);
    rb_define_method(cFXIconList.klass, "hide", VALUEFUNC(_wrap_FXIconList_hide), -1);
    rb_define_method(cFXIconList.klass, "isComposite", VALUEFUNC(_wrap_FXIconList_isComposite), -1);
    rb_define_method(cFXIconList.klass, "contains", VALUEFUNC(_wrap_FXIconList_contains), -1);
    rb_define_method(cFXIconList.klass, "doesSaveUnder", VALUEFUNC(_wrap_FXIconList_doesSaveUnder), -1);
    rb_define_method(cFXIconList.klass, "setBackColor", VALUEFUNC(_wrap_FXIconList_setBackColor), -1);
    rb_define_method(cFXIconList.klass, "getViewportHeight", VALUEFUNC(_wrap_FXIconList_getViewportHeight), -1);
    rb_define_method(cFXIconList.klass, "getViewportWidth", VALUEFUNC(_wrap_FXIconList_getViewportWidth), -1);
    rb_define_method(cFXIconList.klass, "getContentHeight", VALUEFUNC(_wrap_FXIconList_getContentHeight), -1);
    rb_define_method(cFXIconList.klass, "getContentWidth", VALUEFUNC(_wrap_FXIconList_getContentWidth), -1);
    rb_define_method(cFXIconList.klass, "position", VALUEFUNC(_wrap_FXIconList_position), -1);
    rb_define_method(cFXIconList.klass, "selectItem", VALUEFUNC(_wrap_FXIconList_selectItem), -1);
    rb_define_method(cFXIconList.klass, "deselectItem", VALUEFUNC(_wrap_FXIconList_deselectItem), -1);
    rb_define_method(cFXIconList.klass, "toggleItem", VALUEFUNC(_wrap_FXIconList_toggleItem), -1);
    rb_define_method(cFXIconList.klass, "selectInRectangle", VALUEFUNC(_wrap_FXIconList_selectInRectangle), -1);
    rb_define_method(cFXIconList.klass, "extendSelection", VALUEFUNC(_wrap_FXIconList_extendSelection), -1);
    rb_define_method(cFXIconList.klass, "killSelection", VALUEFUNC(_wrap_FXIconList_killSelection), -1);
    rb_define_method(cFXIconList.klass, "setCurrentItem", VALUEFUNC(_wrap_FXIconList_setCurrentItem), -1);
    cFXIconList.mark = (void (*)(void *)) FXRbIconList::markfunc;
    cFXIconList.destroy = (void (*)(void *)) FXRbObject::freefunc;
    
    SWIGTYPE_p_FXIconList->dcast = (swig_dycast_func) FXIconList_dynamic_cast;
    
    rb_define_const(mFox,"FILELIST_SHOWHIDDEN", INT2NUM(FILELIST_SHOWHIDDEN));
    rb_define_const(mFox,"FILELIST_SHOWDIRS", INT2NUM(FILELIST_SHOWDIRS));
    rb_define_const(mFox,"FILELIST_SHOWFILES", INT2NUM(FILELIST_SHOWFILES));
    rb_define_const(mFox,"FILELIST_NO_OWN_ASSOC", INT2NUM(FILELIST_NO_OWN_ASSOC));
    
    cFXFileItem.klass = rb_define_class_under(mFox, "FXFileItem", ((swig_class *) SWIGTYPE_p_FXIconItem->clientdata)->klass);
    SWIG_TypeClientData(SWIGTYPE_p_FXFileItem, (void *) &cFXFileItem);
    rb_define_alloc_func(cFXFileItem.klass, _wrap_FXFileItem_allocate);
    rb_define_method(cFXFileItem.klass, "initialize", VALUEFUNC(_wrap_new_FXFileItem), -1);
    rb_define_method(cFXFileItem.klass, "isFile", VALUEFUNC(_wrap_FXFileItem_isFile), -1);
    rb_define_method(cFXFileItem.klass, "isDirectory", VALUEFUNC(_wrap_FXFileItem_isDirectory), -1);
    rb_define_method(cFXFileItem.klass, "isShare", VALUEFUNC(_wrap_FXFileItem_isShare), -1);
    rb_define_method(cFXFileItem.klass, "isExecutable", VALUEFUNC(_wrap_FXFileItem_isExecutable), -1);
    rb_define_method(cFXFileItem.klass, "isSymlink", VALUEFUNC(_wrap_FXFileItem_isSymlink), -1);
    rb_define_method(cFXFileItem.klass, "isChardev", VALUEFUNC(_wrap_FXFileItem_isChardev), -1);
    rb_define_method(cFXFileItem.klass, "isBlockdev", VALUEFUNC(_wrap_FXFileItem_isBlockdev), -1);
    rb_define_method(cFXFileItem.klass, "isFifo", VALUEFUNC(_wrap_FXFileItem_isFifo), -1);
    rb_define_method(cFXFileItem.klass, "isSocket", VALUEFUNC(_wrap_FXFileItem_isSocket), -1);
    rb_define_method(cFXFileItem.klass, "getAssoc", VALUEFUNC(_wrap_FXFileItem_getAssoc), -1);
    rb_define_method(cFXFileItem.klass, "getSize", VALUEFUNC(_wrap_FXFileItem_getSize), -1);
    rb_define_method(cFXFileItem.klass, "getDate", VALUEFUNC(_wrap_FXFileItem_getDate), -1);
    rb_define_method(cFXFileItem.klass, "save", VALUEFUNC(_wrap_FXFileItem_save), -1);
    rb_define_method(cFXFileItem.klass, "load", VALUEFUNC(_wrap_FXFileItem_load), -1);
    rb_define_method(cFXFileItem.klass, "draw", VALUEFUNC(_wrap_FXFileItem_draw), -1);
    rb_define_method(cFXFileItem.klass, "hitItem", VALUEFUNC(_wrap_FXFileItem_hitItem), -1);
    rb_define_method(cFXFileItem.klass, "drawBigIcon", VALUEFUNC(_wrap_FXFileItem_drawBigIcon), -1);
    rb_define_method(cFXFileItem.klass, "drawMiniIcon", VALUEFUNC(_wrap_FXFileItem_drawMiniIcon), -1);
    rb_define_method(cFXFileItem.klass, "drawDetails", VALUEFUNC(_wrap_FXFileItem_drawDetails), -1);
    rb_define_method(cFXFileItem.klass, "setText", VALUEFUNC(_wrap_FXFileItem_setText), -1);
    rb_define_method(cFXFileItem.klass, "setBigIcon", VALUEFUNC(_wrap_FXFileItem_setBigIcon), -1);
    rb_define_method(cFXFileItem.klass, "setMiniIcon", VALUEFUNC(_wrap_FXFileItem_setMiniIcon), -1);
    rb_define_method(cFXFileItem.klass, "setFocus", VALUEFUNC(_wrap_FXFileItem_setFocus), -1);
    rb_define_method(cFXFileItem.klass, "setSelected", VALUEFUNC(_wrap_FXFileItem_setSelected), -1);
    rb_define_method(cFXFileItem.klass, "setEnabled", VALUEFUNC(_wrap_FXFileItem_setEnabled), -1);
    rb_define_method(cFXFileItem.klass, "setDraggable", VALUEFUNC(_wrap_FXFileItem_setDraggable), -1);
    rb_define_method(cFXFileItem.klass, "setIconOwned", VALUEFUNC(_wrap_FXFileItem_setIconOwned), -1);
    rb_define_method(cFXFileItem.klass, "getWidth", VALUEFUNC(_wrap_FXFileItem_getWidth), -1);
    rb_define_method(cFXFileItem.klass, "getHeight", VALUEFUNC(_wrap_FXFileItem_getHeight), -1);
    rb_define_method(cFXFileItem.klass, "create", VALUEFUNC(_wrap_FXFileItem_create), -1);
    rb_define_method(cFXFileItem.klass, "detach", VALUEFUNC(_wrap_FXFileItem_detach), -1);
    rb_define_method(cFXFileItem.klass, "destroy", VALUEFUNC(_wrap_FXFileItem_destroy), -1);
    cFXFileItem.mark = (void (*)(void *)) FXRbFileItem::markfunc;
    cFXFileItem.destroy = (void (*)(void *)) FXRbFileItem::freefunc;
    
    cFXFileList.klass = rb_define_class_under(mFox, "FXFileList", ((swig_class *) SWIGTYPE_p_FXIconList->clientdata)->klass);
    SWIG_TypeClientData(SWIGTYPE_p_FXFileList, (void *) &cFXFileList);
    rb_define_alloc_func(cFXFileList.klass, _wrap_FXFileList_allocate);
    rb_define_method(cFXFileList.klass, "initialize", VALUEFUNC(_wrap_new_FXFileList), -1);
    rb_define_method(cFXFileList.klass, "onRefreshTimer", VALUEFUNC(_wrap_FXFileList_onRefreshTimer), -1);
    rb_define_method(cFXFileList.klass, "onOpenTimer", VALUEFUNC(_wrap_FXFileList_onOpenTimer), -1);
    rb_define_method(cFXFileList.klass, "onDNDEnter", VALUEFUNC(_wrap_FXFileList_onDNDEnter), -1);
    rb_define_method(cFXFileList.klass, "onDNDLeave", VALUEFUNC(_wrap_FXFileList_onDNDLeave), -1);
    rb_define_method(cFXFileList.klass, "onDNDMotion", VALUEFUNC(_wrap_FXFileList_onDNDMotion), -1);
    rb_define_method(cFXFileList.klass, "onDNDDrop", VALUEFUNC(_wrap_FXFileList_onDNDDrop), -1);
    rb_define_method(cFXFileList.klass, "onDNDRequest", VALUEFUNC(_wrap_FXFileList_onDNDRequest), -1);
    rb_define_method(cFXFileList.klass, "onBeginDrag", VALUEFUNC(_wrap_FXFileList_onBeginDrag), -1);
    rb_define_method(cFXFileList.klass, "onEndDrag", VALUEFUNC(_wrap_FXFileList_onEndDrag), -1);
    rb_define_method(cFXFileList.klass, "onDragged", VALUEFUNC(_wrap_FXFileList_onDragged), -1);
    rb_define_method(cFXFileList.klass, "onCmdSetValue", VALUEFUNC(_wrap_FXFileList_onCmdSetValue), -1);
    rb_define_method(cFXFileList.klass, "onCmdGetStringValue", VALUEFUNC(_wrap_FXFileList_onCmdGetStringValue), -1);
    rb_define_method(cFXFileList.klass, "onCmdSetStringValue", VALUEFUNC(_wrap_FXFileList_onCmdSetStringValue), -1);
    rb_define_method(cFXFileList.klass, "onCmdDirectoryUp", VALUEFUNC(_wrap_FXFileList_onCmdDirectoryUp), -1);
    rb_define_method(cFXFileList.klass, "onUpdDirectoryUp", VALUEFUNC(_wrap_FXFileList_onUpdDirectoryUp), -1);
    rb_define_method(cFXFileList.klass, "onCmdSortByName", VALUEFUNC(_wrap_FXFileList_onCmdSortByName), -1);
    rb_define_method(cFXFileList.klass, "onUpdSortByName", VALUEFUNC(_wrap_FXFileList_onUpdSortByName), -1);
    rb_define_method(cFXFileList.klass, "onCmdSortByType", VALUEFUNC(_wrap_FXFileList_onCmdSortByType), -1);
    rb_define_method(cFXFileList.klass, "onUpdSortByType", VALUEFUNC(_wrap_FXFileList_onUpdSortByType), -1);
    rb_define_method(cFXFileList.klass, "onCmdSortBySize", VALUEFUNC(_wrap_FXFileList_onCmdSortBySize), -1);
    rb_define_method(cFXFileList.klass, "onUpdSortBySize", VALUEFUNC(_wrap_FXFileList_onUpdSortBySize), -1);
    rb_define_method(cFXFileList.klass, "onCmdSortByTime", VALUEFUNC(_wrap_FXFileList_onCmdSortByTime), -1);
    rb_define_method(cFXFileList.klass, "onUpdSortByTime", VALUEFUNC(_wrap_FXFileList_onUpdSortByTime), -1);
    rb_define_method(cFXFileList.klass, "onCmdSortByUser", VALUEFUNC(_wrap_FXFileList_onCmdSortByUser), -1);
    rb_define_method(cFXFileList.klass, "onUpdSortByUser", VALUEFUNC(_wrap_FXFileList_onUpdSortByUser), -1);
    rb_define_method(cFXFileList.klass, "onCmdSortByGroup", VALUEFUNC(_wrap_FXFileList_onCmdSortByGroup), -1);
    rb_define_method(cFXFileList.klass, "onUpdSortByGroup", VALUEFUNC(_wrap_FXFileList_onUpdSortByGroup), -1);
    rb_define_method(cFXFileList.klass, "onCmdSortReverse", VALUEFUNC(_wrap_FXFileList_onCmdSortReverse), -1);
    rb_define_method(cFXFileList.klass, "onUpdSortReverse", VALUEFUNC(_wrap_FXFileList_onUpdSortReverse), -1);
    rb_define_method(cFXFileList.klass, "onCmdSortCase", VALUEFUNC(_wrap_FXFileList_onCmdSortCase), -1);
    rb_define_method(cFXFileList.klass, "onUpdSortCase", VALUEFUNC(_wrap_FXFileList_onUpdSortCase), -1);
    rb_define_method(cFXFileList.klass, "onCmdSetPattern", VALUEFUNC(_wrap_FXFileList_onCmdSetPattern), -1);
    rb_define_method(cFXFileList.klass, "onUpdSetPattern", VALUEFUNC(_wrap_FXFileList_onUpdSetPattern), -1);
    rb_define_method(cFXFileList.klass, "onCmdSetDirectory", VALUEFUNC(_wrap_FXFileList_onCmdSetDirectory), -1);
    rb_define_method(cFXFileList.klass, "onUpdSetDirectory", VALUEFUNC(_wrap_FXFileList_onUpdSetDirectory), -1);
    rb_define_method(cFXFileList.klass, "onCmdToggleHidden", VALUEFUNC(_wrap_FXFileList_onCmdToggleHidden), -1);
    rb_define_method(cFXFileList.klass, "onUpdToggleHidden", VALUEFUNC(_wrap_FXFileList_onUpdToggleHidden), -1);
    rb_define_method(cFXFileList.klass, "onCmdShowHidden", VALUEFUNC(_wrap_FXFileList_onCmdShowHidden), -1);
    rb_define_method(cFXFileList.klass, "onUpdShowHidden", VALUEFUNC(_wrap_FXFileList_onUpdShowHidden), -1);
    rb_define_method(cFXFileList.klass, "onCmdHideHidden", VALUEFUNC(_wrap_FXFileList_onCmdHideHidden), -1);
    rb_define_method(cFXFileList.klass, "onUpdHideHidden", VALUEFUNC(_wrap_FXFileList_onUpdHideHidden), -1);
    rb_define_method(cFXFileList.klass, "onCmdHeader", VALUEFUNC(_wrap_FXFileList_onCmdHeader), -1);
    rb_define_method(cFXFileList.klass, "onUpdHeader", VALUEFUNC(_wrap_FXFileList_onUpdHeader), -1);
    rb_define_method(cFXFileList.klass, "onCmdRefresh", VALUEFUNC(_wrap_FXFileList_onCmdRefresh), -1);
    rb_define_singleton_method(cFXFileList.klass, "ascending", VALUEFUNC(_wrap_FXFileList_ascending), -1);
    rb_define_singleton_method(cFXFileList.klass, "descending", VALUEFUNC(_wrap_FXFileList_descending), -1);
    rb_define_singleton_method(cFXFileList.klass, "ascendingCase", VALUEFUNC(_wrap_FXFileList_ascendingCase), -1);
    rb_define_singleton_method(cFXFileList.klass, "descendingCase", VALUEFUNC(_wrap_FXFileList_descendingCase), -1);
    rb_define_singleton_method(cFXFileList.klass, "ascendingType", VALUEFUNC(_wrap_FXFileList_ascendingType), -1);
    rb_define_singleton_method(cFXFileList.klass, "descendingType", VALUEFUNC(_wrap_FXFileList_descendingType), -1);
    rb_define_singleton_method(cFXFileList.klass, "ascendingSize", VALUEFUNC(_wrap_FXFileList_ascendingSize), -1);
    rb_define_singleton_method(cFXFileList.klass, "descendingSize", VALUEFUNC(_wrap_FXFileList_descendingSize), -1);
    rb_define_singleton_method(cFXFileList.klass, "ascendingTime", VALUEFUNC(_wrap_FXFileList_ascendingTime), -1);
    rb_define_singleton_method(cFXFileList.klass, "descendingTime", VALUEFUNC(_wrap_FXFileList_descendingTime), -1);
    rb_define_singleton_method(cFXFileList.klass, "ascendingUser", VALUEFUNC(_wrap_FXFileList_ascendingUser), -1);
    rb_define_singleton_method(cFXFileList.klass, "descendingUser", VALUEFUNC(_wrap_FXFileList_descendingUser), -1);
    rb_define_singleton_method(cFXFileList.klass, "ascendingGroup", VALUEFUNC(_wrap_FXFileList_ascendingGroup), -1);
    rb_define_singleton_method(cFXFileList.klass, "descendingGroup", VALUEFUNC(_wrap_FXFileList_descendingGroup), -1);
    rb_define_const(cFXFileList.klass,"ID_REFRESHTIMER", INT2NUM(FXFileList::ID_REFRESHTIMER));
    rb_define_const(cFXFileList.klass,"ID_OPENTIMER", INT2NUM(FXFileList::ID_OPENTIMER));
    rb_define_const(cFXFileList.klass,"ID_SORT_BY_NAME", INT2NUM(FXFileList::ID_SORT_BY_NAME));
    rb_define_const(cFXFileList.klass,"ID_SORT_BY_TYPE", INT2NUM(FXFileList::ID_SORT_BY_TYPE));
    rb_define_const(cFXFileList.klass,"ID_SORT_BY_SIZE", INT2NUM(FXFileList::ID_SORT_BY_SIZE));
    rb_define_const(cFXFileList.klass,"ID_SORT_BY_TIME", INT2NUM(FXFileList::ID_SORT_BY_TIME));
    rb_define_const(cFXFileList.klass,"ID_SORT_BY_USER", INT2NUM(FXFileList::ID_SORT_BY_USER));
    rb_define_const(cFXFileList.klass,"ID_SORT_BY_GROUP", INT2NUM(FXFileList::ID_SORT_BY_GROUP));
    rb_define_const(cFXFileList.klass,"ID_SORT_REVERSE", INT2NUM(FXFileList::ID_SORT_REVERSE));
    rb_define_const(cFXFileList.klass,"ID_SORT_CASE", INT2NUM(FXFileList::ID_SORT_CASE));
    rb_define_const(cFXFileList.klass,"ID_DIRECTORY_UP", INT2NUM(FXFileList::ID_DIRECTORY_UP));
    rb_define_const(cFXFileList.klass,"ID_SET_PATTERN", INT2NUM(FXFileList::ID_SET_PATTERN));
    rb_define_const(cFXFileList.klass,"ID_SET_DIRECTORY", INT2NUM(FXFileList::ID_SET_DIRECTORY));
    rb_define_const(cFXFileList.klass,"ID_SHOW_HIDDEN", INT2NUM(FXFileList::ID_SHOW_HIDDEN));
    rb_define_const(cFXFileList.klass,"ID_HIDE_HIDDEN", INT2NUM(FXFileList::ID_HIDE_HIDDEN));
    rb_define_const(cFXFileList.klass,"ID_TOGGLE_HIDDEN", INT2NUM(FXFileList::ID_TOGGLE_HIDDEN));
    rb_define_const(cFXFileList.klass,"ID_REFRESH", INT2NUM(FXFileList::ID_REFRESH));
    rb_define_const(cFXFileList.klass,"ID_LAST", INT2NUM(FXFileList::ID_LAST));
    rb_define_method(cFXFileList.klass, "scan", VALUEFUNC(_wrap_FXFileList_scan), -1);
    rb_define_method(cFXFileList.klass, "setCurrentFile", VALUEFUNC(_wrap_FXFileList_setCurrentFile), -1);
    rb_define_method(cFXFileList.klass, "getCurrentFile", VALUEFUNC(_wrap_FXFileList_getCurrentFile), -1);
    rb_define_method(cFXFileList.klass, "setDirectory", VALUEFUNC(_wrap_FXFileList_setDirectory), -1);
    rb_define_method(cFXFileList.klass, "getDirectory", VALUEFUNC(_wrap_FXFileList_getDirectory), -1);
    rb_define_method(cFXFileList.klass, "setPattern", VALUEFUNC(_wrap_FXFileList_setPattern), -1);
    rb_define_method(cFXFileList.klass, "getPattern", VALUEFUNC(_wrap_FXFileList_getPattern), -1);
    rb_define_method(cFXFileList.klass, "isItemDirectory", VALUEFUNC(_wrap_FXFileList_isItemDirectory), -1);
    rb_define_method(cFXFileList.klass, "isItemShare", VALUEFUNC(_wrap_FXFileList_isItemShare), -1);
    rb_define_method(cFXFileList.klass, "isItemFile", VALUEFUNC(_wrap_FXFileList_isItemFile), -1);
    rb_define_method(cFXFileList.klass, "isItemExecutable", VALUEFUNC(_wrap_FXFileList_isItemExecutable), -1);
    rb_define_method(cFXFileList.klass, "getItemFilename", VALUEFUNC(_wrap_FXFileList_getItemFilename), -1);
    rb_define_method(cFXFileList.klass, "getItemPathname", VALUEFUNC(_wrap_FXFileList_getItemPathname), -1);
    rb_define_method(cFXFileList.klass, "getItemAssoc", VALUEFUNC(_wrap_FXFileList_getItemAssoc), -1);
    rb_define_method(cFXFileList.klass, "getMatchMode", VALUEFUNC(_wrap_FXFileList_getMatchMode), -1);
    rb_define_method(cFXFileList.klass, "setMatchMode", VALUEFUNC(_wrap_FXFileList_setMatchMode), -1);
    rb_define_method(cFXFileList.klass, "getHiddenFilesShown", VALUEFUNC(_wrap_FXFileList_getHiddenFilesShown), -1);
    rb_define_method(cFXFileList.klass, "setHiddenFilesShown", VALUEFUNC(_wrap_FXFileList_setHiddenFilesShown), -1);
    rb_define_method(cFXFileList.klass, "getOnlyDirectoriesShown", VALUEFUNC(_wrap_FXFileList_getOnlyDirectoriesShown), -1);
    rb_define_method(cFXFileList.klass, "setOnlyDirectoriesShown", VALUEFUNC(_wrap_FXFileList_setOnlyDirectoriesShown), -1);
    rb_define_method(cFXFileList.klass, "showOnlyFiles", VALUEFUNC(_wrap_FXFileList_showOnlyFiles), -1);
    rb_define_method(cFXFileList.klass, "setAssociations", VALUEFUNC(_wrap_FXFileList_setAssociations), -1);
    rb_define_method(cFXFileList.klass, "getAssociations", VALUEFUNC(_wrap_FXFileList_getAssociations), -1);
    rb_define_method(cFXFileList.klass, "save", VALUEFUNC(_wrap_FXFileList_save), -1);
    rb_define_method(cFXFileList.klass, "load", VALUEFUNC(_wrap_FXFileList_load), -1);
    rb_define_method(cFXFileList.klass, "create", VALUEFUNC(_wrap_FXFileList_create), -1);
    rb_define_method(cFXFileList.klass, "detach", VALUEFUNC(_wrap_FXFileList_detach), -1);
    rb_define_method(cFXFileList.klass, "destroy", VALUEFUNC(_wrap_FXFileList_destroy), -1);
    rb_define_method(cFXFileList.klass, "resize", VALUEFUNC(_wrap_FXFileList_resize), -1);
    rb_define_method(cFXFileList.klass, "getDefaultWidth", VALUEFUNC(_wrap_FXFileList_getDefaultWidth), -1);
    rb_define_method(cFXFileList.klass, "getDefaultHeight", VALUEFUNC(_wrap_FXFileList_getDefaultHeight), -1);
    rb_define_method(cFXFileList.klass, "getWidthForHeight", VALUEFUNC(_wrap_FXFileList_getWidthForHeight), -1);
    rb_define_method(cFXFileList.klass, "getHeightForWidth", VALUEFUNC(_wrap_FXFileList_getHeightForWidth), -1);
    rb_define_method(cFXFileList.klass, "canFocus", VALUEFUNC(_wrap_FXFileList_canFocus), -1);
    rb_define_method(cFXFileList.klass, "setFocus", VALUEFUNC(_wrap_FXFileList_setFocus), -1);
    rb_define_method(cFXFileList.klass, "killFocus", VALUEFUNC(_wrap_FXFileList_killFocus), -1);
    rb_define_method(cFXFileList.klass, "setDefault", VALUEFUNC(_wrap_FXFileList_setDefault), -1);
    rb_define_method(cFXFileList.klass, "enable", VALUEFUNC(_wrap_FXFileList_enable), -1);
    rb_define_method(cFXFileList.klass, "disable", VALUEFUNC(_wrap_FXFileList_disable), -1);
    rb_define_method(cFXFileList.klass, "raiseWindow", VALUEFUNC(_wrap_FXFileList_raiseWindow), -1);
    rb_define_method(cFXFileList.klass, "lower", VALUEFUNC(_wrap_FXFileList_lower), -1);
    rb_define_method(cFXFileList.klass, "move", VALUEFUNC(_wrap_FXFileList_move), -1);
    rb_define_method(cFXFileList.klass, "layout", VALUEFUNC(_wrap_FXFileList_layout), -1);
    rb_define_method(cFXFileList.klass, "recalc", VALUEFUNC(_wrap_FXFileList_recalc), -1);
    rb_define_method(cFXFileList.klass, "reparent", VALUEFUNC(_wrap_FXFileList_reparent), -1);
    rb_define_method(cFXFileList.klass, "show", VALUEFUNC(_wrap_FXFileList_show), -1);
    rb_define_method(cFXFileList.klass, "hide", VALUEFUNC(_wrap_FXFileList_hide), -1);
    rb_define_method(cFXFileList.klass, "isComposite", VALUEFUNC(_wrap_FXFileList_isComposite), -1);
    rb_define_method(cFXFileList.klass, "contains", VALUEFUNC(_wrap_FXFileList_contains), -1);
    rb_define_method(cFXFileList.klass, "doesSaveUnder", VALUEFUNC(_wrap_FXFileList_doesSaveUnder), -1);
    rb_define_method(cFXFileList.klass, "setBackColor", VALUEFUNC(_wrap_FXFileList_setBackColor), -1);
    rb_define_method(cFXFileList.klass, "getViewportHeight", VALUEFUNC(_wrap_FXFileList_getViewportHeight), -1);
    rb_define_method(cFXFileList.klass, "getViewportWidth", VALUEFUNC(_wrap_FXFileList_getViewportWidth), -1);
    rb_define_method(cFXFileList.klass, "getContentHeight", VALUEFUNC(_wrap_FXFileList_getContentHeight), -1);
    rb_define_method(cFXFileList.klass, "getContentWidth", VALUEFUNC(_wrap_FXFileList_getContentWidth), -1);
    rb_define_method(cFXFileList.klass, "position", VALUEFUNC(_wrap_FXFileList_position), -1);
    rb_define_method(cFXFileList.klass, "selectItem", VALUEFUNC(_wrap_FXFileList_selectItem), -1);
    rb_define_method(cFXFileList.klass, "deselectItem", VALUEFUNC(_wrap_FXFileList_deselectItem), -1);
    rb_define_method(cFXFileList.klass, "toggleItem", VALUEFUNC(_wrap_FXFileList_toggleItem), -1);
    rb_define_method(cFXFileList.klass, "selectInRectangle", VALUEFUNC(_wrap_FXFileList_selectInRectangle), -1);
    rb_define_method(cFXFileList.klass, "extendSelection", VALUEFUNC(_wrap_FXFileList_extendSelection), -1);
    rb_define_method(cFXFileList.klass, "killSelection", VALUEFUNC(_wrap_FXFileList_killSelection), -1);
    rb_define_method(cFXFileList.klass, "setCurrentItem", VALUEFUNC(_wrap_FXFileList_setCurrentItem), -1);
    cFXFileList.mark = (void (*)(void *)) FXRbFileList::markfunc;
    cFXFileList.destroy = (void (*)(void *)) FXRbObject::freefunc;
}

