/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 1.3.22
 * 
 * This file is not intended to be easily readable and contains a number of 
 * coding conventions designed to improve portability and efficiency. Do not make
 * changes to this file unless you know what you are doing--modify the SWIG 
 * interface file instead. 
 * ----------------------------------------------------------------------------- */

#define SWIG_NOINCLUDE

#ifdef __cplusplus
template<class T> class SwigValueWrapper {
    T *tt;
public:
    SwigValueWrapper() : tt(0) { }
    SwigValueWrapper(const SwigValueWrapper<T>& rhs) : tt(new T(*rhs.tt)) { }
    SwigValueWrapper(const T& t) : tt(new T(t)) { }
    ~SwigValueWrapper() { delete tt; } 
    SwigValueWrapper& operator=(const T& t) { delete tt; tt = new T(t); return *this; }
    operator T&() const { return *tt; }
    T *operator&() { return tt; }
private:
    SwigValueWrapper& operator=(const SwigValueWrapper<T>& rhs);
};                                                    
#endif

/* ruby.swg */
/* Implementation : RUBY */
#define SWIGRUBY 1

#include "ruby.h"

/* Flags for pointer conversion */
#define SWIG_POINTER_EXCEPTION     0x1
#define SWIG_POINTER_DISOWN        0x2

#define NUM2USHRT(n) (\
    (0 <= NUM2UINT(n) && NUM2UINT(n) <= USHRT_MAX)\
    ? (unsigned short) NUM2UINT(n) \
    : (rb_raise(rb_eArgError, "integer %d out of range of `unsigned short'",\
               NUM2UINT(n)), (short)0)\
)

#define NUM2SHRT(n) (\
    (SHRT_MIN <= NUM2INT(n) && NUM2INT(n) <= SHRT_MAX)\
    ? (short)NUM2INT(n)\
    : (rb_raise(rb_eArgError, "integer %d out of range of `short'",\
               NUM2INT(n)), (short)0)\
)

/* Ruby 1.7 defines NUM2LL(), LL2NUM() and ULL2NUM() macros */
#ifndef NUM2LL
#define NUM2LL(x) NUM2LONG((x))
#endif
#ifndef LL2NUM
#define LL2NUM(x) INT2NUM((long) (x))
#endif
#ifndef ULL2NUM
#define ULL2NUM(x) UINT2NUM((unsigned long) (x))
#endif

/* Ruby 1.7 doesn't (yet) define NUM2ULL() */
#ifndef NUM2ULL
#ifdef HAVE_LONG_LONG
#define NUM2ULL(x) rb_num2ull((x))
#else
#define NUM2ULL(x) NUM2ULONG(x)
#endif
#endif

/*
 * Need to be very careful about how these macros are defined, especially
 * when compiling C++ code or C code with an ANSI C compiler.
 *
 * VALUEFUNC(f) is a macro used to typecast a C function that implements
 * a Ruby method so that it can be passed as an argument to API functions
 * like rb_define_method() and rb_define_singleton_method().
 *
 * VOIDFUNC(f) is a macro used to typecast a C function that implements
 * either the "mark" or "free" stuff for a Ruby Data object, so that it
 * can be passed as an argument to API functions like Data_Wrap_Struct()
 * and Data_Make_Struct().
 */
 
#ifdef __cplusplus
#  ifndef RUBY_METHOD_FUNC /* These definitions should work for Ruby 1.4.6 */
#    define PROTECTFUNC(f) ((VALUE (*)()) f)
#    define VALUEFUNC(f) ((VALUE (*)()) f)
#    define VOIDFUNC(f)  ((void (*)()) f)
#  else
#    ifndef ANYARGS /* These definitions should work for Ruby 1.6 */
#      define PROTECTFUNC(f) ((VALUE (*)()) f)
#      define VALUEFUNC(f) ((VALUE (*)()) f)
#      define VOIDFUNC(f)  ((RUBY_DATA_FUNC) f)
#    else /* These definitions should work for Ruby 1.7+ */
#      define PROTECTFUNC(f) ((VALUE (*)(VALUE)) f)
#      define VALUEFUNC(f) ((VALUE (*)(ANYARGS)) f)
#      define VOIDFUNC(f)  ((RUBY_DATA_FUNC) f)
#    endif
#  endif
#else
#  define VALUEFUNC(f) (f)
#  define VOIDFUNC(f) (f)
#endif

typedef struct {
  VALUE klass;
  VALUE mImpl;
  void  (*mark)(void *);
  void  (*destroy)(void *);
} swig_class;

/* Don't use for expressions have side effect */
#ifndef RB_STRING_VALUE
#define RB_STRING_VALUE(s) (TYPE(s) == T_STRING ? (s) : (*(volatile VALUE *)&(s) = rb_str_to_str(s)))
#endif
#ifndef StringValue
#define StringValue(s) RB_STRING_VALUE(s)
#endif
#ifndef StringValuePtr
#define StringValuePtr(s) RSTRING(RB_STRING_VALUE(s))->ptr
#endif
#ifndef StringValueLen
#define StringValueLen(s) RSTRING(RB_STRING_VALUE(s))->len
#endif
#ifndef SafeStringValue
#define SafeStringValue(v) do {\
    StringValue(v);\
    rb_check_safe_str(v);\
} while (0)
#endif

#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
#define rb_define_alloc_func(klass, func) rb_define_singleton_method((klass), "new", VALUEFUNC((func)), -1)
#define rb_undef_alloc_func(klass) rb_undef_method(CLASS_OF((klass)), "new")
#endif

/* Contract support */

#define SWIG_contract_assert(expr, msg) if (!(expr)) { rb_raise(rb_eRuntimeError, (char *) msg ); } else


/*************************************************************** -*- c -*-
 * ruby/precommon.swg
 *
 * Rename all exported symbols from common.swg, to avoid symbol
 * clashes if multiple interpreters are included
 *
 ************************************************************************/

#define SWIG_TypeRegister    SWIG_Ruby_TypeRegister
#define SWIG_TypeCheck       SWIG_Ruby_TypeCheck
#define SWIG_TypeCast        SWIG_Ruby_TypeCast
#define SWIG_TypeDynamicCast SWIG_Ruby_TypeDynamicCast
#define SWIG_TypeName        SWIG_Ruby_TypeName
#define SWIG_TypePrettyName  SWIG_Ruby_TypePrettyName
#define SWIG_TypeQuery       SWIG_Ruby_TypeQuery
#define SWIG_TypeClientData  SWIG_Ruby_TypeClientData
#define SWIG_PackData        SWIG_Ruby_PackData 
#define SWIG_UnpackData      SWIG_Ruby_UnpackData 

/* Also rename all exported symbols from rubydef.swig */

/* Common SWIG API */
#define SWIG_ConvertPtr(obj, pp, type, flags) \
  SWIG_Ruby_ConvertPtr(obj, pp, type, flags)
#define SWIG_NewPointerObj(p, type, flags) \
  SWIG_Ruby_NewPointerObj(p, type, flags)
#define SWIG_MustGetPtr(p, type, argnum, flags) \
  SWIG_Ruby_MustGetPtr(p, type, argnum, flags)

/* Ruby-specific SWIG API */

#define SWIG_InitRuntime() \
  SWIG_Ruby_InitRuntime()
#define SWIG_define_class(ty) \
  SWIG_Ruby_define_class(ty)
#define SWIG_NewClassInstance(value, ty) \
  SWIG_Ruby_NewClassInstance(value, ty)
#define SWIG_MangleStr(value) \
  SWIG_Ruby_MangleStr(value)
#define SWIG_CheckConvert(value, ty) \
  SWIG_Ruby_CheckConvert(value, ty)
#define SWIG_NewPackedObj(ptr, sz, ty) \
  SWIG_Ruby_NewPackedObj(ptr, sz, ty)
#define SWIG_ConvertPacked(obj, ptr, sz, ty, flags) \
  SWIG_Ruby_ConvertPacked(obj, ptr, sz, ty, flags)


/***********************************************************************
 * common.swg
 *
 *     This file contains generic SWIG runtime support for pointer
 *     type checking as well as a few commonly used macros to control
 *     external linkage.
 *
 * Author : David Beazley (beazley@cs.uchicago.edu)
 *
 * Copyright (c) 1999-2000, The University of Chicago
 * 
 * This file may be freely redistributed without license or fee provided
 * this copyright message remains intact.
 ************************************************************************/

#include <string.h>

#if defined(_WIN32) || defined(__WIN32__) || defined(__CYGWIN__)
#  if defined(_MSC_VER) || defined(__GNUC__)
#    if defined(STATIC_LINKED)
#      define SWIGEXPORT(a) a
#      define SWIGIMPORT(a) extern a
#    else
#      define SWIGEXPORT(a) __declspec(dllexport) a
#      define SWIGIMPORT(a) extern a
#    endif
#  else
#    if defined(__BORLANDC__)
#      define SWIGEXPORT(a) a _export
#      define SWIGIMPORT(a) a _export
#    else
#      define SWIGEXPORT(a) a
#      define SWIGIMPORT(a) a
#    endif
#  endif
#else
#  define SWIGEXPORT(a) a
#  define SWIGIMPORT(a) a
#endif

#ifdef SWIG_GLOBAL
#  define SWIGRUNTIME(a) SWIGEXPORT(a)
#else
#  define SWIGRUNTIME(a) static a
#endif

#ifdef __cplusplus
extern "C" {
#endif

typedef void *(*swig_converter_func)(void *);
typedef struct swig_type_info *(*swig_dycast_func)(void **);

typedef struct swig_type_info {
  const char             *name;
  swig_converter_func     converter;
  const char             *str;
  void                   *clientdata;
  swig_dycast_func        dcast;
  struct swig_type_info  *next;
  struct swig_type_info  *prev;
} swig_type_info;

#ifdef SWIG_NOINCLUDE

SWIGIMPORT(swig_type_info *) SWIG_TypeRegister(swig_type_info *);
SWIGIMPORT(swig_type_info *) SWIG_TypeCheck(char *c, swig_type_info *);
SWIGIMPORT(void *)           SWIG_TypeCast(swig_type_info *, void *);
SWIGIMPORT(swig_type_info *) SWIG_TypeDynamicCast(swig_type_info *, void **);
SWIGIMPORT(const char *)     SWIG_TypeName(const swig_type_info *);
SWIGIMPORT(const char *)     SWIG_TypePrettyName(const swig_type_info *);
SWIGIMPORT(swig_type_info *) SWIG_TypeQuery(const char *);
SWIGIMPORT(void)             SWIG_TypeClientData(swig_type_info *, void *);
SWIGIMPORT(char *)           SWIG_PackData(char *, void *, int);
SWIGIMPORT(char *)           SWIG_UnpackData(char *, void *, int);

#else

static swig_type_info *swig_type_list = 0;
static swig_type_info **swig_type_list_handle = &swig_type_list;

/* Register a type mapping with the type-checking */
SWIGRUNTIME(swig_type_info *)
SWIG_TypeRegister(swig_type_info *ti) {
  swig_type_info *tc, *head, *ret, *next;
  /* Check to see if this type has already been registered */
  tc = *swig_type_list_handle;
  while (tc) {
    if (strcmp(tc->name, ti->name) == 0) {
      /* Already exists in the table.  Just add additional types to the list */
      if (tc->clientdata) ti->clientdata = tc->clientdata;
      head = tc;
      next = tc->next;
      goto l1;
    }
    tc = tc->prev;
  }
  head = ti;
  next = 0;

  /* Place in list */
  ti->prev = *swig_type_list_handle;
  *swig_type_list_handle = ti;

  /* Build linked lists */
  l1:
  ret = head;
  tc = ti + 1;
  /* Patch up the rest of the links */
  while (tc->name) {
    head->next = tc;
    tc->prev = head;
    head = tc;
    tc++;
  }
  if (next) next->prev = head;
  head->next = next;
  return ret;
}

/* Check the typename */
SWIGRUNTIME(swig_type_info *) 
SWIG_TypeCheck(char *c, swig_type_info *ty) {
  swig_type_info *s;
  if (!ty) return 0;        /* Void pointer */
  s = ty->next;             /* First element always just a name */
  do {
    if (strcmp(s->name,c) == 0) {
      if (s == ty->next) return s;
      /* Move s to the top of the linked list */
      s->prev->next = s->next;
      if (s->next) {
        s->next->prev = s->prev;
      }
      /* Insert s as second element in the list */
      s->next = ty->next;
      if (ty->next) ty->next->prev = s;
      ty->next = s;
      s->prev = ty;
      return s;
    }
    s = s->next;
  } while (s && (s != ty->next));
  return 0;
}

/* Cast a pointer up an inheritance hierarchy */
SWIGRUNTIME(void *) 
SWIG_TypeCast(swig_type_info *ty, void *ptr) {
  if ((!ty) || (!ty->converter)) return ptr;
  return (*ty->converter)(ptr);
}

/* Dynamic pointer casting. Down an inheritance hierarchy */
SWIGRUNTIME(swig_type_info *) 
SWIG_TypeDynamicCast(swig_type_info *ty, void **ptr) {
  swig_type_info *lastty = ty;
  if (!ty || !ty->dcast) return ty;
  while (ty && (ty->dcast)) {
    ty = (*ty->dcast)(ptr);
    if (ty) lastty = ty;
  }
  return lastty;
}

/* Return the name associated with this type */
SWIGRUNTIME(const char *)
SWIG_TypeName(const swig_type_info *ty) {
  return ty->name;
}

/* Return the pretty name associated with this type,
   that is an unmangled type name in a form presentable to the user.
*/
SWIGRUNTIME(const char *)
SWIG_TypePrettyName(const swig_type_info *type) {
  /* The "str" field contains the equivalent pretty names of the
     type, separated by vertical-bar characters.  We choose
     to print the last name, as it is often (?) the most
     specific. */
  if (type->str != NULL) {
    const char *last_name = type->str;
    const char *s;
    for (s = type->str; *s; s++)
      if (*s == '|') last_name = s+1;
    return last_name;
  }
  else
    return type->name;
}

/* 
   Compare two type names skipping the space characters, therefore
   "char*" == "char *" and "Class<int>" == "Class<int >", etc.

   Return 0 when the two name types are equivalent, as in
   strncmp, but skipping ' '.
*/
static int
SWIG_TypeNameComp(const char *f1, const char *l1,
		  const char *f2, const char *l2) {
  for (;(f1 != l1) && (f2 != l2); ++f1, ++f2) {
    while ((*f1 == ' ') && (f1 != l1)) ++f1;
    while ((*f2 == ' ') && (f2 != l2)) ++f2;
    if (*f1 != *f2) return *f1 - *f2;
  }
  return (l1 - f1) - (l2 - f2);
}

/*
  Check type equivalence in a name list like <name1>|<name2>|...
*/
static int
SWIG_TypeEquiv(const char *nb, const char *tb) {
  int equiv = 0;
  const char* te = tb + strlen(tb);
  const char* ne = nb;
  while (!equiv && *ne) {
    for (nb = ne; *ne; ++ne) {
      if (*ne == '|') break;
    }
    equiv = SWIG_TypeNameComp(nb, ne, tb, te) == 0;
    if (*ne) ++ne;
  }
  return equiv;
}
  

/* Search for a swig_type_info structure */
SWIGRUNTIME(swig_type_info *)
SWIG_TypeQuery(const char *name) {
  swig_type_info *ty = *swig_type_list_handle;
  while (ty) {
    if (ty->str && (SWIG_TypeEquiv(ty->str,name))) return ty;
    if (ty->name && (strcmp(name,ty->name) == 0)) return ty;
    ty = ty->prev;
  }
  return 0;
}

/* Set the clientdata field for a type */
SWIGRUNTIME(void)
SWIG_TypeClientData(swig_type_info *ti, void *clientdata) {
  swig_type_info *tc, *equiv;
  if (ti->clientdata == clientdata) return;
  ti->clientdata = clientdata;
  equiv = ti->next;
  while (equiv) {
    if (!equiv->converter) {
      tc = *swig_type_list_handle;
      while (tc) {
        if ((strcmp(tc->name, equiv->name) == 0))
          SWIG_TypeClientData(tc,clientdata);
        tc = tc->prev;
      }
    }
    equiv = equiv->next;
  }
}

/* Pack binary data into a string */
SWIGRUNTIME(char *)
SWIG_PackData(char *c, void *ptr, int sz) {
  static char hex[17] = "0123456789abcdef";
  unsigned char *u = (unsigned char *) ptr;
  const unsigned char *eu =  u + sz;
  register unsigned char uu;
  for (; u != eu; ++u) {
    uu = *u;
    *(c++) = hex[(uu & 0xf0) >> 4];
    *(c++) = hex[uu & 0xf];
  }
  return c;
}

/* Unpack binary data from a string */
SWIGRUNTIME(char *)
SWIG_UnpackData(char *c, void *ptr, int sz) {
  register unsigned char uu = 0;
  register int d;
  unsigned char *u = (unsigned char *) ptr;
  const unsigned char *eu =  u + sz;
  for (; u != eu; ++u) {
    d = *(c++);
    if ((d >= '0') && (d <= '9'))
      uu = ((d - '0') << 4);
    else if ((d >= 'a') && (d <= 'f'))
      uu = ((d - ('a'-10)) << 4);
    d = *(c++);
    if ((d >= '0') && (d <= '9'))
      uu |= (d - '0');
    else if ((d >= 'a') && (d <= 'f'))
      uu |= (d - ('a'-10));
    *u = uu;
  }
  return c;
}

#endif

#ifdef __cplusplus
}
#endif

/* rubydec.swg -*- c -*- */
#ifdef __cplusplus
extern "C" {
#endif

SWIGIMPORT(void)   SWIG_Ruby_InitRuntime(void);
SWIGIMPORT(void)   SWIG_Ruby_define_class(swig_type_info *);
SWIGIMPORT(VALUE)  SWIG_Ruby_NewPointerObj(void *, swig_type_info *, int);
SWIGIMPORT(VALUE)  SWIG_Ruby_NewClassInstance(VALUE, swig_type_info *);
SWIGIMPORT(char *) SWIG_Ruby_MangleStr(VALUE);
SWIGIMPORT(int)    SWIG_Ruby_ConvertPtr(VALUE, void**, swig_type_info *, int);
SWIGIMPORT(void *) SWIG_Ruby_MustGetPtr(VALUE, swig_type_info *, int, int);
SWIGIMPORT(int)    SWIG_Ruby_CheckConvert(VALUE, swig_type_info *);
SWIGIMPORT(VALUE)  SWIG_Ruby_NewPackedObj(void *ptr, int sz, swig_type_info *type);
SWIGIMPORT(void)   SWIG_Ruby_ConvertPacked(VALUE obj, void *ptr, int sz, swig_type_info *ty, int flags);

#ifdef __cplusplus
}
#endif


/* -------- TYPES TABLE (BEGIN) -------- */

#define  SWIGTYPE_p_FXObject swig_types[0] 
#define  SWIGTYPE_p_FXRGBImage swig_types[1] 
#define  SWIGTYPE_p_FXuchar swig_types[2] 
#define  SWIGTYPE_p_FXBitmap swig_types[3] 
#define  SWIGTYPE_p_FXId swig_types[4] 
#define  SWIGTYPE_p_p_FXchar swig_types[5] 
#define  SWIGTYPE_p_FXStream swig_types[6] 
#define  SWIGTYPE_p_FXDrawable swig_types[7] 
#define  SWIGTYPE_p_FXGIFImage swig_types[8] 
#define  SWIGTYPE_p_FXTIFImage swig_types[9] 
#define  SWIGTYPE_p_FXICOImage swig_types[10] 
#define  SWIGTYPE_p_FXPPMImage swig_types[11] 
#define  SWIGTYPE_p_FXXBMImage swig_types[12] 
#define  SWIGTYPE_p_FXXPMImage swig_types[13] 
#define  SWIGTYPE_p_FXPCXImage swig_types[14] 
#define  SWIGTYPE_p_FXColor swig_types[15] 
#define  SWIGTYPE_p_FXBMPImage swig_types[16] 
#define  SWIGTYPE_p_FXApp swig_types[17] 
#define  SWIGTYPE_p_FXJPGImage swig_types[18] 
#define  SWIGTYPE_p_FXImage swig_types[19] 
#define  SWIGTYPE_p_FXPNGImage swig_types[20] 
#define  SWIGTYPE_p_FXMemoryBuffer swig_types[21] 
#define  SWIGTYPE_p_FXTGAImage swig_types[22] 
static swig_type_info *swig_types[24];

/* -------- TYPES TABLE (END) -------- */

#define SWIG_init    Init_image
#define SWIG_name    "Image"


static void SWIG_AsVal(VALUE obj, int *val)
{
    *val = (int) NUM2INT(obj);
}


#include "FXRbCommon.h"


inline FXColor to_FXColor(VALUE obj){
  if(TYPE(obj)==T_STRING){
    return fxcolorfromname(StringValuePtr(obj));
    }
  else if(TYPE(obj)==T_SYMBOL){
    return fxcolorfromname(rb_id2name(SYM2ID(obj)));
    }
  else{
    return NUM2ULONG(obj);
    }
  }


inline FXString to_FXString(VALUE obj){
  if(!NIL_P(obj)){
    Check_Type(obj,T_STRING);
    return FXString(STR2CSTR(obj));
    }
  else{
    return FXString::null;
    }
  }


inline FXbool to_FXbool(VALUE obj){
  if (obj == Qtrue || obj == Qfalse){
    return (obj == Qtrue) ? TRUE : FALSE;
    }
  else{
    return static_cast<FXbool>(NUM2UINT(obj));
    }
  }


static swig_type_info* FXEventTypeInfo=0;

inline void* to_FXEvent(VALUE obj){
  void* ptr;
  if(!FXEventTypeInfo){
    FXEventTypeInfo=SWIG_TypeQuery("FXEvent *");
    FXASSERT(FXEventTypeInfo!=0);
    }
  SWIG_ConvertPtr(obj,&ptr,FXEventTypeInfo,1);
  return ptr;
  }

FXBitmap *new_FXBitmap(FXApp *a,void const *pix,FXuint opts,FXint w,FXint h){
      return new FXRbBitmap(a,pix,opts,w,h);
      }

swig_class cFXBitmap;
static void free_FXBitmap(FXBitmap *);
VALUE FXMemoryBuffer_getData(FXMemoryBuffer const *self){
      FXColor* data = self->getData();
      if (data) {
        FXuint size = self->getSize();
        VALUE ary = rb_ary_new2(size);
        for (int i = 0; i < size; i++)
          rb_ary_store(ary, i, UINT2NUM(data[i]));
        return ary;
        }
      else {
        return Qnil;
        }
      }
FXColor FXMemoryBuffer___getitem__(FXMemoryBuffer const *self,FXuint i){
      return self->getData()[i];
      }
FXColor FXMemoryBuffer___setitem__(FXMemoryBuffer *self,FXuint i,FXColor value){
      self->getData()[i] = value;
      return value;
      }

swig_class cFXMemoryBuffer;
static void free_FXMemoryBuffer(FXMemoryBuffer *);
FXImage *new_FXImage(FXApp *a,VALUE ary,FXuint opts,FXint w,FXint h){
      FXColor* pix=0;
      if(!NIL_P(ary)){
        Check_Type(ary,T_ARRAY);
        if(FXMALLOC(&pix,FXColor,RARRAY(ary)->len)){
          for(long i=0; i<RARRAY(ary)->len; i++){
            pix[i]=static_cast<FXColor>(NUM2UINT(rb_ary_entry(ary,i)));
	    }
          }
	  opts&=IMAGE_OWNED;
        }
      return new FXRbImage(a,pix,opts,w,h);
      }
FXMemoryBuffer *FXImage_getData(FXImage const *self){
      if(self->getData()){
        return new FXMemoryBuffer(self->getData(),self->getWidth()*self->getHeight());
	}
      else{
        return 0;
	}
      }

swig_class cFXImage;
static void free_FXImage(FXImage *);

static swig_type_info *FXImage_dynamic_cast(void **ptr) {
    FXImage **ppImage = reinterpret_cast<FXImage **>(ptr);
    FXBMPImage *pBMPImage=dynamic_cast<FXBMPImage*>(*ppImage);
    if(pBMPImage){
      *ptr=reinterpret_cast<void*>(pBMPImage);
      return SWIG_TypeQuery("FXBMPImage *");
      }
    FXGIFImage *pGIFImage=dynamic_cast<FXGIFImage*>(*ppImage);
    if(pGIFImage){
      *ptr=reinterpret_cast<void*>(pGIFImage);
      return SWIG_TypeQuery("FXGIFImage *");
      }
    FXICOImage *pICOImage=dynamic_cast<FXICOImage*>(*ppImage);
    if(pICOImage){
      *ptr=reinterpret_cast<void*>(pICOImage);
      return SWIG_TypeQuery("FXICOImage *");
      }
    FXIcon *pIcon=dynamic_cast<FXIcon*>(*ppImage);
    if(pIcon){
      *ptr=reinterpret_cast<void*>(pIcon);
      return SWIG_TypeQuery("FXIcon *");
      }
    FXJPGImage *pJPGImage=dynamic_cast<FXJPGImage*>(*ppImage);
    if(pJPGImage){
      *ptr=reinterpret_cast<void*>(pJPGImage);
      return SWIG_TypeQuery("FXJPGImage *");
      }
    FXPCXImage *pPCXImage=dynamic_cast<FXPCXImage*>(*ppImage);
    if(pPCXImage){
      *ptr=reinterpret_cast<void*>(pPCXImage);
      return SWIG_TypeQuery("FXPCXImage *");
      }
    FXPNGImage *pPNGImage=dynamic_cast<FXPNGImage*>(*ppImage);
    if(pPNGImage){
      *ptr=reinterpret_cast<void*>(pPNGImage);
      return SWIG_TypeQuery("FXPNGImage *");
      }
    FXPPMImage *pPPMImage=dynamic_cast<FXPPMImage*>(*ppImage);
    if(pPPMImage){
      *ptr=reinterpret_cast<void*>(pPPMImage);
      return SWIG_TypeQuery("FXPPMImage *");
      }
    FXRGBImage *pRGBImage=dynamic_cast<FXRGBImage*>(*ppImage);
    if(pRGBImage){
      *ptr=reinterpret_cast<void*>(pRGBImage);
      return SWIG_TypeQuery("FXRGBImage *");
      }
    FXTGAImage *pTGAImage=dynamic_cast<FXTGAImage*>(*ppImage);
    if(pTGAImage){
      *ptr=reinterpret_cast<void*>(pTGAImage);
      return SWIG_TypeQuery("FXTGAImage *");
      }
    FXTIFImage *pTIFImage=dynamic_cast<FXTIFImage*>(*ppImage);
    if(pTIFImage){
      *ptr=reinterpret_cast<void*>(pTIFImage);
      return SWIG_TypeQuery("FXTIFImage *");
      }
    FXXBMImage *pXBMImage=dynamic_cast<FXXBMImage*>(*ppImage);
    if(pXBMImage){
      *ptr=reinterpret_cast<void*>(pXBMImage);
      return SWIG_TypeQuery("FXXBMImage *");
      }
    FXXPMImage *pXPMImage=dynamic_cast<FXXPMImage*>(*ppImage);
    if(pXPMImage){
      *ptr=reinterpret_cast<void*>(pXPMImage);
      return SWIG_TypeQuery("FXXPMImage *");
      }
    return 0;
}

FXBMPImage *new_FXBMPImage(FXApp *a,void const *pix,FXuint opts,FXint w,FXint h){
      return new FXRbBMPImage(a,pix,opts,w,h);
      }

swig_class cFXBMPImage;
static void free_FXBMPImage(FXBMPImage *);
FXGIFImage *new_FXGIFImage(FXApp *a,void const *pix,FXuint opts,FXint w,FXint h){
      return new FXRbGIFImage(a,pix,opts,w,h);
      }

swig_class cFXGIFImage;
static void free_FXGIFImage(FXGIFImage *);
FXICOImage *new_FXICOImage(FXApp *a,void const *pix,FXuint opts,FXint w,FXint h){
      return new FXRbICOImage(a,pix,opts,w,h);
      }

swig_class cFXICOImage;
static void free_FXICOImage(FXICOImage *);
FXJPGImage *new_FXJPGImage(FXApp *a,void const *pix,FXuint opts,FXint w,FXint h){
      return new FXRbJPGImage(a,pix,opts,w,h);
      }

swig_class cFXJPGImage;
static void free_FXJPGImage(FXJPGImage *);

  /**
   * Load an JPEG (Joint Photographics Experts Group) file from a stream.
   * Upon successful return, the pixel array and size are returned.
   * If an error occurred, the pixel array is set to NULL.
   */
  VALUE fxloadJPG(FXStream& store){
    FXColor* data;
    FXint width,height,quality;
    if(fxloadJPG(store,data,width,height,quality)){
      VALUE ary=rb_ary_new();
      rb_ary_push(ary,FXRbMakeColorArray(data,width,height));
      FXFREE(&data);
      rb_ary_push(ary,to_ruby(width));
      rb_ary_push(ary,to_ruby(height));
      rb_ary_push(ary,to_ruby(quality));
      return ary;
      }
    else{
      return Qnil;
      }
    }

FXPCXImage *new_FXPCXImage(FXApp *a,void const *pix,FXuint opts,FXint w,FXint h){
      return new FXRbPCXImage(a,pix,opts,w,h);
      }

swig_class cFXPCXImage;
static void free_FXPCXImage(FXPCXImage *);
FXPNGImage *new_FXPNGImage(FXApp *a,void const *pix,FXuint opts,FXint w,FXint h){
      return new FXRbPNGImage(a,pix,opts,w,h);
      }

swig_class cFXPNGImage;
static void free_FXPNGImage(FXPNGImage *);
FXPPMImage *new_FXPPMImage(FXApp *a,void const *pix,FXuint opts,FXint w,FXint h){
      return new FXRbPPMImage(a,pix,opts,w,h);
      }

swig_class cFXPPMImage;
static void free_FXPPMImage(FXPPMImage *);
FXRGBImage *new_FXRGBImage(FXApp *a,void const *pix,FXuint opts,FXint w,FXint h){
      return new FXRbRGBImage(a,pix,opts,w,h);
      }

swig_class cFXRGBImage;
static void free_FXRGBImage(FXRGBImage *);

  /**
   * Load an RGB (SGI IRIS RGB) file from a stream.
   * Upon successful return, the pixel array and size are returned.
   * If an error occurred, the pixel array is set to NULL.
   */
  VALUE fxloadRGB(FXStream& store){
    FXColor* data;
    FXint width;
    FXint height;
    if(fxloadRGB(store,data,width,height)){
      VALUE ary=rb_ary_new();
      rb_ary_push(ary,FXRbMakeColorArray(data,width,height));
      FXFREE(&data);
      rb_ary_push(ary,to_ruby(width));
      rb_ary_push(ary,to_ruby(height));
      return ary;
      }
    else{
      return Qnil;
      }
    }

FXTGAImage *new_FXTGAImage(FXApp *a,void const *pix,FXuint opts,FXint w,FXint h){
      return new FXRbTGAImage(a,pix,opts,w,h);
      }

swig_class cFXTGAImage;
static void free_FXTGAImage(FXTGAImage *);

  /// Load a Targa Image from a stream
  VALUE fxloadTGA(FXStream& store){
    FXColor* data;
    FXint width;
    FXint height;
    if(fxloadTGA(store,data,width,height)){
      VALUE ary=rb_ary_new();
      rb_ary_push(ary,FXRbMakeColorArray(data,width,height));
      FXFREE(&data);
      rb_ary_push(ary,to_ruby(width));
      rb_ary_push(ary,to_ruby(height));
      return ary;
      }
    else{
      return Qnil;
      }
    }

FXTIFImage *new_FXTIFImage(FXApp *a,void const *pix,FXuint opts,FXint w,FXint h){
      return new FXRbTIFImage(a,pix,opts,w,h);
      }

swig_class cFXTIFImage;
static void free_FXTIFImage(FXTIFImage *);

  /// Load a tiff from a stream
  VALUE fxloadTIF(FXStream& store){
    FXColor* data;
    FXint width;
    FXint height;
    FXushort codec;
    if(fxloadTIF(store,data,width,height,codec)){
      VALUE ary=rb_ary_new();
      rb_ary_push(ary,FXRbMakeColorArray(data,width,height));
      FXFREE(&data);
      rb_ary_push(ary,to_ruby(width));
      rb_ary_push(ary,to_ruby(height));
      rb_ary_push(ary,to_ruby(codec));
      return ary;
      }
    else{
      return Qnil;
      }
    }

FXXBMImage *new_FXXBMImage(FXApp *a,FXuchar const *pixels,FXuchar const *mask,FXuint opts,FXint w,FXint h){
      return new FXRbXBMImage(a,pixels,mask,opts,w,h);
      }

swig_class cFXXBMImage;
static void free_FXXBMImage(FXXBMImage *);

  /**
   * Load an XBM (X Bitmap) from pixel array and mask array.
   * Upon successful return, the pixel array and size are returned.
   * If an error occurred, the pixel array is set to NULL.
   */
  VALUE fxloadXBM(const FXuchar *pix,const FXuchar *msk,FXint width,FXint height){
    FXColor* data;
    if(fxloadXBM(data,pix,msk,width,height)){
      VALUE obj=FXRbMakeColorArray(data,width,height);
      FXFREE(&data);
      return obj;
      }
    else{
      return Qnil;
      }
    }


  /**
   * Load an XBM (X Bitmap) file from a stream.
   * Upon successful return, the pixel array and size, and hot-spot are returned.
   * If an error occurred, the pixel array is set to NULL.
   */
  VALUE fxloadXBM(FXStream& store){
    FXColor* data;
    FXint width,height,hotx,hoty;
    if(fxloadXBM(store,data,width,height,hotx,hoty)){
      VALUE ary=rb_ary_new();
      rb_ary_push(ary,FXRbMakeColorArray(data,width,height));
      FXFREE(&data);
      rb_ary_push(ary,to_ruby(width));
      rb_ary_push(ary,to_ruby(height));
      rb_ary_push(ary,to_ruby(hotx));
      rb_ary_push(ary,to_ruby(hoty));
      return ary;
      }
    else{
      return Qnil;
      }
    }

FXXPMImage *new_FXXPMImage(FXApp *a,FXchar const **pix,FXuint opts,FXint w,FXint h){
      return new FXRbXPMImage(a,pix,opts,w,h);
      }

swig_class cFXXPMImage;
static void free_FXXPMImage(FXXPMImage *);
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE _wrap_FXBitmap_allocate(VALUE self) {
#else
     static VALUE _wrap_FXBitmap_allocate(int argc, VALUE *argv, VALUE self) {
#endif
         VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_FXBitmap);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
         return vresult; }
static VALUE _wrap_new_FXBitmap(int argc, VALUE *argv, VALUE self) { FXApp *arg1 = (FXApp *) 0 ; void *arg2 = (void *) 0 ;
    FXuint arg3 = (FXuint) 0 ; FXint arg4 = (FXint) 1 ; FXint arg5 = (FXint) 1 ; FXBitmap *result; if ((argc < 1) || (argc > 5))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXApp, 1); if (argc > 1) { { if (argv[1] != Qnil) {
                Check_Type(argv[1], T_STRING); arg2 = reinterpret_cast<void *>(RSTRING(argv[1])->ptr); }  else { arg2 = NULL; }
             }  }  if (argc > 2) { arg3 = NUM2UINT(argv[2]); }  if (argc > 3) { arg4 = NUM2INT(argv[3]); }  if (argc > 4) {
        arg5 = NUM2INT(argv[4]); }  { result = (FXBitmap *)new_FXBitmap(arg1,(void const *)arg2,arg3,arg4,arg5);
        DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result); if(rb_block_given_p()){ rb_yield(self); }  }  return self; }
static VALUE _wrap_FXBitmap_getData(int argc, VALUE *argv, VALUE self) { FXBitmap *arg1 = (FXBitmap *) 0 ; FXuchar *result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXBitmap, 1); result = (FXuchar *)((FXBitmap const *)arg1)->getData();
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_FXuchar,0); return vresult; }
static VALUE _wrap_FXBitmap_getOptions(int argc, VALUE *argv, VALUE self) { FXBitmap *arg1 = (FXBitmap *) 0 ; FXuint result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXBitmap, 1); result = (FXuint)((FXBitmap const *)arg1)->getOptions();
    vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXBitmap_setOptions(int argc, VALUE *argv, VALUE self) { FXBitmap *arg1 = (FXBitmap *) 0 ; FXuint arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXBitmap, 1); arg2 = NUM2UINT(argv[0]); (arg1)->setOptions(arg2);
    return Qnil; }
static VALUE _wrap_FXBitmap_getPixel(int argc, VALUE *argv, VALUE self) { FXBitmap *arg1 = (FXBitmap *) 0 ; FXint arg2 ;
    FXint arg3 ; FXbool result; VALUE vresult = Qnil; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXBitmap, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    result = (FXbool)((FXBitmap const *)arg1)->getPixel(arg2,arg3); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXBitmap_setPixel(int argc, VALUE *argv, VALUE self) { FXBitmap *arg1 = (FXBitmap *) 0 ; FXint arg2 ;
    FXint arg3 ; FXbool arg4 ; if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXBitmap, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    arg4 = to_FXbool(argv[2]); (arg1)->setPixel(arg2,arg3,arg4); return Qnil; }
static void
free_FXBitmap(FXBitmap *arg1) {
    delete arg1;
}
static VALUE _wrap_FXBitmap_save(int argc, VALUE *argv, VALUE self) { FXBitmap *arg1 = (FXBitmap *) 0 ; FXStream *arg2 = 0 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXBitmap, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXBitmap_save((FXBitmap const *)arg1,*arg2); return Qnil; }
static VALUE _wrap_FXBitmap_load(int argc, VALUE *argv, VALUE self) { FXBitmap *arg1 = (FXBitmap *) 0 ; FXStream *arg2 = 0 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXBitmap, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXBitmap_load(arg1,*arg2); return Qnil; }
static VALUE _wrap_FXBitmap_create(int argc, VALUE *argv, VALUE self) { FXBitmap *arg1 = (FXBitmap *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXBitmap, 1); FXBitmap_create(arg1); return Qnil; }
static VALUE _wrap_FXBitmap_detach(int argc, VALUE *argv, VALUE self) { FXBitmap *arg1 = (FXBitmap *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXBitmap, 1); FXBitmap_detach(arg1); return Qnil; }
static VALUE _wrap_FXBitmap_destroy(int argc, VALUE *argv, VALUE self) { FXBitmap *arg1 = (FXBitmap *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXBitmap, 1); FXBitmap_destroy(arg1); return Qnil; }
static VALUE _wrap_FXBitmap_resize(int argc, VALUE *argv, VALUE self) { FXBitmap *arg1 = (FXBitmap *) 0 ; FXint arg2 ;
    FXint arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXBitmap, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    FXBitmap_resize(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXBitmap_render(int argc, VALUE *argv, VALUE self) { FXBitmap *arg1 = (FXBitmap *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXBitmap, 1); FXBitmap_render(arg1); return Qnil; }
static VALUE _wrap_FXBitmap_release(int argc, VALUE *argv, VALUE self) { FXBitmap *arg1 = (FXBitmap *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXBitmap, 1); FXBitmap_release(arg1); return Qnil; }
static VALUE _wrap_FXBitmap_savePixels(int argc, VALUE *argv, VALUE self) { FXBitmap *arg1 = (FXBitmap *) 0 ;
    FXStream *arg2 = 0 ; FXbool result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXBitmap, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    result = (FXbool)FXBitmap_savePixels((FXBitmap const *)arg1,*arg2); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXBitmap_loadPixels(int argc, VALUE *argv, VALUE self) { FXBitmap *arg1 = (FXBitmap *) 0 ;
    FXStream *arg2 = 0 ; FXbool result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXBitmap, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    result = (FXbool)FXBitmap_loadPixels(arg1,*arg2); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXBitmap_scale(int argc, VALUE *argv, VALUE self) { FXBitmap *arg1 = (FXBitmap *) 0 ; FXint arg2 ;
    FXint arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXBitmap, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    FXBitmap_scale(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXBitmap_mirror(int argc, VALUE *argv, VALUE self) { FXBitmap *arg1 = (FXBitmap *) 0 ; FXbool arg2 ;
    FXbool arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXBitmap, 1); arg2 = to_FXbool(argv[0]); arg3 = to_FXbool(argv[1]);
    FXBitmap_mirror(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXBitmap_rotate(int argc, VALUE *argv, VALUE self) { FXBitmap *arg1 = (FXBitmap *) 0 ; FXint arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXBitmap, 1); arg2 = NUM2INT(argv[0]); FXBitmap_rotate(arg1,arg2);
    return Qnil; }
static VALUE _wrap_FXBitmap_crop(int argc, VALUE *argv, VALUE self) { FXBitmap *arg1 = (FXBitmap *) 0 ; FXint arg2 ;
    FXint arg3 ; FXint arg4 ; FXint arg5 ; if ((argc < 4) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXBitmap, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    arg4 = NUM2INT(argv[2]); arg5 = NUM2INT(argv[3]); FXBitmap_crop(arg1,arg2,arg3,arg4,arg5); return Qnil; }
static VALUE _wrap_FXBitmap_fill(int argc, VALUE *argv, VALUE self) { FXBitmap *arg1 = (FXBitmap *) 0 ; FXbool arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXBitmap, 1); arg2 = to_FXbool(argv[0]); FXBitmap_fill(arg1,arg2);
    return Qnil; }
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE _wrap_FXMemoryBuffer_allocate(VALUE self) {
#else
     static VALUE _wrap_FXMemoryBuffer_allocate(int argc, VALUE *argv, VALUE self) {
#endif
         VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_FXMemoryBuffer);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
         return vresult; }
static VALUE _wrap_new_FXMemoryBuffer(int argc, VALUE *argv, VALUE self) { FXColor *arg1 = (FXColor *) 0 ; FXuint arg2 ;
    FXMemoryBuffer *result; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc); {
        Check_Type(argv[0], T_ARRAY); FXMALLOC(&arg1,FXColor,RARRAY(argv[0])->len);
        arg2=static_cast<FXuint>(RARRAY(argv[0])->len); for(FXint i=0; i<arg2; i++){
            arg1[i]=static_cast<FXColor>(NUM2UINT(rb_ary_entry(argv[0],i))); }  } 
    result = (FXMemoryBuffer *)new FXMemoryBuffer(arg1,arg2); DATA_PTR(self) = result; { FXFREE(&arg1); }  return self; }
static VALUE _wrap_FXMemoryBuffer_getSize(int argc, VALUE *argv, VALUE self) { FXMemoryBuffer *arg1 = (FXMemoryBuffer *) 0 ;
    FXuint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMemoryBuffer, 1);
    result = (FXuint)((FXMemoryBuffer const *)arg1)->getSize(); vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXMemoryBuffer_getData(int argc, VALUE *argv, VALUE self) { FXMemoryBuffer *arg1 = (FXMemoryBuffer *) 0 ;
    VALUE result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMemoryBuffer, 1);
    result = (VALUE)FXMemoryBuffer_getData((FXMemoryBuffer const *)arg1); vresult = result; return vresult; }
static VALUE _wrap_FXMemoryBuffer___getitem__(int argc, VALUE *argv, VALUE self) { FXMemoryBuffer *arg1 = (FXMemoryBuffer *) 0 ;
    FXuint arg2 ; FXColor result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMemoryBuffer, 1); arg2 = NUM2UINT(argv[0]);
    result = (FXColor)FXMemoryBuffer___getitem__((FXMemoryBuffer const *)arg1,arg2); vresult = UINT2NUM(result);
    return vresult; }
static VALUE _wrap_FXMemoryBuffer___setitem__(int argc, VALUE *argv, VALUE self) { FXMemoryBuffer *arg1 = (FXMemoryBuffer *) 0 ;
    FXuint arg2 ; FXColor arg3 ; FXColor result; VALUE vresult = Qnil; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMemoryBuffer, 1); arg2 = NUM2UINT(argv[0]); arg3 = to_FXColor(argv[1]);
    result = (FXColor)FXMemoryBuffer___setitem__(arg1,arg2,arg3); vresult = UINT2NUM(result); return vresult; }
static void
free_FXMemoryBuffer(FXMemoryBuffer *arg1) {
    delete arg1;
}
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE _wrap_FXImage_allocate(VALUE self) {
#else
     static VALUE _wrap_FXImage_allocate(int argc, VALUE *argv, VALUE self) {
#endif
         VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_FXImage);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
         return vresult; }
static VALUE _wrap_new_FXImage(int argc, VALUE *argv, VALUE self) { FXApp *arg1 = (FXApp *) 0 ; VALUE arg2 = (VALUE) Qnil ;
    FXuint arg3 = (FXuint) 0 ; FXint arg4 = (FXint) 1 ; FXint arg5 = (FXint) 1 ; FXImage *result; if ((argc < 1) || (argc > 5))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXApp, 1); if (argc > 1) { arg2 = argv[1]; }  if (argc > 2) {
        arg3 = NUM2UINT(argv[2]); }  if (argc > 3) { arg4 = NUM2INT(argv[3]); }  if (argc > 4) { arg5 = NUM2INT(argv[4]); }  {
        result = (FXImage *)new_FXImage(arg1,arg2,arg3,arg4,arg5); DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result);
        if(rb_block_given_p()){ rb_yield(self); }  }  return self; }
static VALUE _wrap_FXImage_getData(int argc, VALUE *argv, VALUE self) { FXImage *arg1 = (FXImage *) 0 ; FXMemoryBuffer *result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXImage, 1);
    result = (FXMemoryBuffer *)FXImage_getData((FXImage const *)arg1);
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_FXMemoryBuffer,0); return vresult; }
static VALUE _wrap_FXImage_getOptions(int argc, VALUE *argv, VALUE self) { FXImage *arg1 = (FXImage *) 0 ; FXuint result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXImage, 1); result = (FXuint)((FXImage const *)arg1)->getOptions();
    vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXImage_setOptions(int argc, VALUE *argv, VALUE self) { FXImage *arg1 = (FXImage *) 0 ; FXuint arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXImage, 1); arg2 = NUM2UINT(argv[0]); (arg1)->setOptions(arg2);
    return Qnil; }
static VALUE _wrap_FXImage_getPixel(int argc, VALUE *argv, VALUE self) { FXImage *arg1 = (FXImage *) 0 ; FXint arg2 ;
    FXint arg3 ; FXColor result; VALUE vresult = Qnil; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXImage, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    result = (FXColor)((FXImage const *)arg1)->getPixel(arg2,arg3); vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXImage_setPixel(int argc, VALUE *argv, VALUE self) { FXImage *arg1 = (FXImage *) 0 ; FXint arg2 ;
    FXint arg3 ; FXColor arg4 ; if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXImage, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    arg4 = to_FXColor(argv[2]); (arg1)->setPixel(arg2,arg3,arg4); return Qnil; }
static VALUE _wrap_FXImage_hasAlphaq___(int argc, VALUE *argv, VALUE self) { FXImage *arg1 = (FXImage *) 0 ; FXbool result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXImage, 1); result = (FXbool)((FXImage const *)arg1)->hasAlpha();
    vresult = result ? Qtrue : Qfalse; return vresult; }
static void
free_FXImage(FXImage *arg1) {
    delete arg1;
}
static VALUE _wrap_FXImage_save(int argc, VALUE *argv, VALUE self) { FXImage *arg1 = (FXImage *) 0 ; FXStream *arg2 = 0 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXImage, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXImage_save((FXImage const *)arg1,*arg2); return Qnil; }
static VALUE _wrap_FXImage_load(int argc, VALUE *argv, VALUE self) { FXImage *arg1 = (FXImage *) 0 ; FXStream *arg2 = 0 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXImage, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXImage_load(arg1,*arg2); return Qnil; }
static VALUE _wrap_FXImage_create(int argc, VALUE *argv, VALUE self) { FXImage *arg1 = (FXImage *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXImage, 1); FXImage_create(arg1); return Qnil; }
static VALUE _wrap_FXImage_detach(int argc, VALUE *argv, VALUE self) { FXImage *arg1 = (FXImage *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXImage, 1); FXImage_detach(arg1); return Qnil; }
static VALUE _wrap_FXImage_destroy(int argc, VALUE *argv, VALUE self) { FXImage *arg1 = (FXImage *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXImage, 1); FXImage_destroy(arg1); return Qnil; }
static VALUE _wrap_FXImage_resize(int argc, VALUE *argv, VALUE self) { FXImage *arg1 = (FXImage *) 0 ; FXint arg2 ; FXint arg3 ;
    if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXImage, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    FXImage_resize(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXImage_restore(int argc, VALUE *argv, VALUE self) { FXImage *arg1 = (FXImage *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXImage, 1); FXImage_restore(arg1); return Qnil; }
static VALUE _wrap_FXImage_render(int argc, VALUE *argv, VALUE self) { FXImage *arg1 = (FXImage *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXImage, 1); FXImage_render(arg1); return Qnil; }
static VALUE _wrap_FXImage_release(int argc, VALUE *argv, VALUE self) { FXImage *arg1 = (FXImage *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXImage, 1); FXImage_release(arg1); return Qnil; }
static VALUE _wrap_FXImage_scale(int argc, VALUE *argv, VALUE self) { FXImage *arg1 = (FXImage *) 0 ; FXint arg2 ; FXint arg3 ;
    FXint arg4 = (FXint) 0 ; if ((argc < 2) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXImage, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    if (argc > 2) { arg4 = NUM2INT(argv[2]); }  FXImage_scale(arg1,arg2,arg3,arg4); return Qnil; }
static VALUE _wrap_FXImage_mirror(int argc, VALUE *argv, VALUE self) { FXImage *arg1 = (FXImage *) 0 ; FXbool arg2 ;
    FXbool arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXImage, 1); arg2 = to_FXbool(argv[0]); arg3 = to_FXbool(argv[1]);
    FXImage_mirror(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXImage_rotate(int argc, VALUE *argv, VALUE self) { FXImage *arg1 = (FXImage *) 0 ; FXint arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXImage, 1); arg2 = NUM2INT(argv[0]); FXImage_rotate(arg1,arg2);
    return Qnil; }
static VALUE _wrap_FXImage_crop(int argc, VALUE *argv, VALUE self) { FXImage *arg1 = (FXImage *) 0 ; FXint arg2 ; FXint arg3 ;
    FXint arg4 ; FXint arg5 ; if ((argc < 4) || (argc > 4)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXImage, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    arg4 = NUM2INT(argv[2]); arg5 = NUM2INT(argv[3]); FXImage_crop(arg1,arg2,arg3,arg4,arg5); return Qnil; }
static VALUE _wrap_FXImage_fill(int argc, VALUE *argv, VALUE self) { FXImage *arg1 = (FXImage *) 0 ; FXColor arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXImage, 1); arg2 = to_FXColor(argv[0]); FXImage_fill(arg1,arg2);
    return Qnil; }
static VALUE _wrap_FXImage_fade(int argc, VALUE *argv, VALUE self) { FXImage *arg1 = (FXImage *) 0 ; FXColor arg2 ;
    FXint arg3 = (FXint) 255 ; if ((argc < 1) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXImage, 1); arg2 = to_FXColor(argv[0]); if (argc > 1) {
        arg3 = NUM2INT(argv[1]); }  FXImage_fade(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXImage_xshear(int argc, VALUE *argv, VALUE self) { FXImage *arg1 = (FXImage *) 0 ; FXint arg2 ;
    FXColor arg3 = (FXColor) 0 ; if ((argc < 1) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXImage, 1); arg2 = NUM2INT(argv[0]); if (argc > 1) {
        arg3 = to_FXColor(argv[1]); }  FXImage_xshear(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXImage_yshear(int argc, VALUE *argv, VALUE self) { FXImage *arg1 = (FXImage *) 0 ; FXint arg2 ;
    FXColor arg3 = (FXColor) 0 ; if ((argc < 1) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXImage, 1); arg2 = NUM2INT(argv[0]); if (argc > 1) {
        arg3 = to_FXColor(argv[1]); }  FXImage_yshear(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXImage_hgradient(int argc, VALUE *argv, VALUE self) { FXImage *arg1 = (FXImage *) 0 ; FXColor arg2 ;
    FXColor arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXImage, 1); arg2 = to_FXColor(argv[0]); arg3 = to_FXColor(argv[1]);
    FXImage_hgradient(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXImage_vgradient(int argc, VALUE *argv, VALUE self) { FXImage *arg1 = (FXImage *) 0 ; FXColor arg2 ;
    FXColor arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXImage, 1); arg2 = to_FXColor(argv[0]); arg3 = to_FXColor(argv[1]);
    FXImage_vgradient(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXImage_gradient(int argc, VALUE *argv, VALUE self) { FXImage *arg1 = (FXImage *) 0 ; FXColor arg2 ;
    FXColor arg3 ; FXColor arg4 ; FXColor arg5 ; if ((argc < 4) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXImage, 1); arg2 = to_FXColor(argv[0]); arg3 = to_FXColor(argv[1]);
    arg4 = to_FXColor(argv[2]); arg5 = to_FXColor(argv[3]); FXImage_gradient(arg1,arg2,arg3,arg4,arg5); return Qnil; }
static VALUE _wrap_FXImage_blend(int argc, VALUE *argv, VALUE self) { FXImage *arg1 = (FXImage *) 0 ; FXColor arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXImage, 1); arg2 = to_FXColor(argv[0]); FXImage_blend(arg1,arg2);
    return Qnil; }
static VALUE _wrap_FXImage_savePixels(int argc, VALUE *argv, VALUE self) { FXImage *arg1 = (FXImage *) 0 ; FXStream *arg2 = 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXImage, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    result = (FXbool)FXImage_savePixels((FXImage const *)arg1,*arg2); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXImage_loadPixels(int argc, VALUE *argv, VALUE self) { FXImage *arg1 = (FXImage *) 0 ; FXStream *arg2 = 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXImage, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    result = (FXbool)FXImage_loadPixels(arg1,*arg2); vresult = result ? Qtrue : Qfalse; return vresult; }
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE _wrap_FXBMPImage_allocate(VALUE self) {
#else
     static VALUE _wrap_FXBMPImage_allocate(int argc, VALUE *argv, VALUE self) {
#endif
         VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_FXBMPImage);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
         return vresult; }
static VALUE _wrap_new_FXBMPImage(int argc, VALUE *argv, VALUE self) { FXApp *arg1 = (FXApp *) 0 ; void *arg2 = (void *) 0 ;
    FXuint arg3 = (FXuint) 0 ; FXint arg4 = (FXint) 1 ; FXint arg5 = (FXint) 1 ; FXBMPImage *result;
    if ((argc < 1) || (argc > 5)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXApp, 1); if (argc > 1) { { if (argv[1] != Qnil) {
                Check_Type(argv[1], T_STRING); arg2 = reinterpret_cast<void *>(RSTRING(argv[1])->ptr); }  else { arg2 = NULL; }
             }  }  if (argc > 2) { arg3 = NUM2UINT(argv[2]); }  if (argc > 3) { arg4 = NUM2INT(argv[3]); }  if (argc > 4) {
        arg5 = NUM2INT(argv[4]); }  { result = (FXBMPImage *)new_FXBMPImage(arg1,(void const *)arg2,arg3,arg4,arg5);
        DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result); if(rb_block_given_p()){ rb_yield(self); }  }  return self; }
static void
free_FXBMPImage(FXBMPImage *arg1) {
    delete arg1;
}
static VALUE _wrap_FXBMPImage_save(int argc, VALUE *argv, VALUE self) { FXBMPImage *arg1 = (FXBMPImage *) 0 ;
    FXStream *arg2 = 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXBMPImage, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXBMPImage_save((FXBMPImage const *)arg1,*arg2); return Qnil; }
static VALUE _wrap_FXBMPImage_load(int argc, VALUE *argv, VALUE self) { FXBMPImage *arg1 = (FXBMPImage *) 0 ;
    FXStream *arg2 = 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXBMPImage, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXBMPImage_load(arg1,*arg2); return Qnil; }
static VALUE _wrap_FXBMPImage_create(int argc, VALUE *argv, VALUE self) { FXBMPImage *arg1 = (FXBMPImage *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXBMPImage, 1); FXBMPImage_create(arg1); return Qnil; }
static VALUE _wrap_FXBMPImage_detach(int argc, VALUE *argv, VALUE self) { FXBMPImage *arg1 = (FXBMPImage *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXBMPImage, 1); FXBMPImage_detach(arg1); return Qnil; }
static VALUE _wrap_FXBMPImage_destroy(int argc, VALUE *argv, VALUE self) { FXBMPImage *arg1 = (FXBMPImage *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXBMPImage, 1); FXBMPImage_destroy(arg1); return Qnil; }
static VALUE _wrap_FXBMPImage_resize(int argc, VALUE *argv, VALUE self) { FXBMPImage *arg1 = (FXBMPImage *) 0 ; FXint arg2 ;
    FXint arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXBMPImage, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    FXBMPImage_resize(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXBMPImage_restore(int argc, VALUE *argv, VALUE self) { FXBMPImage *arg1 = (FXBMPImage *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXBMPImage, 1); FXBMPImage_restore(arg1); return Qnil; }
static VALUE _wrap_FXBMPImage_render(int argc, VALUE *argv, VALUE self) { FXBMPImage *arg1 = (FXBMPImage *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXBMPImage, 1); FXBMPImage_render(arg1); return Qnil; }
static VALUE _wrap_FXBMPImage_release(int argc, VALUE *argv, VALUE self) { FXBMPImage *arg1 = (FXBMPImage *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXBMPImage, 1); FXBMPImage_release(arg1); return Qnil; }
static VALUE _wrap_FXBMPImage_scale(int argc, VALUE *argv, VALUE self) { FXBMPImage *arg1 = (FXBMPImage *) 0 ; FXint arg2 ;
    FXint arg3 ; FXint arg4 = (FXint) 0 ; if ((argc < 2) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXBMPImage, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    if (argc > 2) { arg4 = NUM2INT(argv[2]); }  FXBMPImage_scale(arg1,arg2,arg3,arg4); return Qnil; }
static VALUE _wrap_FXBMPImage_mirror(int argc, VALUE *argv, VALUE self) { FXBMPImage *arg1 = (FXBMPImage *) 0 ; FXbool arg2 ;
    FXbool arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXBMPImage, 1); arg2 = to_FXbool(argv[0]); arg3 = to_FXbool(argv[1]);
    FXBMPImage_mirror(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXBMPImage_rotate(int argc, VALUE *argv, VALUE self) { FXBMPImage *arg1 = (FXBMPImage *) 0 ; FXint arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXBMPImage, 1); arg2 = NUM2INT(argv[0]); FXBMPImage_rotate(arg1,arg2);
    return Qnil; }
static VALUE _wrap_FXBMPImage_crop(int argc, VALUE *argv, VALUE self) { FXBMPImage *arg1 = (FXBMPImage *) 0 ; FXint arg2 ;
    FXint arg3 ; FXint arg4 ; FXint arg5 ; if ((argc < 4) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXBMPImage, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    arg4 = NUM2INT(argv[2]); arg5 = NUM2INT(argv[3]); FXBMPImage_crop(arg1,arg2,arg3,arg4,arg5); return Qnil; }
static VALUE _wrap_FXBMPImage_fill(int argc, VALUE *argv, VALUE self) { FXBMPImage *arg1 = (FXBMPImage *) 0 ; FXColor arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXBMPImage, 1); arg2 = to_FXColor(argv[0]); FXBMPImage_fill(arg1,arg2);
    return Qnil; }
static VALUE _wrap_FXBMPImage_fade(int argc, VALUE *argv, VALUE self) { FXBMPImage *arg1 = (FXBMPImage *) 0 ; FXColor arg2 ;
    FXint arg3 = (FXint) 255 ; if ((argc < 1) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXBMPImage, 1); arg2 = to_FXColor(argv[0]); if (argc > 1) {
        arg3 = NUM2INT(argv[1]); }  FXBMPImage_fade(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXBMPImage_xshear(int argc, VALUE *argv, VALUE self) { FXBMPImage *arg1 = (FXBMPImage *) 0 ; FXint arg2 ;
    FXColor arg3 = (FXColor) 0 ; if ((argc < 1) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXBMPImage, 1); arg2 = NUM2INT(argv[0]); if (argc > 1) {
        arg3 = to_FXColor(argv[1]); }  FXBMPImage_xshear(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXBMPImage_yshear(int argc, VALUE *argv, VALUE self) { FXBMPImage *arg1 = (FXBMPImage *) 0 ; FXint arg2 ;
    FXColor arg3 = (FXColor) 0 ; if ((argc < 1) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXBMPImage, 1); arg2 = NUM2INT(argv[0]); if (argc > 1) {
        arg3 = to_FXColor(argv[1]); }  FXBMPImage_yshear(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXBMPImage_hgradient(int argc, VALUE *argv, VALUE self) { FXBMPImage *arg1 = (FXBMPImage *) 0 ;
    FXColor arg2 ; FXColor arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXBMPImage, 1); arg2 = to_FXColor(argv[0]); arg3 = to_FXColor(argv[1]);
    FXBMPImage_hgradient(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXBMPImage_vgradient(int argc, VALUE *argv, VALUE self) { FXBMPImage *arg1 = (FXBMPImage *) 0 ;
    FXColor arg2 ; FXColor arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXBMPImage, 1); arg2 = to_FXColor(argv[0]); arg3 = to_FXColor(argv[1]);
    FXBMPImage_vgradient(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXBMPImage_gradient(int argc, VALUE *argv, VALUE self) { FXBMPImage *arg1 = (FXBMPImage *) 0 ; FXColor arg2 ;
    FXColor arg3 ; FXColor arg4 ; FXColor arg5 ; if ((argc < 4) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXBMPImage, 1); arg2 = to_FXColor(argv[0]); arg3 = to_FXColor(argv[1]);
    arg4 = to_FXColor(argv[2]); arg5 = to_FXColor(argv[3]); FXBMPImage_gradient(arg1,arg2,arg3,arg4,arg5); return Qnil; }
static VALUE _wrap_FXBMPImage_blend(int argc, VALUE *argv, VALUE self) { FXBMPImage *arg1 = (FXBMPImage *) 0 ; FXColor arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXBMPImage, 1); arg2 = to_FXColor(argv[0]); FXBMPImage_blend(arg1,arg2);
    return Qnil; }
static VALUE _wrap_FXBMPImage_savePixels(int argc, VALUE *argv, VALUE self) { FXBMPImage *arg1 = (FXBMPImage *) 0 ;
    FXStream *arg2 = 0 ; FXbool result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXBMPImage, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    result = (FXbool)FXBMPImage_savePixels((FXBMPImage const *)arg1,*arg2); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXBMPImage_loadPixels(int argc, VALUE *argv, VALUE self) { FXBMPImage *arg1 = (FXBMPImage *) 0 ;
    FXStream *arg2 = 0 ; FXbool result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXBMPImage, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    result = (FXbool)FXBMPImage_loadPixels(arg1,*arg2); vresult = result ? Qtrue : Qfalse; return vresult; }
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE _wrap_FXGIFImage_allocate(VALUE self) {
#else
     static VALUE _wrap_FXGIFImage_allocate(int argc, VALUE *argv, VALUE self) {
#endif
         VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_FXGIFImage);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
         return vresult; }
static VALUE _wrap_new_FXGIFImage(int argc, VALUE *argv, VALUE self) { FXApp *arg1 = (FXApp *) 0 ; void *arg2 = (void *) 0 ;
    FXuint arg3 = (FXuint) 0 ; FXint arg4 = (FXint) 1 ; FXint arg5 = (FXint) 1 ; FXGIFImage *result;
    if ((argc < 1) || (argc > 5)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXApp, 1); if (argc > 1) { { if (argv[1] != Qnil) {
                Check_Type(argv[1], T_STRING); arg2 = reinterpret_cast<void *>(RSTRING(argv[1])->ptr); }  else { arg2 = NULL; }
             }  }  if (argc > 2) { arg3 = NUM2UINT(argv[2]); }  if (argc > 3) { arg4 = NUM2INT(argv[3]); }  if (argc > 4) {
        arg5 = NUM2INT(argv[4]); }  { result = (FXGIFImage *)new_FXGIFImage(arg1,(void const *)arg2,arg3,arg4,arg5);
        DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result); if(rb_block_given_p()){ rb_yield(self); }  }  return self; }
static void
free_FXGIFImage(FXGIFImage *arg1) {
    delete arg1;
}
static VALUE _wrap_FXGIFImage_save(int argc, VALUE *argv, VALUE self) { FXGIFImage *arg1 = (FXGIFImage *) 0 ;
    FXStream *arg2 = 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGIFImage, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXGIFImage_save((FXGIFImage const *)arg1,*arg2); return Qnil; }
static VALUE _wrap_FXGIFImage_load(int argc, VALUE *argv, VALUE self) { FXGIFImage *arg1 = (FXGIFImage *) 0 ;
    FXStream *arg2 = 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGIFImage, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXGIFImage_load(arg1,*arg2); return Qnil; }
static VALUE _wrap_FXGIFImage_create(int argc, VALUE *argv, VALUE self) { FXGIFImage *arg1 = (FXGIFImage *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGIFImage, 1); FXGIFImage_create(arg1); return Qnil; }
static VALUE _wrap_FXGIFImage_detach(int argc, VALUE *argv, VALUE self) { FXGIFImage *arg1 = (FXGIFImage *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGIFImage, 1); FXGIFImage_detach(arg1); return Qnil; }
static VALUE _wrap_FXGIFImage_destroy(int argc, VALUE *argv, VALUE self) { FXGIFImage *arg1 = (FXGIFImage *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGIFImage, 1); FXGIFImage_destroy(arg1); return Qnil; }
static VALUE _wrap_FXGIFImage_resize(int argc, VALUE *argv, VALUE self) { FXGIFImage *arg1 = (FXGIFImage *) 0 ; FXint arg2 ;
    FXint arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGIFImage, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    FXGIFImage_resize(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXGIFImage_restore(int argc, VALUE *argv, VALUE self) { FXGIFImage *arg1 = (FXGIFImage *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGIFImage, 1); FXGIFImage_restore(arg1); return Qnil; }
static VALUE _wrap_FXGIFImage_render(int argc, VALUE *argv, VALUE self) { FXGIFImage *arg1 = (FXGIFImage *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGIFImage, 1); FXGIFImage_render(arg1); return Qnil; }
static VALUE _wrap_FXGIFImage_release(int argc, VALUE *argv, VALUE self) { FXGIFImage *arg1 = (FXGIFImage *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGIFImage, 1); FXGIFImage_release(arg1); return Qnil; }
static VALUE _wrap_FXGIFImage_scale(int argc, VALUE *argv, VALUE self) { FXGIFImage *arg1 = (FXGIFImage *) 0 ; FXint arg2 ;
    FXint arg3 ; FXint arg4 = (FXint) 0 ; if ((argc < 2) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGIFImage, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    if (argc > 2) { arg4 = NUM2INT(argv[2]); }  FXGIFImage_scale(arg1,arg2,arg3,arg4); return Qnil; }
static VALUE _wrap_FXGIFImage_mirror(int argc, VALUE *argv, VALUE self) { FXGIFImage *arg1 = (FXGIFImage *) 0 ; FXbool arg2 ;
    FXbool arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGIFImage, 1); arg2 = to_FXbool(argv[0]); arg3 = to_FXbool(argv[1]);
    FXGIFImage_mirror(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXGIFImage_rotate(int argc, VALUE *argv, VALUE self) { FXGIFImage *arg1 = (FXGIFImage *) 0 ; FXint arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGIFImage, 1); arg2 = NUM2INT(argv[0]); FXGIFImage_rotate(arg1,arg2);
    return Qnil; }
static VALUE _wrap_FXGIFImage_crop(int argc, VALUE *argv, VALUE self) { FXGIFImage *arg1 = (FXGIFImage *) 0 ; FXint arg2 ;
    FXint arg3 ; FXint arg4 ; FXint arg5 ; if ((argc < 4) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGIFImage, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    arg4 = NUM2INT(argv[2]); arg5 = NUM2INT(argv[3]); FXGIFImage_crop(arg1,arg2,arg3,arg4,arg5); return Qnil; }
static VALUE _wrap_FXGIFImage_fill(int argc, VALUE *argv, VALUE self) { FXGIFImage *arg1 = (FXGIFImage *) 0 ; FXColor arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGIFImage, 1); arg2 = to_FXColor(argv[0]); FXGIFImage_fill(arg1,arg2);
    return Qnil; }
static VALUE _wrap_FXGIFImage_fade(int argc, VALUE *argv, VALUE self) { FXGIFImage *arg1 = (FXGIFImage *) 0 ; FXColor arg2 ;
    FXint arg3 = (FXint) 255 ; if ((argc < 1) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGIFImage, 1); arg2 = to_FXColor(argv[0]); if (argc > 1) {
        arg3 = NUM2INT(argv[1]); }  FXGIFImage_fade(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXGIFImage_xshear(int argc, VALUE *argv, VALUE self) { FXGIFImage *arg1 = (FXGIFImage *) 0 ; FXint arg2 ;
    FXColor arg3 = (FXColor) 0 ; if ((argc < 1) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGIFImage, 1); arg2 = NUM2INT(argv[0]); if (argc > 1) {
        arg3 = to_FXColor(argv[1]); }  FXGIFImage_xshear(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXGIFImage_yshear(int argc, VALUE *argv, VALUE self) { FXGIFImage *arg1 = (FXGIFImage *) 0 ; FXint arg2 ;
    FXColor arg3 = (FXColor) 0 ; if ((argc < 1) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGIFImage, 1); arg2 = NUM2INT(argv[0]); if (argc > 1) {
        arg3 = to_FXColor(argv[1]); }  FXGIFImage_yshear(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXGIFImage_hgradient(int argc, VALUE *argv, VALUE self) { FXGIFImage *arg1 = (FXGIFImage *) 0 ;
    FXColor arg2 ; FXColor arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGIFImage, 1); arg2 = to_FXColor(argv[0]); arg3 = to_FXColor(argv[1]);
    FXGIFImage_hgradient(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXGIFImage_vgradient(int argc, VALUE *argv, VALUE self) { FXGIFImage *arg1 = (FXGIFImage *) 0 ;
    FXColor arg2 ; FXColor arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGIFImage, 1); arg2 = to_FXColor(argv[0]); arg3 = to_FXColor(argv[1]);
    FXGIFImage_vgradient(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXGIFImage_gradient(int argc, VALUE *argv, VALUE self) { FXGIFImage *arg1 = (FXGIFImage *) 0 ; FXColor arg2 ;
    FXColor arg3 ; FXColor arg4 ; FXColor arg5 ; if ((argc < 4) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGIFImage, 1); arg2 = to_FXColor(argv[0]); arg3 = to_FXColor(argv[1]);
    arg4 = to_FXColor(argv[2]); arg5 = to_FXColor(argv[3]); FXGIFImage_gradient(arg1,arg2,arg3,arg4,arg5); return Qnil; }
static VALUE _wrap_FXGIFImage_blend(int argc, VALUE *argv, VALUE self) { FXGIFImage *arg1 = (FXGIFImage *) 0 ; FXColor arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGIFImage, 1); arg2 = to_FXColor(argv[0]); FXGIFImage_blend(arg1,arg2);
    return Qnil; }
static VALUE _wrap_FXGIFImage_savePixels(int argc, VALUE *argv, VALUE self) { FXGIFImage *arg1 = (FXGIFImage *) 0 ;
    FXStream *arg2 = 0 ; FXbool result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGIFImage, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    result = (FXbool)FXGIFImage_savePixels((FXGIFImage const *)arg1,*arg2); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXGIFImage_loadPixels(int argc, VALUE *argv, VALUE self) { FXGIFImage *arg1 = (FXGIFImage *) 0 ;
    FXStream *arg2 = 0 ; FXbool result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGIFImage, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    result = (FXbool)FXGIFImage_loadPixels(arg1,*arg2); vresult = result ? Qtrue : Qfalse; return vresult; }
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE _wrap_FXICOImage_allocate(VALUE self) {
#else
     static VALUE _wrap_FXICOImage_allocate(int argc, VALUE *argv, VALUE self) {
#endif
         VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_FXICOImage);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
         return vresult; }
static VALUE _wrap_new_FXICOImage(int argc, VALUE *argv, VALUE self) { FXApp *arg1 = (FXApp *) 0 ; void *arg2 = (void *) 0 ;
    FXuint arg3 = (FXuint) 0 ; FXint arg4 = (FXint) 1 ; FXint arg5 = (FXint) 1 ; FXICOImage *result;
    if ((argc < 1) || (argc > 5)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXApp, 1); if (argc > 1) { { if (argv[1] != Qnil) {
                Check_Type(argv[1], T_STRING); arg2 = reinterpret_cast<void *>(RSTRING(argv[1])->ptr); }  else { arg2 = NULL; }
             }  }  if (argc > 2) { arg3 = NUM2UINT(argv[2]); }  if (argc > 3) { arg4 = NUM2INT(argv[3]); }  if (argc > 4) {
        arg5 = NUM2INT(argv[4]); }  { result = (FXICOImage *)new_FXICOImage(arg1,(void const *)arg2,arg3,arg4,arg5);
        DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result); if(rb_block_given_p()){ rb_yield(self); }  }  return self; }
static void
free_FXICOImage(FXICOImage *arg1) {
    delete arg1;
}
static VALUE _wrap_FXICOImage_save(int argc, VALUE *argv, VALUE self) { FXICOImage *arg1 = (FXICOImage *) 0 ;
    FXStream *arg2 = 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXICOImage, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXICOImage_save((FXICOImage const *)arg1,*arg2); return Qnil; }
static VALUE _wrap_FXICOImage_load(int argc, VALUE *argv, VALUE self) { FXICOImage *arg1 = (FXICOImage *) 0 ;
    FXStream *arg2 = 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXICOImage, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXICOImage_load(arg1,*arg2); return Qnil; }
static VALUE _wrap_FXICOImage_create(int argc, VALUE *argv, VALUE self) { FXICOImage *arg1 = (FXICOImage *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXICOImage, 1); FXICOImage_create(arg1); return Qnil; }
static VALUE _wrap_FXICOImage_detach(int argc, VALUE *argv, VALUE self) { FXICOImage *arg1 = (FXICOImage *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXICOImage, 1); FXICOImage_detach(arg1); return Qnil; }
static VALUE _wrap_FXICOImage_destroy(int argc, VALUE *argv, VALUE self) { FXICOImage *arg1 = (FXICOImage *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXICOImage, 1); FXICOImage_destroy(arg1); return Qnil; }
static VALUE _wrap_FXICOImage_resize(int argc, VALUE *argv, VALUE self) { FXICOImage *arg1 = (FXICOImage *) 0 ; FXint arg2 ;
    FXint arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXICOImage, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    FXICOImage_resize(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXICOImage_restore(int argc, VALUE *argv, VALUE self) { FXICOImage *arg1 = (FXICOImage *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXICOImage, 1); FXICOImage_restore(arg1); return Qnil; }
static VALUE _wrap_FXICOImage_render(int argc, VALUE *argv, VALUE self) { FXICOImage *arg1 = (FXICOImage *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXICOImage, 1); FXICOImage_render(arg1); return Qnil; }
static VALUE _wrap_FXICOImage_release(int argc, VALUE *argv, VALUE self) { FXICOImage *arg1 = (FXICOImage *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXICOImage, 1); FXICOImage_release(arg1); return Qnil; }
static VALUE _wrap_FXICOImage_scale(int argc, VALUE *argv, VALUE self) { FXICOImage *arg1 = (FXICOImage *) 0 ; FXint arg2 ;
    FXint arg3 ; FXint arg4 = (FXint) 0 ; if ((argc < 2) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXICOImage, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    if (argc > 2) { arg4 = NUM2INT(argv[2]); }  FXICOImage_scale(arg1,arg2,arg3,arg4); return Qnil; }
static VALUE _wrap_FXICOImage_mirror(int argc, VALUE *argv, VALUE self) { FXICOImage *arg1 = (FXICOImage *) 0 ; FXbool arg2 ;
    FXbool arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXICOImage, 1); arg2 = to_FXbool(argv[0]); arg3 = to_FXbool(argv[1]);
    FXICOImage_mirror(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXICOImage_rotate(int argc, VALUE *argv, VALUE self) { FXICOImage *arg1 = (FXICOImage *) 0 ; FXint arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXICOImage, 1); arg2 = NUM2INT(argv[0]); FXICOImage_rotate(arg1,arg2);
    return Qnil; }
static VALUE _wrap_FXICOImage_crop(int argc, VALUE *argv, VALUE self) { FXICOImage *arg1 = (FXICOImage *) 0 ; FXint arg2 ;
    FXint arg3 ; FXint arg4 ; FXint arg5 ; if ((argc < 4) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXICOImage, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    arg4 = NUM2INT(argv[2]); arg5 = NUM2INT(argv[3]); FXICOImage_crop(arg1,arg2,arg3,arg4,arg5); return Qnil; }
static VALUE _wrap_FXICOImage_fill(int argc, VALUE *argv, VALUE self) { FXICOImage *arg1 = (FXICOImage *) 0 ; FXColor arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXICOImage, 1); arg2 = to_FXColor(argv[0]); FXICOImage_fill(arg1,arg2);
    return Qnil; }
static VALUE _wrap_FXICOImage_fade(int argc, VALUE *argv, VALUE self) { FXICOImage *arg1 = (FXICOImage *) 0 ; FXColor arg2 ;
    FXint arg3 = (FXint) 255 ; if ((argc < 1) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXICOImage, 1); arg2 = to_FXColor(argv[0]); if (argc > 1) {
        arg3 = NUM2INT(argv[1]); }  FXICOImage_fade(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXICOImage_xshear(int argc, VALUE *argv, VALUE self) { FXICOImage *arg1 = (FXICOImage *) 0 ; FXint arg2 ;
    FXColor arg3 = (FXColor) 0 ; if ((argc < 1) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXICOImage, 1); arg2 = NUM2INT(argv[0]); if (argc > 1) {
        arg3 = to_FXColor(argv[1]); }  FXICOImage_xshear(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXICOImage_yshear(int argc, VALUE *argv, VALUE self) { FXICOImage *arg1 = (FXICOImage *) 0 ; FXint arg2 ;
    FXColor arg3 = (FXColor) 0 ; if ((argc < 1) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXICOImage, 1); arg2 = NUM2INT(argv[0]); if (argc > 1) {
        arg3 = to_FXColor(argv[1]); }  FXICOImage_yshear(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXICOImage_hgradient(int argc, VALUE *argv, VALUE self) { FXICOImage *arg1 = (FXICOImage *) 0 ;
    FXColor arg2 ; FXColor arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXICOImage, 1); arg2 = to_FXColor(argv[0]); arg3 = to_FXColor(argv[1]);
    FXICOImage_hgradient(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXICOImage_vgradient(int argc, VALUE *argv, VALUE self) { FXICOImage *arg1 = (FXICOImage *) 0 ;
    FXColor arg2 ; FXColor arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXICOImage, 1); arg2 = to_FXColor(argv[0]); arg3 = to_FXColor(argv[1]);
    FXICOImage_vgradient(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXICOImage_gradient(int argc, VALUE *argv, VALUE self) { FXICOImage *arg1 = (FXICOImage *) 0 ; FXColor arg2 ;
    FXColor arg3 ; FXColor arg4 ; FXColor arg5 ; if ((argc < 4) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXICOImage, 1); arg2 = to_FXColor(argv[0]); arg3 = to_FXColor(argv[1]);
    arg4 = to_FXColor(argv[2]); arg5 = to_FXColor(argv[3]); FXICOImage_gradient(arg1,arg2,arg3,arg4,arg5); return Qnil; }
static VALUE _wrap_FXICOImage_blend(int argc, VALUE *argv, VALUE self) { FXICOImage *arg1 = (FXICOImage *) 0 ; FXColor arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXICOImage, 1); arg2 = to_FXColor(argv[0]); FXICOImage_blend(arg1,arg2);
    return Qnil; }
static VALUE _wrap_FXICOImage_savePixels(int argc, VALUE *argv, VALUE self) { FXICOImage *arg1 = (FXICOImage *) 0 ;
    FXStream *arg2 = 0 ; FXbool result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXICOImage, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    result = (FXbool)FXICOImage_savePixels((FXICOImage const *)arg1,*arg2); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXICOImage_loadPixels(int argc, VALUE *argv, VALUE self) { FXICOImage *arg1 = (FXICOImage *) 0 ;
    FXStream *arg2 = 0 ; FXbool result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXICOImage, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    result = (FXbool)FXICOImage_loadPixels(arg1,*arg2); vresult = result ? Qtrue : Qfalse; return vresult; }
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE _wrap_FXJPGImage_allocate(VALUE self) {
#else
     static VALUE _wrap_FXJPGImage_allocate(int argc, VALUE *argv, VALUE self) {
#endif
         VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_FXJPGImage);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
         return vresult; }
static VALUE _wrap_new_FXJPGImage(int argc, VALUE *argv, VALUE self) { FXApp *arg1 = (FXApp *) 0 ; void *arg2 = (void *) 0 ;
    FXuint arg3 = (FXuint) 0 ; FXint arg4 = (FXint) 1 ; FXint arg5 = (FXint) 1 ; FXJPGImage *result;
    if ((argc < 1) || (argc > 5)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXApp, 1); if (argc > 1) { { if (argv[1] != Qnil) {
                Check_Type(argv[1], T_STRING); arg2 = reinterpret_cast<void *>(RSTRING(argv[1])->ptr); }  else { arg2 = NULL; }
             }  }  if (argc > 2) { arg3 = NUM2UINT(argv[2]); }  if (argc > 3) { arg4 = NUM2INT(argv[3]); }  if (argc > 4) {
        arg5 = NUM2INT(argv[4]); }  { result = (FXJPGImage *)new_FXJPGImage(arg1,(void const *)arg2,arg3,arg4,arg5);
        DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result); if(rb_block_given_p()){ rb_yield(self); }  }  return self; }
static VALUE _wrap_FXJPGImage_setQuality(int argc, VALUE *argv, VALUE self) { FXJPGImage *arg1 = (FXJPGImage *) 0 ; FXint arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXJPGImage, 1); arg2 = NUM2INT(argv[0]); (arg1)->setQuality(arg2);
    return Qnil; }
static VALUE _wrap_FXJPGImage_getQuality(int argc, VALUE *argv, VALUE self) { FXJPGImage *arg1 = (FXJPGImage *) 0 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXJPGImage, 1); result = (FXint)((FXJPGImage const *)arg1)->getQuality();
    vresult = INT2NUM(result); return vresult; }
static void
free_FXJPGImage(FXJPGImage *arg1) {
    delete arg1;
}
static VALUE _wrap_FXJPGImage_save(int argc, VALUE *argv, VALUE self) { FXJPGImage *arg1 = (FXJPGImage *) 0 ;
    FXStream *arg2 = 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXJPGImage, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXJPGImage_save((FXJPGImage const *)arg1,*arg2); return Qnil; }
static VALUE _wrap_FXJPGImage_load(int argc, VALUE *argv, VALUE self) { FXJPGImage *arg1 = (FXJPGImage *) 0 ;
    FXStream *arg2 = 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXJPGImage, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXJPGImage_load(arg1,*arg2); return Qnil; }
static VALUE _wrap_FXJPGImage_create(int argc, VALUE *argv, VALUE self) { FXJPGImage *arg1 = (FXJPGImage *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXJPGImage, 1); FXJPGImage_create(arg1); return Qnil; }
static VALUE _wrap_FXJPGImage_detach(int argc, VALUE *argv, VALUE self) { FXJPGImage *arg1 = (FXJPGImage *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXJPGImage, 1); FXJPGImage_detach(arg1); return Qnil; }
static VALUE _wrap_FXJPGImage_destroy(int argc, VALUE *argv, VALUE self) { FXJPGImage *arg1 = (FXJPGImage *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXJPGImage, 1); FXJPGImage_destroy(arg1); return Qnil; }
static VALUE _wrap_FXJPGImage_resize(int argc, VALUE *argv, VALUE self) { FXJPGImage *arg1 = (FXJPGImage *) 0 ; FXint arg2 ;
    FXint arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXJPGImage, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    FXJPGImage_resize(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXJPGImage_restore(int argc, VALUE *argv, VALUE self) { FXJPGImage *arg1 = (FXJPGImage *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXJPGImage, 1); FXJPGImage_restore(arg1); return Qnil; }
static VALUE _wrap_FXJPGImage_render(int argc, VALUE *argv, VALUE self) { FXJPGImage *arg1 = (FXJPGImage *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXJPGImage, 1); FXJPGImage_render(arg1); return Qnil; }
static VALUE _wrap_FXJPGImage_release(int argc, VALUE *argv, VALUE self) { FXJPGImage *arg1 = (FXJPGImage *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXJPGImage, 1); FXJPGImage_release(arg1); return Qnil; }
static VALUE _wrap_FXJPGImage_scale(int argc, VALUE *argv, VALUE self) { FXJPGImage *arg1 = (FXJPGImage *) 0 ; FXint arg2 ;
    FXint arg3 ; FXint arg4 = (FXint) 0 ; if ((argc < 2) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXJPGImage, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    if (argc > 2) { arg4 = NUM2INT(argv[2]); }  FXJPGImage_scale(arg1,arg2,arg3,arg4); return Qnil; }
static VALUE _wrap_FXJPGImage_mirror(int argc, VALUE *argv, VALUE self) { FXJPGImage *arg1 = (FXJPGImage *) 0 ; FXbool arg2 ;
    FXbool arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXJPGImage, 1); arg2 = to_FXbool(argv[0]); arg3 = to_FXbool(argv[1]);
    FXJPGImage_mirror(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXJPGImage_rotate(int argc, VALUE *argv, VALUE self) { FXJPGImage *arg1 = (FXJPGImage *) 0 ; FXint arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXJPGImage, 1); arg2 = NUM2INT(argv[0]); FXJPGImage_rotate(arg1,arg2);
    return Qnil; }
static VALUE _wrap_FXJPGImage_crop(int argc, VALUE *argv, VALUE self) { FXJPGImage *arg1 = (FXJPGImage *) 0 ; FXint arg2 ;
    FXint arg3 ; FXint arg4 ; FXint arg5 ; if ((argc < 4) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXJPGImage, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    arg4 = NUM2INT(argv[2]); arg5 = NUM2INT(argv[3]); FXJPGImage_crop(arg1,arg2,arg3,arg4,arg5); return Qnil; }
static VALUE _wrap_FXJPGImage_fill(int argc, VALUE *argv, VALUE self) { FXJPGImage *arg1 = (FXJPGImage *) 0 ; FXColor arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXJPGImage, 1); arg2 = to_FXColor(argv[0]); FXJPGImage_fill(arg1,arg2);
    return Qnil; }
static VALUE _wrap_FXJPGImage_fade(int argc, VALUE *argv, VALUE self) { FXJPGImage *arg1 = (FXJPGImage *) 0 ; FXColor arg2 ;
    FXint arg3 = (FXint) 255 ; if ((argc < 1) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXJPGImage, 1); arg2 = to_FXColor(argv[0]); if (argc > 1) {
        arg3 = NUM2INT(argv[1]); }  FXJPGImage_fade(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXJPGImage_xshear(int argc, VALUE *argv, VALUE self) { FXJPGImage *arg1 = (FXJPGImage *) 0 ; FXint arg2 ;
    FXColor arg3 = (FXColor) 0 ; if ((argc < 1) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXJPGImage, 1); arg2 = NUM2INT(argv[0]); if (argc > 1) {
        arg3 = to_FXColor(argv[1]); }  FXJPGImage_xshear(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXJPGImage_yshear(int argc, VALUE *argv, VALUE self) { FXJPGImage *arg1 = (FXJPGImage *) 0 ; FXint arg2 ;
    FXColor arg3 = (FXColor) 0 ; if ((argc < 1) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXJPGImage, 1); arg2 = NUM2INT(argv[0]); if (argc > 1) {
        arg3 = to_FXColor(argv[1]); }  FXJPGImage_yshear(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXJPGImage_hgradient(int argc, VALUE *argv, VALUE self) { FXJPGImage *arg1 = (FXJPGImage *) 0 ;
    FXColor arg2 ; FXColor arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXJPGImage, 1); arg2 = to_FXColor(argv[0]); arg3 = to_FXColor(argv[1]);
    FXJPGImage_hgradient(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXJPGImage_vgradient(int argc, VALUE *argv, VALUE self) { FXJPGImage *arg1 = (FXJPGImage *) 0 ;
    FXColor arg2 ; FXColor arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXJPGImage, 1); arg2 = to_FXColor(argv[0]); arg3 = to_FXColor(argv[1]);
    FXJPGImage_vgradient(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXJPGImage_gradient(int argc, VALUE *argv, VALUE self) { FXJPGImage *arg1 = (FXJPGImage *) 0 ; FXColor arg2 ;
    FXColor arg3 ; FXColor arg4 ; FXColor arg5 ; if ((argc < 4) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXJPGImage, 1); arg2 = to_FXColor(argv[0]); arg3 = to_FXColor(argv[1]);
    arg4 = to_FXColor(argv[2]); arg5 = to_FXColor(argv[3]); FXJPGImage_gradient(arg1,arg2,arg3,arg4,arg5); return Qnil; }
static VALUE _wrap_FXJPGImage_blend(int argc, VALUE *argv, VALUE self) { FXJPGImage *arg1 = (FXJPGImage *) 0 ; FXColor arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXJPGImage, 1); arg2 = to_FXColor(argv[0]); FXJPGImage_blend(arg1,arg2);
    return Qnil; }
static VALUE _wrap_FXJPGImage_savePixels(int argc, VALUE *argv, VALUE self) { FXJPGImage *arg1 = (FXJPGImage *) 0 ;
    FXStream *arg2 = 0 ; FXbool result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXJPGImage, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    result = (FXbool)FXJPGImage_savePixels((FXJPGImage const *)arg1,*arg2); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXJPGImage_loadPixels(int argc, VALUE *argv, VALUE self) { FXJPGImage *arg1 = (FXJPGImage *) 0 ;
    FXStream *arg2 = 0 ; FXbool result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXJPGImage, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    result = (FXbool)FXJPGImage_loadPixels(arg1,*arg2); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_fxloadJPG(int argc, VALUE *argv, VALUE self) { FXStream *arg1 = 0 ; VALUE result; VALUE vresult = Qnil;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXStream, 1); if (arg1 == NULL) rb_raise(rb_eTypeError, "null reference");
    result = (VALUE)fxloadJPG(*arg1); vresult = result; return vresult; }
static VALUE _wrap_fxsaveJPG(int argc, VALUE *argv, VALUE self) { FXStream *arg1 = 0 ; FXColor *arg2 = (FXColor *) 0 ;
    FXint arg3 ; FXint arg4 ; FXint arg5 ; FXbool result; VALUE vresult = Qnil; if ((argc < 5) || (argc > 5))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 5)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXStream, 1); if (arg1 == NULL) rb_raise(rb_eTypeError, "null reference");
    { arg2=NULL; if(argv[1]!=Qnil){ Check_Type(argv[1],T_ARRAY); if(FXMALLOC(&arg2,FXColor,RARRAY(argv[1])->len)){
                for(long i=0; i<RARRAY(argv[1])->len; i++){ arg2[i]=static_cast<FXColor>(NUM2UINT(rb_ary_entry(argv[1],i))); }  }
             }  }  arg3 = NUM2INT(argv[2]); arg4 = NUM2INT(argv[3]); arg5 = NUM2INT(argv[4]);
    result = (FXbool)fxsaveJPG(*arg1,(FXColor const *)arg2,arg3,arg4,arg5); vresult = result ? Qtrue : Qfalse; FXFREE(&arg2);
    return vresult; }
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE _wrap_FXPCXImage_allocate(VALUE self) {
#else
     static VALUE _wrap_FXPCXImage_allocate(int argc, VALUE *argv, VALUE self) {
#endif
         VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_FXPCXImage);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
         return vresult; }
static VALUE _wrap_new_FXPCXImage(int argc, VALUE *argv, VALUE self) { FXApp *arg1 = (FXApp *) 0 ; void *arg2 = (void *) 0 ;
    FXuint arg3 = (FXuint) 0 ; FXint arg4 = (FXint) 1 ; FXint arg5 = (FXint) 1 ; FXPCXImage *result;
    if ((argc < 1) || (argc > 5)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXApp, 1); if (argc > 1) { { if (argv[1] != Qnil) {
                Check_Type(argv[1], T_STRING); arg2 = reinterpret_cast<void *>(RSTRING(argv[1])->ptr); }  else { arg2 = NULL; }
             }  }  if (argc > 2) { arg3 = NUM2UINT(argv[2]); }  if (argc > 3) { arg4 = NUM2INT(argv[3]); }  if (argc > 4) {
        arg5 = NUM2INT(argv[4]); }  { result = (FXPCXImage *)new_FXPCXImage(arg1,(void const *)arg2,arg3,arg4,arg5);
        DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result); if(rb_block_given_p()){ rb_yield(self); }  }  return self; }
static void
free_FXPCXImage(FXPCXImage *arg1) {
    delete arg1;
}
static VALUE _wrap_FXPCXImage_save(int argc, VALUE *argv, VALUE self) { FXPCXImage *arg1 = (FXPCXImage *) 0 ;
    FXStream *arg2 = 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPCXImage, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXPCXImage_save((FXPCXImage const *)arg1,*arg2); return Qnil; }
static VALUE _wrap_FXPCXImage_load(int argc, VALUE *argv, VALUE self) { FXPCXImage *arg1 = (FXPCXImage *) 0 ;
    FXStream *arg2 = 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPCXImage, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXPCXImage_load(arg1,*arg2); return Qnil; }
static VALUE _wrap_FXPCXImage_create(int argc, VALUE *argv, VALUE self) { FXPCXImage *arg1 = (FXPCXImage *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPCXImage, 1); FXPCXImage_create(arg1); return Qnil; }
static VALUE _wrap_FXPCXImage_detach(int argc, VALUE *argv, VALUE self) { FXPCXImage *arg1 = (FXPCXImage *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPCXImage, 1); FXPCXImage_detach(arg1); return Qnil; }
static VALUE _wrap_FXPCXImage_destroy(int argc, VALUE *argv, VALUE self) { FXPCXImage *arg1 = (FXPCXImage *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPCXImage, 1); FXPCXImage_destroy(arg1); return Qnil; }
static VALUE _wrap_FXPCXImage_resize(int argc, VALUE *argv, VALUE self) { FXPCXImage *arg1 = (FXPCXImage *) 0 ; FXint arg2 ;
    FXint arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPCXImage, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    FXPCXImage_resize(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXPCXImage_restore(int argc, VALUE *argv, VALUE self) { FXPCXImage *arg1 = (FXPCXImage *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPCXImage, 1); FXPCXImage_restore(arg1); return Qnil; }
static VALUE _wrap_FXPCXImage_render(int argc, VALUE *argv, VALUE self) { FXPCXImage *arg1 = (FXPCXImage *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPCXImage, 1); FXPCXImage_render(arg1); return Qnil; }
static VALUE _wrap_FXPCXImage_release(int argc, VALUE *argv, VALUE self) { FXPCXImage *arg1 = (FXPCXImage *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPCXImage, 1); FXPCXImage_release(arg1); return Qnil; }
static VALUE _wrap_FXPCXImage_scale(int argc, VALUE *argv, VALUE self) { FXPCXImage *arg1 = (FXPCXImage *) 0 ; FXint arg2 ;
    FXint arg3 ; FXint arg4 = (FXint) 0 ; if ((argc < 2) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPCXImage, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    if (argc > 2) { arg4 = NUM2INT(argv[2]); }  FXPCXImage_scale(arg1,arg2,arg3,arg4); return Qnil; }
static VALUE _wrap_FXPCXImage_mirror(int argc, VALUE *argv, VALUE self) { FXPCXImage *arg1 = (FXPCXImage *) 0 ; FXbool arg2 ;
    FXbool arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPCXImage, 1); arg2 = to_FXbool(argv[0]); arg3 = to_FXbool(argv[1]);
    FXPCXImage_mirror(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXPCXImage_rotate(int argc, VALUE *argv, VALUE self) { FXPCXImage *arg1 = (FXPCXImage *) 0 ; FXint arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPCXImage, 1); arg2 = NUM2INT(argv[0]); FXPCXImage_rotate(arg1,arg2);
    return Qnil; }
static VALUE _wrap_FXPCXImage_crop(int argc, VALUE *argv, VALUE self) { FXPCXImage *arg1 = (FXPCXImage *) 0 ; FXint arg2 ;
    FXint arg3 ; FXint arg4 ; FXint arg5 ; if ((argc < 4) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPCXImage, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    arg4 = NUM2INT(argv[2]); arg5 = NUM2INT(argv[3]); FXPCXImage_crop(arg1,arg2,arg3,arg4,arg5); return Qnil; }
static VALUE _wrap_FXPCXImage_fill(int argc, VALUE *argv, VALUE self) { FXPCXImage *arg1 = (FXPCXImage *) 0 ; FXColor arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPCXImage, 1); arg2 = to_FXColor(argv[0]); FXPCXImage_fill(arg1,arg2);
    return Qnil; }
static VALUE _wrap_FXPCXImage_fade(int argc, VALUE *argv, VALUE self) { FXPCXImage *arg1 = (FXPCXImage *) 0 ; FXColor arg2 ;
    FXint arg3 = (FXint) 255 ; if ((argc < 1) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPCXImage, 1); arg2 = to_FXColor(argv[0]); if (argc > 1) {
        arg3 = NUM2INT(argv[1]); }  FXPCXImage_fade(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXPCXImage_xshear(int argc, VALUE *argv, VALUE self) { FXPCXImage *arg1 = (FXPCXImage *) 0 ; FXint arg2 ;
    FXColor arg3 = (FXColor) 0 ; if ((argc < 1) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPCXImage, 1); arg2 = NUM2INT(argv[0]); if (argc > 1) {
        arg3 = to_FXColor(argv[1]); }  FXPCXImage_xshear(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXPCXImage_yshear(int argc, VALUE *argv, VALUE self) { FXPCXImage *arg1 = (FXPCXImage *) 0 ; FXint arg2 ;
    FXColor arg3 = (FXColor) 0 ; if ((argc < 1) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPCXImage, 1); arg2 = NUM2INT(argv[0]); if (argc > 1) {
        arg3 = to_FXColor(argv[1]); }  FXPCXImage_yshear(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXPCXImage_hgradient(int argc, VALUE *argv, VALUE self) { FXPCXImage *arg1 = (FXPCXImage *) 0 ;
    FXColor arg2 ; FXColor arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPCXImage, 1); arg2 = to_FXColor(argv[0]); arg3 = to_FXColor(argv[1]);
    FXPCXImage_hgradient(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXPCXImage_vgradient(int argc, VALUE *argv, VALUE self) { FXPCXImage *arg1 = (FXPCXImage *) 0 ;
    FXColor arg2 ; FXColor arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPCXImage, 1); arg2 = to_FXColor(argv[0]); arg3 = to_FXColor(argv[1]);
    FXPCXImage_vgradient(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXPCXImage_gradient(int argc, VALUE *argv, VALUE self) { FXPCXImage *arg1 = (FXPCXImage *) 0 ; FXColor arg2 ;
    FXColor arg3 ; FXColor arg4 ; FXColor arg5 ; if ((argc < 4) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPCXImage, 1); arg2 = to_FXColor(argv[0]); arg3 = to_FXColor(argv[1]);
    arg4 = to_FXColor(argv[2]); arg5 = to_FXColor(argv[3]); FXPCXImage_gradient(arg1,arg2,arg3,arg4,arg5); return Qnil; }
static VALUE _wrap_FXPCXImage_blend(int argc, VALUE *argv, VALUE self) { FXPCXImage *arg1 = (FXPCXImage *) 0 ; FXColor arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPCXImage, 1); arg2 = to_FXColor(argv[0]); FXPCXImage_blend(arg1,arg2);
    return Qnil; }
static VALUE _wrap_FXPCXImage_savePixels(int argc, VALUE *argv, VALUE self) { FXPCXImage *arg1 = (FXPCXImage *) 0 ;
    FXStream *arg2 = 0 ; FXbool result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPCXImage, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    result = (FXbool)FXPCXImage_savePixels((FXPCXImage const *)arg1,*arg2); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXPCXImage_loadPixels(int argc, VALUE *argv, VALUE self) { FXPCXImage *arg1 = (FXPCXImage *) 0 ;
    FXStream *arg2 = 0 ; FXbool result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPCXImage, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    result = (FXbool)FXPCXImage_loadPixels(arg1,*arg2); vresult = result ? Qtrue : Qfalse; return vresult; }
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE _wrap_FXPNGImage_allocate(VALUE self) {
#else
     static VALUE _wrap_FXPNGImage_allocate(int argc, VALUE *argv, VALUE self) {
#endif
         VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_FXPNGImage);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
         return vresult; }
static VALUE _wrap_new_FXPNGImage(int argc, VALUE *argv, VALUE self) { FXApp *arg1 = (FXApp *) 0 ; void *arg2 = (void *) 0 ;
    FXuint arg3 = (FXuint) 0 ; FXint arg4 = (FXint) 1 ; FXint arg5 = (FXint) 1 ; FXPNGImage *result;
    if ((argc < 1) || (argc > 5)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXApp, 1); if (argc > 1) { { if (argv[1] != Qnil) {
                Check_Type(argv[1], T_STRING); arg2 = reinterpret_cast<void *>(RSTRING(argv[1])->ptr); }  else { arg2 = NULL; }
             }  }  if (argc > 2) { arg3 = NUM2UINT(argv[2]); }  if (argc > 3) { arg4 = NUM2INT(argv[3]); }  if (argc > 4) {
        arg5 = NUM2INT(argv[4]); }  { result = (FXPNGImage *)new_FXPNGImage(arg1,(void const *)arg2,arg3,arg4,arg5);
        DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result); if(rb_block_given_p()){ rb_yield(self); }  }  return self; }
static void
free_FXPNGImage(FXPNGImage *arg1) {
    delete arg1;
}
static VALUE _wrap_FXPNGImage_save(int argc, VALUE *argv, VALUE self) { FXPNGImage *arg1 = (FXPNGImage *) 0 ;
    FXStream *arg2 = 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPNGImage, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXPNGImage_save((FXPNGImage const *)arg1,*arg2); return Qnil; }
static VALUE _wrap_FXPNGImage_load(int argc, VALUE *argv, VALUE self) { FXPNGImage *arg1 = (FXPNGImage *) 0 ;
    FXStream *arg2 = 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPNGImage, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXPNGImage_load(arg1,*arg2); return Qnil; }
static VALUE _wrap_FXPNGImage_create(int argc, VALUE *argv, VALUE self) { FXPNGImage *arg1 = (FXPNGImage *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPNGImage, 1); FXPNGImage_create(arg1); return Qnil; }
static VALUE _wrap_FXPNGImage_detach(int argc, VALUE *argv, VALUE self) { FXPNGImage *arg1 = (FXPNGImage *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPNGImage, 1); FXPNGImage_detach(arg1); return Qnil; }
static VALUE _wrap_FXPNGImage_destroy(int argc, VALUE *argv, VALUE self) { FXPNGImage *arg1 = (FXPNGImage *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPNGImage, 1); FXPNGImage_destroy(arg1); return Qnil; }
static VALUE _wrap_FXPNGImage_resize(int argc, VALUE *argv, VALUE self) { FXPNGImage *arg1 = (FXPNGImage *) 0 ; FXint arg2 ;
    FXint arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPNGImage, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    FXPNGImage_resize(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXPNGImage_restore(int argc, VALUE *argv, VALUE self) { FXPNGImage *arg1 = (FXPNGImage *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPNGImage, 1); FXPNGImage_restore(arg1); return Qnil; }
static VALUE _wrap_FXPNGImage_render(int argc, VALUE *argv, VALUE self) { FXPNGImage *arg1 = (FXPNGImage *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPNGImage, 1); FXPNGImage_render(arg1); return Qnil; }
static VALUE _wrap_FXPNGImage_release(int argc, VALUE *argv, VALUE self) { FXPNGImage *arg1 = (FXPNGImage *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPNGImage, 1); FXPNGImage_release(arg1); return Qnil; }
static VALUE _wrap_FXPNGImage_scale(int argc, VALUE *argv, VALUE self) { FXPNGImage *arg1 = (FXPNGImage *) 0 ; FXint arg2 ;
    FXint arg3 ; FXint arg4 = (FXint) 0 ; if ((argc < 2) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPNGImage, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    if (argc > 2) { arg4 = NUM2INT(argv[2]); }  FXPNGImage_scale(arg1,arg2,arg3,arg4); return Qnil; }
static VALUE _wrap_FXPNGImage_mirror(int argc, VALUE *argv, VALUE self) { FXPNGImage *arg1 = (FXPNGImage *) 0 ; FXbool arg2 ;
    FXbool arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPNGImage, 1); arg2 = to_FXbool(argv[0]); arg3 = to_FXbool(argv[1]);
    FXPNGImage_mirror(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXPNGImage_rotate(int argc, VALUE *argv, VALUE self) { FXPNGImage *arg1 = (FXPNGImage *) 0 ; FXint arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPNGImage, 1); arg2 = NUM2INT(argv[0]); FXPNGImage_rotate(arg1,arg2);
    return Qnil; }
static VALUE _wrap_FXPNGImage_crop(int argc, VALUE *argv, VALUE self) { FXPNGImage *arg1 = (FXPNGImage *) 0 ; FXint arg2 ;
    FXint arg3 ; FXint arg4 ; FXint arg5 ; if ((argc < 4) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPNGImage, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    arg4 = NUM2INT(argv[2]); arg5 = NUM2INT(argv[3]); FXPNGImage_crop(arg1,arg2,arg3,arg4,arg5); return Qnil; }
static VALUE _wrap_FXPNGImage_fill(int argc, VALUE *argv, VALUE self) { FXPNGImage *arg1 = (FXPNGImage *) 0 ; FXColor arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPNGImage, 1); arg2 = to_FXColor(argv[0]); FXPNGImage_fill(arg1,arg2);
    return Qnil; }
static VALUE _wrap_FXPNGImage_fade(int argc, VALUE *argv, VALUE self) { FXPNGImage *arg1 = (FXPNGImage *) 0 ; FXColor arg2 ;
    FXint arg3 = (FXint) 255 ; if ((argc < 1) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPNGImage, 1); arg2 = to_FXColor(argv[0]); if (argc > 1) {
        arg3 = NUM2INT(argv[1]); }  FXPNGImage_fade(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXPNGImage_xshear(int argc, VALUE *argv, VALUE self) { FXPNGImage *arg1 = (FXPNGImage *) 0 ; FXint arg2 ;
    FXColor arg3 = (FXColor) 0 ; if ((argc < 1) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPNGImage, 1); arg2 = NUM2INT(argv[0]); if (argc > 1) {
        arg3 = to_FXColor(argv[1]); }  FXPNGImage_xshear(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXPNGImage_yshear(int argc, VALUE *argv, VALUE self) { FXPNGImage *arg1 = (FXPNGImage *) 0 ; FXint arg2 ;
    FXColor arg3 = (FXColor) 0 ; if ((argc < 1) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPNGImage, 1); arg2 = NUM2INT(argv[0]); if (argc > 1) {
        arg3 = to_FXColor(argv[1]); }  FXPNGImage_yshear(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXPNGImage_hgradient(int argc, VALUE *argv, VALUE self) { FXPNGImage *arg1 = (FXPNGImage *) 0 ;
    FXColor arg2 ; FXColor arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPNGImage, 1); arg2 = to_FXColor(argv[0]); arg3 = to_FXColor(argv[1]);
    FXPNGImage_hgradient(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXPNGImage_vgradient(int argc, VALUE *argv, VALUE self) { FXPNGImage *arg1 = (FXPNGImage *) 0 ;
    FXColor arg2 ; FXColor arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPNGImage, 1); arg2 = to_FXColor(argv[0]); arg3 = to_FXColor(argv[1]);
    FXPNGImage_vgradient(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXPNGImage_gradient(int argc, VALUE *argv, VALUE self) { FXPNGImage *arg1 = (FXPNGImage *) 0 ; FXColor arg2 ;
    FXColor arg3 ; FXColor arg4 ; FXColor arg5 ; if ((argc < 4) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPNGImage, 1); arg2 = to_FXColor(argv[0]); arg3 = to_FXColor(argv[1]);
    arg4 = to_FXColor(argv[2]); arg5 = to_FXColor(argv[3]); FXPNGImage_gradient(arg1,arg2,arg3,arg4,arg5); return Qnil; }
static VALUE _wrap_FXPNGImage_blend(int argc, VALUE *argv, VALUE self) { FXPNGImage *arg1 = (FXPNGImage *) 0 ; FXColor arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPNGImage, 1); arg2 = to_FXColor(argv[0]); FXPNGImage_blend(arg1,arg2);
    return Qnil; }
static VALUE _wrap_FXPNGImage_savePixels(int argc, VALUE *argv, VALUE self) { FXPNGImage *arg1 = (FXPNGImage *) 0 ;
    FXStream *arg2 = 0 ; FXbool result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPNGImage, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    result = (FXbool)FXPNGImage_savePixels((FXPNGImage const *)arg1,*arg2); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXPNGImage_loadPixels(int argc, VALUE *argv, VALUE self) { FXPNGImage *arg1 = (FXPNGImage *) 0 ;
    FXStream *arg2 = 0 ; FXbool result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPNGImage, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    result = (FXbool)FXPNGImage_loadPixels(arg1,*arg2); vresult = result ? Qtrue : Qfalse; return vresult; }
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE _wrap_FXPPMImage_allocate(VALUE self) {
#else
     static VALUE _wrap_FXPPMImage_allocate(int argc, VALUE *argv, VALUE self) {
#endif
         VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_FXPPMImage);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
         return vresult; }
static VALUE _wrap_new_FXPPMImage(int argc, VALUE *argv, VALUE self) { FXApp *arg1 = (FXApp *) 0 ; void *arg2 = (void *) 0 ;
    FXuint arg3 = (FXuint) 0 ; FXint arg4 = (FXint) 1 ; FXint arg5 = (FXint) 1 ; FXPPMImage *result;
    if ((argc < 1) || (argc > 5)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXApp, 1); if (argc > 1) { { if (argv[1] != Qnil) {
                Check_Type(argv[1], T_STRING); arg2 = reinterpret_cast<void *>(RSTRING(argv[1])->ptr); }  else { arg2 = NULL; }
             }  }  if (argc > 2) { arg3 = NUM2UINT(argv[2]); }  if (argc > 3) { arg4 = NUM2INT(argv[3]); }  if (argc > 4) {
        arg5 = NUM2INT(argv[4]); }  { result = (FXPPMImage *)new_FXPPMImage(arg1,(void const *)arg2,arg3,arg4,arg5);
        DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result); if(rb_block_given_p()){ rb_yield(self); }  }  return self; }
static void
free_FXPPMImage(FXPPMImage *arg1) {
    delete arg1;
}
static VALUE _wrap_FXPPMImage_save(int argc, VALUE *argv, VALUE self) { FXPPMImage *arg1 = (FXPPMImage *) 0 ;
    FXStream *arg2 = 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPPMImage, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXPPMImage_save((FXPPMImage const *)arg1,*arg2); return Qnil; }
static VALUE _wrap_FXPPMImage_load(int argc, VALUE *argv, VALUE self) { FXPPMImage *arg1 = (FXPPMImage *) 0 ;
    FXStream *arg2 = 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPPMImage, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXPPMImage_load(arg1,*arg2); return Qnil; }
static VALUE _wrap_FXPPMImage_create(int argc, VALUE *argv, VALUE self) { FXPPMImage *arg1 = (FXPPMImage *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPPMImage, 1); FXPPMImage_create(arg1); return Qnil; }
static VALUE _wrap_FXPPMImage_detach(int argc, VALUE *argv, VALUE self) { FXPPMImage *arg1 = (FXPPMImage *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPPMImage, 1); FXPPMImage_detach(arg1); return Qnil; }
static VALUE _wrap_FXPPMImage_destroy(int argc, VALUE *argv, VALUE self) { FXPPMImage *arg1 = (FXPPMImage *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPPMImage, 1); FXPPMImage_destroy(arg1); return Qnil; }
static VALUE _wrap_FXPPMImage_resize(int argc, VALUE *argv, VALUE self) { FXPPMImage *arg1 = (FXPPMImage *) 0 ; FXint arg2 ;
    FXint arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPPMImage, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    FXPPMImage_resize(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXPPMImage_restore(int argc, VALUE *argv, VALUE self) { FXPPMImage *arg1 = (FXPPMImage *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPPMImage, 1); FXPPMImage_restore(arg1); return Qnil; }
static VALUE _wrap_FXPPMImage_render(int argc, VALUE *argv, VALUE self) { FXPPMImage *arg1 = (FXPPMImage *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPPMImage, 1); FXPPMImage_render(arg1); return Qnil; }
static VALUE _wrap_FXPPMImage_release(int argc, VALUE *argv, VALUE self) { FXPPMImage *arg1 = (FXPPMImage *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPPMImage, 1); FXPPMImage_release(arg1); return Qnil; }
static VALUE _wrap_FXPPMImage_scale(int argc, VALUE *argv, VALUE self) { FXPPMImage *arg1 = (FXPPMImage *) 0 ; FXint arg2 ;
    FXint arg3 ; FXint arg4 = (FXint) 0 ; if ((argc < 2) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPPMImage, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    if (argc > 2) { arg4 = NUM2INT(argv[2]); }  FXPPMImage_scale(arg1,arg2,arg3,arg4); return Qnil; }
static VALUE _wrap_FXPPMImage_mirror(int argc, VALUE *argv, VALUE self) { FXPPMImage *arg1 = (FXPPMImage *) 0 ; FXbool arg2 ;
    FXbool arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPPMImage, 1); arg2 = to_FXbool(argv[0]); arg3 = to_FXbool(argv[1]);
    FXPPMImage_mirror(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXPPMImage_rotate(int argc, VALUE *argv, VALUE self) { FXPPMImage *arg1 = (FXPPMImage *) 0 ; FXint arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPPMImage, 1); arg2 = NUM2INT(argv[0]); FXPPMImage_rotate(arg1,arg2);
    return Qnil; }
static VALUE _wrap_FXPPMImage_crop(int argc, VALUE *argv, VALUE self) { FXPPMImage *arg1 = (FXPPMImage *) 0 ; FXint arg2 ;
    FXint arg3 ; FXint arg4 ; FXint arg5 ; if ((argc < 4) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPPMImage, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    arg4 = NUM2INT(argv[2]); arg5 = NUM2INT(argv[3]); FXPPMImage_crop(arg1,arg2,arg3,arg4,arg5); return Qnil; }
static VALUE _wrap_FXPPMImage_fill(int argc, VALUE *argv, VALUE self) { FXPPMImage *arg1 = (FXPPMImage *) 0 ; FXColor arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPPMImage, 1); arg2 = to_FXColor(argv[0]); FXPPMImage_fill(arg1,arg2);
    return Qnil; }
static VALUE _wrap_FXPPMImage_fade(int argc, VALUE *argv, VALUE self) { FXPPMImage *arg1 = (FXPPMImage *) 0 ; FXColor arg2 ;
    FXint arg3 = (FXint) 255 ; if ((argc < 1) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPPMImage, 1); arg2 = to_FXColor(argv[0]); if (argc > 1) {
        arg3 = NUM2INT(argv[1]); }  FXPPMImage_fade(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXPPMImage_xshear(int argc, VALUE *argv, VALUE self) { FXPPMImage *arg1 = (FXPPMImage *) 0 ; FXint arg2 ;
    FXColor arg3 = (FXColor) 0 ; if ((argc < 1) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPPMImage, 1); arg2 = NUM2INT(argv[0]); if (argc > 1) {
        arg3 = to_FXColor(argv[1]); }  FXPPMImage_xshear(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXPPMImage_yshear(int argc, VALUE *argv, VALUE self) { FXPPMImage *arg1 = (FXPPMImage *) 0 ; FXint arg2 ;
    FXColor arg3 = (FXColor) 0 ; if ((argc < 1) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPPMImage, 1); arg2 = NUM2INT(argv[0]); if (argc > 1) {
        arg3 = to_FXColor(argv[1]); }  FXPPMImage_yshear(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXPPMImage_hgradient(int argc, VALUE *argv, VALUE self) { FXPPMImage *arg1 = (FXPPMImage *) 0 ;
    FXColor arg2 ; FXColor arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPPMImage, 1); arg2 = to_FXColor(argv[0]); arg3 = to_FXColor(argv[1]);
    FXPPMImage_hgradient(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXPPMImage_vgradient(int argc, VALUE *argv, VALUE self) { FXPPMImage *arg1 = (FXPPMImage *) 0 ;
    FXColor arg2 ; FXColor arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPPMImage, 1); arg2 = to_FXColor(argv[0]); arg3 = to_FXColor(argv[1]);
    FXPPMImage_vgradient(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXPPMImage_gradient(int argc, VALUE *argv, VALUE self) { FXPPMImage *arg1 = (FXPPMImage *) 0 ; FXColor arg2 ;
    FXColor arg3 ; FXColor arg4 ; FXColor arg5 ; if ((argc < 4) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPPMImage, 1); arg2 = to_FXColor(argv[0]); arg3 = to_FXColor(argv[1]);
    arg4 = to_FXColor(argv[2]); arg5 = to_FXColor(argv[3]); FXPPMImage_gradient(arg1,arg2,arg3,arg4,arg5); return Qnil; }
static VALUE _wrap_FXPPMImage_blend(int argc, VALUE *argv, VALUE self) { FXPPMImage *arg1 = (FXPPMImage *) 0 ; FXColor arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPPMImage, 1); arg2 = to_FXColor(argv[0]); FXPPMImage_blend(arg1,arg2);
    return Qnil; }
static VALUE _wrap_FXPPMImage_savePixels(int argc, VALUE *argv, VALUE self) { FXPPMImage *arg1 = (FXPPMImage *) 0 ;
    FXStream *arg2 = 0 ; FXbool result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPPMImage, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    result = (FXbool)FXPPMImage_savePixels((FXPPMImage const *)arg1,*arg2); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXPPMImage_loadPixels(int argc, VALUE *argv, VALUE self) { FXPPMImage *arg1 = (FXPPMImage *) 0 ;
    FXStream *arg2 = 0 ; FXbool result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPPMImage, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    result = (FXbool)FXPPMImage_loadPixels(arg1,*arg2); vresult = result ? Qtrue : Qfalse; return vresult; }
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE _wrap_FXRGBImage_allocate(VALUE self) {
#else
     static VALUE _wrap_FXRGBImage_allocate(int argc, VALUE *argv, VALUE self) {
#endif
         VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_FXRGBImage);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
         return vresult; }
static VALUE _wrap_new_FXRGBImage(int argc, VALUE *argv, VALUE self) { FXApp *arg1 = (FXApp *) 0 ; void *arg2 = (void *) 0 ;
    FXuint arg3 = (FXuint) 0 ; FXint arg4 = (FXint) 1 ; FXint arg5 = (FXint) 1 ; FXRGBImage *result;
    if ((argc < 1) || (argc > 5)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXApp, 1); if (argc > 1) { { if (argv[1] != Qnil) {
                Check_Type(argv[1], T_STRING); arg2 = reinterpret_cast<void *>(RSTRING(argv[1])->ptr); }  else { arg2 = NULL; }
             }  }  if (argc > 2) { arg3 = NUM2UINT(argv[2]); }  if (argc > 3) { arg4 = NUM2INT(argv[3]); }  if (argc > 4) {
        arg5 = NUM2INT(argv[4]); }  { result = (FXRGBImage *)new_FXRGBImage(arg1,(void const *)arg2,arg3,arg4,arg5);
        DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result); if(rb_block_given_p()){ rb_yield(self); }  }  return self; }
static void
free_FXRGBImage(FXRGBImage *arg1) {
    delete arg1;
}
static VALUE _wrap_FXRGBImage_save(int argc, VALUE *argv, VALUE self) { FXRGBImage *arg1 = (FXRGBImage *) 0 ;
    FXStream *arg2 = 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRGBImage, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXRGBImage_save((FXRGBImage const *)arg1,*arg2); return Qnil; }
static VALUE _wrap_FXRGBImage_load(int argc, VALUE *argv, VALUE self) { FXRGBImage *arg1 = (FXRGBImage *) 0 ;
    FXStream *arg2 = 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRGBImage, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXRGBImage_load(arg1,*arg2); return Qnil; }
static VALUE _wrap_FXRGBImage_create(int argc, VALUE *argv, VALUE self) { FXRGBImage *arg1 = (FXRGBImage *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRGBImage, 1); FXRGBImage_create(arg1); return Qnil; }
static VALUE _wrap_FXRGBImage_detach(int argc, VALUE *argv, VALUE self) { FXRGBImage *arg1 = (FXRGBImage *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRGBImage, 1); FXRGBImage_detach(arg1); return Qnil; }
static VALUE _wrap_FXRGBImage_destroy(int argc, VALUE *argv, VALUE self) { FXRGBImage *arg1 = (FXRGBImage *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRGBImage, 1); FXRGBImage_destroy(arg1); return Qnil; }
static VALUE _wrap_FXRGBImage_resize(int argc, VALUE *argv, VALUE self) { FXRGBImage *arg1 = (FXRGBImage *) 0 ; FXint arg2 ;
    FXint arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRGBImage, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    FXRGBImage_resize(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXRGBImage_restore(int argc, VALUE *argv, VALUE self) { FXRGBImage *arg1 = (FXRGBImage *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRGBImage, 1); FXRGBImage_restore(arg1); return Qnil; }
static VALUE _wrap_FXRGBImage_render(int argc, VALUE *argv, VALUE self) { FXRGBImage *arg1 = (FXRGBImage *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRGBImage, 1); FXRGBImage_render(arg1); return Qnil; }
static VALUE _wrap_FXRGBImage_release(int argc, VALUE *argv, VALUE self) { FXRGBImage *arg1 = (FXRGBImage *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRGBImage, 1); FXRGBImage_release(arg1); return Qnil; }
static VALUE _wrap_FXRGBImage_scale(int argc, VALUE *argv, VALUE self) { FXRGBImage *arg1 = (FXRGBImage *) 0 ; FXint arg2 ;
    FXint arg3 ; FXint arg4 = (FXint) 0 ; if ((argc < 2) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRGBImage, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    if (argc > 2) { arg4 = NUM2INT(argv[2]); }  FXRGBImage_scale(arg1,arg2,arg3,arg4); return Qnil; }
static VALUE _wrap_FXRGBImage_mirror(int argc, VALUE *argv, VALUE self) { FXRGBImage *arg1 = (FXRGBImage *) 0 ; FXbool arg2 ;
    FXbool arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRGBImage, 1); arg2 = to_FXbool(argv[0]); arg3 = to_FXbool(argv[1]);
    FXRGBImage_mirror(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXRGBImage_rotate(int argc, VALUE *argv, VALUE self) { FXRGBImage *arg1 = (FXRGBImage *) 0 ; FXint arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRGBImage, 1); arg2 = NUM2INT(argv[0]); FXRGBImage_rotate(arg1,arg2);
    return Qnil; }
static VALUE _wrap_FXRGBImage_crop(int argc, VALUE *argv, VALUE self) { FXRGBImage *arg1 = (FXRGBImage *) 0 ; FXint arg2 ;
    FXint arg3 ; FXint arg4 ; FXint arg5 ; if ((argc < 4) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRGBImage, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    arg4 = NUM2INT(argv[2]); arg5 = NUM2INT(argv[3]); FXRGBImage_crop(arg1,arg2,arg3,arg4,arg5); return Qnil; }
static VALUE _wrap_FXRGBImage_fill(int argc, VALUE *argv, VALUE self) { FXRGBImage *arg1 = (FXRGBImage *) 0 ; FXColor arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRGBImage, 1); arg2 = to_FXColor(argv[0]); FXRGBImage_fill(arg1,arg2);
    return Qnil; }
static VALUE _wrap_FXRGBImage_fade(int argc, VALUE *argv, VALUE self) { FXRGBImage *arg1 = (FXRGBImage *) 0 ; FXColor arg2 ;
    FXint arg3 = (FXint) 255 ; if ((argc < 1) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRGBImage, 1); arg2 = to_FXColor(argv[0]); if (argc > 1) {
        arg3 = NUM2INT(argv[1]); }  FXRGBImage_fade(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXRGBImage_xshear(int argc, VALUE *argv, VALUE self) { FXRGBImage *arg1 = (FXRGBImage *) 0 ; FXint arg2 ;
    FXColor arg3 = (FXColor) 0 ; if ((argc < 1) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRGBImage, 1); arg2 = NUM2INT(argv[0]); if (argc > 1) {
        arg3 = to_FXColor(argv[1]); }  FXRGBImage_xshear(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXRGBImage_yshear(int argc, VALUE *argv, VALUE self) { FXRGBImage *arg1 = (FXRGBImage *) 0 ; FXint arg2 ;
    FXColor arg3 = (FXColor) 0 ; if ((argc < 1) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRGBImage, 1); arg2 = NUM2INT(argv[0]); if (argc > 1) {
        arg3 = to_FXColor(argv[1]); }  FXRGBImage_yshear(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXRGBImage_hgradient(int argc, VALUE *argv, VALUE self) { FXRGBImage *arg1 = (FXRGBImage *) 0 ;
    FXColor arg2 ; FXColor arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRGBImage, 1); arg2 = to_FXColor(argv[0]); arg3 = to_FXColor(argv[1]);
    FXRGBImage_hgradient(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXRGBImage_vgradient(int argc, VALUE *argv, VALUE self) { FXRGBImage *arg1 = (FXRGBImage *) 0 ;
    FXColor arg2 ; FXColor arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRGBImage, 1); arg2 = to_FXColor(argv[0]); arg3 = to_FXColor(argv[1]);
    FXRGBImage_vgradient(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXRGBImage_gradient(int argc, VALUE *argv, VALUE self) { FXRGBImage *arg1 = (FXRGBImage *) 0 ; FXColor arg2 ;
    FXColor arg3 ; FXColor arg4 ; FXColor arg5 ; if ((argc < 4) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRGBImage, 1); arg2 = to_FXColor(argv[0]); arg3 = to_FXColor(argv[1]);
    arg4 = to_FXColor(argv[2]); arg5 = to_FXColor(argv[3]); FXRGBImage_gradient(arg1,arg2,arg3,arg4,arg5); return Qnil; }
static VALUE _wrap_FXRGBImage_blend(int argc, VALUE *argv, VALUE self) { FXRGBImage *arg1 = (FXRGBImage *) 0 ; FXColor arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRGBImage, 1); arg2 = to_FXColor(argv[0]); FXRGBImage_blend(arg1,arg2);
    return Qnil; }
static VALUE _wrap_FXRGBImage_savePixels(int argc, VALUE *argv, VALUE self) { FXRGBImage *arg1 = (FXRGBImage *) 0 ;
    FXStream *arg2 = 0 ; FXbool result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRGBImage, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    result = (FXbool)FXRGBImage_savePixels((FXRGBImage const *)arg1,*arg2); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXRGBImage_loadPixels(int argc, VALUE *argv, VALUE self) { FXRGBImage *arg1 = (FXRGBImage *) 0 ;
    FXStream *arg2 = 0 ; FXbool result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRGBImage, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    result = (FXbool)FXRGBImage_loadPixels(arg1,*arg2); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_fxloadRGB(int argc, VALUE *argv, VALUE self) { FXStream *arg1 = 0 ; VALUE result; VALUE vresult = Qnil;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXStream, 1); if (arg1 == NULL) rb_raise(rb_eTypeError, "null reference");
    result = (VALUE)fxloadRGB(*arg1); vresult = result; return vresult; }
static VALUE _wrap_fxsaveRGB(int argc, VALUE *argv, VALUE self) { FXStream *arg1 = 0 ; FXColor *arg2 = (FXColor *) 0 ;
    FXint arg3 ; FXint arg4 ; FXbool result; VALUE vresult = Qnil; if ((argc < 4) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXStream, 1); if (arg1 == NULL) rb_raise(rb_eTypeError, "null reference");
    { arg2=NULL; if(argv[1]!=Qnil){ Check_Type(argv[1],T_ARRAY); if(FXMALLOC(&arg2,FXColor,RARRAY(argv[1])->len)){
                for(long i=0; i<RARRAY(argv[1])->len; i++){ arg2[i]=static_cast<FXColor>(NUM2UINT(rb_ary_entry(argv[1],i))); }  }
             }  }  arg3 = NUM2INT(argv[2]); arg4 = NUM2INT(argv[3]);
    result = (FXbool)fxsaveRGB(*arg1,(FXColor const *)arg2,arg3,arg4); vresult = result ? Qtrue : Qfalse; FXFREE(&arg2);
    return vresult; }
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE _wrap_FXTGAImage_allocate(VALUE self) {
#else
     static VALUE _wrap_FXTGAImage_allocate(int argc, VALUE *argv, VALUE self) {
#endif
         VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_FXTGAImage);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
         return vresult; }
static VALUE _wrap_new_FXTGAImage(int argc, VALUE *argv, VALUE self) { FXApp *arg1 = (FXApp *) 0 ; void *arg2 = (void *) 0 ;
    FXuint arg3 = (FXuint) 0 ; FXint arg4 = (FXint) 1 ; FXint arg5 = (FXint) 1 ; FXTGAImage *result;
    if ((argc < 1) || (argc > 5)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXApp, 1); if (argc > 1) { { if (argv[1] != Qnil) {
                Check_Type(argv[1], T_STRING); arg2 = reinterpret_cast<void *>(RSTRING(argv[1])->ptr); }  else { arg2 = NULL; }
             }  }  if (argc > 2) { arg3 = NUM2UINT(argv[2]); }  if (argc > 3) { arg4 = NUM2INT(argv[3]); }  if (argc > 4) {
        arg5 = NUM2INT(argv[4]); }  { result = (FXTGAImage *)new_FXTGAImage(arg1,(void const *)arg2,arg3,arg4,arg5);
        DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result); if(rb_block_given_p()){ rb_yield(self); }  }  return self; }
static void
free_FXTGAImage(FXTGAImage *arg1) {
    delete arg1;
}
static VALUE _wrap_FXTGAImage_save(int argc, VALUE *argv, VALUE self) { FXTGAImage *arg1 = (FXTGAImage *) 0 ;
    FXStream *arg2 = 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTGAImage, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXTGAImage_save((FXTGAImage const *)arg1,*arg2); return Qnil; }
static VALUE _wrap_FXTGAImage_load(int argc, VALUE *argv, VALUE self) { FXTGAImage *arg1 = (FXTGAImage *) 0 ;
    FXStream *arg2 = 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTGAImage, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXTGAImage_load(arg1,*arg2); return Qnil; }
static VALUE _wrap_FXTGAImage_create(int argc, VALUE *argv, VALUE self) { FXTGAImage *arg1 = (FXTGAImage *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTGAImage, 1); FXTGAImage_create(arg1); return Qnil; }
static VALUE _wrap_FXTGAImage_detach(int argc, VALUE *argv, VALUE self) { FXTGAImage *arg1 = (FXTGAImage *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTGAImage, 1); FXTGAImage_detach(arg1); return Qnil; }
static VALUE _wrap_FXTGAImage_destroy(int argc, VALUE *argv, VALUE self) { FXTGAImage *arg1 = (FXTGAImage *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTGAImage, 1); FXTGAImage_destroy(arg1); return Qnil; }
static VALUE _wrap_FXTGAImage_resize(int argc, VALUE *argv, VALUE self) { FXTGAImage *arg1 = (FXTGAImage *) 0 ; FXint arg2 ;
    FXint arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTGAImage, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    FXTGAImage_resize(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXTGAImage_restore(int argc, VALUE *argv, VALUE self) { FXTGAImage *arg1 = (FXTGAImage *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTGAImage, 1); FXTGAImage_restore(arg1); return Qnil; }
static VALUE _wrap_FXTGAImage_render(int argc, VALUE *argv, VALUE self) { FXTGAImage *arg1 = (FXTGAImage *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTGAImage, 1); FXTGAImage_render(arg1); return Qnil; }
static VALUE _wrap_FXTGAImage_release(int argc, VALUE *argv, VALUE self) { FXTGAImage *arg1 = (FXTGAImage *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTGAImage, 1); FXTGAImage_release(arg1); return Qnil; }
static VALUE _wrap_FXTGAImage_scale(int argc, VALUE *argv, VALUE self) { FXTGAImage *arg1 = (FXTGAImage *) 0 ; FXint arg2 ;
    FXint arg3 ; FXint arg4 = (FXint) 0 ; if ((argc < 2) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTGAImage, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    if (argc > 2) { arg4 = NUM2INT(argv[2]); }  FXTGAImage_scale(arg1,arg2,arg3,arg4); return Qnil; }
static VALUE _wrap_FXTGAImage_mirror(int argc, VALUE *argv, VALUE self) { FXTGAImage *arg1 = (FXTGAImage *) 0 ; FXbool arg2 ;
    FXbool arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTGAImage, 1); arg2 = to_FXbool(argv[0]); arg3 = to_FXbool(argv[1]);
    FXTGAImage_mirror(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXTGAImage_rotate(int argc, VALUE *argv, VALUE self) { FXTGAImage *arg1 = (FXTGAImage *) 0 ; FXint arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTGAImage, 1); arg2 = NUM2INT(argv[0]); FXTGAImage_rotate(arg1,arg2);
    return Qnil; }
static VALUE _wrap_FXTGAImage_crop(int argc, VALUE *argv, VALUE self) { FXTGAImage *arg1 = (FXTGAImage *) 0 ; FXint arg2 ;
    FXint arg3 ; FXint arg4 ; FXint arg5 ; if ((argc < 4) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTGAImage, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    arg4 = NUM2INT(argv[2]); arg5 = NUM2INT(argv[3]); FXTGAImage_crop(arg1,arg2,arg3,arg4,arg5); return Qnil; }
static VALUE _wrap_FXTGAImage_fill(int argc, VALUE *argv, VALUE self) { FXTGAImage *arg1 = (FXTGAImage *) 0 ; FXColor arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTGAImage, 1); arg2 = to_FXColor(argv[0]); FXTGAImage_fill(arg1,arg2);
    return Qnil; }
static VALUE _wrap_FXTGAImage_fade(int argc, VALUE *argv, VALUE self) { FXTGAImage *arg1 = (FXTGAImage *) 0 ; FXColor arg2 ;
    FXint arg3 = (FXint) 255 ; if ((argc < 1) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTGAImage, 1); arg2 = to_FXColor(argv[0]); if (argc > 1) {
        arg3 = NUM2INT(argv[1]); }  FXTGAImage_fade(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXTGAImage_xshear(int argc, VALUE *argv, VALUE self) { FXTGAImage *arg1 = (FXTGAImage *) 0 ; FXint arg2 ;
    FXColor arg3 = (FXColor) 0 ; if ((argc < 1) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTGAImage, 1); arg2 = NUM2INT(argv[0]); if (argc > 1) {
        arg3 = to_FXColor(argv[1]); }  FXTGAImage_xshear(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXTGAImage_yshear(int argc, VALUE *argv, VALUE self) { FXTGAImage *arg1 = (FXTGAImage *) 0 ; FXint arg2 ;
    FXColor arg3 = (FXColor) 0 ; if ((argc < 1) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTGAImage, 1); arg2 = NUM2INT(argv[0]); if (argc > 1) {
        arg3 = to_FXColor(argv[1]); }  FXTGAImage_yshear(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXTGAImage_hgradient(int argc, VALUE *argv, VALUE self) { FXTGAImage *arg1 = (FXTGAImage *) 0 ;
    FXColor arg2 ; FXColor arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTGAImage, 1); arg2 = to_FXColor(argv[0]); arg3 = to_FXColor(argv[1]);
    FXTGAImage_hgradient(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXTGAImage_vgradient(int argc, VALUE *argv, VALUE self) { FXTGAImage *arg1 = (FXTGAImage *) 0 ;
    FXColor arg2 ; FXColor arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTGAImage, 1); arg2 = to_FXColor(argv[0]); arg3 = to_FXColor(argv[1]);
    FXTGAImage_vgradient(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXTGAImage_gradient(int argc, VALUE *argv, VALUE self) { FXTGAImage *arg1 = (FXTGAImage *) 0 ; FXColor arg2 ;
    FXColor arg3 ; FXColor arg4 ; FXColor arg5 ; if ((argc < 4) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTGAImage, 1); arg2 = to_FXColor(argv[0]); arg3 = to_FXColor(argv[1]);
    arg4 = to_FXColor(argv[2]); arg5 = to_FXColor(argv[3]); FXTGAImage_gradient(arg1,arg2,arg3,arg4,arg5); return Qnil; }
static VALUE _wrap_FXTGAImage_blend(int argc, VALUE *argv, VALUE self) { FXTGAImage *arg1 = (FXTGAImage *) 0 ; FXColor arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTGAImage, 1); arg2 = to_FXColor(argv[0]); FXTGAImage_blend(arg1,arg2);
    return Qnil; }
static VALUE _wrap_FXTGAImage_savePixels(int argc, VALUE *argv, VALUE self) { FXTGAImage *arg1 = (FXTGAImage *) 0 ;
    FXStream *arg2 = 0 ; FXbool result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTGAImage, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    result = (FXbool)FXTGAImage_savePixels((FXTGAImage const *)arg1,*arg2); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXTGAImage_loadPixels(int argc, VALUE *argv, VALUE self) { FXTGAImage *arg1 = (FXTGAImage *) 0 ;
    FXStream *arg2 = 0 ; FXbool result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTGAImage, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    result = (FXbool)FXTGAImage_loadPixels(arg1,*arg2); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_fxloadTGA(int argc, VALUE *argv, VALUE self) { FXStream *arg1 = 0 ; VALUE result; VALUE vresult = Qnil;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXStream, 1); if (arg1 == NULL) rb_raise(rb_eTypeError, "null reference");
    result = (VALUE)fxloadTGA(*arg1); vresult = result; return vresult; }
static VALUE _wrap_fxsaveTGA(int argc, VALUE *argv, VALUE self) { FXStream *arg1 = 0 ; FXColor *arg2 = (FXColor *) 0 ;
    FXint arg3 ; FXint arg4 ; FXbool result; VALUE vresult = Qnil; if ((argc < 4) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXStream, 1); if (arg1 == NULL) rb_raise(rb_eTypeError, "null reference");
    { arg2=NULL; if(argv[1]!=Qnil){ Check_Type(argv[1],T_ARRAY); if(FXMALLOC(&arg2,FXColor,RARRAY(argv[1])->len)){
                for(long i=0; i<RARRAY(argv[1])->len; i++){ arg2[i]=static_cast<FXColor>(NUM2UINT(rb_ary_entry(argv[1],i))); }  }
             }  }  arg3 = NUM2INT(argv[2]); arg4 = NUM2INT(argv[3]);
    result = (FXbool)fxsaveTGA(*arg1,(FXColor const *)arg2,arg3,arg4); vresult = result ? Qtrue : Qfalse; FXFREE(&arg2);
    return vresult; }
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE _wrap_FXTIFImage_allocate(VALUE self) {
#else
     static VALUE _wrap_FXTIFImage_allocate(int argc, VALUE *argv, VALUE self) {
#endif
         VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_FXTIFImage);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
         return vresult; }
static VALUE _wrap_new_FXTIFImage(int argc, VALUE *argv, VALUE self) { FXApp *arg1 = (FXApp *) 0 ; void *arg2 = (void *) 0 ;
    FXuint arg3 = (FXuint) 0 ; FXint arg4 = (FXint) 1 ; FXint arg5 = (FXint) 1 ; FXTIFImage *result;
    if ((argc < 1) || (argc > 5)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXApp, 1); if (argc > 1) { { if (argv[1] != Qnil) {
                Check_Type(argv[1], T_STRING); arg2 = reinterpret_cast<void *>(RSTRING(argv[1])->ptr); }  else { arg2 = NULL; }
             }  }  if (argc > 2) { arg3 = NUM2UINT(argv[2]); }  if (argc > 3) { arg4 = NUM2INT(argv[3]); }  if (argc > 4) {
        arg5 = NUM2INT(argv[4]); }  { result = (FXTIFImage *)new_FXTIFImage(arg1,(void const *)arg2,arg3,arg4,arg5);
        DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result); if(rb_block_given_p()){ rb_yield(self); }  }  return self; }
static VALUE _wrap_FXTIFImage_setCodec(int argc, VALUE *argv, VALUE self) { FXTIFImage *arg1 = (FXTIFImage *) 0 ; FXuint arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTIFImage, 1); arg2 = NUM2UINT(argv[0]); (arg1)->setCodec(arg2);
    return Qnil; }
static VALUE _wrap_FXTIFImage_getCodec(int argc, VALUE *argv, VALUE self) { FXTIFImage *arg1 = (FXTIFImage *) 0 ; FXuint result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTIFImage, 1); result = (FXuint)((FXTIFImage const *)arg1)->getCodec();
    vresult = UINT2NUM(result); return vresult; }
static void
free_FXTIFImage(FXTIFImage *arg1) {
    delete arg1;
}
static VALUE _wrap_FXTIFImage_save(int argc, VALUE *argv, VALUE self) { FXTIFImage *arg1 = (FXTIFImage *) 0 ;
    FXStream *arg2 = 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTIFImage, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXTIFImage_save((FXTIFImage const *)arg1,*arg2); return Qnil; }
static VALUE _wrap_FXTIFImage_load(int argc, VALUE *argv, VALUE self) { FXTIFImage *arg1 = (FXTIFImage *) 0 ;
    FXStream *arg2 = 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTIFImage, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXTIFImage_load(arg1,*arg2); return Qnil; }
static VALUE _wrap_FXTIFImage_create(int argc, VALUE *argv, VALUE self) { FXTIFImage *arg1 = (FXTIFImage *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTIFImage, 1); FXTIFImage_create(arg1); return Qnil; }
static VALUE _wrap_FXTIFImage_detach(int argc, VALUE *argv, VALUE self) { FXTIFImage *arg1 = (FXTIFImage *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTIFImage, 1); FXTIFImage_detach(arg1); return Qnil; }
static VALUE _wrap_FXTIFImage_destroy(int argc, VALUE *argv, VALUE self) { FXTIFImage *arg1 = (FXTIFImage *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTIFImage, 1); FXTIFImage_destroy(arg1); return Qnil; }
static VALUE _wrap_FXTIFImage_resize(int argc, VALUE *argv, VALUE self) { FXTIFImage *arg1 = (FXTIFImage *) 0 ; FXint arg2 ;
    FXint arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTIFImage, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    FXTIFImage_resize(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXTIFImage_restore(int argc, VALUE *argv, VALUE self) { FXTIFImage *arg1 = (FXTIFImage *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTIFImage, 1); FXTIFImage_restore(arg1); return Qnil; }
static VALUE _wrap_FXTIFImage_render(int argc, VALUE *argv, VALUE self) { FXTIFImage *arg1 = (FXTIFImage *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTIFImage, 1); FXTIFImage_render(arg1); return Qnil; }
static VALUE _wrap_FXTIFImage_release(int argc, VALUE *argv, VALUE self) { FXTIFImage *arg1 = (FXTIFImage *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTIFImage, 1); FXTIFImage_release(arg1); return Qnil; }
static VALUE _wrap_FXTIFImage_scale(int argc, VALUE *argv, VALUE self) { FXTIFImage *arg1 = (FXTIFImage *) 0 ; FXint arg2 ;
    FXint arg3 ; FXint arg4 = (FXint) 0 ; if ((argc < 2) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTIFImage, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    if (argc > 2) { arg4 = NUM2INT(argv[2]); }  FXTIFImage_scale(arg1,arg2,arg3,arg4); return Qnil; }
static VALUE _wrap_FXTIFImage_mirror(int argc, VALUE *argv, VALUE self) { FXTIFImage *arg1 = (FXTIFImage *) 0 ; FXbool arg2 ;
    FXbool arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTIFImage, 1); arg2 = to_FXbool(argv[0]); arg3 = to_FXbool(argv[1]);
    FXTIFImage_mirror(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXTIFImage_rotate(int argc, VALUE *argv, VALUE self) { FXTIFImage *arg1 = (FXTIFImage *) 0 ; FXint arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTIFImage, 1); arg2 = NUM2INT(argv[0]); FXTIFImage_rotate(arg1,arg2);
    return Qnil; }
static VALUE _wrap_FXTIFImage_crop(int argc, VALUE *argv, VALUE self) { FXTIFImage *arg1 = (FXTIFImage *) 0 ; FXint arg2 ;
    FXint arg3 ; FXint arg4 ; FXint arg5 ; if ((argc < 4) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTIFImage, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    arg4 = NUM2INT(argv[2]); arg5 = NUM2INT(argv[3]); FXTIFImage_crop(arg1,arg2,arg3,arg4,arg5); return Qnil; }
static VALUE _wrap_FXTIFImage_fill(int argc, VALUE *argv, VALUE self) { FXTIFImage *arg1 = (FXTIFImage *) 0 ; FXColor arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTIFImage, 1); arg2 = to_FXColor(argv[0]); FXTIFImage_fill(arg1,arg2);
    return Qnil; }
static VALUE _wrap_FXTIFImage_fade(int argc, VALUE *argv, VALUE self) { FXTIFImage *arg1 = (FXTIFImage *) 0 ; FXColor arg2 ;
    FXint arg3 = (FXint) 255 ; if ((argc < 1) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTIFImage, 1); arg2 = to_FXColor(argv[0]); if (argc > 1) {
        arg3 = NUM2INT(argv[1]); }  FXTIFImage_fade(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXTIFImage_xshear(int argc, VALUE *argv, VALUE self) { FXTIFImage *arg1 = (FXTIFImage *) 0 ; FXint arg2 ;
    FXColor arg3 = (FXColor) 0 ; if ((argc < 1) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTIFImage, 1); arg2 = NUM2INT(argv[0]); if (argc > 1) {
        arg3 = to_FXColor(argv[1]); }  FXTIFImage_xshear(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXTIFImage_yshear(int argc, VALUE *argv, VALUE self) { FXTIFImage *arg1 = (FXTIFImage *) 0 ; FXint arg2 ;
    FXColor arg3 = (FXColor) 0 ; if ((argc < 1) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTIFImage, 1); arg2 = NUM2INT(argv[0]); if (argc > 1) {
        arg3 = to_FXColor(argv[1]); }  FXTIFImage_yshear(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXTIFImage_hgradient(int argc, VALUE *argv, VALUE self) { FXTIFImage *arg1 = (FXTIFImage *) 0 ;
    FXColor arg2 ; FXColor arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTIFImage, 1); arg2 = to_FXColor(argv[0]); arg3 = to_FXColor(argv[1]);
    FXTIFImage_hgradient(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXTIFImage_vgradient(int argc, VALUE *argv, VALUE self) { FXTIFImage *arg1 = (FXTIFImage *) 0 ;
    FXColor arg2 ; FXColor arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTIFImage, 1); arg2 = to_FXColor(argv[0]); arg3 = to_FXColor(argv[1]);
    FXTIFImage_vgradient(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXTIFImage_gradient(int argc, VALUE *argv, VALUE self) { FXTIFImage *arg1 = (FXTIFImage *) 0 ; FXColor arg2 ;
    FXColor arg3 ; FXColor arg4 ; FXColor arg5 ; if ((argc < 4) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTIFImage, 1); arg2 = to_FXColor(argv[0]); arg3 = to_FXColor(argv[1]);
    arg4 = to_FXColor(argv[2]); arg5 = to_FXColor(argv[3]); FXTIFImage_gradient(arg1,arg2,arg3,arg4,arg5); return Qnil; }
static VALUE _wrap_FXTIFImage_blend(int argc, VALUE *argv, VALUE self) { FXTIFImage *arg1 = (FXTIFImage *) 0 ; FXColor arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTIFImage, 1); arg2 = to_FXColor(argv[0]); FXTIFImage_blend(arg1,arg2);
    return Qnil; }
static VALUE _wrap_FXTIFImage_savePixels(int argc, VALUE *argv, VALUE self) { FXTIFImage *arg1 = (FXTIFImage *) 0 ;
    FXStream *arg2 = 0 ; FXbool result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTIFImage, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    result = (FXbool)FXTIFImage_savePixels((FXTIFImage const *)arg1,*arg2); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXTIFImage_loadPixels(int argc, VALUE *argv, VALUE self) { FXTIFImage *arg1 = (FXTIFImage *) 0 ;
    FXStream *arg2 = 0 ; FXbool result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTIFImage, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    result = (FXbool)FXTIFImage_loadPixels(arg1,*arg2); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_fxloadTIF(int argc, VALUE *argv, VALUE self) { FXStream *arg1 = 0 ; VALUE result; VALUE vresult = Qnil;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXStream, 1); if (arg1 == NULL) rb_raise(rb_eTypeError, "null reference");
    result = (VALUE)fxloadTIF(*arg1); vresult = result; return vresult; }
static VALUE _wrap_fxsaveTIF(int argc, VALUE *argv, VALUE self) { FXStream *arg1 = 0 ; FXColor *arg2 = (FXColor *) 0 ;
    FXint arg3 ; FXint arg4 ; FXushort arg5 ; FXbool result; VALUE vresult = Qnil; if ((argc < 5) || (argc > 5))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 5)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXStream, 1); if (arg1 == NULL) rb_raise(rb_eTypeError, "null reference");
    { arg2=NULL; if(argv[1]!=Qnil){ Check_Type(argv[1],T_ARRAY); if(FXMALLOC(&arg2,FXColor,RARRAY(argv[1])->len)){
                for(long i=0; i<RARRAY(argv[1])->len; i++){ arg2[i]=static_cast<FXColor>(NUM2UINT(rb_ary_entry(argv[1],i))); }  }
             }  }  arg3 = NUM2INT(argv[2]); arg4 = NUM2INT(argv[3]); arg5 = NUM2USHRT(argv[4]);
    result = (FXbool)fxsaveTIF(*arg1,(FXColor const *)arg2,arg3,arg4,arg5); vresult = result ? Qtrue : Qfalse; FXFREE(&arg2);
    return vresult; }
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE _wrap_FXXBMImage_allocate(VALUE self) {
#else
     static VALUE _wrap_FXXBMImage_allocate(int argc, VALUE *argv, VALUE self) {
#endif
         VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_FXXBMImage);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
         return vresult; }
static VALUE _wrap_new_FXXBMImage(int argc, VALUE *argv, VALUE self) { FXApp *arg1 = (FXApp *) 0 ;
    FXuchar *arg2 = (FXuchar *) 0 ; FXuchar *arg3 = (FXuchar *) 0 ; FXuint arg4 = (FXuint) 0 ; FXint arg5 = (FXint) 1 ;
    FXint arg6 = (FXint) 1 ; FXXBMImage *result; if ((argc < 1) || (argc > 6))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXApp, 1); if (argc > 1) {
        SWIG_ConvertPtr(argv[1], (void **) &arg2, SWIGTYPE_p_FXuchar, 1); }  if (argc > 2) {
        SWIG_ConvertPtr(argv[2], (void **) &arg3, SWIGTYPE_p_FXuchar, 1); }  if (argc > 3) { arg4 = NUM2UINT(argv[3]); } 
    if (argc > 4) { arg5 = NUM2INT(argv[4]); }  if (argc > 5) { arg6 = NUM2INT(argv[5]); }  {
        result = (FXXBMImage *)new_FXXBMImage(arg1,(FXuchar const *)arg2,(FXuchar const *)arg3,arg4,arg5,arg6);
        DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result); if(rb_block_given_p()){ rb_yield(self); }  }  return self; }
static void
free_FXXBMImage(FXXBMImage *arg1) {
    delete arg1;
}
static VALUE _wrap_FXXBMImage_save(int argc, VALUE *argv, VALUE self) { FXXBMImage *arg1 = (FXXBMImage *) 0 ;
    FXStream *arg2 = 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXXBMImage, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXXBMImage_save((FXXBMImage const *)arg1,*arg2); return Qnil; }
static VALUE _wrap_FXXBMImage_load(int argc, VALUE *argv, VALUE self) { FXXBMImage *arg1 = (FXXBMImage *) 0 ;
    FXStream *arg2 = 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXXBMImage, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXXBMImage_load(arg1,*arg2); return Qnil; }
static VALUE _wrap_FXXBMImage_create(int argc, VALUE *argv, VALUE self) { FXXBMImage *arg1 = (FXXBMImage *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXXBMImage, 1); FXXBMImage_create(arg1); return Qnil; }
static VALUE _wrap_FXXBMImage_detach(int argc, VALUE *argv, VALUE self) { FXXBMImage *arg1 = (FXXBMImage *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXXBMImage, 1); FXXBMImage_detach(arg1); return Qnil; }
static VALUE _wrap_FXXBMImage_destroy(int argc, VALUE *argv, VALUE self) { FXXBMImage *arg1 = (FXXBMImage *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXXBMImage, 1); FXXBMImage_destroy(arg1); return Qnil; }
static VALUE _wrap_FXXBMImage_resize(int argc, VALUE *argv, VALUE self) { FXXBMImage *arg1 = (FXXBMImage *) 0 ; FXint arg2 ;
    FXint arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXXBMImage, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    FXXBMImage_resize(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXXBMImage_restore(int argc, VALUE *argv, VALUE self) { FXXBMImage *arg1 = (FXXBMImage *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXXBMImage, 1); FXXBMImage_restore(arg1); return Qnil; }
static VALUE _wrap_FXXBMImage_render(int argc, VALUE *argv, VALUE self) { FXXBMImage *arg1 = (FXXBMImage *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXXBMImage, 1); FXXBMImage_render(arg1); return Qnil; }
static VALUE _wrap_FXXBMImage_release(int argc, VALUE *argv, VALUE self) { FXXBMImage *arg1 = (FXXBMImage *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXXBMImage, 1); FXXBMImage_release(arg1); return Qnil; }
static VALUE _wrap_FXXBMImage_scale(int argc, VALUE *argv, VALUE self) { FXXBMImage *arg1 = (FXXBMImage *) 0 ; FXint arg2 ;
    FXint arg3 ; FXint arg4 = (FXint) 0 ; if ((argc < 2) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXXBMImage, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    if (argc > 2) { arg4 = NUM2INT(argv[2]); }  FXXBMImage_scale(arg1,arg2,arg3,arg4); return Qnil; }
static VALUE _wrap_FXXBMImage_mirror(int argc, VALUE *argv, VALUE self) { FXXBMImage *arg1 = (FXXBMImage *) 0 ; FXbool arg2 ;
    FXbool arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXXBMImage, 1); arg2 = to_FXbool(argv[0]); arg3 = to_FXbool(argv[1]);
    FXXBMImage_mirror(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXXBMImage_rotate(int argc, VALUE *argv, VALUE self) { FXXBMImage *arg1 = (FXXBMImage *) 0 ; FXint arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXXBMImage, 1); arg2 = NUM2INT(argv[0]); FXXBMImage_rotate(arg1,arg2);
    return Qnil; }
static VALUE _wrap_FXXBMImage_crop(int argc, VALUE *argv, VALUE self) { FXXBMImage *arg1 = (FXXBMImage *) 0 ; FXint arg2 ;
    FXint arg3 ; FXint arg4 ; FXint arg5 ; if ((argc < 4) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXXBMImage, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    arg4 = NUM2INT(argv[2]); arg5 = NUM2INT(argv[3]); FXXBMImage_crop(arg1,arg2,arg3,arg4,arg5); return Qnil; }
static VALUE _wrap_FXXBMImage_fill(int argc, VALUE *argv, VALUE self) { FXXBMImage *arg1 = (FXXBMImage *) 0 ; FXColor arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXXBMImage, 1); arg2 = to_FXColor(argv[0]); FXXBMImage_fill(arg1,arg2);
    return Qnil; }
static VALUE _wrap_FXXBMImage_fade(int argc, VALUE *argv, VALUE self) { FXXBMImage *arg1 = (FXXBMImage *) 0 ; FXColor arg2 ;
    FXint arg3 = (FXint) 255 ; if ((argc < 1) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXXBMImage, 1); arg2 = to_FXColor(argv[0]); if (argc > 1) {
        arg3 = NUM2INT(argv[1]); }  FXXBMImage_fade(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXXBMImage_xshear(int argc, VALUE *argv, VALUE self) { FXXBMImage *arg1 = (FXXBMImage *) 0 ; FXint arg2 ;
    FXColor arg3 = (FXColor) 0 ; if ((argc < 1) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXXBMImage, 1); arg2 = NUM2INT(argv[0]); if (argc > 1) {
        arg3 = to_FXColor(argv[1]); }  FXXBMImage_xshear(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXXBMImage_yshear(int argc, VALUE *argv, VALUE self) { FXXBMImage *arg1 = (FXXBMImage *) 0 ; FXint arg2 ;
    FXColor arg3 = (FXColor) 0 ; if ((argc < 1) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXXBMImage, 1); arg2 = NUM2INT(argv[0]); if (argc > 1) {
        arg3 = to_FXColor(argv[1]); }  FXXBMImage_yshear(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXXBMImage_hgradient(int argc, VALUE *argv, VALUE self) { FXXBMImage *arg1 = (FXXBMImage *) 0 ;
    FXColor arg2 ; FXColor arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXXBMImage, 1); arg2 = to_FXColor(argv[0]); arg3 = to_FXColor(argv[1]);
    FXXBMImage_hgradient(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXXBMImage_vgradient(int argc, VALUE *argv, VALUE self) { FXXBMImage *arg1 = (FXXBMImage *) 0 ;
    FXColor arg2 ; FXColor arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXXBMImage, 1); arg2 = to_FXColor(argv[0]); arg3 = to_FXColor(argv[1]);
    FXXBMImage_vgradient(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXXBMImage_gradient(int argc, VALUE *argv, VALUE self) { FXXBMImage *arg1 = (FXXBMImage *) 0 ; FXColor arg2 ;
    FXColor arg3 ; FXColor arg4 ; FXColor arg5 ; if ((argc < 4) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXXBMImage, 1); arg2 = to_FXColor(argv[0]); arg3 = to_FXColor(argv[1]);
    arg4 = to_FXColor(argv[2]); arg5 = to_FXColor(argv[3]); FXXBMImage_gradient(arg1,arg2,arg3,arg4,arg5); return Qnil; }
static VALUE _wrap_FXXBMImage_blend(int argc, VALUE *argv, VALUE self) { FXXBMImage *arg1 = (FXXBMImage *) 0 ; FXColor arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXXBMImage, 1); arg2 = to_FXColor(argv[0]); FXXBMImage_blend(arg1,arg2);
    return Qnil; }
static VALUE _wrap_FXXBMImage_savePixels(int argc, VALUE *argv, VALUE self) { FXXBMImage *arg1 = (FXXBMImage *) 0 ;
    FXStream *arg2 = 0 ; FXbool result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXXBMImage, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    result = (FXbool)FXXBMImage_savePixels((FXXBMImage const *)arg1,*arg2); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXXBMImage_loadPixels(int argc, VALUE *argv, VALUE self) { FXXBMImage *arg1 = (FXXBMImage *) 0 ;
    FXStream *arg2 = 0 ; FXbool result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXXBMImage, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    result = (FXbool)FXXBMImage_loadPixels(arg1,*arg2); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_fxloadXBM__SWIG_0(int argc, VALUE *argv, VALUE self) { FXuchar *arg1 = (FXuchar *) 0 ;
    FXuchar *arg2 = (FXuchar *) 0 ; FXint arg3 ; FXint arg4 ; VALUE result; VALUE vresult = Qnil; if ((argc < 4) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXuchar, 1);
    SWIG_ConvertPtr(argv[1], (void **) &arg2, SWIGTYPE_p_FXuchar, 1); arg3 = NUM2INT(argv[2]); arg4 = NUM2INT(argv[3]);
    result = (VALUE)fxloadXBM((FXuchar const *)arg1,(FXuchar const *)arg2,arg3,arg4); vresult = result; return vresult; }
static VALUE _wrap_fxloadXBM__SWIG_1(int argc, VALUE *argv, VALUE self) { FXStream *arg1 = 0 ; VALUE result;
    VALUE vresult = Qnil; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXStream, 1); if (arg1 == NULL) rb_raise(rb_eTypeError, "null reference");
    result = (VALUE)fxloadXBM(*arg1); vresult = result; return vresult; }
static VALUE _wrap_fxloadXBM(int nargs, VALUE *args, VALUE self) { int argc; VALUE argv[4]; int ii; argc = nargs;
    for (ii = 0; (ii < argc) && (ii < 4); ii++) { argv[ii] = args[ii]; }  if (argc == 1) { int _v; { void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXStream, 0) != -1)) ? 1 : 0; }
         if (_v) { return _wrap_fxloadXBM__SWIG_1(nargs, args, self);}  }  if (argc == 4) { int _v; { void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXuchar, 0) != -1)) ? 1 : 0; }
         if (_v) { { void *ptr;
                _v = (NIL_P(argv[1]) || (TYPE(argv[1]) == T_DATA && SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_FXuchar, 0) != -1)) ? 1 : 0; }
             if (_v) { { _v = ((TYPE(argv[2]) == T_FIXNUM) || (TYPE(argv[2]) == T_BIGNUM)) ? 1 : 0; }  if (_v) { {
                        _v = ((TYPE(argv[3]) == T_FIXNUM) || (TYPE(argv[3]) == T_BIGNUM)) ? 1 : 0; }  if (_v) {
                        return _wrap_fxloadXBM__SWIG_0(nargs, args, self);}  }  }  }  } 
    rb_raise(rb_eArgError, "No matching function for overloaded 'fxloadXBM'"); return Qnil; }
static VALUE _wrap_fxsaveXBM(int argc, VALUE *argv, VALUE self) { FXStream *arg1 = 0 ; FXColor *arg2 = (FXColor *) 0 ;
    FXint arg3 ; FXint arg4 ; FXint arg5 = (FXint) -1 ; FXint arg6 = (FXint) -1 ; FXbool result; VALUE vresult = Qnil;
    if ((argc < 4) || (argc > 6)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXStream, 1); if (arg1 == NULL) rb_raise(rb_eTypeError, "null reference");
    { arg2=NULL; if(argv[1]!=Qnil){ Check_Type(argv[1],T_ARRAY); if(FXMALLOC(&arg2,FXColor,RARRAY(argv[1])->len)){
                for(long i=0; i<RARRAY(argv[1])->len; i++){ arg2[i]=static_cast<FXColor>(NUM2UINT(rb_ary_entry(argv[1],i))); }  }
             }  }  arg3 = NUM2INT(argv[2]); arg4 = NUM2INT(argv[3]); if (argc > 4) { arg5 = NUM2INT(argv[4]); }  if (argc > 5) {
        arg6 = NUM2INT(argv[5]); }  result = (FXbool)fxsaveXBM(*arg1,(FXColor const *)arg2,arg3,arg4,arg5,arg6);
    vresult = result ? Qtrue : Qfalse; FXFREE(&arg2); return vresult; }
static VALUE _wrap_fxsavePS(int argc, VALUE *argv, VALUE self) { FXStream *arg1 = 0 ; FXColor *arg2 = (FXColor *) 0 ;
    FXint arg3 ; FXint arg4 ; FXint arg5 = (FXint) 612 ; FXint arg6 = (FXint) 792 ; FXint arg7 = (FXint) 35 ;
    FXbool arg8 = (FXbool) 1 ; FXbool result; VALUE vresult = Qnil; if ((argc < 4) || (argc > 8))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXStream, 1); if (arg1 == NULL) rb_raise(rb_eTypeError, "null reference");
    { arg2=NULL; if(argv[1]!=Qnil){ Check_Type(argv[1],T_ARRAY); if(FXMALLOC(&arg2,FXColor,RARRAY(argv[1])->len)){
                for(long i=0; i<RARRAY(argv[1])->len; i++){ arg2[i]=static_cast<FXColor>(NUM2UINT(rb_ary_entry(argv[1],i))); }  }
             }  }  arg3 = NUM2INT(argv[2]); arg4 = NUM2INT(argv[3]); if (argc > 4) { arg5 = NUM2INT(argv[4]); }  if (argc > 5) {
        arg6 = NUM2INT(argv[5]); }  if (argc > 6) { arg7 = NUM2INT(argv[6]); }  if (argc > 7) { arg8 = to_FXbool(argv[7]); } 
    result = (FXbool)fxsavePS(*arg1,(FXColor const *)arg2,arg3,arg4,arg5,arg6,arg7,arg8); vresult = result ? Qtrue : Qfalse;
    FXFREE(&arg2); return vresult; }
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE _wrap_FXXPMImage_allocate(VALUE self) {
#else
     static VALUE _wrap_FXXPMImage_allocate(int argc, VALUE *argv, VALUE self) {
#endif
         VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_FXXPMImage);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
         return vresult; }
static VALUE _wrap_new_FXXPMImage(int argc, VALUE *argv, VALUE self) { FXApp *arg1 = (FXApp *) 0 ;
    FXchar **arg2 = (FXchar **) 0 ; FXuint arg3 = (FXuint) 0 ; FXint arg4 = (FXint) 1 ; FXint arg5 = (FXint) 1 ;
    FXXPMImage *result; if ((argc < 1) || (argc > 5)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXApp, 1); if (argc > 1) { { arg2 = NULL; if (argv[1] != Qnil) {
                Check_Type(argv[1], T_ARRAY); if (FXMALLOC(&arg2, FXchar *, RARRAY(argv[1])->len)) {
                    for (long i = 0; i < RARRAY(argv[1])->len; i++) { arg2[i] = (FXchar *) STR2CSTR(rb_ary_entry(argv[1], i)); }
                     }  }  }  }  if (argc > 2) { arg3 = NUM2UINT(argv[2]); }  if (argc > 3) { arg4 = NUM2INT(argv[3]); } 
    if (argc > 4) { arg5 = NUM2INT(argv[4]); }  {
        result = (FXXPMImage *)new_FXXPMImage(arg1,(FXchar const **)arg2,arg3,arg4,arg5);
        DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result); if(rb_block_given_p()){ rb_yield(self); }  }  FXFREE(&arg2);
    return self; }
static void
free_FXXPMImage(FXXPMImage *arg1) {
    delete arg1;
}
static VALUE _wrap_FXXPMImage_save(int argc, VALUE *argv, VALUE self) { FXXPMImage *arg1 = (FXXPMImage *) 0 ;
    FXStream *arg2 = 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXXPMImage, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXXPMImage_save((FXXPMImage const *)arg1,*arg2); return Qnil; }
static VALUE _wrap_FXXPMImage_load(int argc, VALUE *argv, VALUE self) { FXXPMImage *arg1 = (FXXPMImage *) 0 ;
    FXStream *arg2 = 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXXPMImage, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXXPMImage_load(arg1,*arg2); return Qnil; }
static VALUE _wrap_FXXPMImage_create(int argc, VALUE *argv, VALUE self) { FXXPMImage *arg1 = (FXXPMImage *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXXPMImage, 1); FXXPMImage_create(arg1); return Qnil; }
static VALUE _wrap_FXXPMImage_detach(int argc, VALUE *argv, VALUE self) { FXXPMImage *arg1 = (FXXPMImage *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXXPMImage, 1); FXXPMImage_detach(arg1); return Qnil; }
static VALUE _wrap_FXXPMImage_destroy(int argc, VALUE *argv, VALUE self) { FXXPMImage *arg1 = (FXXPMImage *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXXPMImage, 1); FXXPMImage_destroy(arg1); return Qnil; }
static VALUE _wrap_FXXPMImage_resize(int argc, VALUE *argv, VALUE self) { FXXPMImage *arg1 = (FXXPMImage *) 0 ; FXint arg2 ;
    FXint arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXXPMImage, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    FXXPMImage_resize(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXXPMImage_restore(int argc, VALUE *argv, VALUE self) { FXXPMImage *arg1 = (FXXPMImage *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXXPMImage, 1); FXXPMImage_restore(arg1); return Qnil; }
static VALUE _wrap_FXXPMImage_render(int argc, VALUE *argv, VALUE self) { FXXPMImage *arg1 = (FXXPMImage *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXXPMImage, 1); FXXPMImage_render(arg1); return Qnil; }
static VALUE _wrap_FXXPMImage_release(int argc, VALUE *argv, VALUE self) { FXXPMImage *arg1 = (FXXPMImage *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXXPMImage, 1); FXXPMImage_release(arg1); return Qnil; }
static VALUE _wrap_FXXPMImage_scale(int argc, VALUE *argv, VALUE self) { FXXPMImage *arg1 = (FXXPMImage *) 0 ; FXint arg2 ;
    FXint arg3 ; FXint arg4 = (FXint) 0 ; if ((argc < 2) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXXPMImage, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    if (argc > 2) { arg4 = NUM2INT(argv[2]); }  FXXPMImage_scale(arg1,arg2,arg3,arg4); return Qnil; }
static VALUE _wrap_FXXPMImage_mirror(int argc, VALUE *argv, VALUE self) { FXXPMImage *arg1 = (FXXPMImage *) 0 ; FXbool arg2 ;
    FXbool arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXXPMImage, 1); arg2 = to_FXbool(argv[0]); arg3 = to_FXbool(argv[1]);
    FXXPMImage_mirror(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXXPMImage_rotate(int argc, VALUE *argv, VALUE self) { FXXPMImage *arg1 = (FXXPMImage *) 0 ; FXint arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXXPMImage, 1); arg2 = NUM2INT(argv[0]); FXXPMImage_rotate(arg1,arg2);
    return Qnil; }
static VALUE _wrap_FXXPMImage_crop(int argc, VALUE *argv, VALUE self) { FXXPMImage *arg1 = (FXXPMImage *) 0 ; FXint arg2 ;
    FXint arg3 ; FXint arg4 ; FXint arg5 ; if ((argc < 4) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXXPMImage, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    arg4 = NUM2INT(argv[2]); arg5 = NUM2INT(argv[3]); FXXPMImage_crop(arg1,arg2,arg3,arg4,arg5); return Qnil; }
static VALUE _wrap_FXXPMImage_fill(int argc, VALUE *argv, VALUE self) { FXXPMImage *arg1 = (FXXPMImage *) 0 ; FXColor arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXXPMImage, 1); arg2 = to_FXColor(argv[0]); FXXPMImage_fill(arg1,arg2);
    return Qnil; }
static VALUE _wrap_FXXPMImage_fade(int argc, VALUE *argv, VALUE self) { FXXPMImage *arg1 = (FXXPMImage *) 0 ; FXColor arg2 ;
    FXint arg3 = (FXint) 255 ; if ((argc < 1) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXXPMImage, 1); arg2 = to_FXColor(argv[0]); if (argc > 1) {
        arg3 = NUM2INT(argv[1]); }  FXXPMImage_fade(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXXPMImage_xshear(int argc, VALUE *argv, VALUE self) { FXXPMImage *arg1 = (FXXPMImage *) 0 ; FXint arg2 ;
    FXColor arg3 = (FXColor) 0 ; if ((argc < 1) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXXPMImage, 1); arg2 = NUM2INT(argv[0]); if (argc > 1) {
        arg3 = to_FXColor(argv[1]); }  FXXPMImage_xshear(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXXPMImage_yshear(int argc, VALUE *argv, VALUE self) { FXXPMImage *arg1 = (FXXPMImage *) 0 ; FXint arg2 ;
    FXColor arg3 = (FXColor) 0 ; if ((argc < 1) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXXPMImage, 1); arg2 = NUM2INT(argv[0]); if (argc > 1) {
        arg3 = to_FXColor(argv[1]); }  FXXPMImage_yshear(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXXPMImage_hgradient(int argc, VALUE *argv, VALUE self) { FXXPMImage *arg1 = (FXXPMImage *) 0 ;
    FXColor arg2 ; FXColor arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXXPMImage, 1); arg2 = to_FXColor(argv[0]); arg3 = to_FXColor(argv[1]);
    FXXPMImage_hgradient(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXXPMImage_vgradient(int argc, VALUE *argv, VALUE self) { FXXPMImage *arg1 = (FXXPMImage *) 0 ;
    FXColor arg2 ; FXColor arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXXPMImage, 1); arg2 = to_FXColor(argv[0]); arg3 = to_FXColor(argv[1]);
    FXXPMImage_vgradient(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXXPMImage_gradient(int argc, VALUE *argv, VALUE self) { FXXPMImage *arg1 = (FXXPMImage *) 0 ; FXColor arg2 ;
    FXColor arg3 ; FXColor arg4 ; FXColor arg5 ; if ((argc < 4) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXXPMImage, 1); arg2 = to_FXColor(argv[0]); arg3 = to_FXColor(argv[1]);
    arg4 = to_FXColor(argv[2]); arg5 = to_FXColor(argv[3]); FXXPMImage_gradient(arg1,arg2,arg3,arg4,arg5); return Qnil; }
static VALUE _wrap_FXXPMImage_blend(int argc, VALUE *argv, VALUE self) { FXXPMImage *arg1 = (FXXPMImage *) 0 ; FXColor arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXXPMImage, 1); arg2 = to_FXColor(argv[0]); FXXPMImage_blend(arg1,arg2);
    return Qnil; }
static VALUE _wrap_FXXPMImage_savePixels(int argc, VALUE *argv, VALUE self) { FXXPMImage *arg1 = (FXXPMImage *) 0 ;
    FXStream *arg2 = 0 ; FXbool result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXXPMImage, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    result = (FXbool)FXXPMImage_savePixels((FXXPMImage const *)arg1,*arg2); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXXPMImage_loadPixels(int argc, VALUE *argv, VALUE self) { FXXPMImage *arg1 = (FXXPMImage *) 0 ;
    FXStream *arg2 = 0 ; FXbool result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXXPMImage, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    result = (FXbool)FXXPMImage_loadPixels(arg1,*arg2); vresult = result ? Qtrue : Qfalse; return vresult; }

/* -------- TYPE CONVERSION AND EQUIVALENCE RULES (BEGIN) -------- */

static void *_p_FXShutterItemTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *)(FXVerticalFrame *) ((FXShutterItem *) x));
}
static void *_p_FXColorBarTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXFrame *) ((FXColorBar *) x));
}
static void *_p_FXTabBarTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXTabBar *) x));
}
static void *_p_FXSwitcherTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXSwitcher *) x));
}
static void *_p_FXTextFieldTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXFrame *) ((FXTextField *) x));
}
static void *_p_FXRGBImageTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXImage *) ((FXRGBImage *) x));
}
static void *_p_FXToolBarTabTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXFrame *) ((FXToolBarTab *) x));
}
static void *_p_FXDriveBoxTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *)(FXListBox *) ((FXDriveBox *) x));
}
static void *_p_FXBMPImageTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXImage *) ((FXBMPImage *) x));
}
static void *_p_FXMatrixTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXMatrix *) x));
}
static void *_p_FXScrollCornerTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *) ((FXScrollCorner *) x));
}
static void *_p_FXArrowButtonTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXFrame *) ((FXArrowButton *) x));
}
static void *_p_FXPopupTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXShell *) ((FXPopup *) x));
}
static void *_p_FXDrawableTo_p_FXId(void *x) {
    return (void *)((FXId *)  ((FXDrawable *) x));
}
static void *_p_FXPCXImageTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXImage *) ((FXPCXImage *) x));
}
static void *_p_FXHeaderTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXFrame *) ((FXHeader *) x));
}
static void *_p_FXSplitterTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *) ((FXSplitter *) x));
}
static void *_p_FX4SplitterTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *) ((FX4Splitter *) x));
}
static void *_p_FXSpringTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXSpring *) x));
}
static void *_p_FXPackerTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *) ((FXPacker *) x));
}
static void *_p_FXTabBookTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *)(FXTabBar *) ((FXTabBook *) x));
}
static void *_p_FXImageFrameTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXFrame *) ((FXImageFrame *) x));
}
static void *_p_FXVerticalSeparatorTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXFrame *)(FXSeparator *) ((FXVerticalSeparator *) x));
}
static void *_p_FXHorizontalSeparatorTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXFrame *)(FXSeparator *) ((FXHorizontalSeparator *) x));
}
static void *_p_FXSeparatorTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXFrame *) ((FXSeparator *) x));
}
static void *_p_FXProgressBarTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXFrame *) ((FXProgressBar *) x));
}
static void *_p_FXShutterTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *)(FXVerticalFrame *) ((FXShutter *) x));
}
static void *_p_FXTGAImageTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXImage *) ((FXTGAImage *) x));
}
static void *_p_FXToolTipTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXShell *) ((FXToolTip *) x));
}
static void *_p_FXCompositeTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *) ((FXComposite *) x));
}
static void *_p_FXICOImageTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXImage *) ((FXICOImage *) x));
}
static void *_p_FXBitmapFrameTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXFrame *) ((FXBitmapFrame *) x));
}
static void *_p_FXRealSliderTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXFrame *) ((FXRealSlider *) x));
}
static void *_p_FXSliderTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXFrame *) ((FXSlider *) x));
}
static void *_p_FXGroupBoxTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXGroupBox *) x));
}
static void *_p_FXPPMImageTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXImage *) ((FXPPMImage *) x));
}
static void *_p_FXXBMImageTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXImage *) ((FXXBMImage *) x));
}
static void *_p_FXXPMImageTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXImage *) ((FXXPMImage *) x));
}
static void *_p_FXTreeListBoxTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXTreeListBox *) x));
}
static void *_p_FXListBoxTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXListBox *) x));
}
static void *_p_FXCanvasTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *) ((FXCanvas *) x));
}
static void *_p_FXColorWheelTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXFrame *) ((FXColorWheel *) x));
}
static void *_p_FXVisualTo_p_FXId(void *x) {
    return (void *)((FXId *)  ((FXVisual *) x));
}
static void *_p_FXToolBarGripTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *) ((FXToolBarGrip *) x));
}
static void *_p_FXScrollBarTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *) ((FXScrollBar *) x));
}
static void *_p_FXFontTo_p_FXId(void *x) {
    return (void *)((FXId *)  ((FXFont *) x));
}
static void *_p_FXComboBoxTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXComboBox *) x));
}
static void *_p_FXImageTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *) ((FXImage *) x));
}
static void *_p_FXFrameTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *) ((FXFrame *) x));
}
static void *_p_FXJPGImageTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXImage *) ((FXJPGImage *) x));
}
static void *_p_FXPNGImageTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXImage *) ((FXPNGImage *) x));
}
static void *_p_FXGIFImageTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXImage *) ((FXGIFImage *) x));
}
static void *_p_FXTIFImageTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXImage *) ((FXTIFImage *) x));
}
static void *_p_FXStatusBarTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *)(FXHorizontalFrame *) ((FXStatusBar *) x));
}
static void *_p_FXGIFCursorTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXCursor *) ((FXGIFCursor *) x));
}
static void *_p_FXCURCursorTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXCursor *) ((FXCURCursor *) x));
}
static void *_p_FXCursorTo_p_FXId(void *x) {
    return (void *)((FXId *)  ((FXCursor *) x));
}
static void *_p_FXRealSpinnerTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXRealSpinner *) x));
}
static void *_p_FXSpinnerTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXSpinner *) x));
}
static void *_p_FXStatusLineTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXFrame *) ((FXStatusLine *) x));
}
static void *_p_FXMainWindowTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXShell *)(FXTopWindow *) ((FXMainWindow *) x));
}
static void *_p_FXTopWindowTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXShell *) ((FXTopWindow *) x));
}
static void *_p_FXRootWindowTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *) ((FXRootWindow *) x));
}
static void *_p_FXWindowTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *) ((FXWindow *) x));
}
static void *_p_FXScrollWindowTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXScrollArea *) ((FXScrollWindow *) x));
}
static void *_p_FXShellTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *) ((FXShell *) x));
}
static void *_p_FXBitmapTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *) ((FXBitmap *) x));
}
static void *_p_FXScrollAreaTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *) ((FXScrollArea *) x));
}
static void *_p_FXColorWellTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXFrame *) ((FXColorWell *) x));
}
static void *_p_FXDragCornerTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *) ((FXDragCorner *) x));
}
static void *_p_FXRulerTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXFrame *) ((FXRuler *) x));
}
static void *_p_FXDialTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXFrame *) ((FXDial *) x));
}
static void *_p_FXHorizontalFrameTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXHorizontalFrame *) x));
}
static void *_p_FXVerticalFrameTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXVerticalFrame *) x));
}
static void *_p_FXImageViewTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXScrollArea *) ((FXImageView *) x));
}
static void *_p_FXFontSelectorTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXFontSelector *) x));
}
static void *_p_FXColorSelectorTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXColorSelector *) x));
}
static void *_p_FXFileSelectorTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXFileSelector *) x));
}
static void *_p_FXDirSelectorTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXDirSelector *) x));
}
static void *_p_FXToolBarShellTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXShell *)(FXTopWindow *) ((FXToolBarShell *) x));
}
static void *_p_FXToolBarTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXToolBar *) x));
}
static void *_p_FXDirBoxTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *)(FXTreeListBox *) ((FXDirBox *) x));
}
static void *_p_FXDocumentTo_p_FXObject(void *x) {
    return (void *)((FXObject *)  ((FXDocument *) x));
}
static void *_p_FXRegistryTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXDict *)(FXSettings *) ((FXRegistry *) x));
}
static void *_p_FXHeaderItemTo_p_FXObject(void *x) {
    return (void *)((FXObject *)  ((FXHeaderItem *) x));
}
static void *_p_FXShutterItemTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *)(FXVerticalFrame *) ((FXShutterItem *) x));
}
static void *_p_FXColorBarTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXFrame *) ((FXColorBar *) x));
}
static void *_p_FXTabBarTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXTabBar *) x));
}
static void *_p_FXSwitcherTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXSwitcher *) x));
}
static void *_p_FXTextFieldTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXFrame *) ((FXTextField *) x));
}
static void *_p_FXRGBImageTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXImage *) ((FXRGBImage *) x));
}
static void *_p_FXToolBarTabTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXFrame *) ((FXToolBarTab *) x));
}
static void *_p_FXDriveBoxTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *)(FXListBox *) ((FXDriveBox *) x));
}
static void *_p_FXIconDictTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXDict *) ((FXIconDict *) x));
}
static void *_p_FXBMPImageTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXImage *) ((FXBMPImage *) x));
}
static void *_p_FXMatrixTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXMatrix *) x));
}
static void *_p_FXFileDictTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXDict *) ((FXFileDict *) x));
}
static void *_p_FXRecentFilesTo_p_FXObject(void *x) {
    return (void *)((FXObject *)  ((FXRecentFiles *) x));
}
static void *_p_FXScrollCornerTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *) ((FXScrollCorner *) x));
}
static void *_p_FXArrowButtonTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXFrame *) ((FXArrowButton *) x));
}
static void *_p_FXPopupTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXShell *) ((FXPopup *) x));
}
static void *_p_FXDrawableTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *) ((FXDrawable *) x));
}
static void *_p_FXPCXImageTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXImage *) ((FXPCXImage *) x));
}
static void *_p_FXAppTo_p_FXObject(void *x) {
    return (void *)((FXObject *)  ((FXApp *) x));
}
static void *_p_FXHeaderTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXFrame *) ((FXHeader *) x));
}
static void *_p_FX4SplitterTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *) ((FX4Splitter *) x));
}
static void *_p_FXSplitterTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *) ((FXSplitter *) x));
}
static void *_p_FXSpringTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXSpring *) x));
}
static void *_p_FXPackerTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *) ((FXPacker *) x));
}
static void *_p_FXTabBookTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *)(FXTabBar *) ((FXTabBook *) x));
}
static void *_p_FXImageFrameTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXFrame *) ((FXImageFrame *) x));
}
static void *_p_FXVerticalSeparatorTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXFrame *)(FXSeparator *) ((FXVerticalSeparator *) x));
}
static void *_p_FXHorizontalSeparatorTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXFrame *)(FXSeparator *) ((FXHorizontalSeparator *) x));
}
static void *_p_FXSeparatorTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXFrame *) ((FXSeparator *) x));
}
static void *_p_FXIdTo_p_FXObject(void *x) {
    return (void *)((FXObject *)  ((FXId *) x));
}
static void *_p_FXProgressBarTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXFrame *) ((FXProgressBar *) x));
}
static void *_p_FXShutterTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *)(FXVerticalFrame *) ((FXShutter *) x));
}
static void *_p_FXTGAImageTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXImage *) ((FXTGAImage *) x));
}
static void *_p_FXToolTipTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXShell *) ((FXToolTip *) x));
}
static void *_p_FXCompositeTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *) ((FXComposite *) x));
}
static void *_p_FXBitmapFrameTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXFrame *) ((FXBitmapFrame *) x));
}
static void *_p_FXICOImageTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXImage *) ((FXICOImage *) x));
}
static void *_p_FXRealSliderTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXFrame *) ((FXRealSlider *) x));
}
static void *_p_FXSliderTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXFrame *) ((FXSlider *) x));
}
static void *_p_FXSettingsTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXDict *) ((FXSettings *) x));
}
static void *_p_FXGroupBoxTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXGroupBox *) x));
}
static void *_p_FXDebugTargetTo_p_FXObject(void *x) {
    return (void *)((FXObject *)  ((FXDebugTarget *) x));
}
static void *_p_FXDataTargetTo_p_FXObject(void *x) {
    return (void *)((FXObject *)  ((FXDataTarget *) x));
}
static void *_p_FXPPMImageTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXImage *) ((FXPPMImage *) x));
}
static void *_p_FXXBMImageTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXImage *) ((FXXBMImage *) x));
}
static void *_p_FXXPMImageTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXImage *) ((FXXPMImage *) x));
}
static void *_p_FXTreeListBoxTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXTreeListBox *) x));
}
static void *_p_FXListBoxTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXListBox *) x));
}
static void *_p_FXCanvasTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *) ((FXCanvas *) x));
}
static void *_p_FXColorWheelTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXFrame *) ((FXColorWheel *) x));
}
static void *_p_FXVisualTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *) ((FXVisual *) x));
}
static void *_p_FXScrollBarTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *) ((FXScrollBar *) x));
}
static void *_p_FXToolBarGripTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *) ((FXToolBarGrip *) x));
}
static void *_p_FXFontTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *) ((FXFont *) x));
}
static void *_p_FXComboBoxTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXComboBox *) x));
}
static void *_p_FXImageTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *) ((FXImage *) x));
}
static void *_p_FXFrameTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *) ((FXFrame *) x));
}
static void *_p_FXJPGImageTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXImage *) ((FXJPGImage *) x));
}
static void *_p_FXPNGImageTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXImage *) ((FXPNGImage *) x));
}
static void *_p_FXGIFImageTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXImage *) ((FXGIFImage *) x));
}
static void *_p_FXTIFImageTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXImage *) ((FXTIFImage *) x));
}
static void *_p_FXStringDictTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXDict *) ((FXStringDict *) x));
}
static void *_p_FXStatusBarTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *)(FXHorizontalFrame *) ((FXStatusBar *) x));
}
static void *_p_FXDelegatorTo_p_FXObject(void *x) {
    return (void *)((FXObject *)  ((FXDelegator *) x));
}
static void *_p_FXAccelTableTo_p_FXObject(void *x) {
    return (void *)((FXObject *)  ((FXAccelTable *) x));
}
static void *_p_FXCursorTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *) ((FXCursor *) x));
}
static void *_p_FXCURCursorTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXCursor *) ((FXCURCursor *) x));
}
static void *_p_FXGIFCursorTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXCursor *) ((FXGIFCursor *) x));
}
static void *_p_FXRealSpinnerTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXRealSpinner *) x));
}
static void *_p_FXSpinnerTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXSpinner *) x));
}
static void *_p_FXStatusLineTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXFrame *) ((FXStatusLine *) x));
}
static void *_p_FXScrollWindowTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXScrollArea *) ((FXScrollWindow *) x));
}
static void *_p_FXWindowTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *) ((FXWindow *) x));
}
static void *_p_FXRootWindowTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *) ((FXRootWindow *) x));
}
static void *_p_FXTopWindowTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXShell *) ((FXTopWindow *) x));
}
static void *_p_FXMainWindowTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXShell *)(FXTopWindow *) ((FXMainWindow *) x));
}
static void *_p_FXDictTo_p_FXObject(void *x) {
    return (void *)((FXObject *)  ((FXDict *) x));
}
static void *_p_FXShellTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *) ((FXShell *) x));
}
static void *_p_FXBitmapTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *) ((FXBitmap *) x));
}
static void *_p_FXScrollAreaTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *) ((FXScrollArea *) x));
}
static void *_p_FXColorWellTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXFrame *) ((FXColorWell *) x));
}
static void *_p_FXDragCornerTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *) ((FXDragCorner *) x));
}
static void *_p_FXRulerTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXFrame *) ((FXRuler *) x));
}
static void *_p_FXDialTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXFrame *) ((FXDial *) x));
}
static void *_p_FXHorizontalFrameTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXHorizontalFrame *) x));
}
static void *_p_FXVerticalFrameTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXVerticalFrame *) x));
}
static void *_p_FXImageViewTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXScrollArea *) ((FXImageView *) x));
}
static void *_p_FXDirSelectorTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXDirSelector *) x));
}
static void *_p_FXFileSelectorTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXFileSelector *) x));
}
static void *_p_FXColorSelectorTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXColorSelector *) x));
}
static void *_p_FXFontSelectorTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXFontSelector *) x));
}
static void *_p_FXToolBarTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXToolBar *) x));
}
static void *_p_FXToolBarShellTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXShell *)(FXTopWindow *) ((FXToolBarShell *) x));
}
static void *_p_FXDirBoxTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *)(FXTreeListBox *) ((FXDirBox *) x));
}
static void *_p_FXFileStreamTo_p_FXStream(void *x) {
    return (void *)((FXStream *)  ((FXFileStream *) x));
}
static void *_p_FXMemoryStreamTo_p_FXStream(void *x) {
    return (void *)((FXStream *)  ((FXMemoryStream *) x));
}
static void *_p_FXShutterItemTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *)(FXVerticalFrame *) ((FXShutterItem *) x));
}
static void *_p_FXColorBarTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXFrame *) ((FXColorBar *) x));
}
static void *_p_FXTabBarTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *) ((FXTabBar *) x));
}
static void *_p_FXRGBImageTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXImage *) ((FXRGBImage *) x));
}
static void *_p_FXSwitcherTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *) ((FXSwitcher *) x));
}
static void *_p_FXTextFieldTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXFrame *) ((FXTextField *) x));
}
static void *_p_FXToolBarTabTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXFrame *) ((FXToolBarTab *) x));
}
static void *_p_FXDriveBoxTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *)(FXListBox *) ((FXDriveBox *) x));
}
static void *_p_FXBMPImageTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXImage *) ((FXBMPImage *) x));
}
static void *_p_FXMatrixTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *) ((FXMatrix *) x));
}
static void *_p_FXScrollCornerTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *) ((FXScrollCorner *) x));
}
static void *_p_FXArrowButtonTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXFrame *) ((FXArrowButton *) x));
}
static void *_p_FXPopupTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXShell *) ((FXPopup *) x));
}
static void *_p_FXPCXImageTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXImage *) ((FXPCXImage *) x));
}
static void *_p_FXHeaderTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXFrame *) ((FXHeader *) x));
}
static void *_p_FXSplitterTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *) ((FXSplitter *) x));
}
static void *_p_FX4SplitterTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *) ((FX4Splitter *) x));
}
static void *_p_FXSpringTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *) ((FXSpring *) x));
}
static void *_p_FXPackerTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *) ((FXPacker *) x));
}
static void *_p_FXTabBookTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *)(FXTabBar *) ((FXTabBook *) x));
}
static void *_p_FXImageFrameTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXFrame *) ((FXImageFrame *) x));
}
static void *_p_FXVerticalSeparatorTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXFrame *)(FXSeparator *) ((FXVerticalSeparator *) x));
}
static void *_p_FXSeparatorTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXFrame *) ((FXSeparator *) x));
}
static void *_p_FXHorizontalSeparatorTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXFrame *)(FXSeparator *) ((FXHorizontalSeparator *) x));
}
static void *_p_FXProgressBarTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXFrame *) ((FXProgressBar *) x));
}
static void *_p_FXShutterTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *)(FXVerticalFrame *) ((FXShutter *) x));
}
static void *_p_FXTGAImageTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXImage *) ((FXTGAImage *) x));
}
static void *_p_FXToolTipTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXShell *) ((FXToolTip *) x));
}
static void *_p_FXCompositeTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *) ((FXComposite *) x));
}
static void *_p_FXICOImageTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXImage *) ((FXICOImage *) x));
}
static void *_p_FXBitmapFrameTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXFrame *) ((FXBitmapFrame *) x));
}
static void *_p_FXRealSliderTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXFrame *) ((FXRealSlider *) x));
}
static void *_p_FXSliderTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXFrame *) ((FXSlider *) x));
}
static void *_p_FXGroupBoxTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *) ((FXGroupBox *) x));
}
static void *_p_FXPPMImageTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXImage *) ((FXPPMImage *) x));
}
static void *_p_FXXBMImageTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXImage *) ((FXXBMImage *) x));
}
static void *_p_FXXPMImageTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXImage *) ((FXXPMImage *) x));
}
static void *_p_FXTreeListBoxTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *) ((FXTreeListBox *) x));
}
static void *_p_FXListBoxTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *) ((FXListBox *) x));
}
static void *_p_FXCanvasTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *) ((FXCanvas *) x));
}
static void *_p_FXColorWheelTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXFrame *) ((FXColorWheel *) x));
}
static void *_p_FXToolBarGripTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *) ((FXToolBarGrip *) x));
}
static void *_p_FXScrollBarTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *) ((FXScrollBar *) x));
}
static void *_p_FXComboBoxTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *) ((FXComboBox *) x));
}
static void *_p_FXImageTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *)  ((FXImage *) x));
}
static void *_p_FXFrameTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *) ((FXFrame *) x));
}
static void *_p_FXPNGImageTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXImage *) ((FXPNGImage *) x));
}
static void *_p_FXJPGImageTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXImage *) ((FXJPGImage *) x));
}
static void *_p_FXTIFImageTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXImage *) ((FXTIFImage *) x));
}
static void *_p_FXGIFImageTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXImage *) ((FXGIFImage *) x));
}
static void *_p_FXStatusBarTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *)(FXHorizontalFrame *) ((FXStatusBar *) x));
}
static void *_p_FXRealSpinnerTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *) ((FXRealSpinner *) x));
}
static void *_p_FXSpinnerTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *) ((FXSpinner *) x));
}
static void *_p_FXStatusLineTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXFrame *) ((FXStatusLine *) x));
}
static void *_p_FXMainWindowTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXShell *)(FXTopWindow *) ((FXMainWindow *) x));
}
static void *_p_FXTopWindowTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXShell *) ((FXTopWindow *) x));
}
static void *_p_FXRootWindowTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *) ((FXRootWindow *) x));
}
static void *_p_FXWindowTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *)  ((FXWindow *) x));
}
static void *_p_FXScrollWindowTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXScrollArea *) ((FXScrollWindow *) x));
}
static void *_p_FXShellTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *) ((FXShell *) x));
}
static void *_p_FXBitmapTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *)  ((FXBitmap *) x));
}
static void *_p_FXScrollAreaTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *) ((FXScrollArea *) x));
}
static void *_p_FXColorWellTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXFrame *) ((FXColorWell *) x));
}
static void *_p_FXDragCornerTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *) ((FXDragCorner *) x));
}
static void *_p_FXRulerTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXFrame *) ((FXRuler *) x));
}
static void *_p_FXDialTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXFrame *) ((FXDial *) x));
}
static void *_p_FXVerticalFrameTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *) ((FXVerticalFrame *) x));
}
static void *_p_FXHorizontalFrameTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *) ((FXHorizontalFrame *) x));
}
static void *_p_FXImageViewTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXScrollArea *) ((FXImageView *) x));
}
static void *_p_FXFontSelectorTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *) ((FXFontSelector *) x));
}
static void *_p_FXColorSelectorTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *) ((FXColorSelector *) x));
}
static void *_p_FXFileSelectorTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *) ((FXFileSelector *) x));
}
static void *_p_FXDirSelectorTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *) ((FXDirSelector *) x));
}
static void *_p_FXToolBarShellTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXShell *)(FXTopWindow *) ((FXToolBarShell *) x));
}
static void *_p_FXToolBarTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *) ((FXToolBar *) x));
}
static void *_p_FXDirBoxTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *)(FXTreeListBox *) ((FXDirBox *) x));
}
static void *_p_FXBMPImageTo_p_FXImage(void *x) {
    return (void *)((FXImage *)  ((FXBMPImage *) x));
}
static void *_p_FXPPMImageTo_p_FXImage(void *x) {
    return (void *)((FXImage *)  ((FXPPMImage *) x));
}
static void *_p_FXRGBImageTo_p_FXImage(void *x) {
    return (void *)((FXImage *)  ((FXRGBImage *) x));
}
static void *_p_FXXBMImageTo_p_FXImage(void *x) {
    return (void *)((FXImage *)  ((FXXBMImage *) x));
}
static void *_p_FXXPMImageTo_p_FXImage(void *x) {
    return (void *)((FXImage *)  ((FXXPMImage *) x));
}
static void *_p_FXGIFImageTo_p_FXImage(void *x) {
    return (void *)((FXImage *)  ((FXGIFImage *) x));
}
static void *_p_FXTIFImageTo_p_FXImage(void *x) {
    return (void *)((FXImage *)  ((FXTIFImage *) x));
}
static void *_p_FXJPGImageTo_p_FXImage(void *x) {
    return (void *)((FXImage *)  ((FXJPGImage *) x));
}
static void *_p_FXPCXImageTo_p_FXImage(void *x) {
    return (void *)((FXImage *)  ((FXPCXImage *) x));
}
static void *_p_FXPNGImageTo_p_FXImage(void *x) {
    return (void *)((FXImage *)  ((FXPNGImage *) x));
}
static void *_p_FXICOImageTo_p_FXImage(void *x) {
    return (void *)((FXImage *)  ((FXICOImage *) x));
}
static void *_p_FXTGAImageTo_p_FXImage(void *x) {
    return (void *)((FXImage *)  ((FXTGAImage *) x));
}
static swig_type_info _swigt__p_FXObject[] = {{"_p_FXObject", 0, "FXObject *", 0, 0, 0, 0},{"_p_FXDocument", _p_FXDocumentTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXRegistry", _p_FXRegistryTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXHeaderItem", _p_FXHeaderItemTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXShutterItem", _p_FXShutterItemTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXColorBar", _p_FXColorBarTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXTabBar", _p_FXTabBarTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXRGBImage", _p_FXRGBImageTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXSwitcher", _p_FXSwitcherTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXTextField", _p_FXTextFieldTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXToolBarTab", _p_FXToolBarTabTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXDriveBox", _p_FXDriveBoxTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXIconDict", _p_FXIconDictTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXBMPImage", _p_FXBMPImageTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXMatrix", _p_FXMatrixTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXFileDict", _p_FXFileDictTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXRecentFiles", _p_FXRecentFilesTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXScrollCorner", _p_FXScrollCornerTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXArrowButton", _p_FXArrowButtonTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXPopup", _p_FXPopupTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXDrawable", _p_FXDrawableTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXFont", _p_FXFontTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXPCXImage", _p_FXPCXImageTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXHeader", _p_FXHeaderTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXSplitter", _p_FXSplitterTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FX4Splitter", _p_FX4SplitterTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXSpring", _p_FXSpringTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXPacker", _p_FXPackerTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXTabBook", _p_FXTabBookTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXApp", _p_FXAppTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXImageFrame", _p_FXImageFrameTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXVerticalSeparator", _p_FXVerticalSeparatorTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXSeparator", _p_FXSeparatorTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXHorizontalSeparator", _p_FXHorizontalSeparatorTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXProgressBar", _p_FXProgressBarTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXShutter", _p_FXShutterTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXTGAImage", _p_FXTGAImageTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXComposite", _p_FXCompositeTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXToolTip", _p_FXToolTipTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXDict", _p_FXDictTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXICOImage", _p_FXICOImageTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXBitmapFrame", _p_FXBitmapFrameTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXSlider", _p_FXSliderTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXRealSlider", _p_FXRealSliderTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXSettings", _p_FXSettingsTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXGroupBox", _p_FXGroupBoxTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXDataTarget", _p_FXDataTargetTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXDebugTarget", _p_FXDebugTargetTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXPPMImage", _p_FXPPMImageTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXXBMImage", _p_FXXBMImageTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXXPMImage", _p_FXXPMImageTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXTreeListBox", _p_FXTreeListBoxTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXListBox", _p_FXListBoxTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXCanvas", _p_FXCanvasTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXId", _p_FXIdTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXColorWheel", _p_FXColorWheelTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXDial", _p_FXDialTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXToolBarGrip", _p_FXToolBarGripTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXScrollBar", _p_FXScrollBarTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXVisual", _p_FXVisualTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXComboBox", _p_FXComboBoxTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXImage", _p_FXImageTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXFrame", _p_FXFrameTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXPNGImage", _p_FXPNGImageTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXJPGImage", _p_FXJPGImageTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXTIFImage", _p_FXTIFImageTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXGIFImage", _p_FXGIFImageTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXStatusBar", _p_FXStatusBarTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXStringDict", _p_FXStringDictTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXDelegator", _p_FXDelegatorTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXAccelTable", _p_FXAccelTableTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXObject", 0, 0, 0, 0, 0, 0},{"_p_FXCursor", _p_FXCursorTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXCURCursor", _p_FXCURCursorTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXGIFCursor", _p_FXGIFCursorTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXRealSpinner", _p_FXRealSpinnerTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXSpinner", _p_FXSpinnerTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXStatusLine", _p_FXStatusLineTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXMainWindow", _p_FXMainWindowTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXTopWindow", _p_FXTopWindowTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXRootWindow", _p_FXRootWindowTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXWindow", _p_FXWindowTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXScrollWindow", _p_FXScrollWindowTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXShell", _p_FXShellTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXBitmap", _p_FXBitmapTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXScrollArea", _p_FXScrollAreaTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXColorWell", _p_FXColorWellTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXDragCorner", _p_FXDragCornerTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXRuler", _p_FXRulerTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXHorizontalFrame", _p_FXHorizontalFrameTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXVerticalFrame", _p_FXVerticalFrameTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXImageView", _p_FXImageViewTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXDirSelector", _p_FXDirSelectorTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXFileSelector", _p_FXFileSelectorTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXColorSelector", _p_FXColorSelectorTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXFontSelector", _p_FXFontSelectorTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXToolBarShell", _p_FXToolBarShellTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXToolBar", _p_FXToolBarTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXDirBox", _p_FXDirBoxTo_p_FXObject, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXRGBImage[] = {{"_p_FXRGBImage", 0, "FXRGBImage *", 0, 0, 0, 0},{"_p_FXRGBImage", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXuchar[] = {{"_p_FXuchar", 0, "unsigned char const *|FXuchar const *", 0, 0, 0, 0},{"_p_FXuchar", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXBitmap[] = {{"_p_FXBitmap", 0, "FXBitmap *", 0, 0, 0, 0},{"_p_FXBitmap", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXId[] = {{"_p_FXId", 0, "FXId *", 0, 0, 0, 0},{"_p_FXShutterItem", _p_FXShutterItemTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXColorBar", _p_FXColorBarTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXTabBar", _p_FXTabBarTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXRGBImage", _p_FXRGBImageTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXSwitcher", _p_FXSwitcherTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXTextField", _p_FXTextFieldTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXToolBarTab", _p_FXToolBarTabTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXDriveBox", _p_FXDriveBoxTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXBMPImage", _p_FXBMPImageTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXMatrix", _p_FXMatrixTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXScrollCorner", _p_FXScrollCornerTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXArrowButton", _p_FXArrowButtonTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXPopup", _p_FXPopupTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXDrawable", _p_FXDrawableTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXFont", _p_FXFontTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXPCXImage", _p_FXPCXImageTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXHeader", _p_FXHeaderTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXSplitter", _p_FXSplitterTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FX4Splitter", _p_FX4SplitterTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXSpring", _p_FXSpringTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXPacker", _p_FXPackerTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXTabBook", _p_FXTabBookTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXImageFrame", _p_FXImageFrameTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXVerticalSeparator", _p_FXVerticalSeparatorTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXSeparator", _p_FXSeparatorTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXHorizontalSeparator", _p_FXHorizontalSeparatorTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXProgressBar", _p_FXProgressBarTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXShutter", _p_FXShutterTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXTGAImage", _p_FXTGAImageTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXToolTip", _p_FXToolTipTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXComposite", _p_FXCompositeTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXICOImage", _p_FXICOImageTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXBitmapFrame", _p_FXBitmapFrameTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXSlider", _p_FXSliderTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXRealSlider", _p_FXRealSliderTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXGroupBox", _p_FXGroupBoxTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXPPMImage", _p_FXPPMImageTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXXBMImage", _p_FXXBMImageTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXXPMImage", _p_FXXPMImageTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXTreeListBox", _p_FXTreeListBoxTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXListBox", _p_FXListBoxTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXCanvas", _p_FXCanvasTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXId", 0, 0, 0, 0, 0, 0},{"_p_FXColorWheel", _p_FXColorWheelTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXDial", _p_FXDialTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXToolBarGrip", _p_FXToolBarGripTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXScrollBar", _p_FXScrollBarTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXVisual", _p_FXVisualTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXComboBox", _p_FXComboBoxTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXImage", _p_FXImageTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXFrame", _p_FXFrameTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXPNGImage", _p_FXPNGImageTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXJPGImage", _p_FXJPGImageTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXTIFImage", _p_FXTIFImageTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXGIFImage", _p_FXGIFImageTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXStatusBar", _p_FXStatusBarTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXCursor", _p_FXCursorTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXCURCursor", _p_FXCURCursorTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXGIFCursor", _p_FXGIFCursorTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXRealSpinner", _p_FXRealSpinnerTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXSpinner", _p_FXSpinnerTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXStatusLine", _p_FXStatusLineTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXMainWindow", _p_FXMainWindowTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXTopWindow", _p_FXTopWindowTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXRootWindow", _p_FXRootWindowTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXWindow", _p_FXWindowTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXScrollWindow", _p_FXScrollWindowTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXShell", _p_FXShellTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXBitmap", _p_FXBitmapTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXScrollArea", _p_FXScrollAreaTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXColorWell", _p_FXColorWellTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXDragCorner", _p_FXDragCornerTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXRuler", _p_FXRulerTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXVerticalFrame", _p_FXVerticalFrameTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXHorizontalFrame", _p_FXHorizontalFrameTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXImageView", _p_FXImageViewTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXColorSelector", _p_FXColorSelectorTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXFileSelector", _p_FXFileSelectorTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXDirSelector", _p_FXDirSelectorTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXFontSelector", _p_FXFontSelectorTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXToolBarShell", _p_FXToolBarShellTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXToolBar", _p_FXToolBarTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXDirBox", _p_FXDirBoxTo_p_FXId, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_p_FXchar[] = {{"_p_p_FXchar", 0, "char const **|FXchar const **", 0, 0, 0, 0},{"_p_p_FXchar", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXStream[] = {{"_p_FXStream", 0, "FXStream *", 0, 0, 0, 0},{"_p_FXFileStream", _p_FXFileStreamTo_p_FXStream, 0, 0, 0, 0, 0},{"_p_FXMemoryStream", _p_FXMemoryStreamTo_p_FXStream, 0, 0, 0, 0, 0},{"_p_FXStream", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXDrawable[] = {{"_p_FXDrawable", 0, "FXDrawable *", 0, 0, 0, 0},{"_p_FXShutterItem", _p_FXShutterItemTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXColorBar", _p_FXColorBarTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXTabBar", _p_FXTabBarTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXRGBImage", _p_FXRGBImageTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXSwitcher", _p_FXSwitcherTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXTextField", _p_FXTextFieldTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXToolBarTab", _p_FXToolBarTabTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXDriveBox", _p_FXDriveBoxTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXBMPImage", _p_FXBMPImageTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXMatrix", _p_FXMatrixTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXScrollCorner", _p_FXScrollCornerTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXArrowButton", _p_FXArrowButtonTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXPopup", _p_FXPopupTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXDrawable", 0, 0, 0, 0, 0, 0},{"_p_FXPCXImage", _p_FXPCXImageTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXHeader", _p_FXHeaderTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXSplitter", _p_FXSplitterTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FX4Splitter", _p_FX4SplitterTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXSpring", _p_FXSpringTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXPacker", _p_FXPackerTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXTabBook", _p_FXTabBookTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXImageFrame", _p_FXImageFrameTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXVerticalSeparator", _p_FXVerticalSeparatorTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXSeparator", _p_FXSeparatorTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXHorizontalSeparator", _p_FXHorizontalSeparatorTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXProgressBar", _p_FXProgressBarTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXShutter", _p_FXShutterTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXTGAImage", _p_FXTGAImageTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXToolTip", _p_FXToolTipTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXComposite", _p_FXCompositeTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXICOImage", _p_FXICOImageTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXBitmapFrame", _p_FXBitmapFrameTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXRealSlider", _p_FXRealSliderTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXSlider", _p_FXSliderTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXGroupBox", _p_FXGroupBoxTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXPPMImage", _p_FXPPMImageTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXXBMImage", _p_FXXBMImageTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXXPMImage", _p_FXXPMImageTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXTreeListBox", _p_FXTreeListBoxTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXListBox", _p_FXListBoxTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXCanvas", _p_FXCanvasTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXColorWheel", _p_FXColorWheelTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXDial", _p_FXDialTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXToolBarGrip", _p_FXToolBarGripTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXScrollBar", _p_FXScrollBarTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXComboBox", _p_FXComboBoxTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXImage", _p_FXImageTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXFrame", _p_FXFrameTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXPNGImage", _p_FXPNGImageTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXJPGImage", _p_FXJPGImageTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXTIFImage", _p_FXTIFImageTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXGIFImage", _p_FXGIFImageTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXStatusBar", _p_FXStatusBarTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXRealSpinner", _p_FXRealSpinnerTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXSpinner", _p_FXSpinnerTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXStatusLine", _p_FXStatusLineTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXMainWindow", _p_FXMainWindowTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXTopWindow", _p_FXTopWindowTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXRootWindow", _p_FXRootWindowTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXWindow", _p_FXWindowTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXScrollWindow", _p_FXScrollWindowTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXShell", _p_FXShellTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXBitmap", _p_FXBitmapTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXScrollArea", _p_FXScrollAreaTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXColorWell", _p_FXColorWellTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXDragCorner", _p_FXDragCornerTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXRuler", _p_FXRulerTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXVerticalFrame", _p_FXVerticalFrameTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXHorizontalFrame", _p_FXHorizontalFrameTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXImageView", _p_FXImageViewTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXFontSelector", _p_FXFontSelectorTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXColorSelector", _p_FXColorSelectorTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXFileSelector", _p_FXFileSelectorTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXDirSelector", _p_FXDirSelectorTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXToolBarShell", _p_FXToolBarShellTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXToolBar", _p_FXToolBarTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXDirBox", _p_FXDirBoxTo_p_FXDrawable, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXGIFImage[] = {{"_p_FXGIFImage", 0, "FXGIFImage *", 0, 0, 0, 0},{"_p_FXGIFImage", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXTIFImage[] = {{"_p_FXTIFImage", 0, "FXTIFImage *", 0, 0, 0, 0},{"_p_FXTIFImage", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXICOImage[] = {{"_p_FXICOImage", 0, "FXICOImage *", 0, 0, 0, 0},{"_p_FXICOImage", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXPPMImage[] = {{"_p_FXPPMImage", 0, "FXPPMImage *", 0, 0, 0, 0},{"_p_FXPPMImage", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXXBMImage[] = {{"_p_FXXBMImage", 0, "FXXBMImage *", 0, 0, 0, 0},{"_p_FXXBMImage", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXXPMImage[] = {{"_p_FXXPMImage", 0, "FXXPMImage *", 0, 0, 0, 0},{"_p_FXXPMImage", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXPCXImage[] = {{"_p_FXPCXImage", 0, "FXPCXImage *", 0, 0, 0, 0},{"_p_FXPCXImage", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXColor[] = {{"_p_FXColor", 0, "unsigned int const *|FXColor const *", 0, 0, 0, 0},{"_p_FXColor", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXBMPImage[] = {{"_p_FXBMPImage", 0, "FXBMPImage *", 0, 0, 0, 0},{"_p_FXBMPImage", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXApp[] = {{"_p_FXApp", 0, "FXApp *", 0, 0, 0, 0},{"_p_FXApp", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXJPGImage[] = {{"_p_FXJPGImage", 0, "FXJPGImage *", 0, 0, 0, 0},{"_p_FXJPGImage", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXImage[] = {{"_p_FXImage", 0, "FXImage *", 0, 0, 0, 0},{"_p_FXBMPImage", _p_FXBMPImageTo_p_FXImage, 0, 0, 0, 0, 0},{"_p_FXPPMImage", _p_FXPPMImageTo_p_FXImage, 0, 0, 0, 0, 0},{"_p_FXRGBImage", _p_FXRGBImageTo_p_FXImage, 0, 0, 0, 0, 0},{"_p_FXXBMImage", _p_FXXBMImageTo_p_FXImage, 0, 0, 0, 0, 0},{"_p_FXXPMImage", _p_FXXPMImageTo_p_FXImage, 0, 0, 0, 0, 0},{"_p_FXImage", 0, 0, 0, 0, 0, 0},{"_p_FXGIFImage", _p_FXGIFImageTo_p_FXImage, 0, 0, 0, 0, 0},{"_p_FXTIFImage", _p_FXTIFImageTo_p_FXImage, 0, 0, 0, 0, 0},{"_p_FXJPGImage", _p_FXJPGImageTo_p_FXImage, 0, 0, 0, 0, 0},{"_p_FXPCXImage", _p_FXPCXImageTo_p_FXImage, 0, 0, 0, 0, 0},{"_p_FXPNGImage", _p_FXPNGImageTo_p_FXImage, 0, 0, 0, 0, 0},{"_p_FXICOImage", _p_FXICOImageTo_p_FXImage, 0, 0, 0, 0, 0},{"_p_FXTGAImage", _p_FXTGAImageTo_p_FXImage, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXPNGImage[] = {{"_p_FXPNGImage", 0, "FXPNGImage *", 0, 0, 0, 0},{"_p_FXPNGImage", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXMemoryBuffer[] = {{"_p_FXMemoryBuffer", 0, "FXMemoryBuffer *", 0, 0, 0, 0},{"_p_FXMemoryBuffer", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXTGAImage[] = {{"_p_FXTGAImage", 0, "FXTGAImage *", 0, 0, 0, 0},{"_p_FXTGAImage", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};

static swig_type_info *swig_types_initial[] = {
_swigt__p_FXObject, 
_swigt__p_FXRGBImage, 
_swigt__p_FXuchar, 
_swigt__p_FXBitmap, 
_swigt__p_FXId, 
_swigt__p_p_FXchar, 
_swigt__p_FXStream, 
_swigt__p_FXDrawable, 
_swigt__p_FXGIFImage, 
_swigt__p_FXTIFImage, 
_swigt__p_FXICOImage, 
_swigt__p_FXPPMImage, 
_swigt__p_FXXBMImage, 
_swigt__p_FXXPMImage, 
_swigt__p_FXPCXImage, 
_swigt__p_FXColor, 
_swigt__p_FXBMPImage, 
_swigt__p_FXApp, 
_swigt__p_FXJPGImage, 
_swigt__p_FXImage, 
_swigt__p_FXPNGImage, 
_swigt__p_FXMemoryBuffer, 
_swigt__p_FXTGAImage, 
0
};


/* -------- TYPE CONVERSION AND EQUIVALENCE RULES (END) -------- */


#ifdef __cplusplus
extern "C"
#endif
SWIGEXPORT(void) Init_image(void) {
    int i;
    
    SWIG_InitRuntime();
    
    for (i = 0; swig_types_initial[i]; i++) {
        swig_types[i] = SWIG_TypeRegister(swig_types_initial[i]);
        SWIG_define_class(swig_types[i]);
    }
    
    rb_define_const(mFox,"BITMAP_KEEP", INT2NUM(BITMAP_KEEP));
    rb_define_const(mFox,"BITMAP_OWNED", INT2NUM(BITMAP_OWNED));
    rb_define_const(mFox,"BITMAP_SHMI", INT2NUM(BITMAP_SHMI));
    rb_define_const(mFox,"BITMAP_SHMP", INT2NUM(BITMAP_SHMP));
    
    cFXBitmap.klass = rb_define_class_under(mFox, "FXBitmap", ((swig_class *) SWIGTYPE_p_FXDrawable->clientdata)->klass);
    SWIG_TypeClientData(SWIGTYPE_p_FXBitmap, (void *) &cFXBitmap);
    rb_define_alloc_func(cFXBitmap.klass, _wrap_FXBitmap_allocate);
    rb_define_method(cFXBitmap.klass, "initialize", VALUEFUNC(_wrap_new_FXBitmap), -1);
    rb_define_method(cFXBitmap.klass, "getData", VALUEFUNC(_wrap_FXBitmap_getData), -1);
    rb_define_method(cFXBitmap.klass, "getOptions", VALUEFUNC(_wrap_FXBitmap_getOptions), -1);
    rb_define_method(cFXBitmap.klass, "setOptions", VALUEFUNC(_wrap_FXBitmap_setOptions), -1);
    rb_define_method(cFXBitmap.klass, "getPixel", VALUEFUNC(_wrap_FXBitmap_getPixel), -1);
    rb_define_method(cFXBitmap.klass, "setPixel", VALUEFUNC(_wrap_FXBitmap_setPixel), -1);
    rb_define_method(cFXBitmap.klass, "save", VALUEFUNC(_wrap_FXBitmap_save), -1);
    rb_define_method(cFXBitmap.klass, "load", VALUEFUNC(_wrap_FXBitmap_load), -1);
    rb_define_method(cFXBitmap.klass, "create", VALUEFUNC(_wrap_FXBitmap_create), -1);
    rb_define_method(cFXBitmap.klass, "detach", VALUEFUNC(_wrap_FXBitmap_detach), -1);
    rb_define_method(cFXBitmap.klass, "destroy", VALUEFUNC(_wrap_FXBitmap_destroy), -1);
    rb_define_method(cFXBitmap.klass, "resize", VALUEFUNC(_wrap_FXBitmap_resize), -1);
    rb_define_method(cFXBitmap.klass, "render", VALUEFUNC(_wrap_FXBitmap_render), -1);
    rb_define_method(cFXBitmap.klass, "release", VALUEFUNC(_wrap_FXBitmap_release), -1);
    rb_define_method(cFXBitmap.klass, "savePixels", VALUEFUNC(_wrap_FXBitmap_savePixels), -1);
    rb_define_method(cFXBitmap.klass, "loadPixels", VALUEFUNC(_wrap_FXBitmap_loadPixels), -1);
    rb_define_method(cFXBitmap.klass, "scale", VALUEFUNC(_wrap_FXBitmap_scale), -1);
    rb_define_method(cFXBitmap.klass, "mirror", VALUEFUNC(_wrap_FXBitmap_mirror), -1);
    rb_define_method(cFXBitmap.klass, "rotate", VALUEFUNC(_wrap_FXBitmap_rotate), -1);
    rb_define_method(cFXBitmap.klass, "crop", VALUEFUNC(_wrap_FXBitmap_crop), -1);
    rb_define_method(cFXBitmap.klass, "fill", VALUEFUNC(_wrap_FXBitmap_fill), -1);
    cFXBitmap.mark = (void (*)(void *)) FXRbBitmap::markfunc;
    cFXBitmap.destroy = (void (*)(void *)) FXRbObject::freefunc;
    
    cFXMemoryBuffer.klass = rb_define_class_under(mFox, "FXMemoryBuffer", rb_cObject);
    SWIG_TypeClientData(SWIGTYPE_p_FXMemoryBuffer, (void *) &cFXMemoryBuffer);
    rb_define_alloc_func(cFXMemoryBuffer.klass, _wrap_FXMemoryBuffer_allocate);
    rb_define_method(cFXMemoryBuffer.klass, "initialize", VALUEFUNC(_wrap_new_FXMemoryBuffer), -1);
    rb_define_method(cFXMemoryBuffer.klass, "getSize", VALUEFUNC(_wrap_FXMemoryBuffer_getSize), -1);
    rb_define_method(cFXMemoryBuffer.klass, "getData", VALUEFUNC(_wrap_FXMemoryBuffer_getData), -1);
    rb_define_method(cFXMemoryBuffer.klass, "[]", VALUEFUNC(_wrap_FXMemoryBuffer___getitem__), -1);
    rb_define_method(cFXMemoryBuffer.klass, "[]=", VALUEFUNC(_wrap_FXMemoryBuffer___setitem__), -1);
    cFXMemoryBuffer.mark = 0;
    cFXMemoryBuffer.destroy = (void (*)(void *)) free_FXMemoryBuffer;
    rb_define_const(mFox,"IMAGE_KEEP", INT2NUM(IMAGE_KEEP));
    rb_define_const(mFox,"IMAGE_OWNED", INT2NUM(IMAGE_OWNED));
    rb_define_const(mFox,"IMAGE_DITHER", INT2NUM(IMAGE_DITHER));
    rb_define_const(mFox,"IMAGE_NEAREST", INT2NUM(IMAGE_NEAREST));
    rb_define_const(mFox,"IMAGE_OPAQUE", INT2NUM(IMAGE_OPAQUE));
    rb_define_const(mFox,"IMAGE_ALPHACOLOR", INT2NUM(IMAGE_ALPHACOLOR));
    rb_define_const(mFox,"IMAGE_SHMI", INT2NUM(IMAGE_SHMI));
    rb_define_const(mFox,"IMAGE_SHMP", INT2NUM(IMAGE_SHMP));
    rb_define_const(mFox,"IMAGE_ALPHAGUESS", INT2NUM(IMAGE_ALPHAGUESS));
    
    cFXImage.klass = rb_define_class_under(mFox, "FXImage", ((swig_class *) SWIGTYPE_p_FXDrawable->clientdata)->klass);
    SWIG_TypeClientData(SWIGTYPE_p_FXImage, (void *) &cFXImage);
    rb_define_alloc_func(cFXImage.klass, _wrap_FXImage_allocate);
    rb_define_method(cFXImage.klass, "initialize", VALUEFUNC(_wrap_new_FXImage), -1);
    rb_define_method(cFXImage.klass, "getData", VALUEFUNC(_wrap_FXImage_getData), -1);
    rb_define_method(cFXImage.klass, "getOptions", VALUEFUNC(_wrap_FXImage_getOptions), -1);
    rb_define_method(cFXImage.klass, "setOptions", VALUEFUNC(_wrap_FXImage_setOptions), -1);
    rb_define_method(cFXImage.klass, "getPixel", VALUEFUNC(_wrap_FXImage_getPixel), -1);
    rb_define_method(cFXImage.klass, "setPixel", VALUEFUNC(_wrap_FXImage_setPixel), -1);
    rb_define_method(cFXImage.klass, "hasAlpha?", VALUEFUNC(_wrap_FXImage_hasAlphaq___), -1);
    rb_define_method(cFXImage.klass, "save", VALUEFUNC(_wrap_FXImage_save), -1);
    rb_define_method(cFXImage.klass, "load", VALUEFUNC(_wrap_FXImage_load), -1);
    rb_define_method(cFXImage.klass, "create", VALUEFUNC(_wrap_FXImage_create), -1);
    rb_define_method(cFXImage.klass, "detach", VALUEFUNC(_wrap_FXImage_detach), -1);
    rb_define_method(cFXImage.klass, "destroy", VALUEFUNC(_wrap_FXImage_destroy), -1);
    rb_define_method(cFXImage.klass, "resize", VALUEFUNC(_wrap_FXImage_resize), -1);
    rb_define_method(cFXImage.klass, "restore", VALUEFUNC(_wrap_FXImage_restore), -1);
    rb_define_method(cFXImage.klass, "render", VALUEFUNC(_wrap_FXImage_render), -1);
    rb_define_method(cFXImage.klass, "release", VALUEFUNC(_wrap_FXImage_release), -1);
    rb_define_method(cFXImage.klass, "scale", VALUEFUNC(_wrap_FXImage_scale), -1);
    rb_define_method(cFXImage.klass, "mirror", VALUEFUNC(_wrap_FXImage_mirror), -1);
    rb_define_method(cFXImage.klass, "rotate", VALUEFUNC(_wrap_FXImage_rotate), -1);
    rb_define_method(cFXImage.klass, "crop", VALUEFUNC(_wrap_FXImage_crop), -1);
    rb_define_method(cFXImage.klass, "fill", VALUEFUNC(_wrap_FXImage_fill), -1);
    rb_define_method(cFXImage.klass, "fade", VALUEFUNC(_wrap_FXImage_fade), -1);
    rb_define_method(cFXImage.klass, "xshear", VALUEFUNC(_wrap_FXImage_xshear), -1);
    rb_define_method(cFXImage.klass, "yshear", VALUEFUNC(_wrap_FXImage_yshear), -1);
    rb_define_method(cFXImage.klass, "hgradient", VALUEFUNC(_wrap_FXImage_hgradient), -1);
    rb_define_method(cFXImage.klass, "vgradient", VALUEFUNC(_wrap_FXImage_vgradient), -1);
    rb_define_method(cFXImage.klass, "gradient", VALUEFUNC(_wrap_FXImage_gradient), -1);
    rb_define_method(cFXImage.klass, "blend", VALUEFUNC(_wrap_FXImage_blend), -1);
    rb_define_method(cFXImage.klass, "savePixels", VALUEFUNC(_wrap_FXImage_savePixels), -1);
    rb_define_method(cFXImage.klass, "loadPixels", VALUEFUNC(_wrap_FXImage_loadPixels), -1);
    cFXImage.mark = (void (*)(void *)) FXRbImage::markfunc;
    cFXImage.destroy = (void (*)(void *)) FXRbObject::freefunc;
    
    SWIGTYPE_p_FXImage->dcast = (swig_dycast_func) FXImage_dynamic_cast;
    
    
    cFXBMPImage.klass = rb_define_class_under(mFox, "FXBMPImage", ((swig_class *) SWIGTYPE_p_FXImage->clientdata)->klass);
    SWIG_TypeClientData(SWIGTYPE_p_FXBMPImage, (void *) &cFXBMPImage);
    rb_define_alloc_func(cFXBMPImage.klass, _wrap_FXBMPImage_allocate);
    rb_define_method(cFXBMPImage.klass, "initialize", VALUEFUNC(_wrap_new_FXBMPImage), -1);
    rb_define_method(cFXBMPImage.klass, "save", VALUEFUNC(_wrap_FXBMPImage_save), -1);
    rb_define_method(cFXBMPImage.klass, "load", VALUEFUNC(_wrap_FXBMPImage_load), -1);
    rb_define_method(cFXBMPImage.klass, "create", VALUEFUNC(_wrap_FXBMPImage_create), -1);
    rb_define_method(cFXBMPImage.klass, "detach", VALUEFUNC(_wrap_FXBMPImage_detach), -1);
    rb_define_method(cFXBMPImage.klass, "destroy", VALUEFUNC(_wrap_FXBMPImage_destroy), -1);
    rb_define_method(cFXBMPImage.klass, "resize", VALUEFUNC(_wrap_FXBMPImage_resize), -1);
    rb_define_method(cFXBMPImage.klass, "restore", VALUEFUNC(_wrap_FXBMPImage_restore), -1);
    rb_define_method(cFXBMPImage.klass, "render", VALUEFUNC(_wrap_FXBMPImage_render), -1);
    rb_define_method(cFXBMPImage.klass, "release", VALUEFUNC(_wrap_FXBMPImage_release), -1);
    rb_define_method(cFXBMPImage.klass, "scale", VALUEFUNC(_wrap_FXBMPImage_scale), -1);
    rb_define_method(cFXBMPImage.klass, "mirror", VALUEFUNC(_wrap_FXBMPImage_mirror), -1);
    rb_define_method(cFXBMPImage.klass, "rotate", VALUEFUNC(_wrap_FXBMPImage_rotate), -1);
    rb_define_method(cFXBMPImage.klass, "crop", VALUEFUNC(_wrap_FXBMPImage_crop), -1);
    rb_define_method(cFXBMPImage.klass, "fill", VALUEFUNC(_wrap_FXBMPImage_fill), -1);
    rb_define_method(cFXBMPImage.klass, "fade", VALUEFUNC(_wrap_FXBMPImage_fade), -1);
    rb_define_method(cFXBMPImage.klass, "xshear", VALUEFUNC(_wrap_FXBMPImage_xshear), -1);
    rb_define_method(cFXBMPImage.klass, "yshear", VALUEFUNC(_wrap_FXBMPImage_yshear), -1);
    rb_define_method(cFXBMPImage.klass, "hgradient", VALUEFUNC(_wrap_FXBMPImage_hgradient), -1);
    rb_define_method(cFXBMPImage.klass, "vgradient", VALUEFUNC(_wrap_FXBMPImage_vgradient), -1);
    rb_define_method(cFXBMPImage.klass, "gradient", VALUEFUNC(_wrap_FXBMPImage_gradient), -1);
    rb_define_method(cFXBMPImage.klass, "blend", VALUEFUNC(_wrap_FXBMPImage_blend), -1);
    rb_define_method(cFXBMPImage.klass, "savePixels", VALUEFUNC(_wrap_FXBMPImage_savePixels), -1);
    rb_define_method(cFXBMPImage.klass, "loadPixels", VALUEFUNC(_wrap_FXBMPImage_loadPixels), -1);
    cFXBMPImage.mark = (void (*)(void *)) FXRbBMPImage::markfunc;
    cFXBMPImage.destroy = (void (*)(void *)) FXRbObject::freefunc;
    
    cFXGIFImage.klass = rb_define_class_under(mFox, "FXGIFImage", ((swig_class *) SWIGTYPE_p_FXImage->clientdata)->klass);
    SWIG_TypeClientData(SWIGTYPE_p_FXGIFImage, (void *) &cFXGIFImage);
    rb_define_alloc_func(cFXGIFImage.klass, _wrap_FXGIFImage_allocate);
    rb_define_method(cFXGIFImage.klass, "initialize", VALUEFUNC(_wrap_new_FXGIFImage), -1);
    rb_define_method(cFXGIFImage.klass, "save", VALUEFUNC(_wrap_FXGIFImage_save), -1);
    rb_define_method(cFXGIFImage.klass, "load", VALUEFUNC(_wrap_FXGIFImage_load), -1);
    rb_define_method(cFXGIFImage.klass, "create", VALUEFUNC(_wrap_FXGIFImage_create), -1);
    rb_define_method(cFXGIFImage.klass, "detach", VALUEFUNC(_wrap_FXGIFImage_detach), -1);
    rb_define_method(cFXGIFImage.klass, "destroy", VALUEFUNC(_wrap_FXGIFImage_destroy), -1);
    rb_define_method(cFXGIFImage.klass, "resize", VALUEFUNC(_wrap_FXGIFImage_resize), -1);
    rb_define_method(cFXGIFImage.klass, "restore", VALUEFUNC(_wrap_FXGIFImage_restore), -1);
    rb_define_method(cFXGIFImage.klass, "render", VALUEFUNC(_wrap_FXGIFImage_render), -1);
    rb_define_method(cFXGIFImage.klass, "release", VALUEFUNC(_wrap_FXGIFImage_release), -1);
    rb_define_method(cFXGIFImage.klass, "scale", VALUEFUNC(_wrap_FXGIFImage_scale), -1);
    rb_define_method(cFXGIFImage.klass, "mirror", VALUEFUNC(_wrap_FXGIFImage_mirror), -1);
    rb_define_method(cFXGIFImage.klass, "rotate", VALUEFUNC(_wrap_FXGIFImage_rotate), -1);
    rb_define_method(cFXGIFImage.klass, "crop", VALUEFUNC(_wrap_FXGIFImage_crop), -1);
    rb_define_method(cFXGIFImage.klass, "fill", VALUEFUNC(_wrap_FXGIFImage_fill), -1);
    rb_define_method(cFXGIFImage.klass, "fade", VALUEFUNC(_wrap_FXGIFImage_fade), -1);
    rb_define_method(cFXGIFImage.klass, "xshear", VALUEFUNC(_wrap_FXGIFImage_xshear), -1);
    rb_define_method(cFXGIFImage.klass, "yshear", VALUEFUNC(_wrap_FXGIFImage_yshear), -1);
    rb_define_method(cFXGIFImage.klass, "hgradient", VALUEFUNC(_wrap_FXGIFImage_hgradient), -1);
    rb_define_method(cFXGIFImage.klass, "vgradient", VALUEFUNC(_wrap_FXGIFImage_vgradient), -1);
    rb_define_method(cFXGIFImage.klass, "gradient", VALUEFUNC(_wrap_FXGIFImage_gradient), -1);
    rb_define_method(cFXGIFImage.klass, "blend", VALUEFUNC(_wrap_FXGIFImage_blend), -1);
    rb_define_method(cFXGIFImage.klass, "savePixels", VALUEFUNC(_wrap_FXGIFImage_savePixels), -1);
    rb_define_method(cFXGIFImage.klass, "loadPixels", VALUEFUNC(_wrap_FXGIFImage_loadPixels), -1);
    cFXGIFImage.mark = (void (*)(void *)) FXRbGIFImage::markfunc;
    cFXGIFImage.destroy = (void (*)(void *)) FXRbObject::freefunc;
    
    cFXICOImage.klass = rb_define_class_under(mFox, "FXICOImage", ((swig_class *) SWIGTYPE_p_FXImage->clientdata)->klass);
    SWIG_TypeClientData(SWIGTYPE_p_FXICOImage, (void *) &cFXICOImage);
    rb_define_alloc_func(cFXICOImage.klass, _wrap_FXICOImage_allocate);
    rb_define_method(cFXICOImage.klass, "initialize", VALUEFUNC(_wrap_new_FXICOImage), -1);
    rb_define_method(cFXICOImage.klass, "save", VALUEFUNC(_wrap_FXICOImage_save), -1);
    rb_define_method(cFXICOImage.klass, "load", VALUEFUNC(_wrap_FXICOImage_load), -1);
    rb_define_method(cFXICOImage.klass, "create", VALUEFUNC(_wrap_FXICOImage_create), -1);
    rb_define_method(cFXICOImage.klass, "detach", VALUEFUNC(_wrap_FXICOImage_detach), -1);
    rb_define_method(cFXICOImage.klass, "destroy", VALUEFUNC(_wrap_FXICOImage_destroy), -1);
    rb_define_method(cFXICOImage.klass, "resize", VALUEFUNC(_wrap_FXICOImage_resize), -1);
    rb_define_method(cFXICOImage.klass, "restore", VALUEFUNC(_wrap_FXICOImage_restore), -1);
    rb_define_method(cFXICOImage.klass, "render", VALUEFUNC(_wrap_FXICOImage_render), -1);
    rb_define_method(cFXICOImage.klass, "release", VALUEFUNC(_wrap_FXICOImage_release), -1);
    rb_define_method(cFXICOImage.klass, "scale", VALUEFUNC(_wrap_FXICOImage_scale), -1);
    rb_define_method(cFXICOImage.klass, "mirror", VALUEFUNC(_wrap_FXICOImage_mirror), -1);
    rb_define_method(cFXICOImage.klass, "rotate", VALUEFUNC(_wrap_FXICOImage_rotate), -1);
    rb_define_method(cFXICOImage.klass, "crop", VALUEFUNC(_wrap_FXICOImage_crop), -1);
    rb_define_method(cFXICOImage.klass, "fill", VALUEFUNC(_wrap_FXICOImage_fill), -1);
    rb_define_method(cFXICOImage.klass, "fade", VALUEFUNC(_wrap_FXICOImage_fade), -1);
    rb_define_method(cFXICOImage.klass, "xshear", VALUEFUNC(_wrap_FXICOImage_xshear), -1);
    rb_define_method(cFXICOImage.klass, "yshear", VALUEFUNC(_wrap_FXICOImage_yshear), -1);
    rb_define_method(cFXICOImage.klass, "hgradient", VALUEFUNC(_wrap_FXICOImage_hgradient), -1);
    rb_define_method(cFXICOImage.klass, "vgradient", VALUEFUNC(_wrap_FXICOImage_vgradient), -1);
    rb_define_method(cFXICOImage.klass, "gradient", VALUEFUNC(_wrap_FXICOImage_gradient), -1);
    rb_define_method(cFXICOImage.klass, "blend", VALUEFUNC(_wrap_FXICOImage_blend), -1);
    rb_define_method(cFXICOImage.klass, "savePixels", VALUEFUNC(_wrap_FXICOImage_savePixels), -1);
    rb_define_method(cFXICOImage.klass, "loadPixels", VALUEFUNC(_wrap_FXICOImage_loadPixels), -1);
    cFXICOImage.mark = (void (*)(void *)) FXRbICOImage::markfunc;
    cFXICOImage.destroy = (void (*)(void *)) FXRbObject::freefunc;
    
    cFXJPGImage.klass = rb_define_class_under(mFox, "FXJPGImage", ((swig_class *) SWIGTYPE_p_FXImage->clientdata)->klass);
    SWIG_TypeClientData(SWIGTYPE_p_FXJPGImage, (void *) &cFXJPGImage);
    rb_define_alloc_func(cFXJPGImage.klass, _wrap_FXJPGImage_allocate);
    rb_define_method(cFXJPGImage.klass, "initialize", VALUEFUNC(_wrap_new_FXJPGImage), -1);
    rb_define_method(cFXJPGImage.klass, "setQuality", VALUEFUNC(_wrap_FXJPGImage_setQuality), -1);
    rb_define_method(cFXJPGImage.klass, "getQuality", VALUEFUNC(_wrap_FXJPGImage_getQuality), -1);
    rb_define_method(cFXJPGImage.klass, "save", VALUEFUNC(_wrap_FXJPGImage_save), -1);
    rb_define_method(cFXJPGImage.klass, "load", VALUEFUNC(_wrap_FXJPGImage_load), -1);
    rb_define_method(cFXJPGImage.klass, "create", VALUEFUNC(_wrap_FXJPGImage_create), -1);
    rb_define_method(cFXJPGImage.klass, "detach", VALUEFUNC(_wrap_FXJPGImage_detach), -1);
    rb_define_method(cFXJPGImage.klass, "destroy", VALUEFUNC(_wrap_FXJPGImage_destroy), -1);
    rb_define_method(cFXJPGImage.klass, "resize", VALUEFUNC(_wrap_FXJPGImage_resize), -1);
    rb_define_method(cFXJPGImage.klass, "restore", VALUEFUNC(_wrap_FXJPGImage_restore), -1);
    rb_define_method(cFXJPGImage.klass, "render", VALUEFUNC(_wrap_FXJPGImage_render), -1);
    rb_define_method(cFXJPGImage.klass, "release", VALUEFUNC(_wrap_FXJPGImage_release), -1);
    rb_define_method(cFXJPGImage.klass, "scale", VALUEFUNC(_wrap_FXJPGImage_scale), -1);
    rb_define_method(cFXJPGImage.klass, "mirror", VALUEFUNC(_wrap_FXJPGImage_mirror), -1);
    rb_define_method(cFXJPGImage.klass, "rotate", VALUEFUNC(_wrap_FXJPGImage_rotate), -1);
    rb_define_method(cFXJPGImage.klass, "crop", VALUEFUNC(_wrap_FXJPGImage_crop), -1);
    rb_define_method(cFXJPGImage.klass, "fill", VALUEFUNC(_wrap_FXJPGImage_fill), -1);
    rb_define_method(cFXJPGImage.klass, "fade", VALUEFUNC(_wrap_FXJPGImage_fade), -1);
    rb_define_method(cFXJPGImage.klass, "xshear", VALUEFUNC(_wrap_FXJPGImage_xshear), -1);
    rb_define_method(cFXJPGImage.klass, "yshear", VALUEFUNC(_wrap_FXJPGImage_yshear), -1);
    rb_define_method(cFXJPGImage.klass, "hgradient", VALUEFUNC(_wrap_FXJPGImage_hgradient), -1);
    rb_define_method(cFXJPGImage.klass, "vgradient", VALUEFUNC(_wrap_FXJPGImage_vgradient), -1);
    rb_define_method(cFXJPGImage.klass, "gradient", VALUEFUNC(_wrap_FXJPGImage_gradient), -1);
    rb_define_method(cFXJPGImage.klass, "blend", VALUEFUNC(_wrap_FXJPGImage_blend), -1);
    rb_define_method(cFXJPGImage.klass, "savePixels", VALUEFUNC(_wrap_FXJPGImage_savePixels), -1);
    rb_define_method(cFXJPGImage.klass, "loadPixels", VALUEFUNC(_wrap_FXJPGImage_loadPixels), -1);
    cFXJPGImage.mark = (void (*)(void *)) FXRbJPGImage::markfunc;
    cFXJPGImage.destroy = (void (*)(void *)) FXRbObject::freefunc;
    rb_define_module_function(mFox, "fxloadJPG", VALUEFUNC(_wrap_fxloadJPG), -1);
    rb_define_module_function(mFox, "fxsaveJPG", VALUEFUNC(_wrap_fxsaveJPG), -1);
    
    cFXPCXImage.klass = rb_define_class_under(mFox, "FXPCXImage", ((swig_class *) SWIGTYPE_p_FXImage->clientdata)->klass);
    SWIG_TypeClientData(SWIGTYPE_p_FXPCXImage, (void *) &cFXPCXImage);
    rb_define_alloc_func(cFXPCXImage.klass, _wrap_FXPCXImage_allocate);
    rb_define_method(cFXPCXImage.klass, "initialize", VALUEFUNC(_wrap_new_FXPCXImage), -1);
    rb_define_method(cFXPCXImage.klass, "save", VALUEFUNC(_wrap_FXPCXImage_save), -1);
    rb_define_method(cFXPCXImage.klass, "load", VALUEFUNC(_wrap_FXPCXImage_load), -1);
    rb_define_method(cFXPCXImage.klass, "create", VALUEFUNC(_wrap_FXPCXImage_create), -1);
    rb_define_method(cFXPCXImage.klass, "detach", VALUEFUNC(_wrap_FXPCXImage_detach), -1);
    rb_define_method(cFXPCXImage.klass, "destroy", VALUEFUNC(_wrap_FXPCXImage_destroy), -1);
    rb_define_method(cFXPCXImage.klass, "resize", VALUEFUNC(_wrap_FXPCXImage_resize), -1);
    rb_define_method(cFXPCXImage.klass, "restore", VALUEFUNC(_wrap_FXPCXImage_restore), -1);
    rb_define_method(cFXPCXImage.klass, "render", VALUEFUNC(_wrap_FXPCXImage_render), -1);
    rb_define_method(cFXPCXImage.klass, "release", VALUEFUNC(_wrap_FXPCXImage_release), -1);
    rb_define_method(cFXPCXImage.klass, "scale", VALUEFUNC(_wrap_FXPCXImage_scale), -1);
    rb_define_method(cFXPCXImage.klass, "mirror", VALUEFUNC(_wrap_FXPCXImage_mirror), -1);
    rb_define_method(cFXPCXImage.klass, "rotate", VALUEFUNC(_wrap_FXPCXImage_rotate), -1);
    rb_define_method(cFXPCXImage.klass, "crop", VALUEFUNC(_wrap_FXPCXImage_crop), -1);
    rb_define_method(cFXPCXImage.klass, "fill", VALUEFUNC(_wrap_FXPCXImage_fill), -1);
    rb_define_method(cFXPCXImage.klass, "fade", VALUEFUNC(_wrap_FXPCXImage_fade), -1);
    rb_define_method(cFXPCXImage.klass, "xshear", VALUEFUNC(_wrap_FXPCXImage_xshear), -1);
    rb_define_method(cFXPCXImage.klass, "yshear", VALUEFUNC(_wrap_FXPCXImage_yshear), -1);
    rb_define_method(cFXPCXImage.klass, "hgradient", VALUEFUNC(_wrap_FXPCXImage_hgradient), -1);
    rb_define_method(cFXPCXImage.klass, "vgradient", VALUEFUNC(_wrap_FXPCXImage_vgradient), -1);
    rb_define_method(cFXPCXImage.klass, "gradient", VALUEFUNC(_wrap_FXPCXImage_gradient), -1);
    rb_define_method(cFXPCXImage.klass, "blend", VALUEFUNC(_wrap_FXPCXImage_blend), -1);
    rb_define_method(cFXPCXImage.klass, "savePixels", VALUEFUNC(_wrap_FXPCXImage_savePixels), -1);
    rb_define_method(cFXPCXImage.klass, "loadPixels", VALUEFUNC(_wrap_FXPCXImage_loadPixels), -1);
    cFXPCXImage.mark = (void (*)(void *)) FXRbPCXImage::markfunc;
    cFXPCXImage.destroy = (void (*)(void *)) FXRbObject::freefunc;
    
    cFXPNGImage.klass = rb_define_class_under(mFox, "FXPNGImage", ((swig_class *) SWIGTYPE_p_FXImage->clientdata)->klass);
    SWIG_TypeClientData(SWIGTYPE_p_FXPNGImage, (void *) &cFXPNGImage);
    rb_define_alloc_func(cFXPNGImage.klass, _wrap_FXPNGImage_allocate);
    rb_define_method(cFXPNGImage.klass, "initialize", VALUEFUNC(_wrap_new_FXPNGImage), -1);
    rb_define_method(cFXPNGImage.klass, "save", VALUEFUNC(_wrap_FXPNGImage_save), -1);
    rb_define_method(cFXPNGImage.klass, "load", VALUEFUNC(_wrap_FXPNGImage_load), -1);
    rb_define_method(cFXPNGImage.klass, "create", VALUEFUNC(_wrap_FXPNGImage_create), -1);
    rb_define_method(cFXPNGImage.klass, "detach", VALUEFUNC(_wrap_FXPNGImage_detach), -1);
    rb_define_method(cFXPNGImage.klass, "destroy", VALUEFUNC(_wrap_FXPNGImage_destroy), -1);
    rb_define_method(cFXPNGImage.klass, "resize", VALUEFUNC(_wrap_FXPNGImage_resize), -1);
    rb_define_method(cFXPNGImage.klass, "restore", VALUEFUNC(_wrap_FXPNGImage_restore), -1);
    rb_define_method(cFXPNGImage.klass, "render", VALUEFUNC(_wrap_FXPNGImage_render), -1);
    rb_define_method(cFXPNGImage.klass, "release", VALUEFUNC(_wrap_FXPNGImage_release), -1);
    rb_define_method(cFXPNGImage.klass, "scale", VALUEFUNC(_wrap_FXPNGImage_scale), -1);
    rb_define_method(cFXPNGImage.klass, "mirror", VALUEFUNC(_wrap_FXPNGImage_mirror), -1);
    rb_define_method(cFXPNGImage.klass, "rotate", VALUEFUNC(_wrap_FXPNGImage_rotate), -1);
    rb_define_method(cFXPNGImage.klass, "crop", VALUEFUNC(_wrap_FXPNGImage_crop), -1);
    rb_define_method(cFXPNGImage.klass, "fill", VALUEFUNC(_wrap_FXPNGImage_fill), -1);
    rb_define_method(cFXPNGImage.klass, "fade", VALUEFUNC(_wrap_FXPNGImage_fade), -1);
    rb_define_method(cFXPNGImage.klass, "xshear", VALUEFUNC(_wrap_FXPNGImage_xshear), -1);
    rb_define_method(cFXPNGImage.klass, "yshear", VALUEFUNC(_wrap_FXPNGImage_yshear), -1);
    rb_define_method(cFXPNGImage.klass, "hgradient", VALUEFUNC(_wrap_FXPNGImage_hgradient), -1);
    rb_define_method(cFXPNGImage.klass, "vgradient", VALUEFUNC(_wrap_FXPNGImage_vgradient), -1);
    rb_define_method(cFXPNGImage.klass, "gradient", VALUEFUNC(_wrap_FXPNGImage_gradient), -1);
    rb_define_method(cFXPNGImage.klass, "blend", VALUEFUNC(_wrap_FXPNGImage_blend), -1);
    rb_define_method(cFXPNGImage.klass, "savePixels", VALUEFUNC(_wrap_FXPNGImage_savePixels), -1);
    rb_define_method(cFXPNGImage.klass, "loadPixels", VALUEFUNC(_wrap_FXPNGImage_loadPixels), -1);
    cFXPNGImage.mark = (void (*)(void *)) FXRbPNGImage::markfunc;
    cFXPNGImage.destroy = (void (*)(void *)) FXRbObject::freefunc;
    
    cFXPPMImage.klass = rb_define_class_under(mFox, "FXPPMImage", ((swig_class *) SWIGTYPE_p_FXImage->clientdata)->klass);
    SWIG_TypeClientData(SWIGTYPE_p_FXPPMImage, (void *) &cFXPPMImage);
    rb_define_alloc_func(cFXPPMImage.klass, _wrap_FXPPMImage_allocate);
    rb_define_method(cFXPPMImage.klass, "initialize", VALUEFUNC(_wrap_new_FXPPMImage), -1);
    rb_define_method(cFXPPMImage.klass, "save", VALUEFUNC(_wrap_FXPPMImage_save), -1);
    rb_define_method(cFXPPMImage.klass, "load", VALUEFUNC(_wrap_FXPPMImage_load), -1);
    rb_define_method(cFXPPMImage.klass, "create", VALUEFUNC(_wrap_FXPPMImage_create), -1);
    rb_define_method(cFXPPMImage.klass, "detach", VALUEFUNC(_wrap_FXPPMImage_detach), -1);
    rb_define_method(cFXPPMImage.klass, "destroy", VALUEFUNC(_wrap_FXPPMImage_destroy), -1);
    rb_define_method(cFXPPMImage.klass, "resize", VALUEFUNC(_wrap_FXPPMImage_resize), -1);
    rb_define_method(cFXPPMImage.klass, "restore", VALUEFUNC(_wrap_FXPPMImage_restore), -1);
    rb_define_method(cFXPPMImage.klass, "render", VALUEFUNC(_wrap_FXPPMImage_render), -1);
    rb_define_method(cFXPPMImage.klass, "release", VALUEFUNC(_wrap_FXPPMImage_release), -1);
    rb_define_method(cFXPPMImage.klass, "scale", VALUEFUNC(_wrap_FXPPMImage_scale), -1);
    rb_define_method(cFXPPMImage.klass, "mirror", VALUEFUNC(_wrap_FXPPMImage_mirror), -1);
    rb_define_method(cFXPPMImage.klass, "rotate", VALUEFUNC(_wrap_FXPPMImage_rotate), -1);
    rb_define_method(cFXPPMImage.klass, "crop", VALUEFUNC(_wrap_FXPPMImage_crop), -1);
    rb_define_method(cFXPPMImage.klass, "fill", VALUEFUNC(_wrap_FXPPMImage_fill), -1);
    rb_define_method(cFXPPMImage.klass, "fade", VALUEFUNC(_wrap_FXPPMImage_fade), -1);
    rb_define_method(cFXPPMImage.klass, "xshear", VALUEFUNC(_wrap_FXPPMImage_xshear), -1);
    rb_define_method(cFXPPMImage.klass, "yshear", VALUEFUNC(_wrap_FXPPMImage_yshear), -1);
    rb_define_method(cFXPPMImage.klass, "hgradient", VALUEFUNC(_wrap_FXPPMImage_hgradient), -1);
    rb_define_method(cFXPPMImage.klass, "vgradient", VALUEFUNC(_wrap_FXPPMImage_vgradient), -1);
    rb_define_method(cFXPPMImage.klass, "gradient", VALUEFUNC(_wrap_FXPPMImage_gradient), -1);
    rb_define_method(cFXPPMImage.klass, "blend", VALUEFUNC(_wrap_FXPPMImage_blend), -1);
    rb_define_method(cFXPPMImage.klass, "savePixels", VALUEFUNC(_wrap_FXPPMImage_savePixels), -1);
    rb_define_method(cFXPPMImage.klass, "loadPixels", VALUEFUNC(_wrap_FXPPMImage_loadPixels), -1);
    cFXPPMImage.mark = 0;
    cFXPPMImage.destroy = (void (*)(void *)) FXRbObject::freefunc;
    
    cFXRGBImage.klass = rb_define_class_under(mFox, "FXRGBImage", ((swig_class *) SWIGTYPE_p_FXImage->clientdata)->klass);
    SWIG_TypeClientData(SWIGTYPE_p_FXRGBImage, (void *) &cFXRGBImage);
    rb_define_alloc_func(cFXRGBImage.klass, _wrap_FXRGBImage_allocate);
    rb_define_method(cFXRGBImage.klass, "initialize", VALUEFUNC(_wrap_new_FXRGBImage), -1);
    rb_define_method(cFXRGBImage.klass, "save", VALUEFUNC(_wrap_FXRGBImage_save), -1);
    rb_define_method(cFXRGBImage.klass, "load", VALUEFUNC(_wrap_FXRGBImage_load), -1);
    rb_define_method(cFXRGBImage.klass, "create", VALUEFUNC(_wrap_FXRGBImage_create), -1);
    rb_define_method(cFXRGBImage.klass, "detach", VALUEFUNC(_wrap_FXRGBImage_detach), -1);
    rb_define_method(cFXRGBImage.klass, "destroy", VALUEFUNC(_wrap_FXRGBImage_destroy), -1);
    rb_define_method(cFXRGBImage.klass, "resize", VALUEFUNC(_wrap_FXRGBImage_resize), -1);
    rb_define_method(cFXRGBImage.klass, "restore", VALUEFUNC(_wrap_FXRGBImage_restore), -1);
    rb_define_method(cFXRGBImage.klass, "render", VALUEFUNC(_wrap_FXRGBImage_render), -1);
    rb_define_method(cFXRGBImage.klass, "release", VALUEFUNC(_wrap_FXRGBImage_release), -1);
    rb_define_method(cFXRGBImage.klass, "scale", VALUEFUNC(_wrap_FXRGBImage_scale), -1);
    rb_define_method(cFXRGBImage.klass, "mirror", VALUEFUNC(_wrap_FXRGBImage_mirror), -1);
    rb_define_method(cFXRGBImage.klass, "rotate", VALUEFUNC(_wrap_FXRGBImage_rotate), -1);
    rb_define_method(cFXRGBImage.klass, "crop", VALUEFUNC(_wrap_FXRGBImage_crop), -1);
    rb_define_method(cFXRGBImage.klass, "fill", VALUEFUNC(_wrap_FXRGBImage_fill), -1);
    rb_define_method(cFXRGBImage.klass, "fade", VALUEFUNC(_wrap_FXRGBImage_fade), -1);
    rb_define_method(cFXRGBImage.klass, "xshear", VALUEFUNC(_wrap_FXRGBImage_xshear), -1);
    rb_define_method(cFXRGBImage.klass, "yshear", VALUEFUNC(_wrap_FXRGBImage_yshear), -1);
    rb_define_method(cFXRGBImage.klass, "hgradient", VALUEFUNC(_wrap_FXRGBImage_hgradient), -1);
    rb_define_method(cFXRGBImage.klass, "vgradient", VALUEFUNC(_wrap_FXRGBImage_vgradient), -1);
    rb_define_method(cFXRGBImage.klass, "gradient", VALUEFUNC(_wrap_FXRGBImage_gradient), -1);
    rb_define_method(cFXRGBImage.klass, "blend", VALUEFUNC(_wrap_FXRGBImage_blend), -1);
    rb_define_method(cFXRGBImage.klass, "savePixels", VALUEFUNC(_wrap_FXRGBImage_savePixels), -1);
    rb_define_method(cFXRGBImage.klass, "loadPixels", VALUEFUNC(_wrap_FXRGBImage_loadPixels), -1);
    cFXRGBImage.mark = (void (*)(void *)) FXRbRGBImage::markfunc;
    cFXRGBImage.destroy = (void (*)(void *)) FXRbObject::freefunc;
    rb_define_module_function(mFox, "fxloadRGB", VALUEFUNC(_wrap_fxloadRGB), -1);
    rb_define_module_function(mFox, "fxsaveRGB", VALUEFUNC(_wrap_fxsaveRGB), -1);
    
    cFXTGAImage.klass = rb_define_class_under(mFox, "FXTGAImage", ((swig_class *) SWIGTYPE_p_FXImage->clientdata)->klass);
    SWIG_TypeClientData(SWIGTYPE_p_FXTGAImage, (void *) &cFXTGAImage);
    rb_define_alloc_func(cFXTGAImage.klass, _wrap_FXTGAImage_allocate);
    rb_define_method(cFXTGAImage.klass, "initialize", VALUEFUNC(_wrap_new_FXTGAImage), -1);
    rb_define_method(cFXTGAImage.klass, "save", VALUEFUNC(_wrap_FXTGAImage_save), -1);
    rb_define_method(cFXTGAImage.klass, "load", VALUEFUNC(_wrap_FXTGAImage_load), -1);
    rb_define_method(cFXTGAImage.klass, "create", VALUEFUNC(_wrap_FXTGAImage_create), -1);
    rb_define_method(cFXTGAImage.klass, "detach", VALUEFUNC(_wrap_FXTGAImage_detach), -1);
    rb_define_method(cFXTGAImage.klass, "destroy", VALUEFUNC(_wrap_FXTGAImage_destroy), -1);
    rb_define_method(cFXTGAImage.klass, "resize", VALUEFUNC(_wrap_FXTGAImage_resize), -1);
    rb_define_method(cFXTGAImage.klass, "restore", VALUEFUNC(_wrap_FXTGAImage_restore), -1);
    rb_define_method(cFXTGAImage.klass, "render", VALUEFUNC(_wrap_FXTGAImage_render), -1);
    rb_define_method(cFXTGAImage.klass, "release", VALUEFUNC(_wrap_FXTGAImage_release), -1);
    rb_define_method(cFXTGAImage.klass, "scale", VALUEFUNC(_wrap_FXTGAImage_scale), -1);
    rb_define_method(cFXTGAImage.klass, "mirror", VALUEFUNC(_wrap_FXTGAImage_mirror), -1);
    rb_define_method(cFXTGAImage.klass, "rotate", VALUEFUNC(_wrap_FXTGAImage_rotate), -1);
    rb_define_method(cFXTGAImage.klass, "crop", VALUEFUNC(_wrap_FXTGAImage_crop), -1);
    rb_define_method(cFXTGAImage.klass, "fill", VALUEFUNC(_wrap_FXTGAImage_fill), -1);
    rb_define_method(cFXTGAImage.klass, "fade", VALUEFUNC(_wrap_FXTGAImage_fade), -1);
    rb_define_method(cFXTGAImage.klass, "xshear", VALUEFUNC(_wrap_FXTGAImage_xshear), -1);
    rb_define_method(cFXTGAImage.klass, "yshear", VALUEFUNC(_wrap_FXTGAImage_yshear), -1);
    rb_define_method(cFXTGAImage.klass, "hgradient", VALUEFUNC(_wrap_FXTGAImage_hgradient), -1);
    rb_define_method(cFXTGAImage.klass, "vgradient", VALUEFUNC(_wrap_FXTGAImage_vgradient), -1);
    rb_define_method(cFXTGAImage.klass, "gradient", VALUEFUNC(_wrap_FXTGAImage_gradient), -1);
    rb_define_method(cFXTGAImage.klass, "blend", VALUEFUNC(_wrap_FXTGAImage_blend), -1);
    rb_define_method(cFXTGAImage.klass, "savePixels", VALUEFUNC(_wrap_FXTGAImage_savePixels), -1);
    rb_define_method(cFXTGAImage.klass, "loadPixels", VALUEFUNC(_wrap_FXTGAImage_loadPixels), -1);
    cFXTGAImage.mark = (void (*)(void *)) FXRbTGAImage::markfunc;
    cFXTGAImage.destroy = (void (*)(void *)) FXRbObject::freefunc;
    rb_define_module_function(mFox, "fxloadTGA", VALUEFUNC(_wrap_fxloadTGA), -1);
    rb_define_module_function(mFox, "fxsaveTGA", VALUEFUNC(_wrap_fxsaveTGA), -1);
    
    cFXTIFImage.klass = rb_define_class_under(mFox, "FXTIFImage", ((swig_class *) SWIGTYPE_p_FXImage->clientdata)->klass);
    SWIG_TypeClientData(SWIGTYPE_p_FXTIFImage, (void *) &cFXTIFImage);
    rb_define_alloc_func(cFXTIFImage.klass, _wrap_FXTIFImage_allocate);
    rb_define_method(cFXTIFImage.klass, "initialize", VALUEFUNC(_wrap_new_FXTIFImage), -1);
    rb_define_method(cFXTIFImage.klass, "setCodec", VALUEFUNC(_wrap_FXTIFImage_setCodec), -1);
    rb_define_method(cFXTIFImage.klass, "getCodec", VALUEFUNC(_wrap_FXTIFImage_getCodec), -1);
    rb_define_method(cFXTIFImage.klass, "save", VALUEFUNC(_wrap_FXTIFImage_save), -1);
    rb_define_method(cFXTIFImage.klass, "load", VALUEFUNC(_wrap_FXTIFImage_load), -1);
    rb_define_method(cFXTIFImage.klass, "create", VALUEFUNC(_wrap_FXTIFImage_create), -1);
    rb_define_method(cFXTIFImage.klass, "detach", VALUEFUNC(_wrap_FXTIFImage_detach), -1);
    rb_define_method(cFXTIFImage.klass, "destroy", VALUEFUNC(_wrap_FXTIFImage_destroy), -1);
    rb_define_method(cFXTIFImage.klass, "resize", VALUEFUNC(_wrap_FXTIFImage_resize), -1);
    rb_define_method(cFXTIFImage.klass, "restore", VALUEFUNC(_wrap_FXTIFImage_restore), -1);
    rb_define_method(cFXTIFImage.klass, "render", VALUEFUNC(_wrap_FXTIFImage_render), -1);
    rb_define_method(cFXTIFImage.klass, "release", VALUEFUNC(_wrap_FXTIFImage_release), -1);
    rb_define_method(cFXTIFImage.klass, "scale", VALUEFUNC(_wrap_FXTIFImage_scale), -1);
    rb_define_method(cFXTIFImage.klass, "mirror", VALUEFUNC(_wrap_FXTIFImage_mirror), -1);
    rb_define_method(cFXTIFImage.klass, "rotate", VALUEFUNC(_wrap_FXTIFImage_rotate), -1);
    rb_define_method(cFXTIFImage.klass, "crop", VALUEFUNC(_wrap_FXTIFImage_crop), -1);
    rb_define_method(cFXTIFImage.klass, "fill", VALUEFUNC(_wrap_FXTIFImage_fill), -1);
    rb_define_method(cFXTIFImage.klass, "fade", VALUEFUNC(_wrap_FXTIFImage_fade), -1);
    rb_define_method(cFXTIFImage.klass, "xshear", VALUEFUNC(_wrap_FXTIFImage_xshear), -1);
    rb_define_method(cFXTIFImage.klass, "yshear", VALUEFUNC(_wrap_FXTIFImage_yshear), -1);
    rb_define_method(cFXTIFImage.klass, "hgradient", VALUEFUNC(_wrap_FXTIFImage_hgradient), -1);
    rb_define_method(cFXTIFImage.klass, "vgradient", VALUEFUNC(_wrap_FXTIFImage_vgradient), -1);
    rb_define_method(cFXTIFImage.klass, "gradient", VALUEFUNC(_wrap_FXTIFImage_gradient), -1);
    rb_define_method(cFXTIFImage.klass, "blend", VALUEFUNC(_wrap_FXTIFImage_blend), -1);
    rb_define_method(cFXTIFImage.klass, "savePixels", VALUEFUNC(_wrap_FXTIFImage_savePixels), -1);
    rb_define_method(cFXTIFImage.klass, "loadPixels", VALUEFUNC(_wrap_FXTIFImage_loadPixels), -1);
    cFXTIFImage.mark = (void (*)(void *)) FXRbTIFImage::markfunc;
    cFXTIFImage.destroy = (void (*)(void *)) FXRbObject::freefunc;
    rb_define_module_function(mFox, "fxloadTIF", VALUEFUNC(_wrap_fxloadTIF), -1);
    rb_define_module_function(mFox, "fxsaveTIF", VALUEFUNC(_wrap_fxsaveTIF), -1);
    
    cFXXBMImage.klass = rb_define_class_under(mFox, "FXXBMImage", ((swig_class *) SWIGTYPE_p_FXImage->clientdata)->klass);
    SWIG_TypeClientData(SWIGTYPE_p_FXXBMImage, (void *) &cFXXBMImage);
    rb_define_alloc_func(cFXXBMImage.klass, _wrap_FXXBMImage_allocate);
    rb_define_method(cFXXBMImage.klass, "initialize", VALUEFUNC(_wrap_new_FXXBMImage), -1);
    rb_define_method(cFXXBMImage.klass, "save", VALUEFUNC(_wrap_FXXBMImage_save), -1);
    rb_define_method(cFXXBMImage.klass, "load", VALUEFUNC(_wrap_FXXBMImage_load), -1);
    rb_define_method(cFXXBMImage.klass, "create", VALUEFUNC(_wrap_FXXBMImage_create), -1);
    rb_define_method(cFXXBMImage.klass, "detach", VALUEFUNC(_wrap_FXXBMImage_detach), -1);
    rb_define_method(cFXXBMImage.klass, "destroy", VALUEFUNC(_wrap_FXXBMImage_destroy), -1);
    rb_define_method(cFXXBMImage.klass, "resize", VALUEFUNC(_wrap_FXXBMImage_resize), -1);
    rb_define_method(cFXXBMImage.klass, "restore", VALUEFUNC(_wrap_FXXBMImage_restore), -1);
    rb_define_method(cFXXBMImage.klass, "render", VALUEFUNC(_wrap_FXXBMImage_render), -1);
    rb_define_method(cFXXBMImage.klass, "release", VALUEFUNC(_wrap_FXXBMImage_release), -1);
    rb_define_method(cFXXBMImage.klass, "scale", VALUEFUNC(_wrap_FXXBMImage_scale), -1);
    rb_define_method(cFXXBMImage.klass, "mirror", VALUEFUNC(_wrap_FXXBMImage_mirror), -1);
    rb_define_method(cFXXBMImage.klass, "rotate", VALUEFUNC(_wrap_FXXBMImage_rotate), -1);
    rb_define_method(cFXXBMImage.klass, "crop", VALUEFUNC(_wrap_FXXBMImage_crop), -1);
    rb_define_method(cFXXBMImage.klass, "fill", VALUEFUNC(_wrap_FXXBMImage_fill), -1);
    rb_define_method(cFXXBMImage.klass, "fade", VALUEFUNC(_wrap_FXXBMImage_fade), -1);
    rb_define_method(cFXXBMImage.klass, "xshear", VALUEFUNC(_wrap_FXXBMImage_xshear), -1);
    rb_define_method(cFXXBMImage.klass, "yshear", VALUEFUNC(_wrap_FXXBMImage_yshear), -1);
    rb_define_method(cFXXBMImage.klass, "hgradient", VALUEFUNC(_wrap_FXXBMImage_hgradient), -1);
    rb_define_method(cFXXBMImage.klass, "vgradient", VALUEFUNC(_wrap_FXXBMImage_vgradient), -1);
    rb_define_method(cFXXBMImage.klass, "gradient", VALUEFUNC(_wrap_FXXBMImage_gradient), -1);
    rb_define_method(cFXXBMImage.klass, "blend", VALUEFUNC(_wrap_FXXBMImage_blend), -1);
    rb_define_method(cFXXBMImage.klass, "savePixels", VALUEFUNC(_wrap_FXXBMImage_savePixels), -1);
    rb_define_method(cFXXBMImage.klass, "loadPixels", VALUEFUNC(_wrap_FXXBMImage_loadPixels), -1);
    cFXXBMImage.mark = 0;
    cFXXBMImage.destroy = (void (*)(void *)) FXRbObject::freefunc;
    rb_define_module_function(mFox, "fxloadXBM", VALUEFUNC(_wrap_fxloadXBM), -1);
    rb_define_module_function(mFox, "fxsaveXBM", VALUEFUNC(_wrap_fxsaveXBM), -1);
    rb_define_module_function(mFox, "fxsavePS", VALUEFUNC(_wrap_fxsavePS), -1);
    
    cFXXPMImage.klass = rb_define_class_under(mFox, "FXXPMImage", ((swig_class *) SWIGTYPE_p_FXImage->clientdata)->klass);
    SWIG_TypeClientData(SWIGTYPE_p_FXXPMImage, (void *) &cFXXPMImage);
    rb_define_alloc_func(cFXXPMImage.klass, _wrap_FXXPMImage_allocate);
    rb_define_method(cFXXPMImage.klass, "initialize", VALUEFUNC(_wrap_new_FXXPMImage), -1);
    rb_define_method(cFXXPMImage.klass, "save", VALUEFUNC(_wrap_FXXPMImage_save), -1);
    rb_define_method(cFXXPMImage.klass, "load", VALUEFUNC(_wrap_FXXPMImage_load), -1);
    rb_define_method(cFXXPMImage.klass, "create", VALUEFUNC(_wrap_FXXPMImage_create), -1);
    rb_define_method(cFXXPMImage.klass, "detach", VALUEFUNC(_wrap_FXXPMImage_detach), -1);
    rb_define_method(cFXXPMImage.klass, "destroy", VALUEFUNC(_wrap_FXXPMImage_destroy), -1);
    rb_define_method(cFXXPMImage.klass, "resize", VALUEFUNC(_wrap_FXXPMImage_resize), -1);
    rb_define_method(cFXXPMImage.klass, "restore", VALUEFUNC(_wrap_FXXPMImage_restore), -1);
    rb_define_method(cFXXPMImage.klass, "render", VALUEFUNC(_wrap_FXXPMImage_render), -1);
    rb_define_method(cFXXPMImage.klass, "release", VALUEFUNC(_wrap_FXXPMImage_release), -1);
    rb_define_method(cFXXPMImage.klass, "scale", VALUEFUNC(_wrap_FXXPMImage_scale), -1);
    rb_define_method(cFXXPMImage.klass, "mirror", VALUEFUNC(_wrap_FXXPMImage_mirror), -1);
    rb_define_method(cFXXPMImage.klass, "rotate", VALUEFUNC(_wrap_FXXPMImage_rotate), -1);
    rb_define_method(cFXXPMImage.klass, "crop", VALUEFUNC(_wrap_FXXPMImage_crop), -1);
    rb_define_method(cFXXPMImage.klass, "fill", VALUEFUNC(_wrap_FXXPMImage_fill), -1);
    rb_define_method(cFXXPMImage.klass, "fade", VALUEFUNC(_wrap_FXXPMImage_fade), -1);
    rb_define_method(cFXXPMImage.klass, "xshear", VALUEFUNC(_wrap_FXXPMImage_xshear), -1);
    rb_define_method(cFXXPMImage.klass, "yshear", VALUEFUNC(_wrap_FXXPMImage_yshear), -1);
    rb_define_method(cFXXPMImage.klass, "hgradient", VALUEFUNC(_wrap_FXXPMImage_hgradient), -1);
    rb_define_method(cFXXPMImage.klass, "vgradient", VALUEFUNC(_wrap_FXXPMImage_vgradient), -1);
    rb_define_method(cFXXPMImage.klass, "gradient", VALUEFUNC(_wrap_FXXPMImage_gradient), -1);
    rb_define_method(cFXXPMImage.klass, "blend", VALUEFUNC(_wrap_FXXPMImage_blend), -1);
    rb_define_method(cFXXPMImage.klass, "savePixels", VALUEFUNC(_wrap_FXXPMImage_savePixels), -1);
    rb_define_method(cFXXPMImage.klass, "loadPixels", VALUEFUNC(_wrap_FXXPMImage_loadPixels), -1);
    cFXXPMImage.mark = (void (*)(void *)) FXRbXPMImage::markfunc;
    cFXXPMImage.destroy = (void (*)(void *)) FXRbObject::freefunc;
}

