/***********************************************************************
 * FXRuby -- the Ruby language bindings for the FOX GUI toolkit.
 * Copyright (c) 2001-2003 by J. Lyle Johnson. All Rights Reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * For further information please contact the author by e-mail
 * at "lyle@users.sourceforge.net".
 ***********************************************************************/

/***********************************************************************
 * $Id: FXRbIconList.h,v 1.2 2005/02/27 21:05:22 lyle Exp $
 ***********************************************************************/

#ifndef FXRBICONLIST_H
#define FXRBICONLIST_H

#define DECLARE_FXICONITEM_STUBS(klass,subklass) \
inline void klass ## _draw(const klass* self,const FXIconList* list,FXDC& dc,FXint x,FXint y,FXint w,FXint h){ \
  FXASSERT(self->isMemberOf(FXMETACLASS(subklass))); \
  dynamic_cast<const subklass*>(self)->public_draw(list,dc,x,y,w,h); \
  } \
inline FXint klass ## _hitItem(const klass* self,const FXIconList* list,FXint rx,FXint ry,FXint rw,FXint rh){ \
  FXASSERT(self->isMemberOf(FXMETACLASS(subklass))); \
  return dynamic_cast<const subklass*>(self)->public_hitItem(list,rx,ry,rw,rh); \
  } \
inline void klass ## _drawBigIcon(const klass* self,const FXIconList* list,FXDC& dc,FXint x,FXint y,FXint w,FXint h){ \
  FXASSERT(self->isMemberOf(FXMETACLASS(subklass))); \
  dynamic_cast<const subklass*>(self)->public_drawBigIcon(list,dc,x,y,w,h); \
  } \
inline void klass ## _drawMiniIcon(const klass* self,const FXIconList* list,FXDC& dc,FXint x,FXint y,FXint w,FXint h){ \
  FXASSERT(self->isMemberOf(FXMETACLASS(subklass))); \
  dynamic_cast<const subklass*>(self)->public_drawMiniIcon(list,dc,x,y,w,h); \
  } \
inline void klass ## _drawDetails(const klass* self,const FXIconList* list,FXDC& dc,FXint x,FXint y,FXint w,FXint h){ \
  FXASSERT(self->isMemberOf(FXMETACLASS(subklass))); \
  dynamic_cast<const subklass*>(self)->public_drawDetails(list,dc,x,y,w,h); \
  } \
inline void klass ## _setText(klass* self,const FXString& text){ \
  self->klass::setText(text); \
  } \
inline void klass ## _setBigIcon(klass* self,FXIcon* icn){ \
  self->klass::setBigIcon(icn); \
  } \
inline void klass ## _setMiniIcon(klass* self,FXIcon* icn){ \
  self->klass::setMiniIcon(icn); \
  } \
inline void klass ## _setFocus(klass* self,FXbool focus){ \
  self->klass::setFocus(focus); \
  } \
inline void klass ## _setSelected(klass* self,FXbool selected){ \
  self->klass::setSelected(selected); \
  } \
inline void klass ## _setEnabled(klass* self,FXbool enabled){ \
  self->klass::setEnabled(enabled); \
  } \
inline void klass ## _setDraggable(klass* self,FXbool draggable){ \
  self->klass::setDraggable(draggable); \
  } \
inline void klass ## _setIconOwned(klass* self,FXuint owned){ \
  self->klass::setIconOwned(owned); \
  } \
inline FXint klass ## _getWidth(const klass* self,const FXIconList* list){ \
  return self->klass::getWidth(list); \
  } \
inline FXint klass ## _getHeight(const klass* self,const FXIconList* list){ \
  return self->klass::getHeight(list); \
  } \
inline void klass ## _create(klass* self){ \
  self->klass::create(); \
  } \
inline void klass ## _detach(klass* self){ \
  self->klass::detach(); \
  } \
inline void klass ## _destroy(klass* self){ \
  self->klass::destroy(); \
  }


#define IMPLEMENT_FXICONITEM_STUBS(klass,superklass) \
  void klass::draw(const FXIconList* list,FXDC& dc,FXint x,FXint y,FXint w,FXint h) const { \
    FXRbCallVoidMethod(this,rb_intern("draw"),list,dc,x,y,w,h); \
    } \
  void klass::public_draw(const FXIconList* list,FXDC& dc,FXint x,FXint y,FXint w,FXint h) const { \
    superklass::draw(list,dc,x,y,w,h); \
    } \
  FXint klass::hitItem(const FXIconList* list,FXint rx,FXint ry,FXint rw,FXint rh) const { \
    return FXRbCallIntMethod(this,rb_intern("hitItem"),list,rx,ry,rw,rh); \
    } \
  FXint klass::public_hitItem(const FXIconList* list,FXint rx,FXint ry,FXint rw,FXint rh) const { \
    return superklass::hitItem(list,rx,ry,rw,rh); \
    } \
  void klass::drawBigIcon(const FXIconList* list,FXDC& dc,FXint x,FXint y,FXint w,FXint h) const { \
    FXRbCallVoidMethod(this,rb_intern("drawBigIcon"),list,dc,x,y,w,h); \
    } \
  void klass::public_drawBigIcon(const FXIconList* list,FXDC& dc,FXint x,FXint y,FXint w,FXint h) const { \
    superklass::drawBigIcon(list,dc,x,y,w,h); \
    } \
  void klass::drawMiniIcon(const FXIconList* list,FXDC& dc,FXint x,FXint y,FXint w,FXint h) const { \
    FXRbCallVoidMethod(this,rb_intern("drawMiniIcon"),list,dc,x,y,w,h); \
    } \
  void klass::public_drawMiniIcon(const FXIconList* list,FXDC& dc,FXint x,FXint y,FXint w,FXint h) const { \
    superklass::drawMiniIcon(list,dc,x,y,w,h); \
    } \
  void klass::drawDetails(const FXIconList* list,FXDC& dc,FXint x,FXint y,FXint w,FXint h) const { \
    FXRbCallVoidMethod(this,rb_intern("drawDetails"),list,dc,x,y,w,h); \
    } \
  void klass::public_drawDetails(const FXIconList* list,FXDC& dc,FXint x,FXint y,FXint w,FXint h) const { \
    superklass::drawDetails(list,dc,x,y,w,h); \
    } \
  void klass::setText(const FXString& txt){ \
    FXRbCallVoidMethod(this,rb_intern("setText"),txt); \
    } \
  void klass::setBigIcon(FXIcon* icn){ \
    FXRbCallVoidMethod(this,rb_intern("setBigIcon"),icn); \
    } \
  void klass::setMiniIcon(FXIcon* icn){ \
    FXRbCallVoidMethod(this,rb_intern("setMiniIcon"),icn); \
    } \
  void klass::setFocus(FXbool focus){ \
    FXRbCallVoidMethod(this,rb_intern("setFocus"),focus); \
    } \
  void klass::setSelected(FXbool selected){ \
    FXRbCallVoidMethod(this,rb_intern("setSelected"),selected); \
    } \
  void klass::setEnabled(FXbool enabled){ \
    FXRbCallVoidMethod(this,rb_intern("setEnabled"),enabled); \
    } \
  void klass::setDraggable(FXbool draggable){ \
    FXRbCallVoidMethod(this,rb_intern("setDraggable"),draggable); \
    } \
  void klass::setIconOwned(FXuint owned){ \
    FXRbCallVoidMethod(this,rb_intern("setIconOwned"),owned); \
    } \
  FXint klass::getWidth(const FXIconList* list) const { \
    return FXRbCallIntMethod(this,rb_intern("getWidth"),list); \
    } \
  FXint klass::getHeight(const FXIconList* list) const { \
    return FXRbCallIntMethod(this,rb_intern("getHeight"),list); \
    } \
  void klass::create(){ \
    FXRbCallVoidMethod(this,rb_intern("create")); \
    } \
  void klass::detach(){ \
    FXRbCallVoidMethod(this,rb_intern("detach")); \
    } \
  void klass::destroy(){ \
    FXRbCallVoidMethod(this,rb_intern("destroy")); \
    }


class FXRbIconItem : public FXIconItem {
  FXDECLARE(FXRbIconItem)
protected:
  FXRbIconItem(){}
#include "FXRbObjectVirtuals.h"
#include "FXRbIconItemVirtuals.h"
public:
  // Is this icon item owned by an FXIconList yet?
  FXbool owned;
public:
  // Constructor
  FXRbIconItem(const FXString& text,FXIcon* bi=NULL,FXIcon* mi=NULL,void* ptr=NULL) : FXIconItem(text,bi,mi,ptr),owned(FALSE){}

  // Mark dependencies for the GC
  static void markfunc(FXIconItem* self);

  // Destroy this object if it's not owned
  static void freefunc(FXIconItem* self);

  // Destructor
  virtual ~FXRbIconItem(){
    FXRbUnregisterRubyObj(this);
    }
  };


#define DECLARE_FXICONLIST_STUBS(klass) \
inline FXbool klass ## _selectItem(klass* self,FXint index,FXbool notify){ \
  return self->klass::selectItem(index,notify); \
  } \
inline FXbool klass ## _deselectItem(klass* self,FXint index,FXbool notify){ \
  return self->klass::deselectItem(index,notify); \
  } \
inline FXbool klass ## _toggleItem(klass* self,FXint index,FXbool notify){ \
  return self->klass::toggleItem(index,notify); \
  } \
inline FXbool klass ## _selectInRectangle(klass* self,FXint x,FXint y,FXint w,FXint h,FXbool notify){ \
  return self->klass::selectInRectangle(x,y,w,h,notify); \
  } \
inline FXbool klass ## _extendSelection(klass* self,FXint index,FXbool notify){ \
  return self->klass::extendSelection(index,notify); \
  } \
inline FXbool klass ## _killSelection(klass* self,FXbool notify){ \
  return self->klass::killSelection(notify); \
  } \
inline void klass ## _setCurrentItem(klass* self,FXint index,FXbool notify){ \
  self->klass::setCurrentItem(index,notify); \
  }


#define IMPLEMENT_FXICONLIST_STUBS(cls) \
  FXbool cls::selectItem(FXint index,FXbool notify){ \
    return FXRbCallBoolMethod(this,rb_intern("selectItem"),index,notify); \
    } \
  FXbool cls::deselectItem(FXint index,FXbool notify){ \
    return FXRbCallBoolMethod(this,rb_intern("deselectItem"),index,notify); \
    } \
  FXbool cls::toggleItem(FXint index,FXbool notify){ \
    return FXRbCallBoolMethod(this,rb_intern("toggleItem"),index,notify); \
    } \
  FXbool cls::selectInRectangle(FXint x,FXint y,FXint w,FXint h,FXbool notify){ \
    return FXRbCallBoolMethod(this,rb_intern("selectInRectangle"),x,y,w,h,notify); \
    } \
  FXbool cls::extendSelection(FXint index,FXbool notify){ \
    return FXRbCallBoolMethod(this,rb_intern("extendSelection"),index,notify); \
    } \
  FXbool cls::killSelection(FXbool notify){ \
    return FXRbCallBoolMethod(this,rb_intern("killSelection"),notify); \
    } \
  void cls::setCurrentItem(FXint index,FXbool notify){ \
    FXRbCallVoidMethod(this,rb_intern("setCurrentItem"),index,notify); \
    }


class FXRbIconList : public FXIconList {
  FXDECLARE(FXRbIconList)
protected:
  FXRbIconList(){}
#include "FXRbObjectVirtuals.h"
#include "FXRbIdVirtuals.h"
#include "FXRbDrawableVirtuals.h"
#include "FXRbWindowVirtuals.h"
#include "FXRbScrollAreaVirtuals.h"
#include "FXRbIconListVirtuals.h"
public:
  /// Construct icon list
  FXRbIconList(FXComposite *p,FXObject* tgt=NULL,FXSelector sel=0,FXuint opts=ICONLIST_NORMAL,FXint x=0,FXint y=0,FXint w=0,FXint h=0) : FXIconList(p,tgt,sel,opts,x,y,w,h){
    setSortFunc(FXRbIconList::sortFunc);
    }

  // Mark dependencies for the GC
  static void markfunc(FXIconList* self);

  // Unregister objects that this icon list owns and is about to destroy
  static void unregisterOwnedObjects(FXIconList *pIconList);

  // Sort function stand-in
  static FXint sortFunc(const FXIconItem* a,const FXIconItem* b);

  // Destructor
  virtual ~FXRbIconList(){
    FXRbIconList::unregisterOwnedObjects(this);
    FXRbUnregisterRubyObj(this);
    }
  };

#endif
