/***********************************************************************
 * FXRuby -- the Ruby language bindings for the FOX GUI toolkit.
 * Copyright (c) 2001 by J. Lyle Johnson. All Rights Reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * For further information please contact the author by e-mail
 * at "lyle@users.sourceforge.net".
 ***********************************************************************/

/***********************************************************************
 * $Id: FXRbToolBar.h,v 1.1 2004/08/07 10:55:26 lyle Exp $
 ***********************************************************************/

#ifndef FXRBTOOLBAR_H
#define FXRBTOOLBAR_H

#define DECLARE_FXTOOLBAR_STUBS(klass) \
  inline void klass ## _dock(klass* self,FXuint side,FXWindow* after){ \
    self->klass::dock(side,after); \
    } \
  inline void klass ## _undock(klass* self){ \
    self->klass::undock(); \
    }

#define IMPLEMENT_FXTOOLBAR_STUBS(cls) \
  void cls::dock(FXuint side,FXWindow* after){ \
    FXRbCallVoidMethod(this,rb_intern("dock"),side,after); \
    } \
  void cls::undock(){ \
    FXRbCallVoidMethod(this,rb_intern("undock")); \
    }


class FXRbToolBar : public FXToolBar {
  FXDECLARE(FXRbToolBar)
protected:
  FXRbToolBar(){}
#include "FXRbObjectVirtuals.h"
#include "FXRbIdVirtuals.h"
#include "FXRbDrawableVirtuals.h"
#include "FXRbWindowVirtuals.h"
#include "FXRbToolBarVirtuals.h"
public:
  /**
  * Construct a floatable toolbar 
  * Normally, the toolbar is docked under window p.
  * When floated, the toolbar can be docked under window q, which is
  * typically an FXToolBarShell window.
  */
  FXRbToolBar(FXComposite* p,FXComposite* q,FXuint opts=LAYOUT_TOP|LAYOUT_LEFT|LAYOUT_FILL_X,FXint x=0,FXint y=0,FXint w=0,FXint h=0,FXint pl=3,FXint pr=3,FXint pt=2,FXint pb=2,FXint hs=DEFAULT_SPACING,FXint vs=DEFAULT_SPACING) : FXToolBar(p,q,opts,x,y,w,h,pl,pr,pt,pb,hs,vs){}

  /**
  * Construct a non-floatable toolbar.
  * The toolbar can not be undocked.
  */
  FXRbToolBar(FXComposite* p,FXuint opts=LAYOUT_TOP|LAYOUT_LEFT|LAYOUT_FILL_X,FXint x=0,FXint y=0,FXint w=0,FXint h=0,FXint pl=2,FXint pr=3,FXint pt=3,FXint pb=2,FXint hs=DEFAULT_SPACING,FXint vs=DEFAULT_SPACING) : FXToolBar(p,opts,x,y,w,h,pl,pr,pt,pb,hs,vs){}

  // Destructor
  virtual ~FXRbToolBar(){
    FXRbUnregisterRubyObj(this);
    }

  // Mark dependencies for the GC
  static void markfunc(FXToolBar* self);
  };

#endif
