/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 1.3.22
 * 
 * This file is not intended to be easily readable and contains a number of 
 * coding conventions designed to improve portability and efficiency. Do not make
 * changes to this file unless you know what you are doing--modify the SWIG 
 * interface file instead. 
 * ----------------------------------------------------------------------------- */

#define SWIG_NOINCLUDE

#ifdef __cplusplus
template<class T> class SwigValueWrapper {
    T *tt;
public:
    SwigValueWrapper() : tt(0) { }
    SwigValueWrapper(const SwigValueWrapper<T>& rhs) : tt(new T(*rhs.tt)) { }
    SwigValueWrapper(const T& t) : tt(new T(t)) { }
    ~SwigValueWrapper() { delete tt; } 
    SwigValueWrapper& operator=(const T& t) { delete tt; tt = new T(t); return *this; }
    operator T&() const { return *tt; }
    T *operator&() { return tt; }
private:
    SwigValueWrapper& operator=(const SwigValueWrapper<T>& rhs);
};                                                    
#endif

/* ruby.swg */
/* Implementation : RUBY */
#define SWIGRUBY 1

#include "ruby.h"

/* Flags for pointer conversion */
#define SWIG_POINTER_EXCEPTION     0x1
#define SWIG_POINTER_DISOWN        0x2

#define NUM2USHRT(n) (\
    (0 <= NUM2UINT(n) && NUM2UINT(n) <= USHRT_MAX)\
    ? (unsigned short) NUM2UINT(n) \
    : (rb_raise(rb_eArgError, "integer %d out of range of `unsigned short'",\
               NUM2UINT(n)), (short)0)\
)

#define NUM2SHRT(n) (\
    (SHRT_MIN <= NUM2INT(n) && NUM2INT(n) <= SHRT_MAX)\
    ? (short)NUM2INT(n)\
    : (rb_raise(rb_eArgError, "integer %d out of range of `short'",\
               NUM2INT(n)), (short)0)\
)

/* Ruby 1.7 defines NUM2LL(), LL2NUM() and ULL2NUM() macros */
#ifndef NUM2LL
#define NUM2LL(x) NUM2LONG((x))
#endif
#ifndef LL2NUM
#define LL2NUM(x) INT2NUM((long) (x))
#endif
#ifndef ULL2NUM
#define ULL2NUM(x) UINT2NUM((unsigned long) (x))
#endif

/* Ruby 1.7 doesn't (yet) define NUM2ULL() */
#ifndef NUM2ULL
#ifdef HAVE_LONG_LONG
#define NUM2ULL(x) rb_num2ull((x))
#else
#define NUM2ULL(x) NUM2ULONG(x)
#endif
#endif

/*
 * Need to be very careful about how these macros are defined, especially
 * when compiling C++ code or C code with an ANSI C compiler.
 *
 * VALUEFUNC(f) is a macro used to typecast a C function that implements
 * a Ruby method so that it can be passed as an argument to API functions
 * like rb_define_method() and rb_define_singleton_method().
 *
 * VOIDFUNC(f) is a macro used to typecast a C function that implements
 * either the "mark" or "free" stuff for a Ruby Data object, so that it
 * can be passed as an argument to API functions like Data_Wrap_Struct()
 * and Data_Make_Struct().
 */
 
#ifdef __cplusplus
#  ifndef RUBY_METHOD_FUNC /* These definitions should work for Ruby 1.4.6 */
#    define PROTECTFUNC(f) ((VALUE (*)()) f)
#    define VALUEFUNC(f) ((VALUE (*)()) f)
#    define VOIDFUNC(f)  ((void (*)()) f)
#  else
#    ifndef ANYARGS /* These definitions should work for Ruby 1.6 */
#      define PROTECTFUNC(f) ((VALUE (*)()) f)
#      define VALUEFUNC(f) ((VALUE (*)()) f)
#      define VOIDFUNC(f)  ((RUBY_DATA_FUNC) f)
#    else /* These definitions should work for Ruby 1.7+ */
#      define PROTECTFUNC(f) ((VALUE (*)(VALUE)) f)
#      define VALUEFUNC(f) ((VALUE (*)(ANYARGS)) f)
#      define VOIDFUNC(f)  ((RUBY_DATA_FUNC) f)
#    endif
#  endif
#else
#  define VALUEFUNC(f) (f)
#  define VOIDFUNC(f) (f)
#endif

typedef struct {
  VALUE klass;
  VALUE mImpl;
  void  (*mark)(void *);
  void  (*destroy)(void *);
} swig_class;

/* Don't use for expressions have side effect */
#ifndef RB_STRING_VALUE
#define RB_STRING_VALUE(s) (TYPE(s) == T_STRING ? (s) : (*(volatile VALUE *)&(s) = rb_str_to_str(s)))
#endif
#ifndef StringValue
#define StringValue(s) RB_STRING_VALUE(s)
#endif
#ifndef StringValuePtr
#define StringValuePtr(s) RSTRING(RB_STRING_VALUE(s))->ptr
#endif
#ifndef StringValueLen
#define StringValueLen(s) RSTRING(RB_STRING_VALUE(s))->len
#endif
#ifndef SafeStringValue
#define SafeStringValue(v) do {\
    StringValue(v);\
    rb_check_safe_str(v);\
} while (0)
#endif

#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
#define rb_define_alloc_func(klass, func) rb_define_singleton_method((klass), "new", VALUEFUNC((func)), -1)
#define rb_undef_alloc_func(klass) rb_undef_method(CLASS_OF((klass)), "new")
#endif

/* Contract support */

#define SWIG_contract_assert(expr, msg) if (!(expr)) { rb_raise(rb_eRuntimeError, (char *) msg ); } else


/*************************************************************** -*- c -*-
 * ruby/precommon.swg
 *
 * Rename all exported symbols from common.swg, to avoid symbol
 * clashes if multiple interpreters are included
 *
 ************************************************************************/

#define SWIG_TypeRegister    SWIG_Ruby_TypeRegister
#define SWIG_TypeCheck       SWIG_Ruby_TypeCheck
#define SWIG_TypeCast        SWIG_Ruby_TypeCast
#define SWIG_TypeDynamicCast SWIG_Ruby_TypeDynamicCast
#define SWIG_TypeName        SWIG_Ruby_TypeName
#define SWIG_TypePrettyName  SWIG_Ruby_TypePrettyName
#define SWIG_TypeQuery       SWIG_Ruby_TypeQuery
#define SWIG_TypeClientData  SWIG_Ruby_TypeClientData
#define SWIG_PackData        SWIG_Ruby_PackData 
#define SWIG_UnpackData      SWIG_Ruby_UnpackData 

/* Also rename all exported symbols from rubydef.swig */

/* Common SWIG API */
#define SWIG_ConvertPtr(obj, pp, type, flags) \
  SWIG_Ruby_ConvertPtr(obj, pp, type, flags)
#define SWIG_NewPointerObj(p, type, flags) \
  SWIG_Ruby_NewPointerObj(p, type, flags)
#define SWIG_MustGetPtr(p, type, argnum, flags) \
  SWIG_Ruby_MustGetPtr(p, type, argnum, flags)

/* Ruby-specific SWIG API */

#define SWIG_InitRuntime() \
  SWIG_Ruby_InitRuntime()
#define SWIG_define_class(ty) \
  SWIG_Ruby_define_class(ty)
#define SWIG_NewClassInstance(value, ty) \
  SWIG_Ruby_NewClassInstance(value, ty)
#define SWIG_MangleStr(value) \
  SWIG_Ruby_MangleStr(value)
#define SWIG_CheckConvert(value, ty) \
  SWIG_Ruby_CheckConvert(value, ty)
#define SWIG_NewPackedObj(ptr, sz, ty) \
  SWIG_Ruby_NewPackedObj(ptr, sz, ty)
#define SWIG_ConvertPacked(obj, ptr, sz, ty, flags) \
  SWIG_Ruby_ConvertPacked(obj, ptr, sz, ty, flags)


/***********************************************************************
 * common.swg
 *
 *     This file contains generic SWIG runtime support for pointer
 *     type checking as well as a few commonly used macros to control
 *     external linkage.
 *
 * Author : David Beazley (beazley@cs.uchicago.edu)
 *
 * Copyright (c) 1999-2000, The University of Chicago
 * 
 * This file may be freely redistributed without license or fee provided
 * this copyright message remains intact.
 ************************************************************************/

#include <string.h>

#if defined(_WIN32) || defined(__WIN32__) || defined(__CYGWIN__)
#  if defined(_MSC_VER) || defined(__GNUC__)
#    if defined(STATIC_LINKED)
#      define SWIGEXPORT(a) a
#      define SWIGIMPORT(a) extern a
#    else
#      define SWIGEXPORT(a) __declspec(dllexport) a
#      define SWIGIMPORT(a) extern a
#    endif
#  else
#    if defined(__BORLANDC__)
#      define SWIGEXPORT(a) a _export
#      define SWIGIMPORT(a) a _export
#    else
#      define SWIGEXPORT(a) a
#      define SWIGIMPORT(a) a
#    endif
#  endif
#else
#  define SWIGEXPORT(a) a
#  define SWIGIMPORT(a) a
#endif

#ifdef SWIG_GLOBAL
#  define SWIGRUNTIME(a) SWIGEXPORT(a)
#else
#  define SWIGRUNTIME(a) static a
#endif

#ifdef __cplusplus
extern "C" {
#endif

typedef void *(*swig_converter_func)(void *);
typedef struct swig_type_info *(*swig_dycast_func)(void **);

typedef struct swig_type_info {
  const char             *name;
  swig_converter_func     converter;
  const char             *str;
  void                   *clientdata;
  swig_dycast_func        dcast;
  struct swig_type_info  *next;
  struct swig_type_info  *prev;
} swig_type_info;

#ifdef SWIG_NOINCLUDE

SWIGIMPORT(swig_type_info *) SWIG_TypeRegister(swig_type_info *);
SWIGIMPORT(swig_type_info *) SWIG_TypeCheck(char *c, swig_type_info *);
SWIGIMPORT(void *)           SWIG_TypeCast(swig_type_info *, void *);
SWIGIMPORT(swig_type_info *) SWIG_TypeDynamicCast(swig_type_info *, void **);
SWIGIMPORT(const char *)     SWIG_TypeName(const swig_type_info *);
SWIGIMPORT(const char *)     SWIG_TypePrettyName(const swig_type_info *);
SWIGIMPORT(swig_type_info *) SWIG_TypeQuery(const char *);
SWIGIMPORT(void)             SWIG_TypeClientData(swig_type_info *, void *);
SWIGIMPORT(char *)           SWIG_PackData(char *, void *, int);
SWIGIMPORT(char *)           SWIG_UnpackData(char *, void *, int);

#else

static swig_type_info *swig_type_list = 0;
static swig_type_info **swig_type_list_handle = &swig_type_list;

/* Register a type mapping with the type-checking */
SWIGRUNTIME(swig_type_info *)
SWIG_TypeRegister(swig_type_info *ti) {
  swig_type_info *tc, *head, *ret, *next;
  /* Check to see if this type has already been registered */
  tc = *swig_type_list_handle;
  while (tc) {
    if (strcmp(tc->name, ti->name) == 0) {
      /* Already exists in the table.  Just add additional types to the list */
      if (tc->clientdata) ti->clientdata = tc->clientdata;
      head = tc;
      next = tc->next;
      goto l1;
    }
    tc = tc->prev;
  }
  head = ti;
  next = 0;

  /* Place in list */
  ti->prev = *swig_type_list_handle;
  *swig_type_list_handle = ti;

  /* Build linked lists */
  l1:
  ret = head;
  tc = ti + 1;
  /* Patch up the rest of the links */
  while (tc->name) {
    head->next = tc;
    tc->prev = head;
    head = tc;
    tc++;
  }
  if (next) next->prev = head;
  head->next = next;
  return ret;
}

/* Check the typename */
SWIGRUNTIME(swig_type_info *) 
SWIG_TypeCheck(char *c, swig_type_info *ty) {
  swig_type_info *s;
  if (!ty) return 0;        /* Void pointer */
  s = ty->next;             /* First element always just a name */
  do {
    if (strcmp(s->name,c) == 0) {
      if (s == ty->next) return s;
      /* Move s to the top of the linked list */
      s->prev->next = s->next;
      if (s->next) {
        s->next->prev = s->prev;
      }
      /* Insert s as second element in the list */
      s->next = ty->next;
      if (ty->next) ty->next->prev = s;
      ty->next = s;
      s->prev = ty;
      return s;
    }
    s = s->next;
  } while (s && (s != ty->next));
  return 0;
}

/* Cast a pointer up an inheritance hierarchy */
SWIGRUNTIME(void *) 
SWIG_TypeCast(swig_type_info *ty, void *ptr) {
  if ((!ty) || (!ty->converter)) return ptr;
  return (*ty->converter)(ptr);
}

/* Dynamic pointer casting. Down an inheritance hierarchy */
SWIGRUNTIME(swig_type_info *) 
SWIG_TypeDynamicCast(swig_type_info *ty, void **ptr) {
  swig_type_info *lastty = ty;
  if (!ty || !ty->dcast) return ty;
  while (ty && (ty->dcast)) {
    ty = (*ty->dcast)(ptr);
    if (ty) lastty = ty;
  }
  return lastty;
}

/* Return the name associated with this type */
SWIGRUNTIME(const char *)
SWIG_TypeName(const swig_type_info *ty) {
  return ty->name;
}

/* Return the pretty name associated with this type,
   that is an unmangled type name in a form presentable to the user.
*/
SWIGRUNTIME(const char *)
SWIG_TypePrettyName(const swig_type_info *type) {
  /* The "str" field contains the equivalent pretty names of the
     type, separated by vertical-bar characters.  We choose
     to print the last name, as it is often (?) the most
     specific. */
  if (type->str != NULL) {
    const char *last_name = type->str;
    const char *s;
    for (s = type->str; *s; s++)
      if (*s == '|') last_name = s+1;
    return last_name;
  }
  else
    return type->name;
}

/* 
   Compare two type names skipping the space characters, therefore
   "char*" == "char *" and "Class<int>" == "Class<int >", etc.

   Return 0 when the two name types are equivalent, as in
   strncmp, but skipping ' '.
*/
static int
SWIG_TypeNameComp(const char *f1, const char *l1,
		  const char *f2, const char *l2) {
  for (;(f1 != l1) && (f2 != l2); ++f1, ++f2) {
    while ((*f1 == ' ') && (f1 != l1)) ++f1;
    while ((*f2 == ' ') && (f2 != l2)) ++f2;
    if (*f1 != *f2) return *f1 - *f2;
  }
  return (l1 - f1) - (l2 - f2);
}

/*
  Check type equivalence in a name list like <name1>|<name2>|...
*/
static int
SWIG_TypeEquiv(const char *nb, const char *tb) {
  int equiv = 0;
  const char* te = tb + strlen(tb);
  const char* ne = nb;
  while (!equiv && *ne) {
    for (nb = ne; *ne; ++ne) {
      if (*ne == '|') break;
    }
    equiv = SWIG_TypeNameComp(nb, ne, tb, te) == 0;
    if (*ne) ++ne;
  }
  return equiv;
}
  

/* Search for a swig_type_info structure */
SWIGRUNTIME(swig_type_info *)
SWIG_TypeQuery(const char *name) {
  swig_type_info *ty = *swig_type_list_handle;
  while (ty) {
    if (ty->str && (SWIG_TypeEquiv(ty->str,name))) return ty;
    if (ty->name && (strcmp(name,ty->name) == 0)) return ty;
    ty = ty->prev;
  }
  return 0;
}

/* Set the clientdata field for a type */
SWIGRUNTIME(void)
SWIG_TypeClientData(swig_type_info *ti, void *clientdata) {
  swig_type_info *tc, *equiv;
  if (ti->clientdata == clientdata) return;
  ti->clientdata = clientdata;
  equiv = ti->next;
  while (equiv) {
    if (!equiv->converter) {
      tc = *swig_type_list_handle;
      while (tc) {
        if ((strcmp(tc->name, equiv->name) == 0))
          SWIG_TypeClientData(tc,clientdata);
        tc = tc->prev;
      }
    }
    equiv = equiv->next;
  }
}

/* Pack binary data into a string */
SWIGRUNTIME(char *)
SWIG_PackData(char *c, void *ptr, int sz) {
  static char hex[17] = "0123456789abcdef";
  unsigned char *u = (unsigned char *) ptr;
  const unsigned char *eu =  u + sz;
  register unsigned char uu;
  for (; u != eu; ++u) {
    uu = *u;
    *(c++) = hex[(uu & 0xf0) >> 4];
    *(c++) = hex[uu & 0xf];
  }
  return c;
}

/* Unpack binary data from a string */
SWIGRUNTIME(char *)
SWIG_UnpackData(char *c, void *ptr, int sz) {
  register unsigned char uu = 0;
  register int d;
  unsigned char *u = (unsigned char *) ptr;
  const unsigned char *eu =  u + sz;
  for (; u != eu; ++u) {
    d = *(c++);
    if ((d >= '0') && (d <= '9'))
      uu = ((d - '0') << 4);
    else if ((d >= 'a') && (d <= 'f'))
      uu = ((d - ('a'-10)) << 4);
    d = *(c++);
    if ((d >= '0') && (d <= '9'))
      uu |= (d - '0');
    else if ((d >= 'a') && (d <= 'f'))
      uu |= (d - ('a'-10));
    *u = uu;
  }
  return c;
}

#endif

#ifdef __cplusplus
}
#endif

/* rubydec.swg -*- c -*- */
#ifdef __cplusplus
extern "C" {
#endif

SWIGIMPORT(void)   SWIG_Ruby_InitRuntime(void);
SWIGIMPORT(void)   SWIG_Ruby_define_class(swig_type_info *);
SWIGIMPORT(VALUE)  SWIG_Ruby_NewPointerObj(void *, swig_type_info *, int);
SWIGIMPORT(VALUE)  SWIG_Ruby_NewClassInstance(VALUE, swig_type_info *);
SWIGIMPORT(char *) SWIG_Ruby_MangleStr(VALUE);
SWIGIMPORT(int)    SWIG_Ruby_ConvertPtr(VALUE, void**, swig_type_info *, int);
SWIGIMPORT(void *) SWIG_Ruby_MustGetPtr(VALUE, swig_type_info *, int, int);
SWIGIMPORT(int)    SWIG_Ruby_CheckConvert(VALUE, swig_type_info *);
SWIGIMPORT(VALUE)  SWIG_Ruby_NewPackedObj(void *ptr, int sz, swig_type_info *type);
SWIGIMPORT(void)   SWIG_Ruby_ConvertPacked(VALUE obj, void *ptr, int sz, swig_type_info *ty, int flags);

#ifdef __cplusplus
}
#endif


/* -------- TYPES TABLE (BEGIN) -------- */

#define  SWIGTYPE_p_FXFrame swig_types[0] 
#define  SWIGTYPE_p_FXObject swig_types[1] 
#define  SWIGTYPE_p_FXPopup swig_types[2] 
#define  SWIGTYPE_p_FXPicker swig_types[3] 
#define  SWIGTYPE_p_FXMenuButton swig_types[4] 
#define  SWIGTYPE_p_FXCheckButton swig_types[5] 
#define  SWIGTYPE_p_FXToggleButton swig_types[6] 
#define  SWIGTYPE_p_FXLabel swig_types[7] 
#define  SWIGTYPE_p_FXWindow swig_types[8] 
#define  SWIGTYPE_p_FXComposite swig_types[9] 
#define  SWIGTYPE_p_FXRadioButton swig_types[10] 
#define  SWIGTYPE_p_FXTriStateButton swig_types[11] 
#define  SWIGTYPE_p_FXFont swig_types[12] 
#define  SWIGTYPE_p_FXId swig_types[13] 
#define  SWIGTYPE_p_FXTabBar swig_types[14] 
#define  SWIGTYPE_p_FXButton swig_types[15] 
#define  SWIGTYPE_p_FXStream swig_types[16] 
#define  SWIGTYPE_p_FXDrawable swig_types[17] 
#define  SWIGTYPE_p_FXTabItem swig_types[18] 
#define  SWIGTYPE_p_FXIcon swig_types[19] 
#define  SWIGTYPE_p_FXOption swig_types[20] 
#define  SWIGTYPE_p_FXOptionMenu swig_types[21] 
static swig_type_info *swig_types[23];

/* -------- TYPES TABLE (END) -------- */

#define SWIG_init    Init_label
#define SWIG_name    "Label"


static void SWIG_AsVal(VALUE obj, int *val)
{
    *val = (int) NUM2INT(obj);
}


#include "FXRbCommon.h"


inline FXColor to_FXColor(VALUE obj){
  if(TYPE(obj)==T_STRING){
    return fxcolorfromname(StringValuePtr(obj));
    }
  else if(TYPE(obj)==T_SYMBOL){
    return fxcolorfromname(rb_id2name(SYM2ID(obj)));
    }
  else{
    return NUM2ULONG(obj);
    }
  }


inline FXString to_FXString(VALUE obj){
  if(!NIL_P(obj)){
    Check_Type(obj,T_STRING);
    return FXString(STR2CSTR(obj));
    }
  else{
    return FXString::null;
    }
  }


inline FXbool to_FXbool(VALUE obj){
  if (obj == Qtrue || obj == Qfalse){
    return (obj == Qtrue) ? TRUE : FALSE;
    }
  else{
    return static_cast<FXbool>(NUM2UINT(obj));
    }
  }


static swig_type_info* FXEventTypeInfo=0;

inline void* to_FXEvent(VALUE obj){
  void* ptr;
  if(!FXEventTypeInfo){
    FXEventTypeInfo=SWIG_TypeQuery("FXEvent *");
    FXASSERT(FXEventTypeInfo!=0);
    }
  SWIG_ConvertPtr(obj,&ptr,FXEventTypeInfo,1);
  return ptr;
  }

FXLabel *new_FXLabel(FXComposite *p,FXString const &text,FXIcon *ic,FXuint opts,FXint x,FXint y,FXint w,FXint h,FXint pl,FXint pr,FXint pt,FXint pb){
      return new FXRbLabel(p,text,ic,opts,x,y,w,h,pl,pr,pt,pb);
      }

swig_class cFXLabel;
static void free_FXLabel(FXLabel *);

static swig_type_info *FXLabel_dynamic_cast(void **ptr) {
    FXLabel **ppLabel = reinterpret_cast<FXLabel **>(ptr);
    FXButton *pButton=dynamic_cast<FXButton*>(*ppLabel);
    if(pButton){
      *ptr=reinterpret_cast<void*>(pButton);
      return SWIG_TypeQuery("FXButton *");
      }
    FXCheckButton *pCheckButton=dynamic_cast<FXCheckButton*>(*ppLabel);
    if(pCheckButton){
      *ptr=reinterpret_cast<void*>(pCheckButton);
      return SWIG_TypeQuery("FXCheckButton *");
      }
    FXMenuButton *pMenuButton=dynamic_cast<FXMenuButton*>(*ppLabel);
    if(pMenuButton){
      *ptr=reinterpret_cast<void*>(pMenuButton);
      return SWIG_TypeQuery("FXMenuButton *");
      }
    FXOption *pOption=dynamic_cast<FXOption*>(*ppLabel);
    if(pOption){
      *ptr=reinterpret_cast<void*>(pOption);
      return SWIG_TypeQuery("FXOption *");
      }
    FXOptionMenu *pOptionMenu=dynamic_cast<FXOptionMenu*>(*ppLabel);
    if(pOptionMenu){
      *ptr=reinterpret_cast<void*>(pOptionMenu);
      return SWIG_TypeQuery("FXOptionMenu *");
      }
    FXRadioButton *pRadioButton=dynamic_cast<FXRadioButton*>(*ppLabel);
    if(pRadioButton){
      *ptr=reinterpret_cast<void*>(pRadioButton);
      return SWIG_TypeQuery("FXRadioButton *");
      }
    FXTabItem *pTabItem=dynamic_cast<FXTabItem*>(*ppLabel);
    if(pTabItem){
      *ptr=reinterpret_cast<void*>(pTabItem);
      return SWIG_TypeQuery("FXTabItem *");
      }
    FXToggleButton *pToggleButton=dynamic_cast<FXToggleButton*>(*ppLabel);
    if(pToggleButton){
      *ptr=reinterpret_cast<void*>(pToggleButton);
      return SWIG_TypeQuery("FXToggleButton *");
      }
    return 0;
}

FXButton *new_FXButton(FXComposite *p,FXString const &text,FXIcon *ic,FXObject *tgt,FXSelector sel,FXuint opts,FXint x,FXint y,FXint w,FXint h,FXint pl,FXint pr,FXint pt,FXint pb){
      return new FXRbButton(p,text,ic,tgt,sel,opts,x,y,w,h,pl,pr,pt,pb);
      }

swig_class cFXButton;
static void free_FXButton(FXButton *);

static swig_type_info *FXButton_dynamic_cast(void **ptr) {
    FXButton **ppButton = reinterpret_cast<FXButton **>(ptr);
    FXMDIDeleteButton *pMDIDeleteButton=dynamic_cast<FXMDIDeleteButton*>(*ppButton);
    if(pMDIDeleteButton){
      *ptr=reinterpret_cast<void*>(pMDIDeleteButton);
      return SWIG_TypeQuery("FXMDIDeleteButton *");
      }
    FXMDIMaximizeButton *pMDIMaximizeButton=dynamic_cast<FXMDIMaximizeButton*>(*ppButton);
    if(pMDIMaximizeButton){
      *ptr=reinterpret_cast<void*>(pMDIMaximizeButton);
      return SWIG_TypeQuery("FXMDIMaximizeButton *");
      }
    FXMDIMinimizeButton *pMDIMinimizeButton=dynamic_cast<FXMDIMinimizeButton*>(*ppButton);
    if(pMDIMinimizeButton){
      *ptr=reinterpret_cast<void*>(pMDIMinimizeButton);
      return SWIG_TypeQuery("FXMDIMinimizeButton *");
      }
    FXMDIRestoreButton *pMDIRestoreButton=dynamic_cast<FXMDIRestoreButton*>(*ppButton);
    if(pMDIRestoreButton){
      *ptr=reinterpret_cast<void*>(pMDIRestoreButton);
      return SWIG_TypeQuery("FXMDIRestoreButton *");
      }
    FXPicker *pPicker=dynamic_cast<FXPicker*>(*ppButton);
    if(pPicker){
      *ptr=reinterpret_cast<void*>(pPicker);
      return SWIG_TypeQuery("FXPicker *");
      }
    return 0;
}

FXCheckButton *new_FXCheckButton(FXComposite *p,FXString const &text,FXObject *tgt,FXSelector sel,FXuint opts,FXint x,FXint y,FXint w,FXint h,FXint pl,FXint pr,FXint pt,FXint pb){
      return new FXRbCheckButton(p,text,tgt,sel,opts,x,y,w,h,pl,pr,pt,pb);
      }
FXbool FXCheckButton_getCheck(FXCheckButton const *self){
      rb_warning("FXCheckButton#getCheck is deprecated; use checked?, unchecked? or maybe?");
      return self->getCheck();
      }
FXuchar FXCheckButton_getCheckState(FXCheckButton const *self){ return self->getCheck(); }

swig_class cFXCheckButton;
static void free_FXCheckButton(FXCheckButton *);
FXMenuButton *new_FXMenuButton(FXComposite *p,FXString const &text,FXIcon *ic,FXPopup *pup,FXuint opts,FXint x,FXint y,FXint w,FXint h,FXint pl,FXint pr,FXint pt,FXint pb){
      return new FXRbMenuButton(p,text,ic,pup,opts,x,y,w,h,pl,pr,pt,pb);
      }

swig_class cFXMenuButton;
static void free_FXMenuButton(FXMenuButton *);

static swig_type_info *FXMenuButton_dynamic_cast(void **ptr) {
    FXMenuButton **ppMenuButton = reinterpret_cast<FXMenuButton **>(ptr);
    FXMDIWindowButton *pMDIWindowButton=dynamic_cast<FXMDIWindowButton*>(*ppMenuButton);
    if(pMDIWindowButton){
      *ptr=reinterpret_cast<void*>(pMDIWindowButton);
      return SWIG_TypeQuery("FXMDIWindowButton *");
      }
    return 0;
}

FXOption *new_FXOption(FXComposite *p,FXString const &text,FXIcon *ic,FXObject *tgt,FXSelector sel,FXuint opts,FXint x,FXint y,FXint w,FXint h,FXint pl,FXint pr,FXint pt,FXint pb){
      return new FXRbOption(p,text,ic,tgt,sel,opts,x,y,w,h,pl,pr,pt,pb);
      }

swig_class cFXOption;
static void free_FXOption(FXOption *);
FXOptionMenu *new_FXOptionMenu(FXComposite *p,FXPopup *pup,FXuint opts,FXint x,FXint y,FXint w,FXint h,FXint pl,FXint pr,FXint pt,FXint pb){
      return new FXRbOptionMenu(p,pup,opts,x,y,w,h,pl,pr,pt,pb);
      }

swig_class cFXOptionMenu;
static void free_FXOptionMenu(FXOptionMenu *);
FXRadioButton *new_FXRadioButton(FXComposite *p,FXString const &text,FXObject *tgt,FXSelector sel,FXuint opts,FXint x,FXint y,FXint w,FXint h,FXint pl,FXint pr,FXint pt,FXint pb){
      return new FXRbRadioButton(p,text,tgt,sel,opts,x,y,w,h,pl,pr,pt,pb);
      }
FXbool FXRadioButton_getCheck(FXRadioButton const *self){
      rb_warning("FXRadioButton#getCheck is deprecated; use checked?, unchecked? or maybe?");
      return self->getCheck();
      }
FXuchar FXRadioButton_getCheckState(FXRadioButton const *self){ return self->getCheck(); }

swig_class cFXRadioButton;
static void free_FXRadioButton(FXRadioButton *);
FXTabItem *new_FXTabItem(FXTabBar *p,FXString const &text,FXIcon *ic,FXuint opts,FXint x,FXint y,FXint w,FXint h,FXint pl,FXint pr,FXint pt,FXint pb){
      return new FXRbTabItem(p,text,ic,opts,x,y,w,h,pl,pr,pt,pb);
      }

swig_class cFXTabItem;
static void free_FXTabItem(FXTabItem *);
FXToggleButton *new_FXToggleButton(FXComposite *p,FXString const &text1,FXString const &text2,FXIcon *icon1,FXIcon *icon2,FXObject *tgt,FXSelector sel,FXuint opts,FXint x,FXint y,FXint w,FXint h,FXint pl,FXint pr,FXint pt,FXint pb){
      return new FXRbToggleButton(p,text1,text2,icon1,icon2,tgt,sel,opts,x,y,w,h,pl,pr,pt,pb);
      }

swig_class cFXToggleButton;
static void free_FXToggleButton(FXToggleButton *);

static swig_type_info *FXToggleButton_dynamic_cast(void **ptr) {
    FXToggleButton **ppToggleButton = reinterpret_cast<FXToggleButton **>(ptr);
    FXTriStateButton *pTriStateButton=dynamic_cast<FXTriStateButton*>(*ppToggleButton);
    if(pTriStateButton){
      *ptr=reinterpret_cast<void*>(pTriStateButton);
      return SWIG_TypeQuery("FXTriStateButton *");
      }
    return 0;
}

FXTriStateButton *new_FXTriStateButton(FXComposite *p,FXString const &text1,FXString const &text2,FXString const &text3,FXIcon *icon1,FXIcon *icon2,FXIcon *icon3,FXObject *tgt,FXSelector sel,FXuint opts,FXint x,FXint y,FXint w,FXint h,FXint pl,FXint pr,FXint pt,FXint pb){
      return new FXRbTriStateButton(p,text1,text2,text3,icon1,icon2,icon3,tgt,sel,opts,x,y,w,h,pl,pr,pt,pb);
    }

swig_class cFXTriStateButton;
static void free_FXTriStateButton(FXTriStateButton *);
FXPicker *new_FXPicker(FXComposite *p,FXString const &text,FXIcon *ic,FXObject *tgt,FXSelector sel,FXuint opts,FXint x,FXint y,FXint w,FXint h,FXint pl,FXint pr,FXint pt,FXint pb){
      return new FXRbPicker(p,text,ic,tgt,sel,opts,x,y,w,h,pl,pr,pt,pb);
      }

swig_class cFXPicker;
static void free_FXPicker(FXPicker *);
static VALUE _wrap_FXLabel_onPaint(int argc, VALUE *argv, VALUE self) { FXLabel *arg1 = (FXLabel *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXLabel, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onPaint(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXLabel_onHotKeyPress(int argc, VALUE *argv, VALUE self) { FXLabel *arg1 = (FXLabel *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXLabel, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onHotKeyPress(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXLabel_onHotKeyRelease(int argc, VALUE *argv, VALUE self) { FXLabel *arg1 = (FXLabel *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXLabel, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onHotKeyRelease(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXLabel_onCmdSetValue(int argc, VALUE *argv, VALUE self) { FXLabel *arg1 = (FXLabel *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXLabel, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdSetValue(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXLabel_onCmdSetStringValue(int argc, VALUE *argv, VALUE self) { FXLabel *arg1 = (FXLabel *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; FXString value4 ;
    VALUE vresult = Qnil; if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXLabel, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); {
        value4 = FXString(STR2CSTR(argv[2])); arg4 = (void *) &value4; } 
    result = (long)(arg1)->onCmdSetStringValue(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXLabel_onCmdGetStringValue(int argc, VALUE *argv, VALUE self) { FXLabel *arg1 = (FXLabel *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXLabel, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdGetStringValue(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXLabel_onCmdSetIconValue(int argc, VALUE *argv, VALUE self) { FXLabel *arg1 = (FXLabel *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; void *tmp4 ;
    VALUE vresult = Qnil; if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXLabel, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); {
        tmp4 = FXRbConvertPtr(argv[2], FXRbTypeQuery("FXIcon *")); arg4 = (void *) &tmp4; } 
    result = (long)(arg1)->onCmdSetIconValue(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXLabel_onCmdGetIconValue(int argc, VALUE *argv, VALUE self) { FXLabel *arg1 = (FXLabel *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXLabel, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdGetIconValue(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXLabel_onCmdSetHelp(int argc, VALUE *argv, VALUE self) { FXLabel *arg1 = (FXLabel *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; FXString value4 ;
    VALUE vresult = Qnil; if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXLabel, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); {
        value4 = FXString(STR2CSTR(argv[2])); arg4 = (void *) &value4; }  result = (long)(arg1)->onCmdSetHelp(arg2,arg3,arg4);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXLabel_onCmdGetHelp(int argc, VALUE *argv, VALUE self) { FXLabel *arg1 = (FXLabel *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXLabel, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdGetHelp(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXLabel_onCmdSetTip(int argc, VALUE *argv, VALUE self) { FXLabel *arg1 = (FXLabel *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; FXString value4 ;
    VALUE vresult = Qnil; if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXLabel, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); {
        value4 = FXString(STR2CSTR(argv[2])); arg4 = (void *) &value4; }  result = (long)(arg1)->onCmdSetTip(arg2,arg3,arg4);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXLabel_onCmdGetTip(int argc, VALUE *argv, VALUE self) { FXLabel *arg1 = (FXLabel *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXLabel, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdGetTip(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXLabel_onQueryHelp(int argc, VALUE *argv, VALUE self) { FXLabel *arg1 = (FXLabel *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXLabel, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onQueryHelp(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXLabel_onQueryTip(int argc, VALUE *argv, VALUE self) { FXLabel *arg1 = (FXLabel *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXLabel, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onQueryTip(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE _wrap_FXLabel_allocate(VALUE self) {
#else
     static VALUE _wrap_FXLabel_allocate(int argc, VALUE *argv, VALUE self) {
#endif
         VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_FXLabel);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
         return vresult; }
static VALUE _wrap_new_FXLabel(int argc, VALUE *argv, VALUE self) { FXComposite *arg1 = (FXComposite *) 0 ; FXString *arg2 = 0 ;
    FXIcon *arg3 = (FXIcon *) 0 ; FXuint arg4 = (FXuint) LABEL_NORMAL ; FXint arg5 = (FXint) 0 ; FXint arg6 = (FXint) 0 ;
    FXint arg7 = (FXint) 0 ; FXint arg8 = (FXint) 0 ; FXint arg9 = (FXint) DEFAULT_PAD ; FXint arg10 = (FXint) DEFAULT_PAD ;
    FXint arg11 = (FXint) DEFAULT_PAD ; FXint arg12 = (FXint) DEFAULT_PAD ; FXLabel *result; SwigValueWrapper<FXString > p2 ;
    if ((argc < 2) || (argc > 12)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXComposite, 1); p2 = to_FXString(argv[1]); arg2 = &p2; if (argc > 2) {
        SWIG_ConvertPtr(argv[2], (void **) &arg3, SWIGTYPE_p_FXIcon, 1); }  if (argc > 3) { arg4 = NUM2UINT(argv[3]); } 
    if (argc > 4) { arg5 = NUM2INT(argv[4]); }  if (argc > 5) { arg6 = NUM2INT(argv[5]); }  if (argc > 6) {
        arg7 = NUM2INT(argv[6]); }  if (argc > 7) { arg8 = NUM2INT(argv[7]); }  if (argc > 8) { arg9 = NUM2INT(argv[8]); } 
    if (argc > 9) { arg10 = NUM2INT(argv[9]); }  if (argc > 10) { arg11 = NUM2INT(argv[10]); }  if (argc > 11) {
        arg12 = NUM2INT(argv[11]); }  {
        result = (FXLabel *)new_FXLabel(arg1,(FXString const &)*arg2,arg3,arg4,arg5,arg6,arg7,arg8,arg9,arg10,arg11,arg12);
        DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result); if(rb_block_given_p()){ rb_yield(self); }  }  return self; }
static VALUE _wrap_FXLabel_setText(int argc, VALUE *argv, VALUE self) { FXLabel *arg1 = (FXLabel *) 0 ; FXString *arg2 = 0 ;
    SwigValueWrapper<FXString > p2 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXLabel, 1); p2 = to_FXString(argv[0]); arg2 = &p2;
    (arg1)->setText((FXString const &)*arg2); return Qnil; }
static VALUE _wrap_FXLabel_getText(int argc, VALUE *argv, VALUE self) { FXLabel *arg1 = (FXLabel *) 0 ; FXString result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXLabel, 1); result = ((FXLabel const *)arg1)->getText();
    vresult = rb_str_new2((&result)->text()); return vresult; }
static VALUE _wrap_FXLabel_setIcon(int argc, VALUE *argv, VALUE self) { FXLabel *arg1 = (FXLabel *) 0 ;
    FXIcon *arg2 = (FXIcon *) 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXLabel, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXIcon, 1); (arg1)->setIcon(arg2); return Qnil; }
static VALUE _wrap_FXLabel_getIcon(int argc, VALUE *argv, VALUE self) { FXLabel *arg1 = (FXLabel *) 0 ; FXIcon *result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXLabel, 1); result = (FXIcon *)((FXLabel const *)arg1)->getIcon(); {
        swig_type_info *ty = SWIG_TypeDynamicCast(SWIGTYPE_p_FXIcon, (void **) &result); vresult = FXRbGetRubyObj(result, ty); }
     return vresult; }
static VALUE _wrap_FXLabel_setFont(int argc, VALUE *argv, VALUE self) { FXLabel *arg1 = (FXLabel *) 0 ;
    FXFont *arg2 = (FXFont *) 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXLabel, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXFont, 1); (arg1)->setFont(arg2); return Qnil; }
static VALUE _wrap_FXLabel_getFont(int argc, VALUE *argv, VALUE self) { FXLabel *arg1 = (FXLabel *) 0 ; FXFont *result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXLabel, 1); result = (FXFont *)((FXLabel const *)arg1)->getFont(); {
        swig_type_info *ty = SWIG_TypeDynamicCast(SWIGTYPE_p_FXFont, (void **) &result); vresult = FXRbGetRubyObj(result, ty); }
     return vresult; }
static VALUE _wrap_FXLabel_getTextColor(int argc, VALUE *argv, VALUE self) { FXLabel *arg1 = (FXLabel *) 0 ; FXColor result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXLabel, 1); result = (FXColor)((FXLabel const *)arg1)->getTextColor();
    vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXLabel_setTextColor(int argc, VALUE *argv, VALUE self) { FXLabel *arg1 = (FXLabel *) 0 ; FXColor arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXLabel, 1); arg2 = to_FXColor(argv[0]); (arg1)->setTextColor(arg2);
    return Qnil; }
static VALUE _wrap_FXLabel_setJustify(int argc, VALUE *argv, VALUE self) { FXLabel *arg1 = (FXLabel *) 0 ; FXuint arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXLabel, 1); arg2 = NUM2UINT(argv[0]); (arg1)->setJustify(arg2);
    return Qnil; }
static VALUE _wrap_FXLabel_getJustify(int argc, VALUE *argv, VALUE self) { FXLabel *arg1 = (FXLabel *) 0 ; FXuint result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXLabel, 1); result = (FXuint)((FXLabel const *)arg1)->getJustify();
    vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXLabel_setIconPosition(int argc, VALUE *argv, VALUE self) { FXLabel *arg1 = (FXLabel *) 0 ; FXuint arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXLabel, 1); arg2 = NUM2UINT(argv[0]); (arg1)->setIconPosition(arg2);
    return Qnil; }
static VALUE _wrap_FXLabel_getIconPosition(int argc, VALUE *argv, VALUE self) { FXLabel *arg1 = (FXLabel *) 0 ; FXuint result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXLabel, 1); result = (FXuint)((FXLabel const *)arg1)->getIconPosition();
    vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXLabel_setHelpText(int argc, VALUE *argv, VALUE self) { FXLabel *arg1 = (FXLabel *) 0 ; FXString *arg2 = 0 ;
    SwigValueWrapper<FXString > p2 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXLabel, 1); p2 = to_FXString(argv[0]); arg2 = &p2;
    (arg1)->setHelpText((FXString const &)*arg2); return Qnil; }
static VALUE _wrap_FXLabel_getHelpText(int argc, VALUE *argv, VALUE self) { FXLabel *arg1 = (FXLabel *) 0 ; FXString result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXLabel, 1); result = ((FXLabel const *)arg1)->getHelpText();
    vresult = rb_str_new2((&result)->text()); return vresult; }
static VALUE _wrap_FXLabel_setTipText(int argc, VALUE *argv, VALUE self) { FXLabel *arg1 = (FXLabel *) 0 ; FXString *arg2 = 0 ;
    SwigValueWrapper<FXString > p2 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXLabel, 1); p2 = to_FXString(argv[0]); arg2 = &p2;
    (arg1)->setTipText((FXString const &)*arg2); return Qnil; }
static VALUE _wrap_FXLabel_getTipText(int argc, VALUE *argv, VALUE self) { FXLabel *arg1 = (FXLabel *) 0 ; FXString result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXLabel, 1); result = ((FXLabel const *)arg1)->getTipText();
    vresult = rb_str_new2((&result)->text()); return vresult; }
static void
free_FXLabel(FXLabel *arg1) {
    delete arg1;
}
static VALUE _wrap_FXLabel_save(int argc, VALUE *argv, VALUE self) { FXLabel *arg1 = (FXLabel *) 0 ; FXStream *arg2 = 0 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXLabel, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXLabel_save((FXLabel const *)arg1,*arg2); return Qnil; }
static VALUE _wrap_FXLabel_load(int argc, VALUE *argv, VALUE self) { FXLabel *arg1 = (FXLabel *) 0 ; FXStream *arg2 = 0 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXLabel, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXLabel_load(arg1,*arg2); return Qnil; }
static VALUE _wrap_FXLabel_create(int argc, VALUE *argv, VALUE self) { FXLabel *arg1 = (FXLabel *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXLabel, 1); FXLabel_create(arg1); return Qnil; }
static VALUE _wrap_FXLabel_detach(int argc, VALUE *argv, VALUE self) { FXLabel *arg1 = (FXLabel *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXLabel, 1); FXLabel_detach(arg1); return Qnil; }
static VALUE _wrap_FXLabel_destroy(int argc, VALUE *argv, VALUE self) { FXLabel *arg1 = (FXLabel *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXLabel, 1); FXLabel_destroy(arg1); return Qnil; }
static VALUE _wrap_FXLabel_resize(int argc, VALUE *argv, VALUE self) { FXLabel *arg1 = (FXLabel *) 0 ; FXint arg2 ; FXint arg3 ;
    if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXLabel, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    FXLabel_resize(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXLabel_getDefaultWidth(int argc, VALUE *argv, VALUE self) { FXLabel *arg1 = (FXLabel *) 0 ; FXint result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXLabel, 1); result = (FXint)FXLabel_getDefaultWidth(arg1);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXLabel_getDefaultHeight(int argc, VALUE *argv, VALUE self) { FXLabel *arg1 = (FXLabel *) 0 ; FXint result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXLabel, 1); result = (FXint)FXLabel_getDefaultHeight(arg1);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXLabel_getWidthForHeight(int argc, VALUE *argv, VALUE self) { FXLabel *arg1 = (FXLabel *) 0 ; FXint arg2 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXLabel, 1); arg2 = NUM2INT(argv[0]);
    result = (FXint)FXLabel_getWidthForHeight(arg1,arg2); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXLabel_getHeightForWidth(int argc, VALUE *argv, VALUE self) { FXLabel *arg1 = (FXLabel *) 0 ; FXint arg2 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXLabel, 1); arg2 = NUM2INT(argv[0]);
    result = (FXint)FXLabel_getHeightForWidth(arg1,arg2); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXLabel_canFocus(int argc, VALUE *argv, VALUE self) { FXLabel *arg1 = (FXLabel *) 0 ; FXbool result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXLabel, 1); result = (FXbool)FXLabel_canFocus((FXLabel const *)arg1);
    vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXLabel_setFocus(int argc, VALUE *argv, VALUE self) { FXLabel *arg1 = (FXLabel *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXLabel, 1); FXLabel_setFocus(arg1); return Qnil; }
static VALUE _wrap_FXLabel_killFocus(int argc, VALUE *argv, VALUE self) { FXLabel *arg1 = (FXLabel *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXLabel, 1); FXLabel_killFocus(arg1); return Qnil; }
static VALUE _wrap_FXLabel_setDefault(int argc, VALUE *argv, VALUE self) { FXLabel *arg1 = (FXLabel *) 0 ;
    FXbool arg2 = (FXbool) 1 ; if ((argc < 0) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXLabel, 1); if (argc > 0) { arg2 = to_FXbool(argv[0]); } 
    FXLabel_setDefault(arg1,arg2); return Qnil; }
static VALUE _wrap_FXLabel_enable(int argc, VALUE *argv, VALUE self) { FXLabel *arg1 = (FXLabel *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXLabel, 1); FXLabel_enable(arg1); return Qnil; }
static VALUE _wrap_FXLabel_disable(int argc, VALUE *argv, VALUE self) { FXLabel *arg1 = (FXLabel *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXLabel, 1); FXLabel_disable(arg1); return Qnil; }
static VALUE _wrap_FXLabel_raiseWindow(int argc, VALUE *argv, VALUE self) { FXLabel *arg1 = (FXLabel *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXLabel, 1); FXLabel_raise(arg1); return Qnil; }
static VALUE _wrap_FXLabel_lower(int argc, VALUE *argv, VALUE self) { FXLabel *arg1 = (FXLabel *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXLabel, 1); FXLabel_lower(arg1); return Qnil; }
static VALUE _wrap_FXLabel_move(int argc, VALUE *argv, VALUE self) { FXLabel *arg1 = (FXLabel *) 0 ; FXint arg2 ; FXint arg3 ;
    if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXLabel, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    FXLabel_move(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXLabel_position(int argc, VALUE *argv, VALUE self) { FXLabel *arg1 = (FXLabel *) 0 ; FXint arg2 ;
    FXint arg3 ; FXint arg4 ; FXint arg5 ; if ((argc < 4) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXLabel, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    arg4 = NUM2INT(argv[2]); arg5 = NUM2INT(argv[3]); FXLabel_position(arg1,arg2,arg3,arg4,arg5); return Qnil; }
static VALUE _wrap_FXLabel_layout(int argc, VALUE *argv, VALUE self) { FXLabel *arg1 = (FXLabel *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXLabel, 1); FXLabel_layout(arg1); return Qnil; }
static VALUE _wrap_FXLabel_recalc(int argc, VALUE *argv, VALUE self) { FXLabel *arg1 = (FXLabel *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXLabel, 1); FXLabel_recalc(arg1); return Qnil; }
static VALUE _wrap_FXLabel_reparent(int argc, VALUE *argv, VALUE self) { FXLabel *arg1 = (FXLabel *) 0 ;
    FXComposite *arg2 = (FXComposite *) 0 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXLabel, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXComposite, 1); FXLabel_reparent(arg1,arg2); return Qnil; }
static VALUE _wrap_FXLabel_show(int argc, VALUE *argv, VALUE self) { FXLabel *arg1 = (FXLabel *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXLabel, 1); FXLabel_show(arg1); return Qnil; }
static VALUE _wrap_FXLabel_hide(int argc, VALUE *argv, VALUE self) { FXLabel *arg1 = (FXLabel *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXLabel, 1); FXLabel_hide(arg1); return Qnil; }
static VALUE _wrap_FXLabel_isComposite(int argc, VALUE *argv, VALUE self) { FXLabel *arg1 = (FXLabel *) 0 ; FXbool result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXLabel, 1); result = (FXbool)FXLabel_isComposite((FXLabel const *)arg1);
    vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXLabel_contains(int argc, VALUE *argv, VALUE self) { FXLabel *arg1 = (FXLabel *) 0 ; FXint arg2 ;
    FXint arg3 ; FXbool result; VALUE vresult = Qnil; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXLabel, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    result = (FXbool)FXLabel_contains((FXLabel const *)arg1,arg2,arg3); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXLabel_doesSaveUnder(int argc, VALUE *argv, VALUE self) { FXLabel *arg1 = (FXLabel *) 0 ; FXbool result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXLabel, 1);
    result = (FXbool)FXLabel_doesSaveUnder((FXLabel const *)arg1); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXLabel_setBackColor(int argc, VALUE *argv, VALUE self) { FXLabel *arg1 = (FXLabel *) 0 ; FXColor arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXLabel, 1); arg2 = to_FXColor(argv[0]); FXLabel_setBackColor(arg1,arg2);
    return Qnil; }
static VALUE _wrap_FXButton_onPaint(int argc, VALUE *argv, VALUE self) { FXButton *arg1 = (FXButton *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXButton, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onPaint(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXButton_onUpdate(int argc, VALUE *argv, VALUE self) { FXButton *arg1 = (FXButton *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXButton, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onUpdate(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXButton_onEnter(int argc, VALUE *argv, VALUE self) { FXButton *arg1 = (FXButton *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXButton, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onEnter(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXButton_onLeave(int argc, VALUE *argv, VALUE self) { FXButton *arg1 = (FXButton *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXButton, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onLeave(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXButton_onFocusIn(int argc, VALUE *argv, VALUE self) { FXButton *arg1 = (FXButton *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXButton, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onFocusIn(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXButton_onFocusOut(int argc, VALUE *argv, VALUE self) { FXButton *arg1 = (FXButton *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXButton, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onFocusOut(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXButton_onUngrabbed(int argc, VALUE *argv, VALUE self) { FXButton *arg1 = (FXButton *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXButton, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onUngrabbed(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXButton_onLeftBtnPress(int argc, VALUE *argv, VALUE self) { FXButton *arg1 = (FXButton *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXButton, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onLeftBtnPress(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXButton_onLeftBtnRelease(int argc, VALUE *argv, VALUE self) { FXButton *arg1 = (FXButton *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXButton, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onLeftBtnRelease(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXButton_onKeyPress(int argc, VALUE *argv, VALUE self) { FXButton *arg1 = (FXButton *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXButton, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onKeyPress(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXButton_onKeyRelease(int argc, VALUE *argv, VALUE self) { FXButton *arg1 = (FXButton *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXButton, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onKeyRelease(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXButton_onHotKeyPress(int argc, VALUE *argv, VALUE self) { FXButton *arg1 = (FXButton *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXButton, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onHotKeyPress(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXButton_onHotKeyRelease(int argc, VALUE *argv, VALUE self) { FXButton *arg1 = (FXButton *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXButton, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onHotKeyRelease(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXButton_onCheck(int argc, VALUE *argv, VALUE self) { FXButton *arg1 = (FXButton *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXButton, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCheck(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXButton_onUncheck(int argc, VALUE *argv, VALUE self) { FXButton *arg1 = (FXButton *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXButton, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onUncheck(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXButton_onCmdSetValue(int argc, VALUE *argv, VALUE self) { FXButton *arg1 = (FXButton *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXButton, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]);
    arg4 = reinterpret_cast<void*>(NUM2INT(argv[2])); result = (long)(arg1)->onCmdSetValue(arg2,arg3,arg4);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXButton_onCmdSetIntValue(int argc, VALUE *argv, VALUE self) { FXButton *arg1 = (FXButton *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; FXint value4 ;
    VALUE vresult = Qnil; if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXButton, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); {
        value4 = (FXint) NUM2INT(argv[2]); arg4 = static_cast<void*>(&value4); } 
    result = (long)(arg1)->onCmdSetIntValue(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXButton_onCmdGetIntValue(int argc, VALUE *argv, VALUE self) { FXButton *arg1 = (FXButton *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXButton, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdGetIntValue(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE _wrap_FXButton_allocate(VALUE self) {
#else
     static VALUE _wrap_FXButton_allocate(int argc, VALUE *argv, VALUE self) {
#endif
         VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_FXButton);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
         return vresult; }
static VALUE _wrap_new_FXButton(int argc, VALUE *argv, VALUE self) { FXComposite *arg1 = (FXComposite *) 0 ;
    FXString *arg2 = 0 ; FXIcon *arg3 = (FXIcon *) 0 ; FXObject *arg4 = (FXObject *) 0 ; FXSelector arg5 = (FXSelector) 0 ;
    FXuint arg6 = (FXuint) BUTTON_NORMAL ; FXint arg7 = (FXint) 0 ; FXint arg8 = (FXint) 0 ; FXint arg9 = (FXint) 0 ;
    FXint arg10 = (FXint) 0 ; FXint arg11 = (FXint) DEFAULT_PAD ; FXint arg12 = (FXint) DEFAULT_PAD ;
    FXint arg13 = (FXint) DEFAULT_PAD ; FXint arg14 = (FXint) DEFAULT_PAD ; FXButton *result; SwigValueWrapper<FXString > p2 ;
    if ((argc < 2) || (argc > 14)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXComposite, 1); p2 = to_FXString(argv[1]); arg2 = &p2; if (argc > 2) {
        SWIG_ConvertPtr(argv[2], (void **) &arg3, SWIGTYPE_p_FXIcon, 1); }  if (argc > 3) {
        SWIG_ConvertPtr(argv[3], (void **) &arg4, SWIGTYPE_p_FXObject, 1); }  if (argc > 4) { arg5 = NUM2UINT(argv[4]); } 
    if (argc > 5) { arg6 = NUM2UINT(argv[5]); }  if (argc > 6) { arg7 = NUM2INT(argv[6]); }  if (argc > 7) {
        arg8 = NUM2INT(argv[7]); }  if (argc > 8) { arg9 = NUM2INT(argv[8]); }  if (argc > 9) { arg10 = NUM2INT(argv[9]); } 
    if (argc > 10) { arg11 = NUM2INT(argv[10]); }  if (argc > 11) { arg12 = NUM2INT(argv[11]); }  if (argc > 12) {
        arg13 = NUM2INT(argv[12]); }  if (argc > 13) { arg14 = NUM2INT(argv[13]); }  {
        result = (FXButton *)new_FXButton(arg1,(FXString const &)*arg2,arg3,arg4,arg5,arg6,arg7,arg8,arg9,arg10,arg11,arg12,arg13,arg14);
        DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result); if(rb_block_given_p()){ rb_yield(self); }  }  return self; }
static VALUE _wrap_FXButton_setState(int argc, VALUE *argv, VALUE self) { FXButton *arg1 = (FXButton *) 0 ; FXuint arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXButton, 1); arg2 = NUM2UINT(argv[0]); (arg1)->setState(arg2);
    return Qnil; }
static VALUE _wrap_FXButton_getState(int argc, VALUE *argv, VALUE self) { FXButton *arg1 = (FXButton *) 0 ; FXuint result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXButton, 1); result = (FXuint)((FXButton const *)arg1)->getState();
    vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXButton_setButtonStyle(int argc, VALUE *argv, VALUE self) { FXButton *arg1 = (FXButton *) 0 ; FXuint arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXButton, 1); arg2 = NUM2UINT(argv[0]); (arg1)->setButtonStyle(arg2);
    return Qnil; }
static VALUE _wrap_FXButton_getButtonStyle(int argc, VALUE *argv, VALUE self) { FXButton *arg1 = (FXButton *) 0 ; FXuint result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXButton, 1); result = (FXuint)((FXButton const *)arg1)->getButtonStyle();
    vresult = UINT2NUM(result); return vresult; }
static void
free_FXButton(FXButton *arg1) {
    delete arg1;
}
static VALUE _wrap_FXButton_save(int argc, VALUE *argv, VALUE self) { FXButton *arg1 = (FXButton *) 0 ; FXStream *arg2 = 0 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXButton, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXButton_save((FXButton const *)arg1,*arg2); return Qnil; }
static VALUE _wrap_FXButton_load(int argc, VALUE *argv, VALUE self) { FXButton *arg1 = (FXButton *) 0 ; FXStream *arg2 = 0 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXButton, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXButton_load(arg1,*arg2); return Qnil; }
static VALUE _wrap_FXButton_create(int argc, VALUE *argv, VALUE self) { FXButton *arg1 = (FXButton *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXButton, 1); FXButton_create(arg1); return Qnil; }
static VALUE _wrap_FXButton_detach(int argc, VALUE *argv, VALUE self) { FXButton *arg1 = (FXButton *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXButton, 1); FXButton_detach(arg1); return Qnil; }
static VALUE _wrap_FXButton_destroy(int argc, VALUE *argv, VALUE self) { FXButton *arg1 = (FXButton *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXButton, 1); FXButton_destroy(arg1); return Qnil; }
static VALUE _wrap_FXButton_resize(int argc, VALUE *argv, VALUE self) { FXButton *arg1 = (FXButton *) 0 ; FXint arg2 ;
    FXint arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXButton, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    FXButton_resize(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXButton_getDefaultWidth(int argc, VALUE *argv, VALUE self) { FXButton *arg1 = (FXButton *) 0 ; FXint result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXButton, 1); result = (FXint)FXButton_getDefaultWidth(arg1);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXButton_getDefaultHeight(int argc, VALUE *argv, VALUE self) { FXButton *arg1 = (FXButton *) 0 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXButton, 1); result = (FXint)FXButton_getDefaultHeight(arg1);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXButton_getWidthForHeight(int argc, VALUE *argv, VALUE self) { FXButton *arg1 = (FXButton *) 0 ;
    FXint arg2 ; FXint result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXButton, 1); arg2 = NUM2INT(argv[0]);
    result = (FXint)FXButton_getWidthForHeight(arg1,arg2); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXButton_getHeightForWidth(int argc, VALUE *argv, VALUE self) { FXButton *arg1 = (FXButton *) 0 ;
    FXint arg2 ; FXint result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXButton, 1); arg2 = NUM2INT(argv[0]);
    result = (FXint)FXButton_getHeightForWidth(arg1,arg2); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXButton_canFocus(int argc, VALUE *argv, VALUE self) { FXButton *arg1 = (FXButton *) 0 ; FXbool result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXButton, 1); result = (FXbool)FXButton_canFocus((FXButton const *)arg1);
    vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXButton_setFocus(int argc, VALUE *argv, VALUE self) { FXButton *arg1 = (FXButton *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXButton, 1); FXButton_setFocus(arg1); return Qnil; }
static VALUE _wrap_FXButton_killFocus(int argc, VALUE *argv, VALUE self) { FXButton *arg1 = (FXButton *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXButton, 1); FXButton_killFocus(arg1); return Qnil; }
static VALUE _wrap_FXButton_setDefault(int argc, VALUE *argv, VALUE self) { FXButton *arg1 = (FXButton *) 0 ;
    FXbool arg2 = (FXbool) 1 ; if ((argc < 0) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXButton, 1); if (argc > 0) { arg2 = to_FXbool(argv[0]); } 
    FXButton_setDefault(arg1,arg2); return Qnil; }
static VALUE _wrap_FXButton_enable(int argc, VALUE *argv, VALUE self) { FXButton *arg1 = (FXButton *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXButton, 1); FXButton_enable(arg1); return Qnil; }
static VALUE _wrap_FXButton_disable(int argc, VALUE *argv, VALUE self) { FXButton *arg1 = (FXButton *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXButton, 1); FXButton_disable(arg1); return Qnil; }
static VALUE _wrap_FXButton_raiseWindow(int argc, VALUE *argv, VALUE self) { FXButton *arg1 = (FXButton *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXButton, 1); FXButton_raise(arg1); return Qnil; }
static VALUE _wrap_FXButton_lower(int argc, VALUE *argv, VALUE self) { FXButton *arg1 = (FXButton *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXButton, 1); FXButton_lower(arg1); return Qnil; }
static VALUE _wrap_FXButton_move(int argc, VALUE *argv, VALUE self) { FXButton *arg1 = (FXButton *) 0 ; FXint arg2 ;
    FXint arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXButton, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    FXButton_move(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXButton_position(int argc, VALUE *argv, VALUE self) { FXButton *arg1 = (FXButton *) 0 ; FXint arg2 ;
    FXint arg3 ; FXint arg4 ; FXint arg5 ; if ((argc < 4) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXButton, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    arg4 = NUM2INT(argv[2]); arg5 = NUM2INT(argv[3]); FXButton_position(arg1,arg2,arg3,arg4,arg5); return Qnil; }
static VALUE _wrap_FXButton_layout(int argc, VALUE *argv, VALUE self) { FXButton *arg1 = (FXButton *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXButton, 1); FXButton_layout(arg1); return Qnil; }
static VALUE _wrap_FXButton_recalc(int argc, VALUE *argv, VALUE self) { FXButton *arg1 = (FXButton *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXButton, 1); FXButton_recalc(arg1); return Qnil; }
static VALUE _wrap_FXButton_reparent(int argc, VALUE *argv, VALUE self) { FXButton *arg1 = (FXButton *) 0 ;
    FXComposite *arg2 = (FXComposite *) 0 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXButton, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXComposite, 1); FXButton_reparent(arg1,arg2); return Qnil; }
static VALUE _wrap_FXButton_show(int argc, VALUE *argv, VALUE self) { FXButton *arg1 = (FXButton *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXButton, 1); FXButton_show(arg1); return Qnil; }
static VALUE _wrap_FXButton_hide(int argc, VALUE *argv, VALUE self) { FXButton *arg1 = (FXButton *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXButton, 1); FXButton_hide(arg1); return Qnil; }
static VALUE _wrap_FXButton_isComposite(int argc, VALUE *argv, VALUE self) { FXButton *arg1 = (FXButton *) 0 ; FXbool result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXButton, 1);
    result = (FXbool)FXButton_isComposite((FXButton const *)arg1); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXButton_contains(int argc, VALUE *argv, VALUE self) { FXButton *arg1 = (FXButton *) 0 ; FXint arg2 ;
    FXint arg3 ; FXbool result; VALUE vresult = Qnil; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXButton, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    result = (FXbool)FXButton_contains((FXButton const *)arg1,arg2,arg3); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXButton_doesSaveUnder(int argc, VALUE *argv, VALUE self) { FXButton *arg1 = (FXButton *) 0 ; FXbool result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXButton, 1);
    result = (FXbool)FXButton_doesSaveUnder((FXButton const *)arg1); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXButton_setBackColor(int argc, VALUE *argv, VALUE self) { FXButton *arg1 = (FXButton *) 0 ; FXColor arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXButton, 1); arg2 = to_FXColor(argv[0]);
    FXButton_setBackColor(arg1,arg2); return Qnil; }
static VALUE _wrap_FXCheckButton_onPaint(int argc, VALUE *argv, VALUE self) { FXCheckButton *arg1 = (FXCheckButton *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXCheckButton, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onPaint(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXCheckButton_onUpdate(int argc, VALUE *argv, VALUE self) { FXCheckButton *arg1 = (FXCheckButton *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXCheckButton, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onUpdate(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXCheckButton_onEnter(int argc, VALUE *argv, VALUE self) { FXCheckButton *arg1 = (FXCheckButton *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXCheckButton, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onEnter(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXCheckButton_onLeave(int argc, VALUE *argv, VALUE self) { FXCheckButton *arg1 = (FXCheckButton *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXCheckButton, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onLeave(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXCheckButton_onFocusIn(int argc, VALUE *argv, VALUE self) { FXCheckButton *arg1 = (FXCheckButton *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXCheckButton, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onFocusIn(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXCheckButton_onFocusOut(int argc, VALUE *argv, VALUE self) { FXCheckButton *arg1 = (FXCheckButton *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXCheckButton, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onFocusOut(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXCheckButton_onUngrabbed(int argc, VALUE *argv, VALUE self) { FXCheckButton *arg1 = (FXCheckButton *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXCheckButton, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onUngrabbed(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXCheckButton_onLeftBtnPress(int argc, VALUE *argv, VALUE self) { FXCheckButton *arg1 = (FXCheckButton *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXCheckButton, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onLeftBtnPress(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXCheckButton_onLeftBtnRelease(int argc, VALUE *argv, VALUE self) {
    FXCheckButton *arg1 = (FXCheckButton *) 0 ; FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ;
    long result; VALUE vresult = Qnil; if ((argc < 3) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXCheckButton, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onLeftBtnRelease(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXCheckButton_onKeyPress(int argc, VALUE *argv, VALUE self) { FXCheckButton *arg1 = (FXCheckButton *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXCheckButton, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onKeyPress(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXCheckButton_onKeyRelease(int argc, VALUE *argv, VALUE self) { FXCheckButton *arg1 = (FXCheckButton *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXCheckButton, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onKeyRelease(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXCheckButton_onHotKeyPress(int argc, VALUE *argv, VALUE self) { FXCheckButton *arg1 = (FXCheckButton *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXCheckButton, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onHotKeyPress(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXCheckButton_onHotKeyRelease(int argc, VALUE *argv, VALUE self) {
    FXCheckButton *arg1 = (FXCheckButton *) 0 ; FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ;
    long result; VALUE vresult = Qnil; if ((argc < 3) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXCheckButton, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onHotKeyRelease(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXCheckButton_onCheck(int argc, VALUE *argv, VALUE self) { FXCheckButton *arg1 = (FXCheckButton *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXCheckButton, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCheck(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXCheckButton_onUncheck(int argc, VALUE *argv, VALUE self) { FXCheckButton *arg1 = (FXCheckButton *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXCheckButton, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onUncheck(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXCheckButton_onUnknown(int argc, VALUE *argv, VALUE self) { FXCheckButton *arg1 = (FXCheckButton *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXCheckButton, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onUnknown(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXCheckButton_onCmdSetValue(int argc, VALUE *argv, VALUE self) { FXCheckButton *arg1 = (FXCheckButton *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXCheckButton, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]);
    arg4 = reinterpret_cast<void*>(NUM2INT(argv[2])); result = (long)(arg1)->onCmdSetValue(arg2,arg3,arg4);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXCheckButton_onCmdSetIntValue(int argc, VALUE *argv, VALUE self) {
    FXCheckButton *arg1 = (FXCheckButton *) 0 ; FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ;
    long result; FXint value4 ; VALUE vresult = Qnil; if ((argc < 3) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXCheckButton, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); {
        value4 = (FXint) NUM2INT(argv[2]); arg4 = static_cast<void*>(&value4); } 
    result = (long)(arg1)->onCmdSetIntValue(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXCheckButton_onCmdGetIntValue(int argc, VALUE *argv, VALUE self) {
    FXCheckButton *arg1 = (FXCheckButton *) 0 ; FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ;
    long result; VALUE vresult = Qnil; if ((argc < 3) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXCheckButton, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdGetIntValue(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE _wrap_FXCheckButton_allocate(VALUE self) {
#else
     static VALUE _wrap_FXCheckButton_allocate(int argc, VALUE *argv, VALUE self) {
#endif
         VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_FXCheckButton);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
         return vresult; }
static VALUE _wrap_new_FXCheckButton(int argc, VALUE *argv, VALUE self) { FXComposite *arg1 = (FXComposite *) 0 ;
    FXString *arg2 = 0 ; FXObject *arg3 = (FXObject *) 0 ; FXSelector arg4 = (FXSelector) 0 ;
    FXuint arg5 = (FXuint) CHECKBUTTON_NORMAL ; FXint arg6 = (FXint) 0 ; FXint arg7 = (FXint) 0 ; FXint arg8 = (FXint) 0 ;
    FXint arg9 = (FXint) 0 ; FXint arg10 = (FXint) DEFAULT_PAD ; FXint arg11 = (FXint) DEFAULT_PAD ;
    FXint arg12 = (FXint) DEFAULT_PAD ; FXint arg13 = (FXint) DEFAULT_PAD ; FXCheckButton *result;
    SwigValueWrapper<FXString > p2 ; if ((argc < 2) || (argc > 13))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXComposite, 1); p2 = to_FXString(argv[1]); arg2 = &p2; if (argc > 2) {
        SWIG_ConvertPtr(argv[2], (void **) &arg3, SWIGTYPE_p_FXObject, 1); }  if (argc > 3) { arg4 = NUM2UINT(argv[3]); } 
    if (argc > 4) { arg5 = NUM2UINT(argv[4]); }  if (argc > 5) { arg6 = NUM2INT(argv[5]); }  if (argc > 6) {
        arg7 = NUM2INT(argv[6]); }  if (argc > 7) { arg8 = NUM2INT(argv[7]); }  if (argc > 8) { arg9 = NUM2INT(argv[8]); } 
    if (argc > 9) { arg10 = NUM2INT(argv[9]); }  if (argc > 10) { arg11 = NUM2INT(argv[10]); }  if (argc > 11) {
        arg12 = NUM2INT(argv[11]); }  if (argc > 12) { arg13 = NUM2INT(argv[12]); }  {
        result = (FXCheckButton *)new_FXCheckButton(arg1,(FXString const &)*arg2,arg3,arg4,arg5,arg6,arg7,arg8,arg9,arg10,arg11,arg12,arg13);
        DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result); if(rb_block_given_p()){ rb_yield(self); }  }  return self; }
static VALUE _wrap_FXCheckButton_setCheck(int argc, VALUE *argv, VALUE self) { FXCheckButton *arg1 = (FXCheckButton *) 0 ;
    FXbool arg2 = (FXbool) 1 ; if ((argc < 0) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXCheckButton, 1); if (argc > 0) { arg2 = to_FXbool(argv[0]); } 
    (arg1)->setCheck(arg2); return Qnil; }
static VALUE _wrap_FXCheckButton_getCheck(int argc, VALUE *argv, VALUE self) { FXCheckButton *arg1 = (FXCheckButton *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXCheckButton, 1);
    result = (FXbool)FXCheckButton_getCheck((FXCheckButton const *)arg1); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXCheckButton_getCheckState(int argc, VALUE *argv, VALUE self) { FXCheckButton *arg1 = (FXCheckButton *) 0 ;
    FXuchar result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXCheckButton, 1);
    result = (FXuchar)FXCheckButton_getCheckState((FXCheckButton const *)arg1); vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXCheckButton_setCheckButtonStyle(int argc, VALUE *argv, VALUE self) {
    FXCheckButton *arg1 = (FXCheckButton *) 0 ; FXuint arg2 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXCheckButton, 1); arg2 = NUM2UINT(argv[0]);
    (arg1)->setCheckButtonStyle(arg2); return Qnil; }
static VALUE _wrap_FXCheckButton_getCheckButtonStyle(int argc, VALUE *argv, VALUE self) {
    FXCheckButton *arg1 = (FXCheckButton *) 0 ; FXuint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXCheckButton, 1);
    result = (FXuint)((FXCheckButton const *)arg1)->getCheckButtonStyle(); vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXCheckButton_getBoxColor(int argc, VALUE *argv, VALUE self) { FXCheckButton *arg1 = (FXCheckButton *) 0 ;
    FXColor result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXCheckButton, 1);
    result = (FXColor)((FXCheckButton const *)arg1)->getBoxColor(); vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXCheckButton_setBoxColor(int argc, VALUE *argv, VALUE self) { FXCheckButton *arg1 = (FXCheckButton *) 0 ;
    FXColor arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXCheckButton, 1); arg2 = to_FXColor(argv[0]); (arg1)->setBoxColor(arg2);
    return Qnil; }
static VALUE _wrap_FXCheckButton_getCheckColor(int argc, VALUE *argv, VALUE self) { FXCheckButton *arg1 = (FXCheckButton *) 0 ;
    FXColor result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXCheckButton, 1);
    result = (FXColor)((FXCheckButton const *)arg1)->getCheckColor(); vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXCheckButton_setCheckColor(int argc, VALUE *argv, VALUE self) { FXCheckButton *arg1 = (FXCheckButton *) 0 ;
    FXColor arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXCheckButton, 1); arg2 = to_FXColor(argv[0]);
    (arg1)->setCheckColor(arg2); return Qnil; }
static void
free_FXCheckButton(FXCheckButton *arg1) {
    delete arg1;
}
static VALUE _wrap_FXCheckButton_save(int argc, VALUE *argv, VALUE self) { FXCheckButton *arg1 = (FXCheckButton *) 0 ;
    FXStream *arg2 = 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXCheckButton, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXCheckButton_save((FXCheckButton const *)arg1,*arg2); return Qnil; }
static VALUE _wrap_FXCheckButton_load(int argc, VALUE *argv, VALUE self) { FXCheckButton *arg1 = (FXCheckButton *) 0 ;
    FXStream *arg2 = 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXCheckButton, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXCheckButton_load(arg1,*arg2); return Qnil; }
static VALUE _wrap_FXCheckButton_create(int argc, VALUE *argv, VALUE self) { FXCheckButton *arg1 = (FXCheckButton *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXCheckButton, 1); FXCheckButton_create(arg1); return Qnil; }
static VALUE _wrap_FXCheckButton_detach(int argc, VALUE *argv, VALUE self) { FXCheckButton *arg1 = (FXCheckButton *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXCheckButton, 1); FXCheckButton_detach(arg1); return Qnil; }
static VALUE _wrap_FXCheckButton_destroy(int argc, VALUE *argv, VALUE self) { FXCheckButton *arg1 = (FXCheckButton *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXCheckButton, 1); FXCheckButton_destroy(arg1); return Qnil; }
static VALUE _wrap_FXCheckButton_resize(int argc, VALUE *argv, VALUE self) { FXCheckButton *arg1 = (FXCheckButton *) 0 ;
    FXint arg2 ; FXint arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXCheckButton, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    FXCheckButton_resize(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXCheckButton_getDefaultWidth(int argc, VALUE *argv, VALUE self) {
    FXCheckButton *arg1 = (FXCheckButton *) 0 ; FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXCheckButton, 1); result = (FXint)FXCheckButton_getDefaultWidth(arg1);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXCheckButton_getDefaultHeight(int argc, VALUE *argv, VALUE self) {
    FXCheckButton *arg1 = (FXCheckButton *) 0 ; FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXCheckButton, 1); result = (FXint)FXCheckButton_getDefaultHeight(arg1);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXCheckButton_getWidthForHeight(int argc, VALUE *argv, VALUE self) {
    FXCheckButton *arg1 = (FXCheckButton *) 0 ; FXint arg2 ; FXint result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXCheckButton, 1); arg2 = NUM2INT(argv[0]);
    result = (FXint)FXCheckButton_getWidthForHeight(arg1,arg2); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXCheckButton_getHeightForWidth(int argc, VALUE *argv, VALUE self) {
    FXCheckButton *arg1 = (FXCheckButton *) 0 ; FXint arg2 ; FXint result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXCheckButton, 1); arg2 = NUM2INT(argv[0]);
    result = (FXint)FXCheckButton_getHeightForWidth(arg1,arg2); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXCheckButton_canFocus(int argc, VALUE *argv, VALUE self) { FXCheckButton *arg1 = (FXCheckButton *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXCheckButton, 1);
    result = (FXbool)FXCheckButton_canFocus((FXCheckButton const *)arg1); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXCheckButton_setFocus(int argc, VALUE *argv, VALUE self) { FXCheckButton *arg1 = (FXCheckButton *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXCheckButton, 1); FXCheckButton_setFocus(arg1); return Qnil; }
static VALUE _wrap_FXCheckButton_killFocus(int argc, VALUE *argv, VALUE self) { FXCheckButton *arg1 = (FXCheckButton *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXCheckButton, 1); FXCheckButton_killFocus(arg1); return Qnil; }
static VALUE _wrap_FXCheckButton_setDefault(int argc, VALUE *argv, VALUE self) { FXCheckButton *arg1 = (FXCheckButton *) 0 ;
    FXbool arg2 = (FXbool) 1 ; if ((argc < 0) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXCheckButton, 1); if (argc > 0) { arg2 = to_FXbool(argv[0]); } 
    FXCheckButton_setDefault(arg1,arg2); return Qnil; }
static VALUE _wrap_FXCheckButton_enable(int argc, VALUE *argv, VALUE self) { FXCheckButton *arg1 = (FXCheckButton *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXCheckButton, 1); FXCheckButton_enable(arg1); return Qnil; }
static VALUE _wrap_FXCheckButton_disable(int argc, VALUE *argv, VALUE self) { FXCheckButton *arg1 = (FXCheckButton *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXCheckButton, 1); FXCheckButton_disable(arg1); return Qnil; }
static VALUE _wrap_FXCheckButton_raiseWindow(int argc, VALUE *argv, VALUE self) { FXCheckButton *arg1 = (FXCheckButton *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXCheckButton, 1); FXCheckButton_raise(arg1); return Qnil; }
static VALUE _wrap_FXCheckButton_lower(int argc, VALUE *argv, VALUE self) { FXCheckButton *arg1 = (FXCheckButton *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXCheckButton, 1); FXCheckButton_lower(arg1); return Qnil; }
static VALUE _wrap_FXCheckButton_move(int argc, VALUE *argv, VALUE self) { FXCheckButton *arg1 = (FXCheckButton *) 0 ;
    FXint arg2 ; FXint arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXCheckButton, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    FXCheckButton_move(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXCheckButton_position(int argc, VALUE *argv, VALUE self) { FXCheckButton *arg1 = (FXCheckButton *) 0 ;
    FXint arg2 ; FXint arg3 ; FXint arg4 ; FXint arg5 ; if ((argc < 4) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXCheckButton, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    arg4 = NUM2INT(argv[2]); arg5 = NUM2INT(argv[3]); FXCheckButton_position(arg1,arg2,arg3,arg4,arg5); return Qnil; }
static VALUE _wrap_FXCheckButton_layout(int argc, VALUE *argv, VALUE self) { FXCheckButton *arg1 = (FXCheckButton *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXCheckButton, 1); FXCheckButton_layout(arg1); return Qnil; }
static VALUE _wrap_FXCheckButton_recalc(int argc, VALUE *argv, VALUE self) { FXCheckButton *arg1 = (FXCheckButton *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXCheckButton, 1); FXCheckButton_recalc(arg1); return Qnil; }
static VALUE _wrap_FXCheckButton_reparent(int argc, VALUE *argv, VALUE self) { FXCheckButton *arg1 = (FXCheckButton *) 0 ;
    FXComposite *arg2 = (FXComposite *) 0 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXCheckButton, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXComposite, 1); FXCheckButton_reparent(arg1,arg2); return Qnil; }
static VALUE _wrap_FXCheckButton_show(int argc, VALUE *argv, VALUE self) { FXCheckButton *arg1 = (FXCheckButton *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXCheckButton, 1); FXCheckButton_show(arg1); return Qnil; }
static VALUE _wrap_FXCheckButton_hide(int argc, VALUE *argv, VALUE self) { FXCheckButton *arg1 = (FXCheckButton *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXCheckButton, 1); FXCheckButton_hide(arg1); return Qnil; }
static VALUE _wrap_FXCheckButton_isComposite(int argc, VALUE *argv, VALUE self) { FXCheckButton *arg1 = (FXCheckButton *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXCheckButton, 1);
    result = (FXbool)FXCheckButton_isComposite((FXCheckButton const *)arg1); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXCheckButton_contains(int argc, VALUE *argv, VALUE self) { FXCheckButton *arg1 = (FXCheckButton *) 0 ;
    FXint arg2 ; FXint arg3 ; FXbool result; VALUE vresult = Qnil; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXCheckButton, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    result = (FXbool)FXCheckButton_contains((FXCheckButton const *)arg1,arg2,arg3); vresult = result ? Qtrue : Qfalse;
    return vresult; }
static VALUE _wrap_FXCheckButton_doesSaveUnder(int argc, VALUE *argv, VALUE self) { FXCheckButton *arg1 = (FXCheckButton *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXCheckButton, 1);
    result = (FXbool)FXCheckButton_doesSaveUnder((FXCheckButton const *)arg1); vresult = result ? Qtrue : Qfalse;
    return vresult; }
static VALUE _wrap_FXCheckButton_setBackColor(int argc, VALUE *argv, VALUE self) { FXCheckButton *arg1 = (FXCheckButton *) 0 ;
    FXColor arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXCheckButton, 1); arg2 = to_FXColor(argv[0]);
    FXCheckButton_setBackColor(arg1,arg2); return Qnil; }
static VALUE _wrap_FXMenuButton_onPaint(int argc, VALUE *argv, VALUE self) { FXMenuButton *arg1 = (FXMenuButton *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuButton, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onPaint(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXMenuButton_onUpdate(int argc, VALUE *argv, VALUE self) { FXMenuButton *arg1 = (FXMenuButton *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuButton, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onUpdate(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXMenuButton_onEnter(int argc, VALUE *argv, VALUE self) { FXMenuButton *arg1 = (FXMenuButton *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuButton, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onEnter(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXMenuButton_onLeave(int argc, VALUE *argv, VALUE self) { FXMenuButton *arg1 = (FXMenuButton *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuButton, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onLeave(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXMenuButton_onFocusIn(int argc, VALUE *argv, VALUE self) { FXMenuButton *arg1 = (FXMenuButton *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuButton, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onFocusIn(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXMenuButton_onFocusOut(int argc, VALUE *argv, VALUE self) { FXMenuButton *arg1 = (FXMenuButton *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuButton, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onFocusOut(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXMenuButton_onUngrabbed(int argc, VALUE *argv, VALUE self) { FXMenuButton *arg1 = (FXMenuButton *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuButton, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onUngrabbed(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXMenuButton_onMotion(int argc, VALUE *argv, VALUE self) { FXMenuButton *arg1 = (FXMenuButton *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuButton, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onMotion(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXMenuButton_onLeftBtnPress(int argc, VALUE *argv, VALUE self) { FXMenuButton *arg1 = (FXMenuButton *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuButton, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onLeftBtnPress(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXMenuButton_onLeftBtnRelease(int argc, VALUE *argv, VALUE self) { FXMenuButton *arg1 = (FXMenuButton *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuButton, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onLeftBtnRelease(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXMenuButton_onKeyPress(int argc, VALUE *argv, VALUE self) { FXMenuButton *arg1 = (FXMenuButton *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuButton, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onKeyPress(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXMenuButton_onKeyRelease(int argc, VALUE *argv, VALUE self) { FXMenuButton *arg1 = (FXMenuButton *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuButton, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onKeyRelease(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXMenuButton_onHotKeyPress(int argc, VALUE *argv, VALUE self) { FXMenuButton *arg1 = (FXMenuButton *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuButton, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onHotKeyPress(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXMenuButton_onHotKeyRelease(int argc, VALUE *argv, VALUE self) { FXMenuButton *arg1 = (FXMenuButton *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuButton, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onHotKeyRelease(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXMenuButton_onCmdPost(int argc, VALUE *argv, VALUE self) { FXMenuButton *arg1 = (FXMenuButton *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuButton, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onCmdPost(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXMenuButton_onCmdUnpost(int argc, VALUE *argv, VALUE self) { FXMenuButton *arg1 = (FXMenuButton *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuButton, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onCmdUnpost(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE _wrap_FXMenuButton_allocate(VALUE self) {
#else
     static VALUE _wrap_FXMenuButton_allocate(int argc, VALUE *argv, VALUE self) {
#endif
         VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_FXMenuButton);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
         return vresult; }
static VALUE _wrap_new_FXMenuButton(int argc, VALUE *argv, VALUE self) { FXComposite *arg1 = (FXComposite *) 0 ;
    FXString *arg2 = 0 ; FXIcon *arg3 = (FXIcon *) 0 ; FXPopup *arg4 = (FXPopup *) 0 ;
    FXuint arg5 = (FXuint) JUSTIFY_NORMAL|ICON_BEFORE_TEXT|MENUBUTTON_DOWN ; FXint arg6 = (FXint) 0 ; FXint arg7 = (FXint) 0 ;
    FXint arg8 = (FXint) 0 ; FXint arg9 = (FXint) 0 ; FXint arg10 = (FXint) DEFAULT_PAD ; FXint arg11 = (FXint) DEFAULT_PAD ;
    FXint arg12 = (FXint) DEFAULT_PAD ; FXint arg13 = (FXint) DEFAULT_PAD ; FXMenuButton *result;
    SwigValueWrapper<FXString > p2 ; if ((argc < 2) || (argc > 13))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXComposite, 1); p2 = to_FXString(argv[1]); arg2 = &p2; if (argc > 2) {
        SWIG_ConvertPtr(argv[2], (void **) &arg3, SWIGTYPE_p_FXIcon, 1); }  if (argc > 3) {
        SWIG_ConvertPtr(argv[3], (void **) &arg4, SWIGTYPE_p_FXPopup, 1); }  if (argc > 4) { arg5 = NUM2UINT(argv[4]); } 
    if (argc > 5) { arg6 = NUM2INT(argv[5]); }  if (argc > 6) { arg7 = NUM2INT(argv[6]); }  if (argc > 7) {
        arg8 = NUM2INT(argv[7]); }  if (argc > 8) { arg9 = NUM2INT(argv[8]); }  if (argc > 9) { arg10 = NUM2INT(argv[9]); } 
    if (argc > 10) { arg11 = NUM2INT(argv[10]); }  if (argc > 11) { arg12 = NUM2INT(argv[11]); }  if (argc > 12) {
        arg13 = NUM2INT(argv[12]); }  {
        result = (FXMenuButton *)new_FXMenuButton(arg1,(FXString const &)*arg2,arg3,arg4,arg5,arg6,arg7,arg8,arg9,arg10,arg11,arg12,arg13);
        DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result); if(rb_block_given_p()){ rb_yield(self); }  }  return self; }
static VALUE _wrap_FXMenuButton_setMenu(int argc, VALUE *argv, VALUE self) { FXMenuButton *arg1 = (FXMenuButton *) 0 ;
    FXPopup *arg2 = (FXPopup *) 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuButton, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXPopup, 1); (arg1)->setMenu(arg2); return Qnil; }
static VALUE _wrap_FXMenuButton_getMenu(int argc, VALUE *argv, VALUE self) { FXMenuButton *arg1 = (FXMenuButton *) 0 ;
    FXPopup *result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuButton, 1);
    result = (FXPopup *)((FXMenuButton const *)arg1)->getMenu(); {
        swig_type_info *ty = SWIG_TypeDynamicCast(SWIGTYPE_p_FXPopup, (void **) &result); vresult = FXRbGetRubyObj(result, ty); }
     return vresult; }
static VALUE _wrap_FXMenuButton_setXOffset(int argc, VALUE *argv, VALUE self) { FXMenuButton *arg1 = (FXMenuButton *) 0 ;
    FXint arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuButton, 1); arg2 = NUM2INT(argv[0]); (arg1)->setXOffset(arg2);
    return Qnil; }
static VALUE _wrap_FXMenuButton_getXOffset(int argc, VALUE *argv, VALUE self) { FXMenuButton *arg1 = (FXMenuButton *) 0 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuButton, 1);
    result = (FXint)((FXMenuButton const *)arg1)->getXOffset(); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXMenuButton_setYOffset(int argc, VALUE *argv, VALUE self) { FXMenuButton *arg1 = (FXMenuButton *) 0 ;
    FXint arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuButton, 1); arg2 = NUM2INT(argv[0]); (arg1)->setYOffset(arg2);
    return Qnil; }
static VALUE _wrap_FXMenuButton_getYOffset(int argc, VALUE *argv, VALUE self) { FXMenuButton *arg1 = (FXMenuButton *) 0 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuButton, 1);
    result = (FXint)((FXMenuButton const *)arg1)->getYOffset(); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXMenuButton_setButtonStyle(int argc, VALUE *argv, VALUE self) { FXMenuButton *arg1 = (FXMenuButton *) 0 ;
    FXuint arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuButton, 1); arg2 = NUM2UINT(argv[0]); (arg1)->setButtonStyle(arg2);
    return Qnil; }
static VALUE _wrap_FXMenuButton_getButtonStyle(int argc, VALUE *argv, VALUE self) { FXMenuButton *arg1 = (FXMenuButton *) 0 ;
    FXuint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuButton, 1);
    result = (FXuint)((FXMenuButton const *)arg1)->getButtonStyle(); vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXMenuButton_setPopupStyle(int argc, VALUE *argv, VALUE self) { FXMenuButton *arg1 = (FXMenuButton *) 0 ;
    FXuint arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuButton, 1); arg2 = NUM2UINT(argv[0]); (arg1)->setPopupStyle(arg2);
    return Qnil; }
static VALUE _wrap_FXMenuButton_getPopupStyle(int argc, VALUE *argv, VALUE self) { FXMenuButton *arg1 = (FXMenuButton *) 0 ;
    FXuint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuButton, 1);
    result = (FXuint)((FXMenuButton const *)arg1)->getPopupStyle(); vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXMenuButton_setAttachment(int argc, VALUE *argv, VALUE self) { FXMenuButton *arg1 = (FXMenuButton *) 0 ;
    FXuint arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuButton, 1); arg2 = NUM2UINT(argv[0]); (arg1)->setAttachment(arg2);
    return Qnil; }
static VALUE _wrap_FXMenuButton_getAttachment(int argc, VALUE *argv, VALUE self) { FXMenuButton *arg1 = (FXMenuButton *) 0 ;
    FXuint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuButton, 1);
    result = (FXuint)((FXMenuButton const *)arg1)->getAttachment(); vresult = UINT2NUM(result); return vresult; }
static void
free_FXMenuButton(FXMenuButton *arg1) {
    delete arg1;
}
static VALUE _wrap_FXMenuButton_save(int argc, VALUE *argv, VALUE self) { FXMenuButton *arg1 = (FXMenuButton *) 0 ;
    FXStream *arg2 = 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuButton, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXMenuButton_save((FXMenuButton const *)arg1,*arg2); return Qnil; }
static VALUE _wrap_FXMenuButton_load(int argc, VALUE *argv, VALUE self) { FXMenuButton *arg1 = (FXMenuButton *) 0 ;
    FXStream *arg2 = 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuButton, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXMenuButton_load(arg1,*arg2); return Qnil; }
static VALUE _wrap_FXMenuButton_create(int argc, VALUE *argv, VALUE self) { FXMenuButton *arg1 = (FXMenuButton *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuButton, 1); FXMenuButton_create(arg1); return Qnil; }
static VALUE _wrap_FXMenuButton_detach(int argc, VALUE *argv, VALUE self) { FXMenuButton *arg1 = (FXMenuButton *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuButton, 1); FXMenuButton_detach(arg1); return Qnil; }
static VALUE _wrap_FXMenuButton_destroy(int argc, VALUE *argv, VALUE self) { FXMenuButton *arg1 = (FXMenuButton *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuButton, 1); FXMenuButton_destroy(arg1); return Qnil; }
static VALUE _wrap_FXMenuButton_resize(int argc, VALUE *argv, VALUE self) { FXMenuButton *arg1 = (FXMenuButton *) 0 ;
    FXint arg2 ; FXint arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuButton, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    FXMenuButton_resize(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXMenuButton_getDefaultWidth(int argc, VALUE *argv, VALUE self) { FXMenuButton *arg1 = (FXMenuButton *) 0 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuButton, 1); result = (FXint)FXMenuButton_getDefaultWidth(arg1);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXMenuButton_getDefaultHeight(int argc, VALUE *argv, VALUE self) { FXMenuButton *arg1 = (FXMenuButton *) 0 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuButton, 1); result = (FXint)FXMenuButton_getDefaultHeight(arg1);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXMenuButton_getWidthForHeight(int argc, VALUE *argv, VALUE self) { FXMenuButton *arg1 = (FXMenuButton *) 0 ;
    FXint arg2 ; FXint result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuButton, 1); arg2 = NUM2INT(argv[0]);
    result = (FXint)FXMenuButton_getWidthForHeight(arg1,arg2); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXMenuButton_getHeightForWidth(int argc, VALUE *argv, VALUE self) { FXMenuButton *arg1 = (FXMenuButton *) 0 ;
    FXint arg2 ; FXint result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuButton, 1); arg2 = NUM2INT(argv[0]);
    result = (FXint)FXMenuButton_getHeightForWidth(arg1,arg2); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXMenuButton_canFocus(int argc, VALUE *argv, VALUE self) { FXMenuButton *arg1 = (FXMenuButton *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuButton, 1);
    result = (FXbool)FXMenuButton_canFocus((FXMenuButton const *)arg1); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXMenuButton_setFocus(int argc, VALUE *argv, VALUE self) { FXMenuButton *arg1 = (FXMenuButton *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuButton, 1); FXMenuButton_setFocus(arg1); return Qnil; }
static VALUE _wrap_FXMenuButton_killFocus(int argc, VALUE *argv, VALUE self) { FXMenuButton *arg1 = (FXMenuButton *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuButton, 1); FXMenuButton_killFocus(arg1); return Qnil; }
static VALUE _wrap_FXMenuButton_setDefault(int argc, VALUE *argv, VALUE self) { FXMenuButton *arg1 = (FXMenuButton *) 0 ;
    FXbool arg2 = (FXbool) 1 ; if ((argc < 0) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuButton, 1); if (argc > 0) { arg2 = to_FXbool(argv[0]); } 
    FXMenuButton_setDefault(arg1,arg2); return Qnil; }
static VALUE _wrap_FXMenuButton_enable(int argc, VALUE *argv, VALUE self) { FXMenuButton *arg1 = (FXMenuButton *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuButton, 1); FXMenuButton_enable(arg1); return Qnil; }
static VALUE _wrap_FXMenuButton_disable(int argc, VALUE *argv, VALUE self) { FXMenuButton *arg1 = (FXMenuButton *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuButton, 1); FXMenuButton_disable(arg1); return Qnil; }
static VALUE _wrap_FXMenuButton_raiseWindow(int argc, VALUE *argv, VALUE self) { FXMenuButton *arg1 = (FXMenuButton *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuButton, 1); FXMenuButton_raise(arg1); return Qnil; }
static VALUE _wrap_FXMenuButton_lower(int argc, VALUE *argv, VALUE self) { FXMenuButton *arg1 = (FXMenuButton *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuButton, 1); FXMenuButton_lower(arg1); return Qnil; }
static VALUE _wrap_FXMenuButton_move(int argc, VALUE *argv, VALUE self) { FXMenuButton *arg1 = (FXMenuButton *) 0 ; FXint arg2 ;
    FXint arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuButton, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    FXMenuButton_move(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXMenuButton_position(int argc, VALUE *argv, VALUE self) { FXMenuButton *arg1 = (FXMenuButton *) 0 ;
    FXint arg2 ; FXint arg3 ; FXint arg4 ; FXint arg5 ; if ((argc < 4) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuButton, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    arg4 = NUM2INT(argv[2]); arg5 = NUM2INT(argv[3]); FXMenuButton_position(arg1,arg2,arg3,arg4,arg5); return Qnil; }
static VALUE _wrap_FXMenuButton_layout(int argc, VALUE *argv, VALUE self) { FXMenuButton *arg1 = (FXMenuButton *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuButton, 1); FXMenuButton_layout(arg1); return Qnil; }
static VALUE _wrap_FXMenuButton_recalc(int argc, VALUE *argv, VALUE self) { FXMenuButton *arg1 = (FXMenuButton *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuButton, 1); FXMenuButton_recalc(arg1); return Qnil; }
static VALUE _wrap_FXMenuButton_reparent(int argc, VALUE *argv, VALUE self) { FXMenuButton *arg1 = (FXMenuButton *) 0 ;
    FXComposite *arg2 = (FXComposite *) 0 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuButton, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXComposite, 1); FXMenuButton_reparent(arg1,arg2); return Qnil; }
static VALUE _wrap_FXMenuButton_show(int argc, VALUE *argv, VALUE self) { FXMenuButton *arg1 = (FXMenuButton *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuButton, 1); FXMenuButton_show(arg1); return Qnil; }
static VALUE _wrap_FXMenuButton_hide(int argc, VALUE *argv, VALUE self) { FXMenuButton *arg1 = (FXMenuButton *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuButton, 1); FXMenuButton_hide(arg1); return Qnil; }
static VALUE _wrap_FXMenuButton_isComposite(int argc, VALUE *argv, VALUE self) { FXMenuButton *arg1 = (FXMenuButton *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuButton, 1);
    result = (FXbool)FXMenuButton_isComposite((FXMenuButton const *)arg1); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXMenuButton_contains(int argc, VALUE *argv, VALUE self) { FXMenuButton *arg1 = (FXMenuButton *) 0 ;
    FXint arg2 ; FXint arg3 ; FXbool result; VALUE vresult = Qnil; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuButton, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    result = (FXbool)FXMenuButton_contains((FXMenuButton const *)arg1,arg2,arg3); vresult = result ? Qtrue : Qfalse;
    return vresult; }
static VALUE _wrap_FXMenuButton_doesSaveUnder(int argc, VALUE *argv, VALUE self) { FXMenuButton *arg1 = (FXMenuButton *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuButton, 1);
    result = (FXbool)FXMenuButton_doesSaveUnder((FXMenuButton const *)arg1); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXMenuButton_setBackColor(int argc, VALUE *argv, VALUE self) { FXMenuButton *arg1 = (FXMenuButton *) 0 ;
    FXColor arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuButton, 1); arg2 = to_FXColor(argv[0]);
    FXMenuButton_setBackColor(arg1,arg2); return Qnil; }
static VALUE _wrap_FXOption_onPaint(int argc, VALUE *argv, VALUE self) { FXOption *arg1 = (FXOption *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXOption, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onPaint(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXOption_onEnter(int argc, VALUE *argv, VALUE self) { FXOption *arg1 = (FXOption *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXOption, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onEnter(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXOption_onLeave(int argc, VALUE *argv, VALUE self) { FXOption *arg1 = (FXOption *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXOption, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onLeave(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXOption_onLeftBtnPress(int argc, VALUE *argv, VALUE self) { FXOption *arg1 = (FXOption *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXOption, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onLeftBtnPress(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXOption_onLeftBtnRelease(int argc, VALUE *argv, VALUE self) { FXOption *arg1 = (FXOption *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXOption, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onLeftBtnRelease(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXOption_onKeyPress(int argc, VALUE *argv, VALUE self) { FXOption *arg1 = (FXOption *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXOption, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onKeyPress(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXOption_onKeyRelease(int argc, VALUE *argv, VALUE self) { FXOption *arg1 = (FXOption *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXOption, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onKeyRelease(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXOption_onHotKeyPress(int argc, VALUE *argv, VALUE self) { FXOption *arg1 = (FXOption *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXOption, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onHotKeyPress(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXOption_onHotKeyRelease(int argc, VALUE *argv, VALUE self) { FXOption *arg1 = (FXOption *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXOption, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onHotKeyRelease(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE _wrap_FXOption_allocate(VALUE self) {
#else
     static VALUE _wrap_FXOption_allocate(int argc, VALUE *argv, VALUE self) {
#endif
         VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_FXOption);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
         return vresult; }
static VALUE _wrap_new_FXOption(int argc, VALUE *argv, VALUE self) { FXComposite *arg1 = (FXComposite *) 0 ;
    FXString *arg2 = 0 ; FXIcon *arg3 = (FXIcon *) 0 ; FXObject *arg4 = (FXObject *) 0 ; FXSelector arg5 = (FXSelector) 0 ;
    FXuint arg6 = (FXuint) JUSTIFY_NORMAL|ICON_BEFORE_TEXT ; FXint arg7 = (FXint) 0 ; FXint arg8 = (FXint) 0 ;
    FXint arg9 = (FXint) 0 ; FXint arg10 = (FXint) 0 ; FXint arg11 = (FXint) DEFAULT_PAD ; FXint arg12 = (FXint) DEFAULT_PAD ;
    FXint arg13 = (FXint) DEFAULT_PAD ; FXint arg14 = (FXint) DEFAULT_PAD ; FXOption *result; SwigValueWrapper<FXString > p2 ;
    if ((argc < 2) || (argc > 14)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXComposite, 1); p2 = to_FXString(argv[1]); arg2 = &p2; if (argc > 2) {
        SWIG_ConvertPtr(argv[2], (void **) &arg3, SWIGTYPE_p_FXIcon, 1); }  if (argc > 3) {
        SWIG_ConvertPtr(argv[3], (void **) &arg4, SWIGTYPE_p_FXObject, 1); }  if (argc > 4) { arg5 = NUM2UINT(argv[4]); } 
    if (argc > 5) { arg6 = NUM2UINT(argv[5]); }  if (argc > 6) { arg7 = NUM2INT(argv[6]); }  if (argc > 7) {
        arg8 = NUM2INT(argv[7]); }  if (argc > 8) { arg9 = NUM2INT(argv[8]); }  if (argc > 9) { arg10 = NUM2INT(argv[9]); } 
    if (argc > 10) { arg11 = NUM2INT(argv[10]); }  if (argc > 11) { arg12 = NUM2INT(argv[11]); }  if (argc > 12) {
        arg13 = NUM2INT(argv[12]); }  if (argc > 13) { arg14 = NUM2INT(argv[13]); }  {
        result = (FXOption *)new_FXOption(arg1,(FXString const &)*arg2,arg3,arg4,arg5,arg6,arg7,arg8,arg9,arg10,arg11,arg12,arg13,arg14);
        DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result); if(rb_block_given_p()){ rb_yield(self); }  }  return self; }
static void
free_FXOption(FXOption *arg1) {
    delete arg1;
}
static VALUE _wrap_FXOption_save(int argc, VALUE *argv, VALUE self) { FXOption *arg1 = (FXOption *) 0 ; FXStream *arg2 = 0 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXOption, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXOption_save((FXOption const *)arg1,*arg2); return Qnil; }
static VALUE _wrap_FXOption_load(int argc, VALUE *argv, VALUE self) { FXOption *arg1 = (FXOption *) 0 ; FXStream *arg2 = 0 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXOption, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXOption_load(arg1,*arg2); return Qnil; }
static VALUE _wrap_FXOption_create(int argc, VALUE *argv, VALUE self) { FXOption *arg1 = (FXOption *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXOption, 1); FXOption_create(arg1); return Qnil; }
static VALUE _wrap_FXOption_detach(int argc, VALUE *argv, VALUE self) { FXOption *arg1 = (FXOption *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXOption, 1); FXOption_detach(arg1); return Qnil; }
static VALUE _wrap_FXOption_destroy(int argc, VALUE *argv, VALUE self) { FXOption *arg1 = (FXOption *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXOption, 1); FXOption_destroy(arg1); return Qnil; }
static VALUE _wrap_FXOption_resize(int argc, VALUE *argv, VALUE self) { FXOption *arg1 = (FXOption *) 0 ; FXint arg2 ;
    FXint arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXOption, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    FXOption_resize(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXOption_getDefaultWidth(int argc, VALUE *argv, VALUE self) { FXOption *arg1 = (FXOption *) 0 ; FXint result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXOption, 1); result = (FXint)FXOption_getDefaultWidth(arg1);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXOption_getDefaultHeight(int argc, VALUE *argv, VALUE self) { FXOption *arg1 = (FXOption *) 0 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXOption, 1); result = (FXint)FXOption_getDefaultHeight(arg1);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXOption_getWidthForHeight(int argc, VALUE *argv, VALUE self) { FXOption *arg1 = (FXOption *) 0 ;
    FXint arg2 ; FXint result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXOption, 1); arg2 = NUM2INT(argv[0]);
    result = (FXint)FXOption_getWidthForHeight(arg1,arg2); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXOption_getHeightForWidth(int argc, VALUE *argv, VALUE self) { FXOption *arg1 = (FXOption *) 0 ;
    FXint arg2 ; FXint result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXOption, 1); arg2 = NUM2INT(argv[0]);
    result = (FXint)FXOption_getHeightForWidth(arg1,arg2); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXOption_canFocus(int argc, VALUE *argv, VALUE self) { FXOption *arg1 = (FXOption *) 0 ; FXbool result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXOption, 1); result = (FXbool)FXOption_canFocus((FXOption const *)arg1);
    vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXOption_setFocus(int argc, VALUE *argv, VALUE self) { FXOption *arg1 = (FXOption *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXOption, 1); FXOption_setFocus(arg1); return Qnil; }
static VALUE _wrap_FXOption_killFocus(int argc, VALUE *argv, VALUE self) { FXOption *arg1 = (FXOption *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXOption, 1); FXOption_killFocus(arg1); return Qnil; }
static VALUE _wrap_FXOption_setDefault(int argc, VALUE *argv, VALUE self) { FXOption *arg1 = (FXOption *) 0 ;
    FXbool arg2 = (FXbool) 1 ; if ((argc < 0) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXOption, 1); if (argc > 0) { arg2 = to_FXbool(argv[0]); } 
    FXOption_setDefault(arg1,arg2); return Qnil; }
static VALUE _wrap_FXOption_enable(int argc, VALUE *argv, VALUE self) { FXOption *arg1 = (FXOption *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXOption, 1); FXOption_enable(arg1); return Qnil; }
static VALUE _wrap_FXOption_disable(int argc, VALUE *argv, VALUE self) { FXOption *arg1 = (FXOption *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXOption, 1); FXOption_disable(arg1); return Qnil; }
static VALUE _wrap_FXOption_raiseWindow(int argc, VALUE *argv, VALUE self) { FXOption *arg1 = (FXOption *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXOption, 1); FXOption_raise(arg1); return Qnil; }
static VALUE _wrap_FXOption_lower(int argc, VALUE *argv, VALUE self) { FXOption *arg1 = (FXOption *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXOption, 1); FXOption_lower(arg1); return Qnil; }
static VALUE _wrap_FXOption_move(int argc, VALUE *argv, VALUE self) { FXOption *arg1 = (FXOption *) 0 ; FXint arg2 ;
    FXint arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXOption, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    FXOption_move(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXOption_position(int argc, VALUE *argv, VALUE self) { FXOption *arg1 = (FXOption *) 0 ; FXint arg2 ;
    FXint arg3 ; FXint arg4 ; FXint arg5 ; if ((argc < 4) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXOption, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    arg4 = NUM2INT(argv[2]); arg5 = NUM2INT(argv[3]); FXOption_position(arg1,arg2,arg3,arg4,arg5); return Qnil; }
static VALUE _wrap_FXOption_layout(int argc, VALUE *argv, VALUE self) { FXOption *arg1 = (FXOption *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXOption, 1); FXOption_layout(arg1); return Qnil; }
static VALUE _wrap_FXOption_recalc(int argc, VALUE *argv, VALUE self) { FXOption *arg1 = (FXOption *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXOption, 1); FXOption_recalc(arg1); return Qnil; }
static VALUE _wrap_FXOption_reparent(int argc, VALUE *argv, VALUE self) { FXOption *arg1 = (FXOption *) 0 ;
    FXComposite *arg2 = (FXComposite *) 0 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXOption, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXComposite, 1); FXOption_reparent(arg1,arg2); return Qnil; }
static VALUE _wrap_FXOption_show(int argc, VALUE *argv, VALUE self) { FXOption *arg1 = (FXOption *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXOption, 1); FXOption_show(arg1); return Qnil; }
static VALUE _wrap_FXOption_hide(int argc, VALUE *argv, VALUE self) { FXOption *arg1 = (FXOption *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXOption, 1); FXOption_hide(arg1); return Qnil; }
static VALUE _wrap_FXOption_isComposite(int argc, VALUE *argv, VALUE self) { FXOption *arg1 = (FXOption *) 0 ; FXbool result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXOption, 1);
    result = (FXbool)FXOption_isComposite((FXOption const *)arg1); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXOption_contains(int argc, VALUE *argv, VALUE self) { FXOption *arg1 = (FXOption *) 0 ; FXint arg2 ;
    FXint arg3 ; FXbool result; VALUE vresult = Qnil; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXOption, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    result = (FXbool)FXOption_contains((FXOption const *)arg1,arg2,arg3); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXOption_doesSaveUnder(int argc, VALUE *argv, VALUE self) { FXOption *arg1 = (FXOption *) 0 ; FXbool result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXOption, 1);
    result = (FXbool)FXOption_doesSaveUnder((FXOption const *)arg1); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXOption_setBackColor(int argc, VALUE *argv, VALUE self) { FXOption *arg1 = (FXOption *) 0 ; FXColor arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXOption, 1); arg2 = to_FXColor(argv[0]);
    FXOption_setBackColor(arg1,arg2); return Qnil; }
static VALUE _wrap_FXOptionMenu_onPaint(int argc, VALUE *argv, VALUE self) { FXOptionMenu *arg1 = (FXOptionMenu *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXOptionMenu, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onPaint(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXOptionMenu_onLeftBtnPress(int argc, VALUE *argv, VALUE self) { FXOptionMenu *arg1 = (FXOptionMenu *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXOptionMenu, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onLeftBtnPress(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXOptionMenu_onLeftBtnRelease(int argc, VALUE *argv, VALUE self) { FXOptionMenu *arg1 = (FXOptionMenu *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXOptionMenu, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onLeftBtnRelease(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXOptionMenu_onFocusIn(int argc, VALUE *argv, VALUE self) { FXOptionMenu *arg1 = (FXOptionMenu *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXOptionMenu, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onFocusIn(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXOptionMenu_onFocusOut(int argc, VALUE *argv, VALUE self) { FXOptionMenu *arg1 = (FXOptionMenu *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXOptionMenu, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onFocusOut(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXOptionMenu_onMotion(int argc, VALUE *argv, VALUE self) { FXOptionMenu *arg1 = (FXOptionMenu *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXOptionMenu, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onMotion(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXOptionMenu_onKeyPress(int argc, VALUE *argv, VALUE self) { FXOptionMenu *arg1 = (FXOptionMenu *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXOptionMenu, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onKeyPress(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXOptionMenu_onKeyRelease(int argc, VALUE *argv, VALUE self) { FXOptionMenu *arg1 = (FXOptionMenu *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXOptionMenu, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onKeyRelease(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXOptionMenu_onCmdPost(int argc, VALUE *argv, VALUE self) { FXOptionMenu *arg1 = (FXOptionMenu *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXOptionMenu, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdPost(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXOptionMenu_onCmdUnpost(int argc, VALUE *argv, VALUE self) { FXOptionMenu *arg1 = (FXOptionMenu *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXOptionMenu, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]);
    SWIG_ConvertPtr(argv[2], (void **) &arg4, 0, 1); result = (long)(arg1)->onCmdUnpost(arg2,arg3,arg4);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXOptionMenu_onQueryHelp(int argc, VALUE *argv, VALUE self) { FXOptionMenu *arg1 = (FXOptionMenu *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXOptionMenu, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onQueryHelp(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXOptionMenu_onQueryTip(int argc, VALUE *argv, VALUE self) { FXOptionMenu *arg1 = (FXOptionMenu *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXOptionMenu, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onQueryTip(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXOptionMenu_onCmdSetValue(int argc, VALUE *argv, VALUE self) { FXOptionMenu *arg1 = (FXOptionMenu *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXOptionMenu, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]);
    arg4 = reinterpret_cast<void*>(NUM2INT(argv[2])); result = (long)(arg1)->onCmdSetValue(arg2,arg3,arg4);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXOptionMenu_onCmdSetIntValue(int argc, VALUE *argv, VALUE self) { FXOptionMenu *arg1 = (FXOptionMenu *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; FXint value4 ;
    VALUE vresult = Qnil; if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXOptionMenu, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); {
        value4 = (FXint) NUM2INT(argv[2]); arg4 = static_cast<void*>(&value4); } 
    result = (long)(arg1)->onCmdSetIntValue(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXOptionMenu_onCmdGetIntValue(int argc, VALUE *argv, VALUE self) { FXOptionMenu *arg1 = (FXOptionMenu *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXOptionMenu, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdGetIntValue(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE _wrap_FXOptionMenu_allocate(VALUE self) {
#else
     static VALUE _wrap_FXOptionMenu_allocate(int argc, VALUE *argv, VALUE self) {
#endif
         VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_FXOptionMenu);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
         return vresult; }
static VALUE _wrap_new_FXOptionMenu(int argc, VALUE *argv, VALUE self) { FXComposite *arg1 = (FXComposite *) 0 ;
    FXPopup *arg2 = (FXPopup *) 0 ; FXuint arg3 = (FXuint) JUSTIFY_NORMAL|ICON_BEFORE_TEXT ; FXint arg4 = (FXint) 0 ;
    FXint arg5 = (FXint) 0 ; FXint arg6 = (FXint) 0 ; FXint arg7 = (FXint) 0 ; FXint arg8 = (FXint) DEFAULT_PAD ;
    FXint arg9 = (FXint) DEFAULT_PAD ; FXint arg10 = (FXint) DEFAULT_PAD ; FXint arg11 = (FXint) DEFAULT_PAD ;
    FXOptionMenu *result; if ((argc < 1) || (argc > 11)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXComposite, 1); if (argc > 1) {
        SWIG_ConvertPtr(argv[1], (void **) &arg2, SWIGTYPE_p_FXPopup, 1); }  if (argc > 2) { arg3 = NUM2UINT(argv[2]); } 
    if (argc > 3) { arg4 = NUM2INT(argv[3]); }  if (argc > 4) { arg5 = NUM2INT(argv[4]); }  if (argc > 5) {
        arg6 = NUM2INT(argv[5]); }  if (argc > 6) { arg7 = NUM2INT(argv[6]); }  if (argc > 7) { arg8 = NUM2INT(argv[7]); } 
    if (argc > 8) { arg9 = NUM2INT(argv[8]); }  if (argc > 9) { arg10 = NUM2INT(argv[9]); }  if (argc > 10) {
        arg11 = NUM2INT(argv[10]); }  {
        result = (FXOptionMenu *)new_FXOptionMenu(arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8,arg9,arg10,arg11);
        DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result); if(rb_block_given_p()){ rb_yield(self); }  }  return self; }
static VALUE _wrap_FXOptionMenu_setCurrent(int argc, VALUE *argv, VALUE self) { FXOptionMenu *arg1 = (FXOptionMenu *) 0 ;
    FXOption *arg2 = (FXOption *) 0 ; FXbool arg3 = (FXbool) 0 ; if ((argc < 1) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXOptionMenu, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXOption, 1); if (argc > 1) { arg3 = to_FXbool(argv[1]); } 
    (arg1)->setCurrent(arg2,arg3); return Qnil; }
static VALUE _wrap_FXOptionMenu_getCurrent(int argc, VALUE *argv, VALUE self) { FXOptionMenu *arg1 = (FXOptionMenu *) 0 ;
    FXOption *result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXOptionMenu, 1);
    result = (FXOption *)((FXOptionMenu const *)arg1)->getCurrent(); {
        swig_type_info *ty = SWIG_TypeDynamicCast(SWIGTYPE_p_FXOption, (void **) &result);
        vresult = FXRbGetRubyObj(result, ty); }  return vresult; }
static VALUE _wrap_FXOptionMenu_setCurrentNo(int argc, VALUE *argv, VALUE self) { FXOptionMenu *arg1 = (FXOptionMenu *) 0 ;
    FXint arg2 ; FXbool arg3 = (FXbool) 0 ; if ((argc < 1) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXOptionMenu, 1); arg2 = NUM2INT(argv[0]); if (argc > 1) {
        arg3 = to_FXbool(argv[1]); }  (arg1)->setCurrentNo(arg2,arg3); return Qnil; }
static VALUE _wrap_FXOptionMenu_getCurrentNo(int argc, VALUE *argv, VALUE self) { FXOptionMenu *arg1 = (FXOptionMenu *) 0 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXOptionMenu, 1);
    result = (FXint)((FXOptionMenu const *)arg1)->getCurrentNo(); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXOptionMenu_getNumOptions(int argc, VALUE *argv, VALUE self) { FXOptionMenu *arg1 = (FXOptionMenu *) 0 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXOptionMenu, 1);
    result = (FXint)((FXOptionMenu const *)arg1)->getNumOptions(); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXOptionMenu_setMenu(int argc, VALUE *argv, VALUE self) { FXOptionMenu *arg1 = (FXOptionMenu *) 0 ;
    FXPopup *arg2 = (FXPopup *) 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXOptionMenu, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXPopup, 1); (arg1)->setMenu(arg2); return Qnil; }
static VALUE _wrap_FXOptionMenu_getMenu(int argc, VALUE *argv, VALUE self) { FXOptionMenu *arg1 = (FXOptionMenu *) 0 ;
    FXPopup *result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXOptionMenu, 1);
    result = (FXPopup *)((FXOptionMenu const *)arg1)->getMenu(); {
        swig_type_info *ty = SWIG_TypeDynamicCast(SWIGTYPE_p_FXPopup, (void **) &result); vresult = FXRbGetRubyObj(result, ty); }
     return vresult; }
static VALUE _wrap_FXOptionMenu_isPopped(int argc, VALUE *argv, VALUE self) { FXOptionMenu *arg1 = (FXOptionMenu *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXOptionMenu, 1);
    result = (FXbool)((FXOptionMenu const *)arg1)->isPopped(); vresult = result ? Qtrue : Qfalse; return vresult; }
static void
free_FXOptionMenu(FXOptionMenu *arg1) {
    delete arg1;
}
static VALUE _wrap_FXOptionMenu_save(int argc, VALUE *argv, VALUE self) { FXOptionMenu *arg1 = (FXOptionMenu *) 0 ;
    FXStream *arg2 = 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXOptionMenu, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXOptionMenu_save((FXOptionMenu const *)arg1,*arg2); return Qnil; }
static VALUE _wrap_FXOptionMenu_load(int argc, VALUE *argv, VALUE self) { FXOptionMenu *arg1 = (FXOptionMenu *) 0 ;
    FXStream *arg2 = 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXOptionMenu, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXOptionMenu_load(arg1,*arg2); return Qnil; }
static VALUE _wrap_FXOptionMenu_create(int argc, VALUE *argv, VALUE self) { FXOptionMenu *arg1 = (FXOptionMenu *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXOptionMenu, 1); FXOptionMenu_create(arg1); return Qnil; }
static VALUE _wrap_FXOptionMenu_detach(int argc, VALUE *argv, VALUE self) { FXOptionMenu *arg1 = (FXOptionMenu *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXOptionMenu, 1); FXOptionMenu_detach(arg1); return Qnil; }
static VALUE _wrap_FXOptionMenu_destroy(int argc, VALUE *argv, VALUE self) { FXOptionMenu *arg1 = (FXOptionMenu *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXOptionMenu, 1); FXOptionMenu_destroy(arg1); return Qnil; }
static VALUE _wrap_FXOptionMenu_resize(int argc, VALUE *argv, VALUE self) { FXOptionMenu *arg1 = (FXOptionMenu *) 0 ;
    FXint arg2 ; FXint arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXOptionMenu, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    FXOptionMenu_resize(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXOptionMenu_getDefaultWidth(int argc, VALUE *argv, VALUE self) { FXOptionMenu *arg1 = (FXOptionMenu *) 0 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXOptionMenu, 1); result = (FXint)FXOptionMenu_getDefaultWidth(arg1);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXOptionMenu_getDefaultHeight(int argc, VALUE *argv, VALUE self) { FXOptionMenu *arg1 = (FXOptionMenu *) 0 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXOptionMenu, 1); result = (FXint)FXOptionMenu_getDefaultHeight(arg1);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXOptionMenu_getWidthForHeight(int argc, VALUE *argv, VALUE self) { FXOptionMenu *arg1 = (FXOptionMenu *) 0 ;
    FXint arg2 ; FXint result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXOptionMenu, 1); arg2 = NUM2INT(argv[0]);
    result = (FXint)FXOptionMenu_getWidthForHeight(arg1,arg2); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXOptionMenu_getHeightForWidth(int argc, VALUE *argv, VALUE self) { FXOptionMenu *arg1 = (FXOptionMenu *) 0 ;
    FXint arg2 ; FXint result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXOptionMenu, 1); arg2 = NUM2INT(argv[0]);
    result = (FXint)FXOptionMenu_getHeightForWidth(arg1,arg2); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXOptionMenu_canFocus(int argc, VALUE *argv, VALUE self) { FXOptionMenu *arg1 = (FXOptionMenu *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXOptionMenu, 1);
    result = (FXbool)FXOptionMenu_canFocus((FXOptionMenu const *)arg1); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXOptionMenu_setFocus(int argc, VALUE *argv, VALUE self) { FXOptionMenu *arg1 = (FXOptionMenu *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXOptionMenu, 1); FXOptionMenu_setFocus(arg1); return Qnil; }
static VALUE _wrap_FXOptionMenu_killFocus(int argc, VALUE *argv, VALUE self) { FXOptionMenu *arg1 = (FXOptionMenu *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXOptionMenu, 1); FXOptionMenu_killFocus(arg1); return Qnil; }
static VALUE _wrap_FXOptionMenu_setDefault(int argc, VALUE *argv, VALUE self) { FXOptionMenu *arg1 = (FXOptionMenu *) 0 ;
    FXbool arg2 = (FXbool) 1 ; if ((argc < 0) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXOptionMenu, 1); if (argc > 0) { arg2 = to_FXbool(argv[0]); } 
    FXOptionMenu_setDefault(arg1,arg2); return Qnil; }
static VALUE _wrap_FXOptionMenu_enable(int argc, VALUE *argv, VALUE self) { FXOptionMenu *arg1 = (FXOptionMenu *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXOptionMenu, 1); FXOptionMenu_enable(arg1); return Qnil; }
static VALUE _wrap_FXOptionMenu_disable(int argc, VALUE *argv, VALUE self) { FXOptionMenu *arg1 = (FXOptionMenu *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXOptionMenu, 1); FXOptionMenu_disable(arg1); return Qnil; }
static VALUE _wrap_FXOptionMenu_raiseWindow(int argc, VALUE *argv, VALUE self) { FXOptionMenu *arg1 = (FXOptionMenu *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXOptionMenu, 1); FXOptionMenu_raise(arg1); return Qnil; }
static VALUE _wrap_FXOptionMenu_lower(int argc, VALUE *argv, VALUE self) { FXOptionMenu *arg1 = (FXOptionMenu *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXOptionMenu, 1); FXOptionMenu_lower(arg1); return Qnil; }
static VALUE _wrap_FXOptionMenu_move(int argc, VALUE *argv, VALUE self) { FXOptionMenu *arg1 = (FXOptionMenu *) 0 ; FXint arg2 ;
    FXint arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXOptionMenu, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    FXOptionMenu_move(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXOptionMenu_position(int argc, VALUE *argv, VALUE self) { FXOptionMenu *arg1 = (FXOptionMenu *) 0 ;
    FXint arg2 ; FXint arg3 ; FXint arg4 ; FXint arg5 ; if ((argc < 4) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXOptionMenu, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    arg4 = NUM2INT(argv[2]); arg5 = NUM2INT(argv[3]); FXOptionMenu_position(arg1,arg2,arg3,arg4,arg5); return Qnil; }
static VALUE _wrap_FXOptionMenu_layout(int argc, VALUE *argv, VALUE self) { FXOptionMenu *arg1 = (FXOptionMenu *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXOptionMenu, 1); FXOptionMenu_layout(arg1); return Qnil; }
static VALUE _wrap_FXOptionMenu_recalc(int argc, VALUE *argv, VALUE self) { FXOptionMenu *arg1 = (FXOptionMenu *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXOptionMenu, 1); FXOptionMenu_recalc(arg1); return Qnil; }
static VALUE _wrap_FXOptionMenu_reparent(int argc, VALUE *argv, VALUE self) { FXOptionMenu *arg1 = (FXOptionMenu *) 0 ;
    FXComposite *arg2 = (FXComposite *) 0 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXOptionMenu, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXComposite, 1); FXOptionMenu_reparent(arg1,arg2); return Qnil; }
static VALUE _wrap_FXOptionMenu_show(int argc, VALUE *argv, VALUE self) { FXOptionMenu *arg1 = (FXOptionMenu *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXOptionMenu, 1); FXOptionMenu_show(arg1); return Qnil; }
static VALUE _wrap_FXOptionMenu_hide(int argc, VALUE *argv, VALUE self) { FXOptionMenu *arg1 = (FXOptionMenu *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXOptionMenu, 1); FXOptionMenu_hide(arg1); return Qnil; }
static VALUE _wrap_FXOptionMenu_isComposite(int argc, VALUE *argv, VALUE self) { FXOptionMenu *arg1 = (FXOptionMenu *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXOptionMenu, 1);
    result = (FXbool)FXOptionMenu_isComposite((FXOptionMenu const *)arg1); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXOptionMenu_contains(int argc, VALUE *argv, VALUE self) { FXOptionMenu *arg1 = (FXOptionMenu *) 0 ;
    FXint arg2 ; FXint arg3 ; FXbool result; VALUE vresult = Qnil; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXOptionMenu, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    result = (FXbool)FXOptionMenu_contains((FXOptionMenu const *)arg1,arg2,arg3); vresult = result ? Qtrue : Qfalse;
    return vresult; }
static VALUE _wrap_FXOptionMenu_doesSaveUnder(int argc, VALUE *argv, VALUE self) { FXOptionMenu *arg1 = (FXOptionMenu *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXOptionMenu, 1);
    result = (FXbool)FXOptionMenu_doesSaveUnder((FXOptionMenu const *)arg1); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXOptionMenu_setBackColor(int argc, VALUE *argv, VALUE self) { FXOptionMenu *arg1 = (FXOptionMenu *) 0 ;
    FXColor arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXOptionMenu, 1); arg2 = to_FXColor(argv[0]);
    FXOptionMenu_setBackColor(arg1,arg2); return Qnil; }
static VALUE _wrap_FXRadioButton_onPaint(int argc, VALUE *argv, VALUE self) { FXRadioButton *arg1 = (FXRadioButton *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRadioButton, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onPaint(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXRadioButton_onUpdate(int argc, VALUE *argv, VALUE self) { FXRadioButton *arg1 = (FXRadioButton *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRadioButton, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onUpdate(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXRadioButton_onEnter(int argc, VALUE *argv, VALUE self) { FXRadioButton *arg1 = (FXRadioButton *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRadioButton, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onEnter(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXRadioButton_onLeave(int argc, VALUE *argv, VALUE self) { FXRadioButton *arg1 = (FXRadioButton *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRadioButton, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onLeave(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXRadioButton_onFocusIn(int argc, VALUE *argv, VALUE self) { FXRadioButton *arg1 = (FXRadioButton *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRadioButton, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onFocusIn(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXRadioButton_onFocusOut(int argc, VALUE *argv, VALUE self) { FXRadioButton *arg1 = (FXRadioButton *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRadioButton, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onFocusOut(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXRadioButton_onUngrabbed(int argc, VALUE *argv, VALUE self) { FXRadioButton *arg1 = (FXRadioButton *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRadioButton, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onUngrabbed(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXRadioButton_onLeftBtnPress(int argc, VALUE *argv, VALUE self) { FXRadioButton *arg1 = (FXRadioButton *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRadioButton, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onLeftBtnPress(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXRadioButton_onLeftBtnRelease(int argc, VALUE *argv, VALUE self) {
    FXRadioButton *arg1 = (FXRadioButton *) 0 ; FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ;
    long result; VALUE vresult = Qnil; if ((argc < 3) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRadioButton, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onLeftBtnRelease(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXRadioButton_onKeyPress(int argc, VALUE *argv, VALUE self) { FXRadioButton *arg1 = (FXRadioButton *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRadioButton, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onKeyPress(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXRadioButton_onKeyRelease(int argc, VALUE *argv, VALUE self) { FXRadioButton *arg1 = (FXRadioButton *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRadioButton, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onKeyRelease(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXRadioButton_onHotKeyPress(int argc, VALUE *argv, VALUE self) { FXRadioButton *arg1 = (FXRadioButton *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRadioButton, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onHotKeyPress(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXRadioButton_onHotKeyRelease(int argc, VALUE *argv, VALUE self) {
    FXRadioButton *arg1 = (FXRadioButton *) 0 ; FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ;
    long result; VALUE vresult = Qnil; if ((argc < 3) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRadioButton, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onHotKeyRelease(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXRadioButton_onCheck(int argc, VALUE *argv, VALUE self) { FXRadioButton *arg1 = (FXRadioButton *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRadioButton, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCheck(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXRadioButton_onUncheck(int argc, VALUE *argv, VALUE self) { FXRadioButton *arg1 = (FXRadioButton *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRadioButton, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onUncheck(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXRadioButton_onUnknown(int argc, VALUE *argv, VALUE self) { FXRadioButton *arg1 = (FXRadioButton *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRadioButton, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onUnknown(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXRadioButton_onCmdSetValue(int argc, VALUE *argv, VALUE self) { FXRadioButton *arg1 = (FXRadioButton *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRadioButton, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]);
    arg4 = reinterpret_cast<void*>(NUM2INT(argv[2])); result = (long)(arg1)->onCmdSetValue(arg2,arg3,arg4);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXRadioButton_onCmdSetIntValue(int argc, VALUE *argv, VALUE self) {
    FXRadioButton *arg1 = (FXRadioButton *) 0 ; FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ;
    long result; FXint value4 ; VALUE vresult = Qnil; if ((argc < 3) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRadioButton, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); {
        value4 = (FXint) NUM2INT(argv[2]); arg4 = static_cast<void*>(&value4); } 
    result = (long)(arg1)->onCmdSetIntValue(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXRadioButton_onCmdGetIntValue(int argc, VALUE *argv, VALUE self) {
    FXRadioButton *arg1 = (FXRadioButton *) 0 ; FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ;
    long result; VALUE vresult = Qnil; if ((argc < 3) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRadioButton, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdGetIntValue(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE _wrap_FXRadioButton_allocate(VALUE self) {
#else
     static VALUE _wrap_FXRadioButton_allocate(int argc, VALUE *argv, VALUE self) {
#endif
         VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_FXRadioButton);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
         return vresult; }
static VALUE _wrap_new_FXRadioButton(int argc, VALUE *argv, VALUE self) { FXComposite *arg1 = (FXComposite *) 0 ;
    FXString *arg2 = 0 ; FXObject *arg3 = (FXObject *) 0 ; FXSelector arg4 = (FXSelector) 0 ;
    FXuint arg5 = (FXuint) RADIOBUTTON_NORMAL ; FXint arg6 = (FXint) 0 ; FXint arg7 = (FXint) 0 ; FXint arg8 = (FXint) 0 ;
    FXint arg9 = (FXint) 0 ; FXint arg10 = (FXint) DEFAULT_PAD ; FXint arg11 = (FXint) DEFAULT_PAD ;
    FXint arg12 = (FXint) DEFAULT_PAD ; FXint arg13 = (FXint) DEFAULT_PAD ; FXRadioButton *result;
    SwigValueWrapper<FXString > p2 ; if ((argc < 2) || (argc > 13))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXComposite, 1); p2 = to_FXString(argv[1]); arg2 = &p2; if (argc > 2) {
        SWIG_ConvertPtr(argv[2], (void **) &arg3, SWIGTYPE_p_FXObject, 1); }  if (argc > 3) { arg4 = NUM2UINT(argv[3]); } 
    if (argc > 4) { arg5 = NUM2UINT(argv[4]); }  if (argc > 5) { arg6 = NUM2INT(argv[5]); }  if (argc > 6) {
        arg7 = NUM2INT(argv[6]); }  if (argc > 7) { arg8 = NUM2INT(argv[7]); }  if (argc > 8) { arg9 = NUM2INT(argv[8]); } 
    if (argc > 9) { arg10 = NUM2INT(argv[9]); }  if (argc > 10) { arg11 = NUM2INT(argv[10]); }  if (argc > 11) {
        arg12 = NUM2INT(argv[11]); }  if (argc > 12) { arg13 = NUM2INT(argv[12]); }  {
        result = (FXRadioButton *)new_FXRadioButton(arg1,(FXString const &)*arg2,arg3,arg4,arg5,arg6,arg7,arg8,arg9,arg10,arg11,arg12,arg13);
        DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result); if(rb_block_given_p()){ rb_yield(self); }  }  return self; }
static VALUE _wrap_FXRadioButton_setCheck(int argc, VALUE *argv, VALUE self) { FXRadioButton *arg1 = (FXRadioButton *) 0 ;
    FXbool arg2 = (FXbool) 1 ; if ((argc < 0) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRadioButton, 1); if (argc > 0) { arg2 = to_FXbool(argv[0]); } 
    (arg1)->setCheck(arg2); return Qnil; }
static VALUE _wrap_FXRadioButton_getCheck(int argc, VALUE *argv, VALUE self) { FXRadioButton *arg1 = (FXRadioButton *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRadioButton, 1);
    result = (FXbool)FXRadioButton_getCheck((FXRadioButton const *)arg1); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXRadioButton_getCheckState(int argc, VALUE *argv, VALUE self) { FXRadioButton *arg1 = (FXRadioButton *) 0 ;
    FXuchar result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRadioButton, 1);
    result = (FXuchar)FXRadioButton_getCheckState((FXRadioButton const *)arg1); vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXRadioButton_setRadioButtonStyle(int argc, VALUE *argv, VALUE self) {
    FXRadioButton *arg1 = (FXRadioButton *) 0 ; FXuint arg2 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRadioButton, 1); arg2 = NUM2UINT(argv[0]);
    (arg1)->setRadioButtonStyle(arg2); return Qnil; }
static VALUE _wrap_FXRadioButton_getRadioButtonStyle(int argc, VALUE *argv, VALUE self) {
    FXRadioButton *arg1 = (FXRadioButton *) 0 ; FXuint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRadioButton, 1);
    result = (FXuint)((FXRadioButton const *)arg1)->getRadioButtonStyle(); vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXRadioButton_getRadioColor(int argc, VALUE *argv, VALUE self) { FXRadioButton *arg1 = (FXRadioButton *) 0 ;
    FXColor result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRadioButton, 1);
    result = (FXColor)((FXRadioButton const *)arg1)->getRadioColor(); vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXRadioButton_setRadioColor(int argc, VALUE *argv, VALUE self) { FXRadioButton *arg1 = (FXRadioButton *) 0 ;
    FXColor arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRadioButton, 1); arg2 = to_FXColor(argv[0]);
    (arg1)->setRadioColor(arg2); return Qnil; }
static VALUE _wrap_FXRadioButton_getDiskColor(int argc, VALUE *argv, VALUE self) { FXRadioButton *arg1 = (FXRadioButton *) 0 ;
    FXColor result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRadioButton, 1);
    result = (FXColor)((FXRadioButton const *)arg1)->getDiskColor(); vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXRadioButton_setDiskColor(int argc, VALUE *argv, VALUE self) { FXRadioButton *arg1 = (FXRadioButton *) 0 ;
    FXColor arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRadioButton, 1); arg2 = to_FXColor(argv[0]); (arg1)->setDiskColor(arg2);
    return Qnil; }
static void
free_FXRadioButton(FXRadioButton *arg1) {
    delete arg1;
}
static VALUE _wrap_FXRadioButton_save(int argc, VALUE *argv, VALUE self) { FXRadioButton *arg1 = (FXRadioButton *) 0 ;
    FXStream *arg2 = 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRadioButton, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXRadioButton_save((FXRadioButton const *)arg1,*arg2); return Qnil; }
static VALUE _wrap_FXRadioButton_load(int argc, VALUE *argv, VALUE self) { FXRadioButton *arg1 = (FXRadioButton *) 0 ;
    FXStream *arg2 = 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRadioButton, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXRadioButton_load(arg1,*arg2); return Qnil; }
static VALUE _wrap_FXRadioButton_create(int argc, VALUE *argv, VALUE self) { FXRadioButton *arg1 = (FXRadioButton *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRadioButton, 1); FXRadioButton_create(arg1); return Qnil; }
static VALUE _wrap_FXRadioButton_detach(int argc, VALUE *argv, VALUE self) { FXRadioButton *arg1 = (FXRadioButton *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRadioButton, 1); FXRadioButton_detach(arg1); return Qnil; }
static VALUE _wrap_FXRadioButton_destroy(int argc, VALUE *argv, VALUE self) { FXRadioButton *arg1 = (FXRadioButton *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRadioButton, 1); FXRadioButton_destroy(arg1); return Qnil; }
static VALUE _wrap_FXRadioButton_resize(int argc, VALUE *argv, VALUE self) { FXRadioButton *arg1 = (FXRadioButton *) 0 ;
    FXint arg2 ; FXint arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRadioButton, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    FXRadioButton_resize(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXRadioButton_getDefaultWidth(int argc, VALUE *argv, VALUE self) {
    FXRadioButton *arg1 = (FXRadioButton *) 0 ; FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRadioButton, 1); result = (FXint)FXRadioButton_getDefaultWidth(arg1);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXRadioButton_getDefaultHeight(int argc, VALUE *argv, VALUE self) {
    FXRadioButton *arg1 = (FXRadioButton *) 0 ; FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRadioButton, 1); result = (FXint)FXRadioButton_getDefaultHeight(arg1);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXRadioButton_getWidthForHeight(int argc, VALUE *argv, VALUE self) {
    FXRadioButton *arg1 = (FXRadioButton *) 0 ; FXint arg2 ; FXint result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRadioButton, 1); arg2 = NUM2INT(argv[0]);
    result = (FXint)FXRadioButton_getWidthForHeight(arg1,arg2); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXRadioButton_getHeightForWidth(int argc, VALUE *argv, VALUE self) {
    FXRadioButton *arg1 = (FXRadioButton *) 0 ; FXint arg2 ; FXint result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRadioButton, 1); arg2 = NUM2INT(argv[0]);
    result = (FXint)FXRadioButton_getHeightForWidth(arg1,arg2); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXRadioButton_canFocus(int argc, VALUE *argv, VALUE self) { FXRadioButton *arg1 = (FXRadioButton *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRadioButton, 1);
    result = (FXbool)FXRadioButton_canFocus((FXRadioButton const *)arg1); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXRadioButton_setFocus(int argc, VALUE *argv, VALUE self) { FXRadioButton *arg1 = (FXRadioButton *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRadioButton, 1); FXRadioButton_setFocus(arg1); return Qnil; }
static VALUE _wrap_FXRadioButton_killFocus(int argc, VALUE *argv, VALUE self) { FXRadioButton *arg1 = (FXRadioButton *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRadioButton, 1); FXRadioButton_killFocus(arg1); return Qnil; }
static VALUE _wrap_FXRadioButton_setDefault(int argc, VALUE *argv, VALUE self) { FXRadioButton *arg1 = (FXRadioButton *) 0 ;
    FXbool arg2 = (FXbool) 1 ; if ((argc < 0) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRadioButton, 1); if (argc > 0) { arg2 = to_FXbool(argv[0]); } 
    FXRadioButton_setDefault(arg1,arg2); return Qnil; }
static VALUE _wrap_FXRadioButton_enable(int argc, VALUE *argv, VALUE self) { FXRadioButton *arg1 = (FXRadioButton *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRadioButton, 1); FXRadioButton_enable(arg1); return Qnil; }
static VALUE _wrap_FXRadioButton_disable(int argc, VALUE *argv, VALUE self) { FXRadioButton *arg1 = (FXRadioButton *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRadioButton, 1); FXRadioButton_disable(arg1); return Qnil; }
static VALUE _wrap_FXRadioButton_raiseWindow(int argc, VALUE *argv, VALUE self) { FXRadioButton *arg1 = (FXRadioButton *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRadioButton, 1); FXRadioButton_raise(arg1); return Qnil; }
static VALUE _wrap_FXRadioButton_lower(int argc, VALUE *argv, VALUE self) { FXRadioButton *arg1 = (FXRadioButton *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRadioButton, 1); FXRadioButton_lower(arg1); return Qnil; }
static VALUE _wrap_FXRadioButton_move(int argc, VALUE *argv, VALUE self) { FXRadioButton *arg1 = (FXRadioButton *) 0 ;
    FXint arg2 ; FXint arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRadioButton, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    FXRadioButton_move(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXRadioButton_position(int argc, VALUE *argv, VALUE self) { FXRadioButton *arg1 = (FXRadioButton *) 0 ;
    FXint arg2 ; FXint arg3 ; FXint arg4 ; FXint arg5 ; if ((argc < 4) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRadioButton, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    arg4 = NUM2INT(argv[2]); arg5 = NUM2INT(argv[3]); FXRadioButton_position(arg1,arg2,arg3,arg4,arg5); return Qnil; }
static VALUE _wrap_FXRadioButton_layout(int argc, VALUE *argv, VALUE self) { FXRadioButton *arg1 = (FXRadioButton *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRadioButton, 1); FXRadioButton_layout(arg1); return Qnil; }
static VALUE _wrap_FXRadioButton_recalc(int argc, VALUE *argv, VALUE self) { FXRadioButton *arg1 = (FXRadioButton *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRadioButton, 1); FXRadioButton_recalc(arg1); return Qnil; }
static VALUE _wrap_FXRadioButton_reparent(int argc, VALUE *argv, VALUE self) { FXRadioButton *arg1 = (FXRadioButton *) 0 ;
    FXComposite *arg2 = (FXComposite *) 0 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRadioButton, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXComposite, 1); FXRadioButton_reparent(arg1,arg2); return Qnil; }
static VALUE _wrap_FXRadioButton_show(int argc, VALUE *argv, VALUE self) { FXRadioButton *arg1 = (FXRadioButton *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRadioButton, 1); FXRadioButton_show(arg1); return Qnil; }
static VALUE _wrap_FXRadioButton_hide(int argc, VALUE *argv, VALUE self) { FXRadioButton *arg1 = (FXRadioButton *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRadioButton, 1); FXRadioButton_hide(arg1); return Qnil; }
static VALUE _wrap_FXRadioButton_isComposite(int argc, VALUE *argv, VALUE self) { FXRadioButton *arg1 = (FXRadioButton *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRadioButton, 1);
    result = (FXbool)FXRadioButton_isComposite((FXRadioButton const *)arg1); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXRadioButton_contains(int argc, VALUE *argv, VALUE self) { FXRadioButton *arg1 = (FXRadioButton *) 0 ;
    FXint arg2 ; FXint arg3 ; FXbool result; VALUE vresult = Qnil; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRadioButton, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    result = (FXbool)FXRadioButton_contains((FXRadioButton const *)arg1,arg2,arg3); vresult = result ? Qtrue : Qfalse;
    return vresult; }
static VALUE _wrap_FXRadioButton_doesSaveUnder(int argc, VALUE *argv, VALUE self) { FXRadioButton *arg1 = (FXRadioButton *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRadioButton, 1);
    result = (FXbool)FXRadioButton_doesSaveUnder((FXRadioButton const *)arg1); vresult = result ? Qtrue : Qfalse;
    return vresult; }
static VALUE _wrap_FXRadioButton_setBackColor(int argc, VALUE *argv, VALUE self) { FXRadioButton *arg1 = (FXRadioButton *) 0 ;
    FXColor arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRadioButton, 1); arg2 = to_FXColor(argv[0]);
    FXRadioButton_setBackColor(arg1,arg2); return Qnil; }
static VALUE _wrap_FXTabItem_onPaint(int argc, VALUE *argv, VALUE self) { FXTabItem *arg1 = (FXTabItem *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTabItem, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onPaint(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTabItem_onFocusIn(int argc, VALUE *argv, VALUE self) { FXTabItem *arg1 = (FXTabItem *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTabItem, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onFocusIn(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTabItem_onFocusOut(int argc, VALUE *argv, VALUE self) { FXTabItem *arg1 = (FXTabItem *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTabItem, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onFocusOut(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTabItem_onUngrabbed(int argc, VALUE *argv, VALUE self) { FXTabItem *arg1 = (FXTabItem *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTabItem, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onUngrabbed(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTabItem_onLeftBtnPress(int argc, VALUE *argv, VALUE self) { FXTabItem *arg1 = (FXTabItem *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTabItem, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onLeftBtnPress(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTabItem_onLeftBtnRelease(int argc, VALUE *argv, VALUE self) { FXTabItem *arg1 = (FXTabItem *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTabItem, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onLeftBtnRelease(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTabItem_onKeyPress(int argc, VALUE *argv, VALUE self) { FXTabItem *arg1 = (FXTabItem *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTabItem, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onKeyPress(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTabItem_onKeyRelease(int argc, VALUE *argv, VALUE self) { FXTabItem *arg1 = (FXTabItem *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTabItem, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onKeyRelease(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTabItem_onHotKeyPress(int argc, VALUE *argv, VALUE self) { FXTabItem *arg1 = (FXTabItem *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTabItem, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onHotKeyPress(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTabItem_onHotKeyRelease(int argc, VALUE *argv, VALUE self) { FXTabItem *arg1 = (FXTabItem *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTabItem, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onHotKeyRelease(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE _wrap_FXTabItem_allocate(VALUE self) {
#else
     static VALUE _wrap_FXTabItem_allocate(int argc, VALUE *argv, VALUE self) {
#endif
         VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_FXTabItem);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
         return vresult; }
static VALUE _wrap_new_FXTabItem(int argc, VALUE *argv, VALUE self) { FXTabBar *arg1 = (FXTabBar *) 0 ; FXString *arg2 = 0 ;
    FXIcon *arg3 = (FXIcon *) 0 ; FXuint arg4 = (FXuint) TAB_TOP_NORMAL ; FXint arg5 = (FXint) 0 ; FXint arg6 = (FXint) 0 ;
    FXint arg7 = (FXint) 0 ; FXint arg8 = (FXint) 0 ; FXint arg9 = (FXint) DEFAULT_PAD ; FXint arg10 = (FXint) DEFAULT_PAD ;
    FXint arg11 = (FXint) DEFAULT_PAD ; FXint arg12 = (FXint) DEFAULT_PAD ; FXTabItem *result; SwigValueWrapper<FXString > p2 ;
    if ((argc < 2) || (argc > 12)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXTabBar, 1); p2 = to_FXString(argv[1]); arg2 = &p2; if (argc > 2) {
        SWIG_ConvertPtr(argv[2], (void **) &arg3, SWIGTYPE_p_FXIcon, 1); }  if (argc > 3) { arg4 = NUM2UINT(argv[3]); } 
    if (argc > 4) { arg5 = NUM2INT(argv[4]); }  if (argc > 5) { arg6 = NUM2INT(argv[5]); }  if (argc > 6) {
        arg7 = NUM2INT(argv[6]); }  if (argc > 7) { arg8 = NUM2INT(argv[7]); }  if (argc > 8) { arg9 = NUM2INT(argv[8]); } 
    if (argc > 9) { arg10 = NUM2INT(argv[9]); }  if (argc > 10) { arg11 = NUM2INT(argv[10]); }  if (argc > 11) {
        arg12 = NUM2INT(argv[11]); }  {
        result = (FXTabItem *)new_FXTabItem(arg1,(FXString const &)*arg2,arg3,arg4,arg5,arg6,arg7,arg8,arg9,arg10,arg11,arg12);
        DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result); if(rb_block_given_p()){ rb_yield(self); }  }  return self; }
static VALUE _wrap_FXTabItem_getTabOrientation(int argc, VALUE *argv, VALUE self) { FXTabItem *arg1 = (FXTabItem *) 0 ;
    FXuint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTabItem, 1);
    result = (FXuint)((FXTabItem const *)arg1)->getTabOrientation(); vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXTabItem_setTabOrientation(int argc, VALUE *argv, VALUE self) { FXTabItem *arg1 = (FXTabItem *) 0 ;
    FXuint arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTabItem, 1); arg2 = NUM2UINT(argv[0]); (arg1)->setTabOrientation(arg2);
    return Qnil; }
static void
free_FXTabItem(FXTabItem *arg1) {
    delete arg1;
}
static VALUE _wrap_FXTabItem_save(int argc, VALUE *argv, VALUE self) { FXTabItem *arg1 = (FXTabItem *) 0 ; FXStream *arg2 = 0 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTabItem, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXTabItem_save((FXTabItem const *)arg1,*arg2); return Qnil; }
static VALUE _wrap_FXTabItem_load(int argc, VALUE *argv, VALUE self) { FXTabItem *arg1 = (FXTabItem *) 0 ; FXStream *arg2 = 0 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTabItem, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXTabItem_load(arg1,*arg2); return Qnil; }
static VALUE _wrap_FXTabItem_create(int argc, VALUE *argv, VALUE self) { FXTabItem *arg1 = (FXTabItem *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTabItem, 1); FXTabItem_create(arg1); return Qnil; }
static VALUE _wrap_FXTabItem_detach(int argc, VALUE *argv, VALUE self) { FXTabItem *arg1 = (FXTabItem *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTabItem, 1); FXTabItem_detach(arg1); return Qnil; }
static VALUE _wrap_FXTabItem_destroy(int argc, VALUE *argv, VALUE self) { FXTabItem *arg1 = (FXTabItem *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTabItem, 1); FXTabItem_destroy(arg1); return Qnil; }
static VALUE _wrap_FXTabItem_resize(int argc, VALUE *argv, VALUE self) { FXTabItem *arg1 = (FXTabItem *) 0 ; FXint arg2 ;
    FXint arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTabItem, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    FXTabItem_resize(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXTabItem_getDefaultWidth(int argc, VALUE *argv, VALUE self) { FXTabItem *arg1 = (FXTabItem *) 0 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTabItem, 1); result = (FXint)FXTabItem_getDefaultWidth(arg1);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTabItem_getDefaultHeight(int argc, VALUE *argv, VALUE self) { FXTabItem *arg1 = (FXTabItem *) 0 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTabItem, 1); result = (FXint)FXTabItem_getDefaultHeight(arg1);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTabItem_getWidthForHeight(int argc, VALUE *argv, VALUE self) { FXTabItem *arg1 = (FXTabItem *) 0 ;
    FXint arg2 ; FXint result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTabItem, 1); arg2 = NUM2INT(argv[0]);
    result = (FXint)FXTabItem_getWidthForHeight(arg1,arg2); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTabItem_getHeightForWidth(int argc, VALUE *argv, VALUE self) { FXTabItem *arg1 = (FXTabItem *) 0 ;
    FXint arg2 ; FXint result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTabItem, 1); arg2 = NUM2INT(argv[0]);
    result = (FXint)FXTabItem_getHeightForWidth(arg1,arg2); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTabItem_canFocus(int argc, VALUE *argv, VALUE self) { FXTabItem *arg1 = (FXTabItem *) 0 ; FXbool result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTabItem, 1);
    result = (FXbool)FXTabItem_canFocus((FXTabItem const *)arg1); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXTabItem_setFocus(int argc, VALUE *argv, VALUE self) { FXTabItem *arg1 = (FXTabItem *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTabItem, 1); FXTabItem_setFocus(arg1); return Qnil; }
static VALUE _wrap_FXTabItem_killFocus(int argc, VALUE *argv, VALUE self) { FXTabItem *arg1 = (FXTabItem *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTabItem, 1); FXTabItem_killFocus(arg1); return Qnil; }
static VALUE _wrap_FXTabItem_setDefault(int argc, VALUE *argv, VALUE self) { FXTabItem *arg1 = (FXTabItem *) 0 ;
    FXbool arg2 = (FXbool) 1 ; if ((argc < 0) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTabItem, 1); if (argc > 0) { arg2 = to_FXbool(argv[0]); } 
    FXTabItem_setDefault(arg1,arg2); return Qnil; }
static VALUE _wrap_FXTabItem_enable(int argc, VALUE *argv, VALUE self) { FXTabItem *arg1 = (FXTabItem *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTabItem, 1); FXTabItem_enable(arg1); return Qnil; }
static VALUE _wrap_FXTabItem_disable(int argc, VALUE *argv, VALUE self) { FXTabItem *arg1 = (FXTabItem *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTabItem, 1); FXTabItem_disable(arg1); return Qnil; }
static VALUE _wrap_FXTabItem_raiseWindow(int argc, VALUE *argv, VALUE self) { FXTabItem *arg1 = (FXTabItem *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTabItem, 1); FXTabItem_raise(arg1); return Qnil; }
static VALUE _wrap_FXTabItem_lower(int argc, VALUE *argv, VALUE self) { FXTabItem *arg1 = (FXTabItem *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTabItem, 1); FXTabItem_lower(arg1); return Qnil; }
static VALUE _wrap_FXTabItem_move(int argc, VALUE *argv, VALUE self) { FXTabItem *arg1 = (FXTabItem *) 0 ; FXint arg2 ;
    FXint arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTabItem, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    FXTabItem_move(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXTabItem_position(int argc, VALUE *argv, VALUE self) { FXTabItem *arg1 = (FXTabItem *) 0 ; FXint arg2 ;
    FXint arg3 ; FXint arg4 ; FXint arg5 ; if ((argc < 4) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTabItem, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    arg4 = NUM2INT(argv[2]); arg5 = NUM2INT(argv[3]); FXTabItem_position(arg1,arg2,arg3,arg4,arg5); return Qnil; }
static VALUE _wrap_FXTabItem_layout(int argc, VALUE *argv, VALUE self) { FXTabItem *arg1 = (FXTabItem *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTabItem, 1); FXTabItem_layout(arg1); return Qnil; }
static VALUE _wrap_FXTabItem_recalc(int argc, VALUE *argv, VALUE self) { FXTabItem *arg1 = (FXTabItem *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTabItem, 1); FXTabItem_recalc(arg1); return Qnil; }
static VALUE _wrap_FXTabItem_reparent(int argc, VALUE *argv, VALUE self) { FXTabItem *arg1 = (FXTabItem *) 0 ;
    FXComposite *arg2 = (FXComposite *) 0 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTabItem, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXComposite, 1); FXTabItem_reparent(arg1,arg2); return Qnil; }
static VALUE _wrap_FXTabItem_show(int argc, VALUE *argv, VALUE self) { FXTabItem *arg1 = (FXTabItem *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTabItem, 1); FXTabItem_show(arg1); return Qnil; }
static VALUE _wrap_FXTabItem_hide(int argc, VALUE *argv, VALUE self) { FXTabItem *arg1 = (FXTabItem *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTabItem, 1); FXTabItem_hide(arg1); return Qnil; }
static VALUE _wrap_FXTabItem_isComposite(int argc, VALUE *argv, VALUE self) { FXTabItem *arg1 = (FXTabItem *) 0 ; FXbool result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTabItem, 1);
    result = (FXbool)FXTabItem_isComposite((FXTabItem const *)arg1); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXTabItem_contains(int argc, VALUE *argv, VALUE self) { FXTabItem *arg1 = (FXTabItem *) 0 ; FXint arg2 ;
    FXint arg3 ; FXbool result; VALUE vresult = Qnil; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTabItem, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    result = (FXbool)FXTabItem_contains((FXTabItem const *)arg1,arg2,arg3); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXTabItem_doesSaveUnder(int argc, VALUE *argv, VALUE self) { FXTabItem *arg1 = (FXTabItem *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTabItem, 1);
    result = (FXbool)FXTabItem_doesSaveUnder((FXTabItem const *)arg1); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXTabItem_setBackColor(int argc, VALUE *argv, VALUE self) { FXTabItem *arg1 = (FXTabItem *) 0 ;
    FXColor arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTabItem, 1); arg2 = to_FXColor(argv[0]);
    FXTabItem_setBackColor(arg1,arg2); return Qnil; }
static VALUE _wrap_FXToggleButton_onPaint(int argc, VALUE *argv, VALUE self) { FXToggleButton *arg1 = (FXToggleButton *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToggleButton, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onPaint(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXToggleButton_onUpdate(int argc, VALUE *argv, VALUE self) { FXToggleButton *arg1 = (FXToggleButton *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToggleButton, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onUpdate(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXToggleButton_onEnter(int argc, VALUE *argv, VALUE self) { FXToggleButton *arg1 = (FXToggleButton *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToggleButton, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onEnter(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXToggleButton_onLeave(int argc, VALUE *argv, VALUE self) { FXToggleButton *arg1 = (FXToggleButton *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToggleButton, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onLeave(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXToggleButton_onFocusIn(int argc, VALUE *argv, VALUE self) { FXToggleButton *arg1 = (FXToggleButton *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToggleButton, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onFocusIn(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXToggleButton_onFocusOut(int argc, VALUE *argv, VALUE self) { FXToggleButton *arg1 = (FXToggleButton *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToggleButton, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onFocusOut(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXToggleButton_onUngrabbed(int argc, VALUE *argv, VALUE self) { FXToggleButton *arg1 = (FXToggleButton *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToggleButton, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onUngrabbed(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXToggleButton_onLeftBtnPress(int argc, VALUE *argv, VALUE self) {
    FXToggleButton *arg1 = (FXToggleButton *) 0 ; FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ;
    long result; VALUE vresult = Qnil; if ((argc < 3) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToggleButton, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onLeftBtnPress(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXToggleButton_onLeftBtnRelease(int argc, VALUE *argv, VALUE self) {
    FXToggleButton *arg1 = (FXToggleButton *) 0 ; FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ;
    long result; VALUE vresult = Qnil; if ((argc < 3) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToggleButton, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onLeftBtnRelease(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXToggleButton_onKeyPress(int argc, VALUE *argv, VALUE self) { FXToggleButton *arg1 = (FXToggleButton *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToggleButton, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onKeyPress(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXToggleButton_onKeyRelease(int argc, VALUE *argv, VALUE self) {
    FXToggleButton *arg1 = (FXToggleButton *) 0 ; FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ;
    long result; VALUE vresult = Qnil; if ((argc < 3) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToggleButton, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onKeyRelease(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXToggleButton_onHotKeyPress(int argc, VALUE *argv, VALUE self) {
    FXToggleButton *arg1 = (FXToggleButton *) 0 ; FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ;
    long result; VALUE vresult = Qnil; if ((argc < 3) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToggleButton, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onHotKeyPress(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXToggleButton_onHotKeyRelease(int argc, VALUE *argv, VALUE self) {
    FXToggleButton *arg1 = (FXToggleButton *) 0 ; FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ;
    long result; VALUE vresult = Qnil; if ((argc < 3) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToggleButton, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onHotKeyRelease(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXToggleButton_onCheck(int argc, VALUE *argv, VALUE self) { FXToggleButton *arg1 = (FXToggleButton *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToggleButton, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCheck(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXToggleButton_onUncheck(int argc, VALUE *argv, VALUE self) { FXToggleButton *arg1 = (FXToggleButton *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToggleButton, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onUncheck(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXToggleButton_onQueryHelp(int argc, VALUE *argv, VALUE self) { FXToggleButton *arg1 = (FXToggleButton *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToggleButton, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onQueryHelp(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXToggleButton_onQueryTip(int argc, VALUE *argv, VALUE self) { FXToggleButton *arg1 = (FXToggleButton *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToggleButton, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onQueryTip(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXToggleButton_onCmdSetValue(int argc, VALUE *argv, VALUE self) {
    FXToggleButton *arg1 = (FXToggleButton *) 0 ; FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ;
    long result; VALUE vresult = Qnil; if ((argc < 3) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToggleButton, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]);
    arg4 = reinterpret_cast<void*>(NUM2INT(argv[2])); result = (long)(arg1)->onCmdSetValue(arg2,arg3,arg4);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXToggleButton_onCmdSetIntValue(int argc, VALUE *argv, VALUE self) {
    FXToggleButton *arg1 = (FXToggleButton *) 0 ; FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ;
    long result; FXint value4 ; VALUE vresult = Qnil; if ((argc < 3) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToggleButton, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); {
        value4 = (FXint) NUM2INT(argv[2]); arg4 = static_cast<void*>(&value4); } 
    result = (long)(arg1)->onCmdSetIntValue(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXToggleButton_onCmdGetIntValue(int argc, VALUE *argv, VALUE self) {
    FXToggleButton *arg1 = (FXToggleButton *) 0 ; FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ;
    long result; VALUE vresult = Qnil; if ((argc < 3) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToggleButton, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdGetIntValue(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE _wrap_FXToggleButton_allocate(VALUE self) {
#else
     static VALUE _wrap_FXToggleButton_allocate(int argc, VALUE *argv, VALUE self) {
#endif
         VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_FXToggleButton);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
         return vresult; }
static VALUE _wrap_new_FXToggleButton(int argc, VALUE *argv, VALUE self) { FXComposite *arg1 = (FXComposite *) 0 ;
    FXString *arg2 = 0 ; FXString *arg3 = 0 ; FXIcon *arg4 = (FXIcon *) 0 ; FXIcon *arg5 = (FXIcon *) 0 ;
    FXObject *arg6 = (FXObject *) 0 ; FXSelector arg7 = (FXSelector) 0 ; FXuint arg8 = (FXuint) TOGGLEBUTTON_NORMAL ;
    FXint arg9 = (FXint) 0 ; FXint arg10 = (FXint) 0 ; FXint arg11 = (FXint) 0 ; FXint arg12 = (FXint) 0 ;
    FXint arg13 = (FXint) DEFAULT_PAD ; FXint arg14 = (FXint) DEFAULT_PAD ; FXint arg15 = (FXint) DEFAULT_PAD ;
    FXint arg16 = (FXint) DEFAULT_PAD ; FXToggleButton *result; SwigValueWrapper<FXString > p2 ;
    SwigValueWrapper<FXString > p3 ; if ((argc < 3) || (argc > 16))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXComposite, 1); p2 = to_FXString(argv[1]); arg2 = &p2;
    p3 = to_FXString(argv[2]); arg3 = &p3; if (argc > 3) { SWIG_ConvertPtr(argv[3], (void **) &arg4, SWIGTYPE_p_FXIcon, 1); } 
    if (argc > 4) { SWIG_ConvertPtr(argv[4], (void **) &arg5, SWIGTYPE_p_FXIcon, 1); }  if (argc > 5) {
        SWIG_ConvertPtr(argv[5], (void **) &arg6, SWIGTYPE_p_FXObject, 1); }  if (argc > 6) { arg7 = NUM2UINT(argv[6]); } 
    if (argc > 7) { arg8 = NUM2UINT(argv[7]); }  if (argc > 8) { arg9 = NUM2INT(argv[8]); }  if (argc > 9) {
        arg10 = NUM2INT(argv[9]); }  if (argc > 10) { arg11 = NUM2INT(argv[10]); }  if (argc > 11) { arg12 = NUM2INT(argv[11]); }
     if (argc > 12) { arg13 = NUM2INT(argv[12]); }  if (argc > 13) { arg14 = NUM2INT(argv[13]); }  if (argc > 14) {
        arg15 = NUM2INT(argv[14]); }  if (argc > 15) { arg16 = NUM2INT(argv[15]); }  {
        result = (FXToggleButton *)new_FXToggleButton(arg1,(FXString const &)*arg2,(FXString const &)*arg3,arg4,arg5,arg6,arg7,arg8,arg9,arg10,arg11,arg12,arg13,arg14,arg15,arg16);
        DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result); if(rb_block_given_p()){ rb_yield(self); }  }  return self; }
static VALUE _wrap_FXToggleButton_setAltText(int argc, VALUE *argv, VALUE self) { FXToggleButton *arg1 = (FXToggleButton *) 0 ;
    FXString *arg2 = 0 ; SwigValueWrapper<FXString > p2 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToggleButton, 1); p2 = to_FXString(argv[0]); arg2 = &p2;
    (arg1)->setAltText((FXString const &)*arg2); return Qnil; }
static VALUE _wrap_FXToggleButton_getAltText(int argc, VALUE *argv, VALUE self) { FXToggleButton *arg1 = (FXToggleButton *) 0 ;
    FXString result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToggleButton, 1); result = ((FXToggleButton const *)arg1)->getAltText();
    vresult = rb_str_new2((&result)->text()); return vresult; }
static VALUE _wrap_FXToggleButton_setAltIcon(int argc, VALUE *argv, VALUE self) { FXToggleButton *arg1 = (FXToggleButton *) 0 ;
    FXIcon *arg2 = (FXIcon *) 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToggleButton, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXIcon, 1); (arg1)->setAltIcon(arg2); return Qnil; }
static VALUE _wrap_FXToggleButton_getAltIcon(int argc, VALUE *argv, VALUE self) { FXToggleButton *arg1 = (FXToggleButton *) 0 ;
    FXIcon *result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToggleButton, 1);
    result = (FXIcon *)((FXToggleButton const *)arg1)->getAltIcon(); {
        swig_type_info *ty = SWIG_TypeDynamicCast(SWIGTYPE_p_FXIcon, (void **) &result); vresult = FXRbGetRubyObj(result, ty); }
     return vresult; }
static VALUE _wrap_FXToggleButton_setState(int argc, VALUE *argv, VALUE self) { FXToggleButton *arg1 = (FXToggleButton *) 0 ;
    FXbool arg2 = (FXbool) 1 ; if ((argc < 0) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToggleButton, 1); if (argc > 0) { arg2 = to_FXbool(argv[0]); } 
    (arg1)->setState(arg2); return Qnil; }
static VALUE _wrap_FXToggleButton_getState(int argc, VALUE *argv, VALUE self) { FXToggleButton *arg1 = (FXToggleButton *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToggleButton, 1);
    result = (FXbool)((FXToggleButton const *)arg1)->getState(); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXToggleButton_setAltHelpText(int argc, VALUE *argv, VALUE self) {
    FXToggleButton *arg1 = (FXToggleButton *) 0 ; FXString *arg2 = 0 ; SwigValueWrapper<FXString > p2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToggleButton, 1); p2 = to_FXString(argv[0]); arg2 = &p2;
    (arg1)->setAltHelpText((FXString const &)*arg2); return Qnil; }
static VALUE _wrap_FXToggleButton_getAltHelpText(int argc, VALUE *argv, VALUE self) {
    FXToggleButton *arg1 = (FXToggleButton *) 0 ; FXString result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToggleButton, 1);
    result = ((FXToggleButton const *)arg1)->getAltHelpText(); vresult = rb_str_new2((&result)->text()); return vresult; }
static VALUE _wrap_FXToggleButton_setAltTipText(int argc, VALUE *argv, VALUE self) {
    FXToggleButton *arg1 = (FXToggleButton *) 0 ; FXString *arg2 = 0 ; SwigValueWrapper<FXString > p2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToggleButton, 1); p2 = to_FXString(argv[0]); arg2 = &p2;
    (arg1)->setAltTipText((FXString const &)*arg2); return Qnil; }
static VALUE _wrap_FXToggleButton_getAltTipText(int argc, VALUE *argv, VALUE self) {
    FXToggleButton *arg1 = (FXToggleButton *) 0 ; FXString result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToggleButton, 1);
    result = ((FXToggleButton const *)arg1)->getAltTipText(); vresult = rb_str_new2((&result)->text()); return vresult; }
static VALUE _wrap_FXToggleButton_setToggleStyle(int argc, VALUE *argv, VALUE self) {
    FXToggleButton *arg1 = (FXToggleButton *) 0 ; FXuint arg2 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToggleButton, 1); arg2 = NUM2UINT(argv[0]);
    (arg1)->setToggleStyle(arg2); return Qnil; }
static VALUE _wrap_FXToggleButton_getToggleStyle(int argc, VALUE *argv, VALUE self) {
    FXToggleButton *arg1 = (FXToggleButton *) 0 ; FXuint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToggleButton, 1);
    result = (FXuint)((FXToggleButton const *)arg1)->getToggleStyle(); vresult = UINT2NUM(result); return vresult; }
static void
free_FXToggleButton(FXToggleButton *arg1) {
    delete arg1;
}
static VALUE _wrap_FXToggleButton_save(int argc, VALUE *argv, VALUE self) { FXToggleButton *arg1 = (FXToggleButton *) 0 ;
    FXStream *arg2 = 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToggleButton, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXToggleButton_save((FXToggleButton const *)arg1,*arg2); return Qnil; }
static VALUE _wrap_FXToggleButton_load(int argc, VALUE *argv, VALUE self) { FXToggleButton *arg1 = (FXToggleButton *) 0 ;
    FXStream *arg2 = 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToggleButton, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXToggleButton_load(arg1,*arg2); return Qnil; }
static VALUE _wrap_FXToggleButton_create(int argc, VALUE *argv, VALUE self) { FXToggleButton *arg1 = (FXToggleButton *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToggleButton, 1); FXToggleButton_create(arg1); return Qnil; }
static VALUE _wrap_FXToggleButton_detach(int argc, VALUE *argv, VALUE self) { FXToggleButton *arg1 = (FXToggleButton *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToggleButton, 1); FXToggleButton_detach(arg1); return Qnil; }
static VALUE _wrap_FXToggleButton_destroy(int argc, VALUE *argv, VALUE self) { FXToggleButton *arg1 = (FXToggleButton *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToggleButton, 1); FXToggleButton_destroy(arg1); return Qnil; }
static VALUE _wrap_FXToggleButton_resize(int argc, VALUE *argv, VALUE self) { FXToggleButton *arg1 = (FXToggleButton *) 0 ;
    FXint arg2 ; FXint arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToggleButton, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    FXToggleButton_resize(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXToggleButton_getDefaultWidth(int argc, VALUE *argv, VALUE self) {
    FXToggleButton *arg1 = (FXToggleButton *) 0 ; FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToggleButton, 1); result = (FXint)FXToggleButton_getDefaultWidth(arg1);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXToggleButton_getDefaultHeight(int argc, VALUE *argv, VALUE self) {
    FXToggleButton *arg1 = (FXToggleButton *) 0 ; FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToggleButton, 1); result = (FXint)FXToggleButton_getDefaultHeight(arg1);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXToggleButton_getWidthForHeight(int argc, VALUE *argv, VALUE self) {
    FXToggleButton *arg1 = (FXToggleButton *) 0 ; FXint arg2 ; FXint result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToggleButton, 1); arg2 = NUM2INT(argv[0]);
    result = (FXint)FXToggleButton_getWidthForHeight(arg1,arg2); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXToggleButton_getHeightForWidth(int argc, VALUE *argv, VALUE self) {
    FXToggleButton *arg1 = (FXToggleButton *) 0 ; FXint arg2 ; FXint result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToggleButton, 1); arg2 = NUM2INT(argv[0]);
    result = (FXint)FXToggleButton_getHeightForWidth(arg1,arg2); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXToggleButton_canFocus(int argc, VALUE *argv, VALUE self) { FXToggleButton *arg1 = (FXToggleButton *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToggleButton, 1);
    result = (FXbool)FXToggleButton_canFocus((FXToggleButton const *)arg1); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXToggleButton_setFocus(int argc, VALUE *argv, VALUE self) { FXToggleButton *arg1 = (FXToggleButton *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToggleButton, 1); FXToggleButton_setFocus(arg1); return Qnil; }
static VALUE _wrap_FXToggleButton_killFocus(int argc, VALUE *argv, VALUE self) { FXToggleButton *arg1 = (FXToggleButton *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToggleButton, 1); FXToggleButton_killFocus(arg1); return Qnil; }
static VALUE _wrap_FXToggleButton_setDefault(int argc, VALUE *argv, VALUE self) { FXToggleButton *arg1 = (FXToggleButton *) 0 ;
    FXbool arg2 = (FXbool) 1 ; if ((argc < 0) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToggleButton, 1); if (argc > 0) { arg2 = to_FXbool(argv[0]); } 
    FXToggleButton_setDefault(arg1,arg2); return Qnil; }
static VALUE _wrap_FXToggleButton_enable(int argc, VALUE *argv, VALUE self) { FXToggleButton *arg1 = (FXToggleButton *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToggleButton, 1); FXToggleButton_enable(arg1); return Qnil; }
static VALUE _wrap_FXToggleButton_disable(int argc, VALUE *argv, VALUE self) { FXToggleButton *arg1 = (FXToggleButton *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToggleButton, 1); FXToggleButton_disable(arg1); return Qnil; }
static VALUE _wrap_FXToggleButton_raiseWindow(int argc, VALUE *argv, VALUE self) { FXToggleButton *arg1 = (FXToggleButton *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToggleButton, 1); FXToggleButton_raise(arg1); return Qnil; }
static VALUE _wrap_FXToggleButton_lower(int argc, VALUE *argv, VALUE self) { FXToggleButton *arg1 = (FXToggleButton *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToggleButton, 1); FXToggleButton_lower(arg1); return Qnil; }
static VALUE _wrap_FXToggleButton_move(int argc, VALUE *argv, VALUE self) { FXToggleButton *arg1 = (FXToggleButton *) 0 ;
    FXint arg2 ; FXint arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToggleButton, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    FXToggleButton_move(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXToggleButton_position(int argc, VALUE *argv, VALUE self) { FXToggleButton *arg1 = (FXToggleButton *) 0 ;
    FXint arg2 ; FXint arg3 ; FXint arg4 ; FXint arg5 ; if ((argc < 4) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToggleButton, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    arg4 = NUM2INT(argv[2]); arg5 = NUM2INT(argv[3]); FXToggleButton_position(arg1,arg2,arg3,arg4,arg5); return Qnil; }
static VALUE _wrap_FXToggleButton_layout(int argc, VALUE *argv, VALUE self) { FXToggleButton *arg1 = (FXToggleButton *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToggleButton, 1); FXToggleButton_layout(arg1); return Qnil; }
static VALUE _wrap_FXToggleButton_recalc(int argc, VALUE *argv, VALUE self) { FXToggleButton *arg1 = (FXToggleButton *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToggleButton, 1); FXToggleButton_recalc(arg1); return Qnil; }
static VALUE _wrap_FXToggleButton_reparent(int argc, VALUE *argv, VALUE self) { FXToggleButton *arg1 = (FXToggleButton *) 0 ;
    FXComposite *arg2 = (FXComposite *) 0 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToggleButton, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXComposite, 1); FXToggleButton_reparent(arg1,arg2); return Qnil; }
static VALUE _wrap_FXToggleButton_show(int argc, VALUE *argv, VALUE self) { FXToggleButton *arg1 = (FXToggleButton *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToggleButton, 1); FXToggleButton_show(arg1); return Qnil; }
static VALUE _wrap_FXToggleButton_hide(int argc, VALUE *argv, VALUE self) { FXToggleButton *arg1 = (FXToggleButton *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToggleButton, 1); FXToggleButton_hide(arg1); return Qnil; }
static VALUE _wrap_FXToggleButton_isComposite(int argc, VALUE *argv, VALUE self) { FXToggleButton *arg1 = (FXToggleButton *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToggleButton, 1);
    result = (FXbool)FXToggleButton_isComposite((FXToggleButton const *)arg1); vresult = result ? Qtrue : Qfalse;
    return vresult; }
static VALUE _wrap_FXToggleButton_contains(int argc, VALUE *argv, VALUE self) { FXToggleButton *arg1 = (FXToggleButton *) 0 ;
    FXint arg2 ; FXint arg3 ; FXbool result; VALUE vresult = Qnil; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToggleButton, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    result = (FXbool)FXToggleButton_contains((FXToggleButton const *)arg1,arg2,arg3); vresult = result ? Qtrue : Qfalse;
    return vresult; }
static VALUE _wrap_FXToggleButton_doesSaveUnder(int argc, VALUE *argv, VALUE self) {
    FXToggleButton *arg1 = (FXToggleButton *) 0 ; FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToggleButton, 1);
    result = (FXbool)FXToggleButton_doesSaveUnder((FXToggleButton const *)arg1); vresult = result ? Qtrue : Qfalse;
    return vresult; }
static VALUE _wrap_FXToggleButton_setBackColor(int argc, VALUE *argv, VALUE self) {
    FXToggleButton *arg1 = (FXToggleButton *) 0 ; FXColor arg2 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToggleButton, 1); arg2 = to_FXColor(argv[0]);
    FXToggleButton_setBackColor(arg1,arg2); return Qnil; }
static VALUE _wrap_FXTriStateButton_onPaint(int argc, VALUE *argv, VALUE self) {
    FXTriStateButton *arg1 = (FXTriStateButton *) 0 ; FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ;
    void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil; if ((argc < 3) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTriStateButton, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onPaint(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTriStateButton_onUnknown(int argc, VALUE *argv, VALUE self) {
    FXTriStateButton *arg1 = (FXTriStateButton *) 0 ; FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ;
    void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil; if ((argc < 3) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTriStateButton, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]);
    SWIG_ConvertPtr(argv[2], (void **) &arg4, 0, 1); result = (long)(arg1)->onUnknown(arg2,arg3,arg4);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTriStateButton_onQueryHelp(int argc, VALUE *argv, VALUE self) {
    FXTriStateButton *arg1 = (FXTriStateButton *) 0 ; FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ;
    void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil; if ((argc < 3) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTriStateButton, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]);
    SWIG_ConvertPtr(argv[2], (void **) &arg4, 0, 1); result = (long)(arg1)->onQueryHelp(arg2,arg3,arg4);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTriStateButton_onQueryTip(int argc, VALUE *argv, VALUE self) {
    FXTriStateButton *arg1 = (FXTriStateButton *) 0 ; FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ;
    void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil; if ((argc < 3) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTriStateButton, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]);
    SWIG_ConvertPtr(argv[2], (void **) &arg4, 0, 1); result = (long)(arg1)->onQueryTip(arg2,arg3,arg4);
    vresult = INT2NUM(result); return vresult; }
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE _wrap_FXTriStateButton_allocate(VALUE self) {
#else
     static VALUE _wrap_FXTriStateButton_allocate(int argc, VALUE *argv, VALUE self) {
#endif
         VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_FXTriStateButton);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
         return vresult; }
static VALUE _wrap_new_FXTriStateButton(int argc, VALUE *argv, VALUE self) { FXComposite *arg1 = (FXComposite *) 0 ;
    FXString *arg2 = 0 ; FXString *arg3 = 0 ; FXString *arg4 = 0 ; FXIcon *arg5 = (FXIcon *) 0 ; FXIcon *arg6 = (FXIcon *) 0 ;
    FXIcon *arg7 = (FXIcon *) 0 ; FXObject *arg8 = (FXObject *) 0 ; FXSelector arg9 = (FXSelector) 0 ;
    FXuint arg10 = (FXuint) TOGGLEBUTTON_NORMAL ; FXint arg11 = (FXint) 0 ; FXint arg12 = (FXint) 0 ; FXint arg13 = (FXint) 0 ;
    FXint arg14 = (FXint) 0 ; FXint arg15 = (FXint) DEFAULT_PAD ; FXint arg16 = (FXint) DEFAULT_PAD ;
    FXint arg17 = (FXint) DEFAULT_PAD ; FXint arg18 = (FXint) DEFAULT_PAD ; FXTriStateButton *result;
    SwigValueWrapper<FXString > p2 ; SwigValueWrapper<FXString > p3 ; SwigValueWrapper<FXString > p4 ;
    if ((argc < 4) || (argc > 18)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXComposite, 1); p2 = to_FXString(argv[1]); arg2 = &p2;
    p3 = to_FXString(argv[2]); arg3 = &p3; p4 = to_FXString(argv[3]); arg4 = &p4; if (argc > 4) {
        SWIG_ConvertPtr(argv[4], (void **) &arg5, SWIGTYPE_p_FXIcon, 1); }  if (argc > 5) {
        SWIG_ConvertPtr(argv[5], (void **) &arg6, SWIGTYPE_p_FXIcon, 1); }  if (argc > 6) {
        SWIG_ConvertPtr(argv[6], (void **) &arg7, SWIGTYPE_p_FXIcon, 1); }  if (argc > 7) {
        SWIG_ConvertPtr(argv[7], (void **) &arg8, SWIGTYPE_p_FXObject, 1); }  if (argc > 8) { arg9 = NUM2UINT(argv[8]); } 
    if (argc > 9) { arg10 = NUM2UINT(argv[9]); }  if (argc > 10) { arg11 = NUM2INT(argv[10]); }  if (argc > 11) {
        arg12 = NUM2INT(argv[11]); }  if (argc > 12) { arg13 = NUM2INT(argv[12]); }  if (argc > 13) {
        arg14 = NUM2INT(argv[13]); }  if (argc > 14) { arg15 = NUM2INT(argv[14]); }  if (argc > 15) {
        arg16 = NUM2INT(argv[15]); }  if (argc > 16) { arg17 = NUM2INT(argv[16]); }  if (argc > 17) {
        arg18 = NUM2INT(argv[17]); }  {
        result = (FXTriStateButton *)new_FXTriStateButton(arg1,(FXString const &)*arg2,(FXString const &)*arg3,(FXString const &)*arg4,arg5,arg6,arg7,arg8,arg9,arg10,arg11,arg12,arg13,arg14,arg15,arg16,arg17,arg18);
        DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result); if(rb_block_given_p()){ rb_yield(self); }  }  return self; }
static VALUE _wrap_FXTriStateButton_setMaybeText(int argc, VALUE *argv, VALUE self) {
    FXTriStateButton *arg1 = (FXTriStateButton *) 0 ; FXString *arg2 = 0 ; SwigValueWrapper<FXString > p2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTriStateButton, 1); p2 = to_FXString(argv[0]); arg2 = &p2;
    (arg1)->setMaybeText((FXString const &)*arg2); return Qnil; }
static VALUE _wrap_FXTriStateButton_getMaybeText(int argc, VALUE *argv, VALUE self) {
    FXTriStateButton *arg1 = (FXTriStateButton *) 0 ; FXString result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTriStateButton, 1);
    result = ((FXTriStateButton const *)arg1)->getMaybeText(); vresult = rb_str_new2((&result)->text()); return vresult; }
static VALUE _wrap_FXTriStateButton_setMaybeIcon(int argc, VALUE *argv, VALUE self) {
    FXTriStateButton *arg1 = (FXTriStateButton *) 0 ; FXIcon *arg2 = (FXIcon *) 0 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTriStateButton, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXIcon, 1); (arg1)->setMaybeIcon(arg2); return Qnil; }
static VALUE _wrap_FXTriStateButton_getMaybeIcon(int argc, VALUE *argv, VALUE self) {
    FXTriStateButton *arg1 = (FXTriStateButton *) 0 ; FXIcon *result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTriStateButton, 1);
    result = (FXIcon *)((FXTriStateButton const *)arg1)->getMaybeIcon(); {
        swig_type_info *ty = SWIG_TypeDynamicCast(SWIGTYPE_p_FXIcon, (void **) &result); vresult = FXRbGetRubyObj(result, ty); }
     return vresult; }
static VALUE _wrap_FXTriStateButton_setMaybeHelpText(int argc, VALUE *argv, VALUE self) {
    FXTriStateButton *arg1 = (FXTriStateButton *) 0 ; FXString *arg2 = 0 ; SwigValueWrapper<FXString > p2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTriStateButton, 1); p2 = to_FXString(argv[0]); arg2 = &p2;
    (arg1)->setMaybeHelpText((FXString const &)*arg2); return Qnil; }
static VALUE _wrap_FXTriStateButton_getMaybeHelpText(int argc, VALUE *argv, VALUE self) {
    FXTriStateButton *arg1 = (FXTriStateButton *) 0 ; FXString result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTriStateButton, 1);
    result = ((FXTriStateButton const *)arg1)->getMaybeHelpText(); vresult = rb_str_new2((&result)->text()); return vresult; }
static VALUE _wrap_FXTriStateButton_setMaybeTipText(int argc, VALUE *argv, VALUE self) {
    FXTriStateButton *arg1 = (FXTriStateButton *) 0 ; FXString *arg2 = 0 ; SwigValueWrapper<FXString > p2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTriStateButton, 1); p2 = to_FXString(argv[0]); arg2 = &p2;
    (arg1)->setMaybeTipText((FXString const &)*arg2); return Qnil; }
static VALUE _wrap_FXTriStateButton_getMaybeTipText(int argc, VALUE *argv, VALUE self) {
    FXTriStateButton *arg1 = (FXTriStateButton *) 0 ; FXString result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTriStateButton, 1);
    result = ((FXTriStateButton const *)arg1)->getMaybeTipText(); vresult = rb_str_new2((&result)->text()); return vresult; }
static void
free_FXTriStateButton(FXTriStateButton *arg1) {
    delete arg1;
}
static VALUE _wrap_FXPicker_onMotion(int argc, VALUE *argv, VALUE self) { FXPicker *arg1 = (FXPicker *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPicker, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onMotion(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXPicker_onLeftBtnPress(int argc, VALUE *argv, VALUE self) { FXPicker *arg1 = (FXPicker *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPicker, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onLeftBtnPress(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXPicker_onLeftBtnRelease(int argc, VALUE *argv, VALUE self) { FXPicker *arg1 = (FXPicker *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPicker, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onLeftBtnRelease(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXPicker_onEnter(int argc, VALUE *argv, VALUE self) { FXPicker *arg1 = (FXPicker *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPicker, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onEnter(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXPicker_onLeave(int argc, VALUE *argv, VALUE self) { FXPicker *arg1 = (FXPicker *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPicker, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onLeave(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE _wrap_FXPicker_allocate(VALUE self) {
#else
     static VALUE _wrap_FXPicker_allocate(int argc, VALUE *argv, VALUE self) {
#endif
         VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_FXPicker);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
         return vresult; }
static VALUE _wrap_new_FXPicker(int argc, VALUE *argv, VALUE self) { FXComposite *arg1 = (FXComposite *) 0 ;
    FXString *arg2 = 0 ; FXIcon *arg3 = (FXIcon *) 0 ; FXObject *arg4 = (FXObject *) 0 ; FXSelector arg5 = (FXSelector) 0 ;
    FXuint arg6 = (FXuint) BUTTON_NORMAL ; FXint arg7 = (FXint) 0 ; FXint arg8 = (FXint) 0 ; FXint arg9 = (FXint) 0 ;
    FXint arg10 = (FXint) 0 ; FXint arg11 = (FXint) DEFAULT_PAD ; FXint arg12 = (FXint) DEFAULT_PAD ;
    FXint arg13 = (FXint) DEFAULT_PAD ; FXint arg14 = (FXint) DEFAULT_PAD ; FXPicker *result; SwigValueWrapper<FXString > p2 ;
    if ((argc < 2) || (argc > 14)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXComposite, 1); p2 = to_FXString(argv[1]); arg2 = &p2; if (argc > 2) {
        SWIG_ConvertPtr(argv[2], (void **) &arg3, SWIGTYPE_p_FXIcon, 1); }  if (argc > 3) {
        SWIG_ConvertPtr(argv[3], (void **) &arg4, SWIGTYPE_p_FXObject, 1); }  if (argc > 4) { arg5 = NUM2UINT(argv[4]); } 
    if (argc > 5) { arg6 = NUM2UINT(argv[5]); }  if (argc > 6) { arg7 = NUM2INT(argv[6]); }  if (argc > 7) {
        arg8 = NUM2INT(argv[7]); }  if (argc > 8) { arg9 = NUM2INT(argv[8]); }  if (argc > 9) { arg10 = NUM2INT(argv[9]); } 
    if (argc > 10) { arg11 = NUM2INT(argv[10]); }  if (argc > 11) { arg12 = NUM2INT(argv[11]); }  if (argc > 12) {
        arg13 = NUM2INT(argv[12]); }  if (argc > 13) { arg14 = NUM2INT(argv[13]); }  {
        result = (FXPicker *)new_FXPicker(arg1,(FXString const &)*arg2,arg3,arg4,arg5,arg6,arg7,arg8,arg9,arg10,arg11,arg12,arg13,arg14);
        DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result); if(rb_block_given_p()){ rb_yield(self); }  }  return self; }
static void
free_FXPicker(FXPicker *arg1) {
    delete arg1;
}
static VALUE _wrap_FXPicker_save(int argc, VALUE *argv, VALUE self) { FXPicker *arg1 = (FXPicker *) 0 ; FXStream *arg2 = 0 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPicker, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXPicker_save((FXPicker const *)arg1,*arg2); return Qnil; }
static VALUE _wrap_FXPicker_load(int argc, VALUE *argv, VALUE self) { FXPicker *arg1 = (FXPicker *) 0 ; FXStream *arg2 = 0 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPicker, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXPicker_load(arg1,*arg2); return Qnil; }
static VALUE _wrap_FXPicker_create(int argc, VALUE *argv, VALUE self) { FXPicker *arg1 = (FXPicker *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPicker, 1); FXPicker_create(arg1); return Qnil; }
static VALUE _wrap_FXPicker_detach(int argc, VALUE *argv, VALUE self) { FXPicker *arg1 = (FXPicker *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPicker, 1); FXPicker_detach(arg1); return Qnil; }
static VALUE _wrap_FXPicker_destroy(int argc, VALUE *argv, VALUE self) { FXPicker *arg1 = (FXPicker *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPicker, 1); FXPicker_destroy(arg1); return Qnil; }
static VALUE _wrap_FXPicker_resize(int argc, VALUE *argv, VALUE self) { FXPicker *arg1 = (FXPicker *) 0 ; FXint arg2 ;
    FXint arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPicker, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    FXPicker_resize(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXPicker_getDefaultWidth(int argc, VALUE *argv, VALUE self) { FXPicker *arg1 = (FXPicker *) 0 ; FXint result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPicker, 1); result = (FXint)FXPicker_getDefaultWidth(arg1);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXPicker_getDefaultHeight(int argc, VALUE *argv, VALUE self) { FXPicker *arg1 = (FXPicker *) 0 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPicker, 1); result = (FXint)FXPicker_getDefaultHeight(arg1);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXPicker_getWidthForHeight(int argc, VALUE *argv, VALUE self) { FXPicker *arg1 = (FXPicker *) 0 ;
    FXint arg2 ; FXint result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPicker, 1); arg2 = NUM2INT(argv[0]);
    result = (FXint)FXPicker_getWidthForHeight(arg1,arg2); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXPicker_getHeightForWidth(int argc, VALUE *argv, VALUE self) { FXPicker *arg1 = (FXPicker *) 0 ;
    FXint arg2 ; FXint result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPicker, 1); arg2 = NUM2INT(argv[0]);
    result = (FXint)FXPicker_getHeightForWidth(arg1,arg2); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXPicker_canFocus(int argc, VALUE *argv, VALUE self) { FXPicker *arg1 = (FXPicker *) 0 ; FXbool result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPicker, 1); result = (FXbool)FXPicker_canFocus((FXPicker const *)arg1);
    vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXPicker_setFocus(int argc, VALUE *argv, VALUE self) { FXPicker *arg1 = (FXPicker *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPicker, 1); FXPicker_setFocus(arg1); return Qnil; }
static VALUE _wrap_FXPicker_killFocus(int argc, VALUE *argv, VALUE self) { FXPicker *arg1 = (FXPicker *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPicker, 1); FXPicker_killFocus(arg1); return Qnil; }
static VALUE _wrap_FXPicker_setDefault(int argc, VALUE *argv, VALUE self) { FXPicker *arg1 = (FXPicker *) 0 ;
    FXbool arg2 = (FXbool) 1 ; if ((argc < 0) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPicker, 1); if (argc > 0) { arg2 = to_FXbool(argv[0]); } 
    FXPicker_setDefault(arg1,arg2); return Qnil; }
static VALUE _wrap_FXPicker_enable(int argc, VALUE *argv, VALUE self) { FXPicker *arg1 = (FXPicker *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPicker, 1); FXPicker_enable(arg1); return Qnil; }
static VALUE _wrap_FXPicker_disable(int argc, VALUE *argv, VALUE self) { FXPicker *arg1 = (FXPicker *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPicker, 1); FXPicker_disable(arg1); return Qnil; }
static VALUE _wrap_FXPicker_raiseWindow(int argc, VALUE *argv, VALUE self) { FXPicker *arg1 = (FXPicker *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPicker, 1); FXPicker_raise(arg1); return Qnil; }
static VALUE _wrap_FXPicker_lower(int argc, VALUE *argv, VALUE self) { FXPicker *arg1 = (FXPicker *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPicker, 1); FXPicker_lower(arg1); return Qnil; }
static VALUE _wrap_FXPicker_move(int argc, VALUE *argv, VALUE self) { FXPicker *arg1 = (FXPicker *) 0 ; FXint arg2 ;
    FXint arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPicker, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    FXPicker_move(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXPicker_position(int argc, VALUE *argv, VALUE self) { FXPicker *arg1 = (FXPicker *) 0 ; FXint arg2 ;
    FXint arg3 ; FXint arg4 ; FXint arg5 ; if ((argc < 4) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPicker, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    arg4 = NUM2INT(argv[2]); arg5 = NUM2INT(argv[3]); FXPicker_position(arg1,arg2,arg3,arg4,arg5); return Qnil; }
static VALUE _wrap_FXPicker_layout(int argc, VALUE *argv, VALUE self) { FXPicker *arg1 = (FXPicker *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPicker, 1); FXPicker_layout(arg1); return Qnil; }
static VALUE _wrap_FXPicker_recalc(int argc, VALUE *argv, VALUE self) { FXPicker *arg1 = (FXPicker *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPicker, 1); FXPicker_recalc(arg1); return Qnil; }
static VALUE _wrap_FXPicker_reparent(int argc, VALUE *argv, VALUE self) { FXPicker *arg1 = (FXPicker *) 0 ;
    FXComposite *arg2 = (FXComposite *) 0 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPicker, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXComposite, 1); FXPicker_reparent(arg1,arg2); return Qnil; }
static VALUE _wrap_FXPicker_show(int argc, VALUE *argv, VALUE self) { FXPicker *arg1 = (FXPicker *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPicker, 1); FXPicker_show(arg1); return Qnil; }
static VALUE _wrap_FXPicker_hide(int argc, VALUE *argv, VALUE self) { FXPicker *arg1 = (FXPicker *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPicker, 1); FXPicker_hide(arg1); return Qnil; }
static VALUE _wrap_FXPicker_isComposite(int argc, VALUE *argv, VALUE self) { FXPicker *arg1 = (FXPicker *) 0 ; FXbool result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPicker, 1);
    result = (FXbool)FXPicker_isComposite((FXPicker const *)arg1); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXPicker_contains(int argc, VALUE *argv, VALUE self) { FXPicker *arg1 = (FXPicker *) 0 ; FXint arg2 ;
    FXint arg3 ; FXbool result; VALUE vresult = Qnil; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPicker, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    result = (FXbool)FXPicker_contains((FXPicker const *)arg1,arg2,arg3); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXPicker_doesSaveUnder(int argc, VALUE *argv, VALUE self) { FXPicker *arg1 = (FXPicker *) 0 ; FXbool result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPicker, 1);
    result = (FXbool)FXPicker_doesSaveUnder((FXPicker const *)arg1); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXPicker_setBackColor(int argc, VALUE *argv, VALUE self) { FXPicker *arg1 = (FXPicker *) 0 ; FXColor arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPicker, 1); arg2 = to_FXColor(argv[0]);
    FXPicker_setBackColor(arg1,arg2); return Qnil; }

/* -------- TYPE CONVERSION AND EQUIVALENCE RULES (BEGIN) -------- */

static void *_p_FXToolBarTabTo_p_FXFrame(void *x) {
    return (void *)((FXFrame *)  ((FXToolBarTab *) x));
}
static void *_p_FXColorBarTo_p_FXFrame(void *x) {
    return (void *)((FXFrame *)  ((FXColorBar *) x));
}
static void *_p_FXBitmapFrameTo_p_FXFrame(void *x) {
    return (void *)((FXFrame *)  ((FXBitmapFrame *) x));
}
static void *_p_FXPickerTo_p_FXFrame(void *x) {
    return (void *)((FXFrame *) (FXLabel *)(FXButton *) ((FXPicker *) x));
}
static void *_p_FXDialTo_p_FXFrame(void *x) {
    return (void *)((FXFrame *)  ((FXDial *) x));
}
static void *_p_FXRulerTo_p_FXFrame(void *x) {
    return (void *)((FXFrame *)  ((FXRuler *) x));
}
static void *_p_FXArrowButtonTo_p_FXFrame(void *x) {
    return (void *)((FXFrame *)  ((FXArrowButton *) x));
}
static void *_p_FXLabelTo_p_FXFrame(void *x) {
    return (void *)((FXFrame *)  ((FXLabel *) x));
}
static void *_p_FXCheckButtonTo_p_FXFrame(void *x) {
    return (void *)((FXFrame *) (FXLabel *) ((FXCheckButton *) x));
}
static void *_p_FXMenuButtonTo_p_FXFrame(void *x) {
    return (void *)((FXFrame *) (FXLabel *) ((FXMenuButton *) x));
}
static void *_p_FXRadioButtonTo_p_FXFrame(void *x) {
    return (void *)((FXFrame *) (FXLabel *) ((FXRadioButton *) x));
}
static void *_p_FXToggleButtonTo_p_FXFrame(void *x) {
    return (void *)((FXFrame *) (FXLabel *) ((FXToggleButton *) x));
}
static void *_p_FXTriStateButtonTo_p_FXFrame(void *x) {
    return (void *)((FXFrame *) (FXLabel *)(FXToggleButton *) ((FXTriStateButton *) x));
}
static void *_p_FXColorWheelTo_p_FXFrame(void *x) {
    return (void *)((FXFrame *)  ((FXColorWheel *) x));
}
static void *_p_FXProgressBarTo_p_FXFrame(void *x) {
    return (void *)((FXFrame *)  ((FXProgressBar *) x));
}
static void *_p_FXColorWellTo_p_FXFrame(void *x) {
    return (void *)((FXFrame *)  ((FXColorWell *) x));
}
static void *_p_FXStatusLineTo_p_FXFrame(void *x) {
    return (void *)((FXFrame *)  ((FXStatusLine *) x));
}
static void *_p_FXVerticalSeparatorTo_p_FXFrame(void *x) {
    return (void *)((FXFrame *) (FXSeparator *) ((FXVerticalSeparator *) x));
}
static void *_p_FXHorizontalSeparatorTo_p_FXFrame(void *x) {
    return (void *)((FXFrame *) (FXSeparator *) ((FXHorizontalSeparator *) x));
}
static void *_p_FXSeparatorTo_p_FXFrame(void *x) {
    return (void *)((FXFrame *)  ((FXSeparator *) x));
}
static void *_p_FXButtonTo_p_FXFrame(void *x) {
    return (void *)((FXFrame *) (FXLabel *) ((FXButton *) x));
}
static void *_p_FXTextFieldTo_p_FXFrame(void *x) {
    return (void *)((FXFrame *)  ((FXTextField *) x));
}
static void *_p_FXTabItemTo_p_FXFrame(void *x) {
    return (void *)((FXFrame *) (FXLabel *) ((FXTabItem *) x));
}
static void *_p_FXHeaderTo_p_FXFrame(void *x) {
    return (void *)((FXFrame *)  ((FXHeader *) x));
}
static void *_p_FXOptionTo_p_FXFrame(void *x) {
    return (void *)((FXFrame *) (FXLabel *) ((FXOption *) x));
}
static void *_p_FXImageFrameTo_p_FXFrame(void *x) {
    return (void *)((FXFrame *)  ((FXImageFrame *) x));
}
static void *_p_FXOptionMenuTo_p_FXFrame(void *x) {
    return (void *)((FXFrame *) (FXLabel *) ((FXOptionMenu *) x));
}
static void *_p_FXSliderTo_p_FXFrame(void *x) {
    return (void *)((FXFrame *)  ((FXSlider *) x));
}
static void *_p_FXRealSliderTo_p_FXFrame(void *x) {
    return (void *)((FXFrame *)  ((FXRealSlider *) x));
}
static void *_p_FXOptionTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXFrame *)(FXLabel *) ((FXOption *) x));
}
static void *_p_FXCompositeTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *) ((FXComposite *) x));
}
static void *_p_FXTextFieldTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXFrame *) ((FXTextField *) x));
}
static void *_p_FXArrowButtonTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXFrame *) ((FXArrowButton *) x));
}
static void *_p_FXCheckButtonTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXFrame *)(FXLabel *) ((FXCheckButton *) x));
}
static void *_p_FXMenuButtonTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXFrame *)(FXLabel *) ((FXMenuButton *) x));
}
static void *_p_FXRadioButtonTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXFrame *)(FXLabel *) ((FXRadioButton *) x));
}
static void *_p_FXToggleButtonTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXFrame *)(FXLabel *) ((FXToggleButton *) x));
}
static void *_p_FXTriStateButtonTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXFrame *)(FXLabel *)(FXToggleButton *) ((FXTriStateButton *) x));
}
static void *_p_FXShellTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *) ((FXShell *) x));
}
static void *_p_FXPopupTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXShell *) ((FXPopup *) x));
}
static void *_p_FXWindowTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *) ((FXWindow *) x));
}
static void *_p_FXRootWindowTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *) ((FXRootWindow *) x));
}
static void *_p_FXTopWindowTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXShell *) ((FXTopWindow *) x));
}
static void *_p_FXMainWindowTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXShell *)(FXTopWindow *) ((FXMainWindow *) x));
}
static void *_p_FXRulerTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXFrame *) ((FXRuler *) x));
}
static void *_p_FXVerticalSeparatorTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXFrame *)(FXSeparator *) ((FXVerticalSeparator *) x));
}
static void *_p_FXHorizontalSeparatorTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXFrame *)(FXSeparator *) ((FXHorizontalSeparator *) x));
}
static void *_p_FXSeparatorTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXFrame *) ((FXSeparator *) x));
}
static void *_p_FXStatusLineTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXFrame *) ((FXStatusLine *) x));
}
static void *_p_FXTabItemTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXFrame *)(FXLabel *) ((FXTabItem *) x));
}
static void *_p_FXColorWheelTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXFrame *) ((FXColorWheel *) x));
}
static void *_p_FXBitmapFrameTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXFrame *) ((FXBitmapFrame *) x));
}
static void *_p_FXFontTo_p_FXId(void *x) {
    return (void *)((FXId *)  ((FXFont *) x));
}
static void *_p_FXImageFrameTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXFrame *) ((FXImageFrame *) x));
}
static void *_p_FXLabelTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXFrame *) ((FXLabel *) x));
}
static void *_p_FXPickerTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXFrame *)(FXLabel *)(FXButton *) ((FXPicker *) x));
}
static void *_p_FXDrawableTo_p_FXId(void *x) {
    return (void *)((FXId *)  ((FXDrawable *) x));
}
static void *_p_FXCursorTo_p_FXId(void *x) {
    return (void *)((FXId *)  ((FXCursor *) x));
}
static void *_p_FXCURCursorTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXCursor *) ((FXCURCursor *) x));
}
static void *_p_FXGIFCursorTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXCursor *) ((FXGIFCursor *) x));
}
static void *_p_FXProgressBarTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXFrame *) ((FXProgressBar *) x));
}
static void *_p_FXOptionMenuTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXFrame *)(FXLabel *) ((FXOptionMenu *) x));
}
static void *_p_FXHeaderTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXFrame *) ((FXHeader *) x));
}
static void *_p_FXColorWellTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXFrame *) ((FXColorWell *) x));
}
static void *_p_FXDialTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXFrame *) ((FXDial *) x));
}
static void *_p_FXToolBarTabTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXFrame *) ((FXToolBarTab *) x));
}
static void *_p_FXFrameTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *) ((FXFrame *) x));
}
static void *_p_FXRealSliderTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXFrame *) ((FXRealSlider *) x));
}
static void *_p_FXSliderTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXFrame *) ((FXSlider *) x));
}
static void *_p_FXVisualTo_p_FXId(void *x) {
    return (void *)((FXId *)  ((FXVisual *) x));
}
static void *_p_FXButtonTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXFrame *)(FXLabel *) ((FXButton *) x));
}
static void *_p_FXColorBarTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXFrame *) ((FXColorBar *) x));
}
static void *_p_FXOptionTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXFrame *)(FXLabel *) ((FXOption *) x));
}
static void *_p_FXSettingsTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXDict *) ((FXSettings *) x));
}
static void *_p_FXAccelTableTo_p_FXObject(void *x) {
    return (void *)((FXObject *)  ((FXAccelTable *) x));
}
static void *_p_FXCompositeTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *) ((FXComposite *) x));
}
static void *_p_FXRegistryTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXDict *)(FXSettings *) ((FXRegistry *) x));
}
static void *_p_FXTextFieldTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXFrame *) ((FXTextField *) x));
}
static void *_p_FXArrowButtonTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXFrame *) ((FXArrowButton *) x));
}
static void *_p_FXIconDictTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXDict *) ((FXIconDict *) x));
}
static void *_p_FXCheckButtonTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXFrame *)(FXLabel *) ((FXCheckButton *) x));
}
static void *_p_FXMenuButtonTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXFrame *)(FXLabel *) ((FXMenuButton *) x));
}
static void *_p_FXRadioButtonTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXFrame *)(FXLabel *) ((FXRadioButton *) x));
}
static void *_p_FXToggleButtonTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXFrame *)(FXLabel *) ((FXToggleButton *) x));
}
static void *_p_FXTriStateButtonTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXFrame *)(FXLabel *)(FXToggleButton *) ((FXTriStateButton *) x));
}
static void *_p_FXShellTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *) ((FXShell *) x));
}
static void *_p_FXPopupTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXShell *) ((FXPopup *) x));
}
static void *_p_FXRecentFilesTo_p_FXObject(void *x) {
    return (void *)((FXObject *)  ((FXRecentFiles *) x));
}
static void *_p_FXDocumentTo_p_FXObject(void *x) {
    return (void *)((FXObject *)  ((FXDocument *) x));
}
static void *_p_FXMainWindowTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXShell *)(FXTopWindow *) ((FXMainWindow *) x));
}
static void *_p_FXTopWindowTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXShell *) ((FXTopWindow *) x));
}
static void *_p_FXRootWindowTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *) ((FXRootWindow *) x));
}
static void *_p_FXWindowTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *) ((FXWindow *) x));
}
static void *_p_FXRulerTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXFrame *) ((FXRuler *) x));
}
static void *_p_FXSeparatorTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXFrame *) ((FXSeparator *) x));
}
static void *_p_FXHorizontalSeparatorTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXFrame *)(FXSeparator *) ((FXHorizontalSeparator *) x));
}
static void *_p_FXVerticalSeparatorTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXFrame *)(FXSeparator *) ((FXVerticalSeparator *) x));
}
static void *_p_FXStatusLineTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXFrame *) ((FXStatusLine *) x));
}
static void *_p_FXTabItemTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXFrame *)(FXLabel *) ((FXTabItem *) x));
}
static void *_p_FXStringDictTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXDict *) ((FXStringDict *) x));
}
static void *_p_FXColorWheelTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXFrame *) ((FXColorWheel *) x));
}
static void *_p_FXBitmapFrameTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXFrame *) ((FXBitmapFrame *) x));
}
static void *_p_FXFontTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *) ((FXFont *) x));
}
static void *_p_FXFileDictTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXDict *) ((FXFileDict *) x));
}
static void *_p_FXImageFrameTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXFrame *) ((FXImageFrame *) x));
}
static void *_p_FXLabelTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXFrame *) ((FXLabel *) x));
}
static void *_p_FXDataTargetTo_p_FXObject(void *x) {
    return (void *)((FXObject *)  ((FXDataTarget *) x));
}
static void *_p_FXDebugTargetTo_p_FXObject(void *x) {
    return (void *)((FXObject *)  ((FXDebugTarget *) x));
}
static void *_p_FXPickerTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXFrame *)(FXLabel *)(FXButton *) ((FXPicker *) x));
}
static void *_p_FXDelegatorTo_p_FXObject(void *x) {
    return (void *)((FXObject *)  ((FXDelegator *) x));
}
static void *_p_FXDrawableTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *) ((FXDrawable *) x));
}
static void *_p_FXGIFCursorTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXCursor *) ((FXGIFCursor *) x));
}
static void *_p_FXCURCursorTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXCursor *) ((FXCURCursor *) x));
}
static void *_p_FXCursorTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *) ((FXCursor *) x));
}
static void *_p_FXProgressBarTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXFrame *) ((FXProgressBar *) x));
}
static void *_p_FXOptionMenuTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXFrame *)(FXLabel *) ((FXOptionMenu *) x));
}
static void *_p_FXDictTo_p_FXObject(void *x) {
    return (void *)((FXObject *)  ((FXDict *) x));
}
static void *_p_FXHeaderTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXFrame *) ((FXHeader *) x));
}
static void *_p_FXColorWellTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXFrame *) ((FXColorWell *) x));
}
static void *_p_FXHeaderItemTo_p_FXObject(void *x) {
    return (void *)((FXObject *)  ((FXHeaderItem *) x));
}
static void *_p_FXDialTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXFrame *) ((FXDial *) x));
}
static void *_p_FXToolBarTabTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXFrame *) ((FXToolBarTab *) x));
}
static void *_p_FXIdTo_p_FXObject(void *x) {
    return (void *)((FXObject *)  ((FXId *) x));
}
static void *_p_FXFrameTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *) ((FXFrame *) x));
}
static void *_p_FXSliderTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXFrame *) ((FXSlider *) x));
}
static void *_p_FXRealSliderTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXFrame *) ((FXRealSlider *) x));
}
static void *_p_FXVisualTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *) ((FXVisual *) x));
}
static void *_p_FXButtonTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXFrame *)(FXLabel *) ((FXButton *) x));
}
static void *_p_FXColorBarTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXFrame *) ((FXColorBar *) x));
}
static void *_p_FXAppTo_p_FXObject(void *x) {
    return (void *)((FXObject *)  ((FXApp *) x));
}
static void *_p_FXTriStateButtonTo_p_FXToggleButton(void *x) {
    return (void *)((FXToggleButton *)  ((FXTriStateButton *) x));
}
static void *_p_FXOptionTo_p_FXLabel(void *x) {
    return (void *)((FXLabel *)  ((FXOption *) x));
}
static void *_p_FXButtonTo_p_FXLabel(void *x) {
    return (void *)((FXLabel *)  ((FXButton *) x));
}
static void *_p_FXTabItemTo_p_FXLabel(void *x) {
    return (void *)((FXLabel *)  ((FXTabItem *) x));
}
static void *_p_FXPickerTo_p_FXLabel(void *x) {
    return (void *)((FXLabel *) (FXButton *) ((FXPicker *) x));
}
static void *_p_FXCheckButtonTo_p_FXLabel(void *x) {
    return (void *)((FXLabel *)  ((FXCheckButton *) x));
}
static void *_p_FXMenuButtonTo_p_FXLabel(void *x) {
    return (void *)((FXLabel *)  ((FXMenuButton *) x));
}
static void *_p_FXRadioButtonTo_p_FXLabel(void *x) {
    return (void *)((FXLabel *)  ((FXRadioButton *) x));
}
static void *_p_FXToggleButtonTo_p_FXLabel(void *x) {
    return (void *)((FXLabel *)  ((FXToggleButton *) x));
}
static void *_p_FXTriStateButtonTo_p_FXLabel(void *x) {
    return (void *)((FXLabel *) (FXToggleButton *) ((FXTriStateButton *) x));
}
static void *_p_FXOptionMenuTo_p_FXLabel(void *x) {
    return (void *)((FXLabel *)  ((FXOptionMenu *) x));
}
static void *_p_FXOptionTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXFrame *)(FXLabel *) ((FXOption *) x));
}
static void *_p_FXCompositeTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *)  ((FXComposite *) x));
}
static void *_p_FXTextFieldTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXFrame *) ((FXTextField *) x));
}
static void *_p_FXToggleButtonTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXFrame *)(FXLabel *) ((FXToggleButton *) x));
}
static void *_p_FXRadioButtonTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXFrame *)(FXLabel *) ((FXRadioButton *) x));
}
static void *_p_FXMenuButtonTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXFrame *)(FXLabel *) ((FXMenuButton *) x));
}
static void *_p_FXCheckButtonTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXFrame *)(FXLabel *) ((FXCheckButton *) x));
}
static void *_p_FXArrowButtonTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXFrame *) ((FXArrowButton *) x));
}
static void *_p_FXTriStateButtonTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXFrame *)(FXLabel *)(FXToggleButton *) ((FXTriStateButton *) x));
}
static void *_p_FXShellTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *) ((FXShell *) x));
}
static void *_p_FXPopupTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXShell *) ((FXPopup *) x));
}
static void *_p_FXRootWindowTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *) ((FXRootWindow *) x));
}
static void *_p_FXTopWindowTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXShell *) ((FXTopWindow *) x));
}
static void *_p_FXMainWindowTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXShell *)(FXTopWindow *) ((FXMainWindow *) x));
}
static void *_p_FXRulerTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXFrame *) ((FXRuler *) x));
}
static void *_p_FXVerticalSeparatorTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXFrame *)(FXSeparator *) ((FXVerticalSeparator *) x));
}
static void *_p_FXHorizontalSeparatorTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXFrame *)(FXSeparator *) ((FXHorizontalSeparator *) x));
}
static void *_p_FXSeparatorTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXFrame *) ((FXSeparator *) x));
}
static void *_p_FXStatusLineTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXFrame *) ((FXStatusLine *) x));
}
static void *_p_FXTabItemTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXFrame *)(FXLabel *) ((FXTabItem *) x));
}
static void *_p_FXColorWheelTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXFrame *) ((FXColorWheel *) x));
}
static void *_p_FXBitmapFrameTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXFrame *) ((FXBitmapFrame *) x));
}
static void *_p_FXImageFrameTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXFrame *) ((FXImageFrame *) x));
}
static void *_p_FXLabelTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXFrame *) ((FXLabel *) x));
}
static void *_p_FXPickerTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXFrame *)(FXLabel *)(FXButton *) ((FXPicker *) x));
}
static void *_p_FXOptionMenuTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXFrame *)(FXLabel *) ((FXOptionMenu *) x));
}
static void *_p_FXProgressBarTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXFrame *) ((FXProgressBar *) x));
}
static void *_p_FXHeaderTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXFrame *) ((FXHeader *) x));
}
static void *_p_FXColorWellTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXFrame *) ((FXColorWell *) x));
}
static void *_p_FXDialTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXFrame *) ((FXDial *) x));
}
static void *_p_FXToolBarTabTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXFrame *) ((FXToolBarTab *) x));
}
static void *_p_FXFrameTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *)  ((FXFrame *) x));
}
static void *_p_FXRealSliderTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXFrame *) ((FXRealSlider *) x));
}
static void *_p_FXSliderTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXFrame *) ((FXSlider *) x));
}
static void *_p_FXButtonTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXFrame *)(FXLabel *) ((FXButton *) x));
}
static void *_p_FXColorBarTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXFrame *) ((FXColorBar *) x));
}
static void *_p_FXShellTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *)  ((FXShell *) x));
}
static void *_p_FXRootWindowTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *)  ((FXRootWindow *) x));
}
static void *_p_FXPopupTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXShell *) ((FXPopup *) x));
}
static void *_p_FXTopWindowTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXShell *) ((FXTopWindow *) x));
}
static void *_p_FXMainWindowTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXShell *)(FXTopWindow *) ((FXMainWindow *) x));
}
static void *_p_FXPickerTo_p_FXButton(void *x) {
    return (void *)((FXButton *)  ((FXPicker *) x));
}
static void *_p_FXFileStreamTo_p_FXStream(void *x) {
    return (void *)((FXStream *)  ((FXFileStream *) x));
}
static void *_p_FXMemoryStreamTo_p_FXStream(void *x) {
    return (void *)((FXStream *)  ((FXMemoryStream *) x));
}
static void *_p_FXOptionTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXFrame *)(FXLabel *) ((FXOption *) x));
}
static void *_p_FXCompositeTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *) ((FXComposite *) x));
}
static void *_p_FXTextFieldTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXFrame *) ((FXTextField *) x));
}
static void *_p_FXRadioButtonTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXFrame *)(FXLabel *) ((FXRadioButton *) x));
}
static void *_p_FXMenuButtonTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXFrame *)(FXLabel *) ((FXMenuButton *) x));
}
static void *_p_FXCheckButtonTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXFrame *)(FXLabel *) ((FXCheckButton *) x));
}
static void *_p_FXArrowButtonTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXFrame *) ((FXArrowButton *) x));
}
static void *_p_FXToggleButtonTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXFrame *)(FXLabel *) ((FXToggleButton *) x));
}
static void *_p_FXTriStateButtonTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXFrame *)(FXLabel *)(FXToggleButton *) ((FXTriStateButton *) x));
}
static void *_p_FXShellTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *) ((FXShell *) x));
}
static void *_p_FXPopupTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXShell *) ((FXPopup *) x));
}
static void *_p_FXWindowTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *)  ((FXWindow *) x));
}
static void *_p_FXRootWindowTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *) ((FXRootWindow *) x));
}
static void *_p_FXTopWindowTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXShell *) ((FXTopWindow *) x));
}
static void *_p_FXMainWindowTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXShell *)(FXTopWindow *) ((FXMainWindow *) x));
}
static void *_p_FXRulerTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXFrame *) ((FXRuler *) x));
}
static void *_p_FXVerticalSeparatorTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXFrame *)(FXSeparator *) ((FXVerticalSeparator *) x));
}
static void *_p_FXHorizontalSeparatorTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXFrame *)(FXSeparator *) ((FXHorizontalSeparator *) x));
}
static void *_p_FXSeparatorTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXFrame *) ((FXSeparator *) x));
}
static void *_p_FXStatusLineTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXFrame *) ((FXStatusLine *) x));
}
static void *_p_FXTabItemTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXFrame *)(FXLabel *) ((FXTabItem *) x));
}
static void *_p_FXColorWheelTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXFrame *) ((FXColorWheel *) x));
}
static void *_p_FXBitmapFrameTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXFrame *) ((FXBitmapFrame *) x));
}
static void *_p_FXImageFrameTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXFrame *) ((FXImageFrame *) x));
}
static void *_p_FXLabelTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXFrame *) ((FXLabel *) x));
}
static void *_p_FXPickerTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXFrame *)(FXLabel *)(FXButton *) ((FXPicker *) x));
}
static void *_p_FXOptionMenuTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXFrame *)(FXLabel *) ((FXOptionMenu *) x));
}
static void *_p_FXProgressBarTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXFrame *) ((FXProgressBar *) x));
}
static void *_p_FXHeaderTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXFrame *) ((FXHeader *) x));
}
static void *_p_FXColorWellTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXFrame *) ((FXColorWell *) x));
}
static void *_p_FXDialTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXFrame *) ((FXDial *) x));
}
static void *_p_FXToolBarTabTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXFrame *) ((FXToolBarTab *) x));
}
static void *_p_FXFrameTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *) ((FXFrame *) x));
}
static void *_p_FXRealSliderTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXFrame *) ((FXRealSlider *) x));
}
static void *_p_FXSliderTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXFrame *) ((FXSlider *) x));
}
static void *_p_FXButtonTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXFrame *)(FXLabel *) ((FXButton *) x));
}
static void *_p_FXColorBarTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXFrame *) ((FXColorBar *) x));
}
static swig_type_info _swigt__p_FXFrame[] = {{"_p_FXFrame", 0, "FXFrame *", 0, 0, 0, 0},{"_p_FXToolBarTab", _p_FXToolBarTabTo_p_FXFrame, 0, 0, 0, 0, 0},{"_p_FXFrame", 0, 0, 0, 0, 0, 0},{"_p_FXColorBar", _p_FXColorBarTo_p_FXFrame, 0, 0, 0, 0, 0},{"_p_FXBitmapFrame", _p_FXBitmapFrameTo_p_FXFrame, 0, 0, 0, 0, 0},{"_p_FXPicker", _p_FXPickerTo_p_FXFrame, 0, 0, 0, 0, 0},{"_p_FXRuler", _p_FXRulerTo_p_FXFrame, 0, 0, 0, 0, 0},{"_p_FXArrowButton", _p_FXArrowButtonTo_p_FXFrame, 0, 0, 0, 0, 0},{"_p_FXCheckButton", _p_FXCheckButtonTo_p_FXFrame, 0, 0, 0, 0, 0},{"_p_FXMenuButton", _p_FXMenuButtonTo_p_FXFrame, 0, 0, 0, 0, 0},{"_p_FXRadioButton", _p_FXRadioButtonTo_p_FXFrame, 0, 0, 0, 0, 0},{"_p_FXToggleButton", _p_FXToggleButtonTo_p_FXFrame, 0, 0, 0, 0, 0},{"_p_FXTriStateButton", _p_FXTriStateButtonTo_p_FXFrame, 0, 0, 0, 0, 0},{"_p_FXLabel", _p_FXLabelTo_p_FXFrame, 0, 0, 0, 0, 0},{"_p_FXColorWheel", _p_FXColorWheelTo_p_FXFrame, 0, 0, 0, 0, 0},{"_p_FXProgressBar", _p_FXProgressBarTo_p_FXFrame, 0, 0, 0, 0, 0},{"_p_FXColorWell", _p_FXColorWellTo_p_FXFrame, 0, 0, 0, 0, 0},{"_p_FXStatusLine", _p_FXStatusLineTo_p_FXFrame, 0, 0, 0, 0, 0},{"_p_FXButton", _p_FXButtonTo_p_FXFrame, 0, 0, 0, 0, 0},{"_p_FXVerticalSeparator", _p_FXVerticalSeparatorTo_p_FXFrame, 0, 0, 0, 0, 0},{"_p_FXHorizontalSeparator", _p_FXHorizontalSeparatorTo_p_FXFrame, 0, 0, 0, 0, 0},{"_p_FXSeparator", _p_FXSeparatorTo_p_FXFrame, 0, 0, 0, 0, 0},{"_p_FXTextField", _p_FXTextFieldTo_p_FXFrame, 0, 0, 0, 0, 0},{"_p_FXTabItem", _p_FXTabItemTo_p_FXFrame, 0, 0, 0, 0, 0},{"_p_FXOption", _p_FXOptionTo_p_FXFrame, 0, 0, 0, 0, 0},{"_p_FXHeader", _p_FXHeaderTo_p_FXFrame, 0, 0, 0, 0, 0},{"_p_FXOptionMenu", _p_FXOptionMenuTo_p_FXFrame, 0, 0, 0, 0, 0},{"_p_FXImageFrame", _p_FXImageFrameTo_p_FXFrame, 0, 0, 0, 0, 0},{"_p_FXSlider", _p_FXSliderTo_p_FXFrame, 0, 0, 0, 0, 0},{"_p_FXRealSlider", _p_FXRealSliderTo_p_FXFrame, 0, 0, 0, 0, 0},{"_p_FXDial", _p_FXDialTo_p_FXFrame, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXObject[] = {{"_p_FXObject", 0, "FXObject *", 0, 0, 0, 0},{"_p_FXDict", _p_FXDictTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXOption", _p_FXOptionTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXDial", _p_FXDialTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXSettings", _p_FXSettingsTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXAccelTable", _p_FXAccelTableTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXComposite", _p_FXCompositeTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXRegistry", _p_FXRegistryTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXTextField", _p_FXTextFieldTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXId", _p_FXIdTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXTriStateButton", _p_FXTriStateButtonTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXToggleButton", _p_FXToggleButtonTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXRadioButton", _p_FXRadioButtonTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXMenuButton", _p_FXMenuButtonTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXCheckButton", _p_FXCheckButtonTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXArrowButton", _p_FXArrowButtonTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXIconDict", _p_FXIconDictTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXShell", _p_FXShellTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXPopup", _p_FXPopupTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXWindow", _p_FXWindowTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXRootWindow", _p_FXRootWindowTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXTopWindow", _p_FXTopWindowTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXMainWindow", _p_FXMainWindowTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXRuler", _p_FXRulerTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXRecentFiles", _p_FXRecentFilesTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXDocument", _p_FXDocumentTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXVerticalSeparator", _p_FXVerticalSeparatorTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXHorizontalSeparator", _p_FXHorizontalSeparatorTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXSeparator", _p_FXSeparatorTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXStatusLine", _p_FXStatusLineTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXTabItem", _p_FXTabItemTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXObject", 0, 0, 0, 0, 0, 0},{"_p_FXStringDict", _p_FXStringDictTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXColorWheel", _p_FXColorWheelTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXBitmapFrame", _p_FXBitmapFrameTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXImageFrame", _p_FXImageFrameTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXLabel", _p_FXLabelTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXFileDict", _p_FXFileDictTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXPicker", _p_FXPickerTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXDataTarget", _p_FXDataTargetTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXDebugTarget", _p_FXDebugTargetTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXOptionMenu", _p_FXOptionMenuTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXProgressBar", _p_FXProgressBarTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXGIFCursor", _p_FXGIFCursorTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXCURCursor", _p_FXCURCursorTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXCursor", _p_FXCursorTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXDrawable", _p_FXDrawableTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXDelegator", _p_FXDelegatorTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXHeader", _p_FXHeaderTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXApp", _p_FXAppTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXColorWell", _p_FXColorWellTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXHeaderItem", _p_FXHeaderItemTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXToolBarTab", _p_FXToolBarTabTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXFrame", _p_FXFrameTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXFont", _p_FXFontTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXSlider", _p_FXSliderTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXRealSlider", _p_FXRealSliderTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXButton", _p_FXButtonTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXVisual", _p_FXVisualTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXColorBar", _p_FXColorBarTo_p_FXObject, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXPopup[] = {{"_p_FXPopup", 0, "FXPopup *", 0, 0, 0, 0},{"_p_FXPopup", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXPicker[] = {{"_p_FXPicker", 0, "FXPicker *", 0, 0, 0, 0},{"_p_FXPicker", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXMenuButton[] = {{"_p_FXMenuButton", 0, "FXMenuButton *", 0, 0, 0, 0},{"_p_FXMenuButton", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXCheckButton[] = {{"_p_FXCheckButton", 0, "FXCheckButton *", 0, 0, 0, 0},{"_p_FXCheckButton", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXToggleButton[] = {{"_p_FXToggleButton", 0, "FXToggleButton *", 0, 0, 0, 0},{"_p_FXToggleButton", 0, 0, 0, 0, 0, 0},{"_p_FXTriStateButton", _p_FXTriStateButtonTo_p_FXToggleButton, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXLabel[] = {{"_p_FXLabel", 0, "FXLabel *", 0, 0, 0, 0},{"_p_FXOption", _p_FXOptionTo_p_FXLabel, 0, 0, 0, 0, 0},{"_p_FXLabel", 0, 0, 0, 0, 0, 0},{"_p_FXButton", _p_FXButtonTo_p_FXLabel, 0, 0, 0, 0, 0},{"_p_FXPicker", _p_FXPickerTo_p_FXLabel, 0, 0, 0, 0, 0},{"_p_FXTabItem", _p_FXTabItemTo_p_FXLabel, 0, 0, 0, 0, 0},{"_p_FXCheckButton", _p_FXCheckButtonTo_p_FXLabel, 0, 0, 0, 0, 0},{"_p_FXMenuButton", _p_FXMenuButtonTo_p_FXLabel, 0, 0, 0, 0, 0},{"_p_FXRadioButton", _p_FXRadioButtonTo_p_FXLabel, 0, 0, 0, 0, 0},{"_p_FXToggleButton", _p_FXToggleButtonTo_p_FXLabel, 0, 0, 0, 0, 0},{"_p_FXTriStateButton", _p_FXTriStateButtonTo_p_FXLabel, 0, 0, 0, 0, 0},{"_p_FXOptionMenu", _p_FXOptionMenuTo_p_FXLabel, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXWindow[] = {{"_p_FXWindow", 0, "FXWindow *", 0, 0, 0, 0},{"_p_FXOption", _p_FXOptionTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXDial", _p_FXDialTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXComposite", _p_FXCompositeTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXTextField", _p_FXTextFieldTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXArrowButton", _p_FXArrowButtonTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXCheckButton", _p_FXCheckButtonTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXToggleButton", _p_FXToggleButtonTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXTriStateButton", _p_FXTriStateButtonTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXRadioButton", _p_FXRadioButtonTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXMenuButton", _p_FXMenuButtonTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXShell", _p_FXShellTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXPopup", _p_FXPopupTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXWindow", 0, 0, 0, 0, 0, 0},{"_p_FXRootWindow", _p_FXRootWindowTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXTopWindow", _p_FXTopWindowTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXMainWindow", _p_FXMainWindowTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXRuler", _p_FXRulerTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXVerticalSeparator", _p_FXVerticalSeparatorTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXHorizontalSeparator", _p_FXHorizontalSeparatorTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXSeparator", _p_FXSeparatorTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXStatusLine", _p_FXStatusLineTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXTabItem", _p_FXTabItemTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXColorWheel", _p_FXColorWheelTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXBitmapFrame", _p_FXBitmapFrameTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXImageFrame", _p_FXImageFrameTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXLabel", _p_FXLabelTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXPicker", _p_FXPickerTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXOptionMenu", _p_FXOptionMenuTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXProgressBar", _p_FXProgressBarTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXHeader", _p_FXHeaderTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXColorWell", _p_FXColorWellTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXToolBarTab", _p_FXToolBarTabTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXFrame", _p_FXFrameTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXSlider", _p_FXSliderTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXRealSlider", _p_FXRealSliderTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXButton", _p_FXButtonTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXColorBar", _p_FXColorBarTo_p_FXWindow, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXComposite[] = {{"_p_FXComposite", 0, "FXComposite *", 0, 0, 0, 0},{"_p_FXComposite", 0, 0, 0, 0, 0, 0},{"_p_FXShell", _p_FXShellTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXRootWindow", _p_FXRootWindowTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXPopup", _p_FXPopupTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXTopWindow", _p_FXTopWindowTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXMainWindow", _p_FXMainWindowTo_p_FXComposite, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXRadioButton[] = {{"_p_FXRadioButton", 0, "FXRadioButton *", 0, 0, 0, 0},{"_p_FXRadioButton", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXTriStateButton[] = {{"_p_FXTriStateButton", 0, "FXTriStateButton *", 0, 0, 0, 0},{"_p_FXTriStateButton", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXFont[] = {{"_p_FXFont", 0, "FXFont *", 0, 0, 0, 0},{"_p_FXFont", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXId[] = {{"_p_FXId", 0, "FXId *", 0, 0, 0, 0},{"_p_FXOption", _p_FXOptionTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXDial", _p_FXDialTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXComposite", _p_FXCompositeTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXTextField", _p_FXTextFieldTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXId", 0, 0, 0, 0, 0, 0},{"_p_FXTriStateButton", _p_FXTriStateButtonTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXToggleButton", _p_FXToggleButtonTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXArrowButton", _p_FXArrowButtonTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXCheckButton", _p_FXCheckButtonTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXMenuButton", _p_FXMenuButtonTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXRadioButton", _p_FXRadioButtonTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXShell", _p_FXShellTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXPopup", _p_FXPopupTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXWindow", _p_FXWindowTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXRootWindow", _p_FXRootWindowTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXTopWindow", _p_FXTopWindowTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXMainWindow", _p_FXMainWindowTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXRuler", _p_FXRulerTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXVerticalSeparator", _p_FXVerticalSeparatorTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXHorizontalSeparator", _p_FXHorizontalSeparatorTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXSeparator", _p_FXSeparatorTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXStatusLine", _p_FXStatusLineTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXTabItem", _p_FXTabItemTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXColorWheel", _p_FXColorWheelTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXBitmapFrame", _p_FXBitmapFrameTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXImageFrame", _p_FXImageFrameTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXLabel", _p_FXLabelTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXPicker", _p_FXPickerTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXOptionMenu", _p_FXOptionMenuTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXProgressBar", _p_FXProgressBarTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXGIFCursor", _p_FXGIFCursorTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXCURCursor", _p_FXCURCursorTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXCursor", _p_FXCursorTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXDrawable", _p_FXDrawableTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXHeader", _p_FXHeaderTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXColorWell", _p_FXColorWellTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXToolBarTab", _p_FXToolBarTabTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXFrame", _p_FXFrameTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXFont", _p_FXFontTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXSlider", _p_FXSliderTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXRealSlider", _p_FXRealSliderTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXButton", _p_FXButtonTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXVisual", _p_FXVisualTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXColorBar", _p_FXColorBarTo_p_FXId, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXTabBar[] = {{"_p_FXTabBar", 0, "FXTabBar *", 0, 0, 0, 0},{"_p_FXTabBar", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXButton[] = {{"_p_FXButton", 0, "FXButton *", 0, 0, 0, 0},{"_p_FXButton", 0, 0, 0, 0, 0, 0},{"_p_FXPicker", _p_FXPickerTo_p_FXButton, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXStream[] = {{"_p_FXStream", 0, "FXStream *", 0, 0, 0, 0},{"_p_FXFileStream", _p_FXFileStreamTo_p_FXStream, 0, 0, 0, 0, 0},{"_p_FXMemoryStream", _p_FXMemoryStreamTo_p_FXStream, 0, 0, 0, 0, 0},{"_p_FXStream", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXDrawable[] = {{"_p_FXDrawable", 0, "FXDrawable *", 0, 0, 0, 0},{"_p_FXOption", _p_FXOptionTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXDial", _p_FXDialTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXComposite", _p_FXCompositeTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXTextField", _p_FXTextFieldTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXTriStateButton", _p_FXTriStateButtonTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXToggleButton", _p_FXToggleButtonTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXRadioButton", _p_FXRadioButtonTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXMenuButton", _p_FXMenuButtonTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXCheckButton", _p_FXCheckButtonTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXArrowButton", _p_FXArrowButtonTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXShell", _p_FXShellTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXPopup", _p_FXPopupTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXWindow", _p_FXWindowTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXRootWindow", _p_FXRootWindowTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXTopWindow", _p_FXTopWindowTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXMainWindow", _p_FXMainWindowTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXRuler", _p_FXRulerTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXVerticalSeparator", _p_FXVerticalSeparatorTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXHorizontalSeparator", _p_FXHorizontalSeparatorTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXSeparator", _p_FXSeparatorTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXStatusLine", _p_FXStatusLineTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXTabItem", _p_FXTabItemTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXColorWheel", _p_FXColorWheelTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXBitmapFrame", _p_FXBitmapFrameTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXImageFrame", _p_FXImageFrameTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXLabel", _p_FXLabelTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXPicker", _p_FXPickerTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXOptionMenu", _p_FXOptionMenuTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXDrawable", 0, 0, 0, 0, 0, 0},{"_p_FXProgressBar", _p_FXProgressBarTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXHeader", _p_FXHeaderTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXColorWell", _p_FXColorWellTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXToolBarTab", _p_FXToolBarTabTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXFrame", _p_FXFrameTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXSlider", _p_FXSliderTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXRealSlider", _p_FXRealSliderTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXButton", _p_FXButtonTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXColorBar", _p_FXColorBarTo_p_FXDrawable, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXTabItem[] = {{"_p_FXTabItem", 0, "FXTabItem *", 0, 0, 0, 0},{"_p_FXTabItem", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXIcon[] = {{"_p_FXIcon", 0, "FXIcon *", 0, 0, 0, 0},{"_p_FXIcon", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXOption[] = {{"_p_FXOption", 0, "FXOption *", 0, 0, 0, 0},{"_p_FXOption", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXOptionMenu[] = {{"_p_FXOptionMenu", 0, "FXOptionMenu *", 0, 0, 0, 0},{"_p_FXOptionMenu", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};

static swig_type_info *swig_types_initial[] = {
_swigt__p_FXFrame, 
_swigt__p_FXObject, 
_swigt__p_FXPopup, 
_swigt__p_FXPicker, 
_swigt__p_FXMenuButton, 
_swigt__p_FXCheckButton, 
_swigt__p_FXToggleButton, 
_swigt__p_FXLabel, 
_swigt__p_FXWindow, 
_swigt__p_FXComposite, 
_swigt__p_FXRadioButton, 
_swigt__p_FXTriStateButton, 
_swigt__p_FXFont, 
_swigt__p_FXId, 
_swigt__p_FXTabBar, 
_swigt__p_FXButton, 
_swigt__p_FXStream, 
_swigt__p_FXDrawable, 
_swigt__p_FXTabItem, 
_swigt__p_FXIcon, 
_swigt__p_FXOption, 
_swigt__p_FXOptionMenu, 
0
};


/* -------- TYPE CONVERSION AND EQUIVALENCE RULES (END) -------- */


#ifdef __cplusplus
extern "C"
#endif
SWIGEXPORT(void) Init_label(void) {
    int i;
    
    SWIG_InitRuntime();
    
    for (i = 0; swig_types_initial[i]; i++) {
        swig_types[i] = SWIG_TypeRegister(swig_types_initial[i]);
        SWIG_define_class(swig_types[i]);
    }
    
    rb_define_const(mFox,"ICON_UNDER_TEXT", INT2NUM(ICON_UNDER_TEXT));
    rb_define_const(mFox,"ICON_AFTER_TEXT", INT2NUM(ICON_AFTER_TEXT));
    rb_define_const(mFox,"ICON_BEFORE_TEXT", INT2NUM(ICON_BEFORE_TEXT));
    rb_define_const(mFox,"ICON_ABOVE_TEXT", INT2NUM(ICON_ABOVE_TEXT));
    rb_define_const(mFox,"ICON_BELOW_TEXT", INT2NUM(ICON_BELOW_TEXT));
    rb_define_const(mFox,"TEXT_OVER_ICON", INT2NUM(TEXT_OVER_ICON));
    rb_define_const(mFox,"TEXT_AFTER_ICON", INT2NUM(TEXT_AFTER_ICON));
    rb_define_const(mFox,"TEXT_BEFORE_ICON", INT2NUM(TEXT_BEFORE_ICON));
    rb_define_const(mFox,"TEXT_ABOVE_ICON", INT2NUM(TEXT_ABOVE_ICON));
    rb_define_const(mFox,"TEXT_BELOW_ICON", INT2NUM(TEXT_BELOW_ICON));
    rb_define_const(mFox,"LABEL_NORMAL", INT2NUM(LABEL_NORMAL));
    
    cFXLabel.klass = rb_define_class_under(mFox, "FXLabel", ((swig_class *) SWIGTYPE_p_FXFrame->clientdata)->klass);
    SWIG_TypeClientData(SWIGTYPE_p_FXLabel, (void *) &cFXLabel);
    rb_define_alloc_func(cFXLabel.klass, _wrap_FXLabel_allocate);
    rb_define_method(cFXLabel.klass, "initialize", VALUEFUNC(_wrap_new_FXLabel), -1);
    rb_define_method(cFXLabel.klass, "onPaint", VALUEFUNC(_wrap_FXLabel_onPaint), -1);
    rb_define_method(cFXLabel.klass, "onHotKeyPress", VALUEFUNC(_wrap_FXLabel_onHotKeyPress), -1);
    rb_define_method(cFXLabel.klass, "onHotKeyRelease", VALUEFUNC(_wrap_FXLabel_onHotKeyRelease), -1);
    rb_define_method(cFXLabel.klass, "onCmdSetValue", VALUEFUNC(_wrap_FXLabel_onCmdSetValue), -1);
    rb_define_method(cFXLabel.klass, "onCmdSetStringValue", VALUEFUNC(_wrap_FXLabel_onCmdSetStringValue), -1);
    rb_define_method(cFXLabel.klass, "onCmdGetStringValue", VALUEFUNC(_wrap_FXLabel_onCmdGetStringValue), -1);
    rb_define_method(cFXLabel.klass, "onCmdSetIconValue", VALUEFUNC(_wrap_FXLabel_onCmdSetIconValue), -1);
    rb_define_method(cFXLabel.klass, "onCmdGetIconValue", VALUEFUNC(_wrap_FXLabel_onCmdGetIconValue), -1);
    rb_define_method(cFXLabel.klass, "onCmdSetHelp", VALUEFUNC(_wrap_FXLabel_onCmdSetHelp), -1);
    rb_define_method(cFXLabel.klass, "onCmdGetHelp", VALUEFUNC(_wrap_FXLabel_onCmdGetHelp), -1);
    rb_define_method(cFXLabel.klass, "onCmdSetTip", VALUEFUNC(_wrap_FXLabel_onCmdSetTip), -1);
    rb_define_method(cFXLabel.klass, "onCmdGetTip", VALUEFUNC(_wrap_FXLabel_onCmdGetTip), -1);
    rb_define_method(cFXLabel.klass, "onQueryHelp", VALUEFUNC(_wrap_FXLabel_onQueryHelp), -1);
    rb_define_method(cFXLabel.klass, "onQueryTip", VALUEFUNC(_wrap_FXLabel_onQueryTip), -1);
    rb_define_method(cFXLabel.klass, "setText", VALUEFUNC(_wrap_FXLabel_setText), -1);
    rb_define_method(cFXLabel.klass, "getText", VALUEFUNC(_wrap_FXLabel_getText), -1);
    rb_define_method(cFXLabel.klass, "setIcon", VALUEFUNC(_wrap_FXLabel_setIcon), -1);
    rb_define_method(cFXLabel.klass, "getIcon", VALUEFUNC(_wrap_FXLabel_getIcon), -1);
    rb_define_method(cFXLabel.klass, "setFont", VALUEFUNC(_wrap_FXLabel_setFont), -1);
    rb_define_method(cFXLabel.klass, "getFont", VALUEFUNC(_wrap_FXLabel_getFont), -1);
    rb_define_method(cFXLabel.klass, "getTextColor", VALUEFUNC(_wrap_FXLabel_getTextColor), -1);
    rb_define_method(cFXLabel.klass, "setTextColor", VALUEFUNC(_wrap_FXLabel_setTextColor), -1);
    rb_define_method(cFXLabel.klass, "setJustify", VALUEFUNC(_wrap_FXLabel_setJustify), -1);
    rb_define_method(cFXLabel.klass, "getJustify", VALUEFUNC(_wrap_FXLabel_getJustify), -1);
    rb_define_method(cFXLabel.klass, "setIconPosition", VALUEFUNC(_wrap_FXLabel_setIconPosition), -1);
    rb_define_method(cFXLabel.klass, "getIconPosition", VALUEFUNC(_wrap_FXLabel_getIconPosition), -1);
    rb_define_method(cFXLabel.klass, "setHelpText", VALUEFUNC(_wrap_FXLabel_setHelpText), -1);
    rb_define_method(cFXLabel.klass, "getHelpText", VALUEFUNC(_wrap_FXLabel_getHelpText), -1);
    rb_define_method(cFXLabel.klass, "setTipText", VALUEFUNC(_wrap_FXLabel_setTipText), -1);
    rb_define_method(cFXLabel.klass, "getTipText", VALUEFUNC(_wrap_FXLabel_getTipText), -1);
    rb_define_method(cFXLabel.klass, "save", VALUEFUNC(_wrap_FXLabel_save), -1);
    rb_define_method(cFXLabel.klass, "load", VALUEFUNC(_wrap_FXLabel_load), -1);
    rb_define_method(cFXLabel.klass, "create", VALUEFUNC(_wrap_FXLabel_create), -1);
    rb_define_method(cFXLabel.klass, "detach", VALUEFUNC(_wrap_FXLabel_detach), -1);
    rb_define_method(cFXLabel.klass, "destroy", VALUEFUNC(_wrap_FXLabel_destroy), -1);
    rb_define_method(cFXLabel.klass, "resize", VALUEFUNC(_wrap_FXLabel_resize), -1);
    rb_define_method(cFXLabel.klass, "getDefaultWidth", VALUEFUNC(_wrap_FXLabel_getDefaultWidth), -1);
    rb_define_method(cFXLabel.klass, "getDefaultHeight", VALUEFUNC(_wrap_FXLabel_getDefaultHeight), -1);
    rb_define_method(cFXLabel.klass, "getWidthForHeight", VALUEFUNC(_wrap_FXLabel_getWidthForHeight), -1);
    rb_define_method(cFXLabel.klass, "getHeightForWidth", VALUEFUNC(_wrap_FXLabel_getHeightForWidth), -1);
    rb_define_method(cFXLabel.klass, "canFocus", VALUEFUNC(_wrap_FXLabel_canFocus), -1);
    rb_define_method(cFXLabel.klass, "setFocus", VALUEFUNC(_wrap_FXLabel_setFocus), -1);
    rb_define_method(cFXLabel.klass, "killFocus", VALUEFUNC(_wrap_FXLabel_killFocus), -1);
    rb_define_method(cFXLabel.klass, "setDefault", VALUEFUNC(_wrap_FXLabel_setDefault), -1);
    rb_define_method(cFXLabel.klass, "enable", VALUEFUNC(_wrap_FXLabel_enable), -1);
    rb_define_method(cFXLabel.klass, "disable", VALUEFUNC(_wrap_FXLabel_disable), -1);
    rb_define_method(cFXLabel.klass, "raiseWindow", VALUEFUNC(_wrap_FXLabel_raiseWindow), -1);
    rb_define_method(cFXLabel.klass, "lower", VALUEFUNC(_wrap_FXLabel_lower), -1);
    rb_define_method(cFXLabel.klass, "move", VALUEFUNC(_wrap_FXLabel_move), -1);
    rb_define_method(cFXLabel.klass, "position", VALUEFUNC(_wrap_FXLabel_position), -1);
    rb_define_method(cFXLabel.klass, "layout", VALUEFUNC(_wrap_FXLabel_layout), -1);
    rb_define_method(cFXLabel.klass, "recalc", VALUEFUNC(_wrap_FXLabel_recalc), -1);
    rb_define_method(cFXLabel.klass, "reparent", VALUEFUNC(_wrap_FXLabel_reparent), -1);
    rb_define_method(cFXLabel.klass, "show", VALUEFUNC(_wrap_FXLabel_show), -1);
    rb_define_method(cFXLabel.klass, "hide", VALUEFUNC(_wrap_FXLabel_hide), -1);
    rb_define_method(cFXLabel.klass, "isComposite", VALUEFUNC(_wrap_FXLabel_isComposite), -1);
    rb_define_method(cFXLabel.klass, "contains", VALUEFUNC(_wrap_FXLabel_contains), -1);
    rb_define_method(cFXLabel.klass, "doesSaveUnder", VALUEFUNC(_wrap_FXLabel_doesSaveUnder), -1);
    rb_define_method(cFXLabel.klass, "setBackColor", VALUEFUNC(_wrap_FXLabel_setBackColor), -1);
    cFXLabel.mark = (void (*)(void *)) FXRbLabel::markfunc;
    cFXLabel.destroy = (void (*)(void *)) FXRbObject::freefunc;
    
    SWIGTYPE_p_FXLabel->dcast = (swig_dycast_func) FXLabel_dynamic_cast;
    
    rb_define_const(mFox,"STATE_UP", INT2NUM(STATE_UP));
    rb_define_const(mFox,"STATE_DOWN", INT2NUM(STATE_DOWN));
    rb_define_const(mFox,"STATE_ENGAGED", INT2NUM(STATE_ENGAGED));
    rb_define_const(mFox,"STATE_UNCHECKED", INT2NUM(STATE_UNCHECKED));
    rb_define_const(mFox,"STATE_CHECKED", INT2NUM(STATE_CHECKED));
    rb_define_const(mFox,"BUTTON_AUTOGRAY", INT2NUM(BUTTON_AUTOGRAY));
    rb_define_const(mFox,"BUTTON_AUTOHIDE", INT2NUM(BUTTON_AUTOHIDE));
    rb_define_const(mFox,"BUTTON_TOOLBAR", INT2NUM(BUTTON_TOOLBAR));
    rb_define_const(mFox,"BUTTON_DEFAULT", INT2NUM(BUTTON_DEFAULT));
    rb_define_const(mFox,"BUTTON_INITIAL", INT2NUM(BUTTON_INITIAL));
    rb_define_const(mFox,"BUTTON_NORMAL", INT2NUM(BUTTON_NORMAL));
    
    cFXButton.klass = rb_define_class_under(mFox, "FXButton", ((swig_class *) SWIGTYPE_p_FXLabel->clientdata)->klass);
    SWIG_TypeClientData(SWIGTYPE_p_FXButton, (void *) &cFXButton);
    rb_define_alloc_func(cFXButton.klass, _wrap_FXButton_allocate);
    rb_define_method(cFXButton.klass, "initialize", VALUEFUNC(_wrap_new_FXButton), -1);
    rb_define_method(cFXButton.klass, "onPaint", VALUEFUNC(_wrap_FXButton_onPaint), -1);
    rb_define_method(cFXButton.klass, "onUpdate", VALUEFUNC(_wrap_FXButton_onUpdate), -1);
    rb_define_method(cFXButton.klass, "onEnter", VALUEFUNC(_wrap_FXButton_onEnter), -1);
    rb_define_method(cFXButton.klass, "onLeave", VALUEFUNC(_wrap_FXButton_onLeave), -1);
    rb_define_method(cFXButton.klass, "onFocusIn", VALUEFUNC(_wrap_FXButton_onFocusIn), -1);
    rb_define_method(cFXButton.klass, "onFocusOut", VALUEFUNC(_wrap_FXButton_onFocusOut), -1);
    rb_define_method(cFXButton.klass, "onUngrabbed", VALUEFUNC(_wrap_FXButton_onUngrabbed), -1);
    rb_define_method(cFXButton.klass, "onLeftBtnPress", VALUEFUNC(_wrap_FXButton_onLeftBtnPress), -1);
    rb_define_method(cFXButton.klass, "onLeftBtnRelease", VALUEFUNC(_wrap_FXButton_onLeftBtnRelease), -1);
    rb_define_method(cFXButton.klass, "onKeyPress", VALUEFUNC(_wrap_FXButton_onKeyPress), -1);
    rb_define_method(cFXButton.klass, "onKeyRelease", VALUEFUNC(_wrap_FXButton_onKeyRelease), -1);
    rb_define_method(cFXButton.klass, "onHotKeyPress", VALUEFUNC(_wrap_FXButton_onHotKeyPress), -1);
    rb_define_method(cFXButton.klass, "onHotKeyRelease", VALUEFUNC(_wrap_FXButton_onHotKeyRelease), -1);
    rb_define_method(cFXButton.klass, "onCheck", VALUEFUNC(_wrap_FXButton_onCheck), -1);
    rb_define_method(cFXButton.klass, "onUncheck", VALUEFUNC(_wrap_FXButton_onUncheck), -1);
    rb_define_method(cFXButton.klass, "onCmdSetValue", VALUEFUNC(_wrap_FXButton_onCmdSetValue), -1);
    rb_define_method(cFXButton.klass, "onCmdSetIntValue", VALUEFUNC(_wrap_FXButton_onCmdSetIntValue), -1);
    rb_define_method(cFXButton.klass, "onCmdGetIntValue", VALUEFUNC(_wrap_FXButton_onCmdGetIntValue), -1);
    rb_define_method(cFXButton.klass, "setState", VALUEFUNC(_wrap_FXButton_setState), -1);
    rb_define_method(cFXButton.klass, "getState", VALUEFUNC(_wrap_FXButton_getState), -1);
    rb_define_method(cFXButton.klass, "setButtonStyle", VALUEFUNC(_wrap_FXButton_setButtonStyle), -1);
    rb_define_method(cFXButton.klass, "getButtonStyle", VALUEFUNC(_wrap_FXButton_getButtonStyle), -1);
    rb_define_method(cFXButton.klass, "save", VALUEFUNC(_wrap_FXButton_save), -1);
    rb_define_method(cFXButton.klass, "load", VALUEFUNC(_wrap_FXButton_load), -1);
    rb_define_method(cFXButton.klass, "create", VALUEFUNC(_wrap_FXButton_create), -1);
    rb_define_method(cFXButton.klass, "detach", VALUEFUNC(_wrap_FXButton_detach), -1);
    rb_define_method(cFXButton.klass, "destroy", VALUEFUNC(_wrap_FXButton_destroy), -1);
    rb_define_method(cFXButton.klass, "resize", VALUEFUNC(_wrap_FXButton_resize), -1);
    rb_define_method(cFXButton.klass, "getDefaultWidth", VALUEFUNC(_wrap_FXButton_getDefaultWidth), -1);
    rb_define_method(cFXButton.klass, "getDefaultHeight", VALUEFUNC(_wrap_FXButton_getDefaultHeight), -1);
    rb_define_method(cFXButton.klass, "getWidthForHeight", VALUEFUNC(_wrap_FXButton_getWidthForHeight), -1);
    rb_define_method(cFXButton.klass, "getHeightForWidth", VALUEFUNC(_wrap_FXButton_getHeightForWidth), -1);
    rb_define_method(cFXButton.klass, "canFocus", VALUEFUNC(_wrap_FXButton_canFocus), -1);
    rb_define_method(cFXButton.klass, "setFocus", VALUEFUNC(_wrap_FXButton_setFocus), -1);
    rb_define_method(cFXButton.klass, "killFocus", VALUEFUNC(_wrap_FXButton_killFocus), -1);
    rb_define_method(cFXButton.klass, "setDefault", VALUEFUNC(_wrap_FXButton_setDefault), -1);
    rb_define_method(cFXButton.klass, "enable", VALUEFUNC(_wrap_FXButton_enable), -1);
    rb_define_method(cFXButton.klass, "disable", VALUEFUNC(_wrap_FXButton_disable), -1);
    rb_define_method(cFXButton.klass, "raiseWindow", VALUEFUNC(_wrap_FXButton_raiseWindow), -1);
    rb_define_method(cFXButton.klass, "lower", VALUEFUNC(_wrap_FXButton_lower), -1);
    rb_define_method(cFXButton.klass, "move", VALUEFUNC(_wrap_FXButton_move), -1);
    rb_define_method(cFXButton.klass, "position", VALUEFUNC(_wrap_FXButton_position), -1);
    rb_define_method(cFXButton.klass, "layout", VALUEFUNC(_wrap_FXButton_layout), -1);
    rb_define_method(cFXButton.klass, "recalc", VALUEFUNC(_wrap_FXButton_recalc), -1);
    rb_define_method(cFXButton.klass, "reparent", VALUEFUNC(_wrap_FXButton_reparent), -1);
    rb_define_method(cFXButton.klass, "show", VALUEFUNC(_wrap_FXButton_show), -1);
    rb_define_method(cFXButton.klass, "hide", VALUEFUNC(_wrap_FXButton_hide), -1);
    rb_define_method(cFXButton.klass, "isComposite", VALUEFUNC(_wrap_FXButton_isComposite), -1);
    rb_define_method(cFXButton.klass, "contains", VALUEFUNC(_wrap_FXButton_contains), -1);
    rb_define_method(cFXButton.klass, "doesSaveUnder", VALUEFUNC(_wrap_FXButton_doesSaveUnder), -1);
    rb_define_method(cFXButton.klass, "setBackColor", VALUEFUNC(_wrap_FXButton_setBackColor), -1);
    cFXButton.mark = (void (*)(void *)) FXRbButton::markfunc;
    cFXButton.destroy = (void (*)(void *)) FXRbObject::freefunc;
    
    SWIGTYPE_p_FXButton->dcast = (swig_dycast_func) FXButton_dynamic_cast;
    
    rb_define_const(mFox,"CHECKBUTTON_AUTOGRAY", INT2NUM(CHECKBUTTON_AUTOGRAY));
    rb_define_const(mFox,"CHECKBUTTON_AUTOHIDE", INT2NUM(CHECKBUTTON_AUTOHIDE));
    rb_define_const(mFox,"CHECKBUTTON_PLUS", INT2NUM(CHECKBUTTON_PLUS));
    rb_define_const(mFox,"CHECKBUTTON_NORMAL", INT2NUM(CHECKBUTTON_NORMAL));
    
    cFXCheckButton.klass = rb_define_class_under(mFox, "FXCheckButton", ((swig_class *) SWIGTYPE_p_FXLabel->clientdata)->klass);
    SWIG_TypeClientData(SWIGTYPE_p_FXCheckButton, (void *) &cFXCheckButton);
    rb_define_alloc_func(cFXCheckButton.klass, _wrap_FXCheckButton_allocate);
    rb_define_method(cFXCheckButton.klass, "initialize", VALUEFUNC(_wrap_new_FXCheckButton), -1);
    rb_define_method(cFXCheckButton.klass, "onPaint", VALUEFUNC(_wrap_FXCheckButton_onPaint), -1);
    rb_define_method(cFXCheckButton.klass, "onUpdate", VALUEFUNC(_wrap_FXCheckButton_onUpdate), -1);
    rb_define_method(cFXCheckButton.klass, "onEnter", VALUEFUNC(_wrap_FXCheckButton_onEnter), -1);
    rb_define_method(cFXCheckButton.klass, "onLeave", VALUEFUNC(_wrap_FXCheckButton_onLeave), -1);
    rb_define_method(cFXCheckButton.klass, "onFocusIn", VALUEFUNC(_wrap_FXCheckButton_onFocusIn), -1);
    rb_define_method(cFXCheckButton.klass, "onFocusOut", VALUEFUNC(_wrap_FXCheckButton_onFocusOut), -1);
    rb_define_method(cFXCheckButton.klass, "onUngrabbed", VALUEFUNC(_wrap_FXCheckButton_onUngrabbed), -1);
    rb_define_method(cFXCheckButton.klass, "onLeftBtnPress", VALUEFUNC(_wrap_FXCheckButton_onLeftBtnPress), -1);
    rb_define_method(cFXCheckButton.klass, "onLeftBtnRelease", VALUEFUNC(_wrap_FXCheckButton_onLeftBtnRelease), -1);
    rb_define_method(cFXCheckButton.klass, "onKeyPress", VALUEFUNC(_wrap_FXCheckButton_onKeyPress), -1);
    rb_define_method(cFXCheckButton.klass, "onKeyRelease", VALUEFUNC(_wrap_FXCheckButton_onKeyRelease), -1);
    rb_define_method(cFXCheckButton.klass, "onHotKeyPress", VALUEFUNC(_wrap_FXCheckButton_onHotKeyPress), -1);
    rb_define_method(cFXCheckButton.klass, "onHotKeyRelease", VALUEFUNC(_wrap_FXCheckButton_onHotKeyRelease), -1);
    rb_define_method(cFXCheckButton.klass, "onCheck", VALUEFUNC(_wrap_FXCheckButton_onCheck), -1);
    rb_define_method(cFXCheckButton.klass, "onUncheck", VALUEFUNC(_wrap_FXCheckButton_onUncheck), -1);
    rb_define_method(cFXCheckButton.klass, "onUnknown", VALUEFUNC(_wrap_FXCheckButton_onUnknown), -1);
    rb_define_method(cFXCheckButton.klass, "onCmdSetValue", VALUEFUNC(_wrap_FXCheckButton_onCmdSetValue), -1);
    rb_define_method(cFXCheckButton.klass, "onCmdSetIntValue", VALUEFUNC(_wrap_FXCheckButton_onCmdSetIntValue), -1);
    rb_define_method(cFXCheckButton.klass, "onCmdGetIntValue", VALUEFUNC(_wrap_FXCheckButton_onCmdGetIntValue), -1);
    rb_define_method(cFXCheckButton.klass, "setCheck", VALUEFUNC(_wrap_FXCheckButton_setCheck), -1);
    rb_define_method(cFXCheckButton.klass, "getCheck", VALUEFUNC(_wrap_FXCheckButton_getCheck), -1);
    rb_define_method(cFXCheckButton.klass, "getCheckState", VALUEFUNC(_wrap_FXCheckButton_getCheckState), -1);
    rb_define_method(cFXCheckButton.klass, "setCheckButtonStyle", VALUEFUNC(_wrap_FXCheckButton_setCheckButtonStyle), -1);
    rb_define_method(cFXCheckButton.klass, "getCheckButtonStyle", VALUEFUNC(_wrap_FXCheckButton_getCheckButtonStyle), -1);
    rb_define_method(cFXCheckButton.klass, "getBoxColor", VALUEFUNC(_wrap_FXCheckButton_getBoxColor), -1);
    rb_define_method(cFXCheckButton.klass, "setBoxColor", VALUEFUNC(_wrap_FXCheckButton_setBoxColor), -1);
    rb_define_method(cFXCheckButton.klass, "getCheckColor", VALUEFUNC(_wrap_FXCheckButton_getCheckColor), -1);
    rb_define_method(cFXCheckButton.klass, "setCheckColor", VALUEFUNC(_wrap_FXCheckButton_setCheckColor), -1);
    rb_define_method(cFXCheckButton.klass, "save", VALUEFUNC(_wrap_FXCheckButton_save), -1);
    rb_define_method(cFXCheckButton.klass, "load", VALUEFUNC(_wrap_FXCheckButton_load), -1);
    rb_define_method(cFXCheckButton.klass, "create", VALUEFUNC(_wrap_FXCheckButton_create), -1);
    rb_define_method(cFXCheckButton.klass, "detach", VALUEFUNC(_wrap_FXCheckButton_detach), -1);
    rb_define_method(cFXCheckButton.klass, "destroy", VALUEFUNC(_wrap_FXCheckButton_destroy), -1);
    rb_define_method(cFXCheckButton.klass, "resize", VALUEFUNC(_wrap_FXCheckButton_resize), -1);
    rb_define_method(cFXCheckButton.klass, "getDefaultWidth", VALUEFUNC(_wrap_FXCheckButton_getDefaultWidth), -1);
    rb_define_method(cFXCheckButton.klass, "getDefaultHeight", VALUEFUNC(_wrap_FXCheckButton_getDefaultHeight), -1);
    rb_define_method(cFXCheckButton.klass, "getWidthForHeight", VALUEFUNC(_wrap_FXCheckButton_getWidthForHeight), -1);
    rb_define_method(cFXCheckButton.klass, "getHeightForWidth", VALUEFUNC(_wrap_FXCheckButton_getHeightForWidth), -1);
    rb_define_method(cFXCheckButton.klass, "canFocus", VALUEFUNC(_wrap_FXCheckButton_canFocus), -1);
    rb_define_method(cFXCheckButton.klass, "setFocus", VALUEFUNC(_wrap_FXCheckButton_setFocus), -1);
    rb_define_method(cFXCheckButton.klass, "killFocus", VALUEFUNC(_wrap_FXCheckButton_killFocus), -1);
    rb_define_method(cFXCheckButton.klass, "setDefault", VALUEFUNC(_wrap_FXCheckButton_setDefault), -1);
    rb_define_method(cFXCheckButton.klass, "enable", VALUEFUNC(_wrap_FXCheckButton_enable), -1);
    rb_define_method(cFXCheckButton.klass, "disable", VALUEFUNC(_wrap_FXCheckButton_disable), -1);
    rb_define_method(cFXCheckButton.klass, "raiseWindow", VALUEFUNC(_wrap_FXCheckButton_raiseWindow), -1);
    rb_define_method(cFXCheckButton.klass, "lower", VALUEFUNC(_wrap_FXCheckButton_lower), -1);
    rb_define_method(cFXCheckButton.klass, "move", VALUEFUNC(_wrap_FXCheckButton_move), -1);
    rb_define_method(cFXCheckButton.klass, "position", VALUEFUNC(_wrap_FXCheckButton_position), -1);
    rb_define_method(cFXCheckButton.klass, "layout", VALUEFUNC(_wrap_FXCheckButton_layout), -1);
    rb_define_method(cFXCheckButton.klass, "recalc", VALUEFUNC(_wrap_FXCheckButton_recalc), -1);
    rb_define_method(cFXCheckButton.klass, "reparent", VALUEFUNC(_wrap_FXCheckButton_reparent), -1);
    rb_define_method(cFXCheckButton.klass, "show", VALUEFUNC(_wrap_FXCheckButton_show), -1);
    rb_define_method(cFXCheckButton.klass, "hide", VALUEFUNC(_wrap_FXCheckButton_hide), -1);
    rb_define_method(cFXCheckButton.klass, "isComposite", VALUEFUNC(_wrap_FXCheckButton_isComposite), -1);
    rb_define_method(cFXCheckButton.klass, "contains", VALUEFUNC(_wrap_FXCheckButton_contains), -1);
    rb_define_method(cFXCheckButton.klass, "doesSaveUnder", VALUEFUNC(_wrap_FXCheckButton_doesSaveUnder), -1);
    rb_define_method(cFXCheckButton.klass, "setBackColor", VALUEFUNC(_wrap_FXCheckButton_setBackColor), -1);
    cFXCheckButton.mark = (void (*)(void *)) FXRbCheckButton::markfunc;
    cFXCheckButton.destroy = (void (*)(void *)) FXRbObject::freefunc;
    rb_define_const(mFox,"MENUBUTTON_AUTOGRAY", INT2NUM(MENUBUTTON_AUTOGRAY));
    rb_define_const(mFox,"MENUBUTTON_AUTOHIDE", INT2NUM(MENUBUTTON_AUTOHIDE));
    rb_define_const(mFox,"MENUBUTTON_TOOLBAR", INT2NUM(MENUBUTTON_TOOLBAR));
    rb_define_const(mFox,"MENUBUTTON_DOWN", INT2NUM(MENUBUTTON_DOWN));
    rb_define_const(mFox,"MENUBUTTON_UP", INT2NUM(MENUBUTTON_UP));
    rb_define_const(mFox,"MENUBUTTON_LEFT", INT2NUM(MENUBUTTON_LEFT));
    rb_define_const(mFox,"MENUBUTTON_RIGHT", INT2NUM(MENUBUTTON_RIGHT));
    rb_define_const(mFox,"MENUBUTTON_NOARROWS", INT2NUM(MENUBUTTON_NOARROWS));
    rb_define_const(mFox,"MENUBUTTON_ATTACH_LEFT", INT2NUM(MENUBUTTON_ATTACH_LEFT));
    rb_define_const(mFox,"MENUBUTTON_ATTACH_TOP", INT2NUM(MENUBUTTON_ATTACH_TOP));
    rb_define_const(mFox,"MENUBUTTON_ATTACH_RIGHT", INT2NUM(MENUBUTTON_ATTACH_RIGHT));
    rb_define_const(mFox,"MENUBUTTON_ATTACH_BOTTOM", INT2NUM(MENUBUTTON_ATTACH_BOTTOM));
    rb_define_const(mFox,"MENUBUTTON_ATTACH_CENTER", INT2NUM(MENUBUTTON_ATTACH_CENTER));
    rb_define_const(mFox,"MENUBUTTON_ATTACH_BOTH", INT2NUM(MENUBUTTON_ATTACH_BOTH));
    
    cFXMenuButton.klass = rb_define_class_under(mFox, "FXMenuButton", ((swig_class *) SWIGTYPE_p_FXLabel->clientdata)->klass);
    SWIG_TypeClientData(SWIGTYPE_p_FXMenuButton, (void *) &cFXMenuButton);
    rb_define_alloc_func(cFXMenuButton.klass, _wrap_FXMenuButton_allocate);
    rb_define_method(cFXMenuButton.klass, "initialize", VALUEFUNC(_wrap_new_FXMenuButton), -1);
    rb_define_method(cFXMenuButton.klass, "onPaint", VALUEFUNC(_wrap_FXMenuButton_onPaint), -1);
    rb_define_method(cFXMenuButton.klass, "onUpdate", VALUEFUNC(_wrap_FXMenuButton_onUpdate), -1);
    rb_define_method(cFXMenuButton.klass, "onEnter", VALUEFUNC(_wrap_FXMenuButton_onEnter), -1);
    rb_define_method(cFXMenuButton.klass, "onLeave", VALUEFUNC(_wrap_FXMenuButton_onLeave), -1);
    rb_define_method(cFXMenuButton.klass, "onFocusIn", VALUEFUNC(_wrap_FXMenuButton_onFocusIn), -1);
    rb_define_method(cFXMenuButton.klass, "onFocusOut", VALUEFUNC(_wrap_FXMenuButton_onFocusOut), -1);
    rb_define_method(cFXMenuButton.klass, "onUngrabbed", VALUEFUNC(_wrap_FXMenuButton_onUngrabbed), -1);
    rb_define_method(cFXMenuButton.klass, "onMotion", VALUEFUNC(_wrap_FXMenuButton_onMotion), -1);
    rb_define_method(cFXMenuButton.klass, "onLeftBtnPress", VALUEFUNC(_wrap_FXMenuButton_onLeftBtnPress), -1);
    rb_define_method(cFXMenuButton.klass, "onLeftBtnRelease", VALUEFUNC(_wrap_FXMenuButton_onLeftBtnRelease), -1);
    rb_define_method(cFXMenuButton.klass, "onKeyPress", VALUEFUNC(_wrap_FXMenuButton_onKeyPress), -1);
    rb_define_method(cFXMenuButton.klass, "onKeyRelease", VALUEFUNC(_wrap_FXMenuButton_onKeyRelease), -1);
    rb_define_method(cFXMenuButton.klass, "onHotKeyPress", VALUEFUNC(_wrap_FXMenuButton_onHotKeyPress), -1);
    rb_define_method(cFXMenuButton.klass, "onHotKeyRelease", VALUEFUNC(_wrap_FXMenuButton_onHotKeyRelease), -1);
    rb_define_method(cFXMenuButton.klass, "onCmdPost", VALUEFUNC(_wrap_FXMenuButton_onCmdPost), -1);
    rb_define_method(cFXMenuButton.klass, "onCmdUnpost", VALUEFUNC(_wrap_FXMenuButton_onCmdUnpost), -1);
    rb_define_method(cFXMenuButton.klass, "setMenu", VALUEFUNC(_wrap_FXMenuButton_setMenu), -1);
    rb_define_method(cFXMenuButton.klass, "getMenu", VALUEFUNC(_wrap_FXMenuButton_getMenu), -1);
    rb_define_method(cFXMenuButton.klass, "setXOffset", VALUEFUNC(_wrap_FXMenuButton_setXOffset), -1);
    rb_define_method(cFXMenuButton.klass, "getXOffset", VALUEFUNC(_wrap_FXMenuButton_getXOffset), -1);
    rb_define_method(cFXMenuButton.klass, "setYOffset", VALUEFUNC(_wrap_FXMenuButton_setYOffset), -1);
    rb_define_method(cFXMenuButton.klass, "getYOffset", VALUEFUNC(_wrap_FXMenuButton_getYOffset), -1);
    rb_define_method(cFXMenuButton.klass, "setButtonStyle", VALUEFUNC(_wrap_FXMenuButton_setButtonStyle), -1);
    rb_define_method(cFXMenuButton.klass, "getButtonStyle", VALUEFUNC(_wrap_FXMenuButton_getButtonStyle), -1);
    rb_define_method(cFXMenuButton.klass, "setPopupStyle", VALUEFUNC(_wrap_FXMenuButton_setPopupStyle), -1);
    rb_define_method(cFXMenuButton.klass, "getPopupStyle", VALUEFUNC(_wrap_FXMenuButton_getPopupStyle), -1);
    rb_define_method(cFXMenuButton.klass, "setAttachment", VALUEFUNC(_wrap_FXMenuButton_setAttachment), -1);
    rb_define_method(cFXMenuButton.klass, "getAttachment", VALUEFUNC(_wrap_FXMenuButton_getAttachment), -1);
    rb_define_method(cFXMenuButton.klass, "save", VALUEFUNC(_wrap_FXMenuButton_save), -1);
    rb_define_method(cFXMenuButton.klass, "load", VALUEFUNC(_wrap_FXMenuButton_load), -1);
    rb_define_method(cFXMenuButton.klass, "create", VALUEFUNC(_wrap_FXMenuButton_create), -1);
    rb_define_method(cFXMenuButton.klass, "detach", VALUEFUNC(_wrap_FXMenuButton_detach), -1);
    rb_define_method(cFXMenuButton.klass, "destroy", VALUEFUNC(_wrap_FXMenuButton_destroy), -1);
    rb_define_method(cFXMenuButton.klass, "resize", VALUEFUNC(_wrap_FXMenuButton_resize), -1);
    rb_define_method(cFXMenuButton.klass, "getDefaultWidth", VALUEFUNC(_wrap_FXMenuButton_getDefaultWidth), -1);
    rb_define_method(cFXMenuButton.klass, "getDefaultHeight", VALUEFUNC(_wrap_FXMenuButton_getDefaultHeight), -1);
    rb_define_method(cFXMenuButton.klass, "getWidthForHeight", VALUEFUNC(_wrap_FXMenuButton_getWidthForHeight), -1);
    rb_define_method(cFXMenuButton.klass, "getHeightForWidth", VALUEFUNC(_wrap_FXMenuButton_getHeightForWidth), -1);
    rb_define_method(cFXMenuButton.klass, "canFocus", VALUEFUNC(_wrap_FXMenuButton_canFocus), -1);
    rb_define_method(cFXMenuButton.klass, "setFocus", VALUEFUNC(_wrap_FXMenuButton_setFocus), -1);
    rb_define_method(cFXMenuButton.klass, "killFocus", VALUEFUNC(_wrap_FXMenuButton_killFocus), -1);
    rb_define_method(cFXMenuButton.klass, "setDefault", VALUEFUNC(_wrap_FXMenuButton_setDefault), -1);
    rb_define_method(cFXMenuButton.klass, "enable", VALUEFUNC(_wrap_FXMenuButton_enable), -1);
    rb_define_method(cFXMenuButton.klass, "disable", VALUEFUNC(_wrap_FXMenuButton_disable), -1);
    rb_define_method(cFXMenuButton.klass, "raiseWindow", VALUEFUNC(_wrap_FXMenuButton_raiseWindow), -1);
    rb_define_method(cFXMenuButton.klass, "lower", VALUEFUNC(_wrap_FXMenuButton_lower), -1);
    rb_define_method(cFXMenuButton.klass, "move", VALUEFUNC(_wrap_FXMenuButton_move), -1);
    rb_define_method(cFXMenuButton.klass, "position", VALUEFUNC(_wrap_FXMenuButton_position), -1);
    rb_define_method(cFXMenuButton.klass, "layout", VALUEFUNC(_wrap_FXMenuButton_layout), -1);
    rb_define_method(cFXMenuButton.klass, "recalc", VALUEFUNC(_wrap_FXMenuButton_recalc), -1);
    rb_define_method(cFXMenuButton.klass, "reparent", VALUEFUNC(_wrap_FXMenuButton_reparent), -1);
    rb_define_method(cFXMenuButton.klass, "show", VALUEFUNC(_wrap_FXMenuButton_show), -1);
    rb_define_method(cFXMenuButton.klass, "hide", VALUEFUNC(_wrap_FXMenuButton_hide), -1);
    rb_define_method(cFXMenuButton.klass, "isComposite", VALUEFUNC(_wrap_FXMenuButton_isComposite), -1);
    rb_define_method(cFXMenuButton.klass, "contains", VALUEFUNC(_wrap_FXMenuButton_contains), -1);
    rb_define_method(cFXMenuButton.klass, "doesSaveUnder", VALUEFUNC(_wrap_FXMenuButton_doesSaveUnder), -1);
    rb_define_method(cFXMenuButton.klass, "setBackColor", VALUEFUNC(_wrap_FXMenuButton_setBackColor), -1);
    cFXMenuButton.mark = (void (*)(void *)) FXRbMenuButton::markfunc;
    cFXMenuButton.destroy = (void (*)(void *)) FXRbObject::freefunc;
    
    SWIGTYPE_p_FXMenuButton->dcast = (swig_dycast_func) FXMenuButton_dynamic_cast;
    
    
    cFXOption.klass = rb_define_class_under(mFox, "FXOption", ((swig_class *) SWIGTYPE_p_FXLabel->clientdata)->klass);
    SWIG_TypeClientData(SWIGTYPE_p_FXOption, (void *) &cFXOption);
    rb_define_alloc_func(cFXOption.klass, _wrap_FXOption_allocate);
    rb_define_method(cFXOption.klass, "initialize", VALUEFUNC(_wrap_new_FXOption), -1);
    rb_define_method(cFXOption.klass, "onPaint", VALUEFUNC(_wrap_FXOption_onPaint), -1);
    rb_define_method(cFXOption.klass, "onEnter", VALUEFUNC(_wrap_FXOption_onEnter), -1);
    rb_define_method(cFXOption.klass, "onLeave", VALUEFUNC(_wrap_FXOption_onLeave), -1);
    rb_define_method(cFXOption.klass, "onLeftBtnPress", VALUEFUNC(_wrap_FXOption_onLeftBtnPress), -1);
    rb_define_method(cFXOption.klass, "onLeftBtnRelease", VALUEFUNC(_wrap_FXOption_onLeftBtnRelease), -1);
    rb_define_method(cFXOption.klass, "onKeyPress", VALUEFUNC(_wrap_FXOption_onKeyPress), -1);
    rb_define_method(cFXOption.klass, "onKeyRelease", VALUEFUNC(_wrap_FXOption_onKeyRelease), -1);
    rb_define_method(cFXOption.klass, "onHotKeyPress", VALUEFUNC(_wrap_FXOption_onHotKeyPress), -1);
    rb_define_method(cFXOption.klass, "onHotKeyRelease", VALUEFUNC(_wrap_FXOption_onHotKeyRelease), -1);
    rb_define_method(cFXOption.klass, "save", VALUEFUNC(_wrap_FXOption_save), -1);
    rb_define_method(cFXOption.klass, "load", VALUEFUNC(_wrap_FXOption_load), -1);
    rb_define_method(cFXOption.klass, "create", VALUEFUNC(_wrap_FXOption_create), -1);
    rb_define_method(cFXOption.klass, "detach", VALUEFUNC(_wrap_FXOption_detach), -1);
    rb_define_method(cFXOption.klass, "destroy", VALUEFUNC(_wrap_FXOption_destroy), -1);
    rb_define_method(cFXOption.klass, "resize", VALUEFUNC(_wrap_FXOption_resize), -1);
    rb_define_method(cFXOption.klass, "getDefaultWidth", VALUEFUNC(_wrap_FXOption_getDefaultWidth), -1);
    rb_define_method(cFXOption.klass, "getDefaultHeight", VALUEFUNC(_wrap_FXOption_getDefaultHeight), -1);
    rb_define_method(cFXOption.klass, "getWidthForHeight", VALUEFUNC(_wrap_FXOption_getWidthForHeight), -1);
    rb_define_method(cFXOption.klass, "getHeightForWidth", VALUEFUNC(_wrap_FXOption_getHeightForWidth), -1);
    rb_define_method(cFXOption.klass, "canFocus", VALUEFUNC(_wrap_FXOption_canFocus), -1);
    rb_define_method(cFXOption.klass, "setFocus", VALUEFUNC(_wrap_FXOption_setFocus), -1);
    rb_define_method(cFXOption.klass, "killFocus", VALUEFUNC(_wrap_FXOption_killFocus), -1);
    rb_define_method(cFXOption.klass, "setDefault", VALUEFUNC(_wrap_FXOption_setDefault), -1);
    rb_define_method(cFXOption.klass, "enable", VALUEFUNC(_wrap_FXOption_enable), -1);
    rb_define_method(cFXOption.klass, "disable", VALUEFUNC(_wrap_FXOption_disable), -1);
    rb_define_method(cFXOption.klass, "raiseWindow", VALUEFUNC(_wrap_FXOption_raiseWindow), -1);
    rb_define_method(cFXOption.klass, "lower", VALUEFUNC(_wrap_FXOption_lower), -1);
    rb_define_method(cFXOption.klass, "move", VALUEFUNC(_wrap_FXOption_move), -1);
    rb_define_method(cFXOption.klass, "position", VALUEFUNC(_wrap_FXOption_position), -1);
    rb_define_method(cFXOption.klass, "layout", VALUEFUNC(_wrap_FXOption_layout), -1);
    rb_define_method(cFXOption.klass, "recalc", VALUEFUNC(_wrap_FXOption_recalc), -1);
    rb_define_method(cFXOption.klass, "reparent", VALUEFUNC(_wrap_FXOption_reparent), -1);
    rb_define_method(cFXOption.klass, "show", VALUEFUNC(_wrap_FXOption_show), -1);
    rb_define_method(cFXOption.klass, "hide", VALUEFUNC(_wrap_FXOption_hide), -1);
    rb_define_method(cFXOption.klass, "isComposite", VALUEFUNC(_wrap_FXOption_isComposite), -1);
    rb_define_method(cFXOption.klass, "contains", VALUEFUNC(_wrap_FXOption_contains), -1);
    rb_define_method(cFXOption.klass, "doesSaveUnder", VALUEFUNC(_wrap_FXOption_doesSaveUnder), -1);
    rb_define_method(cFXOption.klass, "setBackColor", VALUEFUNC(_wrap_FXOption_setBackColor), -1);
    cFXOption.mark = (void (*)(void *)) FXRbOption::markfunc;
    cFXOption.destroy = (void (*)(void *)) FXRbObject::freefunc;
    
    cFXOptionMenu.klass = rb_define_class_under(mFox, "FXOptionMenu", ((swig_class *) SWIGTYPE_p_FXLabel->clientdata)->klass);
    SWIG_TypeClientData(SWIGTYPE_p_FXOptionMenu, (void *) &cFXOptionMenu);
    rb_define_alloc_func(cFXOptionMenu.klass, _wrap_FXOptionMenu_allocate);
    rb_define_method(cFXOptionMenu.klass, "initialize", VALUEFUNC(_wrap_new_FXOptionMenu), -1);
    rb_define_method(cFXOptionMenu.klass, "onPaint", VALUEFUNC(_wrap_FXOptionMenu_onPaint), -1);
    rb_define_method(cFXOptionMenu.klass, "onLeftBtnPress", VALUEFUNC(_wrap_FXOptionMenu_onLeftBtnPress), -1);
    rb_define_method(cFXOptionMenu.klass, "onLeftBtnRelease", VALUEFUNC(_wrap_FXOptionMenu_onLeftBtnRelease), -1);
    rb_define_method(cFXOptionMenu.klass, "onFocusIn", VALUEFUNC(_wrap_FXOptionMenu_onFocusIn), -1);
    rb_define_method(cFXOptionMenu.klass, "onFocusOut", VALUEFUNC(_wrap_FXOptionMenu_onFocusOut), -1);
    rb_define_method(cFXOptionMenu.klass, "onMotion", VALUEFUNC(_wrap_FXOptionMenu_onMotion), -1);
    rb_define_method(cFXOptionMenu.klass, "onKeyPress", VALUEFUNC(_wrap_FXOptionMenu_onKeyPress), -1);
    rb_define_method(cFXOptionMenu.klass, "onKeyRelease", VALUEFUNC(_wrap_FXOptionMenu_onKeyRelease), -1);
    rb_define_method(cFXOptionMenu.klass, "onCmdPost", VALUEFUNC(_wrap_FXOptionMenu_onCmdPost), -1);
    rb_define_method(cFXOptionMenu.klass, "onCmdUnpost", VALUEFUNC(_wrap_FXOptionMenu_onCmdUnpost), -1);
    rb_define_method(cFXOptionMenu.klass, "onQueryHelp", VALUEFUNC(_wrap_FXOptionMenu_onQueryHelp), -1);
    rb_define_method(cFXOptionMenu.klass, "onQueryTip", VALUEFUNC(_wrap_FXOptionMenu_onQueryTip), -1);
    rb_define_method(cFXOptionMenu.klass, "onCmdSetValue", VALUEFUNC(_wrap_FXOptionMenu_onCmdSetValue), -1);
    rb_define_method(cFXOptionMenu.klass, "onCmdSetIntValue", VALUEFUNC(_wrap_FXOptionMenu_onCmdSetIntValue), -1);
    rb_define_method(cFXOptionMenu.klass, "onCmdGetIntValue", VALUEFUNC(_wrap_FXOptionMenu_onCmdGetIntValue), -1);
    rb_define_method(cFXOptionMenu.klass, "setCurrent", VALUEFUNC(_wrap_FXOptionMenu_setCurrent), -1);
    rb_define_method(cFXOptionMenu.klass, "getCurrent", VALUEFUNC(_wrap_FXOptionMenu_getCurrent), -1);
    rb_define_method(cFXOptionMenu.klass, "setCurrentNo", VALUEFUNC(_wrap_FXOptionMenu_setCurrentNo), -1);
    rb_define_method(cFXOptionMenu.klass, "getCurrentNo", VALUEFUNC(_wrap_FXOptionMenu_getCurrentNo), -1);
    rb_define_method(cFXOptionMenu.klass, "getNumOptions", VALUEFUNC(_wrap_FXOptionMenu_getNumOptions), -1);
    rb_define_method(cFXOptionMenu.klass, "setMenu", VALUEFUNC(_wrap_FXOptionMenu_setMenu), -1);
    rb_define_method(cFXOptionMenu.klass, "getMenu", VALUEFUNC(_wrap_FXOptionMenu_getMenu), -1);
    rb_define_method(cFXOptionMenu.klass, "isPopped", VALUEFUNC(_wrap_FXOptionMenu_isPopped), -1);
    rb_define_method(cFXOptionMenu.klass, "save", VALUEFUNC(_wrap_FXOptionMenu_save), -1);
    rb_define_method(cFXOptionMenu.klass, "load", VALUEFUNC(_wrap_FXOptionMenu_load), -1);
    rb_define_method(cFXOptionMenu.klass, "create", VALUEFUNC(_wrap_FXOptionMenu_create), -1);
    rb_define_method(cFXOptionMenu.klass, "detach", VALUEFUNC(_wrap_FXOptionMenu_detach), -1);
    rb_define_method(cFXOptionMenu.klass, "destroy", VALUEFUNC(_wrap_FXOptionMenu_destroy), -1);
    rb_define_method(cFXOptionMenu.klass, "resize", VALUEFUNC(_wrap_FXOptionMenu_resize), -1);
    rb_define_method(cFXOptionMenu.klass, "getDefaultWidth", VALUEFUNC(_wrap_FXOptionMenu_getDefaultWidth), -1);
    rb_define_method(cFXOptionMenu.klass, "getDefaultHeight", VALUEFUNC(_wrap_FXOptionMenu_getDefaultHeight), -1);
    rb_define_method(cFXOptionMenu.klass, "getWidthForHeight", VALUEFUNC(_wrap_FXOptionMenu_getWidthForHeight), -1);
    rb_define_method(cFXOptionMenu.klass, "getHeightForWidth", VALUEFUNC(_wrap_FXOptionMenu_getHeightForWidth), -1);
    rb_define_method(cFXOptionMenu.klass, "canFocus", VALUEFUNC(_wrap_FXOptionMenu_canFocus), -1);
    rb_define_method(cFXOptionMenu.klass, "setFocus", VALUEFUNC(_wrap_FXOptionMenu_setFocus), -1);
    rb_define_method(cFXOptionMenu.klass, "killFocus", VALUEFUNC(_wrap_FXOptionMenu_killFocus), -1);
    rb_define_method(cFXOptionMenu.klass, "setDefault", VALUEFUNC(_wrap_FXOptionMenu_setDefault), -1);
    rb_define_method(cFXOptionMenu.klass, "enable", VALUEFUNC(_wrap_FXOptionMenu_enable), -1);
    rb_define_method(cFXOptionMenu.klass, "disable", VALUEFUNC(_wrap_FXOptionMenu_disable), -1);
    rb_define_method(cFXOptionMenu.klass, "raiseWindow", VALUEFUNC(_wrap_FXOptionMenu_raiseWindow), -1);
    rb_define_method(cFXOptionMenu.klass, "lower", VALUEFUNC(_wrap_FXOptionMenu_lower), -1);
    rb_define_method(cFXOptionMenu.klass, "move", VALUEFUNC(_wrap_FXOptionMenu_move), -1);
    rb_define_method(cFXOptionMenu.klass, "position", VALUEFUNC(_wrap_FXOptionMenu_position), -1);
    rb_define_method(cFXOptionMenu.klass, "layout", VALUEFUNC(_wrap_FXOptionMenu_layout), -1);
    rb_define_method(cFXOptionMenu.klass, "recalc", VALUEFUNC(_wrap_FXOptionMenu_recalc), -1);
    rb_define_method(cFXOptionMenu.klass, "reparent", VALUEFUNC(_wrap_FXOptionMenu_reparent), -1);
    rb_define_method(cFXOptionMenu.klass, "show", VALUEFUNC(_wrap_FXOptionMenu_show), -1);
    rb_define_method(cFXOptionMenu.klass, "hide", VALUEFUNC(_wrap_FXOptionMenu_hide), -1);
    rb_define_method(cFXOptionMenu.klass, "isComposite", VALUEFUNC(_wrap_FXOptionMenu_isComposite), -1);
    rb_define_method(cFXOptionMenu.klass, "contains", VALUEFUNC(_wrap_FXOptionMenu_contains), -1);
    rb_define_method(cFXOptionMenu.klass, "doesSaveUnder", VALUEFUNC(_wrap_FXOptionMenu_doesSaveUnder), -1);
    rb_define_method(cFXOptionMenu.klass, "setBackColor", VALUEFUNC(_wrap_FXOptionMenu_setBackColor), -1);
    cFXOptionMenu.mark = (void (*)(void *)) FXRbOptionMenu::markfunc;
    cFXOptionMenu.destroy = (void (*)(void *)) FXRbObject::freefunc;
    rb_define_const(mFox,"RADIOBUTTON_AUTOGRAY", INT2NUM(RADIOBUTTON_AUTOGRAY));
    rb_define_const(mFox,"RADIOBUTTON_AUTOHIDE", INT2NUM(RADIOBUTTON_AUTOHIDE));
    rb_define_const(mFox,"RADIOBUTTON_NORMAL", INT2NUM(RADIOBUTTON_NORMAL));
    
    cFXRadioButton.klass = rb_define_class_under(mFox, "FXRadioButton", ((swig_class *) SWIGTYPE_p_FXLabel->clientdata)->klass);
    SWIG_TypeClientData(SWIGTYPE_p_FXRadioButton, (void *) &cFXRadioButton);
    rb_define_alloc_func(cFXRadioButton.klass, _wrap_FXRadioButton_allocate);
    rb_define_method(cFXRadioButton.klass, "initialize", VALUEFUNC(_wrap_new_FXRadioButton), -1);
    rb_define_method(cFXRadioButton.klass, "onPaint", VALUEFUNC(_wrap_FXRadioButton_onPaint), -1);
    rb_define_method(cFXRadioButton.klass, "onUpdate", VALUEFUNC(_wrap_FXRadioButton_onUpdate), -1);
    rb_define_method(cFXRadioButton.klass, "onEnter", VALUEFUNC(_wrap_FXRadioButton_onEnter), -1);
    rb_define_method(cFXRadioButton.klass, "onLeave", VALUEFUNC(_wrap_FXRadioButton_onLeave), -1);
    rb_define_method(cFXRadioButton.klass, "onFocusIn", VALUEFUNC(_wrap_FXRadioButton_onFocusIn), -1);
    rb_define_method(cFXRadioButton.klass, "onFocusOut", VALUEFUNC(_wrap_FXRadioButton_onFocusOut), -1);
    rb_define_method(cFXRadioButton.klass, "onUngrabbed", VALUEFUNC(_wrap_FXRadioButton_onUngrabbed), -1);
    rb_define_method(cFXRadioButton.klass, "onLeftBtnPress", VALUEFUNC(_wrap_FXRadioButton_onLeftBtnPress), -1);
    rb_define_method(cFXRadioButton.klass, "onLeftBtnRelease", VALUEFUNC(_wrap_FXRadioButton_onLeftBtnRelease), -1);
    rb_define_method(cFXRadioButton.klass, "onKeyPress", VALUEFUNC(_wrap_FXRadioButton_onKeyPress), -1);
    rb_define_method(cFXRadioButton.klass, "onKeyRelease", VALUEFUNC(_wrap_FXRadioButton_onKeyRelease), -1);
    rb_define_method(cFXRadioButton.klass, "onHotKeyPress", VALUEFUNC(_wrap_FXRadioButton_onHotKeyPress), -1);
    rb_define_method(cFXRadioButton.klass, "onHotKeyRelease", VALUEFUNC(_wrap_FXRadioButton_onHotKeyRelease), -1);
    rb_define_method(cFXRadioButton.klass, "onCheck", VALUEFUNC(_wrap_FXRadioButton_onCheck), -1);
    rb_define_method(cFXRadioButton.klass, "onUncheck", VALUEFUNC(_wrap_FXRadioButton_onUncheck), -1);
    rb_define_method(cFXRadioButton.klass, "onUnknown", VALUEFUNC(_wrap_FXRadioButton_onUnknown), -1);
    rb_define_method(cFXRadioButton.klass, "onCmdSetValue", VALUEFUNC(_wrap_FXRadioButton_onCmdSetValue), -1);
    rb_define_method(cFXRadioButton.klass, "onCmdSetIntValue", VALUEFUNC(_wrap_FXRadioButton_onCmdSetIntValue), -1);
    rb_define_method(cFXRadioButton.klass, "onCmdGetIntValue", VALUEFUNC(_wrap_FXRadioButton_onCmdGetIntValue), -1);
    rb_define_method(cFXRadioButton.klass, "setCheck", VALUEFUNC(_wrap_FXRadioButton_setCheck), -1);
    rb_define_method(cFXRadioButton.klass, "getCheck", VALUEFUNC(_wrap_FXRadioButton_getCheck), -1);
    rb_define_method(cFXRadioButton.klass, "getCheckState", VALUEFUNC(_wrap_FXRadioButton_getCheckState), -1);
    rb_define_method(cFXRadioButton.klass, "setRadioButtonStyle", VALUEFUNC(_wrap_FXRadioButton_setRadioButtonStyle), -1);
    rb_define_method(cFXRadioButton.klass, "getRadioButtonStyle", VALUEFUNC(_wrap_FXRadioButton_getRadioButtonStyle), -1);
    rb_define_method(cFXRadioButton.klass, "getRadioColor", VALUEFUNC(_wrap_FXRadioButton_getRadioColor), -1);
    rb_define_method(cFXRadioButton.klass, "setRadioColor", VALUEFUNC(_wrap_FXRadioButton_setRadioColor), -1);
    rb_define_method(cFXRadioButton.klass, "getDiskColor", VALUEFUNC(_wrap_FXRadioButton_getDiskColor), -1);
    rb_define_method(cFXRadioButton.klass, "setDiskColor", VALUEFUNC(_wrap_FXRadioButton_setDiskColor), -1);
    rb_define_method(cFXRadioButton.klass, "save", VALUEFUNC(_wrap_FXRadioButton_save), -1);
    rb_define_method(cFXRadioButton.klass, "load", VALUEFUNC(_wrap_FXRadioButton_load), -1);
    rb_define_method(cFXRadioButton.klass, "create", VALUEFUNC(_wrap_FXRadioButton_create), -1);
    rb_define_method(cFXRadioButton.klass, "detach", VALUEFUNC(_wrap_FXRadioButton_detach), -1);
    rb_define_method(cFXRadioButton.klass, "destroy", VALUEFUNC(_wrap_FXRadioButton_destroy), -1);
    rb_define_method(cFXRadioButton.klass, "resize", VALUEFUNC(_wrap_FXRadioButton_resize), -1);
    rb_define_method(cFXRadioButton.klass, "getDefaultWidth", VALUEFUNC(_wrap_FXRadioButton_getDefaultWidth), -1);
    rb_define_method(cFXRadioButton.klass, "getDefaultHeight", VALUEFUNC(_wrap_FXRadioButton_getDefaultHeight), -1);
    rb_define_method(cFXRadioButton.klass, "getWidthForHeight", VALUEFUNC(_wrap_FXRadioButton_getWidthForHeight), -1);
    rb_define_method(cFXRadioButton.klass, "getHeightForWidth", VALUEFUNC(_wrap_FXRadioButton_getHeightForWidth), -1);
    rb_define_method(cFXRadioButton.klass, "canFocus", VALUEFUNC(_wrap_FXRadioButton_canFocus), -1);
    rb_define_method(cFXRadioButton.klass, "setFocus", VALUEFUNC(_wrap_FXRadioButton_setFocus), -1);
    rb_define_method(cFXRadioButton.klass, "killFocus", VALUEFUNC(_wrap_FXRadioButton_killFocus), -1);
    rb_define_method(cFXRadioButton.klass, "setDefault", VALUEFUNC(_wrap_FXRadioButton_setDefault), -1);
    rb_define_method(cFXRadioButton.klass, "enable", VALUEFUNC(_wrap_FXRadioButton_enable), -1);
    rb_define_method(cFXRadioButton.klass, "disable", VALUEFUNC(_wrap_FXRadioButton_disable), -1);
    rb_define_method(cFXRadioButton.klass, "raiseWindow", VALUEFUNC(_wrap_FXRadioButton_raiseWindow), -1);
    rb_define_method(cFXRadioButton.klass, "lower", VALUEFUNC(_wrap_FXRadioButton_lower), -1);
    rb_define_method(cFXRadioButton.klass, "move", VALUEFUNC(_wrap_FXRadioButton_move), -1);
    rb_define_method(cFXRadioButton.klass, "position", VALUEFUNC(_wrap_FXRadioButton_position), -1);
    rb_define_method(cFXRadioButton.klass, "layout", VALUEFUNC(_wrap_FXRadioButton_layout), -1);
    rb_define_method(cFXRadioButton.klass, "recalc", VALUEFUNC(_wrap_FXRadioButton_recalc), -1);
    rb_define_method(cFXRadioButton.klass, "reparent", VALUEFUNC(_wrap_FXRadioButton_reparent), -1);
    rb_define_method(cFXRadioButton.klass, "show", VALUEFUNC(_wrap_FXRadioButton_show), -1);
    rb_define_method(cFXRadioButton.klass, "hide", VALUEFUNC(_wrap_FXRadioButton_hide), -1);
    rb_define_method(cFXRadioButton.klass, "isComposite", VALUEFUNC(_wrap_FXRadioButton_isComposite), -1);
    rb_define_method(cFXRadioButton.klass, "contains", VALUEFUNC(_wrap_FXRadioButton_contains), -1);
    rb_define_method(cFXRadioButton.klass, "doesSaveUnder", VALUEFUNC(_wrap_FXRadioButton_doesSaveUnder), -1);
    rb_define_method(cFXRadioButton.klass, "setBackColor", VALUEFUNC(_wrap_FXRadioButton_setBackColor), -1);
    cFXRadioButton.mark = (void (*)(void *)) FXRbRadioButton::markfunc;
    cFXRadioButton.destroy = (void (*)(void *)) FXRbObject::freefunc;
    rb_define_const(mFox,"TAB_TOP", INT2NUM(TAB_TOP));
    rb_define_const(mFox,"TAB_LEFT", INT2NUM(TAB_LEFT));
    rb_define_const(mFox,"TAB_RIGHT", INT2NUM(TAB_RIGHT));
    rb_define_const(mFox,"TAB_BOTTOM", INT2NUM(TAB_BOTTOM));
    rb_define_const(mFox,"TAB_TOP_NORMAL", INT2NUM(TAB_TOP_NORMAL));
    rb_define_const(mFox,"TAB_BOTTOM_NORMAL", INT2NUM(TAB_BOTTOM_NORMAL));
    rb_define_const(mFox,"TAB_LEFT_NORMAL", INT2NUM(TAB_LEFT_NORMAL));
    rb_define_const(mFox,"TAB_RIGHT_NORMAL", INT2NUM(TAB_RIGHT_NORMAL));
    
    cFXTabItem.klass = rb_define_class_under(mFox, "FXTabItem", ((swig_class *) SWIGTYPE_p_FXLabel->clientdata)->klass);
    SWIG_TypeClientData(SWIGTYPE_p_FXTabItem, (void *) &cFXTabItem);
    rb_define_alloc_func(cFXTabItem.klass, _wrap_FXTabItem_allocate);
    rb_define_method(cFXTabItem.klass, "initialize", VALUEFUNC(_wrap_new_FXTabItem), -1);
    rb_define_method(cFXTabItem.klass, "onPaint", VALUEFUNC(_wrap_FXTabItem_onPaint), -1);
    rb_define_method(cFXTabItem.klass, "onFocusIn", VALUEFUNC(_wrap_FXTabItem_onFocusIn), -1);
    rb_define_method(cFXTabItem.klass, "onFocusOut", VALUEFUNC(_wrap_FXTabItem_onFocusOut), -1);
    rb_define_method(cFXTabItem.klass, "onUngrabbed", VALUEFUNC(_wrap_FXTabItem_onUngrabbed), -1);
    rb_define_method(cFXTabItem.klass, "onLeftBtnPress", VALUEFUNC(_wrap_FXTabItem_onLeftBtnPress), -1);
    rb_define_method(cFXTabItem.klass, "onLeftBtnRelease", VALUEFUNC(_wrap_FXTabItem_onLeftBtnRelease), -1);
    rb_define_method(cFXTabItem.klass, "onKeyPress", VALUEFUNC(_wrap_FXTabItem_onKeyPress), -1);
    rb_define_method(cFXTabItem.klass, "onKeyRelease", VALUEFUNC(_wrap_FXTabItem_onKeyRelease), -1);
    rb_define_method(cFXTabItem.klass, "onHotKeyPress", VALUEFUNC(_wrap_FXTabItem_onHotKeyPress), -1);
    rb_define_method(cFXTabItem.klass, "onHotKeyRelease", VALUEFUNC(_wrap_FXTabItem_onHotKeyRelease), -1);
    rb_define_method(cFXTabItem.klass, "getTabOrientation", VALUEFUNC(_wrap_FXTabItem_getTabOrientation), -1);
    rb_define_method(cFXTabItem.klass, "setTabOrientation", VALUEFUNC(_wrap_FXTabItem_setTabOrientation), -1);
    rb_define_method(cFXTabItem.klass, "save", VALUEFUNC(_wrap_FXTabItem_save), -1);
    rb_define_method(cFXTabItem.klass, "load", VALUEFUNC(_wrap_FXTabItem_load), -1);
    rb_define_method(cFXTabItem.klass, "create", VALUEFUNC(_wrap_FXTabItem_create), -1);
    rb_define_method(cFXTabItem.klass, "detach", VALUEFUNC(_wrap_FXTabItem_detach), -1);
    rb_define_method(cFXTabItem.klass, "destroy", VALUEFUNC(_wrap_FXTabItem_destroy), -1);
    rb_define_method(cFXTabItem.klass, "resize", VALUEFUNC(_wrap_FXTabItem_resize), -1);
    rb_define_method(cFXTabItem.klass, "getDefaultWidth", VALUEFUNC(_wrap_FXTabItem_getDefaultWidth), -1);
    rb_define_method(cFXTabItem.klass, "getDefaultHeight", VALUEFUNC(_wrap_FXTabItem_getDefaultHeight), -1);
    rb_define_method(cFXTabItem.klass, "getWidthForHeight", VALUEFUNC(_wrap_FXTabItem_getWidthForHeight), -1);
    rb_define_method(cFXTabItem.klass, "getHeightForWidth", VALUEFUNC(_wrap_FXTabItem_getHeightForWidth), -1);
    rb_define_method(cFXTabItem.klass, "canFocus", VALUEFUNC(_wrap_FXTabItem_canFocus), -1);
    rb_define_method(cFXTabItem.klass, "setFocus", VALUEFUNC(_wrap_FXTabItem_setFocus), -1);
    rb_define_method(cFXTabItem.klass, "killFocus", VALUEFUNC(_wrap_FXTabItem_killFocus), -1);
    rb_define_method(cFXTabItem.klass, "setDefault", VALUEFUNC(_wrap_FXTabItem_setDefault), -1);
    rb_define_method(cFXTabItem.klass, "enable", VALUEFUNC(_wrap_FXTabItem_enable), -1);
    rb_define_method(cFXTabItem.klass, "disable", VALUEFUNC(_wrap_FXTabItem_disable), -1);
    rb_define_method(cFXTabItem.klass, "raiseWindow", VALUEFUNC(_wrap_FXTabItem_raiseWindow), -1);
    rb_define_method(cFXTabItem.klass, "lower", VALUEFUNC(_wrap_FXTabItem_lower), -1);
    rb_define_method(cFXTabItem.klass, "move", VALUEFUNC(_wrap_FXTabItem_move), -1);
    rb_define_method(cFXTabItem.klass, "position", VALUEFUNC(_wrap_FXTabItem_position), -1);
    rb_define_method(cFXTabItem.klass, "layout", VALUEFUNC(_wrap_FXTabItem_layout), -1);
    rb_define_method(cFXTabItem.klass, "recalc", VALUEFUNC(_wrap_FXTabItem_recalc), -1);
    rb_define_method(cFXTabItem.klass, "reparent", VALUEFUNC(_wrap_FXTabItem_reparent), -1);
    rb_define_method(cFXTabItem.klass, "show", VALUEFUNC(_wrap_FXTabItem_show), -1);
    rb_define_method(cFXTabItem.klass, "hide", VALUEFUNC(_wrap_FXTabItem_hide), -1);
    rb_define_method(cFXTabItem.klass, "isComposite", VALUEFUNC(_wrap_FXTabItem_isComposite), -1);
    rb_define_method(cFXTabItem.klass, "contains", VALUEFUNC(_wrap_FXTabItem_contains), -1);
    rb_define_method(cFXTabItem.klass, "doesSaveUnder", VALUEFUNC(_wrap_FXTabItem_doesSaveUnder), -1);
    rb_define_method(cFXTabItem.klass, "setBackColor", VALUEFUNC(_wrap_FXTabItem_setBackColor), -1);
    cFXTabItem.mark = (void (*)(void *)) FXRbTabItem::markfunc;
    cFXTabItem.destroy = (void (*)(void *)) FXRbObject::freefunc;
    rb_define_const(mFox,"TOGGLEBUTTON_AUTOGRAY", INT2NUM(TOGGLEBUTTON_AUTOGRAY));
    rb_define_const(mFox,"TOGGLEBUTTON_AUTOHIDE", INT2NUM(TOGGLEBUTTON_AUTOHIDE));
    rb_define_const(mFox,"TOGGLEBUTTON_TOOLBAR", INT2NUM(TOGGLEBUTTON_TOOLBAR));
    rb_define_const(mFox,"TOGGLEBUTTON_KEEPSTATE", INT2NUM(TOGGLEBUTTON_KEEPSTATE));
    rb_define_const(mFox,"TOGGLEBUTTON_NORMAL", INT2NUM(TOGGLEBUTTON_NORMAL));
    
    cFXToggleButton.klass = rb_define_class_under(mFox, "FXToggleButton", ((swig_class *) SWIGTYPE_p_FXLabel->clientdata)->klass);
    SWIG_TypeClientData(SWIGTYPE_p_FXToggleButton, (void *) &cFXToggleButton);
    rb_define_alloc_func(cFXToggleButton.klass, _wrap_FXToggleButton_allocate);
    rb_define_method(cFXToggleButton.klass, "initialize", VALUEFUNC(_wrap_new_FXToggleButton), -1);
    rb_define_method(cFXToggleButton.klass, "onPaint", VALUEFUNC(_wrap_FXToggleButton_onPaint), -1);
    rb_define_method(cFXToggleButton.klass, "onUpdate", VALUEFUNC(_wrap_FXToggleButton_onUpdate), -1);
    rb_define_method(cFXToggleButton.klass, "onEnter", VALUEFUNC(_wrap_FXToggleButton_onEnter), -1);
    rb_define_method(cFXToggleButton.klass, "onLeave", VALUEFUNC(_wrap_FXToggleButton_onLeave), -1);
    rb_define_method(cFXToggleButton.klass, "onFocusIn", VALUEFUNC(_wrap_FXToggleButton_onFocusIn), -1);
    rb_define_method(cFXToggleButton.klass, "onFocusOut", VALUEFUNC(_wrap_FXToggleButton_onFocusOut), -1);
    rb_define_method(cFXToggleButton.klass, "onUngrabbed", VALUEFUNC(_wrap_FXToggleButton_onUngrabbed), -1);
    rb_define_method(cFXToggleButton.klass, "onLeftBtnPress", VALUEFUNC(_wrap_FXToggleButton_onLeftBtnPress), -1);
    rb_define_method(cFXToggleButton.klass, "onLeftBtnRelease", VALUEFUNC(_wrap_FXToggleButton_onLeftBtnRelease), -1);
    rb_define_method(cFXToggleButton.klass, "onKeyPress", VALUEFUNC(_wrap_FXToggleButton_onKeyPress), -1);
    rb_define_method(cFXToggleButton.klass, "onKeyRelease", VALUEFUNC(_wrap_FXToggleButton_onKeyRelease), -1);
    rb_define_method(cFXToggleButton.klass, "onHotKeyPress", VALUEFUNC(_wrap_FXToggleButton_onHotKeyPress), -1);
    rb_define_method(cFXToggleButton.klass, "onHotKeyRelease", VALUEFUNC(_wrap_FXToggleButton_onHotKeyRelease), -1);
    rb_define_method(cFXToggleButton.klass, "onCheck", VALUEFUNC(_wrap_FXToggleButton_onCheck), -1);
    rb_define_method(cFXToggleButton.klass, "onUncheck", VALUEFUNC(_wrap_FXToggleButton_onUncheck), -1);
    rb_define_method(cFXToggleButton.klass, "onQueryHelp", VALUEFUNC(_wrap_FXToggleButton_onQueryHelp), -1);
    rb_define_method(cFXToggleButton.klass, "onQueryTip", VALUEFUNC(_wrap_FXToggleButton_onQueryTip), -1);
    rb_define_method(cFXToggleButton.klass, "onCmdSetValue", VALUEFUNC(_wrap_FXToggleButton_onCmdSetValue), -1);
    rb_define_method(cFXToggleButton.klass, "onCmdSetIntValue", VALUEFUNC(_wrap_FXToggleButton_onCmdSetIntValue), -1);
    rb_define_method(cFXToggleButton.klass, "onCmdGetIntValue", VALUEFUNC(_wrap_FXToggleButton_onCmdGetIntValue), -1);
    rb_define_method(cFXToggleButton.klass, "setAltText", VALUEFUNC(_wrap_FXToggleButton_setAltText), -1);
    rb_define_method(cFXToggleButton.klass, "getAltText", VALUEFUNC(_wrap_FXToggleButton_getAltText), -1);
    rb_define_method(cFXToggleButton.klass, "setAltIcon", VALUEFUNC(_wrap_FXToggleButton_setAltIcon), -1);
    rb_define_method(cFXToggleButton.klass, "getAltIcon", VALUEFUNC(_wrap_FXToggleButton_getAltIcon), -1);
    rb_define_method(cFXToggleButton.klass, "setState", VALUEFUNC(_wrap_FXToggleButton_setState), -1);
    rb_define_method(cFXToggleButton.klass, "getState", VALUEFUNC(_wrap_FXToggleButton_getState), -1);
    rb_define_method(cFXToggleButton.klass, "setAltHelpText", VALUEFUNC(_wrap_FXToggleButton_setAltHelpText), -1);
    rb_define_method(cFXToggleButton.klass, "getAltHelpText", VALUEFUNC(_wrap_FXToggleButton_getAltHelpText), -1);
    rb_define_method(cFXToggleButton.klass, "setAltTipText", VALUEFUNC(_wrap_FXToggleButton_setAltTipText), -1);
    rb_define_method(cFXToggleButton.klass, "getAltTipText", VALUEFUNC(_wrap_FXToggleButton_getAltTipText), -1);
    rb_define_method(cFXToggleButton.klass, "setToggleStyle", VALUEFUNC(_wrap_FXToggleButton_setToggleStyle), -1);
    rb_define_method(cFXToggleButton.klass, "getToggleStyle", VALUEFUNC(_wrap_FXToggleButton_getToggleStyle), -1);
    rb_define_method(cFXToggleButton.klass, "save", VALUEFUNC(_wrap_FXToggleButton_save), -1);
    rb_define_method(cFXToggleButton.klass, "load", VALUEFUNC(_wrap_FXToggleButton_load), -1);
    rb_define_method(cFXToggleButton.klass, "create", VALUEFUNC(_wrap_FXToggleButton_create), -1);
    rb_define_method(cFXToggleButton.klass, "detach", VALUEFUNC(_wrap_FXToggleButton_detach), -1);
    rb_define_method(cFXToggleButton.klass, "destroy", VALUEFUNC(_wrap_FXToggleButton_destroy), -1);
    rb_define_method(cFXToggleButton.klass, "resize", VALUEFUNC(_wrap_FXToggleButton_resize), -1);
    rb_define_method(cFXToggleButton.klass, "getDefaultWidth", VALUEFUNC(_wrap_FXToggleButton_getDefaultWidth), -1);
    rb_define_method(cFXToggleButton.klass, "getDefaultHeight", VALUEFUNC(_wrap_FXToggleButton_getDefaultHeight), -1);
    rb_define_method(cFXToggleButton.klass, "getWidthForHeight", VALUEFUNC(_wrap_FXToggleButton_getWidthForHeight), -1);
    rb_define_method(cFXToggleButton.klass, "getHeightForWidth", VALUEFUNC(_wrap_FXToggleButton_getHeightForWidth), -1);
    rb_define_method(cFXToggleButton.klass, "canFocus", VALUEFUNC(_wrap_FXToggleButton_canFocus), -1);
    rb_define_method(cFXToggleButton.klass, "setFocus", VALUEFUNC(_wrap_FXToggleButton_setFocus), -1);
    rb_define_method(cFXToggleButton.klass, "killFocus", VALUEFUNC(_wrap_FXToggleButton_killFocus), -1);
    rb_define_method(cFXToggleButton.klass, "setDefault", VALUEFUNC(_wrap_FXToggleButton_setDefault), -1);
    rb_define_method(cFXToggleButton.klass, "enable", VALUEFUNC(_wrap_FXToggleButton_enable), -1);
    rb_define_method(cFXToggleButton.klass, "disable", VALUEFUNC(_wrap_FXToggleButton_disable), -1);
    rb_define_method(cFXToggleButton.klass, "raiseWindow", VALUEFUNC(_wrap_FXToggleButton_raiseWindow), -1);
    rb_define_method(cFXToggleButton.klass, "lower", VALUEFUNC(_wrap_FXToggleButton_lower), -1);
    rb_define_method(cFXToggleButton.klass, "move", VALUEFUNC(_wrap_FXToggleButton_move), -1);
    rb_define_method(cFXToggleButton.klass, "position", VALUEFUNC(_wrap_FXToggleButton_position), -1);
    rb_define_method(cFXToggleButton.klass, "layout", VALUEFUNC(_wrap_FXToggleButton_layout), -1);
    rb_define_method(cFXToggleButton.klass, "recalc", VALUEFUNC(_wrap_FXToggleButton_recalc), -1);
    rb_define_method(cFXToggleButton.klass, "reparent", VALUEFUNC(_wrap_FXToggleButton_reparent), -1);
    rb_define_method(cFXToggleButton.klass, "show", VALUEFUNC(_wrap_FXToggleButton_show), -1);
    rb_define_method(cFXToggleButton.klass, "hide", VALUEFUNC(_wrap_FXToggleButton_hide), -1);
    rb_define_method(cFXToggleButton.klass, "isComposite", VALUEFUNC(_wrap_FXToggleButton_isComposite), -1);
    rb_define_method(cFXToggleButton.klass, "contains", VALUEFUNC(_wrap_FXToggleButton_contains), -1);
    rb_define_method(cFXToggleButton.klass, "doesSaveUnder", VALUEFUNC(_wrap_FXToggleButton_doesSaveUnder), -1);
    rb_define_method(cFXToggleButton.klass, "setBackColor", VALUEFUNC(_wrap_FXToggleButton_setBackColor), -1);
    cFXToggleButton.mark = (void (*)(void *)) FXRbToggleButton::markfunc;
    cFXToggleButton.destroy = (void (*)(void *)) FXRbObject::freefunc;
    
    SWIGTYPE_p_FXToggleButton->dcast = (swig_dycast_func) FXToggleButton_dynamic_cast;
    
    
    cFXTriStateButton.klass = rb_define_class_under(mFox, "FXTriStateButton", ((swig_class *) SWIGTYPE_p_FXToggleButton->clientdata)->klass);
    SWIG_TypeClientData(SWIGTYPE_p_FXTriStateButton, (void *) &cFXTriStateButton);
    rb_define_alloc_func(cFXTriStateButton.klass, _wrap_FXTriStateButton_allocate);
    rb_define_method(cFXTriStateButton.klass, "initialize", VALUEFUNC(_wrap_new_FXTriStateButton), -1);
    rb_define_method(cFXTriStateButton.klass, "onPaint", VALUEFUNC(_wrap_FXTriStateButton_onPaint), -1);
    rb_define_method(cFXTriStateButton.klass, "onUnknown", VALUEFUNC(_wrap_FXTriStateButton_onUnknown), -1);
    rb_define_method(cFXTriStateButton.klass, "onQueryHelp", VALUEFUNC(_wrap_FXTriStateButton_onQueryHelp), -1);
    rb_define_method(cFXTriStateButton.klass, "onQueryTip", VALUEFUNC(_wrap_FXTriStateButton_onQueryTip), -1);
    rb_define_method(cFXTriStateButton.klass, "setMaybeText", VALUEFUNC(_wrap_FXTriStateButton_setMaybeText), -1);
    rb_define_method(cFXTriStateButton.klass, "getMaybeText", VALUEFUNC(_wrap_FXTriStateButton_getMaybeText), -1);
    rb_define_method(cFXTriStateButton.klass, "setMaybeIcon", VALUEFUNC(_wrap_FXTriStateButton_setMaybeIcon), -1);
    rb_define_method(cFXTriStateButton.klass, "getMaybeIcon", VALUEFUNC(_wrap_FXTriStateButton_getMaybeIcon), -1);
    rb_define_method(cFXTriStateButton.klass, "setMaybeHelpText", VALUEFUNC(_wrap_FXTriStateButton_setMaybeHelpText), -1);
    rb_define_method(cFXTriStateButton.klass, "getMaybeHelpText", VALUEFUNC(_wrap_FXTriStateButton_getMaybeHelpText), -1);
    rb_define_method(cFXTriStateButton.klass, "setMaybeTipText", VALUEFUNC(_wrap_FXTriStateButton_setMaybeTipText), -1);
    rb_define_method(cFXTriStateButton.klass, "getMaybeTipText", VALUEFUNC(_wrap_FXTriStateButton_getMaybeTipText), -1);
    cFXTriStateButton.mark = (void (*)(void *)) FXRbTriStateButton::markfunc;
    cFXTriStateButton.destroy = (void (*)(void *)) FXRbObject::freefunc;
    
    cFXPicker.klass = rb_define_class_under(mFox, "FXPicker", ((swig_class *) SWIGTYPE_p_FXButton->clientdata)->klass);
    SWIG_TypeClientData(SWIGTYPE_p_FXPicker, (void *) &cFXPicker);
    rb_define_alloc_func(cFXPicker.klass, _wrap_FXPicker_allocate);
    rb_define_method(cFXPicker.klass, "initialize", VALUEFUNC(_wrap_new_FXPicker), -1);
    rb_define_method(cFXPicker.klass, "onMotion", VALUEFUNC(_wrap_FXPicker_onMotion), -1);
    rb_define_method(cFXPicker.klass, "onLeftBtnPress", VALUEFUNC(_wrap_FXPicker_onLeftBtnPress), -1);
    rb_define_method(cFXPicker.klass, "onLeftBtnRelease", VALUEFUNC(_wrap_FXPicker_onLeftBtnRelease), -1);
    rb_define_method(cFXPicker.klass, "onEnter", VALUEFUNC(_wrap_FXPicker_onEnter), -1);
    rb_define_method(cFXPicker.klass, "onLeave", VALUEFUNC(_wrap_FXPicker_onLeave), -1);
    rb_define_method(cFXPicker.klass, "save", VALUEFUNC(_wrap_FXPicker_save), -1);
    rb_define_method(cFXPicker.klass, "load", VALUEFUNC(_wrap_FXPicker_load), -1);
    rb_define_method(cFXPicker.klass, "create", VALUEFUNC(_wrap_FXPicker_create), -1);
    rb_define_method(cFXPicker.klass, "detach", VALUEFUNC(_wrap_FXPicker_detach), -1);
    rb_define_method(cFXPicker.klass, "destroy", VALUEFUNC(_wrap_FXPicker_destroy), -1);
    rb_define_method(cFXPicker.klass, "resize", VALUEFUNC(_wrap_FXPicker_resize), -1);
    rb_define_method(cFXPicker.klass, "getDefaultWidth", VALUEFUNC(_wrap_FXPicker_getDefaultWidth), -1);
    rb_define_method(cFXPicker.klass, "getDefaultHeight", VALUEFUNC(_wrap_FXPicker_getDefaultHeight), -1);
    rb_define_method(cFXPicker.klass, "getWidthForHeight", VALUEFUNC(_wrap_FXPicker_getWidthForHeight), -1);
    rb_define_method(cFXPicker.klass, "getHeightForWidth", VALUEFUNC(_wrap_FXPicker_getHeightForWidth), -1);
    rb_define_method(cFXPicker.klass, "canFocus", VALUEFUNC(_wrap_FXPicker_canFocus), -1);
    rb_define_method(cFXPicker.klass, "setFocus", VALUEFUNC(_wrap_FXPicker_setFocus), -1);
    rb_define_method(cFXPicker.klass, "killFocus", VALUEFUNC(_wrap_FXPicker_killFocus), -1);
    rb_define_method(cFXPicker.klass, "setDefault", VALUEFUNC(_wrap_FXPicker_setDefault), -1);
    rb_define_method(cFXPicker.klass, "enable", VALUEFUNC(_wrap_FXPicker_enable), -1);
    rb_define_method(cFXPicker.klass, "disable", VALUEFUNC(_wrap_FXPicker_disable), -1);
    rb_define_method(cFXPicker.klass, "raiseWindow", VALUEFUNC(_wrap_FXPicker_raiseWindow), -1);
    rb_define_method(cFXPicker.klass, "lower", VALUEFUNC(_wrap_FXPicker_lower), -1);
    rb_define_method(cFXPicker.klass, "move", VALUEFUNC(_wrap_FXPicker_move), -1);
    rb_define_method(cFXPicker.klass, "position", VALUEFUNC(_wrap_FXPicker_position), -1);
    rb_define_method(cFXPicker.klass, "layout", VALUEFUNC(_wrap_FXPicker_layout), -1);
    rb_define_method(cFXPicker.klass, "recalc", VALUEFUNC(_wrap_FXPicker_recalc), -1);
    rb_define_method(cFXPicker.klass, "reparent", VALUEFUNC(_wrap_FXPicker_reparent), -1);
    rb_define_method(cFXPicker.klass, "show", VALUEFUNC(_wrap_FXPicker_show), -1);
    rb_define_method(cFXPicker.klass, "hide", VALUEFUNC(_wrap_FXPicker_hide), -1);
    rb_define_method(cFXPicker.klass, "isComposite", VALUEFUNC(_wrap_FXPicker_isComposite), -1);
    rb_define_method(cFXPicker.klass, "contains", VALUEFUNC(_wrap_FXPicker_contains), -1);
    rb_define_method(cFXPicker.klass, "doesSaveUnder", VALUEFUNC(_wrap_FXPicker_doesSaveUnder), -1);
    rb_define_method(cFXPicker.klass, "setBackColor", VALUEFUNC(_wrap_FXPicker_setBackColor), -1);
    cFXPicker.mark = (void (*)(void *)) FXRbPicker::markfunc;
    cFXPicker.destroy = (void (*)(void *)) FXRbObject::freefunc;
}

