/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 1.3.22
 * 
 * This file is not intended to be easily readable and contains a number of 
 * coding conventions designed to improve portability and efficiency. Do not make
 * changes to this file unless you know what you are doing--modify the SWIG 
 * interface file instead. 
 * ----------------------------------------------------------------------------- */

#define SWIG_NOINCLUDE

#ifdef __cplusplus
template<class T> class SwigValueWrapper {
    T *tt;
public:
    SwigValueWrapper() : tt(0) { }
    SwigValueWrapper(const SwigValueWrapper<T>& rhs) : tt(new T(*rhs.tt)) { }
    SwigValueWrapper(const T& t) : tt(new T(t)) { }
    ~SwigValueWrapper() { delete tt; } 
    SwigValueWrapper& operator=(const T& t) { delete tt; tt = new T(t); return *this; }
    operator T&() const { return *tt; }
    T *operator&() { return tt; }
private:
    SwigValueWrapper& operator=(const SwigValueWrapper<T>& rhs);
};                                                    
#endif

/* ruby.swg */
/* Implementation : RUBY */
#define SWIGRUBY 1

#include "ruby.h"

/* Flags for pointer conversion */
#define SWIG_POINTER_EXCEPTION     0x1
#define SWIG_POINTER_DISOWN        0x2

#define NUM2USHRT(n) (\
    (0 <= NUM2UINT(n) && NUM2UINT(n) <= USHRT_MAX)\
    ? (unsigned short) NUM2UINT(n) \
    : (rb_raise(rb_eArgError, "integer %d out of range of `unsigned short'",\
               NUM2UINT(n)), (short)0)\
)

#define NUM2SHRT(n) (\
    (SHRT_MIN <= NUM2INT(n) && NUM2INT(n) <= SHRT_MAX)\
    ? (short)NUM2INT(n)\
    : (rb_raise(rb_eArgError, "integer %d out of range of `short'",\
               NUM2INT(n)), (short)0)\
)

/* Ruby 1.7 defines NUM2LL(), LL2NUM() and ULL2NUM() macros */
#ifndef NUM2LL
#define NUM2LL(x) NUM2LONG((x))
#endif
#ifndef LL2NUM
#define LL2NUM(x) INT2NUM((long) (x))
#endif
#ifndef ULL2NUM
#define ULL2NUM(x) UINT2NUM((unsigned long) (x))
#endif

/* Ruby 1.7 doesn't (yet) define NUM2ULL() */
#ifndef NUM2ULL
#ifdef HAVE_LONG_LONG
#define NUM2ULL(x) rb_num2ull((x))
#else
#define NUM2ULL(x) NUM2ULONG(x)
#endif
#endif

/*
 * Need to be very careful about how these macros are defined, especially
 * when compiling C++ code or C code with an ANSI C compiler.
 *
 * VALUEFUNC(f) is a macro used to typecast a C function that implements
 * a Ruby method so that it can be passed as an argument to API functions
 * like rb_define_method() and rb_define_singleton_method().
 *
 * VOIDFUNC(f) is a macro used to typecast a C function that implements
 * either the "mark" or "free" stuff for a Ruby Data object, so that it
 * can be passed as an argument to API functions like Data_Wrap_Struct()
 * and Data_Make_Struct().
 */
 
#ifdef __cplusplus
#  ifndef RUBY_METHOD_FUNC /* These definitions should work for Ruby 1.4.6 */
#    define PROTECTFUNC(f) ((VALUE (*)()) f)
#    define VALUEFUNC(f) ((VALUE (*)()) f)
#    define VOIDFUNC(f)  ((void (*)()) f)
#  else
#    ifndef ANYARGS /* These definitions should work for Ruby 1.6 */
#      define PROTECTFUNC(f) ((VALUE (*)()) f)
#      define VALUEFUNC(f) ((VALUE (*)()) f)
#      define VOIDFUNC(f)  ((RUBY_DATA_FUNC) f)
#    else /* These definitions should work for Ruby 1.7+ */
#      define PROTECTFUNC(f) ((VALUE (*)(VALUE)) f)
#      define VALUEFUNC(f) ((VALUE (*)(ANYARGS)) f)
#      define VOIDFUNC(f)  ((RUBY_DATA_FUNC) f)
#    endif
#  endif
#else
#  define VALUEFUNC(f) (f)
#  define VOIDFUNC(f) (f)
#endif

typedef struct {
  VALUE klass;
  VALUE mImpl;
  void  (*mark)(void *);
  void  (*destroy)(void *);
} swig_class;

/* Don't use for expressions have side effect */
#ifndef RB_STRING_VALUE
#define RB_STRING_VALUE(s) (TYPE(s) == T_STRING ? (s) : (*(volatile VALUE *)&(s) = rb_str_to_str(s)))
#endif
#ifndef StringValue
#define StringValue(s) RB_STRING_VALUE(s)
#endif
#ifndef StringValuePtr
#define StringValuePtr(s) RSTRING(RB_STRING_VALUE(s))->ptr
#endif
#ifndef StringValueLen
#define StringValueLen(s) RSTRING(RB_STRING_VALUE(s))->len
#endif
#ifndef SafeStringValue
#define SafeStringValue(v) do {\
    StringValue(v);\
    rb_check_safe_str(v);\
} while (0)
#endif

#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
#define rb_define_alloc_func(klass, func) rb_define_singleton_method((klass), "new", VALUEFUNC((func)), -1)
#define rb_undef_alloc_func(klass) rb_undef_method(CLASS_OF((klass)), "new")
#endif

/* Contract support */

#define SWIG_contract_assert(expr, msg) if (!(expr)) { rb_raise(rb_eRuntimeError, (char *) msg ); } else


/*************************************************************** -*- c -*-
 * ruby/precommon.swg
 *
 * Rename all exported symbols from common.swg, to avoid symbol
 * clashes if multiple interpreters are included
 *
 ************************************************************************/

#define SWIG_TypeRegister    SWIG_Ruby_TypeRegister
#define SWIG_TypeCheck       SWIG_Ruby_TypeCheck
#define SWIG_TypeCast        SWIG_Ruby_TypeCast
#define SWIG_TypeDynamicCast SWIG_Ruby_TypeDynamicCast
#define SWIG_TypeName        SWIG_Ruby_TypeName
#define SWIG_TypePrettyName  SWIG_Ruby_TypePrettyName
#define SWIG_TypeQuery       SWIG_Ruby_TypeQuery
#define SWIG_TypeClientData  SWIG_Ruby_TypeClientData
#define SWIG_PackData        SWIG_Ruby_PackData 
#define SWIG_UnpackData      SWIG_Ruby_UnpackData 

/* Also rename all exported symbols from rubydef.swig */

/* Common SWIG API */
#define SWIG_ConvertPtr(obj, pp, type, flags) \
  SWIG_Ruby_ConvertPtr(obj, pp, type, flags)
#define SWIG_NewPointerObj(p, type, flags) \
  SWIG_Ruby_NewPointerObj(p, type, flags)
#define SWIG_MustGetPtr(p, type, argnum, flags) \
  SWIG_Ruby_MustGetPtr(p, type, argnum, flags)

/* Ruby-specific SWIG API */

#define SWIG_InitRuntime() \
  SWIG_Ruby_InitRuntime()
#define SWIG_define_class(ty) \
  SWIG_Ruby_define_class(ty)
#define SWIG_NewClassInstance(value, ty) \
  SWIG_Ruby_NewClassInstance(value, ty)
#define SWIG_MangleStr(value) \
  SWIG_Ruby_MangleStr(value)
#define SWIG_CheckConvert(value, ty) \
  SWIG_Ruby_CheckConvert(value, ty)
#define SWIG_NewPackedObj(ptr, sz, ty) \
  SWIG_Ruby_NewPackedObj(ptr, sz, ty)
#define SWIG_ConvertPacked(obj, ptr, sz, ty, flags) \
  SWIG_Ruby_ConvertPacked(obj, ptr, sz, ty, flags)


/***********************************************************************
 * common.swg
 *
 *     This file contains generic SWIG runtime support for pointer
 *     type checking as well as a few commonly used macros to control
 *     external linkage.
 *
 * Author : David Beazley (beazley@cs.uchicago.edu)
 *
 * Copyright (c) 1999-2000, The University of Chicago
 * 
 * This file may be freely redistributed without license or fee provided
 * this copyright message remains intact.
 ************************************************************************/

#include <string.h>

#if defined(_WIN32) || defined(__WIN32__) || defined(__CYGWIN__)
#  if defined(_MSC_VER) || defined(__GNUC__)
#    if defined(STATIC_LINKED)
#      define SWIGEXPORT(a) a
#      define SWIGIMPORT(a) extern a
#    else
#      define SWIGEXPORT(a) __declspec(dllexport) a
#      define SWIGIMPORT(a) extern a
#    endif
#  else
#    if defined(__BORLANDC__)
#      define SWIGEXPORT(a) a _export
#      define SWIGIMPORT(a) a _export
#    else
#      define SWIGEXPORT(a) a
#      define SWIGIMPORT(a) a
#    endif
#  endif
#else
#  define SWIGEXPORT(a) a
#  define SWIGIMPORT(a) a
#endif

#ifdef SWIG_GLOBAL
#  define SWIGRUNTIME(a) SWIGEXPORT(a)
#else
#  define SWIGRUNTIME(a) static a
#endif

#ifdef __cplusplus
extern "C" {
#endif

typedef void *(*swig_converter_func)(void *);
typedef struct swig_type_info *(*swig_dycast_func)(void **);

typedef struct swig_type_info {
  const char             *name;
  swig_converter_func     converter;
  const char             *str;
  void                   *clientdata;
  swig_dycast_func        dcast;
  struct swig_type_info  *next;
  struct swig_type_info  *prev;
} swig_type_info;

#ifdef SWIG_NOINCLUDE

SWIGIMPORT(swig_type_info *) SWIG_TypeRegister(swig_type_info *);
SWIGIMPORT(swig_type_info *) SWIG_TypeCheck(char *c, swig_type_info *);
SWIGIMPORT(void *)           SWIG_TypeCast(swig_type_info *, void *);
SWIGIMPORT(swig_type_info *) SWIG_TypeDynamicCast(swig_type_info *, void **);
SWIGIMPORT(const char *)     SWIG_TypeName(const swig_type_info *);
SWIGIMPORT(const char *)     SWIG_TypePrettyName(const swig_type_info *);
SWIGIMPORT(swig_type_info *) SWIG_TypeQuery(const char *);
SWIGIMPORT(void)             SWIG_TypeClientData(swig_type_info *, void *);
SWIGIMPORT(char *)           SWIG_PackData(char *, void *, int);
SWIGIMPORT(char *)           SWIG_UnpackData(char *, void *, int);

#else

static swig_type_info *swig_type_list = 0;
static swig_type_info **swig_type_list_handle = &swig_type_list;

/* Register a type mapping with the type-checking */
SWIGRUNTIME(swig_type_info *)
SWIG_TypeRegister(swig_type_info *ti) {
  swig_type_info *tc, *head, *ret, *next;
  /* Check to see if this type has already been registered */
  tc = *swig_type_list_handle;
  while (tc) {
    if (strcmp(tc->name, ti->name) == 0) {
      /* Already exists in the table.  Just add additional types to the list */
      if (tc->clientdata) ti->clientdata = tc->clientdata;
      head = tc;
      next = tc->next;
      goto l1;
    }
    tc = tc->prev;
  }
  head = ti;
  next = 0;

  /* Place in list */
  ti->prev = *swig_type_list_handle;
  *swig_type_list_handle = ti;

  /* Build linked lists */
  l1:
  ret = head;
  tc = ti + 1;
  /* Patch up the rest of the links */
  while (tc->name) {
    head->next = tc;
    tc->prev = head;
    head = tc;
    tc++;
  }
  if (next) next->prev = head;
  head->next = next;
  return ret;
}

/* Check the typename */
SWIGRUNTIME(swig_type_info *) 
SWIG_TypeCheck(char *c, swig_type_info *ty) {
  swig_type_info *s;
  if (!ty) return 0;        /* Void pointer */
  s = ty->next;             /* First element always just a name */
  do {
    if (strcmp(s->name,c) == 0) {
      if (s == ty->next) return s;
      /* Move s to the top of the linked list */
      s->prev->next = s->next;
      if (s->next) {
        s->next->prev = s->prev;
      }
      /* Insert s as second element in the list */
      s->next = ty->next;
      if (ty->next) ty->next->prev = s;
      ty->next = s;
      s->prev = ty;
      return s;
    }
    s = s->next;
  } while (s && (s != ty->next));
  return 0;
}

/* Cast a pointer up an inheritance hierarchy */
SWIGRUNTIME(void *) 
SWIG_TypeCast(swig_type_info *ty, void *ptr) {
  if ((!ty) || (!ty->converter)) return ptr;
  return (*ty->converter)(ptr);
}

/* Dynamic pointer casting. Down an inheritance hierarchy */
SWIGRUNTIME(swig_type_info *) 
SWIG_TypeDynamicCast(swig_type_info *ty, void **ptr) {
  swig_type_info *lastty = ty;
  if (!ty || !ty->dcast) return ty;
  while (ty && (ty->dcast)) {
    ty = (*ty->dcast)(ptr);
    if (ty) lastty = ty;
  }
  return lastty;
}

/* Return the name associated with this type */
SWIGRUNTIME(const char *)
SWIG_TypeName(const swig_type_info *ty) {
  return ty->name;
}

/* Return the pretty name associated with this type,
   that is an unmangled type name in a form presentable to the user.
*/
SWIGRUNTIME(const char *)
SWIG_TypePrettyName(const swig_type_info *type) {
  /* The "str" field contains the equivalent pretty names of the
     type, separated by vertical-bar characters.  We choose
     to print the last name, as it is often (?) the most
     specific. */
  if (type->str != NULL) {
    const char *last_name = type->str;
    const char *s;
    for (s = type->str; *s; s++)
      if (*s == '|') last_name = s+1;
    return last_name;
  }
  else
    return type->name;
}

/* 
   Compare two type names skipping the space characters, therefore
   "char*" == "char *" and "Class<int>" == "Class<int >", etc.

   Return 0 when the two name types are equivalent, as in
   strncmp, but skipping ' '.
*/
static int
SWIG_TypeNameComp(const char *f1, const char *l1,
		  const char *f2, const char *l2) {
  for (;(f1 != l1) && (f2 != l2); ++f1, ++f2) {
    while ((*f1 == ' ') && (f1 != l1)) ++f1;
    while ((*f2 == ' ') && (f2 != l2)) ++f2;
    if (*f1 != *f2) return *f1 - *f2;
  }
  return (l1 - f1) - (l2 - f2);
}

/*
  Check type equivalence in a name list like <name1>|<name2>|...
*/
static int
SWIG_TypeEquiv(const char *nb, const char *tb) {
  int equiv = 0;
  const char* te = tb + strlen(tb);
  const char* ne = nb;
  while (!equiv && *ne) {
    for (nb = ne; *ne; ++ne) {
      if (*ne == '|') break;
    }
    equiv = SWIG_TypeNameComp(nb, ne, tb, te) == 0;
    if (*ne) ++ne;
  }
  return equiv;
}
  

/* Search for a swig_type_info structure */
SWIGRUNTIME(swig_type_info *)
SWIG_TypeQuery(const char *name) {
  swig_type_info *ty = *swig_type_list_handle;
  while (ty) {
    if (ty->str && (SWIG_TypeEquiv(ty->str,name))) return ty;
    if (ty->name && (strcmp(name,ty->name) == 0)) return ty;
    ty = ty->prev;
  }
  return 0;
}

/* Set the clientdata field for a type */
SWIGRUNTIME(void)
SWIG_TypeClientData(swig_type_info *ti, void *clientdata) {
  swig_type_info *tc, *equiv;
  if (ti->clientdata == clientdata) return;
  ti->clientdata = clientdata;
  equiv = ti->next;
  while (equiv) {
    if (!equiv->converter) {
      tc = *swig_type_list_handle;
      while (tc) {
        if ((strcmp(tc->name, equiv->name) == 0))
          SWIG_TypeClientData(tc,clientdata);
        tc = tc->prev;
      }
    }
    equiv = equiv->next;
  }
}

/* Pack binary data into a string */
SWIGRUNTIME(char *)
SWIG_PackData(char *c, void *ptr, int sz) {
  static char hex[17] = "0123456789abcdef";
  unsigned char *u = (unsigned char *) ptr;
  const unsigned char *eu =  u + sz;
  register unsigned char uu;
  for (; u != eu; ++u) {
    uu = *u;
    *(c++) = hex[(uu & 0xf0) >> 4];
    *(c++) = hex[uu & 0xf];
  }
  return c;
}

/* Unpack binary data from a string */
SWIGRUNTIME(char *)
SWIG_UnpackData(char *c, void *ptr, int sz) {
  register unsigned char uu = 0;
  register int d;
  unsigned char *u = (unsigned char *) ptr;
  const unsigned char *eu =  u + sz;
  for (; u != eu; ++u) {
    d = *(c++);
    if ((d >= '0') && (d <= '9'))
      uu = ((d - '0') << 4);
    else if ((d >= 'a') && (d <= 'f'))
      uu = ((d - ('a'-10)) << 4);
    d = *(c++);
    if ((d >= '0') && (d <= '9'))
      uu |= (d - '0');
    else if ((d >= 'a') && (d <= 'f'))
      uu |= (d - ('a'-10));
    *u = uu;
  }
  return c;
}

#endif

#ifdef __cplusplus
}
#endif

/* rubydec.swg -*- c -*- */
#ifdef __cplusplus
extern "C" {
#endif

SWIGIMPORT(void)   SWIG_Ruby_InitRuntime(void);
SWIGIMPORT(void)   SWIG_Ruby_define_class(swig_type_info *);
SWIGIMPORT(VALUE)  SWIG_Ruby_NewPointerObj(void *, swig_type_info *, int);
SWIGIMPORT(VALUE)  SWIG_Ruby_NewClassInstance(VALUE, swig_type_info *);
SWIGIMPORT(char *) SWIG_Ruby_MangleStr(VALUE);
SWIGIMPORT(int)    SWIG_Ruby_ConvertPtr(VALUE, void**, swig_type_info *, int);
SWIGIMPORT(void *) SWIG_Ruby_MustGetPtr(VALUE, swig_type_info *, int, int);
SWIGIMPORT(int)    SWIG_Ruby_CheckConvert(VALUE, swig_type_info *);
SWIGIMPORT(VALUE)  SWIG_Ruby_NewPackedObj(void *ptr, int sz, swig_type_info *type);
SWIGIMPORT(void)   SWIG_Ruby_ConvertPacked(VALUE obj, void *ptr, int sz, swig_type_info *ty, int flags);

#ifdef __cplusplus
}
#endif


/* -------- TYPES TABLE (BEGIN) -------- */

#define  SWIGTYPE_p_FXFrame swig_types[0] 
#define  SWIGTYPE_p_FXMDIClient swig_types[1] 
#define  SWIGTYPE_p_FXObject swig_types[2] 
#define  SWIGTYPE_p_FXPopup swig_types[3] 
#define  SWIGTYPE_p_FXMDIChild swig_types[4] 
#define  SWIGTYPE_p_FXMDIDeleteButton swig_types[5] 
#define  SWIGTYPE_p_FXMenuButton swig_types[6] 
#define  SWIGTYPE_p_FXWindow swig_types[7] 
#define  SWIGTYPE_p_FXLabel swig_types[8] 
#define  SWIGTYPE_p_FXComposite swig_types[9] 
#define  SWIGTYPE_p_FXMDIRestoreButton swig_types[10] 
#define  SWIGTYPE_p_FXMDIMaximizeButton swig_types[11] 
#define  SWIGTYPE_p_FXMDIMinimizeButton swig_types[12] 
#define  SWIGTYPE_p_FXMDIWindowButton swig_types[13] 
#define  SWIGTYPE_p_FXId swig_types[14] 
#define  SWIGTYPE_p_FXFont swig_types[15] 
#define  SWIGTYPE_p_FXShell swig_types[16] 
#define  SWIGTYPE_p_FXMDIMenu swig_types[17] 
#define  SWIGTYPE_p_FXButton swig_types[18] 
#define  SWIGTYPE_p_FXStream swig_types[19] 
#define  SWIGTYPE_p_FXDrawable swig_types[20] 
#define  SWIGTYPE_p_FXIcon swig_types[21] 
#define  SWIGTYPE_p_FXMenuPane swig_types[22] 
static swig_type_info *swig_types[24];

/* -------- TYPES TABLE (END) -------- */

#define SWIG_init    Init_mdi
#define SWIG_name    "Mdi"


static void SWIG_AsVal(VALUE obj, int *val)
{
    *val = (int) NUM2INT(obj);
}


#include "FXRbCommon.h"


inline FXColor to_FXColor(VALUE obj){
  if(TYPE(obj)==T_STRING){
    return fxcolorfromname(StringValuePtr(obj));
    }
  else if(TYPE(obj)==T_SYMBOL){
    return fxcolorfromname(rb_id2name(SYM2ID(obj)));
    }
  else{
    return NUM2ULONG(obj);
    }
  }


inline FXString to_FXString(VALUE obj){
  if(!NIL_P(obj)){
    Check_Type(obj,T_STRING);
    return FXString(STR2CSTR(obj));
    }
  else{
    return FXString::null;
    }
  }


inline FXbool to_FXbool(VALUE obj){
  if (obj == Qtrue || obj == Qfalse){
    return (obj == Qtrue) ? TRUE : FALSE;
    }
  else{
    return static_cast<FXbool>(NUM2UINT(obj));
    }
  }


static swig_type_info* FXEventTypeInfo=0;

inline void* to_FXEvent(VALUE obj){
  void* ptr;
  if(!FXEventTypeInfo){
    FXEventTypeInfo=SWIG_TypeQuery("FXEvent *");
    FXASSERT(FXEventTypeInfo!=0);
    }
  SWIG_ConvertPtr(obj,&ptr,FXEventTypeInfo,1);
  return ptr;
  }

FXMDIDeleteButton *new_FXMDIDeleteButton(FXComposite *p,FXObject *tgt,FXSelector sel,FXuint opts,FXint x,FXint y,FXint w,FXint h){
      return new FXRbMDIDeleteButton(p,tgt,sel,opts,x,y,w,h);
      }

swig_class cFXMDIDeleteButton;
static void free_FXMDIDeleteButton(FXMDIDeleteButton *);
FXMDIRestoreButton *new_FXMDIRestoreButton(FXComposite *p,FXObject *tgt,FXSelector sel,FXuint opts,FXint x,FXint y,FXint w,FXint h){
      return new FXRbMDIRestoreButton(p,tgt,sel,opts,x,y,w,h);
      }

swig_class cFXMDIRestoreButton;
static void free_FXMDIRestoreButton(FXMDIRestoreButton *);
FXMDIMaximizeButton *new_FXMDIMaximizeButton(FXComposite *p,FXObject *tgt,FXSelector sel,FXuint opts,FXint x,FXint y,FXint w,FXint h){
      return new FXRbMDIMaximizeButton(p,tgt,sel,opts,x,y,w,h);
      }

swig_class cFXMDIMaximizeButton;
static void free_FXMDIMaximizeButton(FXMDIMaximizeButton *);
FXMDIMinimizeButton *new_FXMDIMinimizeButton(FXComposite *p,FXObject *tgt,FXSelector sel,FXuint opts,FXint x,FXint y,FXint w,FXint h){
      return new FXRbMDIMinimizeButton(p,tgt,sel,opts,x,y,w,h);
      }

swig_class cFXMDIMinimizeButton;
static void free_FXMDIMinimizeButton(FXMDIMinimizeButton *);
FXMDIWindowButton *new_FXMDIWindowButton(FXComposite *p,FXPopup *pup,FXObject *tgt,FXSelector sel,FXuint opts,FXint x,FXint y,FXint w,FXint h){
      return new FXRbMDIWindowButton(p,pup,tgt,sel,opts,x,y,w,h);
      }

swig_class cFXMDIWindowButton;
static void free_FXMDIWindowButton(FXMDIWindowButton *);
FXMDIMenu *new_FXMDIMenu(FXWindow *owner,FXObject *tgt){
      return new FXRbMDIMenu(owner,tgt);
      }

swig_class cFXMDIMenu;
static void free_FXMDIMenu(FXMDIMenu *);
FXMDIClient *new_FXMDIClient(FXComposite *p,FXuint opts,FXint x,FXint y,FXint w,FXint h){
      return new FXRbMDIClient(p,opts,x,y,w,h);
      }

swig_class cFXMDIClient;
static void free_FXMDIClient(FXMDIClient *);
FXMDIChild *new_FXMDIChild(FXMDIClient *p,FXString const &name,FXIcon *ic,FXPopup *pup,FXuint opts,FXint x,FXint y,FXint w,FXint h){
      return new FXRbMDIChild(p,name,ic,pup,opts,x,y,w,h);
      }

swig_class cFXMDIChild;
static void free_FXMDIChild(FXMDIChild *);
static VALUE _wrap_FXMDIDeleteButton_onPaint(int argc, VALUE *argv, VALUE self) {
    FXMDIDeleteButton *arg1 = (FXMDIDeleteButton *) 0 ; FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ;
    void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil; if ((argc < 3) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIDeleteButton, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onPaint(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE _wrap_FXMDIDeleteButton_allocate(VALUE self) {
#else
     static VALUE _wrap_FXMDIDeleteButton_allocate(int argc, VALUE *argv, VALUE self) {
#endif
         VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_FXMDIDeleteButton);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
         return vresult; }
static VALUE _wrap_new_FXMDIDeleteButton(int argc, VALUE *argv, VALUE self) { FXComposite *arg1 = (FXComposite *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 = (FXSelector) 0 ; FXuint arg4 = (FXuint) FRAME_RAISED ;
    FXint arg5 = (FXint) 0 ; FXint arg6 = (FXint) 0 ; FXint arg7 = (FXint) 0 ; FXint arg8 = (FXint) 0 ;
    FXMDIDeleteButton *result; if ((argc < 1) || (argc > 8)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXComposite, 1); if (argc > 1) {
        SWIG_ConvertPtr(argv[1], (void **) &arg2, SWIGTYPE_p_FXObject, 1); }  if (argc > 2) { arg3 = NUM2UINT(argv[2]); } 
    if (argc > 3) { arg4 = NUM2UINT(argv[3]); }  if (argc > 4) { arg5 = NUM2INT(argv[4]); }  if (argc > 5) {
        arg6 = NUM2INT(argv[5]); }  if (argc > 6) { arg7 = NUM2INT(argv[6]); }  if (argc > 7) { arg8 = NUM2INT(argv[7]); }  {
        result = (FXMDIDeleteButton *)new_FXMDIDeleteButton(arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8);
        DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result); if(rb_block_given_p()){ rb_yield(self); }  }  return self; }
static void
free_FXMDIDeleteButton(FXMDIDeleteButton *arg1) {
    delete arg1;
}
static VALUE _wrap_FXMDIDeleteButton_save(int argc, VALUE *argv, VALUE self) {
    FXMDIDeleteButton *arg1 = (FXMDIDeleteButton *) 0 ; FXStream *arg2 = 0 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIDeleteButton, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXMDIDeleteButton_save((FXMDIDeleteButton const *)arg1,*arg2); return Qnil; }
static VALUE _wrap_FXMDIDeleteButton_load(int argc, VALUE *argv, VALUE self) {
    FXMDIDeleteButton *arg1 = (FXMDIDeleteButton *) 0 ; FXStream *arg2 = 0 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIDeleteButton, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXMDIDeleteButton_load(arg1,*arg2); return Qnil; }
static VALUE _wrap_FXMDIDeleteButton_create(int argc, VALUE *argv, VALUE self) {
    FXMDIDeleteButton *arg1 = (FXMDIDeleteButton *) 0 ; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIDeleteButton, 1); FXMDIDeleteButton_create(arg1); return Qnil; }
static VALUE _wrap_FXMDIDeleteButton_detach(int argc, VALUE *argv, VALUE self) {
    FXMDIDeleteButton *arg1 = (FXMDIDeleteButton *) 0 ; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIDeleteButton, 1); FXMDIDeleteButton_detach(arg1); return Qnil; }
static VALUE _wrap_FXMDIDeleteButton_destroy(int argc, VALUE *argv, VALUE self) {
    FXMDIDeleteButton *arg1 = (FXMDIDeleteButton *) 0 ; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIDeleteButton, 1); FXMDIDeleteButton_destroy(arg1); return Qnil; }
static VALUE _wrap_FXMDIDeleteButton_resize(int argc, VALUE *argv, VALUE self) {
    FXMDIDeleteButton *arg1 = (FXMDIDeleteButton *) 0 ; FXint arg2 ; FXint arg3 ; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIDeleteButton, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    FXMDIDeleteButton_resize(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXMDIDeleteButton_getDefaultWidth(int argc, VALUE *argv, VALUE self) {
    FXMDIDeleteButton *arg1 = (FXMDIDeleteButton *) 0 ; FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIDeleteButton, 1);
    result = (FXint)FXMDIDeleteButton_getDefaultWidth(arg1); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXMDIDeleteButton_getDefaultHeight(int argc, VALUE *argv, VALUE self) {
    FXMDIDeleteButton *arg1 = (FXMDIDeleteButton *) 0 ; FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIDeleteButton, 1);
    result = (FXint)FXMDIDeleteButton_getDefaultHeight(arg1); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXMDIDeleteButton_getWidthForHeight(int argc, VALUE *argv, VALUE self) {
    FXMDIDeleteButton *arg1 = (FXMDIDeleteButton *) 0 ; FXint arg2 ; FXint result; VALUE vresult = Qnil;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIDeleteButton, 1); arg2 = NUM2INT(argv[0]);
    result = (FXint)FXMDIDeleteButton_getWidthForHeight(arg1,arg2); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXMDIDeleteButton_getHeightForWidth(int argc, VALUE *argv, VALUE self) {
    FXMDIDeleteButton *arg1 = (FXMDIDeleteButton *) 0 ; FXint arg2 ; FXint result; VALUE vresult = Qnil;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIDeleteButton, 1); arg2 = NUM2INT(argv[0]);
    result = (FXint)FXMDIDeleteButton_getHeightForWidth(arg1,arg2); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXMDIDeleteButton_canFocus(int argc, VALUE *argv, VALUE self) {
    FXMDIDeleteButton *arg1 = (FXMDIDeleteButton *) 0 ; FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIDeleteButton, 1);
    result = (FXbool)FXMDIDeleteButton_canFocus((FXMDIDeleteButton const *)arg1); vresult = result ? Qtrue : Qfalse;
    return vresult; }
static VALUE _wrap_FXMDIDeleteButton_setFocus(int argc, VALUE *argv, VALUE self) {
    FXMDIDeleteButton *arg1 = (FXMDIDeleteButton *) 0 ; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIDeleteButton, 1); FXMDIDeleteButton_setFocus(arg1); return Qnil; }
static VALUE _wrap_FXMDIDeleteButton_killFocus(int argc, VALUE *argv, VALUE self) {
    FXMDIDeleteButton *arg1 = (FXMDIDeleteButton *) 0 ; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIDeleteButton, 1); FXMDIDeleteButton_killFocus(arg1); return Qnil; }
static VALUE _wrap_FXMDIDeleteButton_setDefault(int argc, VALUE *argv, VALUE self) {
    FXMDIDeleteButton *arg1 = (FXMDIDeleteButton *) 0 ; FXbool arg2 = (FXbool) 1 ; if ((argc < 0) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIDeleteButton, 1); if (argc > 0) { arg2 = to_FXbool(argv[0]); } 
    FXMDIDeleteButton_setDefault(arg1,arg2); return Qnil; }
static VALUE _wrap_FXMDIDeleteButton_enable(int argc, VALUE *argv, VALUE self) {
    FXMDIDeleteButton *arg1 = (FXMDIDeleteButton *) 0 ; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIDeleteButton, 1); FXMDIDeleteButton_enable(arg1); return Qnil; }
static VALUE _wrap_FXMDIDeleteButton_disable(int argc, VALUE *argv, VALUE self) {
    FXMDIDeleteButton *arg1 = (FXMDIDeleteButton *) 0 ; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIDeleteButton, 1); FXMDIDeleteButton_disable(arg1); return Qnil; }
static VALUE _wrap_FXMDIDeleteButton_raiseWindow(int argc, VALUE *argv, VALUE self) {
    FXMDIDeleteButton *arg1 = (FXMDIDeleteButton *) 0 ; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIDeleteButton, 1); FXMDIDeleteButton_raise(arg1); return Qnil; }
static VALUE _wrap_FXMDIDeleteButton_lower(int argc, VALUE *argv, VALUE self) {
    FXMDIDeleteButton *arg1 = (FXMDIDeleteButton *) 0 ; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIDeleteButton, 1); FXMDIDeleteButton_lower(arg1); return Qnil; }
static VALUE _wrap_FXMDIDeleteButton_move(int argc, VALUE *argv, VALUE self) {
    FXMDIDeleteButton *arg1 = (FXMDIDeleteButton *) 0 ; FXint arg2 ; FXint arg3 ; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIDeleteButton, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    FXMDIDeleteButton_move(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXMDIDeleteButton_position(int argc, VALUE *argv, VALUE self) {
    FXMDIDeleteButton *arg1 = (FXMDIDeleteButton *) 0 ; FXint arg2 ; FXint arg3 ; FXint arg4 ; FXint arg5 ;
    if ((argc < 4) || (argc > 4)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIDeleteButton, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    arg4 = NUM2INT(argv[2]); arg5 = NUM2INT(argv[3]); FXMDIDeleteButton_position(arg1,arg2,arg3,arg4,arg5); return Qnil; }
static VALUE _wrap_FXMDIDeleteButton_layout(int argc, VALUE *argv, VALUE self) {
    FXMDIDeleteButton *arg1 = (FXMDIDeleteButton *) 0 ; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIDeleteButton, 1); FXMDIDeleteButton_layout(arg1); return Qnil; }
static VALUE _wrap_FXMDIDeleteButton_recalc(int argc, VALUE *argv, VALUE self) {
    FXMDIDeleteButton *arg1 = (FXMDIDeleteButton *) 0 ; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIDeleteButton, 1); FXMDIDeleteButton_recalc(arg1); return Qnil; }
static VALUE _wrap_FXMDIDeleteButton_reparent(int argc, VALUE *argv, VALUE self) {
    FXMDIDeleteButton *arg1 = (FXMDIDeleteButton *) 0 ; FXComposite *arg2 = (FXComposite *) 0 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIDeleteButton, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXComposite, 1); FXMDIDeleteButton_reparent(arg1,arg2); return Qnil; }
static VALUE _wrap_FXMDIDeleteButton_show(int argc, VALUE *argv, VALUE self) {
    FXMDIDeleteButton *arg1 = (FXMDIDeleteButton *) 0 ; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIDeleteButton, 1); FXMDIDeleteButton_show(arg1); return Qnil; }
static VALUE _wrap_FXMDIDeleteButton_hide(int argc, VALUE *argv, VALUE self) {
    FXMDIDeleteButton *arg1 = (FXMDIDeleteButton *) 0 ; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIDeleteButton, 1); FXMDIDeleteButton_hide(arg1); return Qnil; }
static VALUE _wrap_FXMDIDeleteButton_isComposite(int argc, VALUE *argv, VALUE self) {
    FXMDIDeleteButton *arg1 = (FXMDIDeleteButton *) 0 ; FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIDeleteButton, 1);
    result = (FXbool)FXMDIDeleteButton_isComposite((FXMDIDeleteButton const *)arg1); vresult = result ? Qtrue : Qfalse;
    return vresult; }
static VALUE _wrap_FXMDIDeleteButton_contains(int argc, VALUE *argv, VALUE self) {
    FXMDIDeleteButton *arg1 = (FXMDIDeleteButton *) 0 ; FXint arg2 ; FXint arg3 ; FXbool result; VALUE vresult = Qnil;
    if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIDeleteButton, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    result = (FXbool)FXMDIDeleteButton_contains((FXMDIDeleteButton const *)arg1,arg2,arg3); vresult = result ? Qtrue : Qfalse;
    return vresult; }
static VALUE _wrap_FXMDIDeleteButton_doesSaveUnder(int argc, VALUE *argv, VALUE self) {
    FXMDIDeleteButton *arg1 = (FXMDIDeleteButton *) 0 ; FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIDeleteButton, 1);
    result = (FXbool)FXMDIDeleteButton_doesSaveUnder((FXMDIDeleteButton const *)arg1); vresult = result ? Qtrue : Qfalse;
    return vresult; }
static VALUE _wrap_FXMDIDeleteButton_setBackColor(int argc, VALUE *argv, VALUE self) {
    FXMDIDeleteButton *arg1 = (FXMDIDeleteButton *) 0 ; FXColor arg2 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIDeleteButton, 1); arg2 = to_FXColor(argv[0]);
    FXMDIDeleteButton_setBackColor(arg1,arg2); return Qnil; }
static VALUE _wrap_FXMDIRestoreButton_onPaint(int argc, VALUE *argv, VALUE self) {
    FXMDIRestoreButton *arg1 = (FXMDIRestoreButton *) 0 ; FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ;
    void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil; if ((argc < 3) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIRestoreButton, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onPaint(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE _wrap_FXMDIRestoreButton_allocate(VALUE self) {
#else
     static VALUE _wrap_FXMDIRestoreButton_allocate(int argc, VALUE *argv, VALUE self) {
#endif
         VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_FXMDIRestoreButton);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
         return vresult; }
static VALUE _wrap_new_FXMDIRestoreButton(int argc, VALUE *argv, VALUE self) { FXComposite *arg1 = (FXComposite *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 = (FXSelector) 0 ; FXuint arg4 = (FXuint) FRAME_RAISED ;
    FXint arg5 = (FXint) 0 ; FXint arg6 = (FXint) 0 ; FXint arg7 = (FXint) 0 ; FXint arg8 = (FXint) 0 ;
    FXMDIRestoreButton *result; if ((argc < 1) || (argc > 8)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXComposite, 1); if (argc > 1) {
        SWIG_ConvertPtr(argv[1], (void **) &arg2, SWIGTYPE_p_FXObject, 1); }  if (argc > 2) { arg3 = NUM2UINT(argv[2]); } 
    if (argc > 3) { arg4 = NUM2UINT(argv[3]); }  if (argc > 4) { arg5 = NUM2INT(argv[4]); }  if (argc > 5) {
        arg6 = NUM2INT(argv[5]); }  if (argc > 6) { arg7 = NUM2INT(argv[6]); }  if (argc > 7) { arg8 = NUM2INT(argv[7]); }  {
        result = (FXMDIRestoreButton *)new_FXMDIRestoreButton(arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8);
        DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result); if(rb_block_given_p()){ rb_yield(self); }  }  return self; }
static void
free_FXMDIRestoreButton(FXMDIRestoreButton *arg1) {
    delete arg1;
}
static VALUE _wrap_FXMDIRestoreButton_save(int argc, VALUE *argv, VALUE self) {
    FXMDIRestoreButton *arg1 = (FXMDIRestoreButton *) 0 ; FXStream *arg2 = 0 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIRestoreButton, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXMDIRestoreButton_save((FXMDIRestoreButton const *)arg1,*arg2); return Qnil; }
static VALUE _wrap_FXMDIRestoreButton_load(int argc, VALUE *argv, VALUE self) {
    FXMDIRestoreButton *arg1 = (FXMDIRestoreButton *) 0 ; FXStream *arg2 = 0 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIRestoreButton, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXMDIRestoreButton_load(arg1,*arg2); return Qnil; }
static VALUE _wrap_FXMDIRestoreButton_create(int argc, VALUE *argv, VALUE self) {
    FXMDIRestoreButton *arg1 = (FXMDIRestoreButton *) 0 ; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIRestoreButton, 1); FXMDIRestoreButton_create(arg1); return Qnil; }
static VALUE _wrap_FXMDIRestoreButton_detach(int argc, VALUE *argv, VALUE self) {
    FXMDIRestoreButton *arg1 = (FXMDIRestoreButton *) 0 ; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIRestoreButton, 1); FXMDIRestoreButton_detach(arg1); return Qnil; }
static VALUE _wrap_FXMDIRestoreButton_destroy(int argc, VALUE *argv, VALUE self) {
    FXMDIRestoreButton *arg1 = (FXMDIRestoreButton *) 0 ; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIRestoreButton, 1); FXMDIRestoreButton_destroy(arg1); return Qnil; }
static VALUE _wrap_FXMDIRestoreButton_resize(int argc, VALUE *argv, VALUE self) {
    FXMDIRestoreButton *arg1 = (FXMDIRestoreButton *) 0 ; FXint arg2 ; FXint arg3 ; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIRestoreButton, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    FXMDIRestoreButton_resize(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXMDIRestoreButton_getDefaultWidth(int argc, VALUE *argv, VALUE self) {
    FXMDIRestoreButton *arg1 = (FXMDIRestoreButton *) 0 ; FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIRestoreButton, 1);
    result = (FXint)FXMDIRestoreButton_getDefaultWidth(arg1); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXMDIRestoreButton_getDefaultHeight(int argc, VALUE *argv, VALUE self) {
    FXMDIRestoreButton *arg1 = (FXMDIRestoreButton *) 0 ; FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIRestoreButton, 1);
    result = (FXint)FXMDIRestoreButton_getDefaultHeight(arg1); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXMDIRestoreButton_getWidthForHeight(int argc, VALUE *argv, VALUE self) {
    FXMDIRestoreButton *arg1 = (FXMDIRestoreButton *) 0 ; FXint arg2 ; FXint result; VALUE vresult = Qnil;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIRestoreButton, 1); arg2 = NUM2INT(argv[0]);
    result = (FXint)FXMDIRestoreButton_getWidthForHeight(arg1,arg2); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXMDIRestoreButton_getHeightForWidth(int argc, VALUE *argv, VALUE self) {
    FXMDIRestoreButton *arg1 = (FXMDIRestoreButton *) 0 ; FXint arg2 ; FXint result; VALUE vresult = Qnil;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIRestoreButton, 1); arg2 = NUM2INT(argv[0]);
    result = (FXint)FXMDIRestoreButton_getHeightForWidth(arg1,arg2); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXMDIRestoreButton_canFocus(int argc, VALUE *argv, VALUE self) {
    FXMDIRestoreButton *arg1 = (FXMDIRestoreButton *) 0 ; FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIRestoreButton, 1);
    result = (FXbool)FXMDIRestoreButton_canFocus((FXMDIRestoreButton const *)arg1); vresult = result ? Qtrue : Qfalse;
    return vresult; }
static VALUE _wrap_FXMDIRestoreButton_setFocus(int argc, VALUE *argv, VALUE self) {
    FXMDIRestoreButton *arg1 = (FXMDIRestoreButton *) 0 ; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIRestoreButton, 1); FXMDIRestoreButton_setFocus(arg1); return Qnil; }
static VALUE _wrap_FXMDIRestoreButton_killFocus(int argc, VALUE *argv, VALUE self) {
    FXMDIRestoreButton *arg1 = (FXMDIRestoreButton *) 0 ; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIRestoreButton, 1); FXMDIRestoreButton_killFocus(arg1); return Qnil; }
static VALUE _wrap_FXMDIRestoreButton_setDefault(int argc, VALUE *argv, VALUE self) {
    FXMDIRestoreButton *arg1 = (FXMDIRestoreButton *) 0 ; FXbool arg2 = (FXbool) 1 ; if ((argc < 0) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIRestoreButton, 1); if (argc > 0) { arg2 = to_FXbool(argv[0]); } 
    FXMDIRestoreButton_setDefault(arg1,arg2); return Qnil; }
static VALUE _wrap_FXMDIRestoreButton_enable(int argc, VALUE *argv, VALUE self) {
    FXMDIRestoreButton *arg1 = (FXMDIRestoreButton *) 0 ; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIRestoreButton, 1); FXMDIRestoreButton_enable(arg1); return Qnil; }
static VALUE _wrap_FXMDIRestoreButton_disable(int argc, VALUE *argv, VALUE self) {
    FXMDIRestoreButton *arg1 = (FXMDIRestoreButton *) 0 ; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIRestoreButton, 1); FXMDIRestoreButton_disable(arg1); return Qnil; }
static VALUE _wrap_FXMDIRestoreButton_raiseWindow(int argc, VALUE *argv, VALUE self) {
    FXMDIRestoreButton *arg1 = (FXMDIRestoreButton *) 0 ; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIRestoreButton, 1); FXMDIRestoreButton_raise(arg1); return Qnil; }
static VALUE _wrap_FXMDIRestoreButton_lower(int argc, VALUE *argv, VALUE self) {
    FXMDIRestoreButton *arg1 = (FXMDIRestoreButton *) 0 ; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIRestoreButton, 1); FXMDIRestoreButton_lower(arg1); return Qnil; }
static VALUE _wrap_FXMDIRestoreButton_move(int argc, VALUE *argv, VALUE self) {
    FXMDIRestoreButton *arg1 = (FXMDIRestoreButton *) 0 ; FXint arg2 ; FXint arg3 ; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIRestoreButton, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    FXMDIRestoreButton_move(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXMDIRestoreButton_position(int argc, VALUE *argv, VALUE self) {
    FXMDIRestoreButton *arg1 = (FXMDIRestoreButton *) 0 ; FXint arg2 ; FXint arg3 ; FXint arg4 ; FXint arg5 ;
    if ((argc < 4) || (argc > 4)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIRestoreButton, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    arg4 = NUM2INT(argv[2]); arg5 = NUM2INT(argv[3]); FXMDIRestoreButton_position(arg1,arg2,arg3,arg4,arg5); return Qnil; }
static VALUE _wrap_FXMDIRestoreButton_layout(int argc, VALUE *argv, VALUE self) {
    FXMDIRestoreButton *arg1 = (FXMDIRestoreButton *) 0 ; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIRestoreButton, 1); FXMDIRestoreButton_layout(arg1); return Qnil; }
static VALUE _wrap_FXMDIRestoreButton_recalc(int argc, VALUE *argv, VALUE self) {
    FXMDIRestoreButton *arg1 = (FXMDIRestoreButton *) 0 ; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIRestoreButton, 1); FXMDIRestoreButton_recalc(arg1); return Qnil; }
static VALUE _wrap_FXMDIRestoreButton_reparent(int argc, VALUE *argv, VALUE self) {
    FXMDIRestoreButton *arg1 = (FXMDIRestoreButton *) 0 ; FXComposite *arg2 = (FXComposite *) 0 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIRestoreButton, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXComposite, 1); FXMDIRestoreButton_reparent(arg1,arg2); return Qnil; }
static VALUE _wrap_FXMDIRestoreButton_show(int argc, VALUE *argv, VALUE self) {
    FXMDIRestoreButton *arg1 = (FXMDIRestoreButton *) 0 ; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIRestoreButton, 1); FXMDIRestoreButton_show(arg1); return Qnil; }
static VALUE _wrap_FXMDIRestoreButton_hide(int argc, VALUE *argv, VALUE self) {
    FXMDIRestoreButton *arg1 = (FXMDIRestoreButton *) 0 ; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIRestoreButton, 1); FXMDIRestoreButton_hide(arg1); return Qnil; }
static VALUE _wrap_FXMDIRestoreButton_isComposite(int argc, VALUE *argv, VALUE self) {
    FXMDIRestoreButton *arg1 = (FXMDIRestoreButton *) 0 ; FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIRestoreButton, 1);
    result = (FXbool)FXMDIRestoreButton_isComposite((FXMDIRestoreButton const *)arg1); vresult = result ? Qtrue : Qfalse;
    return vresult; }
static VALUE _wrap_FXMDIRestoreButton_contains(int argc, VALUE *argv, VALUE self) {
    FXMDIRestoreButton *arg1 = (FXMDIRestoreButton *) 0 ; FXint arg2 ; FXint arg3 ; FXbool result; VALUE vresult = Qnil;
    if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIRestoreButton, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    result = (FXbool)FXMDIRestoreButton_contains((FXMDIRestoreButton const *)arg1,arg2,arg3); vresult = result ? Qtrue : Qfalse;
    return vresult; }
static VALUE _wrap_FXMDIRestoreButton_doesSaveUnder(int argc, VALUE *argv, VALUE self) {
    FXMDIRestoreButton *arg1 = (FXMDIRestoreButton *) 0 ; FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIRestoreButton, 1);
    result = (FXbool)FXMDIRestoreButton_doesSaveUnder((FXMDIRestoreButton const *)arg1); vresult = result ? Qtrue : Qfalse;
    return vresult; }
static VALUE _wrap_FXMDIRestoreButton_setBackColor(int argc, VALUE *argv, VALUE self) {
    FXMDIRestoreButton *arg1 = (FXMDIRestoreButton *) 0 ; FXColor arg2 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIRestoreButton, 1); arg2 = to_FXColor(argv[0]);
    FXMDIRestoreButton_setBackColor(arg1,arg2); return Qnil; }
static VALUE _wrap_FXMDIMaximizeButton_onPaint(int argc, VALUE *argv, VALUE self) {
    FXMDIMaximizeButton *arg1 = (FXMDIMaximizeButton *) 0 ; FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ;
    void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil; if ((argc < 3) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIMaximizeButton, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onPaint(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE _wrap_FXMDIMaximizeButton_allocate(VALUE self) {
#else
     static VALUE _wrap_FXMDIMaximizeButton_allocate(int argc, VALUE *argv, VALUE self) {
#endif
         VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_FXMDIMaximizeButton);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
         return vresult; }
static VALUE _wrap_new_FXMDIMaximizeButton(int argc, VALUE *argv, VALUE self) { FXComposite *arg1 = (FXComposite *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 = (FXSelector) 0 ; FXuint arg4 = (FXuint) FRAME_RAISED ;
    FXint arg5 = (FXint) 0 ; FXint arg6 = (FXint) 0 ; FXint arg7 = (FXint) 0 ; FXint arg8 = (FXint) 0 ;
    FXMDIMaximizeButton *result; if ((argc < 1) || (argc > 8)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXComposite, 1); if (argc > 1) {
        SWIG_ConvertPtr(argv[1], (void **) &arg2, SWIGTYPE_p_FXObject, 1); }  if (argc > 2) { arg3 = NUM2UINT(argv[2]); } 
    if (argc > 3) { arg4 = NUM2UINT(argv[3]); }  if (argc > 4) { arg5 = NUM2INT(argv[4]); }  if (argc > 5) {
        arg6 = NUM2INT(argv[5]); }  if (argc > 6) { arg7 = NUM2INT(argv[6]); }  if (argc > 7) { arg8 = NUM2INT(argv[7]); }  {
        result = (FXMDIMaximizeButton *)new_FXMDIMaximizeButton(arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8);
        DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result); if(rb_block_given_p()){ rb_yield(self); }  }  return self; }
static void
free_FXMDIMaximizeButton(FXMDIMaximizeButton *arg1) {
    delete arg1;
}
static VALUE _wrap_FXMDIMaximizeButton_save(int argc, VALUE *argv, VALUE self) {
    FXMDIMaximizeButton *arg1 = (FXMDIMaximizeButton *) 0 ; FXStream *arg2 = 0 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIMaximizeButton, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXMDIMaximizeButton_save((FXMDIMaximizeButton const *)arg1,*arg2); return Qnil; }
static VALUE _wrap_FXMDIMaximizeButton_load(int argc, VALUE *argv, VALUE self) {
    FXMDIMaximizeButton *arg1 = (FXMDIMaximizeButton *) 0 ; FXStream *arg2 = 0 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIMaximizeButton, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXMDIMaximizeButton_load(arg1,*arg2); return Qnil; }
static VALUE _wrap_FXMDIMaximizeButton_create(int argc, VALUE *argv, VALUE self) {
    FXMDIMaximizeButton *arg1 = (FXMDIMaximizeButton *) 0 ; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIMaximizeButton, 1); FXMDIMaximizeButton_create(arg1); return Qnil; }
static VALUE _wrap_FXMDIMaximizeButton_detach(int argc, VALUE *argv, VALUE self) {
    FXMDIMaximizeButton *arg1 = (FXMDIMaximizeButton *) 0 ; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIMaximizeButton, 1); FXMDIMaximizeButton_detach(arg1); return Qnil; }
static VALUE _wrap_FXMDIMaximizeButton_destroy(int argc, VALUE *argv, VALUE self) {
    FXMDIMaximizeButton *arg1 = (FXMDIMaximizeButton *) 0 ; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIMaximizeButton, 1); FXMDIMaximizeButton_destroy(arg1); return Qnil; }
static VALUE _wrap_FXMDIMaximizeButton_resize(int argc, VALUE *argv, VALUE self) {
    FXMDIMaximizeButton *arg1 = (FXMDIMaximizeButton *) 0 ; FXint arg2 ; FXint arg3 ; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIMaximizeButton, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    FXMDIMaximizeButton_resize(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXMDIMaximizeButton_getDefaultWidth(int argc, VALUE *argv, VALUE self) {
    FXMDIMaximizeButton *arg1 = (FXMDIMaximizeButton *) 0 ; FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIMaximizeButton, 1);
    result = (FXint)FXMDIMaximizeButton_getDefaultWidth(arg1); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXMDIMaximizeButton_getDefaultHeight(int argc, VALUE *argv, VALUE self) {
    FXMDIMaximizeButton *arg1 = (FXMDIMaximizeButton *) 0 ; FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIMaximizeButton, 1);
    result = (FXint)FXMDIMaximizeButton_getDefaultHeight(arg1); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXMDIMaximizeButton_getWidthForHeight(int argc, VALUE *argv, VALUE self) {
    FXMDIMaximizeButton *arg1 = (FXMDIMaximizeButton *) 0 ; FXint arg2 ; FXint result; VALUE vresult = Qnil;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIMaximizeButton, 1); arg2 = NUM2INT(argv[0]);
    result = (FXint)FXMDIMaximizeButton_getWidthForHeight(arg1,arg2); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXMDIMaximizeButton_getHeightForWidth(int argc, VALUE *argv, VALUE self) {
    FXMDIMaximizeButton *arg1 = (FXMDIMaximizeButton *) 0 ; FXint arg2 ; FXint result; VALUE vresult = Qnil;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIMaximizeButton, 1); arg2 = NUM2INT(argv[0]);
    result = (FXint)FXMDIMaximizeButton_getHeightForWidth(arg1,arg2); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXMDIMaximizeButton_canFocus(int argc, VALUE *argv, VALUE self) {
    FXMDIMaximizeButton *arg1 = (FXMDIMaximizeButton *) 0 ; FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIMaximizeButton, 1);
    result = (FXbool)FXMDIMaximizeButton_canFocus((FXMDIMaximizeButton const *)arg1); vresult = result ? Qtrue : Qfalse;
    return vresult; }
static VALUE _wrap_FXMDIMaximizeButton_setFocus(int argc, VALUE *argv, VALUE self) {
    FXMDIMaximizeButton *arg1 = (FXMDIMaximizeButton *) 0 ; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIMaximizeButton, 1); FXMDIMaximizeButton_setFocus(arg1); return Qnil; }
static VALUE _wrap_FXMDIMaximizeButton_killFocus(int argc, VALUE *argv, VALUE self) {
    FXMDIMaximizeButton *arg1 = (FXMDIMaximizeButton *) 0 ; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIMaximizeButton, 1); FXMDIMaximizeButton_killFocus(arg1);
    return Qnil; }
static VALUE _wrap_FXMDIMaximizeButton_setDefault(int argc, VALUE *argv, VALUE self) {
    FXMDIMaximizeButton *arg1 = (FXMDIMaximizeButton *) 0 ; FXbool arg2 = (FXbool) 1 ; if ((argc < 0) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIMaximizeButton, 1); if (argc > 0) { arg2 = to_FXbool(argv[0]); } 
    FXMDIMaximizeButton_setDefault(arg1,arg2); return Qnil; }
static VALUE _wrap_FXMDIMaximizeButton_enable(int argc, VALUE *argv, VALUE self) {
    FXMDIMaximizeButton *arg1 = (FXMDIMaximizeButton *) 0 ; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIMaximizeButton, 1); FXMDIMaximizeButton_enable(arg1); return Qnil; }
static VALUE _wrap_FXMDIMaximizeButton_disable(int argc, VALUE *argv, VALUE self) {
    FXMDIMaximizeButton *arg1 = (FXMDIMaximizeButton *) 0 ; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIMaximizeButton, 1); FXMDIMaximizeButton_disable(arg1); return Qnil; }
static VALUE _wrap_FXMDIMaximizeButton_raiseWindow(int argc, VALUE *argv, VALUE self) {
    FXMDIMaximizeButton *arg1 = (FXMDIMaximizeButton *) 0 ; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIMaximizeButton, 1); FXMDIMaximizeButton_raise(arg1); return Qnil; }
static VALUE _wrap_FXMDIMaximizeButton_lower(int argc, VALUE *argv, VALUE self) {
    FXMDIMaximizeButton *arg1 = (FXMDIMaximizeButton *) 0 ; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIMaximizeButton, 1); FXMDIMaximizeButton_lower(arg1); return Qnil; }
static VALUE _wrap_FXMDIMaximizeButton_move(int argc, VALUE *argv, VALUE self) {
    FXMDIMaximizeButton *arg1 = (FXMDIMaximizeButton *) 0 ; FXint arg2 ; FXint arg3 ; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIMaximizeButton, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    FXMDIMaximizeButton_move(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXMDIMaximizeButton_position(int argc, VALUE *argv, VALUE self) {
    FXMDIMaximizeButton *arg1 = (FXMDIMaximizeButton *) 0 ; FXint arg2 ; FXint arg3 ; FXint arg4 ; FXint arg5 ;
    if ((argc < 4) || (argc > 4)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIMaximizeButton, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    arg4 = NUM2INT(argv[2]); arg5 = NUM2INT(argv[3]); FXMDIMaximizeButton_position(arg1,arg2,arg3,arg4,arg5); return Qnil; }
static VALUE _wrap_FXMDIMaximizeButton_layout(int argc, VALUE *argv, VALUE self) {
    FXMDIMaximizeButton *arg1 = (FXMDIMaximizeButton *) 0 ; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIMaximizeButton, 1); FXMDIMaximizeButton_layout(arg1); return Qnil; }
static VALUE _wrap_FXMDIMaximizeButton_recalc(int argc, VALUE *argv, VALUE self) {
    FXMDIMaximizeButton *arg1 = (FXMDIMaximizeButton *) 0 ; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIMaximizeButton, 1); FXMDIMaximizeButton_recalc(arg1); return Qnil; }
static VALUE _wrap_FXMDIMaximizeButton_reparent(int argc, VALUE *argv, VALUE self) {
    FXMDIMaximizeButton *arg1 = (FXMDIMaximizeButton *) 0 ; FXComposite *arg2 = (FXComposite *) 0 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIMaximizeButton, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXComposite, 1); FXMDIMaximizeButton_reparent(arg1,arg2); return Qnil; }
static VALUE _wrap_FXMDIMaximizeButton_show(int argc, VALUE *argv, VALUE self) {
    FXMDIMaximizeButton *arg1 = (FXMDIMaximizeButton *) 0 ; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIMaximizeButton, 1); FXMDIMaximizeButton_show(arg1); return Qnil; }
static VALUE _wrap_FXMDIMaximizeButton_hide(int argc, VALUE *argv, VALUE self) {
    FXMDIMaximizeButton *arg1 = (FXMDIMaximizeButton *) 0 ; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIMaximizeButton, 1); FXMDIMaximizeButton_hide(arg1); return Qnil; }
static VALUE _wrap_FXMDIMaximizeButton_isComposite(int argc, VALUE *argv, VALUE self) {
    FXMDIMaximizeButton *arg1 = (FXMDIMaximizeButton *) 0 ; FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIMaximizeButton, 1);
    result = (FXbool)FXMDIMaximizeButton_isComposite((FXMDIMaximizeButton const *)arg1); vresult = result ? Qtrue : Qfalse;
    return vresult; }
static VALUE _wrap_FXMDIMaximizeButton_contains(int argc, VALUE *argv, VALUE self) {
    FXMDIMaximizeButton *arg1 = (FXMDIMaximizeButton *) 0 ; FXint arg2 ; FXint arg3 ; FXbool result; VALUE vresult = Qnil;
    if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIMaximizeButton, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    result = (FXbool)FXMDIMaximizeButton_contains((FXMDIMaximizeButton const *)arg1,arg2,arg3);
    vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXMDIMaximizeButton_doesSaveUnder(int argc, VALUE *argv, VALUE self) {
    FXMDIMaximizeButton *arg1 = (FXMDIMaximizeButton *) 0 ; FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIMaximizeButton, 1);
    result = (FXbool)FXMDIMaximizeButton_doesSaveUnder((FXMDIMaximizeButton const *)arg1); vresult = result ? Qtrue : Qfalse;
    return vresult; }
static VALUE _wrap_FXMDIMaximizeButton_setBackColor(int argc, VALUE *argv, VALUE self) {
    FXMDIMaximizeButton *arg1 = (FXMDIMaximizeButton *) 0 ; FXColor arg2 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIMaximizeButton, 1); arg2 = to_FXColor(argv[0]);
    FXMDIMaximizeButton_setBackColor(arg1,arg2); return Qnil; }
static VALUE _wrap_FXMDIMinimizeButton_onPaint(int argc, VALUE *argv, VALUE self) {
    FXMDIMinimizeButton *arg1 = (FXMDIMinimizeButton *) 0 ; FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ;
    void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil; if ((argc < 3) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIMinimizeButton, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onPaint(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE _wrap_FXMDIMinimizeButton_allocate(VALUE self) {
#else
     static VALUE _wrap_FXMDIMinimizeButton_allocate(int argc, VALUE *argv, VALUE self) {
#endif
         VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_FXMDIMinimizeButton);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
         return vresult; }
static VALUE _wrap_new_FXMDIMinimizeButton(int argc, VALUE *argv, VALUE self) { FXComposite *arg1 = (FXComposite *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 = (FXSelector) 0 ; FXuint arg4 = (FXuint) FRAME_RAISED ;
    FXint arg5 = (FXint) 0 ; FXint arg6 = (FXint) 0 ; FXint arg7 = (FXint) 0 ; FXint arg8 = (FXint) 0 ;
    FXMDIMinimizeButton *result; if ((argc < 1) || (argc > 8)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXComposite, 1); if (argc > 1) {
        SWIG_ConvertPtr(argv[1], (void **) &arg2, SWIGTYPE_p_FXObject, 1); }  if (argc > 2) { arg3 = NUM2UINT(argv[2]); } 
    if (argc > 3) { arg4 = NUM2UINT(argv[3]); }  if (argc > 4) { arg5 = NUM2INT(argv[4]); }  if (argc > 5) {
        arg6 = NUM2INT(argv[5]); }  if (argc > 6) { arg7 = NUM2INT(argv[6]); }  if (argc > 7) { arg8 = NUM2INT(argv[7]); }  {
        result = (FXMDIMinimizeButton *)new_FXMDIMinimizeButton(arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8);
        DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result); if(rb_block_given_p()){ rb_yield(self); }  }  return self; }
static void
free_FXMDIMinimizeButton(FXMDIMinimizeButton *arg1) {
    delete arg1;
}
static VALUE _wrap_FXMDIMinimizeButton_save(int argc, VALUE *argv, VALUE self) {
    FXMDIMinimizeButton *arg1 = (FXMDIMinimizeButton *) 0 ; FXStream *arg2 = 0 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIMinimizeButton, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXMDIMinimizeButton_save((FXMDIMinimizeButton const *)arg1,*arg2); return Qnil; }
static VALUE _wrap_FXMDIMinimizeButton_load(int argc, VALUE *argv, VALUE self) {
    FXMDIMinimizeButton *arg1 = (FXMDIMinimizeButton *) 0 ; FXStream *arg2 = 0 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIMinimizeButton, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXMDIMinimizeButton_load(arg1,*arg2); return Qnil; }
static VALUE _wrap_FXMDIMinimizeButton_create(int argc, VALUE *argv, VALUE self) {
    FXMDIMinimizeButton *arg1 = (FXMDIMinimizeButton *) 0 ; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIMinimizeButton, 1); FXMDIMinimizeButton_create(arg1); return Qnil; }
static VALUE _wrap_FXMDIMinimizeButton_detach(int argc, VALUE *argv, VALUE self) {
    FXMDIMinimizeButton *arg1 = (FXMDIMinimizeButton *) 0 ; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIMinimizeButton, 1); FXMDIMinimizeButton_detach(arg1); return Qnil; }
static VALUE _wrap_FXMDIMinimizeButton_destroy(int argc, VALUE *argv, VALUE self) {
    FXMDIMinimizeButton *arg1 = (FXMDIMinimizeButton *) 0 ; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIMinimizeButton, 1); FXMDIMinimizeButton_destroy(arg1); return Qnil; }
static VALUE _wrap_FXMDIMinimizeButton_resize(int argc, VALUE *argv, VALUE self) {
    FXMDIMinimizeButton *arg1 = (FXMDIMinimizeButton *) 0 ; FXint arg2 ; FXint arg3 ; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIMinimizeButton, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    FXMDIMinimizeButton_resize(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXMDIMinimizeButton_getDefaultWidth(int argc, VALUE *argv, VALUE self) {
    FXMDIMinimizeButton *arg1 = (FXMDIMinimizeButton *) 0 ; FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIMinimizeButton, 1);
    result = (FXint)FXMDIMinimizeButton_getDefaultWidth(arg1); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXMDIMinimizeButton_getDefaultHeight(int argc, VALUE *argv, VALUE self) {
    FXMDIMinimizeButton *arg1 = (FXMDIMinimizeButton *) 0 ; FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIMinimizeButton, 1);
    result = (FXint)FXMDIMinimizeButton_getDefaultHeight(arg1); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXMDIMinimizeButton_getWidthForHeight(int argc, VALUE *argv, VALUE self) {
    FXMDIMinimizeButton *arg1 = (FXMDIMinimizeButton *) 0 ; FXint arg2 ; FXint result; VALUE vresult = Qnil;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIMinimizeButton, 1); arg2 = NUM2INT(argv[0]);
    result = (FXint)FXMDIMinimizeButton_getWidthForHeight(arg1,arg2); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXMDIMinimizeButton_getHeightForWidth(int argc, VALUE *argv, VALUE self) {
    FXMDIMinimizeButton *arg1 = (FXMDIMinimizeButton *) 0 ; FXint arg2 ; FXint result; VALUE vresult = Qnil;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIMinimizeButton, 1); arg2 = NUM2INT(argv[0]);
    result = (FXint)FXMDIMinimizeButton_getHeightForWidth(arg1,arg2); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXMDIMinimizeButton_canFocus(int argc, VALUE *argv, VALUE self) {
    FXMDIMinimizeButton *arg1 = (FXMDIMinimizeButton *) 0 ; FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIMinimizeButton, 1);
    result = (FXbool)FXMDIMinimizeButton_canFocus((FXMDIMinimizeButton const *)arg1); vresult = result ? Qtrue : Qfalse;
    return vresult; }
static VALUE _wrap_FXMDIMinimizeButton_setFocus(int argc, VALUE *argv, VALUE self) {
    FXMDIMinimizeButton *arg1 = (FXMDIMinimizeButton *) 0 ; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIMinimizeButton, 1); FXMDIMinimizeButton_setFocus(arg1); return Qnil; }
static VALUE _wrap_FXMDIMinimizeButton_killFocus(int argc, VALUE *argv, VALUE self) {
    FXMDIMinimizeButton *arg1 = (FXMDIMinimizeButton *) 0 ; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIMinimizeButton, 1); FXMDIMinimizeButton_killFocus(arg1);
    return Qnil; }
static VALUE _wrap_FXMDIMinimizeButton_setDefault(int argc, VALUE *argv, VALUE self) {
    FXMDIMinimizeButton *arg1 = (FXMDIMinimizeButton *) 0 ; FXbool arg2 = (FXbool) 1 ; if ((argc < 0) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIMinimizeButton, 1); if (argc > 0) { arg2 = to_FXbool(argv[0]); } 
    FXMDIMinimizeButton_setDefault(arg1,arg2); return Qnil; }
static VALUE _wrap_FXMDIMinimizeButton_enable(int argc, VALUE *argv, VALUE self) {
    FXMDIMinimizeButton *arg1 = (FXMDIMinimizeButton *) 0 ; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIMinimizeButton, 1); FXMDIMinimizeButton_enable(arg1); return Qnil; }
static VALUE _wrap_FXMDIMinimizeButton_disable(int argc, VALUE *argv, VALUE self) {
    FXMDIMinimizeButton *arg1 = (FXMDIMinimizeButton *) 0 ; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIMinimizeButton, 1); FXMDIMinimizeButton_disable(arg1); return Qnil; }
static VALUE _wrap_FXMDIMinimizeButton_raiseWindow(int argc, VALUE *argv, VALUE self) {
    FXMDIMinimizeButton *arg1 = (FXMDIMinimizeButton *) 0 ; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIMinimizeButton, 1); FXMDIMinimizeButton_raise(arg1); return Qnil; }
static VALUE _wrap_FXMDIMinimizeButton_lower(int argc, VALUE *argv, VALUE self) {
    FXMDIMinimizeButton *arg1 = (FXMDIMinimizeButton *) 0 ; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIMinimizeButton, 1); FXMDIMinimizeButton_lower(arg1); return Qnil; }
static VALUE _wrap_FXMDIMinimizeButton_move(int argc, VALUE *argv, VALUE self) {
    FXMDIMinimizeButton *arg1 = (FXMDIMinimizeButton *) 0 ; FXint arg2 ; FXint arg3 ; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIMinimizeButton, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    FXMDIMinimizeButton_move(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXMDIMinimizeButton_position(int argc, VALUE *argv, VALUE self) {
    FXMDIMinimizeButton *arg1 = (FXMDIMinimizeButton *) 0 ; FXint arg2 ; FXint arg3 ; FXint arg4 ; FXint arg5 ;
    if ((argc < 4) || (argc > 4)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIMinimizeButton, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    arg4 = NUM2INT(argv[2]); arg5 = NUM2INT(argv[3]); FXMDIMinimizeButton_position(arg1,arg2,arg3,arg4,arg5); return Qnil; }
static VALUE _wrap_FXMDIMinimizeButton_layout(int argc, VALUE *argv, VALUE self) {
    FXMDIMinimizeButton *arg1 = (FXMDIMinimizeButton *) 0 ; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIMinimizeButton, 1); FXMDIMinimizeButton_layout(arg1); return Qnil; }
static VALUE _wrap_FXMDIMinimizeButton_recalc(int argc, VALUE *argv, VALUE self) {
    FXMDIMinimizeButton *arg1 = (FXMDIMinimizeButton *) 0 ; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIMinimizeButton, 1); FXMDIMinimizeButton_recalc(arg1); return Qnil; }
static VALUE _wrap_FXMDIMinimizeButton_reparent(int argc, VALUE *argv, VALUE self) {
    FXMDIMinimizeButton *arg1 = (FXMDIMinimizeButton *) 0 ; FXComposite *arg2 = (FXComposite *) 0 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIMinimizeButton, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXComposite, 1); FXMDIMinimizeButton_reparent(arg1,arg2); return Qnil; }
static VALUE _wrap_FXMDIMinimizeButton_show(int argc, VALUE *argv, VALUE self) {
    FXMDIMinimizeButton *arg1 = (FXMDIMinimizeButton *) 0 ; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIMinimizeButton, 1); FXMDIMinimizeButton_show(arg1); return Qnil; }
static VALUE _wrap_FXMDIMinimizeButton_hide(int argc, VALUE *argv, VALUE self) {
    FXMDIMinimizeButton *arg1 = (FXMDIMinimizeButton *) 0 ; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIMinimizeButton, 1); FXMDIMinimizeButton_hide(arg1); return Qnil; }
static VALUE _wrap_FXMDIMinimizeButton_isComposite(int argc, VALUE *argv, VALUE self) {
    FXMDIMinimizeButton *arg1 = (FXMDIMinimizeButton *) 0 ; FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIMinimizeButton, 1);
    result = (FXbool)FXMDIMinimizeButton_isComposite((FXMDIMinimizeButton const *)arg1); vresult = result ? Qtrue : Qfalse;
    return vresult; }
static VALUE _wrap_FXMDIMinimizeButton_contains(int argc, VALUE *argv, VALUE self) {
    FXMDIMinimizeButton *arg1 = (FXMDIMinimizeButton *) 0 ; FXint arg2 ; FXint arg3 ; FXbool result; VALUE vresult = Qnil;
    if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIMinimizeButton, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    result = (FXbool)FXMDIMinimizeButton_contains((FXMDIMinimizeButton const *)arg1,arg2,arg3);
    vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXMDIMinimizeButton_doesSaveUnder(int argc, VALUE *argv, VALUE self) {
    FXMDIMinimizeButton *arg1 = (FXMDIMinimizeButton *) 0 ; FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIMinimizeButton, 1);
    result = (FXbool)FXMDIMinimizeButton_doesSaveUnder((FXMDIMinimizeButton const *)arg1); vresult = result ? Qtrue : Qfalse;
    return vresult; }
static VALUE _wrap_FXMDIMinimizeButton_setBackColor(int argc, VALUE *argv, VALUE self) {
    FXMDIMinimizeButton *arg1 = (FXMDIMinimizeButton *) 0 ; FXColor arg2 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIMinimizeButton, 1); arg2 = to_FXColor(argv[0]);
    FXMDIMinimizeButton_setBackColor(arg1,arg2); return Qnil; }
static VALUE _wrap_FXMDIWindowButton_onPaint(int argc, VALUE *argv, VALUE self) {
    FXMDIWindowButton *arg1 = (FXMDIWindowButton *) 0 ; FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ;
    void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil; if ((argc < 3) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIWindowButton, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onPaint(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE _wrap_FXMDIWindowButton_allocate(VALUE self) {
#else
     static VALUE _wrap_FXMDIWindowButton_allocate(int argc, VALUE *argv, VALUE self) {
#endif
         VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_FXMDIWindowButton);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
         return vresult; }
static VALUE _wrap_new_FXMDIWindowButton(int argc, VALUE *argv, VALUE self) { FXComposite *arg1 = (FXComposite *) 0 ;
    FXPopup *arg2 = (FXPopup *) 0 ; FXObject *arg3 = (FXObject *) 0 ; FXSelector arg4 = (FXSelector) 0 ;
    FXuint arg5 = (FXuint) 0 ; FXint arg6 = (FXint) 0 ; FXint arg7 = (FXint) 0 ; FXint arg8 = (FXint) 0 ;
    FXint arg9 = (FXint) 0 ; FXMDIWindowButton *result; if ((argc < 2) || (argc > 9))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXComposite, 1);
    SWIG_ConvertPtr(argv[1], (void **) &arg2, SWIGTYPE_p_FXPopup, 1); if (argc > 2) {
        SWIG_ConvertPtr(argv[2], (void **) &arg3, SWIGTYPE_p_FXObject, 1); }  if (argc > 3) { arg4 = NUM2UINT(argv[3]); } 
    if (argc > 4) { arg5 = NUM2UINT(argv[4]); }  if (argc > 5) { arg6 = NUM2INT(argv[5]); }  if (argc > 6) {
        arg7 = NUM2INT(argv[6]); }  if (argc > 7) { arg8 = NUM2INT(argv[7]); }  if (argc > 8) { arg9 = NUM2INT(argv[8]); }  {
        result = (FXMDIWindowButton *)new_FXMDIWindowButton(arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8,arg9);
        DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result); if(rb_block_given_p()){ rb_yield(self); }  }  return self; }
static void
free_FXMDIWindowButton(FXMDIWindowButton *arg1) {
    delete arg1;
}
static VALUE _wrap_FXMDIWindowButton_save(int argc, VALUE *argv, VALUE self) {
    FXMDIWindowButton *arg1 = (FXMDIWindowButton *) 0 ; FXStream *arg2 = 0 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIWindowButton, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXMDIWindowButton_save((FXMDIWindowButton const *)arg1,*arg2); return Qnil; }
static VALUE _wrap_FXMDIWindowButton_load(int argc, VALUE *argv, VALUE self) {
    FXMDIWindowButton *arg1 = (FXMDIWindowButton *) 0 ; FXStream *arg2 = 0 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIWindowButton, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXMDIWindowButton_load(arg1,*arg2); return Qnil; }
static VALUE _wrap_FXMDIWindowButton_create(int argc, VALUE *argv, VALUE self) {
    FXMDIWindowButton *arg1 = (FXMDIWindowButton *) 0 ; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIWindowButton, 1); FXMDIWindowButton_create(arg1); return Qnil; }
static VALUE _wrap_FXMDIWindowButton_detach(int argc, VALUE *argv, VALUE self) {
    FXMDIWindowButton *arg1 = (FXMDIWindowButton *) 0 ; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIWindowButton, 1); FXMDIWindowButton_detach(arg1); return Qnil; }
static VALUE _wrap_FXMDIWindowButton_destroy(int argc, VALUE *argv, VALUE self) {
    FXMDIWindowButton *arg1 = (FXMDIWindowButton *) 0 ; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIWindowButton, 1); FXMDIWindowButton_destroy(arg1); return Qnil; }
static VALUE _wrap_FXMDIWindowButton_resize(int argc, VALUE *argv, VALUE self) {
    FXMDIWindowButton *arg1 = (FXMDIWindowButton *) 0 ; FXint arg2 ; FXint arg3 ; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIWindowButton, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    FXMDIWindowButton_resize(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXMDIWindowButton_getDefaultWidth(int argc, VALUE *argv, VALUE self) {
    FXMDIWindowButton *arg1 = (FXMDIWindowButton *) 0 ; FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIWindowButton, 1);
    result = (FXint)FXMDIWindowButton_getDefaultWidth(arg1); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXMDIWindowButton_getDefaultHeight(int argc, VALUE *argv, VALUE self) {
    FXMDIWindowButton *arg1 = (FXMDIWindowButton *) 0 ; FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIWindowButton, 1);
    result = (FXint)FXMDIWindowButton_getDefaultHeight(arg1); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXMDIWindowButton_getWidthForHeight(int argc, VALUE *argv, VALUE self) {
    FXMDIWindowButton *arg1 = (FXMDIWindowButton *) 0 ; FXint arg2 ; FXint result; VALUE vresult = Qnil;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIWindowButton, 1); arg2 = NUM2INT(argv[0]);
    result = (FXint)FXMDIWindowButton_getWidthForHeight(arg1,arg2); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXMDIWindowButton_getHeightForWidth(int argc, VALUE *argv, VALUE self) {
    FXMDIWindowButton *arg1 = (FXMDIWindowButton *) 0 ; FXint arg2 ; FXint result; VALUE vresult = Qnil;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIWindowButton, 1); arg2 = NUM2INT(argv[0]);
    result = (FXint)FXMDIWindowButton_getHeightForWidth(arg1,arg2); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXMDIWindowButton_canFocus(int argc, VALUE *argv, VALUE self) {
    FXMDIWindowButton *arg1 = (FXMDIWindowButton *) 0 ; FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIWindowButton, 1);
    result = (FXbool)FXMDIWindowButton_canFocus((FXMDIWindowButton const *)arg1); vresult = result ? Qtrue : Qfalse;
    return vresult; }
static VALUE _wrap_FXMDIWindowButton_setFocus(int argc, VALUE *argv, VALUE self) {
    FXMDIWindowButton *arg1 = (FXMDIWindowButton *) 0 ; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIWindowButton, 1); FXMDIWindowButton_setFocus(arg1); return Qnil; }
static VALUE _wrap_FXMDIWindowButton_killFocus(int argc, VALUE *argv, VALUE self) {
    FXMDIWindowButton *arg1 = (FXMDIWindowButton *) 0 ; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIWindowButton, 1); FXMDIWindowButton_killFocus(arg1); return Qnil; }
static VALUE _wrap_FXMDIWindowButton_setDefault(int argc, VALUE *argv, VALUE self) {
    FXMDIWindowButton *arg1 = (FXMDIWindowButton *) 0 ; FXbool arg2 = (FXbool) 1 ; if ((argc < 0) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIWindowButton, 1); if (argc > 0) { arg2 = to_FXbool(argv[0]); } 
    FXMDIWindowButton_setDefault(arg1,arg2); return Qnil; }
static VALUE _wrap_FXMDIWindowButton_enable(int argc, VALUE *argv, VALUE self) {
    FXMDIWindowButton *arg1 = (FXMDIWindowButton *) 0 ; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIWindowButton, 1); FXMDIWindowButton_enable(arg1); return Qnil; }
static VALUE _wrap_FXMDIWindowButton_disable(int argc, VALUE *argv, VALUE self) {
    FXMDIWindowButton *arg1 = (FXMDIWindowButton *) 0 ; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIWindowButton, 1); FXMDIWindowButton_disable(arg1); return Qnil; }
static VALUE _wrap_FXMDIWindowButton_raiseWindow(int argc, VALUE *argv, VALUE self) {
    FXMDIWindowButton *arg1 = (FXMDIWindowButton *) 0 ; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIWindowButton, 1); FXMDIWindowButton_raise(arg1); return Qnil; }
static VALUE _wrap_FXMDIWindowButton_lower(int argc, VALUE *argv, VALUE self) {
    FXMDIWindowButton *arg1 = (FXMDIWindowButton *) 0 ; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIWindowButton, 1); FXMDIWindowButton_lower(arg1); return Qnil; }
static VALUE _wrap_FXMDIWindowButton_move(int argc, VALUE *argv, VALUE self) {
    FXMDIWindowButton *arg1 = (FXMDIWindowButton *) 0 ; FXint arg2 ; FXint arg3 ; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIWindowButton, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    FXMDIWindowButton_move(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXMDIWindowButton_position(int argc, VALUE *argv, VALUE self) {
    FXMDIWindowButton *arg1 = (FXMDIWindowButton *) 0 ; FXint arg2 ; FXint arg3 ; FXint arg4 ; FXint arg5 ;
    if ((argc < 4) || (argc > 4)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIWindowButton, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    arg4 = NUM2INT(argv[2]); arg5 = NUM2INT(argv[3]); FXMDIWindowButton_position(arg1,arg2,arg3,arg4,arg5); return Qnil; }
static VALUE _wrap_FXMDIWindowButton_layout(int argc, VALUE *argv, VALUE self) {
    FXMDIWindowButton *arg1 = (FXMDIWindowButton *) 0 ; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIWindowButton, 1); FXMDIWindowButton_layout(arg1); return Qnil; }
static VALUE _wrap_FXMDIWindowButton_recalc(int argc, VALUE *argv, VALUE self) {
    FXMDIWindowButton *arg1 = (FXMDIWindowButton *) 0 ; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIWindowButton, 1); FXMDIWindowButton_recalc(arg1); return Qnil; }
static VALUE _wrap_FXMDIWindowButton_reparent(int argc, VALUE *argv, VALUE self) {
    FXMDIWindowButton *arg1 = (FXMDIWindowButton *) 0 ; FXComposite *arg2 = (FXComposite *) 0 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIWindowButton, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXComposite, 1); FXMDIWindowButton_reparent(arg1,arg2); return Qnil; }
static VALUE _wrap_FXMDIWindowButton_show(int argc, VALUE *argv, VALUE self) {
    FXMDIWindowButton *arg1 = (FXMDIWindowButton *) 0 ; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIWindowButton, 1); FXMDIWindowButton_show(arg1); return Qnil; }
static VALUE _wrap_FXMDIWindowButton_hide(int argc, VALUE *argv, VALUE self) {
    FXMDIWindowButton *arg1 = (FXMDIWindowButton *) 0 ; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIWindowButton, 1); FXMDIWindowButton_hide(arg1); return Qnil; }
static VALUE _wrap_FXMDIWindowButton_isComposite(int argc, VALUE *argv, VALUE self) {
    FXMDIWindowButton *arg1 = (FXMDIWindowButton *) 0 ; FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIWindowButton, 1);
    result = (FXbool)FXMDIWindowButton_isComposite((FXMDIWindowButton const *)arg1); vresult = result ? Qtrue : Qfalse;
    return vresult; }
static VALUE _wrap_FXMDIWindowButton_contains(int argc, VALUE *argv, VALUE self) {
    FXMDIWindowButton *arg1 = (FXMDIWindowButton *) 0 ; FXint arg2 ; FXint arg3 ; FXbool result; VALUE vresult = Qnil;
    if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIWindowButton, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    result = (FXbool)FXMDIWindowButton_contains((FXMDIWindowButton const *)arg1,arg2,arg3); vresult = result ? Qtrue : Qfalse;
    return vresult; }
static VALUE _wrap_FXMDIWindowButton_doesSaveUnder(int argc, VALUE *argv, VALUE self) {
    FXMDIWindowButton *arg1 = (FXMDIWindowButton *) 0 ; FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIWindowButton, 1);
    result = (FXbool)FXMDIWindowButton_doesSaveUnder((FXMDIWindowButton const *)arg1); vresult = result ? Qtrue : Qfalse;
    return vresult; }
static VALUE _wrap_FXMDIWindowButton_setBackColor(int argc, VALUE *argv, VALUE self) {
    FXMDIWindowButton *arg1 = (FXMDIWindowButton *) 0 ; FXColor arg2 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIWindowButton, 1); arg2 = to_FXColor(argv[0]);
    FXMDIWindowButton_setBackColor(arg1,arg2); return Qnil; }
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE _wrap_FXMDIMenu_allocate(VALUE self) {
#else
     static VALUE _wrap_FXMDIMenu_allocate(int argc, VALUE *argv, VALUE self) {
#endif
         VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_FXMDIMenu);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
         return vresult; }
static VALUE _wrap_new_FXMDIMenu(int argc, VALUE *argv, VALUE self) { FXWindow *arg1 = (FXWindow *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXMDIMenu *result; if ((argc < 1) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXWindow, 1); if (argc > 1) {
        SWIG_ConvertPtr(argv[1], (void **) &arg2, SWIGTYPE_p_FXObject, 1); }  { result = (FXMDIMenu *)new_FXMDIMenu(arg1,arg2);
        DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result); if(rb_block_given_p()){ rb_yield(self); }  }  return self; }
static void
free_FXMDIMenu(FXMDIMenu *arg1) {
    delete arg1;
}
static VALUE _wrap_FXMDIMenu_save(int argc, VALUE *argv, VALUE self) { FXMDIMenu *arg1 = (FXMDIMenu *) 0 ; FXStream *arg2 = 0 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIMenu, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXMDIMenu_save((FXMDIMenu const *)arg1,*arg2); return Qnil; }
static VALUE _wrap_FXMDIMenu_load(int argc, VALUE *argv, VALUE self) { FXMDIMenu *arg1 = (FXMDIMenu *) 0 ; FXStream *arg2 = 0 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIMenu, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXMDIMenu_load(arg1,*arg2); return Qnil; }
static VALUE _wrap_FXMDIMenu_create(int argc, VALUE *argv, VALUE self) { FXMDIMenu *arg1 = (FXMDIMenu *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIMenu, 1); FXMDIMenu_create(arg1); return Qnil; }
static VALUE _wrap_FXMDIMenu_detach(int argc, VALUE *argv, VALUE self) { FXMDIMenu *arg1 = (FXMDIMenu *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIMenu, 1); FXMDIMenu_detach(arg1); return Qnil; }
static VALUE _wrap_FXMDIMenu_destroy(int argc, VALUE *argv, VALUE self) { FXMDIMenu *arg1 = (FXMDIMenu *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIMenu, 1); FXMDIMenu_destroy(arg1); return Qnil; }
static VALUE _wrap_FXMDIMenu_resize(int argc, VALUE *argv, VALUE self) { FXMDIMenu *arg1 = (FXMDIMenu *) 0 ; FXint arg2 ;
    FXint arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIMenu, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    FXMDIMenu_resize(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXMDIMenu_getDefaultWidth(int argc, VALUE *argv, VALUE self) { FXMDIMenu *arg1 = (FXMDIMenu *) 0 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIMenu, 1); result = (FXint)FXMDIMenu_getDefaultWidth(arg1);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXMDIMenu_getDefaultHeight(int argc, VALUE *argv, VALUE self) { FXMDIMenu *arg1 = (FXMDIMenu *) 0 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIMenu, 1); result = (FXint)FXMDIMenu_getDefaultHeight(arg1);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXMDIMenu_getWidthForHeight(int argc, VALUE *argv, VALUE self) { FXMDIMenu *arg1 = (FXMDIMenu *) 0 ;
    FXint arg2 ; FXint result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIMenu, 1); arg2 = NUM2INT(argv[0]);
    result = (FXint)FXMDIMenu_getWidthForHeight(arg1,arg2); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXMDIMenu_getHeightForWidth(int argc, VALUE *argv, VALUE self) { FXMDIMenu *arg1 = (FXMDIMenu *) 0 ;
    FXint arg2 ; FXint result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIMenu, 1); arg2 = NUM2INT(argv[0]);
    result = (FXint)FXMDIMenu_getHeightForWidth(arg1,arg2); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXMDIMenu_canFocus(int argc, VALUE *argv, VALUE self) { FXMDIMenu *arg1 = (FXMDIMenu *) 0 ; FXbool result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIMenu, 1);
    result = (FXbool)FXMDIMenu_canFocus((FXMDIMenu const *)arg1); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXMDIMenu_setFocus(int argc, VALUE *argv, VALUE self) { FXMDIMenu *arg1 = (FXMDIMenu *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIMenu, 1); FXMDIMenu_setFocus(arg1); return Qnil; }
static VALUE _wrap_FXMDIMenu_killFocus(int argc, VALUE *argv, VALUE self) { FXMDIMenu *arg1 = (FXMDIMenu *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIMenu, 1); FXMDIMenu_killFocus(arg1); return Qnil; }
static VALUE _wrap_FXMDIMenu_setDefault(int argc, VALUE *argv, VALUE self) { FXMDIMenu *arg1 = (FXMDIMenu *) 0 ;
    FXbool arg2 = (FXbool) 1 ; if ((argc < 0) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIMenu, 1); if (argc > 0) { arg2 = to_FXbool(argv[0]); } 
    FXMDIMenu_setDefault(arg1,arg2); return Qnil; }
static VALUE _wrap_FXMDIMenu_enable(int argc, VALUE *argv, VALUE self) { FXMDIMenu *arg1 = (FXMDIMenu *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIMenu, 1); FXMDIMenu_enable(arg1); return Qnil; }
static VALUE _wrap_FXMDIMenu_disable(int argc, VALUE *argv, VALUE self) { FXMDIMenu *arg1 = (FXMDIMenu *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIMenu, 1); FXMDIMenu_disable(arg1); return Qnil; }
static VALUE _wrap_FXMDIMenu_raiseWindow(int argc, VALUE *argv, VALUE self) { FXMDIMenu *arg1 = (FXMDIMenu *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIMenu, 1); FXMDIMenu_raise(arg1); return Qnil; }
static VALUE _wrap_FXMDIMenu_lower(int argc, VALUE *argv, VALUE self) { FXMDIMenu *arg1 = (FXMDIMenu *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIMenu, 1); FXMDIMenu_lower(arg1); return Qnil; }
static VALUE _wrap_FXMDIMenu_move(int argc, VALUE *argv, VALUE self) { FXMDIMenu *arg1 = (FXMDIMenu *) 0 ; FXint arg2 ;
    FXint arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIMenu, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    FXMDIMenu_move(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXMDIMenu_position(int argc, VALUE *argv, VALUE self) { FXMDIMenu *arg1 = (FXMDIMenu *) 0 ; FXint arg2 ;
    FXint arg3 ; FXint arg4 ; FXint arg5 ; if ((argc < 4) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIMenu, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    arg4 = NUM2INT(argv[2]); arg5 = NUM2INT(argv[3]); FXMDIMenu_position(arg1,arg2,arg3,arg4,arg5); return Qnil; }
static VALUE _wrap_FXMDIMenu_layout(int argc, VALUE *argv, VALUE self) { FXMDIMenu *arg1 = (FXMDIMenu *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIMenu, 1); FXMDIMenu_layout(arg1); return Qnil; }
static VALUE _wrap_FXMDIMenu_recalc(int argc, VALUE *argv, VALUE self) { FXMDIMenu *arg1 = (FXMDIMenu *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIMenu, 1); FXMDIMenu_recalc(arg1); return Qnil; }
static VALUE _wrap_FXMDIMenu_reparent(int argc, VALUE *argv, VALUE self) { FXMDIMenu *arg1 = (FXMDIMenu *) 0 ;
    FXComposite *arg2 = (FXComposite *) 0 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIMenu, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXComposite, 1); FXMDIMenu_reparent(arg1,arg2); return Qnil; }
static VALUE _wrap_FXMDIMenu_show(int argc, VALUE *argv, VALUE self) { FXMDIMenu *arg1 = (FXMDIMenu *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIMenu, 1); FXMDIMenu_show(arg1); return Qnil; }
static VALUE _wrap_FXMDIMenu_hide(int argc, VALUE *argv, VALUE self) { FXMDIMenu *arg1 = (FXMDIMenu *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIMenu, 1); FXMDIMenu_hide(arg1); return Qnil; }
static VALUE _wrap_FXMDIMenu_isComposite(int argc, VALUE *argv, VALUE self) { FXMDIMenu *arg1 = (FXMDIMenu *) 0 ; FXbool result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIMenu, 1);
    result = (FXbool)FXMDIMenu_isComposite((FXMDIMenu const *)arg1); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXMDIMenu_contains(int argc, VALUE *argv, VALUE self) { FXMDIMenu *arg1 = (FXMDIMenu *) 0 ; FXint arg2 ;
    FXint arg3 ; FXbool result; VALUE vresult = Qnil; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIMenu, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    result = (FXbool)FXMDIMenu_contains((FXMDIMenu const *)arg1,arg2,arg3); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXMDIMenu_doesSaveUnder(int argc, VALUE *argv, VALUE self) { FXMDIMenu *arg1 = (FXMDIMenu *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIMenu, 1);
    result = (FXbool)FXMDIMenu_doesSaveUnder((FXMDIMenu const *)arg1); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXMDIMenu_setBackColor(int argc, VALUE *argv, VALUE self) { FXMDIMenu *arg1 = (FXMDIMenu *) 0 ;
    FXColor arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIMenu, 1); arg2 = to_FXColor(argv[0]);
    FXMDIMenu_setBackColor(arg1,arg2); return Qnil; }
static VALUE _wrap_FXMDIMenu_popup(int argc, VALUE *argv, VALUE self) { FXMDIMenu *arg1 = (FXMDIMenu *) 0 ;
    FXWindow *arg2 = (FXWindow *) 0 ; FXint arg3 ; FXint arg4 ; FXint arg5 = (FXint) 0 ; FXint arg6 = (FXint) 0 ;
    if ((argc < 3) || (argc > 5)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIMenu, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXWindow, 1); arg3 = NUM2INT(argv[1]); arg4 = NUM2INT(argv[2]);
    if (argc > 3) { arg5 = NUM2INT(argv[3]); }  if (argc > 4) { arg6 = NUM2INT(argv[4]); } 
    FXMDIMenu_popup(arg1,arg2,arg3,arg4,arg5,arg6); return Qnil; }
static VALUE _wrap_FXMDIMenu_popdown(int argc, VALUE *argv, VALUE self) { FXMDIMenu *arg1 = (FXMDIMenu *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIMenu, 1); FXMDIMenu_popdown(arg1); return Qnil; }
static VALUE _wrap_FXMDIClient_onCmdActivateNext(int argc, VALUE *argv, VALUE self) { FXMDIClient *arg1 = (FXMDIClient *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIClient, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdActivateNext(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXMDIClient_onCmdActivatePrev(int argc, VALUE *argv, VALUE self) { FXMDIClient *arg1 = (FXMDIClient *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIClient, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdActivatePrev(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXMDIClient_onCmdTileHorizontal(int argc, VALUE *argv, VALUE self) { FXMDIClient *arg1 = (FXMDIClient *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIClient, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdTileHorizontal(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXMDIClient_onCmdTileVertical(int argc, VALUE *argv, VALUE self) { FXMDIClient *arg1 = (FXMDIClient *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIClient, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdTileVertical(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXMDIClient_onCmdCascade(int argc, VALUE *argv, VALUE self) { FXMDIClient *arg1 = (FXMDIClient *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIClient, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdCascade(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXMDIClient_onUpdActivateNext(int argc, VALUE *argv, VALUE self) { FXMDIClient *arg1 = (FXMDIClient *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIClient, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onUpdActivateNext(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXMDIClient_onUpdActivatePrev(int argc, VALUE *argv, VALUE self) { FXMDIClient *arg1 = (FXMDIClient *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIClient, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onUpdActivatePrev(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXMDIClient_onUpdTileVertical(int argc, VALUE *argv, VALUE self) { FXMDIClient *arg1 = (FXMDIClient *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIClient, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onUpdTileVertical(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXMDIClient_onUpdTileHorizontal(int argc, VALUE *argv, VALUE self) { FXMDIClient *arg1 = (FXMDIClient *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIClient, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onUpdTileHorizontal(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXMDIClient_onUpdCascade(int argc, VALUE *argv, VALUE self) { FXMDIClient *arg1 = (FXMDIClient *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIClient, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onUpdCascade(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXMDIClient_onUpdClose(int argc, VALUE *argv, VALUE self) { FXMDIClient *arg1 = (FXMDIClient *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIClient, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onUpdClose(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXMDIClient_onUpdMenuClose(int argc, VALUE *argv, VALUE self) { FXMDIClient *arg1 = (FXMDIClient *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIClient, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onUpdMenuClose(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXMDIClient_onUpdRestore(int argc, VALUE *argv, VALUE self) { FXMDIClient *arg1 = (FXMDIClient *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIClient, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onUpdRestore(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXMDIClient_onUpdMenuRestore(int argc, VALUE *argv, VALUE self) { FXMDIClient *arg1 = (FXMDIClient *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIClient, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onUpdMenuRestore(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXMDIClient_onUpdMinimize(int argc, VALUE *argv, VALUE self) { FXMDIClient *arg1 = (FXMDIClient *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIClient, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onUpdMinimize(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXMDIClient_onUpdMenuMinimize(int argc, VALUE *argv, VALUE self) { FXMDIClient *arg1 = (FXMDIClient *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIClient, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onUpdMenuMinimize(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXMDIClient_onUpdMaximize(int argc, VALUE *argv, VALUE self) { FXMDIClient *arg1 = (FXMDIClient *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIClient, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onUpdMaximize(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXMDIClient_onUpdMenuWindow(int argc, VALUE *argv, VALUE self) { FXMDIClient *arg1 = (FXMDIClient *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIClient, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onUpdMenuWindow(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXMDIClient_onCmdWindowSelect(int argc, VALUE *argv, VALUE self) { FXMDIClient *arg1 = (FXMDIClient *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIClient, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdWindowSelect(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXMDIClient_onUpdWindowSelect(int argc, VALUE *argv, VALUE self) { FXMDIClient *arg1 = (FXMDIClient *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIClient, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onUpdWindowSelect(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXMDIClient_onCmdOthersWindows(int argc, VALUE *argv, VALUE self) { FXMDIClient *arg1 = (FXMDIClient *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIClient, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdOthersWindows(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXMDIClient_onUpdOthersWindows(int argc, VALUE *argv, VALUE self) { FXMDIClient *arg1 = (FXMDIClient *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIClient, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onUpdOthersWindows(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXMDIClient_onUpdAnyWindows(int argc, VALUE *argv, VALUE self) { FXMDIClient *arg1 = (FXMDIClient *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIClient, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onUpdAnyWindows(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE _wrap_FXMDIClient_allocate(VALUE self) {
#else
     static VALUE _wrap_FXMDIClient_allocate(int argc, VALUE *argv, VALUE self) {
#endif
         VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_FXMDIClient);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
         return vresult; }
static VALUE _wrap_new_FXMDIClient(int argc, VALUE *argv, VALUE self) { FXComposite *arg1 = (FXComposite *) 0 ;
    FXuint arg2 = (FXuint) 0 ; FXint arg3 = (FXint) 0 ; FXint arg4 = (FXint) 0 ; FXint arg5 = (FXint) 0 ;
    FXint arg6 = (FXint) 0 ; FXMDIClient *result; if ((argc < 1) || (argc > 6))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXComposite, 1); if (argc > 1) { arg2 = NUM2UINT(argv[1]); } 
    if (argc > 2) { arg3 = NUM2INT(argv[2]); }  if (argc > 3) { arg4 = NUM2INT(argv[3]); }  if (argc > 4) {
        arg5 = NUM2INT(argv[4]); }  if (argc > 5) { arg6 = NUM2INT(argv[5]); }  {
        result = (FXMDIClient *)new_FXMDIClient(arg1,arg2,arg3,arg4,arg5,arg6);
        DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result); if(rb_block_given_p()){ rb_yield(self); }  }  return self; }
static VALUE _wrap_FXMDIClient_forallWindows(int argc, VALUE *argv, VALUE self) { FXMDIClient *arg1 = (FXMDIClient *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIClient, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]);
    SWIG_ConvertPtr(argv[2], (void **) &arg4, 0, 1); result = (long)(arg1)->forallWindows(arg2,arg3,arg4);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXMDIClient_forallDocuments(int argc, VALUE *argv, VALUE self) { FXMDIClient *arg1 = (FXMDIClient *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIClient, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]);
    SWIG_ConvertPtr(argv[2], (void **) &arg4, 0, 1); result = (long)(arg1)->forallDocuments(arg2,arg3,arg4);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXMDIClient_forallDocWindows(int argc, VALUE *argv, VALUE self) { FXMDIClient *arg1 = (FXMDIClient *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXObject *arg3 = (FXObject *) 0 ; FXSelector arg4 ; void *arg5 = (void *) 0 ; long result;
    VALUE vresult = Qnil; if ((argc < 4) || (argc > 4)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIClient, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1);
    SWIG_ConvertPtr(argv[1], (void **) &arg3, SWIGTYPE_p_FXObject, 1); arg4 = NUM2UINT(argv[2]);
    SWIG_ConvertPtr(argv[3], (void **) &arg5, 0, 1); result = (long)(arg1)->forallDocWindows(arg2,arg3,arg4,arg5);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXMDIClient_getActiveChild(int argc, VALUE *argv, VALUE self) { FXMDIClient *arg1 = (FXMDIClient *) 0 ;
    FXMDIChild *result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIClient, 1);
    result = (FXMDIChild *)((FXMDIClient const *)arg1)->getActiveChild(); {
        swig_type_info *ty = SWIG_TypeDynamicCast(SWIGTYPE_p_FXMDIChild, (void **) &result);
        vresult = FXRbGetRubyObj(result, ty); }  return vresult; }
static VALUE _wrap_FXMDIClient_setCascadeX(int argc, VALUE *argv, VALUE self) { FXMDIClient *arg1 = (FXMDIClient *) 0 ;
    FXint arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIClient, 1); arg2 = NUM2INT(argv[0]); (arg1)->setCascadeX(arg2);
    return Qnil; }
static VALUE _wrap_FXMDIClient_setCascadeY(int argc, VALUE *argv, VALUE self) { FXMDIClient *arg1 = (FXMDIClient *) 0 ;
    FXint arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIClient, 1); arg2 = NUM2INT(argv[0]); (arg1)->setCascadeY(arg2);
    return Qnil; }
static VALUE _wrap_FXMDIClient_getCascadeX(int argc, VALUE *argv, VALUE self) { FXMDIClient *arg1 = (FXMDIClient *) 0 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIClient, 1);
    result = (FXint)((FXMDIClient const *)arg1)->getCascadeX(); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXMDIClient_getCascadeY(int argc, VALUE *argv, VALUE self) { FXMDIClient *arg1 = (FXMDIClient *) 0 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIClient, 1);
    result = (FXint)((FXMDIClient const *)arg1)->getCascadeY(); vresult = INT2NUM(result); return vresult; }
static void
free_FXMDIClient(FXMDIClient *arg1) {
    delete arg1;
}
static VALUE _wrap_FXMDIClient_save(int argc, VALUE *argv, VALUE self) { FXMDIClient *arg1 = (FXMDIClient *) 0 ;
    FXStream *arg2 = 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIClient, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXMDIClient_save((FXMDIClient const *)arg1,*arg2); return Qnil; }
static VALUE _wrap_FXMDIClient_load(int argc, VALUE *argv, VALUE self) { FXMDIClient *arg1 = (FXMDIClient *) 0 ;
    FXStream *arg2 = 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIClient, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXMDIClient_load(arg1,*arg2); return Qnil; }
static VALUE _wrap_FXMDIClient_create(int argc, VALUE *argv, VALUE self) { FXMDIClient *arg1 = (FXMDIClient *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIClient, 1); FXMDIClient_create(arg1); return Qnil; }
static VALUE _wrap_FXMDIClient_detach(int argc, VALUE *argv, VALUE self) { FXMDIClient *arg1 = (FXMDIClient *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIClient, 1); FXMDIClient_detach(arg1); return Qnil; }
static VALUE _wrap_FXMDIClient_destroy(int argc, VALUE *argv, VALUE self) { FXMDIClient *arg1 = (FXMDIClient *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIClient, 1); FXMDIClient_destroy(arg1); return Qnil; }
static VALUE _wrap_FXMDIClient_resize(int argc, VALUE *argv, VALUE self) { FXMDIClient *arg1 = (FXMDIClient *) 0 ; FXint arg2 ;
    FXint arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIClient, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    FXMDIClient_resize(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXMDIClient_getDefaultWidth(int argc, VALUE *argv, VALUE self) { FXMDIClient *arg1 = (FXMDIClient *) 0 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIClient, 1); result = (FXint)FXMDIClient_getDefaultWidth(arg1);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXMDIClient_getDefaultHeight(int argc, VALUE *argv, VALUE self) { FXMDIClient *arg1 = (FXMDIClient *) 0 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIClient, 1); result = (FXint)FXMDIClient_getDefaultHeight(arg1);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXMDIClient_getWidthForHeight(int argc, VALUE *argv, VALUE self) { FXMDIClient *arg1 = (FXMDIClient *) 0 ;
    FXint arg2 ; FXint result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIClient, 1); arg2 = NUM2INT(argv[0]);
    result = (FXint)FXMDIClient_getWidthForHeight(arg1,arg2); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXMDIClient_getHeightForWidth(int argc, VALUE *argv, VALUE self) { FXMDIClient *arg1 = (FXMDIClient *) 0 ;
    FXint arg2 ; FXint result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIClient, 1); arg2 = NUM2INT(argv[0]);
    result = (FXint)FXMDIClient_getHeightForWidth(arg1,arg2); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXMDIClient_canFocus(int argc, VALUE *argv, VALUE self) { FXMDIClient *arg1 = (FXMDIClient *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIClient, 1);
    result = (FXbool)FXMDIClient_canFocus((FXMDIClient const *)arg1); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXMDIClient_setFocus(int argc, VALUE *argv, VALUE self) { FXMDIClient *arg1 = (FXMDIClient *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIClient, 1); FXMDIClient_setFocus(arg1); return Qnil; }
static VALUE _wrap_FXMDIClient_killFocus(int argc, VALUE *argv, VALUE self) { FXMDIClient *arg1 = (FXMDIClient *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIClient, 1); FXMDIClient_killFocus(arg1); return Qnil; }
static VALUE _wrap_FXMDIClient_setDefault(int argc, VALUE *argv, VALUE self) { FXMDIClient *arg1 = (FXMDIClient *) 0 ;
    FXbool arg2 = (FXbool) 1 ; if ((argc < 0) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIClient, 1); if (argc > 0) { arg2 = to_FXbool(argv[0]); } 
    FXMDIClient_setDefault(arg1,arg2); return Qnil; }
static VALUE _wrap_FXMDIClient_enable(int argc, VALUE *argv, VALUE self) { FXMDIClient *arg1 = (FXMDIClient *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIClient, 1); FXMDIClient_enable(arg1); return Qnil; }
static VALUE _wrap_FXMDIClient_disable(int argc, VALUE *argv, VALUE self) { FXMDIClient *arg1 = (FXMDIClient *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIClient, 1); FXMDIClient_disable(arg1); return Qnil; }
static VALUE _wrap_FXMDIClient_raiseWindow(int argc, VALUE *argv, VALUE self) { FXMDIClient *arg1 = (FXMDIClient *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIClient, 1); FXMDIClient_raise(arg1); return Qnil; }
static VALUE _wrap_FXMDIClient_lower(int argc, VALUE *argv, VALUE self) { FXMDIClient *arg1 = (FXMDIClient *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIClient, 1); FXMDIClient_lower(arg1); return Qnil; }
static VALUE _wrap_FXMDIClient_move(int argc, VALUE *argv, VALUE self) { FXMDIClient *arg1 = (FXMDIClient *) 0 ; FXint arg2 ;
    FXint arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIClient, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    FXMDIClient_move(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXMDIClient_position(int argc, VALUE *argv, VALUE self) { FXMDIClient *arg1 = (FXMDIClient *) 0 ;
    FXint arg2 ; FXint arg3 ; FXint arg4 ; FXint arg5 ; if ((argc < 4) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIClient, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    arg4 = NUM2INT(argv[2]); arg5 = NUM2INT(argv[3]); FXMDIClient_position(arg1,arg2,arg3,arg4,arg5); return Qnil; }
static VALUE _wrap_FXMDIClient_layout(int argc, VALUE *argv, VALUE self) { FXMDIClient *arg1 = (FXMDIClient *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIClient, 1); FXMDIClient_layout(arg1); return Qnil; }
static VALUE _wrap_FXMDIClient_recalc(int argc, VALUE *argv, VALUE self) { FXMDIClient *arg1 = (FXMDIClient *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIClient, 1); FXMDIClient_recalc(arg1); return Qnil; }
static VALUE _wrap_FXMDIClient_reparent(int argc, VALUE *argv, VALUE self) { FXMDIClient *arg1 = (FXMDIClient *) 0 ;
    FXComposite *arg2 = (FXComposite *) 0 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIClient, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXComposite, 1); FXMDIClient_reparent(arg1,arg2); return Qnil; }
static VALUE _wrap_FXMDIClient_show(int argc, VALUE *argv, VALUE self) { FXMDIClient *arg1 = (FXMDIClient *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIClient, 1); FXMDIClient_show(arg1); return Qnil; }
static VALUE _wrap_FXMDIClient_hide(int argc, VALUE *argv, VALUE self) { FXMDIClient *arg1 = (FXMDIClient *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIClient, 1); FXMDIClient_hide(arg1); return Qnil; }
static VALUE _wrap_FXMDIClient_isComposite(int argc, VALUE *argv, VALUE self) { FXMDIClient *arg1 = (FXMDIClient *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIClient, 1);
    result = (FXbool)FXMDIClient_isComposite((FXMDIClient const *)arg1); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXMDIClient_contains(int argc, VALUE *argv, VALUE self) { FXMDIClient *arg1 = (FXMDIClient *) 0 ;
    FXint arg2 ; FXint arg3 ; FXbool result; VALUE vresult = Qnil; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIClient, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    result = (FXbool)FXMDIClient_contains((FXMDIClient const *)arg1,arg2,arg3); vresult = result ? Qtrue : Qfalse;
    return vresult; }
static VALUE _wrap_FXMDIClient_doesSaveUnder(int argc, VALUE *argv, VALUE self) { FXMDIClient *arg1 = (FXMDIClient *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIClient, 1);
    result = (FXbool)FXMDIClient_doesSaveUnder((FXMDIClient const *)arg1); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXMDIClient_setBackColor(int argc, VALUE *argv, VALUE self) { FXMDIClient *arg1 = (FXMDIClient *) 0 ;
    FXColor arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIClient, 1); arg2 = to_FXColor(argv[0]);
    FXMDIClient_setBackColor(arg1,arg2); return Qnil; }
static VALUE _wrap_FXMDIClient_setActiveChild(int argc, VALUE *argv, VALUE self) { FXMDIClient *arg1 = (FXMDIClient *) 0 ;
    FXMDIChild *arg2 = (FXMDIChild *) 0 ; FXbool arg3 = (FXbool) 1 ; FXbool result; VALUE vresult = Qnil;
    if ((argc < 0) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIClient, 1); if (argc > 0) {
        SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXMDIChild, 1); }  if (argc > 1) { arg3 = to_FXbool(argv[1]); } 
    result = (FXbool)FXMDIClient_setActiveChild(arg1,arg2,arg3); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXMDIClient_cascade(int argc, VALUE *argv, VALUE self) { FXMDIClient *arg1 = (FXMDIClient *) 0 ;
    FXbool arg2 = (FXbool) 0 ; if ((argc < 0) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIClient, 1); if (argc > 0) { arg2 = to_FXbool(argv[0]); } 
    FXMDIClient_cascade(arg1,arg2); return Qnil; }
static VALUE _wrap_FXMDIClient_horizontal(int argc, VALUE *argv, VALUE self) { FXMDIClient *arg1 = (FXMDIClient *) 0 ;
    FXbool arg2 = (FXbool) 0 ; if ((argc < 0) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIClient, 1); if (argc > 0) { arg2 = to_FXbool(argv[0]); } 
    FXMDIClient_horizontal(arg1,arg2); return Qnil; }
static VALUE _wrap_FXMDIClient_vertical(int argc, VALUE *argv, VALUE self) { FXMDIClient *arg1 = (FXMDIClient *) 0 ;
    FXbool arg2 = (FXbool) 0 ; if ((argc < 0) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIClient, 1); if (argc > 0) { arg2 = to_FXbool(argv[0]); } 
    FXMDIClient_vertical(arg1,arg2); return Qnil; }
static VALUE _wrap_FXMDIChild_onPaint(int argc, VALUE *argv, VALUE self) { FXMDIChild *arg1 = (FXMDIChild *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIChild, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onPaint(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXMDIChild_onFocusSelf(int argc, VALUE *argv, VALUE self) { FXMDIChild *arg1 = (FXMDIChild *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIChild, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onFocusSelf(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXMDIChild_onFocusIn(int argc, VALUE *argv, VALUE self) { FXMDIChild *arg1 = (FXMDIChild *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIChild, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onFocusIn(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXMDIChild_onFocusOut(int argc, VALUE *argv, VALUE self) { FXMDIChild *arg1 = (FXMDIChild *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIChild, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onFocusOut(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXMDIChild_onRightBtnPress(int argc, VALUE *argv, VALUE self) { FXMDIChild *arg1 = (FXMDIChild *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIChild, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onRightBtnPress(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXMDIChild_onRightBtnRelease(int argc, VALUE *argv, VALUE self) { FXMDIChild *arg1 = (FXMDIChild *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIChild, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onRightBtnRelease(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXMDIChild_onLeftBtnPress(int argc, VALUE *argv, VALUE self) { FXMDIChild *arg1 = (FXMDIChild *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIChild, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onLeftBtnPress(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXMDIChild_onLeftBtnRelease(int argc, VALUE *argv, VALUE self) { FXMDIChild *arg1 = (FXMDIChild *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIChild, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onLeftBtnRelease(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXMDIChild_onMiddleBtnPress(int argc, VALUE *argv, VALUE self) { FXMDIChild *arg1 = (FXMDIChild *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIChild, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onMiddleBtnPress(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXMDIChild_onMiddleBtnRelease(int argc, VALUE *argv, VALUE self) { FXMDIChild *arg1 = (FXMDIChild *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIChild, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onMiddleBtnRelease(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXMDIChild_onMotion(int argc, VALUE *argv, VALUE self) { FXMDIChild *arg1 = (FXMDIChild *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIChild, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onMotion(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXMDIChild_onSelected(int argc, VALUE *argv, VALUE self) { FXMDIChild *arg1 = (FXMDIChild *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIChild, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]);
    SWIG_ConvertPtr(argv[2], (void **) &arg4, 0, 1); result = (long)(arg1)->onSelected(arg2,arg3,arg4);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXMDIChild_onDeselected(int argc, VALUE *argv, VALUE self) { FXMDIChild *arg1 = (FXMDIChild *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIChild, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]);
    SWIG_ConvertPtr(argv[2], (void **) &arg4, 0, 1); result = (long)(arg1)->onDeselected(arg2,arg3,arg4);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXMDIChild_onCmdClose(int argc, VALUE *argv, VALUE self) { FXMDIChild *arg1 = (FXMDIChild *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIChild, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdClose(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXMDIChild_onUpdClose(int argc, VALUE *argv, VALUE self) { FXMDIChild *arg1 = (FXMDIChild *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIChild, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onUpdClose(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXMDIChild_onCmdRestore(int argc, VALUE *argv, VALUE self) { FXMDIChild *arg1 = (FXMDIChild *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIChild, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdRestore(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXMDIChild_onUpdRestore(int argc, VALUE *argv, VALUE self) { FXMDIChild *arg1 = (FXMDIChild *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIChild, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onUpdRestore(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXMDIChild_onUpdMaximize(int argc, VALUE *argv, VALUE self) { FXMDIChild *arg1 = (FXMDIChild *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIChild, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onUpdMaximize(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXMDIChild_onUpdMinimize(int argc, VALUE *argv, VALUE self) { FXMDIChild *arg1 = (FXMDIChild *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIChild, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onUpdMinimize(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXMDIChild_onCmdMaximize(int argc, VALUE *argv, VALUE self) { FXMDIChild *arg1 = (FXMDIChild *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIChild, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdMaximize(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXMDIChild_onCmdMinimize(int argc, VALUE *argv, VALUE self) { FXMDIChild *arg1 = (FXMDIChild *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIChild, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdMinimize(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXMDIChild_onUpdWindow(int argc, VALUE *argv, VALUE self) { FXMDIChild *arg1 = (FXMDIChild *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIChild, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onUpdWindow(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXMDIChild_onUpdMenuRestore(int argc, VALUE *argv, VALUE self) { FXMDIChild *arg1 = (FXMDIChild *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIChild, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onUpdMenuRestore(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXMDIChild_onUpdMenuMinimize(int argc, VALUE *argv, VALUE self) { FXMDIChild *arg1 = (FXMDIChild *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIChild, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onUpdMenuMinimize(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXMDIChild_onUpdMenuClose(int argc, VALUE *argv, VALUE self) { FXMDIChild *arg1 = (FXMDIChild *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIChild, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onUpdMenuClose(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXMDIChild_onUpdMenuWindow(int argc, VALUE *argv, VALUE self) { FXMDIChild *arg1 = (FXMDIChild *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIChild, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onUpdMenuWindow(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXMDIChild_onCmdSetStringValue(int argc, VALUE *argv, VALUE self) { FXMDIChild *arg1 = (FXMDIChild *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; FXString value4 ;
    VALUE vresult = Qnil; if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIChild, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); {
        value4 = FXString(STR2CSTR(argv[2])); arg4 = (void *) &value4; } 
    result = (long)(arg1)->onCmdSetStringValue(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXMDIChild_onCmdGetStringValue(int argc, VALUE *argv, VALUE self) { FXMDIChild *arg1 = (FXMDIChild *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; FXString value4 ;
    VALUE vresult = Qnil; if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIChild, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); {
        value4 = FXString(STR2CSTR(argv[2])); arg4 = (void *) &value4; } 
    result = (long)(arg1)->onCmdGetStringValue(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXMDIChild_onCmdSetIconValue(int argc, VALUE *argv, VALUE self) { FXMDIChild *arg1 = (FXMDIChild *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; FXString value4 ;
    VALUE vresult = Qnil; if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIChild, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); {
        value4 = FXString(STR2CSTR(argv[2])); arg4 = (void *) &value4; } 
    result = (long)(arg1)->onCmdSetIconValue(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXMDIChild_onCmdGetIconValue(int argc, VALUE *argv, VALUE self) { FXMDIChild *arg1 = (FXMDIChild *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; FXString value4 ;
    VALUE vresult = Qnil; if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIChild, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); {
        value4 = FXString(STR2CSTR(argv[2])); arg4 = (void *) &value4; } 
    result = (long)(arg1)->onCmdGetIconValue(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE _wrap_FXMDIChild_allocate(VALUE self) {
#else
     static VALUE _wrap_FXMDIChild_allocate(int argc, VALUE *argv, VALUE self) {
#endif
         VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_FXMDIChild);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
         return vresult; }
static VALUE _wrap_new_FXMDIChild(int argc, VALUE *argv, VALUE self) { FXMDIClient *arg1 = (FXMDIClient *) 0 ;
    FXString *arg2 = 0 ; FXIcon *arg3 = (FXIcon *) 0 ; FXPopup *arg4 = (FXPopup *) 0 ; FXuint arg5 = (FXuint) 0 ;
    FXint arg6 = (FXint) 0 ; FXint arg7 = (FXint) 0 ; FXint arg8 = (FXint) 0 ; FXint arg9 = (FXint) 0 ; FXMDIChild *result;
    SwigValueWrapper<FXString > p2 ; if ((argc < 2) || (argc > 9))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXMDIClient, 1); p2 = to_FXString(argv[1]); arg2 = &p2; if (argc > 2) {
        SWIG_ConvertPtr(argv[2], (void **) &arg3, SWIGTYPE_p_FXIcon, 1); }  if (argc > 3) {
        SWIG_ConvertPtr(argv[3], (void **) &arg4, SWIGTYPE_p_FXPopup, 1); }  if (argc > 4) { arg5 = NUM2UINT(argv[4]); } 
    if (argc > 5) { arg6 = NUM2INT(argv[5]); }  if (argc > 6) { arg7 = NUM2INT(argv[6]); }  if (argc > 7) {
        arg8 = NUM2INT(argv[7]); }  if (argc > 8) { arg9 = NUM2INT(argv[8]); }  {
        result = (FXMDIChild *)new_FXMDIChild(arg1,(FXString const &)*arg2,arg3,arg4,arg5,arg6,arg7,arg8,arg9);
        DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result); if(rb_block_given_p()){ rb_yield(self); }  }  return self; }
static VALUE _wrap_FXMDIChild_setNormalX(int argc, VALUE *argv, VALUE self) { FXMDIChild *arg1 = (FXMDIChild *) 0 ; FXint arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIChild, 1); arg2 = NUM2INT(argv[0]); (arg1)->setNormalX(arg2);
    return Qnil; }
static VALUE _wrap_FXMDIChild_setNormalY(int argc, VALUE *argv, VALUE self) { FXMDIChild *arg1 = (FXMDIChild *) 0 ; FXint arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIChild, 1); arg2 = NUM2INT(argv[0]); (arg1)->setNormalY(arg2);
    return Qnil; }
static VALUE _wrap_FXMDIChild_setNormalWidth(int argc, VALUE *argv, VALUE self) { FXMDIChild *arg1 = (FXMDIChild *) 0 ;
    FXint arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIChild, 1); arg2 = NUM2INT(argv[0]); (arg1)->setNormalWidth(arg2);
    return Qnil; }
static VALUE _wrap_FXMDIChild_setNormalHeight(int argc, VALUE *argv, VALUE self) { FXMDIChild *arg1 = (FXMDIChild *) 0 ;
    FXint arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIChild, 1); arg2 = NUM2INT(argv[0]); (arg1)->setNormalHeight(arg2);
    return Qnil; }
static VALUE _wrap_FXMDIChild_getNormalX(int argc, VALUE *argv, VALUE self) { FXMDIChild *arg1 = (FXMDIChild *) 0 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIChild, 1); result = (FXint)((FXMDIChild const *)arg1)->getNormalX();
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXMDIChild_getNormalY(int argc, VALUE *argv, VALUE self) { FXMDIChild *arg1 = (FXMDIChild *) 0 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIChild, 1); result = (FXint)((FXMDIChild const *)arg1)->getNormalY();
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXMDIChild_getNormalWidth(int argc, VALUE *argv, VALUE self) { FXMDIChild *arg1 = (FXMDIChild *) 0 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIChild, 1);
    result = (FXint)((FXMDIChild const *)arg1)->getNormalWidth(); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXMDIChild_getNormalHeight(int argc, VALUE *argv, VALUE self) { FXMDIChild *arg1 = (FXMDIChild *) 0 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIChild, 1);
    result = (FXint)((FXMDIChild const *)arg1)->getNormalHeight(); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXMDIChild_setIconX(int argc, VALUE *argv, VALUE self) { FXMDIChild *arg1 = (FXMDIChild *) 0 ; FXint arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIChild, 1); arg2 = NUM2INT(argv[0]); (arg1)->setIconX(arg2);
    return Qnil; }
static VALUE _wrap_FXMDIChild_setIconY(int argc, VALUE *argv, VALUE self) { FXMDIChild *arg1 = (FXMDIChild *) 0 ; FXint arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIChild, 1); arg2 = NUM2INT(argv[0]); (arg1)->setIconY(arg2);
    return Qnil; }
static VALUE _wrap_FXMDIChild_setIconWidth(int argc, VALUE *argv, VALUE self) { FXMDIChild *arg1 = (FXMDIChild *) 0 ;
    FXint arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIChild, 1); arg2 = NUM2INT(argv[0]); (arg1)->setIconWidth(arg2);
    return Qnil; }
static VALUE _wrap_FXMDIChild_setIconHeight(int argc, VALUE *argv, VALUE self) { FXMDIChild *arg1 = (FXMDIChild *) 0 ;
    FXint arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIChild, 1); arg2 = NUM2INT(argv[0]); (arg1)->setIconHeight(arg2);
    return Qnil; }
static VALUE _wrap_FXMDIChild_getIconX(int argc, VALUE *argv, VALUE self) { FXMDIChild *arg1 = (FXMDIChild *) 0 ; FXint result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIChild, 1); result = (FXint)((FXMDIChild const *)arg1)->getIconX();
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXMDIChild_getIconY(int argc, VALUE *argv, VALUE self) { FXMDIChild *arg1 = (FXMDIChild *) 0 ; FXint result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIChild, 1); result = (FXint)((FXMDIChild const *)arg1)->getIconY();
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXMDIChild_getIconWidth(int argc, VALUE *argv, VALUE self) { FXMDIChild *arg1 = (FXMDIChild *) 0 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIChild, 1);
    result = (FXint)((FXMDIChild const *)arg1)->getIconWidth(); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXMDIChild_getIconHeight(int argc, VALUE *argv, VALUE self) { FXMDIChild *arg1 = (FXMDIChild *) 0 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIChild, 1);
    result = (FXint)((FXMDIChild const *)arg1)->getIconHeight(); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXMDIChild_contentWindow(int argc, VALUE *argv, VALUE self) { FXMDIChild *arg1 = (FXMDIChild *) 0 ;
    FXWindow *result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIChild, 1);
    result = (FXWindow *)((FXMDIChild const *)arg1)->contentWindow(); {
        swig_type_info *ty = SWIG_TypeDynamicCast(SWIGTYPE_p_FXWindow, (void **) &result);
        vresult = FXRbGetRubyObj(result, ty); }  return vresult; }
static VALUE _wrap_FXMDIChild_setTitle(int argc, VALUE *argv, VALUE self) { FXMDIChild *arg1 = (FXMDIChild *) 0 ;
    FXString *arg2 = 0 ; SwigValueWrapper<FXString > p2 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIChild, 1); p2 = to_FXString(argv[0]); arg2 = &p2;
    (arg1)->setTitle((FXString const &)*arg2); return Qnil; }
static VALUE _wrap_FXMDIChild_getTitle(int argc, VALUE *argv, VALUE self) { FXMDIChild *arg1 = (FXMDIChild *) 0 ;
    FXString result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIChild, 1); result = ((FXMDIChild const *)arg1)->getTitle();
    vresult = rb_str_new2((&result)->text()); return vresult; }
static VALUE _wrap_FXMDIChild_getHiliteColor(int argc, VALUE *argv, VALUE self) { FXMDIChild *arg1 = (FXMDIChild *) 0 ;
    FXColor result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIChild, 1);
    result = (FXColor)((FXMDIChild const *)arg1)->getHiliteColor(); vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXMDIChild_getShadowColor(int argc, VALUE *argv, VALUE self) { FXMDIChild *arg1 = (FXMDIChild *) 0 ;
    FXColor result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIChild, 1);
    result = (FXColor)((FXMDIChild const *)arg1)->getShadowColor(); vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXMDIChild_getBaseColor(int argc, VALUE *argv, VALUE self) { FXMDIChild *arg1 = (FXMDIChild *) 0 ;
    FXColor result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIChild, 1);
    result = (FXColor)((FXMDIChild const *)arg1)->getBaseColor(); vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXMDIChild_getBorderColor(int argc, VALUE *argv, VALUE self) { FXMDIChild *arg1 = (FXMDIChild *) 0 ;
    FXColor result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIChild, 1);
    result = (FXColor)((FXMDIChild const *)arg1)->getBorderColor(); vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXMDIChild_getTitleColor(int argc, VALUE *argv, VALUE self) { FXMDIChild *arg1 = (FXMDIChild *) 0 ;
    FXColor result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIChild, 1);
    result = (FXColor)((FXMDIChild const *)arg1)->getTitleColor(); vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXMDIChild_getTitleBackColor(int argc, VALUE *argv, VALUE self) { FXMDIChild *arg1 = (FXMDIChild *) 0 ;
    FXColor result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIChild, 1);
    result = (FXColor)((FXMDIChild const *)arg1)->getTitleBackColor(); vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXMDIChild_setHiliteColor(int argc, VALUE *argv, VALUE self) { FXMDIChild *arg1 = (FXMDIChild *) 0 ;
    FXColor arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIChild, 1); arg2 = to_FXColor(argv[0]); (arg1)->setHiliteColor(arg2);
    return Qnil; }
static VALUE _wrap_FXMDIChild_setShadowColor(int argc, VALUE *argv, VALUE self) { FXMDIChild *arg1 = (FXMDIChild *) 0 ;
    FXColor arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIChild, 1); arg2 = to_FXColor(argv[0]); (arg1)->setShadowColor(arg2);
    return Qnil; }
static VALUE _wrap_FXMDIChild_setBaseColor(int argc, VALUE *argv, VALUE self) { FXMDIChild *arg1 = (FXMDIChild *) 0 ;
    FXColor arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIChild, 1); arg2 = to_FXColor(argv[0]); (arg1)->setBaseColor(arg2);
    return Qnil; }
static VALUE _wrap_FXMDIChild_setBorderColor(int argc, VALUE *argv, VALUE self) { FXMDIChild *arg1 = (FXMDIChild *) 0 ;
    FXColor arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIChild, 1); arg2 = to_FXColor(argv[0]); (arg1)->setBorderColor(arg2);
    return Qnil; }
static VALUE _wrap_FXMDIChild_setTitleColor(int argc, VALUE *argv, VALUE self) { FXMDIChild *arg1 = (FXMDIChild *) 0 ;
    FXColor arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIChild, 1); arg2 = to_FXColor(argv[0]); (arg1)->setTitleColor(arg2);
    return Qnil; }
static VALUE _wrap_FXMDIChild_setTitleBackColor(int argc, VALUE *argv, VALUE self) { FXMDIChild *arg1 = (FXMDIChild *) 0 ;
    FXColor arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIChild, 1); arg2 = to_FXColor(argv[0]);
    (arg1)->setTitleBackColor(arg2); return Qnil; }
static VALUE _wrap_FXMDIChild_isMaximized(int argc, VALUE *argv, VALUE self) { FXMDIChild *arg1 = (FXMDIChild *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIChild, 1);
    result = (FXbool)((FXMDIChild const *)arg1)->isMaximized(); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXMDIChild_isMinimized(int argc, VALUE *argv, VALUE self) { FXMDIChild *arg1 = (FXMDIChild *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIChild, 1);
    result = (FXbool)((FXMDIChild const *)arg1)->isMinimized(); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXMDIChild_getIcon(int argc, VALUE *argv, VALUE self) { FXMDIChild *arg1 = (FXMDIChild *) 0 ; FXIcon *result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIChild, 1); result = (FXIcon *)((FXMDIChild const *)arg1)->getIcon();
    { swig_type_info *ty = SWIG_TypeDynamicCast(SWIGTYPE_p_FXIcon, (void **) &result); vresult = FXRbGetRubyObj(result, ty); } 
    return vresult; }
static VALUE _wrap_FXMDIChild_setIcon(int argc, VALUE *argv, VALUE self) { FXMDIChild *arg1 = (FXMDIChild *) 0 ;
    FXIcon *arg2 = (FXIcon *) 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIChild, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXIcon, 1); (arg1)->setIcon(arg2); return Qnil; }
static VALUE _wrap_FXMDIChild_getMenu(int argc, VALUE *argv, VALUE self) { FXMDIChild *arg1 = (FXMDIChild *) 0 ;
    FXPopup *result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIChild, 1); result = (FXPopup *)((FXMDIChild const *)arg1)->getMenu();
    { swig_type_info *ty = SWIG_TypeDynamicCast(SWIGTYPE_p_FXPopup, (void **) &result); vresult = FXRbGetRubyObj(result, ty); } 
    return vresult; }
static VALUE _wrap_FXMDIChild_setMenu(int argc, VALUE *argv, VALUE self) { FXMDIChild *arg1 = (FXMDIChild *) 0 ;
    FXPopup *arg2 = (FXPopup *) 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIChild, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXPopup, 1); (arg1)->setMenu(arg2); return Qnil; }
static VALUE _wrap_FXMDIChild_setTracking(int argc, VALUE *argv, VALUE self) { FXMDIChild *arg1 = (FXMDIChild *) 0 ;
    FXbool arg2 = (FXbool) 1 ; if ((argc < 0) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIChild, 1); if (argc > 0) { arg2 = to_FXbool(argv[0]); } 
    (arg1)->setTracking(arg2); return Qnil; }
static VALUE _wrap_FXMDIChild_getTracking(int argc, VALUE *argv, VALUE self) { FXMDIChild *arg1 = (FXMDIChild *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIChild, 1);
    result = (FXbool)((FXMDIChild const *)arg1)->getTracking(); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXMDIChild_setFont(int argc, VALUE *argv, VALUE self) { FXMDIChild *arg1 = (FXMDIChild *) 0 ;
    FXFont *arg2 = (FXFont *) 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIChild, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXFont, 1); (arg1)->setFont(arg2); return Qnil; }
static VALUE _wrap_FXMDIChild_getFont(int argc, VALUE *argv, VALUE self) { FXMDIChild *arg1 = (FXMDIChild *) 0 ; FXFont *result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIChild, 1); result = (FXFont *)((FXMDIChild const *)arg1)->getFont();
    { swig_type_info *ty = SWIG_TypeDynamicCast(SWIGTYPE_p_FXFont, (void **) &result); vresult = FXRbGetRubyObj(result, ty); } 
    return vresult; }
static void
free_FXMDIChild(FXMDIChild *arg1) {
    delete arg1;
}
static VALUE _wrap_FXMDIChild_save(int argc, VALUE *argv, VALUE self) { FXMDIChild *arg1 = (FXMDIChild *) 0 ;
    FXStream *arg2 = 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIChild, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXMDIChild_save((FXMDIChild const *)arg1,*arg2); return Qnil; }
static VALUE _wrap_FXMDIChild_load(int argc, VALUE *argv, VALUE self) { FXMDIChild *arg1 = (FXMDIChild *) 0 ;
    FXStream *arg2 = 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIChild, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXMDIChild_load(arg1,*arg2); return Qnil; }
static VALUE _wrap_FXMDIChild_create(int argc, VALUE *argv, VALUE self) { FXMDIChild *arg1 = (FXMDIChild *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIChild, 1); FXMDIChild_create(arg1); return Qnil; }
static VALUE _wrap_FXMDIChild_detach(int argc, VALUE *argv, VALUE self) { FXMDIChild *arg1 = (FXMDIChild *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIChild, 1); FXMDIChild_detach(arg1); return Qnil; }
static VALUE _wrap_FXMDIChild_destroy(int argc, VALUE *argv, VALUE self) { FXMDIChild *arg1 = (FXMDIChild *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIChild, 1); FXMDIChild_destroy(arg1); return Qnil; }
static VALUE _wrap_FXMDIChild_resize(int argc, VALUE *argv, VALUE self) { FXMDIChild *arg1 = (FXMDIChild *) 0 ; FXint arg2 ;
    FXint arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIChild, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    FXMDIChild_resize(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXMDIChild_getDefaultWidth(int argc, VALUE *argv, VALUE self) { FXMDIChild *arg1 = (FXMDIChild *) 0 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIChild, 1); result = (FXint)FXMDIChild_getDefaultWidth(arg1);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXMDIChild_getDefaultHeight(int argc, VALUE *argv, VALUE self) { FXMDIChild *arg1 = (FXMDIChild *) 0 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIChild, 1); result = (FXint)FXMDIChild_getDefaultHeight(arg1);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXMDIChild_getWidthForHeight(int argc, VALUE *argv, VALUE self) { FXMDIChild *arg1 = (FXMDIChild *) 0 ;
    FXint arg2 ; FXint result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIChild, 1); arg2 = NUM2INT(argv[0]);
    result = (FXint)FXMDIChild_getWidthForHeight(arg1,arg2); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXMDIChild_getHeightForWidth(int argc, VALUE *argv, VALUE self) { FXMDIChild *arg1 = (FXMDIChild *) 0 ;
    FXint arg2 ; FXint result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIChild, 1); arg2 = NUM2INT(argv[0]);
    result = (FXint)FXMDIChild_getHeightForWidth(arg1,arg2); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXMDIChild_canFocus(int argc, VALUE *argv, VALUE self) { FXMDIChild *arg1 = (FXMDIChild *) 0 ; FXbool result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIChild, 1);
    result = (FXbool)FXMDIChild_canFocus((FXMDIChild const *)arg1); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXMDIChild_setFocus(int argc, VALUE *argv, VALUE self) { FXMDIChild *arg1 = (FXMDIChild *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIChild, 1); FXMDIChild_setFocus(arg1); return Qnil; }
static VALUE _wrap_FXMDIChild_killFocus(int argc, VALUE *argv, VALUE self) { FXMDIChild *arg1 = (FXMDIChild *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIChild, 1); FXMDIChild_killFocus(arg1); return Qnil; }
static VALUE _wrap_FXMDIChild_setDefault(int argc, VALUE *argv, VALUE self) { FXMDIChild *arg1 = (FXMDIChild *) 0 ;
    FXbool arg2 = (FXbool) 1 ; if ((argc < 0) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIChild, 1); if (argc > 0) { arg2 = to_FXbool(argv[0]); } 
    FXMDIChild_setDefault(arg1,arg2); return Qnil; }
static VALUE _wrap_FXMDIChild_enable(int argc, VALUE *argv, VALUE self) { FXMDIChild *arg1 = (FXMDIChild *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIChild, 1); FXMDIChild_enable(arg1); return Qnil; }
static VALUE _wrap_FXMDIChild_disable(int argc, VALUE *argv, VALUE self) { FXMDIChild *arg1 = (FXMDIChild *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIChild, 1); FXMDIChild_disable(arg1); return Qnil; }
static VALUE _wrap_FXMDIChild_raiseWindow(int argc, VALUE *argv, VALUE self) { FXMDIChild *arg1 = (FXMDIChild *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIChild, 1); FXMDIChild_raise(arg1); return Qnil; }
static VALUE _wrap_FXMDIChild_lower(int argc, VALUE *argv, VALUE self) { FXMDIChild *arg1 = (FXMDIChild *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIChild, 1); FXMDIChild_lower(arg1); return Qnil; }
static VALUE _wrap_FXMDIChild_move(int argc, VALUE *argv, VALUE self) { FXMDIChild *arg1 = (FXMDIChild *) 0 ; FXint arg2 ;
    FXint arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIChild, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    FXMDIChild_move(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXMDIChild_position(int argc, VALUE *argv, VALUE self) { FXMDIChild *arg1 = (FXMDIChild *) 0 ; FXint arg2 ;
    FXint arg3 ; FXint arg4 ; FXint arg5 ; if ((argc < 4) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIChild, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    arg4 = NUM2INT(argv[2]); arg5 = NUM2INT(argv[3]); FXMDIChild_position(arg1,arg2,arg3,arg4,arg5); return Qnil; }
static VALUE _wrap_FXMDIChild_layout(int argc, VALUE *argv, VALUE self) { FXMDIChild *arg1 = (FXMDIChild *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIChild, 1); FXMDIChild_layout(arg1); return Qnil; }
static VALUE _wrap_FXMDIChild_recalc(int argc, VALUE *argv, VALUE self) { FXMDIChild *arg1 = (FXMDIChild *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIChild, 1); FXMDIChild_recalc(arg1); return Qnil; }
static VALUE _wrap_FXMDIChild_reparent(int argc, VALUE *argv, VALUE self) { FXMDIChild *arg1 = (FXMDIChild *) 0 ;
    FXComposite *arg2 = (FXComposite *) 0 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIChild, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXComposite, 1); FXMDIChild_reparent(arg1,arg2); return Qnil; }
static VALUE _wrap_FXMDIChild_show(int argc, VALUE *argv, VALUE self) { FXMDIChild *arg1 = (FXMDIChild *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIChild, 1); FXMDIChild_show(arg1); return Qnil; }
static VALUE _wrap_FXMDIChild_hide(int argc, VALUE *argv, VALUE self) { FXMDIChild *arg1 = (FXMDIChild *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIChild, 1); FXMDIChild_hide(arg1); return Qnil; }
static VALUE _wrap_FXMDIChild_isComposite(int argc, VALUE *argv, VALUE self) { FXMDIChild *arg1 = (FXMDIChild *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIChild, 1);
    result = (FXbool)FXMDIChild_isComposite((FXMDIChild const *)arg1); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXMDIChild_contains(int argc, VALUE *argv, VALUE self) { FXMDIChild *arg1 = (FXMDIChild *) 0 ; FXint arg2 ;
    FXint arg3 ; FXbool result; VALUE vresult = Qnil; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIChild, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    result = (FXbool)FXMDIChild_contains((FXMDIChild const *)arg1,arg2,arg3); vresult = result ? Qtrue : Qfalse;
    return vresult; }
static VALUE _wrap_FXMDIChild_doesSaveUnder(int argc, VALUE *argv, VALUE self) { FXMDIChild *arg1 = (FXMDIChild *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIChild, 1);
    result = (FXbool)FXMDIChild_doesSaveUnder((FXMDIChild const *)arg1); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXMDIChild_setBackColor(int argc, VALUE *argv, VALUE self) { FXMDIChild *arg1 = (FXMDIChild *) 0 ;
    FXColor arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIChild, 1); arg2 = to_FXColor(argv[0]);
    FXMDIChild_setBackColor(arg1,arg2); return Qnil; }
static VALUE _wrap_FXMDIChild_minimize(int argc, VALUE *argv, VALUE self) { FXMDIChild *arg1 = (FXMDIChild *) 0 ;
    FXbool arg2 = (FXbool) 0 ; FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIChild, 1); if (argc > 0) { arg2 = to_FXbool(argv[0]); } 
    result = (FXbool)FXMDIChild_minimize(arg1,arg2); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXMDIChild_maximize(int argc, VALUE *argv, VALUE self) { FXMDIChild *arg1 = (FXMDIChild *) 0 ;
    FXbool arg2 = (FXbool) 0 ; FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIChild, 1); if (argc > 0) { arg2 = to_FXbool(argv[0]); } 
    result = (FXbool)FXMDIChild_maximize(arg1,arg2); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXMDIChild_restore(int argc, VALUE *argv, VALUE self) { FXMDIChild *arg1 = (FXMDIChild *) 0 ;
    FXbool arg2 = (FXbool) 0 ; FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIChild, 1); if (argc > 0) { arg2 = to_FXbool(argv[0]); } 
    result = (FXbool)FXMDIChild_restore(arg1,arg2); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXMDIChild_close(int argc, VALUE *argv, VALUE self) { FXMDIChild *arg1 = (FXMDIChild *) 0 ;
    FXbool arg2 = (FXbool) 0 ; FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMDIChild, 1); if (argc > 0) { arg2 = to_FXbool(argv[0]); } 
    result = (FXbool)FXMDIChild_close(arg1,arg2); vresult = result ? Qtrue : Qfalse; return vresult; }

/* -------- TYPE CONVERSION AND EQUIVALENCE RULES (BEGIN) -------- */

static void *_p_FXOptionTo_p_FXFrame(void *x) {
    return (void *)((FXFrame *) (FXLabel *) ((FXOption *) x));
}
static void *_p_FXTextFieldTo_p_FXFrame(void *x) {
    return (void *)((FXFrame *)  ((FXTextField *) x));
}
static void *_p_FXMDIWindowButtonTo_p_FXFrame(void *x) {
    return (void *)((FXFrame *) (FXLabel *)(FXMenuButton *) ((FXMDIWindowButton *) x));
}
static void *_p_FXMDIMinimizeButtonTo_p_FXFrame(void *x) {
    return (void *)((FXFrame *) (FXLabel *)(FXButton *) ((FXMDIMinimizeButton *) x));
}
static void *_p_FXMDIMaximizeButtonTo_p_FXFrame(void *x) {
    return (void *)((FXFrame *) (FXLabel *)(FXButton *) ((FXMDIMaximizeButton *) x));
}
static void *_p_FXMDIRestoreButtonTo_p_FXFrame(void *x) {
    return (void *)((FXFrame *) (FXLabel *)(FXButton *) ((FXMDIRestoreButton *) x));
}
static void *_p_FXMDIDeleteButtonTo_p_FXFrame(void *x) {
    return (void *)((FXFrame *) (FXLabel *)(FXButton *) ((FXMDIDeleteButton *) x));
}
static void *_p_FXTriStateButtonTo_p_FXFrame(void *x) {
    return (void *)((FXFrame *) (FXLabel *)(FXToggleButton *) ((FXTriStateButton *) x));
}
static void *_p_FXToggleButtonTo_p_FXFrame(void *x) {
    return (void *)((FXFrame *) (FXLabel *) ((FXToggleButton *) x));
}
static void *_p_FXRadioButtonTo_p_FXFrame(void *x) {
    return (void *)((FXFrame *) (FXLabel *) ((FXRadioButton *) x));
}
static void *_p_FXMenuButtonTo_p_FXFrame(void *x) {
    return (void *)((FXFrame *) (FXLabel *) ((FXMenuButton *) x));
}
static void *_p_FXCheckButtonTo_p_FXFrame(void *x) {
    return (void *)((FXFrame *) (FXLabel *) ((FXCheckButton *) x));
}
static void *_p_FXArrowButtonTo_p_FXFrame(void *x) {
    return (void *)((FXFrame *)  ((FXArrowButton *) x));
}
static void *_p_FXRulerTo_p_FXFrame(void *x) {
    return (void *)((FXFrame *)  ((FXRuler *) x));
}
static void *_p_FXSeparatorTo_p_FXFrame(void *x) {
    return (void *)((FXFrame *)  ((FXSeparator *) x));
}
static void *_p_FXHorizontalSeparatorTo_p_FXFrame(void *x) {
    return (void *)((FXFrame *) (FXSeparator *) ((FXHorizontalSeparator *) x));
}
static void *_p_FXVerticalSeparatorTo_p_FXFrame(void *x) {
    return (void *)((FXFrame *) (FXSeparator *) ((FXVerticalSeparator *) x));
}
static void *_p_FXStatusLineTo_p_FXFrame(void *x) {
    return (void *)((FXFrame *)  ((FXStatusLine *) x));
}
static void *_p_FXTabItemTo_p_FXFrame(void *x) {
    return (void *)((FXFrame *) (FXLabel *) ((FXTabItem *) x));
}
static void *_p_FXColorWheelTo_p_FXFrame(void *x) {
    return (void *)((FXFrame *)  ((FXColorWheel *) x));
}
static void *_p_FXBitmapFrameTo_p_FXFrame(void *x) {
    return (void *)((FXFrame *)  ((FXBitmapFrame *) x));
}
static void *_p_FXImageFrameTo_p_FXFrame(void *x) {
    return (void *)((FXFrame *)  ((FXImageFrame *) x));
}
static void *_p_FXLabelTo_p_FXFrame(void *x) {
    return (void *)((FXFrame *)  ((FXLabel *) x));
}
static void *_p_FXPickerTo_p_FXFrame(void *x) {
    return (void *)((FXFrame *) (FXLabel *)(FXButton *) ((FXPicker *) x));
}
static void *_p_FXOptionMenuTo_p_FXFrame(void *x) {
    return (void *)((FXFrame *) (FXLabel *) ((FXOptionMenu *) x));
}
static void *_p_FXProgressBarTo_p_FXFrame(void *x) {
    return (void *)((FXFrame *)  ((FXProgressBar *) x));
}
static void *_p_FXHeaderTo_p_FXFrame(void *x) {
    return (void *)((FXFrame *)  ((FXHeader *) x));
}
static void *_p_FXColorWellTo_p_FXFrame(void *x) {
    return (void *)((FXFrame *)  ((FXColorWell *) x));
}
static void *_p_FXDialTo_p_FXFrame(void *x) {
    return (void *)((FXFrame *)  ((FXDial *) x));
}
static void *_p_FXToolBarTabTo_p_FXFrame(void *x) {
    return (void *)((FXFrame *)  ((FXToolBarTab *) x));
}
static void *_p_FXRealSliderTo_p_FXFrame(void *x) {
    return (void *)((FXFrame *)  ((FXRealSlider *) x));
}
static void *_p_FXSliderTo_p_FXFrame(void *x) {
    return (void *)((FXFrame *)  ((FXSlider *) x));
}
static void *_p_FXButtonTo_p_FXFrame(void *x) {
    return (void *)((FXFrame *) (FXLabel *) ((FXButton *) x));
}
static void *_p_FXColorBarTo_p_FXFrame(void *x) {
    return (void *)((FXFrame *)  ((FXColorBar *) x));
}
static void *_p_FXShutterItemTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *)(FXVerticalFrame *) ((FXShutterItem *) x));
}
static void *_p_FXColorBarTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXFrame *) ((FXColorBar *) x));
}
static void *_p_FXMenuCheckTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXMenuCaption *)(FXMenuCommand *) ((FXMenuCheck *) x));
}
static void *_p_FXMDIChildTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *) ((FXMDIChild *) x));
}
static void *_p_FXTabBarTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXTabBar *) x));
}
static void *_p_FXSwitcherTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXSwitcher *) x));
}
static void *_p_FXTextFieldTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXFrame *) ((FXTextField *) x));
}
static void *_p_FXToolBarTabTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXFrame *) ((FXToolBarTab *) x));
}
static void *_p_FXDriveBoxTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *)(FXListBox *) ((FXDriveBox *) x));
}
static void *_p_FXMDIMenuTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXShell *)(FXPopup *)(FXMenuPane *) ((FXMDIMenu *) x));
}
static void *_p_FXMatrixTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXMatrix *) x));
}
static void *_p_FXScrollCornerTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *) ((FXScrollCorner *) x));
}
static void *_p_FXArrowButtonTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXFrame *) ((FXArrowButton *) x));
}
static void *_p_FXCheckButtonTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXFrame *)(FXLabel *) ((FXCheckButton *) x));
}
static void *_p_FXMenuButtonTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXFrame *)(FXLabel *) ((FXMenuButton *) x));
}
static void *_p_FXRadioButtonTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXFrame *)(FXLabel *) ((FXRadioButton *) x));
}
static void *_p_FXToggleButtonTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXFrame *)(FXLabel *) ((FXToggleButton *) x));
}
static void *_p_FXTriStateButtonTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXFrame *)(FXLabel *)(FXToggleButton *) ((FXTriStateButton *) x));
}
static void *_p_FXMDIDeleteButtonTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXFrame *)(FXLabel *)(FXButton *) ((FXMDIDeleteButton *) x));
}
static void *_p_FXMDIRestoreButtonTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXFrame *)(FXLabel *)(FXButton *) ((FXMDIRestoreButton *) x));
}
static void *_p_FXMDIMaximizeButtonTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXFrame *)(FXLabel *)(FXButton *) ((FXMDIMaximizeButton *) x));
}
static void *_p_FXMDIMinimizeButtonTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXFrame *)(FXLabel *)(FXButton *) ((FXMDIMinimizeButton *) x));
}
static void *_p_FXMDIWindowButtonTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXFrame *)(FXLabel *)(FXMenuButton *) ((FXMDIWindowButton *) x));
}
static void *_p_FXPopupTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXShell *) ((FXPopup *) x));
}
static void *_p_FXPickerTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXFrame *)(FXLabel *)(FXButton *) ((FXPicker *) x));
}
static void *_p_FXDrawableTo_p_FXId(void *x) {
    return (void *)((FXId *)  ((FXDrawable *) x));
}
static void *_p_FXMenuPaneTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXShell *)(FXPopup *) ((FXMenuPane *) x));
}
static void *_p_FXHeaderTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXFrame *) ((FXHeader *) x));
}
static void *_p_FXSplitterTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *) ((FXSplitter *) x));
}
static void *_p_FX4SplitterTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *) ((FX4Splitter *) x));
}
static void *_p_FXSpringTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXSpring *) x));
}
static void *_p_FXPackerTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *) ((FXPacker *) x));
}
static void *_p_FXTabBookTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *)(FXTabBar *) ((FXTabBook *) x));
}
static void *_p_FXImageFrameTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXFrame *) ((FXImageFrame *) x));
}
static void *_p_FXMenuSeparatorTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *) ((FXMenuSeparator *) x));
}
static void *_p_FXVerticalSeparatorTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXFrame *)(FXSeparator *) ((FXVerticalSeparator *) x));
}
static void *_p_FXHorizontalSeparatorTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXFrame *)(FXSeparator *) ((FXHorizontalSeparator *) x));
}
static void *_p_FXSeparatorTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXFrame *) ((FXSeparator *) x));
}
static void *_p_FXProgressBarTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXFrame *) ((FXProgressBar *) x));
}
static void *_p_FXShutterTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *)(FXVerticalFrame *) ((FXShutter *) x));
}
static void *_p_FXMDIClientTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *) ((FXMDIClient *) x));
}
static void *_p_FXToolTipTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXShell *) ((FXToolTip *) x));
}
static void *_p_FXCompositeTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *) ((FXComposite *) x));
}
static void *_p_FXBitmapFrameTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXFrame *) ((FXBitmapFrame *) x));
}
static void *_p_FXRealSliderTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXFrame *) ((FXRealSlider *) x));
}
static void *_p_FXSliderTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXFrame *) ((FXSlider *) x));
}
static void *_p_FXMenuCascadeTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXMenuCaption *) ((FXMenuCascade *) x));
}
static void *_p_FXGroupBoxTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXGroupBox *) x));
}
static void *_p_FXTreeListBoxTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXTreeListBox *) x));
}
static void *_p_FXListBoxTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXListBox *) x));
}
static void *_p_FXCanvasTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *) ((FXCanvas *) x));
}
static void *_p_FXColorWheelTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXFrame *) ((FXColorWheel *) x));
}
static void *_p_FXButtonTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXFrame *)(FXLabel *) ((FXButton *) x));
}
static void *_p_FXVisualTo_p_FXId(void *x) {
    return (void *)((FXId *)  ((FXVisual *) x));
}
static void *_p_FXToolBarGripTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *) ((FXToolBarGrip *) x));
}
static void *_p_FXScrollBarTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *) ((FXScrollBar *) x));
}
static void *_p_FXFontTo_p_FXId(void *x) {
    return (void *)((FXId *)  ((FXFont *) x));
}
static void *_p_FXComboBoxTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXComboBox *) x));
}
static void *_p_FXTabItemTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXFrame *)(FXLabel *) ((FXTabItem *) x));
}
static void *_p_FXFrameTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *) ((FXFrame *) x));
}
static void *_p_FXStatusBarTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *)(FXHorizontalFrame *) ((FXStatusBar *) x));
}
static void *_p_FXGIFCursorTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXCursor *) ((FXGIFCursor *) x));
}
static void *_p_FXCURCursorTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXCursor *) ((FXCURCursor *) x));
}
static void *_p_FXCursorTo_p_FXId(void *x) {
    return (void *)((FXId *)  ((FXCursor *) x));
}
static void *_p_FXMenuCommandTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXMenuCaption *) ((FXMenuCommand *) x));
}
static void *_p_FXRealSpinnerTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXRealSpinner *) x));
}
static void *_p_FXSpinnerTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXSpinner *) x));
}
static void *_p_FXMenuCaptionTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *) ((FXMenuCaption *) x));
}
static void *_p_FXMenuTitleTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXMenuCaption *) ((FXMenuTitle *) x));
}
static void *_p_FXStatusLineTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXFrame *) ((FXStatusLine *) x));
}
static void *_p_FXMainWindowTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXShell *)(FXTopWindow *) ((FXMainWindow *) x));
}
static void *_p_FXTopWindowTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXShell *) ((FXTopWindow *) x));
}
static void *_p_FXRootWindowTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *) ((FXRootWindow *) x));
}
static void *_p_FXWindowTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *) ((FXWindow *) x));
}
static void *_p_FXScrollWindowTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXScrollArea *) ((FXScrollWindow *) x));
}
static void *_p_FXMenuBarTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *)(FXToolBar *) ((FXMenuBar *) x));
}
static void *_p_FXMenuRadioTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXMenuCaption *)(FXMenuCommand *) ((FXMenuRadio *) x));
}
static void *_p_FXLabelTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXFrame *) ((FXLabel *) x));
}
static void *_p_FXShellTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *) ((FXShell *) x));
}
static void *_p_FXOptionTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXFrame *)(FXLabel *) ((FXOption *) x));
}
static void *_p_FXOptionMenuTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXFrame *)(FXLabel *) ((FXOptionMenu *) x));
}
static void *_p_FXScrollAreaTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *) ((FXScrollArea *) x));
}
static void *_p_FXColorWellTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXFrame *) ((FXColorWell *) x));
}
static void *_p_FXDragCornerTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *) ((FXDragCorner *) x));
}
static void *_p_FXRulerTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXFrame *) ((FXRuler *) x));
}
static void *_p_FXDialTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXFrame *) ((FXDial *) x));
}
static void *_p_FXHorizontalFrameTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXHorizontalFrame *) x));
}
static void *_p_FXVerticalFrameTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXVerticalFrame *) x));
}
static void *_p_FXImageViewTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXScrollArea *) ((FXImageView *) x));
}
static void *_p_FXFontSelectorTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXFontSelector *) x));
}
static void *_p_FXColorSelectorTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXColorSelector *) x));
}
static void *_p_FXFileSelectorTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXFileSelector *) x));
}
static void *_p_FXDirSelectorTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXDirSelector *) x));
}
static void *_p_FXToolBarShellTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXShell *)(FXTopWindow *) ((FXToolBarShell *) x));
}
static void *_p_FXToolBarTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXToolBar *) x));
}
static void *_p_FXScrollPaneTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXShell *)(FXPopup *)(FXMenuPane *) ((FXScrollPane *) x));
}
static void *_p_FXDirBoxTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *)(FXTreeListBox *) ((FXDirBox *) x));
}
static void *_p_FXDocumentTo_p_FXObject(void *x) {
    return (void *)((FXObject *)  ((FXDocument *) x));
}
static void *_p_FXRegistryTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXDict *)(FXSettings *) ((FXRegistry *) x));
}
static void *_p_FXHeaderItemTo_p_FXObject(void *x) {
    return (void *)((FXObject *)  ((FXHeaderItem *) x));
}
static void *_p_FXShutterItemTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *)(FXVerticalFrame *) ((FXShutterItem *) x));
}
static void *_p_FXColorBarTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXFrame *) ((FXColorBar *) x));
}
static void *_p_FXMenuCheckTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXMenuCaption *)(FXMenuCommand *) ((FXMenuCheck *) x));
}
static void *_p_FXMDIChildTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *) ((FXMDIChild *) x));
}
static void *_p_FXTabBarTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXTabBar *) x));
}
static void *_p_FXSwitcherTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXSwitcher *) x));
}
static void *_p_FXTextFieldTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXFrame *) ((FXTextField *) x));
}
static void *_p_FXToolBarTabTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXFrame *) ((FXToolBarTab *) x));
}
static void *_p_FXDriveBoxTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *)(FXListBox *) ((FXDriveBox *) x));
}
static void *_p_FXIconDictTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXDict *) ((FXIconDict *) x));
}
static void *_p_FXMDIMenuTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXShell *)(FXPopup *)(FXMenuPane *) ((FXMDIMenu *) x));
}
static void *_p_FXMatrixTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXMatrix *) x));
}
static void *_p_FXFileDictTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXDict *) ((FXFileDict *) x));
}
static void *_p_FXRecentFilesTo_p_FXObject(void *x) {
    return (void *)((FXObject *)  ((FXRecentFiles *) x));
}
static void *_p_FXScrollCornerTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *) ((FXScrollCorner *) x));
}
static void *_p_FXArrowButtonTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXFrame *) ((FXArrowButton *) x));
}
static void *_p_FXCheckButtonTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXFrame *)(FXLabel *) ((FXCheckButton *) x));
}
static void *_p_FXMenuButtonTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXFrame *)(FXLabel *) ((FXMenuButton *) x));
}
static void *_p_FXRadioButtonTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXFrame *)(FXLabel *) ((FXRadioButton *) x));
}
static void *_p_FXToggleButtonTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXFrame *)(FXLabel *) ((FXToggleButton *) x));
}
static void *_p_FXTriStateButtonTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXFrame *)(FXLabel *)(FXToggleButton *) ((FXTriStateButton *) x));
}
static void *_p_FXMDIDeleteButtonTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXFrame *)(FXLabel *)(FXButton *) ((FXMDIDeleteButton *) x));
}
static void *_p_FXMDIRestoreButtonTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXFrame *)(FXLabel *)(FXButton *) ((FXMDIRestoreButton *) x));
}
static void *_p_FXMDIMaximizeButtonTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXFrame *)(FXLabel *)(FXButton *) ((FXMDIMaximizeButton *) x));
}
static void *_p_FXMDIMinimizeButtonTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXFrame *)(FXLabel *)(FXButton *) ((FXMDIMinimizeButton *) x));
}
static void *_p_FXMDIWindowButtonTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXFrame *)(FXLabel *)(FXMenuButton *) ((FXMDIWindowButton *) x));
}
static void *_p_FXPopupTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXShell *) ((FXPopup *) x));
}
static void *_p_FXPickerTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXFrame *)(FXLabel *)(FXButton *) ((FXPicker *) x));
}
static void *_p_FXDrawableTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *) ((FXDrawable *) x));
}
static void *_p_FXMenuPaneTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXShell *)(FXPopup *) ((FXMenuPane *) x));
}
static void *_p_FXAppTo_p_FXObject(void *x) {
    return (void *)((FXObject *)  ((FXApp *) x));
}
static void *_p_FXHeaderTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXFrame *) ((FXHeader *) x));
}
static void *_p_FX4SplitterTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *) ((FX4Splitter *) x));
}
static void *_p_FXSplitterTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *) ((FXSplitter *) x));
}
static void *_p_FXSpringTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXSpring *) x));
}
static void *_p_FXPackerTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *) ((FXPacker *) x));
}
static void *_p_FXTabBookTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *)(FXTabBar *) ((FXTabBook *) x));
}
static void *_p_FXImageFrameTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXFrame *) ((FXImageFrame *) x));
}
static void *_p_FXVerticalSeparatorTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXFrame *)(FXSeparator *) ((FXVerticalSeparator *) x));
}
static void *_p_FXHorizontalSeparatorTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXFrame *)(FXSeparator *) ((FXHorizontalSeparator *) x));
}
static void *_p_FXSeparatorTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXFrame *) ((FXSeparator *) x));
}
static void *_p_FXMenuSeparatorTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *) ((FXMenuSeparator *) x));
}
static void *_p_FXIdTo_p_FXObject(void *x) {
    return (void *)((FXObject *)  ((FXId *) x));
}
static void *_p_FXProgressBarTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXFrame *) ((FXProgressBar *) x));
}
static void *_p_FXShutterTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *)(FXVerticalFrame *) ((FXShutter *) x));
}
static void *_p_FXMDIClientTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *) ((FXMDIClient *) x));
}
static void *_p_FXToolTipTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXShell *) ((FXToolTip *) x));
}
static void *_p_FXCompositeTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *) ((FXComposite *) x));
}
static void *_p_FXBitmapFrameTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXFrame *) ((FXBitmapFrame *) x));
}
static void *_p_FXRealSliderTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXFrame *) ((FXRealSlider *) x));
}
static void *_p_FXSliderTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXFrame *) ((FXSlider *) x));
}
static void *_p_FXSettingsTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXDict *) ((FXSettings *) x));
}
static void *_p_FXGroupBoxTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXGroupBox *) x));
}
static void *_p_FXMenuCascadeTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXMenuCaption *) ((FXMenuCascade *) x));
}
static void *_p_FXDebugTargetTo_p_FXObject(void *x) {
    return (void *)((FXObject *)  ((FXDebugTarget *) x));
}
static void *_p_FXDataTargetTo_p_FXObject(void *x) {
    return (void *)((FXObject *)  ((FXDataTarget *) x));
}
static void *_p_FXTreeListBoxTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXTreeListBox *) x));
}
static void *_p_FXListBoxTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXListBox *) x));
}
static void *_p_FXCanvasTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *) ((FXCanvas *) x));
}
static void *_p_FXColorWheelTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXFrame *) ((FXColorWheel *) x));
}
static void *_p_FXButtonTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXFrame *)(FXLabel *) ((FXButton *) x));
}
static void *_p_FXVisualTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *) ((FXVisual *) x));
}
static void *_p_FXScrollBarTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *) ((FXScrollBar *) x));
}
static void *_p_FXToolBarGripTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *) ((FXToolBarGrip *) x));
}
static void *_p_FXFontTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *) ((FXFont *) x));
}
static void *_p_FXComboBoxTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXComboBox *) x));
}
static void *_p_FXTabItemTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXFrame *)(FXLabel *) ((FXTabItem *) x));
}
static void *_p_FXFrameTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *) ((FXFrame *) x));
}
static void *_p_FXStringDictTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXDict *) ((FXStringDict *) x));
}
static void *_p_FXStatusBarTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *)(FXHorizontalFrame *) ((FXStatusBar *) x));
}
static void *_p_FXDelegatorTo_p_FXObject(void *x) {
    return (void *)((FXObject *)  ((FXDelegator *) x));
}
static void *_p_FXAccelTableTo_p_FXObject(void *x) {
    return (void *)((FXObject *)  ((FXAccelTable *) x));
}
static void *_p_FXCursorTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *) ((FXCursor *) x));
}
static void *_p_FXCURCursorTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXCursor *) ((FXCURCursor *) x));
}
static void *_p_FXGIFCursorTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXCursor *) ((FXGIFCursor *) x));
}
static void *_p_FXMenuCommandTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXMenuCaption *) ((FXMenuCommand *) x));
}
static void *_p_FXRealSpinnerTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXRealSpinner *) x));
}
static void *_p_FXSpinnerTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXSpinner *) x));
}
static void *_p_FXStatusLineTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXFrame *) ((FXStatusLine *) x));
}
static void *_p_FXScrollWindowTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXScrollArea *) ((FXScrollWindow *) x));
}
static void *_p_FXWindowTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *) ((FXWindow *) x));
}
static void *_p_FXRootWindowTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *) ((FXRootWindow *) x));
}
static void *_p_FXTopWindowTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXShell *) ((FXTopWindow *) x));
}
static void *_p_FXMainWindowTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXShell *)(FXTopWindow *) ((FXMainWindow *) x));
}
static void *_p_FXMenuCaptionTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *) ((FXMenuCaption *) x));
}
static void *_p_FXMenuTitleTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXMenuCaption *) ((FXMenuTitle *) x));
}
static void *_p_FXMenuBarTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *)(FXToolBar *) ((FXMenuBar *) x));
}
static void *_p_FXMenuRadioTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXMenuCaption *)(FXMenuCommand *) ((FXMenuRadio *) x));
}
static void *_p_FXLabelTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXFrame *) ((FXLabel *) x));
}
static void *_p_FXDictTo_p_FXObject(void *x) {
    return (void *)((FXObject *)  ((FXDict *) x));
}
static void *_p_FXShellTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *) ((FXShell *) x));
}
static void *_p_FXOptionTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXFrame *)(FXLabel *) ((FXOption *) x));
}
static void *_p_FXOptionMenuTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXFrame *)(FXLabel *) ((FXOptionMenu *) x));
}
static void *_p_FXScrollAreaTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *) ((FXScrollArea *) x));
}
static void *_p_FXColorWellTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXFrame *) ((FXColorWell *) x));
}
static void *_p_FXDragCornerTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *) ((FXDragCorner *) x));
}
static void *_p_FXRulerTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXFrame *) ((FXRuler *) x));
}
static void *_p_FXDialTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXFrame *) ((FXDial *) x));
}
static void *_p_FXHorizontalFrameTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXHorizontalFrame *) x));
}
static void *_p_FXVerticalFrameTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXVerticalFrame *) x));
}
static void *_p_FXImageViewTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXScrollArea *) ((FXImageView *) x));
}
static void *_p_FXDirSelectorTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXDirSelector *) x));
}
static void *_p_FXFileSelectorTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXFileSelector *) x));
}
static void *_p_FXColorSelectorTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXColorSelector *) x));
}
static void *_p_FXFontSelectorTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXFontSelector *) x));
}
static void *_p_FXToolBarTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXToolBar *) x));
}
static void *_p_FXToolBarShellTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXShell *)(FXTopWindow *) ((FXToolBarShell *) x));
}
static void *_p_FXDirBoxTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *)(FXTreeListBox *) ((FXDirBox *) x));
}
static void *_p_FXScrollPaneTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXShell *)(FXPopup *)(FXMenuPane *) ((FXScrollPane *) x));
}
static void *_p_FXMenuPaneTo_p_FXPopup(void *x) {
    return (void *)((FXPopup *)  ((FXMenuPane *) x));
}
static void *_p_FXMDIMenuTo_p_FXPopup(void *x) {
    return (void *)((FXPopup *) (FXMenuPane *) ((FXMDIMenu *) x));
}
static void *_p_FXScrollPaneTo_p_FXPopup(void *x) {
    return (void *)((FXPopup *) (FXMenuPane *) ((FXScrollPane *) x));
}
static void *_p_FXMDIWindowButtonTo_p_FXMenuButton(void *x) {
    return (void *)((FXMenuButton *)  ((FXMDIWindowButton *) x));
}
static void *_p_FXShutterItemTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXPacker *)(FXVerticalFrame *) ((FXShutterItem *) x));
}
static void *_p_FXColorBarTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXFrame *) ((FXColorBar *) x));
}
static void *_p_FXMenuCheckTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXMenuCaption *)(FXMenuCommand *) ((FXMenuCheck *) x));
}
static void *_p_FXMDIChildTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *) ((FXMDIChild *) x));
}
static void *_p_FXTabBarTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXPacker *) ((FXTabBar *) x));
}
static void *_p_FXSwitcherTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXPacker *) ((FXSwitcher *) x));
}
static void *_p_FXTextFieldTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXFrame *) ((FXTextField *) x));
}
static void *_p_FXToolBarTabTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXFrame *) ((FXToolBarTab *) x));
}
static void *_p_FXDriveBoxTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXPacker *)(FXListBox *) ((FXDriveBox *) x));
}
static void *_p_FXMDIMenuTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXShell *)(FXPopup *)(FXMenuPane *) ((FXMDIMenu *) x));
}
static void *_p_FXMatrixTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXPacker *) ((FXMatrix *) x));
}
static void *_p_FXScrollCornerTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *)  ((FXScrollCorner *) x));
}
static void *_p_FXCheckButtonTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXFrame *)(FXLabel *) ((FXCheckButton *) x));
}
static void *_p_FXArrowButtonTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXFrame *) ((FXArrowButton *) x));
}
static void *_p_FXMenuButtonTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXFrame *)(FXLabel *) ((FXMenuButton *) x));
}
static void *_p_FXRadioButtonTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXFrame *)(FXLabel *) ((FXRadioButton *) x));
}
static void *_p_FXToggleButtonTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXFrame *)(FXLabel *) ((FXToggleButton *) x));
}
static void *_p_FXTriStateButtonTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXFrame *)(FXLabel *)(FXToggleButton *) ((FXTriStateButton *) x));
}
static void *_p_FXMDIDeleteButtonTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXFrame *)(FXLabel *)(FXButton *) ((FXMDIDeleteButton *) x));
}
static void *_p_FXMDIRestoreButtonTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXFrame *)(FXLabel *)(FXButton *) ((FXMDIRestoreButton *) x));
}
static void *_p_FXMDIMaximizeButtonTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXFrame *)(FXLabel *)(FXButton *) ((FXMDIMaximizeButton *) x));
}
static void *_p_FXMDIMinimizeButtonTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXFrame *)(FXLabel *)(FXButton *) ((FXMDIMinimizeButton *) x));
}
static void *_p_FXMDIWindowButtonTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXFrame *)(FXLabel *)(FXMenuButton *) ((FXMDIWindowButton *) x));
}
static void *_p_FXPopupTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXShell *) ((FXPopup *) x));
}
static void *_p_FXPickerTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXFrame *)(FXLabel *)(FXButton *) ((FXPicker *) x));
}
static void *_p_FXMenuPaneTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXShell *)(FXPopup *) ((FXMenuPane *) x));
}
static void *_p_FXHeaderTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXFrame *) ((FXHeader *) x));
}
static void *_p_FXSplitterTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *) ((FXSplitter *) x));
}
static void *_p_FX4SplitterTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *) ((FX4Splitter *) x));
}
static void *_p_FXSpringTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXPacker *) ((FXSpring *) x));
}
static void *_p_FXPackerTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *) ((FXPacker *) x));
}
static void *_p_FXTabBookTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXPacker *)(FXTabBar *) ((FXTabBook *) x));
}
static void *_p_FXImageFrameTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXFrame *) ((FXImageFrame *) x));
}
static void *_p_FXMenuSeparatorTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *)  ((FXMenuSeparator *) x));
}
static void *_p_FXSeparatorTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXFrame *) ((FXSeparator *) x));
}
static void *_p_FXHorizontalSeparatorTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXFrame *)(FXSeparator *) ((FXHorizontalSeparator *) x));
}
static void *_p_FXVerticalSeparatorTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXFrame *)(FXSeparator *) ((FXVerticalSeparator *) x));
}
static void *_p_FXProgressBarTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXFrame *) ((FXProgressBar *) x));
}
static void *_p_FXShutterTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXPacker *)(FXVerticalFrame *) ((FXShutter *) x));
}
static void *_p_FXMDIClientTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *) ((FXMDIClient *) x));
}
static void *_p_FXToolTipTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXShell *) ((FXToolTip *) x));
}
static void *_p_FXCompositeTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *)  ((FXComposite *) x));
}
static void *_p_FXBitmapFrameTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXFrame *) ((FXBitmapFrame *) x));
}
static void *_p_FXRealSliderTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXFrame *) ((FXRealSlider *) x));
}
static void *_p_FXSliderTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXFrame *) ((FXSlider *) x));
}
static void *_p_FXMenuCascadeTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXMenuCaption *) ((FXMenuCascade *) x));
}
static void *_p_FXGroupBoxTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXPacker *) ((FXGroupBox *) x));
}
static void *_p_FXTreeListBoxTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXPacker *) ((FXTreeListBox *) x));
}
static void *_p_FXListBoxTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXPacker *) ((FXListBox *) x));
}
static void *_p_FXCanvasTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *)  ((FXCanvas *) x));
}
static void *_p_FXColorWheelTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXFrame *) ((FXColorWheel *) x));
}
static void *_p_FXButtonTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXFrame *)(FXLabel *) ((FXButton *) x));
}
static void *_p_FXToolBarGripTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *)  ((FXToolBarGrip *) x));
}
static void *_p_FXScrollBarTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *)  ((FXScrollBar *) x));
}
static void *_p_FXComboBoxTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXPacker *) ((FXComboBox *) x));
}
static void *_p_FXTabItemTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXFrame *)(FXLabel *) ((FXTabItem *) x));
}
static void *_p_FXFrameTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *)  ((FXFrame *) x));
}
static void *_p_FXStatusBarTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXPacker *)(FXHorizontalFrame *) ((FXStatusBar *) x));
}
static void *_p_FXMenuCommandTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXMenuCaption *) ((FXMenuCommand *) x));
}
static void *_p_FXRealSpinnerTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXPacker *) ((FXRealSpinner *) x));
}
static void *_p_FXSpinnerTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXPacker *) ((FXSpinner *) x));
}
static void *_p_FXMenuCaptionTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *)  ((FXMenuCaption *) x));
}
static void *_p_FXMenuTitleTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXMenuCaption *) ((FXMenuTitle *) x));
}
static void *_p_FXStatusLineTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXFrame *) ((FXStatusLine *) x));
}
static void *_p_FXMainWindowTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXShell *)(FXTopWindow *) ((FXMainWindow *) x));
}
static void *_p_FXTopWindowTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXShell *) ((FXTopWindow *) x));
}
static void *_p_FXRootWindowTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *) ((FXRootWindow *) x));
}
static void *_p_FXScrollWindowTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXScrollArea *) ((FXScrollWindow *) x));
}
static void *_p_FXMenuBarTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXPacker *)(FXToolBar *) ((FXMenuBar *) x));
}
static void *_p_FXMenuRadioTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXMenuCaption *)(FXMenuCommand *) ((FXMenuRadio *) x));
}
static void *_p_FXLabelTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXFrame *) ((FXLabel *) x));
}
static void *_p_FXShellTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *) ((FXShell *) x));
}
static void *_p_FXOptionTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXFrame *)(FXLabel *) ((FXOption *) x));
}
static void *_p_FXOptionMenuTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXFrame *)(FXLabel *) ((FXOptionMenu *) x));
}
static void *_p_FXScrollAreaTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *) ((FXScrollArea *) x));
}
static void *_p_FXColorWellTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXFrame *) ((FXColorWell *) x));
}
static void *_p_FXDragCornerTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *)  ((FXDragCorner *) x));
}
static void *_p_FXRulerTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXFrame *) ((FXRuler *) x));
}
static void *_p_FXDialTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXFrame *) ((FXDial *) x));
}
static void *_p_FXVerticalFrameTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXPacker *) ((FXVerticalFrame *) x));
}
static void *_p_FXHorizontalFrameTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXPacker *) ((FXHorizontalFrame *) x));
}
static void *_p_FXImageViewTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXScrollArea *) ((FXImageView *) x));
}
static void *_p_FXFontSelectorTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXPacker *) ((FXFontSelector *) x));
}
static void *_p_FXColorSelectorTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXPacker *) ((FXColorSelector *) x));
}
static void *_p_FXFileSelectorTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXPacker *) ((FXFileSelector *) x));
}
static void *_p_FXDirSelectorTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXPacker *) ((FXDirSelector *) x));
}
static void *_p_FXToolBarShellTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXShell *)(FXTopWindow *) ((FXToolBarShell *) x));
}
static void *_p_FXToolBarTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXPacker *) ((FXToolBar *) x));
}
static void *_p_FXScrollPaneTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXShell *)(FXPopup *)(FXMenuPane *) ((FXScrollPane *) x));
}
static void *_p_FXDirBoxTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXPacker *)(FXTreeListBox *) ((FXDirBox *) x));
}
static void *_p_FXPickerTo_p_FXLabel(void *x) {
    return (void *)((FXLabel *) (FXButton *) ((FXPicker *) x));
}
static void *_p_FXMDIMinimizeButtonTo_p_FXLabel(void *x) {
    return (void *)((FXLabel *) (FXButton *) ((FXMDIMinimizeButton *) x));
}
static void *_p_FXMDIMaximizeButtonTo_p_FXLabel(void *x) {
    return (void *)((FXLabel *) (FXButton *) ((FXMDIMaximizeButton *) x));
}
static void *_p_FXMDIRestoreButtonTo_p_FXLabel(void *x) {
    return (void *)((FXLabel *) (FXButton *) ((FXMDIRestoreButton *) x));
}
static void *_p_FXMDIDeleteButtonTo_p_FXLabel(void *x) {
    return (void *)((FXLabel *) (FXButton *) ((FXMDIDeleteButton *) x));
}
static void *_p_FXTriStateButtonTo_p_FXLabel(void *x) {
    return (void *)((FXLabel *) (FXToggleButton *) ((FXTriStateButton *) x));
}
static void *_p_FXToggleButtonTo_p_FXLabel(void *x) {
    return (void *)((FXLabel *)  ((FXToggleButton *) x));
}
static void *_p_FXRadioButtonTo_p_FXLabel(void *x) {
    return (void *)((FXLabel *)  ((FXRadioButton *) x));
}
static void *_p_FXMenuButtonTo_p_FXLabel(void *x) {
    return (void *)((FXLabel *)  ((FXMenuButton *) x));
}
static void *_p_FXCheckButtonTo_p_FXLabel(void *x) {
    return (void *)((FXLabel *)  ((FXCheckButton *) x));
}
static void *_p_FXMDIWindowButtonTo_p_FXLabel(void *x) {
    return (void *)((FXLabel *) (FXMenuButton *) ((FXMDIWindowButton *) x));
}
static void *_p_FXButtonTo_p_FXLabel(void *x) {
    return (void *)((FXLabel *)  ((FXButton *) x));
}
static void *_p_FXTabItemTo_p_FXLabel(void *x) {
    return (void *)((FXLabel *)  ((FXTabItem *) x));
}
static void *_p_FXOptionTo_p_FXLabel(void *x) {
    return (void *)((FXLabel *)  ((FXOption *) x));
}
static void *_p_FXOptionMenuTo_p_FXLabel(void *x) {
    return (void *)((FXLabel *)  ((FXOptionMenu *) x));
}
static void *_p_FXDriveBoxTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXPacker *)(FXListBox *) ((FXDriveBox *) x));
}
static void *_p_FXMDIClientTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *)  ((FXMDIClient *) x));
}
static void *_p_FXMenuPaneTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXShell *)(FXPopup *) ((FXMenuPane *) x));
}
static void *_p_FXToolBarTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXPacker *) ((FXToolBar *) x));
}
static void *_p_FXMenuBarTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXPacker *)(FXToolBar *) ((FXMenuBar *) x));
}
static void *_p_FXToolTipTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXShell *) ((FXToolTip *) x));
}
static void *_p_FXTabBookTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXPacker *)(FXTabBar *) ((FXTabBook *) x));
}
static void *_p_FXGroupBoxTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXPacker *) ((FXGroupBox *) x));
}
static void *_p_FXShellTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *)  ((FXShell *) x));
}
static void *_p_FXStatusBarTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXPacker *)(FXHorizontalFrame *) ((FXStatusBar *) x));
}
static void *_p_FXScrollAreaTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *)  ((FXScrollArea *) x));
}
static void *_p_FXPopupTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXShell *) ((FXPopup *) x));
}
static void *_p_FXScrollWindowTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXScrollArea *) ((FXScrollWindow *) x));
}
static void *_p_FXRootWindowTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *)  ((FXRootWindow *) x));
}
static void *_p_FXTopWindowTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXShell *) ((FXTopWindow *) x));
}
static void *_p_FXMainWindowTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXShell *)(FXTopWindow *) ((FXMainWindow *) x));
}
static void *_p_FXComboBoxTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXPacker *) ((FXComboBox *) x));
}
static void *_p_FXHorizontalFrameTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXPacker *) ((FXHorizontalFrame *) x));
}
static void *_p_FXVerticalFrameTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXPacker *) ((FXVerticalFrame *) x));
}
static void *_p_FXMDIChildTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *)  ((FXMDIChild *) x));
}
static void *_p_FX4SplitterTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *)  ((FX4Splitter *) x));
}
static void *_p_FXSplitterTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *)  ((FXSplitter *) x));
}
static void *_p_FXRealSpinnerTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXPacker *) ((FXRealSpinner *) x));
}
static void *_p_FXSpinnerTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXPacker *) ((FXSpinner *) x));
}
static void *_p_FXPackerTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *)  ((FXPacker *) x));
}
static void *_p_FXDirBoxTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXPacker *)(FXTreeListBox *) ((FXDirBox *) x));
}
static void *_p_FXSwitcherTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXPacker *) ((FXSwitcher *) x));
}
static void *_p_FXColorSelectorTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXPacker *) ((FXColorSelector *) x));
}
static void *_p_FXFileSelectorTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXPacker *) ((FXFileSelector *) x));
}
static void *_p_FXDirSelectorTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXPacker *) ((FXDirSelector *) x));
}
static void *_p_FXFontSelectorTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXPacker *) ((FXFontSelector *) x));
}
static void *_p_FXShutterTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXPacker *)(FXVerticalFrame *) ((FXShutter *) x));
}
static void *_p_FXTreeListBoxTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXPacker *) ((FXTreeListBox *) x));
}
static void *_p_FXListBoxTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXPacker *) ((FXListBox *) x));
}
static void *_p_FXMatrixTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXPacker *) ((FXMatrix *) x));
}
static void *_p_FXShutterItemTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXPacker *)(FXVerticalFrame *) ((FXShutterItem *) x));
}
static void *_p_FXTabBarTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXPacker *) ((FXTabBar *) x));
}
static void *_p_FXImageViewTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXScrollArea *) ((FXImageView *) x));
}
static void *_p_FXSpringTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXPacker *) ((FXSpring *) x));
}
static void *_p_FXScrollPaneTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXShell *)(FXPopup *)(FXMenuPane *) ((FXScrollPane *) x));
}
static void *_p_FXToolBarShellTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXShell *)(FXTopWindow *) ((FXToolBarShell *) x));
}
static void *_p_FXMDIMenuTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXShell *)(FXPopup *)(FXMenuPane *) ((FXMDIMenu *) x));
}
static void *_p_FXPopupTo_p_FXShell(void *x) {
    return (void *)((FXShell *)  ((FXPopup *) x));
}
static void *_p_FXTopWindowTo_p_FXShell(void *x) {
    return (void *)((FXShell *)  ((FXTopWindow *) x));
}
static void *_p_FXMainWindowTo_p_FXShell(void *x) {
    return (void *)((FXShell *) (FXTopWindow *) ((FXMainWindow *) x));
}
static void *_p_FXToolTipTo_p_FXShell(void *x) {
    return (void *)((FXShell *)  ((FXToolTip *) x));
}
static void *_p_FXMenuPaneTo_p_FXShell(void *x) {
    return (void *)((FXShell *) (FXPopup *) ((FXMenuPane *) x));
}
static void *_p_FXToolBarShellTo_p_FXShell(void *x) {
    return (void *)((FXShell *) (FXTopWindow *) ((FXToolBarShell *) x));
}
static void *_p_FXMDIMenuTo_p_FXShell(void *x) {
    return (void *)((FXShell *) (FXPopup *)(FXMenuPane *) ((FXMDIMenu *) x));
}
static void *_p_FXScrollPaneTo_p_FXShell(void *x) {
    return (void *)((FXShell *) (FXPopup *)(FXMenuPane *) ((FXScrollPane *) x));
}
static void *_p_FXPickerTo_p_FXButton(void *x) {
    return (void *)((FXButton *)  ((FXPicker *) x));
}
static void *_p_FXMDIDeleteButtonTo_p_FXButton(void *x) {
    return (void *)((FXButton *)  ((FXMDIDeleteButton *) x));
}
static void *_p_FXMDIRestoreButtonTo_p_FXButton(void *x) {
    return (void *)((FXButton *)  ((FXMDIRestoreButton *) x));
}
static void *_p_FXMDIMaximizeButtonTo_p_FXButton(void *x) {
    return (void *)((FXButton *)  ((FXMDIMaximizeButton *) x));
}
static void *_p_FXMDIMinimizeButtonTo_p_FXButton(void *x) {
    return (void *)((FXButton *)  ((FXMDIMinimizeButton *) x));
}
static void *_p_FXFileStreamTo_p_FXStream(void *x) {
    return (void *)((FXStream *)  ((FXFileStream *) x));
}
static void *_p_FXMemoryStreamTo_p_FXStream(void *x) {
    return (void *)((FXStream *)  ((FXMemoryStream *) x));
}
static void *_p_FXShutterItemTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *)(FXVerticalFrame *) ((FXShutterItem *) x));
}
static void *_p_FXColorBarTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXFrame *) ((FXColorBar *) x));
}
static void *_p_FXMenuCheckTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXMenuCaption *)(FXMenuCommand *) ((FXMenuCheck *) x));
}
static void *_p_FXMDIChildTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *) ((FXMDIChild *) x));
}
static void *_p_FXTabBarTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *) ((FXTabBar *) x));
}
static void *_p_FXSwitcherTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *) ((FXSwitcher *) x));
}
static void *_p_FXTextFieldTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXFrame *) ((FXTextField *) x));
}
static void *_p_FXToolBarTabTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXFrame *) ((FXToolBarTab *) x));
}
static void *_p_FXDriveBoxTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *)(FXListBox *) ((FXDriveBox *) x));
}
static void *_p_FXMDIMenuTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXShell *)(FXPopup *)(FXMenuPane *) ((FXMDIMenu *) x));
}
static void *_p_FXMatrixTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *) ((FXMatrix *) x));
}
static void *_p_FXScrollCornerTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *) ((FXScrollCorner *) x));
}
static void *_p_FXArrowButtonTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXFrame *) ((FXArrowButton *) x));
}
static void *_p_FXCheckButtonTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXFrame *)(FXLabel *) ((FXCheckButton *) x));
}
static void *_p_FXMenuButtonTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXFrame *)(FXLabel *) ((FXMenuButton *) x));
}
static void *_p_FXRadioButtonTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXFrame *)(FXLabel *) ((FXRadioButton *) x));
}
static void *_p_FXToggleButtonTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXFrame *)(FXLabel *) ((FXToggleButton *) x));
}
static void *_p_FXTriStateButtonTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXFrame *)(FXLabel *)(FXToggleButton *) ((FXTriStateButton *) x));
}
static void *_p_FXMDIDeleteButtonTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXFrame *)(FXLabel *)(FXButton *) ((FXMDIDeleteButton *) x));
}
static void *_p_FXMDIRestoreButtonTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXFrame *)(FXLabel *)(FXButton *) ((FXMDIRestoreButton *) x));
}
static void *_p_FXMDIMaximizeButtonTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXFrame *)(FXLabel *)(FXButton *) ((FXMDIMaximizeButton *) x));
}
static void *_p_FXMDIMinimizeButtonTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXFrame *)(FXLabel *)(FXButton *) ((FXMDIMinimizeButton *) x));
}
static void *_p_FXMDIWindowButtonTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXFrame *)(FXLabel *)(FXMenuButton *) ((FXMDIWindowButton *) x));
}
static void *_p_FXPopupTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXShell *) ((FXPopup *) x));
}
static void *_p_FXPickerTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXFrame *)(FXLabel *)(FXButton *) ((FXPicker *) x));
}
static void *_p_FXMenuPaneTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXShell *)(FXPopup *) ((FXMenuPane *) x));
}
static void *_p_FXHeaderTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXFrame *) ((FXHeader *) x));
}
static void *_p_FXSplitterTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *) ((FXSplitter *) x));
}
static void *_p_FX4SplitterTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *) ((FX4Splitter *) x));
}
static void *_p_FXSpringTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *) ((FXSpring *) x));
}
static void *_p_FXPackerTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *) ((FXPacker *) x));
}
static void *_p_FXTabBookTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *)(FXTabBar *) ((FXTabBook *) x));
}
static void *_p_FXImageFrameTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXFrame *) ((FXImageFrame *) x));
}
static void *_p_FXMenuSeparatorTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *) ((FXMenuSeparator *) x));
}
static void *_p_FXVerticalSeparatorTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXFrame *)(FXSeparator *) ((FXVerticalSeparator *) x));
}
static void *_p_FXSeparatorTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXFrame *) ((FXSeparator *) x));
}
static void *_p_FXHorizontalSeparatorTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXFrame *)(FXSeparator *) ((FXHorizontalSeparator *) x));
}
static void *_p_FXProgressBarTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXFrame *) ((FXProgressBar *) x));
}
static void *_p_FXShutterTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *)(FXVerticalFrame *) ((FXShutter *) x));
}
static void *_p_FXMDIClientTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *) ((FXMDIClient *) x));
}
static void *_p_FXToolTipTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXShell *) ((FXToolTip *) x));
}
static void *_p_FXCompositeTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *) ((FXComposite *) x));
}
static void *_p_FXBitmapFrameTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXFrame *) ((FXBitmapFrame *) x));
}
static void *_p_FXRealSliderTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXFrame *) ((FXRealSlider *) x));
}
static void *_p_FXSliderTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXFrame *) ((FXSlider *) x));
}
static void *_p_FXMenuCascadeTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXMenuCaption *) ((FXMenuCascade *) x));
}
static void *_p_FXGroupBoxTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *) ((FXGroupBox *) x));
}
static void *_p_FXTreeListBoxTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *) ((FXTreeListBox *) x));
}
static void *_p_FXListBoxTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *) ((FXListBox *) x));
}
static void *_p_FXCanvasTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *) ((FXCanvas *) x));
}
static void *_p_FXColorWheelTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXFrame *) ((FXColorWheel *) x));
}
static void *_p_FXButtonTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXFrame *)(FXLabel *) ((FXButton *) x));
}
static void *_p_FXToolBarGripTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *) ((FXToolBarGrip *) x));
}
static void *_p_FXScrollBarTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *) ((FXScrollBar *) x));
}
static void *_p_FXComboBoxTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *) ((FXComboBox *) x));
}
static void *_p_FXTabItemTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXFrame *)(FXLabel *) ((FXTabItem *) x));
}
static void *_p_FXFrameTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *) ((FXFrame *) x));
}
static void *_p_FXStatusBarTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *)(FXHorizontalFrame *) ((FXStatusBar *) x));
}
static void *_p_FXMenuCommandTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXMenuCaption *) ((FXMenuCommand *) x));
}
static void *_p_FXRealSpinnerTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *) ((FXRealSpinner *) x));
}
static void *_p_FXSpinnerTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *) ((FXSpinner *) x));
}
static void *_p_FXMenuCaptionTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *) ((FXMenuCaption *) x));
}
static void *_p_FXMenuTitleTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXMenuCaption *) ((FXMenuTitle *) x));
}
static void *_p_FXStatusLineTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXFrame *) ((FXStatusLine *) x));
}
static void *_p_FXMainWindowTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXShell *)(FXTopWindow *) ((FXMainWindow *) x));
}
static void *_p_FXTopWindowTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXShell *) ((FXTopWindow *) x));
}
static void *_p_FXRootWindowTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *) ((FXRootWindow *) x));
}
static void *_p_FXWindowTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *)  ((FXWindow *) x));
}
static void *_p_FXScrollWindowTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXScrollArea *) ((FXScrollWindow *) x));
}
static void *_p_FXMenuBarTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *)(FXToolBar *) ((FXMenuBar *) x));
}
static void *_p_FXMenuRadioTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXMenuCaption *)(FXMenuCommand *) ((FXMenuRadio *) x));
}
static void *_p_FXLabelTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXFrame *) ((FXLabel *) x));
}
static void *_p_FXShellTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *) ((FXShell *) x));
}
static void *_p_FXOptionTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXFrame *)(FXLabel *) ((FXOption *) x));
}
static void *_p_FXOptionMenuTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXFrame *)(FXLabel *) ((FXOptionMenu *) x));
}
static void *_p_FXScrollAreaTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *) ((FXScrollArea *) x));
}
static void *_p_FXColorWellTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXFrame *) ((FXColorWell *) x));
}
static void *_p_FXDragCornerTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *) ((FXDragCorner *) x));
}
static void *_p_FXRulerTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXFrame *) ((FXRuler *) x));
}
static void *_p_FXDialTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXFrame *) ((FXDial *) x));
}
static void *_p_FXVerticalFrameTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *) ((FXVerticalFrame *) x));
}
static void *_p_FXHorizontalFrameTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *) ((FXHorizontalFrame *) x));
}
static void *_p_FXImageViewTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXScrollArea *) ((FXImageView *) x));
}
static void *_p_FXFontSelectorTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *) ((FXFontSelector *) x));
}
static void *_p_FXColorSelectorTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *) ((FXColorSelector *) x));
}
static void *_p_FXFileSelectorTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *) ((FXFileSelector *) x));
}
static void *_p_FXDirSelectorTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *) ((FXDirSelector *) x));
}
static void *_p_FXToolBarShellTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXShell *)(FXTopWindow *) ((FXToolBarShell *) x));
}
static void *_p_FXToolBarTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *) ((FXToolBar *) x));
}
static void *_p_FXScrollPaneTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXShell *)(FXPopup *)(FXMenuPane *) ((FXScrollPane *) x));
}
static void *_p_FXDirBoxTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *)(FXTreeListBox *) ((FXDirBox *) x));
}
static void *_p_FXMDIMenuTo_p_FXMenuPane(void *x) {
    return (void *)((FXMenuPane *)  ((FXMDIMenu *) x));
}
static void *_p_FXScrollPaneTo_p_FXMenuPane(void *x) {
    return (void *)((FXMenuPane *)  ((FXScrollPane *) x));
}
static swig_type_info _swigt__p_FXFrame[] = {{"_p_FXFrame", 0, "FXFrame *", 0, 0, 0, 0},{"_p_FXOption", _p_FXOptionTo_p_FXFrame, 0, 0, 0, 0, 0},{"_p_FXDial", _p_FXDialTo_p_FXFrame, 0, 0, 0, 0, 0},{"_p_FXTextField", _p_FXTextFieldTo_p_FXFrame, 0, 0, 0, 0, 0},{"_p_FXArrowButton", _p_FXArrowButtonTo_p_FXFrame, 0, 0, 0, 0, 0},{"_p_FXMDIWindowButton", _p_FXMDIWindowButtonTo_p_FXFrame, 0, 0, 0, 0, 0},{"_p_FXMDIMinimizeButton", _p_FXMDIMinimizeButtonTo_p_FXFrame, 0, 0, 0, 0, 0},{"_p_FXMDIMaximizeButton", _p_FXMDIMaximizeButtonTo_p_FXFrame, 0, 0, 0, 0, 0},{"_p_FXMDIRestoreButton", _p_FXMDIRestoreButtonTo_p_FXFrame, 0, 0, 0, 0, 0},{"_p_FXMDIDeleteButton", _p_FXMDIDeleteButtonTo_p_FXFrame, 0, 0, 0, 0, 0},{"_p_FXTriStateButton", _p_FXTriStateButtonTo_p_FXFrame, 0, 0, 0, 0, 0},{"_p_FXToggleButton", _p_FXToggleButtonTo_p_FXFrame, 0, 0, 0, 0, 0},{"_p_FXRadioButton", _p_FXRadioButtonTo_p_FXFrame, 0, 0, 0, 0, 0},{"_p_FXMenuButton", _p_FXMenuButtonTo_p_FXFrame, 0, 0, 0, 0, 0},{"_p_FXCheckButton", _p_FXCheckButtonTo_p_FXFrame, 0, 0, 0, 0, 0},{"_p_FXRuler", _p_FXRulerTo_p_FXFrame, 0, 0, 0, 0, 0},{"_p_FXSeparator", _p_FXSeparatorTo_p_FXFrame, 0, 0, 0, 0, 0},{"_p_FXHorizontalSeparator", _p_FXHorizontalSeparatorTo_p_FXFrame, 0, 0, 0, 0, 0},{"_p_FXVerticalSeparator", _p_FXVerticalSeparatorTo_p_FXFrame, 0, 0, 0, 0, 0},{"_p_FXStatusLine", _p_FXStatusLineTo_p_FXFrame, 0, 0, 0, 0, 0},{"_p_FXTabItem", _p_FXTabItemTo_p_FXFrame, 0, 0, 0, 0, 0},{"_p_FXColorWheel", _p_FXColorWheelTo_p_FXFrame, 0, 0, 0, 0, 0},{"_p_FXBitmapFrame", _p_FXBitmapFrameTo_p_FXFrame, 0, 0, 0, 0, 0},{"_p_FXImageFrame", _p_FXImageFrameTo_p_FXFrame, 0, 0, 0, 0, 0},{"_p_FXLabel", _p_FXLabelTo_p_FXFrame, 0, 0, 0, 0, 0},{"_p_FXPicker", _p_FXPickerTo_p_FXFrame, 0, 0, 0, 0, 0},{"_p_FXOptionMenu", _p_FXOptionMenuTo_p_FXFrame, 0, 0, 0, 0, 0},{"_p_FXProgressBar", _p_FXProgressBarTo_p_FXFrame, 0, 0, 0, 0, 0},{"_p_FXHeader", _p_FXHeaderTo_p_FXFrame, 0, 0, 0, 0, 0},{"_p_FXColorWell", _p_FXColorWellTo_p_FXFrame, 0, 0, 0, 0, 0},{"_p_FXToolBarTab", _p_FXToolBarTabTo_p_FXFrame, 0, 0, 0, 0, 0},{"_p_FXFrame", 0, 0, 0, 0, 0, 0},{"_p_FXRealSlider", _p_FXRealSliderTo_p_FXFrame, 0, 0, 0, 0, 0},{"_p_FXSlider", _p_FXSliderTo_p_FXFrame, 0, 0, 0, 0, 0},{"_p_FXButton", _p_FXButtonTo_p_FXFrame, 0, 0, 0, 0, 0},{"_p_FXColorBar", _p_FXColorBarTo_p_FXFrame, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXMDIClient[] = {{"_p_FXMDIClient", 0, "FXMDIClient *", 0, 0, 0, 0},{"_p_FXMDIClient", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXObject[] = {{"_p_FXObject", 0, "FXObject *", 0, 0, 0, 0},{"_p_FXDocument", _p_FXDocumentTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXRegistry", _p_FXRegistryTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXHeaderItem", _p_FXHeaderItemTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXShutterItem", _p_FXShutterItemTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXColorBar", _p_FXColorBarTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXMenuCheck", _p_FXMenuCheckTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXMDIChild", _p_FXMDIChildTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXTabBar", _p_FXTabBarTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXSwitcher", _p_FXSwitcherTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXTextField", _p_FXTextFieldTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXToolBarTab", _p_FXToolBarTabTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXDriveBox", _p_FXDriveBoxTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXIconDict", _p_FXIconDictTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXMDIMenu", _p_FXMDIMenuTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXMatrix", _p_FXMatrixTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXFileDict", _p_FXFileDictTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXRecentFiles", _p_FXRecentFilesTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXScrollCorner", _p_FXScrollCornerTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXArrowButton", _p_FXArrowButtonTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXCheckButton", _p_FXCheckButtonTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXMenuButton", _p_FXMenuButtonTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXMDIWindowButton", _p_FXMDIWindowButtonTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXRadioButton", _p_FXRadioButtonTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXToggleButton", _p_FXToggleButtonTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXTriStateButton", _p_FXTriStateButtonTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXMDIDeleteButton", _p_FXMDIDeleteButtonTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXMDIRestoreButton", _p_FXMDIRestoreButtonTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXMDIMaximizeButton", _p_FXMDIMaximizeButtonTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXMDIMinimizeButton", _p_FXMDIMinimizeButtonTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXPicker", _p_FXPickerTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXPopup", _p_FXPopupTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXDrawable", _p_FXDrawableTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXMenuPane", _p_FXMenuPaneTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXFont", _p_FXFontTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXHeader", _p_FXHeaderTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FX4Splitter", _p_FX4SplitterTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXSplitter", _p_FXSplitterTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXSpring", _p_FXSpringTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXPacker", _p_FXPackerTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXTabBook", _p_FXTabBookTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXApp", _p_FXAppTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXImageFrame", _p_FXImageFrameTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXMenuSeparator", _p_FXMenuSeparatorTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXVerticalSeparator", _p_FXVerticalSeparatorTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXSeparator", _p_FXSeparatorTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXHorizontalSeparator", _p_FXHorizontalSeparatorTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXProgressBar", _p_FXProgressBarTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXShutter", _p_FXShutterTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXMDIClient", _p_FXMDIClientTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXToolTip", _p_FXToolTipTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXComposite", _p_FXCompositeTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXDict", _p_FXDictTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXBitmapFrame", _p_FXBitmapFrameTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXSlider", _p_FXSliderTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXRealSlider", _p_FXRealSliderTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXSettings", _p_FXSettingsTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXGroupBox", _p_FXGroupBoxTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXMenuCascade", _p_FXMenuCascadeTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXDataTarget", _p_FXDataTargetTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXDebugTarget", _p_FXDebugTargetTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXListBox", _p_FXListBoxTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXTreeListBox", _p_FXTreeListBoxTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXCanvas", _p_FXCanvasTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXId", _p_FXIdTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXColorWheel", _p_FXColorWheelTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXDial", _p_FXDialTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXButton", _p_FXButtonTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXToolBarGrip", _p_FXToolBarGripTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXScrollBar", _p_FXScrollBarTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXVisual", _p_FXVisualTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXComboBox", _p_FXComboBoxTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXTabItem", _p_FXTabItemTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXFrame", _p_FXFrameTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXStatusBar", _p_FXStatusBarTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXStringDict", _p_FXStringDictTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXDelegator", _p_FXDelegatorTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXAccelTable", _p_FXAccelTableTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXObject", 0, 0, 0, 0, 0, 0},{"_p_FXCursor", _p_FXCursorTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXCURCursor", _p_FXCURCursorTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXGIFCursor", _p_FXGIFCursorTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXMenuCommand", _p_FXMenuCommandTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXRealSpinner", _p_FXRealSpinnerTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXSpinner", _p_FXSpinnerTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXScrollWindow", _p_FXScrollWindowTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXRootWindow", _p_FXRootWindowTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXMainWindow", _p_FXMainWindowTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXTopWindow", _p_FXTopWindowTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXMenuBar", _p_FXMenuBarTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXStatusLine", _p_FXStatusLineTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXMenuCaption", _p_FXMenuCaptionTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXMenuTitle", _p_FXMenuTitleTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXWindow", _p_FXWindowTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXMenuRadio", _p_FXMenuRadioTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXLabel", _p_FXLabelTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXShell", _p_FXShellTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXOption", _p_FXOptionTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXOptionMenu", _p_FXOptionMenuTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXScrollArea", _p_FXScrollAreaTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXColorWell", _p_FXColorWellTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXDragCorner", _p_FXDragCornerTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXRuler", _p_FXRulerTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXHorizontalFrame", _p_FXHorizontalFrameTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXVerticalFrame", _p_FXVerticalFrameTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXColorSelector", _p_FXColorSelectorTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXFileSelector", _p_FXFileSelectorTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXDirSelector", _p_FXDirSelectorTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXFontSelector", _p_FXFontSelectorTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXImageView", _p_FXImageViewTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXToolBarShell", _p_FXToolBarShellTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXToolBar", _p_FXToolBarTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXScrollPane", _p_FXScrollPaneTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXDirBox", _p_FXDirBoxTo_p_FXObject, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXPopup[] = {{"_p_FXPopup", 0, "FXPopup *", 0, 0, 0, 0},{"_p_FXPopup", 0, 0, 0, 0, 0, 0},{"_p_FXMenuPane", _p_FXMenuPaneTo_p_FXPopup, 0, 0, 0, 0, 0},{"_p_FXMDIMenu", _p_FXMDIMenuTo_p_FXPopup, 0, 0, 0, 0, 0},{"_p_FXScrollPane", _p_FXScrollPaneTo_p_FXPopup, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXMDIChild[] = {{"_p_FXMDIChild", 0, "FXMDIChild *", 0, 0, 0, 0},{"_p_FXMDIChild", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXMDIDeleteButton[] = {{"_p_FXMDIDeleteButton", 0, "FXMDIDeleteButton *", 0, 0, 0, 0},{"_p_FXMDIDeleteButton", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXMenuButton[] = {{"_p_FXMenuButton", 0, "FXMenuButton *", 0, 0, 0, 0},{"_p_FXMenuButton", 0, 0, 0, 0, 0, 0},{"_p_FXMDIWindowButton", _p_FXMDIWindowButtonTo_p_FXMenuButton, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXWindow[] = {{"_p_FXWindow", 0, "FXWindow *", 0, 0, 0, 0},{"_p_FXShutterItem", _p_FXShutterItemTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXColorBar", _p_FXColorBarTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXMenuCheck", _p_FXMenuCheckTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXMDIChild", _p_FXMDIChildTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXTabBar", _p_FXTabBarTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXSwitcher", _p_FXSwitcherTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXTextField", _p_FXTextFieldTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXToolBarTab", _p_FXToolBarTabTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXDriveBox", _p_FXDriveBoxTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXMDIMenu", _p_FXMDIMenuTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXMatrix", _p_FXMatrixTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXScrollCorner", _p_FXScrollCornerTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXCheckButton", _p_FXCheckButtonTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXArrowButton", _p_FXArrowButtonTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXMenuButton", _p_FXMenuButtonTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXMDIWindowButton", _p_FXMDIWindowButtonTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXRadioButton", _p_FXRadioButtonTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXToggleButton", _p_FXToggleButtonTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXTriStateButton", _p_FXTriStateButtonTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXMDIDeleteButton", _p_FXMDIDeleteButtonTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXMDIRestoreButton", _p_FXMDIRestoreButtonTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXMDIMaximizeButton", _p_FXMDIMaximizeButtonTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXMDIMinimizeButton", _p_FXMDIMinimizeButtonTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXPicker", _p_FXPickerTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXPopup", _p_FXPopupTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXMenuPane", _p_FXMenuPaneTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXHeader", _p_FXHeaderTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXSplitter", _p_FXSplitterTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FX4Splitter", _p_FX4SplitterTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXSpring", _p_FXSpringTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXPacker", _p_FXPackerTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXTabBook", _p_FXTabBookTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXImageFrame", _p_FXImageFrameTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXMenuSeparator", _p_FXMenuSeparatorTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXSeparator", _p_FXSeparatorTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXHorizontalSeparator", _p_FXHorizontalSeparatorTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXVerticalSeparator", _p_FXVerticalSeparatorTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXProgressBar", _p_FXProgressBarTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXShutter", _p_FXShutterTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXMDIClient", _p_FXMDIClientTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXToolTip", _p_FXToolTipTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXComposite", _p_FXCompositeTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXBitmapFrame", _p_FXBitmapFrameTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXRealSlider", _p_FXRealSliderTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXSlider", _p_FXSliderTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXMenuCascade", _p_FXMenuCascadeTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXGroupBox", _p_FXGroupBoxTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXListBox", _p_FXListBoxTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXTreeListBox", _p_FXTreeListBoxTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXCanvas", _p_FXCanvasTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXColorWheel", _p_FXColorWheelTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXDial", _p_FXDialTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXButton", _p_FXButtonTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXToolBarGrip", _p_FXToolBarGripTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXScrollBar", _p_FXScrollBarTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXComboBox", _p_FXComboBoxTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXTabItem", _p_FXTabItemTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXFrame", _p_FXFrameTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXStatusBar", _p_FXStatusBarTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXMenuCommand", _p_FXMenuCommandTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXRealSpinner", _p_FXRealSpinnerTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXSpinner", _p_FXSpinnerTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXScrollWindow", _p_FXScrollWindowTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXRootWindow", _p_FXRootWindowTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXMainWindow", _p_FXMainWindowTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXTopWindow", _p_FXTopWindowTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXWindow", 0, 0, 0, 0, 0, 0},{"_p_FXMenuBar", _p_FXMenuBarTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXStatusLine", _p_FXStatusLineTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXMenuCaption", _p_FXMenuCaptionTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXMenuTitle", _p_FXMenuTitleTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXMenuRadio", _p_FXMenuRadioTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXLabel", _p_FXLabelTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXShell", _p_FXShellTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXOption", _p_FXOptionTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXOptionMenu", _p_FXOptionMenuTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXScrollArea", _p_FXScrollAreaTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXColorWell", _p_FXColorWellTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXDragCorner", _p_FXDragCornerTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXRuler", _p_FXRulerTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXHorizontalFrame", _p_FXHorizontalFrameTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXVerticalFrame", _p_FXVerticalFrameTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXImageView", _p_FXImageViewTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXColorSelector", _p_FXColorSelectorTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXFileSelector", _p_FXFileSelectorTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXDirSelector", _p_FXDirSelectorTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXFontSelector", _p_FXFontSelectorTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXToolBarShell", _p_FXToolBarShellTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXToolBar", _p_FXToolBarTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXScrollPane", _p_FXScrollPaneTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXDirBox", _p_FXDirBoxTo_p_FXWindow, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXLabel[] = {{"_p_FXLabel", 0, "FXLabel *", 0, 0, 0, 0},{"_p_FXPicker", _p_FXPickerTo_p_FXLabel, 0, 0, 0, 0, 0},{"_p_FXMDIMinimizeButton", _p_FXMDIMinimizeButtonTo_p_FXLabel, 0, 0, 0, 0, 0},{"_p_FXMDIMaximizeButton", _p_FXMDIMaximizeButtonTo_p_FXLabel, 0, 0, 0, 0, 0},{"_p_FXMDIRestoreButton", _p_FXMDIRestoreButtonTo_p_FXLabel, 0, 0, 0, 0, 0},{"_p_FXMDIDeleteButton", _p_FXMDIDeleteButtonTo_p_FXLabel, 0, 0, 0, 0, 0},{"_p_FXTriStateButton", _p_FXTriStateButtonTo_p_FXLabel, 0, 0, 0, 0, 0},{"_p_FXToggleButton", _p_FXToggleButtonTo_p_FXLabel, 0, 0, 0, 0, 0},{"_p_FXRadioButton", _p_FXRadioButtonTo_p_FXLabel, 0, 0, 0, 0, 0},{"_p_FXMenuButton", _p_FXMenuButtonTo_p_FXLabel, 0, 0, 0, 0, 0},{"_p_FXCheckButton", _p_FXCheckButtonTo_p_FXLabel, 0, 0, 0, 0, 0},{"_p_FXMDIWindowButton", _p_FXMDIWindowButtonTo_p_FXLabel, 0, 0, 0, 0, 0},{"_p_FXLabel", 0, 0, 0, 0, 0, 0},{"_p_FXButton", _p_FXButtonTo_p_FXLabel, 0, 0, 0, 0, 0},{"_p_FXTabItem", _p_FXTabItemTo_p_FXLabel, 0, 0, 0, 0, 0},{"_p_FXOption", _p_FXOptionTo_p_FXLabel, 0, 0, 0, 0, 0},{"_p_FXOptionMenu", _p_FXOptionMenuTo_p_FXLabel, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXComposite[] = {{"_p_FXComposite", 0, "FXComposite *", 0, 0, 0, 0},{"_p_FXDriveBox", _p_FXDriveBoxTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXMDIClient", _p_FXMDIClientTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXMenuPane", _p_FXMenuPaneTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXMenuBar", _p_FXMenuBarTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXToolBar", _p_FXToolBarTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXComposite", 0, 0, 0, 0, 0, 0},{"_p_FXToolTip", _p_FXToolTipTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXTabBook", _p_FXTabBookTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXGroupBox", _p_FXGroupBoxTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXShell", _p_FXShellTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXStatusBar", _p_FXStatusBarTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXScrollArea", _p_FXScrollAreaTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXPopup", _p_FXPopupTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXScrollWindow", _p_FXScrollWindowTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXRootWindow", _p_FXRootWindowTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXMainWindow", _p_FXMainWindowTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXTopWindow", _p_FXTopWindowTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXComboBox", _p_FXComboBoxTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXHorizontalFrame", _p_FXHorizontalFrameTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXVerticalFrame", _p_FXVerticalFrameTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXMDIChild", _p_FXMDIChildTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FX4Splitter", _p_FX4SplitterTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXSplitter", _p_FXSplitterTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXRealSpinner", _p_FXRealSpinnerTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXSpinner", _p_FXSpinnerTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXPacker", _p_FXPackerTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXDirBox", _p_FXDirBoxTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXSwitcher", _p_FXSwitcherTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXFileSelector", _p_FXFileSelectorTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXDirSelector", _p_FXDirSelectorTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXFontSelector", _p_FXFontSelectorTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXColorSelector", _p_FXColorSelectorTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXShutter", _p_FXShutterTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXTreeListBox", _p_FXTreeListBoxTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXListBox", _p_FXListBoxTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXMatrix", _p_FXMatrixTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXShutterItem", _p_FXShutterItemTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXTabBar", _p_FXTabBarTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXImageView", _p_FXImageViewTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXSpring", _p_FXSpringTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXScrollPane", _p_FXScrollPaneTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXToolBarShell", _p_FXToolBarShellTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXMDIMenu", _p_FXMDIMenuTo_p_FXComposite, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXMDIRestoreButton[] = {{"_p_FXMDIRestoreButton", 0, "FXMDIRestoreButton *", 0, 0, 0, 0},{"_p_FXMDIRestoreButton", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXMDIMaximizeButton[] = {{"_p_FXMDIMaximizeButton", 0, "FXMDIMaximizeButton *", 0, 0, 0, 0},{"_p_FXMDIMaximizeButton", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXMDIMinimizeButton[] = {{"_p_FXMDIMinimizeButton", 0, "FXMDIMinimizeButton *", 0, 0, 0, 0},{"_p_FXMDIMinimizeButton", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXMDIWindowButton[] = {{"_p_FXMDIWindowButton", 0, "FXMDIWindowButton *", 0, 0, 0, 0},{"_p_FXMDIWindowButton", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXId[] = {{"_p_FXId", 0, "FXId *", 0, 0, 0, 0},{"_p_FXShutterItem", _p_FXShutterItemTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXColorBar", _p_FXColorBarTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXMenuCheck", _p_FXMenuCheckTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXMDIChild", _p_FXMDIChildTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXTabBar", _p_FXTabBarTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXSwitcher", _p_FXSwitcherTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXTextField", _p_FXTextFieldTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXToolBarTab", _p_FXToolBarTabTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXDriveBox", _p_FXDriveBoxTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXMDIMenu", _p_FXMDIMenuTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXMatrix", _p_FXMatrixTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXScrollCorner", _p_FXScrollCornerTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXArrowButton", _p_FXArrowButtonTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXCheckButton", _p_FXCheckButtonTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXMenuButton", _p_FXMenuButtonTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXMDIWindowButton", _p_FXMDIWindowButtonTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXRadioButton", _p_FXRadioButtonTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXToggleButton", _p_FXToggleButtonTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXTriStateButton", _p_FXTriStateButtonTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXMDIDeleteButton", _p_FXMDIDeleteButtonTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXMDIRestoreButton", _p_FXMDIRestoreButtonTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXMDIMaximizeButton", _p_FXMDIMaximizeButtonTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXMDIMinimizeButton", _p_FXMDIMinimizeButtonTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXPicker", _p_FXPickerTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXPopup", _p_FXPopupTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXDrawable", _p_FXDrawableTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXMenuPane", _p_FXMenuPaneTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXFont", _p_FXFontTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXHeader", _p_FXHeaderTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXSplitter", _p_FXSplitterTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FX4Splitter", _p_FX4SplitterTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXSpring", _p_FXSpringTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXPacker", _p_FXPackerTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXTabBook", _p_FXTabBookTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXImageFrame", _p_FXImageFrameTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXMenuSeparator", _p_FXMenuSeparatorTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXVerticalSeparator", _p_FXVerticalSeparatorTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXSeparator", _p_FXSeparatorTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXHorizontalSeparator", _p_FXHorizontalSeparatorTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXProgressBar", _p_FXProgressBarTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXShutter", _p_FXShutterTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXMDIClient", _p_FXMDIClientTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXToolTip", _p_FXToolTipTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXComposite", _p_FXCompositeTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXBitmapFrame", _p_FXBitmapFrameTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXRealSlider", _p_FXRealSliderTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXSlider", _p_FXSliderTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXMenuCascade", _p_FXMenuCascadeTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXGroupBox", _p_FXGroupBoxTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXListBox", _p_FXListBoxTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXTreeListBox", _p_FXTreeListBoxTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXCanvas", _p_FXCanvasTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXId", 0, 0, 0, 0, 0, 0},{"_p_FXColorWheel", _p_FXColorWheelTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXDial", _p_FXDialTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXButton", _p_FXButtonTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXToolBarGrip", _p_FXToolBarGripTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXScrollBar", _p_FXScrollBarTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXVisual", _p_FXVisualTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXComboBox", _p_FXComboBoxTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXTabItem", _p_FXTabItemTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXFrame", _p_FXFrameTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXStatusBar", _p_FXStatusBarTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXCursor", _p_FXCursorTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXCURCursor", _p_FXCURCursorTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXGIFCursor", _p_FXGIFCursorTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXMenuCommand", _p_FXMenuCommandTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXRealSpinner", _p_FXRealSpinnerTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXSpinner", _p_FXSpinnerTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXScrollWindow", _p_FXScrollWindowTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXRootWindow", _p_FXRootWindowTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXMainWindow", _p_FXMainWindowTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXTopWindow", _p_FXTopWindowTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXMenuBar", _p_FXMenuBarTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXStatusLine", _p_FXStatusLineTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXMenuCaption", _p_FXMenuCaptionTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXMenuTitle", _p_FXMenuTitleTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXWindow", _p_FXWindowTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXMenuRadio", _p_FXMenuRadioTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXLabel", _p_FXLabelTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXShell", _p_FXShellTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXOption", _p_FXOptionTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXOptionMenu", _p_FXOptionMenuTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXScrollArea", _p_FXScrollAreaTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXColorWell", _p_FXColorWellTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXDragCorner", _p_FXDragCornerTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXRuler", _p_FXRulerTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXHorizontalFrame", _p_FXHorizontalFrameTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXVerticalFrame", _p_FXVerticalFrameTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXImageView", _p_FXImageViewTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXColorSelector", _p_FXColorSelectorTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXFileSelector", _p_FXFileSelectorTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXDirSelector", _p_FXDirSelectorTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXFontSelector", _p_FXFontSelectorTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXToolBarShell", _p_FXToolBarShellTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXToolBar", _p_FXToolBarTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXScrollPane", _p_FXScrollPaneTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXDirBox", _p_FXDirBoxTo_p_FXId, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXFont[] = {{"_p_FXFont", 0, "FXFont *", 0, 0, 0, 0},{"_p_FXFont", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXShell[] = {{"_p_FXShell", 0, "FXShell *", 0, 0, 0, 0},{"_p_FXShell", 0, 0, 0, 0, 0, 0},{"_p_FXPopup", _p_FXPopupTo_p_FXShell, 0, 0, 0, 0, 0},{"_p_FXMenuPane", _p_FXMenuPaneTo_p_FXShell, 0, 0, 0, 0, 0},{"_p_FXTopWindow", _p_FXTopWindowTo_p_FXShell, 0, 0, 0, 0, 0},{"_p_FXMainWindow", _p_FXMainWindowTo_p_FXShell, 0, 0, 0, 0, 0},{"_p_FXToolTip", _p_FXToolTipTo_p_FXShell, 0, 0, 0, 0, 0},{"_p_FXMDIMenu", _p_FXMDIMenuTo_p_FXShell, 0, 0, 0, 0, 0},{"_p_FXToolBarShell", _p_FXToolBarShellTo_p_FXShell, 0, 0, 0, 0, 0},{"_p_FXScrollPane", _p_FXScrollPaneTo_p_FXShell, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXMDIMenu[] = {{"_p_FXMDIMenu", 0, "FXMDIMenu *", 0, 0, 0, 0},{"_p_FXMDIMenu", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXButton[] = {{"_p_FXButton", 0, "FXButton *", 0, 0, 0, 0},{"_p_FXButton", 0, 0, 0, 0, 0, 0},{"_p_FXPicker", _p_FXPickerTo_p_FXButton, 0, 0, 0, 0, 0},{"_p_FXMDIDeleteButton", _p_FXMDIDeleteButtonTo_p_FXButton, 0, 0, 0, 0, 0},{"_p_FXMDIRestoreButton", _p_FXMDIRestoreButtonTo_p_FXButton, 0, 0, 0, 0, 0},{"_p_FXMDIMaximizeButton", _p_FXMDIMaximizeButtonTo_p_FXButton, 0, 0, 0, 0, 0},{"_p_FXMDIMinimizeButton", _p_FXMDIMinimizeButtonTo_p_FXButton, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXStream[] = {{"_p_FXStream", 0, "FXStream *", 0, 0, 0, 0},{"_p_FXFileStream", _p_FXFileStreamTo_p_FXStream, 0, 0, 0, 0, 0},{"_p_FXMemoryStream", _p_FXMemoryStreamTo_p_FXStream, 0, 0, 0, 0, 0},{"_p_FXStream", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXDrawable[] = {{"_p_FXDrawable", 0, "FXDrawable *", 0, 0, 0, 0},{"_p_FXShutterItem", _p_FXShutterItemTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXColorBar", _p_FXColorBarTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXMenuCheck", _p_FXMenuCheckTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXMDIChild", _p_FXMDIChildTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXTabBar", _p_FXTabBarTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXSwitcher", _p_FXSwitcherTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXTextField", _p_FXTextFieldTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXToolBarTab", _p_FXToolBarTabTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXDriveBox", _p_FXDriveBoxTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXMDIMenu", _p_FXMDIMenuTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXMatrix", _p_FXMatrixTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXScrollCorner", _p_FXScrollCornerTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXArrowButton", _p_FXArrowButtonTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXCheckButton", _p_FXCheckButtonTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXMenuButton", _p_FXMenuButtonTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXMDIWindowButton", _p_FXMDIWindowButtonTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXRadioButton", _p_FXRadioButtonTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXToggleButton", _p_FXToggleButtonTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXTriStateButton", _p_FXTriStateButtonTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXMDIDeleteButton", _p_FXMDIDeleteButtonTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXMDIRestoreButton", _p_FXMDIRestoreButtonTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXMDIMaximizeButton", _p_FXMDIMaximizeButtonTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXMDIMinimizeButton", _p_FXMDIMinimizeButtonTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXPicker", _p_FXPickerTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXPopup", _p_FXPopupTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXDrawable", 0, 0, 0, 0, 0, 0},{"_p_FXMenuPane", _p_FXMenuPaneTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXHeader", _p_FXHeaderTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXSplitter", _p_FXSplitterTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FX4Splitter", _p_FX4SplitterTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXSpring", _p_FXSpringTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXPacker", _p_FXPackerTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXTabBook", _p_FXTabBookTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXImageFrame", _p_FXImageFrameTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXMenuSeparator", _p_FXMenuSeparatorTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXVerticalSeparator", _p_FXVerticalSeparatorTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXSeparator", _p_FXSeparatorTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXHorizontalSeparator", _p_FXHorizontalSeparatorTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXProgressBar", _p_FXProgressBarTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXShutter", _p_FXShutterTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXMDIClient", _p_FXMDIClientTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXToolTip", _p_FXToolTipTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXComposite", _p_FXCompositeTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXBitmapFrame", _p_FXBitmapFrameTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXRealSlider", _p_FXRealSliderTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXSlider", _p_FXSliderTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXMenuCascade", _p_FXMenuCascadeTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXGroupBox", _p_FXGroupBoxTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXListBox", _p_FXListBoxTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXTreeListBox", _p_FXTreeListBoxTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXCanvas", _p_FXCanvasTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXColorWheel", _p_FXColorWheelTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXDial", _p_FXDialTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXButton", _p_FXButtonTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXToolBarGrip", _p_FXToolBarGripTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXScrollBar", _p_FXScrollBarTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXComboBox", _p_FXComboBoxTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXTabItem", _p_FXTabItemTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXFrame", _p_FXFrameTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXStatusBar", _p_FXStatusBarTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXMenuCommand", _p_FXMenuCommandTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXRealSpinner", _p_FXRealSpinnerTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXSpinner", _p_FXSpinnerTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXScrollWindow", _p_FXScrollWindowTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXRootWindow", _p_FXRootWindowTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXMainWindow", _p_FXMainWindowTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXTopWindow", _p_FXTopWindowTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXMenuBar", _p_FXMenuBarTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXStatusLine", _p_FXStatusLineTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXMenuCaption", _p_FXMenuCaptionTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXMenuTitle", _p_FXMenuTitleTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXWindow", _p_FXWindowTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXMenuRadio", _p_FXMenuRadioTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXLabel", _p_FXLabelTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXShell", _p_FXShellTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXOption", _p_FXOptionTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXOptionMenu", _p_FXOptionMenuTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXScrollArea", _p_FXScrollAreaTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXColorWell", _p_FXColorWellTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXDragCorner", _p_FXDragCornerTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXRuler", _p_FXRulerTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXHorizontalFrame", _p_FXHorizontalFrameTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXVerticalFrame", _p_FXVerticalFrameTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXImageView", _p_FXImageViewTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXColorSelector", _p_FXColorSelectorTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXFileSelector", _p_FXFileSelectorTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXDirSelector", _p_FXDirSelectorTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXFontSelector", _p_FXFontSelectorTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXToolBarShell", _p_FXToolBarShellTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXToolBar", _p_FXToolBarTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXScrollPane", _p_FXScrollPaneTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXDirBox", _p_FXDirBoxTo_p_FXDrawable, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXIcon[] = {{"_p_FXIcon", 0, "FXIcon *", 0, 0, 0, 0},{"_p_FXIcon", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXMenuPane[] = {{"_p_FXMenuPane", 0, "FXMenuPane *", 0, 0, 0, 0},{"_p_FXMenuPane", 0, 0, 0, 0, 0, 0},{"_p_FXMDIMenu", _p_FXMDIMenuTo_p_FXMenuPane, 0, 0, 0, 0, 0},{"_p_FXScrollPane", _p_FXScrollPaneTo_p_FXMenuPane, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};

static swig_type_info *swig_types_initial[] = {
_swigt__p_FXFrame, 
_swigt__p_FXMDIClient, 
_swigt__p_FXObject, 
_swigt__p_FXPopup, 
_swigt__p_FXMDIChild, 
_swigt__p_FXMDIDeleteButton, 
_swigt__p_FXMenuButton, 
_swigt__p_FXWindow, 
_swigt__p_FXLabel, 
_swigt__p_FXComposite, 
_swigt__p_FXMDIRestoreButton, 
_swigt__p_FXMDIMaximizeButton, 
_swigt__p_FXMDIMinimizeButton, 
_swigt__p_FXMDIWindowButton, 
_swigt__p_FXId, 
_swigt__p_FXFont, 
_swigt__p_FXShell, 
_swigt__p_FXMDIMenu, 
_swigt__p_FXButton, 
_swigt__p_FXStream, 
_swigt__p_FXDrawable, 
_swigt__p_FXIcon, 
_swigt__p_FXMenuPane, 
0
};


/* -------- TYPE CONVERSION AND EQUIVALENCE RULES (END) -------- */


#ifdef __cplusplus
extern "C"
#endif
SWIGEXPORT(void) Init_mdi(void) {
    int i;
    
    SWIG_InitRuntime();
    
    for (i = 0; swig_types_initial[i]; i++) {
        swig_types[i] = SWIG_TypeRegister(swig_types_initial[i]);
        SWIG_define_class(swig_types[i]);
    }
    
    
    cFXMDIDeleteButton.klass = rb_define_class_under(mFox, "FXMDIDeleteButton", ((swig_class *) SWIGTYPE_p_FXButton->clientdata)->klass);
    SWIG_TypeClientData(SWIGTYPE_p_FXMDIDeleteButton, (void *) &cFXMDIDeleteButton);
    rb_define_alloc_func(cFXMDIDeleteButton.klass, _wrap_FXMDIDeleteButton_allocate);
    rb_define_method(cFXMDIDeleteButton.klass, "initialize", VALUEFUNC(_wrap_new_FXMDIDeleteButton), -1);
    rb_define_method(cFXMDIDeleteButton.klass, "onPaint", VALUEFUNC(_wrap_FXMDIDeleteButton_onPaint), -1);
    rb_define_method(cFXMDIDeleteButton.klass, "save", VALUEFUNC(_wrap_FXMDIDeleteButton_save), -1);
    rb_define_method(cFXMDIDeleteButton.klass, "load", VALUEFUNC(_wrap_FXMDIDeleteButton_load), -1);
    rb_define_method(cFXMDIDeleteButton.klass, "create", VALUEFUNC(_wrap_FXMDIDeleteButton_create), -1);
    rb_define_method(cFXMDIDeleteButton.klass, "detach", VALUEFUNC(_wrap_FXMDIDeleteButton_detach), -1);
    rb_define_method(cFXMDIDeleteButton.klass, "destroy", VALUEFUNC(_wrap_FXMDIDeleteButton_destroy), -1);
    rb_define_method(cFXMDIDeleteButton.klass, "resize", VALUEFUNC(_wrap_FXMDIDeleteButton_resize), -1);
    rb_define_method(cFXMDIDeleteButton.klass, "getDefaultWidth", VALUEFUNC(_wrap_FXMDIDeleteButton_getDefaultWidth), -1);
    rb_define_method(cFXMDIDeleteButton.klass, "getDefaultHeight", VALUEFUNC(_wrap_FXMDIDeleteButton_getDefaultHeight), -1);
    rb_define_method(cFXMDIDeleteButton.klass, "getWidthForHeight", VALUEFUNC(_wrap_FXMDIDeleteButton_getWidthForHeight), -1);
    rb_define_method(cFXMDIDeleteButton.klass, "getHeightForWidth", VALUEFUNC(_wrap_FXMDIDeleteButton_getHeightForWidth), -1);
    rb_define_method(cFXMDIDeleteButton.klass, "canFocus", VALUEFUNC(_wrap_FXMDIDeleteButton_canFocus), -1);
    rb_define_method(cFXMDIDeleteButton.klass, "setFocus", VALUEFUNC(_wrap_FXMDIDeleteButton_setFocus), -1);
    rb_define_method(cFXMDIDeleteButton.klass, "killFocus", VALUEFUNC(_wrap_FXMDIDeleteButton_killFocus), -1);
    rb_define_method(cFXMDIDeleteButton.klass, "setDefault", VALUEFUNC(_wrap_FXMDIDeleteButton_setDefault), -1);
    rb_define_method(cFXMDIDeleteButton.klass, "enable", VALUEFUNC(_wrap_FXMDIDeleteButton_enable), -1);
    rb_define_method(cFXMDIDeleteButton.klass, "disable", VALUEFUNC(_wrap_FXMDIDeleteButton_disable), -1);
    rb_define_method(cFXMDIDeleteButton.klass, "raiseWindow", VALUEFUNC(_wrap_FXMDIDeleteButton_raiseWindow), -1);
    rb_define_method(cFXMDIDeleteButton.klass, "lower", VALUEFUNC(_wrap_FXMDIDeleteButton_lower), -1);
    rb_define_method(cFXMDIDeleteButton.klass, "move", VALUEFUNC(_wrap_FXMDIDeleteButton_move), -1);
    rb_define_method(cFXMDIDeleteButton.klass, "position", VALUEFUNC(_wrap_FXMDIDeleteButton_position), -1);
    rb_define_method(cFXMDIDeleteButton.klass, "layout", VALUEFUNC(_wrap_FXMDIDeleteButton_layout), -1);
    rb_define_method(cFXMDIDeleteButton.klass, "recalc", VALUEFUNC(_wrap_FXMDIDeleteButton_recalc), -1);
    rb_define_method(cFXMDIDeleteButton.klass, "reparent", VALUEFUNC(_wrap_FXMDIDeleteButton_reparent), -1);
    rb_define_method(cFXMDIDeleteButton.klass, "show", VALUEFUNC(_wrap_FXMDIDeleteButton_show), -1);
    rb_define_method(cFXMDIDeleteButton.klass, "hide", VALUEFUNC(_wrap_FXMDIDeleteButton_hide), -1);
    rb_define_method(cFXMDIDeleteButton.klass, "isComposite", VALUEFUNC(_wrap_FXMDIDeleteButton_isComposite), -1);
    rb_define_method(cFXMDIDeleteButton.klass, "contains", VALUEFUNC(_wrap_FXMDIDeleteButton_contains), -1);
    rb_define_method(cFXMDIDeleteButton.klass, "doesSaveUnder", VALUEFUNC(_wrap_FXMDIDeleteButton_doesSaveUnder), -1);
    rb_define_method(cFXMDIDeleteButton.klass, "setBackColor", VALUEFUNC(_wrap_FXMDIDeleteButton_setBackColor), -1);
    cFXMDIDeleteButton.mark = (void (*)(void *)) FXRbMDIDeleteButton::markfunc;
    cFXMDIDeleteButton.destroy = (void (*)(void *)) FXRbObject::freefunc;
    
    cFXMDIRestoreButton.klass = rb_define_class_under(mFox, "FXMDIRestoreButton", ((swig_class *) SWIGTYPE_p_FXButton->clientdata)->klass);
    SWIG_TypeClientData(SWIGTYPE_p_FXMDIRestoreButton, (void *) &cFXMDIRestoreButton);
    rb_define_alloc_func(cFXMDIRestoreButton.klass, _wrap_FXMDIRestoreButton_allocate);
    rb_define_method(cFXMDIRestoreButton.klass, "initialize", VALUEFUNC(_wrap_new_FXMDIRestoreButton), -1);
    rb_define_method(cFXMDIRestoreButton.klass, "onPaint", VALUEFUNC(_wrap_FXMDIRestoreButton_onPaint), -1);
    rb_define_method(cFXMDIRestoreButton.klass, "save", VALUEFUNC(_wrap_FXMDIRestoreButton_save), -1);
    rb_define_method(cFXMDIRestoreButton.klass, "load", VALUEFUNC(_wrap_FXMDIRestoreButton_load), -1);
    rb_define_method(cFXMDIRestoreButton.klass, "create", VALUEFUNC(_wrap_FXMDIRestoreButton_create), -1);
    rb_define_method(cFXMDIRestoreButton.klass, "detach", VALUEFUNC(_wrap_FXMDIRestoreButton_detach), -1);
    rb_define_method(cFXMDIRestoreButton.klass, "destroy", VALUEFUNC(_wrap_FXMDIRestoreButton_destroy), -1);
    rb_define_method(cFXMDIRestoreButton.klass, "resize", VALUEFUNC(_wrap_FXMDIRestoreButton_resize), -1);
    rb_define_method(cFXMDIRestoreButton.klass, "getDefaultWidth", VALUEFUNC(_wrap_FXMDIRestoreButton_getDefaultWidth), -1);
    rb_define_method(cFXMDIRestoreButton.klass, "getDefaultHeight", VALUEFUNC(_wrap_FXMDIRestoreButton_getDefaultHeight), -1);
    rb_define_method(cFXMDIRestoreButton.klass, "getWidthForHeight", VALUEFUNC(_wrap_FXMDIRestoreButton_getWidthForHeight), -1);
    rb_define_method(cFXMDIRestoreButton.klass, "getHeightForWidth", VALUEFUNC(_wrap_FXMDIRestoreButton_getHeightForWidth), -1);
    rb_define_method(cFXMDIRestoreButton.klass, "canFocus", VALUEFUNC(_wrap_FXMDIRestoreButton_canFocus), -1);
    rb_define_method(cFXMDIRestoreButton.klass, "setFocus", VALUEFUNC(_wrap_FXMDIRestoreButton_setFocus), -1);
    rb_define_method(cFXMDIRestoreButton.klass, "killFocus", VALUEFUNC(_wrap_FXMDIRestoreButton_killFocus), -1);
    rb_define_method(cFXMDIRestoreButton.klass, "setDefault", VALUEFUNC(_wrap_FXMDIRestoreButton_setDefault), -1);
    rb_define_method(cFXMDIRestoreButton.klass, "enable", VALUEFUNC(_wrap_FXMDIRestoreButton_enable), -1);
    rb_define_method(cFXMDIRestoreButton.klass, "disable", VALUEFUNC(_wrap_FXMDIRestoreButton_disable), -1);
    rb_define_method(cFXMDIRestoreButton.klass, "raiseWindow", VALUEFUNC(_wrap_FXMDIRestoreButton_raiseWindow), -1);
    rb_define_method(cFXMDIRestoreButton.klass, "lower", VALUEFUNC(_wrap_FXMDIRestoreButton_lower), -1);
    rb_define_method(cFXMDIRestoreButton.klass, "move", VALUEFUNC(_wrap_FXMDIRestoreButton_move), -1);
    rb_define_method(cFXMDIRestoreButton.klass, "position", VALUEFUNC(_wrap_FXMDIRestoreButton_position), -1);
    rb_define_method(cFXMDIRestoreButton.klass, "layout", VALUEFUNC(_wrap_FXMDIRestoreButton_layout), -1);
    rb_define_method(cFXMDIRestoreButton.klass, "recalc", VALUEFUNC(_wrap_FXMDIRestoreButton_recalc), -1);
    rb_define_method(cFXMDIRestoreButton.klass, "reparent", VALUEFUNC(_wrap_FXMDIRestoreButton_reparent), -1);
    rb_define_method(cFXMDIRestoreButton.klass, "show", VALUEFUNC(_wrap_FXMDIRestoreButton_show), -1);
    rb_define_method(cFXMDIRestoreButton.klass, "hide", VALUEFUNC(_wrap_FXMDIRestoreButton_hide), -1);
    rb_define_method(cFXMDIRestoreButton.klass, "isComposite", VALUEFUNC(_wrap_FXMDIRestoreButton_isComposite), -1);
    rb_define_method(cFXMDIRestoreButton.klass, "contains", VALUEFUNC(_wrap_FXMDIRestoreButton_contains), -1);
    rb_define_method(cFXMDIRestoreButton.klass, "doesSaveUnder", VALUEFUNC(_wrap_FXMDIRestoreButton_doesSaveUnder), -1);
    rb_define_method(cFXMDIRestoreButton.klass, "setBackColor", VALUEFUNC(_wrap_FXMDIRestoreButton_setBackColor), -1);
    cFXMDIRestoreButton.mark = (void (*)(void *)) FXRbMDIRestoreButton::markfunc;
    cFXMDIRestoreButton.destroy = (void (*)(void *)) FXRbObject::freefunc;
    
    cFXMDIMaximizeButton.klass = rb_define_class_under(mFox, "FXMDIMaximizeButton", ((swig_class *) SWIGTYPE_p_FXButton->clientdata)->klass);
    SWIG_TypeClientData(SWIGTYPE_p_FXMDIMaximizeButton, (void *) &cFXMDIMaximizeButton);
    rb_define_alloc_func(cFXMDIMaximizeButton.klass, _wrap_FXMDIMaximizeButton_allocate);
    rb_define_method(cFXMDIMaximizeButton.klass, "initialize", VALUEFUNC(_wrap_new_FXMDIMaximizeButton), -1);
    rb_define_method(cFXMDIMaximizeButton.klass, "onPaint", VALUEFUNC(_wrap_FXMDIMaximizeButton_onPaint), -1);
    rb_define_method(cFXMDIMaximizeButton.klass, "save", VALUEFUNC(_wrap_FXMDIMaximizeButton_save), -1);
    rb_define_method(cFXMDIMaximizeButton.klass, "load", VALUEFUNC(_wrap_FXMDIMaximizeButton_load), -1);
    rb_define_method(cFXMDIMaximizeButton.klass, "create", VALUEFUNC(_wrap_FXMDIMaximizeButton_create), -1);
    rb_define_method(cFXMDIMaximizeButton.klass, "detach", VALUEFUNC(_wrap_FXMDIMaximizeButton_detach), -1);
    rb_define_method(cFXMDIMaximizeButton.klass, "destroy", VALUEFUNC(_wrap_FXMDIMaximizeButton_destroy), -1);
    rb_define_method(cFXMDIMaximizeButton.klass, "resize", VALUEFUNC(_wrap_FXMDIMaximizeButton_resize), -1);
    rb_define_method(cFXMDIMaximizeButton.klass, "getDefaultWidth", VALUEFUNC(_wrap_FXMDIMaximizeButton_getDefaultWidth), -1);
    rb_define_method(cFXMDIMaximizeButton.klass, "getDefaultHeight", VALUEFUNC(_wrap_FXMDIMaximizeButton_getDefaultHeight), -1);
    rb_define_method(cFXMDIMaximizeButton.klass, "getWidthForHeight", VALUEFUNC(_wrap_FXMDIMaximizeButton_getWidthForHeight), -1);
    rb_define_method(cFXMDIMaximizeButton.klass, "getHeightForWidth", VALUEFUNC(_wrap_FXMDIMaximizeButton_getHeightForWidth), -1);
    rb_define_method(cFXMDIMaximizeButton.klass, "canFocus", VALUEFUNC(_wrap_FXMDIMaximizeButton_canFocus), -1);
    rb_define_method(cFXMDIMaximizeButton.klass, "setFocus", VALUEFUNC(_wrap_FXMDIMaximizeButton_setFocus), -1);
    rb_define_method(cFXMDIMaximizeButton.klass, "killFocus", VALUEFUNC(_wrap_FXMDIMaximizeButton_killFocus), -1);
    rb_define_method(cFXMDIMaximizeButton.klass, "setDefault", VALUEFUNC(_wrap_FXMDIMaximizeButton_setDefault), -1);
    rb_define_method(cFXMDIMaximizeButton.klass, "enable", VALUEFUNC(_wrap_FXMDIMaximizeButton_enable), -1);
    rb_define_method(cFXMDIMaximizeButton.klass, "disable", VALUEFUNC(_wrap_FXMDIMaximizeButton_disable), -1);
    rb_define_method(cFXMDIMaximizeButton.klass, "raiseWindow", VALUEFUNC(_wrap_FXMDIMaximizeButton_raiseWindow), -1);
    rb_define_method(cFXMDIMaximizeButton.klass, "lower", VALUEFUNC(_wrap_FXMDIMaximizeButton_lower), -1);
    rb_define_method(cFXMDIMaximizeButton.klass, "move", VALUEFUNC(_wrap_FXMDIMaximizeButton_move), -1);
    rb_define_method(cFXMDIMaximizeButton.klass, "position", VALUEFUNC(_wrap_FXMDIMaximizeButton_position), -1);
    rb_define_method(cFXMDIMaximizeButton.klass, "layout", VALUEFUNC(_wrap_FXMDIMaximizeButton_layout), -1);
    rb_define_method(cFXMDIMaximizeButton.klass, "recalc", VALUEFUNC(_wrap_FXMDIMaximizeButton_recalc), -1);
    rb_define_method(cFXMDIMaximizeButton.klass, "reparent", VALUEFUNC(_wrap_FXMDIMaximizeButton_reparent), -1);
    rb_define_method(cFXMDIMaximizeButton.klass, "show", VALUEFUNC(_wrap_FXMDIMaximizeButton_show), -1);
    rb_define_method(cFXMDIMaximizeButton.klass, "hide", VALUEFUNC(_wrap_FXMDIMaximizeButton_hide), -1);
    rb_define_method(cFXMDIMaximizeButton.klass, "isComposite", VALUEFUNC(_wrap_FXMDIMaximizeButton_isComposite), -1);
    rb_define_method(cFXMDIMaximizeButton.klass, "contains", VALUEFUNC(_wrap_FXMDIMaximizeButton_contains), -1);
    rb_define_method(cFXMDIMaximizeButton.klass, "doesSaveUnder", VALUEFUNC(_wrap_FXMDIMaximizeButton_doesSaveUnder), -1);
    rb_define_method(cFXMDIMaximizeButton.klass, "setBackColor", VALUEFUNC(_wrap_FXMDIMaximizeButton_setBackColor), -1);
    cFXMDIMaximizeButton.mark = (void (*)(void *)) FXRbMDIMaximizeButton::markfunc;
    cFXMDIMaximizeButton.destroy = (void (*)(void *)) FXRbObject::freefunc;
    
    cFXMDIMinimizeButton.klass = rb_define_class_under(mFox, "FXMDIMinimizeButton", ((swig_class *) SWIGTYPE_p_FXButton->clientdata)->klass);
    SWIG_TypeClientData(SWIGTYPE_p_FXMDIMinimizeButton, (void *) &cFXMDIMinimizeButton);
    rb_define_alloc_func(cFXMDIMinimizeButton.klass, _wrap_FXMDIMinimizeButton_allocate);
    rb_define_method(cFXMDIMinimizeButton.klass, "initialize", VALUEFUNC(_wrap_new_FXMDIMinimizeButton), -1);
    rb_define_method(cFXMDIMinimizeButton.klass, "onPaint", VALUEFUNC(_wrap_FXMDIMinimizeButton_onPaint), -1);
    rb_define_method(cFXMDIMinimizeButton.klass, "save", VALUEFUNC(_wrap_FXMDIMinimizeButton_save), -1);
    rb_define_method(cFXMDIMinimizeButton.klass, "load", VALUEFUNC(_wrap_FXMDIMinimizeButton_load), -1);
    rb_define_method(cFXMDIMinimizeButton.klass, "create", VALUEFUNC(_wrap_FXMDIMinimizeButton_create), -1);
    rb_define_method(cFXMDIMinimizeButton.klass, "detach", VALUEFUNC(_wrap_FXMDIMinimizeButton_detach), -1);
    rb_define_method(cFXMDIMinimizeButton.klass, "destroy", VALUEFUNC(_wrap_FXMDIMinimizeButton_destroy), -1);
    rb_define_method(cFXMDIMinimizeButton.klass, "resize", VALUEFUNC(_wrap_FXMDIMinimizeButton_resize), -1);
    rb_define_method(cFXMDIMinimizeButton.klass, "getDefaultWidth", VALUEFUNC(_wrap_FXMDIMinimizeButton_getDefaultWidth), -1);
    rb_define_method(cFXMDIMinimizeButton.klass, "getDefaultHeight", VALUEFUNC(_wrap_FXMDIMinimizeButton_getDefaultHeight), -1);
    rb_define_method(cFXMDIMinimizeButton.klass, "getWidthForHeight", VALUEFUNC(_wrap_FXMDIMinimizeButton_getWidthForHeight), -1);
    rb_define_method(cFXMDIMinimizeButton.klass, "getHeightForWidth", VALUEFUNC(_wrap_FXMDIMinimizeButton_getHeightForWidth), -1);
    rb_define_method(cFXMDIMinimizeButton.klass, "canFocus", VALUEFUNC(_wrap_FXMDIMinimizeButton_canFocus), -1);
    rb_define_method(cFXMDIMinimizeButton.klass, "setFocus", VALUEFUNC(_wrap_FXMDIMinimizeButton_setFocus), -1);
    rb_define_method(cFXMDIMinimizeButton.klass, "killFocus", VALUEFUNC(_wrap_FXMDIMinimizeButton_killFocus), -1);
    rb_define_method(cFXMDIMinimizeButton.klass, "setDefault", VALUEFUNC(_wrap_FXMDIMinimizeButton_setDefault), -1);
    rb_define_method(cFXMDIMinimizeButton.klass, "enable", VALUEFUNC(_wrap_FXMDIMinimizeButton_enable), -1);
    rb_define_method(cFXMDIMinimizeButton.klass, "disable", VALUEFUNC(_wrap_FXMDIMinimizeButton_disable), -1);
    rb_define_method(cFXMDIMinimizeButton.klass, "raiseWindow", VALUEFUNC(_wrap_FXMDIMinimizeButton_raiseWindow), -1);
    rb_define_method(cFXMDIMinimizeButton.klass, "lower", VALUEFUNC(_wrap_FXMDIMinimizeButton_lower), -1);
    rb_define_method(cFXMDIMinimizeButton.klass, "move", VALUEFUNC(_wrap_FXMDIMinimizeButton_move), -1);
    rb_define_method(cFXMDIMinimizeButton.klass, "position", VALUEFUNC(_wrap_FXMDIMinimizeButton_position), -1);
    rb_define_method(cFXMDIMinimizeButton.klass, "layout", VALUEFUNC(_wrap_FXMDIMinimizeButton_layout), -1);
    rb_define_method(cFXMDIMinimizeButton.klass, "recalc", VALUEFUNC(_wrap_FXMDIMinimizeButton_recalc), -1);
    rb_define_method(cFXMDIMinimizeButton.klass, "reparent", VALUEFUNC(_wrap_FXMDIMinimizeButton_reparent), -1);
    rb_define_method(cFXMDIMinimizeButton.klass, "show", VALUEFUNC(_wrap_FXMDIMinimizeButton_show), -1);
    rb_define_method(cFXMDIMinimizeButton.klass, "hide", VALUEFUNC(_wrap_FXMDIMinimizeButton_hide), -1);
    rb_define_method(cFXMDIMinimizeButton.klass, "isComposite", VALUEFUNC(_wrap_FXMDIMinimizeButton_isComposite), -1);
    rb_define_method(cFXMDIMinimizeButton.klass, "contains", VALUEFUNC(_wrap_FXMDIMinimizeButton_contains), -1);
    rb_define_method(cFXMDIMinimizeButton.klass, "doesSaveUnder", VALUEFUNC(_wrap_FXMDIMinimizeButton_doesSaveUnder), -1);
    rb_define_method(cFXMDIMinimizeButton.klass, "setBackColor", VALUEFUNC(_wrap_FXMDIMinimizeButton_setBackColor), -1);
    cFXMDIMinimizeButton.mark = (void (*)(void *)) FXRbMDIMinimizeButton::markfunc;
    cFXMDIMinimizeButton.destroy = (void (*)(void *)) FXRbObject::freefunc;
    
    cFXMDIWindowButton.klass = rb_define_class_under(mFox, "FXMDIWindowButton", ((swig_class *) SWIGTYPE_p_FXMenuButton->clientdata)->klass);
    SWIG_TypeClientData(SWIGTYPE_p_FXMDIWindowButton, (void *) &cFXMDIWindowButton);
    rb_define_alloc_func(cFXMDIWindowButton.klass, _wrap_FXMDIWindowButton_allocate);
    rb_define_method(cFXMDIWindowButton.klass, "initialize", VALUEFUNC(_wrap_new_FXMDIWindowButton), -1);
    rb_define_method(cFXMDIWindowButton.klass, "onPaint", VALUEFUNC(_wrap_FXMDIWindowButton_onPaint), -1);
    rb_define_method(cFXMDIWindowButton.klass, "save", VALUEFUNC(_wrap_FXMDIWindowButton_save), -1);
    rb_define_method(cFXMDIWindowButton.klass, "load", VALUEFUNC(_wrap_FXMDIWindowButton_load), -1);
    rb_define_method(cFXMDIWindowButton.klass, "create", VALUEFUNC(_wrap_FXMDIWindowButton_create), -1);
    rb_define_method(cFXMDIWindowButton.klass, "detach", VALUEFUNC(_wrap_FXMDIWindowButton_detach), -1);
    rb_define_method(cFXMDIWindowButton.klass, "destroy", VALUEFUNC(_wrap_FXMDIWindowButton_destroy), -1);
    rb_define_method(cFXMDIWindowButton.klass, "resize", VALUEFUNC(_wrap_FXMDIWindowButton_resize), -1);
    rb_define_method(cFXMDIWindowButton.klass, "getDefaultWidth", VALUEFUNC(_wrap_FXMDIWindowButton_getDefaultWidth), -1);
    rb_define_method(cFXMDIWindowButton.klass, "getDefaultHeight", VALUEFUNC(_wrap_FXMDIWindowButton_getDefaultHeight), -1);
    rb_define_method(cFXMDIWindowButton.klass, "getWidthForHeight", VALUEFUNC(_wrap_FXMDIWindowButton_getWidthForHeight), -1);
    rb_define_method(cFXMDIWindowButton.klass, "getHeightForWidth", VALUEFUNC(_wrap_FXMDIWindowButton_getHeightForWidth), -1);
    rb_define_method(cFXMDIWindowButton.klass, "canFocus", VALUEFUNC(_wrap_FXMDIWindowButton_canFocus), -1);
    rb_define_method(cFXMDIWindowButton.klass, "setFocus", VALUEFUNC(_wrap_FXMDIWindowButton_setFocus), -1);
    rb_define_method(cFXMDIWindowButton.klass, "killFocus", VALUEFUNC(_wrap_FXMDIWindowButton_killFocus), -1);
    rb_define_method(cFXMDIWindowButton.klass, "setDefault", VALUEFUNC(_wrap_FXMDIWindowButton_setDefault), -1);
    rb_define_method(cFXMDIWindowButton.klass, "enable", VALUEFUNC(_wrap_FXMDIWindowButton_enable), -1);
    rb_define_method(cFXMDIWindowButton.klass, "disable", VALUEFUNC(_wrap_FXMDIWindowButton_disable), -1);
    rb_define_method(cFXMDIWindowButton.klass, "raiseWindow", VALUEFUNC(_wrap_FXMDIWindowButton_raiseWindow), -1);
    rb_define_method(cFXMDIWindowButton.klass, "lower", VALUEFUNC(_wrap_FXMDIWindowButton_lower), -1);
    rb_define_method(cFXMDIWindowButton.klass, "move", VALUEFUNC(_wrap_FXMDIWindowButton_move), -1);
    rb_define_method(cFXMDIWindowButton.klass, "position", VALUEFUNC(_wrap_FXMDIWindowButton_position), -1);
    rb_define_method(cFXMDIWindowButton.klass, "layout", VALUEFUNC(_wrap_FXMDIWindowButton_layout), -1);
    rb_define_method(cFXMDIWindowButton.klass, "recalc", VALUEFUNC(_wrap_FXMDIWindowButton_recalc), -1);
    rb_define_method(cFXMDIWindowButton.klass, "reparent", VALUEFUNC(_wrap_FXMDIWindowButton_reparent), -1);
    rb_define_method(cFXMDIWindowButton.klass, "show", VALUEFUNC(_wrap_FXMDIWindowButton_show), -1);
    rb_define_method(cFXMDIWindowButton.klass, "hide", VALUEFUNC(_wrap_FXMDIWindowButton_hide), -1);
    rb_define_method(cFXMDIWindowButton.klass, "isComposite", VALUEFUNC(_wrap_FXMDIWindowButton_isComposite), -1);
    rb_define_method(cFXMDIWindowButton.klass, "contains", VALUEFUNC(_wrap_FXMDIWindowButton_contains), -1);
    rb_define_method(cFXMDIWindowButton.klass, "doesSaveUnder", VALUEFUNC(_wrap_FXMDIWindowButton_doesSaveUnder), -1);
    rb_define_method(cFXMDIWindowButton.klass, "setBackColor", VALUEFUNC(_wrap_FXMDIWindowButton_setBackColor), -1);
    cFXMDIWindowButton.mark = (void (*)(void *)) FXRbMDIWindowButton::markfunc;
    cFXMDIWindowButton.destroy = (void (*)(void *)) FXRbObject::freefunc;
    
    cFXMDIMenu.klass = rb_define_class_under(mFox, "FXMDIMenu", ((swig_class *) SWIGTYPE_p_FXMenuPane->clientdata)->klass);
    SWIG_TypeClientData(SWIGTYPE_p_FXMDIMenu, (void *) &cFXMDIMenu);
    rb_define_alloc_func(cFXMDIMenu.klass, _wrap_FXMDIMenu_allocate);
    rb_define_method(cFXMDIMenu.klass, "initialize", VALUEFUNC(_wrap_new_FXMDIMenu), -1);
    rb_define_method(cFXMDIMenu.klass, "save", VALUEFUNC(_wrap_FXMDIMenu_save), -1);
    rb_define_method(cFXMDIMenu.klass, "load", VALUEFUNC(_wrap_FXMDIMenu_load), -1);
    rb_define_method(cFXMDIMenu.klass, "create", VALUEFUNC(_wrap_FXMDIMenu_create), -1);
    rb_define_method(cFXMDIMenu.klass, "detach", VALUEFUNC(_wrap_FXMDIMenu_detach), -1);
    rb_define_method(cFXMDIMenu.klass, "destroy", VALUEFUNC(_wrap_FXMDIMenu_destroy), -1);
    rb_define_method(cFXMDIMenu.klass, "resize", VALUEFUNC(_wrap_FXMDIMenu_resize), -1);
    rb_define_method(cFXMDIMenu.klass, "getDefaultWidth", VALUEFUNC(_wrap_FXMDIMenu_getDefaultWidth), -1);
    rb_define_method(cFXMDIMenu.klass, "getDefaultHeight", VALUEFUNC(_wrap_FXMDIMenu_getDefaultHeight), -1);
    rb_define_method(cFXMDIMenu.klass, "getWidthForHeight", VALUEFUNC(_wrap_FXMDIMenu_getWidthForHeight), -1);
    rb_define_method(cFXMDIMenu.klass, "getHeightForWidth", VALUEFUNC(_wrap_FXMDIMenu_getHeightForWidth), -1);
    rb_define_method(cFXMDIMenu.klass, "canFocus", VALUEFUNC(_wrap_FXMDIMenu_canFocus), -1);
    rb_define_method(cFXMDIMenu.klass, "setFocus", VALUEFUNC(_wrap_FXMDIMenu_setFocus), -1);
    rb_define_method(cFXMDIMenu.klass, "killFocus", VALUEFUNC(_wrap_FXMDIMenu_killFocus), -1);
    rb_define_method(cFXMDIMenu.klass, "setDefault", VALUEFUNC(_wrap_FXMDIMenu_setDefault), -1);
    rb_define_method(cFXMDIMenu.klass, "enable", VALUEFUNC(_wrap_FXMDIMenu_enable), -1);
    rb_define_method(cFXMDIMenu.klass, "disable", VALUEFUNC(_wrap_FXMDIMenu_disable), -1);
    rb_define_method(cFXMDIMenu.klass, "raiseWindow", VALUEFUNC(_wrap_FXMDIMenu_raiseWindow), -1);
    rb_define_method(cFXMDIMenu.klass, "lower", VALUEFUNC(_wrap_FXMDIMenu_lower), -1);
    rb_define_method(cFXMDIMenu.klass, "move", VALUEFUNC(_wrap_FXMDIMenu_move), -1);
    rb_define_method(cFXMDIMenu.klass, "position", VALUEFUNC(_wrap_FXMDIMenu_position), -1);
    rb_define_method(cFXMDIMenu.klass, "layout", VALUEFUNC(_wrap_FXMDIMenu_layout), -1);
    rb_define_method(cFXMDIMenu.klass, "recalc", VALUEFUNC(_wrap_FXMDIMenu_recalc), -1);
    rb_define_method(cFXMDIMenu.klass, "reparent", VALUEFUNC(_wrap_FXMDIMenu_reparent), -1);
    rb_define_method(cFXMDIMenu.klass, "show", VALUEFUNC(_wrap_FXMDIMenu_show), -1);
    rb_define_method(cFXMDIMenu.klass, "hide", VALUEFUNC(_wrap_FXMDIMenu_hide), -1);
    rb_define_method(cFXMDIMenu.klass, "isComposite", VALUEFUNC(_wrap_FXMDIMenu_isComposite), -1);
    rb_define_method(cFXMDIMenu.klass, "contains", VALUEFUNC(_wrap_FXMDIMenu_contains), -1);
    rb_define_method(cFXMDIMenu.klass, "doesSaveUnder", VALUEFUNC(_wrap_FXMDIMenu_doesSaveUnder), -1);
    rb_define_method(cFXMDIMenu.klass, "setBackColor", VALUEFUNC(_wrap_FXMDIMenu_setBackColor), -1);
    rb_define_method(cFXMDIMenu.klass, "popup", VALUEFUNC(_wrap_FXMDIMenu_popup), -1);
    rb_define_method(cFXMDIMenu.klass, "popdown", VALUEFUNC(_wrap_FXMDIMenu_popdown), -1);
    cFXMDIMenu.mark = (void (*)(void *)) FXRbMDIMenu::markfunc;
    cFXMDIMenu.destroy = (void (*)(void *)) FXRbObject::freefunc;
    
    cFXMDIClient.klass = rb_define_class_under(mFox, "FXMDIClient", ((swig_class *) SWIGTYPE_p_FXComposite->clientdata)->klass);
    SWIG_TypeClientData(SWIGTYPE_p_FXMDIClient, (void *) &cFXMDIClient);
    rb_define_alloc_func(cFXMDIClient.klass, _wrap_FXMDIClient_allocate);
    rb_define_method(cFXMDIClient.klass, "initialize", VALUEFUNC(_wrap_new_FXMDIClient), -1);
    rb_define_method(cFXMDIClient.klass, "onCmdActivateNext", VALUEFUNC(_wrap_FXMDIClient_onCmdActivateNext), -1);
    rb_define_method(cFXMDIClient.klass, "onCmdActivatePrev", VALUEFUNC(_wrap_FXMDIClient_onCmdActivatePrev), -1);
    rb_define_method(cFXMDIClient.klass, "onCmdTileHorizontal", VALUEFUNC(_wrap_FXMDIClient_onCmdTileHorizontal), -1);
    rb_define_method(cFXMDIClient.klass, "onCmdTileVertical", VALUEFUNC(_wrap_FXMDIClient_onCmdTileVertical), -1);
    rb_define_method(cFXMDIClient.klass, "onCmdCascade", VALUEFUNC(_wrap_FXMDIClient_onCmdCascade), -1);
    rb_define_method(cFXMDIClient.klass, "onUpdActivateNext", VALUEFUNC(_wrap_FXMDIClient_onUpdActivateNext), -1);
    rb_define_method(cFXMDIClient.klass, "onUpdActivatePrev", VALUEFUNC(_wrap_FXMDIClient_onUpdActivatePrev), -1);
    rb_define_method(cFXMDIClient.klass, "onUpdTileVertical", VALUEFUNC(_wrap_FXMDIClient_onUpdTileVertical), -1);
    rb_define_method(cFXMDIClient.klass, "onUpdTileHorizontal", VALUEFUNC(_wrap_FXMDIClient_onUpdTileHorizontal), -1);
    rb_define_method(cFXMDIClient.klass, "onUpdCascade", VALUEFUNC(_wrap_FXMDIClient_onUpdCascade), -1);
    rb_define_method(cFXMDIClient.klass, "onUpdClose", VALUEFUNC(_wrap_FXMDIClient_onUpdClose), -1);
    rb_define_method(cFXMDIClient.klass, "onUpdMenuClose", VALUEFUNC(_wrap_FXMDIClient_onUpdMenuClose), -1);
    rb_define_method(cFXMDIClient.klass, "onUpdRestore", VALUEFUNC(_wrap_FXMDIClient_onUpdRestore), -1);
    rb_define_method(cFXMDIClient.klass, "onUpdMenuRestore", VALUEFUNC(_wrap_FXMDIClient_onUpdMenuRestore), -1);
    rb_define_method(cFXMDIClient.klass, "onUpdMinimize", VALUEFUNC(_wrap_FXMDIClient_onUpdMinimize), -1);
    rb_define_method(cFXMDIClient.klass, "onUpdMenuMinimize", VALUEFUNC(_wrap_FXMDIClient_onUpdMenuMinimize), -1);
    rb_define_method(cFXMDIClient.klass, "onUpdMaximize", VALUEFUNC(_wrap_FXMDIClient_onUpdMaximize), -1);
    rb_define_method(cFXMDIClient.klass, "onUpdMenuWindow", VALUEFUNC(_wrap_FXMDIClient_onUpdMenuWindow), -1);
    rb_define_method(cFXMDIClient.klass, "onCmdWindowSelect", VALUEFUNC(_wrap_FXMDIClient_onCmdWindowSelect), -1);
    rb_define_method(cFXMDIClient.klass, "onUpdWindowSelect", VALUEFUNC(_wrap_FXMDIClient_onUpdWindowSelect), -1);
    rb_define_method(cFXMDIClient.klass, "onCmdOthersWindows", VALUEFUNC(_wrap_FXMDIClient_onCmdOthersWindows), -1);
    rb_define_method(cFXMDIClient.klass, "onUpdOthersWindows", VALUEFUNC(_wrap_FXMDIClient_onUpdOthersWindows), -1);
    rb_define_method(cFXMDIClient.klass, "onUpdAnyWindows", VALUEFUNC(_wrap_FXMDIClient_onUpdAnyWindows), -1);
    rb_define_const(cFXMDIClient.klass,"ID_MDI_ANY", INT2NUM(FXMDIClient::ID_MDI_ANY));
    rb_define_const(cFXMDIClient.klass,"ID_MDI_1", INT2NUM(FXMDIClient::ID_MDI_1));
    rb_define_const(cFXMDIClient.klass,"ID_MDI_2", INT2NUM(FXMDIClient::ID_MDI_2));
    rb_define_const(cFXMDIClient.klass,"ID_MDI_3", INT2NUM(FXMDIClient::ID_MDI_3));
    rb_define_const(cFXMDIClient.klass,"ID_MDI_4", INT2NUM(FXMDIClient::ID_MDI_4));
    rb_define_const(cFXMDIClient.klass,"ID_MDI_5", INT2NUM(FXMDIClient::ID_MDI_5));
    rb_define_const(cFXMDIClient.klass,"ID_MDI_6", INT2NUM(FXMDIClient::ID_MDI_6));
    rb_define_const(cFXMDIClient.klass,"ID_MDI_7", INT2NUM(FXMDIClient::ID_MDI_7));
    rb_define_const(cFXMDIClient.klass,"ID_MDI_8", INT2NUM(FXMDIClient::ID_MDI_8));
    rb_define_const(cFXMDIClient.klass,"ID_MDI_9", INT2NUM(FXMDIClient::ID_MDI_9));
    rb_define_const(cFXMDIClient.klass,"ID_MDI_10", INT2NUM(FXMDIClient::ID_MDI_10));
    rb_define_const(cFXMDIClient.klass,"ID_MDI_OVER_1", INT2NUM(FXMDIClient::ID_MDI_OVER_1));
    rb_define_const(cFXMDIClient.klass,"ID_MDI_OVER_2", INT2NUM(FXMDIClient::ID_MDI_OVER_2));
    rb_define_const(cFXMDIClient.klass,"ID_MDI_OVER_3", INT2NUM(FXMDIClient::ID_MDI_OVER_3));
    rb_define_const(cFXMDIClient.klass,"ID_MDI_OVER_4", INT2NUM(FXMDIClient::ID_MDI_OVER_4));
    rb_define_const(cFXMDIClient.klass,"ID_MDI_OVER_5", INT2NUM(FXMDIClient::ID_MDI_OVER_5));
    rb_define_const(cFXMDIClient.klass,"ID_MDI_OVER_6", INT2NUM(FXMDIClient::ID_MDI_OVER_6));
    rb_define_const(cFXMDIClient.klass,"ID_MDI_OVER_7", INT2NUM(FXMDIClient::ID_MDI_OVER_7));
    rb_define_const(cFXMDIClient.klass,"ID_MDI_OVER_8", INT2NUM(FXMDIClient::ID_MDI_OVER_8));
    rb_define_const(cFXMDIClient.klass,"ID_MDI_OVER_9", INT2NUM(FXMDIClient::ID_MDI_OVER_9));
    rb_define_const(cFXMDIClient.klass,"ID_MDI_OVER_10", INT2NUM(FXMDIClient::ID_MDI_OVER_10));
    rb_define_const(cFXMDIClient.klass,"ID_LAST", INT2NUM(FXMDIClient::ID_LAST));
    rb_define_method(cFXMDIClient.klass, "forallWindows", VALUEFUNC(_wrap_FXMDIClient_forallWindows), -1);
    rb_define_method(cFXMDIClient.klass, "forallDocuments", VALUEFUNC(_wrap_FXMDIClient_forallDocuments), -1);
    rb_define_method(cFXMDIClient.klass, "forallDocWindows", VALUEFUNC(_wrap_FXMDIClient_forallDocWindows), -1);
    rb_define_method(cFXMDIClient.klass, "getActiveChild", VALUEFUNC(_wrap_FXMDIClient_getActiveChild), -1);
    rb_define_method(cFXMDIClient.klass, "setCascadeX", VALUEFUNC(_wrap_FXMDIClient_setCascadeX), -1);
    rb_define_method(cFXMDIClient.klass, "setCascadeY", VALUEFUNC(_wrap_FXMDIClient_setCascadeY), -1);
    rb_define_method(cFXMDIClient.klass, "getCascadeX", VALUEFUNC(_wrap_FXMDIClient_getCascadeX), -1);
    rb_define_method(cFXMDIClient.klass, "getCascadeY", VALUEFUNC(_wrap_FXMDIClient_getCascadeY), -1);
    rb_define_method(cFXMDIClient.klass, "save", VALUEFUNC(_wrap_FXMDIClient_save), -1);
    rb_define_method(cFXMDIClient.klass, "load", VALUEFUNC(_wrap_FXMDIClient_load), -1);
    rb_define_method(cFXMDIClient.klass, "create", VALUEFUNC(_wrap_FXMDIClient_create), -1);
    rb_define_method(cFXMDIClient.klass, "detach", VALUEFUNC(_wrap_FXMDIClient_detach), -1);
    rb_define_method(cFXMDIClient.klass, "destroy", VALUEFUNC(_wrap_FXMDIClient_destroy), -1);
    rb_define_method(cFXMDIClient.klass, "resize", VALUEFUNC(_wrap_FXMDIClient_resize), -1);
    rb_define_method(cFXMDIClient.klass, "getDefaultWidth", VALUEFUNC(_wrap_FXMDIClient_getDefaultWidth), -1);
    rb_define_method(cFXMDIClient.klass, "getDefaultHeight", VALUEFUNC(_wrap_FXMDIClient_getDefaultHeight), -1);
    rb_define_method(cFXMDIClient.klass, "getWidthForHeight", VALUEFUNC(_wrap_FXMDIClient_getWidthForHeight), -1);
    rb_define_method(cFXMDIClient.klass, "getHeightForWidth", VALUEFUNC(_wrap_FXMDIClient_getHeightForWidth), -1);
    rb_define_method(cFXMDIClient.klass, "canFocus", VALUEFUNC(_wrap_FXMDIClient_canFocus), -1);
    rb_define_method(cFXMDIClient.klass, "setFocus", VALUEFUNC(_wrap_FXMDIClient_setFocus), -1);
    rb_define_method(cFXMDIClient.klass, "killFocus", VALUEFUNC(_wrap_FXMDIClient_killFocus), -1);
    rb_define_method(cFXMDIClient.klass, "setDefault", VALUEFUNC(_wrap_FXMDIClient_setDefault), -1);
    rb_define_method(cFXMDIClient.klass, "enable", VALUEFUNC(_wrap_FXMDIClient_enable), -1);
    rb_define_method(cFXMDIClient.klass, "disable", VALUEFUNC(_wrap_FXMDIClient_disable), -1);
    rb_define_method(cFXMDIClient.klass, "raiseWindow", VALUEFUNC(_wrap_FXMDIClient_raiseWindow), -1);
    rb_define_method(cFXMDIClient.klass, "lower", VALUEFUNC(_wrap_FXMDIClient_lower), -1);
    rb_define_method(cFXMDIClient.klass, "move", VALUEFUNC(_wrap_FXMDIClient_move), -1);
    rb_define_method(cFXMDIClient.klass, "position", VALUEFUNC(_wrap_FXMDIClient_position), -1);
    rb_define_method(cFXMDIClient.klass, "layout", VALUEFUNC(_wrap_FXMDIClient_layout), -1);
    rb_define_method(cFXMDIClient.klass, "recalc", VALUEFUNC(_wrap_FXMDIClient_recalc), -1);
    rb_define_method(cFXMDIClient.klass, "reparent", VALUEFUNC(_wrap_FXMDIClient_reparent), -1);
    rb_define_method(cFXMDIClient.klass, "show", VALUEFUNC(_wrap_FXMDIClient_show), -1);
    rb_define_method(cFXMDIClient.klass, "hide", VALUEFUNC(_wrap_FXMDIClient_hide), -1);
    rb_define_method(cFXMDIClient.klass, "isComposite", VALUEFUNC(_wrap_FXMDIClient_isComposite), -1);
    rb_define_method(cFXMDIClient.klass, "contains", VALUEFUNC(_wrap_FXMDIClient_contains), -1);
    rb_define_method(cFXMDIClient.klass, "doesSaveUnder", VALUEFUNC(_wrap_FXMDIClient_doesSaveUnder), -1);
    rb_define_method(cFXMDIClient.klass, "setBackColor", VALUEFUNC(_wrap_FXMDIClient_setBackColor), -1);
    rb_define_method(cFXMDIClient.klass, "setActiveChild", VALUEFUNC(_wrap_FXMDIClient_setActiveChild), -1);
    rb_define_method(cFXMDIClient.klass, "cascade", VALUEFUNC(_wrap_FXMDIClient_cascade), -1);
    rb_define_method(cFXMDIClient.klass, "horizontal", VALUEFUNC(_wrap_FXMDIClient_horizontal), -1);
    rb_define_method(cFXMDIClient.klass, "vertical", VALUEFUNC(_wrap_FXMDIClient_vertical), -1);
    cFXMDIClient.mark = (void (*)(void *)) FXRbMDIClient::markfunc;
    cFXMDIClient.destroy = (void (*)(void *)) FXRbObject::freefunc;
    rb_define_const(mFox,"MDI_NORMAL", INT2NUM(MDI_NORMAL));
    rb_define_const(mFox,"MDI_MAXIMIZED", INT2NUM(MDI_MAXIMIZED));
    rb_define_const(mFox,"MDI_MINIMIZED", INT2NUM(MDI_MINIMIZED));
    rb_define_const(mFox,"MDI_TRACKING", INT2NUM(MDI_TRACKING));
    
    cFXMDIChild.klass = rb_define_class_under(mFox, "FXMDIChild", ((swig_class *) SWIGTYPE_p_FXComposite->clientdata)->klass);
    SWIG_TypeClientData(SWIGTYPE_p_FXMDIChild, (void *) &cFXMDIChild);
    rb_define_alloc_func(cFXMDIChild.klass, _wrap_FXMDIChild_allocate);
    rb_define_method(cFXMDIChild.klass, "initialize", VALUEFUNC(_wrap_new_FXMDIChild), -1);
    rb_define_method(cFXMDIChild.klass, "onPaint", VALUEFUNC(_wrap_FXMDIChild_onPaint), -1);
    rb_define_method(cFXMDIChild.klass, "onFocusSelf", VALUEFUNC(_wrap_FXMDIChild_onFocusSelf), -1);
    rb_define_method(cFXMDIChild.klass, "onFocusIn", VALUEFUNC(_wrap_FXMDIChild_onFocusIn), -1);
    rb_define_method(cFXMDIChild.klass, "onFocusOut", VALUEFUNC(_wrap_FXMDIChild_onFocusOut), -1);
    rb_define_method(cFXMDIChild.klass, "onRightBtnPress", VALUEFUNC(_wrap_FXMDIChild_onRightBtnPress), -1);
    rb_define_method(cFXMDIChild.klass, "onRightBtnRelease", VALUEFUNC(_wrap_FXMDIChild_onRightBtnRelease), -1);
    rb_define_method(cFXMDIChild.klass, "onLeftBtnPress", VALUEFUNC(_wrap_FXMDIChild_onLeftBtnPress), -1);
    rb_define_method(cFXMDIChild.klass, "onLeftBtnRelease", VALUEFUNC(_wrap_FXMDIChild_onLeftBtnRelease), -1);
    rb_define_method(cFXMDIChild.klass, "onMiddleBtnPress", VALUEFUNC(_wrap_FXMDIChild_onMiddleBtnPress), -1);
    rb_define_method(cFXMDIChild.klass, "onMiddleBtnRelease", VALUEFUNC(_wrap_FXMDIChild_onMiddleBtnRelease), -1);
    rb_define_method(cFXMDIChild.klass, "onMotion", VALUEFUNC(_wrap_FXMDIChild_onMotion), -1);
    rb_define_method(cFXMDIChild.klass, "onSelected", VALUEFUNC(_wrap_FXMDIChild_onSelected), -1);
    rb_define_method(cFXMDIChild.klass, "onDeselected", VALUEFUNC(_wrap_FXMDIChild_onDeselected), -1);
    rb_define_method(cFXMDIChild.klass, "onCmdClose", VALUEFUNC(_wrap_FXMDIChild_onCmdClose), -1);
    rb_define_method(cFXMDIChild.klass, "onUpdClose", VALUEFUNC(_wrap_FXMDIChild_onUpdClose), -1);
    rb_define_method(cFXMDIChild.klass, "onCmdRestore", VALUEFUNC(_wrap_FXMDIChild_onCmdRestore), -1);
    rb_define_method(cFXMDIChild.klass, "onUpdRestore", VALUEFUNC(_wrap_FXMDIChild_onUpdRestore), -1);
    rb_define_method(cFXMDIChild.klass, "onUpdMaximize", VALUEFUNC(_wrap_FXMDIChild_onUpdMaximize), -1);
    rb_define_method(cFXMDIChild.klass, "onUpdMinimize", VALUEFUNC(_wrap_FXMDIChild_onUpdMinimize), -1);
    rb_define_method(cFXMDIChild.klass, "onCmdMaximize", VALUEFUNC(_wrap_FXMDIChild_onCmdMaximize), -1);
    rb_define_method(cFXMDIChild.klass, "onCmdMinimize", VALUEFUNC(_wrap_FXMDIChild_onCmdMinimize), -1);
    rb_define_method(cFXMDIChild.klass, "onUpdWindow", VALUEFUNC(_wrap_FXMDIChild_onUpdWindow), -1);
    rb_define_method(cFXMDIChild.klass, "onUpdMenuRestore", VALUEFUNC(_wrap_FXMDIChild_onUpdMenuRestore), -1);
    rb_define_method(cFXMDIChild.klass, "onUpdMenuMinimize", VALUEFUNC(_wrap_FXMDIChild_onUpdMenuMinimize), -1);
    rb_define_method(cFXMDIChild.klass, "onUpdMenuClose", VALUEFUNC(_wrap_FXMDIChild_onUpdMenuClose), -1);
    rb_define_method(cFXMDIChild.klass, "onUpdMenuWindow", VALUEFUNC(_wrap_FXMDIChild_onUpdMenuWindow), -1);
    rb_define_method(cFXMDIChild.klass, "onCmdSetStringValue", VALUEFUNC(_wrap_FXMDIChild_onCmdSetStringValue), -1);
    rb_define_method(cFXMDIChild.klass, "onCmdGetStringValue", VALUEFUNC(_wrap_FXMDIChild_onCmdGetStringValue), -1);
    rb_define_method(cFXMDIChild.klass, "onCmdSetIconValue", VALUEFUNC(_wrap_FXMDIChild_onCmdSetIconValue), -1);
    rb_define_method(cFXMDIChild.klass, "onCmdGetIconValue", VALUEFUNC(_wrap_FXMDIChild_onCmdGetIconValue), -1);
    rb_define_method(cFXMDIChild.klass, "setNormalX", VALUEFUNC(_wrap_FXMDIChild_setNormalX), -1);
    rb_define_method(cFXMDIChild.klass, "setNormalY", VALUEFUNC(_wrap_FXMDIChild_setNormalY), -1);
    rb_define_method(cFXMDIChild.klass, "setNormalWidth", VALUEFUNC(_wrap_FXMDIChild_setNormalWidth), -1);
    rb_define_method(cFXMDIChild.klass, "setNormalHeight", VALUEFUNC(_wrap_FXMDIChild_setNormalHeight), -1);
    rb_define_method(cFXMDIChild.klass, "getNormalX", VALUEFUNC(_wrap_FXMDIChild_getNormalX), -1);
    rb_define_method(cFXMDIChild.klass, "getNormalY", VALUEFUNC(_wrap_FXMDIChild_getNormalY), -1);
    rb_define_method(cFXMDIChild.klass, "getNormalWidth", VALUEFUNC(_wrap_FXMDIChild_getNormalWidth), -1);
    rb_define_method(cFXMDIChild.klass, "getNormalHeight", VALUEFUNC(_wrap_FXMDIChild_getNormalHeight), -1);
    rb_define_method(cFXMDIChild.klass, "setIconX", VALUEFUNC(_wrap_FXMDIChild_setIconX), -1);
    rb_define_method(cFXMDIChild.klass, "setIconY", VALUEFUNC(_wrap_FXMDIChild_setIconY), -1);
    rb_define_method(cFXMDIChild.klass, "setIconWidth", VALUEFUNC(_wrap_FXMDIChild_setIconWidth), -1);
    rb_define_method(cFXMDIChild.klass, "setIconHeight", VALUEFUNC(_wrap_FXMDIChild_setIconHeight), -1);
    rb_define_method(cFXMDIChild.klass, "getIconX", VALUEFUNC(_wrap_FXMDIChild_getIconX), -1);
    rb_define_method(cFXMDIChild.klass, "getIconY", VALUEFUNC(_wrap_FXMDIChild_getIconY), -1);
    rb_define_method(cFXMDIChild.klass, "getIconWidth", VALUEFUNC(_wrap_FXMDIChild_getIconWidth), -1);
    rb_define_method(cFXMDIChild.klass, "getIconHeight", VALUEFUNC(_wrap_FXMDIChild_getIconHeight), -1);
    rb_define_method(cFXMDIChild.klass, "contentWindow", VALUEFUNC(_wrap_FXMDIChild_contentWindow), -1);
    rb_define_method(cFXMDIChild.klass, "setTitle", VALUEFUNC(_wrap_FXMDIChild_setTitle), -1);
    rb_define_method(cFXMDIChild.klass, "getTitle", VALUEFUNC(_wrap_FXMDIChild_getTitle), -1);
    rb_define_method(cFXMDIChild.klass, "getHiliteColor", VALUEFUNC(_wrap_FXMDIChild_getHiliteColor), -1);
    rb_define_method(cFXMDIChild.klass, "getShadowColor", VALUEFUNC(_wrap_FXMDIChild_getShadowColor), -1);
    rb_define_method(cFXMDIChild.klass, "getBaseColor", VALUEFUNC(_wrap_FXMDIChild_getBaseColor), -1);
    rb_define_method(cFXMDIChild.klass, "getBorderColor", VALUEFUNC(_wrap_FXMDIChild_getBorderColor), -1);
    rb_define_method(cFXMDIChild.klass, "getTitleColor", VALUEFUNC(_wrap_FXMDIChild_getTitleColor), -1);
    rb_define_method(cFXMDIChild.klass, "getTitleBackColor", VALUEFUNC(_wrap_FXMDIChild_getTitleBackColor), -1);
    rb_define_method(cFXMDIChild.klass, "setHiliteColor", VALUEFUNC(_wrap_FXMDIChild_setHiliteColor), -1);
    rb_define_method(cFXMDIChild.klass, "setShadowColor", VALUEFUNC(_wrap_FXMDIChild_setShadowColor), -1);
    rb_define_method(cFXMDIChild.klass, "setBaseColor", VALUEFUNC(_wrap_FXMDIChild_setBaseColor), -1);
    rb_define_method(cFXMDIChild.klass, "setBorderColor", VALUEFUNC(_wrap_FXMDIChild_setBorderColor), -1);
    rb_define_method(cFXMDIChild.klass, "setTitleColor", VALUEFUNC(_wrap_FXMDIChild_setTitleColor), -1);
    rb_define_method(cFXMDIChild.klass, "setTitleBackColor", VALUEFUNC(_wrap_FXMDIChild_setTitleBackColor), -1);
    rb_define_method(cFXMDIChild.klass, "isMaximized", VALUEFUNC(_wrap_FXMDIChild_isMaximized), -1);
    rb_define_method(cFXMDIChild.klass, "isMinimized", VALUEFUNC(_wrap_FXMDIChild_isMinimized), -1);
    rb_define_method(cFXMDIChild.klass, "getIcon", VALUEFUNC(_wrap_FXMDIChild_getIcon), -1);
    rb_define_method(cFXMDIChild.klass, "setIcon", VALUEFUNC(_wrap_FXMDIChild_setIcon), -1);
    rb_define_method(cFXMDIChild.klass, "getMenu", VALUEFUNC(_wrap_FXMDIChild_getMenu), -1);
    rb_define_method(cFXMDIChild.klass, "setMenu", VALUEFUNC(_wrap_FXMDIChild_setMenu), -1);
    rb_define_method(cFXMDIChild.klass, "setTracking", VALUEFUNC(_wrap_FXMDIChild_setTracking), -1);
    rb_define_method(cFXMDIChild.klass, "getTracking", VALUEFUNC(_wrap_FXMDIChild_getTracking), -1);
    rb_define_method(cFXMDIChild.klass, "setFont", VALUEFUNC(_wrap_FXMDIChild_setFont), -1);
    rb_define_method(cFXMDIChild.klass, "getFont", VALUEFUNC(_wrap_FXMDIChild_getFont), -1);
    rb_define_method(cFXMDIChild.klass, "save", VALUEFUNC(_wrap_FXMDIChild_save), -1);
    rb_define_method(cFXMDIChild.klass, "load", VALUEFUNC(_wrap_FXMDIChild_load), -1);
    rb_define_method(cFXMDIChild.klass, "create", VALUEFUNC(_wrap_FXMDIChild_create), -1);
    rb_define_method(cFXMDIChild.klass, "detach", VALUEFUNC(_wrap_FXMDIChild_detach), -1);
    rb_define_method(cFXMDIChild.klass, "destroy", VALUEFUNC(_wrap_FXMDIChild_destroy), -1);
    rb_define_method(cFXMDIChild.klass, "resize", VALUEFUNC(_wrap_FXMDIChild_resize), -1);
    rb_define_method(cFXMDIChild.klass, "getDefaultWidth", VALUEFUNC(_wrap_FXMDIChild_getDefaultWidth), -1);
    rb_define_method(cFXMDIChild.klass, "getDefaultHeight", VALUEFUNC(_wrap_FXMDIChild_getDefaultHeight), -1);
    rb_define_method(cFXMDIChild.klass, "getWidthForHeight", VALUEFUNC(_wrap_FXMDIChild_getWidthForHeight), -1);
    rb_define_method(cFXMDIChild.klass, "getHeightForWidth", VALUEFUNC(_wrap_FXMDIChild_getHeightForWidth), -1);
    rb_define_method(cFXMDIChild.klass, "canFocus", VALUEFUNC(_wrap_FXMDIChild_canFocus), -1);
    rb_define_method(cFXMDIChild.klass, "setFocus", VALUEFUNC(_wrap_FXMDIChild_setFocus), -1);
    rb_define_method(cFXMDIChild.klass, "killFocus", VALUEFUNC(_wrap_FXMDIChild_killFocus), -1);
    rb_define_method(cFXMDIChild.klass, "setDefault", VALUEFUNC(_wrap_FXMDIChild_setDefault), -1);
    rb_define_method(cFXMDIChild.klass, "enable", VALUEFUNC(_wrap_FXMDIChild_enable), -1);
    rb_define_method(cFXMDIChild.klass, "disable", VALUEFUNC(_wrap_FXMDIChild_disable), -1);
    rb_define_method(cFXMDIChild.klass, "raiseWindow", VALUEFUNC(_wrap_FXMDIChild_raiseWindow), -1);
    rb_define_method(cFXMDIChild.klass, "lower", VALUEFUNC(_wrap_FXMDIChild_lower), -1);
    rb_define_method(cFXMDIChild.klass, "move", VALUEFUNC(_wrap_FXMDIChild_move), -1);
    rb_define_method(cFXMDIChild.klass, "position", VALUEFUNC(_wrap_FXMDIChild_position), -1);
    rb_define_method(cFXMDIChild.klass, "layout", VALUEFUNC(_wrap_FXMDIChild_layout), -1);
    rb_define_method(cFXMDIChild.klass, "recalc", VALUEFUNC(_wrap_FXMDIChild_recalc), -1);
    rb_define_method(cFXMDIChild.klass, "reparent", VALUEFUNC(_wrap_FXMDIChild_reparent), -1);
    rb_define_method(cFXMDIChild.klass, "show", VALUEFUNC(_wrap_FXMDIChild_show), -1);
    rb_define_method(cFXMDIChild.klass, "hide", VALUEFUNC(_wrap_FXMDIChild_hide), -1);
    rb_define_method(cFXMDIChild.klass, "isComposite", VALUEFUNC(_wrap_FXMDIChild_isComposite), -1);
    rb_define_method(cFXMDIChild.klass, "contains", VALUEFUNC(_wrap_FXMDIChild_contains), -1);
    rb_define_method(cFXMDIChild.klass, "doesSaveUnder", VALUEFUNC(_wrap_FXMDIChild_doesSaveUnder), -1);
    rb_define_method(cFXMDIChild.klass, "setBackColor", VALUEFUNC(_wrap_FXMDIChild_setBackColor), -1);
    rb_define_method(cFXMDIChild.klass, "minimize", VALUEFUNC(_wrap_FXMDIChild_minimize), -1);
    rb_define_method(cFXMDIChild.klass, "maximize", VALUEFUNC(_wrap_FXMDIChild_maximize), -1);
    rb_define_method(cFXMDIChild.klass, "restore", VALUEFUNC(_wrap_FXMDIChild_restore), -1);
    rb_define_method(cFXMDIChild.klass, "close", VALUEFUNC(_wrap_FXMDIChild_close), -1);
    cFXMDIChild.mark = (void (*)(void *)) FXRbMDIChild::markfunc;
    cFXMDIChild.destroy = (void (*)(void *)) FXRbObject::freefunc;
}

