/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 1.3.22
 * 
 * This file is not intended to be easily readable and contains a number of 
 * coding conventions designed to improve portability and efficiency. Do not make
 * changes to this file unless you know what you are doing--modify the SWIG 
 * interface file instead. 
 * ----------------------------------------------------------------------------- */

#define SWIG_NOINCLUDE

#ifdef __cplusplus
template<class T> class SwigValueWrapper {
    T *tt;
public:
    SwigValueWrapper() : tt(0) { }
    SwigValueWrapper(const SwigValueWrapper<T>& rhs) : tt(new T(*rhs.tt)) { }
    SwigValueWrapper(const T& t) : tt(new T(t)) { }
    ~SwigValueWrapper() { delete tt; } 
    SwigValueWrapper& operator=(const T& t) { delete tt; tt = new T(t); return *this; }
    operator T&() const { return *tt; }
    T *operator&() { return tt; }
private:
    SwigValueWrapper& operator=(const SwigValueWrapper<T>& rhs);
};                                                    
#endif

/* ruby.swg */
/* Implementation : RUBY */
#define SWIGRUBY 1

#include "ruby.h"

/* Flags for pointer conversion */
#define SWIG_POINTER_EXCEPTION     0x1
#define SWIG_POINTER_DISOWN        0x2

#define NUM2USHRT(n) (\
    (0 <= NUM2UINT(n) && NUM2UINT(n) <= USHRT_MAX)\
    ? (unsigned short) NUM2UINT(n) \
    : (rb_raise(rb_eArgError, "integer %d out of range of `unsigned short'",\
               NUM2UINT(n)), (short)0)\
)

#define NUM2SHRT(n) (\
    (SHRT_MIN <= NUM2INT(n) && NUM2INT(n) <= SHRT_MAX)\
    ? (short)NUM2INT(n)\
    : (rb_raise(rb_eArgError, "integer %d out of range of `short'",\
               NUM2INT(n)), (short)0)\
)

/* Ruby 1.7 defines NUM2LL(), LL2NUM() and ULL2NUM() macros */
#ifndef NUM2LL
#define NUM2LL(x) NUM2LONG((x))
#endif
#ifndef LL2NUM
#define LL2NUM(x) INT2NUM((long) (x))
#endif
#ifndef ULL2NUM
#define ULL2NUM(x) UINT2NUM((unsigned long) (x))
#endif

/* Ruby 1.7 doesn't (yet) define NUM2ULL() */
#ifndef NUM2ULL
#ifdef HAVE_LONG_LONG
#define NUM2ULL(x) rb_num2ull((x))
#else
#define NUM2ULL(x) NUM2ULONG(x)
#endif
#endif

/*
 * Need to be very careful about how these macros are defined, especially
 * when compiling C++ code or C code with an ANSI C compiler.
 *
 * VALUEFUNC(f) is a macro used to typecast a C function that implements
 * a Ruby method so that it can be passed as an argument to API functions
 * like rb_define_method() and rb_define_singleton_method().
 *
 * VOIDFUNC(f) is a macro used to typecast a C function that implements
 * either the "mark" or "free" stuff for a Ruby Data object, so that it
 * can be passed as an argument to API functions like Data_Wrap_Struct()
 * and Data_Make_Struct().
 */
 
#ifdef __cplusplus
#  ifndef RUBY_METHOD_FUNC /* These definitions should work for Ruby 1.4.6 */
#    define PROTECTFUNC(f) ((VALUE (*)()) f)
#    define VALUEFUNC(f) ((VALUE (*)()) f)
#    define VOIDFUNC(f)  ((void (*)()) f)
#  else
#    ifndef ANYARGS /* These definitions should work for Ruby 1.6 */
#      define PROTECTFUNC(f) ((VALUE (*)()) f)
#      define VALUEFUNC(f) ((VALUE (*)()) f)
#      define VOIDFUNC(f)  ((RUBY_DATA_FUNC) f)
#    else /* These definitions should work for Ruby 1.7+ */
#      define PROTECTFUNC(f) ((VALUE (*)(VALUE)) f)
#      define VALUEFUNC(f) ((VALUE (*)(ANYARGS)) f)
#      define VOIDFUNC(f)  ((RUBY_DATA_FUNC) f)
#    endif
#  endif
#else
#  define VALUEFUNC(f) (f)
#  define VOIDFUNC(f) (f)
#endif

typedef struct {
  VALUE klass;
  VALUE mImpl;
  void  (*mark)(void *);
  void  (*destroy)(void *);
} swig_class;

/* Don't use for expressions have side effect */
#ifndef RB_STRING_VALUE
#define RB_STRING_VALUE(s) (TYPE(s) == T_STRING ? (s) : (*(volatile VALUE *)&(s) = rb_str_to_str(s)))
#endif
#ifndef StringValue
#define StringValue(s) RB_STRING_VALUE(s)
#endif
#ifndef StringValuePtr
#define StringValuePtr(s) RSTRING(RB_STRING_VALUE(s))->ptr
#endif
#ifndef StringValueLen
#define StringValueLen(s) RSTRING(RB_STRING_VALUE(s))->len
#endif
#ifndef SafeStringValue
#define SafeStringValue(v) do {\
    StringValue(v);\
    rb_check_safe_str(v);\
} while (0)
#endif

#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
#define rb_define_alloc_func(klass, func) rb_define_singleton_method((klass), "new", VALUEFUNC((func)), -1)
#define rb_undef_alloc_func(klass) rb_undef_method(CLASS_OF((klass)), "new")
#endif

/* Contract support */

#define SWIG_contract_assert(expr, msg) if (!(expr)) { rb_raise(rb_eRuntimeError, (char *) msg ); } else


/*************************************************************** -*- c -*-
 * ruby/precommon.swg
 *
 * Rename all exported symbols from common.swg, to avoid symbol
 * clashes if multiple interpreters are included
 *
 ************************************************************************/

#define SWIG_TypeRegister    SWIG_Ruby_TypeRegister
#define SWIG_TypeCheck       SWIG_Ruby_TypeCheck
#define SWIG_TypeCast        SWIG_Ruby_TypeCast
#define SWIG_TypeDynamicCast SWIG_Ruby_TypeDynamicCast
#define SWIG_TypeName        SWIG_Ruby_TypeName
#define SWIG_TypePrettyName  SWIG_Ruby_TypePrettyName
#define SWIG_TypeQuery       SWIG_Ruby_TypeQuery
#define SWIG_TypeClientData  SWIG_Ruby_TypeClientData
#define SWIG_PackData        SWIG_Ruby_PackData 
#define SWIG_UnpackData      SWIG_Ruby_UnpackData 

/* Also rename all exported symbols from rubydef.swig */

/* Common SWIG API */
#define SWIG_ConvertPtr(obj, pp, type, flags) \
  SWIG_Ruby_ConvertPtr(obj, pp, type, flags)
#define SWIG_NewPointerObj(p, type, flags) \
  SWIG_Ruby_NewPointerObj(p, type, flags)
#define SWIG_MustGetPtr(p, type, argnum, flags) \
  SWIG_Ruby_MustGetPtr(p, type, argnum, flags)

/* Ruby-specific SWIG API */

#define SWIG_InitRuntime() \
  SWIG_Ruby_InitRuntime()
#define SWIG_define_class(ty) \
  SWIG_Ruby_define_class(ty)
#define SWIG_NewClassInstance(value, ty) \
  SWIG_Ruby_NewClassInstance(value, ty)
#define SWIG_MangleStr(value) \
  SWIG_Ruby_MangleStr(value)
#define SWIG_CheckConvert(value, ty) \
  SWIG_Ruby_CheckConvert(value, ty)
#define SWIG_NewPackedObj(ptr, sz, ty) \
  SWIG_Ruby_NewPackedObj(ptr, sz, ty)
#define SWIG_ConvertPacked(obj, ptr, sz, ty, flags) \
  SWIG_Ruby_ConvertPacked(obj, ptr, sz, ty, flags)


/***********************************************************************
 * common.swg
 *
 *     This file contains generic SWIG runtime support for pointer
 *     type checking as well as a few commonly used macros to control
 *     external linkage.
 *
 * Author : David Beazley (beazley@cs.uchicago.edu)
 *
 * Copyright (c) 1999-2000, The University of Chicago
 * 
 * This file may be freely redistributed without license or fee provided
 * this copyright message remains intact.
 ************************************************************************/

#include <string.h>

#if defined(_WIN32) || defined(__WIN32__) || defined(__CYGWIN__)
#  if defined(_MSC_VER) || defined(__GNUC__)
#    if defined(STATIC_LINKED)
#      define SWIGEXPORT(a) a
#      define SWIGIMPORT(a) extern a
#    else
#      define SWIGEXPORT(a) __declspec(dllexport) a
#      define SWIGIMPORT(a) extern a
#    endif
#  else
#    if defined(__BORLANDC__)
#      define SWIGEXPORT(a) a _export
#      define SWIGIMPORT(a) a _export
#    else
#      define SWIGEXPORT(a) a
#      define SWIGIMPORT(a) a
#    endif
#  endif
#else
#  define SWIGEXPORT(a) a
#  define SWIGIMPORT(a) a
#endif

#ifdef SWIG_GLOBAL
#  define SWIGRUNTIME(a) SWIGEXPORT(a)
#else
#  define SWIGRUNTIME(a) static a
#endif

#ifdef __cplusplus
extern "C" {
#endif

typedef void *(*swig_converter_func)(void *);
typedef struct swig_type_info *(*swig_dycast_func)(void **);

typedef struct swig_type_info {
  const char             *name;
  swig_converter_func     converter;
  const char             *str;
  void                   *clientdata;
  swig_dycast_func        dcast;
  struct swig_type_info  *next;
  struct swig_type_info  *prev;
} swig_type_info;

#ifdef SWIG_NOINCLUDE

SWIGIMPORT(swig_type_info *) SWIG_TypeRegister(swig_type_info *);
SWIGIMPORT(swig_type_info *) SWIG_TypeCheck(char *c, swig_type_info *);
SWIGIMPORT(void *)           SWIG_TypeCast(swig_type_info *, void *);
SWIGIMPORT(swig_type_info *) SWIG_TypeDynamicCast(swig_type_info *, void **);
SWIGIMPORT(const char *)     SWIG_TypeName(const swig_type_info *);
SWIGIMPORT(const char *)     SWIG_TypePrettyName(const swig_type_info *);
SWIGIMPORT(swig_type_info *) SWIG_TypeQuery(const char *);
SWIGIMPORT(void)             SWIG_TypeClientData(swig_type_info *, void *);
SWIGIMPORT(char *)           SWIG_PackData(char *, void *, int);
SWIGIMPORT(char *)           SWIG_UnpackData(char *, void *, int);

#else

static swig_type_info *swig_type_list = 0;
static swig_type_info **swig_type_list_handle = &swig_type_list;

/* Register a type mapping with the type-checking */
SWIGRUNTIME(swig_type_info *)
SWIG_TypeRegister(swig_type_info *ti) {
  swig_type_info *tc, *head, *ret, *next;
  /* Check to see if this type has already been registered */
  tc = *swig_type_list_handle;
  while (tc) {
    if (strcmp(tc->name, ti->name) == 0) {
      /* Already exists in the table.  Just add additional types to the list */
      if (tc->clientdata) ti->clientdata = tc->clientdata;
      head = tc;
      next = tc->next;
      goto l1;
    }
    tc = tc->prev;
  }
  head = ti;
  next = 0;

  /* Place in list */
  ti->prev = *swig_type_list_handle;
  *swig_type_list_handle = ti;

  /* Build linked lists */
  l1:
  ret = head;
  tc = ti + 1;
  /* Patch up the rest of the links */
  while (tc->name) {
    head->next = tc;
    tc->prev = head;
    head = tc;
    tc++;
  }
  if (next) next->prev = head;
  head->next = next;
  return ret;
}

/* Check the typename */
SWIGRUNTIME(swig_type_info *) 
SWIG_TypeCheck(char *c, swig_type_info *ty) {
  swig_type_info *s;
  if (!ty) return 0;        /* Void pointer */
  s = ty->next;             /* First element always just a name */
  do {
    if (strcmp(s->name,c) == 0) {
      if (s == ty->next) return s;
      /* Move s to the top of the linked list */
      s->prev->next = s->next;
      if (s->next) {
        s->next->prev = s->prev;
      }
      /* Insert s as second element in the list */
      s->next = ty->next;
      if (ty->next) ty->next->prev = s;
      ty->next = s;
      s->prev = ty;
      return s;
    }
    s = s->next;
  } while (s && (s != ty->next));
  return 0;
}

/* Cast a pointer up an inheritance hierarchy */
SWIGRUNTIME(void *) 
SWIG_TypeCast(swig_type_info *ty, void *ptr) {
  if ((!ty) || (!ty->converter)) return ptr;
  return (*ty->converter)(ptr);
}

/* Dynamic pointer casting. Down an inheritance hierarchy */
SWIGRUNTIME(swig_type_info *) 
SWIG_TypeDynamicCast(swig_type_info *ty, void **ptr) {
  swig_type_info *lastty = ty;
  if (!ty || !ty->dcast) return ty;
  while (ty && (ty->dcast)) {
    ty = (*ty->dcast)(ptr);
    if (ty) lastty = ty;
  }
  return lastty;
}

/* Return the name associated with this type */
SWIGRUNTIME(const char *)
SWIG_TypeName(const swig_type_info *ty) {
  return ty->name;
}

/* Return the pretty name associated with this type,
   that is an unmangled type name in a form presentable to the user.
*/
SWIGRUNTIME(const char *)
SWIG_TypePrettyName(const swig_type_info *type) {
  /* The "str" field contains the equivalent pretty names of the
     type, separated by vertical-bar characters.  We choose
     to print the last name, as it is often (?) the most
     specific. */
  if (type->str != NULL) {
    const char *last_name = type->str;
    const char *s;
    for (s = type->str; *s; s++)
      if (*s == '|') last_name = s+1;
    return last_name;
  }
  else
    return type->name;
}

/* 
   Compare two type names skipping the space characters, therefore
   "char*" == "char *" and "Class<int>" == "Class<int >", etc.

   Return 0 when the two name types are equivalent, as in
   strncmp, but skipping ' '.
*/
static int
SWIG_TypeNameComp(const char *f1, const char *l1,
		  const char *f2, const char *l2) {
  for (;(f1 != l1) && (f2 != l2); ++f1, ++f2) {
    while ((*f1 == ' ') && (f1 != l1)) ++f1;
    while ((*f2 == ' ') && (f2 != l2)) ++f2;
    if (*f1 != *f2) return *f1 - *f2;
  }
  return (l1 - f1) - (l2 - f2);
}

/*
  Check type equivalence in a name list like <name1>|<name2>|...
*/
static int
SWIG_TypeEquiv(const char *nb, const char *tb) {
  int equiv = 0;
  const char* te = tb + strlen(tb);
  const char* ne = nb;
  while (!equiv && *ne) {
    for (nb = ne; *ne; ++ne) {
      if (*ne == '|') break;
    }
    equiv = SWIG_TypeNameComp(nb, ne, tb, te) == 0;
    if (*ne) ++ne;
  }
  return equiv;
}
  

/* Search for a swig_type_info structure */
SWIGRUNTIME(swig_type_info *)
SWIG_TypeQuery(const char *name) {
  swig_type_info *ty = *swig_type_list_handle;
  while (ty) {
    if (ty->str && (SWIG_TypeEquiv(ty->str,name))) return ty;
    if (ty->name && (strcmp(name,ty->name) == 0)) return ty;
    ty = ty->prev;
  }
  return 0;
}

/* Set the clientdata field for a type */
SWIGRUNTIME(void)
SWIG_TypeClientData(swig_type_info *ti, void *clientdata) {
  swig_type_info *tc, *equiv;
  if (ti->clientdata == clientdata) return;
  ti->clientdata = clientdata;
  equiv = ti->next;
  while (equiv) {
    if (!equiv->converter) {
      tc = *swig_type_list_handle;
      while (tc) {
        if ((strcmp(tc->name, equiv->name) == 0))
          SWIG_TypeClientData(tc,clientdata);
        tc = tc->prev;
      }
    }
    equiv = equiv->next;
  }
}

/* Pack binary data into a string */
SWIGRUNTIME(char *)
SWIG_PackData(char *c, void *ptr, int sz) {
  static char hex[17] = "0123456789abcdef";
  unsigned char *u = (unsigned char *) ptr;
  const unsigned char *eu =  u + sz;
  register unsigned char uu;
  for (; u != eu; ++u) {
    uu = *u;
    *(c++) = hex[(uu & 0xf0) >> 4];
    *(c++) = hex[uu & 0xf];
  }
  return c;
}

/* Unpack binary data from a string */
SWIGRUNTIME(char *)
SWIG_UnpackData(char *c, void *ptr, int sz) {
  register unsigned char uu = 0;
  register int d;
  unsigned char *u = (unsigned char *) ptr;
  const unsigned char *eu =  u + sz;
  for (; u != eu; ++u) {
    d = *(c++);
    if ((d >= '0') && (d <= '9'))
      uu = ((d - '0') << 4);
    else if ((d >= 'a') && (d <= 'f'))
      uu = ((d - ('a'-10)) << 4);
    d = *(c++);
    if ((d >= '0') && (d <= '9'))
      uu |= (d - '0');
    else if ((d >= 'a') && (d <= 'f'))
      uu |= (d - ('a'-10));
    *u = uu;
  }
  return c;
}

#endif

#ifdef __cplusplus
}
#endif

/* rubydec.swg -*- c -*- */
#ifdef __cplusplus
extern "C" {
#endif

SWIGIMPORT(void)   SWIG_Ruby_InitRuntime(void);
SWIGIMPORT(void)   SWIG_Ruby_define_class(swig_type_info *);
SWIGIMPORT(VALUE)  SWIG_Ruby_NewPointerObj(void *, swig_type_info *, int);
SWIGIMPORT(VALUE)  SWIG_Ruby_NewClassInstance(VALUE, swig_type_info *);
SWIGIMPORT(char *) SWIG_Ruby_MangleStr(VALUE);
SWIGIMPORT(int)    SWIG_Ruby_ConvertPtr(VALUE, void**, swig_type_info *, int);
SWIGIMPORT(void *) SWIG_Ruby_MustGetPtr(VALUE, swig_type_info *, int, int);
SWIGIMPORT(int)    SWIG_Ruby_CheckConvert(VALUE, swig_type_info *);
SWIGIMPORT(VALUE)  SWIG_Ruby_NewPackedObj(void *ptr, int sz, swig_type_info *type);
SWIGIMPORT(void)   SWIG_Ruby_ConvertPacked(VALUE obj, void *ptr, int sz, swig_type_info *ty, int flags);

#ifdef __cplusplus
}
#endif


/* -------- TYPES TABLE (BEGIN) -------- */

#define  SWIGTYPE_p_FXId swig_types[0] 
#define  SWIGTYPE_p_SCNotification swig_types[1] 
#define  SWIGTYPE_p_FXComposite swig_types[2] 
#define  SWIGTYPE_p_FXWindow swig_types[3] 
#define  SWIGTYPE_p_TextRange swig_types[4] 
#define  SWIGTYPE_p_FXDrawable swig_types[5] 
#define  SWIGTYPE_p_FXObject swig_types[6] 
#define  SWIGTYPE_p_FXScrollArea swig_types[7] 
#define  SWIGTYPE_p_NotifyHeader swig_types[8] 
#define  SWIGTYPE_p_FXScintilla swig_types[9] 
#define  SWIGTYPE_p_FXStream swig_types[10] 
static swig_type_info *swig_types[12];

/* -------- TYPES TABLE (END) -------- */

#define SWIG_init    Init_scintilla
#define SWIG_name    "Scintilla"


static void SWIG_AsVal(VALUE obj, int *val)
{
    *val = (int) NUM2INT(obj);
}


#include "FXRbCommon.h"


inline FXColor to_FXColor(VALUE obj){
  if(TYPE(obj)==T_STRING){
    return fxcolorfromname(StringValuePtr(obj));
    }
  else if(TYPE(obj)==T_SYMBOL){
    return fxcolorfromname(rb_id2name(SYM2ID(obj)));
    }
  else{
    return NUM2ULONG(obj);
    }
  }


inline FXString to_FXString(VALUE obj){
  if(!NIL_P(obj)){
    Check_Type(obj,T_STRING);
    return FXString(STR2CSTR(obj));
    }
  else{
    return FXString::null;
    }
  }


inline FXbool to_FXbool(VALUE obj){
  if (obj == Qtrue || obj == Qfalse){
    return (obj == Qtrue) ? TRUE : FALSE;
    }
  else{
    return static_cast<FXbool>(NUM2UINT(obj));
    }
  }


static swig_type_info* FXEventTypeInfo=0;

inline void* to_FXEvent(VALUE obj){
  void* ptr;
  if(!FXEventTypeInfo){
    FXEventTypeInfo=SWIG_TypeQuery("FXEvent *");
    FXASSERT(FXEventTypeInfo!=0);
    }
  SWIG_ConvertPtr(obj,&ptr,FXEventTypeInfo,1);
  return ptr;
  }


swig_class cNotifyHeader;
VALUE SCNotification_text(SCNotification const *self){
      if (self->nmhdr.code==SCN_MODIFIED){
        return (self->text) ? rb_str_new(self->text,self->length) : Qnil;
        }
      else if (self->nmhdr.code==SCN_USERLISTSELECTION || self->nmhdr.code==SCN_URIDROPPED){
        return (self->text) ? rb_str_new2(self->text) : Qnil;
      } else {
        return Qnil;
      }
    }
VALUE SCNotification_wParam(SCNotification const *self){
      return INT2NUM(self->wParam);
    }
VALUE SCNotification_lParam(SCNotification const *self){
      return INT2NUM(self->lParam);
    }

swig_class cSCNotification;
TextRange *new_TextRange(int start,int last,size_t size){
      TextRange *tr=new TextRange;
      tr->chrg.cpMin=start;
      tr->chrg.cpMax=last;
      FXMALLOC(&tr->lpstrText,char,size);
      return tr;
      }
void delete_TextRange(TextRange *self){
      FXFREE(&self->lpstrText);
      delete self;
      }

swig_class cTextRange;
static void free_TextRange(TextRange *);
FXScintilla *new_FXScintilla(FXComposite *p,FXObject *tgt,FXSelector sel,FXuint opts,FXint x,FXint y,FXint w,FXint h){
      return new FXRbScintilla(p,tgt,sel,opts,x,y,w,h);
      }
VALUE FXScintilla_sendMessage(FXScintilla *self,unsigned int iMsg,VALUE wParam,VALUE lParam){
      // Convert wParam argument
      uptr_t wp;
      switch(TYPE(wParam)){
        case T_FIXNUM:
          wp=static_cast<uptr_t>(NUM2UINT(wParam));
          break;
        case T_STRING:
          wp=static_cast<uptr_t>(reinterpret_cast<long>(RSTRING(wParam)->ptr));
          break;
        case T_TRUE:
        case T_FALSE:
          wp=(wParam==Qtrue) ? 1 : 0;
          break;
        default:
          wp=0;
          break;
        }

      // Convert lParam argument
      sptr_t lp;
      switch(TYPE(lParam)){
        case T_FIXNUM:
          lp=static_cast<sptr_t>(NUM2UINT(lParam));
          break;
        case T_STRING:
          lp=static_cast<sptr_t>(reinterpret_cast<long>(RSTRING(lParam)->ptr));
          break;
        case T_TRUE:
        case T_FALSE:
          lp=(lParam==Qtrue) ? 1 : 0;
          break;
        case T_DATA:
          lp=reinterpret_cast<sptr_t>(DATA_PTR(lParam));
          break;
        default:
          lp=0;
          break;
        }
      sptr_t result=self->sendMessage(iMsg,wp,lp);
      return INT2NUM(result); 
      }
VALUE FXScintilla_position__SWIG_1(FXScintilla const *self){
    FXint x, y;
    self->getPosition(x, y);
    VALUE pos = rb_ary_new();
    rb_ary_push(pos, INT2NUM(x));
    rb_ary_push(pos, INT2NUM(y));
    return pos;
  }

swig_class cFXScintilla;
static void free_FXScintilla(FXScintilla *);
static VALUE _wrap_NotifyHeader_idFrom_get(int argc, VALUE *argv, VALUE self) { NotifyHeader *arg1 = (NotifyHeader *) 0 ;
    unsigned int result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_NotifyHeader, 1); result = (unsigned int) ((arg1)->idFrom);
    vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_NotifyHeader_code_get(int argc, VALUE *argv, VALUE self) { NotifyHeader *arg1 = (NotifyHeader *) 0 ;
    unsigned int result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_NotifyHeader, 1); result = (unsigned int) ((arg1)->code);
    vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_SCNotification_nmhdr_get(int argc, VALUE *argv, VALUE self) { SCNotification *arg1 = (SCNotification *) 0 ;
    NotifyHeader *result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_SCNotification, 1); result = (NotifyHeader *)& ((arg1)->nmhdr);
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_NotifyHeader,0); return vresult; }
static VALUE _wrap_SCNotification_position_get(int argc, VALUE *argv, VALUE self) {
    SCNotification *arg1 = (SCNotification *) 0 ; int result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_SCNotification, 1); result = (int) ((arg1)->position);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_SCNotification_ch_get(int argc, VALUE *argv, VALUE self) { SCNotification *arg1 = (SCNotification *) 0 ;
    int result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_SCNotification, 1); result = (int) ((arg1)->ch);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_SCNotification_modifiers_get(int argc, VALUE *argv, VALUE self) {
    SCNotification *arg1 = (SCNotification *) 0 ; int result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_SCNotification, 1); result = (int) ((arg1)->modifiers);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_SCNotification_modificationType_get(int argc, VALUE *argv, VALUE self) {
    SCNotification *arg1 = (SCNotification *) 0 ; int result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_SCNotification, 1); result = (int) ((arg1)->modificationType);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_SCNotification_text(int argc, VALUE *argv, VALUE self) { SCNotification *arg1 = (SCNotification *) 0 ;
    VALUE result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_SCNotification, 1);
    result = (VALUE)SCNotification_text((SCNotification const *)arg1); vresult = result; return vresult; }
static VALUE _wrap_SCNotification_length_get(int argc, VALUE *argv, VALUE self) { SCNotification *arg1 = (SCNotification *) 0 ;
    int result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_SCNotification, 1); result = (int) ((arg1)->length);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_SCNotification_linesAdded_get(int argc, VALUE *argv, VALUE self) {
    SCNotification *arg1 = (SCNotification *) 0 ; int result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_SCNotification, 1); result = (int) ((arg1)->linesAdded);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_SCNotification_message_get(int argc, VALUE *argv, VALUE self) { SCNotification *arg1 = (SCNotification *) 0 ;
    int result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_SCNotification, 1); result = (int) ((arg1)->message);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_SCNotification_line_get(int argc, VALUE *argv, VALUE self) { SCNotification *arg1 = (SCNotification *) 0 ;
    int result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_SCNotification, 1); result = (int) ((arg1)->line);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_SCNotification_foldLevelNow_get(int argc, VALUE *argv, VALUE self) {
    SCNotification *arg1 = (SCNotification *) 0 ; int result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_SCNotification, 1); result = (int) ((arg1)->foldLevelNow);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_SCNotification_foldLevelPrev_get(int argc, VALUE *argv, VALUE self) {
    SCNotification *arg1 = (SCNotification *) 0 ; int result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_SCNotification, 1); result = (int) ((arg1)->foldLevelPrev);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_SCNotification_margin_get(int argc, VALUE *argv, VALUE self) { SCNotification *arg1 = (SCNotification *) 0 ;
    int result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_SCNotification, 1); result = (int) ((arg1)->margin);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_SCNotification_listType_get(int argc, VALUE *argv, VALUE self) {
    SCNotification *arg1 = (SCNotification *) 0 ; int result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_SCNotification, 1); result = (int) ((arg1)->listType);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_SCNotification_x_get(int argc, VALUE *argv, VALUE self) { SCNotification *arg1 = (SCNotification *) 0 ;
    int result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_SCNotification, 1); result = (int) ((arg1)->x); vresult = INT2NUM(result);
    return vresult; }
static VALUE _wrap_SCNotification_y_get(int argc, VALUE *argv, VALUE self) { SCNotification *arg1 = (SCNotification *) 0 ;
    int result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_SCNotification, 1); result = (int) ((arg1)->y); vresult = INT2NUM(result);
    return vresult; }
static VALUE _wrap_SCNotification_wParam(int argc, VALUE *argv, VALUE self) { SCNotification *arg1 = (SCNotification *) 0 ;
    VALUE result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_SCNotification, 1);
    result = (VALUE)SCNotification_wParam((SCNotification const *)arg1); vresult = result; return vresult; }
static VALUE _wrap_SCNotification_lParam(int argc, VALUE *argv, VALUE self) { SCNotification *arg1 = (SCNotification *) 0 ;
    VALUE result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_SCNotification, 1);
    result = (VALUE)SCNotification_lParam((SCNotification const *)arg1); vresult = result; return vresult; }
static VALUE _wrap_TextRange_lpstrText_get(int argc, VALUE *argv, VALUE self) { TextRange *arg1 = (TextRange *) 0 ;
    char *result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_TextRange, 1); result = (char *) ((arg1)->lpstrText);
    vresult = rb_str_new2(result); return vresult; }
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE _wrap_TextRange_allocate(VALUE self) {
#else
     static VALUE _wrap_TextRange_allocate(int argc, VALUE *argv, VALUE self) {
#endif
         VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_TextRange);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
         return vresult; }
static VALUE _wrap_new_TextRange(int argc, VALUE *argv, VALUE self) { int arg1 ; int arg2 ; size_t arg3 ; TextRange *result;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc); arg1 = NUM2INT(argv[0]);
    arg2 = NUM2INT(argv[1]); arg3 = NUM2LONG(argv[2]); result = (TextRange *)new_TextRange(arg1,arg2,arg3);
    DATA_PTR(self) = result; return self; }
static void
free_TextRange(TextRange *arg1) {
    delete_TextRange(arg1);
}
static VALUE _wrap_FXScintilla_onScintillaCommand(int argc, VALUE *argv, VALUE self) { FXScintilla *arg1 = (FXScintilla *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScintilla, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onScintillaCommand(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXScintilla_onPaint(int argc, VALUE *argv, VALUE self) { FXScintilla *arg1 = (FXScintilla *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScintilla, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onPaint(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXScintilla_onConfigure(int argc, VALUE *argv, VALUE self) { FXScintilla *arg1 = (FXScintilla *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScintilla, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onConfigure(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXScintilla_onTimeoutTicking(int argc, VALUE *argv, VALUE self) { FXScintilla *arg1 = (FXScintilla *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScintilla, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onTimeoutTicking(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXScintilla_onFocusIn(int argc, VALUE *argv, VALUE self) { FXScintilla *arg1 = (FXScintilla *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScintilla, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onFocusIn(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXScintilla_onFocusOut(int argc, VALUE *argv, VALUE self) { FXScintilla *arg1 = (FXScintilla *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScintilla, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onFocusOut(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXScintilla_onMotion(int argc, VALUE *argv, VALUE self) { FXScintilla *arg1 = (FXScintilla *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScintilla, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onMotion(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXScintilla_onLeftBtnPress(int argc, VALUE *argv, VALUE self) { FXScintilla *arg1 = (FXScintilla *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScintilla, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onLeftBtnPress(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXScintilla_onLeftBtnRelease(int argc, VALUE *argv, VALUE self) { FXScintilla *arg1 = (FXScintilla *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScintilla, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onLeftBtnRelease(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXScintilla_onRightBtnPress(int argc, VALUE *argv, VALUE self) { FXScintilla *arg1 = (FXScintilla *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScintilla, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onRightBtnPress(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXScintilla_onMiddleBtnPress(int argc, VALUE *argv, VALUE self) { FXScintilla *arg1 = (FXScintilla *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScintilla, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onMiddleBtnPress(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXScintilla_onBeginDrag(int argc, VALUE *argv, VALUE self) { FXScintilla *arg1 = (FXScintilla *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScintilla, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onBeginDrag(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXScintilla_onDragged(int argc, VALUE *argv, VALUE self) { FXScintilla *arg1 = (FXScintilla *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScintilla, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onDragged(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXScintilla_onEndDrag(int argc, VALUE *argv, VALUE self) { FXScintilla *arg1 = (FXScintilla *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScintilla, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onEndDrag(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXScintilla_onDNDEnter(int argc, VALUE *argv, VALUE self) { FXScintilla *arg1 = (FXScintilla *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScintilla, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onDNDEnter(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXScintilla_onDNDLeave(int argc, VALUE *argv, VALUE self) { FXScintilla *arg1 = (FXScintilla *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScintilla, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onDNDLeave(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXScintilla_onDNDMotion(int argc, VALUE *argv, VALUE self) { FXScintilla *arg1 = (FXScintilla *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScintilla, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onDNDMotion(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXScintilla_onDNDDrop(int argc, VALUE *argv, VALUE self) { FXScintilla *arg1 = (FXScintilla *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScintilla, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onDNDDrop(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXScintilla_onDNDRequest(int argc, VALUE *argv, VALUE self) { FXScintilla *arg1 = (FXScintilla *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScintilla, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onDNDRequest(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXScintilla_onSelectionLost(int argc, VALUE *argv, VALUE self) { FXScintilla *arg1 = (FXScintilla *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScintilla, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onSelectionLost(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXScintilla_onSelectionRequest(int argc, VALUE *argv, VALUE self) { FXScintilla *arg1 = (FXScintilla *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScintilla, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onSelectionRequest(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXScintilla_onClipboardLost(int argc, VALUE *argv, VALUE self) { FXScintilla *arg1 = (FXScintilla *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScintilla, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onClipboardLost(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXScintilla_onClipboardRequest(int argc, VALUE *argv, VALUE self) { FXScintilla *arg1 = (FXScintilla *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScintilla, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onClipboardRequest(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXScintilla_onKeyPress(int argc, VALUE *argv, VALUE self) { FXScintilla *arg1 = (FXScintilla *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScintilla, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onKeyPress(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE _wrap_FXScintilla_allocate(VALUE self) {
#else
     static VALUE _wrap_FXScintilla_allocate(int argc, VALUE *argv, VALUE self) {
#endif
         VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_FXScintilla);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
         return vresult; }
static VALUE _wrap_new_FXScintilla(int argc, VALUE *argv, VALUE self) { FXComposite *arg1 = (FXComposite *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 = (FXSelector) 0 ; FXuint arg4 = (FXuint) 0 ; FXint arg5 = (FXint) 0 ;
    FXint arg6 = (FXint) 0 ; FXint arg7 = (FXint) 0 ; FXint arg8 = (FXint) 0 ; FXScintilla *result;
    if ((argc < 1) || (argc > 8)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXComposite, 1); if (argc > 1) {
        SWIG_ConvertPtr(argv[1], (void **) &arg2, SWIGTYPE_p_FXObject, 1); }  if (argc > 2) { arg3 = NUM2UINT(argv[2]); } 
    if (argc > 3) { arg4 = NUM2UINT(argv[3]); }  if (argc > 4) { arg5 = NUM2INT(argv[4]); }  if (argc > 5) {
        arg6 = NUM2INT(argv[5]); }  if (argc > 6) { arg7 = NUM2INT(argv[6]); }  if (argc > 7) { arg8 = NUM2INT(argv[7]); }  {
        result = (FXScintilla *)new_FXScintilla(arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8);
        DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result); if(rb_block_given_p()){ rb_yield(self); }  }  return self; }
static VALUE _wrap_FXScintilla_setScintillaID(int argc, VALUE *argv, VALUE self) { FXScintilla *arg1 = (FXScintilla *) 0 ;
    int arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScintilla, 1); arg2 = NUM2INT(argv[0]); (arg1)->setScintillaID(arg2);
    return Qnil; }
static VALUE _wrap_FXScintilla_sendMessage(int argc, VALUE *argv, VALUE self) { FXScintilla *arg1 = (FXScintilla *) 0 ;
    unsigned int arg2 ; VALUE arg3 = (VALUE) Qnil ; VALUE arg4 = (VALUE) Qnil ; VALUE result; VALUE vresult = Qnil;
    if ((argc < 1) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScintilla, 1); arg2 = NUM2UINT(argv[0]); if (argc > 1) {
        arg3 = argv[1]; }  if (argc > 2) { arg4 = argv[2]; }  result = (VALUE)FXScintilla_sendMessage(arg1,arg2,arg3,arg4);
    vresult = result; return vresult; }
static void
free_FXScintilla(FXScintilla *arg1) {
    delete arg1;
}
static VALUE _wrap_FXScintilla_save(int argc, VALUE *argv, VALUE self) { FXScintilla *arg1 = (FXScintilla *) 0 ;
    FXStream *arg2 = 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScintilla, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXScintilla_save((FXScintilla const *)arg1,*arg2); return Qnil; }
static VALUE _wrap_FXScintilla_load(int argc, VALUE *argv, VALUE self) { FXScintilla *arg1 = (FXScintilla *) 0 ;
    FXStream *arg2 = 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScintilla, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXScintilla_load(arg1,*arg2); return Qnil; }
static VALUE _wrap_FXScintilla_create(int argc, VALUE *argv, VALUE self) { FXScintilla *arg1 = (FXScintilla *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScintilla, 1); FXScintilla_create(arg1); return Qnil; }
static VALUE _wrap_FXScintilla_detach(int argc, VALUE *argv, VALUE self) { FXScintilla *arg1 = (FXScintilla *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScintilla, 1); FXScintilla_detach(arg1); return Qnil; }
static VALUE _wrap_FXScintilla_destroy(int argc, VALUE *argv, VALUE self) { FXScintilla *arg1 = (FXScintilla *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScintilla, 1); FXScintilla_destroy(arg1); return Qnil; }
static VALUE _wrap_FXScintilla_resize(int argc, VALUE *argv, VALUE self) { FXScintilla *arg1 = (FXScintilla *) 0 ; FXint arg2 ;
    FXint arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScintilla, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    FXScintilla_resize(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXScintilla_getDefaultWidth(int argc, VALUE *argv, VALUE self) { FXScintilla *arg1 = (FXScintilla *) 0 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScintilla, 1); result = (FXint)FXScintilla_getDefaultWidth(arg1);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXScintilla_getDefaultHeight(int argc, VALUE *argv, VALUE self) { FXScintilla *arg1 = (FXScintilla *) 0 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScintilla, 1); result = (FXint)FXScintilla_getDefaultHeight(arg1);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXScintilla_getWidthForHeight(int argc, VALUE *argv, VALUE self) { FXScintilla *arg1 = (FXScintilla *) 0 ;
    FXint arg2 ; FXint result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScintilla, 1); arg2 = NUM2INT(argv[0]);
    result = (FXint)FXScintilla_getWidthForHeight(arg1,arg2); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXScintilla_getHeightForWidth(int argc, VALUE *argv, VALUE self) { FXScintilla *arg1 = (FXScintilla *) 0 ;
    FXint arg2 ; FXint result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScintilla, 1); arg2 = NUM2INT(argv[0]);
    result = (FXint)FXScintilla_getHeightForWidth(arg1,arg2); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXScintilla_canFocus(int argc, VALUE *argv, VALUE self) { FXScintilla *arg1 = (FXScintilla *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScintilla, 1);
    result = (FXbool)FXScintilla_canFocus((FXScintilla const *)arg1); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXScintilla_setFocus(int argc, VALUE *argv, VALUE self) { FXScintilla *arg1 = (FXScintilla *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScintilla, 1); FXScintilla_setFocus(arg1); return Qnil; }
static VALUE _wrap_FXScintilla_killFocus(int argc, VALUE *argv, VALUE self) { FXScintilla *arg1 = (FXScintilla *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScintilla, 1); FXScintilla_killFocus(arg1); return Qnil; }
static VALUE _wrap_FXScintilla_setDefault(int argc, VALUE *argv, VALUE self) { FXScintilla *arg1 = (FXScintilla *) 0 ;
    FXbool arg2 = (FXbool) 1 ; if ((argc < 0) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScintilla, 1); if (argc > 0) { arg2 = to_FXbool(argv[0]); } 
    FXScintilla_setDefault(arg1,arg2); return Qnil; }
static VALUE _wrap_FXScintilla_enable(int argc, VALUE *argv, VALUE self) { FXScintilla *arg1 = (FXScintilla *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScintilla, 1); FXScintilla_enable(arg1); return Qnil; }
static VALUE _wrap_FXScintilla_disable(int argc, VALUE *argv, VALUE self) { FXScintilla *arg1 = (FXScintilla *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScintilla, 1); FXScintilla_disable(arg1); return Qnil; }
static VALUE _wrap_FXScintilla_raiseWindow(int argc, VALUE *argv, VALUE self) { FXScintilla *arg1 = (FXScintilla *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScintilla, 1); FXScintilla_raise(arg1); return Qnil; }
static VALUE _wrap_FXScintilla_lower(int argc, VALUE *argv, VALUE self) { FXScintilla *arg1 = (FXScintilla *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScintilla, 1); FXScintilla_lower(arg1); return Qnil; }
static VALUE _wrap_FXScintilla_move(int argc, VALUE *argv, VALUE self) { FXScintilla *arg1 = (FXScintilla *) 0 ; FXint arg2 ;
    FXint arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScintilla, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    FXScintilla_move(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXScintilla_position__SWIG_0(int argc, VALUE *argv, VALUE self) { FXScintilla *arg1 = (FXScintilla *) 0 ;
    FXint arg2 ; FXint arg3 ; FXint arg4 ; FXint arg5 ; if ((argc < 4) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScintilla, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    arg4 = NUM2INT(argv[2]); arg5 = NUM2INT(argv[3]); FXScintilla_position(arg1,arg2,arg3,arg4,arg5); return Qnil; }
static VALUE _wrap_FXScintilla_layout(int argc, VALUE *argv, VALUE self) { FXScintilla *arg1 = (FXScintilla *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScintilla, 1); FXScintilla_layout(arg1); return Qnil; }
static VALUE _wrap_FXScintilla_recalc(int argc, VALUE *argv, VALUE self) { FXScintilla *arg1 = (FXScintilla *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScintilla, 1); FXScintilla_recalc(arg1); return Qnil; }
static VALUE _wrap_FXScintilla_reparent(int argc, VALUE *argv, VALUE self) { FXScintilla *arg1 = (FXScintilla *) 0 ;
    FXComposite *arg2 = (FXComposite *) 0 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScintilla, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXComposite, 1); FXScintilla_reparent(arg1,arg2); return Qnil; }
static VALUE _wrap_FXScintilla_show(int argc, VALUE *argv, VALUE self) { FXScintilla *arg1 = (FXScintilla *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScintilla, 1); FXScintilla_show(arg1); return Qnil; }
static VALUE _wrap_FXScintilla_hide(int argc, VALUE *argv, VALUE self) { FXScintilla *arg1 = (FXScintilla *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScintilla, 1); FXScintilla_hide(arg1); return Qnil; }
static VALUE _wrap_FXScintilla_isComposite(int argc, VALUE *argv, VALUE self) { FXScintilla *arg1 = (FXScintilla *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScintilla, 1);
    result = (FXbool)FXScintilla_isComposite((FXScintilla const *)arg1); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXScintilla_contains(int argc, VALUE *argv, VALUE self) { FXScintilla *arg1 = (FXScintilla *) 0 ;
    FXint arg2 ; FXint arg3 ; FXbool result; VALUE vresult = Qnil; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScintilla, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    result = (FXbool)FXScintilla_contains((FXScintilla const *)arg1,arg2,arg3); vresult = result ? Qtrue : Qfalse;
    return vresult; }
static VALUE _wrap_FXScintilla_doesSaveUnder(int argc, VALUE *argv, VALUE self) { FXScintilla *arg1 = (FXScintilla *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScintilla, 1);
    result = (FXbool)FXScintilla_doesSaveUnder((FXScintilla const *)arg1); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXScintilla_setBackColor(int argc, VALUE *argv, VALUE self) { FXScintilla *arg1 = (FXScintilla *) 0 ;
    FXColor arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScintilla, 1); arg2 = to_FXColor(argv[0]);
    FXScintilla_setBackColor(arg1,arg2); return Qnil; }
static VALUE _wrap_FXScintilla_getViewportHeight(int argc, VALUE *argv, VALUE self) { FXScintilla *arg1 = (FXScintilla *) 0 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScintilla, 1); result = (FXint)FXScintilla_getViewportHeight(arg1);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXScintilla_getViewportWidth(int argc, VALUE *argv, VALUE self) { FXScintilla *arg1 = (FXScintilla *) 0 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScintilla, 1); result = (FXint)FXScintilla_getViewportWidth(arg1);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXScintilla_getContentHeight(int argc, VALUE *argv, VALUE self) { FXScintilla *arg1 = (FXScintilla *) 0 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScintilla, 1); result = (FXint)FXScintilla_getContentHeight(arg1);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXScintilla_getContentWidth(int argc, VALUE *argv, VALUE self) { FXScintilla *arg1 = (FXScintilla *) 0 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScintilla, 1); result = (FXint)FXScintilla_getContentWidth(arg1);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXScintilla_position__SWIG_1(int argc, VALUE *argv, VALUE self) { FXScintilla *arg1 = (FXScintilla *) 0 ;
    VALUE result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScintilla, 1);
    result = (VALUE)FXScintilla_position__SWIG_1((FXScintilla const *)arg1); vresult = result; return vresult; }
static VALUE _wrap_FXScintilla_position(int nargs, VALUE *args, VALUE self) { int argc; VALUE argv[6]; int ii; argc = nargs + 1;
    argv[0] = self; for (ii = 1; (ii < argc) && (ii < 5); ii++) { argv[ii] = args[ii-1]; }  if (argc == 1) { int _v; {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXScintilla, 0) != -1)) ? 1 : 0; }
         if (_v) { return _wrap_FXScintilla_position__SWIG_1(nargs, args, self);}  }  if (argc == 5) { int _v; { void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXScintilla, 0) != -1)) ? 1 : 0; }
         if (_v) { { _v = ((TYPE(argv[1]) == T_FIXNUM) || (TYPE(argv[1]) == T_BIGNUM)) ? 1 : 0; }  if (_v) { {
                    _v = ((TYPE(argv[2]) == T_FIXNUM) || (TYPE(argv[2]) == T_BIGNUM)) ? 1 : 0; }  if (_v) { {
                        _v = ((TYPE(argv[3]) == T_FIXNUM) || (TYPE(argv[3]) == T_BIGNUM)) ? 1 : 0; }  if (_v) { {
                            _v = ((TYPE(argv[4]) == T_FIXNUM) || (TYPE(argv[4]) == T_BIGNUM)) ? 1 : 0; }  if (_v) {
                            return _wrap_FXScintilla_position__SWIG_0(nargs, args, self);}  }  }  }  }  } 
    rb_raise(rb_eArgError, "No matching function for overloaded 'FXScintilla_position'"); return Qnil; }

/* -------- TYPE CONVERSION AND EQUIVALENCE RULES (BEGIN) -------- */

static void *_p_FXDriveBoxTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXPacker *)(FXListBox *) ((FXDriveBox *) x));
}
static void *_p_FXToolBarTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXPacker *) ((FXToolBar *) x));
}
static void *_p_FXToolTipTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXShell *) ((FXToolTip *) x));
}
static void *_p_FXTabBookTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXPacker *)(FXTabBar *) ((FXTabBook *) x));
}
static void *_p_FXGroupBoxTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXPacker *) ((FXGroupBox *) x));
}
static void *_p_FXShellTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *)  ((FXShell *) x));
}
static void *_p_FXStatusBarTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXPacker *)(FXHorizontalFrame *) ((FXStatusBar *) x));
}
static void *_p_FXScrollAreaTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *)  ((FXScrollArea *) x));
}
static void *_p_FXPopupTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXShell *) ((FXPopup *) x));
}
static void *_p_FXScrollWindowTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXScrollArea *) ((FXScrollWindow *) x));
}
static void *_p_FXRootWindowTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *)  ((FXRootWindow *) x));
}
static void *_p_FXTopWindowTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXShell *) ((FXTopWindow *) x));
}
static void *_p_FXMainWindowTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXShell *)(FXTopWindow *) ((FXMainWindow *) x));
}
static void *_p_FXComboBoxTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXPacker *) ((FXComboBox *) x));
}
static void *_p_FXScintillaTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXScrollArea *) ((FXScintilla *) x));
}
static void *_p_FXHorizontalFrameTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXPacker *) ((FXHorizontalFrame *) x));
}
static void *_p_FXVerticalFrameTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXPacker *) ((FXVerticalFrame *) x));
}
static void *_p_FX4SplitterTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *)  ((FX4Splitter *) x));
}
static void *_p_FXSplitterTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *)  ((FXSplitter *) x));
}
static void *_p_FXRealSpinnerTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXPacker *) ((FXRealSpinner *) x));
}
static void *_p_FXSpinnerTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXPacker *) ((FXSpinner *) x));
}
static void *_p_FXPackerTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *)  ((FXPacker *) x));
}
static void *_p_FXDirBoxTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXPacker *)(FXTreeListBox *) ((FXDirBox *) x));
}
static void *_p_FXSwitcherTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXPacker *) ((FXSwitcher *) x));
}
static void *_p_FXColorSelectorTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXPacker *) ((FXColorSelector *) x));
}
static void *_p_FXFileSelectorTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXPacker *) ((FXFileSelector *) x));
}
static void *_p_FXDirSelectorTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXPacker *) ((FXDirSelector *) x));
}
static void *_p_FXFontSelectorTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXPacker *) ((FXFontSelector *) x));
}
static void *_p_FXShutterTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXPacker *)(FXVerticalFrame *) ((FXShutter *) x));
}
static void *_p_FXTreeListBoxTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXPacker *) ((FXTreeListBox *) x));
}
static void *_p_FXListBoxTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXPacker *) ((FXListBox *) x));
}
static void *_p_FXMatrixTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXPacker *) ((FXMatrix *) x));
}
static void *_p_FXShutterItemTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXPacker *)(FXVerticalFrame *) ((FXShutterItem *) x));
}
static void *_p_FXTabBarTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXPacker *) ((FXTabBar *) x));
}
static void *_p_FXImageViewTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXScrollArea *) ((FXImageView *) x));
}
static void *_p_FXSpringTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXPacker *) ((FXSpring *) x));
}
static void *_p_FXToolBarShellTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXShell *)(FXTopWindow *) ((FXToolBarShell *) x));
}
static void *_p_FXDriveBoxTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *)(FXListBox *) ((FXDriveBox *) x));
}
static void *_p_FXToolBarTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXToolBar *) x));
}
static void *_p_FXCompositeTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *) ((FXComposite *) x));
}
static void *_p_FXToolTipTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXShell *) ((FXToolTip *) x));
}
static void *_p_FXTextFieldTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXFrame *) ((FXTextField *) x));
}
static void *_p_FXTabBookTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *)(FXTabBar *) ((FXTabBook *) x));
}
static void *_p_FXArrowButtonTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXFrame *) ((FXArrowButton *) x));
}
static void *_p_FXGroupBoxTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXGroupBox *) x));
}
static void *_p_FXShellTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *) ((FXShell *) x));
}
static void *_p_FXStatusBarTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *)(FXHorizontalFrame *) ((FXStatusBar *) x));
}
static void *_p_FXScrollAreaTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *) ((FXScrollArea *) x));
}
static void *_p_FXPopupTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXShell *) ((FXPopup *) x));
}
static void *_p_FXScrollWindowTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXScrollArea *) ((FXScrollWindow *) x));
}
static void *_p_FXWindowTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *) ((FXWindow *) x));
}
static void *_p_FXRootWindowTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *) ((FXRootWindow *) x));
}
static void *_p_FXTopWindowTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXShell *) ((FXTopWindow *) x));
}
static void *_p_FXMainWindowTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXShell *)(FXTopWindow *) ((FXMainWindow *) x));
}
static void *_p_FXRulerTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXFrame *) ((FXRuler *) x));
}
static void *_p_FXCanvasTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *) ((FXCanvas *) x));
}
static void *_p_FXScrollCornerTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *) ((FXScrollCorner *) x));
}
static void *_p_FXSeparatorTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXFrame *) ((FXSeparator *) x));
}
static void *_p_FXHorizontalSeparatorTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXFrame *)(FXSeparator *) ((FXHorizontalSeparator *) x));
}
static void *_p_FXVerticalSeparatorTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXFrame *)(FXSeparator *) ((FXVerticalSeparator *) x));
}
static void *_p_FXStatusLineTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXFrame *) ((FXStatusLine *) x));
}
static void *_p_FXComboBoxTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXComboBox *) x));
}
static void *_p_FXScintillaTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXScrollArea *) ((FXScintilla *) x));
}
static void *_p_FXVerticalFrameTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXVerticalFrame *) x));
}
static void *_p_FXHorizontalFrameTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXHorizontalFrame *) x));
}
static void *_p_FX4SplitterTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *) ((FX4Splitter *) x));
}
static void *_p_FXSplitterTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *) ((FXSplitter *) x));
}
static void *_p_FXPackerTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *) ((FXPacker *) x));
}
static void *_p_FXSpinnerTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXSpinner *) x));
}
static void *_p_FXRealSpinnerTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXRealSpinner *) x));
}
static void *_p_FXScrollBarTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *) ((FXScrollBar *) x));
}
static void *_p_FXColorWheelTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXFrame *) ((FXColorWheel *) x));
}
static void *_p_FXBitmapFrameTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXFrame *) ((FXBitmapFrame *) x));
}
static void *_p_FXFontTo_p_FXId(void *x) {
    return (void *)((FXId *)  ((FXFont *) x));
}
static void *_p_FXDirBoxTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *)(FXTreeListBox *) ((FXDirBox *) x));
}
static void *_p_FXToolBarGripTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *) ((FXToolBarGrip *) x));
}
static void *_p_FXImageFrameTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXFrame *) ((FXImageFrame *) x));
}
static void *_p_FXDragCornerTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *) ((FXDragCorner *) x));
}
static void *_p_FXSwitcherTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXSwitcher *) x));
}
static void *_p_FXDirSelectorTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXDirSelector *) x));
}
static void *_p_FXFileSelectorTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXFileSelector *) x));
}
static void *_p_FXColorSelectorTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXColorSelector *) x));
}
static void *_p_FXFontSelectorTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXFontSelector *) x));
}
static void *_p_FXShutterTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *)(FXVerticalFrame *) ((FXShutter *) x));
}
static void *_p_FXDrawableTo_p_FXId(void *x) {
    return (void *)((FXId *)  ((FXDrawable *) x));
}
static void *_p_FXCursorTo_p_FXId(void *x) {
    return (void *)((FXId *)  ((FXCursor *) x));
}
static void *_p_FXCURCursorTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXCursor *) ((FXCURCursor *) x));
}
static void *_p_FXGIFCursorTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXCursor *) ((FXGIFCursor *) x));
}
static void *_p_FXProgressBarTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXFrame *) ((FXProgressBar *) x));
}
static void *_p_FXListBoxTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXListBox *) x));
}
static void *_p_FXTreeListBoxTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXTreeListBox *) x));
}
static void *_p_FXHeaderTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXFrame *) ((FXHeader *) x));
}
static void *_p_FXMatrixTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXMatrix *) x));
}
static void *_p_FXColorWellTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXFrame *) ((FXColorWell *) x));
}
static void *_p_FXShutterItemTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *)(FXVerticalFrame *) ((FXShutterItem *) x));
}
static void *_p_FXDialTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXFrame *) ((FXDial *) x));
}
static void *_p_FXToolBarTabTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXFrame *) ((FXToolBarTab *) x));
}
static void *_p_FXFrameTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *) ((FXFrame *) x));
}
static void *_p_FXTabBarTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXTabBar *) x));
}
static void *_p_FXImageViewTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXScrollArea *) ((FXImageView *) x));
}
static void *_p_FXSliderTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXFrame *) ((FXSlider *) x));
}
static void *_p_FXRealSliderTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXFrame *) ((FXRealSlider *) x));
}
static void *_p_FXSpringTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXSpring *) x));
}
static void *_p_FXVisualTo_p_FXId(void *x) {
    return (void *)((FXId *)  ((FXVisual *) x));
}
static void *_p_FXColorBarTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXFrame *) ((FXColorBar *) x));
}
static void *_p_FXToolBarShellTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXShell *)(FXTopWindow *) ((FXToolBarShell *) x));
}
static void *_p_FXDriveBoxTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXPacker *)(FXListBox *) ((FXDriveBox *) x));
}
static void *_p_FXToolBarTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXPacker *) ((FXToolBar *) x));
}
static void *_p_FXCompositeTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *)  ((FXComposite *) x));
}
static void *_p_FXToolTipTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXShell *) ((FXToolTip *) x));
}
static void *_p_FXTextFieldTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXFrame *) ((FXTextField *) x));
}
static void *_p_FXTabBookTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXPacker *)(FXTabBar *) ((FXTabBook *) x));
}
static void *_p_FXArrowButtonTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXFrame *) ((FXArrowButton *) x));
}
static void *_p_FXGroupBoxTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXPacker *) ((FXGroupBox *) x));
}
static void *_p_FXShellTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *) ((FXShell *) x));
}
static void *_p_FXStatusBarTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXPacker *)(FXHorizontalFrame *) ((FXStatusBar *) x));
}
static void *_p_FXScrollAreaTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *) ((FXScrollArea *) x));
}
static void *_p_FXPopupTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXShell *) ((FXPopup *) x));
}
static void *_p_FXScrollWindowTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXScrollArea *) ((FXScrollWindow *) x));
}
static void *_p_FXRootWindowTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *) ((FXRootWindow *) x));
}
static void *_p_FXTopWindowTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXShell *) ((FXTopWindow *) x));
}
static void *_p_FXMainWindowTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXShell *)(FXTopWindow *) ((FXMainWindow *) x));
}
static void *_p_FXRulerTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXFrame *) ((FXRuler *) x));
}
static void *_p_FXCanvasTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *)  ((FXCanvas *) x));
}
static void *_p_FXScrollCornerTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *)  ((FXScrollCorner *) x));
}
static void *_p_FXVerticalSeparatorTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXFrame *)(FXSeparator *) ((FXVerticalSeparator *) x));
}
static void *_p_FXHorizontalSeparatorTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXFrame *)(FXSeparator *) ((FXHorizontalSeparator *) x));
}
static void *_p_FXSeparatorTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXFrame *) ((FXSeparator *) x));
}
static void *_p_FXStatusLineTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXFrame *) ((FXStatusLine *) x));
}
static void *_p_FXComboBoxTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXPacker *) ((FXComboBox *) x));
}
static void *_p_FXScintillaTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXScrollArea *) ((FXScintilla *) x));
}
static void *_p_FXHorizontalFrameTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXPacker *) ((FXHorizontalFrame *) x));
}
static void *_p_FXVerticalFrameTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXPacker *) ((FXVerticalFrame *) x));
}
static void *_p_FX4SplitterTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *) ((FX4Splitter *) x));
}
static void *_p_FXSplitterTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *) ((FXSplitter *) x));
}
static void *_p_FXPackerTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *) ((FXPacker *) x));
}
static void *_p_FXSpinnerTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXPacker *) ((FXSpinner *) x));
}
static void *_p_FXRealSpinnerTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXPacker *) ((FXRealSpinner *) x));
}
static void *_p_FXScrollBarTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *)  ((FXScrollBar *) x));
}
static void *_p_FXColorWheelTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXFrame *) ((FXColorWheel *) x));
}
static void *_p_FXBitmapFrameTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXFrame *) ((FXBitmapFrame *) x));
}
static void *_p_FXDirBoxTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXPacker *)(FXTreeListBox *) ((FXDirBox *) x));
}
static void *_p_FXToolBarGripTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *)  ((FXToolBarGrip *) x));
}
static void *_p_FXImageFrameTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXFrame *) ((FXImageFrame *) x));
}
static void *_p_FXDragCornerTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *)  ((FXDragCorner *) x));
}
static void *_p_FXSwitcherTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXPacker *) ((FXSwitcher *) x));
}
static void *_p_FXDirSelectorTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXPacker *) ((FXDirSelector *) x));
}
static void *_p_FXFileSelectorTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXPacker *) ((FXFileSelector *) x));
}
static void *_p_FXColorSelectorTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXPacker *) ((FXColorSelector *) x));
}
static void *_p_FXFontSelectorTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXPacker *) ((FXFontSelector *) x));
}
static void *_p_FXShutterTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXPacker *)(FXVerticalFrame *) ((FXShutter *) x));
}
static void *_p_FXProgressBarTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXFrame *) ((FXProgressBar *) x));
}
static void *_p_FXListBoxTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXPacker *) ((FXListBox *) x));
}
static void *_p_FXTreeListBoxTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXPacker *) ((FXTreeListBox *) x));
}
static void *_p_FXHeaderTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXFrame *) ((FXHeader *) x));
}
static void *_p_FXMatrixTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXPacker *) ((FXMatrix *) x));
}
static void *_p_FXColorWellTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXFrame *) ((FXColorWell *) x));
}
static void *_p_FXShutterItemTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXPacker *)(FXVerticalFrame *) ((FXShutterItem *) x));
}
static void *_p_FXDialTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXFrame *) ((FXDial *) x));
}
static void *_p_FXToolBarTabTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXFrame *) ((FXToolBarTab *) x));
}
static void *_p_FXFrameTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *)  ((FXFrame *) x));
}
static void *_p_FXTabBarTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXPacker *) ((FXTabBar *) x));
}
static void *_p_FXImageViewTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXScrollArea *) ((FXImageView *) x));
}
static void *_p_FXSliderTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXFrame *) ((FXSlider *) x));
}
static void *_p_FXRealSliderTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXFrame *) ((FXRealSlider *) x));
}
static void *_p_FXSpringTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXPacker *) ((FXSpring *) x));
}
static void *_p_FXColorBarTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXFrame *) ((FXColorBar *) x));
}
static void *_p_FXToolBarShellTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXShell *)(FXTopWindow *) ((FXToolBarShell *) x));
}
static void *_p_FXDriveBoxTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *)(FXListBox *) ((FXDriveBox *) x));
}
static void *_p_FXToolBarTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *) ((FXToolBar *) x));
}
static void *_p_FXCompositeTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *) ((FXComposite *) x));
}
static void *_p_FXToolTipTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXShell *) ((FXToolTip *) x));
}
static void *_p_FXTextFieldTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXFrame *) ((FXTextField *) x));
}
static void *_p_FXTabBookTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *)(FXTabBar *) ((FXTabBook *) x));
}
static void *_p_FXArrowButtonTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXFrame *) ((FXArrowButton *) x));
}
static void *_p_FXGroupBoxTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *) ((FXGroupBox *) x));
}
static void *_p_FXShellTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *) ((FXShell *) x));
}
static void *_p_FXStatusBarTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *)(FXHorizontalFrame *) ((FXStatusBar *) x));
}
static void *_p_FXScrollAreaTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *) ((FXScrollArea *) x));
}
static void *_p_FXPopupTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXShell *) ((FXPopup *) x));
}
static void *_p_FXScrollWindowTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXScrollArea *) ((FXScrollWindow *) x));
}
static void *_p_FXWindowTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *)  ((FXWindow *) x));
}
static void *_p_FXRootWindowTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *) ((FXRootWindow *) x));
}
static void *_p_FXTopWindowTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXShell *) ((FXTopWindow *) x));
}
static void *_p_FXMainWindowTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXShell *)(FXTopWindow *) ((FXMainWindow *) x));
}
static void *_p_FXRulerTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXFrame *) ((FXRuler *) x));
}
static void *_p_FXCanvasTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *) ((FXCanvas *) x));
}
static void *_p_FXScrollCornerTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *) ((FXScrollCorner *) x));
}
static void *_p_FXHorizontalSeparatorTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXFrame *)(FXSeparator *) ((FXHorizontalSeparator *) x));
}
static void *_p_FXSeparatorTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXFrame *) ((FXSeparator *) x));
}
static void *_p_FXVerticalSeparatorTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXFrame *)(FXSeparator *) ((FXVerticalSeparator *) x));
}
static void *_p_FXStatusLineTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXFrame *) ((FXStatusLine *) x));
}
static void *_p_FXComboBoxTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *) ((FXComboBox *) x));
}
static void *_p_FXScintillaTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXScrollArea *) ((FXScintilla *) x));
}
static void *_p_FXHorizontalFrameTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *) ((FXHorizontalFrame *) x));
}
static void *_p_FXVerticalFrameTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *) ((FXVerticalFrame *) x));
}
static void *_p_FX4SplitterTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *) ((FX4Splitter *) x));
}
static void *_p_FXSplitterTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *) ((FXSplitter *) x));
}
static void *_p_FXPackerTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *) ((FXPacker *) x));
}
static void *_p_FXSpinnerTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *) ((FXSpinner *) x));
}
static void *_p_FXRealSpinnerTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *) ((FXRealSpinner *) x));
}
static void *_p_FXScrollBarTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *) ((FXScrollBar *) x));
}
static void *_p_FXColorWheelTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXFrame *) ((FXColorWheel *) x));
}
static void *_p_FXBitmapFrameTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXFrame *) ((FXBitmapFrame *) x));
}
static void *_p_FXDirBoxTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *)(FXTreeListBox *) ((FXDirBox *) x));
}
static void *_p_FXToolBarGripTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *) ((FXToolBarGrip *) x));
}
static void *_p_FXImageFrameTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXFrame *) ((FXImageFrame *) x));
}
static void *_p_FXDragCornerTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *) ((FXDragCorner *) x));
}
static void *_p_FXSwitcherTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *) ((FXSwitcher *) x));
}
static void *_p_FXDirSelectorTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *) ((FXDirSelector *) x));
}
static void *_p_FXFileSelectorTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *) ((FXFileSelector *) x));
}
static void *_p_FXColorSelectorTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *) ((FXColorSelector *) x));
}
static void *_p_FXFontSelectorTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *) ((FXFontSelector *) x));
}
static void *_p_FXShutterTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *)(FXVerticalFrame *) ((FXShutter *) x));
}
static void *_p_FXProgressBarTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXFrame *) ((FXProgressBar *) x));
}
static void *_p_FXListBoxTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *) ((FXListBox *) x));
}
static void *_p_FXTreeListBoxTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *) ((FXTreeListBox *) x));
}
static void *_p_FXHeaderTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXFrame *) ((FXHeader *) x));
}
static void *_p_FXMatrixTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *) ((FXMatrix *) x));
}
static void *_p_FXColorWellTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXFrame *) ((FXColorWell *) x));
}
static void *_p_FXShutterItemTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *)(FXVerticalFrame *) ((FXShutterItem *) x));
}
static void *_p_FXDialTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXFrame *) ((FXDial *) x));
}
static void *_p_FXToolBarTabTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXFrame *) ((FXToolBarTab *) x));
}
static void *_p_FXFrameTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *) ((FXFrame *) x));
}
static void *_p_FXTabBarTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *) ((FXTabBar *) x));
}
static void *_p_FXImageViewTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXScrollArea *) ((FXImageView *) x));
}
static void *_p_FXSliderTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXFrame *) ((FXSlider *) x));
}
static void *_p_FXRealSliderTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXFrame *) ((FXRealSlider *) x));
}
static void *_p_FXSpringTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *) ((FXSpring *) x));
}
static void *_p_FXColorBarTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXFrame *) ((FXColorBar *) x));
}
static void *_p_FXToolBarShellTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXShell *)(FXTopWindow *) ((FXToolBarShell *) x));
}
static void *_p_FXDocumentTo_p_FXObject(void *x) {
    return (void *)((FXObject *)  ((FXDocument *) x));
}
static void *_p_FXRegistryTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXDict *)(FXSettings *) ((FXRegistry *) x));
}
static void *_p_FXHeaderItemTo_p_FXObject(void *x) {
    return (void *)((FXObject *)  ((FXHeaderItem *) x));
}
static void *_p_FXShutterItemTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *)(FXVerticalFrame *) ((FXShutterItem *) x));
}
static void *_p_FXColorBarTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXFrame *) ((FXColorBar *) x));
}
static void *_p_FXTabBarTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXTabBar *) x));
}
static void *_p_FXSwitcherTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXSwitcher *) x));
}
static void *_p_FXTextFieldTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXFrame *) ((FXTextField *) x));
}
static void *_p_FXToolBarTabTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXFrame *) ((FXToolBarTab *) x));
}
static void *_p_FXDriveBoxTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *)(FXListBox *) ((FXDriveBox *) x));
}
static void *_p_FXIconDictTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXDict *) ((FXIconDict *) x));
}
static void *_p_FXMatrixTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXMatrix *) x));
}
static void *_p_FXFileDictTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXDict *) ((FXFileDict *) x));
}
static void *_p_FXRecentFilesTo_p_FXObject(void *x) {
    return (void *)((FXObject *)  ((FXRecentFiles *) x));
}
static void *_p_FXScrollCornerTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *) ((FXScrollCorner *) x));
}
static void *_p_FXArrowButtonTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXFrame *) ((FXArrowButton *) x));
}
static void *_p_FXPopupTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXShell *) ((FXPopup *) x));
}
static void *_p_FXDrawableTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *) ((FXDrawable *) x));
}
static void *_p_FXAppTo_p_FXObject(void *x) {
    return (void *)((FXObject *)  ((FXApp *) x));
}
static void *_p_FXHeaderTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXFrame *) ((FXHeader *) x));
}
static void *_p_FX4SplitterTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *) ((FX4Splitter *) x));
}
static void *_p_FXSplitterTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *) ((FXSplitter *) x));
}
static void *_p_FXSpringTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXSpring *) x));
}
static void *_p_FXPackerTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *) ((FXPacker *) x));
}
static void *_p_FXTabBookTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *)(FXTabBar *) ((FXTabBook *) x));
}
static void *_p_FXImageFrameTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXFrame *) ((FXImageFrame *) x));
}
static void *_p_FXVerticalSeparatorTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXFrame *)(FXSeparator *) ((FXVerticalSeparator *) x));
}
static void *_p_FXHorizontalSeparatorTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXFrame *)(FXSeparator *) ((FXHorizontalSeparator *) x));
}
static void *_p_FXSeparatorTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXFrame *) ((FXSeparator *) x));
}
static void *_p_FXIdTo_p_FXObject(void *x) {
    return (void *)((FXObject *)  ((FXId *) x));
}
static void *_p_FXProgressBarTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXFrame *) ((FXProgressBar *) x));
}
static void *_p_FXShutterTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *)(FXVerticalFrame *) ((FXShutter *) x));
}
static void *_p_FXToolTipTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXShell *) ((FXToolTip *) x));
}
static void *_p_FXCompositeTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *) ((FXComposite *) x));
}
static void *_p_FXBitmapFrameTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXFrame *) ((FXBitmapFrame *) x));
}
static void *_p_FXRealSliderTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXFrame *) ((FXRealSlider *) x));
}
static void *_p_FXSliderTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXFrame *) ((FXSlider *) x));
}
static void *_p_FXSettingsTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXDict *) ((FXSettings *) x));
}
static void *_p_FXScintillaTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXScrollArea *) ((FXScintilla *) x));
}
static void *_p_FXGroupBoxTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXGroupBox *) x));
}
static void *_p_FXDebugTargetTo_p_FXObject(void *x) {
    return (void *)((FXObject *)  ((FXDebugTarget *) x));
}
static void *_p_FXDataTargetTo_p_FXObject(void *x) {
    return (void *)((FXObject *)  ((FXDataTarget *) x));
}
static void *_p_FXTreeListBoxTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXTreeListBox *) x));
}
static void *_p_FXListBoxTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXListBox *) x));
}
static void *_p_FXCanvasTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *) ((FXCanvas *) x));
}
static void *_p_FXColorWheelTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXFrame *) ((FXColorWheel *) x));
}
static void *_p_FXVisualTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *) ((FXVisual *) x));
}
static void *_p_FXScrollBarTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *) ((FXScrollBar *) x));
}
static void *_p_FXToolBarGripTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *) ((FXToolBarGrip *) x));
}
static void *_p_FXFontTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *) ((FXFont *) x));
}
static void *_p_FXComboBoxTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXComboBox *) x));
}
static void *_p_FXFrameTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *) ((FXFrame *) x));
}
static void *_p_FXStringDictTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXDict *) ((FXStringDict *) x));
}
static void *_p_FXStatusBarTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *)(FXHorizontalFrame *) ((FXStatusBar *) x));
}
static void *_p_FXDelegatorTo_p_FXObject(void *x) {
    return (void *)((FXObject *)  ((FXDelegator *) x));
}
static void *_p_FXAccelTableTo_p_FXObject(void *x) {
    return (void *)((FXObject *)  ((FXAccelTable *) x));
}
static void *_p_FXCursorTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *) ((FXCursor *) x));
}
static void *_p_FXCURCursorTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXCursor *) ((FXCURCursor *) x));
}
static void *_p_FXGIFCursorTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXCursor *) ((FXGIFCursor *) x));
}
static void *_p_FXRealSpinnerTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXRealSpinner *) x));
}
static void *_p_FXSpinnerTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXSpinner *) x));
}
static void *_p_FXStatusLineTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXFrame *) ((FXStatusLine *) x));
}
static void *_p_FXScrollWindowTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXScrollArea *) ((FXScrollWindow *) x));
}
static void *_p_FXWindowTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *) ((FXWindow *) x));
}
static void *_p_FXRootWindowTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *) ((FXRootWindow *) x));
}
static void *_p_FXTopWindowTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXShell *) ((FXTopWindow *) x));
}
static void *_p_FXMainWindowTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXShell *)(FXTopWindow *) ((FXMainWindow *) x));
}
static void *_p_FXDictTo_p_FXObject(void *x) {
    return (void *)((FXObject *)  ((FXDict *) x));
}
static void *_p_FXShellTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *) ((FXShell *) x));
}
static void *_p_FXScrollAreaTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *) ((FXScrollArea *) x));
}
static void *_p_FXColorWellTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXFrame *) ((FXColorWell *) x));
}
static void *_p_FXDragCornerTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *) ((FXDragCorner *) x));
}
static void *_p_FXRulerTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXFrame *) ((FXRuler *) x));
}
static void *_p_FXDialTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXFrame *) ((FXDial *) x));
}
static void *_p_FXHorizontalFrameTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXHorizontalFrame *) x));
}
static void *_p_FXVerticalFrameTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXVerticalFrame *) x));
}
static void *_p_FXImageViewTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXScrollArea *) ((FXImageView *) x));
}
static void *_p_FXDirSelectorTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXDirSelector *) x));
}
static void *_p_FXFileSelectorTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXFileSelector *) x));
}
static void *_p_FXColorSelectorTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXColorSelector *) x));
}
static void *_p_FXFontSelectorTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXFontSelector *) x));
}
static void *_p_FXToolBarTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXToolBar *) x));
}
static void *_p_FXToolBarShellTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXShell *)(FXTopWindow *) ((FXToolBarShell *) x));
}
static void *_p_FXDirBoxTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *)(FXTreeListBox *) ((FXDirBox *) x));
}
static void *_p_FXScrollWindowTo_p_FXScrollArea(void *x) {
    return (void *)((FXScrollArea *)  ((FXScrollWindow *) x));
}
static void *_p_FXImageViewTo_p_FXScrollArea(void *x) {
    return (void *)((FXScrollArea *)  ((FXImageView *) x));
}
static void *_p_FXScintillaTo_p_FXScrollArea(void *x) {
    return (void *)((FXScrollArea *)  ((FXScintilla *) x));
}
static void *_p_FXFileStreamTo_p_FXStream(void *x) {
    return (void *)((FXStream *)  ((FXFileStream *) x));
}
static void *_p_FXMemoryStreamTo_p_FXStream(void *x) {
    return (void *)((FXStream *)  ((FXMemoryStream *) x));
}
static swig_type_info _swigt__p_FXId[] = {{"_p_FXId", 0, "FXId *", 0, 0, 0, 0},{"_p_FXDriveBox", _p_FXDriveBoxTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXDial", _p_FXDialTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXToolBar", _p_FXToolBarTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXComposite", _p_FXCompositeTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXToolTip", _p_FXToolTipTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXTabBook", _p_FXTabBookTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXTextField", _p_FXTextFieldTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXId", 0, 0, 0, 0, 0, 0},{"_p_FXArrowButton", _p_FXArrowButtonTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXGroupBox", _p_FXGroupBoxTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXShell", _p_FXShellTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXStatusBar", _p_FXStatusBarTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXScrollArea", _p_FXScrollAreaTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXPopup", _p_FXPopupTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXMainWindow", _p_FXMainWindowTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXTopWindow", _p_FXTopWindowTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXRootWindow", _p_FXRootWindowTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXScrollWindow", _p_FXScrollWindowTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXScrollCorner", _p_FXScrollCornerTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXWindow", _p_FXWindowTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXRuler", _p_FXRulerTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXCanvas", _p_FXCanvasTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXComboBox", _p_FXComboBoxTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXSeparator", _p_FXSeparatorTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXHorizontalSeparator", _p_FXHorizontalSeparatorTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXVerticalSeparator", _p_FXVerticalSeparatorTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXStatusLine", _p_FXStatusLineTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXScintilla", _p_FXScintillaTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXHorizontalFrame", _p_FXHorizontalFrameTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXVerticalFrame", _p_FXVerticalFrameTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FX4Splitter", _p_FX4SplitterTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXSplitter", _p_FXSplitterTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXRealSpinner", _p_FXRealSpinnerTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXSpinner", _p_FXSpinnerTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXPacker", _p_FXPackerTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXScrollBar", _p_FXScrollBarTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXColorWheel", _p_FXColorWheelTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXBitmapFrame", _p_FXBitmapFrameTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXDirBox", _p_FXDirBoxTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXToolBarGrip", _p_FXToolBarGripTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXImageFrame", _p_FXImageFrameTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXDragCorner", _p_FXDragCornerTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXSwitcher", _p_FXSwitcherTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXColorSelector", _p_FXColorSelectorTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXFileSelector", _p_FXFileSelectorTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXDirSelector", _p_FXDirSelectorTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXFontSelector", _p_FXFontSelectorTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXShutter", _p_FXShutterTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXProgressBar", _p_FXProgressBarTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXDrawable", _p_FXDrawableTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXCursor", _p_FXCursorTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXCURCursor", _p_FXCURCursorTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXGIFCursor", _p_FXGIFCursorTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXListBox", _p_FXListBoxTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXTreeListBox", _p_FXTreeListBoxTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXHeader", _p_FXHeaderTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXMatrix", _p_FXMatrixTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXShutterItem", _p_FXShutterItemTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXColorWell", _p_FXColorWellTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXToolBarTab", _p_FXToolBarTabTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXTabBar", _p_FXTabBarTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXFrame", _p_FXFrameTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXFont", _p_FXFontTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXImageView", _p_FXImageViewTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXSlider", _p_FXSliderTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXRealSlider", _p_FXRealSliderTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXSpring", _p_FXSpringTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXVisual", _p_FXVisualTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXColorBar", _p_FXColorBarTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXToolBarShell", _p_FXToolBarShellTo_p_FXId, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_SCNotification[] = {{"_p_SCNotification", 0, "SCNotification *", 0, 0, 0, 0},{"_p_SCNotification", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXComposite[] = {{"_p_FXComposite", 0, "FXComposite *", 0, 0, 0, 0},{"_p_FXDriveBox", _p_FXDriveBoxTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXToolBar", _p_FXToolBarTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXComposite", 0, 0, 0, 0, 0, 0},{"_p_FXToolTip", _p_FXToolTipTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXTabBook", _p_FXTabBookTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXGroupBox", _p_FXGroupBoxTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXShell", _p_FXShellTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXStatusBar", _p_FXStatusBarTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXScrollArea", _p_FXScrollAreaTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXPopup", _p_FXPopupTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXMainWindow", _p_FXMainWindowTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXTopWindow", _p_FXTopWindowTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXScrollWindow", _p_FXScrollWindowTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXRootWindow", _p_FXRootWindowTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXComboBox", _p_FXComboBoxTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXScintilla", _p_FXScintillaTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXHorizontalFrame", _p_FXHorizontalFrameTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXVerticalFrame", _p_FXVerticalFrameTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FX4Splitter", _p_FX4SplitterTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXSplitter", _p_FXSplitterTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXRealSpinner", _p_FXRealSpinnerTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXSpinner", _p_FXSpinnerTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXPacker", _p_FXPackerTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXDirBox", _p_FXDirBoxTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXSwitcher", _p_FXSwitcherTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXColorSelector", _p_FXColorSelectorTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXFileSelector", _p_FXFileSelectorTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXDirSelector", _p_FXDirSelectorTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXFontSelector", _p_FXFontSelectorTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXShutter", _p_FXShutterTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXTreeListBox", _p_FXTreeListBoxTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXListBox", _p_FXListBoxTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXMatrix", _p_FXMatrixTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXShutterItem", _p_FXShutterItemTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXTabBar", _p_FXTabBarTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXImageView", _p_FXImageViewTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXSpring", _p_FXSpringTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXToolBarShell", _p_FXToolBarShellTo_p_FXComposite, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXWindow[] = {{"_p_FXWindow", 0, "FXWindow *", 0, 0, 0, 0},{"_p_FXDriveBox", _p_FXDriveBoxTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXDial", _p_FXDialTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXToolBar", _p_FXToolBarTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXComposite", _p_FXCompositeTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXToolTip", _p_FXToolTipTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXTabBook", _p_FXTabBookTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXTextField", _p_FXTextFieldTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXArrowButton", _p_FXArrowButtonTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXGroupBox", _p_FXGroupBoxTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXShell", _p_FXShellTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXStatusBar", _p_FXStatusBarTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXScrollArea", _p_FXScrollAreaTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXPopup", _p_FXPopupTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXMainWindow", _p_FXMainWindowTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXTopWindow", _p_FXTopWindowTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXRootWindow", _p_FXRootWindowTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXWindow", 0, 0, 0, 0, 0, 0},{"_p_FXScrollWindow", _p_FXScrollWindowTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXScrollCorner", _p_FXScrollCornerTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXRuler", _p_FXRulerTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXCanvas", _p_FXCanvasTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXComboBox", _p_FXComboBoxTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXSeparator", _p_FXSeparatorTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXHorizontalSeparator", _p_FXHorizontalSeparatorTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXVerticalSeparator", _p_FXVerticalSeparatorTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXStatusLine", _p_FXStatusLineTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXScintilla", _p_FXScintillaTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXHorizontalFrame", _p_FXHorizontalFrameTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXVerticalFrame", _p_FXVerticalFrameTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FX4Splitter", _p_FX4SplitterTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXSplitter", _p_FXSplitterTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXRealSpinner", _p_FXRealSpinnerTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXSpinner", _p_FXSpinnerTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXPacker", _p_FXPackerTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXScrollBar", _p_FXScrollBarTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXColorWheel", _p_FXColorWheelTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXBitmapFrame", _p_FXBitmapFrameTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXDirBox", _p_FXDirBoxTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXToolBarGrip", _p_FXToolBarGripTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXImageFrame", _p_FXImageFrameTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXDragCorner", _p_FXDragCornerTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXSwitcher", _p_FXSwitcherTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXColorSelector", _p_FXColorSelectorTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXFileSelector", _p_FXFileSelectorTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXDirSelector", _p_FXDirSelectorTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXFontSelector", _p_FXFontSelectorTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXShutter", _p_FXShutterTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXProgressBar", _p_FXProgressBarTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXListBox", _p_FXListBoxTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXTreeListBox", _p_FXTreeListBoxTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXHeader", _p_FXHeaderTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXMatrix", _p_FXMatrixTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXShutterItem", _p_FXShutterItemTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXColorWell", _p_FXColorWellTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXToolBarTab", _p_FXToolBarTabTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXTabBar", _p_FXTabBarTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXFrame", _p_FXFrameTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXImageView", _p_FXImageViewTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXSlider", _p_FXSliderTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXRealSlider", _p_FXRealSliderTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXSpring", _p_FXSpringTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXColorBar", _p_FXColorBarTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXToolBarShell", _p_FXToolBarShellTo_p_FXWindow, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_TextRange[] = {{"_p_TextRange", 0, "TextRange *", 0, 0, 0, 0},{"_p_TextRange", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXDrawable[] = {{"_p_FXDrawable", 0, "FXDrawable *", 0, 0, 0, 0},{"_p_FXDriveBox", _p_FXDriveBoxTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXDial", _p_FXDialTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXToolBar", _p_FXToolBarTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXComposite", _p_FXCompositeTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXToolTip", _p_FXToolTipTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXTabBook", _p_FXTabBookTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXTextField", _p_FXTextFieldTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXArrowButton", _p_FXArrowButtonTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXGroupBox", _p_FXGroupBoxTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXShell", _p_FXShellTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXStatusBar", _p_FXStatusBarTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXScrollArea", _p_FXScrollAreaTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXPopup", _p_FXPopupTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXMainWindow", _p_FXMainWindowTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXTopWindow", _p_FXTopWindowTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXRootWindow", _p_FXRootWindowTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXScrollWindow", _p_FXScrollWindowTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXScrollCorner", _p_FXScrollCornerTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXWindow", _p_FXWindowTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXRuler", _p_FXRulerTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXCanvas", _p_FXCanvasTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXComboBox", _p_FXComboBoxTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXSeparator", _p_FXSeparatorTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXHorizontalSeparator", _p_FXHorizontalSeparatorTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXVerticalSeparator", _p_FXVerticalSeparatorTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXStatusLine", _p_FXStatusLineTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXScintilla", _p_FXScintillaTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXHorizontalFrame", _p_FXHorizontalFrameTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXVerticalFrame", _p_FXVerticalFrameTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FX4Splitter", _p_FX4SplitterTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXSplitter", _p_FXSplitterTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXRealSpinner", _p_FXRealSpinnerTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXSpinner", _p_FXSpinnerTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXPacker", _p_FXPackerTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXScrollBar", _p_FXScrollBarTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXColorWheel", _p_FXColorWheelTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXBitmapFrame", _p_FXBitmapFrameTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXDirBox", _p_FXDirBoxTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXToolBarGrip", _p_FXToolBarGripTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXImageFrame", _p_FXImageFrameTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXDragCorner", _p_FXDragCornerTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXSwitcher", _p_FXSwitcherTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXColorSelector", _p_FXColorSelectorTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXFileSelector", _p_FXFileSelectorTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXDirSelector", _p_FXDirSelectorTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXFontSelector", _p_FXFontSelectorTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXShutter", _p_FXShutterTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXDrawable", 0, 0, 0, 0, 0, 0},{"_p_FXProgressBar", _p_FXProgressBarTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXListBox", _p_FXListBoxTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXTreeListBox", _p_FXTreeListBoxTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXHeader", _p_FXHeaderTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXMatrix", _p_FXMatrixTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXShutterItem", _p_FXShutterItemTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXColorWell", _p_FXColorWellTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXToolBarTab", _p_FXToolBarTabTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXTabBar", _p_FXTabBarTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXFrame", _p_FXFrameTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXImageView", _p_FXImageViewTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXSlider", _p_FXSliderTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXRealSlider", _p_FXRealSliderTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXSpring", _p_FXSpringTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXColorBar", _p_FXColorBarTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXToolBarShell", _p_FXToolBarShellTo_p_FXDrawable, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXObject[] = {{"_p_FXObject", 0, "FXObject *", 0, 0, 0, 0},{"_p_FXDocument", _p_FXDocumentTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXRegistry", _p_FXRegistryTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXHeaderItem", _p_FXHeaderItemTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXShutterItem", _p_FXShutterItemTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXColorBar", _p_FXColorBarTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXTabBar", _p_FXTabBarTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXSwitcher", _p_FXSwitcherTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXTextField", _p_FXTextFieldTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXToolBarTab", _p_FXToolBarTabTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXDriveBox", _p_FXDriveBoxTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXIconDict", _p_FXIconDictTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXMatrix", _p_FXMatrixTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXFileDict", _p_FXFileDictTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXRecentFiles", _p_FXRecentFilesTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXScrollCorner", _p_FXScrollCornerTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXArrowButton", _p_FXArrowButtonTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXPopup", _p_FXPopupTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXDrawable", _p_FXDrawableTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXFont", _p_FXFontTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXHeader", _p_FXHeaderTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FX4Splitter", _p_FX4SplitterTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXSplitter", _p_FXSplitterTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXSpring", _p_FXSpringTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXApp", _p_FXAppTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXPacker", _p_FXPackerTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXTabBook", _p_FXTabBookTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXImageFrame", _p_FXImageFrameTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXVerticalSeparator", _p_FXVerticalSeparatorTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXHorizontalSeparator", _p_FXHorizontalSeparatorTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXSeparator", _p_FXSeparatorTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXProgressBar", _p_FXProgressBarTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXShutter", _p_FXShutterTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXToolTip", _p_FXToolTipTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXComposite", _p_FXCompositeTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXDict", _p_FXDictTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXBitmapFrame", _p_FXBitmapFrameTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXRealSlider", _p_FXRealSliderTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXSlider", _p_FXSliderTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXScintilla", _p_FXScintillaTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXSettings", _p_FXSettingsTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXGroupBox", _p_FXGroupBoxTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXDataTarget", _p_FXDataTargetTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXDebugTarget", _p_FXDebugTargetTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXTreeListBox", _p_FXTreeListBoxTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXListBox", _p_FXListBoxTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXCanvas", _p_FXCanvasTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXId", _p_FXIdTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXColorWheel", _p_FXColorWheelTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXDial", _p_FXDialTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXToolBarGrip", _p_FXToolBarGripTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXScrollBar", _p_FXScrollBarTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXVisual", _p_FXVisualTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXComboBox", _p_FXComboBoxTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXFrame", _p_FXFrameTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXStatusBar", _p_FXStatusBarTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXStringDict", _p_FXStringDictTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXDelegator", _p_FXDelegatorTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXAccelTable", _p_FXAccelTableTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXObject", 0, 0, 0, 0, 0, 0},{"_p_FXCursor", _p_FXCursorTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXCURCursor", _p_FXCURCursorTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXGIFCursor", _p_FXGIFCursorTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXRealSpinner", _p_FXRealSpinnerTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXSpinner", _p_FXSpinnerTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXStatusLine", _p_FXStatusLineTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXWindow", _p_FXWindowTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXScrollWindow", _p_FXScrollWindowTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXRootWindow", _p_FXRootWindowTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXTopWindow", _p_FXTopWindowTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXMainWindow", _p_FXMainWindowTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXShell", _p_FXShellTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXScrollArea", _p_FXScrollAreaTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXColorWell", _p_FXColorWellTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXDragCorner", _p_FXDragCornerTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXRuler", _p_FXRulerTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXHorizontalFrame", _p_FXHorizontalFrameTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXVerticalFrame", _p_FXVerticalFrameTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXImageView", _p_FXImageViewTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXColorSelector", _p_FXColorSelectorTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXFileSelector", _p_FXFileSelectorTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXDirSelector", _p_FXDirSelectorTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXFontSelector", _p_FXFontSelectorTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXToolBarShell", _p_FXToolBarShellTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXToolBar", _p_FXToolBarTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXDirBox", _p_FXDirBoxTo_p_FXObject, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXScrollArea[] = {{"_p_FXScrollArea", 0, "FXScrollArea *", 0, 0, 0, 0},{"_p_FXScrollWindow", _p_FXScrollWindowTo_p_FXScrollArea, 0, 0, 0, 0, 0},{"_p_FXScrollArea", 0, 0, 0, 0, 0, 0},{"_p_FXImageView", _p_FXImageViewTo_p_FXScrollArea, 0, 0, 0, 0, 0},{"_p_FXScintilla", _p_FXScintillaTo_p_FXScrollArea, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_NotifyHeader[] = {{"_p_NotifyHeader", 0, "NotifyHeader *", 0, 0, 0, 0},{"_p_NotifyHeader", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXScintilla[] = {{"_p_FXScintilla", 0, "FXScintilla *", 0, 0, 0, 0},{"_p_FXScintilla", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXStream[] = {{"_p_FXStream", 0, "FXStream *", 0, 0, 0, 0},{"_p_FXFileStream", _p_FXFileStreamTo_p_FXStream, 0, 0, 0, 0, 0},{"_p_FXMemoryStream", _p_FXMemoryStreamTo_p_FXStream, 0, 0, 0, 0, 0},{"_p_FXStream", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};

static swig_type_info *swig_types_initial[] = {
_swigt__p_FXId, 
_swigt__p_SCNotification, 
_swigt__p_FXComposite, 
_swigt__p_FXWindow, 
_swigt__p_TextRange, 
_swigt__p_FXDrawable, 
_swigt__p_FXObject, 
_swigt__p_FXScrollArea, 
_swigt__p_NotifyHeader, 
_swigt__p_FXScintilla, 
_swigt__p_FXStream, 
0
};


/* -------- TYPE CONVERSION AND EQUIVALENCE RULES (END) -------- */


#ifdef __cplusplus
extern "C"
#endif
SWIGEXPORT(void) Init_scintilla(void) {
    int i;
    
    SWIG_InitRuntime();
    
    for (i = 0; swig_types_initial[i]; i++) {
        swig_types[i] = SWIG_TypeRegister(swig_types_initial[i]);
        SWIG_define_class(swig_types[i]);
    }
    
    
    cNotifyHeader.klass = rb_define_class_under(mFox, "NotifyHeader", rb_cObject);
    SWIG_TypeClientData(SWIGTYPE_p_NotifyHeader, (void *) &cNotifyHeader);
    rb_undef_alloc_func(cNotifyHeader.klass);
    rb_define_method(cNotifyHeader.klass, "idFrom", VALUEFUNC(_wrap_NotifyHeader_idFrom_get), -1);
    rb_define_method(cNotifyHeader.klass, "code", VALUEFUNC(_wrap_NotifyHeader_code_get), -1);
    cNotifyHeader.mark = 0;
    cNotifyHeader.destroy = (void (*)(void *)) FXRbUnregisterRubyObj;
    
    cSCNotification.klass = rb_define_class_under(mFox, "SCNotification", rb_cObject);
    SWIG_TypeClientData(SWIGTYPE_p_SCNotification, (void *) &cSCNotification);
    rb_undef_alloc_func(cSCNotification.klass);
    rb_define_method(cSCNotification.klass, "nmhdr", VALUEFUNC(_wrap_SCNotification_nmhdr_get), -1);
    rb_define_method(cSCNotification.klass, "position", VALUEFUNC(_wrap_SCNotification_position_get), -1);
    rb_define_method(cSCNotification.klass, "ch", VALUEFUNC(_wrap_SCNotification_ch_get), -1);
    rb_define_method(cSCNotification.klass, "modifiers", VALUEFUNC(_wrap_SCNotification_modifiers_get), -1);
    rb_define_method(cSCNotification.klass, "modificationType", VALUEFUNC(_wrap_SCNotification_modificationType_get), -1);
    rb_define_method(cSCNotification.klass, "text", VALUEFUNC(_wrap_SCNotification_text), -1);
    rb_define_method(cSCNotification.klass, "length", VALUEFUNC(_wrap_SCNotification_length_get), -1);
    rb_define_method(cSCNotification.klass, "linesAdded", VALUEFUNC(_wrap_SCNotification_linesAdded_get), -1);
    rb_define_method(cSCNotification.klass, "message", VALUEFUNC(_wrap_SCNotification_message_get), -1);
    rb_define_method(cSCNotification.klass, "line", VALUEFUNC(_wrap_SCNotification_line_get), -1);
    rb_define_method(cSCNotification.klass, "foldLevelNow", VALUEFUNC(_wrap_SCNotification_foldLevelNow_get), -1);
    rb_define_method(cSCNotification.klass, "foldLevelPrev", VALUEFUNC(_wrap_SCNotification_foldLevelPrev_get), -1);
    rb_define_method(cSCNotification.klass, "margin", VALUEFUNC(_wrap_SCNotification_margin_get), -1);
    rb_define_method(cSCNotification.klass, "listType", VALUEFUNC(_wrap_SCNotification_listType_get), -1);
    rb_define_method(cSCNotification.klass, "x", VALUEFUNC(_wrap_SCNotification_x_get), -1);
    rb_define_method(cSCNotification.klass, "y", VALUEFUNC(_wrap_SCNotification_y_get), -1);
    rb_define_method(cSCNotification.klass, "wParam", VALUEFUNC(_wrap_SCNotification_wParam), -1);
    rb_define_method(cSCNotification.klass, "lParam", VALUEFUNC(_wrap_SCNotification_lParam), -1);
    cSCNotification.mark = 0;
    cSCNotification.destroy = (void (*)(void *)) FXRbUnregisterRubyObj;
    
    cTextRange.klass = rb_define_class_under(mFox, "TextRange", rb_cObject);
    SWIG_TypeClientData(SWIGTYPE_p_TextRange, (void *) &cTextRange);
    rb_define_alloc_func(cTextRange.klass, _wrap_TextRange_allocate);
    rb_define_method(cTextRange.klass, "initialize", VALUEFUNC(_wrap_new_TextRange), -1);
    rb_define_method(cTextRange.klass, "lpstrText", VALUEFUNC(_wrap_TextRange_lpstrText_get), -1);
    cTextRange.mark = 0;
    cTextRange.destroy = (void (*)(void *)) free_TextRange;
    
    cFXScintilla.klass = rb_define_class_under(mFox, "FXScintilla", ((swig_class *) SWIGTYPE_p_FXScrollArea->clientdata)->klass);
    SWIG_TypeClientData(SWIGTYPE_p_FXScintilla, (void *) &cFXScintilla);
    rb_define_alloc_func(cFXScintilla.klass, _wrap_FXScintilla_allocate);
    rb_define_method(cFXScintilla.klass, "initialize", VALUEFUNC(_wrap_new_FXScintilla), -1);
    rb_define_const(cFXScintilla.klass,"ID_TICK", INT2NUM(FXScintilla::ID_TICK));
    rb_define_method(cFXScintilla.klass, "onScintillaCommand", VALUEFUNC(_wrap_FXScintilla_onScintillaCommand), -1);
    rb_define_method(cFXScintilla.klass, "onPaint", VALUEFUNC(_wrap_FXScintilla_onPaint), -1);
    rb_define_method(cFXScintilla.klass, "onConfigure", VALUEFUNC(_wrap_FXScintilla_onConfigure), -1);
    rb_define_method(cFXScintilla.klass, "onTimeoutTicking", VALUEFUNC(_wrap_FXScintilla_onTimeoutTicking), -1);
    rb_define_method(cFXScintilla.klass, "onFocusIn", VALUEFUNC(_wrap_FXScintilla_onFocusIn), -1);
    rb_define_method(cFXScintilla.klass, "onFocusOut", VALUEFUNC(_wrap_FXScintilla_onFocusOut), -1);
    rb_define_method(cFXScintilla.klass, "onMotion", VALUEFUNC(_wrap_FXScintilla_onMotion), -1);
    rb_define_method(cFXScintilla.klass, "onLeftBtnPress", VALUEFUNC(_wrap_FXScintilla_onLeftBtnPress), -1);
    rb_define_method(cFXScintilla.klass, "onLeftBtnRelease", VALUEFUNC(_wrap_FXScintilla_onLeftBtnRelease), -1);
    rb_define_method(cFXScintilla.klass, "onRightBtnPress", VALUEFUNC(_wrap_FXScintilla_onRightBtnPress), -1);
    rb_define_method(cFXScintilla.klass, "onMiddleBtnPress", VALUEFUNC(_wrap_FXScintilla_onMiddleBtnPress), -1);
    rb_define_method(cFXScintilla.klass, "onBeginDrag", VALUEFUNC(_wrap_FXScintilla_onBeginDrag), -1);
    rb_define_method(cFXScintilla.klass, "onDragged", VALUEFUNC(_wrap_FXScintilla_onDragged), -1);
    rb_define_method(cFXScintilla.klass, "onEndDrag", VALUEFUNC(_wrap_FXScintilla_onEndDrag), -1);
    rb_define_method(cFXScintilla.klass, "onDNDEnter", VALUEFUNC(_wrap_FXScintilla_onDNDEnter), -1);
    rb_define_method(cFXScintilla.klass, "onDNDLeave", VALUEFUNC(_wrap_FXScintilla_onDNDLeave), -1);
    rb_define_method(cFXScintilla.klass, "onDNDMotion", VALUEFUNC(_wrap_FXScintilla_onDNDMotion), -1);
    rb_define_method(cFXScintilla.klass, "onDNDDrop", VALUEFUNC(_wrap_FXScintilla_onDNDDrop), -1);
    rb_define_method(cFXScintilla.klass, "onDNDRequest", VALUEFUNC(_wrap_FXScintilla_onDNDRequest), -1);
    rb_define_method(cFXScintilla.klass, "onSelectionLost", VALUEFUNC(_wrap_FXScintilla_onSelectionLost), -1);
    rb_define_method(cFXScintilla.klass, "onSelectionRequest", VALUEFUNC(_wrap_FXScintilla_onSelectionRequest), -1);
    rb_define_method(cFXScintilla.klass, "onClipboardLost", VALUEFUNC(_wrap_FXScintilla_onClipboardLost), -1);
    rb_define_method(cFXScintilla.klass, "onClipboardRequest", VALUEFUNC(_wrap_FXScintilla_onClipboardRequest), -1);
    rb_define_method(cFXScintilla.klass, "onKeyPress", VALUEFUNC(_wrap_FXScintilla_onKeyPress), -1);
    rb_define_method(cFXScintilla.klass, "setScintillaID", VALUEFUNC(_wrap_FXScintilla_setScintillaID), -1);
    rb_define_method(cFXScintilla.klass, "sendMessage", VALUEFUNC(_wrap_FXScintilla_sendMessage), -1);
    rb_define_method(cFXScintilla.klass, "save", VALUEFUNC(_wrap_FXScintilla_save), -1);
    rb_define_method(cFXScintilla.klass, "load", VALUEFUNC(_wrap_FXScintilla_load), -1);
    rb_define_method(cFXScintilla.klass, "create", VALUEFUNC(_wrap_FXScintilla_create), -1);
    rb_define_method(cFXScintilla.klass, "detach", VALUEFUNC(_wrap_FXScintilla_detach), -1);
    rb_define_method(cFXScintilla.klass, "destroy", VALUEFUNC(_wrap_FXScintilla_destroy), -1);
    rb_define_method(cFXScintilla.klass, "resize", VALUEFUNC(_wrap_FXScintilla_resize), -1);
    rb_define_method(cFXScintilla.klass, "getDefaultWidth", VALUEFUNC(_wrap_FXScintilla_getDefaultWidth), -1);
    rb_define_method(cFXScintilla.klass, "getDefaultHeight", VALUEFUNC(_wrap_FXScintilla_getDefaultHeight), -1);
    rb_define_method(cFXScintilla.klass, "getWidthForHeight", VALUEFUNC(_wrap_FXScintilla_getWidthForHeight), -1);
    rb_define_method(cFXScintilla.klass, "getHeightForWidth", VALUEFUNC(_wrap_FXScintilla_getHeightForWidth), -1);
    rb_define_method(cFXScintilla.klass, "canFocus", VALUEFUNC(_wrap_FXScintilla_canFocus), -1);
    rb_define_method(cFXScintilla.klass, "setFocus", VALUEFUNC(_wrap_FXScintilla_setFocus), -1);
    rb_define_method(cFXScintilla.klass, "killFocus", VALUEFUNC(_wrap_FXScintilla_killFocus), -1);
    rb_define_method(cFXScintilla.klass, "setDefault", VALUEFUNC(_wrap_FXScintilla_setDefault), -1);
    rb_define_method(cFXScintilla.klass, "enable", VALUEFUNC(_wrap_FXScintilla_enable), -1);
    rb_define_method(cFXScintilla.klass, "disable", VALUEFUNC(_wrap_FXScintilla_disable), -1);
    rb_define_method(cFXScintilla.klass, "raiseWindow", VALUEFUNC(_wrap_FXScintilla_raiseWindow), -1);
    rb_define_method(cFXScintilla.klass, "lower", VALUEFUNC(_wrap_FXScintilla_lower), -1);
    rb_define_method(cFXScintilla.klass, "move", VALUEFUNC(_wrap_FXScintilla_move), -1);
    rb_define_method(cFXScintilla.klass, "layout", VALUEFUNC(_wrap_FXScintilla_layout), -1);
    rb_define_method(cFXScintilla.klass, "recalc", VALUEFUNC(_wrap_FXScintilla_recalc), -1);
    rb_define_method(cFXScintilla.klass, "reparent", VALUEFUNC(_wrap_FXScintilla_reparent), -1);
    rb_define_method(cFXScintilla.klass, "show", VALUEFUNC(_wrap_FXScintilla_show), -1);
    rb_define_method(cFXScintilla.klass, "hide", VALUEFUNC(_wrap_FXScintilla_hide), -1);
    rb_define_method(cFXScintilla.klass, "isComposite", VALUEFUNC(_wrap_FXScintilla_isComposite), -1);
    rb_define_method(cFXScintilla.klass, "contains", VALUEFUNC(_wrap_FXScintilla_contains), -1);
    rb_define_method(cFXScintilla.klass, "doesSaveUnder", VALUEFUNC(_wrap_FXScintilla_doesSaveUnder), -1);
    rb_define_method(cFXScintilla.klass, "setBackColor", VALUEFUNC(_wrap_FXScintilla_setBackColor), -1);
    rb_define_method(cFXScintilla.klass, "getViewportHeight", VALUEFUNC(_wrap_FXScintilla_getViewportHeight), -1);
    rb_define_method(cFXScintilla.klass, "getViewportWidth", VALUEFUNC(_wrap_FXScintilla_getViewportWidth), -1);
    rb_define_method(cFXScintilla.klass, "getContentHeight", VALUEFUNC(_wrap_FXScintilla_getContentHeight), -1);
    rb_define_method(cFXScintilla.klass, "getContentWidth", VALUEFUNC(_wrap_FXScintilla_getContentWidth), -1);
    rb_define_method(cFXScintilla.klass, "position", VALUEFUNC(_wrap_FXScintilla_position), -1);
    cFXScintilla.mark = (void (*)(void *)) FXRbScintilla::markfunc;
    cFXScintilla.destroy = (void (*)(void *)) FXRbObject::freefunc;
}

