/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 1.3.22
 * 
 * This file is not intended to be easily readable and contains a number of 
 * coding conventions designed to improve portability and efficiency. Do not make
 * changes to this file unless you know what you are doing--modify the SWIG 
 * interface file instead. 
 * ----------------------------------------------------------------------------- */

#define SWIG_NOINCLUDE

#ifdef __cplusplus
template<class T> class SwigValueWrapper {
    T *tt;
public:
    SwigValueWrapper() : tt(0) { }
    SwigValueWrapper(const SwigValueWrapper<T>& rhs) : tt(new T(*rhs.tt)) { }
    SwigValueWrapper(const T& t) : tt(new T(t)) { }
    ~SwigValueWrapper() { delete tt; } 
    SwigValueWrapper& operator=(const T& t) { delete tt; tt = new T(t); return *this; }
    operator T&() const { return *tt; }
    T *operator&() { return tt; }
private:
    SwigValueWrapper& operator=(const SwigValueWrapper<T>& rhs);
};                                                    
#endif

/* ruby.swg */
/* Implementation : RUBY */
#define SWIGRUBY 1

#include "ruby.h"

/* Flags for pointer conversion */
#define SWIG_POINTER_EXCEPTION     0x1
#define SWIG_POINTER_DISOWN        0x2

#define NUM2USHRT(n) (\
    (0 <= NUM2UINT(n) && NUM2UINT(n) <= USHRT_MAX)\
    ? (unsigned short) NUM2UINT(n) \
    : (rb_raise(rb_eArgError, "integer %d out of range of `unsigned short'",\
               NUM2UINT(n)), (short)0)\
)

#define NUM2SHRT(n) (\
    (SHRT_MIN <= NUM2INT(n) && NUM2INT(n) <= SHRT_MAX)\
    ? (short)NUM2INT(n)\
    : (rb_raise(rb_eArgError, "integer %d out of range of `short'",\
               NUM2INT(n)), (short)0)\
)

/* Ruby 1.7 defines NUM2LL(), LL2NUM() and ULL2NUM() macros */
#ifndef NUM2LL
#define NUM2LL(x) NUM2LONG((x))
#endif
#ifndef LL2NUM
#define LL2NUM(x) INT2NUM((long) (x))
#endif
#ifndef ULL2NUM
#define ULL2NUM(x) UINT2NUM((unsigned long) (x))
#endif

/* Ruby 1.7 doesn't (yet) define NUM2ULL() */
#ifndef NUM2ULL
#ifdef HAVE_LONG_LONG
#define NUM2ULL(x) rb_num2ull((x))
#else
#define NUM2ULL(x) NUM2ULONG(x)
#endif
#endif

/*
 * Need to be very careful about how these macros are defined, especially
 * when compiling C++ code or C code with an ANSI C compiler.
 *
 * VALUEFUNC(f) is a macro used to typecast a C function that implements
 * a Ruby method so that it can be passed as an argument to API functions
 * like rb_define_method() and rb_define_singleton_method().
 *
 * VOIDFUNC(f) is a macro used to typecast a C function that implements
 * either the "mark" or "free" stuff for a Ruby Data object, so that it
 * can be passed as an argument to API functions like Data_Wrap_Struct()
 * and Data_Make_Struct().
 */
 
#ifdef __cplusplus
#  ifndef RUBY_METHOD_FUNC /* These definitions should work for Ruby 1.4.6 */
#    define PROTECTFUNC(f) ((VALUE (*)()) f)
#    define VALUEFUNC(f) ((VALUE (*)()) f)
#    define VOIDFUNC(f)  ((void (*)()) f)
#  else
#    ifndef ANYARGS /* These definitions should work for Ruby 1.6 */
#      define PROTECTFUNC(f) ((VALUE (*)()) f)
#      define VALUEFUNC(f) ((VALUE (*)()) f)
#      define VOIDFUNC(f)  ((RUBY_DATA_FUNC) f)
#    else /* These definitions should work for Ruby 1.7+ */
#      define PROTECTFUNC(f) ((VALUE (*)(VALUE)) f)
#      define VALUEFUNC(f) ((VALUE (*)(ANYARGS)) f)
#      define VOIDFUNC(f)  ((RUBY_DATA_FUNC) f)
#    endif
#  endif
#else
#  define VALUEFUNC(f) (f)
#  define VOIDFUNC(f) (f)
#endif

typedef struct {
  VALUE klass;
  VALUE mImpl;
  void  (*mark)(void *);
  void  (*destroy)(void *);
} swig_class;

/* Don't use for expressions have side effect */
#ifndef RB_STRING_VALUE
#define RB_STRING_VALUE(s) (TYPE(s) == T_STRING ? (s) : (*(volatile VALUE *)&(s) = rb_str_to_str(s)))
#endif
#ifndef StringValue
#define StringValue(s) RB_STRING_VALUE(s)
#endif
#ifndef StringValuePtr
#define StringValuePtr(s) RSTRING(RB_STRING_VALUE(s))->ptr
#endif
#ifndef StringValueLen
#define StringValueLen(s) RSTRING(RB_STRING_VALUE(s))->len
#endif
#ifndef SafeStringValue
#define SafeStringValue(v) do {\
    StringValue(v);\
    rb_check_safe_str(v);\
} while (0)
#endif

#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
#define rb_define_alloc_func(klass, func) rb_define_singleton_method((klass), "new", VALUEFUNC((func)), -1)
#define rb_undef_alloc_func(klass) rb_undef_method(CLASS_OF((klass)), "new")
#endif

/* Contract support */

#define SWIG_contract_assert(expr, msg) if (!(expr)) { rb_raise(rb_eRuntimeError, (char *) msg ); } else


/*************************************************************** -*- c -*-
 * ruby/precommon.swg
 *
 * Rename all exported symbols from common.swg, to avoid symbol
 * clashes if multiple interpreters are included
 *
 ************************************************************************/

#define SWIG_TypeRegister    SWIG_Ruby_TypeRegister
#define SWIG_TypeCheck       SWIG_Ruby_TypeCheck
#define SWIG_TypeCast        SWIG_Ruby_TypeCast
#define SWIG_TypeDynamicCast SWIG_Ruby_TypeDynamicCast
#define SWIG_TypeName        SWIG_Ruby_TypeName
#define SWIG_TypePrettyName  SWIG_Ruby_TypePrettyName
#define SWIG_TypeQuery       SWIG_Ruby_TypeQuery
#define SWIG_TypeClientData  SWIG_Ruby_TypeClientData
#define SWIG_PackData        SWIG_Ruby_PackData 
#define SWIG_UnpackData      SWIG_Ruby_UnpackData 

/* Also rename all exported symbols from rubydef.swig */

/* Common SWIG API */
#define SWIG_ConvertPtr(obj, pp, type, flags) \
  SWIG_Ruby_ConvertPtr(obj, pp, type, flags)
#define SWIG_NewPointerObj(p, type, flags) \
  SWIG_Ruby_NewPointerObj(p, type, flags)
#define SWIG_MustGetPtr(p, type, argnum, flags) \
  SWIG_Ruby_MustGetPtr(p, type, argnum, flags)

/* Ruby-specific SWIG API */

#define SWIG_InitRuntime() \
  SWIG_Ruby_InitRuntime()
#define SWIG_define_class(ty) \
  SWIG_Ruby_define_class(ty)
#define SWIG_NewClassInstance(value, ty) \
  SWIG_Ruby_NewClassInstance(value, ty)
#define SWIG_MangleStr(value) \
  SWIG_Ruby_MangleStr(value)
#define SWIG_CheckConvert(value, ty) \
  SWIG_Ruby_CheckConvert(value, ty)
#define SWIG_NewPackedObj(ptr, sz, ty) \
  SWIG_Ruby_NewPackedObj(ptr, sz, ty)
#define SWIG_ConvertPacked(obj, ptr, sz, ty, flags) \
  SWIG_Ruby_ConvertPacked(obj, ptr, sz, ty, flags)


/***********************************************************************
 * common.swg
 *
 *     This file contains generic SWIG runtime support for pointer
 *     type checking as well as a few commonly used macros to control
 *     external linkage.
 *
 * Author : David Beazley (beazley@cs.uchicago.edu)
 *
 * Copyright (c) 1999-2000, The University of Chicago
 * 
 * This file may be freely redistributed without license or fee provided
 * this copyright message remains intact.
 ************************************************************************/

#include <string.h>

#if defined(_WIN32) || defined(__WIN32__) || defined(__CYGWIN__)
#  if defined(_MSC_VER) || defined(__GNUC__)
#    if defined(STATIC_LINKED)
#      define SWIGEXPORT(a) a
#      define SWIGIMPORT(a) extern a
#    else
#      define SWIGEXPORT(a) __declspec(dllexport) a
#      define SWIGIMPORT(a) extern a
#    endif
#  else
#    if defined(__BORLANDC__)
#      define SWIGEXPORT(a) a _export
#      define SWIGIMPORT(a) a _export
#    else
#      define SWIGEXPORT(a) a
#      define SWIGIMPORT(a) a
#    endif
#  endif
#else
#  define SWIGEXPORT(a) a
#  define SWIGIMPORT(a) a
#endif

#ifdef SWIG_GLOBAL
#  define SWIGRUNTIME(a) SWIGEXPORT(a)
#else
#  define SWIGRUNTIME(a) static a
#endif

#ifdef __cplusplus
extern "C" {
#endif

typedef void *(*swig_converter_func)(void *);
typedef struct swig_type_info *(*swig_dycast_func)(void **);

typedef struct swig_type_info {
  const char             *name;
  swig_converter_func     converter;
  const char             *str;
  void                   *clientdata;
  swig_dycast_func        dcast;
  struct swig_type_info  *next;
  struct swig_type_info  *prev;
} swig_type_info;

#ifdef SWIG_NOINCLUDE

SWIGIMPORT(swig_type_info *) SWIG_TypeRegister(swig_type_info *);
SWIGIMPORT(swig_type_info *) SWIG_TypeCheck(char *c, swig_type_info *);
SWIGIMPORT(void *)           SWIG_TypeCast(swig_type_info *, void *);
SWIGIMPORT(swig_type_info *) SWIG_TypeDynamicCast(swig_type_info *, void **);
SWIGIMPORT(const char *)     SWIG_TypeName(const swig_type_info *);
SWIGIMPORT(const char *)     SWIG_TypePrettyName(const swig_type_info *);
SWIGIMPORT(swig_type_info *) SWIG_TypeQuery(const char *);
SWIGIMPORT(void)             SWIG_TypeClientData(swig_type_info *, void *);
SWIGIMPORT(char *)           SWIG_PackData(char *, void *, int);
SWIGIMPORT(char *)           SWIG_UnpackData(char *, void *, int);

#else

static swig_type_info *swig_type_list = 0;
static swig_type_info **swig_type_list_handle = &swig_type_list;

/* Register a type mapping with the type-checking */
SWIGRUNTIME(swig_type_info *)
SWIG_TypeRegister(swig_type_info *ti) {
  swig_type_info *tc, *head, *ret, *next;
  /* Check to see if this type has already been registered */
  tc = *swig_type_list_handle;
  while (tc) {
    if (strcmp(tc->name, ti->name) == 0) {
      /* Already exists in the table.  Just add additional types to the list */
      if (tc->clientdata) ti->clientdata = tc->clientdata;
      head = tc;
      next = tc->next;
      goto l1;
    }
    tc = tc->prev;
  }
  head = ti;
  next = 0;

  /* Place in list */
  ti->prev = *swig_type_list_handle;
  *swig_type_list_handle = ti;

  /* Build linked lists */
  l1:
  ret = head;
  tc = ti + 1;
  /* Patch up the rest of the links */
  while (tc->name) {
    head->next = tc;
    tc->prev = head;
    head = tc;
    tc++;
  }
  if (next) next->prev = head;
  head->next = next;
  return ret;
}

/* Check the typename */
SWIGRUNTIME(swig_type_info *) 
SWIG_TypeCheck(char *c, swig_type_info *ty) {
  swig_type_info *s;
  if (!ty) return 0;        /* Void pointer */
  s = ty->next;             /* First element always just a name */
  do {
    if (strcmp(s->name,c) == 0) {
      if (s == ty->next) return s;
      /* Move s to the top of the linked list */
      s->prev->next = s->next;
      if (s->next) {
        s->next->prev = s->prev;
      }
      /* Insert s as second element in the list */
      s->next = ty->next;
      if (ty->next) ty->next->prev = s;
      ty->next = s;
      s->prev = ty;
      return s;
    }
    s = s->next;
  } while (s && (s != ty->next));
  return 0;
}

/* Cast a pointer up an inheritance hierarchy */
SWIGRUNTIME(void *) 
SWIG_TypeCast(swig_type_info *ty, void *ptr) {
  if ((!ty) || (!ty->converter)) return ptr;
  return (*ty->converter)(ptr);
}

/* Dynamic pointer casting. Down an inheritance hierarchy */
SWIGRUNTIME(swig_type_info *) 
SWIG_TypeDynamicCast(swig_type_info *ty, void **ptr) {
  swig_type_info *lastty = ty;
  if (!ty || !ty->dcast) return ty;
  while (ty && (ty->dcast)) {
    ty = (*ty->dcast)(ptr);
    if (ty) lastty = ty;
  }
  return lastty;
}

/* Return the name associated with this type */
SWIGRUNTIME(const char *)
SWIG_TypeName(const swig_type_info *ty) {
  return ty->name;
}

/* Return the pretty name associated with this type,
   that is an unmangled type name in a form presentable to the user.
*/
SWIGRUNTIME(const char *)
SWIG_TypePrettyName(const swig_type_info *type) {
  /* The "str" field contains the equivalent pretty names of the
     type, separated by vertical-bar characters.  We choose
     to print the last name, as it is often (?) the most
     specific. */
  if (type->str != NULL) {
    const char *last_name = type->str;
    const char *s;
    for (s = type->str; *s; s++)
      if (*s == '|') last_name = s+1;
    return last_name;
  }
  else
    return type->name;
}

/* 
   Compare two type names skipping the space characters, therefore
   "char*" == "char *" and "Class<int>" == "Class<int >", etc.

   Return 0 when the two name types are equivalent, as in
   strncmp, but skipping ' '.
*/
static int
SWIG_TypeNameComp(const char *f1, const char *l1,
		  const char *f2, const char *l2) {
  for (;(f1 != l1) && (f2 != l2); ++f1, ++f2) {
    while ((*f1 == ' ') && (f1 != l1)) ++f1;
    while ((*f2 == ' ') && (f2 != l2)) ++f2;
    if (*f1 != *f2) return *f1 - *f2;
  }
  return (l1 - f1) - (l2 - f2);
}

/*
  Check type equivalence in a name list like <name1>|<name2>|...
*/
static int
SWIG_TypeEquiv(const char *nb, const char *tb) {
  int equiv = 0;
  const char* te = tb + strlen(tb);
  const char* ne = nb;
  while (!equiv && *ne) {
    for (nb = ne; *ne; ++ne) {
      if (*ne == '|') break;
    }
    equiv = SWIG_TypeNameComp(nb, ne, tb, te) == 0;
    if (*ne) ++ne;
  }
  return equiv;
}
  

/* Search for a swig_type_info structure */
SWIGRUNTIME(swig_type_info *)
SWIG_TypeQuery(const char *name) {
  swig_type_info *ty = *swig_type_list_handle;
  while (ty) {
    if (ty->str && (SWIG_TypeEquiv(ty->str,name))) return ty;
    if (ty->name && (strcmp(name,ty->name) == 0)) return ty;
    ty = ty->prev;
  }
  return 0;
}

/* Set the clientdata field for a type */
SWIGRUNTIME(void)
SWIG_TypeClientData(swig_type_info *ti, void *clientdata) {
  swig_type_info *tc, *equiv;
  if (ti->clientdata == clientdata) return;
  ti->clientdata = clientdata;
  equiv = ti->next;
  while (equiv) {
    if (!equiv->converter) {
      tc = *swig_type_list_handle;
      while (tc) {
        if ((strcmp(tc->name, equiv->name) == 0))
          SWIG_TypeClientData(tc,clientdata);
        tc = tc->prev;
      }
    }
    equiv = equiv->next;
  }
}

/* Pack binary data into a string */
SWIGRUNTIME(char *)
SWIG_PackData(char *c, void *ptr, int sz) {
  static char hex[17] = "0123456789abcdef";
  unsigned char *u = (unsigned char *) ptr;
  const unsigned char *eu =  u + sz;
  register unsigned char uu;
  for (; u != eu; ++u) {
    uu = *u;
    *(c++) = hex[(uu & 0xf0) >> 4];
    *(c++) = hex[uu & 0xf];
  }
  return c;
}

/* Unpack binary data from a string */
SWIGRUNTIME(char *)
SWIG_UnpackData(char *c, void *ptr, int sz) {
  register unsigned char uu = 0;
  register int d;
  unsigned char *u = (unsigned char *) ptr;
  const unsigned char *eu =  u + sz;
  for (; u != eu; ++u) {
    d = *(c++);
    if ((d >= '0') && (d <= '9'))
      uu = ((d - '0') << 4);
    else if ((d >= 'a') && (d <= 'f'))
      uu = ((d - ('a'-10)) << 4);
    d = *(c++);
    if ((d >= '0') && (d <= '9'))
      uu |= (d - '0');
    else if ((d >= 'a') && (d <= 'f'))
      uu |= (d - ('a'-10));
    *u = uu;
  }
  return c;
}

#endif

#ifdef __cplusplus
}
#endif

/* rubydec.swg -*- c -*- */
#ifdef __cplusplus
extern "C" {
#endif

SWIGIMPORT(void)   SWIG_Ruby_InitRuntime(void);
SWIGIMPORT(void)   SWIG_Ruby_define_class(swig_type_info *);
SWIGIMPORT(VALUE)  SWIG_Ruby_NewPointerObj(void *, swig_type_info *, int);
SWIGIMPORT(VALUE)  SWIG_Ruby_NewClassInstance(VALUE, swig_type_info *);
SWIGIMPORT(char *) SWIG_Ruby_MangleStr(VALUE);
SWIGIMPORT(int)    SWIG_Ruby_ConvertPtr(VALUE, void**, swig_type_info *, int);
SWIGIMPORT(void *) SWIG_Ruby_MustGetPtr(VALUE, swig_type_info *, int, int);
SWIGIMPORT(int)    SWIG_Ruby_CheckConvert(VALUE, swig_type_info *);
SWIGIMPORT(VALUE)  SWIG_Ruby_NewPackedObj(void *ptr, int sz, swig_type_info *type);
SWIGIMPORT(void)   SWIG_Ruby_ConvertPacked(VALUE obj, void *ptr, int sz, swig_type_info *ty, int flags);

#ifdef __cplusplus
}
#endif


/* -------- TYPES TABLE (BEGIN) -------- */

#define  SWIGTYPE_p_FXId swig_types[0] 
#define  SWIGTYPE_p_FXComposite swig_types[1] 
#define  SWIGTYPE_p_FXText swig_types[2] 
#define  SWIGTYPE_p_FXWindow swig_types[3] 
#define  SWIGTYPE_p_FXHiliteStyle swig_types[4] 
#define  SWIGTYPE_p_FXFont swig_types[5] 
#define  SWIGTYPE_p_FXDrawable swig_types[6] 
#define  SWIGTYPE_p_FXObject swig_types[7] 
#define  SWIGTYPE_p_FXScrollArea swig_types[8] 
#define  SWIGTYPE_p_FXTextChange swig_types[9] 
#define  SWIGTYPE_p_FXStream swig_types[10] 
static swig_type_info *swig_types[12];

/* -------- TYPES TABLE (END) -------- */

#define SWIG_init    Init_text
#define SWIG_name    "Text"


static void SWIG_AsVal(VALUE obj, int *val)
{
    *val = (int) NUM2INT(obj);
}


#include "FXRbCommon.h"


inline FXColor to_FXColor(VALUE obj){
  if(TYPE(obj)==T_STRING){
    return fxcolorfromname(StringValuePtr(obj));
    }
  else if(TYPE(obj)==T_SYMBOL){
    return fxcolorfromname(rb_id2name(SYM2ID(obj)));
    }
  else{
    return NUM2ULONG(obj);
    }
  }


inline FXString to_FXString(VALUE obj){
  if(!NIL_P(obj)){
    Check_Type(obj,T_STRING);
    return FXString(STR2CSTR(obj));
    }
  else{
    return FXString::null;
    }
  }


inline FXbool to_FXbool(VALUE obj){
  if (obj == Qtrue || obj == Qfalse){
    return (obj == Qtrue) ? TRUE : FALSE;
    }
  else{
    return static_cast<FXbool>(NUM2UINT(obj));
    }
  }


static swig_type_info* FXEventTypeInfo=0;

inline void* to_FXEvent(VALUE obj){
  void* ptr;
  if(!FXEventTypeInfo){
    FXEventTypeInfo=SWIG_TypeQuery("FXEvent *");
    FXASSERT(FXEventTypeInfo!=0);
    }
  SWIG_ConvertPtr(obj,&ptr,FXEventTypeInfo,1);
  return ptr;
  }


swig_class cFXHiliteStyle;
static void free_FXHiliteStyle(FXHiliteStyle *);

swig_class cFXTextChange;
FXText *new_FXText(FXComposite *p,FXObject *tgt,FXSelector sel,FXuint opts,FXint x,FXint y,FXint w,FXint h){
      return new FXRbText(p,tgt,sel,opts,x,y,w,h);
      }
VALUE FXText_extractText(FXText const *self,FXint pos,FXint n){
      FXchar *buffer;
      VALUE str;
      if(FXMALLOC(&buffer,FXchar,n)){
        self->extractText(buffer,pos,n);
        str=rb_str_new(buffer,n);
	FXFREE(&buffer);
        }
      else{
        rb_raise(rb_eNoMemError,"couldn't allocate string for return value");
        }
      return str;
      }
VALUE FXText_extractStyle(FXText const *self,FXint pos,FXint n){
      FXchar *style;
      VALUE str=Qnil;
      if(self->isStyled()){
        if(FXMALLOC(&style,FXchar,n)){
          self->extractStyle(style,pos,n);
          str=rb_str_new(style,n);
	  FXFREE(&style);
          }
        else{
          rb_raise(rb_eNoMemError,"couldn't allocate string for return value");
          }
	}
        return str;
      }
void FXText_replaceText(FXText *self,FXint pos,FXint m,FXString const &text,FXbool notify){
    self->replaceText(pos,m,text.text(),text.length(),notify);
    }
void FXText_replaceStyledText(FXText *self,FXint pos,FXint m,FXString const &text,FXint style,FXbool notify){
    self->replaceStyledText(pos,m,text.text(),text.length(),style,notify);
    }
void FXText_appendText(FXText *self,FXString const &text,FXbool notify){
    self->appendText(text.text(),text.length(),notify);
    }
void FXText_appendStyledText(FXText *self,FXString const &text,FXint style,FXbool notify){
    self->appendStyledText(text.text(),text.length(),style,notify);
    }
void FXText_insertText(FXText *self,FXint pos,FXString const &text,FXbool notify){
    self->insertText(pos,text.text(),text.length(),notify);
    }
void FXText_insertStyledText(FXText *self,FXint pos,FXString const &text,FXint style,FXbool notify){
    self->insertStyledText(pos,text.text(),text.length(),style,notify);
    }
VALUE FXText_findText(FXText *self,FXString const &string,FXint start,FXuint flags,FXint npar){
      FXint* beg;
      FXint* end;
      VALUE ary=Qnil;
      
      if(!FXMALLOC(&beg,FXint,npar)){
        return Qnil;
	}
	
      if(!FXMALLOC(&end,FXint,npar)){
        FXFREE(&beg);
	return Qnil;
	}
	
      if(self->findText(string,beg,end,start,flags,npar)){
        ary=rb_ary_new();
	rb_ary_push(ary,FXRbMakeArray(beg,npar));
	rb_ary_push(ary,FXRbMakeArray(end,npar));
        }
	
      FXFREE(&beg);
      FXFREE(&end);
      
      return ary;
      }
void FXText_setHiliteStyles(FXText *self,VALUE styles){
      if(self->isMemberOf(FXMETACLASS(FXRbText))){
        FXRbText *text=dynamic_cast<FXRbText*>(self);
	FXASSERT(text);
        Check_Type(styles,T_ARRAY);
	if(text->numStyles>0){
	  delete [] text->styles;
	  text->numStyles=0;
	  }
	text->numStyles=RARRAY(styles)->len;
	if(text->numStyles>0){
          text->styles=new FXHiliteStyle[text->numStyles];
          for (long i=0; i<text->numStyles; i++){
            FXHiliteStyle* ptr;
	    SWIG_ConvertPtr(rb_ary_entry(styles,i),(void **)&ptr,SWIGTYPE_p_FXHiliteStyle,1);
            text->styles[i]=*ptr;
            }
	  self->setHiliteStyles(text->styles);
	  }
	}
      else{
        rb_notimplement();
        }
      }
VALUE FXText_getHiliteStyles(FXText const *self){
      if(self->isMemberOf(FXMETACLASS(FXRbText))){
        const FXRbText* text=dynamic_cast<const FXRbText*>(self);
	FXASSERT(text);
        VALUE ary=rb_ary_new();
        for(FXint i=0; i<text->numStyles; i++){
	  rb_ary_push(ary,FXRbGetRubyObj(&(text->styles[i]),"FXHiliteStyle *"));
	  }
	return ary;
	}
      else{
        rb_notimplement();
	return Qnil; // not reached
        }
      }
VALUE FXText_position__SWIG_1(FXText const *self){
    FXint x, y;
    self->getPosition(x, y);
    VALUE pos = rb_ary_new();
    rb_ary_push(pos, INT2NUM(x));
    rb_ary_push(pos, INT2NUM(y));
    return pos;
  }

swig_class cFXText;
static void free_FXText(FXText *);
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE _wrap_FXHiliteStyle_allocate(VALUE self) {
#else
     static VALUE _wrap_FXHiliteStyle_allocate(int argc, VALUE *argv, VALUE self) {
#endif
         VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_FXHiliteStyle);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
         return vresult; }
static VALUE _wrap_new_FXHiliteStyle(int argc, VALUE *argv, VALUE self) { FXHiliteStyle *result; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc); result = (FXHiliteStyle *)new FXHiliteStyle();
    DATA_PTR(self) = result; return self; }
static VALUE _wrap_FXHiliteStyle_normalForeColor_set(int argc, VALUE *argv, VALUE self) {
    FXHiliteStyle *arg1 = (FXHiliteStyle *) 0 ; FXColor arg2 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXHiliteStyle, 1); arg2 = to_FXColor(argv[0]);
    if (arg1) (arg1)->normalForeColor = arg2; return Qnil; }
static VALUE _wrap_FXHiliteStyle_normalForeColor_get(int argc, VALUE *argv, VALUE self) {
    FXHiliteStyle *arg1 = (FXHiliteStyle *) 0 ; FXColor result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXHiliteStyle, 1); result = (FXColor) ((arg1)->normalForeColor);
    vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXHiliteStyle_normalBackColor_set(int argc, VALUE *argv, VALUE self) {
    FXHiliteStyle *arg1 = (FXHiliteStyle *) 0 ; FXColor arg2 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXHiliteStyle, 1); arg2 = to_FXColor(argv[0]);
    if (arg1) (arg1)->normalBackColor = arg2; return Qnil; }
static VALUE _wrap_FXHiliteStyle_normalBackColor_get(int argc, VALUE *argv, VALUE self) {
    FXHiliteStyle *arg1 = (FXHiliteStyle *) 0 ; FXColor result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXHiliteStyle, 1); result = (FXColor) ((arg1)->normalBackColor);
    vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXHiliteStyle_selectForeColor_set(int argc, VALUE *argv, VALUE self) {
    FXHiliteStyle *arg1 = (FXHiliteStyle *) 0 ; FXColor arg2 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXHiliteStyle, 1); arg2 = to_FXColor(argv[0]);
    if (arg1) (arg1)->selectForeColor = arg2; return Qnil; }
static VALUE _wrap_FXHiliteStyle_selectForeColor_get(int argc, VALUE *argv, VALUE self) {
    FXHiliteStyle *arg1 = (FXHiliteStyle *) 0 ; FXColor result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXHiliteStyle, 1); result = (FXColor) ((arg1)->selectForeColor);
    vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXHiliteStyle_selectBackColor_set(int argc, VALUE *argv, VALUE self) {
    FXHiliteStyle *arg1 = (FXHiliteStyle *) 0 ; FXColor arg2 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXHiliteStyle, 1); arg2 = to_FXColor(argv[0]);
    if (arg1) (arg1)->selectBackColor = arg2; return Qnil; }
static VALUE _wrap_FXHiliteStyle_selectBackColor_get(int argc, VALUE *argv, VALUE self) {
    FXHiliteStyle *arg1 = (FXHiliteStyle *) 0 ; FXColor result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXHiliteStyle, 1); result = (FXColor) ((arg1)->selectBackColor);
    vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXHiliteStyle_hiliteForeColor_set(int argc, VALUE *argv, VALUE self) {
    FXHiliteStyle *arg1 = (FXHiliteStyle *) 0 ; FXColor arg2 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXHiliteStyle, 1); arg2 = to_FXColor(argv[0]);
    if (arg1) (arg1)->hiliteForeColor = arg2; return Qnil; }
static VALUE _wrap_FXHiliteStyle_hiliteForeColor_get(int argc, VALUE *argv, VALUE self) {
    FXHiliteStyle *arg1 = (FXHiliteStyle *) 0 ; FXColor result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXHiliteStyle, 1); result = (FXColor) ((arg1)->hiliteForeColor);
    vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXHiliteStyle_hiliteBackColor_set(int argc, VALUE *argv, VALUE self) {
    FXHiliteStyle *arg1 = (FXHiliteStyle *) 0 ; FXColor arg2 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXHiliteStyle, 1); arg2 = to_FXColor(argv[0]);
    if (arg1) (arg1)->hiliteBackColor = arg2; return Qnil; }
static VALUE _wrap_FXHiliteStyle_hiliteBackColor_get(int argc, VALUE *argv, VALUE self) {
    FXHiliteStyle *arg1 = (FXHiliteStyle *) 0 ; FXColor result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXHiliteStyle, 1); result = (FXColor) ((arg1)->hiliteBackColor);
    vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXHiliteStyle_activeBackColor_set(int argc, VALUE *argv, VALUE self) {
    FXHiliteStyle *arg1 = (FXHiliteStyle *) 0 ; FXColor arg2 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXHiliteStyle, 1); arg2 = to_FXColor(argv[0]);
    if (arg1) (arg1)->activeBackColor = arg2; return Qnil; }
static VALUE _wrap_FXHiliteStyle_activeBackColor_get(int argc, VALUE *argv, VALUE self) {
    FXHiliteStyle *arg1 = (FXHiliteStyle *) 0 ; FXColor result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXHiliteStyle, 1); result = (FXColor) ((arg1)->activeBackColor);
    vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXHiliteStyle_style_set(int argc, VALUE *argv, VALUE self) { FXHiliteStyle *arg1 = (FXHiliteStyle *) 0 ;
    FXuint arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXHiliteStyle, 1); arg2 = NUM2UINT(argv[0]);
    if (arg1) (arg1)->style = arg2; return Qnil; }
static VALUE _wrap_FXHiliteStyle_style_get(int argc, VALUE *argv, VALUE self) { FXHiliteStyle *arg1 = (FXHiliteStyle *) 0 ;
    FXuint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXHiliteStyle, 1); result = (FXuint) ((arg1)->style);
    vresult = UINT2NUM(result); return vresult; }
static void
free_FXHiliteStyle(FXHiliteStyle *arg1) {
    delete arg1;
}
static VALUE _wrap_FXTextChange_pos_set(int argc, VALUE *argv, VALUE self) { FXTextChange *arg1 = (FXTextChange *) 0 ;
    FXint arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTextChange, 1); arg2 = NUM2INT(argv[0]); if (arg1) (arg1)->pos = arg2;
    return Qnil; }
static VALUE _wrap_FXTextChange_pos_get(int argc, VALUE *argv, VALUE self) { FXTextChange *arg1 = (FXTextChange *) 0 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTextChange, 1); result = (FXint) ((arg1)->pos);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTextChange_ndel_set(int argc, VALUE *argv, VALUE self) { FXTextChange *arg1 = (FXTextChange *) 0 ;
    FXint arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTextChange, 1); arg2 = NUM2INT(argv[0]); if (arg1) (arg1)->ndel = arg2;
    return Qnil; }
static VALUE _wrap_FXTextChange_ndel_get(int argc, VALUE *argv, VALUE self) { FXTextChange *arg1 = (FXTextChange *) 0 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTextChange, 1); result = (FXint) ((arg1)->ndel);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTextChange_nins_set(int argc, VALUE *argv, VALUE self) { FXTextChange *arg1 = (FXTextChange *) 0 ;
    FXint arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTextChange, 1); arg2 = NUM2INT(argv[0]); if (arg1) (arg1)->nins = arg2;
    return Qnil; }
static VALUE _wrap_FXTextChange_nins_get(int argc, VALUE *argv, VALUE self) { FXTextChange *arg1 = (FXTextChange *) 0 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTextChange, 1); result = (FXint) ((arg1)->nins);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTextChange_ins_set(int argc, VALUE *argv, VALUE self) { FXTextChange *arg1 = (FXTextChange *) 0 ;
    FXchar *arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTextChange, 1); arg2 = StringValuePtr(argv[0]); {
        if (arg1->ins) delete [] arg1->ins; if (arg2) { arg1->ins = (FXchar *) (new char[strlen(arg2)+1]);
            strcpy((char *) arg1->ins,arg2); }  else { arg1->ins = 0; }  }  return Qnil; }
static VALUE _wrap_FXTextChange_ins_get(int argc, VALUE *argv, VALUE self) { FXTextChange *arg1 = (FXTextChange *) 0 ;
    FXchar *result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTextChange, 1); result = (FXchar *) ((arg1)->ins);
    vresult = rb_str_new2(result); return vresult; }
static VALUE _wrap_FXTextChange_del_set(int argc, VALUE *argv, VALUE self) { FXTextChange *arg1 = (FXTextChange *) 0 ;
    FXchar *arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTextChange, 1); arg2 = StringValuePtr(argv[0]); {
        if (arg1->del) delete [] arg1->del; if (arg2) { arg1->del = (FXchar *) (new char[strlen(arg2)+1]);
            strcpy((char *) arg1->del,arg2); }  else { arg1->del = 0; }  }  return Qnil; }
static VALUE _wrap_FXTextChange_del_get(int argc, VALUE *argv, VALUE self) { FXTextChange *arg1 = (FXTextChange *) 0 ;
    FXchar *result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTextChange, 1); result = (FXchar *) ((arg1)->del);
    vresult = rb_str_new2(result); return vresult; }
static VALUE _wrap_FXText_onPaint(int argc, VALUE *argv, VALUE self) { FXText *arg1 = (FXText *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXText, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onPaint(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXText_onUpdate(int argc, VALUE *argv, VALUE self) { FXText *arg1 = (FXText *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXText, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onUpdate(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXText_onFocusIn(int argc, VALUE *argv, VALUE self) { FXText *arg1 = (FXText *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXText, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onFocusIn(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXText_onFocusOut(int argc, VALUE *argv, VALUE self) { FXText *arg1 = (FXText *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXText, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onFocusOut(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXText_onLeftBtnPress(int argc, VALUE *argv, VALUE self) { FXText *arg1 = (FXText *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXText, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onLeftBtnPress(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXText_onLeftBtnRelease(int argc, VALUE *argv, VALUE self) { FXText *arg1 = (FXText *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXText, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onLeftBtnRelease(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXText_onMiddleBtnPress(int argc, VALUE *argv, VALUE self) { FXText *arg1 = (FXText *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXText, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onMiddleBtnPress(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXText_onMiddleBtnRelease(int argc, VALUE *argv, VALUE self) { FXText *arg1 = (FXText *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXText, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onMiddleBtnRelease(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXText_onRightBtnPress(int argc, VALUE *argv, VALUE self) { FXText *arg1 = (FXText *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXText, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onRightBtnPress(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXText_onRightBtnRelease(int argc, VALUE *argv, VALUE self) { FXText *arg1 = (FXText *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXText, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onRightBtnRelease(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXText_onUngrabbed(int argc, VALUE *argv, VALUE self) { FXText *arg1 = (FXText *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXText, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onUngrabbed(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXText_onMotion(int argc, VALUE *argv, VALUE self) { FXText *arg1 = (FXText *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXText, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onMotion(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXText_onBeginDrag(int argc, VALUE *argv, VALUE self) { FXText *arg1 = (FXText *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXText, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onBeginDrag(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXText_onEndDrag(int argc, VALUE *argv, VALUE self) { FXText *arg1 = (FXText *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXText, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onEndDrag(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXText_onDragged(int argc, VALUE *argv, VALUE self) { FXText *arg1 = (FXText *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXText, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onDragged(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXText_onDNDEnter(int argc, VALUE *argv, VALUE self) { FXText *arg1 = (FXText *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXText, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onDNDEnter(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXText_onDNDLeave(int argc, VALUE *argv, VALUE self) { FXText *arg1 = (FXText *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXText, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onDNDLeave(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXText_onDNDMotion(int argc, VALUE *argv, VALUE self) { FXText *arg1 = (FXText *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXText, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onDNDMotion(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXText_onDNDDrop(int argc, VALUE *argv, VALUE self) { FXText *arg1 = (FXText *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXText, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onDNDDrop(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXText_onDNDRequest(int argc, VALUE *argv, VALUE self) { FXText *arg1 = (FXText *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXText, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onDNDRequest(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXText_onSelectionLost(int argc, VALUE *argv, VALUE self) { FXText *arg1 = (FXText *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXText, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onSelectionLost(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXText_onSelectionGained(int argc, VALUE *argv, VALUE self) { FXText *arg1 = (FXText *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXText, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onSelectionGained(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXText_onSelectionRequest(int argc, VALUE *argv, VALUE self) { FXText *arg1 = (FXText *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXText, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onSelectionRequest(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXText_onClipboardLost(int argc, VALUE *argv, VALUE self) { FXText *arg1 = (FXText *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXText, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onClipboardLost(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXText_onClipboardGained(int argc, VALUE *argv, VALUE self) { FXText *arg1 = (FXText *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXText, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onClipboardGained(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXText_onClipboardRequest(int argc, VALUE *argv, VALUE self) { FXText *arg1 = (FXText *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXText, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onClipboardRequest(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXText_onKeyPress(int argc, VALUE *argv, VALUE self) { FXText *arg1 = (FXText *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXText, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onKeyPress(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXText_onKeyRelease(int argc, VALUE *argv, VALUE self) { FXText *arg1 = (FXText *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXText, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onKeyRelease(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXText_onBlink(int argc, VALUE *argv, VALUE self) { FXText *arg1 = (FXText *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXText, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onBlink(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXText_onFlash(int argc, VALUE *argv, VALUE self) { FXText *arg1 = (FXText *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXText, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onFlash(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXText_onAutoScroll(int argc, VALUE *argv, VALUE self) { FXText *arg1 = (FXText *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXText, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onAutoScroll(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXText_onQueryHelp(int argc, VALUE *argv, VALUE self) { FXText *arg1 = (FXText *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXText, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onQueryHelp(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXText_onQueryTip(int argc, VALUE *argv, VALUE self) { FXText *arg1 = (FXText *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXText, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onQueryTip(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXText_onCmdToggleEditable(int argc, VALUE *argv, VALUE self) { FXText *arg1 = (FXText *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXText, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdToggleEditable(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXText_onUpdToggleEditable(int argc, VALUE *argv, VALUE self) { FXText *arg1 = (FXText *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXText, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onUpdToggleEditable(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXText_onCmdToggleOverstrike(int argc, VALUE *argv, VALUE self) { FXText *arg1 = (FXText *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXText, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdToggleOverstrike(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXText_onUpdToggleOverstrike(int argc, VALUE *argv, VALUE self) { FXText *arg1 = (FXText *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXText, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onUpdToggleOverstrike(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXText_onCmdCursorRow(int argc, VALUE *argv, VALUE self) { FXText *arg1 = (FXText *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXText, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdCursorRow(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXText_onUpdCursorRow(int argc, VALUE *argv, VALUE self) { FXText *arg1 = (FXText *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXText, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onUpdCursorRow(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXText_onCmdCursorColumn(int argc, VALUE *argv, VALUE self) { FXText *arg1 = (FXText *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXText, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdCursorColumn(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXText_onUpdCursorColumn(int argc, VALUE *argv, VALUE self) { FXText *arg1 = (FXText *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXText, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onUpdCursorColumn(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXText_onUpdHaveSelection(int argc, VALUE *argv, VALUE self) { FXText *arg1 = (FXText *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXText, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onUpdHaveSelection(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXText_onUpdSelectAll(int argc, VALUE *argv, VALUE self) { FXText *arg1 = (FXText *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXText, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onUpdSelectAll(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXText_onCmdSetStringValue(int argc, VALUE *argv, VALUE self) { FXText *arg1 = (FXText *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; FXString value4 ;
    VALUE vresult = Qnil; if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXText, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); {
        value4 = FXString(STR2CSTR(argv[2])); arg4 = (void *) &value4; } 
    result = (long)(arg1)->onCmdSetStringValue(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXText_onCmdGetStringValue(int argc, VALUE *argv, VALUE self) { FXText *arg1 = (FXText *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXText, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdGetStringValue(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXText_onCmdSearch(int argc, VALUE *argv, VALUE self) { FXText *arg1 = (FXText *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXText, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdSearch(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXText_onCmdReplace(int argc, VALUE *argv, VALUE self) { FXText *arg1 = (FXText *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXText, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdReplace(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXText_onCmdSearchNext(int argc, VALUE *argv, VALUE self) { FXText *arg1 = (FXText *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXText, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdSearchNext(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXText_onCmdSearchSel(int argc, VALUE *argv, VALUE self) { FXText *arg1 = (FXText *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXText, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdSearchSel(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXText_onCmdCursorTop(int argc, VALUE *argv, VALUE self) { FXText *arg1 = (FXText *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXText, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdCursorTop(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXText_onCmdCursorBottom(int argc, VALUE *argv, VALUE self) { FXText *arg1 = (FXText *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXText, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdCursorBottom(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXText_onCmdCursorHome(int argc, VALUE *argv, VALUE self) { FXText *arg1 = (FXText *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXText, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdCursorHome(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXText_onCmdCursorEnd(int argc, VALUE *argv, VALUE self) { FXText *arg1 = (FXText *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXText, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdCursorEnd(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXText_onCmdCursorRight(int argc, VALUE *argv, VALUE self) { FXText *arg1 = (FXText *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXText, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdCursorRight(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXText_onCmdCursorLeft(int argc, VALUE *argv, VALUE self) { FXText *arg1 = (FXText *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXText, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdCursorLeft(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXText_onCmdCursorUp(int argc, VALUE *argv, VALUE self) { FXText *arg1 = (FXText *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXText, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdCursorUp(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXText_onCmdCursorDown(int argc, VALUE *argv, VALUE self) { FXText *arg1 = (FXText *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXText, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdCursorDown(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXText_onCmdCursorWordLeft(int argc, VALUE *argv, VALUE self) { FXText *arg1 = (FXText *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXText, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdCursorWordLeft(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXText_onCmdCursorWordRight(int argc, VALUE *argv, VALUE self) { FXText *arg1 = (FXText *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXText, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdCursorWordRight(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXText_onCmdCursorWordStart(int argc, VALUE *argv, VALUE self) { FXText *arg1 = (FXText *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXText, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdCursorWordStart(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXText_onCmdCursorWordEnd(int argc, VALUE *argv, VALUE self) { FXText *arg1 = (FXText *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXText, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdCursorWordEnd(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXText_onCmdCursorPageDown(int argc, VALUE *argv, VALUE self) { FXText *arg1 = (FXText *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXText, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdCursorPageDown(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXText_onCmdCursorPageUp(int argc, VALUE *argv, VALUE self) { FXText *arg1 = (FXText *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXText, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdCursorPageUp(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXText_onCmdCursorScreenTop(int argc, VALUE *argv, VALUE self) { FXText *arg1 = (FXText *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXText, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdCursorScreenTop(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXText_onCmdCursorScreenBottom(int argc, VALUE *argv, VALUE self) { FXText *arg1 = (FXText *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXText, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdCursorScreenBottom(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXText_onCmdCursorScreenCenter(int argc, VALUE *argv, VALUE self) { FXText *arg1 = (FXText *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXText, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdCursorScreenCenter(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXText_onCmdCursorParHome(int argc, VALUE *argv, VALUE self) { FXText *arg1 = (FXText *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXText, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdCursorParHome(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXText_onCmdCursorParEnd(int argc, VALUE *argv, VALUE self) { FXText *arg1 = (FXText *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXText, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdCursorParEnd(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXText_onCmdBlockBeg(int argc, VALUE *argv, VALUE self) { FXText *arg1 = (FXText *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXText, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdBlockBeg(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXText_onCmdBlockEnd(int argc, VALUE *argv, VALUE self) { FXText *arg1 = (FXText *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXText, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdBlockEnd(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXText_onCmdGotoMatching(int argc, VALUE *argv, VALUE self) { FXText *arg1 = (FXText *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXText, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdGotoMatching(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXText_onCmdGotoSelected(int argc, VALUE *argv, VALUE self) { FXText *arg1 = (FXText *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXText, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdGotoSelected(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXText_onCmdGotoLine(int argc, VALUE *argv, VALUE self) { FXText *arg1 = (FXText *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXText, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdGotoLine(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXText_onCmdScrollUp(int argc, VALUE *argv, VALUE self) { FXText *arg1 = (FXText *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXText, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdScrollUp(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXText_onCmdScrollDown(int argc, VALUE *argv, VALUE self) { FXText *arg1 = (FXText *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXText, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdScrollDown(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXText_onCmdMark(int argc, VALUE *argv, VALUE self) { FXText *arg1 = (FXText *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXText, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdMark(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXText_onCmdExtend(int argc, VALUE *argv, VALUE self) { FXText *arg1 = (FXText *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXText, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdExtend(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXText_onCmdOverstString(int argc, VALUE *argv, VALUE self) { FXText *arg1 = (FXText *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXText, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]);
    SWIG_ConvertPtr(argv[2], (void **) &arg4, 0, 1); result = (long)(arg1)->onCmdOverstString(arg2,arg3,arg4);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXText_onCmdInsertString(int argc, VALUE *argv, VALUE self) { FXText *arg1 = (FXText *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXText, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]);
    arg4 = static_cast<void*>(STR2CSTR(argv[2])); result = (long)(arg1)->onCmdInsertString(arg2,arg3,arg4);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXText_onCmdInsertNewline(int argc, VALUE *argv, VALUE self) { FXText *arg1 = (FXText *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXText, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdInsertNewline(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXText_onCmdInsertTab(int argc, VALUE *argv, VALUE self) { FXText *arg1 = (FXText *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXText, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdInsertTab(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXText_onCmdCutSel(int argc, VALUE *argv, VALUE self) { FXText *arg1 = (FXText *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXText, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdCutSel(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXText_onCmdCopySel(int argc, VALUE *argv, VALUE self) { FXText *arg1 = (FXText *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXText, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdCopySel(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXText_onCmdPasteSel(int argc, VALUE *argv, VALUE self) { FXText *arg1 = (FXText *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXText, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdPasteSel(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXText_onCmdDeleteSel(int argc, VALUE *argv, VALUE self) { FXText *arg1 = (FXText *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXText, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdDeleteSel(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXText_onCmdChangeCase(int argc, VALUE *argv, VALUE self) { FXText *arg1 = (FXText *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXText, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdChangeCase(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXText_onCmdShiftText(int argc, VALUE *argv, VALUE self) { FXText *arg1 = (FXText *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXText, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdShiftText(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXText_onCmdPasteMiddle(int argc, VALUE *argv, VALUE self) { FXText *arg1 = (FXText *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXText, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdPasteMiddle(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXText_onCmdSelectChar(int argc, VALUE *argv, VALUE self) { FXText *arg1 = (FXText *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXText, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdSelectChar(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXText_onCmdSelectWord(int argc, VALUE *argv, VALUE self) { FXText *arg1 = (FXText *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXText, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdSelectWord(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXText_onCmdSelectLine(int argc, VALUE *argv, VALUE self) { FXText *arg1 = (FXText *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXText, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdSelectLine(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXText_onCmdSelectAll(int argc, VALUE *argv, VALUE self) { FXText *arg1 = (FXText *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXText, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdSelectAll(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXText_onCmdSelectMatching(int argc, VALUE *argv, VALUE self) { FXText *arg1 = (FXText *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXText, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdSelectMatching(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXText_onCmdSelectBlock(int argc, VALUE *argv, VALUE self) { FXText *arg1 = (FXText *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXText, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdSelectBlock(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXText_onCmdDeselectAll(int argc, VALUE *argv, VALUE self) { FXText *arg1 = (FXText *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXText, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdDeselectAll(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXText_onCmdBackspace(int argc, VALUE *argv, VALUE self) { FXText *arg1 = (FXText *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXText, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdBackspace(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXText_onCmdBackspaceWord(int argc, VALUE *argv, VALUE self) { FXText *arg1 = (FXText *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXText, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdBackspaceWord(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXText_onCmdBackspaceBol(int argc, VALUE *argv, VALUE self) { FXText *arg1 = (FXText *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXText, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdBackspaceBol(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXText_onCmdDelete(int argc, VALUE *argv, VALUE self) { FXText *arg1 = (FXText *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXText, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdDelete(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXText_onCmdDeleteWord(int argc, VALUE *argv, VALUE self) { FXText *arg1 = (FXText *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXText, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdDeleteWord(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXText_onCmdDeleteEol(int argc, VALUE *argv, VALUE self) { FXText *arg1 = (FXText *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXText, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdDeleteEol(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXText_onCmdDeleteAll(int argc, VALUE *argv, VALUE self) { FXText *arg1 = (FXText *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXText, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdDeleteAll(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXText_onCmdDeleteLine(int argc, VALUE *argv, VALUE self) { FXText *arg1 = (FXText *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXText, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdDeleteLine(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE FXText_textDelimiters_get(VALUE self) { VALUE _val; _val = rb_str_new2(FXText::textDelimiters);    return _val; }
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE _wrap_FXText_allocate(VALUE self) {
#else
     static VALUE _wrap_FXText_allocate(int argc, VALUE *argv, VALUE self) {
#endif
         VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_FXText);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
         return vresult; }
static VALUE _wrap_new_FXText(int argc, VALUE *argv, VALUE self) { FXComposite *arg1 = (FXComposite *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 = (FXSelector) 0 ; FXuint arg4 = (FXuint) 0 ; FXint arg5 = (FXint) 0 ;
    FXint arg6 = (FXint) 0 ; FXint arg7 = (FXint) 0 ; FXint arg8 = (FXint) 0 ; FXText *result; if ((argc < 1) || (argc > 8))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXComposite, 1); if (argc > 1) {
        SWIG_ConvertPtr(argv[1], (void **) &arg2, SWIGTYPE_p_FXObject, 1); }  if (argc > 2) { arg3 = NUM2UINT(argv[2]); } 
    if (argc > 3) { arg4 = NUM2UINT(argv[3]); }  if (argc > 4) { arg5 = NUM2INT(argv[4]); }  if (argc > 5) {
        arg6 = NUM2INT(argv[5]); }  if (argc > 6) { arg7 = NUM2INT(argv[6]); }  if (argc > 7) { arg8 = NUM2INT(argv[7]); }  {
        result = (FXText *)new_FXText(arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8);
        DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result); if(rb_block_given_p()){ rb_yield(self); }  }  return self; }
static VALUE _wrap_FXText_setMarginTop(int argc, VALUE *argv, VALUE self) { FXText *arg1 = (FXText *) 0 ; FXint arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXText, 1); arg2 = NUM2INT(argv[0]); (arg1)->setMarginTop(arg2);
    return Qnil; }
static VALUE _wrap_FXText_getMarginTop(int argc, VALUE *argv, VALUE self) { FXText *arg1 = (FXText *) 0 ; FXint result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXText, 1); result = (FXint)((FXText const *)arg1)->getMarginTop();
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXText_setMarginBottom(int argc, VALUE *argv, VALUE self) { FXText *arg1 = (FXText *) 0 ; FXint arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXText, 1); arg2 = NUM2INT(argv[0]); (arg1)->setMarginBottom(arg2);
    return Qnil; }
static VALUE _wrap_FXText_getMarginBottom(int argc, VALUE *argv, VALUE self) { FXText *arg1 = (FXText *) 0 ; FXint result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXText, 1); result = (FXint)((FXText const *)arg1)->getMarginBottom();
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXText_setMarginLeft(int argc, VALUE *argv, VALUE self) { FXText *arg1 = (FXText *) 0 ; FXint arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXText, 1); arg2 = NUM2INT(argv[0]); (arg1)->setMarginLeft(arg2);
    return Qnil; }
static VALUE _wrap_FXText_getMarginLeft(int argc, VALUE *argv, VALUE self) { FXText *arg1 = (FXText *) 0 ; FXint result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXText, 1); result = (FXint)((FXText const *)arg1)->getMarginLeft();
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXText_setMarginRight(int argc, VALUE *argv, VALUE self) { FXText *arg1 = (FXText *) 0 ; FXint arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXText, 1); arg2 = NUM2INT(argv[0]); (arg1)->setMarginRight(arg2);
    return Qnil; }
static VALUE _wrap_FXText_getMarginRight(int argc, VALUE *argv, VALUE self) { FXText *arg1 = (FXText *) 0 ; FXint result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXText, 1); result = (FXint)((FXText const *)arg1)->getMarginRight();
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXText_getWrapColumns(int argc, VALUE *argv, VALUE self) { FXText *arg1 = (FXText *) 0 ; FXint result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXText, 1); result = (FXint)((FXText const *)arg1)->getWrapColumns();
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXText_setWrapColumns(int argc, VALUE *argv, VALUE self) { FXText *arg1 = (FXText *) 0 ; FXint arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXText, 1); arg2 = NUM2INT(argv[0]); (arg1)->setWrapColumns(arg2);
    return Qnil; }
static VALUE _wrap_FXText_getTabColumns(int argc, VALUE *argv, VALUE self) { FXText *arg1 = (FXText *) 0 ; FXint result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXText, 1); result = (FXint)((FXText const *)arg1)->getTabColumns();
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXText_setTabColumns(int argc, VALUE *argv, VALUE self) { FXText *arg1 = (FXText *) 0 ; FXint arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXText, 1); arg2 = NUM2INT(argv[0]); (arg1)->setTabColumns(arg2);
    return Qnil; }
static VALUE _wrap_FXText_getBarColumns(int argc, VALUE *argv, VALUE self) { FXText *arg1 = (FXText *) 0 ; FXint result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXText, 1); result = (FXint)((FXText const *)arg1)->getBarColumns();
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXText_setBarColumns(int argc, VALUE *argv, VALUE self) { FXText *arg1 = (FXText *) 0 ; FXint arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXText, 1); arg2 = NUM2INT(argv[0]); (arg1)->setBarColumns(arg2);
    return Qnil; }
static VALUE _wrap_FXText_isModified(int argc, VALUE *argv, VALUE self) { FXText *arg1 = (FXText *) 0 ; FXbool result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXText, 1); result = (FXbool)((FXText const *)arg1)->isModified();
    vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXText_setModified(int argc, VALUE *argv, VALUE self) { FXText *arg1 = (FXText *) 0 ;
    FXbool arg2 = (FXbool) 1 ; if ((argc < 0) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXText, 1); if (argc > 0) { arg2 = to_FXbool(argv[0]); } 
    (arg1)->setModified(arg2); return Qnil; }
static VALUE _wrap_FXText_isEditable(int argc, VALUE *argv, VALUE self) { FXText *arg1 = (FXText *) 0 ; FXbool result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXText, 1); result = (FXbool)((FXText const *)arg1)->isEditable();
    vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXText_setEditable(int argc, VALUE *argv, VALUE self) { FXText *arg1 = (FXText *) 0 ;
    FXbool arg2 = (FXbool) 1 ; if ((argc < 0) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXText, 1); if (argc > 0) { arg2 = to_FXbool(argv[0]); } 
    (arg1)->setEditable(arg2); return Qnil; }
static VALUE _wrap_FXText_setStyled(int argc, VALUE *argv, VALUE self) { FXText *arg1 = (FXText *) 0 ;
    FXbool arg2 = (FXbool) 1 ; if ((argc < 0) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXText, 1); if (argc > 0) { arg2 = to_FXbool(argv[0]); } 
    (arg1)->setStyled(arg2); return Qnil; }
static VALUE _wrap_FXText_isStyled(int argc, VALUE *argv, VALUE self) { FXText *arg1 = (FXText *) 0 ; FXbool result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXText, 1); result = (FXbool)((FXText const *)arg1)->isStyled();
    vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXText_setDelimiters(int argc, VALUE *argv, VALUE self) { FXText *arg1 = (FXText *) 0 ;
    FXchar *arg2 = (FXchar *) FXText::textDelimiters ; if ((argc < 0) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc); SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXText, 1);
    if (argc > 0) { arg2 = StringValuePtr(argv[0]); }  (arg1)->setDelimiters((FXchar const *)arg2); return Qnil; }
static VALUE _wrap_FXText_getDelimiters(int argc, VALUE *argv, VALUE self) { FXText *arg1 = (FXText *) 0 ; FXchar *result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXText, 1); result = (FXchar *)((FXText const *)arg1)->getDelimiters();
    vresult = rb_str_new2(result); return vresult; }
static VALUE _wrap_FXText_setFont(int argc, VALUE *argv, VALUE self) { FXText *arg1 = (FXText *) 0 ;
    FXFont *arg2 = (FXFont *) 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXText, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXFont, 1); (arg1)->setFont(arg2); return Qnil; }
static VALUE _wrap_FXText_getFont(int argc, VALUE *argv, VALUE self) { FXText *arg1 = (FXText *) 0 ; FXFont *result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXText, 1); result = (FXFont *)((FXText const *)arg1)->getFont(); {
        swig_type_info *ty = SWIG_TypeDynamicCast(SWIGTYPE_p_FXFont, (void **) &result); vresult = FXRbGetRubyObj(result, ty); }
     return vresult; }
static VALUE _wrap_FXText_setTextColor(int argc, VALUE *argv, VALUE self) { FXText *arg1 = (FXText *) 0 ; FXColor arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXText, 1); arg2 = to_FXColor(argv[0]); (arg1)->setTextColor(arg2);
    return Qnil; }
static VALUE _wrap_FXText_getTextColor(int argc, VALUE *argv, VALUE self) { FXText *arg1 = (FXText *) 0 ; FXColor result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXText, 1); result = (FXColor)((FXText const *)arg1)->getTextColor();
    vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXText_setSelBackColor(int argc, VALUE *argv, VALUE self) { FXText *arg1 = (FXText *) 0 ; FXColor arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXText, 1); arg2 = to_FXColor(argv[0]); (arg1)->setSelBackColor(arg2);
    return Qnil; }
static VALUE _wrap_FXText_getSelBackColor(int argc, VALUE *argv, VALUE self) { FXText *arg1 = (FXText *) 0 ; FXColor result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXText, 1); result = (FXColor)((FXText const *)arg1)->getSelBackColor();
    vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXText_setSelTextColor(int argc, VALUE *argv, VALUE self) { FXText *arg1 = (FXText *) 0 ; FXColor arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXText, 1); arg2 = to_FXColor(argv[0]); (arg1)->setSelTextColor(arg2);
    return Qnil; }
static VALUE _wrap_FXText_getSelTextColor(int argc, VALUE *argv, VALUE self) { FXText *arg1 = (FXText *) 0 ; FXColor result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXText, 1); result = (FXColor)((FXText const *)arg1)->getSelTextColor();
    vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXText_setHiliteTextColor(int argc, VALUE *argv, VALUE self) { FXText *arg1 = (FXText *) 0 ; FXColor arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXText, 1); arg2 = to_FXColor(argv[0]); (arg1)->setHiliteTextColor(arg2);
    return Qnil; }
static VALUE _wrap_FXText_getHiliteTextColor(int argc, VALUE *argv, VALUE self) { FXText *arg1 = (FXText *) 0 ; FXColor result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXText, 1);
    result = (FXColor)((FXText const *)arg1)->getHiliteTextColor(); vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXText_setHiliteBackColor(int argc, VALUE *argv, VALUE self) { FXText *arg1 = (FXText *) 0 ; FXColor arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXText, 1); arg2 = to_FXColor(argv[0]); (arg1)->setHiliteBackColor(arg2);
    return Qnil; }
static VALUE _wrap_FXText_getHiliteBackColor(int argc, VALUE *argv, VALUE self) { FXText *arg1 = (FXText *) 0 ; FXColor result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXText, 1);
    result = (FXColor)((FXText const *)arg1)->getHiliteBackColor(); vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXText_setActiveBackColor(int argc, VALUE *argv, VALUE self) { FXText *arg1 = (FXText *) 0 ; FXColor arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXText, 1); arg2 = to_FXColor(argv[0]); (arg1)->setActiveBackColor(arg2);
    return Qnil; }
static VALUE _wrap_FXText_getActiveBackColor(int argc, VALUE *argv, VALUE self) { FXText *arg1 = (FXText *) 0 ; FXColor result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXText, 1);
    result = (FXColor)((FXText const *)arg1)->getActiveBackColor(); vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXText_setCursorColor(int argc, VALUE *argv, VALUE self) { FXText *arg1 = (FXText *) 0 ; FXColor arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXText, 1); arg2 = to_FXColor(argv[0]); (arg1)->setCursorColor(arg2);
    return Qnil; }
static VALUE _wrap_FXText_getCursorColor(int argc, VALUE *argv, VALUE self) { FXText *arg1 = (FXText *) 0 ; FXColor result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXText, 1); result = (FXColor)((FXText const *)arg1)->getCursorColor();
    vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXText_setNumberColor(int argc, VALUE *argv, VALUE self) { FXText *arg1 = (FXText *) 0 ; FXColor arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXText, 1); arg2 = to_FXColor(argv[0]); (arg1)->setNumberColor(arg2);
    return Qnil; }
static VALUE _wrap_FXText_getNumberColor(int argc, VALUE *argv, VALUE self) { FXText *arg1 = (FXText *) 0 ; FXColor result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXText, 1); result = (FXColor)((FXText const *)arg1)->getNumberColor();
    vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXText_setBarColor(int argc, VALUE *argv, VALUE self) { FXText *arg1 = (FXText *) 0 ; FXColor arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXText, 1); arg2 = to_FXColor(argv[0]); (arg1)->setBarColor(arg2);
    return Qnil; }
static VALUE _wrap_FXText_getBarColor(int argc, VALUE *argv, VALUE self) { FXText *arg1 = (FXText *) 0 ; FXColor result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXText, 1); result = (FXColor)((FXText const *)arg1)->getBarColor();
    vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXText_setHelpText(int argc, VALUE *argv, VALUE self) { FXText *arg1 = (FXText *) 0 ; FXString *arg2 = 0 ;
    SwigValueWrapper<FXString > p2 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc); SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXText, 1);
    p2 = to_FXString(argv[0]); arg2 = &p2; (arg1)->setHelpText((FXString const &)*arg2); return Qnil; }
static VALUE _wrap_FXText_getHelpText(int argc, VALUE *argv, VALUE self) { FXText *arg1 = (FXText *) 0 ; FXString result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXText, 1); result = ((FXText const *)arg1)->getHelpText();
    vresult = rb_str_new2((&result)->text()); return vresult; }
static VALUE _wrap_FXText_setTipText(int argc, VALUE *argv, VALUE self) { FXText *arg1 = (FXText *) 0 ; FXString *arg2 = 0 ;
    SwigValueWrapper<FXString > p2 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc); SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXText, 1);
    p2 = to_FXString(argv[0]); arg2 = &p2; (arg1)->setTipText((FXString const &)*arg2); return Qnil; }
static VALUE _wrap_FXText_getTipText(int argc, VALUE *argv, VALUE self) { FXText *arg1 = (FXText *) 0 ; FXString result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXText, 1); result = ((FXText const *)arg1)->getTipText();
    vresult = rb_str_new2((&result)->text()); return vresult; }
static VALUE _wrap_FXText_getChar(int argc, VALUE *argv, VALUE self) { FXText *arg1 = (FXText *) 0 ; FXint arg2 ; FXint result;
    VALUE vresult = Qnil; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXText, 1); arg2 = NUM2INT(argv[0]);
    result = (FXint)((FXText const *)arg1)->getChar(arg2); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXText_getStyle(int argc, VALUE *argv, VALUE self) { FXText *arg1 = (FXText *) 0 ; FXint arg2 ; FXint result;
    VALUE vresult = Qnil; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXText, 1); arg2 = NUM2INT(argv[0]);
    result = (FXint)((FXText const *)arg1)->getStyle(arg2); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXText_extractText(int argc, VALUE *argv, VALUE self) { FXText *arg1 = (FXText *) 0 ; FXint arg2 ;
    FXint arg3 ; VALUE result; VALUE vresult = Qnil; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc); SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXText, 1);
    arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]); result = (VALUE)FXText_extractText((FXText const *)arg1,arg2,arg3);
    vresult = result; return vresult; }
static VALUE _wrap_FXText_extractStyle(int argc, VALUE *argv, VALUE self) { FXText *arg1 = (FXText *) 0 ; FXint arg2 ;
    FXint arg3 ; VALUE result; VALUE vresult = Qnil; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc); SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXText, 1);
    arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]); result = (VALUE)FXText_extractStyle((FXText const *)arg1,arg2,arg3);
    vresult = result; return vresult; }
static VALUE _wrap_FXText_replaceText(int argc, VALUE *argv, VALUE self) { FXText *arg1 = (FXText *) 0 ; FXint arg2 ;
    FXint arg3 ; FXString *arg4 = 0 ; FXbool arg5 = (FXbool) 0 ; SwigValueWrapper<FXString > p4 ; if ((argc < 3) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc); SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXText, 1);
    arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]); p4 = to_FXString(argv[2]); arg4 = &p4; if (argc > 3) {
        arg5 = to_FXbool(argv[3]); }  FXText_replaceText(arg1,arg2,arg3,(FXString const &)*arg4,arg5); return Qnil; }
static VALUE _wrap_FXText_replaceStyledText(int argc, VALUE *argv, VALUE self) { FXText *arg1 = (FXText *) 0 ; FXint arg2 ;
    FXint arg3 ; FXString *arg4 = 0 ; FXint arg5 = (FXint) 0 ; FXbool arg6 = (FXbool) 0 ; SwigValueWrapper<FXString > p4 ;
    if ((argc < 3) || (argc > 5)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXText, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    p4 = to_FXString(argv[2]); arg4 = &p4; if (argc > 3) { arg5 = NUM2INT(argv[3]); }  if (argc > 4) {
        arg6 = to_FXbool(argv[4]); }  FXText_replaceStyledText(arg1,arg2,arg3,(FXString const &)*arg4,arg5,arg6); return Qnil; }
static VALUE _wrap_FXText_appendText(int argc, VALUE *argv, VALUE self) { FXText *arg1 = (FXText *) 0 ; FXString *arg2 = 0 ;
    FXbool arg3 = (FXbool) 0 ; SwigValueWrapper<FXString > p2 ; if ((argc < 1) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc); SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXText, 1);
    p2 = to_FXString(argv[0]); arg2 = &p2; if (argc > 1) { arg3 = to_FXbool(argv[1]); } 
    FXText_appendText(arg1,(FXString const &)*arg2,arg3); return Qnil; }
static VALUE _wrap_FXText_appendStyledText(int argc, VALUE *argv, VALUE self) { FXText *arg1 = (FXText *) 0 ;
    FXString *arg2 = 0 ; FXint arg3 = (FXint) 0 ; FXbool arg4 = (FXbool) 0 ; SwigValueWrapper<FXString > p2 ;
    if ((argc < 1) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXText, 1); p2 = to_FXString(argv[0]); arg2 = &p2; if (argc > 1) {
        arg3 = NUM2INT(argv[1]); }  if (argc > 2) { arg4 = to_FXbool(argv[2]); } 
    FXText_appendStyledText(arg1,(FXString const &)*arg2,arg3,arg4); return Qnil; }
static VALUE _wrap_FXText_insertText(int argc, VALUE *argv, VALUE self) { FXText *arg1 = (FXText *) 0 ; FXint arg2 ;
    FXString *arg3 = 0 ; FXbool arg4 = (FXbool) 0 ; SwigValueWrapper<FXString > p3 ; if ((argc < 2) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc); SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXText, 1);
    arg2 = NUM2INT(argv[0]); p3 = to_FXString(argv[1]); arg3 = &p3; if (argc > 2) { arg4 = to_FXbool(argv[2]); } 
    FXText_insertText(arg1,arg2,(FXString const &)*arg3,arg4); return Qnil; }
static VALUE _wrap_FXText_insertStyledText(int argc, VALUE *argv, VALUE self) { FXText *arg1 = (FXText *) 0 ; FXint arg2 ;
    FXString *arg3 = 0 ; FXint arg4 = (FXint) 0 ; FXbool arg5 = (FXbool) 0 ; SwigValueWrapper<FXString > p3 ;
    if ((argc < 2) || (argc > 4)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXText, 1); arg2 = NUM2INT(argv[0]);
    p3 = to_FXString(argv[1]); arg3 = &p3; if (argc > 2) { arg4 = NUM2INT(argv[2]); }  if (argc > 3) {
        arg5 = to_FXbool(argv[3]); }  FXText_insertStyledText(arg1,arg2,(FXString const &)*arg3,arg4,arg5); return Qnil; }
static VALUE _wrap_FXText_removeText(int argc, VALUE *argv, VALUE self) { FXText *arg1 = (FXText *) 0 ; FXint arg2 ;
    FXint arg3 ; FXbool arg4 = (FXbool) 0 ; if ((argc < 2) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc); SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXText, 1);
    arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]); if (argc > 2) { arg4 = to_FXbool(argv[2]); } 
    (arg1)->removeText(arg2,arg3,arg4); return Qnil; }
static VALUE _wrap_FXText_changeStyle__SWIG_0(int argc, VALUE *argv, VALUE self) { FXText *arg1 = (FXText *) 0 ; FXint arg2 ;
    FXint arg3 ; FXint arg4 ; if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXText, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    arg4 = NUM2INT(argv[2]); (arg1)->changeStyle(arg2,arg3,arg4); return Qnil; }
static VALUE _wrap_FXText_changeStyle__SWIG_1(int argc, VALUE *argv, VALUE self) { FXText *arg1 = (FXText *) 0 ; FXint arg2 ;
    FXint arg3 ; FXchar *arg4 ; if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXText, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    arg4 = StringValuePtr(argv[2]); (arg1)->changeStyle(arg2,arg3,(FXchar const *)arg4); return Qnil; }
static VALUE _wrap_FXText_changeStyle(int nargs, VALUE *args, VALUE self) { int argc; VALUE argv[5]; int ii; argc = nargs + 1;
    argv[0] = self; for (ii = 1; (ii < argc) && (ii < 4); ii++) { argv[ii] = args[ii-1]; }  if (argc == 4) { int _v; {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXText, 0) != -1)) ? 1 : 0; }
         if (_v) { { _v = ((TYPE(argv[1]) == T_FIXNUM) || (TYPE(argv[1]) == T_BIGNUM)) ? 1 : 0; }  if (_v) { {
                    _v = ((TYPE(argv[2]) == T_FIXNUM) || (TYPE(argv[2]) == T_BIGNUM)) ? 1 : 0; }  if (_v) { {
                        _v = ((TYPE(argv[3]) == T_FIXNUM) || (TYPE(argv[3]) == T_BIGNUM)) ? 1 : 0; }  if (_v) {
                        return _wrap_FXText_changeStyle__SWIG_0(nargs, args, self);}  }  }  }  }  if (argc == 4) { int _v; {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXText, 0) != -1)) ? 1 : 0; }
         if (_v) { { _v = ((TYPE(argv[1]) == T_FIXNUM) || (TYPE(argv[1]) == T_BIGNUM)) ? 1 : 0; }  if (_v) { {
                    _v = ((TYPE(argv[2]) == T_FIXNUM) || (TYPE(argv[2]) == T_BIGNUM)) ? 1 : 0; }  if (_v) { {
                        _v = (TYPE(argv[3]) == T_STRING) ? 1 : 0; }  if (_v) {
                        return _wrap_FXText_changeStyle__SWIG_1(nargs, args, self);}  }  }  }  } 
    rb_raise(rb_eArgError, "No matching function for overloaded 'FXText_changeStyle'"); return Qnil; }
static VALUE _wrap_FXText_setText(int argc, VALUE *argv, VALUE self) { FXText *arg1 = (FXText *) 0 ; FXString *arg2 = 0 ;
    FXbool arg3 = (FXbool) 0 ; SwigValueWrapper<FXString > p2 ; if ((argc < 1) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc); SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXText, 1);
    p2 = to_FXString(argv[0]); arg2 = &p2; if (argc > 1) { arg3 = to_FXbool(argv[1]); } 
    (arg1)->setText((FXString const &)*arg2,arg3); return Qnil; }
static VALUE _wrap_FXText_setStyledText(int argc, VALUE *argv, VALUE self) { FXText *arg1 = (FXText *) 0 ; FXString *arg2 = 0 ;
    FXint arg3 = (FXint) 0 ; FXbool arg4 = (FXbool) 0 ; SwigValueWrapper<FXString > p2 ; if ((argc < 1) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc); SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXText, 1);
    p2 = to_FXString(argv[0]); arg2 = &p2; if (argc > 1) { arg3 = NUM2INT(argv[1]); }  if (argc > 2) {
        arg4 = to_FXbool(argv[2]); }  (arg1)->setStyledText((FXString const &)*arg2,arg3,arg4); return Qnil; }
static VALUE _wrap_FXText_getText(int argc, VALUE *argv, VALUE self) { FXText *arg1 = (FXText *) 0 ; FXString result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXText, 1); result = ((FXText const *)arg1)->getText();
    vresult = rb_str_new2((&result)->text()); return vresult; }
static VALUE _wrap_FXText_getLength(int argc, VALUE *argv, VALUE self) { FXText *arg1 = (FXText *) 0 ; FXint result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXText, 1); result = (FXint)((FXText const *)arg1)->getLength();
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXText_shiftText(int argc, VALUE *argv, VALUE self) { FXText *arg1 = (FXText *) 0 ; FXint arg2 ; FXint arg3 ;
    FXint arg4 ; FXbool arg5 = (FXbool) 0 ; FXint result; VALUE vresult = Qnil; if ((argc < 3) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc); SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXText, 1);
    arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]); arg4 = NUM2INT(argv[2]); if (argc > 3) { arg5 = to_FXbool(argv[3]); } 
    result = (FXint)(arg1)->shiftText(arg2,arg3,arg4,arg5); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXText_findText(int argc, VALUE *argv, VALUE self) { FXText *arg1 = (FXText *) 0 ; FXString *arg2 = 0 ;
    FXint arg3 = (FXint) 0 ; FXuint arg4 = (FXuint) SEARCH_FORWARD|SEARCH_WRAP|SEARCH_EXACT ; FXint arg5 = (FXint) 1 ;
    VALUE result; SwigValueWrapper<FXString > p2 ; VALUE vresult = Qnil; if ((argc < 1) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc); SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXText, 1);
    p2 = to_FXString(argv[0]); arg2 = &p2; if (argc > 1) { arg3 = NUM2INT(argv[1]); }  if (argc > 2) {
        arg4 = NUM2UINT(argv[2]); }  if (argc > 3) { arg5 = NUM2INT(argv[3]); } 
    result = (VALUE)FXText_findText(arg1,(FXString const &)*arg2,arg3,arg4,arg5); vresult = result; return vresult; }
static VALUE _wrap_FXText_isPosSelected(int argc, VALUE *argv, VALUE self) { FXText *arg1 = (FXText *) 0 ; FXint arg2 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc); SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXText, 1);
    arg2 = NUM2INT(argv[0]); result = (FXbool)((FXText const *)arg1)->isPosSelected(arg2); vresult = result ? Qtrue : Qfalse;
    return vresult; }
static VALUE _wrap_FXText_isPosVisible(int argc, VALUE *argv, VALUE self) { FXText *arg1 = (FXText *) 0 ; FXint arg2 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc); SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXText, 1);
    arg2 = NUM2INT(argv[0]); result = (FXbool)((FXText const *)arg1)->isPosVisible(arg2); vresult = result ? Qtrue : Qfalse;
    return vresult; }
static VALUE _wrap_FXText_getPosAt(int argc, VALUE *argv, VALUE self) { FXText *arg1 = (FXText *) 0 ; FXint arg2 ; FXint arg3 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc); SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXText, 1);
    arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]); result = (FXint)((FXText const *)arg1)->getPosAt(arg2,arg3);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXText_lineStart(int argc, VALUE *argv, VALUE self) { FXText *arg1 = (FXText *) 0 ; FXint arg2 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc); SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXText, 1);
    arg2 = NUM2INT(argv[0]); result = (FXint)((FXText const *)arg1)->lineStart(arg2); vresult = INT2NUM(result);
    return vresult; }
static VALUE _wrap_FXText_lineEnd(int argc, VALUE *argv, VALUE self) { FXText *arg1 = (FXText *) 0 ; FXint arg2 ; FXint result;
    VALUE vresult = Qnil; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXText, 1); arg2 = NUM2INT(argv[0]);
    result = (FXint)((FXText const *)arg1)->lineEnd(arg2); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXText_nextLine(int argc, VALUE *argv, VALUE self) { FXText *arg1 = (FXText *) 0 ; FXint arg2 ;
    FXint arg3 = (FXint) 1 ; FXint result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc); SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXText, 1);
    arg2 = NUM2INT(argv[0]); if (argc > 1) { arg3 = NUM2INT(argv[1]); } 
    result = (FXint)((FXText const *)arg1)->nextLine(arg2,arg3); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXText_prevLine(int argc, VALUE *argv, VALUE self) { FXText *arg1 = (FXText *) 0 ; FXint arg2 ;
    FXint arg3 = (FXint) 1 ; FXint result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc); SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXText, 1);
    arg2 = NUM2INT(argv[0]); if (argc > 1) { arg3 = NUM2INT(argv[1]); } 
    result = (FXint)((FXText const *)arg1)->prevLine(arg2,arg3); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXText_rowStart(int argc, VALUE *argv, VALUE self) { FXText *arg1 = (FXText *) 0 ; FXint arg2 ; FXint result;
    VALUE vresult = Qnil; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXText, 1); arg2 = NUM2INT(argv[0]);
    result = (FXint)((FXText const *)arg1)->rowStart(arg2); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXText_rowEnd(int argc, VALUE *argv, VALUE self) { FXText *arg1 = (FXText *) 0 ; FXint arg2 ; FXint result;
    VALUE vresult = Qnil; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXText, 1); arg2 = NUM2INT(argv[0]);
    result = (FXint)((FXText const *)arg1)->rowEnd(arg2); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXText_nextRow(int argc, VALUE *argv, VALUE self) { FXText *arg1 = (FXText *) 0 ; FXint arg2 ;
    FXint arg3 = (FXint) 1 ; FXint result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc); SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXText, 1);
    arg2 = NUM2INT(argv[0]); if (argc > 1) { arg3 = NUM2INT(argv[1]); } 
    result = (FXint)((FXText const *)arg1)->nextRow(arg2,arg3); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXText_prevRow(int argc, VALUE *argv, VALUE self) { FXText *arg1 = (FXText *) 0 ; FXint arg2 ;
    FXint arg3 = (FXint) 1 ; FXint result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc); SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXText, 1);
    arg2 = NUM2INT(argv[0]); if (argc > 1) { arg3 = NUM2INT(argv[1]); } 
    result = (FXint)((FXText const *)arg1)->prevRow(arg2,arg3); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXText_leftWord(int argc, VALUE *argv, VALUE self) { FXText *arg1 = (FXText *) 0 ; FXint arg2 ; FXint result;
    VALUE vresult = Qnil; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXText, 1); arg2 = NUM2INT(argv[0]);
    result = (FXint)((FXText const *)arg1)->leftWord(arg2); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXText_rightWord(int argc, VALUE *argv, VALUE self) { FXText *arg1 = (FXText *) 0 ; FXint arg2 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc); SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXText, 1);
    arg2 = NUM2INT(argv[0]); result = (FXint)((FXText const *)arg1)->rightWord(arg2); vresult = INT2NUM(result);
    return vresult; }
static VALUE _wrap_FXText_wordStart(int argc, VALUE *argv, VALUE self) { FXText *arg1 = (FXText *) 0 ; FXint arg2 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc); SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXText, 1);
    arg2 = NUM2INT(argv[0]); result = (FXint)((FXText const *)arg1)->wordStart(arg2); vresult = INT2NUM(result);
    return vresult; }
static VALUE _wrap_FXText_wordEnd(int argc, VALUE *argv, VALUE self) { FXText *arg1 = (FXText *) 0 ; FXint arg2 ; FXint result;
    VALUE vresult = Qnil; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXText, 1); arg2 = NUM2INT(argv[0]);
    result = (FXint)((FXText const *)arg1)->wordEnd(arg2); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXText_validPos(int argc, VALUE *argv, VALUE self) { FXText *arg1 = (FXText *) 0 ; FXint arg2 ; FXint result;
    VALUE vresult = Qnil; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXText, 1); arg2 = NUM2INT(argv[0]);
    result = (FXint)((FXText const *)arg1)->validPos(arg2); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXText_setTopLine(int argc, VALUE *argv, VALUE self) { FXText *arg1 = (FXText *) 0 ; FXint arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXText, 1); arg2 = NUM2INT(argv[0]); (arg1)->setTopLine(arg2);
    return Qnil; }
static VALUE _wrap_FXText_getTopLine(int argc, VALUE *argv, VALUE self) { FXText *arg1 = (FXText *) 0 ; FXint result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXText, 1); result = (FXint)((FXText const *)arg1)->getTopLine();
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXText_setBottomLine(int argc, VALUE *argv, VALUE self) { FXText *arg1 = (FXText *) 0 ; FXint arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXText, 1); arg2 = NUM2INT(argv[0]); (arg1)->setBottomLine(arg2);
    return Qnil; }
static VALUE _wrap_FXText_getBottomLine(int argc, VALUE *argv, VALUE self) { FXText *arg1 = (FXText *) 0 ; FXint result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXText, 1); result = (FXint)((FXText const *)arg1)->getBottomLine();
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXText_setCenterLine(int argc, VALUE *argv, VALUE self) { FXText *arg1 = (FXText *) 0 ; FXint arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXText, 1); arg2 = NUM2INT(argv[0]); (arg1)->setCenterLine(arg2);
    return Qnil; }
static VALUE _wrap_FXText_setAnchorPos(int argc, VALUE *argv, VALUE self) { FXText *arg1 = (FXText *) 0 ; FXint arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXText, 1); arg2 = NUM2INT(argv[0]); (arg1)->setAnchorPos(arg2);
    return Qnil; }
static VALUE _wrap_FXText_getAnchorPos(int argc, VALUE *argv, VALUE self) { FXText *arg1 = (FXText *) 0 ; FXint result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXText, 1); result = (FXint)((FXText const *)arg1)->getAnchorPos();
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXText_setCursorRow(int argc, VALUE *argv, VALUE self) { FXText *arg1 = (FXText *) 0 ; FXint arg2 ;
    FXbool arg3 = (FXbool) 0 ; if ((argc < 1) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXText, 1); arg2 = NUM2INT(argv[0]); if (argc > 1) {
        arg3 = to_FXbool(argv[1]); }  (arg1)->setCursorRow(arg2,arg3); return Qnil; }
static VALUE _wrap_FXText_getCursorRow(int argc, VALUE *argv, VALUE self) { FXText *arg1 = (FXText *) 0 ; FXint result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXText, 1); result = (FXint)((FXText const *)arg1)->getCursorRow();
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXText_setCursorColumn(int argc, VALUE *argv, VALUE self) { FXText *arg1 = (FXText *) 0 ; FXint arg2 ;
    FXbool arg3 = (FXbool) 0 ; if ((argc < 1) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXText, 1); arg2 = NUM2INT(argv[0]); if (argc > 1) {
        arg3 = to_FXbool(argv[1]); }  (arg1)->setCursorColumn(arg2,arg3); return Qnil; }
static VALUE _wrap_FXText_getCursorColumn(int argc, VALUE *argv, VALUE self) { FXText *arg1 = (FXText *) 0 ; FXint result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXText, 1); result = (FXint)((FXText const *)arg1)->getCursorColumn();
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXText_getCursorPos(int argc, VALUE *argv, VALUE self) { FXText *arg1 = (FXText *) 0 ; FXint result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXText, 1); result = (FXint)((FXText const *)arg1)->getCursorPos();
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXText_getSelStartPos(int argc, VALUE *argv, VALUE self) { FXText *arg1 = (FXText *) 0 ; FXint result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXText, 1); result = (FXint)((FXText const *)arg1)->getSelStartPos();
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXText_getSelEndPos(int argc, VALUE *argv, VALUE self) { FXText *arg1 = (FXText *) 0 ; FXint result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXText, 1); result = (FXint)((FXText const *)arg1)->getSelEndPos();
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXText_selectAll(int argc, VALUE *argv, VALUE self) { FXText *arg1 = (FXText *) 0 ;
    FXbool arg2 = (FXbool) 0 ; FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc); SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXText, 1);
    if (argc > 0) { arg2 = to_FXbool(argv[0]); }  result = (FXbool)(arg1)->selectAll(arg2); vresult = result ? Qtrue : Qfalse;
    return vresult; }
static VALUE _wrap_FXText_setSelection(int argc, VALUE *argv, VALUE self) { FXText *arg1 = (FXText *) 0 ; FXint arg2 ;
    FXint arg3 ; FXbool arg4 = (FXbool) 0 ; FXbool result; VALUE vresult = Qnil; if ((argc < 2) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc); SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXText, 1);
    arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]); if (argc > 2) { arg4 = to_FXbool(argv[2]); } 
    result = (FXbool)(arg1)->setSelection(arg2,arg3,arg4); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXText_setHighlight(int argc, VALUE *argv, VALUE self) { FXText *arg1 = (FXText *) 0 ; FXint arg2 ;
    FXint arg3 ; FXbool result; VALUE vresult = Qnil; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc); SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXText, 1);
    arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]); result = (FXbool)(arg1)->setHighlight(arg2,arg3);
    vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXText_killHighlight(int argc, VALUE *argv, VALUE self) { FXText *arg1 = (FXText *) 0 ; FXbool result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXText, 1); result = (FXbool)(arg1)->killHighlight();
    vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXText_makePositionVisible(int argc, VALUE *argv, VALUE self) { FXText *arg1 = (FXText *) 0 ; FXint arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXText, 1); arg2 = NUM2INT(argv[0]); (arg1)->makePositionVisible(arg2);
    return Qnil; }
static VALUE _wrap_FXText_setTextStyle(int argc, VALUE *argv, VALUE self) { FXText *arg1 = (FXText *) 0 ; FXuint arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXText, 1); arg2 = NUM2UINT(argv[0]); (arg1)->setTextStyle(arg2);
    return Qnil; }
static VALUE _wrap_FXText_getTextStyle(int argc, VALUE *argv, VALUE self) { FXText *arg1 = (FXText *) 0 ; FXuint result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXText, 1); result = (FXuint)((FXText const *)arg1)->getTextStyle();
    vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXText_setVisibleRows(int argc, VALUE *argv, VALUE self) { FXText *arg1 = (FXText *) 0 ; FXint arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXText, 1); arg2 = NUM2INT(argv[0]); (arg1)->setVisibleRows(arg2);
    return Qnil; }
static VALUE _wrap_FXText_getVisibleRows(int argc, VALUE *argv, VALUE self) { FXText *arg1 = (FXText *) 0 ; FXint result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXText, 1); result = (FXint)((FXText const *)arg1)->getVisibleRows();
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXText_setVisibleColumns(int argc, VALUE *argv, VALUE self) { FXText *arg1 = (FXText *) 0 ; FXint arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXText, 1); arg2 = NUM2INT(argv[0]); (arg1)->setVisibleColumns(arg2);
    return Qnil; }
static VALUE _wrap_FXText_getVisibleColumns(int argc, VALUE *argv, VALUE self) { FXText *arg1 = (FXText *) 0 ; FXint result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXText, 1); result = (FXint)((FXText const *)arg1)->getVisibleColumns();
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXText_setHiliteMatchTime(int argc, VALUE *argv, VALUE self) { FXText *arg1 = (FXText *) 0 ; FXuint arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXText, 1); arg2 = NUM2UINT(argv[0]); (arg1)->setHiliteMatchTime(arg2);
    return Qnil; }
static VALUE _wrap_FXText_getHiliteMatchTime(int argc, VALUE *argv, VALUE self) { FXText *arg1 = (FXText *) 0 ; FXuint result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXText, 1); result = (FXuint)((FXText const *)arg1)->getHiliteMatchTime();
    vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXText_setHiliteStyles(int argc, VALUE *argv, VALUE self) { FXText *arg1 = (FXText *) 0 ; VALUE arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXText, 1); arg2 = argv[0]; FXText_setHiliteStyles(arg1,arg2);
    return Qnil; }
static VALUE _wrap_FXText_getHiliteStyles(int argc, VALUE *argv, VALUE self) { FXText *arg1 = (FXText *) 0 ; VALUE result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXText, 1); result = (VALUE)FXText_getHiliteStyles((FXText const *)arg1);
    vresult = result; return vresult; }
static void
free_FXText(FXText *arg1) {
    delete arg1;
}
static VALUE _wrap_FXText_save(int argc, VALUE *argv, VALUE self) { FXText *arg1 = (FXText *) 0 ; FXStream *arg2 = 0 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXText, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXText_save((FXText const *)arg1,*arg2); return Qnil; }
static VALUE _wrap_FXText_load(int argc, VALUE *argv, VALUE self) { FXText *arg1 = (FXText *) 0 ; FXStream *arg2 = 0 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXText, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXText_load(arg1,*arg2); return Qnil; }
static VALUE _wrap_FXText_create(int argc, VALUE *argv, VALUE self) { FXText *arg1 = (FXText *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXText, 1); FXText_create(arg1); return Qnil; }
static VALUE _wrap_FXText_detach(int argc, VALUE *argv, VALUE self) { FXText *arg1 = (FXText *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXText, 1); FXText_detach(arg1); return Qnil; }
static VALUE _wrap_FXText_destroy(int argc, VALUE *argv, VALUE self) { FXText *arg1 = (FXText *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXText, 1); FXText_destroy(arg1); return Qnil; }
static VALUE _wrap_FXText_resize(int argc, VALUE *argv, VALUE self) { FXText *arg1 = (FXText *) 0 ; FXint arg2 ; FXint arg3 ;
    if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXText, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    FXText_resize(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXText_getDefaultWidth(int argc, VALUE *argv, VALUE self) { FXText *arg1 = (FXText *) 0 ; FXint result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXText, 1); result = (FXint)FXText_getDefaultWidth(arg1);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXText_getDefaultHeight(int argc, VALUE *argv, VALUE self) { FXText *arg1 = (FXText *) 0 ; FXint result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXText, 1); result = (FXint)FXText_getDefaultHeight(arg1);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXText_getWidthForHeight(int argc, VALUE *argv, VALUE self) { FXText *arg1 = (FXText *) 0 ; FXint arg2 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc); SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXText, 1);
    arg2 = NUM2INT(argv[0]); result = (FXint)FXText_getWidthForHeight(arg1,arg2); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXText_getHeightForWidth(int argc, VALUE *argv, VALUE self) { FXText *arg1 = (FXText *) 0 ; FXint arg2 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc); SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXText, 1);
    arg2 = NUM2INT(argv[0]); result = (FXint)FXText_getHeightForWidth(arg1,arg2); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXText_canFocus(int argc, VALUE *argv, VALUE self) { FXText *arg1 = (FXText *) 0 ; FXbool result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXText, 1); result = (FXbool)FXText_canFocus((FXText const *)arg1);
    vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXText_setFocus(int argc, VALUE *argv, VALUE self) { FXText *arg1 = (FXText *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXText, 1); FXText_setFocus(arg1); return Qnil; }
static VALUE _wrap_FXText_killFocus(int argc, VALUE *argv, VALUE self) { FXText *arg1 = (FXText *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXText, 1); FXText_killFocus(arg1); return Qnil; }
static VALUE _wrap_FXText_setDefault(int argc, VALUE *argv, VALUE self) { FXText *arg1 = (FXText *) 0 ;
    FXbool arg2 = (FXbool) 1 ; if ((argc < 0) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXText, 1); if (argc > 0) { arg2 = to_FXbool(argv[0]); } 
    FXText_setDefault(arg1,arg2); return Qnil; }
static VALUE _wrap_FXText_enable(int argc, VALUE *argv, VALUE self) { FXText *arg1 = (FXText *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXText, 1); FXText_enable(arg1); return Qnil; }
static VALUE _wrap_FXText_disable(int argc, VALUE *argv, VALUE self) { FXText *arg1 = (FXText *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXText, 1); FXText_disable(arg1); return Qnil; }
static VALUE _wrap_FXText_raiseWindow(int argc, VALUE *argv, VALUE self) { FXText *arg1 = (FXText *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXText, 1); FXText_raise(arg1); return Qnil; }
static VALUE _wrap_FXText_lower(int argc, VALUE *argv, VALUE self) { FXText *arg1 = (FXText *) 0 ; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc); SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXText, 1);
    FXText_lower(arg1); return Qnil; }
static VALUE _wrap_FXText_move(int argc, VALUE *argv, VALUE self) { FXText *arg1 = (FXText *) 0 ; FXint arg2 ; FXint arg3 ;
    if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXText, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    FXText_move(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXText_position__SWIG_0(int argc, VALUE *argv, VALUE self) { FXText *arg1 = (FXText *) 0 ; FXint arg2 ;
    FXint arg3 ; FXint arg4 ; FXint arg5 ; if ((argc < 4) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc); SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXText, 1);
    arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]); arg4 = NUM2INT(argv[2]); arg5 = NUM2INT(argv[3]);
    FXText_position(arg1,arg2,arg3,arg4,arg5); return Qnil; }
static VALUE _wrap_FXText_layout(int argc, VALUE *argv, VALUE self) { FXText *arg1 = (FXText *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXText, 1); FXText_layout(arg1); return Qnil; }
static VALUE _wrap_FXText_recalc(int argc, VALUE *argv, VALUE self) { FXText *arg1 = (FXText *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXText, 1); FXText_recalc(arg1); return Qnil; }
static VALUE _wrap_FXText_reparent(int argc, VALUE *argv, VALUE self) { FXText *arg1 = (FXText *) 0 ;
    FXComposite *arg2 = (FXComposite *) 0 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc); SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXText, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXComposite, 1); FXText_reparent(arg1,arg2); return Qnil; }
static VALUE _wrap_FXText_show(int argc, VALUE *argv, VALUE self) { FXText *arg1 = (FXText *) 0 ; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc); SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXText, 1);
    FXText_show(arg1); return Qnil; }
static VALUE _wrap_FXText_hide(int argc, VALUE *argv, VALUE self) { FXText *arg1 = (FXText *) 0 ; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc); SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXText, 1);
    FXText_hide(arg1); return Qnil; }
static VALUE _wrap_FXText_isComposite(int argc, VALUE *argv, VALUE self) { FXText *arg1 = (FXText *) 0 ; FXbool result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXText, 1); result = (FXbool)FXText_isComposite((FXText const *)arg1);
    vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXText_contains(int argc, VALUE *argv, VALUE self) { FXText *arg1 = (FXText *) 0 ; FXint arg2 ; FXint arg3 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc); SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXText, 1);
    arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]); result = (FXbool)FXText_contains((FXText const *)arg1,arg2,arg3);
    vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXText_doesSaveUnder(int argc, VALUE *argv, VALUE self) { FXText *arg1 = (FXText *) 0 ; FXbool result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXText, 1); result = (FXbool)FXText_doesSaveUnder((FXText const *)arg1);
    vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXText_setBackColor(int argc, VALUE *argv, VALUE self) { FXText *arg1 = (FXText *) 0 ; FXColor arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXText, 1); arg2 = to_FXColor(argv[0]); FXText_setBackColor(arg1,arg2);
    return Qnil; }
static VALUE _wrap_FXText_getViewportHeight(int argc, VALUE *argv, VALUE self) { FXText *arg1 = (FXText *) 0 ; FXint result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXText, 1); result = (FXint)FXText_getViewportHeight(arg1);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXText_getViewportWidth(int argc, VALUE *argv, VALUE self) { FXText *arg1 = (FXText *) 0 ; FXint result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXText, 1); result = (FXint)FXText_getViewportWidth(arg1);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXText_getContentHeight(int argc, VALUE *argv, VALUE self) { FXText *arg1 = (FXText *) 0 ; FXint result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXText, 1); result = (FXint)FXText_getContentHeight(arg1);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXText_getContentWidth(int argc, VALUE *argv, VALUE self) { FXText *arg1 = (FXText *) 0 ; FXint result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXText, 1); result = (FXint)FXText_getContentWidth(arg1);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXText_position__SWIG_1(int argc, VALUE *argv, VALUE self) { FXText *arg1 = (FXText *) 0 ; VALUE result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXText, 1); result = (VALUE)FXText_position__SWIG_1((FXText const *)arg1);
    vresult = result; return vresult; }
static VALUE _wrap_FXText_position(int nargs, VALUE *args, VALUE self) { int argc; VALUE argv[6]; int ii; argc = nargs + 1;
    argv[0] = self; for (ii = 1; (ii < argc) && (ii < 5); ii++) { argv[ii] = args[ii-1]; }  if (argc == 1) { int _v; {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXText, 0) != -1)) ? 1 : 0; }
         if (_v) { return _wrap_FXText_position__SWIG_1(nargs, args, self);}  }  if (argc == 5) { int _v; { void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXText, 0) != -1)) ? 1 : 0; }
         if (_v) { { _v = ((TYPE(argv[1]) == T_FIXNUM) || (TYPE(argv[1]) == T_BIGNUM)) ? 1 : 0; }  if (_v) { {
                    _v = ((TYPE(argv[2]) == T_FIXNUM) || (TYPE(argv[2]) == T_BIGNUM)) ? 1 : 0; }  if (_v) { {
                        _v = ((TYPE(argv[3]) == T_FIXNUM) || (TYPE(argv[3]) == T_BIGNUM)) ? 1 : 0; }  if (_v) { {
                            _v = ((TYPE(argv[4]) == T_FIXNUM) || (TYPE(argv[4]) == T_BIGNUM)) ? 1 : 0; }  if (_v) {
                            return _wrap_FXText_position__SWIG_0(nargs, args, self);}  }  }  }  }  } 
    rb_raise(rb_eArgError, "No matching function for overloaded 'FXText_position'"); return Qnil; }
static VALUE _wrap_FXText_setCursorPos(int argc, VALUE *argv, VALUE self) { FXText *arg1 = (FXText *) 0 ; FXint arg2 ;
    FXbool arg3 = (FXbool) 0 ; if ((argc < 1) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXText, 1); arg2 = NUM2INT(argv[0]); if (argc > 1) {
        arg3 = to_FXbool(argv[1]); }  FXText_setCursorPos(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXText_extendSelection(int argc, VALUE *argv, VALUE self) { FXText *arg1 = (FXText *) 0 ; FXint arg2 ;
    int arg3 = (int) SELECT_CHARS ; FXbool arg4 = (FXbool) 0 ; FXbool result; VALUE vresult = Qnil;
    if ((argc < 1) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXText, 1); arg2 = NUM2INT(argv[0]); if (argc > 1) {
        arg3 = (int) NUM2INT(argv[1]); }  if (argc > 2) { arg4 = to_FXbool(argv[2]); } 
    result = (FXbool)FXText_extendSelection(arg1,arg2,(FXTextSelectionMode )arg3,arg4); vresult = result ? Qtrue : Qfalse;
    return vresult; }
static VALUE _wrap_FXText_killSelection(int argc, VALUE *argv, VALUE self) { FXText *arg1 = (FXText *) 0 ;
    FXbool arg2 = (FXbool) 0 ; FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc); SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXText, 1);
    if (argc > 0) { arg2 = to_FXbool(argv[0]); }  result = (FXbool)FXText_killSelection(arg1,arg2);
    vresult = result ? Qtrue : Qfalse; return vresult; }

/* -------- TYPE CONVERSION AND EQUIVALENCE RULES (BEGIN) -------- */

static void *_p_FXDriveBoxTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXPacker *)(FXListBox *) ((FXDriveBox *) x));
}
static void *_p_FXToolBarTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXPacker *) ((FXToolBar *) x));
}
static void *_p_FXTextTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXScrollArea *) ((FXText *) x));
}
static void *_p_FXToolTipTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXShell *) ((FXToolTip *) x));
}
static void *_p_FXTabBookTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXPacker *)(FXTabBar *) ((FXTabBook *) x));
}
static void *_p_FXGroupBoxTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXPacker *) ((FXGroupBox *) x));
}
static void *_p_FXShellTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *)  ((FXShell *) x));
}
static void *_p_FXStatusBarTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXPacker *)(FXHorizontalFrame *) ((FXStatusBar *) x));
}
static void *_p_FXScrollAreaTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *)  ((FXScrollArea *) x));
}
static void *_p_FXPopupTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXShell *) ((FXPopup *) x));
}
static void *_p_FXScrollWindowTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXScrollArea *) ((FXScrollWindow *) x));
}
static void *_p_FXRootWindowTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *)  ((FXRootWindow *) x));
}
static void *_p_FXTopWindowTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXShell *) ((FXTopWindow *) x));
}
static void *_p_FXMainWindowTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXShell *)(FXTopWindow *) ((FXMainWindow *) x));
}
static void *_p_FXComboBoxTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXPacker *) ((FXComboBox *) x));
}
static void *_p_FXHorizontalFrameTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXPacker *) ((FXHorizontalFrame *) x));
}
static void *_p_FXVerticalFrameTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXPacker *) ((FXVerticalFrame *) x));
}
static void *_p_FX4SplitterTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *)  ((FX4Splitter *) x));
}
static void *_p_FXSplitterTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *)  ((FXSplitter *) x));
}
static void *_p_FXRealSpinnerTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXPacker *) ((FXRealSpinner *) x));
}
static void *_p_FXSpinnerTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXPacker *) ((FXSpinner *) x));
}
static void *_p_FXPackerTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *)  ((FXPacker *) x));
}
static void *_p_FXDirBoxTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXPacker *)(FXTreeListBox *) ((FXDirBox *) x));
}
static void *_p_FXSwitcherTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXPacker *) ((FXSwitcher *) x));
}
static void *_p_FXColorSelectorTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXPacker *) ((FXColorSelector *) x));
}
static void *_p_FXFileSelectorTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXPacker *) ((FXFileSelector *) x));
}
static void *_p_FXDirSelectorTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXPacker *) ((FXDirSelector *) x));
}
static void *_p_FXFontSelectorTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXPacker *) ((FXFontSelector *) x));
}
static void *_p_FXShutterTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXPacker *)(FXVerticalFrame *) ((FXShutter *) x));
}
static void *_p_FXTreeListBoxTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXPacker *) ((FXTreeListBox *) x));
}
static void *_p_FXListBoxTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXPacker *) ((FXListBox *) x));
}
static void *_p_FXMatrixTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXPacker *) ((FXMatrix *) x));
}
static void *_p_FXShutterItemTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXPacker *)(FXVerticalFrame *) ((FXShutterItem *) x));
}
static void *_p_FXTabBarTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXPacker *) ((FXTabBar *) x));
}
static void *_p_FXImageViewTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXScrollArea *) ((FXImageView *) x));
}
static void *_p_FXSpringTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXPacker *) ((FXSpring *) x));
}
static void *_p_FXToolBarShellTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXShell *)(FXTopWindow *) ((FXToolBarShell *) x));
}
static void *_p_FXDriveBoxTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *)(FXListBox *) ((FXDriveBox *) x));
}
static void *_p_FXToolBarTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXToolBar *) x));
}
static void *_p_FXTextTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXScrollArea *) ((FXText *) x));
}
static void *_p_FXCompositeTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *) ((FXComposite *) x));
}
static void *_p_FXToolTipTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXShell *) ((FXToolTip *) x));
}
static void *_p_FXTextFieldTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXFrame *) ((FXTextField *) x));
}
static void *_p_FXTabBookTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *)(FXTabBar *) ((FXTabBook *) x));
}
static void *_p_FXArrowButtonTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXFrame *) ((FXArrowButton *) x));
}
static void *_p_FXGroupBoxTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXGroupBox *) x));
}
static void *_p_FXShellTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *) ((FXShell *) x));
}
static void *_p_FXStatusBarTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *)(FXHorizontalFrame *) ((FXStatusBar *) x));
}
static void *_p_FXScrollAreaTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *) ((FXScrollArea *) x));
}
static void *_p_FXPopupTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXShell *) ((FXPopup *) x));
}
static void *_p_FXScrollWindowTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXScrollArea *) ((FXScrollWindow *) x));
}
static void *_p_FXWindowTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *) ((FXWindow *) x));
}
static void *_p_FXRootWindowTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *) ((FXRootWindow *) x));
}
static void *_p_FXTopWindowTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXShell *) ((FXTopWindow *) x));
}
static void *_p_FXMainWindowTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXShell *)(FXTopWindow *) ((FXMainWindow *) x));
}
static void *_p_FXRulerTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXFrame *) ((FXRuler *) x));
}
static void *_p_FXCanvasTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *) ((FXCanvas *) x));
}
static void *_p_FXScrollCornerTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *) ((FXScrollCorner *) x));
}
static void *_p_FXSeparatorTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXFrame *) ((FXSeparator *) x));
}
static void *_p_FXHorizontalSeparatorTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXFrame *)(FXSeparator *) ((FXHorizontalSeparator *) x));
}
static void *_p_FXVerticalSeparatorTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXFrame *)(FXSeparator *) ((FXVerticalSeparator *) x));
}
static void *_p_FXStatusLineTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXFrame *) ((FXStatusLine *) x));
}
static void *_p_FXComboBoxTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXComboBox *) x));
}
static void *_p_FXVerticalFrameTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXVerticalFrame *) x));
}
static void *_p_FXHorizontalFrameTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXHorizontalFrame *) x));
}
static void *_p_FX4SplitterTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *) ((FX4Splitter *) x));
}
static void *_p_FXSplitterTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *) ((FXSplitter *) x));
}
static void *_p_FXPackerTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *) ((FXPacker *) x));
}
static void *_p_FXSpinnerTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXSpinner *) x));
}
static void *_p_FXRealSpinnerTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXRealSpinner *) x));
}
static void *_p_FXScrollBarTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *) ((FXScrollBar *) x));
}
static void *_p_FXColorWheelTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXFrame *) ((FXColorWheel *) x));
}
static void *_p_FXBitmapFrameTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXFrame *) ((FXBitmapFrame *) x));
}
static void *_p_FXFontTo_p_FXId(void *x) {
    return (void *)((FXId *)  ((FXFont *) x));
}
static void *_p_FXDirBoxTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *)(FXTreeListBox *) ((FXDirBox *) x));
}
static void *_p_FXToolBarGripTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *) ((FXToolBarGrip *) x));
}
static void *_p_FXImageFrameTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXFrame *) ((FXImageFrame *) x));
}
static void *_p_FXDragCornerTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *) ((FXDragCorner *) x));
}
static void *_p_FXSwitcherTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXSwitcher *) x));
}
static void *_p_FXDirSelectorTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXDirSelector *) x));
}
static void *_p_FXFileSelectorTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXFileSelector *) x));
}
static void *_p_FXColorSelectorTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXColorSelector *) x));
}
static void *_p_FXFontSelectorTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXFontSelector *) x));
}
static void *_p_FXShutterTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *)(FXVerticalFrame *) ((FXShutter *) x));
}
static void *_p_FXDrawableTo_p_FXId(void *x) {
    return (void *)((FXId *)  ((FXDrawable *) x));
}
static void *_p_FXCursorTo_p_FXId(void *x) {
    return (void *)((FXId *)  ((FXCursor *) x));
}
static void *_p_FXCURCursorTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXCursor *) ((FXCURCursor *) x));
}
static void *_p_FXGIFCursorTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXCursor *) ((FXGIFCursor *) x));
}
static void *_p_FXProgressBarTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXFrame *) ((FXProgressBar *) x));
}
static void *_p_FXListBoxTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXListBox *) x));
}
static void *_p_FXTreeListBoxTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXTreeListBox *) x));
}
static void *_p_FXHeaderTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXFrame *) ((FXHeader *) x));
}
static void *_p_FXMatrixTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXMatrix *) x));
}
static void *_p_FXColorWellTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXFrame *) ((FXColorWell *) x));
}
static void *_p_FXShutterItemTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *)(FXVerticalFrame *) ((FXShutterItem *) x));
}
static void *_p_FXDialTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXFrame *) ((FXDial *) x));
}
static void *_p_FXToolBarTabTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXFrame *) ((FXToolBarTab *) x));
}
static void *_p_FXFrameTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *) ((FXFrame *) x));
}
static void *_p_FXTabBarTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXTabBar *) x));
}
static void *_p_FXImageViewTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXScrollArea *) ((FXImageView *) x));
}
static void *_p_FXSliderTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXFrame *) ((FXSlider *) x));
}
static void *_p_FXRealSliderTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXFrame *) ((FXRealSlider *) x));
}
static void *_p_FXSpringTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXSpring *) x));
}
static void *_p_FXVisualTo_p_FXId(void *x) {
    return (void *)((FXId *)  ((FXVisual *) x));
}
static void *_p_FXColorBarTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXFrame *) ((FXColorBar *) x));
}
static void *_p_FXToolBarShellTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXShell *)(FXTopWindow *) ((FXToolBarShell *) x));
}
static void *_p_FXDriveBoxTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXPacker *)(FXListBox *) ((FXDriveBox *) x));
}
static void *_p_FXToolBarTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXPacker *) ((FXToolBar *) x));
}
static void *_p_FXTextTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXScrollArea *) ((FXText *) x));
}
static void *_p_FXCompositeTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *)  ((FXComposite *) x));
}
static void *_p_FXToolTipTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXShell *) ((FXToolTip *) x));
}
static void *_p_FXTextFieldTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXFrame *) ((FXTextField *) x));
}
static void *_p_FXTabBookTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXPacker *)(FXTabBar *) ((FXTabBook *) x));
}
static void *_p_FXArrowButtonTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXFrame *) ((FXArrowButton *) x));
}
static void *_p_FXGroupBoxTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXPacker *) ((FXGroupBox *) x));
}
static void *_p_FXShellTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *) ((FXShell *) x));
}
static void *_p_FXStatusBarTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXPacker *)(FXHorizontalFrame *) ((FXStatusBar *) x));
}
static void *_p_FXScrollAreaTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *) ((FXScrollArea *) x));
}
static void *_p_FXPopupTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXShell *) ((FXPopup *) x));
}
static void *_p_FXScrollWindowTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXScrollArea *) ((FXScrollWindow *) x));
}
static void *_p_FXRootWindowTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *) ((FXRootWindow *) x));
}
static void *_p_FXTopWindowTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXShell *) ((FXTopWindow *) x));
}
static void *_p_FXMainWindowTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXShell *)(FXTopWindow *) ((FXMainWindow *) x));
}
static void *_p_FXRulerTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXFrame *) ((FXRuler *) x));
}
static void *_p_FXCanvasTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *)  ((FXCanvas *) x));
}
static void *_p_FXScrollCornerTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *)  ((FXScrollCorner *) x));
}
static void *_p_FXVerticalSeparatorTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXFrame *)(FXSeparator *) ((FXVerticalSeparator *) x));
}
static void *_p_FXHorizontalSeparatorTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXFrame *)(FXSeparator *) ((FXHorizontalSeparator *) x));
}
static void *_p_FXSeparatorTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXFrame *) ((FXSeparator *) x));
}
static void *_p_FXStatusLineTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXFrame *) ((FXStatusLine *) x));
}
static void *_p_FXComboBoxTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXPacker *) ((FXComboBox *) x));
}
static void *_p_FXHorizontalFrameTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXPacker *) ((FXHorizontalFrame *) x));
}
static void *_p_FXVerticalFrameTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXPacker *) ((FXVerticalFrame *) x));
}
static void *_p_FX4SplitterTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *) ((FX4Splitter *) x));
}
static void *_p_FXSplitterTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *) ((FXSplitter *) x));
}
static void *_p_FXPackerTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *) ((FXPacker *) x));
}
static void *_p_FXSpinnerTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXPacker *) ((FXSpinner *) x));
}
static void *_p_FXRealSpinnerTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXPacker *) ((FXRealSpinner *) x));
}
static void *_p_FXScrollBarTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *)  ((FXScrollBar *) x));
}
static void *_p_FXColorWheelTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXFrame *) ((FXColorWheel *) x));
}
static void *_p_FXBitmapFrameTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXFrame *) ((FXBitmapFrame *) x));
}
static void *_p_FXDirBoxTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXPacker *)(FXTreeListBox *) ((FXDirBox *) x));
}
static void *_p_FXToolBarGripTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *)  ((FXToolBarGrip *) x));
}
static void *_p_FXImageFrameTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXFrame *) ((FXImageFrame *) x));
}
static void *_p_FXDragCornerTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *)  ((FXDragCorner *) x));
}
static void *_p_FXSwitcherTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXPacker *) ((FXSwitcher *) x));
}
static void *_p_FXDirSelectorTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXPacker *) ((FXDirSelector *) x));
}
static void *_p_FXFileSelectorTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXPacker *) ((FXFileSelector *) x));
}
static void *_p_FXColorSelectorTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXPacker *) ((FXColorSelector *) x));
}
static void *_p_FXFontSelectorTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXPacker *) ((FXFontSelector *) x));
}
static void *_p_FXShutterTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXPacker *)(FXVerticalFrame *) ((FXShutter *) x));
}
static void *_p_FXProgressBarTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXFrame *) ((FXProgressBar *) x));
}
static void *_p_FXListBoxTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXPacker *) ((FXListBox *) x));
}
static void *_p_FXTreeListBoxTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXPacker *) ((FXTreeListBox *) x));
}
static void *_p_FXHeaderTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXFrame *) ((FXHeader *) x));
}
static void *_p_FXMatrixTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXPacker *) ((FXMatrix *) x));
}
static void *_p_FXColorWellTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXFrame *) ((FXColorWell *) x));
}
static void *_p_FXShutterItemTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXPacker *)(FXVerticalFrame *) ((FXShutterItem *) x));
}
static void *_p_FXDialTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXFrame *) ((FXDial *) x));
}
static void *_p_FXToolBarTabTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXFrame *) ((FXToolBarTab *) x));
}
static void *_p_FXFrameTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *)  ((FXFrame *) x));
}
static void *_p_FXTabBarTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXPacker *) ((FXTabBar *) x));
}
static void *_p_FXImageViewTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXScrollArea *) ((FXImageView *) x));
}
static void *_p_FXSliderTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXFrame *) ((FXSlider *) x));
}
static void *_p_FXRealSliderTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXFrame *) ((FXRealSlider *) x));
}
static void *_p_FXSpringTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXPacker *) ((FXSpring *) x));
}
static void *_p_FXColorBarTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXFrame *) ((FXColorBar *) x));
}
static void *_p_FXToolBarShellTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXShell *)(FXTopWindow *) ((FXToolBarShell *) x));
}
static void *_p_FXDriveBoxTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *)(FXListBox *) ((FXDriveBox *) x));
}
static void *_p_FXToolBarTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *) ((FXToolBar *) x));
}
static void *_p_FXTextTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXScrollArea *) ((FXText *) x));
}
static void *_p_FXCompositeTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *) ((FXComposite *) x));
}
static void *_p_FXToolTipTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXShell *) ((FXToolTip *) x));
}
static void *_p_FXTextFieldTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXFrame *) ((FXTextField *) x));
}
static void *_p_FXTabBookTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *)(FXTabBar *) ((FXTabBook *) x));
}
static void *_p_FXArrowButtonTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXFrame *) ((FXArrowButton *) x));
}
static void *_p_FXGroupBoxTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *) ((FXGroupBox *) x));
}
static void *_p_FXShellTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *) ((FXShell *) x));
}
static void *_p_FXStatusBarTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *)(FXHorizontalFrame *) ((FXStatusBar *) x));
}
static void *_p_FXScrollAreaTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *) ((FXScrollArea *) x));
}
static void *_p_FXPopupTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXShell *) ((FXPopup *) x));
}
static void *_p_FXScrollWindowTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXScrollArea *) ((FXScrollWindow *) x));
}
static void *_p_FXWindowTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *)  ((FXWindow *) x));
}
static void *_p_FXRootWindowTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *) ((FXRootWindow *) x));
}
static void *_p_FXTopWindowTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXShell *) ((FXTopWindow *) x));
}
static void *_p_FXMainWindowTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXShell *)(FXTopWindow *) ((FXMainWindow *) x));
}
static void *_p_FXRulerTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXFrame *) ((FXRuler *) x));
}
static void *_p_FXCanvasTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *) ((FXCanvas *) x));
}
static void *_p_FXScrollCornerTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *) ((FXScrollCorner *) x));
}
static void *_p_FXHorizontalSeparatorTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXFrame *)(FXSeparator *) ((FXHorizontalSeparator *) x));
}
static void *_p_FXSeparatorTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXFrame *) ((FXSeparator *) x));
}
static void *_p_FXVerticalSeparatorTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXFrame *)(FXSeparator *) ((FXVerticalSeparator *) x));
}
static void *_p_FXStatusLineTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXFrame *) ((FXStatusLine *) x));
}
static void *_p_FXComboBoxTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *) ((FXComboBox *) x));
}
static void *_p_FXHorizontalFrameTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *) ((FXHorizontalFrame *) x));
}
static void *_p_FXVerticalFrameTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *) ((FXVerticalFrame *) x));
}
static void *_p_FX4SplitterTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *) ((FX4Splitter *) x));
}
static void *_p_FXSplitterTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *) ((FXSplitter *) x));
}
static void *_p_FXPackerTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *) ((FXPacker *) x));
}
static void *_p_FXSpinnerTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *) ((FXSpinner *) x));
}
static void *_p_FXRealSpinnerTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *) ((FXRealSpinner *) x));
}
static void *_p_FXScrollBarTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *) ((FXScrollBar *) x));
}
static void *_p_FXColorWheelTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXFrame *) ((FXColorWheel *) x));
}
static void *_p_FXBitmapFrameTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXFrame *) ((FXBitmapFrame *) x));
}
static void *_p_FXDirBoxTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *)(FXTreeListBox *) ((FXDirBox *) x));
}
static void *_p_FXToolBarGripTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *) ((FXToolBarGrip *) x));
}
static void *_p_FXImageFrameTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXFrame *) ((FXImageFrame *) x));
}
static void *_p_FXDragCornerTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *) ((FXDragCorner *) x));
}
static void *_p_FXSwitcherTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *) ((FXSwitcher *) x));
}
static void *_p_FXDirSelectorTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *) ((FXDirSelector *) x));
}
static void *_p_FXFileSelectorTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *) ((FXFileSelector *) x));
}
static void *_p_FXColorSelectorTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *) ((FXColorSelector *) x));
}
static void *_p_FXFontSelectorTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *) ((FXFontSelector *) x));
}
static void *_p_FXShutterTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *)(FXVerticalFrame *) ((FXShutter *) x));
}
static void *_p_FXProgressBarTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXFrame *) ((FXProgressBar *) x));
}
static void *_p_FXListBoxTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *) ((FXListBox *) x));
}
static void *_p_FXTreeListBoxTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *) ((FXTreeListBox *) x));
}
static void *_p_FXHeaderTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXFrame *) ((FXHeader *) x));
}
static void *_p_FXMatrixTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *) ((FXMatrix *) x));
}
static void *_p_FXColorWellTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXFrame *) ((FXColorWell *) x));
}
static void *_p_FXShutterItemTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *)(FXVerticalFrame *) ((FXShutterItem *) x));
}
static void *_p_FXDialTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXFrame *) ((FXDial *) x));
}
static void *_p_FXToolBarTabTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXFrame *) ((FXToolBarTab *) x));
}
static void *_p_FXFrameTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *) ((FXFrame *) x));
}
static void *_p_FXTabBarTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *) ((FXTabBar *) x));
}
static void *_p_FXImageViewTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXScrollArea *) ((FXImageView *) x));
}
static void *_p_FXSliderTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXFrame *) ((FXSlider *) x));
}
static void *_p_FXRealSliderTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXFrame *) ((FXRealSlider *) x));
}
static void *_p_FXSpringTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *) ((FXSpring *) x));
}
static void *_p_FXColorBarTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXFrame *) ((FXColorBar *) x));
}
static void *_p_FXToolBarShellTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXShell *)(FXTopWindow *) ((FXToolBarShell *) x));
}
static void *_p_FXDocumentTo_p_FXObject(void *x) {
    return (void *)((FXObject *)  ((FXDocument *) x));
}
static void *_p_FXRegistryTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXDict *)(FXSettings *) ((FXRegistry *) x));
}
static void *_p_FXHeaderItemTo_p_FXObject(void *x) {
    return (void *)((FXObject *)  ((FXHeaderItem *) x));
}
static void *_p_FXShutterItemTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *)(FXVerticalFrame *) ((FXShutterItem *) x));
}
static void *_p_FXTextTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXScrollArea *) ((FXText *) x));
}
static void *_p_FXColorBarTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXFrame *) ((FXColorBar *) x));
}
static void *_p_FXTabBarTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXTabBar *) x));
}
static void *_p_FXSwitcherTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXSwitcher *) x));
}
static void *_p_FXTextFieldTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXFrame *) ((FXTextField *) x));
}
static void *_p_FXToolBarTabTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXFrame *) ((FXToolBarTab *) x));
}
static void *_p_FXDriveBoxTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *)(FXListBox *) ((FXDriveBox *) x));
}
static void *_p_FXIconDictTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXDict *) ((FXIconDict *) x));
}
static void *_p_FXMatrixTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXMatrix *) x));
}
static void *_p_FXFileDictTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXDict *) ((FXFileDict *) x));
}
static void *_p_FXRecentFilesTo_p_FXObject(void *x) {
    return (void *)((FXObject *)  ((FXRecentFiles *) x));
}
static void *_p_FXScrollCornerTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *) ((FXScrollCorner *) x));
}
static void *_p_FXArrowButtonTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXFrame *) ((FXArrowButton *) x));
}
static void *_p_FXPopupTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXShell *) ((FXPopup *) x));
}
static void *_p_FXDrawableTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *) ((FXDrawable *) x));
}
static void *_p_FXAppTo_p_FXObject(void *x) {
    return (void *)((FXObject *)  ((FXApp *) x));
}
static void *_p_FXHeaderTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXFrame *) ((FXHeader *) x));
}
static void *_p_FX4SplitterTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *) ((FX4Splitter *) x));
}
static void *_p_FXSplitterTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *) ((FXSplitter *) x));
}
static void *_p_FXSpringTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXSpring *) x));
}
static void *_p_FXPackerTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *) ((FXPacker *) x));
}
static void *_p_FXTabBookTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *)(FXTabBar *) ((FXTabBook *) x));
}
static void *_p_FXImageFrameTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXFrame *) ((FXImageFrame *) x));
}
static void *_p_FXVerticalSeparatorTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXFrame *)(FXSeparator *) ((FXVerticalSeparator *) x));
}
static void *_p_FXHorizontalSeparatorTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXFrame *)(FXSeparator *) ((FXHorizontalSeparator *) x));
}
static void *_p_FXSeparatorTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXFrame *) ((FXSeparator *) x));
}
static void *_p_FXIdTo_p_FXObject(void *x) {
    return (void *)((FXObject *)  ((FXId *) x));
}
static void *_p_FXProgressBarTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXFrame *) ((FXProgressBar *) x));
}
static void *_p_FXShutterTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *)(FXVerticalFrame *) ((FXShutter *) x));
}
static void *_p_FXToolTipTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXShell *) ((FXToolTip *) x));
}
static void *_p_FXCompositeTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *) ((FXComposite *) x));
}
static void *_p_FXBitmapFrameTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXFrame *) ((FXBitmapFrame *) x));
}
static void *_p_FXRealSliderTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXFrame *) ((FXRealSlider *) x));
}
static void *_p_FXSliderTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXFrame *) ((FXSlider *) x));
}
static void *_p_FXSettingsTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXDict *) ((FXSettings *) x));
}
static void *_p_FXGroupBoxTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXGroupBox *) x));
}
static void *_p_FXDebugTargetTo_p_FXObject(void *x) {
    return (void *)((FXObject *)  ((FXDebugTarget *) x));
}
static void *_p_FXDataTargetTo_p_FXObject(void *x) {
    return (void *)((FXObject *)  ((FXDataTarget *) x));
}
static void *_p_FXTreeListBoxTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXTreeListBox *) x));
}
static void *_p_FXListBoxTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXListBox *) x));
}
static void *_p_FXCanvasTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *) ((FXCanvas *) x));
}
static void *_p_FXColorWheelTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXFrame *) ((FXColorWheel *) x));
}
static void *_p_FXVisualTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *) ((FXVisual *) x));
}
static void *_p_FXScrollBarTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *) ((FXScrollBar *) x));
}
static void *_p_FXToolBarGripTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *) ((FXToolBarGrip *) x));
}
static void *_p_FXFontTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *) ((FXFont *) x));
}
static void *_p_FXComboBoxTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXComboBox *) x));
}
static void *_p_FXFrameTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *) ((FXFrame *) x));
}
static void *_p_FXStringDictTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXDict *) ((FXStringDict *) x));
}
static void *_p_FXStatusBarTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *)(FXHorizontalFrame *) ((FXStatusBar *) x));
}
static void *_p_FXDelegatorTo_p_FXObject(void *x) {
    return (void *)((FXObject *)  ((FXDelegator *) x));
}
static void *_p_FXAccelTableTo_p_FXObject(void *x) {
    return (void *)((FXObject *)  ((FXAccelTable *) x));
}
static void *_p_FXCursorTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *) ((FXCursor *) x));
}
static void *_p_FXCURCursorTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXCursor *) ((FXCURCursor *) x));
}
static void *_p_FXGIFCursorTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXCursor *) ((FXGIFCursor *) x));
}
static void *_p_FXRealSpinnerTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXRealSpinner *) x));
}
static void *_p_FXSpinnerTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXSpinner *) x));
}
static void *_p_FXStatusLineTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXFrame *) ((FXStatusLine *) x));
}
static void *_p_FXScrollWindowTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXScrollArea *) ((FXScrollWindow *) x));
}
static void *_p_FXWindowTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *) ((FXWindow *) x));
}
static void *_p_FXRootWindowTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *) ((FXRootWindow *) x));
}
static void *_p_FXTopWindowTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXShell *) ((FXTopWindow *) x));
}
static void *_p_FXMainWindowTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXShell *)(FXTopWindow *) ((FXMainWindow *) x));
}
static void *_p_FXDictTo_p_FXObject(void *x) {
    return (void *)((FXObject *)  ((FXDict *) x));
}
static void *_p_FXShellTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *) ((FXShell *) x));
}
static void *_p_FXScrollAreaTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *) ((FXScrollArea *) x));
}
static void *_p_FXColorWellTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXFrame *) ((FXColorWell *) x));
}
static void *_p_FXDragCornerTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *) ((FXDragCorner *) x));
}
static void *_p_FXRulerTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXFrame *) ((FXRuler *) x));
}
static void *_p_FXDialTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXFrame *) ((FXDial *) x));
}
static void *_p_FXHorizontalFrameTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXHorizontalFrame *) x));
}
static void *_p_FXVerticalFrameTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXVerticalFrame *) x));
}
static void *_p_FXImageViewTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXScrollArea *) ((FXImageView *) x));
}
static void *_p_FXDirSelectorTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXDirSelector *) x));
}
static void *_p_FXFileSelectorTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXFileSelector *) x));
}
static void *_p_FXColorSelectorTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXColorSelector *) x));
}
static void *_p_FXFontSelectorTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXFontSelector *) x));
}
static void *_p_FXToolBarTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXToolBar *) x));
}
static void *_p_FXToolBarShellTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXShell *)(FXTopWindow *) ((FXToolBarShell *) x));
}
static void *_p_FXDirBoxTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *)(FXTreeListBox *) ((FXDirBox *) x));
}
static void *_p_FXTextTo_p_FXScrollArea(void *x) {
    return (void *)((FXScrollArea *)  ((FXText *) x));
}
static void *_p_FXScrollWindowTo_p_FXScrollArea(void *x) {
    return (void *)((FXScrollArea *)  ((FXScrollWindow *) x));
}
static void *_p_FXImageViewTo_p_FXScrollArea(void *x) {
    return (void *)((FXScrollArea *)  ((FXImageView *) x));
}
static void *_p_FXFileStreamTo_p_FXStream(void *x) {
    return (void *)((FXStream *)  ((FXFileStream *) x));
}
static void *_p_FXMemoryStreamTo_p_FXStream(void *x) {
    return (void *)((FXStream *)  ((FXMemoryStream *) x));
}
static swig_type_info _swigt__p_FXId[] = {{"_p_FXId", 0, "FXId *", 0, 0, 0, 0},{"_p_FXDriveBox", _p_FXDriveBoxTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXDial", _p_FXDialTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXToolBar", _p_FXToolBarTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXComposite", _p_FXCompositeTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXToolTip", _p_FXToolTipTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXTabBook", _p_FXTabBookTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXTextField", _p_FXTextFieldTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXId", 0, 0, 0, 0, 0, 0},{"_p_FXArrowButton", _p_FXArrowButtonTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXGroupBox", _p_FXGroupBoxTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXShell", _p_FXShellTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXStatusBar", _p_FXStatusBarTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXScrollArea", _p_FXScrollAreaTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXPopup", _p_FXPopupTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXTopWindow", _p_FXTopWindowTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXRootWindow", _p_FXRootWindowTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXMainWindow", _p_FXMainWindowTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXScrollWindow", _p_FXScrollWindowTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXScrollCorner", _p_FXScrollCornerTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXWindow", _p_FXWindowTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXRuler", _p_FXRulerTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXCanvas", _p_FXCanvasTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXComboBox", _p_FXComboBoxTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXSeparator", _p_FXSeparatorTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXHorizontalSeparator", _p_FXHorizontalSeparatorTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXVerticalSeparator", _p_FXVerticalSeparatorTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXStatusLine", _p_FXStatusLineTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXHorizontalFrame", _p_FXHorizontalFrameTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXVerticalFrame", _p_FXVerticalFrameTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FX4Splitter", _p_FX4SplitterTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXSplitter", _p_FXSplitterTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXText", _p_FXTextTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXRealSpinner", _p_FXRealSpinnerTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXSpinner", _p_FXSpinnerTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXPacker", _p_FXPackerTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXScrollBar", _p_FXScrollBarTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXColorWheel", _p_FXColorWheelTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXBitmapFrame", _p_FXBitmapFrameTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXDirBox", _p_FXDirBoxTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXToolBarGrip", _p_FXToolBarGripTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXImageFrame", _p_FXImageFrameTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXDragCorner", _p_FXDragCornerTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXSwitcher", _p_FXSwitcherTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXColorSelector", _p_FXColorSelectorTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXFileSelector", _p_FXFileSelectorTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXDirSelector", _p_FXDirSelectorTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXFontSelector", _p_FXFontSelectorTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXShutter", _p_FXShutterTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXProgressBar", _p_FXProgressBarTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXDrawable", _p_FXDrawableTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXCursor", _p_FXCursorTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXCURCursor", _p_FXCURCursorTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXGIFCursor", _p_FXGIFCursorTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXListBox", _p_FXListBoxTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXTreeListBox", _p_FXTreeListBoxTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXHeader", _p_FXHeaderTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXMatrix", _p_FXMatrixTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXShutterItem", _p_FXShutterItemTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXColorWell", _p_FXColorWellTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXToolBarTab", _p_FXToolBarTabTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXTabBar", _p_FXTabBarTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXFrame", _p_FXFrameTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXFont", _p_FXFontTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXImageView", _p_FXImageViewTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXSlider", _p_FXSliderTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXRealSlider", _p_FXRealSliderTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXSpring", _p_FXSpringTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXVisual", _p_FXVisualTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXColorBar", _p_FXColorBarTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXToolBarShell", _p_FXToolBarShellTo_p_FXId, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXComposite[] = {{"_p_FXComposite", 0, "FXComposite *", 0, 0, 0, 0},{"_p_FXDriveBox", _p_FXDriveBoxTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXToolBar", _p_FXToolBarTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXComposite", 0, 0, 0, 0, 0, 0},{"_p_FXToolTip", _p_FXToolTipTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXTabBook", _p_FXTabBookTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXGroupBox", _p_FXGroupBoxTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXShell", _p_FXShellTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXStatusBar", _p_FXStatusBarTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXScrollArea", _p_FXScrollAreaTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXPopup", _p_FXPopupTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXTopWindow", _p_FXTopWindowTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXRootWindow", _p_FXRootWindowTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXScrollWindow", _p_FXScrollWindowTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXMainWindow", _p_FXMainWindowTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXComboBox", _p_FXComboBoxTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXHorizontalFrame", _p_FXHorizontalFrameTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXVerticalFrame", _p_FXVerticalFrameTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FX4Splitter", _p_FX4SplitterTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXSplitter", _p_FXSplitterTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXText", _p_FXTextTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXRealSpinner", _p_FXRealSpinnerTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXSpinner", _p_FXSpinnerTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXPacker", _p_FXPackerTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXDirBox", _p_FXDirBoxTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXSwitcher", _p_FXSwitcherTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXColorSelector", _p_FXColorSelectorTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXFileSelector", _p_FXFileSelectorTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXDirSelector", _p_FXDirSelectorTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXFontSelector", _p_FXFontSelectorTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXShutter", _p_FXShutterTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXTreeListBox", _p_FXTreeListBoxTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXListBox", _p_FXListBoxTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXMatrix", _p_FXMatrixTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXShutterItem", _p_FXShutterItemTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXTabBar", _p_FXTabBarTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXImageView", _p_FXImageViewTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXSpring", _p_FXSpringTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXToolBarShell", _p_FXToolBarShellTo_p_FXComposite, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXText[] = {{"_p_FXText", 0, "FXText *", 0, 0, 0, 0},{"_p_FXText", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXWindow[] = {{"_p_FXWindow", 0, "FXWindow *", 0, 0, 0, 0},{"_p_FXDriveBox", _p_FXDriveBoxTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXDial", _p_FXDialTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXToolBar", _p_FXToolBarTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXComposite", _p_FXCompositeTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXToolTip", _p_FXToolTipTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXTabBook", _p_FXTabBookTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXTextField", _p_FXTextFieldTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXArrowButton", _p_FXArrowButtonTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXGroupBox", _p_FXGroupBoxTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXShell", _p_FXShellTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXStatusBar", _p_FXStatusBarTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXScrollArea", _p_FXScrollAreaTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXPopup", _p_FXPopupTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXTopWindow", _p_FXTopWindowTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXRootWindow", _p_FXRootWindowTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXMainWindow", _p_FXMainWindowTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXWindow", 0, 0, 0, 0, 0, 0},{"_p_FXScrollWindow", _p_FXScrollWindowTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXScrollCorner", _p_FXScrollCornerTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXRuler", _p_FXRulerTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXCanvas", _p_FXCanvasTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXComboBox", _p_FXComboBoxTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXSeparator", _p_FXSeparatorTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXHorizontalSeparator", _p_FXHorizontalSeparatorTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXVerticalSeparator", _p_FXVerticalSeparatorTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXStatusLine", _p_FXStatusLineTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXHorizontalFrame", _p_FXHorizontalFrameTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXVerticalFrame", _p_FXVerticalFrameTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FX4Splitter", _p_FX4SplitterTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXSplitter", _p_FXSplitterTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXText", _p_FXTextTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXRealSpinner", _p_FXRealSpinnerTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXSpinner", _p_FXSpinnerTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXPacker", _p_FXPackerTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXScrollBar", _p_FXScrollBarTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXColorWheel", _p_FXColorWheelTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXBitmapFrame", _p_FXBitmapFrameTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXDirBox", _p_FXDirBoxTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXToolBarGrip", _p_FXToolBarGripTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXImageFrame", _p_FXImageFrameTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXDragCorner", _p_FXDragCornerTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXSwitcher", _p_FXSwitcherTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXColorSelector", _p_FXColorSelectorTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXFileSelector", _p_FXFileSelectorTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXDirSelector", _p_FXDirSelectorTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXFontSelector", _p_FXFontSelectorTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXShutter", _p_FXShutterTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXProgressBar", _p_FXProgressBarTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXListBox", _p_FXListBoxTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXTreeListBox", _p_FXTreeListBoxTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXHeader", _p_FXHeaderTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXMatrix", _p_FXMatrixTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXShutterItem", _p_FXShutterItemTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXColorWell", _p_FXColorWellTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXToolBarTab", _p_FXToolBarTabTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXTabBar", _p_FXTabBarTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXFrame", _p_FXFrameTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXImageView", _p_FXImageViewTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXSlider", _p_FXSliderTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXRealSlider", _p_FXRealSliderTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXSpring", _p_FXSpringTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXColorBar", _p_FXColorBarTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXToolBarShell", _p_FXToolBarShellTo_p_FXWindow, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXHiliteStyle[] = {{"_p_FXHiliteStyle", 0, "FXHiliteStyle *", 0, 0, 0, 0},{"_p_FXHiliteStyle", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXFont[] = {{"_p_FXFont", 0, "FXFont *", 0, 0, 0, 0},{"_p_FXFont", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXDrawable[] = {{"_p_FXDrawable", 0, "FXDrawable *", 0, 0, 0, 0},{"_p_FXDriveBox", _p_FXDriveBoxTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXDial", _p_FXDialTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXToolBar", _p_FXToolBarTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXComposite", _p_FXCompositeTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXToolTip", _p_FXToolTipTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXTabBook", _p_FXTabBookTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXTextField", _p_FXTextFieldTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXArrowButton", _p_FXArrowButtonTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXGroupBox", _p_FXGroupBoxTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXShell", _p_FXShellTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXStatusBar", _p_FXStatusBarTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXScrollArea", _p_FXScrollAreaTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXPopup", _p_FXPopupTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXTopWindow", _p_FXTopWindowTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXRootWindow", _p_FXRootWindowTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXMainWindow", _p_FXMainWindowTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXScrollWindow", _p_FXScrollWindowTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXScrollCorner", _p_FXScrollCornerTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXWindow", _p_FXWindowTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXRuler", _p_FXRulerTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXCanvas", _p_FXCanvasTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXComboBox", _p_FXComboBoxTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXSeparator", _p_FXSeparatorTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXHorizontalSeparator", _p_FXHorizontalSeparatorTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXVerticalSeparator", _p_FXVerticalSeparatorTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXStatusLine", _p_FXStatusLineTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXHorizontalFrame", _p_FXHorizontalFrameTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXVerticalFrame", _p_FXVerticalFrameTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FX4Splitter", _p_FX4SplitterTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXSplitter", _p_FXSplitterTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXText", _p_FXTextTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXRealSpinner", _p_FXRealSpinnerTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXSpinner", _p_FXSpinnerTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXPacker", _p_FXPackerTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXScrollBar", _p_FXScrollBarTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXColorWheel", _p_FXColorWheelTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXBitmapFrame", _p_FXBitmapFrameTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXDirBox", _p_FXDirBoxTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXToolBarGrip", _p_FXToolBarGripTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXImageFrame", _p_FXImageFrameTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXDragCorner", _p_FXDragCornerTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXSwitcher", _p_FXSwitcherTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXColorSelector", _p_FXColorSelectorTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXFileSelector", _p_FXFileSelectorTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXDirSelector", _p_FXDirSelectorTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXFontSelector", _p_FXFontSelectorTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXShutter", _p_FXShutterTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXDrawable", 0, 0, 0, 0, 0, 0},{"_p_FXProgressBar", _p_FXProgressBarTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXListBox", _p_FXListBoxTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXTreeListBox", _p_FXTreeListBoxTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXHeader", _p_FXHeaderTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXMatrix", _p_FXMatrixTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXShutterItem", _p_FXShutterItemTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXColorWell", _p_FXColorWellTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXToolBarTab", _p_FXToolBarTabTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXTabBar", _p_FXTabBarTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXFrame", _p_FXFrameTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXImageView", _p_FXImageViewTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXSlider", _p_FXSliderTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXRealSlider", _p_FXRealSliderTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXSpring", _p_FXSpringTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXColorBar", _p_FXColorBarTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXToolBarShell", _p_FXToolBarShellTo_p_FXDrawable, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXObject[] = {{"_p_FXObject", 0, "FXObject *", 0, 0, 0, 0},{"_p_FXDocument", _p_FXDocumentTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXRegistry", _p_FXRegistryTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXHeaderItem", _p_FXHeaderItemTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXShutterItem", _p_FXShutterItemTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXColorBar", _p_FXColorBarTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXTabBar", _p_FXTabBarTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXSwitcher", _p_FXSwitcherTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXTextField", _p_FXTextFieldTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXToolBarTab", _p_FXToolBarTabTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXDriveBox", _p_FXDriveBoxTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXIconDict", _p_FXIconDictTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXMatrix", _p_FXMatrixTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXFileDict", _p_FXFileDictTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXRecentFiles", _p_FXRecentFilesTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXScrollCorner", _p_FXScrollCornerTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXArrowButton", _p_FXArrowButtonTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXPopup", _p_FXPopupTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXDrawable", _p_FXDrawableTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXFont", _p_FXFontTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXHeader", _p_FXHeaderTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FX4Splitter", _p_FX4SplitterTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXSplitter", _p_FXSplitterTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXSpring", _p_FXSpringTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXApp", _p_FXAppTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXPacker", _p_FXPackerTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXTabBook", _p_FXTabBookTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXImageFrame", _p_FXImageFrameTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXVerticalSeparator", _p_FXVerticalSeparatorTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXHorizontalSeparator", _p_FXHorizontalSeparatorTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXSeparator", _p_FXSeparatorTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXProgressBar", _p_FXProgressBarTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXShutter", _p_FXShutterTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXToolTip", _p_FXToolTipTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXComposite", _p_FXCompositeTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXDict", _p_FXDictTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXBitmapFrame", _p_FXBitmapFrameTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXRealSlider", _p_FXRealSliderTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXSlider", _p_FXSliderTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXSettings", _p_FXSettingsTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXGroupBox", _p_FXGroupBoxTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXDataTarget", _p_FXDataTargetTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXDebugTarget", _p_FXDebugTargetTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXTreeListBox", _p_FXTreeListBoxTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXListBox", _p_FXListBoxTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXCanvas", _p_FXCanvasTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXId", _p_FXIdTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXColorWheel", _p_FXColorWheelTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXDial", _p_FXDialTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXToolBarGrip", _p_FXToolBarGripTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXScrollBar", _p_FXScrollBarTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXVisual", _p_FXVisualTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXComboBox", _p_FXComboBoxTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXFrame", _p_FXFrameTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXText", _p_FXTextTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXStatusBar", _p_FXStatusBarTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXStringDict", _p_FXStringDictTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXDelegator", _p_FXDelegatorTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXAccelTable", _p_FXAccelTableTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXObject", 0, 0, 0, 0, 0, 0},{"_p_FXCursor", _p_FXCursorTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXCURCursor", _p_FXCURCursorTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXGIFCursor", _p_FXGIFCursorTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXRealSpinner", _p_FXRealSpinnerTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXSpinner", _p_FXSpinnerTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXStatusLine", _p_FXStatusLineTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXWindow", _p_FXWindowTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXScrollWindow", _p_FXScrollWindowTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXMainWindow", _p_FXMainWindowTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXRootWindow", _p_FXRootWindowTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXTopWindow", _p_FXTopWindowTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXShell", _p_FXShellTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXScrollArea", _p_FXScrollAreaTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXColorWell", _p_FXColorWellTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXDragCorner", _p_FXDragCornerTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXRuler", _p_FXRulerTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXHorizontalFrame", _p_FXHorizontalFrameTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXVerticalFrame", _p_FXVerticalFrameTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXImageView", _p_FXImageViewTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXColorSelector", _p_FXColorSelectorTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXFileSelector", _p_FXFileSelectorTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXDirSelector", _p_FXDirSelectorTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXFontSelector", _p_FXFontSelectorTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXToolBarShell", _p_FXToolBarShellTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXToolBar", _p_FXToolBarTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXDirBox", _p_FXDirBoxTo_p_FXObject, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXScrollArea[] = {{"_p_FXScrollArea", 0, "FXScrollArea *", 0, 0, 0, 0},{"_p_FXText", _p_FXTextTo_p_FXScrollArea, 0, 0, 0, 0, 0},{"_p_FXScrollWindow", _p_FXScrollWindowTo_p_FXScrollArea, 0, 0, 0, 0, 0},{"_p_FXScrollArea", 0, 0, 0, 0, 0, 0},{"_p_FXImageView", _p_FXImageViewTo_p_FXScrollArea, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXTextChange[] = {{"_p_FXTextChange", 0, "FXTextChange *", 0, 0, 0, 0},{"_p_FXTextChange", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXStream[] = {{"_p_FXStream", 0, "FXStream *", 0, 0, 0, 0},{"_p_FXFileStream", _p_FXFileStreamTo_p_FXStream, 0, 0, 0, 0, 0},{"_p_FXMemoryStream", _p_FXMemoryStreamTo_p_FXStream, 0, 0, 0, 0, 0},{"_p_FXStream", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};

static swig_type_info *swig_types_initial[] = {
_swigt__p_FXId, 
_swigt__p_FXComposite, 
_swigt__p_FXText, 
_swigt__p_FXWindow, 
_swigt__p_FXHiliteStyle, 
_swigt__p_FXFont, 
_swigt__p_FXDrawable, 
_swigt__p_FXObject, 
_swigt__p_FXScrollArea, 
_swigt__p_FXTextChange, 
_swigt__p_FXStream, 
0
};


/* -------- TYPE CONVERSION AND EQUIVALENCE RULES (END) -------- */


#ifdef __cplusplus
extern "C"
#endif
SWIGEXPORT(void) Init_text(void) {
    int i;
    
    SWIG_InitRuntime();
    
    for (i = 0; swig_types_initial[i]; i++) {
        swig_types[i] = SWIG_TypeRegister(swig_types_initial[i]);
        SWIG_define_class(swig_types[i]);
    }
    
    rb_define_const(mFox,"TEXT_READONLY", INT2NUM(TEXT_READONLY));
    rb_define_const(mFox,"TEXT_WORDWRAP", INT2NUM(TEXT_WORDWRAP));
    rb_define_const(mFox,"TEXT_OVERSTRIKE", INT2NUM(TEXT_OVERSTRIKE));
    rb_define_const(mFox,"TEXT_FIXEDWRAP", INT2NUM(TEXT_FIXEDWRAP));
    rb_define_const(mFox,"TEXT_NO_TABS", INT2NUM(TEXT_NO_TABS));
    rb_define_const(mFox,"TEXT_AUTOINDENT", INT2NUM(TEXT_AUTOINDENT));
    rb_define_const(mFox,"TEXT_SHOWACTIVE", INT2NUM(TEXT_SHOWACTIVE));
    rb_define_const(mFox,"SELECT_CHARS", INT2NUM(SELECT_CHARS));
    rb_define_const(mFox,"SELECT_WORDS", INT2NUM(SELECT_WORDS));
    rb_define_const(mFox,"SELECT_LINES", INT2NUM(SELECT_LINES));
    
    cFXHiliteStyle.klass = rb_define_class_under(mFox, "FXHiliteStyle", rb_cObject);
    SWIG_TypeClientData(SWIGTYPE_p_FXHiliteStyle, (void *) &cFXHiliteStyle);
    rb_define_alloc_func(cFXHiliteStyle.klass, _wrap_FXHiliteStyle_allocate);
    rb_define_method(cFXHiliteStyle.klass, "initialize", VALUEFUNC(_wrap_new_FXHiliteStyle), -1);
    rb_define_method(cFXHiliteStyle.klass, "normalForeColor=", VALUEFUNC(_wrap_FXHiliteStyle_normalForeColor_set), -1);
    rb_define_method(cFXHiliteStyle.klass, "normalForeColor", VALUEFUNC(_wrap_FXHiliteStyle_normalForeColor_get), -1);
    rb_define_method(cFXHiliteStyle.klass, "normalBackColor=", VALUEFUNC(_wrap_FXHiliteStyle_normalBackColor_set), -1);
    rb_define_method(cFXHiliteStyle.klass, "normalBackColor", VALUEFUNC(_wrap_FXHiliteStyle_normalBackColor_get), -1);
    rb_define_method(cFXHiliteStyle.klass, "selectForeColor=", VALUEFUNC(_wrap_FXHiliteStyle_selectForeColor_set), -1);
    rb_define_method(cFXHiliteStyle.klass, "selectForeColor", VALUEFUNC(_wrap_FXHiliteStyle_selectForeColor_get), -1);
    rb_define_method(cFXHiliteStyle.klass, "selectBackColor=", VALUEFUNC(_wrap_FXHiliteStyle_selectBackColor_set), -1);
    rb_define_method(cFXHiliteStyle.klass, "selectBackColor", VALUEFUNC(_wrap_FXHiliteStyle_selectBackColor_get), -1);
    rb_define_method(cFXHiliteStyle.klass, "hiliteForeColor=", VALUEFUNC(_wrap_FXHiliteStyle_hiliteForeColor_set), -1);
    rb_define_method(cFXHiliteStyle.klass, "hiliteForeColor", VALUEFUNC(_wrap_FXHiliteStyle_hiliteForeColor_get), -1);
    rb_define_method(cFXHiliteStyle.klass, "hiliteBackColor=", VALUEFUNC(_wrap_FXHiliteStyle_hiliteBackColor_set), -1);
    rb_define_method(cFXHiliteStyle.klass, "hiliteBackColor", VALUEFUNC(_wrap_FXHiliteStyle_hiliteBackColor_get), -1);
    rb_define_method(cFXHiliteStyle.klass, "activeBackColor=", VALUEFUNC(_wrap_FXHiliteStyle_activeBackColor_set), -1);
    rb_define_method(cFXHiliteStyle.klass, "activeBackColor", VALUEFUNC(_wrap_FXHiliteStyle_activeBackColor_get), -1);
    rb_define_method(cFXHiliteStyle.klass, "style=", VALUEFUNC(_wrap_FXHiliteStyle_style_set), -1);
    rb_define_method(cFXHiliteStyle.klass, "style", VALUEFUNC(_wrap_FXHiliteStyle_style_get), -1);
    cFXHiliteStyle.mark = 0;
    cFXHiliteStyle.destroy = (void (*)(void *)) free_FXHiliteStyle;
    
    cFXTextChange.klass = rb_define_class_under(mFox, "FXTextChange", rb_cObject);
    SWIG_TypeClientData(SWIGTYPE_p_FXTextChange, (void *) &cFXTextChange);
    rb_undef_alloc_func(cFXTextChange.klass);
    rb_define_method(cFXTextChange.klass, "pos=", VALUEFUNC(_wrap_FXTextChange_pos_set), -1);
    rb_define_method(cFXTextChange.klass, "pos", VALUEFUNC(_wrap_FXTextChange_pos_get), -1);
    rb_define_method(cFXTextChange.klass, "ndel=", VALUEFUNC(_wrap_FXTextChange_ndel_set), -1);
    rb_define_method(cFXTextChange.klass, "ndel", VALUEFUNC(_wrap_FXTextChange_ndel_get), -1);
    rb_define_method(cFXTextChange.klass, "nins=", VALUEFUNC(_wrap_FXTextChange_nins_set), -1);
    rb_define_method(cFXTextChange.klass, "nins", VALUEFUNC(_wrap_FXTextChange_nins_get), -1);
    rb_define_method(cFXTextChange.klass, "ins=", VALUEFUNC(_wrap_FXTextChange_ins_set), -1);
    rb_define_method(cFXTextChange.klass, "ins", VALUEFUNC(_wrap_FXTextChange_ins_get), -1);
    rb_define_method(cFXTextChange.klass, "del=", VALUEFUNC(_wrap_FXTextChange_del_set), -1);
    rb_define_method(cFXTextChange.klass, "del", VALUEFUNC(_wrap_FXTextChange_del_get), -1);
    cFXTextChange.mark = 0;
    
    cFXText.klass = rb_define_class_under(mFox, "FXText", ((swig_class *) SWIGTYPE_p_FXScrollArea->clientdata)->klass);
    SWIG_TypeClientData(SWIGTYPE_p_FXText, (void *) &cFXText);
    rb_define_alloc_func(cFXText.klass, _wrap_FXText_allocate);
    rb_define_method(cFXText.klass, "initialize", VALUEFUNC(_wrap_new_FXText), -1);
    rb_define_const(cFXText.klass,"STYLE_UNDERLINE", INT2NUM(FXText::STYLE_UNDERLINE));
    rb_define_const(cFXText.klass,"STYLE_STRIKEOUT", INT2NUM(FXText::STYLE_STRIKEOUT));
    rb_define_const(cFXText.klass,"STYLE_BOLD", INT2NUM(FXText::STYLE_BOLD));
    rb_define_method(cFXText.klass, "onPaint", VALUEFUNC(_wrap_FXText_onPaint), -1);
    rb_define_method(cFXText.klass, "onUpdate", VALUEFUNC(_wrap_FXText_onUpdate), -1);
    rb_define_method(cFXText.klass, "onFocusIn", VALUEFUNC(_wrap_FXText_onFocusIn), -1);
    rb_define_method(cFXText.klass, "onFocusOut", VALUEFUNC(_wrap_FXText_onFocusOut), -1);
    rb_define_method(cFXText.klass, "onLeftBtnPress", VALUEFUNC(_wrap_FXText_onLeftBtnPress), -1);
    rb_define_method(cFXText.klass, "onLeftBtnRelease", VALUEFUNC(_wrap_FXText_onLeftBtnRelease), -1);
    rb_define_method(cFXText.klass, "onMiddleBtnPress", VALUEFUNC(_wrap_FXText_onMiddleBtnPress), -1);
    rb_define_method(cFXText.klass, "onMiddleBtnRelease", VALUEFUNC(_wrap_FXText_onMiddleBtnRelease), -1);
    rb_define_method(cFXText.klass, "onRightBtnPress", VALUEFUNC(_wrap_FXText_onRightBtnPress), -1);
    rb_define_method(cFXText.klass, "onRightBtnRelease", VALUEFUNC(_wrap_FXText_onRightBtnRelease), -1);
    rb_define_method(cFXText.klass, "onUngrabbed", VALUEFUNC(_wrap_FXText_onUngrabbed), -1);
    rb_define_method(cFXText.klass, "onMotion", VALUEFUNC(_wrap_FXText_onMotion), -1);
    rb_define_method(cFXText.klass, "onBeginDrag", VALUEFUNC(_wrap_FXText_onBeginDrag), -1);
    rb_define_method(cFXText.klass, "onEndDrag", VALUEFUNC(_wrap_FXText_onEndDrag), -1);
    rb_define_method(cFXText.klass, "onDragged", VALUEFUNC(_wrap_FXText_onDragged), -1);
    rb_define_method(cFXText.klass, "onDNDEnter", VALUEFUNC(_wrap_FXText_onDNDEnter), -1);
    rb_define_method(cFXText.klass, "onDNDLeave", VALUEFUNC(_wrap_FXText_onDNDLeave), -1);
    rb_define_method(cFXText.klass, "onDNDMotion", VALUEFUNC(_wrap_FXText_onDNDMotion), -1);
    rb_define_method(cFXText.klass, "onDNDDrop", VALUEFUNC(_wrap_FXText_onDNDDrop), -1);
    rb_define_method(cFXText.klass, "onDNDRequest", VALUEFUNC(_wrap_FXText_onDNDRequest), -1);
    rb_define_method(cFXText.klass, "onSelectionLost", VALUEFUNC(_wrap_FXText_onSelectionLost), -1);
    rb_define_method(cFXText.klass, "onSelectionGained", VALUEFUNC(_wrap_FXText_onSelectionGained), -1);
    rb_define_method(cFXText.klass, "onSelectionRequest", VALUEFUNC(_wrap_FXText_onSelectionRequest), -1);
    rb_define_method(cFXText.klass, "onClipboardLost", VALUEFUNC(_wrap_FXText_onClipboardLost), -1);
    rb_define_method(cFXText.klass, "onClipboardGained", VALUEFUNC(_wrap_FXText_onClipboardGained), -1);
    rb_define_method(cFXText.klass, "onClipboardRequest", VALUEFUNC(_wrap_FXText_onClipboardRequest), -1);
    rb_define_method(cFXText.klass, "onKeyPress", VALUEFUNC(_wrap_FXText_onKeyPress), -1);
    rb_define_method(cFXText.klass, "onKeyRelease", VALUEFUNC(_wrap_FXText_onKeyRelease), -1);
    rb_define_method(cFXText.klass, "onBlink", VALUEFUNC(_wrap_FXText_onBlink), -1);
    rb_define_method(cFXText.klass, "onFlash", VALUEFUNC(_wrap_FXText_onFlash), -1);
    rb_define_method(cFXText.klass, "onAutoScroll", VALUEFUNC(_wrap_FXText_onAutoScroll), -1);
    rb_define_method(cFXText.klass, "onQueryHelp", VALUEFUNC(_wrap_FXText_onQueryHelp), -1);
    rb_define_method(cFXText.klass, "onQueryTip", VALUEFUNC(_wrap_FXText_onQueryTip), -1);
    rb_define_method(cFXText.klass, "onCmdToggleEditable", VALUEFUNC(_wrap_FXText_onCmdToggleEditable), -1);
    rb_define_method(cFXText.klass, "onUpdToggleEditable", VALUEFUNC(_wrap_FXText_onUpdToggleEditable), -1);
    rb_define_method(cFXText.klass, "onCmdToggleOverstrike", VALUEFUNC(_wrap_FXText_onCmdToggleOverstrike), -1);
    rb_define_method(cFXText.klass, "onUpdToggleOverstrike", VALUEFUNC(_wrap_FXText_onUpdToggleOverstrike), -1);
    rb_define_method(cFXText.klass, "onCmdCursorRow", VALUEFUNC(_wrap_FXText_onCmdCursorRow), -1);
    rb_define_method(cFXText.klass, "onUpdCursorRow", VALUEFUNC(_wrap_FXText_onUpdCursorRow), -1);
    rb_define_method(cFXText.klass, "onCmdCursorColumn", VALUEFUNC(_wrap_FXText_onCmdCursorColumn), -1);
    rb_define_method(cFXText.klass, "onUpdCursorColumn", VALUEFUNC(_wrap_FXText_onUpdCursorColumn), -1);
    rb_define_method(cFXText.klass, "onUpdHaveSelection", VALUEFUNC(_wrap_FXText_onUpdHaveSelection), -1);
    rb_define_method(cFXText.klass, "onUpdSelectAll", VALUEFUNC(_wrap_FXText_onUpdSelectAll), -1);
    rb_define_method(cFXText.klass, "onCmdSetStringValue", VALUEFUNC(_wrap_FXText_onCmdSetStringValue), -1);
    rb_define_method(cFXText.klass, "onCmdGetStringValue", VALUEFUNC(_wrap_FXText_onCmdGetStringValue), -1);
    rb_define_method(cFXText.klass, "onCmdSearch", VALUEFUNC(_wrap_FXText_onCmdSearch), -1);
    rb_define_method(cFXText.klass, "onCmdReplace", VALUEFUNC(_wrap_FXText_onCmdReplace), -1);
    rb_define_method(cFXText.klass, "onCmdSearchNext", VALUEFUNC(_wrap_FXText_onCmdSearchNext), -1);
    rb_define_method(cFXText.klass, "onCmdSearchSel", VALUEFUNC(_wrap_FXText_onCmdSearchSel), -1);
    rb_define_method(cFXText.klass, "onCmdCursorTop", VALUEFUNC(_wrap_FXText_onCmdCursorTop), -1);
    rb_define_method(cFXText.klass, "onCmdCursorBottom", VALUEFUNC(_wrap_FXText_onCmdCursorBottom), -1);
    rb_define_method(cFXText.klass, "onCmdCursorHome", VALUEFUNC(_wrap_FXText_onCmdCursorHome), -1);
    rb_define_method(cFXText.klass, "onCmdCursorEnd", VALUEFUNC(_wrap_FXText_onCmdCursorEnd), -1);
    rb_define_method(cFXText.klass, "onCmdCursorRight", VALUEFUNC(_wrap_FXText_onCmdCursorRight), -1);
    rb_define_method(cFXText.klass, "onCmdCursorLeft", VALUEFUNC(_wrap_FXText_onCmdCursorLeft), -1);
    rb_define_method(cFXText.klass, "onCmdCursorUp", VALUEFUNC(_wrap_FXText_onCmdCursorUp), -1);
    rb_define_method(cFXText.klass, "onCmdCursorDown", VALUEFUNC(_wrap_FXText_onCmdCursorDown), -1);
    rb_define_method(cFXText.klass, "onCmdCursorWordLeft", VALUEFUNC(_wrap_FXText_onCmdCursorWordLeft), -1);
    rb_define_method(cFXText.klass, "onCmdCursorWordRight", VALUEFUNC(_wrap_FXText_onCmdCursorWordRight), -1);
    rb_define_method(cFXText.klass, "onCmdCursorWordStart", VALUEFUNC(_wrap_FXText_onCmdCursorWordStart), -1);
    rb_define_method(cFXText.klass, "onCmdCursorWordEnd", VALUEFUNC(_wrap_FXText_onCmdCursorWordEnd), -1);
    rb_define_method(cFXText.klass, "onCmdCursorPageDown", VALUEFUNC(_wrap_FXText_onCmdCursorPageDown), -1);
    rb_define_method(cFXText.klass, "onCmdCursorPageUp", VALUEFUNC(_wrap_FXText_onCmdCursorPageUp), -1);
    rb_define_method(cFXText.klass, "onCmdCursorScreenTop", VALUEFUNC(_wrap_FXText_onCmdCursorScreenTop), -1);
    rb_define_method(cFXText.klass, "onCmdCursorScreenBottom", VALUEFUNC(_wrap_FXText_onCmdCursorScreenBottom), -1);
    rb_define_method(cFXText.klass, "onCmdCursorScreenCenter", VALUEFUNC(_wrap_FXText_onCmdCursorScreenCenter), -1);
    rb_define_method(cFXText.klass, "onCmdCursorParHome", VALUEFUNC(_wrap_FXText_onCmdCursorParHome), -1);
    rb_define_method(cFXText.klass, "onCmdCursorParEnd", VALUEFUNC(_wrap_FXText_onCmdCursorParEnd), -1);
    rb_define_method(cFXText.klass, "onCmdBlockBeg", VALUEFUNC(_wrap_FXText_onCmdBlockBeg), -1);
    rb_define_method(cFXText.klass, "onCmdBlockEnd", VALUEFUNC(_wrap_FXText_onCmdBlockEnd), -1);
    rb_define_method(cFXText.klass, "onCmdGotoMatching", VALUEFUNC(_wrap_FXText_onCmdGotoMatching), -1);
    rb_define_method(cFXText.klass, "onCmdGotoSelected", VALUEFUNC(_wrap_FXText_onCmdGotoSelected), -1);
    rb_define_method(cFXText.klass, "onCmdGotoLine", VALUEFUNC(_wrap_FXText_onCmdGotoLine), -1);
    rb_define_method(cFXText.klass, "onCmdScrollUp", VALUEFUNC(_wrap_FXText_onCmdScrollUp), -1);
    rb_define_method(cFXText.klass, "onCmdScrollDown", VALUEFUNC(_wrap_FXText_onCmdScrollDown), -1);
    rb_define_method(cFXText.klass, "onCmdMark", VALUEFUNC(_wrap_FXText_onCmdMark), -1);
    rb_define_method(cFXText.klass, "onCmdExtend", VALUEFUNC(_wrap_FXText_onCmdExtend), -1);
    rb_define_method(cFXText.klass, "onCmdOverstString", VALUEFUNC(_wrap_FXText_onCmdOverstString), -1);
    rb_define_method(cFXText.klass, "onCmdInsertString", VALUEFUNC(_wrap_FXText_onCmdInsertString), -1);
    rb_define_method(cFXText.klass, "onCmdInsertNewline", VALUEFUNC(_wrap_FXText_onCmdInsertNewline), -1);
    rb_define_method(cFXText.klass, "onCmdInsertTab", VALUEFUNC(_wrap_FXText_onCmdInsertTab), -1);
    rb_define_method(cFXText.klass, "onCmdCutSel", VALUEFUNC(_wrap_FXText_onCmdCutSel), -1);
    rb_define_method(cFXText.klass, "onCmdCopySel", VALUEFUNC(_wrap_FXText_onCmdCopySel), -1);
    rb_define_method(cFXText.klass, "onCmdPasteSel", VALUEFUNC(_wrap_FXText_onCmdPasteSel), -1);
    rb_define_method(cFXText.klass, "onCmdDeleteSel", VALUEFUNC(_wrap_FXText_onCmdDeleteSel), -1);
    rb_define_method(cFXText.klass, "onCmdChangeCase", VALUEFUNC(_wrap_FXText_onCmdChangeCase), -1);
    rb_define_method(cFXText.klass, "onCmdShiftText", VALUEFUNC(_wrap_FXText_onCmdShiftText), -1);
    rb_define_method(cFXText.klass, "onCmdPasteMiddle", VALUEFUNC(_wrap_FXText_onCmdPasteMiddle), -1);
    rb_define_method(cFXText.klass, "onCmdSelectChar", VALUEFUNC(_wrap_FXText_onCmdSelectChar), -1);
    rb_define_method(cFXText.klass, "onCmdSelectWord", VALUEFUNC(_wrap_FXText_onCmdSelectWord), -1);
    rb_define_method(cFXText.klass, "onCmdSelectLine", VALUEFUNC(_wrap_FXText_onCmdSelectLine), -1);
    rb_define_method(cFXText.klass, "onCmdSelectAll", VALUEFUNC(_wrap_FXText_onCmdSelectAll), -1);
    rb_define_method(cFXText.klass, "onCmdSelectMatching", VALUEFUNC(_wrap_FXText_onCmdSelectMatching), -1);
    rb_define_method(cFXText.klass, "onCmdSelectBlock", VALUEFUNC(_wrap_FXText_onCmdSelectBlock), -1);
    rb_define_method(cFXText.klass, "onCmdDeselectAll", VALUEFUNC(_wrap_FXText_onCmdDeselectAll), -1);
    rb_define_method(cFXText.klass, "onCmdBackspace", VALUEFUNC(_wrap_FXText_onCmdBackspace), -1);
    rb_define_method(cFXText.klass, "onCmdBackspaceWord", VALUEFUNC(_wrap_FXText_onCmdBackspaceWord), -1);
    rb_define_method(cFXText.klass, "onCmdBackspaceBol", VALUEFUNC(_wrap_FXText_onCmdBackspaceBol), -1);
    rb_define_method(cFXText.klass, "onCmdDelete", VALUEFUNC(_wrap_FXText_onCmdDelete), -1);
    rb_define_method(cFXText.klass, "onCmdDeleteWord", VALUEFUNC(_wrap_FXText_onCmdDeleteWord), -1);
    rb_define_method(cFXText.klass, "onCmdDeleteEol", VALUEFUNC(_wrap_FXText_onCmdDeleteEol), -1);
    rb_define_method(cFXText.klass, "onCmdDeleteAll", VALUEFUNC(_wrap_FXText_onCmdDeleteAll), -1);
    rb_define_method(cFXText.klass, "onCmdDeleteLine", VALUEFUNC(_wrap_FXText_onCmdDeleteLine), -1);
    rb_define_singleton_method(cFXText.klass, "textDelimiters", VALUEFUNC(FXText_textDelimiters_get), 0);
    rb_define_const(cFXText.klass,"ID_CURSOR_TOP", INT2NUM(FXText::ID_CURSOR_TOP));
    rb_define_const(cFXText.klass,"ID_CURSOR_BOTTOM", INT2NUM(FXText::ID_CURSOR_BOTTOM));
    rb_define_const(cFXText.klass,"ID_CURSOR_HOME", INT2NUM(FXText::ID_CURSOR_HOME));
    rb_define_const(cFXText.klass,"ID_CURSOR_END", INT2NUM(FXText::ID_CURSOR_END));
    rb_define_const(cFXText.klass,"ID_CURSOR_RIGHT", INT2NUM(FXText::ID_CURSOR_RIGHT));
    rb_define_const(cFXText.klass,"ID_CURSOR_LEFT", INT2NUM(FXText::ID_CURSOR_LEFT));
    rb_define_const(cFXText.klass,"ID_CURSOR_UP", INT2NUM(FXText::ID_CURSOR_UP));
    rb_define_const(cFXText.klass,"ID_CURSOR_DOWN", INT2NUM(FXText::ID_CURSOR_DOWN));
    rb_define_const(cFXText.klass,"ID_CURSOR_WORD_LEFT", INT2NUM(FXText::ID_CURSOR_WORD_LEFT));
    rb_define_const(cFXText.klass,"ID_CURSOR_WORD_RIGHT", INT2NUM(FXText::ID_CURSOR_WORD_RIGHT));
    rb_define_const(cFXText.klass,"ID_CURSOR_WORD_START", INT2NUM(FXText::ID_CURSOR_WORD_START));
    rb_define_const(cFXText.klass,"ID_CURSOR_WORD_END", INT2NUM(FXText::ID_CURSOR_WORD_END));
    rb_define_const(cFXText.klass,"ID_CURSOR_PAGEDOWN", INT2NUM(FXText::ID_CURSOR_PAGEDOWN));
    rb_define_const(cFXText.klass,"ID_CURSOR_PAGEUP", INT2NUM(FXText::ID_CURSOR_PAGEUP));
    rb_define_const(cFXText.klass,"ID_CURSOR_SCRNTOP", INT2NUM(FXText::ID_CURSOR_SCRNTOP));
    rb_define_const(cFXText.klass,"ID_CURSOR_SCRNBTM", INT2NUM(FXText::ID_CURSOR_SCRNBTM));
    rb_define_const(cFXText.klass,"ID_CURSOR_SCRNCTR", INT2NUM(FXText::ID_CURSOR_SCRNCTR));
    rb_define_const(cFXText.klass,"ID_CURSOR_PAR_HOME", INT2NUM(FXText::ID_CURSOR_PAR_HOME));
    rb_define_const(cFXText.klass,"ID_CURSOR_PAR_END", INT2NUM(FXText::ID_CURSOR_PAR_END));
    rb_define_const(cFXText.klass,"ID_SCROLL_UP", INT2NUM(FXText::ID_SCROLL_UP));
    rb_define_const(cFXText.klass,"ID_SCROLL_DOWN", INT2NUM(FXText::ID_SCROLL_DOWN));
    rb_define_const(cFXText.klass,"ID_MARK", INT2NUM(FXText::ID_MARK));
    rb_define_const(cFXText.klass,"ID_EXTEND", INT2NUM(FXText::ID_EXTEND));
    rb_define_const(cFXText.klass,"ID_OVERST_STRING", INT2NUM(FXText::ID_OVERST_STRING));
    rb_define_const(cFXText.klass,"ID_INSERT_STRING", INT2NUM(FXText::ID_INSERT_STRING));
    rb_define_const(cFXText.klass,"ID_INSERT_NEWLINE", INT2NUM(FXText::ID_INSERT_NEWLINE));
    rb_define_const(cFXText.klass,"ID_INSERT_TAB", INT2NUM(FXText::ID_INSERT_TAB));
    rb_define_const(cFXText.klass,"ID_CUT_SEL", INT2NUM(FXText::ID_CUT_SEL));
    rb_define_const(cFXText.klass,"ID_COPY_SEL", INT2NUM(FXText::ID_COPY_SEL));
    rb_define_const(cFXText.klass,"ID_DELETE_SEL", INT2NUM(FXText::ID_DELETE_SEL));
    rb_define_const(cFXText.klass,"ID_PASTE_SEL", INT2NUM(FXText::ID_PASTE_SEL));
    rb_define_const(cFXText.klass,"ID_PASTE_MIDDLE", INT2NUM(FXText::ID_PASTE_MIDDLE));
    rb_define_const(cFXText.klass,"ID_SELECT_CHAR", INT2NUM(FXText::ID_SELECT_CHAR));
    rb_define_const(cFXText.klass,"ID_SELECT_WORD", INT2NUM(FXText::ID_SELECT_WORD));
    rb_define_const(cFXText.klass,"ID_SELECT_LINE", INT2NUM(FXText::ID_SELECT_LINE));
    rb_define_const(cFXText.klass,"ID_SELECT_ALL", INT2NUM(FXText::ID_SELECT_ALL));
    rb_define_const(cFXText.klass,"ID_SELECT_MATCHING", INT2NUM(FXText::ID_SELECT_MATCHING));
    rb_define_const(cFXText.klass,"ID_SELECT_BRACE", INT2NUM(FXText::ID_SELECT_BRACE));
    rb_define_const(cFXText.klass,"ID_SELECT_BRACK", INT2NUM(FXText::ID_SELECT_BRACK));
    rb_define_const(cFXText.klass,"ID_SELECT_PAREN", INT2NUM(FXText::ID_SELECT_PAREN));
    rb_define_const(cFXText.klass,"ID_SELECT_ANG", INT2NUM(FXText::ID_SELECT_ANG));
    rb_define_const(cFXText.klass,"ID_DESELECT_ALL", INT2NUM(FXText::ID_DESELECT_ALL));
    rb_define_const(cFXText.klass,"ID_BACKSPACE", INT2NUM(FXText::ID_BACKSPACE));
    rb_define_const(cFXText.klass,"ID_BACKSPACE_WORD", INT2NUM(FXText::ID_BACKSPACE_WORD));
    rb_define_const(cFXText.klass,"ID_BACKSPACE_BOL", INT2NUM(FXText::ID_BACKSPACE_BOL));
    rb_define_const(cFXText.klass,"ID_DELETE", INT2NUM(FXText::ID_DELETE));
    rb_define_const(cFXText.klass,"ID_DELETE_WORD", INT2NUM(FXText::ID_DELETE_WORD));
    rb_define_const(cFXText.klass,"ID_DELETE_EOL", INT2NUM(FXText::ID_DELETE_EOL));
    rb_define_const(cFXText.klass,"ID_DELETE_ALL", INT2NUM(FXText::ID_DELETE_ALL));
    rb_define_const(cFXText.klass,"ID_DELETE_LINE", INT2NUM(FXText::ID_DELETE_LINE));
    rb_define_const(cFXText.klass,"ID_TOGGLE_EDITABLE", INT2NUM(FXText::ID_TOGGLE_EDITABLE));
    rb_define_const(cFXText.klass,"ID_TOGGLE_OVERSTRIKE", INT2NUM(FXText::ID_TOGGLE_OVERSTRIKE));
    rb_define_const(cFXText.klass,"ID_CURSOR_ROW", INT2NUM(FXText::ID_CURSOR_ROW));
    rb_define_const(cFXText.klass,"ID_CURSOR_COLUMN", INT2NUM(FXText::ID_CURSOR_COLUMN));
    rb_define_const(cFXText.klass,"ID_CLEAN_INDENT", INT2NUM(FXText::ID_CLEAN_INDENT));
    rb_define_const(cFXText.klass,"ID_SHIFT_LEFT", INT2NUM(FXText::ID_SHIFT_LEFT));
    rb_define_const(cFXText.klass,"ID_SHIFT_RIGHT", INT2NUM(FXText::ID_SHIFT_RIGHT));
    rb_define_const(cFXText.klass,"ID_SHIFT_TABLEFT", INT2NUM(FXText::ID_SHIFT_TABLEFT));
    rb_define_const(cFXText.klass,"ID_SHIFT_TABRIGHT", INT2NUM(FXText::ID_SHIFT_TABRIGHT));
    rb_define_const(cFXText.klass,"ID_UPPER_CASE", INT2NUM(FXText::ID_UPPER_CASE));
    rb_define_const(cFXText.klass,"ID_LOWER_CASE", INT2NUM(FXText::ID_LOWER_CASE));
    rb_define_const(cFXText.klass,"ID_GOTO_MATCHING", INT2NUM(FXText::ID_GOTO_MATCHING));
    rb_define_const(cFXText.klass,"ID_GOTO_SELECTED", INT2NUM(FXText::ID_GOTO_SELECTED));
    rb_define_const(cFXText.klass,"ID_GOTO_LINE", INT2NUM(FXText::ID_GOTO_LINE));
    rb_define_const(cFXText.klass,"ID_SEARCH_FORW_SEL", INT2NUM(FXText::ID_SEARCH_FORW_SEL));
    rb_define_const(cFXText.klass,"ID_SEARCH_BACK_SEL", INT2NUM(FXText::ID_SEARCH_BACK_SEL));
    rb_define_const(cFXText.klass,"ID_SEARCH_FORW", INT2NUM(FXText::ID_SEARCH_FORW));
    rb_define_const(cFXText.klass,"ID_SEARCH_BACK", INT2NUM(FXText::ID_SEARCH_BACK));
    rb_define_const(cFXText.klass,"ID_SEARCH", INT2NUM(FXText::ID_SEARCH));
    rb_define_const(cFXText.klass,"ID_REPLACE", INT2NUM(FXText::ID_REPLACE));
    rb_define_const(cFXText.klass,"ID_LEFT_BRACE", INT2NUM(FXText::ID_LEFT_BRACE));
    rb_define_const(cFXText.klass,"ID_LEFT_BRACK", INT2NUM(FXText::ID_LEFT_BRACK));
    rb_define_const(cFXText.klass,"ID_LEFT_PAREN", INT2NUM(FXText::ID_LEFT_PAREN));
    rb_define_const(cFXText.klass,"ID_LEFT_ANG", INT2NUM(FXText::ID_LEFT_ANG));
    rb_define_const(cFXText.klass,"ID_RIGHT_BRACE", INT2NUM(FXText::ID_RIGHT_BRACE));
    rb_define_const(cFXText.klass,"ID_RIGHT_BRACK", INT2NUM(FXText::ID_RIGHT_BRACK));
    rb_define_const(cFXText.klass,"ID_RIGHT_PAREN", INT2NUM(FXText::ID_RIGHT_PAREN));
    rb_define_const(cFXText.klass,"ID_RIGHT_ANG", INT2NUM(FXText::ID_RIGHT_ANG));
    rb_define_const(cFXText.klass,"ID_BLINK", INT2NUM(FXText::ID_BLINK));
    rb_define_const(cFXText.klass,"ID_FLASH", INT2NUM(FXText::ID_FLASH));
    rb_define_const(cFXText.klass,"ID_LAST", INT2NUM(FXText::ID_LAST));
    rb_define_method(cFXText.klass, "setMarginTop", VALUEFUNC(_wrap_FXText_setMarginTop), -1);
    rb_define_method(cFXText.klass, "getMarginTop", VALUEFUNC(_wrap_FXText_getMarginTop), -1);
    rb_define_method(cFXText.klass, "setMarginBottom", VALUEFUNC(_wrap_FXText_setMarginBottom), -1);
    rb_define_method(cFXText.klass, "getMarginBottom", VALUEFUNC(_wrap_FXText_getMarginBottom), -1);
    rb_define_method(cFXText.klass, "setMarginLeft", VALUEFUNC(_wrap_FXText_setMarginLeft), -1);
    rb_define_method(cFXText.klass, "getMarginLeft", VALUEFUNC(_wrap_FXText_getMarginLeft), -1);
    rb_define_method(cFXText.klass, "setMarginRight", VALUEFUNC(_wrap_FXText_setMarginRight), -1);
    rb_define_method(cFXText.klass, "getMarginRight", VALUEFUNC(_wrap_FXText_getMarginRight), -1);
    rb_define_method(cFXText.klass, "getWrapColumns", VALUEFUNC(_wrap_FXText_getWrapColumns), -1);
    rb_define_method(cFXText.klass, "setWrapColumns", VALUEFUNC(_wrap_FXText_setWrapColumns), -1);
    rb_define_method(cFXText.klass, "getTabColumns", VALUEFUNC(_wrap_FXText_getTabColumns), -1);
    rb_define_method(cFXText.klass, "setTabColumns", VALUEFUNC(_wrap_FXText_setTabColumns), -1);
    rb_define_method(cFXText.klass, "getBarColumns", VALUEFUNC(_wrap_FXText_getBarColumns), -1);
    rb_define_method(cFXText.klass, "setBarColumns", VALUEFUNC(_wrap_FXText_setBarColumns), -1);
    rb_define_method(cFXText.klass, "isModified", VALUEFUNC(_wrap_FXText_isModified), -1);
    rb_define_method(cFXText.klass, "setModified", VALUEFUNC(_wrap_FXText_setModified), -1);
    rb_define_method(cFXText.klass, "isEditable", VALUEFUNC(_wrap_FXText_isEditable), -1);
    rb_define_method(cFXText.klass, "setEditable", VALUEFUNC(_wrap_FXText_setEditable), -1);
    rb_define_method(cFXText.klass, "setStyled", VALUEFUNC(_wrap_FXText_setStyled), -1);
    rb_define_method(cFXText.klass, "isStyled", VALUEFUNC(_wrap_FXText_isStyled), -1);
    rb_define_method(cFXText.klass, "setDelimiters", VALUEFUNC(_wrap_FXText_setDelimiters), -1);
    rb_define_method(cFXText.klass, "getDelimiters", VALUEFUNC(_wrap_FXText_getDelimiters), -1);
    rb_define_method(cFXText.klass, "setFont", VALUEFUNC(_wrap_FXText_setFont), -1);
    rb_define_method(cFXText.klass, "getFont", VALUEFUNC(_wrap_FXText_getFont), -1);
    rb_define_method(cFXText.klass, "setTextColor", VALUEFUNC(_wrap_FXText_setTextColor), -1);
    rb_define_method(cFXText.klass, "getTextColor", VALUEFUNC(_wrap_FXText_getTextColor), -1);
    rb_define_method(cFXText.klass, "setSelBackColor", VALUEFUNC(_wrap_FXText_setSelBackColor), -1);
    rb_define_method(cFXText.klass, "getSelBackColor", VALUEFUNC(_wrap_FXText_getSelBackColor), -1);
    rb_define_method(cFXText.klass, "setSelTextColor", VALUEFUNC(_wrap_FXText_setSelTextColor), -1);
    rb_define_method(cFXText.klass, "getSelTextColor", VALUEFUNC(_wrap_FXText_getSelTextColor), -1);
    rb_define_method(cFXText.klass, "setHiliteTextColor", VALUEFUNC(_wrap_FXText_setHiliteTextColor), -1);
    rb_define_method(cFXText.klass, "getHiliteTextColor", VALUEFUNC(_wrap_FXText_getHiliteTextColor), -1);
    rb_define_method(cFXText.klass, "setHiliteBackColor", VALUEFUNC(_wrap_FXText_setHiliteBackColor), -1);
    rb_define_method(cFXText.klass, "getHiliteBackColor", VALUEFUNC(_wrap_FXText_getHiliteBackColor), -1);
    rb_define_method(cFXText.klass, "setActiveBackColor", VALUEFUNC(_wrap_FXText_setActiveBackColor), -1);
    rb_define_method(cFXText.klass, "getActiveBackColor", VALUEFUNC(_wrap_FXText_getActiveBackColor), -1);
    rb_define_method(cFXText.klass, "setCursorColor", VALUEFUNC(_wrap_FXText_setCursorColor), -1);
    rb_define_method(cFXText.klass, "getCursorColor", VALUEFUNC(_wrap_FXText_getCursorColor), -1);
    rb_define_method(cFXText.klass, "setNumberColor", VALUEFUNC(_wrap_FXText_setNumberColor), -1);
    rb_define_method(cFXText.klass, "getNumberColor", VALUEFUNC(_wrap_FXText_getNumberColor), -1);
    rb_define_method(cFXText.klass, "setBarColor", VALUEFUNC(_wrap_FXText_setBarColor), -1);
    rb_define_method(cFXText.klass, "getBarColor", VALUEFUNC(_wrap_FXText_getBarColor), -1);
    rb_define_method(cFXText.klass, "setHelpText", VALUEFUNC(_wrap_FXText_setHelpText), -1);
    rb_define_method(cFXText.klass, "getHelpText", VALUEFUNC(_wrap_FXText_getHelpText), -1);
    rb_define_method(cFXText.klass, "setTipText", VALUEFUNC(_wrap_FXText_setTipText), -1);
    rb_define_method(cFXText.klass, "getTipText", VALUEFUNC(_wrap_FXText_getTipText), -1);
    rb_define_method(cFXText.klass, "getChar", VALUEFUNC(_wrap_FXText_getChar), -1);
    rb_define_method(cFXText.klass, "getStyle", VALUEFUNC(_wrap_FXText_getStyle), -1);
    rb_define_method(cFXText.klass, "extractText", VALUEFUNC(_wrap_FXText_extractText), -1);
    rb_define_method(cFXText.klass, "extractStyle", VALUEFUNC(_wrap_FXText_extractStyle), -1);
    rb_define_method(cFXText.klass, "replaceText", VALUEFUNC(_wrap_FXText_replaceText), -1);
    rb_define_method(cFXText.klass, "replaceStyledText", VALUEFUNC(_wrap_FXText_replaceStyledText), -1);
    rb_define_method(cFXText.klass, "appendText", VALUEFUNC(_wrap_FXText_appendText), -1);
    rb_define_method(cFXText.klass, "appendStyledText", VALUEFUNC(_wrap_FXText_appendStyledText), -1);
    rb_define_method(cFXText.klass, "insertText", VALUEFUNC(_wrap_FXText_insertText), -1);
    rb_define_method(cFXText.klass, "insertStyledText", VALUEFUNC(_wrap_FXText_insertStyledText), -1);
    rb_define_method(cFXText.klass, "removeText", VALUEFUNC(_wrap_FXText_removeText), -1);
    rb_define_method(cFXText.klass, "changeStyle", VALUEFUNC(_wrap_FXText_changeStyle), -1);
    rb_define_method(cFXText.klass, "setText", VALUEFUNC(_wrap_FXText_setText), -1);
    rb_define_method(cFXText.klass, "setStyledText", VALUEFUNC(_wrap_FXText_setStyledText), -1);
    rb_define_method(cFXText.klass, "getText", VALUEFUNC(_wrap_FXText_getText), -1);
    rb_define_method(cFXText.klass, "getLength", VALUEFUNC(_wrap_FXText_getLength), -1);
    rb_define_method(cFXText.klass, "shiftText", VALUEFUNC(_wrap_FXText_shiftText), -1);
    rb_define_method(cFXText.klass, "findText", VALUEFUNC(_wrap_FXText_findText), -1);
    rb_define_method(cFXText.klass, "isPosSelected", VALUEFUNC(_wrap_FXText_isPosSelected), -1);
    rb_define_method(cFXText.klass, "isPosVisible", VALUEFUNC(_wrap_FXText_isPosVisible), -1);
    rb_define_method(cFXText.klass, "getPosAt", VALUEFUNC(_wrap_FXText_getPosAt), -1);
    rb_define_method(cFXText.klass, "lineStart", VALUEFUNC(_wrap_FXText_lineStart), -1);
    rb_define_method(cFXText.klass, "lineEnd", VALUEFUNC(_wrap_FXText_lineEnd), -1);
    rb_define_method(cFXText.klass, "nextLine", VALUEFUNC(_wrap_FXText_nextLine), -1);
    rb_define_method(cFXText.klass, "prevLine", VALUEFUNC(_wrap_FXText_prevLine), -1);
    rb_define_method(cFXText.klass, "rowStart", VALUEFUNC(_wrap_FXText_rowStart), -1);
    rb_define_method(cFXText.klass, "rowEnd", VALUEFUNC(_wrap_FXText_rowEnd), -1);
    rb_define_method(cFXText.klass, "nextRow", VALUEFUNC(_wrap_FXText_nextRow), -1);
    rb_define_method(cFXText.klass, "prevRow", VALUEFUNC(_wrap_FXText_prevRow), -1);
    rb_define_method(cFXText.klass, "leftWord", VALUEFUNC(_wrap_FXText_leftWord), -1);
    rb_define_method(cFXText.klass, "rightWord", VALUEFUNC(_wrap_FXText_rightWord), -1);
    rb_define_method(cFXText.klass, "wordStart", VALUEFUNC(_wrap_FXText_wordStart), -1);
    rb_define_method(cFXText.klass, "wordEnd", VALUEFUNC(_wrap_FXText_wordEnd), -1);
    rb_define_method(cFXText.klass, "validPos", VALUEFUNC(_wrap_FXText_validPos), -1);
    rb_define_method(cFXText.klass, "setTopLine", VALUEFUNC(_wrap_FXText_setTopLine), -1);
    rb_define_method(cFXText.klass, "getTopLine", VALUEFUNC(_wrap_FXText_getTopLine), -1);
    rb_define_method(cFXText.klass, "setBottomLine", VALUEFUNC(_wrap_FXText_setBottomLine), -1);
    rb_define_method(cFXText.klass, "getBottomLine", VALUEFUNC(_wrap_FXText_getBottomLine), -1);
    rb_define_method(cFXText.klass, "setCenterLine", VALUEFUNC(_wrap_FXText_setCenterLine), -1);
    rb_define_method(cFXText.klass, "setAnchorPos", VALUEFUNC(_wrap_FXText_setAnchorPos), -1);
    rb_define_method(cFXText.klass, "getAnchorPos", VALUEFUNC(_wrap_FXText_getAnchorPos), -1);
    rb_define_method(cFXText.klass, "setCursorRow", VALUEFUNC(_wrap_FXText_setCursorRow), -1);
    rb_define_method(cFXText.klass, "getCursorRow", VALUEFUNC(_wrap_FXText_getCursorRow), -1);
    rb_define_method(cFXText.klass, "setCursorColumn", VALUEFUNC(_wrap_FXText_setCursorColumn), -1);
    rb_define_method(cFXText.klass, "getCursorColumn", VALUEFUNC(_wrap_FXText_getCursorColumn), -1);
    rb_define_method(cFXText.klass, "getCursorPos", VALUEFUNC(_wrap_FXText_getCursorPos), -1);
    rb_define_method(cFXText.klass, "getSelStartPos", VALUEFUNC(_wrap_FXText_getSelStartPos), -1);
    rb_define_method(cFXText.klass, "getSelEndPos", VALUEFUNC(_wrap_FXText_getSelEndPos), -1);
    rb_define_method(cFXText.klass, "selectAll", VALUEFUNC(_wrap_FXText_selectAll), -1);
    rb_define_method(cFXText.klass, "setSelection", VALUEFUNC(_wrap_FXText_setSelection), -1);
    rb_define_method(cFXText.klass, "setHighlight", VALUEFUNC(_wrap_FXText_setHighlight), -1);
    rb_define_method(cFXText.klass, "killHighlight", VALUEFUNC(_wrap_FXText_killHighlight), -1);
    rb_define_method(cFXText.klass, "makePositionVisible", VALUEFUNC(_wrap_FXText_makePositionVisible), -1);
    rb_define_method(cFXText.klass, "setTextStyle", VALUEFUNC(_wrap_FXText_setTextStyle), -1);
    rb_define_method(cFXText.klass, "getTextStyle", VALUEFUNC(_wrap_FXText_getTextStyle), -1);
    rb_define_method(cFXText.klass, "setVisibleRows", VALUEFUNC(_wrap_FXText_setVisibleRows), -1);
    rb_define_method(cFXText.klass, "getVisibleRows", VALUEFUNC(_wrap_FXText_getVisibleRows), -1);
    rb_define_method(cFXText.klass, "setVisibleColumns", VALUEFUNC(_wrap_FXText_setVisibleColumns), -1);
    rb_define_method(cFXText.klass, "getVisibleColumns", VALUEFUNC(_wrap_FXText_getVisibleColumns), -1);
    rb_define_method(cFXText.klass, "setHiliteMatchTime", VALUEFUNC(_wrap_FXText_setHiliteMatchTime), -1);
    rb_define_method(cFXText.klass, "getHiliteMatchTime", VALUEFUNC(_wrap_FXText_getHiliteMatchTime), -1);
    rb_define_method(cFXText.klass, "setHiliteStyles", VALUEFUNC(_wrap_FXText_setHiliteStyles), -1);
    rb_define_method(cFXText.klass, "getHiliteStyles", VALUEFUNC(_wrap_FXText_getHiliteStyles), -1);
    rb_define_method(cFXText.klass, "save", VALUEFUNC(_wrap_FXText_save), -1);
    rb_define_method(cFXText.klass, "load", VALUEFUNC(_wrap_FXText_load), -1);
    rb_define_method(cFXText.klass, "create", VALUEFUNC(_wrap_FXText_create), -1);
    rb_define_method(cFXText.klass, "detach", VALUEFUNC(_wrap_FXText_detach), -1);
    rb_define_method(cFXText.klass, "destroy", VALUEFUNC(_wrap_FXText_destroy), -1);
    rb_define_method(cFXText.klass, "resize", VALUEFUNC(_wrap_FXText_resize), -1);
    rb_define_method(cFXText.klass, "getDefaultWidth", VALUEFUNC(_wrap_FXText_getDefaultWidth), -1);
    rb_define_method(cFXText.klass, "getDefaultHeight", VALUEFUNC(_wrap_FXText_getDefaultHeight), -1);
    rb_define_method(cFXText.klass, "getWidthForHeight", VALUEFUNC(_wrap_FXText_getWidthForHeight), -1);
    rb_define_method(cFXText.klass, "getHeightForWidth", VALUEFUNC(_wrap_FXText_getHeightForWidth), -1);
    rb_define_method(cFXText.klass, "canFocus", VALUEFUNC(_wrap_FXText_canFocus), -1);
    rb_define_method(cFXText.klass, "setFocus", VALUEFUNC(_wrap_FXText_setFocus), -1);
    rb_define_method(cFXText.klass, "killFocus", VALUEFUNC(_wrap_FXText_killFocus), -1);
    rb_define_method(cFXText.klass, "setDefault", VALUEFUNC(_wrap_FXText_setDefault), -1);
    rb_define_method(cFXText.klass, "enable", VALUEFUNC(_wrap_FXText_enable), -1);
    rb_define_method(cFXText.klass, "disable", VALUEFUNC(_wrap_FXText_disable), -1);
    rb_define_method(cFXText.klass, "raiseWindow", VALUEFUNC(_wrap_FXText_raiseWindow), -1);
    rb_define_method(cFXText.klass, "lower", VALUEFUNC(_wrap_FXText_lower), -1);
    rb_define_method(cFXText.klass, "move", VALUEFUNC(_wrap_FXText_move), -1);
    rb_define_method(cFXText.klass, "layout", VALUEFUNC(_wrap_FXText_layout), -1);
    rb_define_method(cFXText.klass, "recalc", VALUEFUNC(_wrap_FXText_recalc), -1);
    rb_define_method(cFXText.klass, "reparent", VALUEFUNC(_wrap_FXText_reparent), -1);
    rb_define_method(cFXText.klass, "show", VALUEFUNC(_wrap_FXText_show), -1);
    rb_define_method(cFXText.klass, "hide", VALUEFUNC(_wrap_FXText_hide), -1);
    rb_define_method(cFXText.klass, "isComposite", VALUEFUNC(_wrap_FXText_isComposite), -1);
    rb_define_method(cFXText.klass, "contains", VALUEFUNC(_wrap_FXText_contains), -1);
    rb_define_method(cFXText.klass, "doesSaveUnder", VALUEFUNC(_wrap_FXText_doesSaveUnder), -1);
    rb_define_method(cFXText.klass, "setBackColor", VALUEFUNC(_wrap_FXText_setBackColor), -1);
    rb_define_method(cFXText.klass, "getViewportHeight", VALUEFUNC(_wrap_FXText_getViewportHeight), -1);
    rb_define_method(cFXText.klass, "getViewportWidth", VALUEFUNC(_wrap_FXText_getViewportWidth), -1);
    rb_define_method(cFXText.klass, "getContentHeight", VALUEFUNC(_wrap_FXText_getContentHeight), -1);
    rb_define_method(cFXText.klass, "getContentWidth", VALUEFUNC(_wrap_FXText_getContentWidth), -1);
    rb_define_method(cFXText.klass, "position", VALUEFUNC(_wrap_FXText_position), -1);
    rb_define_method(cFXText.klass, "setCursorPos", VALUEFUNC(_wrap_FXText_setCursorPos), -1);
    rb_define_method(cFXText.klass, "extendSelection", VALUEFUNC(_wrap_FXText_extendSelection), -1);
    rb_define_method(cFXText.klass, "killSelection", VALUEFUNC(_wrap_FXText_killSelection), -1);
    cFXText.mark = (void (*)(void *)) FXRbText::markfunc;
    cFXText.destroy = (void (*)(void *)) FXRbObject::freefunc;
}

