/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 1.3.22
 * 
 * This file is not intended to be easily readable and contains a number of 
 * coding conventions designed to improve portability and efficiency. Do not make
 * changes to this file unless you know what you are doing--modify the SWIG 
 * interface file instead. 
 * ----------------------------------------------------------------------------- */

#define SWIG_NOINCLUDE

#ifdef __cplusplus
template<class T> class SwigValueWrapper {
    T *tt;
public:
    SwigValueWrapper() : tt(0) { }
    SwigValueWrapper(const SwigValueWrapper<T>& rhs) : tt(new T(*rhs.tt)) { }
    SwigValueWrapper(const T& t) : tt(new T(t)) { }
    ~SwigValueWrapper() { delete tt; } 
    SwigValueWrapper& operator=(const T& t) { delete tt; tt = new T(t); return *this; }
    operator T&() const { return *tt; }
    T *operator&() { return tt; }
private:
    SwigValueWrapper& operator=(const SwigValueWrapper<T>& rhs);
};                                                    
#endif

/* ruby.swg */
/* Implementation : RUBY */
#define SWIGRUBY 1

#include "ruby.h"

/* Flags for pointer conversion */
#define SWIG_POINTER_EXCEPTION     0x1
#define SWIG_POINTER_DISOWN        0x2

#define NUM2USHRT(n) (\
    (0 <= NUM2UINT(n) && NUM2UINT(n) <= USHRT_MAX)\
    ? (unsigned short) NUM2UINT(n) \
    : (rb_raise(rb_eArgError, "integer %d out of range of `unsigned short'",\
               NUM2UINT(n)), (short)0)\
)

#define NUM2SHRT(n) (\
    (SHRT_MIN <= NUM2INT(n) && NUM2INT(n) <= SHRT_MAX)\
    ? (short)NUM2INT(n)\
    : (rb_raise(rb_eArgError, "integer %d out of range of `short'",\
               NUM2INT(n)), (short)0)\
)

/* Ruby 1.7 defines NUM2LL(), LL2NUM() and ULL2NUM() macros */
#ifndef NUM2LL
#define NUM2LL(x) NUM2LONG((x))
#endif
#ifndef LL2NUM
#define LL2NUM(x) INT2NUM((long) (x))
#endif
#ifndef ULL2NUM
#define ULL2NUM(x) UINT2NUM((unsigned long) (x))
#endif

/* Ruby 1.7 doesn't (yet) define NUM2ULL() */
#ifndef NUM2ULL
#ifdef HAVE_LONG_LONG
#define NUM2ULL(x) rb_num2ull((x))
#else
#define NUM2ULL(x) NUM2ULONG(x)
#endif
#endif

/*
 * Need to be very careful about how these macros are defined, especially
 * when compiling C++ code or C code with an ANSI C compiler.
 *
 * VALUEFUNC(f) is a macro used to typecast a C function that implements
 * a Ruby method so that it can be passed as an argument to API functions
 * like rb_define_method() and rb_define_singleton_method().
 *
 * VOIDFUNC(f) is a macro used to typecast a C function that implements
 * either the "mark" or "free" stuff for a Ruby Data object, so that it
 * can be passed as an argument to API functions like Data_Wrap_Struct()
 * and Data_Make_Struct().
 */
 
#ifdef __cplusplus
#  ifndef RUBY_METHOD_FUNC /* These definitions should work for Ruby 1.4.6 */
#    define PROTECTFUNC(f) ((VALUE (*)()) f)
#    define VALUEFUNC(f) ((VALUE (*)()) f)
#    define VOIDFUNC(f)  ((void (*)()) f)
#  else
#    ifndef ANYARGS /* These definitions should work for Ruby 1.6 */
#      define PROTECTFUNC(f) ((VALUE (*)()) f)
#      define VALUEFUNC(f) ((VALUE (*)()) f)
#      define VOIDFUNC(f)  ((RUBY_DATA_FUNC) f)
#    else /* These definitions should work for Ruby 1.7+ */
#      define PROTECTFUNC(f) ((VALUE (*)(VALUE)) f)
#      define VALUEFUNC(f) ((VALUE (*)(ANYARGS)) f)
#      define VOIDFUNC(f)  ((RUBY_DATA_FUNC) f)
#    endif
#  endif
#else
#  define VALUEFUNC(f) (f)
#  define VOIDFUNC(f) (f)
#endif

typedef struct {
  VALUE klass;
  VALUE mImpl;
  void  (*mark)(void *);
  void  (*destroy)(void *);
} swig_class;

/* Don't use for expressions have side effect */
#ifndef RB_STRING_VALUE
#define RB_STRING_VALUE(s) (TYPE(s) == T_STRING ? (s) : (*(volatile VALUE *)&(s) = rb_str_to_str(s)))
#endif
#ifndef StringValue
#define StringValue(s) RB_STRING_VALUE(s)
#endif
#ifndef StringValuePtr
#define StringValuePtr(s) RSTRING(RB_STRING_VALUE(s))->ptr
#endif
#ifndef StringValueLen
#define StringValueLen(s) RSTRING(RB_STRING_VALUE(s))->len
#endif
#ifndef SafeStringValue
#define SafeStringValue(v) do {\
    StringValue(v);\
    rb_check_safe_str(v);\
} while (0)
#endif

#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
#define rb_define_alloc_func(klass, func) rb_define_singleton_method((klass), "new", VALUEFUNC((func)), -1)
#define rb_undef_alloc_func(klass) rb_undef_method(CLASS_OF((klass)), "new")
#endif

/* Contract support */

#define SWIG_contract_assert(expr, msg) if (!(expr)) { rb_raise(rb_eRuntimeError, (char *) msg ); } else


/*************************************************************** -*- c -*-
 * ruby/precommon.swg
 *
 * Rename all exported symbols from common.swg, to avoid symbol
 * clashes if multiple interpreters are included
 *
 ************************************************************************/

#define SWIG_TypeRegister    SWIG_Ruby_TypeRegister
#define SWIG_TypeCheck       SWIG_Ruby_TypeCheck
#define SWIG_TypeCast        SWIG_Ruby_TypeCast
#define SWIG_TypeDynamicCast SWIG_Ruby_TypeDynamicCast
#define SWIG_TypeName        SWIG_Ruby_TypeName
#define SWIG_TypePrettyName  SWIG_Ruby_TypePrettyName
#define SWIG_TypeQuery       SWIG_Ruby_TypeQuery
#define SWIG_TypeClientData  SWIG_Ruby_TypeClientData
#define SWIG_PackData        SWIG_Ruby_PackData 
#define SWIG_UnpackData      SWIG_Ruby_UnpackData 

/* Also rename all exported symbols from rubydef.swig */

/* Common SWIG API */
#define SWIG_ConvertPtr(obj, pp, type, flags) \
  SWIG_Ruby_ConvertPtr(obj, pp, type, flags)
#define SWIG_NewPointerObj(p, type, flags) \
  SWIG_Ruby_NewPointerObj(p, type, flags)
#define SWIG_MustGetPtr(p, type, argnum, flags) \
  SWIG_Ruby_MustGetPtr(p, type, argnum, flags)

/* Ruby-specific SWIG API */

#define SWIG_InitRuntime() \
  SWIG_Ruby_InitRuntime()
#define SWIG_define_class(ty) \
  SWIG_Ruby_define_class(ty)
#define SWIG_NewClassInstance(value, ty) \
  SWIG_Ruby_NewClassInstance(value, ty)
#define SWIG_MangleStr(value) \
  SWIG_Ruby_MangleStr(value)
#define SWIG_CheckConvert(value, ty) \
  SWIG_Ruby_CheckConvert(value, ty)
#define SWIG_NewPackedObj(ptr, sz, ty) \
  SWIG_Ruby_NewPackedObj(ptr, sz, ty)
#define SWIG_ConvertPacked(obj, ptr, sz, ty, flags) \
  SWIG_Ruby_ConvertPacked(obj, ptr, sz, ty, flags)


/***********************************************************************
 * common.swg
 *
 *     This file contains generic SWIG runtime support for pointer
 *     type checking as well as a few commonly used macros to control
 *     external linkage.
 *
 * Author : David Beazley (beazley@cs.uchicago.edu)
 *
 * Copyright (c) 1999-2000, The University of Chicago
 * 
 * This file may be freely redistributed without license or fee provided
 * this copyright message remains intact.
 ************************************************************************/

#include <string.h>

#if defined(_WIN32) || defined(__WIN32__) || defined(__CYGWIN__)
#  if defined(_MSC_VER) || defined(__GNUC__)
#    if defined(STATIC_LINKED)
#      define SWIGEXPORT(a) a
#      define SWIGIMPORT(a) extern a
#    else
#      define SWIGEXPORT(a) __declspec(dllexport) a
#      define SWIGIMPORT(a) extern a
#    endif
#  else
#    if defined(__BORLANDC__)
#      define SWIGEXPORT(a) a _export
#      define SWIGIMPORT(a) a _export
#    else
#      define SWIGEXPORT(a) a
#      define SWIGIMPORT(a) a
#    endif
#  endif
#else
#  define SWIGEXPORT(a) a
#  define SWIGIMPORT(a) a
#endif

#ifdef SWIG_GLOBAL
#  define SWIGRUNTIME(a) SWIGEXPORT(a)
#else
#  define SWIGRUNTIME(a) static a
#endif

#ifdef __cplusplus
extern "C" {
#endif

typedef void *(*swig_converter_func)(void *);
typedef struct swig_type_info *(*swig_dycast_func)(void **);

typedef struct swig_type_info {
  const char             *name;
  swig_converter_func     converter;
  const char             *str;
  void                   *clientdata;
  swig_dycast_func        dcast;
  struct swig_type_info  *next;
  struct swig_type_info  *prev;
} swig_type_info;

#ifdef SWIG_NOINCLUDE

SWIGIMPORT(swig_type_info *) SWIG_TypeRegister(swig_type_info *);
SWIGIMPORT(swig_type_info *) SWIG_TypeCheck(char *c, swig_type_info *);
SWIGIMPORT(void *)           SWIG_TypeCast(swig_type_info *, void *);
SWIGIMPORT(swig_type_info *) SWIG_TypeDynamicCast(swig_type_info *, void **);
SWIGIMPORT(const char *)     SWIG_TypeName(const swig_type_info *);
SWIGIMPORT(const char *)     SWIG_TypePrettyName(const swig_type_info *);
SWIGIMPORT(swig_type_info *) SWIG_TypeQuery(const char *);
SWIGIMPORT(void)             SWIG_TypeClientData(swig_type_info *, void *);
SWIGIMPORT(char *)           SWIG_PackData(char *, void *, int);
SWIGIMPORT(char *)           SWIG_UnpackData(char *, void *, int);

#else

static swig_type_info *swig_type_list = 0;
static swig_type_info **swig_type_list_handle = &swig_type_list;

/* Register a type mapping with the type-checking */
SWIGRUNTIME(swig_type_info *)
SWIG_TypeRegister(swig_type_info *ti) {
  swig_type_info *tc, *head, *ret, *next;
  /* Check to see if this type has already been registered */
  tc = *swig_type_list_handle;
  while (tc) {
    if (strcmp(tc->name, ti->name) == 0) {
      /* Already exists in the table.  Just add additional types to the list */
      if (tc->clientdata) ti->clientdata = tc->clientdata;
      head = tc;
      next = tc->next;
      goto l1;
    }
    tc = tc->prev;
  }
  head = ti;
  next = 0;

  /* Place in list */
  ti->prev = *swig_type_list_handle;
  *swig_type_list_handle = ti;

  /* Build linked lists */
  l1:
  ret = head;
  tc = ti + 1;
  /* Patch up the rest of the links */
  while (tc->name) {
    head->next = tc;
    tc->prev = head;
    head = tc;
    tc++;
  }
  if (next) next->prev = head;
  head->next = next;
  return ret;
}

/* Check the typename */
SWIGRUNTIME(swig_type_info *) 
SWIG_TypeCheck(char *c, swig_type_info *ty) {
  swig_type_info *s;
  if (!ty) return 0;        /* Void pointer */
  s = ty->next;             /* First element always just a name */
  do {
    if (strcmp(s->name,c) == 0) {
      if (s == ty->next) return s;
      /* Move s to the top of the linked list */
      s->prev->next = s->next;
      if (s->next) {
        s->next->prev = s->prev;
      }
      /* Insert s as second element in the list */
      s->next = ty->next;
      if (ty->next) ty->next->prev = s;
      ty->next = s;
      s->prev = ty;
      return s;
    }
    s = s->next;
  } while (s && (s != ty->next));
  return 0;
}

/* Cast a pointer up an inheritance hierarchy */
SWIGRUNTIME(void *) 
SWIG_TypeCast(swig_type_info *ty, void *ptr) {
  if ((!ty) || (!ty->converter)) return ptr;
  return (*ty->converter)(ptr);
}

/* Dynamic pointer casting. Down an inheritance hierarchy */
SWIGRUNTIME(swig_type_info *) 
SWIG_TypeDynamicCast(swig_type_info *ty, void **ptr) {
  swig_type_info *lastty = ty;
  if (!ty || !ty->dcast) return ty;
  while (ty && (ty->dcast)) {
    ty = (*ty->dcast)(ptr);
    if (ty) lastty = ty;
  }
  return lastty;
}

/* Return the name associated with this type */
SWIGRUNTIME(const char *)
SWIG_TypeName(const swig_type_info *ty) {
  return ty->name;
}

/* Return the pretty name associated with this type,
   that is an unmangled type name in a form presentable to the user.
*/
SWIGRUNTIME(const char *)
SWIG_TypePrettyName(const swig_type_info *type) {
  /* The "str" field contains the equivalent pretty names of the
     type, separated by vertical-bar characters.  We choose
     to print the last name, as it is often (?) the most
     specific. */
  if (type->str != NULL) {
    const char *last_name = type->str;
    const char *s;
    for (s = type->str; *s; s++)
      if (*s == '|') last_name = s+1;
    return last_name;
  }
  else
    return type->name;
}

/* 
   Compare two type names skipping the space characters, therefore
   "char*" == "char *" and "Class<int>" == "Class<int >", etc.

   Return 0 when the two name types are equivalent, as in
   strncmp, but skipping ' '.
*/
static int
SWIG_TypeNameComp(const char *f1, const char *l1,
		  const char *f2, const char *l2) {
  for (;(f1 != l1) && (f2 != l2); ++f1, ++f2) {
    while ((*f1 == ' ') && (f1 != l1)) ++f1;
    while ((*f2 == ' ') && (f2 != l2)) ++f2;
    if (*f1 != *f2) return *f1 - *f2;
  }
  return (l1 - f1) - (l2 - f2);
}

/*
  Check type equivalence in a name list like <name1>|<name2>|...
*/
static int
SWIG_TypeEquiv(const char *nb, const char *tb) {
  int equiv = 0;
  const char* te = tb + strlen(tb);
  const char* ne = nb;
  while (!equiv && *ne) {
    for (nb = ne; *ne; ++ne) {
      if (*ne == '|') break;
    }
    equiv = SWIG_TypeNameComp(nb, ne, tb, te) == 0;
    if (*ne) ++ne;
  }
  return equiv;
}
  

/* Search for a swig_type_info structure */
SWIGRUNTIME(swig_type_info *)
SWIG_TypeQuery(const char *name) {
  swig_type_info *ty = *swig_type_list_handle;
  while (ty) {
    if (ty->str && (SWIG_TypeEquiv(ty->str,name))) return ty;
    if (ty->name && (strcmp(name,ty->name) == 0)) return ty;
    ty = ty->prev;
  }
  return 0;
}

/* Set the clientdata field for a type */
SWIGRUNTIME(void)
SWIG_TypeClientData(swig_type_info *ti, void *clientdata) {
  swig_type_info *tc, *equiv;
  if (ti->clientdata == clientdata) return;
  ti->clientdata = clientdata;
  equiv = ti->next;
  while (equiv) {
    if (!equiv->converter) {
      tc = *swig_type_list_handle;
      while (tc) {
        if ((strcmp(tc->name, equiv->name) == 0))
          SWIG_TypeClientData(tc,clientdata);
        tc = tc->prev;
      }
    }
    equiv = equiv->next;
  }
}

/* Pack binary data into a string */
SWIGRUNTIME(char *)
SWIG_PackData(char *c, void *ptr, int sz) {
  static char hex[17] = "0123456789abcdef";
  unsigned char *u = (unsigned char *) ptr;
  const unsigned char *eu =  u + sz;
  register unsigned char uu;
  for (; u != eu; ++u) {
    uu = *u;
    *(c++) = hex[(uu & 0xf0) >> 4];
    *(c++) = hex[uu & 0xf];
  }
  return c;
}

/* Unpack binary data from a string */
SWIGRUNTIME(char *)
SWIG_UnpackData(char *c, void *ptr, int sz) {
  register unsigned char uu = 0;
  register int d;
  unsigned char *u = (unsigned char *) ptr;
  const unsigned char *eu =  u + sz;
  for (; u != eu; ++u) {
    d = *(c++);
    if ((d >= '0') && (d <= '9'))
      uu = ((d - '0') << 4);
    else if ((d >= 'a') && (d <= 'f'))
      uu = ((d - ('a'-10)) << 4);
    d = *(c++);
    if ((d >= '0') && (d <= '9'))
      uu |= (d - '0');
    else if ((d >= 'a') && (d <= 'f'))
      uu |= (d - ('a'-10));
    *u = uu;
  }
  return c;
}

#endif

#ifdef __cplusplus
}
#endif

/* rubydec.swg -*- c -*- */
#ifdef __cplusplus
extern "C" {
#endif

SWIGIMPORT(void)   SWIG_Ruby_InitRuntime(void);
SWIGIMPORT(void)   SWIG_Ruby_define_class(swig_type_info *);
SWIGIMPORT(VALUE)  SWIG_Ruby_NewPointerObj(void *, swig_type_info *, int);
SWIGIMPORT(VALUE)  SWIG_Ruby_NewClassInstance(VALUE, swig_type_info *);
SWIGIMPORT(char *) SWIG_Ruby_MangleStr(VALUE);
SWIGIMPORT(int)    SWIG_Ruby_ConvertPtr(VALUE, void**, swig_type_info *, int);
SWIGIMPORT(void *) SWIG_Ruby_MustGetPtr(VALUE, swig_type_info *, int, int);
SWIGIMPORT(int)    SWIG_Ruby_CheckConvert(VALUE, swig_type_info *);
SWIGIMPORT(VALUE)  SWIG_Ruby_NewPackedObj(void *ptr, int sz, swig_type_info *type);
SWIGIMPORT(void)   SWIG_Ruby_ConvertPacked(VALUE obj, void *ptr, int sz, swig_type_info *ty, int flags);

#ifdef __cplusplus
}
#endif


/* -------- TYPES TABLE (BEGIN) -------- */

#define  SWIGTYPE_p_FXFoldingItem swig_types[0] 
#define  SWIGTYPE_p_FXObject swig_types[1] 
#define  SWIGTYPE_p_FXScrollArea swig_types[2] 
#define  SWIGTYPE_p_FXWindow swig_types[3] 
#define  SWIGTYPE_p_FXComposite swig_types[4] 
#define  SWIGTYPE_p_FXId swig_types[5] 
#define  SWIGTYPE_p_FXFont swig_types[6] 
#define  SWIGTYPE_p_FXDirList swig_types[7] 
#define  SWIGTYPE_p_FXFileDict swig_types[8] 
#define  SWIGTYPE_p_FXStream swig_types[9] 
#define  SWIGTYPE_p_FXDrawable swig_types[10] 
#define  SWIGTYPE_p_FXDirItem swig_types[11] 
#define  SWIGTYPE_p_FXTreeList swig_types[12] 
#define  SWIGTYPE_p_FXIcon swig_types[13] 
#define  SWIGTYPE_p_FXHeader swig_types[14] 
#define  SWIGTYPE_p_FXFoldingListSortFunc swig_types[15] 
#define  SWIGTYPE_p_FXFoldingList swig_types[16] 
#define  SWIGTYPE_p_FXTreeItem swig_types[17] 
static swig_type_info *swig_types[19];

/* -------- TYPES TABLE (END) -------- */

#define SWIG_init    Init_treelist
#define SWIG_name    "Treelist"


static void SWIG_AsVal(VALUE obj, int *val)
{
    *val = (int) NUM2INT(obj);
}


#include "FXRbCommon.h"


inline FXColor to_FXColor(VALUE obj){
  if(TYPE(obj)==T_STRING){
    return fxcolorfromname(StringValuePtr(obj));
    }
  else if(TYPE(obj)==T_SYMBOL){
    return fxcolorfromname(rb_id2name(SYM2ID(obj)));
    }
  else{
    return NUM2ULONG(obj);
    }
  }


inline FXString to_FXString(VALUE obj){
  if(!NIL_P(obj)){
    Check_Type(obj,T_STRING);
    return FXString(STR2CSTR(obj));
    }
  else{
    return FXString::null;
    }
  }


inline FXbool to_FXbool(VALUE obj){
  if (obj == Qtrue || obj == Qfalse){
    return (obj == Qtrue) ? TRUE : FALSE;
    }
  else{
    return static_cast<FXbool>(NUM2UINT(obj));
    }
  }


static swig_type_info* FXEventTypeInfo=0;

inline void* to_FXEvent(VALUE obj){
  void* ptr;
  if(!FXEventTypeInfo){
    FXEventTypeInfo=SWIG_TypeQuery("FXEvent *");
    FXASSERT(FXEventTypeInfo!=0);
    }
  SWIG_ConvertPtr(obj,&ptr,FXEventTypeInfo,1);
  return ptr;
  }

FXFoldingItem *new_FXFoldingItem(FXString const &text,FXIcon *oi,FXIcon *ci,void *ptr){
      return new FXRbFoldingItem(text,oi,ci,ptr);
      }
void FXFoldingItem_setData(FXFoldingItem *self,VALUE ptr){
      self->setData(reinterpret_cast<void*>(ptr));
      }
VALUE FXFoldingItem_getData(FXFoldingItem const *self){
      return self->getData() ? reinterpret_cast<VALUE>(self->getData()) : Qnil;
      }

swig_class cFXFoldingItem;
static void free_FXFoldingItem(FXFoldingItem *);
FXFoldingList *new_FXFoldingList(FXComposite *p,FXObject *tgt,FXSelector sel,FXuint opts,FXint x,FXint y,FXint w,FXint h){
      return new FXRbFoldingList(p,tgt,sel,opts,x,y,w,h);
      }
FXFoldingItem *FXFoldingList_addItemFirst__SWIG_0(FXFoldingList *self,FXFoldingItem *p,FXFoldingItem *item,FXbool notify){
      if(item->isMemberOf(FXMETACLASS(FXRbFoldingItem))){
        dynamic_cast<FXRbFoldingItem*>(item)->owned=1;
	}
      return self->addItemFirst(p,item,notify);
      }
FXFoldingItem *FXFoldingList_addItemLast__SWIG_0(FXFoldingList *self,FXFoldingItem *p,FXFoldingItem *item,FXbool notify){
      if(item->isMemberOf(FXMETACLASS(FXRbFoldingItem))){
        dynamic_cast<FXRbFoldingItem*>(item)->owned=1;
	}
      return self->addItemLast(p,item,notify);
      }
FXFoldingItem *FXFoldingList_addItemAfter__SWIG_0(FXFoldingList *self,FXFoldingItem *other,FXFoldingItem *item,FXbool notify){
      if(item->isMemberOf(FXMETACLASS(FXRbFoldingItem))){
        dynamic_cast<FXRbFoldingItem*>(item)->owned=1;
	}
      return self->addItemAfter(other,item,notify);
      }
FXFoldingItem *FXFoldingList_addItemBefore__SWIG_0(FXFoldingList *self,FXFoldingItem *other,FXFoldingItem *item,FXbool notify){
      if(item->isMemberOf(FXMETACLASS(FXRbFoldingItem))){
        dynamic_cast<FXRbFoldingItem*>(item)->owned=1;
	}
      return self->addItemBefore(other,item,notify);
      }
void FXFoldingList_removeItem(FXFoldingList *self,FXFoldingItem *item,FXbool notify){
      // Save pointer(s) to the soon-to-be-destroyed items
      FXObjectListOf<FXFoldingItem> items;
      FXRbFoldingList::enumerateItem(item,items);
      
      // Do the deed
      self->removeItem(item,notify);
      
      // Now zero-out pointers held by still-alive Ruby objects
      for(FXint i=0;i<items.no();i++){
        FXRbUnregisterRubyObj(items[i]);
        }
      }
void FXFoldingList_removeItems(FXFoldingList *self,FXFoldingItem *fm,FXFoldingItem *to,FXbool notify){
      // Save pointer(s) to the soon-to-be-destroyed items
      FXObjectListOf<FXFoldingItem> items;
      FXRbFoldingList::enumerateItems(fm,to,items);

      // Do the deed
      self->removeItems(fm,to,notify);

      // Now zero-out pointers held by still-alive Ruby objects
      for(FXint i=0;i<items.no();i++){
        FXRbUnregisterRubyObj(items[i]);
        }
      }
void FXFoldingList_clearItems(FXFoldingList *self,FXbool notify){
      // Save pointer(s) to the soon-to-be-destroyed items
      FXObjectListOf<FXFoldingItem> items;
      FXRbFoldingList::enumerateItems(self->getFirstItem(),self->getLastItem(),items);

      // Do the deed
      self->clearItems(notify);

      // Now zero-out pointers held by still-alive Ruby objects
      for(FXint i=0;i<items.no();i++){
        FXRbUnregisterRubyObj(items[i]);
        }
      }
void FXFoldingList_setItemData(FXFoldingList *self,FXFoldingItem *item,VALUE ptr){
      self->setItemData(item,reinterpret_cast<void*>(ptr));
      }
VALUE FXFoldingList_getItemData(FXFoldingList const *self,FXFoldingItem const *item){
      return self->getItemData(item) ? reinterpret_cast<VALUE>(self->getItemData(item)) : Qnil;
      }
VALUE FXFoldingList_position__SWIG_1(FXFoldingList const *self){
    FXint x, y;
    self->getPosition(x, y);
    VALUE pos = rb_ary_new();
    rb_ary_push(pos, INT2NUM(x));
    rb_ary_push(pos, INT2NUM(y));
    return pos;
  }

swig_class cFXFoldingList;
static void free_FXFoldingList(FXFoldingList *);
FXTreeItem *new_FXTreeItem(FXString const &text,FXIcon *oi,FXIcon *ci,void *ptr){
      return new FXRbTreeItem(text,oi,ci,ptr);
      }
void FXTreeItem_setData(FXTreeItem *self,VALUE ptr){
      self->setData((void*) ptr);
      }
VALUE FXTreeItem_getData(FXTreeItem const *self){
      return self->getData() ? (VALUE) self->getData() : Qnil;
      }

swig_class cFXTreeItem;
static void free_FXTreeItem(FXTreeItem *);

static swig_type_info *FXTreeItem_dynamic_cast(void **ptr) {
    FXTreeItem **ppTreeItem = reinterpret_cast<FXTreeItem **>(ptr);
    FXDirItem *pDirItem=dynamic_cast<FXDirItem*>(*ppTreeItem);
    if(pDirItem){
      *ptr=reinterpret_cast<void*>(pDirItem);
      return SWIG_TypeQuery("FXDirItem *");
      }
    return 0;
}

FXTreeList *new_FXTreeList(FXComposite *p,FXObject *tgt,FXSelector sel,FXuint opts,FXint x,FXint y,FXint w,FXint h){
      return new FXRbTreeList(p,tgt,sel,opts,x,y,w,h);
      }
FXTreeItem *FXTreeList_addItemFirst__SWIG_0(FXTreeList *self,FXTreeItem *p,FXTreeItem *item,FXbool notify){
      if(item->isMemberOf(FXMETACLASS(FXRbTreeItem))){
        dynamic_cast<FXRbTreeItem*>(item)->owner=self;
	}
      return self->addItemFirst(p,item,notify);
      }
FXTreeItem *FXTreeList_addItemFirst__SWIG_1(FXTreeList *self,FXTreeItem *p,FXString const &text,FXIcon *oi,FXIcon *ci,void *ITEMDATA,FXbool notify){
      FXTreeItem* item=self->addItemFirst(p,text,oi,ci,ITEMDATA,notify);
      if(item->isMemberOf(FXMETACLASS(FXRbTreeItem))){
        dynamic_cast<FXRbTreeItem*>(item)->owner=self;
	}
      return item;
      }
FXTreeItem *FXTreeList_addItemLast__SWIG_0(FXTreeList *self,FXTreeItem *p,FXTreeItem *item,FXbool notify){
      if(item->isMemberOf(FXMETACLASS(FXRbTreeItem))){
        dynamic_cast<FXRbTreeItem*>(item)->owner=self;
	}
      return self->addItemLast(p,item,notify);
      }
FXTreeItem *FXTreeList_addItemLast__SWIG_1(FXTreeList *self,FXTreeItem *p,FXString const &text,FXIcon *oi,FXIcon *ci,void *ITEMDATA,FXbool notify){
      FXTreeItem* item=self->addItemLast(p,text,oi,ci,ITEMDATA,notify);
      if(item->isMemberOf(FXMETACLASS(FXRbTreeItem))){
        dynamic_cast<FXRbTreeItem*>(item)->owner=self;
	}
      return item;
      }
FXTreeItem *FXTreeList_addItemAfter__SWIG_0(FXTreeList *self,FXTreeItem *other,FXTreeItem *item,FXbool notify){
      if(item->isMemberOf(FXMETACLASS(FXRbTreeItem))){
        dynamic_cast<FXRbTreeItem*>(item)->owner=self;
	}
      return self->addItemAfter(other,item,notify);
      }
FXTreeItem *FXTreeList_addItemAfter__SWIG_1(FXTreeList *self,FXTreeItem *other,FXString const &text,FXIcon *oi,FXIcon *ci,void *ITEMDATA,FXbool notify){
      FXTreeItem* item=self->addItemAfter(other,text,oi,ci,ITEMDATA,notify);
      if(item->isMemberOf(FXMETACLASS(FXRbTreeItem))){
        dynamic_cast<FXRbTreeItem*>(item)->owner=self;
	}
      return item;
      }
FXTreeItem *FXTreeList_addItemBefore__SWIG_0(FXTreeList *self,FXTreeItem *other,FXTreeItem *item,FXbool notify){
      if(item->isMemberOf(FXMETACLASS(FXRbTreeItem))){
        dynamic_cast<FXRbTreeItem*>(item)->owner=self;
	}
      return self->addItemBefore(other,item,notify);
      }
FXTreeItem *FXTreeList_addItemBefore__SWIG_1(FXTreeList *self,FXTreeItem *other,FXString const &text,FXIcon *oi,FXIcon *ci,void *ITEMDATA,FXbool notify){
      FXTreeItem* item=self->addItemBefore(other,text,oi,ci,ITEMDATA,notify);
      if(item->isMemberOf(FXMETACLASS(FXRbTreeItem))){
        dynamic_cast<FXRbTreeItem*>(item)->owner=self;
	}
      return item;
      }
void FXTreeList_removeItem(FXTreeList *self,FXTreeItem *item,FXbool notify){
      // Save pointer(s) to the soon-to-be-destroyed items
      FXObjectListOf<FXTreeItem> items;
      FXRbTreeList::enumerateItem(item,items);
      
      // Do the deed
      self->removeItem(item,notify);
      
      // Now zero-out pointers held by still-alive Ruby objects
      for(FXint i=0;i<items.no();i++){
        FXRbUnregisterRubyObj(items[i]);
        }
      }
void FXTreeList_removeItems(FXTreeList *self,FXTreeItem *fm,FXTreeItem *to,FXbool notify){
      // Save pointer(s) to the soon-to-be-destroyed items
      FXObjectListOf<FXTreeItem> items;
      FXRbTreeList::enumerateItems(fm,to,items);

      // Do the deed
      self->removeItems(fm,to,notify);

      // Now zero-out pointers held by still-alive Ruby objects
      for(FXint i=0;i<items.no();i++){
        FXRbUnregisterRubyObj(items[i]);
        }
      }
void FXTreeList_clearItems(FXTreeList *self,FXbool notify){
      // Save pointer(s) to the soon-to-be-destroyed items
      FXObjectListOf<FXTreeItem> items;
      FXRbTreeList::enumerateItems(self->getFirstItem(),self->getLastItem(),items);

      // Do the deed
      self->clearItems(notify);

      // Now zero-out pointers held by still-alive Ruby objects
      for(FXint i=0;i<items.no();i++){
        FXRbUnregisterRubyObj(items[i]);
        }
      }
void FXTreeList_setItemData(FXTreeList *self,FXTreeItem *item,VALUE ptr){
      self->setItemData(item,(void*) ptr);
      }
VALUE FXTreeList_getItemData(FXTreeList const *self,FXTreeItem const *item){
      return self->getItemData(item) ? (VALUE) self->getItemData(item) : Qnil;
      }
VALUE FXTreeList_position__SWIG_1(FXTreeList const *self){
    FXint x, y;
    self->getPosition(x, y);
    VALUE pos = rb_ary_new();
    rb_ary_push(pos, INT2NUM(x));
    rb_ary_push(pos, INT2NUM(y));
    return pos;
  }

swig_class cFXTreeList;
static void free_FXTreeList(FXTreeList *);

static swig_type_info *FXTreeList_dynamic_cast(void **ptr) {
    FXTreeList **ppTreeList = reinterpret_cast<FXTreeList **>(ptr);
    FXDirList *pDirList=dynamic_cast<FXDirList*>(*ppTreeList);
    if(pDirList){
      *ptr=reinterpret_cast<void*>(pDirList);
      return SWIG_TypeQuery("FXDirList *");
      }
    return 0;
}

FXDirItem *new_FXDirItem(FXString const &text,FXIcon *oi,FXIcon *ci,void *ptr){
      return new FXRbDirItem(text,oi,ci,ptr);
      }

swig_class cFXDirItem;
static void free_FXDirItem(FXDirItem *);
FXDirList *new_FXDirList(FXComposite *p,FXObject *tgt,FXSelector sel,FXuint opts,FXint x,FXint y,FXint w,FXint h){
      return new FXRbDirList(p,tgt,sel,opts,x,y,w,h);
      }
VALUE FXDirList_position__SWIG_1(FXDirList const *self){
    FXint x, y;
    self->getPosition(x, y);
    VALUE pos = rb_ary_new();
    rb_ary_push(pos, INT2NUM(x));
    rb_ary_push(pos, INT2NUM(y));
    return pos;
  }

swig_class cFXDirList;
static void free_FXDirList(FXDirList *);
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE _wrap_FXFoldingItem_allocate(VALUE self) {
#else
     static VALUE _wrap_FXFoldingItem_allocate(int argc, VALUE *argv, VALUE self) {
#endif
         VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_FXFoldingItem);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
         return vresult; }
static VALUE _wrap_new_FXFoldingItem(int argc, VALUE *argv, VALUE self) { FXString *arg1 = 0 ; FXIcon *arg2 = (FXIcon *) 0 ;
    FXIcon *arg3 = (FXIcon *) 0 ; void *arg4 = (void *) 0 ; FXFoldingItem *result; SwigValueWrapper<FXString > p1 ;
    if ((argc < 1) || (argc > 4)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    p1 = to_FXString(argv[0]); arg1 = &p1; if (argc > 1) { SWIG_ConvertPtr(argv[1], (void **) &arg2, SWIGTYPE_p_FXIcon, 1); } 
    if (argc > 2) { SWIG_ConvertPtr(argv[2], (void **) &arg3, SWIGTYPE_p_FXIcon, 1); }  if (argc > 3) {
        SWIG_ConvertPtr(argv[3], (void **) &arg4, 0, 1); }  {
        result = (FXFoldingItem *)new_FXFoldingItem((FXString const &)*arg1,arg2,arg3,arg4);
        DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result); if(rb_block_given_p()){ rb_yield(self); }  }  return self; }
static VALUE _wrap_FXFoldingItem_getParent(int argc, VALUE *argv, VALUE self) { FXFoldingItem *arg1 = (FXFoldingItem *) 0 ;
    FXFoldingItem *result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFoldingItem, 1);
    result = (FXFoldingItem *)((FXFoldingItem const *)arg1)->getParent(); vresult = FXRbGetRubyObj(result, "FXFoldingItem *");
    return vresult; }
static VALUE _wrap_FXFoldingItem_getNext(int argc, VALUE *argv, VALUE self) { FXFoldingItem *arg1 = (FXFoldingItem *) 0 ;
    FXFoldingItem *result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFoldingItem, 1);
    result = (FXFoldingItem *)((FXFoldingItem const *)arg1)->getNext(); vresult = FXRbGetRubyObj(result, "FXFoldingItem *");
    return vresult; }
static VALUE _wrap_FXFoldingItem_getPrev(int argc, VALUE *argv, VALUE self) { FXFoldingItem *arg1 = (FXFoldingItem *) 0 ;
    FXFoldingItem *result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFoldingItem, 1);
    result = (FXFoldingItem *)((FXFoldingItem const *)arg1)->getPrev(); vresult = FXRbGetRubyObj(result, "FXFoldingItem *");
    return vresult; }
static VALUE _wrap_FXFoldingItem_getFirst(int argc, VALUE *argv, VALUE self) { FXFoldingItem *arg1 = (FXFoldingItem *) 0 ;
    FXFoldingItem *result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFoldingItem, 1);
    result = (FXFoldingItem *)((FXFoldingItem const *)arg1)->getFirst(); vresult = FXRbGetRubyObj(result, "FXFoldingItem *");
    return vresult; }
static VALUE _wrap_FXFoldingItem_getLast(int argc, VALUE *argv, VALUE self) { FXFoldingItem *arg1 = (FXFoldingItem *) 0 ;
    FXFoldingItem *result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFoldingItem, 1);
    result = (FXFoldingItem *)((FXFoldingItem const *)arg1)->getLast(); vresult = FXRbGetRubyObj(result, "FXFoldingItem *");
    return vresult; }
static VALUE _wrap_FXFoldingItem_getBelow(int argc, VALUE *argv, VALUE self) { FXFoldingItem *arg1 = (FXFoldingItem *) 0 ;
    FXFoldingItem *result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFoldingItem, 1);
    result = (FXFoldingItem *)((FXFoldingItem const *)arg1)->getBelow(); vresult = FXRbGetRubyObj(result, "FXFoldingItem *");
    return vresult; }
static VALUE _wrap_FXFoldingItem_getAbove(int argc, VALUE *argv, VALUE self) { FXFoldingItem *arg1 = (FXFoldingItem *) 0 ;
    FXFoldingItem *result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFoldingItem, 1);
    result = (FXFoldingItem *)((FXFoldingItem const *)arg1)->getAbove(); vresult = FXRbGetRubyObj(result, "FXFoldingItem *");
    return vresult; }
static VALUE _wrap_FXFoldingItem_getNumChildren(int argc, VALUE *argv, VALUE self) { FXFoldingItem *arg1 = (FXFoldingItem *) 0 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFoldingItem, 1);
    result = (FXint)((FXFoldingItem const *)arg1)->getNumChildren(); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXFoldingItem_getText(int argc, VALUE *argv, VALUE self) { FXFoldingItem *arg1 = (FXFoldingItem *) 0 ;
    FXString *result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFoldingItem, 1); {
        FXString const &_result_ref = ((FXFoldingItem const *)arg1)->getText(); result = (FXString *) &_result_ref; } 
    vresult = rb_str_new2(result->text()); return vresult; }
static VALUE _wrap_FXFoldingItem_getOpenIcon(int argc, VALUE *argv, VALUE self) { FXFoldingItem *arg1 = (FXFoldingItem *) 0 ;
    FXIcon *result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFoldingItem, 1);
    result = (FXIcon *)((FXFoldingItem const *)arg1)->getOpenIcon(); {
        swig_type_info *ty = SWIG_TypeDynamicCast(SWIGTYPE_p_FXIcon, (void **) &result); vresult = FXRbGetRubyObj(result, ty); }
     return vresult; }
static VALUE _wrap_FXFoldingItem_getClosedIcon(int argc, VALUE *argv, VALUE self) { FXFoldingItem *arg1 = (FXFoldingItem *) 0 ;
    FXIcon *result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFoldingItem, 1);
    result = (FXIcon *)((FXFoldingItem const *)arg1)->getClosedIcon(); {
        swig_type_info *ty = SWIG_TypeDynamicCast(SWIGTYPE_p_FXIcon, (void **) &result); vresult = FXRbGetRubyObj(result, ty); }
     return vresult; }
static VALUE _wrap_FXFoldingItem_setData(int argc, VALUE *argv, VALUE self) { FXFoldingItem *arg1 = (FXFoldingItem *) 0 ;
    VALUE arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFoldingItem, 1); arg2 = argv[0]; FXFoldingItem_setData(arg1,arg2);
    return Qnil; }
static VALUE _wrap_FXFoldingItem_getData(int argc, VALUE *argv, VALUE self) { FXFoldingItem *arg1 = (FXFoldingItem *) 0 ;
    VALUE result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFoldingItem, 1);
    result = (VALUE)FXFoldingItem_getData((FXFoldingItem const *)arg1); vresult = result; return vresult; }
static VALUE _wrap_FXFoldingItem_hasFocus(int argc, VALUE *argv, VALUE self) { FXFoldingItem *arg1 = (FXFoldingItem *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFoldingItem, 1);
    result = (FXbool)((FXFoldingItem const *)arg1)->hasFocus(); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXFoldingItem_isSelected(int argc, VALUE *argv, VALUE self) { FXFoldingItem *arg1 = (FXFoldingItem *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFoldingItem, 1);
    result = (FXbool)((FXFoldingItem const *)arg1)->isSelected(); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXFoldingItem_isOpened(int argc, VALUE *argv, VALUE self) { FXFoldingItem *arg1 = (FXFoldingItem *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFoldingItem, 1);
    result = (FXbool)((FXFoldingItem const *)arg1)->isOpened(); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXFoldingItem_isExpanded(int argc, VALUE *argv, VALUE self) { FXFoldingItem *arg1 = (FXFoldingItem *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFoldingItem, 1);
    result = (FXbool)((FXFoldingItem const *)arg1)->isExpanded(); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXFoldingItem_isEnabled(int argc, VALUE *argv, VALUE self) { FXFoldingItem *arg1 = (FXFoldingItem *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFoldingItem, 1);
    result = (FXbool)((FXFoldingItem const *)arg1)->isEnabled(); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXFoldingItem_isDraggable(int argc, VALUE *argv, VALUE self) { FXFoldingItem *arg1 = (FXFoldingItem *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFoldingItem, 1);
    result = (FXbool)((FXFoldingItem const *)arg1)->isDraggable(); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXFoldingItem_isIconOwned(int argc, VALUE *argv, VALUE self) { FXFoldingItem *arg1 = (FXFoldingItem *) 0 ;
    FXuint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFoldingItem, 1);
    result = (FXuint)((FXFoldingItem const *)arg1)->isIconOwned(); vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXFoldingItem_hasItemsq___(int argc, VALUE *argv, VALUE self) { FXFoldingItem *arg1 = (FXFoldingItem *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFoldingItem, 1);
    result = (FXbool)((FXFoldingItem const *)arg1)->hasItems(); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXFoldingItem_hasItemse___(int argc, VALUE *argv, VALUE self) { FXFoldingItem *arg1 = (FXFoldingItem *) 0 ;
    FXbool arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFoldingItem, 1); arg2 = to_FXbool(argv[0]); (arg1)->setHasItems(arg2);
    return Qnil; }
static VALUE _wrap_FXFoldingItem_isChildOf(int argc, VALUE *argv, VALUE self) { FXFoldingItem *arg1 = (FXFoldingItem *) 0 ;
    FXFoldingItem *arg2 = (FXFoldingItem *) 0 ; FXbool result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFoldingItem, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXFoldingItem, 1);
    result = (FXbool)((FXFoldingItem const *)arg1)->isChildOf((FXFoldingItem const *)arg2); vresult = result ? Qtrue : Qfalse;
    return vresult; }
static VALUE _wrap_FXFoldingItem_isParentOf(int argc, VALUE *argv, VALUE self) { FXFoldingItem *arg1 = (FXFoldingItem *) 0 ;
    FXFoldingItem *arg2 = (FXFoldingItem *) 0 ; FXbool result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFoldingItem, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXFoldingItem, 1);
    result = (FXbool)((FXFoldingItem const *)arg1)->isParentOf((FXFoldingItem const *)arg2); vresult = result ? Qtrue : Qfalse;
    return vresult; }
static void
free_FXFoldingItem(FXFoldingItem *arg1) {
    delete arg1;
}
static VALUE _wrap_FXFoldingItem_save(int argc, VALUE *argv, VALUE self) { FXFoldingItem *arg1 = (FXFoldingItem *) 0 ;
    FXStream *arg2 = 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFoldingItem, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXFoldingItem_save((FXFoldingItem const *)arg1,*arg2); return Qnil; }
static VALUE _wrap_FXFoldingItem_load(int argc, VALUE *argv, VALUE self) { FXFoldingItem *arg1 = (FXFoldingItem *) 0 ;
    FXStream *arg2 = 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFoldingItem, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXFoldingItem_load(arg1,*arg2); return Qnil; }
static VALUE _wrap_FXFoldingItem_setText(int argc, VALUE *argv, VALUE self) { FXFoldingItem *arg1 = (FXFoldingItem *) 0 ;
    FXString *arg2 = 0 ; SwigValueWrapper<FXString > p2 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFoldingItem, 1); p2 = to_FXString(argv[0]); arg2 = &p2;
    FXFoldingItem_setText(arg1,(FXString const &)*arg2); return Qnil; }
static VALUE _wrap_FXFoldingItem_setOpenIcon(int argc, VALUE *argv, VALUE self) { FXFoldingItem *arg1 = (FXFoldingItem *) 0 ;
    FXIcon *arg2 = (FXIcon *) 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFoldingItem, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXIcon, 1); FXFoldingItem_setOpenIcon(arg1,arg2); return Qnil; }
static VALUE _wrap_FXFoldingItem_setClosedIcon(int argc, VALUE *argv, VALUE self) { FXFoldingItem *arg1 = (FXFoldingItem *) 0 ;
    FXIcon *arg2 = (FXIcon *) 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFoldingItem, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXIcon, 1); FXFoldingItem_setClosedIcon(arg1,arg2); return Qnil; }
static VALUE _wrap_FXFoldingItem_setFocus(int argc, VALUE *argv, VALUE self) { FXFoldingItem *arg1 = (FXFoldingItem *) 0 ;
    FXbool arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFoldingItem, 1); arg2 = to_FXbool(argv[0]);
    FXFoldingItem_setFocus(arg1,arg2); return Qnil; }
static VALUE _wrap_FXFoldingItem_setSelected(int argc, VALUE *argv, VALUE self) { FXFoldingItem *arg1 = (FXFoldingItem *) 0 ;
    FXbool arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFoldingItem, 1); arg2 = to_FXbool(argv[0]);
    FXFoldingItem_setSelected(arg1,arg2); return Qnil; }
static VALUE _wrap_FXFoldingItem_setOpened(int argc, VALUE *argv, VALUE self) { FXFoldingItem *arg1 = (FXFoldingItem *) 0 ;
    FXbool arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFoldingItem, 1); arg2 = to_FXbool(argv[0]);
    FXFoldingItem_setOpened(arg1,arg2); return Qnil; }
static VALUE _wrap_FXFoldingItem_setExpanded(int argc, VALUE *argv, VALUE self) { FXFoldingItem *arg1 = (FXFoldingItem *) 0 ;
    FXbool arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFoldingItem, 1); arg2 = to_FXbool(argv[0]);
    FXFoldingItem_setExpanded(arg1,arg2); return Qnil; }
static VALUE _wrap_FXFoldingItem_setEnabled(int argc, VALUE *argv, VALUE self) { FXFoldingItem *arg1 = (FXFoldingItem *) 0 ;
    FXbool arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFoldingItem, 1); arg2 = to_FXbool(argv[0]);
    FXFoldingItem_setEnabled(arg1,arg2); return Qnil; }
static VALUE _wrap_FXFoldingItem_setDraggable(int argc, VALUE *argv, VALUE self) { FXFoldingItem *arg1 = (FXFoldingItem *) 0 ;
    FXbool arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFoldingItem, 1); arg2 = to_FXbool(argv[0]);
    FXFoldingItem_setDraggable(arg1,arg2); return Qnil; }
static VALUE _wrap_FXFoldingItem_setIconOwned(int argc, VALUE *argv, VALUE self) { FXFoldingItem *arg1 = (FXFoldingItem *) 0 ;
    FXuint arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFoldingItem, 1); arg2 = NUM2UINT(argv[0]);
    FXFoldingItem_setIconOwned(arg1,arg2); return Qnil; }
static VALUE _wrap_FXFoldingItem_getWidth(int argc, VALUE *argv, VALUE self) { FXFoldingItem *arg1 = (FXFoldingItem *) 0 ;
    FXFoldingList *arg2 = (FXFoldingList *) 0 ; FXint result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFoldingItem, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXFoldingList, 1);
    result = (FXint)FXFoldingItem_getWidth((FXFoldingItem const *)arg1,(FXFoldingList const *)arg2); vresult = INT2NUM(result);
    return vresult; }
static VALUE _wrap_FXFoldingItem_getHeight(int argc, VALUE *argv, VALUE self) { FXFoldingItem *arg1 = (FXFoldingItem *) 0 ;
    FXFoldingList *arg2 = (FXFoldingList *) 0 ; FXint result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFoldingItem, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXFoldingList, 1);
    result = (FXint)FXFoldingItem_getHeight((FXFoldingItem const *)arg1,(FXFoldingList const *)arg2); vresult = INT2NUM(result);
    return vresult; }
static VALUE _wrap_FXFoldingItem_create(int argc, VALUE *argv, VALUE self) { FXFoldingItem *arg1 = (FXFoldingItem *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFoldingItem, 1); FXFoldingItem_create(arg1); return Qnil; }
static VALUE _wrap_FXFoldingItem_detach(int argc, VALUE *argv, VALUE self) { FXFoldingItem *arg1 = (FXFoldingItem *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFoldingItem, 1); FXFoldingItem_detach(arg1); return Qnil; }
static VALUE _wrap_FXFoldingItem_destroy(int argc, VALUE *argv, VALUE self) { FXFoldingItem *arg1 = (FXFoldingItem *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFoldingItem, 1); FXFoldingItem_destroy(arg1); return Qnil; }
static VALUE _wrap_FXFoldingList_onPaint(int argc, VALUE *argv, VALUE self) { FXFoldingList *arg1 = (FXFoldingList *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFoldingList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]);
    SWIG_ConvertPtr(argv[2], (void **) &arg4, 0, 1); result = (long)(arg1)->onPaint(arg2,arg3,arg4); vresult = INT2NUM(result);
    return vresult; }
static VALUE _wrap_FXFoldingList_onEnter(int argc, VALUE *argv, VALUE self) { FXFoldingList *arg1 = (FXFoldingList *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFoldingList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]);
    SWIG_ConvertPtr(argv[2], (void **) &arg4, 0, 1); result = (long)(arg1)->onEnter(arg2,arg3,arg4); vresult = INT2NUM(result);
    return vresult; }
static VALUE _wrap_FXFoldingList_onLeave(int argc, VALUE *argv, VALUE self) { FXFoldingList *arg1 = (FXFoldingList *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFoldingList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]);
    SWIG_ConvertPtr(argv[2], (void **) &arg4, 0, 1); result = (long)(arg1)->onLeave(arg2,arg3,arg4); vresult = INT2NUM(result);
    return vresult; }
static VALUE _wrap_FXFoldingList_onUngrabbed(int argc, VALUE *argv, VALUE self) { FXFoldingList *arg1 = (FXFoldingList *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFoldingList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]);
    SWIG_ConvertPtr(argv[2], (void **) &arg4, 0, 1); result = (long)(arg1)->onUngrabbed(arg2,arg3,arg4);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXFoldingList_onMotion(int argc, VALUE *argv, VALUE self) { FXFoldingList *arg1 = (FXFoldingList *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFoldingList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]);
    SWIG_ConvertPtr(argv[2], (void **) &arg4, 0, 1); result = (long)(arg1)->onMotion(arg2,arg3,arg4); vresult = INT2NUM(result);
    return vresult; }
static VALUE _wrap_FXFoldingList_onKeyPress(int argc, VALUE *argv, VALUE self) { FXFoldingList *arg1 = (FXFoldingList *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFoldingList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]);
    SWIG_ConvertPtr(argv[2], (void **) &arg4, 0, 1); result = (long)(arg1)->onKeyPress(arg2,arg3,arg4);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXFoldingList_onKeyRelease(int argc, VALUE *argv, VALUE self) { FXFoldingList *arg1 = (FXFoldingList *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFoldingList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]);
    SWIG_ConvertPtr(argv[2], (void **) &arg4, 0, 1); result = (long)(arg1)->onKeyRelease(arg2,arg3,arg4);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXFoldingList_onLeftBtnPress(int argc, VALUE *argv, VALUE self) { FXFoldingList *arg1 = (FXFoldingList *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFoldingList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]);
    SWIG_ConvertPtr(argv[2], (void **) &arg4, 0, 1); result = (long)(arg1)->onLeftBtnPress(arg2,arg3,arg4);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXFoldingList_onLeftBtnRelease(int argc, VALUE *argv, VALUE self) {
    FXFoldingList *arg1 = (FXFoldingList *) 0 ; FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ;
    long result; VALUE vresult = Qnil; if ((argc < 3) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFoldingList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]);
    SWIG_ConvertPtr(argv[2], (void **) &arg4, 0, 1); result = (long)(arg1)->onLeftBtnRelease(arg2,arg3,arg4);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXFoldingList_onRightBtnPress(int argc, VALUE *argv, VALUE self) {
    FXFoldingList *arg1 = (FXFoldingList *) 0 ; FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ;
    long result; VALUE vresult = Qnil; if ((argc < 3) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFoldingList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]);
    SWIG_ConvertPtr(argv[2], (void **) &arg4, 0, 1); result = (long)(arg1)->onRightBtnPress(arg2,arg3,arg4);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXFoldingList_onRightBtnRelease(int argc, VALUE *argv, VALUE self) {
    FXFoldingList *arg1 = (FXFoldingList *) 0 ; FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ;
    long result; VALUE vresult = Qnil; if ((argc < 3) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFoldingList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]);
    SWIG_ConvertPtr(argv[2], (void **) &arg4, 0, 1); result = (long)(arg1)->onRightBtnRelease(arg2,arg3,arg4);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXFoldingList_onHeaderChanged(int argc, VALUE *argv, VALUE self) {
    FXFoldingList *arg1 = (FXFoldingList *) 0 ; FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ;
    long result; VALUE vresult = Qnil; if ((argc < 3) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFoldingList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]);
    SWIG_ConvertPtr(argv[2], (void **) &arg4, 0, 1); result = (long)(arg1)->onHeaderChanged(arg2,arg3,arg4);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXFoldingList_onQueryTip(int argc, VALUE *argv, VALUE self) { FXFoldingList *arg1 = (FXFoldingList *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFoldingList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]);
    SWIG_ConvertPtr(argv[2], (void **) &arg4, 0, 1); result = (long)(arg1)->onQueryTip(arg2,arg3,arg4);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXFoldingList_onQueryHelp(int argc, VALUE *argv, VALUE self) { FXFoldingList *arg1 = (FXFoldingList *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFoldingList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]);
    SWIG_ConvertPtr(argv[2], (void **) &arg4, 0, 1); result = (long)(arg1)->onQueryHelp(arg2,arg3,arg4);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXFoldingList_onTipTimer(int argc, VALUE *argv, VALUE self) { FXFoldingList *arg1 = (FXFoldingList *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFoldingList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]);
    SWIG_ConvertPtr(argv[2], (void **) &arg4, 0, 1); result = (long)(arg1)->onTipTimer(arg2,arg3,arg4);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXFoldingList_onFocusIn(int argc, VALUE *argv, VALUE self) { FXFoldingList *arg1 = (FXFoldingList *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFoldingList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]);
    SWIG_ConvertPtr(argv[2], (void **) &arg4, 0, 1); result = (long)(arg1)->onFocusIn(arg2,arg3,arg4);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXFoldingList_onFocusOut(int argc, VALUE *argv, VALUE self) { FXFoldingList *arg1 = (FXFoldingList *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFoldingList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]);
    SWIG_ConvertPtr(argv[2], (void **) &arg4, 0, 1); result = (long)(arg1)->onFocusOut(arg2,arg3,arg4);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXFoldingList_onAutoScroll(int argc, VALUE *argv, VALUE self) { FXFoldingList *arg1 = (FXFoldingList *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFoldingList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]);
    SWIG_ConvertPtr(argv[2], (void **) &arg4, 0, 1); result = (long)(arg1)->onAutoScroll(arg2,arg3,arg4);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXFoldingList_onClicked(int argc, VALUE *argv, VALUE self) { FXFoldingList *arg1 = (FXFoldingList *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFoldingList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]);
    SWIG_ConvertPtr(argv[2], (void **) &arg4, 0, 1); result = (long)(arg1)->onClicked(arg2,arg3,arg4);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXFoldingList_onDoubleClicked(int argc, VALUE *argv, VALUE self) {
    FXFoldingList *arg1 = (FXFoldingList *) 0 ; FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ;
    long result; VALUE vresult = Qnil; if ((argc < 3) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFoldingList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]);
    SWIG_ConvertPtr(argv[2], (void **) &arg4, 0, 1); result = (long)(arg1)->onDoubleClicked(arg2,arg3,arg4);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXFoldingList_onTripleClicked(int argc, VALUE *argv, VALUE self) {
    FXFoldingList *arg1 = (FXFoldingList *) 0 ; FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ;
    long result; VALUE vresult = Qnil; if ((argc < 3) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFoldingList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]);
    SWIG_ConvertPtr(argv[2], (void **) &arg4, 0, 1); result = (long)(arg1)->onTripleClicked(arg2,arg3,arg4);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXFoldingList_onCommand(int argc, VALUE *argv, VALUE self) { FXFoldingList *arg1 = (FXFoldingList *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFoldingList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]);
    SWIG_ConvertPtr(argv[2], (void **) &arg4, 0, 1); result = (long)(arg1)->onCommand(arg2,arg3,arg4);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXFoldingList_onLookupTimer(int argc, VALUE *argv, VALUE self) { FXFoldingList *arg1 = (FXFoldingList *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFoldingList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]);
    SWIG_ConvertPtr(argv[2], (void **) &arg4, 0, 1); result = (long)(arg1)->onLookupTimer(arg2,arg3,arg4);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXFoldingList_ascending(int argc, VALUE *argv, VALUE self) { FXFoldingItem *arg1 = (FXFoldingItem *) 0 ;
    FXFoldingItem *arg2 = (FXFoldingItem *) 0 ; FXint result; VALUE vresult = Qnil; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXFoldingItem, 1);
    SWIG_ConvertPtr(argv[1], (void **) &arg2, SWIGTYPE_p_FXFoldingItem, 1);
    result = (FXint)FXFoldingList::ascending((FXFoldingItem const *)arg1,(FXFoldingItem const *)arg2);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXFoldingList_descending(int argc, VALUE *argv, VALUE self) { FXFoldingItem *arg1 = (FXFoldingItem *) 0 ;
    FXFoldingItem *arg2 = (FXFoldingItem *) 0 ; FXint result; VALUE vresult = Qnil; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXFoldingItem, 1);
    SWIG_ConvertPtr(argv[1], (void **) &arg2, SWIGTYPE_p_FXFoldingItem, 1);
    result = (FXint)FXFoldingList::descending((FXFoldingItem const *)arg1,(FXFoldingItem const *)arg2);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXFoldingList_ascendingCase(int argc, VALUE *argv, VALUE self) { FXFoldingItem *arg1 = (FXFoldingItem *) 0 ;
    FXFoldingItem *arg2 = (FXFoldingItem *) 0 ; FXint result; VALUE vresult = Qnil; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXFoldingItem, 1);
    SWIG_ConvertPtr(argv[1], (void **) &arg2, SWIGTYPE_p_FXFoldingItem, 1);
    result = (FXint)FXFoldingList::ascendingCase((FXFoldingItem const *)arg1,(FXFoldingItem const *)arg2);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXFoldingList_descendingCase(int argc, VALUE *argv, VALUE self) { FXFoldingItem *arg1 = (FXFoldingItem *) 0 ;
    FXFoldingItem *arg2 = (FXFoldingItem *) 0 ; FXint result; VALUE vresult = Qnil; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXFoldingItem, 1);
    SWIG_ConvertPtr(argv[1], (void **) &arg2, SWIGTYPE_p_FXFoldingItem, 1);
    result = (FXint)FXFoldingList::descendingCase((FXFoldingItem const *)arg1,(FXFoldingItem const *)arg2);
    vresult = INT2NUM(result); return vresult; }
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE _wrap_FXFoldingList_allocate(VALUE self) {
#else
     static VALUE _wrap_FXFoldingList_allocate(int argc, VALUE *argv, VALUE self) {
#endif
         VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_FXFoldingList);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
         return vresult; }
static VALUE _wrap_new_FXFoldingList(int argc, VALUE *argv, VALUE self) { FXComposite *arg1 = (FXComposite *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 = (FXSelector) 0 ; FXuint arg4 = (FXuint) FOLDINGLIST_NORMAL ;
    FXint arg5 = (FXint) 0 ; FXint arg6 = (FXint) 0 ; FXint arg7 = (FXint) 0 ; FXint arg8 = (FXint) 0 ; FXFoldingList *result;
    if ((argc < 1) || (argc > 8)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXComposite, 1); if (argc > 1) {
        SWIG_ConvertPtr(argv[1], (void **) &arg2, SWIGTYPE_p_FXObject, 1); }  if (argc > 2) { arg3 = NUM2UINT(argv[2]); } 
    if (argc > 3) { arg4 = NUM2UINT(argv[3]); }  if (argc > 4) { arg5 = NUM2INT(argv[4]); }  if (argc > 5) {
        arg6 = NUM2INT(argv[5]); }  if (argc > 6) { arg7 = NUM2INT(argv[6]); }  if (argc > 7) { arg8 = NUM2INT(argv[7]); }  {
        result = (FXFoldingList *)new_FXFoldingList(arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8);
        DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result); if(rb_block_given_p()){ rb_yield(self); }  }  return self; }
static VALUE _wrap_FXFoldingList_getHeader(int argc, VALUE *argv, VALUE self) { FXFoldingList *arg1 = (FXFoldingList *) 0 ;
    FXHeader *result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFoldingList, 1);
    result = (FXHeader *)((FXFoldingList const *)arg1)->getHeader(); {
        swig_type_info *ty = SWIG_TypeDynamicCast(SWIGTYPE_p_FXHeader, (void **) &result);
        vresult = FXRbGetRubyObj(result, ty); }  return vresult; }
static VALUE _wrap_FXFoldingList_appendHeader(int argc, VALUE *argv, VALUE self) { FXFoldingList *arg1 = (FXFoldingList *) 0 ;
    FXString *arg2 = 0 ; FXIcon *arg3 = (FXIcon *) 0 ; FXint arg4 = (FXint) 1 ; SwigValueWrapper<FXString > p2 ;
    if ((argc < 1) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFoldingList, 1); p2 = to_FXString(argv[0]); arg2 = &p2; if (argc > 1) {
        SWIG_ConvertPtr(argv[1], (void **) &arg3, SWIGTYPE_p_FXIcon, 1); }  if (argc > 2) { arg4 = NUM2INT(argv[2]); } 
    (arg1)->appendHeader((FXString const &)*arg2,arg3,arg4); return Qnil; }
static VALUE _wrap_FXFoldingList_removeHeader(int argc, VALUE *argv, VALUE self) { FXFoldingList *arg1 = (FXFoldingList *) 0 ;
    FXint arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFoldingList, 1); arg2 = NUM2INT(argv[0]); (arg1)->removeHeader(arg2);
    return Qnil; }
static VALUE _wrap_FXFoldingList_setHeaderText(int argc, VALUE *argv, VALUE self) { FXFoldingList *arg1 = (FXFoldingList *) 0 ;
    FXint arg2 ; FXString *arg3 = 0 ; SwigValueWrapper<FXString > p3 ; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFoldingList, 1); arg2 = NUM2INT(argv[0]);
    p3 = to_FXString(argv[1]); arg3 = &p3; (arg1)->setHeaderText(arg2,(FXString const &)*arg3); return Qnil; }
static VALUE _wrap_FXFoldingList_getHeaderText(int argc, VALUE *argv, VALUE self) { FXFoldingList *arg1 = (FXFoldingList *) 0 ;
    FXint arg2 ; FXString result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFoldingList, 1); arg2 = NUM2INT(argv[0]);
    result = ((FXFoldingList const *)arg1)->getHeaderText(arg2); vresult = rb_str_new2((&result)->text()); return vresult; }
static VALUE _wrap_FXFoldingList_setHeaderIcon(int argc, VALUE *argv, VALUE self) { FXFoldingList *arg1 = (FXFoldingList *) 0 ;
    FXint arg2 ; FXIcon *arg3 = (FXIcon *) 0 ; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFoldingList, 1); arg2 = NUM2INT(argv[0]);
    SWIG_ConvertPtr(argv[1], (void **) &arg3, SWIGTYPE_p_FXIcon, 1); (arg1)->setHeaderIcon(arg2,arg3); return Qnil; }
static VALUE _wrap_FXFoldingList_getHeaderIcon(int argc, VALUE *argv, VALUE self) { FXFoldingList *arg1 = (FXFoldingList *) 0 ;
    FXint arg2 ; FXIcon *result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFoldingList, 1); arg2 = NUM2INT(argv[0]);
    result = (FXIcon *)((FXFoldingList const *)arg1)->getHeaderIcon(arg2); {
        swig_type_info *ty = SWIG_TypeDynamicCast(SWIGTYPE_p_FXIcon, (void **) &result); vresult = FXRbGetRubyObj(result, ty); }
     return vresult; }
static VALUE _wrap_FXFoldingList_setHeaderSize(int argc, VALUE *argv, VALUE self) { FXFoldingList *arg1 = (FXFoldingList *) 0 ;
    FXint arg2 ; FXint arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFoldingList, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    (arg1)->setHeaderSize(arg2,arg3); return Qnil; }
static VALUE _wrap_FXFoldingList_getHeaderSize(int argc, VALUE *argv, VALUE self) { FXFoldingList *arg1 = (FXFoldingList *) 0 ;
    FXint arg2 ; FXint result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFoldingList, 1); arg2 = NUM2INT(argv[0]);
    result = (FXint)((FXFoldingList const *)arg1)->getHeaderSize(arg2); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXFoldingList_getNumHeaders(int argc, VALUE *argv, VALUE self) { FXFoldingList *arg1 = (FXFoldingList *) 0 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFoldingList, 1);
    result = (FXint)((FXFoldingList const *)arg1)->getNumHeaders(); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXFoldingList_getNumItems(int argc, VALUE *argv, VALUE self) { FXFoldingList *arg1 = (FXFoldingList *) 0 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFoldingList, 1);
    result = (FXint)((FXFoldingList const *)arg1)->getNumItems(); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXFoldingList_getNumVisible(int argc, VALUE *argv, VALUE self) { FXFoldingList *arg1 = (FXFoldingList *) 0 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFoldingList, 1);
    result = (FXint)((FXFoldingList const *)arg1)->getNumVisible(); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXFoldingList_setNumVisible(int argc, VALUE *argv, VALUE self) { FXFoldingList *arg1 = (FXFoldingList *) 0 ;
    FXint arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFoldingList, 1); arg2 = NUM2INT(argv[0]); (arg1)->setNumVisible(arg2);
    return Qnil; }
static VALUE _wrap_FXFoldingList_getFirstItem(int argc, VALUE *argv, VALUE self) { FXFoldingList *arg1 = (FXFoldingList *) 0 ;
    FXFoldingItem *result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFoldingList, 1);
    result = (FXFoldingItem *)((FXFoldingList const *)arg1)->getFirstItem();
    vresult = FXRbGetRubyObj(result, "FXFoldingItem *"); return vresult; }
static VALUE _wrap_FXFoldingList_getLastItem(int argc, VALUE *argv, VALUE self) { FXFoldingList *arg1 = (FXFoldingList *) 0 ;
    FXFoldingItem *result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFoldingList, 1);
    result = (FXFoldingItem *)((FXFoldingList const *)arg1)->getLastItem(); vresult = FXRbGetRubyObj(result, "FXFoldingItem *");
    return vresult; }
static VALUE _wrap_FXFoldingList_addItemFirst__SWIG_0(int argc, VALUE *argv, VALUE self) {
    FXFoldingList *arg1 = (FXFoldingList *) 0 ; FXFoldingItem *arg2 = (FXFoldingItem *) 0 ;
    FXFoldingItem *arg3 = (FXFoldingItem *) 0 ; FXbool arg4 = (FXbool) 0 ; FXFoldingItem *result; VALUE vresult = Qnil;
    if ((argc < 2) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFoldingList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXFoldingItem, 1);
    SWIG_ConvertPtr(argv[1], (void **) &arg3, SWIGTYPE_p_FXFoldingItem, 1); if (argc > 2) { arg4 = to_FXbool(argv[2]); } 
    result = (FXFoldingItem *)FXFoldingList_addItemFirst__SWIG_0(arg1,arg2,arg3,arg4);
    vresult = FXRbGetRubyObj(result, "FXFoldingItem *"); return vresult; }
static VALUE _wrap_FXFoldingList_addItemFirst__SWIG_1(int argc, VALUE *argv, VALUE self) {
    FXFoldingList *arg1 = (FXFoldingList *) 0 ; FXFoldingItem *arg2 = (FXFoldingItem *) 0 ; FXString *arg3 = 0 ;
    FXIcon *arg4 = (FXIcon *) 0 ; FXIcon *arg5 = (FXIcon *) 0 ; void *arg6 = (void *) 0 ; FXbool arg7 = (FXbool) 0 ;
    FXFoldingItem *result; SwigValueWrapper<FXString > p3 ; VALUE vresult = Qnil; if ((argc < 2) || (argc > 6))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFoldingList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXFoldingItem, 1); p3 = to_FXString(argv[1]); arg3 = &p3;
    if (argc > 2) { SWIG_ConvertPtr(argv[2], (void **) &arg4, SWIGTYPE_p_FXIcon, 1); }  if (argc > 3) {
        SWIG_ConvertPtr(argv[3], (void **) &arg5, SWIGTYPE_p_FXIcon, 1); }  if (argc > 4) {
        SWIG_ConvertPtr(argv[4], (void **) &arg6, 0, 1); }  if (argc > 5) { arg7 = to_FXbool(argv[5]); } 
    result = (FXFoldingItem *)(arg1)->addItemFirst(arg2,(FXString const &)*arg3,arg4,arg5,arg6,arg7);
    vresult = FXRbGetRubyObj(result, "FXFoldingItem *"); return vresult; }
static VALUE _wrap_FXFoldingList_addItemFirst(int nargs, VALUE *args, VALUE self) { int argc; VALUE argv[8]; int ii;
    argc = nargs + 1; argv[0] = self; for (ii = 1; (ii < argc) && (ii < 7); ii++) { argv[ii] = args[ii-1]; } 
    if ((argc >= 3) && (argc <= 4)) { int _v; { void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXFoldingList, 0) != -1)) ? 1 : 0; }
         if (_v) { { void *ptr;
                _v = (NIL_P(argv[1]) || (TYPE(argv[1]) == T_DATA && SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_FXFoldingItem, 0) != -1)) ? 1 : 0; }
             if (_v) { { void *ptr;
                    _v = (NIL_P(argv[2]) || (TYPE(argv[2]) == T_DATA && SWIG_ConvertPtr(argv[2], &ptr, SWIGTYPE_p_FXFoldingItem, 0) != -1)) ? 1 : 0; }
                 if (_v) { if (argc <= 3) { return _wrap_FXFoldingList_addItemFirst__SWIG_0(nargs, args, self);}  {
                        _v = (argv[3] == Qtrue || argv[3] == Qfalse) ? 1 : 0; }  if (_v) {
                        return _wrap_FXFoldingList_addItemFirst__SWIG_0(nargs, args, self);}  }  }  }  } 
    if ((argc >= 3) && (argc <= 7)) { int _v; { void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXFoldingList, 0) != -1)) ? 1 : 0; }
         if (_v) { { void *ptr;
                _v = (NIL_P(argv[1]) || (TYPE(argv[1]) == T_DATA && SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_FXFoldingItem, 0) != -1)) ? 1 : 0; }
             if (_v) { { _v = (NIL_P(argv[2]) || TYPE(argv[2]) == T_STRING) ? 1 : 0; }  if (_v) { if (argc <= 3) {
                        return _wrap_FXFoldingList_addItemFirst__SWIG_1(nargs, args, self);}  { void *ptr;
                        _v = (NIL_P(argv[3]) || (TYPE(argv[3]) == T_DATA && SWIG_ConvertPtr(argv[3], &ptr, SWIGTYPE_p_FXIcon, 0) != -1)) ? 1 : 0; }
                     if (_v) { if (argc <= 4) { return _wrap_FXFoldingList_addItemFirst__SWIG_1(nargs, args, self);}  {
                            void *ptr;
                            _v = (NIL_P(argv[4]) || (TYPE(argv[4]) == T_DATA && SWIG_ConvertPtr(argv[4], &ptr, SWIGTYPE_p_FXIcon, 0) != -1)) ? 1 : 0; }
                         if (_v) { if (argc <= 5) { return _wrap_FXFoldingList_addItemFirst__SWIG_1(nargs, args, self);}  {
                                void *ptr;
                                _v = (NIL_P(argv[5]) || (TYPE(argv[5]) == T_DATA && SWIG_ConvertPtr(argv[5], &ptr, 0, 0) != -1)) ? 1 : 0; }
                             if (_v) { if (argc <= 6) { return _wrap_FXFoldingList_addItemFirst__SWIG_1(nargs, args, self);}  {
                                    _v = (argv[6] == Qtrue || argv[6] == Qfalse) ? 1 : 0; }  if (_v) {
                                    return _wrap_FXFoldingList_addItemFirst__SWIG_1(nargs, args, self);}  }  }  }  }  }  }  } 
    rb_raise(rb_eArgError, "No matching function for overloaded 'FXFoldingList_addItemFirst'"); return Qnil; }
static VALUE _wrap_FXFoldingList_addItemLast__SWIG_0(int argc, VALUE *argv, VALUE self) {
    FXFoldingList *arg1 = (FXFoldingList *) 0 ; FXFoldingItem *arg2 = (FXFoldingItem *) 0 ;
    FXFoldingItem *arg3 = (FXFoldingItem *) 0 ; FXbool arg4 = (FXbool) 0 ; FXFoldingItem *result; VALUE vresult = Qnil;
    if ((argc < 2) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFoldingList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXFoldingItem, 1);
    SWIG_ConvertPtr(argv[1], (void **) &arg3, SWIGTYPE_p_FXFoldingItem, 1); if (argc > 2) { arg4 = to_FXbool(argv[2]); } 
    result = (FXFoldingItem *)FXFoldingList_addItemLast__SWIG_0(arg1,arg2,arg3,arg4);
    vresult = FXRbGetRubyObj(result, "FXFoldingItem *"); return vresult; }
static VALUE _wrap_FXFoldingList_addItemLast__SWIG_1(int argc, VALUE *argv, VALUE self) {
    FXFoldingList *arg1 = (FXFoldingList *) 0 ; FXFoldingItem *arg2 = (FXFoldingItem *) 0 ; FXString *arg3 = 0 ;
    FXIcon *arg4 = (FXIcon *) 0 ; FXIcon *arg5 = (FXIcon *) 0 ; void *arg6 = (void *) 0 ; FXbool arg7 = (FXbool) 0 ;
    FXFoldingItem *result; SwigValueWrapper<FXString > p3 ; VALUE vresult = Qnil; if ((argc < 2) || (argc > 6))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFoldingList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXFoldingItem, 1); p3 = to_FXString(argv[1]); arg3 = &p3;
    if (argc > 2) { SWIG_ConvertPtr(argv[2], (void **) &arg4, SWIGTYPE_p_FXIcon, 1); }  if (argc > 3) {
        SWIG_ConvertPtr(argv[3], (void **) &arg5, SWIGTYPE_p_FXIcon, 1); }  if (argc > 4) {
        SWIG_ConvertPtr(argv[4], (void **) &arg6, 0, 1); }  if (argc > 5) { arg7 = to_FXbool(argv[5]); } 
    result = (FXFoldingItem *)(arg1)->addItemLast(arg2,(FXString const &)*arg3,arg4,arg5,arg6,arg7);
    vresult = FXRbGetRubyObj(result, "FXFoldingItem *"); return vresult; }
static VALUE _wrap_FXFoldingList_addItemLast(int nargs, VALUE *args, VALUE self) { int argc; VALUE argv[8]; int ii;
    argc = nargs + 1; argv[0] = self; for (ii = 1; (ii < argc) && (ii < 7); ii++) { argv[ii] = args[ii-1]; } 
    if ((argc >= 3) && (argc <= 4)) { int _v; { void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXFoldingList, 0) != -1)) ? 1 : 0; }
         if (_v) { { void *ptr;
                _v = (NIL_P(argv[1]) || (TYPE(argv[1]) == T_DATA && SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_FXFoldingItem, 0) != -1)) ? 1 : 0; }
             if (_v) { { void *ptr;
                    _v = (NIL_P(argv[2]) || (TYPE(argv[2]) == T_DATA && SWIG_ConvertPtr(argv[2], &ptr, SWIGTYPE_p_FXFoldingItem, 0) != -1)) ? 1 : 0; }
                 if (_v) { if (argc <= 3) { return _wrap_FXFoldingList_addItemLast__SWIG_0(nargs, args, self);}  {
                        _v = (argv[3] == Qtrue || argv[3] == Qfalse) ? 1 : 0; }  if (_v) {
                        return _wrap_FXFoldingList_addItemLast__SWIG_0(nargs, args, self);}  }  }  }  } 
    if ((argc >= 3) && (argc <= 7)) { int _v; { void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXFoldingList, 0) != -1)) ? 1 : 0; }
         if (_v) { { void *ptr;
                _v = (NIL_P(argv[1]) || (TYPE(argv[1]) == T_DATA && SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_FXFoldingItem, 0) != -1)) ? 1 : 0; }
             if (_v) { { _v = (NIL_P(argv[2]) || TYPE(argv[2]) == T_STRING) ? 1 : 0; }  if (_v) { if (argc <= 3) {
                        return _wrap_FXFoldingList_addItemLast__SWIG_1(nargs, args, self);}  { void *ptr;
                        _v = (NIL_P(argv[3]) || (TYPE(argv[3]) == T_DATA && SWIG_ConvertPtr(argv[3], &ptr, SWIGTYPE_p_FXIcon, 0) != -1)) ? 1 : 0; }
                     if (_v) { if (argc <= 4) { return _wrap_FXFoldingList_addItemLast__SWIG_1(nargs, args, self);}  {
                            void *ptr;
                            _v = (NIL_P(argv[4]) || (TYPE(argv[4]) == T_DATA && SWIG_ConvertPtr(argv[4], &ptr, SWIGTYPE_p_FXIcon, 0) != -1)) ? 1 : 0; }
                         if (_v) { if (argc <= 5) { return _wrap_FXFoldingList_addItemLast__SWIG_1(nargs, args, self);}  {
                                void *ptr;
                                _v = (NIL_P(argv[5]) || (TYPE(argv[5]) == T_DATA && SWIG_ConvertPtr(argv[5], &ptr, 0, 0) != -1)) ? 1 : 0; }
                             if (_v) { if (argc <= 6) { return _wrap_FXFoldingList_addItemLast__SWIG_1(nargs, args, self);}  {
                                    _v = (argv[6] == Qtrue || argv[6] == Qfalse) ? 1 : 0; }  if (_v) {
                                    return _wrap_FXFoldingList_addItemLast__SWIG_1(nargs, args, self);}  }  }  }  }  }  }  } 
    rb_raise(rb_eArgError, "No matching function for overloaded 'FXFoldingList_addItemLast'"); return Qnil; }
static VALUE _wrap_FXFoldingList_addItemAfter__SWIG_0(int argc, VALUE *argv, VALUE self) {
    FXFoldingList *arg1 = (FXFoldingList *) 0 ; FXFoldingItem *arg2 = (FXFoldingItem *) 0 ;
    FXFoldingItem *arg3 = (FXFoldingItem *) 0 ; FXbool arg4 = (FXbool) 0 ; FXFoldingItem *result; VALUE vresult = Qnil;
    if ((argc < 2) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFoldingList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXFoldingItem, 1);
    SWIG_ConvertPtr(argv[1], (void **) &arg3, SWIGTYPE_p_FXFoldingItem, 1); if (argc > 2) { arg4 = to_FXbool(argv[2]); } 
    result = (FXFoldingItem *)FXFoldingList_addItemAfter__SWIG_0(arg1,arg2,arg3,arg4);
    vresult = FXRbGetRubyObj(result, "FXFoldingItem *"); return vresult; }
static VALUE _wrap_FXFoldingList_addItemAfter__SWIG_1(int argc, VALUE *argv, VALUE self) {
    FXFoldingList *arg1 = (FXFoldingList *) 0 ; FXFoldingItem *arg2 = (FXFoldingItem *) 0 ; FXString *arg3 = 0 ;
    FXIcon *arg4 = (FXIcon *) 0 ; FXIcon *arg5 = (FXIcon *) 0 ; void *arg6 = (void *) 0 ; FXbool arg7 = (FXbool) 0 ;
    FXFoldingItem *result; SwigValueWrapper<FXString > p3 ; VALUE vresult = Qnil; if ((argc < 2) || (argc > 6))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFoldingList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXFoldingItem, 1); p3 = to_FXString(argv[1]); arg3 = &p3;
    if (argc > 2) { SWIG_ConvertPtr(argv[2], (void **) &arg4, SWIGTYPE_p_FXIcon, 1); }  if (argc > 3) {
        SWIG_ConvertPtr(argv[3], (void **) &arg5, SWIGTYPE_p_FXIcon, 1); }  if (argc > 4) {
        SWIG_ConvertPtr(argv[4], (void **) &arg6, 0, 1); }  if (argc > 5) { arg7 = to_FXbool(argv[5]); } 
    result = (FXFoldingItem *)(arg1)->addItemAfter(arg2,(FXString const &)*arg3,arg4,arg5,arg6,arg7);
    vresult = FXRbGetRubyObj(result, "FXFoldingItem *"); return vresult; }
static VALUE _wrap_FXFoldingList_addItemAfter(int nargs, VALUE *args, VALUE self) { int argc; VALUE argv[8]; int ii;
    argc = nargs + 1; argv[0] = self; for (ii = 1; (ii < argc) && (ii < 7); ii++) { argv[ii] = args[ii-1]; } 
    if ((argc >= 3) && (argc <= 4)) { int _v; { void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXFoldingList, 0) != -1)) ? 1 : 0; }
         if (_v) { { void *ptr;
                _v = (NIL_P(argv[1]) || (TYPE(argv[1]) == T_DATA && SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_FXFoldingItem, 0) != -1)) ? 1 : 0; }
             if (_v) { { void *ptr;
                    _v = (NIL_P(argv[2]) || (TYPE(argv[2]) == T_DATA && SWIG_ConvertPtr(argv[2], &ptr, SWIGTYPE_p_FXFoldingItem, 0) != -1)) ? 1 : 0; }
                 if (_v) { if (argc <= 3) { return _wrap_FXFoldingList_addItemAfter__SWIG_0(nargs, args, self);}  {
                        _v = (argv[3] == Qtrue || argv[3] == Qfalse) ? 1 : 0; }  if (_v) {
                        return _wrap_FXFoldingList_addItemAfter__SWIG_0(nargs, args, self);}  }  }  }  } 
    if ((argc >= 3) && (argc <= 7)) { int _v; { void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXFoldingList, 0) != -1)) ? 1 : 0; }
         if (_v) { { void *ptr;
                _v = (NIL_P(argv[1]) || (TYPE(argv[1]) == T_DATA && SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_FXFoldingItem, 0) != -1)) ? 1 : 0; }
             if (_v) { { _v = (NIL_P(argv[2]) || TYPE(argv[2]) == T_STRING) ? 1 : 0; }  if (_v) { if (argc <= 3) {
                        return _wrap_FXFoldingList_addItemAfter__SWIG_1(nargs, args, self);}  { void *ptr;
                        _v = (NIL_P(argv[3]) || (TYPE(argv[3]) == T_DATA && SWIG_ConvertPtr(argv[3], &ptr, SWIGTYPE_p_FXIcon, 0) != -1)) ? 1 : 0; }
                     if (_v) { if (argc <= 4) { return _wrap_FXFoldingList_addItemAfter__SWIG_1(nargs, args, self);}  {
                            void *ptr;
                            _v = (NIL_P(argv[4]) || (TYPE(argv[4]) == T_DATA && SWIG_ConvertPtr(argv[4], &ptr, SWIGTYPE_p_FXIcon, 0) != -1)) ? 1 : 0; }
                         if (_v) { if (argc <= 5) { return _wrap_FXFoldingList_addItemAfter__SWIG_1(nargs, args, self);}  {
                                void *ptr;
                                _v = (NIL_P(argv[5]) || (TYPE(argv[5]) == T_DATA && SWIG_ConvertPtr(argv[5], &ptr, 0, 0) != -1)) ? 1 : 0; }
                             if (_v) { if (argc <= 6) { return _wrap_FXFoldingList_addItemAfter__SWIG_1(nargs, args, self);}  {
                                    _v = (argv[6] == Qtrue || argv[6] == Qfalse) ? 1 : 0; }  if (_v) {
                                    return _wrap_FXFoldingList_addItemAfter__SWIG_1(nargs, args, self);}  }  }  }  }  }  }  } 
    rb_raise(rb_eArgError, "No matching function for overloaded 'FXFoldingList_addItemAfter'"); return Qnil; }
static VALUE _wrap_FXFoldingList_addItemBefore__SWIG_0(int argc, VALUE *argv, VALUE self) {
    FXFoldingList *arg1 = (FXFoldingList *) 0 ; FXFoldingItem *arg2 = (FXFoldingItem *) 0 ;
    FXFoldingItem *arg3 = (FXFoldingItem *) 0 ; FXbool arg4 = (FXbool) 0 ; FXFoldingItem *result; VALUE vresult = Qnil;
    if ((argc < 2) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFoldingList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXFoldingItem, 1);
    SWIG_ConvertPtr(argv[1], (void **) &arg3, SWIGTYPE_p_FXFoldingItem, 1); if (argc > 2) { arg4 = to_FXbool(argv[2]); } 
    result = (FXFoldingItem *)FXFoldingList_addItemBefore__SWIG_0(arg1,arg2,arg3,arg4);
    vresult = FXRbGetRubyObj(result, "FXFoldingItem *"); return vresult; }
static VALUE _wrap_FXFoldingList_addItemBefore__SWIG_1(int argc, VALUE *argv, VALUE self) {
    FXFoldingList *arg1 = (FXFoldingList *) 0 ; FXFoldingItem *arg2 = (FXFoldingItem *) 0 ; FXString *arg3 = 0 ;
    FXIcon *arg4 = (FXIcon *) 0 ; FXIcon *arg5 = (FXIcon *) 0 ; void *arg6 = (void *) 0 ; FXbool arg7 = (FXbool) 0 ;
    FXFoldingItem *result; SwigValueWrapper<FXString > p3 ; VALUE vresult = Qnil; if ((argc < 2) || (argc > 6))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFoldingList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXFoldingItem, 1); p3 = to_FXString(argv[1]); arg3 = &p3;
    if (argc > 2) { SWIG_ConvertPtr(argv[2], (void **) &arg4, SWIGTYPE_p_FXIcon, 1); }  if (argc > 3) {
        SWIG_ConvertPtr(argv[3], (void **) &arg5, SWIGTYPE_p_FXIcon, 1); }  if (argc > 4) {
        SWIG_ConvertPtr(argv[4], (void **) &arg6, 0, 1); }  if (argc > 5) { arg7 = to_FXbool(argv[5]); } 
    result = (FXFoldingItem *)(arg1)->addItemBefore(arg2,(FXString const &)*arg3,arg4,arg5,arg6,arg7);
    vresult = FXRbGetRubyObj(result, "FXFoldingItem *"); return vresult; }
static VALUE _wrap_FXFoldingList_addItemBefore(int nargs, VALUE *args, VALUE self) { int argc; VALUE argv[8]; int ii;
    argc = nargs + 1; argv[0] = self; for (ii = 1; (ii < argc) && (ii < 7); ii++) { argv[ii] = args[ii-1]; } 
    if ((argc >= 3) && (argc <= 4)) { int _v; { void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXFoldingList, 0) != -1)) ? 1 : 0; }
         if (_v) { { void *ptr;
                _v = (NIL_P(argv[1]) || (TYPE(argv[1]) == T_DATA && SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_FXFoldingItem, 0) != -1)) ? 1 : 0; }
             if (_v) { { void *ptr;
                    _v = (NIL_P(argv[2]) || (TYPE(argv[2]) == T_DATA && SWIG_ConvertPtr(argv[2], &ptr, SWIGTYPE_p_FXFoldingItem, 0) != -1)) ? 1 : 0; }
                 if (_v) { if (argc <= 3) { return _wrap_FXFoldingList_addItemBefore__SWIG_0(nargs, args, self);}  {
                        _v = (argv[3] == Qtrue || argv[3] == Qfalse) ? 1 : 0; }  if (_v) {
                        return _wrap_FXFoldingList_addItemBefore__SWIG_0(nargs, args, self);}  }  }  }  } 
    if ((argc >= 3) && (argc <= 7)) { int _v; { void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXFoldingList, 0) != -1)) ? 1 : 0; }
         if (_v) { { void *ptr;
                _v = (NIL_P(argv[1]) || (TYPE(argv[1]) == T_DATA && SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_FXFoldingItem, 0) != -1)) ? 1 : 0; }
             if (_v) { { _v = (NIL_P(argv[2]) || TYPE(argv[2]) == T_STRING) ? 1 : 0; }  if (_v) { if (argc <= 3) {
                        return _wrap_FXFoldingList_addItemBefore__SWIG_1(nargs, args, self);}  { void *ptr;
                        _v = (NIL_P(argv[3]) || (TYPE(argv[3]) == T_DATA && SWIG_ConvertPtr(argv[3], &ptr, SWIGTYPE_p_FXIcon, 0) != -1)) ? 1 : 0; }
                     if (_v) { if (argc <= 4) { return _wrap_FXFoldingList_addItemBefore__SWIG_1(nargs, args, self);}  {
                            void *ptr;
                            _v = (NIL_P(argv[4]) || (TYPE(argv[4]) == T_DATA && SWIG_ConvertPtr(argv[4], &ptr, SWIGTYPE_p_FXIcon, 0) != -1)) ? 1 : 0; }
                         if (_v) { if (argc <= 5) { return _wrap_FXFoldingList_addItemBefore__SWIG_1(nargs, args, self);}  {
                                void *ptr;
                                _v = (NIL_P(argv[5]) || (TYPE(argv[5]) == T_DATA && SWIG_ConvertPtr(argv[5], &ptr, 0, 0) != -1)) ? 1 : 0; }
                             if (_v) { if (argc <= 6) { return _wrap_FXFoldingList_addItemBefore__SWIG_1(nargs, args, self);}  {
                                    _v = (argv[6] == Qtrue || argv[6] == Qfalse) ? 1 : 0; }  if (_v) {
                                    return _wrap_FXFoldingList_addItemBefore__SWIG_1(nargs, args, self);}  }  }  }  }  }  }  } 
    rb_raise(rb_eArgError, "No matching function for overloaded 'FXFoldingList_addItemBefore'"); return Qnil; }
static VALUE _wrap_FXFoldingList_reparentItem(int argc, VALUE *argv, VALUE self) { FXFoldingList *arg1 = (FXFoldingList *) 0 ;
    FXFoldingItem *arg2 = (FXFoldingItem *) 0 ; FXFoldingItem *arg3 = (FXFoldingItem *) 0 ; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFoldingList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXFoldingItem, 1);
    SWIG_ConvertPtr(argv[1], (void **) &arg3, SWIGTYPE_p_FXFoldingItem, 1); (arg1)->reparentItem(arg2,arg3); return Qnil; }
static VALUE _wrap_FXFoldingList_moveItemBefore(int argc, VALUE *argv, VALUE self) { FXFoldingList *arg1 = (FXFoldingList *) 0 ;
    FXFoldingItem *arg2 = (FXFoldingItem *) 0 ; FXFoldingItem *arg3 = (FXFoldingItem *) 0 ; FXFoldingItem *result;
    VALUE vresult = Qnil; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFoldingList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXFoldingItem, 1);
    SWIG_ConvertPtr(argv[1], (void **) &arg3, SWIGTYPE_p_FXFoldingItem, 1);
    result = (FXFoldingItem *)(arg1)->moveItemBefore(arg2,arg3); vresult = FXRbGetRubyObj(result, "FXFoldingItem *");
    return vresult; }
static VALUE _wrap_FXFoldingList_moveItemAfter(int argc, VALUE *argv, VALUE self) { FXFoldingList *arg1 = (FXFoldingList *) 0 ;
    FXFoldingItem *arg2 = (FXFoldingItem *) 0 ; FXFoldingItem *arg3 = (FXFoldingItem *) 0 ; FXFoldingItem *result;
    VALUE vresult = Qnil; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFoldingList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXFoldingItem, 1);
    SWIG_ConvertPtr(argv[1], (void **) &arg3, SWIGTYPE_p_FXFoldingItem, 1);
    result = (FXFoldingItem *)(arg1)->moveItemAfter(arg2,arg3); vresult = FXRbGetRubyObj(result, "FXFoldingItem *");
    return vresult; }
static VALUE _wrap_FXFoldingList_removeItem(int argc, VALUE *argv, VALUE self) { FXFoldingList *arg1 = (FXFoldingList *) 0 ;
    FXFoldingItem *arg2 = (FXFoldingItem *) 0 ; FXbool arg3 = (FXbool) 0 ; if ((argc < 1) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFoldingList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXFoldingItem, 1); if (argc > 1) { arg3 = to_FXbool(argv[1]); } 
    FXFoldingList_removeItem(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXFoldingList_removeItems(int argc, VALUE *argv, VALUE self) { FXFoldingList *arg1 = (FXFoldingList *) 0 ;
    FXFoldingItem *arg2 = (FXFoldingItem *) 0 ; FXFoldingItem *arg3 = (FXFoldingItem *) 0 ; FXbool arg4 = (FXbool) 0 ;
    if ((argc < 2) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFoldingList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXFoldingItem, 1);
    SWIG_ConvertPtr(argv[1], (void **) &arg3, SWIGTYPE_p_FXFoldingItem, 1); if (argc > 2) { arg4 = to_FXbool(argv[2]); } 
    FXFoldingList_removeItems(arg1,arg2,arg3,arg4); return Qnil; }
static VALUE _wrap_FXFoldingList_clearItems(int argc, VALUE *argv, VALUE self) { FXFoldingList *arg1 = (FXFoldingList *) 0 ;
    FXbool arg2 = (FXbool) 0 ; if ((argc < 0) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFoldingList, 1); if (argc > 0) { arg2 = to_FXbool(argv[0]); } 
    FXFoldingList_clearItems(arg1,arg2); return Qnil; }
static VALUE _wrap_FXFoldingList_getItemWidth(int argc, VALUE *argv, VALUE self) { FXFoldingList *arg1 = (FXFoldingList *) 0 ;
    FXFoldingItem *arg2 = (FXFoldingItem *) 0 ; FXint result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFoldingList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXFoldingItem, 1);
    result = (FXint)((FXFoldingList const *)arg1)->getItemWidth((FXFoldingItem const *)arg2); vresult = INT2NUM(result);
    return vresult; }
static VALUE _wrap_FXFoldingList_getItemHeight(int argc, VALUE *argv, VALUE self) { FXFoldingList *arg1 = (FXFoldingList *) 0 ;
    FXFoldingItem *arg2 = (FXFoldingItem *) 0 ; FXint result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFoldingList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXFoldingItem, 1);
    result = (FXint)((FXFoldingList const *)arg1)->getItemHeight((FXFoldingItem const *)arg2); vresult = INT2NUM(result);
    return vresult; }
static VALUE _wrap_FXFoldingList_getItemAt(int argc, VALUE *argv, VALUE self) { FXFoldingList *arg1 = (FXFoldingList *) 0 ;
    FXint arg2 ; FXint arg3 ; FXFoldingItem *result; VALUE vresult = Qnil; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFoldingList, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    result = (FXFoldingItem *)((FXFoldingList const *)arg1)->getItemAt(arg2,arg3);
    vresult = FXRbGetRubyObj(result, "FXFoldingItem *"); return vresult; }
static VALUE _wrap_FXFoldingList_findItem(int argc, VALUE *argv, VALUE self) { FXFoldingList *arg1 = (FXFoldingList *) 0 ;
    FXString *arg2 = 0 ; FXFoldingItem *arg3 = (FXFoldingItem *) 0 ; FXuint arg4 = (FXuint) SEARCH_FORWARD|SEARCH_WRAP ;
    FXFoldingItem *result; SwigValueWrapper<FXString > p2 ; VALUE vresult = Qnil; if ((argc < 1) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFoldingList, 1); p2 = to_FXString(argv[0]); arg2 = &p2; if (argc > 1) {
        SWIG_ConvertPtr(argv[1], (void **) &arg3, SWIGTYPE_p_FXFoldingItem, 1); }  if (argc > 2) { arg4 = NUM2UINT(argv[2]); } 
    result = (FXFoldingItem *)((FXFoldingList const *)arg1)->findItem((FXString const &)*arg2,arg3,arg4);
    vresult = FXRbGetRubyObj(result, "FXFoldingItem *"); return vresult; }
static VALUE _wrap_FXFoldingList_makeItemVisible(int argc, VALUE *argv, VALUE self) {
    FXFoldingList *arg1 = (FXFoldingList *) 0 ; FXFoldingItem *arg2 = (FXFoldingItem *) 0 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFoldingList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXFoldingItem, 1); (arg1)->makeItemVisible(arg2); return Qnil; }
static VALUE _wrap_FXFoldingList_setItemText(int argc, VALUE *argv, VALUE self) { FXFoldingList *arg1 = (FXFoldingList *) 0 ;
    FXFoldingItem *arg2 = (FXFoldingItem *) 0 ; FXString *arg3 = 0 ; SwigValueWrapper<FXString > p3 ;
    if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFoldingList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXFoldingItem, 1); p3 = to_FXString(argv[1]); arg3 = &p3;
    (arg1)->setItemText(arg2,(FXString const &)*arg3); return Qnil; }
static VALUE _wrap_FXFoldingList_getItemText(int argc, VALUE *argv, VALUE self) { FXFoldingList *arg1 = (FXFoldingList *) 0 ;
    FXFoldingItem *arg2 = (FXFoldingItem *) 0 ; FXString result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFoldingList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXFoldingItem, 1);
    result = ((FXFoldingList const *)arg1)->getItemText((FXFoldingItem const *)arg2); vresult = rb_str_new2((&result)->text());
    return vresult; }
static VALUE _wrap_FXFoldingList_setItemOpenIcon(int argc, VALUE *argv, VALUE self) {
    FXFoldingList *arg1 = (FXFoldingList *) 0 ; FXFoldingItem *arg2 = (FXFoldingItem *) 0 ; FXIcon *arg3 = (FXIcon *) 0 ;
    if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFoldingList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXFoldingItem, 1);
    SWIG_ConvertPtr(argv[1], (void **) &arg3, SWIGTYPE_p_FXIcon, 1); (arg1)->setItemOpenIcon(arg2,arg3); return Qnil; }
static VALUE _wrap_FXFoldingList_getItemOpenIcon(int argc, VALUE *argv, VALUE self) {
    FXFoldingList *arg1 = (FXFoldingList *) 0 ; FXFoldingItem *arg2 = (FXFoldingItem *) 0 ; FXIcon *result;
    VALUE vresult = Qnil; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFoldingList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXFoldingItem, 1);
    result = (FXIcon *)((FXFoldingList const *)arg1)->getItemOpenIcon((FXFoldingItem const *)arg2); {
        swig_type_info *ty = SWIG_TypeDynamicCast(SWIGTYPE_p_FXIcon, (void **) &result); vresult = FXRbGetRubyObj(result, ty); }
     return vresult; }
static VALUE _wrap_FXFoldingList_setItemClosedIcon(int argc, VALUE *argv, VALUE self) {
    FXFoldingList *arg1 = (FXFoldingList *) 0 ; FXFoldingItem *arg2 = (FXFoldingItem *) 0 ; FXIcon *arg3 = (FXIcon *) 0 ;
    if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFoldingList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXFoldingItem, 1);
    SWIG_ConvertPtr(argv[1], (void **) &arg3, SWIGTYPE_p_FXIcon, 1); (arg1)->setItemClosedIcon(arg2,arg3); return Qnil; }
static VALUE _wrap_FXFoldingList_getItemClosedIcon(int argc, VALUE *argv, VALUE self) {
    FXFoldingList *arg1 = (FXFoldingList *) 0 ; FXFoldingItem *arg2 = (FXFoldingItem *) 0 ; FXIcon *result;
    VALUE vresult = Qnil; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFoldingList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXFoldingItem, 1);
    result = (FXIcon *)((FXFoldingList const *)arg1)->getItemClosedIcon((FXFoldingItem const *)arg2); {
        swig_type_info *ty = SWIG_TypeDynamicCast(SWIGTYPE_p_FXIcon, (void **) &result); vresult = FXRbGetRubyObj(result, ty); }
     return vresult; }
static VALUE _wrap_FXFoldingList_setItemData(int argc, VALUE *argv, VALUE self) { FXFoldingList *arg1 = (FXFoldingList *) 0 ;
    FXFoldingItem *arg2 = (FXFoldingItem *) 0 ; VALUE arg3 ; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFoldingList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXFoldingItem, 1); arg3 = argv[1];
    FXFoldingList_setItemData(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXFoldingList_getItemData(int argc, VALUE *argv, VALUE self) { FXFoldingList *arg1 = (FXFoldingList *) 0 ;
    FXFoldingItem *arg2 = (FXFoldingItem *) 0 ; VALUE result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFoldingList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXFoldingItem, 1);
    result = (VALUE)FXFoldingList_getItemData((FXFoldingList const *)arg1,(FXFoldingItem const *)arg2); vresult = result;
    return vresult; }
static VALUE _wrap_FXFoldingList_isItemSelected(int argc, VALUE *argv, VALUE self) { FXFoldingList *arg1 = (FXFoldingList *) 0 ;
    FXFoldingItem *arg2 = (FXFoldingItem *) 0 ; FXbool result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFoldingList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXFoldingItem, 1);
    result = (FXbool)((FXFoldingList const *)arg1)->isItemSelected((FXFoldingItem const *)arg2);
    vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXFoldingList_isItemCurrent(int argc, VALUE *argv, VALUE self) { FXFoldingList *arg1 = (FXFoldingList *) 0 ;
    FXFoldingItem *arg2 = (FXFoldingItem *) 0 ; FXbool result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFoldingList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXFoldingItem, 1);
    result = (FXbool)((FXFoldingList const *)arg1)->isItemCurrent((FXFoldingItem const *)arg2);
    vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXFoldingList_isItemVisible(int argc, VALUE *argv, VALUE self) { FXFoldingList *arg1 = (FXFoldingList *) 0 ;
    FXFoldingItem *arg2 = (FXFoldingItem *) 0 ; FXbool result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFoldingList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXFoldingItem, 1);
    result = (FXbool)((FXFoldingList const *)arg1)->isItemVisible((FXFoldingItem const *)arg2);
    vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXFoldingList_isItemOpened(int argc, VALUE *argv, VALUE self) { FXFoldingList *arg1 = (FXFoldingList *) 0 ;
    FXFoldingItem *arg2 = (FXFoldingItem *) 0 ; FXbool result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFoldingList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXFoldingItem, 1);
    result = (FXbool)((FXFoldingList const *)arg1)->isItemOpened((FXFoldingItem const *)arg2);
    vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXFoldingList_isItemExpanded(int argc, VALUE *argv, VALUE self) { FXFoldingList *arg1 = (FXFoldingList *) 0 ;
    FXFoldingItem *arg2 = (FXFoldingItem *) 0 ; FXbool result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFoldingList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXFoldingItem, 1);
    result = (FXbool)((FXFoldingList const *)arg1)->isItemExpanded((FXFoldingItem const *)arg2);
    vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXFoldingList_isItemLeaf(int argc, VALUE *argv, VALUE self) { FXFoldingList *arg1 = (FXFoldingList *) 0 ;
    FXFoldingItem *arg2 = (FXFoldingItem *) 0 ; FXbool result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFoldingList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXFoldingItem, 1);
    result = (FXbool)((FXFoldingList const *)arg1)->isItemLeaf((FXFoldingItem const *)arg2); vresult = result ? Qtrue : Qfalse;
    return vresult; }
static VALUE _wrap_FXFoldingList_isItemEnabled(int argc, VALUE *argv, VALUE self) { FXFoldingList *arg1 = (FXFoldingList *) 0 ;
    FXFoldingItem *arg2 = (FXFoldingItem *) 0 ; FXbool result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFoldingList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXFoldingItem, 1);
    result = (FXbool)((FXFoldingList const *)arg1)->isItemEnabled((FXFoldingItem const *)arg2);
    vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXFoldingList_hitItem(int argc, VALUE *argv, VALUE self) { FXFoldingList *arg1 = (FXFoldingList *) 0 ;
    FXFoldingItem *arg2 = (FXFoldingItem *) 0 ; FXint arg3 ; FXint arg4 ; FXint result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFoldingList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXFoldingItem, 1); arg3 = NUM2INT(argv[1]); arg4 = NUM2INT(argv[2]);
    result = (FXint)((FXFoldingList const *)arg1)->hitItem((FXFoldingItem const *)arg2,arg3,arg4); vresult = INT2NUM(result);
    return vresult; }
static VALUE _wrap_FXFoldingList_updateItem(int argc, VALUE *argv, VALUE self) { FXFoldingList *arg1 = (FXFoldingList *) 0 ;
    FXFoldingItem *arg2 = (FXFoldingItem *) 0 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFoldingList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXFoldingItem, 1); (arg1)->updateItem(arg2); return Qnil; }
static VALUE _wrap_FXFoldingList_enableItem(int argc, VALUE *argv, VALUE self) { FXFoldingList *arg1 = (FXFoldingList *) 0 ;
    FXFoldingItem *arg2 = (FXFoldingItem *) 0 ; FXbool result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFoldingList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXFoldingItem, 1); result = (FXbool)(arg1)->enableItem(arg2);
    vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXFoldingList_disableItem(int argc, VALUE *argv, VALUE self) { FXFoldingList *arg1 = (FXFoldingList *) 0 ;
    FXFoldingItem *arg2 = (FXFoldingItem *) 0 ; FXbool result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFoldingList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXFoldingItem, 1); result = (FXbool)(arg1)->disableItem(arg2);
    vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXFoldingList_selectItem(int argc, VALUE *argv, VALUE self) { FXFoldingList *arg1 = (FXFoldingList *) 0 ;
    FXFoldingItem *arg2 = (FXFoldingItem *) 0 ; FXbool arg3 = (FXbool) 0 ; FXbool result; VALUE vresult = Qnil;
    if ((argc < 1) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFoldingList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXFoldingItem, 1); if (argc > 1) { arg3 = to_FXbool(argv[1]); } 
    result = (FXbool)(arg1)->selectItem(arg2,arg3); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXFoldingList_deselectItem(int argc, VALUE *argv, VALUE self) { FXFoldingList *arg1 = (FXFoldingList *) 0 ;
    FXFoldingItem *arg2 = (FXFoldingItem *) 0 ; FXbool arg3 = (FXbool) 0 ; FXbool result; VALUE vresult = Qnil;
    if ((argc < 1) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFoldingList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXFoldingItem, 1); if (argc > 1) { arg3 = to_FXbool(argv[1]); } 
    result = (FXbool)(arg1)->deselectItem(arg2,arg3); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXFoldingList_toggleItem(int argc, VALUE *argv, VALUE self) { FXFoldingList *arg1 = (FXFoldingList *) 0 ;
    FXFoldingItem *arg2 = (FXFoldingItem *) 0 ; FXbool arg3 = (FXbool) 0 ; FXbool result; VALUE vresult = Qnil;
    if ((argc < 1) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFoldingList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXFoldingItem, 1); if (argc > 1) { arg3 = to_FXbool(argv[1]); } 
    result = (FXbool)(arg1)->toggleItem(arg2,arg3); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXFoldingList_extendSelection(int argc, VALUE *argv, VALUE self) {
    FXFoldingList *arg1 = (FXFoldingList *) 0 ; FXFoldingItem *arg2 = (FXFoldingItem *) 0 ; FXbool arg3 = (FXbool) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFoldingList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXFoldingItem, 1); if (argc > 1) { arg3 = to_FXbool(argv[1]); } 
    result = (FXbool)(arg1)->extendSelection(arg2,arg3); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXFoldingList_killSelection(int argc, VALUE *argv, VALUE self) { FXFoldingList *arg1 = (FXFoldingList *) 0 ;
    FXbool arg2 = (FXbool) 0 ; FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFoldingList, 1); if (argc > 0) { arg2 = to_FXbool(argv[0]); } 
    result = (FXbool)(arg1)->killSelection(arg2); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXFoldingList_openItem(int argc, VALUE *argv, VALUE self) { FXFoldingList *arg1 = (FXFoldingList *) 0 ;
    FXFoldingItem *arg2 = (FXFoldingItem *) 0 ; FXbool arg3 = (FXbool) 0 ; FXbool result; VALUE vresult = Qnil;
    if ((argc < 1) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFoldingList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXFoldingItem, 1); if (argc > 1) { arg3 = to_FXbool(argv[1]); } 
    result = (FXbool)(arg1)->openItem(arg2,arg3); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXFoldingList_closeItem(int argc, VALUE *argv, VALUE self) { FXFoldingList *arg1 = (FXFoldingList *) 0 ;
    FXFoldingItem *arg2 = (FXFoldingItem *) 0 ; FXbool arg3 = (FXbool) 0 ; FXbool result; VALUE vresult = Qnil;
    if ((argc < 1) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFoldingList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXFoldingItem, 1); if (argc > 1) { arg3 = to_FXbool(argv[1]); } 
    result = (FXbool)(arg1)->closeItem(arg2,arg3); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXFoldingList_collapseTree(int argc, VALUE *argv, VALUE self) { FXFoldingList *arg1 = (FXFoldingList *) 0 ;
    FXFoldingItem *arg2 = (FXFoldingItem *) 0 ; FXbool arg3 = (FXbool) 0 ; FXbool result; VALUE vresult = Qnil;
    if ((argc < 1) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFoldingList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXFoldingItem, 1); if (argc > 1) { arg3 = to_FXbool(argv[1]); } 
    result = (FXbool)(arg1)->collapseTree(arg2,arg3); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXFoldingList_expandTree(int argc, VALUE *argv, VALUE self) { FXFoldingList *arg1 = (FXFoldingList *) 0 ;
    FXFoldingItem *arg2 = (FXFoldingItem *) 0 ; FXbool arg3 = (FXbool) 0 ; FXbool result; VALUE vresult = Qnil;
    if ((argc < 1) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFoldingList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXFoldingItem, 1); if (argc > 1) { arg3 = to_FXbool(argv[1]); } 
    result = (FXbool)(arg1)->expandTree(arg2,arg3); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXFoldingList_setCurrentItem(int argc, VALUE *argv, VALUE self) { FXFoldingList *arg1 = (FXFoldingList *) 0 ;
    FXFoldingItem *arg2 = (FXFoldingItem *) 0 ; FXbool arg3 = (FXbool) 0 ; if ((argc < 1) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFoldingList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXFoldingItem, 1); if (argc > 1) { arg3 = to_FXbool(argv[1]); } 
    (arg1)->setCurrentItem(arg2,arg3); return Qnil; }
static VALUE _wrap_FXFoldingList_getCurrentItem(int argc, VALUE *argv, VALUE self) { FXFoldingList *arg1 = (FXFoldingList *) 0 ;
    FXFoldingItem *result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFoldingList, 1);
    result = (FXFoldingItem *)((FXFoldingList const *)arg1)->getCurrentItem();
    vresult = FXRbGetRubyObj(result, "FXFoldingItem *"); return vresult; }
static VALUE _wrap_FXFoldingList_setAnchorItem(int argc, VALUE *argv, VALUE self) { FXFoldingList *arg1 = (FXFoldingList *) 0 ;
    FXFoldingItem *arg2 = (FXFoldingItem *) 0 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFoldingList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXFoldingItem, 1); (arg1)->setAnchorItem(arg2); return Qnil; }
static VALUE _wrap_FXFoldingList_getAnchorItem(int argc, VALUE *argv, VALUE self) { FXFoldingList *arg1 = (FXFoldingList *) 0 ;
    FXFoldingItem *result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFoldingList, 1);
    result = (FXFoldingItem *)((FXFoldingList const *)arg1)->getAnchorItem();
    vresult = FXRbGetRubyObj(result, "FXFoldingItem *"); return vresult; }
static VALUE _wrap_FXFoldingList_getCursorItem(int argc, VALUE *argv, VALUE self) { FXFoldingList *arg1 = (FXFoldingList *) 0 ;
    FXFoldingItem *result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFoldingList, 1);
    result = (FXFoldingItem *)((FXFoldingList const *)arg1)->getCursorItem();
    vresult = FXRbGetRubyObj(result, "FXFoldingItem *"); return vresult; }
static VALUE _wrap_FXFoldingList_sortItems(int argc, VALUE *argv, VALUE self) { FXFoldingList *arg1 = (FXFoldingList *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFoldingList, 1); (arg1)->sortItems(); return Qnil; }
static VALUE _wrap_FXFoldingList_sortRootItems(int argc, VALUE *argv, VALUE self) { FXFoldingList *arg1 = (FXFoldingList *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFoldingList, 1); (arg1)->sortRootItems(); return Qnil; }
static VALUE _wrap_FXFoldingList_sortChildItems(int argc, VALUE *argv, VALUE self) { FXFoldingList *arg1 = (FXFoldingList *) 0 ;
    FXFoldingItem *arg2 = (FXFoldingItem *) 0 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFoldingList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXFoldingItem, 1); (arg1)->sortChildItems(arg2); return Qnil; }
static VALUE _wrap_FXFoldingList_getSortFunc(int argc, VALUE *argv, VALUE self) { FXFoldingList *arg1 = (FXFoldingList *) 0 ;
    FXFoldingListSortFunc result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFoldingList, 1); result = ((FXFoldingList const *)arg1)->getSortFunc();
    { FXFoldingListSortFunc * resultptr; resultptr = new FXFoldingListSortFunc((FXFoldingListSortFunc &)result);
        vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_FXFoldingListSortFunc, 1); }  return vresult; }
static VALUE _wrap_FXFoldingList_setSortFunc(int argc, VALUE *argv, VALUE self) { FXFoldingList *arg1 = (FXFoldingList *) 0 ;
    FXFoldingListSortFunc arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFoldingList, 1); { FXFoldingListSortFunc * ptr;
        SWIG_ConvertPtr(argv[0], (void **) &ptr, SWIGTYPE_p_FXFoldingListSortFunc, 1); if (ptr) arg2 = *ptr; } 
    (arg1)->setSortFunc(arg2); return Qnil; }
static VALUE _wrap_FXFoldingList_setFont(int argc, VALUE *argv, VALUE self) { FXFoldingList *arg1 = (FXFoldingList *) 0 ;
    FXFont *arg2 = (FXFont *) 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFoldingList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXFont, 1); (arg1)->setFont(arg2); return Qnil; }
static VALUE _wrap_FXFoldingList_getFont(int argc, VALUE *argv, VALUE self) { FXFoldingList *arg1 = (FXFoldingList *) 0 ;
    FXFont *result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFoldingList, 1);
    result = (FXFont *)((FXFoldingList const *)arg1)->getFont(); {
        swig_type_info *ty = SWIG_TypeDynamicCast(SWIGTYPE_p_FXFont, (void **) &result); vresult = FXRbGetRubyObj(result, ty); }
     return vresult; }
static VALUE _wrap_FXFoldingList_setIndent(int argc, VALUE *argv, VALUE self) { FXFoldingList *arg1 = (FXFoldingList *) 0 ;
    FXint arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFoldingList, 1); arg2 = NUM2INT(argv[0]); (arg1)->setIndent(arg2);
    return Qnil; }
static VALUE _wrap_FXFoldingList_getIndent(int argc, VALUE *argv, VALUE self) { FXFoldingList *arg1 = (FXFoldingList *) 0 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFoldingList, 1);
    result = (FXint)((FXFoldingList const *)arg1)->getIndent(); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXFoldingList_getTextColor(int argc, VALUE *argv, VALUE self) { FXFoldingList *arg1 = (FXFoldingList *) 0 ;
    FXColor result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFoldingList, 1);
    result = (FXColor)((FXFoldingList const *)arg1)->getTextColor(); vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXFoldingList_setTextColor(int argc, VALUE *argv, VALUE self) { FXFoldingList *arg1 = (FXFoldingList *) 0 ;
    FXColor arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFoldingList, 1); arg2 = to_FXColor(argv[0]); (arg1)->setTextColor(arg2);
    return Qnil; }
static VALUE _wrap_FXFoldingList_getSelBackColor(int argc, VALUE *argv, VALUE self) {
    FXFoldingList *arg1 = (FXFoldingList *) 0 ; FXColor result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFoldingList, 1);
    result = (FXColor)((FXFoldingList const *)arg1)->getSelBackColor(); vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXFoldingList_setSelBackColor(int argc, VALUE *argv, VALUE self) {
    FXFoldingList *arg1 = (FXFoldingList *) 0 ; FXColor arg2 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFoldingList, 1); arg2 = to_FXColor(argv[0]);
    (arg1)->setSelBackColor(arg2); return Qnil; }
static VALUE _wrap_FXFoldingList_getSelTextColor(int argc, VALUE *argv, VALUE self) {
    FXFoldingList *arg1 = (FXFoldingList *) 0 ; FXColor result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFoldingList, 1);
    result = (FXColor)((FXFoldingList const *)arg1)->getSelTextColor(); vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXFoldingList_setSelTextColor(int argc, VALUE *argv, VALUE self) {
    FXFoldingList *arg1 = (FXFoldingList *) 0 ; FXColor arg2 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFoldingList, 1); arg2 = to_FXColor(argv[0]);
    (arg1)->setSelTextColor(arg2); return Qnil; }
static VALUE _wrap_FXFoldingList_getLineColor(int argc, VALUE *argv, VALUE self) { FXFoldingList *arg1 = (FXFoldingList *) 0 ;
    FXColor result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFoldingList, 1);
    result = (FXColor)((FXFoldingList const *)arg1)->getLineColor(); vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXFoldingList_setLineColor(int argc, VALUE *argv, VALUE self) { FXFoldingList *arg1 = (FXFoldingList *) 0 ;
    FXColor arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFoldingList, 1); arg2 = to_FXColor(argv[0]); (arg1)->setLineColor(arg2);
    return Qnil; }
static VALUE _wrap_FXFoldingList_getListStyle(int argc, VALUE *argv, VALUE self) { FXFoldingList *arg1 = (FXFoldingList *) 0 ;
    FXuint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFoldingList, 1);
    result = (FXuint)((FXFoldingList const *)arg1)->getListStyle(); vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXFoldingList_setListStyle(int argc, VALUE *argv, VALUE self) { FXFoldingList *arg1 = (FXFoldingList *) 0 ;
    FXuint arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFoldingList, 1); arg2 = NUM2UINT(argv[0]); (arg1)->setListStyle(arg2);
    return Qnil; }
static VALUE _wrap_FXFoldingList_setHelpText(int argc, VALUE *argv, VALUE self) { FXFoldingList *arg1 = (FXFoldingList *) 0 ;
    FXString *arg2 = 0 ; SwigValueWrapper<FXString > p2 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFoldingList, 1); p2 = to_FXString(argv[0]); arg2 = &p2;
    (arg1)->setHelpText((FXString const &)*arg2); return Qnil; }
static VALUE _wrap_FXFoldingList_getHelpText(int argc, VALUE *argv, VALUE self) { FXFoldingList *arg1 = (FXFoldingList *) 0 ;
    FXString result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFoldingList, 1); result = ((FXFoldingList const *)arg1)->getHelpText();
    vresult = rb_str_new2((&result)->text()); return vresult; }
static void
free_FXFoldingList(FXFoldingList *arg1) {
    delete arg1;
}
static VALUE _wrap_FXFoldingList_save(int argc, VALUE *argv, VALUE self) { FXFoldingList *arg1 = (FXFoldingList *) 0 ;
    FXStream *arg2 = 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFoldingList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXFoldingList_save((FXFoldingList const *)arg1,*arg2); return Qnil; }
static VALUE _wrap_FXFoldingList_load(int argc, VALUE *argv, VALUE self) { FXFoldingList *arg1 = (FXFoldingList *) 0 ;
    FXStream *arg2 = 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFoldingList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXFoldingList_load(arg1,*arg2); return Qnil; }
static VALUE _wrap_FXFoldingList_create(int argc, VALUE *argv, VALUE self) { FXFoldingList *arg1 = (FXFoldingList *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFoldingList, 1); FXFoldingList_create(arg1); return Qnil; }
static VALUE _wrap_FXFoldingList_detach(int argc, VALUE *argv, VALUE self) { FXFoldingList *arg1 = (FXFoldingList *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFoldingList, 1); FXFoldingList_detach(arg1); return Qnil; }
static VALUE _wrap_FXFoldingList_destroy(int argc, VALUE *argv, VALUE self) { FXFoldingList *arg1 = (FXFoldingList *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFoldingList, 1); FXFoldingList_destroy(arg1); return Qnil; }
static VALUE _wrap_FXFoldingList_resize(int argc, VALUE *argv, VALUE self) { FXFoldingList *arg1 = (FXFoldingList *) 0 ;
    FXint arg2 ; FXint arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFoldingList, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    FXFoldingList_resize(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXFoldingList_getDefaultWidth(int argc, VALUE *argv, VALUE self) {
    FXFoldingList *arg1 = (FXFoldingList *) 0 ; FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFoldingList, 1); result = (FXint)FXFoldingList_getDefaultWidth(arg1);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXFoldingList_getDefaultHeight(int argc, VALUE *argv, VALUE self) {
    FXFoldingList *arg1 = (FXFoldingList *) 0 ; FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFoldingList, 1); result = (FXint)FXFoldingList_getDefaultHeight(arg1);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXFoldingList_getWidthForHeight(int argc, VALUE *argv, VALUE self) {
    FXFoldingList *arg1 = (FXFoldingList *) 0 ; FXint arg2 ; FXint result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFoldingList, 1); arg2 = NUM2INT(argv[0]);
    result = (FXint)FXFoldingList_getWidthForHeight(arg1,arg2); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXFoldingList_getHeightForWidth(int argc, VALUE *argv, VALUE self) {
    FXFoldingList *arg1 = (FXFoldingList *) 0 ; FXint arg2 ; FXint result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFoldingList, 1); arg2 = NUM2INT(argv[0]);
    result = (FXint)FXFoldingList_getHeightForWidth(arg1,arg2); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXFoldingList_canFocus(int argc, VALUE *argv, VALUE self) { FXFoldingList *arg1 = (FXFoldingList *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFoldingList, 1);
    result = (FXbool)FXFoldingList_canFocus((FXFoldingList const *)arg1); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXFoldingList_setFocus(int argc, VALUE *argv, VALUE self) { FXFoldingList *arg1 = (FXFoldingList *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFoldingList, 1); FXFoldingList_setFocus(arg1); return Qnil; }
static VALUE _wrap_FXFoldingList_killFocus(int argc, VALUE *argv, VALUE self) { FXFoldingList *arg1 = (FXFoldingList *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFoldingList, 1); FXFoldingList_killFocus(arg1); return Qnil; }
static VALUE _wrap_FXFoldingList_setDefault(int argc, VALUE *argv, VALUE self) { FXFoldingList *arg1 = (FXFoldingList *) 0 ;
    FXbool arg2 = (FXbool) 1 ; if ((argc < 0) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFoldingList, 1); if (argc > 0) { arg2 = to_FXbool(argv[0]); } 
    FXFoldingList_setDefault(arg1,arg2); return Qnil; }
static VALUE _wrap_FXFoldingList_enable(int argc, VALUE *argv, VALUE self) { FXFoldingList *arg1 = (FXFoldingList *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFoldingList, 1); FXFoldingList_enable(arg1); return Qnil; }
static VALUE _wrap_FXFoldingList_disable(int argc, VALUE *argv, VALUE self) { FXFoldingList *arg1 = (FXFoldingList *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFoldingList, 1); FXFoldingList_disable(arg1); return Qnil; }
static VALUE _wrap_FXFoldingList_raiseWindow(int argc, VALUE *argv, VALUE self) { FXFoldingList *arg1 = (FXFoldingList *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFoldingList, 1); FXFoldingList_raise(arg1); return Qnil; }
static VALUE _wrap_FXFoldingList_lower(int argc, VALUE *argv, VALUE self) { FXFoldingList *arg1 = (FXFoldingList *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFoldingList, 1); FXFoldingList_lower(arg1); return Qnil; }
static VALUE _wrap_FXFoldingList_move(int argc, VALUE *argv, VALUE self) { FXFoldingList *arg1 = (FXFoldingList *) 0 ;
    FXint arg2 ; FXint arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFoldingList, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    FXFoldingList_move(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXFoldingList_position__SWIG_0(int argc, VALUE *argv, VALUE self) {
    FXFoldingList *arg1 = (FXFoldingList *) 0 ; FXint arg2 ; FXint arg3 ; FXint arg4 ; FXint arg5 ;
    if ((argc < 4) || (argc > 4)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFoldingList, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    arg4 = NUM2INT(argv[2]); arg5 = NUM2INT(argv[3]); FXFoldingList_position(arg1,arg2,arg3,arg4,arg5); return Qnil; }
static VALUE _wrap_FXFoldingList_layout(int argc, VALUE *argv, VALUE self) { FXFoldingList *arg1 = (FXFoldingList *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFoldingList, 1); FXFoldingList_layout(arg1); return Qnil; }
static VALUE _wrap_FXFoldingList_recalc(int argc, VALUE *argv, VALUE self) { FXFoldingList *arg1 = (FXFoldingList *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFoldingList, 1); FXFoldingList_recalc(arg1); return Qnil; }
static VALUE _wrap_FXFoldingList_reparent(int argc, VALUE *argv, VALUE self) { FXFoldingList *arg1 = (FXFoldingList *) 0 ;
    FXComposite *arg2 = (FXComposite *) 0 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFoldingList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXComposite, 1); FXFoldingList_reparent(arg1,arg2); return Qnil; }
static VALUE _wrap_FXFoldingList_show(int argc, VALUE *argv, VALUE self) { FXFoldingList *arg1 = (FXFoldingList *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFoldingList, 1); FXFoldingList_show(arg1); return Qnil; }
static VALUE _wrap_FXFoldingList_hide(int argc, VALUE *argv, VALUE self) { FXFoldingList *arg1 = (FXFoldingList *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFoldingList, 1); FXFoldingList_hide(arg1); return Qnil; }
static VALUE _wrap_FXFoldingList_isComposite(int argc, VALUE *argv, VALUE self) { FXFoldingList *arg1 = (FXFoldingList *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFoldingList, 1);
    result = (FXbool)FXFoldingList_isComposite((FXFoldingList const *)arg1); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXFoldingList_contains(int argc, VALUE *argv, VALUE self) { FXFoldingList *arg1 = (FXFoldingList *) 0 ;
    FXint arg2 ; FXint arg3 ; FXbool result; VALUE vresult = Qnil; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFoldingList, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    result = (FXbool)FXFoldingList_contains((FXFoldingList const *)arg1,arg2,arg3); vresult = result ? Qtrue : Qfalse;
    return vresult; }
static VALUE _wrap_FXFoldingList_doesSaveUnder(int argc, VALUE *argv, VALUE self) { FXFoldingList *arg1 = (FXFoldingList *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFoldingList, 1);
    result = (FXbool)FXFoldingList_doesSaveUnder((FXFoldingList const *)arg1); vresult = result ? Qtrue : Qfalse;
    return vresult; }
static VALUE _wrap_FXFoldingList_setBackColor(int argc, VALUE *argv, VALUE self) { FXFoldingList *arg1 = (FXFoldingList *) 0 ;
    FXColor arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFoldingList, 1); arg2 = to_FXColor(argv[0]);
    FXFoldingList_setBackColor(arg1,arg2); return Qnil; }
static VALUE _wrap_FXFoldingList_getViewportHeight(int argc, VALUE *argv, VALUE self) {
    FXFoldingList *arg1 = (FXFoldingList *) 0 ; FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFoldingList, 1); result = (FXint)FXFoldingList_getViewportHeight(arg1);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXFoldingList_getViewportWidth(int argc, VALUE *argv, VALUE self) {
    FXFoldingList *arg1 = (FXFoldingList *) 0 ; FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFoldingList, 1); result = (FXint)FXFoldingList_getViewportWidth(arg1);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXFoldingList_getContentHeight(int argc, VALUE *argv, VALUE self) {
    FXFoldingList *arg1 = (FXFoldingList *) 0 ; FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFoldingList, 1); result = (FXint)FXFoldingList_getContentHeight(arg1);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXFoldingList_getContentWidth(int argc, VALUE *argv, VALUE self) {
    FXFoldingList *arg1 = (FXFoldingList *) 0 ; FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFoldingList, 1); result = (FXint)FXFoldingList_getContentWidth(arg1);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXFoldingList_position__SWIG_1(int argc, VALUE *argv, VALUE self) {
    FXFoldingList *arg1 = (FXFoldingList *) 0 ; VALUE result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFoldingList, 1);
    result = (VALUE)FXFoldingList_position__SWIG_1((FXFoldingList const *)arg1); vresult = result; return vresult; }
static VALUE _wrap_FXFoldingList_position(int nargs, VALUE *args, VALUE self) { int argc; VALUE argv[6]; int ii;
    argc = nargs + 1; argv[0] = self; for (ii = 1; (ii < argc) && (ii < 5); ii++) { argv[ii] = args[ii-1]; }  if (argc == 1) {
        int _v; { void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXFoldingList, 0) != -1)) ? 1 : 0; }
         if (_v) { return _wrap_FXFoldingList_position__SWIG_1(nargs, args, self);}  }  if (argc == 5) { int _v; { void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXFoldingList, 0) != -1)) ? 1 : 0; }
         if (_v) { { _v = ((TYPE(argv[1]) == T_FIXNUM) || (TYPE(argv[1]) == T_BIGNUM)) ? 1 : 0; }  if (_v) { {
                    _v = ((TYPE(argv[2]) == T_FIXNUM) || (TYPE(argv[2]) == T_BIGNUM)) ? 1 : 0; }  if (_v) { {
                        _v = ((TYPE(argv[3]) == T_FIXNUM) || (TYPE(argv[3]) == T_BIGNUM)) ? 1 : 0; }  if (_v) { {
                            _v = ((TYPE(argv[4]) == T_FIXNUM) || (TYPE(argv[4]) == T_BIGNUM)) ? 1 : 0; }  if (_v) {
                            return _wrap_FXFoldingList_position__SWIG_0(nargs, args, self);}  }  }  }  }  } 
    rb_raise(rb_eArgError, "No matching function for overloaded 'FXFoldingList_position'"); return Qnil; }
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE _wrap_FXTreeItem_allocate(VALUE self) {
#else
     static VALUE _wrap_FXTreeItem_allocate(int argc, VALUE *argv, VALUE self) {
#endif
         VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_FXTreeItem);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
         return vresult; }
static VALUE _wrap_new_FXTreeItem(int argc, VALUE *argv, VALUE self) { FXString *arg1 = 0 ; FXIcon *arg2 = (FXIcon *) 0 ;
    FXIcon *arg3 = (FXIcon *) 0 ; void *arg4 = (void *) 0 ; FXTreeItem *result; SwigValueWrapper<FXString > p1 ;
    if ((argc < 1) || (argc > 4)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    p1 = to_FXString(argv[0]); arg1 = &p1; if (argc > 1) { SWIG_ConvertPtr(argv[1], (void **) &arg2, SWIGTYPE_p_FXIcon, 1); } 
    if (argc > 2) { SWIG_ConvertPtr(argv[2], (void **) &arg3, SWIGTYPE_p_FXIcon, 1); }  if (argc > 3) {
        SWIG_ConvertPtr(argv[3], (void **) &arg4, 0, 1); }  {
        result = (FXTreeItem *)new_FXTreeItem((FXString const &)*arg1,arg2,arg3,arg4);
        DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result); if(rb_block_given_p()){ rb_yield(self); }  }  return self; }
static VALUE _wrap_FXTreeItem_getText(int argc, VALUE *argv, VALUE self) { FXTreeItem *arg1 = (FXTreeItem *) 0 ;
    FXString *result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTreeItem, 1); {
        FXString const &_result_ref = ((FXTreeItem const *)arg1)->getText(); result = (FXString *) &_result_ref; } 
    vresult = rb_str_new2(result->text()); return vresult; }
static VALUE _wrap_FXTreeItem_getOpenIcon(int argc, VALUE *argv, VALUE self) { FXTreeItem *arg1 = (FXTreeItem *) 0 ;
    FXIcon *result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTreeItem, 1);
    result = (FXIcon *)((FXTreeItem const *)arg1)->getOpenIcon(); {
        swig_type_info *ty = SWIG_TypeDynamicCast(SWIGTYPE_p_FXIcon, (void **) &result); vresult = FXRbGetRubyObj(result, ty); }
     return vresult; }
static VALUE _wrap_FXTreeItem_getClosedIcon(int argc, VALUE *argv, VALUE self) { FXTreeItem *arg1 = (FXTreeItem *) 0 ;
    FXIcon *result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTreeItem, 1);
    result = (FXIcon *)((FXTreeItem const *)arg1)->getClosedIcon(); {
        swig_type_info *ty = SWIG_TypeDynamicCast(SWIGTYPE_p_FXIcon, (void **) &result); vresult = FXRbGetRubyObj(result, ty); }
     return vresult; }
static VALUE _wrap_FXTreeItem_getParent(int argc, VALUE *argv, VALUE self) { FXTreeItem *arg1 = (FXTreeItem *) 0 ;
    FXTreeItem *result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTreeItem, 1);
    result = (FXTreeItem *)((FXTreeItem const *)arg1)->getParent(); {
        swig_type_info *ty = SWIG_TypeDynamicCast(SWIGTYPE_p_FXTreeItem, (void **) &result);
        vresult = FXRbGetRubyObj(result, ty); }  return vresult; }
static VALUE _wrap_FXTreeItem_getNext(int argc, VALUE *argv, VALUE self) { FXTreeItem *arg1 = (FXTreeItem *) 0 ;
    FXTreeItem *result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTreeItem, 1);
    result = (FXTreeItem *)((FXTreeItem const *)arg1)->getNext(); {
        swig_type_info *ty = SWIG_TypeDynamicCast(SWIGTYPE_p_FXTreeItem, (void **) &result);
        vresult = FXRbGetRubyObj(result, ty); }  return vresult; }
static VALUE _wrap_FXTreeItem_getPrev(int argc, VALUE *argv, VALUE self) { FXTreeItem *arg1 = (FXTreeItem *) 0 ;
    FXTreeItem *result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTreeItem, 1);
    result = (FXTreeItem *)((FXTreeItem const *)arg1)->getPrev(); {
        swig_type_info *ty = SWIG_TypeDynamicCast(SWIGTYPE_p_FXTreeItem, (void **) &result);
        vresult = FXRbGetRubyObj(result, ty); }  return vresult; }
static VALUE _wrap_FXTreeItem_getFirst(int argc, VALUE *argv, VALUE self) { FXTreeItem *arg1 = (FXTreeItem *) 0 ;
    FXTreeItem *result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTreeItem, 1);
    result = (FXTreeItem *)((FXTreeItem const *)arg1)->getFirst(); {
        swig_type_info *ty = SWIG_TypeDynamicCast(SWIGTYPE_p_FXTreeItem, (void **) &result);
        vresult = FXRbGetRubyObj(result, ty); }  return vresult; }
static VALUE _wrap_FXTreeItem_getLast(int argc, VALUE *argv, VALUE self) { FXTreeItem *arg1 = (FXTreeItem *) 0 ;
    FXTreeItem *result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTreeItem, 1);
    result = (FXTreeItem *)((FXTreeItem const *)arg1)->getLast(); {
        swig_type_info *ty = SWIG_TypeDynamicCast(SWIGTYPE_p_FXTreeItem, (void **) &result);
        vresult = FXRbGetRubyObj(result, ty); }  return vresult; }
static VALUE _wrap_FXTreeItem_getBelow(int argc, VALUE *argv, VALUE self) { FXTreeItem *arg1 = (FXTreeItem *) 0 ;
    FXTreeItem *result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTreeItem, 1);
    result = (FXTreeItem *)((FXTreeItem const *)arg1)->getBelow(); {
        swig_type_info *ty = SWIG_TypeDynamicCast(SWIGTYPE_p_FXTreeItem, (void **) &result);
        vresult = FXRbGetRubyObj(result, ty); }  return vresult; }
static VALUE _wrap_FXTreeItem_getAbove(int argc, VALUE *argv, VALUE self) { FXTreeItem *arg1 = (FXTreeItem *) 0 ;
    FXTreeItem *result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTreeItem, 1);
    result = (FXTreeItem *)((FXTreeItem const *)arg1)->getAbove(); {
        swig_type_info *ty = SWIG_TypeDynamicCast(SWIGTYPE_p_FXTreeItem, (void **) &result);
        vresult = FXRbGetRubyObj(result, ty); }  return vresult; }
static VALUE _wrap_FXTreeItem_getNumChildren(int argc, VALUE *argv, VALUE self) { FXTreeItem *arg1 = (FXTreeItem *) 0 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTreeItem, 1);
    result = (FXint)((FXTreeItem const *)arg1)->getNumChildren(); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTreeItem_setData(int argc, VALUE *argv, VALUE self) { FXTreeItem *arg1 = (FXTreeItem *) 0 ; VALUE arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTreeItem, 1); arg2 = argv[0]; FXTreeItem_setData(arg1,arg2);
    return Qnil; }
static VALUE _wrap_FXTreeItem_getData(int argc, VALUE *argv, VALUE self) { FXTreeItem *arg1 = (FXTreeItem *) 0 ; VALUE result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTreeItem, 1);
    result = (VALUE)FXTreeItem_getData((FXTreeItem const *)arg1); vresult = result; return vresult; }
static VALUE _wrap_FXTreeItem_hasFocus(int argc, VALUE *argv, VALUE self) { FXTreeItem *arg1 = (FXTreeItem *) 0 ; FXbool result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTreeItem, 1); result = (FXbool)((FXTreeItem const *)arg1)->hasFocus();
    vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXTreeItem_isSelected(int argc, VALUE *argv, VALUE self) { FXTreeItem *arg1 = (FXTreeItem *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTreeItem, 1); result = (FXbool)((FXTreeItem const *)arg1)->isSelected();
    vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXTreeItem_isOpened(int argc, VALUE *argv, VALUE self) { FXTreeItem *arg1 = (FXTreeItem *) 0 ; FXbool result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTreeItem, 1); result = (FXbool)((FXTreeItem const *)arg1)->isOpened();
    vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXTreeItem_isExpanded(int argc, VALUE *argv, VALUE self) { FXTreeItem *arg1 = (FXTreeItem *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTreeItem, 1); result = (FXbool)((FXTreeItem const *)arg1)->isExpanded();
    vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXTreeItem_isEnabled(int argc, VALUE *argv, VALUE self) { FXTreeItem *arg1 = (FXTreeItem *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTreeItem, 1); result = (FXbool)((FXTreeItem const *)arg1)->isEnabled();
    vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXTreeItem_isDraggable(int argc, VALUE *argv, VALUE self) { FXTreeItem *arg1 = (FXTreeItem *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTreeItem, 1);
    result = (FXbool)((FXTreeItem const *)arg1)->isDraggable(); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXTreeItem_setIconOwned(int argc, VALUE *argv, VALUE self) { FXTreeItem *arg1 = (FXTreeItem *) 0 ;
    FXuint arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTreeItem, 1); arg2 = NUM2UINT(argv[0]); (arg1)->setIconOwned(arg2);
    return Qnil; }
static VALUE _wrap_FXTreeItem_isIconOwned(int argc, VALUE *argv, VALUE self) { FXTreeItem *arg1 = (FXTreeItem *) 0 ;
    FXuint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTreeItem, 1);
    result = (FXuint)((FXTreeItem const *)arg1)->isIconOwned(); vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXTreeItem_hasItemsq___(int argc, VALUE *argv, VALUE self) { FXTreeItem *arg1 = (FXTreeItem *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTreeItem, 1); result = (FXbool)((FXTreeItem const *)arg1)->hasItems();
    vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXTreeItem_hasItemse___(int argc, VALUE *argv, VALUE self) { FXTreeItem *arg1 = (FXTreeItem *) 0 ;
    FXbool arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTreeItem, 1); arg2 = to_FXbool(argv[0]); (arg1)->setHasItems(arg2);
    return Qnil; }
static VALUE _wrap_FXTreeItem_isChildOf(int argc, VALUE *argv, VALUE self) { FXTreeItem *arg1 = (FXTreeItem *) 0 ;
    FXTreeItem *arg2 = (FXTreeItem *) 0 ; FXbool result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTreeItem, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXTreeItem, 1);
    result = (FXbool)((FXTreeItem const *)arg1)->isChildOf((FXTreeItem const *)arg2); vresult = result ? Qtrue : Qfalse;
    return vresult; }
static VALUE _wrap_FXTreeItem_isParentOf(int argc, VALUE *argv, VALUE self) { FXTreeItem *arg1 = (FXTreeItem *) 0 ;
    FXTreeItem *arg2 = (FXTreeItem *) 0 ; FXbool result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTreeItem, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXTreeItem, 1);
    result = (FXbool)((FXTreeItem const *)arg1)->isParentOf((FXTreeItem const *)arg2); vresult = result ? Qtrue : Qfalse;
    return vresult; }
static void
free_FXTreeItem(FXTreeItem *arg1) {
    delete arg1;
}
static VALUE _wrap_FXTreeItem_save(int argc, VALUE *argv, VALUE self) { FXTreeItem *arg1 = (FXTreeItem *) 0 ;
    FXStream *arg2 = 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTreeItem, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXTreeItem_save((FXTreeItem const *)arg1,*arg2); return Qnil; }
static VALUE _wrap_FXTreeItem_load(int argc, VALUE *argv, VALUE self) { FXTreeItem *arg1 = (FXTreeItem *) 0 ;
    FXStream *arg2 = 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTreeItem, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXTreeItem_load(arg1,*arg2); return Qnil; }
static VALUE _wrap_FXTreeItem_setText(int argc, VALUE *argv, VALUE self) { FXTreeItem *arg1 = (FXTreeItem *) 0 ;
    FXString *arg2 = 0 ; SwigValueWrapper<FXString > p2 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTreeItem, 1); p2 = to_FXString(argv[0]); arg2 = &p2;
    FXTreeItem_setText(arg1,(FXString const &)*arg2); return Qnil; }
static VALUE _wrap_FXTreeItem_setOpenIcon(int argc, VALUE *argv, VALUE self) { FXTreeItem *arg1 = (FXTreeItem *) 0 ;
    FXIcon *arg2 = (FXIcon *) 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTreeItem, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXIcon, 1); FXTreeItem_setOpenIcon(arg1,arg2); return Qnil; }
static VALUE _wrap_FXTreeItem_setClosedIcon(int argc, VALUE *argv, VALUE self) { FXTreeItem *arg1 = (FXTreeItem *) 0 ;
    FXIcon *arg2 = (FXIcon *) 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTreeItem, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXIcon, 1); FXTreeItem_setClosedIcon(arg1,arg2); return Qnil; }
static VALUE _wrap_FXTreeItem_setFocus(int argc, VALUE *argv, VALUE self) { FXTreeItem *arg1 = (FXTreeItem *) 0 ; FXbool arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTreeItem, 1); arg2 = to_FXbool(argv[0]); FXTreeItem_setFocus(arg1,arg2);
    return Qnil; }
static VALUE _wrap_FXTreeItem_setSelected(int argc, VALUE *argv, VALUE self) { FXTreeItem *arg1 = (FXTreeItem *) 0 ;
    FXbool arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTreeItem, 1); arg2 = to_FXbool(argv[0]);
    FXTreeItem_setSelected(arg1,arg2); return Qnil; }
static VALUE _wrap_FXTreeItem_setOpened(int argc, VALUE *argv, VALUE self) { FXTreeItem *arg1 = (FXTreeItem *) 0 ; FXbool arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTreeItem, 1); arg2 = to_FXbool(argv[0]);
    FXTreeItem_setOpened(arg1,arg2); return Qnil; }
static VALUE _wrap_FXTreeItem_setExpanded(int argc, VALUE *argv, VALUE self) { FXTreeItem *arg1 = (FXTreeItem *) 0 ;
    FXbool arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTreeItem, 1); arg2 = to_FXbool(argv[0]);
    FXTreeItem_setExpanded(arg1,arg2); return Qnil; }
static VALUE _wrap_FXTreeItem_setEnabled(int argc, VALUE *argv, VALUE self) { FXTreeItem *arg1 = (FXTreeItem *) 0 ;
    FXbool arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTreeItem, 1); arg2 = to_FXbool(argv[0]);
    FXTreeItem_setEnabled(arg1,arg2); return Qnil; }
static VALUE _wrap_FXTreeItem_setDraggable(int argc, VALUE *argv, VALUE self) { FXTreeItem *arg1 = (FXTreeItem *) 0 ;
    FXbool arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTreeItem, 1); arg2 = to_FXbool(argv[0]);
    FXTreeItem_setDraggable(arg1,arg2); return Qnil; }
static VALUE _wrap_FXTreeItem_getWidth(int argc, VALUE *argv, VALUE self) { FXTreeItem *arg1 = (FXTreeItem *) 0 ;
    FXTreeList *arg2 = (FXTreeList *) 0 ; FXint result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTreeItem, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXTreeList, 1);
    result = (FXint)FXTreeItem_getWidth((FXTreeItem const *)arg1,(FXTreeList const *)arg2); vresult = INT2NUM(result);
    return vresult; }
static VALUE _wrap_FXTreeItem_getHeight(int argc, VALUE *argv, VALUE self) { FXTreeItem *arg1 = (FXTreeItem *) 0 ;
    FXTreeList *arg2 = (FXTreeList *) 0 ; FXint result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTreeItem, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXTreeList, 1);
    result = (FXint)FXTreeItem_getHeight((FXTreeItem const *)arg1,(FXTreeList const *)arg2); vresult = INT2NUM(result);
    return vresult; }
static VALUE _wrap_FXTreeItem_create(int argc, VALUE *argv, VALUE self) { FXTreeItem *arg1 = (FXTreeItem *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTreeItem, 1); FXTreeItem_create(arg1); return Qnil; }
static VALUE _wrap_FXTreeItem_detach(int argc, VALUE *argv, VALUE self) { FXTreeItem *arg1 = (FXTreeItem *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTreeItem, 1); FXTreeItem_detach(arg1); return Qnil; }
static VALUE _wrap_FXTreeItem_destroy(int argc, VALUE *argv, VALUE self) { FXTreeItem *arg1 = (FXTreeItem *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTreeItem, 1); FXTreeItem_destroy(arg1); return Qnil; }
static VALUE _wrap_FXTreeList_onPaint(int argc, VALUE *argv, VALUE self) { FXTreeList *arg1 = (FXTreeList *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTreeList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onPaint(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTreeList_onEnter(int argc, VALUE *argv, VALUE self) { FXTreeList *arg1 = (FXTreeList *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTreeList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onEnter(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTreeList_onLeave(int argc, VALUE *argv, VALUE self) { FXTreeList *arg1 = (FXTreeList *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTreeList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onLeave(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTreeList_onUngrabbed(int argc, VALUE *argv, VALUE self) { FXTreeList *arg1 = (FXTreeList *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTreeList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onUngrabbed(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTreeList_onMotion(int argc, VALUE *argv, VALUE self) { FXTreeList *arg1 = (FXTreeList *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTreeList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onMotion(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTreeList_onKeyPress(int argc, VALUE *argv, VALUE self) { FXTreeList *arg1 = (FXTreeList *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTreeList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onKeyPress(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTreeList_onKeyRelease(int argc, VALUE *argv, VALUE self) { FXTreeList *arg1 = (FXTreeList *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTreeList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onKeyRelease(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTreeList_onLeftBtnPress(int argc, VALUE *argv, VALUE self) { FXTreeList *arg1 = (FXTreeList *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTreeList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onLeftBtnPress(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTreeList_onLeftBtnRelease(int argc, VALUE *argv, VALUE self) { FXTreeList *arg1 = (FXTreeList *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTreeList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onLeftBtnRelease(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTreeList_onRightBtnPress(int argc, VALUE *argv, VALUE self) { FXTreeList *arg1 = (FXTreeList *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTreeList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onRightBtnPress(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTreeList_onRightBtnRelease(int argc, VALUE *argv, VALUE self) { FXTreeList *arg1 = (FXTreeList *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTreeList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onRightBtnRelease(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTreeList_onQueryTip(int argc, VALUE *argv, VALUE self) { FXTreeList *arg1 = (FXTreeList *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTreeList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onQueryTip(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTreeList_onQueryHelp(int argc, VALUE *argv, VALUE self) { FXTreeList *arg1 = (FXTreeList *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTreeList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onQueryHelp(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTreeList_onTipTimer(int argc, VALUE *argv, VALUE self) { FXTreeList *arg1 = (FXTreeList *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTreeList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onTipTimer(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTreeList_onFocusIn(int argc, VALUE *argv, VALUE self) { FXTreeList *arg1 = (FXTreeList *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTreeList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onFocusIn(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTreeList_onFocusOut(int argc, VALUE *argv, VALUE self) { FXTreeList *arg1 = (FXTreeList *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTreeList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onFocusOut(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTreeList_onAutoScroll(int argc, VALUE *argv, VALUE self) { FXTreeList *arg1 = (FXTreeList *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTreeList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onAutoScroll(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTreeList_onClicked(int argc, VALUE *argv, VALUE self) { FXTreeList *arg1 = (FXTreeList *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTreeList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]);
    SWIG_ConvertPtr(argv[2],&arg4,SWIGTYPE_p_FXTreeItem,1); result = (long)(arg1)->onClicked(arg2,arg3,arg4);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTreeList_onDoubleClicked(int argc, VALUE *argv, VALUE self) { FXTreeList *arg1 = (FXTreeList *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTreeList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]);
    SWIG_ConvertPtr(argv[2],&arg4,SWIGTYPE_p_FXTreeItem,1); result = (long)(arg1)->onDoubleClicked(arg2,arg3,arg4);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTreeList_onTripleClicked(int argc, VALUE *argv, VALUE self) { FXTreeList *arg1 = (FXTreeList *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTreeList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]);
    SWIG_ConvertPtr(argv[2],&arg4,SWIGTYPE_p_FXTreeItem,1); result = (long)(arg1)->onTripleClicked(arg2,arg3,arg4);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTreeList_onCommand(int argc, VALUE *argv, VALUE self) { FXTreeList *arg1 = (FXTreeList *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTreeList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]);
    SWIG_ConvertPtr(argv[2],&arg4,SWIGTYPE_p_FXTreeItem,1); result = (long)(arg1)->onCommand(arg2,arg3,arg4);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTreeList_onLookupTimer(int argc, VALUE *argv, VALUE self) { FXTreeList *arg1 = (FXTreeList *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTreeList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onLookupTimer(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTreeList_ascending(int argc, VALUE *argv, VALUE self) { FXTreeItem *arg1 = (FXTreeItem *) 0 ;
    FXTreeItem *arg2 = (FXTreeItem *) 0 ; FXint result; VALUE vresult = Qnil; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXTreeItem, 1);
    SWIG_ConvertPtr(argv[1], (void **) &arg2, SWIGTYPE_p_FXTreeItem, 1);
    result = (FXint)FXTreeList::ascending((FXTreeItem const *)arg1,(FXTreeItem const *)arg2); vresult = INT2NUM(result);
    return vresult; }
static VALUE _wrap_FXTreeList_descending(int argc, VALUE *argv, VALUE self) { FXTreeItem *arg1 = (FXTreeItem *) 0 ;
    FXTreeItem *arg2 = (FXTreeItem *) 0 ; FXint result; VALUE vresult = Qnil; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXTreeItem, 1);
    SWIG_ConvertPtr(argv[1], (void **) &arg2, SWIGTYPE_p_FXTreeItem, 1);
    result = (FXint)FXTreeList::descending((FXTreeItem const *)arg1,(FXTreeItem const *)arg2); vresult = INT2NUM(result);
    return vresult; }
static VALUE _wrap_FXTreeList_ascendingCase(int argc, VALUE *argv, VALUE self) { FXTreeItem *arg1 = (FXTreeItem *) 0 ;
    FXTreeItem *arg2 = (FXTreeItem *) 0 ; FXint result; VALUE vresult = Qnil; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXTreeItem, 1);
    SWIG_ConvertPtr(argv[1], (void **) &arg2, SWIGTYPE_p_FXTreeItem, 1);
    result = (FXint)FXTreeList::ascendingCase((FXTreeItem const *)arg1,(FXTreeItem const *)arg2); vresult = INT2NUM(result);
    return vresult; }
static VALUE _wrap_FXTreeList_descendingCase(int argc, VALUE *argv, VALUE self) { FXTreeItem *arg1 = (FXTreeItem *) 0 ;
    FXTreeItem *arg2 = (FXTreeItem *) 0 ; FXint result; VALUE vresult = Qnil; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXTreeItem, 1);
    SWIG_ConvertPtr(argv[1], (void **) &arg2, SWIGTYPE_p_FXTreeItem, 1);
    result = (FXint)FXTreeList::descendingCase((FXTreeItem const *)arg1,(FXTreeItem const *)arg2); vresult = INT2NUM(result);
    return vresult; }
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE _wrap_FXTreeList_allocate(VALUE self) {
#else
     static VALUE _wrap_FXTreeList_allocate(int argc, VALUE *argv, VALUE self) {
#endif
         VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_FXTreeList);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
         return vresult; }
static VALUE _wrap_new_FXTreeList(int argc, VALUE *argv, VALUE self) { FXComposite *arg1 = (FXComposite *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 = (FXSelector) 0 ; FXuint arg4 = (FXuint) TREELIST_NORMAL ;
    FXint arg5 = (FXint) 0 ; FXint arg6 = (FXint) 0 ; FXint arg7 = (FXint) 0 ; FXint arg8 = (FXint) 0 ; FXTreeList *result;
    if ((argc < 1) || (argc > 8)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXComposite, 1); if (argc > 1) {
        SWIG_ConvertPtr(argv[1], (void **) &arg2, SWIGTYPE_p_FXObject, 1); }  if (argc > 2) { arg3 = NUM2UINT(argv[2]); } 
    if (argc > 3) { arg4 = NUM2UINT(argv[3]); }  if (argc > 4) { arg5 = NUM2INT(argv[4]); }  if (argc > 5) {
        arg6 = NUM2INT(argv[5]); }  if (argc > 6) { arg7 = NUM2INT(argv[6]); }  if (argc > 7) { arg8 = NUM2INT(argv[7]); }  {
        result = (FXTreeList *)new_FXTreeList(arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8);
        DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result); if(rb_block_given_p()){ rb_yield(self); }  }  return self; }
static VALUE _wrap_FXTreeList_getNumItems(int argc, VALUE *argv, VALUE self) { FXTreeList *arg1 = (FXTreeList *) 0 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTreeList, 1); result = (FXint)((FXTreeList const *)arg1)->getNumItems();
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTreeList_getNumVisible(int argc, VALUE *argv, VALUE self) { FXTreeList *arg1 = (FXTreeList *) 0 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTreeList, 1);
    result = (FXint)((FXTreeList const *)arg1)->getNumVisible(); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTreeList_setNumVisible(int argc, VALUE *argv, VALUE self) { FXTreeList *arg1 = (FXTreeList *) 0 ;
    FXint arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTreeList, 1); arg2 = NUM2INT(argv[0]); (arg1)->setNumVisible(arg2);
    return Qnil; }
static VALUE _wrap_FXTreeList_getFirstItem(int argc, VALUE *argv, VALUE self) { FXTreeList *arg1 = (FXTreeList *) 0 ;
    FXTreeItem *result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTreeList, 1);
    result = (FXTreeItem *)((FXTreeList const *)arg1)->getFirstItem(); {
        swig_type_info *ty = SWIG_TypeDynamicCast(SWIGTYPE_p_FXTreeItem, (void **) &result);
        vresult = FXRbGetRubyObj(result, ty); }  return vresult; }
static VALUE _wrap_FXTreeList_getLastItem(int argc, VALUE *argv, VALUE self) { FXTreeList *arg1 = (FXTreeList *) 0 ;
    FXTreeItem *result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTreeList, 1);
    result = (FXTreeItem *)((FXTreeList const *)arg1)->getLastItem(); {
        swig_type_info *ty = SWIG_TypeDynamicCast(SWIGTYPE_p_FXTreeItem, (void **) &result);
        vresult = FXRbGetRubyObj(result, ty); }  return vresult; }
static VALUE _wrap_FXTreeList_addItemFirst__SWIG_0(int argc, VALUE *argv, VALUE self) { FXTreeList *arg1 = (FXTreeList *) 0 ;
    FXTreeItem *arg2 = (FXTreeItem *) 0 ; FXTreeItem *arg3 = (FXTreeItem *) 0 ; FXbool arg4 = (FXbool) 0 ; FXTreeItem *result;
    VALUE vresult = Qnil; if ((argc < 2) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTreeList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXTreeItem, 1);
    SWIG_ConvertPtr(argv[1], (void **) &arg3, SWIGTYPE_p_FXTreeItem, 1); if (argc > 2) { arg4 = to_FXbool(argv[2]); } 
    result = (FXTreeItem *)FXTreeList_addItemFirst__SWIG_0(arg1,arg2,arg3,arg4); {
        swig_type_info *ty = SWIG_TypeDynamicCast(SWIGTYPE_p_FXTreeItem, (void **) &result);
        vresult = FXRbGetRubyObj(result, ty); }  return vresult; }
static VALUE _wrap_FXTreeList_addItemFirst__SWIG_1(int argc, VALUE *argv, VALUE self) { FXTreeList *arg1 = (FXTreeList *) 0 ;
    FXTreeItem *arg2 = (FXTreeItem *) 0 ; FXString *arg3 = 0 ; FXIcon *arg4 = (FXIcon *) 0 ; FXIcon *arg5 = (FXIcon *) 0 ;
    void *arg6 = (void *) 0 ; FXbool arg7 = (FXbool) 0 ; FXTreeItem *result; SwigValueWrapper<FXString > p3 ;
    VALUE vresult = Qnil; if ((argc < 2) || (argc > 6)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTreeList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXTreeItem, 1); p3 = to_FXString(argv[1]); arg3 = &p3; if (argc > 2) {
        SWIG_ConvertPtr(argv[2], (void **) &arg4, SWIGTYPE_p_FXIcon, 1); }  if (argc > 3) {
        SWIG_ConvertPtr(argv[3], (void **) &arg5, SWIGTYPE_p_FXIcon, 1); }  if (argc > 4) {
        arg6 = (argv[4] == Qnil) ? NULL : (void *) argv[4]; }  if (argc > 5) { arg7 = to_FXbool(argv[5]); } 
    result = (FXTreeItem *)FXTreeList_addItemFirst__SWIG_1(arg1,arg2,(FXString const &)*arg3,arg4,arg5,arg6,arg7); {
        swig_type_info *ty = SWIG_TypeDynamicCast(SWIGTYPE_p_FXTreeItem, (void **) &result);
        vresult = FXRbGetRubyObj(result, ty); }  return vresult; }
static VALUE _wrap_FXTreeList_addItemFirst(int nargs, VALUE *args, VALUE self) { int argc; VALUE argv[8]; int ii;
    argc = nargs + 1; argv[0] = self; for (ii = 1; (ii < argc) && (ii < 7); ii++) { argv[ii] = args[ii-1]; } 
    if ((argc >= 3) && (argc <= 4)) { int _v; { void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXTreeList, 0) != -1)) ? 1 : 0; }
         if (_v) { { void *ptr;
                _v = (NIL_P(argv[1]) || (TYPE(argv[1]) == T_DATA && SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_FXTreeItem, 0) != -1)) ? 1 : 0; }
             if (_v) { { void *ptr;
                    _v = (NIL_P(argv[2]) || (TYPE(argv[2]) == T_DATA && SWIG_ConvertPtr(argv[2], &ptr, SWIGTYPE_p_FXTreeItem, 0) != -1)) ? 1 : 0; }
                 if (_v) { if (argc <= 3) { return _wrap_FXTreeList_addItemFirst__SWIG_0(nargs, args, self);}  {
                        _v = (argv[3] == Qtrue || argv[3] == Qfalse) ? 1 : 0; }  if (_v) {
                        return _wrap_FXTreeList_addItemFirst__SWIG_0(nargs, args, self);}  }  }  }  } 
    if ((argc >= 3) && (argc <= 7)) { int _v; { void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXTreeList, 0) != -1)) ? 1 : 0; }
         if (_v) { { void *ptr;
                _v = (NIL_P(argv[1]) || (TYPE(argv[1]) == T_DATA && SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_FXTreeItem, 0) != -1)) ? 1 : 0; }
             if (_v) { { _v = (NIL_P(argv[2]) || TYPE(argv[2]) == T_STRING) ? 1 : 0; }  if (_v) { if (argc <= 3) {
                        return _wrap_FXTreeList_addItemFirst__SWIG_1(nargs, args, self);}  { void *ptr;
                        _v = (NIL_P(argv[3]) || (TYPE(argv[3]) == T_DATA && SWIG_ConvertPtr(argv[3], &ptr, SWIGTYPE_p_FXIcon, 0) != -1)) ? 1 : 0; }
                     if (_v) { if (argc <= 4) { return _wrap_FXTreeList_addItemFirst__SWIG_1(nargs, args, self);}  { void *ptr;
                            _v = (NIL_P(argv[4]) || (TYPE(argv[4]) == T_DATA && SWIG_ConvertPtr(argv[4], &ptr, SWIGTYPE_p_FXIcon, 0) != -1)) ? 1 : 0; }
                         if (_v) { if (argc <= 5) { return _wrap_FXTreeList_addItemFirst__SWIG_1(nargs, args, self);}  {
                                _v = 1; }  if (_v) { if (argc <= 6) {
                                    return _wrap_FXTreeList_addItemFirst__SWIG_1(nargs, args, self);}  {
                                    _v = (argv[6] == Qtrue || argv[6] == Qfalse) ? 1 : 0; }  if (_v) {
                                    return _wrap_FXTreeList_addItemFirst__SWIG_1(nargs, args, self);}  }  }  }  }  }  }  } 
    rb_raise(rb_eArgError, "No matching function for overloaded 'FXTreeList_addItemFirst'"); return Qnil; }
static VALUE _wrap_FXTreeList_addItemLast__SWIG_0(int argc, VALUE *argv, VALUE self) { FXTreeList *arg1 = (FXTreeList *) 0 ;
    FXTreeItem *arg2 = (FXTreeItem *) 0 ; FXTreeItem *arg3 = (FXTreeItem *) 0 ; FXbool arg4 = (FXbool) 0 ; FXTreeItem *result;
    VALUE vresult = Qnil; if ((argc < 2) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTreeList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXTreeItem, 1);
    SWIG_ConvertPtr(argv[1], (void **) &arg3, SWIGTYPE_p_FXTreeItem, 1); if (argc > 2) { arg4 = to_FXbool(argv[2]); } 
    result = (FXTreeItem *)FXTreeList_addItemLast__SWIG_0(arg1,arg2,arg3,arg4); {
        swig_type_info *ty = SWIG_TypeDynamicCast(SWIGTYPE_p_FXTreeItem, (void **) &result);
        vresult = FXRbGetRubyObj(result, ty); }  return vresult; }
static VALUE _wrap_FXTreeList_addItemLast__SWIG_1(int argc, VALUE *argv, VALUE self) { FXTreeList *arg1 = (FXTreeList *) 0 ;
    FXTreeItem *arg2 = (FXTreeItem *) 0 ; FXString *arg3 = 0 ; FXIcon *arg4 = (FXIcon *) 0 ; FXIcon *arg5 = (FXIcon *) 0 ;
    void *arg6 = (void *) 0 ; FXbool arg7 = (FXbool) 0 ; FXTreeItem *result; SwigValueWrapper<FXString > p3 ;
    VALUE vresult = Qnil; if ((argc < 2) || (argc > 6)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTreeList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXTreeItem, 1); p3 = to_FXString(argv[1]); arg3 = &p3; if (argc > 2) {
        SWIG_ConvertPtr(argv[2], (void **) &arg4, SWIGTYPE_p_FXIcon, 1); }  if (argc > 3) {
        SWIG_ConvertPtr(argv[3], (void **) &arg5, SWIGTYPE_p_FXIcon, 1); }  if (argc > 4) {
        arg6 = (argv[4] == Qnil) ? NULL : (void *) argv[4]; }  if (argc > 5) { arg7 = to_FXbool(argv[5]); } 
    result = (FXTreeItem *)FXTreeList_addItemLast__SWIG_1(arg1,arg2,(FXString const &)*arg3,arg4,arg5,arg6,arg7); {
        swig_type_info *ty = SWIG_TypeDynamicCast(SWIGTYPE_p_FXTreeItem, (void **) &result);
        vresult = FXRbGetRubyObj(result, ty); }  return vresult; }
static VALUE _wrap_FXTreeList_addItemLast(int nargs, VALUE *args, VALUE self) { int argc; VALUE argv[8]; int ii;
    argc = nargs + 1; argv[0] = self; for (ii = 1; (ii < argc) && (ii < 7); ii++) { argv[ii] = args[ii-1]; } 
    if ((argc >= 3) && (argc <= 4)) { int _v; { void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXTreeList, 0) != -1)) ? 1 : 0; }
         if (_v) { { void *ptr;
                _v = (NIL_P(argv[1]) || (TYPE(argv[1]) == T_DATA && SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_FXTreeItem, 0) != -1)) ? 1 : 0; }
             if (_v) { { void *ptr;
                    _v = (NIL_P(argv[2]) || (TYPE(argv[2]) == T_DATA && SWIG_ConvertPtr(argv[2], &ptr, SWIGTYPE_p_FXTreeItem, 0) != -1)) ? 1 : 0; }
                 if (_v) { if (argc <= 3) { return _wrap_FXTreeList_addItemLast__SWIG_0(nargs, args, self);}  {
                        _v = (argv[3] == Qtrue || argv[3] == Qfalse) ? 1 : 0; }  if (_v) {
                        return _wrap_FXTreeList_addItemLast__SWIG_0(nargs, args, self);}  }  }  }  } 
    if ((argc >= 3) && (argc <= 7)) { int _v; { void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXTreeList, 0) != -1)) ? 1 : 0; }
         if (_v) { { void *ptr;
                _v = (NIL_P(argv[1]) || (TYPE(argv[1]) == T_DATA && SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_FXTreeItem, 0) != -1)) ? 1 : 0; }
             if (_v) { { _v = (NIL_P(argv[2]) || TYPE(argv[2]) == T_STRING) ? 1 : 0; }  if (_v) { if (argc <= 3) {
                        return _wrap_FXTreeList_addItemLast__SWIG_1(nargs, args, self);}  { void *ptr;
                        _v = (NIL_P(argv[3]) || (TYPE(argv[3]) == T_DATA && SWIG_ConvertPtr(argv[3], &ptr, SWIGTYPE_p_FXIcon, 0) != -1)) ? 1 : 0; }
                     if (_v) { if (argc <= 4) { return _wrap_FXTreeList_addItemLast__SWIG_1(nargs, args, self);}  { void *ptr;
                            _v = (NIL_P(argv[4]) || (TYPE(argv[4]) == T_DATA && SWIG_ConvertPtr(argv[4], &ptr, SWIGTYPE_p_FXIcon, 0) != -1)) ? 1 : 0; }
                         if (_v) { if (argc <= 5) { return _wrap_FXTreeList_addItemLast__SWIG_1(nargs, args, self);}  { _v = 1; }
                             if (_v) { if (argc <= 6) { return _wrap_FXTreeList_addItemLast__SWIG_1(nargs, args, self);}  {
                                    _v = (argv[6] == Qtrue || argv[6] == Qfalse) ? 1 : 0; }  if (_v) {
                                    return _wrap_FXTreeList_addItemLast__SWIG_1(nargs, args, self);}  }  }  }  }  }  }  } 
    rb_raise(rb_eArgError, "No matching function for overloaded 'FXTreeList_addItemLast'"); return Qnil; }
static VALUE _wrap_FXTreeList_addItemAfter__SWIG_0(int argc, VALUE *argv, VALUE self) { FXTreeList *arg1 = (FXTreeList *) 0 ;
    FXTreeItem *arg2 = (FXTreeItem *) 0 ; FXTreeItem *arg3 = (FXTreeItem *) 0 ; FXbool arg4 = (FXbool) 0 ; FXTreeItem *result;
    VALUE vresult = Qnil; if ((argc < 2) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTreeList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXTreeItem, 1);
    SWIG_ConvertPtr(argv[1], (void **) &arg3, SWIGTYPE_p_FXTreeItem, 1); if (argc > 2) { arg4 = to_FXbool(argv[2]); } 
    result = (FXTreeItem *)FXTreeList_addItemAfter__SWIG_0(arg1,arg2,arg3,arg4); {
        swig_type_info *ty = SWIG_TypeDynamicCast(SWIGTYPE_p_FXTreeItem, (void **) &result);
        vresult = FXRbGetRubyObj(result, ty); }  return vresult; }
static VALUE _wrap_FXTreeList_addItemAfter__SWIG_1(int argc, VALUE *argv, VALUE self) { FXTreeList *arg1 = (FXTreeList *) 0 ;
    FXTreeItem *arg2 = (FXTreeItem *) 0 ; FXString *arg3 = 0 ; FXIcon *arg4 = (FXIcon *) 0 ; FXIcon *arg5 = (FXIcon *) 0 ;
    void *arg6 = (void *) 0 ; FXbool arg7 = (FXbool) 0 ; FXTreeItem *result; SwigValueWrapper<FXString > p3 ;
    VALUE vresult = Qnil; if ((argc < 2) || (argc > 6)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTreeList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXTreeItem, 1); p3 = to_FXString(argv[1]); arg3 = &p3; if (argc > 2) {
        SWIG_ConvertPtr(argv[2], (void **) &arg4, SWIGTYPE_p_FXIcon, 1); }  if (argc > 3) {
        SWIG_ConvertPtr(argv[3], (void **) &arg5, SWIGTYPE_p_FXIcon, 1); }  if (argc > 4) {
        arg6 = (argv[4] == Qnil) ? NULL : (void *) argv[4]; }  if (argc > 5) { arg7 = to_FXbool(argv[5]); } 
    result = (FXTreeItem *)FXTreeList_addItemAfter__SWIG_1(arg1,arg2,(FXString const &)*arg3,arg4,arg5,arg6,arg7); {
        swig_type_info *ty = SWIG_TypeDynamicCast(SWIGTYPE_p_FXTreeItem, (void **) &result);
        vresult = FXRbGetRubyObj(result, ty); }  return vresult; }
static VALUE _wrap_FXTreeList_addItemAfter(int nargs, VALUE *args, VALUE self) { int argc; VALUE argv[8]; int ii;
    argc = nargs + 1; argv[0] = self; for (ii = 1; (ii < argc) && (ii < 7); ii++) { argv[ii] = args[ii-1]; } 
    if ((argc >= 3) && (argc <= 4)) { int _v; { void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXTreeList, 0) != -1)) ? 1 : 0; }
         if (_v) { { void *ptr;
                _v = (NIL_P(argv[1]) || (TYPE(argv[1]) == T_DATA && SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_FXTreeItem, 0) != -1)) ? 1 : 0; }
             if (_v) { { void *ptr;
                    _v = (NIL_P(argv[2]) || (TYPE(argv[2]) == T_DATA && SWIG_ConvertPtr(argv[2], &ptr, SWIGTYPE_p_FXTreeItem, 0) != -1)) ? 1 : 0; }
                 if (_v) { if (argc <= 3) { return _wrap_FXTreeList_addItemAfter__SWIG_0(nargs, args, self);}  {
                        _v = (argv[3] == Qtrue || argv[3] == Qfalse) ? 1 : 0; }  if (_v) {
                        return _wrap_FXTreeList_addItemAfter__SWIG_0(nargs, args, self);}  }  }  }  } 
    if ((argc >= 3) && (argc <= 7)) { int _v; { void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXTreeList, 0) != -1)) ? 1 : 0; }
         if (_v) { { void *ptr;
                _v = (NIL_P(argv[1]) || (TYPE(argv[1]) == T_DATA && SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_FXTreeItem, 0) != -1)) ? 1 : 0; }
             if (_v) { { _v = (NIL_P(argv[2]) || TYPE(argv[2]) == T_STRING) ? 1 : 0; }  if (_v) { if (argc <= 3) {
                        return _wrap_FXTreeList_addItemAfter__SWIG_1(nargs, args, self);}  { void *ptr;
                        _v = (NIL_P(argv[3]) || (TYPE(argv[3]) == T_DATA && SWIG_ConvertPtr(argv[3], &ptr, SWIGTYPE_p_FXIcon, 0) != -1)) ? 1 : 0; }
                     if (_v) { if (argc <= 4) { return _wrap_FXTreeList_addItemAfter__SWIG_1(nargs, args, self);}  { void *ptr;
                            _v = (NIL_P(argv[4]) || (TYPE(argv[4]) == T_DATA && SWIG_ConvertPtr(argv[4], &ptr, SWIGTYPE_p_FXIcon, 0) != -1)) ? 1 : 0; }
                         if (_v) { if (argc <= 5) { return _wrap_FXTreeList_addItemAfter__SWIG_1(nargs, args, self);}  {
                                _v = 1; }  if (_v) { if (argc <= 6) {
                                    return _wrap_FXTreeList_addItemAfter__SWIG_1(nargs, args, self);}  {
                                    _v = (argv[6] == Qtrue || argv[6] == Qfalse) ? 1 : 0; }  if (_v) {
                                    return _wrap_FXTreeList_addItemAfter__SWIG_1(nargs, args, self);}  }  }  }  }  }  }  } 
    rb_raise(rb_eArgError, "No matching function for overloaded 'FXTreeList_addItemAfter'"); return Qnil; }
static VALUE _wrap_FXTreeList_addItemBefore__SWIG_0(int argc, VALUE *argv, VALUE self) { FXTreeList *arg1 = (FXTreeList *) 0 ;
    FXTreeItem *arg2 = (FXTreeItem *) 0 ; FXTreeItem *arg3 = (FXTreeItem *) 0 ; FXbool arg4 = (FXbool) 0 ; FXTreeItem *result;
    VALUE vresult = Qnil; if ((argc < 2) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTreeList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXTreeItem, 1);
    SWIG_ConvertPtr(argv[1], (void **) &arg3, SWIGTYPE_p_FXTreeItem, 1); if (argc > 2) { arg4 = to_FXbool(argv[2]); } 
    result = (FXTreeItem *)FXTreeList_addItemBefore__SWIG_0(arg1,arg2,arg3,arg4); {
        swig_type_info *ty = SWIG_TypeDynamicCast(SWIGTYPE_p_FXTreeItem, (void **) &result);
        vresult = FXRbGetRubyObj(result, ty); }  return vresult; }
static VALUE _wrap_FXTreeList_addItemBefore__SWIG_1(int argc, VALUE *argv, VALUE self) { FXTreeList *arg1 = (FXTreeList *) 0 ;
    FXTreeItem *arg2 = (FXTreeItem *) 0 ; FXString *arg3 = 0 ; FXIcon *arg4 = (FXIcon *) 0 ; FXIcon *arg5 = (FXIcon *) 0 ;
    void *arg6 = (void *) 0 ; FXbool arg7 = (FXbool) 0 ; FXTreeItem *result; SwigValueWrapper<FXString > p3 ;
    VALUE vresult = Qnil; if ((argc < 2) || (argc > 6)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTreeList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXTreeItem, 1); p3 = to_FXString(argv[1]); arg3 = &p3; if (argc > 2) {
        SWIG_ConvertPtr(argv[2], (void **) &arg4, SWIGTYPE_p_FXIcon, 1); }  if (argc > 3) {
        SWIG_ConvertPtr(argv[3], (void **) &arg5, SWIGTYPE_p_FXIcon, 1); }  if (argc > 4) {
        arg6 = (argv[4] == Qnil) ? NULL : (void *) argv[4]; }  if (argc > 5) { arg7 = to_FXbool(argv[5]); } 
    result = (FXTreeItem *)FXTreeList_addItemBefore__SWIG_1(arg1,arg2,(FXString const &)*arg3,arg4,arg5,arg6,arg7); {
        swig_type_info *ty = SWIG_TypeDynamicCast(SWIGTYPE_p_FXTreeItem, (void **) &result);
        vresult = FXRbGetRubyObj(result, ty); }  return vresult; }
static VALUE _wrap_FXTreeList_addItemBefore(int nargs, VALUE *args, VALUE self) { int argc; VALUE argv[8]; int ii;
    argc = nargs + 1; argv[0] = self; for (ii = 1; (ii < argc) && (ii < 7); ii++) { argv[ii] = args[ii-1]; } 
    if ((argc >= 3) && (argc <= 4)) { int _v; { void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXTreeList, 0) != -1)) ? 1 : 0; }
         if (_v) { { void *ptr;
                _v = (NIL_P(argv[1]) || (TYPE(argv[1]) == T_DATA && SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_FXTreeItem, 0) != -1)) ? 1 : 0; }
             if (_v) { { void *ptr;
                    _v = (NIL_P(argv[2]) || (TYPE(argv[2]) == T_DATA && SWIG_ConvertPtr(argv[2], &ptr, SWIGTYPE_p_FXTreeItem, 0) != -1)) ? 1 : 0; }
                 if (_v) { if (argc <= 3) { return _wrap_FXTreeList_addItemBefore__SWIG_0(nargs, args, self);}  {
                        _v = (argv[3] == Qtrue || argv[3] == Qfalse) ? 1 : 0; }  if (_v) {
                        return _wrap_FXTreeList_addItemBefore__SWIG_0(nargs, args, self);}  }  }  }  } 
    if ((argc >= 3) && (argc <= 7)) { int _v; { void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXTreeList, 0) != -1)) ? 1 : 0; }
         if (_v) { { void *ptr;
                _v = (NIL_P(argv[1]) || (TYPE(argv[1]) == T_DATA && SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_FXTreeItem, 0) != -1)) ? 1 : 0; }
             if (_v) { { _v = (NIL_P(argv[2]) || TYPE(argv[2]) == T_STRING) ? 1 : 0; }  if (_v) { if (argc <= 3) {
                        return _wrap_FXTreeList_addItemBefore__SWIG_1(nargs, args, self);}  { void *ptr;
                        _v = (NIL_P(argv[3]) || (TYPE(argv[3]) == T_DATA && SWIG_ConvertPtr(argv[3], &ptr, SWIGTYPE_p_FXIcon, 0) != -1)) ? 1 : 0; }
                     if (_v) { if (argc <= 4) { return _wrap_FXTreeList_addItemBefore__SWIG_1(nargs, args, self);}  { void *ptr;
                            _v = (NIL_P(argv[4]) || (TYPE(argv[4]) == T_DATA && SWIG_ConvertPtr(argv[4], &ptr, SWIGTYPE_p_FXIcon, 0) != -1)) ? 1 : 0; }
                         if (_v) { if (argc <= 5) { return _wrap_FXTreeList_addItemBefore__SWIG_1(nargs, args, self);}  {
                                _v = 1; }  if (_v) { if (argc <= 6) {
                                    return _wrap_FXTreeList_addItemBefore__SWIG_1(nargs, args, self);}  {
                                    _v = (argv[6] == Qtrue || argv[6] == Qfalse) ? 1 : 0; }  if (_v) {
                                    return _wrap_FXTreeList_addItemBefore__SWIG_1(nargs, args, self);}  }  }  }  }  }  }  } 
    rb_raise(rb_eArgError, "No matching function for overloaded 'FXTreeList_addItemBefore'"); return Qnil; }
static VALUE _wrap_FXTreeList_reparentItem(int argc, VALUE *argv, VALUE self) { FXTreeList *arg1 = (FXTreeList *) 0 ;
    FXTreeItem *arg2 = (FXTreeItem *) 0 ; FXTreeItem *arg3 = (FXTreeItem *) 0 ; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTreeList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXTreeItem, 1);
    SWIG_ConvertPtr(argv[1], (void **) &arg3, SWIGTYPE_p_FXTreeItem, 1); (arg1)->reparentItem(arg2,arg3); return Qnil; }
static VALUE _wrap_FXTreeList_moveItemBefore(int argc, VALUE *argv, VALUE self) { FXTreeList *arg1 = (FXTreeList *) 0 ;
    FXTreeItem *arg2 = (FXTreeItem *) 0 ; FXTreeItem *arg3 = (FXTreeItem *) 0 ; FXTreeItem *result; VALUE vresult = Qnil;
    if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTreeList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXTreeItem, 1);
    SWIG_ConvertPtr(argv[1], (void **) &arg3, SWIGTYPE_p_FXTreeItem, 1);
    result = (FXTreeItem *)(arg1)->moveItemBefore(arg2,arg3); {
        swig_type_info *ty = SWIG_TypeDynamicCast(SWIGTYPE_p_FXTreeItem, (void **) &result);
        vresult = FXRbGetRubyObj(result, ty); }  return vresult; }
static VALUE _wrap_FXTreeList_moveItemAfter(int argc, VALUE *argv, VALUE self) { FXTreeList *arg1 = (FXTreeList *) 0 ;
    FXTreeItem *arg2 = (FXTreeItem *) 0 ; FXTreeItem *arg3 = (FXTreeItem *) 0 ; FXTreeItem *result; VALUE vresult = Qnil;
    if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTreeList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXTreeItem, 1);
    SWIG_ConvertPtr(argv[1], (void **) &arg3, SWIGTYPE_p_FXTreeItem, 1);
    result = (FXTreeItem *)(arg1)->moveItemAfter(arg2,arg3); {
        swig_type_info *ty = SWIG_TypeDynamicCast(SWIGTYPE_p_FXTreeItem, (void **) &result);
        vresult = FXRbGetRubyObj(result, ty); }  return vresult; }
static VALUE _wrap_FXTreeList_removeItem(int argc, VALUE *argv, VALUE self) { FXTreeList *arg1 = (FXTreeList *) 0 ;
    FXTreeItem *arg2 = (FXTreeItem *) 0 ; FXbool arg3 = (FXbool) 0 ; if ((argc < 1) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTreeList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXTreeItem, 1); if (argc > 1) { arg3 = to_FXbool(argv[1]); } 
    FXTreeList_removeItem(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXTreeList_removeItems(int argc, VALUE *argv, VALUE self) { FXTreeList *arg1 = (FXTreeList *) 0 ;
    FXTreeItem *arg2 = (FXTreeItem *) 0 ; FXTreeItem *arg3 = (FXTreeItem *) 0 ; FXbool arg4 = (FXbool) 0 ;
    if ((argc < 2) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTreeList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXTreeItem, 1);
    SWIG_ConvertPtr(argv[1], (void **) &arg3, SWIGTYPE_p_FXTreeItem, 1); if (argc > 2) { arg4 = to_FXbool(argv[2]); } 
    FXTreeList_removeItems(arg1,arg2,arg3,arg4); return Qnil; }
static VALUE _wrap_FXTreeList_clearItems(int argc, VALUE *argv, VALUE self) { FXTreeList *arg1 = (FXTreeList *) 0 ;
    FXbool arg2 = (FXbool) 0 ; if ((argc < 0) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTreeList, 1); if (argc > 0) { arg2 = to_FXbool(argv[0]); } 
    FXTreeList_clearItems(arg1,arg2); return Qnil; }
static VALUE _wrap_FXTreeList_getItemWidth(int argc, VALUE *argv, VALUE self) { FXTreeList *arg1 = (FXTreeList *) 0 ;
    FXTreeItem *arg2 = (FXTreeItem *) 0 ; FXint result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTreeList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXTreeItem, 1);
    result = (FXint)((FXTreeList const *)arg1)->getItemWidth((FXTreeItem const *)arg2); vresult = INT2NUM(result);
    return vresult; }
static VALUE _wrap_FXTreeList_getItemHeight(int argc, VALUE *argv, VALUE self) { FXTreeList *arg1 = (FXTreeList *) 0 ;
    FXTreeItem *arg2 = (FXTreeItem *) 0 ; FXint result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTreeList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXTreeItem, 1);
    result = (FXint)((FXTreeList const *)arg1)->getItemHeight((FXTreeItem const *)arg2); vresult = INT2NUM(result);
    return vresult; }
static VALUE _wrap_FXTreeList_getItemAt(int argc, VALUE *argv, VALUE self) { FXTreeList *arg1 = (FXTreeList *) 0 ; FXint arg2 ;
    FXint arg3 ; FXTreeItem *result; VALUE vresult = Qnil; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTreeList, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    result = (FXTreeItem *)((FXTreeList const *)arg1)->getItemAt(arg2,arg3); {
        swig_type_info *ty = SWIG_TypeDynamicCast(SWIGTYPE_p_FXTreeItem, (void **) &result);
        vresult = FXRbGetRubyObj(result, ty); }  return vresult; }
static VALUE _wrap_FXTreeList_findItem(int argc, VALUE *argv, VALUE self) { FXTreeList *arg1 = (FXTreeList *) 0 ;
    FXString *arg2 = 0 ; FXTreeItem *arg3 = (FXTreeItem *) 0 ; FXuint arg4 = (FXuint) SEARCH_FORWARD|SEARCH_WRAP ;
    FXTreeItem *result; SwigValueWrapper<FXString > p2 ; VALUE vresult = Qnil; if ((argc < 1) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTreeList, 1); p2 = to_FXString(argv[0]); arg2 = &p2; if (argc > 1) {
        SWIG_ConvertPtr(argv[1], (void **) &arg3, SWIGTYPE_p_FXTreeItem, 1); }  if (argc > 2) { arg4 = NUM2UINT(argv[2]); } 
    result = (FXTreeItem *)((FXTreeList const *)arg1)->findItem((FXString const &)*arg2,arg3,arg4); {
        swig_type_info *ty = SWIG_TypeDynamicCast(SWIGTYPE_p_FXTreeItem, (void **) &result);
        vresult = FXRbGetRubyObj(result, ty); }  return vresult; }
static VALUE _wrap_FXTreeList_makeItemVisible(int argc, VALUE *argv, VALUE self) { FXTreeList *arg1 = (FXTreeList *) 0 ;
    FXTreeItem *arg2 = (FXTreeItem *) 0 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTreeList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXTreeItem, 1); (arg1)->makeItemVisible(arg2); return Qnil; }
static VALUE _wrap_FXTreeList_setItemText(int argc, VALUE *argv, VALUE self) { FXTreeList *arg1 = (FXTreeList *) 0 ;
    FXTreeItem *arg2 = (FXTreeItem *) 0 ; FXString *arg3 = 0 ; SwigValueWrapper<FXString > p3 ; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTreeList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXTreeItem, 1); p3 = to_FXString(argv[1]); arg3 = &p3;
    (arg1)->setItemText(arg2,(FXString const &)*arg3); return Qnil; }
static VALUE _wrap_FXTreeList_getItemText(int argc, VALUE *argv, VALUE self) { FXTreeList *arg1 = (FXTreeList *) 0 ;
    FXTreeItem *arg2 = (FXTreeItem *) 0 ; FXString result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTreeList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXTreeItem, 1);
    result = ((FXTreeList const *)arg1)->getItemText((FXTreeItem const *)arg2); vresult = rb_str_new2((&result)->text());
    return vresult; }
static VALUE _wrap_FXTreeList_setItemOpenIcon(int argc, VALUE *argv, VALUE self) { FXTreeList *arg1 = (FXTreeList *) 0 ;
    FXTreeItem *arg2 = (FXTreeItem *) 0 ; FXIcon *arg3 = (FXIcon *) 0 ; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTreeList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXTreeItem, 1);
    SWIG_ConvertPtr(argv[1], (void **) &arg3, SWIGTYPE_p_FXIcon, 1); (arg1)->setItemOpenIcon(arg2,arg3); return Qnil; }
static VALUE _wrap_FXTreeList_getItemOpenIcon(int argc, VALUE *argv, VALUE self) { FXTreeList *arg1 = (FXTreeList *) 0 ;
    FXTreeItem *arg2 = (FXTreeItem *) 0 ; FXIcon *result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTreeList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXTreeItem, 1);
    result = (FXIcon *)((FXTreeList const *)arg1)->getItemOpenIcon((FXTreeItem const *)arg2); {
        swig_type_info *ty = SWIG_TypeDynamicCast(SWIGTYPE_p_FXIcon, (void **) &result); vresult = FXRbGetRubyObj(result, ty); }
     return vresult; }
static VALUE _wrap_FXTreeList_setItemClosedIcon(int argc, VALUE *argv, VALUE self) { FXTreeList *arg1 = (FXTreeList *) 0 ;
    FXTreeItem *arg2 = (FXTreeItem *) 0 ; FXIcon *arg3 = (FXIcon *) 0 ; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTreeList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXTreeItem, 1);
    SWIG_ConvertPtr(argv[1], (void **) &arg3, SWIGTYPE_p_FXIcon, 1); (arg1)->setItemClosedIcon(arg2,arg3); return Qnil; }
static VALUE _wrap_FXTreeList_getItemClosedIcon(int argc, VALUE *argv, VALUE self) { FXTreeList *arg1 = (FXTreeList *) 0 ;
    FXTreeItem *arg2 = (FXTreeItem *) 0 ; FXIcon *result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTreeList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXTreeItem, 1);
    result = (FXIcon *)((FXTreeList const *)arg1)->getItemClosedIcon((FXTreeItem const *)arg2); {
        swig_type_info *ty = SWIG_TypeDynamicCast(SWIGTYPE_p_FXIcon, (void **) &result); vresult = FXRbGetRubyObj(result, ty); }
     return vresult; }
static VALUE _wrap_FXTreeList_setItemData(int argc, VALUE *argv, VALUE self) { FXTreeList *arg1 = (FXTreeList *) 0 ;
    FXTreeItem *arg2 = (FXTreeItem *) 0 ; VALUE arg3 ; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTreeList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXTreeItem, 1); arg3 = argv[1]; FXTreeList_setItemData(arg1,arg2,arg3);
    return Qnil; }
static VALUE _wrap_FXTreeList_getItemData(int argc, VALUE *argv, VALUE self) { FXTreeList *arg1 = (FXTreeList *) 0 ;
    FXTreeItem *arg2 = (FXTreeItem *) 0 ; VALUE result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTreeList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXTreeItem, 1);
    result = (VALUE)FXTreeList_getItemData((FXTreeList const *)arg1,(FXTreeItem const *)arg2); vresult = result;
    return vresult; }
static VALUE _wrap_FXTreeList_isItemSelected(int argc, VALUE *argv, VALUE self) { FXTreeList *arg1 = (FXTreeList *) 0 ;
    FXTreeItem *arg2 = (FXTreeItem *) 0 ; FXbool result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTreeList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXTreeItem, 1);
    result = (FXbool)((FXTreeList const *)arg1)->isItemSelected((FXTreeItem const *)arg2); vresult = result ? Qtrue : Qfalse;
    return vresult; }
static VALUE _wrap_FXTreeList_isItemCurrent(int argc, VALUE *argv, VALUE self) { FXTreeList *arg1 = (FXTreeList *) 0 ;
    FXTreeItem *arg2 = (FXTreeItem *) 0 ; FXbool result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTreeList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXTreeItem, 1);
    result = (FXbool)((FXTreeList const *)arg1)->isItemCurrent((FXTreeItem const *)arg2); vresult = result ? Qtrue : Qfalse;
    return vresult; }
static VALUE _wrap_FXTreeList_isItemVisible(int argc, VALUE *argv, VALUE self) { FXTreeList *arg1 = (FXTreeList *) 0 ;
    FXTreeItem *arg2 = (FXTreeItem *) 0 ; FXbool result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTreeList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXTreeItem, 1);
    result = (FXbool)((FXTreeList const *)arg1)->isItemVisible((FXTreeItem const *)arg2); vresult = result ? Qtrue : Qfalse;
    return vresult; }
static VALUE _wrap_FXTreeList_isItemOpened(int argc, VALUE *argv, VALUE self) { FXTreeList *arg1 = (FXTreeList *) 0 ;
    FXTreeItem *arg2 = (FXTreeItem *) 0 ; FXbool result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTreeList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXTreeItem, 1);
    result = (FXbool)((FXTreeList const *)arg1)->isItemOpened((FXTreeItem const *)arg2); vresult = result ? Qtrue : Qfalse;
    return vresult; }
static VALUE _wrap_FXTreeList_isItemExpanded(int argc, VALUE *argv, VALUE self) { FXTreeList *arg1 = (FXTreeList *) 0 ;
    FXTreeItem *arg2 = (FXTreeItem *) 0 ; FXbool result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTreeList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXTreeItem, 1);
    result = (FXbool)((FXTreeList const *)arg1)->isItemExpanded((FXTreeItem const *)arg2); vresult = result ? Qtrue : Qfalse;
    return vresult; }
static VALUE _wrap_FXTreeList_isItemLeaf(int argc, VALUE *argv, VALUE self) { FXTreeList *arg1 = (FXTreeList *) 0 ;
    FXTreeItem *arg2 = (FXTreeItem *) 0 ; FXbool result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTreeList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXTreeItem, 1);
    result = (FXbool)((FXTreeList const *)arg1)->isItemLeaf((FXTreeItem const *)arg2); vresult = result ? Qtrue : Qfalse;
    return vresult; }
static VALUE _wrap_FXTreeList_isItemEnabled(int argc, VALUE *argv, VALUE self) { FXTreeList *arg1 = (FXTreeList *) 0 ;
    FXTreeItem *arg2 = (FXTreeItem *) 0 ; FXbool result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTreeList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXTreeItem, 1);
    result = (FXbool)((FXTreeList const *)arg1)->isItemEnabled((FXTreeItem const *)arg2); vresult = result ? Qtrue : Qfalse;
    return vresult; }
static VALUE _wrap_FXTreeList_hitItem(int argc, VALUE *argv, VALUE self) { FXTreeList *arg1 = (FXTreeList *) 0 ;
    FXTreeItem *arg2 = (FXTreeItem *) 0 ; FXint arg3 ; FXint arg4 ; FXint result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTreeList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXTreeItem, 1); arg3 = NUM2INT(argv[1]); arg4 = NUM2INT(argv[2]);
    result = (FXint)((FXTreeList const *)arg1)->hitItem((FXTreeItem const *)arg2,arg3,arg4); vresult = INT2NUM(result);
    return vresult; }
static VALUE _wrap_FXTreeList_updateItem(int argc, VALUE *argv, VALUE self) { FXTreeList *arg1 = (FXTreeList *) 0 ;
    FXTreeItem *arg2 = (FXTreeItem *) 0 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTreeList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXTreeItem, 1); ((FXTreeList const *)arg1)->updateItem(arg2);
    return Qnil; }
static VALUE _wrap_FXTreeList_enableItem(int argc, VALUE *argv, VALUE self) { FXTreeList *arg1 = (FXTreeList *) 0 ;
    FXTreeItem *arg2 = (FXTreeItem *) 0 ; FXbool result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTreeList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXTreeItem, 1); result = (FXbool)(arg1)->enableItem(arg2);
    vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXTreeList_disableItem(int argc, VALUE *argv, VALUE self) { FXTreeList *arg1 = (FXTreeList *) 0 ;
    FXTreeItem *arg2 = (FXTreeItem *) 0 ; FXbool result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTreeList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXTreeItem, 1); result = (FXbool)(arg1)->disableItem(arg2);
    vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXTreeList_getCurrentItem(int argc, VALUE *argv, VALUE self) { FXTreeList *arg1 = (FXTreeList *) 0 ;
    FXTreeItem *result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTreeList, 1);
    result = (FXTreeItem *)((FXTreeList const *)arg1)->getCurrentItem(); {
        swig_type_info *ty = SWIG_TypeDynamicCast(SWIGTYPE_p_FXTreeItem, (void **) &result);
        vresult = FXRbGetRubyObj(result, ty); }  return vresult; }
static VALUE _wrap_FXTreeList_setAnchorItem(int argc, VALUE *argv, VALUE self) { FXTreeList *arg1 = (FXTreeList *) 0 ;
    FXTreeItem *arg2 = (FXTreeItem *) 0 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTreeList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXTreeItem, 1); (arg1)->setAnchorItem(arg2); return Qnil; }
static VALUE _wrap_FXTreeList_getAnchorItem(int argc, VALUE *argv, VALUE self) { FXTreeList *arg1 = (FXTreeList *) 0 ;
    FXTreeItem *result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTreeList, 1);
    result = (FXTreeItem *)((FXTreeList const *)arg1)->getAnchorItem(); {
        swig_type_info *ty = SWIG_TypeDynamicCast(SWIGTYPE_p_FXTreeItem, (void **) &result);
        vresult = FXRbGetRubyObj(result, ty); }  return vresult; }
static VALUE _wrap_FXTreeList_getCursorItem(int argc, VALUE *argv, VALUE self) { FXTreeList *arg1 = (FXTreeList *) 0 ;
    FXTreeItem *result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTreeList, 1);
    result = (FXTreeItem *)((FXTreeList const *)arg1)->getCursorItem(); {
        swig_type_info *ty = SWIG_TypeDynamicCast(SWIGTYPE_p_FXTreeItem, (void **) &result);
        vresult = FXRbGetRubyObj(result, ty); }  return vresult; }
static VALUE _wrap_FXTreeList_sortRootItems(int argc, VALUE *argv, VALUE self) { FXTreeList *arg1 = (FXTreeList *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTreeList, 1); (arg1)->sortRootItems(); return Qnil; }
static VALUE _wrap_FXTreeList_sortItems(int argc, VALUE *argv, VALUE self) { FXTreeList *arg1 = (FXTreeList *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTreeList, 1); (arg1)->sortItems(); return Qnil; }
static VALUE _wrap_FXTreeList_sortChildItems(int argc, VALUE *argv, VALUE self) { FXTreeList *arg1 = (FXTreeList *) 0 ;
    FXTreeItem *arg2 = (FXTreeItem *) 0 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTreeList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXTreeItem, 1); (arg1)->sortChildItems(arg2); return Qnil; }
static VALUE _wrap_FXTreeList_setFont(int argc, VALUE *argv, VALUE self) { FXTreeList *arg1 = (FXTreeList *) 0 ;
    FXFont *arg2 = (FXFont *) 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTreeList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXFont, 1); (arg1)->setFont(arg2); return Qnil; }
static VALUE _wrap_FXTreeList_getFont(int argc, VALUE *argv, VALUE self) { FXTreeList *arg1 = (FXTreeList *) 0 ; FXFont *result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTreeList, 1); result = (FXFont *)((FXTreeList const *)arg1)->getFont();
    { swig_type_info *ty = SWIG_TypeDynamicCast(SWIGTYPE_p_FXFont, (void **) &result); vresult = FXRbGetRubyObj(result, ty); } 
    return vresult; }
static VALUE _wrap_FXTreeList_setIndent(int argc, VALUE *argv, VALUE self) { FXTreeList *arg1 = (FXTreeList *) 0 ; FXint arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTreeList, 1); arg2 = NUM2INT(argv[0]); (arg1)->setIndent(arg2);
    return Qnil; }
static VALUE _wrap_FXTreeList_getIndent(int argc, VALUE *argv, VALUE self) { FXTreeList *arg1 = (FXTreeList *) 0 ; FXint result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTreeList, 1); result = (FXint)((FXTreeList const *)arg1)->getIndent();
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTreeList_getTextColor(int argc, VALUE *argv, VALUE self) { FXTreeList *arg1 = (FXTreeList *) 0 ;
    FXColor result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTreeList, 1);
    result = (FXColor)((FXTreeList const *)arg1)->getTextColor(); vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXTreeList_setTextColor(int argc, VALUE *argv, VALUE self) { FXTreeList *arg1 = (FXTreeList *) 0 ;
    FXColor arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTreeList, 1); arg2 = to_FXColor(argv[0]); (arg1)->setTextColor(arg2);
    return Qnil; }
static VALUE _wrap_FXTreeList_getSelBackColor(int argc, VALUE *argv, VALUE self) { FXTreeList *arg1 = (FXTreeList *) 0 ;
    FXColor result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTreeList, 1);
    result = (FXColor)((FXTreeList const *)arg1)->getSelBackColor(); vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXTreeList_setSelBackColor(int argc, VALUE *argv, VALUE self) { FXTreeList *arg1 = (FXTreeList *) 0 ;
    FXColor arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTreeList, 1); arg2 = to_FXColor(argv[0]); (arg1)->setSelBackColor(arg2);
    return Qnil; }
static VALUE _wrap_FXTreeList_getSelTextColor(int argc, VALUE *argv, VALUE self) { FXTreeList *arg1 = (FXTreeList *) 0 ;
    FXColor result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTreeList, 1);
    result = (FXColor)((FXTreeList const *)arg1)->getSelTextColor(); vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXTreeList_setSelTextColor(int argc, VALUE *argv, VALUE self) { FXTreeList *arg1 = (FXTreeList *) 0 ;
    FXColor arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTreeList, 1); arg2 = to_FXColor(argv[0]); (arg1)->setSelTextColor(arg2);
    return Qnil; }
static VALUE _wrap_FXTreeList_getLineColor(int argc, VALUE *argv, VALUE self) { FXTreeList *arg1 = (FXTreeList *) 0 ;
    FXColor result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTreeList, 1);
    result = (FXColor)((FXTreeList const *)arg1)->getLineColor(); vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXTreeList_setLineColor(int argc, VALUE *argv, VALUE self) { FXTreeList *arg1 = (FXTreeList *) 0 ;
    FXColor arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTreeList, 1); arg2 = to_FXColor(argv[0]); (arg1)->setLineColor(arg2);
    return Qnil; }
static VALUE _wrap_FXTreeList_getListStyle(int argc, VALUE *argv, VALUE self) { FXTreeList *arg1 = (FXTreeList *) 0 ;
    FXuint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTreeList, 1);
    result = (FXuint)((FXTreeList const *)arg1)->getListStyle(); vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXTreeList_setListStyle(int argc, VALUE *argv, VALUE self) { FXTreeList *arg1 = (FXTreeList *) 0 ;
    FXuint arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTreeList, 1); arg2 = NUM2UINT(argv[0]); (arg1)->setListStyle(arg2);
    return Qnil; }
static VALUE _wrap_FXTreeList_setHelpText(int argc, VALUE *argv, VALUE self) { FXTreeList *arg1 = (FXTreeList *) 0 ;
    FXString *arg2 = 0 ; SwigValueWrapper<FXString > p2 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTreeList, 1); p2 = to_FXString(argv[0]); arg2 = &p2;
    (arg1)->setHelpText((FXString const &)*arg2); return Qnil; }
static VALUE _wrap_FXTreeList_getHelpText(int argc, VALUE *argv, VALUE self) { FXTreeList *arg1 = (FXTreeList *) 0 ;
    FXString result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTreeList, 1); result = ((FXTreeList const *)arg1)->getHelpText();
    vresult = rb_str_new2((&result)->text()); return vresult; }
static void
free_FXTreeList(FXTreeList *arg1) {
    delete arg1;
}
static VALUE _wrap_FXTreeList_save(int argc, VALUE *argv, VALUE self) { FXTreeList *arg1 = (FXTreeList *) 0 ;
    FXStream *arg2 = 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTreeList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXTreeList_save((FXTreeList const *)arg1,*arg2); return Qnil; }
static VALUE _wrap_FXTreeList_load(int argc, VALUE *argv, VALUE self) { FXTreeList *arg1 = (FXTreeList *) 0 ;
    FXStream *arg2 = 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTreeList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXTreeList_load(arg1,*arg2); return Qnil; }
static VALUE _wrap_FXTreeList_create(int argc, VALUE *argv, VALUE self) { FXTreeList *arg1 = (FXTreeList *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTreeList, 1); FXTreeList_create(arg1); return Qnil; }
static VALUE _wrap_FXTreeList_detach(int argc, VALUE *argv, VALUE self) { FXTreeList *arg1 = (FXTreeList *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTreeList, 1); FXTreeList_detach(arg1); return Qnil; }
static VALUE _wrap_FXTreeList_destroy(int argc, VALUE *argv, VALUE self) { FXTreeList *arg1 = (FXTreeList *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTreeList, 1); FXTreeList_destroy(arg1); return Qnil; }
static VALUE _wrap_FXTreeList_resize(int argc, VALUE *argv, VALUE self) { FXTreeList *arg1 = (FXTreeList *) 0 ; FXint arg2 ;
    FXint arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTreeList, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    FXTreeList_resize(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXTreeList_getDefaultWidth(int argc, VALUE *argv, VALUE self) { FXTreeList *arg1 = (FXTreeList *) 0 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTreeList, 1); result = (FXint)FXTreeList_getDefaultWidth(arg1);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTreeList_getDefaultHeight(int argc, VALUE *argv, VALUE self) { FXTreeList *arg1 = (FXTreeList *) 0 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTreeList, 1); result = (FXint)FXTreeList_getDefaultHeight(arg1);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTreeList_getWidthForHeight(int argc, VALUE *argv, VALUE self) { FXTreeList *arg1 = (FXTreeList *) 0 ;
    FXint arg2 ; FXint result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTreeList, 1); arg2 = NUM2INT(argv[0]);
    result = (FXint)FXTreeList_getWidthForHeight(arg1,arg2); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTreeList_getHeightForWidth(int argc, VALUE *argv, VALUE self) { FXTreeList *arg1 = (FXTreeList *) 0 ;
    FXint arg2 ; FXint result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTreeList, 1); arg2 = NUM2INT(argv[0]);
    result = (FXint)FXTreeList_getHeightForWidth(arg1,arg2); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTreeList_canFocus(int argc, VALUE *argv, VALUE self) { FXTreeList *arg1 = (FXTreeList *) 0 ; FXbool result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTreeList, 1);
    result = (FXbool)FXTreeList_canFocus((FXTreeList const *)arg1); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXTreeList_setFocus(int argc, VALUE *argv, VALUE self) { FXTreeList *arg1 = (FXTreeList *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTreeList, 1); FXTreeList_setFocus(arg1); return Qnil; }
static VALUE _wrap_FXTreeList_killFocus(int argc, VALUE *argv, VALUE self) { FXTreeList *arg1 = (FXTreeList *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTreeList, 1); FXTreeList_killFocus(arg1); return Qnil; }
static VALUE _wrap_FXTreeList_setDefault(int argc, VALUE *argv, VALUE self) { FXTreeList *arg1 = (FXTreeList *) 0 ;
    FXbool arg2 = (FXbool) 1 ; if ((argc < 0) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTreeList, 1); if (argc > 0) { arg2 = to_FXbool(argv[0]); } 
    FXTreeList_setDefault(arg1,arg2); return Qnil; }
static VALUE _wrap_FXTreeList_enable(int argc, VALUE *argv, VALUE self) { FXTreeList *arg1 = (FXTreeList *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTreeList, 1); FXTreeList_enable(arg1); return Qnil; }
static VALUE _wrap_FXTreeList_disable(int argc, VALUE *argv, VALUE self) { FXTreeList *arg1 = (FXTreeList *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTreeList, 1); FXTreeList_disable(arg1); return Qnil; }
static VALUE _wrap_FXTreeList_raiseWindow(int argc, VALUE *argv, VALUE self) { FXTreeList *arg1 = (FXTreeList *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTreeList, 1); FXTreeList_raise(arg1); return Qnil; }
static VALUE _wrap_FXTreeList_lower(int argc, VALUE *argv, VALUE self) { FXTreeList *arg1 = (FXTreeList *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTreeList, 1); FXTreeList_lower(arg1); return Qnil; }
static VALUE _wrap_FXTreeList_move(int argc, VALUE *argv, VALUE self) { FXTreeList *arg1 = (FXTreeList *) 0 ; FXint arg2 ;
    FXint arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTreeList, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    FXTreeList_move(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXTreeList_position__SWIG_0(int argc, VALUE *argv, VALUE self) { FXTreeList *arg1 = (FXTreeList *) 0 ;
    FXint arg2 ; FXint arg3 ; FXint arg4 ; FXint arg5 ; if ((argc < 4) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTreeList, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    arg4 = NUM2INT(argv[2]); arg5 = NUM2INT(argv[3]); FXTreeList_position(arg1,arg2,arg3,arg4,arg5); return Qnil; }
static VALUE _wrap_FXTreeList_layout(int argc, VALUE *argv, VALUE self) { FXTreeList *arg1 = (FXTreeList *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTreeList, 1); FXTreeList_layout(arg1); return Qnil; }
static VALUE _wrap_FXTreeList_recalc(int argc, VALUE *argv, VALUE self) { FXTreeList *arg1 = (FXTreeList *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTreeList, 1); FXTreeList_recalc(arg1); return Qnil; }
static VALUE _wrap_FXTreeList_reparent(int argc, VALUE *argv, VALUE self) { FXTreeList *arg1 = (FXTreeList *) 0 ;
    FXComposite *arg2 = (FXComposite *) 0 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTreeList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXComposite, 1); FXTreeList_reparent(arg1,arg2); return Qnil; }
static VALUE _wrap_FXTreeList_show(int argc, VALUE *argv, VALUE self) { FXTreeList *arg1 = (FXTreeList *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTreeList, 1); FXTreeList_show(arg1); return Qnil; }
static VALUE _wrap_FXTreeList_hide(int argc, VALUE *argv, VALUE self) { FXTreeList *arg1 = (FXTreeList *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTreeList, 1); FXTreeList_hide(arg1); return Qnil; }
static VALUE _wrap_FXTreeList_isComposite(int argc, VALUE *argv, VALUE self) { FXTreeList *arg1 = (FXTreeList *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTreeList, 1);
    result = (FXbool)FXTreeList_isComposite((FXTreeList const *)arg1); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXTreeList_contains(int argc, VALUE *argv, VALUE self) { FXTreeList *arg1 = (FXTreeList *) 0 ; FXint arg2 ;
    FXint arg3 ; FXbool result; VALUE vresult = Qnil; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTreeList, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    result = (FXbool)FXTreeList_contains((FXTreeList const *)arg1,arg2,arg3); vresult = result ? Qtrue : Qfalse;
    return vresult; }
static VALUE _wrap_FXTreeList_doesSaveUnder(int argc, VALUE *argv, VALUE self) { FXTreeList *arg1 = (FXTreeList *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTreeList, 1);
    result = (FXbool)FXTreeList_doesSaveUnder((FXTreeList const *)arg1); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXTreeList_setBackColor(int argc, VALUE *argv, VALUE self) { FXTreeList *arg1 = (FXTreeList *) 0 ;
    FXColor arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTreeList, 1); arg2 = to_FXColor(argv[0]);
    FXTreeList_setBackColor(arg1,arg2); return Qnil; }
static VALUE _wrap_FXTreeList_getViewportHeight(int argc, VALUE *argv, VALUE self) { FXTreeList *arg1 = (FXTreeList *) 0 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTreeList, 1); result = (FXint)FXTreeList_getViewportHeight(arg1);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTreeList_getViewportWidth(int argc, VALUE *argv, VALUE self) { FXTreeList *arg1 = (FXTreeList *) 0 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTreeList, 1); result = (FXint)FXTreeList_getViewportWidth(arg1);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTreeList_getContentHeight(int argc, VALUE *argv, VALUE self) { FXTreeList *arg1 = (FXTreeList *) 0 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTreeList, 1); result = (FXint)FXTreeList_getContentHeight(arg1);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTreeList_getContentWidth(int argc, VALUE *argv, VALUE self) { FXTreeList *arg1 = (FXTreeList *) 0 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTreeList, 1); result = (FXint)FXTreeList_getContentWidth(arg1);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTreeList_position__SWIG_1(int argc, VALUE *argv, VALUE self) { FXTreeList *arg1 = (FXTreeList *) 0 ;
    VALUE result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTreeList, 1);
    result = (VALUE)FXTreeList_position__SWIG_1((FXTreeList const *)arg1); vresult = result; return vresult; }
static VALUE _wrap_FXTreeList_position(int nargs, VALUE *args, VALUE self) { int argc; VALUE argv[6]; int ii; argc = nargs + 1;
    argv[0] = self; for (ii = 1; (ii < argc) && (ii < 5); ii++) { argv[ii] = args[ii-1]; }  if (argc == 1) { int _v; {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXTreeList, 0) != -1)) ? 1 : 0; }
         if (_v) { return _wrap_FXTreeList_position__SWIG_1(nargs, args, self);}  }  if (argc == 5) { int _v; { void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXTreeList, 0) != -1)) ? 1 : 0; }
         if (_v) { { _v = ((TYPE(argv[1]) == T_FIXNUM) || (TYPE(argv[1]) == T_BIGNUM)) ? 1 : 0; }  if (_v) { {
                    _v = ((TYPE(argv[2]) == T_FIXNUM) || (TYPE(argv[2]) == T_BIGNUM)) ? 1 : 0; }  if (_v) { {
                        _v = ((TYPE(argv[3]) == T_FIXNUM) || (TYPE(argv[3]) == T_BIGNUM)) ? 1 : 0; }  if (_v) { {
                            _v = ((TYPE(argv[4]) == T_FIXNUM) || (TYPE(argv[4]) == T_BIGNUM)) ? 1 : 0; }  if (_v) {
                            return _wrap_FXTreeList_position__SWIG_0(nargs, args, self);}  }  }  }  }  } 
    rb_raise(rb_eArgError, "No matching function for overloaded 'FXTreeList_position'"); return Qnil; }
static VALUE _wrap_FXTreeList_selectItem(int argc, VALUE *argv, VALUE self) { FXTreeList *arg1 = (FXTreeList *) 0 ;
    FXTreeItem *arg2 = (FXTreeItem *) 0 ; FXbool arg3 = (FXbool) 0 ; FXbool result; VALUE vresult = Qnil;
    if ((argc < 1) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTreeList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXTreeItem, 1); if (argc > 1) { arg3 = to_FXbool(argv[1]); } 
    result = (FXbool)FXTreeList_selectItem(arg1,arg2,arg3); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXTreeList_deselectItem(int argc, VALUE *argv, VALUE self) { FXTreeList *arg1 = (FXTreeList *) 0 ;
    FXTreeItem *arg2 = (FXTreeItem *) 0 ; FXbool arg3 = (FXbool) 0 ; FXbool result; VALUE vresult = Qnil;
    if ((argc < 1) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTreeList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXTreeItem, 1); if (argc > 1) { arg3 = to_FXbool(argv[1]); } 
    result = (FXbool)FXTreeList_deselectItem(arg1,arg2,arg3); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXTreeList_toggleItem(int argc, VALUE *argv, VALUE self) { FXTreeList *arg1 = (FXTreeList *) 0 ;
    FXTreeItem *arg2 = (FXTreeItem *) 0 ; FXbool arg3 = (FXbool) 0 ; FXbool result; VALUE vresult = Qnil;
    if ((argc < 1) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTreeList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXTreeItem, 1); if (argc > 1) { arg3 = to_FXbool(argv[1]); } 
    result = (FXbool)FXTreeList_toggleItem(arg1,arg2,arg3); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXTreeList_extendSelection(int argc, VALUE *argv, VALUE self) { FXTreeList *arg1 = (FXTreeList *) 0 ;
    FXTreeItem *arg2 = (FXTreeItem *) 0 ; FXbool arg3 = (FXbool) 0 ; FXbool result; VALUE vresult = Qnil;
    if ((argc < 1) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTreeList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXTreeItem, 1); if (argc > 1) { arg3 = to_FXbool(argv[1]); } 
    result = (FXbool)FXTreeList_extendSelection(arg1,arg2,arg3); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXTreeList_killSelection(int argc, VALUE *argv, VALUE self) { FXTreeList *arg1 = (FXTreeList *) 0 ;
    FXbool arg2 = (FXbool) 0 ; FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTreeList, 1); if (argc > 0) { arg2 = to_FXbool(argv[0]); } 
    result = (FXbool)FXTreeList_killSelection(arg1,arg2); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXTreeList_openItem(int argc, VALUE *argv, VALUE self) { FXTreeList *arg1 = (FXTreeList *) 0 ;
    FXTreeItem *arg2 = (FXTreeItem *) 0 ; FXbool arg3 = (FXbool) 0 ; FXbool result; VALUE vresult = Qnil;
    if ((argc < 1) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTreeList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXTreeItem, 1); if (argc > 1) { arg3 = to_FXbool(argv[1]); } 
    result = (FXbool)FXTreeList_openItem(arg1,arg2,arg3); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXTreeList_closeItem(int argc, VALUE *argv, VALUE self) { FXTreeList *arg1 = (FXTreeList *) 0 ;
    FXTreeItem *arg2 = (FXTreeItem *) 0 ; FXbool arg3 = (FXbool) 0 ; FXbool result; VALUE vresult = Qnil;
    if ((argc < 1) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTreeList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXTreeItem, 1); if (argc > 1) { arg3 = to_FXbool(argv[1]); } 
    result = (FXbool)FXTreeList_closeItem(arg1,arg2,arg3); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXTreeList_collapseTree(int argc, VALUE *argv, VALUE self) { FXTreeList *arg1 = (FXTreeList *) 0 ;
    FXTreeItem *arg2 = (FXTreeItem *) 0 ; FXbool arg3 = (FXbool) 0 ; FXbool result; VALUE vresult = Qnil;
    if ((argc < 1) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTreeList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXTreeItem, 1); if (argc > 1) { arg3 = to_FXbool(argv[1]); } 
    result = (FXbool)FXTreeList_collapseTree(arg1,arg2,arg3); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXTreeList_expandTree(int argc, VALUE *argv, VALUE self) { FXTreeList *arg1 = (FXTreeList *) 0 ;
    FXTreeItem *arg2 = (FXTreeItem *) 0 ; FXbool arg3 = (FXbool) 0 ; FXbool result; VALUE vresult = Qnil;
    if ((argc < 1) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTreeList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXTreeItem, 1); if (argc > 1) { arg3 = to_FXbool(argv[1]); } 
    result = (FXbool)FXTreeList_expandTree(arg1,arg2,arg3); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXTreeList_setCurrentItem(int argc, VALUE *argv, VALUE self) { FXTreeList *arg1 = (FXTreeList *) 0 ;
    FXTreeItem *arg2 = (FXTreeItem *) 0 ; FXbool arg3 = (FXbool) 0 ; if ((argc < 1) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTreeList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXTreeItem, 1); if (argc > 1) { arg3 = to_FXbool(argv[1]); } 
    FXTreeList_setCurrentItem(arg1,arg2,arg3); return Qnil; }
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE _wrap_FXDirItem_allocate(VALUE self) {
#else
     static VALUE _wrap_FXDirItem_allocate(int argc, VALUE *argv, VALUE self) {
#endif
         VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_FXDirItem);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
         return vresult; }
static VALUE _wrap_new_FXDirItem(int argc, VALUE *argv, VALUE self) { FXString *arg1 = 0 ; FXIcon *arg2 = (FXIcon *) 0 ;
    FXIcon *arg3 = (FXIcon *) 0 ; void *arg4 = (void *) 0 ; FXDirItem *result; SwigValueWrapper<FXString > p1 ;
    if ((argc < 1) || (argc > 4)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    p1 = to_FXString(argv[0]); arg1 = &p1; if (argc > 1) { SWIG_ConvertPtr(argv[1], (void **) &arg2, SWIGTYPE_p_FXIcon, 1); } 
    if (argc > 2) { SWIG_ConvertPtr(argv[2], (void **) &arg3, SWIGTYPE_p_FXIcon, 1); }  if (argc > 3) {
        SWIG_ConvertPtr(argv[3], (void **) &arg4, 0, 1); }  {
        result = (FXDirItem *)new_FXDirItem((FXString const &)*arg1,arg2,arg3,arg4);
        DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result); if(rb_block_given_p()){ rb_yield(self); }  }  return self; }
static VALUE _wrap_FXDirItem_isFile(int argc, VALUE *argv, VALUE self) { FXDirItem *arg1 = (FXDirItem *) 0 ; FXbool result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDirItem, 1); result = (FXbool)((FXDirItem const *)arg1)->isFile();
    vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXDirItem_isDirectory(int argc, VALUE *argv, VALUE self) { FXDirItem *arg1 = (FXDirItem *) 0 ; FXbool result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDirItem, 1); result = (FXbool)((FXDirItem const *)arg1)->isDirectory();
    vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXDirItem_isExecutable(int argc, VALUE *argv, VALUE self) { FXDirItem *arg1 = (FXDirItem *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDirItem, 1); result = (FXbool)((FXDirItem const *)arg1)->isExecutable();
    vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXDirItem_isSymlink(int argc, VALUE *argv, VALUE self) { FXDirItem *arg1 = (FXDirItem *) 0 ; FXbool result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDirItem, 1); result = (FXbool)((FXDirItem const *)arg1)->isSymlink();
    vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXDirItem_isChardev(int argc, VALUE *argv, VALUE self) { FXDirItem *arg1 = (FXDirItem *) 0 ; FXbool result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDirItem, 1); result = (FXbool)((FXDirItem const *)arg1)->isChardev();
    vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXDirItem_isBlockdev(int argc, VALUE *argv, VALUE self) { FXDirItem *arg1 = (FXDirItem *) 0 ; FXbool result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDirItem, 1); result = (FXbool)((FXDirItem const *)arg1)->isBlockdev();
    vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXDirItem_isFifo(int argc, VALUE *argv, VALUE self) { FXDirItem *arg1 = (FXDirItem *) 0 ; FXbool result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDirItem, 1); result = (FXbool)((FXDirItem const *)arg1)->isFifo();
    vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXDirItem_isSocket(int argc, VALUE *argv, VALUE self) { FXDirItem *arg1 = (FXDirItem *) 0 ; FXbool result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDirItem, 1); result = (FXbool)((FXDirItem const *)arg1)->isSocket();
    vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXDirItem_getAssoc(int argc, VALUE *argv, VALUE self) { FXDirItem *arg1 = (FXDirItem *) 0 ;
    FXFileAssoc *result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDirItem, 1);
    result = (FXFileAssoc *)((FXDirItem const *)arg1)->getAssoc(); vresult = FXRbGetRubyObj(result, "FXFileAssoc *");
    return vresult; }
static VALUE _wrap_FXDirItem_getSize(int argc, VALUE *argv, VALUE self) { FXDirItem *arg1 = (FXDirItem *) 0 ;
    unsigned long result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDirItem, 1);
    result = (unsigned long)((FXDirItem const *)arg1)->getSize(); vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXDirItem_getDate(int argc, VALUE *argv, VALUE self) { FXDirItem *arg1 = (FXDirItem *) 0 ; FXTime result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDirItem, 1); result = (FXTime)((FXDirItem const *)arg1)->getDate();
    vresult = INT2NUM(result); return vresult; }
static void
free_FXDirItem(FXDirItem *arg1) {
    delete arg1;
}
static VALUE _wrap_FXDirItem_save(int argc, VALUE *argv, VALUE self) { FXDirItem *arg1 = (FXDirItem *) 0 ; FXStream *arg2 = 0 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDirItem, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXDirItem_save((FXDirItem const *)arg1,*arg2); return Qnil; }
static VALUE _wrap_FXDirItem_load(int argc, VALUE *argv, VALUE self) { FXDirItem *arg1 = (FXDirItem *) 0 ; FXStream *arg2 = 0 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDirItem, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXDirItem_load(arg1,*arg2); return Qnil; }
static VALUE _wrap_FXDirItem_setText(int argc, VALUE *argv, VALUE self) { FXDirItem *arg1 = (FXDirItem *) 0 ;
    FXString *arg2 = 0 ; SwigValueWrapper<FXString > p2 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDirItem, 1); p2 = to_FXString(argv[0]); arg2 = &p2;
    FXDirItem_setText(arg1,(FXString const &)*arg2); return Qnil; }
static VALUE _wrap_FXDirItem_setOpenIcon(int argc, VALUE *argv, VALUE self) { FXDirItem *arg1 = (FXDirItem *) 0 ;
    FXIcon *arg2 = (FXIcon *) 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDirItem, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXIcon, 1); FXDirItem_setOpenIcon(arg1,arg2); return Qnil; }
static VALUE _wrap_FXDirItem_setClosedIcon(int argc, VALUE *argv, VALUE self) { FXDirItem *arg1 = (FXDirItem *) 0 ;
    FXIcon *arg2 = (FXIcon *) 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDirItem, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXIcon, 1); FXDirItem_setClosedIcon(arg1,arg2); return Qnil; }
static VALUE _wrap_FXDirItem_setFocus(int argc, VALUE *argv, VALUE self) { FXDirItem *arg1 = (FXDirItem *) 0 ; FXbool arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDirItem, 1); arg2 = to_FXbool(argv[0]); FXDirItem_setFocus(arg1,arg2);
    return Qnil; }
static VALUE _wrap_FXDirItem_setSelected(int argc, VALUE *argv, VALUE self) { FXDirItem *arg1 = (FXDirItem *) 0 ; FXbool arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDirItem, 1); arg2 = to_FXbool(argv[0]);
    FXDirItem_setSelected(arg1,arg2); return Qnil; }
static VALUE _wrap_FXDirItem_setOpened(int argc, VALUE *argv, VALUE self) { FXDirItem *arg1 = (FXDirItem *) 0 ; FXbool arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDirItem, 1); arg2 = to_FXbool(argv[0]); FXDirItem_setOpened(arg1,arg2);
    return Qnil; }
static VALUE _wrap_FXDirItem_setExpanded(int argc, VALUE *argv, VALUE self) { FXDirItem *arg1 = (FXDirItem *) 0 ; FXbool arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDirItem, 1); arg2 = to_FXbool(argv[0]);
    FXDirItem_setExpanded(arg1,arg2); return Qnil; }
static VALUE _wrap_FXDirItem_setEnabled(int argc, VALUE *argv, VALUE self) { FXDirItem *arg1 = (FXDirItem *) 0 ; FXbool arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDirItem, 1); arg2 = to_FXbool(argv[0]); FXDirItem_setEnabled(arg1,arg2);
    return Qnil; }
static VALUE _wrap_FXDirItem_setDraggable(int argc, VALUE *argv, VALUE self) { FXDirItem *arg1 = (FXDirItem *) 0 ; FXbool arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDirItem, 1); arg2 = to_FXbool(argv[0]);
    FXDirItem_setDraggable(arg1,arg2); return Qnil; }
static VALUE _wrap_FXDirItem_getWidth(int argc, VALUE *argv, VALUE self) { FXDirItem *arg1 = (FXDirItem *) 0 ;
    FXTreeList *arg2 = (FXTreeList *) 0 ; FXint result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDirItem, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXTreeList, 1);
    result = (FXint)FXDirItem_getWidth((FXDirItem const *)arg1,(FXTreeList const *)arg2); vresult = INT2NUM(result);
    return vresult; }
static VALUE _wrap_FXDirItem_getHeight(int argc, VALUE *argv, VALUE self) { FXDirItem *arg1 = (FXDirItem *) 0 ;
    FXTreeList *arg2 = (FXTreeList *) 0 ; FXint result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDirItem, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXTreeList, 1);
    result = (FXint)FXDirItem_getHeight((FXDirItem const *)arg1,(FXTreeList const *)arg2); vresult = INT2NUM(result);
    return vresult; }
static VALUE _wrap_FXDirItem_create(int argc, VALUE *argv, VALUE self) { FXDirItem *arg1 = (FXDirItem *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDirItem, 1); FXDirItem_create(arg1); return Qnil; }
static VALUE _wrap_FXDirItem_detach(int argc, VALUE *argv, VALUE self) { FXDirItem *arg1 = (FXDirItem *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDirItem, 1); FXDirItem_detach(arg1); return Qnil; }
static VALUE _wrap_FXDirItem_destroy(int argc, VALUE *argv, VALUE self) { FXDirItem *arg1 = (FXDirItem *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDirItem, 1); FXDirItem_destroy(arg1); return Qnil; }
static VALUE _wrap_FXDirList_onRefreshTimer(int argc, VALUE *argv, VALUE self) { FXDirList *arg1 = (FXDirList *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDirList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onRefreshTimer(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXDirList_onBeginDrag(int argc, VALUE *argv, VALUE self) { FXDirList *arg1 = (FXDirList *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDirList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onBeginDrag(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXDirList_onEndDrag(int argc, VALUE *argv, VALUE self) { FXDirList *arg1 = (FXDirList *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDirList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onEndDrag(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXDirList_onDragged(int argc, VALUE *argv, VALUE self) { FXDirList *arg1 = (FXDirList *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDirList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onDragged(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXDirList_onDNDEnter(int argc, VALUE *argv, VALUE self) { FXDirList *arg1 = (FXDirList *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDirList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onDNDEnter(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXDirList_onDNDLeave(int argc, VALUE *argv, VALUE self) { FXDirList *arg1 = (FXDirList *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDirList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onDNDLeave(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXDirList_onDNDMotion(int argc, VALUE *argv, VALUE self) { FXDirList *arg1 = (FXDirList *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDirList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onDNDMotion(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXDirList_onDNDDrop(int argc, VALUE *argv, VALUE self) { FXDirList *arg1 = (FXDirList *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDirList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onDNDDrop(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXDirList_onDNDRequest(int argc, VALUE *argv, VALUE self) { FXDirList *arg1 = (FXDirList *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDirList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onDNDRequest(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXDirList_onCmdSetValue(int argc, VALUE *argv, VALUE self) { FXDirList *arg1 = (FXDirList *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDirList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]);
    arg4 = static_cast<void*>(STR2CSTR(argv[2])); result = (long)(arg1)->onCmdSetValue(arg2,arg3,arg4);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXDirList_onCmdSetStringValue(int argc, VALUE *argv, VALUE self) { FXDirList *arg1 = (FXDirList *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; FXString value4 ;
    VALUE vresult = Qnil; if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDirList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); {
        value4 = FXString(STR2CSTR(argv[2])); arg4 = (void *) &value4; } 
    result = (long)(arg1)->onCmdSetStringValue(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXDirList_onCmdGetStringValue(int argc, VALUE *argv, VALUE self) { FXDirList *arg1 = (FXDirList *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDirList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdGetStringValue(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXDirList_onCmdToggleHidden(int argc, VALUE *argv, VALUE self) { FXDirList *arg1 = (FXDirList *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDirList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdToggleHidden(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXDirList_onUpdToggleHidden(int argc, VALUE *argv, VALUE self) { FXDirList *arg1 = (FXDirList *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDirList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onUpdToggleHidden(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXDirList_onCmdShowHidden(int argc, VALUE *argv, VALUE self) { FXDirList *arg1 = (FXDirList *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDirList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdShowHidden(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXDirList_onUpdShowHidden(int argc, VALUE *argv, VALUE self) { FXDirList *arg1 = (FXDirList *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDirList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onUpdShowHidden(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXDirList_onCmdHideHidden(int argc, VALUE *argv, VALUE self) { FXDirList *arg1 = (FXDirList *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDirList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdHideHidden(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXDirList_onUpdHideHidden(int argc, VALUE *argv, VALUE self) { FXDirList *arg1 = (FXDirList *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDirList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onUpdHideHidden(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXDirList_onCmdToggleFiles(int argc, VALUE *argv, VALUE self) { FXDirList *arg1 = (FXDirList *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDirList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdToggleFiles(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXDirList_onUpdToggleFiles(int argc, VALUE *argv, VALUE self) { FXDirList *arg1 = (FXDirList *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDirList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onUpdToggleFiles(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXDirList_onCmdShowFiles(int argc, VALUE *argv, VALUE self) { FXDirList *arg1 = (FXDirList *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDirList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdShowFiles(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXDirList_onUpdShowFiles(int argc, VALUE *argv, VALUE self) { FXDirList *arg1 = (FXDirList *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDirList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onUpdShowFiles(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXDirList_onCmdHideFiles(int argc, VALUE *argv, VALUE self) { FXDirList *arg1 = (FXDirList *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDirList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdHideFiles(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXDirList_onUpdHideFiles(int argc, VALUE *argv, VALUE self) { FXDirList *arg1 = (FXDirList *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDirList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onUpdHideFiles(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXDirList_onCmdSetPattern(int argc, VALUE *argv, VALUE self) { FXDirList *arg1 = (FXDirList *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDirList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]);
    arg4 = static_cast<void*>(STR2CSTR(argv[2])); result = (long)(arg1)->onCmdSetPattern(arg2,arg3,arg4);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXDirList_onUpdSetPattern(int argc, VALUE *argv, VALUE self) { FXDirList *arg1 = (FXDirList *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDirList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onUpdSetPattern(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXDirList_onCmdSortReverse(int argc, VALUE *argv, VALUE self) { FXDirList *arg1 = (FXDirList *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDirList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdSortReverse(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXDirList_onUpdSortReverse(int argc, VALUE *argv, VALUE self) { FXDirList *arg1 = (FXDirList *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDirList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onUpdSortReverse(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXDirList_onCmdSortCase(int argc, VALUE *argv, VALUE self) { FXDirList *arg1 = (FXDirList *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDirList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdSortCase(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXDirList_onUpdSortCase(int argc, VALUE *argv, VALUE self) { FXDirList *arg1 = (FXDirList *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDirList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onUpdSortCase(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXDirList_onCmdRefresh(int argc, VALUE *argv, VALUE self) { FXDirList *arg1 = (FXDirList *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDirList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdRefresh(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXDirList_ascending(int argc, VALUE *argv, VALUE self) { FXTreeItem *arg1 = (FXTreeItem *) 0 ;
    FXTreeItem *arg2 = (FXTreeItem *) 0 ; FXint result; VALUE vresult = Qnil; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXTreeItem, 1);
    SWIG_ConvertPtr(argv[1], (void **) &arg2, SWIGTYPE_p_FXTreeItem, 1);
    result = (FXint)FXDirList::ascending((FXTreeItem const *)arg1,(FXTreeItem const *)arg2); vresult = INT2NUM(result);
    return vresult; }
static VALUE _wrap_FXDirList_descending(int argc, VALUE *argv, VALUE self) { FXTreeItem *arg1 = (FXTreeItem *) 0 ;
    FXTreeItem *arg2 = (FXTreeItem *) 0 ; FXint result; VALUE vresult = Qnil; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXTreeItem, 1);
    SWIG_ConvertPtr(argv[1], (void **) &arg2, SWIGTYPE_p_FXTreeItem, 1);
    result = (FXint)FXDirList::descending((FXTreeItem const *)arg1,(FXTreeItem const *)arg2); vresult = INT2NUM(result);
    return vresult; }
static VALUE _wrap_FXDirList_ascendingCase(int argc, VALUE *argv, VALUE self) { FXTreeItem *arg1 = (FXTreeItem *) 0 ;
    FXTreeItem *arg2 = (FXTreeItem *) 0 ; FXint result; VALUE vresult = Qnil; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXTreeItem, 1);
    SWIG_ConvertPtr(argv[1], (void **) &arg2, SWIGTYPE_p_FXTreeItem, 1);
    result = (FXint)FXDirList::ascendingCase((FXTreeItem const *)arg1,(FXTreeItem const *)arg2); vresult = INT2NUM(result);
    return vresult; }
static VALUE _wrap_FXDirList_descendingCase(int argc, VALUE *argv, VALUE self) { FXTreeItem *arg1 = (FXTreeItem *) 0 ;
    FXTreeItem *arg2 = (FXTreeItem *) 0 ; FXint result; VALUE vresult = Qnil; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXTreeItem, 1);
    SWIG_ConvertPtr(argv[1], (void **) &arg2, SWIGTYPE_p_FXTreeItem, 1);
    result = (FXint)FXDirList::descendingCase((FXTreeItem const *)arg1,(FXTreeItem const *)arg2); vresult = INT2NUM(result);
    return vresult; }
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE _wrap_FXDirList_allocate(VALUE self) {
#else
     static VALUE _wrap_FXDirList_allocate(int argc, VALUE *argv, VALUE self) {
#endif
         VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_FXDirList);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
         return vresult; }
static VALUE _wrap_new_FXDirList(int argc, VALUE *argv, VALUE self) { FXComposite *arg1 = (FXComposite *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 = (FXSelector) 0 ; FXuint arg4 = (FXuint) 0 ; FXint arg5 = (FXint) 0 ;
    FXint arg6 = (FXint) 0 ; FXint arg7 = (FXint) 0 ; FXint arg8 = (FXint) 0 ; FXDirList *result; if ((argc < 1) || (argc > 8))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXComposite, 1); if (argc > 1) {
        SWIG_ConvertPtr(argv[1], (void **) &arg2, SWIGTYPE_p_FXObject, 1); }  if (argc > 2) { arg3 = NUM2UINT(argv[2]); } 
    if (argc > 3) { arg4 = NUM2UINT(argv[3]); }  if (argc > 4) { arg5 = NUM2INT(argv[4]); }  if (argc > 5) {
        arg6 = NUM2INT(argv[5]); }  if (argc > 6) { arg7 = NUM2INT(argv[6]); }  if (argc > 7) { arg8 = NUM2INT(argv[7]); }  {
        result = (FXDirList *)new_FXDirList(arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8);
        DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result); if(rb_block_given_p()){ rb_yield(self); }  }  return self; }
static VALUE _wrap_FXDirList_scan(int argc, VALUE *argv, VALUE self) { FXDirList *arg1 = (FXDirList *) 0 ;
    FXbool arg2 = (FXbool) 1 ; if ((argc < 0) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDirList, 1); if (argc > 0) { arg2 = to_FXbool(argv[0]); } 
    (arg1)->scan(arg2); return Qnil; }
static VALUE _wrap_FXDirList_isItemDirectory(int argc, VALUE *argv, VALUE self) { FXDirList *arg1 = (FXDirList *) 0 ;
    FXTreeItem *arg2 = (FXTreeItem *) 0 ; FXbool result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDirList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXTreeItem, 1);
    result = (FXbool)((FXDirList const *)arg1)->isItemDirectory((FXTreeItem const *)arg2); vresult = result ? Qtrue : Qfalse;
    return vresult; }
static VALUE _wrap_FXDirList_isItemFile(int argc, VALUE *argv, VALUE self) { FXDirList *arg1 = (FXDirList *) 0 ;
    FXTreeItem *arg2 = (FXTreeItem *) 0 ; FXbool result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDirList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXTreeItem, 1);
    result = (FXbool)((FXDirList const *)arg1)->isItemFile((FXTreeItem const *)arg2); vresult = result ? Qtrue : Qfalse;
    return vresult; }
static VALUE _wrap_FXDirList_isItemExecutable(int argc, VALUE *argv, VALUE self) { FXDirList *arg1 = (FXDirList *) 0 ;
    FXTreeItem *arg2 = (FXTreeItem *) 0 ; FXbool result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDirList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXTreeItem, 1);
    result = (FXbool)((FXDirList const *)arg1)->isItemExecutable((FXTreeItem const *)arg2); vresult = result ? Qtrue : Qfalse;
    return vresult; }
static VALUE _wrap_FXDirList_setCurrentFile(int argc, VALUE *argv, VALUE self) { FXDirList *arg1 = (FXDirList *) 0 ;
    FXString *arg2 = 0 ; FXbool arg3 = (FXbool) 0 ; SwigValueWrapper<FXString > p2 ; if ((argc < 1) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDirList, 1); p2 = to_FXString(argv[0]); arg2 = &p2; if (argc > 1) {
        arg3 = to_FXbool(argv[1]); }  (arg1)->setCurrentFile((FXString const &)*arg2,arg3); return Qnil; }
static VALUE _wrap_FXDirList_getCurrentFile(int argc, VALUE *argv, VALUE self) { FXDirList *arg1 = (FXDirList *) 0 ;
    FXString result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDirList, 1); result = ((FXDirList const *)arg1)->getCurrentFile();
    vresult = rb_str_new2((&result)->text()); return vresult; }
static VALUE _wrap_FXDirList_setDirectory(int argc, VALUE *argv, VALUE self) { FXDirList *arg1 = (FXDirList *) 0 ;
    FXString *arg2 = 0 ; FXbool arg3 = (FXbool) 0 ; SwigValueWrapper<FXString > p2 ; if ((argc < 1) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDirList, 1); p2 = to_FXString(argv[0]); arg2 = &p2; if (argc > 1) {
        arg3 = to_FXbool(argv[1]); }  (arg1)->setDirectory((FXString const &)*arg2,arg3); return Qnil; }
static VALUE _wrap_FXDirList_getDirectory(int argc, VALUE *argv, VALUE self) { FXDirList *arg1 = (FXDirList *) 0 ;
    FXString result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDirList, 1); result = ((FXDirList const *)arg1)->getDirectory();
    vresult = rb_str_new2((&result)->text()); return vresult; }
static VALUE _wrap_FXDirList_getItemPathname(int argc, VALUE *argv, VALUE self) { FXDirList *arg1 = (FXDirList *) 0 ;
    FXTreeItem *arg2 = (FXTreeItem *) 0 ; FXString result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDirList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXTreeItem, 1);
    result = ((FXDirList const *)arg1)->getItemPathname((FXTreeItem const *)arg2); vresult = rb_str_new2((&result)->text());
    return vresult; }
static VALUE _wrap_FXDirList_getPathnameItem(int argc, VALUE *argv, VALUE self) { FXDirList *arg1 = (FXDirList *) 0 ;
    FXString *arg2 = 0 ; FXTreeItem *result; SwigValueWrapper<FXString > p2 ; VALUE vresult = Qnil;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDirList, 1); p2 = to_FXString(argv[0]); arg2 = &p2;
    result = (FXTreeItem *)(arg1)->getPathnameItem((FXString const &)*arg2); {
        swig_type_info *ty = SWIG_TypeDynamicCast(SWIGTYPE_p_FXTreeItem, (void **) &result);
        vresult = FXRbGetRubyObj(result, ty); }  return vresult; }
static VALUE _wrap_FXDirList_setPattern(int argc, VALUE *argv, VALUE self) { FXDirList *arg1 = (FXDirList *) 0 ;
    FXString *arg2 = 0 ; SwigValueWrapper<FXString > p2 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDirList, 1); p2 = to_FXString(argv[0]); arg2 = &p2;
    (arg1)->setPattern((FXString const &)*arg2); return Qnil; }
static VALUE _wrap_FXDirList_getPattern(int argc, VALUE *argv, VALUE self) { FXDirList *arg1 = (FXDirList *) 0 ;
    FXString result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDirList, 1); result = ((FXDirList const *)arg1)->getPattern();
    vresult = rb_str_new2((&result)->text()); return vresult; }
static VALUE _wrap_FXDirList_getMatchMode(int argc, VALUE *argv, VALUE self) { FXDirList *arg1 = (FXDirList *) 0 ;
    FXuint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDirList, 1); result = (FXuint)((FXDirList const *)arg1)->getMatchMode();
    vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXDirList_setMatchMode(int argc, VALUE *argv, VALUE self) { FXDirList *arg1 = (FXDirList *) 0 ; FXuint arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDirList, 1); arg2 = NUM2UINT(argv[0]); (arg1)->setMatchMode(arg2);
    return Qnil; }
static VALUE _wrap_FXDirList_getShowFiles(int argc, VALUE *argv, VALUE self) { FXDirList *arg1 = (FXDirList *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDirList, 1); result = (FXbool)((FXDirList const *)arg1)->showFiles();
    vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXDirList_setShowFiles(int argc, VALUE *argv, VALUE self) { FXDirList *arg1 = (FXDirList *) 0 ; FXbool arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDirList, 1); arg2 = to_FXbool(argv[0]); (arg1)->showFiles(arg2);
    return Qnil; }
static VALUE _wrap_FXDirList_getShowHiddenFiles(int argc, VALUE *argv, VALUE self) { FXDirList *arg1 = (FXDirList *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDirList, 1);
    result = (FXbool)((FXDirList const *)arg1)->showHiddenFiles(); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXDirList_setShowHiddenFiles(int argc, VALUE *argv, VALUE self) { FXDirList *arg1 = (FXDirList *) 0 ;
    FXbool arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDirList, 1); arg2 = to_FXbool(argv[0]); (arg1)->showHiddenFiles(arg2);
    return Qnil; }
static VALUE _wrap_FXDirList_setAssociations(int argc, VALUE *argv, VALUE self) { FXDirList *arg1 = (FXDirList *) 0 ;
    FXFileDict *arg2 = (FXFileDict *) 0 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDirList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXFileDict, 1); (arg1)->setAssociations(arg2); return Qnil; }
static VALUE _wrap_FXDirList_getAssociations(int argc, VALUE *argv, VALUE self) { FXDirList *arg1 = (FXDirList *) 0 ;
    FXFileDict *result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDirList, 1);
    result = (FXFileDict *)((FXDirList const *)arg1)->getAssociations(); {
        swig_type_info *ty = SWIG_TypeDynamicCast(SWIGTYPE_p_FXFileDict, (void **) &result);
        vresult = FXRbGetRubyObj(result, ty); }  return vresult; }
static void
free_FXDirList(FXDirList *arg1) {
    delete arg1;
}
static VALUE _wrap_FXDirList_save(int argc, VALUE *argv, VALUE self) { FXDirList *arg1 = (FXDirList *) 0 ; FXStream *arg2 = 0 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDirList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXDirList_save((FXDirList const *)arg1,*arg2); return Qnil; }
static VALUE _wrap_FXDirList_load(int argc, VALUE *argv, VALUE self) { FXDirList *arg1 = (FXDirList *) 0 ; FXStream *arg2 = 0 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDirList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXDirList_load(arg1,*arg2); return Qnil; }
static VALUE _wrap_FXDirList_create(int argc, VALUE *argv, VALUE self) { FXDirList *arg1 = (FXDirList *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDirList, 1); FXDirList_create(arg1); return Qnil; }
static VALUE _wrap_FXDirList_detach(int argc, VALUE *argv, VALUE self) { FXDirList *arg1 = (FXDirList *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDirList, 1); FXDirList_detach(arg1); return Qnil; }
static VALUE _wrap_FXDirList_destroy(int argc, VALUE *argv, VALUE self) { FXDirList *arg1 = (FXDirList *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDirList, 1); FXDirList_destroy(arg1); return Qnil; }
static VALUE _wrap_FXDirList_resize(int argc, VALUE *argv, VALUE self) { FXDirList *arg1 = (FXDirList *) 0 ; FXint arg2 ;
    FXint arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDirList, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    FXDirList_resize(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXDirList_getDefaultWidth(int argc, VALUE *argv, VALUE self) { FXDirList *arg1 = (FXDirList *) 0 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDirList, 1); result = (FXint)FXDirList_getDefaultWidth(arg1);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXDirList_getDefaultHeight(int argc, VALUE *argv, VALUE self) { FXDirList *arg1 = (FXDirList *) 0 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDirList, 1); result = (FXint)FXDirList_getDefaultHeight(arg1);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXDirList_getWidthForHeight(int argc, VALUE *argv, VALUE self) { FXDirList *arg1 = (FXDirList *) 0 ;
    FXint arg2 ; FXint result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDirList, 1); arg2 = NUM2INT(argv[0]);
    result = (FXint)FXDirList_getWidthForHeight(arg1,arg2); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXDirList_getHeightForWidth(int argc, VALUE *argv, VALUE self) { FXDirList *arg1 = (FXDirList *) 0 ;
    FXint arg2 ; FXint result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDirList, 1); arg2 = NUM2INT(argv[0]);
    result = (FXint)FXDirList_getHeightForWidth(arg1,arg2); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXDirList_canFocus(int argc, VALUE *argv, VALUE self) { FXDirList *arg1 = (FXDirList *) 0 ; FXbool result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDirList, 1);
    result = (FXbool)FXDirList_canFocus((FXDirList const *)arg1); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXDirList_setFocus(int argc, VALUE *argv, VALUE self) { FXDirList *arg1 = (FXDirList *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDirList, 1); FXDirList_setFocus(arg1); return Qnil; }
static VALUE _wrap_FXDirList_killFocus(int argc, VALUE *argv, VALUE self) { FXDirList *arg1 = (FXDirList *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDirList, 1); FXDirList_killFocus(arg1); return Qnil; }
static VALUE _wrap_FXDirList_setDefault(int argc, VALUE *argv, VALUE self) { FXDirList *arg1 = (FXDirList *) 0 ;
    FXbool arg2 = (FXbool) 1 ; if ((argc < 0) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDirList, 1); if (argc > 0) { arg2 = to_FXbool(argv[0]); } 
    FXDirList_setDefault(arg1,arg2); return Qnil; }
static VALUE _wrap_FXDirList_enable(int argc, VALUE *argv, VALUE self) { FXDirList *arg1 = (FXDirList *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDirList, 1); FXDirList_enable(arg1); return Qnil; }
static VALUE _wrap_FXDirList_disable(int argc, VALUE *argv, VALUE self) { FXDirList *arg1 = (FXDirList *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDirList, 1); FXDirList_disable(arg1); return Qnil; }
static VALUE _wrap_FXDirList_raiseWindow(int argc, VALUE *argv, VALUE self) { FXDirList *arg1 = (FXDirList *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDirList, 1); FXDirList_raise(arg1); return Qnil; }
static VALUE _wrap_FXDirList_lower(int argc, VALUE *argv, VALUE self) { FXDirList *arg1 = (FXDirList *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDirList, 1); FXDirList_lower(arg1); return Qnil; }
static VALUE _wrap_FXDirList_move(int argc, VALUE *argv, VALUE self) { FXDirList *arg1 = (FXDirList *) 0 ; FXint arg2 ;
    FXint arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDirList, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    FXDirList_move(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXDirList_position__SWIG_0(int argc, VALUE *argv, VALUE self) { FXDirList *arg1 = (FXDirList *) 0 ;
    FXint arg2 ; FXint arg3 ; FXint arg4 ; FXint arg5 ; if ((argc < 4) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDirList, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    arg4 = NUM2INT(argv[2]); arg5 = NUM2INT(argv[3]); FXDirList_position(arg1,arg2,arg3,arg4,arg5); return Qnil; }
static VALUE _wrap_FXDirList_layout(int argc, VALUE *argv, VALUE self) { FXDirList *arg1 = (FXDirList *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDirList, 1); FXDirList_layout(arg1); return Qnil; }
static VALUE _wrap_FXDirList_recalc(int argc, VALUE *argv, VALUE self) { FXDirList *arg1 = (FXDirList *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDirList, 1); FXDirList_recalc(arg1); return Qnil; }
static VALUE _wrap_FXDirList_reparent(int argc, VALUE *argv, VALUE self) { FXDirList *arg1 = (FXDirList *) 0 ;
    FXComposite *arg2 = (FXComposite *) 0 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDirList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXComposite, 1); FXDirList_reparent(arg1,arg2); return Qnil; }
static VALUE _wrap_FXDirList_show(int argc, VALUE *argv, VALUE self) { FXDirList *arg1 = (FXDirList *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDirList, 1); FXDirList_show(arg1); return Qnil; }
static VALUE _wrap_FXDirList_hide(int argc, VALUE *argv, VALUE self) { FXDirList *arg1 = (FXDirList *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDirList, 1); FXDirList_hide(arg1); return Qnil; }
static VALUE _wrap_FXDirList_isComposite(int argc, VALUE *argv, VALUE self) { FXDirList *arg1 = (FXDirList *) 0 ; FXbool result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDirList, 1);
    result = (FXbool)FXDirList_isComposite((FXDirList const *)arg1); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXDirList_contains(int argc, VALUE *argv, VALUE self) { FXDirList *arg1 = (FXDirList *) 0 ; FXint arg2 ;
    FXint arg3 ; FXbool result; VALUE vresult = Qnil; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDirList, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    result = (FXbool)FXDirList_contains((FXDirList const *)arg1,arg2,arg3); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXDirList_doesSaveUnder(int argc, VALUE *argv, VALUE self) { FXDirList *arg1 = (FXDirList *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDirList, 1);
    result = (FXbool)FXDirList_doesSaveUnder((FXDirList const *)arg1); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXDirList_setBackColor(int argc, VALUE *argv, VALUE self) { FXDirList *arg1 = (FXDirList *) 0 ;
    FXColor arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDirList, 1); arg2 = to_FXColor(argv[0]);
    FXDirList_setBackColor(arg1,arg2); return Qnil; }
static VALUE _wrap_FXDirList_getViewportHeight(int argc, VALUE *argv, VALUE self) { FXDirList *arg1 = (FXDirList *) 0 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDirList, 1); result = (FXint)FXDirList_getViewportHeight(arg1);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXDirList_getViewportWidth(int argc, VALUE *argv, VALUE self) { FXDirList *arg1 = (FXDirList *) 0 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDirList, 1); result = (FXint)FXDirList_getViewportWidth(arg1);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXDirList_getContentHeight(int argc, VALUE *argv, VALUE self) { FXDirList *arg1 = (FXDirList *) 0 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDirList, 1); result = (FXint)FXDirList_getContentHeight(arg1);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXDirList_getContentWidth(int argc, VALUE *argv, VALUE self) { FXDirList *arg1 = (FXDirList *) 0 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDirList, 1); result = (FXint)FXDirList_getContentWidth(arg1);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXDirList_position__SWIG_1(int argc, VALUE *argv, VALUE self) { FXDirList *arg1 = (FXDirList *) 0 ;
    VALUE result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDirList, 1);
    result = (VALUE)FXDirList_position__SWIG_1((FXDirList const *)arg1); vresult = result; return vresult; }
static VALUE _wrap_FXDirList_position(int nargs, VALUE *args, VALUE self) { int argc; VALUE argv[6]; int ii; argc = nargs + 1;
    argv[0] = self; for (ii = 1; (ii < argc) && (ii < 5); ii++) { argv[ii] = args[ii-1]; }  if (argc == 1) { int _v; {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXDirList, 0) != -1)) ? 1 : 0; }
         if (_v) { return _wrap_FXDirList_position__SWIG_1(nargs, args, self);}  }  if (argc == 5) { int _v; { void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXDirList, 0) != -1)) ? 1 : 0; }
         if (_v) { { _v = ((TYPE(argv[1]) == T_FIXNUM) || (TYPE(argv[1]) == T_BIGNUM)) ? 1 : 0; }  if (_v) { {
                    _v = ((TYPE(argv[2]) == T_FIXNUM) || (TYPE(argv[2]) == T_BIGNUM)) ? 1 : 0; }  if (_v) { {
                        _v = ((TYPE(argv[3]) == T_FIXNUM) || (TYPE(argv[3]) == T_BIGNUM)) ? 1 : 0; }  if (_v) { {
                            _v = ((TYPE(argv[4]) == T_FIXNUM) || (TYPE(argv[4]) == T_BIGNUM)) ? 1 : 0; }  if (_v) {
                            return _wrap_FXDirList_position__SWIG_0(nargs, args, self);}  }  }  }  }  } 
    rb_raise(rb_eArgError, "No matching function for overloaded 'FXDirList_position'"); return Qnil; }
static VALUE _wrap_FXDirList_selectItem(int argc, VALUE *argv, VALUE self) { FXDirList *arg1 = (FXDirList *) 0 ;
    FXTreeItem *arg2 = (FXTreeItem *) 0 ; FXbool arg3 = (FXbool) 0 ; FXbool result; VALUE vresult = Qnil;
    if ((argc < 1) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDirList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXTreeItem, 1); if (argc > 1) { arg3 = to_FXbool(argv[1]); } 
    result = (FXbool)FXDirList_selectItem(arg1,arg2,arg3); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXDirList_deselectItem(int argc, VALUE *argv, VALUE self) { FXDirList *arg1 = (FXDirList *) 0 ;
    FXTreeItem *arg2 = (FXTreeItem *) 0 ; FXbool arg3 = (FXbool) 0 ; FXbool result; VALUE vresult = Qnil;
    if ((argc < 1) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDirList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXTreeItem, 1); if (argc > 1) { arg3 = to_FXbool(argv[1]); } 
    result = (FXbool)FXDirList_deselectItem(arg1,arg2,arg3); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXDirList_toggleItem(int argc, VALUE *argv, VALUE self) { FXDirList *arg1 = (FXDirList *) 0 ;
    FXTreeItem *arg2 = (FXTreeItem *) 0 ; FXbool arg3 = (FXbool) 0 ; FXbool result; VALUE vresult = Qnil;
    if ((argc < 1) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDirList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXTreeItem, 1); if (argc > 1) { arg3 = to_FXbool(argv[1]); } 
    result = (FXbool)FXDirList_toggleItem(arg1,arg2,arg3); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXDirList_extendSelection(int argc, VALUE *argv, VALUE self) { FXDirList *arg1 = (FXDirList *) 0 ;
    FXTreeItem *arg2 = (FXTreeItem *) 0 ; FXbool arg3 = (FXbool) 0 ; FXbool result; VALUE vresult = Qnil;
    if ((argc < 1) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDirList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXTreeItem, 1); if (argc > 1) { arg3 = to_FXbool(argv[1]); } 
    result = (FXbool)FXDirList_extendSelection(arg1,arg2,arg3); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXDirList_killSelection(int argc, VALUE *argv, VALUE self) { FXDirList *arg1 = (FXDirList *) 0 ;
    FXbool arg2 = (FXbool) 0 ; FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDirList, 1); if (argc > 0) { arg2 = to_FXbool(argv[0]); } 
    result = (FXbool)FXDirList_killSelection(arg1,arg2); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXDirList_openItem(int argc, VALUE *argv, VALUE self) { FXDirList *arg1 = (FXDirList *) 0 ;
    FXTreeItem *arg2 = (FXTreeItem *) 0 ; FXbool arg3 = (FXbool) 0 ; FXbool result; VALUE vresult = Qnil;
    if ((argc < 1) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDirList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXTreeItem, 1); if (argc > 1) { arg3 = to_FXbool(argv[1]); } 
    result = (FXbool)FXDirList_openItem(arg1,arg2,arg3); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXDirList_closeItem(int argc, VALUE *argv, VALUE self) { FXDirList *arg1 = (FXDirList *) 0 ;
    FXTreeItem *arg2 = (FXTreeItem *) 0 ; FXbool arg3 = (FXbool) 0 ; FXbool result; VALUE vresult = Qnil;
    if ((argc < 1) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDirList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXTreeItem, 1); if (argc > 1) { arg3 = to_FXbool(argv[1]); } 
    result = (FXbool)FXDirList_closeItem(arg1,arg2,arg3); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXDirList_collapseTree(int argc, VALUE *argv, VALUE self) { FXDirList *arg1 = (FXDirList *) 0 ;
    FXTreeItem *arg2 = (FXTreeItem *) 0 ; FXbool arg3 = (FXbool) 0 ; FXbool result; VALUE vresult = Qnil;
    if ((argc < 1) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDirList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXTreeItem, 1); if (argc > 1) { arg3 = to_FXbool(argv[1]); } 
    result = (FXbool)FXDirList_collapseTree(arg1,arg2,arg3); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXDirList_expandTree(int argc, VALUE *argv, VALUE self) { FXDirList *arg1 = (FXDirList *) 0 ;
    FXTreeItem *arg2 = (FXTreeItem *) 0 ; FXbool arg3 = (FXbool) 0 ; FXbool result; VALUE vresult = Qnil;
    if ((argc < 1) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDirList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXTreeItem, 1); if (argc > 1) { arg3 = to_FXbool(argv[1]); } 
    result = (FXbool)FXDirList_expandTree(arg1,arg2,arg3); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXDirList_setCurrentItem(int argc, VALUE *argv, VALUE self) { FXDirList *arg1 = (FXDirList *) 0 ;
    FXTreeItem *arg2 = (FXTreeItem *) 0 ; FXbool arg3 = (FXbool) 0 ; if ((argc < 1) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDirList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXTreeItem, 1); if (argc > 1) { arg3 = to_FXbool(argv[1]); } 
    FXDirList_setCurrentItem(arg1,arg2,arg3); return Qnil; }

/* -------- TYPE CONVERSION AND EQUIVALENCE RULES (BEGIN) -------- */

static void *_p_FXDriveBoxTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *)(FXListBox *) ((FXDriveBox *) x));
}
static void *_p_FXToolBarTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXToolBar *) x));
}
static void *_p_FXCompositeTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *) ((FXComposite *) x));
}
static void *_p_FXToolTipTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXShell *) ((FXToolTip *) x));
}
static void *_p_FXTextFieldTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXFrame *) ((FXTextField *) x));
}
static void *_p_FXTabBookTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *)(FXTabBar *) ((FXTabBook *) x));
}
static void *_p_FXArrowButtonTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXFrame *) ((FXArrowButton *) x));
}
static void *_p_FXGroupBoxTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXGroupBox *) x));
}
static void *_p_FXShellTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *) ((FXShell *) x));
}
static void *_p_FXStatusBarTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *)(FXHorizontalFrame *) ((FXStatusBar *) x));
}
static void *_p_FXScrollAreaTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *) ((FXScrollArea *) x));
}
static void *_p_FXPopupTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXShell *) ((FXPopup *) x));
}
static void *_p_FXFoldingListTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXScrollArea *) ((FXFoldingList *) x));
}
static void *_p_FXScrollWindowTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXScrollArea *) ((FXScrollWindow *) x));
}
static void *_p_FXWindowTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *) ((FXWindow *) x));
}
static void *_p_FXRootWindowTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *) ((FXRootWindow *) x));
}
static void *_p_FXTopWindowTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXShell *) ((FXTopWindow *) x));
}
static void *_p_FXMainWindowTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXShell *)(FXTopWindow *) ((FXMainWindow *) x));
}
static void *_p_FXRulerTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXFrame *) ((FXRuler *) x));
}
static void *_p_FXCanvasTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *) ((FXCanvas *) x));
}
static void *_p_FXScrollCornerTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *) ((FXScrollCorner *) x));
}
static void *_p_FXSeparatorTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXFrame *) ((FXSeparator *) x));
}
static void *_p_FXHorizontalSeparatorTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXFrame *)(FXSeparator *) ((FXHorizontalSeparator *) x));
}
static void *_p_FXVerticalSeparatorTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXFrame *)(FXSeparator *) ((FXVerticalSeparator *) x));
}
static void *_p_FXStatusLineTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXFrame *) ((FXStatusLine *) x));
}
static void *_p_FXComboBoxTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXComboBox *) x));
}
static void *_p_FXVerticalFrameTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXVerticalFrame *) x));
}
static void *_p_FXHorizontalFrameTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXHorizontalFrame *) x));
}
static void *_p_FX4SplitterTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *) ((FX4Splitter *) x));
}
static void *_p_FXSplitterTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *) ((FXSplitter *) x));
}
static void *_p_FXPackerTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *) ((FXPacker *) x));
}
static void *_p_FXSpinnerTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXSpinner *) x));
}
static void *_p_FXRealSpinnerTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXRealSpinner *) x));
}
static void *_p_FXScrollBarTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *) ((FXScrollBar *) x));
}
static void *_p_FXColorWheelTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXFrame *) ((FXColorWheel *) x));
}
static void *_p_FXBitmapFrameTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXFrame *) ((FXBitmapFrame *) x));
}
static void *_p_FXFontTo_p_FXId(void *x) {
    return (void *)((FXId *)  ((FXFont *) x));
}
static void *_p_FXDirBoxTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *)(FXTreeListBox *) ((FXDirBox *) x));
}
static void *_p_FXToolBarGripTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *) ((FXToolBarGrip *) x));
}
static void *_p_FXImageFrameTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXFrame *) ((FXImageFrame *) x));
}
static void *_p_FXDragCornerTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *) ((FXDragCorner *) x));
}
static void *_p_FXSwitcherTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXSwitcher *) x));
}
static void *_p_FXDirSelectorTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXDirSelector *) x));
}
static void *_p_FXFileSelectorTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXFileSelector *) x));
}
static void *_p_FXColorSelectorTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXColorSelector *) x));
}
static void *_p_FXFontSelectorTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXFontSelector *) x));
}
static void *_p_FXShutterTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *)(FXVerticalFrame *) ((FXShutter *) x));
}
static void *_p_FXDrawableTo_p_FXId(void *x) {
    return (void *)((FXId *)  ((FXDrawable *) x));
}
static void *_p_FXCursorTo_p_FXId(void *x) {
    return (void *)((FXId *)  ((FXCursor *) x));
}
static void *_p_FXCURCursorTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXCursor *) ((FXCURCursor *) x));
}
static void *_p_FXGIFCursorTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXCursor *) ((FXGIFCursor *) x));
}
static void *_p_FXProgressBarTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXFrame *) ((FXProgressBar *) x));
}
static void *_p_FXDirListTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXScrollArea *)(FXTreeList *) ((FXDirList *) x));
}
static void *_p_FXListBoxTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXListBox *) x));
}
static void *_p_FXTreeListBoxTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXTreeListBox *) x));
}
static void *_p_FXHeaderTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXFrame *) ((FXHeader *) x));
}
static void *_p_FXMatrixTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXMatrix *) x));
}
static void *_p_FXColorWellTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXFrame *) ((FXColorWell *) x));
}
static void *_p_FXShutterItemTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *)(FXVerticalFrame *) ((FXShutterItem *) x));
}
static void *_p_FXDialTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXFrame *) ((FXDial *) x));
}
static void *_p_FXToolBarTabTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXFrame *) ((FXToolBarTab *) x));
}
static void *_p_FXFrameTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *) ((FXFrame *) x));
}
static void *_p_FXTabBarTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXTabBar *) x));
}
static void *_p_FXImageViewTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXScrollArea *) ((FXImageView *) x));
}
static void *_p_FXSliderTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXFrame *) ((FXSlider *) x));
}
static void *_p_FXRealSliderTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXFrame *) ((FXRealSlider *) x));
}
static void *_p_FXTreeListTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXScrollArea *) ((FXTreeList *) x));
}
static void *_p_FXSpringTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXSpring *) x));
}
static void *_p_FXVisualTo_p_FXId(void *x) {
    return (void *)((FXId *)  ((FXVisual *) x));
}
static void *_p_FXColorBarTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXFrame *) ((FXColorBar *) x));
}
static void *_p_FXToolBarShellTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXShell *)(FXTopWindow *) ((FXToolBarShell *) x));
}
static void *_p_FXDocumentTo_p_FXObject(void *x) {
    return (void *)((FXObject *)  ((FXDocument *) x));
}
static void *_p_FXRegistryTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXDict *)(FXSettings *) ((FXRegistry *) x));
}
static void *_p_FXHeaderItemTo_p_FXObject(void *x) {
    return (void *)((FXObject *)  ((FXHeaderItem *) x));
}
static void *_p_FXShutterItemTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *)(FXVerticalFrame *) ((FXShutterItem *) x));
}
static void *_p_FXColorBarTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXFrame *) ((FXColorBar *) x));
}
static void *_p_FXTabBarTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXTabBar *) x));
}
static void *_p_FXTreeListTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXScrollArea *) ((FXTreeList *) x));
}
static void *_p_FXSwitcherTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXSwitcher *) x));
}
static void *_p_FXTextFieldTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXFrame *) ((FXTextField *) x));
}
static void *_p_FXToolBarTabTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXFrame *) ((FXToolBarTab *) x));
}
static void *_p_FXDriveBoxTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *)(FXListBox *) ((FXDriveBox *) x));
}
static void *_p_FXIconDictTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXDict *) ((FXIconDict *) x));
}
static void *_p_FXDirListTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXScrollArea *)(FXTreeList *) ((FXDirList *) x));
}
static void *_p_FXMatrixTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXMatrix *) x));
}
static void *_p_FXFileDictTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXDict *) ((FXFileDict *) x));
}
static void *_p_FXRecentFilesTo_p_FXObject(void *x) {
    return (void *)((FXObject *)  ((FXRecentFiles *) x));
}
static void *_p_FXScrollCornerTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *) ((FXScrollCorner *) x));
}
static void *_p_FXArrowButtonTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXFrame *) ((FXArrowButton *) x));
}
static void *_p_FXPopupTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXShell *) ((FXPopup *) x));
}
static void *_p_FXDrawableTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *) ((FXDrawable *) x));
}
static void *_p_FXAppTo_p_FXObject(void *x) {
    return (void *)((FXObject *)  ((FXApp *) x));
}
static void *_p_FXHeaderTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXFrame *) ((FXHeader *) x));
}
static void *_p_FX4SplitterTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *) ((FX4Splitter *) x));
}
static void *_p_FXSplitterTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *) ((FXSplitter *) x));
}
static void *_p_FXSpringTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXSpring *) x));
}
static void *_p_FXPackerTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *) ((FXPacker *) x));
}
static void *_p_FXTabBookTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *)(FXTabBar *) ((FXTabBook *) x));
}
static void *_p_FXImageFrameTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXFrame *) ((FXImageFrame *) x));
}
static void *_p_FXVerticalSeparatorTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXFrame *)(FXSeparator *) ((FXVerticalSeparator *) x));
}
static void *_p_FXHorizontalSeparatorTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXFrame *)(FXSeparator *) ((FXHorizontalSeparator *) x));
}
static void *_p_FXSeparatorTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXFrame *) ((FXSeparator *) x));
}
static void *_p_FXIdTo_p_FXObject(void *x) {
    return (void *)((FXObject *)  ((FXId *) x));
}
static void *_p_FXProgressBarTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXFrame *) ((FXProgressBar *) x));
}
static void *_p_FXShutterTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *)(FXVerticalFrame *) ((FXShutter *) x));
}
static void *_p_FXFoldingListTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXScrollArea *) ((FXFoldingList *) x));
}
static void *_p_FXToolTipTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXShell *) ((FXToolTip *) x));
}
static void *_p_FXCompositeTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *) ((FXComposite *) x));
}
static void *_p_FXBitmapFrameTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXFrame *) ((FXBitmapFrame *) x));
}
static void *_p_FXRealSliderTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXFrame *) ((FXRealSlider *) x));
}
static void *_p_FXSliderTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXFrame *) ((FXSlider *) x));
}
static void *_p_FXSettingsTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXDict *) ((FXSettings *) x));
}
static void *_p_FXGroupBoxTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXGroupBox *) x));
}
static void *_p_FXDebugTargetTo_p_FXObject(void *x) {
    return (void *)((FXObject *)  ((FXDebugTarget *) x));
}
static void *_p_FXDataTargetTo_p_FXObject(void *x) {
    return (void *)((FXObject *)  ((FXDataTarget *) x));
}
static void *_p_FXTreeItemTo_p_FXObject(void *x) {
    return (void *)((FXObject *)  ((FXTreeItem *) x));
}
static void *_p_FXTreeListBoxTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXTreeListBox *) x));
}
static void *_p_FXListBoxTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXListBox *) x));
}
static void *_p_FXCanvasTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *) ((FXCanvas *) x));
}
static void *_p_FXColorWheelTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXFrame *) ((FXColorWheel *) x));
}
static void *_p_FXVisualTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *) ((FXVisual *) x));
}
static void *_p_FXScrollBarTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *) ((FXScrollBar *) x));
}
static void *_p_FXToolBarGripTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *) ((FXToolBarGrip *) x));
}
static void *_p_FXDirItemTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXTreeItem *) ((FXDirItem *) x));
}
static void *_p_FXFontTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *) ((FXFont *) x));
}
static void *_p_FXComboBoxTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXComboBox *) x));
}
static void *_p_FXFrameTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *) ((FXFrame *) x));
}
static void *_p_FXStringDictTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXDict *) ((FXStringDict *) x));
}
static void *_p_FXStatusBarTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *)(FXHorizontalFrame *) ((FXStatusBar *) x));
}
static void *_p_FXDelegatorTo_p_FXObject(void *x) {
    return (void *)((FXObject *)  ((FXDelegator *) x));
}
static void *_p_FXAccelTableTo_p_FXObject(void *x) {
    return (void *)((FXObject *)  ((FXAccelTable *) x));
}
static void *_p_FXCursorTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *) ((FXCursor *) x));
}
static void *_p_FXCURCursorTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXCursor *) ((FXCURCursor *) x));
}
static void *_p_FXGIFCursorTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXCursor *) ((FXGIFCursor *) x));
}
static void *_p_FXRealSpinnerTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXRealSpinner *) x));
}
static void *_p_FXSpinnerTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXSpinner *) x));
}
static void *_p_FXStatusLineTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXFrame *) ((FXStatusLine *) x));
}
static void *_p_FXScrollWindowTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXScrollArea *) ((FXScrollWindow *) x));
}
static void *_p_FXWindowTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *) ((FXWindow *) x));
}
static void *_p_FXRootWindowTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *) ((FXRootWindow *) x));
}
static void *_p_FXTopWindowTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXShell *) ((FXTopWindow *) x));
}
static void *_p_FXMainWindowTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXShell *)(FXTopWindow *) ((FXMainWindow *) x));
}
static void *_p_FXDictTo_p_FXObject(void *x) {
    return (void *)((FXObject *)  ((FXDict *) x));
}
static void *_p_FXShellTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *) ((FXShell *) x));
}
static void *_p_FXScrollAreaTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *) ((FXScrollArea *) x));
}
static void *_p_FXColorWellTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXFrame *) ((FXColorWell *) x));
}
static void *_p_FXDragCornerTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *) ((FXDragCorner *) x));
}
static void *_p_FXRulerTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXFrame *) ((FXRuler *) x));
}
static void *_p_FXDialTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXFrame *) ((FXDial *) x));
}
static void *_p_FXHorizontalFrameTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXHorizontalFrame *) x));
}
static void *_p_FXVerticalFrameTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXVerticalFrame *) x));
}
static void *_p_FXImageViewTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXScrollArea *) ((FXImageView *) x));
}
static void *_p_FXDirSelectorTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXDirSelector *) x));
}
static void *_p_FXFileSelectorTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXFileSelector *) x));
}
static void *_p_FXColorSelectorTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXColorSelector *) x));
}
static void *_p_FXFontSelectorTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXFontSelector *) x));
}
static void *_p_FXFoldingItemTo_p_FXObject(void *x) {
    return (void *)((FXObject *)  ((FXFoldingItem *) x));
}
static void *_p_FXToolBarTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXToolBar *) x));
}
static void *_p_FXToolBarShellTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXShell *)(FXTopWindow *) ((FXToolBarShell *) x));
}
static void *_p_FXDirBoxTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *)(FXTreeListBox *) ((FXDirBox *) x));
}
static void *_p_FXFoldingListTo_p_FXScrollArea(void *x) {
    return (void *)((FXScrollArea *)  ((FXFoldingList *) x));
}
static void *_p_FXDirListTo_p_FXScrollArea(void *x) {
    return (void *)((FXScrollArea *) (FXTreeList *) ((FXDirList *) x));
}
static void *_p_FXScrollWindowTo_p_FXScrollArea(void *x) {
    return (void *)((FXScrollArea *)  ((FXScrollWindow *) x));
}
static void *_p_FXTreeListTo_p_FXScrollArea(void *x) {
    return (void *)((FXScrollArea *)  ((FXTreeList *) x));
}
static void *_p_FXImageViewTo_p_FXScrollArea(void *x) {
    return (void *)((FXScrollArea *)  ((FXImageView *) x));
}
static void *_p_FXDriveBoxTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXPacker *)(FXListBox *) ((FXDriveBox *) x));
}
static void *_p_FXToolBarTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXPacker *) ((FXToolBar *) x));
}
static void *_p_FXCompositeTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *)  ((FXComposite *) x));
}
static void *_p_FXToolTipTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXShell *) ((FXToolTip *) x));
}
static void *_p_FXTextFieldTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXFrame *) ((FXTextField *) x));
}
static void *_p_FXTabBookTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXPacker *)(FXTabBar *) ((FXTabBook *) x));
}
static void *_p_FXArrowButtonTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXFrame *) ((FXArrowButton *) x));
}
static void *_p_FXGroupBoxTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXPacker *) ((FXGroupBox *) x));
}
static void *_p_FXShellTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *) ((FXShell *) x));
}
static void *_p_FXStatusBarTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXPacker *)(FXHorizontalFrame *) ((FXStatusBar *) x));
}
static void *_p_FXScrollAreaTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *) ((FXScrollArea *) x));
}
static void *_p_FXPopupTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXShell *) ((FXPopup *) x));
}
static void *_p_FXFoldingListTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXScrollArea *) ((FXFoldingList *) x));
}
static void *_p_FXScrollWindowTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXScrollArea *) ((FXScrollWindow *) x));
}
static void *_p_FXRootWindowTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *) ((FXRootWindow *) x));
}
static void *_p_FXTopWindowTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXShell *) ((FXTopWindow *) x));
}
static void *_p_FXMainWindowTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXShell *)(FXTopWindow *) ((FXMainWindow *) x));
}
static void *_p_FXRulerTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXFrame *) ((FXRuler *) x));
}
static void *_p_FXCanvasTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *)  ((FXCanvas *) x));
}
static void *_p_FXScrollCornerTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *)  ((FXScrollCorner *) x));
}
static void *_p_FXVerticalSeparatorTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXFrame *)(FXSeparator *) ((FXVerticalSeparator *) x));
}
static void *_p_FXHorizontalSeparatorTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXFrame *)(FXSeparator *) ((FXHorizontalSeparator *) x));
}
static void *_p_FXSeparatorTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXFrame *) ((FXSeparator *) x));
}
static void *_p_FXStatusLineTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXFrame *) ((FXStatusLine *) x));
}
static void *_p_FXComboBoxTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXPacker *) ((FXComboBox *) x));
}
static void *_p_FXHorizontalFrameTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXPacker *) ((FXHorizontalFrame *) x));
}
static void *_p_FXVerticalFrameTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXPacker *) ((FXVerticalFrame *) x));
}
static void *_p_FX4SplitterTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *) ((FX4Splitter *) x));
}
static void *_p_FXSplitterTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *) ((FXSplitter *) x));
}
static void *_p_FXPackerTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *) ((FXPacker *) x));
}
static void *_p_FXSpinnerTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXPacker *) ((FXSpinner *) x));
}
static void *_p_FXRealSpinnerTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXPacker *) ((FXRealSpinner *) x));
}
static void *_p_FXScrollBarTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *)  ((FXScrollBar *) x));
}
static void *_p_FXColorWheelTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXFrame *) ((FXColorWheel *) x));
}
static void *_p_FXBitmapFrameTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXFrame *) ((FXBitmapFrame *) x));
}
static void *_p_FXDirBoxTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXPacker *)(FXTreeListBox *) ((FXDirBox *) x));
}
static void *_p_FXToolBarGripTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *)  ((FXToolBarGrip *) x));
}
static void *_p_FXImageFrameTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXFrame *) ((FXImageFrame *) x));
}
static void *_p_FXDragCornerTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *)  ((FXDragCorner *) x));
}
static void *_p_FXSwitcherTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXPacker *) ((FXSwitcher *) x));
}
static void *_p_FXDirSelectorTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXPacker *) ((FXDirSelector *) x));
}
static void *_p_FXFileSelectorTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXPacker *) ((FXFileSelector *) x));
}
static void *_p_FXColorSelectorTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXPacker *) ((FXColorSelector *) x));
}
static void *_p_FXFontSelectorTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXPacker *) ((FXFontSelector *) x));
}
static void *_p_FXShutterTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXPacker *)(FXVerticalFrame *) ((FXShutter *) x));
}
static void *_p_FXProgressBarTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXFrame *) ((FXProgressBar *) x));
}
static void *_p_FXDirListTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXScrollArea *)(FXTreeList *) ((FXDirList *) x));
}
static void *_p_FXListBoxTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXPacker *) ((FXListBox *) x));
}
static void *_p_FXTreeListBoxTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXPacker *) ((FXTreeListBox *) x));
}
static void *_p_FXHeaderTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXFrame *) ((FXHeader *) x));
}
static void *_p_FXMatrixTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXPacker *) ((FXMatrix *) x));
}
static void *_p_FXColorWellTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXFrame *) ((FXColorWell *) x));
}
static void *_p_FXShutterItemTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXPacker *)(FXVerticalFrame *) ((FXShutterItem *) x));
}
static void *_p_FXDialTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXFrame *) ((FXDial *) x));
}
static void *_p_FXToolBarTabTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXFrame *) ((FXToolBarTab *) x));
}
static void *_p_FXFrameTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *)  ((FXFrame *) x));
}
static void *_p_FXTabBarTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXPacker *) ((FXTabBar *) x));
}
static void *_p_FXImageViewTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXScrollArea *) ((FXImageView *) x));
}
static void *_p_FXSliderTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXFrame *) ((FXSlider *) x));
}
static void *_p_FXRealSliderTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXFrame *) ((FXRealSlider *) x));
}
static void *_p_FXTreeListTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXScrollArea *) ((FXTreeList *) x));
}
static void *_p_FXSpringTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXPacker *) ((FXSpring *) x));
}
static void *_p_FXColorBarTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXFrame *) ((FXColorBar *) x));
}
static void *_p_FXToolBarShellTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXShell *)(FXTopWindow *) ((FXToolBarShell *) x));
}
static void *_p_FXDriveBoxTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXPacker *)(FXListBox *) ((FXDriveBox *) x));
}
static void *_p_FXToolBarTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXPacker *) ((FXToolBar *) x));
}
static void *_p_FXToolTipTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXShell *) ((FXToolTip *) x));
}
static void *_p_FXTabBookTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXPacker *)(FXTabBar *) ((FXTabBook *) x));
}
static void *_p_FXGroupBoxTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXPacker *) ((FXGroupBox *) x));
}
static void *_p_FXShellTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *)  ((FXShell *) x));
}
static void *_p_FXStatusBarTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXPacker *)(FXHorizontalFrame *) ((FXStatusBar *) x));
}
static void *_p_FXScrollAreaTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *)  ((FXScrollArea *) x));
}
static void *_p_FXPopupTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXShell *) ((FXPopup *) x));
}
static void *_p_FXFoldingListTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXScrollArea *) ((FXFoldingList *) x));
}
static void *_p_FXScrollWindowTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXScrollArea *) ((FXScrollWindow *) x));
}
static void *_p_FXRootWindowTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *)  ((FXRootWindow *) x));
}
static void *_p_FXTopWindowTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXShell *) ((FXTopWindow *) x));
}
static void *_p_FXMainWindowTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXShell *)(FXTopWindow *) ((FXMainWindow *) x));
}
static void *_p_FXComboBoxTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXPacker *) ((FXComboBox *) x));
}
static void *_p_FXHorizontalFrameTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXPacker *) ((FXHorizontalFrame *) x));
}
static void *_p_FXVerticalFrameTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXPacker *) ((FXVerticalFrame *) x));
}
static void *_p_FX4SplitterTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *)  ((FX4Splitter *) x));
}
static void *_p_FXSplitterTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *)  ((FXSplitter *) x));
}
static void *_p_FXRealSpinnerTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXPacker *) ((FXRealSpinner *) x));
}
static void *_p_FXSpinnerTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXPacker *) ((FXSpinner *) x));
}
static void *_p_FXPackerTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *)  ((FXPacker *) x));
}
static void *_p_FXDirBoxTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXPacker *)(FXTreeListBox *) ((FXDirBox *) x));
}
static void *_p_FXSwitcherTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXPacker *) ((FXSwitcher *) x));
}
static void *_p_FXColorSelectorTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXPacker *) ((FXColorSelector *) x));
}
static void *_p_FXFileSelectorTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXPacker *) ((FXFileSelector *) x));
}
static void *_p_FXDirSelectorTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXPacker *) ((FXDirSelector *) x));
}
static void *_p_FXFontSelectorTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXPacker *) ((FXFontSelector *) x));
}
static void *_p_FXShutterTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXPacker *)(FXVerticalFrame *) ((FXShutter *) x));
}
static void *_p_FXDirListTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXScrollArea *)(FXTreeList *) ((FXDirList *) x));
}
static void *_p_FXTreeListBoxTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXPacker *) ((FXTreeListBox *) x));
}
static void *_p_FXListBoxTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXPacker *) ((FXListBox *) x));
}
static void *_p_FXMatrixTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXPacker *) ((FXMatrix *) x));
}
static void *_p_FXShutterItemTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXPacker *)(FXVerticalFrame *) ((FXShutterItem *) x));
}
static void *_p_FXTabBarTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXPacker *) ((FXTabBar *) x));
}
static void *_p_FXImageViewTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXScrollArea *) ((FXImageView *) x));
}
static void *_p_FXTreeListTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXScrollArea *) ((FXTreeList *) x));
}
static void *_p_FXSpringTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXPacker *) ((FXSpring *) x));
}
static void *_p_FXToolBarShellTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXShell *)(FXTopWindow *) ((FXToolBarShell *) x));
}
static void *_p_FXFileStreamTo_p_FXStream(void *x) {
    return (void *)((FXStream *)  ((FXFileStream *) x));
}
static void *_p_FXMemoryStreamTo_p_FXStream(void *x) {
    return (void *)((FXStream *)  ((FXMemoryStream *) x));
}
static void *_p_FXDriveBoxTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *)(FXListBox *) ((FXDriveBox *) x));
}
static void *_p_FXToolBarTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *) ((FXToolBar *) x));
}
static void *_p_FXCompositeTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *) ((FXComposite *) x));
}
static void *_p_FXToolTipTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXShell *) ((FXToolTip *) x));
}
static void *_p_FXTextFieldTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXFrame *) ((FXTextField *) x));
}
static void *_p_FXTabBookTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *)(FXTabBar *) ((FXTabBook *) x));
}
static void *_p_FXArrowButtonTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXFrame *) ((FXArrowButton *) x));
}
static void *_p_FXGroupBoxTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *) ((FXGroupBox *) x));
}
static void *_p_FXShellTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *) ((FXShell *) x));
}
static void *_p_FXStatusBarTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *)(FXHorizontalFrame *) ((FXStatusBar *) x));
}
static void *_p_FXScrollAreaTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *) ((FXScrollArea *) x));
}
static void *_p_FXPopupTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXShell *) ((FXPopup *) x));
}
static void *_p_FXFoldingListTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXScrollArea *) ((FXFoldingList *) x));
}
static void *_p_FXScrollWindowTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXScrollArea *) ((FXScrollWindow *) x));
}
static void *_p_FXWindowTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *)  ((FXWindow *) x));
}
static void *_p_FXRootWindowTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *) ((FXRootWindow *) x));
}
static void *_p_FXTopWindowTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXShell *) ((FXTopWindow *) x));
}
static void *_p_FXMainWindowTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXShell *)(FXTopWindow *) ((FXMainWindow *) x));
}
static void *_p_FXRulerTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXFrame *) ((FXRuler *) x));
}
static void *_p_FXCanvasTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *) ((FXCanvas *) x));
}
static void *_p_FXScrollCornerTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *) ((FXScrollCorner *) x));
}
static void *_p_FXHorizontalSeparatorTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXFrame *)(FXSeparator *) ((FXHorizontalSeparator *) x));
}
static void *_p_FXSeparatorTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXFrame *) ((FXSeparator *) x));
}
static void *_p_FXVerticalSeparatorTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXFrame *)(FXSeparator *) ((FXVerticalSeparator *) x));
}
static void *_p_FXStatusLineTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXFrame *) ((FXStatusLine *) x));
}
static void *_p_FXComboBoxTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *) ((FXComboBox *) x));
}
static void *_p_FXHorizontalFrameTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *) ((FXHorizontalFrame *) x));
}
static void *_p_FXVerticalFrameTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *) ((FXVerticalFrame *) x));
}
static void *_p_FX4SplitterTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *) ((FX4Splitter *) x));
}
static void *_p_FXSplitterTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *) ((FXSplitter *) x));
}
static void *_p_FXPackerTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *) ((FXPacker *) x));
}
static void *_p_FXSpinnerTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *) ((FXSpinner *) x));
}
static void *_p_FXRealSpinnerTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *) ((FXRealSpinner *) x));
}
static void *_p_FXScrollBarTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *) ((FXScrollBar *) x));
}
static void *_p_FXColorWheelTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXFrame *) ((FXColorWheel *) x));
}
static void *_p_FXBitmapFrameTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXFrame *) ((FXBitmapFrame *) x));
}
static void *_p_FXDirBoxTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *)(FXTreeListBox *) ((FXDirBox *) x));
}
static void *_p_FXToolBarGripTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *) ((FXToolBarGrip *) x));
}
static void *_p_FXImageFrameTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXFrame *) ((FXImageFrame *) x));
}
static void *_p_FXDragCornerTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *) ((FXDragCorner *) x));
}
static void *_p_FXSwitcherTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *) ((FXSwitcher *) x));
}
static void *_p_FXDirSelectorTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *) ((FXDirSelector *) x));
}
static void *_p_FXFileSelectorTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *) ((FXFileSelector *) x));
}
static void *_p_FXColorSelectorTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *) ((FXColorSelector *) x));
}
static void *_p_FXFontSelectorTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *) ((FXFontSelector *) x));
}
static void *_p_FXShutterTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *)(FXVerticalFrame *) ((FXShutter *) x));
}
static void *_p_FXProgressBarTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXFrame *) ((FXProgressBar *) x));
}
static void *_p_FXDirListTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXScrollArea *)(FXTreeList *) ((FXDirList *) x));
}
static void *_p_FXListBoxTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *) ((FXListBox *) x));
}
static void *_p_FXTreeListBoxTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *) ((FXTreeListBox *) x));
}
static void *_p_FXHeaderTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXFrame *) ((FXHeader *) x));
}
static void *_p_FXMatrixTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *) ((FXMatrix *) x));
}
static void *_p_FXColorWellTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXFrame *) ((FXColorWell *) x));
}
static void *_p_FXShutterItemTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *)(FXVerticalFrame *) ((FXShutterItem *) x));
}
static void *_p_FXDialTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXFrame *) ((FXDial *) x));
}
static void *_p_FXToolBarTabTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXFrame *) ((FXToolBarTab *) x));
}
static void *_p_FXFrameTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *) ((FXFrame *) x));
}
static void *_p_FXTabBarTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *) ((FXTabBar *) x));
}
static void *_p_FXImageViewTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXScrollArea *) ((FXImageView *) x));
}
static void *_p_FXSliderTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXFrame *) ((FXSlider *) x));
}
static void *_p_FXRealSliderTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXFrame *) ((FXRealSlider *) x));
}
static void *_p_FXTreeListTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXScrollArea *) ((FXTreeList *) x));
}
static void *_p_FXSpringTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *) ((FXSpring *) x));
}
static void *_p_FXColorBarTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXFrame *) ((FXColorBar *) x));
}
static void *_p_FXToolBarShellTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXShell *)(FXTopWindow *) ((FXToolBarShell *) x));
}
static void *_p_FXDirListTo_p_FXTreeList(void *x) {
    return (void *)((FXTreeList *)  ((FXDirList *) x));
}
static void *_p_FXDirItemTo_p_FXTreeItem(void *x) {
    return (void *)((FXTreeItem *)  ((FXDirItem *) x));
}
static swig_type_info _swigt__p_FXFoldingItem[] = {{"_p_FXFoldingItem", 0, "FXFoldingItem *", 0, 0, 0, 0},{"_p_FXFoldingItem", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXObject[] = {{"_p_FXObject", 0, "FXObject *", 0, 0, 0, 0},{"_p_FXDocument", _p_FXDocumentTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXRegistry", _p_FXRegistryTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXHeaderItem", _p_FXHeaderItemTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXShutterItem", _p_FXShutterItemTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXColorBar", _p_FXColorBarTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXTreeList", _p_FXTreeListTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXTabBar", _p_FXTabBarTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXSwitcher", _p_FXSwitcherTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXTextField", _p_FXTextFieldTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXToolBarTab", _p_FXToolBarTabTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXDriveBox", _p_FXDriveBoxTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXDirList", _p_FXDirListTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXIconDict", _p_FXIconDictTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXMatrix", _p_FXMatrixTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXFileDict", _p_FXFileDictTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXRecentFiles", _p_FXRecentFilesTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXScrollCorner", _p_FXScrollCornerTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXArrowButton", _p_FXArrowButtonTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXPopup", _p_FXPopupTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXDrawable", _p_FXDrawableTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXFont", _p_FXFontTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXHeader", _p_FXHeaderTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FX4Splitter", _p_FX4SplitterTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXSplitter", _p_FXSplitterTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXSpring", _p_FXSpringTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXPacker", _p_FXPackerTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXTabBook", _p_FXTabBookTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXApp", _p_FXAppTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXImageFrame", _p_FXImageFrameTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXVerticalSeparator", _p_FXVerticalSeparatorTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXHorizontalSeparator", _p_FXHorizontalSeparatorTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXSeparator", _p_FXSeparatorTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXProgressBar", _p_FXProgressBarTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXShutter", _p_FXShutterTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXFoldingList", _p_FXFoldingListTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXToolTip", _p_FXToolTipTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXComposite", _p_FXCompositeTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXDict", _p_FXDictTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXBitmapFrame", _p_FXBitmapFrameTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXRealSlider", _p_FXRealSliderTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXSlider", _p_FXSliderTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXSettings", _p_FXSettingsTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXGroupBox", _p_FXGroupBoxTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXDataTarget", _p_FXDataTargetTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXDebugTarget", _p_FXDebugTargetTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXTreeItem", _p_FXTreeItemTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXTreeListBox", _p_FXTreeListBoxTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXListBox", _p_FXListBoxTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXCanvas", _p_FXCanvasTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXId", _p_FXIdTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXColorWheel", _p_FXColorWheelTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXDial", _p_FXDialTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXToolBarGrip", _p_FXToolBarGripTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXScrollBar", _p_FXScrollBarTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXDirItem", _p_FXDirItemTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXVisual", _p_FXVisualTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXComboBox", _p_FXComboBoxTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXFrame", _p_FXFrameTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXStatusBar", _p_FXStatusBarTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXStringDict", _p_FXStringDictTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXDelegator", _p_FXDelegatorTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXAccelTable", _p_FXAccelTableTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXObject", 0, 0, 0, 0, 0, 0},{"_p_FXCursor", _p_FXCursorTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXCURCursor", _p_FXCURCursorTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXGIFCursor", _p_FXGIFCursorTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXRealSpinner", _p_FXRealSpinnerTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXSpinner", _p_FXSpinnerTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXStatusLine", _p_FXStatusLineTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXWindow", _p_FXWindowTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXTopWindow", _p_FXTopWindowTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXRootWindow", _p_FXRootWindowTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXScrollWindow", _p_FXScrollWindowTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXMainWindow", _p_FXMainWindowTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXShell", _p_FXShellTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXScrollArea", _p_FXScrollAreaTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXColorWell", _p_FXColorWellTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXDragCorner", _p_FXDragCornerTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXRuler", _p_FXRulerTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXHorizontalFrame", _p_FXHorizontalFrameTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXVerticalFrame", _p_FXVerticalFrameTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXImageView", _p_FXImageViewTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXColorSelector", _p_FXColorSelectorTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXFileSelector", _p_FXFileSelectorTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXDirSelector", _p_FXDirSelectorTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXFontSelector", _p_FXFontSelectorTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXFoldingItem", _p_FXFoldingItemTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXToolBarShell", _p_FXToolBarShellTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXToolBar", _p_FXToolBarTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXDirBox", _p_FXDirBoxTo_p_FXObject, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXScrollArea[] = {{"_p_FXScrollArea", 0, "FXScrollArea *", 0, 0, 0, 0},{"_p_FXFoldingList", _p_FXFoldingListTo_p_FXScrollArea, 0, 0, 0, 0, 0},{"_p_FXDirList", _p_FXDirListTo_p_FXScrollArea, 0, 0, 0, 0, 0},{"_p_FXScrollWindow", _p_FXScrollWindowTo_p_FXScrollArea, 0, 0, 0, 0, 0},{"_p_FXTreeList", _p_FXTreeListTo_p_FXScrollArea, 0, 0, 0, 0, 0},{"_p_FXScrollArea", 0, 0, 0, 0, 0, 0},{"_p_FXImageView", _p_FXImageViewTo_p_FXScrollArea, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXWindow[] = {{"_p_FXWindow", 0, "FXWindow *", 0, 0, 0, 0},{"_p_FXDriveBox", _p_FXDriveBoxTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXDial", _p_FXDialTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXToolBar", _p_FXToolBarTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXComposite", _p_FXCompositeTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXToolTip", _p_FXToolTipTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXTabBook", _p_FXTabBookTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXTextField", _p_FXTextFieldTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXArrowButton", _p_FXArrowButtonTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXFoldingList", _p_FXFoldingListTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXGroupBox", _p_FXGroupBoxTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXShell", _p_FXShellTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXStatusBar", _p_FXStatusBarTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXScrollArea", _p_FXScrollAreaTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXPopup", _p_FXPopupTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXTopWindow", _p_FXTopWindowTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXRootWindow", _p_FXRootWindowTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXMainWindow", _p_FXMainWindowTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXWindow", 0, 0, 0, 0, 0, 0},{"_p_FXScrollWindow", _p_FXScrollWindowTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXScrollCorner", _p_FXScrollCornerTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXRuler", _p_FXRulerTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXCanvas", _p_FXCanvasTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXComboBox", _p_FXComboBoxTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXSeparator", _p_FXSeparatorTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXHorizontalSeparator", _p_FXHorizontalSeparatorTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXVerticalSeparator", _p_FXVerticalSeparatorTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXStatusLine", _p_FXStatusLineTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXHorizontalFrame", _p_FXHorizontalFrameTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXVerticalFrame", _p_FXVerticalFrameTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FX4Splitter", _p_FX4SplitterTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXSplitter", _p_FXSplitterTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXRealSpinner", _p_FXRealSpinnerTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXSpinner", _p_FXSpinnerTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXPacker", _p_FXPackerTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXScrollBar", _p_FXScrollBarTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXColorWheel", _p_FXColorWheelTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXBitmapFrame", _p_FXBitmapFrameTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXDirBox", _p_FXDirBoxTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXToolBarGrip", _p_FXToolBarGripTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXImageFrame", _p_FXImageFrameTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXDragCorner", _p_FXDragCornerTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXSwitcher", _p_FXSwitcherTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXColorSelector", _p_FXColorSelectorTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXFileSelector", _p_FXFileSelectorTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXDirSelector", _p_FXDirSelectorTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXFontSelector", _p_FXFontSelectorTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXShutter", _p_FXShutterTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXDirList", _p_FXDirListTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXProgressBar", _p_FXProgressBarTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXListBox", _p_FXListBoxTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXTreeListBox", _p_FXTreeListBoxTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXHeader", _p_FXHeaderTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXMatrix", _p_FXMatrixTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXShutterItem", _p_FXShutterItemTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXColorWell", _p_FXColorWellTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXToolBarTab", _p_FXToolBarTabTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXTabBar", _p_FXTabBarTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXFrame", _p_FXFrameTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXImageView", _p_FXImageViewTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXTreeList", _p_FXTreeListTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXSlider", _p_FXSliderTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXRealSlider", _p_FXRealSliderTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXSpring", _p_FXSpringTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXColorBar", _p_FXColorBarTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXToolBarShell", _p_FXToolBarShellTo_p_FXWindow, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXComposite[] = {{"_p_FXComposite", 0, "FXComposite *", 0, 0, 0, 0},{"_p_FXDriveBox", _p_FXDriveBoxTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXToolBar", _p_FXToolBarTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXComposite", 0, 0, 0, 0, 0, 0},{"_p_FXToolTip", _p_FXToolTipTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXTabBook", _p_FXTabBookTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXFoldingList", _p_FXFoldingListTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXGroupBox", _p_FXGroupBoxTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXShell", _p_FXShellTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXStatusBar", _p_FXStatusBarTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXScrollArea", _p_FXScrollAreaTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXPopup", _p_FXPopupTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXTopWindow", _p_FXTopWindowTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXRootWindow", _p_FXRootWindowTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXMainWindow", _p_FXMainWindowTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXScrollWindow", _p_FXScrollWindowTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXComboBox", _p_FXComboBoxTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXHorizontalFrame", _p_FXHorizontalFrameTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXVerticalFrame", _p_FXVerticalFrameTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FX4Splitter", _p_FX4SplitterTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXSplitter", _p_FXSplitterTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXRealSpinner", _p_FXRealSpinnerTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXSpinner", _p_FXSpinnerTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXPacker", _p_FXPackerTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXDirBox", _p_FXDirBoxTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXSwitcher", _p_FXSwitcherTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXColorSelector", _p_FXColorSelectorTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXFileSelector", _p_FXFileSelectorTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXDirSelector", _p_FXDirSelectorTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXFontSelector", _p_FXFontSelectorTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXShutter", _p_FXShutterTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXDirList", _p_FXDirListTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXListBox", _p_FXListBoxTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXTreeListBox", _p_FXTreeListBoxTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXMatrix", _p_FXMatrixTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXShutterItem", _p_FXShutterItemTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXTabBar", _p_FXTabBarTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXImageView", _p_FXImageViewTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXTreeList", _p_FXTreeListTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXSpring", _p_FXSpringTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXToolBarShell", _p_FXToolBarShellTo_p_FXComposite, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXId[] = {{"_p_FXId", 0, "FXId *", 0, 0, 0, 0},{"_p_FXDriveBox", _p_FXDriveBoxTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXDial", _p_FXDialTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXToolBar", _p_FXToolBarTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXComposite", _p_FXCompositeTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXToolTip", _p_FXToolTipTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXTabBook", _p_FXTabBookTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXTextField", _p_FXTextFieldTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXId", 0, 0, 0, 0, 0, 0},{"_p_FXArrowButton", _p_FXArrowButtonTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXFoldingList", _p_FXFoldingListTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXGroupBox", _p_FXGroupBoxTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXShell", _p_FXShellTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXStatusBar", _p_FXStatusBarTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXScrollArea", _p_FXScrollAreaTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXPopup", _p_FXPopupTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXTopWindow", _p_FXTopWindowTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXRootWindow", _p_FXRootWindowTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXMainWindow", _p_FXMainWindowTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXScrollWindow", _p_FXScrollWindowTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXScrollCorner", _p_FXScrollCornerTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXWindow", _p_FXWindowTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXRuler", _p_FXRulerTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXCanvas", _p_FXCanvasTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXComboBox", _p_FXComboBoxTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXSeparator", _p_FXSeparatorTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXHorizontalSeparator", _p_FXHorizontalSeparatorTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXVerticalSeparator", _p_FXVerticalSeparatorTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXStatusLine", _p_FXStatusLineTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXHorizontalFrame", _p_FXHorizontalFrameTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXVerticalFrame", _p_FXVerticalFrameTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FX4Splitter", _p_FX4SplitterTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXSplitter", _p_FXSplitterTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXRealSpinner", _p_FXRealSpinnerTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXSpinner", _p_FXSpinnerTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXPacker", _p_FXPackerTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXScrollBar", _p_FXScrollBarTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXColorWheel", _p_FXColorWheelTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXBitmapFrame", _p_FXBitmapFrameTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXDirBox", _p_FXDirBoxTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXToolBarGrip", _p_FXToolBarGripTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXImageFrame", _p_FXImageFrameTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXDragCorner", _p_FXDragCornerTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXSwitcher", _p_FXSwitcherTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXColorSelector", _p_FXColorSelectorTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXFileSelector", _p_FXFileSelectorTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXDirSelector", _p_FXDirSelectorTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXFontSelector", _p_FXFontSelectorTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXShutter", _p_FXShutterTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXDirList", _p_FXDirListTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXProgressBar", _p_FXProgressBarTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXDrawable", _p_FXDrawableTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXCursor", _p_FXCursorTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXCURCursor", _p_FXCURCursorTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXGIFCursor", _p_FXGIFCursorTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXListBox", _p_FXListBoxTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXTreeListBox", _p_FXTreeListBoxTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXHeader", _p_FXHeaderTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXMatrix", _p_FXMatrixTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXShutterItem", _p_FXShutterItemTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXColorWell", _p_FXColorWellTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXToolBarTab", _p_FXToolBarTabTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXTabBar", _p_FXTabBarTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXFrame", _p_FXFrameTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXFont", _p_FXFontTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXImageView", _p_FXImageViewTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXTreeList", _p_FXTreeListTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXSlider", _p_FXSliderTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXRealSlider", _p_FXRealSliderTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXSpring", _p_FXSpringTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXVisual", _p_FXVisualTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXColorBar", _p_FXColorBarTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXToolBarShell", _p_FXToolBarShellTo_p_FXId, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXFont[] = {{"_p_FXFont", 0, "FXFont *", 0, 0, 0, 0},{"_p_FXFont", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXDirList[] = {{"_p_FXDirList", 0, "FXDirList *", 0, 0, 0, 0},{"_p_FXDirList", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXFileDict[] = {{"_p_FXFileDict", 0, "FXFileDict *", 0, 0, 0, 0},{"_p_FXFileDict", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXStream[] = {{"_p_FXStream", 0, "FXStream *", 0, 0, 0, 0},{"_p_FXFileStream", _p_FXFileStreamTo_p_FXStream, 0, 0, 0, 0, 0},{"_p_FXMemoryStream", _p_FXMemoryStreamTo_p_FXStream, 0, 0, 0, 0, 0},{"_p_FXStream", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXDrawable[] = {{"_p_FXDrawable", 0, "FXDrawable *", 0, 0, 0, 0},{"_p_FXDriveBox", _p_FXDriveBoxTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXDial", _p_FXDialTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXToolBar", _p_FXToolBarTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXComposite", _p_FXCompositeTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXToolTip", _p_FXToolTipTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXTabBook", _p_FXTabBookTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXTextField", _p_FXTextFieldTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXArrowButton", _p_FXArrowButtonTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXFoldingList", _p_FXFoldingListTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXGroupBox", _p_FXGroupBoxTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXShell", _p_FXShellTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXStatusBar", _p_FXStatusBarTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXScrollArea", _p_FXScrollAreaTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXPopup", _p_FXPopupTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXTopWindow", _p_FXTopWindowTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXRootWindow", _p_FXRootWindowTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXMainWindow", _p_FXMainWindowTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXScrollWindow", _p_FXScrollWindowTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXScrollCorner", _p_FXScrollCornerTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXWindow", _p_FXWindowTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXRuler", _p_FXRulerTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXCanvas", _p_FXCanvasTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXComboBox", _p_FXComboBoxTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXSeparator", _p_FXSeparatorTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXHorizontalSeparator", _p_FXHorizontalSeparatorTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXVerticalSeparator", _p_FXVerticalSeparatorTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXStatusLine", _p_FXStatusLineTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXHorizontalFrame", _p_FXHorizontalFrameTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXVerticalFrame", _p_FXVerticalFrameTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FX4Splitter", _p_FX4SplitterTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXSplitter", _p_FXSplitterTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXRealSpinner", _p_FXRealSpinnerTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXSpinner", _p_FXSpinnerTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXPacker", _p_FXPackerTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXScrollBar", _p_FXScrollBarTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXColorWheel", _p_FXColorWheelTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXBitmapFrame", _p_FXBitmapFrameTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXDirBox", _p_FXDirBoxTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXToolBarGrip", _p_FXToolBarGripTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXImageFrame", _p_FXImageFrameTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXDragCorner", _p_FXDragCornerTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXSwitcher", _p_FXSwitcherTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXColorSelector", _p_FXColorSelectorTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXFileSelector", _p_FXFileSelectorTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXDirSelector", _p_FXDirSelectorTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXFontSelector", _p_FXFontSelectorTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXShutter", _p_FXShutterTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXDrawable", 0, 0, 0, 0, 0, 0},{"_p_FXDirList", _p_FXDirListTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXProgressBar", _p_FXProgressBarTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXListBox", _p_FXListBoxTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXTreeListBox", _p_FXTreeListBoxTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXHeader", _p_FXHeaderTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXMatrix", _p_FXMatrixTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXShutterItem", _p_FXShutterItemTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXColorWell", _p_FXColorWellTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXToolBarTab", _p_FXToolBarTabTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXTabBar", _p_FXTabBarTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXFrame", _p_FXFrameTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXImageView", _p_FXImageViewTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXTreeList", _p_FXTreeListTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXSlider", _p_FXSliderTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXRealSlider", _p_FXRealSliderTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXSpring", _p_FXSpringTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXColorBar", _p_FXColorBarTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXToolBarShell", _p_FXToolBarShellTo_p_FXDrawable, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXDirItem[] = {{"_p_FXDirItem", 0, "FXDirItem *", 0, 0, 0, 0},{"_p_FXDirItem", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXTreeList[] = {{"_p_FXTreeList", 0, "FXTreeList *", 0, 0, 0, 0},{"_p_FXDirList", _p_FXDirListTo_p_FXTreeList, 0, 0, 0, 0, 0},{"_p_FXTreeList", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXIcon[] = {{"_p_FXIcon", 0, "FXIcon *", 0, 0, 0, 0},{"_p_FXIcon", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXHeader[] = {{"_p_FXHeader", 0, "FXHeader *", 0, 0, 0, 0},{"_p_FXHeader", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXFoldingListSortFunc[] = {{"_p_FXFoldingListSortFunc", 0, "FXFoldingListSortFunc *", 0, 0, 0, 0},{"_p_FXFoldingListSortFunc", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXFoldingList[] = {{"_p_FXFoldingList", 0, "FXFoldingList *", 0, 0, 0, 0},{"_p_FXFoldingList", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXTreeItem[] = {{"_p_FXTreeItem", 0, "FXTreeItem *", 0, 0, 0, 0},{"_p_FXTreeItem", 0, 0, 0, 0, 0, 0},{"_p_FXDirItem", _p_FXDirItemTo_p_FXTreeItem, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};

static swig_type_info *swig_types_initial[] = {
_swigt__p_FXFoldingItem, 
_swigt__p_FXObject, 
_swigt__p_FXScrollArea, 
_swigt__p_FXWindow, 
_swigt__p_FXComposite, 
_swigt__p_FXId, 
_swigt__p_FXFont, 
_swigt__p_FXDirList, 
_swigt__p_FXFileDict, 
_swigt__p_FXStream, 
_swigt__p_FXDrawable, 
_swigt__p_FXDirItem, 
_swigt__p_FXTreeList, 
_swigt__p_FXIcon, 
_swigt__p_FXHeader, 
_swigt__p_FXFoldingListSortFunc, 
_swigt__p_FXFoldingList, 
_swigt__p_FXTreeItem, 
0
};


/* -------- TYPE CONVERSION AND EQUIVALENCE RULES (END) -------- */


#ifdef __cplusplus
extern "C"
#endif
SWIGEXPORT(void) Init_treelist(void) {
    int i;
    
    SWIG_InitRuntime();
    
    for (i = 0; swig_types_initial[i]; i++) {
        swig_types[i] = SWIG_TypeRegister(swig_types_initial[i]);
        SWIG_define_class(swig_types[i]);
    }
    
    rb_define_const(mFox,"FOLDINGLIST_EXTENDEDSELECT", INT2NUM(FOLDINGLIST_EXTENDEDSELECT));
    rb_define_const(mFox,"FOLDINGLIST_SINGLESELECT", INT2NUM(FOLDINGLIST_SINGLESELECT));
    rb_define_const(mFox,"FOLDINGLIST_BROWSESELECT", INT2NUM(FOLDINGLIST_BROWSESELECT));
    rb_define_const(mFox,"FOLDINGLIST_MULTIPLESELECT", INT2NUM(FOLDINGLIST_MULTIPLESELECT));
    rb_define_const(mFox,"FOLDINGLIST_AUTOSELECT", INT2NUM(FOLDINGLIST_AUTOSELECT));
    rb_define_const(mFox,"FOLDINGLIST_SHOWS_LINES", INT2NUM(FOLDINGLIST_SHOWS_LINES));
    rb_define_const(mFox,"FOLDINGLIST_SHOWS_BOXES", INT2NUM(FOLDINGLIST_SHOWS_BOXES));
    rb_define_const(mFox,"FOLDINGLIST_ROOT_BOXES", INT2NUM(FOLDINGLIST_ROOT_BOXES));
    rb_define_const(mFox,"FOLDINGLIST_NORMAL", INT2NUM(FOLDINGLIST_NORMAL));
    
    cFXFoldingItem.klass = rb_define_class_under(mFox, "FXFoldingItem", ((swig_class *) SWIGTYPE_p_FXObject->clientdata)->klass);
    SWIG_TypeClientData(SWIGTYPE_p_FXFoldingItem, (void *) &cFXFoldingItem);
    rb_define_alloc_func(cFXFoldingItem.klass, _wrap_FXFoldingItem_allocate);
    rb_define_method(cFXFoldingItem.klass, "initialize", VALUEFUNC(_wrap_new_FXFoldingItem), -1);
    rb_define_method(cFXFoldingItem.klass, "getParent", VALUEFUNC(_wrap_FXFoldingItem_getParent), -1);
    rb_define_method(cFXFoldingItem.klass, "getNext", VALUEFUNC(_wrap_FXFoldingItem_getNext), -1);
    rb_define_method(cFXFoldingItem.klass, "getPrev", VALUEFUNC(_wrap_FXFoldingItem_getPrev), -1);
    rb_define_method(cFXFoldingItem.klass, "getFirst", VALUEFUNC(_wrap_FXFoldingItem_getFirst), -1);
    rb_define_method(cFXFoldingItem.klass, "getLast", VALUEFUNC(_wrap_FXFoldingItem_getLast), -1);
    rb_define_method(cFXFoldingItem.klass, "getBelow", VALUEFUNC(_wrap_FXFoldingItem_getBelow), -1);
    rb_define_method(cFXFoldingItem.klass, "getAbove", VALUEFUNC(_wrap_FXFoldingItem_getAbove), -1);
    rb_define_method(cFXFoldingItem.klass, "getNumChildren", VALUEFUNC(_wrap_FXFoldingItem_getNumChildren), -1);
    rb_define_method(cFXFoldingItem.klass, "getText", VALUEFUNC(_wrap_FXFoldingItem_getText), -1);
    rb_define_method(cFXFoldingItem.klass, "getOpenIcon", VALUEFUNC(_wrap_FXFoldingItem_getOpenIcon), -1);
    rb_define_method(cFXFoldingItem.klass, "getClosedIcon", VALUEFUNC(_wrap_FXFoldingItem_getClosedIcon), -1);
    rb_define_method(cFXFoldingItem.klass, "setData", VALUEFUNC(_wrap_FXFoldingItem_setData), -1);
    rb_define_method(cFXFoldingItem.klass, "getData", VALUEFUNC(_wrap_FXFoldingItem_getData), -1);
    rb_define_method(cFXFoldingItem.klass, "hasFocus", VALUEFUNC(_wrap_FXFoldingItem_hasFocus), -1);
    rb_define_method(cFXFoldingItem.klass, "isSelected", VALUEFUNC(_wrap_FXFoldingItem_isSelected), -1);
    rb_define_method(cFXFoldingItem.klass, "isOpened", VALUEFUNC(_wrap_FXFoldingItem_isOpened), -1);
    rb_define_method(cFXFoldingItem.klass, "isExpanded", VALUEFUNC(_wrap_FXFoldingItem_isExpanded), -1);
    rb_define_method(cFXFoldingItem.klass, "isEnabled", VALUEFUNC(_wrap_FXFoldingItem_isEnabled), -1);
    rb_define_method(cFXFoldingItem.klass, "isDraggable", VALUEFUNC(_wrap_FXFoldingItem_isDraggable), -1);
    rb_define_method(cFXFoldingItem.klass, "isIconOwned", VALUEFUNC(_wrap_FXFoldingItem_isIconOwned), -1);
    rb_define_method(cFXFoldingItem.klass, "hasItems?", VALUEFUNC(_wrap_FXFoldingItem_hasItemsq___), -1);
    rb_define_method(cFXFoldingItem.klass, "hasItems=", VALUEFUNC(_wrap_FXFoldingItem_hasItemse___), -1);
    rb_define_method(cFXFoldingItem.klass, "isChildOf", VALUEFUNC(_wrap_FXFoldingItem_isChildOf), -1);
    rb_define_method(cFXFoldingItem.klass, "isParentOf", VALUEFUNC(_wrap_FXFoldingItem_isParentOf), -1);
    rb_define_method(cFXFoldingItem.klass, "save", VALUEFUNC(_wrap_FXFoldingItem_save), -1);
    rb_define_method(cFXFoldingItem.klass, "load", VALUEFUNC(_wrap_FXFoldingItem_load), -1);
    rb_define_method(cFXFoldingItem.klass, "setText", VALUEFUNC(_wrap_FXFoldingItem_setText), -1);
    rb_define_method(cFXFoldingItem.klass, "setOpenIcon", VALUEFUNC(_wrap_FXFoldingItem_setOpenIcon), -1);
    rb_define_method(cFXFoldingItem.klass, "setClosedIcon", VALUEFUNC(_wrap_FXFoldingItem_setClosedIcon), -1);
    rb_define_method(cFXFoldingItem.klass, "setFocus", VALUEFUNC(_wrap_FXFoldingItem_setFocus), -1);
    rb_define_method(cFXFoldingItem.klass, "setSelected", VALUEFUNC(_wrap_FXFoldingItem_setSelected), -1);
    rb_define_method(cFXFoldingItem.klass, "setOpened", VALUEFUNC(_wrap_FXFoldingItem_setOpened), -1);
    rb_define_method(cFXFoldingItem.klass, "setExpanded", VALUEFUNC(_wrap_FXFoldingItem_setExpanded), -1);
    rb_define_method(cFXFoldingItem.klass, "setEnabled", VALUEFUNC(_wrap_FXFoldingItem_setEnabled), -1);
    rb_define_method(cFXFoldingItem.klass, "setDraggable", VALUEFUNC(_wrap_FXFoldingItem_setDraggable), -1);
    rb_define_method(cFXFoldingItem.klass, "setIconOwned", VALUEFUNC(_wrap_FXFoldingItem_setIconOwned), -1);
    rb_define_method(cFXFoldingItem.klass, "getWidth", VALUEFUNC(_wrap_FXFoldingItem_getWidth), -1);
    rb_define_method(cFXFoldingItem.klass, "getHeight", VALUEFUNC(_wrap_FXFoldingItem_getHeight), -1);
    rb_define_method(cFXFoldingItem.klass, "create", VALUEFUNC(_wrap_FXFoldingItem_create), -1);
    rb_define_method(cFXFoldingItem.klass, "detach", VALUEFUNC(_wrap_FXFoldingItem_detach), -1);
    rb_define_method(cFXFoldingItem.klass, "destroy", VALUEFUNC(_wrap_FXFoldingItem_destroy), -1);
    cFXFoldingItem.mark = (void (*)(void *)) FXRbFoldingItem::markfunc;
    cFXFoldingItem.destroy = (void (*)(void *)) FXRbFoldingItem::freefunc;
    
    cFXFoldingList.klass = rb_define_class_under(mFox, "FXFoldingList", ((swig_class *) SWIGTYPE_p_FXScrollArea->clientdata)->klass);
    SWIG_TypeClientData(SWIGTYPE_p_FXFoldingList, (void *) &cFXFoldingList);
    rb_define_alloc_func(cFXFoldingList.klass, _wrap_FXFoldingList_allocate);
    rb_define_method(cFXFoldingList.klass, "initialize", VALUEFUNC(_wrap_new_FXFoldingList), -1);
    rb_define_method(cFXFoldingList.klass, "onPaint", VALUEFUNC(_wrap_FXFoldingList_onPaint), -1);
    rb_define_method(cFXFoldingList.klass, "onEnter", VALUEFUNC(_wrap_FXFoldingList_onEnter), -1);
    rb_define_method(cFXFoldingList.klass, "onLeave", VALUEFUNC(_wrap_FXFoldingList_onLeave), -1);
    rb_define_method(cFXFoldingList.klass, "onUngrabbed", VALUEFUNC(_wrap_FXFoldingList_onUngrabbed), -1);
    rb_define_method(cFXFoldingList.klass, "onMotion", VALUEFUNC(_wrap_FXFoldingList_onMotion), -1);
    rb_define_method(cFXFoldingList.klass, "onKeyPress", VALUEFUNC(_wrap_FXFoldingList_onKeyPress), -1);
    rb_define_method(cFXFoldingList.klass, "onKeyRelease", VALUEFUNC(_wrap_FXFoldingList_onKeyRelease), -1);
    rb_define_method(cFXFoldingList.klass, "onLeftBtnPress", VALUEFUNC(_wrap_FXFoldingList_onLeftBtnPress), -1);
    rb_define_method(cFXFoldingList.klass, "onLeftBtnRelease", VALUEFUNC(_wrap_FXFoldingList_onLeftBtnRelease), -1);
    rb_define_method(cFXFoldingList.klass, "onRightBtnPress", VALUEFUNC(_wrap_FXFoldingList_onRightBtnPress), -1);
    rb_define_method(cFXFoldingList.klass, "onRightBtnRelease", VALUEFUNC(_wrap_FXFoldingList_onRightBtnRelease), -1);
    rb_define_method(cFXFoldingList.klass, "onHeaderChanged", VALUEFUNC(_wrap_FXFoldingList_onHeaderChanged), -1);
    rb_define_method(cFXFoldingList.klass, "onQueryTip", VALUEFUNC(_wrap_FXFoldingList_onQueryTip), -1);
    rb_define_method(cFXFoldingList.klass, "onQueryHelp", VALUEFUNC(_wrap_FXFoldingList_onQueryHelp), -1);
    rb_define_method(cFXFoldingList.klass, "onTipTimer", VALUEFUNC(_wrap_FXFoldingList_onTipTimer), -1);
    rb_define_method(cFXFoldingList.klass, "onFocusIn", VALUEFUNC(_wrap_FXFoldingList_onFocusIn), -1);
    rb_define_method(cFXFoldingList.klass, "onFocusOut", VALUEFUNC(_wrap_FXFoldingList_onFocusOut), -1);
    rb_define_method(cFXFoldingList.klass, "onAutoScroll", VALUEFUNC(_wrap_FXFoldingList_onAutoScroll), -1);
    rb_define_method(cFXFoldingList.klass, "onClicked", VALUEFUNC(_wrap_FXFoldingList_onClicked), -1);
    rb_define_method(cFXFoldingList.klass, "onDoubleClicked", VALUEFUNC(_wrap_FXFoldingList_onDoubleClicked), -1);
    rb_define_method(cFXFoldingList.klass, "onTripleClicked", VALUEFUNC(_wrap_FXFoldingList_onTripleClicked), -1);
    rb_define_method(cFXFoldingList.klass, "onCommand", VALUEFUNC(_wrap_FXFoldingList_onCommand), -1);
    rb_define_method(cFXFoldingList.klass, "onLookupTimer", VALUEFUNC(_wrap_FXFoldingList_onLookupTimer), -1);
    rb_define_singleton_method(cFXFoldingList.klass, "ascending", VALUEFUNC(_wrap_FXFoldingList_ascending), -1);
    rb_define_singleton_method(cFXFoldingList.klass, "descending", VALUEFUNC(_wrap_FXFoldingList_descending), -1);
    rb_define_singleton_method(cFXFoldingList.klass, "ascendingCase", VALUEFUNC(_wrap_FXFoldingList_ascendingCase), -1);
    rb_define_singleton_method(cFXFoldingList.klass, "descendingCase", VALUEFUNC(_wrap_FXFoldingList_descendingCase), -1);
    rb_define_const(cFXFoldingList.klass,"ID_LOOKUPTIMER", INT2NUM(FXFoldingList::ID_LOOKUPTIMER));
    rb_define_const(cFXFoldingList.klass,"ID_HEADER_CHANGE", INT2NUM(FXFoldingList::ID_HEADER_CHANGE));
    rb_define_const(cFXFoldingList.klass,"ID_LAST", INT2NUM(FXFoldingList::ID_LAST));
    rb_define_method(cFXFoldingList.klass, "getHeader", VALUEFUNC(_wrap_FXFoldingList_getHeader), -1);
    rb_define_method(cFXFoldingList.klass, "appendHeader", VALUEFUNC(_wrap_FXFoldingList_appendHeader), -1);
    rb_define_method(cFXFoldingList.klass, "removeHeader", VALUEFUNC(_wrap_FXFoldingList_removeHeader), -1);
    rb_define_method(cFXFoldingList.klass, "setHeaderText", VALUEFUNC(_wrap_FXFoldingList_setHeaderText), -1);
    rb_define_method(cFXFoldingList.klass, "getHeaderText", VALUEFUNC(_wrap_FXFoldingList_getHeaderText), -1);
    rb_define_method(cFXFoldingList.klass, "setHeaderIcon", VALUEFUNC(_wrap_FXFoldingList_setHeaderIcon), -1);
    rb_define_method(cFXFoldingList.klass, "getHeaderIcon", VALUEFUNC(_wrap_FXFoldingList_getHeaderIcon), -1);
    rb_define_method(cFXFoldingList.klass, "setHeaderSize", VALUEFUNC(_wrap_FXFoldingList_setHeaderSize), -1);
    rb_define_method(cFXFoldingList.klass, "getHeaderSize", VALUEFUNC(_wrap_FXFoldingList_getHeaderSize), -1);
    rb_define_method(cFXFoldingList.klass, "getNumHeaders", VALUEFUNC(_wrap_FXFoldingList_getNumHeaders), -1);
    rb_define_method(cFXFoldingList.klass, "getNumItems", VALUEFUNC(_wrap_FXFoldingList_getNumItems), -1);
    rb_define_method(cFXFoldingList.klass, "getNumVisible", VALUEFUNC(_wrap_FXFoldingList_getNumVisible), -1);
    rb_define_method(cFXFoldingList.klass, "setNumVisible", VALUEFUNC(_wrap_FXFoldingList_setNumVisible), -1);
    rb_define_method(cFXFoldingList.klass, "getFirstItem", VALUEFUNC(_wrap_FXFoldingList_getFirstItem), -1);
    rb_define_method(cFXFoldingList.klass, "getLastItem", VALUEFUNC(_wrap_FXFoldingList_getLastItem), -1);
    rb_define_method(cFXFoldingList.klass, "addItemFirst", VALUEFUNC(_wrap_FXFoldingList_addItemFirst), -1);
    rb_define_method(cFXFoldingList.klass, "addItemLast", VALUEFUNC(_wrap_FXFoldingList_addItemLast), -1);
    rb_define_method(cFXFoldingList.klass, "addItemAfter", VALUEFUNC(_wrap_FXFoldingList_addItemAfter), -1);
    rb_define_method(cFXFoldingList.klass, "addItemBefore", VALUEFUNC(_wrap_FXFoldingList_addItemBefore), -1);
    rb_define_method(cFXFoldingList.klass, "reparentItem", VALUEFUNC(_wrap_FXFoldingList_reparentItem), -1);
    rb_define_method(cFXFoldingList.klass, "moveItemBefore", VALUEFUNC(_wrap_FXFoldingList_moveItemBefore), -1);
    rb_define_method(cFXFoldingList.klass, "moveItemAfter", VALUEFUNC(_wrap_FXFoldingList_moveItemAfter), -1);
    rb_define_method(cFXFoldingList.klass, "removeItem", VALUEFUNC(_wrap_FXFoldingList_removeItem), -1);
    rb_define_method(cFXFoldingList.klass, "removeItems", VALUEFUNC(_wrap_FXFoldingList_removeItems), -1);
    rb_define_method(cFXFoldingList.klass, "clearItems", VALUEFUNC(_wrap_FXFoldingList_clearItems), -1);
    rb_define_method(cFXFoldingList.klass, "getItemWidth", VALUEFUNC(_wrap_FXFoldingList_getItemWidth), -1);
    rb_define_method(cFXFoldingList.klass, "getItemHeight", VALUEFUNC(_wrap_FXFoldingList_getItemHeight), -1);
    rb_define_method(cFXFoldingList.klass, "getItemAt", VALUEFUNC(_wrap_FXFoldingList_getItemAt), -1);
    rb_define_method(cFXFoldingList.klass, "findItem", VALUEFUNC(_wrap_FXFoldingList_findItem), -1);
    rb_define_method(cFXFoldingList.klass, "makeItemVisible", VALUEFUNC(_wrap_FXFoldingList_makeItemVisible), -1);
    rb_define_method(cFXFoldingList.klass, "setItemText", VALUEFUNC(_wrap_FXFoldingList_setItemText), -1);
    rb_define_method(cFXFoldingList.klass, "getItemText", VALUEFUNC(_wrap_FXFoldingList_getItemText), -1);
    rb_define_method(cFXFoldingList.klass, "setItemOpenIcon", VALUEFUNC(_wrap_FXFoldingList_setItemOpenIcon), -1);
    rb_define_method(cFXFoldingList.klass, "getItemOpenIcon", VALUEFUNC(_wrap_FXFoldingList_getItemOpenIcon), -1);
    rb_define_method(cFXFoldingList.klass, "setItemClosedIcon", VALUEFUNC(_wrap_FXFoldingList_setItemClosedIcon), -1);
    rb_define_method(cFXFoldingList.klass, "getItemClosedIcon", VALUEFUNC(_wrap_FXFoldingList_getItemClosedIcon), -1);
    rb_define_method(cFXFoldingList.klass, "setItemData", VALUEFUNC(_wrap_FXFoldingList_setItemData), -1);
    rb_define_method(cFXFoldingList.klass, "getItemData", VALUEFUNC(_wrap_FXFoldingList_getItemData), -1);
    rb_define_method(cFXFoldingList.klass, "isItemSelected", VALUEFUNC(_wrap_FXFoldingList_isItemSelected), -1);
    rb_define_method(cFXFoldingList.klass, "isItemCurrent", VALUEFUNC(_wrap_FXFoldingList_isItemCurrent), -1);
    rb_define_method(cFXFoldingList.klass, "isItemVisible", VALUEFUNC(_wrap_FXFoldingList_isItemVisible), -1);
    rb_define_method(cFXFoldingList.klass, "isItemOpened", VALUEFUNC(_wrap_FXFoldingList_isItemOpened), -1);
    rb_define_method(cFXFoldingList.klass, "isItemExpanded", VALUEFUNC(_wrap_FXFoldingList_isItemExpanded), -1);
    rb_define_method(cFXFoldingList.klass, "isItemLeaf", VALUEFUNC(_wrap_FXFoldingList_isItemLeaf), -1);
    rb_define_method(cFXFoldingList.klass, "isItemEnabled", VALUEFUNC(_wrap_FXFoldingList_isItemEnabled), -1);
    rb_define_method(cFXFoldingList.klass, "hitItem", VALUEFUNC(_wrap_FXFoldingList_hitItem), -1);
    rb_define_method(cFXFoldingList.klass, "updateItem", VALUEFUNC(_wrap_FXFoldingList_updateItem), -1);
    rb_define_method(cFXFoldingList.klass, "enableItem", VALUEFUNC(_wrap_FXFoldingList_enableItem), -1);
    rb_define_method(cFXFoldingList.klass, "disableItem", VALUEFUNC(_wrap_FXFoldingList_disableItem), -1);
    rb_define_method(cFXFoldingList.klass, "selectItem", VALUEFUNC(_wrap_FXFoldingList_selectItem), -1);
    rb_define_method(cFXFoldingList.klass, "deselectItem", VALUEFUNC(_wrap_FXFoldingList_deselectItem), -1);
    rb_define_method(cFXFoldingList.klass, "toggleItem", VALUEFUNC(_wrap_FXFoldingList_toggleItem), -1);
    rb_define_method(cFXFoldingList.klass, "extendSelection", VALUEFUNC(_wrap_FXFoldingList_extendSelection), -1);
    rb_define_method(cFXFoldingList.klass, "killSelection", VALUEFUNC(_wrap_FXFoldingList_killSelection), -1);
    rb_define_method(cFXFoldingList.klass, "openItem", VALUEFUNC(_wrap_FXFoldingList_openItem), -1);
    rb_define_method(cFXFoldingList.klass, "closeItem", VALUEFUNC(_wrap_FXFoldingList_closeItem), -1);
    rb_define_method(cFXFoldingList.klass, "collapseTree", VALUEFUNC(_wrap_FXFoldingList_collapseTree), -1);
    rb_define_method(cFXFoldingList.klass, "expandTree", VALUEFUNC(_wrap_FXFoldingList_expandTree), -1);
    rb_define_method(cFXFoldingList.klass, "setCurrentItem", VALUEFUNC(_wrap_FXFoldingList_setCurrentItem), -1);
    rb_define_method(cFXFoldingList.klass, "getCurrentItem", VALUEFUNC(_wrap_FXFoldingList_getCurrentItem), -1);
    rb_define_method(cFXFoldingList.klass, "setAnchorItem", VALUEFUNC(_wrap_FXFoldingList_setAnchorItem), -1);
    rb_define_method(cFXFoldingList.klass, "getAnchorItem", VALUEFUNC(_wrap_FXFoldingList_getAnchorItem), -1);
    rb_define_method(cFXFoldingList.klass, "getCursorItem", VALUEFUNC(_wrap_FXFoldingList_getCursorItem), -1);
    rb_define_method(cFXFoldingList.klass, "sortItems", VALUEFUNC(_wrap_FXFoldingList_sortItems), -1);
    rb_define_method(cFXFoldingList.klass, "sortRootItems", VALUEFUNC(_wrap_FXFoldingList_sortRootItems), -1);
    rb_define_method(cFXFoldingList.klass, "sortChildItems", VALUEFUNC(_wrap_FXFoldingList_sortChildItems), -1);
    rb_define_method(cFXFoldingList.klass, "getSortFunc", VALUEFUNC(_wrap_FXFoldingList_getSortFunc), -1);
    rb_define_method(cFXFoldingList.klass, "setSortFunc", VALUEFUNC(_wrap_FXFoldingList_setSortFunc), -1);
    rb_define_method(cFXFoldingList.klass, "setFont", VALUEFUNC(_wrap_FXFoldingList_setFont), -1);
    rb_define_method(cFXFoldingList.klass, "getFont", VALUEFUNC(_wrap_FXFoldingList_getFont), -1);
    rb_define_method(cFXFoldingList.klass, "setIndent", VALUEFUNC(_wrap_FXFoldingList_setIndent), -1);
    rb_define_method(cFXFoldingList.klass, "getIndent", VALUEFUNC(_wrap_FXFoldingList_getIndent), -1);
    rb_define_method(cFXFoldingList.klass, "getTextColor", VALUEFUNC(_wrap_FXFoldingList_getTextColor), -1);
    rb_define_method(cFXFoldingList.klass, "setTextColor", VALUEFUNC(_wrap_FXFoldingList_setTextColor), -1);
    rb_define_method(cFXFoldingList.klass, "getSelBackColor", VALUEFUNC(_wrap_FXFoldingList_getSelBackColor), -1);
    rb_define_method(cFXFoldingList.klass, "setSelBackColor", VALUEFUNC(_wrap_FXFoldingList_setSelBackColor), -1);
    rb_define_method(cFXFoldingList.klass, "getSelTextColor", VALUEFUNC(_wrap_FXFoldingList_getSelTextColor), -1);
    rb_define_method(cFXFoldingList.klass, "setSelTextColor", VALUEFUNC(_wrap_FXFoldingList_setSelTextColor), -1);
    rb_define_method(cFXFoldingList.klass, "getLineColor", VALUEFUNC(_wrap_FXFoldingList_getLineColor), -1);
    rb_define_method(cFXFoldingList.klass, "setLineColor", VALUEFUNC(_wrap_FXFoldingList_setLineColor), -1);
    rb_define_method(cFXFoldingList.klass, "getListStyle", VALUEFUNC(_wrap_FXFoldingList_getListStyle), -1);
    rb_define_method(cFXFoldingList.klass, "setListStyle", VALUEFUNC(_wrap_FXFoldingList_setListStyle), -1);
    rb_define_method(cFXFoldingList.klass, "setHelpText", VALUEFUNC(_wrap_FXFoldingList_setHelpText), -1);
    rb_define_method(cFXFoldingList.klass, "getHelpText", VALUEFUNC(_wrap_FXFoldingList_getHelpText), -1);
    rb_define_method(cFXFoldingList.klass, "save", VALUEFUNC(_wrap_FXFoldingList_save), -1);
    rb_define_method(cFXFoldingList.klass, "load", VALUEFUNC(_wrap_FXFoldingList_load), -1);
    rb_define_method(cFXFoldingList.klass, "create", VALUEFUNC(_wrap_FXFoldingList_create), -1);
    rb_define_method(cFXFoldingList.klass, "detach", VALUEFUNC(_wrap_FXFoldingList_detach), -1);
    rb_define_method(cFXFoldingList.klass, "destroy", VALUEFUNC(_wrap_FXFoldingList_destroy), -1);
    rb_define_method(cFXFoldingList.klass, "resize", VALUEFUNC(_wrap_FXFoldingList_resize), -1);
    rb_define_method(cFXFoldingList.klass, "getDefaultWidth", VALUEFUNC(_wrap_FXFoldingList_getDefaultWidth), -1);
    rb_define_method(cFXFoldingList.klass, "getDefaultHeight", VALUEFUNC(_wrap_FXFoldingList_getDefaultHeight), -1);
    rb_define_method(cFXFoldingList.klass, "getWidthForHeight", VALUEFUNC(_wrap_FXFoldingList_getWidthForHeight), -1);
    rb_define_method(cFXFoldingList.klass, "getHeightForWidth", VALUEFUNC(_wrap_FXFoldingList_getHeightForWidth), -1);
    rb_define_method(cFXFoldingList.klass, "canFocus", VALUEFUNC(_wrap_FXFoldingList_canFocus), -1);
    rb_define_method(cFXFoldingList.klass, "setFocus", VALUEFUNC(_wrap_FXFoldingList_setFocus), -1);
    rb_define_method(cFXFoldingList.klass, "killFocus", VALUEFUNC(_wrap_FXFoldingList_killFocus), -1);
    rb_define_method(cFXFoldingList.klass, "setDefault", VALUEFUNC(_wrap_FXFoldingList_setDefault), -1);
    rb_define_method(cFXFoldingList.klass, "enable", VALUEFUNC(_wrap_FXFoldingList_enable), -1);
    rb_define_method(cFXFoldingList.klass, "disable", VALUEFUNC(_wrap_FXFoldingList_disable), -1);
    rb_define_method(cFXFoldingList.klass, "raiseWindow", VALUEFUNC(_wrap_FXFoldingList_raiseWindow), -1);
    rb_define_method(cFXFoldingList.klass, "lower", VALUEFUNC(_wrap_FXFoldingList_lower), -1);
    rb_define_method(cFXFoldingList.klass, "move", VALUEFUNC(_wrap_FXFoldingList_move), -1);
    rb_define_method(cFXFoldingList.klass, "layout", VALUEFUNC(_wrap_FXFoldingList_layout), -1);
    rb_define_method(cFXFoldingList.klass, "recalc", VALUEFUNC(_wrap_FXFoldingList_recalc), -1);
    rb_define_method(cFXFoldingList.klass, "reparent", VALUEFUNC(_wrap_FXFoldingList_reparent), -1);
    rb_define_method(cFXFoldingList.klass, "show", VALUEFUNC(_wrap_FXFoldingList_show), -1);
    rb_define_method(cFXFoldingList.klass, "hide", VALUEFUNC(_wrap_FXFoldingList_hide), -1);
    rb_define_method(cFXFoldingList.klass, "isComposite", VALUEFUNC(_wrap_FXFoldingList_isComposite), -1);
    rb_define_method(cFXFoldingList.klass, "contains", VALUEFUNC(_wrap_FXFoldingList_contains), -1);
    rb_define_method(cFXFoldingList.klass, "doesSaveUnder", VALUEFUNC(_wrap_FXFoldingList_doesSaveUnder), -1);
    rb_define_method(cFXFoldingList.klass, "setBackColor", VALUEFUNC(_wrap_FXFoldingList_setBackColor), -1);
    rb_define_method(cFXFoldingList.klass, "getViewportHeight", VALUEFUNC(_wrap_FXFoldingList_getViewportHeight), -1);
    rb_define_method(cFXFoldingList.klass, "getViewportWidth", VALUEFUNC(_wrap_FXFoldingList_getViewportWidth), -1);
    rb_define_method(cFXFoldingList.klass, "getContentHeight", VALUEFUNC(_wrap_FXFoldingList_getContentHeight), -1);
    rb_define_method(cFXFoldingList.klass, "getContentWidth", VALUEFUNC(_wrap_FXFoldingList_getContentWidth), -1);
    rb_define_method(cFXFoldingList.klass, "position", VALUEFUNC(_wrap_FXFoldingList_position), -1);
    cFXFoldingList.mark = (void (*)(void *)) FXRbFoldingList::markfunc;
    cFXFoldingList.destroy = (void (*)(void *)) FXRbObject::freefunc;
    rb_define_const(mFox,"TREELIST_EXTENDEDSELECT", INT2NUM(TREELIST_EXTENDEDSELECT));
    rb_define_const(mFox,"TREELIST_SINGLESELECT", INT2NUM(TREELIST_SINGLESELECT));
    rb_define_const(mFox,"TREELIST_BROWSESELECT", INT2NUM(TREELIST_BROWSESELECT));
    rb_define_const(mFox,"TREELIST_MULTIPLESELECT", INT2NUM(TREELIST_MULTIPLESELECT));
    rb_define_const(mFox,"TREELIST_AUTOSELECT", INT2NUM(TREELIST_AUTOSELECT));
    rb_define_const(mFox,"TREELIST_SHOWS_LINES", INT2NUM(TREELIST_SHOWS_LINES));
    rb_define_const(mFox,"TREELIST_SHOWS_BOXES", INT2NUM(TREELIST_SHOWS_BOXES));
    rb_define_const(mFox,"TREELIST_ROOT_BOXES", INT2NUM(TREELIST_ROOT_BOXES));
    rb_define_const(mFox,"TREELIST_NORMAL", INT2NUM(TREELIST_NORMAL));
    
    cFXTreeItem.klass = rb_define_class_under(mFox, "FXTreeItem", ((swig_class *) SWIGTYPE_p_FXObject->clientdata)->klass);
    SWIG_TypeClientData(SWIGTYPE_p_FXTreeItem, (void *) &cFXTreeItem);
    rb_define_alloc_func(cFXTreeItem.klass, _wrap_FXTreeItem_allocate);
    rb_define_method(cFXTreeItem.klass, "initialize", VALUEFUNC(_wrap_new_FXTreeItem), -1);
    rb_define_method(cFXTreeItem.klass, "getText", VALUEFUNC(_wrap_FXTreeItem_getText), -1);
    rb_define_method(cFXTreeItem.klass, "getOpenIcon", VALUEFUNC(_wrap_FXTreeItem_getOpenIcon), -1);
    rb_define_method(cFXTreeItem.klass, "getClosedIcon", VALUEFUNC(_wrap_FXTreeItem_getClosedIcon), -1);
    rb_define_method(cFXTreeItem.klass, "getParent", VALUEFUNC(_wrap_FXTreeItem_getParent), -1);
    rb_define_method(cFXTreeItem.klass, "getNext", VALUEFUNC(_wrap_FXTreeItem_getNext), -1);
    rb_define_method(cFXTreeItem.klass, "getPrev", VALUEFUNC(_wrap_FXTreeItem_getPrev), -1);
    rb_define_method(cFXTreeItem.klass, "getFirst", VALUEFUNC(_wrap_FXTreeItem_getFirst), -1);
    rb_define_method(cFXTreeItem.klass, "getLast", VALUEFUNC(_wrap_FXTreeItem_getLast), -1);
    rb_define_method(cFXTreeItem.klass, "getBelow", VALUEFUNC(_wrap_FXTreeItem_getBelow), -1);
    rb_define_method(cFXTreeItem.klass, "getAbove", VALUEFUNC(_wrap_FXTreeItem_getAbove), -1);
    rb_define_method(cFXTreeItem.klass, "getNumChildren", VALUEFUNC(_wrap_FXTreeItem_getNumChildren), -1);
    rb_define_method(cFXTreeItem.klass, "setData", VALUEFUNC(_wrap_FXTreeItem_setData), -1);
    rb_define_method(cFXTreeItem.klass, "getData", VALUEFUNC(_wrap_FXTreeItem_getData), -1);
    rb_define_method(cFXTreeItem.klass, "hasFocus", VALUEFUNC(_wrap_FXTreeItem_hasFocus), -1);
    rb_define_method(cFXTreeItem.klass, "isSelected", VALUEFUNC(_wrap_FXTreeItem_isSelected), -1);
    rb_define_method(cFXTreeItem.klass, "isOpened", VALUEFUNC(_wrap_FXTreeItem_isOpened), -1);
    rb_define_method(cFXTreeItem.klass, "isExpanded", VALUEFUNC(_wrap_FXTreeItem_isExpanded), -1);
    rb_define_method(cFXTreeItem.klass, "isEnabled", VALUEFUNC(_wrap_FXTreeItem_isEnabled), -1);
    rb_define_method(cFXTreeItem.klass, "isDraggable", VALUEFUNC(_wrap_FXTreeItem_isDraggable), -1);
    rb_define_method(cFXTreeItem.klass, "setIconOwned", VALUEFUNC(_wrap_FXTreeItem_setIconOwned), -1);
    rb_define_method(cFXTreeItem.klass, "isIconOwned", VALUEFUNC(_wrap_FXTreeItem_isIconOwned), -1);
    rb_define_method(cFXTreeItem.klass, "hasItems?", VALUEFUNC(_wrap_FXTreeItem_hasItemsq___), -1);
    rb_define_method(cFXTreeItem.klass, "hasItems=", VALUEFUNC(_wrap_FXTreeItem_hasItemse___), -1);
    rb_define_method(cFXTreeItem.klass, "isChildOf", VALUEFUNC(_wrap_FXTreeItem_isChildOf), -1);
    rb_define_method(cFXTreeItem.klass, "isParentOf", VALUEFUNC(_wrap_FXTreeItem_isParentOf), -1);
    rb_define_method(cFXTreeItem.klass, "save", VALUEFUNC(_wrap_FXTreeItem_save), -1);
    rb_define_method(cFXTreeItem.klass, "load", VALUEFUNC(_wrap_FXTreeItem_load), -1);
    rb_define_method(cFXTreeItem.klass, "setText", VALUEFUNC(_wrap_FXTreeItem_setText), -1);
    rb_define_method(cFXTreeItem.klass, "setOpenIcon", VALUEFUNC(_wrap_FXTreeItem_setOpenIcon), -1);
    rb_define_method(cFXTreeItem.klass, "setClosedIcon", VALUEFUNC(_wrap_FXTreeItem_setClosedIcon), -1);
    rb_define_method(cFXTreeItem.klass, "setFocus", VALUEFUNC(_wrap_FXTreeItem_setFocus), -1);
    rb_define_method(cFXTreeItem.klass, "setSelected", VALUEFUNC(_wrap_FXTreeItem_setSelected), -1);
    rb_define_method(cFXTreeItem.klass, "setOpened", VALUEFUNC(_wrap_FXTreeItem_setOpened), -1);
    rb_define_method(cFXTreeItem.klass, "setExpanded", VALUEFUNC(_wrap_FXTreeItem_setExpanded), -1);
    rb_define_method(cFXTreeItem.klass, "setEnabled", VALUEFUNC(_wrap_FXTreeItem_setEnabled), -1);
    rb_define_method(cFXTreeItem.klass, "setDraggable", VALUEFUNC(_wrap_FXTreeItem_setDraggable), -1);
    rb_define_method(cFXTreeItem.klass, "getWidth", VALUEFUNC(_wrap_FXTreeItem_getWidth), -1);
    rb_define_method(cFXTreeItem.klass, "getHeight", VALUEFUNC(_wrap_FXTreeItem_getHeight), -1);
    rb_define_method(cFXTreeItem.klass, "create", VALUEFUNC(_wrap_FXTreeItem_create), -1);
    rb_define_method(cFXTreeItem.klass, "detach", VALUEFUNC(_wrap_FXTreeItem_detach), -1);
    rb_define_method(cFXTreeItem.klass, "destroy", VALUEFUNC(_wrap_FXTreeItem_destroy), -1);
    cFXTreeItem.mark = (void (*)(void *)) FXRbTreeItem::markfunc;
    cFXTreeItem.destroy = (void (*)(void *)) FXRbTreeItem::freefunc;
    
    SWIGTYPE_p_FXTreeItem->dcast = (swig_dycast_func) FXTreeItem_dynamic_cast;
    
    
    cFXTreeList.klass = rb_define_class_under(mFox, "FXTreeList", ((swig_class *) SWIGTYPE_p_FXScrollArea->clientdata)->klass);
    SWIG_TypeClientData(SWIGTYPE_p_FXTreeList, (void *) &cFXTreeList);
    rb_define_alloc_func(cFXTreeList.klass, _wrap_FXTreeList_allocate);
    rb_define_method(cFXTreeList.klass, "initialize", VALUEFUNC(_wrap_new_FXTreeList), -1);
    rb_define_method(cFXTreeList.klass, "onPaint", VALUEFUNC(_wrap_FXTreeList_onPaint), -1);
    rb_define_method(cFXTreeList.klass, "onEnter", VALUEFUNC(_wrap_FXTreeList_onEnter), -1);
    rb_define_method(cFXTreeList.klass, "onLeave", VALUEFUNC(_wrap_FXTreeList_onLeave), -1);
    rb_define_method(cFXTreeList.klass, "onUngrabbed", VALUEFUNC(_wrap_FXTreeList_onUngrabbed), -1);
    rb_define_method(cFXTreeList.klass, "onMotion", VALUEFUNC(_wrap_FXTreeList_onMotion), -1);
    rb_define_method(cFXTreeList.klass, "onKeyPress", VALUEFUNC(_wrap_FXTreeList_onKeyPress), -1);
    rb_define_method(cFXTreeList.klass, "onKeyRelease", VALUEFUNC(_wrap_FXTreeList_onKeyRelease), -1);
    rb_define_method(cFXTreeList.klass, "onLeftBtnPress", VALUEFUNC(_wrap_FXTreeList_onLeftBtnPress), -1);
    rb_define_method(cFXTreeList.klass, "onLeftBtnRelease", VALUEFUNC(_wrap_FXTreeList_onLeftBtnRelease), -1);
    rb_define_method(cFXTreeList.klass, "onRightBtnPress", VALUEFUNC(_wrap_FXTreeList_onRightBtnPress), -1);
    rb_define_method(cFXTreeList.klass, "onRightBtnRelease", VALUEFUNC(_wrap_FXTreeList_onRightBtnRelease), -1);
    rb_define_method(cFXTreeList.klass, "onQueryTip", VALUEFUNC(_wrap_FXTreeList_onQueryTip), -1);
    rb_define_method(cFXTreeList.klass, "onQueryHelp", VALUEFUNC(_wrap_FXTreeList_onQueryHelp), -1);
    rb_define_method(cFXTreeList.klass, "onTipTimer", VALUEFUNC(_wrap_FXTreeList_onTipTimer), -1);
    rb_define_method(cFXTreeList.klass, "onFocusIn", VALUEFUNC(_wrap_FXTreeList_onFocusIn), -1);
    rb_define_method(cFXTreeList.klass, "onFocusOut", VALUEFUNC(_wrap_FXTreeList_onFocusOut), -1);
    rb_define_method(cFXTreeList.klass, "onAutoScroll", VALUEFUNC(_wrap_FXTreeList_onAutoScroll), -1);
    rb_define_method(cFXTreeList.klass, "onClicked", VALUEFUNC(_wrap_FXTreeList_onClicked), -1);
    rb_define_method(cFXTreeList.klass, "onDoubleClicked", VALUEFUNC(_wrap_FXTreeList_onDoubleClicked), -1);
    rb_define_method(cFXTreeList.klass, "onTripleClicked", VALUEFUNC(_wrap_FXTreeList_onTripleClicked), -1);
    rb_define_method(cFXTreeList.klass, "onCommand", VALUEFUNC(_wrap_FXTreeList_onCommand), -1);
    rb_define_method(cFXTreeList.klass, "onLookupTimer", VALUEFUNC(_wrap_FXTreeList_onLookupTimer), -1);
    rb_define_singleton_method(cFXTreeList.klass, "ascending", VALUEFUNC(_wrap_FXTreeList_ascending), -1);
    rb_define_singleton_method(cFXTreeList.klass, "descending", VALUEFUNC(_wrap_FXTreeList_descending), -1);
    rb_define_singleton_method(cFXTreeList.klass, "ascendingCase", VALUEFUNC(_wrap_FXTreeList_ascendingCase), -1);
    rb_define_singleton_method(cFXTreeList.klass, "descendingCase", VALUEFUNC(_wrap_FXTreeList_descendingCase), -1);
    rb_define_const(cFXTreeList.klass,"ID_LOOKUPTIMER", INT2NUM(FXTreeList::ID_LOOKUPTIMER));
    rb_define_const(cFXTreeList.klass,"ID_LAST", INT2NUM(FXTreeList::ID_LAST));
    rb_define_method(cFXTreeList.klass, "getNumItems", VALUEFUNC(_wrap_FXTreeList_getNumItems), -1);
    rb_define_method(cFXTreeList.klass, "getNumVisible", VALUEFUNC(_wrap_FXTreeList_getNumVisible), -1);
    rb_define_method(cFXTreeList.klass, "setNumVisible", VALUEFUNC(_wrap_FXTreeList_setNumVisible), -1);
    rb_define_method(cFXTreeList.klass, "getFirstItem", VALUEFUNC(_wrap_FXTreeList_getFirstItem), -1);
    rb_define_method(cFXTreeList.klass, "getLastItem", VALUEFUNC(_wrap_FXTreeList_getLastItem), -1);
    rb_define_method(cFXTreeList.klass, "addItemFirst", VALUEFUNC(_wrap_FXTreeList_addItemFirst), -1);
    rb_define_method(cFXTreeList.klass, "addItemLast", VALUEFUNC(_wrap_FXTreeList_addItemLast), -1);
    rb_define_method(cFXTreeList.klass, "addItemAfter", VALUEFUNC(_wrap_FXTreeList_addItemAfter), -1);
    rb_define_method(cFXTreeList.klass, "addItemBefore", VALUEFUNC(_wrap_FXTreeList_addItemBefore), -1);
    rb_define_method(cFXTreeList.klass, "reparentItem", VALUEFUNC(_wrap_FXTreeList_reparentItem), -1);
    rb_define_method(cFXTreeList.klass, "moveItemBefore", VALUEFUNC(_wrap_FXTreeList_moveItemBefore), -1);
    rb_define_method(cFXTreeList.klass, "moveItemAfter", VALUEFUNC(_wrap_FXTreeList_moveItemAfter), -1);
    rb_define_method(cFXTreeList.klass, "removeItem", VALUEFUNC(_wrap_FXTreeList_removeItem), -1);
    rb_define_method(cFXTreeList.klass, "removeItems", VALUEFUNC(_wrap_FXTreeList_removeItems), -1);
    rb_define_method(cFXTreeList.klass, "clearItems", VALUEFUNC(_wrap_FXTreeList_clearItems), -1);
    rb_define_method(cFXTreeList.klass, "getItemWidth", VALUEFUNC(_wrap_FXTreeList_getItemWidth), -1);
    rb_define_method(cFXTreeList.klass, "getItemHeight", VALUEFUNC(_wrap_FXTreeList_getItemHeight), -1);
    rb_define_method(cFXTreeList.klass, "getItemAt", VALUEFUNC(_wrap_FXTreeList_getItemAt), -1);
    rb_define_method(cFXTreeList.klass, "findItem", VALUEFUNC(_wrap_FXTreeList_findItem), -1);
    rb_define_method(cFXTreeList.klass, "makeItemVisible", VALUEFUNC(_wrap_FXTreeList_makeItemVisible), -1);
    rb_define_method(cFXTreeList.klass, "setItemText", VALUEFUNC(_wrap_FXTreeList_setItemText), -1);
    rb_define_method(cFXTreeList.klass, "getItemText", VALUEFUNC(_wrap_FXTreeList_getItemText), -1);
    rb_define_method(cFXTreeList.klass, "setItemOpenIcon", VALUEFUNC(_wrap_FXTreeList_setItemOpenIcon), -1);
    rb_define_method(cFXTreeList.klass, "getItemOpenIcon", VALUEFUNC(_wrap_FXTreeList_getItemOpenIcon), -1);
    rb_define_method(cFXTreeList.klass, "setItemClosedIcon", VALUEFUNC(_wrap_FXTreeList_setItemClosedIcon), -1);
    rb_define_method(cFXTreeList.klass, "getItemClosedIcon", VALUEFUNC(_wrap_FXTreeList_getItemClosedIcon), -1);
    rb_define_method(cFXTreeList.klass, "setItemData", VALUEFUNC(_wrap_FXTreeList_setItemData), -1);
    rb_define_method(cFXTreeList.klass, "getItemData", VALUEFUNC(_wrap_FXTreeList_getItemData), -1);
    rb_define_method(cFXTreeList.klass, "isItemSelected", VALUEFUNC(_wrap_FXTreeList_isItemSelected), -1);
    rb_define_method(cFXTreeList.klass, "isItemCurrent", VALUEFUNC(_wrap_FXTreeList_isItemCurrent), -1);
    rb_define_method(cFXTreeList.klass, "isItemVisible", VALUEFUNC(_wrap_FXTreeList_isItemVisible), -1);
    rb_define_method(cFXTreeList.klass, "isItemOpened", VALUEFUNC(_wrap_FXTreeList_isItemOpened), -1);
    rb_define_method(cFXTreeList.klass, "isItemExpanded", VALUEFUNC(_wrap_FXTreeList_isItemExpanded), -1);
    rb_define_method(cFXTreeList.klass, "isItemLeaf", VALUEFUNC(_wrap_FXTreeList_isItemLeaf), -1);
    rb_define_method(cFXTreeList.klass, "isItemEnabled", VALUEFUNC(_wrap_FXTreeList_isItemEnabled), -1);
    rb_define_method(cFXTreeList.klass, "hitItem", VALUEFUNC(_wrap_FXTreeList_hitItem), -1);
    rb_define_method(cFXTreeList.klass, "updateItem", VALUEFUNC(_wrap_FXTreeList_updateItem), -1);
    rb_define_method(cFXTreeList.klass, "enableItem", VALUEFUNC(_wrap_FXTreeList_enableItem), -1);
    rb_define_method(cFXTreeList.klass, "disableItem", VALUEFUNC(_wrap_FXTreeList_disableItem), -1);
    rb_define_method(cFXTreeList.klass, "getCurrentItem", VALUEFUNC(_wrap_FXTreeList_getCurrentItem), -1);
    rb_define_method(cFXTreeList.klass, "setAnchorItem", VALUEFUNC(_wrap_FXTreeList_setAnchorItem), -1);
    rb_define_method(cFXTreeList.klass, "getAnchorItem", VALUEFUNC(_wrap_FXTreeList_getAnchorItem), -1);
    rb_define_method(cFXTreeList.klass, "getCursorItem", VALUEFUNC(_wrap_FXTreeList_getCursorItem), -1);
    rb_define_method(cFXTreeList.klass, "sortRootItems", VALUEFUNC(_wrap_FXTreeList_sortRootItems), -1);
    rb_define_method(cFXTreeList.klass, "sortItems", VALUEFUNC(_wrap_FXTreeList_sortItems), -1);
    rb_define_method(cFXTreeList.klass, "sortChildItems", VALUEFUNC(_wrap_FXTreeList_sortChildItems), -1);
    rb_define_method(cFXTreeList.klass, "setFont", VALUEFUNC(_wrap_FXTreeList_setFont), -1);
    rb_define_method(cFXTreeList.klass, "getFont", VALUEFUNC(_wrap_FXTreeList_getFont), -1);
    rb_define_method(cFXTreeList.klass, "setIndent", VALUEFUNC(_wrap_FXTreeList_setIndent), -1);
    rb_define_method(cFXTreeList.klass, "getIndent", VALUEFUNC(_wrap_FXTreeList_getIndent), -1);
    rb_define_method(cFXTreeList.klass, "getTextColor", VALUEFUNC(_wrap_FXTreeList_getTextColor), -1);
    rb_define_method(cFXTreeList.klass, "setTextColor", VALUEFUNC(_wrap_FXTreeList_setTextColor), -1);
    rb_define_method(cFXTreeList.klass, "getSelBackColor", VALUEFUNC(_wrap_FXTreeList_getSelBackColor), -1);
    rb_define_method(cFXTreeList.klass, "setSelBackColor", VALUEFUNC(_wrap_FXTreeList_setSelBackColor), -1);
    rb_define_method(cFXTreeList.klass, "getSelTextColor", VALUEFUNC(_wrap_FXTreeList_getSelTextColor), -1);
    rb_define_method(cFXTreeList.klass, "setSelTextColor", VALUEFUNC(_wrap_FXTreeList_setSelTextColor), -1);
    rb_define_method(cFXTreeList.klass, "getLineColor", VALUEFUNC(_wrap_FXTreeList_getLineColor), -1);
    rb_define_method(cFXTreeList.klass, "setLineColor", VALUEFUNC(_wrap_FXTreeList_setLineColor), -1);
    rb_define_method(cFXTreeList.klass, "getListStyle", VALUEFUNC(_wrap_FXTreeList_getListStyle), -1);
    rb_define_method(cFXTreeList.klass, "setListStyle", VALUEFUNC(_wrap_FXTreeList_setListStyle), -1);
    rb_define_method(cFXTreeList.klass, "setHelpText", VALUEFUNC(_wrap_FXTreeList_setHelpText), -1);
    rb_define_method(cFXTreeList.klass, "getHelpText", VALUEFUNC(_wrap_FXTreeList_getHelpText), -1);
    rb_define_method(cFXTreeList.klass, "save", VALUEFUNC(_wrap_FXTreeList_save), -1);
    rb_define_method(cFXTreeList.klass, "load", VALUEFUNC(_wrap_FXTreeList_load), -1);
    rb_define_method(cFXTreeList.klass, "create", VALUEFUNC(_wrap_FXTreeList_create), -1);
    rb_define_method(cFXTreeList.klass, "detach", VALUEFUNC(_wrap_FXTreeList_detach), -1);
    rb_define_method(cFXTreeList.klass, "destroy", VALUEFUNC(_wrap_FXTreeList_destroy), -1);
    rb_define_method(cFXTreeList.klass, "resize", VALUEFUNC(_wrap_FXTreeList_resize), -1);
    rb_define_method(cFXTreeList.klass, "getDefaultWidth", VALUEFUNC(_wrap_FXTreeList_getDefaultWidth), -1);
    rb_define_method(cFXTreeList.klass, "getDefaultHeight", VALUEFUNC(_wrap_FXTreeList_getDefaultHeight), -1);
    rb_define_method(cFXTreeList.klass, "getWidthForHeight", VALUEFUNC(_wrap_FXTreeList_getWidthForHeight), -1);
    rb_define_method(cFXTreeList.klass, "getHeightForWidth", VALUEFUNC(_wrap_FXTreeList_getHeightForWidth), -1);
    rb_define_method(cFXTreeList.klass, "canFocus", VALUEFUNC(_wrap_FXTreeList_canFocus), -1);
    rb_define_method(cFXTreeList.klass, "setFocus", VALUEFUNC(_wrap_FXTreeList_setFocus), -1);
    rb_define_method(cFXTreeList.klass, "killFocus", VALUEFUNC(_wrap_FXTreeList_killFocus), -1);
    rb_define_method(cFXTreeList.klass, "setDefault", VALUEFUNC(_wrap_FXTreeList_setDefault), -1);
    rb_define_method(cFXTreeList.klass, "enable", VALUEFUNC(_wrap_FXTreeList_enable), -1);
    rb_define_method(cFXTreeList.klass, "disable", VALUEFUNC(_wrap_FXTreeList_disable), -1);
    rb_define_method(cFXTreeList.klass, "raiseWindow", VALUEFUNC(_wrap_FXTreeList_raiseWindow), -1);
    rb_define_method(cFXTreeList.klass, "lower", VALUEFUNC(_wrap_FXTreeList_lower), -1);
    rb_define_method(cFXTreeList.klass, "move", VALUEFUNC(_wrap_FXTreeList_move), -1);
    rb_define_method(cFXTreeList.klass, "layout", VALUEFUNC(_wrap_FXTreeList_layout), -1);
    rb_define_method(cFXTreeList.klass, "recalc", VALUEFUNC(_wrap_FXTreeList_recalc), -1);
    rb_define_method(cFXTreeList.klass, "reparent", VALUEFUNC(_wrap_FXTreeList_reparent), -1);
    rb_define_method(cFXTreeList.klass, "show", VALUEFUNC(_wrap_FXTreeList_show), -1);
    rb_define_method(cFXTreeList.klass, "hide", VALUEFUNC(_wrap_FXTreeList_hide), -1);
    rb_define_method(cFXTreeList.klass, "isComposite", VALUEFUNC(_wrap_FXTreeList_isComposite), -1);
    rb_define_method(cFXTreeList.klass, "contains", VALUEFUNC(_wrap_FXTreeList_contains), -1);
    rb_define_method(cFXTreeList.klass, "doesSaveUnder", VALUEFUNC(_wrap_FXTreeList_doesSaveUnder), -1);
    rb_define_method(cFXTreeList.klass, "setBackColor", VALUEFUNC(_wrap_FXTreeList_setBackColor), -1);
    rb_define_method(cFXTreeList.klass, "getViewportHeight", VALUEFUNC(_wrap_FXTreeList_getViewportHeight), -1);
    rb_define_method(cFXTreeList.klass, "getViewportWidth", VALUEFUNC(_wrap_FXTreeList_getViewportWidth), -1);
    rb_define_method(cFXTreeList.klass, "getContentHeight", VALUEFUNC(_wrap_FXTreeList_getContentHeight), -1);
    rb_define_method(cFXTreeList.klass, "getContentWidth", VALUEFUNC(_wrap_FXTreeList_getContentWidth), -1);
    rb_define_method(cFXTreeList.klass, "position", VALUEFUNC(_wrap_FXTreeList_position), -1);
    rb_define_method(cFXTreeList.klass, "selectItem", VALUEFUNC(_wrap_FXTreeList_selectItem), -1);
    rb_define_method(cFXTreeList.klass, "deselectItem", VALUEFUNC(_wrap_FXTreeList_deselectItem), -1);
    rb_define_method(cFXTreeList.klass, "toggleItem", VALUEFUNC(_wrap_FXTreeList_toggleItem), -1);
    rb_define_method(cFXTreeList.klass, "extendSelection", VALUEFUNC(_wrap_FXTreeList_extendSelection), -1);
    rb_define_method(cFXTreeList.klass, "killSelection", VALUEFUNC(_wrap_FXTreeList_killSelection), -1);
    rb_define_method(cFXTreeList.klass, "openItem", VALUEFUNC(_wrap_FXTreeList_openItem), -1);
    rb_define_method(cFXTreeList.klass, "closeItem", VALUEFUNC(_wrap_FXTreeList_closeItem), -1);
    rb_define_method(cFXTreeList.klass, "collapseTree", VALUEFUNC(_wrap_FXTreeList_collapseTree), -1);
    rb_define_method(cFXTreeList.klass, "expandTree", VALUEFUNC(_wrap_FXTreeList_expandTree), -1);
    rb_define_method(cFXTreeList.klass, "setCurrentItem", VALUEFUNC(_wrap_FXTreeList_setCurrentItem), -1);
    cFXTreeList.mark = (void (*)(void *)) FXRbTreeList::markfunc;
    cFXTreeList.destroy = (void (*)(void *)) FXRbObject::freefunc;
    
    SWIGTYPE_p_FXTreeList->dcast = (swig_dycast_func) FXTreeList_dynamic_cast;
    
    rb_define_const(mFox,"DIRLIST_SHOWFILES", INT2NUM(DIRLIST_SHOWFILES));
    rb_define_const(mFox,"DIRLIST_SHOWHIDDEN", INT2NUM(DIRLIST_SHOWHIDDEN));
    rb_define_const(mFox,"DIRLIST_NO_OWN_ASSOC", INT2NUM(DIRLIST_NO_OWN_ASSOC));
    
    cFXDirItem.klass = rb_define_class_under(mFox, "FXDirItem", ((swig_class *) SWIGTYPE_p_FXTreeItem->clientdata)->klass);
    SWIG_TypeClientData(SWIGTYPE_p_FXDirItem, (void *) &cFXDirItem);
    rb_define_alloc_func(cFXDirItem.klass, _wrap_FXDirItem_allocate);
    rb_define_method(cFXDirItem.klass, "initialize", VALUEFUNC(_wrap_new_FXDirItem), -1);
    rb_define_method(cFXDirItem.klass, "isFile", VALUEFUNC(_wrap_FXDirItem_isFile), -1);
    rb_define_method(cFXDirItem.klass, "isDirectory", VALUEFUNC(_wrap_FXDirItem_isDirectory), -1);
    rb_define_method(cFXDirItem.klass, "isExecutable", VALUEFUNC(_wrap_FXDirItem_isExecutable), -1);
    rb_define_method(cFXDirItem.klass, "isSymlink", VALUEFUNC(_wrap_FXDirItem_isSymlink), -1);
    rb_define_method(cFXDirItem.klass, "isChardev", VALUEFUNC(_wrap_FXDirItem_isChardev), -1);
    rb_define_method(cFXDirItem.klass, "isBlockdev", VALUEFUNC(_wrap_FXDirItem_isBlockdev), -1);
    rb_define_method(cFXDirItem.klass, "isFifo", VALUEFUNC(_wrap_FXDirItem_isFifo), -1);
    rb_define_method(cFXDirItem.klass, "isSocket", VALUEFUNC(_wrap_FXDirItem_isSocket), -1);
    rb_define_method(cFXDirItem.klass, "getAssoc", VALUEFUNC(_wrap_FXDirItem_getAssoc), -1);
    rb_define_method(cFXDirItem.klass, "getSize", VALUEFUNC(_wrap_FXDirItem_getSize), -1);
    rb_define_method(cFXDirItem.klass, "getDate", VALUEFUNC(_wrap_FXDirItem_getDate), -1);
    rb_define_method(cFXDirItem.klass, "save", VALUEFUNC(_wrap_FXDirItem_save), -1);
    rb_define_method(cFXDirItem.klass, "load", VALUEFUNC(_wrap_FXDirItem_load), -1);
    rb_define_method(cFXDirItem.klass, "setText", VALUEFUNC(_wrap_FXDirItem_setText), -1);
    rb_define_method(cFXDirItem.klass, "setOpenIcon", VALUEFUNC(_wrap_FXDirItem_setOpenIcon), -1);
    rb_define_method(cFXDirItem.klass, "setClosedIcon", VALUEFUNC(_wrap_FXDirItem_setClosedIcon), -1);
    rb_define_method(cFXDirItem.klass, "setFocus", VALUEFUNC(_wrap_FXDirItem_setFocus), -1);
    rb_define_method(cFXDirItem.klass, "setSelected", VALUEFUNC(_wrap_FXDirItem_setSelected), -1);
    rb_define_method(cFXDirItem.klass, "setOpened", VALUEFUNC(_wrap_FXDirItem_setOpened), -1);
    rb_define_method(cFXDirItem.klass, "setExpanded", VALUEFUNC(_wrap_FXDirItem_setExpanded), -1);
    rb_define_method(cFXDirItem.klass, "setEnabled", VALUEFUNC(_wrap_FXDirItem_setEnabled), -1);
    rb_define_method(cFXDirItem.klass, "setDraggable", VALUEFUNC(_wrap_FXDirItem_setDraggable), -1);
    rb_define_method(cFXDirItem.klass, "getWidth", VALUEFUNC(_wrap_FXDirItem_getWidth), -1);
    rb_define_method(cFXDirItem.klass, "getHeight", VALUEFUNC(_wrap_FXDirItem_getHeight), -1);
    rb_define_method(cFXDirItem.klass, "create", VALUEFUNC(_wrap_FXDirItem_create), -1);
    rb_define_method(cFXDirItem.klass, "detach", VALUEFUNC(_wrap_FXDirItem_detach), -1);
    rb_define_method(cFXDirItem.klass, "destroy", VALUEFUNC(_wrap_FXDirItem_destroy), -1);
    cFXDirItem.mark = (void (*)(void *)) FXRbDirItem::markfunc;
    cFXDirItem.destroy = (void (*)(void *)) FXRbDirItem::freefunc;
    
    cFXDirList.klass = rb_define_class_under(mFox, "FXDirList", ((swig_class *) SWIGTYPE_p_FXTreeList->clientdata)->klass);
    SWIG_TypeClientData(SWIGTYPE_p_FXDirList, (void *) &cFXDirList);
    rb_define_alloc_func(cFXDirList.klass, _wrap_FXDirList_allocate);
    rb_define_method(cFXDirList.klass, "initialize", VALUEFUNC(_wrap_new_FXDirList), -1);
    rb_define_method(cFXDirList.klass, "onRefreshTimer", VALUEFUNC(_wrap_FXDirList_onRefreshTimer), -1);
    rb_define_method(cFXDirList.klass, "onBeginDrag", VALUEFUNC(_wrap_FXDirList_onBeginDrag), -1);
    rb_define_method(cFXDirList.klass, "onEndDrag", VALUEFUNC(_wrap_FXDirList_onEndDrag), -1);
    rb_define_method(cFXDirList.klass, "onDragged", VALUEFUNC(_wrap_FXDirList_onDragged), -1);
    rb_define_method(cFXDirList.klass, "onDNDEnter", VALUEFUNC(_wrap_FXDirList_onDNDEnter), -1);
    rb_define_method(cFXDirList.klass, "onDNDLeave", VALUEFUNC(_wrap_FXDirList_onDNDLeave), -1);
    rb_define_method(cFXDirList.klass, "onDNDMotion", VALUEFUNC(_wrap_FXDirList_onDNDMotion), -1);
    rb_define_method(cFXDirList.klass, "onDNDDrop", VALUEFUNC(_wrap_FXDirList_onDNDDrop), -1);
    rb_define_method(cFXDirList.klass, "onDNDRequest", VALUEFUNC(_wrap_FXDirList_onDNDRequest), -1);
    rb_define_method(cFXDirList.klass, "onCmdSetValue", VALUEFUNC(_wrap_FXDirList_onCmdSetValue), -1);
    rb_define_method(cFXDirList.klass, "onCmdSetStringValue", VALUEFUNC(_wrap_FXDirList_onCmdSetStringValue), -1);
    rb_define_method(cFXDirList.klass, "onCmdGetStringValue", VALUEFUNC(_wrap_FXDirList_onCmdGetStringValue), -1);
    rb_define_method(cFXDirList.klass, "onCmdToggleHidden", VALUEFUNC(_wrap_FXDirList_onCmdToggleHidden), -1);
    rb_define_method(cFXDirList.klass, "onUpdToggleHidden", VALUEFUNC(_wrap_FXDirList_onUpdToggleHidden), -1);
    rb_define_method(cFXDirList.klass, "onCmdShowHidden", VALUEFUNC(_wrap_FXDirList_onCmdShowHidden), -1);
    rb_define_method(cFXDirList.klass, "onUpdShowHidden", VALUEFUNC(_wrap_FXDirList_onUpdShowHidden), -1);
    rb_define_method(cFXDirList.klass, "onCmdHideHidden", VALUEFUNC(_wrap_FXDirList_onCmdHideHidden), -1);
    rb_define_method(cFXDirList.klass, "onUpdHideHidden", VALUEFUNC(_wrap_FXDirList_onUpdHideHidden), -1);
    rb_define_method(cFXDirList.klass, "onCmdToggleFiles", VALUEFUNC(_wrap_FXDirList_onCmdToggleFiles), -1);
    rb_define_method(cFXDirList.klass, "onUpdToggleFiles", VALUEFUNC(_wrap_FXDirList_onUpdToggleFiles), -1);
    rb_define_method(cFXDirList.klass, "onCmdShowFiles", VALUEFUNC(_wrap_FXDirList_onCmdShowFiles), -1);
    rb_define_method(cFXDirList.klass, "onUpdShowFiles", VALUEFUNC(_wrap_FXDirList_onUpdShowFiles), -1);
    rb_define_method(cFXDirList.klass, "onCmdHideFiles", VALUEFUNC(_wrap_FXDirList_onCmdHideFiles), -1);
    rb_define_method(cFXDirList.klass, "onUpdHideFiles", VALUEFUNC(_wrap_FXDirList_onUpdHideFiles), -1);
    rb_define_method(cFXDirList.klass, "onCmdSetPattern", VALUEFUNC(_wrap_FXDirList_onCmdSetPattern), -1);
    rb_define_method(cFXDirList.klass, "onUpdSetPattern", VALUEFUNC(_wrap_FXDirList_onUpdSetPattern), -1);
    rb_define_method(cFXDirList.klass, "onCmdSortReverse", VALUEFUNC(_wrap_FXDirList_onCmdSortReverse), -1);
    rb_define_method(cFXDirList.klass, "onUpdSortReverse", VALUEFUNC(_wrap_FXDirList_onUpdSortReverse), -1);
    rb_define_method(cFXDirList.klass, "onCmdSortCase", VALUEFUNC(_wrap_FXDirList_onCmdSortCase), -1);
    rb_define_method(cFXDirList.klass, "onUpdSortCase", VALUEFUNC(_wrap_FXDirList_onUpdSortCase), -1);
    rb_define_method(cFXDirList.klass, "onCmdRefresh", VALUEFUNC(_wrap_FXDirList_onCmdRefresh), -1);
    rb_define_singleton_method(cFXDirList.klass, "ascending", VALUEFUNC(_wrap_FXDirList_ascending), -1);
    rb_define_singleton_method(cFXDirList.klass, "descending", VALUEFUNC(_wrap_FXDirList_descending), -1);
    rb_define_singleton_method(cFXDirList.klass, "ascendingCase", VALUEFUNC(_wrap_FXDirList_ascendingCase), -1);
    rb_define_singleton_method(cFXDirList.klass, "descendingCase", VALUEFUNC(_wrap_FXDirList_descendingCase), -1);
    rb_define_const(cFXDirList.klass,"ID_REFRESHTIMER", INT2NUM(FXDirList::ID_REFRESHTIMER));
    rb_define_const(cFXDirList.klass,"ID_SHOW_FILES", INT2NUM(FXDirList::ID_SHOW_FILES));
    rb_define_const(cFXDirList.klass,"ID_HIDE_FILES", INT2NUM(FXDirList::ID_HIDE_FILES));
    rb_define_const(cFXDirList.klass,"ID_TOGGLE_FILES", INT2NUM(FXDirList::ID_TOGGLE_FILES));
    rb_define_const(cFXDirList.klass,"ID_SHOW_HIDDEN", INT2NUM(FXDirList::ID_SHOW_HIDDEN));
    rb_define_const(cFXDirList.klass,"ID_HIDE_HIDDEN", INT2NUM(FXDirList::ID_HIDE_HIDDEN));
    rb_define_const(cFXDirList.klass,"ID_TOGGLE_HIDDEN", INT2NUM(FXDirList::ID_TOGGLE_HIDDEN));
    rb_define_const(cFXDirList.klass,"ID_SET_PATTERN", INT2NUM(FXDirList::ID_SET_PATTERN));
    rb_define_const(cFXDirList.klass,"ID_SORT_REVERSE", INT2NUM(FXDirList::ID_SORT_REVERSE));
    rb_define_const(cFXDirList.klass,"ID_SORT_CASE", INT2NUM(FXDirList::ID_SORT_CASE));
    rb_define_const(cFXDirList.klass,"ID_REFRESH", INT2NUM(FXDirList::ID_REFRESH));
    rb_define_const(cFXDirList.klass,"ID_LAST", INT2NUM(FXDirList::ID_LAST));
    rb_define_method(cFXDirList.klass, "scan", VALUEFUNC(_wrap_FXDirList_scan), -1);
    rb_define_method(cFXDirList.klass, "isItemDirectory", VALUEFUNC(_wrap_FXDirList_isItemDirectory), -1);
    rb_define_method(cFXDirList.klass, "isItemFile", VALUEFUNC(_wrap_FXDirList_isItemFile), -1);
    rb_define_method(cFXDirList.klass, "isItemExecutable", VALUEFUNC(_wrap_FXDirList_isItemExecutable), -1);
    rb_define_method(cFXDirList.klass, "setCurrentFile", VALUEFUNC(_wrap_FXDirList_setCurrentFile), -1);
    rb_define_method(cFXDirList.klass, "getCurrentFile", VALUEFUNC(_wrap_FXDirList_getCurrentFile), -1);
    rb_define_method(cFXDirList.klass, "setDirectory", VALUEFUNC(_wrap_FXDirList_setDirectory), -1);
    rb_define_method(cFXDirList.klass, "getDirectory", VALUEFUNC(_wrap_FXDirList_getDirectory), -1);
    rb_define_method(cFXDirList.klass, "getItemPathname", VALUEFUNC(_wrap_FXDirList_getItemPathname), -1);
    rb_define_method(cFXDirList.klass, "getPathnameItem", VALUEFUNC(_wrap_FXDirList_getPathnameItem), -1);
    rb_define_method(cFXDirList.klass, "setPattern", VALUEFUNC(_wrap_FXDirList_setPattern), -1);
    rb_define_method(cFXDirList.klass, "getPattern", VALUEFUNC(_wrap_FXDirList_getPattern), -1);
    rb_define_method(cFXDirList.klass, "getMatchMode", VALUEFUNC(_wrap_FXDirList_getMatchMode), -1);
    rb_define_method(cFXDirList.klass, "setMatchMode", VALUEFUNC(_wrap_FXDirList_setMatchMode), -1);
    rb_define_method(cFXDirList.klass, "getShowFiles", VALUEFUNC(_wrap_FXDirList_getShowFiles), -1);
    rb_define_method(cFXDirList.klass, "setShowFiles", VALUEFUNC(_wrap_FXDirList_setShowFiles), -1);
    rb_define_method(cFXDirList.klass, "getShowHiddenFiles", VALUEFUNC(_wrap_FXDirList_getShowHiddenFiles), -1);
    rb_define_method(cFXDirList.klass, "setShowHiddenFiles", VALUEFUNC(_wrap_FXDirList_setShowHiddenFiles), -1);
    rb_define_method(cFXDirList.klass, "setAssociations", VALUEFUNC(_wrap_FXDirList_setAssociations), -1);
    rb_define_method(cFXDirList.klass, "getAssociations", VALUEFUNC(_wrap_FXDirList_getAssociations), -1);
    rb_define_method(cFXDirList.klass, "save", VALUEFUNC(_wrap_FXDirList_save), -1);
    rb_define_method(cFXDirList.klass, "load", VALUEFUNC(_wrap_FXDirList_load), -1);
    rb_define_method(cFXDirList.klass, "create", VALUEFUNC(_wrap_FXDirList_create), -1);
    rb_define_method(cFXDirList.klass, "detach", VALUEFUNC(_wrap_FXDirList_detach), -1);
    rb_define_method(cFXDirList.klass, "destroy", VALUEFUNC(_wrap_FXDirList_destroy), -1);
    rb_define_method(cFXDirList.klass, "resize", VALUEFUNC(_wrap_FXDirList_resize), -1);
    rb_define_method(cFXDirList.klass, "getDefaultWidth", VALUEFUNC(_wrap_FXDirList_getDefaultWidth), -1);
    rb_define_method(cFXDirList.klass, "getDefaultHeight", VALUEFUNC(_wrap_FXDirList_getDefaultHeight), -1);
    rb_define_method(cFXDirList.klass, "getWidthForHeight", VALUEFUNC(_wrap_FXDirList_getWidthForHeight), -1);
    rb_define_method(cFXDirList.klass, "getHeightForWidth", VALUEFUNC(_wrap_FXDirList_getHeightForWidth), -1);
    rb_define_method(cFXDirList.klass, "canFocus", VALUEFUNC(_wrap_FXDirList_canFocus), -1);
    rb_define_method(cFXDirList.klass, "setFocus", VALUEFUNC(_wrap_FXDirList_setFocus), -1);
    rb_define_method(cFXDirList.klass, "killFocus", VALUEFUNC(_wrap_FXDirList_killFocus), -1);
    rb_define_method(cFXDirList.klass, "setDefault", VALUEFUNC(_wrap_FXDirList_setDefault), -1);
    rb_define_method(cFXDirList.klass, "enable", VALUEFUNC(_wrap_FXDirList_enable), -1);
    rb_define_method(cFXDirList.klass, "disable", VALUEFUNC(_wrap_FXDirList_disable), -1);
    rb_define_method(cFXDirList.klass, "raiseWindow", VALUEFUNC(_wrap_FXDirList_raiseWindow), -1);
    rb_define_method(cFXDirList.klass, "lower", VALUEFUNC(_wrap_FXDirList_lower), -1);
    rb_define_method(cFXDirList.klass, "move", VALUEFUNC(_wrap_FXDirList_move), -1);
    rb_define_method(cFXDirList.klass, "layout", VALUEFUNC(_wrap_FXDirList_layout), -1);
    rb_define_method(cFXDirList.klass, "recalc", VALUEFUNC(_wrap_FXDirList_recalc), -1);
    rb_define_method(cFXDirList.klass, "reparent", VALUEFUNC(_wrap_FXDirList_reparent), -1);
    rb_define_method(cFXDirList.klass, "show", VALUEFUNC(_wrap_FXDirList_show), -1);
    rb_define_method(cFXDirList.klass, "hide", VALUEFUNC(_wrap_FXDirList_hide), -1);
    rb_define_method(cFXDirList.klass, "isComposite", VALUEFUNC(_wrap_FXDirList_isComposite), -1);
    rb_define_method(cFXDirList.klass, "contains", VALUEFUNC(_wrap_FXDirList_contains), -1);
    rb_define_method(cFXDirList.klass, "doesSaveUnder", VALUEFUNC(_wrap_FXDirList_doesSaveUnder), -1);
    rb_define_method(cFXDirList.klass, "setBackColor", VALUEFUNC(_wrap_FXDirList_setBackColor), -1);
    rb_define_method(cFXDirList.klass, "getViewportHeight", VALUEFUNC(_wrap_FXDirList_getViewportHeight), -1);
    rb_define_method(cFXDirList.klass, "getViewportWidth", VALUEFUNC(_wrap_FXDirList_getViewportWidth), -1);
    rb_define_method(cFXDirList.klass, "getContentHeight", VALUEFUNC(_wrap_FXDirList_getContentHeight), -1);
    rb_define_method(cFXDirList.klass, "getContentWidth", VALUEFUNC(_wrap_FXDirList_getContentWidth), -1);
    rb_define_method(cFXDirList.klass, "position", VALUEFUNC(_wrap_FXDirList_position), -1);
    rb_define_method(cFXDirList.klass, "selectItem", VALUEFUNC(_wrap_FXDirList_selectItem), -1);
    rb_define_method(cFXDirList.klass, "deselectItem", VALUEFUNC(_wrap_FXDirList_deselectItem), -1);
    rb_define_method(cFXDirList.klass, "toggleItem", VALUEFUNC(_wrap_FXDirList_toggleItem), -1);
    rb_define_method(cFXDirList.klass, "extendSelection", VALUEFUNC(_wrap_FXDirList_extendSelection), -1);
    rb_define_method(cFXDirList.klass, "killSelection", VALUEFUNC(_wrap_FXDirList_killSelection), -1);
    rb_define_method(cFXDirList.klass, "openItem", VALUEFUNC(_wrap_FXDirList_openItem), -1);
    rb_define_method(cFXDirList.klass, "closeItem", VALUEFUNC(_wrap_FXDirList_closeItem), -1);
    rb_define_method(cFXDirList.klass, "collapseTree", VALUEFUNC(_wrap_FXDirList_collapseTree), -1);
    rb_define_method(cFXDirList.klass, "expandTree", VALUEFUNC(_wrap_FXDirList_expandTree), -1);
    rb_define_method(cFXDirList.klass, "setCurrentItem", VALUEFUNC(_wrap_FXDirList_setCurrentItem), -1);
    cFXDirList.mark = (void (*)(void *)) FXRbDirList::markfunc;
    cFXDirList.destroy = (void (*)(void *)) FXRbObject::freefunc;
}

