/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 1.3.22
 * 
 * This file is not intended to be easily readable and contains a number of 
 * coding conventions designed to improve portability and efficiency. Do not make
 * changes to this file unless you know what you are doing--modify the SWIG 
 * interface file instead. 
 * ----------------------------------------------------------------------------- */

#define SWIG_NOINCLUDE

#ifdef __cplusplus
template<class T> class SwigValueWrapper {
    T *tt;
public:
    SwigValueWrapper() : tt(0) { }
    SwigValueWrapper(const SwigValueWrapper<T>& rhs) : tt(new T(*rhs.tt)) { }
    SwigValueWrapper(const T& t) : tt(new T(t)) { }
    ~SwigValueWrapper() { delete tt; } 
    SwigValueWrapper& operator=(const T& t) { delete tt; tt = new T(t); return *this; }
    operator T&() const { return *tt; }
    T *operator&() { return tt; }
private:
    SwigValueWrapper& operator=(const SwigValueWrapper<T>& rhs);
};                                                    
#endif

/* ruby.swg */
/* Implementation : RUBY */
#define SWIGRUBY 1

#include "ruby.h"

/* Flags for pointer conversion */
#define SWIG_POINTER_EXCEPTION     0x1
#define SWIG_POINTER_DISOWN        0x2

#define NUM2USHRT(n) (\
    (0 <= NUM2UINT(n) && NUM2UINT(n) <= USHRT_MAX)\
    ? (unsigned short) NUM2UINT(n) \
    : (rb_raise(rb_eArgError, "integer %d out of range of `unsigned short'",\
               NUM2UINT(n)), (short)0)\
)

#define NUM2SHRT(n) (\
    (SHRT_MIN <= NUM2INT(n) && NUM2INT(n) <= SHRT_MAX)\
    ? (short)NUM2INT(n)\
    : (rb_raise(rb_eArgError, "integer %d out of range of `short'",\
               NUM2INT(n)), (short)0)\
)

/* Ruby 1.7 defines NUM2LL(), LL2NUM() and ULL2NUM() macros */
#ifndef NUM2LL
#define NUM2LL(x) NUM2LONG((x))
#endif
#ifndef LL2NUM
#define LL2NUM(x) INT2NUM((long) (x))
#endif
#ifndef ULL2NUM
#define ULL2NUM(x) UINT2NUM((unsigned long) (x))
#endif

/* Ruby 1.7 doesn't (yet) define NUM2ULL() */
#ifndef NUM2ULL
#ifdef HAVE_LONG_LONG
#define NUM2ULL(x) rb_num2ull((x))
#else
#define NUM2ULL(x) NUM2ULONG(x)
#endif
#endif

/*
 * Need to be very careful about how these macros are defined, especially
 * when compiling C++ code or C code with an ANSI C compiler.
 *
 * VALUEFUNC(f) is a macro used to typecast a C function that implements
 * a Ruby method so that it can be passed as an argument to API functions
 * like rb_define_method() and rb_define_singleton_method().
 *
 * VOIDFUNC(f) is a macro used to typecast a C function that implements
 * either the "mark" or "free" stuff for a Ruby Data object, so that it
 * can be passed as an argument to API functions like Data_Wrap_Struct()
 * and Data_Make_Struct().
 */
 
#ifdef __cplusplus
#  ifndef RUBY_METHOD_FUNC /* These definitions should work for Ruby 1.4.6 */
#    define PROTECTFUNC(f) ((VALUE (*)()) f)
#    define VALUEFUNC(f) ((VALUE (*)()) f)
#    define VOIDFUNC(f)  ((void (*)()) f)
#  else
#    ifndef ANYARGS /* These definitions should work for Ruby 1.6 */
#      define PROTECTFUNC(f) ((VALUE (*)()) f)
#      define VALUEFUNC(f) ((VALUE (*)()) f)
#      define VOIDFUNC(f)  ((RUBY_DATA_FUNC) f)
#    else /* These definitions should work for Ruby 1.7+ */
#      define PROTECTFUNC(f) ((VALUE (*)(VALUE)) f)
#      define VALUEFUNC(f) ((VALUE (*)(ANYARGS)) f)
#      define VOIDFUNC(f)  ((RUBY_DATA_FUNC) f)
#    endif
#  endif
#else
#  define VALUEFUNC(f) (f)
#  define VOIDFUNC(f) (f)
#endif

typedef struct {
  VALUE klass;
  VALUE mImpl;
  void  (*mark)(void *);
  void  (*destroy)(void *);
} swig_class;

/* Don't use for expressions have side effect */
#ifndef RB_STRING_VALUE
#define RB_STRING_VALUE(s) (TYPE(s) == T_STRING ? (s) : (*(volatile VALUE *)&(s) = rb_str_to_str(s)))
#endif
#ifndef StringValue
#define StringValue(s) RB_STRING_VALUE(s)
#endif
#ifndef StringValuePtr
#define StringValuePtr(s) RSTRING(RB_STRING_VALUE(s))->ptr
#endif
#ifndef StringValueLen
#define StringValueLen(s) RSTRING(RB_STRING_VALUE(s))->len
#endif
#ifndef SafeStringValue
#define SafeStringValue(v) do {\
    StringValue(v);\
    rb_check_safe_str(v);\
} while (0)
#endif

#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
#define rb_define_alloc_func(klass, func) rb_define_singleton_method((klass), "new", VALUEFUNC((func)), -1)
#define rb_undef_alloc_func(klass) rb_undef_method(CLASS_OF((klass)), "new")
#endif

/* Contract support */

#define SWIG_contract_assert(expr, msg) if (!(expr)) { rb_raise(rb_eRuntimeError, (char *) msg ); } else


/*************************************************************** -*- c -*-
 * ruby/precommon.swg
 *
 * Rename all exported symbols from common.swg, to avoid symbol
 * clashes if multiple interpreters are included
 *
 ************************************************************************/

#define SWIG_TypeRegister    SWIG_Ruby_TypeRegister
#define SWIG_TypeCheck       SWIG_Ruby_TypeCheck
#define SWIG_TypeCast        SWIG_Ruby_TypeCast
#define SWIG_TypeDynamicCast SWIG_Ruby_TypeDynamicCast
#define SWIG_TypeName        SWIG_Ruby_TypeName
#define SWIG_TypePrettyName  SWIG_Ruby_TypePrettyName
#define SWIG_TypeQuery       SWIG_Ruby_TypeQuery
#define SWIG_TypeClientData  SWIG_Ruby_TypeClientData
#define SWIG_PackData        SWIG_Ruby_PackData 
#define SWIG_UnpackData      SWIG_Ruby_UnpackData 

/* Also rename all exported symbols from rubydef.swig */

/* Common SWIG API */
#define SWIG_ConvertPtr(obj, pp, type, flags) \
  SWIG_Ruby_ConvertPtr(obj, pp, type, flags)
#define SWIG_NewPointerObj(p, type, flags) \
  SWIG_Ruby_NewPointerObj(p, type, flags)
#define SWIG_MustGetPtr(p, type, argnum, flags) \
  SWIG_Ruby_MustGetPtr(p, type, argnum, flags)

/* Ruby-specific SWIG API */

#define SWIG_InitRuntime() \
  SWIG_Ruby_InitRuntime()
#define SWIG_define_class(ty) \
  SWIG_Ruby_define_class(ty)
#define SWIG_NewClassInstance(value, ty) \
  SWIG_Ruby_NewClassInstance(value, ty)
#define SWIG_MangleStr(value) \
  SWIG_Ruby_MangleStr(value)
#define SWIG_CheckConvert(value, ty) \
  SWIG_Ruby_CheckConvert(value, ty)
#define SWIG_NewPackedObj(ptr, sz, ty) \
  SWIG_Ruby_NewPackedObj(ptr, sz, ty)
#define SWIG_ConvertPacked(obj, ptr, sz, ty, flags) \
  SWIG_Ruby_ConvertPacked(obj, ptr, sz, ty, flags)


/***********************************************************************
 * common.swg
 *
 *     This file contains generic SWIG runtime support for pointer
 *     type checking as well as a few commonly used macros to control
 *     external linkage.
 *
 * Author : David Beazley (beazley@cs.uchicago.edu)
 *
 * Copyright (c) 1999-2000, The University of Chicago
 * 
 * This file may be freely redistributed without license or fee provided
 * this copyright message remains intact.
 ************************************************************************/

#include <string.h>

#if defined(_WIN32) || defined(__WIN32__) || defined(__CYGWIN__)
#  if defined(_MSC_VER) || defined(__GNUC__)
#    if defined(STATIC_LINKED)
#      define SWIGEXPORT(a) a
#      define SWIGIMPORT(a) extern a
#    else
#      define SWIGEXPORT(a) __declspec(dllexport) a
#      define SWIGIMPORT(a) extern a
#    endif
#  else
#    if defined(__BORLANDC__)
#      define SWIGEXPORT(a) a _export
#      define SWIGIMPORT(a) a _export
#    else
#      define SWIGEXPORT(a) a
#      define SWIGIMPORT(a) a
#    endif
#  endif
#else
#  define SWIGEXPORT(a) a
#  define SWIGIMPORT(a) a
#endif

#ifdef SWIG_GLOBAL
#  define SWIGRUNTIME(a) SWIGEXPORT(a)
#else
#  define SWIGRUNTIME(a) static a
#endif

#ifdef __cplusplus
extern "C" {
#endif

typedef void *(*swig_converter_func)(void *);
typedef struct swig_type_info *(*swig_dycast_func)(void **);

typedef struct swig_type_info {
  const char             *name;
  swig_converter_func     converter;
  const char             *str;
  void                   *clientdata;
  swig_dycast_func        dcast;
  struct swig_type_info  *next;
  struct swig_type_info  *prev;
} swig_type_info;

#ifdef SWIG_NOINCLUDE

SWIGIMPORT(swig_type_info *) SWIG_TypeRegister(swig_type_info *);
SWIGIMPORT(swig_type_info *) SWIG_TypeCheck(char *c, swig_type_info *);
SWIGIMPORT(void *)           SWIG_TypeCast(swig_type_info *, void *);
SWIGIMPORT(swig_type_info *) SWIG_TypeDynamicCast(swig_type_info *, void **);
SWIGIMPORT(const char *)     SWIG_TypeName(const swig_type_info *);
SWIGIMPORT(const char *)     SWIG_TypePrettyName(const swig_type_info *);
SWIGIMPORT(swig_type_info *) SWIG_TypeQuery(const char *);
SWIGIMPORT(void)             SWIG_TypeClientData(swig_type_info *, void *);
SWIGIMPORT(char *)           SWIG_PackData(char *, void *, int);
SWIGIMPORT(char *)           SWIG_UnpackData(char *, void *, int);

#else

static swig_type_info *swig_type_list = 0;
static swig_type_info **swig_type_list_handle = &swig_type_list;

/* Register a type mapping with the type-checking */
SWIGRUNTIME(swig_type_info *)
SWIG_TypeRegister(swig_type_info *ti) {
  swig_type_info *tc, *head, *ret, *next;
  /* Check to see if this type has already been registered */
  tc = *swig_type_list_handle;
  while (tc) {
    if (strcmp(tc->name, ti->name) == 0) {
      /* Already exists in the table.  Just add additional types to the list */
      if (tc->clientdata) ti->clientdata = tc->clientdata;
      head = tc;
      next = tc->next;
      goto l1;
    }
    tc = tc->prev;
  }
  head = ti;
  next = 0;

  /* Place in list */
  ti->prev = *swig_type_list_handle;
  *swig_type_list_handle = ti;

  /* Build linked lists */
  l1:
  ret = head;
  tc = ti + 1;
  /* Patch up the rest of the links */
  while (tc->name) {
    head->next = tc;
    tc->prev = head;
    head = tc;
    tc++;
  }
  if (next) next->prev = head;
  head->next = next;
  return ret;
}

/* Check the typename */
SWIGRUNTIME(swig_type_info *) 
SWIG_TypeCheck(char *c, swig_type_info *ty) {
  swig_type_info *s;
  if (!ty) return 0;        /* Void pointer */
  s = ty->next;             /* First element always just a name */
  do {
    if (strcmp(s->name,c) == 0) {
      if (s == ty->next) return s;
      /* Move s to the top of the linked list */
      s->prev->next = s->next;
      if (s->next) {
        s->next->prev = s->prev;
      }
      /* Insert s as second element in the list */
      s->next = ty->next;
      if (ty->next) ty->next->prev = s;
      ty->next = s;
      s->prev = ty;
      return s;
    }
    s = s->next;
  } while (s && (s != ty->next));
  return 0;
}

/* Cast a pointer up an inheritance hierarchy */
SWIGRUNTIME(void *) 
SWIG_TypeCast(swig_type_info *ty, void *ptr) {
  if ((!ty) || (!ty->converter)) return ptr;
  return (*ty->converter)(ptr);
}

/* Dynamic pointer casting. Down an inheritance hierarchy */
SWIGRUNTIME(swig_type_info *) 
SWIG_TypeDynamicCast(swig_type_info *ty, void **ptr) {
  swig_type_info *lastty = ty;
  if (!ty || !ty->dcast) return ty;
  while (ty && (ty->dcast)) {
    ty = (*ty->dcast)(ptr);
    if (ty) lastty = ty;
  }
  return lastty;
}

/* Return the name associated with this type */
SWIGRUNTIME(const char *)
SWIG_TypeName(const swig_type_info *ty) {
  return ty->name;
}

/* Return the pretty name associated with this type,
   that is an unmangled type name in a form presentable to the user.
*/
SWIGRUNTIME(const char *)
SWIG_TypePrettyName(const swig_type_info *type) {
  /* The "str" field contains the equivalent pretty names of the
     type, separated by vertical-bar characters.  We choose
     to print the last name, as it is often (?) the most
     specific. */
  if (type->str != NULL) {
    const char *last_name = type->str;
    const char *s;
    for (s = type->str; *s; s++)
      if (*s == '|') last_name = s+1;
    return last_name;
  }
  else
    return type->name;
}

/* 
   Compare two type names skipping the space characters, therefore
   "char*" == "char *" and "Class<int>" == "Class<int >", etc.

   Return 0 when the two name types are equivalent, as in
   strncmp, but skipping ' '.
*/
static int
SWIG_TypeNameComp(const char *f1, const char *l1,
		  const char *f2, const char *l2) {
  for (;(f1 != l1) && (f2 != l2); ++f1, ++f2) {
    while ((*f1 == ' ') && (f1 != l1)) ++f1;
    while ((*f2 == ' ') && (f2 != l2)) ++f2;
    if (*f1 != *f2) return *f1 - *f2;
  }
  return (l1 - f1) - (l2 - f2);
}

/*
  Check type equivalence in a name list like <name1>|<name2>|...
*/
static int
SWIG_TypeEquiv(const char *nb, const char *tb) {
  int equiv = 0;
  const char* te = tb + strlen(tb);
  const char* ne = nb;
  while (!equiv && *ne) {
    for (nb = ne; *ne; ++ne) {
      if (*ne == '|') break;
    }
    equiv = SWIG_TypeNameComp(nb, ne, tb, te) == 0;
    if (*ne) ++ne;
  }
  return equiv;
}
  

/* Search for a swig_type_info structure */
SWIGRUNTIME(swig_type_info *)
SWIG_TypeQuery(const char *name) {
  swig_type_info *ty = *swig_type_list_handle;
  while (ty) {
    if (ty->str && (SWIG_TypeEquiv(ty->str,name))) return ty;
    if (ty->name && (strcmp(name,ty->name) == 0)) return ty;
    ty = ty->prev;
  }
  return 0;
}

/* Set the clientdata field for a type */
SWIGRUNTIME(void)
SWIG_TypeClientData(swig_type_info *ti, void *clientdata) {
  swig_type_info *tc, *equiv;
  if (ti->clientdata == clientdata) return;
  ti->clientdata = clientdata;
  equiv = ti->next;
  while (equiv) {
    if (!equiv->converter) {
      tc = *swig_type_list_handle;
      while (tc) {
        if ((strcmp(tc->name, equiv->name) == 0))
          SWIG_TypeClientData(tc,clientdata);
        tc = tc->prev;
      }
    }
    equiv = equiv->next;
  }
}

/* Pack binary data into a string */
SWIGRUNTIME(char *)
SWIG_PackData(char *c, void *ptr, int sz) {
  static char hex[17] = "0123456789abcdef";
  unsigned char *u = (unsigned char *) ptr;
  const unsigned char *eu =  u + sz;
  register unsigned char uu;
  for (; u != eu; ++u) {
    uu = *u;
    *(c++) = hex[(uu & 0xf0) >> 4];
    *(c++) = hex[uu & 0xf];
  }
  return c;
}

/* Unpack binary data from a string */
SWIGRUNTIME(char *)
SWIG_UnpackData(char *c, void *ptr, int sz) {
  register unsigned char uu = 0;
  register int d;
  unsigned char *u = (unsigned char *) ptr;
  const unsigned char *eu =  u + sz;
  for (; u != eu; ++u) {
    d = *(c++);
    if ((d >= '0') && (d <= '9'))
      uu = ((d - '0') << 4);
    else if ((d >= 'a') && (d <= 'f'))
      uu = ((d - ('a'-10)) << 4);
    d = *(c++);
    if ((d >= '0') && (d <= '9'))
      uu |= (d - '0');
    else if ((d >= 'a') && (d <= 'f'))
      uu |= (d - ('a'-10));
    *u = uu;
  }
  return c;
}

#endif

#ifdef __cplusplus
}
#endif

/* rubydec.swg -*- c -*- */
#ifdef __cplusplus
extern "C" {
#endif

SWIGIMPORT(void)   SWIG_Ruby_InitRuntime(void);
SWIGIMPORT(void)   SWIG_Ruby_define_class(swig_type_info *);
SWIGIMPORT(VALUE)  SWIG_Ruby_NewPointerObj(void *, swig_type_info *, int);
SWIGIMPORT(VALUE)  SWIG_Ruby_NewClassInstance(VALUE, swig_type_info *);
SWIGIMPORT(char *) SWIG_Ruby_MangleStr(VALUE);
SWIGIMPORT(int)    SWIG_Ruby_ConvertPtr(VALUE, void**, swig_type_info *, int);
SWIGIMPORT(void *) SWIG_Ruby_MustGetPtr(VALUE, swig_type_info *, int, int);
SWIGIMPORT(int)    SWIG_Ruby_CheckConvert(VALUE, swig_type_info *);
SWIGIMPORT(VALUE)  SWIG_Ruby_NewPackedObj(void *ptr, int sz, swig_type_info *type);
SWIGIMPORT(void)   SWIG_Ruby_ConvertPacked(VALUE obj, void *ptr, int sz, swig_type_info *ty, int flags);

#ifdef __cplusplus
}
#endif


/* -------- TYPES TABLE (BEGIN) -------- */

#define  SWIGTYPE_p_FXDriveBox swig_types[0] 
#define  SWIGTYPE_p_FXToolBar swig_types[1] 
#define  SWIGTYPE_p_FXTreeItem swig_types[2] 
#define  SWIGTYPE_p_FXComposite swig_types[3] 
#define  SWIGTYPE_p_FXToolTip swig_types[4] 
#define  SWIGTYPE_p_FXTabBook swig_types[5] 
#define  SWIGTYPE_p_FXImage swig_types[6] 
#define  SWIGTYPE_p_FXId swig_types[7] 
#define  SWIGTYPE_p_FXShell swig_types[8] 
#define  SWIGTYPE_p_FXScrollArea swig_types[9] 
#define  SWIGTYPE_p_FXScrollCorner swig_types[10] 
#define  SWIGTYPE_p_FXWindow swig_types[11] 
#define  SWIGTYPE_p_FXTopWindow swig_types[12] 
#define  SWIGTYPE_p_FXCanvas swig_types[13] 
#define  SWIGTYPE_p_FXIcon swig_types[14] 
#define  SWIGTYPE_p_FXComboBox swig_types[15] 
#define  SWIGTYPE_p_FXObject swig_types[16] 
#define  SWIGTYPE_p_FXRealSpinner swig_types[17] 
#define  SWIGTYPE_p_FXSpinner swig_types[18] 
#define  SWIGTYPE_p_FXPacker swig_types[19] 
#define  SWIGTYPE_p_FXScrollBar swig_types[20] 
#define  SWIGTYPE_p_FXDirBox swig_types[21] 
#define  SWIGTYPE_p_FXToolBarGrip swig_types[22] 
#define  SWIGTYPE_p_FXDragCorner swig_types[23] 
#define  SWIGTYPE_p_FXFileDict swig_types[24] 
#define  SWIGTYPE_p_FXDirSelector swig_types[25] 
#define  SWIGTYPE_p_FXFileSelector swig_types[26] 
#define  SWIGTYPE_p_FXColorSelector swig_types[27] 
#define  SWIGTYPE_p_FXFontSelector swig_types[28] 
#define  SWIGTYPE_p_FXDrawable swig_types[29] 
#define  SWIGTYPE_p_FXStream swig_types[30] 
#define  SWIGTYPE_p_FXTreeListBox swig_types[31] 
#define  SWIGTYPE_p_FXListBox swig_types[32] 
#define  SWIGTYPE_p_FXFontDesc swig_types[33] 
#define  SWIGTYPE_p_FXApp swig_types[34] 
#define  SWIGTYPE_p_FXFont swig_types[35] 
#define  SWIGTYPE_p_FXTabBar swig_types[36] 
#define  SWIGTYPE_p_FXImageView swig_types[37] 
#define  SWIGTYPE_p_FXButton swig_types[38] 
#define  SWIGTYPE_p_FXToolBarShell swig_types[39] 
static swig_type_info *swig_types[41];

/* -------- TYPES TABLE (END) -------- */

#define SWIG_init    Init_ui
#define SWIG_name    "Ui"


static void SWIG_AsVal(VALUE obj, int *val)
{
    *val = (int) NUM2INT(obj);
}


#include "FXRbCommon.h"


inline FXColor to_FXColor(VALUE obj){
  if(TYPE(obj)==T_STRING){
    return fxcolorfromname(StringValuePtr(obj));
    }
  else if(TYPE(obj)==T_SYMBOL){
    return fxcolorfromname(rb_id2name(SYM2ID(obj)));
    }
  else{
    return NUM2ULONG(obj);
    }
  }


inline FXString to_FXString(VALUE obj){
  if(!NIL_P(obj)){
    Check_Type(obj,T_STRING);
    return FXString(STR2CSTR(obj));
    }
  else{
    return FXString::null;
    }
  }


inline FXbool to_FXbool(VALUE obj){
  if (obj == Qtrue || obj == Qfalse){
    return (obj == Qtrue) ? TRUE : FALSE;
    }
  else{
    return static_cast<FXbool>(NUM2UINT(obj));
    }
  }


static swig_type_info* FXEventTypeInfo=0;

inline void* to_FXEvent(VALUE obj){
  void* ptr;
  if(!FXEventTypeInfo){
    FXEventTypeInfo=SWIG_TypeQuery("FXEvent *");
    FXASSERT(FXEventTypeInfo!=0);
    }
  SWIG_ConvertPtr(obj,&ptr,FXEventTypeInfo,1);
  return ptr;
  }

FXSpinner *new_FXSpinner(FXComposite *p,FXint cols,FXObject *tgt,FXSelector sel,FXuint opts,FXint x,FXint y,FXint w,FXint h,FXint pl,FXint pr,FXint pt,FXint pb){
      return new FXRbSpinner(p,cols,tgt,sel,opts,x,y,w,h,pl,pr,pt,pb);
      }
void FXSpinner_setRange(FXSpinner *self,VALUE range){
      FXint lo,hi;
      FXRbRange2LoHi(range,lo,hi);
      self->setRange(lo,hi);
      }
VALUE FXSpinner_getRange(FXSpinner const *self){
      FXint lo,hi;
      self->getRange(lo,hi);
      return rb_range_new(INT2NUM(lo),INT2NUM(hi),0);
      }

swig_class cFXSpinner;
static void free_FXSpinner(FXSpinner *);
FXRealSpinner *new_FXRealSpinner(FXComposite *p,FXint cols,FXObject *tgt,FXSelector sel,FXuint opts,FXint x,FXint y,FXint w,FXint h,FXint pl,FXint pr,FXint pt,FXint pb){
      return new FXRbRealSpinner(p,cols,tgt,sel,opts,x,y,w,h,pl,pr,pt,pb);
      }
void FXRealSpinner_setRange(FXRealSpinner *self,VALUE range){
      FXdouble lo,hi;
      FXRbRange2LoHi(range,lo,hi);
      self->setRange(lo,hi);
      }
VALUE FXRealSpinner_getRange(FXRealSpinner const *self){
      FXdouble lo,hi;
      self->getRange(lo,hi);
      return rb_range_new(rb_float_new(lo),rb_float_new(hi),0);
      }

swig_class cFXRealSpinner;
static void free_FXRealSpinner(FXRealSpinner *);
FXCanvas *new_FXCanvas(FXComposite *p,FXObject *tgt,FXSelector sel,FXuint opts,FXint x,FXint y,FXint w,FXint h){
      return new FXRbCanvas(p,tgt,sel,opts,x,y,w,h);
      }

swig_class cFXCanvas;
static void free_FXCanvas(FXCanvas *);

static swig_type_info *FXCanvas_dynamic_cast(void **ptr) {
    FXCanvas **ppCanvas = reinterpret_cast<FXCanvas **>(ptr);
    FXGLCanvas *pGLCanvas=dynamic_cast<FXGLCanvas*>(*ppCanvas);
    if(pGLCanvas){
      *ptr=reinterpret_cast<void*>(pGLCanvas);
      return SWIG_TypeQuery("FXGLCanvas *");
      }
    return 0;
}

FXToolTip *new_FXToolTip(FXApp *a,FXuint opts,FXint x,FXint y,FXint w,FXint h){
      return new FXRbToolTip(a,opts,x,y,w,h);
      }

swig_class cFXToolTip;
static void free_FXToolTip(FXToolTip *);
FXToolBar *new_FXToolBar__SWIG_0(FXComposite *p,FXComposite *q,FXuint opts,FXint x,FXint y,FXint w,FXint h,FXint pl,FXint pr,FXint pt,FXint pb,FXint hs,FXint vs){
      return new FXRbToolBar(p,q,opts,x,y,w,h,pl,pr,pt,pb,hs,vs);
      }
FXToolBar *new_FXToolBar__SWIG_1(FXComposite *p,FXuint opts,FXint x,FXint y,FXint w,FXint h,FXint pl,FXint pr,FXint pt,FXint pb,FXint hs,FXint vs){
      return new FXRbToolBar(p,opts,x,y,w,h,pl,pr,pt,pb,hs,vs);
      }

swig_class cFXToolBar;
static void free_FXToolBar(FXToolBar *);
FXTabBar *new_FXTabBar(FXComposite *p,FXObject *tgt,FXSelector sel,FXuint opts,FXint x,FXint y,FXint w,FXint h,FXint pl,FXint pr,FXint pt,FXint pb){
      return new FXRbTabBar(p,tgt,sel,opts,x,y,w,h,pl,pr,pt,pb);
      }

swig_class cFXTabBar;
static void free_FXTabBar(FXTabBar *);

static swig_type_info *FXTabBar_dynamic_cast(void **ptr) {
    FXTabBar **ppTabBar = reinterpret_cast<FXTabBar **>(ptr);
    FXTabBook *pTabBook=dynamic_cast<FXTabBook*>(*ppTabBar);
    if(pTabBook){
      *ptr=reinterpret_cast<void*>(pTabBook);
      return SWIG_TypeQuery("FXTabBook *");
      }
    return 0;
}

FXTabBook *new_FXTabBook(FXComposite *p,FXObject *tgt,FXSelector sel,FXuint opts,FXint x,FXint y,FXint w,FXint h,FXint pl,FXint pr,FXint pt,FXint pb){
      return new FXRbTabBook(p,tgt,sel,opts,x,y,w,h,pl,pr,pt,pb);
      }

swig_class cFXTabBook;
static void free_FXTabBook(FXTabBook *);
FXScrollBar *new_FXScrollBar(FXComposite *p,FXObject *tgt,FXSelector sel,FXuint opts,FXint x,FXint y,FXint w,FXint h){
      return new FXRbScrollBar(p,tgt,sel,opts,x,y,w,h);
      }
FXint FXScrollBar_position__SWIG_0(FXScrollBar const *self){
      return self->getPosition();
      }

swig_class cFXScrollBar;
static void free_FXScrollBar(FXScrollBar *);
FXScrollCorner *new_FXScrollCorner(FXComposite *p){
      return new FXRbScrollCorner(p);
      }

swig_class cFXScrollCorner;
static void free_FXScrollCorner(FXScrollCorner *);
FXComboBox *new_FXComboBox(FXComposite *p,FXint cols,FXObject *tgt,FXSelector sel,FXuint opts,FXint x,FXint y,FXint w,FXint h,FXint pl,FXint pr,FXint pt,FXint pb){
      return new FXRbComboBox(p,cols,tgt,sel,opts,x,y,w,h,pl,pr,pt,pb);
      }
void FXComboBox_setItemData(FXComboBox *self,FXint index,VALUE ptr){
      self->setItemData(index, (void*) ptr);
      }
VALUE FXComboBox_getItemData(FXComboBox const *self,FXint index){
      return self->getItemData(index) ? (VALUE) self->getItemData(index) : Qnil;
      }

swig_class cFXComboBox;
static void free_FXComboBox(FXComboBox *);
FXListBox *new_FXListBox(FXComposite *p,FXObject *tgt,FXSelector sel,FXuint opts,FXint x,FXint y,FXint w,FXint h,FXint pl,FXint pr,FXint pt,FXint pb){
      return new FXRbListBox(p,tgt,sel,opts,x,y,w,h,pl,pr,pt,pb);
      }
void FXListBox_setItemData(FXListBox *self,FXint index,VALUE ptr){
      self->setItemData(index, (void*) ptr);
      }
VALUE FXListBox_getItemData(FXListBox const *self,FXint index){
      return self->getItemData(index) ? (VALUE) self->getItemData(index) : Qnil;
      }

swig_class cFXListBox;
static void free_FXListBox(FXListBox *);

static swig_type_info *FXListBox_dynamic_cast(void **ptr) {
    FXListBox **ppListBox = reinterpret_cast<FXListBox **>(ptr);
    FXDriveBox *pDriveBox=dynamic_cast<FXDriveBox*>(*ppListBox);
    if(pDriveBox){
      *ptr=reinterpret_cast<void*>(pDriveBox);
      return SWIG_TypeQuery("FXDriveBox *");
      }
    return 0;
}

FXTreeListBox *new_FXTreeListBox(FXComposite *p,FXObject *tgt,FXSelector sel,FXuint opts,FXint x,FXint y,FXint w,FXint h,FXint pl,FXint pr,FXint pt,FXint pb){
      return new FXRbTreeListBox(p,tgt,sel,opts,x,y,w,h,pl,pr,pt,pb);
      }
FXTreeItem *FXTreeListBox_addItemFirst__SWIG_0(FXTreeListBox *self,FXTreeItem *p,FXTreeItem *item){
      if(item->isMemberOf(FXMETACLASS(FXRbTreeItem))){
        dynamic_cast<FXRbTreeItem*>(item)->owner=self;
	}
      return self->addItemFirst(p,item);
    }
FXTreeItem *FXTreeListBox_addItemLast__SWIG_0(FXTreeListBox *self,FXTreeItem *p,FXTreeItem *item){
      if(item->isMemberOf(FXMETACLASS(FXRbTreeItem))){
        dynamic_cast<FXRbTreeItem*>(item)->owner=self;
	}
      return self->addItemLast(p,item);
    }
FXTreeItem *FXTreeListBox_addItemAfter__SWIG_0(FXTreeListBox *self,FXTreeItem *other,FXTreeItem *item){
      if(item->isMemberOf(FXMETACLASS(FXRbTreeItem))){
        dynamic_cast<FXRbTreeItem*>(item)->owner=self;
	}
      return self->addItemAfter(other,item);
    }
FXTreeItem *FXTreeListBox_addItemBefore__SWIG_0(FXTreeListBox *self,FXTreeItem *other,FXTreeItem *item){
      if(item->isMemberOf(FXMETACLASS(FXRbTreeItem))){
        dynamic_cast<FXRbTreeItem*>(item)->owner=self;
	}
      return self->addItemBefore(other,item);
    }
FXTreeItem *FXTreeListBox_addItemFirst__SWIG_1(FXTreeListBox *self,FXTreeItem *p,FXString const &text,FXIcon *oi,FXIcon *ci,void *ITEMDATA){
      FXTreeItem* item=self->addItemFirst(p,text,oi,ci,ITEMDATA);
      if(item->isMemberOf(FXMETACLASS(FXRbTreeItem))){
        dynamic_cast<FXRbTreeItem*>(item)->owner=self;
	}
      return item;
      }
FXTreeItem *FXTreeListBox_addItemLast__SWIG_1(FXTreeListBox *self,FXTreeItem *p,FXString const &text,FXIcon *oi,FXIcon *ci,void *ITEMDATA){
      FXTreeItem* item=self->addItemLast(p,text,oi,ci,ITEMDATA);
      if(item->isMemberOf(FXMETACLASS(FXRbTreeItem))){
        dynamic_cast<FXRbTreeItem*>(item)->owner=self;
	}
      return item;
      }
FXTreeItem *FXTreeListBox_addItemAfter__SWIG_1(FXTreeListBox *self,FXTreeItem *other,FXString const &text,FXIcon *oi,FXIcon *ci,void *ITEMDATA){
      FXTreeItem* item=self->addItemAfter(other,text,oi,ci,ITEMDATA);
      if(item->isMemberOf(FXMETACLASS(FXRbTreeItem))){
        dynamic_cast<FXRbTreeItem*>(item)->owner=self;
	}
      return item;
      }
FXTreeItem *FXTreeListBox_addItemBefore__SWIG_1(FXTreeListBox *self,FXTreeItem *other,FXString const &text,FXIcon *oi,FXIcon *ci,void *ITEMDATA){
      FXTreeItem* item=self->addItemBefore(other,text,oi,ci,ITEMDATA);
      if(item->isMemberOf(FXMETACLASS(FXRbTreeItem))){
        dynamic_cast<FXRbTreeItem*>(item)->owner=self;
	}
      return item;
      }
void FXTreeListBox_removeItem(FXTreeListBox *self,FXTreeItem *item){
      // Save pointer(s) to the soon-to-be-destroyed items
      FXObjectListOf<FXTreeItem> items;
      FXRbTreeList::enumerateItem(item,items);
      
      // Do the deed
      self->removeItem(item);
      
      // Now zero-out pointers held by still-alive Ruby objects
      for(FXint i=0;i<items.no();i++){
        FXRbUnregisterRubyObj(items[i]);
        }
      }
void FXTreeListBox_removeItems(FXTreeListBox *self,FXTreeItem *fm,FXTreeItem *to){
      // Save pointer(s) to the soon-to-be-destroyed items
      FXObjectListOf<FXTreeItem> items;
      FXRbTreeList::enumerateItems(fm,to,items);

      // Do the deed
      self->removeItems(fm,to);

      // Now zero-out pointers held by still-alive Ruby objects
      for(FXint i=0;i<items.no();i++){
        FXRbUnregisterRubyObj(items[i]);
        }
      }
void FXTreeListBox_clearItems(FXTreeListBox *self){
      // Save pointer(s) to the soon-to-be-destroyed items
      FXObjectListOf<FXTreeItem> items;
      FXRbTreeList::enumerateItems(self->getFirstItem(),self->getLastItem(),items);

      // Do the deed
      self->clearItems();

      // Now zero-out pointers held by still-alive Ruby objects
      for(FXint i=0;i<items.no();i++){
        FXRbUnregisterRubyObj(items[i]);
        }
      }
void FXTreeListBox_setItemData(FXTreeListBox *self,FXTreeItem *item,VALUE ptr){
      self->setItemData(item,(void*) ptr);
      }
VALUE FXTreeListBox_getItemData(FXTreeListBox const *self,FXTreeItem const *item){
      return self->getItemData(item) ? (VALUE) self->getItemData(item) : Qnil;
      }

swig_class cFXTreeListBox;
static void free_FXTreeListBox(FXTreeListBox *);

static swig_type_info *FXTreeListBox_dynamic_cast(void **ptr) {
    FXTreeListBox **ppTreeListBox = reinterpret_cast<FXTreeListBox **>(ptr);
    FXDirBox *pDirBox=dynamic_cast<FXDirBox*>(*ppTreeListBox);
    if(pDirBox){
      *ptr=reinterpret_cast<void*>(pDirBox);
      return SWIG_TypeQuery("FXDirBox *");
      }
    return 0;
}

FXImageView *new_FXImageView(FXComposite *p,FXImage *img,FXObject *tgt,FXSelector sel,FXuint opts,FXint x,FXint y,FXint w,FXint h){
      return new FXRbImageView(p,img,tgt,sel,opts,x,y,w,h);
      }
VALUE FXImageView_position__SWIG_1(FXImageView const *self){
    FXint x, y;
    self->getPosition(x, y);
    VALUE pos = rb_ary_new();
    rb_ary_push(pos, INT2NUM(x));
    rb_ary_push(pos, INT2NUM(y));
    return pos;
  }

swig_class cFXImageView;
static void free_FXImageView(FXImageView *);
FXDragCorner *new_FXDragCorner(FXComposite *p){
      return new FXRbDragCorner(p);
      }

swig_class cFXDragCorner;
static void free_FXDragCorner(FXDragCorner *);
FXDirBox *new_FXDirBox(FXComposite *p,FXObject *tgt,FXSelector sel,FXuint opts,FXint x,FXint y,FXint w,FXint h,FXint pl,FXint pr,FXint pt,FXint pb){
      return new FXRbDirBox(p,tgt,sel,opts,x,y,w,h,pl,pr,pt,pb);
      }

swig_class cFXDirBox;
static void free_FXDirBox(FXDirBox *);
FXDriveBox *new_FXDriveBox(FXComposite *p,FXObject *tgt,FXSelector sel,FXuint opts,FXint x,FXint y,FXint w,FXint h,FXint pl,FXint pr,FXint pt,FXint pb){
      return new FXRbDriveBox(p,tgt,sel,opts,x,y,w,h,pl,pr,pt,pb);
      }

swig_class cFXDriveBox;
static void free_FXDriveBox(FXDriveBox *);
FXDirSelector *new_FXDirSelector(FXComposite *p,FXObject *tgt,FXSelector sel,FXuint opts,FXint x,FXint y,FXint w,FXint h){
      return new FXRbDirSelector(p,tgt,sel,opts,x,y,w,h);
      }

swig_class cFXDirSelector;
static void free_FXDirSelector(FXDirSelector *);
FXFileSelector *new_FXFileSelector(FXComposite *p,FXObject *tgt,FXSelector sel,FXuint opts,FXint x,FXint y,FXint w,FXint h){
      return new FXRbFileSelector(p,tgt,sel,opts,x,y,w,h);
      }
VALUE FXFileSelector_getFilenames(FXFileSelector const *self){
        VALUE result = rb_ary_new();
        FXString *filenames = self->getFilenames();
        if (filenames) {
            register FXString *p = filenames;
            while ((*p) != FXString::null) {
                rb_ary_push(result, rb_str_new2((*p).text()));
		p++;
            }
	    delete [] filenames;
        }
        return result;
    }
void FXFileSelector_setPatternList(FXFileSelector *self,VALUE ary){
      FXString patterns;
      if(TYPE(ary)==T_STRING){
        patterns=FXString(STR2CSTR(ary));
        }
      else if(TYPE(ary)==T_ARRAY){
        for(long i=0; i<RARRAY(ary)->len; i++){
          VALUE obj=rb_ary_entry(ary,i);
          Check_Type(obj,T_STRING);
          patterns+=FXString(STR2CSTR(obj))+FXString("\n");
          }
        }
      else{
        rb_raise(rb_eArgError,"expected either a string, or an array of strings, as input");
        }
      self->setPatternList(patterns);
      }
VALUE FXFileSelector_getPatternList(FXFileSelector const *self){
      FXString pat;
      FXString patterns;
      VALUE ary;
      patterns=self->getPatternList();
      ary=rb_ary_new();
      for(FXint start=0;!(pat=patterns.section('\n',start)).empty();start++){
	rb_ary_push(ary,to_ruby(pat.text()));
        }
      return ary;
    }

swig_class cFXFileSelector;
static void free_FXFileSelector(FXFileSelector *);
FXColorSelector *new_FXColorSelector(FXComposite *p,FXObject *tgt,FXSelector sel,FXuint opts,FXint x,FXint y,FXint w,FXint h){
      return new FXRbColorSelector(p,tgt,sel,opts,x,y,w,h);
      }

swig_class cFXColorSelector;
static void free_FXColorSelector(FXColorSelector *);
FXFontSelector *new_FXFontSelector(FXComposite *p,FXObject *tgt,FXSelector sel,FXuint opts,FXint x,FXint y,FXint w,FXint h){
      return new FXRbFontSelector(p,tgt,sel,opts,x,y,w,h);
      }
FXFontDesc FXFontSelector_getFontSelection(FXFontSelector const *self){
	FXFontDesc fontdesc;
        self->getFontSelection(fontdesc);
	return fontdesc;
    }

swig_class cFXFontSelector;
static void free_FXFontSelector(FXFontSelector *);
FXToolBarGrip *new_FXToolBarGrip(FXToolBar *p,FXObject *tgt,FXSelector sel,FXuint opts,FXint x,FXint y,FXint w,FXint h){
      return new FXRbToolBarGrip(p,tgt,sel,opts,x,y,w,h);
      }

swig_class cFXToolBarGrip;
static void free_FXToolBarGrip(FXToolBarGrip *);
FXToolBarShell *new_FXToolBarShell(FXWindow *owner,FXuint opts,FXint x,FXint y,FXint w,FXint h,FXint hs,FXint vs){
      return new FXRbToolBarShell(owner,opts,x,y,w,h,hs,vs);
      }

swig_class cFXToolBarShell;
static void free_FXToolBarShell(FXToolBarShell *);
static VALUE _wrap_FXSpinner_onUpdIncrement(int argc, VALUE *argv, VALUE self) { FXSpinner *arg1 = (FXSpinner *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSpinner, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onUpdIncrement(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXSpinner_onCmdIncrement(int argc, VALUE *argv, VALUE self) { FXSpinner *arg1 = (FXSpinner *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSpinner, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onCmdIncrement(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXSpinner_onUpdDecrement(int argc, VALUE *argv, VALUE self) { FXSpinner *arg1 = (FXSpinner *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSpinner, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onUpdDecrement(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXSpinner_onCmdDecrement(int argc, VALUE *argv, VALUE self) { FXSpinner *arg1 = (FXSpinner *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSpinner, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onCmdDecrement(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXSpinner_onUpdEntry(int argc, VALUE *argv, VALUE self) { FXSpinner *arg1 = (FXSpinner *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSpinner, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onUpdEntry(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXSpinner_onCmdEntry(int argc, VALUE *argv, VALUE self) { FXSpinner *arg1 = (FXSpinner *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSpinner, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdEntry(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXSpinner_onChgEntry(int argc, VALUE *argv, VALUE self) { FXSpinner *arg1 = (FXSpinner *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSpinner, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onChgEntry(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXSpinner_onWheelEntry(int argc, VALUE *argv, VALUE self) { FXSpinner *arg1 = (FXSpinner *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSpinner, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onWheelEntry(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXSpinner_onKeyPress(int argc, VALUE *argv, VALUE self) { FXSpinner *arg1 = (FXSpinner *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSpinner, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onKeyPress(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXSpinner_onKeyRelease(int argc, VALUE *argv, VALUE self) { FXSpinner *arg1 = (FXSpinner *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSpinner, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onKeyRelease(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXSpinner_onCmdSetValue(int argc, VALUE *argv, VALUE self) { FXSpinner *arg1 = (FXSpinner *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSpinner, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]);
    arg4 = reinterpret_cast<void*>(NUM2INT(argv[2])); result = (long)(arg1)->onCmdSetValue(arg2,arg3,arg4);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXSpinner_onCmdSetIntValue(int argc, VALUE *argv, VALUE self) { FXSpinner *arg1 = (FXSpinner *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; FXint value4 ;
    VALUE vresult = Qnil; if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSpinner, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); {
        value4 = (FXint) NUM2INT(argv[2]); arg4 = static_cast<void*>(&value4); } 
    result = (long)(arg1)->onCmdSetIntValue(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXSpinner_onCmdGetIntValue(int argc, VALUE *argv, VALUE self) { FXSpinner *arg1 = (FXSpinner *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSpinner, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdGetIntValue(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXSpinner_onCmdSetIntRange(int argc, VALUE *argv, VALUE self) { FXSpinner *arg1 = (FXSpinner *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; FXint values4[2] ;
    VALUE vresult = Qnil; if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSpinner, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); { Check_Type(argv[2], T_ARRAY);
        values4[0] = (FXint) NUM2INT(rb_ary_entry(argv[2], 0)); values4[1] = (FXint) NUM2INT(rb_ary_entry(argv[2], 1));
        arg4 = static_cast<void*>(values4); }  result = (long)(arg1)->onCmdSetIntRange(arg2,arg3,arg4);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXSpinner_onCmdGetIntRange(int argc, VALUE *argv, VALUE self) { FXSpinner *arg1 = (FXSpinner *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSpinner, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]);
    SWIG_ConvertPtr(argv[2], (void **) &arg4, 0, 1); result = (long)(arg1)->onCmdGetIntRange(arg2,arg3,arg4);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXSpinner_onFocusSelf(int argc, VALUE *argv, VALUE self) { FXSpinner *arg1 = (FXSpinner *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSpinner, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onFocusSelf(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE _wrap_FXSpinner_allocate(VALUE self) {
#else
     static VALUE _wrap_FXSpinner_allocate(int argc, VALUE *argv, VALUE self) {
#endif
         VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_FXSpinner);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
         return vresult; }
static VALUE _wrap_new_FXSpinner(int argc, VALUE *argv, VALUE self) { FXComposite *arg1 = (FXComposite *) 0 ; FXint arg2 ;
    FXObject *arg3 = (FXObject *) 0 ; FXSelector arg4 = (FXSelector) 0 ; FXuint arg5 = (FXuint) SPIN_NORMAL ;
    FXint arg6 = (FXint) 0 ; FXint arg7 = (FXint) 0 ; FXint arg8 = (FXint) 0 ; FXint arg9 = (FXint) 0 ;
    FXint arg10 = (FXint) DEFAULT_PAD ; FXint arg11 = (FXint) DEFAULT_PAD ; FXint arg12 = (FXint) DEFAULT_PAD ;
    FXint arg13 = (FXint) DEFAULT_PAD ; FXSpinner *result; if ((argc < 2) || (argc > 13))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXComposite, 1); arg2 = NUM2INT(argv[1]); if (argc > 2) {
        SWIG_ConvertPtr(argv[2], (void **) &arg3, SWIGTYPE_p_FXObject, 1); }  if (argc > 3) { arg4 = NUM2UINT(argv[3]); } 
    if (argc > 4) { arg5 = NUM2UINT(argv[4]); }  if (argc > 5) { arg6 = NUM2INT(argv[5]); }  if (argc > 6) {
        arg7 = NUM2INT(argv[6]); }  if (argc > 7) { arg8 = NUM2INT(argv[7]); }  if (argc > 8) { arg9 = NUM2INT(argv[8]); } 
    if (argc > 9) { arg10 = NUM2INT(argv[9]); }  if (argc > 10) { arg11 = NUM2INT(argv[10]); }  if (argc > 11) {
        arg12 = NUM2INT(argv[11]); }  if (argc > 12) { arg13 = NUM2INT(argv[12]); }  {
        result = (FXSpinner *)new_FXSpinner(arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8,arg9,arg10,arg11,arg12,arg13);
        DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result); if(rb_block_given_p()){ rb_yield(self); }  }  return self; }
static VALUE _wrap_FXSpinner_increment(int argc, VALUE *argv, VALUE self) { FXSpinner *arg1 = (FXSpinner *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSpinner, 1); (arg1)->increment(); return Qnil; }
static VALUE _wrap_FXSpinner_decrement(int argc, VALUE *argv, VALUE self) { FXSpinner *arg1 = (FXSpinner *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSpinner, 1); (arg1)->decrement(); return Qnil; }
static VALUE _wrap_FXSpinner_isCyclic(int argc, VALUE *argv, VALUE self) { FXSpinner *arg1 = (FXSpinner *) 0 ; FXbool result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSpinner, 1); result = (FXbool)((FXSpinner const *)arg1)->isCyclic();
    vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXSpinner_setCyclic(int argc, VALUE *argv, VALUE self) { FXSpinner *arg1 = (FXSpinner *) 0 ; FXbool arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSpinner, 1); arg2 = to_FXbool(argv[0]); (arg1)->setCyclic(arg2);
    return Qnil; }
static VALUE _wrap_FXSpinner_isTextVisible(int argc, VALUE *argv, VALUE self) { FXSpinner *arg1 = (FXSpinner *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSpinner, 1);
    result = (FXbool)((FXSpinner const *)arg1)->isTextVisible(); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXSpinner_setTextVisible(int argc, VALUE *argv, VALUE self) { FXSpinner *arg1 = (FXSpinner *) 0 ;
    FXbool arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSpinner, 1); arg2 = to_FXbool(argv[0]); (arg1)->setTextVisible(arg2);
    return Qnil; }
static VALUE _wrap_FXSpinner_getValue(int argc, VALUE *argv, VALUE self) { FXSpinner *arg1 = (FXSpinner *) 0 ; FXint result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSpinner, 1); result = (FXint)((FXSpinner const *)arg1)->getValue();
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXSpinner_setRange(int argc, VALUE *argv, VALUE self) { FXSpinner *arg1 = (FXSpinner *) 0 ; VALUE arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSpinner, 1); arg2 = argv[0]; FXSpinner_setRange(arg1,arg2);
    return Qnil; }
static VALUE _wrap_FXSpinner_getRange(int argc, VALUE *argv, VALUE self) { FXSpinner *arg1 = (FXSpinner *) 0 ; VALUE result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSpinner, 1);
    result = (VALUE)FXSpinner_getRange((FXSpinner const *)arg1); vresult = result; return vresult; }
static VALUE _wrap_FXSpinner_setIncrement(int argc, VALUE *argv, VALUE self) { FXSpinner *arg1 = (FXSpinner *) 0 ; FXint arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSpinner, 1); arg2 = NUM2INT(argv[0]); (arg1)->setIncrement(arg2);
    return Qnil; }
static VALUE _wrap_FXSpinner_getIncrement(int argc, VALUE *argv, VALUE self) { FXSpinner *arg1 = (FXSpinner *) 0 ; FXint result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSpinner, 1); result = (FXint)((FXSpinner const *)arg1)->getIncrement();
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXSpinner_setFont(int argc, VALUE *argv, VALUE self) { FXSpinner *arg1 = (FXSpinner *) 0 ;
    FXFont *arg2 = (FXFont *) 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSpinner, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXFont, 1); (arg1)->setFont(arg2); return Qnil; }
static VALUE _wrap_FXSpinner_getFont(int argc, VALUE *argv, VALUE self) { FXSpinner *arg1 = (FXSpinner *) 0 ; FXFont *result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSpinner, 1); result = (FXFont *)((FXSpinner const *)arg1)->getFont(); {
        swig_type_info *ty = SWIG_TypeDynamicCast(SWIGTYPE_p_FXFont, (void **) &result); vresult = FXRbGetRubyObj(result, ty); }
     return vresult; }
static VALUE _wrap_FXSpinner_setHelpText(int argc, VALUE *argv, VALUE self) { FXSpinner *arg1 = (FXSpinner *) 0 ;
    FXString *arg2 = 0 ; SwigValueWrapper<FXString > p2 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSpinner, 1); p2 = to_FXString(argv[0]); arg2 = &p2;
    (arg1)->setHelpText((FXString const &)*arg2); return Qnil; }
static VALUE _wrap_FXSpinner_getHelpText(int argc, VALUE *argv, VALUE self) { FXSpinner *arg1 = (FXSpinner *) 0 ;
    FXString result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSpinner, 1); result = ((FXSpinner const *)arg1)->getHelpText();
    vresult = rb_str_new2((&result)->text()); return vresult; }
static VALUE _wrap_FXSpinner_setTipText(int argc, VALUE *argv, VALUE self) { FXSpinner *arg1 = (FXSpinner *) 0 ;
    FXString *arg2 = 0 ; SwigValueWrapper<FXString > p2 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSpinner, 1); p2 = to_FXString(argv[0]); arg2 = &p2;
    (arg1)->setTipText((FXString const &)*arg2); return Qnil; }
static VALUE _wrap_FXSpinner_getTipText(int argc, VALUE *argv, VALUE self) { FXSpinner *arg1 = (FXSpinner *) 0 ;
    FXString result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSpinner, 1); result = ((FXSpinner const *)arg1)->getTipText();
    vresult = rb_str_new2((&result)->text()); return vresult; }
static VALUE _wrap_FXSpinner_setSpinnerStyle(int argc, VALUE *argv, VALUE self) { FXSpinner *arg1 = (FXSpinner *) 0 ;
    FXuint arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSpinner, 1); arg2 = NUM2UINT(argv[0]); (arg1)->setSpinnerStyle(arg2);
    return Qnil; }
static VALUE _wrap_FXSpinner_getSpinnerStyle(int argc, VALUE *argv, VALUE self) { FXSpinner *arg1 = (FXSpinner *) 0 ;
    FXuint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSpinner, 1);
    result = (FXuint)((FXSpinner const *)arg1)->getSpinnerStyle(); vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXSpinner_setEditable(int argc, VALUE *argv, VALUE self) { FXSpinner *arg1 = (FXSpinner *) 0 ;
    FXbool arg2 = (FXbool) 1 ; if ((argc < 0) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSpinner, 1); if (argc > 0) { arg2 = to_FXbool(argv[0]); } 
    (arg1)->setEditable(arg2); return Qnil; }
static VALUE _wrap_FXSpinner_isEditable(int argc, VALUE *argv, VALUE self) { FXSpinner *arg1 = (FXSpinner *) 0 ; FXbool result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSpinner, 1); result = (FXbool)((FXSpinner const *)arg1)->isEditable();
    vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXSpinner_setUpArrowColor(int argc, VALUE *argv, VALUE self) { FXSpinner *arg1 = (FXSpinner *) 0 ;
    FXColor arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSpinner, 1); arg2 = to_FXColor(argv[0]); (arg1)->setUpArrowColor(arg2);
    return Qnil; }
static VALUE _wrap_FXSpinner_getUpArrowColor(int argc, VALUE *argv, VALUE self) { FXSpinner *arg1 = (FXSpinner *) 0 ;
    FXColor result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSpinner, 1);
    result = (FXColor)((FXSpinner const *)arg1)->getUpArrowColor(); vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXSpinner_setDownArrowColor(int argc, VALUE *argv, VALUE self) { FXSpinner *arg1 = (FXSpinner *) 0 ;
    FXColor arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSpinner, 1); arg2 = to_FXColor(argv[0]);
    (arg1)->setDownArrowColor(arg2); return Qnil; }
static VALUE _wrap_FXSpinner_getDownArrowColor(int argc, VALUE *argv, VALUE self) { FXSpinner *arg1 = (FXSpinner *) 0 ;
    FXColor result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSpinner, 1);
    result = (FXColor)((FXSpinner const *)arg1)->getDownArrowColor(); vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXSpinner_setTextColor(int argc, VALUE *argv, VALUE self) { FXSpinner *arg1 = (FXSpinner *) 0 ;
    FXColor arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSpinner, 1); arg2 = to_FXColor(argv[0]); (arg1)->setTextColor(arg2);
    return Qnil; }
static VALUE _wrap_FXSpinner_getTextColor(int argc, VALUE *argv, VALUE self) { FXSpinner *arg1 = (FXSpinner *) 0 ;
    FXColor result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSpinner, 1);
    result = (FXColor)((FXSpinner const *)arg1)->getTextColor(); vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXSpinner_setSelBackColor(int argc, VALUE *argv, VALUE self) { FXSpinner *arg1 = (FXSpinner *) 0 ;
    FXColor arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSpinner, 1); arg2 = to_FXColor(argv[0]); (arg1)->setSelBackColor(arg2);
    return Qnil; }
static VALUE _wrap_FXSpinner_getSelBackColor(int argc, VALUE *argv, VALUE self) { FXSpinner *arg1 = (FXSpinner *) 0 ;
    FXColor result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSpinner, 1);
    result = (FXColor)((FXSpinner const *)arg1)->getSelBackColor(); vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXSpinner_setSelTextColor(int argc, VALUE *argv, VALUE self) { FXSpinner *arg1 = (FXSpinner *) 0 ;
    FXColor arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSpinner, 1); arg2 = to_FXColor(argv[0]); (arg1)->setSelTextColor(arg2);
    return Qnil; }
static VALUE _wrap_FXSpinner_getSelTextColor(int argc, VALUE *argv, VALUE self) { FXSpinner *arg1 = (FXSpinner *) 0 ;
    FXColor result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSpinner, 1);
    result = (FXColor)((FXSpinner const *)arg1)->getSelTextColor(); vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXSpinner_setCursorColor(int argc, VALUE *argv, VALUE self) { FXSpinner *arg1 = (FXSpinner *) 0 ;
    FXColor arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSpinner, 1); arg2 = to_FXColor(argv[0]); (arg1)->setCursorColor(arg2);
    return Qnil; }
static VALUE _wrap_FXSpinner_getCursorColor(int argc, VALUE *argv, VALUE self) { FXSpinner *arg1 = (FXSpinner *) 0 ;
    FXColor result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSpinner, 1);
    result = (FXColor)((FXSpinner const *)arg1)->getCursorColor(); vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXSpinner_setNumColumns(int argc, VALUE *argv, VALUE self) { FXSpinner *arg1 = (FXSpinner *) 0 ; FXint arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSpinner, 1); arg2 = NUM2INT(argv[0]); (arg1)->setNumColumns(arg2);
    return Qnil; }
static VALUE _wrap_FXSpinner_getNumColumns(int argc, VALUE *argv, VALUE self) { FXSpinner *arg1 = (FXSpinner *) 0 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSpinner, 1); result = (FXint)((FXSpinner const *)arg1)->getNumColumns();
    vresult = INT2NUM(result); return vresult; }
static void
free_FXSpinner(FXSpinner *arg1) {
    delete arg1;
}
static VALUE _wrap_FXSpinner_save(int argc, VALUE *argv, VALUE self) { FXSpinner *arg1 = (FXSpinner *) 0 ; FXStream *arg2 = 0 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSpinner, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXSpinner_save((FXSpinner const *)arg1,*arg2); return Qnil; }
static VALUE _wrap_FXSpinner_load(int argc, VALUE *argv, VALUE self) { FXSpinner *arg1 = (FXSpinner *) 0 ; FXStream *arg2 = 0 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSpinner, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXSpinner_load(arg1,*arg2); return Qnil; }
static VALUE _wrap_FXSpinner_create(int argc, VALUE *argv, VALUE self) { FXSpinner *arg1 = (FXSpinner *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSpinner, 1); FXSpinner_create(arg1); return Qnil; }
static VALUE _wrap_FXSpinner_detach(int argc, VALUE *argv, VALUE self) { FXSpinner *arg1 = (FXSpinner *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSpinner, 1); FXSpinner_detach(arg1); return Qnil; }
static VALUE _wrap_FXSpinner_destroy(int argc, VALUE *argv, VALUE self) { FXSpinner *arg1 = (FXSpinner *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSpinner, 1); FXSpinner_destroy(arg1); return Qnil; }
static VALUE _wrap_FXSpinner_resize(int argc, VALUE *argv, VALUE self) { FXSpinner *arg1 = (FXSpinner *) 0 ; FXint arg2 ;
    FXint arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSpinner, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    FXSpinner_resize(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXSpinner_getDefaultWidth(int argc, VALUE *argv, VALUE self) { FXSpinner *arg1 = (FXSpinner *) 0 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSpinner, 1); result = (FXint)FXSpinner_getDefaultWidth(arg1);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXSpinner_getDefaultHeight(int argc, VALUE *argv, VALUE self) { FXSpinner *arg1 = (FXSpinner *) 0 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSpinner, 1); result = (FXint)FXSpinner_getDefaultHeight(arg1);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXSpinner_getWidthForHeight(int argc, VALUE *argv, VALUE self) { FXSpinner *arg1 = (FXSpinner *) 0 ;
    FXint arg2 ; FXint result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSpinner, 1); arg2 = NUM2INT(argv[0]);
    result = (FXint)FXSpinner_getWidthForHeight(arg1,arg2); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXSpinner_getHeightForWidth(int argc, VALUE *argv, VALUE self) { FXSpinner *arg1 = (FXSpinner *) 0 ;
    FXint arg2 ; FXint result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSpinner, 1); arg2 = NUM2INT(argv[0]);
    result = (FXint)FXSpinner_getHeightForWidth(arg1,arg2); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXSpinner_canFocus(int argc, VALUE *argv, VALUE self) { FXSpinner *arg1 = (FXSpinner *) 0 ; FXbool result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSpinner, 1);
    result = (FXbool)FXSpinner_canFocus((FXSpinner const *)arg1); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXSpinner_setFocus(int argc, VALUE *argv, VALUE self) { FXSpinner *arg1 = (FXSpinner *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSpinner, 1); FXSpinner_setFocus(arg1); return Qnil; }
static VALUE _wrap_FXSpinner_killFocus(int argc, VALUE *argv, VALUE self) { FXSpinner *arg1 = (FXSpinner *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSpinner, 1); FXSpinner_killFocus(arg1); return Qnil; }
static VALUE _wrap_FXSpinner_setDefault(int argc, VALUE *argv, VALUE self) { FXSpinner *arg1 = (FXSpinner *) 0 ;
    FXbool arg2 = (FXbool) 1 ; if ((argc < 0) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSpinner, 1); if (argc > 0) { arg2 = to_FXbool(argv[0]); } 
    FXSpinner_setDefault(arg1,arg2); return Qnil; }
static VALUE _wrap_FXSpinner_enable(int argc, VALUE *argv, VALUE self) { FXSpinner *arg1 = (FXSpinner *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSpinner, 1); FXSpinner_enable(arg1); return Qnil; }
static VALUE _wrap_FXSpinner_disable(int argc, VALUE *argv, VALUE self) { FXSpinner *arg1 = (FXSpinner *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSpinner, 1); FXSpinner_disable(arg1); return Qnil; }
static VALUE _wrap_FXSpinner_raiseWindow(int argc, VALUE *argv, VALUE self) { FXSpinner *arg1 = (FXSpinner *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSpinner, 1); FXSpinner_raise(arg1); return Qnil; }
static VALUE _wrap_FXSpinner_lower(int argc, VALUE *argv, VALUE self) { FXSpinner *arg1 = (FXSpinner *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSpinner, 1); FXSpinner_lower(arg1); return Qnil; }
static VALUE _wrap_FXSpinner_move(int argc, VALUE *argv, VALUE self) { FXSpinner *arg1 = (FXSpinner *) 0 ; FXint arg2 ;
    FXint arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSpinner, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    FXSpinner_move(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXSpinner_position(int argc, VALUE *argv, VALUE self) { FXSpinner *arg1 = (FXSpinner *) 0 ; FXint arg2 ;
    FXint arg3 ; FXint arg4 ; FXint arg5 ; if ((argc < 4) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSpinner, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    arg4 = NUM2INT(argv[2]); arg5 = NUM2INT(argv[3]); FXSpinner_position(arg1,arg2,arg3,arg4,arg5); return Qnil; }
static VALUE _wrap_FXSpinner_layout(int argc, VALUE *argv, VALUE self) { FXSpinner *arg1 = (FXSpinner *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSpinner, 1); FXSpinner_layout(arg1); return Qnil; }
static VALUE _wrap_FXSpinner_recalc(int argc, VALUE *argv, VALUE self) { FXSpinner *arg1 = (FXSpinner *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSpinner, 1); FXSpinner_recalc(arg1); return Qnil; }
static VALUE _wrap_FXSpinner_reparent(int argc, VALUE *argv, VALUE self) { FXSpinner *arg1 = (FXSpinner *) 0 ;
    FXComposite *arg2 = (FXComposite *) 0 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSpinner, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXComposite, 1); FXSpinner_reparent(arg1,arg2); return Qnil; }
static VALUE _wrap_FXSpinner_show(int argc, VALUE *argv, VALUE self) { FXSpinner *arg1 = (FXSpinner *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSpinner, 1); FXSpinner_show(arg1); return Qnil; }
static VALUE _wrap_FXSpinner_hide(int argc, VALUE *argv, VALUE self) { FXSpinner *arg1 = (FXSpinner *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSpinner, 1); FXSpinner_hide(arg1); return Qnil; }
static VALUE _wrap_FXSpinner_isComposite(int argc, VALUE *argv, VALUE self) { FXSpinner *arg1 = (FXSpinner *) 0 ; FXbool result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSpinner, 1);
    result = (FXbool)FXSpinner_isComposite((FXSpinner const *)arg1); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXSpinner_contains(int argc, VALUE *argv, VALUE self) { FXSpinner *arg1 = (FXSpinner *) 0 ; FXint arg2 ;
    FXint arg3 ; FXbool result; VALUE vresult = Qnil; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSpinner, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    result = (FXbool)FXSpinner_contains((FXSpinner const *)arg1,arg2,arg3); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXSpinner_doesSaveUnder(int argc, VALUE *argv, VALUE self) { FXSpinner *arg1 = (FXSpinner *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSpinner, 1);
    result = (FXbool)FXSpinner_doesSaveUnder((FXSpinner const *)arg1); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXSpinner_setBackColor(int argc, VALUE *argv, VALUE self) { FXSpinner *arg1 = (FXSpinner *) 0 ;
    FXColor arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSpinner, 1); arg2 = to_FXColor(argv[0]);
    FXSpinner_setBackColor(arg1,arg2); return Qnil; }
static VALUE _wrap_FXSpinner_setValue(int argc, VALUE *argv, VALUE self) { FXSpinner *arg1 = (FXSpinner *) 0 ; FXint arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSpinner, 1); arg2 = NUM2INT(argv[0]); FXSpinner_setValue(arg1,arg2);
    return Qnil; }
static VALUE _wrap_FXRealSpinner_onUpdIncrement(int argc, VALUE *argv, VALUE self) { FXRealSpinner *arg1 = (FXRealSpinner *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRealSpinner, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onUpdIncrement(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXRealSpinner_onCmdIncrement(int argc, VALUE *argv, VALUE self) { FXRealSpinner *arg1 = (FXRealSpinner *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRealSpinner, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onCmdIncrement(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXRealSpinner_onUpdDecrement(int argc, VALUE *argv, VALUE self) { FXRealSpinner *arg1 = (FXRealSpinner *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRealSpinner, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onUpdDecrement(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXRealSpinner_onCmdDecrement(int argc, VALUE *argv, VALUE self) { FXRealSpinner *arg1 = (FXRealSpinner *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRealSpinner, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onCmdDecrement(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXRealSpinner_onUpdEntry(int argc, VALUE *argv, VALUE self) { FXRealSpinner *arg1 = (FXRealSpinner *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRealSpinner, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onUpdEntry(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXRealSpinner_onCmdEntry(int argc, VALUE *argv, VALUE self) { FXRealSpinner *arg1 = (FXRealSpinner *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRealSpinner, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdEntry(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXRealSpinner_onChgEntry(int argc, VALUE *argv, VALUE self) { FXRealSpinner *arg1 = (FXRealSpinner *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRealSpinner, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onChgEntry(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXRealSpinner_onWheelEntry(int argc, VALUE *argv, VALUE self) { FXRealSpinner *arg1 = (FXRealSpinner *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRealSpinner, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onWheelEntry(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXRealSpinner_onKeyPress(int argc, VALUE *argv, VALUE self) { FXRealSpinner *arg1 = (FXRealSpinner *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRealSpinner, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onKeyPress(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXRealSpinner_onKeyRelease(int argc, VALUE *argv, VALUE self) { FXRealSpinner *arg1 = (FXRealSpinner *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRealSpinner, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onKeyRelease(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXRealSpinner_onCmdSetValue(int argc, VALUE *argv, VALUE self) { FXRealSpinner *arg1 = (FXRealSpinner *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRealSpinner, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]);
    arg4 = reinterpret_cast<void*>(NUM2INT(argv[2])); result = (long)(arg1)->onCmdSetValue(arg2,arg3,arg4);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXRealSpinner_onCmdSetIntValue(int argc, VALUE *argv, VALUE self) {
    FXRealSpinner *arg1 = (FXRealSpinner *) 0 ; FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ;
    long result; FXint value4 ; VALUE vresult = Qnil; if ((argc < 3) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRealSpinner, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); {
        value4 = (FXint) NUM2INT(argv[2]); arg4 = static_cast<void*>(&value4); } 
    result = (long)(arg1)->onCmdSetIntValue(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXRealSpinner_onCmdGetIntValue(int argc, VALUE *argv, VALUE self) {
    FXRealSpinner *arg1 = (FXRealSpinner *) 0 ; FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ;
    long result; VALUE vresult = Qnil; if ((argc < 3) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRealSpinner, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdGetIntValue(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXRealSpinner_onCmdSetIntRange(int argc, VALUE *argv, VALUE self) {
    FXRealSpinner *arg1 = (FXRealSpinner *) 0 ; FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ;
    long result; FXint values4[2] ; VALUE vresult = Qnil; if ((argc < 3) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRealSpinner, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); { Check_Type(argv[2], T_ARRAY);
        values4[0] = (FXint) NUM2INT(rb_ary_entry(argv[2], 0)); values4[1] = (FXint) NUM2INT(rb_ary_entry(argv[2], 1));
        arg4 = static_cast<void*>(values4); }  result = (long)(arg1)->onCmdSetIntRange(arg2,arg3,arg4);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXRealSpinner_onCmdGetIntRange(int argc, VALUE *argv, VALUE self) {
    FXRealSpinner *arg1 = (FXRealSpinner *) 0 ; FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ;
    long result; VALUE vresult = Qnil; if ((argc < 3) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRealSpinner, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]);
    SWIG_ConvertPtr(argv[2], (void **) &arg4, 0, 1); result = (long)(arg1)->onCmdGetIntRange(arg2,arg3,arg4);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXRealSpinner_onCmdSetRealValue(int argc, VALUE *argv, VALUE self) {
    FXRealSpinner *arg1 = (FXRealSpinner *) 0 ; FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ;
    long result; FXdouble value4 ; VALUE vresult = Qnil; if ((argc < 3) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRealSpinner, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); {
        value4 = (FXdouble) NUM2DBL(argv[2]); arg4 = (void *) &value4; } 
    result = (long)(arg1)->onCmdSetRealValue(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXRealSpinner_onCmdGetRealValue(int argc, VALUE *argv, VALUE self) {
    FXRealSpinner *arg1 = (FXRealSpinner *) 0 ; FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ;
    long result; VALUE vresult = Qnil; if ((argc < 3) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRealSpinner, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdGetRealValue(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXRealSpinner_onCmdSetRealRange(int argc, VALUE *argv, VALUE self) {
    FXRealSpinner *arg1 = (FXRealSpinner *) 0 ; FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ;
    long result; FXdouble values4[2] ; VALUE vresult = Qnil; if ((argc < 3) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRealSpinner, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); { Check_Type(argv[2], T_ARRAY);
        values4[0] = (FXdouble) NUM2DBL(rb_ary_entry(argv[2], 0)); values4[1] = (FXdouble) NUM2DBL(rb_ary_entry(argv[2], 1));
        arg4 = (void *) values4; }  result = (long)(arg1)->onCmdSetRealRange(arg2,arg3,arg4); vresult = INT2NUM(result);
    return vresult; }
static VALUE _wrap_FXRealSpinner_onCmdGetRealRange(int argc, VALUE *argv, VALUE self) {
    FXRealSpinner *arg1 = (FXRealSpinner *) 0 ; FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ;
    long result; VALUE vresult = Qnil; if ((argc < 3) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRealSpinner, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]);
    SWIG_ConvertPtr(argv[2], (void **) &arg4, 0, 1); result = (long)(arg1)->onCmdGetRealRange(arg2,arg3,arg4);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXRealSpinner_onFocusSelf(int argc, VALUE *argv, VALUE self) { FXRealSpinner *arg1 = (FXRealSpinner *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRealSpinner, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onFocusSelf(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE _wrap_FXRealSpinner_allocate(VALUE self) {
#else
     static VALUE _wrap_FXRealSpinner_allocate(int argc, VALUE *argv, VALUE self) {
#endif
         VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_FXRealSpinner);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
         return vresult; }
static VALUE _wrap_new_FXRealSpinner(int argc, VALUE *argv, VALUE self) { FXComposite *arg1 = (FXComposite *) 0 ; FXint arg2 ;
    FXObject *arg3 = (FXObject *) 0 ; FXSelector arg4 = (FXSelector) 0 ; FXuint arg5 = (FXuint) REALSPIN_NORMAL ;
    FXint arg6 = (FXint) 0 ; FXint arg7 = (FXint) 0 ; FXint arg8 = (FXint) 0 ; FXint arg9 = (FXint) 0 ;
    FXint arg10 = (FXint) DEFAULT_PAD ; FXint arg11 = (FXint) DEFAULT_PAD ; FXint arg12 = (FXint) DEFAULT_PAD ;
    FXint arg13 = (FXint) DEFAULT_PAD ; FXRealSpinner *result; if ((argc < 2) || (argc > 13))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXComposite, 1); arg2 = NUM2INT(argv[1]); if (argc > 2) {
        SWIG_ConvertPtr(argv[2], (void **) &arg3, SWIGTYPE_p_FXObject, 1); }  if (argc > 3) { arg4 = NUM2UINT(argv[3]); } 
    if (argc > 4) { arg5 = NUM2UINT(argv[4]); }  if (argc > 5) { arg6 = NUM2INT(argv[5]); }  if (argc > 6) {
        arg7 = NUM2INT(argv[6]); }  if (argc > 7) { arg8 = NUM2INT(argv[7]); }  if (argc > 8) { arg9 = NUM2INT(argv[8]); } 
    if (argc > 9) { arg10 = NUM2INT(argv[9]); }  if (argc > 10) { arg11 = NUM2INT(argv[10]); }  if (argc > 11) {
        arg12 = NUM2INT(argv[11]); }  if (argc > 12) { arg13 = NUM2INT(argv[12]); }  {
        result = (FXRealSpinner *)new_FXRealSpinner(arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8,arg9,arg10,arg11,arg12,arg13);
        DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result); if(rb_block_given_p()){ rb_yield(self); }  }  return self; }
static VALUE _wrap_FXRealSpinner_increment(int argc, VALUE *argv, VALUE self) { FXRealSpinner *arg1 = (FXRealSpinner *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRealSpinner, 1); (arg1)->increment(); return Qnil; }
static VALUE _wrap_FXRealSpinner_decrement(int argc, VALUE *argv, VALUE self) { FXRealSpinner *arg1 = (FXRealSpinner *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRealSpinner, 1); (arg1)->decrement(); return Qnil; }
static VALUE _wrap_FXRealSpinner_isCyclic(int argc, VALUE *argv, VALUE self) { FXRealSpinner *arg1 = (FXRealSpinner *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRealSpinner, 1);
    result = (FXbool)((FXRealSpinner const *)arg1)->isCyclic(); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXRealSpinner_setCyclic(int argc, VALUE *argv, VALUE self) { FXRealSpinner *arg1 = (FXRealSpinner *) 0 ;
    FXbool arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRealSpinner, 1); arg2 = to_FXbool(argv[0]); (arg1)->setCyclic(arg2);
    return Qnil; }
static VALUE _wrap_FXRealSpinner_isTextVisible(int argc, VALUE *argv, VALUE self) { FXRealSpinner *arg1 = (FXRealSpinner *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRealSpinner, 1);
    result = (FXbool)((FXRealSpinner const *)arg1)->isTextVisible(); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXRealSpinner_setTextVisible(int argc, VALUE *argv, VALUE self) { FXRealSpinner *arg1 = (FXRealSpinner *) 0 ;
    FXbool arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRealSpinner, 1); arg2 = to_FXbool(argv[0]);
    (arg1)->setTextVisible(arg2); return Qnil; }
static VALUE _wrap_FXRealSpinner_getValue(int argc, VALUE *argv, VALUE self) { FXRealSpinner *arg1 = (FXRealSpinner *) 0 ;
    FXdouble result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRealSpinner, 1);
    result = (FXdouble)((FXRealSpinner const *)arg1)->getValue(); vresult = rb_float_new(result); return vresult; }
static VALUE _wrap_FXRealSpinner_setRange(int argc, VALUE *argv, VALUE self) { FXRealSpinner *arg1 = (FXRealSpinner *) 0 ;
    VALUE arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRealSpinner, 1); arg2 = argv[0]; FXRealSpinner_setRange(arg1,arg2);
    return Qnil; }
static VALUE _wrap_FXRealSpinner_getRange(int argc, VALUE *argv, VALUE self) { FXRealSpinner *arg1 = (FXRealSpinner *) 0 ;
    VALUE result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRealSpinner, 1);
    result = (VALUE)FXRealSpinner_getRange((FXRealSpinner const *)arg1); vresult = result; return vresult; }
static VALUE _wrap_FXRealSpinner_setIncrement(int argc, VALUE *argv, VALUE self) { FXRealSpinner *arg1 = (FXRealSpinner *) 0 ;
    FXdouble arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRealSpinner, 1); arg2 = (FXdouble) NUM2DBL(argv[0]);
    (arg1)->setIncrement(arg2); return Qnil; }
static VALUE _wrap_FXRealSpinner_getIncrement(int argc, VALUE *argv, VALUE self) { FXRealSpinner *arg1 = (FXRealSpinner *) 0 ;
    FXdouble result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRealSpinner, 1);
    result = (FXdouble)((FXRealSpinner const *)arg1)->getIncrement(); vresult = rb_float_new(result); return vresult; }
static VALUE _wrap_FXRealSpinner_setFont(int argc, VALUE *argv, VALUE self) { FXRealSpinner *arg1 = (FXRealSpinner *) 0 ;
    FXFont *arg2 = (FXFont *) 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRealSpinner, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXFont, 1); (arg1)->setFont(arg2); return Qnil; }
static VALUE _wrap_FXRealSpinner_getFont(int argc, VALUE *argv, VALUE self) { FXRealSpinner *arg1 = (FXRealSpinner *) 0 ;
    FXFont *result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRealSpinner, 1);
    result = (FXFont *)((FXRealSpinner const *)arg1)->getFont(); {
        swig_type_info *ty = SWIG_TypeDynamicCast(SWIGTYPE_p_FXFont, (void **) &result); vresult = FXRbGetRubyObj(result, ty); }
     return vresult; }
static VALUE _wrap_FXRealSpinner_setHelpText(int argc, VALUE *argv, VALUE self) { FXRealSpinner *arg1 = (FXRealSpinner *) 0 ;
    FXString *arg2 = 0 ; SwigValueWrapper<FXString > p2 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRealSpinner, 1); p2 = to_FXString(argv[0]); arg2 = &p2;
    (arg1)->setHelpText((FXString const &)*arg2); return Qnil; }
static VALUE _wrap_FXRealSpinner_getHelpText(int argc, VALUE *argv, VALUE self) { FXRealSpinner *arg1 = (FXRealSpinner *) 0 ;
    FXString result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRealSpinner, 1); result = ((FXRealSpinner const *)arg1)->getHelpText();
    vresult = rb_str_new2((&result)->text()); return vresult; }
static VALUE _wrap_FXRealSpinner_setTipText(int argc, VALUE *argv, VALUE self) { FXRealSpinner *arg1 = (FXRealSpinner *) 0 ;
    FXString *arg2 = 0 ; SwigValueWrapper<FXString > p2 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRealSpinner, 1); p2 = to_FXString(argv[0]); arg2 = &p2;
    (arg1)->setTipText((FXString const &)*arg2); return Qnil; }
static VALUE _wrap_FXRealSpinner_getTipText(int argc, VALUE *argv, VALUE self) { FXRealSpinner *arg1 = (FXRealSpinner *) 0 ;
    FXString result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRealSpinner, 1); result = ((FXRealSpinner const *)arg1)->getTipText();
    vresult = rb_str_new2((&result)->text()); return vresult; }
static VALUE _wrap_FXRealSpinner_setSpinnerStyle(int argc, VALUE *argv, VALUE self) {
    FXRealSpinner *arg1 = (FXRealSpinner *) 0 ; FXuint arg2 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRealSpinner, 1); arg2 = NUM2UINT(argv[0]);
    (arg1)->setSpinnerStyle(arg2); return Qnil; }
static VALUE _wrap_FXRealSpinner_getSpinnerStyle(int argc, VALUE *argv, VALUE self) {
    FXRealSpinner *arg1 = (FXRealSpinner *) 0 ; FXuint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRealSpinner, 1);
    result = (FXuint)((FXRealSpinner const *)arg1)->getSpinnerStyle(); vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXRealSpinner_setEditable(int argc, VALUE *argv, VALUE self) { FXRealSpinner *arg1 = (FXRealSpinner *) 0 ;
    FXbool arg2 = (FXbool) 1 ; if ((argc < 0) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRealSpinner, 1); if (argc > 0) { arg2 = to_FXbool(argv[0]); } 
    (arg1)->setEditable(arg2); return Qnil; }
static VALUE _wrap_FXRealSpinner_isEditable(int argc, VALUE *argv, VALUE self) { FXRealSpinner *arg1 = (FXRealSpinner *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRealSpinner, 1);
    result = (FXbool)((FXRealSpinner const *)arg1)->isEditable(); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXRealSpinner_setUpArrowColor(int argc, VALUE *argv, VALUE self) {
    FXRealSpinner *arg1 = (FXRealSpinner *) 0 ; FXColor arg2 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRealSpinner, 1); arg2 = to_FXColor(argv[0]);
    (arg1)->setUpArrowColor(arg2); return Qnil; }
static VALUE _wrap_FXRealSpinner_getUpArrowColor(int argc, VALUE *argv, VALUE self) {
    FXRealSpinner *arg1 = (FXRealSpinner *) 0 ; FXColor result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRealSpinner, 1);
    result = (FXColor)((FXRealSpinner const *)arg1)->getUpArrowColor(); vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXRealSpinner_setDownArrowColor(int argc, VALUE *argv, VALUE self) {
    FXRealSpinner *arg1 = (FXRealSpinner *) 0 ; FXColor arg2 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRealSpinner, 1); arg2 = to_FXColor(argv[0]);
    (arg1)->setDownArrowColor(arg2); return Qnil; }
static VALUE _wrap_FXRealSpinner_getDownArrowColor(int argc, VALUE *argv, VALUE self) {
    FXRealSpinner *arg1 = (FXRealSpinner *) 0 ; FXColor result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRealSpinner, 1);
    result = (FXColor)((FXRealSpinner const *)arg1)->getDownArrowColor(); vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXRealSpinner_setTextColor(int argc, VALUE *argv, VALUE self) { FXRealSpinner *arg1 = (FXRealSpinner *) 0 ;
    FXColor arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRealSpinner, 1); arg2 = to_FXColor(argv[0]); (arg1)->setTextColor(arg2);
    return Qnil; }
static VALUE _wrap_FXRealSpinner_getTextColor(int argc, VALUE *argv, VALUE self) { FXRealSpinner *arg1 = (FXRealSpinner *) 0 ;
    FXColor result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRealSpinner, 1);
    result = (FXColor)((FXRealSpinner const *)arg1)->getTextColor(); vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXRealSpinner_setSelBackColor(int argc, VALUE *argv, VALUE self) {
    FXRealSpinner *arg1 = (FXRealSpinner *) 0 ; FXColor arg2 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRealSpinner, 1); arg2 = to_FXColor(argv[0]);
    (arg1)->setSelBackColor(arg2); return Qnil; }
static VALUE _wrap_FXRealSpinner_getSelBackColor(int argc, VALUE *argv, VALUE self) {
    FXRealSpinner *arg1 = (FXRealSpinner *) 0 ; FXColor result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRealSpinner, 1);
    result = (FXColor)((FXRealSpinner const *)arg1)->getSelBackColor(); vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXRealSpinner_setSelTextColor(int argc, VALUE *argv, VALUE self) {
    FXRealSpinner *arg1 = (FXRealSpinner *) 0 ; FXColor arg2 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRealSpinner, 1); arg2 = to_FXColor(argv[0]);
    (arg1)->setSelTextColor(arg2); return Qnil; }
static VALUE _wrap_FXRealSpinner_getSelTextColor(int argc, VALUE *argv, VALUE self) {
    FXRealSpinner *arg1 = (FXRealSpinner *) 0 ; FXColor result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRealSpinner, 1);
    result = (FXColor)((FXRealSpinner const *)arg1)->getSelTextColor(); vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXRealSpinner_setCursorColor(int argc, VALUE *argv, VALUE self) { FXRealSpinner *arg1 = (FXRealSpinner *) 0 ;
    FXColor arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRealSpinner, 1); arg2 = to_FXColor(argv[0]);
    (arg1)->setCursorColor(arg2); return Qnil; }
static VALUE _wrap_FXRealSpinner_getCursorColor(int argc, VALUE *argv, VALUE self) { FXRealSpinner *arg1 = (FXRealSpinner *) 0 ;
    FXColor result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRealSpinner, 1);
    result = (FXColor)((FXRealSpinner const *)arg1)->getCursorColor(); vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXRealSpinner_setNumColumns(int argc, VALUE *argv, VALUE self) { FXRealSpinner *arg1 = (FXRealSpinner *) 0 ;
    FXint arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRealSpinner, 1); arg2 = NUM2INT(argv[0]); (arg1)->setNumColumns(arg2);
    return Qnil; }
static VALUE _wrap_FXRealSpinner_getNumColumns(int argc, VALUE *argv, VALUE self) { FXRealSpinner *arg1 = (FXRealSpinner *) 0 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRealSpinner, 1);
    result = (FXint)((FXRealSpinner const *)arg1)->getNumColumns(); vresult = INT2NUM(result); return vresult; }
static void
free_FXRealSpinner(FXRealSpinner *arg1) {
    delete arg1;
}
static VALUE _wrap_FXRealSpinner_save(int argc, VALUE *argv, VALUE self) { FXRealSpinner *arg1 = (FXRealSpinner *) 0 ;
    FXStream *arg2 = 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRealSpinner, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXRealSpinner_save((FXRealSpinner const *)arg1,*arg2); return Qnil; }
static VALUE _wrap_FXRealSpinner_load(int argc, VALUE *argv, VALUE self) { FXRealSpinner *arg1 = (FXRealSpinner *) 0 ;
    FXStream *arg2 = 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRealSpinner, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXRealSpinner_load(arg1,*arg2); return Qnil; }
static VALUE _wrap_FXRealSpinner_create(int argc, VALUE *argv, VALUE self) { FXRealSpinner *arg1 = (FXRealSpinner *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRealSpinner, 1); FXRealSpinner_create(arg1); return Qnil; }
static VALUE _wrap_FXRealSpinner_detach(int argc, VALUE *argv, VALUE self) { FXRealSpinner *arg1 = (FXRealSpinner *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRealSpinner, 1); FXRealSpinner_detach(arg1); return Qnil; }
static VALUE _wrap_FXRealSpinner_destroy(int argc, VALUE *argv, VALUE self) { FXRealSpinner *arg1 = (FXRealSpinner *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRealSpinner, 1); FXRealSpinner_destroy(arg1); return Qnil; }
static VALUE _wrap_FXRealSpinner_resize(int argc, VALUE *argv, VALUE self) { FXRealSpinner *arg1 = (FXRealSpinner *) 0 ;
    FXint arg2 ; FXint arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRealSpinner, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    FXRealSpinner_resize(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXRealSpinner_getDefaultWidth(int argc, VALUE *argv, VALUE self) {
    FXRealSpinner *arg1 = (FXRealSpinner *) 0 ; FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRealSpinner, 1); result = (FXint)FXRealSpinner_getDefaultWidth(arg1);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXRealSpinner_getDefaultHeight(int argc, VALUE *argv, VALUE self) {
    FXRealSpinner *arg1 = (FXRealSpinner *) 0 ; FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRealSpinner, 1); result = (FXint)FXRealSpinner_getDefaultHeight(arg1);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXRealSpinner_getWidthForHeight(int argc, VALUE *argv, VALUE self) {
    FXRealSpinner *arg1 = (FXRealSpinner *) 0 ; FXint arg2 ; FXint result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRealSpinner, 1); arg2 = NUM2INT(argv[0]);
    result = (FXint)FXRealSpinner_getWidthForHeight(arg1,arg2); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXRealSpinner_getHeightForWidth(int argc, VALUE *argv, VALUE self) {
    FXRealSpinner *arg1 = (FXRealSpinner *) 0 ; FXint arg2 ; FXint result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRealSpinner, 1); arg2 = NUM2INT(argv[0]);
    result = (FXint)FXRealSpinner_getHeightForWidth(arg1,arg2); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXRealSpinner_canFocus(int argc, VALUE *argv, VALUE self) { FXRealSpinner *arg1 = (FXRealSpinner *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRealSpinner, 1);
    result = (FXbool)FXRealSpinner_canFocus((FXRealSpinner const *)arg1); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXRealSpinner_setFocus(int argc, VALUE *argv, VALUE self) { FXRealSpinner *arg1 = (FXRealSpinner *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRealSpinner, 1); FXRealSpinner_setFocus(arg1); return Qnil; }
static VALUE _wrap_FXRealSpinner_killFocus(int argc, VALUE *argv, VALUE self) { FXRealSpinner *arg1 = (FXRealSpinner *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRealSpinner, 1); FXRealSpinner_killFocus(arg1); return Qnil; }
static VALUE _wrap_FXRealSpinner_setDefault(int argc, VALUE *argv, VALUE self) { FXRealSpinner *arg1 = (FXRealSpinner *) 0 ;
    FXbool arg2 = (FXbool) 1 ; if ((argc < 0) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRealSpinner, 1); if (argc > 0) { arg2 = to_FXbool(argv[0]); } 
    FXRealSpinner_setDefault(arg1,arg2); return Qnil; }
static VALUE _wrap_FXRealSpinner_enable(int argc, VALUE *argv, VALUE self) { FXRealSpinner *arg1 = (FXRealSpinner *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRealSpinner, 1); FXRealSpinner_enable(arg1); return Qnil; }
static VALUE _wrap_FXRealSpinner_disable(int argc, VALUE *argv, VALUE self) { FXRealSpinner *arg1 = (FXRealSpinner *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRealSpinner, 1); FXRealSpinner_disable(arg1); return Qnil; }
static VALUE _wrap_FXRealSpinner_raiseWindow(int argc, VALUE *argv, VALUE self) { FXRealSpinner *arg1 = (FXRealSpinner *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRealSpinner, 1); FXRealSpinner_raise(arg1); return Qnil; }
static VALUE _wrap_FXRealSpinner_lower(int argc, VALUE *argv, VALUE self) { FXRealSpinner *arg1 = (FXRealSpinner *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRealSpinner, 1); FXRealSpinner_lower(arg1); return Qnil; }
static VALUE _wrap_FXRealSpinner_move(int argc, VALUE *argv, VALUE self) { FXRealSpinner *arg1 = (FXRealSpinner *) 0 ;
    FXint arg2 ; FXint arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRealSpinner, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    FXRealSpinner_move(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXRealSpinner_position(int argc, VALUE *argv, VALUE self) { FXRealSpinner *arg1 = (FXRealSpinner *) 0 ;
    FXint arg2 ; FXint arg3 ; FXint arg4 ; FXint arg5 ; if ((argc < 4) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRealSpinner, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    arg4 = NUM2INT(argv[2]); arg5 = NUM2INT(argv[3]); FXRealSpinner_position(arg1,arg2,arg3,arg4,arg5); return Qnil; }
static VALUE _wrap_FXRealSpinner_layout(int argc, VALUE *argv, VALUE self) { FXRealSpinner *arg1 = (FXRealSpinner *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRealSpinner, 1); FXRealSpinner_layout(arg1); return Qnil; }
static VALUE _wrap_FXRealSpinner_recalc(int argc, VALUE *argv, VALUE self) { FXRealSpinner *arg1 = (FXRealSpinner *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRealSpinner, 1); FXRealSpinner_recalc(arg1); return Qnil; }
static VALUE _wrap_FXRealSpinner_reparent(int argc, VALUE *argv, VALUE self) { FXRealSpinner *arg1 = (FXRealSpinner *) 0 ;
    FXComposite *arg2 = (FXComposite *) 0 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRealSpinner, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXComposite, 1); FXRealSpinner_reparent(arg1,arg2); return Qnil; }
static VALUE _wrap_FXRealSpinner_show(int argc, VALUE *argv, VALUE self) { FXRealSpinner *arg1 = (FXRealSpinner *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRealSpinner, 1); FXRealSpinner_show(arg1); return Qnil; }
static VALUE _wrap_FXRealSpinner_hide(int argc, VALUE *argv, VALUE self) { FXRealSpinner *arg1 = (FXRealSpinner *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRealSpinner, 1); FXRealSpinner_hide(arg1); return Qnil; }
static VALUE _wrap_FXRealSpinner_isComposite(int argc, VALUE *argv, VALUE self) { FXRealSpinner *arg1 = (FXRealSpinner *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRealSpinner, 1);
    result = (FXbool)FXRealSpinner_isComposite((FXRealSpinner const *)arg1); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXRealSpinner_contains(int argc, VALUE *argv, VALUE self) { FXRealSpinner *arg1 = (FXRealSpinner *) 0 ;
    FXint arg2 ; FXint arg3 ; FXbool result; VALUE vresult = Qnil; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRealSpinner, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    result = (FXbool)FXRealSpinner_contains((FXRealSpinner const *)arg1,arg2,arg3); vresult = result ? Qtrue : Qfalse;
    return vresult; }
static VALUE _wrap_FXRealSpinner_doesSaveUnder(int argc, VALUE *argv, VALUE self) { FXRealSpinner *arg1 = (FXRealSpinner *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRealSpinner, 1);
    result = (FXbool)FXRealSpinner_doesSaveUnder((FXRealSpinner const *)arg1); vresult = result ? Qtrue : Qfalse;
    return vresult; }
static VALUE _wrap_FXRealSpinner_setBackColor(int argc, VALUE *argv, VALUE self) { FXRealSpinner *arg1 = (FXRealSpinner *) 0 ;
    FXColor arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRealSpinner, 1); arg2 = to_FXColor(argv[0]);
    FXRealSpinner_setBackColor(arg1,arg2); return Qnil; }
static VALUE _wrap_FXRealSpinner_setValue(int argc, VALUE *argv, VALUE self) { FXRealSpinner *arg1 = (FXRealSpinner *) 0 ;
    FXdouble arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRealSpinner, 1); arg2 = (FXdouble) NUM2DBL(argv[0]);
    FXRealSpinner_setValue(arg1,arg2); return Qnil; }
static VALUE _wrap_FXCanvas_onPaint(int argc, VALUE *argv, VALUE self) { FXCanvas *arg1 = (FXCanvas *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXCanvas, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onPaint(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXCanvas_onMotion(int argc, VALUE *argv, VALUE self) { FXCanvas *arg1 = (FXCanvas *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXCanvas, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onMotion(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXCanvas_onKeyPress(int argc, VALUE *argv, VALUE self) { FXCanvas *arg1 = (FXCanvas *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXCanvas, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onKeyPress(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXCanvas_onKeyRelease(int argc, VALUE *argv, VALUE self) { FXCanvas *arg1 = (FXCanvas *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXCanvas, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onKeyRelease(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE _wrap_FXCanvas_allocate(VALUE self) {
#else
     static VALUE _wrap_FXCanvas_allocate(int argc, VALUE *argv, VALUE self) {
#endif
         VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_FXCanvas);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
         return vresult; }
static VALUE _wrap_new_FXCanvas(int argc, VALUE *argv, VALUE self) { FXComposite *arg1 = (FXComposite *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 = (FXSelector) 0 ; FXuint arg4 = (FXuint) FRAME_NORMAL ;
    FXint arg5 = (FXint) 0 ; FXint arg6 = (FXint) 0 ; FXint arg7 = (FXint) 0 ; FXint arg8 = (FXint) 0 ; FXCanvas *result;
    if ((argc < 1) || (argc > 8)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXComposite, 1); if (argc > 1) {
        SWIG_ConvertPtr(argv[1], (void **) &arg2, SWIGTYPE_p_FXObject, 1); }  if (argc > 2) { arg3 = NUM2UINT(argv[2]); } 
    if (argc > 3) { arg4 = NUM2UINT(argv[3]); }  if (argc > 4) { arg5 = NUM2INT(argv[4]); }  if (argc > 5) {
        arg6 = NUM2INT(argv[5]); }  if (argc > 6) { arg7 = NUM2INT(argv[6]); }  if (argc > 7) { arg8 = NUM2INT(argv[7]); }  {
        result = (FXCanvas *)new_FXCanvas(arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8);
        DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result); if(rb_block_given_p()){ rb_yield(self); }  }  return self; }
static void
free_FXCanvas(FXCanvas *arg1) {
    delete arg1;
}
static VALUE _wrap_FXCanvas_save(int argc, VALUE *argv, VALUE self) { FXCanvas *arg1 = (FXCanvas *) 0 ; FXStream *arg2 = 0 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXCanvas, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXCanvas_save((FXCanvas const *)arg1,*arg2); return Qnil; }
static VALUE _wrap_FXCanvas_load(int argc, VALUE *argv, VALUE self) { FXCanvas *arg1 = (FXCanvas *) 0 ; FXStream *arg2 = 0 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXCanvas, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXCanvas_load(arg1,*arg2); return Qnil; }
static VALUE _wrap_FXCanvas_create(int argc, VALUE *argv, VALUE self) { FXCanvas *arg1 = (FXCanvas *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXCanvas, 1); FXCanvas_create(arg1); return Qnil; }
static VALUE _wrap_FXCanvas_detach(int argc, VALUE *argv, VALUE self) { FXCanvas *arg1 = (FXCanvas *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXCanvas, 1); FXCanvas_detach(arg1); return Qnil; }
static VALUE _wrap_FXCanvas_destroy(int argc, VALUE *argv, VALUE self) { FXCanvas *arg1 = (FXCanvas *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXCanvas, 1); FXCanvas_destroy(arg1); return Qnil; }
static VALUE _wrap_FXCanvas_resize(int argc, VALUE *argv, VALUE self) { FXCanvas *arg1 = (FXCanvas *) 0 ; FXint arg2 ;
    FXint arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXCanvas, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    FXCanvas_resize(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXCanvas_getDefaultWidth(int argc, VALUE *argv, VALUE self) { FXCanvas *arg1 = (FXCanvas *) 0 ; FXint result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXCanvas, 1); result = (FXint)FXCanvas_getDefaultWidth(arg1);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXCanvas_getDefaultHeight(int argc, VALUE *argv, VALUE self) { FXCanvas *arg1 = (FXCanvas *) 0 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXCanvas, 1); result = (FXint)FXCanvas_getDefaultHeight(arg1);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXCanvas_getWidthForHeight(int argc, VALUE *argv, VALUE self) { FXCanvas *arg1 = (FXCanvas *) 0 ;
    FXint arg2 ; FXint result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXCanvas, 1); arg2 = NUM2INT(argv[0]);
    result = (FXint)FXCanvas_getWidthForHeight(arg1,arg2); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXCanvas_getHeightForWidth(int argc, VALUE *argv, VALUE self) { FXCanvas *arg1 = (FXCanvas *) 0 ;
    FXint arg2 ; FXint result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXCanvas, 1); arg2 = NUM2INT(argv[0]);
    result = (FXint)FXCanvas_getHeightForWidth(arg1,arg2); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXCanvas_canFocus(int argc, VALUE *argv, VALUE self) { FXCanvas *arg1 = (FXCanvas *) 0 ; FXbool result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXCanvas, 1); result = (FXbool)FXCanvas_canFocus((FXCanvas const *)arg1);
    vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXCanvas_setFocus(int argc, VALUE *argv, VALUE self) { FXCanvas *arg1 = (FXCanvas *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXCanvas, 1); FXCanvas_setFocus(arg1); return Qnil; }
static VALUE _wrap_FXCanvas_killFocus(int argc, VALUE *argv, VALUE self) { FXCanvas *arg1 = (FXCanvas *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXCanvas, 1); FXCanvas_killFocus(arg1); return Qnil; }
static VALUE _wrap_FXCanvas_setDefault(int argc, VALUE *argv, VALUE self) { FXCanvas *arg1 = (FXCanvas *) 0 ;
    FXbool arg2 = (FXbool) 1 ; if ((argc < 0) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXCanvas, 1); if (argc > 0) { arg2 = to_FXbool(argv[0]); } 
    FXCanvas_setDefault(arg1,arg2); return Qnil; }
static VALUE _wrap_FXCanvas_enable(int argc, VALUE *argv, VALUE self) { FXCanvas *arg1 = (FXCanvas *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXCanvas, 1); FXCanvas_enable(arg1); return Qnil; }
static VALUE _wrap_FXCanvas_disable(int argc, VALUE *argv, VALUE self) { FXCanvas *arg1 = (FXCanvas *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXCanvas, 1); FXCanvas_disable(arg1); return Qnil; }
static VALUE _wrap_FXCanvas_raiseWindow(int argc, VALUE *argv, VALUE self) { FXCanvas *arg1 = (FXCanvas *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXCanvas, 1); FXCanvas_raise(arg1); return Qnil; }
static VALUE _wrap_FXCanvas_lower(int argc, VALUE *argv, VALUE self) { FXCanvas *arg1 = (FXCanvas *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXCanvas, 1); FXCanvas_lower(arg1); return Qnil; }
static VALUE _wrap_FXCanvas_move(int argc, VALUE *argv, VALUE self) { FXCanvas *arg1 = (FXCanvas *) 0 ; FXint arg2 ;
    FXint arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXCanvas, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    FXCanvas_move(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXCanvas_position(int argc, VALUE *argv, VALUE self) { FXCanvas *arg1 = (FXCanvas *) 0 ; FXint arg2 ;
    FXint arg3 ; FXint arg4 ; FXint arg5 ; if ((argc < 4) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXCanvas, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    arg4 = NUM2INT(argv[2]); arg5 = NUM2INT(argv[3]); FXCanvas_position(arg1,arg2,arg3,arg4,arg5); return Qnil; }
static VALUE _wrap_FXCanvas_layout(int argc, VALUE *argv, VALUE self) { FXCanvas *arg1 = (FXCanvas *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXCanvas, 1); FXCanvas_layout(arg1); return Qnil; }
static VALUE _wrap_FXCanvas_recalc(int argc, VALUE *argv, VALUE self) { FXCanvas *arg1 = (FXCanvas *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXCanvas, 1); FXCanvas_recalc(arg1); return Qnil; }
static VALUE _wrap_FXCanvas_reparent(int argc, VALUE *argv, VALUE self) { FXCanvas *arg1 = (FXCanvas *) 0 ;
    FXComposite *arg2 = (FXComposite *) 0 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXCanvas, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXComposite, 1); FXCanvas_reparent(arg1,arg2); return Qnil; }
static VALUE _wrap_FXCanvas_show(int argc, VALUE *argv, VALUE self) { FXCanvas *arg1 = (FXCanvas *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXCanvas, 1); FXCanvas_show(arg1); return Qnil; }
static VALUE _wrap_FXCanvas_hide(int argc, VALUE *argv, VALUE self) { FXCanvas *arg1 = (FXCanvas *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXCanvas, 1); FXCanvas_hide(arg1); return Qnil; }
static VALUE _wrap_FXCanvas_isComposite(int argc, VALUE *argv, VALUE self) { FXCanvas *arg1 = (FXCanvas *) 0 ; FXbool result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXCanvas, 1);
    result = (FXbool)FXCanvas_isComposite((FXCanvas const *)arg1); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXCanvas_contains(int argc, VALUE *argv, VALUE self) { FXCanvas *arg1 = (FXCanvas *) 0 ; FXint arg2 ;
    FXint arg3 ; FXbool result; VALUE vresult = Qnil; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXCanvas, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    result = (FXbool)FXCanvas_contains((FXCanvas const *)arg1,arg2,arg3); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXCanvas_doesSaveUnder(int argc, VALUE *argv, VALUE self) { FXCanvas *arg1 = (FXCanvas *) 0 ; FXbool result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXCanvas, 1);
    result = (FXbool)FXCanvas_doesSaveUnder((FXCanvas const *)arg1); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXCanvas_setBackColor(int argc, VALUE *argv, VALUE self) { FXCanvas *arg1 = (FXCanvas *) 0 ; FXColor arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXCanvas, 1); arg2 = to_FXColor(argv[0]);
    FXCanvas_setBackColor(arg1,arg2); return Qnil; }
static VALUE _wrap_FXToolTip_onPaint(int argc, VALUE *argv, VALUE self) { FXToolTip *arg1 = (FXToolTip *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToolTip, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onPaint(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXToolTip_onUpdate(int argc, VALUE *argv, VALUE self) { FXToolTip *arg1 = (FXToolTip *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToolTip, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onUpdate(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXToolTip_onTipShow(int argc, VALUE *argv, VALUE self) { FXToolTip *arg1 = (FXToolTip *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToolTip, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onTipShow(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXToolTip_onTipHide(int argc, VALUE *argv, VALUE self) { FXToolTip *arg1 = (FXToolTip *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToolTip, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onTipHide(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXToolTip_onCmdGetStringValue(int argc, VALUE *argv, VALUE self) { FXToolTip *arg1 = (FXToolTip *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToolTip, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdGetStringValue(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXToolTip_onCmdSetStringValue(int argc, VALUE *argv, VALUE self) { FXToolTip *arg1 = (FXToolTip *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; FXString value4 ;
    VALUE vresult = Qnil; if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToolTip, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); {
        value4 = FXString(STR2CSTR(argv[2])); arg4 = (void *) &value4; } 
    result = (long)(arg1)->onCmdSetStringValue(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE _wrap_FXToolTip_allocate(VALUE self) {
#else
     static VALUE _wrap_FXToolTip_allocate(int argc, VALUE *argv, VALUE self) {
#endif
         VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_FXToolTip);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
         return vresult; }
static VALUE _wrap_new_FXToolTip(int argc, VALUE *argv, VALUE self) { FXApp *arg1 = (FXApp *) 0 ;
    FXuint arg2 = (FXuint) TOOLTIP_NORMAL ; FXint arg3 = (FXint) 0 ; FXint arg4 = (FXint) 0 ; FXint arg5 = (FXint) 0 ;
    FXint arg6 = (FXint) 0 ; FXToolTip *result; if ((argc < 1) || (argc > 6))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXApp, 1); if (argc > 1) { arg2 = NUM2UINT(argv[1]); }  if (argc > 2) {
        arg3 = NUM2INT(argv[2]); }  if (argc > 3) { arg4 = NUM2INT(argv[3]); }  if (argc > 4) { arg5 = NUM2INT(argv[4]); } 
    if (argc > 5) { arg6 = NUM2INT(argv[5]); }  { result = (FXToolTip *)new_FXToolTip(arg1,arg2,arg3,arg4,arg5,arg6);
        DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result); if(rb_block_given_p()){ rb_yield(self); }  }  return self; }
static VALUE _wrap_FXToolTip_setText(int argc, VALUE *argv, VALUE self) { FXToolTip *arg1 = (FXToolTip *) 0 ;
    FXString *arg2 = 0 ; SwigValueWrapper<FXString > p2 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToolTip, 1); p2 = to_FXString(argv[0]); arg2 = &p2;
    (arg1)->setText((FXString const &)*arg2); return Qnil; }
static VALUE _wrap_FXToolTip_getText(int argc, VALUE *argv, VALUE self) { FXToolTip *arg1 = (FXToolTip *) 0 ; FXString result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToolTip, 1); result = ((FXToolTip const *)arg1)->getText();
    vresult = rb_str_new2((&result)->text()); return vresult; }
static VALUE _wrap_FXToolTip_setFont(int argc, VALUE *argv, VALUE self) { FXToolTip *arg1 = (FXToolTip *) 0 ;
    FXFont *arg2 = (FXFont *) 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToolTip, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXFont, 1); (arg1)->setFont(arg2); return Qnil; }
static VALUE _wrap_FXToolTip_getFont(int argc, VALUE *argv, VALUE self) { FXToolTip *arg1 = (FXToolTip *) 0 ; FXFont *result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToolTip, 1); result = (FXFont *)((FXToolTip const *)arg1)->getFont(); {
        swig_type_info *ty = SWIG_TypeDynamicCast(SWIGTYPE_p_FXFont, (void **) &result); vresult = FXRbGetRubyObj(result, ty); }
     return vresult; }
static VALUE _wrap_FXToolTip_getTextColor(int argc, VALUE *argv, VALUE self) { FXToolTip *arg1 = (FXToolTip *) 0 ;
    FXColor result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToolTip, 1);
    result = (FXColor)((FXToolTip const *)arg1)->getTextColor(); vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXToolTip_setTextColor(int argc, VALUE *argv, VALUE self) { FXToolTip *arg1 = (FXToolTip *) 0 ;
    FXColor arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToolTip, 1); arg2 = to_FXColor(argv[0]); (arg1)->setTextColor(arg2);
    return Qnil; }
static void
free_FXToolTip(FXToolTip *arg1) {
    delete arg1;
}
static VALUE _wrap_FXToolTip_save(int argc, VALUE *argv, VALUE self) { FXToolTip *arg1 = (FXToolTip *) 0 ; FXStream *arg2 = 0 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToolTip, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXToolTip_save((FXToolTip const *)arg1,*arg2); return Qnil; }
static VALUE _wrap_FXToolTip_load(int argc, VALUE *argv, VALUE self) { FXToolTip *arg1 = (FXToolTip *) 0 ; FXStream *arg2 = 0 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToolTip, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXToolTip_load(arg1,*arg2); return Qnil; }
static VALUE _wrap_FXToolTip_create(int argc, VALUE *argv, VALUE self) { FXToolTip *arg1 = (FXToolTip *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToolTip, 1); FXToolTip_create(arg1); return Qnil; }
static VALUE _wrap_FXToolTip_detach(int argc, VALUE *argv, VALUE self) { FXToolTip *arg1 = (FXToolTip *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToolTip, 1); FXToolTip_detach(arg1); return Qnil; }
static VALUE _wrap_FXToolTip_destroy(int argc, VALUE *argv, VALUE self) { FXToolTip *arg1 = (FXToolTip *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToolTip, 1); FXToolTip_destroy(arg1); return Qnil; }
static VALUE _wrap_FXToolTip_resize(int argc, VALUE *argv, VALUE self) { FXToolTip *arg1 = (FXToolTip *) 0 ; FXint arg2 ;
    FXint arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToolTip, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    FXToolTip_resize(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXToolTip_getDefaultWidth(int argc, VALUE *argv, VALUE self) { FXToolTip *arg1 = (FXToolTip *) 0 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToolTip, 1); result = (FXint)FXToolTip_getDefaultWidth(arg1);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXToolTip_getDefaultHeight(int argc, VALUE *argv, VALUE self) { FXToolTip *arg1 = (FXToolTip *) 0 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToolTip, 1); result = (FXint)FXToolTip_getDefaultHeight(arg1);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXToolTip_getWidthForHeight(int argc, VALUE *argv, VALUE self) { FXToolTip *arg1 = (FXToolTip *) 0 ;
    FXint arg2 ; FXint result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToolTip, 1); arg2 = NUM2INT(argv[0]);
    result = (FXint)FXToolTip_getWidthForHeight(arg1,arg2); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXToolTip_getHeightForWidth(int argc, VALUE *argv, VALUE self) { FXToolTip *arg1 = (FXToolTip *) 0 ;
    FXint arg2 ; FXint result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToolTip, 1); arg2 = NUM2INT(argv[0]);
    result = (FXint)FXToolTip_getHeightForWidth(arg1,arg2); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXToolTip_canFocus(int argc, VALUE *argv, VALUE self) { FXToolTip *arg1 = (FXToolTip *) 0 ; FXbool result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToolTip, 1);
    result = (FXbool)FXToolTip_canFocus((FXToolTip const *)arg1); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXToolTip_setFocus(int argc, VALUE *argv, VALUE self) { FXToolTip *arg1 = (FXToolTip *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToolTip, 1); FXToolTip_setFocus(arg1); return Qnil; }
static VALUE _wrap_FXToolTip_killFocus(int argc, VALUE *argv, VALUE self) { FXToolTip *arg1 = (FXToolTip *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToolTip, 1); FXToolTip_killFocus(arg1); return Qnil; }
static VALUE _wrap_FXToolTip_setDefault(int argc, VALUE *argv, VALUE self) { FXToolTip *arg1 = (FXToolTip *) 0 ;
    FXbool arg2 = (FXbool) 1 ; if ((argc < 0) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToolTip, 1); if (argc > 0) { arg2 = to_FXbool(argv[0]); } 
    FXToolTip_setDefault(arg1,arg2); return Qnil; }
static VALUE _wrap_FXToolTip_enable(int argc, VALUE *argv, VALUE self) { FXToolTip *arg1 = (FXToolTip *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToolTip, 1); FXToolTip_enable(arg1); return Qnil; }
static VALUE _wrap_FXToolTip_disable(int argc, VALUE *argv, VALUE self) { FXToolTip *arg1 = (FXToolTip *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToolTip, 1); FXToolTip_disable(arg1); return Qnil; }
static VALUE _wrap_FXToolTip_raiseWindow(int argc, VALUE *argv, VALUE self) { FXToolTip *arg1 = (FXToolTip *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToolTip, 1); FXToolTip_raise(arg1); return Qnil; }
static VALUE _wrap_FXToolTip_lower(int argc, VALUE *argv, VALUE self) { FXToolTip *arg1 = (FXToolTip *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToolTip, 1); FXToolTip_lower(arg1); return Qnil; }
static VALUE _wrap_FXToolTip_move(int argc, VALUE *argv, VALUE self) { FXToolTip *arg1 = (FXToolTip *) 0 ; FXint arg2 ;
    FXint arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToolTip, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    FXToolTip_move(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXToolTip_position(int argc, VALUE *argv, VALUE self) { FXToolTip *arg1 = (FXToolTip *) 0 ; FXint arg2 ;
    FXint arg3 ; FXint arg4 ; FXint arg5 ; if ((argc < 4) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToolTip, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    arg4 = NUM2INT(argv[2]); arg5 = NUM2INT(argv[3]); FXToolTip_position(arg1,arg2,arg3,arg4,arg5); return Qnil; }
static VALUE _wrap_FXToolTip_layout(int argc, VALUE *argv, VALUE self) { FXToolTip *arg1 = (FXToolTip *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToolTip, 1); FXToolTip_layout(arg1); return Qnil; }
static VALUE _wrap_FXToolTip_recalc(int argc, VALUE *argv, VALUE self) { FXToolTip *arg1 = (FXToolTip *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToolTip, 1); FXToolTip_recalc(arg1); return Qnil; }
static VALUE _wrap_FXToolTip_reparent(int argc, VALUE *argv, VALUE self) { FXToolTip *arg1 = (FXToolTip *) 0 ;
    FXComposite *arg2 = (FXComposite *) 0 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToolTip, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXComposite, 1); FXToolTip_reparent(arg1,arg2); return Qnil; }
static VALUE _wrap_FXToolTip_show(int argc, VALUE *argv, VALUE self) { FXToolTip *arg1 = (FXToolTip *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToolTip, 1); FXToolTip_show(arg1); return Qnil; }
static VALUE _wrap_FXToolTip_hide(int argc, VALUE *argv, VALUE self) { FXToolTip *arg1 = (FXToolTip *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToolTip, 1); FXToolTip_hide(arg1); return Qnil; }
static VALUE _wrap_FXToolTip_isComposite(int argc, VALUE *argv, VALUE self) { FXToolTip *arg1 = (FXToolTip *) 0 ; FXbool result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToolTip, 1);
    result = (FXbool)FXToolTip_isComposite((FXToolTip const *)arg1); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXToolTip_contains(int argc, VALUE *argv, VALUE self) { FXToolTip *arg1 = (FXToolTip *) 0 ; FXint arg2 ;
    FXint arg3 ; FXbool result; VALUE vresult = Qnil; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToolTip, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    result = (FXbool)FXToolTip_contains((FXToolTip const *)arg1,arg2,arg3); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXToolTip_doesSaveUnder(int argc, VALUE *argv, VALUE self) { FXToolTip *arg1 = (FXToolTip *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToolTip, 1);
    result = (FXbool)FXToolTip_doesSaveUnder((FXToolTip const *)arg1); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXToolTip_setBackColor(int argc, VALUE *argv, VALUE self) { FXToolTip *arg1 = (FXToolTip *) 0 ;
    FXColor arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToolTip, 1); arg2 = to_FXColor(argv[0]);
    FXToolTip_setBackColor(arg1,arg2); return Qnil; }
static VALUE _wrap_FXToolBar_onCmdUndock(int argc, VALUE *argv, VALUE self) { FXToolBar *arg1 = (FXToolBar *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToolBar, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdUndock(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXToolBar_onUpdUndock(int argc, VALUE *argv, VALUE self) { FXToolBar *arg1 = (FXToolBar *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToolBar, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onUpdUndock(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXToolBar_onCmdDockTop(int argc, VALUE *argv, VALUE self) { FXToolBar *arg1 = (FXToolBar *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToolBar, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdDockTop(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXToolBar_onUpdDockTop(int argc, VALUE *argv, VALUE self) { FXToolBar *arg1 = (FXToolBar *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToolBar, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onUpdDockTop(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXToolBar_onCmdDockBottom(int argc, VALUE *argv, VALUE self) { FXToolBar *arg1 = (FXToolBar *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToolBar, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdDockBottom(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXToolBar_onUpdDockBottom(int argc, VALUE *argv, VALUE self) { FXToolBar *arg1 = (FXToolBar *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToolBar, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onUpdDockBottom(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXToolBar_onCmdDockLeft(int argc, VALUE *argv, VALUE self) { FXToolBar *arg1 = (FXToolBar *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToolBar, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdDockLeft(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXToolBar_onUpdDockLeft(int argc, VALUE *argv, VALUE self) { FXToolBar *arg1 = (FXToolBar *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToolBar, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onUpdDockLeft(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXToolBar_onCmdDockRight(int argc, VALUE *argv, VALUE self) { FXToolBar *arg1 = (FXToolBar *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToolBar, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdDockRight(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXToolBar_onUpdDockRight(int argc, VALUE *argv, VALUE self) { FXToolBar *arg1 = (FXToolBar *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToolBar, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onUpdDockRight(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXToolBar_onBeginDragGrip(int argc, VALUE *argv, VALUE self) { FXToolBar *arg1 = (FXToolBar *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToolBar, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onBeginDragGrip(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXToolBar_onEndDragGrip(int argc, VALUE *argv, VALUE self) { FXToolBar *arg1 = (FXToolBar *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToolBar, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onEndDragGrip(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXToolBar_onDraggedGrip(int argc, VALUE *argv, VALUE self) { FXToolBar *arg1 = (FXToolBar *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToolBar, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onDraggedGrip(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_new_FXToolBar__SWIG_0(int argc, VALUE *argv, VALUE self) { FXComposite *arg1 = (FXComposite *) 0 ;
    FXComposite *arg2 = (FXComposite *) 0 ; FXuint arg3 = (FXuint) LAYOUT_TOP|LAYOUT_LEFT|LAYOUT_FILL_X ;
    FXint arg4 = (FXint) 0 ; FXint arg5 = (FXint) 0 ; FXint arg6 = (FXint) 0 ; FXint arg7 = (FXint) 0 ; FXint arg8 = (FXint) 3 ;
    FXint arg9 = (FXint) 3 ; FXint arg10 = (FXint) 2 ; FXint arg11 = (FXint) 2 ; FXint arg12 = (FXint) DEFAULT_SPACING ;
    FXint arg13 = (FXint) DEFAULT_SPACING ; FXToolBar *result; if ((argc < 2) || (argc > 13))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXComposite, 1);
    SWIG_ConvertPtr(argv[1], (void **) &arg2, SWIGTYPE_p_FXComposite, 1); if (argc > 2) { arg3 = NUM2UINT(argv[2]); } 
    if (argc > 3) { arg4 = NUM2INT(argv[3]); }  if (argc > 4) { arg5 = NUM2INT(argv[4]); }  if (argc > 5) {
        arg6 = NUM2INT(argv[5]); }  if (argc > 6) { arg7 = NUM2INT(argv[6]); }  if (argc > 7) { arg8 = NUM2INT(argv[7]); } 
    if (argc > 8) { arg9 = NUM2INT(argv[8]); }  if (argc > 9) { arg10 = NUM2INT(argv[9]); }  if (argc > 10) {
        arg11 = NUM2INT(argv[10]); }  if (argc > 11) { arg12 = NUM2INT(argv[11]); }  if (argc > 12) {
        arg13 = NUM2INT(argv[12]); }  {
        result = (FXToolBar *)new_FXToolBar__SWIG_0(arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8,arg9,arg10,arg11,arg12,arg13);
        DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result); if(rb_block_given_p()){ rb_yield(self); }  }  return self; }
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE _wrap_FXToolBar_allocate(VALUE self) {
#else
     static VALUE _wrap_FXToolBar_allocate(int argc, VALUE *argv, VALUE self) {
#endif
         VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_FXToolBar);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
         return vresult; }
static VALUE _wrap_new_FXToolBar__SWIG_1(int argc, VALUE *argv, VALUE self) { FXComposite *arg1 = (FXComposite *) 0 ;
    FXuint arg2 = (FXuint) LAYOUT_TOP|LAYOUT_LEFT|LAYOUT_FILL_X ; FXint arg3 = (FXint) 0 ; FXint arg4 = (FXint) 0 ;
    FXint arg5 = (FXint) 0 ; FXint arg6 = (FXint) 0 ; FXint arg7 = (FXint) 2 ; FXint arg8 = (FXint) 3 ; FXint arg9 = (FXint) 3 ;
    FXint arg10 = (FXint) 2 ; FXint arg11 = (FXint) DEFAULT_SPACING ; FXint arg12 = (FXint) DEFAULT_SPACING ; FXToolBar *result;
    if ((argc < 1) || (argc > 12)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXComposite, 1); if (argc > 1) { arg2 = NUM2UINT(argv[1]); } 
    if (argc > 2) { arg3 = NUM2INT(argv[2]); }  if (argc > 3) { arg4 = NUM2INT(argv[3]); }  if (argc > 4) {
        arg5 = NUM2INT(argv[4]); }  if (argc > 5) { arg6 = NUM2INT(argv[5]); }  if (argc > 6) { arg7 = NUM2INT(argv[6]); } 
    if (argc > 7) { arg8 = NUM2INT(argv[7]); }  if (argc > 8) { arg9 = NUM2INT(argv[8]); }  if (argc > 9) {
        arg10 = NUM2INT(argv[9]); }  if (argc > 10) { arg11 = NUM2INT(argv[10]); }  if (argc > 11) { arg12 = NUM2INT(argv[11]); }
     { result = (FXToolBar *)new_FXToolBar__SWIG_1(arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8,arg9,arg10,arg11,arg12);
        DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result); if(rb_block_given_p()){ rb_yield(self); }  }  return self; }
static VALUE _wrap_new_FXToolBar(int nargs, VALUE *args, VALUE self) { int argc; VALUE argv[13]; int ii; argc = nargs;
    for (ii = 0; (ii < argc) && (ii < 13); ii++) { argv[ii] = args[ii]; }  if ((argc >= 1) && (argc <= 12)) { int _v; {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXComposite, 0) != -1)) ? 1 : 0; }
         if (_v) { if (argc <= 1) { return _wrap_new_FXToolBar__SWIG_1(nargs, args, self);}  {
                _v = ((TYPE(argv[1]) == T_FIXNUM) || (TYPE(argv[1]) == T_BIGNUM)) ? 1 : 0; }  if (_v) { if (argc <= 2) {
                    return _wrap_new_FXToolBar__SWIG_1(nargs, args, self);}  {
                    _v = ((TYPE(argv[2]) == T_FIXNUM) || (TYPE(argv[2]) == T_BIGNUM)) ? 1 : 0; }  if (_v) { if (argc <= 3) {
                        return _wrap_new_FXToolBar__SWIG_1(nargs, args, self);}  {
                        _v = ((TYPE(argv[3]) == T_FIXNUM) || (TYPE(argv[3]) == T_BIGNUM)) ? 1 : 0; }  if (_v) { if (argc <= 4) {
                            return _wrap_new_FXToolBar__SWIG_1(nargs, args, self);}  {
                            _v = ((TYPE(argv[4]) == T_FIXNUM) || (TYPE(argv[4]) == T_BIGNUM)) ? 1 : 0; }  if (_v) {
                            if (argc <= 5) { return _wrap_new_FXToolBar__SWIG_1(nargs, args, self);}  {
                                _v = ((TYPE(argv[5]) == T_FIXNUM) || (TYPE(argv[5]) == T_BIGNUM)) ? 1 : 0; }  if (_v) {
                                if (argc <= 6) { return _wrap_new_FXToolBar__SWIG_1(nargs, args, self);}  {
                                    _v = ((TYPE(argv[6]) == T_FIXNUM) || (TYPE(argv[6]) == T_BIGNUM)) ? 1 : 0; }  if (_v) {
                                    if (argc <= 7) { return _wrap_new_FXToolBar__SWIG_1(nargs, args, self);}  {
                                        _v = ((TYPE(argv[7]) == T_FIXNUM) || (TYPE(argv[7]) == T_BIGNUM)) ? 1 : 0; }  if (_v) {
                                        if (argc <= 8) { return _wrap_new_FXToolBar__SWIG_1(nargs, args, self);}  {
                                            _v = ((TYPE(argv[8]) == T_FIXNUM) || (TYPE(argv[8]) == T_BIGNUM)) ? 1 : 0; } 
                                        if (_v) { if (argc <= 9) { return _wrap_new_FXToolBar__SWIG_1(nargs, args, self);}  {
                                                _v = ((TYPE(argv[9]) == T_FIXNUM) || (TYPE(argv[9]) == T_BIGNUM)) ? 1 : 0; } 
                                            if (_v) { if (argc <= 10) { return _wrap_new_FXToolBar__SWIG_1(nargs, args, self);} 
                                                { _v = ((TYPE(argv[10]) == T_FIXNUM) || (TYPE(argv[10]) == T_BIGNUM)) ? 1 : 0; }
                                                 if (_v) { if (argc <= 11) {
                                                        return _wrap_new_FXToolBar__SWIG_1(nargs, args, self);}  {
                                                        _v = ((TYPE(argv[11]) == T_FIXNUM) || (TYPE(argv[11]) == T_BIGNUM)) ? 1 : 0; }
                                                     if (_v) { return _wrap_new_FXToolBar__SWIG_1(nargs, args, self);}  }  }  }
                                         }  }  }  }  }  }  }  }  }  if ((argc >= 2) && (argc <= 13)) { int _v; { void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXComposite, 0) != -1)) ? 1 : 0; }
         if (_v) { { void *ptr;
                _v = (NIL_P(argv[1]) || (TYPE(argv[1]) == T_DATA && SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_FXComposite, 0) != -1)) ? 1 : 0; }
             if (_v) { if (argc <= 2) { return _wrap_new_FXToolBar__SWIG_0(nargs, args, self);}  {
                    _v = ((TYPE(argv[2]) == T_FIXNUM) || (TYPE(argv[2]) == T_BIGNUM)) ? 1 : 0; }  if (_v) { if (argc <= 3) {
                        return _wrap_new_FXToolBar__SWIG_0(nargs, args, self);}  {
                        _v = ((TYPE(argv[3]) == T_FIXNUM) || (TYPE(argv[3]) == T_BIGNUM)) ? 1 : 0; }  if (_v) { if (argc <= 4) {
                            return _wrap_new_FXToolBar__SWIG_0(nargs, args, self);}  {
                            _v = ((TYPE(argv[4]) == T_FIXNUM) || (TYPE(argv[4]) == T_BIGNUM)) ? 1 : 0; }  if (_v) {
                            if (argc <= 5) { return _wrap_new_FXToolBar__SWIG_0(nargs, args, self);}  {
                                _v = ((TYPE(argv[5]) == T_FIXNUM) || (TYPE(argv[5]) == T_BIGNUM)) ? 1 : 0; }  if (_v) {
                                if (argc <= 6) { return _wrap_new_FXToolBar__SWIG_0(nargs, args, self);}  {
                                    _v = ((TYPE(argv[6]) == T_FIXNUM) || (TYPE(argv[6]) == T_BIGNUM)) ? 1 : 0; }  if (_v) {
                                    if (argc <= 7) { return _wrap_new_FXToolBar__SWIG_0(nargs, args, self);}  {
                                        _v = ((TYPE(argv[7]) == T_FIXNUM) || (TYPE(argv[7]) == T_BIGNUM)) ? 1 : 0; }  if (_v) {
                                        if (argc <= 8) { return _wrap_new_FXToolBar__SWIG_0(nargs, args, self);}  {
                                            _v = ((TYPE(argv[8]) == T_FIXNUM) || (TYPE(argv[8]) == T_BIGNUM)) ? 1 : 0; } 
                                        if (_v) { if (argc <= 9) { return _wrap_new_FXToolBar__SWIG_0(nargs, args, self);}  {
                                                _v = ((TYPE(argv[9]) == T_FIXNUM) || (TYPE(argv[9]) == T_BIGNUM)) ? 1 : 0; } 
                                            if (_v) { if (argc <= 10) { return _wrap_new_FXToolBar__SWIG_0(nargs, args, self);} 
                                                { _v = ((TYPE(argv[10]) == T_FIXNUM) || (TYPE(argv[10]) == T_BIGNUM)) ? 1 : 0; }
                                                 if (_v) { if (argc <= 11) {
                                                        return _wrap_new_FXToolBar__SWIG_0(nargs, args, self);}  {
                                                        _v = ((TYPE(argv[11]) == T_FIXNUM) || (TYPE(argv[11]) == T_BIGNUM)) ? 1 : 0; }
                                                     if (_v) { if (argc <= 12) {
                                                            return _wrap_new_FXToolBar__SWIG_0(nargs, args, self);}  {
                                                            _v = ((TYPE(argv[12]) == T_FIXNUM) || (TYPE(argv[12]) == T_BIGNUM)) ? 1 : 0; }
                                                         if (_v) { return _wrap_new_FXToolBar__SWIG_0(nargs, args, self);}  }  }
                                                 }  }  }  }  }  }  }  }  }  }  } 
    rb_raise(rb_eArgError, "No matching function for overloaded 'new_FXToolBar'"); return Qnil; }
static VALUE _wrap_FXToolBar_setDryDock(int argc, VALUE *argv, VALUE self) { FXToolBar *arg1 = (FXToolBar *) 0 ;
    FXComposite *arg2 = (FXComposite *) 0 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToolBar, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXComposite, 1); (arg1)->setDryDock(arg2); return Qnil; }
static VALUE _wrap_FXToolBar_setWetDock(int argc, VALUE *argv, VALUE self) { FXToolBar *arg1 = (FXToolBar *) 0 ;
    FXComposite *arg2 = (FXComposite *) 0 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToolBar, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXComposite, 1); (arg1)->setWetDock(arg2); return Qnil; }
static VALUE _wrap_FXToolBar_getDryDock(int argc, VALUE *argv, VALUE self) { FXToolBar *arg1 = (FXToolBar *) 0 ;
    FXComposite *result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToolBar, 1);
    result = (FXComposite *)((FXToolBar const *)arg1)->getDryDock(); {
        swig_type_info *ty = SWIG_TypeDynamicCast(SWIGTYPE_p_FXComposite, (void **) &result);
        vresult = FXRbGetRubyObj(result, ty); }  return vresult; }
static VALUE _wrap_FXToolBar_getWetDock(int argc, VALUE *argv, VALUE self) { FXToolBar *arg1 = (FXToolBar *) 0 ;
    FXComposite *result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToolBar, 1);
    result = (FXComposite *)((FXToolBar const *)arg1)->getWetDock(); {
        swig_type_info *ty = SWIG_TypeDynamicCast(SWIGTYPE_p_FXComposite, (void **) &result);
        vresult = FXRbGetRubyObj(result, ty); }  return vresult; }
static VALUE _wrap_FXToolBar_isDocked(int argc, VALUE *argv, VALUE self) { FXToolBar *arg1 = (FXToolBar *) 0 ; FXbool result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToolBar, 1); result = (FXbool)((FXToolBar const *)arg1)->isDocked();
    vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXToolBar_setDockingSide(int argc, VALUE *argv, VALUE self) { FXToolBar *arg1 = (FXToolBar *) 0 ;
    FXuint arg2 = (FXuint) LAYOUT_SIDE_TOP ; if ((argc < 0) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToolBar, 1); if (argc > 0) { arg2 = NUM2UINT(argv[0]); } 
    (arg1)->setDockingSide(arg2); return Qnil; }
static VALUE _wrap_FXToolBar_getDockingSide(int argc, VALUE *argv, VALUE self) { FXToolBar *arg1 = (FXToolBar *) 0 ;
    FXuint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToolBar, 1);
    result = (FXuint)((FXToolBar const *)arg1)->getDockingSide(); vresult = UINT2NUM(result); return vresult; }
static void
free_FXToolBar(FXToolBar *arg1) {
    delete arg1;
}
static VALUE _wrap_FXToolBar_save(int argc, VALUE *argv, VALUE self) { FXToolBar *arg1 = (FXToolBar *) 0 ; FXStream *arg2 = 0 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToolBar, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXToolBar_save((FXToolBar const *)arg1,*arg2); return Qnil; }
static VALUE _wrap_FXToolBar_load(int argc, VALUE *argv, VALUE self) { FXToolBar *arg1 = (FXToolBar *) 0 ; FXStream *arg2 = 0 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToolBar, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXToolBar_load(arg1,*arg2); return Qnil; }
static VALUE _wrap_FXToolBar_create(int argc, VALUE *argv, VALUE self) { FXToolBar *arg1 = (FXToolBar *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToolBar, 1); FXToolBar_create(arg1); return Qnil; }
static VALUE _wrap_FXToolBar_detach(int argc, VALUE *argv, VALUE self) { FXToolBar *arg1 = (FXToolBar *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToolBar, 1); FXToolBar_detach(arg1); return Qnil; }
static VALUE _wrap_FXToolBar_destroy(int argc, VALUE *argv, VALUE self) { FXToolBar *arg1 = (FXToolBar *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToolBar, 1); FXToolBar_destroy(arg1); return Qnil; }
static VALUE _wrap_FXToolBar_resize(int argc, VALUE *argv, VALUE self) { FXToolBar *arg1 = (FXToolBar *) 0 ; FXint arg2 ;
    FXint arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToolBar, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    FXToolBar_resize(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXToolBar_getDefaultWidth(int argc, VALUE *argv, VALUE self) { FXToolBar *arg1 = (FXToolBar *) 0 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToolBar, 1); result = (FXint)FXToolBar_getDefaultWidth(arg1);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXToolBar_getDefaultHeight(int argc, VALUE *argv, VALUE self) { FXToolBar *arg1 = (FXToolBar *) 0 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToolBar, 1); result = (FXint)FXToolBar_getDefaultHeight(arg1);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXToolBar_getWidthForHeight(int argc, VALUE *argv, VALUE self) { FXToolBar *arg1 = (FXToolBar *) 0 ;
    FXint arg2 ; FXint result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToolBar, 1); arg2 = NUM2INT(argv[0]);
    result = (FXint)FXToolBar_getWidthForHeight(arg1,arg2); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXToolBar_getHeightForWidth(int argc, VALUE *argv, VALUE self) { FXToolBar *arg1 = (FXToolBar *) 0 ;
    FXint arg2 ; FXint result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToolBar, 1); arg2 = NUM2INT(argv[0]);
    result = (FXint)FXToolBar_getHeightForWidth(arg1,arg2); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXToolBar_canFocus(int argc, VALUE *argv, VALUE self) { FXToolBar *arg1 = (FXToolBar *) 0 ; FXbool result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToolBar, 1);
    result = (FXbool)FXToolBar_canFocus((FXToolBar const *)arg1); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXToolBar_setFocus(int argc, VALUE *argv, VALUE self) { FXToolBar *arg1 = (FXToolBar *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToolBar, 1); FXToolBar_setFocus(arg1); return Qnil; }
static VALUE _wrap_FXToolBar_killFocus(int argc, VALUE *argv, VALUE self) { FXToolBar *arg1 = (FXToolBar *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToolBar, 1); FXToolBar_killFocus(arg1); return Qnil; }
static VALUE _wrap_FXToolBar_setDefault(int argc, VALUE *argv, VALUE self) { FXToolBar *arg1 = (FXToolBar *) 0 ;
    FXbool arg2 = (FXbool) 1 ; if ((argc < 0) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToolBar, 1); if (argc > 0) { arg2 = to_FXbool(argv[0]); } 
    FXToolBar_setDefault(arg1,arg2); return Qnil; }
static VALUE _wrap_FXToolBar_enable(int argc, VALUE *argv, VALUE self) { FXToolBar *arg1 = (FXToolBar *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToolBar, 1); FXToolBar_enable(arg1); return Qnil; }
static VALUE _wrap_FXToolBar_disable(int argc, VALUE *argv, VALUE self) { FXToolBar *arg1 = (FXToolBar *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToolBar, 1); FXToolBar_disable(arg1); return Qnil; }
static VALUE _wrap_FXToolBar_raiseWindow(int argc, VALUE *argv, VALUE self) { FXToolBar *arg1 = (FXToolBar *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToolBar, 1); FXToolBar_raise(arg1); return Qnil; }
static VALUE _wrap_FXToolBar_lower(int argc, VALUE *argv, VALUE self) { FXToolBar *arg1 = (FXToolBar *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToolBar, 1); FXToolBar_lower(arg1); return Qnil; }
static VALUE _wrap_FXToolBar_move(int argc, VALUE *argv, VALUE self) { FXToolBar *arg1 = (FXToolBar *) 0 ; FXint arg2 ;
    FXint arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToolBar, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    FXToolBar_move(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXToolBar_position(int argc, VALUE *argv, VALUE self) { FXToolBar *arg1 = (FXToolBar *) 0 ; FXint arg2 ;
    FXint arg3 ; FXint arg4 ; FXint arg5 ; if ((argc < 4) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToolBar, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    arg4 = NUM2INT(argv[2]); arg5 = NUM2INT(argv[3]); FXToolBar_position(arg1,arg2,arg3,arg4,arg5); return Qnil; }
static VALUE _wrap_FXToolBar_layout(int argc, VALUE *argv, VALUE self) { FXToolBar *arg1 = (FXToolBar *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToolBar, 1); FXToolBar_layout(arg1); return Qnil; }
static VALUE _wrap_FXToolBar_recalc(int argc, VALUE *argv, VALUE self) { FXToolBar *arg1 = (FXToolBar *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToolBar, 1); FXToolBar_recalc(arg1); return Qnil; }
static VALUE _wrap_FXToolBar_reparent(int argc, VALUE *argv, VALUE self) { FXToolBar *arg1 = (FXToolBar *) 0 ;
    FXComposite *arg2 = (FXComposite *) 0 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToolBar, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXComposite, 1); FXToolBar_reparent(arg1,arg2); return Qnil; }
static VALUE _wrap_FXToolBar_show(int argc, VALUE *argv, VALUE self) { FXToolBar *arg1 = (FXToolBar *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToolBar, 1); FXToolBar_show(arg1); return Qnil; }
static VALUE _wrap_FXToolBar_hide(int argc, VALUE *argv, VALUE self) { FXToolBar *arg1 = (FXToolBar *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToolBar, 1); FXToolBar_hide(arg1); return Qnil; }
static VALUE _wrap_FXToolBar_isComposite(int argc, VALUE *argv, VALUE self) { FXToolBar *arg1 = (FXToolBar *) 0 ; FXbool result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToolBar, 1);
    result = (FXbool)FXToolBar_isComposite((FXToolBar const *)arg1); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXToolBar_contains(int argc, VALUE *argv, VALUE self) { FXToolBar *arg1 = (FXToolBar *) 0 ; FXint arg2 ;
    FXint arg3 ; FXbool result; VALUE vresult = Qnil; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToolBar, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    result = (FXbool)FXToolBar_contains((FXToolBar const *)arg1,arg2,arg3); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXToolBar_doesSaveUnder(int argc, VALUE *argv, VALUE self) { FXToolBar *arg1 = (FXToolBar *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToolBar, 1);
    result = (FXbool)FXToolBar_doesSaveUnder((FXToolBar const *)arg1); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXToolBar_setBackColor(int argc, VALUE *argv, VALUE self) { FXToolBar *arg1 = (FXToolBar *) 0 ;
    FXColor arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToolBar, 1); arg2 = to_FXColor(argv[0]);
    FXToolBar_setBackColor(arg1,arg2); return Qnil; }
static VALUE _wrap_FXToolBar_dock(int argc, VALUE *argv, VALUE self) { FXToolBar *arg1 = (FXToolBar *) 0 ;
    FXuint arg2 = (FXuint) LAYOUT_SIDE_TOP ; FXWindow *arg3 = (FXWindow *) (FXWindow *) -1 ; if ((argc < 0) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToolBar, 1); if (argc > 0) { arg2 = NUM2UINT(argv[0]); } 
    if (argc > 1) { { if (TYPE(argv[1]) == T_FIXNUM) {
                arg3 = reinterpret_cast<FXWindow *>(static_cast<long>(NUM2INT(argv[1]))); }  else {
                SWIG_ConvertPtr(argv[1], (void **) &arg3, SWIGTYPE_p_FXWindow, 1); }  }  }  FXToolBar_dock(arg1,arg2,arg3);
    return Qnil; }
static VALUE _wrap_FXToolBar_undock(int argc, VALUE *argv, VALUE self) { FXToolBar *arg1 = (FXToolBar *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToolBar, 1); FXToolBar_undock(arg1); return Qnil; }
static VALUE _wrap_FXTabBar_onPaint(int argc, VALUE *argv, VALUE self) { FXTabBar *arg1 = (FXTabBar *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTabBar, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onPaint(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTabBar_onFocusNext(int argc, VALUE *argv, VALUE self) { FXTabBar *arg1 = (FXTabBar *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTabBar, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onFocusNext(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTabBar_onFocusPrev(int argc, VALUE *argv, VALUE self) { FXTabBar *arg1 = (FXTabBar *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTabBar, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onFocusPrev(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTabBar_onFocusUp(int argc, VALUE *argv, VALUE self) { FXTabBar *arg1 = (FXTabBar *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTabBar, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onFocusUp(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTabBar_onFocusDown(int argc, VALUE *argv, VALUE self) { FXTabBar *arg1 = (FXTabBar *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTabBar, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onFocusDown(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTabBar_onFocusLeft(int argc, VALUE *argv, VALUE self) { FXTabBar *arg1 = (FXTabBar *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTabBar, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onFocusLeft(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTabBar_onFocusRight(int argc, VALUE *argv, VALUE self) { FXTabBar *arg1 = (FXTabBar *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTabBar, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onFocusRight(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTabBar_onCmdOpenItem(int argc, VALUE *argv, VALUE self) { FXTabBar *arg1 = (FXTabBar *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTabBar, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdOpenItem(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTabBar_onCmdSetValue(int argc, VALUE *argv, VALUE self) { FXTabBar *arg1 = (FXTabBar *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTabBar, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]);
    arg4 = reinterpret_cast<void*>(NUM2INT(argv[2])); result = (long)(arg1)->onCmdSetValue(arg2,arg3,arg4);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTabBar_onCmdSetIntValue(int argc, VALUE *argv, VALUE self) { FXTabBar *arg1 = (FXTabBar *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; FXint value4 ;
    VALUE vresult = Qnil; if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTabBar, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); {
        value4 = (FXint) NUM2INT(argv[2]); arg4 = static_cast<void*>(&value4); } 
    result = (long)(arg1)->onCmdSetIntValue(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTabBar_onCmdGetIntValue(int argc, VALUE *argv, VALUE self) { FXTabBar *arg1 = (FXTabBar *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTabBar, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdGetIntValue(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTabBar_onCmdOpen(int argc, VALUE *argv, VALUE self) { FXTabBar *arg1 = (FXTabBar *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTabBar, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdOpen(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTabBar_onUpdOpen(int argc, VALUE *argv, VALUE self) { FXTabBar *arg1 = (FXTabBar *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTabBar, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onUpdOpen(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE _wrap_FXTabBar_allocate(VALUE self) {
#else
     static VALUE _wrap_FXTabBar_allocate(int argc, VALUE *argv, VALUE self) {
#endif
         VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_FXTabBar);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
         return vresult; }
static VALUE _wrap_new_FXTabBar(int argc, VALUE *argv, VALUE self) { FXComposite *arg1 = (FXComposite *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 = (FXSelector) 0 ; FXuint arg4 = (FXuint) TABBOOK_NORMAL ;
    FXint arg5 = (FXint) 0 ; FXint arg6 = (FXint) 0 ; FXint arg7 = (FXint) 0 ; FXint arg8 = (FXint) 0 ;
    FXint arg9 = (FXint) DEFAULT_SPACING ; FXint arg10 = (FXint) DEFAULT_SPACING ; FXint arg11 = (FXint) DEFAULT_SPACING ;
    FXint arg12 = (FXint) DEFAULT_SPACING ; FXTabBar *result; if ((argc < 1) || (argc > 12))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXComposite, 1); if (argc > 1) {
        SWIG_ConvertPtr(argv[1], (void **) &arg2, SWIGTYPE_p_FXObject, 1); }  if (argc > 2) { arg3 = NUM2UINT(argv[2]); } 
    if (argc > 3) { arg4 = NUM2UINT(argv[3]); }  if (argc > 4) { arg5 = NUM2INT(argv[4]); }  if (argc > 5) {
        arg6 = NUM2INT(argv[5]); }  if (argc > 6) { arg7 = NUM2INT(argv[6]); }  if (argc > 7) { arg8 = NUM2INT(argv[7]); } 
    if (argc > 8) { arg9 = NUM2INT(argv[8]); }  if (argc > 9) { arg10 = NUM2INT(argv[9]); }  if (argc > 10) {
        arg11 = NUM2INT(argv[10]); }  if (argc > 11) { arg12 = NUM2INT(argv[11]); }  {
        result = (FXTabBar *)new_FXTabBar(arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8,arg9,arg10,arg11,arg12);
        DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result); if(rb_block_given_p()){ rb_yield(self); }  }  return self; }
static VALUE _wrap_FXTabBar_getCurrent(int argc, VALUE *argv, VALUE self) { FXTabBar *arg1 = (FXTabBar *) 0 ; FXint result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTabBar, 1); result = (FXint)((FXTabBar const *)arg1)->getCurrent();
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTabBar_getTabStyle(int argc, VALUE *argv, VALUE self) { FXTabBar *arg1 = (FXTabBar *) 0 ; FXuint result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTabBar, 1); result = (FXuint)((FXTabBar const *)arg1)->getTabStyle();
    vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXTabBar_setTabStyle(int argc, VALUE *argv, VALUE self) { FXTabBar *arg1 = (FXTabBar *) 0 ; FXuint arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTabBar, 1); arg2 = NUM2UINT(argv[0]); (arg1)->setTabStyle(arg2);
    return Qnil; }
static void
free_FXTabBar(FXTabBar *arg1) {
    delete arg1;
}
static VALUE _wrap_FXTabBar_save(int argc, VALUE *argv, VALUE self) { FXTabBar *arg1 = (FXTabBar *) 0 ; FXStream *arg2 = 0 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTabBar, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXTabBar_save((FXTabBar const *)arg1,*arg2); return Qnil; }
static VALUE _wrap_FXTabBar_load(int argc, VALUE *argv, VALUE self) { FXTabBar *arg1 = (FXTabBar *) 0 ; FXStream *arg2 = 0 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTabBar, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXTabBar_load(arg1,*arg2); return Qnil; }
static VALUE _wrap_FXTabBar_create(int argc, VALUE *argv, VALUE self) { FXTabBar *arg1 = (FXTabBar *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTabBar, 1); FXTabBar_create(arg1); return Qnil; }
static VALUE _wrap_FXTabBar_detach(int argc, VALUE *argv, VALUE self) { FXTabBar *arg1 = (FXTabBar *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTabBar, 1); FXTabBar_detach(arg1); return Qnil; }
static VALUE _wrap_FXTabBar_destroy(int argc, VALUE *argv, VALUE self) { FXTabBar *arg1 = (FXTabBar *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTabBar, 1); FXTabBar_destroy(arg1); return Qnil; }
static VALUE _wrap_FXTabBar_resize(int argc, VALUE *argv, VALUE self) { FXTabBar *arg1 = (FXTabBar *) 0 ; FXint arg2 ;
    FXint arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTabBar, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    FXTabBar_resize(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXTabBar_getDefaultWidth(int argc, VALUE *argv, VALUE self) { FXTabBar *arg1 = (FXTabBar *) 0 ; FXint result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTabBar, 1); result = (FXint)FXTabBar_getDefaultWidth(arg1);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTabBar_getDefaultHeight(int argc, VALUE *argv, VALUE self) { FXTabBar *arg1 = (FXTabBar *) 0 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTabBar, 1); result = (FXint)FXTabBar_getDefaultHeight(arg1);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTabBar_getWidthForHeight(int argc, VALUE *argv, VALUE self) { FXTabBar *arg1 = (FXTabBar *) 0 ;
    FXint arg2 ; FXint result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTabBar, 1); arg2 = NUM2INT(argv[0]);
    result = (FXint)FXTabBar_getWidthForHeight(arg1,arg2); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTabBar_getHeightForWidth(int argc, VALUE *argv, VALUE self) { FXTabBar *arg1 = (FXTabBar *) 0 ;
    FXint arg2 ; FXint result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTabBar, 1); arg2 = NUM2INT(argv[0]);
    result = (FXint)FXTabBar_getHeightForWidth(arg1,arg2); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTabBar_canFocus(int argc, VALUE *argv, VALUE self) { FXTabBar *arg1 = (FXTabBar *) 0 ; FXbool result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTabBar, 1); result = (FXbool)FXTabBar_canFocus((FXTabBar const *)arg1);
    vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXTabBar_setFocus(int argc, VALUE *argv, VALUE self) { FXTabBar *arg1 = (FXTabBar *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTabBar, 1); FXTabBar_setFocus(arg1); return Qnil; }
static VALUE _wrap_FXTabBar_killFocus(int argc, VALUE *argv, VALUE self) { FXTabBar *arg1 = (FXTabBar *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTabBar, 1); FXTabBar_killFocus(arg1); return Qnil; }
static VALUE _wrap_FXTabBar_setDefault(int argc, VALUE *argv, VALUE self) { FXTabBar *arg1 = (FXTabBar *) 0 ;
    FXbool arg2 = (FXbool) 1 ; if ((argc < 0) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTabBar, 1); if (argc > 0) { arg2 = to_FXbool(argv[0]); } 
    FXTabBar_setDefault(arg1,arg2); return Qnil; }
static VALUE _wrap_FXTabBar_enable(int argc, VALUE *argv, VALUE self) { FXTabBar *arg1 = (FXTabBar *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTabBar, 1); FXTabBar_enable(arg1); return Qnil; }
static VALUE _wrap_FXTabBar_disable(int argc, VALUE *argv, VALUE self) { FXTabBar *arg1 = (FXTabBar *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTabBar, 1); FXTabBar_disable(arg1); return Qnil; }
static VALUE _wrap_FXTabBar_raiseWindow(int argc, VALUE *argv, VALUE self) { FXTabBar *arg1 = (FXTabBar *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTabBar, 1); FXTabBar_raise(arg1); return Qnil; }
static VALUE _wrap_FXTabBar_lower(int argc, VALUE *argv, VALUE self) { FXTabBar *arg1 = (FXTabBar *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTabBar, 1); FXTabBar_lower(arg1); return Qnil; }
static VALUE _wrap_FXTabBar_move(int argc, VALUE *argv, VALUE self) { FXTabBar *arg1 = (FXTabBar *) 0 ; FXint arg2 ;
    FXint arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTabBar, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    FXTabBar_move(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXTabBar_position(int argc, VALUE *argv, VALUE self) { FXTabBar *arg1 = (FXTabBar *) 0 ; FXint arg2 ;
    FXint arg3 ; FXint arg4 ; FXint arg5 ; if ((argc < 4) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTabBar, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    arg4 = NUM2INT(argv[2]); arg5 = NUM2INT(argv[3]); FXTabBar_position(arg1,arg2,arg3,arg4,arg5); return Qnil; }
static VALUE _wrap_FXTabBar_layout(int argc, VALUE *argv, VALUE self) { FXTabBar *arg1 = (FXTabBar *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTabBar, 1); FXTabBar_layout(arg1); return Qnil; }
static VALUE _wrap_FXTabBar_recalc(int argc, VALUE *argv, VALUE self) { FXTabBar *arg1 = (FXTabBar *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTabBar, 1); FXTabBar_recalc(arg1); return Qnil; }
static VALUE _wrap_FXTabBar_reparent(int argc, VALUE *argv, VALUE self) { FXTabBar *arg1 = (FXTabBar *) 0 ;
    FXComposite *arg2 = (FXComposite *) 0 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTabBar, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXComposite, 1); FXTabBar_reparent(arg1,arg2); return Qnil; }
static VALUE _wrap_FXTabBar_show(int argc, VALUE *argv, VALUE self) { FXTabBar *arg1 = (FXTabBar *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTabBar, 1); FXTabBar_show(arg1); return Qnil; }
static VALUE _wrap_FXTabBar_hide(int argc, VALUE *argv, VALUE self) { FXTabBar *arg1 = (FXTabBar *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTabBar, 1); FXTabBar_hide(arg1); return Qnil; }
static VALUE _wrap_FXTabBar_isComposite(int argc, VALUE *argv, VALUE self) { FXTabBar *arg1 = (FXTabBar *) 0 ; FXbool result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTabBar, 1);
    result = (FXbool)FXTabBar_isComposite((FXTabBar const *)arg1); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXTabBar_contains(int argc, VALUE *argv, VALUE self) { FXTabBar *arg1 = (FXTabBar *) 0 ; FXint arg2 ;
    FXint arg3 ; FXbool result; VALUE vresult = Qnil; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTabBar, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    result = (FXbool)FXTabBar_contains((FXTabBar const *)arg1,arg2,arg3); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXTabBar_doesSaveUnder(int argc, VALUE *argv, VALUE self) { FXTabBar *arg1 = (FXTabBar *) 0 ; FXbool result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTabBar, 1);
    result = (FXbool)FXTabBar_doesSaveUnder((FXTabBar const *)arg1); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXTabBar_setBackColor(int argc, VALUE *argv, VALUE self) { FXTabBar *arg1 = (FXTabBar *) 0 ; FXColor arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTabBar, 1); arg2 = to_FXColor(argv[0]);
    FXTabBar_setBackColor(arg1,arg2); return Qnil; }
static VALUE _wrap_FXTabBar_setCurrent(int argc, VALUE *argv, VALUE self) { FXTabBar *arg1 = (FXTabBar *) 0 ; FXint arg2 ;
    FXbool arg3 = (FXbool) 0 ; if ((argc < 1) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTabBar, 1); arg2 = NUM2INT(argv[0]); if (argc > 1) {
        arg3 = to_FXbool(argv[1]); }  FXTabBar_setCurrent(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXTabBook_onPaint(int argc, VALUE *argv, VALUE self) { FXTabBook *arg1 = (FXTabBook *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTabBook, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onPaint(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTabBook_onFocusNext(int argc, VALUE *argv, VALUE self) { FXTabBook *arg1 = (FXTabBook *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTabBook, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onFocusNext(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTabBook_onFocusPrev(int argc, VALUE *argv, VALUE self) { FXTabBook *arg1 = (FXTabBook *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTabBook, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onFocusPrev(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTabBook_onFocusUp(int argc, VALUE *argv, VALUE self) { FXTabBook *arg1 = (FXTabBook *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTabBook, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onFocusUp(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTabBook_onFocusDown(int argc, VALUE *argv, VALUE self) { FXTabBook *arg1 = (FXTabBook *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTabBook, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onFocusDown(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTabBook_onFocusLeft(int argc, VALUE *argv, VALUE self) { FXTabBook *arg1 = (FXTabBook *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTabBook, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onFocusLeft(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTabBook_onFocusRight(int argc, VALUE *argv, VALUE self) { FXTabBook *arg1 = (FXTabBook *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTabBook, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onFocusRight(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTabBook_onCmdOpenItem(int argc, VALUE *argv, VALUE self) { FXTabBook *arg1 = (FXTabBook *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTabBook, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdOpenItem(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE _wrap_FXTabBook_allocate(VALUE self) {
#else
     static VALUE _wrap_FXTabBook_allocate(int argc, VALUE *argv, VALUE self) {
#endif
         VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_FXTabBook);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
         return vresult; }
static VALUE _wrap_new_FXTabBook(int argc, VALUE *argv, VALUE self) { FXComposite *arg1 = (FXComposite *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 = (FXSelector) 0 ; FXuint arg4 = (FXuint) TABBOOK_NORMAL ;
    FXint arg5 = (FXint) 0 ; FXint arg6 = (FXint) 0 ; FXint arg7 = (FXint) 0 ; FXint arg8 = (FXint) 0 ;
    FXint arg9 = (FXint) DEFAULT_SPACING ; FXint arg10 = (FXint) DEFAULT_SPACING ; FXint arg11 = (FXint) DEFAULT_SPACING ;
    FXint arg12 = (FXint) DEFAULT_SPACING ; FXTabBook *result; if ((argc < 1) || (argc > 12))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXComposite, 1); if (argc > 1) {
        SWIG_ConvertPtr(argv[1], (void **) &arg2, SWIGTYPE_p_FXObject, 1); }  if (argc > 2) { arg3 = NUM2UINT(argv[2]); } 
    if (argc > 3) { arg4 = NUM2UINT(argv[3]); }  if (argc > 4) { arg5 = NUM2INT(argv[4]); }  if (argc > 5) {
        arg6 = NUM2INT(argv[5]); }  if (argc > 6) { arg7 = NUM2INT(argv[6]); }  if (argc > 7) { arg8 = NUM2INT(argv[7]); } 
    if (argc > 8) { arg9 = NUM2INT(argv[8]); }  if (argc > 9) { arg10 = NUM2INT(argv[9]); }  if (argc > 10) {
        arg11 = NUM2INT(argv[10]); }  if (argc > 11) { arg12 = NUM2INT(argv[11]); }  {
        result = (FXTabBook *)new_FXTabBook(arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8,arg9,arg10,arg11,arg12);
        DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result); if(rb_block_given_p()){ rb_yield(self); }  }  return self; }
static void
free_FXTabBook(FXTabBook *arg1) {
    delete arg1;
}
static VALUE _wrap_FXTabBook_save(int argc, VALUE *argv, VALUE self) { FXTabBook *arg1 = (FXTabBook *) 0 ; FXStream *arg2 = 0 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTabBook, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXTabBook_save((FXTabBook const *)arg1,*arg2); return Qnil; }
static VALUE _wrap_FXTabBook_load(int argc, VALUE *argv, VALUE self) { FXTabBook *arg1 = (FXTabBook *) 0 ; FXStream *arg2 = 0 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTabBook, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXTabBook_load(arg1,*arg2); return Qnil; }
static VALUE _wrap_FXTabBook_create(int argc, VALUE *argv, VALUE self) { FXTabBook *arg1 = (FXTabBook *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTabBook, 1); FXTabBook_create(arg1); return Qnil; }
static VALUE _wrap_FXTabBook_detach(int argc, VALUE *argv, VALUE self) { FXTabBook *arg1 = (FXTabBook *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTabBook, 1); FXTabBook_detach(arg1); return Qnil; }
static VALUE _wrap_FXTabBook_destroy(int argc, VALUE *argv, VALUE self) { FXTabBook *arg1 = (FXTabBook *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTabBook, 1); FXTabBook_destroy(arg1); return Qnil; }
static VALUE _wrap_FXTabBook_resize(int argc, VALUE *argv, VALUE self) { FXTabBook *arg1 = (FXTabBook *) 0 ; FXint arg2 ;
    FXint arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTabBook, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    FXTabBook_resize(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXTabBook_getDefaultWidth(int argc, VALUE *argv, VALUE self) { FXTabBook *arg1 = (FXTabBook *) 0 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTabBook, 1); result = (FXint)FXTabBook_getDefaultWidth(arg1);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTabBook_getDefaultHeight(int argc, VALUE *argv, VALUE self) { FXTabBook *arg1 = (FXTabBook *) 0 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTabBook, 1); result = (FXint)FXTabBook_getDefaultHeight(arg1);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTabBook_getWidthForHeight(int argc, VALUE *argv, VALUE self) { FXTabBook *arg1 = (FXTabBook *) 0 ;
    FXint arg2 ; FXint result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTabBook, 1); arg2 = NUM2INT(argv[0]);
    result = (FXint)FXTabBook_getWidthForHeight(arg1,arg2); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTabBook_getHeightForWidth(int argc, VALUE *argv, VALUE self) { FXTabBook *arg1 = (FXTabBook *) 0 ;
    FXint arg2 ; FXint result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTabBook, 1); arg2 = NUM2INT(argv[0]);
    result = (FXint)FXTabBook_getHeightForWidth(arg1,arg2); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTabBook_canFocus(int argc, VALUE *argv, VALUE self) { FXTabBook *arg1 = (FXTabBook *) 0 ; FXbool result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTabBook, 1);
    result = (FXbool)FXTabBook_canFocus((FXTabBook const *)arg1); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXTabBook_setFocus(int argc, VALUE *argv, VALUE self) { FXTabBook *arg1 = (FXTabBook *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTabBook, 1); FXTabBook_setFocus(arg1); return Qnil; }
static VALUE _wrap_FXTabBook_killFocus(int argc, VALUE *argv, VALUE self) { FXTabBook *arg1 = (FXTabBook *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTabBook, 1); FXTabBook_killFocus(arg1); return Qnil; }
static VALUE _wrap_FXTabBook_setDefault(int argc, VALUE *argv, VALUE self) { FXTabBook *arg1 = (FXTabBook *) 0 ;
    FXbool arg2 = (FXbool) 1 ; if ((argc < 0) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTabBook, 1); if (argc > 0) { arg2 = to_FXbool(argv[0]); } 
    FXTabBook_setDefault(arg1,arg2); return Qnil; }
static VALUE _wrap_FXTabBook_enable(int argc, VALUE *argv, VALUE self) { FXTabBook *arg1 = (FXTabBook *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTabBook, 1); FXTabBook_enable(arg1); return Qnil; }
static VALUE _wrap_FXTabBook_disable(int argc, VALUE *argv, VALUE self) { FXTabBook *arg1 = (FXTabBook *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTabBook, 1); FXTabBook_disable(arg1); return Qnil; }
static VALUE _wrap_FXTabBook_raiseWindow(int argc, VALUE *argv, VALUE self) { FXTabBook *arg1 = (FXTabBook *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTabBook, 1); FXTabBook_raise(arg1); return Qnil; }
static VALUE _wrap_FXTabBook_lower(int argc, VALUE *argv, VALUE self) { FXTabBook *arg1 = (FXTabBook *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTabBook, 1); FXTabBook_lower(arg1); return Qnil; }
static VALUE _wrap_FXTabBook_move(int argc, VALUE *argv, VALUE self) { FXTabBook *arg1 = (FXTabBook *) 0 ; FXint arg2 ;
    FXint arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTabBook, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    FXTabBook_move(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXTabBook_position(int argc, VALUE *argv, VALUE self) { FXTabBook *arg1 = (FXTabBook *) 0 ; FXint arg2 ;
    FXint arg3 ; FXint arg4 ; FXint arg5 ; if ((argc < 4) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTabBook, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    arg4 = NUM2INT(argv[2]); arg5 = NUM2INT(argv[3]); FXTabBook_position(arg1,arg2,arg3,arg4,arg5); return Qnil; }
static VALUE _wrap_FXTabBook_layout(int argc, VALUE *argv, VALUE self) { FXTabBook *arg1 = (FXTabBook *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTabBook, 1); FXTabBook_layout(arg1); return Qnil; }
static VALUE _wrap_FXTabBook_recalc(int argc, VALUE *argv, VALUE self) { FXTabBook *arg1 = (FXTabBook *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTabBook, 1); FXTabBook_recalc(arg1); return Qnil; }
static VALUE _wrap_FXTabBook_reparent(int argc, VALUE *argv, VALUE self) { FXTabBook *arg1 = (FXTabBook *) 0 ;
    FXComposite *arg2 = (FXComposite *) 0 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTabBook, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXComposite, 1); FXTabBook_reparent(arg1,arg2); return Qnil; }
static VALUE _wrap_FXTabBook_show(int argc, VALUE *argv, VALUE self) { FXTabBook *arg1 = (FXTabBook *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTabBook, 1); FXTabBook_show(arg1); return Qnil; }
static VALUE _wrap_FXTabBook_hide(int argc, VALUE *argv, VALUE self) { FXTabBook *arg1 = (FXTabBook *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTabBook, 1); FXTabBook_hide(arg1); return Qnil; }
static VALUE _wrap_FXTabBook_isComposite(int argc, VALUE *argv, VALUE self) { FXTabBook *arg1 = (FXTabBook *) 0 ; FXbool result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTabBook, 1);
    result = (FXbool)FXTabBook_isComposite((FXTabBook const *)arg1); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXTabBook_contains(int argc, VALUE *argv, VALUE self) { FXTabBook *arg1 = (FXTabBook *) 0 ; FXint arg2 ;
    FXint arg3 ; FXbool result; VALUE vresult = Qnil; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTabBook, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    result = (FXbool)FXTabBook_contains((FXTabBook const *)arg1,arg2,arg3); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXTabBook_doesSaveUnder(int argc, VALUE *argv, VALUE self) { FXTabBook *arg1 = (FXTabBook *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTabBook, 1);
    result = (FXbool)FXTabBook_doesSaveUnder((FXTabBook const *)arg1); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXTabBook_setBackColor(int argc, VALUE *argv, VALUE self) { FXTabBook *arg1 = (FXTabBook *) 0 ;
    FXColor arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTabBook, 1); arg2 = to_FXColor(argv[0]);
    FXTabBook_setBackColor(arg1,arg2); return Qnil; }
static VALUE _wrap_FXTabBook_setCurrent(int argc, VALUE *argv, VALUE self) { FXTabBook *arg1 = (FXTabBook *) 0 ; FXint arg2 ;
    FXbool arg3 = (FXbool) 0 ; if ((argc < 1) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTabBook, 1); arg2 = NUM2INT(argv[0]); if (argc > 1) {
        arg3 = to_FXbool(argv[1]); }  FXTabBook_setCurrent(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXScrollBar_onPaint(int argc, VALUE *argv, VALUE self) { FXScrollBar *arg1 = (FXScrollBar *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScrollBar, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onPaint(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXScrollBar_onMotion(int argc, VALUE *argv, VALUE self) { FXScrollBar *arg1 = (FXScrollBar *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScrollBar, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onMotion(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXScrollBar_onMouseWheel(int argc, VALUE *argv, VALUE self) { FXScrollBar *arg1 = (FXScrollBar *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScrollBar, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onMouseWheel(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXScrollBar_onLeftBtnPress(int argc, VALUE *argv, VALUE self) { FXScrollBar *arg1 = (FXScrollBar *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScrollBar, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onLeftBtnPress(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXScrollBar_onLeftBtnRelease(int argc, VALUE *argv, VALUE self) { FXScrollBar *arg1 = (FXScrollBar *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScrollBar, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onLeftBtnRelease(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXScrollBar_onMiddleBtnPress(int argc, VALUE *argv, VALUE self) { FXScrollBar *arg1 = (FXScrollBar *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScrollBar, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onMiddleBtnPress(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXScrollBar_onMiddleBtnRelease(int argc, VALUE *argv, VALUE self) { FXScrollBar *arg1 = (FXScrollBar *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScrollBar, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onMiddleBtnRelease(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXScrollBar_onRightBtnPress(int argc, VALUE *argv, VALUE self) { FXScrollBar *arg1 = (FXScrollBar *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScrollBar, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onRightBtnPress(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXScrollBar_onRightBtnRelease(int argc, VALUE *argv, VALUE self) { FXScrollBar *arg1 = (FXScrollBar *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScrollBar, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onRightBtnRelease(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXScrollBar_onUngrabbed(int argc, VALUE *argv, VALUE self) { FXScrollBar *arg1 = (FXScrollBar *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScrollBar, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onUngrabbed(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXScrollBar_onTimeWheel(int argc, VALUE *argv, VALUE self) { FXScrollBar *arg1 = (FXScrollBar *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScrollBar, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onTimeWheel(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXScrollBar_onAutoScroll(int argc, VALUE *argv, VALUE self) { FXScrollBar *arg1 = (FXScrollBar *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScrollBar, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]);
    arg4 = reinterpret_cast<void*>(NUM2INT(argv[2])); result = (long)(arg1)->onAutoScroll(arg2,arg3,arg4);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXScrollBar_onCmdSetValue(int argc, VALUE *argv, VALUE self) { FXScrollBar *arg1 = (FXScrollBar *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScrollBar, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]);
    arg4 = reinterpret_cast<void*>(NUM2INT(argv[2])); result = (long)(arg1)->onCmdSetValue(arg2,arg3,arg4);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXScrollBar_onCmdSetIntValue(int argc, VALUE *argv, VALUE self) { FXScrollBar *arg1 = (FXScrollBar *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; FXint value4 ;
    VALUE vresult = Qnil; if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScrollBar, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); {
        value4 = (FXint) NUM2INT(argv[2]); arg4 = static_cast<void*>(&value4); } 
    result = (long)(arg1)->onCmdSetIntValue(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXScrollBar_onCmdGetIntValue(int argc, VALUE *argv, VALUE self) { FXScrollBar *arg1 = (FXScrollBar *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScrollBar, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdGetIntValue(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXScrollBar_onCmdSetIntRange(int argc, VALUE *argv, VALUE self) { FXScrollBar *arg1 = (FXScrollBar *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; FXint values4[2] ;
    VALUE vresult = Qnil; if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScrollBar, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); { Check_Type(argv[2], T_ARRAY);
        values4[0] = (FXint) NUM2INT(rb_ary_entry(argv[2], 0)); values4[1] = (FXint) NUM2INT(rb_ary_entry(argv[2], 1));
        arg4 = static_cast<void*>(values4); }  result = (long)(arg1)->onCmdSetIntRange(arg2,arg3,arg4);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXScrollBar_onCmdGetIntRange(int argc, VALUE *argv, VALUE self) { FXScrollBar *arg1 = (FXScrollBar *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScrollBar, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]);
    SWIG_ConvertPtr(argv[2], (void **) &arg4, 0, 1); result = (long)(arg1)->onCmdGetIntRange(arg2,arg3,arg4);
    vresult = INT2NUM(result); return vresult; }
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE _wrap_FXScrollBar_allocate(VALUE self) {
#else
     static VALUE _wrap_FXScrollBar_allocate(int argc, VALUE *argv, VALUE self) {
#endif
         VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_FXScrollBar);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
         return vresult; }
static VALUE _wrap_new_FXScrollBar(int argc, VALUE *argv, VALUE self) { FXComposite *arg1 = (FXComposite *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 = (FXSelector) 0 ; FXuint arg4 = (FXuint) SCROLLBAR_VERTICAL ;
    FXint arg5 = (FXint) 0 ; FXint arg6 = (FXint) 0 ; FXint arg7 = (FXint) 0 ; FXint arg8 = (FXint) 0 ; FXScrollBar *result;
    if ((argc < 1) || (argc > 8)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXComposite, 1); if (argc > 1) {
        SWIG_ConvertPtr(argv[1], (void **) &arg2, SWIGTYPE_p_FXObject, 1); }  if (argc > 2) { arg3 = NUM2UINT(argv[2]); } 
    if (argc > 3) { arg4 = NUM2UINT(argv[3]); }  if (argc > 4) { arg5 = NUM2INT(argv[4]); }  if (argc > 5) {
        arg6 = NUM2INT(argv[5]); }  if (argc > 6) { arg7 = NUM2INT(argv[6]); }  if (argc > 7) { arg8 = NUM2INT(argv[7]); }  {
        result = (FXScrollBar *)new_FXScrollBar(arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8);
        DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result); if(rb_block_given_p()){ rb_yield(self); }  }  return self; }
static VALUE _wrap_FXScrollBar_setRange(int argc, VALUE *argv, VALUE self) { FXScrollBar *arg1 = (FXScrollBar *) 0 ;
    FXint arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScrollBar, 1); arg2 = NUM2INT(argv[0]); (arg1)->setRange(arg2);
    return Qnil; }
static VALUE _wrap_FXScrollBar_getRange(int argc, VALUE *argv, VALUE self) { FXScrollBar *arg1 = (FXScrollBar *) 0 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScrollBar, 1); result = (FXint)((FXScrollBar const *)arg1)->getRange();
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXScrollBar_setPage(int argc, VALUE *argv, VALUE self) { FXScrollBar *arg1 = (FXScrollBar *) 0 ; FXint arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScrollBar, 1); arg2 = NUM2INT(argv[0]); (arg1)->setPage(arg2);
    return Qnil; }
static VALUE _wrap_FXScrollBar_getPage(int argc, VALUE *argv, VALUE self) { FXScrollBar *arg1 = (FXScrollBar *) 0 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScrollBar, 1); result = (FXint)((FXScrollBar const *)arg1)->getPage();
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXScrollBar_setLine(int argc, VALUE *argv, VALUE self) { FXScrollBar *arg1 = (FXScrollBar *) 0 ; FXint arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScrollBar, 1); arg2 = NUM2INT(argv[0]); (arg1)->setLine(arg2);
    return Qnil; }
static VALUE _wrap_FXScrollBar_getLine(int argc, VALUE *argv, VALUE self) { FXScrollBar *arg1 = (FXScrollBar *) 0 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScrollBar, 1); result = (FXint)((FXScrollBar const *)arg1)->getLine();
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXScrollBar_setPosition(int argc, VALUE *argv, VALUE self) { FXScrollBar *arg1 = (FXScrollBar *) 0 ;
    FXint arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScrollBar, 1); arg2 = NUM2INT(argv[0]); (arg1)->setPosition(arg2);
    return Qnil; }
static VALUE _wrap_FXScrollBar_position__SWIG_0(int argc, VALUE *argv, VALUE self) { FXScrollBar *arg1 = (FXScrollBar *) 0 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScrollBar, 1);
    result = (FXint)FXScrollBar_position__SWIG_0((FXScrollBar const *)arg1); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXScrollBar_setHiliteColor(int argc, VALUE *argv, VALUE self) { FXScrollBar *arg1 = (FXScrollBar *) 0 ;
    FXColor arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScrollBar, 1); arg2 = to_FXColor(argv[0]); (arg1)->setHiliteColor(arg2);
    return Qnil; }
static VALUE _wrap_FXScrollBar_getHiliteColor(int argc, VALUE *argv, VALUE self) { FXScrollBar *arg1 = (FXScrollBar *) 0 ;
    FXColor result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScrollBar, 1);
    result = (FXColor)((FXScrollBar const *)arg1)->getHiliteColor(); vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXScrollBar_setShadowColor(int argc, VALUE *argv, VALUE self) { FXScrollBar *arg1 = (FXScrollBar *) 0 ;
    FXColor arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScrollBar, 1); arg2 = to_FXColor(argv[0]); (arg1)->setShadowColor(arg2);
    return Qnil; }
static VALUE _wrap_FXScrollBar_getShadowColor(int argc, VALUE *argv, VALUE self) { FXScrollBar *arg1 = (FXScrollBar *) 0 ;
    FXColor result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScrollBar, 1);
    result = (FXColor)((FXScrollBar const *)arg1)->getShadowColor(); vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXScrollBar_getBorderColor(int argc, VALUE *argv, VALUE self) { FXScrollBar *arg1 = (FXScrollBar *) 0 ;
    FXColor result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScrollBar, 1);
    result = (FXColor)((FXScrollBar const *)arg1)->getBorderColor(); vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXScrollBar_setBorderColor(int argc, VALUE *argv, VALUE self) { FXScrollBar *arg1 = (FXScrollBar *) 0 ;
    FXColor arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScrollBar, 1); arg2 = to_FXColor(argv[0]); (arg1)->setBorderColor(arg2);
    return Qnil; }
static VALUE _wrap_FXScrollBar_getScrollbarStyle(int argc, VALUE *argv, VALUE self) { FXScrollBar *arg1 = (FXScrollBar *) 0 ;
    FXuint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScrollBar, 1);
    result = (FXuint)((FXScrollBar const *)arg1)->getScrollbarStyle(); vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXScrollBar_setScrollbarStyle(int argc, VALUE *argv, VALUE self) { FXScrollBar *arg1 = (FXScrollBar *) 0 ;
    FXuint arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScrollBar, 1); arg2 = NUM2UINT(argv[0]);
    (arg1)->setScrollbarStyle(arg2); return Qnil; }
static void
free_FXScrollBar(FXScrollBar *arg1) {
    delete arg1;
}
static VALUE _wrap_FXScrollBar_save(int argc, VALUE *argv, VALUE self) { FXScrollBar *arg1 = (FXScrollBar *) 0 ;
    FXStream *arg2 = 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScrollBar, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXScrollBar_save((FXScrollBar const *)arg1,*arg2); return Qnil; }
static VALUE _wrap_FXScrollBar_load(int argc, VALUE *argv, VALUE self) { FXScrollBar *arg1 = (FXScrollBar *) 0 ;
    FXStream *arg2 = 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScrollBar, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXScrollBar_load(arg1,*arg2); return Qnil; }
static VALUE _wrap_FXScrollBar_create(int argc, VALUE *argv, VALUE self) { FXScrollBar *arg1 = (FXScrollBar *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScrollBar, 1); FXScrollBar_create(arg1); return Qnil; }
static VALUE _wrap_FXScrollBar_detach(int argc, VALUE *argv, VALUE self) { FXScrollBar *arg1 = (FXScrollBar *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScrollBar, 1); FXScrollBar_detach(arg1); return Qnil; }
static VALUE _wrap_FXScrollBar_destroy(int argc, VALUE *argv, VALUE self) { FXScrollBar *arg1 = (FXScrollBar *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScrollBar, 1); FXScrollBar_destroy(arg1); return Qnil; }
static VALUE _wrap_FXScrollBar_resize(int argc, VALUE *argv, VALUE self) { FXScrollBar *arg1 = (FXScrollBar *) 0 ; FXint arg2 ;
    FXint arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScrollBar, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    FXScrollBar_resize(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXScrollBar_getDefaultWidth(int argc, VALUE *argv, VALUE self) { FXScrollBar *arg1 = (FXScrollBar *) 0 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScrollBar, 1); result = (FXint)FXScrollBar_getDefaultWidth(arg1);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXScrollBar_getDefaultHeight(int argc, VALUE *argv, VALUE self) { FXScrollBar *arg1 = (FXScrollBar *) 0 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScrollBar, 1); result = (FXint)FXScrollBar_getDefaultHeight(arg1);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXScrollBar_getWidthForHeight(int argc, VALUE *argv, VALUE self) { FXScrollBar *arg1 = (FXScrollBar *) 0 ;
    FXint arg2 ; FXint result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScrollBar, 1); arg2 = NUM2INT(argv[0]);
    result = (FXint)FXScrollBar_getWidthForHeight(arg1,arg2); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXScrollBar_getHeightForWidth(int argc, VALUE *argv, VALUE self) { FXScrollBar *arg1 = (FXScrollBar *) 0 ;
    FXint arg2 ; FXint result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScrollBar, 1); arg2 = NUM2INT(argv[0]);
    result = (FXint)FXScrollBar_getHeightForWidth(arg1,arg2); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXScrollBar_canFocus(int argc, VALUE *argv, VALUE self) { FXScrollBar *arg1 = (FXScrollBar *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScrollBar, 1);
    result = (FXbool)FXScrollBar_canFocus((FXScrollBar const *)arg1); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXScrollBar_setFocus(int argc, VALUE *argv, VALUE self) { FXScrollBar *arg1 = (FXScrollBar *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScrollBar, 1); FXScrollBar_setFocus(arg1); return Qnil; }
static VALUE _wrap_FXScrollBar_killFocus(int argc, VALUE *argv, VALUE self) { FXScrollBar *arg1 = (FXScrollBar *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScrollBar, 1); FXScrollBar_killFocus(arg1); return Qnil; }
static VALUE _wrap_FXScrollBar_setDefault(int argc, VALUE *argv, VALUE self) { FXScrollBar *arg1 = (FXScrollBar *) 0 ;
    FXbool arg2 = (FXbool) 1 ; if ((argc < 0) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScrollBar, 1); if (argc > 0) { arg2 = to_FXbool(argv[0]); } 
    FXScrollBar_setDefault(arg1,arg2); return Qnil; }
static VALUE _wrap_FXScrollBar_enable(int argc, VALUE *argv, VALUE self) { FXScrollBar *arg1 = (FXScrollBar *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScrollBar, 1); FXScrollBar_enable(arg1); return Qnil; }
static VALUE _wrap_FXScrollBar_disable(int argc, VALUE *argv, VALUE self) { FXScrollBar *arg1 = (FXScrollBar *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScrollBar, 1); FXScrollBar_disable(arg1); return Qnil; }
static VALUE _wrap_FXScrollBar_raiseWindow(int argc, VALUE *argv, VALUE self) { FXScrollBar *arg1 = (FXScrollBar *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScrollBar, 1); FXScrollBar_raise(arg1); return Qnil; }
static VALUE _wrap_FXScrollBar_lower(int argc, VALUE *argv, VALUE self) { FXScrollBar *arg1 = (FXScrollBar *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScrollBar, 1); FXScrollBar_lower(arg1); return Qnil; }
static VALUE _wrap_FXScrollBar_move(int argc, VALUE *argv, VALUE self) { FXScrollBar *arg1 = (FXScrollBar *) 0 ; FXint arg2 ;
    FXint arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScrollBar, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    FXScrollBar_move(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXScrollBar_position__SWIG_1(int argc, VALUE *argv, VALUE self) { FXScrollBar *arg1 = (FXScrollBar *) 0 ;
    FXint arg2 ; FXint arg3 ; FXint arg4 ; FXint arg5 ; if ((argc < 4) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScrollBar, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    arg4 = NUM2INT(argv[2]); arg5 = NUM2INT(argv[3]); FXScrollBar_position(arg1,arg2,arg3,arg4,arg5); return Qnil; }
static VALUE _wrap_FXScrollBar_position(int nargs, VALUE *args, VALUE self) { int argc; VALUE argv[6]; int ii; argc = nargs + 1;
    argv[0] = self; for (ii = 1; (ii < argc) && (ii < 5); ii++) { argv[ii] = args[ii-1]; }  if (argc == 1) { int _v; {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXScrollBar, 0) != -1)) ? 1 : 0; }
         if (_v) { return _wrap_FXScrollBar_position__SWIG_0(nargs, args, self);}  }  if (argc == 5) { int _v; { void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXScrollBar, 0) != -1)) ? 1 : 0; }
         if (_v) { { _v = ((TYPE(argv[1]) == T_FIXNUM) || (TYPE(argv[1]) == T_BIGNUM)) ? 1 : 0; }  if (_v) { {
                    _v = ((TYPE(argv[2]) == T_FIXNUM) || (TYPE(argv[2]) == T_BIGNUM)) ? 1 : 0; }  if (_v) { {
                        _v = ((TYPE(argv[3]) == T_FIXNUM) || (TYPE(argv[3]) == T_BIGNUM)) ? 1 : 0; }  if (_v) { {
                            _v = ((TYPE(argv[4]) == T_FIXNUM) || (TYPE(argv[4]) == T_BIGNUM)) ? 1 : 0; }  if (_v) {
                            return _wrap_FXScrollBar_position__SWIG_1(nargs, args, self);}  }  }  }  }  } 
    rb_raise(rb_eArgError, "No matching function for overloaded 'FXScrollBar_position'"); return Qnil; }
static VALUE _wrap_FXScrollBar_layout(int argc, VALUE *argv, VALUE self) { FXScrollBar *arg1 = (FXScrollBar *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScrollBar, 1); FXScrollBar_layout(arg1); return Qnil; }
static VALUE _wrap_FXScrollBar_recalc(int argc, VALUE *argv, VALUE self) { FXScrollBar *arg1 = (FXScrollBar *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScrollBar, 1); FXScrollBar_recalc(arg1); return Qnil; }
static VALUE _wrap_FXScrollBar_reparent(int argc, VALUE *argv, VALUE self) { FXScrollBar *arg1 = (FXScrollBar *) 0 ;
    FXComposite *arg2 = (FXComposite *) 0 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScrollBar, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXComposite, 1); FXScrollBar_reparent(arg1,arg2); return Qnil; }
static VALUE _wrap_FXScrollBar_show(int argc, VALUE *argv, VALUE self) { FXScrollBar *arg1 = (FXScrollBar *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScrollBar, 1); FXScrollBar_show(arg1); return Qnil; }
static VALUE _wrap_FXScrollBar_hide(int argc, VALUE *argv, VALUE self) { FXScrollBar *arg1 = (FXScrollBar *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScrollBar, 1); FXScrollBar_hide(arg1); return Qnil; }
static VALUE _wrap_FXScrollBar_isComposite(int argc, VALUE *argv, VALUE self) { FXScrollBar *arg1 = (FXScrollBar *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScrollBar, 1);
    result = (FXbool)FXScrollBar_isComposite((FXScrollBar const *)arg1); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXScrollBar_contains(int argc, VALUE *argv, VALUE self) { FXScrollBar *arg1 = (FXScrollBar *) 0 ;
    FXint arg2 ; FXint arg3 ; FXbool result; VALUE vresult = Qnil; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScrollBar, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    result = (FXbool)FXScrollBar_contains((FXScrollBar const *)arg1,arg2,arg3); vresult = result ? Qtrue : Qfalse;
    return vresult; }
static VALUE _wrap_FXScrollBar_doesSaveUnder(int argc, VALUE *argv, VALUE self) { FXScrollBar *arg1 = (FXScrollBar *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScrollBar, 1);
    result = (FXbool)FXScrollBar_doesSaveUnder((FXScrollBar const *)arg1); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXScrollBar_setBackColor(int argc, VALUE *argv, VALUE self) { FXScrollBar *arg1 = (FXScrollBar *) 0 ;
    FXColor arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScrollBar, 1); arg2 = to_FXColor(argv[0]);
    FXScrollBar_setBackColor(arg1,arg2); return Qnil; }
static VALUE _wrap_FXScrollCorner_onPaint(int argc, VALUE *argv, VALUE self) { FXScrollCorner *arg1 = (FXScrollCorner *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScrollCorner, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onPaint(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE _wrap_FXScrollCorner_allocate(VALUE self) {
#else
     static VALUE _wrap_FXScrollCorner_allocate(int argc, VALUE *argv, VALUE self) {
#endif
         VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_FXScrollCorner);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
         return vresult; }
static VALUE _wrap_new_FXScrollCorner(int argc, VALUE *argv, VALUE self) { FXComposite *arg1 = (FXComposite *) 0 ;
    FXScrollCorner *result; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXComposite, 1); { result = (FXScrollCorner *)new_FXScrollCorner(arg1);
        DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result); if(rb_block_given_p()){ rb_yield(self); }  }  return self; }
static void
free_FXScrollCorner(FXScrollCorner *arg1) {
    delete arg1;
}
static VALUE _wrap_FXScrollCorner_save(int argc, VALUE *argv, VALUE self) { FXScrollCorner *arg1 = (FXScrollCorner *) 0 ;
    FXStream *arg2 = 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScrollCorner, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXScrollCorner_save((FXScrollCorner const *)arg1,*arg2); return Qnil; }
static VALUE _wrap_FXScrollCorner_load(int argc, VALUE *argv, VALUE self) { FXScrollCorner *arg1 = (FXScrollCorner *) 0 ;
    FXStream *arg2 = 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScrollCorner, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXScrollCorner_load(arg1,*arg2); return Qnil; }
static VALUE _wrap_FXScrollCorner_create(int argc, VALUE *argv, VALUE self) { FXScrollCorner *arg1 = (FXScrollCorner *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScrollCorner, 1); FXScrollCorner_create(arg1); return Qnil; }
static VALUE _wrap_FXScrollCorner_detach(int argc, VALUE *argv, VALUE self) { FXScrollCorner *arg1 = (FXScrollCorner *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScrollCorner, 1); FXScrollCorner_detach(arg1); return Qnil; }
static VALUE _wrap_FXScrollCorner_destroy(int argc, VALUE *argv, VALUE self) { FXScrollCorner *arg1 = (FXScrollCorner *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScrollCorner, 1); FXScrollCorner_destroy(arg1); return Qnil; }
static VALUE _wrap_FXScrollCorner_resize(int argc, VALUE *argv, VALUE self) { FXScrollCorner *arg1 = (FXScrollCorner *) 0 ;
    FXint arg2 ; FXint arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScrollCorner, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    FXScrollCorner_resize(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXScrollCorner_getDefaultWidth(int argc, VALUE *argv, VALUE self) {
    FXScrollCorner *arg1 = (FXScrollCorner *) 0 ; FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScrollCorner, 1); result = (FXint)FXScrollCorner_getDefaultWidth(arg1);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXScrollCorner_getDefaultHeight(int argc, VALUE *argv, VALUE self) {
    FXScrollCorner *arg1 = (FXScrollCorner *) 0 ; FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScrollCorner, 1); result = (FXint)FXScrollCorner_getDefaultHeight(arg1);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXScrollCorner_getWidthForHeight(int argc, VALUE *argv, VALUE self) {
    FXScrollCorner *arg1 = (FXScrollCorner *) 0 ; FXint arg2 ; FXint result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScrollCorner, 1); arg2 = NUM2INT(argv[0]);
    result = (FXint)FXScrollCorner_getWidthForHeight(arg1,arg2); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXScrollCorner_getHeightForWidth(int argc, VALUE *argv, VALUE self) {
    FXScrollCorner *arg1 = (FXScrollCorner *) 0 ; FXint arg2 ; FXint result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScrollCorner, 1); arg2 = NUM2INT(argv[0]);
    result = (FXint)FXScrollCorner_getHeightForWidth(arg1,arg2); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXScrollCorner_canFocus(int argc, VALUE *argv, VALUE self) { FXScrollCorner *arg1 = (FXScrollCorner *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScrollCorner, 1);
    result = (FXbool)FXScrollCorner_canFocus((FXScrollCorner const *)arg1); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXScrollCorner_setFocus(int argc, VALUE *argv, VALUE self) { FXScrollCorner *arg1 = (FXScrollCorner *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScrollCorner, 1); FXScrollCorner_setFocus(arg1); return Qnil; }
static VALUE _wrap_FXScrollCorner_killFocus(int argc, VALUE *argv, VALUE self) { FXScrollCorner *arg1 = (FXScrollCorner *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScrollCorner, 1); FXScrollCorner_killFocus(arg1); return Qnil; }
static VALUE _wrap_FXScrollCorner_setDefault(int argc, VALUE *argv, VALUE self) { FXScrollCorner *arg1 = (FXScrollCorner *) 0 ;
    FXbool arg2 = (FXbool) 1 ; if ((argc < 0) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScrollCorner, 1); if (argc > 0) { arg2 = to_FXbool(argv[0]); } 
    FXScrollCorner_setDefault(arg1,arg2); return Qnil; }
static VALUE _wrap_FXScrollCorner_enable(int argc, VALUE *argv, VALUE self) { FXScrollCorner *arg1 = (FXScrollCorner *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScrollCorner, 1); FXScrollCorner_enable(arg1); return Qnil; }
static VALUE _wrap_FXScrollCorner_disable(int argc, VALUE *argv, VALUE self) { FXScrollCorner *arg1 = (FXScrollCorner *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScrollCorner, 1); FXScrollCorner_disable(arg1); return Qnil; }
static VALUE _wrap_FXScrollCorner_raiseWindow(int argc, VALUE *argv, VALUE self) { FXScrollCorner *arg1 = (FXScrollCorner *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScrollCorner, 1); FXScrollCorner_raise(arg1); return Qnil; }
static VALUE _wrap_FXScrollCorner_lower(int argc, VALUE *argv, VALUE self) { FXScrollCorner *arg1 = (FXScrollCorner *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScrollCorner, 1); FXScrollCorner_lower(arg1); return Qnil; }
static VALUE _wrap_FXScrollCorner_move(int argc, VALUE *argv, VALUE self) { FXScrollCorner *arg1 = (FXScrollCorner *) 0 ;
    FXint arg2 ; FXint arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScrollCorner, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    FXScrollCorner_move(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXScrollCorner_position(int argc, VALUE *argv, VALUE self) { FXScrollCorner *arg1 = (FXScrollCorner *) 0 ;
    FXint arg2 ; FXint arg3 ; FXint arg4 ; FXint arg5 ; if ((argc < 4) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScrollCorner, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    arg4 = NUM2INT(argv[2]); arg5 = NUM2INT(argv[3]); FXScrollCorner_position(arg1,arg2,arg3,arg4,arg5); return Qnil; }
static VALUE _wrap_FXScrollCorner_layout(int argc, VALUE *argv, VALUE self) { FXScrollCorner *arg1 = (FXScrollCorner *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScrollCorner, 1); FXScrollCorner_layout(arg1); return Qnil; }
static VALUE _wrap_FXScrollCorner_recalc(int argc, VALUE *argv, VALUE self) { FXScrollCorner *arg1 = (FXScrollCorner *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScrollCorner, 1); FXScrollCorner_recalc(arg1); return Qnil; }
static VALUE _wrap_FXScrollCorner_reparent(int argc, VALUE *argv, VALUE self) { FXScrollCorner *arg1 = (FXScrollCorner *) 0 ;
    FXComposite *arg2 = (FXComposite *) 0 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScrollCorner, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXComposite, 1); FXScrollCorner_reparent(arg1,arg2); return Qnil; }
static VALUE _wrap_FXScrollCorner_show(int argc, VALUE *argv, VALUE self) { FXScrollCorner *arg1 = (FXScrollCorner *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScrollCorner, 1); FXScrollCorner_show(arg1); return Qnil; }
static VALUE _wrap_FXScrollCorner_hide(int argc, VALUE *argv, VALUE self) { FXScrollCorner *arg1 = (FXScrollCorner *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScrollCorner, 1); FXScrollCorner_hide(arg1); return Qnil; }
static VALUE _wrap_FXScrollCorner_isComposite(int argc, VALUE *argv, VALUE self) { FXScrollCorner *arg1 = (FXScrollCorner *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScrollCorner, 1);
    result = (FXbool)FXScrollCorner_isComposite((FXScrollCorner const *)arg1); vresult = result ? Qtrue : Qfalse;
    return vresult; }
static VALUE _wrap_FXScrollCorner_contains(int argc, VALUE *argv, VALUE self) { FXScrollCorner *arg1 = (FXScrollCorner *) 0 ;
    FXint arg2 ; FXint arg3 ; FXbool result; VALUE vresult = Qnil; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScrollCorner, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    result = (FXbool)FXScrollCorner_contains((FXScrollCorner const *)arg1,arg2,arg3); vresult = result ? Qtrue : Qfalse;
    return vresult; }
static VALUE _wrap_FXScrollCorner_doesSaveUnder(int argc, VALUE *argv, VALUE self) {
    FXScrollCorner *arg1 = (FXScrollCorner *) 0 ; FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScrollCorner, 1);
    result = (FXbool)FXScrollCorner_doesSaveUnder((FXScrollCorner const *)arg1); vresult = result ? Qtrue : Qfalse;
    return vresult; }
static VALUE _wrap_FXScrollCorner_setBackColor(int argc, VALUE *argv, VALUE self) {
    FXScrollCorner *arg1 = (FXScrollCorner *) 0 ; FXColor arg2 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScrollCorner, 1); arg2 = to_FXColor(argv[0]);
    FXScrollCorner_setBackColor(arg1,arg2); return Qnil; }
static VALUE _wrap_FXComboBox_onFocusUp(int argc, VALUE *argv, VALUE self) { FXComboBox *arg1 = (FXComboBox *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXComboBox, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onFocusUp(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXComboBox_onFocusDown(int argc, VALUE *argv, VALUE self) { FXComboBox *arg1 = (FXComboBox *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXComboBox, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onFocusDown(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXComboBox_onFocusSelf(int argc, VALUE *argv, VALUE self) { FXComboBox *arg1 = (FXComboBox *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXComboBox, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onFocusSelf(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXComboBox_onTextButton(int argc, VALUE *argv, VALUE self) { FXComboBox *arg1 = (FXComboBox *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXComboBox, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onTextButton(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXComboBox_onTextChanged(int argc, VALUE *argv, VALUE self) { FXComboBox *arg1 = (FXComboBox *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXComboBox, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]);
    arg4 = static_cast<void*>(STR2CSTR(argv[2])); result = (long)(arg1)->onTextChanged(arg2,arg3,arg4);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXComboBox_onTextCommand(int argc, VALUE *argv, VALUE self) { FXComboBox *arg1 = (FXComboBox *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXComboBox, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]);
    arg4 = static_cast<void*>(STR2CSTR(argv[2])); result = (long)(arg1)->onTextCommand(arg2,arg3,arg4);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXComboBox_onListClicked(int argc, VALUE *argv, VALUE self) { FXComboBox *arg1 = (FXComboBox *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXComboBox, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]);
    arg4 = reinterpret_cast<void*>(NUM2INT(argv[2])); result = (long)(arg1)->onListClicked(arg2,arg3,arg4);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXComboBox_onFwdToText(int argc, VALUE *argv, VALUE self) { FXComboBox *arg1 = (FXComboBox *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXComboBox, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onFwdToText(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXComboBox_onUpdFmText(int argc, VALUE *argv, VALUE self) { FXComboBox *arg1 = (FXComboBox *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXComboBox, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onUpdFmText(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE _wrap_FXComboBox_allocate(VALUE self) {
#else
     static VALUE _wrap_FXComboBox_allocate(int argc, VALUE *argv, VALUE self) {
#endif
         VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_FXComboBox);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
         return vresult; }
static VALUE _wrap_new_FXComboBox(int argc, VALUE *argv, VALUE self) { FXComposite *arg1 = (FXComposite *) 0 ; FXint arg2 ;
    FXObject *arg3 = (FXObject *) 0 ; FXSelector arg4 = (FXSelector) 0 ; FXuint arg5 = (FXuint) COMBOBOX_NORMAL ;
    FXint arg6 = (FXint) 0 ; FXint arg7 = (FXint) 0 ; FXint arg8 = (FXint) 0 ; FXint arg9 = (FXint) 0 ;
    FXint arg10 = (FXint) DEFAULT_PAD ; FXint arg11 = (FXint) DEFAULT_PAD ; FXint arg12 = (FXint) DEFAULT_PAD ;
    FXint arg13 = (FXint) DEFAULT_PAD ; FXComboBox *result; if ((argc < 2) || (argc > 13))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXComposite, 1); arg2 = NUM2INT(argv[1]); if (argc > 2) {
        SWIG_ConvertPtr(argv[2], (void **) &arg3, SWIGTYPE_p_FXObject, 1); }  if (argc > 3) { arg4 = NUM2UINT(argv[3]); } 
    if (argc > 4) { arg5 = NUM2UINT(argv[4]); }  if (argc > 5) { arg6 = NUM2INT(argv[5]); }  if (argc > 6) {
        arg7 = NUM2INT(argv[6]); }  if (argc > 7) { arg8 = NUM2INT(argv[7]); }  if (argc > 8) { arg9 = NUM2INT(argv[8]); } 
    if (argc > 9) { arg10 = NUM2INT(argv[9]); }  if (argc > 10) { arg11 = NUM2INT(argv[10]); }  if (argc > 11) {
        arg12 = NUM2INT(argv[11]); }  if (argc > 12) { arg13 = NUM2INT(argv[12]); }  {
        result = (FXComboBox *)new_FXComboBox(arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8,arg9,arg10,arg11,arg12,arg13);
        DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result); if(rb_block_given_p()){ rb_yield(self); }  }  return self; }
static VALUE _wrap_FXComboBox_isEditable(int argc, VALUE *argv, VALUE self) { FXComboBox *arg1 = (FXComboBox *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXComboBox, 1); result = (FXbool)((FXComboBox const *)arg1)->isEditable();
    vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXComboBox_setEditable(int argc, VALUE *argv, VALUE self) { FXComboBox *arg1 = (FXComboBox *) 0 ;
    FXbool arg2 = (FXbool) 1 ; if ((argc < 0) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXComboBox, 1); if (argc > 0) { arg2 = to_FXbool(argv[0]); } 
    (arg1)->setEditable(arg2); return Qnil; }
static VALUE _wrap_FXComboBox_setText(int argc, VALUE *argv, VALUE self) { FXComboBox *arg1 = (FXComboBox *) 0 ;
    FXString *arg2 = 0 ; SwigValueWrapper<FXString > p2 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXComboBox, 1); p2 = to_FXString(argv[0]); arg2 = &p2;
    (arg1)->setText((FXString const &)*arg2); return Qnil; }
static VALUE _wrap_FXComboBox_getText(int argc, VALUE *argv, VALUE self) { FXComboBox *arg1 = (FXComboBox *) 0 ;
    FXString result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXComboBox, 1); result = ((FXComboBox const *)arg1)->getText();
    vresult = rb_str_new2((&result)->text()); return vresult; }
static VALUE _wrap_FXComboBox_setNumColumns(int argc, VALUE *argv, VALUE self) { FXComboBox *arg1 = (FXComboBox *) 0 ;
    FXint arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXComboBox, 1); arg2 = NUM2INT(argv[0]); (arg1)->setNumColumns(arg2);
    return Qnil; }
static VALUE _wrap_FXComboBox_getNumColumns(int argc, VALUE *argv, VALUE self) { FXComboBox *arg1 = (FXComboBox *) 0 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXComboBox, 1);
    result = (FXint)((FXComboBox const *)arg1)->getNumColumns(); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXComboBox_getNumItems(int argc, VALUE *argv, VALUE self) { FXComboBox *arg1 = (FXComboBox *) 0 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXComboBox, 1); result = (FXint)((FXComboBox const *)arg1)->getNumItems();
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXComboBox_getNumVisible(int argc, VALUE *argv, VALUE self) { FXComboBox *arg1 = (FXComboBox *) 0 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXComboBox, 1);
    result = (FXint)((FXComboBox const *)arg1)->getNumVisible(); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXComboBox_setNumVisible(int argc, VALUE *argv, VALUE self) { FXComboBox *arg1 = (FXComboBox *) 0 ;
    FXint arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXComboBox, 1); arg2 = NUM2INT(argv[0]); (arg1)->setNumVisible(arg2);
    return Qnil; }
static VALUE _wrap_FXComboBox_isItemCurrent(int argc, VALUE *argv, VALUE self) { FXComboBox *arg1 = (FXComboBox *) 0 ;
    FXint arg2 ; FXbool result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXComboBox, 1); arg2 = NUM2INT(argv[0]); {
        if (arg2 < 0 || arg2 >= arg1->getNumItems()) { rb_raise(rb_eIndexError, "combobox item index out of bounds"); }  } 
    result = (FXbool)((FXComboBox const *)arg1)->isItemCurrent(arg2); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXComboBox_setCurrentItem(int argc, VALUE *argv, VALUE self) { FXComboBox *arg1 = (FXComboBox *) 0 ;
    FXint arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXComboBox, 1); arg2 = NUM2INT(argv[0]); (arg1)->setCurrentItem(arg2);
    return Qnil; }
static VALUE _wrap_FXComboBox_getCurrentItem(int argc, VALUE *argv, VALUE self) { FXComboBox *arg1 = (FXComboBox *) 0 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXComboBox, 1);
    result = (FXint)((FXComboBox const *)arg1)->getCurrentItem(); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXComboBox_getItem(int argc, VALUE *argv, VALUE self) { FXComboBox *arg1 = (FXComboBox *) 0 ; FXint arg2 ;
    FXString result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXComboBox, 1); arg2 = NUM2INT(argv[0]); {
        if (arg2 < 0 || arg2 >= arg1->getNumItems()) { rb_raise(rb_eIndexError, "combobox item index out of bounds"); }  } 
    result = ((FXComboBox const *)arg1)->getItem(arg2); vresult = rb_str_new2((&result)->text()); return vresult; }
static VALUE _wrap_FXComboBox_setItem(int argc, VALUE *argv, VALUE self) { FXComboBox *arg1 = (FXComboBox *) 0 ; FXint arg2 ;
    FXString *arg3 = 0 ; void *arg4 = (void *) 0 ; FXint result; SwigValueWrapper<FXString > p3 ; VALUE vresult = Qnil;
    if ((argc < 2) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXComboBox, 1); arg2 = NUM2INT(argv[0]);
    p3 = to_FXString(argv[1]); arg3 = &p3; if (argc > 2) { arg4 = (argv[2] == Qnil) ? NULL : (void *) argv[2]; }  {
        if (arg2 < 0 || arg2 >= arg1->getNumItems()) { rb_raise(rb_eIndexError, "combobox item index out of bounds"); }  } 
    result = (FXint)(arg1)->setItem(arg2,(FXString const &)*arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXComboBox_insertItem(int argc, VALUE *argv, VALUE self) { FXComboBox *arg1 = (FXComboBox *) 0 ; FXint arg2 ;
    FXString *arg3 = 0 ; void *arg4 = (void *) 0 ; FXint result; SwigValueWrapper<FXString > p3 ; VALUE vresult = Qnil;
    if ((argc < 2) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXComboBox, 1); arg2 = NUM2INT(argv[0]);
    p3 = to_FXString(argv[1]); arg3 = &p3; if (argc > 2) { arg4 = (argv[2] == Qnil) ? NULL : (void *) argv[2]; }  {
        if (arg2 < 0 || arg2 >= arg1->getNumItems()) { rb_raise(rb_eIndexError, "combobox item index out of bounds"); }  } 
    result = (FXint)(arg1)->insertItem(arg2,(FXString const &)*arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXComboBox_appendItem(int argc, VALUE *argv, VALUE self) { FXComboBox *arg1 = (FXComboBox *) 0 ;
    FXString *arg2 = 0 ; void *arg3 = (void *) 0 ; FXint result; SwigValueWrapper<FXString > p2 ; VALUE vresult = Qnil;
    if ((argc < 1) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXComboBox, 1); p2 = to_FXString(argv[0]); arg2 = &p2; if (argc > 1) {
        arg3 = (argv[1] == Qnil) ? NULL : (void *) argv[1]; }  result = (FXint)(arg1)->appendItem((FXString const &)*arg2,arg3);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXComboBox_prependItem(int argc, VALUE *argv, VALUE self) { FXComboBox *arg1 = (FXComboBox *) 0 ;
    FXString *arg2 = 0 ; void *arg3 = (void *) 0 ; FXint result; SwigValueWrapper<FXString > p2 ; VALUE vresult = Qnil;
    if ((argc < 1) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXComboBox, 1); p2 = to_FXString(argv[0]); arg2 = &p2; if (argc > 1) {
        arg3 = (argv[1] == Qnil) ? NULL : (void *) argv[1]; } 
    result = (FXint)(arg1)->prependItem((FXString const &)*arg2,arg3); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXComboBox_moveItem(int argc, VALUE *argv, VALUE self) { FXComboBox *arg1 = (FXComboBox *) 0 ; FXint arg2 ;
    FXint arg3 ; FXint result; VALUE vresult = Qnil; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXComboBox, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]); {
        if (arg2 < 0 || arg2 >= arg1->getNumItems()) { rb_raise(rb_eIndexError, "combobox item index out of bounds"); }  }  {
        if (arg3 < 0 || arg3 >= arg1->getNumItems()) { rb_raise(rb_eIndexError, "combobox item index out of bounds"); }  } 
    result = (FXint)(arg1)->moveItem(arg2,arg3); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXComboBox_removeItem(int argc, VALUE *argv, VALUE self) { FXComboBox *arg1 = (FXComboBox *) 0 ; FXint arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXComboBox, 1); arg2 = NUM2INT(argv[0]); {
        if (arg2 < 0 || arg2 >= arg1->getNumItems()) { rb_raise(rb_eIndexError, "combobox item index out of bounds"); }  } 
    (arg1)->removeItem(arg2); return Qnil; }
static VALUE _wrap_FXComboBox_clearItems(int argc, VALUE *argv, VALUE self) { FXComboBox *arg1 = (FXComboBox *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXComboBox, 1); (arg1)->clearItems(); return Qnil; }
static VALUE _wrap_FXComboBox_findItem(int argc, VALUE *argv, VALUE self) { FXComboBox *arg1 = (FXComboBox *) 0 ;
    FXString *arg2 = 0 ; FXint arg3 = (FXint) -1 ; FXuint arg4 = (FXuint) SEARCH_FORWARD|SEARCH_WRAP ; FXint result;
    SwigValueWrapper<FXString > p2 ; VALUE vresult = Qnil; if ((argc < 1) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXComboBox, 1); p2 = to_FXString(argv[0]); arg2 = &p2; if (argc > 1) {
        arg3 = NUM2INT(argv[1]); }  if (argc > 2) { arg4 = NUM2UINT(argv[2]); } 
    result = (FXint)((FXComboBox const *)arg1)->findItem((FXString const &)*arg2,arg3,arg4); vresult = INT2NUM(result);
    return vresult; }
static VALUE _wrap_FXComboBox_setItemText(int argc, VALUE *argv, VALUE self) { FXComboBox *arg1 = (FXComboBox *) 0 ;
    FXint arg2 ; FXString *arg3 = 0 ; SwigValueWrapper<FXString > p3 ; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXComboBox, 1); arg2 = NUM2INT(argv[0]);
    p3 = to_FXString(argv[1]); arg3 = &p3; { if (arg2 < 0 || arg2 >= arg1->getNumItems()) {
            rb_raise(rb_eIndexError, "combobox item index out of bounds"); }  } 
    (arg1)->setItemText(arg2,(FXString const &)*arg3); return Qnil; }
static VALUE _wrap_FXComboBox_getItemText(int argc, VALUE *argv, VALUE self) { FXComboBox *arg1 = (FXComboBox *) 0 ;
    FXint arg2 ; FXString result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXComboBox, 1); arg2 = NUM2INT(argv[0]); {
        if (arg2 < 0 || arg2 >= arg1->getNumItems()) { rb_raise(rb_eIndexError, "combobox item index out of bounds"); }  } 
    result = ((FXComboBox const *)arg1)->getItemText(arg2); vresult = rb_str_new2((&result)->text()); return vresult; }
static VALUE _wrap_FXComboBox_setItemData(int argc, VALUE *argv, VALUE self) { FXComboBox *arg1 = (FXComboBox *) 0 ;
    FXint arg2 ; VALUE arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXComboBox, 1); arg2 = NUM2INT(argv[0]); arg3 = argv[1]; {
        if (arg2 < 0 || arg2 >= arg1->getNumItems()) { rb_raise(rb_eIndexError, "combobox item index out of bounds"); }  } 
    FXComboBox_setItemData(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXComboBox_getItemData(int argc, VALUE *argv, VALUE self) { FXComboBox *arg1 = (FXComboBox *) 0 ;
    FXint arg2 ; VALUE result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXComboBox, 1); arg2 = NUM2INT(argv[0]); {
        if (arg2 < 0 || arg2 >= arg1->getNumItems()) { rb_raise(rb_eIndexError, "combobox item index out of bounds"); }  } 
    result = (VALUE)FXComboBox_getItemData((FXComboBox const *)arg1,arg2); vresult = result; return vresult; }
static VALUE _wrap_FXComboBox_isPaneShown(int argc, VALUE *argv, VALUE self) { FXComboBox *arg1 = (FXComboBox *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXComboBox, 1);
    result = (FXbool)((FXComboBox const *)arg1)->isPaneShown(); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXComboBox_sortItems(int argc, VALUE *argv, VALUE self) { FXComboBox *arg1 = (FXComboBox *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXComboBox, 1); (arg1)->sortItems(); return Qnil; }
static VALUE _wrap_FXComboBox_setFont(int argc, VALUE *argv, VALUE self) { FXComboBox *arg1 = (FXComboBox *) 0 ;
    FXFont *arg2 = (FXFont *) 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXComboBox, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXFont, 1); (arg1)->setFont(arg2); return Qnil; }
static VALUE _wrap_FXComboBox_getFont(int argc, VALUE *argv, VALUE self) { FXComboBox *arg1 = (FXComboBox *) 0 ; FXFont *result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXComboBox, 1); result = (FXFont *)((FXComboBox const *)arg1)->getFont();
    { swig_type_info *ty = SWIG_TypeDynamicCast(SWIGTYPE_p_FXFont, (void **) &result); vresult = FXRbGetRubyObj(result, ty); } 
    return vresult; }
static VALUE _wrap_FXComboBox_setComboStyle(int argc, VALUE *argv, VALUE self) { FXComboBox *arg1 = (FXComboBox *) 0 ;
    FXuint arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXComboBox, 1); arg2 = NUM2UINT(argv[0]); (arg1)->setComboStyle(arg2);
    return Qnil; }
static VALUE _wrap_FXComboBox_getComboStyle(int argc, VALUE *argv, VALUE self) { FXComboBox *arg1 = (FXComboBox *) 0 ;
    FXuint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXComboBox, 1);
    result = (FXuint)((FXComboBox const *)arg1)->getComboStyle(); vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXComboBox_getBackColor(int argc, VALUE *argv, VALUE self) { FXComboBox *arg1 = (FXComboBox *) 0 ;
    FXColor result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXComboBox, 1);
    result = (FXColor)((FXComboBox const *)arg1)->getBackColor(); vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXComboBox_setTextColor(int argc, VALUE *argv, VALUE self) { FXComboBox *arg1 = (FXComboBox *) 0 ;
    FXColor arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXComboBox, 1); arg2 = to_FXColor(argv[0]); (arg1)->setTextColor(arg2);
    return Qnil; }
static VALUE _wrap_FXComboBox_getTextColor(int argc, VALUE *argv, VALUE self) { FXComboBox *arg1 = (FXComboBox *) 0 ;
    FXColor result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXComboBox, 1);
    result = (FXColor)((FXComboBox const *)arg1)->getTextColor(); vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXComboBox_setSelBackColor(int argc, VALUE *argv, VALUE self) { FXComboBox *arg1 = (FXComboBox *) 0 ;
    FXColor arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXComboBox, 1); arg2 = to_FXColor(argv[0]); (arg1)->setSelBackColor(arg2);
    return Qnil; }
static VALUE _wrap_FXComboBox_getSelBackColor(int argc, VALUE *argv, VALUE self) { FXComboBox *arg1 = (FXComboBox *) 0 ;
    FXColor result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXComboBox, 1);
    result = (FXColor)((FXComboBox const *)arg1)->getSelBackColor(); vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXComboBox_setSelTextColor(int argc, VALUE *argv, VALUE self) { FXComboBox *arg1 = (FXComboBox *) 0 ;
    FXColor arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXComboBox, 1); arg2 = to_FXColor(argv[0]); (arg1)->setSelTextColor(arg2);
    return Qnil; }
static VALUE _wrap_FXComboBox_getSelTextColor(int argc, VALUE *argv, VALUE self) { FXComboBox *arg1 = (FXComboBox *) 0 ;
    FXColor result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXComboBox, 1);
    result = (FXColor)((FXComboBox const *)arg1)->getSelTextColor(); vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXComboBox_setHelpText(int argc, VALUE *argv, VALUE self) { FXComboBox *arg1 = (FXComboBox *) 0 ;
    FXString *arg2 = 0 ; SwigValueWrapper<FXString > p2 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXComboBox, 1); p2 = to_FXString(argv[0]); arg2 = &p2;
    (arg1)->setHelpText((FXString const &)*arg2); return Qnil; }
static VALUE _wrap_FXComboBox_getHelpText(int argc, VALUE *argv, VALUE self) { FXComboBox *arg1 = (FXComboBox *) 0 ;
    FXString result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXComboBox, 1); result = ((FXComboBox const *)arg1)->getHelpText();
    vresult = rb_str_new2((&result)->text()); return vresult; }
static VALUE _wrap_FXComboBox_setTipText(int argc, VALUE *argv, VALUE self) { FXComboBox *arg1 = (FXComboBox *) 0 ;
    FXString *arg2 = 0 ; SwigValueWrapper<FXString > p2 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXComboBox, 1); p2 = to_FXString(argv[0]); arg2 = &p2;
    (arg1)->setTipText((FXString const &)*arg2); return Qnil; }
static VALUE _wrap_FXComboBox_getTipText(int argc, VALUE *argv, VALUE self) { FXComboBox *arg1 = (FXComboBox *) 0 ;
    FXString result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXComboBox, 1); result = ((FXComboBox const *)arg1)->getTipText();
    vresult = rb_str_new2((&result)->text()); return vresult; }
static void
free_FXComboBox(FXComboBox *arg1) {
    delete arg1;
}
static VALUE _wrap_FXComboBox_save(int argc, VALUE *argv, VALUE self) { FXComboBox *arg1 = (FXComboBox *) 0 ;
    FXStream *arg2 = 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXComboBox, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXComboBox_save((FXComboBox const *)arg1,*arg2); return Qnil; }
static VALUE _wrap_FXComboBox_load(int argc, VALUE *argv, VALUE self) { FXComboBox *arg1 = (FXComboBox *) 0 ;
    FXStream *arg2 = 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXComboBox, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXComboBox_load(arg1,*arg2); return Qnil; }
static VALUE _wrap_FXComboBox_create(int argc, VALUE *argv, VALUE self) { FXComboBox *arg1 = (FXComboBox *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXComboBox, 1); FXComboBox_create(arg1); return Qnil; }
static VALUE _wrap_FXComboBox_detach(int argc, VALUE *argv, VALUE self) { FXComboBox *arg1 = (FXComboBox *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXComboBox, 1); FXComboBox_detach(arg1); return Qnil; }
static VALUE _wrap_FXComboBox_destroy(int argc, VALUE *argv, VALUE self) { FXComboBox *arg1 = (FXComboBox *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXComboBox, 1); FXComboBox_destroy(arg1); return Qnil; }
static VALUE _wrap_FXComboBox_resize(int argc, VALUE *argv, VALUE self) { FXComboBox *arg1 = (FXComboBox *) 0 ; FXint arg2 ;
    FXint arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXComboBox, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    FXComboBox_resize(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXComboBox_getDefaultWidth(int argc, VALUE *argv, VALUE self) { FXComboBox *arg1 = (FXComboBox *) 0 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXComboBox, 1); result = (FXint)FXComboBox_getDefaultWidth(arg1);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXComboBox_getDefaultHeight(int argc, VALUE *argv, VALUE self) { FXComboBox *arg1 = (FXComboBox *) 0 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXComboBox, 1); result = (FXint)FXComboBox_getDefaultHeight(arg1);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXComboBox_getWidthForHeight(int argc, VALUE *argv, VALUE self) { FXComboBox *arg1 = (FXComboBox *) 0 ;
    FXint arg2 ; FXint result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXComboBox, 1); arg2 = NUM2INT(argv[0]);
    result = (FXint)FXComboBox_getWidthForHeight(arg1,arg2); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXComboBox_getHeightForWidth(int argc, VALUE *argv, VALUE self) { FXComboBox *arg1 = (FXComboBox *) 0 ;
    FXint arg2 ; FXint result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXComboBox, 1); arg2 = NUM2INT(argv[0]);
    result = (FXint)FXComboBox_getHeightForWidth(arg1,arg2); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXComboBox_canFocus(int argc, VALUE *argv, VALUE self) { FXComboBox *arg1 = (FXComboBox *) 0 ; FXbool result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXComboBox, 1);
    result = (FXbool)FXComboBox_canFocus((FXComboBox const *)arg1); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXComboBox_setFocus(int argc, VALUE *argv, VALUE self) { FXComboBox *arg1 = (FXComboBox *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXComboBox, 1); FXComboBox_setFocus(arg1); return Qnil; }
static VALUE _wrap_FXComboBox_killFocus(int argc, VALUE *argv, VALUE self) { FXComboBox *arg1 = (FXComboBox *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXComboBox, 1); FXComboBox_killFocus(arg1); return Qnil; }
static VALUE _wrap_FXComboBox_setDefault(int argc, VALUE *argv, VALUE self) { FXComboBox *arg1 = (FXComboBox *) 0 ;
    FXbool arg2 = (FXbool) 1 ; if ((argc < 0) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXComboBox, 1); if (argc > 0) { arg2 = to_FXbool(argv[0]); } 
    FXComboBox_setDefault(arg1,arg2); return Qnil; }
static VALUE _wrap_FXComboBox_enable(int argc, VALUE *argv, VALUE self) { FXComboBox *arg1 = (FXComboBox *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXComboBox, 1); FXComboBox_enable(arg1); return Qnil; }
static VALUE _wrap_FXComboBox_disable(int argc, VALUE *argv, VALUE self) { FXComboBox *arg1 = (FXComboBox *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXComboBox, 1); FXComboBox_disable(arg1); return Qnil; }
static VALUE _wrap_FXComboBox_raiseWindow(int argc, VALUE *argv, VALUE self) { FXComboBox *arg1 = (FXComboBox *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXComboBox, 1); FXComboBox_raise(arg1); return Qnil; }
static VALUE _wrap_FXComboBox_lower(int argc, VALUE *argv, VALUE self) { FXComboBox *arg1 = (FXComboBox *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXComboBox, 1); FXComboBox_lower(arg1); return Qnil; }
static VALUE _wrap_FXComboBox_move(int argc, VALUE *argv, VALUE self) { FXComboBox *arg1 = (FXComboBox *) 0 ; FXint arg2 ;
    FXint arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXComboBox, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    FXComboBox_move(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXComboBox_position(int argc, VALUE *argv, VALUE self) { FXComboBox *arg1 = (FXComboBox *) 0 ; FXint arg2 ;
    FXint arg3 ; FXint arg4 ; FXint arg5 ; if ((argc < 4) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXComboBox, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    arg4 = NUM2INT(argv[2]); arg5 = NUM2INT(argv[3]); FXComboBox_position(arg1,arg2,arg3,arg4,arg5); return Qnil; }
static VALUE _wrap_FXComboBox_layout(int argc, VALUE *argv, VALUE self) { FXComboBox *arg1 = (FXComboBox *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXComboBox, 1); FXComboBox_layout(arg1); return Qnil; }
static VALUE _wrap_FXComboBox_recalc(int argc, VALUE *argv, VALUE self) { FXComboBox *arg1 = (FXComboBox *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXComboBox, 1); FXComboBox_recalc(arg1); return Qnil; }
static VALUE _wrap_FXComboBox_reparent(int argc, VALUE *argv, VALUE self) { FXComboBox *arg1 = (FXComboBox *) 0 ;
    FXComposite *arg2 = (FXComposite *) 0 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXComboBox, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXComposite, 1); FXComboBox_reparent(arg1,arg2); return Qnil; }
static VALUE _wrap_FXComboBox_show(int argc, VALUE *argv, VALUE self) { FXComboBox *arg1 = (FXComboBox *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXComboBox, 1); FXComboBox_show(arg1); return Qnil; }
static VALUE _wrap_FXComboBox_hide(int argc, VALUE *argv, VALUE self) { FXComboBox *arg1 = (FXComboBox *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXComboBox, 1); FXComboBox_hide(arg1); return Qnil; }
static VALUE _wrap_FXComboBox_isComposite(int argc, VALUE *argv, VALUE self) { FXComboBox *arg1 = (FXComboBox *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXComboBox, 1);
    result = (FXbool)FXComboBox_isComposite((FXComboBox const *)arg1); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXComboBox_contains(int argc, VALUE *argv, VALUE self) { FXComboBox *arg1 = (FXComboBox *) 0 ; FXint arg2 ;
    FXint arg3 ; FXbool result; VALUE vresult = Qnil; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXComboBox, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    result = (FXbool)FXComboBox_contains((FXComboBox const *)arg1,arg2,arg3); vresult = result ? Qtrue : Qfalse;
    return vresult; }
static VALUE _wrap_FXComboBox_doesSaveUnder(int argc, VALUE *argv, VALUE self) { FXComboBox *arg1 = (FXComboBox *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXComboBox, 1);
    result = (FXbool)FXComboBox_doesSaveUnder((FXComboBox const *)arg1); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXComboBox_setBackColor(int argc, VALUE *argv, VALUE self) { FXComboBox *arg1 = (FXComboBox *) 0 ;
    FXColor arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXComboBox, 1); arg2 = to_FXColor(argv[0]);
    FXComboBox_setBackColor(arg1,arg2); return Qnil; }
static VALUE _wrap_FXListBox_onFocusUp(int argc, VALUE *argv, VALUE self) { FXListBox *arg1 = (FXListBox *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXListBox, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onFocusUp(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXListBox_onFocusDown(int argc, VALUE *argv, VALUE self) { FXListBox *arg1 = (FXListBox *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXListBox, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onFocusDown(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXListBox_onFocusSelf(int argc, VALUE *argv, VALUE self) { FXListBox *arg1 = (FXListBox *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXListBox, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onFocusSelf(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXListBox_onFieldButton(int argc, VALUE *argv, VALUE self) { FXListBox *arg1 = (FXListBox *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXListBox, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onFieldButton(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXListBox_onListUpdate(int argc, VALUE *argv, VALUE self) { FXListBox *arg1 = (FXListBox *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXListBox, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onListUpdate(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXListBox_onListChanged(int argc, VALUE *argv, VALUE self) { FXListBox *arg1 = (FXListBox *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXListBox, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]);
    arg4 = reinterpret_cast<void*>(NUM2INT(argv[2])); result = (long)(arg1)->onListChanged(arg2,arg3,arg4);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXListBox_onListClicked(int argc, VALUE *argv, VALUE self) { FXListBox *arg1 = (FXListBox *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXListBox, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]);
    arg4 = reinterpret_cast<void*>(NUM2INT(argv[2])); result = (long)(arg1)->onListClicked(arg2,arg3,arg4);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXListBox_onCmdSetValue(int argc, VALUE *argv, VALUE self) { FXListBox *arg1 = (FXListBox *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXListBox, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]);
    arg4 = reinterpret_cast<void*>(NUM2INT(argv[2])); result = (long)(arg1)->onCmdSetValue(arg2,arg3,arg4);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXListBox_onCmdGetIntValue(int argc, VALUE *argv, VALUE self) { FXListBox *arg1 = (FXListBox *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXListBox, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdGetIntValue(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXListBox_onCmdSetIntValue(int argc, VALUE *argv, VALUE self) { FXListBox *arg1 = (FXListBox *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; FXint value4 ;
    VALUE vresult = Qnil; if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXListBox, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); {
        value4 = (FXint) NUM2INT(argv[2]); arg4 = static_cast<void*>(&value4); } 
    result = (long)(arg1)->onCmdSetIntValue(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE _wrap_FXListBox_allocate(VALUE self) {
#else
     static VALUE _wrap_FXListBox_allocate(int argc, VALUE *argv, VALUE self) {
#endif
         VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_FXListBox);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
         return vresult; }
static VALUE _wrap_new_FXListBox(int argc, VALUE *argv, VALUE self) { FXComposite *arg1 = (FXComposite *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 = (FXSelector) 0 ;
    FXuint arg4 = (FXuint) FRAME_SUNKEN|FRAME_THICK|LISTBOX_NORMAL ; FXint arg5 = (FXint) 0 ; FXint arg6 = (FXint) 0 ;
    FXint arg7 = (FXint) 0 ; FXint arg8 = (FXint) 0 ; FXint arg9 = (FXint) DEFAULT_PAD ; FXint arg10 = (FXint) DEFAULT_PAD ;
    FXint arg11 = (FXint) DEFAULT_PAD ; FXint arg12 = (FXint) DEFAULT_PAD ; FXListBox *result; if ((argc < 1) || (argc > 12))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXComposite, 1); if (argc > 1) {
        SWIG_ConvertPtr(argv[1], (void **) &arg2, SWIGTYPE_p_FXObject, 1); }  if (argc > 2) { arg3 = NUM2UINT(argv[2]); } 
    if (argc > 3) { arg4 = NUM2UINT(argv[3]); }  if (argc > 4) { arg5 = NUM2INT(argv[4]); }  if (argc > 5) {
        arg6 = NUM2INT(argv[5]); }  if (argc > 6) { arg7 = NUM2INT(argv[6]); }  if (argc > 7) { arg8 = NUM2INT(argv[7]); } 
    if (argc > 8) { arg9 = NUM2INT(argv[8]); }  if (argc > 9) { arg10 = NUM2INT(argv[9]); }  if (argc > 10) {
        arg11 = NUM2INT(argv[10]); }  if (argc > 11) { arg12 = NUM2INT(argv[11]); }  {
        result = (FXListBox *)new_FXListBox(arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8,arg9,arg10,arg11,arg12);
        DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result); if(rb_block_given_p()){ rb_yield(self); }  }  return self; }
static VALUE _wrap_FXListBox_getNumItems(int argc, VALUE *argv, VALUE self) { FXListBox *arg1 = (FXListBox *) 0 ; FXint result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXListBox, 1); result = (FXint)((FXListBox const *)arg1)->getNumItems();
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXListBox_getNumVisible(int argc, VALUE *argv, VALUE self) { FXListBox *arg1 = (FXListBox *) 0 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXListBox, 1); result = (FXint)((FXListBox const *)arg1)->getNumVisible();
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXListBox_setNumVisible(int argc, VALUE *argv, VALUE self) { FXListBox *arg1 = (FXListBox *) 0 ; FXint arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXListBox, 1); arg2 = NUM2INT(argv[0]); (arg1)->setNumVisible(arg2);
    return Qnil; }
static VALUE _wrap_FXListBox_isItemCurrent(int argc, VALUE *argv, VALUE self) { FXListBox *arg1 = (FXListBox *) 0 ; FXint arg2 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXListBox, 1); arg2 = NUM2INT(argv[0]); {
        if (arg2 < 0 || arg2 >= arg1->getNumItems()) { rb_raise(rb_eIndexError, "list box item index out of bounds"); }  } 
    result = (FXbool)((FXListBox const *)arg1)->isItemCurrent(arg2); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXListBox_setCurrentItem(int argc, VALUE *argv, VALUE self) { FXListBox *arg1 = (FXListBox *) 0 ;
    FXint arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXListBox, 1); arg2 = NUM2INT(argv[0]); {
        if (arg2 < 0 || arg2 >= arg1->getNumItems()) { rb_raise(rb_eIndexError, "list box item index out of bounds"); }  } 
    (arg1)->setCurrentItem(arg2); return Qnil; }
static VALUE _wrap_FXListBox_getCurrentItem(int argc, VALUE *argv, VALUE self) { FXListBox *arg1 = (FXListBox *) 0 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXListBox, 1);
    result = (FXint)((FXListBox const *)arg1)->getCurrentItem(); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXListBox_getItem(int argc, VALUE *argv, VALUE self) { FXListBox *arg1 = (FXListBox *) 0 ; FXint arg2 ;
    FXString result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXListBox, 1); arg2 = NUM2INT(argv[0]); {
        if (arg2 < 0 || arg2 >= arg1->getNumItems()) { rb_raise(rb_eIndexError, "list box item index out of bounds"); }  } 
    result = ((FXListBox const *)arg1)->getItem(arg2); vresult = rb_str_new2((&result)->text()); return vresult; }
static VALUE _wrap_FXListBox_setItem(int argc, VALUE *argv, VALUE self) { FXListBox *arg1 = (FXListBox *) 0 ; FXint arg2 ;
    FXString *arg3 = 0 ; FXIcon *arg4 = (FXIcon *) 0 ; void *arg5 = (void *) 0 ; FXint result; SwigValueWrapper<FXString > p3 ;
    VALUE vresult = Qnil; if ((argc < 2) || (argc > 4)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXListBox, 1); arg2 = NUM2INT(argv[0]);
    p3 = to_FXString(argv[1]); arg3 = &p3; if (argc > 2) { SWIG_ConvertPtr(argv[2], (void **) &arg4, SWIGTYPE_p_FXIcon, 1); } 
    if (argc > 3) { arg5 = (argv[3] == Qnil) ? NULL : (void *) argv[3]; }  { if (arg2 < 0 || arg2 >= arg1->getNumItems()) {
            rb_raise(rb_eIndexError, "list box item index out of bounds"); }  } 
    result = (FXint)(arg1)->setItem(arg2,(FXString const &)*arg3,arg4,arg5); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXListBox_insertItem(int argc, VALUE *argv, VALUE self) { FXListBox *arg1 = (FXListBox *) 0 ; FXint arg2 ;
    FXString *arg3 = 0 ; FXIcon *arg4 = (FXIcon *) 0 ; void *arg5 = (void *) 0 ; FXint result; SwigValueWrapper<FXString > p3 ;
    VALUE vresult = Qnil; if ((argc < 2) || (argc > 4)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXListBox, 1); arg2 = NUM2INT(argv[0]);
    p3 = to_FXString(argv[1]); arg3 = &p3; if (argc > 2) { SWIG_ConvertPtr(argv[2], (void **) &arg4, SWIGTYPE_p_FXIcon, 1); } 
    if (argc > 3) { arg5 = (argv[3] == Qnil) ? NULL : (void *) argv[3]; }  { if (arg2 < 0 || arg2 >= arg1->getNumItems()) {
            rb_raise(rb_eIndexError, "list box item index out of bounds"); }  } 
    result = (FXint)(arg1)->insertItem(arg2,(FXString const &)*arg3,arg4,arg5); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXListBox_appendItem(int argc, VALUE *argv, VALUE self) { FXListBox *arg1 = (FXListBox *) 0 ;
    FXString *arg2 = 0 ; FXIcon *arg3 = (FXIcon *) 0 ; void *arg4 = (void *) 0 ; FXint result; SwigValueWrapper<FXString > p2 ;
    VALUE vresult = Qnil; if ((argc < 1) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXListBox, 1); p2 = to_FXString(argv[0]); arg2 = &p2; if (argc > 1) {
        SWIG_ConvertPtr(argv[1], (void **) &arg3, SWIGTYPE_p_FXIcon, 1); }  if (argc > 2) {
        arg4 = (argv[2] == Qnil) ? NULL : (void *) argv[2]; } 
    result = (FXint)(arg1)->appendItem((FXString const &)*arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXListBox_prependItem(int argc, VALUE *argv, VALUE self) { FXListBox *arg1 = (FXListBox *) 0 ;
    FXString *arg2 = 0 ; FXIcon *arg3 = (FXIcon *) 0 ; void *arg4 = (void *) 0 ; FXint result; SwigValueWrapper<FXString > p2 ;
    VALUE vresult = Qnil; if ((argc < 1) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXListBox, 1); p2 = to_FXString(argv[0]); arg2 = &p2; if (argc > 1) {
        SWIG_ConvertPtr(argv[1], (void **) &arg3, SWIGTYPE_p_FXIcon, 1); }  if (argc > 2) {
        arg4 = (argv[2] == Qnil) ? NULL : (void *) argv[2]; } 
    result = (FXint)(arg1)->prependItem((FXString const &)*arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXListBox_moveItem(int argc, VALUE *argv, VALUE self) { FXListBox *arg1 = (FXListBox *) 0 ; FXint arg2 ;
    FXint arg3 ; FXint result; VALUE vresult = Qnil; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXListBox, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]); {
        if (arg2 < 0 || arg2 >= arg1->getNumItems()) { rb_raise(rb_eIndexError, "list box item index out of bounds"); }  }  {
        if (arg3 < 0 || arg3 >= arg1->getNumItems()) { rb_raise(rb_eIndexError, "list box item index out of bounds"); }  } 
    result = (FXint)(arg1)->moveItem(arg2,arg3); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXListBox_removeItem(int argc, VALUE *argv, VALUE self) { FXListBox *arg1 = (FXListBox *) 0 ; FXint arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXListBox, 1); arg2 = NUM2INT(argv[0]); {
        if (arg2 < 0 || arg2 >= arg1->getNumItems()) { rb_raise(rb_eIndexError, "list box item index out of bounds"); }  } 
    (arg1)->removeItem(arg2); return Qnil; }
static VALUE _wrap_FXListBox_clearItems(int argc, VALUE *argv, VALUE self) { FXListBox *arg1 = (FXListBox *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXListBox, 1); (arg1)->clearItems(); return Qnil; }
static VALUE _wrap_FXListBox_findItem(int argc, VALUE *argv, VALUE self) { FXListBox *arg1 = (FXListBox *) 0 ;
    FXString *arg2 = 0 ; FXint arg3 = (FXint) -1 ; FXuint arg4 = (FXuint) SEARCH_FORWARD|SEARCH_WRAP ; FXint result;
    SwigValueWrapper<FXString > p2 ; VALUE vresult = Qnil; if ((argc < 1) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXListBox, 1); p2 = to_FXString(argv[0]); arg2 = &p2; if (argc > 1) {
        arg3 = NUM2INT(argv[1]); }  if (argc > 2) { arg4 = NUM2UINT(argv[2]); } 
    result = (FXint)((FXListBox const *)arg1)->findItem((FXString const &)*arg2,arg3,arg4); vresult = INT2NUM(result);
    return vresult; }
static VALUE _wrap_FXListBox_setItemText(int argc, VALUE *argv, VALUE self) { FXListBox *arg1 = (FXListBox *) 0 ; FXint arg2 ;
    FXString *arg3 = 0 ; SwigValueWrapper<FXString > p3 ; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXListBox, 1); arg2 = NUM2INT(argv[0]);
    p3 = to_FXString(argv[1]); arg3 = &p3; { if (arg2 < 0 || arg2 >= arg1->getNumItems()) {
            rb_raise(rb_eIndexError, "list box item index out of bounds"); }  } 
    (arg1)->setItemText(arg2,(FXString const &)*arg3); return Qnil; }
static VALUE _wrap_FXListBox_getItemText(int argc, VALUE *argv, VALUE self) { FXListBox *arg1 = (FXListBox *) 0 ; FXint arg2 ;
    FXString result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXListBox, 1); arg2 = NUM2INT(argv[0]); {
        if (arg2 < 0 || arg2 >= arg1->getNumItems()) { rb_raise(rb_eIndexError, "list box item index out of bounds"); }  } 
    result = ((FXListBox const *)arg1)->getItemText(arg2); vresult = rb_str_new2((&result)->text()); return vresult; }
static VALUE _wrap_FXListBox_setItemIcon(int argc, VALUE *argv, VALUE self) { FXListBox *arg1 = (FXListBox *) 0 ; FXint arg2 ;
    FXIcon *arg3 = (FXIcon *) 0 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXListBox, 1); arg2 = NUM2INT(argv[0]);
    SWIG_ConvertPtr(argv[1], (void **) &arg3, SWIGTYPE_p_FXIcon, 1); { if (arg2 < 0 || arg2 >= arg1->getNumItems()) {
            rb_raise(rb_eIndexError, "list box item index out of bounds"); }  }  (arg1)->setItemIcon(arg2,arg3); return Qnil; }
static VALUE _wrap_FXListBox_getItemIcon(int argc, VALUE *argv, VALUE self) { FXListBox *arg1 = (FXListBox *) 0 ; FXint arg2 ;
    FXIcon *result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXListBox, 1); arg2 = NUM2INT(argv[0]); {
        if (arg2 < 0 || arg2 >= arg1->getNumItems()) { rb_raise(rb_eIndexError, "list box item index out of bounds"); }  } 
    result = (FXIcon *)((FXListBox const *)arg1)->getItemIcon(arg2); {
        swig_type_info *ty = SWIG_TypeDynamicCast(SWIGTYPE_p_FXIcon, (void **) &result); vresult = FXRbGetRubyObj(result, ty); }
     return vresult; }
static VALUE _wrap_FXListBox_setItemData(int argc, VALUE *argv, VALUE self) { FXListBox *arg1 = (FXListBox *) 0 ; FXint arg2 ;
    VALUE arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXListBox, 1); arg2 = NUM2INT(argv[0]); arg3 = argv[1]; {
        if (arg2 < 0 || arg2 >= arg1->getNumItems()) { rb_raise(rb_eIndexError, "list box item index out of bounds"); }  } 
    FXListBox_setItemData(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXListBox_getItemData(int argc, VALUE *argv, VALUE self) { FXListBox *arg1 = (FXListBox *) 0 ; FXint arg2 ;
    VALUE result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXListBox, 1); arg2 = NUM2INT(argv[0]); {
        if (arg2 < 0 || arg2 >= arg1->getNumItems()) { rb_raise(rb_eIndexError, "list box item index out of bounds"); }  } 
    result = (VALUE)FXListBox_getItemData((FXListBox const *)arg1,arg2); vresult = result; return vresult; }
static VALUE _wrap_FXListBox_isPaneShown(int argc, VALUE *argv, VALUE self) { FXListBox *arg1 = (FXListBox *) 0 ; FXbool result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXListBox, 1); result = (FXbool)((FXListBox const *)arg1)->isPaneShown();
    vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXListBox_sortItems(int argc, VALUE *argv, VALUE self) { FXListBox *arg1 = (FXListBox *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXListBox, 1); (arg1)->sortItems(); return Qnil; }
static VALUE _wrap_FXListBox_setFont(int argc, VALUE *argv, VALUE self) { FXListBox *arg1 = (FXListBox *) 0 ;
    FXFont *arg2 = (FXFont *) 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXListBox, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXFont, 1); (arg1)->setFont(arg2); return Qnil; }
static VALUE _wrap_FXListBox_getFont(int argc, VALUE *argv, VALUE self) { FXListBox *arg1 = (FXListBox *) 0 ; FXFont *result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXListBox, 1); result = (FXFont *)((FXListBox const *)arg1)->getFont(); {
        swig_type_info *ty = SWIG_TypeDynamicCast(SWIGTYPE_p_FXFont, (void **) &result); vresult = FXRbGetRubyObj(result, ty); }
     return vresult; }
static VALUE _wrap_FXListBox_getBackColor(int argc, VALUE *argv, VALUE self) { FXListBox *arg1 = (FXListBox *) 0 ;
    FXColor result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXListBox, 1);
    result = (FXColor)((FXListBox const *)arg1)->getBackColor(); vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXListBox_setTextColor(int argc, VALUE *argv, VALUE self) { FXListBox *arg1 = (FXListBox *) 0 ;
    FXColor arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXListBox, 1); arg2 = to_FXColor(argv[0]); (arg1)->setTextColor(arg2);
    return Qnil; }
static VALUE _wrap_FXListBox_getTextColor(int argc, VALUE *argv, VALUE self) { FXListBox *arg1 = (FXListBox *) 0 ;
    FXColor result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXListBox, 1);
    result = (FXColor)((FXListBox const *)arg1)->getTextColor(); vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXListBox_setSelBackColor(int argc, VALUE *argv, VALUE self) { FXListBox *arg1 = (FXListBox *) 0 ;
    FXColor arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXListBox, 1); arg2 = to_FXColor(argv[0]); (arg1)->setSelBackColor(arg2);
    return Qnil; }
static VALUE _wrap_FXListBox_getSelBackColor(int argc, VALUE *argv, VALUE self) { FXListBox *arg1 = (FXListBox *) 0 ;
    FXColor result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXListBox, 1);
    result = (FXColor)((FXListBox const *)arg1)->getSelBackColor(); vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXListBox_setSelTextColor(int argc, VALUE *argv, VALUE self) { FXListBox *arg1 = (FXListBox *) 0 ;
    FXColor arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXListBox, 1); arg2 = to_FXColor(argv[0]); (arg1)->setSelTextColor(arg2);
    return Qnil; }
static VALUE _wrap_FXListBox_getSelTextColor(int argc, VALUE *argv, VALUE self) { FXListBox *arg1 = (FXListBox *) 0 ;
    FXColor result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXListBox, 1);
    result = (FXColor)((FXListBox const *)arg1)->getSelTextColor(); vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXListBox_setHelpText(int argc, VALUE *argv, VALUE self) { FXListBox *arg1 = (FXListBox *) 0 ;
    FXString *arg2 = 0 ; SwigValueWrapper<FXString > p2 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXListBox, 1); p2 = to_FXString(argv[0]); arg2 = &p2;
    (arg1)->setHelpText((FXString const &)*arg2); return Qnil; }
static VALUE _wrap_FXListBox_getHelpText(int argc, VALUE *argv, VALUE self) { FXListBox *arg1 = (FXListBox *) 0 ;
    FXString result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXListBox, 1); result = ((FXListBox const *)arg1)->getHelpText();
    vresult = rb_str_new2((&result)->text()); return vresult; }
static VALUE _wrap_FXListBox_setTipText(int argc, VALUE *argv, VALUE self) { FXListBox *arg1 = (FXListBox *) 0 ;
    FXString *arg2 = 0 ; SwigValueWrapper<FXString > p2 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXListBox, 1); p2 = to_FXString(argv[0]); arg2 = &p2;
    (arg1)->setTipText((FXString const &)*arg2); return Qnil; }
static VALUE _wrap_FXListBox_getTipText(int argc, VALUE *argv, VALUE self) { FXListBox *arg1 = (FXListBox *) 0 ;
    FXString result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXListBox, 1); result = ((FXListBox const *)arg1)->getTipText();
    vresult = rb_str_new2((&result)->text()); return vresult; }
static void
free_FXListBox(FXListBox *arg1) {
    delete arg1;
}
static VALUE _wrap_FXListBox_save(int argc, VALUE *argv, VALUE self) { FXListBox *arg1 = (FXListBox *) 0 ; FXStream *arg2 = 0 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXListBox, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXListBox_save((FXListBox const *)arg1,*arg2); return Qnil; }
static VALUE _wrap_FXListBox_load(int argc, VALUE *argv, VALUE self) { FXListBox *arg1 = (FXListBox *) 0 ; FXStream *arg2 = 0 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXListBox, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXListBox_load(arg1,*arg2); return Qnil; }
static VALUE _wrap_FXListBox_create(int argc, VALUE *argv, VALUE self) { FXListBox *arg1 = (FXListBox *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXListBox, 1); FXListBox_create(arg1); return Qnil; }
static VALUE _wrap_FXListBox_detach(int argc, VALUE *argv, VALUE self) { FXListBox *arg1 = (FXListBox *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXListBox, 1); FXListBox_detach(arg1); return Qnil; }
static VALUE _wrap_FXListBox_destroy(int argc, VALUE *argv, VALUE self) { FXListBox *arg1 = (FXListBox *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXListBox, 1); FXListBox_destroy(arg1); return Qnil; }
static VALUE _wrap_FXListBox_resize(int argc, VALUE *argv, VALUE self) { FXListBox *arg1 = (FXListBox *) 0 ; FXint arg2 ;
    FXint arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXListBox, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    FXListBox_resize(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXListBox_getDefaultWidth(int argc, VALUE *argv, VALUE self) { FXListBox *arg1 = (FXListBox *) 0 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXListBox, 1); result = (FXint)FXListBox_getDefaultWidth(arg1);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXListBox_getDefaultHeight(int argc, VALUE *argv, VALUE self) { FXListBox *arg1 = (FXListBox *) 0 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXListBox, 1); result = (FXint)FXListBox_getDefaultHeight(arg1);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXListBox_getWidthForHeight(int argc, VALUE *argv, VALUE self) { FXListBox *arg1 = (FXListBox *) 0 ;
    FXint arg2 ; FXint result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXListBox, 1); arg2 = NUM2INT(argv[0]);
    result = (FXint)FXListBox_getWidthForHeight(arg1,arg2); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXListBox_getHeightForWidth(int argc, VALUE *argv, VALUE self) { FXListBox *arg1 = (FXListBox *) 0 ;
    FXint arg2 ; FXint result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXListBox, 1); arg2 = NUM2INT(argv[0]);
    result = (FXint)FXListBox_getHeightForWidth(arg1,arg2); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXListBox_canFocus(int argc, VALUE *argv, VALUE self) { FXListBox *arg1 = (FXListBox *) 0 ; FXbool result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXListBox, 1);
    result = (FXbool)FXListBox_canFocus((FXListBox const *)arg1); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXListBox_setFocus(int argc, VALUE *argv, VALUE self) { FXListBox *arg1 = (FXListBox *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXListBox, 1); FXListBox_setFocus(arg1); return Qnil; }
static VALUE _wrap_FXListBox_killFocus(int argc, VALUE *argv, VALUE self) { FXListBox *arg1 = (FXListBox *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXListBox, 1); FXListBox_killFocus(arg1); return Qnil; }
static VALUE _wrap_FXListBox_setDefault(int argc, VALUE *argv, VALUE self) { FXListBox *arg1 = (FXListBox *) 0 ;
    FXbool arg2 = (FXbool) 1 ; if ((argc < 0) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXListBox, 1); if (argc > 0) { arg2 = to_FXbool(argv[0]); } 
    FXListBox_setDefault(arg1,arg2); return Qnil; }
static VALUE _wrap_FXListBox_enable(int argc, VALUE *argv, VALUE self) { FXListBox *arg1 = (FXListBox *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXListBox, 1); FXListBox_enable(arg1); return Qnil; }
static VALUE _wrap_FXListBox_disable(int argc, VALUE *argv, VALUE self) { FXListBox *arg1 = (FXListBox *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXListBox, 1); FXListBox_disable(arg1); return Qnil; }
static VALUE _wrap_FXListBox_raiseWindow(int argc, VALUE *argv, VALUE self) { FXListBox *arg1 = (FXListBox *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXListBox, 1); FXListBox_raise(arg1); return Qnil; }
static VALUE _wrap_FXListBox_lower(int argc, VALUE *argv, VALUE self) { FXListBox *arg1 = (FXListBox *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXListBox, 1); FXListBox_lower(arg1); return Qnil; }
static VALUE _wrap_FXListBox_move(int argc, VALUE *argv, VALUE self) { FXListBox *arg1 = (FXListBox *) 0 ; FXint arg2 ;
    FXint arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXListBox, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    FXListBox_move(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXListBox_position(int argc, VALUE *argv, VALUE self) { FXListBox *arg1 = (FXListBox *) 0 ; FXint arg2 ;
    FXint arg3 ; FXint arg4 ; FXint arg5 ; if ((argc < 4) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXListBox, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    arg4 = NUM2INT(argv[2]); arg5 = NUM2INT(argv[3]); FXListBox_position(arg1,arg2,arg3,arg4,arg5); return Qnil; }
static VALUE _wrap_FXListBox_layout(int argc, VALUE *argv, VALUE self) { FXListBox *arg1 = (FXListBox *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXListBox, 1); FXListBox_layout(arg1); return Qnil; }
static VALUE _wrap_FXListBox_recalc(int argc, VALUE *argv, VALUE self) { FXListBox *arg1 = (FXListBox *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXListBox, 1); FXListBox_recalc(arg1); return Qnil; }
static VALUE _wrap_FXListBox_reparent(int argc, VALUE *argv, VALUE self) { FXListBox *arg1 = (FXListBox *) 0 ;
    FXComposite *arg2 = (FXComposite *) 0 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXListBox, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXComposite, 1); FXListBox_reparent(arg1,arg2); return Qnil; }
static VALUE _wrap_FXListBox_show(int argc, VALUE *argv, VALUE self) { FXListBox *arg1 = (FXListBox *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXListBox, 1); FXListBox_show(arg1); return Qnil; }
static VALUE _wrap_FXListBox_hide(int argc, VALUE *argv, VALUE self) { FXListBox *arg1 = (FXListBox *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXListBox, 1); FXListBox_hide(arg1); return Qnil; }
static VALUE _wrap_FXListBox_isComposite(int argc, VALUE *argv, VALUE self) { FXListBox *arg1 = (FXListBox *) 0 ; FXbool result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXListBox, 1);
    result = (FXbool)FXListBox_isComposite((FXListBox const *)arg1); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXListBox_contains(int argc, VALUE *argv, VALUE self) { FXListBox *arg1 = (FXListBox *) 0 ; FXint arg2 ;
    FXint arg3 ; FXbool result; VALUE vresult = Qnil; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXListBox, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    result = (FXbool)FXListBox_contains((FXListBox const *)arg1,arg2,arg3); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXListBox_doesSaveUnder(int argc, VALUE *argv, VALUE self) { FXListBox *arg1 = (FXListBox *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXListBox, 1);
    result = (FXbool)FXListBox_doesSaveUnder((FXListBox const *)arg1); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXListBox_setBackColor(int argc, VALUE *argv, VALUE self) { FXListBox *arg1 = (FXListBox *) 0 ;
    FXColor arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXListBox, 1); arg2 = to_FXColor(argv[0]);
    FXListBox_setBackColor(arg1,arg2); return Qnil; }
static VALUE _wrap_FXTreeListBox_onFocusUp(int argc, VALUE *argv, VALUE self) { FXTreeListBox *arg1 = (FXTreeListBox *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTreeListBox, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onFocusUp(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTreeListBox_onFocusDown(int argc, VALUE *argv, VALUE self) { FXTreeListBox *arg1 = (FXTreeListBox *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTreeListBox, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onFocusDown(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTreeListBox_onFocusSelf(int argc, VALUE *argv, VALUE self) { FXTreeListBox *arg1 = (FXTreeListBox *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTreeListBox, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onFocusSelf(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTreeListBox_onChanged(int argc, VALUE *argv, VALUE self) { FXTreeListBox *arg1 = (FXTreeListBox *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTreeListBox, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]);
    SWIG_ConvertPtr(argv[2],&arg4,SWIGTYPE_p_FXTreeItem,1); result = (long)(arg1)->onChanged(arg2,arg3,arg4);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTreeListBox_onCommand(int argc, VALUE *argv, VALUE self) { FXTreeListBox *arg1 = (FXTreeListBox *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTreeListBox, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]);
    SWIG_ConvertPtr(argv[2],&arg4,SWIGTYPE_p_FXTreeItem,1); result = (long)(arg1)->onCommand(arg2,arg3,arg4);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTreeListBox_onFieldButton(int argc, VALUE *argv, VALUE self) { FXTreeListBox *arg1 = (FXTreeListBox *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTreeListBox, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onFieldButton(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTreeListBox_onTreeChanged(int argc, VALUE *argv, VALUE self) { FXTreeListBox *arg1 = (FXTreeListBox *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTreeListBox, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]);
    SWIG_ConvertPtr(argv[2],&arg4,SWIGTYPE_p_FXTreeItem,1); result = (long)(arg1)->onTreeChanged(arg2,arg3,arg4);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTreeListBox_onTreeClicked(int argc, VALUE *argv, VALUE self) { FXTreeListBox *arg1 = (FXTreeListBox *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTreeListBox, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]);
    SWIG_ConvertPtr(argv[2],&arg4,SWIGTYPE_p_FXTreeItem,1); result = (long)(arg1)->onTreeClicked(arg2,arg3,arg4);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTreeListBox_onUpdFmTree(int argc, VALUE *argv, VALUE self) { FXTreeListBox *arg1 = (FXTreeListBox *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTreeListBox, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onUpdFmTree(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE _wrap_FXTreeListBox_allocate(VALUE self) {
#else
     static VALUE _wrap_FXTreeListBox_allocate(int argc, VALUE *argv, VALUE self) {
#endif
         VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_FXTreeListBox);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
         return vresult; }
static VALUE _wrap_new_FXTreeListBox(int argc, VALUE *argv, VALUE self) { FXComposite *arg1 = (FXComposite *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 = (FXSelector) 0 ;
    FXuint arg4 = (FXuint) FRAME_SUNKEN|FRAME_THICK|TREELISTBOX_NORMAL ; FXint arg5 = (FXint) 0 ; FXint arg6 = (FXint) 0 ;
    FXint arg7 = (FXint) 0 ; FXint arg8 = (FXint) 0 ; FXint arg9 = (FXint) DEFAULT_PAD ; FXint arg10 = (FXint) DEFAULT_PAD ;
    FXint arg11 = (FXint) DEFAULT_PAD ; FXint arg12 = (FXint) DEFAULT_PAD ; FXTreeListBox *result;
    if ((argc < 1) || (argc > 12)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXComposite, 1); if (argc > 1) {
        SWIG_ConvertPtr(argv[1], (void **) &arg2, SWIGTYPE_p_FXObject, 1); }  if (argc > 2) { arg3 = NUM2UINT(argv[2]); } 
    if (argc > 3) { arg4 = NUM2UINT(argv[3]); }  if (argc > 4) { arg5 = NUM2INT(argv[4]); }  if (argc > 5) {
        arg6 = NUM2INT(argv[5]); }  if (argc > 6) { arg7 = NUM2INT(argv[6]); }  if (argc > 7) { arg8 = NUM2INT(argv[7]); } 
    if (argc > 8) { arg9 = NUM2INT(argv[8]); }  if (argc > 9) { arg10 = NUM2INT(argv[9]); }  if (argc > 10) {
        arg11 = NUM2INT(argv[10]); }  if (argc > 11) { arg12 = NUM2INT(argv[11]); }  {
        result = (FXTreeListBox *)new_FXTreeListBox(arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8,arg9,arg10,arg11,arg12);
        DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result); if(rb_block_given_p()){ rb_yield(self); }  }  return self; }
static VALUE _wrap_FXTreeListBox_getNumItems(int argc, VALUE *argv, VALUE self) { FXTreeListBox *arg1 = (FXTreeListBox *) 0 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTreeListBox, 1);
    result = (FXint)((FXTreeListBox const *)arg1)->getNumItems(); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTreeListBox_getNumVisible(int argc, VALUE *argv, VALUE self) { FXTreeListBox *arg1 = (FXTreeListBox *) 0 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTreeListBox, 1);
    result = (FXint)((FXTreeListBox const *)arg1)->getNumVisible(); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTreeListBox_setNumVisible(int argc, VALUE *argv, VALUE self) { FXTreeListBox *arg1 = (FXTreeListBox *) 0 ;
    FXint arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTreeListBox, 1); arg2 = NUM2INT(argv[0]); (arg1)->setNumVisible(arg2);
    return Qnil; }
static VALUE _wrap_FXTreeListBox_getFirstItem(int argc, VALUE *argv, VALUE self) { FXTreeListBox *arg1 = (FXTreeListBox *) 0 ;
    FXTreeItem *result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTreeListBox, 1);
    result = (FXTreeItem *)((FXTreeListBox const *)arg1)->getFirstItem(); {
        swig_type_info *ty = SWIG_TypeDynamicCast(SWIGTYPE_p_FXTreeItem, (void **) &result);
        vresult = FXRbGetRubyObj(result, ty); }  return vresult; }
static VALUE _wrap_FXTreeListBox_getLastItem(int argc, VALUE *argv, VALUE self) { FXTreeListBox *arg1 = (FXTreeListBox *) 0 ;
    FXTreeItem *result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTreeListBox, 1);
    result = (FXTreeItem *)((FXTreeListBox const *)arg1)->getLastItem(); {
        swig_type_info *ty = SWIG_TypeDynamicCast(SWIGTYPE_p_FXTreeItem, (void **) &result);
        vresult = FXRbGetRubyObj(result, ty); }  return vresult; }
static VALUE _wrap_FXTreeListBox_addItemFirst__SWIG_0(int argc, VALUE *argv, VALUE self) {
    FXTreeListBox *arg1 = (FXTreeListBox *) 0 ; FXTreeItem *arg2 = (FXTreeItem *) 0 ; FXTreeItem *arg3 = (FXTreeItem *) 0 ;
    FXTreeItem *result; VALUE vresult = Qnil; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTreeListBox, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXTreeItem, 1);
    SWIG_ConvertPtr(argv[1], (void **) &arg3, SWIGTYPE_p_FXTreeItem, 1);
    result = (FXTreeItem *)FXTreeListBox_addItemFirst__SWIG_0(arg1,arg2,arg3); {
        swig_type_info *ty = SWIG_TypeDynamicCast(SWIGTYPE_p_FXTreeItem, (void **) &result);
        vresult = FXRbGetRubyObj(result, ty); }  return vresult; }
static VALUE _wrap_FXTreeListBox_addItemLast__SWIG_0(int argc, VALUE *argv, VALUE self) {
    FXTreeListBox *arg1 = (FXTreeListBox *) 0 ; FXTreeItem *arg2 = (FXTreeItem *) 0 ; FXTreeItem *arg3 = (FXTreeItem *) 0 ;
    FXTreeItem *result; VALUE vresult = Qnil; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTreeListBox, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXTreeItem, 1);
    SWIG_ConvertPtr(argv[1], (void **) &arg3, SWIGTYPE_p_FXTreeItem, 1);
    result = (FXTreeItem *)FXTreeListBox_addItemLast__SWIG_0(arg1,arg2,arg3); {
        swig_type_info *ty = SWIG_TypeDynamicCast(SWIGTYPE_p_FXTreeItem, (void **) &result);
        vresult = FXRbGetRubyObj(result, ty); }  return vresult; }
static VALUE _wrap_FXTreeListBox_addItemAfter__SWIG_0(int argc, VALUE *argv, VALUE self) {
    FXTreeListBox *arg1 = (FXTreeListBox *) 0 ; FXTreeItem *arg2 = (FXTreeItem *) 0 ; FXTreeItem *arg3 = (FXTreeItem *) 0 ;
    FXTreeItem *result; VALUE vresult = Qnil; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTreeListBox, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXTreeItem, 1);
    SWIG_ConvertPtr(argv[1], (void **) &arg3, SWIGTYPE_p_FXTreeItem, 1);
    result = (FXTreeItem *)FXTreeListBox_addItemAfter__SWIG_0(arg1,arg2,arg3); {
        swig_type_info *ty = SWIG_TypeDynamicCast(SWIGTYPE_p_FXTreeItem, (void **) &result);
        vresult = FXRbGetRubyObj(result, ty); }  return vresult; }
static VALUE _wrap_FXTreeListBox_addItemBefore__SWIG_0(int argc, VALUE *argv, VALUE self) {
    FXTreeListBox *arg1 = (FXTreeListBox *) 0 ; FXTreeItem *arg2 = (FXTreeItem *) 0 ; FXTreeItem *arg3 = (FXTreeItem *) 0 ;
    FXTreeItem *result; VALUE vresult = Qnil; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTreeListBox, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXTreeItem, 1);
    SWIG_ConvertPtr(argv[1], (void **) &arg3, SWIGTYPE_p_FXTreeItem, 1);
    result = (FXTreeItem *)FXTreeListBox_addItemBefore__SWIG_0(arg1,arg2,arg3); {
        swig_type_info *ty = SWIG_TypeDynamicCast(SWIGTYPE_p_FXTreeItem, (void **) &result);
        vresult = FXRbGetRubyObj(result, ty); }  return vresult; }
static VALUE _wrap_FXTreeListBox_addItemFirst__SWIG_1(int argc, VALUE *argv, VALUE self) {
    FXTreeListBox *arg1 = (FXTreeListBox *) 0 ; FXTreeItem *arg2 = (FXTreeItem *) 0 ; FXString *arg3 = 0 ;
    FXIcon *arg4 = (FXIcon *) 0 ; FXIcon *arg5 = (FXIcon *) 0 ; void *arg6 = (void *) 0 ; FXTreeItem *result;
    SwigValueWrapper<FXString > p3 ; VALUE vresult = Qnil; if ((argc < 2) || (argc > 5))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTreeListBox, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXTreeItem, 1); p3 = to_FXString(argv[1]); arg3 = &p3; if (argc > 2) {
        SWIG_ConvertPtr(argv[2], (void **) &arg4, SWIGTYPE_p_FXIcon, 1); }  if (argc > 3) {
        SWIG_ConvertPtr(argv[3], (void **) &arg5, SWIGTYPE_p_FXIcon, 1); }  if (argc > 4) {
        arg6 = (argv[4] == Qnil) ? NULL : (void *) argv[4]; } 
    result = (FXTreeItem *)FXTreeListBox_addItemFirst__SWIG_1(arg1,arg2,(FXString const &)*arg3,arg4,arg5,arg6); {
        swig_type_info *ty = SWIG_TypeDynamicCast(SWIGTYPE_p_FXTreeItem, (void **) &result);
        vresult = FXRbGetRubyObj(result, ty); }  return vresult; }
static VALUE _wrap_FXTreeListBox_addItemFirst(int nargs, VALUE *args, VALUE self) { int argc; VALUE argv[7]; int ii;
    argc = nargs + 1; argv[0] = self; for (ii = 1; (ii < argc) && (ii < 6); ii++) { argv[ii] = args[ii-1]; }  if (argc == 3) {
        int _v; { void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXTreeListBox, 0) != -1)) ? 1 : 0; }
         if (_v) { { void *ptr;
                _v = (NIL_P(argv[1]) || (TYPE(argv[1]) == T_DATA && SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_FXTreeItem, 0) != -1)) ? 1 : 0; }
             if (_v) { { void *ptr;
                    _v = (NIL_P(argv[2]) || (TYPE(argv[2]) == T_DATA && SWIG_ConvertPtr(argv[2], &ptr, SWIGTYPE_p_FXTreeItem, 0) != -1)) ? 1 : 0; }
                 if (_v) { return _wrap_FXTreeListBox_addItemFirst__SWIG_0(nargs, args, self);}  }  }  } 
    if ((argc >= 3) && (argc <= 6)) { int _v; { void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXTreeListBox, 0) != -1)) ? 1 : 0; }
         if (_v) { { void *ptr;
                _v = (NIL_P(argv[1]) || (TYPE(argv[1]) == T_DATA && SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_FXTreeItem, 0) != -1)) ? 1 : 0; }
             if (_v) { { _v = (NIL_P(argv[2]) || TYPE(argv[2]) == T_STRING) ? 1 : 0; }  if (_v) { if (argc <= 3) {
                        return _wrap_FXTreeListBox_addItemFirst__SWIG_1(nargs, args, self);}  { void *ptr;
                        _v = (NIL_P(argv[3]) || (TYPE(argv[3]) == T_DATA && SWIG_ConvertPtr(argv[3], &ptr, SWIGTYPE_p_FXIcon, 0) != -1)) ? 1 : 0; }
                     if (_v) { if (argc <= 4) { return _wrap_FXTreeListBox_addItemFirst__SWIG_1(nargs, args, self);}  {
                            void *ptr;
                            _v = (NIL_P(argv[4]) || (TYPE(argv[4]) == T_DATA && SWIG_ConvertPtr(argv[4], &ptr, SWIGTYPE_p_FXIcon, 0) != -1)) ? 1 : 0; }
                         if (_v) { if (argc <= 5) { return _wrap_FXTreeListBox_addItemFirst__SWIG_1(nargs, args, self);}  {
                                _v = 1; }  if (_v) { return _wrap_FXTreeListBox_addItemFirst__SWIG_1(nargs, args, self);}  }  }
                     }  }  }  }  rb_raise(rb_eArgError, "No matching function for overloaded 'FXTreeListBox_addItemFirst'");
    return Qnil; }
static VALUE _wrap_FXTreeListBox_addItemLast__SWIG_1(int argc, VALUE *argv, VALUE self) {
    FXTreeListBox *arg1 = (FXTreeListBox *) 0 ; FXTreeItem *arg2 = (FXTreeItem *) 0 ; FXString *arg3 = 0 ;
    FXIcon *arg4 = (FXIcon *) 0 ; FXIcon *arg5 = (FXIcon *) 0 ; void *arg6 = (void *) 0 ; FXTreeItem *result;
    SwigValueWrapper<FXString > p3 ; VALUE vresult = Qnil; if ((argc < 2) || (argc > 5))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTreeListBox, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXTreeItem, 1); p3 = to_FXString(argv[1]); arg3 = &p3; if (argc > 2) {
        SWIG_ConvertPtr(argv[2], (void **) &arg4, SWIGTYPE_p_FXIcon, 1); }  if (argc > 3) {
        SWIG_ConvertPtr(argv[3], (void **) &arg5, SWIGTYPE_p_FXIcon, 1); }  if (argc > 4) {
        arg6 = (argv[4] == Qnil) ? NULL : (void *) argv[4]; } 
    result = (FXTreeItem *)FXTreeListBox_addItemLast__SWIG_1(arg1,arg2,(FXString const &)*arg3,arg4,arg5,arg6); {
        swig_type_info *ty = SWIG_TypeDynamicCast(SWIGTYPE_p_FXTreeItem, (void **) &result);
        vresult = FXRbGetRubyObj(result, ty); }  return vresult; }
static VALUE _wrap_FXTreeListBox_addItemLast(int nargs, VALUE *args, VALUE self) { int argc; VALUE argv[7]; int ii;
    argc = nargs + 1; argv[0] = self; for (ii = 1; (ii < argc) && (ii < 6); ii++) { argv[ii] = args[ii-1]; }  if (argc == 3) {
        int _v; { void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXTreeListBox, 0) != -1)) ? 1 : 0; }
         if (_v) { { void *ptr;
                _v = (NIL_P(argv[1]) || (TYPE(argv[1]) == T_DATA && SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_FXTreeItem, 0) != -1)) ? 1 : 0; }
             if (_v) { { void *ptr;
                    _v = (NIL_P(argv[2]) || (TYPE(argv[2]) == T_DATA && SWIG_ConvertPtr(argv[2], &ptr, SWIGTYPE_p_FXTreeItem, 0) != -1)) ? 1 : 0; }
                 if (_v) { return _wrap_FXTreeListBox_addItemLast__SWIG_0(nargs, args, self);}  }  }  } 
    if ((argc >= 3) && (argc <= 6)) { int _v; { void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXTreeListBox, 0) != -1)) ? 1 : 0; }
         if (_v) { { void *ptr;
                _v = (NIL_P(argv[1]) || (TYPE(argv[1]) == T_DATA && SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_FXTreeItem, 0) != -1)) ? 1 : 0; }
             if (_v) { { _v = (NIL_P(argv[2]) || TYPE(argv[2]) == T_STRING) ? 1 : 0; }  if (_v) { if (argc <= 3) {
                        return _wrap_FXTreeListBox_addItemLast__SWIG_1(nargs, args, self);}  { void *ptr;
                        _v = (NIL_P(argv[3]) || (TYPE(argv[3]) == T_DATA && SWIG_ConvertPtr(argv[3], &ptr, SWIGTYPE_p_FXIcon, 0) != -1)) ? 1 : 0; }
                     if (_v) { if (argc <= 4) { return _wrap_FXTreeListBox_addItemLast__SWIG_1(nargs, args, self);}  {
                            void *ptr;
                            _v = (NIL_P(argv[4]) || (TYPE(argv[4]) == T_DATA && SWIG_ConvertPtr(argv[4], &ptr, SWIGTYPE_p_FXIcon, 0) != -1)) ? 1 : 0; }
                         if (_v) { if (argc <= 5) { return _wrap_FXTreeListBox_addItemLast__SWIG_1(nargs, args, self);}  {
                                _v = 1; }  if (_v) { return _wrap_FXTreeListBox_addItemLast__SWIG_1(nargs, args, self);}  }  }  }
                 }  }  }  rb_raise(rb_eArgError, "No matching function for overloaded 'FXTreeListBox_addItemLast'");
    return Qnil; }
static VALUE _wrap_FXTreeListBox_addItemAfter__SWIG_1(int argc, VALUE *argv, VALUE self) {
    FXTreeListBox *arg1 = (FXTreeListBox *) 0 ; FXTreeItem *arg2 = (FXTreeItem *) 0 ; FXString *arg3 = 0 ;
    FXIcon *arg4 = (FXIcon *) 0 ; FXIcon *arg5 = (FXIcon *) 0 ; void *arg6 = (void *) 0 ; FXTreeItem *result;
    SwigValueWrapper<FXString > p3 ; VALUE vresult = Qnil; if ((argc < 2) || (argc > 5))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTreeListBox, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXTreeItem, 1); p3 = to_FXString(argv[1]); arg3 = &p3; if (argc > 2) {
        SWIG_ConvertPtr(argv[2], (void **) &arg4, SWIGTYPE_p_FXIcon, 1); }  if (argc > 3) {
        SWIG_ConvertPtr(argv[3], (void **) &arg5, SWIGTYPE_p_FXIcon, 1); }  if (argc > 4) {
        arg6 = (argv[4] == Qnil) ? NULL : (void *) argv[4]; } 
    result = (FXTreeItem *)FXTreeListBox_addItemAfter__SWIG_1(arg1,arg2,(FXString const &)*arg3,arg4,arg5,arg6); {
        swig_type_info *ty = SWIG_TypeDynamicCast(SWIGTYPE_p_FXTreeItem, (void **) &result);
        vresult = FXRbGetRubyObj(result, ty); }  return vresult; }
static VALUE _wrap_FXTreeListBox_addItemAfter(int nargs, VALUE *args, VALUE self) { int argc; VALUE argv[7]; int ii;
    argc = nargs + 1; argv[0] = self; for (ii = 1; (ii < argc) && (ii < 6); ii++) { argv[ii] = args[ii-1]; }  if (argc == 3) {
        int _v; { void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXTreeListBox, 0) != -1)) ? 1 : 0; }
         if (_v) { { void *ptr;
                _v = (NIL_P(argv[1]) || (TYPE(argv[1]) == T_DATA && SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_FXTreeItem, 0) != -1)) ? 1 : 0; }
             if (_v) { { void *ptr;
                    _v = (NIL_P(argv[2]) || (TYPE(argv[2]) == T_DATA && SWIG_ConvertPtr(argv[2], &ptr, SWIGTYPE_p_FXTreeItem, 0) != -1)) ? 1 : 0; }
                 if (_v) { return _wrap_FXTreeListBox_addItemAfter__SWIG_0(nargs, args, self);}  }  }  } 
    if ((argc >= 3) && (argc <= 6)) { int _v; { void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXTreeListBox, 0) != -1)) ? 1 : 0; }
         if (_v) { { void *ptr;
                _v = (NIL_P(argv[1]) || (TYPE(argv[1]) == T_DATA && SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_FXTreeItem, 0) != -1)) ? 1 : 0; }
             if (_v) { { _v = (NIL_P(argv[2]) || TYPE(argv[2]) == T_STRING) ? 1 : 0; }  if (_v) { if (argc <= 3) {
                        return _wrap_FXTreeListBox_addItemAfter__SWIG_1(nargs, args, self);}  { void *ptr;
                        _v = (NIL_P(argv[3]) || (TYPE(argv[3]) == T_DATA && SWIG_ConvertPtr(argv[3], &ptr, SWIGTYPE_p_FXIcon, 0) != -1)) ? 1 : 0; }
                     if (_v) { if (argc <= 4) { return _wrap_FXTreeListBox_addItemAfter__SWIG_1(nargs, args, self);}  {
                            void *ptr;
                            _v = (NIL_P(argv[4]) || (TYPE(argv[4]) == T_DATA && SWIG_ConvertPtr(argv[4], &ptr, SWIGTYPE_p_FXIcon, 0) != -1)) ? 1 : 0; }
                         if (_v) { if (argc <= 5) { return _wrap_FXTreeListBox_addItemAfter__SWIG_1(nargs, args, self);}  {
                                _v = 1; }  if (_v) { return _wrap_FXTreeListBox_addItemAfter__SWIG_1(nargs, args, self);}  }  }
                     }  }  }  }  rb_raise(rb_eArgError, "No matching function for overloaded 'FXTreeListBox_addItemAfter'");
    return Qnil; }
static VALUE _wrap_FXTreeListBox_addItemBefore__SWIG_1(int argc, VALUE *argv, VALUE self) {
    FXTreeListBox *arg1 = (FXTreeListBox *) 0 ; FXTreeItem *arg2 = (FXTreeItem *) 0 ; FXString *arg3 = 0 ;
    FXIcon *arg4 = (FXIcon *) 0 ; FXIcon *arg5 = (FXIcon *) 0 ; void *arg6 = (void *) 0 ; FXTreeItem *result;
    SwigValueWrapper<FXString > p3 ; VALUE vresult = Qnil; if ((argc < 2) || (argc > 5))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTreeListBox, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXTreeItem, 1); p3 = to_FXString(argv[1]); arg3 = &p3; if (argc > 2) {
        SWIG_ConvertPtr(argv[2], (void **) &arg4, SWIGTYPE_p_FXIcon, 1); }  if (argc > 3) {
        SWIG_ConvertPtr(argv[3], (void **) &arg5, SWIGTYPE_p_FXIcon, 1); }  if (argc > 4) {
        arg6 = (argv[4] == Qnil) ? NULL : (void *) argv[4]; } 
    result = (FXTreeItem *)FXTreeListBox_addItemBefore__SWIG_1(arg1,arg2,(FXString const &)*arg3,arg4,arg5,arg6); {
        swig_type_info *ty = SWIG_TypeDynamicCast(SWIGTYPE_p_FXTreeItem, (void **) &result);
        vresult = FXRbGetRubyObj(result, ty); }  return vresult; }
static VALUE _wrap_FXTreeListBox_addItemBefore(int nargs, VALUE *args, VALUE self) { int argc; VALUE argv[7]; int ii;
    argc = nargs + 1; argv[0] = self; for (ii = 1; (ii < argc) && (ii < 6); ii++) { argv[ii] = args[ii-1]; }  if (argc == 3) {
        int _v; { void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXTreeListBox, 0) != -1)) ? 1 : 0; }
         if (_v) { { void *ptr;
                _v = (NIL_P(argv[1]) || (TYPE(argv[1]) == T_DATA && SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_FXTreeItem, 0) != -1)) ? 1 : 0; }
             if (_v) { { void *ptr;
                    _v = (NIL_P(argv[2]) || (TYPE(argv[2]) == T_DATA && SWIG_ConvertPtr(argv[2], &ptr, SWIGTYPE_p_FXTreeItem, 0) != -1)) ? 1 : 0; }
                 if (_v) { return _wrap_FXTreeListBox_addItemBefore__SWIG_0(nargs, args, self);}  }  }  } 
    if ((argc >= 3) && (argc <= 6)) { int _v; { void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXTreeListBox, 0) != -1)) ? 1 : 0; }
         if (_v) { { void *ptr;
                _v = (NIL_P(argv[1]) || (TYPE(argv[1]) == T_DATA && SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_FXTreeItem, 0) != -1)) ? 1 : 0; }
             if (_v) { { _v = (NIL_P(argv[2]) || TYPE(argv[2]) == T_STRING) ? 1 : 0; }  if (_v) { if (argc <= 3) {
                        return _wrap_FXTreeListBox_addItemBefore__SWIG_1(nargs, args, self);}  { void *ptr;
                        _v = (NIL_P(argv[3]) || (TYPE(argv[3]) == T_DATA && SWIG_ConvertPtr(argv[3], &ptr, SWIGTYPE_p_FXIcon, 0) != -1)) ? 1 : 0; }
                     if (_v) { if (argc <= 4) { return _wrap_FXTreeListBox_addItemBefore__SWIG_1(nargs, args, self);}  {
                            void *ptr;
                            _v = (NIL_P(argv[4]) || (TYPE(argv[4]) == T_DATA && SWIG_ConvertPtr(argv[4], &ptr, SWIGTYPE_p_FXIcon, 0) != -1)) ? 1 : 0; }
                         if (_v) { if (argc <= 5) { return _wrap_FXTreeListBox_addItemBefore__SWIG_1(nargs, args, self);}  {
                                _v = 1; }  if (_v) { return _wrap_FXTreeListBox_addItemBefore__SWIG_1(nargs, args, self);}  }  }
                     }  }  }  }  rb_raise(rb_eArgError, "No matching function for overloaded 'FXTreeListBox_addItemBefore'");
    return Qnil; }
static VALUE _wrap_FXTreeListBox_removeItem(int argc, VALUE *argv, VALUE self) { FXTreeListBox *arg1 = (FXTreeListBox *) 0 ;
    FXTreeItem *arg2 = (FXTreeItem *) 0 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTreeListBox, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXTreeItem, 1); FXTreeListBox_removeItem(arg1,arg2); return Qnil; }
static VALUE _wrap_FXTreeListBox_removeItems(int argc, VALUE *argv, VALUE self) { FXTreeListBox *arg1 = (FXTreeListBox *) 0 ;
    FXTreeItem *arg2 = (FXTreeItem *) 0 ; FXTreeItem *arg3 = (FXTreeItem *) 0 ; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTreeListBox, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXTreeItem, 1);
    SWIG_ConvertPtr(argv[1], (void **) &arg3, SWIGTYPE_p_FXTreeItem, 1); FXTreeListBox_removeItems(arg1,arg2,arg3);
    return Qnil; }
static VALUE _wrap_FXTreeListBox_clearItems(int argc, VALUE *argv, VALUE self) { FXTreeListBox *arg1 = (FXTreeListBox *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTreeListBox, 1); FXTreeListBox_clearItems(arg1); return Qnil; }
static VALUE _wrap_FXTreeListBox_findItem(int argc, VALUE *argv, VALUE self) { FXTreeListBox *arg1 = (FXTreeListBox *) 0 ;
    FXString *arg2 = 0 ; FXTreeItem *arg3 = (FXTreeItem *) 0 ; FXuint arg4 = (FXuint) SEARCH_FORWARD|SEARCH_WRAP ;
    FXTreeItem *result; SwigValueWrapper<FXString > p2 ; VALUE vresult = Qnil; if ((argc < 1) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTreeListBox, 1); p2 = to_FXString(argv[0]); arg2 = &p2; if (argc > 1) {
        SWIG_ConvertPtr(argv[1], (void **) &arg3, SWIGTYPE_p_FXTreeItem, 1); }  if (argc > 2) { arg4 = NUM2UINT(argv[2]); } 
    result = (FXTreeItem *)((FXTreeListBox const *)arg1)->findItem((FXString const &)*arg2,arg3,arg4); {
        swig_type_info *ty = SWIG_TypeDynamicCast(SWIGTYPE_p_FXTreeItem, (void **) &result);
        vresult = FXRbGetRubyObj(result, ty); }  return vresult; }
static VALUE _wrap_FXTreeListBox_isItemCurrent(int argc, VALUE *argv, VALUE self) { FXTreeListBox *arg1 = (FXTreeListBox *) 0 ;
    FXTreeItem *arg2 = (FXTreeItem *) 0 ; FXbool result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTreeListBox, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXTreeItem, 1);
    result = (FXbool)((FXTreeListBox const *)arg1)->isItemCurrent((FXTreeItem const *)arg2); vresult = result ? Qtrue : Qfalse;
    return vresult; }
static VALUE _wrap_FXTreeListBox_isItemLeaf(int argc, VALUE *argv, VALUE self) { FXTreeListBox *arg1 = (FXTreeListBox *) 0 ;
    FXTreeItem *arg2 = (FXTreeItem *) 0 ; FXbool result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTreeListBox, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXTreeItem, 1);
    result = (FXbool)((FXTreeListBox const *)arg1)->isItemLeaf((FXTreeItem const *)arg2); vresult = result ? Qtrue : Qfalse;
    return vresult; }
static VALUE _wrap_FXTreeListBox_sortRootItems(int argc, VALUE *argv, VALUE self) { FXTreeListBox *arg1 = (FXTreeListBox *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTreeListBox, 1); (arg1)->sortRootItems(); return Qnil; }
static VALUE _wrap_FXTreeListBox_sortItems(int argc, VALUE *argv, VALUE self) { FXTreeListBox *arg1 = (FXTreeListBox *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTreeListBox, 1); (arg1)->sortItems(); return Qnil; }
static VALUE _wrap_FXTreeListBox_sortChildItems(int argc, VALUE *argv, VALUE self) { FXTreeListBox *arg1 = (FXTreeListBox *) 0 ;
    FXTreeItem *arg2 = (FXTreeItem *) 0 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTreeListBox, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXTreeItem, 1); (arg1)->sortChildItems(arg2); return Qnil; }
static VALUE _wrap_FXTreeListBox_setCurrentItem(int argc, VALUE *argv, VALUE self) { FXTreeListBox *arg1 = (FXTreeListBox *) 0 ;
    FXTreeItem *arg2 = (FXTreeItem *) 0 ; FXbool arg3 = (FXbool) 0 ; if ((argc < 1) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTreeListBox, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXTreeItem, 1); if (argc > 1) { arg3 = to_FXbool(argv[1]); } 
    (arg1)->setCurrentItem(arg2,arg3); return Qnil; }
static VALUE _wrap_FXTreeListBox_getCurrentItem(int argc, VALUE *argv, VALUE self) { FXTreeListBox *arg1 = (FXTreeListBox *) 0 ;
    FXTreeItem *result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTreeListBox, 1);
    result = (FXTreeItem *)((FXTreeListBox const *)arg1)->getCurrentItem(); {
        swig_type_info *ty = SWIG_TypeDynamicCast(SWIGTYPE_p_FXTreeItem, (void **) &result);
        vresult = FXRbGetRubyObj(result, ty); }  return vresult; }
static VALUE _wrap_FXTreeListBox_setItemText(int argc, VALUE *argv, VALUE self) { FXTreeListBox *arg1 = (FXTreeListBox *) 0 ;
    FXTreeItem *arg2 = (FXTreeItem *) 0 ; FXString *arg3 = 0 ; SwigValueWrapper<FXString > p3 ; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTreeListBox, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXTreeItem, 1); p3 = to_FXString(argv[1]); arg3 = &p3;
    (arg1)->setItemText(arg2,(FXString const &)*arg3); return Qnil; }
static VALUE _wrap_FXTreeListBox_getItemText(int argc, VALUE *argv, VALUE self) { FXTreeListBox *arg1 = (FXTreeListBox *) 0 ;
    FXTreeItem *arg2 = (FXTreeItem *) 0 ; FXString result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTreeListBox, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXTreeItem, 1);
    result = ((FXTreeListBox const *)arg1)->getItemText((FXTreeItem const *)arg2); vresult = rb_str_new2((&result)->text());
    return vresult; }
static VALUE _wrap_FXTreeListBox_setItemOpenIcon(int argc, VALUE *argv, VALUE self) {
    FXTreeListBox *arg1 = (FXTreeListBox *) 0 ; FXTreeItem *arg2 = (FXTreeItem *) 0 ; FXIcon *arg3 = (FXIcon *) 0 ;
    if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTreeListBox, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXTreeItem, 1);
    SWIG_ConvertPtr(argv[1], (void **) &arg3, SWIGTYPE_p_FXIcon, 1); (arg1)->setItemOpenIcon(arg2,arg3); return Qnil; }
static VALUE _wrap_FXTreeListBox_getItemOpenIcon(int argc, VALUE *argv, VALUE self) {
    FXTreeListBox *arg1 = (FXTreeListBox *) 0 ; FXTreeItem *arg2 = (FXTreeItem *) 0 ; FXIcon *result; VALUE vresult = Qnil;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTreeListBox, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXTreeItem, 1);
    result = (FXIcon *)((FXTreeListBox const *)arg1)->getItemOpenIcon((FXTreeItem const *)arg2); {
        swig_type_info *ty = SWIG_TypeDynamicCast(SWIGTYPE_p_FXIcon, (void **) &result); vresult = FXRbGetRubyObj(result, ty); }
     return vresult; }
static VALUE _wrap_FXTreeListBox_setItemClosedIcon(int argc, VALUE *argv, VALUE self) {
    FXTreeListBox *arg1 = (FXTreeListBox *) 0 ; FXTreeItem *arg2 = (FXTreeItem *) 0 ; FXIcon *arg3 = (FXIcon *) 0 ;
    if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTreeListBox, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXTreeItem, 1);
    SWIG_ConvertPtr(argv[1], (void **) &arg3, SWIGTYPE_p_FXIcon, 1); (arg1)->setItemClosedIcon(arg2,arg3); return Qnil; }
static VALUE _wrap_FXTreeListBox_getItemClosedIcon(int argc, VALUE *argv, VALUE self) {
    FXTreeListBox *arg1 = (FXTreeListBox *) 0 ; FXTreeItem *arg2 = (FXTreeItem *) 0 ; FXIcon *result; VALUE vresult = Qnil;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTreeListBox, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXTreeItem, 1);
    result = (FXIcon *)((FXTreeListBox const *)arg1)->getItemClosedIcon((FXTreeItem const *)arg2); {
        swig_type_info *ty = SWIG_TypeDynamicCast(SWIGTYPE_p_FXIcon, (void **) &result); vresult = FXRbGetRubyObj(result, ty); }
     return vresult; }
static VALUE _wrap_FXTreeListBox_setItemData(int argc, VALUE *argv, VALUE self) { FXTreeListBox *arg1 = (FXTreeListBox *) 0 ;
    FXTreeItem *arg2 = (FXTreeItem *) 0 ; VALUE arg3 ; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTreeListBox, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXTreeItem, 1); arg3 = argv[1];
    FXTreeListBox_setItemData(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXTreeListBox_getItemData(int argc, VALUE *argv, VALUE self) { FXTreeListBox *arg1 = (FXTreeListBox *) 0 ;
    FXTreeItem *arg2 = (FXTreeItem *) 0 ; VALUE result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTreeListBox, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXTreeItem, 1);
    result = (VALUE)FXTreeListBox_getItemData((FXTreeListBox const *)arg1,(FXTreeItem const *)arg2); vresult = result;
    return vresult; }
static VALUE _wrap_FXTreeListBox_isPaneShown(int argc, VALUE *argv, VALUE self) { FXTreeListBox *arg1 = (FXTreeListBox *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTreeListBox, 1);
    result = (FXbool)((FXTreeListBox const *)arg1)->isPaneShown(); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXTreeListBox_setFont(int argc, VALUE *argv, VALUE self) { FXTreeListBox *arg1 = (FXTreeListBox *) 0 ;
    FXFont *arg2 = (FXFont *) 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTreeListBox, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXFont, 1); (arg1)->setFont(arg2); return Qnil; }
static VALUE _wrap_FXTreeListBox_getFont(int argc, VALUE *argv, VALUE self) { FXTreeListBox *arg1 = (FXTreeListBox *) 0 ;
    FXFont *result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTreeListBox, 1);
    result = (FXFont *)((FXTreeListBox const *)arg1)->getFont(); {
        swig_type_info *ty = SWIG_TypeDynamicCast(SWIGTYPE_p_FXFont, (void **) &result); vresult = FXRbGetRubyObj(result, ty); }
     return vresult; }
static VALUE _wrap_FXTreeListBox_getListStyle(int argc, VALUE *argv, VALUE self) { FXTreeListBox *arg1 = (FXTreeListBox *) 0 ;
    FXuint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTreeListBox, 1);
    result = (FXuint)((FXTreeListBox const *)arg1)->getListStyle(); vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXTreeListBox_setListStyle(int argc, VALUE *argv, VALUE self) { FXTreeListBox *arg1 = (FXTreeListBox *) 0 ;
    FXuint arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTreeListBox, 1); arg2 = NUM2UINT(argv[0]); (arg1)->setListStyle(arg2);
    return Qnil; }
static VALUE _wrap_FXTreeListBox_setHelpText(int argc, VALUE *argv, VALUE self) { FXTreeListBox *arg1 = (FXTreeListBox *) 0 ;
    FXString *arg2 = 0 ; SwigValueWrapper<FXString > p2 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTreeListBox, 1); p2 = to_FXString(argv[0]); arg2 = &p2;
    (arg1)->setHelpText((FXString const &)*arg2); return Qnil; }
static VALUE _wrap_FXTreeListBox_getHelpText(int argc, VALUE *argv, VALUE self) { FXTreeListBox *arg1 = (FXTreeListBox *) 0 ;
    FXString result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTreeListBox, 1); result = ((FXTreeListBox const *)arg1)->getHelpText();
    vresult = rb_str_new2((&result)->text()); return vresult; }
static VALUE _wrap_FXTreeListBox_setTipText(int argc, VALUE *argv, VALUE self) { FXTreeListBox *arg1 = (FXTreeListBox *) 0 ;
    FXString *arg2 = 0 ; SwigValueWrapper<FXString > p2 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTreeListBox, 1); p2 = to_FXString(argv[0]); arg2 = &p2;
    (arg1)->setTipText((FXString const &)*arg2); return Qnil; }
static VALUE _wrap_FXTreeListBox_getTipText(int argc, VALUE *argv, VALUE self) { FXTreeListBox *arg1 = (FXTreeListBox *) 0 ;
    FXString result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTreeListBox, 1); result = ((FXTreeListBox const *)arg1)->getTipText();
    vresult = rb_str_new2((&result)->text()); return vresult; }
static void
free_FXTreeListBox(FXTreeListBox *arg1) {
    delete arg1;
}
static VALUE _wrap_FXTreeListBox_save(int argc, VALUE *argv, VALUE self) { FXTreeListBox *arg1 = (FXTreeListBox *) 0 ;
    FXStream *arg2 = 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTreeListBox, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXTreeListBox_save((FXTreeListBox const *)arg1,*arg2); return Qnil; }
static VALUE _wrap_FXTreeListBox_load(int argc, VALUE *argv, VALUE self) { FXTreeListBox *arg1 = (FXTreeListBox *) 0 ;
    FXStream *arg2 = 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTreeListBox, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXTreeListBox_load(arg1,*arg2); return Qnil; }
static VALUE _wrap_FXTreeListBox_create(int argc, VALUE *argv, VALUE self) { FXTreeListBox *arg1 = (FXTreeListBox *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTreeListBox, 1); FXTreeListBox_create(arg1); return Qnil; }
static VALUE _wrap_FXTreeListBox_detach(int argc, VALUE *argv, VALUE self) { FXTreeListBox *arg1 = (FXTreeListBox *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTreeListBox, 1); FXTreeListBox_detach(arg1); return Qnil; }
static VALUE _wrap_FXTreeListBox_destroy(int argc, VALUE *argv, VALUE self) { FXTreeListBox *arg1 = (FXTreeListBox *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTreeListBox, 1); FXTreeListBox_destroy(arg1); return Qnil; }
static VALUE _wrap_FXTreeListBox_resize(int argc, VALUE *argv, VALUE self) { FXTreeListBox *arg1 = (FXTreeListBox *) 0 ;
    FXint arg2 ; FXint arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTreeListBox, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    FXTreeListBox_resize(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXTreeListBox_getDefaultWidth(int argc, VALUE *argv, VALUE self) {
    FXTreeListBox *arg1 = (FXTreeListBox *) 0 ; FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTreeListBox, 1); result = (FXint)FXTreeListBox_getDefaultWidth(arg1);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTreeListBox_getDefaultHeight(int argc, VALUE *argv, VALUE self) {
    FXTreeListBox *arg1 = (FXTreeListBox *) 0 ; FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTreeListBox, 1); result = (FXint)FXTreeListBox_getDefaultHeight(arg1);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTreeListBox_getWidthForHeight(int argc, VALUE *argv, VALUE self) {
    FXTreeListBox *arg1 = (FXTreeListBox *) 0 ; FXint arg2 ; FXint result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTreeListBox, 1); arg2 = NUM2INT(argv[0]);
    result = (FXint)FXTreeListBox_getWidthForHeight(arg1,arg2); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTreeListBox_getHeightForWidth(int argc, VALUE *argv, VALUE self) {
    FXTreeListBox *arg1 = (FXTreeListBox *) 0 ; FXint arg2 ; FXint result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTreeListBox, 1); arg2 = NUM2INT(argv[0]);
    result = (FXint)FXTreeListBox_getHeightForWidth(arg1,arg2); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTreeListBox_canFocus(int argc, VALUE *argv, VALUE self) { FXTreeListBox *arg1 = (FXTreeListBox *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTreeListBox, 1);
    result = (FXbool)FXTreeListBox_canFocus((FXTreeListBox const *)arg1); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXTreeListBox_setFocus(int argc, VALUE *argv, VALUE self) { FXTreeListBox *arg1 = (FXTreeListBox *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTreeListBox, 1); FXTreeListBox_setFocus(arg1); return Qnil; }
static VALUE _wrap_FXTreeListBox_killFocus(int argc, VALUE *argv, VALUE self) { FXTreeListBox *arg1 = (FXTreeListBox *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTreeListBox, 1); FXTreeListBox_killFocus(arg1); return Qnil; }
static VALUE _wrap_FXTreeListBox_setDefault(int argc, VALUE *argv, VALUE self) { FXTreeListBox *arg1 = (FXTreeListBox *) 0 ;
    FXbool arg2 = (FXbool) 1 ; if ((argc < 0) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTreeListBox, 1); if (argc > 0) { arg2 = to_FXbool(argv[0]); } 
    FXTreeListBox_setDefault(arg1,arg2); return Qnil; }
static VALUE _wrap_FXTreeListBox_enable(int argc, VALUE *argv, VALUE self) { FXTreeListBox *arg1 = (FXTreeListBox *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTreeListBox, 1); FXTreeListBox_enable(arg1); return Qnil; }
static VALUE _wrap_FXTreeListBox_disable(int argc, VALUE *argv, VALUE self) { FXTreeListBox *arg1 = (FXTreeListBox *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTreeListBox, 1); FXTreeListBox_disable(arg1); return Qnil; }
static VALUE _wrap_FXTreeListBox_raiseWindow(int argc, VALUE *argv, VALUE self) { FXTreeListBox *arg1 = (FXTreeListBox *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTreeListBox, 1); FXTreeListBox_raise(arg1); return Qnil; }
static VALUE _wrap_FXTreeListBox_lower(int argc, VALUE *argv, VALUE self) { FXTreeListBox *arg1 = (FXTreeListBox *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTreeListBox, 1); FXTreeListBox_lower(arg1); return Qnil; }
static VALUE _wrap_FXTreeListBox_move(int argc, VALUE *argv, VALUE self) { FXTreeListBox *arg1 = (FXTreeListBox *) 0 ;
    FXint arg2 ; FXint arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTreeListBox, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    FXTreeListBox_move(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXTreeListBox_position(int argc, VALUE *argv, VALUE self) { FXTreeListBox *arg1 = (FXTreeListBox *) 0 ;
    FXint arg2 ; FXint arg3 ; FXint arg4 ; FXint arg5 ; if ((argc < 4) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTreeListBox, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    arg4 = NUM2INT(argv[2]); arg5 = NUM2INT(argv[3]); FXTreeListBox_position(arg1,arg2,arg3,arg4,arg5); return Qnil; }
static VALUE _wrap_FXTreeListBox_layout(int argc, VALUE *argv, VALUE self) { FXTreeListBox *arg1 = (FXTreeListBox *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTreeListBox, 1); FXTreeListBox_layout(arg1); return Qnil; }
static VALUE _wrap_FXTreeListBox_recalc(int argc, VALUE *argv, VALUE self) { FXTreeListBox *arg1 = (FXTreeListBox *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTreeListBox, 1); FXTreeListBox_recalc(arg1); return Qnil; }
static VALUE _wrap_FXTreeListBox_reparent(int argc, VALUE *argv, VALUE self) { FXTreeListBox *arg1 = (FXTreeListBox *) 0 ;
    FXComposite *arg2 = (FXComposite *) 0 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTreeListBox, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXComposite, 1); FXTreeListBox_reparent(arg1,arg2); return Qnil; }
static VALUE _wrap_FXTreeListBox_show(int argc, VALUE *argv, VALUE self) { FXTreeListBox *arg1 = (FXTreeListBox *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTreeListBox, 1); FXTreeListBox_show(arg1); return Qnil; }
static VALUE _wrap_FXTreeListBox_hide(int argc, VALUE *argv, VALUE self) { FXTreeListBox *arg1 = (FXTreeListBox *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTreeListBox, 1); FXTreeListBox_hide(arg1); return Qnil; }
static VALUE _wrap_FXTreeListBox_isComposite(int argc, VALUE *argv, VALUE self) { FXTreeListBox *arg1 = (FXTreeListBox *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTreeListBox, 1);
    result = (FXbool)FXTreeListBox_isComposite((FXTreeListBox const *)arg1); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXTreeListBox_contains(int argc, VALUE *argv, VALUE self) { FXTreeListBox *arg1 = (FXTreeListBox *) 0 ;
    FXint arg2 ; FXint arg3 ; FXbool result; VALUE vresult = Qnil; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTreeListBox, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    result = (FXbool)FXTreeListBox_contains((FXTreeListBox const *)arg1,arg2,arg3); vresult = result ? Qtrue : Qfalse;
    return vresult; }
static VALUE _wrap_FXTreeListBox_doesSaveUnder(int argc, VALUE *argv, VALUE self) { FXTreeListBox *arg1 = (FXTreeListBox *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTreeListBox, 1);
    result = (FXbool)FXTreeListBox_doesSaveUnder((FXTreeListBox const *)arg1); vresult = result ? Qtrue : Qfalse;
    return vresult; }
static VALUE _wrap_FXTreeListBox_setBackColor(int argc, VALUE *argv, VALUE self) { FXTreeListBox *arg1 = (FXTreeListBox *) 0 ;
    FXColor arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTreeListBox, 1); arg2 = to_FXColor(argv[0]);
    FXTreeListBox_setBackColor(arg1,arg2); return Qnil; }
static VALUE _wrap_FXImageView_onPaint(int argc, VALUE *argv, VALUE self) { FXImageView *arg1 = (FXImageView *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXImageView, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onPaint(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXImageView_onMotion(int argc, VALUE *argv, VALUE self) { FXImageView *arg1 = (FXImageView *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXImageView, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onMotion(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXImageView_onRightBtnPress(int argc, VALUE *argv, VALUE self) { FXImageView *arg1 = (FXImageView *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXImageView, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onRightBtnPress(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXImageView_onRightBtnRelease(int argc, VALUE *argv, VALUE self) { FXImageView *arg1 = (FXImageView *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXImageView, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onRightBtnRelease(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE _wrap_FXImageView_allocate(VALUE self) {
#else
     static VALUE _wrap_FXImageView_allocate(int argc, VALUE *argv, VALUE self) {
#endif
         VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_FXImageView);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
         return vresult; }
static VALUE _wrap_new_FXImageView(int argc, VALUE *argv, VALUE self) { FXComposite *arg1 = (FXComposite *) 0 ;
    FXImage *arg2 = (FXImage *) 0 ; FXObject *arg3 = (FXObject *) 0 ; FXSelector arg4 = (FXSelector) 0 ;
    FXuint arg5 = (FXuint) 0 ; FXint arg6 = (FXint) 0 ; FXint arg7 = (FXint) 0 ; FXint arg8 = (FXint) 0 ;
    FXint arg9 = (FXint) 0 ; FXImageView *result; if ((argc < 1) || (argc > 9))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXComposite, 1); if (argc > 1) {
        SWIG_ConvertPtr(argv[1], (void **) &arg2, SWIGTYPE_p_FXImage, 1); }  if (argc > 2) {
        SWIG_ConvertPtr(argv[2], (void **) &arg3, SWIGTYPE_p_FXObject, 1); }  if (argc > 3) { arg4 = NUM2UINT(argv[3]); } 
    if (argc > 4) { arg5 = NUM2UINT(argv[4]); }  if (argc > 5) { arg6 = NUM2INT(argv[5]); }  if (argc > 6) {
        arg7 = NUM2INT(argv[6]); }  if (argc > 7) { arg8 = NUM2INT(argv[7]); }  if (argc > 8) { arg9 = NUM2INT(argv[8]); }  {
        result = (FXImageView *)new_FXImageView(arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8,arg9);
        DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result); if(rb_block_given_p()){ rb_yield(self); }  }  return self; }
static VALUE _wrap_FXImageView_setImage(int argc, VALUE *argv, VALUE self) { FXImageView *arg1 = (FXImageView *) 0 ;
    FXImage *arg2 = (FXImage *) 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXImageView, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXImage, 1); (arg1)->setImage(arg2); return Qnil; }
static VALUE _wrap_FXImageView_getImage(int argc, VALUE *argv, VALUE self) { FXImageView *arg1 = (FXImageView *) 0 ;
    FXImage *result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXImageView, 1);
    result = (FXImage *)((FXImageView const *)arg1)->getImage(); {
        swig_type_info *ty = SWIG_TypeDynamicCast(SWIGTYPE_p_FXImage, (void **) &result); vresult = FXRbGetRubyObj(result, ty); }
     return vresult; }
static VALUE _wrap_FXImageView_setAlignment(int argc, VALUE *argv, VALUE self) { FXImageView *arg1 = (FXImageView *) 0 ;
    FXuint arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXImageView, 1); arg2 = NUM2UINT(argv[0]); (arg1)->setAlignment(arg2);
    return Qnil; }
static VALUE _wrap_FXImageView_getAlignment(int argc, VALUE *argv, VALUE self) { FXImageView *arg1 = (FXImageView *) 0 ;
    FXuint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXImageView, 1);
    result = (FXuint)((FXImageView const *)arg1)->getAlignment(); vresult = UINT2NUM(result); return vresult; }
static void
free_FXImageView(FXImageView *arg1) {
    delete arg1;
}
static VALUE _wrap_FXImageView_save(int argc, VALUE *argv, VALUE self) { FXImageView *arg1 = (FXImageView *) 0 ;
    FXStream *arg2 = 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXImageView, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXImageView_save((FXImageView const *)arg1,*arg2); return Qnil; }
static VALUE _wrap_FXImageView_load(int argc, VALUE *argv, VALUE self) { FXImageView *arg1 = (FXImageView *) 0 ;
    FXStream *arg2 = 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXImageView, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXImageView_load(arg1,*arg2); return Qnil; }
static VALUE _wrap_FXImageView_create(int argc, VALUE *argv, VALUE self) { FXImageView *arg1 = (FXImageView *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXImageView, 1); FXImageView_create(arg1); return Qnil; }
static VALUE _wrap_FXImageView_detach(int argc, VALUE *argv, VALUE self) { FXImageView *arg1 = (FXImageView *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXImageView, 1); FXImageView_detach(arg1); return Qnil; }
static VALUE _wrap_FXImageView_destroy(int argc, VALUE *argv, VALUE self) { FXImageView *arg1 = (FXImageView *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXImageView, 1); FXImageView_destroy(arg1); return Qnil; }
static VALUE _wrap_FXImageView_resize(int argc, VALUE *argv, VALUE self) { FXImageView *arg1 = (FXImageView *) 0 ; FXint arg2 ;
    FXint arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXImageView, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    FXImageView_resize(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXImageView_getDefaultWidth(int argc, VALUE *argv, VALUE self) { FXImageView *arg1 = (FXImageView *) 0 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXImageView, 1); result = (FXint)FXImageView_getDefaultWidth(arg1);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXImageView_getDefaultHeight(int argc, VALUE *argv, VALUE self) { FXImageView *arg1 = (FXImageView *) 0 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXImageView, 1); result = (FXint)FXImageView_getDefaultHeight(arg1);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXImageView_getWidthForHeight(int argc, VALUE *argv, VALUE self) { FXImageView *arg1 = (FXImageView *) 0 ;
    FXint arg2 ; FXint result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXImageView, 1); arg2 = NUM2INT(argv[0]);
    result = (FXint)FXImageView_getWidthForHeight(arg1,arg2); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXImageView_getHeightForWidth(int argc, VALUE *argv, VALUE self) { FXImageView *arg1 = (FXImageView *) 0 ;
    FXint arg2 ; FXint result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXImageView, 1); arg2 = NUM2INT(argv[0]);
    result = (FXint)FXImageView_getHeightForWidth(arg1,arg2); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXImageView_canFocus(int argc, VALUE *argv, VALUE self) { FXImageView *arg1 = (FXImageView *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXImageView, 1);
    result = (FXbool)FXImageView_canFocus((FXImageView const *)arg1); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXImageView_setFocus(int argc, VALUE *argv, VALUE self) { FXImageView *arg1 = (FXImageView *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXImageView, 1); FXImageView_setFocus(arg1); return Qnil; }
static VALUE _wrap_FXImageView_killFocus(int argc, VALUE *argv, VALUE self) { FXImageView *arg1 = (FXImageView *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXImageView, 1); FXImageView_killFocus(arg1); return Qnil; }
static VALUE _wrap_FXImageView_setDefault(int argc, VALUE *argv, VALUE self) { FXImageView *arg1 = (FXImageView *) 0 ;
    FXbool arg2 = (FXbool) 1 ; if ((argc < 0) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXImageView, 1); if (argc > 0) { arg2 = to_FXbool(argv[0]); } 
    FXImageView_setDefault(arg1,arg2); return Qnil; }
static VALUE _wrap_FXImageView_enable(int argc, VALUE *argv, VALUE self) { FXImageView *arg1 = (FXImageView *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXImageView, 1); FXImageView_enable(arg1); return Qnil; }
static VALUE _wrap_FXImageView_disable(int argc, VALUE *argv, VALUE self) { FXImageView *arg1 = (FXImageView *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXImageView, 1); FXImageView_disable(arg1); return Qnil; }
static VALUE _wrap_FXImageView_raiseWindow(int argc, VALUE *argv, VALUE self) { FXImageView *arg1 = (FXImageView *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXImageView, 1); FXImageView_raise(arg1); return Qnil; }
static VALUE _wrap_FXImageView_lower(int argc, VALUE *argv, VALUE self) { FXImageView *arg1 = (FXImageView *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXImageView, 1); FXImageView_lower(arg1); return Qnil; }
static VALUE _wrap_FXImageView_move(int argc, VALUE *argv, VALUE self) { FXImageView *arg1 = (FXImageView *) 0 ; FXint arg2 ;
    FXint arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXImageView, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    FXImageView_move(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXImageView_position__SWIG_0(int argc, VALUE *argv, VALUE self) { FXImageView *arg1 = (FXImageView *) 0 ;
    FXint arg2 ; FXint arg3 ; FXint arg4 ; FXint arg5 ; if ((argc < 4) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXImageView, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    arg4 = NUM2INT(argv[2]); arg5 = NUM2INT(argv[3]); FXImageView_position(arg1,arg2,arg3,arg4,arg5); return Qnil; }
static VALUE _wrap_FXImageView_layout(int argc, VALUE *argv, VALUE self) { FXImageView *arg1 = (FXImageView *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXImageView, 1); FXImageView_layout(arg1); return Qnil; }
static VALUE _wrap_FXImageView_recalc(int argc, VALUE *argv, VALUE self) { FXImageView *arg1 = (FXImageView *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXImageView, 1); FXImageView_recalc(arg1); return Qnil; }
static VALUE _wrap_FXImageView_reparent(int argc, VALUE *argv, VALUE self) { FXImageView *arg1 = (FXImageView *) 0 ;
    FXComposite *arg2 = (FXComposite *) 0 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXImageView, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXComposite, 1); FXImageView_reparent(arg1,arg2); return Qnil; }
static VALUE _wrap_FXImageView_show(int argc, VALUE *argv, VALUE self) { FXImageView *arg1 = (FXImageView *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXImageView, 1); FXImageView_show(arg1); return Qnil; }
static VALUE _wrap_FXImageView_hide(int argc, VALUE *argv, VALUE self) { FXImageView *arg1 = (FXImageView *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXImageView, 1); FXImageView_hide(arg1); return Qnil; }
static VALUE _wrap_FXImageView_isComposite(int argc, VALUE *argv, VALUE self) { FXImageView *arg1 = (FXImageView *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXImageView, 1);
    result = (FXbool)FXImageView_isComposite((FXImageView const *)arg1); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXImageView_contains(int argc, VALUE *argv, VALUE self) { FXImageView *arg1 = (FXImageView *) 0 ;
    FXint arg2 ; FXint arg3 ; FXbool result; VALUE vresult = Qnil; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXImageView, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    result = (FXbool)FXImageView_contains((FXImageView const *)arg1,arg2,arg3); vresult = result ? Qtrue : Qfalse;
    return vresult; }
static VALUE _wrap_FXImageView_doesSaveUnder(int argc, VALUE *argv, VALUE self) { FXImageView *arg1 = (FXImageView *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXImageView, 1);
    result = (FXbool)FXImageView_doesSaveUnder((FXImageView const *)arg1); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXImageView_setBackColor(int argc, VALUE *argv, VALUE self) { FXImageView *arg1 = (FXImageView *) 0 ;
    FXColor arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXImageView, 1); arg2 = to_FXColor(argv[0]);
    FXImageView_setBackColor(arg1,arg2); return Qnil; }
static VALUE _wrap_FXImageView_getViewportHeight(int argc, VALUE *argv, VALUE self) { FXImageView *arg1 = (FXImageView *) 0 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXImageView, 1); result = (FXint)FXImageView_getViewportHeight(arg1);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXImageView_getViewportWidth(int argc, VALUE *argv, VALUE self) { FXImageView *arg1 = (FXImageView *) 0 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXImageView, 1); result = (FXint)FXImageView_getViewportWidth(arg1);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXImageView_getContentHeight(int argc, VALUE *argv, VALUE self) { FXImageView *arg1 = (FXImageView *) 0 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXImageView, 1); result = (FXint)FXImageView_getContentHeight(arg1);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXImageView_getContentWidth(int argc, VALUE *argv, VALUE self) { FXImageView *arg1 = (FXImageView *) 0 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXImageView, 1); result = (FXint)FXImageView_getContentWidth(arg1);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXImageView_position__SWIG_1(int argc, VALUE *argv, VALUE self) { FXImageView *arg1 = (FXImageView *) 0 ;
    VALUE result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXImageView, 1);
    result = (VALUE)FXImageView_position__SWIG_1((FXImageView const *)arg1); vresult = result; return vresult; }
static VALUE _wrap_FXImageView_position(int nargs, VALUE *args, VALUE self) { int argc; VALUE argv[6]; int ii; argc = nargs + 1;
    argv[0] = self; for (ii = 1; (ii < argc) && (ii < 5); ii++) { argv[ii] = args[ii-1]; }  if (argc == 1) { int _v; {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXImageView, 0) != -1)) ? 1 : 0; }
         if (_v) { return _wrap_FXImageView_position__SWIG_1(nargs, args, self);}  }  if (argc == 5) { int _v; { void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXImageView, 0) != -1)) ? 1 : 0; }
         if (_v) { { _v = ((TYPE(argv[1]) == T_FIXNUM) || (TYPE(argv[1]) == T_BIGNUM)) ? 1 : 0; }  if (_v) { {
                    _v = ((TYPE(argv[2]) == T_FIXNUM) || (TYPE(argv[2]) == T_BIGNUM)) ? 1 : 0; }  if (_v) { {
                        _v = ((TYPE(argv[3]) == T_FIXNUM) || (TYPE(argv[3]) == T_BIGNUM)) ? 1 : 0; }  if (_v) { {
                            _v = ((TYPE(argv[4]) == T_FIXNUM) || (TYPE(argv[4]) == T_BIGNUM)) ? 1 : 0; }  if (_v) {
                            return _wrap_FXImageView_position__SWIG_0(nargs, args, self);}  }  }  }  }  } 
    rb_raise(rb_eArgError, "No matching function for overloaded 'FXImageView_position'"); return Qnil; }
static VALUE _wrap_FXDragCorner_onPaint(int argc, VALUE *argv, VALUE self) { FXDragCorner *arg1 = (FXDragCorner *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDragCorner, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onPaint(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXDragCorner_onLeftBtnPress(int argc, VALUE *argv, VALUE self) { FXDragCorner *arg1 = (FXDragCorner *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDragCorner, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onLeftBtnPress(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXDragCorner_onLeftBtnRelease(int argc, VALUE *argv, VALUE self) { FXDragCorner *arg1 = (FXDragCorner *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDragCorner, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onLeftBtnRelease(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXDragCorner_onMotion(int argc, VALUE *argv, VALUE self) { FXDragCorner *arg1 = (FXDragCorner *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDragCorner, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onMotion(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE _wrap_FXDragCorner_allocate(VALUE self) {
#else
     static VALUE _wrap_FXDragCorner_allocate(int argc, VALUE *argv, VALUE self) {
#endif
         VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_FXDragCorner);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
         return vresult; }
static VALUE _wrap_new_FXDragCorner(int argc, VALUE *argv, VALUE self) { FXComposite *arg1 = (FXComposite *) 0 ;
    FXDragCorner *result; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXComposite, 1); { result = (FXDragCorner *)new_FXDragCorner(arg1);
        DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result); if(rb_block_given_p()){ rb_yield(self); }  }  return self; }
static VALUE _wrap_FXDragCorner_setHiliteColor(int argc, VALUE *argv, VALUE self) { FXDragCorner *arg1 = (FXDragCorner *) 0 ;
    FXColor arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDragCorner, 1); arg2 = to_FXColor(argv[0]);
    (arg1)->setHiliteColor(arg2); return Qnil; }
static VALUE _wrap_FXDragCorner_getHiliteColor(int argc, VALUE *argv, VALUE self) { FXDragCorner *arg1 = (FXDragCorner *) 0 ;
    FXColor result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDragCorner, 1);
    result = (FXColor)((FXDragCorner const *)arg1)->getHiliteColor(); vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXDragCorner_setShadowColor(int argc, VALUE *argv, VALUE self) { FXDragCorner *arg1 = (FXDragCorner *) 0 ;
    FXColor arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDragCorner, 1); arg2 = to_FXColor(argv[0]);
    (arg1)->setShadowColor(arg2); return Qnil; }
static VALUE _wrap_FXDragCorner_getShadowColor(int argc, VALUE *argv, VALUE self) { FXDragCorner *arg1 = (FXDragCorner *) 0 ;
    FXColor result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDragCorner, 1);
    result = (FXColor)((FXDragCorner const *)arg1)->getShadowColor(); vresult = UINT2NUM(result); return vresult; }
static void
free_FXDragCorner(FXDragCorner *arg1) {
    delete arg1;
}
static VALUE _wrap_FXDragCorner_save(int argc, VALUE *argv, VALUE self) { FXDragCorner *arg1 = (FXDragCorner *) 0 ;
    FXStream *arg2 = 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDragCorner, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXDragCorner_save((FXDragCorner const *)arg1,*arg2); return Qnil; }
static VALUE _wrap_FXDragCorner_load(int argc, VALUE *argv, VALUE self) { FXDragCorner *arg1 = (FXDragCorner *) 0 ;
    FXStream *arg2 = 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDragCorner, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXDragCorner_load(arg1,*arg2); return Qnil; }
static VALUE _wrap_FXDragCorner_create(int argc, VALUE *argv, VALUE self) { FXDragCorner *arg1 = (FXDragCorner *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDragCorner, 1); FXDragCorner_create(arg1); return Qnil; }
static VALUE _wrap_FXDragCorner_detach(int argc, VALUE *argv, VALUE self) { FXDragCorner *arg1 = (FXDragCorner *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDragCorner, 1); FXDragCorner_detach(arg1); return Qnil; }
static VALUE _wrap_FXDragCorner_destroy(int argc, VALUE *argv, VALUE self) { FXDragCorner *arg1 = (FXDragCorner *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDragCorner, 1); FXDragCorner_destroy(arg1); return Qnil; }
static VALUE _wrap_FXDragCorner_resize(int argc, VALUE *argv, VALUE self) { FXDragCorner *arg1 = (FXDragCorner *) 0 ;
    FXint arg2 ; FXint arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDragCorner, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    FXDragCorner_resize(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXDragCorner_getDefaultWidth(int argc, VALUE *argv, VALUE self) { FXDragCorner *arg1 = (FXDragCorner *) 0 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDragCorner, 1); result = (FXint)FXDragCorner_getDefaultWidth(arg1);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXDragCorner_getDefaultHeight(int argc, VALUE *argv, VALUE self) { FXDragCorner *arg1 = (FXDragCorner *) 0 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDragCorner, 1); result = (FXint)FXDragCorner_getDefaultHeight(arg1);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXDragCorner_getWidthForHeight(int argc, VALUE *argv, VALUE self) { FXDragCorner *arg1 = (FXDragCorner *) 0 ;
    FXint arg2 ; FXint result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDragCorner, 1); arg2 = NUM2INT(argv[0]);
    result = (FXint)FXDragCorner_getWidthForHeight(arg1,arg2); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXDragCorner_getHeightForWidth(int argc, VALUE *argv, VALUE self) { FXDragCorner *arg1 = (FXDragCorner *) 0 ;
    FXint arg2 ; FXint result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDragCorner, 1); arg2 = NUM2INT(argv[0]);
    result = (FXint)FXDragCorner_getHeightForWidth(arg1,arg2); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXDragCorner_canFocus(int argc, VALUE *argv, VALUE self) { FXDragCorner *arg1 = (FXDragCorner *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDragCorner, 1);
    result = (FXbool)FXDragCorner_canFocus((FXDragCorner const *)arg1); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXDragCorner_setFocus(int argc, VALUE *argv, VALUE self) { FXDragCorner *arg1 = (FXDragCorner *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDragCorner, 1); FXDragCorner_setFocus(arg1); return Qnil; }
static VALUE _wrap_FXDragCorner_killFocus(int argc, VALUE *argv, VALUE self) { FXDragCorner *arg1 = (FXDragCorner *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDragCorner, 1); FXDragCorner_killFocus(arg1); return Qnil; }
static VALUE _wrap_FXDragCorner_setDefault(int argc, VALUE *argv, VALUE self) { FXDragCorner *arg1 = (FXDragCorner *) 0 ;
    FXbool arg2 = (FXbool) 1 ; if ((argc < 0) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDragCorner, 1); if (argc > 0) { arg2 = to_FXbool(argv[0]); } 
    FXDragCorner_setDefault(arg1,arg2); return Qnil; }
static VALUE _wrap_FXDragCorner_enable(int argc, VALUE *argv, VALUE self) { FXDragCorner *arg1 = (FXDragCorner *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDragCorner, 1); FXDragCorner_enable(arg1); return Qnil; }
static VALUE _wrap_FXDragCorner_disable(int argc, VALUE *argv, VALUE self) { FXDragCorner *arg1 = (FXDragCorner *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDragCorner, 1); FXDragCorner_disable(arg1); return Qnil; }
static VALUE _wrap_FXDragCorner_raiseWindow(int argc, VALUE *argv, VALUE self) { FXDragCorner *arg1 = (FXDragCorner *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDragCorner, 1); FXDragCorner_raise(arg1); return Qnil; }
static VALUE _wrap_FXDragCorner_lower(int argc, VALUE *argv, VALUE self) { FXDragCorner *arg1 = (FXDragCorner *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDragCorner, 1); FXDragCorner_lower(arg1); return Qnil; }
static VALUE _wrap_FXDragCorner_move(int argc, VALUE *argv, VALUE self) { FXDragCorner *arg1 = (FXDragCorner *) 0 ; FXint arg2 ;
    FXint arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDragCorner, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    FXDragCorner_move(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXDragCorner_position(int argc, VALUE *argv, VALUE self) { FXDragCorner *arg1 = (FXDragCorner *) 0 ;
    FXint arg2 ; FXint arg3 ; FXint arg4 ; FXint arg5 ; if ((argc < 4) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDragCorner, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    arg4 = NUM2INT(argv[2]); arg5 = NUM2INT(argv[3]); FXDragCorner_position(arg1,arg2,arg3,arg4,arg5); return Qnil; }
static VALUE _wrap_FXDragCorner_layout(int argc, VALUE *argv, VALUE self) { FXDragCorner *arg1 = (FXDragCorner *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDragCorner, 1); FXDragCorner_layout(arg1); return Qnil; }
static VALUE _wrap_FXDragCorner_recalc(int argc, VALUE *argv, VALUE self) { FXDragCorner *arg1 = (FXDragCorner *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDragCorner, 1); FXDragCorner_recalc(arg1); return Qnil; }
static VALUE _wrap_FXDragCorner_reparent(int argc, VALUE *argv, VALUE self) { FXDragCorner *arg1 = (FXDragCorner *) 0 ;
    FXComposite *arg2 = (FXComposite *) 0 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDragCorner, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXComposite, 1); FXDragCorner_reparent(arg1,arg2); return Qnil; }
static VALUE _wrap_FXDragCorner_show(int argc, VALUE *argv, VALUE self) { FXDragCorner *arg1 = (FXDragCorner *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDragCorner, 1); FXDragCorner_show(arg1); return Qnil; }
static VALUE _wrap_FXDragCorner_hide(int argc, VALUE *argv, VALUE self) { FXDragCorner *arg1 = (FXDragCorner *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDragCorner, 1); FXDragCorner_hide(arg1); return Qnil; }
static VALUE _wrap_FXDragCorner_isComposite(int argc, VALUE *argv, VALUE self) { FXDragCorner *arg1 = (FXDragCorner *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDragCorner, 1);
    result = (FXbool)FXDragCorner_isComposite((FXDragCorner const *)arg1); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXDragCorner_contains(int argc, VALUE *argv, VALUE self) { FXDragCorner *arg1 = (FXDragCorner *) 0 ;
    FXint arg2 ; FXint arg3 ; FXbool result; VALUE vresult = Qnil; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDragCorner, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    result = (FXbool)FXDragCorner_contains((FXDragCorner const *)arg1,arg2,arg3); vresult = result ? Qtrue : Qfalse;
    return vresult; }
static VALUE _wrap_FXDragCorner_doesSaveUnder(int argc, VALUE *argv, VALUE self) { FXDragCorner *arg1 = (FXDragCorner *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDragCorner, 1);
    result = (FXbool)FXDragCorner_doesSaveUnder((FXDragCorner const *)arg1); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXDragCorner_setBackColor(int argc, VALUE *argv, VALUE self) { FXDragCorner *arg1 = (FXDragCorner *) 0 ;
    FXColor arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDragCorner, 1); arg2 = to_FXColor(argv[0]);
    FXDragCorner_setBackColor(arg1,arg2); return Qnil; }
static VALUE _wrap_FXDirBox_onChanged(int argc, VALUE *argv, VALUE self) { FXDirBox *arg1 = (FXDirBox *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDirBox, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]);
    SWIG_ConvertPtr(argv[2],&arg4,SWIGTYPE_p_FXObject,1); result = (long)(arg1)->onChanged(arg2,arg3,arg4);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXDirBox_onCommand(int argc, VALUE *argv, VALUE self) { FXDirBox *arg1 = (FXDirBox *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDirBox, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]);
    SWIG_ConvertPtr(argv[2],&arg4,SWIGTYPE_p_FXObject,1); result = (long)(arg1)->onCommand(arg2,arg3,arg4);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXDirBox_onCmdSetValue(int argc, VALUE *argv, VALUE self) { FXDirBox *arg1 = (FXDirBox *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDirBox, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]);
    arg4 = static_cast<void*>(STR2CSTR(argv[2])); result = (long)(arg1)->onCmdSetValue(arg2,arg3,arg4);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXDirBox_onCmdSetStringValue(int argc, VALUE *argv, VALUE self) { FXDirBox *arg1 = (FXDirBox *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; FXString value4 ;
    VALUE vresult = Qnil; if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDirBox, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); {
        value4 = FXString(STR2CSTR(argv[2])); arg4 = (void *) &value4; } 
    result = (long)(arg1)->onCmdSetStringValue(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXDirBox_onCmdGetStringValue(int argc, VALUE *argv, VALUE self) { FXDirBox *arg1 = (FXDirBox *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDirBox, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdGetStringValue(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE _wrap_FXDirBox_allocate(VALUE self) {
#else
     static VALUE _wrap_FXDirBox_allocate(int argc, VALUE *argv, VALUE self) {
#endif
         VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_FXDirBox);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
         return vresult; }
static VALUE _wrap_new_FXDirBox(int argc, VALUE *argv, VALUE self) { FXComposite *arg1 = (FXComposite *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 = (FXSelector) 0 ;
    FXuint arg4 = (FXuint) FRAME_SUNKEN|FRAME_THICK|TREELISTBOX_NORMAL ; FXint arg5 = (FXint) 0 ; FXint arg6 = (FXint) 0 ;
    FXint arg7 = (FXint) 0 ; FXint arg8 = (FXint) 0 ; FXint arg9 = (FXint) DEFAULT_PAD ; FXint arg10 = (FXint) DEFAULT_PAD ;
    FXint arg11 = (FXint) DEFAULT_PAD ; FXint arg12 = (FXint) DEFAULT_PAD ; FXDirBox *result; if ((argc < 1) || (argc > 12))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXComposite, 1); if (argc > 1) {
        SWIG_ConvertPtr(argv[1], (void **) &arg2, SWIGTYPE_p_FXObject, 1); }  if (argc > 2) { arg3 = NUM2UINT(argv[2]); } 
    if (argc > 3) { arg4 = NUM2UINT(argv[3]); }  if (argc > 4) { arg5 = NUM2INT(argv[4]); }  if (argc > 5) {
        arg6 = NUM2INT(argv[5]); }  if (argc > 6) { arg7 = NUM2INT(argv[6]); }  if (argc > 7) { arg8 = NUM2INT(argv[7]); } 
    if (argc > 8) { arg9 = NUM2INT(argv[8]); }  if (argc > 9) { arg10 = NUM2INT(argv[9]); }  if (argc > 10) {
        arg11 = NUM2INT(argv[10]); }  if (argc > 11) { arg12 = NUM2INT(argv[11]); }  {
        result = (FXDirBox *)new_FXDirBox(arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8,arg9,arg10,arg11,arg12);
        DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result); if(rb_block_given_p()){ rb_yield(self); }  }  return self; }
static VALUE _wrap_FXDirBox_setDirectory(int argc, VALUE *argv, VALUE self) { FXDirBox *arg1 = (FXDirBox *) 0 ;
    FXString *arg2 = 0 ; SwigValueWrapper<FXString > p2 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDirBox, 1); p2 = to_FXString(argv[0]); arg2 = &p2;
    (arg1)->setDirectory((FXString const &)*arg2); return Qnil; }
static VALUE _wrap_FXDirBox_getDirectory(int argc, VALUE *argv, VALUE self) { FXDirBox *arg1 = (FXDirBox *) 0 ; FXString result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDirBox, 1); result = ((FXDirBox const *)arg1)->getDirectory();
    vresult = rb_str_new2((&result)->text()); return vresult; }
static VALUE _wrap_FXDirBox_setAssociations(int argc, VALUE *argv, VALUE self) { FXDirBox *arg1 = (FXDirBox *) 0 ;
    FXFileDict *arg2 = (FXFileDict *) 0 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDirBox, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXFileDict, 1); (arg1)->setAssociations(arg2); return Qnil; }
static VALUE _wrap_FXDirBox_getAssociations(int argc, VALUE *argv, VALUE self) { FXDirBox *arg1 = (FXDirBox *) 0 ;
    FXFileDict *result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDirBox, 1);
    result = (FXFileDict *)((FXDirBox const *)arg1)->getAssociations(); {
        swig_type_info *ty = SWIG_TypeDynamicCast(SWIGTYPE_p_FXFileDict, (void **) &result);
        vresult = FXRbGetRubyObj(result, ty); }  return vresult; }
static void
free_FXDirBox(FXDirBox *arg1) {
    delete arg1;
}
static VALUE _wrap_FXDirBox_save(int argc, VALUE *argv, VALUE self) { FXDirBox *arg1 = (FXDirBox *) 0 ; FXStream *arg2 = 0 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDirBox, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXDirBox_save((FXDirBox const *)arg1,*arg2); return Qnil; }
static VALUE _wrap_FXDirBox_load(int argc, VALUE *argv, VALUE self) { FXDirBox *arg1 = (FXDirBox *) 0 ; FXStream *arg2 = 0 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDirBox, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXDirBox_load(arg1,*arg2); return Qnil; }
static VALUE _wrap_FXDirBox_create(int argc, VALUE *argv, VALUE self) { FXDirBox *arg1 = (FXDirBox *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDirBox, 1); FXDirBox_create(arg1); return Qnil; }
static VALUE _wrap_FXDirBox_detach(int argc, VALUE *argv, VALUE self) { FXDirBox *arg1 = (FXDirBox *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDirBox, 1); FXDirBox_detach(arg1); return Qnil; }
static VALUE _wrap_FXDirBox_destroy(int argc, VALUE *argv, VALUE self) { FXDirBox *arg1 = (FXDirBox *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDirBox, 1); FXDirBox_destroy(arg1); return Qnil; }
static VALUE _wrap_FXDirBox_resize(int argc, VALUE *argv, VALUE self) { FXDirBox *arg1 = (FXDirBox *) 0 ; FXint arg2 ;
    FXint arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDirBox, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    FXDirBox_resize(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXDirBox_getDefaultWidth(int argc, VALUE *argv, VALUE self) { FXDirBox *arg1 = (FXDirBox *) 0 ; FXint result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDirBox, 1); result = (FXint)FXDirBox_getDefaultWidth(arg1);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXDirBox_getDefaultHeight(int argc, VALUE *argv, VALUE self) { FXDirBox *arg1 = (FXDirBox *) 0 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDirBox, 1); result = (FXint)FXDirBox_getDefaultHeight(arg1);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXDirBox_getWidthForHeight(int argc, VALUE *argv, VALUE self) { FXDirBox *arg1 = (FXDirBox *) 0 ;
    FXint arg2 ; FXint result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDirBox, 1); arg2 = NUM2INT(argv[0]);
    result = (FXint)FXDirBox_getWidthForHeight(arg1,arg2); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXDirBox_getHeightForWidth(int argc, VALUE *argv, VALUE self) { FXDirBox *arg1 = (FXDirBox *) 0 ;
    FXint arg2 ; FXint result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDirBox, 1); arg2 = NUM2INT(argv[0]);
    result = (FXint)FXDirBox_getHeightForWidth(arg1,arg2); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXDirBox_canFocus(int argc, VALUE *argv, VALUE self) { FXDirBox *arg1 = (FXDirBox *) 0 ; FXbool result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDirBox, 1); result = (FXbool)FXDirBox_canFocus((FXDirBox const *)arg1);
    vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXDirBox_setFocus(int argc, VALUE *argv, VALUE self) { FXDirBox *arg1 = (FXDirBox *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDirBox, 1); FXDirBox_setFocus(arg1); return Qnil; }
static VALUE _wrap_FXDirBox_killFocus(int argc, VALUE *argv, VALUE self) { FXDirBox *arg1 = (FXDirBox *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDirBox, 1); FXDirBox_killFocus(arg1); return Qnil; }
static VALUE _wrap_FXDirBox_setDefault(int argc, VALUE *argv, VALUE self) { FXDirBox *arg1 = (FXDirBox *) 0 ;
    FXbool arg2 = (FXbool) 1 ; if ((argc < 0) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDirBox, 1); if (argc > 0) { arg2 = to_FXbool(argv[0]); } 
    FXDirBox_setDefault(arg1,arg2); return Qnil; }
static VALUE _wrap_FXDirBox_enable(int argc, VALUE *argv, VALUE self) { FXDirBox *arg1 = (FXDirBox *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDirBox, 1); FXDirBox_enable(arg1); return Qnil; }
static VALUE _wrap_FXDirBox_disable(int argc, VALUE *argv, VALUE self) { FXDirBox *arg1 = (FXDirBox *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDirBox, 1); FXDirBox_disable(arg1); return Qnil; }
static VALUE _wrap_FXDirBox_raiseWindow(int argc, VALUE *argv, VALUE self) { FXDirBox *arg1 = (FXDirBox *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDirBox, 1); FXDirBox_raise(arg1); return Qnil; }
static VALUE _wrap_FXDirBox_lower(int argc, VALUE *argv, VALUE self) { FXDirBox *arg1 = (FXDirBox *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDirBox, 1); FXDirBox_lower(arg1); return Qnil; }
static VALUE _wrap_FXDirBox_move(int argc, VALUE *argv, VALUE self) { FXDirBox *arg1 = (FXDirBox *) 0 ; FXint arg2 ;
    FXint arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDirBox, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    FXDirBox_move(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXDirBox_position(int argc, VALUE *argv, VALUE self) { FXDirBox *arg1 = (FXDirBox *) 0 ; FXint arg2 ;
    FXint arg3 ; FXint arg4 ; FXint arg5 ; if ((argc < 4) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDirBox, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    arg4 = NUM2INT(argv[2]); arg5 = NUM2INT(argv[3]); FXDirBox_position(arg1,arg2,arg3,arg4,arg5); return Qnil; }
static VALUE _wrap_FXDirBox_layout(int argc, VALUE *argv, VALUE self) { FXDirBox *arg1 = (FXDirBox *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDirBox, 1); FXDirBox_layout(arg1); return Qnil; }
static VALUE _wrap_FXDirBox_recalc(int argc, VALUE *argv, VALUE self) { FXDirBox *arg1 = (FXDirBox *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDirBox, 1); FXDirBox_recalc(arg1); return Qnil; }
static VALUE _wrap_FXDirBox_reparent(int argc, VALUE *argv, VALUE self) { FXDirBox *arg1 = (FXDirBox *) 0 ;
    FXComposite *arg2 = (FXComposite *) 0 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDirBox, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXComposite, 1); FXDirBox_reparent(arg1,arg2); return Qnil; }
static VALUE _wrap_FXDirBox_show(int argc, VALUE *argv, VALUE self) { FXDirBox *arg1 = (FXDirBox *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDirBox, 1); FXDirBox_show(arg1); return Qnil; }
static VALUE _wrap_FXDirBox_hide(int argc, VALUE *argv, VALUE self) { FXDirBox *arg1 = (FXDirBox *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDirBox, 1); FXDirBox_hide(arg1); return Qnil; }
static VALUE _wrap_FXDirBox_isComposite(int argc, VALUE *argv, VALUE self) { FXDirBox *arg1 = (FXDirBox *) 0 ; FXbool result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDirBox, 1);
    result = (FXbool)FXDirBox_isComposite((FXDirBox const *)arg1); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXDirBox_contains(int argc, VALUE *argv, VALUE self) { FXDirBox *arg1 = (FXDirBox *) 0 ; FXint arg2 ;
    FXint arg3 ; FXbool result; VALUE vresult = Qnil; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDirBox, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    result = (FXbool)FXDirBox_contains((FXDirBox const *)arg1,arg2,arg3); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXDirBox_doesSaveUnder(int argc, VALUE *argv, VALUE self) { FXDirBox *arg1 = (FXDirBox *) 0 ; FXbool result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDirBox, 1);
    result = (FXbool)FXDirBox_doesSaveUnder((FXDirBox const *)arg1); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXDirBox_setBackColor(int argc, VALUE *argv, VALUE self) { FXDirBox *arg1 = (FXDirBox *) 0 ; FXColor arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDirBox, 1); arg2 = to_FXColor(argv[0]);
    FXDirBox_setBackColor(arg1,arg2); return Qnil; }
static VALUE _wrap_FXDriveBox_onListChanged(int argc, VALUE *argv, VALUE self) { FXDriveBox *arg1 = (FXDriveBox *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDriveBox, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]);
    arg4 = reinterpret_cast<void*>(NUM2INT(argv[2])); result = (long)(arg1)->onListChanged(arg2,arg3,arg4);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXDriveBox_onListClicked(int argc, VALUE *argv, VALUE self) { FXDriveBox *arg1 = (FXDriveBox *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDriveBox, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]);
    arg4 = reinterpret_cast<void*>(NUM2INT(argv[2])); result = (long)(arg1)->onListClicked(arg2,arg3,arg4);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXDriveBox_onCmdSetValue(int argc, VALUE *argv, VALUE self) { FXDriveBox *arg1 = (FXDriveBox *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDriveBox, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]);
    arg4 = static_cast<void*>(STR2CSTR(argv[2])); result = (long)(arg1)->onCmdSetValue(arg2,arg3,arg4);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXDriveBox_onCmdSetStringValue(int argc, VALUE *argv, VALUE self) { FXDriveBox *arg1 = (FXDriveBox *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; FXString value4 ;
    VALUE vresult = Qnil; if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDriveBox, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); {
        value4 = FXString(STR2CSTR(argv[2])); arg4 = (void *) &value4; } 
    result = (long)(arg1)->onCmdSetStringValue(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXDriveBox_onCmdGetStringValue(int argc, VALUE *argv, VALUE self) { FXDriveBox *arg1 = (FXDriveBox *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDriveBox, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdGetStringValue(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE _wrap_FXDriveBox_allocate(VALUE self) {
#else
     static VALUE _wrap_FXDriveBox_allocate(int argc, VALUE *argv, VALUE self) {
#endif
         VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_FXDriveBox);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
         return vresult; }
static VALUE _wrap_new_FXDriveBox(int argc, VALUE *argv, VALUE self) { FXComposite *arg1 = (FXComposite *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 = (FXSelector) 0 ;
    FXuint arg4 = (FXuint) FRAME_SUNKEN|FRAME_THICK|LISTBOX_NORMAL ; FXint arg5 = (FXint) 0 ; FXint arg6 = (FXint) 0 ;
    FXint arg7 = (FXint) 0 ; FXint arg8 = (FXint) 0 ; FXint arg9 = (FXint) DEFAULT_PAD ; FXint arg10 = (FXint) DEFAULT_PAD ;
    FXint arg11 = (FXint) DEFAULT_PAD ; FXint arg12 = (FXint) DEFAULT_PAD ; FXDriveBox *result; if ((argc < 1) || (argc > 12))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXComposite, 1); if (argc > 1) {
        SWIG_ConvertPtr(argv[1], (void **) &arg2, SWIGTYPE_p_FXObject, 1); }  if (argc > 2) { arg3 = NUM2UINT(argv[2]); } 
    if (argc > 3) { arg4 = NUM2UINT(argv[3]); }  if (argc > 4) { arg5 = NUM2INT(argv[4]); }  if (argc > 5) {
        arg6 = NUM2INT(argv[5]); }  if (argc > 6) { arg7 = NUM2INT(argv[6]); }  if (argc > 7) { arg8 = NUM2INT(argv[7]); } 
    if (argc > 8) { arg9 = NUM2INT(argv[8]); }  if (argc > 9) { arg10 = NUM2INT(argv[9]); }  if (argc > 10) {
        arg11 = NUM2INT(argv[10]); }  if (argc > 11) { arg12 = NUM2INT(argv[11]); }  {
        result = (FXDriveBox *)new_FXDriveBox(arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8,arg9,arg10,arg11,arg12);
        DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result); if(rb_block_given_p()){ rb_yield(self); }  }  return self; }
static VALUE _wrap_FXDriveBox_setDrive(int argc, VALUE *argv, VALUE self) { FXDriveBox *arg1 = (FXDriveBox *) 0 ;
    FXString *arg2 = 0 ; FXbool result; SwigValueWrapper<FXString > p2 ; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDriveBox, 1); p2 = to_FXString(argv[0]); arg2 = &p2;
    result = (FXbool)(arg1)->setDrive((FXString const &)*arg2); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXDriveBox_getDrive(int argc, VALUE *argv, VALUE self) { FXDriveBox *arg1 = (FXDriveBox *) 0 ;
    FXString result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDriveBox, 1); result = ((FXDriveBox const *)arg1)->getDrive();
    vresult = rb_str_new2((&result)->text()); return vresult; }
static VALUE _wrap_FXDriveBox_setAssociations(int argc, VALUE *argv, VALUE self) { FXDriveBox *arg1 = (FXDriveBox *) 0 ;
    FXFileDict *arg2 = (FXFileDict *) 0 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDriveBox, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXFileDict, 1); (arg1)->setAssociations(arg2); return Qnil; }
static VALUE _wrap_FXDriveBox_getAssociations(int argc, VALUE *argv, VALUE self) { FXDriveBox *arg1 = (FXDriveBox *) 0 ;
    FXFileDict *result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDriveBox, 1);
    result = (FXFileDict *)((FXDriveBox const *)arg1)->getAssociations(); {
        swig_type_info *ty = SWIG_TypeDynamicCast(SWIGTYPE_p_FXFileDict, (void **) &result);
        vresult = FXRbGetRubyObj(result, ty); }  return vresult; }
static void
free_FXDriveBox(FXDriveBox *arg1) {
    delete arg1;
}
static VALUE _wrap_FXDriveBox_save(int argc, VALUE *argv, VALUE self) { FXDriveBox *arg1 = (FXDriveBox *) 0 ;
    FXStream *arg2 = 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDriveBox, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXDriveBox_save((FXDriveBox const *)arg1,*arg2); return Qnil; }
static VALUE _wrap_FXDriveBox_load(int argc, VALUE *argv, VALUE self) { FXDriveBox *arg1 = (FXDriveBox *) 0 ;
    FXStream *arg2 = 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDriveBox, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXDriveBox_load(arg1,*arg2); return Qnil; }
static VALUE _wrap_FXDriveBox_create(int argc, VALUE *argv, VALUE self) { FXDriveBox *arg1 = (FXDriveBox *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDriveBox, 1); FXDriveBox_create(arg1); return Qnil; }
static VALUE _wrap_FXDriveBox_detach(int argc, VALUE *argv, VALUE self) { FXDriveBox *arg1 = (FXDriveBox *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDriveBox, 1); FXDriveBox_detach(arg1); return Qnil; }
static VALUE _wrap_FXDriveBox_destroy(int argc, VALUE *argv, VALUE self) { FXDriveBox *arg1 = (FXDriveBox *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDriveBox, 1); FXDriveBox_destroy(arg1); return Qnil; }
static VALUE _wrap_FXDriveBox_resize(int argc, VALUE *argv, VALUE self) { FXDriveBox *arg1 = (FXDriveBox *) 0 ; FXint arg2 ;
    FXint arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDriveBox, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    FXDriveBox_resize(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXDriveBox_getDefaultWidth(int argc, VALUE *argv, VALUE self) { FXDriveBox *arg1 = (FXDriveBox *) 0 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDriveBox, 1); result = (FXint)FXDriveBox_getDefaultWidth(arg1);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXDriveBox_getDefaultHeight(int argc, VALUE *argv, VALUE self) { FXDriveBox *arg1 = (FXDriveBox *) 0 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDriveBox, 1); result = (FXint)FXDriveBox_getDefaultHeight(arg1);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXDriveBox_getWidthForHeight(int argc, VALUE *argv, VALUE self) { FXDriveBox *arg1 = (FXDriveBox *) 0 ;
    FXint arg2 ; FXint result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDriveBox, 1); arg2 = NUM2INT(argv[0]);
    result = (FXint)FXDriveBox_getWidthForHeight(arg1,arg2); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXDriveBox_getHeightForWidth(int argc, VALUE *argv, VALUE self) { FXDriveBox *arg1 = (FXDriveBox *) 0 ;
    FXint arg2 ; FXint result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDriveBox, 1); arg2 = NUM2INT(argv[0]);
    result = (FXint)FXDriveBox_getHeightForWidth(arg1,arg2); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXDriveBox_canFocus(int argc, VALUE *argv, VALUE self) { FXDriveBox *arg1 = (FXDriveBox *) 0 ; FXbool result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDriveBox, 1);
    result = (FXbool)FXDriveBox_canFocus((FXDriveBox const *)arg1); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXDriveBox_setFocus(int argc, VALUE *argv, VALUE self) { FXDriveBox *arg1 = (FXDriveBox *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDriveBox, 1); FXDriveBox_setFocus(arg1); return Qnil; }
static VALUE _wrap_FXDriveBox_killFocus(int argc, VALUE *argv, VALUE self) { FXDriveBox *arg1 = (FXDriveBox *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDriveBox, 1); FXDriveBox_killFocus(arg1); return Qnil; }
static VALUE _wrap_FXDriveBox_setDefault(int argc, VALUE *argv, VALUE self) { FXDriveBox *arg1 = (FXDriveBox *) 0 ;
    FXbool arg2 = (FXbool) 1 ; if ((argc < 0) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDriveBox, 1); if (argc > 0) { arg2 = to_FXbool(argv[0]); } 
    FXDriveBox_setDefault(arg1,arg2); return Qnil; }
static VALUE _wrap_FXDriveBox_enable(int argc, VALUE *argv, VALUE self) { FXDriveBox *arg1 = (FXDriveBox *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDriveBox, 1); FXDriveBox_enable(arg1); return Qnil; }
static VALUE _wrap_FXDriveBox_disable(int argc, VALUE *argv, VALUE self) { FXDriveBox *arg1 = (FXDriveBox *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDriveBox, 1); FXDriveBox_disable(arg1); return Qnil; }
static VALUE _wrap_FXDriveBox_raiseWindow(int argc, VALUE *argv, VALUE self) { FXDriveBox *arg1 = (FXDriveBox *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDriveBox, 1); FXDriveBox_raise(arg1); return Qnil; }
static VALUE _wrap_FXDriveBox_lower(int argc, VALUE *argv, VALUE self) { FXDriveBox *arg1 = (FXDriveBox *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDriveBox, 1); FXDriveBox_lower(arg1); return Qnil; }
static VALUE _wrap_FXDriveBox_move(int argc, VALUE *argv, VALUE self) { FXDriveBox *arg1 = (FXDriveBox *) 0 ; FXint arg2 ;
    FXint arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDriveBox, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    FXDriveBox_move(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXDriveBox_position(int argc, VALUE *argv, VALUE self) { FXDriveBox *arg1 = (FXDriveBox *) 0 ; FXint arg2 ;
    FXint arg3 ; FXint arg4 ; FXint arg5 ; if ((argc < 4) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDriveBox, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    arg4 = NUM2INT(argv[2]); arg5 = NUM2INT(argv[3]); FXDriveBox_position(arg1,arg2,arg3,arg4,arg5); return Qnil; }
static VALUE _wrap_FXDriveBox_layout(int argc, VALUE *argv, VALUE self) { FXDriveBox *arg1 = (FXDriveBox *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDriveBox, 1); FXDriveBox_layout(arg1); return Qnil; }
static VALUE _wrap_FXDriveBox_recalc(int argc, VALUE *argv, VALUE self) { FXDriveBox *arg1 = (FXDriveBox *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDriveBox, 1); FXDriveBox_recalc(arg1); return Qnil; }
static VALUE _wrap_FXDriveBox_reparent(int argc, VALUE *argv, VALUE self) { FXDriveBox *arg1 = (FXDriveBox *) 0 ;
    FXComposite *arg2 = (FXComposite *) 0 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDriveBox, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXComposite, 1); FXDriveBox_reparent(arg1,arg2); return Qnil; }
static VALUE _wrap_FXDriveBox_show(int argc, VALUE *argv, VALUE self) { FXDriveBox *arg1 = (FXDriveBox *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDriveBox, 1); FXDriveBox_show(arg1); return Qnil; }
static VALUE _wrap_FXDriveBox_hide(int argc, VALUE *argv, VALUE self) { FXDriveBox *arg1 = (FXDriveBox *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDriveBox, 1); FXDriveBox_hide(arg1); return Qnil; }
static VALUE _wrap_FXDriveBox_isComposite(int argc, VALUE *argv, VALUE self) { FXDriveBox *arg1 = (FXDriveBox *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDriveBox, 1);
    result = (FXbool)FXDriveBox_isComposite((FXDriveBox const *)arg1); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXDriveBox_contains(int argc, VALUE *argv, VALUE self) { FXDriveBox *arg1 = (FXDriveBox *) 0 ; FXint arg2 ;
    FXint arg3 ; FXbool result; VALUE vresult = Qnil; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDriveBox, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    result = (FXbool)FXDriveBox_contains((FXDriveBox const *)arg1,arg2,arg3); vresult = result ? Qtrue : Qfalse;
    return vresult; }
static VALUE _wrap_FXDriveBox_doesSaveUnder(int argc, VALUE *argv, VALUE self) { FXDriveBox *arg1 = (FXDriveBox *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDriveBox, 1);
    result = (FXbool)FXDriveBox_doesSaveUnder((FXDriveBox const *)arg1); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXDriveBox_setBackColor(int argc, VALUE *argv, VALUE self) { FXDriveBox *arg1 = (FXDriveBox *) 0 ;
    FXColor arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDriveBox, 1); arg2 = to_FXColor(argv[0]);
    FXDriveBox_setBackColor(arg1,arg2); return Qnil; }
static VALUE _wrap_FXDirSelector_onCmdName(int argc, VALUE *argv, VALUE self) { FXDirSelector *arg1 = (FXDirSelector *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDirSelector, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdName(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXDirSelector_onCmdOpened(int argc, VALUE *argv, VALUE self) { FXDirSelector *arg1 = (FXDirSelector *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDirSelector, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]);
    SWIG_ConvertPtr(argv[2],&arg4,SWIGTYPE_p_FXTreeItem,1); result = (long)(arg1)->onCmdOpened(arg2,arg3,arg4);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXDirSelector_onCmdHome(int argc, VALUE *argv, VALUE self) { FXDirSelector *arg1 = (FXDirSelector *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDirSelector, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdHome(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXDirSelector_onCmdWork(int argc, VALUE *argv, VALUE self) { FXDirSelector *arg1 = (FXDirSelector *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDirSelector, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdWork(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXDirSelector_onCmdDirectoryUp(int argc, VALUE *argv, VALUE self) {
    FXDirSelector *arg1 = (FXDirSelector *) 0 ; FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ;
    long result; VALUE vresult = Qnil; if ((argc < 3) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDirSelector, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdDirectoryUp(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE _wrap_FXDirSelector_allocate(VALUE self) {
#else
     static VALUE _wrap_FXDirSelector_allocate(int argc, VALUE *argv, VALUE self) {
#endif
         VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_FXDirSelector);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
         return vresult; }
static VALUE _wrap_new_FXDirSelector(int argc, VALUE *argv, VALUE self) { FXComposite *arg1 = (FXComposite *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 = (FXSelector) 0 ; FXuint arg4 = (FXuint) 0 ; FXint arg5 = (FXint) 0 ;
    FXint arg6 = (FXint) 0 ; FXint arg7 = (FXint) 0 ; FXint arg8 = (FXint) 0 ; FXDirSelector *result;
    if ((argc < 1) || (argc > 8)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXComposite, 1); if (argc > 1) {
        SWIG_ConvertPtr(argv[1], (void **) &arg2, SWIGTYPE_p_FXObject, 1); }  if (argc > 2) { arg3 = NUM2UINT(argv[2]); } 
    if (argc > 3) { arg4 = NUM2UINT(argv[3]); }  if (argc > 4) { arg5 = NUM2INT(argv[4]); }  if (argc > 5) {
        arg6 = NUM2INT(argv[5]); }  if (argc > 6) { arg7 = NUM2INT(argv[6]); }  if (argc > 7) { arg8 = NUM2INT(argv[7]); }  {
        result = (FXDirSelector *)new_FXDirSelector(arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8);
        DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result); if(rb_block_given_p()){ rb_yield(self); }  }  return self; }
static VALUE _wrap_FXDirSelector_acceptButton(int argc, VALUE *argv, VALUE self) { FXDirSelector *arg1 = (FXDirSelector *) 0 ;
    FXButton *result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDirSelector, 1);
    result = (FXButton *)((FXDirSelector const *)arg1)->acceptButton(); {
        swig_type_info *ty = SWIG_TypeDynamicCast(SWIGTYPE_p_FXButton, (void **) &result);
        vresult = FXRbGetRubyObj(result, ty); }  return vresult; }
static VALUE _wrap_FXDirSelector_cancelButton(int argc, VALUE *argv, VALUE self) { FXDirSelector *arg1 = (FXDirSelector *) 0 ;
    FXButton *result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDirSelector, 1);
    result = (FXButton *)((FXDirSelector const *)arg1)->cancelButton(); {
        swig_type_info *ty = SWIG_TypeDynamicCast(SWIGTYPE_p_FXButton, (void **) &result);
        vresult = FXRbGetRubyObj(result, ty); }  return vresult; }
static VALUE _wrap_FXDirSelector_setDirectory(int argc, VALUE *argv, VALUE self) { FXDirSelector *arg1 = (FXDirSelector *) 0 ;
    FXString *arg2 = 0 ; SwigValueWrapper<FXString > p2 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDirSelector, 1); p2 = to_FXString(argv[0]); arg2 = &p2;
    (arg1)->setDirectory((FXString const &)*arg2); return Qnil; }
static VALUE _wrap_FXDirSelector_getDirectory(int argc, VALUE *argv, VALUE self) { FXDirSelector *arg1 = (FXDirSelector *) 0 ;
    FXString result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDirSelector, 1); result = ((FXDirSelector const *)arg1)->getDirectory();
    vresult = rb_str_new2((&result)->text()); return vresult; }
static VALUE _wrap_FXDirSelector_setDirBoxStyle(int argc, VALUE *argv, VALUE self) { FXDirSelector *arg1 = (FXDirSelector *) 0 ;
    FXuint arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDirSelector, 1); arg2 = NUM2UINT(argv[0]); (arg1)->setDirBoxStyle(arg2);
    return Qnil; }
static VALUE _wrap_FXDirSelector_getDirBoxStyle(int argc, VALUE *argv, VALUE self) { FXDirSelector *arg1 = (FXDirSelector *) 0 ;
    FXuint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDirSelector, 1);
    result = (FXuint)((FXDirSelector const *)arg1)->getDirBoxStyle(); vresult = UINT2NUM(result); return vresult; }
static void
free_FXDirSelector(FXDirSelector *arg1) {
    delete arg1;
}
static VALUE _wrap_FXDirSelector_save(int argc, VALUE *argv, VALUE self) { FXDirSelector *arg1 = (FXDirSelector *) 0 ;
    FXStream *arg2 = 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDirSelector, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXDirSelector_save((FXDirSelector const *)arg1,*arg2); return Qnil; }
static VALUE _wrap_FXDirSelector_load(int argc, VALUE *argv, VALUE self) { FXDirSelector *arg1 = (FXDirSelector *) 0 ;
    FXStream *arg2 = 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDirSelector, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXDirSelector_load(arg1,*arg2); return Qnil; }
static VALUE _wrap_FXDirSelector_create(int argc, VALUE *argv, VALUE self) { FXDirSelector *arg1 = (FXDirSelector *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDirSelector, 1); FXDirSelector_create(arg1); return Qnil; }
static VALUE _wrap_FXDirSelector_detach(int argc, VALUE *argv, VALUE self) { FXDirSelector *arg1 = (FXDirSelector *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDirSelector, 1); FXDirSelector_detach(arg1); return Qnil; }
static VALUE _wrap_FXDirSelector_destroy(int argc, VALUE *argv, VALUE self) { FXDirSelector *arg1 = (FXDirSelector *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDirSelector, 1); FXDirSelector_destroy(arg1); return Qnil; }
static VALUE _wrap_FXDirSelector_resize(int argc, VALUE *argv, VALUE self) { FXDirSelector *arg1 = (FXDirSelector *) 0 ;
    FXint arg2 ; FXint arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDirSelector, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    FXDirSelector_resize(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXDirSelector_getDefaultWidth(int argc, VALUE *argv, VALUE self) {
    FXDirSelector *arg1 = (FXDirSelector *) 0 ; FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDirSelector, 1); result = (FXint)FXDirSelector_getDefaultWidth(arg1);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXDirSelector_getDefaultHeight(int argc, VALUE *argv, VALUE self) {
    FXDirSelector *arg1 = (FXDirSelector *) 0 ; FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDirSelector, 1); result = (FXint)FXDirSelector_getDefaultHeight(arg1);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXDirSelector_getWidthForHeight(int argc, VALUE *argv, VALUE self) {
    FXDirSelector *arg1 = (FXDirSelector *) 0 ; FXint arg2 ; FXint result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDirSelector, 1); arg2 = NUM2INT(argv[0]);
    result = (FXint)FXDirSelector_getWidthForHeight(arg1,arg2); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXDirSelector_getHeightForWidth(int argc, VALUE *argv, VALUE self) {
    FXDirSelector *arg1 = (FXDirSelector *) 0 ; FXint arg2 ; FXint result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDirSelector, 1); arg2 = NUM2INT(argv[0]);
    result = (FXint)FXDirSelector_getHeightForWidth(arg1,arg2); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXDirSelector_canFocus(int argc, VALUE *argv, VALUE self) { FXDirSelector *arg1 = (FXDirSelector *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDirSelector, 1);
    result = (FXbool)FXDirSelector_canFocus((FXDirSelector const *)arg1); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXDirSelector_setFocus(int argc, VALUE *argv, VALUE self) { FXDirSelector *arg1 = (FXDirSelector *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDirSelector, 1); FXDirSelector_setFocus(arg1); return Qnil; }
static VALUE _wrap_FXDirSelector_killFocus(int argc, VALUE *argv, VALUE self) { FXDirSelector *arg1 = (FXDirSelector *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDirSelector, 1); FXDirSelector_killFocus(arg1); return Qnil; }
static VALUE _wrap_FXDirSelector_setDefault(int argc, VALUE *argv, VALUE self) { FXDirSelector *arg1 = (FXDirSelector *) 0 ;
    FXbool arg2 = (FXbool) 1 ; if ((argc < 0) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDirSelector, 1); if (argc > 0) { arg2 = to_FXbool(argv[0]); } 
    FXDirSelector_setDefault(arg1,arg2); return Qnil; }
static VALUE _wrap_FXDirSelector_enable(int argc, VALUE *argv, VALUE self) { FXDirSelector *arg1 = (FXDirSelector *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDirSelector, 1); FXDirSelector_enable(arg1); return Qnil; }
static VALUE _wrap_FXDirSelector_disable(int argc, VALUE *argv, VALUE self) { FXDirSelector *arg1 = (FXDirSelector *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDirSelector, 1); FXDirSelector_disable(arg1); return Qnil; }
static VALUE _wrap_FXDirSelector_raiseWindow(int argc, VALUE *argv, VALUE self) { FXDirSelector *arg1 = (FXDirSelector *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDirSelector, 1); FXDirSelector_raise(arg1); return Qnil; }
static VALUE _wrap_FXDirSelector_lower(int argc, VALUE *argv, VALUE self) { FXDirSelector *arg1 = (FXDirSelector *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDirSelector, 1); FXDirSelector_lower(arg1); return Qnil; }
static VALUE _wrap_FXDirSelector_move(int argc, VALUE *argv, VALUE self) { FXDirSelector *arg1 = (FXDirSelector *) 0 ;
    FXint arg2 ; FXint arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDirSelector, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    FXDirSelector_move(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXDirSelector_position(int argc, VALUE *argv, VALUE self) { FXDirSelector *arg1 = (FXDirSelector *) 0 ;
    FXint arg2 ; FXint arg3 ; FXint arg4 ; FXint arg5 ; if ((argc < 4) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDirSelector, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    arg4 = NUM2INT(argv[2]); arg5 = NUM2INT(argv[3]); FXDirSelector_position(arg1,arg2,arg3,arg4,arg5); return Qnil; }
static VALUE _wrap_FXDirSelector_layout(int argc, VALUE *argv, VALUE self) { FXDirSelector *arg1 = (FXDirSelector *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDirSelector, 1); FXDirSelector_layout(arg1); return Qnil; }
static VALUE _wrap_FXDirSelector_recalc(int argc, VALUE *argv, VALUE self) { FXDirSelector *arg1 = (FXDirSelector *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDirSelector, 1); FXDirSelector_recalc(arg1); return Qnil; }
static VALUE _wrap_FXDirSelector_reparent(int argc, VALUE *argv, VALUE self) { FXDirSelector *arg1 = (FXDirSelector *) 0 ;
    FXComposite *arg2 = (FXComposite *) 0 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDirSelector, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXComposite, 1); FXDirSelector_reparent(arg1,arg2); return Qnil; }
static VALUE _wrap_FXDirSelector_show(int argc, VALUE *argv, VALUE self) { FXDirSelector *arg1 = (FXDirSelector *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDirSelector, 1); FXDirSelector_show(arg1); return Qnil; }
static VALUE _wrap_FXDirSelector_hide(int argc, VALUE *argv, VALUE self) { FXDirSelector *arg1 = (FXDirSelector *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDirSelector, 1); FXDirSelector_hide(arg1); return Qnil; }
static VALUE _wrap_FXDirSelector_isComposite(int argc, VALUE *argv, VALUE self) { FXDirSelector *arg1 = (FXDirSelector *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDirSelector, 1);
    result = (FXbool)FXDirSelector_isComposite((FXDirSelector const *)arg1); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXDirSelector_contains(int argc, VALUE *argv, VALUE self) { FXDirSelector *arg1 = (FXDirSelector *) 0 ;
    FXint arg2 ; FXint arg3 ; FXbool result; VALUE vresult = Qnil; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDirSelector, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    result = (FXbool)FXDirSelector_contains((FXDirSelector const *)arg1,arg2,arg3); vresult = result ? Qtrue : Qfalse;
    return vresult; }
static VALUE _wrap_FXDirSelector_doesSaveUnder(int argc, VALUE *argv, VALUE self) { FXDirSelector *arg1 = (FXDirSelector *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDirSelector, 1);
    result = (FXbool)FXDirSelector_doesSaveUnder((FXDirSelector const *)arg1); vresult = result ? Qtrue : Qfalse;
    return vresult; }
static VALUE _wrap_FXDirSelector_setBackColor(int argc, VALUE *argv, VALUE self) { FXDirSelector *arg1 = (FXDirSelector *) 0 ;
    FXColor arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDirSelector, 1); arg2 = to_FXColor(argv[0]);
    FXDirSelector_setBackColor(arg1,arg2); return Qnil; }
static VALUE _wrap_FXFileSelector_onCmdAccept(int argc, VALUE *argv, VALUE self) { FXFileSelector *arg1 = (FXFileSelector *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileSelector, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdAccept(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXFileSelector_onCmdFilter(int argc, VALUE *argv, VALUE self) { FXFileSelector *arg1 = (FXFileSelector *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileSelector, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]);
    arg4 = static_cast<void*>(STR2CSTR(argv[2])); result = (long)(arg1)->onCmdFilter(arg2,arg3,arg4); vresult = INT2NUM(result);
    return vresult; }
static VALUE _wrap_FXFileSelector_onCmdItemDblClicked(int argc, VALUE *argv, VALUE self) {
    FXFileSelector *arg1 = (FXFileSelector *) 0 ; FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ;
    long result; VALUE vresult = Qnil; if ((argc < 3) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileSelector, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]);
    arg4 = reinterpret_cast<void*>(NUM2INT(argv[2])); result = (long)(arg1)->onCmdItemDblClicked(arg2,arg3,arg4);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXFileSelector_onCmdItemSelected(int argc, VALUE *argv, VALUE self) {
    FXFileSelector *arg1 = (FXFileSelector *) 0 ; FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ;
    long result; VALUE vresult = Qnil; if ((argc < 3) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileSelector, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]);
    arg4 = reinterpret_cast<void*>(NUM2INT(argv[2])); result = (long)(arg1)->onCmdItemSelected(arg2,arg3,arg4);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXFileSelector_onCmdItemDeselected(int argc, VALUE *argv, VALUE self) {
    FXFileSelector *arg1 = (FXFileSelector *) 0 ; FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ;
    long result; VALUE vresult = Qnil; if ((argc < 3) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileSelector, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdItemDeselected(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXFileSelector_onCmdDirectoryUp(int argc, VALUE *argv, VALUE self) {
    FXFileSelector *arg1 = (FXFileSelector *) 0 ; FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ;
    long result; VALUE vresult = Qnil; if ((argc < 3) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileSelector, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdDirectoryUp(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXFileSelector_onUpdDirectoryUp(int argc, VALUE *argv, VALUE self) {
    FXFileSelector *arg1 = (FXFileSelector *) 0 ; FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ;
    long result; VALUE vresult = Qnil; if ((argc < 3) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileSelector, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onUpdDirectoryUp(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXFileSelector_onCmdDirTree(int argc, VALUE *argv, VALUE self) {
    FXFileSelector *arg1 = (FXFileSelector *) 0 ; FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ;
    long result; VALUE vresult = Qnil; if ((argc < 3) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileSelector, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]);
    arg4 = static_cast<void*>(STR2CSTR(argv[2])); result = (long)(arg1)->onCmdDirTree(arg2,arg3,arg4);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXFileSelector_onCmdHome(int argc, VALUE *argv, VALUE self) { FXFileSelector *arg1 = (FXFileSelector *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileSelector, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdHome(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXFileSelector_onCmdWork(int argc, VALUE *argv, VALUE self) { FXFileSelector *arg1 = (FXFileSelector *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileSelector, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdWork(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXFileSelector_onCmdBookmark(int argc, VALUE *argv, VALUE self) {
    FXFileSelector *arg1 = (FXFileSelector *) 0 ; FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ;
    long result; VALUE vresult = Qnil; if ((argc < 3) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileSelector, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdBookmark(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXFileSelector_onCmdVisit(int argc, VALUE *argv, VALUE self) { FXFileSelector *arg1 = (FXFileSelector *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileSelector, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]);
    arg4 = static_cast<void*>(STR2CSTR(argv[2])); result = (long)(arg1)->onCmdVisit(arg2,arg3,arg4); vresult = INT2NUM(result);
    return vresult; }
static VALUE _wrap_FXFileSelector_onCmdNew(int argc, VALUE *argv, VALUE self) { FXFileSelector *arg1 = (FXFileSelector *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileSelector, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdNew(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXFileSelector_onUpdNew(int argc, VALUE *argv, VALUE self) { FXFileSelector *arg1 = (FXFileSelector *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileSelector, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onUpdNew(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXFileSelector_onCmdMove(int argc, VALUE *argv, VALUE self) { FXFileSelector *arg1 = (FXFileSelector *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileSelector, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdMove(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXFileSelector_onCmdCopy(int argc, VALUE *argv, VALUE self) { FXFileSelector *arg1 = (FXFileSelector *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileSelector, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdCopy(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXFileSelector_onCmdLink(int argc, VALUE *argv, VALUE self) { FXFileSelector *arg1 = (FXFileSelector *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileSelector, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdLink(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXFileSelector_onCmdDelete(int argc, VALUE *argv, VALUE self) { FXFileSelector *arg1 = (FXFileSelector *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileSelector, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdDelete(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXFileSelector_onUpdSelected(int argc, VALUE *argv, VALUE self) {
    FXFileSelector *arg1 = (FXFileSelector *) 0 ; FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ;
    long result; VALUE vresult = Qnil; if ((argc < 3) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileSelector, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onUpdSelected(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXFileSelector_onPopupMenu(int argc, VALUE *argv, VALUE self) { FXFileSelector *arg1 = (FXFileSelector *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileSelector, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onPopupMenu(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE _wrap_FXFileSelector_allocate(VALUE self) {
#else
     static VALUE _wrap_FXFileSelector_allocate(int argc, VALUE *argv, VALUE self) {
#endif
         VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_FXFileSelector);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
         return vresult; }
static VALUE _wrap_new_FXFileSelector(int argc, VALUE *argv, VALUE self) { FXComposite *arg1 = (FXComposite *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 = (FXSelector) 0 ; FXuint arg4 = (FXuint) 0 ; FXint arg5 = (FXint) 0 ;
    FXint arg6 = (FXint) 0 ; FXint arg7 = (FXint) 0 ; FXint arg8 = (FXint) 0 ; FXFileSelector *result;
    if ((argc < 1) || (argc > 8)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXComposite, 1); if (argc > 1) {
        SWIG_ConvertPtr(argv[1], (void **) &arg2, SWIGTYPE_p_FXObject, 1); }  if (argc > 2) { arg3 = NUM2UINT(argv[2]); } 
    if (argc > 3) { arg4 = NUM2UINT(argv[3]); }  if (argc > 4) { arg5 = NUM2INT(argv[4]); }  if (argc > 5) {
        arg6 = NUM2INT(argv[5]); }  if (argc > 6) { arg7 = NUM2INT(argv[6]); }  if (argc > 7) { arg8 = NUM2INT(argv[7]); }  {
        result = (FXFileSelector *)new_FXFileSelector(arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8);
        DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result); if(rb_block_given_p()){ rb_yield(self); }  }  return self; }
static VALUE _wrap_FXFileSelector_acceptButton(int argc, VALUE *argv, VALUE self) {
    FXFileSelector *arg1 = (FXFileSelector *) 0 ; FXButton *result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileSelector, 1);
    result = (FXButton *)((FXFileSelector const *)arg1)->acceptButton(); {
        swig_type_info *ty = SWIG_TypeDynamicCast(SWIGTYPE_p_FXButton, (void **) &result);
        vresult = FXRbGetRubyObj(result, ty); }  return vresult; }
static VALUE _wrap_FXFileSelector_cancelButton(int argc, VALUE *argv, VALUE self) {
    FXFileSelector *arg1 = (FXFileSelector *) 0 ; FXButton *result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileSelector, 1);
    result = (FXButton *)((FXFileSelector const *)arg1)->cancelButton(); {
        swig_type_info *ty = SWIG_TypeDynamicCast(SWIGTYPE_p_FXButton, (void **) &result);
        vresult = FXRbGetRubyObj(result, ty); }  return vresult; }
static VALUE _wrap_FXFileSelector_setFilename(int argc, VALUE *argv, VALUE self) { FXFileSelector *arg1 = (FXFileSelector *) 0 ;
    FXString *arg2 = 0 ; SwigValueWrapper<FXString > p2 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileSelector, 1); p2 = to_FXString(argv[0]); arg2 = &p2;
    (arg1)->setFilename((FXString const &)*arg2); return Qnil; }
static VALUE _wrap_FXFileSelector_getFilename(int argc, VALUE *argv, VALUE self) { FXFileSelector *arg1 = (FXFileSelector *) 0 ;
    FXString result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileSelector, 1);
    result = ((FXFileSelector const *)arg1)->getFilename(); vresult = rb_str_new2((&result)->text()); return vresult; }
static VALUE _wrap_FXFileSelector_getFilenames(int argc, VALUE *argv, VALUE self) {
    FXFileSelector *arg1 = (FXFileSelector *) 0 ; VALUE result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileSelector, 1);
    result = (VALUE)FXFileSelector_getFilenames((FXFileSelector const *)arg1); vresult = result; return vresult; }
static VALUE _wrap_FXFileSelector_setPattern(int argc, VALUE *argv, VALUE self) { FXFileSelector *arg1 = (FXFileSelector *) 0 ;
    FXString *arg2 = 0 ; SwigValueWrapper<FXString > p2 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileSelector, 1); p2 = to_FXString(argv[0]); arg2 = &p2;
    (arg1)->setPattern((FXString const &)*arg2); return Qnil; }
static VALUE _wrap_FXFileSelector_getPattern(int argc, VALUE *argv, VALUE self) { FXFileSelector *arg1 = (FXFileSelector *) 0 ;
    FXString result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileSelector, 1); result = ((FXFileSelector const *)arg1)->getPattern();
    vresult = rb_str_new2((&result)->text()); return vresult; }
static VALUE _wrap_FXFileSelector_setPatternList(int argc, VALUE *argv, VALUE self) {
    FXFileSelector *arg1 = (FXFileSelector *) 0 ; VALUE arg2 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileSelector, 1); arg2 = argv[0];
    FXFileSelector_setPatternList(arg1,arg2); return Qnil; }
static VALUE _wrap_FXFileSelector_getPatternList(int argc, VALUE *argv, VALUE self) {
    FXFileSelector *arg1 = (FXFileSelector *) 0 ; VALUE result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileSelector, 1);
    result = (VALUE)FXFileSelector_getPatternList((FXFileSelector const *)arg1); vresult = result; return vresult; }
static VALUE _wrap_FXFileSelector_setCurrentPattern(int argc, VALUE *argv, VALUE self) {
    FXFileSelector *arg1 = (FXFileSelector *) 0 ; FXint arg2 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileSelector, 1); arg2 = NUM2INT(argv[0]);
    (arg1)->setCurrentPattern(arg2); return Qnil; }
static VALUE _wrap_FXFileSelector_getCurrentPattern(int argc, VALUE *argv, VALUE self) {
    FXFileSelector *arg1 = (FXFileSelector *) 0 ; FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileSelector, 1);
    result = (FXint)((FXFileSelector const *)arg1)->getCurrentPattern(); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXFileSelector_getPatternText(int argc, VALUE *argv, VALUE self) {
    FXFileSelector *arg1 = (FXFileSelector *) 0 ; FXint arg2 ; FXString result; VALUE vresult = Qnil;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileSelector, 1); arg2 = NUM2INT(argv[0]);
    result = ((FXFileSelector const *)arg1)->getPatternText(arg2); vresult = rb_str_new2((&result)->text()); return vresult; }
static VALUE _wrap_FXFileSelector_setPatternText(int argc, VALUE *argv, VALUE self) {
    FXFileSelector *arg1 = (FXFileSelector *) 0 ; FXint arg2 ; FXString *arg3 = 0 ; SwigValueWrapper<FXString > p3 ;
    if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileSelector, 1); arg2 = NUM2INT(argv[0]);
    p3 = to_FXString(argv[1]); arg3 = &p3; (arg1)->setPatternText(arg2,(FXString const &)*arg3); return Qnil; }
static VALUE _wrap_FXFileSelector_setDirectory(int argc, VALUE *argv, VALUE self) {
    FXFileSelector *arg1 = (FXFileSelector *) 0 ; FXString *arg2 = 0 ; SwigValueWrapper<FXString > p2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileSelector, 1); p2 = to_FXString(argv[0]); arg2 = &p2;
    (arg1)->setDirectory((FXString const &)*arg2); return Qnil; }
static VALUE _wrap_FXFileSelector_getDirectory(int argc, VALUE *argv, VALUE self) {
    FXFileSelector *arg1 = (FXFileSelector *) 0 ; FXString result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileSelector, 1);
    result = ((FXFileSelector const *)arg1)->getDirectory(); vresult = rb_str_new2((&result)->text()); return vresult; }
static VALUE _wrap_FXFileSelector_patternFromText(int argc, VALUE *argv, VALUE self) { FXString *arg1 = 0 ; FXString result;
    SwigValueWrapper<FXString > p1 ; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc); p1 = to_FXString(argv[0]); arg1 = &p1;
    result = FXFileSelector::patternFromText((FXString const &)*arg1); vresult = rb_str_new2((&result)->text());
    return vresult; }
static VALUE _wrap_FXFileSelector_extensionFromPattern(int argc, VALUE *argv, VALUE self) { FXString *arg1 = 0 ;
    FXString result; SwigValueWrapper<FXString > p1 ; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc); p1 = to_FXString(argv[0]); arg1 = &p1;
    result = FXFileSelector::extensionFromPattern((FXString const &)*arg1); vresult = rb_str_new2((&result)->text());
    return vresult; }
static VALUE _wrap_FXFileSelector_setItemSpace(int argc, VALUE *argv, VALUE self) {
    FXFileSelector *arg1 = (FXFileSelector *) 0 ; FXint arg2 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileSelector, 1); arg2 = NUM2INT(argv[0]); (arg1)->setItemSpace(arg2);
    return Qnil; }
static VALUE _wrap_FXFileSelector_getItemSpace(int argc, VALUE *argv, VALUE self) {
    FXFileSelector *arg1 = (FXFileSelector *) 0 ; FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileSelector, 1);
    result = (FXint)((FXFileSelector const *)arg1)->getItemSpace(); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXFileSelector_setFileBoxStyle(int argc, VALUE *argv, VALUE self) {
    FXFileSelector *arg1 = (FXFileSelector *) 0 ; FXuint arg2 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileSelector, 1); arg2 = NUM2UINT(argv[0]);
    (arg1)->setFileBoxStyle(arg2); return Qnil; }
static VALUE _wrap_FXFileSelector_getFileBoxStyle(int argc, VALUE *argv, VALUE self) {
    FXFileSelector *arg1 = (FXFileSelector *) 0 ; FXuint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileSelector, 1);
    result = (FXuint)((FXFileSelector const *)arg1)->getFileBoxStyle(); vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXFileSelector_setSelectMode(int argc, VALUE *argv, VALUE self) {
    FXFileSelector *arg1 = (FXFileSelector *) 0 ; FXuint arg2 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileSelector, 1); arg2 = NUM2UINT(argv[0]); (arg1)->setSelectMode(arg2);
    return Qnil; }
static VALUE _wrap_FXFileSelector_getSelectMode(int argc, VALUE *argv, VALUE self) {
    FXFileSelector *arg1 = (FXFileSelector *) 0 ; FXuint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileSelector, 1);
    result = (FXuint)((FXFileSelector const *)arg1)->getSelectMode(); vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXFileSelector_setMatchMode(int argc, VALUE *argv, VALUE self) {
    FXFileSelector *arg1 = (FXFileSelector *) 0 ; FXuint arg2 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileSelector, 1); arg2 = NUM2UINT(argv[0]); (arg1)->setMatchMode(arg2);
    return Qnil; }
static VALUE _wrap_FXFileSelector_getMatchMode(int argc, VALUE *argv, VALUE self) {
    FXFileSelector *arg1 = (FXFileSelector *) 0 ; FXuint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileSelector, 1);
    result = (FXuint)((FXFileSelector const *)arg1)->getMatchMode(); vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXFileSelector_setReadOnlyShown(int argc, VALUE *argv, VALUE self) {
    FXFileSelector *arg1 = (FXFileSelector *) 0 ; FXbool arg2 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileSelector, 1); arg2 = to_FXbool(argv[0]); (arg1)->showReadOnly(arg2);
    return Qnil; }
static VALUE _wrap_FXFileSelector_getReadOnlyShown(int argc, VALUE *argv, VALUE self) {
    FXFileSelector *arg1 = (FXFileSelector *) 0 ; FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileSelector, 1);
    result = (FXbool)((FXFileSelector const *)arg1)->shownReadOnly(); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXFileSelector_setReadOnly(int argc, VALUE *argv, VALUE self) { FXFileSelector *arg1 = (FXFileSelector *) 0 ;
    FXbool arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileSelector, 1); arg2 = to_FXbool(argv[0]); (arg1)->setReadOnly(arg2);
    return Qnil; }
static VALUE _wrap_FXFileSelector_getReadOnly(int argc, VALUE *argv, VALUE self) { FXFileSelector *arg1 = (FXFileSelector *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileSelector, 1);
    result = (FXbool)((FXFileSelector const *)arg1)->getReadOnly(); vresult = result ? Qtrue : Qfalse; return vresult; }
static void
free_FXFileSelector(FXFileSelector *arg1) {
    delete arg1;
}
static VALUE _wrap_FXFileSelector_save(int argc, VALUE *argv, VALUE self) { FXFileSelector *arg1 = (FXFileSelector *) 0 ;
    FXStream *arg2 = 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileSelector, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXFileSelector_save((FXFileSelector const *)arg1,*arg2); return Qnil; }
static VALUE _wrap_FXFileSelector_load(int argc, VALUE *argv, VALUE self) { FXFileSelector *arg1 = (FXFileSelector *) 0 ;
    FXStream *arg2 = 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileSelector, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXFileSelector_load(arg1,*arg2); return Qnil; }
static VALUE _wrap_FXFileSelector_create(int argc, VALUE *argv, VALUE self) { FXFileSelector *arg1 = (FXFileSelector *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileSelector, 1); FXFileSelector_create(arg1); return Qnil; }
static VALUE _wrap_FXFileSelector_detach(int argc, VALUE *argv, VALUE self) { FXFileSelector *arg1 = (FXFileSelector *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileSelector, 1); FXFileSelector_detach(arg1); return Qnil; }
static VALUE _wrap_FXFileSelector_destroy(int argc, VALUE *argv, VALUE self) { FXFileSelector *arg1 = (FXFileSelector *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileSelector, 1); FXFileSelector_destroy(arg1); return Qnil; }
static VALUE _wrap_FXFileSelector_resize(int argc, VALUE *argv, VALUE self) { FXFileSelector *arg1 = (FXFileSelector *) 0 ;
    FXint arg2 ; FXint arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileSelector, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    FXFileSelector_resize(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXFileSelector_getDefaultWidth(int argc, VALUE *argv, VALUE self) {
    FXFileSelector *arg1 = (FXFileSelector *) 0 ; FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileSelector, 1); result = (FXint)FXFileSelector_getDefaultWidth(arg1);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXFileSelector_getDefaultHeight(int argc, VALUE *argv, VALUE self) {
    FXFileSelector *arg1 = (FXFileSelector *) 0 ; FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileSelector, 1); result = (FXint)FXFileSelector_getDefaultHeight(arg1);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXFileSelector_getWidthForHeight(int argc, VALUE *argv, VALUE self) {
    FXFileSelector *arg1 = (FXFileSelector *) 0 ; FXint arg2 ; FXint result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileSelector, 1); arg2 = NUM2INT(argv[0]);
    result = (FXint)FXFileSelector_getWidthForHeight(arg1,arg2); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXFileSelector_getHeightForWidth(int argc, VALUE *argv, VALUE self) {
    FXFileSelector *arg1 = (FXFileSelector *) 0 ; FXint arg2 ; FXint result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileSelector, 1); arg2 = NUM2INT(argv[0]);
    result = (FXint)FXFileSelector_getHeightForWidth(arg1,arg2); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXFileSelector_canFocus(int argc, VALUE *argv, VALUE self) { FXFileSelector *arg1 = (FXFileSelector *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileSelector, 1);
    result = (FXbool)FXFileSelector_canFocus((FXFileSelector const *)arg1); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXFileSelector_setFocus(int argc, VALUE *argv, VALUE self) { FXFileSelector *arg1 = (FXFileSelector *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileSelector, 1); FXFileSelector_setFocus(arg1); return Qnil; }
static VALUE _wrap_FXFileSelector_killFocus(int argc, VALUE *argv, VALUE self) { FXFileSelector *arg1 = (FXFileSelector *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileSelector, 1); FXFileSelector_killFocus(arg1); return Qnil; }
static VALUE _wrap_FXFileSelector_setDefault(int argc, VALUE *argv, VALUE self) { FXFileSelector *arg1 = (FXFileSelector *) 0 ;
    FXbool arg2 = (FXbool) 1 ; if ((argc < 0) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileSelector, 1); if (argc > 0) { arg2 = to_FXbool(argv[0]); } 
    FXFileSelector_setDefault(arg1,arg2); return Qnil; }
static VALUE _wrap_FXFileSelector_enable(int argc, VALUE *argv, VALUE self) { FXFileSelector *arg1 = (FXFileSelector *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileSelector, 1); FXFileSelector_enable(arg1); return Qnil; }
static VALUE _wrap_FXFileSelector_disable(int argc, VALUE *argv, VALUE self) { FXFileSelector *arg1 = (FXFileSelector *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileSelector, 1); FXFileSelector_disable(arg1); return Qnil; }
static VALUE _wrap_FXFileSelector_raiseWindow(int argc, VALUE *argv, VALUE self) { FXFileSelector *arg1 = (FXFileSelector *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileSelector, 1); FXFileSelector_raise(arg1); return Qnil; }
static VALUE _wrap_FXFileSelector_lower(int argc, VALUE *argv, VALUE self) { FXFileSelector *arg1 = (FXFileSelector *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileSelector, 1); FXFileSelector_lower(arg1); return Qnil; }
static VALUE _wrap_FXFileSelector_move(int argc, VALUE *argv, VALUE self) { FXFileSelector *arg1 = (FXFileSelector *) 0 ;
    FXint arg2 ; FXint arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileSelector, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    FXFileSelector_move(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXFileSelector_position(int argc, VALUE *argv, VALUE self) { FXFileSelector *arg1 = (FXFileSelector *) 0 ;
    FXint arg2 ; FXint arg3 ; FXint arg4 ; FXint arg5 ; if ((argc < 4) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileSelector, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    arg4 = NUM2INT(argv[2]); arg5 = NUM2INT(argv[3]); FXFileSelector_position(arg1,arg2,arg3,arg4,arg5); return Qnil; }
static VALUE _wrap_FXFileSelector_layout(int argc, VALUE *argv, VALUE self) { FXFileSelector *arg1 = (FXFileSelector *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileSelector, 1); FXFileSelector_layout(arg1); return Qnil; }
static VALUE _wrap_FXFileSelector_recalc(int argc, VALUE *argv, VALUE self) { FXFileSelector *arg1 = (FXFileSelector *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileSelector, 1); FXFileSelector_recalc(arg1); return Qnil; }
static VALUE _wrap_FXFileSelector_reparent(int argc, VALUE *argv, VALUE self) { FXFileSelector *arg1 = (FXFileSelector *) 0 ;
    FXComposite *arg2 = (FXComposite *) 0 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileSelector, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXComposite, 1); FXFileSelector_reparent(arg1,arg2); return Qnil; }
static VALUE _wrap_FXFileSelector_show(int argc, VALUE *argv, VALUE self) { FXFileSelector *arg1 = (FXFileSelector *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileSelector, 1); FXFileSelector_show(arg1); return Qnil; }
static VALUE _wrap_FXFileSelector_hide(int argc, VALUE *argv, VALUE self) { FXFileSelector *arg1 = (FXFileSelector *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileSelector, 1); FXFileSelector_hide(arg1); return Qnil; }
static VALUE _wrap_FXFileSelector_isComposite(int argc, VALUE *argv, VALUE self) { FXFileSelector *arg1 = (FXFileSelector *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileSelector, 1);
    result = (FXbool)FXFileSelector_isComposite((FXFileSelector const *)arg1); vresult = result ? Qtrue : Qfalse;
    return vresult; }
static VALUE _wrap_FXFileSelector_contains(int argc, VALUE *argv, VALUE self) { FXFileSelector *arg1 = (FXFileSelector *) 0 ;
    FXint arg2 ; FXint arg3 ; FXbool result; VALUE vresult = Qnil; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileSelector, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    result = (FXbool)FXFileSelector_contains((FXFileSelector const *)arg1,arg2,arg3); vresult = result ? Qtrue : Qfalse;
    return vresult; }
static VALUE _wrap_FXFileSelector_doesSaveUnder(int argc, VALUE *argv, VALUE self) {
    FXFileSelector *arg1 = (FXFileSelector *) 0 ; FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileSelector, 1);
    result = (FXbool)FXFileSelector_doesSaveUnder((FXFileSelector const *)arg1); vresult = result ? Qtrue : Qfalse;
    return vresult; }
static VALUE _wrap_FXFileSelector_setBackColor(int argc, VALUE *argv, VALUE self) {
    FXFileSelector *arg1 = (FXFileSelector *) 0 ; FXColor arg2 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileSelector, 1); arg2 = to_FXColor(argv[0]);
    FXFileSelector_setBackColor(arg1,arg2); return Qnil; }
static VALUE _wrap_FXColorSelector_onCmdColor(int argc, VALUE *argv, VALUE self) {
    FXColorSelector *arg1 = (FXColorSelector *) 0 ; FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ;
    void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil; if ((argc < 3) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorSelector, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdColor(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXColorSelector_onChgColor(int argc, VALUE *argv, VALUE self) {
    FXColorSelector *arg1 = (FXColorSelector *) 0 ; FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ;
    void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil; if ((argc < 3) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorSelector, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onChgColor(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXColorSelector_onCmdWell(int argc, VALUE *argv, VALUE self) {
    FXColorSelector *arg1 = (FXColorSelector *) 0 ; FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ;
    void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil; if ((argc < 3) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorSelector, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdWell(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXColorSelector_onChgWell(int argc, VALUE *argv, VALUE self) {
    FXColorSelector *arg1 = (FXColorSelector *) 0 ; FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ;
    void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil; if ((argc < 3) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorSelector, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]);
    arg4 = reinterpret_cast<void*>(NUM2UINT(argv[2])); result = (long)(arg1)->onChgWell(arg2,arg3,arg4);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXColorSelector_onCmdRGBSlider(int argc, VALUE *argv, VALUE self) {
    FXColorSelector *arg1 = (FXColorSelector *) 0 ; FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ;
    void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil; if ((argc < 3) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorSelector, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdRGBSlider(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXColorSelector_onUpdRGBSlider(int argc, VALUE *argv, VALUE self) {
    FXColorSelector *arg1 = (FXColorSelector *) 0 ; FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ;
    void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil; if ((argc < 3) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorSelector, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onUpdRGBSlider(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXColorSelector_onCmdRGBText(int argc, VALUE *argv, VALUE self) {
    FXColorSelector *arg1 = (FXColorSelector *) 0 ; FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ;
    void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil; if ((argc < 3) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorSelector, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdRGBText(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXColorSelector_onUpdRGBText(int argc, VALUE *argv, VALUE self) {
    FXColorSelector *arg1 = (FXColorSelector *) 0 ; FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ;
    void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil; if ((argc < 3) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorSelector, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onUpdRGBText(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXColorSelector_onCmdHSVSlider(int argc, VALUE *argv, VALUE self) {
    FXColorSelector *arg1 = (FXColorSelector *) 0 ; FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ;
    void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil; if ((argc < 3) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorSelector, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdHSVSlider(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXColorSelector_onUpdHSVSlider(int argc, VALUE *argv, VALUE self) {
    FXColorSelector *arg1 = (FXColorSelector *) 0 ; FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ;
    void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil; if ((argc < 3) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorSelector, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onUpdHSVSlider(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXColorSelector_onCmdHSVText(int argc, VALUE *argv, VALUE self) {
    FXColorSelector *arg1 = (FXColorSelector *) 0 ; FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ;
    void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil; if ((argc < 3) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorSelector, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdHSVText(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXColorSelector_onUpdHSVText(int argc, VALUE *argv, VALUE self) {
    FXColorSelector *arg1 = (FXColorSelector *) 0 ; FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ;
    void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil; if ((argc < 3) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorSelector, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onUpdHSVText(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXColorSelector_onCmdCMYSlider(int argc, VALUE *argv, VALUE self) {
    FXColorSelector *arg1 = (FXColorSelector *) 0 ; FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ;
    void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil; if ((argc < 3) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorSelector, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdCMYSlider(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXColorSelector_onUpdCMYSlider(int argc, VALUE *argv, VALUE self) {
    FXColorSelector *arg1 = (FXColorSelector *) 0 ; FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ;
    void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil; if ((argc < 3) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorSelector, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onUpdCMYSlider(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXColorSelector_onCmdCMYText(int argc, VALUE *argv, VALUE self) {
    FXColorSelector *arg1 = (FXColorSelector *) 0 ; FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ;
    void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil; if ((argc < 3) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorSelector, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdCMYText(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXColorSelector_onUpdCMYText(int argc, VALUE *argv, VALUE self) {
    FXColorSelector *arg1 = (FXColorSelector *) 0 ; FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ;
    void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil; if ((argc < 3) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorSelector, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onUpdCMYText(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXColorSelector_onCmdList(int argc, VALUE *argv, VALUE self) {
    FXColorSelector *arg1 = (FXColorSelector *) 0 ; FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ;
    void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil; if ((argc < 3) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorSelector, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]);
    arg4 = reinterpret_cast<void*>(NUM2INT(argv[2])); result = (long)(arg1)->onCmdList(arg2,arg3,arg4);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXColorSelector_onCmdCustomWell(int argc, VALUE *argv, VALUE self) {
    FXColorSelector *arg1 = (FXColorSelector *) 0 ; FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ;
    void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil; if ((argc < 3) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorSelector, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]);
    arg4 = reinterpret_cast<void*>(NUM2UINT(argv[2])); result = (long)(arg1)->onCmdCustomWell(arg2,arg3,arg4);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXColorSelector_onChgCustomWell(int argc, VALUE *argv, VALUE self) {
    FXColorSelector *arg1 = (FXColorSelector *) 0 ; FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ;
    void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil; if ((argc < 3) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorSelector, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]);
    arg4 = reinterpret_cast<void*>(NUM2UINT(argv[2])); result = (long)(arg1)->onChgCustomWell(arg2,arg3,arg4);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXColorSelector_onCmdSetValue(int argc, VALUE *argv, VALUE self) {
    FXColorSelector *arg1 = (FXColorSelector *) 0 ; FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ;
    void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil; if ((argc < 3) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorSelector, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]);
    arg4 = reinterpret_cast<void*>(NUM2UINT(argv[2])); result = (long)(arg1)->onCmdSetValue(arg2,arg3,arg4);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXColorSelector_onCmdActivePane(int argc, VALUE *argv, VALUE self) {
    FXColorSelector *arg1 = (FXColorSelector *) 0 ; FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ;
    void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil; if ((argc < 3) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorSelector, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]);
    arg4 = reinterpret_cast<void*>(NUM2INT(argv[2])); result = (long)(arg1)->onCmdActivePane(arg2,arg3,arg4);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXColorSelector_onCmdAlphaSlider(int argc, VALUE *argv, VALUE self) {
    FXColorSelector *arg1 = (FXColorSelector *) 0 ; FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ;
    void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil; if ((argc < 3) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorSelector, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdAlphaSlider(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXColorSelector_onUpdAlphaSlider(int argc, VALUE *argv, VALUE self) {
    FXColorSelector *arg1 = (FXColorSelector *) 0 ; FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ;
    void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil; if ((argc < 3) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorSelector, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onUpdAlphaSlider(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXColorSelector_onCmdAlphaText(int argc, VALUE *argv, VALUE self) {
    FXColorSelector *arg1 = (FXColorSelector *) 0 ; FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ;
    void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil; if ((argc < 3) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorSelector, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdAlphaText(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXColorSelector_onUpdAlphaText(int argc, VALUE *argv, VALUE self) {
    FXColorSelector *arg1 = (FXColorSelector *) 0 ; FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ;
    void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil; if ((argc < 3) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorSelector, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onUpdAlphaText(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXColorSelector_onUpdAlphaLabel(int argc, VALUE *argv, VALUE self) {
    FXColorSelector *arg1 = (FXColorSelector *) 0 ; FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ;
    void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil; if ((argc < 3) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorSelector, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onUpdAlphaLabel(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXColorSelector_onCmdWheel(int argc, VALUE *argv, VALUE self) {
    FXColorSelector *arg1 = (FXColorSelector *) 0 ; FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ;
    void *arg4 = (void *) 0 ; long result; FXfloat values4[3] ; VALUE vresult = Qnil; if ((argc < 3) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorSelector, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); { Check_Type(argv[2], T_ARRAY);
        values4[0] = (FXfloat) NUM2DBL(rb_ary_entry(argv[2], 0)); values4[1] = (FXfloat) NUM2DBL(rb_ary_entry(argv[2], 1));
        values4[2] = (FXfloat) NUM2DBL(rb_ary_entry(argv[2], 2)); arg4 = (void *) values4; } 
    result = (long)(arg1)->onCmdWheel(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXColorSelector_onUpdWheel(int argc, VALUE *argv, VALUE self) {
    FXColorSelector *arg1 = (FXColorSelector *) 0 ; FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ;
    void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil; if ((argc < 3) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorSelector, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onUpdWheel(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXColorSelector_onCmdBar(int argc, VALUE *argv, VALUE self) { FXColorSelector *arg1 = (FXColorSelector *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; FXfloat values4[3] ;
    VALUE vresult = Qnil; if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorSelector, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); { Check_Type(argv[2], T_ARRAY);
        values4[0] = (FXfloat) NUM2DBL(rb_ary_entry(argv[2], 0)); values4[1] = (FXfloat) NUM2DBL(rb_ary_entry(argv[2], 1));
        values4[2] = (FXfloat) NUM2DBL(rb_ary_entry(argv[2], 2)); arg4 = (void *) values4; } 
    result = (long)(arg1)->onCmdBar(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXColorSelector_onUpdBar(int argc, VALUE *argv, VALUE self) { FXColorSelector *arg1 = (FXColorSelector *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorSelector, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onUpdBar(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXColorSelector_onCmdColorPick(int argc, VALUE *argv, VALUE self) {
    FXColorSelector *arg1 = (FXColorSelector *) 0 ; FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ;
    void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil; if ((argc < 3) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorSelector, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]);
    arg4 = FXRbConvertPtr(argv[2], FXRbTypeQuery("FXPoint *")); result = (long)(arg1)->onCmdColorPick(arg2,arg3,arg4);
    vresult = INT2NUM(result); return vresult; }
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE _wrap_FXColorSelector_allocate(VALUE self) {
#else
     static VALUE _wrap_FXColorSelector_allocate(int argc, VALUE *argv, VALUE self) {
#endif
         VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_FXColorSelector);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
         return vresult; }
static VALUE _wrap_new_FXColorSelector(int argc, VALUE *argv, VALUE self) { FXComposite *arg1 = (FXComposite *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 = (FXSelector) 0 ; FXuint arg4 = (FXuint) 0 ; FXint arg5 = (FXint) 0 ;
    FXint arg6 = (FXint) 0 ; FXint arg7 = (FXint) 0 ; FXint arg8 = (FXint) 0 ; FXColorSelector *result;
    if ((argc < 1) || (argc > 8)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXComposite, 1); if (argc > 1) {
        SWIG_ConvertPtr(argv[1], (void **) &arg2, SWIGTYPE_p_FXObject, 1); }  if (argc > 2) { arg3 = NUM2UINT(argv[2]); } 
    if (argc > 3) { arg4 = NUM2UINT(argv[3]); }  if (argc > 4) { arg5 = NUM2INT(argv[4]); }  if (argc > 5) {
        arg6 = NUM2INT(argv[5]); }  if (argc > 6) { arg7 = NUM2INT(argv[6]); }  if (argc > 7) { arg8 = NUM2INT(argv[7]); }  {
        result = (FXColorSelector *)new_FXColorSelector(arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8);
        DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result); if(rb_block_given_p()){ rb_yield(self); }  }  return self; }
static VALUE _wrap_FXColorSelector_acceptButton(int argc, VALUE *argv, VALUE self) {
    FXColorSelector *arg1 = (FXColorSelector *) 0 ; FXButton *result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorSelector, 1);
    result = (FXButton *)((FXColorSelector const *)arg1)->acceptButton(); {
        swig_type_info *ty = SWIG_TypeDynamicCast(SWIGTYPE_p_FXButton, (void **) &result);
        vresult = FXRbGetRubyObj(result, ty); }  return vresult; }
static VALUE _wrap_FXColorSelector_cancelButton(int argc, VALUE *argv, VALUE self) {
    FXColorSelector *arg1 = (FXColorSelector *) 0 ; FXButton *result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorSelector, 1);
    result = (FXButton *)((FXColorSelector const *)arg1)->cancelButton(); {
        swig_type_info *ty = SWIG_TypeDynamicCast(SWIGTYPE_p_FXButton, (void **) &result);
        vresult = FXRbGetRubyObj(result, ty); }  return vresult; }
static VALUE _wrap_FXColorSelector_setRGBA(int argc, VALUE *argv, VALUE self) { FXColorSelector *arg1 = (FXColorSelector *) 0 ;
    FXColor arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorSelector, 1); arg2 = to_FXColor(argv[0]); (arg1)->setRGBA(arg2);
    return Qnil; }
static VALUE _wrap_FXColorSelector_getRGBA(int argc, VALUE *argv, VALUE self) { FXColorSelector *arg1 = (FXColorSelector *) 0 ;
    FXColor result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorSelector, 1);
    result = (FXColor)((FXColorSelector const *)arg1)->getRGBA(); vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXColorSelector_isOpaqueOnly(int argc, VALUE *argv, VALUE self) {
    FXColorSelector *arg1 = (FXColorSelector *) 0 ; FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorSelector, 1);
    result = (FXbool)((FXColorSelector const *)arg1)->isOpaqueOnly(); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXColorSelector_setOpaqueOnly(int argc, VALUE *argv, VALUE self) {
    FXColorSelector *arg1 = (FXColorSelector *) 0 ; FXbool arg2 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorSelector, 1); arg2 = to_FXbool(argv[0]);
    (arg1)->setOpaqueOnly(arg2); return Qnil; }
static void
free_FXColorSelector(FXColorSelector *arg1) {
    delete arg1;
}
static VALUE _wrap_FXColorSelector_save(int argc, VALUE *argv, VALUE self) { FXColorSelector *arg1 = (FXColorSelector *) 0 ;
    FXStream *arg2 = 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorSelector, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXColorSelector_save((FXColorSelector const *)arg1,*arg2); return Qnil; }
static VALUE _wrap_FXColorSelector_load(int argc, VALUE *argv, VALUE self) { FXColorSelector *arg1 = (FXColorSelector *) 0 ;
    FXStream *arg2 = 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorSelector, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXColorSelector_load(arg1,*arg2); return Qnil; }
static VALUE _wrap_FXColorSelector_create(int argc, VALUE *argv, VALUE self) { FXColorSelector *arg1 = (FXColorSelector *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorSelector, 1); FXColorSelector_create(arg1); return Qnil; }
static VALUE _wrap_FXColorSelector_detach(int argc, VALUE *argv, VALUE self) { FXColorSelector *arg1 = (FXColorSelector *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorSelector, 1); FXColorSelector_detach(arg1); return Qnil; }
static VALUE _wrap_FXColorSelector_destroy(int argc, VALUE *argv, VALUE self) { FXColorSelector *arg1 = (FXColorSelector *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorSelector, 1); FXColorSelector_destroy(arg1); return Qnil; }
static VALUE _wrap_FXColorSelector_resize(int argc, VALUE *argv, VALUE self) { FXColorSelector *arg1 = (FXColorSelector *) 0 ;
    FXint arg2 ; FXint arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorSelector, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    FXColorSelector_resize(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXColorSelector_getDefaultWidth(int argc, VALUE *argv, VALUE self) {
    FXColorSelector *arg1 = (FXColorSelector *) 0 ; FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorSelector, 1);
    result = (FXint)FXColorSelector_getDefaultWidth(arg1); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXColorSelector_getDefaultHeight(int argc, VALUE *argv, VALUE self) {
    FXColorSelector *arg1 = (FXColorSelector *) 0 ; FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorSelector, 1);
    result = (FXint)FXColorSelector_getDefaultHeight(arg1); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXColorSelector_getWidthForHeight(int argc, VALUE *argv, VALUE self) {
    FXColorSelector *arg1 = (FXColorSelector *) 0 ; FXint arg2 ; FXint result; VALUE vresult = Qnil;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorSelector, 1); arg2 = NUM2INT(argv[0]);
    result = (FXint)FXColorSelector_getWidthForHeight(arg1,arg2); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXColorSelector_getHeightForWidth(int argc, VALUE *argv, VALUE self) {
    FXColorSelector *arg1 = (FXColorSelector *) 0 ; FXint arg2 ; FXint result; VALUE vresult = Qnil;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorSelector, 1); arg2 = NUM2INT(argv[0]);
    result = (FXint)FXColorSelector_getHeightForWidth(arg1,arg2); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXColorSelector_canFocus(int argc, VALUE *argv, VALUE self) { FXColorSelector *arg1 = (FXColorSelector *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorSelector, 1);
    result = (FXbool)FXColorSelector_canFocus((FXColorSelector const *)arg1); vresult = result ? Qtrue : Qfalse;
    return vresult; }
static VALUE _wrap_FXColorSelector_setFocus(int argc, VALUE *argv, VALUE self) { FXColorSelector *arg1 = (FXColorSelector *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorSelector, 1); FXColorSelector_setFocus(arg1); return Qnil; }
static VALUE _wrap_FXColorSelector_killFocus(int argc, VALUE *argv, VALUE self) {
    FXColorSelector *arg1 = (FXColorSelector *) 0 ; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorSelector, 1); FXColorSelector_killFocus(arg1); return Qnil; }
static VALUE _wrap_FXColorSelector_setDefault(int argc, VALUE *argv, VALUE self) {
    FXColorSelector *arg1 = (FXColorSelector *) 0 ; FXbool arg2 = (FXbool) 1 ; if ((argc < 0) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorSelector, 1); if (argc > 0) { arg2 = to_FXbool(argv[0]); } 
    FXColorSelector_setDefault(arg1,arg2); return Qnil; }
static VALUE _wrap_FXColorSelector_enable(int argc, VALUE *argv, VALUE self) { FXColorSelector *arg1 = (FXColorSelector *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorSelector, 1); FXColorSelector_enable(arg1); return Qnil; }
static VALUE _wrap_FXColorSelector_disable(int argc, VALUE *argv, VALUE self) { FXColorSelector *arg1 = (FXColorSelector *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorSelector, 1); FXColorSelector_disable(arg1); return Qnil; }
static VALUE _wrap_FXColorSelector_raiseWindow(int argc, VALUE *argv, VALUE self) {
    FXColorSelector *arg1 = (FXColorSelector *) 0 ; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorSelector, 1); FXColorSelector_raise(arg1); return Qnil; }
static VALUE _wrap_FXColorSelector_lower(int argc, VALUE *argv, VALUE self) { FXColorSelector *arg1 = (FXColorSelector *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorSelector, 1); FXColorSelector_lower(arg1); return Qnil; }
static VALUE _wrap_FXColorSelector_move(int argc, VALUE *argv, VALUE self) { FXColorSelector *arg1 = (FXColorSelector *) 0 ;
    FXint arg2 ; FXint arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorSelector, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    FXColorSelector_move(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXColorSelector_position(int argc, VALUE *argv, VALUE self) { FXColorSelector *arg1 = (FXColorSelector *) 0 ;
    FXint arg2 ; FXint arg3 ; FXint arg4 ; FXint arg5 ; if ((argc < 4) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorSelector, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    arg4 = NUM2INT(argv[2]); arg5 = NUM2INT(argv[3]); FXColorSelector_position(arg1,arg2,arg3,arg4,arg5); return Qnil; }
static VALUE _wrap_FXColorSelector_layout(int argc, VALUE *argv, VALUE self) { FXColorSelector *arg1 = (FXColorSelector *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorSelector, 1); FXColorSelector_layout(arg1); return Qnil; }
static VALUE _wrap_FXColorSelector_recalc(int argc, VALUE *argv, VALUE self) { FXColorSelector *arg1 = (FXColorSelector *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorSelector, 1); FXColorSelector_recalc(arg1); return Qnil; }
static VALUE _wrap_FXColorSelector_reparent(int argc, VALUE *argv, VALUE self) { FXColorSelector *arg1 = (FXColorSelector *) 0 ;
    FXComposite *arg2 = (FXComposite *) 0 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorSelector, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXComposite, 1); FXColorSelector_reparent(arg1,arg2); return Qnil; }
static VALUE _wrap_FXColorSelector_show(int argc, VALUE *argv, VALUE self) { FXColorSelector *arg1 = (FXColorSelector *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorSelector, 1); FXColorSelector_show(arg1); return Qnil; }
static VALUE _wrap_FXColorSelector_hide(int argc, VALUE *argv, VALUE self) { FXColorSelector *arg1 = (FXColorSelector *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorSelector, 1); FXColorSelector_hide(arg1); return Qnil; }
static VALUE _wrap_FXColorSelector_isComposite(int argc, VALUE *argv, VALUE self) {
    FXColorSelector *arg1 = (FXColorSelector *) 0 ; FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorSelector, 1);
    result = (FXbool)FXColorSelector_isComposite((FXColorSelector const *)arg1); vresult = result ? Qtrue : Qfalse;
    return vresult; }
static VALUE _wrap_FXColorSelector_contains(int argc, VALUE *argv, VALUE self) { FXColorSelector *arg1 = (FXColorSelector *) 0 ;
    FXint arg2 ; FXint arg3 ; FXbool result; VALUE vresult = Qnil; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorSelector, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    result = (FXbool)FXColorSelector_contains((FXColorSelector const *)arg1,arg2,arg3); vresult = result ? Qtrue : Qfalse;
    return vresult; }
static VALUE _wrap_FXColorSelector_doesSaveUnder(int argc, VALUE *argv, VALUE self) {
    FXColorSelector *arg1 = (FXColorSelector *) 0 ; FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorSelector, 1);
    result = (FXbool)FXColorSelector_doesSaveUnder((FXColorSelector const *)arg1); vresult = result ? Qtrue : Qfalse;
    return vresult; }
static VALUE _wrap_FXColorSelector_setBackColor(int argc, VALUE *argv, VALUE self) {
    FXColorSelector *arg1 = (FXColorSelector *) 0 ; FXColor arg2 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorSelector, 1); arg2 = to_FXColor(argv[0]);
    FXColorSelector_setBackColor(arg1,arg2); return Qnil; }
static VALUE _wrap_FXFontSelector_onCmdFamily(int argc, VALUE *argv, VALUE self) { FXFontSelector *arg1 = (FXFontSelector *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFontSelector, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]);
    arg4 = reinterpret_cast<void*>(NUM2INT(argv[2])); result = (long)(arg1)->onCmdFamily(arg2,arg3,arg4);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXFontSelector_onCmdWeight(int argc, VALUE *argv, VALUE self) { FXFontSelector *arg1 = (FXFontSelector *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFontSelector, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]);
    arg4 = reinterpret_cast<void*>(NUM2INT(argv[2])); result = (long)(arg1)->onCmdWeight(arg2,arg3,arg4);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXFontSelector_onCmdStyle(int argc, VALUE *argv, VALUE self) { FXFontSelector *arg1 = (FXFontSelector *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFontSelector, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]);
    arg4 = reinterpret_cast<void*>(NUM2INT(argv[2])); result = (long)(arg1)->onCmdStyle(arg2,arg3,arg4);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXFontSelector_onCmdStyleText(int argc, VALUE *argv, VALUE self) {
    FXFontSelector *arg1 = (FXFontSelector *) 0 ; FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ;
    long result; VALUE vresult = Qnil; if ((argc < 3) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFontSelector, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdStyleText(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXFontSelector_onCmdSize(int argc, VALUE *argv, VALUE self) { FXFontSelector *arg1 = (FXFontSelector *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFontSelector, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]);
    arg4 = reinterpret_cast<void*>(NUM2INT(argv[2])); result = (long)(arg1)->onCmdSize(arg2,arg3,arg4);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXFontSelector_onCmdSizeText(int argc, VALUE *argv, VALUE self) {
    FXFontSelector *arg1 = (FXFontSelector *) 0 ; FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ;
    long result; VALUE vresult = Qnil; if ((argc < 3) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFontSelector, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdSizeText(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXFontSelector_onCmdCharset(int argc, VALUE *argv, VALUE self) {
    FXFontSelector *arg1 = (FXFontSelector *) 0 ; FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ;
    long result; VALUE vresult = Qnil; if ((argc < 3) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFontSelector, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdCharset(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXFontSelector_onUpdCharset(int argc, VALUE *argv, VALUE self) {
    FXFontSelector *arg1 = (FXFontSelector *) 0 ; FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ;
    long result; VALUE vresult = Qnil; if ((argc < 3) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFontSelector, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onUpdCharset(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXFontSelector_onCmdSetWidth(int argc, VALUE *argv, VALUE self) {
    FXFontSelector *arg1 = (FXFontSelector *) 0 ; FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ;
    long result; VALUE vresult = Qnil; if ((argc < 3) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFontSelector, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdSetWidth(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXFontSelector_onUpdSetWidth(int argc, VALUE *argv, VALUE self) {
    FXFontSelector *arg1 = (FXFontSelector *) 0 ; FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ;
    long result; VALUE vresult = Qnil; if ((argc < 3) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFontSelector, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onUpdSetWidth(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXFontSelector_onCmdPitch(int argc, VALUE *argv, VALUE self) { FXFontSelector *arg1 = (FXFontSelector *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFontSelector, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdPitch(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXFontSelector_onUpdPitch(int argc, VALUE *argv, VALUE self) { FXFontSelector *arg1 = (FXFontSelector *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFontSelector, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onUpdPitch(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXFontSelector_onCmdScalable(int argc, VALUE *argv, VALUE self) {
    FXFontSelector *arg1 = (FXFontSelector *) 0 ; FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ;
    long result; VALUE vresult = Qnil; if ((argc < 3) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFontSelector, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdScalable(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXFontSelector_onUpdScalable(int argc, VALUE *argv, VALUE self) {
    FXFontSelector *arg1 = (FXFontSelector *) 0 ; FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ;
    long result; VALUE vresult = Qnil; if ((argc < 3) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFontSelector, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onUpdScalable(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXFontSelector_onCmdAllFonts(int argc, VALUE *argv, VALUE self) {
    FXFontSelector *arg1 = (FXFontSelector *) 0 ; FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ;
    long result; VALUE vresult = Qnil; if ((argc < 3) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFontSelector, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdAllFonts(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXFontSelector_onUpdAllFonts(int argc, VALUE *argv, VALUE self) {
    FXFontSelector *arg1 = (FXFontSelector *) 0 ; FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ;
    long result; VALUE vresult = Qnil; if ((argc < 3) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFontSelector, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onUpdAllFonts(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE _wrap_FXFontSelector_allocate(VALUE self) {
#else
     static VALUE _wrap_FXFontSelector_allocate(int argc, VALUE *argv, VALUE self) {
#endif
         VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_FXFontSelector);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
         return vresult; }
static VALUE _wrap_new_FXFontSelector(int argc, VALUE *argv, VALUE self) { FXComposite *arg1 = (FXComposite *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 = (FXSelector) 0 ; FXuint arg4 = (FXuint) 0 ; FXint arg5 = (FXint) 0 ;
    FXint arg6 = (FXint) 0 ; FXint arg7 = (FXint) 0 ; FXint arg8 = (FXint) 0 ; FXFontSelector *result;
    if ((argc < 1) || (argc > 8)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXComposite, 1); if (argc > 1) {
        SWIG_ConvertPtr(argv[1], (void **) &arg2, SWIGTYPE_p_FXObject, 1); }  if (argc > 2) { arg3 = NUM2UINT(argv[2]); } 
    if (argc > 3) { arg4 = NUM2UINT(argv[3]); }  if (argc > 4) { arg5 = NUM2INT(argv[4]); }  if (argc > 5) {
        arg6 = NUM2INT(argv[5]); }  if (argc > 6) { arg7 = NUM2INT(argv[6]); }  if (argc > 7) { arg8 = NUM2INT(argv[7]); }  {
        result = (FXFontSelector *)new_FXFontSelector(arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8);
        DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result); if(rb_block_given_p()){ rb_yield(self); }  }  return self; }
static VALUE _wrap_FXFontSelector_acceptButton(int argc, VALUE *argv, VALUE self) {
    FXFontSelector *arg1 = (FXFontSelector *) 0 ; FXButton *result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFontSelector, 1);
    result = (FXButton *)((FXFontSelector const *)arg1)->acceptButton(); {
        swig_type_info *ty = SWIG_TypeDynamicCast(SWIGTYPE_p_FXButton, (void **) &result);
        vresult = FXRbGetRubyObj(result, ty); }  return vresult; }
static VALUE _wrap_FXFontSelector_cancelButton(int argc, VALUE *argv, VALUE self) {
    FXFontSelector *arg1 = (FXFontSelector *) 0 ; FXButton *result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFontSelector, 1);
    result = (FXButton *)((FXFontSelector const *)arg1)->cancelButton(); {
        swig_type_info *ty = SWIG_TypeDynamicCast(SWIGTYPE_p_FXButton, (void **) &result);
        vresult = FXRbGetRubyObj(result, ty); }  return vresult; }
static VALUE _wrap_FXFontSelector_setFontSelection(int argc, VALUE *argv, VALUE self) {
    FXFontSelector *arg1 = (FXFontSelector *) 0 ; FXFontDesc *arg2 = 0 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFontSelector, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXFontDesc, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    (arg1)->setFontSelection((FXFontDesc const &)*arg2); return Qnil; }
static VALUE _wrap_FXFontSelector_getFontSelection(int argc, VALUE *argv, VALUE self) {
    FXFontSelector *arg1 = (FXFontSelector *) 0 ; FXFontDesc result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFontSelector, 1);
    result = FXFontSelector_getFontSelection((FXFontSelector const *)arg1); { FXFontDesc* resultptr = new FXFontDesc(result);
        vresult = FXRbGetRubyObj(resultptr, "FXFontDesc *"); }  return vresult; }
static void
free_FXFontSelector(FXFontSelector *arg1) {
    delete arg1;
}
static VALUE _wrap_FXFontSelector_save(int argc, VALUE *argv, VALUE self) { FXFontSelector *arg1 = (FXFontSelector *) 0 ;
    FXStream *arg2 = 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFontSelector, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXFontSelector_save((FXFontSelector const *)arg1,*arg2); return Qnil; }
static VALUE _wrap_FXFontSelector_load(int argc, VALUE *argv, VALUE self) { FXFontSelector *arg1 = (FXFontSelector *) 0 ;
    FXStream *arg2 = 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFontSelector, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXFontSelector_load(arg1,*arg2); return Qnil; }
static VALUE _wrap_FXFontSelector_create(int argc, VALUE *argv, VALUE self) { FXFontSelector *arg1 = (FXFontSelector *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFontSelector, 1); FXFontSelector_create(arg1); return Qnil; }
static VALUE _wrap_FXFontSelector_detach(int argc, VALUE *argv, VALUE self) { FXFontSelector *arg1 = (FXFontSelector *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFontSelector, 1); FXFontSelector_detach(arg1); return Qnil; }
static VALUE _wrap_FXFontSelector_destroy(int argc, VALUE *argv, VALUE self) { FXFontSelector *arg1 = (FXFontSelector *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFontSelector, 1); FXFontSelector_destroy(arg1); return Qnil; }
static VALUE _wrap_FXFontSelector_resize(int argc, VALUE *argv, VALUE self) { FXFontSelector *arg1 = (FXFontSelector *) 0 ;
    FXint arg2 ; FXint arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFontSelector, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    FXFontSelector_resize(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXFontSelector_getDefaultWidth(int argc, VALUE *argv, VALUE self) {
    FXFontSelector *arg1 = (FXFontSelector *) 0 ; FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFontSelector, 1); result = (FXint)FXFontSelector_getDefaultWidth(arg1);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXFontSelector_getDefaultHeight(int argc, VALUE *argv, VALUE self) {
    FXFontSelector *arg1 = (FXFontSelector *) 0 ; FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFontSelector, 1); result = (FXint)FXFontSelector_getDefaultHeight(arg1);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXFontSelector_getWidthForHeight(int argc, VALUE *argv, VALUE self) {
    FXFontSelector *arg1 = (FXFontSelector *) 0 ; FXint arg2 ; FXint result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFontSelector, 1); arg2 = NUM2INT(argv[0]);
    result = (FXint)FXFontSelector_getWidthForHeight(arg1,arg2); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXFontSelector_getHeightForWidth(int argc, VALUE *argv, VALUE self) {
    FXFontSelector *arg1 = (FXFontSelector *) 0 ; FXint arg2 ; FXint result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFontSelector, 1); arg2 = NUM2INT(argv[0]);
    result = (FXint)FXFontSelector_getHeightForWidth(arg1,arg2); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXFontSelector_canFocus(int argc, VALUE *argv, VALUE self) { FXFontSelector *arg1 = (FXFontSelector *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFontSelector, 1);
    result = (FXbool)FXFontSelector_canFocus((FXFontSelector const *)arg1); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXFontSelector_setFocus(int argc, VALUE *argv, VALUE self) { FXFontSelector *arg1 = (FXFontSelector *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFontSelector, 1); FXFontSelector_setFocus(arg1); return Qnil; }
static VALUE _wrap_FXFontSelector_killFocus(int argc, VALUE *argv, VALUE self) { FXFontSelector *arg1 = (FXFontSelector *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFontSelector, 1); FXFontSelector_killFocus(arg1); return Qnil; }
static VALUE _wrap_FXFontSelector_setDefault(int argc, VALUE *argv, VALUE self) { FXFontSelector *arg1 = (FXFontSelector *) 0 ;
    FXbool arg2 = (FXbool) 1 ; if ((argc < 0) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFontSelector, 1); if (argc > 0) { arg2 = to_FXbool(argv[0]); } 
    FXFontSelector_setDefault(arg1,arg2); return Qnil; }
static VALUE _wrap_FXFontSelector_enable(int argc, VALUE *argv, VALUE self) { FXFontSelector *arg1 = (FXFontSelector *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFontSelector, 1); FXFontSelector_enable(arg1); return Qnil; }
static VALUE _wrap_FXFontSelector_disable(int argc, VALUE *argv, VALUE self) { FXFontSelector *arg1 = (FXFontSelector *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFontSelector, 1); FXFontSelector_disable(arg1); return Qnil; }
static VALUE _wrap_FXFontSelector_raiseWindow(int argc, VALUE *argv, VALUE self) { FXFontSelector *arg1 = (FXFontSelector *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFontSelector, 1); FXFontSelector_raise(arg1); return Qnil; }
static VALUE _wrap_FXFontSelector_lower(int argc, VALUE *argv, VALUE self) { FXFontSelector *arg1 = (FXFontSelector *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFontSelector, 1); FXFontSelector_lower(arg1); return Qnil; }
static VALUE _wrap_FXFontSelector_move(int argc, VALUE *argv, VALUE self) { FXFontSelector *arg1 = (FXFontSelector *) 0 ;
    FXint arg2 ; FXint arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFontSelector, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    FXFontSelector_move(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXFontSelector_position(int argc, VALUE *argv, VALUE self) { FXFontSelector *arg1 = (FXFontSelector *) 0 ;
    FXint arg2 ; FXint arg3 ; FXint arg4 ; FXint arg5 ; if ((argc < 4) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFontSelector, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    arg4 = NUM2INT(argv[2]); arg5 = NUM2INT(argv[3]); FXFontSelector_position(arg1,arg2,arg3,arg4,arg5); return Qnil; }
static VALUE _wrap_FXFontSelector_layout(int argc, VALUE *argv, VALUE self) { FXFontSelector *arg1 = (FXFontSelector *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFontSelector, 1); FXFontSelector_layout(arg1); return Qnil; }
static VALUE _wrap_FXFontSelector_recalc(int argc, VALUE *argv, VALUE self) { FXFontSelector *arg1 = (FXFontSelector *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFontSelector, 1); FXFontSelector_recalc(arg1); return Qnil; }
static VALUE _wrap_FXFontSelector_reparent(int argc, VALUE *argv, VALUE self) { FXFontSelector *arg1 = (FXFontSelector *) 0 ;
    FXComposite *arg2 = (FXComposite *) 0 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFontSelector, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXComposite, 1); FXFontSelector_reparent(arg1,arg2); return Qnil; }
static VALUE _wrap_FXFontSelector_show(int argc, VALUE *argv, VALUE self) { FXFontSelector *arg1 = (FXFontSelector *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFontSelector, 1); FXFontSelector_show(arg1); return Qnil; }
static VALUE _wrap_FXFontSelector_hide(int argc, VALUE *argv, VALUE self) { FXFontSelector *arg1 = (FXFontSelector *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFontSelector, 1); FXFontSelector_hide(arg1); return Qnil; }
static VALUE _wrap_FXFontSelector_isComposite(int argc, VALUE *argv, VALUE self) { FXFontSelector *arg1 = (FXFontSelector *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFontSelector, 1);
    result = (FXbool)FXFontSelector_isComposite((FXFontSelector const *)arg1); vresult = result ? Qtrue : Qfalse;
    return vresult; }
static VALUE _wrap_FXFontSelector_contains(int argc, VALUE *argv, VALUE self) { FXFontSelector *arg1 = (FXFontSelector *) 0 ;
    FXint arg2 ; FXint arg3 ; FXbool result; VALUE vresult = Qnil; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFontSelector, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    result = (FXbool)FXFontSelector_contains((FXFontSelector const *)arg1,arg2,arg3); vresult = result ? Qtrue : Qfalse;
    return vresult; }
static VALUE _wrap_FXFontSelector_doesSaveUnder(int argc, VALUE *argv, VALUE self) {
    FXFontSelector *arg1 = (FXFontSelector *) 0 ; FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFontSelector, 1);
    result = (FXbool)FXFontSelector_doesSaveUnder((FXFontSelector const *)arg1); vresult = result ? Qtrue : Qfalse;
    return vresult; }
static VALUE _wrap_FXFontSelector_setBackColor(int argc, VALUE *argv, VALUE self) {
    FXFontSelector *arg1 = (FXFontSelector *) 0 ; FXColor arg2 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFontSelector, 1); arg2 = to_FXColor(argv[0]);
    FXFontSelector_setBackColor(arg1,arg2); return Qnil; }
static VALUE _wrap_FXToolBarGrip_onPaint(int argc, VALUE *argv, VALUE self) { FXToolBarGrip *arg1 = (FXToolBarGrip *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToolBarGrip, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onPaint(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXToolBarGrip_onLeftBtnPress(int argc, VALUE *argv, VALUE self) { FXToolBarGrip *arg1 = (FXToolBarGrip *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToolBarGrip, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onLeftBtnPress(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXToolBarGrip_onLeftBtnRelease(int argc, VALUE *argv, VALUE self) {
    FXToolBarGrip *arg1 = (FXToolBarGrip *) 0 ; FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ;
    long result; VALUE vresult = Qnil; if ((argc < 3) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToolBarGrip, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onLeftBtnRelease(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXToolBarGrip_onMotion(int argc, VALUE *argv, VALUE self) { FXToolBarGrip *arg1 = (FXToolBarGrip *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToolBarGrip, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onMotion(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXToolBarGrip_onEnter(int argc, VALUE *argv, VALUE self) { FXToolBarGrip *arg1 = (FXToolBarGrip *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToolBarGrip, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onEnter(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXToolBarGrip_onLeave(int argc, VALUE *argv, VALUE self) { FXToolBarGrip *arg1 = (FXToolBarGrip *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToolBarGrip, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onLeave(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE _wrap_FXToolBarGrip_allocate(VALUE self) {
#else
     static VALUE _wrap_FXToolBarGrip_allocate(int argc, VALUE *argv, VALUE self) {
#endif
         VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_FXToolBarGrip);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
         return vresult; }
static VALUE _wrap_new_FXToolBarGrip(int argc, VALUE *argv, VALUE self) { FXToolBar *arg1 = (FXToolBar *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 = (FXSelector) 0 ; FXuint arg4 = (FXuint) TOOLBARGRIP_SINGLE ;
    FXint arg5 = (FXint) 0 ; FXint arg6 = (FXint) 0 ; FXint arg7 = (FXint) 0 ; FXint arg8 = (FXint) 0 ; FXToolBarGrip *result;
    if ((argc < 1) || (argc > 8)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXToolBar, 1); if (argc > 1) {
        SWIG_ConvertPtr(argv[1], (void **) &arg2, SWIGTYPE_p_FXObject, 1); }  if (argc > 2) { arg3 = NUM2UINT(argv[2]); } 
    if (argc > 3) { arg4 = NUM2UINT(argv[3]); }  if (argc > 4) { arg5 = NUM2INT(argv[4]); }  if (argc > 5) {
        arg6 = NUM2INT(argv[5]); }  if (argc > 6) { arg7 = NUM2INT(argv[6]); }  if (argc > 7) { arg8 = NUM2INT(argv[7]); }  {
        result = (FXToolBarGrip *)new_FXToolBarGrip(arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8);
        DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result); if(rb_block_given_p()){ rb_yield(self); }  }  return self; }
static VALUE _wrap_FXToolBarGrip_setDoubleBar(int argc, VALUE *argv, VALUE self) { FXToolBarGrip *arg1 = (FXToolBarGrip *) 0 ;
    FXbool arg2 = (FXbool) 1 ; if ((argc < 0) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToolBarGrip, 1); if (argc > 0) { arg2 = to_FXbool(argv[0]); } 
    (arg1)->setDoubleBar(arg2); return Qnil; }
static VALUE _wrap_FXToolBarGrip_isDoubleBar(int argc, VALUE *argv, VALUE self) { FXToolBarGrip *arg1 = (FXToolBarGrip *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToolBarGrip, 1);
    result = (FXbool)((FXToolBarGrip const *)arg1)->isDoubleBar(); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXToolBarGrip_setHiliteColor(int argc, VALUE *argv, VALUE self) { FXToolBarGrip *arg1 = (FXToolBarGrip *) 0 ;
    FXColor arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToolBarGrip, 1); arg2 = to_FXColor(argv[0]);
    (arg1)->setHiliteColor(arg2); return Qnil; }
static VALUE _wrap_FXToolBarGrip_getHiliteColor(int argc, VALUE *argv, VALUE self) { FXToolBarGrip *arg1 = (FXToolBarGrip *) 0 ;
    FXColor result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToolBarGrip, 1);
    result = (FXColor)((FXToolBarGrip const *)arg1)->getHiliteColor(); vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXToolBarGrip_setShadowColor(int argc, VALUE *argv, VALUE self) { FXToolBarGrip *arg1 = (FXToolBarGrip *) 0 ;
    FXColor arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToolBarGrip, 1); arg2 = to_FXColor(argv[0]);
    (arg1)->setShadowColor(arg2); return Qnil; }
static VALUE _wrap_FXToolBarGrip_getShadowColor(int argc, VALUE *argv, VALUE self) { FXToolBarGrip *arg1 = (FXToolBarGrip *) 0 ;
    FXColor result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToolBarGrip, 1);
    result = (FXColor)((FXToolBarGrip const *)arg1)->getShadowColor(); vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXToolBarGrip_setActiveColor(int argc, VALUE *argv, VALUE self) { FXToolBarGrip *arg1 = (FXToolBarGrip *) 0 ;
    FXColor arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToolBarGrip, 1); arg2 = to_FXColor(argv[0]);
    (arg1)->setActiveColor(arg2); return Qnil; }
static VALUE _wrap_FXToolBarGrip_getActiveColor(int argc, VALUE *argv, VALUE self) { FXToolBarGrip *arg1 = (FXToolBarGrip *) 0 ;
    FXColor result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToolBarGrip, 1);
    result = (FXColor)((FXToolBarGrip const *)arg1)->getActiveColor(); vresult = UINT2NUM(result); return vresult; }
static void
free_FXToolBarGrip(FXToolBarGrip *arg1) {
    delete arg1;
}
static VALUE _wrap_FXToolBarGrip_save(int argc, VALUE *argv, VALUE self) { FXToolBarGrip *arg1 = (FXToolBarGrip *) 0 ;
    FXStream *arg2 = 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToolBarGrip, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXToolBarGrip_save((FXToolBarGrip const *)arg1,*arg2); return Qnil; }
static VALUE _wrap_FXToolBarGrip_load(int argc, VALUE *argv, VALUE self) { FXToolBarGrip *arg1 = (FXToolBarGrip *) 0 ;
    FXStream *arg2 = 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToolBarGrip, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXToolBarGrip_load(arg1,*arg2); return Qnil; }
static VALUE _wrap_FXToolBarGrip_create(int argc, VALUE *argv, VALUE self) { FXToolBarGrip *arg1 = (FXToolBarGrip *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToolBarGrip, 1); FXToolBarGrip_create(arg1); return Qnil; }
static VALUE _wrap_FXToolBarGrip_detach(int argc, VALUE *argv, VALUE self) { FXToolBarGrip *arg1 = (FXToolBarGrip *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToolBarGrip, 1); FXToolBarGrip_detach(arg1); return Qnil; }
static VALUE _wrap_FXToolBarGrip_destroy(int argc, VALUE *argv, VALUE self) { FXToolBarGrip *arg1 = (FXToolBarGrip *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToolBarGrip, 1); FXToolBarGrip_destroy(arg1); return Qnil; }
static VALUE _wrap_FXToolBarGrip_resize(int argc, VALUE *argv, VALUE self) { FXToolBarGrip *arg1 = (FXToolBarGrip *) 0 ;
    FXint arg2 ; FXint arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToolBarGrip, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    FXToolBarGrip_resize(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXToolBarGrip_getDefaultWidth(int argc, VALUE *argv, VALUE self) {
    FXToolBarGrip *arg1 = (FXToolBarGrip *) 0 ; FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToolBarGrip, 1); result = (FXint)FXToolBarGrip_getDefaultWidth(arg1);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXToolBarGrip_getDefaultHeight(int argc, VALUE *argv, VALUE self) {
    FXToolBarGrip *arg1 = (FXToolBarGrip *) 0 ; FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToolBarGrip, 1); result = (FXint)FXToolBarGrip_getDefaultHeight(arg1);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXToolBarGrip_getWidthForHeight(int argc, VALUE *argv, VALUE self) {
    FXToolBarGrip *arg1 = (FXToolBarGrip *) 0 ; FXint arg2 ; FXint result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToolBarGrip, 1); arg2 = NUM2INT(argv[0]);
    result = (FXint)FXToolBarGrip_getWidthForHeight(arg1,arg2); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXToolBarGrip_getHeightForWidth(int argc, VALUE *argv, VALUE self) {
    FXToolBarGrip *arg1 = (FXToolBarGrip *) 0 ; FXint arg2 ; FXint result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToolBarGrip, 1); arg2 = NUM2INT(argv[0]);
    result = (FXint)FXToolBarGrip_getHeightForWidth(arg1,arg2); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXToolBarGrip_canFocus(int argc, VALUE *argv, VALUE self) { FXToolBarGrip *arg1 = (FXToolBarGrip *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToolBarGrip, 1);
    result = (FXbool)FXToolBarGrip_canFocus((FXToolBarGrip const *)arg1); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXToolBarGrip_setFocus(int argc, VALUE *argv, VALUE self) { FXToolBarGrip *arg1 = (FXToolBarGrip *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToolBarGrip, 1); FXToolBarGrip_setFocus(arg1); return Qnil; }
static VALUE _wrap_FXToolBarGrip_killFocus(int argc, VALUE *argv, VALUE self) { FXToolBarGrip *arg1 = (FXToolBarGrip *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToolBarGrip, 1); FXToolBarGrip_killFocus(arg1); return Qnil; }
static VALUE _wrap_FXToolBarGrip_setDefault(int argc, VALUE *argv, VALUE self) { FXToolBarGrip *arg1 = (FXToolBarGrip *) 0 ;
    FXbool arg2 = (FXbool) 1 ; if ((argc < 0) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToolBarGrip, 1); if (argc > 0) { arg2 = to_FXbool(argv[0]); } 
    FXToolBarGrip_setDefault(arg1,arg2); return Qnil; }
static VALUE _wrap_FXToolBarGrip_enable(int argc, VALUE *argv, VALUE self) { FXToolBarGrip *arg1 = (FXToolBarGrip *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToolBarGrip, 1); FXToolBarGrip_enable(arg1); return Qnil; }
static VALUE _wrap_FXToolBarGrip_disable(int argc, VALUE *argv, VALUE self) { FXToolBarGrip *arg1 = (FXToolBarGrip *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToolBarGrip, 1); FXToolBarGrip_disable(arg1); return Qnil; }
static VALUE _wrap_FXToolBarGrip_raiseWindow(int argc, VALUE *argv, VALUE self) { FXToolBarGrip *arg1 = (FXToolBarGrip *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToolBarGrip, 1); FXToolBarGrip_raise(arg1); return Qnil; }
static VALUE _wrap_FXToolBarGrip_lower(int argc, VALUE *argv, VALUE self) { FXToolBarGrip *arg1 = (FXToolBarGrip *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToolBarGrip, 1); FXToolBarGrip_lower(arg1); return Qnil; }
static VALUE _wrap_FXToolBarGrip_move(int argc, VALUE *argv, VALUE self) { FXToolBarGrip *arg1 = (FXToolBarGrip *) 0 ;
    FXint arg2 ; FXint arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToolBarGrip, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    FXToolBarGrip_move(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXToolBarGrip_position(int argc, VALUE *argv, VALUE self) { FXToolBarGrip *arg1 = (FXToolBarGrip *) 0 ;
    FXint arg2 ; FXint arg3 ; FXint arg4 ; FXint arg5 ; if ((argc < 4) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToolBarGrip, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    arg4 = NUM2INT(argv[2]); arg5 = NUM2INT(argv[3]); FXToolBarGrip_position(arg1,arg2,arg3,arg4,arg5); return Qnil; }
static VALUE _wrap_FXToolBarGrip_layout(int argc, VALUE *argv, VALUE self) { FXToolBarGrip *arg1 = (FXToolBarGrip *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToolBarGrip, 1); FXToolBarGrip_layout(arg1); return Qnil; }
static VALUE _wrap_FXToolBarGrip_recalc(int argc, VALUE *argv, VALUE self) { FXToolBarGrip *arg1 = (FXToolBarGrip *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToolBarGrip, 1); FXToolBarGrip_recalc(arg1); return Qnil; }
static VALUE _wrap_FXToolBarGrip_reparent(int argc, VALUE *argv, VALUE self) { FXToolBarGrip *arg1 = (FXToolBarGrip *) 0 ;
    FXComposite *arg2 = (FXComposite *) 0 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToolBarGrip, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXComposite, 1); FXToolBarGrip_reparent(arg1,arg2); return Qnil; }
static VALUE _wrap_FXToolBarGrip_show(int argc, VALUE *argv, VALUE self) { FXToolBarGrip *arg1 = (FXToolBarGrip *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToolBarGrip, 1); FXToolBarGrip_show(arg1); return Qnil; }
static VALUE _wrap_FXToolBarGrip_hide(int argc, VALUE *argv, VALUE self) { FXToolBarGrip *arg1 = (FXToolBarGrip *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToolBarGrip, 1); FXToolBarGrip_hide(arg1); return Qnil; }
static VALUE _wrap_FXToolBarGrip_isComposite(int argc, VALUE *argv, VALUE self) { FXToolBarGrip *arg1 = (FXToolBarGrip *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToolBarGrip, 1);
    result = (FXbool)FXToolBarGrip_isComposite((FXToolBarGrip const *)arg1); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXToolBarGrip_contains(int argc, VALUE *argv, VALUE self) { FXToolBarGrip *arg1 = (FXToolBarGrip *) 0 ;
    FXint arg2 ; FXint arg3 ; FXbool result; VALUE vresult = Qnil; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToolBarGrip, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    result = (FXbool)FXToolBarGrip_contains((FXToolBarGrip const *)arg1,arg2,arg3); vresult = result ? Qtrue : Qfalse;
    return vresult; }
static VALUE _wrap_FXToolBarGrip_doesSaveUnder(int argc, VALUE *argv, VALUE self) { FXToolBarGrip *arg1 = (FXToolBarGrip *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToolBarGrip, 1);
    result = (FXbool)FXToolBarGrip_doesSaveUnder((FXToolBarGrip const *)arg1); vresult = result ? Qtrue : Qfalse;
    return vresult; }
static VALUE _wrap_FXToolBarGrip_setBackColor(int argc, VALUE *argv, VALUE self) { FXToolBarGrip *arg1 = (FXToolBarGrip *) 0 ;
    FXColor arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToolBarGrip, 1); arg2 = to_FXColor(argv[0]);
    FXToolBarGrip_setBackColor(arg1,arg2); return Qnil; }
static VALUE _wrap_FXToolBarShell_onPaint(int argc, VALUE *argv, VALUE self) { FXToolBarShell *arg1 = (FXToolBarShell *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToolBarShell, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onPaint(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE _wrap_FXToolBarShell_allocate(VALUE self) {
#else
     static VALUE _wrap_FXToolBarShell_allocate(int argc, VALUE *argv, VALUE self) {
#endif
         VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_FXToolBarShell);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
         return vresult; }
static VALUE _wrap_new_FXToolBarShell(int argc, VALUE *argv, VALUE self) { FXWindow *arg1 = (FXWindow *) 0 ;
    FXuint arg2 = (FXuint) FRAME_RAISED|FRAME_THICK ; FXint arg3 = (FXint) 0 ; FXint arg4 = (FXint) 0 ; FXint arg5 = (FXint) 0 ;
    FXint arg6 = (FXint) 0 ; FXint arg7 = (FXint) 4 ; FXint arg8 = (FXint) 4 ; FXToolBarShell *result;
    if ((argc < 1) || (argc > 8)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXWindow, 1); if (argc > 1) { arg2 = NUM2UINT(argv[1]); } 
    if (argc > 2) { arg3 = NUM2INT(argv[2]); }  if (argc > 3) { arg4 = NUM2INT(argv[3]); }  if (argc > 4) {
        arg5 = NUM2INT(argv[4]); }  if (argc > 5) { arg6 = NUM2INT(argv[5]); }  if (argc > 6) { arg7 = NUM2INT(argv[6]); } 
    if (argc > 7) { arg8 = NUM2INT(argv[7]); }  {
        result = (FXToolBarShell *)new_FXToolBarShell(arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8);
        DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result); if(rb_block_given_p()){ rb_yield(self); }  }  return self; }
static VALUE _wrap_FXToolBarShell_setFrameStyle(int argc, VALUE *argv, VALUE self) {
    FXToolBarShell *arg1 = (FXToolBarShell *) 0 ; FXuint arg2 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToolBarShell, 1); arg2 = NUM2UINT(argv[0]); (arg1)->setFrameStyle(arg2);
    return Qnil; }
static VALUE _wrap_FXToolBarShell_getFrameStyle(int argc, VALUE *argv, VALUE self) {
    FXToolBarShell *arg1 = (FXToolBarShell *) 0 ; FXuint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToolBarShell, 1);
    result = (FXuint)((FXToolBarShell const *)arg1)->getFrameStyle(); vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXToolBarShell_getBorderWidth(int argc, VALUE *argv, VALUE self) {
    FXToolBarShell *arg1 = (FXToolBarShell *) 0 ; FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToolBarShell, 1);
    result = (FXint)((FXToolBarShell const *)arg1)->getBorderWidth(); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXToolBarShell_setHiliteColor(int argc, VALUE *argv, VALUE self) {
    FXToolBarShell *arg1 = (FXToolBarShell *) 0 ; FXColor arg2 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToolBarShell, 1); arg2 = to_FXColor(argv[0]);
    (arg1)->setHiliteColor(arg2); return Qnil; }
static VALUE _wrap_FXToolBarShell_getHiliteColor(int argc, VALUE *argv, VALUE self) {
    FXToolBarShell *arg1 = (FXToolBarShell *) 0 ; FXColor result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToolBarShell, 1);
    result = (FXColor)((FXToolBarShell const *)arg1)->getHiliteColor(); vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXToolBarShell_setShadowColor(int argc, VALUE *argv, VALUE self) {
    FXToolBarShell *arg1 = (FXToolBarShell *) 0 ; FXColor arg2 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToolBarShell, 1); arg2 = to_FXColor(argv[0]);
    (arg1)->setShadowColor(arg2); return Qnil; }
static VALUE _wrap_FXToolBarShell_getShadowColor(int argc, VALUE *argv, VALUE self) {
    FXToolBarShell *arg1 = (FXToolBarShell *) 0 ; FXColor result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToolBarShell, 1);
    result = (FXColor)((FXToolBarShell const *)arg1)->getShadowColor(); vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXToolBarShell_setBorderColor(int argc, VALUE *argv, VALUE self) {
    FXToolBarShell *arg1 = (FXToolBarShell *) 0 ; FXColor arg2 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToolBarShell, 1); arg2 = to_FXColor(argv[0]);
    (arg1)->setBorderColor(arg2); return Qnil; }
static VALUE _wrap_FXToolBarShell_getBorderColor(int argc, VALUE *argv, VALUE self) {
    FXToolBarShell *arg1 = (FXToolBarShell *) 0 ; FXColor result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToolBarShell, 1);
    result = (FXColor)((FXToolBarShell const *)arg1)->getBorderColor(); vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXToolBarShell_setBaseColor(int argc, VALUE *argv, VALUE self) {
    FXToolBarShell *arg1 = (FXToolBarShell *) 0 ; FXColor arg2 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToolBarShell, 1); arg2 = to_FXColor(argv[0]);
    (arg1)->setBaseColor(arg2); return Qnil; }
static VALUE _wrap_FXToolBarShell_getBaseColor(int argc, VALUE *argv, VALUE self) {
    FXToolBarShell *arg1 = (FXToolBarShell *) 0 ; FXColor result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToolBarShell, 1);
    result = (FXColor)((FXToolBarShell const *)arg1)->getBaseColor(); vresult = UINT2NUM(result); return vresult; }
static void
free_FXToolBarShell(FXToolBarShell *arg1) {
    delete arg1;
}
static VALUE _wrap_FXToolBarShell_save(int argc, VALUE *argv, VALUE self) { FXToolBarShell *arg1 = (FXToolBarShell *) 0 ;
    FXStream *arg2 = 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToolBarShell, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXToolBarShell_save((FXToolBarShell const *)arg1,*arg2); return Qnil; }
static VALUE _wrap_FXToolBarShell_load(int argc, VALUE *argv, VALUE self) { FXToolBarShell *arg1 = (FXToolBarShell *) 0 ;
    FXStream *arg2 = 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToolBarShell, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXToolBarShell_load(arg1,*arg2); return Qnil; }
static VALUE _wrap_FXToolBarShell_create(int argc, VALUE *argv, VALUE self) { FXToolBarShell *arg1 = (FXToolBarShell *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToolBarShell, 1); FXToolBarShell_create(arg1); return Qnil; }
static VALUE _wrap_FXToolBarShell_detach(int argc, VALUE *argv, VALUE self) { FXToolBarShell *arg1 = (FXToolBarShell *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToolBarShell, 1); FXToolBarShell_detach(arg1); return Qnil; }
static VALUE _wrap_FXToolBarShell_destroy(int argc, VALUE *argv, VALUE self) { FXToolBarShell *arg1 = (FXToolBarShell *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToolBarShell, 1); FXToolBarShell_destroy(arg1); return Qnil; }
static VALUE _wrap_FXToolBarShell_resize(int argc, VALUE *argv, VALUE self) { FXToolBarShell *arg1 = (FXToolBarShell *) 0 ;
    FXint arg2 ; FXint arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToolBarShell, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    FXToolBarShell_resize(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXToolBarShell_getDefaultWidth(int argc, VALUE *argv, VALUE self) {
    FXToolBarShell *arg1 = (FXToolBarShell *) 0 ; FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToolBarShell, 1); result = (FXint)FXToolBarShell_getDefaultWidth(arg1);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXToolBarShell_getDefaultHeight(int argc, VALUE *argv, VALUE self) {
    FXToolBarShell *arg1 = (FXToolBarShell *) 0 ; FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToolBarShell, 1); result = (FXint)FXToolBarShell_getDefaultHeight(arg1);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXToolBarShell_getWidthForHeight(int argc, VALUE *argv, VALUE self) {
    FXToolBarShell *arg1 = (FXToolBarShell *) 0 ; FXint arg2 ; FXint result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToolBarShell, 1); arg2 = NUM2INT(argv[0]);
    result = (FXint)FXToolBarShell_getWidthForHeight(arg1,arg2); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXToolBarShell_getHeightForWidth(int argc, VALUE *argv, VALUE self) {
    FXToolBarShell *arg1 = (FXToolBarShell *) 0 ; FXint arg2 ; FXint result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToolBarShell, 1); arg2 = NUM2INT(argv[0]);
    result = (FXint)FXToolBarShell_getHeightForWidth(arg1,arg2); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXToolBarShell_canFocus(int argc, VALUE *argv, VALUE self) { FXToolBarShell *arg1 = (FXToolBarShell *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToolBarShell, 1);
    result = (FXbool)FXToolBarShell_canFocus((FXToolBarShell const *)arg1); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXToolBarShell_setFocus(int argc, VALUE *argv, VALUE self) { FXToolBarShell *arg1 = (FXToolBarShell *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToolBarShell, 1); FXToolBarShell_setFocus(arg1); return Qnil; }
static VALUE _wrap_FXToolBarShell_killFocus(int argc, VALUE *argv, VALUE self) { FXToolBarShell *arg1 = (FXToolBarShell *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToolBarShell, 1); FXToolBarShell_killFocus(arg1); return Qnil; }
static VALUE _wrap_FXToolBarShell_setDefault(int argc, VALUE *argv, VALUE self) { FXToolBarShell *arg1 = (FXToolBarShell *) 0 ;
    FXbool arg2 = (FXbool) 1 ; if ((argc < 0) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToolBarShell, 1); if (argc > 0) { arg2 = to_FXbool(argv[0]); } 
    FXToolBarShell_setDefault(arg1,arg2); return Qnil; }
static VALUE _wrap_FXToolBarShell_enable(int argc, VALUE *argv, VALUE self) { FXToolBarShell *arg1 = (FXToolBarShell *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToolBarShell, 1); FXToolBarShell_enable(arg1); return Qnil; }
static VALUE _wrap_FXToolBarShell_disable(int argc, VALUE *argv, VALUE self) { FXToolBarShell *arg1 = (FXToolBarShell *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToolBarShell, 1); FXToolBarShell_disable(arg1); return Qnil; }
static VALUE _wrap_FXToolBarShell_raiseWindow(int argc, VALUE *argv, VALUE self) { FXToolBarShell *arg1 = (FXToolBarShell *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToolBarShell, 1); FXToolBarShell_raise(arg1); return Qnil; }
static VALUE _wrap_FXToolBarShell_lower(int argc, VALUE *argv, VALUE self) { FXToolBarShell *arg1 = (FXToolBarShell *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToolBarShell, 1); FXToolBarShell_lower(arg1); return Qnil; }
static VALUE _wrap_FXToolBarShell_move(int argc, VALUE *argv, VALUE self) { FXToolBarShell *arg1 = (FXToolBarShell *) 0 ;
    FXint arg2 ; FXint arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToolBarShell, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    FXToolBarShell_move(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXToolBarShell_position(int argc, VALUE *argv, VALUE self) { FXToolBarShell *arg1 = (FXToolBarShell *) 0 ;
    FXint arg2 ; FXint arg3 ; FXint arg4 ; FXint arg5 ; if ((argc < 4) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToolBarShell, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    arg4 = NUM2INT(argv[2]); arg5 = NUM2INT(argv[3]); FXToolBarShell_position(arg1,arg2,arg3,arg4,arg5); return Qnil; }
static VALUE _wrap_FXToolBarShell_layout(int argc, VALUE *argv, VALUE self) { FXToolBarShell *arg1 = (FXToolBarShell *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToolBarShell, 1); FXToolBarShell_layout(arg1); return Qnil; }
static VALUE _wrap_FXToolBarShell_recalc(int argc, VALUE *argv, VALUE self) { FXToolBarShell *arg1 = (FXToolBarShell *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToolBarShell, 1); FXToolBarShell_recalc(arg1); return Qnil; }
static VALUE _wrap_FXToolBarShell_reparent(int argc, VALUE *argv, VALUE self) { FXToolBarShell *arg1 = (FXToolBarShell *) 0 ;
    FXComposite *arg2 = (FXComposite *) 0 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToolBarShell, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXComposite, 1); FXToolBarShell_reparent(arg1,arg2); return Qnil; }
static VALUE _wrap_FXToolBarShell_show__SWIG_0(int argc, VALUE *argv, VALUE self) {
    FXToolBarShell *arg1 = (FXToolBarShell *) 0 ; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToolBarShell, 1); FXToolBarShell_show(arg1); return Qnil; }
static VALUE _wrap_FXToolBarShell_hide(int argc, VALUE *argv, VALUE self) { FXToolBarShell *arg1 = (FXToolBarShell *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToolBarShell, 1); FXToolBarShell_hide(arg1); return Qnil; }
static VALUE _wrap_FXToolBarShell_isComposite(int argc, VALUE *argv, VALUE self) { FXToolBarShell *arg1 = (FXToolBarShell *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToolBarShell, 1);
    result = (FXbool)FXToolBarShell_isComposite((FXToolBarShell const *)arg1); vresult = result ? Qtrue : Qfalse;
    return vresult; }
static VALUE _wrap_FXToolBarShell_contains(int argc, VALUE *argv, VALUE self) { FXToolBarShell *arg1 = (FXToolBarShell *) 0 ;
    FXint arg2 ; FXint arg3 ; FXbool result; VALUE vresult = Qnil; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToolBarShell, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    result = (FXbool)FXToolBarShell_contains((FXToolBarShell const *)arg1,arg2,arg3); vresult = result ? Qtrue : Qfalse;
    return vresult; }
static VALUE _wrap_FXToolBarShell_doesSaveUnder(int argc, VALUE *argv, VALUE self) {
    FXToolBarShell *arg1 = (FXToolBarShell *) 0 ; FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToolBarShell, 1);
    result = (FXbool)FXToolBarShell_doesSaveUnder((FXToolBarShell const *)arg1); vresult = result ? Qtrue : Qfalse;
    return vresult; }
static VALUE _wrap_FXToolBarShell_setBackColor(int argc, VALUE *argv, VALUE self) {
    FXToolBarShell *arg1 = (FXToolBarShell *) 0 ; FXColor arg2 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToolBarShell, 1); arg2 = to_FXColor(argv[0]);
    FXToolBarShell_setBackColor(arg1,arg2); return Qnil; }
static VALUE _wrap_FXToolBarShell_show__SWIG_1(int argc, VALUE *argv, VALUE self) {
    FXToolBarShell *arg1 = (FXToolBarShell *) 0 ; FXuint arg2 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToolBarShell, 1); arg2 = NUM2UINT(argv[0]);
    FXToolBarShell_show(arg1,arg2); return Qnil; }
static VALUE _wrap_FXToolBarShell_show(int nargs, VALUE *args, VALUE self) { int argc; VALUE argv[3]; int ii; argc = nargs + 1;
    argv[0] = self; for (ii = 1; (ii < argc) && (ii < 2); ii++) { argv[ii] = args[ii-1]; }  if (argc == 1) { int _v; {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXToolBarShell, 0) != -1)) ? 1 : 0; }
         if (_v) { return _wrap_FXToolBarShell_show__SWIG_0(nargs, args, self);}  }  if (argc == 2) { int _v; { void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXToolBarShell, 0) != -1)) ? 1 : 0; }
         if (_v) { { _v = ((TYPE(argv[1]) == T_FIXNUM) || (TYPE(argv[1]) == T_BIGNUM)) ? 1 : 0; }  if (_v) {
                return _wrap_FXToolBarShell_show__SWIG_1(nargs, args, self);}  }  } 
    rb_raise(rb_eArgError, "No matching function for overloaded 'FXToolBarShell_show'"); return Qnil; }
static VALUE _wrap_FXToolBarShell_maximize(int argc, VALUE *argv, VALUE self) { FXToolBarShell *arg1 = (FXToolBarShell *) 0 ;
    FXbool arg2 = (FXbool) 0 ; FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToolBarShell, 1); if (argc > 0) { arg2 = to_FXbool(argv[0]); } 
    result = (FXbool)FXToolBarShell_maximize(arg1,arg2); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXToolBarShell_minimize(int argc, VALUE *argv, VALUE self) { FXToolBarShell *arg1 = (FXToolBarShell *) 0 ;
    FXbool arg2 = (FXbool) 0 ; FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToolBarShell, 1); if (argc > 0) { arg2 = to_FXbool(argv[0]); } 
    result = (FXbool)FXToolBarShell_minimize(arg1,arg2); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXToolBarShell_restore(int argc, VALUE *argv, VALUE self) { FXToolBarShell *arg1 = (FXToolBarShell *) 0 ;
    FXbool arg2 = (FXbool) 0 ; FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToolBarShell, 1); if (argc > 0) { arg2 = to_FXbool(argv[0]); } 
    result = (FXbool)FXToolBarShell_restore(arg1,arg2); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXToolBarShell_close(int argc, VALUE *argv, VALUE self) { FXToolBarShell *arg1 = (FXToolBarShell *) 0 ;
    FXbool arg2 = (FXbool) 0 ; FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXToolBarShell, 1); if (argc > 0) { arg2 = to_FXbool(argv[0]); } 
    result = (FXbool)FXToolBarShell_close(arg1,arg2); vresult = result ? Qtrue : Qfalse; return vresult; }

/* -------- TYPE CONVERSION AND EQUIVALENCE RULES (BEGIN) -------- */

static void *_p_FXDriveBoxTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXPacker *)(FXListBox *) ((FXDriveBox *) x));
}
static void *_p_FXToolBarTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXPacker *) ((FXToolBar *) x));
}
static void *_p_FXToolTipTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXShell *) ((FXToolTip *) x));
}
static void *_p_FXTabBookTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXPacker *)(FXTabBar *) ((FXTabBook *) x));
}
static void *_p_FXGroupBoxTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXPacker *) ((FXGroupBox *) x));
}
static void *_p_FXShellTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *)  ((FXShell *) x));
}
static void *_p_FXStatusBarTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXPacker *)(FXHorizontalFrame *) ((FXStatusBar *) x));
}
static void *_p_FXScrollAreaTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *)  ((FXScrollArea *) x));
}
static void *_p_FXPopupTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXShell *) ((FXPopup *) x));
}
static void *_p_FXScrollWindowTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXScrollArea *) ((FXScrollWindow *) x));
}
static void *_p_FXRootWindowTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *)  ((FXRootWindow *) x));
}
static void *_p_FXTopWindowTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXShell *) ((FXTopWindow *) x));
}
static void *_p_FXMainWindowTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXShell *)(FXTopWindow *) ((FXMainWindow *) x));
}
static void *_p_FXComboBoxTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXPacker *) ((FXComboBox *) x));
}
static void *_p_FXHorizontalFrameTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXPacker *) ((FXHorizontalFrame *) x));
}
static void *_p_FXVerticalFrameTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXPacker *) ((FXVerticalFrame *) x));
}
static void *_p_FX4SplitterTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *)  ((FX4Splitter *) x));
}
static void *_p_FXSplitterTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *)  ((FXSplitter *) x));
}
static void *_p_FXRealSpinnerTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXPacker *) ((FXRealSpinner *) x));
}
static void *_p_FXSpinnerTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXPacker *) ((FXSpinner *) x));
}
static void *_p_FXPackerTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *)  ((FXPacker *) x));
}
static void *_p_FXDirBoxTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXPacker *)(FXTreeListBox *) ((FXDirBox *) x));
}
static void *_p_FXSwitcherTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXPacker *) ((FXSwitcher *) x));
}
static void *_p_FXColorSelectorTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXPacker *) ((FXColorSelector *) x));
}
static void *_p_FXFileSelectorTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXPacker *) ((FXFileSelector *) x));
}
static void *_p_FXDirSelectorTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXPacker *) ((FXDirSelector *) x));
}
static void *_p_FXFontSelectorTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXPacker *) ((FXFontSelector *) x));
}
static void *_p_FXShutterTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXPacker *)(FXVerticalFrame *) ((FXShutter *) x));
}
static void *_p_FXTreeListBoxTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXPacker *) ((FXTreeListBox *) x));
}
static void *_p_FXListBoxTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXPacker *) ((FXListBox *) x));
}
static void *_p_FXMatrixTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXPacker *) ((FXMatrix *) x));
}
static void *_p_FXShutterItemTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXPacker *)(FXVerticalFrame *) ((FXShutterItem *) x));
}
static void *_p_FXTabBarTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXPacker *) ((FXTabBar *) x));
}
static void *_p_FXImageViewTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXScrollArea *) ((FXImageView *) x));
}
static void *_p_FXSpringTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXPacker *) ((FXSpring *) x));
}
static void *_p_FXToolBarShellTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXShell *)(FXTopWindow *) ((FXToolBarShell *) x));
}
static void *_p_FXPopupTo_p_FXShell(void *x) {
    return (void *)((FXShell *)  ((FXPopup *) x));
}
static void *_p_FXTopWindowTo_p_FXShell(void *x) {
    return (void *)((FXShell *)  ((FXTopWindow *) x));
}
static void *_p_FXMainWindowTo_p_FXShell(void *x) {
    return (void *)((FXShell *) (FXTopWindow *) ((FXMainWindow *) x));
}
static void *_p_FXToolTipTo_p_FXShell(void *x) {
    return (void *)((FXShell *)  ((FXToolTip *) x));
}
static void *_p_FXToolBarShellTo_p_FXShell(void *x) {
    return (void *)((FXShell *) (FXTopWindow *) ((FXToolBarShell *) x));
}
static void *_p_FXScrollWindowTo_p_FXScrollArea(void *x) {
    return (void *)((FXScrollArea *)  ((FXScrollWindow *) x));
}
static void *_p_FXImageViewTo_p_FXScrollArea(void *x) {
    return (void *)((FXScrollArea *)  ((FXImageView *) x));
}
static void *_p_FXDriveBoxTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXPacker *)(FXListBox *) ((FXDriveBox *) x));
}
static void *_p_FXToolBarTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXPacker *) ((FXToolBar *) x));
}
static void *_p_FXCompositeTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *)  ((FXComposite *) x));
}
static void *_p_FXToolTipTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXShell *) ((FXToolTip *) x));
}
static void *_p_FXTextFieldTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXFrame *) ((FXTextField *) x));
}
static void *_p_FXTabBookTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXPacker *)(FXTabBar *) ((FXTabBook *) x));
}
static void *_p_FXArrowButtonTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXFrame *) ((FXArrowButton *) x));
}
static void *_p_FXGroupBoxTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXPacker *) ((FXGroupBox *) x));
}
static void *_p_FXShellTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *) ((FXShell *) x));
}
static void *_p_FXStatusBarTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXPacker *)(FXHorizontalFrame *) ((FXStatusBar *) x));
}
static void *_p_FXScrollAreaTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *) ((FXScrollArea *) x));
}
static void *_p_FXPopupTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXShell *) ((FXPopup *) x));
}
static void *_p_FXScrollWindowTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXScrollArea *) ((FXScrollWindow *) x));
}
static void *_p_FXRootWindowTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *) ((FXRootWindow *) x));
}
static void *_p_FXTopWindowTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXShell *) ((FXTopWindow *) x));
}
static void *_p_FXMainWindowTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXShell *)(FXTopWindow *) ((FXMainWindow *) x));
}
static void *_p_FXRulerTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXFrame *) ((FXRuler *) x));
}
static void *_p_FXCanvasTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *)  ((FXCanvas *) x));
}
static void *_p_FXScrollCornerTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *)  ((FXScrollCorner *) x));
}
static void *_p_FXVerticalSeparatorTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXFrame *)(FXSeparator *) ((FXVerticalSeparator *) x));
}
static void *_p_FXHorizontalSeparatorTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXFrame *)(FXSeparator *) ((FXHorizontalSeparator *) x));
}
static void *_p_FXSeparatorTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXFrame *) ((FXSeparator *) x));
}
static void *_p_FXStatusLineTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXFrame *) ((FXStatusLine *) x));
}
static void *_p_FXComboBoxTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXPacker *) ((FXComboBox *) x));
}
static void *_p_FXHorizontalFrameTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXPacker *) ((FXHorizontalFrame *) x));
}
static void *_p_FXVerticalFrameTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXPacker *) ((FXVerticalFrame *) x));
}
static void *_p_FX4SplitterTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *) ((FX4Splitter *) x));
}
static void *_p_FXSplitterTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *) ((FXSplitter *) x));
}
static void *_p_FXPackerTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *) ((FXPacker *) x));
}
static void *_p_FXSpinnerTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXPacker *) ((FXSpinner *) x));
}
static void *_p_FXRealSpinnerTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXPacker *) ((FXRealSpinner *) x));
}
static void *_p_FXScrollBarTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *)  ((FXScrollBar *) x));
}
static void *_p_FXColorWheelTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXFrame *) ((FXColorWheel *) x));
}
static void *_p_FXBitmapFrameTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXFrame *) ((FXBitmapFrame *) x));
}
static void *_p_FXDirBoxTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXPacker *)(FXTreeListBox *) ((FXDirBox *) x));
}
static void *_p_FXToolBarGripTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *)  ((FXToolBarGrip *) x));
}
static void *_p_FXImageFrameTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXFrame *) ((FXImageFrame *) x));
}
static void *_p_FXDragCornerTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *)  ((FXDragCorner *) x));
}
static void *_p_FXSwitcherTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXPacker *) ((FXSwitcher *) x));
}
static void *_p_FXDirSelectorTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXPacker *) ((FXDirSelector *) x));
}
static void *_p_FXFileSelectorTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXPacker *) ((FXFileSelector *) x));
}
static void *_p_FXColorSelectorTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXPacker *) ((FXColorSelector *) x));
}
static void *_p_FXFontSelectorTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXPacker *) ((FXFontSelector *) x));
}
static void *_p_FXShutterTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXPacker *)(FXVerticalFrame *) ((FXShutter *) x));
}
static void *_p_FXProgressBarTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXFrame *) ((FXProgressBar *) x));
}
static void *_p_FXListBoxTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXPacker *) ((FXListBox *) x));
}
static void *_p_FXTreeListBoxTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXPacker *) ((FXTreeListBox *) x));
}
static void *_p_FXHeaderTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXFrame *) ((FXHeader *) x));
}
static void *_p_FXMatrixTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXPacker *) ((FXMatrix *) x));
}
static void *_p_FXColorWellTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXFrame *) ((FXColorWell *) x));
}
static void *_p_FXShutterItemTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXPacker *)(FXVerticalFrame *) ((FXShutterItem *) x));
}
static void *_p_FXDialTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXFrame *) ((FXDial *) x));
}
static void *_p_FXToolBarTabTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXFrame *) ((FXToolBarTab *) x));
}
static void *_p_FXFrameTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *)  ((FXFrame *) x));
}
static void *_p_FXTabBarTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXPacker *) ((FXTabBar *) x));
}
static void *_p_FXImageViewTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXScrollArea *) ((FXImageView *) x));
}
static void *_p_FXSliderTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXFrame *) ((FXSlider *) x));
}
static void *_p_FXRealSliderTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXFrame *) ((FXRealSlider *) x));
}
static void *_p_FXSpringTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXPacker *) ((FXSpring *) x));
}
static void *_p_FXColorBarTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXFrame *) ((FXColorBar *) x));
}
static void *_p_FXToolBarShellTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXShell *)(FXTopWindow *) ((FXToolBarShell *) x));
}
static void *_p_FXMainWindowTo_p_FXTopWindow(void *x) {
    return (void *)((FXTopWindow *)  ((FXMainWindow *) x));
}
static void *_p_FXToolBarShellTo_p_FXTopWindow(void *x) {
    return (void *)((FXTopWindow *)  ((FXToolBarShell *) x));
}
static void *_p_FXDocumentTo_p_FXObject(void *x) {
    return (void *)((FXObject *)  ((FXDocument *) x));
}
static void *_p_FXRegistryTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXDict *)(FXSettings *) ((FXRegistry *) x));
}
static void *_p_FXHeaderItemTo_p_FXObject(void *x) {
    return (void *)((FXObject *)  ((FXHeaderItem *) x));
}
static void *_p_FXShutterItemTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *)(FXVerticalFrame *) ((FXShutterItem *) x));
}
static void *_p_FXColorBarTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXFrame *) ((FXColorBar *) x));
}
static void *_p_FXTabBarTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXTabBar *) x));
}
static void *_p_FXSwitcherTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXSwitcher *) x));
}
static void *_p_FXTextFieldTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXFrame *) ((FXTextField *) x));
}
static void *_p_FXToolBarTabTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXFrame *) ((FXToolBarTab *) x));
}
static void *_p_FXDriveBoxTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *)(FXListBox *) ((FXDriveBox *) x));
}
static void *_p_FXIconDictTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXDict *) ((FXIconDict *) x));
}
static void *_p_FXMatrixTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXMatrix *) x));
}
static void *_p_FXFileDictTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXDict *) ((FXFileDict *) x));
}
static void *_p_FXRecentFilesTo_p_FXObject(void *x) {
    return (void *)((FXObject *)  ((FXRecentFiles *) x));
}
static void *_p_FXScrollCornerTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *) ((FXScrollCorner *) x));
}
static void *_p_FXArrowButtonTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXFrame *) ((FXArrowButton *) x));
}
static void *_p_FXPopupTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXShell *) ((FXPopup *) x));
}
static void *_p_FXDrawableTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *) ((FXDrawable *) x));
}
static void *_p_FXAppTo_p_FXObject(void *x) {
    return (void *)((FXObject *)  ((FXApp *) x));
}
static void *_p_FXHeaderTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXFrame *) ((FXHeader *) x));
}
static void *_p_FX4SplitterTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *) ((FX4Splitter *) x));
}
static void *_p_FXSplitterTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *) ((FXSplitter *) x));
}
static void *_p_FXSpringTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXSpring *) x));
}
static void *_p_FXPackerTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *) ((FXPacker *) x));
}
static void *_p_FXTabBookTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *)(FXTabBar *) ((FXTabBook *) x));
}
static void *_p_FXImageFrameTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXFrame *) ((FXImageFrame *) x));
}
static void *_p_FXVerticalSeparatorTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXFrame *)(FXSeparator *) ((FXVerticalSeparator *) x));
}
static void *_p_FXHorizontalSeparatorTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXFrame *)(FXSeparator *) ((FXHorizontalSeparator *) x));
}
static void *_p_FXSeparatorTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXFrame *) ((FXSeparator *) x));
}
static void *_p_FXIdTo_p_FXObject(void *x) {
    return (void *)((FXObject *)  ((FXId *) x));
}
static void *_p_FXProgressBarTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXFrame *) ((FXProgressBar *) x));
}
static void *_p_FXShutterTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *)(FXVerticalFrame *) ((FXShutter *) x));
}
static void *_p_FXToolTipTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXShell *) ((FXToolTip *) x));
}
static void *_p_FXCompositeTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *) ((FXComposite *) x));
}
static void *_p_FXBitmapFrameTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXFrame *) ((FXBitmapFrame *) x));
}
static void *_p_FXRealSliderTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXFrame *) ((FXRealSlider *) x));
}
static void *_p_FXSliderTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXFrame *) ((FXSlider *) x));
}
static void *_p_FXSettingsTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXDict *) ((FXSettings *) x));
}
static void *_p_FXGroupBoxTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXGroupBox *) x));
}
static void *_p_FXDebugTargetTo_p_FXObject(void *x) {
    return (void *)((FXObject *)  ((FXDebugTarget *) x));
}
static void *_p_FXDataTargetTo_p_FXObject(void *x) {
    return (void *)((FXObject *)  ((FXDataTarget *) x));
}
static void *_p_FXTreeListBoxTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXTreeListBox *) x));
}
static void *_p_FXListBoxTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXListBox *) x));
}
static void *_p_FXCanvasTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *) ((FXCanvas *) x));
}
static void *_p_FXColorWheelTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXFrame *) ((FXColorWheel *) x));
}
static void *_p_FXVisualTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *) ((FXVisual *) x));
}
static void *_p_FXScrollBarTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *) ((FXScrollBar *) x));
}
static void *_p_FXToolBarGripTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *) ((FXToolBarGrip *) x));
}
static void *_p_FXFontTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *) ((FXFont *) x));
}
static void *_p_FXComboBoxTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXComboBox *) x));
}
static void *_p_FXFrameTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *) ((FXFrame *) x));
}
static void *_p_FXStringDictTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXDict *) ((FXStringDict *) x));
}
static void *_p_FXStatusBarTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *)(FXHorizontalFrame *) ((FXStatusBar *) x));
}
static void *_p_FXDelegatorTo_p_FXObject(void *x) {
    return (void *)((FXObject *)  ((FXDelegator *) x));
}
static void *_p_FXAccelTableTo_p_FXObject(void *x) {
    return (void *)((FXObject *)  ((FXAccelTable *) x));
}
static void *_p_FXCursorTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *) ((FXCursor *) x));
}
static void *_p_FXCURCursorTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXCursor *) ((FXCURCursor *) x));
}
static void *_p_FXGIFCursorTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXCursor *) ((FXGIFCursor *) x));
}
static void *_p_FXRealSpinnerTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXRealSpinner *) x));
}
static void *_p_FXSpinnerTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXSpinner *) x));
}
static void *_p_FXStatusLineTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXFrame *) ((FXStatusLine *) x));
}
static void *_p_FXScrollWindowTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXScrollArea *) ((FXScrollWindow *) x));
}
static void *_p_FXWindowTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *) ((FXWindow *) x));
}
static void *_p_FXRootWindowTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *) ((FXRootWindow *) x));
}
static void *_p_FXTopWindowTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXShell *) ((FXTopWindow *) x));
}
static void *_p_FXMainWindowTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXShell *)(FXTopWindow *) ((FXMainWindow *) x));
}
static void *_p_FXDictTo_p_FXObject(void *x) {
    return (void *)((FXObject *)  ((FXDict *) x));
}
static void *_p_FXShellTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *) ((FXShell *) x));
}
static void *_p_FXScrollAreaTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *) ((FXScrollArea *) x));
}
static void *_p_FXColorWellTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXFrame *) ((FXColorWell *) x));
}
static void *_p_FXDragCornerTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *) ((FXDragCorner *) x));
}
static void *_p_FXRulerTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXFrame *) ((FXRuler *) x));
}
static void *_p_FXDialTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXFrame *) ((FXDial *) x));
}
static void *_p_FXHorizontalFrameTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXHorizontalFrame *) x));
}
static void *_p_FXVerticalFrameTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXVerticalFrame *) x));
}
static void *_p_FXImageViewTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXScrollArea *) ((FXImageView *) x));
}
static void *_p_FXDirSelectorTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXDirSelector *) x));
}
static void *_p_FXFileSelectorTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXFileSelector *) x));
}
static void *_p_FXColorSelectorTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXColorSelector *) x));
}
static void *_p_FXFontSelectorTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXFontSelector *) x));
}
static void *_p_FXToolBarTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXToolBar *) x));
}
static void *_p_FXToolBarShellTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXShell *)(FXTopWindow *) ((FXToolBarShell *) x));
}
static void *_p_FXDirBoxTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *)(FXTreeListBox *) ((FXDirBox *) x));
}
static void *_p_FXToolBarTo_p_FXPacker(void *x) {
    return (void *)((FXPacker *)  ((FXToolBar *) x));
}
static void *_p_FXListBoxTo_p_FXPacker(void *x) {
    return (void *)((FXPacker *)  ((FXListBox *) x));
}
static void *_p_FXTreeListBoxTo_p_FXPacker(void *x) {
    return (void *)((FXPacker *)  ((FXTreeListBox *) x));
}
static void *_p_FXComboBoxTo_p_FXPacker(void *x) {
    return (void *)((FXPacker *)  ((FXComboBox *) x));
}
static void *_p_FXShutterItemTo_p_FXPacker(void *x) {
    return (void *)((FXPacker *) (FXVerticalFrame *) ((FXShutterItem *) x));
}
static void *_p_FXStatusBarTo_p_FXPacker(void *x) {
    return (void *)((FXPacker *) (FXHorizontalFrame *) ((FXStatusBar *) x));
}
static void *_p_FXDirBoxTo_p_FXPacker(void *x) {
    return (void *)((FXPacker *) (FXTreeListBox *) ((FXDirBox *) x));
}
static void *_p_FXTabBarTo_p_FXPacker(void *x) {
    return (void *)((FXPacker *)  ((FXTabBar *) x));
}
static void *_p_FXTabBookTo_p_FXPacker(void *x) {
    return (void *)((FXPacker *) (FXTabBar *) ((FXTabBook *) x));
}
static void *_p_FXGroupBoxTo_p_FXPacker(void *x) {
    return (void *)((FXPacker *)  ((FXGroupBox *) x));
}
static void *_p_FXShutterTo_p_FXPacker(void *x) {
    return (void *)((FXPacker *) (FXVerticalFrame *) ((FXShutter *) x));
}
static void *_p_FXVerticalFrameTo_p_FXPacker(void *x) {
    return (void *)((FXPacker *)  ((FXVerticalFrame *) x));
}
static void *_p_FXHorizontalFrameTo_p_FXPacker(void *x) {
    return (void *)((FXPacker *)  ((FXHorizontalFrame *) x));
}
static void *_p_FXRealSpinnerTo_p_FXPacker(void *x) {
    return (void *)((FXPacker *)  ((FXRealSpinner *) x));
}
static void *_p_FXSpinnerTo_p_FXPacker(void *x) {
    return (void *)((FXPacker *)  ((FXSpinner *) x));
}
static void *_p_FXMatrixTo_p_FXPacker(void *x) {
    return (void *)((FXPacker *)  ((FXMatrix *) x));
}
static void *_p_FXSpringTo_p_FXPacker(void *x) {
    return (void *)((FXPacker *)  ((FXSpring *) x));
}
static void *_p_FXDirSelectorTo_p_FXPacker(void *x) {
    return (void *)((FXPacker *)  ((FXDirSelector *) x));
}
static void *_p_FXFileSelectorTo_p_FXPacker(void *x) {
    return (void *)((FXPacker *)  ((FXFileSelector *) x));
}
static void *_p_FXColorSelectorTo_p_FXPacker(void *x) {
    return (void *)((FXPacker *)  ((FXColorSelector *) x));
}
static void *_p_FXFontSelectorTo_p_FXPacker(void *x) {
    return (void *)((FXPacker *)  ((FXFontSelector *) x));
}
static void *_p_FXDriveBoxTo_p_FXPacker(void *x) {
    return (void *)((FXPacker *) (FXListBox *) ((FXDriveBox *) x));
}
static void *_p_FXSwitcherTo_p_FXPacker(void *x) {
    return (void *)((FXPacker *)  ((FXSwitcher *) x));
}
static void *_p_FXDriveBoxTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *)(FXListBox *) ((FXDriveBox *) x));
}
static void *_p_FXToolBarTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *) ((FXToolBar *) x));
}
static void *_p_FXCompositeTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *) ((FXComposite *) x));
}
static void *_p_FXToolTipTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXShell *) ((FXToolTip *) x));
}
static void *_p_FXTextFieldTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXFrame *) ((FXTextField *) x));
}
static void *_p_FXTabBookTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *)(FXTabBar *) ((FXTabBook *) x));
}
static void *_p_FXArrowButtonTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXFrame *) ((FXArrowButton *) x));
}
static void *_p_FXGroupBoxTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *) ((FXGroupBox *) x));
}
static void *_p_FXShellTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *) ((FXShell *) x));
}
static void *_p_FXStatusBarTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *)(FXHorizontalFrame *) ((FXStatusBar *) x));
}
static void *_p_FXScrollAreaTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *) ((FXScrollArea *) x));
}
static void *_p_FXPopupTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXShell *) ((FXPopup *) x));
}
static void *_p_FXScrollWindowTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXScrollArea *) ((FXScrollWindow *) x));
}
static void *_p_FXWindowTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *)  ((FXWindow *) x));
}
static void *_p_FXRootWindowTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *) ((FXRootWindow *) x));
}
static void *_p_FXTopWindowTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXShell *) ((FXTopWindow *) x));
}
static void *_p_FXMainWindowTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXShell *)(FXTopWindow *) ((FXMainWindow *) x));
}
static void *_p_FXRulerTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXFrame *) ((FXRuler *) x));
}
static void *_p_FXCanvasTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *) ((FXCanvas *) x));
}
static void *_p_FXScrollCornerTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *) ((FXScrollCorner *) x));
}
static void *_p_FXHorizontalSeparatorTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXFrame *)(FXSeparator *) ((FXHorizontalSeparator *) x));
}
static void *_p_FXSeparatorTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXFrame *) ((FXSeparator *) x));
}
static void *_p_FXVerticalSeparatorTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXFrame *)(FXSeparator *) ((FXVerticalSeparator *) x));
}
static void *_p_FXStatusLineTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXFrame *) ((FXStatusLine *) x));
}
static void *_p_FXComboBoxTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *) ((FXComboBox *) x));
}
static void *_p_FXHorizontalFrameTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *) ((FXHorizontalFrame *) x));
}
static void *_p_FXVerticalFrameTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *) ((FXVerticalFrame *) x));
}
static void *_p_FX4SplitterTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *) ((FX4Splitter *) x));
}
static void *_p_FXSplitterTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *) ((FXSplitter *) x));
}
static void *_p_FXPackerTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *) ((FXPacker *) x));
}
static void *_p_FXSpinnerTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *) ((FXSpinner *) x));
}
static void *_p_FXRealSpinnerTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *) ((FXRealSpinner *) x));
}
static void *_p_FXScrollBarTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *) ((FXScrollBar *) x));
}
static void *_p_FXColorWheelTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXFrame *) ((FXColorWheel *) x));
}
static void *_p_FXBitmapFrameTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXFrame *) ((FXBitmapFrame *) x));
}
static void *_p_FXDirBoxTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *)(FXTreeListBox *) ((FXDirBox *) x));
}
static void *_p_FXToolBarGripTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *) ((FXToolBarGrip *) x));
}
static void *_p_FXImageFrameTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXFrame *) ((FXImageFrame *) x));
}
static void *_p_FXDragCornerTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *) ((FXDragCorner *) x));
}
static void *_p_FXSwitcherTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *) ((FXSwitcher *) x));
}
static void *_p_FXDirSelectorTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *) ((FXDirSelector *) x));
}
static void *_p_FXFileSelectorTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *) ((FXFileSelector *) x));
}
static void *_p_FXColorSelectorTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *) ((FXColorSelector *) x));
}
static void *_p_FXFontSelectorTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *) ((FXFontSelector *) x));
}
static void *_p_FXShutterTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *)(FXVerticalFrame *) ((FXShutter *) x));
}
static void *_p_FXProgressBarTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXFrame *) ((FXProgressBar *) x));
}
static void *_p_FXListBoxTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *) ((FXListBox *) x));
}
static void *_p_FXTreeListBoxTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *) ((FXTreeListBox *) x));
}
static void *_p_FXHeaderTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXFrame *) ((FXHeader *) x));
}
static void *_p_FXMatrixTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *) ((FXMatrix *) x));
}
static void *_p_FXColorWellTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXFrame *) ((FXColorWell *) x));
}
static void *_p_FXShutterItemTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *)(FXVerticalFrame *) ((FXShutterItem *) x));
}
static void *_p_FXDialTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXFrame *) ((FXDial *) x));
}
static void *_p_FXToolBarTabTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXFrame *) ((FXToolBarTab *) x));
}
static void *_p_FXFrameTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *) ((FXFrame *) x));
}
static void *_p_FXTabBarTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *) ((FXTabBar *) x));
}
static void *_p_FXImageViewTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXScrollArea *) ((FXImageView *) x));
}
static void *_p_FXSliderTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXFrame *) ((FXSlider *) x));
}
static void *_p_FXRealSliderTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXFrame *) ((FXRealSlider *) x));
}
static void *_p_FXSpringTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *) ((FXSpring *) x));
}
static void *_p_FXColorBarTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXFrame *) ((FXColorBar *) x));
}
static void *_p_FXToolBarShellTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXShell *)(FXTopWindow *) ((FXToolBarShell *) x));
}
static void *_p_FXFileStreamTo_p_FXStream(void *x) {
    return (void *)((FXStream *)  ((FXFileStream *) x));
}
static void *_p_FXMemoryStreamTo_p_FXStream(void *x) {
    return (void *)((FXStream *)  ((FXMemoryStream *) x));
}
static void *_p_FXDirBoxTo_p_FXTreeListBox(void *x) {
    return (void *)((FXTreeListBox *)  ((FXDirBox *) x));
}
static void *_p_FXDriveBoxTo_p_FXListBox(void *x) {
    return (void *)((FXListBox *)  ((FXDriveBox *) x));
}
static void *_p_FXDriveBoxTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *)(FXListBox *) ((FXDriveBox *) x));
}
static void *_p_FXToolBarTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXToolBar *) x));
}
static void *_p_FXCompositeTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *) ((FXComposite *) x));
}
static void *_p_FXToolTipTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXShell *) ((FXToolTip *) x));
}
static void *_p_FXTextFieldTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXFrame *) ((FXTextField *) x));
}
static void *_p_FXTabBookTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *)(FXTabBar *) ((FXTabBook *) x));
}
static void *_p_FXArrowButtonTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXFrame *) ((FXArrowButton *) x));
}
static void *_p_FXGroupBoxTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXGroupBox *) x));
}
static void *_p_FXShellTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *) ((FXShell *) x));
}
static void *_p_FXStatusBarTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *)(FXHorizontalFrame *) ((FXStatusBar *) x));
}
static void *_p_FXScrollAreaTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *) ((FXScrollArea *) x));
}
static void *_p_FXPopupTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXShell *) ((FXPopup *) x));
}
static void *_p_FXScrollWindowTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXScrollArea *) ((FXScrollWindow *) x));
}
static void *_p_FXWindowTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *) ((FXWindow *) x));
}
static void *_p_FXRootWindowTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *) ((FXRootWindow *) x));
}
static void *_p_FXTopWindowTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXShell *) ((FXTopWindow *) x));
}
static void *_p_FXMainWindowTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXShell *)(FXTopWindow *) ((FXMainWindow *) x));
}
static void *_p_FXRulerTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXFrame *) ((FXRuler *) x));
}
static void *_p_FXCanvasTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *) ((FXCanvas *) x));
}
static void *_p_FXScrollCornerTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *) ((FXScrollCorner *) x));
}
static void *_p_FXSeparatorTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXFrame *) ((FXSeparator *) x));
}
static void *_p_FXHorizontalSeparatorTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXFrame *)(FXSeparator *) ((FXHorizontalSeparator *) x));
}
static void *_p_FXVerticalSeparatorTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXFrame *)(FXSeparator *) ((FXVerticalSeparator *) x));
}
static void *_p_FXStatusLineTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXFrame *) ((FXStatusLine *) x));
}
static void *_p_FXComboBoxTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXComboBox *) x));
}
static void *_p_FXVerticalFrameTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXVerticalFrame *) x));
}
static void *_p_FXHorizontalFrameTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXHorizontalFrame *) x));
}
static void *_p_FX4SplitterTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *) ((FX4Splitter *) x));
}
static void *_p_FXSplitterTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *) ((FXSplitter *) x));
}
static void *_p_FXPackerTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *) ((FXPacker *) x));
}
static void *_p_FXSpinnerTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXSpinner *) x));
}
static void *_p_FXRealSpinnerTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXRealSpinner *) x));
}
static void *_p_FXScrollBarTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *) ((FXScrollBar *) x));
}
static void *_p_FXColorWheelTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXFrame *) ((FXColorWheel *) x));
}
static void *_p_FXBitmapFrameTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXFrame *) ((FXBitmapFrame *) x));
}
static void *_p_FXFontTo_p_FXId(void *x) {
    return (void *)((FXId *)  ((FXFont *) x));
}
static void *_p_FXDirBoxTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *)(FXTreeListBox *) ((FXDirBox *) x));
}
static void *_p_FXToolBarGripTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *) ((FXToolBarGrip *) x));
}
static void *_p_FXImageFrameTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXFrame *) ((FXImageFrame *) x));
}
static void *_p_FXDragCornerTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *) ((FXDragCorner *) x));
}
static void *_p_FXSwitcherTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXSwitcher *) x));
}
static void *_p_FXDirSelectorTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXDirSelector *) x));
}
static void *_p_FXFileSelectorTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXFileSelector *) x));
}
static void *_p_FXColorSelectorTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXColorSelector *) x));
}
static void *_p_FXFontSelectorTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXFontSelector *) x));
}
static void *_p_FXShutterTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *)(FXVerticalFrame *) ((FXShutter *) x));
}
static void *_p_FXDrawableTo_p_FXId(void *x) {
    return (void *)((FXId *)  ((FXDrawable *) x));
}
static void *_p_FXCursorTo_p_FXId(void *x) {
    return (void *)((FXId *)  ((FXCursor *) x));
}
static void *_p_FXCURCursorTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXCursor *) ((FXCURCursor *) x));
}
static void *_p_FXGIFCursorTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXCursor *) ((FXGIFCursor *) x));
}
static void *_p_FXProgressBarTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXFrame *) ((FXProgressBar *) x));
}
static void *_p_FXListBoxTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXListBox *) x));
}
static void *_p_FXTreeListBoxTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXTreeListBox *) x));
}
static void *_p_FXHeaderTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXFrame *) ((FXHeader *) x));
}
static void *_p_FXMatrixTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXMatrix *) x));
}
static void *_p_FXColorWellTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXFrame *) ((FXColorWell *) x));
}
static void *_p_FXShutterItemTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *)(FXVerticalFrame *) ((FXShutterItem *) x));
}
static void *_p_FXDialTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXFrame *) ((FXDial *) x));
}
static void *_p_FXToolBarTabTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXFrame *) ((FXToolBarTab *) x));
}
static void *_p_FXFrameTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *) ((FXFrame *) x));
}
static void *_p_FXTabBarTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXTabBar *) x));
}
static void *_p_FXImageViewTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXScrollArea *) ((FXImageView *) x));
}
static void *_p_FXSliderTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXFrame *) ((FXSlider *) x));
}
static void *_p_FXRealSliderTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXFrame *) ((FXRealSlider *) x));
}
static void *_p_FXSpringTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXSpring *) x));
}
static void *_p_FXVisualTo_p_FXId(void *x) {
    return (void *)((FXId *)  ((FXVisual *) x));
}
static void *_p_FXColorBarTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXFrame *) ((FXColorBar *) x));
}
static void *_p_FXToolBarShellTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXShell *)(FXTopWindow *) ((FXToolBarShell *) x));
}
static void *_p_FXTabBookTo_p_FXTabBar(void *x) {
    return (void *)((FXTabBar *)  ((FXTabBook *) x));
}
static swig_type_info _swigt__p_FXDriveBox[] = {{"_p_FXDriveBox", 0, "FXDriveBox *", 0, 0, 0, 0},{"_p_FXDriveBox", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXToolBar[] = {{"_p_FXToolBar", 0, "FXToolBar *", 0, 0, 0, 0},{"_p_FXToolBar", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXTreeItem[] = {{"_p_FXTreeItem", 0, "FXTreeItem *", 0, 0, 0, 0},{"_p_FXTreeItem", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXComposite[] = {{"_p_FXComposite", 0, "FXComposite *", 0, 0, 0, 0},{"_p_FXDriveBox", _p_FXDriveBoxTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXToolBar", _p_FXToolBarTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXComposite", 0, 0, 0, 0, 0, 0},{"_p_FXToolTip", _p_FXToolTipTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXTabBook", _p_FXTabBookTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXGroupBox", _p_FXGroupBoxTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXShell", _p_FXShellTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXStatusBar", _p_FXStatusBarTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXScrollArea", _p_FXScrollAreaTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXPopup", _p_FXPopupTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXRootWindow", _p_FXRootWindowTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXTopWindow", _p_FXTopWindowTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXMainWindow", _p_FXMainWindowTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXScrollWindow", _p_FXScrollWindowTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXComboBox", _p_FXComboBoxTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXHorizontalFrame", _p_FXHorizontalFrameTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXVerticalFrame", _p_FXVerticalFrameTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FX4Splitter", _p_FX4SplitterTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXSplitter", _p_FXSplitterTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXRealSpinner", _p_FXRealSpinnerTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXSpinner", _p_FXSpinnerTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXPacker", _p_FXPackerTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXDirBox", _p_FXDirBoxTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXFileSelector", _p_FXFileSelectorTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXDirSelector", _p_FXDirSelectorTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXColorSelector", _p_FXColorSelectorTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXFontSelector", _p_FXFontSelectorTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXSwitcher", _p_FXSwitcherTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXShutter", _p_FXShutterTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXListBox", _p_FXListBoxTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXTreeListBox", _p_FXTreeListBoxTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXMatrix", _p_FXMatrixTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXShutterItem", _p_FXShutterItemTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXTabBar", _p_FXTabBarTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXImageView", _p_FXImageViewTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXSpring", _p_FXSpringTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXToolBarShell", _p_FXToolBarShellTo_p_FXComposite, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXToolTip[] = {{"_p_FXToolTip", 0, "FXToolTip *", 0, 0, 0, 0},{"_p_FXToolTip", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXTabBook[] = {{"_p_FXTabBook", 0, "FXTabBook *", 0, 0, 0, 0},{"_p_FXTabBook", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXImage[] = {{"_p_FXImage", 0, "FXImage *", 0, 0, 0, 0},{"_p_FXImage", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXId[] = {{"_p_FXId", 0, "FXId *", 0, 0, 0, 0},{"_p_FXDriveBox", _p_FXDriveBoxTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXDial", _p_FXDialTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXToolBar", _p_FXToolBarTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXComposite", _p_FXCompositeTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXToolTip", _p_FXToolTipTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXTabBook", _p_FXTabBookTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXTextField", _p_FXTextFieldTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXId", 0, 0, 0, 0, 0, 0},{"_p_FXArrowButton", _p_FXArrowButtonTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXGroupBox", _p_FXGroupBoxTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXShell", _p_FXShellTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXStatusBar", _p_FXStatusBarTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXScrollArea", _p_FXScrollAreaTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXPopup", _p_FXPopupTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXRootWindow", _p_FXRootWindowTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXScrollWindow", _p_FXScrollWindowTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXTopWindow", _p_FXTopWindowTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXMainWindow", _p_FXMainWindowTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXScrollCorner", _p_FXScrollCornerTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXWindow", _p_FXWindowTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXRuler", _p_FXRulerTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXCanvas", _p_FXCanvasTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXComboBox", _p_FXComboBoxTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXSeparator", _p_FXSeparatorTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXHorizontalSeparator", _p_FXHorizontalSeparatorTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXVerticalSeparator", _p_FXVerticalSeparatorTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXStatusLine", _p_FXStatusLineTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXHorizontalFrame", _p_FXHorizontalFrameTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXVerticalFrame", _p_FXVerticalFrameTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FX4Splitter", _p_FX4SplitterTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXSplitter", _p_FXSplitterTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXRealSpinner", _p_FXRealSpinnerTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXSpinner", _p_FXSpinnerTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXPacker", _p_FXPackerTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXScrollBar", _p_FXScrollBarTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXColorWheel", _p_FXColorWheelTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXBitmapFrame", _p_FXBitmapFrameTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXDirBox", _p_FXDirBoxTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXToolBarGrip", _p_FXToolBarGripTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXImageFrame", _p_FXImageFrameTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXDragCorner", _p_FXDragCornerTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXDirSelector", _p_FXDirSelectorTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXFileSelector", _p_FXFileSelectorTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXColorSelector", _p_FXColorSelectorTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXFontSelector", _p_FXFontSelectorTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXSwitcher", _p_FXSwitcherTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXShutter", _p_FXShutterTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXProgressBar", _p_FXProgressBarTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXDrawable", _p_FXDrawableTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXCursor", _p_FXCursorTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXCURCursor", _p_FXCURCursorTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXGIFCursor", _p_FXGIFCursorTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXListBox", _p_FXListBoxTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXTreeListBox", _p_FXTreeListBoxTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXHeader", _p_FXHeaderTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXMatrix", _p_FXMatrixTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXShutterItem", _p_FXShutterItemTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXColorWell", _p_FXColorWellTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXToolBarTab", _p_FXToolBarTabTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXTabBar", _p_FXTabBarTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXFrame", _p_FXFrameTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXFont", _p_FXFontTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXImageView", _p_FXImageViewTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXSlider", _p_FXSliderTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXRealSlider", _p_FXRealSliderTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXSpring", _p_FXSpringTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXVisual", _p_FXVisualTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXColorBar", _p_FXColorBarTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXToolBarShell", _p_FXToolBarShellTo_p_FXId, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXShell[] = {{"_p_FXShell", 0, "FXShell *", 0, 0, 0, 0},{"_p_FXShell", 0, 0, 0, 0, 0, 0},{"_p_FXPopup", _p_FXPopupTo_p_FXShell, 0, 0, 0, 0, 0},{"_p_FXTopWindow", _p_FXTopWindowTo_p_FXShell, 0, 0, 0, 0, 0},{"_p_FXMainWindow", _p_FXMainWindowTo_p_FXShell, 0, 0, 0, 0, 0},{"_p_FXToolTip", _p_FXToolTipTo_p_FXShell, 0, 0, 0, 0, 0},{"_p_FXToolBarShell", _p_FXToolBarShellTo_p_FXShell, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXScrollArea[] = {{"_p_FXScrollArea", 0, "FXScrollArea *", 0, 0, 0, 0},{"_p_FXScrollWindow", _p_FXScrollWindowTo_p_FXScrollArea, 0, 0, 0, 0, 0},{"_p_FXScrollArea", 0, 0, 0, 0, 0, 0},{"_p_FXImageView", _p_FXImageViewTo_p_FXScrollArea, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXScrollCorner[] = {{"_p_FXScrollCorner", 0, "FXScrollCorner *", 0, 0, 0, 0},{"_p_FXScrollCorner", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXWindow[] = {{"_p_FXWindow", 0, "FXWindow *", 0, 0, 0, 0},{"_p_FXDriveBox", _p_FXDriveBoxTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXDial", _p_FXDialTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXToolBar", _p_FXToolBarTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXComposite", _p_FXCompositeTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXToolTip", _p_FXToolTipTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXTabBook", _p_FXTabBookTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXTextField", _p_FXTextFieldTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXArrowButton", _p_FXArrowButtonTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXGroupBox", _p_FXGroupBoxTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXShell", _p_FXShellTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXStatusBar", _p_FXStatusBarTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXScrollArea", _p_FXScrollAreaTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXPopup", _p_FXPopupTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXRootWindow", _p_FXRootWindowTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXScrollWindow", _p_FXScrollWindowTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXWindow", 0, 0, 0, 0, 0, 0},{"_p_FXTopWindow", _p_FXTopWindowTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXMainWindow", _p_FXMainWindowTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXScrollCorner", _p_FXScrollCornerTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXRuler", _p_FXRulerTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXCanvas", _p_FXCanvasTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXComboBox", _p_FXComboBoxTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXSeparator", _p_FXSeparatorTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXHorizontalSeparator", _p_FXHorizontalSeparatorTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXVerticalSeparator", _p_FXVerticalSeparatorTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXStatusLine", _p_FXStatusLineTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXHorizontalFrame", _p_FXHorizontalFrameTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXVerticalFrame", _p_FXVerticalFrameTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FX4Splitter", _p_FX4SplitterTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXSplitter", _p_FXSplitterTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXRealSpinner", _p_FXRealSpinnerTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXSpinner", _p_FXSpinnerTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXPacker", _p_FXPackerTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXScrollBar", _p_FXScrollBarTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXColorWheel", _p_FXColorWheelTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXBitmapFrame", _p_FXBitmapFrameTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXDirBox", _p_FXDirBoxTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXToolBarGrip", _p_FXToolBarGripTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXImageFrame", _p_FXImageFrameTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXDragCorner", _p_FXDragCornerTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXDirSelector", _p_FXDirSelectorTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXFileSelector", _p_FXFileSelectorTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXColorSelector", _p_FXColorSelectorTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXFontSelector", _p_FXFontSelectorTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXSwitcher", _p_FXSwitcherTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXShutter", _p_FXShutterTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXProgressBar", _p_FXProgressBarTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXListBox", _p_FXListBoxTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXTreeListBox", _p_FXTreeListBoxTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXHeader", _p_FXHeaderTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXMatrix", _p_FXMatrixTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXShutterItem", _p_FXShutterItemTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXColorWell", _p_FXColorWellTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXToolBarTab", _p_FXToolBarTabTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXTabBar", _p_FXTabBarTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXFrame", _p_FXFrameTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXImageView", _p_FXImageViewTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXSlider", _p_FXSliderTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXRealSlider", _p_FXRealSliderTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXSpring", _p_FXSpringTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXColorBar", _p_FXColorBarTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXToolBarShell", _p_FXToolBarShellTo_p_FXWindow, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXTopWindow[] = {{"_p_FXTopWindow", 0, "FXTopWindow *", 0, 0, 0, 0},{"_p_FXTopWindow", 0, 0, 0, 0, 0, 0},{"_p_FXMainWindow", _p_FXMainWindowTo_p_FXTopWindow, 0, 0, 0, 0, 0},{"_p_FXToolBarShell", _p_FXToolBarShellTo_p_FXTopWindow, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXCanvas[] = {{"_p_FXCanvas", 0, "FXCanvas *", 0, 0, 0, 0},{"_p_FXCanvas", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXIcon[] = {{"_p_FXIcon", 0, "FXIcon *", 0, 0, 0, 0},{"_p_FXIcon", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXComboBox[] = {{"_p_FXComboBox", 0, "FXComboBox *", 0, 0, 0, 0},{"_p_FXComboBox", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXObject[] = {{"_p_FXObject", 0, "FXObject *", 0, 0, 0, 0},{"_p_FXDocument", _p_FXDocumentTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXRegistry", _p_FXRegistryTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXHeaderItem", _p_FXHeaderItemTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXShutterItem", _p_FXShutterItemTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXColorBar", _p_FXColorBarTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXTabBar", _p_FXTabBarTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXSwitcher", _p_FXSwitcherTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXTextField", _p_FXTextFieldTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXToolBarTab", _p_FXToolBarTabTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXDriveBox", _p_FXDriveBoxTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXIconDict", _p_FXIconDictTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXMatrix", _p_FXMatrixTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXFileDict", _p_FXFileDictTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXRecentFiles", _p_FXRecentFilesTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXScrollCorner", _p_FXScrollCornerTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXArrowButton", _p_FXArrowButtonTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXPopup", _p_FXPopupTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXDrawable", _p_FXDrawableTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXFont", _p_FXFontTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXHeader", _p_FXHeaderTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FX4Splitter", _p_FX4SplitterTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXSplitter", _p_FXSplitterTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXSpring", _p_FXSpringTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXApp", _p_FXAppTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXPacker", _p_FXPackerTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXTabBook", _p_FXTabBookTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXImageFrame", _p_FXImageFrameTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXVerticalSeparator", _p_FXVerticalSeparatorTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXHorizontalSeparator", _p_FXHorizontalSeparatorTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXSeparator", _p_FXSeparatorTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXProgressBar", _p_FXProgressBarTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXShutter", _p_FXShutterTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXToolTip", _p_FXToolTipTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXComposite", _p_FXCompositeTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXDict", _p_FXDictTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXBitmapFrame", _p_FXBitmapFrameTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXRealSlider", _p_FXRealSliderTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXSlider", _p_FXSliderTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXSettings", _p_FXSettingsTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXGroupBox", _p_FXGroupBoxTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXDataTarget", _p_FXDataTargetTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXDebugTarget", _p_FXDebugTargetTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXListBox", _p_FXListBoxTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXTreeListBox", _p_FXTreeListBoxTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXCanvas", _p_FXCanvasTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXId", _p_FXIdTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXColorWheel", _p_FXColorWheelTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXDial", _p_FXDialTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXToolBarGrip", _p_FXToolBarGripTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXScrollBar", _p_FXScrollBarTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXVisual", _p_FXVisualTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXComboBox", _p_FXComboBoxTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXFrame", _p_FXFrameTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXStatusBar", _p_FXStatusBarTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXStringDict", _p_FXStringDictTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXDelegator", _p_FXDelegatorTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXAccelTable", _p_FXAccelTableTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXObject", 0, 0, 0, 0, 0, 0},{"_p_FXCursor", _p_FXCursorTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXCURCursor", _p_FXCURCursorTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXGIFCursor", _p_FXGIFCursorTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXRealSpinner", _p_FXRealSpinnerTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXSpinner", _p_FXSpinnerTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXStatusLine", _p_FXStatusLineTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXWindow", _p_FXWindowTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXTopWindow", _p_FXTopWindowTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXMainWindow", _p_FXMainWindowTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXScrollWindow", _p_FXScrollWindowTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXRootWindow", _p_FXRootWindowTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXShell", _p_FXShellTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXScrollArea", _p_FXScrollAreaTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXColorWell", _p_FXColorWellTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXDragCorner", _p_FXDragCornerTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXRuler", _p_FXRulerTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXHorizontalFrame", _p_FXHorizontalFrameTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXVerticalFrame", _p_FXVerticalFrameTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXImageView", _p_FXImageViewTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXFontSelector", _p_FXFontSelectorTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXColorSelector", _p_FXColorSelectorTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXFileSelector", _p_FXFileSelectorTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXDirSelector", _p_FXDirSelectorTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXToolBarShell", _p_FXToolBarShellTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXToolBar", _p_FXToolBarTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXDirBox", _p_FXDirBoxTo_p_FXObject, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXRealSpinner[] = {{"_p_FXRealSpinner", 0, "FXRealSpinner *", 0, 0, 0, 0},{"_p_FXRealSpinner", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXSpinner[] = {{"_p_FXSpinner", 0, "FXSpinner *", 0, 0, 0, 0},{"_p_FXSpinner", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXPacker[] = {{"_p_FXPacker", 0, "FXPacker *", 0, 0, 0, 0},{"_p_FXToolBar", _p_FXToolBarTo_p_FXPacker, 0, 0, 0, 0, 0},{"_p_FXListBox", _p_FXListBoxTo_p_FXPacker, 0, 0, 0, 0, 0},{"_p_FXTreeListBox", _p_FXTreeListBoxTo_p_FXPacker, 0, 0, 0, 0, 0},{"_p_FXComboBox", _p_FXComboBoxTo_p_FXPacker, 0, 0, 0, 0, 0},{"_p_FXShutterItem", _p_FXShutterItemTo_p_FXPacker, 0, 0, 0, 0, 0},{"_p_FXDirBox", _p_FXDirBoxTo_p_FXPacker, 0, 0, 0, 0, 0},{"_p_FXStatusBar", _p_FXStatusBarTo_p_FXPacker, 0, 0, 0, 0, 0},{"_p_FXTabBar", _p_FXTabBarTo_p_FXPacker, 0, 0, 0, 0, 0},{"_p_FXTabBook", _p_FXTabBookTo_p_FXPacker, 0, 0, 0, 0, 0},{"_p_FXGroupBox", _p_FXGroupBoxTo_p_FXPacker, 0, 0, 0, 0, 0},{"_p_FXShutter", _p_FXShutterTo_p_FXPacker, 0, 0, 0, 0, 0},{"_p_FXPacker", 0, 0, 0, 0, 0, 0},{"_p_FXHorizontalFrame", _p_FXHorizontalFrameTo_p_FXPacker, 0, 0, 0, 0, 0},{"_p_FXVerticalFrame", _p_FXVerticalFrameTo_p_FXPacker, 0, 0, 0, 0, 0},{"_p_FXRealSpinner", _p_FXRealSpinnerTo_p_FXPacker, 0, 0, 0, 0, 0},{"_p_FXSpinner", _p_FXSpinnerTo_p_FXPacker, 0, 0, 0, 0, 0},{"_p_FXMatrix", _p_FXMatrixTo_p_FXPacker, 0, 0, 0, 0, 0},{"_p_FXSpring", _p_FXSpringTo_p_FXPacker, 0, 0, 0, 0, 0},{"_p_FXDirSelector", _p_FXDirSelectorTo_p_FXPacker, 0, 0, 0, 0, 0},{"_p_FXFileSelector", _p_FXFileSelectorTo_p_FXPacker, 0, 0, 0, 0, 0},{"_p_FXColorSelector", _p_FXColorSelectorTo_p_FXPacker, 0, 0, 0, 0, 0},{"_p_FXFontSelector", _p_FXFontSelectorTo_p_FXPacker, 0, 0, 0, 0, 0},{"_p_FXDriveBox", _p_FXDriveBoxTo_p_FXPacker, 0, 0, 0, 0, 0},{"_p_FXSwitcher", _p_FXSwitcherTo_p_FXPacker, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXScrollBar[] = {{"_p_FXScrollBar", 0, "FXScrollBar *", 0, 0, 0, 0},{"_p_FXScrollBar", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXDirBox[] = {{"_p_FXDirBox", 0, "FXDirBox *", 0, 0, 0, 0},{"_p_FXDirBox", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXToolBarGrip[] = {{"_p_FXToolBarGrip", 0, "FXToolBarGrip *", 0, 0, 0, 0},{"_p_FXToolBarGrip", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXDragCorner[] = {{"_p_FXDragCorner", 0, "FXDragCorner *", 0, 0, 0, 0},{"_p_FXDragCorner", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXFileDict[] = {{"_p_FXFileDict", 0, "FXFileDict *", 0, 0, 0, 0},{"_p_FXFileDict", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXDirSelector[] = {{"_p_FXDirSelector", 0, "FXDirSelector *", 0, 0, 0, 0},{"_p_FXDirSelector", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXFileSelector[] = {{"_p_FXFileSelector", 0, "FXFileSelector *", 0, 0, 0, 0},{"_p_FXFileSelector", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXColorSelector[] = {{"_p_FXColorSelector", 0, "FXColorSelector *", 0, 0, 0, 0},{"_p_FXColorSelector", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXFontSelector[] = {{"_p_FXFontSelector", 0, "FXFontSelector *", 0, 0, 0, 0},{"_p_FXFontSelector", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXDrawable[] = {{"_p_FXDrawable", 0, "FXDrawable *", 0, 0, 0, 0},{"_p_FXDriveBox", _p_FXDriveBoxTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXDial", _p_FXDialTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXToolBar", _p_FXToolBarTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXComposite", _p_FXCompositeTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXToolTip", _p_FXToolTipTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXTabBook", _p_FXTabBookTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXTextField", _p_FXTextFieldTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXArrowButton", _p_FXArrowButtonTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXGroupBox", _p_FXGroupBoxTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXShell", _p_FXShellTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXStatusBar", _p_FXStatusBarTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXScrollArea", _p_FXScrollAreaTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXPopup", _p_FXPopupTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXRootWindow", _p_FXRootWindowTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXScrollWindow", _p_FXScrollWindowTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXTopWindow", _p_FXTopWindowTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXMainWindow", _p_FXMainWindowTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXScrollCorner", _p_FXScrollCornerTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXWindow", _p_FXWindowTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXRuler", _p_FXRulerTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXCanvas", _p_FXCanvasTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXComboBox", _p_FXComboBoxTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXSeparator", _p_FXSeparatorTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXHorizontalSeparator", _p_FXHorizontalSeparatorTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXVerticalSeparator", _p_FXVerticalSeparatorTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXStatusLine", _p_FXStatusLineTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXHorizontalFrame", _p_FXHorizontalFrameTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXVerticalFrame", _p_FXVerticalFrameTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FX4Splitter", _p_FX4SplitterTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXSplitter", _p_FXSplitterTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXRealSpinner", _p_FXRealSpinnerTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXSpinner", _p_FXSpinnerTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXPacker", _p_FXPackerTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXScrollBar", _p_FXScrollBarTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXColorWheel", _p_FXColorWheelTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXBitmapFrame", _p_FXBitmapFrameTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXDirBox", _p_FXDirBoxTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXToolBarGrip", _p_FXToolBarGripTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXImageFrame", _p_FXImageFrameTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXDragCorner", _p_FXDragCornerTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXDirSelector", _p_FXDirSelectorTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXFileSelector", _p_FXFileSelectorTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXColorSelector", _p_FXColorSelectorTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXFontSelector", _p_FXFontSelectorTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXSwitcher", _p_FXSwitcherTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXShutter", _p_FXShutterTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXDrawable", 0, 0, 0, 0, 0, 0},{"_p_FXProgressBar", _p_FXProgressBarTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXListBox", _p_FXListBoxTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXTreeListBox", _p_FXTreeListBoxTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXHeader", _p_FXHeaderTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXMatrix", _p_FXMatrixTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXShutterItem", _p_FXShutterItemTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXColorWell", _p_FXColorWellTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXToolBarTab", _p_FXToolBarTabTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXTabBar", _p_FXTabBarTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXFrame", _p_FXFrameTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXImageView", _p_FXImageViewTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXSlider", _p_FXSliderTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXRealSlider", _p_FXRealSliderTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXSpring", _p_FXSpringTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXColorBar", _p_FXColorBarTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXToolBarShell", _p_FXToolBarShellTo_p_FXDrawable, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXStream[] = {{"_p_FXStream", 0, "FXStream *", 0, 0, 0, 0},{"_p_FXFileStream", _p_FXFileStreamTo_p_FXStream, 0, 0, 0, 0, 0},{"_p_FXMemoryStream", _p_FXMemoryStreamTo_p_FXStream, 0, 0, 0, 0, 0},{"_p_FXStream", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXTreeListBox[] = {{"_p_FXTreeListBox", 0, "FXTreeListBox *", 0, 0, 0, 0},{"_p_FXTreeListBox", 0, 0, 0, 0, 0, 0},{"_p_FXDirBox", _p_FXDirBoxTo_p_FXTreeListBox, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXListBox[] = {{"_p_FXListBox", 0, "FXListBox *", 0, 0, 0, 0},{"_p_FXDriveBox", _p_FXDriveBoxTo_p_FXListBox, 0, 0, 0, 0, 0},{"_p_FXListBox", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXFontDesc[] = {{"_p_FXFontDesc", 0, "FXFontDesc *", 0, 0, 0, 0},{"_p_FXFontDesc", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXApp[] = {{"_p_FXApp", 0, "FXApp *", 0, 0, 0, 0},{"_p_FXApp", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXFont[] = {{"_p_FXFont", 0, "FXFont *", 0, 0, 0, 0},{"_p_FXFont", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXTabBar[] = {{"_p_FXTabBar", 0, "FXTabBar *", 0, 0, 0, 0},{"_p_FXTabBook", _p_FXTabBookTo_p_FXTabBar, 0, 0, 0, 0, 0},{"_p_FXTabBar", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXImageView[] = {{"_p_FXImageView", 0, "FXImageView *", 0, 0, 0, 0},{"_p_FXImageView", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXButton[] = {{"_p_FXButton", 0, "FXButton *", 0, 0, 0, 0},{"_p_FXButton", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXToolBarShell[] = {{"_p_FXToolBarShell", 0, "FXToolBarShell *", 0, 0, 0, 0},{"_p_FXToolBarShell", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};

static swig_type_info *swig_types_initial[] = {
_swigt__p_FXDriveBox, 
_swigt__p_FXToolBar, 
_swigt__p_FXTreeItem, 
_swigt__p_FXComposite, 
_swigt__p_FXToolTip, 
_swigt__p_FXTabBook, 
_swigt__p_FXImage, 
_swigt__p_FXId, 
_swigt__p_FXShell, 
_swigt__p_FXScrollArea, 
_swigt__p_FXScrollCorner, 
_swigt__p_FXWindow, 
_swigt__p_FXTopWindow, 
_swigt__p_FXCanvas, 
_swigt__p_FXIcon, 
_swigt__p_FXComboBox, 
_swigt__p_FXObject, 
_swigt__p_FXRealSpinner, 
_swigt__p_FXSpinner, 
_swigt__p_FXPacker, 
_swigt__p_FXScrollBar, 
_swigt__p_FXDirBox, 
_swigt__p_FXToolBarGrip, 
_swigt__p_FXDragCorner, 
_swigt__p_FXFileDict, 
_swigt__p_FXDirSelector, 
_swigt__p_FXFileSelector, 
_swigt__p_FXColorSelector, 
_swigt__p_FXFontSelector, 
_swigt__p_FXDrawable, 
_swigt__p_FXStream, 
_swigt__p_FXTreeListBox, 
_swigt__p_FXListBox, 
_swigt__p_FXFontDesc, 
_swigt__p_FXApp, 
_swigt__p_FXFont, 
_swigt__p_FXTabBar, 
_swigt__p_FXImageView, 
_swigt__p_FXButton, 
_swigt__p_FXToolBarShell, 
0
};


/* -------- TYPE CONVERSION AND EQUIVALENCE RULES (END) -------- */


#ifdef __cplusplus
extern "C"
#endif
SWIGEXPORT(void) Init_ui(void) {
    int i;
    
    SWIG_InitRuntime();
    
    for (i = 0; swig_types_initial[i]; i++) {
        swig_types[i] = SWIG_TypeRegister(swig_types_initial[i]);
        SWIG_define_class(swig_types[i]);
    }
    
    rb_define_const(mFox,"SPIN_NORMAL", INT2NUM(SPIN_NORMAL));
    rb_define_const(mFox,"SPIN_CYCLIC", INT2NUM(SPIN_CYCLIC));
    rb_define_const(mFox,"SPIN_NOTEXT", INT2NUM(SPIN_NOTEXT));
    rb_define_const(mFox,"SPIN_NOMAX", INT2NUM(SPIN_NOMAX));
    rb_define_const(mFox,"SPIN_NOMIN", INT2NUM(SPIN_NOMIN));
    
    cFXSpinner.klass = rb_define_class_under(mFox, "FXSpinner", ((swig_class *) SWIGTYPE_p_FXPacker->clientdata)->klass);
    SWIG_TypeClientData(SWIGTYPE_p_FXSpinner, (void *) &cFXSpinner);
    rb_define_alloc_func(cFXSpinner.klass, _wrap_FXSpinner_allocate);
    rb_define_method(cFXSpinner.klass, "initialize", VALUEFUNC(_wrap_new_FXSpinner), -1);
    rb_define_method(cFXSpinner.klass, "onUpdIncrement", VALUEFUNC(_wrap_FXSpinner_onUpdIncrement), -1);
    rb_define_method(cFXSpinner.klass, "onCmdIncrement", VALUEFUNC(_wrap_FXSpinner_onCmdIncrement), -1);
    rb_define_method(cFXSpinner.klass, "onUpdDecrement", VALUEFUNC(_wrap_FXSpinner_onUpdDecrement), -1);
    rb_define_method(cFXSpinner.klass, "onCmdDecrement", VALUEFUNC(_wrap_FXSpinner_onCmdDecrement), -1);
    rb_define_method(cFXSpinner.klass, "onUpdEntry", VALUEFUNC(_wrap_FXSpinner_onUpdEntry), -1);
    rb_define_method(cFXSpinner.klass, "onCmdEntry", VALUEFUNC(_wrap_FXSpinner_onCmdEntry), -1);
    rb_define_method(cFXSpinner.klass, "onChgEntry", VALUEFUNC(_wrap_FXSpinner_onChgEntry), -1);
    rb_define_method(cFXSpinner.klass, "onWheelEntry", VALUEFUNC(_wrap_FXSpinner_onWheelEntry), -1);
    rb_define_method(cFXSpinner.klass, "onKeyPress", VALUEFUNC(_wrap_FXSpinner_onKeyPress), -1);
    rb_define_method(cFXSpinner.klass, "onKeyRelease", VALUEFUNC(_wrap_FXSpinner_onKeyRelease), -1);
    rb_define_method(cFXSpinner.klass, "onCmdSetValue", VALUEFUNC(_wrap_FXSpinner_onCmdSetValue), -1);
    rb_define_method(cFXSpinner.klass, "onCmdSetIntValue", VALUEFUNC(_wrap_FXSpinner_onCmdSetIntValue), -1);
    rb_define_method(cFXSpinner.klass, "onCmdGetIntValue", VALUEFUNC(_wrap_FXSpinner_onCmdGetIntValue), -1);
    rb_define_method(cFXSpinner.klass, "onCmdSetIntRange", VALUEFUNC(_wrap_FXSpinner_onCmdSetIntRange), -1);
    rb_define_method(cFXSpinner.klass, "onCmdGetIntRange", VALUEFUNC(_wrap_FXSpinner_onCmdGetIntRange), -1);
    rb_define_method(cFXSpinner.klass, "onFocusSelf", VALUEFUNC(_wrap_FXSpinner_onFocusSelf), -1);
    rb_define_const(cFXSpinner.klass,"ID_INCREMENT", INT2NUM(FXSpinner::ID_INCREMENT));
    rb_define_const(cFXSpinner.klass,"ID_DECREMENT", INT2NUM(FXSpinner::ID_DECREMENT));
    rb_define_const(cFXSpinner.klass,"ID_ENTRY", INT2NUM(FXSpinner::ID_ENTRY));
    rb_define_const(cFXSpinner.klass,"ID_LAST", INT2NUM(FXSpinner::ID_LAST));
    rb_define_method(cFXSpinner.klass, "increment", VALUEFUNC(_wrap_FXSpinner_increment), -1);
    rb_define_method(cFXSpinner.klass, "decrement", VALUEFUNC(_wrap_FXSpinner_decrement), -1);
    rb_define_method(cFXSpinner.klass, "isCyclic", VALUEFUNC(_wrap_FXSpinner_isCyclic), -1);
    rb_define_method(cFXSpinner.klass, "setCyclic", VALUEFUNC(_wrap_FXSpinner_setCyclic), -1);
    rb_define_method(cFXSpinner.klass, "isTextVisible", VALUEFUNC(_wrap_FXSpinner_isTextVisible), -1);
    rb_define_method(cFXSpinner.klass, "setTextVisible", VALUEFUNC(_wrap_FXSpinner_setTextVisible), -1);
    rb_define_method(cFXSpinner.klass, "getValue", VALUEFUNC(_wrap_FXSpinner_getValue), -1);
    rb_define_method(cFXSpinner.klass, "setRange", VALUEFUNC(_wrap_FXSpinner_setRange), -1);
    rb_define_method(cFXSpinner.klass, "getRange", VALUEFUNC(_wrap_FXSpinner_getRange), -1);
    rb_define_method(cFXSpinner.klass, "setIncrement", VALUEFUNC(_wrap_FXSpinner_setIncrement), -1);
    rb_define_method(cFXSpinner.klass, "getIncrement", VALUEFUNC(_wrap_FXSpinner_getIncrement), -1);
    rb_define_method(cFXSpinner.klass, "setFont", VALUEFUNC(_wrap_FXSpinner_setFont), -1);
    rb_define_method(cFXSpinner.klass, "getFont", VALUEFUNC(_wrap_FXSpinner_getFont), -1);
    rb_define_method(cFXSpinner.klass, "setHelpText", VALUEFUNC(_wrap_FXSpinner_setHelpText), -1);
    rb_define_method(cFXSpinner.klass, "getHelpText", VALUEFUNC(_wrap_FXSpinner_getHelpText), -1);
    rb_define_method(cFXSpinner.klass, "setTipText", VALUEFUNC(_wrap_FXSpinner_setTipText), -1);
    rb_define_method(cFXSpinner.klass, "getTipText", VALUEFUNC(_wrap_FXSpinner_getTipText), -1);
    rb_define_method(cFXSpinner.klass, "setSpinnerStyle", VALUEFUNC(_wrap_FXSpinner_setSpinnerStyle), -1);
    rb_define_method(cFXSpinner.klass, "getSpinnerStyle", VALUEFUNC(_wrap_FXSpinner_getSpinnerStyle), -1);
    rb_define_method(cFXSpinner.klass, "setEditable", VALUEFUNC(_wrap_FXSpinner_setEditable), -1);
    rb_define_method(cFXSpinner.klass, "isEditable", VALUEFUNC(_wrap_FXSpinner_isEditable), -1);
    rb_define_method(cFXSpinner.klass, "setUpArrowColor", VALUEFUNC(_wrap_FXSpinner_setUpArrowColor), -1);
    rb_define_method(cFXSpinner.klass, "getUpArrowColor", VALUEFUNC(_wrap_FXSpinner_getUpArrowColor), -1);
    rb_define_method(cFXSpinner.klass, "setDownArrowColor", VALUEFUNC(_wrap_FXSpinner_setDownArrowColor), -1);
    rb_define_method(cFXSpinner.klass, "getDownArrowColor", VALUEFUNC(_wrap_FXSpinner_getDownArrowColor), -1);
    rb_define_method(cFXSpinner.klass, "setTextColor", VALUEFUNC(_wrap_FXSpinner_setTextColor), -1);
    rb_define_method(cFXSpinner.klass, "getTextColor", VALUEFUNC(_wrap_FXSpinner_getTextColor), -1);
    rb_define_method(cFXSpinner.klass, "setSelBackColor", VALUEFUNC(_wrap_FXSpinner_setSelBackColor), -1);
    rb_define_method(cFXSpinner.klass, "getSelBackColor", VALUEFUNC(_wrap_FXSpinner_getSelBackColor), -1);
    rb_define_method(cFXSpinner.klass, "setSelTextColor", VALUEFUNC(_wrap_FXSpinner_setSelTextColor), -1);
    rb_define_method(cFXSpinner.klass, "getSelTextColor", VALUEFUNC(_wrap_FXSpinner_getSelTextColor), -1);
    rb_define_method(cFXSpinner.klass, "setCursorColor", VALUEFUNC(_wrap_FXSpinner_setCursorColor), -1);
    rb_define_method(cFXSpinner.klass, "getCursorColor", VALUEFUNC(_wrap_FXSpinner_getCursorColor), -1);
    rb_define_method(cFXSpinner.klass, "setNumColumns", VALUEFUNC(_wrap_FXSpinner_setNumColumns), -1);
    rb_define_method(cFXSpinner.klass, "getNumColumns", VALUEFUNC(_wrap_FXSpinner_getNumColumns), -1);
    rb_define_method(cFXSpinner.klass, "save", VALUEFUNC(_wrap_FXSpinner_save), -1);
    rb_define_method(cFXSpinner.klass, "load", VALUEFUNC(_wrap_FXSpinner_load), -1);
    rb_define_method(cFXSpinner.klass, "create", VALUEFUNC(_wrap_FXSpinner_create), -1);
    rb_define_method(cFXSpinner.klass, "detach", VALUEFUNC(_wrap_FXSpinner_detach), -1);
    rb_define_method(cFXSpinner.klass, "destroy", VALUEFUNC(_wrap_FXSpinner_destroy), -1);
    rb_define_method(cFXSpinner.klass, "resize", VALUEFUNC(_wrap_FXSpinner_resize), -1);
    rb_define_method(cFXSpinner.klass, "getDefaultWidth", VALUEFUNC(_wrap_FXSpinner_getDefaultWidth), -1);
    rb_define_method(cFXSpinner.klass, "getDefaultHeight", VALUEFUNC(_wrap_FXSpinner_getDefaultHeight), -1);
    rb_define_method(cFXSpinner.klass, "getWidthForHeight", VALUEFUNC(_wrap_FXSpinner_getWidthForHeight), -1);
    rb_define_method(cFXSpinner.klass, "getHeightForWidth", VALUEFUNC(_wrap_FXSpinner_getHeightForWidth), -1);
    rb_define_method(cFXSpinner.klass, "canFocus", VALUEFUNC(_wrap_FXSpinner_canFocus), -1);
    rb_define_method(cFXSpinner.klass, "setFocus", VALUEFUNC(_wrap_FXSpinner_setFocus), -1);
    rb_define_method(cFXSpinner.klass, "killFocus", VALUEFUNC(_wrap_FXSpinner_killFocus), -1);
    rb_define_method(cFXSpinner.klass, "setDefault", VALUEFUNC(_wrap_FXSpinner_setDefault), -1);
    rb_define_method(cFXSpinner.klass, "enable", VALUEFUNC(_wrap_FXSpinner_enable), -1);
    rb_define_method(cFXSpinner.klass, "disable", VALUEFUNC(_wrap_FXSpinner_disable), -1);
    rb_define_method(cFXSpinner.klass, "raiseWindow", VALUEFUNC(_wrap_FXSpinner_raiseWindow), -1);
    rb_define_method(cFXSpinner.klass, "lower", VALUEFUNC(_wrap_FXSpinner_lower), -1);
    rb_define_method(cFXSpinner.klass, "move", VALUEFUNC(_wrap_FXSpinner_move), -1);
    rb_define_method(cFXSpinner.klass, "position", VALUEFUNC(_wrap_FXSpinner_position), -1);
    rb_define_method(cFXSpinner.klass, "layout", VALUEFUNC(_wrap_FXSpinner_layout), -1);
    rb_define_method(cFXSpinner.klass, "recalc", VALUEFUNC(_wrap_FXSpinner_recalc), -1);
    rb_define_method(cFXSpinner.klass, "reparent", VALUEFUNC(_wrap_FXSpinner_reparent), -1);
    rb_define_method(cFXSpinner.klass, "show", VALUEFUNC(_wrap_FXSpinner_show), -1);
    rb_define_method(cFXSpinner.klass, "hide", VALUEFUNC(_wrap_FXSpinner_hide), -1);
    rb_define_method(cFXSpinner.klass, "isComposite", VALUEFUNC(_wrap_FXSpinner_isComposite), -1);
    rb_define_method(cFXSpinner.klass, "contains", VALUEFUNC(_wrap_FXSpinner_contains), -1);
    rb_define_method(cFXSpinner.klass, "doesSaveUnder", VALUEFUNC(_wrap_FXSpinner_doesSaveUnder), -1);
    rb_define_method(cFXSpinner.klass, "setBackColor", VALUEFUNC(_wrap_FXSpinner_setBackColor), -1);
    rb_define_method(cFXSpinner.klass, "setValue", VALUEFUNC(_wrap_FXSpinner_setValue), -1);
    cFXSpinner.mark = (void (*)(void *)) FXRbSpinner::markfunc;
    cFXSpinner.destroy = (void (*)(void *)) FXRbObject::freefunc;
    rb_define_const(mFox,"REALSPIN_NORMAL", INT2NUM(REALSPIN_NORMAL));
    rb_define_const(mFox,"REALSPIN_CYCLIC", INT2NUM(REALSPIN_CYCLIC));
    rb_define_const(mFox,"REALSPIN_NOTEXT", INT2NUM(REALSPIN_NOTEXT));
    rb_define_const(mFox,"REALSPIN_NOMAX", INT2NUM(REALSPIN_NOMAX));
    rb_define_const(mFox,"REALSPIN_NOMIN", INT2NUM(REALSPIN_NOMIN));
    rb_define_const(mFox,"REALSPIN_LOG", INT2NUM(REALSPIN_LOG));
    
    cFXRealSpinner.klass = rb_define_class_under(mFox, "FXRealSpinner", ((swig_class *) SWIGTYPE_p_FXPacker->clientdata)->klass);
    SWIG_TypeClientData(SWIGTYPE_p_FXRealSpinner, (void *) &cFXRealSpinner);
    rb_define_alloc_func(cFXRealSpinner.klass, _wrap_FXRealSpinner_allocate);
    rb_define_method(cFXRealSpinner.klass, "initialize", VALUEFUNC(_wrap_new_FXRealSpinner), -1);
    rb_define_method(cFXRealSpinner.klass, "onUpdIncrement", VALUEFUNC(_wrap_FXRealSpinner_onUpdIncrement), -1);
    rb_define_method(cFXRealSpinner.klass, "onCmdIncrement", VALUEFUNC(_wrap_FXRealSpinner_onCmdIncrement), -1);
    rb_define_method(cFXRealSpinner.klass, "onUpdDecrement", VALUEFUNC(_wrap_FXRealSpinner_onUpdDecrement), -1);
    rb_define_method(cFXRealSpinner.klass, "onCmdDecrement", VALUEFUNC(_wrap_FXRealSpinner_onCmdDecrement), -1);
    rb_define_method(cFXRealSpinner.klass, "onUpdEntry", VALUEFUNC(_wrap_FXRealSpinner_onUpdEntry), -1);
    rb_define_method(cFXRealSpinner.klass, "onCmdEntry", VALUEFUNC(_wrap_FXRealSpinner_onCmdEntry), -1);
    rb_define_method(cFXRealSpinner.klass, "onChgEntry", VALUEFUNC(_wrap_FXRealSpinner_onChgEntry), -1);
    rb_define_method(cFXRealSpinner.klass, "onWheelEntry", VALUEFUNC(_wrap_FXRealSpinner_onWheelEntry), -1);
    rb_define_method(cFXRealSpinner.klass, "onKeyPress", VALUEFUNC(_wrap_FXRealSpinner_onKeyPress), -1);
    rb_define_method(cFXRealSpinner.klass, "onKeyRelease", VALUEFUNC(_wrap_FXRealSpinner_onKeyRelease), -1);
    rb_define_method(cFXRealSpinner.klass, "onCmdSetValue", VALUEFUNC(_wrap_FXRealSpinner_onCmdSetValue), -1);
    rb_define_method(cFXRealSpinner.klass, "onCmdSetIntValue", VALUEFUNC(_wrap_FXRealSpinner_onCmdSetIntValue), -1);
    rb_define_method(cFXRealSpinner.klass, "onCmdGetIntValue", VALUEFUNC(_wrap_FXRealSpinner_onCmdGetIntValue), -1);
    rb_define_method(cFXRealSpinner.klass, "onCmdSetIntRange", VALUEFUNC(_wrap_FXRealSpinner_onCmdSetIntRange), -1);
    rb_define_method(cFXRealSpinner.klass, "onCmdGetIntRange", VALUEFUNC(_wrap_FXRealSpinner_onCmdGetIntRange), -1);
    rb_define_method(cFXRealSpinner.klass, "onCmdSetRealValue", VALUEFUNC(_wrap_FXRealSpinner_onCmdSetRealValue), -1);
    rb_define_method(cFXRealSpinner.klass, "onCmdGetRealValue", VALUEFUNC(_wrap_FXRealSpinner_onCmdGetRealValue), -1);
    rb_define_method(cFXRealSpinner.klass, "onCmdSetRealRange", VALUEFUNC(_wrap_FXRealSpinner_onCmdSetRealRange), -1);
    rb_define_method(cFXRealSpinner.klass, "onCmdGetRealRange", VALUEFUNC(_wrap_FXRealSpinner_onCmdGetRealRange), -1);
    rb_define_method(cFXRealSpinner.klass, "onFocusSelf", VALUEFUNC(_wrap_FXRealSpinner_onFocusSelf), -1);
    rb_define_const(cFXRealSpinner.klass,"ID_INCREMENT", INT2NUM(FXRealSpinner::ID_INCREMENT));
    rb_define_const(cFXRealSpinner.klass,"ID_DECREMENT", INT2NUM(FXRealSpinner::ID_DECREMENT));
    rb_define_const(cFXRealSpinner.klass,"ID_ENTRY", INT2NUM(FXRealSpinner::ID_ENTRY));
    rb_define_const(cFXRealSpinner.klass,"ID_LAST", INT2NUM(FXRealSpinner::ID_LAST));
    rb_define_method(cFXRealSpinner.klass, "increment", VALUEFUNC(_wrap_FXRealSpinner_increment), -1);
    rb_define_method(cFXRealSpinner.klass, "decrement", VALUEFUNC(_wrap_FXRealSpinner_decrement), -1);
    rb_define_method(cFXRealSpinner.klass, "isCyclic", VALUEFUNC(_wrap_FXRealSpinner_isCyclic), -1);
    rb_define_method(cFXRealSpinner.klass, "setCyclic", VALUEFUNC(_wrap_FXRealSpinner_setCyclic), -1);
    rb_define_method(cFXRealSpinner.klass, "isTextVisible", VALUEFUNC(_wrap_FXRealSpinner_isTextVisible), -1);
    rb_define_method(cFXRealSpinner.klass, "setTextVisible", VALUEFUNC(_wrap_FXRealSpinner_setTextVisible), -1);
    rb_define_method(cFXRealSpinner.klass, "getValue", VALUEFUNC(_wrap_FXRealSpinner_getValue), -1);
    rb_define_method(cFXRealSpinner.klass, "setRange", VALUEFUNC(_wrap_FXRealSpinner_setRange), -1);
    rb_define_method(cFXRealSpinner.klass, "getRange", VALUEFUNC(_wrap_FXRealSpinner_getRange), -1);
    rb_define_method(cFXRealSpinner.klass, "setIncrement", VALUEFUNC(_wrap_FXRealSpinner_setIncrement), -1);
    rb_define_method(cFXRealSpinner.klass, "getIncrement", VALUEFUNC(_wrap_FXRealSpinner_getIncrement), -1);
    rb_define_method(cFXRealSpinner.klass, "setFont", VALUEFUNC(_wrap_FXRealSpinner_setFont), -1);
    rb_define_method(cFXRealSpinner.klass, "getFont", VALUEFUNC(_wrap_FXRealSpinner_getFont), -1);
    rb_define_method(cFXRealSpinner.klass, "setHelpText", VALUEFUNC(_wrap_FXRealSpinner_setHelpText), -1);
    rb_define_method(cFXRealSpinner.klass, "getHelpText", VALUEFUNC(_wrap_FXRealSpinner_getHelpText), -1);
    rb_define_method(cFXRealSpinner.klass, "setTipText", VALUEFUNC(_wrap_FXRealSpinner_setTipText), -1);
    rb_define_method(cFXRealSpinner.klass, "getTipText", VALUEFUNC(_wrap_FXRealSpinner_getTipText), -1);
    rb_define_method(cFXRealSpinner.klass, "setSpinnerStyle", VALUEFUNC(_wrap_FXRealSpinner_setSpinnerStyle), -1);
    rb_define_method(cFXRealSpinner.klass, "getSpinnerStyle", VALUEFUNC(_wrap_FXRealSpinner_getSpinnerStyle), -1);
    rb_define_method(cFXRealSpinner.klass, "setEditable", VALUEFUNC(_wrap_FXRealSpinner_setEditable), -1);
    rb_define_method(cFXRealSpinner.klass, "isEditable", VALUEFUNC(_wrap_FXRealSpinner_isEditable), -1);
    rb_define_method(cFXRealSpinner.klass, "setUpArrowColor", VALUEFUNC(_wrap_FXRealSpinner_setUpArrowColor), -1);
    rb_define_method(cFXRealSpinner.klass, "getUpArrowColor", VALUEFUNC(_wrap_FXRealSpinner_getUpArrowColor), -1);
    rb_define_method(cFXRealSpinner.klass, "setDownArrowColor", VALUEFUNC(_wrap_FXRealSpinner_setDownArrowColor), -1);
    rb_define_method(cFXRealSpinner.klass, "getDownArrowColor", VALUEFUNC(_wrap_FXRealSpinner_getDownArrowColor), -1);
    rb_define_method(cFXRealSpinner.klass, "setTextColor", VALUEFUNC(_wrap_FXRealSpinner_setTextColor), -1);
    rb_define_method(cFXRealSpinner.klass, "getTextColor", VALUEFUNC(_wrap_FXRealSpinner_getTextColor), -1);
    rb_define_method(cFXRealSpinner.klass, "setSelBackColor", VALUEFUNC(_wrap_FXRealSpinner_setSelBackColor), -1);
    rb_define_method(cFXRealSpinner.klass, "getSelBackColor", VALUEFUNC(_wrap_FXRealSpinner_getSelBackColor), -1);
    rb_define_method(cFXRealSpinner.klass, "setSelTextColor", VALUEFUNC(_wrap_FXRealSpinner_setSelTextColor), -1);
    rb_define_method(cFXRealSpinner.klass, "getSelTextColor", VALUEFUNC(_wrap_FXRealSpinner_getSelTextColor), -1);
    rb_define_method(cFXRealSpinner.klass, "setCursorColor", VALUEFUNC(_wrap_FXRealSpinner_setCursorColor), -1);
    rb_define_method(cFXRealSpinner.klass, "getCursorColor", VALUEFUNC(_wrap_FXRealSpinner_getCursorColor), -1);
    rb_define_method(cFXRealSpinner.klass, "setNumColumns", VALUEFUNC(_wrap_FXRealSpinner_setNumColumns), -1);
    rb_define_method(cFXRealSpinner.klass, "getNumColumns", VALUEFUNC(_wrap_FXRealSpinner_getNumColumns), -1);
    rb_define_method(cFXRealSpinner.klass, "save", VALUEFUNC(_wrap_FXRealSpinner_save), -1);
    rb_define_method(cFXRealSpinner.klass, "load", VALUEFUNC(_wrap_FXRealSpinner_load), -1);
    rb_define_method(cFXRealSpinner.klass, "create", VALUEFUNC(_wrap_FXRealSpinner_create), -1);
    rb_define_method(cFXRealSpinner.klass, "detach", VALUEFUNC(_wrap_FXRealSpinner_detach), -1);
    rb_define_method(cFXRealSpinner.klass, "destroy", VALUEFUNC(_wrap_FXRealSpinner_destroy), -1);
    rb_define_method(cFXRealSpinner.klass, "resize", VALUEFUNC(_wrap_FXRealSpinner_resize), -1);
    rb_define_method(cFXRealSpinner.klass, "getDefaultWidth", VALUEFUNC(_wrap_FXRealSpinner_getDefaultWidth), -1);
    rb_define_method(cFXRealSpinner.klass, "getDefaultHeight", VALUEFUNC(_wrap_FXRealSpinner_getDefaultHeight), -1);
    rb_define_method(cFXRealSpinner.klass, "getWidthForHeight", VALUEFUNC(_wrap_FXRealSpinner_getWidthForHeight), -1);
    rb_define_method(cFXRealSpinner.klass, "getHeightForWidth", VALUEFUNC(_wrap_FXRealSpinner_getHeightForWidth), -1);
    rb_define_method(cFXRealSpinner.klass, "canFocus", VALUEFUNC(_wrap_FXRealSpinner_canFocus), -1);
    rb_define_method(cFXRealSpinner.klass, "setFocus", VALUEFUNC(_wrap_FXRealSpinner_setFocus), -1);
    rb_define_method(cFXRealSpinner.klass, "killFocus", VALUEFUNC(_wrap_FXRealSpinner_killFocus), -1);
    rb_define_method(cFXRealSpinner.klass, "setDefault", VALUEFUNC(_wrap_FXRealSpinner_setDefault), -1);
    rb_define_method(cFXRealSpinner.klass, "enable", VALUEFUNC(_wrap_FXRealSpinner_enable), -1);
    rb_define_method(cFXRealSpinner.klass, "disable", VALUEFUNC(_wrap_FXRealSpinner_disable), -1);
    rb_define_method(cFXRealSpinner.klass, "raiseWindow", VALUEFUNC(_wrap_FXRealSpinner_raiseWindow), -1);
    rb_define_method(cFXRealSpinner.klass, "lower", VALUEFUNC(_wrap_FXRealSpinner_lower), -1);
    rb_define_method(cFXRealSpinner.klass, "move", VALUEFUNC(_wrap_FXRealSpinner_move), -1);
    rb_define_method(cFXRealSpinner.klass, "position", VALUEFUNC(_wrap_FXRealSpinner_position), -1);
    rb_define_method(cFXRealSpinner.klass, "layout", VALUEFUNC(_wrap_FXRealSpinner_layout), -1);
    rb_define_method(cFXRealSpinner.klass, "recalc", VALUEFUNC(_wrap_FXRealSpinner_recalc), -1);
    rb_define_method(cFXRealSpinner.klass, "reparent", VALUEFUNC(_wrap_FXRealSpinner_reparent), -1);
    rb_define_method(cFXRealSpinner.klass, "show", VALUEFUNC(_wrap_FXRealSpinner_show), -1);
    rb_define_method(cFXRealSpinner.klass, "hide", VALUEFUNC(_wrap_FXRealSpinner_hide), -1);
    rb_define_method(cFXRealSpinner.klass, "isComposite", VALUEFUNC(_wrap_FXRealSpinner_isComposite), -1);
    rb_define_method(cFXRealSpinner.klass, "contains", VALUEFUNC(_wrap_FXRealSpinner_contains), -1);
    rb_define_method(cFXRealSpinner.klass, "doesSaveUnder", VALUEFUNC(_wrap_FXRealSpinner_doesSaveUnder), -1);
    rb_define_method(cFXRealSpinner.klass, "setBackColor", VALUEFUNC(_wrap_FXRealSpinner_setBackColor), -1);
    rb_define_method(cFXRealSpinner.klass, "setValue", VALUEFUNC(_wrap_FXRealSpinner_setValue), -1);
    cFXRealSpinner.mark = 0;
    cFXRealSpinner.destroy = (void (*)(void *)) FXRbObject::freefunc;
    
    cFXCanvas.klass = rb_define_class_under(mFox, "FXCanvas", ((swig_class *) SWIGTYPE_p_FXWindow->clientdata)->klass);
    SWIG_TypeClientData(SWIGTYPE_p_FXCanvas, (void *) &cFXCanvas);
    rb_define_alloc_func(cFXCanvas.klass, _wrap_FXCanvas_allocate);
    rb_define_method(cFXCanvas.klass, "initialize", VALUEFUNC(_wrap_new_FXCanvas), -1);
    rb_define_method(cFXCanvas.klass, "onPaint", VALUEFUNC(_wrap_FXCanvas_onPaint), -1);
    rb_define_method(cFXCanvas.klass, "onMotion", VALUEFUNC(_wrap_FXCanvas_onMotion), -1);
    rb_define_method(cFXCanvas.klass, "onKeyPress", VALUEFUNC(_wrap_FXCanvas_onKeyPress), -1);
    rb_define_method(cFXCanvas.klass, "onKeyRelease", VALUEFUNC(_wrap_FXCanvas_onKeyRelease), -1);
    rb_define_method(cFXCanvas.klass, "save", VALUEFUNC(_wrap_FXCanvas_save), -1);
    rb_define_method(cFXCanvas.klass, "load", VALUEFUNC(_wrap_FXCanvas_load), -1);
    rb_define_method(cFXCanvas.klass, "create", VALUEFUNC(_wrap_FXCanvas_create), -1);
    rb_define_method(cFXCanvas.klass, "detach", VALUEFUNC(_wrap_FXCanvas_detach), -1);
    rb_define_method(cFXCanvas.klass, "destroy", VALUEFUNC(_wrap_FXCanvas_destroy), -1);
    rb_define_method(cFXCanvas.klass, "resize", VALUEFUNC(_wrap_FXCanvas_resize), -1);
    rb_define_method(cFXCanvas.klass, "getDefaultWidth", VALUEFUNC(_wrap_FXCanvas_getDefaultWidth), -1);
    rb_define_method(cFXCanvas.klass, "getDefaultHeight", VALUEFUNC(_wrap_FXCanvas_getDefaultHeight), -1);
    rb_define_method(cFXCanvas.klass, "getWidthForHeight", VALUEFUNC(_wrap_FXCanvas_getWidthForHeight), -1);
    rb_define_method(cFXCanvas.klass, "getHeightForWidth", VALUEFUNC(_wrap_FXCanvas_getHeightForWidth), -1);
    rb_define_method(cFXCanvas.klass, "canFocus", VALUEFUNC(_wrap_FXCanvas_canFocus), -1);
    rb_define_method(cFXCanvas.klass, "setFocus", VALUEFUNC(_wrap_FXCanvas_setFocus), -1);
    rb_define_method(cFXCanvas.klass, "killFocus", VALUEFUNC(_wrap_FXCanvas_killFocus), -1);
    rb_define_method(cFXCanvas.klass, "setDefault", VALUEFUNC(_wrap_FXCanvas_setDefault), -1);
    rb_define_method(cFXCanvas.klass, "enable", VALUEFUNC(_wrap_FXCanvas_enable), -1);
    rb_define_method(cFXCanvas.klass, "disable", VALUEFUNC(_wrap_FXCanvas_disable), -1);
    rb_define_method(cFXCanvas.klass, "raiseWindow", VALUEFUNC(_wrap_FXCanvas_raiseWindow), -1);
    rb_define_method(cFXCanvas.klass, "lower", VALUEFUNC(_wrap_FXCanvas_lower), -1);
    rb_define_method(cFXCanvas.klass, "move", VALUEFUNC(_wrap_FXCanvas_move), -1);
    rb_define_method(cFXCanvas.klass, "position", VALUEFUNC(_wrap_FXCanvas_position), -1);
    rb_define_method(cFXCanvas.klass, "layout", VALUEFUNC(_wrap_FXCanvas_layout), -1);
    rb_define_method(cFXCanvas.klass, "recalc", VALUEFUNC(_wrap_FXCanvas_recalc), -1);
    rb_define_method(cFXCanvas.klass, "reparent", VALUEFUNC(_wrap_FXCanvas_reparent), -1);
    rb_define_method(cFXCanvas.klass, "show", VALUEFUNC(_wrap_FXCanvas_show), -1);
    rb_define_method(cFXCanvas.klass, "hide", VALUEFUNC(_wrap_FXCanvas_hide), -1);
    rb_define_method(cFXCanvas.klass, "isComposite", VALUEFUNC(_wrap_FXCanvas_isComposite), -1);
    rb_define_method(cFXCanvas.klass, "contains", VALUEFUNC(_wrap_FXCanvas_contains), -1);
    rb_define_method(cFXCanvas.klass, "doesSaveUnder", VALUEFUNC(_wrap_FXCanvas_doesSaveUnder), -1);
    rb_define_method(cFXCanvas.klass, "setBackColor", VALUEFUNC(_wrap_FXCanvas_setBackColor), -1);
    cFXCanvas.mark = (void (*)(void *)) FXRbCanvas::markfunc;
    cFXCanvas.destroy = (void (*)(void *)) FXRbObject::freefunc;
    
    SWIGTYPE_p_FXCanvas->dcast = (swig_dycast_func) FXCanvas_dynamic_cast;
    
    rb_define_const(mFox,"TOOLTIP_PERMANENT", INT2NUM(TOOLTIP_PERMANENT));
    rb_define_const(mFox,"TOOLTIP_VARIABLE", INT2NUM(TOOLTIP_VARIABLE));
    rb_define_const(mFox,"TOOLTIP_NORMAL", INT2NUM(TOOLTIP_NORMAL));
    
    cFXToolTip.klass = rb_define_class_under(mFox, "FXToolTip", ((swig_class *) SWIGTYPE_p_FXShell->clientdata)->klass);
    SWIG_TypeClientData(SWIGTYPE_p_FXToolTip, (void *) &cFXToolTip);
    rb_define_alloc_func(cFXToolTip.klass, _wrap_FXToolTip_allocate);
    rb_define_method(cFXToolTip.klass, "initialize", VALUEFUNC(_wrap_new_FXToolTip), -1);
    rb_define_method(cFXToolTip.klass, "onPaint", VALUEFUNC(_wrap_FXToolTip_onPaint), -1);
    rb_define_method(cFXToolTip.klass, "onUpdate", VALUEFUNC(_wrap_FXToolTip_onUpdate), -1);
    rb_define_method(cFXToolTip.klass, "onTipShow", VALUEFUNC(_wrap_FXToolTip_onTipShow), -1);
    rb_define_method(cFXToolTip.klass, "onTipHide", VALUEFUNC(_wrap_FXToolTip_onTipHide), -1);
    rb_define_method(cFXToolTip.klass, "onCmdGetStringValue", VALUEFUNC(_wrap_FXToolTip_onCmdGetStringValue), -1);
    rb_define_method(cFXToolTip.klass, "onCmdSetStringValue", VALUEFUNC(_wrap_FXToolTip_onCmdSetStringValue), -1);
    rb_define_const(cFXToolTip.klass,"ID_TIP_SHOW", INT2NUM(FXToolTip::ID_TIP_SHOW));
    rb_define_const(cFXToolTip.klass,"ID_TIP_HIDE", INT2NUM(FXToolTip::ID_TIP_HIDE));
    rb_define_const(cFXToolTip.klass,"ID_LAST", INT2NUM(FXToolTip::ID_LAST));
    rb_define_method(cFXToolTip.klass, "setText", VALUEFUNC(_wrap_FXToolTip_setText), -1);
    rb_define_method(cFXToolTip.klass, "getText", VALUEFUNC(_wrap_FXToolTip_getText), -1);
    rb_define_method(cFXToolTip.klass, "setFont", VALUEFUNC(_wrap_FXToolTip_setFont), -1);
    rb_define_method(cFXToolTip.klass, "getFont", VALUEFUNC(_wrap_FXToolTip_getFont), -1);
    rb_define_method(cFXToolTip.klass, "getTextColor", VALUEFUNC(_wrap_FXToolTip_getTextColor), -1);
    rb_define_method(cFXToolTip.klass, "setTextColor", VALUEFUNC(_wrap_FXToolTip_setTextColor), -1);
    rb_define_method(cFXToolTip.klass, "save", VALUEFUNC(_wrap_FXToolTip_save), -1);
    rb_define_method(cFXToolTip.klass, "load", VALUEFUNC(_wrap_FXToolTip_load), -1);
    rb_define_method(cFXToolTip.klass, "create", VALUEFUNC(_wrap_FXToolTip_create), -1);
    rb_define_method(cFXToolTip.klass, "detach", VALUEFUNC(_wrap_FXToolTip_detach), -1);
    rb_define_method(cFXToolTip.klass, "destroy", VALUEFUNC(_wrap_FXToolTip_destroy), -1);
    rb_define_method(cFXToolTip.klass, "resize", VALUEFUNC(_wrap_FXToolTip_resize), -1);
    rb_define_method(cFXToolTip.klass, "getDefaultWidth", VALUEFUNC(_wrap_FXToolTip_getDefaultWidth), -1);
    rb_define_method(cFXToolTip.klass, "getDefaultHeight", VALUEFUNC(_wrap_FXToolTip_getDefaultHeight), -1);
    rb_define_method(cFXToolTip.klass, "getWidthForHeight", VALUEFUNC(_wrap_FXToolTip_getWidthForHeight), -1);
    rb_define_method(cFXToolTip.klass, "getHeightForWidth", VALUEFUNC(_wrap_FXToolTip_getHeightForWidth), -1);
    rb_define_method(cFXToolTip.klass, "canFocus", VALUEFUNC(_wrap_FXToolTip_canFocus), -1);
    rb_define_method(cFXToolTip.klass, "setFocus", VALUEFUNC(_wrap_FXToolTip_setFocus), -1);
    rb_define_method(cFXToolTip.klass, "killFocus", VALUEFUNC(_wrap_FXToolTip_killFocus), -1);
    rb_define_method(cFXToolTip.klass, "setDefault", VALUEFUNC(_wrap_FXToolTip_setDefault), -1);
    rb_define_method(cFXToolTip.klass, "enable", VALUEFUNC(_wrap_FXToolTip_enable), -1);
    rb_define_method(cFXToolTip.klass, "disable", VALUEFUNC(_wrap_FXToolTip_disable), -1);
    rb_define_method(cFXToolTip.klass, "raiseWindow", VALUEFUNC(_wrap_FXToolTip_raiseWindow), -1);
    rb_define_method(cFXToolTip.klass, "lower", VALUEFUNC(_wrap_FXToolTip_lower), -1);
    rb_define_method(cFXToolTip.klass, "move", VALUEFUNC(_wrap_FXToolTip_move), -1);
    rb_define_method(cFXToolTip.klass, "position", VALUEFUNC(_wrap_FXToolTip_position), -1);
    rb_define_method(cFXToolTip.klass, "layout", VALUEFUNC(_wrap_FXToolTip_layout), -1);
    rb_define_method(cFXToolTip.klass, "recalc", VALUEFUNC(_wrap_FXToolTip_recalc), -1);
    rb_define_method(cFXToolTip.klass, "reparent", VALUEFUNC(_wrap_FXToolTip_reparent), -1);
    rb_define_method(cFXToolTip.klass, "show", VALUEFUNC(_wrap_FXToolTip_show), -1);
    rb_define_method(cFXToolTip.klass, "hide", VALUEFUNC(_wrap_FXToolTip_hide), -1);
    rb_define_method(cFXToolTip.klass, "isComposite", VALUEFUNC(_wrap_FXToolTip_isComposite), -1);
    rb_define_method(cFXToolTip.klass, "contains", VALUEFUNC(_wrap_FXToolTip_contains), -1);
    rb_define_method(cFXToolTip.klass, "doesSaveUnder", VALUEFUNC(_wrap_FXToolTip_doesSaveUnder), -1);
    rb_define_method(cFXToolTip.klass, "setBackColor", VALUEFUNC(_wrap_FXToolTip_setBackColor), -1);
    cFXToolTip.mark = (void (*)(void *)) FXRbToolTip::markfunc;
    cFXToolTip.destroy = (void (*)(void *)) FXRbObject::freefunc;
    
    cFXToolBar.klass = rb_define_class_under(mFox, "FXToolBar", ((swig_class *) SWIGTYPE_p_FXPacker->clientdata)->klass);
    SWIG_TypeClientData(SWIGTYPE_p_FXToolBar, (void *) &cFXToolBar);
    rb_define_alloc_func(cFXToolBar.klass, _wrap_FXToolBar_allocate);
    rb_define_method(cFXToolBar.klass, "initialize", VALUEFUNC(_wrap_new_FXToolBar), -1);
    rb_define_method(cFXToolBar.klass, "onCmdUndock", VALUEFUNC(_wrap_FXToolBar_onCmdUndock), -1);
    rb_define_method(cFXToolBar.klass, "onUpdUndock", VALUEFUNC(_wrap_FXToolBar_onUpdUndock), -1);
    rb_define_method(cFXToolBar.klass, "onCmdDockTop", VALUEFUNC(_wrap_FXToolBar_onCmdDockTop), -1);
    rb_define_method(cFXToolBar.klass, "onUpdDockTop", VALUEFUNC(_wrap_FXToolBar_onUpdDockTop), -1);
    rb_define_method(cFXToolBar.klass, "onCmdDockBottom", VALUEFUNC(_wrap_FXToolBar_onCmdDockBottom), -1);
    rb_define_method(cFXToolBar.klass, "onUpdDockBottom", VALUEFUNC(_wrap_FXToolBar_onUpdDockBottom), -1);
    rb_define_method(cFXToolBar.klass, "onCmdDockLeft", VALUEFUNC(_wrap_FXToolBar_onCmdDockLeft), -1);
    rb_define_method(cFXToolBar.klass, "onUpdDockLeft", VALUEFUNC(_wrap_FXToolBar_onUpdDockLeft), -1);
    rb_define_method(cFXToolBar.klass, "onCmdDockRight", VALUEFUNC(_wrap_FXToolBar_onCmdDockRight), -1);
    rb_define_method(cFXToolBar.klass, "onUpdDockRight", VALUEFUNC(_wrap_FXToolBar_onUpdDockRight), -1);
    rb_define_method(cFXToolBar.klass, "onBeginDragGrip", VALUEFUNC(_wrap_FXToolBar_onBeginDragGrip), -1);
    rb_define_method(cFXToolBar.klass, "onEndDragGrip", VALUEFUNC(_wrap_FXToolBar_onEndDragGrip), -1);
    rb_define_method(cFXToolBar.klass, "onDraggedGrip", VALUEFUNC(_wrap_FXToolBar_onDraggedGrip), -1);
    rb_define_const(cFXToolBar.klass,"ID_UNDOCK", INT2NUM(FXToolBar::ID_UNDOCK));
    rb_define_const(cFXToolBar.klass,"ID_DOCK_TOP", INT2NUM(FXToolBar::ID_DOCK_TOP));
    rb_define_const(cFXToolBar.klass,"ID_DOCK_BOTTOM", INT2NUM(FXToolBar::ID_DOCK_BOTTOM));
    rb_define_const(cFXToolBar.klass,"ID_DOCK_LEFT", INT2NUM(FXToolBar::ID_DOCK_LEFT));
    rb_define_const(cFXToolBar.klass,"ID_DOCK_RIGHT", INT2NUM(FXToolBar::ID_DOCK_RIGHT));
    rb_define_const(cFXToolBar.klass,"ID_TOOLBARGRIP", INT2NUM(FXToolBar::ID_TOOLBARGRIP));
    rb_define_const(cFXToolBar.klass,"ID_LAST", INT2NUM(FXToolBar::ID_LAST));
    rb_define_method(cFXToolBar.klass, "setDryDock", VALUEFUNC(_wrap_FXToolBar_setDryDock), -1);
    rb_define_method(cFXToolBar.klass, "setWetDock", VALUEFUNC(_wrap_FXToolBar_setWetDock), -1);
    rb_define_method(cFXToolBar.klass, "getDryDock", VALUEFUNC(_wrap_FXToolBar_getDryDock), -1);
    rb_define_method(cFXToolBar.klass, "getWetDock", VALUEFUNC(_wrap_FXToolBar_getWetDock), -1);
    rb_define_method(cFXToolBar.klass, "isDocked", VALUEFUNC(_wrap_FXToolBar_isDocked), -1);
    rb_define_method(cFXToolBar.klass, "setDockingSide", VALUEFUNC(_wrap_FXToolBar_setDockingSide), -1);
    rb_define_method(cFXToolBar.klass, "getDockingSide", VALUEFUNC(_wrap_FXToolBar_getDockingSide), -1);
    rb_define_method(cFXToolBar.klass, "save", VALUEFUNC(_wrap_FXToolBar_save), -1);
    rb_define_method(cFXToolBar.klass, "load", VALUEFUNC(_wrap_FXToolBar_load), -1);
    rb_define_method(cFXToolBar.klass, "create", VALUEFUNC(_wrap_FXToolBar_create), -1);
    rb_define_method(cFXToolBar.klass, "detach", VALUEFUNC(_wrap_FXToolBar_detach), -1);
    rb_define_method(cFXToolBar.klass, "destroy", VALUEFUNC(_wrap_FXToolBar_destroy), -1);
    rb_define_method(cFXToolBar.klass, "resize", VALUEFUNC(_wrap_FXToolBar_resize), -1);
    rb_define_method(cFXToolBar.klass, "getDefaultWidth", VALUEFUNC(_wrap_FXToolBar_getDefaultWidth), -1);
    rb_define_method(cFXToolBar.klass, "getDefaultHeight", VALUEFUNC(_wrap_FXToolBar_getDefaultHeight), -1);
    rb_define_method(cFXToolBar.klass, "getWidthForHeight", VALUEFUNC(_wrap_FXToolBar_getWidthForHeight), -1);
    rb_define_method(cFXToolBar.klass, "getHeightForWidth", VALUEFUNC(_wrap_FXToolBar_getHeightForWidth), -1);
    rb_define_method(cFXToolBar.klass, "canFocus", VALUEFUNC(_wrap_FXToolBar_canFocus), -1);
    rb_define_method(cFXToolBar.klass, "setFocus", VALUEFUNC(_wrap_FXToolBar_setFocus), -1);
    rb_define_method(cFXToolBar.klass, "killFocus", VALUEFUNC(_wrap_FXToolBar_killFocus), -1);
    rb_define_method(cFXToolBar.klass, "setDefault", VALUEFUNC(_wrap_FXToolBar_setDefault), -1);
    rb_define_method(cFXToolBar.klass, "enable", VALUEFUNC(_wrap_FXToolBar_enable), -1);
    rb_define_method(cFXToolBar.klass, "disable", VALUEFUNC(_wrap_FXToolBar_disable), -1);
    rb_define_method(cFXToolBar.klass, "raiseWindow", VALUEFUNC(_wrap_FXToolBar_raiseWindow), -1);
    rb_define_method(cFXToolBar.klass, "lower", VALUEFUNC(_wrap_FXToolBar_lower), -1);
    rb_define_method(cFXToolBar.klass, "move", VALUEFUNC(_wrap_FXToolBar_move), -1);
    rb_define_method(cFXToolBar.klass, "position", VALUEFUNC(_wrap_FXToolBar_position), -1);
    rb_define_method(cFXToolBar.klass, "layout", VALUEFUNC(_wrap_FXToolBar_layout), -1);
    rb_define_method(cFXToolBar.klass, "recalc", VALUEFUNC(_wrap_FXToolBar_recalc), -1);
    rb_define_method(cFXToolBar.klass, "reparent", VALUEFUNC(_wrap_FXToolBar_reparent), -1);
    rb_define_method(cFXToolBar.klass, "show", VALUEFUNC(_wrap_FXToolBar_show), -1);
    rb_define_method(cFXToolBar.klass, "hide", VALUEFUNC(_wrap_FXToolBar_hide), -1);
    rb_define_method(cFXToolBar.klass, "isComposite", VALUEFUNC(_wrap_FXToolBar_isComposite), -1);
    rb_define_method(cFXToolBar.klass, "contains", VALUEFUNC(_wrap_FXToolBar_contains), -1);
    rb_define_method(cFXToolBar.klass, "doesSaveUnder", VALUEFUNC(_wrap_FXToolBar_doesSaveUnder), -1);
    rb_define_method(cFXToolBar.klass, "setBackColor", VALUEFUNC(_wrap_FXToolBar_setBackColor), -1);
    rb_define_method(cFXToolBar.klass, "dock", VALUEFUNC(_wrap_FXToolBar_dock), -1);
    rb_define_method(cFXToolBar.klass, "undock", VALUEFUNC(_wrap_FXToolBar_undock), -1);
    cFXToolBar.mark = (void (*)(void *)) FXRbToolBar::markfunc;
    cFXToolBar.destroy = (void (*)(void *)) FXRbObject::freefunc;
    rb_define_const(mFox,"TABBOOK_TOPTABS", INT2NUM(TABBOOK_TOPTABS));
    rb_define_const(mFox,"TABBOOK_BOTTOMTABS", INT2NUM(TABBOOK_BOTTOMTABS));
    rb_define_const(mFox,"TABBOOK_SIDEWAYS", INT2NUM(TABBOOK_SIDEWAYS));
    rb_define_const(mFox,"TABBOOK_LEFTTABS", INT2NUM(TABBOOK_LEFTTABS));
    rb_define_const(mFox,"TABBOOK_RIGHTTABS", INT2NUM(TABBOOK_RIGHTTABS));
    rb_define_const(mFox,"TABBOOK_NORMAL", INT2NUM(TABBOOK_NORMAL));
    
    cFXTabBar.klass = rb_define_class_under(mFox, "FXTabBar", ((swig_class *) SWIGTYPE_p_FXPacker->clientdata)->klass);
    SWIG_TypeClientData(SWIGTYPE_p_FXTabBar, (void *) &cFXTabBar);
    rb_define_alloc_func(cFXTabBar.klass, _wrap_FXTabBar_allocate);
    rb_define_method(cFXTabBar.klass, "initialize", VALUEFUNC(_wrap_new_FXTabBar), -1);
    rb_define_method(cFXTabBar.klass, "onPaint", VALUEFUNC(_wrap_FXTabBar_onPaint), -1);
    rb_define_method(cFXTabBar.klass, "onFocusNext", VALUEFUNC(_wrap_FXTabBar_onFocusNext), -1);
    rb_define_method(cFXTabBar.klass, "onFocusPrev", VALUEFUNC(_wrap_FXTabBar_onFocusPrev), -1);
    rb_define_method(cFXTabBar.klass, "onFocusUp", VALUEFUNC(_wrap_FXTabBar_onFocusUp), -1);
    rb_define_method(cFXTabBar.klass, "onFocusDown", VALUEFUNC(_wrap_FXTabBar_onFocusDown), -1);
    rb_define_method(cFXTabBar.klass, "onFocusLeft", VALUEFUNC(_wrap_FXTabBar_onFocusLeft), -1);
    rb_define_method(cFXTabBar.klass, "onFocusRight", VALUEFUNC(_wrap_FXTabBar_onFocusRight), -1);
    rb_define_method(cFXTabBar.klass, "onCmdOpenItem", VALUEFUNC(_wrap_FXTabBar_onCmdOpenItem), -1);
    rb_define_method(cFXTabBar.klass, "onCmdSetValue", VALUEFUNC(_wrap_FXTabBar_onCmdSetValue), -1);
    rb_define_method(cFXTabBar.klass, "onCmdSetIntValue", VALUEFUNC(_wrap_FXTabBar_onCmdSetIntValue), -1);
    rb_define_method(cFXTabBar.klass, "onCmdGetIntValue", VALUEFUNC(_wrap_FXTabBar_onCmdGetIntValue), -1);
    rb_define_method(cFXTabBar.klass, "onCmdOpen", VALUEFUNC(_wrap_FXTabBar_onCmdOpen), -1);
    rb_define_method(cFXTabBar.klass, "onUpdOpen", VALUEFUNC(_wrap_FXTabBar_onUpdOpen), -1);
    rb_define_const(cFXTabBar.klass,"ID_OPEN_ITEM", INT2NUM(FXTabBar::ID_OPEN_ITEM));
    rb_define_const(cFXTabBar.klass,"ID_OPEN_FIRST", INT2NUM(FXTabBar::ID_OPEN_FIRST));
    rb_define_const(cFXTabBar.klass,"ID_OPEN_SECOND", INT2NUM(FXTabBar::ID_OPEN_SECOND));
    rb_define_const(cFXTabBar.klass,"ID_OPEN_THIRD", INT2NUM(FXTabBar::ID_OPEN_THIRD));
    rb_define_const(cFXTabBar.klass,"ID_OPEN_FOURTH", INT2NUM(FXTabBar::ID_OPEN_FOURTH));
    rb_define_const(cFXTabBar.klass,"ID_OPEN_FIFTH", INT2NUM(FXTabBar::ID_OPEN_FIFTH));
    rb_define_const(cFXTabBar.klass,"ID_OPEN_SIXTH", INT2NUM(FXTabBar::ID_OPEN_SIXTH));
    rb_define_const(cFXTabBar.klass,"ID_OPEN_SEVENTH", INT2NUM(FXTabBar::ID_OPEN_SEVENTH));
    rb_define_const(cFXTabBar.klass,"ID_OPEN_EIGHTH", INT2NUM(FXTabBar::ID_OPEN_EIGHTH));
    rb_define_const(cFXTabBar.klass,"ID_OPEN_NINETH", INT2NUM(FXTabBar::ID_OPEN_NINETH));
    rb_define_const(cFXTabBar.klass,"ID_OPEN_TENTH", INT2NUM(FXTabBar::ID_OPEN_TENTH));
    rb_define_const(cFXTabBar.klass,"ID_OPEN_LAST", INT2NUM(FXTabBar::ID_OPEN_LAST));
    rb_define_const(cFXTabBar.klass,"ID_LAST", INT2NUM(FXTabBar::ID_LAST));
    rb_define_method(cFXTabBar.klass, "getCurrent", VALUEFUNC(_wrap_FXTabBar_getCurrent), -1);
    rb_define_method(cFXTabBar.klass, "getTabStyle", VALUEFUNC(_wrap_FXTabBar_getTabStyle), -1);
    rb_define_method(cFXTabBar.klass, "setTabStyle", VALUEFUNC(_wrap_FXTabBar_setTabStyle), -1);
    rb_define_method(cFXTabBar.klass, "save", VALUEFUNC(_wrap_FXTabBar_save), -1);
    rb_define_method(cFXTabBar.klass, "load", VALUEFUNC(_wrap_FXTabBar_load), -1);
    rb_define_method(cFXTabBar.klass, "create", VALUEFUNC(_wrap_FXTabBar_create), -1);
    rb_define_method(cFXTabBar.klass, "detach", VALUEFUNC(_wrap_FXTabBar_detach), -1);
    rb_define_method(cFXTabBar.klass, "destroy", VALUEFUNC(_wrap_FXTabBar_destroy), -1);
    rb_define_method(cFXTabBar.klass, "resize", VALUEFUNC(_wrap_FXTabBar_resize), -1);
    rb_define_method(cFXTabBar.klass, "getDefaultWidth", VALUEFUNC(_wrap_FXTabBar_getDefaultWidth), -1);
    rb_define_method(cFXTabBar.klass, "getDefaultHeight", VALUEFUNC(_wrap_FXTabBar_getDefaultHeight), -1);
    rb_define_method(cFXTabBar.klass, "getWidthForHeight", VALUEFUNC(_wrap_FXTabBar_getWidthForHeight), -1);
    rb_define_method(cFXTabBar.klass, "getHeightForWidth", VALUEFUNC(_wrap_FXTabBar_getHeightForWidth), -1);
    rb_define_method(cFXTabBar.klass, "canFocus", VALUEFUNC(_wrap_FXTabBar_canFocus), -1);
    rb_define_method(cFXTabBar.klass, "setFocus", VALUEFUNC(_wrap_FXTabBar_setFocus), -1);
    rb_define_method(cFXTabBar.klass, "killFocus", VALUEFUNC(_wrap_FXTabBar_killFocus), -1);
    rb_define_method(cFXTabBar.klass, "setDefault", VALUEFUNC(_wrap_FXTabBar_setDefault), -1);
    rb_define_method(cFXTabBar.klass, "enable", VALUEFUNC(_wrap_FXTabBar_enable), -1);
    rb_define_method(cFXTabBar.klass, "disable", VALUEFUNC(_wrap_FXTabBar_disable), -1);
    rb_define_method(cFXTabBar.klass, "raiseWindow", VALUEFUNC(_wrap_FXTabBar_raiseWindow), -1);
    rb_define_method(cFXTabBar.klass, "lower", VALUEFUNC(_wrap_FXTabBar_lower), -1);
    rb_define_method(cFXTabBar.klass, "move", VALUEFUNC(_wrap_FXTabBar_move), -1);
    rb_define_method(cFXTabBar.klass, "position", VALUEFUNC(_wrap_FXTabBar_position), -1);
    rb_define_method(cFXTabBar.klass, "layout", VALUEFUNC(_wrap_FXTabBar_layout), -1);
    rb_define_method(cFXTabBar.klass, "recalc", VALUEFUNC(_wrap_FXTabBar_recalc), -1);
    rb_define_method(cFXTabBar.klass, "reparent", VALUEFUNC(_wrap_FXTabBar_reparent), -1);
    rb_define_method(cFXTabBar.klass, "show", VALUEFUNC(_wrap_FXTabBar_show), -1);
    rb_define_method(cFXTabBar.klass, "hide", VALUEFUNC(_wrap_FXTabBar_hide), -1);
    rb_define_method(cFXTabBar.klass, "isComposite", VALUEFUNC(_wrap_FXTabBar_isComposite), -1);
    rb_define_method(cFXTabBar.klass, "contains", VALUEFUNC(_wrap_FXTabBar_contains), -1);
    rb_define_method(cFXTabBar.klass, "doesSaveUnder", VALUEFUNC(_wrap_FXTabBar_doesSaveUnder), -1);
    rb_define_method(cFXTabBar.klass, "setBackColor", VALUEFUNC(_wrap_FXTabBar_setBackColor), -1);
    rb_define_method(cFXTabBar.klass, "setCurrent", VALUEFUNC(_wrap_FXTabBar_setCurrent), -1);
    cFXTabBar.mark = (void (*)(void *)) FXRbTabBar::markfunc;
    cFXTabBar.destroy = (void (*)(void *)) FXRbObject::freefunc;
    
    SWIGTYPE_p_FXTabBar->dcast = (swig_dycast_func) FXTabBar_dynamic_cast;
    
    
    cFXTabBook.klass = rb_define_class_under(mFox, "FXTabBook", ((swig_class *) SWIGTYPE_p_FXTabBar->clientdata)->klass);
    SWIG_TypeClientData(SWIGTYPE_p_FXTabBook, (void *) &cFXTabBook);
    rb_define_alloc_func(cFXTabBook.klass, _wrap_FXTabBook_allocate);
    rb_define_method(cFXTabBook.klass, "initialize", VALUEFUNC(_wrap_new_FXTabBook), -1);
    rb_define_method(cFXTabBook.klass, "onPaint", VALUEFUNC(_wrap_FXTabBook_onPaint), -1);
    rb_define_method(cFXTabBook.klass, "onFocusNext", VALUEFUNC(_wrap_FXTabBook_onFocusNext), -1);
    rb_define_method(cFXTabBook.klass, "onFocusPrev", VALUEFUNC(_wrap_FXTabBook_onFocusPrev), -1);
    rb_define_method(cFXTabBook.klass, "onFocusUp", VALUEFUNC(_wrap_FXTabBook_onFocusUp), -1);
    rb_define_method(cFXTabBook.klass, "onFocusDown", VALUEFUNC(_wrap_FXTabBook_onFocusDown), -1);
    rb_define_method(cFXTabBook.klass, "onFocusLeft", VALUEFUNC(_wrap_FXTabBook_onFocusLeft), -1);
    rb_define_method(cFXTabBook.klass, "onFocusRight", VALUEFUNC(_wrap_FXTabBook_onFocusRight), -1);
    rb_define_method(cFXTabBook.klass, "onCmdOpenItem", VALUEFUNC(_wrap_FXTabBook_onCmdOpenItem), -1);
    rb_define_method(cFXTabBook.klass, "save", VALUEFUNC(_wrap_FXTabBook_save), -1);
    rb_define_method(cFXTabBook.klass, "load", VALUEFUNC(_wrap_FXTabBook_load), -1);
    rb_define_method(cFXTabBook.klass, "create", VALUEFUNC(_wrap_FXTabBook_create), -1);
    rb_define_method(cFXTabBook.klass, "detach", VALUEFUNC(_wrap_FXTabBook_detach), -1);
    rb_define_method(cFXTabBook.klass, "destroy", VALUEFUNC(_wrap_FXTabBook_destroy), -1);
    rb_define_method(cFXTabBook.klass, "resize", VALUEFUNC(_wrap_FXTabBook_resize), -1);
    rb_define_method(cFXTabBook.klass, "getDefaultWidth", VALUEFUNC(_wrap_FXTabBook_getDefaultWidth), -1);
    rb_define_method(cFXTabBook.klass, "getDefaultHeight", VALUEFUNC(_wrap_FXTabBook_getDefaultHeight), -1);
    rb_define_method(cFXTabBook.klass, "getWidthForHeight", VALUEFUNC(_wrap_FXTabBook_getWidthForHeight), -1);
    rb_define_method(cFXTabBook.klass, "getHeightForWidth", VALUEFUNC(_wrap_FXTabBook_getHeightForWidth), -1);
    rb_define_method(cFXTabBook.klass, "canFocus", VALUEFUNC(_wrap_FXTabBook_canFocus), -1);
    rb_define_method(cFXTabBook.klass, "setFocus", VALUEFUNC(_wrap_FXTabBook_setFocus), -1);
    rb_define_method(cFXTabBook.klass, "killFocus", VALUEFUNC(_wrap_FXTabBook_killFocus), -1);
    rb_define_method(cFXTabBook.klass, "setDefault", VALUEFUNC(_wrap_FXTabBook_setDefault), -1);
    rb_define_method(cFXTabBook.klass, "enable", VALUEFUNC(_wrap_FXTabBook_enable), -1);
    rb_define_method(cFXTabBook.klass, "disable", VALUEFUNC(_wrap_FXTabBook_disable), -1);
    rb_define_method(cFXTabBook.klass, "raiseWindow", VALUEFUNC(_wrap_FXTabBook_raiseWindow), -1);
    rb_define_method(cFXTabBook.klass, "lower", VALUEFUNC(_wrap_FXTabBook_lower), -1);
    rb_define_method(cFXTabBook.klass, "move", VALUEFUNC(_wrap_FXTabBook_move), -1);
    rb_define_method(cFXTabBook.klass, "position", VALUEFUNC(_wrap_FXTabBook_position), -1);
    rb_define_method(cFXTabBook.klass, "layout", VALUEFUNC(_wrap_FXTabBook_layout), -1);
    rb_define_method(cFXTabBook.klass, "recalc", VALUEFUNC(_wrap_FXTabBook_recalc), -1);
    rb_define_method(cFXTabBook.klass, "reparent", VALUEFUNC(_wrap_FXTabBook_reparent), -1);
    rb_define_method(cFXTabBook.klass, "show", VALUEFUNC(_wrap_FXTabBook_show), -1);
    rb_define_method(cFXTabBook.klass, "hide", VALUEFUNC(_wrap_FXTabBook_hide), -1);
    rb_define_method(cFXTabBook.klass, "isComposite", VALUEFUNC(_wrap_FXTabBook_isComposite), -1);
    rb_define_method(cFXTabBook.klass, "contains", VALUEFUNC(_wrap_FXTabBook_contains), -1);
    rb_define_method(cFXTabBook.klass, "doesSaveUnder", VALUEFUNC(_wrap_FXTabBook_doesSaveUnder), -1);
    rb_define_method(cFXTabBook.klass, "setBackColor", VALUEFUNC(_wrap_FXTabBook_setBackColor), -1);
    rb_define_method(cFXTabBook.klass, "setCurrent", VALUEFUNC(_wrap_FXTabBook_setCurrent), -1);
    cFXTabBook.mark = (void (*)(void *)) FXRbTabBook::markfunc;
    cFXTabBook.destroy = (void (*)(void *)) FXRbObject::freefunc;
    rb_define_const(mFox,"SCROLLBAR_VERTICAL", INT2NUM(SCROLLBAR_VERTICAL));
    rb_define_const(mFox,"SCROLLBAR_HORIZONTAL", INT2NUM(SCROLLBAR_HORIZONTAL));
    rb_define_const(mFox,"SCROLLBAR_WHEELJUMP", INT2NUM(SCROLLBAR_WHEELJUMP));
    
    cFXScrollBar.klass = rb_define_class_under(mFox, "FXScrollBar", ((swig_class *) SWIGTYPE_p_FXWindow->clientdata)->klass);
    SWIG_TypeClientData(SWIGTYPE_p_FXScrollBar, (void *) &cFXScrollBar);
    rb_define_alloc_func(cFXScrollBar.klass, _wrap_FXScrollBar_allocate);
    rb_define_method(cFXScrollBar.klass, "initialize", VALUEFUNC(_wrap_new_FXScrollBar), -1);
    rb_define_method(cFXScrollBar.klass, "onPaint", VALUEFUNC(_wrap_FXScrollBar_onPaint), -1);
    rb_define_method(cFXScrollBar.klass, "onMotion", VALUEFUNC(_wrap_FXScrollBar_onMotion), -1);
    rb_define_method(cFXScrollBar.klass, "onMouseWheel", VALUEFUNC(_wrap_FXScrollBar_onMouseWheel), -1);
    rb_define_method(cFXScrollBar.klass, "onLeftBtnPress", VALUEFUNC(_wrap_FXScrollBar_onLeftBtnPress), -1);
    rb_define_method(cFXScrollBar.klass, "onLeftBtnRelease", VALUEFUNC(_wrap_FXScrollBar_onLeftBtnRelease), -1);
    rb_define_method(cFXScrollBar.klass, "onMiddleBtnPress", VALUEFUNC(_wrap_FXScrollBar_onMiddleBtnPress), -1);
    rb_define_method(cFXScrollBar.klass, "onMiddleBtnRelease", VALUEFUNC(_wrap_FXScrollBar_onMiddleBtnRelease), -1);
    rb_define_method(cFXScrollBar.klass, "onRightBtnPress", VALUEFUNC(_wrap_FXScrollBar_onRightBtnPress), -1);
    rb_define_method(cFXScrollBar.klass, "onRightBtnRelease", VALUEFUNC(_wrap_FXScrollBar_onRightBtnRelease), -1);
    rb_define_method(cFXScrollBar.klass, "onUngrabbed", VALUEFUNC(_wrap_FXScrollBar_onUngrabbed), -1);
    rb_define_method(cFXScrollBar.klass, "onTimeWheel", VALUEFUNC(_wrap_FXScrollBar_onTimeWheel), -1);
    rb_define_method(cFXScrollBar.klass, "onAutoScroll", VALUEFUNC(_wrap_FXScrollBar_onAutoScroll), -1);
    rb_define_method(cFXScrollBar.klass, "onCmdSetValue", VALUEFUNC(_wrap_FXScrollBar_onCmdSetValue), -1);
    rb_define_method(cFXScrollBar.klass, "onCmdSetIntValue", VALUEFUNC(_wrap_FXScrollBar_onCmdSetIntValue), -1);
    rb_define_method(cFXScrollBar.klass, "onCmdGetIntValue", VALUEFUNC(_wrap_FXScrollBar_onCmdGetIntValue), -1);
    rb_define_method(cFXScrollBar.klass, "onCmdSetIntRange", VALUEFUNC(_wrap_FXScrollBar_onCmdSetIntRange), -1);
    rb_define_method(cFXScrollBar.klass, "onCmdGetIntRange", VALUEFUNC(_wrap_FXScrollBar_onCmdGetIntRange), -1);
    rb_define_const(cFXScrollBar.klass,"ID_TIMEWHEEL", INT2NUM(FXScrollBar::ID_TIMEWHEEL));
    rb_define_const(cFXScrollBar.klass,"ID_AUTOSCROLL", INT2NUM(FXScrollBar::ID_AUTOSCROLL));
    rb_define_const(cFXScrollBar.klass,"ID_LAST", INT2NUM(FXScrollBar::ID_LAST));
    rb_define_method(cFXScrollBar.klass, "setRange", VALUEFUNC(_wrap_FXScrollBar_setRange), -1);
    rb_define_method(cFXScrollBar.klass, "getRange", VALUEFUNC(_wrap_FXScrollBar_getRange), -1);
    rb_define_method(cFXScrollBar.klass, "setPage", VALUEFUNC(_wrap_FXScrollBar_setPage), -1);
    rb_define_method(cFXScrollBar.klass, "getPage", VALUEFUNC(_wrap_FXScrollBar_getPage), -1);
    rb_define_method(cFXScrollBar.klass, "setLine", VALUEFUNC(_wrap_FXScrollBar_setLine), -1);
    rb_define_method(cFXScrollBar.klass, "getLine", VALUEFUNC(_wrap_FXScrollBar_getLine), -1);
    rb_define_method(cFXScrollBar.klass, "setPosition", VALUEFUNC(_wrap_FXScrollBar_setPosition), -1);
    rb_define_method(cFXScrollBar.klass, "setHiliteColor", VALUEFUNC(_wrap_FXScrollBar_setHiliteColor), -1);
    rb_define_method(cFXScrollBar.klass, "getHiliteColor", VALUEFUNC(_wrap_FXScrollBar_getHiliteColor), -1);
    rb_define_method(cFXScrollBar.klass, "setShadowColor", VALUEFUNC(_wrap_FXScrollBar_setShadowColor), -1);
    rb_define_method(cFXScrollBar.klass, "getShadowColor", VALUEFUNC(_wrap_FXScrollBar_getShadowColor), -1);
    rb_define_method(cFXScrollBar.klass, "getBorderColor", VALUEFUNC(_wrap_FXScrollBar_getBorderColor), -1);
    rb_define_method(cFXScrollBar.klass, "setBorderColor", VALUEFUNC(_wrap_FXScrollBar_setBorderColor), -1);
    rb_define_method(cFXScrollBar.klass, "getScrollbarStyle", VALUEFUNC(_wrap_FXScrollBar_getScrollbarStyle), -1);
    rb_define_method(cFXScrollBar.klass, "setScrollbarStyle", VALUEFUNC(_wrap_FXScrollBar_setScrollbarStyle), -1);
    rb_define_method(cFXScrollBar.klass, "save", VALUEFUNC(_wrap_FXScrollBar_save), -1);
    rb_define_method(cFXScrollBar.klass, "load", VALUEFUNC(_wrap_FXScrollBar_load), -1);
    rb_define_method(cFXScrollBar.klass, "create", VALUEFUNC(_wrap_FXScrollBar_create), -1);
    rb_define_method(cFXScrollBar.klass, "detach", VALUEFUNC(_wrap_FXScrollBar_detach), -1);
    rb_define_method(cFXScrollBar.klass, "destroy", VALUEFUNC(_wrap_FXScrollBar_destroy), -1);
    rb_define_method(cFXScrollBar.klass, "resize", VALUEFUNC(_wrap_FXScrollBar_resize), -1);
    rb_define_method(cFXScrollBar.klass, "getDefaultWidth", VALUEFUNC(_wrap_FXScrollBar_getDefaultWidth), -1);
    rb_define_method(cFXScrollBar.klass, "getDefaultHeight", VALUEFUNC(_wrap_FXScrollBar_getDefaultHeight), -1);
    rb_define_method(cFXScrollBar.klass, "getWidthForHeight", VALUEFUNC(_wrap_FXScrollBar_getWidthForHeight), -1);
    rb_define_method(cFXScrollBar.klass, "getHeightForWidth", VALUEFUNC(_wrap_FXScrollBar_getHeightForWidth), -1);
    rb_define_method(cFXScrollBar.klass, "canFocus", VALUEFUNC(_wrap_FXScrollBar_canFocus), -1);
    rb_define_method(cFXScrollBar.klass, "setFocus", VALUEFUNC(_wrap_FXScrollBar_setFocus), -1);
    rb_define_method(cFXScrollBar.klass, "killFocus", VALUEFUNC(_wrap_FXScrollBar_killFocus), -1);
    rb_define_method(cFXScrollBar.klass, "setDefault", VALUEFUNC(_wrap_FXScrollBar_setDefault), -1);
    rb_define_method(cFXScrollBar.klass, "enable", VALUEFUNC(_wrap_FXScrollBar_enable), -1);
    rb_define_method(cFXScrollBar.klass, "disable", VALUEFUNC(_wrap_FXScrollBar_disable), -1);
    rb_define_method(cFXScrollBar.klass, "raiseWindow", VALUEFUNC(_wrap_FXScrollBar_raiseWindow), -1);
    rb_define_method(cFXScrollBar.klass, "lower", VALUEFUNC(_wrap_FXScrollBar_lower), -1);
    rb_define_method(cFXScrollBar.klass, "move", VALUEFUNC(_wrap_FXScrollBar_move), -1);
    rb_define_method(cFXScrollBar.klass, "position", VALUEFUNC(_wrap_FXScrollBar_position), -1);
    rb_define_method(cFXScrollBar.klass, "layout", VALUEFUNC(_wrap_FXScrollBar_layout), -1);
    rb_define_method(cFXScrollBar.klass, "recalc", VALUEFUNC(_wrap_FXScrollBar_recalc), -1);
    rb_define_method(cFXScrollBar.klass, "reparent", VALUEFUNC(_wrap_FXScrollBar_reparent), -1);
    rb_define_method(cFXScrollBar.klass, "show", VALUEFUNC(_wrap_FXScrollBar_show), -1);
    rb_define_method(cFXScrollBar.klass, "hide", VALUEFUNC(_wrap_FXScrollBar_hide), -1);
    rb_define_method(cFXScrollBar.klass, "isComposite", VALUEFUNC(_wrap_FXScrollBar_isComposite), -1);
    rb_define_method(cFXScrollBar.klass, "contains", VALUEFUNC(_wrap_FXScrollBar_contains), -1);
    rb_define_method(cFXScrollBar.klass, "doesSaveUnder", VALUEFUNC(_wrap_FXScrollBar_doesSaveUnder), -1);
    rb_define_method(cFXScrollBar.klass, "setBackColor", VALUEFUNC(_wrap_FXScrollBar_setBackColor), -1);
    cFXScrollBar.mark = (void (*)(void *)) FXRbScrollBar::markfunc;
    cFXScrollBar.destroy = (void (*)(void *)) FXRbObject::freefunc;
    
    cFXScrollCorner.klass = rb_define_class_under(mFox, "FXScrollCorner", ((swig_class *) SWIGTYPE_p_FXWindow->clientdata)->klass);
    SWIG_TypeClientData(SWIGTYPE_p_FXScrollCorner, (void *) &cFXScrollCorner);
    rb_define_alloc_func(cFXScrollCorner.klass, _wrap_FXScrollCorner_allocate);
    rb_define_method(cFXScrollCorner.klass, "initialize", VALUEFUNC(_wrap_new_FXScrollCorner), -1);
    rb_define_method(cFXScrollCorner.klass, "onPaint", VALUEFUNC(_wrap_FXScrollCorner_onPaint), -1);
    rb_define_method(cFXScrollCorner.klass, "save", VALUEFUNC(_wrap_FXScrollCorner_save), -1);
    rb_define_method(cFXScrollCorner.klass, "load", VALUEFUNC(_wrap_FXScrollCorner_load), -1);
    rb_define_method(cFXScrollCorner.klass, "create", VALUEFUNC(_wrap_FXScrollCorner_create), -1);
    rb_define_method(cFXScrollCorner.klass, "detach", VALUEFUNC(_wrap_FXScrollCorner_detach), -1);
    rb_define_method(cFXScrollCorner.klass, "destroy", VALUEFUNC(_wrap_FXScrollCorner_destroy), -1);
    rb_define_method(cFXScrollCorner.klass, "resize", VALUEFUNC(_wrap_FXScrollCorner_resize), -1);
    rb_define_method(cFXScrollCorner.klass, "getDefaultWidth", VALUEFUNC(_wrap_FXScrollCorner_getDefaultWidth), -1);
    rb_define_method(cFXScrollCorner.klass, "getDefaultHeight", VALUEFUNC(_wrap_FXScrollCorner_getDefaultHeight), -1);
    rb_define_method(cFXScrollCorner.klass, "getWidthForHeight", VALUEFUNC(_wrap_FXScrollCorner_getWidthForHeight), -1);
    rb_define_method(cFXScrollCorner.klass, "getHeightForWidth", VALUEFUNC(_wrap_FXScrollCorner_getHeightForWidth), -1);
    rb_define_method(cFXScrollCorner.klass, "canFocus", VALUEFUNC(_wrap_FXScrollCorner_canFocus), -1);
    rb_define_method(cFXScrollCorner.klass, "setFocus", VALUEFUNC(_wrap_FXScrollCorner_setFocus), -1);
    rb_define_method(cFXScrollCorner.klass, "killFocus", VALUEFUNC(_wrap_FXScrollCorner_killFocus), -1);
    rb_define_method(cFXScrollCorner.klass, "setDefault", VALUEFUNC(_wrap_FXScrollCorner_setDefault), -1);
    rb_define_method(cFXScrollCorner.klass, "enable", VALUEFUNC(_wrap_FXScrollCorner_enable), -1);
    rb_define_method(cFXScrollCorner.klass, "disable", VALUEFUNC(_wrap_FXScrollCorner_disable), -1);
    rb_define_method(cFXScrollCorner.klass, "raiseWindow", VALUEFUNC(_wrap_FXScrollCorner_raiseWindow), -1);
    rb_define_method(cFXScrollCorner.klass, "lower", VALUEFUNC(_wrap_FXScrollCorner_lower), -1);
    rb_define_method(cFXScrollCorner.klass, "move", VALUEFUNC(_wrap_FXScrollCorner_move), -1);
    rb_define_method(cFXScrollCorner.klass, "position", VALUEFUNC(_wrap_FXScrollCorner_position), -1);
    rb_define_method(cFXScrollCorner.klass, "layout", VALUEFUNC(_wrap_FXScrollCorner_layout), -1);
    rb_define_method(cFXScrollCorner.klass, "recalc", VALUEFUNC(_wrap_FXScrollCorner_recalc), -1);
    rb_define_method(cFXScrollCorner.klass, "reparent", VALUEFUNC(_wrap_FXScrollCorner_reparent), -1);
    rb_define_method(cFXScrollCorner.klass, "show", VALUEFUNC(_wrap_FXScrollCorner_show), -1);
    rb_define_method(cFXScrollCorner.klass, "hide", VALUEFUNC(_wrap_FXScrollCorner_hide), -1);
    rb_define_method(cFXScrollCorner.klass, "isComposite", VALUEFUNC(_wrap_FXScrollCorner_isComposite), -1);
    rb_define_method(cFXScrollCorner.klass, "contains", VALUEFUNC(_wrap_FXScrollCorner_contains), -1);
    rb_define_method(cFXScrollCorner.klass, "doesSaveUnder", VALUEFUNC(_wrap_FXScrollCorner_doesSaveUnder), -1);
    rb_define_method(cFXScrollCorner.klass, "setBackColor", VALUEFUNC(_wrap_FXScrollCorner_setBackColor), -1);
    cFXScrollCorner.mark = (void (*)(void *)) FXRbScrollCorner::markfunc;
    cFXScrollCorner.destroy = (void (*)(void *)) FXRbObject::freefunc;
    rb_define_const(mFox,"COMBOBOX_NO_REPLACE", INT2NUM(COMBOBOX_NO_REPLACE));
    rb_define_const(mFox,"COMBOBOX_REPLACE", INT2NUM(COMBOBOX_REPLACE));
    rb_define_const(mFox,"COMBOBOX_INSERT_BEFORE", INT2NUM(COMBOBOX_INSERT_BEFORE));
    rb_define_const(mFox,"COMBOBOX_INSERT_AFTER", INT2NUM(COMBOBOX_INSERT_AFTER));
    rb_define_const(mFox,"COMBOBOX_INSERT_FIRST", INT2NUM(COMBOBOX_INSERT_FIRST));
    rb_define_const(mFox,"COMBOBOX_INSERT_LAST", INT2NUM(COMBOBOX_INSERT_LAST));
    rb_define_const(mFox,"COMBOBOX_STATIC", INT2NUM(COMBOBOX_STATIC));
    rb_define_const(mFox,"COMBOBOX_NORMAL", INT2NUM(COMBOBOX_NORMAL));
    
    cFXComboBox.klass = rb_define_class_under(mFox, "FXComboBox", ((swig_class *) SWIGTYPE_p_FXPacker->clientdata)->klass);
    SWIG_TypeClientData(SWIGTYPE_p_FXComboBox, (void *) &cFXComboBox);
    rb_define_alloc_func(cFXComboBox.klass, _wrap_FXComboBox_allocate);
    rb_define_method(cFXComboBox.klass, "initialize", VALUEFUNC(_wrap_new_FXComboBox), -1);
    rb_define_method(cFXComboBox.klass, "onFocusUp", VALUEFUNC(_wrap_FXComboBox_onFocusUp), -1);
    rb_define_method(cFXComboBox.klass, "onFocusDown", VALUEFUNC(_wrap_FXComboBox_onFocusDown), -1);
    rb_define_method(cFXComboBox.klass, "onFocusSelf", VALUEFUNC(_wrap_FXComboBox_onFocusSelf), -1);
    rb_define_method(cFXComboBox.klass, "onTextButton", VALUEFUNC(_wrap_FXComboBox_onTextButton), -1);
    rb_define_method(cFXComboBox.klass, "onTextChanged", VALUEFUNC(_wrap_FXComboBox_onTextChanged), -1);
    rb_define_method(cFXComboBox.klass, "onTextCommand", VALUEFUNC(_wrap_FXComboBox_onTextCommand), -1);
    rb_define_method(cFXComboBox.klass, "onListClicked", VALUEFUNC(_wrap_FXComboBox_onListClicked), -1);
    rb_define_method(cFXComboBox.klass, "onFwdToText", VALUEFUNC(_wrap_FXComboBox_onFwdToText), -1);
    rb_define_method(cFXComboBox.klass, "onUpdFmText", VALUEFUNC(_wrap_FXComboBox_onUpdFmText), -1);
    rb_define_const(cFXComboBox.klass,"ID_LIST", INT2NUM(FXComboBox::ID_LIST));
    rb_define_const(cFXComboBox.klass,"ID_TEXT", INT2NUM(FXComboBox::ID_TEXT));
    rb_define_const(cFXComboBox.klass,"ID_LAST", INT2NUM(FXComboBox::ID_LAST));
    rb_define_method(cFXComboBox.klass, "isEditable", VALUEFUNC(_wrap_FXComboBox_isEditable), -1);
    rb_define_method(cFXComboBox.klass, "setEditable", VALUEFUNC(_wrap_FXComboBox_setEditable), -1);
    rb_define_method(cFXComboBox.klass, "setText", VALUEFUNC(_wrap_FXComboBox_setText), -1);
    rb_define_method(cFXComboBox.klass, "getText", VALUEFUNC(_wrap_FXComboBox_getText), -1);
    rb_define_method(cFXComboBox.klass, "setNumColumns", VALUEFUNC(_wrap_FXComboBox_setNumColumns), -1);
    rb_define_method(cFXComboBox.klass, "getNumColumns", VALUEFUNC(_wrap_FXComboBox_getNumColumns), -1);
    rb_define_method(cFXComboBox.klass, "getNumItems", VALUEFUNC(_wrap_FXComboBox_getNumItems), -1);
    rb_define_method(cFXComboBox.klass, "getNumVisible", VALUEFUNC(_wrap_FXComboBox_getNumVisible), -1);
    rb_define_method(cFXComboBox.klass, "setNumVisible", VALUEFUNC(_wrap_FXComboBox_setNumVisible), -1);
    rb_define_method(cFXComboBox.klass, "isItemCurrent", VALUEFUNC(_wrap_FXComboBox_isItemCurrent), -1);
    rb_define_method(cFXComboBox.klass, "setCurrentItem", VALUEFUNC(_wrap_FXComboBox_setCurrentItem), -1);
    rb_define_method(cFXComboBox.klass, "getCurrentItem", VALUEFUNC(_wrap_FXComboBox_getCurrentItem), -1);
    rb_define_method(cFXComboBox.klass, "getItem", VALUEFUNC(_wrap_FXComboBox_getItem), -1);
    rb_define_method(cFXComboBox.klass, "setItem", VALUEFUNC(_wrap_FXComboBox_setItem), -1);
    rb_define_method(cFXComboBox.klass, "insertItem", VALUEFUNC(_wrap_FXComboBox_insertItem), -1);
    rb_define_method(cFXComboBox.klass, "appendItem", VALUEFUNC(_wrap_FXComboBox_appendItem), -1);
    rb_define_method(cFXComboBox.klass, "prependItem", VALUEFUNC(_wrap_FXComboBox_prependItem), -1);
    rb_define_method(cFXComboBox.klass, "moveItem", VALUEFUNC(_wrap_FXComboBox_moveItem), -1);
    rb_define_method(cFXComboBox.klass, "removeItem", VALUEFUNC(_wrap_FXComboBox_removeItem), -1);
    rb_define_method(cFXComboBox.klass, "clearItems", VALUEFUNC(_wrap_FXComboBox_clearItems), -1);
    rb_define_method(cFXComboBox.klass, "findItem", VALUEFUNC(_wrap_FXComboBox_findItem), -1);
    rb_define_method(cFXComboBox.klass, "setItemText", VALUEFUNC(_wrap_FXComboBox_setItemText), -1);
    rb_define_method(cFXComboBox.klass, "getItemText", VALUEFUNC(_wrap_FXComboBox_getItemText), -1);
    rb_define_method(cFXComboBox.klass, "setItemData", VALUEFUNC(_wrap_FXComboBox_setItemData), -1);
    rb_define_method(cFXComboBox.klass, "getItemData", VALUEFUNC(_wrap_FXComboBox_getItemData), -1);
    rb_define_method(cFXComboBox.klass, "isPaneShown", VALUEFUNC(_wrap_FXComboBox_isPaneShown), -1);
    rb_define_method(cFXComboBox.klass, "sortItems", VALUEFUNC(_wrap_FXComboBox_sortItems), -1);
    rb_define_method(cFXComboBox.klass, "setFont", VALUEFUNC(_wrap_FXComboBox_setFont), -1);
    rb_define_method(cFXComboBox.klass, "getFont", VALUEFUNC(_wrap_FXComboBox_getFont), -1);
    rb_define_method(cFXComboBox.klass, "setComboStyle", VALUEFUNC(_wrap_FXComboBox_setComboStyle), -1);
    rb_define_method(cFXComboBox.klass, "getComboStyle", VALUEFUNC(_wrap_FXComboBox_getComboStyle), -1);
    rb_define_method(cFXComboBox.klass, "getBackColor", VALUEFUNC(_wrap_FXComboBox_getBackColor), -1);
    rb_define_method(cFXComboBox.klass, "setTextColor", VALUEFUNC(_wrap_FXComboBox_setTextColor), -1);
    rb_define_method(cFXComboBox.klass, "getTextColor", VALUEFUNC(_wrap_FXComboBox_getTextColor), -1);
    rb_define_method(cFXComboBox.klass, "setSelBackColor", VALUEFUNC(_wrap_FXComboBox_setSelBackColor), -1);
    rb_define_method(cFXComboBox.klass, "getSelBackColor", VALUEFUNC(_wrap_FXComboBox_getSelBackColor), -1);
    rb_define_method(cFXComboBox.klass, "setSelTextColor", VALUEFUNC(_wrap_FXComboBox_setSelTextColor), -1);
    rb_define_method(cFXComboBox.klass, "getSelTextColor", VALUEFUNC(_wrap_FXComboBox_getSelTextColor), -1);
    rb_define_method(cFXComboBox.klass, "setHelpText", VALUEFUNC(_wrap_FXComboBox_setHelpText), -1);
    rb_define_method(cFXComboBox.klass, "getHelpText", VALUEFUNC(_wrap_FXComboBox_getHelpText), -1);
    rb_define_method(cFXComboBox.klass, "setTipText", VALUEFUNC(_wrap_FXComboBox_setTipText), -1);
    rb_define_method(cFXComboBox.klass, "getTipText", VALUEFUNC(_wrap_FXComboBox_getTipText), -1);
    rb_define_method(cFXComboBox.klass, "save", VALUEFUNC(_wrap_FXComboBox_save), -1);
    rb_define_method(cFXComboBox.klass, "load", VALUEFUNC(_wrap_FXComboBox_load), -1);
    rb_define_method(cFXComboBox.klass, "create", VALUEFUNC(_wrap_FXComboBox_create), -1);
    rb_define_method(cFXComboBox.klass, "detach", VALUEFUNC(_wrap_FXComboBox_detach), -1);
    rb_define_method(cFXComboBox.klass, "destroy", VALUEFUNC(_wrap_FXComboBox_destroy), -1);
    rb_define_method(cFXComboBox.klass, "resize", VALUEFUNC(_wrap_FXComboBox_resize), -1);
    rb_define_method(cFXComboBox.klass, "getDefaultWidth", VALUEFUNC(_wrap_FXComboBox_getDefaultWidth), -1);
    rb_define_method(cFXComboBox.klass, "getDefaultHeight", VALUEFUNC(_wrap_FXComboBox_getDefaultHeight), -1);
    rb_define_method(cFXComboBox.klass, "getWidthForHeight", VALUEFUNC(_wrap_FXComboBox_getWidthForHeight), -1);
    rb_define_method(cFXComboBox.klass, "getHeightForWidth", VALUEFUNC(_wrap_FXComboBox_getHeightForWidth), -1);
    rb_define_method(cFXComboBox.klass, "canFocus", VALUEFUNC(_wrap_FXComboBox_canFocus), -1);
    rb_define_method(cFXComboBox.klass, "setFocus", VALUEFUNC(_wrap_FXComboBox_setFocus), -1);
    rb_define_method(cFXComboBox.klass, "killFocus", VALUEFUNC(_wrap_FXComboBox_killFocus), -1);
    rb_define_method(cFXComboBox.klass, "setDefault", VALUEFUNC(_wrap_FXComboBox_setDefault), -1);
    rb_define_method(cFXComboBox.klass, "enable", VALUEFUNC(_wrap_FXComboBox_enable), -1);
    rb_define_method(cFXComboBox.klass, "disable", VALUEFUNC(_wrap_FXComboBox_disable), -1);
    rb_define_method(cFXComboBox.klass, "raiseWindow", VALUEFUNC(_wrap_FXComboBox_raiseWindow), -1);
    rb_define_method(cFXComboBox.klass, "lower", VALUEFUNC(_wrap_FXComboBox_lower), -1);
    rb_define_method(cFXComboBox.klass, "move", VALUEFUNC(_wrap_FXComboBox_move), -1);
    rb_define_method(cFXComboBox.klass, "position", VALUEFUNC(_wrap_FXComboBox_position), -1);
    rb_define_method(cFXComboBox.klass, "layout", VALUEFUNC(_wrap_FXComboBox_layout), -1);
    rb_define_method(cFXComboBox.klass, "recalc", VALUEFUNC(_wrap_FXComboBox_recalc), -1);
    rb_define_method(cFXComboBox.klass, "reparent", VALUEFUNC(_wrap_FXComboBox_reparent), -1);
    rb_define_method(cFXComboBox.klass, "show", VALUEFUNC(_wrap_FXComboBox_show), -1);
    rb_define_method(cFXComboBox.klass, "hide", VALUEFUNC(_wrap_FXComboBox_hide), -1);
    rb_define_method(cFXComboBox.klass, "isComposite", VALUEFUNC(_wrap_FXComboBox_isComposite), -1);
    rb_define_method(cFXComboBox.klass, "contains", VALUEFUNC(_wrap_FXComboBox_contains), -1);
    rb_define_method(cFXComboBox.klass, "doesSaveUnder", VALUEFUNC(_wrap_FXComboBox_doesSaveUnder), -1);
    rb_define_method(cFXComboBox.klass, "setBackColor", VALUEFUNC(_wrap_FXComboBox_setBackColor), -1);
    cFXComboBox.mark = (void (*)(void *)) FXRbComboBox::markfunc;
    cFXComboBox.destroy = (void (*)(void *)) FXRbObject::freefunc;
    rb_define_const(mFox,"LISTBOX_NORMAL", INT2NUM(LISTBOX_NORMAL));
    
    cFXListBox.klass = rb_define_class_under(mFox, "FXListBox", ((swig_class *) SWIGTYPE_p_FXPacker->clientdata)->klass);
    SWIG_TypeClientData(SWIGTYPE_p_FXListBox, (void *) &cFXListBox);
    rb_define_alloc_func(cFXListBox.klass, _wrap_FXListBox_allocate);
    rb_define_method(cFXListBox.klass, "initialize", VALUEFUNC(_wrap_new_FXListBox), -1);
    rb_define_method(cFXListBox.klass, "onFocusUp", VALUEFUNC(_wrap_FXListBox_onFocusUp), -1);
    rb_define_method(cFXListBox.klass, "onFocusDown", VALUEFUNC(_wrap_FXListBox_onFocusDown), -1);
    rb_define_method(cFXListBox.klass, "onFocusSelf", VALUEFUNC(_wrap_FXListBox_onFocusSelf), -1);
    rb_define_method(cFXListBox.klass, "onFieldButton", VALUEFUNC(_wrap_FXListBox_onFieldButton), -1);
    rb_define_method(cFXListBox.klass, "onListUpdate", VALUEFUNC(_wrap_FXListBox_onListUpdate), -1);
    rb_define_method(cFXListBox.klass, "onListChanged", VALUEFUNC(_wrap_FXListBox_onListChanged), -1);
    rb_define_method(cFXListBox.klass, "onListClicked", VALUEFUNC(_wrap_FXListBox_onListClicked), -1);
    rb_define_method(cFXListBox.klass, "onCmdSetValue", VALUEFUNC(_wrap_FXListBox_onCmdSetValue), -1);
    rb_define_method(cFXListBox.klass, "onCmdGetIntValue", VALUEFUNC(_wrap_FXListBox_onCmdGetIntValue), -1);
    rb_define_method(cFXListBox.klass, "onCmdSetIntValue", VALUEFUNC(_wrap_FXListBox_onCmdSetIntValue), -1);
    rb_define_const(cFXListBox.klass,"ID_LIST", INT2NUM(FXListBox::ID_LIST));
    rb_define_const(cFXListBox.klass,"ID_FIELD", INT2NUM(FXListBox::ID_FIELD));
    rb_define_const(cFXListBox.klass,"ID_LAST", INT2NUM(FXListBox::ID_LAST));
    rb_define_method(cFXListBox.klass, "getNumItems", VALUEFUNC(_wrap_FXListBox_getNumItems), -1);
    rb_define_method(cFXListBox.klass, "getNumVisible", VALUEFUNC(_wrap_FXListBox_getNumVisible), -1);
    rb_define_method(cFXListBox.klass, "setNumVisible", VALUEFUNC(_wrap_FXListBox_setNumVisible), -1);
    rb_define_method(cFXListBox.klass, "isItemCurrent", VALUEFUNC(_wrap_FXListBox_isItemCurrent), -1);
    rb_define_method(cFXListBox.klass, "setCurrentItem", VALUEFUNC(_wrap_FXListBox_setCurrentItem), -1);
    rb_define_method(cFXListBox.klass, "getCurrentItem", VALUEFUNC(_wrap_FXListBox_getCurrentItem), -1);
    rb_define_method(cFXListBox.klass, "getItem", VALUEFUNC(_wrap_FXListBox_getItem), -1);
    rb_define_method(cFXListBox.klass, "setItem", VALUEFUNC(_wrap_FXListBox_setItem), -1);
    rb_define_method(cFXListBox.klass, "insertItem", VALUEFUNC(_wrap_FXListBox_insertItem), -1);
    rb_define_method(cFXListBox.klass, "appendItem", VALUEFUNC(_wrap_FXListBox_appendItem), -1);
    rb_define_alias(cFXListBox.klass, "<<", "appendItem");
    rb_define_method(cFXListBox.klass, "prependItem", VALUEFUNC(_wrap_FXListBox_prependItem), -1);
    rb_define_method(cFXListBox.klass, "moveItem", VALUEFUNC(_wrap_FXListBox_moveItem), -1);
    rb_define_method(cFXListBox.klass, "removeItem", VALUEFUNC(_wrap_FXListBox_removeItem), -1);
    rb_define_method(cFXListBox.klass, "clearItems", VALUEFUNC(_wrap_FXListBox_clearItems), -1);
    rb_define_method(cFXListBox.klass, "findItem", VALUEFUNC(_wrap_FXListBox_findItem), -1);
    rb_define_method(cFXListBox.klass, "setItemText", VALUEFUNC(_wrap_FXListBox_setItemText), -1);
    rb_define_method(cFXListBox.klass, "getItemText", VALUEFUNC(_wrap_FXListBox_getItemText), -1);
    rb_define_method(cFXListBox.klass, "setItemIcon", VALUEFUNC(_wrap_FXListBox_setItemIcon), -1);
    rb_define_method(cFXListBox.klass, "getItemIcon", VALUEFUNC(_wrap_FXListBox_getItemIcon), -1);
    rb_define_method(cFXListBox.klass, "setItemData", VALUEFUNC(_wrap_FXListBox_setItemData), -1);
    rb_define_method(cFXListBox.klass, "getItemData", VALUEFUNC(_wrap_FXListBox_getItemData), -1);
    rb_define_method(cFXListBox.klass, "isPaneShown", VALUEFUNC(_wrap_FXListBox_isPaneShown), -1);
    rb_define_method(cFXListBox.klass, "sortItems", VALUEFUNC(_wrap_FXListBox_sortItems), -1);
    rb_define_method(cFXListBox.klass, "setFont", VALUEFUNC(_wrap_FXListBox_setFont), -1);
    rb_define_method(cFXListBox.klass, "getFont", VALUEFUNC(_wrap_FXListBox_getFont), -1);
    rb_define_method(cFXListBox.klass, "getBackColor", VALUEFUNC(_wrap_FXListBox_getBackColor), -1);
    rb_define_method(cFXListBox.klass, "setTextColor", VALUEFUNC(_wrap_FXListBox_setTextColor), -1);
    rb_define_method(cFXListBox.klass, "getTextColor", VALUEFUNC(_wrap_FXListBox_getTextColor), -1);
    rb_define_method(cFXListBox.klass, "setSelBackColor", VALUEFUNC(_wrap_FXListBox_setSelBackColor), -1);
    rb_define_method(cFXListBox.klass, "getSelBackColor", VALUEFUNC(_wrap_FXListBox_getSelBackColor), -1);
    rb_define_method(cFXListBox.klass, "setSelTextColor", VALUEFUNC(_wrap_FXListBox_setSelTextColor), -1);
    rb_define_method(cFXListBox.klass, "getSelTextColor", VALUEFUNC(_wrap_FXListBox_getSelTextColor), -1);
    rb_define_method(cFXListBox.klass, "setHelpText", VALUEFUNC(_wrap_FXListBox_setHelpText), -1);
    rb_define_method(cFXListBox.klass, "getHelpText", VALUEFUNC(_wrap_FXListBox_getHelpText), -1);
    rb_define_method(cFXListBox.klass, "setTipText", VALUEFUNC(_wrap_FXListBox_setTipText), -1);
    rb_define_method(cFXListBox.klass, "getTipText", VALUEFUNC(_wrap_FXListBox_getTipText), -1);
    rb_define_method(cFXListBox.klass, "save", VALUEFUNC(_wrap_FXListBox_save), -1);
    rb_define_method(cFXListBox.klass, "load", VALUEFUNC(_wrap_FXListBox_load), -1);
    rb_define_method(cFXListBox.klass, "create", VALUEFUNC(_wrap_FXListBox_create), -1);
    rb_define_method(cFXListBox.klass, "detach", VALUEFUNC(_wrap_FXListBox_detach), -1);
    rb_define_method(cFXListBox.klass, "destroy", VALUEFUNC(_wrap_FXListBox_destroy), -1);
    rb_define_method(cFXListBox.klass, "resize", VALUEFUNC(_wrap_FXListBox_resize), -1);
    rb_define_method(cFXListBox.klass, "getDefaultWidth", VALUEFUNC(_wrap_FXListBox_getDefaultWidth), -1);
    rb_define_method(cFXListBox.klass, "getDefaultHeight", VALUEFUNC(_wrap_FXListBox_getDefaultHeight), -1);
    rb_define_method(cFXListBox.klass, "getWidthForHeight", VALUEFUNC(_wrap_FXListBox_getWidthForHeight), -1);
    rb_define_method(cFXListBox.klass, "getHeightForWidth", VALUEFUNC(_wrap_FXListBox_getHeightForWidth), -1);
    rb_define_method(cFXListBox.klass, "canFocus", VALUEFUNC(_wrap_FXListBox_canFocus), -1);
    rb_define_method(cFXListBox.klass, "setFocus", VALUEFUNC(_wrap_FXListBox_setFocus), -1);
    rb_define_method(cFXListBox.klass, "killFocus", VALUEFUNC(_wrap_FXListBox_killFocus), -1);
    rb_define_method(cFXListBox.klass, "setDefault", VALUEFUNC(_wrap_FXListBox_setDefault), -1);
    rb_define_method(cFXListBox.klass, "enable", VALUEFUNC(_wrap_FXListBox_enable), -1);
    rb_define_method(cFXListBox.klass, "disable", VALUEFUNC(_wrap_FXListBox_disable), -1);
    rb_define_method(cFXListBox.klass, "raiseWindow", VALUEFUNC(_wrap_FXListBox_raiseWindow), -1);
    rb_define_method(cFXListBox.klass, "lower", VALUEFUNC(_wrap_FXListBox_lower), -1);
    rb_define_method(cFXListBox.klass, "move", VALUEFUNC(_wrap_FXListBox_move), -1);
    rb_define_method(cFXListBox.klass, "position", VALUEFUNC(_wrap_FXListBox_position), -1);
    rb_define_method(cFXListBox.klass, "layout", VALUEFUNC(_wrap_FXListBox_layout), -1);
    rb_define_method(cFXListBox.klass, "recalc", VALUEFUNC(_wrap_FXListBox_recalc), -1);
    rb_define_method(cFXListBox.klass, "reparent", VALUEFUNC(_wrap_FXListBox_reparent), -1);
    rb_define_method(cFXListBox.klass, "show", VALUEFUNC(_wrap_FXListBox_show), -1);
    rb_define_method(cFXListBox.klass, "hide", VALUEFUNC(_wrap_FXListBox_hide), -1);
    rb_define_method(cFXListBox.klass, "isComposite", VALUEFUNC(_wrap_FXListBox_isComposite), -1);
    rb_define_method(cFXListBox.klass, "contains", VALUEFUNC(_wrap_FXListBox_contains), -1);
    rb_define_method(cFXListBox.klass, "doesSaveUnder", VALUEFUNC(_wrap_FXListBox_doesSaveUnder), -1);
    rb_define_method(cFXListBox.klass, "setBackColor", VALUEFUNC(_wrap_FXListBox_setBackColor), -1);
    cFXListBox.mark = (void (*)(void *)) FXRbListBox::markfunc;
    cFXListBox.destroy = (void (*)(void *)) FXRbObject::freefunc;
    
    SWIGTYPE_p_FXListBox->dcast = (swig_dycast_func) FXListBox_dynamic_cast;
    
    rb_define_const(mFox,"TREELISTBOX_NORMAL", INT2NUM(TREELISTBOX_NORMAL));
    
    cFXTreeListBox.klass = rb_define_class_under(mFox, "FXTreeListBox", ((swig_class *) SWIGTYPE_p_FXPacker->clientdata)->klass);
    SWIG_TypeClientData(SWIGTYPE_p_FXTreeListBox, (void *) &cFXTreeListBox);
    rb_define_alloc_func(cFXTreeListBox.klass, _wrap_FXTreeListBox_allocate);
    rb_define_method(cFXTreeListBox.klass, "initialize", VALUEFUNC(_wrap_new_FXTreeListBox), -1);
    rb_define_method(cFXTreeListBox.klass, "onFocusUp", VALUEFUNC(_wrap_FXTreeListBox_onFocusUp), -1);
    rb_define_method(cFXTreeListBox.klass, "onFocusDown", VALUEFUNC(_wrap_FXTreeListBox_onFocusDown), -1);
    rb_define_method(cFXTreeListBox.klass, "onFocusSelf", VALUEFUNC(_wrap_FXTreeListBox_onFocusSelf), -1);
    rb_define_method(cFXTreeListBox.klass, "onChanged", VALUEFUNC(_wrap_FXTreeListBox_onChanged), -1);
    rb_define_method(cFXTreeListBox.klass, "onCommand", VALUEFUNC(_wrap_FXTreeListBox_onCommand), -1);
    rb_define_method(cFXTreeListBox.klass, "onFieldButton", VALUEFUNC(_wrap_FXTreeListBox_onFieldButton), -1);
    rb_define_method(cFXTreeListBox.klass, "onTreeChanged", VALUEFUNC(_wrap_FXTreeListBox_onTreeChanged), -1);
    rb_define_method(cFXTreeListBox.klass, "onTreeClicked", VALUEFUNC(_wrap_FXTreeListBox_onTreeClicked), -1);
    rb_define_method(cFXTreeListBox.klass, "onUpdFmTree", VALUEFUNC(_wrap_FXTreeListBox_onUpdFmTree), -1);
    rb_define_const(cFXTreeListBox.klass,"ID_TREE", INT2NUM(FXTreeListBox::ID_TREE));
    rb_define_const(cFXTreeListBox.klass,"ID_FIELD", INT2NUM(FXTreeListBox::ID_FIELD));
    rb_define_const(cFXTreeListBox.klass,"ID_LAST", INT2NUM(FXTreeListBox::ID_LAST));
    rb_define_method(cFXTreeListBox.klass, "getNumItems", VALUEFUNC(_wrap_FXTreeListBox_getNumItems), -1);
    rb_define_method(cFXTreeListBox.klass, "getNumVisible", VALUEFUNC(_wrap_FXTreeListBox_getNumVisible), -1);
    rb_define_method(cFXTreeListBox.klass, "setNumVisible", VALUEFUNC(_wrap_FXTreeListBox_setNumVisible), -1);
    rb_define_method(cFXTreeListBox.klass, "getFirstItem", VALUEFUNC(_wrap_FXTreeListBox_getFirstItem), -1);
    rb_define_method(cFXTreeListBox.klass, "getLastItem", VALUEFUNC(_wrap_FXTreeListBox_getLastItem), -1);
    rb_define_method(cFXTreeListBox.klass, "addItemFirst", VALUEFUNC(_wrap_FXTreeListBox_addItemFirst), -1);
    rb_define_method(cFXTreeListBox.klass, "addItemLast", VALUEFUNC(_wrap_FXTreeListBox_addItemLast), -1);
    rb_define_method(cFXTreeListBox.klass, "addItemAfter", VALUEFUNC(_wrap_FXTreeListBox_addItemAfter), -1);
    rb_define_method(cFXTreeListBox.klass, "addItemBefore", VALUEFUNC(_wrap_FXTreeListBox_addItemBefore), -1);
    rb_define_method(cFXTreeListBox.klass, "removeItem", VALUEFUNC(_wrap_FXTreeListBox_removeItem), -1);
    rb_define_method(cFXTreeListBox.klass, "removeItems", VALUEFUNC(_wrap_FXTreeListBox_removeItems), -1);
    rb_define_method(cFXTreeListBox.klass, "clearItems", VALUEFUNC(_wrap_FXTreeListBox_clearItems), -1);
    rb_define_method(cFXTreeListBox.klass, "findItem", VALUEFUNC(_wrap_FXTreeListBox_findItem), -1);
    rb_define_method(cFXTreeListBox.klass, "isItemCurrent", VALUEFUNC(_wrap_FXTreeListBox_isItemCurrent), -1);
    rb_define_method(cFXTreeListBox.klass, "isItemLeaf", VALUEFUNC(_wrap_FXTreeListBox_isItemLeaf), -1);
    rb_define_method(cFXTreeListBox.klass, "sortRootItems", VALUEFUNC(_wrap_FXTreeListBox_sortRootItems), -1);
    rb_define_method(cFXTreeListBox.klass, "sortItems", VALUEFUNC(_wrap_FXTreeListBox_sortItems), -1);
    rb_define_method(cFXTreeListBox.klass, "sortChildItems", VALUEFUNC(_wrap_FXTreeListBox_sortChildItems), -1);
    rb_define_method(cFXTreeListBox.klass, "setCurrentItem", VALUEFUNC(_wrap_FXTreeListBox_setCurrentItem), -1);
    rb_define_method(cFXTreeListBox.klass, "getCurrentItem", VALUEFUNC(_wrap_FXTreeListBox_getCurrentItem), -1);
    rb_define_method(cFXTreeListBox.klass, "setItemText", VALUEFUNC(_wrap_FXTreeListBox_setItemText), -1);
    rb_define_method(cFXTreeListBox.klass, "getItemText", VALUEFUNC(_wrap_FXTreeListBox_getItemText), -1);
    rb_define_method(cFXTreeListBox.klass, "setItemOpenIcon", VALUEFUNC(_wrap_FXTreeListBox_setItemOpenIcon), -1);
    rb_define_method(cFXTreeListBox.klass, "getItemOpenIcon", VALUEFUNC(_wrap_FXTreeListBox_getItemOpenIcon), -1);
    rb_define_method(cFXTreeListBox.klass, "setItemClosedIcon", VALUEFUNC(_wrap_FXTreeListBox_setItemClosedIcon), -1);
    rb_define_method(cFXTreeListBox.klass, "getItemClosedIcon", VALUEFUNC(_wrap_FXTreeListBox_getItemClosedIcon), -1);
    rb_define_method(cFXTreeListBox.klass, "setItemData", VALUEFUNC(_wrap_FXTreeListBox_setItemData), -1);
    rb_define_method(cFXTreeListBox.klass, "getItemData", VALUEFUNC(_wrap_FXTreeListBox_getItemData), -1);
    rb_define_method(cFXTreeListBox.klass, "isPaneShown", VALUEFUNC(_wrap_FXTreeListBox_isPaneShown), -1);
    rb_define_method(cFXTreeListBox.klass, "setFont", VALUEFUNC(_wrap_FXTreeListBox_setFont), -1);
    rb_define_method(cFXTreeListBox.klass, "getFont", VALUEFUNC(_wrap_FXTreeListBox_getFont), -1);
    rb_define_method(cFXTreeListBox.klass, "getListStyle", VALUEFUNC(_wrap_FXTreeListBox_getListStyle), -1);
    rb_define_method(cFXTreeListBox.klass, "setListStyle", VALUEFUNC(_wrap_FXTreeListBox_setListStyle), -1);
    rb_define_method(cFXTreeListBox.klass, "setHelpText", VALUEFUNC(_wrap_FXTreeListBox_setHelpText), -1);
    rb_define_method(cFXTreeListBox.klass, "getHelpText", VALUEFUNC(_wrap_FXTreeListBox_getHelpText), -1);
    rb_define_method(cFXTreeListBox.klass, "setTipText", VALUEFUNC(_wrap_FXTreeListBox_setTipText), -1);
    rb_define_method(cFXTreeListBox.klass, "getTipText", VALUEFUNC(_wrap_FXTreeListBox_getTipText), -1);
    rb_define_method(cFXTreeListBox.klass, "save", VALUEFUNC(_wrap_FXTreeListBox_save), -1);
    rb_define_method(cFXTreeListBox.klass, "load", VALUEFUNC(_wrap_FXTreeListBox_load), -1);
    rb_define_method(cFXTreeListBox.klass, "create", VALUEFUNC(_wrap_FXTreeListBox_create), -1);
    rb_define_method(cFXTreeListBox.klass, "detach", VALUEFUNC(_wrap_FXTreeListBox_detach), -1);
    rb_define_method(cFXTreeListBox.klass, "destroy", VALUEFUNC(_wrap_FXTreeListBox_destroy), -1);
    rb_define_method(cFXTreeListBox.klass, "resize", VALUEFUNC(_wrap_FXTreeListBox_resize), -1);
    rb_define_method(cFXTreeListBox.klass, "getDefaultWidth", VALUEFUNC(_wrap_FXTreeListBox_getDefaultWidth), -1);
    rb_define_method(cFXTreeListBox.klass, "getDefaultHeight", VALUEFUNC(_wrap_FXTreeListBox_getDefaultHeight), -1);
    rb_define_method(cFXTreeListBox.klass, "getWidthForHeight", VALUEFUNC(_wrap_FXTreeListBox_getWidthForHeight), -1);
    rb_define_method(cFXTreeListBox.klass, "getHeightForWidth", VALUEFUNC(_wrap_FXTreeListBox_getHeightForWidth), -1);
    rb_define_method(cFXTreeListBox.klass, "canFocus", VALUEFUNC(_wrap_FXTreeListBox_canFocus), -1);
    rb_define_method(cFXTreeListBox.klass, "setFocus", VALUEFUNC(_wrap_FXTreeListBox_setFocus), -1);
    rb_define_method(cFXTreeListBox.klass, "killFocus", VALUEFUNC(_wrap_FXTreeListBox_killFocus), -1);
    rb_define_method(cFXTreeListBox.klass, "setDefault", VALUEFUNC(_wrap_FXTreeListBox_setDefault), -1);
    rb_define_method(cFXTreeListBox.klass, "enable", VALUEFUNC(_wrap_FXTreeListBox_enable), -1);
    rb_define_method(cFXTreeListBox.klass, "disable", VALUEFUNC(_wrap_FXTreeListBox_disable), -1);
    rb_define_method(cFXTreeListBox.klass, "raiseWindow", VALUEFUNC(_wrap_FXTreeListBox_raiseWindow), -1);
    rb_define_method(cFXTreeListBox.klass, "lower", VALUEFUNC(_wrap_FXTreeListBox_lower), -1);
    rb_define_method(cFXTreeListBox.klass, "move", VALUEFUNC(_wrap_FXTreeListBox_move), -1);
    rb_define_method(cFXTreeListBox.klass, "position", VALUEFUNC(_wrap_FXTreeListBox_position), -1);
    rb_define_method(cFXTreeListBox.klass, "layout", VALUEFUNC(_wrap_FXTreeListBox_layout), -1);
    rb_define_method(cFXTreeListBox.klass, "recalc", VALUEFUNC(_wrap_FXTreeListBox_recalc), -1);
    rb_define_method(cFXTreeListBox.klass, "reparent", VALUEFUNC(_wrap_FXTreeListBox_reparent), -1);
    rb_define_method(cFXTreeListBox.klass, "show", VALUEFUNC(_wrap_FXTreeListBox_show), -1);
    rb_define_method(cFXTreeListBox.klass, "hide", VALUEFUNC(_wrap_FXTreeListBox_hide), -1);
    rb_define_method(cFXTreeListBox.klass, "isComposite", VALUEFUNC(_wrap_FXTreeListBox_isComposite), -1);
    rb_define_method(cFXTreeListBox.klass, "contains", VALUEFUNC(_wrap_FXTreeListBox_contains), -1);
    rb_define_method(cFXTreeListBox.klass, "doesSaveUnder", VALUEFUNC(_wrap_FXTreeListBox_doesSaveUnder), -1);
    rb_define_method(cFXTreeListBox.klass, "setBackColor", VALUEFUNC(_wrap_FXTreeListBox_setBackColor), -1);
    cFXTreeListBox.mark = (void (*)(void *)) FXRbTreeListBox::markfunc;
    cFXTreeListBox.destroy = (void (*)(void *)) FXRbObject::freefunc;
    
    SWIGTYPE_p_FXTreeListBox->dcast = (swig_dycast_func) FXTreeListBox_dynamic_cast;
    
    rb_define_const(mFox,"IMAGEVIEW_NORMAL", INT2NUM(IMAGEVIEW_NORMAL));
    rb_define_const(mFox,"IMAGEVIEW_CENTER_X", INT2NUM(IMAGEVIEW_CENTER_X));
    rb_define_const(mFox,"IMAGEVIEW_LEFT", INT2NUM(IMAGEVIEW_LEFT));
    rb_define_const(mFox,"IMAGEVIEW_RIGHT", INT2NUM(IMAGEVIEW_RIGHT));
    rb_define_const(mFox,"IMAGEVIEW_CENTER_Y", INT2NUM(IMAGEVIEW_CENTER_Y));
    rb_define_const(mFox,"IMAGEVIEW_TOP", INT2NUM(IMAGEVIEW_TOP));
    rb_define_const(mFox,"IMAGEVIEW_BOTTOM", INT2NUM(IMAGEVIEW_BOTTOM));
    
    cFXImageView.klass = rb_define_class_under(mFox, "FXImageView", ((swig_class *) SWIGTYPE_p_FXScrollArea->clientdata)->klass);
    SWIG_TypeClientData(SWIGTYPE_p_FXImageView, (void *) &cFXImageView);
    rb_define_alloc_func(cFXImageView.klass, _wrap_FXImageView_allocate);
    rb_define_method(cFXImageView.klass, "initialize", VALUEFUNC(_wrap_new_FXImageView), -1);
    rb_define_method(cFXImageView.klass, "onPaint", VALUEFUNC(_wrap_FXImageView_onPaint), -1);
    rb_define_method(cFXImageView.klass, "onMotion", VALUEFUNC(_wrap_FXImageView_onMotion), -1);
    rb_define_method(cFXImageView.klass, "onRightBtnPress", VALUEFUNC(_wrap_FXImageView_onRightBtnPress), -1);
    rb_define_method(cFXImageView.klass, "onRightBtnRelease", VALUEFUNC(_wrap_FXImageView_onRightBtnRelease), -1);
    rb_define_const(cFXImageView.klass,"ID_XYZ", INT2NUM(FXImageView::ID_XYZ));
    rb_define_const(cFXImageView.klass,"ID_LAST", INT2NUM(FXImageView::ID_LAST));
    rb_define_method(cFXImageView.klass, "setImage", VALUEFUNC(_wrap_FXImageView_setImage), -1);
    rb_define_method(cFXImageView.klass, "getImage", VALUEFUNC(_wrap_FXImageView_getImage), -1);
    rb_define_method(cFXImageView.klass, "setAlignment", VALUEFUNC(_wrap_FXImageView_setAlignment), -1);
    rb_define_method(cFXImageView.klass, "getAlignment", VALUEFUNC(_wrap_FXImageView_getAlignment), -1);
    rb_define_method(cFXImageView.klass, "save", VALUEFUNC(_wrap_FXImageView_save), -1);
    rb_define_method(cFXImageView.klass, "load", VALUEFUNC(_wrap_FXImageView_load), -1);
    rb_define_method(cFXImageView.klass, "create", VALUEFUNC(_wrap_FXImageView_create), -1);
    rb_define_method(cFXImageView.klass, "detach", VALUEFUNC(_wrap_FXImageView_detach), -1);
    rb_define_method(cFXImageView.klass, "destroy", VALUEFUNC(_wrap_FXImageView_destroy), -1);
    rb_define_method(cFXImageView.klass, "resize", VALUEFUNC(_wrap_FXImageView_resize), -1);
    rb_define_method(cFXImageView.klass, "getDefaultWidth", VALUEFUNC(_wrap_FXImageView_getDefaultWidth), -1);
    rb_define_method(cFXImageView.klass, "getDefaultHeight", VALUEFUNC(_wrap_FXImageView_getDefaultHeight), -1);
    rb_define_method(cFXImageView.klass, "getWidthForHeight", VALUEFUNC(_wrap_FXImageView_getWidthForHeight), -1);
    rb_define_method(cFXImageView.klass, "getHeightForWidth", VALUEFUNC(_wrap_FXImageView_getHeightForWidth), -1);
    rb_define_method(cFXImageView.klass, "canFocus", VALUEFUNC(_wrap_FXImageView_canFocus), -1);
    rb_define_method(cFXImageView.klass, "setFocus", VALUEFUNC(_wrap_FXImageView_setFocus), -1);
    rb_define_method(cFXImageView.klass, "killFocus", VALUEFUNC(_wrap_FXImageView_killFocus), -1);
    rb_define_method(cFXImageView.klass, "setDefault", VALUEFUNC(_wrap_FXImageView_setDefault), -1);
    rb_define_method(cFXImageView.klass, "enable", VALUEFUNC(_wrap_FXImageView_enable), -1);
    rb_define_method(cFXImageView.klass, "disable", VALUEFUNC(_wrap_FXImageView_disable), -1);
    rb_define_method(cFXImageView.klass, "raiseWindow", VALUEFUNC(_wrap_FXImageView_raiseWindow), -1);
    rb_define_method(cFXImageView.klass, "lower", VALUEFUNC(_wrap_FXImageView_lower), -1);
    rb_define_method(cFXImageView.klass, "move", VALUEFUNC(_wrap_FXImageView_move), -1);
    rb_define_method(cFXImageView.klass, "layout", VALUEFUNC(_wrap_FXImageView_layout), -1);
    rb_define_method(cFXImageView.klass, "recalc", VALUEFUNC(_wrap_FXImageView_recalc), -1);
    rb_define_method(cFXImageView.klass, "reparent", VALUEFUNC(_wrap_FXImageView_reparent), -1);
    rb_define_method(cFXImageView.klass, "show", VALUEFUNC(_wrap_FXImageView_show), -1);
    rb_define_method(cFXImageView.klass, "hide", VALUEFUNC(_wrap_FXImageView_hide), -1);
    rb_define_method(cFXImageView.klass, "isComposite", VALUEFUNC(_wrap_FXImageView_isComposite), -1);
    rb_define_method(cFXImageView.klass, "contains", VALUEFUNC(_wrap_FXImageView_contains), -1);
    rb_define_method(cFXImageView.klass, "doesSaveUnder", VALUEFUNC(_wrap_FXImageView_doesSaveUnder), -1);
    rb_define_method(cFXImageView.klass, "setBackColor", VALUEFUNC(_wrap_FXImageView_setBackColor), -1);
    rb_define_method(cFXImageView.klass, "getViewportHeight", VALUEFUNC(_wrap_FXImageView_getViewportHeight), -1);
    rb_define_method(cFXImageView.klass, "getViewportWidth", VALUEFUNC(_wrap_FXImageView_getViewportWidth), -1);
    rb_define_method(cFXImageView.klass, "getContentHeight", VALUEFUNC(_wrap_FXImageView_getContentHeight), -1);
    rb_define_method(cFXImageView.klass, "getContentWidth", VALUEFUNC(_wrap_FXImageView_getContentWidth), -1);
    rb_define_method(cFXImageView.klass, "position", VALUEFUNC(_wrap_FXImageView_position), -1);
    cFXImageView.mark = (void (*)(void *)) FXRbImageView::markfunc;
    cFXImageView.destroy = (void (*)(void *)) FXRbObject::freefunc;
    
    cFXDragCorner.klass = rb_define_class_under(mFox, "FXDragCorner", ((swig_class *) SWIGTYPE_p_FXWindow->clientdata)->klass);
    SWIG_TypeClientData(SWIGTYPE_p_FXDragCorner, (void *) &cFXDragCorner);
    rb_define_alloc_func(cFXDragCorner.klass, _wrap_FXDragCorner_allocate);
    rb_define_method(cFXDragCorner.klass, "initialize", VALUEFUNC(_wrap_new_FXDragCorner), -1);
    rb_define_method(cFXDragCorner.klass, "onPaint", VALUEFUNC(_wrap_FXDragCorner_onPaint), -1);
    rb_define_method(cFXDragCorner.klass, "onLeftBtnPress", VALUEFUNC(_wrap_FXDragCorner_onLeftBtnPress), -1);
    rb_define_method(cFXDragCorner.klass, "onLeftBtnRelease", VALUEFUNC(_wrap_FXDragCorner_onLeftBtnRelease), -1);
    rb_define_method(cFXDragCorner.klass, "onMotion", VALUEFUNC(_wrap_FXDragCorner_onMotion), -1);
    rb_define_method(cFXDragCorner.klass, "setHiliteColor", VALUEFUNC(_wrap_FXDragCorner_setHiliteColor), -1);
    rb_define_method(cFXDragCorner.klass, "getHiliteColor", VALUEFUNC(_wrap_FXDragCorner_getHiliteColor), -1);
    rb_define_method(cFXDragCorner.klass, "setShadowColor", VALUEFUNC(_wrap_FXDragCorner_setShadowColor), -1);
    rb_define_method(cFXDragCorner.klass, "getShadowColor", VALUEFUNC(_wrap_FXDragCorner_getShadowColor), -1);
    rb_define_method(cFXDragCorner.klass, "save", VALUEFUNC(_wrap_FXDragCorner_save), -1);
    rb_define_method(cFXDragCorner.klass, "load", VALUEFUNC(_wrap_FXDragCorner_load), -1);
    rb_define_method(cFXDragCorner.klass, "create", VALUEFUNC(_wrap_FXDragCorner_create), -1);
    rb_define_method(cFXDragCorner.klass, "detach", VALUEFUNC(_wrap_FXDragCorner_detach), -1);
    rb_define_method(cFXDragCorner.klass, "destroy", VALUEFUNC(_wrap_FXDragCorner_destroy), -1);
    rb_define_method(cFXDragCorner.klass, "resize", VALUEFUNC(_wrap_FXDragCorner_resize), -1);
    rb_define_method(cFXDragCorner.klass, "getDefaultWidth", VALUEFUNC(_wrap_FXDragCorner_getDefaultWidth), -1);
    rb_define_method(cFXDragCorner.klass, "getDefaultHeight", VALUEFUNC(_wrap_FXDragCorner_getDefaultHeight), -1);
    rb_define_method(cFXDragCorner.klass, "getWidthForHeight", VALUEFUNC(_wrap_FXDragCorner_getWidthForHeight), -1);
    rb_define_method(cFXDragCorner.klass, "getHeightForWidth", VALUEFUNC(_wrap_FXDragCorner_getHeightForWidth), -1);
    rb_define_method(cFXDragCorner.klass, "canFocus", VALUEFUNC(_wrap_FXDragCorner_canFocus), -1);
    rb_define_method(cFXDragCorner.klass, "setFocus", VALUEFUNC(_wrap_FXDragCorner_setFocus), -1);
    rb_define_method(cFXDragCorner.klass, "killFocus", VALUEFUNC(_wrap_FXDragCorner_killFocus), -1);
    rb_define_method(cFXDragCorner.klass, "setDefault", VALUEFUNC(_wrap_FXDragCorner_setDefault), -1);
    rb_define_method(cFXDragCorner.klass, "enable", VALUEFUNC(_wrap_FXDragCorner_enable), -1);
    rb_define_method(cFXDragCorner.klass, "disable", VALUEFUNC(_wrap_FXDragCorner_disable), -1);
    rb_define_method(cFXDragCorner.klass, "raiseWindow", VALUEFUNC(_wrap_FXDragCorner_raiseWindow), -1);
    rb_define_method(cFXDragCorner.klass, "lower", VALUEFUNC(_wrap_FXDragCorner_lower), -1);
    rb_define_method(cFXDragCorner.klass, "move", VALUEFUNC(_wrap_FXDragCorner_move), -1);
    rb_define_method(cFXDragCorner.klass, "position", VALUEFUNC(_wrap_FXDragCorner_position), -1);
    rb_define_method(cFXDragCorner.klass, "layout", VALUEFUNC(_wrap_FXDragCorner_layout), -1);
    rb_define_method(cFXDragCorner.klass, "recalc", VALUEFUNC(_wrap_FXDragCorner_recalc), -1);
    rb_define_method(cFXDragCorner.klass, "reparent", VALUEFUNC(_wrap_FXDragCorner_reparent), -1);
    rb_define_method(cFXDragCorner.klass, "show", VALUEFUNC(_wrap_FXDragCorner_show), -1);
    rb_define_method(cFXDragCorner.klass, "hide", VALUEFUNC(_wrap_FXDragCorner_hide), -1);
    rb_define_method(cFXDragCorner.klass, "isComposite", VALUEFUNC(_wrap_FXDragCorner_isComposite), -1);
    rb_define_method(cFXDragCorner.klass, "contains", VALUEFUNC(_wrap_FXDragCorner_contains), -1);
    rb_define_method(cFXDragCorner.klass, "doesSaveUnder", VALUEFUNC(_wrap_FXDragCorner_doesSaveUnder), -1);
    rb_define_method(cFXDragCorner.klass, "setBackColor", VALUEFUNC(_wrap_FXDragCorner_setBackColor), -1);
    cFXDragCorner.mark = (void (*)(void *)) FXRbDragCorner::markfunc;
    cFXDragCorner.destroy = (void (*)(void *)) FXRbObject::freefunc;
    rb_define_const(mFox,"DIRBOX_NO_OWN_ASSOC", INT2NUM(DIRBOX_NO_OWN_ASSOC));
    
    cFXDirBox.klass = rb_define_class_under(mFox, "FXDirBox", ((swig_class *) SWIGTYPE_p_FXTreeListBox->clientdata)->klass);
    SWIG_TypeClientData(SWIGTYPE_p_FXDirBox, (void *) &cFXDirBox);
    rb_define_alloc_func(cFXDirBox.klass, _wrap_FXDirBox_allocate);
    rb_define_method(cFXDirBox.klass, "initialize", VALUEFUNC(_wrap_new_FXDirBox), -1);
    rb_define_method(cFXDirBox.klass, "onChanged", VALUEFUNC(_wrap_FXDirBox_onChanged), -1);
    rb_define_method(cFXDirBox.klass, "onCommand", VALUEFUNC(_wrap_FXDirBox_onCommand), -1);
    rb_define_method(cFXDirBox.klass, "onCmdSetValue", VALUEFUNC(_wrap_FXDirBox_onCmdSetValue), -1);
    rb_define_method(cFXDirBox.klass, "onCmdSetStringValue", VALUEFUNC(_wrap_FXDirBox_onCmdSetStringValue), -1);
    rb_define_method(cFXDirBox.klass, "onCmdGetStringValue", VALUEFUNC(_wrap_FXDirBox_onCmdGetStringValue), -1);
    rb_define_method(cFXDirBox.klass, "setDirectory", VALUEFUNC(_wrap_FXDirBox_setDirectory), -1);
    rb_define_method(cFXDirBox.klass, "getDirectory", VALUEFUNC(_wrap_FXDirBox_getDirectory), -1);
    rb_define_method(cFXDirBox.klass, "setAssociations", VALUEFUNC(_wrap_FXDirBox_setAssociations), -1);
    rb_define_method(cFXDirBox.klass, "getAssociations", VALUEFUNC(_wrap_FXDirBox_getAssociations), -1);
    rb_define_method(cFXDirBox.klass, "save", VALUEFUNC(_wrap_FXDirBox_save), -1);
    rb_define_method(cFXDirBox.klass, "load", VALUEFUNC(_wrap_FXDirBox_load), -1);
    rb_define_method(cFXDirBox.klass, "create", VALUEFUNC(_wrap_FXDirBox_create), -1);
    rb_define_method(cFXDirBox.klass, "detach", VALUEFUNC(_wrap_FXDirBox_detach), -1);
    rb_define_method(cFXDirBox.klass, "destroy", VALUEFUNC(_wrap_FXDirBox_destroy), -1);
    rb_define_method(cFXDirBox.klass, "resize", VALUEFUNC(_wrap_FXDirBox_resize), -1);
    rb_define_method(cFXDirBox.klass, "getDefaultWidth", VALUEFUNC(_wrap_FXDirBox_getDefaultWidth), -1);
    rb_define_method(cFXDirBox.klass, "getDefaultHeight", VALUEFUNC(_wrap_FXDirBox_getDefaultHeight), -1);
    rb_define_method(cFXDirBox.klass, "getWidthForHeight", VALUEFUNC(_wrap_FXDirBox_getWidthForHeight), -1);
    rb_define_method(cFXDirBox.klass, "getHeightForWidth", VALUEFUNC(_wrap_FXDirBox_getHeightForWidth), -1);
    rb_define_method(cFXDirBox.klass, "canFocus", VALUEFUNC(_wrap_FXDirBox_canFocus), -1);
    rb_define_method(cFXDirBox.klass, "setFocus", VALUEFUNC(_wrap_FXDirBox_setFocus), -1);
    rb_define_method(cFXDirBox.klass, "killFocus", VALUEFUNC(_wrap_FXDirBox_killFocus), -1);
    rb_define_method(cFXDirBox.klass, "setDefault", VALUEFUNC(_wrap_FXDirBox_setDefault), -1);
    rb_define_method(cFXDirBox.klass, "enable", VALUEFUNC(_wrap_FXDirBox_enable), -1);
    rb_define_method(cFXDirBox.klass, "disable", VALUEFUNC(_wrap_FXDirBox_disable), -1);
    rb_define_method(cFXDirBox.klass, "raiseWindow", VALUEFUNC(_wrap_FXDirBox_raiseWindow), -1);
    rb_define_method(cFXDirBox.klass, "lower", VALUEFUNC(_wrap_FXDirBox_lower), -1);
    rb_define_method(cFXDirBox.klass, "move", VALUEFUNC(_wrap_FXDirBox_move), -1);
    rb_define_method(cFXDirBox.klass, "position", VALUEFUNC(_wrap_FXDirBox_position), -1);
    rb_define_method(cFXDirBox.klass, "layout", VALUEFUNC(_wrap_FXDirBox_layout), -1);
    rb_define_method(cFXDirBox.klass, "recalc", VALUEFUNC(_wrap_FXDirBox_recalc), -1);
    rb_define_method(cFXDirBox.klass, "reparent", VALUEFUNC(_wrap_FXDirBox_reparent), -1);
    rb_define_method(cFXDirBox.klass, "show", VALUEFUNC(_wrap_FXDirBox_show), -1);
    rb_define_method(cFXDirBox.klass, "hide", VALUEFUNC(_wrap_FXDirBox_hide), -1);
    rb_define_method(cFXDirBox.klass, "isComposite", VALUEFUNC(_wrap_FXDirBox_isComposite), -1);
    rb_define_method(cFXDirBox.klass, "contains", VALUEFUNC(_wrap_FXDirBox_contains), -1);
    rb_define_method(cFXDirBox.klass, "doesSaveUnder", VALUEFUNC(_wrap_FXDirBox_doesSaveUnder), -1);
    rb_define_method(cFXDirBox.klass, "setBackColor", VALUEFUNC(_wrap_FXDirBox_setBackColor), -1);
    cFXDirBox.mark = (void (*)(void *)) FXRbDirBox::markfunc;
    cFXDirBox.destroy = (void (*)(void *)) FXRbObject::freefunc;
    
    cFXDriveBox.klass = rb_define_class_under(mFox, "FXDriveBox", ((swig_class *) SWIGTYPE_p_FXListBox->clientdata)->klass);
    SWIG_TypeClientData(SWIGTYPE_p_FXDriveBox, (void *) &cFXDriveBox);
    rb_define_alloc_func(cFXDriveBox.klass, _wrap_FXDriveBox_allocate);
    rb_define_method(cFXDriveBox.klass, "initialize", VALUEFUNC(_wrap_new_FXDriveBox), -1);
    rb_define_method(cFXDriveBox.klass, "onListChanged", VALUEFUNC(_wrap_FXDriveBox_onListChanged), -1);
    rb_define_method(cFXDriveBox.klass, "onListClicked", VALUEFUNC(_wrap_FXDriveBox_onListClicked), -1);
    rb_define_method(cFXDriveBox.klass, "onCmdSetValue", VALUEFUNC(_wrap_FXDriveBox_onCmdSetValue), -1);
    rb_define_method(cFXDriveBox.klass, "onCmdSetStringValue", VALUEFUNC(_wrap_FXDriveBox_onCmdSetStringValue), -1);
    rb_define_method(cFXDriveBox.klass, "onCmdGetStringValue", VALUEFUNC(_wrap_FXDriveBox_onCmdGetStringValue), -1);
    rb_define_method(cFXDriveBox.klass, "setDrive", VALUEFUNC(_wrap_FXDriveBox_setDrive), -1);
    rb_define_method(cFXDriveBox.klass, "getDrive", VALUEFUNC(_wrap_FXDriveBox_getDrive), -1);
    rb_define_method(cFXDriveBox.klass, "setAssociations", VALUEFUNC(_wrap_FXDriveBox_setAssociations), -1);
    rb_define_method(cFXDriveBox.klass, "getAssociations", VALUEFUNC(_wrap_FXDriveBox_getAssociations), -1);
    rb_define_method(cFXDriveBox.klass, "save", VALUEFUNC(_wrap_FXDriveBox_save), -1);
    rb_define_method(cFXDriveBox.klass, "load", VALUEFUNC(_wrap_FXDriveBox_load), -1);
    rb_define_method(cFXDriveBox.klass, "create", VALUEFUNC(_wrap_FXDriveBox_create), -1);
    rb_define_method(cFXDriveBox.klass, "detach", VALUEFUNC(_wrap_FXDriveBox_detach), -1);
    rb_define_method(cFXDriveBox.klass, "destroy", VALUEFUNC(_wrap_FXDriveBox_destroy), -1);
    rb_define_method(cFXDriveBox.klass, "resize", VALUEFUNC(_wrap_FXDriveBox_resize), -1);
    rb_define_method(cFXDriveBox.klass, "getDefaultWidth", VALUEFUNC(_wrap_FXDriveBox_getDefaultWidth), -1);
    rb_define_method(cFXDriveBox.klass, "getDefaultHeight", VALUEFUNC(_wrap_FXDriveBox_getDefaultHeight), -1);
    rb_define_method(cFXDriveBox.klass, "getWidthForHeight", VALUEFUNC(_wrap_FXDriveBox_getWidthForHeight), -1);
    rb_define_method(cFXDriveBox.klass, "getHeightForWidth", VALUEFUNC(_wrap_FXDriveBox_getHeightForWidth), -1);
    rb_define_method(cFXDriveBox.klass, "canFocus", VALUEFUNC(_wrap_FXDriveBox_canFocus), -1);
    rb_define_method(cFXDriveBox.klass, "setFocus", VALUEFUNC(_wrap_FXDriveBox_setFocus), -1);
    rb_define_method(cFXDriveBox.klass, "killFocus", VALUEFUNC(_wrap_FXDriveBox_killFocus), -1);
    rb_define_method(cFXDriveBox.klass, "setDefault", VALUEFUNC(_wrap_FXDriveBox_setDefault), -1);
    rb_define_method(cFXDriveBox.klass, "enable", VALUEFUNC(_wrap_FXDriveBox_enable), -1);
    rb_define_method(cFXDriveBox.klass, "disable", VALUEFUNC(_wrap_FXDriveBox_disable), -1);
    rb_define_method(cFXDriveBox.klass, "raiseWindow", VALUEFUNC(_wrap_FXDriveBox_raiseWindow), -1);
    rb_define_method(cFXDriveBox.klass, "lower", VALUEFUNC(_wrap_FXDriveBox_lower), -1);
    rb_define_method(cFXDriveBox.klass, "move", VALUEFUNC(_wrap_FXDriveBox_move), -1);
    rb_define_method(cFXDriveBox.klass, "position", VALUEFUNC(_wrap_FXDriveBox_position), -1);
    rb_define_method(cFXDriveBox.klass, "layout", VALUEFUNC(_wrap_FXDriveBox_layout), -1);
    rb_define_method(cFXDriveBox.klass, "recalc", VALUEFUNC(_wrap_FXDriveBox_recalc), -1);
    rb_define_method(cFXDriveBox.klass, "reparent", VALUEFUNC(_wrap_FXDriveBox_reparent), -1);
    rb_define_method(cFXDriveBox.klass, "show", VALUEFUNC(_wrap_FXDriveBox_show), -1);
    rb_define_method(cFXDriveBox.klass, "hide", VALUEFUNC(_wrap_FXDriveBox_hide), -1);
    rb_define_method(cFXDriveBox.klass, "isComposite", VALUEFUNC(_wrap_FXDriveBox_isComposite), -1);
    rb_define_method(cFXDriveBox.klass, "contains", VALUEFUNC(_wrap_FXDriveBox_contains), -1);
    rb_define_method(cFXDriveBox.klass, "doesSaveUnder", VALUEFUNC(_wrap_FXDriveBox_doesSaveUnder), -1);
    rb_define_method(cFXDriveBox.klass, "setBackColor", VALUEFUNC(_wrap_FXDriveBox_setBackColor), -1);
    cFXDriveBox.mark = (void (*)(void *)) FXRbDriveBox::markfunc;
    cFXDriveBox.destroy = (void (*)(void *)) FXRbObject::freefunc;
    
    cFXDirSelector.klass = rb_define_class_under(mFox, "FXDirSelector", ((swig_class *) SWIGTYPE_p_FXPacker->clientdata)->klass);
    SWIG_TypeClientData(SWIGTYPE_p_FXDirSelector, (void *) &cFXDirSelector);
    rb_define_alloc_func(cFXDirSelector.klass, _wrap_FXDirSelector_allocate);
    rb_define_method(cFXDirSelector.klass, "initialize", VALUEFUNC(_wrap_new_FXDirSelector), -1);
    rb_define_method(cFXDirSelector.klass, "onCmdName", VALUEFUNC(_wrap_FXDirSelector_onCmdName), -1);
    rb_define_method(cFXDirSelector.klass, "onCmdOpened", VALUEFUNC(_wrap_FXDirSelector_onCmdOpened), -1);
    rb_define_method(cFXDirSelector.klass, "onCmdHome", VALUEFUNC(_wrap_FXDirSelector_onCmdHome), -1);
    rb_define_method(cFXDirSelector.klass, "onCmdWork", VALUEFUNC(_wrap_FXDirSelector_onCmdWork), -1);
    rb_define_method(cFXDirSelector.klass, "onCmdDirectoryUp", VALUEFUNC(_wrap_FXDirSelector_onCmdDirectoryUp), -1);
    rb_define_const(cFXDirSelector.klass,"ID_DIRNAME", INT2NUM(FXDirSelector::ID_DIRNAME));
    rb_define_const(cFXDirSelector.klass,"ID_DIRLIST", INT2NUM(FXDirSelector::ID_DIRLIST));
    rb_define_const(cFXDirSelector.klass,"ID_HOME", INT2NUM(FXDirSelector::ID_HOME));
    rb_define_const(cFXDirSelector.klass,"ID_WORK", INT2NUM(FXDirSelector::ID_WORK));
    rb_define_const(cFXDirSelector.klass,"ID_DIRECTORY_UP", INT2NUM(FXDirSelector::ID_DIRECTORY_UP));
    rb_define_const(cFXDirSelector.klass,"ID_LAST", INT2NUM(FXDirSelector::ID_LAST));
    rb_define_method(cFXDirSelector.klass, "acceptButton", VALUEFUNC(_wrap_FXDirSelector_acceptButton), -1);
    rb_define_method(cFXDirSelector.klass, "cancelButton", VALUEFUNC(_wrap_FXDirSelector_cancelButton), -1);
    rb_define_method(cFXDirSelector.klass, "setDirectory", VALUEFUNC(_wrap_FXDirSelector_setDirectory), -1);
    rb_define_method(cFXDirSelector.klass, "getDirectory", VALUEFUNC(_wrap_FXDirSelector_getDirectory), -1);
    rb_define_method(cFXDirSelector.klass, "setDirBoxStyle", VALUEFUNC(_wrap_FXDirSelector_setDirBoxStyle), -1);
    rb_define_method(cFXDirSelector.klass, "getDirBoxStyle", VALUEFUNC(_wrap_FXDirSelector_getDirBoxStyle), -1);
    rb_define_method(cFXDirSelector.klass, "save", VALUEFUNC(_wrap_FXDirSelector_save), -1);
    rb_define_method(cFXDirSelector.klass, "load", VALUEFUNC(_wrap_FXDirSelector_load), -1);
    rb_define_method(cFXDirSelector.klass, "create", VALUEFUNC(_wrap_FXDirSelector_create), -1);
    rb_define_method(cFXDirSelector.klass, "detach", VALUEFUNC(_wrap_FXDirSelector_detach), -1);
    rb_define_method(cFXDirSelector.klass, "destroy", VALUEFUNC(_wrap_FXDirSelector_destroy), -1);
    rb_define_method(cFXDirSelector.klass, "resize", VALUEFUNC(_wrap_FXDirSelector_resize), -1);
    rb_define_method(cFXDirSelector.klass, "getDefaultWidth", VALUEFUNC(_wrap_FXDirSelector_getDefaultWidth), -1);
    rb_define_method(cFXDirSelector.klass, "getDefaultHeight", VALUEFUNC(_wrap_FXDirSelector_getDefaultHeight), -1);
    rb_define_method(cFXDirSelector.klass, "getWidthForHeight", VALUEFUNC(_wrap_FXDirSelector_getWidthForHeight), -1);
    rb_define_method(cFXDirSelector.klass, "getHeightForWidth", VALUEFUNC(_wrap_FXDirSelector_getHeightForWidth), -1);
    rb_define_method(cFXDirSelector.klass, "canFocus", VALUEFUNC(_wrap_FXDirSelector_canFocus), -1);
    rb_define_method(cFXDirSelector.klass, "setFocus", VALUEFUNC(_wrap_FXDirSelector_setFocus), -1);
    rb_define_method(cFXDirSelector.klass, "killFocus", VALUEFUNC(_wrap_FXDirSelector_killFocus), -1);
    rb_define_method(cFXDirSelector.klass, "setDefault", VALUEFUNC(_wrap_FXDirSelector_setDefault), -1);
    rb_define_method(cFXDirSelector.klass, "enable", VALUEFUNC(_wrap_FXDirSelector_enable), -1);
    rb_define_method(cFXDirSelector.klass, "disable", VALUEFUNC(_wrap_FXDirSelector_disable), -1);
    rb_define_method(cFXDirSelector.klass, "raiseWindow", VALUEFUNC(_wrap_FXDirSelector_raiseWindow), -1);
    rb_define_method(cFXDirSelector.klass, "lower", VALUEFUNC(_wrap_FXDirSelector_lower), -1);
    rb_define_method(cFXDirSelector.klass, "move", VALUEFUNC(_wrap_FXDirSelector_move), -1);
    rb_define_method(cFXDirSelector.klass, "position", VALUEFUNC(_wrap_FXDirSelector_position), -1);
    rb_define_method(cFXDirSelector.klass, "layout", VALUEFUNC(_wrap_FXDirSelector_layout), -1);
    rb_define_method(cFXDirSelector.klass, "recalc", VALUEFUNC(_wrap_FXDirSelector_recalc), -1);
    rb_define_method(cFXDirSelector.klass, "reparent", VALUEFUNC(_wrap_FXDirSelector_reparent), -1);
    rb_define_method(cFXDirSelector.klass, "show", VALUEFUNC(_wrap_FXDirSelector_show), -1);
    rb_define_method(cFXDirSelector.klass, "hide", VALUEFUNC(_wrap_FXDirSelector_hide), -1);
    rb_define_method(cFXDirSelector.klass, "isComposite", VALUEFUNC(_wrap_FXDirSelector_isComposite), -1);
    rb_define_method(cFXDirSelector.klass, "contains", VALUEFUNC(_wrap_FXDirSelector_contains), -1);
    rb_define_method(cFXDirSelector.klass, "doesSaveUnder", VALUEFUNC(_wrap_FXDirSelector_doesSaveUnder), -1);
    rb_define_method(cFXDirSelector.klass, "setBackColor", VALUEFUNC(_wrap_FXDirSelector_setBackColor), -1);
    cFXDirSelector.mark = (void (*)(void *)) FXRbDirSelector::markfunc;
    cFXDirSelector.destroy = (void (*)(void *)) FXRbObject::freefunc;
    rb_define_const(mFox,"SELECTFILE_ANY", INT2NUM(SELECTFILE_ANY));
    rb_define_const(mFox,"SELECTFILE_EXISTING", INT2NUM(SELECTFILE_EXISTING));
    rb_define_const(mFox,"SELECTFILE_MULTIPLE", INT2NUM(SELECTFILE_MULTIPLE));
    rb_define_const(mFox,"SELECTFILE_MULTIPLE_ALL", INT2NUM(SELECTFILE_MULTIPLE_ALL));
    rb_define_const(mFox,"SELECTFILE_DIRECTORY", INT2NUM(SELECTFILE_DIRECTORY));
    
    cFXFileSelector.klass = rb_define_class_under(mFox, "FXFileSelector", ((swig_class *) SWIGTYPE_p_FXPacker->clientdata)->klass);
    SWIG_TypeClientData(SWIGTYPE_p_FXFileSelector, (void *) &cFXFileSelector);
    rb_define_alloc_func(cFXFileSelector.klass, _wrap_FXFileSelector_allocate);
    rb_define_method(cFXFileSelector.klass, "initialize", VALUEFUNC(_wrap_new_FXFileSelector), -1);
    rb_define_method(cFXFileSelector.klass, "onCmdAccept", VALUEFUNC(_wrap_FXFileSelector_onCmdAccept), -1);
    rb_define_method(cFXFileSelector.klass, "onCmdFilter", VALUEFUNC(_wrap_FXFileSelector_onCmdFilter), -1);
    rb_define_method(cFXFileSelector.klass, "onCmdItemDblClicked", VALUEFUNC(_wrap_FXFileSelector_onCmdItemDblClicked), -1);
    rb_define_method(cFXFileSelector.klass, "onCmdItemSelected", VALUEFUNC(_wrap_FXFileSelector_onCmdItemSelected), -1);
    rb_define_method(cFXFileSelector.klass, "onCmdItemDeselected", VALUEFUNC(_wrap_FXFileSelector_onCmdItemDeselected), -1);
    rb_define_method(cFXFileSelector.klass, "onCmdDirectoryUp", VALUEFUNC(_wrap_FXFileSelector_onCmdDirectoryUp), -1);
    rb_define_method(cFXFileSelector.klass, "onUpdDirectoryUp", VALUEFUNC(_wrap_FXFileSelector_onUpdDirectoryUp), -1);
    rb_define_method(cFXFileSelector.klass, "onCmdDirTree", VALUEFUNC(_wrap_FXFileSelector_onCmdDirTree), -1);
    rb_define_method(cFXFileSelector.klass, "onCmdHome", VALUEFUNC(_wrap_FXFileSelector_onCmdHome), -1);
    rb_define_method(cFXFileSelector.klass, "onCmdWork", VALUEFUNC(_wrap_FXFileSelector_onCmdWork), -1);
    rb_define_method(cFXFileSelector.klass, "onCmdBookmark", VALUEFUNC(_wrap_FXFileSelector_onCmdBookmark), -1);
    rb_define_method(cFXFileSelector.klass, "onCmdVisit", VALUEFUNC(_wrap_FXFileSelector_onCmdVisit), -1);
    rb_define_method(cFXFileSelector.klass, "onCmdNew", VALUEFUNC(_wrap_FXFileSelector_onCmdNew), -1);
    rb_define_method(cFXFileSelector.klass, "onUpdNew", VALUEFUNC(_wrap_FXFileSelector_onUpdNew), -1);
    rb_define_method(cFXFileSelector.klass, "onCmdMove", VALUEFUNC(_wrap_FXFileSelector_onCmdMove), -1);
    rb_define_method(cFXFileSelector.klass, "onCmdCopy", VALUEFUNC(_wrap_FXFileSelector_onCmdCopy), -1);
    rb_define_method(cFXFileSelector.klass, "onCmdLink", VALUEFUNC(_wrap_FXFileSelector_onCmdLink), -1);
    rb_define_method(cFXFileSelector.klass, "onCmdDelete", VALUEFUNC(_wrap_FXFileSelector_onCmdDelete), -1);
    rb_define_method(cFXFileSelector.klass, "onUpdSelected", VALUEFUNC(_wrap_FXFileSelector_onUpdSelected), -1);
    rb_define_method(cFXFileSelector.klass, "onPopupMenu", VALUEFUNC(_wrap_FXFileSelector_onPopupMenu), -1);
    rb_define_const(cFXFileSelector.klass,"ID_FILEFILTER", INT2NUM(FXFileSelector::ID_FILEFILTER));
    rb_define_const(cFXFileSelector.klass,"ID_ACCEPT", INT2NUM(FXFileSelector::ID_ACCEPT));
    rb_define_const(cFXFileSelector.klass,"ID_FILELIST", INT2NUM(FXFileSelector::ID_FILELIST));
    rb_define_const(cFXFileSelector.klass,"ID_DIRECTORY_UP", INT2NUM(FXFileSelector::ID_DIRECTORY_UP));
    rb_define_const(cFXFileSelector.klass,"ID_DIRTREE", INT2NUM(FXFileSelector::ID_DIRTREE));
    rb_define_const(cFXFileSelector.klass,"ID_HOME", INT2NUM(FXFileSelector::ID_HOME));
    rb_define_const(cFXFileSelector.klass,"ID_WORK", INT2NUM(FXFileSelector::ID_WORK));
    rb_define_const(cFXFileSelector.klass,"ID_BOOKMARK", INT2NUM(FXFileSelector::ID_BOOKMARK));
    rb_define_const(cFXFileSelector.klass,"ID_VISIT", INT2NUM(FXFileSelector::ID_VISIT));
    rb_define_const(cFXFileSelector.klass,"ID_NEW", INT2NUM(FXFileSelector::ID_NEW));
    rb_define_const(cFXFileSelector.klass,"ID_DELETE", INT2NUM(FXFileSelector::ID_DELETE));
    rb_define_const(cFXFileSelector.klass,"ID_MOVE", INT2NUM(FXFileSelector::ID_MOVE));
    rb_define_const(cFXFileSelector.klass,"ID_COPY", INT2NUM(FXFileSelector::ID_COPY));
    rb_define_const(cFXFileSelector.klass,"ID_LINK", INT2NUM(FXFileSelector::ID_LINK));
    rb_define_const(cFXFileSelector.klass,"ID_LAST", INT2NUM(FXFileSelector::ID_LAST));
    rb_define_method(cFXFileSelector.klass, "acceptButton", VALUEFUNC(_wrap_FXFileSelector_acceptButton), -1);
    rb_define_method(cFXFileSelector.klass, "cancelButton", VALUEFUNC(_wrap_FXFileSelector_cancelButton), -1);
    rb_define_method(cFXFileSelector.klass, "setFilename", VALUEFUNC(_wrap_FXFileSelector_setFilename), -1);
    rb_define_method(cFXFileSelector.klass, "getFilename", VALUEFUNC(_wrap_FXFileSelector_getFilename), -1);
    rb_define_method(cFXFileSelector.klass, "getFilenames", VALUEFUNC(_wrap_FXFileSelector_getFilenames), -1);
    rb_define_method(cFXFileSelector.klass, "setPattern", VALUEFUNC(_wrap_FXFileSelector_setPattern), -1);
    rb_define_method(cFXFileSelector.klass, "getPattern", VALUEFUNC(_wrap_FXFileSelector_getPattern), -1);
    rb_define_method(cFXFileSelector.klass, "setPatternList", VALUEFUNC(_wrap_FXFileSelector_setPatternList), -1);
    rb_define_method(cFXFileSelector.klass, "getPatternList", VALUEFUNC(_wrap_FXFileSelector_getPatternList), -1);
    rb_define_method(cFXFileSelector.klass, "setCurrentPattern", VALUEFUNC(_wrap_FXFileSelector_setCurrentPattern), -1);
    rb_define_method(cFXFileSelector.klass, "getCurrentPattern", VALUEFUNC(_wrap_FXFileSelector_getCurrentPattern), -1);
    rb_define_method(cFXFileSelector.klass, "getPatternText", VALUEFUNC(_wrap_FXFileSelector_getPatternText), -1);
    rb_define_method(cFXFileSelector.klass, "setPatternText", VALUEFUNC(_wrap_FXFileSelector_setPatternText), -1);
    rb_define_method(cFXFileSelector.klass, "setDirectory", VALUEFUNC(_wrap_FXFileSelector_setDirectory), -1);
    rb_define_method(cFXFileSelector.klass, "getDirectory", VALUEFUNC(_wrap_FXFileSelector_getDirectory), -1);
    rb_define_singleton_method(cFXFileSelector.klass, "patternFromText", VALUEFUNC(_wrap_FXFileSelector_patternFromText), -1);
    rb_define_singleton_method(cFXFileSelector.klass, "extensionFromPattern", VALUEFUNC(_wrap_FXFileSelector_extensionFromPattern), -1);
    rb_define_method(cFXFileSelector.klass, "setItemSpace", VALUEFUNC(_wrap_FXFileSelector_setItemSpace), -1);
    rb_define_method(cFXFileSelector.klass, "getItemSpace", VALUEFUNC(_wrap_FXFileSelector_getItemSpace), -1);
    rb_define_method(cFXFileSelector.klass, "setFileBoxStyle", VALUEFUNC(_wrap_FXFileSelector_setFileBoxStyle), -1);
    rb_define_method(cFXFileSelector.klass, "getFileBoxStyle", VALUEFUNC(_wrap_FXFileSelector_getFileBoxStyle), -1);
    rb_define_method(cFXFileSelector.klass, "setSelectMode", VALUEFUNC(_wrap_FXFileSelector_setSelectMode), -1);
    rb_define_method(cFXFileSelector.klass, "getSelectMode", VALUEFUNC(_wrap_FXFileSelector_getSelectMode), -1);
    rb_define_method(cFXFileSelector.klass, "setMatchMode", VALUEFUNC(_wrap_FXFileSelector_setMatchMode), -1);
    rb_define_method(cFXFileSelector.klass, "getMatchMode", VALUEFUNC(_wrap_FXFileSelector_getMatchMode), -1);
    rb_define_method(cFXFileSelector.klass, "setReadOnlyShown", VALUEFUNC(_wrap_FXFileSelector_setReadOnlyShown), -1);
    rb_define_method(cFXFileSelector.klass, "getReadOnlyShown", VALUEFUNC(_wrap_FXFileSelector_getReadOnlyShown), -1);
    rb_define_method(cFXFileSelector.klass, "setReadOnly", VALUEFUNC(_wrap_FXFileSelector_setReadOnly), -1);
    rb_define_method(cFXFileSelector.klass, "getReadOnly", VALUEFUNC(_wrap_FXFileSelector_getReadOnly), -1);
    rb_define_method(cFXFileSelector.klass, "save", VALUEFUNC(_wrap_FXFileSelector_save), -1);
    rb_define_method(cFXFileSelector.klass, "load", VALUEFUNC(_wrap_FXFileSelector_load), -1);
    rb_define_method(cFXFileSelector.klass, "create", VALUEFUNC(_wrap_FXFileSelector_create), -1);
    rb_define_method(cFXFileSelector.klass, "detach", VALUEFUNC(_wrap_FXFileSelector_detach), -1);
    rb_define_method(cFXFileSelector.klass, "destroy", VALUEFUNC(_wrap_FXFileSelector_destroy), -1);
    rb_define_method(cFXFileSelector.klass, "resize", VALUEFUNC(_wrap_FXFileSelector_resize), -1);
    rb_define_method(cFXFileSelector.klass, "getDefaultWidth", VALUEFUNC(_wrap_FXFileSelector_getDefaultWidth), -1);
    rb_define_method(cFXFileSelector.klass, "getDefaultHeight", VALUEFUNC(_wrap_FXFileSelector_getDefaultHeight), -1);
    rb_define_method(cFXFileSelector.klass, "getWidthForHeight", VALUEFUNC(_wrap_FXFileSelector_getWidthForHeight), -1);
    rb_define_method(cFXFileSelector.klass, "getHeightForWidth", VALUEFUNC(_wrap_FXFileSelector_getHeightForWidth), -1);
    rb_define_method(cFXFileSelector.klass, "canFocus", VALUEFUNC(_wrap_FXFileSelector_canFocus), -1);
    rb_define_method(cFXFileSelector.klass, "setFocus", VALUEFUNC(_wrap_FXFileSelector_setFocus), -1);
    rb_define_method(cFXFileSelector.klass, "killFocus", VALUEFUNC(_wrap_FXFileSelector_killFocus), -1);
    rb_define_method(cFXFileSelector.klass, "setDefault", VALUEFUNC(_wrap_FXFileSelector_setDefault), -1);
    rb_define_method(cFXFileSelector.klass, "enable", VALUEFUNC(_wrap_FXFileSelector_enable), -1);
    rb_define_method(cFXFileSelector.klass, "disable", VALUEFUNC(_wrap_FXFileSelector_disable), -1);
    rb_define_method(cFXFileSelector.klass, "raiseWindow", VALUEFUNC(_wrap_FXFileSelector_raiseWindow), -1);
    rb_define_method(cFXFileSelector.klass, "lower", VALUEFUNC(_wrap_FXFileSelector_lower), -1);
    rb_define_method(cFXFileSelector.klass, "move", VALUEFUNC(_wrap_FXFileSelector_move), -1);
    rb_define_method(cFXFileSelector.klass, "position", VALUEFUNC(_wrap_FXFileSelector_position), -1);
    rb_define_method(cFXFileSelector.klass, "layout", VALUEFUNC(_wrap_FXFileSelector_layout), -1);
    rb_define_method(cFXFileSelector.klass, "recalc", VALUEFUNC(_wrap_FXFileSelector_recalc), -1);
    rb_define_method(cFXFileSelector.klass, "reparent", VALUEFUNC(_wrap_FXFileSelector_reparent), -1);
    rb_define_method(cFXFileSelector.klass, "show", VALUEFUNC(_wrap_FXFileSelector_show), -1);
    rb_define_method(cFXFileSelector.klass, "hide", VALUEFUNC(_wrap_FXFileSelector_hide), -1);
    rb_define_method(cFXFileSelector.klass, "isComposite", VALUEFUNC(_wrap_FXFileSelector_isComposite), -1);
    rb_define_method(cFXFileSelector.klass, "contains", VALUEFUNC(_wrap_FXFileSelector_contains), -1);
    rb_define_method(cFXFileSelector.klass, "doesSaveUnder", VALUEFUNC(_wrap_FXFileSelector_doesSaveUnder), -1);
    rb_define_method(cFXFileSelector.klass, "setBackColor", VALUEFUNC(_wrap_FXFileSelector_setBackColor), -1);
    cFXFileSelector.mark = (void (*)(void *)) FXRbFileSelector::markfunc;
    cFXFileSelector.destroy = (void (*)(void *)) FXRbObject::freefunc;
    
    cFXColorSelector.klass = rb_define_class_under(mFox, "FXColorSelector", ((swig_class *) SWIGTYPE_p_FXPacker->clientdata)->klass);
    SWIG_TypeClientData(SWIGTYPE_p_FXColorSelector, (void *) &cFXColorSelector);
    rb_define_alloc_func(cFXColorSelector.klass, _wrap_FXColorSelector_allocate);
    rb_define_method(cFXColorSelector.klass, "initialize", VALUEFUNC(_wrap_new_FXColorSelector), -1);
    rb_define_method(cFXColorSelector.klass, "onCmdColor", VALUEFUNC(_wrap_FXColorSelector_onCmdColor), -1);
    rb_define_method(cFXColorSelector.klass, "onChgColor", VALUEFUNC(_wrap_FXColorSelector_onChgColor), -1);
    rb_define_method(cFXColorSelector.klass, "onCmdWell", VALUEFUNC(_wrap_FXColorSelector_onCmdWell), -1);
    rb_define_method(cFXColorSelector.klass, "onChgWell", VALUEFUNC(_wrap_FXColorSelector_onChgWell), -1);
    rb_define_method(cFXColorSelector.klass, "onCmdRGBSlider", VALUEFUNC(_wrap_FXColorSelector_onCmdRGBSlider), -1);
    rb_define_method(cFXColorSelector.klass, "onUpdRGBSlider", VALUEFUNC(_wrap_FXColorSelector_onUpdRGBSlider), -1);
    rb_define_method(cFXColorSelector.klass, "onCmdRGBText", VALUEFUNC(_wrap_FXColorSelector_onCmdRGBText), -1);
    rb_define_method(cFXColorSelector.klass, "onUpdRGBText", VALUEFUNC(_wrap_FXColorSelector_onUpdRGBText), -1);
    rb_define_method(cFXColorSelector.klass, "onCmdHSVSlider", VALUEFUNC(_wrap_FXColorSelector_onCmdHSVSlider), -1);
    rb_define_method(cFXColorSelector.klass, "onUpdHSVSlider", VALUEFUNC(_wrap_FXColorSelector_onUpdHSVSlider), -1);
    rb_define_method(cFXColorSelector.klass, "onCmdHSVText", VALUEFUNC(_wrap_FXColorSelector_onCmdHSVText), -1);
    rb_define_method(cFXColorSelector.klass, "onUpdHSVText", VALUEFUNC(_wrap_FXColorSelector_onUpdHSVText), -1);
    rb_define_method(cFXColorSelector.klass, "onCmdCMYSlider", VALUEFUNC(_wrap_FXColorSelector_onCmdCMYSlider), -1);
    rb_define_method(cFXColorSelector.klass, "onUpdCMYSlider", VALUEFUNC(_wrap_FXColorSelector_onUpdCMYSlider), -1);
    rb_define_method(cFXColorSelector.klass, "onCmdCMYText", VALUEFUNC(_wrap_FXColorSelector_onCmdCMYText), -1);
    rb_define_method(cFXColorSelector.klass, "onUpdCMYText", VALUEFUNC(_wrap_FXColorSelector_onUpdCMYText), -1);
    rb_define_method(cFXColorSelector.klass, "onCmdList", VALUEFUNC(_wrap_FXColorSelector_onCmdList), -1);
    rb_define_method(cFXColorSelector.klass, "onCmdCustomWell", VALUEFUNC(_wrap_FXColorSelector_onCmdCustomWell), -1);
    rb_define_method(cFXColorSelector.klass, "onChgCustomWell", VALUEFUNC(_wrap_FXColorSelector_onChgCustomWell), -1);
    rb_define_method(cFXColorSelector.klass, "onCmdSetValue", VALUEFUNC(_wrap_FXColorSelector_onCmdSetValue), -1);
    rb_define_method(cFXColorSelector.klass, "onCmdActivePane", VALUEFUNC(_wrap_FXColorSelector_onCmdActivePane), -1);
    rb_define_method(cFXColorSelector.klass, "onCmdAlphaSlider", VALUEFUNC(_wrap_FXColorSelector_onCmdAlphaSlider), -1);
    rb_define_method(cFXColorSelector.klass, "onUpdAlphaSlider", VALUEFUNC(_wrap_FXColorSelector_onUpdAlphaSlider), -1);
    rb_define_method(cFXColorSelector.klass, "onCmdAlphaText", VALUEFUNC(_wrap_FXColorSelector_onCmdAlphaText), -1);
    rb_define_method(cFXColorSelector.klass, "onUpdAlphaText", VALUEFUNC(_wrap_FXColorSelector_onUpdAlphaText), -1);
    rb_define_method(cFXColorSelector.klass, "onUpdAlphaLabel", VALUEFUNC(_wrap_FXColorSelector_onUpdAlphaLabel), -1);
    rb_define_method(cFXColorSelector.klass, "onCmdWheel", VALUEFUNC(_wrap_FXColorSelector_onCmdWheel), -1);
    rb_define_method(cFXColorSelector.klass, "onUpdWheel", VALUEFUNC(_wrap_FXColorSelector_onUpdWheel), -1);
    rb_define_method(cFXColorSelector.klass, "onCmdBar", VALUEFUNC(_wrap_FXColorSelector_onCmdBar), -1);
    rb_define_method(cFXColorSelector.klass, "onUpdBar", VALUEFUNC(_wrap_FXColorSelector_onUpdBar), -1);
    rb_define_method(cFXColorSelector.klass, "onCmdColorPick", VALUEFUNC(_wrap_FXColorSelector_onCmdColorPick), -1);
    rb_define_const(cFXColorSelector.klass,"ID_CUSTOM_FIRST", INT2NUM(FXColorSelector::ID_CUSTOM_FIRST));
    rb_define_const(cFXColorSelector.klass,"ID_CUSTOM_LAST", INT2NUM(FXColorSelector::ID_CUSTOM_LAST));
    rb_define_const(cFXColorSelector.klass,"ID_RGB_RED_SLIDER", INT2NUM(FXColorSelector::ID_RGB_RED_SLIDER));
    rb_define_const(cFXColorSelector.klass,"ID_RGB_GREEN_SLIDER", INT2NUM(FXColorSelector::ID_RGB_GREEN_SLIDER));
    rb_define_const(cFXColorSelector.klass,"ID_RGB_BLUE_SLIDER", INT2NUM(FXColorSelector::ID_RGB_BLUE_SLIDER));
    rb_define_const(cFXColorSelector.klass,"ID_RGB_RED_TEXT", INT2NUM(FXColorSelector::ID_RGB_RED_TEXT));
    rb_define_const(cFXColorSelector.klass,"ID_RGB_GREEN_TEXT", INT2NUM(FXColorSelector::ID_RGB_GREEN_TEXT));
    rb_define_const(cFXColorSelector.klass,"ID_RGB_BLUE_TEXT", INT2NUM(FXColorSelector::ID_RGB_BLUE_TEXT));
    rb_define_const(cFXColorSelector.klass,"ID_HSV_HUE_SLIDER", INT2NUM(FXColorSelector::ID_HSV_HUE_SLIDER));
    rb_define_const(cFXColorSelector.klass,"ID_HSV_SATURATION_SLIDER", INT2NUM(FXColorSelector::ID_HSV_SATURATION_SLIDER));
    rb_define_const(cFXColorSelector.klass,"ID_HSV_VALUE_SLIDER", INT2NUM(FXColorSelector::ID_HSV_VALUE_SLIDER));
    rb_define_const(cFXColorSelector.klass,"ID_HSV_HUE_TEXT", INT2NUM(FXColorSelector::ID_HSV_HUE_TEXT));
    rb_define_const(cFXColorSelector.klass,"ID_HSV_SATURATION_TEXT", INT2NUM(FXColorSelector::ID_HSV_SATURATION_TEXT));
    rb_define_const(cFXColorSelector.klass,"ID_HSV_VALUE_TEXT", INT2NUM(FXColorSelector::ID_HSV_VALUE_TEXT));
    rb_define_const(cFXColorSelector.klass,"ID_CMY_CYAN_SLIDER", INT2NUM(FXColorSelector::ID_CMY_CYAN_SLIDER));
    rb_define_const(cFXColorSelector.klass,"ID_CMY_MAGENTA_SLIDER", INT2NUM(FXColorSelector::ID_CMY_MAGENTA_SLIDER));
    rb_define_const(cFXColorSelector.klass,"ID_CMY_YELLOW_SLIDER", INT2NUM(FXColorSelector::ID_CMY_YELLOW_SLIDER));
    rb_define_const(cFXColorSelector.klass,"ID_CMY_CYAN_TEXT", INT2NUM(FXColorSelector::ID_CMY_CYAN_TEXT));
    rb_define_const(cFXColorSelector.klass,"ID_CMY_MAGENTA_TEXT", INT2NUM(FXColorSelector::ID_CMY_MAGENTA_TEXT));
    rb_define_const(cFXColorSelector.klass,"ID_CMY_YELLOW_TEXT", INT2NUM(FXColorSelector::ID_CMY_YELLOW_TEXT));
    rb_define_const(cFXColorSelector.klass,"ID_DIAL_WHEEL", INT2NUM(FXColorSelector::ID_DIAL_WHEEL));
    rb_define_const(cFXColorSelector.klass,"ID_COLOR_BAR", INT2NUM(FXColorSelector::ID_COLOR_BAR));
    rb_define_const(cFXColorSelector.klass,"ID_COLOR_LIST", INT2NUM(FXColorSelector::ID_COLOR_LIST));
    rb_define_const(cFXColorSelector.klass,"ID_WELL_CHANGED", INT2NUM(FXColorSelector::ID_WELL_CHANGED));
    rb_define_const(cFXColorSelector.klass,"ID_COLOR", INT2NUM(FXColorSelector::ID_COLOR));
    rb_define_const(cFXColorSelector.klass,"ID_ACTIVEPANE", INT2NUM(FXColorSelector::ID_ACTIVEPANE));
    rb_define_const(cFXColorSelector.klass,"ID_ALPHA_SLIDER", INT2NUM(FXColorSelector::ID_ALPHA_SLIDER));
    rb_define_const(cFXColorSelector.klass,"ID_ALPHA_TEXT", INT2NUM(FXColorSelector::ID_ALPHA_TEXT));
    rb_define_const(cFXColorSelector.klass,"ID_ALPHA_LABEL", INT2NUM(FXColorSelector::ID_ALPHA_LABEL));
    rb_define_const(cFXColorSelector.klass,"ID_COLORPICK", INT2NUM(FXColorSelector::ID_COLORPICK));
    rb_define_const(cFXColorSelector.klass,"ID_LAST", INT2NUM(FXColorSelector::ID_LAST));
    rb_define_method(cFXColorSelector.klass, "acceptButton", VALUEFUNC(_wrap_FXColorSelector_acceptButton), -1);
    rb_define_method(cFXColorSelector.klass, "cancelButton", VALUEFUNC(_wrap_FXColorSelector_cancelButton), -1);
    rb_define_method(cFXColorSelector.klass, "setRGBA", VALUEFUNC(_wrap_FXColorSelector_setRGBA), -1);
    rb_define_method(cFXColorSelector.klass, "getRGBA", VALUEFUNC(_wrap_FXColorSelector_getRGBA), -1);
    rb_define_method(cFXColorSelector.klass, "isOpaqueOnly", VALUEFUNC(_wrap_FXColorSelector_isOpaqueOnly), -1);
    rb_define_method(cFXColorSelector.klass, "setOpaqueOnly", VALUEFUNC(_wrap_FXColorSelector_setOpaqueOnly), -1);
    rb_define_method(cFXColorSelector.klass, "save", VALUEFUNC(_wrap_FXColorSelector_save), -1);
    rb_define_method(cFXColorSelector.klass, "load", VALUEFUNC(_wrap_FXColorSelector_load), -1);
    rb_define_method(cFXColorSelector.klass, "create", VALUEFUNC(_wrap_FXColorSelector_create), -1);
    rb_define_method(cFXColorSelector.klass, "detach", VALUEFUNC(_wrap_FXColorSelector_detach), -1);
    rb_define_method(cFXColorSelector.klass, "destroy", VALUEFUNC(_wrap_FXColorSelector_destroy), -1);
    rb_define_method(cFXColorSelector.klass, "resize", VALUEFUNC(_wrap_FXColorSelector_resize), -1);
    rb_define_method(cFXColorSelector.klass, "getDefaultWidth", VALUEFUNC(_wrap_FXColorSelector_getDefaultWidth), -1);
    rb_define_method(cFXColorSelector.klass, "getDefaultHeight", VALUEFUNC(_wrap_FXColorSelector_getDefaultHeight), -1);
    rb_define_method(cFXColorSelector.klass, "getWidthForHeight", VALUEFUNC(_wrap_FXColorSelector_getWidthForHeight), -1);
    rb_define_method(cFXColorSelector.klass, "getHeightForWidth", VALUEFUNC(_wrap_FXColorSelector_getHeightForWidth), -1);
    rb_define_method(cFXColorSelector.klass, "canFocus", VALUEFUNC(_wrap_FXColorSelector_canFocus), -1);
    rb_define_method(cFXColorSelector.klass, "setFocus", VALUEFUNC(_wrap_FXColorSelector_setFocus), -1);
    rb_define_method(cFXColorSelector.klass, "killFocus", VALUEFUNC(_wrap_FXColorSelector_killFocus), -1);
    rb_define_method(cFXColorSelector.klass, "setDefault", VALUEFUNC(_wrap_FXColorSelector_setDefault), -1);
    rb_define_method(cFXColorSelector.klass, "enable", VALUEFUNC(_wrap_FXColorSelector_enable), -1);
    rb_define_method(cFXColorSelector.klass, "disable", VALUEFUNC(_wrap_FXColorSelector_disable), -1);
    rb_define_method(cFXColorSelector.klass, "raiseWindow", VALUEFUNC(_wrap_FXColorSelector_raiseWindow), -1);
    rb_define_method(cFXColorSelector.klass, "lower", VALUEFUNC(_wrap_FXColorSelector_lower), -1);
    rb_define_method(cFXColorSelector.klass, "move", VALUEFUNC(_wrap_FXColorSelector_move), -1);
    rb_define_method(cFXColorSelector.klass, "position", VALUEFUNC(_wrap_FXColorSelector_position), -1);
    rb_define_method(cFXColorSelector.klass, "layout", VALUEFUNC(_wrap_FXColorSelector_layout), -1);
    rb_define_method(cFXColorSelector.klass, "recalc", VALUEFUNC(_wrap_FXColorSelector_recalc), -1);
    rb_define_method(cFXColorSelector.klass, "reparent", VALUEFUNC(_wrap_FXColorSelector_reparent), -1);
    rb_define_method(cFXColorSelector.klass, "show", VALUEFUNC(_wrap_FXColorSelector_show), -1);
    rb_define_method(cFXColorSelector.klass, "hide", VALUEFUNC(_wrap_FXColorSelector_hide), -1);
    rb_define_method(cFXColorSelector.klass, "isComposite", VALUEFUNC(_wrap_FXColorSelector_isComposite), -1);
    rb_define_method(cFXColorSelector.klass, "contains", VALUEFUNC(_wrap_FXColorSelector_contains), -1);
    rb_define_method(cFXColorSelector.klass, "doesSaveUnder", VALUEFUNC(_wrap_FXColorSelector_doesSaveUnder), -1);
    rb_define_method(cFXColorSelector.klass, "setBackColor", VALUEFUNC(_wrap_FXColorSelector_setBackColor), -1);
    cFXColorSelector.mark = (void (*)(void *)) FXRbColorSelector::markfunc;
    cFXColorSelector.destroy = (void (*)(void *)) FXRbObject::freefunc;
    
    cFXFontSelector.klass = rb_define_class_under(mFox, "FXFontSelector", ((swig_class *) SWIGTYPE_p_FXPacker->clientdata)->klass);
    SWIG_TypeClientData(SWIGTYPE_p_FXFontSelector, (void *) &cFXFontSelector);
    rb_define_alloc_func(cFXFontSelector.klass, _wrap_FXFontSelector_allocate);
    rb_define_method(cFXFontSelector.klass, "initialize", VALUEFUNC(_wrap_new_FXFontSelector), -1);
    rb_define_method(cFXFontSelector.klass, "onCmdFamily", VALUEFUNC(_wrap_FXFontSelector_onCmdFamily), -1);
    rb_define_method(cFXFontSelector.klass, "onCmdWeight", VALUEFUNC(_wrap_FXFontSelector_onCmdWeight), -1);
    rb_define_method(cFXFontSelector.klass, "onCmdStyle", VALUEFUNC(_wrap_FXFontSelector_onCmdStyle), -1);
    rb_define_method(cFXFontSelector.klass, "onCmdStyleText", VALUEFUNC(_wrap_FXFontSelector_onCmdStyleText), -1);
    rb_define_method(cFXFontSelector.klass, "onCmdSize", VALUEFUNC(_wrap_FXFontSelector_onCmdSize), -1);
    rb_define_method(cFXFontSelector.klass, "onCmdSizeText", VALUEFUNC(_wrap_FXFontSelector_onCmdSizeText), -1);
    rb_define_method(cFXFontSelector.klass, "onCmdCharset", VALUEFUNC(_wrap_FXFontSelector_onCmdCharset), -1);
    rb_define_method(cFXFontSelector.klass, "onUpdCharset", VALUEFUNC(_wrap_FXFontSelector_onUpdCharset), -1);
    rb_define_method(cFXFontSelector.klass, "onCmdSetWidth", VALUEFUNC(_wrap_FXFontSelector_onCmdSetWidth), -1);
    rb_define_method(cFXFontSelector.klass, "onUpdSetWidth", VALUEFUNC(_wrap_FXFontSelector_onUpdSetWidth), -1);
    rb_define_method(cFXFontSelector.klass, "onCmdPitch", VALUEFUNC(_wrap_FXFontSelector_onCmdPitch), -1);
    rb_define_method(cFXFontSelector.klass, "onUpdPitch", VALUEFUNC(_wrap_FXFontSelector_onUpdPitch), -1);
    rb_define_method(cFXFontSelector.klass, "onCmdScalable", VALUEFUNC(_wrap_FXFontSelector_onCmdScalable), -1);
    rb_define_method(cFXFontSelector.klass, "onUpdScalable", VALUEFUNC(_wrap_FXFontSelector_onUpdScalable), -1);
    rb_define_method(cFXFontSelector.klass, "onCmdAllFonts", VALUEFUNC(_wrap_FXFontSelector_onCmdAllFonts), -1);
    rb_define_method(cFXFontSelector.klass, "onUpdAllFonts", VALUEFUNC(_wrap_FXFontSelector_onUpdAllFonts), -1);
    rb_define_const(cFXFontSelector.klass,"ID_FAMILY", INT2NUM(FXFontSelector::ID_FAMILY));
    rb_define_const(cFXFontSelector.klass,"ID_WEIGHT", INT2NUM(FXFontSelector::ID_WEIGHT));
    rb_define_const(cFXFontSelector.klass,"ID_STYLE", INT2NUM(FXFontSelector::ID_STYLE));
    rb_define_const(cFXFontSelector.klass,"ID_STYLE_TEXT", INT2NUM(FXFontSelector::ID_STYLE_TEXT));
    rb_define_const(cFXFontSelector.klass,"ID_SIZE", INT2NUM(FXFontSelector::ID_SIZE));
    rb_define_const(cFXFontSelector.klass,"ID_SIZE_TEXT", INT2NUM(FXFontSelector::ID_SIZE_TEXT));
    rb_define_const(cFXFontSelector.klass,"ID_CHARSET", INT2NUM(FXFontSelector::ID_CHARSET));
    rb_define_const(cFXFontSelector.klass,"ID_SETWIDTH", INT2NUM(FXFontSelector::ID_SETWIDTH));
    rb_define_const(cFXFontSelector.klass,"ID_PITCH", INT2NUM(FXFontSelector::ID_PITCH));
    rb_define_const(cFXFontSelector.klass,"ID_SCALABLE", INT2NUM(FXFontSelector::ID_SCALABLE));
    rb_define_const(cFXFontSelector.klass,"ID_ALLFONTS", INT2NUM(FXFontSelector::ID_ALLFONTS));
    rb_define_const(cFXFontSelector.klass,"ID_LAST", INT2NUM(FXFontSelector::ID_LAST));
    rb_define_method(cFXFontSelector.klass, "acceptButton", VALUEFUNC(_wrap_FXFontSelector_acceptButton), -1);
    rb_define_method(cFXFontSelector.klass, "cancelButton", VALUEFUNC(_wrap_FXFontSelector_cancelButton), -1);
    rb_define_method(cFXFontSelector.klass, "setFontSelection", VALUEFUNC(_wrap_FXFontSelector_setFontSelection), -1);
    rb_define_method(cFXFontSelector.klass, "getFontSelection", VALUEFUNC(_wrap_FXFontSelector_getFontSelection), -1);
    rb_define_method(cFXFontSelector.klass, "save", VALUEFUNC(_wrap_FXFontSelector_save), -1);
    rb_define_method(cFXFontSelector.klass, "load", VALUEFUNC(_wrap_FXFontSelector_load), -1);
    rb_define_method(cFXFontSelector.klass, "create", VALUEFUNC(_wrap_FXFontSelector_create), -1);
    rb_define_method(cFXFontSelector.klass, "detach", VALUEFUNC(_wrap_FXFontSelector_detach), -1);
    rb_define_method(cFXFontSelector.klass, "destroy", VALUEFUNC(_wrap_FXFontSelector_destroy), -1);
    rb_define_method(cFXFontSelector.klass, "resize", VALUEFUNC(_wrap_FXFontSelector_resize), -1);
    rb_define_method(cFXFontSelector.klass, "getDefaultWidth", VALUEFUNC(_wrap_FXFontSelector_getDefaultWidth), -1);
    rb_define_method(cFXFontSelector.klass, "getDefaultHeight", VALUEFUNC(_wrap_FXFontSelector_getDefaultHeight), -1);
    rb_define_method(cFXFontSelector.klass, "getWidthForHeight", VALUEFUNC(_wrap_FXFontSelector_getWidthForHeight), -1);
    rb_define_method(cFXFontSelector.klass, "getHeightForWidth", VALUEFUNC(_wrap_FXFontSelector_getHeightForWidth), -1);
    rb_define_method(cFXFontSelector.klass, "canFocus", VALUEFUNC(_wrap_FXFontSelector_canFocus), -1);
    rb_define_method(cFXFontSelector.klass, "setFocus", VALUEFUNC(_wrap_FXFontSelector_setFocus), -1);
    rb_define_method(cFXFontSelector.klass, "killFocus", VALUEFUNC(_wrap_FXFontSelector_killFocus), -1);
    rb_define_method(cFXFontSelector.klass, "setDefault", VALUEFUNC(_wrap_FXFontSelector_setDefault), -1);
    rb_define_method(cFXFontSelector.klass, "enable", VALUEFUNC(_wrap_FXFontSelector_enable), -1);
    rb_define_method(cFXFontSelector.klass, "disable", VALUEFUNC(_wrap_FXFontSelector_disable), -1);
    rb_define_method(cFXFontSelector.klass, "raiseWindow", VALUEFUNC(_wrap_FXFontSelector_raiseWindow), -1);
    rb_define_method(cFXFontSelector.klass, "lower", VALUEFUNC(_wrap_FXFontSelector_lower), -1);
    rb_define_method(cFXFontSelector.klass, "move", VALUEFUNC(_wrap_FXFontSelector_move), -1);
    rb_define_method(cFXFontSelector.klass, "position", VALUEFUNC(_wrap_FXFontSelector_position), -1);
    rb_define_method(cFXFontSelector.klass, "layout", VALUEFUNC(_wrap_FXFontSelector_layout), -1);
    rb_define_method(cFXFontSelector.klass, "recalc", VALUEFUNC(_wrap_FXFontSelector_recalc), -1);
    rb_define_method(cFXFontSelector.klass, "reparent", VALUEFUNC(_wrap_FXFontSelector_reparent), -1);
    rb_define_method(cFXFontSelector.klass, "show", VALUEFUNC(_wrap_FXFontSelector_show), -1);
    rb_define_method(cFXFontSelector.klass, "hide", VALUEFUNC(_wrap_FXFontSelector_hide), -1);
    rb_define_method(cFXFontSelector.klass, "isComposite", VALUEFUNC(_wrap_FXFontSelector_isComposite), -1);
    rb_define_method(cFXFontSelector.klass, "contains", VALUEFUNC(_wrap_FXFontSelector_contains), -1);
    rb_define_method(cFXFontSelector.klass, "doesSaveUnder", VALUEFUNC(_wrap_FXFontSelector_doesSaveUnder), -1);
    rb_define_method(cFXFontSelector.klass, "setBackColor", VALUEFUNC(_wrap_FXFontSelector_setBackColor), -1);
    cFXFontSelector.mark = (void (*)(void *)) FXRbFontSelector::markfunc;
    cFXFontSelector.destroy = (void (*)(void *)) FXRbObject::freefunc;
    rb_define_const(mFox,"TOOLBARGRIP_SINGLE", INT2NUM(TOOLBARGRIP_SINGLE));
    rb_define_const(mFox,"TOOLBARGRIP_DOUBLE", INT2NUM(TOOLBARGRIP_DOUBLE));
    rb_define_const(mFox,"TOOLBARGRIP_SEPARATOR", INT2NUM(TOOLBARGRIP_SEPARATOR));
    
    cFXToolBarGrip.klass = rb_define_class_under(mFox, "FXToolBarGrip", ((swig_class *) SWIGTYPE_p_FXWindow->clientdata)->klass);
    SWIG_TypeClientData(SWIGTYPE_p_FXToolBarGrip, (void *) &cFXToolBarGrip);
    rb_define_alloc_func(cFXToolBarGrip.klass, _wrap_FXToolBarGrip_allocate);
    rb_define_method(cFXToolBarGrip.klass, "initialize", VALUEFUNC(_wrap_new_FXToolBarGrip), -1);
    rb_define_method(cFXToolBarGrip.klass, "onPaint", VALUEFUNC(_wrap_FXToolBarGrip_onPaint), -1);
    rb_define_method(cFXToolBarGrip.klass, "onLeftBtnPress", VALUEFUNC(_wrap_FXToolBarGrip_onLeftBtnPress), -1);
    rb_define_method(cFXToolBarGrip.klass, "onLeftBtnRelease", VALUEFUNC(_wrap_FXToolBarGrip_onLeftBtnRelease), -1);
    rb_define_method(cFXToolBarGrip.klass, "onMotion", VALUEFUNC(_wrap_FXToolBarGrip_onMotion), -1);
    rb_define_method(cFXToolBarGrip.klass, "onEnter", VALUEFUNC(_wrap_FXToolBarGrip_onEnter), -1);
    rb_define_method(cFXToolBarGrip.klass, "onLeave", VALUEFUNC(_wrap_FXToolBarGrip_onLeave), -1);
    rb_define_method(cFXToolBarGrip.klass, "setDoubleBar", VALUEFUNC(_wrap_FXToolBarGrip_setDoubleBar), -1);
    rb_define_method(cFXToolBarGrip.klass, "isDoubleBar", VALUEFUNC(_wrap_FXToolBarGrip_isDoubleBar), -1);
    rb_define_method(cFXToolBarGrip.klass, "setHiliteColor", VALUEFUNC(_wrap_FXToolBarGrip_setHiliteColor), -1);
    rb_define_method(cFXToolBarGrip.klass, "getHiliteColor", VALUEFUNC(_wrap_FXToolBarGrip_getHiliteColor), -1);
    rb_define_method(cFXToolBarGrip.klass, "setShadowColor", VALUEFUNC(_wrap_FXToolBarGrip_setShadowColor), -1);
    rb_define_method(cFXToolBarGrip.klass, "getShadowColor", VALUEFUNC(_wrap_FXToolBarGrip_getShadowColor), -1);
    rb_define_method(cFXToolBarGrip.klass, "setActiveColor", VALUEFUNC(_wrap_FXToolBarGrip_setActiveColor), -1);
    rb_define_method(cFXToolBarGrip.klass, "getActiveColor", VALUEFUNC(_wrap_FXToolBarGrip_getActiveColor), -1);
    rb_define_method(cFXToolBarGrip.klass, "save", VALUEFUNC(_wrap_FXToolBarGrip_save), -1);
    rb_define_method(cFXToolBarGrip.klass, "load", VALUEFUNC(_wrap_FXToolBarGrip_load), -1);
    rb_define_method(cFXToolBarGrip.klass, "create", VALUEFUNC(_wrap_FXToolBarGrip_create), -1);
    rb_define_method(cFXToolBarGrip.klass, "detach", VALUEFUNC(_wrap_FXToolBarGrip_detach), -1);
    rb_define_method(cFXToolBarGrip.klass, "destroy", VALUEFUNC(_wrap_FXToolBarGrip_destroy), -1);
    rb_define_method(cFXToolBarGrip.klass, "resize", VALUEFUNC(_wrap_FXToolBarGrip_resize), -1);
    rb_define_method(cFXToolBarGrip.klass, "getDefaultWidth", VALUEFUNC(_wrap_FXToolBarGrip_getDefaultWidth), -1);
    rb_define_method(cFXToolBarGrip.klass, "getDefaultHeight", VALUEFUNC(_wrap_FXToolBarGrip_getDefaultHeight), -1);
    rb_define_method(cFXToolBarGrip.klass, "getWidthForHeight", VALUEFUNC(_wrap_FXToolBarGrip_getWidthForHeight), -1);
    rb_define_method(cFXToolBarGrip.klass, "getHeightForWidth", VALUEFUNC(_wrap_FXToolBarGrip_getHeightForWidth), -1);
    rb_define_method(cFXToolBarGrip.klass, "canFocus", VALUEFUNC(_wrap_FXToolBarGrip_canFocus), -1);
    rb_define_method(cFXToolBarGrip.klass, "setFocus", VALUEFUNC(_wrap_FXToolBarGrip_setFocus), -1);
    rb_define_method(cFXToolBarGrip.klass, "killFocus", VALUEFUNC(_wrap_FXToolBarGrip_killFocus), -1);
    rb_define_method(cFXToolBarGrip.klass, "setDefault", VALUEFUNC(_wrap_FXToolBarGrip_setDefault), -1);
    rb_define_method(cFXToolBarGrip.klass, "enable", VALUEFUNC(_wrap_FXToolBarGrip_enable), -1);
    rb_define_method(cFXToolBarGrip.klass, "disable", VALUEFUNC(_wrap_FXToolBarGrip_disable), -1);
    rb_define_method(cFXToolBarGrip.klass, "raiseWindow", VALUEFUNC(_wrap_FXToolBarGrip_raiseWindow), -1);
    rb_define_method(cFXToolBarGrip.klass, "lower", VALUEFUNC(_wrap_FXToolBarGrip_lower), -1);
    rb_define_method(cFXToolBarGrip.klass, "move", VALUEFUNC(_wrap_FXToolBarGrip_move), -1);
    rb_define_method(cFXToolBarGrip.klass, "position", VALUEFUNC(_wrap_FXToolBarGrip_position), -1);
    rb_define_method(cFXToolBarGrip.klass, "layout", VALUEFUNC(_wrap_FXToolBarGrip_layout), -1);
    rb_define_method(cFXToolBarGrip.klass, "recalc", VALUEFUNC(_wrap_FXToolBarGrip_recalc), -1);
    rb_define_method(cFXToolBarGrip.klass, "reparent", VALUEFUNC(_wrap_FXToolBarGrip_reparent), -1);
    rb_define_method(cFXToolBarGrip.klass, "show", VALUEFUNC(_wrap_FXToolBarGrip_show), -1);
    rb_define_method(cFXToolBarGrip.klass, "hide", VALUEFUNC(_wrap_FXToolBarGrip_hide), -1);
    rb_define_method(cFXToolBarGrip.klass, "isComposite", VALUEFUNC(_wrap_FXToolBarGrip_isComposite), -1);
    rb_define_method(cFXToolBarGrip.klass, "contains", VALUEFUNC(_wrap_FXToolBarGrip_contains), -1);
    rb_define_method(cFXToolBarGrip.klass, "doesSaveUnder", VALUEFUNC(_wrap_FXToolBarGrip_doesSaveUnder), -1);
    rb_define_method(cFXToolBarGrip.klass, "setBackColor", VALUEFUNC(_wrap_FXToolBarGrip_setBackColor), -1);
    cFXToolBarGrip.mark = (void (*)(void *)) FXRbToolBarGrip::markfunc;
    cFXToolBarGrip.destroy = (void (*)(void *)) FXRbObject::freefunc;
    
    cFXToolBarShell.klass = rb_define_class_under(mFox, "FXToolBarShell", ((swig_class *) SWIGTYPE_p_FXTopWindow->clientdata)->klass);
    SWIG_TypeClientData(SWIGTYPE_p_FXToolBarShell, (void *) &cFXToolBarShell);
    rb_define_alloc_func(cFXToolBarShell.klass, _wrap_FXToolBarShell_allocate);
    rb_define_method(cFXToolBarShell.klass, "initialize", VALUEFUNC(_wrap_new_FXToolBarShell), -1);
    rb_define_method(cFXToolBarShell.klass, "onPaint", VALUEFUNC(_wrap_FXToolBarShell_onPaint), -1);
    rb_define_method(cFXToolBarShell.klass, "setFrameStyle", VALUEFUNC(_wrap_FXToolBarShell_setFrameStyle), -1);
    rb_define_method(cFXToolBarShell.klass, "getFrameStyle", VALUEFUNC(_wrap_FXToolBarShell_getFrameStyle), -1);
    rb_define_method(cFXToolBarShell.klass, "getBorderWidth", VALUEFUNC(_wrap_FXToolBarShell_getBorderWidth), -1);
    rb_define_method(cFXToolBarShell.klass, "setHiliteColor", VALUEFUNC(_wrap_FXToolBarShell_setHiliteColor), -1);
    rb_define_method(cFXToolBarShell.klass, "getHiliteColor", VALUEFUNC(_wrap_FXToolBarShell_getHiliteColor), -1);
    rb_define_method(cFXToolBarShell.klass, "setShadowColor", VALUEFUNC(_wrap_FXToolBarShell_setShadowColor), -1);
    rb_define_method(cFXToolBarShell.klass, "getShadowColor", VALUEFUNC(_wrap_FXToolBarShell_getShadowColor), -1);
    rb_define_method(cFXToolBarShell.klass, "setBorderColor", VALUEFUNC(_wrap_FXToolBarShell_setBorderColor), -1);
    rb_define_method(cFXToolBarShell.klass, "getBorderColor", VALUEFUNC(_wrap_FXToolBarShell_getBorderColor), -1);
    rb_define_method(cFXToolBarShell.klass, "setBaseColor", VALUEFUNC(_wrap_FXToolBarShell_setBaseColor), -1);
    rb_define_method(cFXToolBarShell.klass, "getBaseColor", VALUEFUNC(_wrap_FXToolBarShell_getBaseColor), -1);
    rb_define_method(cFXToolBarShell.klass, "save", VALUEFUNC(_wrap_FXToolBarShell_save), -1);
    rb_define_method(cFXToolBarShell.klass, "load", VALUEFUNC(_wrap_FXToolBarShell_load), -1);
    rb_define_method(cFXToolBarShell.klass, "create", VALUEFUNC(_wrap_FXToolBarShell_create), -1);
    rb_define_method(cFXToolBarShell.klass, "detach", VALUEFUNC(_wrap_FXToolBarShell_detach), -1);
    rb_define_method(cFXToolBarShell.klass, "destroy", VALUEFUNC(_wrap_FXToolBarShell_destroy), -1);
    rb_define_method(cFXToolBarShell.klass, "resize", VALUEFUNC(_wrap_FXToolBarShell_resize), -1);
    rb_define_method(cFXToolBarShell.klass, "getDefaultWidth", VALUEFUNC(_wrap_FXToolBarShell_getDefaultWidth), -1);
    rb_define_method(cFXToolBarShell.klass, "getDefaultHeight", VALUEFUNC(_wrap_FXToolBarShell_getDefaultHeight), -1);
    rb_define_method(cFXToolBarShell.klass, "getWidthForHeight", VALUEFUNC(_wrap_FXToolBarShell_getWidthForHeight), -1);
    rb_define_method(cFXToolBarShell.klass, "getHeightForWidth", VALUEFUNC(_wrap_FXToolBarShell_getHeightForWidth), -1);
    rb_define_method(cFXToolBarShell.klass, "canFocus", VALUEFUNC(_wrap_FXToolBarShell_canFocus), -1);
    rb_define_method(cFXToolBarShell.klass, "setFocus", VALUEFUNC(_wrap_FXToolBarShell_setFocus), -1);
    rb_define_method(cFXToolBarShell.klass, "killFocus", VALUEFUNC(_wrap_FXToolBarShell_killFocus), -1);
    rb_define_method(cFXToolBarShell.klass, "setDefault", VALUEFUNC(_wrap_FXToolBarShell_setDefault), -1);
    rb_define_method(cFXToolBarShell.klass, "enable", VALUEFUNC(_wrap_FXToolBarShell_enable), -1);
    rb_define_method(cFXToolBarShell.klass, "disable", VALUEFUNC(_wrap_FXToolBarShell_disable), -1);
    rb_define_method(cFXToolBarShell.klass, "raiseWindow", VALUEFUNC(_wrap_FXToolBarShell_raiseWindow), -1);
    rb_define_method(cFXToolBarShell.klass, "lower", VALUEFUNC(_wrap_FXToolBarShell_lower), -1);
    rb_define_method(cFXToolBarShell.klass, "move", VALUEFUNC(_wrap_FXToolBarShell_move), -1);
    rb_define_method(cFXToolBarShell.klass, "position", VALUEFUNC(_wrap_FXToolBarShell_position), -1);
    rb_define_method(cFXToolBarShell.klass, "layout", VALUEFUNC(_wrap_FXToolBarShell_layout), -1);
    rb_define_method(cFXToolBarShell.klass, "recalc", VALUEFUNC(_wrap_FXToolBarShell_recalc), -1);
    rb_define_method(cFXToolBarShell.klass, "reparent", VALUEFUNC(_wrap_FXToolBarShell_reparent), -1);
    rb_define_method(cFXToolBarShell.klass, "hide", VALUEFUNC(_wrap_FXToolBarShell_hide), -1);
    rb_define_method(cFXToolBarShell.klass, "isComposite", VALUEFUNC(_wrap_FXToolBarShell_isComposite), -1);
    rb_define_method(cFXToolBarShell.klass, "contains", VALUEFUNC(_wrap_FXToolBarShell_contains), -1);
    rb_define_method(cFXToolBarShell.klass, "doesSaveUnder", VALUEFUNC(_wrap_FXToolBarShell_doesSaveUnder), -1);
    rb_define_method(cFXToolBarShell.klass, "setBackColor", VALUEFUNC(_wrap_FXToolBarShell_setBackColor), -1);
    rb_define_method(cFXToolBarShell.klass, "show", VALUEFUNC(_wrap_FXToolBarShell_show), -1);
    rb_define_method(cFXToolBarShell.klass, "maximize", VALUEFUNC(_wrap_FXToolBarShell_maximize), -1);
    rb_define_method(cFXToolBarShell.klass, "minimize", VALUEFUNC(_wrap_FXToolBarShell_minimize), -1);
    rb_define_method(cFXToolBarShell.klass, "restore", VALUEFUNC(_wrap_FXToolBarShell_restore), -1);
    rb_define_method(cFXToolBarShell.klass, "close", VALUEFUNC(_wrap_FXToolBarShell_close), -1);
    cFXToolBarShell.mark = (void (*)(void *)) FXRbToolBarShell::markfunc;
    cFXToolBarShell.destroy = (void (*)(void *)) FXRbObject::freefunc;
}

