/***********************************************************************
 * FXRuby -- the Ruby language bindings for the FOX GUI toolkit.
 * Copyright (c) 2001-2003 by J. Lyle Johnson. All Rights Reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * For further information please contact the author by e-mail
 * at "lyle@users.sourceforge.net".
 ***********************************************************************/

/// Registers stuff to know about the extension
struct FXFileAssoc {
  FXFileAssoc();
  FXString   command;           /// Command to execute
  FXString   extension;         /// Full extension name
  FXString   mimetype;          /// Mime type name
  FXIcon    *bigicon;           /// Big normal icon
  FXIcon    *bigiconopen;       /// Big open icon
  FXIcon    *miniicon;          /// Mini normal icon
  FXIcon    *miniiconopen;      /// Mini open icon
  FXDragType dragtype;          /// Registered drag type
  FXuint     flags;             /// Flags
  ~FXFileAssoc();
  };


/// Icon dictionary
class FXIconDict : public FXDict {
protected:
  FXIconDict(){}
  virtual void *createData(const void*);
  virtual void deleteData(void*);
public:
  %extend {
    /// Default icon search path
    static VALUE defaultIconPath(){
      return rb_str_new2(FXIconDict::defaultIconPath);
      }
  }

public:

  %extend {
    /// Construct an icon dictionary, with given path
    FXIconDict(FXApp* a,const FXString& p=defaultIconPath){
      return new FXRbIconDict(a,p);
      }
    }

  /// Get application
  FXApp* getApp() const;

  /// Set icon search path
  void setIconPath(const FXString& p);

  /// Return current icon search path
  FXString getIconPath() const;

  /// Insert unique icon loaded from filename into dictionary
  FXIcon* insert(const FXchar* name);

  /// Remove icon from dictionary
  FXIcon* remove(const FXchar* name);

  /// Find icon by name
  FXIcon* find(const FXchar* name);

  /// Destructor
  virtual ~FXIconDict();
  };


DECLARE_FXOBJECT_VIRTUALS(FXIconDict)


/// File Association dictionary
class FXFileDict : public FXDict {
protected:
  FXFileDict(){}
  virtual void *createData(const void*);
  virtual void deleteData(void*);

public:
#ifdef SWIGRUBY
  %extend {
    /// Registry key used to find fallback executable icons
    static VALUE defaultExecBinding(){
      return to_ruby(FXFileDict::defaultExecBinding);
      }

    /// Registry key used to find fallback directory icons
    static VALUE defaultDirBinding(){
      return to_ruby(FXFileDict::defaultDirBinding);
      }

    /// Registry key used to find fallback document icons
    static VALUE defaultFileBinding(){
      return to_ruby(FXFileDict::defaultFileBinding);
      }
  }
#endif

public:

  %extend {
    /**
    * Construct a dictionary mapping file-extension to file associations,
    * using the application registry settings as a source for the bindings.
    */
    FXFileDict(FXApp* a){
      return new FXRbFileDict(a);
      }
  
    /**
    * Construct a dictionary mapping file-extension to file associations,
    * using the specified settings database as a source for the bindings.
    */
    FXFileDict(FXApp* a,FXSettings* db){
      return new FXRbFileDict(a,db);
      }
    }

  /// Get application
  FXApp* getApp() const;

  /// Set icon search path
  void setIconPath(const FXString& path);

  /// Return current icon search path
  FXString getIconPath() const;

  /// Replace file association
  FXFileAssoc* replace(const FXchar* ext,const FXchar* str);

  /// Remove file association
  FXFileAssoc* remove(const FXchar* ext);

  /// Find file association already in dictionary
  FXFileAssoc* find(const FXchar* ext);

  /// Find file association from registry
  FXFileAssoc* associate(const FXchar* key);
  
  /// Destructor
  virtual ~FXFileDict();
  };


DECLARE_FXOBJECT_VIRTUALS(FXFileDict)
DECLARE_FXFILEDICT_VIRTUALS(FXFileDict)

