/***********************************************************************
 * FXRuby -- the Ruby language bindings for the FOX GUI toolkit.
 * Copyright (c) 2001-2003 by J. Lyle Johnson. All Rights Reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * For further information please contact the author by e-mail
 * at "lyle@users.sourceforge.net".
 ***********************************************************************/

class FXMDIChild;
  

/**
* The MDI client window manages a number of MDI child windows in
* a multiple-document interface (MDI) application.
* MDI child windows usually receive messages from the GUI through
* delegation via the MDI client, i.e. the MDI client window is set as
* the target for most GUI commands; the MDI client filters out a few messages
* and forwards all other messages to the active MDI child.
* MDI client can arrange the MDI child windows in various ways:-
* it may maximize one of the MDI child windows, arrange them side-by-side,
* cascade them, or iconify them.
* MDI child windows are notified about changes in the active MDI child
* window by the MDI client.
*/
class FXMDIClient : public FXComposite {
protected:
  FXMDIChild *active;             // Active child
  FXint       cascadex;           // Cascade offset X
  FXint       cascadey;           // Cascade offset Y
protected:
  FXMDIClient();
public:
  long onCmdActivateNext(FXObject*,FXSelector,void* PTR_IGNORE);
  long onCmdActivatePrev(FXObject*,FXSelector,void* PTR_IGNORE);
  long onCmdTileHorizontal(FXObject*,FXSelector,void* PTR_IGNORE);
  long onCmdTileVertical(FXObject*,FXSelector,void* PTR_IGNORE);
  long onCmdCascade(FXObject*,FXSelector,void* PTR_IGNORE);
  long onUpdActivateNext(FXObject*,FXSelector,void* PTR_IGNORE);
  long onUpdActivatePrev(FXObject*,FXSelector,void* PTR_IGNORE);
  long onUpdTileVertical(FXObject*,FXSelector,void* PTR_IGNORE);
  long onUpdTileHorizontal(FXObject*,FXSelector,void* PTR_IGNORE);
  long onUpdCascade(FXObject*,FXSelector,void* PTR_IGNORE);
  long onUpdClose(FXObject*,FXSelector,void* PTR_IGNORE);
  long onUpdMenuClose(FXObject*,FXSelector,void* PTR_IGNORE);
  long onUpdRestore(FXObject*,FXSelector,void* PTR_IGNORE);
  long onUpdMenuRestore(FXObject*,FXSelector,void* PTR_IGNORE);
  long onUpdMinimize(FXObject*,FXSelector,void* PTR_IGNORE);
  long onUpdMenuMinimize(FXObject*,FXSelector,void* PTR_IGNORE);
  long onUpdMaximize(FXObject*,FXSelector,void* PTR_IGNORE);
  long onUpdMenuWindow(FXObject*,FXSelector,void* PTR_IGNORE);
  long onCmdWindowSelect(FXObject*,FXSelector,void* PTR_IGNORE);
  long onUpdWindowSelect(FXObject*,FXSelector,void* PTR_IGNORE);
  long onCmdOthersWindows(FXObject*,FXSelector,void* PTR_IGNORE);
  long onUpdOthersWindows(FXObject*,FXSelector,void* PTR_IGNORE);
  long onUpdAnyWindows(FXObject*,FXSelector,void* PTR_IGNORE);
public:
  enum {
    ID_MDI_ANY=65400,
    ID_MDI_1,           // Select MDI child 1 
    ID_MDI_2,
    ID_MDI_3,
    ID_MDI_4,
    ID_MDI_5,
    ID_MDI_6,
    ID_MDI_7,
    ID_MDI_8,
    ID_MDI_9,
    ID_MDI_10,
    ID_MDI_OVER_1,      // Sensitize MDI menu when 1 or more children
    ID_MDI_OVER_2,
    ID_MDI_OVER_3,
    ID_MDI_OVER_4,
    ID_MDI_OVER_5,
    ID_MDI_OVER_6,
    ID_MDI_OVER_7,
    ID_MDI_OVER_8,
    ID_MDI_OVER_9,
    ID_MDI_OVER_10,
    ID_LAST
    };
public:
  %extend {
    /// Construct MDI Client window
    FXMDIClient(FXComposite* p,FXuint opts=0,FXint x=0,FXint y=0,FXint w=0,FXint h=0){
      return new FXRbMDIClient(p,opts,x,y,w,h);
      }
    }

  /**
  * Pass message to all MDI windows, stopping when one of
  * the MDI windows fails to handle the message.
  */
  long forallWindows(FXObject* sender,FXSelector sel,void* ptr);

  /**
  * Pass message once to all MDI windows with the same document,
  * stopping when one of the MDI windows fails to handle the message.
  */
  long forallDocuments(FXObject* sender,FXSelector sel,void* ptr);

  /**
  * Pass message to all MDI Child windows whose target is document,
  * stopping when one of the MDI windows fails to handle the message.
  */
  long forallDocWindows(FXObject* document,FXObject* sender,FXSelector sel,void* ptr);

  /// Get current active child; may be NULL!
  FXMDIChild* getActiveChild() const;

  /// Change cascade offset X
  void setCascadeX(FXint off);

  /// Change cascade offset Y
  void setCascadeY(FXint off);

  /// Get cascade offset X
  FXint getCascadeX() const;

  /// Get cascade offset Y
  FXint getCascadeY() const;

  /// Destructor
  virtual ~FXMDIClient();
  };


DECLARE_FXOBJECT_VIRTUALS(FXMDIClient)
DECLARE_FXID_VIRTUALS(FXMDIClient)
DECLARE_FXDRAWABLE_VIRTUALS(FXMDIClient)
DECLARE_FXWINDOW_VIRTUALS(FXMDIClient)
DECLARE_FXMDICLIENT_VIRTUALS(FXMDIClient)
