/***********************************************************************
 * FXRuby -- the Ruby language bindings for the FOX GUI toolkit.
 * Copyright (c) 2001-2003 by J. Lyle Johnson. All Rights Reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * For further information please contact the author by e-mail
 * at "lyle@users.sourceforge.net".
 ***********************************************************************/

%ignore FXSphered::operator=(const FXSphered&);

%rename("empty?")	FXSphered::empty() const;
%rename("contains?")	FXSphered::contains(FXdouble x,FXdouble y,FXdouble z) const;
%rename("contains?")	FXSphered::contains(const FXVec3d& p) const;
%rename("contains?")	FXSphered::contains(const FXRanged& box) const;
%rename("contains?")	FXSphered::contains(const FXSphered& sphere) const;
%rename("include!")	FXSphered::include(FXdouble x,FXdouble y,FXdouble z);
%rename("include!")	FXSphered::include(const FXVec3d& p);
%rename("include!")	FXSphered::include(const FXRanged& box);
%rename("include!")	FXSphered::include(const FXSphered& sphere);
%rename("intersects?")	FXSphered::intersect(const FXVec3d& u,const FXVec3d& v) const;
%rename("overlaps?")	FXSphered::overlap(const FXRanged& other) const;
%rename("overlaps?")	FXSphered::overlap(const FXSphered& other) const;

// Spherical bounds
class FXSphered {
public:
  FXVec3d center;
  FXdouble radius;
public:

  /// Default constructor
  FXSphered();

  /// Copy constructor
  FXSphered(const FXSphered& sphere);

  /// Initialize from center and radius
  FXSphered(const FXVec3d& cen,FXdouble rad);

  /// Initialize from center and radius
  FXSphered(FXdouble x,FXdouble y,FXdouble z,FXdouble rad);

  /// Initialize sphere to fully contain the given bounding box
  FXSphered(const FXRanged& bounds);

  /// Assignment
  FXSphered& operator=(const FXSphered& sphere);

  // Diameter of sphere
  FXdouble diameter() const;

  /// Test if empty
  FXbool empty() const;

  /// Test if sphere contains point x,y,z
  FXbool contains(FXdouble x,FXdouble y,FXdouble z) const;

  /// Test if sphere contains point p
  FXbool contains(const FXVec3d& p) const;

  /// Test if sphere properly contains another box
  FXbool contains(const FXRanged& box) const;

  /// Test if sphere properly contains another sphere
  FXbool contains(const FXSphered& sphere) const;

  /// Include point
  FXSphered& include(FXdouble x,FXdouble y,FXdouble z);

  /// Include point
  FXSphered& include(const FXVec3d& p);

  /// Include given range into this one
  FXSphered& include(const FXRanged& box);

  /// Include given sphere into this one
  FXSphered& include(const FXSphered& sphere);

  // Intersect sphere with plane ax+by+cz+w; returns -1,0,+1
  FXint intersect(const FXVec4d& plane) const;

  /// Intersect sphere with ray u-v
  FXbool intersect(const FXVec3d& u,const FXVec3d& v) const;

  %extend {
    /// Test if sphere overlaps with box
    FXbool overlap(const FXRanged& other) const {
      return overlap(*self,other);
      }

    /// Test if spheres overlap
    FXbool overlap(const FXSphered& other) const {
      return overlap(*self,other);
      }
    }
  };
