/***********************************************************************
 * FXRuby -- the Ruby language bindings for the FOX GUI toolkit.
 * Copyright (c) 2001-2003 by J. Lyle Johnson. All Rights Reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * For further information please contact the author by e-mail
 * at "lyle@users.sourceforge.net".
 ***********************************************************************/

/// Stream data flow direction
enum FXStreamDirection {
  FXStreamDead=0,               /// Unopened stream
  FXStreamSave=1,               /// Saving stuff to stream
  FXStreamLoad=2                /// Loading stuff from stream
  };


/// Stream status codes
enum FXStreamStatus {
  FXStreamOK=0,                 /// OK
  FXStreamEnd=1,                /// Try read past end of stream
  FXStreamFull=2,               /// Filled up stream buffer or disk full
  FXStreamNoWrite=3,            /// Unable to open for write
  FXStreamNoRead=4,             /// Unable to open for read
  FXStreamFormat=5,             /// Stream format error
  FXStreamUnknown=6,            /// Trying to read unknown class
  FXStreamAlloc=7,              /// Alloc failed
  FXStreamFailure=8             /// General failure
  };


/// Stream seeking
enum FXWhence {
  FXFromStart=0,                /// Seek from start position
  FXFromCurrent=1,              /// Seek from current position
  FXFromEnd=2                   /// Seek from end position
  };


/*********************  Persistent Store Definition  *************************/

%rename("getPosition") FXStream::position() const;
%rename("eof?")        FXStream::eof() const;

/// Persistent store definition
class FXStream {
public:

  /**
   * Construct stream with given container object.  The container object
   * is an object that will itself not be saved to or loaded from the stream,
   * but which may be referenced by other objects.  These references will be
   * properly saved and restored.
   */
  /// Constructor
  %extend {
    FXStream(const FXObject* cont=NULL){
      return new FXRbStream(cont);
      }
  }

  /**
  * Open stream for reading (FXStreamLoad) or for writing (FXStreamSave).
  * An initial buffer size may be given, which must be at least 16 bytes.
  * If data is not NULL, it is expected to point to an external data buffer
  * of length size; otherwise stream will use an internally managed buffer.
  */
  FXbool open(FXStreamDirection save_or_load,unsigned long size=8192,FXuchar* data=NULL);

  /// Get available buffer space
  unsigned long getSpace() const;

  /// Set available buffer space
  void setSpace(unsigned long sp);

  /// Get status code
  FXStreamStatus status() const;

  /// Return TRUE if at end of file or error
  FXbool eof() const;
  
  /// Set status code
  void setError(FXStreamStatus err);

  /// Obtain direction
  FXStreamDirection direction() const;

  /// Get parent object
  const FXObject* container() const;

  /// Get position
  unsigned long position() const;

  /// Change swap bytes flag
  void swapBytes(FXbool s);

  /// Get swap bytes flag
  FXbool swapBytes() const;

  /// Return implementation's endianness
  static FXbool isLittleEndian();
  
  /// Destructor
  virtual ~FXStream();
  };


DECLARE_FXSTREAM_VIRTUALS(FXStream)

