/***********************************************************************
 * FXRuby -- the Ruby language bindings for the FOX GUI toolkit.
 * Copyright (c) 2001-2003 by J. Lyle Johnson. All Rights Reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * For further information please contact the author by e-mail
 * at "lyle@users.sourceforge.net".
 ***********************************************************************/


/// TGA Image class
class FXTGAImage : public FXImage {
protected:
  FXTGAImage(){}
public:

  /// Construct an image from memory stream formatted in TGA format
  %extend {
    FXTGAImage(FXApp *a,const void *pix=NULL,FXuint opts=0,FXint w=1,FXint h=1){
      return new FXRbTGAImage(a,pix,opts,w,h);
      }
    }

  /// Destroy
  virtual ~FXTGAImage();
  };


DECLARE_FXOBJECT_VIRTUALS(FXTGAImage)
DECLARE_FXID_VIRTUALS(FXTGAImage)
DECLARE_FXDRAWABLE_VIRTUALS(FXTGAImage)
DECLARE_FXIMAGE_VIRTUALS(FXTGAImage)


%inline %{
  /// Load a Targa Image from a stream
  VALUE fxloadTGA(FXStream& store){
    FXColor* data;
    FXint width;
    FXint height;
    if(fxloadTGA(store,data,width,height)){
      VALUE ary=rb_ary_new();
      rb_ary_push(ary,FXRbMakeColorArray(data,width,height));
      FXFREE(&data);
      rb_ary_push(ary,to_ruby(width));
      rb_ary_push(ary,to_ruby(height));
      return ary;
      }
    else{
      return Qnil;
      }
    }
%}

/// Save a Targa image to a stream
FXbool fxsaveTGA(FXStream& store,const FXColor* PIXELS,FXint width,FXint height);
