#!/usr/bin/env ruby

require 'fox12'
begin
  require 'soap/driver'
rescue LoadError
  require 'fox12/missingdep'
  MSG = <<EOM
  Sorry, this example depends on the SOAP4R extension. Please
  check the Ruby Application Archives for an appropriate
  download site.
EOM
  missingDependency(MSG)
end

include Fox

TRANSLATIONS = {
  "English to French" => "en_fr",
  "English to German" => "en_de",
  "English to Italian" => "en_it",
  "English to Japanese" => "en_jp",
  "English to Korean" => "en_kr",
  "English to Portugese" => "en_pt",
  "English to Spanish" => "en_es",
  "French to English" => "fr_en",
  "German to English" => "de_en",
  "Italian to English" => "it_en",
  "Japanese to English" => "jp_en",
  "Korean to English" => "kr_en",
  "Portugese to English" => "pt_en",
  "Spanish to English" => "es_en",
  "Russian to English" => "ru_en",
  "German to French" => "de_fr",
  "French to German" => "fr_de"
}

class Babelfish < FXMainWindow

  def initialize(app)
    # Invoke base class initialize first
    super(app, "Babelfish", nil, nil, DECOR_ALL,
      0, 0, 600, 400, 0, 0)

    # Initialize the SOAP driver
    @drv = SOAP::Driver.new(nil, nil, 'urn:xmethodsBabelFish',
      'http://services.xmethods.net/perl/soaplite.cgi')
    @drv.addMethodWithSOAPAction('BabelFish',
      'urn:xmethodsBabelFish#BabelFish', 'translationmode', 'sourcedata')

    # Controls area along the bottom
    controlsFrame = FXHorizontalFrame.new(self,
      LAYOUT_SIDE_BOTTOM|LAYOUT_FILL_X)
    FXLabel.new(controlsFrame, "Translate from:")
    @transModeCombo = FXComboBox.new(controlsFrame, 15, 6, nil, 0,
      COMBOBOX_STATIC|FRAME_SUNKEN|FRAME_THICK)
    TRANSLATIONS.keys.each do |key|
      @transModeCombo.appendItem(key, TRANSLATIONS[key])
    end
    btn = FXButton.new(controlsFrame, "Translate", nil, nil, 0,
      BUTTON_NORMAL|LAYOUT_SIDE_RIGHT)
    btn.connect(SEL_COMMAND) do
      transMode = @transModeCombo.getItemData(@transModeCombo.currentItem)
      getApp().beginWaitCursor() do
        @translatedText.text = @drv.BabelFish(transMode, @sourceText.text)
      end
    end

    mainFrame = FXVerticalFrame.new(self,
      LAYOUT_SIDE_TOP|LAYOUT_FILL_X|LAYOUT_FILL_Y|PACK_UNIFORM_HEIGHT)

    # Source text area in a sunken frame
    topFrame = FXVerticalFrame.new(mainFrame, LAYOUT_FILL_X|LAYOUT_FILL_Y)
    FXLabel.new(topFrame, "Source Text:", nil, LAYOUT_FILL_X)
    sunkenFrame = FXHorizontalFrame.new(topFrame,
      FRAME_SUNKEN|FRAME_THICK|LAYOUT_FILL_X|LAYOUT_FILL_Y)
    @sourceText = FXText.new(sunkenFrame, nil, 0,
      LAYOUT_FILL_X|LAYOUT_FILL_Y)

    # Translated text output
    bottomFrame = FXVerticalFrame.new(mainFrame, LAYOUT_FILL_X|LAYOUT_FILL_Y)
    FXLabel.new(bottomFrame, "Translated text:", nil, LAYOUT_FILL_X)
    sunkenFrame = FXHorizontalFrame.new(bottomFrame,
      FRAME_SUNKEN|FRAME_THICK|LAYOUT_FILL_X|LAYOUT_FILL_Y)
    @translatedText = FXText.new(sunkenFrame, nil, 0,
      TEXT_READONLY|LAYOUT_FILL_X|LAYOUT_FILL_Y)
  end
  
  def create
    super
    show(PLACEMENT_SCREEN)
  end
end

if __FILE__ == $0
  # Make application
  application = FXApp.new("Babelfish", "FoxTest")

  # Make window
  window = Babelfish.new(application)

  # Create it
  application.create

  # Run
  application.run
end
