/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 1.3.22
 * 
 * This file is not intended to be easily readable and contains a number of 
 * coding conventions designed to improve portability and efficiency. Do not make
 * changes to this file unless you know what you are doing--modify the SWIG 
 * interface file instead. 
 * ----------------------------------------------------------------------------- */

#define SWIG_NOINCLUDE

#ifdef __cplusplus
template<class T> class SwigValueWrapper {
    T *tt;
public:
    SwigValueWrapper() : tt(0) { }
    SwigValueWrapper(const SwigValueWrapper<T>& rhs) : tt(new T(*rhs.tt)) { }
    SwigValueWrapper(const T& t) : tt(new T(t)) { }
    ~SwigValueWrapper() { delete tt; } 
    SwigValueWrapper& operator=(const T& t) { delete tt; tt = new T(t); return *this; }
    operator T&() const { return *tt; }
    T *operator&() { return tt; }
private:
    SwigValueWrapper& operator=(const SwigValueWrapper<T>& rhs);
};                                                    
#endif

/* ruby.swg */
/* Implementation : RUBY */
#define SWIGRUBY 1

#include "ruby.h"

/* Flags for pointer conversion */
#define SWIG_POINTER_EXCEPTION     0x1
#define SWIG_POINTER_DISOWN        0x2

#define NUM2USHRT(n) (\
    (0 <= NUM2UINT(n) && NUM2UINT(n) <= USHRT_MAX)\
    ? (unsigned short) NUM2UINT(n) \
    : (rb_raise(rb_eArgError, "integer %d out of range of `unsigned short'",\
               NUM2UINT(n)), (short)0)\
)

#define NUM2SHRT(n) (\
    (SHRT_MIN <= NUM2INT(n) && NUM2INT(n) <= SHRT_MAX)\
    ? (short)NUM2INT(n)\
    : (rb_raise(rb_eArgError, "integer %d out of range of `short'",\
               NUM2INT(n)), (short)0)\
)

/* Ruby 1.7 defines NUM2LL(), LL2NUM() and ULL2NUM() macros */
#ifndef NUM2LL
#define NUM2LL(x) NUM2LONG((x))
#endif
#ifndef LL2NUM
#define LL2NUM(x) INT2NUM((long) (x))
#endif
#ifndef ULL2NUM
#define ULL2NUM(x) UINT2NUM((unsigned long) (x))
#endif

/* Ruby 1.7 doesn't (yet) define NUM2ULL() */
#ifndef NUM2ULL
#ifdef HAVE_LONG_LONG
#define NUM2ULL(x) rb_num2ull((x))
#else
#define NUM2ULL(x) NUM2ULONG(x)
#endif
#endif

/*
 * Need to be very careful about how these macros are defined, especially
 * when compiling C++ code or C code with an ANSI C compiler.
 *
 * VALUEFUNC(f) is a macro used to typecast a C function that implements
 * a Ruby method so that it can be passed as an argument to API functions
 * like rb_define_method() and rb_define_singleton_method().
 *
 * VOIDFUNC(f) is a macro used to typecast a C function that implements
 * either the "mark" or "free" stuff for a Ruby Data object, so that it
 * can be passed as an argument to API functions like Data_Wrap_Struct()
 * and Data_Make_Struct().
 */
 
#ifdef __cplusplus
#  ifndef RUBY_METHOD_FUNC /* These definitions should work for Ruby 1.4.6 */
#    define PROTECTFUNC(f) ((VALUE (*)()) f)
#    define VALUEFUNC(f) ((VALUE (*)()) f)
#    define VOIDFUNC(f)  ((void (*)()) f)
#  else
#    ifndef ANYARGS /* These definitions should work for Ruby 1.6 */
#      define PROTECTFUNC(f) ((VALUE (*)()) f)
#      define VALUEFUNC(f) ((VALUE (*)()) f)
#      define VOIDFUNC(f)  ((RUBY_DATA_FUNC) f)
#    else /* These definitions should work for Ruby 1.7+ */
#      define PROTECTFUNC(f) ((VALUE (*)(VALUE)) f)
#      define VALUEFUNC(f) ((VALUE (*)(ANYARGS)) f)
#      define VOIDFUNC(f)  ((RUBY_DATA_FUNC) f)
#    endif
#  endif
#else
#  define VALUEFUNC(f) (f)
#  define VOIDFUNC(f) (f)
#endif

typedef struct {
  VALUE klass;
  VALUE mImpl;
  void  (*mark)(void *);
  void  (*destroy)(void *);
} swig_class;

/* Don't use for expressions have side effect */
#ifndef RB_STRING_VALUE
#define RB_STRING_VALUE(s) (TYPE(s) == T_STRING ? (s) : (*(volatile VALUE *)&(s) = rb_str_to_str(s)))
#endif
#ifndef StringValue
#define StringValue(s) RB_STRING_VALUE(s)
#endif
#ifndef StringValuePtr
#define StringValuePtr(s) RSTRING(RB_STRING_VALUE(s))->ptr
#endif
#ifndef StringValueLen
#define StringValueLen(s) RSTRING(RB_STRING_VALUE(s))->len
#endif
#ifndef SafeStringValue
#define SafeStringValue(v) do {\
    StringValue(v);\
    rb_check_safe_str(v);\
} while (0)
#endif

#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
#define rb_define_alloc_func(klass, func) rb_define_singleton_method((klass), "new", VALUEFUNC((func)), -1)
#define rb_undef_alloc_func(klass) rb_undef_method(CLASS_OF((klass)), "new")
#endif

/* Contract support */

#define SWIG_contract_assert(expr, msg) if (!(expr)) { rb_raise(rb_eRuntimeError, (char *) msg ); } else


/*************************************************************** -*- c -*-
 * ruby/precommon.swg
 *
 * Rename all exported symbols from common.swg, to avoid symbol
 * clashes if multiple interpreters are included
 *
 ************************************************************************/

#define SWIG_TypeRegister    SWIG_Ruby_TypeRegister
#define SWIG_TypeCheck       SWIG_Ruby_TypeCheck
#define SWIG_TypeCast        SWIG_Ruby_TypeCast
#define SWIG_TypeDynamicCast SWIG_Ruby_TypeDynamicCast
#define SWIG_TypeName        SWIG_Ruby_TypeName
#define SWIG_TypePrettyName  SWIG_Ruby_TypePrettyName
#define SWIG_TypeQuery       SWIG_Ruby_TypeQuery
#define SWIG_TypeClientData  SWIG_Ruby_TypeClientData
#define SWIG_PackData        SWIG_Ruby_PackData 
#define SWIG_UnpackData      SWIG_Ruby_UnpackData 

/* Also rename all exported symbols from rubydef.swig */

/* Common SWIG API */
#define SWIG_ConvertPtr(obj, pp, type, flags) \
  SWIG_Ruby_ConvertPtr(obj, pp, type, flags)
#define SWIG_NewPointerObj(p, type, flags) \
  SWIG_Ruby_NewPointerObj(p, type, flags)
#define SWIG_MustGetPtr(p, type, argnum, flags) \
  SWIG_Ruby_MustGetPtr(p, type, argnum, flags)

/* Ruby-specific SWIG API */

#define SWIG_InitRuntime() \
  SWIG_Ruby_InitRuntime()
#define SWIG_define_class(ty) \
  SWIG_Ruby_define_class(ty)
#define SWIG_NewClassInstance(value, ty) \
  SWIG_Ruby_NewClassInstance(value, ty)
#define SWIG_MangleStr(value) \
  SWIG_Ruby_MangleStr(value)
#define SWIG_CheckConvert(value, ty) \
  SWIG_Ruby_CheckConvert(value, ty)
#define SWIG_NewPackedObj(ptr, sz, ty) \
  SWIG_Ruby_NewPackedObj(ptr, sz, ty)
#define SWIG_ConvertPacked(obj, ptr, sz, ty, flags) \
  SWIG_Ruby_ConvertPacked(obj, ptr, sz, ty, flags)


/***********************************************************************
 * common.swg
 *
 *     This file contains generic SWIG runtime support for pointer
 *     type checking as well as a few commonly used macros to control
 *     external linkage.
 *
 * Author : David Beazley (beazley@cs.uchicago.edu)
 *
 * Copyright (c) 1999-2000, The University of Chicago
 * 
 * This file may be freely redistributed without license or fee provided
 * this copyright message remains intact.
 ************************************************************************/

#include <string.h>

#if defined(_WIN32) || defined(__WIN32__) || defined(__CYGWIN__)
#  if defined(_MSC_VER) || defined(__GNUC__)
#    if defined(STATIC_LINKED)
#      define SWIGEXPORT(a) a
#      define SWIGIMPORT(a) extern a
#    else
#      define SWIGEXPORT(a) __declspec(dllexport) a
#      define SWIGIMPORT(a) extern a
#    endif
#  else
#    if defined(__BORLANDC__)
#      define SWIGEXPORT(a) a _export
#      define SWIGIMPORT(a) a _export
#    else
#      define SWIGEXPORT(a) a
#      define SWIGIMPORT(a) a
#    endif
#  endif
#else
#  define SWIGEXPORT(a) a
#  define SWIGIMPORT(a) a
#endif

#ifdef SWIG_GLOBAL
#  define SWIGRUNTIME(a) SWIGEXPORT(a)
#else
#  define SWIGRUNTIME(a) static a
#endif

#ifdef __cplusplus
extern "C" {
#endif

typedef void *(*swig_converter_func)(void *);
typedef struct swig_type_info *(*swig_dycast_func)(void **);

typedef struct swig_type_info {
  const char             *name;
  swig_converter_func     converter;
  const char             *str;
  void                   *clientdata;
  swig_dycast_func        dcast;
  struct swig_type_info  *next;
  struct swig_type_info  *prev;
} swig_type_info;

#ifdef SWIG_NOINCLUDE

SWIGIMPORT(swig_type_info *) SWIG_TypeRegister(swig_type_info *);
SWIGIMPORT(swig_type_info *) SWIG_TypeCheck(char *c, swig_type_info *);
SWIGIMPORT(void *)           SWIG_TypeCast(swig_type_info *, void *);
SWIGIMPORT(swig_type_info *) SWIG_TypeDynamicCast(swig_type_info *, void **);
SWIGIMPORT(const char *)     SWIG_TypeName(const swig_type_info *);
SWIGIMPORT(const char *)     SWIG_TypePrettyName(const swig_type_info *);
SWIGIMPORT(swig_type_info *) SWIG_TypeQuery(const char *);
SWIGIMPORT(void)             SWIG_TypeClientData(swig_type_info *, void *);
SWIGIMPORT(char *)           SWIG_PackData(char *, void *, int);
SWIGIMPORT(char *)           SWIG_UnpackData(char *, void *, int);

#else

static swig_type_info *swig_type_list = 0;
static swig_type_info **swig_type_list_handle = &swig_type_list;

/* Register a type mapping with the type-checking */
SWIGRUNTIME(swig_type_info *)
SWIG_TypeRegister(swig_type_info *ti) {
  swig_type_info *tc, *head, *ret, *next;
  /* Check to see if this type has already been registered */
  tc = *swig_type_list_handle;
  while (tc) {
    if (strcmp(tc->name, ti->name) == 0) {
      /* Already exists in the table.  Just add additional types to the list */
      if (tc->clientdata) ti->clientdata = tc->clientdata;
      head = tc;
      next = tc->next;
      goto l1;
    }
    tc = tc->prev;
  }
  head = ti;
  next = 0;

  /* Place in list */
  ti->prev = *swig_type_list_handle;
  *swig_type_list_handle = ti;

  /* Build linked lists */
  l1:
  ret = head;
  tc = ti + 1;
  /* Patch up the rest of the links */
  while (tc->name) {
    head->next = tc;
    tc->prev = head;
    head = tc;
    tc++;
  }
  if (next) next->prev = head;
  head->next = next;
  return ret;
}

/* Check the typename */
SWIGRUNTIME(swig_type_info *) 
SWIG_TypeCheck(char *c, swig_type_info *ty) {
  swig_type_info *s;
  if (!ty) return 0;        /* Void pointer */
  s = ty->next;             /* First element always just a name */
  do {
    if (strcmp(s->name,c) == 0) {
      if (s == ty->next) return s;
      /* Move s to the top of the linked list */
      s->prev->next = s->next;
      if (s->next) {
        s->next->prev = s->prev;
      }
      /* Insert s as second element in the list */
      s->next = ty->next;
      if (ty->next) ty->next->prev = s;
      ty->next = s;
      s->prev = ty;
      return s;
    }
    s = s->next;
  } while (s && (s != ty->next));
  return 0;
}

/* Cast a pointer up an inheritance hierarchy */
SWIGRUNTIME(void *) 
SWIG_TypeCast(swig_type_info *ty, void *ptr) {
  if ((!ty) || (!ty->converter)) return ptr;
  return (*ty->converter)(ptr);
}

/* Dynamic pointer casting. Down an inheritance hierarchy */
SWIGRUNTIME(swig_type_info *) 
SWIG_TypeDynamicCast(swig_type_info *ty, void **ptr) {
  swig_type_info *lastty = ty;
  if (!ty || !ty->dcast) return ty;
  while (ty && (ty->dcast)) {
    ty = (*ty->dcast)(ptr);
    if (ty) lastty = ty;
  }
  return lastty;
}

/* Return the name associated with this type */
SWIGRUNTIME(const char *)
SWIG_TypeName(const swig_type_info *ty) {
  return ty->name;
}

/* Return the pretty name associated with this type,
   that is an unmangled type name in a form presentable to the user.
*/
SWIGRUNTIME(const char *)
SWIG_TypePrettyName(const swig_type_info *type) {
  /* The "str" field contains the equivalent pretty names of the
     type, separated by vertical-bar characters.  We choose
     to print the last name, as it is often (?) the most
     specific. */
  if (type->str != NULL) {
    const char *last_name = type->str;
    const char *s;
    for (s = type->str; *s; s++)
      if (*s == '|') last_name = s+1;
    return last_name;
  }
  else
    return type->name;
}

/* 
   Compare two type names skipping the space characters, therefore
   "char*" == "char *" and "Class<int>" == "Class<int >", etc.

   Return 0 when the two name types are equivalent, as in
   strncmp, but skipping ' '.
*/
static int
SWIG_TypeNameComp(const char *f1, const char *l1,
		  const char *f2, const char *l2) {
  for (;(f1 != l1) && (f2 != l2); ++f1, ++f2) {
    while ((*f1 == ' ') && (f1 != l1)) ++f1;
    while ((*f2 == ' ') && (f2 != l2)) ++f2;
    if (*f1 != *f2) return *f1 - *f2;
  }
  return (l1 - f1) - (l2 - f2);
}

/*
  Check type equivalence in a name list like <name1>|<name2>|...
*/
static int
SWIG_TypeEquiv(const char *nb, const char *tb) {
  int equiv = 0;
  const char* te = tb + strlen(tb);
  const char* ne = nb;
  while (!equiv && *ne) {
    for (nb = ne; *ne; ++ne) {
      if (*ne == '|') break;
    }
    equiv = SWIG_TypeNameComp(nb, ne, tb, te) == 0;
    if (*ne) ++ne;
  }
  return equiv;
}
  

/* Search for a swig_type_info structure */
SWIGRUNTIME(swig_type_info *)
SWIG_TypeQuery(const char *name) {
  swig_type_info *ty = *swig_type_list_handle;
  while (ty) {
    if (ty->str && (SWIG_TypeEquiv(ty->str,name))) return ty;
    if (ty->name && (strcmp(name,ty->name) == 0)) return ty;
    ty = ty->prev;
  }
  return 0;
}

/* Set the clientdata field for a type */
SWIGRUNTIME(void)
SWIG_TypeClientData(swig_type_info *ti, void *clientdata) {
  swig_type_info *tc, *equiv;
  if (ti->clientdata == clientdata) return;
  ti->clientdata = clientdata;
  equiv = ti->next;
  while (equiv) {
    if (!equiv->converter) {
      tc = *swig_type_list_handle;
      while (tc) {
        if ((strcmp(tc->name, equiv->name) == 0))
          SWIG_TypeClientData(tc,clientdata);
        tc = tc->prev;
      }
    }
    equiv = equiv->next;
  }
}

/* Pack binary data into a string */
SWIGRUNTIME(char *)
SWIG_PackData(char *c, void *ptr, int sz) {
  static char hex[17] = "0123456789abcdef";
  unsigned char *u = (unsigned char *) ptr;
  const unsigned char *eu =  u + sz;
  register unsigned char uu;
  for (; u != eu; ++u) {
    uu = *u;
    *(c++) = hex[(uu & 0xf0) >> 4];
    *(c++) = hex[uu & 0xf];
  }
  return c;
}

/* Unpack binary data from a string */
SWIGRUNTIME(char *)
SWIG_UnpackData(char *c, void *ptr, int sz) {
  register unsigned char uu = 0;
  register int d;
  unsigned char *u = (unsigned char *) ptr;
  const unsigned char *eu =  u + sz;
  for (; u != eu; ++u) {
    d = *(c++);
    if ((d >= '0') && (d <= '9'))
      uu = ((d - '0') << 4);
    else if ((d >= 'a') && (d <= 'f'))
      uu = ((d - ('a'-10)) << 4);
    d = *(c++);
    if ((d >= '0') && (d <= '9'))
      uu |= (d - '0');
    else if ((d >= 'a') && (d <= 'f'))
      uu |= (d - ('a'-10));
    *u = uu;
  }
  return c;
}

#endif

#ifdef __cplusplus
}
#endif

/* rubydec.swg -*- c -*- */
#ifdef __cplusplus
extern "C" {
#endif

SWIGIMPORT(void)   SWIG_Ruby_InitRuntime(void);
SWIGIMPORT(void)   SWIG_Ruby_define_class(swig_type_info *);
SWIGIMPORT(VALUE)  SWIG_Ruby_NewPointerObj(void *, swig_type_info *, int);
SWIGIMPORT(VALUE)  SWIG_Ruby_NewClassInstance(VALUE, swig_type_info *);
SWIGIMPORT(char *) SWIG_Ruby_MangleStr(VALUE);
SWIGIMPORT(int)    SWIG_Ruby_ConvertPtr(VALUE, void**, swig_type_info *, int);
SWIGIMPORT(void *) SWIG_Ruby_MustGetPtr(VALUE, swig_type_info *, int, int);
SWIGIMPORT(int)    SWIG_Ruby_CheckConvert(VALUE, swig_type_info *);
SWIGIMPORT(VALUE)  SWIG_Ruby_NewPackedObj(void *ptr, int sz, swig_type_info *type);
SWIGIMPORT(void)   SWIG_Ruby_ConvertPacked(VALUE obj, void *ptr, int sz, swig_type_info *ty, int flags);

#ifdef __cplusplus
}
#endif


/* -------- TYPES TABLE (BEGIN) -------- */

#define  SWIGTYPE_p_FXObject swig_types[0] 
#define  SWIGTYPE_p_FXColorDialog swig_types[1] 
#define  SWIGTYPE_p_FXDirDialog swig_types[2] 
#define  SWIGTYPE_p_FXFontDialog swig_types[3] 
#define  SWIGTYPE_p_FXSearchDialog swig_types[4] 
#define  SWIGTYPE_p_FXInputDialog swig_types[5] 
#define  SWIGTYPE_p_FXPrintDialog swig_types[6] 
#define  SWIGTYPE_p_FXPrinter swig_types[7] 
#define  SWIGTYPE_p_FXMessageBox swig_types[8] 
#define  SWIGTYPE_p_FXWindow swig_types[9] 
#define  SWIGTYPE_p_FXTopWindow swig_types[10] 
#define  SWIGTYPE_p_FXComposite swig_types[11] 
#define  SWIGTYPE_p_FXId swig_types[12] 
#define  SWIGTYPE_p_FXShell swig_types[13] 
#define  SWIGTYPE_p_FXWizard swig_types[14] 
#define  SWIGTYPE_p_FXButton swig_types[15] 
#define  SWIGTYPE_p_FXStream swig_types[16] 
#define  SWIGTYPE_p_FXDrawable swig_types[17] 
#define  SWIGTYPE_p_FXHorizontalFrame swig_types[18] 
#define  SWIGTYPE_p_FXIcon swig_types[19] 
#define  SWIGTYPE_p_FXFileDialog swig_types[20] 
#define  SWIGTYPE_p_FXReplaceDialog swig_types[21] 
#define  SWIGTYPE_p_FXApp swig_types[22] 
#define  SWIGTYPE_p_FXProgressDialog swig_types[23] 
#define  SWIGTYPE_p_FXFontDesc swig_types[24] 
#define  SWIGTYPE_p_FXImage swig_types[25] 
#define  SWIGTYPE_p_FXDialogBox swig_types[26] 
#define  SWIGTYPE_p_FXSwitcher swig_types[27] 
static swig_type_info *swig_types[29];

/* -------- TYPES TABLE (END) -------- */

#define SWIG_init    Init_dialogs
#define SWIG_name    "Dialogs"


static void SWIG_AsVal(VALUE obj, int *val)
{
    *val = (int) NUM2INT(obj);
}


#include "FXRbCommon.h"


inline FXColor to_FXColor(VALUE obj){
  if(TYPE(obj)==T_STRING){
    return fxcolorfromname(StringValuePtr(obj));
    }
  else if(TYPE(obj)==T_SYMBOL){
    return fxcolorfromname(rb_id2name(SYM2ID(obj)));
    }
  else{
    return NUM2ULONG(obj);
    }
  }


inline FXString to_FXString(VALUE obj){
  if(!NIL_P(obj)){
    Check_Type(obj,T_STRING);
    return FXString(STR2CSTR(obj));
    }
  else{
    return FXString::null;
    }
  }


inline FXbool to_FXbool(VALUE obj){
  if (obj == Qtrue || obj == Qfalse){
    return (obj == Qtrue) ? TRUE : FALSE;
    }
  else{
    return static_cast<FXbool>(NUM2UINT(obj));
    }
  }


static swig_type_info* FXEventTypeInfo=0;

inline void* to_FXEvent(VALUE obj){
  void* ptr;
  if(!FXEventTypeInfo){
    FXEventTypeInfo=SWIG_TypeQuery("FXEvent *");
    FXASSERT(FXEventTypeInfo!=0);
    }
  SWIG_ConvertPtr(obj,&ptr,FXEventTypeInfo,1);
  return ptr;
  }

FXDialogBox *new_FXDialogBox__SWIG_0(FXApp *a,FXString const &name,FXuint opts,FXint x,FXint y,FXint w,FXint h,FXint pl,FXint pr,FXint pt,FXint pb,FXint hs,FXint vs){
      return new FXRbDialogBox(a,name,opts,x,y,w,h,pl,pr,pt,pb,hs,vs);
      }
FXDialogBox *new_FXDialogBox__SWIG_1(FXWindow *owner,FXString const &name,FXuint opts,FXint x,FXint y,FXint w,FXint h,FXint pl,FXint pr,FXint pt,FXint pb,FXint hs,FXint vs){
      return new FXRbDialogBox(owner,name,opts,x,y,w,h,pl,pr,pt,pb,hs,vs);
      }

swig_class cFXDialogBox;
static void free_FXDialogBox(FXDialogBox *);

static swig_type_info *FXDialogBox_dynamic_cast(void **ptr) {
    FXDialogBox **ppDialogBox = reinterpret_cast<FXDialogBox **>(ptr);
    FXColorDialog *pColorDialog=dynamic_cast<FXColorDialog*>(*ppDialogBox);
    if(pColorDialog){
      *ptr=reinterpret_cast<void*>(pColorDialog);
      return SWIG_TypeQuery("FXColorDialog *");
      }
    FXDirDialog *pDirDialog=dynamic_cast<FXDirDialog*>(*ppDialogBox);
    if(pDirDialog){
      *ptr=reinterpret_cast<void*>(pDirDialog);
      return SWIG_TypeQuery("FXDirDialog *");
      }
    FXFileDialog *pFileDialog=dynamic_cast<FXFileDialog*>(*ppDialogBox);
    if(pFileDialog){
      *ptr=reinterpret_cast<void*>(pFileDialog);
      return SWIG_TypeQuery("FXFileDialog *");
      }
    FXFontDialog *pFontDialog=dynamic_cast<FXFontDialog*>(*ppDialogBox);
    if(pFontDialog){
      *ptr=reinterpret_cast<void*>(pFontDialog);
      return SWIG_TypeQuery("FXFontDialog *");
      }
    FXInputDialog *pInputDialog=dynamic_cast<FXInputDialog*>(*ppDialogBox);
    if(pInputDialog){
      *ptr=reinterpret_cast<void*>(pInputDialog);
      return SWIG_TypeQuery("FXInputDialog *");
      }
    FXMessageBox *pMessageBox=dynamic_cast<FXMessageBox*>(*ppDialogBox);
    if(pMessageBox){
      *ptr=reinterpret_cast<void*>(pMessageBox);
      return SWIG_TypeQuery("FXMessageBox *");
      }
    FXPrintDialog *pPrintDialog=dynamic_cast<FXPrintDialog*>(*ppDialogBox);
    if(pPrintDialog){
      *ptr=reinterpret_cast<void*>(pPrintDialog);
      return SWIG_TypeQuery("FXPrintDialog *");
      }
    FXProgressDialog *pProgressDialog=dynamic_cast<FXProgressDialog*>(*ppDialogBox);
    if(pProgressDialog){
      *ptr=reinterpret_cast<void*>(pProgressDialog);
      return SWIG_TypeQuery("FXProgressDialog *");
      }
    FXReplaceDialog *pReplaceDialog=dynamic_cast<FXReplaceDialog*>(*ppDialogBox);
    if(pReplaceDialog){
      *ptr=reinterpret_cast<void*>(pReplaceDialog);
      return SWIG_TypeQuery("FXReplaceDialog *");
      }
    FXWizard *pWizard=dynamic_cast<FXWizard*>(*ppDialogBox);
    if(pWizard){
      *ptr=reinterpret_cast<void*>(pWizard);
      return SWIG_TypeQuery("FXWizard *");
      }
    return 0;
}

FXDirDialog *new_FXDirDialog(FXWindow *owner,FXString const &name,FXuint opts,FXint x,FXint y,FXint w,FXint h){
      return new FXRbDirDialog(owner,name,opts,x,y,w,h);
      }

swig_class cFXDirDialog;
static void free_FXDirDialog(FXDirDialog *);
FXFileDialog *new_FXFileDialog__SWIG_0(FXWindow *owner,FXString const &name,FXuint opts,FXint x,FXint y,FXint w,FXint h){
      return new FXRbFileDialog(owner,name,opts,x,y,w,h);
      }
FXFileDialog *new_FXFileDialog__SWIG_1(FXApp *a,FXString const &name,FXuint opts,FXint x,FXint y,FXint w,FXint h){
      return new FXRbFileDialog(a,name,opts,x,y,w,h);
      }
VALUE FXFileDialog_getFilenames(FXFileDialog const *self){
        VALUE result = rb_ary_new();
        FXString *filenames = self->getFilenames();
        if (filenames) {
            register FXString *p = filenames;
            while ((*p) != FXString::null) {
                rb_ary_push(result, rb_str_new2((*p).text()));
		p++;
            }
	    delete [] filenames;
        }
        return result;
    }
void FXFileDialog_setPatternList(FXFileDialog *self,VALUE ary){
      FXString patterns;
      if(TYPE(ary)==T_STRING){
        patterns=FXString(STR2CSTR(ary));
        }
      else if(TYPE(ary)==T_ARRAY){
        for(long i=0; i<RARRAY(ary)->len; i++){
          VALUE obj=rb_ary_entry(ary,i);
          Check_Type(obj,T_STRING);
          patterns+=FXString(STR2CSTR(obj))+FXString("\n");
          }
        }
      else{
        rb_raise(rb_eArgError,"expected either a string, or an array of strings, as input");
        }
      self->setPatternList(patterns);
      }
VALUE FXFileDialog_getPatternList(FXFileDialog const *self){
      FXString pat;
      FXString patterns;
      VALUE ary;
      patterns=self->getPatternList();
      ary=rb_ary_new();
      for(FXint start=0;!(pat=patterns.section('\n',start)).empty();start++){
	rb_ary_push(ary,to_ruby(pat.text()));
        }
      return ary;
    }
VALUE FXFileDialog_getOpenFilenames(FXWindow *owner,FXString const &caption,FXString const &path,FXString const &patterns,FXint initial){
        VALUE result = rb_ary_new();
        FXString *filenames = FXFileDialog::getOpenFilenames(owner, caption,
          path, patterns, initial);
        if (filenames) {
            register FXString *p = filenames;
            while ((*p) != FXString::null) {
                rb_ary_push(result, rb_str_new2((*p).text()));
		p++;
            }
	    delete [] filenames;
        }
        return result;
    }

swig_class cFXFileDialog;
static void free_FXFileDialog(FXFileDialog *);
FXColorDialog *new_FXColorDialog(FXWindow *owner,FXString const &name,FXuint opts,FXint x,FXint y,FXint w,FXint h){
      return new FXRbColorDialog(owner,name,opts,x,y,w,h);
      }

swig_class cFXColorDialog;
static void free_FXColorDialog(FXColorDialog *);
FXFontDialog *new_FXFontDialog(FXWindow *owner,FXString const &name,FXuint opts,FXint x,FXint y,FXint w,FXint h){
      return new FXRbFontDialog(owner,name,opts,x,y,w,h);
      }
FXFontDesc FXFontDialog_getFontSelection(FXFontDialog const *self){
	FXFontDesc fontdesc;
	self->getFontSelection(fontdesc);
	return fontdesc;
    }

swig_class cFXFontDialog;
static void free_FXFontDialog(FXFontDialog *);
FXReplaceDialog *new_FXReplaceDialog(FXWindow *owner,FXString const &caption,FXIcon *ic,FXuint opts,FXint x,FXint y,FXint w,FXint h){
      return new FXRbReplaceDialog(owner,caption,ic,opts,x,y,w,h);
      }

swig_class cFXReplaceDialog;
static void free_FXReplaceDialog(FXReplaceDialog *);

static swig_type_info *FXReplaceDialog_dynamic_cast(void **ptr) {
    FXReplaceDialog **ppReplaceDialog = reinterpret_cast<FXReplaceDialog **>(ptr);
    FXSearchDialog *pSearchDialog=dynamic_cast<FXSearchDialog*>(*ppReplaceDialog);
    if(pSearchDialog){
      *ptr=reinterpret_cast<void*>(pSearchDialog);
      return SWIG_TypeQuery("FXSearchDialog *");
      }
    return 0;
}

FXSearchDialog *new_FXSearchDialog(FXWindow *owner,FXString const &caption,FXIcon *ic,FXuint opts,FXint x,FXint y,FXint w,FXint h){
      return new FXRbSearchDialog(owner,caption,ic,opts,x,y,w,h);
      }

swig_class cFXSearchDialog;
static void free_FXSearchDialog(FXSearchDialog *);
FXInputDialog *new_FXInputDialog(FXWindow *owner,FXString const &caption,FXString const &label,FXIcon *ic,FXuint opts,FXint x,FXint y,FXint w,FXint h){
      return new FXRbInputDialog(owner,caption,label,ic,opts,x,y,w,h);
      }
VALUE FXInputDialog_getLimits(FXInputDialog *self){
      FXdouble lo, hi;
      self->getLimits(lo, hi);
      VALUE result = rb_ary_new();
      rb_ary_push(result, rb_float_new(lo));
      rb_ary_push(result, rb_float_new(hi));
      return result;
    }
VALUE FXInputDialog_getString(FXString const &initial,FXWindow *owner,FXString const &caption,FXString const &label,FXIcon *ic){
      FXString result(initial);
      if(FXInputDialog::getString(result,owner,caption,label,ic)){
        return to_ruby(result);
        }
      else{
        return Qnil;
        }
      }
VALUE FXInputDialog_getInteger(FXint initial,FXWindow *owner,FXString const &caption,FXString const &label,FXIcon *ic,FXint lo,FXint hi){
      FXint result=initial;
      if(FXInputDialog::getInteger(result,owner,caption,label,ic,lo,hi)){
        return to_ruby(result);
        }
      else{
        return Qnil;
        }
      }
VALUE FXInputDialog_getReal(FXdouble initial,FXWindow *owner,FXString const &caption,FXString const &label,FXIcon *ic,FXdouble lo,FXdouble hi){
      FXdouble result=initial;
      if(FXInputDialog::getReal(result,owner,caption,label,ic,lo,hi)){
        return to_ruby(result);
        }
      else{
        return Qnil;
        }
      }

swig_class cFXInputDialog;
FXPrintDialog *new_FXPrintDialog(FXWindow *owner,FXString const &name,FXuint opts,FXint x,FXint y,FXint w,FXint h){
      return new FXRbPrintDialog(owner,name,opts,x,y,w,h);
      }
FXPrinter FXPrintDialog_getPrinter(FXPrintDialog *self){
	FXPrinter pr;
	self->getPrinter(pr);
	return pr;
    }

swig_class cFXPrintDialog;
static void free_FXPrintDialog(FXPrintDialog *);
FXProgressDialog *new_FXProgressDialog(FXWindow *owner,FXString const &caption,FXString const &label,FXuint opts,FXint x,FXint y,FXint w,FXint h){
      return new FXRbProgressDialog(owner,caption,label,opts,x,y,w,h);
      }

swig_class cFXProgressDialog;
static void free_FXProgressDialog(FXProgressDialog *);
FXMessageBox *new_FXMessageBox__SWIG_0(FXWindow *owner,FXString const &caption,FXString const &text,FXIcon *ic,FXuint opts,FXint x,FXint y){
      return new FXRbMessageBox(owner,caption,text,ic,opts,x,y);
      }
FXMessageBox *new_FXMessageBox__SWIG_1(FXApp *app,FXString const &caption,FXString const &text,FXIcon *ic,FXuint opts,FXint x,FXint y){
      return new FXRbMessageBox(app,caption,text,ic,opts,x,y);
      }

swig_class cFXMessageBox;
static void free_FXMessageBox(FXMessageBox *);
FXWizard *new_FXWizard__SWIG_0(FXApp *a,FXString const &name,FXImage *image,FXuint opts,FXint x,FXint y,FXint w,FXint h,FXint pl,FXint pr,FXint pt,FXint pb,FXint hs,FXint vs){
      return new FXRbWizard(a,name,image,opts,x,y,w,h,pl,pr,pt,pb,hs,vs);
      }
FXWizard *new_FXWizard__SWIG_1(FXWindow *owner,FXString const &name,FXImage *image,FXuint opts,FXint x,FXint y,FXint w,FXint h,FXint pl,FXint pr,FXint pt,FXint pb,FXint hs,FXint vs){
      return new FXRbWizard(owner,name,image,opts,x,y,w,h,pl,pr,pt,pb,hs,vs);
      }
void FXWizard_setCurrentPanel(FXWizard *self,FXint index){
      if(0<=index && index<self->getNumPanels()){
        self->setCurrentPanel(index);
        }
      else{
        rb_raise(rb_eIndexError,"panel index %d out of bounds",index);
        }
      }

swig_class cFXWizard;
static void free_FXWizard(FXWizard *);
static VALUE _wrap_FXDialogBox_onKeyPress(int argc, VALUE *argv, VALUE self) { FXDialogBox *arg1 = (FXDialogBox *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDialogBox, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onKeyPress(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXDialogBox_onKeyRelease(int argc, VALUE *argv, VALUE self) { FXDialogBox *arg1 = (FXDialogBox *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDialogBox, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onKeyRelease(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXDialogBox_onCmdAccept(int argc, VALUE *argv, VALUE self) { FXDialogBox *arg1 = (FXDialogBox *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDialogBox, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdAccept(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXDialogBox_onCmdCancel(int argc, VALUE *argv, VALUE self) { FXDialogBox *arg1 = (FXDialogBox *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDialogBox, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdCancel(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_new_FXDialogBox__SWIG_0(int argc, VALUE *argv, VALUE self) { FXApp *arg1 = (FXApp *) 0 ; FXString *arg2 = 0 ;
    FXuint arg3 = (FXuint) DECOR_TITLE|DECOR_BORDER ; FXint arg4 = (FXint) 0 ; FXint arg5 = (FXint) 0 ; FXint arg6 = (FXint) 0 ;
    FXint arg7 = (FXint) 0 ; FXint arg8 = (FXint) 10 ; FXint arg9 = (FXint) 10 ; FXint arg10 = (FXint) 10 ;
    FXint arg11 = (FXint) 10 ; FXint arg12 = (FXint) 4 ; FXint arg13 = (FXint) 4 ; FXDialogBox *result;
    SwigValueWrapper<FXString > p2 ; if ((argc < 2) || (argc > 13))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXApp, 1); p2 = to_FXString(argv[1]); arg2 = &p2; if (argc > 2) {
        arg3 = NUM2UINT(argv[2]); }  if (argc > 3) { arg4 = NUM2INT(argv[3]); }  if (argc > 4) { arg5 = NUM2INT(argv[4]); } 
    if (argc > 5) { arg6 = NUM2INT(argv[5]); }  if (argc > 6) { arg7 = NUM2INT(argv[6]); }  if (argc > 7) {
        arg8 = NUM2INT(argv[7]); }  if (argc > 8) { arg9 = NUM2INT(argv[8]); }  if (argc > 9) { arg10 = NUM2INT(argv[9]); } 
    if (argc > 10) { arg11 = NUM2INT(argv[10]); }  if (argc > 11) { arg12 = NUM2INT(argv[11]); }  if (argc > 12) {
        arg13 = NUM2INT(argv[12]); }  {
        result = (FXDialogBox *)new_FXDialogBox__SWIG_0(arg1,(FXString const &)*arg2,arg3,arg4,arg5,arg6,arg7,arg8,arg9,arg10,arg11,arg12,arg13);
        DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result); if(rb_block_given_p()){ rb_yield(self); }  }  return self; }
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE _wrap_FXDialogBox_allocate(VALUE self) {
#else
     static VALUE _wrap_FXDialogBox_allocate(int argc, VALUE *argv, VALUE self) {
#endif
         VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_FXDialogBox);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
         return vresult; }
static VALUE _wrap_new_FXDialogBox__SWIG_1(int argc, VALUE *argv, VALUE self) { FXWindow *arg1 = (FXWindow *) 0 ;
    FXString *arg2 = 0 ; FXuint arg3 = (FXuint) DECOR_TITLE|DECOR_BORDER ; FXint arg4 = (FXint) 0 ; FXint arg5 = (FXint) 0 ;
    FXint arg6 = (FXint) 0 ; FXint arg7 = (FXint) 0 ; FXint arg8 = (FXint) 10 ; FXint arg9 = (FXint) 10 ;
    FXint arg10 = (FXint) 10 ; FXint arg11 = (FXint) 10 ; FXint arg12 = (FXint) 4 ; FXint arg13 = (FXint) 4 ;
    FXDialogBox *result; SwigValueWrapper<FXString > p2 ; if ((argc < 2) || (argc > 13))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXWindow, 1); p2 = to_FXString(argv[1]); arg2 = &p2; if (argc > 2) {
        arg3 = NUM2UINT(argv[2]); }  if (argc > 3) { arg4 = NUM2INT(argv[3]); }  if (argc > 4) { arg5 = NUM2INT(argv[4]); } 
    if (argc > 5) { arg6 = NUM2INT(argv[5]); }  if (argc > 6) { arg7 = NUM2INT(argv[6]); }  if (argc > 7) {
        arg8 = NUM2INT(argv[7]); }  if (argc > 8) { arg9 = NUM2INT(argv[8]); }  if (argc > 9) { arg10 = NUM2INT(argv[9]); } 
    if (argc > 10) { arg11 = NUM2INT(argv[10]); }  if (argc > 11) { arg12 = NUM2INT(argv[11]); }  if (argc > 12) {
        arg13 = NUM2INT(argv[12]); }  {
        result = (FXDialogBox *)new_FXDialogBox__SWIG_1(arg1,(FXString const &)*arg2,arg3,arg4,arg5,arg6,arg7,arg8,arg9,arg10,arg11,arg12,arg13);
        DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result); if(rb_block_given_p()){ rb_yield(self); }  }  return self; }
static VALUE _wrap_new_FXDialogBox(int nargs, VALUE *args, VALUE self) { int argc; VALUE argv[13]; int ii; argc = nargs;
    for (ii = 0; (ii < argc) && (ii < 13); ii++) { argv[ii] = args[ii]; }  if ((argc >= 2) && (argc <= 13)) { int _v; {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXApp, 0) != -1)) ? 1 : 0; }
         if (_v) { { _v = (NIL_P(argv[1]) || TYPE(argv[1]) == T_STRING) ? 1 : 0; }  if (_v) { if (argc <= 2) {
                    return _wrap_new_FXDialogBox__SWIG_0(nargs, args, self);}  {
                    _v = ((TYPE(argv[2]) == T_FIXNUM) || (TYPE(argv[2]) == T_BIGNUM)) ? 1 : 0; }  if (_v) { if (argc <= 3) {
                        return _wrap_new_FXDialogBox__SWIG_0(nargs, args, self);}  {
                        _v = ((TYPE(argv[3]) == T_FIXNUM) || (TYPE(argv[3]) == T_BIGNUM)) ? 1 : 0; }  if (_v) { if (argc <= 4) {
                            return _wrap_new_FXDialogBox__SWIG_0(nargs, args, self);}  {
                            _v = ((TYPE(argv[4]) == T_FIXNUM) || (TYPE(argv[4]) == T_BIGNUM)) ? 1 : 0; }  if (_v) {
                            if (argc <= 5) { return _wrap_new_FXDialogBox__SWIG_0(nargs, args, self);}  {
                                _v = ((TYPE(argv[5]) == T_FIXNUM) || (TYPE(argv[5]) == T_BIGNUM)) ? 1 : 0; }  if (_v) {
                                if (argc <= 6) { return _wrap_new_FXDialogBox__SWIG_0(nargs, args, self);}  {
                                    _v = ((TYPE(argv[6]) == T_FIXNUM) || (TYPE(argv[6]) == T_BIGNUM)) ? 1 : 0; }  if (_v) {
                                    if (argc <= 7) { return _wrap_new_FXDialogBox__SWIG_0(nargs, args, self);}  {
                                        _v = ((TYPE(argv[7]) == T_FIXNUM) || (TYPE(argv[7]) == T_BIGNUM)) ? 1 : 0; }  if (_v) {
                                        if (argc <= 8) { return _wrap_new_FXDialogBox__SWIG_0(nargs, args, self);}  {
                                            _v = ((TYPE(argv[8]) == T_FIXNUM) || (TYPE(argv[8]) == T_BIGNUM)) ? 1 : 0; } 
                                        if (_v) { if (argc <= 9) { return _wrap_new_FXDialogBox__SWIG_0(nargs, args, self);}  {
                                                _v = ((TYPE(argv[9]) == T_FIXNUM) || (TYPE(argv[9]) == T_BIGNUM)) ? 1 : 0; } 
                                            if (_v) { if (argc <= 10) { return _wrap_new_FXDialogBox__SWIG_0(nargs, args, self);}
                                                 { _v = ((TYPE(argv[10]) == T_FIXNUM) || (TYPE(argv[10]) == T_BIGNUM)) ? 1 : 0; }
                                                 if (_v) { if (argc <= 11) {
                                                        return _wrap_new_FXDialogBox__SWIG_0(nargs, args, self);}  {
                                                        _v = ((TYPE(argv[11]) == T_FIXNUM) || (TYPE(argv[11]) == T_BIGNUM)) ? 1 : 0; }
                                                     if (_v) { if (argc <= 12) {
                                                            return _wrap_new_FXDialogBox__SWIG_0(nargs, args, self);}  {
                                                            _v = ((TYPE(argv[12]) == T_FIXNUM) || (TYPE(argv[12]) == T_BIGNUM)) ? 1 : 0; }
                                                         if (_v) { return _wrap_new_FXDialogBox__SWIG_0(nargs, args, self);}  }
                                                     }  }  }  }  }  }  }  }  }  }  }  }  if ((argc >= 2) && (argc <= 13)) {
        int _v; { void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXWindow, 0) != -1)) ? 1 : 0; }
         if (_v) { { _v = (NIL_P(argv[1]) || TYPE(argv[1]) == T_STRING) ? 1 : 0; }  if (_v) { if (argc <= 2) {
                    return _wrap_new_FXDialogBox__SWIG_1(nargs, args, self);}  {
                    _v = ((TYPE(argv[2]) == T_FIXNUM) || (TYPE(argv[2]) == T_BIGNUM)) ? 1 : 0; }  if (_v) { if (argc <= 3) {
                        return _wrap_new_FXDialogBox__SWIG_1(nargs, args, self);}  {
                        _v = ((TYPE(argv[3]) == T_FIXNUM) || (TYPE(argv[3]) == T_BIGNUM)) ? 1 : 0; }  if (_v) { if (argc <= 4) {
                            return _wrap_new_FXDialogBox__SWIG_1(nargs, args, self);}  {
                            _v = ((TYPE(argv[4]) == T_FIXNUM) || (TYPE(argv[4]) == T_BIGNUM)) ? 1 : 0; }  if (_v) {
                            if (argc <= 5) { return _wrap_new_FXDialogBox__SWIG_1(nargs, args, self);}  {
                                _v = ((TYPE(argv[5]) == T_FIXNUM) || (TYPE(argv[5]) == T_BIGNUM)) ? 1 : 0; }  if (_v) {
                                if (argc <= 6) { return _wrap_new_FXDialogBox__SWIG_1(nargs, args, self);}  {
                                    _v = ((TYPE(argv[6]) == T_FIXNUM) || (TYPE(argv[6]) == T_BIGNUM)) ? 1 : 0; }  if (_v) {
                                    if (argc <= 7) { return _wrap_new_FXDialogBox__SWIG_1(nargs, args, self);}  {
                                        _v = ((TYPE(argv[7]) == T_FIXNUM) || (TYPE(argv[7]) == T_BIGNUM)) ? 1 : 0; }  if (_v) {
                                        if (argc <= 8) { return _wrap_new_FXDialogBox__SWIG_1(nargs, args, self);}  {
                                            _v = ((TYPE(argv[8]) == T_FIXNUM) || (TYPE(argv[8]) == T_BIGNUM)) ? 1 : 0; } 
                                        if (_v) { if (argc <= 9) { return _wrap_new_FXDialogBox__SWIG_1(nargs, args, self);}  {
                                                _v = ((TYPE(argv[9]) == T_FIXNUM) || (TYPE(argv[9]) == T_BIGNUM)) ? 1 : 0; } 
                                            if (_v) { if (argc <= 10) { return _wrap_new_FXDialogBox__SWIG_1(nargs, args, self);}
                                                 { _v = ((TYPE(argv[10]) == T_FIXNUM) || (TYPE(argv[10]) == T_BIGNUM)) ? 1 : 0; }
                                                 if (_v) { if (argc <= 11) {
                                                        return _wrap_new_FXDialogBox__SWIG_1(nargs, args, self);}  {
                                                        _v = ((TYPE(argv[11]) == T_FIXNUM) || (TYPE(argv[11]) == T_BIGNUM)) ? 1 : 0; }
                                                     if (_v) { if (argc <= 12) {
                                                            return _wrap_new_FXDialogBox__SWIG_1(nargs, args, self);}  {
                                                            _v = ((TYPE(argv[12]) == T_FIXNUM) || (TYPE(argv[12]) == T_BIGNUM)) ? 1 : 0; }
                                                         if (_v) { return _wrap_new_FXDialogBox__SWIG_1(nargs, args, self);}  }
                                                     }  }  }  }  }  }  }  }  }  }  }  } 
    rb_raise(rb_eArgError, "No matching function for overloaded 'new_FXDialogBox'"); return Qnil; }
static void
free_FXDialogBox(FXDialogBox *arg1) {
    delete arg1;
}
static VALUE _wrap_FXDialogBox_save(int argc, VALUE *argv, VALUE self) { FXDialogBox *arg1 = (FXDialogBox *) 0 ;
    FXStream *arg2 = 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDialogBox, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXDialogBox_save((FXDialogBox const *)arg1,*arg2); return Qnil; }
static VALUE _wrap_FXDialogBox_load(int argc, VALUE *argv, VALUE self) { FXDialogBox *arg1 = (FXDialogBox *) 0 ;
    FXStream *arg2 = 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDialogBox, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXDialogBox_load(arg1,*arg2); return Qnil; }
static VALUE _wrap_FXDialogBox_create(int argc, VALUE *argv, VALUE self) { FXDialogBox *arg1 = (FXDialogBox *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDialogBox, 1); FXDialogBox_create(arg1); return Qnil; }
static VALUE _wrap_FXDialogBox_detach(int argc, VALUE *argv, VALUE self) { FXDialogBox *arg1 = (FXDialogBox *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDialogBox, 1); FXDialogBox_detach(arg1); return Qnil; }
static VALUE _wrap_FXDialogBox_destroy(int argc, VALUE *argv, VALUE self) { FXDialogBox *arg1 = (FXDialogBox *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDialogBox, 1); FXDialogBox_destroy(arg1); return Qnil; }
static VALUE _wrap_FXDialogBox_resize(int argc, VALUE *argv, VALUE self) { FXDialogBox *arg1 = (FXDialogBox *) 0 ; FXint arg2 ;
    FXint arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDialogBox, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    FXDialogBox_resize(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXDialogBox_getDefaultWidth(int argc, VALUE *argv, VALUE self) { FXDialogBox *arg1 = (FXDialogBox *) 0 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDialogBox, 1); result = (FXint)FXDialogBox_getDefaultWidth(arg1);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXDialogBox_getDefaultHeight(int argc, VALUE *argv, VALUE self) { FXDialogBox *arg1 = (FXDialogBox *) 0 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDialogBox, 1); result = (FXint)FXDialogBox_getDefaultHeight(arg1);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXDialogBox_getWidthForHeight(int argc, VALUE *argv, VALUE self) { FXDialogBox *arg1 = (FXDialogBox *) 0 ;
    FXint arg2 ; FXint result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDialogBox, 1); arg2 = NUM2INT(argv[0]);
    result = (FXint)FXDialogBox_getWidthForHeight(arg1,arg2); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXDialogBox_getHeightForWidth(int argc, VALUE *argv, VALUE self) { FXDialogBox *arg1 = (FXDialogBox *) 0 ;
    FXint arg2 ; FXint result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDialogBox, 1); arg2 = NUM2INT(argv[0]);
    result = (FXint)FXDialogBox_getHeightForWidth(arg1,arg2); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXDialogBox_canFocus(int argc, VALUE *argv, VALUE self) { FXDialogBox *arg1 = (FXDialogBox *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDialogBox, 1);
    result = (FXbool)FXDialogBox_canFocus((FXDialogBox const *)arg1); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXDialogBox_setFocus(int argc, VALUE *argv, VALUE self) { FXDialogBox *arg1 = (FXDialogBox *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDialogBox, 1); FXDialogBox_setFocus(arg1); return Qnil; }
static VALUE _wrap_FXDialogBox_killFocus(int argc, VALUE *argv, VALUE self) { FXDialogBox *arg1 = (FXDialogBox *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDialogBox, 1); FXDialogBox_killFocus(arg1); return Qnil; }
static VALUE _wrap_FXDialogBox_setDefault(int argc, VALUE *argv, VALUE self) { FXDialogBox *arg1 = (FXDialogBox *) 0 ;
    FXbool arg2 = (FXbool) 1 ; if ((argc < 0) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDialogBox, 1); if (argc > 0) { arg2 = to_FXbool(argv[0]); } 
    FXDialogBox_setDefault(arg1,arg2); return Qnil; }
static VALUE _wrap_FXDialogBox_enable(int argc, VALUE *argv, VALUE self) { FXDialogBox *arg1 = (FXDialogBox *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDialogBox, 1); FXDialogBox_enable(arg1); return Qnil; }
static VALUE _wrap_FXDialogBox_disable(int argc, VALUE *argv, VALUE self) { FXDialogBox *arg1 = (FXDialogBox *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDialogBox, 1); FXDialogBox_disable(arg1); return Qnil; }
static VALUE _wrap_FXDialogBox_raiseWindow(int argc, VALUE *argv, VALUE self) { FXDialogBox *arg1 = (FXDialogBox *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDialogBox, 1); FXDialogBox_raise(arg1); return Qnil; }
static VALUE _wrap_FXDialogBox_lower(int argc, VALUE *argv, VALUE self) { FXDialogBox *arg1 = (FXDialogBox *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDialogBox, 1); FXDialogBox_lower(arg1); return Qnil; }
static VALUE _wrap_FXDialogBox_move(int argc, VALUE *argv, VALUE self) { FXDialogBox *arg1 = (FXDialogBox *) 0 ; FXint arg2 ;
    FXint arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDialogBox, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    FXDialogBox_move(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXDialogBox_position(int argc, VALUE *argv, VALUE self) { FXDialogBox *arg1 = (FXDialogBox *) 0 ;
    FXint arg2 ; FXint arg3 ; FXint arg4 ; FXint arg5 ; if ((argc < 4) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDialogBox, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    arg4 = NUM2INT(argv[2]); arg5 = NUM2INT(argv[3]); FXDialogBox_position(arg1,arg2,arg3,arg4,arg5); return Qnil; }
static VALUE _wrap_FXDialogBox_layout(int argc, VALUE *argv, VALUE self) { FXDialogBox *arg1 = (FXDialogBox *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDialogBox, 1); FXDialogBox_layout(arg1); return Qnil; }
static VALUE _wrap_FXDialogBox_recalc(int argc, VALUE *argv, VALUE self) { FXDialogBox *arg1 = (FXDialogBox *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDialogBox, 1); FXDialogBox_recalc(arg1); return Qnil; }
static VALUE _wrap_FXDialogBox_reparent(int argc, VALUE *argv, VALUE self) { FXDialogBox *arg1 = (FXDialogBox *) 0 ;
    FXComposite *arg2 = (FXComposite *) 0 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDialogBox, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXComposite, 1); FXDialogBox_reparent(arg1,arg2); return Qnil; }
static VALUE _wrap_FXDialogBox_show__SWIG_0(int argc, VALUE *argv, VALUE self) { FXDialogBox *arg1 = (FXDialogBox *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDialogBox, 1); FXDialogBox_show(arg1); return Qnil; }
static VALUE _wrap_FXDialogBox_hide(int argc, VALUE *argv, VALUE self) { FXDialogBox *arg1 = (FXDialogBox *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDialogBox, 1); FXDialogBox_hide(arg1); return Qnil; }
static VALUE _wrap_FXDialogBox_isComposite(int argc, VALUE *argv, VALUE self) { FXDialogBox *arg1 = (FXDialogBox *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDialogBox, 1);
    result = (FXbool)FXDialogBox_isComposite((FXDialogBox const *)arg1); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXDialogBox_contains(int argc, VALUE *argv, VALUE self) { FXDialogBox *arg1 = (FXDialogBox *) 0 ;
    FXint arg2 ; FXint arg3 ; FXbool result; VALUE vresult = Qnil; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDialogBox, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    result = (FXbool)FXDialogBox_contains((FXDialogBox const *)arg1,arg2,arg3); vresult = result ? Qtrue : Qfalse;
    return vresult; }
static VALUE _wrap_FXDialogBox_doesSaveUnder(int argc, VALUE *argv, VALUE self) { FXDialogBox *arg1 = (FXDialogBox *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDialogBox, 1);
    result = (FXbool)FXDialogBox_doesSaveUnder((FXDialogBox const *)arg1); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXDialogBox_setBackColor(int argc, VALUE *argv, VALUE self) { FXDialogBox *arg1 = (FXDialogBox *) 0 ;
    FXColor arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDialogBox, 1); arg2 = to_FXColor(argv[0]);
    FXDialogBox_setBackColor(arg1,arg2); return Qnil; }
static VALUE _wrap_FXDialogBox_show__SWIG_1(int argc, VALUE *argv, VALUE self) { FXDialogBox *arg1 = (FXDialogBox *) 0 ;
    FXuint arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDialogBox, 1); arg2 = NUM2UINT(argv[0]); FXDialogBox_show(arg1,arg2);
    return Qnil; }
static VALUE _wrap_FXDialogBox_show(int nargs, VALUE *args, VALUE self) { int argc; VALUE argv[3]; int ii; argc = nargs + 1;
    argv[0] = self; for (ii = 1; (ii < argc) && (ii < 2); ii++) { argv[ii] = args[ii-1]; }  if (argc == 1) { int _v; {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXDialogBox, 0) != -1)) ? 1 : 0; }
         if (_v) { return _wrap_FXDialogBox_show__SWIG_0(nargs, args, self);}  }  if (argc == 2) { int _v; { void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXDialogBox, 0) != -1)) ? 1 : 0; }
         if (_v) { { _v = ((TYPE(argv[1]) == T_FIXNUM) || (TYPE(argv[1]) == T_BIGNUM)) ? 1 : 0; }  if (_v) {
                return _wrap_FXDialogBox_show__SWIG_1(nargs, args, self);}  }  } 
    rb_raise(rb_eArgError, "No matching function for overloaded 'FXDialogBox_show'"); return Qnil; }
static VALUE _wrap_FXDialogBox_maximize(int argc, VALUE *argv, VALUE self) { FXDialogBox *arg1 = (FXDialogBox *) 0 ;
    FXbool arg2 = (FXbool) 0 ; FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDialogBox, 1); if (argc > 0) { arg2 = to_FXbool(argv[0]); } 
    result = (FXbool)FXDialogBox_maximize(arg1,arg2); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXDialogBox_minimize(int argc, VALUE *argv, VALUE self) { FXDialogBox *arg1 = (FXDialogBox *) 0 ;
    FXbool arg2 = (FXbool) 0 ; FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDialogBox, 1); if (argc > 0) { arg2 = to_FXbool(argv[0]); } 
    result = (FXbool)FXDialogBox_minimize(arg1,arg2); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXDialogBox_restore(int argc, VALUE *argv, VALUE self) { FXDialogBox *arg1 = (FXDialogBox *) 0 ;
    FXbool arg2 = (FXbool) 0 ; FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDialogBox, 1); if (argc > 0) { arg2 = to_FXbool(argv[0]); } 
    result = (FXbool)FXDialogBox_restore(arg1,arg2); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXDialogBox_close(int argc, VALUE *argv, VALUE self) { FXDialogBox *arg1 = (FXDialogBox *) 0 ;
    FXbool arg2 = (FXbool) 0 ; FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDialogBox, 1); if (argc > 0) { arg2 = to_FXbool(argv[0]); } 
    result = (FXbool)FXDialogBox_close(arg1,arg2); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXDialogBox_execute(int argc, VALUE *argv, VALUE self) { FXDialogBox *arg1 = (FXDialogBox *) 0 ;
    FXuint arg2 = (FXuint) PLACEMENT_CURSOR ; FXuint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDialogBox, 1); if (argc > 0) { arg2 = NUM2UINT(argv[0]); } 
    result = (FXuint)FXDialogBox_execute(arg1,arg2); vresult = UINT2NUM(result); return vresult; }
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE _wrap_FXDirDialog_allocate(VALUE self) {
#else
     static VALUE _wrap_FXDirDialog_allocate(int argc, VALUE *argv, VALUE self) {
#endif
         VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_FXDirDialog);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
         return vresult; }
static VALUE _wrap_new_FXDirDialog(int argc, VALUE *argv, VALUE self) { FXWindow *arg1 = (FXWindow *) 0 ; FXString *arg2 = 0 ;
    FXuint arg3 = (FXuint) 0 ; FXint arg4 = (FXint) 0 ; FXint arg5 = (FXint) 0 ; FXint arg6 = (FXint) 400 ;
    FXint arg7 = (FXint) 300 ; FXDirDialog *result; SwigValueWrapper<FXString > p2 ; if ((argc < 2) || (argc > 7))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXWindow, 1); p2 = to_FXString(argv[1]); arg2 = &p2; if (argc > 2) {
        arg3 = NUM2UINT(argv[2]); }  if (argc > 3) { arg4 = NUM2INT(argv[3]); }  if (argc > 4) { arg5 = NUM2INT(argv[4]); } 
    if (argc > 5) { arg6 = NUM2INT(argv[5]); }  if (argc > 6) { arg7 = NUM2INT(argv[6]); }  {
        result = (FXDirDialog *)new_FXDirDialog(arg1,(FXString const &)*arg2,arg3,arg4,arg5,arg6,arg7);
        DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result); if(rb_block_given_p()){ rb_yield(self); }  }  return self; }
static VALUE _wrap_FXDirDialog_setDirectory(int argc, VALUE *argv, VALUE self) { FXDirDialog *arg1 = (FXDirDialog *) 0 ;
    FXString *arg2 = 0 ; SwigValueWrapper<FXString > p2 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDirDialog, 1); p2 = to_FXString(argv[0]); arg2 = &p2;
    (arg1)->setDirectory((FXString const &)*arg2); return Qnil; }
static VALUE _wrap_FXDirDialog_getDirectory(int argc, VALUE *argv, VALUE self) { FXDirDialog *arg1 = (FXDirDialog *) 0 ;
    FXString result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDirDialog, 1); result = ((FXDirDialog const *)arg1)->getDirectory();
    vresult = rb_str_new2((&result)->text()); return vresult; }
static VALUE _wrap_FXDirDialog_setDirBoxStyle(int argc, VALUE *argv, VALUE self) { FXDirDialog *arg1 = (FXDirDialog *) 0 ;
    FXuint arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDirDialog, 1); arg2 = NUM2UINT(argv[0]); (arg1)->setDirBoxStyle(arg2);
    return Qnil; }
static VALUE _wrap_FXDirDialog_getDirBoxStyle(int argc, VALUE *argv, VALUE self) { FXDirDialog *arg1 = (FXDirDialog *) 0 ;
    FXuint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDirDialog, 1);
    result = (FXuint)((FXDirDialog const *)arg1)->getDirBoxStyle(); vresult = UINT2NUM(result); return vresult; }
static void
free_FXDirDialog(FXDirDialog *arg1) {
    delete arg1;
}
static VALUE _wrap_FXDirDialog_save(int argc, VALUE *argv, VALUE self) { FXDirDialog *arg1 = (FXDirDialog *) 0 ;
    FXStream *arg2 = 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDirDialog, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXDirDialog_save((FXDirDialog const *)arg1,*arg2); return Qnil; }
static VALUE _wrap_FXDirDialog_load(int argc, VALUE *argv, VALUE self) { FXDirDialog *arg1 = (FXDirDialog *) 0 ;
    FXStream *arg2 = 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDirDialog, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXDirDialog_load(arg1,*arg2); return Qnil; }
static VALUE _wrap_FXDirDialog_create(int argc, VALUE *argv, VALUE self) { FXDirDialog *arg1 = (FXDirDialog *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDirDialog, 1); FXDirDialog_create(arg1); return Qnil; }
static VALUE _wrap_FXDirDialog_detach(int argc, VALUE *argv, VALUE self) { FXDirDialog *arg1 = (FXDirDialog *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDirDialog, 1); FXDirDialog_detach(arg1); return Qnil; }
static VALUE _wrap_FXDirDialog_destroy(int argc, VALUE *argv, VALUE self) { FXDirDialog *arg1 = (FXDirDialog *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDirDialog, 1); FXDirDialog_destroy(arg1); return Qnil; }
static VALUE _wrap_FXDirDialog_resize(int argc, VALUE *argv, VALUE self) { FXDirDialog *arg1 = (FXDirDialog *) 0 ; FXint arg2 ;
    FXint arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDirDialog, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    FXDirDialog_resize(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXDirDialog_getDefaultWidth(int argc, VALUE *argv, VALUE self) { FXDirDialog *arg1 = (FXDirDialog *) 0 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDirDialog, 1); result = (FXint)FXDirDialog_getDefaultWidth(arg1);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXDirDialog_getDefaultHeight(int argc, VALUE *argv, VALUE self) { FXDirDialog *arg1 = (FXDirDialog *) 0 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDirDialog, 1); result = (FXint)FXDirDialog_getDefaultHeight(arg1);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXDirDialog_getWidthForHeight(int argc, VALUE *argv, VALUE self) { FXDirDialog *arg1 = (FXDirDialog *) 0 ;
    FXint arg2 ; FXint result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDirDialog, 1); arg2 = NUM2INT(argv[0]);
    result = (FXint)FXDirDialog_getWidthForHeight(arg1,arg2); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXDirDialog_getHeightForWidth(int argc, VALUE *argv, VALUE self) { FXDirDialog *arg1 = (FXDirDialog *) 0 ;
    FXint arg2 ; FXint result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDirDialog, 1); arg2 = NUM2INT(argv[0]);
    result = (FXint)FXDirDialog_getHeightForWidth(arg1,arg2); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXDirDialog_canFocus(int argc, VALUE *argv, VALUE self) { FXDirDialog *arg1 = (FXDirDialog *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDirDialog, 1);
    result = (FXbool)FXDirDialog_canFocus((FXDirDialog const *)arg1); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXDirDialog_setFocus(int argc, VALUE *argv, VALUE self) { FXDirDialog *arg1 = (FXDirDialog *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDirDialog, 1); FXDirDialog_setFocus(arg1); return Qnil; }
static VALUE _wrap_FXDirDialog_killFocus(int argc, VALUE *argv, VALUE self) { FXDirDialog *arg1 = (FXDirDialog *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDirDialog, 1); FXDirDialog_killFocus(arg1); return Qnil; }
static VALUE _wrap_FXDirDialog_setDefault(int argc, VALUE *argv, VALUE self) { FXDirDialog *arg1 = (FXDirDialog *) 0 ;
    FXbool arg2 = (FXbool) 1 ; if ((argc < 0) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDirDialog, 1); if (argc > 0) { arg2 = to_FXbool(argv[0]); } 
    FXDirDialog_setDefault(arg1,arg2); return Qnil; }
static VALUE _wrap_FXDirDialog_enable(int argc, VALUE *argv, VALUE self) { FXDirDialog *arg1 = (FXDirDialog *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDirDialog, 1); FXDirDialog_enable(arg1); return Qnil; }
static VALUE _wrap_FXDirDialog_disable(int argc, VALUE *argv, VALUE self) { FXDirDialog *arg1 = (FXDirDialog *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDirDialog, 1); FXDirDialog_disable(arg1); return Qnil; }
static VALUE _wrap_FXDirDialog_raiseWindow(int argc, VALUE *argv, VALUE self) { FXDirDialog *arg1 = (FXDirDialog *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDirDialog, 1); FXDirDialog_raise(arg1); return Qnil; }
static VALUE _wrap_FXDirDialog_lower(int argc, VALUE *argv, VALUE self) { FXDirDialog *arg1 = (FXDirDialog *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDirDialog, 1); FXDirDialog_lower(arg1); return Qnil; }
static VALUE _wrap_FXDirDialog_move(int argc, VALUE *argv, VALUE self) { FXDirDialog *arg1 = (FXDirDialog *) 0 ; FXint arg2 ;
    FXint arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDirDialog, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    FXDirDialog_move(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXDirDialog_position(int argc, VALUE *argv, VALUE self) { FXDirDialog *arg1 = (FXDirDialog *) 0 ;
    FXint arg2 ; FXint arg3 ; FXint arg4 ; FXint arg5 ; if ((argc < 4) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDirDialog, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    arg4 = NUM2INT(argv[2]); arg5 = NUM2INT(argv[3]); FXDirDialog_position(arg1,arg2,arg3,arg4,arg5); return Qnil; }
static VALUE _wrap_FXDirDialog_layout(int argc, VALUE *argv, VALUE self) { FXDirDialog *arg1 = (FXDirDialog *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDirDialog, 1); FXDirDialog_layout(arg1); return Qnil; }
static VALUE _wrap_FXDirDialog_recalc(int argc, VALUE *argv, VALUE self) { FXDirDialog *arg1 = (FXDirDialog *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDirDialog, 1); FXDirDialog_recalc(arg1); return Qnil; }
static VALUE _wrap_FXDirDialog_reparent(int argc, VALUE *argv, VALUE self) { FXDirDialog *arg1 = (FXDirDialog *) 0 ;
    FXComposite *arg2 = (FXComposite *) 0 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDirDialog, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXComposite, 1); FXDirDialog_reparent(arg1,arg2); return Qnil; }
static VALUE _wrap_FXDirDialog_show__SWIG_0(int argc, VALUE *argv, VALUE self) { FXDirDialog *arg1 = (FXDirDialog *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDirDialog, 1); FXDirDialog_show(arg1); return Qnil; }
static VALUE _wrap_FXDirDialog_hide(int argc, VALUE *argv, VALUE self) { FXDirDialog *arg1 = (FXDirDialog *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDirDialog, 1); FXDirDialog_hide(arg1); return Qnil; }
static VALUE _wrap_FXDirDialog_isComposite(int argc, VALUE *argv, VALUE self) { FXDirDialog *arg1 = (FXDirDialog *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDirDialog, 1);
    result = (FXbool)FXDirDialog_isComposite((FXDirDialog const *)arg1); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXDirDialog_contains(int argc, VALUE *argv, VALUE self) { FXDirDialog *arg1 = (FXDirDialog *) 0 ;
    FXint arg2 ; FXint arg3 ; FXbool result; VALUE vresult = Qnil; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDirDialog, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    result = (FXbool)FXDirDialog_contains((FXDirDialog const *)arg1,arg2,arg3); vresult = result ? Qtrue : Qfalse;
    return vresult; }
static VALUE _wrap_FXDirDialog_doesSaveUnder(int argc, VALUE *argv, VALUE self) { FXDirDialog *arg1 = (FXDirDialog *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDirDialog, 1);
    result = (FXbool)FXDirDialog_doesSaveUnder((FXDirDialog const *)arg1); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXDirDialog_setBackColor(int argc, VALUE *argv, VALUE self) { FXDirDialog *arg1 = (FXDirDialog *) 0 ;
    FXColor arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDirDialog, 1); arg2 = to_FXColor(argv[0]);
    FXDirDialog_setBackColor(arg1,arg2); return Qnil; }
static VALUE _wrap_FXDirDialog_show__SWIG_1(int argc, VALUE *argv, VALUE self) { FXDirDialog *arg1 = (FXDirDialog *) 0 ;
    FXuint arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDirDialog, 1); arg2 = NUM2UINT(argv[0]); FXDirDialog_show(arg1,arg2);
    return Qnil; }
static VALUE _wrap_FXDirDialog_show(int nargs, VALUE *args, VALUE self) { int argc; VALUE argv[3]; int ii; argc = nargs + 1;
    argv[0] = self; for (ii = 1; (ii < argc) && (ii < 2); ii++) { argv[ii] = args[ii-1]; }  if (argc == 1) { int _v; {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXDirDialog, 0) != -1)) ? 1 : 0; }
         if (_v) { return _wrap_FXDirDialog_show__SWIG_0(nargs, args, self);}  }  if (argc == 2) { int _v; { void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXDirDialog, 0) != -1)) ? 1 : 0; }
         if (_v) { { _v = ((TYPE(argv[1]) == T_FIXNUM) || (TYPE(argv[1]) == T_BIGNUM)) ? 1 : 0; }  if (_v) {
                return _wrap_FXDirDialog_show__SWIG_1(nargs, args, self);}  }  } 
    rb_raise(rb_eArgError, "No matching function for overloaded 'FXDirDialog_show'"); return Qnil; }
static VALUE _wrap_FXDirDialog_maximize(int argc, VALUE *argv, VALUE self) { FXDirDialog *arg1 = (FXDirDialog *) 0 ;
    FXbool arg2 = (FXbool) 0 ; FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDirDialog, 1); if (argc > 0) { arg2 = to_FXbool(argv[0]); } 
    result = (FXbool)FXDirDialog_maximize(arg1,arg2); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXDirDialog_minimize(int argc, VALUE *argv, VALUE self) { FXDirDialog *arg1 = (FXDirDialog *) 0 ;
    FXbool arg2 = (FXbool) 0 ; FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDirDialog, 1); if (argc > 0) { arg2 = to_FXbool(argv[0]); } 
    result = (FXbool)FXDirDialog_minimize(arg1,arg2); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXDirDialog_restore(int argc, VALUE *argv, VALUE self) { FXDirDialog *arg1 = (FXDirDialog *) 0 ;
    FXbool arg2 = (FXbool) 0 ; FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDirDialog, 1); if (argc > 0) { arg2 = to_FXbool(argv[0]); } 
    result = (FXbool)FXDirDialog_restore(arg1,arg2); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXDirDialog_close(int argc, VALUE *argv, VALUE self) { FXDirDialog *arg1 = (FXDirDialog *) 0 ;
    FXbool arg2 = (FXbool) 0 ; FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDirDialog, 1); if (argc > 0) { arg2 = to_FXbool(argv[0]); } 
    result = (FXbool)FXDirDialog_close(arg1,arg2); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXDirDialog_execute(int argc, VALUE *argv, VALUE self) { FXDirDialog *arg1 = (FXDirDialog *) 0 ;
    FXuint arg2 = (FXuint) PLACEMENT_CURSOR ; FXuint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXDirDialog, 1); if (argc > 0) { arg2 = NUM2UINT(argv[0]); } 
    result = (FXuint)FXDirDialog_execute(arg1,arg2); vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_new_FXFileDialog__SWIG_0(int argc, VALUE *argv, VALUE self) { FXWindow *arg1 = (FXWindow *) 0 ;
    FXString *arg2 = 0 ; FXuint arg3 = (FXuint) 0 ; FXint arg4 = (FXint) 0 ; FXint arg5 = (FXint) 0 ; FXint arg6 = (FXint) 500 ;
    FXint arg7 = (FXint) 300 ; FXFileDialog *result; SwigValueWrapper<FXString > p2 ; if ((argc < 2) || (argc > 7))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXWindow, 1); p2 = to_FXString(argv[1]); arg2 = &p2; if (argc > 2) {
        arg3 = NUM2UINT(argv[2]); }  if (argc > 3) { arg4 = NUM2INT(argv[3]); }  if (argc > 4) { arg5 = NUM2INT(argv[4]); } 
    if (argc > 5) { arg6 = NUM2INT(argv[5]); }  if (argc > 6) { arg7 = NUM2INT(argv[6]); }  {
        result = (FXFileDialog *)new_FXFileDialog__SWIG_0(arg1,(FXString const &)*arg2,arg3,arg4,arg5,arg6,arg7);
        DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result); if(rb_block_given_p()){ rb_yield(self); }  }  return self; }
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE _wrap_FXFileDialog_allocate(VALUE self) {
#else
     static VALUE _wrap_FXFileDialog_allocate(int argc, VALUE *argv, VALUE self) {
#endif
         VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_FXFileDialog);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
         return vresult; }
static VALUE _wrap_new_FXFileDialog__SWIG_1(int argc, VALUE *argv, VALUE self) { FXApp *arg1 = (FXApp *) 0 ;
    FXString *arg2 = 0 ; FXuint arg3 = (FXuint) 0 ; FXint arg4 = (FXint) 0 ; FXint arg5 = (FXint) 0 ; FXint arg6 = (FXint) 500 ;
    FXint arg7 = (FXint) 300 ; FXFileDialog *result; SwigValueWrapper<FXString > p2 ; if ((argc < 2) || (argc > 7))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXApp, 1); p2 = to_FXString(argv[1]); arg2 = &p2; if (argc > 2) {
        arg3 = NUM2UINT(argv[2]); }  if (argc > 3) { arg4 = NUM2INT(argv[3]); }  if (argc > 4) { arg5 = NUM2INT(argv[4]); } 
    if (argc > 5) { arg6 = NUM2INT(argv[5]); }  if (argc > 6) { arg7 = NUM2INT(argv[6]); }  {
        result = (FXFileDialog *)new_FXFileDialog__SWIG_1(arg1,(FXString const &)*arg2,arg3,arg4,arg5,arg6,arg7);
        DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result); if(rb_block_given_p()){ rb_yield(self); }  }  return self; }
static VALUE _wrap_new_FXFileDialog(int nargs, VALUE *args, VALUE self) { int argc; VALUE argv[7]; int ii; argc = nargs;
    for (ii = 0; (ii < argc) && (ii < 7); ii++) { argv[ii] = args[ii]; }  if ((argc >= 2) && (argc <= 7)) { int _v; { void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXWindow, 0) != -1)) ? 1 : 0; }
         if (_v) { { _v = (NIL_P(argv[1]) || TYPE(argv[1]) == T_STRING) ? 1 : 0; }  if (_v) { if (argc <= 2) {
                    return _wrap_new_FXFileDialog__SWIG_0(nargs, args, self);}  {
                    _v = ((TYPE(argv[2]) == T_FIXNUM) || (TYPE(argv[2]) == T_BIGNUM)) ? 1 : 0; }  if (_v) { if (argc <= 3) {
                        return _wrap_new_FXFileDialog__SWIG_0(nargs, args, self);}  {
                        _v = ((TYPE(argv[3]) == T_FIXNUM) || (TYPE(argv[3]) == T_BIGNUM)) ? 1 : 0; }  if (_v) { if (argc <= 4) {
                            return _wrap_new_FXFileDialog__SWIG_0(nargs, args, self);}  {
                            _v = ((TYPE(argv[4]) == T_FIXNUM) || (TYPE(argv[4]) == T_BIGNUM)) ? 1 : 0; }  if (_v) {
                            if (argc <= 5) { return _wrap_new_FXFileDialog__SWIG_0(nargs, args, self);}  {
                                _v = ((TYPE(argv[5]) == T_FIXNUM) || (TYPE(argv[5]) == T_BIGNUM)) ? 1 : 0; }  if (_v) {
                                if (argc <= 6) { return _wrap_new_FXFileDialog__SWIG_0(nargs, args, self);}  {
                                    _v = ((TYPE(argv[6]) == T_FIXNUM) || (TYPE(argv[6]) == T_BIGNUM)) ? 1 : 0; }  if (_v) {
                                    return _wrap_new_FXFileDialog__SWIG_0(nargs, args, self);}  }  }  }  }  }  }  } 
    if ((argc >= 2) && (argc <= 7)) { int _v; { void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXApp, 0) != -1)) ? 1 : 0; }
         if (_v) { { _v = (NIL_P(argv[1]) || TYPE(argv[1]) == T_STRING) ? 1 : 0; }  if (_v) { if (argc <= 2) {
                    return _wrap_new_FXFileDialog__SWIG_1(nargs, args, self);}  {
                    _v = ((TYPE(argv[2]) == T_FIXNUM) || (TYPE(argv[2]) == T_BIGNUM)) ? 1 : 0; }  if (_v) { if (argc <= 3) {
                        return _wrap_new_FXFileDialog__SWIG_1(nargs, args, self);}  {
                        _v = ((TYPE(argv[3]) == T_FIXNUM) || (TYPE(argv[3]) == T_BIGNUM)) ? 1 : 0; }  if (_v) { if (argc <= 4) {
                            return _wrap_new_FXFileDialog__SWIG_1(nargs, args, self);}  {
                            _v = ((TYPE(argv[4]) == T_FIXNUM) || (TYPE(argv[4]) == T_BIGNUM)) ? 1 : 0; }  if (_v) {
                            if (argc <= 5) { return _wrap_new_FXFileDialog__SWIG_1(nargs, args, self);}  {
                                _v = ((TYPE(argv[5]) == T_FIXNUM) || (TYPE(argv[5]) == T_BIGNUM)) ? 1 : 0; }  if (_v) {
                                if (argc <= 6) { return _wrap_new_FXFileDialog__SWIG_1(nargs, args, self);}  {
                                    _v = ((TYPE(argv[6]) == T_FIXNUM) || (TYPE(argv[6]) == T_BIGNUM)) ? 1 : 0; }  if (_v) {
                                    return _wrap_new_FXFileDialog__SWIG_1(nargs, args, self);}  }  }  }  }  }  }  } 
    rb_raise(rb_eArgError, "No matching function for overloaded 'new_FXFileDialog'"); return Qnil; }
static VALUE _wrap_FXFileDialog_setFilename(int argc, VALUE *argv, VALUE self) { FXFileDialog *arg1 = (FXFileDialog *) 0 ;
    FXString *arg2 = 0 ; SwigValueWrapper<FXString > p2 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileDialog, 1); p2 = to_FXString(argv[0]); arg2 = &p2;
    (arg1)->setFilename((FXString const &)*arg2); return Qnil; }
static VALUE _wrap_FXFileDialog_getFilename(int argc, VALUE *argv, VALUE self) { FXFileDialog *arg1 = (FXFileDialog *) 0 ;
    FXString result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileDialog, 1); result = ((FXFileDialog const *)arg1)->getFilename();
    vresult = rb_str_new2((&result)->text()); return vresult; }
static VALUE _wrap_FXFileDialog_getFilenames(int argc, VALUE *argv, VALUE self) { FXFileDialog *arg1 = (FXFileDialog *) 0 ;
    VALUE result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileDialog, 1);
    result = (VALUE)FXFileDialog_getFilenames((FXFileDialog const *)arg1); vresult = result; return vresult; }
static VALUE _wrap_FXFileDialog_setPattern(int argc, VALUE *argv, VALUE self) { FXFileDialog *arg1 = (FXFileDialog *) 0 ;
    FXString *arg2 = 0 ; SwigValueWrapper<FXString > p2 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileDialog, 1); p2 = to_FXString(argv[0]); arg2 = &p2;
    (arg1)->setPattern((FXString const &)*arg2); return Qnil; }
static VALUE _wrap_FXFileDialog_getPattern(int argc, VALUE *argv, VALUE self) { FXFileDialog *arg1 = (FXFileDialog *) 0 ;
    FXString result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileDialog, 1); result = ((FXFileDialog const *)arg1)->getPattern();
    vresult = rb_str_new2((&result)->text()); return vresult; }
static VALUE _wrap_FXFileDialog_setPatternList(int argc, VALUE *argv, VALUE self) { FXFileDialog *arg1 = (FXFileDialog *) 0 ;
    VALUE arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileDialog, 1); arg2 = argv[0]; FXFileDialog_setPatternList(arg1,arg2);
    return Qnil; }
static VALUE _wrap_FXFileDialog_getPatternList(int argc, VALUE *argv, VALUE self) { FXFileDialog *arg1 = (FXFileDialog *) 0 ;
    VALUE result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileDialog, 1);
    result = (VALUE)FXFileDialog_getPatternList((FXFileDialog const *)arg1); vresult = result; return vresult; }
static VALUE _wrap_FXFileDialog_setCurrentPattern(int argc, VALUE *argv, VALUE self) { FXFileDialog *arg1 = (FXFileDialog *) 0 ;
    FXint arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileDialog, 1); arg2 = NUM2INT(argv[0]);
    (arg1)->setCurrentPattern(arg2); return Qnil; }
static VALUE _wrap_FXFileDialog_getCurrentPattern(int argc, VALUE *argv, VALUE self) { FXFileDialog *arg1 = (FXFileDialog *) 0 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileDialog, 1);
    result = (FXint)((FXFileDialog const *)arg1)->getCurrentPattern(); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXFileDialog_getPatternText(int argc, VALUE *argv, VALUE self) { FXFileDialog *arg1 = (FXFileDialog *) 0 ;
    FXint arg2 ; FXString result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileDialog, 1); arg2 = NUM2INT(argv[0]);
    result = ((FXFileDialog const *)arg1)->getPatternText(arg2); vresult = rb_str_new2((&result)->text()); return vresult; }
static VALUE _wrap_FXFileDialog_setPatternText(int argc, VALUE *argv, VALUE self) { FXFileDialog *arg1 = (FXFileDialog *) 0 ;
    FXint arg2 ; FXString *arg3 = 0 ; SwigValueWrapper<FXString > p3 ; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileDialog, 1); arg2 = NUM2INT(argv[0]);
    p3 = to_FXString(argv[1]); arg3 = &p3; (arg1)->setPatternText(arg2,(FXString const &)*arg3); return Qnil; }
static VALUE _wrap_FXFileDialog_setDirectory(int argc, VALUE *argv, VALUE self) { FXFileDialog *arg1 = (FXFileDialog *) 0 ;
    FXString *arg2 = 0 ; SwigValueWrapper<FXString > p2 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileDialog, 1); p2 = to_FXString(argv[0]); arg2 = &p2;
    (arg1)->setDirectory((FXString const &)*arg2); return Qnil; }
static VALUE _wrap_FXFileDialog_getDirectory(int argc, VALUE *argv, VALUE self) { FXFileDialog *arg1 = (FXFileDialog *) 0 ;
    FXString result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileDialog, 1); result = ((FXFileDialog const *)arg1)->getDirectory();
    vresult = rb_str_new2((&result)->text()); return vresult; }
static VALUE _wrap_FXFileDialog_setItemSpace(int argc, VALUE *argv, VALUE self) { FXFileDialog *arg1 = (FXFileDialog *) 0 ;
    FXint arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileDialog, 1); arg2 = NUM2INT(argv[0]); (arg1)->setItemSpace(arg2);
    return Qnil; }
static VALUE _wrap_FXFileDialog_getItemSpace(int argc, VALUE *argv, VALUE self) { FXFileDialog *arg1 = (FXFileDialog *) 0 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileDialog, 1);
    result = (FXint)((FXFileDialog const *)arg1)->getItemSpace(); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXFileDialog_setFileBoxStyle(int argc, VALUE *argv, VALUE self) { FXFileDialog *arg1 = (FXFileDialog *) 0 ;
    FXuint arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileDialog, 1); arg2 = NUM2UINT(argv[0]); (arg1)->setFileBoxStyle(arg2);
    return Qnil; }
static VALUE _wrap_FXFileDialog_getFileBoxStyle(int argc, VALUE *argv, VALUE self) { FXFileDialog *arg1 = (FXFileDialog *) 0 ;
    FXuint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileDialog, 1);
    result = (FXuint)((FXFileDialog const *)arg1)->getFileBoxStyle(); vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXFileDialog_setSelectMode(int argc, VALUE *argv, VALUE self) { FXFileDialog *arg1 = (FXFileDialog *) 0 ;
    FXuint arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileDialog, 1); arg2 = NUM2UINT(argv[0]); (arg1)->setSelectMode(arg2);
    return Qnil; }
static VALUE _wrap_FXFileDialog_getSelectMode(int argc, VALUE *argv, VALUE self) { FXFileDialog *arg1 = (FXFileDialog *) 0 ;
    FXuint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileDialog, 1);
    result = (FXuint)((FXFileDialog const *)arg1)->getSelectMode(); vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXFileDialog_setMatchMode(int argc, VALUE *argv, VALUE self) { FXFileDialog *arg1 = (FXFileDialog *) 0 ;
    FXuint arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileDialog, 1); arg2 = NUM2UINT(argv[0]); (arg1)->setMatchMode(arg2);
    return Qnil; }
static VALUE _wrap_FXFileDialog_getMatchMode(int argc, VALUE *argv, VALUE self) { FXFileDialog *arg1 = (FXFileDialog *) 0 ;
    FXuint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileDialog, 1);
    result = (FXuint)((FXFileDialog const *)arg1)->getMatchMode(); vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXFileDialog_showReadOnly(int argc, VALUE *argv, VALUE self) { FXFileDialog *arg1 = (FXFileDialog *) 0 ;
    FXbool arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileDialog, 1); arg2 = to_FXbool(argv[0]); (arg1)->showReadOnly(arg2);
    return Qnil; }
static VALUE _wrap_FXFileDialog_shownReadOnly(int argc, VALUE *argv, VALUE self) { FXFileDialog *arg1 = (FXFileDialog *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileDialog, 1);
    result = (FXbool)((FXFileDialog const *)arg1)->shownReadOnly(); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXFileDialog_setReadOnly(int argc, VALUE *argv, VALUE self) { FXFileDialog *arg1 = (FXFileDialog *) 0 ;
    FXbool arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileDialog, 1); arg2 = to_FXbool(argv[0]); (arg1)->setReadOnly(arg2);
    return Qnil; }
static VALUE _wrap_FXFileDialog_getReadOnly(int argc, VALUE *argv, VALUE self) { FXFileDialog *arg1 = (FXFileDialog *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileDialog, 1);
    result = (FXbool)((FXFileDialog const *)arg1)->getReadOnly(); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXFileDialog_getOpenFilename(int argc, VALUE *argv, VALUE self) { FXWindow *arg1 = (FXWindow *) 0 ;
    FXString *arg2 = 0 ; FXString *arg3 = 0 ; FXString const &arg4_defvalue = "*" ;
    FXString *arg4 = (FXString *) &arg4_defvalue ; FXint arg5 = (FXint) 0 ; FXString result; SwigValueWrapper<FXString > p2 ;
    SwigValueWrapper<FXString > p3 ; SwigValueWrapper<FXString > p4 ; VALUE vresult = Qnil; if ((argc < 3) || (argc > 5))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXWindow, 1); p2 = to_FXString(argv[1]); arg2 = &p2;
    p3 = to_FXString(argv[2]); arg3 = &p3; if (argc > 3) { p4 = to_FXString(argv[3]); arg4 = &p4; }  if (argc > 4) {
        arg5 = NUM2INT(argv[4]); } 
    result = FXFileDialog::getOpenFilename(arg1,(FXString const &)*arg2,(FXString const &)*arg3,(FXString const &)*arg4,arg5);
    vresult = rb_str_new2((&result)->text()); return vresult; }
static VALUE _wrap_FXFileDialog_getOpenFilenames(int argc, VALUE *argv, VALUE self) { FXWindow *arg1 = (FXWindow *) 0 ;
    FXString *arg2 = 0 ; FXString *arg3 = 0 ; FXString const &arg4_defvalue = "*" ;
    FXString *arg4 = (FXString *) &arg4_defvalue ; FXint arg5 = (FXint) 0 ; VALUE result; SwigValueWrapper<FXString > p2 ;
    SwigValueWrapper<FXString > p3 ; SwigValueWrapper<FXString > p4 ; VALUE vresult = Qnil; if ((argc < 3) || (argc > 5))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXWindow, 1); p2 = to_FXString(argv[1]); arg2 = &p2;
    p3 = to_FXString(argv[2]); arg3 = &p3; if (argc > 3) { p4 = to_FXString(argv[3]); arg4 = &p4; }  if (argc > 4) {
        arg5 = NUM2INT(argv[4]); } 
    result = (VALUE)FXFileDialog_getOpenFilenames(arg1,(FXString const &)*arg2,(FXString const &)*arg3,(FXString const &)*arg4,arg5);
    vresult = result; return vresult; }
static VALUE _wrap_FXFileDialog_getSaveFilename(int argc, VALUE *argv, VALUE self) { FXWindow *arg1 = (FXWindow *) 0 ;
    FXString *arg2 = 0 ; FXString *arg3 = 0 ; FXString const &arg4_defvalue = "*" ;
    FXString *arg4 = (FXString *) &arg4_defvalue ; FXint arg5 = (FXint) 0 ; FXString result; SwigValueWrapper<FXString > p2 ;
    SwigValueWrapper<FXString > p3 ; SwigValueWrapper<FXString > p4 ; VALUE vresult = Qnil; if ((argc < 3) || (argc > 5))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXWindow, 1); p2 = to_FXString(argv[1]); arg2 = &p2;
    p3 = to_FXString(argv[2]); arg3 = &p3; if (argc > 3) { p4 = to_FXString(argv[3]); arg4 = &p4; }  if (argc > 4) {
        arg5 = NUM2INT(argv[4]); } 
    result = FXFileDialog::getSaveFilename(arg1,(FXString const &)*arg2,(FXString const &)*arg3,(FXString const &)*arg4,arg5);
    vresult = rb_str_new2((&result)->text()); return vresult; }
static VALUE _wrap_FXFileDialog_getOpenDirectory(int argc, VALUE *argv, VALUE self) { FXWindow *arg1 = (FXWindow *) 0 ;
    FXString *arg2 = 0 ; FXString *arg3 = 0 ; FXString result; SwigValueWrapper<FXString > p2 ; SwigValueWrapper<FXString > p3 ;
    VALUE vresult = Qnil; if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXWindow, 1); p2 = to_FXString(argv[1]); arg2 = &p2;
    p3 = to_FXString(argv[2]); arg3 = &p3;
    result = FXFileDialog::getOpenDirectory(arg1,(FXString const &)*arg2,(FXString const &)*arg3);
    vresult = rb_str_new2((&result)->text()); return vresult; }
static void
free_FXFileDialog(FXFileDialog *arg1) {
    delete arg1;
}
static VALUE _wrap_FXFileDialog_save(int argc, VALUE *argv, VALUE self) { FXFileDialog *arg1 = (FXFileDialog *) 0 ;
    FXStream *arg2 = 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileDialog, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXFileDialog_save((FXFileDialog const *)arg1,*arg2); return Qnil; }
static VALUE _wrap_FXFileDialog_load(int argc, VALUE *argv, VALUE self) { FXFileDialog *arg1 = (FXFileDialog *) 0 ;
    FXStream *arg2 = 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileDialog, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXFileDialog_load(arg1,*arg2); return Qnil; }
static VALUE _wrap_FXFileDialog_create(int argc, VALUE *argv, VALUE self) { FXFileDialog *arg1 = (FXFileDialog *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileDialog, 1); FXFileDialog_create(arg1); return Qnil; }
static VALUE _wrap_FXFileDialog_detach(int argc, VALUE *argv, VALUE self) { FXFileDialog *arg1 = (FXFileDialog *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileDialog, 1); FXFileDialog_detach(arg1); return Qnil; }
static VALUE _wrap_FXFileDialog_destroy(int argc, VALUE *argv, VALUE self) { FXFileDialog *arg1 = (FXFileDialog *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileDialog, 1); FXFileDialog_destroy(arg1); return Qnil; }
static VALUE _wrap_FXFileDialog_resize(int argc, VALUE *argv, VALUE self) { FXFileDialog *arg1 = (FXFileDialog *) 0 ;
    FXint arg2 ; FXint arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileDialog, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    FXFileDialog_resize(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXFileDialog_getDefaultWidth(int argc, VALUE *argv, VALUE self) { FXFileDialog *arg1 = (FXFileDialog *) 0 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileDialog, 1); result = (FXint)FXFileDialog_getDefaultWidth(arg1);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXFileDialog_getDefaultHeight(int argc, VALUE *argv, VALUE self) { FXFileDialog *arg1 = (FXFileDialog *) 0 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileDialog, 1); result = (FXint)FXFileDialog_getDefaultHeight(arg1);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXFileDialog_getWidthForHeight(int argc, VALUE *argv, VALUE self) { FXFileDialog *arg1 = (FXFileDialog *) 0 ;
    FXint arg2 ; FXint result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileDialog, 1); arg2 = NUM2INT(argv[0]);
    result = (FXint)FXFileDialog_getWidthForHeight(arg1,arg2); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXFileDialog_getHeightForWidth(int argc, VALUE *argv, VALUE self) { FXFileDialog *arg1 = (FXFileDialog *) 0 ;
    FXint arg2 ; FXint result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileDialog, 1); arg2 = NUM2INT(argv[0]);
    result = (FXint)FXFileDialog_getHeightForWidth(arg1,arg2); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXFileDialog_canFocus(int argc, VALUE *argv, VALUE self) { FXFileDialog *arg1 = (FXFileDialog *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileDialog, 1);
    result = (FXbool)FXFileDialog_canFocus((FXFileDialog const *)arg1); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXFileDialog_setFocus(int argc, VALUE *argv, VALUE self) { FXFileDialog *arg1 = (FXFileDialog *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileDialog, 1); FXFileDialog_setFocus(arg1); return Qnil; }
static VALUE _wrap_FXFileDialog_killFocus(int argc, VALUE *argv, VALUE self) { FXFileDialog *arg1 = (FXFileDialog *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileDialog, 1); FXFileDialog_killFocus(arg1); return Qnil; }
static VALUE _wrap_FXFileDialog_setDefault(int argc, VALUE *argv, VALUE self) { FXFileDialog *arg1 = (FXFileDialog *) 0 ;
    FXbool arg2 = (FXbool) 1 ; if ((argc < 0) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileDialog, 1); if (argc > 0) { arg2 = to_FXbool(argv[0]); } 
    FXFileDialog_setDefault(arg1,arg2); return Qnil; }
static VALUE _wrap_FXFileDialog_enable(int argc, VALUE *argv, VALUE self) { FXFileDialog *arg1 = (FXFileDialog *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileDialog, 1); FXFileDialog_enable(arg1); return Qnil; }
static VALUE _wrap_FXFileDialog_disable(int argc, VALUE *argv, VALUE self) { FXFileDialog *arg1 = (FXFileDialog *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileDialog, 1); FXFileDialog_disable(arg1); return Qnil; }
static VALUE _wrap_FXFileDialog_raiseWindow(int argc, VALUE *argv, VALUE self) { FXFileDialog *arg1 = (FXFileDialog *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileDialog, 1); FXFileDialog_raise(arg1); return Qnil; }
static VALUE _wrap_FXFileDialog_lower(int argc, VALUE *argv, VALUE self) { FXFileDialog *arg1 = (FXFileDialog *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileDialog, 1); FXFileDialog_lower(arg1); return Qnil; }
static VALUE _wrap_FXFileDialog_move(int argc, VALUE *argv, VALUE self) { FXFileDialog *arg1 = (FXFileDialog *) 0 ; FXint arg2 ;
    FXint arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileDialog, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    FXFileDialog_move(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXFileDialog_position(int argc, VALUE *argv, VALUE self) { FXFileDialog *arg1 = (FXFileDialog *) 0 ;
    FXint arg2 ; FXint arg3 ; FXint arg4 ; FXint arg5 ; if ((argc < 4) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileDialog, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    arg4 = NUM2INT(argv[2]); arg5 = NUM2INT(argv[3]); FXFileDialog_position(arg1,arg2,arg3,arg4,arg5); return Qnil; }
static VALUE _wrap_FXFileDialog_layout(int argc, VALUE *argv, VALUE self) { FXFileDialog *arg1 = (FXFileDialog *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileDialog, 1); FXFileDialog_layout(arg1); return Qnil; }
static VALUE _wrap_FXFileDialog_recalc(int argc, VALUE *argv, VALUE self) { FXFileDialog *arg1 = (FXFileDialog *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileDialog, 1); FXFileDialog_recalc(arg1); return Qnil; }
static VALUE _wrap_FXFileDialog_reparent(int argc, VALUE *argv, VALUE self) { FXFileDialog *arg1 = (FXFileDialog *) 0 ;
    FXComposite *arg2 = (FXComposite *) 0 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileDialog, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXComposite, 1); FXFileDialog_reparent(arg1,arg2); return Qnil; }
static VALUE _wrap_FXFileDialog_show__SWIG_0(int argc, VALUE *argv, VALUE self) { FXFileDialog *arg1 = (FXFileDialog *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileDialog, 1); FXFileDialog_show(arg1); return Qnil; }
static VALUE _wrap_FXFileDialog_hide(int argc, VALUE *argv, VALUE self) { FXFileDialog *arg1 = (FXFileDialog *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileDialog, 1); FXFileDialog_hide(arg1); return Qnil; }
static VALUE _wrap_FXFileDialog_isComposite(int argc, VALUE *argv, VALUE self) { FXFileDialog *arg1 = (FXFileDialog *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileDialog, 1);
    result = (FXbool)FXFileDialog_isComposite((FXFileDialog const *)arg1); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXFileDialog_contains(int argc, VALUE *argv, VALUE self) { FXFileDialog *arg1 = (FXFileDialog *) 0 ;
    FXint arg2 ; FXint arg3 ; FXbool result; VALUE vresult = Qnil; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileDialog, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    result = (FXbool)FXFileDialog_contains((FXFileDialog const *)arg1,arg2,arg3); vresult = result ? Qtrue : Qfalse;
    return vresult; }
static VALUE _wrap_FXFileDialog_doesSaveUnder(int argc, VALUE *argv, VALUE self) { FXFileDialog *arg1 = (FXFileDialog *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileDialog, 1);
    result = (FXbool)FXFileDialog_doesSaveUnder((FXFileDialog const *)arg1); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXFileDialog_setBackColor(int argc, VALUE *argv, VALUE self) { FXFileDialog *arg1 = (FXFileDialog *) 0 ;
    FXColor arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileDialog, 1); arg2 = to_FXColor(argv[0]);
    FXFileDialog_setBackColor(arg1,arg2); return Qnil; }
static VALUE _wrap_FXFileDialog_show__SWIG_1(int argc, VALUE *argv, VALUE self) { FXFileDialog *arg1 = (FXFileDialog *) 0 ;
    FXuint arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileDialog, 1); arg2 = NUM2UINT(argv[0]); FXFileDialog_show(arg1,arg2);
    return Qnil; }
static VALUE _wrap_FXFileDialog_show(int nargs, VALUE *args, VALUE self) { int argc; VALUE argv[3]; int ii; argc = nargs + 1;
    argv[0] = self; for (ii = 1; (ii < argc) && (ii < 2); ii++) { argv[ii] = args[ii-1]; }  if (argc == 1) { int _v; {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXFileDialog, 0) != -1)) ? 1 : 0; }
         if (_v) { return _wrap_FXFileDialog_show__SWIG_0(nargs, args, self);}  }  if (argc == 2) { int _v; { void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXFileDialog, 0) != -1)) ? 1 : 0; }
         if (_v) { { _v = ((TYPE(argv[1]) == T_FIXNUM) || (TYPE(argv[1]) == T_BIGNUM)) ? 1 : 0; }  if (_v) {
                return _wrap_FXFileDialog_show__SWIG_1(nargs, args, self);}  }  } 
    rb_raise(rb_eArgError, "No matching function for overloaded 'FXFileDialog_show'"); return Qnil; }
static VALUE _wrap_FXFileDialog_maximize(int argc, VALUE *argv, VALUE self) { FXFileDialog *arg1 = (FXFileDialog *) 0 ;
    FXbool arg2 = (FXbool) 0 ; FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileDialog, 1); if (argc > 0) { arg2 = to_FXbool(argv[0]); } 
    result = (FXbool)FXFileDialog_maximize(arg1,arg2); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXFileDialog_minimize(int argc, VALUE *argv, VALUE self) { FXFileDialog *arg1 = (FXFileDialog *) 0 ;
    FXbool arg2 = (FXbool) 0 ; FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileDialog, 1); if (argc > 0) { arg2 = to_FXbool(argv[0]); } 
    result = (FXbool)FXFileDialog_minimize(arg1,arg2); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXFileDialog_restore(int argc, VALUE *argv, VALUE self) { FXFileDialog *arg1 = (FXFileDialog *) 0 ;
    FXbool arg2 = (FXbool) 0 ; FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileDialog, 1); if (argc > 0) { arg2 = to_FXbool(argv[0]); } 
    result = (FXbool)FXFileDialog_restore(arg1,arg2); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXFileDialog_close(int argc, VALUE *argv, VALUE self) { FXFileDialog *arg1 = (FXFileDialog *) 0 ;
    FXbool arg2 = (FXbool) 0 ; FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileDialog, 1); if (argc > 0) { arg2 = to_FXbool(argv[0]); } 
    result = (FXbool)FXFileDialog_close(arg1,arg2); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXFileDialog_execute(int argc, VALUE *argv, VALUE self) { FXFileDialog *arg1 = (FXFileDialog *) 0 ;
    FXuint arg2 = (FXuint) PLACEMENT_CURSOR ; FXuint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFileDialog, 1); if (argc > 0) { arg2 = NUM2UINT(argv[0]); } 
    result = (FXuint)FXFileDialog_execute(arg1,arg2); vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXColorDialog_onChgColor(int argc, VALUE *argv, VALUE self) { FXColorDialog *arg1 = (FXColorDialog *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorDialog, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]);
    arg4 = reinterpret_cast<void*>(NUM2UINT(argv[2])); result = (long)(arg1)->onChgColor(arg2,arg3,arg4);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXColorDialog_onCmdColor(int argc, VALUE *argv, VALUE self) { FXColorDialog *arg1 = (FXColorDialog *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorDialog, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]);
    arg4 = reinterpret_cast<void*>(NUM2UINT(argv[2])); result = (long)(arg1)->onCmdColor(arg2,arg3,arg4);
    vresult = INT2NUM(result); return vresult; }
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE _wrap_FXColorDialog_allocate(VALUE self) {
#else
     static VALUE _wrap_FXColorDialog_allocate(int argc, VALUE *argv, VALUE self) {
#endif
         VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_FXColorDialog);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
         return vresult; }
static VALUE _wrap_new_FXColorDialog(int argc, VALUE *argv, VALUE self) { FXWindow *arg1 = (FXWindow *) 0 ; FXString *arg2 = 0 ;
    FXuint arg3 = (FXuint) 0 ; FXint arg4 = (FXint) 0 ; FXint arg5 = (FXint) 0 ; FXint arg6 = (FXint) 0 ;
    FXint arg7 = (FXint) 0 ; FXColorDialog *result; SwigValueWrapper<FXString > p2 ; if ((argc < 2) || (argc > 7))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXWindow, 1); p2 = to_FXString(argv[1]); arg2 = &p2; if (argc > 2) {
        arg3 = NUM2UINT(argv[2]); }  if (argc > 3) { arg4 = NUM2INT(argv[3]); }  if (argc > 4) { arg5 = NUM2INT(argv[4]); } 
    if (argc > 5) { arg6 = NUM2INT(argv[5]); }  if (argc > 6) { arg7 = NUM2INT(argv[6]); }  {
        result = (FXColorDialog *)new_FXColorDialog(arg1,(FXString const &)*arg2,arg3,arg4,arg5,arg6,arg7);
        DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result); if(rb_block_given_p()){ rb_yield(self); }  }  return self; }
static VALUE _wrap_FXColorDialog_setRGBA(int argc, VALUE *argv, VALUE self) { FXColorDialog *arg1 = (FXColorDialog *) 0 ;
    FXColor arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorDialog, 1); arg2 = to_FXColor(argv[0]); (arg1)->setRGBA(arg2);
    return Qnil; }
static VALUE _wrap_FXColorDialog_getRGBA(int argc, VALUE *argv, VALUE self) { FXColorDialog *arg1 = (FXColorDialog *) 0 ;
    FXColor result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorDialog, 1);
    result = (FXColor)((FXColorDialog const *)arg1)->getRGBA(); vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXColorDialog_isOpaqueOnly(int argc, VALUE *argv, VALUE self) { FXColorDialog *arg1 = (FXColorDialog *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorDialog, 1);
    result = (FXbool)((FXColorDialog const *)arg1)->isOpaqueOnly(); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXColorDialog_setOpaqueOnly(int argc, VALUE *argv, VALUE self) { FXColorDialog *arg1 = (FXColorDialog *) 0 ;
    FXbool arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorDialog, 1); arg2 = to_FXbool(argv[0]); (arg1)->setOpaqueOnly(arg2);
    return Qnil; }
static void
free_FXColorDialog(FXColorDialog *arg1) {
    delete arg1;
}
static VALUE _wrap_FXColorDialog_save(int argc, VALUE *argv, VALUE self) { FXColorDialog *arg1 = (FXColorDialog *) 0 ;
    FXStream *arg2 = 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorDialog, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXColorDialog_save((FXColorDialog const *)arg1,*arg2); return Qnil; }
static VALUE _wrap_FXColorDialog_load(int argc, VALUE *argv, VALUE self) { FXColorDialog *arg1 = (FXColorDialog *) 0 ;
    FXStream *arg2 = 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorDialog, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXColorDialog_load(arg1,*arg2); return Qnil; }
static VALUE _wrap_FXColorDialog_create(int argc, VALUE *argv, VALUE self) { FXColorDialog *arg1 = (FXColorDialog *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorDialog, 1); FXColorDialog_create(arg1); return Qnil; }
static VALUE _wrap_FXColorDialog_detach(int argc, VALUE *argv, VALUE self) { FXColorDialog *arg1 = (FXColorDialog *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorDialog, 1); FXColorDialog_detach(arg1); return Qnil; }
static VALUE _wrap_FXColorDialog_destroy(int argc, VALUE *argv, VALUE self) { FXColorDialog *arg1 = (FXColorDialog *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorDialog, 1); FXColorDialog_destroy(arg1); return Qnil; }
static VALUE _wrap_FXColorDialog_resize(int argc, VALUE *argv, VALUE self) { FXColorDialog *arg1 = (FXColorDialog *) 0 ;
    FXint arg2 ; FXint arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorDialog, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    FXColorDialog_resize(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXColorDialog_getDefaultWidth(int argc, VALUE *argv, VALUE self) {
    FXColorDialog *arg1 = (FXColorDialog *) 0 ; FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorDialog, 1); result = (FXint)FXColorDialog_getDefaultWidth(arg1);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXColorDialog_getDefaultHeight(int argc, VALUE *argv, VALUE self) {
    FXColorDialog *arg1 = (FXColorDialog *) 0 ; FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorDialog, 1); result = (FXint)FXColorDialog_getDefaultHeight(arg1);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXColorDialog_getWidthForHeight(int argc, VALUE *argv, VALUE self) {
    FXColorDialog *arg1 = (FXColorDialog *) 0 ; FXint arg2 ; FXint result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorDialog, 1); arg2 = NUM2INT(argv[0]);
    result = (FXint)FXColorDialog_getWidthForHeight(arg1,arg2); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXColorDialog_getHeightForWidth(int argc, VALUE *argv, VALUE self) {
    FXColorDialog *arg1 = (FXColorDialog *) 0 ; FXint arg2 ; FXint result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorDialog, 1); arg2 = NUM2INT(argv[0]);
    result = (FXint)FXColorDialog_getHeightForWidth(arg1,arg2); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXColorDialog_canFocus(int argc, VALUE *argv, VALUE self) { FXColorDialog *arg1 = (FXColorDialog *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorDialog, 1);
    result = (FXbool)FXColorDialog_canFocus((FXColorDialog const *)arg1); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXColorDialog_setFocus(int argc, VALUE *argv, VALUE self) { FXColorDialog *arg1 = (FXColorDialog *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorDialog, 1); FXColorDialog_setFocus(arg1); return Qnil; }
static VALUE _wrap_FXColorDialog_killFocus(int argc, VALUE *argv, VALUE self) { FXColorDialog *arg1 = (FXColorDialog *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorDialog, 1); FXColorDialog_killFocus(arg1); return Qnil; }
static VALUE _wrap_FXColorDialog_setDefault(int argc, VALUE *argv, VALUE self) { FXColorDialog *arg1 = (FXColorDialog *) 0 ;
    FXbool arg2 = (FXbool) 1 ; if ((argc < 0) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorDialog, 1); if (argc > 0) { arg2 = to_FXbool(argv[0]); } 
    FXColorDialog_setDefault(arg1,arg2); return Qnil; }
static VALUE _wrap_FXColorDialog_enable(int argc, VALUE *argv, VALUE self) { FXColorDialog *arg1 = (FXColorDialog *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorDialog, 1); FXColorDialog_enable(arg1); return Qnil; }
static VALUE _wrap_FXColorDialog_disable(int argc, VALUE *argv, VALUE self) { FXColorDialog *arg1 = (FXColorDialog *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorDialog, 1); FXColorDialog_disable(arg1); return Qnil; }
static VALUE _wrap_FXColorDialog_raiseWindow(int argc, VALUE *argv, VALUE self) { FXColorDialog *arg1 = (FXColorDialog *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorDialog, 1); FXColorDialog_raise(arg1); return Qnil; }
static VALUE _wrap_FXColorDialog_lower(int argc, VALUE *argv, VALUE self) { FXColorDialog *arg1 = (FXColorDialog *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorDialog, 1); FXColorDialog_lower(arg1); return Qnil; }
static VALUE _wrap_FXColorDialog_move(int argc, VALUE *argv, VALUE self) { FXColorDialog *arg1 = (FXColorDialog *) 0 ;
    FXint arg2 ; FXint arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorDialog, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    FXColorDialog_move(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXColorDialog_position(int argc, VALUE *argv, VALUE self) { FXColorDialog *arg1 = (FXColorDialog *) 0 ;
    FXint arg2 ; FXint arg3 ; FXint arg4 ; FXint arg5 ; if ((argc < 4) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorDialog, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    arg4 = NUM2INT(argv[2]); arg5 = NUM2INT(argv[3]); FXColorDialog_position(arg1,arg2,arg3,arg4,arg5); return Qnil; }
static VALUE _wrap_FXColorDialog_layout(int argc, VALUE *argv, VALUE self) { FXColorDialog *arg1 = (FXColorDialog *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorDialog, 1); FXColorDialog_layout(arg1); return Qnil; }
static VALUE _wrap_FXColorDialog_recalc(int argc, VALUE *argv, VALUE self) { FXColorDialog *arg1 = (FXColorDialog *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorDialog, 1); FXColorDialog_recalc(arg1); return Qnil; }
static VALUE _wrap_FXColorDialog_reparent(int argc, VALUE *argv, VALUE self) { FXColorDialog *arg1 = (FXColorDialog *) 0 ;
    FXComposite *arg2 = (FXComposite *) 0 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorDialog, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXComposite, 1); FXColorDialog_reparent(arg1,arg2); return Qnil; }
static VALUE _wrap_FXColorDialog_show__SWIG_0(int argc, VALUE *argv, VALUE self) { FXColorDialog *arg1 = (FXColorDialog *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorDialog, 1); FXColorDialog_show(arg1); return Qnil; }
static VALUE _wrap_FXColorDialog_hide(int argc, VALUE *argv, VALUE self) { FXColorDialog *arg1 = (FXColorDialog *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorDialog, 1); FXColorDialog_hide(arg1); return Qnil; }
static VALUE _wrap_FXColorDialog_isComposite(int argc, VALUE *argv, VALUE self) { FXColorDialog *arg1 = (FXColorDialog *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorDialog, 1);
    result = (FXbool)FXColorDialog_isComposite((FXColorDialog const *)arg1); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXColorDialog_contains(int argc, VALUE *argv, VALUE self) { FXColorDialog *arg1 = (FXColorDialog *) 0 ;
    FXint arg2 ; FXint arg3 ; FXbool result; VALUE vresult = Qnil; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorDialog, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    result = (FXbool)FXColorDialog_contains((FXColorDialog const *)arg1,arg2,arg3); vresult = result ? Qtrue : Qfalse;
    return vresult; }
static VALUE _wrap_FXColorDialog_doesSaveUnder(int argc, VALUE *argv, VALUE self) { FXColorDialog *arg1 = (FXColorDialog *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorDialog, 1);
    result = (FXbool)FXColorDialog_doesSaveUnder((FXColorDialog const *)arg1); vresult = result ? Qtrue : Qfalse;
    return vresult; }
static VALUE _wrap_FXColorDialog_setBackColor(int argc, VALUE *argv, VALUE self) { FXColorDialog *arg1 = (FXColorDialog *) 0 ;
    FXColor arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorDialog, 1); arg2 = to_FXColor(argv[0]);
    FXColorDialog_setBackColor(arg1,arg2); return Qnil; }
static VALUE _wrap_FXColorDialog_show__SWIG_1(int argc, VALUE *argv, VALUE self) { FXColorDialog *arg1 = (FXColorDialog *) 0 ;
    FXuint arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorDialog, 1); arg2 = NUM2UINT(argv[0]);
    FXColorDialog_show(arg1,arg2); return Qnil; }
static VALUE _wrap_FXColorDialog_show(int nargs, VALUE *args, VALUE self) { int argc; VALUE argv[3]; int ii; argc = nargs + 1;
    argv[0] = self; for (ii = 1; (ii < argc) && (ii < 2); ii++) { argv[ii] = args[ii-1]; }  if (argc == 1) { int _v; {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXColorDialog, 0) != -1)) ? 1 : 0; }
         if (_v) { return _wrap_FXColorDialog_show__SWIG_0(nargs, args, self);}  }  if (argc == 2) { int _v; { void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXColorDialog, 0) != -1)) ? 1 : 0; }
         if (_v) { { _v = ((TYPE(argv[1]) == T_FIXNUM) || (TYPE(argv[1]) == T_BIGNUM)) ? 1 : 0; }  if (_v) {
                return _wrap_FXColorDialog_show__SWIG_1(nargs, args, self);}  }  } 
    rb_raise(rb_eArgError, "No matching function for overloaded 'FXColorDialog_show'"); return Qnil; }
static VALUE _wrap_FXColorDialog_maximize(int argc, VALUE *argv, VALUE self) { FXColorDialog *arg1 = (FXColorDialog *) 0 ;
    FXbool arg2 = (FXbool) 0 ; FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorDialog, 1); if (argc > 0) { arg2 = to_FXbool(argv[0]); } 
    result = (FXbool)FXColorDialog_maximize(arg1,arg2); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXColorDialog_minimize(int argc, VALUE *argv, VALUE self) { FXColorDialog *arg1 = (FXColorDialog *) 0 ;
    FXbool arg2 = (FXbool) 0 ; FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorDialog, 1); if (argc > 0) { arg2 = to_FXbool(argv[0]); } 
    result = (FXbool)FXColorDialog_minimize(arg1,arg2); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXColorDialog_restore(int argc, VALUE *argv, VALUE self) { FXColorDialog *arg1 = (FXColorDialog *) 0 ;
    FXbool arg2 = (FXbool) 0 ; FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorDialog, 1); if (argc > 0) { arg2 = to_FXbool(argv[0]); } 
    result = (FXbool)FXColorDialog_restore(arg1,arg2); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXColorDialog_close(int argc, VALUE *argv, VALUE self) { FXColorDialog *arg1 = (FXColorDialog *) 0 ;
    FXbool arg2 = (FXbool) 0 ; FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorDialog, 1); if (argc > 0) { arg2 = to_FXbool(argv[0]); } 
    result = (FXbool)FXColorDialog_close(arg1,arg2); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXColorDialog_execute(int argc, VALUE *argv, VALUE self) { FXColorDialog *arg1 = (FXColorDialog *) 0 ;
    FXuint arg2 = (FXuint) PLACEMENT_CURSOR ; FXuint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXColorDialog, 1); if (argc > 0) { arg2 = NUM2UINT(argv[0]); } 
    result = (FXuint)FXColorDialog_execute(arg1,arg2); vresult = UINT2NUM(result); return vresult; }
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE _wrap_FXFontDialog_allocate(VALUE self) {
#else
     static VALUE _wrap_FXFontDialog_allocate(int argc, VALUE *argv, VALUE self) {
#endif
         VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_FXFontDialog);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
         return vresult; }
static VALUE _wrap_new_FXFontDialog(int argc, VALUE *argv, VALUE self) { FXWindow *arg1 = (FXWindow *) 0 ; FXString *arg2 = 0 ;
    FXuint arg3 = (FXuint) 0 ; FXint arg4 = (FXint) 0 ; FXint arg5 = (FXint) 0 ; FXint arg6 = (FXint) 600 ;
    FXint arg7 = (FXint) 380 ; FXFontDialog *result; SwigValueWrapper<FXString > p2 ; if ((argc < 2) || (argc > 7))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXWindow, 1); p2 = to_FXString(argv[1]); arg2 = &p2; if (argc > 2) {
        arg3 = NUM2UINT(argv[2]); }  if (argc > 3) { arg4 = NUM2INT(argv[3]); }  if (argc > 4) { arg5 = NUM2INT(argv[4]); } 
    if (argc > 5) { arg6 = NUM2INT(argv[5]); }  if (argc > 6) { arg7 = NUM2INT(argv[6]); }  {
        result = (FXFontDialog *)new_FXFontDialog(arg1,(FXString const &)*arg2,arg3,arg4,arg5,arg6,arg7);
        DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result); if(rb_block_given_p()){ rb_yield(self); }  }  return self; }
static VALUE _wrap_FXFontDialog_setFontSelection(int argc, VALUE *argv, VALUE self) { FXFontDialog *arg1 = (FXFontDialog *) 0 ;
    FXFontDesc *arg2 = 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFontDialog, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXFontDesc, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    (arg1)->setFontSelection((FXFontDesc const &)*arg2); return Qnil; }
static VALUE _wrap_FXFontDialog_getFontSelection(int argc, VALUE *argv, VALUE self) { FXFontDialog *arg1 = (FXFontDialog *) 0 ;
    FXFontDesc result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFontDialog, 1);
    result = FXFontDialog_getFontSelection((FXFontDialog const *)arg1); { FXFontDesc* resultptr = new FXFontDesc(result);
        vresult = FXRbGetRubyObj(resultptr, "FXFontDesc *"); }  return vresult; }
static void
free_FXFontDialog(FXFontDialog *arg1) {
    delete arg1;
}
static VALUE _wrap_FXFontDialog_save(int argc, VALUE *argv, VALUE self) { FXFontDialog *arg1 = (FXFontDialog *) 0 ;
    FXStream *arg2 = 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFontDialog, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXFontDialog_save((FXFontDialog const *)arg1,*arg2); return Qnil; }
static VALUE _wrap_FXFontDialog_load(int argc, VALUE *argv, VALUE self) { FXFontDialog *arg1 = (FXFontDialog *) 0 ;
    FXStream *arg2 = 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFontDialog, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXFontDialog_load(arg1,*arg2); return Qnil; }
static VALUE _wrap_FXFontDialog_create(int argc, VALUE *argv, VALUE self) { FXFontDialog *arg1 = (FXFontDialog *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFontDialog, 1); FXFontDialog_create(arg1); return Qnil; }
static VALUE _wrap_FXFontDialog_detach(int argc, VALUE *argv, VALUE self) { FXFontDialog *arg1 = (FXFontDialog *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFontDialog, 1); FXFontDialog_detach(arg1); return Qnil; }
static VALUE _wrap_FXFontDialog_destroy(int argc, VALUE *argv, VALUE self) { FXFontDialog *arg1 = (FXFontDialog *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFontDialog, 1); FXFontDialog_destroy(arg1); return Qnil; }
static VALUE _wrap_FXFontDialog_resize(int argc, VALUE *argv, VALUE self) { FXFontDialog *arg1 = (FXFontDialog *) 0 ;
    FXint arg2 ; FXint arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFontDialog, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    FXFontDialog_resize(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXFontDialog_getDefaultWidth(int argc, VALUE *argv, VALUE self) { FXFontDialog *arg1 = (FXFontDialog *) 0 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFontDialog, 1); result = (FXint)FXFontDialog_getDefaultWidth(arg1);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXFontDialog_getDefaultHeight(int argc, VALUE *argv, VALUE self) { FXFontDialog *arg1 = (FXFontDialog *) 0 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFontDialog, 1); result = (FXint)FXFontDialog_getDefaultHeight(arg1);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXFontDialog_getWidthForHeight(int argc, VALUE *argv, VALUE self) { FXFontDialog *arg1 = (FXFontDialog *) 0 ;
    FXint arg2 ; FXint result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFontDialog, 1); arg2 = NUM2INT(argv[0]);
    result = (FXint)FXFontDialog_getWidthForHeight(arg1,arg2); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXFontDialog_getHeightForWidth(int argc, VALUE *argv, VALUE self) { FXFontDialog *arg1 = (FXFontDialog *) 0 ;
    FXint arg2 ; FXint result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFontDialog, 1); arg2 = NUM2INT(argv[0]);
    result = (FXint)FXFontDialog_getHeightForWidth(arg1,arg2); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXFontDialog_canFocus(int argc, VALUE *argv, VALUE self) { FXFontDialog *arg1 = (FXFontDialog *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFontDialog, 1);
    result = (FXbool)FXFontDialog_canFocus((FXFontDialog const *)arg1); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXFontDialog_setFocus(int argc, VALUE *argv, VALUE self) { FXFontDialog *arg1 = (FXFontDialog *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFontDialog, 1); FXFontDialog_setFocus(arg1); return Qnil; }
static VALUE _wrap_FXFontDialog_killFocus(int argc, VALUE *argv, VALUE self) { FXFontDialog *arg1 = (FXFontDialog *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFontDialog, 1); FXFontDialog_killFocus(arg1); return Qnil; }
static VALUE _wrap_FXFontDialog_setDefault(int argc, VALUE *argv, VALUE self) { FXFontDialog *arg1 = (FXFontDialog *) 0 ;
    FXbool arg2 = (FXbool) 1 ; if ((argc < 0) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFontDialog, 1); if (argc > 0) { arg2 = to_FXbool(argv[0]); } 
    FXFontDialog_setDefault(arg1,arg2); return Qnil; }
static VALUE _wrap_FXFontDialog_enable(int argc, VALUE *argv, VALUE self) { FXFontDialog *arg1 = (FXFontDialog *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFontDialog, 1); FXFontDialog_enable(arg1); return Qnil; }
static VALUE _wrap_FXFontDialog_disable(int argc, VALUE *argv, VALUE self) { FXFontDialog *arg1 = (FXFontDialog *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFontDialog, 1); FXFontDialog_disable(arg1); return Qnil; }
static VALUE _wrap_FXFontDialog_raiseWindow(int argc, VALUE *argv, VALUE self) { FXFontDialog *arg1 = (FXFontDialog *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFontDialog, 1); FXFontDialog_raise(arg1); return Qnil; }
static VALUE _wrap_FXFontDialog_lower(int argc, VALUE *argv, VALUE self) { FXFontDialog *arg1 = (FXFontDialog *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFontDialog, 1); FXFontDialog_lower(arg1); return Qnil; }
static VALUE _wrap_FXFontDialog_move(int argc, VALUE *argv, VALUE self) { FXFontDialog *arg1 = (FXFontDialog *) 0 ; FXint arg2 ;
    FXint arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFontDialog, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    FXFontDialog_move(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXFontDialog_position(int argc, VALUE *argv, VALUE self) { FXFontDialog *arg1 = (FXFontDialog *) 0 ;
    FXint arg2 ; FXint arg3 ; FXint arg4 ; FXint arg5 ; if ((argc < 4) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFontDialog, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    arg4 = NUM2INT(argv[2]); arg5 = NUM2INT(argv[3]); FXFontDialog_position(arg1,arg2,arg3,arg4,arg5); return Qnil; }
static VALUE _wrap_FXFontDialog_layout(int argc, VALUE *argv, VALUE self) { FXFontDialog *arg1 = (FXFontDialog *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFontDialog, 1); FXFontDialog_layout(arg1); return Qnil; }
static VALUE _wrap_FXFontDialog_recalc(int argc, VALUE *argv, VALUE self) { FXFontDialog *arg1 = (FXFontDialog *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFontDialog, 1); FXFontDialog_recalc(arg1); return Qnil; }
static VALUE _wrap_FXFontDialog_reparent(int argc, VALUE *argv, VALUE self) { FXFontDialog *arg1 = (FXFontDialog *) 0 ;
    FXComposite *arg2 = (FXComposite *) 0 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFontDialog, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXComposite, 1); FXFontDialog_reparent(arg1,arg2); return Qnil; }
static VALUE _wrap_FXFontDialog_show__SWIG_0(int argc, VALUE *argv, VALUE self) { FXFontDialog *arg1 = (FXFontDialog *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFontDialog, 1); FXFontDialog_show(arg1); return Qnil; }
static VALUE _wrap_FXFontDialog_hide(int argc, VALUE *argv, VALUE self) { FXFontDialog *arg1 = (FXFontDialog *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFontDialog, 1); FXFontDialog_hide(arg1); return Qnil; }
static VALUE _wrap_FXFontDialog_isComposite(int argc, VALUE *argv, VALUE self) { FXFontDialog *arg1 = (FXFontDialog *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFontDialog, 1);
    result = (FXbool)FXFontDialog_isComposite((FXFontDialog const *)arg1); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXFontDialog_contains(int argc, VALUE *argv, VALUE self) { FXFontDialog *arg1 = (FXFontDialog *) 0 ;
    FXint arg2 ; FXint arg3 ; FXbool result; VALUE vresult = Qnil; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFontDialog, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    result = (FXbool)FXFontDialog_contains((FXFontDialog const *)arg1,arg2,arg3); vresult = result ? Qtrue : Qfalse;
    return vresult; }
static VALUE _wrap_FXFontDialog_doesSaveUnder(int argc, VALUE *argv, VALUE self) { FXFontDialog *arg1 = (FXFontDialog *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFontDialog, 1);
    result = (FXbool)FXFontDialog_doesSaveUnder((FXFontDialog const *)arg1); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXFontDialog_setBackColor(int argc, VALUE *argv, VALUE self) { FXFontDialog *arg1 = (FXFontDialog *) 0 ;
    FXColor arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFontDialog, 1); arg2 = to_FXColor(argv[0]);
    FXFontDialog_setBackColor(arg1,arg2); return Qnil; }
static VALUE _wrap_FXFontDialog_show__SWIG_1(int argc, VALUE *argv, VALUE self) { FXFontDialog *arg1 = (FXFontDialog *) 0 ;
    FXuint arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFontDialog, 1); arg2 = NUM2UINT(argv[0]); FXFontDialog_show(arg1,arg2);
    return Qnil; }
static VALUE _wrap_FXFontDialog_show(int nargs, VALUE *args, VALUE self) { int argc; VALUE argv[3]; int ii; argc = nargs + 1;
    argv[0] = self; for (ii = 1; (ii < argc) && (ii < 2); ii++) { argv[ii] = args[ii-1]; }  if (argc == 1) { int _v; {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXFontDialog, 0) != -1)) ? 1 : 0; }
         if (_v) { return _wrap_FXFontDialog_show__SWIG_0(nargs, args, self);}  }  if (argc == 2) { int _v; { void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXFontDialog, 0) != -1)) ? 1 : 0; }
         if (_v) { { _v = ((TYPE(argv[1]) == T_FIXNUM) || (TYPE(argv[1]) == T_BIGNUM)) ? 1 : 0; }  if (_v) {
                return _wrap_FXFontDialog_show__SWIG_1(nargs, args, self);}  }  } 
    rb_raise(rb_eArgError, "No matching function for overloaded 'FXFontDialog_show'"); return Qnil; }
static VALUE _wrap_FXFontDialog_maximize(int argc, VALUE *argv, VALUE self) { FXFontDialog *arg1 = (FXFontDialog *) 0 ;
    FXbool arg2 = (FXbool) 0 ; FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFontDialog, 1); if (argc > 0) { arg2 = to_FXbool(argv[0]); } 
    result = (FXbool)FXFontDialog_maximize(arg1,arg2); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXFontDialog_minimize(int argc, VALUE *argv, VALUE self) { FXFontDialog *arg1 = (FXFontDialog *) 0 ;
    FXbool arg2 = (FXbool) 0 ; FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFontDialog, 1); if (argc > 0) { arg2 = to_FXbool(argv[0]); } 
    result = (FXbool)FXFontDialog_minimize(arg1,arg2); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXFontDialog_restore(int argc, VALUE *argv, VALUE self) { FXFontDialog *arg1 = (FXFontDialog *) 0 ;
    FXbool arg2 = (FXbool) 0 ; FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFontDialog, 1); if (argc > 0) { arg2 = to_FXbool(argv[0]); } 
    result = (FXbool)FXFontDialog_restore(arg1,arg2); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXFontDialog_close(int argc, VALUE *argv, VALUE self) { FXFontDialog *arg1 = (FXFontDialog *) 0 ;
    FXbool arg2 = (FXbool) 0 ; FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFontDialog, 1); if (argc > 0) { arg2 = to_FXbool(argv[0]); } 
    result = (FXbool)FXFontDialog_close(arg1,arg2); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXFontDialog_execute(int argc, VALUE *argv, VALUE self) { FXFontDialog *arg1 = (FXFontDialog *) 0 ;
    FXuint arg2 = (FXuint) PLACEMENT_CURSOR ; FXuint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXFontDialog, 1); if (argc > 0) { arg2 = NUM2UINT(argv[0]); } 
    result = (FXuint)FXFontDialog_execute(arg1,arg2); vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXReplaceDialog_onCmdAll(int argc, VALUE *argv, VALUE self) { FXReplaceDialog *arg1 = (FXReplaceDialog *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXReplaceDialog, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdAll(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXReplaceDialog_onCmdNext(int argc, VALUE *argv, VALUE self) {
    FXReplaceDialog *arg1 = (FXReplaceDialog *) 0 ; FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ;
    void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil; if ((argc < 3) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXReplaceDialog, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdNext(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXReplaceDialog_onUpdDir(int argc, VALUE *argv, VALUE self) { FXReplaceDialog *arg1 = (FXReplaceDialog *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXReplaceDialog, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onUpdDir(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXReplaceDialog_onCmdDir(int argc, VALUE *argv, VALUE self) { FXReplaceDialog *arg1 = (FXReplaceDialog *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXReplaceDialog, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdDir(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXReplaceDialog_onUpdMode(int argc, VALUE *argv, VALUE self) {
    FXReplaceDialog *arg1 = (FXReplaceDialog *) 0 ; FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ;
    void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil; if ((argc < 3) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXReplaceDialog, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onUpdMode(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXReplaceDialog_onCmdMode(int argc, VALUE *argv, VALUE self) {
    FXReplaceDialog *arg1 = (FXReplaceDialog *) 0 ; FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ;
    void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil; if ((argc < 3) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXReplaceDialog, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdMode(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXReplaceDialog_onSearchKey(int argc, VALUE *argv, VALUE self) {
    FXReplaceDialog *arg1 = (FXReplaceDialog *) 0 ; FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ;
    void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil; if ((argc < 3) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXReplaceDialog, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onSearchKey(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXReplaceDialog_onReplaceKey(int argc, VALUE *argv, VALUE self) {
    FXReplaceDialog *arg1 = (FXReplaceDialog *) 0 ; FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ;
    void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil; if ((argc < 3) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXReplaceDialog, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onReplaceKey(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXReplaceDialog_onCmdSearchHist(int argc, VALUE *argv, VALUE self) {
    FXReplaceDialog *arg1 = (FXReplaceDialog *) 0 ; FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ;
    void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil; if ((argc < 3) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXReplaceDialog, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdSearchHist(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXReplaceDialog_onCmdReplaceHist(int argc, VALUE *argv, VALUE self) {
    FXReplaceDialog *arg1 = (FXReplaceDialog *) 0 ; FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ;
    void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil; if ((argc < 3) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXReplaceDialog, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdReplaceHist(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXReplaceDialog_onCmdAccept(int argc, VALUE *argv, VALUE self) {
    FXReplaceDialog *arg1 = (FXReplaceDialog *) 0 ; FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ;
    void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil; if ((argc < 3) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXReplaceDialog, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdAccept(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE _wrap_FXReplaceDialog_allocate(VALUE self) {
#else
     static VALUE _wrap_FXReplaceDialog_allocate(int argc, VALUE *argv, VALUE self) {
#endif
         VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_FXReplaceDialog);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
         return vresult; }
static VALUE _wrap_new_FXReplaceDialog(int argc, VALUE *argv, VALUE self) { FXWindow *arg1 = (FXWindow *) 0 ;
    FXString *arg2 = 0 ; FXIcon *arg3 = (FXIcon *) 0 ; FXuint arg4 = (FXuint) 0 ; FXint arg5 = (FXint) 0 ;
    FXint arg6 = (FXint) 0 ; FXint arg7 = (FXint) 0 ; FXint arg8 = (FXint) 0 ; FXReplaceDialog *result;
    SwigValueWrapper<FXString > p2 ; if ((argc < 2) || (argc > 8))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXWindow, 1); p2 = to_FXString(argv[1]); arg2 = &p2; if (argc > 2) {
        SWIG_ConvertPtr(argv[2], (void **) &arg3, SWIGTYPE_p_FXIcon, 1); }  if (argc > 3) { arg4 = NUM2UINT(argv[3]); } 
    if (argc > 4) { arg5 = NUM2INT(argv[4]); }  if (argc > 5) { arg6 = NUM2INT(argv[5]); }  if (argc > 6) {
        arg7 = NUM2INT(argv[6]); }  if (argc > 7) { arg8 = NUM2INT(argv[7]); }  {
        result = (FXReplaceDialog *)new_FXReplaceDialog(arg1,(FXString const &)*arg2,arg3,arg4,arg5,arg6,arg7,arg8);
        DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result); if(rb_block_given_p()){ rb_yield(self); }  }  return self; }
static VALUE _wrap_FXReplaceDialog_setSearchText(int argc, VALUE *argv, VALUE self) {
    FXReplaceDialog *arg1 = (FXReplaceDialog *) 0 ; FXString *arg2 = 0 ; SwigValueWrapper<FXString > p2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXReplaceDialog, 1); p2 = to_FXString(argv[0]); arg2 = &p2;
    (arg1)->setSearchText((FXString const &)*arg2); return Qnil; }
static VALUE _wrap_FXReplaceDialog_getSearchText(int argc, VALUE *argv, VALUE self) {
    FXReplaceDialog *arg1 = (FXReplaceDialog *) 0 ; FXString result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXReplaceDialog, 1);
    result = ((FXReplaceDialog const *)arg1)->getSearchText(); vresult = rb_str_new2((&result)->text()); return vresult; }
static VALUE _wrap_FXReplaceDialog_setReplaceText(int argc, VALUE *argv, VALUE self) {
    FXReplaceDialog *arg1 = (FXReplaceDialog *) 0 ; FXString *arg2 = 0 ; SwigValueWrapper<FXString > p2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXReplaceDialog, 1); p2 = to_FXString(argv[0]); arg2 = &p2;
    (arg1)->setReplaceText((FXString const &)*arg2); return Qnil; }
static VALUE _wrap_FXReplaceDialog_getReplaceText(int argc, VALUE *argv, VALUE self) {
    FXReplaceDialog *arg1 = (FXReplaceDialog *) 0 ; FXString result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXReplaceDialog, 1);
    result = ((FXReplaceDialog const *)arg1)->getReplaceText(); vresult = rb_str_new2((&result)->text()); return vresult; }
static VALUE _wrap_FXReplaceDialog_setSearchMode(int argc, VALUE *argv, VALUE self) {
    FXReplaceDialog *arg1 = (FXReplaceDialog *) 0 ; FXuint arg2 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXReplaceDialog, 1); arg2 = NUM2UINT(argv[0]);
    (arg1)->setSearchMode(arg2); return Qnil; }
static VALUE _wrap_FXReplaceDialog_getSearchMode(int argc, VALUE *argv, VALUE self) {
    FXReplaceDialog *arg1 = (FXReplaceDialog *) 0 ; FXuint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXReplaceDialog, 1);
    result = (FXuint)((FXReplaceDialog const *)arg1)->getSearchMode(); vresult = UINT2NUM(result); return vresult; }
static void
free_FXReplaceDialog(FXReplaceDialog *arg1) {
    delete arg1;
}
static VALUE _wrap_FXReplaceDialog_save(int argc, VALUE *argv, VALUE self) { FXReplaceDialog *arg1 = (FXReplaceDialog *) 0 ;
    FXStream *arg2 = 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXReplaceDialog, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXReplaceDialog_save((FXReplaceDialog const *)arg1,*arg2); return Qnil; }
static VALUE _wrap_FXReplaceDialog_load(int argc, VALUE *argv, VALUE self) { FXReplaceDialog *arg1 = (FXReplaceDialog *) 0 ;
    FXStream *arg2 = 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXReplaceDialog, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXReplaceDialog_load(arg1,*arg2); return Qnil; }
static VALUE _wrap_FXReplaceDialog_create(int argc, VALUE *argv, VALUE self) { FXReplaceDialog *arg1 = (FXReplaceDialog *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXReplaceDialog, 1); FXReplaceDialog_create(arg1); return Qnil; }
static VALUE _wrap_FXReplaceDialog_detach(int argc, VALUE *argv, VALUE self) { FXReplaceDialog *arg1 = (FXReplaceDialog *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXReplaceDialog, 1); FXReplaceDialog_detach(arg1); return Qnil; }
static VALUE _wrap_FXReplaceDialog_destroy(int argc, VALUE *argv, VALUE self) { FXReplaceDialog *arg1 = (FXReplaceDialog *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXReplaceDialog, 1); FXReplaceDialog_destroy(arg1); return Qnil; }
static VALUE _wrap_FXReplaceDialog_resize(int argc, VALUE *argv, VALUE self) { FXReplaceDialog *arg1 = (FXReplaceDialog *) 0 ;
    FXint arg2 ; FXint arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXReplaceDialog, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    FXReplaceDialog_resize(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXReplaceDialog_getDefaultWidth(int argc, VALUE *argv, VALUE self) {
    FXReplaceDialog *arg1 = (FXReplaceDialog *) 0 ; FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXReplaceDialog, 1);
    result = (FXint)FXReplaceDialog_getDefaultWidth(arg1); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXReplaceDialog_getDefaultHeight(int argc, VALUE *argv, VALUE self) {
    FXReplaceDialog *arg1 = (FXReplaceDialog *) 0 ; FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXReplaceDialog, 1);
    result = (FXint)FXReplaceDialog_getDefaultHeight(arg1); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXReplaceDialog_getWidthForHeight(int argc, VALUE *argv, VALUE self) {
    FXReplaceDialog *arg1 = (FXReplaceDialog *) 0 ; FXint arg2 ; FXint result; VALUE vresult = Qnil;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXReplaceDialog, 1); arg2 = NUM2INT(argv[0]);
    result = (FXint)FXReplaceDialog_getWidthForHeight(arg1,arg2); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXReplaceDialog_getHeightForWidth(int argc, VALUE *argv, VALUE self) {
    FXReplaceDialog *arg1 = (FXReplaceDialog *) 0 ; FXint arg2 ; FXint result; VALUE vresult = Qnil;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXReplaceDialog, 1); arg2 = NUM2INT(argv[0]);
    result = (FXint)FXReplaceDialog_getHeightForWidth(arg1,arg2); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXReplaceDialog_canFocus(int argc, VALUE *argv, VALUE self) { FXReplaceDialog *arg1 = (FXReplaceDialog *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXReplaceDialog, 1);
    result = (FXbool)FXReplaceDialog_canFocus((FXReplaceDialog const *)arg1); vresult = result ? Qtrue : Qfalse;
    return vresult; }
static VALUE _wrap_FXReplaceDialog_setFocus(int argc, VALUE *argv, VALUE self) { FXReplaceDialog *arg1 = (FXReplaceDialog *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXReplaceDialog, 1); FXReplaceDialog_setFocus(arg1); return Qnil; }
static VALUE _wrap_FXReplaceDialog_killFocus(int argc, VALUE *argv, VALUE self) {
    FXReplaceDialog *arg1 = (FXReplaceDialog *) 0 ; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXReplaceDialog, 1); FXReplaceDialog_killFocus(arg1); return Qnil; }
static VALUE _wrap_FXReplaceDialog_setDefault(int argc, VALUE *argv, VALUE self) {
    FXReplaceDialog *arg1 = (FXReplaceDialog *) 0 ; FXbool arg2 = (FXbool) 1 ; if ((argc < 0) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXReplaceDialog, 1); if (argc > 0) { arg2 = to_FXbool(argv[0]); } 
    FXReplaceDialog_setDefault(arg1,arg2); return Qnil; }
static VALUE _wrap_FXReplaceDialog_enable(int argc, VALUE *argv, VALUE self) { FXReplaceDialog *arg1 = (FXReplaceDialog *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXReplaceDialog, 1); FXReplaceDialog_enable(arg1); return Qnil; }
static VALUE _wrap_FXReplaceDialog_disable(int argc, VALUE *argv, VALUE self) { FXReplaceDialog *arg1 = (FXReplaceDialog *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXReplaceDialog, 1); FXReplaceDialog_disable(arg1); return Qnil; }
static VALUE _wrap_FXReplaceDialog_raiseWindow(int argc, VALUE *argv, VALUE self) {
    FXReplaceDialog *arg1 = (FXReplaceDialog *) 0 ; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXReplaceDialog, 1); FXReplaceDialog_raise(arg1); return Qnil; }
static VALUE _wrap_FXReplaceDialog_lower(int argc, VALUE *argv, VALUE self) { FXReplaceDialog *arg1 = (FXReplaceDialog *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXReplaceDialog, 1); FXReplaceDialog_lower(arg1); return Qnil; }
static VALUE _wrap_FXReplaceDialog_move(int argc, VALUE *argv, VALUE self) { FXReplaceDialog *arg1 = (FXReplaceDialog *) 0 ;
    FXint arg2 ; FXint arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXReplaceDialog, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    FXReplaceDialog_move(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXReplaceDialog_position(int argc, VALUE *argv, VALUE self) { FXReplaceDialog *arg1 = (FXReplaceDialog *) 0 ;
    FXint arg2 ; FXint arg3 ; FXint arg4 ; FXint arg5 ; if ((argc < 4) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXReplaceDialog, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    arg4 = NUM2INT(argv[2]); arg5 = NUM2INT(argv[3]); FXReplaceDialog_position(arg1,arg2,arg3,arg4,arg5); return Qnil; }
static VALUE _wrap_FXReplaceDialog_layout(int argc, VALUE *argv, VALUE self) { FXReplaceDialog *arg1 = (FXReplaceDialog *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXReplaceDialog, 1); FXReplaceDialog_layout(arg1); return Qnil; }
static VALUE _wrap_FXReplaceDialog_recalc(int argc, VALUE *argv, VALUE self) { FXReplaceDialog *arg1 = (FXReplaceDialog *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXReplaceDialog, 1); FXReplaceDialog_recalc(arg1); return Qnil; }
static VALUE _wrap_FXReplaceDialog_reparent(int argc, VALUE *argv, VALUE self) { FXReplaceDialog *arg1 = (FXReplaceDialog *) 0 ;
    FXComposite *arg2 = (FXComposite *) 0 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXReplaceDialog, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXComposite, 1); FXReplaceDialog_reparent(arg1,arg2); return Qnil; }
static VALUE _wrap_FXReplaceDialog_show__SWIG_0(int argc, VALUE *argv, VALUE self) {
    FXReplaceDialog *arg1 = (FXReplaceDialog *) 0 ; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXReplaceDialog, 1); FXReplaceDialog_show(arg1); return Qnil; }
static VALUE _wrap_FXReplaceDialog_hide(int argc, VALUE *argv, VALUE self) { FXReplaceDialog *arg1 = (FXReplaceDialog *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXReplaceDialog, 1); FXReplaceDialog_hide(arg1); return Qnil; }
static VALUE _wrap_FXReplaceDialog_isComposite(int argc, VALUE *argv, VALUE self) {
    FXReplaceDialog *arg1 = (FXReplaceDialog *) 0 ; FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXReplaceDialog, 1);
    result = (FXbool)FXReplaceDialog_isComposite((FXReplaceDialog const *)arg1); vresult = result ? Qtrue : Qfalse;
    return vresult; }
static VALUE _wrap_FXReplaceDialog_contains(int argc, VALUE *argv, VALUE self) { FXReplaceDialog *arg1 = (FXReplaceDialog *) 0 ;
    FXint arg2 ; FXint arg3 ; FXbool result; VALUE vresult = Qnil; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXReplaceDialog, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    result = (FXbool)FXReplaceDialog_contains((FXReplaceDialog const *)arg1,arg2,arg3); vresult = result ? Qtrue : Qfalse;
    return vresult; }
static VALUE _wrap_FXReplaceDialog_doesSaveUnder(int argc, VALUE *argv, VALUE self) {
    FXReplaceDialog *arg1 = (FXReplaceDialog *) 0 ; FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXReplaceDialog, 1);
    result = (FXbool)FXReplaceDialog_doesSaveUnder((FXReplaceDialog const *)arg1); vresult = result ? Qtrue : Qfalse;
    return vresult; }
static VALUE _wrap_FXReplaceDialog_setBackColor(int argc, VALUE *argv, VALUE self) {
    FXReplaceDialog *arg1 = (FXReplaceDialog *) 0 ; FXColor arg2 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXReplaceDialog, 1); arg2 = to_FXColor(argv[0]);
    FXReplaceDialog_setBackColor(arg1,arg2); return Qnil; }
static VALUE _wrap_FXReplaceDialog_show__SWIG_1(int argc, VALUE *argv, VALUE self) {
    FXReplaceDialog *arg1 = (FXReplaceDialog *) 0 ; FXuint arg2 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXReplaceDialog, 1); arg2 = NUM2UINT(argv[0]);
    FXReplaceDialog_show(arg1,arg2); return Qnil; }
static VALUE _wrap_FXReplaceDialog_show(int nargs, VALUE *args, VALUE self) { int argc; VALUE argv[3]; int ii; argc = nargs + 1;
    argv[0] = self; for (ii = 1; (ii < argc) && (ii < 2); ii++) { argv[ii] = args[ii-1]; }  if (argc == 1) { int _v; {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXReplaceDialog, 0) != -1)) ? 1 : 0; }
         if (_v) { return _wrap_FXReplaceDialog_show__SWIG_0(nargs, args, self);}  }  if (argc == 2) { int _v; { void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXReplaceDialog, 0) != -1)) ? 1 : 0; }
         if (_v) { { _v = ((TYPE(argv[1]) == T_FIXNUM) || (TYPE(argv[1]) == T_BIGNUM)) ? 1 : 0; }  if (_v) {
                return _wrap_FXReplaceDialog_show__SWIG_1(nargs, args, self);}  }  } 
    rb_raise(rb_eArgError, "No matching function for overloaded 'FXReplaceDialog_show'"); return Qnil; }
static VALUE _wrap_FXReplaceDialog_maximize(int argc, VALUE *argv, VALUE self) { FXReplaceDialog *arg1 = (FXReplaceDialog *) 0 ;
    FXbool arg2 = (FXbool) 0 ; FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXReplaceDialog, 1); if (argc > 0) { arg2 = to_FXbool(argv[0]); } 
    result = (FXbool)FXReplaceDialog_maximize(arg1,arg2); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXReplaceDialog_minimize(int argc, VALUE *argv, VALUE self) { FXReplaceDialog *arg1 = (FXReplaceDialog *) 0 ;
    FXbool arg2 = (FXbool) 0 ; FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXReplaceDialog, 1); if (argc > 0) { arg2 = to_FXbool(argv[0]); } 
    result = (FXbool)FXReplaceDialog_minimize(arg1,arg2); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXReplaceDialog_restore(int argc, VALUE *argv, VALUE self) { FXReplaceDialog *arg1 = (FXReplaceDialog *) 0 ;
    FXbool arg2 = (FXbool) 0 ; FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXReplaceDialog, 1); if (argc > 0) { arg2 = to_FXbool(argv[0]); } 
    result = (FXbool)FXReplaceDialog_restore(arg1,arg2); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXReplaceDialog_close(int argc, VALUE *argv, VALUE self) { FXReplaceDialog *arg1 = (FXReplaceDialog *) 0 ;
    FXbool arg2 = (FXbool) 0 ; FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXReplaceDialog, 1); if (argc > 0) { arg2 = to_FXbool(argv[0]); } 
    result = (FXbool)FXReplaceDialog_close(arg1,arg2); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXReplaceDialog_execute(int argc, VALUE *argv, VALUE self) { FXReplaceDialog *arg1 = (FXReplaceDialog *) 0 ;
    FXuint arg2 = (FXuint) PLACEMENT_CURSOR ; FXuint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXReplaceDialog, 1); if (argc > 0) { arg2 = NUM2UINT(argv[0]); } 
    result = (FXuint)FXReplaceDialog_execute(arg1,arg2); vresult = UINT2NUM(result); return vresult; }
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE _wrap_FXSearchDialog_allocate(VALUE self) {
#else
     static VALUE _wrap_FXSearchDialog_allocate(int argc, VALUE *argv, VALUE self) {
#endif
         VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_FXSearchDialog);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
         return vresult; }
static VALUE _wrap_new_FXSearchDialog(int argc, VALUE *argv, VALUE self) { FXWindow *arg1 = (FXWindow *) 0 ;
    FXString *arg2 = 0 ; FXIcon *arg3 = (FXIcon *) 0 ; FXuint arg4 = (FXuint) 0 ; FXint arg5 = (FXint) 0 ;
    FXint arg6 = (FXint) 0 ; FXint arg7 = (FXint) 0 ; FXint arg8 = (FXint) 0 ; FXSearchDialog *result;
    SwigValueWrapper<FXString > p2 ; if ((argc < 2) || (argc > 8))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXWindow, 1); p2 = to_FXString(argv[1]); arg2 = &p2; if (argc > 2) {
        SWIG_ConvertPtr(argv[2], (void **) &arg3, SWIGTYPE_p_FXIcon, 1); }  if (argc > 3) { arg4 = NUM2UINT(argv[3]); } 
    if (argc > 4) { arg5 = NUM2INT(argv[4]); }  if (argc > 5) { arg6 = NUM2INT(argv[5]); }  if (argc > 6) {
        arg7 = NUM2INT(argv[6]); }  if (argc > 7) { arg8 = NUM2INT(argv[7]); }  {
        result = (FXSearchDialog *)new_FXSearchDialog(arg1,(FXString const &)*arg2,arg3,arg4,arg5,arg6,arg7,arg8);
        DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result); if(rb_block_given_p()){ rb_yield(self); }  }  return self; }
static void
free_FXSearchDialog(FXSearchDialog *arg1) {
    delete arg1;
}
static VALUE _wrap_FXSearchDialog_save(int argc, VALUE *argv, VALUE self) { FXSearchDialog *arg1 = (FXSearchDialog *) 0 ;
    FXStream *arg2 = 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSearchDialog, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXSearchDialog_save((FXSearchDialog const *)arg1,*arg2); return Qnil; }
static VALUE _wrap_FXSearchDialog_load(int argc, VALUE *argv, VALUE self) { FXSearchDialog *arg1 = (FXSearchDialog *) 0 ;
    FXStream *arg2 = 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSearchDialog, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXSearchDialog_load(arg1,*arg2); return Qnil; }
static VALUE _wrap_FXSearchDialog_create(int argc, VALUE *argv, VALUE self) { FXSearchDialog *arg1 = (FXSearchDialog *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSearchDialog, 1); FXSearchDialog_create(arg1); return Qnil; }
static VALUE _wrap_FXSearchDialog_detach(int argc, VALUE *argv, VALUE self) { FXSearchDialog *arg1 = (FXSearchDialog *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSearchDialog, 1); FXSearchDialog_detach(arg1); return Qnil; }
static VALUE _wrap_FXSearchDialog_destroy(int argc, VALUE *argv, VALUE self) { FXSearchDialog *arg1 = (FXSearchDialog *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSearchDialog, 1); FXSearchDialog_destroy(arg1); return Qnil; }
static VALUE _wrap_FXSearchDialog_resize(int argc, VALUE *argv, VALUE self) { FXSearchDialog *arg1 = (FXSearchDialog *) 0 ;
    FXint arg2 ; FXint arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSearchDialog, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    FXSearchDialog_resize(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXSearchDialog_getDefaultWidth(int argc, VALUE *argv, VALUE self) {
    FXSearchDialog *arg1 = (FXSearchDialog *) 0 ; FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSearchDialog, 1); result = (FXint)FXSearchDialog_getDefaultWidth(arg1);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXSearchDialog_getDefaultHeight(int argc, VALUE *argv, VALUE self) {
    FXSearchDialog *arg1 = (FXSearchDialog *) 0 ; FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSearchDialog, 1); result = (FXint)FXSearchDialog_getDefaultHeight(arg1);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXSearchDialog_getWidthForHeight(int argc, VALUE *argv, VALUE self) {
    FXSearchDialog *arg1 = (FXSearchDialog *) 0 ; FXint arg2 ; FXint result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSearchDialog, 1); arg2 = NUM2INT(argv[0]);
    result = (FXint)FXSearchDialog_getWidthForHeight(arg1,arg2); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXSearchDialog_getHeightForWidth(int argc, VALUE *argv, VALUE self) {
    FXSearchDialog *arg1 = (FXSearchDialog *) 0 ; FXint arg2 ; FXint result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSearchDialog, 1); arg2 = NUM2INT(argv[0]);
    result = (FXint)FXSearchDialog_getHeightForWidth(arg1,arg2); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXSearchDialog_canFocus(int argc, VALUE *argv, VALUE self) { FXSearchDialog *arg1 = (FXSearchDialog *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSearchDialog, 1);
    result = (FXbool)FXSearchDialog_canFocus((FXSearchDialog const *)arg1); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXSearchDialog_setFocus(int argc, VALUE *argv, VALUE self) { FXSearchDialog *arg1 = (FXSearchDialog *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSearchDialog, 1); FXSearchDialog_setFocus(arg1); return Qnil; }
static VALUE _wrap_FXSearchDialog_killFocus(int argc, VALUE *argv, VALUE self) { FXSearchDialog *arg1 = (FXSearchDialog *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSearchDialog, 1); FXSearchDialog_killFocus(arg1); return Qnil; }
static VALUE _wrap_FXSearchDialog_setDefault(int argc, VALUE *argv, VALUE self) { FXSearchDialog *arg1 = (FXSearchDialog *) 0 ;
    FXbool arg2 = (FXbool) 1 ; if ((argc < 0) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSearchDialog, 1); if (argc > 0) { arg2 = to_FXbool(argv[0]); } 
    FXSearchDialog_setDefault(arg1,arg2); return Qnil; }
static VALUE _wrap_FXSearchDialog_enable(int argc, VALUE *argv, VALUE self) { FXSearchDialog *arg1 = (FXSearchDialog *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSearchDialog, 1); FXSearchDialog_enable(arg1); return Qnil; }
static VALUE _wrap_FXSearchDialog_disable(int argc, VALUE *argv, VALUE self) { FXSearchDialog *arg1 = (FXSearchDialog *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSearchDialog, 1); FXSearchDialog_disable(arg1); return Qnil; }
static VALUE _wrap_FXSearchDialog_raiseWindow(int argc, VALUE *argv, VALUE self) { FXSearchDialog *arg1 = (FXSearchDialog *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSearchDialog, 1); FXSearchDialog_raise(arg1); return Qnil; }
static VALUE _wrap_FXSearchDialog_lower(int argc, VALUE *argv, VALUE self) { FXSearchDialog *arg1 = (FXSearchDialog *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSearchDialog, 1); FXSearchDialog_lower(arg1); return Qnil; }
static VALUE _wrap_FXSearchDialog_move(int argc, VALUE *argv, VALUE self) { FXSearchDialog *arg1 = (FXSearchDialog *) 0 ;
    FXint arg2 ; FXint arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSearchDialog, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    FXSearchDialog_move(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXSearchDialog_position(int argc, VALUE *argv, VALUE self) { FXSearchDialog *arg1 = (FXSearchDialog *) 0 ;
    FXint arg2 ; FXint arg3 ; FXint arg4 ; FXint arg5 ; if ((argc < 4) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSearchDialog, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    arg4 = NUM2INT(argv[2]); arg5 = NUM2INT(argv[3]); FXSearchDialog_position(arg1,arg2,arg3,arg4,arg5); return Qnil; }
static VALUE _wrap_FXSearchDialog_layout(int argc, VALUE *argv, VALUE self) { FXSearchDialog *arg1 = (FXSearchDialog *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSearchDialog, 1); FXSearchDialog_layout(arg1); return Qnil; }
static VALUE _wrap_FXSearchDialog_recalc(int argc, VALUE *argv, VALUE self) { FXSearchDialog *arg1 = (FXSearchDialog *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSearchDialog, 1); FXSearchDialog_recalc(arg1); return Qnil; }
static VALUE _wrap_FXSearchDialog_reparent(int argc, VALUE *argv, VALUE self) { FXSearchDialog *arg1 = (FXSearchDialog *) 0 ;
    FXComposite *arg2 = (FXComposite *) 0 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSearchDialog, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXComposite, 1); FXSearchDialog_reparent(arg1,arg2); return Qnil; }
static VALUE _wrap_FXSearchDialog_show__SWIG_0(int argc, VALUE *argv, VALUE self) {
    FXSearchDialog *arg1 = (FXSearchDialog *) 0 ; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSearchDialog, 1); FXSearchDialog_show(arg1); return Qnil; }
static VALUE _wrap_FXSearchDialog_hide(int argc, VALUE *argv, VALUE self) { FXSearchDialog *arg1 = (FXSearchDialog *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSearchDialog, 1); FXSearchDialog_hide(arg1); return Qnil; }
static VALUE _wrap_FXSearchDialog_isComposite(int argc, VALUE *argv, VALUE self) { FXSearchDialog *arg1 = (FXSearchDialog *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSearchDialog, 1);
    result = (FXbool)FXSearchDialog_isComposite((FXSearchDialog const *)arg1); vresult = result ? Qtrue : Qfalse;
    return vresult; }
static VALUE _wrap_FXSearchDialog_contains(int argc, VALUE *argv, VALUE self) { FXSearchDialog *arg1 = (FXSearchDialog *) 0 ;
    FXint arg2 ; FXint arg3 ; FXbool result; VALUE vresult = Qnil; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSearchDialog, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    result = (FXbool)FXSearchDialog_contains((FXSearchDialog const *)arg1,arg2,arg3); vresult = result ? Qtrue : Qfalse;
    return vresult; }
static VALUE _wrap_FXSearchDialog_doesSaveUnder(int argc, VALUE *argv, VALUE self) {
    FXSearchDialog *arg1 = (FXSearchDialog *) 0 ; FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSearchDialog, 1);
    result = (FXbool)FXSearchDialog_doesSaveUnder((FXSearchDialog const *)arg1); vresult = result ? Qtrue : Qfalse;
    return vresult; }
static VALUE _wrap_FXSearchDialog_setBackColor(int argc, VALUE *argv, VALUE self) {
    FXSearchDialog *arg1 = (FXSearchDialog *) 0 ; FXColor arg2 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSearchDialog, 1); arg2 = to_FXColor(argv[0]);
    FXSearchDialog_setBackColor(arg1,arg2); return Qnil; }
static VALUE _wrap_FXSearchDialog_show__SWIG_1(int argc, VALUE *argv, VALUE self) {
    FXSearchDialog *arg1 = (FXSearchDialog *) 0 ; FXuint arg2 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSearchDialog, 1); arg2 = NUM2UINT(argv[0]);
    FXSearchDialog_show(arg1,arg2); return Qnil; }
static VALUE _wrap_FXSearchDialog_show(int nargs, VALUE *args, VALUE self) { int argc; VALUE argv[3]; int ii; argc = nargs + 1;
    argv[0] = self; for (ii = 1; (ii < argc) && (ii < 2); ii++) { argv[ii] = args[ii-1]; }  if (argc == 1) { int _v; {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXSearchDialog, 0) != -1)) ? 1 : 0; }
         if (_v) { return _wrap_FXSearchDialog_show__SWIG_0(nargs, args, self);}  }  if (argc == 2) { int _v; { void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXSearchDialog, 0) != -1)) ? 1 : 0; }
         if (_v) { { _v = ((TYPE(argv[1]) == T_FIXNUM) || (TYPE(argv[1]) == T_BIGNUM)) ? 1 : 0; }  if (_v) {
                return _wrap_FXSearchDialog_show__SWIG_1(nargs, args, self);}  }  } 
    rb_raise(rb_eArgError, "No matching function for overloaded 'FXSearchDialog_show'"); return Qnil; }
static VALUE _wrap_FXSearchDialog_maximize(int argc, VALUE *argv, VALUE self) { FXSearchDialog *arg1 = (FXSearchDialog *) 0 ;
    FXbool arg2 = (FXbool) 0 ; FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSearchDialog, 1); if (argc > 0) { arg2 = to_FXbool(argv[0]); } 
    result = (FXbool)FXSearchDialog_maximize(arg1,arg2); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXSearchDialog_minimize(int argc, VALUE *argv, VALUE self) { FXSearchDialog *arg1 = (FXSearchDialog *) 0 ;
    FXbool arg2 = (FXbool) 0 ; FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSearchDialog, 1); if (argc > 0) { arg2 = to_FXbool(argv[0]); } 
    result = (FXbool)FXSearchDialog_minimize(arg1,arg2); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXSearchDialog_restore(int argc, VALUE *argv, VALUE self) { FXSearchDialog *arg1 = (FXSearchDialog *) 0 ;
    FXbool arg2 = (FXbool) 0 ; FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSearchDialog, 1); if (argc > 0) { arg2 = to_FXbool(argv[0]); } 
    result = (FXbool)FXSearchDialog_restore(arg1,arg2); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXSearchDialog_close(int argc, VALUE *argv, VALUE self) { FXSearchDialog *arg1 = (FXSearchDialog *) 0 ;
    FXbool arg2 = (FXbool) 0 ; FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSearchDialog, 1); if (argc > 0) { arg2 = to_FXbool(argv[0]); } 
    result = (FXbool)FXSearchDialog_close(arg1,arg2); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXSearchDialog_execute(int argc, VALUE *argv, VALUE self) { FXSearchDialog *arg1 = (FXSearchDialog *) 0 ;
    FXuint arg2 = (FXuint) PLACEMENT_CURSOR ; FXuint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSearchDialog, 1); if (argc > 0) { arg2 = NUM2UINT(argv[0]); } 
    result = (FXuint)FXSearchDialog_execute(arg1,arg2); vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXInputDialog_onCmdAccept(int argc, VALUE *argv, VALUE self) { FXInputDialog *arg1 = (FXInputDialog *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXInputDialog, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdAccept(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE _wrap_FXInputDialog_allocate(VALUE self) {
#else
     static VALUE _wrap_FXInputDialog_allocate(int argc, VALUE *argv, VALUE self) {
#endif
         VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_FXInputDialog);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
         return vresult; }
static VALUE _wrap_new_FXInputDialog(int argc, VALUE *argv, VALUE self) { FXWindow *arg1 = (FXWindow *) 0 ; FXString *arg2 = 0 ;
    FXString *arg3 = 0 ; FXIcon *arg4 = (FXIcon *) 0 ; FXuint arg5 = (FXuint) INPUTDIALOG_STRING ; FXint arg6 = (FXint) 0 ;
    FXint arg7 = (FXint) 0 ; FXint arg8 = (FXint) 0 ; FXint arg9 = (FXint) 0 ; FXInputDialog *result;
    SwigValueWrapper<FXString > p2 ; SwigValueWrapper<FXString > p3 ; if ((argc < 3) || (argc > 9))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXWindow, 1); p2 = to_FXString(argv[1]); arg2 = &p2;
    p3 = to_FXString(argv[2]); arg3 = &p3; if (argc > 3) { SWIG_ConvertPtr(argv[3], (void **) &arg4, SWIGTYPE_p_FXIcon, 1); } 
    if (argc > 4) { arg5 = NUM2UINT(argv[4]); }  if (argc > 5) { arg6 = NUM2INT(argv[5]); }  if (argc > 6) {
        arg7 = NUM2INT(argv[6]); }  if (argc > 7) { arg8 = NUM2INT(argv[7]); }  if (argc > 8) { arg9 = NUM2INT(argv[8]); }  {
        result = (FXInputDialog *)new_FXInputDialog(arg1,(FXString const &)*arg2,(FXString const &)*arg3,arg4,arg5,arg6,arg7,arg8,arg9);
        DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result); if(rb_block_given_p()){ rb_yield(self); }  }  return self; }
static VALUE _wrap_FXInputDialog_getText(int argc, VALUE *argv, VALUE self) { FXInputDialog *arg1 = (FXInputDialog *) 0 ;
    FXString result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXInputDialog, 1); result = ((FXInputDialog const *)arg1)->getText();
    vresult = rb_str_new2((&result)->text()); return vresult; }
static VALUE _wrap_FXInputDialog_setText(int argc, VALUE *argv, VALUE self) { FXInputDialog *arg1 = (FXInputDialog *) 0 ;
    FXString *arg2 = 0 ; SwigValueWrapper<FXString > p2 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXInputDialog, 1); p2 = to_FXString(argv[0]); arg2 = &p2;
    (arg1)->setText((FXString const &)*arg2); return Qnil; }
static VALUE _wrap_FXInputDialog_setNumColumns(int argc, VALUE *argv, VALUE self) { FXInputDialog *arg1 = (FXInputDialog *) 0 ;
    FXint arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXInputDialog, 1); arg2 = NUM2INT(argv[0]); (arg1)->setNumColumns(arg2);
    return Qnil; }
static VALUE _wrap_FXInputDialog_getNumColumns(int argc, VALUE *argv, VALUE self) { FXInputDialog *arg1 = (FXInputDialog *) 0 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXInputDialog, 1);
    result = (FXint)((FXInputDialog const *)arg1)->getNumColumns(); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXInputDialog_setLimits(int argc, VALUE *argv, VALUE self) { FXInputDialog *arg1 = (FXInputDialog *) 0 ;
    FXdouble arg2 ; FXdouble arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXInputDialog, 1); arg2 = (FXdouble) NUM2DBL(argv[0]);
    arg3 = (FXdouble) NUM2DBL(argv[1]); (arg1)->setLimits(arg2,arg3); return Qnil; }
static VALUE _wrap_FXInputDialog_getLimits(int argc, VALUE *argv, VALUE self) { FXInputDialog *arg1 = (FXInputDialog *) 0 ;
    VALUE result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXInputDialog, 1); result = (VALUE)FXInputDialog_getLimits(arg1);
    vresult = result; return vresult; }
static VALUE _wrap_FXInputDialog_getString(int argc, VALUE *argv, VALUE self) { FXString *arg1 = 0 ;
    FXWindow *arg2 = (FXWindow *) 0 ; FXString *arg3 = 0 ; FXString *arg4 = 0 ; FXIcon *arg5 = (FXIcon *) 0 ; VALUE result;
    SwigValueWrapper<FXString > p1 ; SwigValueWrapper<FXString > p3 ; SwigValueWrapper<FXString > p4 ; VALUE vresult = Qnil;
    if ((argc < 4) || (argc > 5)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    p1 = to_FXString(argv[0]); arg1 = &p1; SWIG_ConvertPtr(argv[1], (void **) &arg2, SWIGTYPE_p_FXWindow, 1);
    p3 = to_FXString(argv[2]); arg3 = &p3; p4 = to_FXString(argv[3]); arg4 = &p4; if (argc > 4) {
        SWIG_ConvertPtr(argv[4], (void **) &arg5, SWIGTYPE_p_FXIcon, 1); } 
    result = (VALUE)FXInputDialog_getString((FXString const &)*arg1,arg2,(FXString const &)*arg3,(FXString const &)*arg4,arg5);
    vresult = result; return vresult; }
static VALUE _wrap_FXInputDialog_getInteger(int argc, VALUE *argv, VALUE self) { FXint arg1 ; FXWindow *arg2 = (FXWindow *) 0 ;
    FXString *arg3 = 0 ; FXString *arg4 = 0 ; FXIcon *arg5 = (FXIcon *) 0 ; FXint arg6 = (FXint) 1 ; FXint arg7 = (FXint) 0 ;
    VALUE result; SwigValueWrapper<FXString > p3 ; SwigValueWrapper<FXString > p4 ; VALUE vresult = Qnil;
    if ((argc < 4) || (argc > 7)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc); arg1 = NUM2INT(argv[0]);
    SWIG_ConvertPtr(argv[1], (void **) &arg2, SWIGTYPE_p_FXWindow, 1); p3 = to_FXString(argv[2]); arg3 = &p3;
    p4 = to_FXString(argv[3]); arg4 = &p4; if (argc > 4) { SWIG_ConvertPtr(argv[4], (void **) &arg5, SWIGTYPE_p_FXIcon, 1); } 
    if (argc > 5) { arg6 = NUM2INT(argv[5]); }  if (argc > 6) { arg7 = NUM2INT(argv[6]); } 
    result = (VALUE)FXInputDialog_getInteger(arg1,arg2,(FXString const &)*arg3,(FXString const &)*arg4,arg5,arg6,arg7);
    vresult = result; return vresult; }
static VALUE _wrap_FXInputDialog_getReal(int argc, VALUE *argv, VALUE self) { FXdouble arg1 ; FXWindow *arg2 = (FXWindow *) 0 ;
    FXString *arg3 = 0 ; FXString *arg4 = 0 ; FXIcon *arg5 = (FXIcon *) 0 ; FXdouble arg6 = (FXdouble) 1.0 ;
    FXdouble arg7 = (FXdouble) 0.0 ; VALUE result; SwigValueWrapper<FXString > p3 ; SwigValueWrapper<FXString > p4 ;
    VALUE vresult = Qnil; if ((argc < 4) || (argc > 7)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    arg1 = (FXdouble) NUM2DBL(argv[0]); SWIG_ConvertPtr(argv[1], (void **) &arg2, SWIGTYPE_p_FXWindow, 1);
    p3 = to_FXString(argv[2]); arg3 = &p3; p4 = to_FXString(argv[3]); arg4 = &p4; if (argc > 4) {
        SWIG_ConvertPtr(argv[4], (void **) &arg5, SWIGTYPE_p_FXIcon, 1); }  if (argc > 5) { arg6 = (FXdouble) NUM2DBL(argv[5]); }
     if (argc > 6) { arg7 = (FXdouble) NUM2DBL(argv[6]); } 
    result = (VALUE)FXInputDialog_getReal(arg1,arg2,(FXString const &)*arg3,(FXString const &)*arg4,arg5,arg6,arg7);
    vresult = result; return vresult; }
static VALUE _wrap_FXInputDialog_save(int argc, VALUE *argv, VALUE self) { FXInputDialog *arg1 = (FXInputDialog *) 0 ;
    FXStream *arg2 = 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXInputDialog, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXInputDialog_save((FXInputDialog const *)arg1,*arg2); return Qnil; }
static VALUE _wrap_FXInputDialog_load(int argc, VALUE *argv, VALUE self) { FXInputDialog *arg1 = (FXInputDialog *) 0 ;
    FXStream *arg2 = 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXInputDialog, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXInputDialog_load(arg1,*arg2); return Qnil; }
static VALUE _wrap_FXInputDialog_create(int argc, VALUE *argv, VALUE self) { FXInputDialog *arg1 = (FXInputDialog *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXInputDialog, 1); FXInputDialog_create(arg1); return Qnil; }
static VALUE _wrap_FXInputDialog_detach(int argc, VALUE *argv, VALUE self) { FXInputDialog *arg1 = (FXInputDialog *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXInputDialog, 1); FXInputDialog_detach(arg1); return Qnil; }
static VALUE _wrap_FXInputDialog_destroy(int argc, VALUE *argv, VALUE self) { FXInputDialog *arg1 = (FXInputDialog *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXInputDialog, 1); FXInputDialog_destroy(arg1); return Qnil; }
static VALUE _wrap_FXInputDialog_resize(int argc, VALUE *argv, VALUE self) { FXInputDialog *arg1 = (FXInputDialog *) 0 ;
    FXint arg2 ; FXint arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXInputDialog, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    FXInputDialog_resize(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXInputDialog_getDefaultWidth(int argc, VALUE *argv, VALUE self) {
    FXInputDialog *arg1 = (FXInputDialog *) 0 ; FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXInputDialog, 1); result = (FXint)FXInputDialog_getDefaultWidth(arg1);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXInputDialog_getDefaultHeight(int argc, VALUE *argv, VALUE self) {
    FXInputDialog *arg1 = (FXInputDialog *) 0 ; FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXInputDialog, 1); result = (FXint)FXInputDialog_getDefaultHeight(arg1);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXInputDialog_getWidthForHeight(int argc, VALUE *argv, VALUE self) {
    FXInputDialog *arg1 = (FXInputDialog *) 0 ; FXint arg2 ; FXint result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXInputDialog, 1); arg2 = NUM2INT(argv[0]);
    result = (FXint)FXInputDialog_getWidthForHeight(arg1,arg2); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXInputDialog_getHeightForWidth(int argc, VALUE *argv, VALUE self) {
    FXInputDialog *arg1 = (FXInputDialog *) 0 ; FXint arg2 ; FXint result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXInputDialog, 1); arg2 = NUM2INT(argv[0]);
    result = (FXint)FXInputDialog_getHeightForWidth(arg1,arg2); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXInputDialog_canFocus(int argc, VALUE *argv, VALUE self) { FXInputDialog *arg1 = (FXInputDialog *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXInputDialog, 1);
    result = (FXbool)FXInputDialog_canFocus((FXInputDialog const *)arg1); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXInputDialog_setFocus(int argc, VALUE *argv, VALUE self) { FXInputDialog *arg1 = (FXInputDialog *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXInputDialog, 1); FXInputDialog_setFocus(arg1); return Qnil; }
static VALUE _wrap_FXInputDialog_killFocus(int argc, VALUE *argv, VALUE self) { FXInputDialog *arg1 = (FXInputDialog *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXInputDialog, 1); FXInputDialog_killFocus(arg1); return Qnil; }
static VALUE _wrap_FXInputDialog_setDefault(int argc, VALUE *argv, VALUE self) { FXInputDialog *arg1 = (FXInputDialog *) 0 ;
    FXbool arg2 = (FXbool) 1 ; if ((argc < 0) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXInputDialog, 1); if (argc > 0) { arg2 = to_FXbool(argv[0]); } 
    FXInputDialog_setDefault(arg1,arg2); return Qnil; }
static VALUE _wrap_FXInputDialog_enable(int argc, VALUE *argv, VALUE self) { FXInputDialog *arg1 = (FXInputDialog *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXInputDialog, 1); FXInputDialog_enable(arg1); return Qnil; }
static VALUE _wrap_FXInputDialog_disable(int argc, VALUE *argv, VALUE self) { FXInputDialog *arg1 = (FXInputDialog *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXInputDialog, 1); FXInputDialog_disable(arg1); return Qnil; }
static VALUE _wrap_FXInputDialog_raiseWindow(int argc, VALUE *argv, VALUE self) { FXInputDialog *arg1 = (FXInputDialog *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXInputDialog, 1); FXInputDialog_raise(arg1); return Qnil; }
static VALUE _wrap_FXInputDialog_lower(int argc, VALUE *argv, VALUE self) { FXInputDialog *arg1 = (FXInputDialog *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXInputDialog, 1); FXInputDialog_lower(arg1); return Qnil; }
static VALUE _wrap_FXInputDialog_move(int argc, VALUE *argv, VALUE self) { FXInputDialog *arg1 = (FXInputDialog *) 0 ;
    FXint arg2 ; FXint arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXInputDialog, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    FXInputDialog_move(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXInputDialog_position(int argc, VALUE *argv, VALUE self) { FXInputDialog *arg1 = (FXInputDialog *) 0 ;
    FXint arg2 ; FXint arg3 ; FXint arg4 ; FXint arg5 ; if ((argc < 4) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXInputDialog, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    arg4 = NUM2INT(argv[2]); arg5 = NUM2INT(argv[3]); FXInputDialog_position(arg1,arg2,arg3,arg4,arg5); return Qnil; }
static VALUE _wrap_FXInputDialog_layout(int argc, VALUE *argv, VALUE self) { FXInputDialog *arg1 = (FXInputDialog *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXInputDialog, 1); FXInputDialog_layout(arg1); return Qnil; }
static VALUE _wrap_FXInputDialog_recalc(int argc, VALUE *argv, VALUE self) { FXInputDialog *arg1 = (FXInputDialog *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXInputDialog, 1); FXInputDialog_recalc(arg1); return Qnil; }
static VALUE _wrap_FXInputDialog_reparent(int argc, VALUE *argv, VALUE self) { FXInputDialog *arg1 = (FXInputDialog *) 0 ;
    FXComposite *arg2 = (FXComposite *) 0 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXInputDialog, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXComposite, 1); FXInputDialog_reparent(arg1,arg2); return Qnil; }
static VALUE _wrap_FXInputDialog_show__SWIG_0(int argc, VALUE *argv, VALUE self) { FXInputDialog *arg1 = (FXInputDialog *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXInputDialog, 1); FXInputDialog_show(arg1); return Qnil; }
static VALUE _wrap_FXInputDialog_hide(int argc, VALUE *argv, VALUE self) { FXInputDialog *arg1 = (FXInputDialog *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXInputDialog, 1); FXInputDialog_hide(arg1); return Qnil; }
static VALUE _wrap_FXInputDialog_isComposite(int argc, VALUE *argv, VALUE self) { FXInputDialog *arg1 = (FXInputDialog *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXInputDialog, 1);
    result = (FXbool)FXInputDialog_isComposite((FXInputDialog const *)arg1); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXInputDialog_contains(int argc, VALUE *argv, VALUE self) { FXInputDialog *arg1 = (FXInputDialog *) 0 ;
    FXint arg2 ; FXint arg3 ; FXbool result; VALUE vresult = Qnil; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXInputDialog, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    result = (FXbool)FXInputDialog_contains((FXInputDialog const *)arg1,arg2,arg3); vresult = result ? Qtrue : Qfalse;
    return vresult; }
static VALUE _wrap_FXInputDialog_doesSaveUnder(int argc, VALUE *argv, VALUE self) { FXInputDialog *arg1 = (FXInputDialog *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXInputDialog, 1);
    result = (FXbool)FXInputDialog_doesSaveUnder((FXInputDialog const *)arg1); vresult = result ? Qtrue : Qfalse;
    return vresult; }
static VALUE _wrap_FXInputDialog_setBackColor(int argc, VALUE *argv, VALUE self) { FXInputDialog *arg1 = (FXInputDialog *) 0 ;
    FXColor arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXInputDialog, 1); arg2 = to_FXColor(argv[0]);
    FXInputDialog_setBackColor(arg1,arg2); return Qnil; }
static VALUE _wrap_FXInputDialog_show__SWIG_1(int argc, VALUE *argv, VALUE self) { FXInputDialog *arg1 = (FXInputDialog *) 0 ;
    FXuint arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXInputDialog, 1); arg2 = NUM2UINT(argv[0]);
    FXInputDialog_show(arg1,arg2); return Qnil; }
static VALUE _wrap_FXInputDialog_show(int nargs, VALUE *args, VALUE self) { int argc; VALUE argv[3]; int ii; argc = nargs + 1;
    argv[0] = self; for (ii = 1; (ii < argc) && (ii < 2); ii++) { argv[ii] = args[ii-1]; }  if (argc == 1) { int _v; {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXInputDialog, 0) != -1)) ? 1 : 0; }
         if (_v) { return _wrap_FXInputDialog_show__SWIG_0(nargs, args, self);}  }  if (argc == 2) { int _v; { void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXInputDialog, 0) != -1)) ? 1 : 0; }
         if (_v) { { _v = ((TYPE(argv[1]) == T_FIXNUM) || (TYPE(argv[1]) == T_BIGNUM)) ? 1 : 0; }  if (_v) {
                return _wrap_FXInputDialog_show__SWIG_1(nargs, args, self);}  }  } 
    rb_raise(rb_eArgError, "No matching function for overloaded 'FXInputDialog_show'"); return Qnil; }
static VALUE _wrap_FXInputDialog_maximize(int argc, VALUE *argv, VALUE self) { FXInputDialog *arg1 = (FXInputDialog *) 0 ;
    FXbool arg2 = (FXbool) 0 ; FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXInputDialog, 1); if (argc > 0) { arg2 = to_FXbool(argv[0]); } 
    result = (FXbool)FXInputDialog_maximize(arg1,arg2); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXInputDialog_minimize(int argc, VALUE *argv, VALUE self) { FXInputDialog *arg1 = (FXInputDialog *) 0 ;
    FXbool arg2 = (FXbool) 0 ; FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXInputDialog, 1); if (argc > 0) { arg2 = to_FXbool(argv[0]); } 
    result = (FXbool)FXInputDialog_minimize(arg1,arg2); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXInputDialog_restore(int argc, VALUE *argv, VALUE self) { FXInputDialog *arg1 = (FXInputDialog *) 0 ;
    FXbool arg2 = (FXbool) 0 ; FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXInputDialog, 1); if (argc > 0) { arg2 = to_FXbool(argv[0]); } 
    result = (FXbool)FXInputDialog_restore(arg1,arg2); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXInputDialog_close(int argc, VALUE *argv, VALUE self) { FXInputDialog *arg1 = (FXInputDialog *) 0 ;
    FXbool arg2 = (FXbool) 0 ; FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXInputDialog, 1); if (argc > 0) { arg2 = to_FXbool(argv[0]); } 
    result = (FXbool)FXInputDialog_close(arg1,arg2); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXInputDialog_execute(int argc, VALUE *argv, VALUE self) { FXInputDialog *arg1 = (FXInputDialog *) 0 ;
    FXuint arg2 = (FXuint) PLACEMENT_CURSOR ; FXuint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXInputDialog, 1); if (argc > 0) { arg2 = NUM2UINT(argv[0]); } 
    result = (FXuint)FXInputDialog_execute(arg1,arg2); vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXPrintDialog_onCmdToPrinter(int argc, VALUE *argv, VALUE self) { FXPrintDialog *arg1 = (FXPrintDialog *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPrintDialog, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdToPrinter(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXPrintDialog_onUpdToPrinter(int argc, VALUE *argv, VALUE self) { FXPrintDialog *arg1 = (FXPrintDialog *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPrintDialog, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onUpdToPrinter(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXPrintDialog_onCmdToFile(int argc, VALUE *argv, VALUE self) { FXPrintDialog *arg1 = (FXPrintDialog *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPrintDialog, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdToFile(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXPrintDialog_onUpdToFile(int argc, VALUE *argv, VALUE self) { FXPrintDialog *arg1 = (FXPrintDialog *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPrintDialog, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onUpdToFile(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXPrintDialog_onCmdBrowse(int argc, VALUE *argv, VALUE self) { FXPrintDialog *arg1 = (FXPrintDialog *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPrintDialog, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdBrowse(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXPrintDialog_onUpdBrowse(int argc, VALUE *argv, VALUE self) { FXPrintDialog *arg1 = (FXPrintDialog *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPrintDialog, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onUpdBrowse(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXPrintDialog_onCmdProps(int argc, VALUE *argv, VALUE self) { FXPrintDialog *arg1 = (FXPrintDialog *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPrintDialog, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdProps(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXPrintDialog_onUpdProps(int argc, VALUE *argv, VALUE self) { FXPrintDialog *arg1 = (FXPrintDialog *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPrintDialog, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onUpdProps(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXPrintDialog_onCmdPortrait(int argc, VALUE *argv, VALUE self) { FXPrintDialog *arg1 = (FXPrintDialog *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPrintDialog, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdPortrait(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXPrintDialog_onUpdPortrait(int argc, VALUE *argv, VALUE self) { FXPrintDialog *arg1 = (FXPrintDialog *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPrintDialog, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onUpdPortrait(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXPrintDialog_onCmdLandscape(int argc, VALUE *argv, VALUE self) { FXPrintDialog *arg1 = (FXPrintDialog *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPrintDialog, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdLandscape(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXPrintDialog_onUpdLandscape(int argc, VALUE *argv, VALUE self) { FXPrintDialog *arg1 = (FXPrintDialog *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPrintDialog, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onUpdLandscape(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXPrintDialog_onCmdPages(int argc, VALUE *argv, VALUE self) { FXPrintDialog *arg1 = (FXPrintDialog *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPrintDialog, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdPages(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXPrintDialog_onUpdPages(int argc, VALUE *argv, VALUE self) { FXPrintDialog *arg1 = (FXPrintDialog *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPrintDialog, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onUpdPages(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXPrintDialog_onCmdColor(int argc, VALUE *argv, VALUE self) { FXPrintDialog *arg1 = (FXPrintDialog *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPrintDialog, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdColor(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXPrintDialog_onUpdColor(int argc, VALUE *argv, VALUE self) { FXPrintDialog *arg1 = (FXPrintDialog *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPrintDialog, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onUpdColor(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXPrintDialog_onCmdGray(int argc, VALUE *argv, VALUE self) { FXPrintDialog *arg1 = (FXPrintDialog *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPrintDialog, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdGray(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXPrintDialog_onUpdGray(int argc, VALUE *argv, VALUE self) { FXPrintDialog *arg1 = (FXPrintDialog *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPrintDialog, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onUpdGray(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXPrintDialog_onCmdNumCopies(int argc, VALUE *argv, VALUE self) { FXPrintDialog *arg1 = (FXPrintDialog *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPrintDialog, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdNumCopies(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXPrintDialog_onUpdNumCopies(int argc, VALUE *argv, VALUE self) { FXPrintDialog *arg1 = (FXPrintDialog *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPrintDialog, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onUpdNumCopies(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXPrintDialog_onCmdFirstPage(int argc, VALUE *argv, VALUE self) { FXPrintDialog *arg1 = (FXPrintDialog *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPrintDialog, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdFirstPage(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXPrintDialog_onUpdFirstPage(int argc, VALUE *argv, VALUE self) { FXPrintDialog *arg1 = (FXPrintDialog *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPrintDialog, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onUpdFirstPage(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXPrintDialog_onCmdLastPage(int argc, VALUE *argv, VALUE self) { FXPrintDialog *arg1 = (FXPrintDialog *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPrintDialog, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdLastPage(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXPrintDialog_onUpdLastPage(int argc, VALUE *argv, VALUE self) { FXPrintDialog *arg1 = (FXPrintDialog *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPrintDialog, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onUpdLastPage(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXPrintDialog_onCmdCollateNormal(int argc, VALUE *argv, VALUE self) {
    FXPrintDialog *arg1 = (FXPrintDialog *) 0 ; FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ;
    long result; VALUE vresult = Qnil; if ((argc < 3) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPrintDialog, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdCollateNormal(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXPrintDialog_onUpdCollateNormal(int argc, VALUE *argv, VALUE self) {
    FXPrintDialog *arg1 = (FXPrintDialog *) 0 ; FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ;
    long result; VALUE vresult = Qnil; if ((argc < 3) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPrintDialog, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onUpdCollateNormal(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXPrintDialog_onCmdCollateReversed(int argc, VALUE *argv, VALUE self) {
    FXPrintDialog *arg1 = (FXPrintDialog *) 0 ; FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ;
    long result; VALUE vresult = Qnil; if ((argc < 3) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPrintDialog, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdCollateReversed(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXPrintDialog_onUpdCollateReversed(int argc, VALUE *argv, VALUE self) {
    FXPrintDialog *arg1 = (FXPrintDialog *) 0 ; FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ;
    long result; VALUE vresult = Qnil; if ((argc < 3) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPrintDialog, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onUpdCollateReversed(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXPrintDialog_onCmdFileName(int argc, VALUE *argv, VALUE self) { FXPrintDialog *arg1 = (FXPrintDialog *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPrintDialog, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdFileName(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXPrintDialog_onUpdFileName(int argc, VALUE *argv, VALUE self) { FXPrintDialog *arg1 = (FXPrintDialog *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPrintDialog, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onUpdFileName(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXPrintDialog_onCmdPrinterName(int argc, VALUE *argv, VALUE self) {
    FXPrintDialog *arg1 = (FXPrintDialog *) 0 ; FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ;
    long result; VALUE vresult = Qnil; if ((argc < 3) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPrintDialog, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdPrinterName(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXPrintDialog_onUpdPrinterName(int argc, VALUE *argv, VALUE self) {
    FXPrintDialog *arg1 = (FXPrintDialog *) 0 ; FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ;
    long result; VALUE vresult = Qnil; if ((argc < 3) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPrintDialog, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onUpdPrinterName(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXPrintDialog_onCmdAccept(int argc, VALUE *argv, VALUE self) { FXPrintDialog *arg1 = (FXPrintDialog *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPrintDialog, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdAccept(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXPrintDialog_onCmdMedia(int argc, VALUE *argv, VALUE self) { FXPrintDialog *arg1 = (FXPrintDialog *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPrintDialog, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdMedia(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXPrintDialog_onUpdMedia(int argc, VALUE *argv, VALUE self) { FXPrintDialog *arg1 = (FXPrintDialog *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPrintDialog, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onUpdMedia(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE _wrap_FXPrintDialog_allocate(VALUE self) {
#else
     static VALUE _wrap_FXPrintDialog_allocate(int argc, VALUE *argv, VALUE self) {
#endif
         VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_FXPrintDialog);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
         return vresult; }
static VALUE _wrap_new_FXPrintDialog(int argc, VALUE *argv, VALUE self) { FXWindow *arg1 = (FXWindow *) 0 ; FXString *arg2 = 0 ;
    FXuint arg3 = (FXuint) 0 ; FXint arg4 = (FXint) 0 ; FXint arg5 = (FXint) 0 ; FXint arg6 = (FXint) 0 ;
    FXint arg7 = (FXint) 0 ; FXPrintDialog *result; SwigValueWrapper<FXString > p2 ; if ((argc < 2) || (argc > 7))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXWindow, 1); p2 = to_FXString(argv[1]); arg2 = &p2; if (argc > 2) {
        arg3 = NUM2UINT(argv[2]); }  if (argc > 3) { arg4 = NUM2INT(argv[3]); }  if (argc > 4) { arg5 = NUM2INT(argv[4]); } 
    if (argc > 5) { arg6 = NUM2INT(argv[5]); }  if (argc > 6) { arg7 = NUM2INT(argv[6]); }  {
        result = (FXPrintDialog *)new_FXPrintDialog(arg1,(FXString const &)*arg2,arg3,arg4,arg5,arg6,arg7);
        DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result); if(rb_block_given_p()){ rb_yield(self); }  }  return self; }
static VALUE _wrap_FXPrintDialog_setPrinter(int argc, VALUE *argv, VALUE self) { FXPrintDialog *arg1 = (FXPrintDialog *) 0 ;
    FXPrinter *arg2 = 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPrintDialog, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXPrinter, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    (arg1)->setPrinter((FXPrinter const &)*arg2); return Qnil; }
static VALUE _wrap_FXPrintDialog_getPrinter(int argc, VALUE *argv, VALUE self) { FXPrintDialog *arg1 = (FXPrintDialog *) 0 ;
    FXPrinter result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPrintDialog, 1); result = FXPrintDialog_getPrinter(arg1); {
        FXPrinter *resultptr = new FXPrinter(result); vresult = FXRbGetRubyObj(resultptr, "FXPrinter *"); }  return vresult; }
static void
free_FXPrintDialog(FXPrintDialog *arg1) {
    delete arg1;
}
static VALUE _wrap_FXPrintDialog_save(int argc, VALUE *argv, VALUE self) { FXPrintDialog *arg1 = (FXPrintDialog *) 0 ;
    FXStream *arg2 = 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPrintDialog, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXPrintDialog_save((FXPrintDialog const *)arg1,*arg2); return Qnil; }
static VALUE _wrap_FXPrintDialog_load(int argc, VALUE *argv, VALUE self) { FXPrintDialog *arg1 = (FXPrintDialog *) 0 ;
    FXStream *arg2 = 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPrintDialog, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXPrintDialog_load(arg1,*arg2); return Qnil; }
static VALUE _wrap_FXPrintDialog_create(int argc, VALUE *argv, VALUE self) { FXPrintDialog *arg1 = (FXPrintDialog *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPrintDialog, 1); FXPrintDialog_create(arg1); return Qnil; }
static VALUE _wrap_FXPrintDialog_detach(int argc, VALUE *argv, VALUE self) { FXPrintDialog *arg1 = (FXPrintDialog *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPrintDialog, 1); FXPrintDialog_detach(arg1); return Qnil; }
static VALUE _wrap_FXPrintDialog_destroy(int argc, VALUE *argv, VALUE self) { FXPrintDialog *arg1 = (FXPrintDialog *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPrintDialog, 1); FXPrintDialog_destroy(arg1); return Qnil; }
static VALUE _wrap_FXPrintDialog_resize(int argc, VALUE *argv, VALUE self) { FXPrintDialog *arg1 = (FXPrintDialog *) 0 ;
    FXint arg2 ; FXint arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPrintDialog, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    FXPrintDialog_resize(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXPrintDialog_getDefaultWidth(int argc, VALUE *argv, VALUE self) {
    FXPrintDialog *arg1 = (FXPrintDialog *) 0 ; FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPrintDialog, 1); result = (FXint)FXPrintDialog_getDefaultWidth(arg1);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXPrintDialog_getDefaultHeight(int argc, VALUE *argv, VALUE self) {
    FXPrintDialog *arg1 = (FXPrintDialog *) 0 ; FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPrintDialog, 1); result = (FXint)FXPrintDialog_getDefaultHeight(arg1);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXPrintDialog_getWidthForHeight(int argc, VALUE *argv, VALUE self) {
    FXPrintDialog *arg1 = (FXPrintDialog *) 0 ; FXint arg2 ; FXint result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPrintDialog, 1); arg2 = NUM2INT(argv[0]);
    result = (FXint)FXPrintDialog_getWidthForHeight(arg1,arg2); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXPrintDialog_getHeightForWidth(int argc, VALUE *argv, VALUE self) {
    FXPrintDialog *arg1 = (FXPrintDialog *) 0 ; FXint arg2 ; FXint result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPrintDialog, 1); arg2 = NUM2INT(argv[0]);
    result = (FXint)FXPrintDialog_getHeightForWidth(arg1,arg2); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXPrintDialog_canFocus(int argc, VALUE *argv, VALUE self) { FXPrintDialog *arg1 = (FXPrintDialog *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPrintDialog, 1);
    result = (FXbool)FXPrintDialog_canFocus((FXPrintDialog const *)arg1); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXPrintDialog_setFocus(int argc, VALUE *argv, VALUE self) { FXPrintDialog *arg1 = (FXPrintDialog *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPrintDialog, 1); FXPrintDialog_setFocus(arg1); return Qnil; }
static VALUE _wrap_FXPrintDialog_killFocus(int argc, VALUE *argv, VALUE self) { FXPrintDialog *arg1 = (FXPrintDialog *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPrintDialog, 1); FXPrintDialog_killFocus(arg1); return Qnil; }
static VALUE _wrap_FXPrintDialog_setDefault(int argc, VALUE *argv, VALUE self) { FXPrintDialog *arg1 = (FXPrintDialog *) 0 ;
    FXbool arg2 = (FXbool) 1 ; if ((argc < 0) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPrintDialog, 1); if (argc > 0) { arg2 = to_FXbool(argv[0]); } 
    FXPrintDialog_setDefault(arg1,arg2); return Qnil; }
static VALUE _wrap_FXPrintDialog_enable(int argc, VALUE *argv, VALUE self) { FXPrintDialog *arg1 = (FXPrintDialog *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPrintDialog, 1); FXPrintDialog_enable(arg1); return Qnil; }
static VALUE _wrap_FXPrintDialog_disable(int argc, VALUE *argv, VALUE self) { FXPrintDialog *arg1 = (FXPrintDialog *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPrintDialog, 1); FXPrintDialog_disable(arg1); return Qnil; }
static VALUE _wrap_FXPrintDialog_raiseWindow(int argc, VALUE *argv, VALUE self) { FXPrintDialog *arg1 = (FXPrintDialog *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPrintDialog, 1); FXPrintDialog_raise(arg1); return Qnil; }
static VALUE _wrap_FXPrintDialog_lower(int argc, VALUE *argv, VALUE self) { FXPrintDialog *arg1 = (FXPrintDialog *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPrintDialog, 1); FXPrintDialog_lower(arg1); return Qnil; }
static VALUE _wrap_FXPrintDialog_move(int argc, VALUE *argv, VALUE self) { FXPrintDialog *arg1 = (FXPrintDialog *) 0 ;
    FXint arg2 ; FXint arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPrintDialog, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    FXPrintDialog_move(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXPrintDialog_position(int argc, VALUE *argv, VALUE self) { FXPrintDialog *arg1 = (FXPrintDialog *) 0 ;
    FXint arg2 ; FXint arg3 ; FXint arg4 ; FXint arg5 ; if ((argc < 4) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPrintDialog, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    arg4 = NUM2INT(argv[2]); arg5 = NUM2INT(argv[3]); FXPrintDialog_position(arg1,arg2,arg3,arg4,arg5); return Qnil; }
static VALUE _wrap_FXPrintDialog_layout(int argc, VALUE *argv, VALUE self) { FXPrintDialog *arg1 = (FXPrintDialog *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPrintDialog, 1); FXPrintDialog_layout(arg1); return Qnil; }
static VALUE _wrap_FXPrintDialog_recalc(int argc, VALUE *argv, VALUE self) { FXPrintDialog *arg1 = (FXPrintDialog *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPrintDialog, 1); FXPrintDialog_recalc(arg1); return Qnil; }
static VALUE _wrap_FXPrintDialog_reparent(int argc, VALUE *argv, VALUE self) { FXPrintDialog *arg1 = (FXPrintDialog *) 0 ;
    FXComposite *arg2 = (FXComposite *) 0 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPrintDialog, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXComposite, 1); FXPrintDialog_reparent(arg1,arg2); return Qnil; }
static VALUE _wrap_FXPrintDialog_show__SWIG_0(int argc, VALUE *argv, VALUE self) { FXPrintDialog *arg1 = (FXPrintDialog *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPrintDialog, 1); FXPrintDialog_show(arg1); return Qnil; }
static VALUE _wrap_FXPrintDialog_hide(int argc, VALUE *argv, VALUE self) { FXPrintDialog *arg1 = (FXPrintDialog *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPrintDialog, 1); FXPrintDialog_hide(arg1); return Qnil; }
static VALUE _wrap_FXPrintDialog_isComposite(int argc, VALUE *argv, VALUE self) { FXPrintDialog *arg1 = (FXPrintDialog *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPrintDialog, 1);
    result = (FXbool)FXPrintDialog_isComposite((FXPrintDialog const *)arg1); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXPrintDialog_contains(int argc, VALUE *argv, VALUE self) { FXPrintDialog *arg1 = (FXPrintDialog *) 0 ;
    FXint arg2 ; FXint arg3 ; FXbool result; VALUE vresult = Qnil; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPrintDialog, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    result = (FXbool)FXPrintDialog_contains((FXPrintDialog const *)arg1,arg2,arg3); vresult = result ? Qtrue : Qfalse;
    return vresult; }
static VALUE _wrap_FXPrintDialog_doesSaveUnder(int argc, VALUE *argv, VALUE self) { FXPrintDialog *arg1 = (FXPrintDialog *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPrintDialog, 1);
    result = (FXbool)FXPrintDialog_doesSaveUnder((FXPrintDialog const *)arg1); vresult = result ? Qtrue : Qfalse;
    return vresult; }
static VALUE _wrap_FXPrintDialog_setBackColor(int argc, VALUE *argv, VALUE self) { FXPrintDialog *arg1 = (FXPrintDialog *) 0 ;
    FXColor arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPrintDialog, 1); arg2 = to_FXColor(argv[0]);
    FXPrintDialog_setBackColor(arg1,arg2); return Qnil; }
static VALUE _wrap_FXPrintDialog_show__SWIG_1(int argc, VALUE *argv, VALUE self) { FXPrintDialog *arg1 = (FXPrintDialog *) 0 ;
    FXuint arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPrintDialog, 1); arg2 = NUM2UINT(argv[0]);
    FXPrintDialog_show(arg1,arg2); return Qnil; }
static VALUE _wrap_FXPrintDialog_show(int nargs, VALUE *args, VALUE self) { int argc; VALUE argv[3]; int ii; argc = nargs + 1;
    argv[0] = self; for (ii = 1; (ii < argc) && (ii < 2); ii++) { argv[ii] = args[ii-1]; }  if (argc == 1) { int _v; {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXPrintDialog, 0) != -1)) ? 1 : 0; }
         if (_v) { return _wrap_FXPrintDialog_show__SWIG_0(nargs, args, self);}  }  if (argc == 2) { int _v; { void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXPrintDialog, 0) != -1)) ? 1 : 0; }
         if (_v) { { _v = ((TYPE(argv[1]) == T_FIXNUM) || (TYPE(argv[1]) == T_BIGNUM)) ? 1 : 0; }  if (_v) {
                return _wrap_FXPrintDialog_show__SWIG_1(nargs, args, self);}  }  } 
    rb_raise(rb_eArgError, "No matching function for overloaded 'FXPrintDialog_show'"); return Qnil; }
static VALUE _wrap_FXPrintDialog_maximize(int argc, VALUE *argv, VALUE self) { FXPrintDialog *arg1 = (FXPrintDialog *) 0 ;
    FXbool arg2 = (FXbool) 0 ; FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPrintDialog, 1); if (argc > 0) { arg2 = to_FXbool(argv[0]); } 
    result = (FXbool)FXPrintDialog_maximize(arg1,arg2); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXPrintDialog_minimize(int argc, VALUE *argv, VALUE self) { FXPrintDialog *arg1 = (FXPrintDialog *) 0 ;
    FXbool arg2 = (FXbool) 0 ; FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPrintDialog, 1); if (argc > 0) { arg2 = to_FXbool(argv[0]); } 
    result = (FXbool)FXPrintDialog_minimize(arg1,arg2); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXPrintDialog_restore(int argc, VALUE *argv, VALUE self) { FXPrintDialog *arg1 = (FXPrintDialog *) 0 ;
    FXbool arg2 = (FXbool) 0 ; FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPrintDialog, 1); if (argc > 0) { arg2 = to_FXbool(argv[0]); } 
    result = (FXbool)FXPrintDialog_restore(arg1,arg2); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXPrintDialog_close(int argc, VALUE *argv, VALUE self) { FXPrintDialog *arg1 = (FXPrintDialog *) 0 ;
    FXbool arg2 = (FXbool) 0 ; FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPrintDialog, 1); if (argc > 0) { arg2 = to_FXbool(argv[0]); } 
    result = (FXbool)FXPrintDialog_close(arg1,arg2); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXPrintDialog_execute(int argc, VALUE *argv, VALUE self) { FXPrintDialog *arg1 = (FXPrintDialog *) 0 ;
    FXuint arg2 = (FXuint) PLACEMENT_CURSOR ; FXuint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPrintDialog, 1); if (argc > 0) { arg2 = NUM2UINT(argv[0]); } 
    result = (FXuint)FXPrintDialog_execute(arg1,arg2); vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXProgressDialog_onCmdSetValue(int argc, VALUE *argv, VALUE self) {
    FXProgressDialog *arg1 = (FXProgressDialog *) 0 ; FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ;
    void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil; if ((argc < 3) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXProgressDialog, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]);
    arg4 = reinterpret_cast<void*>(NUM2INT(argv[2])); result = (long)(arg1)->onCmdSetValue(arg2,arg3,arg4);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXProgressDialog_onCmdSetIntValue(int argc, VALUE *argv, VALUE self) {
    FXProgressDialog *arg1 = (FXProgressDialog *) 0 ; FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ;
    void *arg4 = (void *) 0 ; long result; FXint value4 ; VALUE vresult = Qnil; if ((argc < 3) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXProgressDialog, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); {
        value4 = (FXint) NUM2INT(argv[2]); arg4 = static_cast<void*>(&value4); } 
    result = (long)(arg1)->onCmdSetIntValue(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXProgressDialog_onCmdGetIntValue(int argc, VALUE *argv, VALUE self) {
    FXProgressDialog *arg1 = (FXProgressDialog *) 0 ; FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ;
    void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil; if ((argc < 3) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXProgressDialog, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdGetIntValue(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXProgressDialog_onCmdSetStringValue(int argc, VALUE *argv, VALUE self) {
    FXProgressDialog *arg1 = (FXProgressDialog *) 0 ; FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ;
    void *arg4 = (void *) 0 ; long result; FXString value4 ; VALUE vresult = Qnil; if ((argc < 3) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXProgressDialog, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); {
        value4 = FXString(STR2CSTR(argv[2])); arg4 = (void *) &value4; } 
    result = (long)(arg1)->onCmdSetStringValue(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXProgressDialog_onCmdGetStringValue(int argc, VALUE *argv, VALUE self) {
    FXProgressDialog *arg1 = (FXProgressDialog *) 0 ; FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ;
    void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil; if ((argc < 3) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXProgressDialog, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdGetStringValue(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXProgressDialog_onCmdCancel(int argc, VALUE *argv, VALUE self) {
    FXProgressDialog *arg1 = (FXProgressDialog *) 0 ; FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ;
    void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil; if ((argc < 3) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXProgressDialog, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdCancel(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE _wrap_FXProgressDialog_allocate(VALUE self) {
#else
     static VALUE _wrap_FXProgressDialog_allocate(int argc, VALUE *argv, VALUE self) {
#endif
         VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_FXProgressDialog);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
         return vresult; }
static VALUE _wrap_new_FXProgressDialog(int argc, VALUE *argv, VALUE self) { FXWindow *arg1 = (FXWindow *) 0 ;
    FXString *arg2 = 0 ; FXString *arg3 = 0 ; FXuint arg4 = (FXuint) PROGRESSDIALOG_NORMAL ; FXint arg5 = (FXint) 0 ;
    FXint arg6 = (FXint) 0 ; FXint arg7 = (FXint) 0 ; FXint arg8 = (FXint) 0 ; FXProgressDialog *result;
    SwigValueWrapper<FXString > p2 ; SwigValueWrapper<FXString > p3 ; if ((argc < 3) || (argc > 8))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXWindow, 1); p2 = to_FXString(argv[1]); arg2 = &p2;
    p3 = to_FXString(argv[2]); arg3 = &p3; if (argc > 3) { arg4 = NUM2UINT(argv[3]); }  if (argc > 4) {
        arg5 = NUM2INT(argv[4]); }  if (argc > 5) { arg6 = NUM2INT(argv[5]); }  if (argc > 6) { arg7 = NUM2INT(argv[6]); } 
    if (argc > 7) { arg8 = NUM2INT(argv[7]); }  {
        result = (FXProgressDialog *)new_FXProgressDialog(arg1,(FXString const &)*arg2,(FXString const &)*arg3,arg4,arg5,arg6,arg7,arg8);
        DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result); if(rb_block_given_p()){ rb_yield(self); }  }  return self; }
static VALUE _wrap_FXProgressDialog_setMessage(int argc, VALUE *argv, VALUE self) {
    FXProgressDialog *arg1 = (FXProgressDialog *) 0 ; FXString *arg2 = 0 ; SwigValueWrapper<FXString > p2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXProgressDialog, 1); p2 = to_FXString(argv[0]); arg2 = &p2;
    (arg1)->setMessage((FXString const &)*arg2); return Qnil; }
static VALUE _wrap_FXProgressDialog_getMessage(int argc, VALUE *argv, VALUE self) {
    FXProgressDialog *arg1 = (FXProgressDialog *) 0 ; FXString result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXProgressDialog, 1);
    result = ((FXProgressDialog const *)arg1)->getMessage(); vresult = rb_str_new2((&result)->text()); return vresult; }
static VALUE _wrap_FXProgressDialog_setBarStyle(int argc, VALUE *argv, VALUE self) {
    FXProgressDialog *arg1 = (FXProgressDialog *) 0 ; FXuint arg2 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXProgressDialog, 1); arg2 = NUM2UINT(argv[0]); (arg1)->setBarStyle(arg2);
    return Qnil; }
static VALUE _wrap_FXProgressDialog_getBarStyle(int argc, VALUE *argv, VALUE self) {
    FXProgressDialog *arg1 = (FXProgressDialog *) 0 ; FXuint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXProgressDialog, 1);
    result = (FXuint)((FXProgressDialog const *)arg1)->getBarStyle(); vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXProgressDialog_setProgress(int argc, VALUE *argv, VALUE self) {
    FXProgressDialog *arg1 = (FXProgressDialog *) 0 ; FXuint arg2 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXProgressDialog, 1); arg2 = NUM2UINT(argv[0]); (arg1)->setProgress(arg2);
    return Qnil; }
static VALUE _wrap_FXProgressDialog_getProgress(int argc, VALUE *argv, VALUE self) {
    FXProgressDialog *arg1 = (FXProgressDialog *) 0 ; FXuint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXProgressDialog, 1);
    result = (FXuint)((FXProgressDialog const *)arg1)->getProgress(); vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXProgressDialog_setTotal(int argc, VALUE *argv, VALUE self) {
    FXProgressDialog *arg1 = (FXProgressDialog *) 0 ; FXuint arg2 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXProgressDialog, 1); arg2 = NUM2UINT(argv[0]); (arg1)->setTotal(arg2);
    return Qnil; }
static VALUE _wrap_FXProgressDialog_getTotal(int argc, VALUE *argv, VALUE self) {
    FXProgressDialog *arg1 = (FXProgressDialog *) 0 ; FXuint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXProgressDialog, 1);
    result = (FXuint)((FXProgressDialog const *)arg1)->getTotal(); vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXProgressDialog_increment(int argc, VALUE *argv, VALUE self) {
    FXProgressDialog *arg1 = (FXProgressDialog *) 0 ; FXuint arg2 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXProgressDialog, 1); arg2 = NUM2UINT(argv[0]); (arg1)->increment(arg2);
    return Qnil; }
static VALUE _wrap_FXProgressDialog_isCancelled(int argc, VALUE *argv, VALUE self) {
    FXProgressDialog *arg1 = (FXProgressDialog *) 0 ; FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXProgressDialog, 1);
    result = (FXbool)((FXProgressDialog const *)arg1)->isCancelled(); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXProgressDialog_setCancelled(int argc, VALUE *argv, VALUE self) {
    FXProgressDialog *arg1 = (FXProgressDialog *) 0 ; FXbool arg2 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXProgressDialog, 1); arg2 = to_FXbool(argv[0]);
    (arg1)->setCancelled(arg2); return Qnil; }
static void
free_FXProgressDialog(FXProgressDialog *arg1) {
    delete arg1;
}
static VALUE _wrap_FXProgressDialog_save(int argc, VALUE *argv, VALUE self) { FXProgressDialog *arg1 = (FXProgressDialog *) 0 ;
    FXStream *arg2 = 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXProgressDialog, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXProgressDialog_save((FXProgressDialog const *)arg1,*arg2); return Qnil; }
static VALUE _wrap_FXProgressDialog_load(int argc, VALUE *argv, VALUE self) { FXProgressDialog *arg1 = (FXProgressDialog *) 0 ;
    FXStream *arg2 = 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXProgressDialog, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXProgressDialog_load(arg1,*arg2); return Qnil; }
static VALUE _wrap_FXProgressDialog_create(int argc, VALUE *argv, VALUE self) {
    FXProgressDialog *arg1 = (FXProgressDialog *) 0 ; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXProgressDialog, 1); FXProgressDialog_create(arg1); return Qnil; }
static VALUE _wrap_FXProgressDialog_detach(int argc, VALUE *argv, VALUE self) {
    FXProgressDialog *arg1 = (FXProgressDialog *) 0 ; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXProgressDialog, 1); FXProgressDialog_detach(arg1); return Qnil; }
static VALUE _wrap_FXProgressDialog_destroy(int argc, VALUE *argv, VALUE self) {
    FXProgressDialog *arg1 = (FXProgressDialog *) 0 ; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXProgressDialog, 1); FXProgressDialog_destroy(arg1); return Qnil; }
static VALUE _wrap_FXProgressDialog_resize(int argc, VALUE *argv, VALUE self) {
    FXProgressDialog *arg1 = (FXProgressDialog *) 0 ; FXint arg2 ; FXint arg3 ; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXProgressDialog, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    FXProgressDialog_resize(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXProgressDialog_getDefaultWidth(int argc, VALUE *argv, VALUE self) {
    FXProgressDialog *arg1 = (FXProgressDialog *) 0 ; FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXProgressDialog, 1);
    result = (FXint)FXProgressDialog_getDefaultWidth(arg1); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXProgressDialog_getDefaultHeight(int argc, VALUE *argv, VALUE self) {
    FXProgressDialog *arg1 = (FXProgressDialog *) 0 ; FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXProgressDialog, 1);
    result = (FXint)FXProgressDialog_getDefaultHeight(arg1); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXProgressDialog_getWidthForHeight(int argc, VALUE *argv, VALUE self) {
    FXProgressDialog *arg1 = (FXProgressDialog *) 0 ; FXint arg2 ; FXint result; VALUE vresult = Qnil;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXProgressDialog, 1); arg2 = NUM2INT(argv[0]);
    result = (FXint)FXProgressDialog_getWidthForHeight(arg1,arg2); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXProgressDialog_getHeightForWidth(int argc, VALUE *argv, VALUE self) {
    FXProgressDialog *arg1 = (FXProgressDialog *) 0 ; FXint arg2 ; FXint result; VALUE vresult = Qnil;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXProgressDialog, 1); arg2 = NUM2INT(argv[0]);
    result = (FXint)FXProgressDialog_getHeightForWidth(arg1,arg2); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXProgressDialog_canFocus(int argc, VALUE *argv, VALUE self) {
    FXProgressDialog *arg1 = (FXProgressDialog *) 0 ; FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXProgressDialog, 1);
    result = (FXbool)FXProgressDialog_canFocus((FXProgressDialog const *)arg1); vresult = result ? Qtrue : Qfalse;
    return vresult; }
static VALUE _wrap_FXProgressDialog_setFocus(int argc, VALUE *argv, VALUE self) {
    FXProgressDialog *arg1 = (FXProgressDialog *) 0 ; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXProgressDialog, 1); FXProgressDialog_setFocus(arg1); return Qnil; }
static VALUE _wrap_FXProgressDialog_killFocus(int argc, VALUE *argv, VALUE self) {
    FXProgressDialog *arg1 = (FXProgressDialog *) 0 ; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXProgressDialog, 1); FXProgressDialog_killFocus(arg1); return Qnil; }
static VALUE _wrap_FXProgressDialog_setDefault(int argc, VALUE *argv, VALUE self) {
    FXProgressDialog *arg1 = (FXProgressDialog *) 0 ; FXbool arg2 = (FXbool) 1 ; if ((argc < 0) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXProgressDialog, 1); if (argc > 0) { arg2 = to_FXbool(argv[0]); } 
    FXProgressDialog_setDefault(arg1,arg2); return Qnil; }
static VALUE _wrap_FXProgressDialog_enable(int argc, VALUE *argv, VALUE self) {
    FXProgressDialog *arg1 = (FXProgressDialog *) 0 ; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXProgressDialog, 1); FXProgressDialog_enable(arg1); return Qnil; }
static VALUE _wrap_FXProgressDialog_disable(int argc, VALUE *argv, VALUE self) {
    FXProgressDialog *arg1 = (FXProgressDialog *) 0 ; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXProgressDialog, 1); FXProgressDialog_disable(arg1); return Qnil; }
static VALUE _wrap_FXProgressDialog_raiseWindow(int argc, VALUE *argv, VALUE self) {
    FXProgressDialog *arg1 = (FXProgressDialog *) 0 ; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXProgressDialog, 1); FXProgressDialog_raise(arg1); return Qnil; }
static VALUE _wrap_FXProgressDialog_lower(int argc, VALUE *argv, VALUE self) { FXProgressDialog *arg1 = (FXProgressDialog *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXProgressDialog, 1); FXProgressDialog_lower(arg1); return Qnil; }
static VALUE _wrap_FXProgressDialog_move(int argc, VALUE *argv, VALUE self) { FXProgressDialog *arg1 = (FXProgressDialog *) 0 ;
    FXint arg2 ; FXint arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXProgressDialog, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    FXProgressDialog_move(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXProgressDialog_position(int argc, VALUE *argv, VALUE self) {
    FXProgressDialog *arg1 = (FXProgressDialog *) 0 ; FXint arg2 ; FXint arg3 ; FXint arg4 ; FXint arg5 ;
    if ((argc < 4) || (argc > 4)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXProgressDialog, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    arg4 = NUM2INT(argv[2]); arg5 = NUM2INT(argv[3]); FXProgressDialog_position(arg1,arg2,arg3,arg4,arg5); return Qnil; }
static VALUE _wrap_FXProgressDialog_layout(int argc, VALUE *argv, VALUE self) {
    FXProgressDialog *arg1 = (FXProgressDialog *) 0 ; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXProgressDialog, 1); FXProgressDialog_layout(arg1); return Qnil; }
static VALUE _wrap_FXProgressDialog_recalc(int argc, VALUE *argv, VALUE self) {
    FXProgressDialog *arg1 = (FXProgressDialog *) 0 ; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXProgressDialog, 1); FXProgressDialog_recalc(arg1); return Qnil; }
static VALUE _wrap_FXProgressDialog_reparent(int argc, VALUE *argv, VALUE self) {
    FXProgressDialog *arg1 = (FXProgressDialog *) 0 ; FXComposite *arg2 = (FXComposite *) 0 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXProgressDialog, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXComposite, 1); FXProgressDialog_reparent(arg1,arg2); return Qnil; }
static VALUE _wrap_FXProgressDialog_show__SWIG_0(int argc, VALUE *argv, VALUE self) {
    FXProgressDialog *arg1 = (FXProgressDialog *) 0 ; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXProgressDialog, 1); FXProgressDialog_show(arg1); return Qnil; }
static VALUE _wrap_FXProgressDialog_hide(int argc, VALUE *argv, VALUE self) { FXProgressDialog *arg1 = (FXProgressDialog *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXProgressDialog, 1); FXProgressDialog_hide(arg1); return Qnil; }
static VALUE _wrap_FXProgressDialog_isComposite(int argc, VALUE *argv, VALUE self) {
    FXProgressDialog *arg1 = (FXProgressDialog *) 0 ; FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXProgressDialog, 1);
    result = (FXbool)FXProgressDialog_isComposite((FXProgressDialog const *)arg1); vresult = result ? Qtrue : Qfalse;
    return vresult; }
static VALUE _wrap_FXProgressDialog_contains(int argc, VALUE *argv, VALUE self) {
    FXProgressDialog *arg1 = (FXProgressDialog *) 0 ; FXint arg2 ; FXint arg3 ; FXbool result; VALUE vresult = Qnil;
    if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXProgressDialog, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    result = (FXbool)FXProgressDialog_contains((FXProgressDialog const *)arg1,arg2,arg3); vresult = result ? Qtrue : Qfalse;
    return vresult; }
static VALUE _wrap_FXProgressDialog_doesSaveUnder(int argc, VALUE *argv, VALUE self) {
    FXProgressDialog *arg1 = (FXProgressDialog *) 0 ; FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXProgressDialog, 1);
    result = (FXbool)FXProgressDialog_doesSaveUnder((FXProgressDialog const *)arg1); vresult = result ? Qtrue : Qfalse;
    return vresult; }
static VALUE _wrap_FXProgressDialog_setBackColor(int argc, VALUE *argv, VALUE self) {
    FXProgressDialog *arg1 = (FXProgressDialog *) 0 ; FXColor arg2 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXProgressDialog, 1); arg2 = to_FXColor(argv[0]);
    FXProgressDialog_setBackColor(arg1,arg2); return Qnil; }
static VALUE _wrap_FXProgressDialog_show__SWIG_1(int argc, VALUE *argv, VALUE self) {
    FXProgressDialog *arg1 = (FXProgressDialog *) 0 ; FXuint arg2 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXProgressDialog, 1); arg2 = NUM2UINT(argv[0]);
    FXProgressDialog_show(arg1,arg2); return Qnil; }
static VALUE _wrap_FXProgressDialog_show(int nargs, VALUE *args, VALUE self) { int argc; VALUE argv[3]; int ii;
    argc = nargs + 1; argv[0] = self; for (ii = 1; (ii < argc) && (ii < 2); ii++) { argv[ii] = args[ii-1]; }  if (argc == 1) {
        int _v; { void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXProgressDialog, 0) != -1)) ? 1 : 0; }
         if (_v) { return _wrap_FXProgressDialog_show__SWIG_0(nargs, args, self);}  }  if (argc == 2) { int _v; { void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXProgressDialog, 0) != -1)) ? 1 : 0; }
         if (_v) { { _v = ((TYPE(argv[1]) == T_FIXNUM) || (TYPE(argv[1]) == T_BIGNUM)) ? 1 : 0; }  if (_v) {
                return _wrap_FXProgressDialog_show__SWIG_1(nargs, args, self);}  }  } 
    rb_raise(rb_eArgError, "No matching function for overloaded 'FXProgressDialog_show'"); return Qnil; }
static VALUE _wrap_FXProgressDialog_maximize(int argc, VALUE *argv, VALUE self) {
    FXProgressDialog *arg1 = (FXProgressDialog *) 0 ; FXbool arg2 = (FXbool) 0 ; FXbool result; VALUE vresult = Qnil;
    if ((argc < 0) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXProgressDialog, 1); if (argc > 0) { arg2 = to_FXbool(argv[0]); } 
    result = (FXbool)FXProgressDialog_maximize(arg1,arg2); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXProgressDialog_minimize(int argc, VALUE *argv, VALUE self) {
    FXProgressDialog *arg1 = (FXProgressDialog *) 0 ; FXbool arg2 = (FXbool) 0 ; FXbool result; VALUE vresult = Qnil;
    if ((argc < 0) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXProgressDialog, 1); if (argc > 0) { arg2 = to_FXbool(argv[0]); } 
    result = (FXbool)FXProgressDialog_minimize(arg1,arg2); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXProgressDialog_restore(int argc, VALUE *argv, VALUE self) {
    FXProgressDialog *arg1 = (FXProgressDialog *) 0 ; FXbool arg2 = (FXbool) 0 ; FXbool result; VALUE vresult = Qnil;
    if ((argc < 0) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXProgressDialog, 1); if (argc > 0) { arg2 = to_FXbool(argv[0]); } 
    result = (FXbool)FXProgressDialog_restore(arg1,arg2); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXProgressDialog_close(int argc, VALUE *argv, VALUE self) { FXProgressDialog *arg1 = (FXProgressDialog *) 0 ;
    FXbool arg2 = (FXbool) 0 ; FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXProgressDialog, 1); if (argc > 0) { arg2 = to_FXbool(argv[0]); } 
    result = (FXbool)FXProgressDialog_close(arg1,arg2); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXProgressDialog_execute(int argc, VALUE *argv, VALUE self) {
    FXProgressDialog *arg1 = (FXProgressDialog *) 0 ; FXuint arg2 = (FXuint) PLACEMENT_CURSOR ; FXuint result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXProgressDialog, 1); if (argc > 0) { arg2 = NUM2UINT(argv[0]); } 
    result = (FXuint)FXProgressDialog_execute(arg1,arg2); vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXMessageBox_onCmdClicked(int argc, VALUE *argv, VALUE self) { FXMessageBox *arg1 = (FXMessageBox *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMessageBox, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdClicked(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXMessageBox_onCmdCancel(int argc, VALUE *argv, VALUE self) { FXMessageBox *arg1 = (FXMessageBox *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMessageBox, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdCancel(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_new_FXMessageBox__SWIG_0(int argc, VALUE *argv, VALUE self) { FXWindow *arg1 = (FXWindow *) 0 ;
    FXString *arg2 = 0 ; FXString *arg3 = 0 ; FXIcon *arg4 = (FXIcon *) 0 ; FXuint arg5 = (FXuint) 0 ; FXint arg6 = (FXint) 0 ;
    FXint arg7 = (FXint) 0 ; FXMessageBox *result; SwigValueWrapper<FXString > p2 ; SwigValueWrapper<FXString > p3 ;
    if ((argc < 3) || (argc > 7)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXWindow, 1); p2 = to_FXString(argv[1]); arg2 = &p2;
    p3 = to_FXString(argv[2]); arg3 = &p3; if (argc > 3) { SWIG_ConvertPtr(argv[3], (void **) &arg4, SWIGTYPE_p_FXIcon, 1); } 
    if (argc > 4) { arg5 = NUM2UINT(argv[4]); }  if (argc > 5) { arg6 = NUM2INT(argv[5]); }  if (argc > 6) {
        arg7 = NUM2INT(argv[6]); }  {
        result = (FXMessageBox *)new_FXMessageBox__SWIG_0(arg1,(FXString const &)*arg2,(FXString const &)*arg3,arg4,arg5,arg6,arg7);
        DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result); if(rb_block_given_p()){ rb_yield(self); }  }  return self; }
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE _wrap_FXMessageBox_allocate(VALUE self) {
#else
     static VALUE _wrap_FXMessageBox_allocate(int argc, VALUE *argv, VALUE self) {
#endif
         VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_FXMessageBox);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
         return vresult; }
static VALUE _wrap_new_FXMessageBox__SWIG_1(int argc, VALUE *argv, VALUE self) { FXApp *arg1 = (FXApp *) 0 ;
    FXString *arg2 = 0 ; FXString *arg3 = 0 ; FXIcon *arg4 = (FXIcon *) 0 ; FXuint arg5 = (FXuint) 0 ; FXint arg6 = (FXint) 0 ;
    FXint arg7 = (FXint) 0 ; FXMessageBox *result; SwigValueWrapper<FXString > p2 ; SwigValueWrapper<FXString > p3 ;
    if ((argc < 3) || (argc > 7)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXApp, 1); p2 = to_FXString(argv[1]); arg2 = &p2;
    p3 = to_FXString(argv[2]); arg3 = &p3; if (argc > 3) { SWIG_ConvertPtr(argv[3], (void **) &arg4, SWIGTYPE_p_FXIcon, 1); } 
    if (argc > 4) { arg5 = NUM2UINT(argv[4]); }  if (argc > 5) { arg6 = NUM2INT(argv[5]); }  if (argc > 6) {
        arg7 = NUM2INT(argv[6]); }  {
        result = (FXMessageBox *)new_FXMessageBox__SWIG_1(arg1,(FXString const &)*arg2,(FXString const &)*arg3,arg4,arg5,arg6,arg7);
        DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result); if(rb_block_given_p()){ rb_yield(self); }  }  return self; }
static VALUE _wrap_new_FXMessageBox(int nargs, VALUE *args, VALUE self) { int argc; VALUE argv[7]; int ii; argc = nargs;
    for (ii = 0; (ii < argc) && (ii < 7); ii++) { argv[ii] = args[ii]; }  if ((argc >= 3) && (argc <= 7)) { int _v; { void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXWindow, 0) != -1)) ? 1 : 0; }
         if (_v) { { _v = (NIL_P(argv[1]) || TYPE(argv[1]) == T_STRING) ? 1 : 0; }  if (_v) { {
                    _v = (NIL_P(argv[2]) || TYPE(argv[2]) == T_STRING) ? 1 : 0; }  if (_v) { if (argc <= 3) {
                        return _wrap_new_FXMessageBox__SWIG_0(nargs, args, self);}  { void *ptr;
                        _v = (NIL_P(argv[3]) || (TYPE(argv[3]) == T_DATA && SWIG_ConvertPtr(argv[3], &ptr, SWIGTYPE_p_FXIcon, 0) != -1)) ? 1 : 0; }
                     if (_v) { if (argc <= 4) { return _wrap_new_FXMessageBox__SWIG_0(nargs, args, self);}  {
                            _v = ((TYPE(argv[4]) == T_FIXNUM) || (TYPE(argv[4]) == T_BIGNUM)) ? 1 : 0; }  if (_v) {
                            if (argc <= 5) { return _wrap_new_FXMessageBox__SWIG_0(nargs, args, self);}  {
                                _v = ((TYPE(argv[5]) == T_FIXNUM) || (TYPE(argv[5]) == T_BIGNUM)) ? 1 : 0; }  if (_v) {
                                if (argc <= 6) { return _wrap_new_FXMessageBox__SWIG_0(nargs, args, self);}  {
                                    _v = ((TYPE(argv[6]) == T_FIXNUM) || (TYPE(argv[6]) == T_BIGNUM)) ? 1 : 0; }  if (_v) {
                                    return _wrap_new_FXMessageBox__SWIG_0(nargs, args, self);}  }  }  }  }  }  }  } 
    if ((argc >= 3) && (argc <= 7)) { int _v; { void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXApp, 0) != -1)) ? 1 : 0; }
         if (_v) { { _v = (NIL_P(argv[1]) || TYPE(argv[1]) == T_STRING) ? 1 : 0; }  if (_v) { {
                    _v = (NIL_P(argv[2]) || TYPE(argv[2]) == T_STRING) ? 1 : 0; }  if (_v) { if (argc <= 3) {
                        return _wrap_new_FXMessageBox__SWIG_1(nargs, args, self);}  { void *ptr;
                        _v = (NIL_P(argv[3]) || (TYPE(argv[3]) == T_DATA && SWIG_ConvertPtr(argv[3], &ptr, SWIGTYPE_p_FXIcon, 0) != -1)) ? 1 : 0; }
                     if (_v) { if (argc <= 4) { return _wrap_new_FXMessageBox__SWIG_1(nargs, args, self);}  {
                            _v = ((TYPE(argv[4]) == T_FIXNUM) || (TYPE(argv[4]) == T_BIGNUM)) ? 1 : 0; }  if (_v) {
                            if (argc <= 5) { return _wrap_new_FXMessageBox__SWIG_1(nargs, args, self);}  {
                                _v = ((TYPE(argv[5]) == T_FIXNUM) || (TYPE(argv[5]) == T_BIGNUM)) ? 1 : 0; }  if (_v) {
                                if (argc <= 6) { return _wrap_new_FXMessageBox__SWIG_1(nargs, args, self);}  {
                                    _v = ((TYPE(argv[6]) == T_FIXNUM) || (TYPE(argv[6]) == T_BIGNUM)) ? 1 : 0; }  if (_v) {
                                    return _wrap_new_FXMessageBox__SWIG_1(nargs, args, self);}  }  }  }  }  }  }  } 
    rb_raise(rb_eArgError, "No matching function for overloaded 'new_FXMessageBox'"); return Qnil; }
static VALUE _wrap_FXMessageBox_error__SWIG_0(int argc, VALUE *argv, VALUE self) { FXWindow *arg1 = (FXWindow *) 0 ;
    FXuint arg2 ; char *arg3 ; char *arg4 ; FXuint result; VALUE vresult = Qnil; if ((argc < 4) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXWindow, 1); arg2 = NUM2UINT(argv[1]); arg3 = StringValuePtr(argv[2]);
    arg4 = StringValuePtr(argv[3]); result = (FXuint)FXMessageBox::error(arg1,arg2,(char const *)arg3,(char const *)arg4);
    vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXMessageBox_error__SWIG_1(int argc, VALUE *argv, VALUE self) { FXApp *arg1 = (FXApp *) 0 ; FXuint arg2 ;
    char *arg3 ; char *arg4 ; FXuint result; VALUE vresult = Qnil; if ((argc < 4) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXApp, 1); arg2 = NUM2UINT(argv[1]); arg3 = StringValuePtr(argv[2]);
    arg4 = StringValuePtr(argv[3]); result = (FXuint)FXMessageBox::error(arg1,arg2,(char const *)arg3,(char const *)arg4);
    vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXMessageBox_error(int nargs, VALUE *args, VALUE self) { int argc; VALUE argv[4]; int ii; argc = nargs;
    for (ii = 0; (ii < argc) && (ii < 4); ii++) { argv[ii] = args[ii]; }  if (argc == 4) { int _v; { void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXWindow, 0) != -1)) ? 1 : 0; }
         if (_v) { { _v = ((TYPE(argv[1]) == T_FIXNUM) || (TYPE(argv[1]) == T_BIGNUM)) ? 1 : 0; }  if (_v) { {
                    _v = (TYPE(argv[2]) == T_STRING) ? 1 : 0; }  if (_v) { { _v = (TYPE(argv[3]) == T_STRING) ? 1 : 0; } 
                    if (_v) { return _wrap_FXMessageBox_error__SWIG_0(nargs, args, self);}  }  }  }  }  if (argc == 4) { int _v;
        { void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXApp, 0) != -1)) ? 1 : 0; }
         if (_v) { { _v = ((TYPE(argv[1]) == T_FIXNUM) || (TYPE(argv[1]) == T_BIGNUM)) ? 1 : 0; }  if (_v) { {
                    _v = (TYPE(argv[2]) == T_STRING) ? 1 : 0; }  if (_v) { { _v = (TYPE(argv[3]) == T_STRING) ? 1 : 0; } 
                    if (_v) { return _wrap_FXMessageBox_error__SWIG_1(nargs, args, self);}  }  }  }  } 
    rb_raise(rb_eArgError, "No matching function for overloaded 'FXMessageBox_error'"); return Qnil; }
static VALUE _wrap_FXMessageBox_warning__SWIG_0(int argc, VALUE *argv, VALUE self) { FXWindow *arg1 = (FXWindow *) 0 ;
    FXuint arg2 ; char *arg3 ; char *arg4 ; FXuint result; VALUE vresult = Qnil; if ((argc < 4) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXWindow, 1); arg2 = NUM2UINT(argv[1]); arg3 = StringValuePtr(argv[2]);
    arg4 = StringValuePtr(argv[3]); result = (FXuint)FXMessageBox::warning(arg1,arg2,(char const *)arg3,(char const *)arg4);
    vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXMessageBox_warning__SWIG_1(int argc, VALUE *argv, VALUE self) { FXApp *arg1 = (FXApp *) 0 ; FXuint arg2 ;
    char *arg3 ; char *arg4 ; FXuint result; VALUE vresult = Qnil; if ((argc < 4) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXApp, 1); arg2 = NUM2UINT(argv[1]); arg3 = StringValuePtr(argv[2]);
    arg4 = StringValuePtr(argv[3]); result = (FXuint)FXMessageBox::warning(arg1,arg2,(char const *)arg3,(char const *)arg4);
    vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXMessageBox_warning(int nargs, VALUE *args, VALUE self) { int argc; VALUE argv[4]; int ii; argc = nargs;
    for (ii = 0; (ii < argc) && (ii < 4); ii++) { argv[ii] = args[ii]; }  if (argc == 4) { int _v; { void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXWindow, 0) != -1)) ? 1 : 0; }
         if (_v) { { _v = ((TYPE(argv[1]) == T_FIXNUM) || (TYPE(argv[1]) == T_BIGNUM)) ? 1 : 0; }  if (_v) { {
                    _v = (TYPE(argv[2]) == T_STRING) ? 1 : 0; }  if (_v) { { _v = (TYPE(argv[3]) == T_STRING) ? 1 : 0; } 
                    if (_v) { return _wrap_FXMessageBox_warning__SWIG_0(nargs, args, self);}  }  }  }  }  if (argc == 4) {
        int _v; { void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXApp, 0) != -1)) ? 1 : 0; }
         if (_v) { { _v = ((TYPE(argv[1]) == T_FIXNUM) || (TYPE(argv[1]) == T_BIGNUM)) ? 1 : 0; }  if (_v) { {
                    _v = (TYPE(argv[2]) == T_STRING) ? 1 : 0; }  if (_v) { { _v = (TYPE(argv[3]) == T_STRING) ? 1 : 0; } 
                    if (_v) { return _wrap_FXMessageBox_warning__SWIG_1(nargs, args, self);}  }  }  }  } 
    rb_raise(rb_eArgError, "No matching function for overloaded 'FXMessageBox_warning'"); return Qnil; }
static VALUE _wrap_FXMessageBox_question__SWIG_0(int argc, VALUE *argv, VALUE self) { FXWindow *arg1 = (FXWindow *) 0 ;
    FXuint arg2 ; char *arg3 ; char *arg4 ; FXuint result; VALUE vresult = Qnil; if ((argc < 4) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXWindow, 1); arg2 = NUM2UINT(argv[1]); arg3 = StringValuePtr(argv[2]);
    arg4 = StringValuePtr(argv[3]); result = (FXuint)FXMessageBox::question(arg1,arg2,(char const *)arg3,(char const *)arg4);
    vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXMessageBox_question__SWIG_1(int argc, VALUE *argv, VALUE self) { FXApp *arg1 = (FXApp *) 0 ; FXuint arg2 ;
    char *arg3 ; char *arg4 ; FXuint result; VALUE vresult = Qnil; if ((argc < 4) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXApp, 1); arg2 = NUM2UINT(argv[1]); arg3 = StringValuePtr(argv[2]);
    arg4 = StringValuePtr(argv[3]); result = (FXuint)FXMessageBox::question(arg1,arg2,(char const *)arg3,(char const *)arg4);
    vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXMessageBox_question(int nargs, VALUE *args, VALUE self) { int argc; VALUE argv[4]; int ii; argc = nargs;
    for (ii = 0; (ii < argc) && (ii < 4); ii++) { argv[ii] = args[ii]; }  if (argc == 4) { int _v; { void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXWindow, 0) != -1)) ? 1 : 0; }
         if (_v) { { _v = ((TYPE(argv[1]) == T_FIXNUM) || (TYPE(argv[1]) == T_BIGNUM)) ? 1 : 0; }  if (_v) { {
                    _v = (TYPE(argv[2]) == T_STRING) ? 1 : 0; }  if (_v) { { _v = (TYPE(argv[3]) == T_STRING) ? 1 : 0; } 
                    if (_v) { return _wrap_FXMessageBox_question__SWIG_0(nargs, args, self);}  }  }  }  }  if (argc == 4) {
        int _v; { void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXApp, 0) != -1)) ? 1 : 0; }
         if (_v) { { _v = ((TYPE(argv[1]) == T_FIXNUM) || (TYPE(argv[1]) == T_BIGNUM)) ? 1 : 0; }  if (_v) { {
                    _v = (TYPE(argv[2]) == T_STRING) ? 1 : 0; }  if (_v) { { _v = (TYPE(argv[3]) == T_STRING) ? 1 : 0; } 
                    if (_v) { return _wrap_FXMessageBox_question__SWIG_1(nargs, args, self);}  }  }  }  } 
    rb_raise(rb_eArgError, "No matching function for overloaded 'FXMessageBox_question'"); return Qnil; }
static VALUE _wrap_FXMessageBox_information__SWIG_0(int argc, VALUE *argv, VALUE self) { FXWindow *arg1 = (FXWindow *) 0 ;
    FXuint arg2 ; char *arg3 ; char *arg4 ; FXuint result; VALUE vresult = Qnil; if ((argc < 4) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXWindow, 1); arg2 = NUM2UINT(argv[1]); arg3 = StringValuePtr(argv[2]);
    arg4 = StringValuePtr(argv[3]); result = (FXuint)FXMessageBox::information(arg1,arg2,(char const *)arg3,(char const *)arg4);
    vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXMessageBox_information__SWIG_1(int argc, VALUE *argv, VALUE self) { FXApp *arg1 = (FXApp *) 0 ;
    FXuint arg2 ; char *arg3 ; char *arg4 ; FXuint result; VALUE vresult = Qnil; if ((argc < 4) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXApp, 1); arg2 = NUM2UINT(argv[1]); arg3 = StringValuePtr(argv[2]);
    arg4 = StringValuePtr(argv[3]); result = (FXuint)FXMessageBox::information(arg1,arg2,(char const *)arg3,(char const *)arg4);
    vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXMessageBox_information(int nargs, VALUE *args, VALUE self) { int argc; VALUE argv[4]; int ii; argc = nargs;
    for (ii = 0; (ii < argc) && (ii < 4); ii++) { argv[ii] = args[ii]; }  if (argc == 4) { int _v; { void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXWindow, 0) != -1)) ? 1 : 0; }
         if (_v) { { _v = ((TYPE(argv[1]) == T_FIXNUM) || (TYPE(argv[1]) == T_BIGNUM)) ? 1 : 0; }  if (_v) { {
                    _v = (TYPE(argv[2]) == T_STRING) ? 1 : 0; }  if (_v) { { _v = (TYPE(argv[3]) == T_STRING) ? 1 : 0; } 
                    if (_v) { return _wrap_FXMessageBox_information__SWIG_0(nargs, args, self);}  }  }  }  }  if (argc == 4) {
        int _v; { void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXApp, 0) != -1)) ? 1 : 0; }
         if (_v) { { _v = ((TYPE(argv[1]) == T_FIXNUM) || (TYPE(argv[1]) == T_BIGNUM)) ? 1 : 0; }  if (_v) { {
                    _v = (TYPE(argv[2]) == T_STRING) ? 1 : 0; }  if (_v) { { _v = (TYPE(argv[3]) == T_STRING) ? 1 : 0; } 
                    if (_v) { return _wrap_FXMessageBox_information__SWIG_1(nargs, args, self);}  }  }  }  } 
    rb_raise(rb_eArgError, "No matching function for overloaded 'FXMessageBox_information'"); return Qnil; }
static void
free_FXMessageBox(FXMessageBox *arg1) {
    delete arg1;
}
static VALUE _wrap_FXMessageBox_save(int argc, VALUE *argv, VALUE self) { FXMessageBox *arg1 = (FXMessageBox *) 0 ;
    FXStream *arg2 = 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMessageBox, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXMessageBox_save((FXMessageBox const *)arg1,*arg2); return Qnil; }
static VALUE _wrap_FXMessageBox_load(int argc, VALUE *argv, VALUE self) { FXMessageBox *arg1 = (FXMessageBox *) 0 ;
    FXStream *arg2 = 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMessageBox, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXMessageBox_load(arg1,*arg2); return Qnil; }
static VALUE _wrap_FXMessageBox_create(int argc, VALUE *argv, VALUE self) { FXMessageBox *arg1 = (FXMessageBox *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMessageBox, 1); FXMessageBox_create(arg1); return Qnil; }
static VALUE _wrap_FXMessageBox_detach(int argc, VALUE *argv, VALUE self) { FXMessageBox *arg1 = (FXMessageBox *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMessageBox, 1); FXMessageBox_detach(arg1); return Qnil; }
static VALUE _wrap_FXMessageBox_destroy(int argc, VALUE *argv, VALUE self) { FXMessageBox *arg1 = (FXMessageBox *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMessageBox, 1); FXMessageBox_destroy(arg1); return Qnil; }
static VALUE _wrap_FXMessageBox_resize(int argc, VALUE *argv, VALUE self) { FXMessageBox *arg1 = (FXMessageBox *) 0 ;
    FXint arg2 ; FXint arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMessageBox, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    FXMessageBox_resize(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXMessageBox_getDefaultWidth(int argc, VALUE *argv, VALUE self) { FXMessageBox *arg1 = (FXMessageBox *) 0 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMessageBox, 1); result = (FXint)FXMessageBox_getDefaultWidth(arg1);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXMessageBox_getDefaultHeight(int argc, VALUE *argv, VALUE self) { FXMessageBox *arg1 = (FXMessageBox *) 0 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMessageBox, 1); result = (FXint)FXMessageBox_getDefaultHeight(arg1);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXMessageBox_getWidthForHeight(int argc, VALUE *argv, VALUE self) { FXMessageBox *arg1 = (FXMessageBox *) 0 ;
    FXint arg2 ; FXint result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMessageBox, 1); arg2 = NUM2INT(argv[0]);
    result = (FXint)FXMessageBox_getWidthForHeight(arg1,arg2); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXMessageBox_getHeightForWidth(int argc, VALUE *argv, VALUE self) { FXMessageBox *arg1 = (FXMessageBox *) 0 ;
    FXint arg2 ; FXint result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMessageBox, 1); arg2 = NUM2INT(argv[0]);
    result = (FXint)FXMessageBox_getHeightForWidth(arg1,arg2); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXMessageBox_canFocus(int argc, VALUE *argv, VALUE self) { FXMessageBox *arg1 = (FXMessageBox *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMessageBox, 1);
    result = (FXbool)FXMessageBox_canFocus((FXMessageBox const *)arg1); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXMessageBox_setFocus(int argc, VALUE *argv, VALUE self) { FXMessageBox *arg1 = (FXMessageBox *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMessageBox, 1); FXMessageBox_setFocus(arg1); return Qnil; }
static VALUE _wrap_FXMessageBox_killFocus(int argc, VALUE *argv, VALUE self) { FXMessageBox *arg1 = (FXMessageBox *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMessageBox, 1); FXMessageBox_killFocus(arg1); return Qnil; }
static VALUE _wrap_FXMessageBox_setDefault(int argc, VALUE *argv, VALUE self) { FXMessageBox *arg1 = (FXMessageBox *) 0 ;
    FXbool arg2 = (FXbool) 1 ; if ((argc < 0) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMessageBox, 1); if (argc > 0) { arg2 = to_FXbool(argv[0]); } 
    FXMessageBox_setDefault(arg1,arg2); return Qnil; }
static VALUE _wrap_FXMessageBox_enable(int argc, VALUE *argv, VALUE self) { FXMessageBox *arg1 = (FXMessageBox *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMessageBox, 1); FXMessageBox_enable(arg1); return Qnil; }
static VALUE _wrap_FXMessageBox_disable(int argc, VALUE *argv, VALUE self) { FXMessageBox *arg1 = (FXMessageBox *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMessageBox, 1); FXMessageBox_disable(arg1); return Qnil; }
static VALUE _wrap_FXMessageBox_raiseWindow(int argc, VALUE *argv, VALUE self) { FXMessageBox *arg1 = (FXMessageBox *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMessageBox, 1); FXMessageBox_raise(arg1); return Qnil; }
static VALUE _wrap_FXMessageBox_lower(int argc, VALUE *argv, VALUE self) { FXMessageBox *arg1 = (FXMessageBox *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMessageBox, 1); FXMessageBox_lower(arg1); return Qnil; }
static VALUE _wrap_FXMessageBox_move(int argc, VALUE *argv, VALUE self) { FXMessageBox *arg1 = (FXMessageBox *) 0 ; FXint arg2 ;
    FXint arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMessageBox, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    FXMessageBox_move(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXMessageBox_position(int argc, VALUE *argv, VALUE self) { FXMessageBox *arg1 = (FXMessageBox *) 0 ;
    FXint arg2 ; FXint arg3 ; FXint arg4 ; FXint arg5 ; if ((argc < 4) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMessageBox, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    arg4 = NUM2INT(argv[2]); arg5 = NUM2INT(argv[3]); FXMessageBox_position(arg1,arg2,arg3,arg4,arg5); return Qnil; }
static VALUE _wrap_FXMessageBox_layout(int argc, VALUE *argv, VALUE self) { FXMessageBox *arg1 = (FXMessageBox *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMessageBox, 1); FXMessageBox_layout(arg1); return Qnil; }
static VALUE _wrap_FXMessageBox_recalc(int argc, VALUE *argv, VALUE self) { FXMessageBox *arg1 = (FXMessageBox *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMessageBox, 1); FXMessageBox_recalc(arg1); return Qnil; }
static VALUE _wrap_FXMessageBox_reparent(int argc, VALUE *argv, VALUE self) { FXMessageBox *arg1 = (FXMessageBox *) 0 ;
    FXComposite *arg2 = (FXComposite *) 0 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMessageBox, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXComposite, 1); FXMessageBox_reparent(arg1,arg2); return Qnil; }
static VALUE _wrap_FXMessageBox_show__SWIG_0(int argc, VALUE *argv, VALUE self) { FXMessageBox *arg1 = (FXMessageBox *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMessageBox, 1); FXMessageBox_show(arg1); return Qnil; }
static VALUE _wrap_FXMessageBox_hide(int argc, VALUE *argv, VALUE self) { FXMessageBox *arg1 = (FXMessageBox *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMessageBox, 1); FXMessageBox_hide(arg1); return Qnil; }
static VALUE _wrap_FXMessageBox_isComposite(int argc, VALUE *argv, VALUE self) { FXMessageBox *arg1 = (FXMessageBox *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMessageBox, 1);
    result = (FXbool)FXMessageBox_isComposite((FXMessageBox const *)arg1); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXMessageBox_contains(int argc, VALUE *argv, VALUE self) { FXMessageBox *arg1 = (FXMessageBox *) 0 ;
    FXint arg2 ; FXint arg3 ; FXbool result; VALUE vresult = Qnil; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMessageBox, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    result = (FXbool)FXMessageBox_contains((FXMessageBox const *)arg1,arg2,arg3); vresult = result ? Qtrue : Qfalse;
    return vresult; }
static VALUE _wrap_FXMessageBox_doesSaveUnder(int argc, VALUE *argv, VALUE self) { FXMessageBox *arg1 = (FXMessageBox *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMessageBox, 1);
    result = (FXbool)FXMessageBox_doesSaveUnder((FXMessageBox const *)arg1); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXMessageBox_setBackColor(int argc, VALUE *argv, VALUE self) { FXMessageBox *arg1 = (FXMessageBox *) 0 ;
    FXColor arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMessageBox, 1); arg2 = to_FXColor(argv[0]);
    FXMessageBox_setBackColor(arg1,arg2); return Qnil; }
static VALUE _wrap_FXMessageBox_show__SWIG_1(int argc, VALUE *argv, VALUE self) { FXMessageBox *arg1 = (FXMessageBox *) 0 ;
    FXuint arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMessageBox, 1); arg2 = NUM2UINT(argv[0]); FXMessageBox_show(arg1,arg2);
    return Qnil; }
static VALUE _wrap_FXMessageBox_show(int nargs, VALUE *args, VALUE self) { int argc; VALUE argv[3]; int ii; argc = nargs + 1;
    argv[0] = self; for (ii = 1; (ii < argc) && (ii < 2); ii++) { argv[ii] = args[ii-1]; }  if (argc == 1) { int _v; {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXMessageBox, 0) != -1)) ? 1 : 0; }
         if (_v) { return _wrap_FXMessageBox_show__SWIG_0(nargs, args, self);}  }  if (argc == 2) { int _v; { void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXMessageBox, 0) != -1)) ? 1 : 0; }
         if (_v) { { _v = ((TYPE(argv[1]) == T_FIXNUM) || (TYPE(argv[1]) == T_BIGNUM)) ? 1 : 0; }  if (_v) {
                return _wrap_FXMessageBox_show__SWIG_1(nargs, args, self);}  }  } 
    rb_raise(rb_eArgError, "No matching function for overloaded 'FXMessageBox_show'"); return Qnil; }
static VALUE _wrap_FXMessageBox_maximize(int argc, VALUE *argv, VALUE self) { FXMessageBox *arg1 = (FXMessageBox *) 0 ;
    FXbool arg2 = (FXbool) 0 ; FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMessageBox, 1); if (argc > 0) { arg2 = to_FXbool(argv[0]); } 
    result = (FXbool)FXMessageBox_maximize(arg1,arg2); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXMessageBox_minimize(int argc, VALUE *argv, VALUE self) { FXMessageBox *arg1 = (FXMessageBox *) 0 ;
    FXbool arg2 = (FXbool) 0 ; FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMessageBox, 1); if (argc > 0) { arg2 = to_FXbool(argv[0]); } 
    result = (FXbool)FXMessageBox_minimize(arg1,arg2); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXMessageBox_restore(int argc, VALUE *argv, VALUE self) { FXMessageBox *arg1 = (FXMessageBox *) 0 ;
    FXbool arg2 = (FXbool) 0 ; FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMessageBox, 1); if (argc > 0) { arg2 = to_FXbool(argv[0]); } 
    result = (FXbool)FXMessageBox_restore(arg1,arg2); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXMessageBox_close(int argc, VALUE *argv, VALUE self) { FXMessageBox *arg1 = (FXMessageBox *) 0 ;
    FXbool arg2 = (FXbool) 0 ; FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMessageBox, 1); if (argc > 0) { arg2 = to_FXbool(argv[0]); } 
    result = (FXbool)FXMessageBox_close(arg1,arg2); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXMessageBox_execute(int argc, VALUE *argv, VALUE self) { FXMessageBox *arg1 = (FXMessageBox *) 0 ;
    FXuint arg2 = (FXuint) PLACEMENT_CURSOR ; FXuint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMessageBox, 1); if (argc > 0) { arg2 = NUM2UINT(argv[0]); } 
    result = (FXuint)FXMessageBox_execute(arg1,arg2); vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXWizard_onUpdFinish(int argc, VALUE *argv, VALUE self) { FXWizard *arg1 = (FXWizard *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXWizard, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onUpdFinish(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXWizard_onCmdNext(int argc, VALUE *argv, VALUE self) { FXWizard *arg1 = (FXWizard *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXWizard, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdNext(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXWizard_onUpdNext(int argc, VALUE *argv, VALUE self) { FXWizard *arg1 = (FXWizard *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXWizard, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onUpdNext(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXWizard_onCmdBack(int argc, VALUE *argv, VALUE self) { FXWizard *arg1 = (FXWizard *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXWizard, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdBack(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXWizard_onUpdBack(int argc, VALUE *argv, VALUE self) { FXWizard *arg1 = (FXWizard *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXWizard, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onUpdBack(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_new_FXWizard__SWIG_0(int argc, VALUE *argv, VALUE self) { FXApp *arg1 = (FXApp *) 0 ; FXString *arg2 = 0 ;
    FXImage *arg3 = (FXImage *) 0 ; FXuint arg4 = (FXuint) DECOR_TITLE|DECOR_BORDER|DECOR_RESIZE ; FXint arg5 = (FXint) 0 ;
    FXint arg6 = (FXint) 0 ; FXint arg7 = (FXint) 0 ; FXint arg8 = (FXint) 0 ; FXint arg9 = (FXint) 10 ;
    FXint arg10 = (FXint) 10 ; FXint arg11 = (FXint) 10 ; FXint arg12 = (FXint) 10 ; FXint arg13 = (FXint) 10 ;
    FXint arg14 = (FXint) 10 ; FXWizard *result; SwigValueWrapper<FXString > p2 ; if ((argc < 3) || (argc > 14))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXApp, 1); p2 = to_FXString(argv[1]); arg2 = &p2;
    SWIG_ConvertPtr(argv[2], (void **) &arg3, SWIGTYPE_p_FXImage, 1); if (argc > 3) { arg4 = NUM2UINT(argv[3]); } 
    if (argc > 4) { arg5 = NUM2INT(argv[4]); }  if (argc > 5) { arg6 = NUM2INT(argv[5]); }  if (argc > 6) {
        arg7 = NUM2INT(argv[6]); }  if (argc > 7) { arg8 = NUM2INT(argv[7]); }  if (argc > 8) { arg9 = NUM2INT(argv[8]); } 
    if (argc > 9) { arg10 = NUM2INT(argv[9]); }  if (argc > 10) { arg11 = NUM2INT(argv[10]); }  if (argc > 11) {
        arg12 = NUM2INT(argv[11]); }  if (argc > 12) { arg13 = NUM2INT(argv[12]); }  if (argc > 13) {
        arg14 = NUM2INT(argv[13]); }  {
        result = (FXWizard *)new_FXWizard__SWIG_0(arg1,(FXString const &)*arg2,arg3,arg4,arg5,arg6,arg7,arg8,arg9,arg10,arg11,arg12,arg13,arg14);
        DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result); if(rb_block_given_p()){ rb_yield(self); }  }  return self; }
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE _wrap_FXWizard_allocate(VALUE self) {
#else
     static VALUE _wrap_FXWizard_allocate(int argc, VALUE *argv, VALUE self) {
#endif
         VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_FXWizard);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
         return vresult; }
static VALUE _wrap_new_FXWizard__SWIG_1(int argc, VALUE *argv, VALUE self) { FXWindow *arg1 = (FXWindow *) 0 ;
    FXString *arg2 = 0 ; FXImage *arg3 = (FXImage *) 0 ; FXuint arg4 = (FXuint) DECOR_TITLE|DECOR_BORDER|DECOR_RESIZE ;
    FXint arg5 = (FXint) 0 ; FXint arg6 = (FXint) 0 ; FXint arg7 = (FXint) 0 ; FXint arg8 = (FXint) 0 ;
    FXint arg9 = (FXint) 10 ; FXint arg10 = (FXint) 10 ; FXint arg11 = (FXint) 10 ; FXint arg12 = (FXint) 10 ;
    FXint arg13 = (FXint) 10 ; FXint arg14 = (FXint) 10 ; FXWizard *result; SwigValueWrapper<FXString > p2 ;
    if ((argc < 3) || (argc > 14)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXWindow, 1); p2 = to_FXString(argv[1]); arg2 = &p2;
    SWIG_ConvertPtr(argv[2], (void **) &arg3, SWIGTYPE_p_FXImage, 1); if (argc > 3) { arg4 = NUM2UINT(argv[3]); } 
    if (argc > 4) { arg5 = NUM2INT(argv[4]); }  if (argc > 5) { arg6 = NUM2INT(argv[5]); }  if (argc > 6) {
        arg7 = NUM2INT(argv[6]); }  if (argc > 7) { arg8 = NUM2INT(argv[7]); }  if (argc > 8) { arg9 = NUM2INT(argv[8]); } 
    if (argc > 9) { arg10 = NUM2INT(argv[9]); }  if (argc > 10) { arg11 = NUM2INT(argv[10]); }  if (argc > 11) {
        arg12 = NUM2INT(argv[11]); }  if (argc > 12) { arg13 = NUM2INT(argv[12]); }  if (argc > 13) {
        arg14 = NUM2INT(argv[13]); }  {
        result = (FXWizard *)new_FXWizard__SWIG_1(arg1,(FXString const &)*arg2,arg3,arg4,arg5,arg6,arg7,arg8,arg9,arg10,arg11,arg12,arg13,arg14);
        DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result); if(rb_block_given_p()){ rb_yield(self); }  }  return self; }
static VALUE _wrap_new_FXWizard(int nargs, VALUE *args, VALUE self) { int argc; VALUE argv[14]; int ii; argc = nargs;
    for (ii = 0; (ii < argc) && (ii < 14); ii++) { argv[ii] = args[ii]; }  if ((argc >= 3) && (argc <= 14)) { int _v; {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXApp, 0) != -1)) ? 1 : 0; }
         if (_v) { { _v = (NIL_P(argv[1]) || TYPE(argv[1]) == T_STRING) ? 1 : 0; }  if (_v) { { void *ptr;
                    _v = (NIL_P(argv[2]) || (TYPE(argv[2]) == T_DATA && SWIG_ConvertPtr(argv[2], &ptr, SWIGTYPE_p_FXImage, 0) != -1)) ? 1 : 0; }
                 if (_v) { if (argc <= 3) { return _wrap_new_FXWizard__SWIG_0(nargs, args, self);}  {
                        _v = ((TYPE(argv[3]) == T_FIXNUM) || (TYPE(argv[3]) == T_BIGNUM)) ? 1 : 0; }  if (_v) { if (argc <= 4) {
                            return _wrap_new_FXWizard__SWIG_0(nargs, args, self);}  {
                            _v = ((TYPE(argv[4]) == T_FIXNUM) || (TYPE(argv[4]) == T_BIGNUM)) ? 1 : 0; }  if (_v) {
                            if (argc <= 5) { return _wrap_new_FXWizard__SWIG_0(nargs, args, self);}  {
                                _v = ((TYPE(argv[5]) == T_FIXNUM) || (TYPE(argv[5]) == T_BIGNUM)) ? 1 : 0; }  if (_v) {
                                if (argc <= 6) { return _wrap_new_FXWizard__SWIG_0(nargs, args, self);}  {
                                    _v = ((TYPE(argv[6]) == T_FIXNUM) || (TYPE(argv[6]) == T_BIGNUM)) ? 1 : 0; }  if (_v) {
                                    if (argc <= 7) { return _wrap_new_FXWizard__SWIG_0(nargs, args, self);}  {
                                        _v = ((TYPE(argv[7]) == T_FIXNUM) || (TYPE(argv[7]) == T_BIGNUM)) ? 1 : 0; }  if (_v) {
                                        if (argc <= 8) { return _wrap_new_FXWizard__SWIG_0(nargs, args, self);}  {
                                            _v = ((TYPE(argv[8]) == T_FIXNUM) || (TYPE(argv[8]) == T_BIGNUM)) ? 1 : 0; } 
                                        if (_v) { if (argc <= 9) { return _wrap_new_FXWizard__SWIG_0(nargs, args, self);}  {
                                                _v = ((TYPE(argv[9]) == T_FIXNUM) || (TYPE(argv[9]) == T_BIGNUM)) ? 1 : 0; } 
                                            if (_v) { if (argc <= 10) { return _wrap_new_FXWizard__SWIG_0(nargs, args, self);} 
                                                { _v = ((TYPE(argv[10]) == T_FIXNUM) || (TYPE(argv[10]) == T_BIGNUM)) ? 1 : 0; }
                                                 if (_v) { if (argc <= 11) {
                                                        return _wrap_new_FXWizard__SWIG_0(nargs, args, self);}  {
                                                        _v = ((TYPE(argv[11]) == T_FIXNUM) || (TYPE(argv[11]) == T_BIGNUM)) ? 1 : 0; }
                                                     if (_v) { if (argc <= 12) {
                                                            return _wrap_new_FXWizard__SWIG_0(nargs, args, self);}  {
                                                            _v = ((TYPE(argv[12]) == T_FIXNUM) || (TYPE(argv[12]) == T_BIGNUM)) ? 1 : 0; }
                                                         if (_v) { if (argc <= 13) {
                                                                return _wrap_new_FXWizard__SWIG_0(nargs, args, self);}  {
                                                                _v = ((TYPE(argv[13]) == T_FIXNUM) || (TYPE(argv[13]) == T_BIGNUM)) ? 1 : 0; }
                                                             if (_v) { return _wrap_new_FXWizard__SWIG_0(nargs, args, self);}  }
                                                         }  }  }  }  }  }  }  }  }  }  }  }  } 
    if ((argc >= 3) && (argc <= 14)) { int _v; { void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXWindow, 0) != -1)) ? 1 : 0; }
         if (_v) { { _v = (NIL_P(argv[1]) || TYPE(argv[1]) == T_STRING) ? 1 : 0; }  if (_v) { { void *ptr;
                    _v = (NIL_P(argv[2]) || (TYPE(argv[2]) == T_DATA && SWIG_ConvertPtr(argv[2], &ptr, SWIGTYPE_p_FXImage, 0) != -1)) ? 1 : 0; }
                 if (_v) { if (argc <= 3) { return _wrap_new_FXWizard__SWIG_1(nargs, args, self);}  {
                        _v = ((TYPE(argv[3]) == T_FIXNUM) || (TYPE(argv[3]) == T_BIGNUM)) ? 1 : 0; }  if (_v) { if (argc <= 4) {
                            return _wrap_new_FXWizard__SWIG_1(nargs, args, self);}  {
                            _v = ((TYPE(argv[4]) == T_FIXNUM) || (TYPE(argv[4]) == T_BIGNUM)) ? 1 : 0; }  if (_v) {
                            if (argc <= 5) { return _wrap_new_FXWizard__SWIG_1(nargs, args, self);}  {
                                _v = ((TYPE(argv[5]) == T_FIXNUM) || (TYPE(argv[5]) == T_BIGNUM)) ? 1 : 0; }  if (_v) {
                                if (argc <= 6) { return _wrap_new_FXWizard__SWIG_1(nargs, args, self);}  {
                                    _v = ((TYPE(argv[6]) == T_FIXNUM) || (TYPE(argv[6]) == T_BIGNUM)) ? 1 : 0; }  if (_v) {
                                    if (argc <= 7) { return _wrap_new_FXWizard__SWIG_1(nargs, args, self);}  {
                                        _v = ((TYPE(argv[7]) == T_FIXNUM) || (TYPE(argv[7]) == T_BIGNUM)) ? 1 : 0; }  if (_v) {
                                        if (argc <= 8) { return _wrap_new_FXWizard__SWIG_1(nargs, args, self);}  {
                                            _v = ((TYPE(argv[8]) == T_FIXNUM) || (TYPE(argv[8]) == T_BIGNUM)) ? 1 : 0; } 
                                        if (_v) { if (argc <= 9) { return _wrap_new_FXWizard__SWIG_1(nargs, args, self);}  {
                                                _v = ((TYPE(argv[9]) == T_FIXNUM) || (TYPE(argv[9]) == T_BIGNUM)) ? 1 : 0; } 
                                            if (_v) { if (argc <= 10) { return _wrap_new_FXWizard__SWIG_1(nargs, args, self);} 
                                                { _v = ((TYPE(argv[10]) == T_FIXNUM) || (TYPE(argv[10]) == T_BIGNUM)) ? 1 : 0; }
                                                 if (_v) { if (argc <= 11) {
                                                        return _wrap_new_FXWizard__SWIG_1(nargs, args, self);}  {
                                                        _v = ((TYPE(argv[11]) == T_FIXNUM) || (TYPE(argv[11]) == T_BIGNUM)) ? 1 : 0; }
                                                     if (_v) { if (argc <= 12) {
                                                            return _wrap_new_FXWizard__SWIG_1(nargs, args, self);}  {
                                                            _v = ((TYPE(argv[12]) == T_FIXNUM) || (TYPE(argv[12]) == T_BIGNUM)) ? 1 : 0; }
                                                         if (_v) { if (argc <= 13) {
                                                                return _wrap_new_FXWizard__SWIG_1(nargs, args, self);}  {
                                                                _v = ((TYPE(argv[13]) == T_FIXNUM) || (TYPE(argv[13]) == T_BIGNUM)) ? 1 : 0; }
                                                             if (_v) { return _wrap_new_FXWizard__SWIG_1(nargs, args, self);}  }
                                                         }  }  }  }  }  }  }  }  }  }  }  }  } 
    rb_raise(rb_eArgError, "No matching function for overloaded 'new_FXWizard'"); return Qnil; }
static VALUE _wrap_FXWizard_buttonFrame(int argc, VALUE *argv, VALUE self) { FXWizard *arg1 = (FXWizard *) 0 ;
    FXHorizontalFrame *result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXWizard, 1);
    result = (FXHorizontalFrame *)((FXWizard const *)arg1)->buttonFrame();
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_FXHorizontalFrame,0); return vresult; }
static VALUE _wrap_FXWizard_advanceButton(int argc, VALUE *argv, VALUE self) { FXWizard *arg1 = (FXWizard *) 0 ;
    FXButton *result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXWizard, 1);
    result = (FXButton *)((FXWizard const *)arg1)->advanceButton(); {
        swig_type_info *ty = SWIG_TypeDynamicCast(SWIGTYPE_p_FXButton, (void **) &result);
        vresult = FXRbGetRubyObj(result, ty); }  return vresult; }
static VALUE _wrap_FXWizard_retreatButton(int argc, VALUE *argv, VALUE self) { FXWizard *arg1 = (FXWizard *) 0 ;
    FXButton *result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXWizard, 1);
    result = (FXButton *)((FXWizard const *)arg1)->retreatButton(); {
        swig_type_info *ty = SWIG_TypeDynamicCast(SWIGTYPE_p_FXButton, (void **) &result);
        vresult = FXRbGetRubyObj(result, ty); }  return vresult; }
static VALUE _wrap_FXWizard_finishButton(int argc, VALUE *argv, VALUE self) { FXWizard *arg1 = (FXWizard *) 0 ;
    FXButton *result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXWizard, 1);
    result = (FXButton *)((FXWizard const *)arg1)->finishButton(); {
        swig_type_info *ty = SWIG_TypeDynamicCast(SWIGTYPE_p_FXButton, (void **) &result);
        vresult = FXRbGetRubyObj(result, ty); }  return vresult; }
static VALUE _wrap_FXWizard_cancelButton(int argc, VALUE *argv, VALUE self) { FXWizard *arg1 = (FXWizard *) 0 ;
    FXButton *result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXWizard, 1);
    result = (FXButton *)((FXWizard const *)arg1)->cancelButton(); {
        swig_type_info *ty = SWIG_TypeDynamicCast(SWIGTYPE_p_FXButton, (void **) &result);
        vresult = FXRbGetRubyObj(result, ty); }  return vresult; }
static VALUE _wrap_FXWizard_getContainer(int argc, VALUE *argv, VALUE self) { FXWizard *arg1 = (FXWizard *) 0 ;
    FXSwitcher *result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXWizard, 1);
    result = (FXSwitcher *)((FXWizard const *)arg1)->getContainer();
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_FXSwitcher,0); return vresult; }
static VALUE _wrap_FXWizard_setImage(int argc, VALUE *argv, VALUE self) { FXWizard *arg1 = (FXWizard *) 0 ;
    FXImage *arg2 = (FXImage *) 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXWizard, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXImage, 1); (arg1)->setImage(arg2); return Qnil; }
static VALUE _wrap_FXWizard_getImage(int argc, VALUE *argv, VALUE self) { FXWizard *arg1 = (FXWizard *) 0 ; FXImage *result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXWizard, 1); result = (FXImage *)((FXWizard const *)arg1)->getImage(); {
        swig_type_info *ty = SWIG_TypeDynamicCast(SWIGTYPE_p_FXImage, (void **) &result); vresult = FXRbGetRubyObj(result, ty); }
     return vresult; }
static VALUE _wrap_FXWizard_getNumPanels(int argc, VALUE *argv, VALUE self) { FXWizard *arg1 = (FXWizard *) 0 ; FXint result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXWizard, 1); result = (FXint)((FXWizard const *)arg1)->getNumPanels();
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXWizard_setCurrentPanel(int argc, VALUE *argv, VALUE self) { FXWizard *arg1 = (FXWizard *) 0 ; FXint arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXWizard, 1); arg2 = NUM2INT(argv[0]);
    FXWizard_setCurrentPanel(arg1,arg2); return Qnil; }
static VALUE _wrap_FXWizard_getCurrentPanel(int argc, VALUE *argv, VALUE self) { FXWizard *arg1 = (FXWizard *) 0 ; FXint result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXWizard, 1); result = (FXint)((FXWizard const *)arg1)->getCurrentPanel();
    vresult = INT2NUM(result); return vresult; }
static void
free_FXWizard(FXWizard *arg1) {
    delete arg1;
}
static VALUE _wrap_FXWizard_save(int argc, VALUE *argv, VALUE self) { FXWizard *arg1 = (FXWizard *) 0 ; FXStream *arg2 = 0 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXWizard, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXWizard_save((FXWizard const *)arg1,*arg2); return Qnil; }
static VALUE _wrap_FXWizard_load(int argc, VALUE *argv, VALUE self) { FXWizard *arg1 = (FXWizard *) 0 ; FXStream *arg2 = 0 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXWizard, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXWizard_load(arg1,*arg2); return Qnil; }
static VALUE _wrap_FXWizard_create(int argc, VALUE *argv, VALUE self) { FXWizard *arg1 = (FXWizard *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXWizard, 1); FXWizard_create(arg1); return Qnil; }
static VALUE _wrap_FXWizard_detach(int argc, VALUE *argv, VALUE self) { FXWizard *arg1 = (FXWizard *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXWizard, 1); FXWizard_detach(arg1); return Qnil; }
static VALUE _wrap_FXWizard_destroy(int argc, VALUE *argv, VALUE self) { FXWizard *arg1 = (FXWizard *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXWizard, 1); FXWizard_destroy(arg1); return Qnil; }
static VALUE _wrap_FXWizard_resize(int argc, VALUE *argv, VALUE self) { FXWizard *arg1 = (FXWizard *) 0 ; FXint arg2 ;
    FXint arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXWizard, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    FXWizard_resize(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXWizard_getDefaultWidth(int argc, VALUE *argv, VALUE self) { FXWizard *arg1 = (FXWizard *) 0 ; FXint result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXWizard, 1); result = (FXint)FXWizard_getDefaultWidth(arg1);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXWizard_getDefaultHeight(int argc, VALUE *argv, VALUE self) { FXWizard *arg1 = (FXWizard *) 0 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXWizard, 1); result = (FXint)FXWizard_getDefaultHeight(arg1);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXWizard_getWidthForHeight(int argc, VALUE *argv, VALUE self) { FXWizard *arg1 = (FXWizard *) 0 ;
    FXint arg2 ; FXint result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXWizard, 1); arg2 = NUM2INT(argv[0]);
    result = (FXint)FXWizard_getWidthForHeight(arg1,arg2); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXWizard_getHeightForWidth(int argc, VALUE *argv, VALUE self) { FXWizard *arg1 = (FXWizard *) 0 ;
    FXint arg2 ; FXint result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXWizard, 1); arg2 = NUM2INT(argv[0]);
    result = (FXint)FXWizard_getHeightForWidth(arg1,arg2); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXWizard_canFocus(int argc, VALUE *argv, VALUE self) { FXWizard *arg1 = (FXWizard *) 0 ; FXbool result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXWizard, 1); result = (FXbool)FXWizard_canFocus((FXWizard const *)arg1);
    vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXWizard_setFocus(int argc, VALUE *argv, VALUE self) { FXWizard *arg1 = (FXWizard *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXWizard, 1); FXWizard_setFocus(arg1); return Qnil; }
static VALUE _wrap_FXWizard_killFocus(int argc, VALUE *argv, VALUE self) { FXWizard *arg1 = (FXWizard *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXWizard, 1); FXWizard_killFocus(arg1); return Qnil; }
static VALUE _wrap_FXWizard_setDefault(int argc, VALUE *argv, VALUE self) { FXWizard *arg1 = (FXWizard *) 0 ;
    FXbool arg2 = (FXbool) 1 ; if ((argc < 0) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXWizard, 1); if (argc > 0) { arg2 = to_FXbool(argv[0]); } 
    FXWizard_setDefault(arg1,arg2); return Qnil; }
static VALUE _wrap_FXWizard_enable(int argc, VALUE *argv, VALUE self) { FXWizard *arg1 = (FXWizard *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXWizard, 1); FXWizard_enable(arg1); return Qnil; }
static VALUE _wrap_FXWizard_disable(int argc, VALUE *argv, VALUE self) { FXWizard *arg1 = (FXWizard *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXWizard, 1); FXWizard_disable(arg1); return Qnil; }
static VALUE _wrap_FXWizard_raiseWindow(int argc, VALUE *argv, VALUE self) { FXWizard *arg1 = (FXWizard *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXWizard, 1); FXWizard_raise(arg1); return Qnil; }
static VALUE _wrap_FXWizard_lower(int argc, VALUE *argv, VALUE self) { FXWizard *arg1 = (FXWizard *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXWizard, 1); FXWizard_lower(arg1); return Qnil; }
static VALUE _wrap_FXWizard_move(int argc, VALUE *argv, VALUE self) { FXWizard *arg1 = (FXWizard *) 0 ; FXint arg2 ;
    FXint arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXWizard, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    FXWizard_move(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXWizard_position(int argc, VALUE *argv, VALUE self) { FXWizard *arg1 = (FXWizard *) 0 ; FXint arg2 ;
    FXint arg3 ; FXint arg4 ; FXint arg5 ; if ((argc < 4) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXWizard, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    arg4 = NUM2INT(argv[2]); arg5 = NUM2INT(argv[3]); FXWizard_position(arg1,arg2,arg3,arg4,arg5); return Qnil; }
static VALUE _wrap_FXWizard_layout(int argc, VALUE *argv, VALUE self) { FXWizard *arg1 = (FXWizard *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXWizard, 1); FXWizard_layout(arg1); return Qnil; }
static VALUE _wrap_FXWizard_recalc(int argc, VALUE *argv, VALUE self) { FXWizard *arg1 = (FXWizard *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXWizard, 1); FXWizard_recalc(arg1); return Qnil; }
static VALUE _wrap_FXWizard_reparent(int argc, VALUE *argv, VALUE self) { FXWizard *arg1 = (FXWizard *) 0 ;
    FXComposite *arg2 = (FXComposite *) 0 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXWizard, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXComposite, 1); FXWizard_reparent(arg1,arg2); return Qnil; }
static VALUE _wrap_FXWizard_show__SWIG_0(int argc, VALUE *argv, VALUE self) { FXWizard *arg1 = (FXWizard *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXWizard, 1); FXWizard_show(arg1); return Qnil; }
static VALUE _wrap_FXWizard_hide(int argc, VALUE *argv, VALUE self) { FXWizard *arg1 = (FXWizard *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXWizard, 1); FXWizard_hide(arg1); return Qnil; }
static VALUE _wrap_FXWizard_isComposite(int argc, VALUE *argv, VALUE self) { FXWizard *arg1 = (FXWizard *) 0 ; FXbool result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXWizard, 1);
    result = (FXbool)FXWizard_isComposite((FXWizard const *)arg1); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXWizard_contains(int argc, VALUE *argv, VALUE self) { FXWizard *arg1 = (FXWizard *) 0 ; FXint arg2 ;
    FXint arg3 ; FXbool result; VALUE vresult = Qnil; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXWizard, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    result = (FXbool)FXWizard_contains((FXWizard const *)arg1,arg2,arg3); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXWizard_doesSaveUnder(int argc, VALUE *argv, VALUE self) { FXWizard *arg1 = (FXWizard *) 0 ; FXbool result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXWizard, 1);
    result = (FXbool)FXWizard_doesSaveUnder((FXWizard const *)arg1); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXWizard_setBackColor(int argc, VALUE *argv, VALUE self) { FXWizard *arg1 = (FXWizard *) 0 ; FXColor arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXWizard, 1); arg2 = to_FXColor(argv[0]);
    FXWizard_setBackColor(arg1,arg2); return Qnil; }
static VALUE _wrap_FXWizard_show__SWIG_1(int argc, VALUE *argv, VALUE self) { FXWizard *arg1 = (FXWizard *) 0 ; FXuint arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXWizard, 1); arg2 = NUM2UINT(argv[0]); FXWizard_show(arg1,arg2);
    return Qnil; }
static VALUE _wrap_FXWizard_show(int nargs, VALUE *args, VALUE self) { int argc; VALUE argv[3]; int ii; argc = nargs + 1;
    argv[0] = self; for (ii = 1; (ii < argc) && (ii < 2); ii++) { argv[ii] = args[ii-1]; }  if (argc == 1) { int _v; {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXWizard, 0) != -1)) ? 1 : 0; }
         if (_v) { return _wrap_FXWizard_show__SWIG_0(nargs, args, self);}  }  if (argc == 2) { int _v; { void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXWizard, 0) != -1)) ? 1 : 0; }
         if (_v) { { _v = ((TYPE(argv[1]) == T_FIXNUM) || (TYPE(argv[1]) == T_BIGNUM)) ? 1 : 0; }  if (_v) {
                return _wrap_FXWizard_show__SWIG_1(nargs, args, self);}  }  } 
    rb_raise(rb_eArgError, "No matching function for overloaded 'FXWizard_show'"); return Qnil; }
static VALUE _wrap_FXWizard_maximize(int argc, VALUE *argv, VALUE self) { FXWizard *arg1 = (FXWizard *) 0 ;
    FXbool arg2 = (FXbool) 0 ; FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXWizard, 1); if (argc > 0) { arg2 = to_FXbool(argv[0]); } 
    result = (FXbool)FXWizard_maximize(arg1,arg2); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXWizard_minimize(int argc, VALUE *argv, VALUE self) { FXWizard *arg1 = (FXWizard *) 0 ;
    FXbool arg2 = (FXbool) 0 ; FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXWizard, 1); if (argc > 0) { arg2 = to_FXbool(argv[0]); } 
    result = (FXbool)FXWizard_minimize(arg1,arg2); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXWizard_restore(int argc, VALUE *argv, VALUE self) { FXWizard *arg1 = (FXWizard *) 0 ;
    FXbool arg2 = (FXbool) 0 ; FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXWizard, 1); if (argc > 0) { arg2 = to_FXbool(argv[0]); } 
    result = (FXbool)FXWizard_restore(arg1,arg2); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXWizard_close(int argc, VALUE *argv, VALUE self) { FXWizard *arg1 = (FXWizard *) 0 ;
    FXbool arg2 = (FXbool) 0 ; FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXWizard, 1); if (argc > 0) { arg2 = to_FXbool(argv[0]); } 
    result = (FXbool)FXWizard_close(arg1,arg2); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXWizard_execute(int argc, VALUE *argv, VALUE self) { FXWizard *arg1 = (FXWizard *) 0 ;
    FXuint arg2 = (FXuint) PLACEMENT_CURSOR ; FXuint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXWizard, 1); if (argc > 0) { arg2 = NUM2UINT(argv[0]); } 
    result = (FXuint)FXWizard_execute(arg1,arg2); vresult = UINT2NUM(result); return vresult; }

/* -------- TYPE CONVERSION AND EQUIVALENCE RULES (BEGIN) -------- */

static void *_p_FXShutterItemTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *)(FXVerticalFrame *) ((FXShutterItem *) x));
}
static void *_p_FXColorBarTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXFrame *) ((FXColorBar *) x));
}
static void *_p_FXTabBarTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXTabBar *) x));
}
static void *_p_FXSwitcherTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXSwitcher *) x));
}
static void *_p_FXTextFieldTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXFrame *) ((FXTextField *) x));
}
static void *_p_FXToolBarTabTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXFrame *) ((FXToolBarTab *) x));
}
static void *_p_FXDriveBoxTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *)(FXListBox *) ((FXDriveBox *) x));
}
static void *_p_FXMatrixTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXMatrix *) x));
}
static void *_p_FXDialogBoxTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXShell *)(FXTopWindow *) ((FXDialogBox *) x));
}
static void *_p_FXScrollCornerTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *) ((FXScrollCorner *) x));
}
static void *_p_FXArrowButtonTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXFrame *) ((FXArrowButton *) x));
}
static void *_p_FXPopupTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXShell *) ((FXPopup *) x));
}
static void *_p_FXDrawableTo_p_FXId(void *x) {
    return (void *)((FXId *)  ((FXDrawable *) x));
}
static void *_p_FXWizardTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXShell *)(FXTopWindow *)(FXDialogBox *) ((FXWizard *) x));
}
static void *_p_FXHeaderTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXFrame *) ((FXHeader *) x));
}
static void *_p_FXSplitterTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *) ((FXSplitter *) x));
}
static void *_p_FX4SplitterTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *) ((FX4Splitter *) x));
}
static void *_p_FXSpringTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXSpring *) x));
}
static void *_p_FXPackerTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *) ((FXPacker *) x));
}
static void *_p_FXTabBookTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *)(FXTabBar *) ((FXTabBook *) x));
}
static void *_p_FXImageFrameTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXFrame *) ((FXImageFrame *) x));
}
static void *_p_FXVerticalSeparatorTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXFrame *)(FXSeparator *) ((FXVerticalSeparator *) x));
}
static void *_p_FXHorizontalSeparatorTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXFrame *)(FXSeparator *) ((FXHorizontalSeparator *) x));
}
static void *_p_FXSeparatorTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXFrame *) ((FXSeparator *) x));
}
static void *_p_FXProgressBarTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXFrame *) ((FXProgressBar *) x));
}
static void *_p_FXShutterTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *)(FXVerticalFrame *) ((FXShutter *) x));
}
static void *_p_FXReplaceDialogTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXShell *)(FXTopWindow *)(FXDialogBox *) ((FXReplaceDialog *) x));
}
static void *_p_FXFileDialogTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXShell *)(FXTopWindow *)(FXDialogBox *) ((FXFileDialog *) x));
}
static void *_p_FXProgressDialogTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXShell *)(FXTopWindow *)(FXDialogBox *) ((FXProgressDialog *) x));
}
static void *_p_FXToolTipTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXShell *) ((FXToolTip *) x));
}
static void *_p_FXCompositeTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *) ((FXComposite *) x));
}
static void *_p_FXBitmapFrameTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXFrame *) ((FXBitmapFrame *) x));
}
static void *_p_FXRealSliderTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXFrame *) ((FXRealSlider *) x));
}
static void *_p_FXSliderTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXFrame *) ((FXSlider *) x));
}
static void *_p_FXGroupBoxTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXGroupBox *) x));
}
static void *_p_FXTreeListBoxTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXTreeListBox *) x));
}
static void *_p_FXListBoxTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXListBox *) x));
}
static void *_p_FXCanvasTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *) ((FXCanvas *) x));
}
static void *_p_FXColorWheelTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXFrame *) ((FXColorWheel *) x));
}
static void *_p_FXMessageBoxTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXShell *)(FXTopWindow *)(FXDialogBox *) ((FXMessageBox *) x));
}
static void *_p_FXVisualTo_p_FXId(void *x) {
    return (void *)((FXId *)  ((FXVisual *) x));
}
static void *_p_FXToolBarGripTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *) ((FXToolBarGrip *) x));
}
static void *_p_FXScrollBarTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *) ((FXScrollBar *) x));
}
static void *_p_FXFontTo_p_FXId(void *x) {
    return (void *)((FXId *)  ((FXFont *) x));
}
static void *_p_FXComboBoxTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXComboBox *) x));
}
static void *_p_FXFrameTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *) ((FXFrame *) x));
}
static void *_p_FXStatusBarTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *)(FXHorizontalFrame *) ((FXStatusBar *) x));
}
static void *_p_FXGIFCursorTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXCursor *) ((FXGIFCursor *) x));
}
static void *_p_FXCURCursorTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXCursor *) ((FXCURCursor *) x));
}
static void *_p_FXCursorTo_p_FXId(void *x) {
    return (void *)((FXId *)  ((FXCursor *) x));
}
static void *_p_FXRealSpinnerTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXRealSpinner *) x));
}
static void *_p_FXSpinnerTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXSpinner *) x));
}
static void *_p_FXStatusLineTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXFrame *) ((FXStatusLine *) x));
}
static void *_p_FXMainWindowTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXShell *)(FXTopWindow *) ((FXMainWindow *) x));
}
static void *_p_FXTopWindowTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXShell *) ((FXTopWindow *) x));
}
static void *_p_FXRootWindowTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *) ((FXRootWindow *) x));
}
static void *_p_FXWindowTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *) ((FXWindow *) x));
}
static void *_p_FXScrollWindowTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXScrollArea *) ((FXScrollWindow *) x));
}
static void *_p_FXFontDialogTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXShell *)(FXTopWindow *)(FXDialogBox *) ((FXFontDialog *) x));
}
static void *_p_FXColorDialogTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXShell *)(FXTopWindow *)(FXDialogBox *) ((FXColorDialog *) x));
}
static void *_p_FXDirDialogTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXShell *)(FXTopWindow *)(FXDialogBox *) ((FXDirDialog *) x));
}
static void *_p_FXSearchDialogTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXShell *)(FXTopWindow *)(FXDialogBox *)(FXReplaceDialog *) ((FXSearchDialog *) x));
}
static void *_p_FXInputDialogTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXShell *)(FXTopWindow *)(FXDialogBox *) ((FXInputDialog *) x));
}
static void *_p_FXPrintDialogTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXShell *)(FXTopWindow *)(FXDialogBox *) ((FXPrintDialog *) x));
}
static void *_p_FXShellTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *) ((FXShell *) x));
}
static void *_p_FXScrollAreaTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *) ((FXScrollArea *) x));
}
static void *_p_FXColorWellTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXFrame *) ((FXColorWell *) x));
}
static void *_p_FXDragCornerTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *) ((FXDragCorner *) x));
}
static void *_p_FXRulerTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXFrame *) ((FXRuler *) x));
}
static void *_p_FXDialTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXFrame *) ((FXDial *) x));
}
static void *_p_FXHorizontalFrameTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXHorizontalFrame *) x));
}
static void *_p_FXVerticalFrameTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXVerticalFrame *) x));
}
static void *_p_FXImageViewTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXScrollArea *) ((FXImageView *) x));
}
static void *_p_FXFontSelectorTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXFontSelector *) x));
}
static void *_p_FXColorSelectorTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXColorSelector *) x));
}
static void *_p_FXFileSelectorTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXFileSelector *) x));
}
static void *_p_FXDirSelectorTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXDirSelector *) x));
}
static void *_p_FXToolBarShellTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXShell *)(FXTopWindow *) ((FXToolBarShell *) x));
}
static void *_p_FXToolBarTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXToolBar *) x));
}
static void *_p_FXDirBoxTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *)(FXTreeListBox *) ((FXDirBox *) x));
}
static void *_p_FXDocumentTo_p_FXObject(void *x) {
    return (void *)((FXObject *)  ((FXDocument *) x));
}
static void *_p_FXRegistryTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXDict *)(FXSettings *) ((FXRegistry *) x));
}
static void *_p_FXHeaderItemTo_p_FXObject(void *x) {
    return (void *)((FXObject *)  ((FXHeaderItem *) x));
}
static void *_p_FXShutterItemTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *)(FXVerticalFrame *) ((FXShutterItem *) x));
}
static void *_p_FXColorBarTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXFrame *) ((FXColorBar *) x));
}
static void *_p_FXTabBarTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXTabBar *) x));
}
static void *_p_FXSwitcherTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXSwitcher *) x));
}
static void *_p_FXTextFieldTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXFrame *) ((FXTextField *) x));
}
static void *_p_FXToolBarTabTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXFrame *) ((FXToolBarTab *) x));
}
static void *_p_FXDriveBoxTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *)(FXListBox *) ((FXDriveBox *) x));
}
static void *_p_FXIconDictTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXDict *) ((FXIconDict *) x));
}
static void *_p_FXMatrixTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXMatrix *) x));
}
static void *_p_FXFileDictTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXDict *) ((FXFileDict *) x));
}
static void *_p_FXDialogBoxTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXShell *)(FXTopWindow *) ((FXDialogBox *) x));
}
static void *_p_FXRecentFilesTo_p_FXObject(void *x) {
    return (void *)((FXObject *)  ((FXRecentFiles *) x));
}
static void *_p_FXScrollCornerTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *) ((FXScrollCorner *) x));
}
static void *_p_FXArrowButtonTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXFrame *) ((FXArrowButton *) x));
}
static void *_p_FXPopupTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXShell *) ((FXPopup *) x));
}
static void *_p_FXDrawableTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *) ((FXDrawable *) x));
}
static void *_p_FXWizardTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXShell *)(FXTopWindow *)(FXDialogBox *) ((FXWizard *) x));
}
static void *_p_FXAppTo_p_FXObject(void *x) {
    return (void *)((FXObject *)  ((FXApp *) x));
}
static void *_p_FXHeaderTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXFrame *) ((FXHeader *) x));
}
static void *_p_FX4SplitterTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *) ((FX4Splitter *) x));
}
static void *_p_FXSplitterTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *) ((FXSplitter *) x));
}
static void *_p_FXSpringTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXSpring *) x));
}
static void *_p_FXPackerTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *) ((FXPacker *) x));
}
static void *_p_FXTabBookTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *)(FXTabBar *) ((FXTabBook *) x));
}
static void *_p_FXImageFrameTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXFrame *) ((FXImageFrame *) x));
}
static void *_p_FXVerticalSeparatorTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXFrame *)(FXSeparator *) ((FXVerticalSeparator *) x));
}
static void *_p_FXHorizontalSeparatorTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXFrame *)(FXSeparator *) ((FXHorizontalSeparator *) x));
}
static void *_p_FXSeparatorTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXFrame *) ((FXSeparator *) x));
}
static void *_p_FXIdTo_p_FXObject(void *x) {
    return (void *)((FXObject *)  ((FXId *) x));
}
static void *_p_FXProgressBarTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXFrame *) ((FXProgressBar *) x));
}
static void *_p_FXShutterTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *)(FXVerticalFrame *) ((FXShutter *) x));
}
static void *_p_FXFileDialogTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXShell *)(FXTopWindow *)(FXDialogBox *) ((FXFileDialog *) x));
}
static void *_p_FXReplaceDialogTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXShell *)(FXTopWindow *)(FXDialogBox *) ((FXReplaceDialog *) x));
}
static void *_p_FXProgressDialogTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXShell *)(FXTopWindow *)(FXDialogBox *) ((FXProgressDialog *) x));
}
static void *_p_FXToolTipTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXShell *) ((FXToolTip *) x));
}
static void *_p_FXCompositeTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *) ((FXComposite *) x));
}
static void *_p_FXBitmapFrameTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXFrame *) ((FXBitmapFrame *) x));
}
static void *_p_FXRealSliderTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXFrame *) ((FXRealSlider *) x));
}
static void *_p_FXSliderTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXFrame *) ((FXSlider *) x));
}
static void *_p_FXSettingsTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXDict *) ((FXSettings *) x));
}
static void *_p_FXGroupBoxTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXGroupBox *) x));
}
static void *_p_FXDebugTargetTo_p_FXObject(void *x) {
    return (void *)((FXObject *)  ((FXDebugTarget *) x));
}
static void *_p_FXDataTargetTo_p_FXObject(void *x) {
    return (void *)((FXObject *)  ((FXDataTarget *) x));
}
static void *_p_FXTreeListBoxTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXTreeListBox *) x));
}
static void *_p_FXListBoxTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXListBox *) x));
}
static void *_p_FXCanvasTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *) ((FXCanvas *) x));
}
static void *_p_FXColorWheelTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXFrame *) ((FXColorWheel *) x));
}
static void *_p_FXMessageBoxTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXShell *)(FXTopWindow *)(FXDialogBox *) ((FXMessageBox *) x));
}
static void *_p_FXVisualTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *) ((FXVisual *) x));
}
static void *_p_FXScrollBarTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *) ((FXScrollBar *) x));
}
static void *_p_FXToolBarGripTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *) ((FXToolBarGrip *) x));
}
static void *_p_FXFontTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *) ((FXFont *) x));
}
static void *_p_FXComboBoxTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXComboBox *) x));
}
static void *_p_FXFrameTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *) ((FXFrame *) x));
}
static void *_p_FXStringDictTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXDict *) ((FXStringDict *) x));
}
static void *_p_FXStatusBarTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *)(FXHorizontalFrame *) ((FXStatusBar *) x));
}
static void *_p_FXDelegatorTo_p_FXObject(void *x) {
    return (void *)((FXObject *)  ((FXDelegator *) x));
}
static void *_p_FXAccelTableTo_p_FXObject(void *x) {
    return (void *)((FXObject *)  ((FXAccelTable *) x));
}
static void *_p_FXCursorTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *) ((FXCursor *) x));
}
static void *_p_FXCURCursorTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXCursor *) ((FXCURCursor *) x));
}
static void *_p_FXGIFCursorTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXCursor *) ((FXGIFCursor *) x));
}
static void *_p_FXRealSpinnerTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXRealSpinner *) x));
}
static void *_p_FXSpinnerTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXSpinner *) x));
}
static void *_p_FXStatusLineTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXFrame *) ((FXStatusLine *) x));
}
static void *_p_FXScrollWindowTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXScrollArea *) ((FXScrollWindow *) x));
}
static void *_p_FXWindowTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *) ((FXWindow *) x));
}
static void *_p_FXRootWindowTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *) ((FXRootWindow *) x));
}
static void *_p_FXTopWindowTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXShell *) ((FXTopWindow *) x));
}
static void *_p_FXMainWindowTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXShell *)(FXTopWindow *) ((FXMainWindow *) x));
}
static void *_p_FXDirDialogTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXShell *)(FXTopWindow *)(FXDialogBox *) ((FXDirDialog *) x));
}
static void *_p_FXColorDialogTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXShell *)(FXTopWindow *)(FXDialogBox *) ((FXColorDialog *) x));
}
static void *_p_FXFontDialogTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXShell *)(FXTopWindow *)(FXDialogBox *) ((FXFontDialog *) x));
}
static void *_p_FXSearchDialogTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXShell *)(FXTopWindow *)(FXDialogBox *)(FXReplaceDialog *) ((FXSearchDialog *) x));
}
static void *_p_FXInputDialogTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXShell *)(FXTopWindow *)(FXDialogBox *) ((FXInputDialog *) x));
}
static void *_p_FXPrintDialogTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXShell *)(FXTopWindow *)(FXDialogBox *) ((FXPrintDialog *) x));
}
static void *_p_FXDictTo_p_FXObject(void *x) {
    return (void *)((FXObject *)  ((FXDict *) x));
}
static void *_p_FXShellTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *) ((FXShell *) x));
}
static void *_p_FXScrollAreaTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *) ((FXScrollArea *) x));
}
static void *_p_FXColorWellTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXFrame *) ((FXColorWell *) x));
}
static void *_p_FXDragCornerTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *) ((FXDragCorner *) x));
}
static void *_p_FXRulerTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXFrame *) ((FXRuler *) x));
}
static void *_p_FXDialTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXFrame *) ((FXDial *) x));
}
static void *_p_FXHorizontalFrameTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXHorizontalFrame *) x));
}
static void *_p_FXVerticalFrameTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXVerticalFrame *) x));
}
static void *_p_FXImageViewTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXScrollArea *) ((FXImageView *) x));
}
static void *_p_FXDirSelectorTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXDirSelector *) x));
}
static void *_p_FXFileSelectorTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXFileSelector *) x));
}
static void *_p_FXColorSelectorTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXColorSelector *) x));
}
static void *_p_FXFontSelectorTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXFontSelector *) x));
}
static void *_p_FXToolBarTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXToolBar *) x));
}
static void *_p_FXToolBarShellTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXShell *)(FXTopWindow *) ((FXToolBarShell *) x));
}
static void *_p_FXDirBoxTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *)(FXTreeListBox *) ((FXDirBox *) x));
}
static void *_p_FXDriveBoxTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXPacker *)(FXListBox *) ((FXDriveBox *) x));
}
static void *_p_FXMessageBoxTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXShell *)(FXTopWindow *)(FXDialogBox *) ((FXMessageBox *) x));
}
static void *_p_FXToolBarTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXPacker *) ((FXToolBar *) x));
}
static void *_p_FXCompositeTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *)  ((FXComposite *) x));
}
static void *_p_FXToolTipTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXShell *) ((FXToolTip *) x));
}
static void *_p_FXTextFieldTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXFrame *) ((FXTextField *) x));
}
static void *_p_FXTabBookTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXPacker *)(FXTabBar *) ((FXTabBook *) x));
}
static void *_p_FXFileDialogTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXShell *)(FXTopWindow *)(FXDialogBox *) ((FXFileDialog *) x));
}
static void *_p_FXReplaceDialogTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXShell *)(FXTopWindow *)(FXDialogBox *) ((FXReplaceDialog *) x));
}
static void *_p_FXProgressDialogTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXShell *)(FXTopWindow *)(FXDialogBox *) ((FXProgressDialog *) x));
}
static void *_p_FXArrowButtonTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXFrame *) ((FXArrowButton *) x));
}
static void *_p_FXGroupBoxTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXPacker *) ((FXGroupBox *) x));
}
static void *_p_FXShellTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *) ((FXShell *) x));
}
static void *_p_FXStatusBarTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXPacker *)(FXHorizontalFrame *) ((FXStatusBar *) x));
}
static void *_p_FXScrollAreaTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *) ((FXScrollArea *) x));
}
static void *_p_FXPopupTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXShell *) ((FXPopup *) x));
}
static void *_p_FXScrollWindowTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXScrollArea *) ((FXScrollWindow *) x));
}
static void *_p_FXRootWindowTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *) ((FXRootWindow *) x));
}
static void *_p_FXTopWindowTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXShell *) ((FXTopWindow *) x));
}
static void *_p_FXMainWindowTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXShell *)(FXTopWindow *) ((FXMainWindow *) x));
}
static void *_p_FXRulerTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXFrame *) ((FXRuler *) x));
}
static void *_p_FXCanvasTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *)  ((FXCanvas *) x));
}
static void *_p_FXScrollCornerTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *)  ((FXScrollCorner *) x));
}
static void *_p_FXVerticalSeparatorTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXFrame *)(FXSeparator *) ((FXVerticalSeparator *) x));
}
static void *_p_FXHorizontalSeparatorTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXFrame *)(FXSeparator *) ((FXHorizontalSeparator *) x));
}
static void *_p_FXSeparatorTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXFrame *) ((FXSeparator *) x));
}
static void *_p_FXStatusLineTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXFrame *) ((FXStatusLine *) x));
}
static void *_p_FXComboBoxTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXPacker *) ((FXComboBox *) x));
}
static void *_p_FXHorizontalFrameTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXPacker *) ((FXHorizontalFrame *) x));
}
static void *_p_FXVerticalFrameTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXPacker *) ((FXVerticalFrame *) x));
}
static void *_p_FX4SplitterTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *) ((FX4Splitter *) x));
}
static void *_p_FXSplitterTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *) ((FXSplitter *) x));
}
static void *_p_FXDialogBoxTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXShell *)(FXTopWindow *) ((FXDialogBox *) x));
}
static void *_p_FXPackerTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *) ((FXPacker *) x));
}
static void *_p_FXSpinnerTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXPacker *) ((FXSpinner *) x));
}
static void *_p_FXRealSpinnerTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXPacker *) ((FXRealSpinner *) x));
}
static void *_p_FXScrollBarTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *)  ((FXScrollBar *) x));
}
static void *_p_FXColorWheelTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXFrame *) ((FXColorWheel *) x));
}
static void *_p_FXBitmapFrameTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXFrame *) ((FXBitmapFrame *) x));
}
static void *_p_FXDirBoxTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXPacker *)(FXTreeListBox *) ((FXDirBox *) x));
}
static void *_p_FXToolBarGripTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *)  ((FXToolBarGrip *) x));
}
static void *_p_FXImageFrameTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXFrame *) ((FXImageFrame *) x));
}
static void *_p_FXDragCornerTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *)  ((FXDragCorner *) x));
}
static void *_p_FXSwitcherTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXPacker *) ((FXSwitcher *) x));
}
static void *_p_FXDirSelectorTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXPacker *) ((FXDirSelector *) x));
}
static void *_p_FXFileSelectorTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXPacker *) ((FXFileSelector *) x));
}
static void *_p_FXColorSelectorTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXPacker *) ((FXColorSelector *) x));
}
static void *_p_FXFontSelectorTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXPacker *) ((FXFontSelector *) x));
}
static void *_p_FXShutterTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXPacker *)(FXVerticalFrame *) ((FXShutter *) x));
}
static void *_p_FXProgressBarTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXFrame *) ((FXProgressBar *) x));
}
static void *_p_FXListBoxTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXPacker *) ((FXListBox *) x));
}
static void *_p_FXTreeListBoxTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXPacker *) ((FXTreeListBox *) x));
}
static void *_p_FXHeaderTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXFrame *) ((FXHeader *) x));
}
static void *_p_FXMatrixTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXPacker *) ((FXMatrix *) x));
}
static void *_p_FXColorWellTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXFrame *) ((FXColorWell *) x));
}
static void *_p_FXShutterItemTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXPacker *)(FXVerticalFrame *) ((FXShutterItem *) x));
}
static void *_p_FXDialTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXFrame *) ((FXDial *) x));
}
static void *_p_FXToolBarTabTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXFrame *) ((FXToolBarTab *) x));
}
static void *_p_FXWizardTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXShell *)(FXTopWindow *)(FXDialogBox *) ((FXWizard *) x));
}
static void *_p_FXFrameTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *)  ((FXFrame *) x));
}
static void *_p_FXTabBarTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXPacker *) ((FXTabBar *) x));
}
static void *_p_FXImageViewTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXScrollArea *) ((FXImageView *) x));
}
static void *_p_FXSliderTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXFrame *) ((FXSlider *) x));
}
static void *_p_FXRealSliderTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXFrame *) ((FXRealSlider *) x));
}
static void *_p_FXDirDialogTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXShell *)(FXTopWindow *)(FXDialogBox *) ((FXDirDialog *) x));
}
static void *_p_FXColorDialogTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXShell *)(FXTopWindow *)(FXDialogBox *) ((FXColorDialog *) x));
}
static void *_p_FXFontDialogTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXShell *)(FXTopWindow *)(FXDialogBox *) ((FXFontDialog *) x));
}
static void *_p_FXSearchDialogTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXShell *)(FXTopWindow *)(FXDialogBox *)(FXReplaceDialog *) ((FXSearchDialog *) x));
}
static void *_p_FXInputDialogTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXShell *)(FXTopWindow *)(FXDialogBox *) ((FXInputDialog *) x));
}
static void *_p_FXPrintDialogTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXShell *)(FXTopWindow *)(FXDialogBox *) ((FXPrintDialog *) x));
}
static void *_p_FXSpringTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXPacker *) ((FXSpring *) x));
}
static void *_p_FXColorBarTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXFrame *) ((FXColorBar *) x));
}
static void *_p_FXToolBarShellTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXShell *)(FXTopWindow *) ((FXToolBarShell *) x));
}
static void *_p_FXMessageBoxTo_p_FXTopWindow(void *x) {
    return (void *)((FXTopWindow *) (FXDialogBox *) ((FXMessageBox *) x));
}
static void *_p_FXPrintDialogTo_p_FXTopWindow(void *x) {
    return (void *)((FXTopWindow *) (FXDialogBox *) ((FXPrintDialog *) x));
}
static void *_p_FXInputDialogTo_p_FXTopWindow(void *x) {
    return (void *)((FXTopWindow *) (FXDialogBox *) ((FXInputDialog *) x));
}
static void *_p_FXSearchDialogTo_p_FXTopWindow(void *x) {
    return (void *)((FXTopWindow *) (FXDialogBox *)(FXReplaceDialog *) ((FXSearchDialog *) x));
}
static void *_p_FXFontDialogTo_p_FXTopWindow(void *x) {
    return (void *)((FXTopWindow *) (FXDialogBox *) ((FXFontDialog *) x));
}
static void *_p_FXColorDialogTo_p_FXTopWindow(void *x) {
    return (void *)((FXTopWindow *) (FXDialogBox *) ((FXColorDialog *) x));
}
static void *_p_FXDirDialogTo_p_FXTopWindow(void *x) {
    return (void *)((FXTopWindow *) (FXDialogBox *) ((FXDirDialog *) x));
}
static void *_p_FXMainWindowTo_p_FXTopWindow(void *x) {
    return (void *)((FXTopWindow *)  ((FXMainWindow *) x));
}
static void *_p_FXWizardTo_p_FXTopWindow(void *x) {
    return (void *)((FXTopWindow *) (FXDialogBox *) ((FXWizard *) x));
}
static void *_p_FXToolBarShellTo_p_FXTopWindow(void *x) {
    return (void *)((FXTopWindow *)  ((FXToolBarShell *) x));
}
static void *_p_FXProgressDialogTo_p_FXTopWindow(void *x) {
    return (void *)((FXTopWindow *) (FXDialogBox *) ((FXProgressDialog *) x));
}
static void *_p_FXReplaceDialogTo_p_FXTopWindow(void *x) {
    return (void *)((FXTopWindow *) (FXDialogBox *) ((FXReplaceDialog *) x));
}
static void *_p_FXFileDialogTo_p_FXTopWindow(void *x) {
    return (void *)((FXTopWindow *) (FXDialogBox *) ((FXFileDialog *) x));
}
static void *_p_FXDialogBoxTo_p_FXTopWindow(void *x) {
    return (void *)((FXTopWindow *)  ((FXDialogBox *) x));
}
static void *_p_FXDriveBoxTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXPacker *)(FXListBox *) ((FXDriveBox *) x));
}
static void *_p_FXMessageBoxTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXShell *)(FXTopWindow *)(FXDialogBox *) ((FXMessageBox *) x));
}
static void *_p_FXToolBarTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXPacker *) ((FXToolBar *) x));
}
static void *_p_FXToolTipTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXShell *) ((FXToolTip *) x));
}
static void *_p_FXTabBookTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXPacker *)(FXTabBar *) ((FXTabBook *) x));
}
static void *_p_FXFileDialogTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXShell *)(FXTopWindow *)(FXDialogBox *) ((FXFileDialog *) x));
}
static void *_p_FXReplaceDialogTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXShell *)(FXTopWindow *)(FXDialogBox *) ((FXReplaceDialog *) x));
}
static void *_p_FXProgressDialogTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXShell *)(FXTopWindow *)(FXDialogBox *) ((FXProgressDialog *) x));
}
static void *_p_FXGroupBoxTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXPacker *) ((FXGroupBox *) x));
}
static void *_p_FXShellTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *)  ((FXShell *) x));
}
static void *_p_FXStatusBarTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXPacker *)(FXHorizontalFrame *) ((FXStatusBar *) x));
}
static void *_p_FXScrollAreaTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *)  ((FXScrollArea *) x));
}
static void *_p_FXPopupTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXShell *) ((FXPopup *) x));
}
static void *_p_FXScrollWindowTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXScrollArea *) ((FXScrollWindow *) x));
}
static void *_p_FXRootWindowTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *)  ((FXRootWindow *) x));
}
static void *_p_FXTopWindowTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXShell *) ((FXTopWindow *) x));
}
static void *_p_FXMainWindowTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXShell *)(FXTopWindow *) ((FXMainWindow *) x));
}
static void *_p_FXComboBoxTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXPacker *) ((FXComboBox *) x));
}
static void *_p_FXHorizontalFrameTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXPacker *) ((FXHorizontalFrame *) x));
}
static void *_p_FXVerticalFrameTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXPacker *) ((FXVerticalFrame *) x));
}
static void *_p_FX4SplitterTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *)  ((FX4Splitter *) x));
}
static void *_p_FXSplitterTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *)  ((FXSplitter *) x));
}
static void *_p_FXDialogBoxTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXShell *)(FXTopWindow *) ((FXDialogBox *) x));
}
static void *_p_FXRealSpinnerTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXPacker *) ((FXRealSpinner *) x));
}
static void *_p_FXSpinnerTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXPacker *) ((FXSpinner *) x));
}
static void *_p_FXPackerTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *)  ((FXPacker *) x));
}
static void *_p_FXDirBoxTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXPacker *)(FXTreeListBox *) ((FXDirBox *) x));
}
static void *_p_FXSwitcherTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXPacker *) ((FXSwitcher *) x));
}
static void *_p_FXColorSelectorTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXPacker *) ((FXColorSelector *) x));
}
static void *_p_FXFileSelectorTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXPacker *) ((FXFileSelector *) x));
}
static void *_p_FXDirSelectorTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXPacker *) ((FXDirSelector *) x));
}
static void *_p_FXFontSelectorTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXPacker *) ((FXFontSelector *) x));
}
static void *_p_FXShutterTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXPacker *)(FXVerticalFrame *) ((FXShutter *) x));
}
static void *_p_FXTreeListBoxTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXPacker *) ((FXTreeListBox *) x));
}
static void *_p_FXListBoxTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXPacker *) ((FXListBox *) x));
}
static void *_p_FXMatrixTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXPacker *) ((FXMatrix *) x));
}
static void *_p_FXShutterItemTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXPacker *)(FXVerticalFrame *) ((FXShutterItem *) x));
}
static void *_p_FXWizardTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXShell *)(FXTopWindow *)(FXDialogBox *) ((FXWizard *) x));
}
static void *_p_FXTabBarTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXPacker *) ((FXTabBar *) x));
}
static void *_p_FXImageViewTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXScrollArea *) ((FXImageView *) x));
}
static void *_p_FXDirDialogTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXShell *)(FXTopWindow *)(FXDialogBox *) ((FXDirDialog *) x));
}
static void *_p_FXColorDialogTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXShell *)(FXTopWindow *)(FXDialogBox *) ((FXColorDialog *) x));
}
static void *_p_FXFontDialogTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXShell *)(FXTopWindow *)(FXDialogBox *) ((FXFontDialog *) x));
}
static void *_p_FXSearchDialogTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXShell *)(FXTopWindow *)(FXDialogBox *)(FXReplaceDialog *) ((FXSearchDialog *) x));
}
static void *_p_FXInputDialogTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXShell *)(FXTopWindow *)(FXDialogBox *) ((FXInputDialog *) x));
}
static void *_p_FXPrintDialogTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXShell *)(FXTopWindow *)(FXDialogBox *) ((FXPrintDialog *) x));
}
static void *_p_FXSpringTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXPacker *) ((FXSpring *) x));
}
static void *_p_FXToolBarShellTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXShell *)(FXTopWindow *) ((FXToolBarShell *) x));
}
static void *_p_FXPopupTo_p_FXShell(void *x) {
    return (void *)((FXShell *)  ((FXPopup *) x));
}
static void *_p_FXPrintDialogTo_p_FXShell(void *x) {
    return (void *)((FXShell *) (FXTopWindow *)(FXDialogBox *) ((FXPrintDialog *) x));
}
static void *_p_FXInputDialogTo_p_FXShell(void *x) {
    return (void *)((FXShell *) (FXTopWindow *)(FXDialogBox *) ((FXInputDialog *) x));
}
static void *_p_FXSearchDialogTo_p_FXShell(void *x) {
    return (void *)((FXShell *) (FXTopWindow *)(FXDialogBox *)(FXReplaceDialog *) ((FXSearchDialog *) x));
}
static void *_p_FXFontDialogTo_p_FXShell(void *x) {
    return (void *)((FXShell *) (FXTopWindow *)(FXDialogBox *) ((FXFontDialog *) x));
}
static void *_p_FXColorDialogTo_p_FXShell(void *x) {
    return (void *)((FXShell *) (FXTopWindow *)(FXDialogBox *) ((FXColorDialog *) x));
}
static void *_p_FXDirDialogTo_p_FXShell(void *x) {
    return (void *)((FXShell *) (FXTopWindow *)(FXDialogBox *) ((FXDirDialog *) x));
}
static void *_p_FXMessageBoxTo_p_FXShell(void *x) {
    return (void *)((FXShell *) (FXTopWindow *)(FXDialogBox *) ((FXMessageBox *) x));
}
static void *_p_FXToolTipTo_p_FXShell(void *x) {
    return (void *)((FXShell *)  ((FXToolTip *) x));
}
static void *_p_FXMainWindowTo_p_FXShell(void *x) {
    return (void *)((FXShell *) (FXTopWindow *) ((FXMainWindow *) x));
}
static void *_p_FXTopWindowTo_p_FXShell(void *x) {
    return (void *)((FXShell *)  ((FXTopWindow *) x));
}
static void *_p_FXWizardTo_p_FXShell(void *x) {
    return (void *)((FXShell *) (FXTopWindow *)(FXDialogBox *) ((FXWizard *) x));
}
static void *_p_FXToolBarShellTo_p_FXShell(void *x) {
    return (void *)((FXShell *) (FXTopWindow *) ((FXToolBarShell *) x));
}
static void *_p_FXReplaceDialogTo_p_FXShell(void *x) {
    return (void *)((FXShell *) (FXTopWindow *)(FXDialogBox *) ((FXReplaceDialog *) x));
}
static void *_p_FXFileDialogTo_p_FXShell(void *x) {
    return (void *)((FXShell *) (FXTopWindow *)(FXDialogBox *) ((FXFileDialog *) x));
}
static void *_p_FXProgressDialogTo_p_FXShell(void *x) {
    return (void *)((FXShell *) (FXTopWindow *)(FXDialogBox *) ((FXProgressDialog *) x));
}
static void *_p_FXDialogBoxTo_p_FXShell(void *x) {
    return (void *)((FXShell *) (FXTopWindow *) ((FXDialogBox *) x));
}
static void *_p_FXFileStreamTo_p_FXStream(void *x) {
    return (void *)((FXStream *)  ((FXFileStream *) x));
}
static void *_p_FXMemoryStreamTo_p_FXStream(void *x) {
    return (void *)((FXStream *)  ((FXMemoryStream *) x));
}
static void *_p_FXShutterItemTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *)(FXVerticalFrame *) ((FXShutterItem *) x));
}
static void *_p_FXColorBarTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXFrame *) ((FXColorBar *) x));
}
static void *_p_FXTabBarTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *) ((FXTabBar *) x));
}
static void *_p_FXSwitcherTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *) ((FXSwitcher *) x));
}
static void *_p_FXTextFieldTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXFrame *) ((FXTextField *) x));
}
static void *_p_FXToolBarTabTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXFrame *) ((FXToolBarTab *) x));
}
static void *_p_FXDriveBoxTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *)(FXListBox *) ((FXDriveBox *) x));
}
static void *_p_FXMatrixTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *) ((FXMatrix *) x));
}
static void *_p_FXDialogBoxTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXShell *)(FXTopWindow *) ((FXDialogBox *) x));
}
static void *_p_FXScrollCornerTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *) ((FXScrollCorner *) x));
}
static void *_p_FXArrowButtonTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXFrame *) ((FXArrowButton *) x));
}
static void *_p_FXPopupTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXShell *) ((FXPopup *) x));
}
static void *_p_FXWizardTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXShell *)(FXTopWindow *)(FXDialogBox *) ((FXWizard *) x));
}
static void *_p_FXHeaderTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXFrame *) ((FXHeader *) x));
}
static void *_p_FXSplitterTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *) ((FXSplitter *) x));
}
static void *_p_FX4SplitterTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *) ((FX4Splitter *) x));
}
static void *_p_FXSpringTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *) ((FXSpring *) x));
}
static void *_p_FXPackerTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *) ((FXPacker *) x));
}
static void *_p_FXTabBookTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *)(FXTabBar *) ((FXTabBook *) x));
}
static void *_p_FXImageFrameTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXFrame *) ((FXImageFrame *) x));
}
static void *_p_FXVerticalSeparatorTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXFrame *)(FXSeparator *) ((FXVerticalSeparator *) x));
}
static void *_p_FXSeparatorTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXFrame *) ((FXSeparator *) x));
}
static void *_p_FXHorizontalSeparatorTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXFrame *)(FXSeparator *) ((FXHorizontalSeparator *) x));
}
static void *_p_FXProgressBarTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXFrame *) ((FXProgressBar *) x));
}
static void *_p_FXShutterTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *)(FXVerticalFrame *) ((FXShutter *) x));
}
static void *_p_FXProgressDialogTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXShell *)(FXTopWindow *)(FXDialogBox *) ((FXProgressDialog *) x));
}
static void *_p_FXReplaceDialogTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXShell *)(FXTopWindow *)(FXDialogBox *) ((FXReplaceDialog *) x));
}
static void *_p_FXFileDialogTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXShell *)(FXTopWindow *)(FXDialogBox *) ((FXFileDialog *) x));
}
static void *_p_FXToolTipTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXShell *) ((FXToolTip *) x));
}
static void *_p_FXCompositeTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *) ((FXComposite *) x));
}
static void *_p_FXBitmapFrameTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXFrame *) ((FXBitmapFrame *) x));
}
static void *_p_FXRealSliderTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXFrame *) ((FXRealSlider *) x));
}
static void *_p_FXSliderTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXFrame *) ((FXSlider *) x));
}
static void *_p_FXGroupBoxTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *) ((FXGroupBox *) x));
}
static void *_p_FXTreeListBoxTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *) ((FXTreeListBox *) x));
}
static void *_p_FXListBoxTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *) ((FXListBox *) x));
}
static void *_p_FXCanvasTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *) ((FXCanvas *) x));
}
static void *_p_FXColorWheelTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXFrame *) ((FXColorWheel *) x));
}
static void *_p_FXMessageBoxTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXShell *)(FXTopWindow *)(FXDialogBox *) ((FXMessageBox *) x));
}
static void *_p_FXToolBarGripTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *) ((FXToolBarGrip *) x));
}
static void *_p_FXScrollBarTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *) ((FXScrollBar *) x));
}
static void *_p_FXComboBoxTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *) ((FXComboBox *) x));
}
static void *_p_FXFrameTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *) ((FXFrame *) x));
}
static void *_p_FXStatusBarTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *)(FXHorizontalFrame *) ((FXStatusBar *) x));
}
static void *_p_FXRealSpinnerTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *) ((FXRealSpinner *) x));
}
static void *_p_FXSpinnerTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *) ((FXSpinner *) x));
}
static void *_p_FXStatusLineTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXFrame *) ((FXStatusLine *) x));
}
static void *_p_FXMainWindowTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXShell *)(FXTopWindow *) ((FXMainWindow *) x));
}
static void *_p_FXTopWindowTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXShell *) ((FXTopWindow *) x));
}
static void *_p_FXRootWindowTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *) ((FXRootWindow *) x));
}
static void *_p_FXWindowTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *)  ((FXWindow *) x));
}
static void *_p_FXScrollWindowTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXScrollArea *) ((FXScrollWindow *) x));
}
static void *_p_FXPrintDialogTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXShell *)(FXTopWindow *)(FXDialogBox *) ((FXPrintDialog *) x));
}
static void *_p_FXInputDialogTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXShell *)(FXTopWindow *)(FXDialogBox *) ((FXInputDialog *) x));
}
static void *_p_FXSearchDialogTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXShell *)(FXTopWindow *)(FXDialogBox *)(FXReplaceDialog *) ((FXSearchDialog *) x));
}
static void *_p_FXFontDialogTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXShell *)(FXTopWindow *)(FXDialogBox *) ((FXFontDialog *) x));
}
static void *_p_FXColorDialogTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXShell *)(FXTopWindow *)(FXDialogBox *) ((FXColorDialog *) x));
}
static void *_p_FXDirDialogTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXShell *)(FXTopWindow *)(FXDialogBox *) ((FXDirDialog *) x));
}
static void *_p_FXShellTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *) ((FXShell *) x));
}
static void *_p_FXScrollAreaTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *) ((FXScrollArea *) x));
}
static void *_p_FXColorWellTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXFrame *) ((FXColorWell *) x));
}
static void *_p_FXDragCornerTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *) ((FXDragCorner *) x));
}
static void *_p_FXRulerTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXFrame *) ((FXRuler *) x));
}
static void *_p_FXDialTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXFrame *) ((FXDial *) x));
}
static void *_p_FXVerticalFrameTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *) ((FXVerticalFrame *) x));
}
static void *_p_FXHorizontalFrameTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *) ((FXHorizontalFrame *) x));
}
static void *_p_FXImageViewTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXScrollArea *) ((FXImageView *) x));
}
static void *_p_FXFontSelectorTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *) ((FXFontSelector *) x));
}
static void *_p_FXColorSelectorTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *) ((FXColorSelector *) x));
}
static void *_p_FXFileSelectorTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *) ((FXFileSelector *) x));
}
static void *_p_FXDirSelectorTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *) ((FXDirSelector *) x));
}
static void *_p_FXToolBarShellTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXShell *)(FXTopWindow *) ((FXToolBarShell *) x));
}
static void *_p_FXToolBarTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *) ((FXToolBar *) x));
}
static void *_p_FXDirBoxTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *)(FXTreeListBox *) ((FXDirBox *) x));
}
static void *_p_FXStatusBarTo_p_FXHorizontalFrame(void *x) {
    return (void *)((FXHorizontalFrame *)  ((FXStatusBar *) x));
}
static void *_p_FXSearchDialogTo_p_FXReplaceDialog(void *x) {
    return (void *)((FXReplaceDialog *)  ((FXSearchDialog *) x));
}
static void *_p_FXDirDialogTo_p_FXDialogBox(void *x) {
    return (void *)((FXDialogBox *)  ((FXDirDialog *) x));
}
static void *_p_FXColorDialogTo_p_FXDialogBox(void *x) {
    return (void *)((FXDialogBox *)  ((FXColorDialog *) x));
}
static void *_p_FXFontDialogTo_p_FXDialogBox(void *x) {
    return (void *)((FXDialogBox *)  ((FXFontDialog *) x));
}
static void *_p_FXSearchDialogTo_p_FXDialogBox(void *x) {
    return (void *)((FXDialogBox *) (FXReplaceDialog *) ((FXSearchDialog *) x));
}
static void *_p_FXInputDialogTo_p_FXDialogBox(void *x) {
    return (void *)((FXDialogBox *)  ((FXInputDialog *) x));
}
static void *_p_FXPrintDialogTo_p_FXDialogBox(void *x) {
    return (void *)((FXDialogBox *)  ((FXPrintDialog *) x));
}
static void *_p_FXMessageBoxTo_p_FXDialogBox(void *x) {
    return (void *)((FXDialogBox *)  ((FXMessageBox *) x));
}
static void *_p_FXFileDialogTo_p_FXDialogBox(void *x) {
    return (void *)((FXDialogBox *)  ((FXFileDialog *) x));
}
static void *_p_FXReplaceDialogTo_p_FXDialogBox(void *x) {
    return (void *)((FXDialogBox *)  ((FXReplaceDialog *) x));
}
static void *_p_FXProgressDialogTo_p_FXDialogBox(void *x) {
    return (void *)((FXDialogBox *)  ((FXProgressDialog *) x));
}
static void *_p_FXWizardTo_p_FXDialogBox(void *x) {
    return (void *)((FXDialogBox *)  ((FXWizard *) x));
}
static swig_type_info _swigt__p_FXObject[] = {{"_p_FXObject", 0, "FXObject *", 0, 0, 0, 0},{"_p_FXDocument", _p_FXDocumentTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXRegistry", _p_FXRegistryTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXHeaderItem", _p_FXHeaderItemTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXShutterItem", _p_FXShutterItemTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXColorBar", _p_FXColorBarTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXTabBar", _p_FXTabBarTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXSwitcher", _p_FXSwitcherTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXTextField", _p_FXTextFieldTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXToolBarTab", _p_FXToolBarTabTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXDriveBox", _p_FXDriveBoxTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXIconDict", _p_FXIconDictTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXMatrix", _p_FXMatrixTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXFileDict", _p_FXFileDictTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXDialogBox", _p_FXDialogBoxTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXRecentFiles", _p_FXRecentFilesTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXScrollCorner", _p_FXScrollCornerTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXArrowButton", _p_FXArrowButtonTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXPopup", _p_FXPopupTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXDrawable", _p_FXDrawableTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXFont", _p_FXFontTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXWizard", _p_FXWizardTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXHeader", _p_FXHeaderTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXSplitter", _p_FXSplitterTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FX4Splitter", _p_FX4SplitterTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXSpring", _p_FXSpringTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXPacker", _p_FXPackerTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXTabBook", _p_FXTabBookTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXApp", _p_FXAppTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXImageFrame", _p_FXImageFrameTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXHorizontalSeparator", _p_FXHorizontalSeparatorTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXSeparator", _p_FXSeparatorTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXVerticalSeparator", _p_FXVerticalSeparatorTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXProgressBar", _p_FXProgressBarTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXShutter", _p_FXShutterTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXFileDialog", _p_FXFileDialogTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXReplaceDialog", _p_FXReplaceDialogTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXProgressDialog", _p_FXProgressDialogTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXComposite", _p_FXCompositeTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXToolTip", _p_FXToolTipTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXDict", _p_FXDictTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXBitmapFrame", _p_FXBitmapFrameTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXSlider", _p_FXSliderTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXRealSlider", _p_FXRealSliderTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXSettings", _p_FXSettingsTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXGroupBox", _p_FXGroupBoxTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXDataTarget", _p_FXDataTargetTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXDebugTarget", _p_FXDebugTargetTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXListBox", _p_FXListBoxTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXTreeListBox", _p_FXTreeListBoxTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXCanvas", _p_FXCanvasTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXId", _p_FXIdTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXColorWheel", _p_FXColorWheelTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXDial", _p_FXDialTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXMessageBox", _p_FXMessageBoxTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXToolBarGrip", _p_FXToolBarGripTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXScrollBar", _p_FXScrollBarTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXVisual", _p_FXVisualTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXComboBox", _p_FXComboBoxTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXFrame", _p_FXFrameTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXStatusBar", _p_FXStatusBarTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXStringDict", _p_FXStringDictTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXDelegator", _p_FXDelegatorTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXAccelTable", _p_FXAccelTableTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXObject", 0, 0, 0, 0, 0, 0},{"_p_FXCursor", _p_FXCursorTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXCURCursor", _p_FXCURCursorTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXGIFCursor", _p_FXGIFCursorTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXRealSpinner", _p_FXRealSpinnerTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXSpinner", _p_FXSpinnerTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXScrollWindow", _p_FXScrollWindowTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXRootWindow", _p_FXRootWindowTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXMainWindow", _p_FXMainWindowTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXTopWindow", _p_FXTopWindowTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXStatusLine", _p_FXStatusLineTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXWindow", _p_FXWindowTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXDirDialog", _p_FXDirDialogTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXColorDialog", _p_FXColorDialogTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXFontDialog", _p_FXFontDialogTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXSearchDialog", _p_FXSearchDialogTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXInputDialog", _p_FXInputDialogTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXPrintDialog", _p_FXPrintDialogTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXShell", _p_FXShellTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXScrollArea", _p_FXScrollAreaTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXColorWell", _p_FXColorWellTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXDragCorner", _p_FXDragCornerTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXRuler", _p_FXRulerTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXHorizontalFrame", _p_FXHorizontalFrameTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXVerticalFrame", _p_FXVerticalFrameTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXImageView", _p_FXImageViewTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXColorSelector", _p_FXColorSelectorTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXFileSelector", _p_FXFileSelectorTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXDirSelector", _p_FXDirSelectorTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXFontSelector", _p_FXFontSelectorTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXToolBarShell", _p_FXToolBarShellTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXToolBar", _p_FXToolBarTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXDirBox", _p_FXDirBoxTo_p_FXObject, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXColorDialog[] = {{"_p_FXColorDialog", 0, "FXColorDialog *", 0, 0, 0, 0},{"_p_FXColorDialog", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXDirDialog[] = {{"_p_FXDirDialog", 0, "FXDirDialog *", 0, 0, 0, 0},{"_p_FXDirDialog", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXFontDialog[] = {{"_p_FXFontDialog", 0, "FXFontDialog *", 0, 0, 0, 0},{"_p_FXFontDialog", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXSearchDialog[] = {{"_p_FXSearchDialog", 0, "FXSearchDialog *", 0, 0, 0, 0},{"_p_FXSearchDialog", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXInputDialog[] = {{"_p_FXInputDialog", 0, "FXInputDialog *", 0, 0, 0, 0},{"_p_FXInputDialog", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXPrintDialog[] = {{"_p_FXPrintDialog", 0, "FXPrintDialog *", 0, 0, 0, 0},{"_p_FXPrintDialog", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXPrinter[] = {{"_p_FXPrinter", 0, "FXPrinter *", 0, 0, 0, 0},{"_p_FXPrinter", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXMessageBox[] = {{"_p_FXMessageBox", 0, "FXMessageBox *", 0, 0, 0, 0},{"_p_FXMessageBox", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXWindow[] = {{"_p_FXWindow", 0, "FXWindow *", 0, 0, 0, 0},{"_p_FXShutterItem", _p_FXShutterItemTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXColorBar", _p_FXColorBarTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXTabBar", _p_FXTabBarTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXSwitcher", _p_FXSwitcherTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXTextField", _p_FXTextFieldTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXToolBarTab", _p_FXToolBarTabTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXDriveBox", _p_FXDriveBoxTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXMatrix", _p_FXMatrixTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXDialogBox", _p_FXDialogBoxTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXScrollCorner", _p_FXScrollCornerTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXArrowButton", _p_FXArrowButtonTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXPopup", _p_FXPopupTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXWizard", _p_FXWizardTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXHeader", _p_FXHeaderTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FX4Splitter", _p_FX4SplitterTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXSplitter", _p_FXSplitterTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXSpring", _p_FXSpringTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXPacker", _p_FXPackerTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXTabBook", _p_FXTabBookTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXImageFrame", _p_FXImageFrameTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXVerticalSeparator", _p_FXVerticalSeparatorTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXHorizontalSeparator", _p_FXHorizontalSeparatorTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXSeparator", _p_FXSeparatorTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXProgressBar", _p_FXProgressBarTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXShutter", _p_FXShutterTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXFileDialog", _p_FXFileDialogTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXReplaceDialog", _p_FXReplaceDialogTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXProgressDialog", _p_FXProgressDialogTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXComposite", _p_FXCompositeTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXToolTip", _p_FXToolTipTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXBitmapFrame", _p_FXBitmapFrameTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXSlider", _p_FXSliderTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXRealSlider", _p_FXRealSliderTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXGroupBox", _p_FXGroupBoxTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXListBox", _p_FXListBoxTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXTreeListBox", _p_FXTreeListBoxTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXCanvas", _p_FXCanvasTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXColorWheel", _p_FXColorWheelTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXDial", _p_FXDialTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXMessageBox", _p_FXMessageBoxTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXToolBarGrip", _p_FXToolBarGripTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXScrollBar", _p_FXScrollBarTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXComboBox", _p_FXComboBoxTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXFrame", _p_FXFrameTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXStatusBar", _p_FXStatusBarTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXRealSpinner", _p_FXRealSpinnerTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXSpinner", _p_FXSpinnerTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXStatusLine", _p_FXStatusLineTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXScrollWindow", _p_FXScrollWindowTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXRootWindow", _p_FXRootWindowTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXMainWindow", _p_FXMainWindowTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXTopWindow", _p_FXTopWindowTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXWindow", 0, 0, 0, 0, 0, 0},{"_p_FXSearchDialog", _p_FXSearchDialogTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXFontDialog", _p_FXFontDialogTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXColorDialog", _p_FXColorDialogTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXDirDialog", _p_FXDirDialogTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXInputDialog", _p_FXInputDialogTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXPrintDialog", _p_FXPrintDialogTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXShell", _p_FXShellTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXScrollArea", _p_FXScrollAreaTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXColorWell", _p_FXColorWellTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXDragCorner", _p_FXDragCornerTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXRuler", _p_FXRulerTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXHorizontalFrame", _p_FXHorizontalFrameTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXVerticalFrame", _p_FXVerticalFrameTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXImageView", _p_FXImageViewTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXColorSelector", _p_FXColorSelectorTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXFileSelector", _p_FXFileSelectorTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXDirSelector", _p_FXDirSelectorTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXFontSelector", _p_FXFontSelectorTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXToolBarShell", _p_FXToolBarShellTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXToolBar", _p_FXToolBarTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXDirBox", _p_FXDirBoxTo_p_FXWindow, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXTopWindow[] = {{"_p_FXTopWindow", 0, "FXTopWindow *", 0, 0, 0, 0},{"_p_FXMessageBox", _p_FXMessageBoxTo_p_FXTopWindow, 0, 0, 0, 0, 0},{"_p_FXPrintDialog", _p_FXPrintDialogTo_p_FXTopWindow, 0, 0, 0, 0, 0},{"_p_FXInputDialog", _p_FXInputDialogTo_p_FXTopWindow, 0, 0, 0, 0, 0},{"_p_FXSearchDialog", _p_FXSearchDialogTo_p_FXTopWindow, 0, 0, 0, 0, 0},{"_p_FXFontDialog", _p_FXFontDialogTo_p_FXTopWindow, 0, 0, 0, 0, 0},{"_p_FXColorDialog", _p_FXColorDialogTo_p_FXTopWindow, 0, 0, 0, 0, 0},{"_p_FXDirDialog", _p_FXDirDialogTo_p_FXTopWindow, 0, 0, 0, 0, 0},{"_p_FXMainWindow", _p_FXMainWindowTo_p_FXTopWindow, 0, 0, 0, 0, 0},{"_p_FXTopWindow", 0, 0, 0, 0, 0, 0},{"_p_FXWizard", _p_FXWizardTo_p_FXTopWindow, 0, 0, 0, 0, 0},{"_p_FXToolBarShell", _p_FXToolBarShellTo_p_FXTopWindow, 0, 0, 0, 0, 0},{"_p_FXProgressDialog", _p_FXProgressDialogTo_p_FXTopWindow, 0, 0, 0, 0, 0},{"_p_FXReplaceDialog", _p_FXReplaceDialogTo_p_FXTopWindow, 0, 0, 0, 0, 0},{"_p_FXFileDialog", _p_FXFileDialogTo_p_FXTopWindow, 0, 0, 0, 0, 0},{"_p_FXDialogBox", _p_FXDialogBoxTo_p_FXTopWindow, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXComposite[] = {{"_p_FXComposite", 0, "FXComposite *", 0, 0, 0, 0},{"_p_FXDriveBox", _p_FXDriveBoxTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXMessageBox", _p_FXMessageBoxTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXToolBar", _p_FXToolBarTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXComposite", 0, 0, 0, 0, 0, 0},{"_p_FXToolTip", _p_FXToolTipTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXFileDialog", _p_FXFileDialogTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXReplaceDialog", _p_FXReplaceDialogTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXProgressDialog", _p_FXProgressDialogTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXTabBook", _p_FXTabBookTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXGroupBox", _p_FXGroupBoxTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXShell", _p_FXShellTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXStatusBar", _p_FXStatusBarTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXScrollArea", _p_FXScrollAreaTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXPopup", _p_FXPopupTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXScrollWindow", _p_FXScrollWindowTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXRootWindow", _p_FXRootWindowTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXMainWindow", _p_FXMainWindowTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXTopWindow", _p_FXTopWindowTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXComboBox", _p_FXComboBoxTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXHorizontalFrame", _p_FXHorizontalFrameTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXVerticalFrame", _p_FXVerticalFrameTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXDialogBox", _p_FXDialogBoxTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FX4Splitter", _p_FX4SplitterTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXSplitter", _p_FXSplitterTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXRealSpinner", _p_FXRealSpinnerTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXSpinner", _p_FXSpinnerTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXPacker", _p_FXPackerTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXDirBox", _p_FXDirBoxTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXSwitcher", _p_FXSwitcherTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXFontSelector", _p_FXFontSelectorTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXDirSelector", _p_FXDirSelectorTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXFileSelector", _p_FXFileSelectorTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXColorSelector", _p_FXColorSelectorTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXShutter", _p_FXShutterTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXTreeListBox", _p_FXTreeListBoxTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXListBox", _p_FXListBoxTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXMatrix", _p_FXMatrixTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXShutterItem", _p_FXShutterItemTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXWizard", _p_FXWizardTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXTabBar", _p_FXTabBarTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXImageView", _p_FXImageViewTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXPrintDialog", _p_FXPrintDialogTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXInputDialog", _p_FXInputDialogTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXFontDialog", _p_FXFontDialogTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXColorDialog", _p_FXColorDialogTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXSearchDialog", _p_FXSearchDialogTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXDirDialog", _p_FXDirDialogTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXSpring", _p_FXSpringTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXToolBarShell", _p_FXToolBarShellTo_p_FXComposite, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXId[] = {{"_p_FXId", 0, "FXId *", 0, 0, 0, 0},{"_p_FXShutterItem", _p_FXShutterItemTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXColorBar", _p_FXColorBarTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXTabBar", _p_FXTabBarTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXSwitcher", _p_FXSwitcherTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXTextField", _p_FXTextFieldTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXToolBarTab", _p_FXToolBarTabTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXDriveBox", _p_FXDriveBoxTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXMatrix", _p_FXMatrixTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXDialogBox", _p_FXDialogBoxTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXScrollCorner", _p_FXScrollCornerTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXArrowButton", _p_FXArrowButtonTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXPopup", _p_FXPopupTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXDrawable", _p_FXDrawableTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXFont", _p_FXFontTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXWizard", _p_FXWizardTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXHeader", _p_FXHeaderTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXSplitter", _p_FXSplitterTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FX4Splitter", _p_FX4SplitterTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXSpring", _p_FXSpringTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXPacker", _p_FXPackerTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXTabBook", _p_FXTabBookTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXImageFrame", _p_FXImageFrameTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXHorizontalSeparator", _p_FXHorizontalSeparatorTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXVerticalSeparator", _p_FXVerticalSeparatorTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXSeparator", _p_FXSeparatorTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXProgressBar", _p_FXProgressBarTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXShutter", _p_FXShutterTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXFileDialog", _p_FXFileDialogTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXReplaceDialog", _p_FXReplaceDialogTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXProgressDialog", _p_FXProgressDialogTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXComposite", _p_FXCompositeTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXToolTip", _p_FXToolTipTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXBitmapFrame", _p_FXBitmapFrameTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXSlider", _p_FXSliderTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXRealSlider", _p_FXRealSliderTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXGroupBox", _p_FXGroupBoxTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXListBox", _p_FXListBoxTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXTreeListBox", _p_FXTreeListBoxTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXCanvas", _p_FXCanvasTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXId", 0, 0, 0, 0, 0, 0},{"_p_FXColorWheel", _p_FXColorWheelTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXDial", _p_FXDialTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXMessageBox", _p_FXMessageBoxTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXToolBarGrip", _p_FXToolBarGripTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXScrollBar", _p_FXScrollBarTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXVisual", _p_FXVisualTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXComboBox", _p_FXComboBoxTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXFrame", _p_FXFrameTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXStatusBar", _p_FXStatusBarTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXCursor", _p_FXCursorTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXCURCursor", _p_FXCURCursorTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXGIFCursor", _p_FXGIFCursorTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXRealSpinner", _p_FXRealSpinnerTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXSpinner", _p_FXSpinnerTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXStatusLine", _p_FXStatusLineTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXWindow", _p_FXWindowTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXScrollWindow", _p_FXScrollWindowTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXRootWindow", _p_FXRootWindowTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXMainWindow", _p_FXMainWindowTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXTopWindow", _p_FXTopWindowTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXSearchDialog", _p_FXSearchDialogTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXFontDialog", _p_FXFontDialogTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXColorDialog", _p_FXColorDialogTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXDirDialog", _p_FXDirDialogTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXInputDialog", _p_FXInputDialogTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXPrintDialog", _p_FXPrintDialogTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXShell", _p_FXShellTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXScrollArea", _p_FXScrollAreaTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXColorWell", _p_FXColorWellTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXDragCorner", _p_FXDragCornerTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXRuler", _p_FXRulerTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXHorizontalFrame", _p_FXHorizontalFrameTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXVerticalFrame", _p_FXVerticalFrameTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXImageView", _p_FXImageViewTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXColorSelector", _p_FXColorSelectorTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXFileSelector", _p_FXFileSelectorTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXDirSelector", _p_FXDirSelectorTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXFontSelector", _p_FXFontSelectorTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXToolBarShell", _p_FXToolBarShellTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXToolBar", _p_FXToolBarTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXDirBox", _p_FXDirBoxTo_p_FXId, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXShell[] = {{"_p_FXShell", 0, "FXShell *", 0, 0, 0, 0},{"_p_FXPopup", _p_FXPopupTo_p_FXShell, 0, 0, 0, 0, 0},{"_p_FXPrintDialog", _p_FXPrintDialogTo_p_FXShell, 0, 0, 0, 0, 0},{"_p_FXInputDialog", _p_FXInputDialogTo_p_FXShell, 0, 0, 0, 0, 0},{"_p_FXSearchDialog", _p_FXSearchDialogTo_p_FXShell, 0, 0, 0, 0, 0},{"_p_FXFontDialog", _p_FXFontDialogTo_p_FXShell, 0, 0, 0, 0, 0},{"_p_FXColorDialog", _p_FXColorDialogTo_p_FXShell, 0, 0, 0, 0, 0},{"_p_FXDirDialog", _p_FXDirDialogTo_p_FXShell, 0, 0, 0, 0, 0},{"_p_FXMessageBox", _p_FXMessageBoxTo_p_FXShell, 0, 0, 0, 0, 0},{"_p_FXToolTip", _p_FXToolTipTo_p_FXShell, 0, 0, 0, 0, 0},{"_p_FXMainWindow", _p_FXMainWindowTo_p_FXShell, 0, 0, 0, 0, 0},{"_p_FXTopWindow", _p_FXTopWindowTo_p_FXShell, 0, 0, 0, 0, 0},{"_p_FXWizard", _p_FXWizardTo_p_FXShell, 0, 0, 0, 0, 0},{"_p_FXShell", 0, 0, 0, 0, 0, 0},{"_p_FXToolBarShell", _p_FXToolBarShellTo_p_FXShell, 0, 0, 0, 0, 0},{"_p_FXFileDialog", _p_FXFileDialogTo_p_FXShell, 0, 0, 0, 0, 0},{"_p_FXReplaceDialog", _p_FXReplaceDialogTo_p_FXShell, 0, 0, 0, 0, 0},{"_p_FXProgressDialog", _p_FXProgressDialogTo_p_FXShell, 0, 0, 0, 0, 0},{"_p_FXDialogBox", _p_FXDialogBoxTo_p_FXShell, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXWizard[] = {{"_p_FXWizard", 0, "FXWizard *", 0, 0, 0, 0},{"_p_FXWizard", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXButton[] = {{"_p_FXButton", 0, "FXButton *", 0, 0, 0, 0},{"_p_FXButton", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXStream[] = {{"_p_FXStream", 0, "FXStream *", 0, 0, 0, 0},{"_p_FXFileStream", _p_FXFileStreamTo_p_FXStream, 0, 0, 0, 0, 0},{"_p_FXMemoryStream", _p_FXMemoryStreamTo_p_FXStream, 0, 0, 0, 0, 0},{"_p_FXStream", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXDrawable[] = {{"_p_FXDrawable", 0, "FXDrawable *", 0, 0, 0, 0},{"_p_FXShutterItem", _p_FXShutterItemTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXColorBar", _p_FXColorBarTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXTabBar", _p_FXTabBarTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXSwitcher", _p_FXSwitcherTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXTextField", _p_FXTextFieldTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXToolBarTab", _p_FXToolBarTabTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXDriveBox", _p_FXDriveBoxTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXMatrix", _p_FXMatrixTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXDialogBox", _p_FXDialogBoxTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXScrollCorner", _p_FXScrollCornerTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXArrowButton", _p_FXArrowButtonTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXPopup", _p_FXPopupTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXDrawable", 0, 0, 0, 0, 0, 0},{"_p_FXWizard", _p_FXWizardTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXHeader", _p_FXHeaderTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXSplitter", _p_FXSplitterTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FX4Splitter", _p_FX4SplitterTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXSpring", _p_FXSpringTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXPacker", _p_FXPackerTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXTabBook", _p_FXTabBookTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXImageFrame", _p_FXImageFrameTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXVerticalSeparator", _p_FXVerticalSeparatorTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXSeparator", _p_FXSeparatorTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXHorizontalSeparator", _p_FXHorizontalSeparatorTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXProgressBar", _p_FXProgressBarTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXShutter", _p_FXShutterTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXFileDialog", _p_FXFileDialogTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXReplaceDialog", _p_FXReplaceDialogTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXProgressDialog", _p_FXProgressDialogTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXComposite", _p_FXCompositeTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXToolTip", _p_FXToolTipTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXBitmapFrame", _p_FXBitmapFrameTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXSlider", _p_FXSliderTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXRealSlider", _p_FXRealSliderTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXGroupBox", _p_FXGroupBoxTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXListBox", _p_FXListBoxTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXTreeListBox", _p_FXTreeListBoxTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXCanvas", _p_FXCanvasTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXColorWheel", _p_FXColorWheelTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXDial", _p_FXDialTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXMessageBox", _p_FXMessageBoxTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXToolBarGrip", _p_FXToolBarGripTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXScrollBar", _p_FXScrollBarTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXComboBox", _p_FXComboBoxTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXFrame", _p_FXFrameTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXStatusBar", _p_FXStatusBarTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXRealSpinner", _p_FXRealSpinnerTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXSpinner", _p_FXSpinnerTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXStatusLine", _p_FXStatusLineTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXWindow", _p_FXWindowTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXScrollWindow", _p_FXScrollWindowTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXRootWindow", _p_FXRootWindowTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXMainWindow", _p_FXMainWindowTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXTopWindow", _p_FXTopWindowTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXSearchDialog", _p_FXSearchDialogTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXFontDialog", _p_FXFontDialogTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXColorDialog", _p_FXColorDialogTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXDirDialog", _p_FXDirDialogTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXInputDialog", _p_FXInputDialogTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXPrintDialog", _p_FXPrintDialogTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXShell", _p_FXShellTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXScrollArea", _p_FXScrollAreaTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXColorWell", _p_FXColorWellTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXDragCorner", _p_FXDragCornerTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXRuler", _p_FXRulerTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXHorizontalFrame", _p_FXHorizontalFrameTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXVerticalFrame", _p_FXVerticalFrameTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXImageView", _p_FXImageViewTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXColorSelector", _p_FXColorSelectorTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXFileSelector", _p_FXFileSelectorTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXDirSelector", _p_FXDirSelectorTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXFontSelector", _p_FXFontSelectorTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXToolBarShell", _p_FXToolBarShellTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXToolBar", _p_FXToolBarTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXDirBox", _p_FXDirBoxTo_p_FXDrawable, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXHorizontalFrame[] = {{"_p_FXHorizontalFrame", 0, "FXHorizontalFrame *", 0, 0, 0, 0},{"_p_FXHorizontalFrame", 0, 0, 0, 0, 0, 0},{"_p_FXStatusBar", _p_FXStatusBarTo_p_FXHorizontalFrame, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXIcon[] = {{"_p_FXIcon", 0, "FXIcon *", 0, 0, 0, 0},{"_p_FXIcon", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXFileDialog[] = {{"_p_FXFileDialog", 0, "FXFileDialog *", 0, 0, 0, 0},{"_p_FXFileDialog", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXReplaceDialog[] = {{"_p_FXReplaceDialog", 0, "FXReplaceDialog *", 0, 0, 0, 0},{"_p_FXSearchDialog", _p_FXSearchDialogTo_p_FXReplaceDialog, 0, 0, 0, 0, 0},{"_p_FXReplaceDialog", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXApp[] = {{"_p_FXApp", 0, "FXApp *", 0, 0, 0, 0},{"_p_FXApp", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXProgressDialog[] = {{"_p_FXProgressDialog", 0, "FXProgressDialog *", 0, 0, 0, 0},{"_p_FXProgressDialog", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXFontDesc[] = {{"_p_FXFontDesc", 0, "FXFontDesc *", 0, 0, 0, 0},{"_p_FXFontDesc", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXImage[] = {{"_p_FXImage", 0, "FXImage *", 0, 0, 0, 0},{"_p_FXImage", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXDialogBox[] = {{"_p_FXDialogBox", 0, "FXDialogBox *", 0, 0, 0, 0},{"_p_FXDialogBox", 0, 0, 0, 0, 0, 0},{"_p_FXDirDialog", _p_FXDirDialogTo_p_FXDialogBox, 0, 0, 0, 0, 0},{"_p_FXColorDialog", _p_FXColorDialogTo_p_FXDialogBox, 0, 0, 0, 0, 0},{"_p_FXFontDialog", _p_FXFontDialogTo_p_FXDialogBox, 0, 0, 0, 0, 0},{"_p_FXSearchDialog", _p_FXSearchDialogTo_p_FXDialogBox, 0, 0, 0, 0, 0},{"_p_FXInputDialog", _p_FXInputDialogTo_p_FXDialogBox, 0, 0, 0, 0, 0},{"_p_FXPrintDialog", _p_FXPrintDialogTo_p_FXDialogBox, 0, 0, 0, 0, 0},{"_p_FXMessageBox", _p_FXMessageBoxTo_p_FXDialogBox, 0, 0, 0, 0, 0},{"_p_FXFileDialog", _p_FXFileDialogTo_p_FXDialogBox, 0, 0, 0, 0, 0},{"_p_FXReplaceDialog", _p_FXReplaceDialogTo_p_FXDialogBox, 0, 0, 0, 0, 0},{"_p_FXProgressDialog", _p_FXProgressDialogTo_p_FXDialogBox, 0, 0, 0, 0, 0},{"_p_FXWizard", _p_FXWizardTo_p_FXDialogBox, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXSwitcher[] = {{"_p_FXSwitcher", 0, "FXSwitcher *", 0, 0, 0, 0},{"_p_FXSwitcher", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};

static swig_type_info *swig_types_initial[] = {
_swigt__p_FXObject, 
_swigt__p_FXColorDialog, 
_swigt__p_FXDirDialog, 
_swigt__p_FXFontDialog, 
_swigt__p_FXSearchDialog, 
_swigt__p_FXInputDialog, 
_swigt__p_FXPrintDialog, 
_swigt__p_FXPrinter, 
_swigt__p_FXMessageBox, 
_swigt__p_FXWindow, 
_swigt__p_FXTopWindow, 
_swigt__p_FXComposite, 
_swigt__p_FXId, 
_swigt__p_FXShell, 
_swigt__p_FXWizard, 
_swigt__p_FXButton, 
_swigt__p_FXStream, 
_swigt__p_FXDrawable, 
_swigt__p_FXHorizontalFrame, 
_swigt__p_FXIcon, 
_swigt__p_FXFileDialog, 
_swigt__p_FXReplaceDialog, 
_swigt__p_FXApp, 
_swigt__p_FXProgressDialog, 
_swigt__p_FXFontDesc, 
_swigt__p_FXImage, 
_swigt__p_FXDialogBox, 
_swigt__p_FXSwitcher, 
0
};


/* -------- TYPE CONVERSION AND EQUIVALENCE RULES (END) -------- */


#ifdef __cplusplus
extern "C"
#endif
SWIGEXPORT(void) Init_dialogs(void) {
    int i;
    
    SWIG_InitRuntime();
    
    for (i = 0; swig_types_initial[i]; i++) {
        swig_types[i] = SWIG_TypeRegister(swig_types_initial[i]);
        SWIG_define_class(swig_types[i]);
    }
    
    
    cFXDialogBox.klass = rb_define_class_under(mFox, "FXDialogBox", ((swig_class *) SWIGTYPE_p_FXTopWindow->clientdata)->klass);
    SWIG_TypeClientData(SWIGTYPE_p_FXDialogBox, (void *) &cFXDialogBox);
    rb_define_alloc_func(cFXDialogBox.klass, _wrap_FXDialogBox_allocate);
    rb_define_method(cFXDialogBox.klass, "initialize", VALUEFUNC(_wrap_new_FXDialogBox), -1);
    rb_define_method(cFXDialogBox.klass, "onKeyPress", VALUEFUNC(_wrap_FXDialogBox_onKeyPress), -1);
    rb_define_method(cFXDialogBox.klass, "onKeyRelease", VALUEFUNC(_wrap_FXDialogBox_onKeyRelease), -1);
    rb_define_method(cFXDialogBox.klass, "onCmdAccept", VALUEFUNC(_wrap_FXDialogBox_onCmdAccept), -1);
    rb_define_method(cFXDialogBox.klass, "onCmdCancel", VALUEFUNC(_wrap_FXDialogBox_onCmdCancel), -1);
    rb_define_const(cFXDialogBox.klass,"ID_CANCEL", INT2NUM(FXDialogBox::ID_CANCEL));
    rb_define_const(cFXDialogBox.klass,"ID_ACCEPT", INT2NUM(FXDialogBox::ID_ACCEPT));
    rb_define_const(cFXDialogBox.klass,"ID_LAST", INT2NUM(FXDialogBox::ID_LAST));
    rb_define_method(cFXDialogBox.klass, "save", VALUEFUNC(_wrap_FXDialogBox_save), -1);
    rb_define_method(cFXDialogBox.klass, "load", VALUEFUNC(_wrap_FXDialogBox_load), -1);
    rb_define_method(cFXDialogBox.klass, "create", VALUEFUNC(_wrap_FXDialogBox_create), -1);
    rb_define_method(cFXDialogBox.klass, "detach", VALUEFUNC(_wrap_FXDialogBox_detach), -1);
    rb_define_method(cFXDialogBox.klass, "destroy", VALUEFUNC(_wrap_FXDialogBox_destroy), -1);
    rb_define_method(cFXDialogBox.klass, "resize", VALUEFUNC(_wrap_FXDialogBox_resize), -1);
    rb_define_method(cFXDialogBox.klass, "getDefaultWidth", VALUEFUNC(_wrap_FXDialogBox_getDefaultWidth), -1);
    rb_define_method(cFXDialogBox.klass, "getDefaultHeight", VALUEFUNC(_wrap_FXDialogBox_getDefaultHeight), -1);
    rb_define_method(cFXDialogBox.klass, "getWidthForHeight", VALUEFUNC(_wrap_FXDialogBox_getWidthForHeight), -1);
    rb_define_method(cFXDialogBox.klass, "getHeightForWidth", VALUEFUNC(_wrap_FXDialogBox_getHeightForWidth), -1);
    rb_define_method(cFXDialogBox.klass, "canFocus", VALUEFUNC(_wrap_FXDialogBox_canFocus), -1);
    rb_define_method(cFXDialogBox.klass, "setFocus", VALUEFUNC(_wrap_FXDialogBox_setFocus), -1);
    rb_define_method(cFXDialogBox.klass, "killFocus", VALUEFUNC(_wrap_FXDialogBox_killFocus), -1);
    rb_define_method(cFXDialogBox.klass, "setDefault", VALUEFUNC(_wrap_FXDialogBox_setDefault), -1);
    rb_define_method(cFXDialogBox.klass, "enable", VALUEFUNC(_wrap_FXDialogBox_enable), -1);
    rb_define_method(cFXDialogBox.klass, "disable", VALUEFUNC(_wrap_FXDialogBox_disable), -1);
    rb_define_method(cFXDialogBox.klass, "raiseWindow", VALUEFUNC(_wrap_FXDialogBox_raiseWindow), -1);
    rb_define_method(cFXDialogBox.klass, "lower", VALUEFUNC(_wrap_FXDialogBox_lower), -1);
    rb_define_method(cFXDialogBox.klass, "move", VALUEFUNC(_wrap_FXDialogBox_move), -1);
    rb_define_method(cFXDialogBox.klass, "position", VALUEFUNC(_wrap_FXDialogBox_position), -1);
    rb_define_method(cFXDialogBox.klass, "layout", VALUEFUNC(_wrap_FXDialogBox_layout), -1);
    rb_define_method(cFXDialogBox.klass, "recalc", VALUEFUNC(_wrap_FXDialogBox_recalc), -1);
    rb_define_method(cFXDialogBox.klass, "reparent", VALUEFUNC(_wrap_FXDialogBox_reparent), -1);
    rb_define_method(cFXDialogBox.klass, "hide", VALUEFUNC(_wrap_FXDialogBox_hide), -1);
    rb_define_method(cFXDialogBox.klass, "isComposite", VALUEFUNC(_wrap_FXDialogBox_isComposite), -1);
    rb_define_method(cFXDialogBox.klass, "contains", VALUEFUNC(_wrap_FXDialogBox_contains), -1);
    rb_define_method(cFXDialogBox.klass, "doesSaveUnder", VALUEFUNC(_wrap_FXDialogBox_doesSaveUnder), -1);
    rb_define_method(cFXDialogBox.klass, "setBackColor", VALUEFUNC(_wrap_FXDialogBox_setBackColor), -1);
    rb_define_method(cFXDialogBox.klass, "show", VALUEFUNC(_wrap_FXDialogBox_show), -1);
    rb_define_method(cFXDialogBox.klass, "maximize", VALUEFUNC(_wrap_FXDialogBox_maximize), -1);
    rb_define_method(cFXDialogBox.klass, "minimize", VALUEFUNC(_wrap_FXDialogBox_minimize), -1);
    rb_define_method(cFXDialogBox.klass, "restore", VALUEFUNC(_wrap_FXDialogBox_restore), -1);
    rb_define_method(cFXDialogBox.klass, "close", VALUEFUNC(_wrap_FXDialogBox_close), -1);
    rb_define_method(cFXDialogBox.klass, "execute", VALUEFUNC(_wrap_FXDialogBox_execute), -1);
    cFXDialogBox.mark = (void (*)(void *)) FXRbDialogBox::markfunc;
    cFXDialogBox.destroy = (void (*)(void *)) FXRbObject::freefunc;
    
    SWIGTYPE_p_FXDialogBox->dcast = (swig_dycast_func) FXDialogBox_dynamic_cast;
    
    
    cFXDirDialog.klass = rb_define_class_under(mFox, "FXDirDialog", ((swig_class *) SWIGTYPE_p_FXDialogBox->clientdata)->klass);
    SWIG_TypeClientData(SWIGTYPE_p_FXDirDialog, (void *) &cFXDirDialog);
    rb_define_alloc_func(cFXDirDialog.klass, _wrap_FXDirDialog_allocate);
    rb_define_method(cFXDirDialog.klass, "initialize", VALUEFUNC(_wrap_new_FXDirDialog), -1);
    rb_define_method(cFXDirDialog.klass, "setDirectory", VALUEFUNC(_wrap_FXDirDialog_setDirectory), -1);
    rb_define_method(cFXDirDialog.klass, "getDirectory", VALUEFUNC(_wrap_FXDirDialog_getDirectory), -1);
    rb_define_method(cFXDirDialog.klass, "setDirBoxStyle", VALUEFUNC(_wrap_FXDirDialog_setDirBoxStyle), -1);
    rb_define_method(cFXDirDialog.klass, "getDirBoxStyle", VALUEFUNC(_wrap_FXDirDialog_getDirBoxStyle), -1);
    rb_define_method(cFXDirDialog.klass, "save", VALUEFUNC(_wrap_FXDirDialog_save), -1);
    rb_define_method(cFXDirDialog.klass, "load", VALUEFUNC(_wrap_FXDirDialog_load), -1);
    rb_define_method(cFXDirDialog.klass, "create", VALUEFUNC(_wrap_FXDirDialog_create), -1);
    rb_define_method(cFXDirDialog.klass, "detach", VALUEFUNC(_wrap_FXDirDialog_detach), -1);
    rb_define_method(cFXDirDialog.klass, "destroy", VALUEFUNC(_wrap_FXDirDialog_destroy), -1);
    rb_define_method(cFXDirDialog.klass, "resize", VALUEFUNC(_wrap_FXDirDialog_resize), -1);
    rb_define_method(cFXDirDialog.klass, "getDefaultWidth", VALUEFUNC(_wrap_FXDirDialog_getDefaultWidth), -1);
    rb_define_method(cFXDirDialog.klass, "getDefaultHeight", VALUEFUNC(_wrap_FXDirDialog_getDefaultHeight), -1);
    rb_define_method(cFXDirDialog.klass, "getWidthForHeight", VALUEFUNC(_wrap_FXDirDialog_getWidthForHeight), -1);
    rb_define_method(cFXDirDialog.klass, "getHeightForWidth", VALUEFUNC(_wrap_FXDirDialog_getHeightForWidth), -1);
    rb_define_method(cFXDirDialog.klass, "canFocus", VALUEFUNC(_wrap_FXDirDialog_canFocus), -1);
    rb_define_method(cFXDirDialog.klass, "setFocus", VALUEFUNC(_wrap_FXDirDialog_setFocus), -1);
    rb_define_method(cFXDirDialog.klass, "killFocus", VALUEFUNC(_wrap_FXDirDialog_killFocus), -1);
    rb_define_method(cFXDirDialog.klass, "setDefault", VALUEFUNC(_wrap_FXDirDialog_setDefault), -1);
    rb_define_method(cFXDirDialog.klass, "enable", VALUEFUNC(_wrap_FXDirDialog_enable), -1);
    rb_define_method(cFXDirDialog.klass, "disable", VALUEFUNC(_wrap_FXDirDialog_disable), -1);
    rb_define_method(cFXDirDialog.klass, "raiseWindow", VALUEFUNC(_wrap_FXDirDialog_raiseWindow), -1);
    rb_define_method(cFXDirDialog.klass, "lower", VALUEFUNC(_wrap_FXDirDialog_lower), -1);
    rb_define_method(cFXDirDialog.klass, "move", VALUEFUNC(_wrap_FXDirDialog_move), -1);
    rb_define_method(cFXDirDialog.klass, "position", VALUEFUNC(_wrap_FXDirDialog_position), -1);
    rb_define_method(cFXDirDialog.klass, "layout", VALUEFUNC(_wrap_FXDirDialog_layout), -1);
    rb_define_method(cFXDirDialog.klass, "recalc", VALUEFUNC(_wrap_FXDirDialog_recalc), -1);
    rb_define_method(cFXDirDialog.klass, "reparent", VALUEFUNC(_wrap_FXDirDialog_reparent), -1);
    rb_define_method(cFXDirDialog.klass, "hide", VALUEFUNC(_wrap_FXDirDialog_hide), -1);
    rb_define_method(cFXDirDialog.klass, "isComposite", VALUEFUNC(_wrap_FXDirDialog_isComposite), -1);
    rb_define_method(cFXDirDialog.klass, "contains", VALUEFUNC(_wrap_FXDirDialog_contains), -1);
    rb_define_method(cFXDirDialog.klass, "doesSaveUnder", VALUEFUNC(_wrap_FXDirDialog_doesSaveUnder), -1);
    rb_define_method(cFXDirDialog.klass, "setBackColor", VALUEFUNC(_wrap_FXDirDialog_setBackColor), -1);
    rb_define_method(cFXDirDialog.klass, "show", VALUEFUNC(_wrap_FXDirDialog_show), -1);
    rb_define_method(cFXDirDialog.klass, "maximize", VALUEFUNC(_wrap_FXDirDialog_maximize), -1);
    rb_define_method(cFXDirDialog.klass, "minimize", VALUEFUNC(_wrap_FXDirDialog_minimize), -1);
    rb_define_method(cFXDirDialog.klass, "restore", VALUEFUNC(_wrap_FXDirDialog_restore), -1);
    rb_define_method(cFXDirDialog.klass, "close", VALUEFUNC(_wrap_FXDirDialog_close), -1);
    rb_define_method(cFXDirDialog.klass, "execute", VALUEFUNC(_wrap_FXDirDialog_execute), -1);
    cFXDirDialog.mark = (void (*)(void *)) FXRbDirDialog::markfunc;
    cFXDirDialog.destroy = (void (*)(void *)) FXRbObject::freefunc;
    
    cFXFileDialog.klass = rb_define_class_under(mFox, "FXFileDialog", ((swig_class *) SWIGTYPE_p_FXDialogBox->clientdata)->klass);
    SWIG_TypeClientData(SWIGTYPE_p_FXFileDialog, (void *) &cFXFileDialog);
    rb_define_alloc_func(cFXFileDialog.klass, _wrap_FXFileDialog_allocate);
    rb_define_method(cFXFileDialog.klass, "initialize", VALUEFUNC(_wrap_new_FXFileDialog), -1);
    rb_define_method(cFXFileDialog.klass, "setFilename", VALUEFUNC(_wrap_FXFileDialog_setFilename), -1);
    rb_define_method(cFXFileDialog.klass, "getFilename", VALUEFUNC(_wrap_FXFileDialog_getFilename), -1);
    rb_define_method(cFXFileDialog.klass, "getFilenames", VALUEFUNC(_wrap_FXFileDialog_getFilenames), -1);
    rb_define_method(cFXFileDialog.klass, "setPattern", VALUEFUNC(_wrap_FXFileDialog_setPattern), -1);
    rb_define_method(cFXFileDialog.klass, "getPattern", VALUEFUNC(_wrap_FXFileDialog_getPattern), -1);
    rb_define_method(cFXFileDialog.klass, "setPatternList", VALUEFUNC(_wrap_FXFileDialog_setPatternList), -1);
    rb_define_method(cFXFileDialog.klass, "getPatternList", VALUEFUNC(_wrap_FXFileDialog_getPatternList), -1);
    rb_define_method(cFXFileDialog.klass, "setCurrentPattern", VALUEFUNC(_wrap_FXFileDialog_setCurrentPattern), -1);
    rb_define_method(cFXFileDialog.klass, "getCurrentPattern", VALUEFUNC(_wrap_FXFileDialog_getCurrentPattern), -1);
    rb_define_method(cFXFileDialog.klass, "getPatternText", VALUEFUNC(_wrap_FXFileDialog_getPatternText), -1);
    rb_define_method(cFXFileDialog.klass, "setPatternText", VALUEFUNC(_wrap_FXFileDialog_setPatternText), -1);
    rb_define_method(cFXFileDialog.klass, "setDirectory", VALUEFUNC(_wrap_FXFileDialog_setDirectory), -1);
    rb_define_method(cFXFileDialog.klass, "getDirectory", VALUEFUNC(_wrap_FXFileDialog_getDirectory), -1);
    rb_define_method(cFXFileDialog.klass, "setItemSpace", VALUEFUNC(_wrap_FXFileDialog_setItemSpace), -1);
    rb_define_method(cFXFileDialog.klass, "getItemSpace", VALUEFUNC(_wrap_FXFileDialog_getItemSpace), -1);
    rb_define_method(cFXFileDialog.klass, "setFileBoxStyle", VALUEFUNC(_wrap_FXFileDialog_setFileBoxStyle), -1);
    rb_define_method(cFXFileDialog.klass, "getFileBoxStyle", VALUEFUNC(_wrap_FXFileDialog_getFileBoxStyle), -1);
    rb_define_method(cFXFileDialog.klass, "setSelectMode", VALUEFUNC(_wrap_FXFileDialog_setSelectMode), -1);
    rb_define_method(cFXFileDialog.klass, "getSelectMode", VALUEFUNC(_wrap_FXFileDialog_getSelectMode), -1);
    rb_define_method(cFXFileDialog.klass, "setMatchMode", VALUEFUNC(_wrap_FXFileDialog_setMatchMode), -1);
    rb_define_method(cFXFileDialog.klass, "getMatchMode", VALUEFUNC(_wrap_FXFileDialog_getMatchMode), -1);
    rb_define_method(cFXFileDialog.klass, "showReadOnly", VALUEFUNC(_wrap_FXFileDialog_showReadOnly), -1);
    rb_define_method(cFXFileDialog.klass, "shownReadOnly", VALUEFUNC(_wrap_FXFileDialog_shownReadOnly), -1);
    rb_define_method(cFXFileDialog.klass, "setReadOnly", VALUEFUNC(_wrap_FXFileDialog_setReadOnly), -1);
    rb_define_method(cFXFileDialog.klass, "getReadOnly", VALUEFUNC(_wrap_FXFileDialog_getReadOnly), -1);
    rb_define_singleton_method(cFXFileDialog.klass, "getOpenFilename", VALUEFUNC(_wrap_FXFileDialog_getOpenFilename), -1);
    rb_define_singleton_method(cFXFileDialog.klass, "getOpenFilenames", VALUEFUNC(_wrap_FXFileDialog_getOpenFilenames), -1);
    rb_define_singleton_method(cFXFileDialog.klass, "getSaveFilename", VALUEFUNC(_wrap_FXFileDialog_getSaveFilename), -1);
    rb_define_singleton_method(cFXFileDialog.klass, "getOpenDirectory", VALUEFUNC(_wrap_FXFileDialog_getOpenDirectory), -1);
    rb_define_method(cFXFileDialog.klass, "save", VALUEFUNC(_wrap_FXFileDialog_save), -1);
    rb_define_method(cFXFileDialog.klass, "load", VALUEFUNC(_wrap_FXFileDialog_load), -1);
    rb_define_method(cFXFileDialog.klass, "create", VALUEFUNC(_wrap_FXFileDialog_create), -1);
    rb_define_method(cFXFileDialog.klass, "detach", VALUEFUNC(_wrap_FXFileDialog_detach), -1);
    rb_define_method(cFXFileDialog.klass, "destroy", VALUEFUNC(_wrap_FXFileDialog_destroy), -1);
    rb_define_method(cFXFileDialog.klass, "resize", VALUEFUNC(_wrap_FXFileDialog_resize), -1);
    rb_define_method(cFXFileDialog.klass, "getDefaultWidth", VALUEFUNC(_wrap_FXFileDialog_getDefaultWidth), -1);
    rb_define_method(cFXFileDialog.klass, "getDefaultHeight", VALUEFUNC(_wrap_FXFileDialog_getDefaultHeight), -1);
    rb_define_method(cFXFileDialog.klass, "getWidthForHeight", VALUEFUNC(_wrap_FXFileDialog_getWidthForHeight), -1);
    rb_define_method(cFXFileDialog.klass, "getHeightForWidth", VALUEFUNC(_wrap_FXFileDialog_getHeightForWidth), -1);
    rb_define_method(cFXFileDialog.klass, "canFocus", VALUEFUNC(_wrap_FXFileDialog_canFocus), -1);
    rb_define_method(cFXFileDialog.klass, "setFocus", VALUEFUNC(_wrap_FXFileDialog_setFocus), -1);
    rb_define_method(cFXFileDialog.klass, "killFocus", VALUEFUNC(_wrap_FXFileDialog_killFocus), -1);
    rb_define_method(cFXFileDialog.klass, "setDefault", VALUEFUNC(_wrap_FXFileDialog_setDefault), -1);
    rb_define_method(cFXFileDialog.klass, "enable", VALUEFUNC(_wrap_FXFileDialog_enable), -1);
    rb_define_method(cFXFileDialog.klass, "disable", VALUEFUNC(_wrap_FXFileDialog_disable), -1);
    rb_define_method(cFXFileDialog.klass, "raiseWindow", VALUEFUNC(_wrap_FXFileDialog_raiseWindow), -1);
    rb_define_method(cFXFileDialog.klass, "lower", VALUEFUNC(_wrap_FXFileDialog_lower), -1);
    rb_define_method(cFXFileDialog.klass, "move", VALUEFUNC(_wrap_FXFileDialog_move), -1);
    rb_define_method(cFXFileDialog.klass, "position", VALUEFUNC(_wrap_FXFileDialog_position), -1);
    rb_define_method(cFXFileDialog.klass, "layout", VALUEFUNC(_wrap_FXFileDialog_layout), -1);
    rb_define_method(cFXFileDialog.klass, "recalc", VALUEFUNC(_wrap_FXFileDialog_recalc), -1);
    rb_define_method(cFXFileDialog.klass, "reparent", VALUEFUNC(_wrap_FXFileDialog_reparent), -1);
    rb_define_method(cFXFileDialog.klass, "hide", VALUEFUNC(_wrap_FXFileDialog_hide), -1);
    rb_define_method(cFXFileDialog.klass, "isComposite", VALUEFUNC(_wrap_FXFileDialog_isComposite), -1);
    rb_define_method(cFXFileDialog.klass, "contains", VALUEFUNC(_wrap_FXFileDialog_contains), -1);
    rb_define_method(cFXFileDialog.klass, "doesSaveUnder", VALUEFUNC(_wrap_FXFileDialog_doesSaveUnder), -1);
    rb_define_method(cFXFileDialog.klass, "setBackColor", VALUEFUNC(_wrap_FXFileDialog_setBackColor), -1);
    rb_define_method(cFXFileDialog.klass, "show", VALUEFUNC(_wrap_FXFileDialog_show), -1);
    rb_define_method(cFXFileDialog.klass, "maximize", VALUEFUNC(_wrap_FXFileDialog_maximize), -1);
    rb_define_method(cFXFileDialog.klass, "minimize", VALUEFUNC(_wrap_FXFileDialog_minimize), -1);
    rb_define_method(cFXFileDialog.klass, "restore", VALUEFUNC(_wrap_FXFileDialog_restore), -1);
    rb_define_method(cFXFileDialog.klass, "close", VALUEFUNC(_wrap_FXFileDialog_close), -1);
    rb_define_method(cFXFileDialog.klass, "execute", VALUEFUNC(_wrap_FXFileDialog_execute), -1);
    cFXFileDialog.mark = (void (*)(void *)) FXRbFileDialog::markfunc;
    cFXFileDialog.destroy = (void (*)(void *)) FXRbObject::freefunc;
    
    cFXColorDialog.klass = rb_define_class_under(mFox, "FXColorDialog", ((swig_class *) SWIGTYPE_p_FXDialogBox->clientdata)->klass);
    SWIG_TypeClientData(SWIGTYPE_p_FXColorDialog, (void *) &cFXColorDialog);
    rb_define_alloc_func(cFXColorDialog.klass, _wrap_FXColorDialog_allocate);
    rb_define_method(cFXColorDialog.klass, "initialize", VALUEFUNC(_wrap_new_FXColorDialog), -1);
    rb_define_method(cFXColorDialog.klass, "onChgColor", VALUEFUNC(_wrap_FXColorDialog_onChgColor), -1);
    rb_define_method(cFXColorDialog.klass, "onCmdColor", VALUEFUNC(_wrap_FXColorDialog_onCmdColor), -1);
    rb_define_const(cFXColorDialog.klass,"ID_COLORSELECTOR", INT2NUM(FXColorDialog::ID_COLORSELECTOR));
    rb_define_const(cFXColorDialog.klass,"ID_LAST", INT2NUM(FXColorDialog::ID_LAST));
    rb_define_method(cFXColorDialog.klass, "setRGBA", VALUEFUNC(_wrap_FXColorDialog_setRGBA), -1);
    rb_define_method(cFXColorDialog.klass, "getRGBA", VALUEFUNC(_wrap_FXColorDialog_getRGBA), -1);
    rb_define_method(cFXColorDialog.klass, "isOpaqueOnly", VALUEFUNC(_wrap_FXColorDialog_isOpaqueOnly), -1);
    rb_define_method(cFXColorDialog.klass, "setOpaqueOnly", VALUEFUNC(_wrap_FXColorDialog_setOpaqueOnly), -1);
    rb_define_method(cFXColorDialog.klass, "save", VALUEFUNC(_wrap_FXColorDialog_save), -1);
    rb_define_method(cFXColorDialog.klass, "load", VALUEFUNC(_wrap_FXColorDialog_load), -1);
    rb_define_method(cFXColorDialog.klass, "create", VALUEFUNC(_wrap_FXColorDialog_create), -1);
    rb_define_method(cFXColorDialog.klass, "detach", VALUEFUNC(_wrap_FXColorDialog_detach), -1);
    rb_define_method(cFXColorDialog.klass, "destroy", VALUEFUNC(_wrap_FXColorDialog_destroy), -1);
    rb_define_method(cFXColorDialog.klass, "resize", VALUEFUNC(_wrap_FXColorDialog_resize), -1);
    rb_define_method(cFXColorDialog.klass, "getDefaultWidth", VALUEFUNC(_wrap_FXColorDialog_getDefaultWidth), -1);
    rb_define_method(cFXColorDialog.klass, "getDefaultHeight", VALUEFUNC(_wrap_FXColorDialog_getDefaultHeight), -1);
    rb_define_method(cFXColorDialog.klass, "getWidthForHeight", VALUEFUNC(_wrap_FXColorDialog_getWidthForHeight), -1);
    rb_define_method(cFXColorDialog.klass, "getHeightForWidth", VALUEFUNC(_wrap_FXColorDialog_getHeightForWidth), -1);
    rb_define_method(cFXColorDialog.klass, "canFocus", VALUEFUNC(_wrap_FXColorDialog_canFocus), -1);
    rb_define_method(cFXColorDialog.klass, "setFocus", VALUEFUNC(_wrap_FXColorDialog_setFocus), -1);
    rb_define_method(cFXColorDialog.klass, "killFocus", VALUEFUNC(_wrap_FXColorDialog_killFocus), -1);
    rb_define_method(cFXColorDialog.klass, "setDefault", VALUEFUNC(_wrap_FXColorDialog_setDefault), -1);
    rb_define_method(cFXColorDialog.klass, "enable", VALUEFUNC(_wrap_FXColorDialog_enable), -1);
    rb_define_method(cFXColorDialog.klass, "disable", VALUEFUNC(_wrap_FXColorDialog_disable), -1);
    rb_define_method(cFXColorDialog.klass, "raiseWindow", VALUEFUNC(_wrap_FXColorDialog_raiseWindow), -1);
    rb_define_method(cFXColorDialog.klass, "lower", VALUEFUNC(_wrap_FXColorDialog_lower), -1);
    rb_define_method(cFXColorDialog.klass, "move", VALUEFUNC(_wrap_FXColorDialog_move), -1);
    rb_define_method(cFXColorDialog.klass, "position", VALUEFUNC(_wrap_FXColorDialog_position), -1);
    rb_define_method(cFXColorDialog.klass, "layout", VALUEFUNC(_wrap_FXColorDialog_layout), -1);
    rb_define_method(cFXColorDialog.klass, "recalc", VALUEFUNC(_wrap_FXColorDialog_recalc), -1);
    rb_define_method(cFXColorDialog.klass, "reparent", VALUEFUNC(_wrap_FXColorDialog_reparent), -1);
    rb_define_method(cFXColorDialog.klass, "hide", VALUEFUNC(_wrap_FXColorDialog_hide), -1);
    rb_define_method(cFXColorDialog.klass, "isComposite", VALUEFUNC(_wrap_FXColorDialog_isComposite), -1);
    rb_define_method(cFXColorDialog.klass, "contains", VALUEFUNC(_wrap_FXColorDialog_contains), -1);
    rb_define_method(cFXColorDialog.klass, "doesSaveUnder", VALUEFUNC(_wrap_FXColorDialog_doesSaveUnder), -1);
    rb_define_method(cFXColorDialog.klass, "setBackColor", VALUEFUNC(_wrap_FXColorDialog_setBackColor), -1);
    rb_define_method(cFXColorDialog.klass, "show", VALUEFUNC(_wrap_FXColorDialog_show), -1);
    rb_define_method(cFXColorDialog.klass, "maximize", VALUEFUNC(_wrap_FXColorDialog_maximize), -1);
    rb_define_method(cFXColorDialog.klass, "minimize", VALUEFUNC(_wrap_FXColorDialog_minimize), -1);
    rb_define_method(cFXColorDialog.klass, "restore", VALUEFUNC(_wrap_FXColorDialog_restore), -1);
    rb_define_method(cFXColorDialog.klass, "close", VALUEFUNC(_wrap_FXColorDialog_close), -1);
    rb_define_method(cFXColorDialog.klass, "execute", VALUEFUNC(_wrap_FXColorDialog_execute), -1);
    cFXColorDialog.mark = (void (*)(void *)) FXRbColorDialog::markfunc;
    cFXColorDialog.destroy = (void (*)(void *)) FXRbObject::freefunc;
    
    cFXFontDialog.klass = rb_define_class_under(mFox, "FXFontDialog", ((swig_class *) SWIGTYPE_p_FXDialogBox->clientdata)->klass);
    SWIG_TypeClientData(SWIGTYPE_p_FXFontDialog, (void *) &cFXFontDialog);
    rb_define_alloc_func(cFXFontDialog.klass, _wrap_FXFontDialog_allocate);
    rb_define_method(cFXFontDialog.klass, "initialize", VALUEFUNC(_wrap_new_FXFontDialog), -1);
    rb_define_method(cFXFontDialog.klass, "setFontSelection", VALUEFUNC(_wrap_FXFontDialog_setFontSelection), -1);
    rb_define_method(cFXFontDialog.klass, "getFontSelection", VALUEFUNC(_wrap_FXFontDialog_getFontSelection), -1);
    rb_define_method(cFXFontDialog.klass, "save", VALUEFUNC(_wrap_FXFontDialog_save), -1);
    rb_define_method(cFXFontDialog.klass, "load", VALUEFUNC(_wrap_FXFontDialog_load), -1);
    rb_define_method(cFXFontDialog.klass, "create", VALUEFUNC(_wrap_FXFontDialog_create), -1);
    rb_define_method(cFXFontDialog.klass, "detach", VALUEFUNC(_wrap_FXFontDialog_detach), -1);
    rb_define_method(cFXFontDialog.klass, "destroy", VALUEFUNC(_wrap_FXFontDialog_destroy), -1);
    rb_define_method(cFXFontDialog.klass, "resize", VALUEFUNC(_wrap_FXFontDialog_resize), -1);
    rb_define_method(cFXFontDialog.klass, "getDefaultWidth", VALUEFUNC(_wrap_FXFontDialog_getDefaultWidth), -1);
    rb_define_method(cFXFontDialog.klass, "getDefaultHeight", VALUEFUNC(_wrap_FXFontDialog_getDefaultHeight), -1);
    rb_define_method(cFXFontDialog.klass, "getWidthForHeight", VALUEFUNC(_wrap_FXFontDialog_getWidthForHeight), -1);
    rb_define_method(cFXFontDialog.klass, "getHeightForWidth", VALUEFUNC(_wrap_FXFontDialog_getHeightForWidth), -1);
    rb_define_method(cFXFontDialog.klass, "canFocus", VALUEFUNC(_wrap_FXFontDialog_canFocus), -1);
    rb_define_method(cFXFontDialog.klass, "setFocus", VALUEFUNC(_wrap_FXFontDialog_setFocus), -1);
    rb_define_method(cFXFontDialog.klass, "killFocus", VALUEFUNC(_wrap_FXFontDialog_killFocus), -1);
    rb_define_method(cFXFontDialog.klass, "setDefault", VALUEFUNC(_wrap_FXFontDialog_setDefault), -1);
    rb_define_method(cFXFontDialog.klass, "enable", VALUEFUNC(_wrap_FXFontDialog_enable), -1);
    rb_define_method(cFXFontDialog.klass, "disable", VALUEFUNC(_wrap_FXFontDialog_disable), -1);
    rb_define_method(cFXFontDialog.klass, "raiseWindow", VALUEFUNC(_wrap_FXFontDialog_raiseWindow), -1);
    rb_define_method(cFXFontDialog.klass, "lower", VALUEFUNC(_wrap_FXFontDialog_lower), -1);
    rb_define_method(cFXFontDialog.klass, "move", VALUEFUNC(_wrap_FXFontDialog_move), -1);
    rb_define_method(cFXFontDialog.klass, "position", VALUEFUNC(_wrap_FXFontDialog_position), -1);
    rb_define_method(cFXFontDialog.klass, "layout", VALUEFUNC(_wrap_FXFontDialog_layout), -1);
    rb_define_method(cFXFontDialog.klass, "recalc", VALUEFUNC(_wrap_FXFontDialog_recalc), -1);
    rb_define_method(cFXFontDialog.klass, "reparent", VALUEFUNC(_wrap_FXFontDialog_reparent), -1);
    rb_define_method(cFXFontDialog.klass, "hide", VALUEFUNC(_wrap_FXFontDialog_hide), -1);
    rb_define_method(cFXFontDialog.klass, "isComposite", VALUEFUNC(_wrap_FXFontDialog_isComposite), -1);
    rb_define_method(cFXFontDialog.klass, "contains", VALUEFUNC(_wrap_FXFontDialog_contains), -1);
    rb_define_method(cFXFontDialog.klass, "doesSaveUnder", VALUEFUNC(_wrap_FXFontDialog_doesSaveUnder), -1);
    rb_define_method(cFXFontDialog.klass, "setBackColor", VALUEFUNC(_wrap_FXFontDialog_setBackColor), -1);
    rb_define_method(cFXFontDialog.klass, "show", VALUEFUNC(_wrap_FXFontDialog_show), -1);
    rb_define_method(cFXFontDialog.klass, "maximize", VALUEFUNC(_wrap_FXFontDialog_maximize), -1);
    rb_define_method(cFXFontDialog.klass, "minimize", VALUEFUNC(_wrap_FXFontDialog_minimize), -1);
    rb_define_method(cFXFontDialog.klass, "restore", VALUEFUNC(_wrap_FXFontDialog_restore), -1);
    rb_define_method(cFXFontDialog.klass, "close", VALUEFUNC(_wrap_FXFontDialog_close), -1);
    rb_define_method(cFXFontDialog.klass, "execute", VALUEFUNC(_wrap_FXFontDialog_execute), -1);
    cFXFontDialog.mark = (void (*)(void *)) FXRbFontDialog::markfunc;
    cFXFontDialog.destroy = (void (*)(void *)) FXRbObject::freefunc;
    
    cFXReplaceDialog.klass = rb_define_class_under(mFox, "FXReplaceDialog", ((swig_class *) SWIGTYPE_p_FXDialogBox->clientdata)->klass);
    SWIG_TypeClientData(SWIGTYPE_p_FXReplaceDialog, (void *) &cFXReplaceDialog);
    rb_define_alloc_func(cFXReplaceDialog.klass, _wrap_FXReplaceDialog_allocate);
    rb_define_method(cFXReplaceDialog.klass, "initialize", VALUEFUNC(_wrap_new_FXReplaceDialog), -1);
    rb_define_method(cFXReplaceDialog.klass, "onCmdAll", VALUEFUNC(_wrap_FXReplaceDialog_onCmdAll), -1);
    rb_define_method(cFXReplaceDialog.klass, "onCmdNext", VALUEFUNC(_wrap_FXReplaceDialog_onCmdNext), -1);
    rb_define_method(cFXReplaceDialog.klass, "onUpdDir", VALUEFUNC(_wrap_FXReplaceDialog_onUpdDir), -1);
    rb_define_method(cFXReplaceDialog.klass, "onCmdDir", VALUEFUNC(_wrap_FXReplaceDialog_onCmdDir), -1);
    rb_define_method(cFXReplaceDialog.klass, "onUpdMode", VALUEFUNC(_wrap_FXReplaceDialog_onUpdMode), -1);
    rb_define_method(cFXReplaceDialog.klass, "onCmdMode", VALUEFUNC(_wrap_FXReplaceDialog_onCmdMode), -1);
    rb_define_method(cFXReplaceDialog.klass, "onSearchKey", VALUEFUNC(_wrap_FXReplaceDialog_onSearchKey), -1);
    rb_define_method(cFXReplaceDialog.klass, "onReplaceKey", VALUEFUNC(_wrap_FXReplaceDialog_onReplaceKey), -1);
    rb_define_method(cFXReplaceDialog.klass, "onCmdSearchHist", VALUEFUNC(_wrap_FXReplaceDialog_onCmdSearchHist), -1);
    rb_define_method(cFXReplaceDialog.klass, "onCmdReplaceHist", VALUEFUNC(_wrap_FXReplaceDialog_onCmdReplaceHist), -1);
    rb_define_method(cFXReplaceDialog.klass, "onCmdAccept", VALUEFUNC(_wrap_FXReplaceDialog_onCmdAccept), -1);
    rb_define_const(cFXReplaceDialog.klass,"ID_NEXT", INT2NUM(FXReplaceDialog::ID_NEXT));
    rb_define_const(cFXReplaceDialog.klass,"ID_PREV", INT2NUM(FXReplaceDialog::ID_PREV));
    rb_define_const(cFXReplaceDialog.klass,"ID_SEARCH_UP", INT2NUM(FXReplaceDialog::ID_SEARCH_UP));
    rb_define_const(cFXReplaceDialog.klass,"ID_SEARCH_DN", INT2NUM(FXReplaceDialog::ID_SEARCH_DN));
    rb_define_const(cFXReplaceDialog.klass,"ID_REPLACE_UP", INT2NUM(FXReplaceDialog::ID_REPLACE_UP));
    rb_define_const(cFXReplaceDialog.klass,"ID_REPLACE_DN", INT2NUM(FXReplaceDialog::ID_REPLACE_DN));
    rb_define_const(cFXReplaceDialog.klass,"ID_ALL", INT2NUM(FXReplaceDialog::ID_ALL));
    rb_define_const(cFXReplaceDialog.klass,"ID_DIR", INT2NUM(FXReplaceDialog::ID_DIR));
    rb_define_const(cFXReplaceDialog.klass,"ID_SEARCH_TEXT", INT2NUM(FXReplaceDialog::ID_SEARCH_TEXT));
    rb_define_const(cFXReplaceDialog.klass,"ID_REPLACE_TEXT", INT2NUM(FXReplaceDialog::ID_REPLACE_TEXT));
    rb_define_const(cFXReplaceDialog.klass,"ID_MODE", INT2NUM(FXReplaceDialog::ID_MODE));
    rb_define_const(cFXReplaceDialog.klass,"ID_LAST", INT2NUM(FXReplaceDialog::ID_LAST));
    rb_define_const(cFXReplaceDialog.klass,"DONE", INT2NUM(FXReplaceDialog::DONE));
    rb_define_const(cFXReplaceDialog.klass,"SEARCH", INT2NUM(FXReplaceDialog::SEARCH));
    rb_define_const(cFXReplaceDialog.klass,"REPLACE", INT2NUM(FXReplaceDialog::REPLACE));
    rb_define_const(cFXReplaceDialog.klass,"SEARCH_NEXT", INT2NUM(FXReplaceDialog::SEARCH_NEXT));
    rb_define_const(cFXReplaceDialog.klass,"REPLACE_NEXT", INT2NUM(FXReplaceDialog::REPLACE_NEXT));
    rb_define_const(cFXReplaceDialog.klass,"REPLACE_ALL", INT2NUM(FXReplaceDialog::REPLACE_ALL));
    rb_define_method(cFXReplaceDialog.klass, "setSearchText", VALUEFUNC(_wrap_FXReplaceDialog_setSearchText), -1);
    rb_define_method(cFXReplaceDialog.klass, "getSearchText", VALUEFUNC(_wrap_FXReplaceDialog_getSearchText), -1);
    rb_define_method(cFXReplaceDialog.klass, "setReplaceText", VALUEFUNC(_wrap_FXReplaceDialog_setReplaceText), -1);
    rb_define_method(cFXReplaceDialog.klass, "getReplaceText", VALUEFUNC(_wrap_FXReplaceDialog_getReplaceText), -1);
    rb_define_method(cFXReplaceDialog.klass, "setSearchMode", VALUEFUNC(_wrap_FXReplaceDialog_setSearchMode), -1);
    rb_define_method(cFXReplaceDialog.klass, "getSearchMode", VALUEFUNC(_wrap_FXReplaceDialog_getSearchMode), -1);
    rb_define_method(cFXReplaceDialog.klass, "save", VALUEFUNC(_wrap_FXReplaceDialog_save), -1);
    rb_define_method(cFXReplaceDialog.klass, "load", VALUEFUNC(_wrap_FXReplaceDialog_load), -1);
    rb_define_method(cFXReplaceDialog.klass, "create", VALUEFUNC(_wrap_FXReplaceDialog_create), -1);
    rb_define_method(cFXReplaceDialog.klass, "detach", VALUEFUNC(_wrap_FXReplaceDialog_detach), -1);
    rb_define_method(cFXReplaceDialog.klass, "destroy", VALUEFUNC(_wrap_FXReplaceDialog_destroy), -1);
    rb_define_method(cFXReplaceDialog.klass, "resize", VALUEFUNC(_wrap_FXReplaceDialog_resize), -1);
    rb_define_method(cFXReplaceDialog.klass, "getDefaultWidth", VALUEFUNC(_wrap_FXReplaceDialog_getDefaultWidth), -1);
    rb_define_method(cFXReplaceDialog.klass, "getDefaultHeight", VALUEFUNC(_wrap_FXReplaceDialog_getDefaultHeight), -1);
    rb_define_method(cFXReplaceDialog.klass, "getWidthForHeight", VALUEFUNC(_wrap_FXReplaceDialog_getWidthForHeight), -1);
    rb_define_method(cFXReplaceDialog.klass, "getHeightForWidth", VALUEFUNC(_wrap_FXReplaceDialog_getHeightForWidth), -1);
    rb_define_method(cFXReplaceDialog.klass, "canFocus", VALUEFUNC(_wrap_FXReplaceDialog_canFocus), -1);
    rb_define_method(cFXReplaceDialog.klass, "setFocus", VALUEFUNC(_wrap_FXReplaceDialog_setFocus), -1);
    rb_define_method(cFXReplaceDialog.klass, "killFocus", VALUEFUNC(_wrap_FXReplaceDialog_killFocus), -1);
    rb_define_method(cFXReplaceDialog.klass, "setDefault", VALUEFUNC(_wrap_FXReplaceDialog_setDefault), -1);
    rb_define_method(cFXReplaceDialog.klass, "enable", VALUEFUNC(_wrap_FXReplaceDialog_enable), -1);
    rb_define_method(cFXReplaceDialog.klass, "disable", VALUEFUNC(_wrap_FXReplaceDialog_disable), -1);
    rb_define_method(cFXReplaceDialog.klass, "raiseWindow", VALUEFUNC(_wrap_FXReplaceDialog_raiseWindow), -1);
    rb_define_method(cFXReplaceDialog.klass, "lower", VALUEFUNC(_wrap_FXReplaceDialog_lower), -1);
    rb_define_method(cFXReplaceDialog.klass, "move", VALUEFUNC(_wrap_FXReplaceDialog_move), -1);
    rb_define_method(cFXReplaceDialog.klass, "position", VALUEFUNC(_wrap_FXReplaceDialog_position), -1);
    rb_define_method(cFXReplaceDialog.klass, "layout", VALUEFUNC(_wrap_FXReplaceDialog_layout), -1);
    rb_define_method(cFXReplaceDialog.klass, "recalc", VALUEFUNC(_wrap_FXReplaceDialog_recalc), -1);
    rb_define_method(cFXReplaceDialog.klass, "reparent", VALUEFUNC(_wrap_FXReplaceDialog_reparent), -1);
    rb_define_method(cFXReplaceDialog.klass, "hide", VALUEFUNC(_wrap_FXReplaceDialog_hide), -1);
    rb_define_method(cFXReplaceDialog.klass, "isComposite", VALUEFUNC(_wrap_FXReplaceDialog_isComposite), -1);
    rb_define_method(cFXReplaceDialog.klass, "contains", VALUEFUNC(_wrap_FXReplaceDialog_contains), -1);
    rb_define_method(cFXReplaceDialog.klass, "doesSaveUnder", VALUEFUNC(_wrap_FXReplaceDialog_doesSaveUnder), -1);
    rb_define_method(cFXReplaceDialog.klass, "setBackColor", VALUEFUNC(_wrap_FXReplaceDialog_setBackColor), -1);
    rb_define_method(cFXReplaceDialog.klass, "show", VALUEFUNC(_wrap_FXReplaceDialog_show), -1);
    rb_define_method(cFXReplaceDialog.klass, "maximize", VALUEFUNC(_wrap_FXReplaceDialog_maximize), -1);
    rb_define_method(cFXReplaceDialog.klass, "minimize", VALUEFUNC(_wrap_FXReplaceDialog_minimize), -1);
    rb_define_method(cFXReplaceDialog.klass, "restore", VALUEFUNC(_wrap_FXReplaceDialog_restore), -1);
    rb_define_method(cFXReplaceDialog.klass, "close", VALUEFUNC(_wrap_FXReplaceDialog_close), -1);
    rb_define_method(cFXReplaceDialog.klass, "execute", VALUEFUNC(_wrap_FXReplaceDialog_execute), -1);
    cFXReplaceDialog.mark = (void (*)(void *)) FXRbReplaceDialog::markfunc;
    cFXReplaceDialog.destroy = (void (*)(void *)) FXRbObject::freefunc;
    
    SWIGTYPE_p_FXReplaceDialog->dcast = (swig_dycast_func) FXReplaceDialog_dynamic_cast;
    
    
    cFXSearchDialog.klass = rb_define_class_under(mFox, "FXSearchDialog", ((swig_class *) SWIGTYPE_p_FXReplaceDialog->clientdata)->klass);
    SWIG_TypeClientData(SWIGTYPE_p_FXSearchDialog, (void *) &cFXSearchDialog);
    rb_define_alloc_func(cFXSearchDialog.klass, _wrap_FXSearchDialog_allocate);
    rb_define_method(cFXSearchDialog.klass, "initialize", VALUEFUNC(_wrap_new_FXSearchDialog), -1);
    rb_define_method(cFXSearchDialog.klass, "save", VALUEFUNC(_wrap_FXSearchDialog_save), -1);
    rb_define_method(cFXSearchDialog.klass, "load", VALUEFUNC(_wrap_FXSearchDialog_load), -1);
    rb_define_method(cFXSearchDialog.klass, "create", VALUEFUNC(_wrap_FXSearchDialog_create), -1);
    rb_define_method(cFXSearchDialog.klass, "detach", VALUEFUNC(_wrap_FXSearchDialog_detach), -1);
    rb_define_method(cFXSearchDialog.klass, "destroy", VALUEFUNC(_wrap_FXSearchDialog_destroy), -1);
    rb_define_method(cFXSearchDialog.klass, "resize", VALUEFUNC(_wrap_FXSearchDialog_resize), -1);
    rb_define_method(cFXSearchDialog.klass, "getDefaultWidth", VALUEFUNC(_wrap_FXSearchDialog_getDefaultWidth), -1);
    rb_define_method(cFXSearchDialog.klass, "getDefaultHeight", VALUEFUNC(_wrap_FXSearchDialog_getDefaultHeight), -1);
    rb_define_method(cFXSearchDialog.klass, "getWidthForHeight", VALUEFUNC(_wrap_FXSearchDialog_getWidthForHeight), -1);
    rb_define_method(cFXSearchDialog.klass, "getHeightForWidth", VALUEFUNC(_wrap_FXSearchDialog_getHeightForWidth), -1);
    rb_define_method(cFXSearchDialog.klass, "canFocus", VALUEFUNC(_wrap_FXSearchDialog_canFocus), -1);
    rb_define_method(cFXSearchDialog.klass, "setFocus", VALUEFUNC(_wrap_FXSearchDialog_setFocus), -1);
    rb_define_method(cFXSearchDialog.klass, "killFocus", VALUEFUNC(_wrap_FXSearchDialog_killFocus), -1);
    rb_define_method(cFXSearchDialog.klass, "setDefault", VALUEFUNC(_wrap_FXSearchDialog_setDefault), -1);
    rb_define_method(cFXSearchDialog.klass, "enable", VALUEFUNC(_wrap_FXSearchDialog_enable), -1);
    rb_define_method(cFXSearchDialog.klass, "disable", VALUEFUNC(_wrap_FXSearchDialog_disable), -1);
    rb_define_method(cFXSearchDialog.klass, "raiseWindow", VALUEFUNC(_wrap_FXSearchDialog_raiseWindow), -1);
    rb_define_method(cFXSearchDialog.klass, "lower", VALUEFUNC(_wrap_FXSearchDialog_lower), -1);
    rb_define_method(cFXSearchDialog.klass, "move", VALUEFUNC(_wrap_FXSearchDialog_move), -1);
    rb_define_method(cFXSearchDialog.klass, "position", VALUEFUNC(_wrap_FXSearchDialog_position), -1);
    rb_define_method(cFXSearchDialog.klass, "layout", VALUEFUNC(_wrap_FXSearchDialog_layout), -1);
    rb_define_method(cFXSearchDialog.klass, "recalc", VALUEFUNC(_wrap_FXSearchDialog_recalc), -1);
    rb_define_method(cFXSearchDialog.klass, "reparent", VALUEFUNC(_wrap_FXSearchDialog_reparent), -1);
    rb_define_method(cFXSearchDialog.klass, "hide", VALUEFUNC(_wrap_FXSearchDialog_hide), -1);
    rb_define_method(cFXSearchDialog.klass, "isComposite", VALUEFUNC(_wrap_FXSearchDialog_isComposite), -1);
    rb_define_method(cFXSearchDialog.klass, "contains", VALUEFUNC(_wrap_FXSearchDialog_contains), -1);
    rb_define_method(cFXSearchDialog.klass, "doesSaveUnder", VALUEFUNC(_wrap_FXSearchDialog_doesSaveUnder), -1);
    rb_define_method(cFXSearchDialog.klass, "setBackColor", VALUEFUNC(_wrap_FXSearchDialog_setBackColor), -1);
    rb_define_method(cFXSearchDialog.klass, "show", VALUEFUNC(_wrap_FXSearchDialog_show), -1);
    rb_define_method(cFXSearchDialog.klass, "maximize", VALUEFUNC(_wrap_FXSearchDialog_maximize), -1);
    rb_define_method(cFXSearchDialog.klass, "minimize", VALUEFUNC(_wrap_FXSearchDialog_minimize), -1);
    rb_define_method(cFXSearchDialog.klass, "restore", VALUEFUNC(_wrap_FXSearchDialog_restore), -1);
    rb_define_method(cFXSearchDialog.klass, "close", VALUEFUNC(_wrap_FXSearchDialog_close), -1);
    rb_define_method(cFXSearchDialog.klass, "execute", VALUEFUNC(_wrap_FXSearchDialog_execute), -1);
    cFXSearchDialog.mark = (void (*)(void *)) FXRbSearchDialog::markfunc;
    cFXSearchDialog.destroy = (void (*)(void *)) FXRbObject::freefunc;
    rb_define_const(mFox,"INPUTDIALOG_STRING", INT2NUM(INPUTDIALOG_STRING));
    rb_define_const(mFox,"INPUTDIALOG_INTEGER", INT2NUM(INPUTDIALOG_INTEGER));
    rb_define_const(mFox,"INPUTDIALOG_REAL", INT2NUM(INPUTDIALOG_REAL));
    rb_define_const(mFox,"INPUTDIALOG_PASSWORD", INT2NUM(INPUTDIALOG_PASSWORD));
    
    cFXInputDialog.klass = rb_define_class_under(mFox, "FXInputDialog", ((swig_class *) SWIGTYPE_p_FXDialogBox->clientdata)->klass);
    SWIG_TypeClientData(SWIGTYPE_p_FXInputDialog, (void *) &cFXInputDialog);
    rb_define_alloc_func(cFXInputDialog.klass, _wrap_FXInputDialog_allocate);
    rb_define_method(cFXInputDialog.klass, "initialize", VALUEFUNC(_wrap_new_FXInputDialog), -1);
    rb_define_method(cFXInputDialog.klass, "onCmdAccept", VALUEFUNC(_wrap_FXInputDialog_onCmdAccept), -1);
    rb_define_method(cFXInputDialog.klass, "getText", VALUEFUNC(_wrap_FXInputDialog_getText), -1);
    rb_define_method(cFXInputDialog.klass, "setText", VALUEFUNC(_wrap_FXInputDialog_setText), -1);
    rb_define_method(cFXInputDialog.klass, "setNumColumns", VALUEFUNC(_wrap_FXInputDialog_setNumColumns), -1);
    rb_define_method(cFXInputDialog.klass, "getNumColumns", VALUEFUNC(_wrap_FXInputDialog_getNumColumns), -1);
    rb_define_method(cFXInputDialog.klass, "setLimits", VALUEFUNC(_wrap_FXInputDialog_setLimits), -1);
    rb_define_method(cFXInputDialog.klass, "getLimits", VALUEFUNC(_wrap_FXInputDialog_getLimits), -1);
    rb_define_singleton_method(cFXInputDialog.klass, "getString", VALUEFUNC(_wrap_FXInputDialog_getString), -1);
    rb_define_singleton_method(cFXInputDialog.klass, "getInteger", VALUEFUNC(_wrap_FXInputDialog_getInteger), -1);
    rb_define_singleton_method(cFXInputDialog.klass, "getReal", VALUEFUNC(_wrap_FXInputDialog_getReal), -1);
    rb_define_method(cFXInputDialog.klass, "save", VALUEFUNC(_wrap_FXInputDialog_save), -1);
    rb_define_method(cFXInputDialog.klass, "load", VALUEFUNC(_wrap_FXInputDialog_load), -1);
    rb_define_method(cFXInputDialog.klass, "create", VALUEFUNC(_wrap_FXInputDialog_create), -1);
    rb_define_method(cFXInputDialog.klass, "detach", VALUEFUNC(_wrap_FXInputDialog_detach), -1);
    rb_define_method(cFXInputDialog.klass, "destroy", VALUEFUNC(_wrap_FXInputDialog_destroy), -1);
    rb_define_method(cFXInputDialog.klass, "resize", VALUEFUNC(_wrap_FXInputDialog_resize), -1);
    rb_define_method(cFXInputDialog.klass, "getDefaultWidth", VALUEFUNC(_wrap_FXInputDialog_getDefaultWidth), -1);
    rb_define_method(cFXInputDialog.klass, "getDefaultHeight", VALUEFUNC(_wrap_FXInputDialog_getDefaultHeight), -1);
    rb_define_method(cFXInputDialog.klass, "getWidthForHeight", VALUEFUNC(_wrap_FXInputDialog_getWidthForHeight), -1);
    rb_define_method(cFXInputDialog.klass, "getHeightForWidth", VALUEFUNC(_wrap_FXInputDialog_getHeightForWidth), -1);
    rb_define_method(cFXInputDialog.klass, "canFocus", VALUEFUNC(_wrap_FXInputDialog_canFocus), -1);
    rb_define_method(cFXInputDialog.klass, "setFocus", VALUEFUNC(_wrap_FXInputDialog_setFocus), -1);
    rb_define_method(cFXInputDialog.klass, "killFocus", VALUEFUNC(_wrap_FXInputDialog_killFocus), -1);
    rb_define_method(cFXInputDialog.klass, "setDefault", VALUEFUNC(_wrap_FXInputDialog_setDefault), -1);
    rb_define_method(cFXInputDialog.klass, "enable", VALUEFUNC(_wrap_FXInputDialog_enable), -1);
    rb_define_method(cFXInputDialog.klass, "disable", VALUEFUNC(_wrap_FXInputDialog_disable), -1);
    rb_define_method(cFXInputDialog.klass, "raiseWindow", VALUEFUNC(_wrap_FXInputDialog_raiseWindow), -1);
    rb_define_method(cFXInputDialog.klass, "lower", VALUEFUNC(_wrap_FXInputDialog_lower), -1);
    rb_define_method(cFXInputDialog.klass, "move", VALUEFUNC(_wrap_FXInputDialog_move), -1);
    rb_define_method(cFXInputDialog.klass, "position", VALUEFUNC(_wrap_FXInputDialog_position), -1);
    rb_define_method(cFXInputDialog.klass, "layout", VALUEFUNC(_wrap_FXInputDialog_layout), -1);
    rb_define_method(cFXInputDialog.klass, "recalc", VALUEFUNC(_wrap_FXInputDialog_recalc), -1);
    rb_define_method(cFXInputDialog.klass, "reparent", VALUEFUNC(_wrap_FXInputDialog_reparent), -1);
    rb_define_method(cFXInputDialog.klass, "hide", VALUEFUNC(_wrap_FXInputDialog_hide), -1);
    rb_define_method(cFXInputDialog.klass, "isComposite", VALUEFUNC(_wrap_FXInputDialog_isComposite), -1);
    rb_define_method(cFXInputDialog.klass, "contains", VALUEFUNC(_wrap_FXInputDialog_contains), -1);
    rb_define_method(cFXInputDialog.klass, "doesSaveUnder", VALUEFUNC(_wrap_FXInputDialog_doesSaveUnder), -1);
    rb_define_method(cFXInputDialog.klass, "setBackColor", VALUEFUNC(_wrap_FXInputDialog_setBackColor), -1);
    rb_define_method(cFXInputDialog.klass, "show", VALUEFUNC(_wrap_FXInputDialog_show), -1);
    rb_define_method(cFXInputDialog.klass, "maximize", VALUEFUNC(_wrap_FXInputDialog_maximize), -1);
    rb_define_method(cFXInputDialog.klass, "minimize", VALUEFUNC(_wrap_FXInputDialog_minimize), -1);
    rb_define_method(cFXInputDialog.klass, "restore", VALUEFUNC(_wrap_FXInputDialog_restore), -1);
    rb_define_method(cFXInputDialog.klass, "close", VALUEFUNC(_wrap_FXInputDialog_close), -1);
    rb_define_method(cFXInputDialog.klass, "execute", VALUEFUNC(_wrap_FXInputDialog_execute), -1);
    cFXInputDialog.mark = (void (*)(void *)) FXRbInputDialog::markfunc;
    cFXInputDialog.destroy = (void (*)(void *)) FXRbObject::freefunc;
    
    cFXPrintDialog.klass = rb_define_class_under(mFox, "FXPrintDialog", ((swig_class *) SWIGTYPE_p_FXDialogBox->clientdata)->klass);
    SWIG_TypeClientData(SWIGTYPE_p_FXPrintDialog, (void *) &cFXPrintDialog);
    rb_define_alloc_func(cFXPrintDialog.klass, _wrap_FXPrintDialog_allocate);
    rb_define_method(cFXPrintDialog.klass, "initialize", VALUEFUNC(_wrap_new_FXPrintDialog), -1);
    rb_define_method(cFXPrintDialog.klass, "onCmdToPrinter", VALUEFUNC(_wrap_FXPrintDialog_onCmdToPrinter), -1);
    rb_define_method(cFXPrintDialog.klass, "onUpdToPrinter", VALUEFUNC(_wrap_FXPrintDialog_onUpdToPrinter), -1);
    rb_define_method(cFXPrintDialog.klass, "onCmdToFile", VALUEFUNC(_wrap_FXPrintDialog_onCmdToFile), -1);
    rb_define_method(cFXPrintDialog.klass, "onUpdToFile", VALUEFUNC(_wrap_FXPrintDialog_onUpdToFile), -1);
    rb_define_method(cFXPrintDialog.klass, "onCmdBrowse", VALUEFUNC(_wrap_FXPrintDialog_onCmdBrowse), -1);
    rb_define_method(cFXPrintDialog.klass, "onUpdBrowse", VALUEFUNC(_wrap_FXPrintDialog_onUpdBrowse), -1);
    rb_define_method(cFXPrintDialog.klass, "onCmdProps", VALUEFUNC(_wrap_FXPrintDialog_onCmdProps), -1);
    rb_define_method(cFXPrintDialog.klass, "onUpdProps", VALUEFUNC(_wrap_FXPrintDialog_onUpdProps), -1);
    rb_define_method(cFXPrintDialog.klass, "onCmdPortrait", VALUEFUNC(_wrap_FXPrintDialog_onCmdPortrait), -1);
    rb_define_method(cFXPrintDialog.klass, "onUpdPortrait", VALUEFUNC(_wrap_FXPrintDialog_onUpdPortrait), -1);
    rb_define_method(cFXPrintDialog.klass, "onCmdLandscape", VALUEFUNC(_wrap_FXPrintDialog_onCmdLandscape), -1);
    rb_define_method(cFXPrintDialog.klass, "onUpdLandscape", VALUEFUNC(_wrap_FXPrintDialog_onUpdLandscape), -1);
    rb_define_method(cFXPrintDialog.klass, "onCmdPages", VALUEFUNC(_wrap_FXPrintDialog_onCmdPages), -1);
    rb_define_method(cFXPrintDialog.klass, "onUpdPages", VALUEFUNC(_wrap_FXPrintDialog_onUpdPages), -1);
    rb_define_method(cFXPrintDialog.klass, "onCmdColor", VALUEFUNC(_wrap_FXPrintDialog_onCmdColor), -1);
    rb_define_method(cFXPrintDialog.klass, "onUpdColor", VALUEFUNC(_wrap_FXPrintDialog_onUpdColor), -1);
    rb_define_method(cFXPrintDialog.klass, "onCmdGray", VALUEFUNC(_wrap_FXPrintDialog_onCmdGray), -1);
    rb_define_method(cFXPrintDialog.klass, "onUpdGray", VALUEFUNC(_wrap_FXPrintDialog_onUpdGray), -1);
    rb_define_method(cFXPrintDialog.klass, "onCmdNumCopies", VALUEFUNC(_wrap_FXPrintDialog_onCmdNumCopies), -1);
    rb_define_method(cFXPrintDialog.klass, "onUpdNumCopies", VALUEFUNC(_wrap_FXPrintDialog_onUpdNumCopies), -1);
    rb_define_method(cFXPrintDialog.klass, "onCmdFirstPage", VALUEFUNC(_wrap_FXPrintDialog_onCmdFirstPage), -1);
    rb_define_method(cFXPrintDialog.klass, "onUpdFirstPage", VALUEFUNC(_wrap_FXPrintDialog_onUpdFirstPage), -1);
    rb_define_method(cFXPrintDialog.klass, "onCmdLastPage", VALUEFUNC(_wrap_FXPrintDialog_onCmdLastPage), -1);
    rb_define_method(cFXPrintDialog.klass, "onUpdLastPage", VALUEFUNC(_wrap_FXPrintDialog_onUpdLastPage), -1);
    rb_define_method(cFXPrintDialog.klass, "onCmdCollateNormal", VALUEFUNC(_wrap_FXPrintDialog_onCmdCollateNormal), -1);
    rb_define_method(cFXPrintDialog.klass, "onUpdCollateNormal", VALUEFUNC(_wrap_FXPrintDialog_onUpdCollateNormal), -1);
    rb_define_method(cFXPrintDialog.klass, "onCmdCollateReversed", VALUEFUNC(_wrap_FXPrintDialog_onCmdCollateReversed), -1);
    rb_define_method(cFXPrintDialog.klass, "onUpdCollateReversed", VALUEFUNC(_wrap_FXPrintDialog_onUpdCollateReversed), -1);
    rb_define_method(cFXPrintDialog.klass, "onCmdFileName", VALUEFUNC(_wrap_FXPrintDialog_onCmdFileName), -1);
    rb_define_method(cFXPrintDialog.klass, "onUpdFileName", VALUEFUNC(_wrap_FXPrintDialog_onUpdFileName), -1);
    rb_define_method(cFXPrintDialog.klass, "onCmdPrinterName", VALUEFUNC(_wrap_FXPrintDialog_onCmdPrinterName), -1);
    rb_define_method(cFXPrintDialog.klass, "onUpdPrinterName", VALUEFUNC(_wrap_FXPrintDialog_onUpdPrinterName), -1);
    rb_define_method(cFXPrintDialog.klass, "onCmdAccept", VALUEFUNC(_wrap_FXPrintDialog_onCmdAccept), -1);
    rb_define_method(cFXPrintDialog.klass, "onCmdMedia", VALUEFUNC(_wrap_FXPrintDialog_onCmdMedia), -1);
    rb_define_method(cFXPrintDialog.klass, "onUpdMedia", VALUEFUNC(_wrap_FXPrintDialog_onUpdMedia), -1);
    rb_define_const(cFXPrintDialog.klass,"ID_TO_PRINTER", INT2NUM(FXPrintDialog::ID_TO_PRINTER));
    rb_define_const(cFXPrintDialog.klass,"ID_TO_FILE", INT2NUM(FXPrintDialog::ID_TO_FILE));
    rb_define_const(cFXPrintDialog.klass,"ID_PRINTER_NAME", INT2NUM(FXPrintDialog::ID_PRINTER_NAME));
    rb_define_const(cFXPrintDialog.klass,"ID_FILE_NAME", INT2NUM(FXPrintDialog::ID_FILE_NAME));
    rb_define_const(cFXPrintDialog.klass,"ID_LANDSCAPE", INT2NUM(FXPrintDialog::ID_LANDSCAPE));
    rb_define_const(cFXPrintDialog.klass,"ID_PORTRAIT", INT2NUM(FXPrintDialog::ID_PORTRAIT));
    rb_define_const(cFXPrintDialog.klass,"ID_MEDIA", INT2NUM(FXPrintDialog::ID_MEDIA));
    rb_define_const(cFXPrintDialog.klass,"ID_COLLATE_NORMAL", INT2NUM(FXPrintDialog::ID_COLLATE_NORMAL));
    rb_define_const(cFXPrintDialog.klass,"ID_COLLATE_REVERSED", INT2NUM(FXPrintDialog::ID_COLLATE_REVERSED));
    rb_define_const(cFXPrintDialog.klass,"ID_PAGES_ALL", INT2NUM(FXPrintDialog::ID_PAGES_ALL));
    rb_define_const(cFXPrintDialog.klass,"ID_PAGES_EVEN", INT2NUM(FXPrintDialog::ID_PAGES_EVEN));
    rb_define_const(cFXPrintDialog.klass,"ID_PAGES_ODD", INT2NUM(FXPrintDialog::ID_PAGES_ODD));
    rb_define_const(cFXPrintDialog.klass,"ID_PAGES_RANGE", INT2NUM(FXPrintDialog::ID_PAGES_RANGE));
    rb_define_const(cFXPrintDialog.klass,"ID_PAGES_FIRST", INT2NUM(FXPrintDialog::ID_PAGES_FIRST));
    rb_define_const(cFXPrintDialog.klass,"ID_PAGES_LAST", INT2NUM(FXPrintDialog::ID_PAGES_LAST));
    rb_define_const(cFXPrintDialog.klass,"ID_BROWSE_FILE", INT2NUM(FXPrintDialog::ID_BROWSE_FILE));
    rb_define_const(cFXPrintDialog.klass,"ID_PROPERTIES", INT2NUM(FXPrintDialog::ID_PROPERTIES));
    rb_define_const(cFXPrintDialog.klass,"ID_COLOR_PRINTER", INT2NUM(FXPrintDialog::ID_COLOR_PRINTER));
    rb_define_const(cFXPrintDialog.klass,"ID_GRAY_PRINTER", INT2NUM(FXPrintDialog::ID_GRAY_PRINTER));
    rb_define_const(cFXPrintDialog.klass,"ID_NUM_COPIES", INT2NUM(FXPrintDialog::ID_NUM_COPIES));
    rb_define_method(cFXPrintDialog.klass, "setPrinter", VALUEFUNC(_wrap_FXPrintDialog_setPrinter), -1);
    rb_define_method(cFXPrintDialog.klass, "getPrinter", VALUEFUNC(_wrap_FXPrintDialog_getPrinter), -1);
    rb_define_method(cFXPrintDialog.klass, "save", VALUEFUNC(_wrap_FXPrintDialog_save), -1);
    rb_define_method(cFXPrintDialog.klass, "load", VALUEFUNC(_wrap_FXPrintDialog_load), -1);
    rb_define_method(cFXPrintDialog.klass, "create", VALUEFUNC(_wrap_FXPrintDialog_create), -1);
    rb_define_method(cFXPrintDialog.klass, "detach", VALUEFUNC(_wrap_FXPrintDialog_detach), -1);
    rb_define_method(cFXPrintDialog.klass, "destroy", VALUEFUNC(_wrap_FXPrintDialog_destroy), -1);
    rb_define_method(cFXPrintDialog.klass, "resize", VALUEFUNC(_wrap_FXPrintDialog_resize), -1);
    rb_define_method(cFXPrintDialog.klass, "getDefaultWidth", VALUEFUNC(_wrap_FXPrintDialog_getDefaultWidth), -1);
    rb_define_method(cFXPrintDialog.klass, "getDefaultHeight", VALUEFUNC(_wrap_FXPrintDialog_getDefaultHeight), -1);
    rb_define_method(cFXPrintDialog.klass, "getWidthForHeight", VALUEFUNC(_wrap_FXPrintDialog_getWidthForHeight), -1);
    rb_define_method(cFXPrintDialog.klass, "getHeightForWidth", VALUEFUNC(_wrap_FXPrintDialog_getHeightForWidth), -1);
    rb_define_method(cFXPrintDialog.klass, "canFocus", VALUEFUNC(_wrap_FXPrintDialog_canFocus), -1);
    rb_define_method(cFXPrintDialog.klass, "setFocus", VALUEFUNC(_wrap_FXPrintDialog_setFocus), -1);
    rb_define_method(cFXPrintDialog.klass, "killFocus", VALUEFUNC(_wrap_FXPrintDialog_killFocus), -1);
    rb_define_method(cFXPrintDialog.klass, "setDefault", VALUEFUNC(_wrap_FXPrintDialog_setDefault), -1);
    rb_define_method(cFXPrintDialog.klass, "enable", VALUEFUNC(_wrap_FXPrintDialog_enable), -1);
    rb_define_method(cFXPrintDialog.klass, "disable", VALUEFUNC(_wrap_FXPrintDialog_disable), -1);
    rb_define_method(cFXPrintDialog.klass, "raiseWindow", VALUEFUNC(_wrap_FXPrintDialog_raiseWindow), -1);
    rb_define_method(cFXPrintDialog.klass, "lower", VALUEFUNC(_wrap_FXPrintDialog_lower), -1);
    rb_define_method(cFXPrintDialog.klass, "move", VALUEFUNC(_wrap_FXPrintDialog_move), -1);
    rb_define_method(cFXPrintDialog.klass, "position", VALUEFUNC(_wrap_FXPrintDialog_position), -1);
    rb_define_method(cFXPrintDialog.klass, "layout", VALUEFUNC(_wrap_FXPrintDialog_layout), -1);
    rb_define_method(cFXPrintDialog.klass, "recalc", VALUEFUNC(_wrap_FXPrintDialog_recalc), -1);
    rb_define_method(cFXPrintDialog.klass, "reparent", VALUEFUNC(_wrap_FXPrintDialog_reparent), -1);
    rb_define_method(cFXPrintDialog.klass, "hide", VALUEFUNC(_wrap_FXPrintDialog_hide), -1);
    rb_define_method(cFXPrintDialog.klass, "isComposite", VALUEFUNC(_wrap_FXPrintDialog_isComposite), -1);
    rb_define_method(cFXPrintDialog.klass, "contains", VALUEFUNC(_wrap_FXPrintDialog_contains), -1);
    rb_define_method(cFXPrintDialog.klass, "doesSaveUnder", VALUEFUNC(_wrap_FXPrintDialog_doesSaveUnder), -1);
    rb_define_method(cFXPrintDialog.klass, "setBackColor", VALUEFUNC(_wrap_FXPrintDialog_setBackColor), -1);
    rb_define_method(cFXPrintDialog.klass, "show", VALUEFUNC(_wrap_FXPrintDialog_show), -1);
    rb_define_method(cFXPrintDialog.klass, "maximize", VALUEFUNC(_wrap_FXPrintDialog_maximize), -1);
    rb_define_method(cFXPrintDialog.klass, "minimize", VALUEFUNC(_wrap_FXPrintDialog_minimize), -1);
    rb_define_method(cFXPrintDialog.klass, "restore", VALUEFUNC(_wrap_FXPrintDialog_restore), -1);
    rb_define_method(cFXPrintDialog.klass, "close", VALUEFUNC(_wrap_FXPrintDialog_close), -1);
    rb_define_method(cFXPrintDialog.klass, "execute", VALUEFUNC(_wrap_FXPrintDialog_execute), -1);
    cFXPrintDialog.mark = (void (*)(void *)) FXRbPrintDialog::markfunc;
    cFXPrintDialog.destroy = (void (*)(void *)) FXRbObject::freefunc;
    rb_define_const(mFox,"PROGRESSDIALOG_NOCANCEL", INT2NUM(PROGRESSDIALOG_NOCANCEL));
    rb_define_const(mFox,"PROGRESSDIALOG_CANCEL", INT2NUM(PROGRESSDIALOG_CANCEL));
    rb_define_const(mFox,"PROGRESSDIALOG_NORMAL", INT2NUM(PROGRESSDIALOG_NORMAL));
    
    cFXProgressDialog.klass = rb_define_class_under(mFox, "FXProgressDialog", ((swig_class *) SWIGTYPE_p_FXDialogBox->clientdata)->klass);
    SWIG_TypeClientData(SWIGTYPE_p_FXProgressDialog, (void *) &cFXProgressDialog);
    rb_define_alloc_func(cFXProgressDialog.klass, _wrap_FXProgressDialog_allocate);
    rb_define_method(cFXProgressDialog.klass, "initialize", VALUEFUNC(_wrap_new_FXProgressDialog), -1);
    rb_define_method(cFXProgressDialog.klass, "onCmdSetValue", VALUEFUNC(_wrap_FXProgressDialog_onCmdSetValue), -1);
    rb_define_method(cFXProgressDialog.klass, "onCmdSetIntValue", VALUEFUNC(_wrap_FXProgressDialog_onCmdSetIntValue), -1);
    rb_define_method(cFXProgressDialog.klass, "onCmdGetIntValue", VALUEFUNC(_wrap_FXProgressDialog_onCmdGetIntValue), -1);
    rb_define_method(cFXProgressDialog.klass, "onCmdSetStringValue", VALUEFUNC(_wrap_FXProgressDialog_onCmdSetStringValue), -1);
    rb_define_method(cFXProgressDialog.klass, "onCmdGetStringValue", VALUEFUNC(_wrap_FXProgressDialog_onCmdGetStringValue), -1);
    rb_define_method(cFXProgressDialog.klass, "onCmdCancel", VALUEFUNC(_wrap_FXProgressDialog_onCmdCancel), -1);
    rb_define_method(cFXProgressDialog.klass, "setMessage", VALUEFUNC(_wrap_FXProgressDialog_setMessage), -1);
    rb_define_method(cFXProgressDialog.klass, "getMessage", VALUEFUNC(_wrap_FXProgressDialog_getMessage), -1);
    rb_define_method(cFXProgressDialog.klass, "setBarStyle", VALUEFUNC(_wrap_FXProgressDialog_setBarStyle), -1);
    rb_define_method(cFXProgressDialog.klass, "getBarStyle", VALUEFUNC(_wrap_FXProgressDialog_getBarStyle), -1);
    rb_define_method(cFXProgressDialog.klass, "setProgress", VALUEFUNC(_wrap_FXProgressDialog_setProgress), -1);
    rb_define_method(cFXProgressDialog.klass, "getProgress", VALUEFUNC(_wrap_FXProgressDialog_getProgress), -1);
    rb_define_method(cFXProgressDialog.klass, "setTotal", VALUEFUNC(_wrap_FXProgressDialog_setTotal), -1);
    rb_define_method(cFXProgressDialog.klass, "getTotal", VALUEFUNC(_wrap_FXProgressDialog_getTotal), -1);
    rb_define_method(cFXProgressDialog.klass, "increment", VALUEFUNC(_wrap_FXProgressDialog_increment), -1);
    rb_define_method(cFXProgressDialog.klass, "isCancelled", VALUEFUNC(_wrap_FXProgressDialog_isCancelled), -1);
    rb_define_method(cFXProgressDialog.klass, "setCancelled", VALUEFUNC(_wrap_FXProgressDialog_setCancelled), -1);
    rb_define_method(cFXProgressDialog.klass, "save", VALUEFUNC(_wrap_FXProgressDialog_save), -1);
    rb_define_method(cFXProgressDialog.klass, "load", VALUEFUNC(_wrap_FXProgressDialog_load), -1);
    rb_define_method(cFXProgressDialog.klass, "create", VALUEFUNC(_wrap_FXProgressDialog_create), -1);
    rb_define_method(cFXProgressDialog.klass, "detach", VALUEFUNC(_wrap_FXProgressDialog_detach), -1);
    rb_define_method(cFXProgressDialog.klass, "destroy", VALUEFUNC(_wrap_FXProgressDialog_destroy), -1);
    rb_define_method(cFXProgressDialog.klass, "resize", VALUEFUNC(_wrap_FXProgressDialog_resize), -1);
    rb_define_method(cFXProgressDialog.klass, "getDefaultWidth", VALUEFUNC(_wrap_FXProgressDialog_getDefaultWidth), -1);
    rb_define_method(cFXProgressDialog.klass, "getDefaultHeight", VALUEFUNC(_wrap_FXProgressDialog_getDefaultHeight), -1);
    rb_define_method(cFXProgressDialog.klass, "getWidthForHeight", VALUEFUNC(_wrap_FXProgressDialog_getWidthForHeight), -1);
    rb_define_method(cFXProgressDialog.klass, "getHeightForWidth", VALUEFUNC(_wrap_FXProgressDialog_getHeightForWidth), -1);
    rb_define_method(cFXProgressDialog.klass, "canFocus", VALUEFUNC(_wrap_FXProgressDialog_canFocus), -1);
    rb_define_method(cFXProgressDialog.klass, "setFocus", VALUEFUNC(_wrap_FXProgressDialog_setFocus), -1);
    rb_define_method(cFXProgressDialog.klass, "killFocus", VALUEFUNC(_wrap_FXProgressDialog_killFocus), -1);
    rb_define_method(cFXProgressDialog.klass, "setDefault", VALUEFUNC(_wrap_FXProgressDialog_setDefault), -1);
    rb_define_method(cFXProgressDialog.klass, "enable", VALUEFUNC(_wrap_FXProgressDialog_enable), -1);
    rb_define_method(cFXProgressDialog.klass, "disable", VALUEFUNC(_wrap_FXProgressDialog_disable), -1);
    rb_define_method(cFXProgressDialog.klass, "raiseWindow", VALUEFUNC(_wrap_FXProgressDialog_raiseWindow), -1);
    rb_define_method(cFXProgressDialog.klass, "lower", VALUEFUNC(_wrap_FXProgressDialog_lower), -1);
    rb_define_method(cFXProgressDialog.klass, "move", VALUEFUNC(_wrap_FXProgressDialog_move), -1);
    rb_define_method(cFXProgressDialog.klass, "position", VALUEFUNC(_wrap_FXProgressDialog_position), -1);
    rb_define_method(cFXProgressDialog.klass, "layout", VALUEFUNC(_wrap_FXProgressDialog_layout), -1);
    rb_define_method(cFXProgressDialog.klass, "recalc", VALUEFUNC(_wrap_FXProgressDialog_recalc), -1);
    rb_define_method(cFXProgressDialog.klass, "reparent", VALUEFUNC(_wrap_FXProgressDialog_reparent), -1);
    rb_define_method(cFXProgressDialog.klass, "hide", VALUEFUNC(_wrap_FXProgressDialog_hide), -1);
    rb_define_method(cFXProgressDialog.klass, "isComposite", VALUEFUNC(_wrap_FXProgressDialog_isComposite), -1);
    rb_define_method(cFXProgressDialog.klass, "contains", VALUEFUNC(_wrap_FXProgressDialog_contains), -1);
    rb_define_method(cFXProgressDialog.klass, "doesSaveUnder", VALUEFUNC(_wrap_FXProgressDialog_doesSaveUnder), -1);
    rb_define_method(cFXProgressDialog.klass, "setBackColor", VALUEFUNC(_wrap_FXProgressDialog_setBackColor), -1);
    rb_define_method(cFXProgressDialog.klass, "show", VALUEFUNC(_wrap_FXProgressDialog_show), -1);
    rb_define_method(cFXProgressDialog.klass, "maximize", VALUEFUNC(_wrap_FXProgressDialog_maximize), -1);
    rb_define_method(cFXProgressDialog.klass, "minimize", VALUEFUNC(_wrap_FXProgressDialog_minimize), -1);
    rb_define_method(cFXProgressDialog.klass, "restore", VALUEFUNC(_wrap_FXProgressDialog_restore), -1);
    rb_define_method(cFXProgressDialog.klass, "close", VALUEFUNC(_wrap_FXProgressDialog_close), -1);
    rb_define_method(cFXProgressDialog.klass, "execute", VALUEFUNC(_wrap_FXProgressDialog_execute), -1);
    cFXProgressDialog.mark = (void (*)(void *)) FXRbProgressDialog::markfunc;
    cFXProgressDialog.destroy = (void (*)(void *)) FXRbObject::freefunc;
    rb_define_const(mFox,"MBOX_OK", INT2NUM(MBOX_OK));
    rb_define_const(mFox,"MBOX_OK_CANCEL", INT2NUM(MBOX_OK_CANCEL));
    rb_define_const(mFox,"MBOX_YES_NO", INT2NUM(MBOX_YES_NO));
    rb_define_const(mFox,"MBOX_YES_NO_CANCEL", INT2NUM(MBOX_YES_NO_CANCEL));
    rb_define_const(mFox,"MBOX_QUIT_CANCEL", INT2NUM(MBOX_QUIT_CANCEL));
    rb_define_const(mFox,"MBOX_QUIT_SAVE_CANCEL", INT2NUM(MBOX_QUIT_SAVE_CANCEL));
    rb_define_const(mFox,"MBOX_SKIP_SKIPALL_CANCEL", INT2NUM(MBOX_SKIP_SKIPALL_CANCEL));
    rb_define_const(mFox,"MBOX_CLICKED_YES", INT2NUM(MBOX_CLICKED_YES));
    rb_define_const(mFox,"MBOX_CLICKED_NO", INT2NUM(MBOX_CLICKED_NO));
    rb_define_const(mFox,"MBOX_CLICKED_OK", INT2NUM(MBOX_CLICKED_OK));
    rb_define_const(mFox,"MBOX_CLICKED_CANCEL", INT2NUM(MBOX_CLICKED_CANCEL));
    rb_define_const(mFox,"MBOX_CLICKED_QUIT", INT2NUM(MBOX_CLICKED_QUIT));
    rb_define_const(mFox,"MBOX_CLICKED_SAVE", INT2NUM(MBOX_CLICKED_SAVE));
    rb_define_const(mFox,"MBOX_CLICKED_SKIP", INT2NUM(MBOX_CLICKED_SKIP));
    rb_define_const(mFox,"MBOX_CLICKED_SKIPALL", INT2NUM(MBOX_CLICKED_SKIPALL));
    
    cFXMessageBox.klass = rb_define_class_under(mFox, "FXMessageBox", ((swig_class *) SWIGTYPE_p_FXDialogBox->clientdata)->klass);
    SWIG_TypeClientData(SWIGTYPE_p_FXMessageBox, (void *) &cFXMessageBox);
    rb_define_alloc_func(cFXMessageBox.klass, _wrap_FXMessageBox_allocate);
    rb_define_method(cFXMessageBox.klass, "initialize", VALUEFUNC(_wrap_new_FXMessageBox), -1);
    rb_define_method(cFXMessageBox.klass, "onCmdClicked", VALUEFUNC(_wrap_FXMessageBox_onCmdClicked), -1);
    rb_define_method(cFXMessageBox.klass, "onCmdCancel", VALUEFUNC(_wrap_FXMessageBox_onCmdCancel), -1);
    rb_define_const(cFXMessageBox.klass,"ID_CLICKED_YES", INT2NUM(FXMessageBox::ID_CLICKED_YES));
    rb_define_const(cFXMessageBox.klass,"ID_CLICKED_NO", INT2NUM(FXMessageBox::ID_CLICKED_NO));
    rb_define_const(cFXMessageBox.klass,"ID_CLICKED_OK", INT2NUM(FXMessageBox::ID_CLICKED_OK));
    rb_define_const(cFXMessageBox.klass,"ID_CLICKED_CANCEL", INT2NUM(FXMessageBox::ID_CLICKED_CANCEL));
    rb_define_const(cFXMessageBox.klass,"ID_CLICKED_QUIT", INT2NUM(FXMessageBox::ID_CLICKED_QUIT));
    rb_define_const(cFXMessageBox.klass,"ID_CLICKED_SAVE", INT2NUM(FXMessageBox::ID_CLICKED_SAVE));
    rb_define_const(cFXMessageBox.klass,"ID_CLICKED_SKIP", INT2NUM(FXMessageBox::ID_CLICKED_SKIP));
    rb_define_const(cFXMessageBox.klass,"ID_CLICKED_SKIPALL", INT2NUM(FXMessageBox::ID_CLICKED_SKIPALL));
    rb_define_const(cFXMessageBox.klass,"ID_LAST", INT2NUM(FXMessageBox::ID_LAST));
    rb_define_singleton_method(cFXMessageBox.klass, "error", VALUEFUNC(_wrap_FXMessageBox_error), -1);
    rb_define_singleton_method(cFXMessageBox.klass, "warning", VALUEFUNC(_wrap_FXMessageBox_warning), -1);
    rb_define_singleton_method(cFXMessageBox.klass, "question", VALUEFUNC(_wrap_FXMessageBox_question), -1);
    rb_define_singleton_method(cFXMessageBox.klass, "information", VALUEFUNC(_wrap_FXMessageBox_information), -1);
    rb_define_method(cFXMessageBox.klass, "save", VALUEFUNC(_wrap_FXMessageBox_save), -1);
    rb_define_method(cFXMessageBox.klass, "load", VALUEFUNC(_wrap_FXMessageBox_load), -1);
    rb_define_method(cFXMessageBox.klass, "create", VALUEFUNC(_wrap_FXMessageBox_create), -1);
    rb_define_method(cFXMessageBox.klass, "detach", VALUEFUNC(_wrap_FXMessageBox_detach), -1);
    rb_define_method(cFXMessageBox.klass, "destroy", VALUEFUNC(_wrap_FXMessageBox_destroy), -1);
    rb_define_method(cFXMessageBox.klass, "resize", VALUEFUNC(_wrap_FXMessageBox_resize), -1);
    rb_define_method(cFXMessageBox.klass, "getDefaultWidth", VALUEFUNC(_wrap_FXMessageBox_getDefaultWidth), -1);
    rb_define_method(cFXMessageBox.klass, "getDefaultHeight", VALUEFUNC(_wrap_FXMessageBox_getDefaultHeight), -1);
    rb_define_method(cFXMessageBox.klass, "getWidthForHeight", VALUEFUNC(_wrap_FXMessageBox_getWidthForHeight), -1);
    rb_define_method(cFXMessageBox.klass, "getHeightForWidth", VALUEFUNC(_wrap_FXMessageBox_getHeightForWidth), -1);
    rb_define_method(cFXMessageBox.klass, "canFocus", VALUEFUNC(_wrap_FXMessageBox_canFocus), -1);
    rb_define_method(cFXMessageBox.klass, "setFocus", VALUEFUNC(_wrap_FXMessageBox_setFocus), -1);
    rb_define_method(cFXMessageBox.klass, "killFocus", VALUEFUNC(_wrap_FXMessageBox_killFocus), -1);
    rb_define_method(cFXMessageBox.klass, "setDefault", VALUEFUNC(_wrap_FXMessageBox_setDefault), -1);
    rb_define_method(cFXMessageBox.klass, "enable", VALUEFUNC(_wrap_FXMessageBox_enable), -1);
    rb_define_method(cFXMessageBox.klass, "disable", VALUEFUNC(_wrap_FXMessageBox_disable), -1);
    rb_define_method(cFXMessageBox.klass, "raiseWindow", VALUEFUNC(_wrap_FXMessageBox_raiseWindow), -1);
    rb_define_method(cFXMessageBox.klass, "lower", VALUEFUNC(_wrap_FXMessageBox_lower), -1);
    rb_define_method(cFXMessageBox.klass, "move", VALUEFUNC(_wrap_FXMessageBox_move), -1);
    rb_define_method(cFXMessageBox.klass, "position", VALUEFUNC(_wrap_FXMessageBox_position), -1);
    rb_define_method(cFXMessageBox.klass, "layout", VALUEFUNC(_wrap_FXMessageBox_layout), -1);
    rb_define_method(cFXMessageBox.klass, "recalc", VALUEFUNC(_wrap_FXMessageBox_recalc), -1);
    rb_define_method(cFXMessageBox.klass, "reparent", VALUEFUNC(_wrap_FXMessageBox_reparent), -1);
    rb_define_method(cFXMessageBox.klass, "hide", VALUEFUNC(_wrap_FXMessageBox_hide), -1);
    rb_define_method(cFXMessageBox.klass, "isComposite", VALUEFUNC(_wrap_FXMessageBox_isComposite), -1);
    rb_define_method(cFXMessageBox.klass, "contains", VALUEFUNC(_wrap_FXMessageBox_contains), -1);
    rb_define_method(cFXMessageBox.klass, "doesSaveUnder", VALUEFUNC(_wrap_FXMessageBox_doesSaveUnder), -1);
    rb_define_method(cFXMessageBox.klass, "setBackColor", VALUEFUNC(_wrap_FXMessageBox_setBackColor), -1);
    rb_define_method(cFXMessageBox.klass, "show", VALUEFUNC(_wrap_FXMessageBox_show), -1);
    rb_define_method(cFXMessageBox.klass, "maximize", VALUEFUNC(_wrap_FXMessageBox_maximize), -1);
    rb_define_method(cFXMessageBox.klass, "minimize", VALUEFUNC(_wrap_FXMessageBox_minimize), -1);
    rb_define_method(cFXMessageBox.klass, "restore", VALUEFUNC(_wrap_FXMessageBox_restore), -1);
    rb_define_method(cFXMessageBox.klass, "close", VALUEFUNC(_wrap_FXMessageBox_close), -1);
    rb_define_method(cFXMessageBox.klass, "execute", VALUEFUNC(_wrap_FXMessageBox_execute), -1);
    cFXMessageBox.mark = (void (*)(void *)) FXRbMessageBox::markfunc;
    cFXMessageBox.destroy = (void (*)(void *)) FXRbObject::freefunc;
    
    cFXWizard.klass = rb_define_class_under(mFox, "FXWizard", ((swig_class *) SWIGTYPE_p_FXDialogBox->clientdata)->klass);
    SWIG_TypeClientData(SWIGTYPE_p_FXWizard, (void *) &cFXWizard);
    rb_define_alloc_func(cFXWizard.klass, _wrap_FXWizard_allocate);
    rb_define_method(cFXWizard.klass, "initialize", VALUEFUNC(_wrap_new_FXWizard), -1);
    rb_define_method(cFXWizard.klass, "onUpdFinish", VALUEFUNC(_wrap_FXWizard_onUpdFinish), -1);
    rb_define_method(cFXWizard.klass, "onCmdNext", VALUEFUNC(_wrap_FXWizard_onCmdNext), -1);
    rb_define_method(cFXWizard.klass, "onUpdNext", VALUEFUNC(_wrap_FXWizard_onUpdNext), -1);
    rb_define_method(cFXWizard.klass, "onCmdBack", VALUEFUNC(_wrap_FXWizard_onCmdBack), -1);
    rb_define_method(cFXWizard.klass, "onUpdBack", VALUEFUNC(_wrap_FXWizard_onUpdBack), -1);
    rb_define_const(cFXWizard.klass,"ID_NEXT", INT2NUM(FXWizard::ID_NEXT));
    rb_define_const(cFXWizard.klass,"ID_BACK", INT2NUM(FXWizard::ID_BACK));
    rb_define_const(cFXWizard.klass,"ID_LAST", INT2NUM(FXWizard::ID_LAST));
    rb_define_method(cFXWizard.klass, "buttonFrame", VALUEFUNC(_wrap_FXWizard_buttonFrame), -1);
    rb_define_method(cFXWizard.klass, "advanceButton", VALUEFUNC(_wrap_FXWizard_advanceButton), -1);
    rb_define_method(cFXWizard.klass, "retreatButton", VALUEFUNC(_wrap_FXWizard_retreatButton), -1);
    rb_define_method(cFXWizard.klass, "finishButton", VALUEFUNC(_wrap_FXWizard_finishButton), -1);
    rb_define_method(cFXWizard.klass, "cancelButton", VALUEFUNC(_wrap_FXWizard_cancelButton), -1);
    rb_define_method(cFXWizard.klass, "getContainer", VALUEFUNC(_wrap_FXWizard_getContainer), -1);
    rb_define_method(cFXWizard.klass, "setImage", VALUEFUNC(_wrap_FXWizard_setImage), -1);
    rb_define_method(cFXWizard.klass, "getImage", VALUEFUNC(_wrap_FXWizard_getImage), -1);
    rb_define_method(cFXWizard.klass, "getNumPanels", VALUEFUNC(_wrap_FXWizard_getNumPanels), -1);
    rb_define_method(cFXWizard.klass, "setCurrentPanel", VALUEFUNC(_wrap_FXWizard_setCurrentPanel), -1);
    rb_define_method(cFXWizard.klass, "getCurrentPanel", VALUEFUNC(_wrap_FXWizard_getCurrentPanel), -1);
    rb_define_method(cFXWizard.klass, "save", VALUEFUNC(_wrap_FXWizard_save), -1);
    rb_define_method(cFXWizard.klass, "load", VALUEFUNC(_wrap_FXWizard_load), -1);
    rb_define_method(cFXWizard.klass, "create", VALUEFUNC(_wrap_FXWizard_create), -1);
    rb_define_method(cFXWizard.klass, "detach", VALUEFUNC(_wrap_FXWizard_detach), -1);
    rb_define_method(cFXWizard.klass, "destroy", VALUEFUNC(_wrap_FXWizard_destroy), -1);
    rb_define_method(cFXWizard.klass, "resize", VALUEFUNC(_wrap_FXWizard_resize), -1);
    rb_define_method(cFXWizard.klass, "getDefaultWidth", VALUEFUNC(_wrap_FXWizard_getDefaultWidth), -1);
    rb_define_method(cFXWizard.klass, "getDefaultHeight", VALUEFUNC(_wrap_FXWizard_getDefaultHeight), -1);
    rb_define_method(cFXWizard.klass, "getWidthForHeight", VALUEFUNC(_wrap_FXWizard_getWidthForHeight), -1);
    rb_define_method(cFXWizard.klass, "getHeightForWidth", VALUEFUNC(_wrap_FXWizard_getHeightForWidth), -1);
    rb_define_method(cFXWizard.klass, "canFocus", VALUEFUNC(_wrap_FXWizard_canFocus), -1);
    rb_define_method(cFXWizard.klass, "setFocus", VALUEFUNC(_wrap_FXWizard_setFocus), -1);
    rb_define_method(cFXWizard.klass, "killFocus", VALUEFUNC(_wrap_FXWizard_killFocus), -1);
    rb_define_method(cFXWizard.klass, "setDefault", VALUEFUNC(_wrap_FXWizard_setDefault), -1);
    rb_define_method(cFXWizard.klass, "enable", VALUEFUNC(_wrap_FXWizard_enable), -1);
    rb_define_method(cFXWizard.klass, "disable", VALUEFUNC(_wrap_FXWizard_disable), -1);
    rb_define_method(cFXWizard.klass, "raiseWindow", VALUEFUNC(_wrap_FXWizard_raiseWindow), -1);
    rb_define_method(cFXWizard.klass, "lower", VALUEFUNC(_wrap_FXWizard_lower), -1);
    rb_define_method(cFXWizard.klass, "move", VALUEFUNC(_wrap_FXWizard_move), -1);
    rb_define_method(cFXWizard.klass, "position", VALUEFUNC(_wrap_FXWizard_position), -1);
    rb_define_method(cFXWizard.klass, "layout", VALUEFUNC(_wrap_FXWizard_layout), -1);
    rb_define_method(cFXWizard.klass, "recalc", VALUEFUNC(_wrap_FXWizard_recalc), -1);
    rb_define_method(cFXWizard.klass, "reparent", VALUEFUNC(_wrap_FXWizard_reparent), -1);
    rb_define_method(cFXWizard.klass, "hide", VALUEFUNC(_wrap_FXWizard_hide), -1);
    rb_define_method(cFXWizard.klass, "isComposite", VALUEFUNC(_wrap_FXWizard_isComposite), -1);
    rb_define_method(cFXWizard.klass, "contains", VALUEFUNC(_wrap_FXWizard_contains), -1);
    rb_define_method(cFXWizard.klass, "doesSaveUnder", VALUEFUNC(_wrap_FXWizard_doesSaveUnder), -1);
    rb_define_method(cFXWizard.klass, "setBackColor", VALUEFUNC(_wrap_FXWizard_setBackColor), -1);
    rb_define_method(cFXWizard.klass, "show", VALUEFUNC(_wrap_FXWizard_show), -1);
    rb_define_method(cFXWizard.klass, "maximize", VALUEFUNC(_wrap_FXWizard_maximize), -1);
    rb_define_method(cFXWizard.klass, "minimize", VALUEFUNC(_wrap_FXWizard_minimize), -1);
    rb_define_method(cFXWizard.klass, "restore", VALUEFUNC(_wrap_FXWizard_restore), -1);
    rb_define_method(cFXWizard.klass, "close", VALUEFUNC(_wrap_FXWizard_close), -1);
    rb_define_method(cFXWizard.klass, "execute", VALUEFUNC(_wrap_FXWizard_execute), -1);
    cFXWizard.mark = (void (*)(void *)) FXRbWizard::markfunc;
    cFXWizard.destroy = (void (*)(void *)) FXRbObject::freefunc;
}

