/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 1.3.22
 * 
 * This file is not intended to be easily readable and contains a number of 
 * coding conventions designed to improve portability and efficiency. Do not make
 * changes to this file unless you know what you are doing--modify the SWIG 
 * interface file instead. 
 * ----------------------------------------------------------------------------- */

#define SWIG_NOINCLUDE

#ifdef __cplusplus
template<class T> class SwigValueWrapper {
    T *tt;
public:
    SwigValueWrapper() : tt(0) { }
    SwigValueWrapper(const SwigValueWrapper<T>& rhs) : tt(new T(*rhs.tt)) { }
    SwigValueWrapper(const T& t) : tt(new T(t)) { }
    ~SwigValueWrapper() { delete tt; } 
    SwigValueWrapper& operator=(const T& t) { delete tt; tt = new T(t); return *this; }
    operator T&() const { return *tt; }
    T *operator&() { return tt; }
private:
    SwigValueWrapper& operator=(const SwigValueWrapper<T>& rhs);
};                                                    
#endif

/* ruby.swg */
/* Implementation : RUBY */
#define SWIGRUBY 1

#include "ruby.h"

/* Flags for pointer conversion */
#define SWIG_POINTER_EXCEPTION     0x1
#define SWIG_POINTER_DISOWN        0x2

#define NUM2USHRT(n) (\
    (0 <= NUM2UINT(n) && NUM2UINT(n) <= USHRT_MAX)\
    ? (unsigned short) NUM2UINT(n) \
    : (rb_raise(rb_eArgError, "integer %d out of range of `unsigned short'",\
               NUM2UINT(n)), (short)0)\
)

#define NUM2SHRT(n) (\
    (SHRT_MIN <= NUM2INT(n) && NUM2INT(n) <= SHRT_MAX)\
    ? (short)NUM2INT(n)\
    : (rb_raise(rb_eArgError, "integer %d out of range of `short'",\
               NUM2INT(n)), (short)0)\
)

/* Ruby 1.7 defines NUM2LL(), LL2NUM() and ULL2NUM() macros */
#ifndef NUM2LL
#define NUM2LL(x) NUM2LONG((x))
#endif
#ifndef LL2NUM
#define LL2NUM(x) INT2NUM((long) (x))
#endif
#ifndef ULL2NUM
#define ULL2NUM(x) UINT2NUM((unsigned long) (x))
#endif

/* Ruby 1.7 doesn't (yet) define NUM2ULL() */
#ifndef NUM2ULL
#ifdef HAVE_LONG_LONG
#define NUM2ULL(x) rb_num2ull((x))
#else
#define NUM2ULL(x) NUM2ULONG(x)
#endif
#endif

/*
 * Need to be very careful about how these macros are defined, especially
 * when compiling C++ code or C code with an ANSI C compiler.
 *
 * VALUEFUNC(f) is a macro used to typecast a C function that implements
 * a Ruby method so that it can be passed as an argument to API functions
 * like rb_define_method() and rb_define_singleton_method().
 *
 * VOIDFUNC(f) is a macro used to typecast a C function that implements
 * either the "mark" or "free" stuff for a Ruby Data object, so that it
 * can be passed as an argument to API functions like Data_Wrap_Struct()
 * and Data_Make_Struct().
 */
 
#ifdef __cplusplus
#  ifndef RUBY_METHOD_FUNC /* These definitions should work for Ruby 1.4.6 */
#    define PROTECTFUNC(f) ((VALUE (*)()) f)
#    define VALUEFUNC(f) ((VALUE (*)()) f)
#    define VOIDFUNC(f)  ((void (*)()) f)
#  else
#    ifndef ANYARGS /* These definitions should work for Ruby 1.6 */
#      define PROTECTFUNC(f) ((VALUE (*)()) f)
#      define VALUEFUNC(f) ((VALUE (*)()) f)
#      define VOIDFUNC(f)  ((RUBY_DATA_FUNC) f)
#    else /* These definitions should work for Ruby 1.7+ */
#      define PROTECTFUNC(f) ((VALUE (*)(VALUE)) f)
#      define VALUEFUNC(f) ((VALUE (*)(ANYARGS)) f)
#      define VOIDFUNC(f)  ((RUBY_DATA_FUNC) f)
#    endif
#  endif
#else
#  define VALUEFUNC(f) (f)
#  define VOIDFUNC(f) (f)
#endif

typedef struct {
  VALUE klass;
  VALUE mImpl;
  void  (*mark)(void *);
  void  (*destroy)(void *);
} swig_class;

/* Don't use for expressions have side effect */
#ifndef RB_STRING_VALUE
#define RB_STRING_VALUE(s) (TYPE(s) == T_STRING ? (s) : (*(volatile VALUE *)&(s) = rb_str_to_str(s)))
#endif
#ifndef StringValue
#define StringValue(s) RB_STRING_VALUE(s)
#endif
#ifndef StringValuePtr
#define StringValuePtr(s) RSTRING(RB_STRING_VALUE(s))->ptr
#endif
#ifndef StringValueLen
#define StringValueLen(s) RSTRING(RB_STRING_VALUE(s))->len
#endif
#ifndef SafeStringValue
#define SafeStringValue(v) do {\
    StringValue(v);\
    rb_check_safe_str(v);\
} while (0)
#endif

#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
#define rb_define_alloc_func(klass, func) rb_define_singleton_method((klass), "new", VALUEFUNC((func)), -1)
#define rb_undef_alloc_func(klass) rb_undef_method(CLASS_OF((klass)), "new")
#endif

/* Contract support */

#define SWIG_contract_assert(expr, msg) if (!(expr)) { rb_raise(rb_eRuntimeError, (char *) msg ); } else


/*************************************************************** -*- c -*-
 * ruby/precommon.swg
 *
 * Rename all exported symbols from common.swg, to avoid symbol
 * clashes if multiple interpreters are included
 *
 ************************************************************************/

#define SWIG_TypeRegister    SWIG_Ruby_TypeRegister
#define SWIG_TypeCheck       SWIG_Ruby_TypeCheck
#define SWIG_TypeCast        SWIG_Ruby_TypeCast
#define SWIG_TypeDynamicCast SWIG_Ruby_TypeDynamicCast
#define SWIG_TypeName        SWIG_Ruby_TypeName
#define SWIG_TypePrettyName  SWIG_Ruby_TypePrettyName
#define SWIG_TypeQuery       SWIG_Ruby_TypeQuery
#define SWIG_TypeClientData  SWIG_Ruby_TypeClientData
#define SWIG_PackData        SWIG_Ruby_PackData 
#define SWIG_UnpackData      SWIG_Ruby_UnpackData 

/* Also rename all exported symbols from rubydef.swig */

/* Common SWIG API */
#define SWIG_ConvertPtr(obj, pp, type, flags) \
  SWIG_Ruby_ConvertPtr(obj, pp, type, flags)
#define SWIG_NewPointerObj(p, type, flags) \
  SWIG_Ruby_NewPointerObj(p, type, flags)
#define SWIG_MustGetPtr(p, type, argnum, flags) \
  SWIG_Ruby_MustGetPtr(p, type, argnum, flags)

/* Ruby-specific SWIG API */

#define SWIG_InitRuntime() \
  SWIG_Ruby_InitRuntime()
#define SWIG_define_class(ty) \
  SWIG_Ruby_define_class(ty)
#define SWIG_NewClassInstance(value, ty) \
  SWIG_Ruby_NewClassInstance(value, ty)
#define SWIG_MangleStr(value) \
  SWIG_Ruby_MangleStr(value)
#define SWIG_CheckConvert(value, ty) \
  SWIG_Ruby_CheckConvert(value, ty)
#define SWIG_NewPackedObj(ptr, sz, ty) \
  SWIG_Ruby_NewPackedObj(ptr, sz, ty)
#define SWIG_ConvertPacked(obj, ptr, sz, ty, flags) \
  SWIG_Ruby_ConvertPacked(obj, ptr, sz, ty, flags)


/***********************************************************************
 * common.swg
 *
 *     This file contains generic SWIG runtime support for pointer
 *     type checking as well as a few commonly used macros to control
 *     external linkage.
 *
 * Author : David Beazley (beazley@cs.uchicago.edu)
 *
 * Copyright (c) 1999-2000, The University of Chicago
 * 
 * This file may be freely redistributed without license or fee provided
 * this copyright message remains intact.
 ************************************************************************/

#include <string.h>

#if defined(_WIN32) || defined(__WIN32__) || defined(__CYGWIN__)
#  if defined(_MSC_VER) || defined(__GNUC__)
#    if defined(STATIC_LINKED)
#      define SWIGEXPORT(a) a
#      define SWIGIMPORT(a) extern a
#    else
#      define SWIGEXPORT(a) __declspec(dllexport) a
#      define SWIGIMPORT(a) extern a
#    endif
#  else
#    if defined(__BORLANDC__)
#      define SWIGEXPORT(a) a _export
#      define SWIGIMPORT(a) a _export
#    else
#      define SWIGEXPORT(a) a
#      define SWIGIMPORT(a) a
#    endif
#  endif
#else
#  define SWIGEXPORT(a) a
#  define SWIGIMPORT(a) a
#endif

#ifdef SWIG_GLOBAL
#  define SWIGRUNTIME(a) SWIGEXPORT(a)
#else
#  define SWIGRUNTIME(a) static a
#endif

#ifdef __cplusplus
extern "C" {
#endif

typedef void *(*swig_converter_func)(void *);
typedef struct swig_type_info *(*swig_dycast_func)(void **);

typedef struct swig_type_info {
  const char             *name;
  swig_converter_func     converter;
  const char             *str;
  void                   *clientdata;
  swig_dycast_func        dcast;
  struct swig_type_info  *next;
  struct swig_type_info  *prev;
} swig_type_info;

#ifdef SWIG_NOINCLUDE

SWIGIMPORT(swig_type_info *) SWIG_TypeRegister(swig_type_info *);
SWIGIMPORT(swig_type_info *) SWIG_TypeCheck(char *c, swig_type_info *);
SWIGIMPORT(void *)           SWIG_TypeCast(swig_type_info *, void *);
SWIGIMPORT(swig_type_info *) SWIG_TypeDynamicCast(swig_type_info *, void **);
SWIGIMPORT(const char *)     SWIG_TypeName(const swig_type_info *);
SWIGIMPORT(const char *)     SWIG_TypePrettyName(const swig_type_info *);
SWIGIMPORT(swig_type_info *) SWIG_TypeQuery(const char *);
SWIGIMPORT(void)             SWIG_TypeClientData(swig_type_info *, void *);
SWIGIMPORT(char *)           SWIG_PackData(char *, void *, int);
SWIGIMPORT(char *)           SWIG_UnpackData(char *, void *, int);

#else

static swig_type_info *swig_type_list = 0;
static swig_type_info **swig_type_list_handle = &swig_type_list;

/* Register a type mapping with the type-checking */
SWIGRUNTIME(swig_type_info *)
SWIG_TypeRegister(swig_type_info *ti) {
  swig_type_info *tc, *head, *ret, *next;
  /* Check to see if this type has already been registered */
  tc = *swig_type_list_handle;
  while (tc) {
    if (strcmp(tc->name, ti->name) == 0) {
      /* Already exists in the table.  Just add additional types to the list */
      if (tc->clientdata) ti->clientdata = tc->clientdata;
      head = tc;
      next = tc->next;
      goto l1;
    }
    tc = tc->prev;
  }
  head = ti;
  next = 0;

  /* Place in list */
  ti->prev = *swig_type_list_handle;
  *swig_type_list_handle = ti;

  /* Build linked lists */
  l1:
  ret = head;
  tc = ti + 1;
  /* Patch up the rest of the links */
  while (tc->name) {
    head->next = tc;
    tc->prev = head;
    head = tc;
    tc++;
  }
  if (next) next->prev = head;
  head->next = next;
  return ret;
}

/* Check the typename */
SWIGRUNTIME(swig_type_info *) 
SWIG_TypeCheck(char *c, swig_type_info *ty) {
  swig_type_info *s;
  if (!ty) return 0;        /* Void pointer */
  s = ty->next;             /* First element always just a name */
  do {
    if (strcmp(s->name,c) == 0) {
      if (s == ty->next) return s;
      /* Move s to the top of the linked list */
      s->prev->next = s->next;
      if (s->next) {
        s->next->prev = s->prev;
      }
      /* Insert s as second element in the list */
      s->next = ty->next;
      if (ty->next) ty->next->prev = s;
      ty->next = s;
      s->prev = ty;
      return s;
    }
    s = s->next;
  } while (s && (s != ty->next));
  return 0;
}

/* Cast a pointer up an inheritance hierarchy */
SWIGRUNTIME(void *) 
SWIG_TypeCast(swig_type_info *ty, void *ptr) {
  if ((!ty) || (!ty->converter)) return ptr;
  return (*ty->converter)(ptr);
}

/* Dynamic pointer casting. Down an inheritance hierarchy */
SWIGRUNTIME(swig_type_info *) 
SWIG_TypeDynamicCast(swig_type_info *ty, void **ptr) {
  swig_type_info *lastty = ty;
  if (!ty || !ty->dcast) return ty;
  while (ty && (ty->dcast)) {
    ty = (*ty->dcast)(ptr);
    if (ty) lastty = ty;
  }
  return lastty;
}

/* Return the name associated with this type */
SWIGRUNTIME(const char *)
SWIG_TypeName(const swig_type_info *ty) {
  return ty->name;
}

/* Return the pretty name associated with this type,
   that is an unmangled type name in a form presentable to the user.
*/
SWIGRUNTIME(const char *)
SWIG_TypePrettyName(const swig_type_info *type) {
  /* The "str" field contains the equivalent pretty names of the
     type, separated by vertical-bar characters.  We choose
     to print the last name, as it is often (?) the most
     specific. */
  if (type->str != NULL) {
    const char *last_name = type->str;
    const char *s;
    for (s = type->str; *s; s++)
      if (*s == '|') last_name = s+1;
    return last_name;
  }
  else
    return type->name;
}

/* 
   Compare two type names skipping the space characters, therefore
   "char*" == "char *" and "Class<int>" == "Class<int >", etc.

   Return 0 when the two name types are equivalent, as in
   strncmp, but skipping ' '.
*/
static int
SWIG_TypeNameComp(const char *f1, const char *l1,
		  const char *f2, const char *l2) {
  for (;(f1 != l1) && (f2 != l2); ++f1, ++f2) {
    while ((*f1 == ' ') && (f1 != l1)) ++f1;
    while ((*f2 == ' ') && (f2 != l2)) ++f2;
    if (*f1 != *f2) return *f1 - *f2;
  }
  return (l1 - f1) - (l2 - f2);
}

/*
  Check type equivalence in a name list like <name1>|<name2>|...
*/
static int
SWIG_TypeEquiv(const char *nb, const char *tb) {
  int equiv = 0;
  const char* te = tb + strlen(tb);
  const char* ne = nb;
  while (!equiv && *ne) {
    for (nb = ne; *ne; ++ne) {
      if (*ne == '|') break;
    }
    equiv = SWIG_TypeNameComp(nb, ne, tb, te) == 0;
    if (*ne) ++ne;
  }
  return equiv;
}
  

/* Search for a swig_type_info structure */
SWIGRUNTIME(swig_type_info *)
SWIG_TypeQuery(const char *name) {
  swig_type_info *ty = *swig_type_list_handle;
  while (ty) {
    if (ty->str && (SWIG_TypeEquiv(ty->str,name))) return ty;
    if (ty->name && (strcmp(name,ty->name) == 0)) return ty;
    ty = ty->prev;
  }
  return 0;
}

/* Set the clientdata field for a type */
SWIGRUNTIME(void)
SWIG_TypeClientData(swig_type_info *ti, void *clientdata) {
  swig_type_info *tc, *equiv;
  if (ti->clientdata == clientdata) return;
  ti->clientdata = clientdata;
  equiv = ti->next;
  while (equiv) {
    if (!equiv->converter) {
      tc = *swig_type_list_handle;
      while (tc) {
        if ((strcmp(tc->name, equiv->name) == 0))
          SWIG_TypeClientData(tc,clientdata);
        tc = tc->prev;
      }
    }
    equiv = equiv->next;
  }
}

/* Pack binary data into a string */
SWIGRUNTIME(char *)
SWIG_PackData(char *c, void *ptr, int sz) {
  static char hex[17] = "0123456789abcdef";
  unsigned char *u = (unsigned char *) ptr;
  const unsigned char *eu =  u + sz;
  register unsigned char uu;
  for (; u != eu; ++u) {
    uu = *u;
    *(c++) = hex[(uu & 0xf0) >> 4];
    *(c++) = hex[uu & 0xf];
  }
  return c;
}

/* Unpack binary data from a string */
SWIGRUNTIME(char *)
SWIG_UnpackData(char *c, void *ptr, int sz) {
  register unsigned char uu = 0;
  register int d;
  unsigned char *u = (unsigned char *) ptr;
  const unsigned char *eu =  u + sz;
  for (; u != eu; ++u) {
    d = *(c++);
    if ((d >= '0') && (d <= '9'))
      uu = ((d - '0') << 4);
    else if ((d >= 'a') && (d <= 'f'))
      uu = ((d - ('a'-10)) << 4);
    d = *(c++);
    if ((d >= '0') && (d <= '9'))
      uu |= (d - '0');
    else if ((d >= 'a') && (d <= 'f'))
      uu |= (d - ('a'-10));
    *u = uu;
  }
  return c;
}

#endif

#ifdef __cplusplus
}
#endif

/* rubydec.swg -*- c -*- */
#ifdef __cplusplus
extern "C" {
#endif

SWIGIMPORT(void)   SWIG_Ruby_InitRuntime(void);
SWIGIMPORT(void)   SWIG_Ruby_define_class(swig_type_info *);
SWIGIMPORT(VALUE)  SWIG_Ruby_NewPointerObj(void *, swig_type_info *, int);
SWIGIMPORT(VALUE)  SWIG_Ruby_NewClassInstance(VALUE, swig_type_info *);
SWIGIMPORT(char *) SWIG_Ruby_MangleStr(VALUE);
SWIGIMPORT(int)    SWIG_Ruby_ConvertPtr(VALUE, void**, swig_type_info *, int);
SWIGIMPORT(void *) SWIG_Ruby_MustGetPtr(VALUE, swig_type_info *, int, int);
SWIGIMPORT(int)    SWIG_Ruby_CheckConvert(VALUE, swig_type_info *);
SWIGIMPORT(VALUE)  SWIG_Ruby_NewPackedObj(void *ptr, int sz, swig_type_info *type);
SWIGIMPORT(void)   SWIG_Ruby_ConvertPacked(VALUE obj, void *ptr, int sz, swig_type_info *ty, int flags);

#ifdef __cplusplus
}
#endif


/* -------- TYPES TABLE (BEGIN) -------- */

#define  SWIGTYPE_p_FXMat4d swig_types[0] 
#define  SWIGTYPE_p_FXVec4d swig_types[1] 
#define  SWIGTYPE_p_FXMat4f swig_types[2] 
#define  SWIGTYPE_p_FXVec4f swig_types[3] 
#define  SWIGTYPE_p_FXfloat swig_types[4] 
#define  SWIGTYPE_p_FXMat3d swig_types[5] 
#define  SWIGTYPE_p_FXComposite swig_types[6] 
#define  SWIGTYPE_p_FXVec3d swig_types[7] 
#define  SWIGTYPE_p_FXGLViewer swig_types[8] 
#define  SWIGTYPE_p_FXMat3f swig_types[9] 
#define  SWIGTYPE_p_FXViewport swig_types[10] 
#define  SWIGTYPE_p_FXId swig_types[11] 
#define  SWIGTYPE_p_FXVec3f swig_types[12] 
#define  SWIGTYPE_p_FXWindow swig_types[13] 
#define  SWIGTYPE_p_FXCanvas swig_types[14] 
#define  SWIGTYPE_p_FXGLCanvas swig_types[15] 
#define  SWIGTYPE_p_FXRanged swig_types[16] 
#define  SWIGTYPE_p_FXSphered swig_types[17] 
#define  SWIGTYPE_p_FXVec2d swig_types[18] 
#define  SWIGTYPE_p_FXSpheref swig_types[19] 
#define  SWIGTYPE_p_FXRangef swig_types[20] 
#define  SWIGTYPE_p_FXVec2f swig_types[21] 
#define  SWIGTYPE_p_FXObject swig_types[22] 
#define  SWIGTYPE_p_FXGLObject swig_types[23] 
#define  SWIGTYPE_p_FXGLContext swig_types[24] 
#define  SWIGTYPE_p_FXMaterial swig_types[25] 
#define  SWIGTYPE_p_FXQuatd swig_types[26] 
#define  SWIGTYPE_p_FXQuatf swig_types[27] 
#define  SWIGTYPE_p_FXGLShape swig_types[28] 
#define  SWIGTYPE_p_FXDrawable swig_types[29] 
#define  SWIGTYPE_p_FXStream swig_types[30] 
#define  SWIGTYPE_p_FXApp swig_types[31] 
#define  SWIGTYPE_p_FXLight swig_types[32] 
#define  SWIGTYPE_p_FXFont swig_types[33] 
#define  SWIGTYPE_p_FXGLVisual swig_types[34] 
#define  SWIGTYPE_p_FXVisual swig_types[35] 
#define  SWIGTYPE_p_FXuint swig_types[36] 
static swig_type_info *swig_types[38];

/* -------- TYPES TABLE (END) -------- */

#define SWIG_init    Init_fx3d
#define SWIG_name    "Fx3d"


static void SWIG_AsVal(VALUE obj, int *val)
{
    *val = (int) NUM2INT(obj);
}


#include "FXRbCommon.h"


inline FXColor to_FXColor(VALUE obj){
  if(TYPE(obj)==T_STRING){
    return fxcolorfromname(StringValuePtr(obj));
    }
  else if(TYPE(obj)==T_SYMBOL){
    return fxcolorfromname(rb_id2name(SYM2ID(obj)));
    }
  else{
    return NUM2ULONG(obj);
    }
  }


inline FXString to_FXString(VALUE obj){
  if(!NIL_P(obj)){
    Check_Type(obj,T_STRING);
    return FXString(STR2CSTR(obj));
    }
  else{
    return FXString::null;
    }
  }


inline FXbool to_FXbool(VALUE obj){
  if (obj == Qtrue || obj == Qfalse){
    return (obj == Qtrue) ? TRUE : FALSE;
    }
  else{
    return static_cast<FXbool>(NUM2UINT(obj));
    }
  }


static swig_type_info* FXEventTypeInfo=0;

inline void* to_FXEvent(VALUE obj){
  void* ptr;
  if(!FXEventTypeInfo){
    FXEventTypeInfo=SWIG_TypeQuery("FXEvent *");
    FXASSERT(FXEventTypeInfo!=0);
    }
  SWIG_ConvertPtr(obj,&ptr,FXEventTypeInfo,1);
  return ptr;
  }

FXfloat FXVec2f___getitem__(FXVec2f const *self,FXint i){
      if(i<0||i>1) rb_raise(rb_eIndexError,"index %d out of bounds",i);
      return (*self)[i];
      }
FXfloat FXVec2f___setitem__(FXVec2f *self,FXint i,FXfloat f){
      if(i<0||i>1) rb_raise(rb_eIndexError,"index %d out of bounds",i);
      (*self)[i]=f;
      return f;
      }
FXVec2f FXVec2f_operator_Ss_(FXVec2f const *self){ return -(*self); }
FXVec2f FXVec2f_operator_Sa_(FXVec2f const *self,FXVec2f const &other){ return (*self)+other; }
FXVec2f FXVec2f_operator_Ss_(FXVec2f const *self,FXVec2f const &other){ return (*self)-other; }
FXVec2f FXVec2f_operator_Sm___SWIG_0(FXVec2f const *self,FXfloat n){ return (*self)*n; }
FXVec2f FXVec2f_operator_Sd_(FXVec2f const *self,FXfloat n){
      if(n==0.0f) rb_raise(rb_eZeroDivError,"divided by 0");
      return (*self)/n;
      }
FXfloat FXVec2f_operator_Sm___SWIG_1(FXVec2f const *self,FXVec2f const &other){ return (*self)*other; }
FXfloat FXVec2f_dot(FXVec2f const *self,FXVec2f const &other){ return (*self)*other; }
bool FXVec2f_operator_Se__Se_(FXVec2f const *self,FXVec2f const &other){ return (*self)==other; }
FXfloat FXVec2f_len2(FXVec2f const *self){ return len2(*self); }
FXfloat FXVec2f_len(FXVec2f const *self){ return len(*self); }
FXVec2f FXVec2f_normalize(FXVec2f const *self){ return normalize(*self); }
FXVec2f FXVec2f_lo(FXVec2f const *self,FXVec2f const &other){ return lo(*self,other); }
FXVec2f FXVec2f_hi(FXVec2f const *self,FXVec2f const &other){ return hi(*self,other); }
VALUE FXVec2f_to_a(FXVec2f const *self){ return rb_ary_new3(2,rb_float_new(self->x),rb_float_new(self->y)); }
FXString FXVec2f_to_s(FXVec2f const *self){ return FXStringFormat("[%g, %g]",self->x,self->y); }

swig_class cFXVec2f;
FXdouble FXVec2d___getitem__(FXVec2d const *self,FXint i){
      if(i<0||i>1) rb_raise(rb_eIndexError,"index %d out of bounds",i);
      return (*self)[i];
      }
FXdouble FXVec2d___setitem__(FXVec2d *self,FXint i,FXdouble d){
      if(i<0||i>1) rb_raise(rb_eIndexError,"index %d out of bounds",i);
      (*self)[i]=d;
      return d;
      }
FXVec2d FXVec2d_operator_Ss_(FXVec2d const *self){ return -(*self); }
FXVec2d FXVec2d_operator_Sa_(FXVec2d const *self,FXVec2d const &other){ return (*self)+other; }
FXVec2d FXVec2d_operator_Ss_(FXVec2d const *self,FXVec2d const &other){ return (*self)-other; }
FXVec2d FXVec2d_operator_Sm___SWIG_0(FXVec2d const *self,FXdouble n){ return (*self)*n; }
FXVec2d FXVec2d_operator_Sd_(FXVec2d const *self,FXdouble n){
      if(n==0.0) rb_raise(rb_eZeroDivError,"divided by 0");
      return (*self)/n;
      }
FXdouble FXVec2d_operator_Sm___SWIG_1(FXVec2d const *self,FXVec2d const &other){ return (*self)*other; }
FXdouble FXVec2d_dot(FXVec2d const *self,FXVec2d const &other){ return (*self)*other; }
bool FXVec2d_operator_Se__Se_(FXVec2d const *self,FXVec2d const &other){ return (*self)==other; }
FXdouble FXVec2d_len2(FXVec2d const *self){ return len2(*self); }
FXdouble FXVec2d_len(FXVec2d const *self){ return len(*self); }
FXVec2d FXVec2d_normalize(FXVec2d const *self){ return normalize(*self); }
FXVec2d FXVec2d_lo(FXVec2d const *self,FXVec2d const &other){ return lo(*self,other); }
FXVec2d FXVec2d_hi(FXVec2d const *self,FXVec2d const &other){ return hi(*self,other); }
VALUE FXVec2d_to_a(FXVec2d const *self){ return rb_ary_new3(2,rb_float_new(self->x),rb_float_new(self->y)); }
FXString FXVec2d_to_s(FXVec2d const *self){ return FXStringFormat("[%g, %g]",self->x,self->y); }

swig_class cFXVec2d;
FXfloat FXVec3f___getitem__(FXVec3f const *self,FXint i){
      if(i<0||i>2) rb_raise(rb_eIndexError,"index %d out of bounds",i);
      return (*self)[i];
      }
FXfloat FXVec3f___setitem__(FXVec3f *self,FXint i,FXfloat f){
      if(i<0||i>2) rb_raise(rb_eIndexError,"index %d out of bounds",i);
      (*self)[i]=f;
      return f;
      }
FXVec3f FXVec3f_operator_Ss_(FXVec3f const *self){ return -(*self); }
FXVec3f FXVec3f_operator_Sa_(FXVec3f const *self,FXVec3f const &other){ return (*self)+other; }
FXVec3f FXVec3f_operator_Ss_(FXVec3f const *self,FXVec3f const &other){ return (*self)-other; }
FXVec3f FXVec3f_operator_Sm___SWIG_0(FXVec3f const *self,FXfloat n){ return (*self)*n; }
FXVec3f FXVec3f_operator_Sd_(FXVec3f const *self,FXfloat n){
      if(n==0.0f) rb_raise(rb_eZeroDivError,"divided by 0");
      return (*self)/n;
      }
FXfloat FXVec3f_operator_Sm___SWIG_1(FXVec3f const *self,FXVec3f const &other){ return (*self)*other; }
FXfloat FXVec3f_dot(FXVec3f const *self,FXVec3f const &other){ return (*self)*other; }
FXVec3f FXVec3f_operator_Sx_(FXVec3f const *self,FXVec3f const &other){ return (*self)^other; }
FXVec3f FXVec3f_cross(FXVec3f const *self,FXVec3f const &other){ return (*self)^other; }
bool FXVec3f_operator_Se__Se_(FXVec3f const *self,FXVec3f const &other){ return (*self)==other; }
FXfloat FXVec3f_len2(FXVec3f const *self){ return len2(*self); }
FXfloat FXVec3f_len(FXVec3f const *self){ return len(*self); }
FXVec3f FXVec3f_normalize(FXVec3f const *self){ return normalize(*self); }
FXVec3f FXVec3f_lo(FXVec3f const *self,FXVec3f const &other){ return lo(*self,other); }
FXVec3f FXVec3f_hi(FXVec3f const *self,FXVec3f const &other){ return hi(*self,other); }
VALUE FXVec3f_to_a(FXVec3f const *self){ return rb_ary_new3(3,rb_float_new(self->x),rb_float_new(self->y),rb_float_new(self->z)); }
FXString FXVec3f_to_s(FXVec3f const *self){ return FXStringFormat("[%g, %g, %g]",self->x,self->y,self->z); }

swig_class cFXVec3f;
FXdouble FXVec3d___getitem__(FXVec3d const *self,FXint i){
      if(i<0||i>2) rb_raise(rb_eIndexError,"index %d out of bounds",i);
      return (*self)[i];
      }
FXdouble FXVec3d___setitem__(FXVec3d *self,FXint i,FXdouble d){
      if(i<0||i>2) rb_raise(rb_eIndexError,"index %d out of bounds",i);
      (*self)[i]=d;
      return d;
      }
FXVec3d FXVec3d_operator_Ss_(FXVec3d const *self){ return -(*self); }
FXVec3d FXVec3d_operator_Sa_(FXVec3d const *self,FXVec3d const &other){ return (*self)+other; }
FXVec3d FXVec3d_operator_Ss_(FXVec3d const *self,FXVec3d const &other){ return (*self)-other; }
FXVec3d FXVec3d_operator_Sm___SWIG_0(FXVec3d const *self,FXdouble n){ return (*self)*n; }
FXVec3d FXVec3d_operator_Sd_(FXVec3d const *self,FXdouble n){
      if(n==0.0) rb_raise(rb_eZeroDivError,"divided by 0");
      return (*self)/n;
      }
FXdouble FXVec3d_operator_Sm___SWIG_1(FXVec3d const *self,FXVec3d const &other){ return (*self)*other; }
FXdouble FXVec3d_dot(FXVec3d const *self,FXVec3d const &other){ return (*self)*other; }
FXVec3d FXVec3d_operator_Sx_(FXVec3d const *self,FXVec3d const &other){ return (*self)^other; }
FXVec3d FXVec3d_cross(FXVec3d const *self,FXVec3d const &other){ return (*self)^other; }
bool FXVec3d_operator_Se__Se_(FXVec3d const *self,FXVec3d const &other){ return (*self)==other; }
FXdouble FXVec3d_len2(FXVec3d const *self){ return len2(*self); }
FXdouble FXVec3d_len(FXVec3d const *self){ return len(*self); }
FXVec3d FXVec3d_normalize(FXVec3d const *self){ return normalize(*self); }
FXVec3d FXVec3d_lo(FXVec3d const *self,FXVec3d const &other){ return lo(*self,other); }
FXVec3d FXVec3d_hi(FXVec3d const *self,FXVec3d const &other){ return hi(*self,other); }
VALUE FXVec3d_to_a(FXVec3d const *self){ return rb_ary_new3(3,rb_float_new(self->x),rb_float_new(self->y),rb_float_new(self->z)); }
FXString FXVec3d_to_s(FXVec3d const *self){ return FXStringFormat("[%g, %g, %g]",self->x,self->y,self->z); }

swig_class cFXVec3d;
FXfloat FXVec4f___getitem__(FXVec4f const *self,FXint i){
      if(i<0||i>3) rb_raise(rb_eIndexError,"index %d out of bounds",i);
      return (*self)[i];
      }
FXfloat FXVec4f___setitem__(FXVec4f *self,FXint i,FXfloat f){
      if(i<0||i>3) rb_raise(rb_eIndexError,"index %d out of bounds",i);
      (*self)[i]=f;
      return f;
      }
FXVec4f FXVec4f_operator_Ss_(FXVec4f const *self){ return -(*self); }
FXVec4f FXVec4f_operator_Sa_(FXVec4f const *self,FXVec4f const &b){ return (*self)+b; }
FXVec4f FXVec4f_operator_Ss_(FXVec4f const *self,FXVec4f const &b){ return (*self)-b; }
FXVec4f FXVec4f_operator_Sm___SWIG_0(FXVec4f const *self,FXfloat n){ return (*self)*n; }
FXVec4f FXVec4f_operator_Sd_(FXVec4f const *self,FXfloat n){
      if(n==0.0f) rb_raise(rb_eZeroDivError,"divided by 0");
      return (*self)/n;
      }
FXfloat FXVec4f_operator_Sm___SWIG_1(FXVec4f const *self,FXVec4f const &a){ return (*self)*a; }
FXfloat FXVec4f_dot(FXVec4f const *self,FXVec4f const &a){ return (*self)*a; }
bool FXVec4f_operator_Se__Se___SWIG_0(FXVec4f const *self,FXVec4f const &b){ return (*self == b); }
bool FXVec4f_operator_Se__Se___SWIG_1(FXVec4f const *self,FXfloat n){ return (*self == n); }
FXfloat FXVec4f_len(FXVec4f const *self){ return len(*self); }
FXfloat FXVec4f_len2(FXVec4f const *self){ return len2(*self); }
FXVec4f FXVec4f_normalize(FXVec4f const *self){ return normalize(*self); }
FXVec4f FXVec4f_lo(FXVec4f const *self,FXVec4f const &other){ return lo(*self,other); }
FXVec4f FXVec4f_hi(FXVec4f const *self,FXVec4f const &other){ return hi(*self,other); }
VALUE FXVec4f_to_a(FXVec4f const *self){ return rb_ary_new3(4,rb_float_new(self->x),rb_float_new(self->y),rb_float_new(self->z),rb_float_new(self->w)); }
FXString FXVec4f_to_s(FXVec4f const *self){ return FXStringFormat("[%g, %g, %g, %g]",self->x,self->y,self->z,self->w); }

swig_class cFXVec4f;
FXdouble FXVec4d___getitem__(FXVec4d const *self,FXint i){
      if(i<0||i>3) rb_raise(rb_eIndexError,"index %d out of bounds",i);
      return (*self)[i];
      }
FXdouble FXVec4d___setitem__(FXVec4d *self,FXint i,FXdouble d){
      if(i<0||i>3) rb_raise(rb_eIndexError,"index %d out of bounds",i);
      (*self)[i]=d;
      return d;
      }
FXVec4d FXVec4d_operator_Ss_(FXVec4d const *self){ return -(*self); }
FXVec4d FXVec4d_operator_Sa_(FXVec4d const *self,FXVec4d const &other){ return (*self)+other; }
FXVec4d FXVec4d_operator_Ss_(FXVec4d const *self,FXVec4d const &other){ return (*self)-other; }
FXVec4d FXVec4d_operator_Sm___SWIG_0(FXVec4d const *self,FXdouble n){ return (*self)*n; }
FXVec4d FXVec4d_operator_Sd_(FXVec4d const *self,FXdouble n){
      if(n==0.0) rb_raise(rb_eZeroDivError,"divided by 0");
      return (*self)/n;
      }
FXdouble FXVec4d_operator_Sm___SWIG_1(FXVec4d const *self,FXVec4d const &other){ return (*self)*other; }
FXdouble FXVec4d_dot(FXVec4d const *self,FXVec4d const &other){ return (*self)*other; }
bool FXVec4d_operator_Se__Se_(FXVec4d const *self,FXVec4d const &other){ return (*self)==other; }
FXdouble FXVec4d_len2(FXVec4d const *self){ return len2(*self); }
FXdouble FXVec4d_len(FXVec4d const *self){ return len(*self); }
FXVec4d FXVec4d_normalize(FXVec4d const *self){ return normalize(*self); }
FXVec4d FXVec4d_lo(FXVec4d const *self,FXVec4d const &other){ return lo(*self,other); }
FXVec4d FXVec4d_hi(FXVec4d const *self,FXVec4d const &other){ return hi(*self,other); }
VALUE FXVec4d_to_a(FXVec4d const *self){ return rb_ary_new3(4,rb_float_new(self->x),rb_float_new(self->y),rb_float_new(self->z),rb_float_new(self->w)); }
FXString FXVec4d_to_s(FXVec4d const *self){ return FXStringFormat("[%g, %g, %g, %g]",self->x,self->y,self->z,self->w); }

swig_class cFXVec4d;
VALUE FXQuatf_getAxisAngle(FXQuatf const *self){
      FXVec3f axis;
      FXfloat phi;
      self->getAxisAngle(axis,phi);
      return rb_ary_new3(2,rb_ary_new3(3,rb_float_new(axis.x),rb_float_new(axis.y),rb_float_new(axis.z)),rb_float_new(phi));
      }
VALUE FXQuatf_getRollPitchYaw(FXQuatf const *self){
      FXfloat roll,pitch,yaw;
      self->getRollPitchYaw(roll,pitch,yaw);
      return rb_ary_new3(3,rb_float_new(roll),rb_float_new(pitch),rb_float_new(yaw));
      }
FXQuatf FXQuatf_exp(FXQuatf const *self){ return exp(*self); }
FXQuatf FXQuatf_log(FXQuatf const *self){ return log(*self); }
FXQuatf FXQuatf_invert(FXQuatf const *self){ return invert(*self); }
FXQuatf FXQuatf_unitinvert(FXQuatf const *self){ return unitinvert(*self); }
FXQuatf FXQuatf_conj(FXQuatf const *self){ return conj(*self); }
FXQuatf FXQuatf_operator_Sm___SWIG_0(FXQuatf const *self,FXQuatf const &other){ return (*self)*other; }
FXVec3f FXQuatf_operator_Sm___SWIG_1(FXQuatf const *self,FXVec3f const &vec){ return (*self)*vec; }
FXQuatf FXQuatf_arc(FXVec3f const &a,FXVec3f const &b){ return arc(a,b); }
FXQuatf FXQuatf_lerp(FXQuatf const &u,FXQuatf const &v,FXfloat f){ return lerp(u,v,f); }

swig_class cFXQuatf;
VALUE FXQuatd_getAxisAngle(FXQuatd const *self){
      FXVec3d axis;
      FXdouble phi;
      self->getAxisAngle(axis,phi);
      return rb_ary_new3(2,rb_ary_new3(3,rb_float_new(axis.x),rb_float_new(axis.y),rb_float_new(axis.z)),rb_float_new(phi));
      }
VALUE FXQuatd_getRollPitchYaw(FXQuatd const *self){
      FXdouble roll,pitch,yaw;
      self->getRollPitchYaw(roll,pitch,yaw);
      return rb_ary_new3(3,rb_float_new(roll),rb_float_new(pitch),rb_float_new(yaw));
      }
FXQuatd FXQuatd_exp(FXQuatd const *self){ return exp(*self); }
FXQuatd FXQuatd_log(FXQuatd const *self){ return log(*self); }
FXQuatd FXQuatd_invert(FXQuatd const *self){ return invert(*self); }
FXQuatd FXQuatd_unitinvert(FXQuatd const *self){ return unitinvert(*self); }
FXQuatd FXQuatd_conj(FXQuatd const *self){ return conj(*self); }
FXQuatd FXQuatd_operator_Sm___SWIG_0(FXQuatd const *self,FXQuatd const &other){ return (*self)*other; }
FXVec3d FXQuatd_operator_Sm___SWIG_1(FXQuatd const *self,FXVec3d const &vec){ return (*self)*vec; }
FXQuatd FXQuatd_arc(FXVec3d const &a,FXVec3d const &b){ return arc(a,b); }
FXQuatd FXQuatd_lerp(FXQuatd const &u,FXQuatd const &v,FXdouble f){ return lerp(u,v,f); }

swig_class cFXQuatd;
FXVec3f const &FXMat3f___getitem__(FXMat3f const *self,FXint i){
      if(i<0 || i>2) rb_raise(rb_eIndexError,"index %d out of bounds",i);
      return (*self)[i];
      }
FXVec3f &FXMat3f___setitem__(FXMat3f *self,FXint i,FXVec3d const &other){
      if(i<0 || i>2) rb_raise(rb_eIndexError,"index %d out of bounds",i);
      (*self)[i]=other;
      return (*self)[i];
      }
FXMat3f FXMat3f_operator_Sa_(FXMat3f const *self,FXMat3f const &other){ return (*self)+other; }
FXMat3f FXMat3f_operator_Ss_(FXMat3f const *self,FXMat3f const &other){ return (*self)-other; }
FXMat3f FXMat3f_operator_Ss_(FXMat3f const *self){ return -(*self); }
FXMat3f FXMat3f_operator_Sm___SWIG_0(FXMat3f const *self,FXMat3f const &other){ return (*self)*other; }
FXMat3f FXMat3f_operator_Sm___SWIG_1(FXMat3f const *self,FXfloat x){ return (*self)*x; }
FXMat3f FXMat3f_operator_Sd_(FXMat3f const *self,FXfloat x){
      if(x==0.0f) rb_raise(rb_eZeroDivError,"divided by 0");
      return (*self)/x;
      }
FXVec3f FXMat3f_operator_Sm___SWIG_2(FXMat3f const *self,FXVec3f const &other){ return (*self)*other; }
FXVec2f FXMat3f_operator_Sm___SWIG_3(FXMat3f const *self,FXVec2f const &other){ return (*self)*other; }
FXfloat FXMat3f_det(FXMat3f const *self){ return det(*self); }
FXMat3f FXMat3f_transpose(FXMat3f const *self){ return transpose(*self); }
FXMat3f FXMat3f_invert(FXMat3f const *self){ return invert(*self); }

swig_class cFXMat3f;
FXVec3d const &FXMat3d___getitem__(FXMat3d const *self,FXint i){
      if(i<0 || i>2) rb_raise(rb_eIndexError,"index %d out of bounds",i);
      return (*self)[i];
      }
FXVec3d &FXMat3d___setitem__(FXMat3d *self,FXint i,FXVec3d const &other){
      if(i<0 || i>2) rb_raise(rb_eIndexError,"index %d out of bounds",i);
      (*self)[i]=other;
      return (*self)[i];
      }
FXMat3d FXMat3d_operator_Sa_(FXMat3d const *self,FXMat3d const &other){ return (*self)+other; }
FXMat3d FXMat3d_operator_Ss_(FXMat3d const *self,FXMat3d const &other){ return (*self)-other; }
FXMat3d FXMat3d_operator_Ss_(FXMat3d const *self){ return -(*self); }
FXMat3d FXMat3d_operator_Sm___SWIG_0(FXMat3d const *self,FXMat3d const &other){ return (*self)*other; }
FXMat3d FXMat3d_operator_Sm___SWIG_1(FXMat3d const *self,FXdouble x){ return (*self)*x; }
FXMat3d FXMat3d_operator_Sd_(FXMat3d const *self,FXdouble x){
      if(x==0.0) rb_raise(rb_eZeroDivError,"divided by 0");
      return (*self)/x;
      }
FXVec3d FXMat3d_operator_Sm___SWIG_2(FXMat3d const *self,FXVec3d const &other){ return (*self)*other; }
FXVec2d FXMat3d_operator_Sm___SWIG_3(FXMat3d const *self,FXVec2d const &other){ return (*self)*other; }
FXdouble FXMat3d_det(FXMat3d const *self){ return det(*self); }
FXMat3d FXMat3d_transpose(FXMat3d const *self){ return transpose(*self); }
FXMat3d FXMat3d_invert(FXMat3d const *self){ return invert(*self); }

swig_class cFXMat3d;
FXVec4f const &FXMat4f___getitem__(FXMat4f const *self,FXint i){
      if(i<0 || i>3) rb_raise(rb_eIndexError,"index %d out of bounds",i);
      return (*self)[i];
      }
FXVec4f &FXMat4f___setitem__(FXMat4f *self,FXint i,FXVec3d const &other){
      if(i<0 || i>3) rb_raise(rb_eIndexError,"index %d out of bounds",i);
      (*self)[i]=other;
      return (*self)[i];
      }
FXMat4f FXMat4f_operator_Sa_(FXMat4f const *self,FXMat4f const &other){ return (*self)+other; }
FXMat4f FXMat4f_operator_Ss_(FXMat4f const *self,FXMat4f const &other){ return (*self)-other; }
FXMat4f FXMat4f_operator_Sm___SWIG_0(FXMat4f const *self,FXMat4f const &other){ return (*self)*other; }
FXMat4f FXMat4f_operator_Sm___SWIG_1(FXMat4f const *self,FXfloat x){ return (*self)*x; }
FXVec4f FXMat4f_operator_Sm___SWIG_2(FXMat4f const *self,FXVec4f const &other){ return (*self)*other; }
FXVec3f FXMat4f_operator_Sm___SWIG_3(FXMat4f const *self,FXVec3f const &other){ return (*self)*other; }
FXMat4f FXMat4f_operator_Sd_(FXMat4f const *self,FXfloat x){
      if(x==0.0f) rb_raise(rb_eZeroDivError,"divided by 0");
      return (*self)/x;
      }
FXMat4f FXMat4f_operator_Ss_(FXMat4f const *self){ return -(*self); }
FXfloat FXMat4f_det(FXMat4f const *self){
      return det(*self);
      }
FXMat4f FXMat4f_transpose(FXMat4f const *self){
      return transpose(*self);
      }
FXMat4f FXMat4f_invert(FXMat4f const *self){
      return invert(*self);
      }
FXString FXMat4f_to_s(FXMat4f const *self){
      const FXMat4f& m = *self;
      return FXStringFormat("[[%g, %g, %g, %g], [%g, %g, %g, %g], [%g, %g, %g, %g], [%g, %g, %g, %g]]",m[0][0],m[0][1],m[0][2],m[0][3],m[1][0],m[1][1],m[1][2],m[1][3],m[2][0],m[2][1],m[2][2],m[2][3],m[3][0],m[3][1],m[3][2],m[3][3]);
      }

swig_class cFXMat4f;
FXVec4d const &FXMat4d___getitem__(FXMat4d const *self,FXint i){
      if(i<0 || i>3) rb_raise(rb_eIndexError,"index %d out of bounds",i);
      return (*self)[i];
      }
FXVec4d &FXMat4d___setitem__(FXMat4d *self,FXint i,FXVec3d const &other){
      if(i<0 || i>3) rb_raise(rb_eIndexError,"index %d out of bounds",i);
      (*self)[i]=other;
      return (*self)[i];
      }
FXMat4d FXMat4d_operator_Sa_(FXMat4d const *self,FXMat4d const &other){ return (*self)+other; }
FXMat4d FXMat4d_operator_Ss_(FXMat4d const *self,FXMat4d const &other){ return (*self)-other; }
FXMat4d FXMat4d_operator_Ss_(FXMat4d const *self){ return -(*self); }
FXMat4d FXMat4d_operator_Sm___SWIG_0(FXMat4d const *self,FXMat4d const &other){ return (*self)*other; }
FXMat4d FXMat4d_operator_Sm___SWIG_1(FXMat4d const *self,FXdouble x){ return (*self)*x; }
FXMat4d FXMat4d_operator_Sd_(FXMat4d const *self,FXdouble x){
      if(x==0.0) rb_raise(rb_eZeroDivError,"divided by 0");
      return (*self)/x;
      }
FXVec4d FXMat4d_operator_Sm___SWIG_2(FXMat4d const *self,FXVec4d const &other){ return (*self)*other; }
FXVec3d FXMat4d_operator_Sm___SWIG_3(FXMat4d const *self,FXVec3d const &v){ return (*self)*v; }
FXdouble FXMat4d_det(FXMat4d const *self){ return det(*self); }
FXMat4d FXMat4d_transpose(FXMat4d const *self){ return transpose(*self); }
FXMat4d FXMat4d_invert(FXMat4d const *self){ return invert(*self); }

swig_class cFXMat4d;
FXVec3f &FXRangef___getitem__(FXRangef *self,FXint i){
      if(i<0||1<i){
        rb_raise(rb_eIndexError,"index %d out of bounds",i);
        }
      return (*self)[i];
      }
void FXRangef___setitem__(FXRangef *self,FXint i,FXVec3f &slice){
      if(i<0||1<i){
        rb_raise(rb_eIndexError,"index %d out of bounds",i);
        }
      (*self)[i]=slice;
      }
FXbool FXRangef_overlaps(FXRangef const *self,FXRangef const &other){
      return FX::overlap(*self,other);
      }
FXVec3f FXRangef_corner(FXRangef const *self,FXint c){
      if(c<0||7<c){
        rb_raise(rb_eIndexError,"corner index %d out of bounds",c);
        }
      return self->corner(c);
      }
FXRangef FXRangef_onion(FXRangef const *self,FXRangef const &other){
      return FX::unite(*self,other);
      }
FXRangef FXRangef_intersection(FXRangef const *self,FXRangef const &other){
      return FX::intersect(*self,other);
      }

swig_class cFXRangef;
FXVec3d &FXRanged___getitem__(FXRanged *self,FXint i){
      if(i<0||1<i){
        rb_raise(rb_eIndexError,"index %d out of bounds",i);
        }
      return (*self)[i];
      }
void FXRanged___setitem__(FXRanged *self,FXint i,FXVec3d &slice){
      if(i<0||1<i){
        rb_raise(rb_eIndexError,"index %d out of bounds",i);
        }
      (*self)[i]=slice;
      }
FXbool FXRanged_overlaps(FXRanged const *self,FXRanged const &other){
      return FX::overlap(*self,other);
      }
FXVec3d FXRanged_corner(FXRanged const *self,FXint c){
      if(c<0||7<c){
        rb_raise(rb_eIndexError,"corner index %d out of bounds",c);
        }
      return self->corner(c);
      }
FXRanged FXRanged_onion(FXRanged const *self,FXRanged const &other){
      return FX::unite(*self,other);
      }
FXRanged FXRanged_intersection(FXRanged const *self,FXRanged const &other){
      return FX::intersect(*self,other);
      }

swig_class cFXRanged;
FXbool FXSpheref_overlap__SWIG_0(FXSpheref const *self,FXRangef const &other){
      return overlap(*self,other);
      }
FXbool FXSpheref_overlap__SWIG_1(FXSpheref const *self,FXSpheref const &other){
      return overlap(*self,other);
      }

swig_class cFXSpheref;
FXbool FXSphered_overlap__SWIG_0(FXSphered const *self,FXRanged const &other){
      return overlap(*self,other);
      }
FXbool FXSphered_overlap__SWIG_1(FXSphered const *self,FXSphered const &other){
      return overlap(*self,other);
      }

swig_class cFXSphered;
FXGLVisual *new_FXGLVisual(FXApp *a,FXuint flags){
      return new FXRbGLVisual(a,flags);
      }
FXbool FXGLVisual_supported(FXApp *application){
      int major,minor;
      FXbool answer=FXGLVisual::supported(application,major,minor);
      return rb_ary_new3(3,answer?Qtrue:Qfalse,INT2NUM(major),INT2NUM(minor));
      }

swig_class cFXGLVisual;
static void free_FXGLVisual(FXGLVisual *);
FXGLContext *new_FXGLContext__SWIG_0(FXApp *a,FXGLVisual *vis){
      return new FXRbGLContext(a,vis);
      }
FXGLContext *new_FXGLContext__SWIG_1(FXApp *a,FXGLVisual *vis,FXGLContext *shared){
      return new FXRbGLContext(a,vis,shared);
      }

swig_class cFXGLContext;
static void free_FXGLContext(FXGLContext *);
FXGLCanvas *new_FXGLCanvas__SWIG_0(FXComposite *p,FXGLVisual *vis,FXObject *tgt,FXSelector sel,FXuint opts,FXint x,FXint y,FXint w,FXint h){
      return new FXRbGLCanvas(p,vis,tgt,sel,opts,x,y,w,h);
      }
FXGLCanvas *new_FXGLCanvas__SWIG_1(FXComposite *p,FXGLVisual *vis,FXGLCanvas *sharegroup,FXObject *tgt,FXSelector sel,FXuint opts,FXint x,FXint y,FXint w,FXint h){
      return new FXRbGLCanvas(p,vis,sharegroup,tgt,sel,opts,x,y,w,h);
      }
unsigned long FXGLCanvas_getCurrentContext(){
      return reinterpret_cast<unsigned long>(FXGLCanvas::getCurrentContext());
      }
unsigned long FXGLCanvas_getContext(FXGLCanvas const *self){
      return reinterpret_cast<unsigned long>(self->getContext());
      }

swig_class cFXGLCanvas;
static void free_FXGLCanvas(FXGLCanvas *);

static swig_type_info *FXGLCanvas_dynamic_cast(void **ptr) {
    FXGLCanvas **ppGLCanvas = reinterpret_cast<FXGLCanvas **>(ptr);
    FXGLViewer *pGLViewer=dynamic_cast<FXGLViewer*>(*ppGLCanvas);
    if(pGLViewer){
      *ptr=reinterpret_cast<void*>(pGLViewer);
      return SWIG_TypeQuery("FXGLViewer *");
      }
    return 0;
}


swig_class cFXViewport;
static void free_FXViewport(FXViewport *);

swig_class cFXLight;
static void free_FXLight(FXLight *);

swig_class cFXMaterial;
static void free_FXMaterial(FXMaterial *);
VALUE FXGLViewer_objectTypeName(){
      return to_ruby(FXGLViewer::objectTypeName);
      }
FXGLViewer *new_FXGLViewer__SWIG_0(FXComposite *p,FXGLVisual *vis,FXObject *tgt,FXSelector sel,FXuint opts,FXint x,FXint y,FXint w,FXint h){
      return new FXRbGLViewer(p,vis,tgt,sel,opts,x,y,w,h);
      }
FXGLViewer *new_FXGLViewer__SWIG_1(FXComposite *p,FXGLVisual *vis,FXGLViewer *sharegroup,FXObject *tgt,FXSelector sel,FXuint opts,FXint x,FXint y,FXint w,FXint h){
      return new FXRbGLViewer(p,vis,sharegroup,tgt,sel,opts,x,y,w,h);
      }
VALUE FXGLViewer_lasso(FXGLViewer *self,FXint x1,FXint y1,FXint x2,FXint y2){
      VALUE objects = rb_ary_new();
      FXGLObject** items = self->lasso(x1, y1, x2, y2);
      if (items) {
        register FXGLObject** p = items;
        while (*p) {
          rb_ary_push(objects, to_ruby(*p));
          p++;
        }
        FXFREE(&items);
      }
      return objects;
    }
FXViewport FXGLViewer_getViewport(FXGLViewer const *self){
      FXViewport v;
      self->getViewport(v);
      return v;
    }
VALUE FXGLViewer_eyeToScreen(FXGLViewer *self,FXVec3f e){
      FXint sx, sy;
      self->eyeToScreen(sx, sy, e);
      VALUE point = rb_ary_new();
      rb_ary_push(point, INT2NUM(sx));
      rb_ary_push(point, INT2NUM(sy));
      return point;
    }
FXMaterial FXGLViewer_getMaterial(FXGLViewer const *self){
      FXMaterial mtl;
      self->getMaterial(mtl);
      return mtl;
    }
VALUE FXGLViewer_getBoreVector(FXGLViewer *self,FXint sx,FXint sy){
      FXVec3f point, dir;
      self->getBoreVector(sx, sy, point, dir);

      VALUE pointArray = rb_ary_new();
      rb_ary_push(pointArray, rb_float_new(point[0]));
      rb_ary_push(pointArray, rb_float_new(point[1]));
      rb_ary_push(pointArray, rb_float_new(point[2]));

      VALUE dirArray = rb_ary_new();
      rb_ary_push(dirArray, rb_float_new(dir[0]));
      rb_ary_push(dirArray, rb_float_new(dir[1]));
      rb_ary_push(dirArray, rb_float_new(dir[2]));

      VALUE results = rb_ary_new();
      rb_ary_push(results, pointArray);
      rb_ary_push(results, dirArray);

      return results;
    }
VALUE FXGLViewer_readPixels(FXGLViewer *self,FXint x,FXint y,FXint w,FXint h){
      FXColor *buffer;
      VALUE pixels=Qnil;
      if(self->readPixels(buffer,x,y,w,h)){
	pixels=FXRbMakeColorArray(buffer,w,h);
	FXFREE(&buffer);
	}
      return pixels;
      }
VALUE FXGLViewer_readFeedback(FXGLViewer *self,FXint x,FXint y,FXint w,FXint h){
      FXfloat *buffer;
      FXint used, size;
      if (self->readFeedback(buffer,used,size,x,y,w,h)){
	VALUE results=rb_ary_new();
	for(FXint i=0;i<used;i++) rb_ary_push(results,rb_float_new(buffer[i]));
	FXFREE(&buffer);
	return results;
        }
      else{
	return Qnil;
        }
      }
void FXGLViewer_setZSortFunc(FXGLViewer *self,VALUE proc){
      }
VALUE FXGLViewer_getZSortFunc(FXGLViewer const *self){
      return Qnil;
      }
FXLight FXGLViewer_getLight(FXGLViewer const *self){
      FXLight lite;
      self->getLight(lite);
      return lite;
    }

swig_class cFXGLViewer;
static void free_FXGLViewer(FXGLViewer *);
FXGLObject *new_FXGLObject(){
      return new FXRbGLObject();
      }
FXGLObject *FXGLObject_identify(FXGLObject *self,FXuint *path,FXint n){
      return self->identify(path);
      }

swig_class cFXGLObject;
static void free_FXGLObject(FXGLObject *);

static swig_type_info *FXGLObject_dynamic_cast(void **ptr) {
    FXGLObject **ppGLObject = reinterpret_cast<FXGLObject **>(ptr);
    FXGLShape *pGLShape=dynamic_cast<FXGLShape*>(*ppGLObject);
    if(pGLShape){
      *ptr=reinterpret_cast<void*>(pGLShape);
      return SWIG_TypeQuery("FXGLShape *");
      }
    return 0;
}

FXGLShape *new_FXGLShape__SWIG_0(FXfloat x,FXfloat y,FXfloat z,FXuint opts){
      return new FXRbGLShape(x,y,z,opts);
      }
FXGLShape *new_FXGLShape__SWIG_1(FXfloat x,FXfloat y,FXfloat z,FXuint opts,FXMaterial const &front,FXMaterial const &back){
      return new FXRbGLShape(x,y,z,opts,front,back);
      }
FXGLObject *FXGLShape_identify(FXGLShape *self,FXuint *path,FXint n){
      return self->identify(path);
      }
FXVec3f FXGLShape_getPosition(FXGLShape const *self){
      FXASSERT(self->isMemberOf(FXMETACLASS(FXRbGLShape)));
      return dynamic_cast<const FXRbGLShape*>(self)->getPosition();
      }
void FXGLShape_setPosition(FXGLShape *self,FXVec3f const &pos){
      FXASSERT(self->isMemberOf(FXMETACLASS(FXRbGLShape)));
      dynamic_cast<FXRbGLShape*>(self)->setPosition(pos);
      }
FXMaterial FXGLShape_getMaterial(FXGLShape const *self,FXint side){
      FXMaterial mtl;
      self->getMaterial(side, mtl);
      return mtl;
      }
void FXGLShape_setRange(FXGLShape *self,FXRangef const &box){
      FXASSERT(self->isMemberOf(FXMETACLASS(FXRbGLShape)));
      dynamic_cast<FXRbGLShape*>(self)->setRange(box);
      }

swig_class cFXGLShape;
static void free_FXGLShape(FXGLShape *);
static VALUE _wrap_FXVec2f_x_set(int argc, VALUE *argv, VALUE self) { FXVec2f *arg1 = (FXVec2f *) 0 ; FXfloat arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXVec2f, 1); arg2 = (FXfloat) NUM2DBL(argv[0]);
    if (arg1) (arg1)->x = arg2; return Qnil; }
static VALUE _wrap_FXVec2f_x_get(int argc, VALUE *argv, VALUE self) { FXVec2f *arg1 = (FXVec2f *) 0 ; FXfloat result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXVec2f, 1); result = (FXfloat) ((arg1)->x);
    vresult = rb_float_new(result); return vresult; }
static VALUE _wrap_FXVec2f_y_set(int argc, VALUE *argv, VALUE self) { FXVec2f *arg1 = (FXVec2f *) 0 ; FXfloat arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXVec2f, 1); arg2 = (FXfloat) NUM2DBL(argv[0]);
    if (arg1) (arg1)->y = arg2; return Qnil; }
static VALUE _wrap_FXVec2f_y_get(int argc, VALUE *argv, VALUE self) { FXVec2f *arg1 = (FXVec2f *) 0 ; FXfloat result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXVec2f, 1); result = (FXfloat) ((arg1)->y);
    vresult = rb_float_new(result); return vresult; }
static VALUE _wrap_new_FXVec2f__SWIG_0(int argc, VALUE *argv, VALUE self) { FXVec2f *result; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc); { result = (FXVec2f *)new FXVec2f();
        DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result); if(rb_block_given_p()){ rb_yield(self); }  }  return self; }
static VALUE _wrap_new_FXVec2f__SWIG_1(int argc, VALUE *argv, VALUE self) { FXVec2f *arg1 = 0 ; FXVec2f *result;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXVec2f, 1); if (arg1 == NULL) rb_raise(rb_eTypeError, "null reference");
    { result = (FXVec2f *)new FXVec2f((FXVec2f const &)*arg1); DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result);
        if(rb_block_given_p()){ rb_yield(self); }  }  return self; }
static VALUE _wrap_new_FXVec2f__SWIG_2(int argc, VALUE *argv, VALUE self) { FXfloat *arg1 ; FXVec2f *result;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXfloat, 1); {
        result = (FXVec2f *)new FXVec2f((FXfloat const (*))arg1); DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result);
        if(rb_block_given_p()){ rb_yield(self); }  }  return self; }
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE _wrap_FXVec2f_allocate(VALUE self) {
#else
     static VALUE _wrap_FXVec2f_allocate(int argc, VALUE *argv, VALUE self) {
#endif
         VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_FXVec2f);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
         return vresult; }
static VALUE _wrap_new_FXVec2f__SWIG_3(int argc, VALUE *argv, VALUE self) { FXfloat arg1 ; FXfloat arg2 ; FXVec2f *result;
    if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    arg1 = (FXfloat) NUM2DBL(argv[0]); arg2 = (FXfloat) NUM2DBL(argv[1]); { result = (FXVec2f *)new FXVec2f(arg1,arg2);
        DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result); if(rb_block_given_p()){ rb_yield(self); }  }  return self; }
static VALUE _wrap_new_FXVec2f(int nargs, VALUE *args, VALUE self) { int argc; VALUE argv[2]; int ii; argc = nargs;
    for (ii = 0; (ii < argc) && (ii < 2); ii++) { argv[ii] = args[ii]; }  if (argc == 0) {
        return _wrap_new_FXVec2f__SWIG_0(nargs, args, self);}  if (argc == 1) { int _v; { void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXVec2f, 0) != -1)) ? 1 : 0; }
         if (_v) { return _wrap_new_FXVec2f__SWIG_1(nargs, args, self);}  }  if (argc == 1) { int _v; { void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXfloat, 0) != -1)) ? 1 : 0; }
         if (_v) { return _wrap_new_FXVec2f__SWIG_2(nargs, args, self);}  }  if (argc == 2) { int _v; {
            _v = ((TYPE(argv[0]) == T_FLOAT) || (TYPE(argv[0]) == T_FIXNUM) || (TYPE(argv[0]) == T_BIGNUM)) ? 1 : 0; } 
        if (_v) { { _v = ((TYPE(argv[1]) == T_FLOAT) || (TYPE(argv[1]) == T_FIXNUM) || (TYPE(argv[1]) == T_BIGNUM)) ? 1 : 0; } 
            if (_v) { return _wrap_new_FXVec2f__SWIG_3(nargs, args, self);}  }  } 
    rb_raise(rb_eArgError, "No matching function for overloaded 'new_FXVec2f'"); return Qnil; }
static VALUE _wrap_FXVec2f___getitem__(int argc, VALUE *argv, VALUE self) { FXVec2f *arg1 = (FXVec2f *) 0 ; FXint arg2 ;
    FXfloat result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXVec2f, 1); arg2 = NUM2INT(argv[0]);
    result = (FXfloat)FXVec2f___getitem__((FXVec2f const *)arg1,arg2); vresult = rb_float_new(result); return vresult; }
static VALUE _wrap_FXVec2f___setitem__(int argc, VALUE *argv, VALUE self) { FXVec2f *arg1 = (FXVec2f *) 0 ; FXint arg2 ;
    FXfloat arg3 ; FXfloat result; VALUE vresult = Qnil; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXVec2f, 1); arg2 = NUM2INT(argv[0]); arg3 = (FXfloat) NUM2DBL(argv[1]);
    result = (FXfloat)FXVec2f___setitem__(arg1,arg2,arg3); vresult = rb_float_new(result); return vresult; }
static VALUE _wrap_FXVec2f___neg__(int argc, VALUE *argv, VALUE self) { FXVec2f *arg1 = (FXVec2f *) 0 ; FXVec2f result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXVec2f, 1); result = FXVec2f_operator_Ss_((FXVec2f const *)arg1); {
        FXVec2f * resultptr; resultptr = new FXVec2f((FXVec2f &)result);
        vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_FXVec2f, 1); }  return vresult; }
static VALUE _wrap_FXVec2f___add__(int argc, VALUE *argv, VALUE self) { FXVec2f *arg1 = (FXVec2f *) 0 ; FXVec2f *arg2 = 0 ;
    FXVec2f result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXVec2f, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXVec2f, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    result = FXVec2f_operator_Sa_((FXVec2f const *)arg1,(FXVec2f const &)*arg2); { FXVec2f * resultptr;
        resultptr = new FXVec2f((FXVec2f &)result); vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_FXVec2f, 1); } 
    return vresult; }
static VALUE _wrap_FXVec2f___sub__(int argc, VALUE *argv, VALUE self) { FXVec2f *arg1 = (FXVec2f *) 0 ; FXVec2f *arg2 = 0 ;
    FXVec2f result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXVec2f, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXVec2f, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    result = FXVec2f_operator_Ss_((FXVec2f const *)arg1,(FXVec2f const &)*arg2); { FXVec2f * resultptr;
        resultptr = new FXVec2f((FXVec2f &)result); vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_FXVec2f, 1); } 
    return vresult; }
static VALUE _wrap_FXVec2f___mul____SWIG_0(int argc, VALUE *argv, VALUE self) { FXVec2f *arg1 = (FXVec2f *) 0 ; FXfloat arg2 ;
    FXVec2f result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXVec2f, 1); arg2 = (FXfloat) NUM2DBL(argv[0]);
    result = FXVec2f_operator_Sm___SWIG_0((FXVec2f const *)arg1,arg2); { FXVec2f * resultptr;
        resultptr = new FXVec2f((FXVec2f &)result); vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_FXVec2f, 1); } 
    return vresult; }
static VALUE _wrap_FXVec2f___div__(int argc, VALUE *argv, VALUE self) { FXVec2f *arg1 = (FXVec2f *) 0 ; FXfloat arg2 ;
    FXVec2f result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXVec2f, 1); arg2 = (FXfloat) NUM2DBL(argv[0]);
    result = FXVec2f_operator_Sd_((FXVec2f const *)arg1,arg2); { FXVec2f * resultptr;
        resultptr = new FXVec2f((FXVec2f &)result); vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_FXVec2f, 1); } 
    return vresult; }
static VALUE _wrap_FXVec2f___mul____SWIG_1(int argc, VALUE *argv, VALUE self) { FXVec2f *arg1 = (FXVec2f *) 0 ;
    FXVec2f *arg2 = 0 ; FXfloat result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXVec2f, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXVec2f, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    result = (FXfloat)FXVec2f_operator_Sm___SWIG_1((FXVec2f const *)arg1,(FXVec2f const &)*arg2);
    vresult = rb_float_new(result); return vresult; }
static VALUE _wrap_FXVec2f___mul__(int nargs, VALUE *args, VALUE self) { int argc; VALUE argv[3]; int ii; argc = nargs + 1;
    argv[0] = self; for (ii = 1; (ii < argc) && (ii < 2); ii++) { argv[ii] = args[ii-1]; }  if (argc == 2) { int _v; {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXVec2f, 0) != -1)) ? 1 : 0; }
         if (_v) { { void *ptr;
                _v = (NIL_P(argv[1]) || (TYPE(argv[1]) == T_DATA && SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_FXVec2f, 0) != -1)) ? 1 : 0; }
             if (_v) { return _wrap_FXVec2f___mul____SWIG_1(nargs, args, self);}  }  }  if (argc == 2) { int _v; { void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXVec2f, 0) != -1)) ? 1 : 0; }
         if (_v) { { _v = ((TYPE(argv[1]) == T_FLOAT) || (TYPE(argv[1]) == T_FIXNUM) || (TYPE(argv[1]) == T_BIGNUM)) ? 1 : 0; } 
            if (_v) { return _wrap_FXVec2f___mul____SWIG_0(nargs, args, self);}  }  } 
    rb_raise(rb_eArgError, "No matching function for overloaded 'FXVec2f___mul__'"); return Qnil; }
static VALUE _wrap_FXVec2f_dot(int argc, VALUE *argv, VALUE self) { FXVec2f *arg1 = (FXVec2f *) 0 ; FXVec2f *arg2 = 0 ;
    FXfloat result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXVec2f, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXVec2f, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    result = (FXfloat)FXVec2f_dot((FXVec2f const *)arg1,(FXVec2f const &)*arg2); vresult = rb_float_new(result);
    return vresult; }
static VALUE _wrap_FXVec2f___eq__(int argc, VALUE *argv, VALUE self) { FXVec2f *arg1 = (FXVec2f *) 0 ; FXVec2f *arg2 = 0 ;
    bool result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXVec2f, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXVec2f, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    result = (bool)FXVec2f_operator_Se__Se_((FXVec2f const *)arg1,(FXVec2f const &)*arg2); vresult = result ? Qtrue : Qfalse;
    return vresult; }
static VALUE _wrap_FXVec2f_len2(int argc, VALUE *argv, VALUE self) { FXVec2f *arg1 = (FXVec2f *) 0 ; FXfloat result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXVec2f, 1); result = (FXfloat)FXVec2f_len2((FXVec2f const *)arg1);
    vresult = rb_float_new(result); return vresult; }
static VALUE _wrap_FXVec2f_len(int argc, VALUE *argv, VALUE self) { FXVec2f *arg1 = (FXVec2f *) 0 ; FXfloat result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXVec2f, 1); result = (FXfloat)FXVec2f_len((FXVec2f const *)arg1);
    vresult = rb_float_new(result); return vresult; }
static VALUE _wrap_FXVec2f_normalize(int argc, VALUE *argv, VALUE self) { FXVec2f *arg1 = (FXVec2f *) 0 ; FXVec2f result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXVec2f, 1); result = FXVec2f_normalize((FXVec2f const *)arg1); {
        FXVec2f * resultptr; resultptr = new FXVec2f((FXVec2f &)result);
        vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_FXVec2f, 1); }  return vresult; }
static VALUE _wrap_FXVec2f_lo(int argc, VALUE *argv, VALUE self) { FXVec2f *arg1 = (FXVec2f *) 0 ; FXVec2f *arg2 = 0 ;
    FXVec2f result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXVec2f, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXVec2f, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    result = FXVec2f_lo((FXVec2f const *)arg1,(FXVec2f const &)*arg2); { FXVec2f * resultptr;
        resultptr = new FXVec2f((FXVec2f &)result); vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_FXVec2f, 1); } 
    return vresult; }
static VALUE _wrap_FXVec2f_hi(int argc, VALUE *argv, VALUE self) { FXVec2f *arg1 = (FXVec2f *) 0 ; FXVec2f *arg2 = 0 ;
    FXVec2f result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXVec2f, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXVec2f, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    result = FXVec2f_hi((FXVec2f const *)arg1,(FXVec2f const &)*arg2); { FXVec2f * resultptr;
        resultptr = new FXVec2f((FXVec2f &)result); vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_FXVec2f, 1); } 
    return vresult; }
static VALUE _wrap_FXVec2f_to_a(int argc, VALUE *argv, VALUE self) { FXVec2f *arg1 = (FXVec2f *) 0 ; VALUE result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXVec2f, 1); result = (VALUE)FXVec2f_to_a((FXVec2f const *)arg1);
    vresult = result; return vresult; }
static VALUE _wrap_FXVec2f_to_s(int argc, VALUE *argv, VALUE self) { FXVec2f *arg1 = (FXVec2f *) 0 ; FXString result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXVec2f, 1); result = FXVec2f_to_s((FXVec2f const *)arg1);
    vresult = rb_str_new2((&result)->text()); return vresult; }
static VALUE _wrap_FXVec2d_x_set(int argc, VALUE *argv, VALUE self) { FXVec2d *arg1 = (FXVec2d *) 0 ; FXdouble arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXVec2d, 1); arg2 = (FXdouble) NUM2DBL(argv[0]);
    if (arg1) (arg1)->x = arg2; return Qnil; }
static VALUE _wrap_FXVec2d_x_get(int argc, VALUE *argv, VALUE self) { FXVec2d *arg1 = (FXVec2d *) 0 ; FXdouble result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXVec2d, 1); result = (FXdouble) ((arg1)->x);
    vresult = rb_float_new(result); return vresult; }
static VALUE _wrap_FXVec2d_y_set(int argc, VALUE *argv, VALUE self) { FXVec2d *arg1 = (FXVec2d *) 0 ; FXdouble arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXVec2d, 1); arg2 = (FXdouble) NUM2DBL(argv[0]);
    if (arg1) (arg1)->y = arg2; return Qnil; }
static VALUE _wrap_FXVec2d_y_get(int argc, VALUE *argv, VALUE self) { FXVec2d *arg1 = (FXVec2d *) 0 ; FXdouble result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXVec2d, 1); result = (FXdouble) ((arg1)->y);
    vresult = rb_float_new(result); return vresult; }
static VALUE _wrap_new_FXVec2d__SWIG_0(int argc, VALUE *argv, VALUE self) { FXVec2d *result; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc); { result = (FXVec2d *)new FXVec2d();
        DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result); if(rb_block_given_p()){ rb_yield(self); }  }  return self; }
static VALUE _wrap_new_FXVec2d__SWIG_1(int argc, VALUE *argv, VALUE self) { FXVec2d *arg1 = 0 ; FXVec2d *result;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXVec2d, 1); if (arg1 == NULL) rb_raise(rb_eTypeError, "null reference");
    { result = (FXVec2d *)new FXVec2d((FXVec2d const &)*arg1); DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result);
        if(rb_block_given_p()){ rb_yield(self); }  }  return self; }
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE _wrap_FXVec2d_allocate(VALUE self) {
#else
     static VALUE _wrap_FXVec2d_allocate(int argc, VALUE *argv, VALUE self) {
#endif
         VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_FXVec2d);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
         return vresult; }
static VALUE _wrap_new_FXVec2d__SWIG_2(int argc, VALUE *argv, VALUE self) { FXdouble arg1 ; FXdouble arg2 ; FXVec2d *result;
    if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    arg1 = (FXdouble) NUM2DBL(argv[0]); arg2 = (FXdouble) NUM2DBL(argv[1]); { result = (FXVec2d *)new FXVec2d(arg1,arg2);
        DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result); if(rb_block_given_p()){ rb_yield(self); }  }  return self; }
static VALUE _wrap_new_FXVec2d(int nargs, VALUE *args, VALUE self) { int argc; VALUE argv[2]; int ii; argc = nargs;
    for (ii = 0; (ii < argc) && (ii < 2); ii++) { argv[ii] = args[ii]; }  if (argc == 0) {
        return _wrap_new_FXVec2d__SWIG_0(nargs, args, self);}  if (argc == 1) { int _v; { void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXVec2d, 0) != -1)) ? 1 : 0; }
         if (_v) { return _wrap_new_FXVec2d__SWIG_1(nargs, args, self);}  }  if (argc == 2) { int _v; {
            _v = ((TYPE(argv[0]) == T_FLOAT) || (TYPE(argv[0]) == T_FIXNUM) || (TYPE(argv[0]) == T_BIGNUM)) ? 1 : 0; } 
        if (_v) { { _v = ((TYPE(argv[1]) == T_FLOAT) || (TYPE(argv[1]) == T_FIXNUM) || (TYPE(argv[1]) == T_BIGNUM)) ? 1 : 0; } 
            if (_v) { return _wrap_new_FXVec2d__SWIG_2(nargs, args, self);}  }  } 
    rb_raise(rb_eArgError, "No matching function for overloaded 'new_FXVec2d'"); return Qnil; }
static VALUE _wrap_FXVec2d___getitem__(int argc, VALUE *argv, VALUE self) { FXVec2d *arg1 = (FXVec2d *) 0 ; FXint arg2 ;
    FXdouble result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXVec2d, 1); arg2 = NUM2INT(argv[0]);
    result = (FXdouble)FXVec2d___getitem__((FXVec2d const *)arg1,arg2); vresult = rb_float_new(result); return vresult; }
static VALUE _wrap_FXVec2d___setitem__(int argc, VALUE *argv, VALUE self) { FXVec2d *arg1 = (FXVec2d *) 0 ; FXint arg2 ;
    FXdouble arg3 ; FXdouble result; VALUE vresult = Qnil; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXVec2d, 1); arg2 = NUM2INT(argv[0]); arg3 = (FXdouble) NUM2DBL(argv[1]);
    result = (FXdouble)FXVec2d___setitem__(arg1,arg2,arg3); vresult = rb_float_new(result); return vresult; }
static VALUE _wrap_FXVec2d___neg__(int argc, VALUE *argv, VALUE self) { FXVec2d *arg1 = (FXVec2d *) 0 ; FXVec2d result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXVec2d, 1); result = FXVec2d_operator_Ss_((FXVec2d const *)arg1); {
        FXVec2d * resultptr; resultptr = new FXVec2d((FXVec2d &)result);
        vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_FXVec2d, 1); }  return vresult; }
static VALUE _wrap_FXVec2d___add__(int argc, VALUE *argv, VALUE self) { FXVec2d *arg1 = (FXVec2d *) 0 ; FXVec2d *arg2 = 0 ;
    FXVec2d result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXVec2d, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXVec2d, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    result = FXVec2d_operator_Sa_((FXVec2d const *)arg1,(FXVec2d const &)*arg2); { FXVec2d * resultptr;
        resultptr = new FXVec2d((FXVec2d &)result); vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_FXVec2d, 1); } 
    return vresult; }
static VALUE _wrap_FXVec2d___sub__(int argc, VALUE *argv, VALUE self) { FXVec2d *arg1 = (FXVec2d *) 0 ; FXVec2d *arg2 = 0 ;
    FXVec2d result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXVec2d, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXVec2d, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    result = FXVec2d_operator_Ss_((FXVec2d const *)arg1,(FXVec2d const &)*arg2); { FXVec2d * resultptr;
        resultptr = new FXVec2d((FXVec2d &)result); vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_FXVec2d, 1); } 
    return vresult; }
static VALUE _wrap_FXVec2d___mul____SWIG_0(int argc, VALUE *argv, VALUE self) { FXVec2d *arg1 = (FXVec2d *) 0 ; FXdouble arg2 ;
    FXVec2d result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXVec2d, 1); arg2 = (FXdouble) NUM2DBL(argv[0]);
    result = FXVec2d_operator_Sm___SWIG_0((FXVec2d const *)arg1,arg2); { FXVec2d * resultptr;
        resultptr = new FXVec2d((FXVec2d &)result); vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_FXVec2d, 1); } 
    return vresult; }
static VALUE _wrap_FXVec2d___div__(int argc, VALUE *argv, VALUE self) { FXVec2d *arg1 = (FXVec2d *) 0 ; FXdouble arg2 ;
    FXVec2d result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXVec2d, 1); arg2 = (FXdouble) NUM2DBL(argv[0]);
    result = FXVec2d_operator_Sd_((FXVec2d const *)arg1,arg2); { FXVec2d * resultptr;
        resultptr = new FXVec2d((FXVec2d &)result); vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_FXVec2d, 1); } 
    return vresult; }
static VALUE _wrap_FXVec2d___mul____SWIG_1(int argc, VALUE *argv, VALUE self) { FXVec2d *arg1 = (FXVec2d *) 0 ;
    FXVec2d *arg2 = 0 ; FXdouble result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXVec2d, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXVec2d, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    result = (FXdouble)FXVec2d_operator_Sm___SWIG_1((FXVec2d const *)arg1,(FXVec2d const &)*arg2);
    vresult = rb_float_new(result); return vresult; }
static VALUE _wrap_FXVec2d___mul__(int nargs, VALUE *args, VALUE self) { int argc; VALUE argv[3]; int ii; argc = nargs + 1;
    argv[0] = self; for (ii = 1; (ii < argc) && (ii < 2); ii++) { argv[ii] = args[ii-1]; }  if (argc == 2) { int _v; {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXVec2d, 0) != -1)) ? 1 : 0; }
         if (_v) { { void *ptr;
                _v = (NIL_P(argv[1]) || (TYPE(argv[1]) == T_DATA && SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_FXVec2d, 0) != -1)) ? 1 : 0; }
             if (_v) { return _wrap_FXVec2d___mul____SWIG_1(nargs, args, self);}  }  }  if (argc == 2) { int _v; { void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXVec2d, 0) != -1)) ? 1 : 0; }
         if (_v) { { _v = ((TYPE(argv[1]) == T_FLOAT) || (TYPE(argv[1]) == T_FIXNUM) || (TYPE(argv[1]) == T_BIGNUM)) ? 1 : 0; } 
            if (_v) { return _wrap_FXVec2d___mul____SWIG_0(nargs, args, self);}  }  } 
    rb_raise(rb_eArgError, "No matching function for overloaded 'FXVec2d___mul__'"); return Qnil; }
static VALUE _wrap_FXVec2d_dot(int argc, VALUE *argv, VALUE self) { FXVec2d *arg1 = (FXVec2d *) 0 ; FXVec2d *arg2 = 0 ;
    FXdouble result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXVec2d, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXVec2d, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    result = (FXdouble)FXVec2d_dot((FXVec2d const *)arg1,(FXVec2d const &)*arg2); vresult = rb_float_new(result);
    return vresult; }
static VALUE _wrap_FXVec2d___eq__(int argc, VALUE *argv, VALUE self) { FXVec2d *arg1 = (FXVec2d *) 0 ; FXVec2d *arg2 = 0 ;
    bool result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXVec2d, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXVec2d, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    result = (bool)FXVec2d_operator_Se__Se_((FXVec2d const *)arg1,(FXVec2d const &)*arg2); vresult = result ? Qtrue : Qfalse;
    return vresult; }
static VALUE _wrap_FXVec2d_len2(int argc, VALUE *argv, VALUE self) { FXVec2d *arg1 = (FXVec2d *) 0 ; FXdouble result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXVec2d, 1); result = (FXdouble)FXVec2d_len2((FXVec2d const *)arg1);
    vresult = rb_float_new(result); return vresult; }
static VALUE _wrap_FXVec2d_len(int argc, VALUE *argv, VALUE self) { FXVec2d *arg1 = (FXVec2d *) 0 ; FXdouble result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXVec2d, 1); result = (FXdouble)FXVec2d_len((FXVec2d const *)arg1);
    vresult = rb_float_new(result); return vresult; }
static VALUE _wrap_FXVec2d_normalize(int argc, VALUE *argv, VALUE self) { FXVec2d *arg1 = (FXVec2d *) 0 ; FXVec2d result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXVec2d, 1); result = FXVec2d_normalize((FXVec2d const *)arg1); {
        FXVec2d * resultptr; resultptr = new FXVec2d((FXVec2d &)result);
        vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_FXVec2d, 1); }  return vresult; }
static VALUE _wrap_FXVec2d_lo(int argc, VALUE *argv, VALUE self) { FXVec2d *arg1 = (FXVec2d *) 0 ; FXVec2d *arg2 = 0 ;
    FXVec2d result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXVec2d, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXVec2d, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    result = FXVec2d_lo((FXVec2d const *)arg1,(FXVec2d const &)*arg2); { FXVec2d * resultptr;
        resultptr = new FXVec2d((FXVec2d &)result); vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_FXVec2d, 1); } 
    return vresult; }
static VALUE _wrap_FXVec2d_hi(int argc, VALUE *argv, VALUE self) { FXVec2d *arg1 = (FXVec2d *) 0 ; FXVec2d *arg2 = 0 ;
    FXVec2d result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXVec2d, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXVec2d, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    result = FXVec2d_hi((FXVec2d const *)arg1,(FXVec2d const &)*arg2); { FXVec2d * resultptr;
        resultptr = new FXVec2d((FXVec2d &)result); vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_FXVec2d, 1); } 
    return vresult; }
static VALUE _wrap_FXVec2d_to_a(int argc, VALUE *argv, VALUE self) { FXVec2d *arg1 = (FXVec2d *) 0 ; VALUE result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXVec2d, 1); result = (VALUE)FXVec2d_to_a((FXVec2d const *)arg1);
    vresult = result; return vresult; }
static VALUE _wrap_FXVec2d_to_s(int argc, VALUE *argv, VALUE self) { FXVec2d *arg1 = (FXVec2d *) 0 ; FXString result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXVec2d, 1); result = FXVec2d_to_s((FXVec2d const *)arg1);
    vresult = rb_str_new2((&result)->text()); return vresult; }
static VALUE _wrap_FXVec3f_x_set(int argc, VALUE *argv, VALUE self) { FXVec3f *arg1 = (FXVec3f *) 0 ; FXfloat arg2 ;
    FXVec3f tmp1 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc); {
        if (TYPE(self) == T_ARRAY) {
            tmp1 = FXVec3f(NUM2DBL(rb_ary_entry(self, 0)), NUM2DBL(rb_ary_entry(self, 1)), NUM2DBL(rb_ary_entry(self, 2)));
            arg1 = &tmp1; }  else { SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXVec3f, 1); }  } 
    arg2 = (FXfloat) NUM2DBL(argv[0]); if (arg1) (arg1)->x = arg2; return Qnil; }
static VALUE _wrap_FXVec3f_x_get(int argc, VALUE *argv, VALUE self) { FXVec3f *arg1 = (FXVec3f *) 0 ; FXfloat result;
    FXVec3f tmp1 ; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc); { if (TYPE(self) == T_ARRAY) {
            tmp1 = FXVec3f(NUM2DBL(rb_ary_entry(self, 0)), NUM2DBL(rb_ary_entry(self, 1)), NUM2DBL(rb_ary_entry(self, 2)));
            arg1 = &tmp1; }  else { SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXVec3f, 1); }  } 
    result = (FXfloat) ((arg1)->x); vresult = rb_float_new(result); return vresult; }
static VALUE _wrap_FXVec3f_y_set(int argc, VALUE *argv, VALUE self) { FXVec3f *arg1 = (FXVec3f *) 0 ; FXfloat arg2 ;
    FXVec3f tmp1 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc); {
        if (TYPE(self) == T_ARRAY) {
            tmp1 = FXVec3f(NUM2DBL(rb_ary_entry(self, 0)), NUM2DBL(rb_ary_entry(self, 1)), NUM2DBL(rb_ary_entry(self, 2)));
            arg1 = &tmp1; }  else { SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXVec3f, 1); }  } 
    arg2 = (FXfloat) NUM2DBL(argv[0]); if (arg1) (arg1)->y = arg2; return Qnil; }
static VALUE _wrap_FXVec3f_y_get(int argc, VALUE *argv, VALUE self) { FXVec3f *arg1 = (FXVec3f *) 0 ; FXfloat result;
    FXVec3f tmp1 ; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc); { if (TYPE(self) == T_ARRAY) {
            tmp1 = FXVec3f(NUM2DBL(rb_ary_entry(self, 0)), NUM2DBL(rb_ary_entry(self, 1)), NUM2DBL(rb_ary_entry(self, 2)));
            arg1 = &tmp1; }  else { SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXVec3f, 1); }  } 
    result = (FXfloat) ((arg1)->y); vresult = rb_float_new(result); return vresult; }
static VALUE _wrap_FXVec3f_z_set(int argc, VALUE *argv, VALUE self) { FXVec3f *arg1 = (FXVec3f *) 0 ; FXfloat arg2 ;
    FXVec3f tmp1 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc); {
        if (TYPE(self) == T_ARRAY) {
            tmp1 = FXVec3f(NUM2DBL(rb_ary_entry(self, 0)), NUM2DBL(rb_ary_entry(self, 1)), NUM2DBL(rb_ary_entry(self, 2)));
            arg1 = &tmp1; }  else { SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXVec3f, 1); }  } 
    arg2 = (FXfloat) NUM2DBL(argv[0]); if (arg1) (arg1)->z = arg2; return Qnil; }
static VALUE _wrap_FXVec3f_z_get(int argc, VALUE *argv, VALUE self) { FXVec3f *arg1 = (FXVec3f *) 0 ; FXfloat result;
    FXVec3f tmp1 ; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc); { if (TYPE(self) == T_ARRAY) {
            tmp1 = FXVec3f(NUM2DBL(rb_ary_entry(self, 0)), NUM2DBL(rb_ary_entry(self, 1)), NUM2DBL(rb_ary_entry(self, 2)));
            arg1 = &tmp1; }  else { SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXVec3f, 1); }  } 
    result = (FXfloat) ((arg1)->z); vresult = rb_float_new(result); return vresult; }
static VALUE _wrap_new_FXVec3f__SWIG_0(int argc, VALUE *argv, VALUE self) { FXVec3f *result; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc); { result = (FXVec3f *)new FXVec3f();
        DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result); if(rb_block_given_p()){ rb_yield(self); }  }  return self; }
static VALUE _wrap_new_FXVec3f__SWIG_1(int argc, VALUE *argv, VALUE self) { FXVec3f *arg1 = 0 ; FXVec3f *result;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc); {
        if (TYPE(argv[0]) == T_ARRAY) {
            arg1 = new FXVec3f(NUM2DBL(rb_ary_entry(argv[0], 0)), NUM2DBL(rb_ary_entry(argv[0], 1)), NUM2DBL(rb_ary_entry(argv[0], 2))); }
         else { FXVec3f *p; SWIG_ConvertPtr(argv[0], (void **)&p, SWIGTYPE_p_FXVec3f, 1); arg1 = new FXVec3f(*p); }  }  {
        result = (FXVec3f *)new FXVec3f((FXVec3f const &)*arg1); DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result);
        if(rb_block_given_p()){ rb_yield(self); }  }  delete arg1; return self; }
static VALUE _wrap_new_FXVec3f__SWIG_2(int argc, VALUE *argv, VALUE self) { FXfloat arg1 ; FXfloat arg2 ;
    FXfloat arg3 = (FXfloat) 1.0f ; FXVec3f *result; if ((argc < 2) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc); arg1 = (FXfloat) NUM2DBL(argv[0]);
    arg2 = (FXfloat) NUM2DBL(argv[1]); if (argc > 2) { arg3 = (FXfloat) NUM2DBL(argv[2]); }  {
        result = (FXVec3f *)new FXVec3f(arg1,arg2,arg3); DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result);
        if(rb_block_given_p()){ rb_yield(self); }  }  return self; }
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE _wrap_FXVec3f_allocate(VALUE self) {
#else
     static VALUE _wrap_FXVec3f_allocate(int argc, VALUE *argv, VALUE self) {
#endif
         VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_FXVec3f);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
         return vresult; }
static VALUE _wrap_new_FXVec3f__SWIG_3(int argc, VALUE *argv, VALUE self) { FXColor arg1 ; FXVec3f *result;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc); arg1 = to_FXColor(argv[0]); {
        result = (FXVec3f *)new FXVec3f(arg1); DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result);
        if(rb_block_given_p()){ rb_yield(self); }  }  return self; }
static VALUE _wrap_new_FXVec3f(int nargs, VALUE *args, VALUE self) { int argc; VALUE argv[3]; int ii; argc = nargs;
    for (ii = 0; (ii < argc) && (ii < 3); ii++) { argv[ii] = args[ii]; }  if (argc == 0) {
        return _wrap_new_FXVec3f__SWIG_0(nargs, args, self);}  if (argc == 1) { int _v; { void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXVec3f, 0) != -1)) ? 1 : 0; }
         if (_v) { return _wrap_new_FXVec3f__SWIG_1(nargs, args, self);}  }  if (argc == 1) { int _v; {
            _v = ((TYPE(argv[0]) == T_FIXNUM) || (TYPE(argv[0]) == T_BIGNUM)) ? 1 : 0; }  if (_v) {
            return _wrap_new_FXVec3f__SWIG_3(nargs, args, self);}  }  if ((argc >= 2) && (argc <= 3)) { int _v; {
            _v = ((TYPE(argv[0]) == T_FLOAT) || (TYPE(argv[0]) == T_FIXNUM) || (TYPE(argv[0]) == T_BIGNUM)) ? 1 : 0; } 
        if (_v) { { _v = ((TYPE(argv[1]) == T_FLOAT) || (TYPE(argv[1]) == T_FIXNUM) || (TYPE(argv[1]) == T_BIGNUM)) ? 1 : 0; } 
            if (_v) { if (argc <= 2) { return _wrap_new_FXVec3f__SWIG_2(nargs, args, self);}  {
                    _v = ((TYPE(argv[2]) == T_FLOAT) || (TYPE(argv[2]) == T_FIXNUM) || (TYPE(argv[2]) == T_BIGNUM)) ? 1 : 0; } 
                if (_v) { return _wrap_new_FXVec3f__SWIG_2(nargs, args, self);}  }  }  } 
    rb_raise(rb_eArgError, "No matching function for overloaded 'new_FXVec3f'"); return Qnil; }
static VALUE _wrap_FXVec3f___getitem__(int argc, VALUE *argv, VALUE self) { FXVec3f *arg1 = (FXVec3f *) 0 ; FXint arg2 ;
    FXfloat result; FXVec3f tmp1 ; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc); { if (TYPE(self) == T_ARRAY) {
            tmp1 = FXVec3f(NUM2DBL(rb_ary_entry(self, 0)), NUM2DBL(rb_ary_entry(self, 1)), NUM2DBL(rb_ary_entry(self, 2)));
            arg1 = &tmp1; }  else { SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXVec3f, 1); }  } 
    arg2 = NUM2INT(argv[0]); result = (FXfloat)FXVec3f___getitem__((FXVec3f const *)arg1,arg2); vresult = rb_float_new(result);
    return vresult; }
static VALUE _wrap_FXVec3f___setitem__(int argc, VALUE *argv, VALUE self) { FXVec3f *arg1 = (FXVec3f *) 0 ; FXint arg2 ;
    FXfloat arg3 ; FXfloat result; FXVec3f tmp1 ; VALUE vresult = Qnil; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc); { if (TYPE(self) == T_ARRAY) {
            tmp1 = FXVec3f(NUM2DBL(rb_ary_entry(self, 0)), NUM2DBL(rb_ary_entry(self, 1)), NUM2DBL(rb_ary_entry(self, 2)));
            arg1 = &tmp1; }  else { SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXVec3f, 1); }  } 
    arg2 = NUM2INT(argv[0]); arg3 = (FXfloat) NUM2DBL(argv[1]); result = (FXfloat)FXVec3f___setitem__(arg1,arg2,arg3);
    vresult = rb_float_new(result); return vresult; }
static VALUE _wrap_FXVec3f___neg__(int argc, VALUE *argv, VALUE self) { FXVec3f *arg1 = (FXVec3f *) 0 ; FXVec3f result;
    FXVec3f tmp1 ; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc); { if (TYPE(self) == T_ARRAY) {
            tmp1 = FXVec3f(NUM2DBL(rb_ary_entry(self, 0)), NUM2DBL(rb_ary_entry(self, 1)), NUM2DBL(rb_ary_entry(self, 2)));
            arg1 = &tmp1; }  else { SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXVec3f, 1); }  } 
    result = FXVec3f_operator_Ss_((FXVec3f const *)arg1); { FXVec3f* resultptr = new FXVec3f(result);
        vresult = FXRbGetRubyObj(resultptr, "FXVec3f *"); }  return vresult; }
static VALUE _wrap_FXVec3f___add__(int argc, VALUE *argv, VALUE self) { FXVec3f *arg1 = (FXVec3f *) 0 ; FXVec3f *arg2 = 0 ;
    FXVec3f result; FXVec3f tmp1 ; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc); { if (TYPE(self) == T_ARRAY) {
            tmp1 = FXVec3f(NUM2DBL(rb_ary_entry(self, 0)), NUM2DBL(rb_ary_entry(self, 1)), NUM2DBL(rb_ary_entry(self, 2)));
            arg1 = &tmp1; }  else { SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXVec3f, 1); }  }  {
        if (TYPE(argv[0]) == T_ARRAY) {
            arg2 = new FXVec3f(NUM2DBL(rb_ary_entry(argv[0], 0)), NUM2DBL(rb_ary_entry(argv[0], 1)), NUM2DBL(rb_ary_entry(argv[0], 2))); }
         else { FXVec3f *p; SWIG_ConvertPtr(argv[0], (void **)&p, SWIGTYPE_p_FXVec3f, 1); arg2 = new FXVec3f(*p); }  } 
    result = FXVec3f_operator_Sa_((FXVec3f const *)arg1,(FXVec3f const &)*arg2); { FXVec3f* resultptr = new FXVec3f(result);
        vresult = FXRbGetRubyObj(resultptr, "FXVec3f *"); }  delete arg2; return vresult; }
static VALUE _wrap_FXVec3f___sub__(int argc, VALUE *argv, VALUE self) { FXVec3f *arg1 = (FXVec3f *) 0 ; FXVec3f *arg2 = 0 ;
    FXVec3f result; FXVec3f tmp1 ; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc); { if (TYPE(self) == T_ARRAY) {
            tmp1 = FXVec3f(NUM2DBL(rb_ary_entry(self, 0)), NUM2DBL(rb_ary_entry(self, 1)), NUM2DBL(rb_ary_entry(self, 2)));
            arg1 = &tmp1; }  else { SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXVec3f, 1); }  }  {
        if (TYPE(argv[0]) == T_ARRAY) {
            arg2 = new FXVec3f(NUM2DBL(rb_ary_entry(argv[0], 0)), NUM2DBL(rb_ary_entry(argv[0], 1)), NUM2DBL(rb_ary_entry(argv[0], 2))); }
         else { FXVec3f *p; SWIG_ConvertPtr(argv[0], (void **)&p, SWIGTYPE_p_FXVec3f, 1); arg2 = new FXVec3f(*p); }  } 
    result = FXVec3f_operator_Ss_((FXVec3f const *)arg1,(FXVec3f const &)*arg2); { FXVec3f* resultptr = new FXVec3f(result);
        vresult = FXRbGetRubyObj(resultptr, "FXVec3f *"); }  delete arg2; return vresult; }
static VALUE _wrap_FXVec3f___mul____SWIG_0(int argc, VALUE *argv, VALUE self) { FXVec3f *arg1 = (FXVec3f *) 0 ; FXfloat arg2 ;
    FXVec3f result; FXVec3f tmp1 ; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc); { if (TYPE(self) == T_ARRAY) {
            tmp1 = FXVec3f(NUM2DBL(rb_ary_entry(self, 0)), NUM2DBL(rb_ary_entry(self, 1)), NUM2DBL(rb_ary_entry(self, 2)));
            arg1 = &tmp1; }  else { SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXVec3f, 1); }  } 
    arg2 = (FXfloat) NUM2DBL(argv[0]); result = FXVec3f_operator_Sm___SWIG_0((FXVec3f const *)arg1,arg2); {
        FXVec3f* resultptr = new FXVec3f(result); vresult = FXRbGetRubyObj(resultptr, "FXVec3f *"); }  return vresult; }
static VALUE _wrap_FXVec3f___div__(int argc, VALUE *argv, VALUE self) { FXVec3f *arg1 = (FXVec3f *) 0 ; FXfloat arg2 ;
    FXVec3f result; FXVec3f tmp1 ; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc); { if (TYPE(self) == T_ARRAY) {
            tmp1 = FXVec3f(NUM2DBL(rb_ary_entry(self, 0)), NUM2DBL(rb_ary_entry(self, 1)), NUM2DBL(rb_ary_entry(self, 2)));
            arg1 = &tmp1; }  else { SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXVec3f, 1); }  } 
    arg2 = (FXfloat) NUM2DBL(argv[0]); result = FXVec3f_operator_Sd_((FXVec3f const *)arg1,arg2); {
        FXVec3f* resultptr = new FXVec3f(result); vresult = FXRbGetRubyObj(resultptr, "FXVec3f *"); }  return vresult; }
static VALUE _wrap_FXVec3f___mul____SWIG_1(int argc, VALUE *argv, VALUE self) { FXVec3f *arg1 = (FXVec3f *) 0 ;
    FXVec3f *arg2 = 0 ; FXfloat result; FXVec3f tmp1 ; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc); { if (TYPE(self) == T_ARRAY) {
            tmp1 = FXVec3f(NUM2DBL(rb_ary_entry(self, 0)), NUM2DBL(rb_ary_entry(self, 1)), NUM2DBL(rb_ary_entry(self, 2)));
            arg1 = &tmp1; }  else { SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXVec3f, 1); }  }  {
        if (TYPE(argv[0]) == T_ARRAY) {
            arg2 = new FXVec3f(NUM2DBL(rb_ary_entry(argv[0], 0)), NUM2DBL(rb_ary_entry(argv[0], 1)), NUM2DBL(rb_ary_entry(argv[0], 2))); }
         else { FXVec3f *p; SWIG_ConvertPtr(argv[0], (void **)&p, SWIGTYPE_p_FXVec3f, 1); arg2 = new FXVec3f(*p); }  } 
    result = (FXfloat)FXVec3f_operator_Sm___SWIG_1((FXVec3f const *)arg1,(FXVec3f const &)*arg2);
    vresult = rb_float_new(result); delete arg2; return vresult; }
static VALUE _wrap_FXVec3f___mul__(int nargs, VALUE *args, VALUE self) { int argc; VALUE argv[3]; int ii; argc = nargs + 1;
    argv[0] = self; for (ii = 1; (ii < argc) && (ii < 2); ii++) { argv[ii] = args[ii-1]; }  if (argc == 2) { int _v; {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXVec3f, 0) != -1)) ? 1 : 0; }
         if (_v) { { void *ptr;
                _v = (NIL_P(argv[1]) || (TYPE(argv[1]) == T_DATA && SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_FXVec3f, 0) != -1)) ? 1 : 0; }
             if (_v) { return _wrap_FXVec3f___mul____SWIG_1(nargs, args, self);}  }  }  if (argc == 2) { int _v; { void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXVec3f, 0) != -1)) ? 1 : 0; }
         if (_v) { { _v = ((TYPE(argv[1]) == T_FLOAT) || (TYPE(argv[1]) == T_FIXNUM) || (TYPE(argv[1]) == T_BIGNUM)) ? 1 : 0; } 
            if (_v) { return _wrap_FXVec3f___mul____SWIG_0(nargs, args, self);}  }  } 
    rb_raise(rb_eArgError, "No matching function for overloaded 'FXVec3f___mul__'"); return Qnil; }
static VALUE _wrap_FXVec3f_dot(int argc, VALUE *argv, VALUE self) { FXVec3f *arg1 = (FXVec3f *) 0 ; FXVec3f *arg2 = 0 ;
    FXfloat result; FXVec3f tmp1 ; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc); { if (TYPE(self) == T_ARRAY) {
            tmp1 = FXVec3f(NUM2DBL(rb_ary_entry(self, 0)), NUM2DBL(rb_ary_entry(self, 1)), NUM2DBL(rb_ary_entry(self, 2)));
            arg1 = &tmp1; }  else { SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXVec3f, 1); }  }  {
        if (TYPE(argv[0]) == T_ARRAY) {
            arg2 = new FXVec3f(NUM2DBL(rb_ary_entry(argv[0], 0)), NUM2DBL(rb_ary_entry(argv[0], 1)), NUM2DBL(rb_ary_entry(argv[0], 2))); }
         else { FXVec3f *p; SWIG_ConvertPtr(argv[0], (void **)&p, SWIGTYPE_p_FXVec3f, 1); arg2 = new FXVec3f(*p); }  } 
    result = (FXfloat)FXVec3f_dot((FXVec3f const *)arg1,(FXVec3f const &)*arg2); vresult = rb_float_new(result); delete arg2;
    return vresult; }
static VALUE _wrap_FXVec3f___xor__(int argc, VALUE *argv, VALUE self) { FXVec3f *arg1 = (FXVec3f *) 0 ; FXVec3f *arg2 = 0 ;
    FXVec3f result; FXVec3f tmp1 ; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc); { if (TYPE(self) == T_ARRAY) {
            tmp1 = FXVec3f(NUM2DBL(rb_ary_entry(self, 0)), NUM2DBL(rb_ary_entry(self, 1)), NUM2DBL(rb_ary_entry(self, 2)));
            arg1 = &tmp1; }  else { SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXVec3f, 1); }  }  {
        if (TYPE(argv[0]) == T_ARRAY) {
            arg2 = new FXVec3f(NUM2DBL(rb_ary_entry(argv[0], 0)), NUM2DBL(rb_ary_entry(argv[0], 1)), NUM2DBL(rb_ary_entry(argv[0], 2))); }
         else { FXVec3f *p; SWIG_ConvertPtr(argv[0], (void **)&p, SWIGTYPE_p_FXVec3f, 1); arg2 = new FXVec3f(*p); }  } 
    result = FXVec3f_operator_Sx_((FXVec3f const *)arg1,(FXVec3f const &)*arg2); { FXVec3f* resultptr = new FXVec3f(result);
        vresult = FXRbGetRubyObj(resultptr, "FXVec3f *"); }  delete arg2; return vresult; }
static VALUE _wrap_FXVec3f_cross(int argc, VALUE *argv, VALUE self) { FXVec3f *arg1 = (FXVec3f *) 0 ; FXVec3f *arg2 = 0 ;
    FXVec3f result; FXVec3f tmp1 ; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc); { if (TYPE(self) == T_ARRAY) {
            tmp1 = FXVec3f(NUM2DBL(rb_ary_entry(self, 0)), NUM2DBL(rb_ary_entry(self, 1)), NUM2DBL(rb_ary_entry(self, 2)));
            arg1 = &tmp1; }  else { SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXVec3f, 1); }  }  {
        if (TYPE(argv[0]) == T_ARRAY) {
            arg2 = new FXVec3f(NUM2DBL(rb_ary_entry(argv[0], 0)), NUM2DBL(rb_ary_entry(argv[0], 1)), NUM2DBL(rb_ary_entry(argv[0], 2))); }
         else { FXVec3f *p; SWIG_ConvertPtr(argv[0], (void **)&p, SWIGTYPE_p_FXVec3f, 1); arg2 = new FXVec3f(*p); }  } 
    result = FXVec3f_cross((FXVec3f const *)arg1,(FXVec3f const &)*arg2); { FXVec3f* resultptr = new FXVec3f(result);
        vresult = FXRbGetRubyObj(resultptr, "FXVec3f *"); }  delete arg2; return vresult; }
static VALUE _wrap_FXVec3f___eq__(int argc, VALUE *argv, VALUE self) { FXVec3f *arg1 = (FXVec3f *) 0 ; FXVec3f *arg2 = 0 ;
    bool result; FXVec3f tmp1 ; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc); { if (TYPE(self) == T_ARRAY) {
            tmp1 = FXVec3f(NUM2DBL(rb_ary_entry(self, 0)), NUM2DBL(rb_ary_entry(self, 1)), NUM2DBL(rb_ary_entry(self, 2)));
            arg1 = &tmp1; }  else { SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXVec3f, 1); }  }  {
        if (TYPE(argv[0]) == T_ARRAY) {
            arg2 = new FXVec3f(NUM2DBL(rb_ary_entry(argv[0], 0)), NUM2DBL(rb_ary_entry(argv[0], 1)), NUM2DBL(rb_ary_entry(argv[0], 2))); }
         else { FXVec3f *p; SWIG_ConvertPtr(argv[0], (void **)&p, SWIGTYPE_p_FXVec3f, 1); arg2 = new FXVec3f(*p); }  } 
    result = (bool)FXVec3f_operator_Se__Se_((FXVec3f const *)arg1,(FXVec3f const &)*arg2); vresult = result ? Qtrue : Qfalse;
    delete arg2; return vresult; }
static VALUE _wrap_FXVec3f_len2(int argc, VALUE *argv, VALUE self) { FXVec3f *arg1 = (FXVec3f *) 0 ; FXfloat result;
    FXVec3f tmp1 ; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc); { if (TYPE(self) == T_ARRAY) {
            tmp1 = FXVec3f(NUM2DBL(rb_ary_entry(self, 0)), NUM2DBL(rb_ary_entry(self, 1)), NUM2DBL(rb_ary_entry(self, 2)));
            arg1 = &tmp1; }  else { SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXVec3f, 1); }  } 
    result = (FXfloat)FXVec3f_len2((FXVec3f const *)arg1); vresult = rb_float_new(result); return vresult; }
static VALUE _wrap_FXVec3f_len(int argc, VALUE *argv, VALUE self) { FXVec3f *arg1 = (FXVec3f *) 0 ; FXfloat result;
    FXVec3f tmp1 ; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc); { if (TYPE(self) == T_ARRAY) {
            tmp1 = FXVec3f(NUM2DBL(rb_ary_entry(self, 0)), NUM2DBL(rb_ary_entry(self, 1)), NUM2DBL(rb_ary_entry(self, 2)));
            arg1 = &tmp1; }  else { SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXVec3f, 1); }  } 
    result = (FXfloat)FXVec3f_len((FXVec3f const *)arg1); vresult = rb_float_new(result); return vresult; }
static VALUE _wrap_FXVec3f_normalize(int argc, VALUE *argv, VALUE self) { FXVec3f *arg1 = (FXVec3f *) 0 ; FXVec3f result;
    FXVec3f tmp1 ; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc); { if (TYPE(self) == T_ARRAY) {
            tmp1 = FXVec3f(NUM2DBL(rb_ary_entry(self, 0)), NUM2DBL(rb_ary_entry(self, 1)), NUM2DBL(rb_ary_entry(self, 2)));
            arg1 = &tmp1; }  else { SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXVec3f, 1); }  } 
    result = FXVec3f_normalize((FXVec3f const *)arg1); { FXVec3f* resultptr = new FXVec3f(result);
        vresult = FXRbGetRubyObj(resultptr, "FXVec3f *"); }  return vresult; }
static VALUE _wrap_FXVec3f_lo(int argc, VALUE *argv, VALUE self) { FXVec3f *arg1 = (FXVec3f *) 0 ; FXVec3f *arg2 = 0 ;
    FXVec3f result; FXVec3f tmp1 ; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc); { if (TYPE(self) == T_ARRAY) {
            tmp1 = FXVec3f(NUM2DBL(rb_ary_entry(self, 0)), NUM2DBL(rb_ary_entry(self, 1)), NUM2DBL(rb_ary_entry(self, 2)));
            arg1 = &tmp1; }  else { SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXVec3f, 1); }  }  {
        if (TYPE(argv[0]) == T_ARRAY) {
            arg2 = new FXVec3f(NUM2DBL(rb_ary_entry(argv[0], 0)), NUM2DBL(rb_ary_entry(argv[0], 1)), NUM2DBL(rb_ary_entry(argv[0], 2))); }
         else { FXVec3f *p; SWIG_ConvertPtr(argv[0], (void **)&p, SWIGTYPE_p_FXVec3f, 1); arg2 = new FXVec3f(*p); }  } 
    result = FXVec3f_lo((FXVec3f const *)arg1,(FXVec3f const &)*arg2); { FXVec3f* resultptr = new FXVec3f(result);
        vresult = FXRbGetRubyObj(resultptr, "FXVec3f *"); }  delete arg2; return vresult; }
static VALUE _wrap_FXVec3f_hi(int argc, VALUE *argv, VALUE self) { FXVec3f *arg1 = (FXVec3f *) 0 ; FXVec3f *arg2 = 0 ;
    FXVec3f result; FXVec3f tmp1 ; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc); { if (TYPE(self) == T_ARRAY) {
            tmp1 = FXVec3f(NUM2DBL(rb_ary_entry(self, 0)), NUM2DBL(rb_ary_entry(self, 1)), NUM2DBL(rb_ary_entry(self, 2)));
            arg1 = &tmp1; }  else { SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXVec3f, 1); }  }  {
        if (TYPE(argv[0]) == T_ARRAY) {
            arg2 = new FXVec3f(NUM2DBL(rb_ary_entry(argv[0], 0)), NUM2DBL(rb_ary_entry(argv[0], 1)), NUM2DBL(rb_ary_entry(argv[0], 2))); }
         else { FXVec3f *p; SWIG_ConvertPtr(argv[0], (void **)&p, SWIGTYPE_p_FXVec3f, 1); arg2 = new FXVec3f(*p); }  } 
    result = FXVec3f_hi((FXVec3f const *)arg1,(FXVec3f const &)*arg2); { FXVec3f* resultptr = new FXVec3f(result);
        vresult = FXRbGetRubyObj(resultptr, "FXVec3f *"); }  delete arg2; return vresult; }
static VALUE _wrap_FXVec3f_to_a(int argc, VALUE *argv, VALUE self) { FXVec3f *arg1 = (FXVec3f *) 0 ; VALUE result;
    FXVec3f tmp1 ; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc); { if (TYPE(self) == T_ARRAY) {
            tmp1 = FXVec3f(NUM2DBL(rb_ary_entry(self, 0)), NUM2DBL(rb_ary_entry(self, 1)), NUM2DBL(rb_ary_entry(self, 2)));
            arg1 = &tmp1; }  else { SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXVec3f, 1); }  } 
    result = (VALUE)FXVec3f_to_a((FXVec3f const *)arg1); vresult = result; return vresult; }
static VALUE _wrap_FXVec3f_to_s(int argc, VALUE *argv, VALUE self) { FXVec3f *arg1 = (FXVec3f *) 0 ; FXString result;
    FXVec3f tmp1 ; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc); { if (TYPE(self) == T_ARRAY) {
            tmp1 = FXVec3f(NUM2DBL(rb_ary_entry(self, 0)), NUM2DBL(rb_ary_entry(self, 1)), NUM2DBL(rb_ary_entry(self, 2)));
            arg1 = &tmp1; }  else { SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXVec3f, 1); }  } 
    result = FXVec3f_to_s((FXVec3f const *)arg1); vresult = rb_str_new2((&result)->text()); return vresult; }
static VALUE _wrap_FXVec3d_x_set(int argc, VALUE *argv, VALUE self) { FXVec3d *arg1 = (FXVec3d *) 0 ; FXdouble arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXVec3d, 1); arg2 = (FXdouble) NUM2DBL(argv[0]);
    if (arg1) (arg1)->x = arg2; return Qnil; }
static VALUE _wrap_FXVec3d_x_get(int argc, VALUE *argv, VALUE self) { FXVec3d *arg1 = (FXVec3d *) 0 ; FXdouble result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXVec3d, 1); result = (FXdouble) ((arg1)->x);
    vresult = rb_float_new(result); return vresult; }
static VALUE _wrap_FXVec3d_y_set(int argc, VALUE *argv, VALUE self) { FXVec3d *arg1 = (FXVec3d *) 0 ; FXdouble arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXVec3d, 1); arg2 = (FXdouble) NUM2DBL(argv[0]);
    if (arg1) (arg1)->y = arg2; return Qnil; }
static VALUE _wrap_FXVec3d_y_get(int argc, VALUE *argv, VALUE self) { FXVec3d *arg1 = (FXVec3d *) 0 ; FXdouble result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXVec3d, 1); result = (FXdouble) ((arg1)->y);
    vresult = rb_float_new(result); return vresult; }
static VALUE _wrap_FXVec3d_z_set(int argc, VALUE *argv, VALUE self) { FXVec3d *arg1 = (FXVec3d *) 0 ; FXdouble arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXVec3d, 1); arg2 = (FXdouble) NUM2DBL(argv[0]);
    if (arg1) (arg1)->z = arg2; return Qnil; }
static VALUE _wrap_FXVec3d_z_get(int argc, VALUE *argv, VALUE self) { FXVec3d *arg1 = (FXVec3d *) 0 ; FXdouble result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXVec3d, 1); result = (FXdouble) ((arg1)->z);
    vresult = rb_float_new(result); return vresult; }
static VALUE _wrap_new_FXVec3d__SWIG_0(int argc, VALUE *argv, VALUE self) { FXVec3d *result; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc); { result = (FXVec3d *)new FXVec3d();
        DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result); if(rb_block_given_p()){ rb_yield(self); }  }  return self; }
static VALUE _wrap_new_FXVec3d__SWIG_1(int argc, VALUE *argv, VALUE self) { FXVec3d *arg1 = 0 ; FXVec3d *result;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXVec3d, 1); if (arg1 == NULL) rb_raise(rb_eTypeError, "null reference");
    { result = (FXVec3d *)new FXVec3d((FXVec3d const &)*arg1); DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result);
        if(rb_block_given_p()){ rb_yield(self); }  }  return self; }
static VALUE _wrap_new_FXVec3d__SWIG_2(int argc, VALUE *argv, VALUE self) { FXdouble arg1 ; FXdouble arg2 ;
    FXdouble arg3 = (FXdouble) 1.0 ; FXVec3d *result; if ((argc < 2) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc); arg1 = (FXdouble) NUM2DBL(argv[0]);
    arg2 = (FXdouble) NUM2DBL(argv[1]); if (argc > 2) { arg3 = (FXdouble) NUM2DBL(argv[2]); }  {
        result = (FXVec3d *)new FXVec3d(arg1,arg2,arg3); DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result);
        if(rb_block_given_p()){ rb_yield(self); }  }  return self; }
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE _wrap_FXVec3d_allocate(VALUE self) {
#else
     static VALUE _wrap_FXVec3d_allocate(int argc, VALUE *argv, VALUE self) {
#endif
         VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_FXVec3d);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
         return vresult; }
static VALUE _wrap_new_FXVec3d__SWIG_3(int argc, VALUE *argv, VALUE self) { FXColor arg1 ; FXVec3d *result;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc); arg1 = to_FXColor(argv[0]); {
        result = (FXVec3d *)new FXVec3d(arg1); DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result);
        if(rb_block_given_p()){ rb_yield(self); }  }  return self; }
static VALUE _wrap_new_FXVec3d(int nargs, VALUE *args, VALUE self) { int argc; VALUE argv[3]; int ii; argc = nargs;
    for (ii = 0; (ii < argc) && (ii < 3); ii++) { argv[ii] = args[ii]; }  if (argc == 0) {
        return _wrap_new_FXVec3d__SWIG_0(nargs, args, self);}  if (argc == 1) { int _v; { void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXVec3d, 0) != -1)) ? 1 : 0; }
         if (_v) { return _wrap_new_FXVec3d__SWIG_1(nargs, args, self);}  }  if (argc == 1) { int _v; {
            _v = ((TYPE(argv[0]) == T_FIXNUM) || (TYPE(argv[0]) == T_BIGNUM)) ? 1 : 0; }  if (_v) {
            return _wrap_new_FXVec3d__SWIG_3(nargs, args, self);}  }  if ((argc >= 2) && (argc <= 3)) { int _v; {
            _v = ((TYPE(argv[0]) == T_FLOAT) || (TYPE(argv[0]) == T_FIXNUM) || (TYPE(argv[0]) == T_BIGNUM)) ? 1 : 0; } 
        if (_v) { { _v = ((TYPE(argv[1]) == T_FLOAT) || (TYPE(argv[1]) == T_FIXNUM) || (TYPE(argv[1]) == T_BIGNUM)) ? 1 : 0; } 
            if (_v) { if (argc <= 2) { return _wrap_new_FXVec3d__SWIG_2(nargs, args, self);}  {
                    _v = ((TYPE(argv[2]) == T_FLOAT) || (TYPE(argv[2]) == T_FIXNUM) || (TYPE(argv[2]) == T_BIGNUM)) ? 1 : 0; } 
                if (_v) { return _wrap_new_FXVec3d__SWIG_2(nargs, args, self);}  }  }  } 
    rb_raise(rb_eArgError, "No matching function for overloaded 'new_FXVec3d'"); return Qnil; }
static VALUE _wrap_FXVec3d___getitem__(int argc, VALUE *argv, VALUE self) { FXVec3d *arg1 = (FXVec3d *) 0 ; FXint arg2 ;
    FXdouble result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXVec3d, 1); arg2 = NUM2INT(argv[0]);
    result = (FXdouble)FXVec3d___getitem__((FXVec3d const *)arg1,arg2); vresult = rb_float_new(result); return vresult; }
static VALUE _wrap_FXVec3d___setitem__(int argc, VALUE *argv, VALUE self) { FXVec3d *arg1 = (FXVec3d *) 0 ; FXint arg2 ;
    FXdouble arg3 ; FXdouble result; VALUE vresult = Qnil; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXVec3d, 1); arg2 = NUM2INT(argv[0]); arg3 = (FXdouble) NUM2DBL(argv[1]);
    result = (FXdouble)FXVec3d___setitem__(arg1,arg2,arg3); vresult = rb_float_new(result); return vresult; }
static VALUE _wrap_FXVec3d___neg__(int argc, VALUE *argv, VALUE self) { FXVec3d *arg1 = (FXVec3d *) 0 ; FXVec3d result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXVec3d, 1); result = FXVec3d_operator_Ss_((FXVec3d const *)arg1); {
        FXVec3d * resultptr; resultptr = new FXVec3d((FXVec3d &)result);
        vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_FXVec3d, 1); }  return vresult; }
static VALUE _wrap_FXVec3d___add__(int argc, VALUE *argv, VALUE self) { FXVec3d *arg1 = (FXVec3d *) 0 ; FXVec3d *arg2 = 0 ;
    FXVec3d result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXVec3d, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXVec3d, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    result = FXVec3d_operator_Sa_((FXVec3d const *)arg1,(FXVec3d const &)*arg2); { FXVec3d * resultptr;
        resultptr = new FXVec3d((FXVec3d &)result); vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_FXVec3d, 1); } 
    return vresult; }
static VALUE _wrap_FXVec3d___sub__(int argc, VALUE *argv, VALUE self) { FXVec3d *arg1 = (FXVec3d *) 0 ; FXVec3d *arg2 = 0 ;
    FXVec3d result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXVec3d, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXVec3d, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    result = FXVec3d_operator_Ss_((FXVec3d const *)arg1,(FXVec3d const &)*arg2); { FXVec3d * resultptr;
        resultptr = new FXVec3d((FXVec3d &)result); vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_FXVec3d, 1); } 
    return vresult; }
static VALUE _wrap_FXVec3d___mul____SWIG_0(int argc, VALUE *argv, VALUE self) { FXVec3d *arg1 = (FXVec3d *) 0 ; FXdouble arg2 ;
    FXVec3d result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXVec3d, 1); arg2 = (FXdouble) NUM2DBL(argv[0]);
    result = FXVec3d_operator_Sm___SWIG_0((FXVec3d const *)arg1,arg2); { FXVec3d * resultptr;
        resultptr = new FXVec3d((FXVec3d &)result); vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_FXVec3d, 1); } 
    return vresult; }
static VALUE _wrap_FXVec3d___div__(int argc, VALUE *argv, VALUE self) { FXVec3d *arg1 = (FXVec3d *) 0 ; FXdouble arg2 ;
    FXVec3d result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXVec3d, 1); arg2 = (FXdouble) NUM2DBL(argv[0]);
    result = FXVec3d_operator_Sd_((FXVec3d const *)arg1,arg2); { FXVec3d * resultptr;
        resultptr = new FXVec3d((FXVec3d &)result); vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_FXVec3d, 1); } 
    return vresult; }
static VALUE _wrap_FXVec3d___mul____SWIG_1(int argc, VALUE *argv, VALUE self) { FXVec3d *arg1 = (FXVec3d *) 0 ;
    FXVec3d *arg2 = 0 ; FXdouble result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXVec3d, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXVec3d, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    result = (FXdouble)FXVec3d_operator_Sm___SWIG_1((FXVec3d const *)arg1,(FXVec3d const &)*arg2);
    vresult = rb_float_new(result); return vresult; }
static VALUE _wrap_FXVec3d___mul__(int nargs, VALUE *args, VALUE self) { int argc; VALUE argv[3]; int ii; argc = nargs + 1;
    argv[0] = self; for (ii = 1; (ii < argc) && (ii < 2); ii++) { argv[ii] = args[ii-1]; }  if (argc == 2) { int _v; {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXVec3d, 0) != -1)) ? 1 : 0; }
         if (_v) { { void *ptr;
                _v = (NIL_P(argv[1]) || (TYPE(argv[1]) == T_DATA && SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_FXVec3d, 0) != -1)) ? 1 : 0; }
             if (_v) { return _wrap_FXVec3d___mul____SWIG_1(nargs, args, self);}  }  }  if (argc == 2) { int _v; { void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXVec3d, 0) != -1)) ? 1 : 0; }
         if (_v) { { _v = ((TYPE(argv[1]) == T_FLOAT) || (TYPE(argv[1]) == T_FIXNUM) || (TYPE(argv[1]) == T_BIGNUM)) ? 1 : 0; } 
            if (_v) { return _wrap_FXVec3d___mul____SWIG_0(nargs, args, self);}  }  } 
    rb_raise(rb_eArgError, "No matching function for overloaded 'FXVec3d___mul__'"); return Qnil; }
static VALUE _wrap_FXVec3d_dot(int argc, VALUE *argv, VALUE self) { FXVec3d *arg1 = (FXVec3d *) 0 ; FXVec3d *arg2 = 0 ;
    FXdouble result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXVec3d, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXVec3d, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    result = (FXdouble)FXVec3d_dot((FXVec3d const *)arg1,(FXVec3d const &)*arg2); vresult = rb_float_new(result);
    return vresult; }
static VALUE _wrap_FXVec3d___xor__(int argc, VALUE *argv, VALUE self) { FXVec3d *arg1 = (FXVec3d *) 0 ; FXVec3d *arg2 = 0 ;
    FXVec3d result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXVec3d, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXVec3d, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    result = FXVec3d_operator_Sx_((FXVec3d const *)arg1,(FXVec3d const &)*arg2); { FXVec3d * resultptr;
        resultptr = new FXVec3d((FXVec3d &)result); vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_FXVec3d, 1); } 
    return vresult; }
static VALUE _wrap_FXVec3d_cross(int argc, VALUE *argv, VALUE self) { FXVec3d *arg1 = (FXVec3d *) 0 ; FXVec3d *arg2 = 0 ;
    FXVec3d result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXVec3d, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXVec3d, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    result = FXVec3d_cross((FXVec3d const *)arg1,(FXVec3d const &)*arg2); { FXVec3d * resultptr;
        resultptr = new FXVec3d((FXVec3d &)result); vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_FXVec3d, 1); } 
    return vresult; }
static VALUE _wrap_FXVec3d___eq__(int argc, VALUE *argv, VALUE self) { FXVec3d *arg1 = (FXVec3d *) 0 ; FXVec3d *arg2 = 0 ;
    bool result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXVec3d, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXVec3d, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    result = (bool)FXVec3d_operator_Se__Se_((FXVec3d const *)arg1,(FXVec3d const &)*arg2); vresult = result ? Qtrue : Qfalse;
    return vresult; }
static VALUE _wrap_FXVec3d_len2(int argc, VALUE *argv, VALUE self) { FXVec3d *arg1 = (FXVec3d *) 0 ; FXdouble result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXVec3d, 1); result = (FXdouble)FXVec3d_len2((FXVec3d const *)arg1);
    vresult = rb_float_new(result); return vresult; }
static VALUE _wrap_FXVec3d_len(int argc, VALUE *argv, VALUE self) { FXVec3d *arg1 = (FXVec3d *) 0 ; FXdouble result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXVec3d, 1); result = (FXdouble)FXVec3d_len((FXVec3d const *)arg1);
    vresult = rb_float_new(result); return vresult; }
static VALUE _wrap_FXVec3d_normalize(int argc, VALUE *argv, VALUE self) { FXVec3d *arg1 = (FXVec3d *) 0 ; FXVec3d result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXVec3d, 1); result = FXVec3d_normalize((FXVec3d const *)arg1); {
        FXVec3d * resultptr; resultptr = new FXVec3d((FXVec3d &)result);
        vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_FXVec3d, 1); }  return vresult; }
static VALUE _wrap_FXVec3d_lo(int argc, VALUE *argv, VALUE self) { FXVec3d *arg1 = (FXVec3d *) 0 ; FXVec3d *arg2 = 0 ;
    FXVec3d result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXVec3d, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXVec3d, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    result = FXVec3d_lo((FXVec3d const *)arg1,(FXVec3d const &)*arg2); { FXVec3d * resultptr;
        resultptr = new FXVec3d((FXVec3d &)result); vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_FXVec3d, 1); } 
    return vresult; }
static VALUE _wrap_FXVec3d_hi(int argc, VALUE *argv, VALUE self) { FXVec3d *arg1 = (FXVec3d *) 0 ; FXVec3d *arg2 = 0 ;
    FXVec3d result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXVec3d, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXVec3d, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    result = FXVec3d_hi((FXVec3d const *)arg1,(FXVec3d const &)*arg2); { FXVec3d * resultptr;
        resultptr = new FXVec3d((FXVec3d &)result); vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_FXVec3d, 1); } 
    return vresult; }
static VALUE _wrap_FXVec3d_to_a(int argc, VALUE *argv, VALUE self) { FXVec3d *arg1 = (FXVec3d *) 0 ; VALUE result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXVec3d, 1); result = (VALUE)FXVec3d_to_a((FXVec3d const *)arg1);
    vresult = result; return vresult; }
static VALUE _wrap_FXVec3d_to_s(int argc, VALUE *argv, VALUE self) { FXVec3d *arg1 = (FXVec3d *) 0 ; FXString result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXVec3d, 1); result = FXVec3d_to_s((FXVec3d const *)arg1);
    vresult = rb_str_new2((&result)->text()); return vresult; }
static VALUE _wrap_FXVec4f_x_set(int argc, VALUE *argv, VALUE self) { FXVec4f *arg1 = (FXVec4f *) 0 ; FXfloat arg2 ;
    FXVec4f tmp1 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc); {
        if (TYPE(self) == T_ARRAY) {
            tmp1 = FXVec4f(NUM2DBL(rb_ary_entry(self, 0)), NUM2DBL(rb_ary_entry(self, 1)), NUM2DBL(rb_ary_entry(self, 2)), NUM2DBL(rb_ary_entry(self, 3)));
            arg1 = &tmp1; }  else { SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXVec4f, 1); }  } 
    arg2 = (FXfloat) NUM2DBL(argv[0]); if (arg1) (arg1)->x = arg2; return Qnil; }
static VALUE _wrap_FXVec4f_x_get(int argc, VALUE *argv, VALUE self) { FXVec4f *arg1 = (FXVec4f *) 0 ; FXfloat result;
    FXVec4f tmp1 ; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc); { if (TYPE(self) == T_ARRAY) {
            tmp1 = FXVec4f(NUM2DBL(rb_ary_entry(self, 0)), NUM2DBL(rb_ary_entry(self, 1)), NUM2DBL(rb_ary_entry(self, 2)), NUM2DBL(rb_ary_entry(self, 3)));
            arg1 = &tmp1; }  else { SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXVec4f, 1); }  } 
    result = (FXfloat) ((arg1)->x); vresult = rb_float_new(result); return vresult; }
static VALUE _wrap_FXVec4f_y_set(int argc, VALUE *argv, VALUE self) { FXVec4f *arg1 = (FXVec4f *) 0 ; FXfloat arg2 ;
    FXVec4f tmp1 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc); {
        if (TYPE(self) == T_ARRAY) {
            tmp1 = FXVec4f(NUM2DBL(rb_ary_entry(self, 0)), NUM2DBL(rb_ary_entry(self, 1)), NUM2DBL(rb_ary_entry(self, 2)), NUM2DBL(rb_ary_entry(self, 3)));
            arg1 = &tmp1; }  else { SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXVec4f, 1); }  } 
    arg2 = (FXfloat) NUM2DBL(argv[0]); if (arg1) (arg1)->y = arg2; return Qnil; }
static VALUE _wrap_FXVec4f_y_get(int argc, VALUE *argv, VALUE self) { FXVec4f *arg1 = (FXVec4f *) 0 ; FXfloat result;
    FXVec4f tmp1 ; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc); { if (TYPE(self) == T_ARRAY) {
            tmp1 = FXVec4f(NUM2DBL(rb_ary_entry(self, 0)), NUM2DBL(rb_ary_entry(self, 1)), NUM2DBL(rb_ary_entry(self, 2)), NUM2DBL(rb_ary_entry(self, 3)));
            arg1 = &tmp1; }  else { SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXVec4f, 1); }  } 
    result = (FXfloat) ((arg1)->y); vresult = rb_float_new(result); return vresult; }
static VALUE _wrap_FXVec4f_z_set(int argc, VALUE *argv, VALUE self) { FXVec4f *arg1 = (FXVec4f *) 0 ; FXfloat arg2 ;
    FXVec4f tmp1 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc); {
        if (TYPE(self) == T_ARRAY) {
            tmp1 = FXVec4f(NUM2DBL(rb_ary_entry(self, 0)), NUM2DBL(rb_ary_entry(self, 1)), NUM2DBL(rb_ary_entry(self, 2)), NUM2DBL(rb_ary_entry(self, 3)));
            arg1 = &tmp1; }  else { SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXVec4f, 1); }  } 
    arg2 = (FXfloat) NUM2DBL(argv[0]); if (arg1) (arg1)->z = arg2; return Qnil; }
static VALUE _wrap_FXVec4f_z_get(int argc, VALUE *argv, VALUE self) { FXVec4f *arg1 = (FXVec4f *) 0 ; FXfloat result;
    FXVec4f tmp1 ; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc); { if (TYPE(self) == T_ARRAY) {
            tmp1 = FXVec4f(NUM2DBL(rb_ary_entry(self, 0)), NUM2DBL(rb_ary_entry(self, 1)), NUM2DBL(rb_ary_entry(self, 2)), NUM2DBL(rb_ary_entry(self, 3)));
            arg1 = &tmp1; }  else { SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXVec4f, 1); }  } 
    result = (FXfloat) ((arg1)->z); vresult = rb_float_new(result); return vresult; }
static VALUE _wrap_FXVec4f_w_set(int argc, VALUE *argv, VALUE self) { FXVec4f *arg1 = (FXVec4f *) 0 ; FXfloat arg2 ;
    FXVec4f tmp1 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc); {
        if (TYPE(self) == T_ARRAY) {
            tmp1 = FXVec4f(NUM2DBL(rb_ary_entry(self, 0)), NUM2DBL(rb_ary_entry(self, 1)), NUM2DBL(rb_ary_entry(self, 2)), NUM2DBL(rb_ary_entry(self, 3)));
            arg1 = &tmp1; }  else { SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXVec4f, 1); }  } 
    arg2 = (FXfloat) NUM2DBL(argv[0]); if (arg1) (arg1)->w = arg2; return Qnil; }
static VALUE _wrap_FXVec4f_w_get(int argc, VALUE *argv, VALUE self) { FXVec4f *arg1 = (FXVec4f *) 0 ; FXfloat result;
    FXVec4f tmp1 ; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc); { if (TYPE(self) == T_ARRAY) {
            tmp1 = FXVec4f(NUM2DBL(rb_ary_entry(self, 0)), NUM2DBL(rb_ary_entry(self, 1)), NUM2DBL(rb_ary_entry(self, 2)), NUM2DBL(rb_ary_entry(self, 3)));
            arg1 = &tmp1; }  else { SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXVec4f, 1); }  } 
    result = (FXfloat) ((arg1)->w); vresult = rb_float_new(result); return vresult; }
static VALUE _wrap_new_FXVec4f__SWIG_0(int argc, VALUE *argv, VALUE self) { FXVec4f *result; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc); { result = (FXVec4f *)new FXVec4f();
        DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result); if(rb_block_given_p()){ rb_yield(self); }  }  return self; }
static VALUE _wrap_new_FXVec4f__SWIG_1(int argc, VALUE *argv, VALUE self) { FXVec4f *arg1 = 0 ; FXVec4f *result;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc); {
        if (TYPE(argv[0]) == T_ARRAY) {
            arg1 = new FXVec4f(NUM2DBL(rb_ary_entry(argv[0], 0)), NUM2DBL(rb_ary_entry(argv[0], 1)), NUM2DBL(rb_ary_entry(argv[0], 2)), NUM2DBL(rb_ary_entry(argv[0], 3))); }
         else { FXVec4f *p; SWIG_ConvertPtr(argv[0],(void **)&p,SWIGTYPE_p_FXVec4f,1); arg1 = new FXVec4f(*p); }  }  {
        result = (FXVec4f *)new FXVec4f((FXVec4f const &)*arg1); DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result);
        if(rb_block_given_p()){ rb_yield(self); }  }  delete arg1; return self; }
static VALUE _wrap_new_FXVec4f__SWIG_2(int argc, VALUE *argv, VALUE self) { FXVec3f *arg1 = 0 ; FXVec4f *result;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc); {
        if (TYPE(argv[0]) == T_ARRAY) {
            arg1 = new FXVec3f(NUM2DBL(rb_ary_entry(argv[0], 0)), NUM2DBL(rb_ary_entry(argv[0], 1)), NUM2DBL(rb_ary_entry(argv[0], 2))); }
         else { FXVec3f *p; SWIG_ConvertPtr(argv[0], (void **)&p, SWIGTYPE_p_FXVec3f, 1); arg1 = new FXVec3f(*p); }  }  {
        result = (FXVec4f *)new FXVec4f((FXVec3f const &)*arg1); DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result);
        if(rb_block_given_p()){ rb_yield(self); }  }  delete arg1; return self; }
static VALUE _wrap_new_FXVec4f__SWIG_3(int argc, VALUE *argv, VALUE self) { FXfloat arg1 ; FXfloat arg2 ; FXfloat arg3 ;
    FXfloat arg4 = (FXfloat) 1.0f ; FXVec4f *result; if ((argc < 3) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc); arg1 = (FXfloat) NUM2DBL(argv[0]);
    arg2 = (FXfloat) NUM2DBL(argv[1]); arg3 = (FXfloat) NUM2DBL(argv[2]); if (argc > 3) { arg4 = (FXfloat) NUM2DBL(argv[3]); } 
    { result = (FXVec4f *)new FXVec4f(arg1,arg2,arg3,arg4); DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result);
        if(rb_block_given_p()){ rb_yield(self); }  }  return self; }
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE _wrap_FXVec4f_allocate(VALUE self) {
#else
     static VALUE _wrap_FXVec4f_allocate(int argc, VALUE *argv, VALUE self) {
#endif
         VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_FXVec4f);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
         return vresult; }
static VALUE _wrap_new_FXVec4f__SWIG_4(int argc, VALUE *argv, VALUE self) { FXColor arg1 ; FXVec4f *result;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc); arg1 = to_FXColor(argv[0]); {
        result = (FXVec4f *)new FXVec4f(arg1); DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result);
        if(rb_block_given_p()){ rb_yield(self); }  }  return self; }
static VALUE _wrap_new_FXVec4f(int nargs, VALUE *args, VALUE self) { int argc; VALUE argv[4]; int ii; argc = nargs;
    for (ii = 0; (ii < argc) && (ii < 4); ii++) { argv[ii] = args[ii]; }  if (argc == 0) {
        return _wrap_new_FXVec4f__SWIG_0(nargs, args, self);}  if (argc == 1) { int _v; { void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXVec4f, 0) != -1)) ? 1 : 0; }
         if (_v) { return _wrap_new_FXVec4f__SWIG_1(nargs, args, self);}  }  if (argc == 1) { int _v; { void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXVec3f, 0) != -1)) ? 1 : 0; }
         if (_v) { return _wrap_new_FXVec4f__SWIG_2(nargs, args, self);}  }  if (argc == 1) { int _v; {
            _v = ((TYPE(argv[0]) == T_FIXNUM) || (TYPE(argv[0]) == T_BIGNUM)) ? 1 : 0; }  if (_v) {
            return _wrap_new_FXVec4f__SWIG_4(nargs, args, self);}  }  if ((argc >= 3) && (argc <= 4)) { int _v; {
            _v = ((TYPE(argv[0]) == T_FLOAT) || (TYPE(argv[0]) == T_FIXNUM) || (TYPE(argv[0]) == T_BIGNUM)) ? 1 : 0; } 
        if (_v) { { _v = ((TYPE(argv[1]) == T_FLOAT) || (TYPE(argv[1]) == T_FIXNUM) || (TYPE(argv[1]) == T_BIGNUM)) ? 1 : 0; } 
            if (_v) { {
                    _v = ((TYPE(argv[2]) == T_FLOAT) || (TYPE(argv[2]) == T_FIXNUM) || (TYPE(argv[2]) == T_BIGNUM)) ? 1 : 0; } 
                if (_v) { if (argc <= 3) { return _wrap_new_FXVec4f__SWIG_3(nargs, args, self);}  {
                        _v = ((TYPE(argv[3]) == T_FLOAT) || (TYPE(argv[3]) == T_FIXNUM) || (TYPE(argv[3]) == T_BIGNUM)) ? 1 : 0; }
                     if (_v) { return _wrap_new_FXVec4f__SWIG_3(nargs, args, self);}  }  }  }  } 
    rb_raise(rb_eArgError, "No matching function for overloaded 'new_FXVec4f'"); return Qnil; }
static VALUE _wrap_FXVec4f___getitem__(int argc, VALUE *argv, VALUE self) { FXVec4f *arg1 = (FXVec4f *) 0 ; FXint arg2 ;
    FXfloat result; FXVec4f tmp1 ; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc); { if (TYPE(self) == T_ARRAY) {
            tmp1 = FXVec4f(NUM2DBL(rb_ary_entry(self, 0)), NUM2DBL(rb_ary_entry(self, 1)), NUM2DBL(rb_ary_entry(self, 2)), NUM2DBL(rb_ary_entry(self, 3)));
            arg1 = &tmp1; }  else { SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXVec4f, 1); }  } 
    arg2 = NUM2INT(argv[0]); result = (FXfloat)FXVec4f___getitem__((FXVec4f const *)arg1,arg2); vresult = rb_float_new(result);
    return vresult; }
static VALUE _wrap_FXVec4f___setitem__(int argc, VALUE *argv, VALUE self) { FXVec4f *arg1 = (FXVec4f *) 0 ; FXint arg2 ;
    FXfloat arg3 ; FXfloat result; FXVec4f tmp1 ; VALUE vresult = Qnil; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc); { if (TYPE(self) == T_ARRAY) {
            tmp1 = FXVec4f(NUM2DBL(rb_ary_entry(self, 0)), NUM2DBL(rb_ary_entry(self, 1)), NUM2DBL(rb_ary_entry(self, 2)), NUM2DBL(rb_ary_entry(self, 3)));
            arg1 = &tmp1; }  else { SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXVec4f, 1); }  } 
    arg2 = NUM2INT(argv[0]); arg3 = (FXfloat) NUM2DBL(argv[1]); result = (FXfloat)FXVec4f___setitem__(arg1,arg2,arg3);
    vresult = rb_float_new(result); return vresult; }
static VALUE _wrap_FXVec4f___neg__(int argc, VALUE *argv, VALUE self) { FXVec4f *arg1 = (FXVec4f *) 0 ; FXVec4f result;
    FXVec4f tmp1 ; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc); { if (TYPE(self) == T_ARRAY) {
            tmp1 = FXVec4f(NUM2DBL(rb_ary_entry(self, 0)), NUM2DBL(rb_ary_entry(self, 1)), NUM2DBL(rb_ary_entry(self, 2)), NUM2DBL(rb_ary_entry(self, 3)));
            arg1 = &tmp1; }  else { SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXVec4f, 1); }  } 
    result = FXVec4f_operator_Ss_((FXVec4f const *)arg1); { FXVec4f* resultptr = new FXVec4f(result);
        vresult = FXRbGetRubyObj(resultptr, "FXVec4f *"); }  return vresult; }
static VALUE _wrap_FXVec4f___add__(int argc, VALUE *argv, VALUE self) { FXVec4f *arg1 = (FXVec4f *) 0 ; FXVec4f *arg2 = 0 ;
    FXVec4f result; FXVec4f tmp1 ; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc); { if (TYPE(self) == T_ARRAY) {
            tmp1 = FXVec4f(NUM2DBL(rb_ary_entry(self, 0)), NUM2DBL(rb_ary_entry(self, 1)), NUM2DBL(rb_ary_entry(self, 2)), NUM2DBL(rb_ary_entry(self, 3)));
            arg1 = &tmp1; }  else { SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXVec4f, 1); }  }  {
        if (TYPE(argv[0]) == T_ARRAY) {
            arg2 = new FXVec4f(NUM2DBL(rb_ary_entry(argv[0], 0)), NUM2DBL(rb_ary_entry(argv[0], 1)), NUM2DBL(rb_ary_entry(argv[0], 2)), NUM2DBL(rb_ary_entry(argv[0], 3))); }
         else { FXVec4f *p; SWIG_ConvertPtr(argv[0],(void **)&p,SWIGTYPE_p_FXVec4f,1); arg2 = new FXVec4f(*p); }  } 
    result = FXVec4f_operator_Sa_((FXVec4f const *)arg1,(FXVec4f const &)*arg2); { FXVec4f* resultptr = new FXVec4f(result);
        vresult = FXRbGetRubyObj(resultptr, "FXVec4f *"); }  delete arg2; return vresult; }
static VALUE _wrap_FXVec4f___sub__(int argc, VALUE *argv, VALUE self) { FXVec4f *arg1 = (FXVec4f *) 0 ; FXVec4f *arg2 = 0 ;
    FXVec4f result; FXVec4f tmp1 ; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc); { if (TYPE(self) == T_ARRAY) {
            tmp1 = FXVec4f(NUM2DBL(rb_ary_entry(self, 0)), NUM2DBL(rb_ary_entry(self, 1)), NUM2DBL(rb_ary_entry(self, 2)), NUM2DBL(rb_ary_entry(self, 3)));
            arg1 = &tmp1; }  else { SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXVec4f, 1); }  }  {
        if (TYPE(argv[0]) == T_ARRAY) {
            arg2 = new FXVec4f(NUM2DBL(rb_ary_entry(argv[0], 0)), NUM2DBL(rb_ary_entry(argv[0], 1)), NUM2DBL(rb_ary_entry(argv[0], 2)), NUM2DBL(rb_ary_entry(argv[0], 3))); }
         else { FXVec4f *p; SWIG_ConvertPtr(argv[0],(void **)&p,SWIGTYPE_p_FXVec4f,1); arg2 = new FXVec4f(*p); }  } 
    result = FXVec4f_operator_Ss_((FXVec4f const *)arg1,(FXVec4f const &)*arg2); { FXVec4f* resultptr = new FXVec4f(result);
        vresult = FXRbGetRubyObj(resultptr, "FXVec4f *"); }  delete arg2; return vresult; }
static VALUE _wrap_FXVec4f___mul____SWIG_0(int argc, VALUE *argv, VALUE self) { FXVec4f *arg1 = (FXVec4f *) 0 ; FXfloat arg2 ;
    FXVec4f result; FXVec4f tmp1 ; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc); { if (TYPE(self) == T_ARRAY) {
            tmp1 = FXVec4f(NUM2DBL(rb_ary_entry(self, 0)), NUM2DBL(rb_ary_entry(self, 1)), NUM2DBL(rb_ary_entry(self, 2)), NUM2DBL(rb_ary_entry(self, 3)));
            arg1 = &tmp1; }  else { SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXVec4f, 1); }  } 
    arg2 = (FXfloat) NUM2DBL(argv[0]); result = FXVec4f_operator_Sm___SWIG_0((FXVec4f const *)arg1,arg2); {
        FXVec4f* resultptr = new FXVec4f(result); vresult = FXRbGetRubyObj(resultptr, "FXVec4f *"); }  return vresult; }
static VALUE _wrap_FXVec4f___div__(int argc, VALUE *argv, VALUE self) { FXVec4f *arg1 = (FXVec4f *) 0 ; FXfloat arg2 ;
    FXVec4f result; FXVec4f tmp1 ; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc); { if (TYPE(self) == T_ARRAY) {
            tmp1 = FXVec4f(NUM2DBL(rb_ary_entry(self, 0)), NUM2DBL(rb_ary_entry(self, 1)), NUM2DBL(rb_ary_entry(self, 2)), NUM2DBL(rb_ary_entry(self, 3)));
            arg1 = &tmp1; }  else { SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXVec4f, 1); }  } 
    arg2 = (FXfloat) NUM2DBL(argv[0]); result = FXVec4f_operator_Sd_((FXVec4f const *)arg1,arg2); {
        FXVec4f* resultptr = new FXVec4f(result); vresult = FXRbGetRubyObj(resultptr, "FXVec4f *"); }  return vresult; }
static VALUE _wrap_FXVec4f___mul____SWIG_1(int argc, VALUE *argv, VALUE self) { FXVec4f *arg1 = (FXVec4f *) 0 ;
    FXVec4f *arg2 = 0 ; FXfloat result; FXVec4f tmp1 ; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc); { if (TYPE(self) == T_ARRAY) {
            tmp1 = FXVec4f(NUM2DBL(rb_ary_entry(self, 0)), NUM2DBL(rb_ary_entry(self, 1)), NUM2DBL(rb_ary_entry(self, 2)), NUM2DBL(rb_ary_entry(self, 3)));
            arg1 = &tmp1; }  else { SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXVec4f, 1); }  }  {
        if (TYPE(argv[0]) == T_ARRAY) {
            arg2 = new FXVec4f(NUM2DBL(rb_ary_entry(argv[0], 0)), NUM2DBL(rb_ary_entry(argv[0], 1)), NUM2DBL(rb_ary_entry(argv[0], 2)), NUM2DBL(rb_ary_entry(argv[0], 3))); }
         else { FXVec4f *p; SWIG_ConvertPtr(argv[0],(void **)&p,SWIGTYPE_p_FXVec4f,1); arg2 = new FXVec4f(*p); }  } 
    result = (FXfloat)FXVec4f_operator_Sm___SWIG_1((FXVec4f const *)arg1,(FXVec4f const &)*arg2);
    vresult = rb_float_new(result); delete arg2; return vresult; }
static VALUE _wrap_FXVec4f___mul__(int nargs, VALUE *args, VALUE self) { int argc; VALUE argv[3]; int ii; argc = nargs + 1;
    argv[0] = self; for (ii = 1; (ii < argc) && (ii < 2); ii++) { argv[ii] = args[ii-1]; }  if (argc == 2) { int _v; {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXVec4f, 0) != -1)) ? 1 : 0; }
         if (_v) { { void *ptr;
                _v = (NIL_P(argv[1]) || (TYPE(argv[1]) == T_DATA && SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_FXVec4f, 0) != -1)) ? 1 : 0; }
             if (_v) { return _wrap_FXVec4f___mul____SWIG_1(nargs, args, self);}  }  }  if (argc == 2) { int _v; { void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXVec4f, 0) != -1)) ? 1 : 0; }
         if (_v) { { _v = ((TYPE(argv[1]) == T_FLOAT) || (TYPE(argv[1]) == T_FIXNUM) || (TYPE(argv[1]) == T_BIGNUM)) ? 1 : 0; } 
            if (_v) { return _wrap_FXVec4f___mul____SWIG_0(nargs, args, self);}  }  } 
    rb_raise(rb_eArgError, "No matching function for overloaded 'FXVec4f___mul__'"); return Qnil; }
static VALUE _wrap_FXVec4f_dot(int argc, VALUE *argv, VALUE self) { FXVec4f *arg1 = (FXVec4f *) 0 ; FXVec4f *arg2 = 0 ;
    FXfloat result; FXVec4f tmp1 ; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc); { if (TYPE(self) == T_ARRAY) {
            tmp1 = FXVec4f(NUM2DBL(rb_ary_entry(self, 0)), NUM2DBL(rb_ary_entry(self, 1)), NUM2DBL(rb_ary_entry(self, 2)), NUM2DBL(rb_ary_entry(self, 3)));
            arg1 = &tmp1; }  else { SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXVec4f, 1); }  }  {
        if (TYPE(argv[0]) == T_ARRAY) {
            arg2 = new FXVec4f(NUM2DBL(rb_ary_entry(argv[0], 0)), NUM2DBL(rb_ary_entry(argv[0], 1)), NUM2DBL(rb_ary_entry(argv[0], 2)), NUM2DBL(rb_ary_entry(argv[0], 3))); }
         else { FXVec4f *p; SWIG_ConvertPtr(argv[0],(void **)&p,SWIGTYPE_p_FXVec4f,1); arg2 = new FXVec4f(*p); }  } 
    result = (FXfloat)FXVec4f_dot((FXVec4f const *)arg1,(FXVec4f const &)*arg2); vresult = rb_float_new(result); delete arg2;
    return vresult; }
static VALUE _wrap_FXVec4f___eq____SWIG_0(int argc, VALUE *argv, VALUE self) { FXVec4f *arg1 = (FXVec4f *) 0 ;
    FXVec4f *arg2 = 0 ; bool result; FXVec4f tmp1 ; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc); { if (TYPE(self) == T_ARRAY) {
            tmp1 = FXVec4f(NUM2DBL(rb_ary_entry(self, 0)), NUM2DBL(rb_ary_entry(self, 1)), NUM2DBL(rb_ary_entry(self, 2)), NUM2DBL(rb_ary_entry(self, 3)));
            arg1 = &tmp1; }  else { SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXVec4f, 1); }  }  {
        if (TYPE(argv[0]) == T_ARRAY) {
            arg2 = new FXVec4f(NUM2DBL(rb_ary_entry(argv[0], 0)), NUM2DBL(rb_ary_entry(argv[0], 1)), NUM2DBL(rb_ary_entry(argv[0], 2)), NUM2DBL(rb_ary_entry(argv[0], 3))); }
         else { FXVec4f *p; SWIG_ConvertPtr(argv[0],(void **)&p,SWIGTYPE_p_FXVec4f,1); arg2 = new FXVec4f(*p); }  } 
    result = (bool)FXVec4f_operator_Se__Se___SWIG_0((FXVec4f const *)arg1,(FXVec4f const &)*arg2);
    vresult = result ? Qtrue : Qfalse; delete arg2; return vresult; }
static VALUE _wrap_FXVec4f___eq____SWIG_1(int argc, VALUE *argv, VALUE self) { FXVec4f *arg1 = (FXVec4f *) 0 ; FXfloat arg2 ;
    bool result; FXVec4f tmp1 ; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc); { if (TYPE(self) == T_ARRAY) {
            tmp1 = FXVec4f(NUM2DBL(rb_ary_entry(self, 0)), NUM2DBL(rb_ary_entry(self, 1)), NUM2DBL(rb_ary_entry(self, 2)), NUM2DBL(rb_ary_entry(self, 3)));
            arg1 = &tmp1; }  else { SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXVec4f, 1); }  } 
    arg2 = (FXfloat) NUM2DBL(argv[0]); result = (bool)FXVec4f_operator_Se__Se___SWIG_1((FXVec4f const *)arg1,arg2);
    vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXVec4f___eq__(int nargs, VALUE *args, VALUE self) { int argc; VALUE argv[3]; int ii; argc = nargs + 1;
    argv[0] = self; for (ii = 1; (ii < argc) && (ii < 2); ii++) { argv[ii] = args[ii-1]; }  if (argc == 2) { int _v; {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXVec4f, 0) != -1)) ? 1 : 0; }
         if (_v) { { void *ptr;
                _v = (NIL_P(argv[1]) || (TYPE(argv[1]) == T_DATA && SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_FXVec4f, 0) != -1)) ? 1 : 0; }
             if (_v) { return _wrap_FXVec4f___eq____SWIG_0(nargs, args, self);}  }  }  if (argc == 2) { int _v; { void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXVec4f, 0) != -1)) ? 1 : 0; }
         if (_v) { { _v = ((TYPE(argv[1]) == T_FLOAT) || (TYPE(argv[1]) == T_FIXNUM) || (TYPE(argv[1]) == T_BIGNUM)) ? 1 : 0; } 
            if (_v) { return _wrap_FXVec4f___eq____SWIG_1(nargs, args, self);}  }  } 
    rb_raise(rb_eArgError, "No matching function for overloaded 'FXVec4f___eq__'"); return Qnil; }
static VALUE _wrap_FXVec4f_len(int argc, VALUE *argv, VALUE self) { FXVec4f *arg1 = (FXVec4f *) 0 ; FXfloat result;
    FXVec4f tmp1 ; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc); { if (TYPE(self) == T_ARRAY) {
            tmp1 = FXVec4f(NUM2DBL(rb_ary_entry(self, 0)), NUM2DBL(rb_ary_entry(self, 1)), NUM2DBL(rb_ary_entry(self, 2)), NUM2DBL(rb_ary_entry(self, 3)));
            arg1 = &tmp1; }  else { SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXVec4f, 1); }  } 
    result = (FXfloat)FXVec4f_len((FXVec4f const *)arg1); vresult = rb_float_new(result); return vresult; }
static VALUE _wrap_FXVec4f_len2(int argc, VALUE *argv, VALUE self) { FXVec4f *arg1 = (FXVec4f *) 0 ; FXfloat result;
    FXVec4f tmp1 ; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc); { if (TYPE(self) == T_ARRAY) {
            tmp1 = FXVec4f(NUM2DBL(rb_ary_entry(self, 0)), NUM2DBL(rb_ary_entry(self, 1)), NUM2DBL(rb_ary_entry(self, 2)), NUM2DBL(rb_ary_entry(self, 3)));
            arg1 = &tmp1; }  else { SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXVec4f, 1); }  } 
    result = (FXfloat)FXVec4f_len2((FXVec4f const *)arg1); vresult = rb_float_new(result); return vresult; }
static VALUE _wrap_FXVec4f_normalize(int argc, VALUE *argv, VALUE self) { FXVec4f *arg1 = (FXVec4f *) 0 ; FXVec4f result;
    FXVec4f tmp1 ; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc); { if (TYPE(self) == T_ARRAY) {
            tmp1 = FXVec4f(NUM2DBL(rb_ary_entry(self, 0)), NUM2DBL(rb_ary_entry(self, 1)), NUM2DBL(rb_ary_entry(self, 2)), NUM2DBL(rb_ary_entry(self, 3)));
            arg1 = &tmp1; }  else { SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXVec4f, 1); }  } 
    result = FXVec4f_normalize((FXVec4f const *)arg1); { FXVec4f* resultptr = new FXVec4f(result);
        vresult = FXRbGetRubyObj(resultptr, "FXVec4f *"); }  return vresult; }
static VALUE _wrap_FXVec4f_lo(int argc, VALUE *argv, VALUE self) { FXVec4f *arg1 = (FXVec4f *) 0 ; FXVec4f *arg2 = 0 ;
    FXVec4f result; FXVec4f tmp1 ; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc); { if (TYPE(self) == T_ARRAY) {
            tmp1 = FXVec4f(NUM2DBL(rb_ary_entry(self, 0)), NUM2DBL(rb_ary_entry(self, 1)), NUM2DBL(rb_ary_entry(self, 2)), NUM2DBL(rb_ary_entry(self, 3)));
            arg1 = &tmp1; }  else { SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXVec4f, 1); }  }  {
        if (TYPE(argv[0]) == T_ARRAY) {
            arg2 = new FXVec4f(NUM2DBL(rb_ary_entry(argv[0], 0)), NUM2DBL(rb_ary_entry(argv[0], 1)), NUM2DBL(rb_ary_entry(argv[0], 2)), NUM2DBL(rb_ary_entry(argv[0], 3))); }
         else { FXVec4f *p; SWIG_ConvertPtr(argv[0],(void **)&p,SWIGTYPE_p_FXVec4f,1); arg2 = new FXVec4f(*p); }  } 
    result = FXVec4f_lo((FXVec4f const *)arg1,(FXVec4f const &)*arg2); { FXVec4f* resultptr = new FXVec4f(result);
        vresult = FXRbGetRubyObj(resultptr, "FXVec4f *"); }  delete arg2; return vresult; }
static VALUE _wrap_FXVec4f_hi(int argc, VALUE *argv, VALUE self) { FXVec4f *arg1 = (FXVec4f *) 0 ; FXVec4f *arg2 = 0 ;
    FXVec4f result; FXVec4f tmp1 ; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc); { if (TYPE(self) == T_ARRAY) {
            tmp1 = FXVec4f(NUM2DBL(rb_ary_entry(self, 0)), NUM2DBL(rb_ary_entry(self, 1)), NUM2DBL(rb_ary_entry(self, 2)), NUM2DBL(rb_ary_entry(self, 3)));
            arg1 = &tmp1; }  else { SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXVec4f, 1); }  }  {
        if (TYPE(argv[0]) == T_ARRAY) {
            arg2 = new FXVec4f(NUM2DBL(rb_ary_entry(argv[0], 0)), NUM2DBL(rb_ary_entry(argv[0], 1)), NUM2DBL(rb_ary_entry(argv[0], 2)), NUM2DBL(rb_ary_entry(argv[0], 3))); }
         else { FXVec4f *p; SWIG_ConvertPtr(argv[0],(void **)&p,SWIGTYPE_p_FXVec4f,1); arg2 = new FXVec4f(*p); }  } 
    result = FXVec4f_hi((FXVec4f const *)arg1,(FXVec4f const &)*arg2); { FXVec4f* resultptr = new FXVec4f(result);
        vresult = FXRbGetRubyObj(resultptr, "FXVec4f *"); }  delete arg2; return vresult; }
static VALUE _wrap_FXVec4f_to_a(int argc, VALUE *argv, VALUE self) { FXVec4f *arg1 = (FXVec4f *) 0 ; VALUE result;
    FXVec4f tmp1 ; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc); { if (TYPE(self) == T_ARRAY) {
            tmp1 = FXVec4f(NUM2DBL(rb_ary_entry(self, 0)), NUM2DBL(rb_ary_entry(self, 1)), NUM2DBL(rb_ary_entry(self, 2)), NUM2DBL(rb_ary_entry(self, 3)));
            arg1 = &tmp1; }  else { SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXVec4f, 1); }  } 
    result = (VALUE)FXVec4f_to_a((FXVec4f const *)arg1); vresult = result; return vresult; }
static VALUE _wrap_FXVec4f_to_s(int argc, VALUE *argv, VALUE self) { FXVec4f *arg1 = (FXVec4f *) 0 ; FXString result;
    FXVec4f tmp1 ; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc); { if (TYPE(self) == T_ARRAY) {
            tmp1 = FXVec4f(NUM2DBL(rb_ary_entry(self, 0)), NUM2DBL(rb_ary_entry(self, 1)), NUM2DBL(rb_ary_entry(self, 2)), NUM2DBL(rb_ary_entry(self, 3)));
            arg1 = &tmp1; }  else { SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXVec4f, 1); }  } 
    result = FXVec4f_to_s((FXVec4f const *)arg1); vresult = rb_str_new2((&result)->text()); return vresult; }
static VALUE _wrap_FXVec4d_x_set(int argc, VALUE *argv, VALUE self) { FXVec4d *arg1 = (FXVec4d *) 0 ; FXdouble arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXVec4d, 1); arg2 = (FXdouble) NUM2DBL(argv[0]);
    if (arg1) (arg1)->x = arg2; return Qnil; }
static VALUE _wrap_FXVec4d_x_get(int argc, VALUE *argv, VALUE self) { FXVec4d *arg1 = (FXVec4d *) 0 ; FXdouble result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXVec4d, 1); result = (FXdouble) ((arg1)->x);
    vresult = rb_float_new(result); return vresult; }
static VALUE _wrap_FXVec4d_y_set(int argc, VALUE *argv, VALUE self) { FXVec4d *arg1 = (FXVec4d *) 0 ; FXdouble arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXVec4d, 1); arg2 = (FXdouble) NUM2DBL(argv[0]);
    if (arg1) (arg1)->y = arg2; return Qnil; }
static VALUE _wrap_FXVec4d_y_get(int argc, VALUE *argv, VALUE self) { FXVec4d *arg1 = (FXVec4d *) 0 ; FXdouble result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXVec4d, 1); result = (FXdouble) ((arg1)->y);
    vresult = rb_float_new(result); return vresult; }
static VALUE _wrap_FXVec4d_z_set(int argc, VALUE *argv, VALUE self) { FXVec4d *arg1 = (FXVec4d *) 0 ; FXdouble arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXVec4d, 1); arg2 = (FXdouble) NUM2DBL(argv[0]);
    if (arg1) (arg1)->z = arg2; return Qnil; }
static VALUE _wrap_FXVec4d_z_get(int argc, VALUE *argv, VALUE self) { FXVec4d *arg1 = (FXVec4d *) 0 ; FXdouble result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXVec4d, 1); result = (FXdouble) ((arg1)->z);
    vresult = rb_float_new(result); return vresult; }
static VALUE _wrap_FXVec4d_w_set(int argc, VALUE *argv, VALUE self) { FXVec4d *arg1 = (FXVec4d *) 0 ; FXdouble arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXVec4d, 1); arg2 = (FXdouble) NUM2DBL(argv[0]);
    if (arg1) (arg1)->w = arg2; return Qnil; }
static VALUE _wrap_FXVec4d_w_get(int argc, VALUE *argv, VALUE self) { FXVec4d *arg1 = (FXVec4d *) 0 ; FXdouble result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXVec4d, 1); result = (FXdouble) ((arg1)->w);
    vresult = rb_float_new(result); return vresult; }
static VALUE _wrap_new_FXVec4d__SWIG_0(int argc, VALUE *argv, VALUE self) { FXVec4d *result; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc); { result = (FXVec4d *)new FXVec4d();
        DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result); if(rb_block_given_p()){ rb_yield(self); }  }  return self; }
static VALUE _wrap_new_FXVec4d__SWIG_1(int argc, VALUE *argv, VALUE self) { FXVec4d *arg1 = 0 ; FXVec4d *result;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXVec4d, 1); if (arg1 == NULL) rb_raise(rb_eTypeError, "null reference");
    { result = (FXVec4d *)new FXVec4d((FXVec4d const &)*arg1); DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result);
        if(rb_block_given_p()){ rb_yield(self); }  }  return self; }
static VALUE _wrap_new_FXVec4d__SWIG_2(int argc, VALUE *argv, VALUE self) { FXVec3d *arg1 = 0 ; FXVec4d *result;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXVec3d, 1); if (arg1 == NULL) rb_raise(rb_eTypeError, "null reference");
    { result = (FXVec4d *)new FXVec4d((FXVec3d const &)*arg1); DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result);
        if(rb_block_given_p()){ rb_yield(self); }  }  return self; }
static VALUE _wrap_new_FXVec4d__SWIG_3(int argc, VALUE *argv, VALUE self) { FXdouble arg1 ; FXdouble arg2 ; FXdouble arg3 ;
    FXdouble arg4 = (FXdouble) 1.0 ; FXVec4d *result; if ((argc < 3) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc); arg1 = (FXdouble) NUM2DBL(argv[0]);
    arg2 = (FXdouble) NUM2DBL(argv[1]); arg3 = (FXdouble) NUM2DBL(argv[2]); if (argc > 3) { arg4 = (FXdouble) NUM2DBL(argv[3]); }
     { result = (FXVec4d *)new FXVec4d(arg1,arg2,arg3,arg4); DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result);
        if(rb_block_given_p()){ rb_yield(self); }  }  return self; }
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE _wrap_FXVec4d_allocate(VALUE self) {
#else
     static VALUE _wrap_FXVec4d_allocate(int argc, VALUE *argv, VALUE self) {
#endif
         VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_FXVec4d);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
         return vresult; }
static VALUE _wrap_new_FXVec4d__SWIG_4(int argc, VALUE *argv, VALUE self) { FXColor arg1 ; FXVec4d *result;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc); arg1 = to_FXColor(argv[0]); {
        result = (FXVec4d *)new FXVec4d(arg1); DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result);
        if(rb_block_given_p()){ rb_yield(self); }  }  return self; }
static VALUE _wrap_new_FXVec4d(int nargs, VALUE *args, VALUE self) { int argc; VALUE argv[4]; int ii; argc = nargs;
    for (ii = 0; (ii < argc) && (ii < 4); ii++) { argv[ii] = args[ii]; }  if (argc == 0) {
        return _wrap_new_FXVec4d__SWIG_0(nargs, args, self);}  if (argc == 1) { int _v; { void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXVec4d, 0) != -1)) ? 1 : 0; }
         if (_v) { return _wrap_new_FXVec4d__SWIG_1(nargs, args, self);}  }  if (argc == 1) { int _v; { void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXVec3d, 0) != -1)) ? 1 : 0; }
         if (_v) { return _wrap_new_FXVec4d__SWIG_2(nargs, args, self);}  }  if (argc == 1) { int _v; {
            _v = ((TYPE(argv[0]) == T_FIXNUM) || (TYPE(argv[0]) == T_BIGNUM)) ? 1 : 0; }  if (_v) {
            return _wrap_new_FXVec4d__SWIG_4(nargs, args, self);}  }  if ((argc >= 3) && (argc <= 4)) { int _v; {
            _v = ((TYPE(argv[0]) == T_FLOAT) || (TYPE(argv[0]) == T_FIXNUM) || (TYPE(argv[0]) == T_BIGNUM)) ? 1 : 0; } 
        if (_v) { { _v = ((TYPE(argv[1]) == T_FLOAT) || (TYPE(argv[1]) == T_FIXNUM) || (TYPE(argv[1]) == T_BIGNUM)) ? 1 : 0; } 
            if (_v) { {
                    _v = ((TYPE(argv[2]) == T_FLOAT) || (TYPE(argv[2]) == T_FIXNUM) || (TYPE(argv[2]) == T_BIGNUM)) ? 1 : 0; } 
                if (_v) { if (argc <= 3) { return _wrap_new_FXVec4d__SWIG_3(nargs, args, self);}  {
                        _v = ((TYPE(argv[3]) == T_FLOAT) || (TYPE(argv[3]) == T_FIXNUM) || (TYPE(argv[3]) == T_BIGNUM)) ? 1 : 0; }
                     if (_v) { return _wrap_new_FXVec4d__SWIG_3(nargs, args, self);}  }  }  }  } 
    rb_raise(rb_eArgError, "No matching function for overloaded 'new_FXVec4d'"); return Qnil; }
static VALUE _wrap_FXVec4d___getitem__(int argc, VALUE *argv, VALUE self) { FXVec4d *arg1 = (FXVec4d *) 0 ; FXint arg2 ;
    FXdouble result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXVec4d, 1); arg2 = NUM2INT(argv[0]);
    result = (FXdouble)FXVec4d___getitem__((FXVec4d const *)arg1,arg2); vresult = rb_float_new(result); return vresult; }
static VALUE _wrap_FXVec4d___setitem__(int argc, VALUE *argv, VALUE self) { FXVec4d *arg1 = (FXVec4d *) 0 ; FXint arg2 ;
    FXdouble arg3 ; FXdouble result; VALUE vresult = Qnil; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXVec4d, 1); arg2 = NUM2INT(argv[0]); arg3 = (FXdouble) NUM2DBL(argv[1]);
    result = (FXdouble)FXVec4d___setitem__(arg1,arg2,arg3); vresult = rb_float_new(result); return vresult; }
static VALUE _wrap_FXVec4d___neg__(int argc, VALUE *argv, VALUE self) { FXVec4d *arg1 = (FXVec4d *) 0 ; FXVec4d result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXVec4d, 1); result = FXVec4d_operator_Ss_((FXVec4d const *)arg1); {
        FXVec4d * resultptr; resultptr = new FXVec4d((FXVec4d &)result);
        vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_FXVec4d, 1); }  return vresult; }
static VALUE _wrap_FXVec4d___add__(int argc, VALUE *argv, VALUE self) { FXVec4d *arg1 = (FXVec4d *) 0 ; FXVec4d *arg2 = 0 ;
    FXVec4d result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXVec4d, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXVec4d, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    result = FXVec4d_operator_Sa_((FXVec4d const *)arg1,(FXVec4d const &)*arg2); { FXVec4d * resultptr;
        resultptr = new FXVec4d((FXVec4d &)result); vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_FXVec4d, 1); } 
    return vresult; }
static VALUE _wrap_FXVec4d___sub__(int argc, VALUE *argv, VALUE self) { FXVec4d *arg1 = (FXVec4d *) 0 ; FXVec4d *arg2 = 0 ;
    FXVec4d result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXVec4d, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXVec4d, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    result = FXVec4d_operator_Ss_((FXVec4d const *)arg1,(FXVec4d const &)*arg2); { FXVec4d * resultptr;
        resultptr = new FXVec4d((FXVec4d &)result); vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_FXVec4d, 1); } 
    return vresult; }
static VALUE _wrap_FXVec4d___mul____SWIG_0(int argc, VALUE *argv, VALUE self) { FXVec4d *arg1 = (FXVec4d *) 0 ; FXdouble arg2 ;
    FXVec4d result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXVec4d, 1); arg2 = (FXdouble) NUM2DBL(argv[0]);
    result = FXVec4d_operator_Sm___SWIG_0((FXVec4d const *)arg1,arg2); { FXVec4d * resultptr;
        resultptr = new FXVec4d((FXVec4d &)result); vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_FXVec4d, 1); } 
    return vresult; }
static VALUE _wrap_FXVec4d___div__(int argc, VALUE *argv, VALUE self) { FXVec4d *arg1 = (FXVec4d *) 0 ; FXdouble arg2 ;
    FXVec4d result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXVec4d, 1); arg2 = (FXdouble) NUM2DBL(argv[0]);
    result = FXVec4d_operator_Sd_((FXVec4d const *)arg1,arg2); { FXVec4d * resultptr;
        resultptr = new FXVec4d((FXVec4d &)result); vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_FXVec4d, 1); } 
    return vresult; }
static VALUE _wrap_FXVec4d___mul____SWIG_1(int argc, VALUE *argv, VALUE self) { FXVec4d *arg1 = (FXVec4d *) 0 ;
    FXVec4d *arg2 = 0 ; FXdouble result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXVec4d, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXVec4d, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    result = (FXdouble)FXVec4d_operator_Sm___SWIG_1((FXVec4d const *)arg1,(FXVec4d const &)*arg2);
    vresult = rb_float_new(result); return vresult; }
static VALUE _wrap_FXVec4d___mul__(int nargs, VALUE *args, VALUE self) { int argc; VALUE argv[3]; int ii; argc = nargs + 1;
    argv[0] = self; for (ii = 1; (ii < argc) && (ii < 2); ii++) { argv[ii] = args[ii-1]; }  if (argc == 2) { int _v; {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXVec4d, 0) != -1)) ? 1 : 0; }
         if (_v) { { void *ptr;
                _v = (NIL_P(argv[1]) || (TYPE(argv[1]) == T_DATA && SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_FXVec4d, 0) != -1)) ? 1 : 0; }
             if (_v) { return _wrap_FXVec4d___mul____SWIG_1(nargs, args, self);}  }  }  if (argc == 2) { int _v; { void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXVec4d, 0) != -1)) ? 1 : 0; }
         if (_v) { { _v = ((TYPE(argv[1]) == T_FLOAT) || (TYPE(argv[1]) == T_FIXNUM) || (TYPE(argv[1]) == T_BIGNUM)) ? 1 : 0; } 
            if (_v) { return _wrap_FXVec4d___mul____SWIG_0(nargs, args, self);}  }  } 
    rb_raise(rb_eArgError, "No matching function for overloaded 'FXVec4d___mul__'"); return Qnil; }
static VALUE _wrap_FXVec4d_dot(int argc, VALUE *argv, VALUE self) { FXVec4d *arg1 = (FXVec4d *) 0 ; FXVec4d *arg2 = 0 ;
    FXdouble result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXVec4d, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXVec4d, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    result = (FXdouble)FXVec4d_dot((FXVec4d const *)arg1,(FXVec4d const &)*arg2); vresult = rb_float_new(result);
    return vresult; }
static VALUE _wrap_FXVec4d___eq__(int argc, VALUE *argv, VALUE self) { FXVec4d *arg1 = (FXVec4d *) 0 ; FXVec4d *arg2 = 0 ;
    bool result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXVec4d, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXVec4d, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    result = (bool)FXVec4d_operator_Se__Se_((FXVec4d const *)arg1,(FXVec4d const &)*arg2); vresult = result ? Qtrue : Qfalse;
    return vresult; }
static VALUE _wrap_FXVec4d_len2(int argc, VALUE *argv, VALUE self) { FXVec4d *arg1 = (FXVec4d *) 0 ; FXdouble result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXVec4d, 1); result = (FXdouble)FXVec4d_len2((FXVec4d const *)arg1);
    vresult = rb_float_new(result); return vresult; }
static VALUE _wrap_FXVec4d_len(int argc, VALUE *argv, VALUE self) { FXVec4d *arg1 = (FXVec4d *) 0 ; FXdouble result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXVec4d, 1); result = (FXdouble)FXVec4d_len((FXVec4d const *)arg1);
    vresult = rb_float_new(result); return vresult; }
static VALUE _wrap_FXVec4d_normalize(int argc, VALUE *argv, VALUE self) { FXVec4d *arg1 = (FXVec4d *) 0 ; FXVec4d result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXVec4d, 1); result = FXVec4d_normalize((FXVec4d const *)arg1); {
        FXVec4d * resultptr; resultptr = new FXVec4d((FXVec4d &)result);
        vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_FXVec4d, 1); }  return vresult; }
static VALUE _wrap_FXVec4d_lo(int argc, VALUE *argv, VALUE self) { FXVec4d *arg1 = (FXVec4d *) 0 ; FXVec4d *arg2 = 0 ;
    FXVec4d result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXVec4d, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXVec4d, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    result = FXVec4d_lo((FXVec4d const *)arg1,(FXVec4d const &)*arg2); { FXVec4d * resultptr;
        resultptr = new FXVec4d((FXVec4d &)result); vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_FXVec4d, 1); } 
    return vresult; }
static VALUE _wrap_FXVec4d_hi(int argc, VALUE *argv, VALUE self) { FXVec4d *arg1 = (FXVec4d *) 0 ; FXVec4d *arg2 = 0 ;
    FXVec4d result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXVec4d, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXVec4d, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    result = FXVec4d_hi((FXVec4d const *)arg1,(FXVec4d const &)*arg2); { FXVec4d * resultptr;
        resultptr = new FXVec4d((FXVec4d &)result); vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_FXVec4d, 1); } 
    return vresult; }
static VALUE _wrap_FXVec4d_to_a(int argc, VALUE *argv, VALUE self) { FXVec4d *arg1 = (FXVec4d *) 0 ; VALUE result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXVec4d, 1); result = (VALUE)FXVec4d_to_a((FXVec4d const *)arg1);
    vresult = result; return vresult; }
static VALUE _wrap_FXVec4d_to_s(int argc, VALUE *argv, VALUE self) { FXVec4d *arg1 = (FXVec4d *) 0 ; FXString result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXVec4d, 1); result = FXVec4d_to_s((FXVec4d const *)arg1);
    vresult = rb_str_new2((&result)->text()); return vresult; }
static VALUE _wrap_new_FXQuatf__SWIG_0(int argc, VALUE *argv, VALUE self) { FXQuatf *result; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc); { result = (FXQuatf *)new FXQuatf();
        DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result); if(rb_block_given_p()){ rb_yield(self); }  }  return self; }
static VALUE _wrap_new_FXQuatf__SWIG_1(int argc, VALUE *argv, VALUE self) { FXVec3f *arg1 = 0 ; FXfloat arg2 = (FXfloat) 0.0 ;
    FXQuatf *result; if ((argc < 1) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc); {
        if (TYPE(argv[0]) == T_ARRAY) {
            arg1 = new FXVec3f(NUM2DBL(rb_ary_entry(argv[0], 0)), NUM2DBL(rb_ary_entry(argv[0], 1)), NUM2DBL(rb_ary_entry(argv[0], 2))); }
         else { FXVec3f *p; SWIG_ConvertPtr(argv[0], (void **)&p, SWIGTYPE_p_FXVec3f, 1); arg1 = new FXVec3f(*p); }  } 
    if (argc > 1) { arg2 = (FXfloat) NUM2DBL(argv[1]); }  { result = (FXQuatf *)new FXQuatf((FXVec3f const &)*arg1,arg2);
        DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result); if(rb_block_given_p()){ rb_yield(self); }  }  delete arg1;
    return self; }
static VALUE _wrap_new_FXQuatf__SWIG_2(int argc, VALUE *argv, VALUE self) { FXfloat arg1 ; FXfloat arg2 ; FXfloat arg3 ;
    FXQuatf *result; if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    arg1 = (FXfloat) NUM2DBL(argv[0]); arg2 = (FXfloat) NUM2DBL(argv[1]); arg3 = (FXfloat) NUM2DBL(argv[2]); {
        result = (FXQuatf *)new FXQuatf(arg1,arg2,arg3); DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result);
        if(rb_block_given_p()){ rb_yield(self); }  }  return self; }
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE _wrap_FXQuatf_allocate(VALUE self) {
#else
     static VALUE _wrap_FXQuatf_allocate(int argc, VALUE *argv, VALUE self) {
#endif
         VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_FXQuatf);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
         return vresult; }
static VALUE _wrap_new_FXQuatf__SWIG_3(int argc, VALUE *argv, VALUE self) { FXfloat arg1 ; FXfloat arg2 ; FXfloat arg3 ;
    FXfloat arg4 ; FXQuatf *result; if ((argc < 4) || (argc > 4)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    arg1 = (FXfloat) NUM2DBL(argv[0]); arg2 = (FXfloat) NUM2DBL(argv[1]); arg3 = (FXfloat) NUM2DBL(argv[2]);
    arg4 = (FXfloat) NUM2DBL(argv[3]); { result = (FXQuatf *)new FXQuatf(arg1,arg2,arg3,arg4);
        DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result); if(rb_block_given_p()){ rb_yield(self); }  }  return self; }
static VALUE _wrap_new_FXQuatf(int nargs, VALUE *args, VALUE self) { int argc; VALUE argv[4]; int ii; argc = nargs;
    for (ii = 0; (ii < argc) && (ii < 4); ii++) { argv[ii] = args[ii]; }  if (argc == 0) {
        return _wrap_new_FXQuatf__SWIG_0(nargs, args, self);}  if ((argc >= 1) && (argc <= 2)) { int _v; { void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXVec3f, 0) != -1)) ? 1 : 0; }
         if (_v) { if (argc <= 1) { return _wrap_new_FXQuatf__SWIG_1(nargs, args, self);}  {
                _v = ((TYPE(argv[1]) == T_FLOAT) || (TYPE(argv[1]) == T_FIXNUM) || (TYPE(argv[1]) == T_BIGNUM)) ? 1 : 0; } 
            if (_v) { return _wrap_new_FXQuatf__SWIG_1(nargs, args, self);}  }  }  if (argc == 3) { int _v; {
            _v = ((TYPE(argv[0]) == T_FLOAT) || (TYPE(argv[0]) == T_FIXNUM) || (TYPE(argv[0]) == T_BIGNUM)) ? 1 : 0; } 
        if (_v) { { _v = ((TYPE(argv[1]) == T_FLOAT) || (TYPE(argv[1]) == T_FIXNUM) || (TYPE(argv[1]) == T_BIGNUM)) ? 1 : 0; } 
            if (_v) { {
                    _v = ((TYPE(argv[2]) == T_FLOAT) || (TYPE(argv[2]) == T_FIXNUM) || (TYPE(argv[2]) == T_BIGNUM)) ? 1 : 0; } 
                if (_v) { return _wrap_new_FXQuatf__SWIG_2(nargs, args, self);}  }  }  }  if (argc == 4) { int _v; {
            _v = ((TYPE(argv[0]) == T_FLOAT) || (TYPE(argv[0]) == T_FIXNUM) || (TYPE(argv[0]) == T_BIGNUM)) ? 1 : 0; } 
        if (_v) { { _v = ((TYPE(argv[1]) == T_FLOAT) || (TYPE(argv[1]) == T_FIXNUM) || (TYPE(argv[1]) == T_BIGNUM)) ? 1 : 0; } 
            if (_v) { {
                    _v = ((TYPE(argv[2]) == T_FLOAT) || (TYPE(argv[2]) == T_FIXNUM) || (TYPE(argv[2]) == T_BIGNUM)) ? 1 : 0; } 
                if (_v) { {
                        _v = ((TYPE(argv[3]) == T_FLOAT) || (TYPE(argv[3]) == T_FIXNUM) || (TYPE(argv[3]) == T_BIGNUM)) ? 1 : 0; }
                     if (_v) { return _wrap_new_FXQuatf__SWIG_3(nargs, args, self);}  }  }  }  } 
    rb_raise(rb_eArgError, "No matching function for overloaded 'new_FXQuatf'"); return Qnil; }
static VALUE _wrap_FXQuatf_adjustN___(int argc, VALUE *argv, VALUE self) { FXQuatf *arg1 = (FXQuatf *) 0 ; FXQuatf *result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXQuatf, 1); { FXQuatf &_result_ref = (arg1)->adjust();
        result = (FXQuatf *) &_result_ref; }  vresult = FXRbGetRubyObj(result, "FXQuatf *"); return vresult; }
static VALUE _wrap_FXQuatf_setAxisAngle(int argc, VALUE *argv, VALUE self) { FXQuatf *arg1 = (FXQuatf *) 0 ; FXVec3f *arg2 = 0 ;
    FXfloat arg3 = (FXfloat) 0.0f ; if ((argc < 1) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXQuatf, 1); { if (TYPE(argv[0]) == T_ARRAY) {
            arg2 = new FXVec3f(NUM2DBL(rb_ary_entry(argv[0], 0)), NUM2DBL(rb_ary_entry(argv[0], 1)), NUM2DBL(rb_ary_entry(argv[0], 2))); }
         else { FXVec3f *p; SWIG_ConvertPtr(argv[0], (void **)&p, SWIGTYPE_p_FXVec3f, 1); arg2 = new FXVec3f(*p); }  } 
    if (argc > 1) { arg3 = (FXfloat) NUM2DBL(argv[1]); }  (arg1)->setAxisAngle((FXVec3f const &)*arg2,arg3); delete arg2;
    return Qnil; }
static VALUE _wrap_FXQuatf_getAxisAngle(int argc, VALUE *argv, VALUE self) { FXQuatf *arg1 = (FXQuatf *) 0 ; VALUE result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXQuatf, 1); result = (VALUE)FXQuatf_getAxisAngle((FXQuatf const *)arg1);
    vresult = result; return vresult; }
static VALUE _wrap_FXQuatf_setRollPitchYaw(int argc, VALUE *argv, VALUE self) { FXQuatf *arg1 = (FXQuatf *) 0 ; FXfloat arg2 ;
    FXfloat arg3 ; FXfloat arg4 ; if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXQuatf, 1); arg2 = (FXfloat) NUM2DBL(argv[0]);
    arg3 = (FXfloat) NUM2DBL(argv[1]); arg4 = (FXfloat) NUM2DBL(argv[2]); (arg1)->setRollPitchYaw(arg2,arg3,arg4); return Qnil; }
static VALUE _wrap_FXQuatf_getRollPitchYaw(int argc, VALUE *argv, VALUE self) { FXQuatf *arg1 = (FXQuatf *) 0 ; VALUE result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXQuatf, 1);
    result = (VALUE)FXQuatf_getRollPitchYaw((FXQuatf const *)arg1); vresult = result; return vresult; }
static VALUE _wrap_FXQuatf_exp(int argc, VALUE *argv, VALUE self) { FXQuatf *arg1 = (FXQuatf *) 0 ; FXQuatf result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXQuatf, 1); result = FXQuatf_exp((FXQuatf const *)arg1); {
        FXQuatf *resultptr = new FXQuatf(result); vresult = FXRbGetRubyObj(resultptr, "FXQuatf *"); }  return vresult; }
static VALUE _wrap_FXQuatf_log(int argc, VALUE *argv, VALUE self) { FXQuatf *arg1 = (FXQuatf *) 0 ; FXQuatf result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXQuatf, 1); result = FXQuatf_log((FXQuatf const *)arg1); {
        FXQuatf *resultptr = new FXQuatf(result); vresult = FXRbGetRubyObj(resultptr, "FXQuatf *"); }  return vresult; }
static VALUE _wrap_FXQuatf_invert(int argc, VALUE *argv, VALUE self) { FXQuatf *arg1 = (FXQuatf *) 0 ; FXQuatf result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXQuatf, 1); result = FXQuatf_invert((FXQuatf const *)arg1); {
        FXQuatf *resultptr = new FXQuatf(result); vresult = FXRbGetRubyObj(resultptr, "FXQuatf *"); }  return vresult; }
static VALUE _wrap_FXQuatf_unitinvert(int argc, VALUE *argv, VALUE self) { FXQuatf *arg1 = (FXQuatf *) 0 ; FXQuatf result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXQuatf, 1); result = FXQuatf_unitinvert((FXQuatf const *)arg1); {
        FXQuatf *resultptr = new FXQuatf(result); vresult = FXRbGetRubyObj(resultptr, "FXQuatf *"); }  return vresult; }
static VALUE _wrap_FXQuatf_conj(int argc, VALUE *argv, VALUE self) { FXQuatf *arg1 = (FXQuatf *) 0 ; FXQuatf result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXQuatf, 1); result = FXQuatf_conj((FXQuatf const *)arg1); {
        FXQuatf *resultptr = new FXQuatf(result); vresult = FXRbGetRubyObj(resultptr, "FXQuatf *"); }  return vresult; }
static VALUE _wrap_FXQuatf___mul____SWIG_0(int argc, VALUE *argv, VALUE self) { FXQuatf *arg1 = (FXQuatf *) 0 ;
    FXQuatf *arg2 = 0 ; FXQuatf result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXQuatf, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXQuatf, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    result = FXQuatf_operator_Sm___SWIG_0((FXQuatf const *)arg1,(FXQuatf const &)*arg2); {
        FXQuatf *resultptr = new FXQuatf(result); vresult = FXRbGetRubyObj(resultptr, "FXQuatf *"); }  return vresult; }
static VALUE _wrap_FXQuatf___mul____SWIG_1(int argc, VALUE *argv, VALUE self) { FXQuatf *arg1 = (FXQuatf *) 0 ;
    FXVec3f *arg2 = 0 ; FXVec3f result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXQuatf, 1); { if (TYPE(argv[0]) == T_ARRAY) {
            arg2 = new FXVec3f(NUM2DBL(rb_ary_entry(argv[0], 0)), NUM2DBL(rb_ary_entry(argv[0], 1)), NUM2DBL(rb_ary_entry(argv[0], 2))); }
         else { FXVec3f *p; SWIG_ConvertPtr(argv[0], (void **)&p, SWIGTYPE_p_FXVec3f, 1); arg2 = new FXVec3f(*p); }  } 
    result = FXQuatf_operator_Sm___SWIG_1((FXQuatf const *)arg1,(FXVec3f const &)*arg2); {
        FXVec3f* resultptr = new FXVec3f(result); vresult = FXRbGetRubyObj(resultptr, "FXVec3f *"); }  delete arg2;
    return vresult; }
static VALUE _wrap_FXQuatf___mul__(int nargs, VALUE *args, VALUE self) { int argc; VALUE argv[3]; int ii; argc = nargs + 1;
    argv[0] = self; for (ii = 1; (ii < argc) && (ii < 2); ii++) { argv[ii] = args[ii-1]; }  if (argc == 2) { int _v; {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXQuatf, 0) != -1)) ? 1 : 0; }
         if (_v) { { void *ptr;
                _v = (NIL_P(argv[1]) || (TYPE(argv[1]) == T_DATA && SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_FXQuatf, 0) != -1)) ? 1 : 0; }
             if (_v) { return _wrap_FXQuatf___mul____SWIG_0(nargs, args, self);}  }  }  if (argc == 2) { int _v; { void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXQuatf, 0) != -1)) ? 1 : 0; }
         if (_v) { { void *ptr;
                _v = (NIL_P(argv[1]) || (TYPE(argv[1]) == T_DATA && SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_FXVec3f, 0) != -1)) ? 1 : 0; }
             if (_v) { return _wrap_FXQuatf___mul____SWIG_1(nargs, args, self);}  }  } 
    rb_raise(rb_eArgError, "No matching function for overloaded 'FXQuatf___mul__'"); return Qnil; }
static VALUE _wrap_FXQuatf_arc(int argc, VALUE *argv, VALUE self) { FXVec3f *arg1 = 0 ; FXVec3f *arg2 = 0 ; FXQuatf result;
    VALUE vresult = Qnil; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc); {
        if (TYPE(argv[0]) == T_ARRAY) {
            arg1 = new FXVec3f(NUM2DBL(rb_ary_entry(argv[0], 0)), NUM2DBL(rb_ary_entry(argv[0], 1)), NUM2DBL(rb_ary_entry(argv[0], 2))); }
         else { FXVec3f *p; SWIG_ConvertPtr(argv[0], (void **)&p, SWIGTYPE_p_FXVec3f, 1); arg1 = new FXVec3f(*p); }  }  {
        if (TYPE(argv[1]) == T_ARRAY) {
            arg2 = new FXVec3f(NUM2DBL(rb_ary_entry(argv[1], 0)), NUM2DBL(rb_ary_entry(argv[1], 1)), NUM2DBL(rb_ary_entry(argv[1], 2))); }
         else { FXVec3f *p; SWIG_ConvertPtr(argv[1], (void **)&p, SWIGTYPE_p_FXVec3f, 1); arg2 = new FXVec3f(*p); }  } 
    result = FXQuatf_arc((FXVec3f const &)*arg1,(FXVec3f const &)*arg2); { FXQuatf *resultptr = new FXQuatf(result);
        vresult = FXRbGetRubyObj(resultptr, "FXQuatf *"); }  delete arg1; delete arg2; return vresult; }
static VALUE _wrap_FXQuatf_lerp(int argc, VALUE *argv, VALUE self) { FXQuatf *arg1 = 0 ; FXQuatf *arg2 = 0 ; FXfloat arg3 ;
    FXQuatf result; VALUE vresult = Qnil; if ((argc < 3) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXQuatf, 1); if (arg1 == NULL) rb_raise(rb_eTypeError, "null reference");
    SWIG_ConvertPtr(argv[1], (void **) &arg2, SWIGTYPE_p_FXQuatf, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    arg3 = (FXfloat) NUM2DBL(argv[2]); result = FXQuatf_lerp((FXQuatf const &)*arg1,(FXQuatf const &)*arg2,arg3); {
        FXQuatf *resultptr = new FXQuatf(result); vresult = FXRbGetRubyObj(resultptr, "FXQuatf *"); }  return vresult; }
static VALUE _wrap_new_FXQuatd__SWIG_0(int argc, VALUE *argv, VALUE self) { FXQuatd *result; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc); { result = (FXQuatd *)new FXQuatd();
        DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result); if(rb_block_given_p()){ rb_yield(self); }  }  return self; }
static VALUE _wrap_new_FXQuatd__SWIG_1(int argc, VALUE *argv, VALUE self) { FXQuatd *arg1 = 0 ; FXQuatd *result;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXQuatd, 1); if (arg1 == NULL) rb_raise(rb_eTypeError, "null reference");
    { result = (FXQuatd *)new FXQuatd((FXQuatd const &)*arg1); DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result);
        if(rb_block_given_p()){ rb_yield(self); }  }  return self; }
static VALUE _wrap_new_FXQuatd__SWIG_2(int argc, VALUE *argv, VALUE self) { FXdouble arg1 ; FXdouble arg2 ; FXdouble arg3 ;
    FXdouble arg4 ; FXQuatd *result; if ((argc < 4) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc); arg1 = (FXdouble) NUM2DBL(argv[0]);
    arg2 = (FXdouble) NUM2DBL(argv[1]); arg3 = (FXdouble) NUM2DBL(argv[2]); arg4 = (FXdouble) NUM2DBL(argv[3]); {
        result = (FXQuatd *)new FXQuatd(arg1,arg2,arg3,arg4); DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result);
        if(rb_block_given_p()){ rb_yield(self); }  }  return self; }
static VALUE _wrap_new_FXQuatd__SWIG_3(int argc, VALUE *argv, VALUE self) { FXVec3d *arg1 = 0 ; FXdouble arg2 = (FXdouble) 0.0 ;
    FXQuatd *result; if ((argc < 1) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXVec3d, 1); if (arg1 == NULL) rb_raise(rb_eTypeError, "null reference");
    if (argc > 1) { arg2 = (FXdouble) NUM2DBL(argv[1]); }  { result = (FXQuatd *)new FXQuatd((FXVec3d const &)*arg1,arg2);
        DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result); if(rb_block_given_p()){ rb_yield(self); }  }  return self; }
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE _wrap_FXQuatd_allocate(VALUE self) {
#else
     static VALUE _wrap_FXQuatd_allocate(int argc, VALUE *argv, VALUE self) {
#endif
         VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_FXQuatd);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
         return vresult; }
static VALUE _wrap_new_FXQuatd__SWIG_4(int argc, VALUE *argv, VALUE self) { FXdouble arg1 ; FXdouble arg2 ; FXdouble arg3 ;
    FXQuatd *result; if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    arg1 = (FXdouble) NUM2DBL(argv[0]); arg2 = (FXdouble) NUM2DBL(argv[1]); arg3 = (FXdouble) NUM2DBL(argv[2]); {
        result = (FXQuatd *)new FXQuatd(arg1,arg2,arg3); DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result);
        if(rb_block_given_p()){ rb_yield(self); }  }  return self; }
static VALUE _wrap_new_FXQuatd(int nargs, VALUE *args, VALUE self) { int argc; VALUE argv[4]; int ii; argc = nargs;
    for (ii = 0; (ii < argc) && (ii < 4); ii++) { argv[ii] = args[ii]; }  if (argc == 0) {
        return _wrap_new_FXQuatd__SWIG_0(nargs, args, self);}  if (argc == 1) { int _v; { void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXQuatd, 0) != -1)) ? 1 : 0; }
         if (_v) { return _wrap_new_FXQuatd__SWIG_1(nargs, args, self);}  }  if ((argc >= 1) && (argc <= 2)) { int _v; {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXVec3d, 0) != -1)) ? 1 : 0; }
         if (_v) { if (argc <= 1) { return _wrap_new_FXQuatd__SWIG_3(nargs, args, self);}  {
                _v = ((TYPE(argv[1]) == T_FLOAT) || (TYPE(argv[1]) == T_FIXNUM) || (TYPE(argv[1]) == T_BIGNUM)) ? 1 : 0; } 
            if (_v) { return _wrap_new_FXQuatd__SWIG_3(nargs, args, self);}  }  }  if (argc == 3) { int _v; {
            _v = ((TYPE(argv[0]) == T_FLOAT) || (TYPE(argv[0]) == T_FIXNUM) || (TYPE(argv[0]) == T_BIGNUM)) ? 1 : 0; } 
        if (_v) { { _v = ((TYPE(argv[1]) == T_FLOAT) || (TYPE(argv[1]) == T_FIXNUM) || (TYPE(argv[1]) == T_BIGNUM)) ? 1 : 0; } 
            if (_v) { {
                    _v = ((TYPE(argv[2]) == T_FLOAT) || (TYPE(argv[2]) == T_FIXNUM) || (TYPE(argv[2]) == T_BIGNUM)) ? 1 : 0; } 
                if (_v) { return _wrap_new_FXQuatd__SWIG_4(nargs, args, self);}  }  }  }  if (argc == 4) { int _v; {
            _v = ((TYPE(argv[0]) == T_FLOAT) || (TYPE(argv[0]) == T_FIXNUM) || (TYPE(argv[0]) == T_BIGNUM)) ? 1 : 0; } 
        if (_v) { { _v = ((TYPE(argv[1]) == T_FLOAT) || (TYPE(argv[1]) == T_FIXNUM) || (TYPE(argv[1]) == T_BIGNUM)) ? 1 : 0; } 
            if (_v) { {
                    _v = ((TYPE(argv[2]) == T_FLOAT) || (TYPE(argv[2]) == T_FIXNUM) || (TYPE(argv[2]) == T_BIGNUM)) ? 1 : 0; } 
                if (_v) { {
                        _v = ((TYPE(argv[3]) == T_FLOAT) || (TYPE(argv[3]) == T_FIXNUM) || (TYPE(argv[3]) == T_BIGNUM)) ? 1 : 0; }
                     if (_v) { return _wrap_new_FXQuatd__SWIG_2(nargs, args, self);}  }  }  }  } 
    rb_raise(rb_eArgError, "No matching function for overloaded 'new_FXQuatd'"); return Qnil; }
static VALUE _wrap_FXQuatd_adjust(int argc, VALUE *argv, VALUE self) { FXQuatd *arg1 = (FXQuatd *) 0 ; FXQuatd *result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXQuatd, 1); { FXQuatd &_result_ref = (arg1)->adjust();
        result = (FXQuatd *) &_result_ref; }  vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_FXQuatd,0);
    return vresult; }
static VALUE _wrap_FXQuatd_setAxisAngle(int argc, VALUE *argv, VALUE self) { FXQuatd *arg1 = (FXQuatd *) 0 ; FXVec3d *arg2 = 0 ;
    FXdouble arg3 = (FXdouble) 0.0 ; if ((argc < 1) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXQuatd, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXVec3d, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    if (argc > 1) { arg3 = (FXdouble) NUM2DBL(argv[1]); }  (arg1)->setAxisAngle((FXVec3d const &)*arg2,arg3); return Qnil; }
static VALUE _wrap_FXQuatd_getAxisAngle(int argc, VALUE *argv, VALUE self) { FXQuatd *arg1 = (FXQuatd *) 0 ; VALUE result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXQuatd, 1); result = (VALUE)FXQuatd_getAxisAngle((FXQuatd const *)arg1);
    vresult = result; return vresult; }
static VALUE _wrap_FXQuatd_setRollPitchYaw(int argc, VALUE *argv, VALUE self) { FXQuatd *arg1 = (FXQuatd *) 0 ; FXdouble arg2 ;
    FXdouble arg3 ; FXdouble arg4 ; if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXQuatd, 1); arg2 = (FXdouble) NUM2DBL(argv[0]);
    arg3 = (FXdouble) NUM2DBL(argv[1]); arg4 = (FXdouble) NUM2DBL(argv[2]); (arg1)->setRollPitchYaw(arg2,arg3,arg4);
    return Qnil; }
static VALUE _wrap_FXQuatd_getRollPitchYaw(int argc, VALUE *argv, VALUE self) { FXQuatd *arg1 = (FXQuatd *) 0 ; VALUE result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXQuatd, 1);
    result = (VALUE)FXQuatd_getRollPitchYaw((FXQuatd const *)arg1); vresult = result; return vresult; }
static VALUE _wrap_FXQuatd_exp(int argc, VALUE *argv, VALUE self) { FXQuatd *arg1 = (FXQuatd *) 0 ; FXQuatd result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXQuatd, 1); result = FXQuatd_exp((FXQuatd const *)arg1); {
        FXQuatd * resultptr; resultptr = new FXQuatd((FXQuatd &)result);
        vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_FXQuatd, 1); }  return vresult; }
static VALUE _wrap_FXQuatd_log(int argc, VALUE *argv, VALUE self) { FXQuatd *arg1 = (FXQuatd *) 0 ; FXQuatd result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXQuatd, 1); result = FXQuatd_log((FXQuatd const *)arg1); {
        FXQuatd * resultptr; resultptr = new FXQuatd((FXQuatd &)result);
        vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_FXQuatd, 1); }  return vresult; }
static VALUE _wrap_FXQuatd_invert(int argc, VALUE *argv, VALUE self) { FXQuatd *arg1 = (FXQuatd *) 0 ; FXQuatd result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXQuatd, 1); result = FXQuatd_invert((FXQuatd const *)arg1); {
        FXQuatd * resultptr; resultptr = new FXQuatd((FXQuatd &)result);
        vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_FXQuatd, 1); }  return vresult; }
static VALUE _wrap_FXQuatd_unitinvert(int argc, VALUE *argv, VALUE self) { FXQuatd *arg1 = (FXQuatd *) 0 ; FXQuatd result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXQuatd, 1); result = FXQuatd_unitinvert((FXQuatd const *)arg1); {
        FXQuatd * resultptr; resultptr = new FXQuatd((FXQuatd &)result);
        vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_FXQuatd, 1); }  return vresult; }
static VALUE _wrap_FXQuatd_conj(int argc, VALUE *argv, VALUE self) { FXQuatd *arg1 = (FXQuatd *) 0 ; FXQuatd result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXQuatd, 1); result = FXQuatd_conj((FXQuatd const *)arg1); {
        FXQuatd * resultptr; resultptr = new FXQuatd((FXQuatd &)result);
        vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_FXQuatd, 1); }  return vresult; }
static VALUE _wrap_FXQuatd___mul____SWIG_0(int argc, VALUE *argv, VALUE self) { FXQuatd *arg1 = (FXQuatd *) 0 ;
    FXQuatd *arg2 = 0 ; FXQuatd result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXQuatd, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXQuatd, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    result = FXQuatd_operator_Sm___SWIG_0((FXQuatd const *)arg1,(FXQuatd const &)*arg2); { FXQuatd * resultptr;
        resultptr = new FXQuatd((FXQuatd &)result); vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_FXQuatd, 1); } 
    return vresult; }
static VALUE _wrap_FXQuatd___mul____SWIG_1(int argc, VALUE *argv, VALUE self) { FXQuatd *arg1 = (FXQuatd *) 0 ;
    FXVec3d *arg2 = 0 ; FXVec3d result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXQuatd, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXVec3d, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    result = FXQuatd_operator_Sm___SWIG_1((FXQuatd const *)arg1,(FXVec3d const &)*arg2); { FXVec3d * resultptr;
        resultptr = new FXVec3d((FXVec3d &)result); vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_FXVec3d, 1); } 
    return vresult; }
static VALUE _wrap_FXQuatd___mul__(int nargs, VALUE *args, VALUE self) { int argc; VALUE argv[3]; int ii; argc = nargs + 1;
    argv[0] = self; for (ii = 1; (ii < argc) && (ii < 2); ii++) { argv[ii] = args[ii-1]; }  if (argc == 2) { int _v; {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXQuatd, 0) != -1)) ? 1 : 0; }
         if (_v) { { void *ptr;
                _v = (NIL_P(argv[1]) || (TYPE(argv[1]) == T_DATA && SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_FXQuatd, 0) != -1)) ? 1 : 0; }
             if (_v) { return _wrap_FXQuatd___mul____SWIG_0(nargs, args, self);}  }  }  if (argc == 2) { int _v; { void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXQuatd, 0) != -1)) ? 1 : 0; }
         if (_v) { { void *ptr;
                _v = (NIL_P(argv[1]) || (TYPE(argv[1]) == T_DATA && SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_FXVec3d, 0) != -1)) ? 1 : 0; }
             if (_v) { return _wrap_FXQuatd___mul____SWIG_1(nargs, args, self);}  }  } 
    rb_raise(rb_eArgError, "No matching function for overloaded 'FXQuatd___mul__'"); return Qnil; }
static VALUE _wrap_FXQuatd_arc(int argc, VALUE *argv, VALUE self) { FXVec3d *arg1 = 0 ; FXVec3d *arg2 = 0 ; FXQuatd result;
    VALUE vresult = Qnil; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXVec3d, 1); if (arg1 == NULL) rb_raise(rb_eTypeError, "null reference");
    SWIG_ConvertPtr(argv[1], (void **) &arg2, SWIGTYPE_p_FXVec3d, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    result = FXQuatd_arc((FXVec3d const &)*arg1,(FXVec3d const &)*arg2); { FXQuatd * resultptr;
        resultptr = new FXQuatd((FXQuatd &)result); vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_FXQuatd, 1); } 
    return vresult; }
static VALUE _wrap_FXQuatd_lerp(int argc, VALUE *argv, VALUE self) { FXQuatd *arg1 = 0 ; FXQuatd *arg2 = 0 ; FXdouble arg3 ;
    FXQuatd result; VALUE vresult = Qnil; if ((argc < 3) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXQuatd, 1); if (arg1 == NULL) rb_raise(rb_eTypeError, "null reference");
    SWIG_ConvertPtr(argv[1], (void **) &arg2, SWIGTYPE_p_FXQuatd, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    arg3 = (FXdouble) NUM2DBL(argv[2]); result = FXQuatd_lerp((FXQuatd const &)*arg1,(FXQuatd const &)*arg2,arg3); {
        FXQuatd * resultptr; resultptr = new FXQuatd((FXQuatd &)result);
        vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_FXQuatd, 1); }  return vresult; }
static VALUE _wrap_new_FXMat3f__SWIG_0(int argc, VALUE *argv, VALUE self) { FXMat3f *result; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc); { result = (FXMat3f *)new FXMat3f();
        DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result); if(rb_block_given_p()){ rb_yield(self); }  }  return self; }
static VALUE _wrap_new_FXMat3f__SWIG_1(int argc, VALUE *argv, VALUE self) { FXfloat arg1 ; FXMat3f *result;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    arg1 = (FXfloat) NUM2DBL(argv[0]); { result = (FXMat3f *)new FXMat3f(arg1);
        DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result); if(rb_block_given_p()){ rb_yield(self); }  }  return self; }
static VALUE _wrap_new_FXMat3f__SWIG_2(int argc, VALUE *argv, VALUE self) { FXfloat arg1 ; FXfloat arg2 ; FXfloat arg3 ;
    FXfloat arg4 ; FXfloat arg5 ; FXfloat arg6 ; FXfloat arg7 ; FXfloat arg8 ; FXfloat arg9 ; FXMat3f *result;
    if ((argc < 9) || (argc > 9)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 9)",argc);
    arg1 = (FXfloat) NUM2DBL(argv[0]); arg2 = (FXfloat) NUM2DBL(argv[1]); arg3 = (FXfloat) NUM2DBL(argv[2]);
    arg4 = (FXfloat) NUM2DBL(argv[3]); arg5 = (FXfloat) NUM2DBL(argv[4]); arg6 = (FXfloat) NUM2DBL(argv[5]);
    arg7 = (FXfloat) NUM2DBL(argv[6]); arg8 = (FXfloat) NUM2DBL(argv[7]); arg9 = (FXfloat) NUM2DBL(argv[8]); {
        result = (FXMat3f *)new FXMat3f(arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8,arg9);
        DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result); if(rb_block_given_p()){ rb_yield(self); }  }  return self; }
static VALUE _wrap_new_FXMat3f__SWIG_3(int argc, VALUE *argv, VALUE self) { FXVec3f *arg1 = 0 ; FXVec3f *arg2 = 0 ;
    FXVec3f *arg3 = 0 ; FXMat3f *result; if ((argc < 3) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc); { if (TYPE(argv[0]) == T_ARRAY) {
            arg1 = new FXVec3f(NUM2DBL(rb_ary_entry(argv[0], 0)), NUM2DBL(rb_ary_entry(argv[0], 1)), NUM2DBL(rb_ary_entry(argv[0], 2))); }
         else { FXVec3f *p; SWIG_ConvertPtr(argv[0], (void **)&p, SWIGTYPE_p_FXVec3f, 1); arg1 = new FXVec3f(*p); }  }  {
        if (TYPE(argv[1]) == T_ARRAY) {
            arg2 = new FXVec3f(NUM2DBL(rb_ary_entry(argv[1], 0)), NUM2DBL(rb_ary_entry(argv[1], 1)), NUM2DBL(rb_ary_entry(argv[1], 2))); }
         else { FXVec3f *p; SWIG_ConvertPtr(argv[1], (void **)&p, SWIGTYPE_p_FXVec3f, 1); arg2 = new FXVec3f(*p); }  }  {
        if (TYPE(argv[2]) == T_ARRAY) {
            arg3 = new FXVec3f(NUM2DBL(rb_ary_entry(argv[2], 0)), NUM2DBL(rb_ary_entry(argv[2], 1)), NUM2DBL(rb_ary_entry(argv[2], 2))); }
         else { FXVec3f *p; SWIG_ConvertPtr(argv[2], (void **)&p, SWIGTYPE_p_FXVec3f, 1); arg3 = new FXVec3f(*p); }  }  {
        result = (FXMat3f *)new FXMat3f((FXVec3f const &)*arg1,(FXVec3f const &)*arg2,(FXVec3f const &)*arg3);
        DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result); if(rb_block_given_p()){ rb_yield(self); }  }  delete arg1;
    delete arg2; delete arg3; return self; }
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE _wrap_FXMat3f_allocate(VALUE self) {
#else
     static VALUE _wrap_FXMat3f_allocate(int argc, VALUE *argv, VALUE self) {
#endif
         VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_FXMat3f);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
         return vresult; }
static VALUE _wrap_new_FXMat3f__SWIG_4(int argc, VALUE *argv, VALUE self) { FXMat3f *arg1 = 0 ; FXMat3f *result;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXMat3f, 1); if (arg1 == NULL) rb_raise(rb_eTypeError, "null reference");
    { result = (FXMat3f *)new FXMat3f((FXMat3f const &)*arg1); DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result);
        if(rb_block_given_p()){ rb_yield(self); }  }  return self; }
static VALUE _wrap_new_FXMat3f(int nargs, VALUE *args, VALUE self) { int argc; VALUE argv[9]; int ii; argc = nargs;
    for (ii = 0; (ii < argc) && (ii < 9); ii++) { argv[ii] = args[ii]; }  if (argc == 0) {
        return _wrap_new_FXMat3f__SWIG_0(nargs, args, self);}  if (argc == 1) { int _v; { void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXMat3f, 0) != -1)) ? 1 : 0; }
         if (_v) { return _wrap_new_FXMat3f__SWIG_4(nargs, args, self);}  }  if (argc == 1) { int _v; {
            _v = ((TYPE(argv[0]) == T_FLOAT) || (TYPE(argv[0]) == T_FIXNUM) || (TYPE(argv[0]) == T_BIGNUM)) ? 1 : 0; } 
        if (_v) { return _wrap_new_FXMat3f__SWIG_1(nargs, args, self);}  }  if (argc == 3) { int _v; { void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXVec3f, 0) != -1)) ? 1 : 0; }
         if (_v) { { void *ptr;
                _v = (NIL_P(argv[1]) || (TYPE(argv[1]) == T_DATA && SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_FXVec3f, 0) != -1)) ? 1 : 0; }
             if (_v) { { void *ptr;
                    _v = (NIL_P(argv[2]) || (TYPE(argv[2]) == T_DATA && SWIG_ConvertPtr(argv[2], &ptr, SWIGTYPE_p_FXVec3f, 0) != -1)) ? 1 : 0; }
                 if (_v) { return _wrap_new_FXMat3f__SWIG_3(nargs, args, self);}  }  }  }  if (argc == 9) { int _v; {
            _v = ((TYPE(argv[0]) == T_FLOAT) || (TYPE(argv[0]) == T_FIXNUM) || (TYPE(argv[0]) == T_BIGNUM)) ? 1 : 0; } 
        if (_v) { { _v = ((TYPE(argv[1]) == T_FLOAT) || (TYPE(argv[1]) == T_FIXNUM) || (TYPE(argv[1]) == T_BIGNUM)) ? 1 : 0; } 
            if (_v) { {
                    _v = ((TYPE(argv[2]) == T_FLOAT) || (TYPE(argv[2]) == T_FIXNUM) || (TYPE(argv[2]) == T_BIGNUM)) ? 1 : 0; } 
                if (_v) { {
                        _v = ((TYPE(argv[3]) == T_FLOAT) || (TYPE(argv[3]) == T_FIXNUM) || (TYPE(argv[3]) == T_BIGNUM)) ? 1 : 0; }
                     if (_v) { {
                            _v = ((TYPE(argv[4]) == T_FLOAT) || (TYPE(argv[4]) == T_FIXNUM) || (TYPE(argv[4]) == T_BIGNUM)) ? 1 : 0; }
                         if (_v) { {
                                _v = ((TYPE(argv[5]) == T_FLOAT) || (TYPE(argv[5]) == T_FIXNUM) || (TYPE(argv[5]) == T_BIGNUM)) ? 1 : 0; }
                             if (_v) { {
                                    _v = ((TYPE(argv[6]) == T_FLOAT) || (TYPE(argv[6]) == T_FIXNUM) || (TYPE(argv[6]) == T_BIGNUM)) ? 1 : 0; }
                                 if (_v) { {
                                        _v = ((TYPE(argv[7]) == T_FLOAT) || (TYPE(argv[7]) == T_FIXNUM) || (TYPE(argv[7]) == T_BIGNUM)) ? 1 : 0; }
                                     if (_v) { {
                                            _v = ((TYPE(argv[8]) == T_FLOAT) || (TYPE(argv[8]) == T_FIXNUM) || (TYPE(argv[8]) == T_BIGNUM)) ? 1 : 0; }
                                         if (_v) { return _wrap_new_FXMat3f__SWIG_2(nargs, args, self);}  }  }  }  }  }  }  }  }
         }  rb_raise(rb_eArgError, "No matching function for overloaded 'new_FXMat3f'"); return Qnil; }
static VALUE _wrap_FXMat3f___getitem__(int argc, VALUE *argv, VALUE self) { FXMat3f *arg1 = (FXMat3f *) 0 ; FXint arg2 ;
    FXVec3f *result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMat3f, 1); arg2 = NUM2INT(argv[0]); {
        FXVec3f const &_result_ref = FXMat3f___getitem__((FXMat3f const *)arg1,arg2); result = (FXVec3f *) &_result_ref; } 
    vresult = FXRbGetRubyObj(result, "FXVec3f *"); return vresult; }
static VALUE _wrap_FXMat3f___setitem__(int argc, VALUE *argv, VALUE self) { FXMat3f *arg1 = (FXMat3f *) 0 ; FXint arg2 ;
    FXVec3d *arg3 = 0 ; FXVec3f *result; VALUE vresult = Qnil; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMat3f, 1); arg2 = NUM2INT(argv[0]);
    SWIG_ConvertPtr(argv[1], (void **) &arg3, SWIGTYPE_p_FXVec3d, 1); if (arg3 == NULL) rb_raise(rb_eTypeError, "null reference");
    { FXVec3f &_result_ref = FXMat3f___setitem__(arg1,arg2,(FXVec3d const &)*arg3); result = (FXVec3f *) &_result_ref; } 
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_FXVec3f,0); return vresult; }
static VALUE _wrap_FXMat3f___add__(int argc, VALUE *argv, VALUE self) { FXMat3f *arg1 = (FXMat3f *) 0 ; FXMat3f *arg2 = 0 ;
    FXMat3f result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMat3f, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXMat3f, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    result = FXMat3f_operator_Sa_((FXMat3f const *)arg1,(FXMat3f const &)*arg2); { FXMat3f * resultptr;
        resultptr = new FXMat3f((FXMat3f &)result); vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_FXMat3f, 1); } 
    return vresult; }
static VALUE _wrap_FXMat3f___sub__(int argc, VALUE *argv, VALUE self) { FXMat3f *arg1 = (FXMat3f *) 0 ; FXMat3f *arg2 = 0 ;
    FXMat3f result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMat3f, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXMat3f, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    result = FXMat3f_operator_Ss_((FXMat3f const *)arg1,(FXMat3f const &)*arg2); { FXMat3f * resultptr;
        resultptr = new FXMat3f((FXMat3f &)result); vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_FXMat3f, 1); } 
    return vresult; }
static VALUE _wrap_FXMat3f___neg__(int argc, VALUE *argv, VALUE self) { FXMat3f *arg1 = (FXMat3f *) 0 ; FXMat3f result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMat3f, 1); result = FXMat3f_operator_Ss_((FXMat3f const *)arg1); {
        FXMat3f * resultptr; resultptr = new FXMat3f((FXMat3f &)result);
        vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_FXMat3f, 1); }  return vresult; }
static VALUE _wrap_FXMat3f___mul____SWIG_0(int argc, VALUE *argv, VALUE self) { FXMat3f *arg1 = (FXMat3f *) 0 ;
    FXMat3f *arg2 = 0 ; FXMat3f result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMat3f, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXMat3f, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    result = FXMat3f_operator_Sm___SWIG_0((FXMat3f const *)arg1,(FXMat3f const &)*arg2); { FXMat3f * resultptr;
        resultptr = new FXMat3f((FXMat3f &)result); vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_FXMat3f, 1); } 
    return vresult; }
static VALUE _wrap_FXMat3f___mul____SWIG_1(int argc, VALUE *argv, VALUE self) { FXMat3f *arg1 = (FXMat3f *) 0 ; FXfloat arg2 ;
    FXMat3f result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMat3f, 1); arg2 = (FXfloat) NUM2DBL(argv[0]);
    result = FXMat3f_operator_Sm___SWIG_1((FXMat3f const *)arg1,arg2); { FXMat3f * resultptr;
        resultptr = new FXMat3f((FXMat3f &)result); vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_FXMat3f, 1); } 
    return vresult; }
static VALUE _wrap_FXMat3f___div__(int argc, VALUE *argv, VALUE self) { FXMat3f *arg1 = (FXMat3f *) 0 ; FXfloat arg2 ;
    FXMat3f result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMat3f, 1); arg2 = (FXfloat) NUM2DBL(argv[0]);
    result = FXMat3f_operator_Sd_((FXMat3f const *)arg1,arg2); { FXMat3f * resultptr;
        resultptr = new FXMat3f((FXMat3f &)result); vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_FXMat3f, 1); } 
    return vresult; }
static VALUE _wrap_FXMat3f___mul____SWIG_2(int argc, VALUE *argv, VALUE self) { FXMat3f *arg1 = (FXMat3f *) 0 ;
    FXVec3f *arg2 = 0 ; FXVec3f result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMat3f, 1); { if (TYPE(argv[0]) == T_ARRAY) {
            arg2 = new FXVec3f(NUM2DBL(rb_ary_entry(argv[0], 0)), NUM2DBL(rb_ary_entry(argv[0], 1)), NUM2DBL(rb_ary_entry(argv[0], 2))); }
         else { FXVec3f *p; SWIG_ConvertPtr(argv[0], (void **)&p, SWIGTYPE_p_FXVec3f, 1); arg2 = new FXVec3f(*p); }  } 
    result = FXMat3f_operator_Sm___SWIG_2((FXMat3f const *)arg1,(FXVec3f const &)*arg2); {
        FXVec3f* resultptr = new FXVec3f(result); vresult = FXRbGetRubyObj(resultptr, "FXVec3f *"); }  delete arg2;
    return vresult; }
static VALUE _wrap_FXMat3f___mul____SWIG_3(int argc, VALUE *argv, VALUE self) { FXMat3f *arg1 = (FXMat3f *) 0 ;
    FXVec2f *arg2 = 0 ; FXVec2f result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMat3f, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXVec2f, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    result = FXMat3f_operator_Sm___SWIG_3((FXMat3f const *)arg1,(FXVec2f const &)*arg2); { FXVec2f * resultptr;
        resultptr = new FXVec2f((FXVec2f &)result); vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_FXVec2f, 1); } 
    return vresult; }
static VALUE _wrap_FXMat3f___mul__(int nargs, VALUE *args, VALUE self) { int argc; VALUE argv[3]; int ii; argc = nargs + 1;
    argv[0] = self; for (ii = 1; (ii < argc) && (ii < 2); ii++) { argv[ii] = args[ii-1]; }  if (argc == 2) { int _v; {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXMat3f, 0) != -1)) ? 1 : 0; }
         if (_v) { { void *ptr;
                _v = (NIL_P(argv[1]) || (TYPE(argv[1]) == T_DATA && SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_FXMat3f, 0) != -1)) ? 1 : 0; }
             if (_v) { return _wrap_FXMat3f___mul____SWIG_0(nargs, args, self);}  }  }  if (argc == 2) { int _v; { void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXMat3f, 0) != -1)) ? 1 : 0; }
         if (_v) { { void *ptr;
                _v = (NIL_P(argv[1]) || (TYPE(argv[1]) == T_DATA && SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_FXVec3f, 0) != -1)) ? 1 : 0; }
             if (_v) { return _wrap_FXMat3f___mul____SWIG_2(nargs, args, self);}  }  }  if (argc == 2) { int _v; { void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXMat3f, 0) != -1)) ? 1 : 0; }
         if (_v) { { void *ptr;
                _v = (NIL_P(argv[1]) || (TYPE(argv[1]) == T_DATA && SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_FXVec2f, 0) != -1)) ? 1 : 0; }
             if (_v) { return _wrap_FXMat3f___mul____SWIG_3(nargs, args, self);}  }  }  if (argc == 2) { int _v; { void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXMat3f, 0) != -1)) ? 1 : 0; }
         if (_v) { { _v = ((TYPE(argv[1]) == T_FLOAT) || (TYPE(argv[1]) == T_FIXNUM) || (TYPE(argv[1]) == T_BIGNUM)) ? 1 : 0; } 
            if (_v) { return _wrap_FXMat3f___mul____SWIG_1(nargs, args, self);}  }  } 
    rb_raise(rb_eArgError, "No matching function for overloaded 'FXMat3f___mul__'"); return Qnil; }
static VALUE _wrap_FXMat3f_eye(int argc, VALUE *argv, VALUE self) { FXMat3f *arg1 = (FXMat3f *) 0 ; FXMat3f *result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMat3f, 1); { FXMat3f &_result_ref = (arg1)->eye();
        result = (FXMat3f *) &_result_ref; }  vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_FXMat3f,0);
    return vresult; }
static VALUE _wrap_FXMat3f_rot__SWIG_0(int argc, VALUE *argv, VALUE self) { FXMat3f *arg1 = (FXMat3f *) 0 ; FXfloat arg2 ;
    FXfloat arg3 ; FXMat3f *result; VALUE vresult = Qnil; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMat3f, 1); arg2 = (FXfloat) NUM2DBL(argv[0]);
    arg3 = (FXfloat) NUM2DBL(argv[1]); { FXMat3f &_result_ref = (arg1)->rot(arg2,arg3); result = (FXMat3f *) &_result_ref; } 
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_FXMat3f,0); return vresult; }
static VALUE _wrap_FXMat3f_rot__SWIG_1(int argc, VALUE *argv, VALUE self) { FXMat3f *arg1 = (FXMat3f *) 0 ; FXfloat arg2 ;
    FXMat3f *result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMat3f, 1); arg2 = (FXfloat) NUM2DBL(argv[0]); {
        FXMat3f &_result_ref = (arg1)->rot(arg2); result = (FXMat3f *) &_result_ref; } 
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_FXMat3f,0); return vresult; }
static VALUE _wrap_FXMat3f_rot(int nargs, VALUE *args, VALUE self) { int argc; VALUE argv[4]; int ii; argc = nargs + 1;
    argv[0] = self; for (ii = 1; (ii < argc) && (ii < 3); ii++) { argv[ii] = args[ii-1]; }  if (argc == 2) { int _v; {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXMat3f, 0) != -1)) ? 1 : 0; }
         if (_v) { { _v = ((TYPE(argv[1]) == T_FLOAT) || (TYPE(argv[1]) == T_FIXNUM) || (TYPE(argv[1]) == T_BIGNUM)) ? 1 : 0; } 
            if (_v) { return _wrap_FXMat3f_rot__SWIG_1(nargs, args, self);}  }  }  if (argc == 3) { int _v; { void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXMat3f, 0) != -1)) ? 1 : 0; }
         if (_v) { { _v = ((TYPE(argv[1]) == T_FLOAT) || (TYPE(argv[1]) == T_FIXNUM) || (TYPE(argv[1]) == T_BIGNUM)) ? 1 : 0; } 
            if (_v) { {
                    _v = ((TYPE(argv[2]) == T_FLOAT) || (TYPE(argv[2]) == T_FIXNUM) || (TYPE(argv[2]) == T_BIGNUM)) ? 1 : 0; } 
                if (_v) { return _wrap_FXMat3f_rot__SWIG_0(nargs, args, self);}  }  }  } 
    rb_raise(rb_eArgError, "No matching function for overloaded 'FXMat3f_rot'"); return Qnil; }
static VALUE _wrap_FXMat3f_trans(int argc, VALUE *argv, VALUE self) { FXMat3f *arg1 = (FXMat3f *) 0 ; FXfloat arg2 ;
    FXfloat arg3 ; FXMat3f *result; VALUE vresult = Qnil; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMat3f, 1); arg2 = (FXfloat) NUM2DBL(argv[0]);
    arg3 = (FXfloat) NUM2DBL(argv[1]); { FXMat3f &_result_ref = (arg1)->trans(arg2,arg3); result = (FXMat3f *) &_result_ref; } 
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_FXMat3f,0); return vresult; }
static VALUE _wrap_FXMat3f_scale__SWIG_0(int argc, VALUE *argv, VALUE self) { FXMat3f *arg1 = (FXMat3f *) 0 ; FXfloat arg2 ;
    FXfloat arg3 ; FXMat3f *result; VALUE vresult = Qnil; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMat3f, 1); arg2 = (FXfloat) NUM2DBL(argv[0]);
    arg3 = (FXfloat) NUM2DBL(argv[1]); { FXMat3f &_result_ref = (arg1)->scale(arg2,arg3); result = (FXMat3f *) &_result_ref; } 
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_FXMat3f,0); return vresult; }
static VALUE _wrap_FXMat3f_scale__SWIG_1(int argc, VALUE *argv, VALUE self) { FXMat3f *arg1 = (FXMat3f *) 0 ; FXfloat arg2 ;
    FXMat3f *result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMat3f, 1); arg2 = (FXfloat) NUM2DBL(argv[0]); {
        FXMat3f &_result_ref = (arg1)->scale(arg2); result = (FXMat3f *) &_result_ref; } 
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_FXMat3f,0); return vresult; }
static VALUE _wrap_FXMat3f_scale(int nargs, VALUE *args, VALUE self) { int argc; VALUE argv[4]; int ii; argc = nargs + 1;
    argv[0] = self; for (ii = 1; (ii < argc) && (ii < 3); ii++) { argv[ii] = args[ii-1]; }  if (argc == 2) { int _v; {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXMat3f, 0) != -1)) ? 1 : 0; }
         if (_v) { { _v = ((TYPE(argv[1]) == T_FLOAT) || (TYPE(argv[1]) == T_FIXNUM) || (TYPE(argv[1]) == T_BIGNUM)) ? 1 : 0; } 
            if (_v) { return _wrap_FXMat3f_scale__SWIG_1(nargs, args, self);}  }  }  if (argc == 3) { int _v; { void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXMat3f, 0) != -1)) ? 1 : 0; }
         if (_v) { { _v = ((TYPE(argv[1]) == T_FLOAT) || (TYPE(argv[1]) == T_FIXNUM) || (TYPE(argv[1]) == T_BIGNUM)) ? 1 : 0; } 
            if (_v) { {
                    _v = ((TYPE(argv[2]) == T_FLOAT) || (TYPE(argv[2]) == T_FIXNUM) || (TYPE(argv[2]) == T_BIGNUM)) ? 1 : 0; } 
                if (_v) { return _wrap_FXMat3f_scale__SWIG_0(nargs, args, self);}  }  }  } 
    rb_raise(rb_eArgError, "No matching function for overloaded 'FXMat3f_scale'"); return Qnil; }
static VALUE _wrap_FXMat3f_det(int argc, VALUE *argv, VALUE self) { FXMat3f *arg1 = (FXMat3f *) 0 ; FXfloat result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMat3f, 1); result = (FXfloat)FXMat3f_det((FXMat3f const *)arg1);
    vresult = rb_float_new(result); return vresult; }
static VALUE _wrap_FXMat3f_transpose(int argc, VALUE *argv, VALUE self) { FXMat3f *arg1 = (FXMat3f *) 0 ; FXMat3f result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMat3f, 1); result = FXMat3f_transpose((FXMat3f const *)arg1); {
        FXMat3f * resultptr; resultptr = new FXMat3f((FXMat3f &)result);
        vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_FXMat3f, 1); }  return vresult; }
static VALUE _wrap_FXMat3f_invert(int argc, VALUE *argv, VALUE self) { FXMat3f *arg1 = (FXMat3f *) 0 ; FXMat3f result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMat3f, 1); result = FXMat3f_invert((FXMat3f const *)arg1); {
        FXMat3f * resultptr; resultptr = new FXMat3f((FXMat3f &)result);
        vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_FXMat3f, 1); }  return vresult; }
static VALUE _wrap_new_FXMat3d__SWIG_0(int argc, VALUE *argv, VALUE self) { FXMat3d *result; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc); { result = (FXMat3d *)new FXMat3d();
        DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result); if(rb_block_given_p()){ rb_yield(self); }  }  return self; }
static VALUE _wrap_new_FXMat3d__SWIG_1(int argc, VALUE *argv, VALUE self) { FXdouble arg1 ; FXMat3d *result;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    arg1 = (FXdouble) NUM2DBL(argv[0]); { result = (FXMat3d *)new FXMat3d(arg1);
        DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result); if(rb_block_given_p()){ rb_yield(self); }  }  return self; }
static VALUE _wrap_new_FXMat3d__SWIG_2(int argc, VALUE *argv, VALUE self) { FXdouble arg1 ; FXdouble arg2 ; FXdouble arg3 ;
    FXdouble arg4 ; FXdouble arg5 ; FXdouble arg6 ; FXdouble arg7 ; FXdouble arg8 ; FXdouble arg9 ; FXMat3d *result;
    if ((argc < 9) || (argc > 9)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 9)",argc);
    arg1 = (FXdouble) NUM2DBL(argv[0]); arg2 = (FXdouble) NUM2DBL(argv[1]); arg3 = (FXdouble) NUM2DBL(argv[2]);
    arg4 = (FXdouble) NUM2DBL(argv[3]); arg5 = (FXdouble) NUM2DBL(argv[4]); arg6 = (FXdouble) NUM2DBL(argv[5]);
    arg7 = (FXdouble) NUM2DBL(argv[6]); arg8 = (FXdouble) NUM2DBL(argv[7]); arg9 = (FXdouble) NUM2DBL(argv[8]); {
        result = (FXMat3d *)new FXMat3d(arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8,arg9);
        DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result); if(rb_block_given_p()){ rb_yield(self); }  }  return self; }
static VALUE _wrap_new_FXMat3d__SWIG_3(int argc, VALUE *argv, VALUE self) { FXVec3d *arg1 = 0 ; FXVec3d *arg2 = 0 ;
    FXVec3d *arg3 = 0 ; FXMat3d *result; if ((argc < 3) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXVec3d, 1); if (arg1 == NULL) rb_raise(rb_eTypeError, "null reference");
    SWIG_ConvertPtr(argv[1], (void **) &arg2, SWIGTYPE_p_FXVec3d, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    SWIG_ConvertPtr(argv[2], (void **) &arg3, SWIGTYPE_p_FXVec3d, 1); if (arg3 == NULL) rb_raise(rb_eTypeError, "null reference");
    { result = (FXMat3d *)new FXMat3d((FXVec3d const &)*arg1,(FXVec3d const &)*arg2,(FXVec3d const &)*arg3);
        DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result); if(rb_block_given_p()){ rb_yield(self); }  }  return self; }
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE _wrap_FXMat3d_allocate(VALUE self) {
#else
     static VALUE _wrap_FXMat3d_allocate(int argc, VALUE *argv, VALUE self) {
#endif
         VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_FXMat3d);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
         return vresult; }
static VALUE _wrap_new_FXMat3d__SWIG_4(int argc, VALUE *argv, VALUE self) { FXMat3d *arg1 = 0 ; FXMat3d *result;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXMat3d, 1); if (arg1 == NULL) rb_raise(rb_eTypeError, "null reference");
    { result = (FXMat3d *)new FXMat3d((FXMat3d const &)*arg1); DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result);
        if(rb_block_given_p()){ rb_yield(self); }  }  return self; }
static VALUE _wrap_new_FXMat3d(int nargs, VALUE *args, VALUE self) { int argc; VALUE argv[9]; int ii; argc = nargs;
    for (ii = 0; (ii < argc) && (ii < 9); ii++) { argv[ii] = args[ii]; }  if (argc == 0) {
        return _wrap_new_FXMat3d__SWIG_0(nargs, args, self);}  if (argc == 1) { int _v; { void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXMat3d, 0) != -1)) ? 1 : 0; }
         if (_v) { return _wrap_new_FXMat3d__SWIG_4(nargs, args, self);}  }  if (argc == 1) { int _v; {
            _v = ((TYPE(argv[0]) == T_FLOAT) || (TYPE(argv[0]) == T_FIXNUM) || (TYPE(argv[0]) == T_BIGNUM)) ? 1 : 0; } 
        if (_v) { return _wrap_new_FXMat3d__SWIG_1(nargs, args, self);}  }  if (argc == 3) { int _v; { void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXVec3d, 0) != -1)) ? 1 : 0; }
         if (_v) { { void *ptr;
                _v = (NIL_P(argv[1]) || (TYPE(argv[1]) == T_DATA && SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_FXVec3d, 0) != -1)) ? 1 : 0; }
             if (_v) { { void *ptr;
                    _v = (NIL_P(argv[2]) || (TYPE(argv[2]) == T_DATA && SWIG_ConvertPtr(argv[2], &ptr, SWIGTYPE_p_FXVec3d, 0) != -1)) ? 1 : 0; }
                 if (_v) { return _wrap_new_FXMat3d__SWIG_3(nargs, args, self);}  }  }  }  if (argc == 9) { int _v; {
            _v = ((TYPE(argv[0]) == T_FLOAT) || (TYPE(argv[0]) == T_FIXNUM) || (TYPE(argv[0]) == T_BIGNUM)) ? 1 : 0; } 
        if (_v) { { _v = ((TYPE(argv[1]) == T_FLOAT) || (TYPE(argv[1]) == T_FIXNUM) || (TYPE(argv[1]) == T_BIGNUM)) ? 1 : 0; } 
            if (_v) { {
                    _v = ((TYPE(argv[2]) == T_FLOAT) || (TYPE(argv[2]) == T_FIXNUM) || (TYPE(argv[2]) == T_BIGNUM)) ? 1 : 0; } 
                if (_v) { {
                        _v = ((TYPE(argv[3]) == T_FLOAT) || (TYPE(argv[3]) == T_FIXNUM) || (TYPE(argv[3]) == T_BIGNUM)) ? 1 : 0; }
                     if (_v) { {
                            _v = ((TYPE(argv[4]) == T_FLOAT) || (TYPE(argv[4]) == T_FIXNUM) || (TYPE(argv[4]) == T_BIGNUM)) ? 1 : 0; }
                         if (_v) { {
                                _v = ((TYPE(argv[5]) == T_FLOAT) || (TYPE(argv[5]) == T_FIXNUM) || (TYPE(argv[5]) == T_BIGNUM)) ? 1 : 0; }
                             if (_v) { {
                                    _v = ((TYPE(argv[6]) == T_FLOAT) || (TYPE(argv[6]) == T_FIXNUM) || (TYPE(argv[6]) == T_BIGNUM)) ? 1 : 0; }
                                 if (_v) { {
                                        _v = ((TYPE(argv[7]) == T_FLOAT) || (TYPE(argv[7]) == T_FIXNUM) || (TYPE(argv[7]) == T_BIGNUM)) ? 1 : 0; }
                                     if (_v) { {
                                            _v = ((TYPE(argv[8]) == T_FLOAT) || (TYPE(argv[8]) == T_FIXNUM) || (TYPE(argv[8]) == T_BIGNUM)) ? 1 : 0; }
                                         if (_v) { return _wrap_new_FXMat3d__SWIG_2(nargs, args, self);}  }  }  }  }  }  }  }  }
         }  rb_raise(rb_eArgError, "No matching function for overloaded 'new_FXMat3d'"); return Qnil; }
static VALUE _wrap_FXMat3d___getitem__(int argc, VALUE *argv, VALUE self) { FXMat3d *arg1 = (FXMat3d *) 0 ; FXint arg2 ;
    FXVec3d *result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMat3d, 1); arg2 = NUM2INT(argv[0]); {
        FXVec3d const &_result_ref = FXMat3d___getitem__((FXMat3d const *)arg1,arg2); result = (FXVec3d *) &_result_ref; } 
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_FXVec3d,0); return vresult; }
static VALUE _wrap_FXMat3d___setitem__(int argc, VALUE *argv, VALUE self) { FXMat3d *arg1 = (FXMat3d *) 0 ; FXint arg2 ;
    FXVec3d *arg3 = 0 ; FXVec3d *result; VALUE vresult = Qnil; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMat3d, 1); arg2 = NUM2INT(argv[0]);
    SWIG_ConvertPtr(argv[1], (void **) &arg3, SWIGTYPE_p_FXVec3d, 1); if (arg3 == NULL) rb_raise(rb_eTypeError, "null reference");
    { FXVec3d &_result_ref = FXMat3d___setitem__(arg1,arg2,(FXVec3d const &)*arg3); result = (FXVec3d *) &_result_ref; } 
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_FXVec3d,0); return vresult; }
static VALUE _wrap_FXMat3d___add__(int argc, VALUE *argv, VALUE self) { FXMat3d *arg1 = (FXMat3d *) 0 ; FXMat3d *arg2 = 0 ;
    FXMat3d result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMat3d, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXMat3d, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    result = FXMat3d_operator_Sa_((FXMat3d const *)arg1,(FXMat3d const &)*arg2); { FXMat3d * resultptr;
        resultptr = new FXMat3d((FXMat3d &)result); vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_FXMat3d, 1); } 
    return vresult; }
static VALUE _wrap_FXMat3d___sub__(int argc, VALUE *argv, VALUE self) { FXMat3d *arg1 = (FXMat3d *) 0 ; FXMat3d *arg2 = 0 ;
    FXMat3d result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMat3d, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXMat3d, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    result = FXMat3d_operator_Ss_((FXMat3d const *)arg1,(FXMat3d const &)*arg2); { FXMat3d * resultptr;
        resultptr = new FXMat3d((FXMat3d &)result); vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_FXMat3d, 1); } 
    return vresult; }
static VALUE _wrap_FXMat3d___neg__(int argc, VALUE *argv, VALUE self) { FXMat3d *arg1 = (FXMat3d *) 0 ; FXMat3d result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMat3d, 1); result = FXMat3d_operator_Ss_((FXMat3d const *)arg1); {
        FXMat3d * resultptr; resultptr = new FXMat3d((FXMat3d &)result);
        vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_FXMat3d, 1); }  return vresult; }
static VALUE _wrap_FXMat3d___mul____SWIG_0(int argc, VALUE *argv, VALUE self) { FXMat3d *arg1 = (FXMat3d *) 0 ;
    FXMat3d *arg2 = 0 ; FXMat3d result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMat3d, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXMat3d, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    result = FXMat3d_operator_Sm___SWIG_0((FXMat3d const *)arg1,(FXMat3d const &)*arg2); { FXMat3d * resultptr;
        resultptr = new FXMat3d((FXMat3d &)result); vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_FXMat3d, 1); } 
    return vresult; }
static VALUE _wrap_FXMat3d___mul____SWIG_1(int argc, VALUE *argv, VALUE self) { FXMat3d *arg1 = (FXMat3d *) 0 ; FXdouble arg2 ;
    FXMat3d result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMat3d, 1); arg2 = (FXdouble) NUM2DBL(argv[0]);
    result = FXMat3d_operator_Sm___SWIG_1((FXMat3d const *)arg1,arg2); { FXMat3d * resultptr;
        resultptr = new FXMat3d((FXMat3d &)result); vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_FXMat3d, 1); } 
    return vresult; }
static VALUE _wrap_FXMat3d___div__(int argc, VALUE *argv, VALUE self) { FXMat3d *arg1 = (FXMat3d *) 0 ; FXdouble arg2 ;
    FXMat3d result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMat3d, 1); arg2 = (FXdouble) NUM2DBL(argv[0]);
    result = FXMat3d_operator_Sd_((FXMat3d const *)arg1,arg2); { FXMat3d * resultptr;
        resultptr = new FXMat3d((FXMat3d &)result); vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_FXMat3d, 1); } 
    return vresult; }
static VALUE _wrap_FXMat3d___mul____SWIG_2(int argc, VALUE *argv, VALUE self) { FXMat3d *arg1 = (FXMat3d *) 0 ;
    FXVec3d *arg2 = 0 ; FXVec3d result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMat3d, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXVec3d, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    result = FXMat3d_operator_Sm___SWIG_2((FXMat3d const *)arg1,(FXVec3d const &)*arg2); { FXVec3d * resultptr;
        resultptr = new FXVec3d((FXVec3d &)result); vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_FXVec3d, 1); } 
    return vresult; }
static VALUE _wrap_FXMat3d___mul____SWIG_3(int argc, VALUE *argv, VALUE self) { FXMat3d *arg1 = (FXMat3d *) 0 ;
    FXVec2d *arg2 = 0 ; FXVec2d result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMat3d, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXVec2d, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    result = FXMat3d_operator_Sm___SWIG_3((FXMat3d const *)arg1,(FXVec2d const &)*arg2); { FXVec2d * resultptr;
        resultptr = new FXVec2d((FXVec2d &)result); vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_FXVec2d, 1); } 
    return vresult; }
static VALUE _wrap_FXMat3d___mul__(int nargs, VALUE *args, VALUE self) { int argc; VALUE argv[3]; int ii; argc = nargs + 1;
    argv[0] = self; for (ii = 1; (ii < argc) && (ii < 2); ii++) { argv[ii] = args[ii-1]; }  if (argc == 2) { int _v; {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXMat3d, 0) != -1)) ? 1 : 0; }
         if (_v) { { void *ptr;
                _v = (NIL_P(argv[1]) || (TYPE(argv[1]) == T_DATA && SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_FXMat3d, 0) != -1)) ? 1 : 0; }
             if (_v) { return _wrap_FXMat3d___mul____SWIG_0(nargs, args, self);}  }  }  if (argc == 2) { int _v; { void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXMat3d, 0) != -1)) ? 1 : 0; }
         if (_v) { { void *ptr;
                _v = (NIL_P(argv[1]) || (TYPE(argv[1]) == T_DATA && SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_FXVec3d, 0) != -1)) ? 1 : 0; }
             if (_v) { return _wrap_FXMat3d___mul____SWIG_2(nargs, args, self);}  }  }  if (argc == 2) { int _v; { void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXMat3d, 0) != -1)) ? 1 : 0; }
         if (_v) { { void *ptr;
                _v = (NIL_P(argv[1]) || (TYPE(argv[1]) == T_DATA && SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_FXVec2d, 0) != -1)) ? 1 : 0; }
             if (_v) { return _wrap_FXMat3d___mul____SWIG_3(nargs, args, self);}  }  }  if (argc == 2) { int _v; { void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXMat3d, 0) != -1)) ? 1 : 0; }
         if (_v) { { _v = ((TYPE(argv[1]) == T_FLOAT) || (TYPE(argv[1]) == T_FIXNUM) || (TYPE(argv[1]) == T_BIGNUM)) ? 1 : 0; } 
            if (_v) { return _wrap_FXMat3d___mul____SWIG_1(nargs, args, self);}  }  } 
    rb_raise(rb_eArgError, "No matching function for overloaded 'FXMat3d___mul__'"); return Qnil; }
static VALUE _wrap_FXMat3d_eye(int argc, VALUE *argv, VALUE self) { FXMat3d *arg1 = (FXMat3d *) 0 ; FXMat3d *result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMat3d, 1); { FXMat3d &_result_ref = (arg1)->eye();
        result = (FXMat3d *) &_result_ref; }  vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_FXMat3d,0);
    return vresult; }
static VALUE _wrap_FXMat3d_rot__SWIG_0(int argc, VALUE *argv, VALUE self) { FXMat3d *arg1 = (FXMat3d *) 0 ; FXdouble arg2 ;
    FXdouble arg3 ; FXMat3d *result; VALUE vresult = Qnil; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMat3d, 1); arg2 = (FXdouble) NUM2DBL(argv[0]);
    arg3 = (FXdouble) NUM2DBL(argv[1]); { FXMat3d &_result_ref = (arg1)->rot(arg2,arg3); result = (FXMat3d *) &_result_ref; } 
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_FXMat3d,0); return vresult; }
static VALUE _wrap_FXMat3d_rot__SWIG_1(int argc, VALUE *argv, VALUE self) { FXMat3d *arg1 = (FXMat3d *) 0 ; FXdouble arg2 ;
    FXMat3d *result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMat3d, 1); arg2 = (FXdouble) NUM2DBL(argv[0]); {
        FXMat3d &_result_ref = (arg1)->rot(arg2); result = (FXMat3d *) &_result_ref; } 
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_FXMat3d,0); return vresult; }
static VALUE _wrap_FXMat3d_rot(int nargs, VALUE *args, VALUE self) { int argc; VALUE argv[4]; int ii; argc = nargs + 1;
    argv[0] = self; for (ii = 1; (ii < argc) && (ii < 3); ii++) { argv[ii] = args[ii-1]; }  if (argc == 2) { int _v; {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXMat3d, 0) != -1)) ? 1 : 0; }
         if (_v) { { _v = ((TYPE(argv[1]) == T_FLOAT) || (TYPE(argv[1]) == T_FIXNUM) || (TYPE(argv[1]) == T_BIGNUM)) ? 1 : 0; } 
            if (_v) { return _wrap_FXMat3d_rot__SWIG_1(nargs, args, self);}  }  }  if (argc == 3) { int _v; { void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXMat3d, 0) != -1)) ? 1 : 0; }
         if (_v) { { _v = ((TYPE(argv[1]) == T_FLOAT) || (TYPE(argv[1]) == T_FIXNUM) || (TYPE(argv[1]) == T_BIGNUM)) ? 1 : 0; } 
            if (_v) { {
                    _v = ((TYPE(argv[2]) == T_FLOAT) || (TYPE(argv[2]) == T_FIXNUM) || (TYPE(argv[2]) == T_BIGNUM)) ? 1 : 0; } 
                if (_v) { return _wrap_FXMat3d_rot__SWIG_0(nargs, args, self);}  }  }  } 
    rb_raise(rb_eArgError, "No matching function for overloaded 'FXMat3d_rot'"); return Qnil; }
static VALUE _wrap_FXMat3d_trans(int argc, VALUE *argv, VALUE self) { FXMat3d *arg1 = (FXMat3d *) 0 ; FXdouble arg2 ;
    FXdouble arg3 ; FXMat3d *result; VALUE vresult = Qnil; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMat3d, 1); arg2 = (FXdouble) NUM2DBL(argv[0]);
    arg3 = (FXdouble) NUM2DBL(argv[1]); { FXMat3d &_result_ref = (arg1)->trans(arg2,arg3); result = (FXMat3d *) &_result_ref; } 
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_FXMat3d,0); return vresult; }
static VALUE _wrap_FXMat3d_scale__SWIG_0(int argc, VALUE *argv, VALUE self) { FXMat3d *arg1 = (FXMat3d *) 0 ; FXdouble arg2 ;
    FXdouble arg3 ; FXMat3d *result; VALUE vresult = Qnil; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMat3d, 1); arg2 = (FXdouble) NUM2DBL(argv[0]);
    arg3 = (FXdouble) NUM2DBL(argv[1]); { FXMat3d &_result_ref = (arg1)->scale(arg2,arg3); result = (FXMat3d *) &_result_ref; } 
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_FXMat3d,0); return vresult; }
static VALUE _wrap_FXMat3d_scale__SWIG_1(int argc, VALUE *argv, VALUE self) { FXMat3d *arg1 = (FXMat3d *) 0 ; FXdouble arg2 ;
    FXMat3d *result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMat3d, 1); arg2 = (FXdouble) NUM2DBL(argv[0]); {
        FXMat3d &_result_ref = (arg1)->scale(arg2); result = (FXMat3d *) &_result_ref; } 
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_FXMat3d,0); return vresult; }
static VALUE _wrap_FXMat3d_scale(int nargs, VALUE *args, VALUE self) { int argc; VALUE argv[4]; int ii; argc = nargs + 1;
    argv[0] = self; for (ii = 1; (ii < argc) && (ii < 3); ii++) { argv[ii] = args[ii-1]; }  if (argc == 2) { int _v; {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXMat3d, 0) != -1)) ? 1 : 0; }
         if (_v) { { _v = ((TYPE(argv[1]) == T_FLOAT) || (TYPE(argv[1]) == T_FIXNUM) || (TYPE(argv[1]) == T_BIGNUM)) ? 1 : 0; } 
            if (_v) { return _wrap_FXMat3d_scale__SWIG_1(nargs, args, self);}  }  }  if (argc == 3) { int _v; { void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXMat3d, 0) != -1)) ? 1 : 0; }
         if (_v) { { _v = ((TYPE(argv[1]) == T_FLOAT) || (TYPE(argv[1]) == T_FIXNUM) || (TYPE(argv[1]) == T_BIGNUM)) ? 1 : 0; } 
            if (_v) { {
                    _v = ((TYPE(argv[2]) == T_FLOAT) || (TYPE(argv[2]) == T_FIXNUM) || (TYPE(argv[2]) == T_BIGNUM)) ? 1 : 0; } 
                if (_v) { return _wrap_FXMat3d_scale__SWIG_0(nargs, args, self);}  }  }  } 
    rb_raise(rb_eArgError, "No matching function for overloaded 'FXMat3d_scale'"); return Qnil; }
static VALUE _wrap_FXMat3d_det(int argc, VALUE *argv, VALUE self) { FXMat3d *arg1 = (FXMat3d *) 0 ; FXdouble result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMat3d, 1); result = (FXdouble)FXMat3d_det((FXMat3d const *)arg1);
    vresult = rb_float_new(result); return vresult; }
static VALUE _wrap_FXMat3d_transpose(int argc, VALUE *argv, VALUE self) { FXMat3d *arg1 = (FXMat3d *) 0 ; FXMat3d result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMat3d, 1); result = FXMat3d_transpose((FXMat3d const *)arg1); {
        FXMat3d * resultptr; resultptr = new FXMat3d((FXMat3d &)result);
        vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_FXMat3d, 1); }  return vresult; }
static VALUE _wrap_FXMat3d_invert(int argc, VALUE *argv, VALUE self) { FXMat3d *arg1 = (FXMat3d *) 0 ; FXMat3d result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMat3d, 1); result = FXMat3d_invert((FXMat3d const *)arg1); {
        FXMat3d * resultptr; resultptr = new FXMat3d((FXMat3d &)result);
        vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_FXMat3d, 1); }  return vresult; }
static VALUE _wrap_new_FXMat4f__SWIG_0(int argc, VALUE *argv, VALUE self) { FXMat4f *result; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc); { result = (FXMat4f *)new FXMat4f();
        DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result); if(rb_block_given_p()){ rb_yield(self); }  }  return self; }
static VALUE _wrap_new_FXMat4f__SWIG_1(int argc, VALUE *argv, VALUE self) { FXfloat arg1 ; FXMat4f *result;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    arg1 = (FXfloat) NUM2DBL(argv[0]); { result = (FXMat4f *)new FXMat4f(arg1);
        DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result); if(rb_block_given_p()){ rb_yield(self); }  }  return self; }
static VALUE _wrap_new_FXMat4f__SWIG_2(int argc, VALUE *argv, VALUE self) { FXfloat arg1 ; FXfloat arg2 ; FXfloat arg3 ;
    FXfloat arg4 ; FXfloat arg5 ; FXfloat arg6 ; FXfloat arg7 ; FXfloat arg8 ; FXfloat arg9 ; FXfloat arg10 ; FXfloat arg11 ;
    FXfloat arg12 ; FXfloat arg13 ; FXfloat arg14 ; FXfloat arg15 ; FXfloat arg16 ; FXMat4f *result;
    if ((argc < 16) || (argc > 16)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 16)",argc);
    arg1 = (FXfloat) NUM2DBL(argv[0]); arg2 = (FXfloat) NUM2DBL(argv[1]); arg3 = (FXfloat) NUM2DBL(argv[2]);
    arg4 = (FXfloat) NUM2DBL(argv[3]); arg5 = (FXfloat) NUM2DBL(argv[4]); arg6 = (FXfloat) NUM2DBL(argv[5]);
    arg7 = (FXfloat) NUM2DBL(argv[6]); arg8 = (FXfloat) NUM2DBL(argv[7]); arg9 = (FXfloat) NUM2DBL(argv[8]);
    arg10 = (FXfloat) NUM2DBL(argv[9]); arg11 = (FXfloat) NUM2DBL(argv[10]); arg12 = (FXfloat) NUM2DBL(argv[11]);
    arg13 = (FXfloat) NUM2DBL(argv[12]); arg14 = (FXfloat) NUM2DBL(argv[13]); arg15 = (FXfloat) NUM2DBL(argv[14]);
    arg16 = (FXfloat) NUM2DBL(argv[15]); {
        result = (FXMat4f *)new FXMat4f(arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8,arg9,arg10,arg11,arg12,arg13,arg14,arg15,arg16);
        DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result); if(rb_block_given_p()){ rb_yield(self); }  }  return self; }
static VALUE _wrap_new_FXMat4f__SWIG_3(int argc, VALUE *argv, VALUE self) { FXVec4f *arg1 = 0 ; FXVec4f *arg2 = 0 ;
    FXVec4f *arg3 = 0 ; FXVec4f *arg4 = 0 ; FXMat4f *result; if ((argc < 4) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc); { if (TYPE(argv[0]) == T_ARRAY) {
            arg1 = new FXVec4f(NUM2DBL(rb_ary_entry(argv[0], 0)), NUM2DBL(rb_ary_entry(argv[0], 1)), NUM2DBL(rb_ary_entry(argv[0], 2)), NUM2DBL(rb_ary_entry(argv[0], 3))); }
         else { FXVec4f *p; SWIG_ConvertPtr(argv[0],(void **)&p,SWIGTYPE_p_FXVec4f,1); arg1 = new FXVec4f(*p); }  }  {
        if (TYPE(argv[1]) == T_ARRAY) {
            arg2 = new FXVec4f(NUM2DBL(rb_ary_entry(argv[1], 0)), NUM2DBL(rb_ary_entry(argv[1], 1)), NUM2DBL(rb_ary_entry(argv[1], 2)), NUM2DBL(rb_ary_entry(argv[1], 3))); }
         else { FXVec4f *p; SWIG_ConvertPtr(argv[1],(void **)&p,SWIGTYPE_p_FXVec4f,1); arg2 = new FXVec4f(*p); }  }  {
        if (TYPE(argv[2]) == T_ARRAY) {
            arg3 = new FXVec4f(NUM2DBL(rb_ary_entry(argv[2], 0)), NUM2DBL(rb_ary_entry(argv[2], 1)), NUM2DBL(rb_ary_entry(argv[2], 2)), NUM2DBL(rb_ary_entry(argv[2], 3))); }
         else { FXVec4f *p; SWIG_ConvertPtr(argv[2],(void **)&p,SWIGTYPE_p_FXVec4f,1); arg3 = new FXVec4f(*p); }  }  {
        if (TYPE(argv[3]) == T_ARRAY) {
            arg4 = new FXVec4f(NUM2DBL(rb_ary_entry(argv[3], 0)), NUM2DBL(rb_ary_entry(argv[3], 1)), NUM2DBL(rb_ary_entry(argv[3], 2)), NUM2DBL(rb_ary_entry(argv[3], 3))); }
         else { FXVec4f *p; SWIG_ConvertPtr(argv[3],(void **)&p,SWIGTYPE_p_FXVec4f,1); arg4 = new FXVec4f(*p); }  }  {
        result = (FXMat4f *)new FXMat4f((FXVec4f const &)*arg1,(FXVec4f const &)*arg2,(FXVec4f const &)*arg3,(FXVec4f const &)*arg4);
        DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result); if(rb_block_given_p()){ rb_yield(self); }  }  delete arg1;
    delete arg2; delete arg3; delete arg4; return self; }
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE _wrap_FXMat4f_allocate(VALUE self) {
#else
     static VALUE _wrap_FXMat4f_allocate(int argc, VALUE *argv, VALUE self) {
#endif
         VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_FXMat4f);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
         return vresult; }
static VALUE _wrap_new_FXMat4f__SWIG_4(int argc, VALUE *argv, VALUE self) { FXMat4f *arg1 = 0 ; FXMat4f *result;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXMat4f, 1); if (arg1 == NULL) rb_raise(rb_eTypeError, "null reference");
    { result = (FXMat4f *)new FXMat4f((FXMat4f const &)*arg1); DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result);
        if(rb_block_given_p()){ rb_yield(self); }  }  return self; }
static VALUE _wrap_new_FXMat4f(int nargs, VALUE *args, VALUE self) { int argc; VALUE argv[16]; int ii; argc = nargs;
    for (ii = 0; (ii < argc) && (ii < 16); ii++) { argv[ii] = args[ii]; }  if (argc == 0) {
        return _wrap_new_FXMat4f__SWIG_0(nargs, args, self);}  if (argc == 1) { int _v; { void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXMat4f, 0) != -1)) ? 1 : 0; }
         if (_v) { return _wrap_new_FXMat4f__SWIG_4(nargs, args, self);}  }  if (argc == 1) { int _v; {
            _v = ((TYPE(argv[0]) == T_FLOAT) || (TYPE(argv[0]) == T_FIXNUM) || (TYPE(argv[0]) == T_BIGNUM)) ? 1 : 0; } 
        if (_v) { return _wrap_new_FXMat4f__SWIG_1(nargs, args, self);}  }  if (argc == 4) { int _v; { void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXVec4f, 0) != -1)) ? 1 : 0; }
         if (_v) { { void *ptr;
                _v = (NIL_P(argv[1]) || (TYPE(argv[1]) == T_DATA && SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_FXVec4f, 0) != -1)) ? 1 : 0; }
             if (_v) { { void *ptr;
                    _v = (NIL_P(argv[2]) || (TYPE(argv[2]) == T_DATA && SWIG_ConvertPtr(argv[2], &ptr, SWIGTYPE_p_FXVec4f, 0) != -1)) ? 1 : 0; }
                 if (_v) { { void *ptr;
                        _v = (NIL_P(argv[3]) || (TYPE(argv[3]) == T_DATA && SWIG_ConvertPtr(argv[3], &ptr, SWIGTYPE_p_FXVec4f, 0) != -1)) ? 1 : 0; }
                     if (_v) { return _wrap_new_FXMat4f__SWIG_3(nargs, args, self);}  }  }  }  }  if (argc == 16) { int _v; {
            _v = ((TYPE(argv[0]) == T_FLOAT) || (TYPE(argv[0]) == T_FIXNUM) || (TYPE(argv[0]) == T_BIGNUM)) ? 1 : 0; } 
        if (_v) { { _v = ((TYPE(argv[1]) == T_FLOAT) || (TYPE(argv[1]) == T_FIXNUM) || (TYPE(argv[1]) == T_BIGNUM)) ? 1 : 0; } 
            if (_v) { {
                    _v = ((TYPE(argv[2]) == T_FLOAT) || (TYPE(argv[2]) == T_FIXNUM) || (TYPE(argv[2]) == T_BIGNUM)) ? 1 : 0; } 
                if (_v) { {
                        _v = ((TYPE(argv[3]) == T_FLOAT) || (TYPE(argv[3]) == T_FIXNUM) || (TYPE(argv[3]) == T_BIGNUM)) ? 1 : 0; }
                     if (_v) { {
                            _v = ((TYPE(argv[4]) == T_FLOAT) || (TYPE(argv[4]) == T_FIXNUM) || (TYPE(argv[4]) == T_BIGNUM)) ? 1 : 0; }
                         if (_v) { {
                                _v = ((TYPE(argv[5]) == T_FLOAT) || (TYPE(argv[5]) == T_FIXNUM) || (TYPE(argv[5]) == T_BIGNUM)) ? 1 : 0; }
                             if (_v) { {
                                    _v = ((TYPE(argv[6]) == T_FLOAT) || (TYPE(argv[6]) == T_FIXNUM) || (TYPE(argv[6]) == T_BIGNUM)) ? 1 : 0; }
                                 if (_v) { {
                                        _v = ((TYPE(argv[7]) == T_FLOAT) || (TYPE(argv[7]) == T_FIXNUM) || (TYPE(argv[7]) == T_BIGNUM)) ? 1 : 0; }
                                     if (_v) { {
                                            _v = ((TYPE(argv[8]) == T_FLOAT) || (TYPE(argv[8]) == T_FIXNUM) || (TYPE(argv[8]) == T_BIGNUM)) ? 1 : 0; }
                                         if (_v) { {
                                                _v = ((TYPE(argv[9]) == T_FLOAT) || (TYPE(argv[9]) == T_FIXNUM) || (TYPE(argv[9]) == T_BIGNUM)) ? 1 : 0; }
                                             if (_v) { {
                                                    _v = ((TYPE(argv[10]) == T_FLOAT) || (TYPE(argv[10]) == T_FIXNUM) || (TYPE(argv[10]) == T_BIGNUM)) ? 1 : 0; }
                                                 if (_v) { {
                                                        _v = ((TYPE(argv[11]) == T_FLOAT) || (TYPE(argv[11]) == T_FIXNUM) || (TYPE(argv[11]) == T_BIGNUM)) ? 1 : 0; }
                                                     if (_v) { {
                                                            _v = ((TYPE(argv[12]) == T_FLOAT) || (TYPE(argv[12]) == T_FIXNUM) || (TYPE(argv[12]) == T_BIGNUM)) ? 1 : 0; }
                                                         if (_v) { {
                                                                _v = ((TYPE(argv[13]) == T_FLOAT) || (TYPE(argv[13]) == T_FIXNUM) || (TYPE(argv[13]) == T_BIGNUM)) ? 1 : 0; }
                                                             if (_v) { {
                                                                    _v = ((TYPE(argv[14]) == T_FLOAT) || (TYPE(argv[14]) == T_FIXNUM) || (TYPE(argv[14]) == T_BIGNUM)) ? 1 : 0; }
                                                                 if (_v) { {
                                                                        _v = ((TYPE(argv[15]) == T_FLOAT) || (TYPE(argv[15]) == T_FIXNUM) || (TYPE(argv[15]) == T_BIGNUM)) ? 1 : 0; }
                                                                     if (_v) {
                                                                        return _wrap_new_FXMat4f__SWIG_2(nargs, args, self);}  }
                                                                 }  }  }  }  }  }  }  }  }  }  }  }  }  }  } 
    rb_raise(rb_eArgError, "No matching function for overloaded 'new_FXMat4f'"); return Qnil; }
static VALUE _wrap_FXMat4f___getitem__(int argc, VALUE *argv, VALUE self) { FXMat4f *arg1 = (FXMat4f *) 0 ; FXint arg2 ;
    FXVec4f *result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMat4f, 1); arg2 = NUM2INT(argv[0]); {
        FXVec4f const &_result_ref = FXMat4f___getitem__((FXMat4f const *)arg1,arg2); result = (FXVec4f *) &_result_ref; } 
    vresult = FXRbGetRubyObj(result, "FXVec4f *"); return vresult; }
static VALUE _wrap_FXMat4f___setitem__(int argc, VALUE *argv, VALUE self) { FXMat4f *arg1 = (FXMat4f *) 0 ; FXint arg2 ;
    FXVec3d *arg3 = 0 ; FXVec4f *result; VALUE vresult = Qnil; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMat4f, 1); arg2 = NUM2INT(argv[0]);
    SWIG_ConvertPtr(argv[1], (void **) &arg3, SWIGTYPE_p_FXVec3d, 1); if (arg3 == NULL) rb_raise(rb_eTypeError, "null reference");
    { FXVec4f &_result_ref = FXMat4f___setitem__(arg1,arg2,(FXVec3d const &)*arg3); result = (FXVec4f *) &_result_ref; } 
    vresult = FXRbGetRubyObj(result, "FXVec4f *"); return vresult; }
static VALUE _wrap_FXMat4f___add__(int argc, VALUE *argv, VALUE self) { FXMat4f *arg1 = (FXMat4f *) 0 ; FXMat4f *arg2 = 0 ;
    FXMat4f result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMat4f, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXMat4f, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    result = FXMat4f_operator_Sa_((FXMat4f const *)arg1,(FXMat4f const &)*arg2); { FXMat4f* resultptr = new FXMat4f(result);
        vresult = FXRbGetRubyObj(resultptr, "FXMat4f *"); }  return vresult; }
static VALUE _wrap_FXMat4f___sub__(int argc, VALUE *argv, VALUE self) { FXMat4f *arg1 = (FXMat4f *) 0 ; FXMat4f *arg2 = 0 ;
    FXMat4f result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMat4f, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXMat4f, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    result = FXMat4f_operator_Ss_((FXMat4f const *)arg1,(FXMat4f const &)*arg2); { FXMat4f* resultptr = new FXMat4f(result);
        vresult = FXRbGetRubyObj(resultptr, "FXMat4f *"); }  return vresult; }
static VALUE _wrap_FXMat4f___mul____SWIG_0(int argc, VALUE *argv, VALUE self) { FXMat4f *arg1 = (FXMat4f *) 0 ;
    FXMat4f *arg2 = 0 ; FXMat4f result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMat4f, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXMat4f, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    result = FXMat4f_operator_Sm___SWIG_0((FXMat4f const *)arg1,(FXMat4f const &)*arg2); {
        FXMat4f* resultptr = new FXMat4f(result); vresult = FXRbGetRubyObj(resultptr, "FXMat4f *"); }  return vresult; }
static VALUE _wrap_FXMat4f___mul____SWIG_1(int argc, VALUE *argv, VALUE self) { FXMat4f *arg1 = (FXMat4f *) 0 ; FXfloat arg2 ;
    FXMat4f result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMat4f, 1); arg2 = (FXfloat) NUM2DBL(argv[0]);
    result = FXMat4f_operator_Sm___SWIG_1((FXMat4f const *)arg1,arg2); { FXMat4f* resultptr = new FXMat4f(result);
        vresult = FXRbGetRubyObj(resultptr, "FXMat4f *"); }  return vresult; }
static VALUE _wrap_FXMat4f___mul____SWIG_2(int argc, VALUE *argv, VALUE self) { FXMat4f *arg1 = (FXMat4f *) 0 ;
    FXVec4f *arg2 = 0 ; FXVec4f result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMat4f, 1); { if (TYPE(argv[0]) == T_ARRAY) {
            arg2 = new FXVec4f(NUM2DBL(rb_ary_entry(argv[0], 0)), NUM2DBL(rb_ary_entry(argv[0], 1)), NUM2DBL(rb_ary_entry(argv[0], 2)), NUM2DBL(rb_ary_entry(argv[0], 3))); }
         else { FXVec4f *p; SWIG_ConvertPtr(argv[0],(void **)&p,SWIGTYPE_p_FXVec4f,1); arg2 = new FXVec4f(*p); }  } 
    result = FXMat4f_operator_Sm___SWIG_2((FXMat4f const *)arg1,(FXVec4f const &)*arg2); {
        FXVec4f* resultptr = new FXVec4f(result); vresult = FXRbGetRubyObj(resultptr, "FXVec4f *"); }  delete arg2;
    return vresult; }
static VALUE _wrap_FXMat4f___mul____SWIG_3(int argc, VALUE *argv, VALUE self) { FXMat4f *arg1 = (FXMat4f *) 0 ;
    FXVec3f *arg2 = 0 ; FXVec3f result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMat4f, 1); { if (TYPE(argv[0]) == T_ARRAY) {
            arg2 = new FXVec3f(NUM2DBL(rb_ary_entry(argv[0], 0)), NUM2DBL(rb_ary_entry(argv[0], 1)), NUM2DBL(rb_ary_entry(argv[0], 2))); }
         else { FXVec3f *p; SWIG_ConvertPtr(argv[0], (void **)&p, SWIGTYPE_p_FXVec3f, 1); arg2 = new FXVec3f(*p); }  } 
    result = FXMat4f_operator_Sm___SWIG_3((FXMat4f const *)arg1,(FXVec3f const &)*arg2); {
        FXVec3f* resultptr = new FXVec3f(result); vresult = FXRbGetRubyObj(resultptr, "FXVec3f *"); }  delete arg2;
    return vresult; }
static VALUE _wrap_FXMat4f___mul__(int nargs, VALUE *args, VALUE self) { int argc; VALUE argv[3]; int ii; argc = nargs + 1;
    argv[0] = self; for (ii = 1; (ii < argc) && (ii < 2); ii++) { argv[ii] = args[ii-1]; }  if (argc == 2) { int _v; {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXMat4f, 0) != -1)) ? 1 : 0; }
         if (_v) { { void *ptr;
                _v = (NIL_P(argv[1]) || (TYPE(argv[1]) == T_DATA && SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_FXMat4f, 0) != -1)) ? 1 : 0; }
             if (_v) { return _wrap_FXMat4f___mul____SWIG_0(nargs, args, self);}  }  }  if (argc == 2) { int _v; { void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXMat4f, 0) != -1)) ? 1 : 0; }
         if (_v) { { void *ptr;
                _v = (NIL_P(argv[1]) || (TYPE(argv[1]) == T_DATA && SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_FXVec4f, 0) != -1)) ? 1 : 0; }
             if (_v) { return _wrap_FXMat4f___mul____SWIG_2(nargs, args, self);}  }  }  if (argc == 2) { int _v; { void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXMat4f, 0) != -1)) ? 1 : 0; }
         if (_v) { { void *ptr;
                _v = (NIL_P(argv[1]) || (TYPE(argv[1]) == T_DATA && SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_FXVec3f, 0) != -1)) ? 1 : 0; }
             if (_v) { return _wrap_FXMat4f___mul____SWIG_3(nargs, args, self);}  }  }  if (argc == 2) { int _v; { void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXMat4f, 0) != -1)) ? 1 : 0; }
         if (_v) { { _v = ((TYPE(argv[1]) == T_FLOAT) || (TYPE(argv[1]) == T_FIXNUM) || (TYPE(argv[1]) == T_BIGNUM)) ? 1 : 0; } 
            if (_v) { return _wrap_FXMat4f___mul____SWIG_1(nargs, args, self);}  }  } 
    rb_raise(rb_eArgError, "No matching function for overloaded 'FXMat4f___mul__'"); return Qnil; }
static VALUE _wrap_FXMat4f___div__(int argc, VALUE *argv, VALUE self) { FXMat4f *arg1 = (FXMat4f *) 0 ; FXfloat arg2 ;
    FXMat4f result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMat4f, 1); arg2 = (FXfloat) NUM2DBL(argv[0]);
    result = FXMat4f_operator_Sd_((FXMat4f const *)arg1,arg2); { FXMat4f* resultptr = new FXMat4f(result);
        vresult = FXRbGetRubyObj(resultptr, "FXMat4f *"); }  return vresult; }
static VALUE _wrap_FXMat4f___neg__(int argc, VALUE *argv, VALUE self) { FXMat4f *arg1 = (FXMat4f *) 0 ; FXMat4f result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMat4f, 1); result = FXMat4f_operator_Ss_((FXMat4f const *)arg1); {
        FXMat4f* resultptr = new FXMat4f(result); vresult = FXRbGetRubyObj(resultptr, "FXMat4f *"); }  return vresult; }
static VALUE _wrap_FXMat4f_det(int argc, VALUE *argv, VALUE self) { FXMat4f *arg1 = (FXMat4f *) 0 ; FXfloat result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMat4f, 1); result = (FXfloat)FXMat4f_det((FXMat4f const *)arg1);
    vresult = rb_float_new(result); return vresult; }
static VALUE _wrap_FXMat4f_transpose(int argc, VALUE *argv, VALUE self) { FXMat4f *arg1 = (FXMat4f *) 0 ; FXMat4f result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMat4f, 1); result = FXMat4f_transpose((FXMat4f const *)arg1); {
        FXMat4f* resultptr = new FXMat4f(result); vresult = FXRbGetRubyObj(resultptr, "FXMat4f *"); }  return vresult; }
static VALUE _wrap_FXMat4f_invert(int argc, VALUE *argv, VALUE self) { FXMat4f *arg1 = (FXMat4f *) 0 ; FXMat4f result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMat4f, 1); result = FXMat4f_invert((FXMat4f const *)arg1); {
        FXMat4f* resultptr = new FXMat4f(result); vresult = FXRbGetRubyObj(resultptr, "FXMat4f *"); }  return vresult; }
static VALUE _wrap_FXMat4f_to_s(int argc, VALUE *argv, VALUE self) { FXMat4f *arg1 = (FXMat4f *) 0 ; FXString result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMat4f, 1); result = FXMat4f_to_s((FXMat4f const *)arg1);
    vresult = rb_str_new2((&result)->text()); return vresult; }
static VALUE _wrap_FXMat4f_eye(int argc, VALUE *argv, VALUE self) { FXMat4f *arg1 = (FXMat4f *) 0 ; FXMat4f *result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMat4f, 1); { FXMat4f &_result_ref = (arg1)->eye();
        result = (FXMat4f *) &_result_ref; }  vresult = FXRbGetRubyObj(result, "FXMat4f *"); return vresult; }
static VALUE _wrap_FXMat4f_ortho(int argc, VALUE *argv, VALUE self) { FXMat4f *arg1 = (FXMat4f *) 0 ; FXfloat arg2 ;
    FXfloat arg3 ; FXfloat arg4 ; FXfloat arg5 ; FXfloat arg6 ; FXfloat arg7 ; FXMat4f *result; VALUE vresult = Qnil;
    if ((argc < 6) || (argc > 6)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 6)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMat4f, 1); arg2 = (FXfloat) NUM2DBL(argv[0]);
    arg3 = (FXfloat) NUM2DBL(argv[1]); arg4 = (FXfloat) NUM2DBL(argv[2]); arg5 = (FXfloat) NUM2DBL(argv[3]);
    arg6 = (FXfloat) NUM2DBL(argv[4]); arg7 = (FXfloat) NUM2DBL(argv[5]); {
        FXMat4f &_result_ref = (arg1)->ortho(arg2,arg3,arg4,arg5,arg6,arg7); result = (FXMat4f *) &_result_ref; } 
    vresult = FXRbGetRubyObj(result, "FXMat4f *"); return vresult; }
static VALUE _wrap_FXMat4f_frustum(int argc, VALUE *argv, VALUE self) { FXMat4f *arg1 = (FXMat4f *) 0 ; FXfloat arg2 ;
    FXfloat arg3 ; FXfloat arg4 ; FXfloat arg5 ; FXfloat arg6 ; FXfloat arg7 ; FXMat4f *result; VALUE vresult = Qnil;
    if ((argc < 6) || (argc > 6)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 6)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMat4f, 1); arg2 = (FXfloat) NUM2DBL(argv[0]);
    arg3 = (FXfloat) NUM2DBL(argv[1]); arg4 = (FXfloat) NUM2DBL(argv[2]); arg5 = (FXfloat) NUM2DBL(argv[3]);
    arg6 = (FXfloat) NUM2DBL(argv[4]); arg7 = (FXfloat) NUM2DBL(argv[5]); {
        FXMat4f &_result_ref = (arg1)->frustum(arg2,arg3,arg4,arg5,arg6,arg7); result = (FXMat4f *) &_result_ref; } 
    vresult = FXRbGetRubyObj(result, "FXMat4f *"); return vresult; }
static VALUE _wrap_FXMat4f_left(int argc, VALUE *argv, VALUE self) { FXMat4f *arg1 = (FXMat4f *) 0 ; FXMat4f *result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMat4f, 1); { FXMat4f &_result_ref = (arg1)->left();
        result = (FXMat4f *) &_result_ref; }  vresult = FXRbGetRubyObj(result, "FXMat4f *"); return vresult; }
static VALUE _wrap_FXMat4f_rot__SWIG_0(int argc, VALUE *argv, VALUE self) { FXMat4f *arg1 = (FXMat4f *) 0 ; FXQuatf *arg2 = 0 ;
    FXMat4f *result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMat4f, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXQuatf, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    { FXMat4f &_result_ref = (arg1)->rot((FXQuatf const &)*arg2); result = (FXMat4f *) &_result_ref; } 
    vresult = FXRbGetRubyObj(result, "FXMat4f *"); return vresult; }
static VALUE _wrap_FXMat4f_rot__SWIG_1(int argc, VALUE *argv, VALUE self) { FXMat4f *arg1 = (FXMat4f *) 0 ; FXVec3f *arg2 = 0 ;
    FXfloat arg3 ; FXfloat arg4 ; FXMat4f *result; VALUE vresult = Qnil; if ((argc < 3) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMat4f, 1); { if (TYPE(argv[0]) == T_ARRAY) {
            arg2 = new FXVec3f(NUM2DBL(rb_ary_entry(argv[0], 0)), NUM2DBL(rb_ary_entry(argv[0], 1)), NUM2DBL(rb_ary_entry(argv[0], 2))); }
         else { FXVec3f *p; SWIG_ConvertPtr(argv[0], (void **)&p, SWIGTYPE_p_FXVec3f, 1); arg2 = new FXVec3f(*p); }  } 
    arg3 = (FXfloat) NUM2DBL(argv[1]); arg4 = (FXfloat) NUM2DBL(argv[2]); {
        FXMat4f &_result_ref = (arg1)->rot((FXVec3f const &)*arg2,arg3,arg4); result = (FXMat4f *) &_result_ref; } 
    vresult = FXRbGetRubyObj(result, "FXMat4f *"); delete arg2; return vresult; }
static VALUE _wrap_FXMat4f_rot__SWIG_2(int argc, VALUE *argv, VALUE self) { FXMat4f *arg1 = (FXMat4f *) 0 ; FXVec3f *arg2 = 0 ;
    FXfloat arg3 ; FXMat4f *result; VALUE vresult = Qnil; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMat4f, 1); { if (TYPE(argv[0]) == T_ARRAY) {
            arg2 = new FXVec3f(NUM2DBL(rb_ary_entry(argv[0], 0)), NUM2DBL(rb_ary_entry(argv[0], 1)), NUM2DBL(rb_ary_entry(argv[0], 2))); }
         else { FXVec3f *p; SWIG_ConvertPtr(argv[0], (void **)&p, SWIGTYPE_p_FXVec3f, 1); arg2 = new FXVec3f(*p); }  } 
    arg3 = (FXfloat) NUM2DBL(argv[1]); { FXMat4f &_result_ref = (arg1)->rot((FXVec3f const &)*arg2,arg3);
        result = (FXMat4f *) &_result_ref; }  vresult = FXRbGetRubyObj(result, "FXMat4f *"); delete arg2; return vresult; }
static VALUE _wrap_FXMat4f_rot(int nargs, VALUE *args, VALUE self) { int argc; VALUE argv[5]; int ii; argc = nargs + 1;
    argv[0] = self; for (ii = 1; (ii < argc) && (ii < 4); ii++) { argv[ii] = args[ii-1]; }  if (argc == 2) { int _v; {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXMat4f, 0) != -1)) ? 1 : 0; }
         if (_v) { { void *ptr;
                _v = (NIL_P(argv[1]) || (TYPE(argv[1]) == T_DATA && SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_FXQuatf, 0) != -1)) ? 1 : 0; }
             if (_v) { return _wrap_FXMat4f_rot__SWIG_0(nargs, args, self);}  }  }  if (argc == 3) { int _v; { void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXMat4f, 0) != -1)) ? 1 : 0; }
         if (_v) { { void *ptr;
                _v = (NIL_P(argv[1]) || (TYPE(argv[1]) == T_DATA && SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_FXVec3f, 0) != -1)) ? 1 : 0; }
             if (_v) { {
                    _v = ((TYPE(argv[2]) == T_FLOAT) || (TYPE(argv[2]) == T_FIXNUM) || (TYPE(argv[2]) == T_BIGNUM)) ? 1 : 0; } 
                if (_v) { return _wrap_FXMat4f_rot__SWIG_2(nargs, args, self);}  }  }  }  if (argc == 4) { int _v; { void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXMat4f, 0) != -1)) ? 1 : 0; }
         if (_v) { { void *ptr;
                _v = (NIL_P(argv[1]) || (TYPE(argv[1]) == T_DATA && SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_FXVec3f, 0) != -1)) ? 1 : 0; }
             if (_v) { {
                    _v = ((TYPE(argv[2]) == T_FLOAT) || (TYPE(argv[2]) == T_FIXNUM) || (TYPE(argv[2]) == T_BIGNUM)) ? 1 : 0; } 
                if (_v) { {
                        _v = ((TYPE(argv[3]) == T_FLOAT) || (TYPE(argv[3]) == T_FIXNUM) || (TYPE(argv[3]) == T_BIGNUM)) ? 1 : 0; }
                     if (_v) { return _wrap_FXMat4f_rot__SWIG_1(nargs, args, self);}  }  }  }  } 
    rb_raise(rb_eArgError, "No matching function for overloaded 'FXMat4f_rot'"); return Qnil; }
static VALUE _wrap_FXMat4f_xrot__SWIG_0(int argc, VALUE *argv, VALUE self) { FXMat4f *arg1 = (FXMat4f *) 0 ; FXfloat arg2 ;
    FXfloat arg3 ; FXMat4f *result; VALUE vresult = Qnil; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMat4f, 1); arg2 = (FXfloat) NUM2DBL(argv[0]);
    arg3 = (FXfloat) NUM2DBL(argv[1]); { FXMat4f &_result_ref = (arg1)->xrot(arg2,arg3); result = (FXMat4f *) &_result_ref; } 
    vresult = FXRbGetRubyObj(result, "FXMat4f *"); return vresult; }
static VALUE _wrap_FXMat4f_xrot__SWIG_1(int argc, VALUE *argv, VALUE self) { FXMat4f *arg1 = (FXMat4f *) 0 ; FXfloat arg2 ;
    FXMat4f *result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMat4f, 1); arg2 = (FXfloat) NUM2DBL(argv[0]); {
        FXMat4f &_result_ref = (arg1)->xrot(arg2); result = (FXMat4f *) &_result_ref; } 
    vresult = FXRbGetRubyObj(result, "FXMat4f *"); return vresult; }
static VALUE _wrap_FXMat4f_xrot(int nargs, VALUE *args, VALUE self) { int argc; VALUE argv[4]; int ii; argc = nargs + 1;
    argv[0] = self; for (ii = 1; (ii < argc) && (ii < 3); ii++) { argv[ii] = args[ii-1]; }  if (argc == 2) { int _v; {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXMat4f, 0) != -1)) ? 1 : 0; }
         if (_v) { { _v = ((TYPE(argv[1]) == T_FLOAT) || (TYPE(argv[1]) == T_FIXNUM) || (TYPE(argv[1]) == T_BIGNUM)) ? 1 : 0; } 
            if (_v) { return _wrap_FXMat4f_xrot__SWIG_1(nargs, args, self);}  }  }  if (argc == 3) { int _v; { void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXMat4f, 0) != -1)) ? 1 : 0; }
         if (_v) { { _v = ((TYPE(argv[1]) == T_FLOAT) || (TYPE(argv[1]) == T_FIXNUM) || (TYPE(argv[1]) == T_BIGNUM)) ? 1 : 0; } 
            if (_v) { {
                    _v = ((TYPE(argv[2]) == T_FLOAT) || (TYPE(argv[2]) == T_FIXNUM) || (TYPE(argv[2]) == T_BIGNUM)) ? 1 : 0; } 
                if (_v) { return _wrap_FXMat4f_xrot__SWIG_0(nargs, args, self);}  }  }  } 
    rb_raise(rb_eArgError, "No matching function for overloaded 'FXMat4f_xrot'"); return Qnil; }
static VALUE _wrap_FXMat4f_yrot__SWIG_0(int argc, VALUE *argv, VALUE self) { FXMat4f *arg1 = (FXMat4f *) 0 ; FXfloat arg2 ;
    FXfloat arg3 ; FXMat4f *result; VALUE vresult = Qnil; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMat4f, 1); arg2 = (FXfloat) NUM2DBL(argv[0]);
    arg3 = (FXfloat) NUM2DBL(argv[1]); { FXMat4f &_result_ref = (arg1)->yrot(arg2,arg3); result = (FXMat4f *) &_result_ref; } 
    vresult = FXRbGetRubyObj(result, "FXMat4f *"); return vresult; }
static VALUE _wrap_FXMat4f_yrot__SWIG_1(int argc, VALUE *argv, VALUE self) { FXMat4f *arg1 = (FXMat4f *) 0 ; FXfloat arg2 ;
    FXMat4f *result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMat4f, 1); arg2 = (FXfloat) NUM2DBL(argv[0]); {
        FXMat4f &_result_ref = (arg1)->yrot(arg2); result = (FXMat4f *) &_result_ref; } 
    vresult = FXRbGetRubyObj(result, "FXMat4f *"); return vresult; }
static VALUE _wrap_FXMat4f_yrot(int nargs, VALUE *args, VALUE self) { int argc; VALUE argv[4]; int ii; argc = nargs + 1;
    argv[0] = self; for (ii = 1; (ii < argc) && (ii < 3); ii++) { argv[ii] = args[ii-1]; }  if (argc == 2) { int _v; {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXMat4f, 0) != -1)) ? 1 : 0; }
         if (_v) { { _v = ((TYPE(argv[1]) == T_FLOAT) || (TYPE(argv[1]) == T_FIXNUM) || (TYPE(argv[1]) == T_BIGNUM)) ? 1 : 0; } 
            if (_v) { return _wrap_FXMat4f_yrot__SWIG_1(nargs, args, self);}  }  }  if (argc == 3) { int _v; { void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXMat4f, 0) != -1)) ? 1 : 0; }
         if (_v) { { _v = ((TYPE(argv[1]) == T_FLOAT) || (TYPE(argv[1]) == T_FIXNUM) || (TYPE(argv[1]) == T_BIGNUM)) ? 1 : 0; } 
            if (_v) { {
                    _v = ((TYPE(argv[2]) == T_FLOAT) || (TYPE(argv[2]) == T_FIXNUM) || (TYPE(argv[2]) == T_BIGNUM)) ? 1 : 0; } 
                if (_v) { return _wrap_FXMat4f_yrot__SWIG_0(nargs, args, self);}  }  }  } 
    rb_raise(rb_eArgError, "No matching function for overloaded 'FXMat4f_yrot'"); return Qnil; }
static VALUE _wrap_FXMat4f_zrot__SWIG_0(int argc, VALUE *argv, VALUE self) { FXMat4f *arg1 = (FXMat4f *) 0 ; FXfloat arg2 ;
    FXfloat arg3 ; FXMat4f *result; VALUE vresult = Qnil; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMat4f, 1); arg2 = (FXfloat) NUM2DBL(argv[0]);
    arg3 = (FXfloat) NUM2DBL(argv[1]); { FXMat4f &_result_ref = (arg1)->zrot(arg2,arg3); result = (FXMat4f *) &_result_ref; } 
    vresult = FXRbGetRubyObj(result, "FXMat4f *"); return vresult; }
static VALUE _wrap_FXMat4f_zrot__SWIG_1(int argc, VALUE *argv, VALUE self) { FXMat4f *arg1 = (FXMat4f *) 0 ; FXfloat arg2 ;
    FXMat4f *result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMat4f, 1); arg2 = (FXfloat) NUM2DBL(argv[0]); {
        FXMat4f &_result_ref = (arg1)->zrot(arg2); result = (FXMat4f *) &_result_ref; } 
    vresult = FXRbGetRubyObj(result, "FXMat4f *"); return vresult; }
static VALUE _wrap_FXMat4f_zrot(int nargs, VALUE *args, VALUE self) { int argc; VALUE argv[4]; int ii; argc = nargs + 1;
    argv[0] = self; for (ii = 1; (ii < argc) && (ii < 3); ii++) { argv[ii] = args[ii-1]; }  if (argc == 2) { int _v; {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXMat4f, 0) != -1)) ? 1 : 0; }
         if (_v) { { _v = ((TYPE(argv[1]) == T_FLOAT) || (TYPE(argv[1]) == T_FIXNUM) || (TYPE(argv[1]) == T_BIGNUM)) ? 1 : 0; } 
            if (_v) { return _wrap_FXMat4f_zrot__SWIG_1(nargs, args, self);}  }  }  if (argc == 3) { int _v; { void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXMat4f, 0) != -1)) ? 1 : 0; }
         if (_v) { { _v = ((TYPE(argv[1]) == T_FLOAT) || (TYPE(argv[1]) == T_FIXNUM) || (TYPE(argv[1]) == T_BIGNUM)) ? 1 : 0; } 
            if (_v) { {
                    _v = ((TYPE(argv[2]) == T_FLOAT) || (TYPE(argv[2]) == T_FIXNUM) || (TYPE(argv[2]) == T_BIGNUM)) ? 1 : 0; } 
                if (_v) { return _wrap_FXMat4f_zrot__SWIG_0(nargs, args, self);}  }  }  } 
    rb_raise(rb_eArgError, "No matching function for overloaded 'FXMat4f_zrot'"); return Qnil; }
static VALUE _wrap_FXMat4f_look(int argc, VALUE *argv, VALUE self) { FXMat4f *arg1 = (FXMat4f *) 0 ; FXVec3f *arg2 = 0 ;
    FXVec3f *arg3 = 0 ; FXVec3f *arg4 = 0 ; FXMat4f *result; VALUE vresult = Qnil; if ((argc < 3) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMat4f, 1); { if (TYPE(argv[0]) == T_ARRAY) {
            arg2 = new FXVec3f(NUM2DBL(rb_ary_entry(argv[0], 0)), NUM2DBL(rb_ary_entry(argv[0], 1)), NUM2DBL(rb_ary_entry(argv[0], 2))); }
         else { FXVec3f *p; SWIG_ConvertPtr(argv[0], (void **)&p, SWIGTYPE_p_FXVec3f, 1); arg2 = new FXVec3f(*p); }  }  {
        if (TYPE(argv[1]) == T_ARRAY) {
            arg3 = new FXVec3f(NUM2DBL(rb_ary_entry(argv[1], 0)), NUM2DBL(rb_ary_entry(argv[1], 1)), NUM2DBL(rb_ary_entry(argv[1], 2))); }
         else { FXVec3f *p; SWIG_ConvertPtr(argv[1], (void **)&p, SWIGTYPE_p_FXVec3f, 1); arg3 = new FXVec3f(*p); }  }  {
        if (TYPE(argv[2]) == T_ARRAY) {
            arg4 = new FXVec3f(NUM2DBL(rb_ary_entry(argv[2], 0)), NUM2DBL(rb_ary_entry(argv[2], 1)), NUM2DBL(rb_ary_entry(argv[2], 2))); }
         else { FXVec3f *p; SWIG_ConvertPtr(argv[2], (void **)&p, SWIGTYPE_p_FXVec3f, 1); arg4 = new FXVec3f(*p); }  }  {
        FXMat4f &_result_ref = (arg1)->look((FXVec3f const &)*arg2,(FXVec3f const &)*arg3,(FXVec3f const &)*arg4);
        result = (FXMat4f *) &_result_ref; }  vresult = FXRbGetRubyObj(result, "FXMat4f *"); delete arg2; delete arg3;
    delete arg4; return vresult; }
static VALUE _wrap_FXMat4f_trans__SWIG_0(int argc, VALUE *argv, VALUE self) { FXMat4f *arg1 = (FXMat4f *) 0 ; FXfloat arg2 ;
    FXfloat arg3 ; FXfloat arg4 ; FXMat4f *result; VALUE vresult = Qnil; if ((argc < 3) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMat4f, 1); arg2 = (FXfloat) NUM2DBL(argv[0]);
    arg3 = (FXfloat) NUM2DBL(argv[1]); arg4 = (FXfloat) NUM2DBL(argv[2]); {
        FXMat4f &_result_ref = (arg1)->trans(arg2,arg3,arg4); result = (FXMat4f *) &_result_ref; } 
    vresult = FXRbGetRubyObj(result, "FXMat4f *"); return vresult; }
static VALUE _wrap_FXMat4f_trans__SWIG_1(int argc, VALUE *argv, VALUE self) { FXMat4f *arg1 = (FXMat4f *) 0 ;
    FXVec3f *arg2 = 0 ; FXMat4f *result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMat4f, 1); { if (TYPE(argv[0]) == T_ARRAY) {
            arg2 = new FXVec3f(NUM2DBL(rb_ary_entry(argv[0], 0)), NUM2DBL(rb_ary_entry(argv[0], 1)), NUM2DBL(rb_ary_entry(argv[0], 2))); }
         else { FXVec3f *p; SWIG_ConvertPtr(argv[0], (void **)&p, SWIGTYPE_p_FXVec3f, 1); arg2 = new FXVec3f(*p); }  }  {
        FXMat4f &_result_ref = (arg1)->trans((FXVec3f const &)*arg2); result = (FXMat4f *) &_result_ref; } 
    vresult = FXRbGetRubyObj(result, "FXMat4f *"); delete arg2; return vresult; }
static VALUE _wrap_FXMat4f_trans(int nargs, VALUE *args, VALUE self) { int argc; VALUE argv[5]; int ii; argc = nargs + 1;
    argv[0] = self; for (ii = 1; (ii < argc) && (ii < 4); ii++) { argv[ii] = args[ii-1]; }  if (argc == 2) { int _v; {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXMat4f, 0) != -1)) ? 1 : 0; }
         if (_v) { { void *ptr;
                _v = (NIL_P(argv[1]) || (TYPE(argv[1]) == T_DATA && SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_FXVec3f, 0) != -1)) ? 1 : 0; }
             if (_v) { return _wrap_FXMat4f_trans__SWIG_1(nargs, args, self);}  }  }  if (argc == 4) { int _v; { void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXMat4f, 0) != -1)) ? 1 : 0; }
         if (_v) { { _v = ((TYPE(argv[1]) == T_FLOAT) || (TYPE(argv[1]) == T_FIXNUM) || (TYPE(argv[1]) == T_BIGNUM)) ? 1 : 0; } 
            if (_v) { {
                    _v = ((TYPE(argv[2]) == T_FLOAT) || (TYPE(argv[2]) == T_FIXNUM) || (TYPE(argv[2]) == T_BIGNUM)) ? 1 : 0; } 
                if (_v) { {
                        _v = ((TYPE(argv[3]) == T_FLOAT) || (TYPE(argv[3]) == T_FIXNUM) || (TYPE(argv[3]) == T_BIGNUM)) ? 1 : 0; }
                     if (_v) { return _wrap_FXMat4f_trans__SWIG_0(nargs, args, self);}  }  }  }  } 
    rb_raise(rb_eArgError, "No matching function for overloaded 'FXMat4f_trans'"); return Qnil; }
static VALUE _wrap_FXMat4f_scale__SWIG_0(int argc, VALUE *argv, VALUE self) { FXMat4f *arg1 = (FXMat4f *) 0 ; FXfloat arg2 ;
    FXfloat arg3 ; FXfloat arg4 ; FXMat4f *result; VALUE vresult = Qnil; if ((argc < 3) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMat4f, 1); arg2 = (FXfloat) NUM2DBL(argv[0]);
    arg3 = (FXfloat) NUM2DBL(argv[1]); arg4 = (FXfloat) NUM2DBL(argv[2]); {
        FXMat4f &_result_ref = (arg1)->scale(arg2,arg3,arg4); result = (FXMat4f *) &_result_ref; } 
    vresult = FXRbGetRubyObj(result, "FXMat4f *"); return vresult; }
static VALUE _wrap_FXMat4f_scale__SWIG_1(int argc, VALUE *argv, VALUE self) { FXMat4f *arg1 = (FXMat4f *) 0 ; FXfloat arg2 ;
    FXMat4f *result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMat4f, 1); arg2 = (FXfloat) NUM2DBL(argv[0]); {
        FXMat4f &_result_ref = (arg1)->scale(arg2); result = (FXMat4f *) &_result_ref; } 
    vresult = FXRbGetRubyObj(result, "FXMat4f *"); return vresult; }
static VALUE _wrap_FXMat4f_scale__SWIG_2(int argc, VALUE *argv, VALUE self) { FXMat4f *arg1 = (FXMat4f *) 0 ;
    FXVec3f *arg2 = 0 ; FXMat4f *result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMat4f, 1); { if (TYPE(argv[0]) == T_ARRAY) {
            arg2 = new FXVec3f(NUM2DBL(rb_ary_entry(argv[0], 0)), NUM2DBL(rb_ary_entry(argv[0], 1)), NUM2DBL(rb_ary_entry(argv[0], 2))); }
         else { FXVec3f *p; SWIG_ConvertPtr(argv[0], (void **)&p, SWIGTYPE_p_FXVec3f, 1); arg2 = new FXVec3f(*p); }  }  {
        FXMat4f &_result_ref = (arg1)->scale((FXVec3f const &)*arg2); result = (FXMat4f *) &_result_ref; } 
    vresult = FXRbGetRubyObj(result, "FXMat4f *"); delete arg2; return vresult; }
static VALUE _wrap_FXMat4f_scale(int nargs, VALUE *args, VALUE self) { int argc; VALUE argv[5]; int ii; argc = nargs + 1;
    argv[0] = self; for (ii = 1; (ii < argc) && (ii < 4); ii++) { argv[ii] = args[ii-1]; }  if (argc == 2) { int _v; {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXMat4f, 0) != -1)) ? 1 : 0; }
         if (_v) { { void *ptr;
                _v = (NIL_P(argv[1]) || (TYPE(argv[1]) == T_DATA && SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_FXVec3f, 0) != -1)) ? 1 : 0; }
             if (_v) { return _wrap_FXMat4f_scale__SWIG_2(nargs, args, self);}  }  }  if (argc == 2) { int _v; { void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXMat4f, 0) != -1)) ? 1 : 0; }
         if (_v) { { _v = ((TYPE(argv[1]) == T_FLOAT) || (TYPE(argv[1]) == T_FIXNUM) || (TYPE(argv[1]) == T_BIGNUM)) ? 1 : 0; } 
            if (_v) { return _wrap_FXMat4f_scale__SWIG_1(nargs, args, self);}  }  }  if (argc == 4) { int _v; { void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXMat4f, 0) != -1)) ? 1 : 0; }
         if (_v) { { _v = ((TYPE(argv[1]) == T_FLOAT) || (TYPE(argv[1]) == T_FIXNUM) || (TYPE(argv[1]) == T_BIGNUM)) ? 1 : 0; } 
            if (_v) { {
                    _v = ((TYPE(argv[2]) == T_FLOAT) || (TYPE(argv[2]) == T_FIXNUM) || (TYPE(argv[2]) == T_BIGNUM)) ? 1 : 0; } 
                if (_v) { {
                        _v = ((TYPE(argv[3]) == T_FLOAT) || (TYPE(argv[3]) == T_FIXNUM) || (TYPE(argv[3]) == T_BIGNUM)) ? 1 : 0; }
                     if (_v) { return _wrap_FXMat4f_scale__SWIG_0(nargs, args, self);}  }  }  }  } 
    rb_raise(rb_eArgError, "No matching function for overloaded 'FXMat4f_scale'"); return Qnil; }
static VALUE _wrap_new_FXMat4d__SWIG_0(int argc, VALUE *argv, VALUE self) { FXMat4d *result; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc); { result = (FXMat4d *)new FXMat4d();
        DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result); if(rb_block_given_p()){ rb_yield(self); }  }  return self; }
static VALUE _wrap_new_FXMat4d__SWIG_1(int argc, VALUE *argv, VALUE self) { FXdouble arg1 ; FXMat4d *result;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    arg1 = (FXdouble) NUM2DBL(argv[0]); { result = (FXMat4d *)new FXMat4d(arg1);
        DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result); if(rb_block_given_p()){ rb_yield(self); }  }  return self; }
static VALUE _wrap_new_FXMat4d__SWIG_2(int argc, VALUE *argv, VALUE self) { FXdouble arg1 ; FXdouble arg2 ; FXdouble arg3 ;
    FXdouble arg4 ; FXdouble arg5 ; FXdouble arg6 ; FXdouble arg7 ; FXdouble arg8 ; FXdouble arg9 ; FXdouble arg10 ;
    FXdouble arg11 ; FXdouble arg12 ; FXdouble arg13 ; FXdouble arg14 ; FXdouble arg15 ; FXdouble arg16 ; FXMat4d *result;
    if ((argc < 16) || (argc > 16)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 16)",argc);
    arg1 = (FXdouble) NUM2DBL(argv[0]); arg2 = (FXdouble) NUM2DBL(argv[1]); arg3 = (FXdouble) NUM2DBL(argv[2]);
    arg4 = (FXdouble) NUM2DBL(argv[3]); arg5 = (FXdouble) NUM2DBL(argv[4]); arg6 = (FXdouble) NUM2DBL(argv[5]);
    arg7 = (FXdouble) NUM2DBL(argv[6]); arg8 = (FXdouble) NUM2DBL(argv[7]); arg9 = (FXdouble) NUM2DBL(argv[8]);
    arg10 = (FXdouble) NUM2DBL(argv[9]); arg11 = (FXdouble) NUM2DBL(argv[10]); arg12 = (FXdouble) NUM2DBL(argv[11]);
    arg13 = (FXdouble) NUM2DBL(argv[12]); arg14 = (FXdouble) NUM2DBL(argv[13]); arg15 = (FXdouble) NUM2DBL(argv[14]);
    arg16 = (FXdouble) NUM2DBL(argv[15]); {
        result = (FXMat4d *)new FXMat4d(arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8,arg9,arg10,arg11,arg12,arg13,arg14,arg15,arg16);
        DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result); if(rb_block_given_p()){ rb_yield(self); }  }  return self; }
static VALUE _wrap_new_FXMat4d__SWIG_3(int argc, VALUE *argv, VALUE self) { FXVec4d *arg1 = 0 ; FXVec4d *arg2 = 0 ;
    FXVec4d *arg3 = 0 ; FXVec4d *arg4 = 0 ; FXMat4d *result; if ((argc < 4) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXVec4d, 1); if (arg1 == NULL) rb_raise(rb_eTypeError, "null reference");
    SWIG_ConvertPtr(argv[1], (void **) &arg2, SWIGTYPE_p_FXVec4d, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    SWIG_ConvertPtr(argv[2], (void **) &arg3, SWIGTYPE_p_FXVec4d, 1); if (arg3 == NULL) rb_raise(rb_eTypeError, "null reference");
    SWIG_ConvertPtr(argv[3], (void **) &arg4, SWIGTYPE_p_FXVec4d, 1); if (arg4 == NULL) rb_raise(rb_eTypeError, "null reference");
    {
        result = (FXMat4d *)new FXMat4d((FXVec4d const &)*arg1,(FXVec4d const &)*arg2,(FXVec4d const &)*arg3,(FXVec4d const &)*arg4);
        DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result); if(rb_block_given_p()){ rb_yield(self); }  }  return self; }
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE _wrap_FXMat4d_allocate(VALUE self) {
#else
     static VALUE _wrap_FXMat4d_allocate(int argc, VALUE *argv, VALUE self) {
#endif
         VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_FXMat4d);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
         return vresult; }
static VALUE _wrap_new_FXMat4d__SWIG_4(int argc, VALUE *argv, VALUE self) { FXMat4d *arg1 = 0 ; FXMat4d *result;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXMat4d, 1); if (arg1 == NULL) rb_raise(rb_eTypeError, "null reference");
    { result = (FXMat4d *)new FXMat4d((FXMat4d const &)*arg1); DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result);
        if(rb_block_given_p()){ rb_yield(self); }  }  return self; }
static VALUE _wrap_new_FXMat4d(int nargs, VALUE *args, VALUE self) { int argc; VALUE argv[16]; int ii; argc = nargs;
    for (ii = 0; (ii < argc) && (ii < 16); ii++) { argv[ii] = args[ii]; }  if (argc == 0) {
        return _wrap_new_FXMat4d__SWIG_0(nargs, args, self);}  if (argc == 1) { int _v; { void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXMat4d, 0) != -1)) ? 1 : 0; }
         if (_v) { return _wrap_new_FXMat4d__SWIG_4(nargs, args, self);}  }  if (argc == 1) { int _v; {
            _v = ((TYPE(argv[0]) == T_FLOAT) || (TYPE(argv[0]) == T_FIXNUM) || (TYPE(argv[0]) == T_BIGNUM)) ? 1 : 0; } 
        if (_v) { return _wrap_new_FXMat4d__SWIG_1(nargs, args, self);}  }  if (argc == 4) { int _v; { void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXVec4d, 0) != -1)) ? 1 : 0; }
         if (_v) { { void *ptr;
                _v = (NIL_P(argv[1]) || (TYPE(argv[1]) == T_DATA && SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_FXVec4d, 0) != -1)) ? 1 : 0; }
             if (_v) { { void *ptr;
                    _v = (NIL_P(argv[2]) || (TYPE(argv[2]) == T_DATA && SWIG_ConvertPtr(argv[2], &ptr, SWIGTYPE_p_FXVec4d, 0) != -1)) ? 1 : 0; }
                 if (_v) { { void *ptr;
                        _v = (NIL_P(argv[3]) || (TYPE(argv[3]) == T_DATA && SWIG_ConvertPtr(argv[3], &ptr, SWIGTYPE_p_FXVec4d, 0) != -1)) ? 1 : 0; }
                     if (_v) { return _wrap_new_FXMat4d__SWIG_3(nargs, args, self);}  }  }  }  }  if (argc == 16) { int _v; {
            _v = ((TYPE(argv[0]) == T_FLOAT) || (TYPE(argv[0]) == T_FIXNUM) || (TYPE(argv[0]) == T_BIGNUM)) ? 1 : 0; } 
        if (_v) { { _v = ((TYPE(argv[1]) == T_FLOAT) || (TYPE(argv[1]) == T_FIXNUM) || (TYPE(argv[1]) == T_BIGNUM)) ? 1 : 0; } 
            if (_v) { {
                    _v = ((TYPE(argv[2]) == T_FLOAT) || (TYPE(argv[2]) == T_FIXNUM) || (TYPE(argv[2]) == T_BIGNUM)) ? 1 : 0; } 
                if (_v) { {
                        _v = ((TYPE(argv[3]) == T_FLOAT) || (TYPE(argv[3]) == T_FIXNUM) || (TYPE(argv[3]) == T_BIGNUM)) ? 1 : 0; }
                     if (_v) { {
                            _v = ((TYPE(argv[4]) == T_FLOAT) || (TYPE(argv[4]) == T_FIXNUM) || (TYPE(argv[4]) == T_BIGNUM)) ? 1 : 0; }
                         if (_v) { {
                                _v = ((TYPE(argv[5]) == T_FLOAT) || (TYPE(argv[5]) == T_FIXNUM) || (TYPE(argv[5]) == T_BIGNUM)) ? 1 : 0; }
                             if (_v) { {
                                    _v = ((TYPE(argv[6]) == T_FLOAT) || (TYPE(argv[6]) == T_FIXNUM) || (TYPE(argv[6]) == T_BIGNUM)) ? 1 : 0; }
                                 if (_v) { {
                                        _v = ((TYPE(argv[7]) == T_FLOAT) || (TYPE(argv[7]) == T_FIXNUM) || (TYPE(argv[7]) == T_BIGNUM)) ? 1 : 0; }
                                     if (_v) { {
                                            _v = ((TYPE(argv[8]) == T_FLOAT) || (TYPE(argv[8]) == T_FIXNUM) || (TYPE(argv[8]) == T_BIGNUM)) ? 1 : 0; }
                                         if (_v) { {
                                                _v = ((TYPE(argv[9]) == T_FLOAT) || (TYPE(argv[9]) == T_FIXNUM) || (TYPE(argv[9]) == T_BIGNUM)) ? 1 : 0; }
                                             if (_v) { {
                                                    _v = ((TYPE(argv[10]) == T_FLOAT) || (TYPE(argv[10]) == T_FIXNUM) || (TYPE(argv[10]) == T_BIGNUM)) ? 1 : 0; }
                                                 if (_v) { {
                                                        _v = ((TYPE(argv[11]) == T_FLOAT) || (TYPE(argv[11]) == T_FIXNUM) || (TYPE(argv[11]) == T_BIGNUM)) ? 1 : 0; }
                                                     if (_v) { {
                                                            _v = ((TYPE(argv[12]) == T_FLOAT) || (TYPE(argv[12]) == T_FIXNUM) || (TYPE(argv[12]) == T_BIGNUM)) ? 1 : 0; }
                                                         if (_v) { {
                                                                _v = ((TYPE(argv[13]) == T_FLOAT) || (TYPE(argv[13]) == T_FIXNUM) || (TYPE(argv[13]) == T_BIGNUM)) ? 1 : 0; }
                                                             if (_v) { {
                                                                    _v = ((TYPE(argv[14]) == T_FLOAT) || (TYPE(argv[14]) == T_FIXNUM) || (TYPE(argv[14]) == T_BIGNUM)) ? 1 : 0; }
                                                                 if (_v) { {
                                                                        _v = ((TYPE(argv[15]) == T_FLOAT) || (TYPE(argv[15]) == T_FIXNUM) || (TYPE(argv[15]) == T_BIGNUM)) ? 1 : 0; }
                                                                     if (_v) {
                                                                        return _wrap_new_FXMat4d__SWIG_2(nargs, args, self);}  }
                                                                 }  }  }  }  }  }  }  }  }  }  }  }  }  }  } 
    rb_raise(rb_eArgError, "No matching function for overloaded 'new_FXMat4d'"); return Qnil; }
static VALUE _wrap_FXMat4d___getitem__(int argc, VALUE *argv, VALUE self) { FXMat4d *arg1 = (FXMat4d *) 0 ; FXint arg2 ;
    FXVec4d *result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMat4d, 1); arg2 = NUM2INT(argv[0]); {
        FXVec4d const &_result_ref = FXMat4d___getitem__((FXMat4d const *)arg1,arg2); result = (FXVec4d *) &_result_ref; } 
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_FXVec4d,0); return vresult; }
static VALUE _wrap_FXMat4d___setitem__(int argc, VALUE *argv, VALUE self) { FXMat4d *arg1 = (FXMat4d *) 0 ; FXint arg2 ;
    FXVec3d *arg3 = 0 ; FXVec4d *result; VALUE vresult = Qnil; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMat4d, 1); arg2 = NUM2INT(argv[0]);
    SWIG_ConvertPtr(argv[1], (void **) &arg3, SWIGTYPE_p_FXVec3d, 1); if (arg3 == NULL) rb_raise(rb_eTypeError, "null reference");
    { FXVec4d &_result_ref = FXMat4d___setitem__(arg1,arg2,(FXVec3d const &)*arg3); result = (FXVec4d *) &_result_ref; } 
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_FXVec4d,0); return vresult; }
static VALUE _wrap_FXMat4d___add__(int argc, VALUE *argv, VALUE self) { FXMat4d *arg1 = (FXMat4d *) 0 ; FXMat4d *arg2 = 0 ;
    FXMat4d result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMat4d, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXMat4d, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    result = FXMat4d_operator_Sa_((FXMat4d const *)arg1,(FXMat4d const &)*arg2); { FXMat4d * resultptr;
        resultptr = new FXMat4d((FXMat4d &)result); vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_FXMat4d, 1); } 
    return vresult; }
static VALUE _wrap_FXMat4d___sub__(int argc, VALUE *argv, VALUE self) { FXMat4d *arg1 = (FXMat4d *) 0 ; FXMat4d *arg2 = 0 ;
    FXMat4d result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMat4d, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXMat4d, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    result = FXMat4d_operator_Ss_((FXMat4d const *)arg1,(FXMat4d const &)*arg2); { FXMat4d * resultptr;
        resultptr = new FXMat4d((FXMat4d &)result); vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_FXMat4d, 1); } 
    return vresult; }
static VALUE _wrap_FXMat4d___neg__(int argc, VALUE *argv, VALUE self) { FXMat4d *arg1 = (FXMat4d *) 0 ; FXMat4d result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMat4d, 1); result = FXMat4d_operator_Ss_((FXMat4d const *)arg1); {
        FXMat4d * resultptr; resultptr = new FXMat4d((FXMat4d &)result);
        vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_FXMat4d, 1); }  return vresult; }
static VALUE _wrap_FXMat4d___mul____SWIG_0(int argc, VALUE *argv, VALUE self) { FXMat4d *arg1 = (FXMat4d *) 0 ;
    FXMat4d *arg2 = 0 ; FXMat4d result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMat4d, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXMat4d, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    result = FXMat4d_operator_Sm___SWIG_0((FXMat4d const *)arg1,(FXMat4d const &)*arg2); { FXMat4d * resultptr;
        resultptr = new FXMat4d((FXMat4d &)result); vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_FXMat4d, 1); } 
    return vresult; }
static VALUE _wrap_FXMat4d___mul____SWIG_1(int argc, VALUE *argv, VALUE self) { FXMat4d *arg1 = (FXMat4d *) 0 ; FXdouble arg2 ;
    FXMat4d result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMat4d, 1); arg2 = (FXdouble) NUM2DBL(argv[0]);
    result = FXMat4d_operator_Sm___SWIG_1((FXMat4d const *)arg1,arg2); { FXMat4d * resultptr;
        resultptr = new FXMat4d((FXMat4d &)result); vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_FXMat4d, 1); } 
    return vresult; }
static VALUE _wrap_FXMat4d___div__(int argc, VALUE *argv, VALUE self) { FXMat4d *arg1 = (FXMat4d *) 0 ; FXdouble arg2 ;
    FXMat4d result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMat4d, 1); arg2 = (FXdouble) NUM2DBL(argv[0]);
    result = FXMat4d_operator_Sd_((FXMat4d const *)arg1,arg2); { FXMat4d * resultptr;
        resultptr = new FXMat4d((FXMat4d &)result); vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_FXMat4d, 1); } 
    return vresult; }
static VALUE _wrap_FXMat4d___mul____SWIG_2(int argc, VALUE *argv, VALUE self) { FXMat4d *arg1 = (FXMat4d *) 0 ;
    FXVec4d *arg2 = 0 ; FXVec4d result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMat4d, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXVec4d, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    result = FXMat4d_operator_Sm___SWIG_2((FXMat4d const *)arg1,(FXVec4d const &)*arg2); { FXVec4d * resultptr;
        resultptr = new FXVec4d((FXVec4d &)result); vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_FXVec4d, 1); } 
    return vresult; }
static VALUE _wrap_FXMat4d___mul____SWIG_3(int argc, VALUE *argv, VALUE self) { FXMat4d *arg1 = (FXMat4d *) 0 ;
    FXVec3d *arg2 = 0 ; FXVec3d result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMat4d, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXVec3d, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    result = FXMat4d_operator_Sm___SWIG_3((FXMat4d const *)arg1,(FXVec3d const &)*arg2); { FXVec3d * resultptr;
        resultptr = new FXVec3d((FXVec3d &)result); vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_FXVec3d, 1); } 
    return vresult; }
static VALUE _wrap_FXMat4d___mul__(int nargs, VALUE *args, VALUE self) { int argc; VALUE argv[3]; int ii; argc = nargs + 1;
    argv[0] = self; for (ii = 1; (ii < argc) && (ii < 2); ii++) { argv[ii] = args[ii-1]; }  if (argc == 2) { int _v; {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXMat4d, 0) != -1)) ? 1 : 0; }
         if (_v) { { void *ptr;
                _v = (NIL_P(argv[1]) || (TYPE(argv[1]) == T_DATA && SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_FXMat4d, 0) != -1)) ? 1 : 0; }
             if (_v) { return _wrap_FXMat4d___mul____SWIG_0(nargs, args, self);}  }  }  if (argc == 2) { int _v; { void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXMat4d, 0) != -1)) ? 1 : 0; }
         if (_v) { { void *ptr;
                _v = (NIL_P(argv[1]) || (TYPE(argv[1]) == T_DATA && SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_FXVec4d, 0) != -1)) ? 1 : 0; }
             if (_v) { return _wrap_FXMat4d___mul____SWIG_2(nargs, args, self);}  }  }  if (argc == 2) { int _v; { void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXMat4d, 0) != -1)) ? 1 : 0; }
         if (_v) { { void *ptr;
                _v = (NIL_P(argv[1]) || (TYPE(argv[1]) == T_DATA && SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_FXVec3d, 0) != -1)) ? 1 : 0; }
             if (_v) { return _wrap_FXMat4d___mul____SWIG_3(nargs, args, self);}  }  }  if (argc == 2) { int _v; { void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXMat4d, 0) != -1)) ? 1 : 0; }
         if (_v) { { _v = ((TYPE(argv[1]) == T_FLOAT) || (TYPE(argv[1]) == T_FIXNUM) || (TYPE(argv[1]) == T_BIGNUM)) ? 1 : 0; } 
            if (_v) { return _wrap_FXMat4d___mul____SWIG_1(nargs, args, self);}  }  } 
    rb_raise(rb_eArgError, "No matching function for overloaded 'FXMat4d___mul__'"); return Qnil; }
static VALUE _wrap_FXMat4d_eye(int argc, VALUE *argv, VALUE self) { FXMat4d *arg1 = (FXMat4d *) 0 ; FXMat4d *result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMat4d, 1); { FXMat4d &_result_ref = (arg1)->eye();
        result = (FXMat4d *) &_result_ref; }  vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_FXMat4d,0);
    return vresult; }
static VALUE _wrap_FXMat4d_ortho(int argc, VALUE *argv, VALUE self) { FXMat4d *arg1 = (FXMat4d *) 0 ; FXdouble arg2 ;
    FXdouble arg3 ; FXdouble arg4 ; FXdouble arg5 ; FXdouble arg6 ; FXdouble arg7 ; FXMat4d *result; VALUE vresult = Qnil;
    if ((argc < 6) || (argc > 6)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 6)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMat4d, 1); arg2 = (FXdouble) NUM2DBL(argv[0]);
    arg3 = (FXdouble) NUM2DBL(argv[1]); arg4 = (FXdouble) NUM2DBL(argv[2]); arg5 = (FXdouble) NUM2DBL(argv[3]);
    arg6 = (FXdouble) NUM2DBL(argv[4]); arg7 = (FXdouble) NUM2DBL(argv[5]); {
        FXMat4d &_result_ref = (arg1)->ortho(arg2,arg3,arg4,arg5,arg6,arg7); result = (FXMat4d *) &_result_ref; } 
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_FXMat4d,0); return vresult; }
static VALUE _wrap_FXMat4d_frustum(int argc, VALUE *argv, VALUE self) { FXMat4d *arg1 = (FXMat4d *) 0 ; FXdouble arg2 ;
    FXdouble arg3 ; FXdouble arg4 ; FXdouble arg5 ; FXdouble arg6 ; FXdouble arg7 ; FXMat4d *result; VALUE vresult = Qnil;
    if ((argc < 6) || (argc > 6)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 6)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMat4d, 1); arg2 = (FXdouble) NUM2DBL(argv[0]);
    arg3 = (FXdouble) NUM2DBL(argv[1]); arg4 = (FXdouble) NUM2DBL(argv[2]); arg5 = (FXdouble) NUM2DBL(argv[3]);
    arg6 = (FXdouble) NUM2DBL(argv[4]); arg7 = (FXdouble) NUM2DBL(argv[5]); {
        FXMat4d &_result_ref = (arg1)->frustum(arg2,arg3,arg4,arg5,arg6,arg7); result = (FXMat4d *) &_result_ref; } 
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_FXMat4d,0); return vresult; }
static VALUE _wrap_FXMat4d_left(int argc, VALUE *argv, VALUE self) { FXMat4d *arg1 = (FXMat4d *) 0 ; FXMat4d *result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMat4d, 1); { FXMat4d &_result_ref = (arg1)->left();
        result = (FXMat4d *) &_result_ref; }  vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_FXMat4d,0);
    return vresult; }
static VALUE _wrap_FXMat4d_rot__SWIG_0(int argc, VALUE *argv, VALUE self) { FXMat4d *arg1 = (FXMat4d *) 0 ; FXQuatd *arg2 = 0 ;
    FXMat4d *result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMat4d, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXQuatd, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    { FXMat4d &_result_ref = (arg1)->rot((FXQuatd const &)*arg2); result = (FXMat4d *) &_result_ref; } 
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_FXMat4d,0); return vresult; }
static VALUE _wrap_FXMat4d_rot__SWIG_1(int argc, VALUE *argv, VALUE self) { FXMat4d *arg1 = (FXMat4d *) 0 ; FXVec3d *arg2 = 0 ;
    FXdouble arg3 ; FXdouble arg4 ; FXMat4d *result; VALUE vresult = Qnil; if ((argc < 3) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMat4d, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXVec3d, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    arg3 = (FXdouble) NUM2DBL(argv[1]); arg4 = (FXdouble) NUM2DBL(argv[2]); {
        FXMat4d &_result_ref = (arg1)->rot((FXVec3d const &)*arg2,arg3,arg4); result = (FXMat4d *) &_result_ref; } 
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_FXMat4d,0); return vresult; }
static VALUE _wrap_FXMat4d_rot__SWIG_2(int argc, VALUE *argv, VALUE self) { FXMat4d *arg1 = (FXMat4d *) 0 ; FXVec3d *arg2 = 0 ;
    FXdouble arg3 ; FXMat4d *result; VALUE vresult = Qnil; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMat4d, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXVec3d, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    arg3 = (FXdouble) NUM2DBL(argv[1]); { FXMat4d &_result_ref = (arg1)->rot((FXVec3d const &)*arg2,arg3);
        result = (FXMat4d *) &_result_ref; }  vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_FXMat4d,0);
    return vresult; }
static VALUE _wrap_FXMat4d_rot(int nargs, VALUE *args, VALUE self) { int argc; VALUE argv[5]; int ii; argc = nargs + 1;
    argv[0] = self; for (ii = 1; (ii < argc) && (ii < 4); ii++) { argv[ii] = args[ii-1]; }  if (argc == 2) { int _v; {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXMat4d, 0) != -1)) ? 1 : 0; }
         if (_v) { { void *ptr;
                _v = (NIL_P(argv[1]) || (TYPE(argv[1]) == T_DATA && SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_FXQuatd, 0) != -1)) ? 1 : 0; }
             if (_v) { return _wrap_FXMat4d_rot__SWIG_0(nargs, args, self);}  }  }  if (argc == 3) { int _v; { void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXMat4d, 0) != -1)) ? 1 : 0; }
         if (_v) { { void *ptr;
                _v = (NIL_P(argv[1]) || (TYPE(argv[1]) == T_DATA && SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_FXVec3d, 0) != -1)) ? 1 : 0; }
             if (_v) { {
                    _v = ((TYPE(argv[2]) == T_FLOAT) || (TYPE(argv[2]) == T_FIXNUM) || (TYPE(argv[2]) == T_BIGNUM)) ? 1 : 0; } 
                if (_v) { return _wrap_FXMat4d_rot__SWIG_2(nargs, args, self);}  }  }  }  if (argc == 4) { int _v; { void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXMat4d, 0) != -1)) ? 1 : 0; }
         if (_v) { { void *ptr;
                _v = (NIL_P(argv[1]) || (TYPE(argv[1]) == T_DATA && SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_FXVec3d, 0) != -1)) ? 1 : 0; }
             if (_v) { {
                    _v = ((TYPE(argv[2]) == T_FLOAT) || (TYPE(argv[2]) == T_FIXNUM) || (TYPE(argv[2]) == T_BIGNUM)) ? 1 : 0; } 
                if (_v) { {
                        _v = ((TYPE(argv[3]) == T_FLOAT) || (TYPE(argv[3]) == T_FIXNUM) || (TYPE(argv[3]) == T_BIGNUM)) ? 1 : 0; }
                     if (_v) { return _wrap_FXMat4d_rot__SWIG_1(nargs, args, self);}  }  }  }  } 
    rb_raise(rb_eArgError, "No matching function for overloaded 'FXMat4d_rot'"); return Qnil; }
static VALUE _wrap_FXMat4d_xrot__SWIG_0(int argc, VALUE *argv, VALUE self) { FXMat4d *arg1 = (FXMat4d *) 0 ; FXdouble arg2 ;
    FXdouble arg3 ; FXMat4d *result; VALUE vresult = Qnil; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMat4d, 1); arg2 = (FXdouble) NUM2DBL(argv[0]);
    arg3 = (FXdouble) NUM2DBL(argv[1]); { FXMat4d &_result_ref = (arg1)->xrot(arg2,arg3); result = (FXMat4d *) &_result_ref; } 
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_FXMat4d,0); return vresult; }
static VALUE _wrap_FXMat4d_xrot__SWIG_1(int argc, VALUE *argv, VALUE self) { FXMat4d *arg1 = (FXMat4d *) 0 ; FXdouble arg2 ;
    FXMat4d *result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMat4d, 1); arg2 = (FXdouble) NUM2DBL(argv[0]); {
        FXMat4d &_result_ref = (arg1)->xrot(arg2); result = (FXMat4d *) &_result_ref; } 
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_FXMat4d,0); return vresult; }
static VALUE _wrap_FXMat4d_xrot(int nargs, VALUE *args, VALUE self) { int argc; VALUE argv[4]; int ii; argc = nargs + 1;
    argv[0] = self; for (ii = 1; (ii < argc) && (ii < 3); ii++) { argv[ii] = args[ii-1]; }  if (argc == 2) { int _v; {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXMat4d, 0) != -1)) ? 1 : 0; }
         if (_v) { { _v = ((TYPE(argv[1]) == T_FLOAT) || (TYPE(argv[1]) == T_FIXNUM) || (TYPE(argv[1]) == T_BIGNUM)) ? 1 : 0; } 
            if (_v) { return _wrap_FXMat4d_xrot__SWIG_1(nargs, args, self);}  }  }  if (argc == 3) { int _v; { void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXMat4d, 0) != -1)) ? 1 : 0; }
         if (_v) { { _v = ((TYPE(argv[1]) == T_FLOAT) || (TYPE(argv[1]) == T_FIXNUM) || (TYPE(argv[1]) == T_BIGNUM)) ? 1 : 0; } 
            if (_v) { {
                    _v = ((TYPE(argv[2]) == T_FLOAT) || (TYPE(argv[2]) == T_FIXNUM) || (TYPE(argv[2]) == T_BIGNUM)) ? 1 : 0; } 
                if (_v) { return _wrap_FXMat4d_xrot__SWIG_0(nargs, args, self);}  }  }  } 
    rb_raise(rb_eArgError, "No matching function for overloaded 'FXMat4d_xrot'"); return Qnil; }
static VALUE _wrap_FXMat4d_yrot__SWIG_0(int argc, VALUE *argv, VALUE self) { FXMat4d *arg1 = (FXMat4d *) 0 ; FXdouble arg2 ;
    FXdouble arg3 ; FXMat4d *result; VALUE vresult = Qnil; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMat4d, 1); arg2 = (FXdouble) NUM2DBL(argv[0]);
    arg3 = (FXdouble) NUM2DBL(argv[1]); { FXMat4d &_result_ref = (arg1)->yrot(arg2,arg3); result = (FXMat4d *) &_result_ref; } 
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_FXMat4d,0); return vresult; }
static VALUE _wrap_FXMat4d_yrot__SWIG_1(int argc, VALUE *argv, VALUE self) { FXMat4d *arg1 = (FXMat4d *) 0 ; FXdouble arg2 ;
    FXMat4d *result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMat4d, 1); arg2 = (FXdouble) NUM2DBL(argv[0]); {
        FXMat4d &_result_ref = (arg1)->yrot(arg2); result = (FXMat4d *) &_result_ref; } 
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_FXMat4d,0); return vresult; }
static VALUE _wrap_FXMat4d_yrot(int nargs, VALUE *args, VALUE self) { int argc; VALUE argv[4]; int ii; argc = nargs + 1;
    argv[0] = self; for (ii = 1; (ii < argc) && (ii < 3); ii++) { argv[ii] = args[ii-1]; }  if (argc == 2) { int _v; {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXMat4d, 0) != -1)) ? 1 : 0; }
         if (_v) { { _v = ((TYPE(argv[1]) == T_FLOAT) || (TYPE(argv[1]) == T_FIXNUM) || (TYPE(argv[1]) == T_BIGNUM)) ? 1 : 0; } 
            if (_v) { return _wrap_FXMat4d_yrot__SWIG_1(nargs, args, self);}  }  }  if (argc == 3) { int _v; { void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXMat4d, 0) != -1)) ? 1 : 0; }
         if (_v) { { _v = ((TYPE(argv[1]) == T_FLOAT) || (TYPE(argv[1]) == T_FIXNUM) || (TYPE(argv[1]) == T_BIGNUM)) ? 1 : 0; } 
            if (_v) { {
                    _v = ((TYPE(argv[2]) == T_FLOAT) || (TYPE(argv[2]) == T_FIXNUM) || (TYPE(argv[2]) == T_BIGNUM)) ? 1 : 0; } 
                if (_v) { return _wrap_FXMat4d_yrot__SWIG_0(nargs, args, self);}  }  }  } 
    rb_raise(rb_eArgError, "No matching function for overloaded 'FXMat4d_yrot'"); return Qnil; }
static VALUE _wrap_FXMat4d_zrot__SWIG_0(int argc, VALUE *argv, VALUE self) { FXMat4d *arg1 = (FXMat4d *) 0 ; FXdouble arg2 ;
    FXdouble arg3 ; FXMat4d *result; VALUE vresult = Qnil; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMat4d, 1); arg2 = (FXdouble) NUM2DBL(argv[0]);
    arg3 = (FXdouble) NUM2DBL(argv[1]); { FXMat4d &_result_ref = (arg1)->zrot(arg2,arg3); result = (FXMat4d *) &_result_ref; } 
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_FXMat4d,0); return vresult; }
static VALUE _wrap_FXMat4d_zrot__SWIG_1(int argc, VALUE *argv, VALUE self) { FXMat4d *arg1 = (FXMat4d *) 0 ; FXdouble arg2 ;
    FXMat4d *result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMat4d, 1); arg2 = (FXdouble) NUM2DBL(argv[0]); {
        FXMat4d &_result_ref = (arg1)->zrot(arg2); result = (FXMat4d *) &_result_ref; } 
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_FXMat4d,0); return vresult; }
static VALUE _wrap_FXMat4d_zrot(int nargs, VALUE *args, VALUE self) { int argc; VALUE argv[4]; int ii; argc = nargs + 1;
    argv[0] = self; for (ii = 1; (ii < argc) && (ii < 3); ii++) { argv[ii] = args[ii-1]; }  if (argc == 2) { int _v; {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXMat4d, 0) != -1)) ? 1 : 0; }
         if (_v) { { _v = ((TYPE(argv[1]) == T_FLOAT) || (TYPE(argv[1]) == T_FIXNUM) || (TYPE(argv[1]) == T_BIGNUM)) ? 1 : 0; } 
            if (_v) { return _wrap_FXMat4d_zrot__SWIG_1(nargs, args, self);}  }  }  if (argc == 3) { int _v; { void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXMat4d, 0) != -1)) ? 1 : 0; }
         if (_v) { { _v = ((TYPE(argv[1]) == T_FLOAT) || (TYPE(argv[1]) == T_FIXNUM) || (TYPE(argv[1]) == T_BIGNUM)) ? 1 : 0; } 
            if (_v) { {
                    _v = ((TYPE(argv[2]) == T_FLOAT) || (TYPE(argv[2]) == T_FIXNUM) || (TYPE(argv[2]) == T_BIGNUM)) ? 1 : 0; } 
                if (_v) { return _wrap_FXMat4d_zrot__SWIG_0(nargs, args, self);}  }  }  } 
    rb_raise(rb_eArgError, "No matching function for overloaded 'FXMat4d_zrot'"); return Qnil; }
static VALUE _wrap_FXMat4d_look(int argc, VALUE *argv, VALUE self) { FXMat4d *arg1 = (FXMat4d *) 0 ; FXVec3d *arg2 = 0 ;
    FXVec3d *arg3 = 0 ; FXVec3d *arg4 = 0 ; FXMat4d *result; VALUE vresult = Qnil; if ((argc < 3) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMat4d, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXVec3d, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    SWIG_ConvertPtr(argv[1], (void **) &arg3, SWIGTYPE_p_FXVec3d, 1); if (arg3 == NULL) rb_raise(rb_eTypeError, "null reference");
    SWIG_ConvertPtr(argv[2], (void **) &arg4, SWIGTYPE_p_FXVec3d, 1); if (arg4 == NULL) rb_raise(rb_eTypeError, "null reference");
    { FXMat4d &_result_ref = (arg1)->look((FXVec3d const &)*arg2,(FXVec3d const &)*arg3,(FXVec3d const &)*arg4);
        result = (FXMat4d *) &_result_ref; }  vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_FXMat4d,0);
    return vresult; }
static VALUE _wrap_FXMat4d_trans__SWIG_0(int argc, VALUE *argv, VALUE self) { FXMat4d *arg1 = (FXMat4d *) 0 ; FXdouble arg2 ;
    FXdouble arg3 ; FXdouble arg4 ; FXMat4d *result; VALUE vresult = Qnil; if ((argc < 3) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMat4d, 1); arg2 = (FXdouble) NUM2DBL(argv[0]);
    arg3 = (FXdouble) NUM2DBL(argv[1]); arg4 = (FXdouble) NUM2DBL(argv[2]); {
        FXMat4d &_result_ref = (arg1)->trans(arg2,arg3,arg4); result = (FXMat4d *) &_result_ref; } 
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_FXMat4d,0); return vresult; }
static VALUE _wrap_FXMat4d_trans__SWIG_1(int argc, VALUE *argv, VALUE self) { FXMat4d *arg1 = (FXMat4d *) 0 ;
    FXVec3d *arg2 = 0 ; FXMat4d *result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMat4d, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXVec3d, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    { FXMat4d &_result_ref = (arg1)->trans((FXVec3d const &)*arg2); result = (FXMat4d *) &_result_ref; } 
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_FXMat4d,0); return vresult; }
static VALUE _wrap_FXMat4d_trans(int nargs, VALUE *args, VALUE self) { int argc; VALUE argv[5]; int ii; argc = nargs + 1;
    argv[0] = self; for (ii = 1; (ii < argc) && (ii < 4); ii++) { argv[ii] = args[ii-1]; }  if (argc == 2) { int _v; {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXMat4d, 0) != -1)) ? 1 : 0; }
         if (_v) { { void *ptr;
                _v = (NIL_P(argv[1]) || (TYPE(argv[1]) == T_DATA && SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_FXVec3d, 0) != -1)) ? 1 : 0; }
             if (_v) { return _wrap_FXMat4d_trans__SWIG_1(nargs, args, self);}  }  }  if (argc == 4) { int _v; { void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXMat4d, 0) != -1)) ? 1 : 0; }
         if (_v) { { _v = ((TYPE(argv[1]) == T_FLOAT) || (TYPE(argv[1]) == T_FIXNUM) || (TYPE(argv[1]) == T_BIGNUM)) ? 1 : 0; } 
            if (_v) { {
                    _v = ((TYPE(argv[2]) == T_FLOAT) || (TYPE(argv[2]) == T_FIXNUM) || (TYPE(argv[2]) == T_BIGNUM)) ? 1 : 0; } 
                if (_v) { {
                        _v = ((TYPE(argv[3]) == T_FLOAT) || (TYPE(argv[3]) == T_FIXNUM) || (TYPE(argv[3]) == T_BIGNUM)) ? 1 : 0; }
                     if (_v) { return _wrap_FXMat4d_trans__SWIG_0(nargs, args, self);}  }  }  }  } 
    rb_raise(rb_eArgError, "No matching function for overloaded 'FXMat4d_trans'"); return Qnil; }
static VALUE _wrap_FXMat4d_scale__SWIG_0(int argc, VALUE *argv, VALUE self) { FXMat4d *arg1 = (FXMat4d *) 0 ; FXdouble arg2 ;
    FXdouble arg3 ; FXdouble arg4 ; FXMat4d *result; VALUE vresult = Qnil; if ((argc < 3) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMat4d, 1); arg2 = (FXdouble) NUM2DBL(argv[0]);
    arg3 = (FXdouble) NUM2DBL(argv[1]); arg4 = (FXdouble) NUM2DBL(argv[2]); {
        FXMat4d &_result_ref = (arg1)->scale(arg2,arg3,arg4); result = (FXMat4d *) &_result_ref; } 
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_FXMat4d,0); return vresult; }
static VALUE _wrap_FXMat4d_scale__SWIG_1(int argc, VALUE *argv, VALUE self) { FXMat4d *arg1 = (FXMat4d *) 0 ; FXdouble arg2 ;
    FXMat4d *result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMat4d, 1); arg2 = (FXdouble) NUM2DBL(argv[0]); {
        FXMat4d &_result_ref = (arg1)->scale(arg2); result = (FXMat4d *) &_result_ref; } 
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_FXMat4d,0); return vresult; }
static VALUE _wrap_FXMat4d_scale__SWIG_2(int argc, VALUE *argv, VALUE self) { FXMat4d *arg1 = (FXMat4d *) 0 ;
    FXVec3d *arg2 = 0 ; FXMat4d *result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMat4d, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXVec3d, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    { FXMat4d &_result_ref = (arg1)->scale((FXVec3d const &)*arg2); result = (FXMat4d *) &_result_ref; } 
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_FXMat4d,0); return vresult; }
static VALUE _wrap_FXMat4d_scale(int nargs, VALUE *args, VALUE self) { int argc; VALUE argv[5]; int ii; argc = nargs + 1;
    argv[0] = self; for (ii = 1; (ii < argc) && (ii < 4); ii++) { argv[ii] = args[ii-1]; }  if (argc == 2) { int _v; {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXMat4d, 0) != -1)) ? 1 : 0; }
         if (_v) { { void *ptr;
                _v = (NIL_P(argv[1]) || (TYPE(argv[1]) == T_DATA && SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_FXVec3d, 0) != -1)) ? 1 : 0; }
             if (_v) { return _wrap_FXMat4d_scale__SWIG_2(nargs, args, self);}  }  }  if (argc == 2) { int _v; { void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXMat4d, 0) != -1)) ? 1 : 0; }
         if (_v) { { _v = ((TYPE(argv[1]) == T_FLOAT) || (TYPE(argv[1]) == T_FIXNUM) || (TYPE(argv[1]) == T_BIGNUM)) ? 1 : 0; } 
            if (_v) { return _wrap_FXMat4d_scale__SWIG_1(nargs, args, self);}  }  }  if (argc == 4) { int _v; { void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXMat4d, 0) != -1)) ? 1 : 0; }
         if (_v) { { _v = ((TYPE(argv[1]) == T_FLOAT) || (TYPE(argv[1]) == T_FIXNUM) || (TYPE(argv[1]) == T_BIGNUM)) ? 1 : 0; } 
            if (_v) { {
                    _v = ((TYPE(argv[2]) == T_FLOAT) || (TYPE(argv[2]) == T_FIXNUM) || (TYPE(argv[2]) == T_BIGNUM)) ? 1 : 0; } 
                if (_v) { {
                        _v = ((TYPE(argv[3]) == T_FLOAT) || (TYPE(argv[3]) == T_FIXNUM) || (TYPE(argv[3]) == T_BIGNUM)) ? 1 : 0; }
                     if (_v) { return _wrap_FXMat4d_scale__SWIG_0(nargs, args, self);}  }  }  }  } 
    rb_raise(rb_eArgError, "No matching function for overloaded 'FXMat4d_scale'"); return Qnil; }
static VALUE _wrap_FXMat4d_det(int argc, VALUE *argv, VALUE self) { FXMat4d *arg1 = (FXMat4d *) 0 ; FXdouble result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMat4d, 1); result = (FXdouble)FXMat4d_det((FXMat4d const *)arg1);
    vresult = rb_float_new(result); return vresult; }
static VALUE _wrap_FXMat4d_transpose(int argc, VALUE *argv, VALUE self) { FXMat4d *arg1 = (FXMat4d *) 0 ; FXMat4d result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMat4d, 1); result = FXMat4d_transpose((FXMat4d const *)arg1); {
        FXMat4d * resultptr; resultptr = new FXMat4d((FXMat4d &)result);
        vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_FXMat4d, 1); }  return vresult; }
static VALUE _wrap_FXMat4d_invert(int argc, VALUE *argv, VALUE self) { FXMat4d *arg1 = (FXMat4d *) 0 ; FXMat4d result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMat4d, 1); result = FXMat4d_invert((FXMat4d const *)arg1); {
        FXMat4d * resultptr; resultptr = new FXMat4d((FXMat4d &)result);
        vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_FXMat4d, 1); }  return vresult; }
static VALUE _wrap_FXRangef_lower_set(int argc, VALUE *argv, VALUE self) { FXRangef *arg1 = (FXRangef *) 0 ;
    FXVec3f *arg2 = (FXVec3f *) 0 ; FXVec3f tmp2 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRangef, 1); { if (TYPE(argv[0]) == T_ARRAY) {
            tmp2 = FXVec3f(NUM2DBL(rb_ary_entry(argv[0], 0)), NUM2DBL(rb_ary_entry(argv[0], 1)), NUM2DBL(rb_ary_entry(argv[0], 2)));
            arg2 = &tmp2; }  else { SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXVec3f, 1); }  } 
    if (arg1) (arg1)->lower = *arg2; return Qnil; }
static VALUE _wrap_FXRangef_lower_get(int argc, VALUE *argv, VALUE self) { FXRangef *arg1 = (FXRangef *) 0 ; FXVec3f *result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRangef, 1); result = (FXVec3f *)& ((arg1)->lower);
    vresult = FXRbGetRubyObj(result, "FXVec3f *"); return vresult; }
static VALUE _wrap_FXRangef_upper_set(int argc, VALUE *argv, VALUE self) { FXRangef *arg1 = (FXRangef *) 0 ;
    FXVec3f *arg2 = (FXVec3f *) 0 ; FXVec3f tmp2 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRangef, 1); { if (TYPE(argv[0]) == T_ARRAY) {
            tmp2 = FXVec3f(NUM2DBL(rb_ary_entry(argv[0], 0)), NUM2DBL(rb_ary_entry(argv[0], 1)), NUM2DBL(rb_ary_entry(argv[0], 2)));
            arg2 = &tmp2; }  else { SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXVec3f, 1); }  } 
    if (arg1) (arg1)->upper = *arg2; return Qnil; }
static VALUE _wrap_FXRangef_upper_get(int argc, VALUE *argv, VALUE self) { FXRangef *arg1 = (FXRangef *) 0 ; FXVec3f *result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRangef, 1); result = (FXVec3f *)& ((arg1)->upper);
    vresult = FXRbGetRubyObj(result, "FXVec3f *"); return vresult; }
static VALUE _wrap_new_FXRangef__SWIG_0(int argc, VALUE *argv, VALUE self) { FXRangef *result; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc); { result = (FXRangef *)new FXRangef();
        DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result); if(rb_block_given_p()){ rb_yield(self); }  }  return self; }
static VALUE _wrap_new_FXRangef__SWIG_1(int argc, VALUE *argv, VALUE self) { FXRangef *arg1 = 0 ; FXRangef *result;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXRangef, 1); if (arg1 == NULL) rb_raise(rb_eTypeError, "null reference");
    { result = (FXRangef *)new FXRangef((FXRangef const &)*arg1); DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result);
        if(rb_block_given_p()){ rb_yield(self); }  }  return self; }
static VALUE _wrap_new_FXRangef__SWIG_2(int argc, VALUE *argv, VALUE self) { FXfloat arg1 ; FXfloat arg2 ; FXfloat arg3 ;
    FXfloat arg4 ; FXfloat arg5 ; FXfloat arg6 ; FXRangef *result; if ((argc < 6) || (argc > 6))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 6)",argc); arg1 = (FXfloat) NUM2DBL(argv[0]);
    arg2 = (FXfloat) NUM2DBL(argv[1]); arg3 = (FXfloat) NUM2DBL(argv[2]); arg4 = (FXfloat) NUM2DBL(argv[3]);
    arg5 = (FXfloat) NUM2DBL(argv[4]); arg6 = (FXfloat) NUM2DBL(argv[5]); {
        result = (FXRangef *)new FXRangef(arg1,arg2,arg3,arg4,arg5,arg6);
        DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result); if(rb_block_given_p()){ rb_yield(self); }  }  return self; }
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE _wrap_FXRangef_allocate(VALUE self) {
#else
     static VALUE _wrap_FXRangef_allocate(int argc, VALUE *argv, VALUE self) {
#endif
         VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_FXRangef);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
         return vresult; }
static VALUE _wrap_new_FXRangef__SWIG_3(int argc, VALUE *argv, VALUE self) { FXSpheref *arg1 = 0 ; FXRangef *result;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXSpheref, 1); if (arg1 == NULL) rb_raise(rb_eTypeError, "null reference");
    { result = (FXRangef *)new FXRangef((FXSpheref const &)*arg1); DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result);
        if(rb_block_given_p()){ rb_yield(self); }  }  return self; }
static VALUE _wrap_new_FXRangef(int nargs, VALUE *args, VALUE self) { int argc; VALUE argv[6]; int ii; argc = nargs;
    for (ii = 0; (ii < argc) && (ii < 6); ii++) { argv[ii] = args[ii]; }  if (argc == 0) {
        return _wrap_new_FXRangef__SWIG_0(nargs, args, self);}  if (argc == 1) { int _v; { void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXRangef, 0) != -1)) ? 1 : 0; }
         if (_v) { return _wrap_new_FXRangef__SWIG_1(nargs, args, self);}  }  if (argc == 1) { int _v; { void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXSpheref, 0) != -1)) ? 1 : 0; }
         if (_v) { return _wrap_new_FXRangef__SWIG_3(nargs, args, self);}  }  if (argc == 6) { int _v; {
            _v = ((TYPE(argv[0]) == T_FLOAT) || (TYPE(argv[0]) == T_FIXNUM) || (TYPE(argv[0]) == T_BIGNUM)) ? 1 : 0; } 
        if (_v) { { _v = ((TYPE(argv[1]) == T_FLOAT) || (TYPE(argv[1]) == T_FIXNUM) || (TYPE(argv[1]) == T_BIGNUM)) ? 1 : 0; } 
            if (_v) { {
                    _v = ((TYPE(argv[2]) == T_FLOAT) || (TYPE(argv[2]) == T_FIXNUM) || (TYPE(argv[2]) == T_BIGNUM)) ? 1 : 0; } 
                if (_v) { {
                        _v = ((TYPE(argv[3]) == T_FLOAT) || (TYPE(argv[3]) == T_FIXNUM) || (TYPE(argv[3]) == T_BIGNUM)) ? 1 : 0; }
                     if (_v) { {
                            _v = ((TYPE(argv[4]) == T_FLOAT) || (TYPE(argv[4]) == T_FIXNUM) || (TYPE(argv[4]) == T_BIGNUM)) ? 1 : 0; }
                         if (_v) { {
                                _v = ((TYPE(argv[5]) == T_FLOAT) || (TYPE(argv[5]) == T_FIXNUM) || (TYPE(argv[5]) == T_BIGNUM)) ? 1 : 0; }
                             if (_v) { return _wrap_new_FXRangef__SWIG_2(nargs, args, self);}  }  }  }  }  }  } 
    rb_raise(rb_eArgError, "No matching function for overloaded 'new_FXRangef'"); return Qnil; }
static VALUE _wrap_FXRangef___getitem__(int argc, VALUE *argv, VALUE self) { FXRangef *arg1 = (FXRangef *) 0 ; FXint arg2 ;
    FXVec3f *result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRangef, 1); arg2 = NUM2INT(argv[0]); {
        FXVec3f &_result_ref = FXRangef___getitem__(arg1,arg2); result = (FXVec3f *) &_result_ref; } 
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_FXVec3f,0); return vresult; }
static VALUE _wrap_FXRangef___setitem__(int argc, VALUE *argv, VALUE self) { FXRangef *arg1 = (FXRangef *) 0 ; FXint arg2 ;
    FXVec3f *arg3 = 0 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRangef, 1); arg2 = NUM2INT(argv[0]);
    SWIG_ConvertPtr(argv[1], (void **) &arg3, SWIGTYPE_p_FXVec3f, 1); if (arg3 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXRangef___setitem__(arg1,arg2,*arg3); return Qnil; }
static VALUE _wrap_FXRangef_width(int argc, VALUE *argv, VALUE self) { FXRangef *arg1 = (FXRangef *) 0 ; FXfloat result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRangef, 1); result = (FXfloat)((FXRangef const *)arg1)->width();
    vresult = rb_float_new(result); return vresult; }
static VALUE _wrap_FXRangef_height(int argc, VALUE *argv, VALUE self) { FXRangef *arg1 = (FXRangef *) 0 ; FXfloat result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRangef, 1); result = (FXfloat)((FXRangef const *)arg1)->height();
    vresult = rb_float_new(result); return vresult; }
static VALUE _wrap_FXRangef_depth(int argc, VALUE *argv, VALUE self) { FXRangef *arg1 = (FXRangef *) 0 ; FXfloat result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRangef, 1); result = (FXfloat)((FXRangef const *)arg1)->depth();
    vresult = rb_float_new(result); return vresult; }
static VALUE _wrap_FXRangef_longest(int argc, VALUE *argv, VALUE self) { FXRangef *arg1 = (FXRangef *) 0 ; FXfloat result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRangef, 1); result = (FXfloat)((FXRangef const *)arg1)->longest();
    vresult = rb_float_new(result); return vresult; }
static VALUE _wrap_FXRangef_shortest(int argc, VALUE *argv, VALUE self) { FXRangef *arg1 = (FXRangef *) 0 ; FXfloat result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRangef, 1); result = (FXfloat)((FXRangef const *)arg1)->shortest();
    vresult = rb_float_new(result); return vresult; }
static VALUE _wrap_FXRangef_diameter(int argc, VALUE *argv, VALUE self) { FXRangef *arg1 = (FXRangef *) 0 ; FXfloat result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRangef, 1); result = (FXfloat)((FXRangef const *)arg1)->diameter();
    vresult = rb_float_new(result); return vresult; }
static VALUE _wrap_FXRangef_diagonal(int argc, VALUE *argv, VALUE self) { FXRangef *arg1 = (FXRangef *) 0 ; FXVec3f result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRangef, 1); result = ((FXRangef const *)arg1)->diagonal(); {
        FXVec3f* resultptr = new FXVec3f(result); vresult = FXRbGetRubyObj(resultptr, "FXVec3f *"); }  return vresult; }
static VALUE _wrap_FXRangef_center(int argc, VALUE *argv, VALUE self) { FXRangef *arg1 = (FXRangef *) 0 ; FXVec3f result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRangef, 1); result = ((FXRangef const *)arg1)->center(); {
        FXVec3f* resultptr = new FXVec3f(result); vresult = FXRbGetRubyObj(resultptr, "FXVec3f *"); }  return vresult; }
static VALUE _wrap_FXRangef_emptyq___(int argc, VALUE *argv, VALUE self) { FXRangef *arg1 = (FXRangef *) 0 ; FXbool result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRangef, 1); result = (FXbool)((FXRangef const *)arg1)->empty();
    vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXRangef_containsq_____SWIG_0(int argc, VALUE *argv, VALUE self) { FXRangef *arg1 = (FXRangef *) 0 ;
    FXfloat arg2 ; FXfloat arg3 ; FXfloat arg4 ; FXbool result; VALUE vresult = Qnil; if ((argc < 3) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRangef, 1); arg2 = (FXfloat) NUM2DBL(argv[0]);
    arg3 = (FXfloat) NUM2DBL(argv[1]); arg4 = (FXfloat) NUM2DBL(argv[2]);
    result = (FXbool)((FXRangef const *)arg1)->contains(arg2,arg3,arg4); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXRangef_containsq_____SWIG_1(int argc, VALUE *argv, VALUE self) { FXRangef *arg1 = (FXRangef *) 0 ;
    FXVec3f *arg2 = 0 ; FXbool result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRangef, 1); { if (TYPE(argv[0]) == T_ARRAY) {
            arg2 = new FXVec3f(NUM2DBL(rb_ary_entry(argv[0], 0)), NUM2DBL(rb_ary_entry(argv[0], 1)), NUM2DBL(rb_ary_entry(argv[0], 2))); }
         else { FXVec3f *p; SWIG_ConvertPtr(argv[0], (void **)&p, SWIGTYPE_p_FXVec3f, 1); arg2 = new FXVec3f(*p); }  } 
    result = (FXbool)((FXRangef const *)arg1)->contains((FXVec3f const &)*arg2); vresult = result ? Qtrue : Qfalse; delete arg2;
    return vresult; }
static VALUE _wrap_FXRangef_containsq_____SWIG_2(int argc, VALUE *argv, VALUE self) { FXRangef *arg1 = (FXRangef *) 0 ;
    FXRangef *arg2 = 0 ; FXbool result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRangef, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXRangef, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    result = (FXbool)((FXRangef const *)arg1)->contains((FXRangef const &)*arg2); vresult = result ? Qtrue : Qfalse;
    return vresult; }
static VALUE _wrap_FXRangef_containsq_____SWIG_3(int argc, VALUE *argv, VALUE self) { FXRangef *arg1 = (FXRangef *) 0 ;
    FXSpheref *arg2 = 0 ; FXbool result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRangef, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXSpheref, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    result = (FXbool)((FXRangef const *)arg1)->contains((FXSpheref const &)*arg2); vresult = result ? Qtrue : Qfalse;
    return vresult; }
static VALUE _wrap_FXRangef_containsq___(int nargs, VALUE *args, VALUE self) { int argc; VALUE argv[5]; int ii;
    argc = nargs + 1; argv[0] = self; for (ii = 1; (ii < argc) && (ii < 4); ii++) { argv[ii] = args[ii-1]; }  if (argc == 2) {
        int _v; { void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXRangef, 0) != -1)) ? 1 : 0; }
         if (_v) { { void *ptr;
                _v = (NIL_P(argv[1]) || (TYPE(argv[1]) == T_DATA && SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_FXVec3f, 0) != -1)) ? 1 : 0; }
             if (_v) { return _wrap_FXRangef_containsq_____SWIG_1(nargs, args, self);}  }  }  if (argc == 2) { int _v; {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXRangef, 0) != -1)) ? 1 : 0; }
         if (_v) { { void *ptr;
                _v = (NIL_P(argv[1]) || (TYPE(argv[1]) == T_DATA && SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_FXRangef, 0) != -1)) ? 1 : 0; }
             if (_v) { return _wrap_FXRangef_containsq_____SWIG_2(nargs, args, self);}  }  }  if (argc == 2) { int _v; {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXRangef, 0) != -1)) ? 1 : 0; }
         if (_v) { { void *ptr;
                _v = (NIL_P(argv[1]) || (TYPE(argv[1]) == T_DATA && SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_FXSpheref, 0) != -1)) ? 1 : 0; }
             if (_v) { return _wrap_FXRangef_containsq_____SWIG_3(nargs, args, self);}  }  }  if (argc == 4) { int _v; {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXRangef, 0) != -1)) ? 1 : 0; }
         if (_v) { { _v = ((TYPE(argv[1]) == T_FLOAT) || (TYPE(argv[1]) == T_FIXNUM) || (TYPE(argv[1]) == T_BIGNUM)) ? 1 : 0; } 
            if (_v) { {
                    _v = ((TYPE(argv[2]) == T_FLOAT) || (TYPE(argv[2]) == T_FIXNUM) || (TYPE(argv[2]) == T_BIGNUM)) ? 1 : 0; } 
                if (_v) { {
                        _v = ((TYPE(argv[3]) == T_FLOAT) || (TYPE(argv[3]) == T_FIXNUM) || (TYPE(argv[3]) == T_BIGNUM)) ? 1 : 0; }
                     if (_v) { return _wrap_FXRangef_containsq_____SWIG_0(nargs, args, self);}  }  }  }  } 
    rb_raise(rb_eArgError, "No matching function for overloaded 'FXRangef_contains?'"); return Qnil; }
static VALUE _wrap_FXRangef_includeN_____SWIG_0(int argc, VALUE *argv, VALUE self) { FXRangef *arg1 = (FXRangef *) 0 ;
    FXfloat arg2 ; FXfloat arg3 ; FXfloat arg4 ; FXRangef *result; VALUE vresult = Qnil; if ((argc < 3) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRangef, 1); arg2 = (FXfloat) NUM2DBL(argv[0]);
    arg3 = (FXfloat) NUM2DBL(argv[1]); arg4 = (FXfloat) NUM2DBL(argv[2]); {
        FXRangef &_result_ref = (arg1)->include(arg2,arg3,arg4); result = (FXRangef *) &_result_ref; } 
    vresult = FXRbGetRubyObj(result, "FXRangef *"); return vresult; }
static VALUE _wrap_FXRangef_includeN_____SWIG_1(int argc, VALUE *argv, VALUE self) { FXRangef *arg1 = (FXRangef *) 0 ;
    FXVec3f *arg2 = 0 ; FXRangef *result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRangef, 1); { if (TYPE(argv[0]) == T_ARRAY) {
            arg2 = new FXVec3f(NUM2DBL(rb_ary_entry(argv[0], 0)), NUM2DBL(rb_ary_entry(argv[0], 1)), NUM2DBL(rb_ary_entry(argv[0], 2))); }
         else { FXVec3f *p; SWIG_ConvertPtr(argv[0], (void **)&p, SWIGTYPE_p_FXVec3f, 1); arg2 = new FXVec3f(*p); }  }  {
        FXRangef &_result_ref = (arg1)->include((FXVec3f const &)*arg2); result = (FXRangef *) &_result_ref; } 
    vresult = FXRbGetRubyObj(result, "FXRangef *"); delete arg2; return vresult; }
static VALUE _wrap_FXRangef_includeN_____SWIG_2(int argc, VALUE *argv, VALUE self) { FXRangef *arg1 = (FXRangef *) 0 ;
    FXRangef *arg2 = 0 ; FXRangef *result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRangef, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXRangef, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    { FXRangef &_result_ref = (arg1)->include((FXRangef const &)*arg2); result = (FXRangef *) &_result_ref; } 
    vresult = FXRbGetRubyObj(result, "FXRangef *"); return vresult; }
static VALUE _wrap_FXRangef_includeN_____SWIG_3(int argc, VALUE *argv, VALUE self) { FXRangef *arg1 = (FXRangef *) 0 ;
    FXSpheref *arg2 = 0 ; FXRangef *result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRangef, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXSpheref, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    { FXRangef &_result_ref = (arg1)->include((FXSpheref const &)*arg2); result = (FXRangef *) &_result_ref; } 
    vresult = FXRbGetRubyObj(result, "FXRangef *"); return vresult; }
static VALUE _wrap_FXRangef_includeN___(int nargs, VALUE *args, VALUE self) { int argc; VALUE argv[5]; int ii; argc = nargs + 1;
    argv[0] = self; for (ii = 1; (ii < argc) && (ii < 4); ii++) { argv[ii] = args[ii-1]; }  if (argc == 2) { int _v; {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXRangef, 0) != -1)) ? 1 : 0; }
         if (_v) { { void *ptr;
                _v = (NIL_P(argv[1]) || (TYPE(argv[1]) == T_DATA && SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_FXVec3f, 0) != -1)) ? 1 : 0; }
             if (_v) { return _wrap_FXRangef_includeN_____SWIG_1(nargs, args, self);}  }  }  if (argc == 2) { int _v; {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXRangef, 0) != -1)) ? 1 : 0; }
         if (_v) { { void *ptr;
                _v = (NIL_P(argv[1]) || (TYPE(argv[1]) == T_DATA && SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_FXRangef, 0) != -1)) ? 1 : 0; }
             if (_v) { return _wrap_FXRangef_includeN_____SWIG_2(nargs, args, self);}  }  }  if (argc == 2) { int _v; {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXRangef, 0) != -1)) ? 1 : 0; }
         if (_v) { { void *ptr;
                _v = (NIL_P(argv[1]) || (TYPE(argv[1]) == T_DATA && SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_FXSpheref, 0) != -1)) ? 1 : 0; }
             if (_v) { return _wrap_FXRangef_includeN_____SWIG_3(nargs, args, self);}  }  }  if (argc == 4) { int _v; {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXRangef, 0) != -1)) ? 1 : 0; }
         if (_v) { { _v = ((TYPE(argv[1]) == T_FLOAT) || (TYPE(argv[1]) == T_FIXNUM) || (TYPE(argv[1]) == T_BIGNUM)) ? 1 : 0; } 
            if (_v) { {
                    _v = ((TYPE(argv[2]) == T_FLOAT) || (TYPE(argv[2]) == T_FIXNUM) || (TYPE(argv[2]) == T_BIGNUM)) ? 1 : 0; } 
                if (_v) { {
                        _v = ((TYPE(argv[3]) == T_FLOAT) || (TYPE(argv[3]) == T_FIXNUM) || (TYPE(argv[3]) == T_BIGNUM)) ? 1 : 0; }
                     if (_v) { return _wrap_FXRangef_includeN_____SWIG_0(nargs, args, self);}  }  }  }  } 
    rb_raise(rb_eArgError, "No matching function for overloaded 'FXRangef_include!'"); return Qnil; }
static VALUE _wrap_FXRangef_intersect__SWIG_0(int argc, VALUE *argv, VALUE self) { FXRangef *arg1 = (FXRangef *) 0 ;
    FXVec4f *arg2 = 0 ; FXint result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRangef, 1); { if (TYPE(argv[0]) == T_ARRAY) {
            arg2 = new FXVec4f(NUM2DBL(rb_ary_entry(argv[0], 0)), NUM2DBL(rb_ary_entry(argv[0], 1)), NUM2DBL(rb_ary_entry(argv[0], 2)), NUM2DBL(rb_ary_entry(argv[0], 3))); }
         else { FXVec4f *p; SWIG_ConvertPtr(argv[0],(void **)&p,SWIGTYPE_p_FXVec4f,1); arg2 = new FXVec4f(*p); }  } 
    result = (FXint)((FXRangef const *)arg1)->intersect((FXVec4f const &)*arg2); vresult = INT2NUM(result); delete arg2;
    return vresult; }
static VALUE _wrap_FXRangef_intersect__SWIG_1(int argc, VALUE *argv, VALUE self) { FXRangef *arg1 = (FXRangef *) 0 ;
    FXVec3f *arg2 = 0 ; FXVec3f *arg3 = 0 ; FXbool result; VALUE vresult = Qnil; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRangef, 1); { if (TYPE(argv[0]) == T_ARRAY) {
            arg2 = new FXVec3f(NUM2DBL(rb_ary_entry(argv[0], 0)), NUM2DBL(rb_ary_entry(argv[0], 1)), NUM2DBL(rb_ary_entry(argv[0], 2))); }
         else { FXVec3f *p; SWIG_ConvertPtr(argv[0], (void **)&p, SWIGTYPE_p_FXVec3f, 1); arg2 = new FXVec3f(*p); }  }  {
        if (TYPE(argv[1]) == T_ARRAY) {
            arg3 = new FXVec3f(NUM2DBL(rb_ary_entry(argv[1], 0)), NUM2DBL(rb_ary_entry(argv[1], 1)), NUM2DBL(rb_ary_entry(argv[1], 2))); }
         else { FXVec3f *p; SWIG_ConvertPtr(argv[1], (void **)&p, SWIGTYPE_p_FXVec3f, 1); arg3 = new FXVec3f(*p); }  } 
    result = (FXbool)(arg1)->intersect((FXVec3f const &)*arg2,(FXVec3f const &)*arg3); vresult = result ? Qtrue : Qfalse;
    delete arg2; delete arg3; return vresult; }
static VALUE _wrap_FXRangef_intersect(int nargs, VALUE *args, VALUE self) { int argc; VALUE argv[4]; int ii; argc = nargs + 1;
    argv[0] = self; for (ii = 1; (ii < argc) && (ii < 3); ii++) { argv[ii] = args[ii-1]; }  if (argc == 2) { int _v; {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXRangef, 0) != -1)) ? 1 : 0; }
         if (_v) { { void *ptr;
                _v = (NIL_P(argv[1]) || (TYPE(argv[1]) == T_DATA && SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_FXVec4f, 0) != -1)) ? 1 : 0; }
             if (_v) { return _wrap_FXRangef_intersect__SWIG_0(nargs, args, self);}  }  }  if (argc == 3) { int _v; { void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXRangef, 0) != -1)) ? 1 : 0; }
         if (_v) { { void *ptr;
                _v = (NIL_P(argv[1]) || (TYPE(argv[1]) == T_DATA && SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_FXVec3f, 0) != -1)) ? 1 : 0; }
             if (_v) { { void *ptr;
                    _v = (NIL_P(argv[2]) || (TYPE(argv[2]) == T_DATA && SWIG_ConvertPtr(argv[2], &ptr, SWIGTYPE_p_FXVec3f, 0) != -1)) ? 1 : 0; }
                 if (_v) { return _wrap_FXRangef_intersect__SWIG_1(nargs, args, self);}  }  }  } 
    rb_raise(rb_eArgError, "No matching function for overloaded 'FXRangef_intersect'"); return Qnil; }
static VALUE _wrap_FXRangef_overlapsq___(int argc, VALUE *argv, VALUE self) { FXRangef *arg1 = (FXRangef *) 0 ;
    FXRangef *arg2 = 0 ; FXbool result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRangef, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXRangef, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    result = (FXbool)FXRangef_overlaps((FXRangef const *)arg1,(FXRangef const &)*arg2); vresult = result ? Qtrue : Qfalse;
    return vresult; }
static VALUE _wrap_FXRangef_corner(int argc, VALUE *argv, VALUE self) { FXRangef *arg1 = (FXRangef *) 0 ; FXint arg2 ;
    FXVec3f result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRangef, 1); arg2 = NUM2INT(argv[0]);
    result = FXRangef_corner((FXRangef const *)arg1,arg2); { FXVec3f* resultptr = new FXVec3f(result);
        vresult = FXRbGetRubyObj(resultptr, "FXVec3f *"); }  return vresult; }
static VALUE _wrap_FXRangef_union(int argc, VALUE *argv, VALUE self) { FXRangef *arg1 = (FXRangef *) 0 ; FXRangef *arg2 = 0 ;
    FXRangef result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRangef, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXRangef, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    result = FXRangef_onion((FXRangef const *)arg1,(FXRangef const &)*arg2); { FXRangef* resultptr = new FXRangef(result);
        vresult = FXRbGetRubyObj(resultptr, "FXRangef *"); }  return vresult; }
static VALUE _wrap_FXRangef_intersection(int argc, VALUE *argv, VALUE self) { FXRangef *arg1 = (FXRangef *) 0 ;
    FXRangef *arg2 = 0 ; FXRangef result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRangef, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXRangef, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    result = FXRangef_intersection((FXRangef const *)arg1,(FXRangef const &)*arg2); {
        FXRangef* resultptr = new FXRangef(result); vresult = FXRbGetRubyObj(resultptr, "FXRangef *"); }  return vresult; }
static VALUE _wrap_FXRanged_lower_set(int argc, VALUE *argv, VALUE self) { FXRanged *arg1 = (FXRanged *) 0 ;
    FXVec3d *arg2 = (FXVec3d *) 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRanged, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXVec3d, 1); if (arg1) (arg1)->lower = *arg2; return Qnil; }
static VALUE _wrap_FXRanged_lower_get(int argc, VALUE *argv, VALUE self) { FXRanged *arg1 = (FXRanged *) 0 ; FXVec3d *result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRanged, 1); result = (FXVec3d *)& ((arg1)->lower);
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_FXVec3d,0); return vresult; }
static VALUE _wrap_FXRanged_upper_set(int argc, VALUE *argv, VALUE self) { FXRanged *arg1 = (FXRanged *) 0 ;
    FXVec3d *arg2 = (FXVec3d *) 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRanged, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXVec3d, 1); if (arg1) (arg1)->upper = *arg2; return Qnil; }
static VALUE _wrap_FXRanged_upper_get(int argc, VALUE *argv, VALUE self) { FXRanged *arg1 = (FXRanged *) 0 ; FXVec3d *result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRanged, 1); result = (FXVec3d *)& ((arg1)->upper);
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_FXVec3d,0); return vresult; }
static VALUE _wrap_new_FXRanged__SWIG_0(int argc, VALUE *argv, VALUE self) { FXRanged *result; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc); { result = (FXRanged *)new FXRanged();
        DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result); if(rb_block_given_p()){ rb_yield(self); }  }  return self; }
static VALUE _wrap_new_FXRanged__SWIG_1(int argc, VALUE *argv, VALUE self) { FXRanged *arg1 = 0 ; FXRanged *result;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXRanged, 1); if (arg1 == NULL) rb_raise(rb_eTypeError, "null reference");
    { result = (FXRanged *)new FXRanged((FXRanged const &)*arg1); DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result);
        if(rb_block_given_p()){ rb_yield(self); }  }  return self; }
static VALUE _wrap_new_FXRanged__SWIG_2(int argc, VALUE *argv, VALUE self) { FXdouble arg1 ; FXdouble arg2 ; FXdouble arg3 ;
    FXdouble arg4 ; FXdouble arg5 ; FXdouble arg6 ; FXRanged *result; if ((argc < 6) || (argc > 6))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 6)",argc); arg1 = (FXdouble) NUM2DBL(argv[0]);
    arg2 = (FXdouble) NUM2DBL(argv[1]); arg3 = (FXdouble) NUM2DBL(argv[2]); arg4 = (FXdouble) NUM2DBL(argv[3]);
    arg5 = (FXdouble) NUM2DBL(argv[4]); arg6 = (FXdouble) NUM2DBL(argv[5]); {
        result = (FXRanged *)new FXRanged(arg1,arg2,arg3,arg4,arg5,arg6);
        DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result); if(rb_block_given_p()){ rb_yield(self); }  }  return self; }
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE _wrap_FXRanged_allocate(VALUE self) {
#else
     static VALUE _wrap_FXRanged_allocate(int argc, VALUE *argv, VALUE self) {
#endif
         VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_FXRanged);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
         return vresult; }
static VALUE _wrap_new_FXRanged__SWIG_3(int argc, VALUE *argv, VALUE self) { FXSphered *arg1 = 0 ; FXRanged *result;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXSphered, 1); if (arg1 == NULL) rb_raise(rb_eTypeError, "null reference");
    { result = (FXRanged *)new FXRanged((FXSphered const &)*arg1); DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result);
        if(rb_block_given_p()){ rb_yield(self); }  }  return self; }
static VALUE _wrap_new_FXRanged(int nargs, VALUE *args, VALUE self) { int argc; VALUE argv[6]; int ii; argc = nargs;
    for (ii = 0; (ii < argc) && (ii < 6); ii++) { argv[ii] = args[ii]; }  if (argc == 0) {
        return _wrap_new_FXRanged__SWIG_0(nargs, args, self);}  if (argc == 1) { int _v; { void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXRanged, 0) != -1)) ? 1 : 0; }
         if (_v) { return _wrap_new_FXRanged__SWIG_1(nargs, args, self);}  }  if (argc == 1) { int _v; { void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXSphered, 0) != -1)) ? 1 : 0; }
         if (_v) { return _wrap_new_FXRanged__SWIG_3(nargs, args, self);}  }  if (argc == 6) { int _v; {
            _v = ((TYPE(argv[0]) == T_FLOAT) || (TYPE(argv[0]) == T_FIXNUM) || (TYPE(argv[0]) == T_BIGNUM)) ? 1 : 0; } 
        if (_v) { { _v = ((TYPE(argv[1]) == T_FLOAT) || (TYPE(argv[1]) == T_FIXNUM) || (TYPE(argv[1]) == T_BIGNUM)) ? 1 : 0; } 
            if (_v) { {
                    _v = ((TYPE(argv[2]) == T_FLOAT) || (TYPE(argv[2]) == T_FIXNUM) || (TYPE(argv[2]) == T_BIGNUM)) ? 1 : 0; } 
                if (_v) { {
                        _v = ((TYPE(argv[3]) == T_FLOAT) || (TYPE(argv[3]) == T_FIXNUM) || (TYPE(argv[3]) == T_BIGNUM)) ? 1 : 0; }
                     if (_v) { {
                            _v = ((TYPE(argv[4]) == T_FLOAT) || (TYPE(argv[4]) == T_FIXNUM) || (TYPE(argv[4]) == T_BIGNUM)) ? 1 : 0; }
                         if (_v) { {
                                _v = ((TYPE(argv[5]) == T_FLOAT) || (TYPE(argv[5]) == T_FIXNUM) || (TYPE(argv[5]) == T_BIGNUM)) ? 1 : 0; }
                             if (_v) { return _wrap_new_FXRanged__SWIG_2(nargs, args, self);}  }  }  }  }  }  } 
    rb_raise(rb_eArgError, "No matching function for overloaded 'new_FXRanged'"); return Qnil; }
static VALUE _wrap_FXRanged___getitem__(int argc, VALUE *argv, VALUE self) { FXRanged *arg1 = (FXRanged *) 0 ; FXint arg2 ;
    FXVec3d *result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRanged, 1); arg2 = NUM2INT(argv[0]); {
        FXVec3d &_result_ref = FXRanged___getitem__(arg1,arg2); result = (FXVec3d *) &_result_ref; } 
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_FXVec3d,0); return vresult; }
static VALUE _wrap_FXRanged___setitem__(int argc, VALUE *argv, VALUE self) { FXRanged *arg1 = (FXRanged *) 0 ; FXint arg2 ;
    FXVec3d *arg3 = 0 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRanged, 1); arg2 = NUM2INT(argv[0]);
    SWIG_ConvertPtr(argv[1], (void **) &arg3, SWIGTYPE_p_FXVec3d, 1); if (arg3 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXRanged___setitem__(arg1,arg2,*arg3); return Qnil; }
static VALUE _wrap_FXRanged_width(int argc, VALUE *argv, VALUE self) { FXRanged *arg1 = (FXRanged *) 0 ; FXdouble result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRanged, 1); result = (FXdouble)((FXRanged const *)arg1)->width();
    vresult = rb_float_new(result); return vresult; }
static VALUE _wrap_FXRanged_height(int argc, VALUE *argv, VALUE self) { FXRanged *arg1 = (FXRanged *) 0 ; FXdouble result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRanged, 1); result = (FXdouble)((FXRanged const *)arg1)->height();
    vresult = rb_float_new(result); return vresult; }
static VALUE _wrap_FXRanged_depth(int argc, VALUE *argv, VALUE self) { FXRanged *arg1 = (FXRanged *) 0 ; FXdouble result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRanged, 1); result = (FXdouble)((FXRanged const *)arg1)->depth();
    vresult = rb_float_new(result); return vresult; }
static VALUE _wrap_FXRanged_longest(int argc, VALUE *argv, VALUE self) { FXRanged *arg1 = (FXRanged *) 0 ; FXdouble result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRanged, 1); result = (FXdouble)((FXRanged const *)arg1)->longest();
    vresult = rb_float_new(result); return vresult; }
static VALUE _wrap_FXRanged_shortest(int argc, VALUE *argv, VALUE self) { FXRanged *arg1 = (FXRanged *) 0 ; FXdouble result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRanged, 1); result = (FXdouble)((FXRanged const *)arg1)->shortest();
    vresult = rb_float_new(result); return vresult; }
static VALUE _wrap_FXRanged_diameter(int argc, VALUE *argv, VALUE self) { FXRanged *arg1 = (FXRanged *) 0 ; FXdouble result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRanged, 1); result = (FXdouble)((FXRanged const *)arg1)->diameter();
    vresult = rb_float_new(result); return vresult; }
static VALUE _wrap_FXRanged_diagonal(int argc, VALUE *argv, VALUE self) { FXRanged *arg1 = (FXRanged *) 0 ; FXVec3d result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRanged, 1); result = ((FXRanged const *)arg1)->diagonal(); {
        FXVec3d * resultptr; resultptr = new FXVec3d((FXVec3d &)result);
        vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_FXVec3d, 1); }  return vresult; }
static VALUE _wrap_FXRanged_center(int argc, VALUE *argv, VALUE self) { FXRanged *arg1 = (FXRanged *) 0 ; FXVec3d result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRanged, 1); result = ((FXRanged const *)arg1)->center(); {
        FXVec3d * resultptr; resultptr = new FXVec3d((FXVec3d &)result);
        vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_FXVec3d, 1); }  return vresult; }
static VALUE _wrap_FXRanged_emptyq___(int argc, VALUE *argv, VALUE self) { FXRanged *arg1 = (FXRanged *) 0 ; FXbool result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRanged, 1); result = (FXbool)((FXRanged const *)arg1)->empty();
    vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXRanged_contains(int argc, VALUE *argv, VALUE self) { FXRanged *arg1 = (FXRanged *) 0 ; FXdouble arg2 ;
    FXdouble arg3 ; FXdouble arg4 ; FXbool result; VALUE vresult = Qnil; if ((argc < 3) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRanged, 1); arg2 = (FXdouble) NUM2DBL(argv[0]);
    arg3 = (FXdouble) NUM2DBL(argv[1]); arg4 = (FXdouble) NUM2DBL(argv[2]);
    result = (FXbool)((FXRanged const *)arg1)->contains(arg2,arg3,arg4); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXRanged_containsq_____SWIG_0(int argc, VALUE *argv, VALUE self) { FXRanged *arg1 = (FXRanged *) 0 ;
    FXVec3d *arg2 = 0 ; FXbool result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRanged, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXVec3d, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    result = (FXbool)((FXRanged const *)arg1)->contains((FXVec3d const &)*arg2); vresult = result ? Qtrue : Qfalse;
    return vresult; }
static VALUE _wrap_FXRanged_containsq_____SWIG_1(int argc, VALUE *argv, VALUE self) { FXRanged *arg1 = (FXRanged *) 0 ;
    FXRanged *arg2 = 0 ; FXbool result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRanged, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXRanged, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    result = (FXbool)((FXRanged const *)arg1)->contains((FXRanged const &)*arg2); vresult = result ? Qtrue : Qfalse;
    return vresult; }
static VALUE _wrap_FXRanged_containsq_____SWIG_2(int argc, VALUE *argv, VALUE self) { FXRanged *arg1 = (FXRanged *) 0 ;
    FXSphered *arg2 = 0 ; FXbool result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRanged, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXSphered, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    result = (FXbool)((FXRanged const *)arg1)->contains((FXSphered const &)*arg2); vresult = result ? Qtrue : Qfalse;
    return vresult; }
static VALUE _wrap_FXRanged_containsq___(int nargs, VALUE *args, VALUE self) { int argc; VALUE argv[3]; int ii;
    argc = nargs + 1; argv[0] = self; for (ii = 1; (ii < argc) && (ii < 2); ii++) { argv[ii] = args[ii-1]; }  if (argc == 2) {
        int _v; { void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXRanged, 0) != -1)) ? 1 : 0; }
         if (_v) { { void *ptr;
                _v = (NIL_P(argv[1]) || (TYPE(argv[1]) == T_DATA && SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_FXVec3d, 0) != -1)) ? 1 : 0; }
             if (_v) { return _wrap_FXRanged_containsq_____SWIG_0(nargs, args, self);}  }  }  if (argc == 2) { int _v; {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXRanged, 0) != -1)) ? 1 : 0; }
         if (_v) { { void *ptr;
                _v = (NIL_P(argv[1]) || (TYPE(argv[1]) == T_DATA && SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_FXRanged, 0) != -1)) ? 1 : 0; }
             if (_v) { return _wrap_FXRanged_containsq_____SWIG_1(nargs, args, self);}  }  }  if (argc == 2) { int _v; {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXRanged, 0) != -1)) ? 1 : 0; }
         if (_v) { { void *ptr;
                _v = (NIL_P(argv[1]) || (TYPE(argv[1]) == T_DATA && SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_FXSphered, 0) != -1)) ? 1 : 0; }
             if (_v) { return _wrap_FXRanged_containsq_____SWIG_2(nargs, args, self);}  }  } 
    rb_raise(rb_eArgError, "No matching function for overloaded 'FXRanged_contains?'"); return Qnil; }
static VALUE _wrap_FXRanged_include__SWIG_0(int argc, VALUE *argv, VALUE self) { FXRanged *arg1 = (FXRanged *) 0 ;
    FXdouble arg2 ; FXdouble arg3 ; FXdouble arg4 ; FXRanged *result; VALUE vresult = Qnil; if ((argc < 3) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRanged, 1); arg2 = (FXdouble) NUM2DBL(argv[0]);
    arg3 = (FXdouble) NUM2DBL(argv[1]); arg4 = (FXdouble) NUM2DBL(argv[2]); {
        FXRanged &_result_ref = (arg1)->include(arg2,arg3,arg4); result = (FXRanged *) &_result_ref; } 
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_FXRanged,0); return vresult; }
static VALUE _wrap_FXRanged_include__SWIG_1(int argc, VALUE *argv, VALUE self) { FXRanged *arg1 = (FXRanged *) 0 ;
    FXVec3d *arg2 = 0 ; FXRanged *result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRanged, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXVec3d, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    { FXRanged &_result_ref = (arg1)->include((FXVec3d const &)*arg2); result = (FXRanged *) &_result_ref; } 
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_FXRanged,0); return vresult; }
static VALUE _wrap_FXRanged_include__SWIG_2(int argc, VALUE *argv, VALUE self) { FXRanged *arg1 = (FXRanged *) 0 ;
    FXRanged *arg2 = 0 ; FXRanged *result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRanged, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXRanged, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    { FXRanged &_result_ref = (arg1)->include((FXRanged const &)*arg2); result = (FXRanged *) &_result_ref; } 
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_FXRanged,0); return vresult; }
static VALUE _wrap_FXRanged_include__SWIG_3(int argc, VALUE *argv, VALUE self) { FXRanged *arg1 = (FXRanged *) 0 ;
    FXSphered *arg2 = 0 ; FXRanged *result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRanged, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXSphered, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    { FXRanged &_result_ref = (arg1)->include((FXSphered const &)*arg2); result = (FXRanged *) &_result_ref; } 
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_FXRanged,0); return vresult; }
static VALUE _wrap_FXRanged_include(int nargs, VALUE *args, VALUE self) { int argc; VALUE argv[5]; int ii; argc = nargs + 1;
    argv[0] = self; for (ii = 1; (ii < argc) && (ii < 4); ii++) { argv[ii] = args[ii-1]; }  if (argc == 2) { int _v; {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXRanged, 0) != -1)) ? 1 : 0; }
         if (_v) { { void *ptr;
                _v = (NIL_P(argv[1]) || (TYPE(argv[1]) == T_DATA && SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_FXVec3d, 0) != -1)) ? 1 : 0; }
             if (_v) { return _wrap_FXRanged_include__SWIG_1(nargs, args, self);}  }  }  if (argc == 2) { int _v; { void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXRanged, 0) != -1)) ? 1 : 0; }
         if (_v) { { void *ptr;
                _v = (NIL_P(argv[1]) || (TYPE(argv[1]) == T_DATA && SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_FXRanged, 0) != -1)) ? 1 : 0; }
             if (_v) { return _wrap_FXRanged_include__SWIG_2(nargs, args, self);}  }  }  if (argc == 2) { int _v; { void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXRanged, 0) != -1)) ? 1 : 0; }
         if (_v) { { void *ptr;
                _v = (NIL_P(argv[1]) || (TYPE(argv[1]) == T_DATA && SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_FXSphered, 0) != -1)) ? 1 : 0; }
             if (_v) { return _wrap_FXRanged_include__SWIG_3(nargs, args, self);}  }  }  if (argc == 4) { int _v; { void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXRanged, 0) != -1)) ? 1 : 0; }
         if (_v) { { _v = ((TYPE(argv[1]) == T_FLOAT) || (TYPE(argv[1]) == T_FIXNUM) || (TYPE(argv[1]) == T_BIGNUM)) ? 1 : 0; } 
            if (_v) { {
                    _v = ((TYPE(argv[2]) == T_FLOAT) || (TYPE(argv[2]) == T_FIXNUM) || (TYPE(argv[2]) == T_BIGNUM)) ? 1 : 0; } 
                if (_v) { {
                        _v = ((TYPE(argv[3]) == T_FLOAT) || (TYPE(argv[3]) == T_FIXNUM) || (TYPE(argv[3]) == T_BIGNUM)) ? 1 : 0; }
                     if (_v) { return _wrap_FXRanged_include__SWIG_0(nargs, args, self);}  }  }  }  } 
    rb_raise(rb_eArgError, "No matching function for overloaded 'FXRanged_include'"); return Qnil; }
static VALUE _wrap_FXRanged_intersect__SWIG_0(int argc, VALUE *argv, VALUE self) { FXRanged *arg1 = (FXRanged *) 0 ;
    FXVec4d *arg2 = 0 ; FXint result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRanged, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXVec4d, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    result = (FXint)((FXRanged const *)arg1)->intersect((FXVec4d const &)*arg2); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXRanged_intersect__SWIG_1(int argc, VALUE *argv, VALUE self) { FXRanged *arg1 = (FXRanged *) 0 ;
    FXVec3d *arg2 = 0 ; FXVec3d *arg3 = 0 ; FXbool result; VALUE vresult = Qnil; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRanged, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXVec3d, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    SWIG_ConvertPtr(argv[1], (void **) &arg3, SWIGTYPE_p_FXVec3d, 1); if (arg3 == NULL) rb_raise(rb_eTypeError, "null reference");
    result = (FXbool)(arg1)->intersect((FXVec3d const &)*arg2,(FXVec3d const &)*arg3); vresult = result ? Qtrue : Qfalse;
    return vresult; }
static VALUE _wrap_FXRanged_intersect(int nargs, VALUE *args, VALUE self) { int argc; VALUE argv[4]; int ii; argc = nargs + 1;
    argv[0] = self; for (ii = 1; (ii < argc) && (ii < 3); ii++) { argv[ii] = args[ii-1]; }  if (argc == 2) { int _v; {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXRanged, 0) != -1)) ? 1 : 0; }
         if (_v) { { void *ptr;
                _v = (NIL_P(argv[1]) || (TYPE(argv[1]) == T_DATA && SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_FXVec4d, 0) != -1)) ? 1 : 0; }
             if (_v) { return _wrap_FXRanged_intersect__SWIG_0(nargs, args, self);}  }  }  if (argc == 3) { int _v; { void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXRanged, 0) != -1)) ? 1 : 0; }
         if (_v) { { void *ptr;
                _v = (NIL_P(argv[1]) || (TYPE(argv[1]) == T_DATA && SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_FXVec3d, 0) != -1)) ? 1 : 0; }
             if (_v) { { void *ptr;
                    _v = (NIL_P(argv[2]) || (TYPE(argv[2]) == T_DATA && SWIG_ConvertPtr(argv[2], &ptr, SWIGTYPE_p_FXVec3d, 0) != -1)) ? 1 : 0; }
                 if (_v) { return _wrap_FXRanged_intersect__SWIG_1(nargs, args, self);}  }  }  } 
    rb_raise(rb_eArgError, "No matching function for overloaded 'FXRanged_intersect'"); return Qnil; }
static VALUE _wrap_FXRanged_overlapsq___(int argc, VALUE *argv, VALUE self) { FXRanged *arg1 = (FXRanged *) 0 ;
    FXRanged *arg2 = 0 ; FXbool result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRanged, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXRanged, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    result = (FXbool)FXRanged_overlaps((FXRanged const *)arg1,(FXRanged const &)*arg2); vresult = result ? Qtrue : Qfalse;
    return vresult; }
static VALUE _wrap_FXRanged_corner(int argc, VALUE *argv, VALUE self) { FXRanged *arg1 = (FXRanged *) 0 ; FXint arg2 ;
    FXVec3d result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRanged, 1); arg2 = NUM2INT(argv[0]);
    result = FXRanged_corner((FXRanged const *)arg1,arg2); { FXVec3d * resultptr; resultptr = new FXVec3d((FXVec3d &)result);
        vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_FXVec3d, 1); }  return vresult; }
static VALUE _wrap_FXRanged_union(int argc, VALUE *argv, VALUE self) { FXRanged *arg1 = (FXRanged *) 0 ; FXRanged *arg2 = 0 ;
    FXRanged result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRanged, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXRanged, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    result = FXRanged_onion((FXRanged const *)arg1,(FXRanged const &)*arg2); { FXRanged * resultptr;
        resultptr = new FXRanged((FXRanged &)result); vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_FXRanged, 1); }
     return vresult; }
static VALUE _wrap_FXRanged_intersection(int argc, VALUE *argv, VALUE self) { FXRanged *arg1 = (FXRanged *) 0 ;
    FXRanged *arg2 = 0 ; FXRanged result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRanged, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXRanged, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    result = FXRanged_intersection((FXRanged const *)arg1,(FXRanged const &)*arg2); { FXRanged * resultptr;
        resultptr = new FXRanged((FXRanged &)result); vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_FXRanged, 1); }
     return vresult; }
static VALUE _wrap_FXSpheref_center_set(int argc, VALUE *argv, VALUE self) { FXSpheref *arg1 = (FXSpheref *) 0 ;
    FXVec3f *arg2 = (FXVec3f *) 0 ; FXVec3f tmp2 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSpheref, 1); { if (TYPE(argv[0]) == T_ARRAY) {
            tmp2 = FXVec3f(NUM2DBL(rb_ary_entry(argv[0], 0)), NUM2DBL(rb_ary_entry(argv[0], 1)), NUM2DBL(rb_ary_entry(argv[0], 2)));
            arg2 = &tmp2; }  else { SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXVec3f, 1); }  } 
    if (arg1) (arg1)->center = *arg2; return Qnil; }
static VALUE _wrap_FXSpheref_center_get(int argc, VALUE *argv, VALUE self) { FXSpheref *arg1 = (FXSpheref *) 0 ;
    FXVec3f *result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSpheref, 1); result = (FXVec3f *)& ((arg1)->center);
    vresult = FXRbGetRubyObj(result, "FXVec3f *"); return vresult; }
static VALUE _wrap_FXSpheref_radius_set(int argc, VALUE *argv, VALUE self) { FXSpheref *arg1 = (FXSpheref *) 0 ; FXfloat arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSpheref, 1); arg2 = (FXfloat) NUM2DBL(argv[0]);
    if (arg1) (arg1)->radius = arg2; return Qnil; }
static VALUE _wrap_FXSpheref_radius_get(int argc, VALUE *argv, VALUE self) { FXSpheref *arg1 = (FXSpheref *) 0 ; FXfloat result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSpheref, 1); result = (FXfloat) ((arg1)->radius);
    vresult = rb_float_new(result); return vresult; }
static VALUE _wrap_new_FXSpheref__SWIG_0(int argc, VALUE *argv, VALUE self) { FXSpheref *result; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc); result = (FXSpheref *)new FXSpheref();
    DATA_PTR(self) = result; return self; }
static VALUE _wrap_new_FXSpheref__SWIG_1(int argc, VALUE *argv, VALUE self) { FXSpheref *arg1 = 0 ; FXSpheref *result;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXSpheref, 1); if (arg1 == NULL) rb_raise(rb_eTypeError, "null reference");
    result = (FXSpheref *)new FXSpheref((FXSpheref const &)*arg1); DATA_PTR(self) = result; return self; }
static VALUE _wrap_new_FXSpheref__SWIG_2(int argc, VALUE *argv, VALUE self) { FXVec3f *arg1 = 0 ; FXfloat arg2 ;
    FXSpheref *result; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc); {
        if (TYPE(argv[0]) == T_ARRAY) {
            arg1 = new FXVec3f(NUM2DBL(rb_ary_entry(argv[0], 0)), NUM2DBL(rb_ary_entry(argv[0], 1)), NUM2DBL(rb_ary_entry(argv[0], 2))); }
         else { FXVec3f *p; SWIG_ConvertPtr(argv[0], (void **)&p, SWIGTYPE_p_FXVec3f, 1); arg1 = new FXVec3f(*p); }  } 
    arg2 = (FXfloat) NUM2DBL(argv[1]); result = (FXSpheref *)new FXSpheref((FXVec3f const &)*arg1,arg2);
    DATA_PTR(self) = result; delete arg1; return self; }
static VALUE _wrap_new_FXSpheref__SWIG_3(int argc, VALUE *argv, VALUE self) { FXfloat arg1 ; FXfloat arg2 ; FXfloat arg3 ;
    FXfloat arg4 ; FXSpheref *result; if ((argc < 4) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc); arg1 = (FXfloat) NUM2DBL(argv[0]);
    arg2 = (FXfloat) NUM2DBL(argv[1]); arg3 = (FXfloat) NUM2DBL(argv[2]); arg4 = (FXfloat) NUM2DBL(argv[3]);
    result = (FXSpheref *)new FXSpheref(arg1,arg2,arg3,arg4); DATA_PTR(self) = result; return self; }
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE _wrap_FXSpheref_allocate(VALUE self) {
#else
     static VALUE _wrap_FXSpheref_allocate(int argc, VALUE *argv, VALUE self) {
#endif
         VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_FXSpheref);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
         return vresult; }
static VALUE _wrap_new_FXSpheref__SWIG_4(int argc, VALUE *argv, VALUE self) { FXRangef *arg1 = 0 ; FXSpheref *result;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXRangef, 1); if (arg1 == NULL) rb_raise(rb_eTypeError, "null reference");
    result = (FXSpheref *)new FXSpheref((FXRangef const &)*arg1); DATA_PTR(self) = result; return self; }
static VALUE _wrap_new_FXSpheref(int nargs, VALUE *args, VALUE self) { int argc; VALUE argv[4]; int ii; argc = nargs;
    for (ii = 0; (ii < argc) && (ii < 4); ii++) { argv[ii] = args[ii]; }  if (argc == 0) {
        return _wrap_new_FXSpheref__SWIG_0(nargs, args, self);}  if (argc == 1) { int _v; { void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXSpheref, 0) != -1)) ? 1 : 0; }
         if (_v) { return _wrap_new_FXSpheref__SWIG_1(nargs, args, self);}  }  if (argc == 1) { int _v; { void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXRangef, 0) != -1)) ? 1 : 0; }
         if (_v) { return _wrap_new_FXSpheref__SWIG_4(nargs, args, self);}  }  if (argc == 2) { int _v; { void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXVec3f, 0) != -1)) ? 1 : 0; }
         if (_v) { { _v = ((TYPE(argv[1]) == T_FLOAT) || (TYPE(argv[1]) == T_FIXNUM) || (TYPE(argv[1]) == T_BIGNUM)) ? 1 : 0; } 
            if (_v) { return _wrap_new_FXSpheref__SWIG_2(nargs, args, self);}  }  }  if (argc == 4) { int _v; {
            _v = ((TYPE(argv[0]) == T_FLOAT) || (TYPE(argv[0]) == T_FIXNUM) || (TYPE(argv[0]) == T_BIGNUM)) ? 1 : 0; } 
        if (_v) { { _v = ((TYPE(argv[1]) == T_FLOAT) || (TYPE(argv[1]) == T_FIXNUM) || (TYPE(argv[1]) == T_BIGNUM)) ? 1 : 0; } 
            if (_v) { {
                    _v = ((TYPE(argv[2]) == T_FLOAT) || (TYPE(argv[2]) == T_FIXNUM) || (TYPE(argv[2]) == T_BIGNUM)) ? 1 : 0; } 
                if (_v) { {
                        _v = ((TYPE(argv[3]) == T_FLOAT) || (TYPE(argv[3]) == T_FIXNUM) || (TYPE(argv[3]) == T_BIGNUM)) ? 1 : 0; }
                     if (_v) { return _wrap_new_FXSpheref__SWIG_3(nargs, args, self);}  }  }  }  } 
    rb_raise(rb_eArgError, "No matching function for overloaded 'new_FXSpheref'"); return Qnil; }
static VALUE _wrap_FXSpheref_diameter(int argc, VALUE *argv, VALUE self) { FXSpheref *arg1 = (FXSpheref *) 0 ; FXfloat result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSpheref, 1); result = (FXfloat)((FXSpheref const *)arg1)->diameter();
    vresult = rb_float_new(result); return vresult; }
static VALUE _wrap_FXSpheref_emptyq___(int argc, VALUE *argv, VALUE self) { FXSpheref *arg1 = (FXSpheref *) 0 ; FXbool result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSpheref, 1); result = (FXbool)((FXSpheref const *)arg1)->empty();
    vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXSpheref_containsq_____SWIG_0(int argc, VALUE *argv, VALUE self) { FXSpheref *arg1 = (FXSpheref *) 0 ;
    FXfloat arg2 ; FXfloat arg3 ; FXfloat arg4 ; FXbool result; VALUE vresult = Qnil; if ((argc < 3) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSpheref, 1); arg2 = (FXfloat) NUM2DBL(argv[0]);
    arg3 = (FXfloat) NUM2DBL(argv[1]); arg4 = (FXfloat) NUM2DBL(argv[2]);
    result = (FXbool)((FXSpheref const *)arg1)->contains(arg2,arg3,arg4); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXSpheref_containsq_____SWIG_1(int argc, VALUE *argv, VALUE self) { FXSpheref *arg1 = (FXSpheref *) 0 ;
    FXVec3f *arg2 = 0 ; FXbool result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSpheref, 1); { if (TYPE(argv[0]) == T_ARRAY) {
            arg2 = new FXVec3f(NUM2DBL(rb_ary_entry(argv[0], 0)), NUM2DBL(rb_ary_entry(argv[0], 1)), NUM2DBL(rb_ary_entry(argv[0], 2))); }
         else { FXVec3f *p; SWIG_ConvertPtr(argv[0], (void **)&p, SWIGTYPE_p_FXVec3f, 1); arg2 = new FXVec3f(*p); }  } 
    result = (FXbool)((FXSpheref const *)arg1)->contains((FXVec3f const &)*arg2); vresult = result ? Qtrue : Qfalse;
    delete arg2; return vresult; }
static VALUE _wrap_FXSpheref_containsq_____SWIG_2(int argc, VALUE *argv, VALUE self) { FXSpheref *arg1 = (FXSpheref *) 0 ;
    FXRangef *arg2 = 0 ; FXbool result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSpheref, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXRangef, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    result = (FXbool)((FXSpheref const *)arg1)->contains((FXRangef const &)*arg2); vresult = result ? Qtrue : Qfalse;
    return vresult; }
static VALUE _wrap_FXSpheref_containsq_____SWIG_3(int argc, VALUE *argv, VALUE self) { FXSpheref *arg1 = (FXSpheref *) 0 ;
    FXSpheref *arg2 = 0 ; FXbool result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSpheref, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXSpheref, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    result = (FXbool)((FXSpheref const *)arg1)->contains((FXSpheref const &)*arg2); vresult = result ? Qtrue : Qfalse;
    return vresult; }
static VALUE _wrap_FXSpheref_containsq___(int nargs, VALUE *args, VALUE self) { int argc; VALUE argv[5]; int ii;
    argc = nargs + 1; argv[0] = self; for (ii = 1; (ii < argc) && (ii < 4); ii++) { argv[ii] = args[ii-1]; }  if (argc == 2) {
        int _v; { void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXSpheref, 0) != -1)) ? 1 : 0; }
         if (_v) { { void *ptr;
                _v = (NIL_P(argv[1]) || (TYPE(argv[1]) == T_DATA && SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_FXVec3f, 0) != -1)) ? 1 : 0; }
             if (_v) { return _wrap_FXSpheref_containsq_____SWIG_1(nargs, args, self);}  }  }  if (argc == 2) { int _v; {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXSpheref, 0) != -1)) ? 1 : 0; }
         if (_v) { { void *ptr;
                _v = (NIL_P(argv[1]) || (TYPE(argv[1]) == T_DATA && SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_FXRangef, 0) != -1)) ? 1 : 0; }
             if (_v) { return _wrap_FXSpheref_containsq_____SWIG_2(nargs, args, self);}  }  }  if (argc == 2) { int _v; {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXSpheref, 0) != -1)) ? 1 : 0; }
         if (_v) { { void *ptr;
                _v = (NIL_P(argv[1]) || (TYPE(argv[1]) == T_DATA && SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_FXSpheref, 0) != -1)) ? 1 : 0; }
             if (_v) { return _wrap_FXSpheref_containsq_____SWIG_3(nargs, args, self);}  }  }  if (argc == 4) { int _v; {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXSpheref, 0) != -1)) ? 1 : 0; }
         if (_v) { { _v = ((TYPE(argv[1]) == T_FLOAT) || (TYPE(argv[1]) == T_FIXNUM) || (TYPE(argv[1]) == T_BIGNUM)) ? 1 : 0; } 
            if (_v) { {
                    _v = ((TYPE(argv[2]) == T_FLOAT) || (TYPE(argv[2]) == T_FIXNUM) || (TYPE(argv[2]) == T_BIGNUM)) ? 1 : 0; } 
                if (_v) { {
                        _v = ((TYPE(argv[3]) == T_FLOAT) || (TYPE(argv[3]) == T_FIXNUM) || (TYPE(argv[3]) == T_BIGNUM)) ? 1 : 0; }
                     if (_v) { return _wrap_FXSpheref_containsq_____SWIG_0(nargs, args, self);}  }  }  }  } 
    rb_raise(rb_eArgError, "No matching function for overloaded 'FXSpheref_contains?'"); return Qnil; }
static VALUE _wrap_FXSpheref_includeN_____SWIG_0(int argc, VALUE *argv, VALUE self) { FXSpheref *arg1 = (FXSpheref *) 0 ;
    FXfloat arg2 ; FXfloat arg3 ; FXfloat arg4 ; FXSpheref *result; VALUE vresult = Qnil; if ((argc < 3) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSpheref, 1); arg2 = (FXfloat) NUM2DBL(argv[0]);
    arg3 = (FXfloat) NUM2DBL(argv[1]); arg4 = (FXfloat) NUM2DBL(argv[2]); {
        FXSpheref &_result_ref = (arg1)->include(arg2,arg3,arg4); result = (FXSpheref *) &_result_ref; } 
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_FXSpheref,0); return vresult; }
static VALUE _wrap_FXSpheref_includeN_____SWIG_1(int argc, VALUE *argv, VALUE self) { FXSpheref *arg1 = (FXSpheref *) 0 ;
    FXVec3f *arg2 = 0 ; FXSpheref *result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSpheref, 1); { if (TYPE(argv[0]) == T_ARRAY) {
            arg2 = new FXVec3f(NUM2DBL(rb_ary_entry(argv[0], 0)), NUM2DBL(rb_ary_entry(argv[0], 1)), NUM2DBL(rb_ary_entry(argv[0], 2))); }
         else { FXVec3f *p; SWIG_ConvertPtr(argv[0], (void **)&p, SWIGTYPE_p_FXVec3f, 1); arg2 = new FXVec3f(*p); }  }  {
        FXSpheref &_result_ref = (arg1)->include((FXVec3f const &)*arg2); result = (FXSpheref *) &_result_ref; } 
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_FXSpheref,0); delete arg2; return vresult; }
static VALUE _wrap_FXSpheref_includeN_____SWIG_2(int argc, VALUE *argv, VALUE self) { FXSpheref *arg1 = (FXSpheref *) 0 ;
    FXRangef *arg2 = 0 ; FXSpheref *result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSpheref, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXRangef, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    { FXSpheref &_result_ref = (arg1)->include((FXRangef const &)*arg2); result = (FXSpheref *) &_result_ref; } 
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_FXSpheref,0); return vresult; }
static VALUE _wrap_FXSpheref_includeN_____SWIG_3(int argc, VALUE *argv, VALUE self) { FXSpheref *arg1 = (FXSpheref *) 0 ;
    FXSpheref *arg2 = 0 ; FXSpheref *result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSpheref, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXSpheref, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    { FXSpheref &_result_ref = (arg1)->include((FXSpheref const &)*arg2); result = (FXSpheref *) &_result_ref; } 
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_FXSpheref,0); return vresult; }
static VALUE _wrap_FXSpheref_includeN___(int nargs, VALUE *args, VALUE self) { int argc; VALUE argv[5]; int ii;
    argc = nargs + 1; argv[0] = self; for (ii = 1; (ii < argc) && (ii < 4); ii++) { argv[ii] = args[ii-1]; }  if (argc == 2) {
        int _v; { void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXSpheref, 0) != -1)) ? 1 : 0; }
         if (_v) { { void *ptr;
                _v = (NIL_P(argv[1]) || (TYPE(argv[1]) == T_DATA && SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_FXVec3f, 0) != -1)) ? 1 : 0; }
             if (_v) { return _wrap_FXSpheref_includeN_____SWIG_1(nargs, args, self);}  }  }  if (argc == 2) { int _v; {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXSpheref, 0) != -1)) ? 1 : 0; }
         if (_v) { { void *ptr;
                _v = (NIL_P(argv[1]) || (TYPE(argv[1]) == T_DATA && SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_FXRangef, 0) != -1)) ? 1 : 0; }
             if (_v) { return _wrap_FXSpheref_includeN_____SWIG_2(nargs, args, self);}  }  }  if (argc == 2) { int _v; {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXSpheref, 0) != -1)) ? 1 : 0; }
         if (_v) { { void *ptr;
                _v = (NIL_P(argv[1]) || (TYPE(argv[1]) == T_DATA && SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_FXSpheref, 0) != -1)) ? 1 : 0; }
             if (_v) { return _wrap_FXSpheref_includeN_____SWIG_3(nargs, args, self);}  }  }  if (argc == 4) { int _v; {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXSpheref, 0) != -1)) ? 1 : 0; }
         if (_v) { { _v = ((TYPE(argv[1]) == T_FLOAT) || (TYPE(argv[1]) == T_FIXNUM) || (TYPE(argv[1]) == T_BIGNUM)) ? 1 : 0; } 
            if (_v) { {
                    _v = ((TYPE(argv[2]) == T_FLOAT) || (TYPE(argv[2]) == T_FIXNUM) || (TYPE(argv[2]) == T_BIGNUM)) ? 1 : 0; } 
                if (_v) { {
                        _v = ((TYPE(argv[3]) == T_FLOAT) || (TYPE(argv[3]) == T_FIXNUM) || (TYPE(argv[3]) == T_BIGNUM)) ? 1 : 0; }
                     if (_v) { return _wrap_FXSpheref_includeN_____SWIG_0(nargs, args, self);}  }  }  }  } 
    rb_raise(rb_eArgError, "No matching function for overloaded 'FXSpheref_include!'"); return Qnil; }
static VALUE _wrap_FXSpheref_intersect(int argc, VALUE *argv, VALUE self) { FXSpheref *arg1 = (FXSpheref *) 0 ;
    FXVec4f *arg2 = 0 ; FXint result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSpheref, 1); { if (TYPE(argv[0]) == T_ARRAY) {
            arg2 = new FXVec4f(NUM2DBL(rb_ary_entry(argv[0], 0)), NUM2DBL(rb_ary_entry(argv[0], 1)), NUM2DBL(rb_ary_entry(argv[0], 2)), NUM2DBL(rb_ary_entry(argv[0], 3))); }
         else { FXVec4f *p; SWIG_ConvertPtr(argv[0],(void **)&p,SWIGTYPE_p_FXVec4f,1); arg2 = new FXVec4f(*p); }  } 
    result = (FXint)((FXSpheref const *)arg1)->intersect((FXVec4f const &)*arg2); vresult = INT2NUM(result); delete arg2;
    return vresult; }
static VALUE _wrap_FXSpheref_intersectsq___(int argc, VALUE *argv, VALUE self) { FXSpheref *arg1 = (FXSpheref *) 0 ;
    FXVec3f *arg2 = 0 ; FXVec3f *arg3 = 0 ; FXbool result; VALUE vresult = Qnil; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSpheref, 1); { if (TYPE(argv[0]) == T_ARRAY) {
            arg2 = new FXVec3f(NUM2DBL(rb_ary_entry(argv[0], 0)), NUM2DBL(rb_ary_entry(argv[0], 1)), NUM2DBL(rb_ary_entry(argv[0], 2))); }
         else { FXVec3f *p; SWIG_ConvertPtr(argv[0], (void **)&p, SWIGTYPE_p_FXVec3f, 1); arg2 = new FXVec3f(*p); }  }  {
        if (TYPE(argv[1]) == T_ARRAY) {
            arg3 = new FXVec3f(NUM2DBL(rb_ary_entry(argv[1], 0)), NUM2DBL(rb_ary_entry(argv[1], 1)), NUM2DBL(rb_ary_entry(argv[1], 2))); }
         else { FXVec3f *p; SWIG_ConvertPtr(argv[1], (void **)&p, SWIGTYPE_p_FXVec3f, 1); arg3 = new FXVec3f(*p); }  } 
    result = (FXbool)((FXSpheref const *)arg1)->intersect((FXVec3f const &)*arg2,(FXVec3f const &)*arg3);
    vresult = result ? Qtrue : Qfalse; delete arg2; delete arg3; return vresult; }
static VALUE _wrap_FXSpheref_overlapsq_____SWIG_0(int argc, VALUE *argv, VALUE self) { FXSpheref *arg1 = (FXSpheref *) 0 ;
    FXRangef *arg2 = 0 ; FXbool result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSpheref, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXRangef, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    result = (FXbool)FXSpheref_overlap__SWIG_0((FXSpheref const *)arg1,(FXRangef const &)*arg2);
    vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXSpheref_overlapsq_____SWIG_1(int argc, VALUE *argv, VALUE self) { FXSpheref *arg1 = (FXSpheref *) 0 ;
    FXSpheref *arg2 = 0 ; FXbool result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSpheref, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXSpheref, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    result = (FXbool)FXSpheref_overlap__SWIG_1((FXSpheref const *)arg1,(FXSpheref const &)*arg2);
    vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXSpheref_overlapsq___(int nargs, VALUE *args, VALUE self) { int argc; VALUE argv[3]; int ii;
    argc = nargs + 1; argv[0] = self; for (ii = 1; (ii < argc) && (ii < 2); ii++) { argv[ii] = args[ii-1]; }  if (argc == 2) {
        int _v; { void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXSpheref, 0) != -1)) ? 1 : 0; }
         if (_v) { { void *ptr;
                _v = (NIL_P(argv[1]) || (TYPE(argv[1]) == T_DATA && SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_FXRangef, 0) != -1)) ? 1 : 0; }
             if (_v) { return _wrap_FXSpheref_overlapsq_____SWIG_0(nargs, args, self);}  }  }  if (argc == 2) { int _v; {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXSpheref, 0) != -1)) ? 1 : 0; }
         if (_v) { { void *ptr;
                _v = (NIL_P(argv[1]) || (TYPE(argv[1]) == T_DATA && SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_FXSpheref, 0) != -1)) ? 1 : 0; }
             if (_v) { return _wrap_FXSpheref_overlapsq_____SWIG_1(nargs, args, self);}  }  } 
    rb_raise(rb_eArgError, "No matching function for overloaded 'FXSpheref_overlaps?'"); return Qnil; }
static VALUE _wrap_FXSphered_center_set(int argc, VALUE *argv, VALUE self) { FXSphered *arg1 = (FXSphered *) 0 ;
    FXVec3d *arg2 = (FXVec3d *) 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSphered, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXVec3d, 1); if (arg1) (arg1)->center = *arg2; return Qnil; }
static VALUE _wrap_FXSphered_center_get(int argc, VALUE *argv, VALUE self) { FXSphered *arg1 = (FXSphered *) 0 ;
    FXVec3d *result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSphered, 1); result = (FXVec3d *)& ((arg1)->center);
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_FXVec3d,0); return vresult; }
static VALUE _wrap_FXSphered_radius_set(int argc, VALUE *argv, VALUE self) { FXSphered *arg1 = (FXSphered *) 0 ; FXdouble arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSphered, 1); arg2 = (FXdouble) NUM2DBL(argv[0]);
    if (arg1) (arg1)->radius = arg2; return Qnil; }
static VALUE _wrap_FXSphered_radius_get(int argc, VALUE *argv, VALUE self) { FXSphered *arg1 = (FXSphered *) 0 ;
    FXdouble result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSphered, 1); result = (FXdouble) ((arg1)->radius);
    vresult = rb_float_new(result); return vresult; }
static VALUE _wrap_new_FXSphered__SWIG_0(int argc, VALUE *argv, VALUE self) { FXSphered *result; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc); result = (FXSphered *)new FXSphered();
    DATA_PTR(self) = result; return self; }
static VALUE _wrap_new_FXSphered__SWIG_1(int argc, VALUE *argv, VALUE self) { FXSphered *arg1 = 0 ; FXSphered *result;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXSphered, 1); if (arg1 == NULL) rb_raise(rb_eTypeError, "null reference");
    result = (FXSphered *)new FXSphered((FXSphered const &)*arg1); DATA_PTR(self) = result; return self; }
static VALUE _wrap_new_FXSphered__SWIG_2(int argc, VALUE *argv, VALUE self) { FXVec3d *arg1 = 0 ; FXdouble arg2 ;
    FXSphered *result; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXVec3d, 1); if (arg1 == NULL) rb_raise(rb_eTypeError, "null reference");
    arg2 = (FXdouble) NUM2DBL(argv[1]); result = (FXSphered *)new FXSphered((FXVec3d const &)*arg1,arg2);
    DATA_PTR(self) = result; return self; }
static VALUE _wrap_new_FXSphered__SWIG_3(int argc, VALUE *argv, VALUE self) { FXdouble arg1 ; FXdouble arg2 ; FXdouble arg3 ;
    FXdouble arg4 ; FXSphered *result; if ((argc < 4) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc); arg1 = (FXdouble) NUM2DBL(argv[0]);
    arg2 = (FXdouble) NUM2DBL(argv[1]); arg3 = (FXdouble) NUM2DBL(argv[2]); arg4 = (FXdouble) NUM2DBL(argv[3]);
    result = (FXSphered *)new FXSphered(arg1,arg2,arg3,arg4); DATA_PTR(self) = result; return self; }
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE _wrap_FXSphered_allocate(VALUE self) {
#else
     static VALUE _wrap_FXSphered_allocate(int argc, VALUE *argv, VALUE self) {
#endif
         VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_FXSphered);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
         return vresult; }
static VALUE _wrap_new_FXSphered__SWIG_4(int argc, VALUE *argv, VALUE self) { FXRanged *arg1 = 0 ; FXSphered *result;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXRanged, 1); if (arg1 == NULL) rb_raise(rb_eTypeError, "null reference");
    result = (FXSphered *)new FXSphered((FXRanged const &)*arg1); DATA_PTR(self) = result; return self; }
static VALUE _wrap_new_FXSphered(int nargs, VALUE *args, VALUE self) { int argc; VALUE argv[4]; int ii; argc = nargs;
    for (ii = 0; (ii < argc) && (ii < 4); ii++) { argv[ii] = args[ii]; }  if (argc == 0) {
        return _wrap_new_FXSphered__SWIG_0(nargs, args, self);}  if (argc == 1) { int _v; { void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXSphered, 0) != -1)) ? 1 : 0; }
         if (_v) { return _wrap_new_FXSphered__SWIG_1(nargs, args, self);}  }  if (argc == 1) { int _v; { void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXRanged, 0) != -1)) ? 1 : 0; }
         if (_v) { return _wrap_new_FXSphered__SWIG_4(nargs, args, self);}  }  if (argc == 2) { int _v; { void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXVec3d, 0) != -1)) ? 1 : 0; }
         if (_v) { { _v = ((TYPE(argv[1]) == T_FLOAT) || (TYPE(argv[1]) == T_FIXNUM) || (TYPE(argv[1]) == T_BIGNUM)) ? 1 : 0; } 
            if (_v) { return _wrap_new_FXSphered__SWIG_2(nargs, args, self);}  }  }  if (argc == 4) { int _v; {
            _v = ((TYPE(argv[0]) == T_FLOAT) || (TYPE(argv[0]) == T_FIXNUM) || (TYPE(argv[0]) == T_BIGNUM)) ? 1 : 0; } 
        if (_v) { { _v = ((TYPE(argv[1]) == T_FLOAT) || (TYPE(argv[1]) == T_FIXNUM) || (TYPE(argv[1]) == T_BIGNUM)) ? 1 : 0; } 
            if (_v) { {
                    _v = ((TYPE(argv[2]) == T_FLOAT) || (TYPE(argv[2]) == T_FIXNUM) || (TYPE(argv[2]) == T_BIGNUM)) ? 1 : 0; } 
                if (_v) { {
                        _v = ((TYPE(argv[3]) == T_FLOAT) || (TYPE(argv[3]) == T_FIXNUM) || (TYPE(argv[3]) == T_BIGNUM)) ? 1 : 0; }
                     if (_v) { return _wrap_new_FXSphered__SWIG_3(nargs, args, self);}  }  }  }  } 
    rb_raise(rb_eArgError, "No matching function for overloaded 'new_FXSphered'"); return Qnil; }
static VALUE _wrap_FXSphered_diameter(int argc, VALUE *argv, VALUE self) { FXSphered *arg1 = (FXSphered *) 0 ; FXdouble result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSphered, 1); result = (FXdouble)((FXSphered const *)arg1)->diameter();
    vresult = rb_float_new(result); return vresult; }
static VALUE _wrap_FXSphered_emptyq___(int argc, VALUE *argv, VALUE self) { FXSphered *arg1 = (FXSphered *) 0 ; FXbool result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSphered, 1); result = (FXbool)((FXSphered const *)arg1)->empty();
    vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXSphered_containsq_____SWIG_0(int argc, VALUE *argv, VALUE self) { FXSphered *arg1 = (FXSphered *) 0 ;
    FXdouble arg2 ; FXdouble arg3 ; FXdouble arg4 ; FXbool result; VALUE vresult = Qnil; if ((argc < 3) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSphered, 1); arg2 = (FXdouble) NUM2DBL(argv[0]);
    arg3 = (FXdouble) NUM2DBL(argv[1]); arg4 = (FXdouble) NUM2DBL(argv[2]);
    result = (FXbool)((FXSphered const *)arg1)->contains(arg2,arg3,arg4); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXSphered_containsq_____SWIG_1(int argc, VALUE *argv, VALUE self) { FXSphered *arg1 = (FXSphered *) 0 ;
    FXVec3d *arg2 = 0 ; FXbool result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSphered, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXVec3d, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    result = (FXbool)((FXSphered const *)arg1)->contains((FXVec3d const &)*arg2); vresult = result ? Qtrue : Qfalse;
    return vresult; }
static VALUE _wrap_FXSphered_containsq_____SWIG_2(int argc, VALUE *argv, VALUE self) { FXSphered *arg1 = (FXSphered *) 0 ;
    FXRanged *arg2 = 0 ; FXbool result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSphered, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXRanged, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    result = (FXbool)((FXSphered const *)arg1)->contains((FXRanged const &)*arg2); vresult = result ? Qtrue : Qfalse;
    return vresult; }
static VALUE _wrap_FXSphered_containsq_____SWIG_3(int argc, VALUE *argv, VALUE self) { FXSphered *arg1 = (FXSphered *) 0 ;
    FXSphered *arg2 = 0 ; FXbool result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSphered, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXSphered, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    result = (FXbool)((FXSphered const *)arg1)->contains((FXSphered const &)*arg2); vresult = result ? Qtrue : Qfalse;
    return vresult; }
static VALUE _wrap_FXSphered_containsq___(int nargs, VALUE *args, VALUE self) { int argc; VALUE argv[5]; int ii;
    argc = nargs + 1; argv[0] = self; for (ii = 1; (ii < argc) && (ii < 4); ii++) { argv[ii] = args[ii-1]; }  if (argc == 2) {
        int _v; { void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXSphered, 0) != -1)) ? 1 : 0; }
         if (_v) { { void *ptr;
                _v = (NIL_P(argv[1]) || (TYPE(argv[1]) == T_DATA && SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_FXVec3d, 0) != -1)) ? 1 : 0; }
             if (_v) { return _wrap_FXSphered_containsq_____SWIG_1(nargs, args, self);}  }  }  if (argc == 2) { int _v; {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXSphered, 0) != -1)) ? 1 : 0; }
         if (_v) { { void *ptr;
                _v = (NIL_P(argv[1]) || (TYPE(argv[1]) == T_DATA && SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_FXRanged, 0) != -1)) ? 1 : 0; }
             if (_v) { return _wrap_FXSphered_containsq_____SWIG_2(nargs, args, self);}  }  }  if (argc == 2) { int _v; {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXSphered, 0) != -1)) ? 1 : 0; }
         if (_v) { { void *ptr;
                _v = (NIL_P(argv[1]) || (TYPE(argv[1]) == T_DATA && SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_FXSphered, 0) != -1)) ? 1 : 0; }
             if (_v) { return _wrap_FXSphered_containsq_____SWIG_3(nargs, args, self);}  }  }  if (argc == 4) { int _v; {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXSphered, 0) != -1)) ? 1 : 0; }
         if (_v) { { _v = ((TYPE(argv[1]) == T_FLOAT) || (TYPE(argv[1]) == T_FIXNUM) || (TYPE(argv[1]) == T_BIGNUM)) ? 1 : 0; } 
            if (_v) { {
                    _v = ((TYPE(argv[2]) == T_FLOAT) || (TYPE(argv[2]) == T_FIXNUM) || (TYPE(argv[2]) == T_BIGNUM)) ? 1 : 0; } 
                if (_v) { {
                        _v = ((TYPE(argv[3]) == T_FLOAT) || (TYPE(argv[3]) == T_FIXNUM) || (TYPE(argv[3]) == T_BIGNUM)) ? 1 : 0; }
                     if (_v) { return _wrap_FXSphered_containsq_____SWIG_0(nargs, args, self);}  }  }  }  } 
    rb_raise(rb_eArgError, "No matching function for overloaded 'FXSphered_contains?'"); return Qnil; }
static VALUE _wrap_FXSphered_includeN_____SWIG_0(int argc, VALUE *argv, VALUE self) { FXSphered *arg1 = (FXSphered *) 0 ;
    FXdouble arg2 ; FXdouble arg3 ; FXdouble arg4 ; FXSphered *result; VALUE vresult = Qnil; if ((argc < 3) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSphered, 1); arg2 = (FXdouble) NUM2DBL(argv[0]);
    arg3 = (FXdouble) NUM2DBL(argv[1]); arg4 = (FXdouble) NUM2DBL(argv[2]); {
        FXSphered &_result_ref = (arg1)->include(arg2,arg3,arg4); result = (FXSphered *) &_result_ref; } 
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_FXSphered,0); return vresult; }
static VALUE _wrap_FXSphered_includeN_____SWIG_1(int argc, VALUE *argv, VALUE self) { FXSphered *arg1 = (FXSphered *) 0 ;
    FXVec3d *arg2 = 0 ; FXSphered *result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSphered, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXVec3d, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    { FXSphered &_result_ref = (arg1)->include((FXVec3d const &)*arg2); result = (FXSphered *) &_result_ref; } 
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_FXSphered,0); return vresult; }
static VALUE _wrap_FXSphered_includeN_____SWIG_2(int argc, VALUE *argv, VALUE self) { FXSphered *arg1 = (FXSphered *) 0 ;
    FXRanged *arg2 = 0 ; FXSphered *result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSphered, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXRanged, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    { FXSphered &_result_ref = (arg1)->include((FXRanged const &)*arg2); result = (FXSphered *) &_result_ref; } 
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_FXSphered,0); return vresult; }
static VALUE _wrap_FXSphered_includeN_____SWIG_3(int argc, VALUE *argv, VALUE self) { FXSphered *arg1 = (FXSphered *) 0 ;
    FXSphered *arg2 = 0 ; FXSphered *result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSphered, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXSphered, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    { FXSphered &_result_ref = (arg1)->include((FXSphered const &)*arg2); result = (FXSphered *) &_result_ref; } 
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_FXSphered,0); return vresult; }
static VALUE _wrap_FXSphered_includeN___(int nargs, VALUE *args, VALUE self) { int argc; VALUE argv[5]; int ii;
    argc = nargs + 1; argv[0] = self; for (ii = 1; (ii < argc) && (ii < 4); ii++) { argv[ii] = args[ii-1]; }  if (argc == 2) {
        int _v; { void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXSphered, 0) != -1)) ? 1 : 0; }
         if (_v) { { void *ptr;
                _v = (NIL_P(argv[1]) || (TYPE(argv[1]) == T_DATA && SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_FXVec3d, 0) != -1)) ? 1 : 0; }
             if (_v) { return _wrap_FXSphered_includeN_____SWIG_1(nargs, args, self);}  }  }  if (argc == 2) { int _v; {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXSphered, 0) != -1)) ? 1 : 0; }
         if (_v) { { void *ptr;
                _v = (NIL_P(argv[1]) || (TYPE(argv[1]) == T_DATA && SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_FXRanged, 0) != -1)) ? 1 : 0; }
             if (_v) { return _wrap_FXSphered_includeN_____SWIG_2(nargs, args, self);}  }  }  if (argc == 2) { int _v; {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXSphered, 0) != -1)) ? 1 : 0; }
         if (_v) { { void *ptr;
                _v = (NIL_P(argv[1]) || (TYPE(argv[1]) == T_DATA && SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_FXSphered, 0) != -1)) ? 1 : 0; }
             if (_v) { return _wrap_FXSphered_includeN_____SWIG_3(nargs, args, self);}  }  }  if (argc == 4) { int _v; {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXSphered, 0) != -1)) ? 1 : 0; }
         if (_v) { { _v = ((TYPE(argv[1]) == T_FLOAT) || (TYPE(argv[1]) == T_FIXNUM) || (TYPE(argv[1]) == T_BIGNUM)) ? 1 : 0; } 
            if (_v) { {
                    _v = ((TYPE(argv[2]) == T_FLOAT) || (TYPE(argv[2]) == T_FIXNUM) || (TYPE(argv[2]) == T_BIGNUM)) ? 1 : 0; } 
                if (_v) { {
                        _v = ((TYPE(argv[3]) == T_FLOAT) || (TYPE(argv[3]) == T_FIXNUM) || (TYPE(argv[3]) == T_BIGNUM)) ? 1 : 0; }
                     if (_v) { return _wrap_FXSphered_includeN_____SWIG_0(nargs, args, self);}  }  }  }  } 
    rb_raise(rb_eArgError, "No matching function for overloaded 'FXSphered_include!'"); return Qnil; }
static VALUE _wrap_FXSphered_intersect(int argc, VALUE *argv, VALUE self) { FXSphered *arg1 = (FXSphered *) 0 ;
    FXVec4d *arg2 = 0 ; FXint result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSphered, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXVec4d, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    result = (FXint)((FXSphered const *)arg1)->intersect((FXVec4d const &)*arg2); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXSphered_intersectsq___(int argc, VALUE *argv, VALUE self) { FXSphered *arg1 = (FXSphered *) 0 ;
    FXVec3d *arg2 = 0 ; FXVec3d *arg3 = 0 ; FXbool result; VALUE vresult = Qnil; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSphered, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXVec3d, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    SWIG_ConvertPtr(argv[1], (void **) &arg3, SWIGTYPE_p_FXVec3d, 1); if (arg3 == NULL) rb_raise(rb_eTypeError, "null reference");
    result = (FXbool)((FXSphered const *)arg1)->intersect((FXVec3d const &)*arg2,(FXVec3d const &)*arg3);
    vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXSphered_overlapsq_____SWIG_0(int argc, VALUE *argv, VALUE self) { FXSphered *arg1 = (FXSphered *) 0 ;
    FXRanged *arg2 = 0 ; FXbool result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSphered, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXRanged, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    result = (FXbool)FXSphered_overlap__SWIG_0((FXSphered const *)arg1,(FXRanged const &)*arg2);
    vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXSphered_overlapsq_____SWIG_1(int argc, VALUE *argv, VALUE self) { FXSphered *arg1 = (FXSphered *) 0 ;
    FXSphered *arg2 = 0 ; FXbool result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSphered, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXSphered, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    result = (FXbool)FXSphered_overlap__SWIG_1((FXSphered const *)arg1,(FXSphered const &)*arg2);
    vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXSphered_overlapsq___(int nargs, VALUE *args, VALUE self) { int argc; VALUE argv[3]; int ii;
    argc = nargs + 1; argv[0] = self; for (ii = 1; (ii < argc) && (ii < 2); ii++) { argv[ii] = args[ii-1]; }  if (argc == 2) {
        int _v; { void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXSphered, 0) != -1)) ? 1 : 0; }
         if (_v) { { void *ptr;
                _v = (NIL_P(argv[1]) || (TYPE(argv[1]) == T_DATA && SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_FXRanged, 0) != -1)) ? 1 : 0; }
             if (_v) { return _wrap_FXSphered_overlapsq_____SWIG_0(nargs, args, self);}  }  }  if (argc == 2) { int _v; {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXSphered, 0) != -1)) ? 1 : 0; }
         if (_v) { { void *ptr;
                _v = (NIL_P(argv[1]) || (TYPE(argv[1]) == T_DATA && SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_FXSphered, 0) != -1)) ? 1 : 0; }
             if (_v) { return _wrap_FXSphered_overlapsq_____SWIG_1(nargs, args, self);}  }  } 
    rb_raise(rb_eArgError, "No matching function for overloaded 'FXSphered_overlaps?'"); return Qnil; }
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE _wrap_FXGLVisual_allocate(VALUE self) {
#else
     static VALUE _wrap_FXGLVisual_allocate(int argc, VALUE *argv, VALUE self) {
#endif
         VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_FXGLVisual);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
         return vresult; }
static VALUE _wrap_new_FXGLVisual(int argc, VALUE *argv, VALUE self) { FXApp *arg1 = (FXApp *) 0 ; FXuint arg2 ;
    FXGLVisual *result; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXApp, 1); arg2 = NUM2UINT(argv[1]); {
        result = (FXGLVisual *)new_FXGLVisual(arg1,arg2); DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result);
        if(rb_block_given_p()){ rb_yield(self); }  }  return self; }
static VALUE _wrap_FXGLVisual_supported(int argc, VALUE *argv, VALUE self) { FXApp *arg1 = (FXApp *) 0 ; FXbool result;
    VALUE vresult = Qnil; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXApp, 1); result = (FXbool)FXGLVisual_supported(arg1);
    vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXGLVisual_getRedSize(int argc, VALUE *argv, VALUE self) { FXGLVisual *arg1 = (FXGLVisual *) 0 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLVisual, 1); result = (FXint)((FXGLVisual const *)arg1)->getRedSize();
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXGLVisual_getGreenSize(int argc, VALUE *argv, VALUE self) { FXGLVisual *arg1 = (FXGLVisual *) 0 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLVisual, 1);
    result = (FXint)((FXGLVisual const *)arg1)->getGreenSize(); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXGLVisual_getBlueSize(int argc, VALUE *argv, VALUE self) { FXGLVisual *arg1 = (FXGLVisual *) 0 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLVisual, 1); result = (FXint)((FXGLVisual const *)arg1)->getBlueSize();
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXGLVisual_getAlphaSize(int argc, VALUE *argv, VALUE self) { FXGLVisual *arg1 = (FXGLVisual *) 0 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLVisual, 1);
    result = (FXint)((FXGLVisual const *)arg1)->getAlphaSize(); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXGLVisual_getDepthSize(int argc, VALUE *argv, VALUE self) { FXGLVisual *arg1 = (FXGLVisual *) 0 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLVisual, 1);
    result = (FXint)((FXGLVisual const *)arg1)->getDepthSize(); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXGLVisual_getStencilSize(int argc, VALUE *argv, VALUE self) { FXGLVisual *arg1 = (FXGLVisual *) 0 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLVisual, 1);
    result = (FXint)((FXGLVisual const *)arg1)->getStencilSize(); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXGLVisual_getAccumRedSize(int argc, VALUE *argv, VALUE self) { FXGLVisual *arg1 = (FXGLVisual *) 0 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLVisual, 1);
    result = (FXint)((FXGLVisual const *)arg1)->getAccumRedSize(); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXGLVisual_getAccumGreenSize(int argc, VALUE *argv, VALUE self) { FXGLVisual *arg1 = (FXGLVisual *) 0 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLVisual, 1);
    result = (FXint)((FXGLVisual const *)arg1)->getAccumGreenSize(); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXGLVisual_getAccumBlueSize(int argc, VALUE *argv, VALUE self) { FXGLVisual *arg1 = (FXGLVisual *) 0 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLVisual, 1);
    result = (FXint)((FXGLVisual const *)arg1)->getAccumBlueSize(); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXGLVisual_getAccumAlphaSize(int argc, VALUE *argv, VALUE self) { FXGLVisual *arg1 = (FXGLVisual *) 0 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLVisual, 1);
    result = (FXint)((FXGLVisual const *)arg1)->getAccumAlphaSize(); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXGLVisual_setRedSize(int argc, VALUE *argv, VALUE self) { FXGLVisual *arg1 = (FXGLVisual *) 0 ; FXint arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLVisual, 1); arg2 = NUM2INT(argv[0]); (arg1)->setRedSize(arg2);
    return Qnil; }
static VALUE _wrap_FXGLVisual_setGreenSize(int argc, VALUE *argv, VALUE self) { FXGLVisual *arg1 = (FXGLVisual *) 0 ;
    FXint arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLVisual, 1); arg2 = NUM2INT(argv[0]); (arg1)->setGreenSize(arg2);
    return Qnil; }
static VALUE _wrap_FXGLVisual_setBlueSize(int argc, VALUE *argv, VALUE self) { FXGLVisual *arg1 = (FXGLVisual *) 0 ;
    FXint arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLVisual, 1); arg2 = NUM2INT(argv[0]); (arg1)->setBlueSize(arg2);
    return Qnil; }
static VALUE _wrap_FXGLVisual_setAlphaSize(int argc, VALUE *argv, VALUE self) { FXGLVisual *arg1 = (FXGLVisual *) 0 ;
    FXint arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLVisual, 1); arg2 = NUM2INT(argv[0]); (arg1)->setAlphaSize(arg2);
    return Qnil; }
static VALUE _wrap_FXGLVisual_setDepthSize(int argc, VALUE *argv, VALUE self) { FXGLVisual *arg1 = (FXGLVisual *) 0 ;
    FXint arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLVisual, 1); arg2 = NUM2INT(argv[0]); (arg1)->setDepthSize(arg2);
    return Qnil; }
static VALUE _wrap_FXGLVisual_setStencilSize(int argc, VALUE *argv, VALUE self) { FXGLVisual *arg1 = (FXGLVisual *) 0 ;
    FXint arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLVisual, 1); arg2 = NUM2INT(argv[0]); (arg1)->setStencilSize(arg2);
    return Qnil; }
static VALUE _wrap_FXGLVisual_setAccumRedSize(int argc, VALUE *argv, VALUE self) { FXGLVisual *arg1 = (FXGLVisual *) 0 ;
    FXint arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLVisual, 1); arg2 = NUM2INT(argv[0]); (arg1)->setAccumRedSize(arg2);
    return Qnil; }
static VALUE _wrap_FXGLVisual_setAccumGreenSize(int argc, VALUE *argv, VALUE self) { FXGLVisual *arg1 = (FXGLVisual *) 0 ;
    FXint arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLVisual, 1); arg2 = NUM2INT(argv[0]); (arg1)->setAccumGreenSize(arg2);
    return Qnil; }
static VALUE _wrap_FXGLVisual_setAccumBlueSize(int argc, VALUE *argv, VALUE self) { FXGLVisual *arg1 = (FXGLVisual *) 0 ;
    FXint arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLVisual, 1); arg2 = NUM2INT(argv[0]); (arg1)->setAccumBlueSize(arg2);
    return Qnil; }
static VALUE _wrap_FXGLVisual_setAccumAlphaSize(int argc, VALUE *argv, VALUE self) { FXGLVisual *arg1 = (FXGLVisual *) 0 ;
    FXint arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLVisual, 1); arg2 = NUM2INT(argv[0]); (arg1)->setAccumAlphaSize(arg2);
    return Qnil; }
static VALUE _wrap_FXGLVisual_getActualRedSize(int argc, VALUE *argv, VALUE self) { FXGLVisual *arg1 = (FXGLVisual *) 0 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLVisual, 1);
    result = (FXint)((FXGLVisual const *)arg1)->getActualRedSize(); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXGLVisual_getActualGreenSize(int argc, VALUE *argv, VALUE self) { FXGLVisual *arg1 = (FXGLVisual *) 0 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLVisual, 1);
    result = (FXint)((FXGLVisual const *)arg1)->getActualGreenSize(); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXGLVisual_getActualBlueSize(int argc, VALUE *argv, VALUE self) { FXGLVisual *arg1 = (FXGLVisual *) 0 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLVisual, 1);
    result = (FXint)((FXGLVisual const *)arg1)->getActualBlueSize(); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXGLVisual_getActualAlphaSize(int argc, VALUE *argv, VALUE self) { FXGLVisual *arg1 = (FXGLVisual *) 0 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLVisual, 1);
    result = (FXint)((FXGLVisual const *)arg1)->getActualAlphaSize(); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXGLVisual_getActualDepthSize(int argc, VALUE *argv, VALUE self) { FXGLVisual *arg1 = (FXGLVisual *) 0 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLVisual, 1);
    result = (FXint)((FXGLVisual const *)arg1)->getActualDepthSize(); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXGLVisual_getActualStencilSize(int argc, VALUE *argv, VALUE self) { FXGLVisual *arg1 = (FXGLVisual *) 0 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLVisual, 1);
    result = (FXint)((FXGLVisual const *)arg1)->getActualStencilSize(); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXGLVisual_getActualAccumRedSize(int argc, VALUE *argv, VALUE self) { FXGLVisual *arg1 = (FXGLVisual *) 0 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLVisual, 1);
    result = (FXint)((FXGLVisual const *)arg1)->getActualAccumRedSize(); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXGLVisual_getActualAccumGreenSize(int argc, VALUE *argv, VALUE self) { FXGLVisual *arg1 = (FXGLVisual *) 0 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLVisual, 1);
    result = (FXint)((FXGLVisual const *)arg1)->getActualAccumGreenSize(); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXGLVisual_getActualAccumBlueSize(int argc, VALUE *argv, VALUE self) { FXGLVisual *arg1 = (FXGLVisual *) 0 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLVisual, 1);
    result = (FXint)((FXGLVisual const *)arg1)->getActualAccumBlueSize(); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXGLVisual_getActualAccumAlphaSize(int argc, VALUE *argv, VALUE self) { FXGLVisual *arg1 = (FXGLVisual *) 0 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLVisual, 1);
    result = (FXint)((FXGLVisual const *)arg1)->getActualAccumAlphaSize(); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXGLVisual_isDoubleBuffer(int argc, VALUE *argv, VALUE self) { FXGLVisual *arg1 = (FXGLVisual *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLVisual, 1);
    result = (FXbool)((FXGLVisual const *)arg1)->isDoubleBuffer(); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXGLVisual_isStereo(int argc, VALUE *argv, VALUE self) { FXGLVisual *arg1 = (FXGLVisual *) 0 ; FXbool result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLVisual, 1); result = (FXbool)((FXGLVisual const *)arg1)->isStereo();
    vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXGLVisual_isAccelerated(int argc, VALUE *argv, VALUE self) { FXGLVisual *arg1 = (FXGLVisual *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLVisual, 1);
    result = (FXbool)((FXGLVisual const *)arg1)->isAccelerated(); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXGLVisual_isBufferSwapCopy(int argc, VALUE *argv, VALUE self) { FXGLVisual *arg1 = (FXGLVisual *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLVisual, 1);
    result = (FXbool)((FXGLVisual const *)arg1)->isBufferSwapCopy(); vresult = result ? Qtrue : Qfalse; return vresult; }
static void
free_FXGLVisual(FXGLVisual *arg1) {
    delete arg1;
}
static VALUE _wrap_FXGLVisual_save(int argc, VALUE *argv, VALUE self) { FXGLVisual *arg1 = (FXGLVisual *) 0 ;
    FXStream *arg2 = 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLVisual, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXGLVisual_save((FXGLVisual const *)arg1,*arg2); return Qnil; }
static VALUE _wrap_FXGLVisual_load(int argc, VALUE *argv, VALUE self) { FXGLVisual *arg1 = (FXGLVisual *) 0 ;
    FXStream *arg2 = 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLVisual, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXGLVisual_load(arg1,*arg2); return Qnil; }
static VALUE _wrap_FXGLVisual_create(int argc, VALUE *argv, VALUE self) { FXGLVisual *arg1 = (FXGLVisual *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLVisual, 1); FXGLVisual_create(arg1); return Qnil; }
static VALUE _wrap_FXGLVisual_detach(int argc, VALUE *argv, VALUE self) { FXGLVisual *arg1 = (FXGLVisual *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLVisual, 1); FXGLVisual_detach(arg1); return Qnil; }
static VALUE _wrap_FXGLVisual_destroy(int argc, VALUE *argv, VALUE self) { FXGLVisual *arg1 = (FXGLVisual *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLVisual, 1); FXGLVisual_destroy(arg1); return Qnil; }
static VALUE _wrap_glUseFXFont(int argc, VALUE *argv, VALUE self) { FXFont *arg1 = (FXFont *) 0 ; int arg2 ; int arg3 ;
    int arg4 ; if ((argc < 4) || (argc > 4)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXFont, 1); arg2 = NUM2INT(argv[1]); arg3 = NUM2INT(argv[2]);
    arg4 = NUM2INT(argv[3]); glUseFXFont(arg1,arg2,arg3,arg4); return Qnil; }
static VALUE _wrap_new_FXGLContext__SWIG_0(int argc, VALUE *argv, VALUE self) { FXApp *arg1 = (FXApp *) 0 ;
    FXGLVisual *arg2 = (FXGLVisual *) 0 ; FXGLContext *result; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXApp, 1);
    SWIG_ConvertPtr(argv[1], (void **) &arg2, SWIGTYPE_p_FXGLVisual, 1); {
        result = (FXGLContext *)new_FXGLContext__SWIG_0(arg1,arg2); DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result);
        if(rb_block_given_p()){ rb_yield(self); }  }  return self; }
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE _wrap_FXGLContext_allocate(VALUE self) {
#else
     static VALUE _wrap_FXGLContext_allocate(int argc, VALUE *argv, VALUE self) {
#endif
         VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_FXGLContext);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
         return vresult; }
static VALUE _wrap_new_FXGLContext__SWIG_1(int argc, VALUE *argv, VALUE self) { FXApp *arg1 = (FXApp *) 0 ;
    FXGLVisual *arg2 = (FXGLVisual *) 0 ; FXGLContext *arg3 = (FXGLContext *) 0 ; FXGLContext *result;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXApp, 1);
    SWIG_ConvertPtr(argv[1], (void **) &arg2, SWIGTYPE_p_FXGLVisual, 1);
    SWIG_ConvertPtr(argv[2], (void **) &arg3, SWIGTYPE_p_FXGLContext, 1); {
        result = (FXGLContext *)new_FXGLContext__SWIG_1(arg1,arg2,arg3);
        DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result); if(rb_block_given_p()){ rb_yield(self); }  }  return self; }
static VALUE _wrap_new_FXGLContext(int nargs, VALUE *args, VALUE self) { int argc; VALUE argv[3]; int ii; argc = nargs;
    for (ii = 0; (ii < argc) && (ii < 3); ii++) { argv[ii] = args[ii]; }  if (argc == 2) { int _v; { void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXApp, 0) != -1)) ? 1 : 0; }
         if (_v) { { void *ptr;
                _v = (NIL_P(argv[1]) || (TYPE(argv[1]) == T_DATA && SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_FXGLVisual, 0) != -1)) ? 1 : 0; }
             if (_v) { return _wrap_new_FXGLContext__SWIG_0(nargs, args, self);}  }  }  if (argc == 3) { int _v; { void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXApp, 0) != -1)) ? 1 : 0; }
         if (_v) { { void *ptr;
                _v = (NIL_P(argv[1]) || (TYPE(argv[1]) == T_DATA && SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_FXGLVisual, 0) != -1)) ? 1 : 0; }
             if (_v) { { void *ptr;
                    _v = (NIL_P(argv[2]) || (TYPE(argv[2]) == T_DATA && SWIG_ConvertPtr(argv[2], &ptr, SWIGTYPE_p_FXGLContext, 0) != -1)) ? 1 : 0; }
                 if (_v) { return _wrap_new_FXGLContext__SWIG_1(nargs, args, self);}  }  }  } 
    rb_raise(rb_eArgError, "No matching function for overloaded 'new_FXGLContext'"); return Qnil; }
static VALUE _wrap_FXGLContext_isShared(int argc, VALUE *argv, VALUE self) { FXGLContext *arg1 = (FXGLContext *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLContext, 1); result = (FXbool)((FXGLContext const *)arg1)->isShared();
    vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXGLContext_getVisual(int argc, VALUE *argv, VALUE self) { FXGLContext *arg1 = (FXGLContext *) 0 ;
    FXGLVisual *result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLContext, 1);
    result = (FXGLVisual *)((FXGLContext const *)arg1)->getVisual(); {
        swig_type_info *ty = SWIG_TypeDynamicCast(SWIGTYPE_p_FXGLVisual, (void **) &result);
        vresult = FXRbGetRubyObj(result, ty); }  return vresult; }
static VALUE _wrap_FXGLContext_begin(int argc, VALUE *argv, VALUE self) { FXGLContext *arg1 = (FXGLContext *) 0 ;
    FXDrawable *arg2 = (FXDrawable *) 0 ; FXbool result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLContext, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXDrawable, 1); result = (FXbool)(arg1)->begin(arg2);
    vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXGLContext_end(int argc, VALUE *argv, VALUE self) { FXGLContext *arg1 = (FXGLContext *) 0 ; FXbool result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLContext, 1); result = (FXbool)(arg1)->end();
    vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXGLContext_swapBuffers(int argc, VALUE *argv, VALUE self) { FXGLContext *arg1 = (FXGLContext *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLContext, 1); (arg1)->swapBuffers(); return Qnil; }
static VALUE _wrap_FXGLContext_swapSubBuffers(int argc, VALUE *argv, VALUE self) { FXGLContext *arg1 = (FXGLContext *) 0 ;
    FXint arg2 ; FXint arg3 ; FXint arg4 ; FXint arg5 ; if ((argc < 4) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLContext, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    arg4 = NUM2INT(argv[2]); arg5 = NUM2INT(argv[3]); (arg1)->swapSubBuffers(arg2,arg3,arg4,arg5); return Qnil; }
static void
free_FXGLContext(FXGLContext *arg1) {
    delete arg1;
}
static VALUE _wrap_FXGLContext_save(int argc, VALUE *argv, VALUE self) { FXGLContext *arg1 = (FXGLContext *) 0 ;
    FXStream *arg2 = 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLContext, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXGLContext_save((FXGLContext const *)arg1,*arg2); return Qnil; }
static VALUE _wrap_FXGLContext_load(int argc, VALUE *argv, VALUE self) { FXGLContext *arg1 = (FXGLContext *) 0 ;
    FXStream *arg2 = 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLContext, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXGLContext_load(arg1,*arg2); return Qnil; }
static VALUE _wrap_FXGLContext_create(int argc, VALUE *argv, VALUE self) { FXGLContext *arg1 = (FXGLContext *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLContext, 1); FXGLContext_create(arg1); return Qnil; }
static VALUE _wrap_FXGLContext_detach(int argc, VALUE *argv, VALUE self) { FXGLContext *arg1 = (FXGLContext *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLContext, 1); FXGLContext_detach(arg1); return Qnil; }
static VALUE _wrap_FXGLContext_destroy(int argc, VALUE *argv, VALUE self) { FXGLContext *arg1 = (FXGLContext *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLContext, 1); FXGLContext_destroy(arg1); return Qnil; }
static VALUE _wrap_new_FXGLCanvas__SWIG_0(int argc, VALUE *argv, VALUE self) { FXComposite *arg1 = (FXComposite *) 0 ;
    FXGLVisual *arg2 = (FXGLVisual *) 0 ; FXObject *arg3 = (FXObject *) 0 ; FXSelector arg4 = (FXSelector) 0 ;
    FXuint arg5 = (FXuint) 0 ; FXint arg6 = (FXint) 0 ; FXint arg7 = (FXint) 0 ; FXint arg8 = (FXint) 0 ;
    FXint arg9 = (FXint) 0 ; FXGLCanvas *result; if ((argc < 2) || (argc > 9))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXComposite, 1);
    SWIG_ConvertPtr(argv[1], (void **) &arg2, SWIGTYPE_p_FXGLVisual, 1); if (argc > 2) {
        SWIG_ConvertPtr(argv[2], (void **) &arg3, SWIGTYPE_p_FXObject, 1); }  if (argc > 3) { arg4 = NUM2UINT(argv[3]); } 
    if (argc > 4) { arg5 = NUM2UINT(argv[4]); }  if (argc > 5) { arg6 = NUM2INT(argv[5]); }  if (argc > 6) {
        arg7 = NUM2INT(argv[6]); }  if (argc > 7) { arg8 = NUM2INT(argv[7]); }  if (argc > 8) { arg9 = NUM2INT(argv[8]); }  {
        result = (FXGLCanvas *)new_FXGLCanvas__SWIG_0(arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8,arg9);
        DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result); if(rb_block_given_p()){ rb_yield(self); }  }  return self; }
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE _wrap_FXGLCanvas_allocate(VALUE self) {
#else
     static VALUE _wrap_FXGLCanvas_allocate(int argc, VALUE *argv, VALUE self) {
#endif
         VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_FXGLCanvas);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
         return vresult; }
static VALUE _wrap_new_FXGLCanvas__SWIG_1(int argc, VALUE *argv, VALUE self) { FXComposite *arg1 = (FXComposite *) 0 ;
    FXGLVisual *arg2 = (FXGLVisual *) 0 ; FXGLCanvas *arg3 = (FXGLCanvas *) 0 ; FXObject *arg4 = (FXObject *) 0 ;
    FXSelector arg5 = (FXSelector) 0 ; FXuint arg6 = (FXuint) 0 ; FXint arg7 = (FXint) 0 ; FXint arg8 = (FXint) 0 ;
    FXint arg9 = (FXint) 0 ; FXint arg10 = (FXint) 0 ; FXGLCanvas *result; if ((argc < 3) || (argc > 10))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXComposite, 1);
    SWIG_ConvertPtr(argv[1], (void **) &arg2, SWIGTYPE_p_FXGLVisual, 1);
    SWIG_ConvertPtr(argv[2], (void **) &arg3, SWIGTYPE_p_FXGLCanvas, 1); if (argc > 3) {
        SWIG_ConvertPtr(argv[3], (void **) &arg4, SWIGTYPE_p_FXObject, 1); }  if (argc > 4) { arg5 = NUM2UINT(argv[4]); } 
    if (argc > 5) { arg6 = NUM2UINT(argv[5]); }  if (argc > 6) { arg7 = NUM2INT(argv[6]); }  if (argc > 7) {
        arg8 = NUM2INT(argv[7]); }  if (argc > 8) { arg9 = NUM2INT(argv[8]); }  if (argc > 9) { arg10 = NUM2INT(argv[9]); }  {
        result = (FXGLCanvas *)new_FXGLCanvas__SWIG_1(arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8,arg9,arg10);
        DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result); if(rb_block_given_p()){ rb_yield(self); }  }  return self; }
static VALUE _wrap_new_FXGLCanvas(int nargs, VALUE *args, VALUE self) { int argc; VALUE argv[10]; int ii; argc = nargs;
    for (ii = 0; (ii < argc) && (ii < 10); ii++) { argv[ii] = args[ii]; }  if ((argc >= 2) && (argc <= 9)) { int _v; {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXComposite, 0) != -1)) ? 1 : 0; }
         if (_v) { { void *ptr;
                _v = (NIL_P(argv[1]) || (TYPE(argv[1]) == T_DATA && SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_FXGLVisual, 0) != -1)) ? 1 : 0; }
             if (_v) { if (argc <= 2) { return _wrap_new_FXGLCanvas__SWIG_0(nargs, args, self);}  { void *ptr;
                    _v = (NIL_P(argv[2]) || (TYPE(argv[2]) == T_DATA && SWIG_ConvertPtr(argv[2], &ptr, SWIGTYPE_p_FXObject, 0) != -1)) ? 1 : 0; }
                 if (_v) { if (argc <= 3) { return _wrap_new_FXGLCanvas__SWIG_0(nargs, args, self);}  {
                        _v = ((TYPE(argv[3]) == T_FIXNUM) || (TYPE(argv[3]) == T_BIGNUM)) ? 1 : 0; }  if (_v) { if (argc <= 4) {
                            return _wrap_new_FXGLCanvas__SWIG_0(nargs, args, self);}  {
                            _v = ((TYPE(argv[4]) == T_FIXNUM) || (TYPE(argv[4]) == T_BIGNUM)) ? 1 : 0; }  if (_v) {
                            if (argc <= 5) { return _wrap_new_FXGLCanvas__SWIG_0(nargs, args, self);}  {
                                _v = ((TYPE(argv[5]) == T_FIXNUM) || (TYPE(argv[5]) == T_BIGNUM)) ? 1 : 0; }  if (_v) {
                                if (argc <= 6) { return _wrap_new_FXGLCanvas__SWIG_0(nargs, args, self);}  {
                                    _v = ((TYPE(argv[6]) == T_FIXNUM) || (TYPE(argv[6]) == T_BIGNUM)) ? 1 : 0; }  if (_v) {
                                    if (argc <= 7) { return _wrap_new_FXGLCanvas__SWIG_0(nargs, args, self);}  {
                                        _v = ((TYPE(argv[7]) == T_FIXNUM) || (TYPE(argv[7]) == T_BIGNUM)) ? 1 : 0; }  if (_v) {
                                        if (argc <= 8) { return _wrap_new_FXGLCanvas__SWIG_0(nargs, args, self);}  {
                                            _v = ((TYPE(argv[8]) == T_FIXNUM) || (TYPE(argv[8]) == T_BIGNUM)) ? 1 : 0; } 
                                        if (_v) { return _wrap_new_FXGLCanvas__SWIG_0(nargs, args, self);}  }  }  }  }  }  }  }
             }  }  if ((argc >= 3) && (argc <= 10)) { int _v; { void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXComposite, 0) != -1)) ? 1 : 0; }
         if (_v) { { void *ptr;
                _v = (NIL_P(argv[1]) || (TYPE(argv[1]) == T_DATA && SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_FXGLVisual, 0) != -1)) ? 1 : 0; }
             if (_v) { { void *ptr;
                    _v = (NIL_P(argv[2]) || (TYPE(argv[2]) == T_DATA && SWIG_ConvertPtr(argv[2], &ptr, SWIGTYPE_p_FXGLCanvas, 0) != -1)) ? 1 : 0; }
                 if (_v) { if (argc <= 3) { return _wrap_new_FXGLCanvas__SWIG_1(nargs, args, self);}  { void *ptr;
                        _v = (NIL_P(argv[3]) || (TYPE(argv[3]) == T_DATA && SWIG_ConvertPtr(argv[3], &ptr, SWIGTYPE_p_FXObject, 0) != -1)) ? 1 : 0; }
                     if (_v) { if (argc <= 4) { return _wrap_new_FXGLCanvas__SWIG_1(nargs, args, self);}  {
                            _v = ((TYPE(argv[4]) == T_FIXNUM) || (TYPE(argv[4]) == T_BIGNUM)) ? 1 : 0; }  if (_v) {
                            if (argc <= 5) { return _wrap_new_FXGLCanvas__SWIG_1(nargs, args, self);}  {
                                _v = ((TYPE(argv[5]) == T_FIXNUM) || (TYPE(argv[5]) == T_BIGNUM)) ? 1 : 0; }  if (_v) {
                                if (argc <= 6) { return _wrap_new_FXGLCanvas__SWIG_1(nargs, args, self);}  {
                                    _v = ((TYPE(argv[6]) == T_FIXNUM) || (TYPE(argv[6]) == T_BIGNUM)) ? 1 : 0; }  if (_v) {
                                    if (argc <= 7) { return _wrap_new_FXGLCanvas__SWIG_1(nargs, args, self);}  {
                                        _v = ((TYPE(argv[7]) == T_FIXNUM) || (TYPE(argv[7]) == T_BIGNUM)) ? 1 : 0; }  if (_v) {
                                        if (argc <= 8) { return _wrap_new_FXGLCanvas__SWIG_1(nargs, args, self);}  {
                                            _v = ((TYPE(argv[8]) == T_FIXNUM) || (TYPE(argv[8]) == T_BIGNUM)) ? 1 : 0; } 
                                        if (_v) { if (argc <= 9) { return _wrap_new_FXGLCanvas__SWIG_1(nargs, args, self);}  {
                                                _v = ((TYPE(argv[9]) == T_FIXNUM) || (TYPE(argv[9]) == T_BIGNUM)) ? 1 : 0; } 
                                            if (_v) { return _wrap_new_FXGLCanvas__SWIG_1(nargs, args, self);}  }  }  }  }  }  }
                     }  }  }  }  rb_raise(rb_eArgError, "No matching function for overloaded 'new_FXGLCanvas'"); return Qnil; }
static VALUE _wrap_FXGLCanvas_isShared(int argc, VALUE *argv, VALUE self) { FXGLCanvas *arg1 = (FXGLCanvas *) 0 ; FXbool result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLCanvas, 1); result = (FXbool)((FXGLCanvas const *)arg1)->isShared();
    vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXGLCanvas_getCurrentContext(int argc, VALUE *argv, VALUE self) { unsigned long result; VALUE vresult = Qnil;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    result = (unsigned long)FXGLCanvas_getCurrentContext(); vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXGLCanvas_getContext(int argc, VALUE *argv, VALUE self) { FXGLCanvas *arg1 = (FXGLCanvas *) 0 ;
    unsigned long result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLCanvas, 1);
    result = (unsigned long)FXGLCanvas_getContext((FXGLCanvas const *)arg1); vresult = UINT2NUM(result); return vresult; }
static void
free_FXGLCanvas(FXGLCanvas *arg1) {
    delete arg1;
}
static VALUE _wrap_FXGLCanvas_save(int argc, VALUE *argv, VALUE self) { FXGLCanvas *arg1 = (FXGLCanvas *) 0 ;
    FXStream *arg2 = 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLCanvas, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXGLCanvas_save((FXGLCanvas const *)arg1,*arg2); return Qnil; }
static VALUE _wrap_FXGLCanvas_load(int argc, VALUE *argv, VALUE self) { FXGLCanvas *arg1 = (FXGLCanvas *) 0 ;
    FXStream *arg2 = 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLCanvas, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXGLCanvas_load(arg1,*arg2); return Qnil; }
static VALUE _wrap_FXGLCanvas_create(int argc, VALUE *argv, VALUE self) { FXGLCanvas *arg1 = (FXGLCanvas *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLCanvas, 1); FXGLCanvas_create(arg1); return Qnil; }
static VALUE _wrap_FXGLCanvas_detach(int argc, VALUE *argv, VALUE self) { FXGLCanvas *arg1 = (FXGLCanvas *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLCanvas, 1); FXGLCanvas_detach(arg1); return Qnil; }
static VALUE _wrap_FXGLCanvas_destroy(int argc, VALUE *argv, VALUE self) { FXGLCanvas *arg1 = (FXGLCanvas *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLCanvas, 1); FXGLCanvas_destroy(arg1); return Qnil; }
static VALUE _wrap_FXGLCanvas_resize(int argc, VALUE *argv, VALUE self) { FXGLCanvas *arg1 = (FXGLCanvas *) 0 ; FXint arg2 ;
    FXint arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLCanvas, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    FXGLCanvas_resize(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXGLCanvas_getDefaultWidth(int argc, VALUE *argv, VALUE self) { FXGLCanvas *arg1 = (FXGLCanvas *) 0 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLCanvas, 1); result = (FXint)FXGLCanvas_getDefaultWidth(arg1);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXGLCanvas_getDefaultHeight(int argc, VALUE *argv, VALUE self) { FXGLCanvas *arg1 = (FXGLCanvas *) 0 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLCanvas, 1); result = (FXint)FXGLCanvas_getDefaultHeight(arg1);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXGLCanvas_getWidthForHeight(int argc, VALUE *argv, VALUE self) { FXGLCanvas *arg1 = (FXGLCanvas *) 0 ;
    FXint arg2 ; FXint result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLCanvas, 1); arg2 = NUM2INT(argv[0]);
    result = (FXint)FXGLCanvas_getWidthForHeight(arg1,arg2); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXGLCanvas_getHeightForWidth(int argc, VALUE *argv, VALUE self) { FXGLCanvas *arg1 = (FXGLCanvas *) 0 ;
    FXint arg2 ; FXint result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLCanvas, 1); arg2 = NUM2INT(argv[0]);
    result = (FXint)FXGLCanvas_getHeightForWidth(arg1,arg2); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXGLCanvas_canFocus(int argc, VALUE *argv, VALUE self) { FXGLCanvas *arg1 = (FXGLCanvas *) 0 ; FXbool result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLCanvas, 1);
    result = (FXbool)FXGLCanvas_canFocus((FXGLCanvas const *)arg1); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXGLCanvas_setFocus(int argc, VALUE *argv, VALUE self) { FXGLCanvas *arg1 = (FXGLCanvas *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLCanvas, 1); FXGLCanvas_setFocus(arg1); return Qnil; }
static VALUE _wrap_FXGLCanvas_killFocus(int argc, VALUE *argv, VALUE self) { FXGLCanvas *arg1 = (FXGLCanvas *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLCanvas, 1); FXGLCanvas_killFocus(arg1); return Qnil; }
static VALUE _wrap_FXGLCanvas_setDefault(int argc, VALUE *argv, VALUE self) { FXGLCanvas *arg1 = (FXGLCanvas *) 0 ;
    FXbool arg2 = (FXbool) 1 ; if ((argc < 0) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLCanvas, 1); if (argc > 0) { arg2 = to_FXbool(argv[0]); } 
    FXGLCanvas_setDefault(arg1,arg2); return Qnil; }
static VALUE _wrap_FXGLCanvas_enable(int argc, VALUE *argv, VALUE self) { FXGLCanvas *arg1 = (FXGLCanvas *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLCanvas, 1); FXGLCanvas_enable(arg1); return Qnil; }
static VALUE _wrap_FXGLCanvas_disable(int argc, VALUE *argv, VALUE self) { FXGLCanvas *arg1 = (FXGLCanvas *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLCanvas, 1); FXGLCanvas_disable(arg1); return Qnil; }
static VALUE _wrap_FXGLCanvas_raiseWindow(int argc, VALUE *argv, VALUE self) { FXGLCanvas *arg1 = (FXGLCanvas *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLCanvas, 1); FXGLCanvas_raise(arg1); return Qnil; }
static VALUE _wrap_FXGLCanvas_lower(int argc, VALUE *argv, VALUE self) { FXGLCanvas *arg1 = (FXGLCanvas *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLCanvas, 1); FXGLCanvas_lower(arg1); return Qnil; }
static VALUE _wrap_FXGLCanvas_move(int argc, VALUE *argv, VALUE self) { FXGLCanvas *arg1 = (FXGLCanvas *) 0 ; FXint arg2 ;
    FXint arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLCanvas, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    FXGLCanvas_move(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXGLCanvas_position(int argc, VALUE *argv, VALUE self) { FXGLCanvas *arg1 = (FXGLCanvas *) 0 ; FXint arg2 ;
    FXint arg3 ; FXint arg4 ; FXint arg5 ; if ((argc < 4) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLCanvas, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    arg4 = NUM2INT(argv[2]); arg5 = NUM2INT(argv[3]); FXGLCanvas_position(arg1,arg2,arg3,arg4,arg5); return Qnil; }
static VALUE _wrap_FXGLCanvas_layout(int argc, VALUE *argv, VALUE self) { FXGLCanvas *arg1 = (FXGLCanvas *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLCanvas, 1); FXGLCanvas_layout(arg1); return Qnil; }
static VALUE _wrap_FXGLCanvas_recalc(int argc, VALUE *argv, VALUE self) { FXGLCanvas *arg1 = (FXGLCanvas *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLCanvas, 1); FXGLCanvas_recalc(arg1); return Qnil; }
static VALUE _wrap_FXGLCanvas_reparent(int argc, VALUE *argv, VALUE self) { FXGLCanvas *arg1 = (FXGLCanvas *) 0 ;
    FXComposite *arg2 = (FXComposite *) 0 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLCanvas, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXComposite, 1); FXGLCanvas_reparent(arg1,arg2); return Qnil; }
static VALUE _wrap_FXGLCanvas_show(int argc, VALUE *argv, VALUE self) { FXGLCanvas *arg1 = (FXGLCanvas *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLCanvas, 1); FXGLCanvas_show(arg1); return Qnil; }
static VALUE _wrap_FXGLCanvas_hide(int argc, VALUE *argv, VALUE self) { FXGLCanvas *arg1 = (FXGLCanvas *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLCanvas, 1); FXGLCanvas_hide(arg1); return Qnil; }
static VALUE _wrap_FXGLCanvas_isComposite(int argc, VALUE *argv, VALUE self) { FXGLCanvas *arg1 = (FXGLCanvas *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLCanvas, 1);
    result = (FXbool)FXGLCanvas_isComposite((FXGLCanvas const *)arg1); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXGLCanvas_contains(int argc, VALUE *argv, VALUE self) { FXGLCanvas *arg1 = (FXGLCanvas *) 0 ; FXint arg2 ;
    FXint arg3 ; FXbool result; VALUE vresult = Qnil; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLCanvas, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    result = (FXbool)FXGLCanvas_contains((FXGLCanvas const *)arg1,arg2,arg3); vresult = result ? Qtrue : Qfalse;
    return vresult; }
static VALUE _wrap_FXGLCanvas_doesSaveUnder(int argc, VALUE *argv, VALUE self) { FXGLCanvas *arg1 = (FXGLCanvas *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLCanvas, 1);
    result = (FXbool)FXGLCanvas_doesSaveUnder((FXGLCanvas const *)arg1); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXGLCanvas_setBackColor(int argc, VALUE *argv, VALUE self) { FXGLCanvas *arg1 = (FXGLCanvas *) 0 ;
    FXColor arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLCanvas, 1); arg2 = to_FXColor(argv[0]);
    FXGLCanvas_setBackColor(arg1,arg2); return Qnil; }
static VALUE _wrap_FXGLCanvas_makeCurrent(int argc, VALUE *argv, VALUE self) { FXGLCanvas *arg1 = (FXGLCanvas *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLCanvas, 1); result = (FXbool)FXGLCanvas_makeCurrent(arg1);
    vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXGLCanvas_makeNonCurrent(int argc, VALUE *argv, VALUE self) { FXGLCanvas *arg1 = (FXGLCanvas *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLCanvas, 1); result = (FXbool)FXGLCanvas_makeNonCurrent(arg1);
    vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXGLCanvas_isCurrent(int argc, VALUE *argv, VALUE self) { FXGLCanvas *arg1 = (FXGLCanvas *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLCanvas, 1);
    result = (FXbool)FXGLCanvas_isCurrent((FXGLCanvas const *)arg1); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXGLCanvas_swapBuffers(int argc, VALUE *argv, VALUE self) { FXGLCanvas *arg1 = (FXGLCanvas *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLCanvas, 1); FXGLCanvas_swapBuffers(arg1); return Qnil; }
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE _wrap_FXViewport_allocate(VALUE self) {
#else
     static VALUE _wrap_FXViewport_allocate(int argc, VALUE *argv, VALUE self) {
#endif
         VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_FXViewport);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
         return vresult; }
static VALUE _wrap_new_FXViewport(int argc, VALUE *argv, VALUE self) { FXViewport *result; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc); result = (FXViewport *)new FXViewport();
    DATA_PTR(self) = result; return self; }
static VALUE _wrap_FXViewport_w_set(int argc, VALUE *argv, VALUE self) { FXViewport *arg1 = (FXViewport *) 0 ; FXint arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXViewport, 1); arg2 = NUM2INT(argv[0]); if (arg1) (arg1)->w = arg2;
    return Qnil; }
static VALUE _wrap_FXViewport_w_get(int argc, VALUE *argv, VALUE self) { FXViewport *arg1 = (FXViewport *) 0 ; FXint result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXViewport, 1); result = (FXint) ((arg1)->w); vresult = INT2NUM(result);
    return vresult; }
static VALUE _wrap_FXViewport_h_set(int argc, VALUE *argv, VALUE self) { FXViewport *arg1 = (FXViewport *) 0 ; FXint arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXViewport, 1); arg2 = NUM2INT(argv[0]); if (arg1) (arg1)->h = arg2;
    return Qnil; }
static VALUE _wrap_FXViewport_h_get(int argc, VALUE *argv, VALUE self) { FXViewport *arg1 = (FXViewport *) 0 ; FXint result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXViewport, 1); result = (FXint) ((arg1)->h); vresult = INT2NUM(result);
    return vresult; }
static VALUE _wrap_FXViewport_left_set(int argc, VALUE *argv, VALUE self) { FXViewport *arg1 = (FXViewport *) 0 ;
    FXdouble arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXViewport, 1); arg2 = (FXdouble) NUM2DBL(argv[0]);
    if (arg1) (arg1)->left = arg2; return Qnil; }
static VALUE _wrap_FXViewport_left_get(int argc, VALUE *argv, VALUE self) { FXViewport *arg1 = (FXViewport *) 0 ;
    FXdouble result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXViewport, 1); result = (FXdouble) ((arg1)->left);
    vresult = rb_float_new(result); return vresult; }
static VALUE _wrap_FXViewport_right_set(int argc, VALUE *argv, VALUE self) { FXViewport *arg1 = (FXViewport *) 0 ;
    FXdouble arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXViewport, 1); arg2 = (FXdouble) NUM2DBL(argv[0]);
    if (arg1) (arg1)->right = arg2; return Qnil; }
static VALUE _wrap_FXViewport_right_get(int argc, VALUE *argv, VALUE self) { FXViewport *arg1 = (FXViewport *) 0 ;
    FXdouble result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXViewport, 1); result = (FXdouble) ((arg1)->right);
    vresult = rb_float_new(result); return vresult; }
static VALUE _wrap_FXViewport_bottom_set(int argc, VALUE *argv, VALUE self) { FXViewport *arg1 = (FXViewport *) 0 ;
    FXdouble arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXViewport, 1); arg2 = (FXdouble) NUM2DBL(argv[0]);
    if (arg1) (arg1)->bottom = arg2; return Qnil; }
static VALUE _wrap_FXViewport_bottom_get(int argc, VALUE *argv, VALUE self) { FXViewport *arg1 = (FXViewport *) 0 ;
    FXdouble result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXViewport, 1); result = (FXdouble) ((arg1)->bottom);
    vresult = rb_float_new(result); return vresult; }
static VALUE _wrap_FXViewport_top_set(int argc, VALUE *argv, VALUE self) { FXViewport *arg1 = (FXViewport *) 0 ; FXdouble arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXViewport, 1); arg2 = (FXdouble) NUM2DBL(argv[0]);
    if (arg1) (arg1)->top = arg2; return Qnil; }
static VALUE _wrap_FXViewport_top_get(int argc, VALUE *argv, VALUE self) { FXViewport *arg1 = (FXViewport *) 0 ;
    FXdouble result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXViewport, 1); result = (FXdouble) ((arg1)->top);
    vresult = rb_float_new(result); return vresult; }
static VALUE _wrap_FXViewport_hither_set(int argc, VALUE *argv, VALUE self) { FXViewport *arg1 = (FXViewport *) 0 ;
    FXdouble arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXViewport, 1); arg2 = (FXdouble) NUM2DBL(argv[0]);
    if (arg1) (arg1)->hither = arg2; return Qnil; }
static VALUE _wrap_FXViewport_hither_get(int argc, VALUE *argv, VALUE self) { FXViewport *arg1 = (FXViewport *) 0 ;
    FXdouble result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXViewport, 1); result = (FXdouble) ((arg1)->hither);
    vresult = rb_float_new(result); return vresult; }
static VALUE _wrap_FXViewport_yon_set(int argc, VALUE *argv, VALUE self) { FXViewport *arg1 = (FXViewport *) 0 ; FXdouble arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXViewport, 1); arg2 = (FXdouble) NUM2DBL(argv[0]);
    if (arg1) (arg1)->yon = arg2; return Qnil; }
static VALUE _wrap_FXViewport_yon_get(int argc, VALUE *argv, VALUE self) { FXViewport *arg1 = (FXViewport *) 0 ;
    FXdouble result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXViewport, 1); result = (FXdouble) ((arg1)->yon);
    vresult = rb_float_new(result); return vresult; }
static void
free_FXViewport(FXViewport *arg1) {
    delete arg1;
}
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE _wrap_FXLight_allocate(VALUE self) {
#else
     static VALUE _wrap_FXLight_allocate(int argc, VALUE *argv, VALUE self) {
#endif
         VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_FXLight);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
         return vresult; }
static VALUE _wrap_new_FXLight(int argc, VALUE *argv, VALUE self) { FXLight *result; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc); result = (FXLight *)new FXLight(); DATA_PTR(self) = result;
    return self; }
static VALUE _wrap_FXLight_ambient_set(int argc, VALUE *argv, VALUE self) { FXLight *arg1 = (FXLight *) 0 ;
    FXVec4f *arg2 = (FXVec4f *) 0 ; FXVec4f tmp2 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXLight, 1); { if (TYPE(argv[0]) == T_ARRAY) {
            tmp2 = FXVec4f(NUM2DBL(rb_ary_entry(argv[0], 0)), NUM2DBL(rb_ary_entry(argv[0], 1)), NUM2DBL(rb_ary_entry(argv[0], 2)), NUM2DBL(rb_ary_entry(argv[0], 3)));
            arg2 = &tmp2; }  else { SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXVec4f, 1); }  } 
    if (arg1) (arg1)->ambient = *arg2; return Qnil; }
static VALUE _wrap_FXLight_ambient_get(int argc, VALUE *argv, VALUE self) { FXLight *arg1 = (FXLight *) 0 ; FXVec4f *result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXLight, 1); result = (FXVec4f *)& ((arg1)->ambient);
    vresult = FXRbGetRubyObj(result, "FXVec4f *"); return vresult; }
static VALUE _wrap_FXLight_diffuse_set(int argc, VALUE *argv, VALUE self) { FXLight *arg1 = (FXLight *) 0 ;
    FXVec4f *arg2 = (FXVec4f *) 0 ; FXVec4f tmp2 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXLight, 1); { if (TYPE(argv[0]) == T_ARRAY) {
            tmp2 = FXVec4f(NUM2DBL(rb_ary_entry(argv[0], 0)), NUM2DBL(rb_ary_entry(argv[0], 1)), NUM2DBL(rb_ary_entry(argv[0], 2)), NUM2DBL(rb_ary_entry(argv[0], 3)));
            arg2 = &tmp2; }  else { SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXVec4f, 1); }  } 
    if (arg1) (arg1)->diffuse = *arg2; return Qnil; }
static VALUE _wrap_FXLight_diffuse_get(int argc, VALUE *argv, VALUE self) { FXLight *arg1 = (FXLight *) 0 ; FXVec4f *result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXLight, 1); result = (FXVec4f *)& ((arg1)->diffuse);
    vresult = FXRbGetRubyObj(result, "FXVec4f *"); return vresult; }
static VALUE _wrap_FXLight_specular_set(int argc, VALUE *argv, VALUE self) { FXLight *arg1 = (FXLight *) 0 ;
    FXVec4f *arg2 = (FXVec4f *) 0 ; FXVec4f tmp2 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXLight, 1); { if (TYPE(argv[0]) == T_ARRAY) {
            tmp2 = FXVec4f(NUM2DBL(rb_ary_entry(argv[0], 0)), NUM2DBL(rb_ary_entry(argv[0], 1)), NUM2DBL(rb_ary_entry(argv[0], 2)), NUM2DBL(rb_ary_entry(argv[0], 3)));
            arg2 = &tmp2; }  else { SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXVec4f, 1); }  } 
    if (arg1) (arg1)->specular = *arg2; return Qnil; }
static VALUE _wrap_FXLight_specular_get(int argc, VALUE *argv, VALUE self) { FXLight *arg1 = (FXLight *) 0 ; FXVec4f *result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXLight, 1); result = (FXVec4f *)& ((arg1)->specular);
    vresult = FXRbGetRubyObj(result, "FXVec4f *"); return vresult; }
static VALUE _wrap_FXLight_position_set(int argc, VALUE *argv, VALUE self) { FXLight *arg1 = (FXLight *) 0 ;
    FXVec4f *arg2 = (FXVec4f *) 0 ; FXVec4f tmp2 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXLight, 1); { if (TYPE(argv[0]) == T_ARRAY) {
            tmp2 = FXVec4f(NUM2DBL(rb_ary_entry(argv[0], 0)), NUM2DBL(rb_ary_entry(argv[0], 1)), NUM2DBL(rb_ary_entry(argv[0], 2)), NUM2DBL(rb_ary_entry(argv[0], 3)));
            arg2 = &tmp2; }  else { SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXVec4f, 1); }  } 
    if (arg1) (arg1)->position = *arg2; return Qnil; }
static VALUE _wrap_FXLight_position_get(int argc, VALUE *argv, VALUE self) { FXLight *arg1 = (FXLight *) 0 ; FXVec4f *result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXLight, 1); result = (FXVec4f *)& ((arg1)->position);
    vresult = FXRbGetRubyObj(result, "FXVec4f *"); return vresult; }
static VALUE _wrap_FXLight_direction_set(int argc, VALUE *argv, VALUE self) { FXLight *arg1 = (FXLight *) 0 ;
    FXVec3f *arg2 = (FXVec3f *) 0 ; FXVec3f tmp2 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXLight, 1); { if (TYPE(argv[0]) == T_ARRAY) {
            tmp2 = FXVec3f(NUM2DBL(rb_ary_entry(argv[0], 0)), NUM2DBL(rb_ary_entry(argv[0], 1)), NUM2DBL(rb_ary_entry(argv[0], 2)));
            arg2 = &tmp2; }  else { SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXVec3f, 1); }  } 
    if (arg1) (arg1)->direction = *arg2; return Qnil; }
static VALUE _wrap_FXLight_direction_get(int argc, VALUE *argv, VALUE self) { FXLight *arg1 = (FXLight *) 0 ; FXVec3f *result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXLight, 1); result = (FXVec3f *)& ((arg1)->direction);
    vresult = FXRbGetRubyObj(result, "FXVec3f *"); return vresult; }
static VALUE _wrap_FXLight_exponent_set(int argc, VALUE *argv, VALUE self) { FXLight *arg1 = (FXLight *) 0 ; FXfloat arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXLight, 1); arg2 = (FXfloat) NUM2DBL(argv[0]);
    if (arg1) (arg1)->exponent = arg2; return Qnil; }
static VALUE _wrap_FXLight_exponent_get(int argc, VALUE *argv, VALUE self) { FXLight *arg1 = (FXLight *) 0 ; FXfloat result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXLight, 1); result = (FXfloat) ((arg1)->exponent);
    vresult = rb_float_new(result); return vresult; }
static VALUE _wrap_FXLight_cutoff_set(int argc, VALUE *argv, VALUE self) { FXLight *arg1 = (FXLight *) 0 ; FXfloat arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXLight, 1); arg2 = (FXfloat) NUM2DBL(argv[0]);
    if (arg1) (arg1)->cutoff = arg2; return Qnil; }
static VALUE _wrap_FXLight_cutoff_get(int argc, VALUE *argv, VALUE self) { FXLight *arg1 = (FXLight *) 0 ; FXfloat result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXLight, 1); result = (FXfloat) ((arg1)->cutoff);
    vresult = rb_float_new(result); return vresult; }
static VALUE _wrap_FXLight_c_attn_set(int argc, VALUE *argv, VALUE self) { FXLight *arg1 = (FXLight *) 0 ; FXfloat arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXLight, 1); arg2 = (FXfloat) NUM2DBL(argv[0]);
    if (arg1) (arg1)->c_attn = arg2; return Qnil; }
static VALUE _wrap_FXLight_c_attn_get(int argc, VALUE *argv, VALUE self) { FXLight *arg1 = (FXLight *) 0 ; FXfloat result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXLight, 1); result = (FXfloat) ((arg1)->c_attn);
    vresult = rb_float_new(result); return vresult; }
static VALUE _wrap_FXLight_l_attn_set(int argc, VALUE *argv, VALUE self) { FXLight *arg1 = (FXLight *) 0 ; FXfloat arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXLight, 1); arg2 = (FXfloat) NUM2DBL(argv[0]);
    if (arg1) (arg1)->l_attn = arg2; return Qnil; }
static VALUE _wrap_FXLight_l_attn_get(int argc, VALUE *argv, VALUE self) { FXLight *arg1 = (FXLight *) 0 ; FXfloat result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXLight, 1); result = (FXfloat) ((arg1)->l_attn);
    vresult = rb_float_new(result); return vresult; }
static VALUE _wrap_FXLight_q_attn_set(int argc, VALUE *argv, VALUE self) { FXLight *arg1 = (FXLight *) 0 ; FXfloat arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXLight, 1); arg2 = (FXfloat) NUM2DBL(argv[0]);
    if (arg1) (arg1)->q_attn = arg2; return Qnil; }
static VALUE _wrap_FXLight_q_attn_get(int argc, VALUE *argv, VALUE self) { FXLight *arg1 = (FXLight *) 0 ; FXfloat result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXLight, 1); result = (FXfloat) ((arg1)->q_attn);
    vresult = rb_float_new(result); return vresult; }
static void
free_FXLight(FXLight *arg1) {
    delete arg1;
}
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE _wrap_FXMaterial_allocate(VALUE self) {
#else
     static VALUE _wrap_FXMaterial_allocate(int argc, VALUE *argv, VALUE self) {
#endif
         VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_FXMaterial);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
         return vresult; }
static VALUE _wrap_new_FXMaterial(int argc, VALUE *argv, VALUE self) { FXMaterial *result; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc); result = (FXMaterial *)new FXMaterial();
    DATA_PTR(self) = result; return self; }
static VALUE _wrap_FXMaterial_ambient_set(int argc, VALUE *argv, VALUE self) { FXMaterial *arg1 = (FXMaterial *) 0 ;
    FXVec4f *arg2 = (FXVec4f *) 0 ; FXVec4f tmp2 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMaterial, 1); { if (TYPE(argv[0]) == T_ARRAY) {
            tmp2 = FXVec4f(NUM2DBL(rb_ary_entry(argv[0], 0)), NUM2DBL(rb_ary_entry(argv[0], 1)), NUM2DBL(rb_ary_entry(argv[0], 2)), NUM2DBL(rb_ary_entry(argv[0], 3)));
            arg2 = &tmp2; }  else { SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXVec4f, 1); }  } 
    if (arg1) (arg1)->ambient = *arg2; return Qnil; }
static VALUE _wrap_FXMaterial_ambient_get(int argc, VALUE *argv, VALUE self) { FXMaterial *arg1 = (FXMaterial *) 0 ;
    FXVec4f *result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMaterial, 1); result = (FXVec4f *)& ((arg1)->ambient);
    vresult = FXRbGetRubyObj(result, "FXVec4f *"); return vresult; }
static VALUE _wrap_FXMaterial_diffuse_set(int argc, VALUE *argv, VALUE self) { FXMaterial *arg1 = (FXMaterial *) 0 ;
    FXVec4f *arg2 = (FXVec4f *) 0 ; FXVec4f tmp2 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMaterial, 1); { if (TYPE(argv[0]) == T_ARRAY) {
            tmp2 = FXVec4f(NUM2DBL(rb_ary_entry(argv[0], 0)), NUM2DBL(rb_ary_entry(argv[0], 1)), NUM2DBL(rb_ary_entry(argv[0], 2)), NUM2DBL(rb_ary_entry(argv[0], 3)));
            arg2 = &tmp2; }  else { SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXVec4f, 1); }  } 
    if (arg1) (arg1)->diffuse = *arg2; return Qnil; }
static VALUE _wrap_FXMaterial_diffuse_get(int argc, VALUE *argv, VALUE self) { FXMaterial *arg1 = (FXMaterial *) 0 ;
    FXVec4f *result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMaterial, 1); result = (FXVec4f *)& ((arg1)->diffuse);
    vresult = FXRbGetRubyObj(result, "FXVec4f *"); return vresult; }
static VALUE _wrap_FXMaterial_specular_set(int argc, VALUE *argv, VALUE self) { FXMaterial *arg1 = (FXMaterial *) 0 ;
    FXVec4f *arg2 = (FXVec4f *) 0 ; FXVec4f tmp2 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMaterial, 1); { if (TYPE(argv[0]) == T_ARRAY) {
            tmp2 = FXVec4f(NUM2DBL(rb_ary_entry(argv[0], 0)), NUM2DBL(rb_ary_entry(argv[0], 1)), NUM2DBL(rb_ary_entry(argv[0], 2)), NUM2DBL(rb_ary_entry(argv[0], 3)));
            arg2 = &tmp2; }  else { SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXVec4f, 1); }  } 
    if (arg1) (arg1)->specular = *arg2; return Qnil; }
static VALUE _wrap_FXMaterial_specular_get(int argc, VALUE *argv, VALUE self) { FXMaterial *arg1 = (FXMaterial *) 0 ;
    FXVec4f *result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMaterial, 1); result = (FXVec4f *)& ((arg1)->specular);
    vresult = FXRbGetRubyObj(result, "FXVec4f *"); return vresult; }
static VALUE _wrap_FXMaterial_emission_set(int argc, VALUE *argv, VALUE self) { FXMaterial *arg1 = (FXMaterial *) 0 ;
    FXVec4f *arg2 = (FXVec4f *) 0 ; FXVec4f tmp2 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMaterial, 1); { if (TYPE(argv[0]) == T_ARRAY) {
            tmp2 = FXVec4f(NUM2DBL(rb_ary_entry(argv[0], 0)), NUM2DBL(rb_ary_entry(argv[0], 1)), NUM2DBL(rb_ary_entry(argv[0], 2)), NUM2DBL(rb_ary_entry(argv[0], 3)));
            arg2 = &tmp2; }  else { SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXVec4f, 1); }  } 
    if (arg1) (arg1)->emission = *arg2; return Qnil; }
static VALUE _wrap_FXMaterial_emission_get(int argc, VALUE *argv, VALUE self) { FXMaterial *arg1 = (FXMaterial *) 0 ;
    FXVec4f *result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMaterial, 1); result = (FXVec4f *)& ((arg1)->emission);
    vresult = FXRbGetRubyObj(result, "FXVec4f *"); return vresult; }
static VALUE _wrap_FXMaterial_shininess_set(int argc, VALUE *argv, VALUE self) { FXMaterial *arg1 = (FXMaterial *) 0 ;
    FXfloat arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMaterial, 1); arg2 = (FXfloat) NUM2DBL(argv[0]);
    if (arg1) (arg1)->shininess = arg2; return Qnil; }
static VALUE _wrap_FXMaterial_shininess_get(int argc, VALUE *argv, VALUE self) { FXMaterial *arg1 = (FXMaterial *) 0 ;
    FXfloat result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMaterial, 1); result = (FXfloat) ((arg1)->shininess);
    vresult = rb_float_new(result); return vresult; }
static void
free_FXMaterial(FXMaterial *arg1) {
    delete arg1;
}
static VALUE FXGLViewer_objectType_get(VALUE self) { VALUE _val; _val = UINT2NUM(FXGLViewer::objectType);    return _val; }
static VALUE FXGLViewer_objectType_set(VALUE self, VALUE _val) { FXGLViewer::objectType = NUM2UINT(_val); return _val; }
static VALUE _wrap_FXGLViewer_onPaint(int argc, VALUE *argv, VALUE self) { FXGLViewer *arg1 = (FXGLViewer *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLViewer, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onPaint(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXGLViewer_onEnter(int argc, VALUE *argv, VALUE self) { FXGLViewer *arg1 = (FXGLViewer *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLViewer, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onEnter(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXGLViewer_onLeave(int argc, VALUE *argv, VALUE self) { FXGLViewer *arg1 = (FXGLViewer *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLViewer, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onLeave(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXGLViewer_onMotion(int argc, VALUE *argv, VALUE self) { FXGLViewer *arg1 = (FXGLViewer *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLViewer, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onMotion(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXGLViewer_onMouseWheel(int argc, VALUE *argv, VALUE self) { FXGLViewer *arg1 = (FXGLViewer *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLViewer, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onMouseWheel(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXGLViewer_onChanged(int argc, VALUE *argv, VALUE self) { FXGLViewer *arg1 = (FXGLViewer *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLViewer, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]);
    SWIG_ConvertPtr(argv[2], (void **) &arg4, 0, 1); result = (long)(arg1)->onChanged(arg2,arg3,arg4);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXGLViewer_onPick(int argc, VALUE *argv, VALUE self) { FXGLViewer *arg1 = (FXGLViewer *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLViewer, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]);
    SWIG_ConvertPtr(argv[2], (void **) &arg4, 0, 1); result = (long)(arg1)->onPick(arg2,arg3,arg4); vresult = INT2NUM(result);
    return vresult; }
static VALUE _wrap_FXGLViewer_onClicked(int argc, VALUE *argv, VALUE self) { FXGLViewer *arg1 = (FXGLViewer *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLViewer, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]);
    SWIG_ConvertPtr(argv[2], (void **) &arg4, 0, 1); result = (long)(arg1)->onClicked(arg2,arg3,arg4);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXGLViewer_onDoubleClicked(int argc, VALUE *argv, VALUE self) { FXGLViewer *arg1 = (FXGLViewer *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLViewer, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]);
    SWIG_ConvertPtr(argv[2], (void **) &arg4, 0, 1); result = (long)(arg1)->onDoubleClicked(arg2,arg3,arg4);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXGLViewer_onTripleClicked(int argc, VALUE *argv, VALUE self) { FXGLViewer *arg1 = (FXGLViewer *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLViewer, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]);
    SWIG_ConvertPtr(argv[2], (void **) &arg4, 0, 1); result = (long)(arg1)->onTripleClicked(arg2,arg3,arg4);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXGLViewer_onLassoed(int argc, VALUE *argv, VALUE self) { FXGLViewer *arg1 = (FXGLViewer *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLViewer, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onLassoed(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXGLViewer_onSelected(int argc, VALUE *argv, VALUE self) { FXGLViewer *arg1 = (FXGLViewer *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLViewer, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onSelected(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXGLViewer_onDeselected(int argc, VALUE *argv, VALUE self) { FXGLViewer *arg1 = (FXGLViewer *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLViewer, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onDeselected(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXGLViewer_onInserted(int argc, VALUE *argv, VALUE self) { FXGLViewer *arg1 = (FXGLViewer *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLViewer, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onInserted(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXGLViewer_onDeleted(int argc, VALUE *argv, VALUE self) { FXGLViewer *arg1 = (FXGLViewer *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLViewer, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onDeleted(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXGLViewer_onLeftBtnPress(int argc, VALUE *argv, VALUE self) { FXGLViewer *arg1 = (FXGLViewer *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLViewer, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onLeftBtnPress(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXGLViewer_onLeftBtnRelease(int argc, VALUE *argv, VALUE self) { FXGLViewer *arg1 = (FXGLViewer *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLViewer, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onLeftBtnRelease(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXGLViewer_onMiddleBtnPress(int argc, VALUE *argv, VALUE self) { FXGLViewer *arg1 = (FXGLViewer *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLViewer, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onMiddleBtnPress(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXGLViewer_onMiddleBtnRelease(int argc, VALUE *argv, VALUE self) { FXGLViewer *arg1 = (FXGLViewer *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLViewer, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onMiddleBtnRelease(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXGLViewer_onRightBtnPress(int argc, VALUE *argv, VALUE self) { FXGLViewer *arg1 = (FXGLViewer *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLViewer, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onRightBtnPress(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXGLViewer_onRightBtnRelease(int argc, VALUE *argv, VALUE self) { FXGLViewer *arg1 = (FXGLViewer *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLViewer, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onRightBtnRelease(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXGLViewer_onUngrabbed(int argc, VALUE *argv, VALUE self) { FXGLViewer *arg1 = (FXGLViewer *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLViewer, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onUngrabbed(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXGLViewer_onKeyPress(int argc, VALUE *argv, VALUE self) { FXGLViewer *arg1 = (FXGLViewer *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLViewer, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onKeyPress(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXGLViewer_onKeyRelease(int argc, VALUE *argv, VALUE self) { FXGLViewer *arg1 = (FXGLViewer *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLViewer, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onKeyRelease(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXGLViewer_onFocusIn(int argc, VALUE *argv, VALUE self) { FXGLViewer *arg1 = (FXGLViewer *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLViewer, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onFocusIn(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXGLViewer_onFocusOut(int argc, VALUE *argv, VALUE self) { FXGLViewer *arg1 = (FXGLViewer *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLViewer, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onFocusOut(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXGLViewer_onClipboardLost(int argc, VALUE *argv, VALUE self) { FXGLViewer *arg1 = (FXGLViewer *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLViewer, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onClipboardLost(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXGLViewer_onClipboardGained(int argc, VALUE *argv, VALUE self) { FXGLViewer *arg1 = (FXGLViewer *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLViewer, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onClipboardGained(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXGLViewer_onClipboardRequest(int argc, VALUE *argv, VALUE self) { FXGLViewer *arg1 = (FXGLViewer *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLViewer, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onClipboardRequest(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXGLViewer_onCmdPerspective(int argc, VALUE *argv, VALUE self) { FXGLViewer *arg1 = (FXGLViewer *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLViewer, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdPerspective(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXGLViewer_onUpdPerspective(int argc, VALUE *argv, VALUE self) { FXGLViewer *arg1 = (FXGLViewer *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLViewer, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onUpdPerspective(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXGLViewer_onCmdParallel(int argc, VALUE *argv, VALUE self) { FXGLViewer *arg1 = (FXGLViewer *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLViewer, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdParallel(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXGLViewer_onUpdParallel(int argc, VALUE *argv, VALUE self) { FXGLViewer *arg1 = (FXGLViewer *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLViewer, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onUpdParallel(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXGLViewer_onCmdFront(int argc, VALUE *argv, VALUE self) { FXGLViewer *arg1 = (FXGLViewer *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLViewer, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdFront(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXGLViewer_onUpdFront(int argc, VALUE *argv, VALUE self) { FXGLViewer *arg1 = (FXGLViewer *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLViewer, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onUpdFront(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXGLViewer_onCmdBack(int argc, VALUE *argv, VALUE self) { FXGLViewer *arg1 = (FXGLViewer *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLViewer, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdBack(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXGLViewer_onUpdBack(int argc, VALUE *argv, VALUE self) { FXGLViewer *arg1 = (FXGLViewer *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLViewer, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onUpdBack(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXGLViewer_onCmdLeft(int argc, VALUE *argv, VALUE self) { FXGLViewer *arg1 = (FXGLViewer *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLViewer, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdLeft(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXGLViewer_onUpdLeft(int argc, VALUE *argv, VALUE self) { FXGLViewer *arg1 = (FXGLViewer *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLViewer, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onUpdLeft(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXGLViewer_onCmdRight(int argc, VALUE *argv, VALUE self) { FXGLViewer *arg1 = (FXGLViewer *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLViewer, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdRight(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXGLViewer_onUpdRight(int argc, VALUE *argv, VALUE self) { FXGLViewer *arg1 = (FXGLViewer *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLViewer, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onUpdRight(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXGLViewer_onCmdTop(int argc, VALUE *argv, VALUE self) { FXGLViewer *arg1 = (FXGLViewer *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLViewer, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdTop(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXGLViewer_onUpdTop(int argc, VALUE *argv, VALUE self) { FXGLViewer *arg1 = (FXGLViewer *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLViewer, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onUpdTop(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXGLViewer_onCmdBottom(int argc, VALUE *argv, VALUE self) { FXGLViewer *arg1 = (FXGLViewer *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLViewer, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdBottom(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXGLViewer_onUpdBottom(int argc, VALUE *argv, VALUE self) { FXGLViewer *arg1 = (FXGLViewer *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLViewer, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onUpdBottom(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXGLViewer_onCmdResetView(int argc, VALUE *argv, VALUE self) { FXGLViewer *arg1 = (FXGLViewer *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLViewer, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdResetView(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXGLViewer_onCmdFitView(int argc, VALUE *argv, VALUE self) { FXGLViewer *arg1 = (FXGLViewer *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLViewer, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdFitView(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXGLViewer_onDNDEnter(int argc, VALUE *argv, VALUE self) { FXGLViewer *arg1 = (FXGLViewer *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLViewer, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onDNDEnter(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXGLViewer_onDNDLeave(int argc, VALUE *argv, VALUE self) { FXGLViewer *arg1 = (FXGLViewer *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLViewer, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onDNDLeave(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXGLViewer_onDNDMotion(int argc, VALUE *argv, VALUE self) { FXGLViewer *arg1 = (FXGLViewer *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLViewer, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onDNDMotion(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXGLViewer_onDNDDrop(int argc, VALUE *argv, VALUE self) { FXGLViewer *arg1 = (FXGLViewer *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLViewer, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onDNDDrop(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXGLViewer_onTipTimer(int argc, VALUE *argv, VALUE self) { FXGLViewer *arg1 = (FXGLViewer *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLViewer, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onTipTimer(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXGLViewer_onCmdXYZDial(int argc, VALUE *argv, VALUE self) { FXGLViewer *arg1 = (FXGLViewer *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLViewer, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]);
    arg4 = reinterpret_cast<void*>(NUM2INT(argv[2])); result = (long)(arg1)->onCmdXYZDial(arg2,arg3,arg4);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXGLViewer_onUpdXYZDial(int argc, VALUE *argv, VALUE self) { FXGLViewer *arg1 = (FXGLViewer *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLViewer, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onUpdXYZDial(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXGLViewer_onCmdRollPitchYaw(int argc, VALUE *argv, VALUE self) { FXGLViewer *arg1 = (FXGLViewer *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLViewer, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdRollPitchYaw(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXGLViewer_onUpdRollPitchYaw(int argc, VALUE *argv, VALUE self) { FXGLViewer *arg1 = (FXGLViewer *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLViewer, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onUpdRollPitchYaw(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXGLViewer_onCmdXYZScale(int argc, VALUE *argv, VALUE self) { FXGLViewer *arg1 = (FXGLViewer *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLViewer, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdXYZScale(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXGLViewer_onUpdXYZScale(int argc, VALUE *argv, VALUE self) { FXGLViewer *arg1 = (FXGLViewer *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLViewer, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onUpdXYZScale(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXGLViewer_onUpdCurrent(int argc, VALUE *argv, VALUE self) { FXGLViewer *arg1 = (FXGLViewer *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLViewer, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onUpdCurrent(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXGLViewer_onCmdCutSel(int argc, VALUE *argv, VALUE self) { FXGLViewer *arg1 = (FXGLViewer *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLViewer, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdCutSel(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXGLViewer_onCmdCopySel(int argc, VALUE *argv, VALUE self) { FXGLViewer *arg1 = (FXGLViewer *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLViewer, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdCopySel(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXGLViewer_onCmdPasteSel(int argc, VALUE *argv, VALUE self) { FXGLViewer *arg1 = (FXGLViewer *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLViewer, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdPasteSel(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXGLViewer_onCmdDeleteSel(int argc, VALUE *argv, VALUE self) { FXGLViewer *arg1 = (FXGLViewer *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLViewer, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdDeleteSel(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXGLViewer_onUpdDeleteSel(int argc, VALUE *argv, VALUE self) { FXGLViewer *arg1 = (FXGLViewer *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLViewer, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onUpdDeleteSel(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXGLViewer_onCmdBackColor(int argc, VALUE *argv, VALUE self) { FXGLViewer *arg1 = (FXGLViewer *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLViewer, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]);
    arg4 = reinterpret_cast<void*>(NUM2UINT(argv[2])); result = (long)(arg1)->onCmdBackColor(arg2,arg3,arg4);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXGLViewer_onUpdBackColor(int argc, VALUE *argv, VALUE self) { FXGLViewer *arg1 = (FXGLViewer *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLViewer, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onUpdBackColor(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXGLViewer_onCmdGradientBackColor(int argc, VALUE *argv, VALUE self) { FXGLViewer *arg1 = (FXGLViewer *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLViewer, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]);
    arg4 = reinterpret_cast<void*>(NUM2UINT(argv[2])); result = (long)(arg1)->onCmdGradientBackColor(arg2,arg3,arg4);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXGLViewer_onUpdGradientBackColor(int argc, VALUE *argv, VALUE self) { FXGLViewer *arg1 = (FXGLViewer *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLViewer, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onUpdGradientBackColor(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXGLViewer_onCmdAmbientColor(int argc, VALUE *argv, VALUE self) { FXGLViewer *arg1 = (FXGLViewer *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLViewer, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]);
    arg4 = reinterpret_cast<void*>(NUM2UINT(argv[2])); result = (long)(arg1)->onCmdAmbientColor(arg2,arg3,arg4);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXGLViewer_onUpdAmbientColor(int argc, VALUE *argv, VALUE self) { FXGLViewer *arg1 = (FXGLViewer *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLViewer, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onUpdAmbientColor(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXGLViewer_onCmdLighting(int argc, VALUE *argv, VALUE self) { FXGLViewer *arg1 = (FXGLViewer *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLViewer, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdLighting(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXGLViewer_onUpdLighting(int argc, VALUE *argv, VALUE self) { FXGLViewer *arg1 = (FXGLViewer *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLViewer, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onUpdLighting(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXGLViewer_onCmdFog(int argc, VALUE *argv, VALUE self) { FXGLViewer *arg1 = (FXGLViewer *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLViewer, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdFog(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXGLViewer_onUpdFog(int argc, VALUE *argv, VALUE self) { FXGLViewer *arg1 = (FXGLViewer *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLViewer, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onUpdFog(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXGLViewer_onCmdDither(int argc, VALUE *argv, VALUE self) { FXGLViewer *arg1 = (FXGLViewer *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLViewer, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdDither(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXGLViewer_onUpdDither(int argc, VALUE *argv, VALUE self) { FXGLViewer *arg1 = (FXGLViewer *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLViewer, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onUpdDither(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXGLViewer_onCmdFov(int argc, VALUE *argv, VALUE self) { FXGLViewer *arg1 = (FXGLViewer *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLViewer, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdFov(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXGLViewer_onUpdFov(int argc, VALUE *argv, VALUE self) { FXGLViewer *arg1 = (FXGLViewer *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLViewer, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onUpdFov(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXGLViewer_onCmdZoom(int argc, VALUE *argv, VALUE self) { FXGLViewer *arg1 = (FXGLViewer *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLViewer, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdZoom(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXGLViewer_onUpdZoom(int argc, VALUE *argv, VALUE self) { FXGLViewer *arg1 = (FXGLViewer *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLViewer, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onUpdZoom(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXGLViewer_onCmdLightAmbient(int argc, VALUE *argv, VALUE self) { FXGLViewer *arg1 = (FXGLViewer *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLViewer, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]);
    arg4 = reinterpret_cast<void*>(NUM2UINT(argv[2])); result = (long)(arg1)->onCmdLightAmbient(arg2,arg3,arg4);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXGLViewer_onUpdLightAmbient(int argc, VALUE *argv, VALUE self) { FXGLViewer *arg1 = (FXGLViewer *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLViewer, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onUpdLightAmbient(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXGLViewer_onCmdLightDiffuse(int argc, VALUE *argv, VALUE self) { FXGLViewer *arg1 = (FXGLViewer *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLViewer, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]);
    arg4 = reinterpret_cast<void*>(NUM2UINT(argv[2])); result = (long)(arg1)->onCmdLightDiffuse(arg2,arg3,arg4);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXGLViewer_onUpdLightDiffuse(int argc, VALUE *argv, VALUE self) { FXGLViewer *arg1 = (FXGLViewer *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLViewer, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onUpdLightDiffuse(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXGLViewer_onCmdLightSpecular(int argc, VALUE *argv, VALUE self) { FXGLViewer *arg1 = (FXGLViewer *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLViewer, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]);
    arg4 = reinterpret_cast<void*>(NUM2UINT(argv[2])); result = (long)(arg1)->onCmdLightSpecular(arg2,arg3,arg4);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXGLViewer_onUpdLightSpecular(int argc, VALUE *argv, VALUE self) { FXGLViewer *arg1 = (FXGLViewer *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLViewer, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onUpdLightSpecular(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXGLViewer_onCmdTurbo(int argc, VALUE *argv, VALUE self) { FXGLViewer *arg1 = (FXGLViewer *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLViewer, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdTurbo(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXGLViewer_onUpdTurbo(int argc, VALUE *argv, VALUE self) { FXGLViewer *arg1 = (FXGLViewer *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLViewer, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onUpdTurbo(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXGLViewer_onCmdPrintImage(int argc, VALUE *argv, VALUE self) { FXGLViewer *arg1 = (FXGLViewer *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLViewer, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdPrintImage(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXGLViewer_onCmdPrintVector(int argc, VALUE *argv, VALUE self) { FXGLViewer *arg1 = (FXGLViewer *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLViewer, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdPrintVector(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXGLViewer_onCmdLassoZoom(int argc, VALUE *argv, VALUE self) { FXGLViewer *arg1 = (FXGLViewer *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLViewer, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdLassoZoom(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXGLViewer_onCmdLassoSelect(int argc, VALUE *argv, VALUE self) { FXGLViewer *arg1 = (FXGLViewer *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLViewer, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdLassoSelect(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXGLViewer_onQueryHelp(int argc, VALUE *argv, VALUE self) { FXGLViewer *arg1 = (FXGLViewer *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLViewer, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onQueryHelp(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXGLViewer_onQueryTip(int argc, VALUE *argv, VALUE self) { FXGLViewer *arg1 = (FXGLViewer *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLViewer, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onQueryTip(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXGLViewer_objectTypeName(int argc, VALUE *argv, VALUE self) { VALUE result; VALUE vresult = Qnil;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    result = (VALUE)FXGLViewer_objectTypeName(); vresult = result; return vresult; }
static VALUE _wrap_new_FXGLViewer__SWIG_0(int argc, VALUE *argv, VALUE self) { FXComposite *arg1 = (FXComposite *) 0 ;
    FXGLVisual *arg2 = (FXGLVisual *) 0 ; FXObject *arg3 = (FXObject *) 0 ; FXSelector arg4 = (FXSelector) 0 ;
    FXuint arg5 = (FXuint) 0 ; FXint arg6 = (FXint) 0 ; FXint arg7 = (FXint) 0 ; FXint arg8 = (FXint) 0 ;
    FXint arg9 = (FXint) 0 ; FXGLViewer *result; if ((argc < 2) || (argc > 9))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXComposite, 1);
    SWIG_ConvertPtr(argv[1], (void **) &arg2, SWIGTYPE_p_FXGLVisual, 1); if (argc > 2) {
        SWIG_ConvertPtr(argv[2], (void **) &arg3, SWIGTYPE_p_FXObject, 1); }  if (argc > 3) { arg4 = NUM2UINT(argv[3]); } 
    if (argc > 4) { arg5 = NUM2UINT(argv[4]); }  if (argc > 5) { arg6 = NUM2INT(argv[5]); }  if (argc > 6) {
        arg7 = NUM2INT(argv[6]); }  if (argc > 7) { arg8 = NUM2INT(argv[7]); }  if (argc > 8) { arg9 = NUM2INT(argv[8]); }  {
        result = (FXGLViewer *)new_FXGLViewer__SWIG_0(arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8,arg9);
        DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result); if(rb_block_given_p()){ rb_yield(self); }  }  return self; }
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE _wrap_FXGLViewer_allocate(VALUE self) {
#else
     static VALUE _wrap_FXGLViewer_allocate(int argc, VALUE *argv, VALUE self) {
#endif
         VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_FXGLViewer);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
         return vresult; }
static VALUE _wrap_new_FXGLViewer__SWIG_1(int argc, VALUE *argv, VALUE self) { FXComposite *arg1 = (FXComposite *) 0 ;
    FXGLVisual *arg2 = (FXGLVisual *) 0 ; FXGLViewer *arg3 = (FXGLViewer *) 0 ; FXObject *arg4 = (FXObject *) 0 ;
    FXSelector arg5 = (FXSelector) 0 ; FXuint arg6 = (FXuint) 0 ; FXint arg7 = (FXint) 0 ; FXint arg8 = (FXint) 0 ;
    FXint arg9 = (FXint) 0 ; FXint arg10 = (FXint) 0 ; FXGLViewer *result; if ((argc < 3) || (argc > 10))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXComposite, 1);
    SWIG_ConvertPtr(argv[1], (void **) &arg2, SWIGTYPE_p_FXGLVisual, 1);
    SWIG_ConvertPtr(argv[2], (void **) &arg3, SWIGTYPE_p_FXGLViewer, 1); if (argc > 3) {
        SWIG_ConvertPtr(argv[3], (void **) &arg4, SWIGTYPE_p_FXObject, 1); }  if (argc > 4) { arg5 = NUM2UINT(argv[4]); } 
    if (argc > 5) { arg6 = NUM2UINT(argv[5]); }  if (argc > 6) { arg7 = NUM2INT(argv[6]); }  if (argc > 7) {
        arg8 = NUM2INT(argv[7]); }  if (argc > 8) { arg9 = NUM2INT(argv[8]); }  if (argc > 9) { arg10 = NUM2INT(argv[9]); }  {
        result = (FXGLViewer *)new_FXGLViewer__SWIG_1(arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8,arg9,arg10);
        DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result); if(rb_block_given_p()){ rb_yield(self); }  }  return self; }
static VALUE _wrap_new_FXGLViewer(int nargs, VALUE *args, VALUE self) { int argc; VALUE argv[10]; int ii; argc = nargs;
    for (ii = 0; (ii < argc) && (ii < 10); ii++) { argv[ii] = args[ii]; }  if ((argc >= 2) && (argc <= 9)) { int _v; {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXComposite, 0) != -1)) ? 1 : 0; }
         if (_v) { { void *ptr;
                _v = (NIL_P(argv[1]) || (TYPE(argv[1]) == T_DATA && SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_FXGLVisual, 0) != -1)) ? 1 : 0; }
             if (_v) { if (argc <= 2) { return _wrap_new_FXGLViewer__SWIG_0(nargs, args, self);}  { void *ptr;
                    _v = (NIL_P(argv[2]) || (TYPE(argv[2]) == T_DATA && SWIG_ConvertPtr(argv[2], &ptr, SWIGTYPE_p_FXObject, 0) != -1)) ? 1 : 0; }
                 if (_v) { if (argc <= 3) { return _wrap_new_FXGLViewer__SWIG_0(nargs, args, self);}  {
                        _v = ((TYPE(argv[3]) == T_FIXNUM) || (TYPE(argv[3]) == T_BIGNUM)) ? 1 : 0; }  if (_v) { if (argc <= 4) {
                            return _wrap_new_FXGLViewer__SWIG_0(nargs, args, self);}  {
                            _v = ((TYPE(argv[4]) == T_FIXNUM) || (TYPE(argv[4]) == T_BIGNUM)) ? 1 : 0; }  if (_v) {
                            if (argc <= 5) { return _wrap_new_FXGLViewer__SWIG_0(nargs, args, self);}  {
                                _v = ((TYPE(argv[5]) == T_FIXNUM) || (TYPE(argv[5]) == T_BIGNUM)) ? 1 : 0; }  if (_v) {
                                if (argc <= 6) { return _wrap_new_FXGLViewer__SWIG_0(nargs, args, self);}  {
                                    _v = ((TYPE(argv[6]) == T_FIXNUM) || (TYPE(argv[6]) == T_BIGNUM)) ? 1 : 0; }  if (_v) {
                                    if (argc <= 7) { return _wrap_new_FXGLViewer__SWIG_0(nargs, args, self);}  {
                                        _v = ((TYPE(argv[7]) == T_FIXNUM) || (TYPE(argv[7]) == T_BIGNUM)) ? 1 : 0; }  if (_v) {
                                        if (argc <= 8) { return _wrap_new_FXGLViewer__SWIG_0(nargs, args, self);}  {
                                            _v = ((TYPE(argv[8]) == T_FIXNUM) || (TYPE(argv[8]) == T_BIGNUM)) ? 1 : 0; } 
                                        if (_v) { return _wrap_new_FXGLViewer__SWIG_0(nargs, args, self);}  }  }  }  }  }  }  }
             }  }  if ((argc >= 3) && (argc <= 10)) { int _v; { void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXComposite, 0) != -1)) ? 1 : 0; }
         if (_v) { { void *ptr;
                _v = (NIL_P(argv[1]) || (TYPE(argv[1]) == T_DATA && SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_FXGLVisual, 0) != -1)) ? 1 : 0; }
             if (_v) { { void *ptr;
                    _v = (NIL_P(argv[2]) || (TYPE(argv[2]) == T_DATA && SWIG_ConvertPtr(argv[2], &ptr, SWIGTYPE_p_FXGLViewer, 0) != -1)) ? 1 : 0; }
                 if (_v) { if (argc <= 3) { return _wrap_new_FXGLViewer__SWIG_1(nargs, args, self);}  { void *ptr;
                        _v = (NIL_P(argv[3]) || (TYPE(argv[3]) == T_DATA && SWIG_ConvertPtr(argv[3], &ptr, SWIGTYPE_p_FXObject, 0) != -1)) ? 1 : 0; }
                     if (_v) { if (argc <= 4) { return _wrap_new_FXGLViewer__SWIG_1(nargs, args, self);}  {
                            _v = ((TYPE(argv[4]) == T_FIXNUM) || (TYPE(argv[4]) == T_BIGNUM)) ? 1 : 0; }  if (_v) {
                            if (argc <= 5) { return _wrap_new_FXGLViewer__SWIG_1(nargs, args, self);}  {
                                _v = ((TYPE(argv[5]) == T_FIXNUM) || (TYPE(argv[5]) == T_BIGNUM)) ? 1 : 0; }  if (_v) {
                                if (argc <= 6) { return _wrap_new_FXGLViewer__SWIG_1(nargs, args, self);}  {
                                    _v = ((TYPE(argv[6]) == T_FIXNUM) || (TYPE(argv[6]) == T_BIGNUM)) ? 1 : 0; }  if (_v) {
                                    if (argc <= 7) { return _wrap_new_FXGLViewer__SWIG_1(nargs, args, self);}  {
                                        _v = ((TYPE(argv[7]) == T_FIXNUM) || (TYPE(argv[7]) == T_BIGNUM)) ? 1 : 0; }  if (_v) {
                                        if (argc <= 8) { return _wrap_new_FXGLViewer__SWIG_1(nargs, args, self);}  {
                                            _v = ((TYPE(argv[8]) == T_FIXNUM) || (TYPE(argv[8]) == T_BIGNUM)) ? 1 : 0; } 
                                        if (_v) { if (argc <= 9) { return _wrap_new_FXGLViewer__SWIG_1(nargs, args, self);}  {
                                                _v = ((TYPE(argv[9]) == T_FIXNUM) || (TYPE(argv[9]) == T_BIGNUM)) ? 1 : 0; } 
                                            if (_v) { return _wrap_new_FXGLViewer__SWIG_1(nargs, args, self);}  }  }  }  }  }  }
                     }  }  }  }  rb_raise(rb_eArgError, "No matching function for overloaded 'new_FXGLViewer'"); return Qnil; }
static VALUE _wrap_FXGLViewer_worldPix(int argc, VALUE *argv, VALUE self) { FXGLViewer *arg1 = (FXGLViewer *) 0 ;
    FXdouble result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLViewer, 1); result = (FXdouble)((FXGLViewer const *)arg1)->worldPix();
    vresult = rb_float_new(result); return vresult; }
static VALUE _wrap_FXGLViewer_modelPix(int argc, VALUE *argv, VALUE self) { FXGLViewer *arg1 = (FXGLViewer *) 0 ;
    FXdouble result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLViewer, 1); result = (FXdouble)((FXGLViewer const *)arg1)->modelPix();
    vresult = rb_float_new(result); return vresult; }
static VALUE _wrap_FXGLViewer_lasso(int argc, VALUE *argv, VALUE self) { FXGLViewer *arg1 = (FXGLViewer *) 0 ; FXint arg2 ;
    FXint arg3 ; FXint arg4 ; FXint arg5 ; VALUE result; VALUE vresult = Qnil; if ((argc < 4) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLViewer, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    arg4 = NUM2INT(argv[2]); arg5 = NUM2INT(argv[3]); result = (VALUE)FXGLViewer_lasso(arg1,arg2,arg3,arg4,arg5);
    vresult = result; return vresult; }
static VALUE _wrap_FXGLViewer_setBounds(int argc, VALUE *argv, VALUE self) { FXGLViewer *arg1 = (FXGLViewer *) 0 ;
    FXRangef *arg2 = 0 ; FXbool result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLViewer, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXRangef, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    result = (FXbool)(arg1)->setBounds((FXRangef const &)*arg2); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXGLViewer_fitToBounds(int argc, VALUE *argv, VALUE self) { FXGLViewer *arg1 = (FXGLViewer *) 0 ;
    FXRangef *arg2 = 0 ; FXbool result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLViewer, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXRangef, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    result = (FXbool)(arg1)->fitToBounds((FXRangef const &)*arg2); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXGLViewer_getViewport(int argc, VALUE *argv, VALUE self) { FXGLViewer *arg1 = (FXGLViewer *) 0 ;
    FXViewport result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLViewer, 1); result = FXGLViewer_getViewport((FXGLViewer const *)arg1);
    { FXViewport* resultptr = new FXViewport(result);  vresult = FXRbGetRubyObj(resultptr, "FXViewport *"); }  return vresult; }
static VALUE _wrap_FXGLViewer_eyeToScreen(int argc, VALUE *argv, VALUE self) { FXGLViewer *arg1 = (FXGLViewer *) 0 ;
    FXVec3f arg2 ; VALUE result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLViewer, 1); { FXVec3f * ptr;
        SWIG_ConvertPtr(argv[0], (void **) &ptr, SWIGTYPE_p_FXVec3f, 1); if (ptr) arg2 = *ptr; } 
    result = (VALUE)FXGLViewer_eyeToScreen(arg1,arg2); vresult = result; return vresult; }
static VALUE _wrap_FXGLViewer_screenToEye(int argc, VALUE *argv, VALUE self) { FXGLViewer *arg1 = (FXGLViewer *) 0 ;
    FXint arg2 ; FXint arg3 ; FXfloat arg4 = (FXfloat) 0.0 ; FXVec3f result; VALUE vresult = Qnil; if ((argc < 2) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLViewer, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    if (argc > 2) { arg4 = (FXfloat) NUM2DBL(argv[2]); }  result = (arg1)->screenToEye(arg2,arg3,arg4); {
        FXVec3f* resultptr = new FXVec3f(result); vresult = FXRbGetRubyObj(resultptr, "FXVec3f *"); }  return vresult; }
static VALUE _wrap_FXGLViewer_screenToTarget(int argc, VALUE *argv, VALUE self) { FXGLViewer *arg1 = (FXGLViewer *) 0 ;
    FXint arg2 ; FXint arg3 ; FXVec3f result; VALUE vresult = Qnil; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLViewer, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    result = (arg1)->screenToTarget(arg2,arg3); { FXVec3f* resultptr = new FXVec3f(result);
        vresult = FXRbGetRubyObj(resultptr, "FXVec3f *"); }  return vresult; }
static VALUE _wrap_FXGLViewer_worldToEye(int argc, VALUE *argv, VALUE self) { FXGLViewer *arg1 = (FXGLViewer *) 0 ;
    FXVec3f arg2 ; FXVec3f result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLViewer, 1); { FXVec3f * ptr;
        SWIG_ConvertPtr(argv[0], (void **) &ptr, SWIGTYPE_p_FXVec3f, 1); if (ptr) arg2 = *ptr; } 
    result = (arg1)->worldToEye(arg2); { FXVec3f* resultptr = new FXVec3f(result);
        vresult = FXRbGetRubyObj(resultptr, "FXVec3f *"); }  return vresult; }
static VALUE _wrap_FXGLViewer_worldToEyeZ(int argc, VALUE *argv, VALUE self) { FXGLViewer *arg1 = (FXGLViewer *) 0 ;
    FXVec3f arg2 ; FXfloat result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLViewer, 1); { FXVec3f * ptr;
        SWIG_ConvertPtr(argv[0], (void **) &ptr, SWIGTYPE_p_FXVec3f, 1); if (ptr) arg2 = *ptr; } 
    result = (FXfloat)(arg1)->worldToEyeZ(arg2); vresult = rb_float_new(result); return vresult; }
static VALUE _wrap_FXGLViewer_eyeToWorld(int argc, VALUE *argv, VALUE self) { FXGLViewer *arg1 = (FXGLViewer *) 0 ;
    FXVec3f arg2 ; FXVec3f result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLViewer, 1); { FXVec3f * ptr;
        SWIG_ConvertPtr(argv[0], (void **) &ptr, SWIGTYPE_p_FXVec3f, 1); if (ptr) arg2 = *ptr; } 
    result = (arg1)->eyeToWorld(arg2); { FXVec3f* resultptr = new FXVec3f(result);
        vresult = FXRbGetRubyObj(resultptr, "FXVec3f *"); }  return vresult; }
static VALUE _wrap_FXGLViewer_worldVector(int argc, VALUE *argv, VALUE self) { FXGLViewer *arg1 = (FXGLViewer *) 0 ;
    FXint arg2 ; FXint arg3 ; FXint arg4 ; FXint arg5 ; FXVec3f result; VALUE vresult = Qnil; if ((argc < 4) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLViewer, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    arg4 = NUM2INT(argv[2]); arg5 = NUM2INT(argv[3]); result = (arg1)->worldVector(arg2,arg3,arg4,arg5); {
        FXVec3f* resultptr = new FXVec3f(result); vresult = FXRbGetRubyObj(resultptr, "FXVec3f *"); }  return vresult; }
static VALUE _wrap_FXGLViewer_setMaterial(int argc, VALUE *argv, VALUE self) { FXGLViewer *arg1 = (FXGLViewer *) 0 ;
    FXMaterial *arg2 = 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLViewer, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXMaterial, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    (arg1)->setMaterial((FXMaterial const &)*arg2); return Qnil; }
static VALUE _wrap_FXGLViewer_getMaterial(int argc, VALUE *argv, VALUE self) { FXGLViewer *arg1 = (FXGLViewer *) 0 ;
    FXMaterial result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLViewer, 1); result = FXGLViewer_getMaterial((FXGLViewer const *)arg1);
    { FXMaterial *resultptr = new FXMaterial(result); vresult = FXRbGetRubyObj(resultptr, "FXMaterial *"); }  return vresult; }
static VALUE _wrap_FXGLViewer_setFieldOfView(int argc, VALUE *argv, VALUE self) { FXGLViewer *arg1 = (FXGLViewer *) 0 ;
    FXdouble arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLViewer, 1); arg2 = (FXdouble) NUM2DBL(argv[0]);
    (arg1)->setFieldOfView(arg2); return Qnil; }
static VALUE _wrap_FXGLViewer_getFieldOfView(int argc, VALUE *argv, VALUE self) { FXGLViewer *arg1 = (FXGLViewer *) 0 ;
    FXdouble result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLViewer, 1);
    result = (FXdouble)((FXGLViewer const *)arg1)->getFieldOfView(); vresult = rb_float_new(result); return vresult; }
static VALUE _wrap_FXGLViewer_setZoom(int argc, VALUE *argv, VALUE self) { FXGLViewer *arg1 = (FXGLViewer *) 0 ; FXdouble arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLViewer, 1); arg2 = (FXdouble) NUM2DBL(argv[0]); (arg1)->setZoom(arg2);
    return Qnil; }
static VALUE _wrap_FXGLViewer_getZoom(int argc, VALUE *argv, VALUE self) { FXGLViewer *arg1 = (FXGLViewer *) 0 ;
    FXdouble result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLViewer, 1); result = (FXdouble)((FXGLViewer const *)arg1)->getZoom();
    vresult = rb_float_new(result); return vresult; }
static VALUE _wrap_FXGLViewer_setDistance(int argc, VALUE *argv, VALUE self) { FXGLViewer *arg1 = (FXGLViewer *) 0 ;
    FXdouble arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLViewer, 1); arg2 = (FXdouble) NUM2DBL(argv[0]);
    (arg1)->setDistance(arg2); return Qnil; }
static VALUE _wrap_FXGLViewer_getDistance(int argc, VALUE *argv, VALUE self) { FXGLViewer *arg1 = (FXGLViewer *) 0 ;
    FXdouble result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLViewer, 1);
    result = (FXdouble)((FXGLViewer const *)arg1)->getDistance(); vresult = rb_float_new(result); return vresult; }
static VALUE _wrap_FXGLViewer_setScale(int argc, VALUE *argv, VALUE self) { FXGLViewer *arg1 = (FXGLViewer *) 0 ; FXVec3f arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLViewer, 1); { FXVec3f * ptr;
        SWIG_ConvertPtr(argv[0], (void **) &ptr, SWIGTYPE_p_FXVec3f, 1); if (ptr) arg2 = *ptr; }  (arg1)->setScale(arg2);
    return Qnil; }
static VALUE _wrap_FXGLViewer_getScale(int argc, VALUE *argv, VALUE self) { FXGLViewer *arg1 = (FXGLViewer *) 0 ;
    FXVec3f *result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLViewer, 1); {
        FXVec3f const &_result_ref = ((FXGLViewer const *)arg1)->getScale(); result = (FXVec3f *) &_result_ref; } 
    vresult = FXRbGetRubyObj(result, "FXVec3f *"); return vresult; }
static VALUE _wrap_FXGLViewer_setOrientation(int argc, VALUE *argv, VALUE self) { FXGLViewer *arg1 = (FXGLViewer *) 0 ;
    FXQuatf arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLViewer, 1); { FXQuatf * ptr;
        SWIG_ConvertPtr(argv[0], (void **) &ptr, SWIGTYPE_p_FXQuatf, 1); if (ptr) arg2 = *ptr; }  (arg1)->setOrientation(arg2);
    return Qnil; }
static VALUE _wrap_FXGLViewer_getOrientation(int argc, VALUE *argv, VALUE self) { FXGLViewer *arg1 = (FXGLViewer *) 0 ;
    FXQuatf *result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLViewer, 1); {
        FXQuatf const &_result_ref = ((FXGLViewer const *)arg1)->getOrientation(); result = (FXQuatf *) &_result_ref; } 
    vresult = FXRbGetRubyObj(result, "FXQuatf *"); return vresult; }
static VALUE _wrap_FXGLViewer_setCenter(int argc, VALUE *argv, VALUE self) { FXGLViewer *arg1 = (FXGLViewer *) 0 ;
    FXVec3f arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLViewer, 1); { FXVec3f * ptr;
        SWIG_ConvertPtr(argv[0], (void **) &ptr, SWIGTYPE_p_FXVec3f, 1); if (ptr) arg2 = *ptr; }  (arg1)->setCenter(arg2);
    return Qnil; }
static VALUE _wrap_FXGLViewer_getCenter(int argc, VALUE *argv, VALUE self) { FXGLViewer *arg1 = (FXGLViewer *) 0 ;
    FXVec3f *result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLViewer, 1); {
        FXVec3f const &_result_ref = ((FXGLViewer const *)arg1)->getCenter(); result = (FXVec3f *) &_result_ref; } 
    vresult = FXRbGetRubyObj(result, "FXVec3f *"); return vresult; }
static VALUE _wrap_FXGLViewer_translate(int argc, VALUE *argv, VALUE self) { FXGLViewer *arg1 = (FXGLViewer *) 0 ;
    FXVec3f arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLViewer, 1); { FXVec3f * ptr;
        SWIG_ConvertPtr(argv[0], (void **) &ptr, SWIGTYPE_p_FXVec3f, 1); if (ptr) arg2 = *ptr; }  (arg1)->translate(arg2);
    return Qnil; }
static VALUE _wrap_FXGLViewer_getBoreVector(int argc, VALUE *argv, VALUE self) { FXGLViewer *arg1 = (FXGLViewer *) 0 ;
    FXint arg2 ; FXint arg3 ; VALUE result; VALUE vresult = Qnil; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLViewer, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    result = (VALUE)FXGLViewer_getBoreVector(arg1,arg2,arg3); vresult = result; return vresult; }
static VALUE _wrap_FXGLViewer_getEyeVector(int argc, VALUE *argv, VALUE self) { FXGLViewer *arg1 = (FXGLViewer *) 0 ;
    FXVec3f result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLViewer, 1); result = ((FXGLViewer const *)arg1)->getEyeVector(); {
        FXVec3f* resultptr = new FXVec3f(result); vresult = FXRbGetRubyObj(resultptr, "FXVec3f *"); }  return vresult; }
static VALUE _wrap_FXGLViewer_getEyePosition(int argc, VALUE *argv, VALUE self) { FXGLViewer *arg1 = (FXGLViewer *) 0 ;
    FXVec3f result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLViewer, 1); result = ((FXGLViewer const *)arg1)->getEyePosition(); {
        FXVec3f* resultptr = new FXVec3f(result); vresult = FXRbGetRubyObj(resultptr, "FXVec3f *"); }  return vresult; }
static VALUE _wrap_FXGLViewer_setHelpText(int argc, VALUE *argv, VALUE self) { FXGLViewer *arg1 = (FXGLViewer *) 0 ;
    FXString *arg2 = 0 ; SwigValueWrapper<FXString > p2 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLViewer, 1); p2 = to_FXString(argv[0]); arg2 = &p2;
    (arg1)->setHelpText((FXString const &)*arg2); return Qnil; }
static VALUE _wrap_FXGLViewer_getHelpText(int argc, VALUE *argv, VALUE self) { FXGLViewer *arg1 = (FXGLViewer *) 0 ;
    FXString result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLViewer, 1); result = ((FXGLViewer const *)arg1)->getHelpText();
    vresult = rb_str_new2((&result)->text()); return vresult; }
static VALUE _wrap_FXGLViewer_setTipText(int argc, VALUE *argv, VALUE self) { FXGLViewer *arg1 = (FXGLViewer *) 0 ;
    FXString *arg2 = 0 ; SwigValueWrapper<FXString > p2 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLViewer, 1); p2 = to_FXString(argv[0]); arg2 = &p2;
    (arg1)->setTipText((FXString const &)*arg2); return Qnil; }
static VALUE _wrap_FXGLViewer_getTipText(int argc, VALUE *argv, VALUE self) { FXGLViewer *arg1 = (FXGLViewer *) 0 ;
    FXString result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLViewer, 1); result = ((FXGLViewer const *)arg1)->getTipText();
    vresult = rb_str_new2((&result)->text()); return vresult; }
static VALUE _wrap_FXGLViewer_getTransform(int argc, VALUE *argv, VALUE self) { FXGLViewer *arg1 = (FXGLViewer *) 0 ;
    FXMat4f *result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLViewer, 1); {
        FXMat4f const &_result_ref = ((FXGLViewer const *)arg1)->getTransform(); result = (FXMat4f *) &_result_ref; } 
    vresult = FXRbGetRubyObj(result, "FXMat4f *"); return vresult; }
static VALUE _wrap_FXGLViewer_getInvTransform(int argc, VALUE *argv, VALUE self) { FXGLViewer *arg1 = (FXGLViewer *) 0 ;
    FXMat4f *result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLViewer, 1); {
        FXMat4f const &_result_ref = ((FXGLViewer const *)arg1)->getInvTransform(); result = (FXMat4f *) &_result_ref; } 
    vresult = FXRbGetRubyObj(result, "FXMat4f *"); return vresult; }
static VALUE _wrap_FXGLViewer_setScene(int argc, VALUE *argv, VALUE self) { FXGLViewer *arg1 = (FXGLViewer *) 0 ;
    FXGLObject *arg2 = (FXGLObject *) 0 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLViewer, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXGLObject, 1); (arg1)->setScene(arg2); return Qnil; }
static VALUE _wrap_FXGLViewer_getScene(int argc, VALUE *argv, VALUE self) { FXGLViewer *arg1 = (FXGLViewer *) 0 ;
    FXGLObject *result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLViewer, 1);
    result = (FXGLObject *)((FXGLViewer const *)arg1)->getScene(); {
        swig_type_info *ty = SWIG_TypeDynamicCast(SWIGTYPE_p_FXGLObject, (void **) &result);
        vresult = FXRbGetRubyObj(result, ty); }  return vresult; }
static VALUE _wrap_FXGLViewer_setSelection(int argc, VALUE *argv, VALUE self) { FXGLViewer *arg1 = (FXGLViewer *) 0 ;
    FXGLObject *arg2 = (FXGLObject *) 0 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLViewer, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXGLObject, 1); (arg1)->setSelection(arg2); return Qnil; }
static VALUE _wrap_FXGLViewer_getSelection(int argc, VALUE *argv, VALUE self) { FXGLViewer *arg1 = (FXGLViewer *) 0 ;
    FXGLObject *result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLViewer, 1);
    result = (FXGLObject *)((FXGLViewer const *)arg1)->getSelection(); {
        swig_type_info *ty = SWIG_TypeDynamicCast(SWIGTYPE_p_FXGLObject, (void **) &result);
        vresult = FXRbGetRubyObj(result, ty); }  return vresult; }
static VALUE _wrap_FXGLViewer_setProjection(int argc, VALUE *argv, VALUE self) { FXGLViewer *arg1 = (FXGLViewer *) 0 ;
    FXuint arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLViewer, 1); arg2 = NUM2UINT(argv[0]); (arg1)->setProjection(arg2);
    return Qnil; }
static VALUE _wrap_FXGLViewer_getProjection(int argc, VALUE *argv, VALUE self) { FXGLViewer *arg1 = (FXGLViewer *) 0 ;
    FXuint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLViewer, 1);
    result = (FXuint)((FXGLViewer const *)arg1)->getProjection(); vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXGLViewer_setBackgroundColor(int argc, VALUE *argv, VALUE self) { FXGLViewer *arg1 = (FXGLViewer *) 0 ;
    FXVec4f *arg2 = 0 ; FXbool arg3 = (FXbool) 2 ; if ((argc < 1) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLViewer, 1); { if (TYPE(argv[0]) == T_ARRAY) {
            arg2 = new FXVec4f(NUM2DBL(rb_ary_entry(argv[0], 0)), NUM2DBL(rb_ary_entry(argv[0], 1)), NUM2DBL(rb_ary_entry(argv[0], 2)), NUM2DBL(rb_ary_entry(argv[0], 3))); }
         else { FXVec4f *p; SWIG_ConvertPtr(argv[0],(void **)&p,SWIGTYPE_p_FXVec4f,1); arg2 = new FXVec4f(*p); }  } 
    if (argc > 1) { arg3 = to_FXbool(argv[1]); }  (arg1)->setBackgroundColor((FXVec4f const &)*arg2,arg3); delete arg2;
    return Qnil; }
static VALUE _wrap_FXGLViewer_getBackgroundColor(int argc, VALUE *argv, VALUE self) { FXGLViewer *arg1 = (FXGLViewer *) 0 ;
    FXbool arg2 = (FXbool) 0 ; FXVec4f *result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLViewer, 1); if (argc > 0) { arg2 = to_FXbool(argv[0]); }  {
        FXVec4f const &_result_ref = ((FXGLViewer const *)arg1)->getBackgroundColor(arg2); result = (FXVec4f *) &_result_ref; } 
    vresult = FXRbGetRubyObj(result, "FXVec4f *"); return vresult; }
static VALUE _wrap_FXGLViewer_setAmbientColor(int argc, VALUE *argv, VALUE self) { FXGLViewer *arg1 = (FXGLViewer *) 0 ;
    FXVec4f *arg2 = 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLViewer, 1); { if (TYPE(argv[0]) == T_ARRAY) {
            arg2 = new FXVec4f(NUM2DBL(rb_ary_entry(argv[0], 0)), NUM2DBL(rb_ary_entry(argv[0], 1)), NUM2DBL(rb_ary_entry(argv[0], 2)), NUM2DBL(rb_ary_entry(argv[0], 3))); }
         else { FXVec4f *p; SWIG_ConvertPtr(argv[0],(void **)&p,SWIGTYPE_p_FXVec4f,1); arg2 = new FXVec4f(*p); }  } 
    (arg1)->setAmbientColor((FXVec4f const &)*arg2); delete arg2; return Qnil; }
static VALUE _wrap_FXGLViewer_getAmbientColor(int argc, VALUE *argv, VALUE self) { FXGLViewer *arg1 = (FXGLViewer *) 0 ;
    FXVec4f *result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLViewer, 1); {
        FXVec4f const &_result_ref = ((FXGLViewer const *)arg1)->getAmbientColor(); result = (FXVec4f *) &_result_ref; } 
    vresult = FXRbGetRubyObj(result, "FXVec4f *"); return vresult; }
static VALUE _wrap_FXGLViewer_readPixels(int argc, VALUE *argv, VALUE self) { FXGLViewer *arg1 = (FXGLViewer *) 0 ; FXint arg2 ;
    FXint arg3 ; FXint arg4 ; FXint arg5 ; VALUE result; VALUE vresult = Qnil; if ((argc < 4) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLViewer, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    arg4 = NUM2INT(argv[2]); arg5 = NUM2INT(argv[3]); result = (VALUE)FXGLViewer_readPixels(arg1,arg2,arg3,arg4,arg5);
    vresult = result; return vresult; }
static VALUE _wrap_FXGLViewer_readFeedback(int argc, VALUE *argv, VALUE self) { FXGLViewer *arg1 = (FXGLViewer *) 0 ;
    FXint arg2 ; FXint arg3 ; FXint arg4 ; FXint arg5 ; VALUE result; VALUE vresult = Qnil; if ((argc < 4) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLViewer, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    arg4 = NUM2INT(argv[2]); arg5 = NUM2INT(argv[3]); result = (VALUE)FXGLViewer_readFeedback(arg1,arg2,arg3,arg4,arg5);
    vresult = result; return vresult; }
static VALUE _wrap_FXGLViewer_setZSortFunc(int argc, VALUE *argv, VALUE self) { FXGLViewer *arg1 = (FXGLViewer *) 0 ;
    VALUE arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLViewer, 1); arg2 = argv[0]; FXGLViewer_setZSortFunc(arg1,arg2);
    return Qnil; }
static VALUE _wrap_FXGLViewer_getZSortFunc(int argc, VALUE *argv, VALUE self) { FXGLViewer *arg1 = (FXGLViewer *) 0 ;
    VALUE result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLViewer, 1);
    result = (VALUE)FXGLViewer_getZSortFunc((FXGLViewer const *)arg1); vresult = result; return vresult; }
static VALUE _wrap_FXGLViewer_setMaxHits(int argc, VALUE *argv, VALUE self) { FXGLViewer *arg1 = (FXGLViewer *) 0 ; FXint arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLViewer, 1); arg2 = NUM2INT(argv[0]); (arg1)->setMaxHits(arg2);
    return Qnil; }
static VALUE _wrap_FXGLViewer_getMaxHits(int argc, VALUE *argv, VALUE self) { FXGLViewer *arg1 = (FXGLViewer *) 0 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLViewer, 1); result = (FXint)((FXGLViewer const *)arg1)->getMaxHits();
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXGLViewer_doesTurbo(int argc, VALUE *argv, VALUE self) { FXGLViewer *arg1 = (FXGLViewer *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLViewer, 1); result = (FXbool)((FXGLViewer const *)arg1)->doesTurbo();
    vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXGLViewer_getTurboMode(int argc, VALUE *argv, VALUE self) { FXGLViewer *arg1 = (FXGLViewer *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLViewer, 1);
    result = (FXbool)((FXGLViewer const *)arg1)->getTurboMode(); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXGLViewer_setTurboMode(int argc, VALUE *argv, VALUE self) { FXGLViewer *arg1 = (FXGLViewer *) 0 ;
    FXbool arg2 = (FXbool) 1 ; if ((argc < 0) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLViewer, 1); if (argc > 0) { arg2 = to_FXbool(argv[0]); } 
    (arg1)->setTurboMode(arg2); return Qnil; }
static VALUE _wrap_FXGLViewer_getLight(int argc, VALUE *argv, VALUE self) { FXGLViewer *arg1 = (FXGLViewer *) 0 ;
    FXLight result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLViewer, 1); result = FXGLViewer_getLight((FXGLViewer const *)arg1); {
        FXLight *resultptr = new FXLight(result); vresult = FXRbGetRubyObj(resultptr, "FXLight *"); }  return vresult; }
static VALUE _wrap_FXGLViewer_setLight(int argc, VALUE *argv, VALUE self) { FXGLViewer *arg1 = (FXGLViewer *) 0 ;
    FXLight *arg2 = 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLViewer, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXLight, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    (arg1)->setLight((FXLight const &)*arg2); return Qnil; }
static void
free_FXGLViewer(FXGLViewer *arg1) {
    delete arg1;
}
static VALUE _wrap_FXGLViewer_save(int argc, VALUE *argv, VALUE self) { FXGLViewer *arg1 = (FXGLViewer *) 0 ;
    FXStream *arg2 = 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLViewer, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXGLViewer_save((FXGLViewer const *)arg1,*arg2); return Qnil; }
static VALUE _wrap_FXGLViewer_load(int argc, VALUE *argv, VALUE self) { FXGLViewer *arg1 = (FXGLViewer *) 0 ;
    FXStream *arg2 = 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLViewer, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXGLViewer_load(arg1,*arg2); return Qnil; }
static VALUE _wrap_FXGLViewer_create(int argc, VALUE *argv, VALUE self) { FXGLViewer *arg1 = (FXGLViewer *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLViewer, 1); FXGLViewer_create(arg1); return Qnil; }
static VALUE _wrap_FXGLViewer_detach(int argc, VALUE *argv, VALUE self) { FXGLViewer *arg1 = (FXGLViewer *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLViewer, 1); FXGLViewer_detach(arg1); return Qnil; }
static VALUE _wrap_FXGLViewer_destroy(int argc, VALUE *argv, VALUE self) { FXGLViewer *arg1 = (FXGLViewer *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLViewer, 1); FXGLViewer_destroy(arg1); return Qnil; }
static VALUE _wrap_FXGLViewer_resize(int argc, VALUE *argv, VALUE self) { FXGLViewer *arg1 = (FXGLViewer *) 0 ; FXint arg2 ;
    FXint arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLViewer, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    FXGLViewer_resize(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXGLViewer_getDefaultWidth(int argc, VALUE *argv, VALUE self) { FXGLViewer *arg1 = (FXGLViewer *) 0 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLViewer, 1); result = (FXint)FXGLViewer_getDefaultWidth(arg1);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXGLViewer_getDefaultHeight(int argc, VALUE *argv, VALUE self) { FXGLViewer *arg1 = (FXGLViewer *) 0 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLViewer, 1); result = (FXint)FXGLViewer_getDefaultHeight(arg1);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXGLViewer_getWidthForHeight(int argc, VALUE *argv, VALUE self) { FXGLViewer *arg1 = (FXGLViewer *) 0 ;
    FXint arg2 ; FXint result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLViewer, 1); arg2 = NUM2INT(argv[0]);
    result = (FXint)FXGLViewer_getWidthForHeight(arg1,arg2); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXGLViewer_getHeightForWidth(int argc, VALUE *argv, VALUE self) { FXGLViewer *arg1 = (FXGLViewer *) 0 ;
    FXint arg2 ; FXint result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLViewer, 1); arg2 = NUM2INT(argv[0]);
    result = (FXint)FXGLViewer_getHeightForWidth(arg1,arg2); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXGLViewer_canFocus(int argc, VALUE *argv, VALUE self) { FXGLViewer *arg1 = (FXGLViewer *) 0 ; FXbool result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLViewer, 1);
    result = (FXbool)FXGLViewer_canFocus((FXGLViewer const *)arg1); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXGLViewer_setFocus(int argc, VALUE *argv, VALUE self) { FXGLViewer *arg1 = (FXGLViewer *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLViewer, 1); FXGLViewer_setFocus(arg1); return Qnil; }
static VALUE _wrap_FXGLViewer_killFocus(int argc, VALUE *argv, VALUE self) { FXGLViewer *arg1 = (FXGLViewer *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLViewer, 1); FXGLViewer_killFocus(arg1); return Qnil; }
static VALUE _wrap_FXGLViewer_setDefault(int argc, VALUE *argv, VALUE self) { FXGLViewer *arg1 = (FXGLViewer *) 0 ;
    FXbool arg2 = (FXbool) 1 ; if ((argc < 0) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLViewer, 1); if (argc > 0) { arg2 = to_FXbool(argv[0]); } 
    FXGLViewer_setDefault(arg1,arg2); return Qnil; }
static VALUE _wrap_FXGLViewer_enable(int argc, VALUE *argv, VALUE self) { FXGLViewer *arg1 = (FXGLViewer *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLViewer, 1); FXGLViewer_enable(arg1); return Qnil; }
static VALUE _wrap_FXGLViewer_disable(int argc, VALUE *argv, VALUE self) { FXGLViewer *arg1 = (FXGLViewer *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLViewer, 1); FXGLViewer_disable(arg1); return Qnil; }
static VALUE _wrap_FXGLViewer_raiseWindow(int argc, VALUE *argv, VALUE self) { FXGLViewer *arg1 = (FXGLViewer *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLViewer, 1); FXGLViewer_raise(arg1); return Qnil; }
static VALUE _wrap_FXGLViewer_lower(int argc, VALUE *argv, VALUE self) { FXGLViewer *arg1 = (FXGLViewer *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLViewer, 1); FXGLViewer_lower(arg1); return Qnil; }
static VALUE _wrap_FXGLViewer_move(int argc, VALUE *argv, VALUE self) { FXGLViewer *arg1 = (FXGLViewer *) 0 ; FXint arg2 ;
    FXint arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLViewer, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    FXGLViewer_move(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXGLViewer_position(int argc, VALUE *argv, VALUE self) { FXGLViewer *arg1 = (FXGLViewer *) 0 ; FXint arg2 ;
    FXint arg3 ; FXint arg4 ; FXint arg5 ; if ((argc < 4) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLViewer, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    arg4 = NUM2INT(argv[2]); arg5 = NUM2INT(argv[3]); FXGLViewer_position(arg1,arg2,arg3,arg4,arg5); return Qnil; }
static VALUE _wrap_FXGLViewer_layout(int argc, VALUE *argv, VALUE self) { FXGLViewer *arg1 = (FXGLViewer *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLViewer, 1); FXGLViewer_layout(arg1); return Qnil; }
static VALUE _wrap_FXGLViewer_recalc(int argc, VALUE *argv, VALUE self) { FXGLViewer *arg1 = (FXGLViewer *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLViewer, 1); FXGLViewer_recalc(arg1); return Qnil; }
static VALUE _wrap_FXGLViewer_reparent(int argc, VALUE *argv, VALUE self) { FXGLViewer *arg1 = (FXGLViewer *) 0 ;
    FXComposite *arg2 = (FXComposite *) 0 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLViewer, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXComposite, 1); FXGLViewer_reparent(arg1,arg2); return Qnil; }
static VALUE _wrap_FXGLViewer_show(int argc, VALUE *argv, VALUE self) { FXGLViewer *arg1 = (FXGLViewer *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLViewer, 1); FXGLViewer_show(arg1); return Qnil; }
static VALUE _wrap_FXGLViewer_hide(int argc, VALUE *argv, VALUE self) { FXGLViewer *arg1 = (FXGLViewer *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLViewer, 1); FXGLViewer_hide(arg1); return Qnil; }
static VALUE _wrap_FXGLViewer_isComposite(int argc, VALUE *argv, VALUE self) { FXGLViewer *arg1 = (FXGLViewer *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLViewer, 1);
    result = (FXbool)FXGLViewer_isComposite((FXGLViewer const *)arg1); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXGLViewer_contains(int argc, VALUE *argv, VALUE self) { FXGLViewer *arg1 = (FXGLViewer *) 0 ; FXint arg2 ;
    FXint arg3 ; FXbool result; VALUE vresult = Qnil; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLViewer, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    result = (FXbool)FXGLViewer_contains((FXGLViewer const *)arg1,arg2,arg3); vresult = result ? Qtrue : Qfalse;
    return vresult; }
static VALUE _wrap_FXGLViewer_doesSaveUnder(int argc, VALUE *argv, VALUE self) { FXGLViewer *arg1 = (FXGLViewer *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLViewer, 1);
    result = (FXbool)FXGLViewer_doesSaveUnder((FXGLViewer const *)arg1); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXGLViewer_setBackColor(int argc, VALUE *argv, VALUE self) { FXGLViewer *arg1 = (FXGLViewer *) 0 ;
    FXColor arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLViewer, 1); arg2 = to_FXColor(argv[0]);
    FXGLViewer_setBackColor(arg1,arg2); return Qnil; }
static VALUE _wrap_FXGLViewer_makeCurrent(int argc, VALUE *argv, VALUE self) { FXGLViewer *arg1 = (FXGLViewer *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLViewer, 1); result = (FXbool)FXGLViewer_makeCurrent(arg1);
    vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXGLViewer_makeNonCurrent(int argc, VALUE *argv, VALUE self) { FXGLViewer *arg1 = (FXGLViewer *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLViewer, 1); result = (FXbool)FXGLViewer_makeNonCurrent(arg1);
    vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXGLViewer_isCurrent(int argc, VALUE *argv, VALUE self) { FXGLViewer *arg1 = (FXGLViewer *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLViewer, 1);
    result = (FXbool)FXGLViewer_isCurrent((FXGLViewer const *)arg1); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXGLViewer_swapBuffers(int argc, VALUE *argv, VALUE self) { FXGLViewer *arg1 = (FXGLViewer *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLViewer, 1); FXGLViewer_swapBuffers(arg1); return Qnil; }
static VALUE _wrap_FXGLViewer_select(int argc, VALUE *argv, VALUE self) { FXGLViewer *arg1 = (FXGLViewer *) 0 ; FXint arg2 ;
    FXint arg3 ; FXint arg4 ; FXint arg5 ; FXGLObject **result; VALUE vresult = Qnil; if ((argc < 4) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLViewer, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    arg4 = NUM2INT(argv[2]); arg5 = NUM2INT(argv[3]); result = (FXGLObject **)FXGLViewer_select(arg1,arg2,arg3,arg4,arg5); {
        vresult=Qnil; if(result){ vresult=rb_ary_new(); register FXGLObject** p=result; while(*p){
                rb_ary_push(vresult,to_ruby(*p)); p++; }  FXFREE(&result); }  }  return vresult; }
static VALUE _wrap_FXGLViewer_pick(int argc, VALUE *argv, VALUE self) { FXGLViewer *arg1 = (FXGLViewer *) 0 ; FXint arg2 ;
    FXint arg3 ; FXGLObject *result; VALUE vresult = Qnil; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLViewer, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    result = (FXGLObject *)FXGLViewer_pick(arg1,arg2,arg3); {
        swig_type_info *ty = SWIG_TypeDynamicCast(SWIGTYPE_p_FXGLObject, (void **) &result);
        vresult = FXRbGetRubyObj(result, ty); }  return vresult; }
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE _wrap_FXGLObject_allocate(VALUE self) {
#else
     static VALUE _wrap_FXGLObject_allocate(int argc, VALUE *argv, VALUE self) {
#endif
         VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_FXGLObject);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
         return vresult; }
static VALUE _wrap_new_FXGLObject(int argc, VALUE *argv, VALUE self) { FXGLObject *result; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc); { result = (FXGLObject *)new_FXGLObject();
        DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result); if(rb_block_given_p()){ rb_yield(self); }  }  return self; }
static VALUE _wrap_FXGLObject_identify(int argc, VALUE *argv, VALUE self) { FXGLObject *arg1 = (FXGLObject *) 0 ;
    FXuint *arg2 = (FXuint *) 0 ; FXint arg3 ; FXGLObject *result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLObject, 1); { Check_Type(argv[0], T_ARRAY);
        FXMALLOC(&arg2,FXuint,RARRAY(argv[0])->len); arg3=static_cast<FXint>(RARRAY(argv[0])->len); for(FXint i=0; i<arg3; i++){
            arg2[i]=NUM2UINT(rb_ary_entry(argv[0],i)); }  }  result = (FXGLObject *)FXGLObject_identify(arg1,arg2,arg3); {
        swig_type_info *ty = SWIG_TypeDynamicCast(SWIGTYPE_p_FXGLObject, (void **) &result);
        vresult = FXRbGetRubyObj(result, ty); }  { FXFREE(&arg2); }  return vresult; }
static void
free_FXGLObject(FXGLObject *arg1) {
    delete arg1;
}
static VALUE _wrap_FXGLObject_save(int argc, VALUE *argv, VALUE self) { FXGLObject *arg1 = (FXGLObject *) 0 ;
    FXStream *arg2 = 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLObject, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXGLObject_save((FXGLObject const *)arg1,*arg2); return Qnil; }
static VALUE _wrap_FXGLObject_load(int argc, VALUE *argv, VALUE self) { FXGLObject *arg1 = (FXGLObject *) 0 ;
    FXStream *arg2 = 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLObject, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXGLObject_load(arg1,*arg2); return Qnil; }
static VALUE _wrap_FXGLObject_copy(int argc, VALUE *argv, VALUE self) { FXGLObject *arg1 = (FXGLObject *) 0 ;
    FXGLObject *result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLObject, 1); result = (FXGLObject *)FXGLObject_copy(arg1); {
        swig_type_info *ty = SWIG_TypeDynamicCast(SWIGTYPE_p_FXGLObject, (void **) &result);
        vresult = FXRbGetRubyObj(result, ty); }  return vresult; }
static VALUE _wrap_FXGLObject_bounds(int argc, VALUE *argv, VALUE self) { FXGLObject *arg1 = (FXGLObject *) 0 ; FXRangef result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLObject, 1); result = FXGLObject_bounds(arg1); {
        FXRangef* resultptr = new FXRangef(result); vresult = FXRbGetRubyObj(resultptr, "FXRangef *"); }  return vresult; }
static VALUE _wrap_FXGLObject_draw(int argc, VALUE *argv, VALUE self) { FXGLObject *arg1 = (FXGLObject *) 0 ;
    FXGLViewer *arg2 = (FXGLViewer *) 0 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLObject, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXGLViewer, 1); FXGLObject_draw(arg1,arg2); return Qnil; }
static VALUE _wrap_FXGLObject_hit(int argc, VALUE *argv, VALUE self) { FXGLObject *arg1 = (FXGLObject *) 0 ;
    FXGLViewer *arg2 = (FXGLViewer *) 0 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLObject, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXGLViewer, 1); FXGLObject_hit(arg1,arg2); return Qnil; }
static VALUE _wrap_FXGLObject_canDrag(int argc, VALUE *argv, VALUE self) { FXGLObject *arg1 = (FXGLObject *) 0 ; FXbool result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLObject, 1);
    result = (FXbool)FXGLObject_canDrag((FXGLObject const *)arg1); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXGLObject_canDelete(int argc, VALUE *argv, VALUE self) { FXGLObject *arg1 = (FXGLObject *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLObject, 1);
    result = (FXbool)FXGLObject_canDelete((FXGLObject const *)arg1); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXGLObject_drag(int argc, VALUE *argv, VALUE self) { FXGLObject *arg1 = (FXGLObject *) 0 ;
    FXGLViewer *arg2 = (FXGLViewer *) 0 ; FXint arg3 ; FXint arg4 ; FXint arg5 ; FXint arg6 ; FXbool result;
    VALUE vresult = Qnil; if ((argc < 5) || (argc > 5)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 5)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLObject, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXGLViewer, 1); arg3 = NUM2INT(argv[1]); arg4 = NUM2INT(argv[2]);
    arg5 = NUM2INT(argv[3]); arg6 = NUM2INT(argv[4]); result = (FXbool)FXGLObject_drag(arg1,arg2,arg3,arg4,arg5,arg6);
    vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXGLShape_onDNDDrop(int argc, VALUE *argv, VALUE self) { FXGLShape *arg1 = (FXGLShape *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLShape, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]);
    SWIG_ConvertPtr(argv[2], (void **) &arg4, 0, 1); result = (long)(arg1)->onDNDDrop(arg2,arg3,arg4);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXGLShape_onDNDMotion(int argc, VALUE *argv, VALUE self) { FXGLShape *arg1 = (FXGLShape *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLShape, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onDNDMotion(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXGLShape_onQueryTip(int argc, VALUE *argv, VALUE self) { FXGLShape *arg1 = (FXGLShape *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLShape, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]);
    SWIG_ConvertPtr(argv[2], (void **) &arg4, 0, 1); result = (long)(arg1)->onQueryTip(arg2,arg3,arg4);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXGLShape_onCmdShadeOff(int argc, VALUE *argv, VALUE self) { FXGLShape *arg1 = (FXGLShape *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLShape, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]);
    SWIG_ConvertPtr(argv[2], (void **) &arg4, 0, 1); result = (long)(arg1)->onCmdShadeOff(arg2,arg3,arg4);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXGLShape_onUpdShadeOff(int argc, VALUE *argv, VALUE self) { FXGLShape *arg1 = (FXGLShape *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLShape, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]);
    SWIG_ConvertPtr(argv[2], (void **) &arg4, 0, 1); result = (long)(arg1)->onUpdShadeOff(arg2,arg3,arg4);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXGLShape_onCmdShadeOn(int argc, VALUE *argv, VALUE self) { FXGLShape *arg1 = (FXGLShape *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLShape, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]);
    SWIG_ConvertPtr(argv[2], (void **) &arg4, 0, 1); result = (long)(arg1)->onCmdShadeOn(arg2,arg3,arg4);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXGLShape_onUpdShadeOn(int argc, VALUE *argv, VALUE self) { FXGLShape *arg1 = (FXGLShape *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLShape, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]);
    SWIG_ConvertPtr(argv[2], (void **) &arg4, 0, 1); result = (long)(arg1)->onUpdShadeOn(arg2,arg3,arg4);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXGLShape_onCmdShadeSmooth(int argc, VALUE *argv, VALUE self) { FXGLShape *arg1 = (FXGLShape *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLShape, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]);
    SWIG_ConvertPtr(argv[2], (void **) &arg4, 0, 1); result = (long)(arg1)->onCmdShadeSmooth(arg2,arg3,arg4);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXGLShape_onUpdShadeSmooth(int argc, VALUE *argv, VALUE self) { FXGLShape *arg1 = (FXGLShape *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLShape, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]);
    SWIG_ConvertPtr(argv[2], (void **) &arg4, 0, 1); result = (long)(arg1)->onUpdShadeSmooth(arg2,arg3,arg4);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXGLShape_onCmdFrontMaterial(int argc, VALUE *argv, VALUE self) { FXGLShape *arg1 = (FXGLShape *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLShape, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]);
    SWIG_ConvertPtr(argv[2], (void **) &arg4, 0, 1); result = (long)(arg1)->onCmdFrontMaterial(arg2,arg3,arg4);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXGLShape_onUpdFrontMaterial(int argc, VALUE *argv, VALUE self) { FXGLShape *arg1 = (FXGLShape *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLShape, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]);
    SWIG_ConvertPtr(argv[2], (void **) &arg4, 0, 1); result = (long)(arg1)->onUpdFrontMaterial(arg2,arg3,arg4);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXGLShape_onCmdBackMaterial(int argc, VALUE *argv, VALUE self) { FXGLShape *arg1 = (FXGLShape *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLShape, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]);
    SWIG_ConvertPtr(argv[2], (void **) &arg4, 0, 1); result = (long)(arg1)->onCmdBackMaterial(arg2,arg3,arg4);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXGLShape_onUpdBackMaterial(int argc, VALUE *argv, VALUE self) { FXGLShape *arg1 = (FXGLShape *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLShape, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]);
    SWIG_ConvertPtr(argv[2], (void **) &arg4, 0, 1); result = (long)(arg1)->onUpdBackMaterial(arg2,arg3,arg4);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXGLShape_onCmdDrawingStyle(int argc, VALUE *argv, VALUE self) { FXGLShape *arg1 = (FXGLShape *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLShape, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]);
    SWIG_ConvertPtr(argv[2], (void **) &arg4, 0, 1); result = (long)(arg1)->onCmdDrawingStyle(arg2,arg3,arg4);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXGLShape_onUpdDrawingStyle(int argc, VALUE *argv, VALUE self) { FXGLShape *arg1 = (FXGLShape *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLShape, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]);
    SWIG_ConvertPtr(argv[2], (void **) &arg4, 0, 1); result = (long)(arg1)->onUpdDrawingStyle(arg2,arg3,arg4);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_new_FXGLShape__SWIG_0(int argc, VALUE *argv, VALUE self) { FXfloat arg1 ; FXfloat arg2 ; FXfloat arg3 ;
    FXuint arg4 ; FXGLShape *result; if ((argc < 4) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc); arg1 = (FXfloat) NUM2DBL(argv[0]);
    arg2 = (FXfloat) NUM2DBL(argv[1]); arg3 = (FXfloat) NUM2DBL(argv[2]); arg4 = NUM2UINT(argv[3]); {
        result = (FXGLShape *)new_FXGLShape__SWIG_0(arg1,arg2,arg3,arg4);
        DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result); if(rb_block_given_p()){ rb_yield(self); }  }  return self; }
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE _wrap_FXGLShape_allocate(VALUE self) {
#else
     static VALUE _wrap_FXGLShape_allocate(int argc, VALUE *argv, VALUE self) {
#endif
         VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_FXGLShape);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
         return vresult; }
static VALUE _wrap_new_FXGLShape__SWIG_1(int argc, VALUE *argv, VALUE self) { FXfloat arg1 ; FXfloat arg2 ; FXfloat arg3 ;
    FXuint arg4 ; FXMaterial *arg5 = 0 ; FXMaterial *arg6 = 0 ; FXGLShape *result; if ((argc < 6) || (argc > 6))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 6)",argc); arg1 = (FXfloat) NUM2DBL(argv[0]);
    arg2 = (FXfloat) NUM2DBL(argv[1]); arg3 = (FXfloat) NUM2DBL(argv[2]); arg4 = NUM2UINT(argv[3]);
    SWIG_ConvertPtr(argv[4], (void **) &arg5, SWIGTYPE_p_FXMaterial, 1); if (arg5 == NULL) rb_raise(rb_eTypeError, "null reference");
    SWIG_ConvertPtr(argv[5], (void **) &arg6, SWIGTYPE_p_FXMaterial, 1); if (arg6 == NULL) rb_raise(rb_eTypeError, "null reference");
    { result = (FXGLShape *)new_FXGLShape__SWIG_1(arg1,arg2,arg3,arg4,(FXMaterial const &)*arg5,(FXMaterial const &)*arg6);
        DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result); if(rb_block_given_p()){ rb_yield(self); }  }  return self; }
static VALUE _wrap_new_FXGLShape(int nargs, VALUE *args, VALUE self) { int argc; VALUE argv[6]; int ii; argc = nargs;
    for (ii = 0; (ii < argc) && (ii < 6); ii++) { argv[ii] = args[ii]; }  if (argc == 4) { int _v; {
            _v = ((TYPE(argv[0]) == T_FLOAT) || (TYPE(argv[0]) == T_FIXNUM) || (TYPE(argv[0]) == T_BIGNUM)) ? 1 : 0; } 
        if (_v) { { _v = ((TYPE(argv[1]) == T_FLOAT) || (TYPE(argv[1]) == T_FIXNUM) || (TYPE(argv[1]) == T_BIGNUM)) ? 1 : 0; } 
            if (_v) { {
                    _v = ((TYPE(argv[2]) == T_FLOAT) || (TYPE(argv[2]) == T_FIXNUM) || (TYPE(argv[2]) == T_BIGNUM)) ? 1 : 0; } 
                if (_v) { { _v = ((TYPE(argv[3]) == T_FIXNUM) || (TYPE(argv[3]) == T_BIGNUM)) ? 1 : 0; }  if (_v) {
                        return _wrap_new_FXGLShape__SWIG_0(nargs, args, self);}  }  }  }  }  if (argc == 6) { int _v; {
            _v = ((TYPE(argv[0]) == T_FLOAT) || (TYPE(argv[0]) == T_FIXNUM) || (TYPE(argv[0]) == T_BIGNUM)) ? 1 : 0; } 
        if (_v) { { _v = ((TYPE(argv[1]) == T_FLOAT) || (TYPE(argv[1]) == T_FIXNUM) || (TYPE(argv[1]) == T_BIGNUM)) ? 1 : 0; } 
            if (_v) { {
                    _v = ((TYPE(argv[2]) == T_FLOAT) || (TYPE(argv[2]) == T_FIXNUM) || (TYPE(argv[2]) == T_BIGNUM)) ? 1 : 0; } 
                if (_v) { { _v = ((TYPE(argv[3]) == T_FIXNUM) || (TYPE(argv[3]) == T_BIGNUM)) ? 1 : 0; }  if (_v) { { void *ptr;
                            _v = (NIL_P(argv[4]) || (TYPE(argv[4]) == T_DATA && SWIG_ConvertPtr(argv[4], &ptr, SWIGTYPE_p_FXMaterial, 0) != -1)) ? 1 : 0; }
                         if (_v) { { void *ptr;
                                _v = (NIL_P(argv[5]) || (TYPE(argv[5]) == T_DATA && SWIG_ConvertPtr(argv[5], &ptr, SWIGTYPE_p_FXMaterial, 0) != -1)) ? 1 : 0; }
                             if (_v) { return _wrap_new_FXGLShape__SWIG_1(nargs, args, self);}  }  }  }  }  }  } 
    rb_raise(rb_eArgError, "No matching function for overloaded 'new_FXGLShape'"); return Qnil; }
static VALUE _wrap_FXGLShape_identify(int argc, VALUE *argv, VALUE self) { FXGLShape *arg1 = (FXGLShape *) 0 ;
    FXuint *arg2 = (FXuint *) 0 ; FXint arg3 ; FXGLObject *result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLShape, 1); { Check_Type(argv[0], T_ARRAY);
        FXMALLOC(&arg2,FXuint,RARRAY(argv[0])->len); arg3=static_cast<FXint>(RARRAY(argv[0])->len); for(FXint i=0; i<arg3; i++){
            arg2[i]=NUM2UINT(rb_ary_entry(argv[0],i)); }  }  result = (FXGLObject *)FXGLShape_identify(arg1,arg2,arg3); {
        swig_type_info *ty = SWIG_TypeDynamicCast(SWIGTYPE_p_FXGLObject, (void **) &result);
        vresult = FXRbGetRubyObj(result, ty); }  { FXFREE(&arg2); }  return vresult; }
static VALUE _wrap_FXGLShape_setTipText(int argc, VALUE *argv, VALUE self) { FXGLShape *arg1 = (FXGLShape *) 0 ;
    FXString *arg2 = 0 ; SwigValueWrapper<FXString > p2 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLShape, 1); p2 = to_FXString(argv[0]); arg2 = &p2;
    (arg1)->setTipText((FXString const &)*arg2); return Qnil; }
static VALUE _wrap_FXGLShape_getTipText(int argc, VALUE *argv, VALUE self) { FXGLShape *arg1 = (FXGLShape *) 0 ;
    FXString result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLShape, 1); result = ((FXGLShape const *)arg1)->getTipText();
    vresult = rb_str_new2((&result)->text()); return vresult; }
static VALUE _wrap_FXGLShape_setMaterial(int argc, VALUE *argv, VALUE self) { FXGLShape *arg1 = (FXGLShape *) 0 ; FXint arg2 ;
    FXMaterial *arg3 = 0 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLShape, 1); arg2 = NUM2INT(argv[0]);
    SWIG_ConvertPtr(argv[1], (void **) &arg3, SWIGTYPE_p_FXMaterial, 1); if (arg3 == NULL) rb_raise(rb_eTypeError, "null reference");
    (arg1)->setMaterial(arg2,(FXMaterial const &)*arg3); return Qnil; }
static VALUE _wrap_FXGLShape_getPosition(int argc, VALUE *argv, VALUE self) { FXGLShape *arg1 = (FXGLShape *) 0 ;
    FXVec3f result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLShape, 1); result = FXGLShape_getPosition((FXGLShape const *)arg1); {
        FXVec3f* resultptr = new FXVec3f(result); vresult = FXRbGetRubyObj(resultptr, "FXVec3f *"); }  return vresult; }
static VALUE _wrap_FXGLShape_setPosition(int argc, VALUE *argv, VALUE self) { FXGLShape *arg1 = (FXGLShape *) 0 ;
    FXVec3f *arg2 = 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLShape, 1); { if (TYPE(argv[0]) == T_ARRAY) {
            arg2 = new FXVec3f(NUM2DBL(rb_ary_entry(argv[0], 0)), NUM2DBL(rb_ary_entry(argv[0], 1)), NUM2DBL(rb_ary_entry(argv[0], 2))); }
         else { FXVec3f *p; SWIG_ConvertPtr(argv[0], (void **)&p, SWIGTYPE_p_FXVec3f, 1); arg2 = new FXVec3f(*p); }  } 
    FXGLShape_setPosition(arg1,(FXVec3f const &)*arg2); delete arg2; return Qnil; }
static VALUE _wrap_FXGLShape_getMaterial(int argc, VALUE *argv, VALUE self) { FXGLShape *arg1 = (FXGLShape *) 0 ; FXint arg2 ;
    FXMaterial result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLShape, 1); arg2 = NUM2INT(argv[0]);
    result = FXGLShape_getMaterial((FXGLShape const *)arg1,arg2); { FXMaterial *resultptr = new FXMaterial(result);
        vresult = FXRbGetRubyObj(resultptr, "FXMaterial *"); }  return vresult; }
static VALUE _wrap_FXGLShape_setRange(int argc, VALUE *argv, VALUE self) { FXGLShape *arg1 = (FXGLShape *) 0 ;
    FXRangef *arg2 = 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLShape, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXRangef, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXGLShape_setRange(arg1,(FXRangef const &)*arg2); return Qnil; }
static void
free_FXGLShape(FXGLShape *arg1) {
    delete arg1;
}
static VALUE _wrap_FXGLShape_save(int argc, VALUE *argv, VALUE self) { FXGLShape *arg1 = (FXGLShape *) 0 ; FXStream *arg2 = 0 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLShape, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXGLShape_save((FXGLShape const *)arg1,*arg2); return Qnil; }
static VALUE _wrap_FXGLShape_load(int argc, VALUE *argv, VALUE self) { FXGLShape *arg1 = (FXGLShape *) 0 ; FXStream *arg2 = 0 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLShape, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXGLShape_load(arg1,*arg2); return Qnil; }
static VALUE _wrap_FXGLShape_copy(int argc, VALUE *argv, VALUE self) { FXGLShape *arg1 = (FXGLShape *) 0 ; FXGLObject *result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLShape, 1); result = (FXGLObject *)FXGLShape_copy(arg1); {
        swig_type_info *ty = SWIG_TypeDynamicCast(SWIGTYPE_p_FXGLObject, (void **) &result);
        vresult = FXRbGetRubyObj(result, ty); }  return vresult; }
static VALUE _wrap_FXGLShape_bounds(int argc, VALUE *argv, VALUE self) { FXGLShape *arg1 = (FXGLShape *) 0 ; FXRangef result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLShape, 1); result = FXGLShape_bounds(arg1); {
        FXRangef* resultptr = new FXRangef(result); vresult = FXRbGetRubyObj(resultptr, "FXRangef *"); }  return vresult; }
static VALUE _wrap_FXGLShape_draw(int argc, VALUE *argv, VALUE self) { FXGLShape *arg1 = (FXGLShape *) 0 ;
    FXGLViewer *arg2 = (FXGLViewer *) 0 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLShape, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXGLViewer, 1); FXGLShape_draw(arg1,arg2); return Qnil; }
static VALUE _wrap_FXGLShape_hit(int argc, VALUE *argv, VALUE self) { FXGLShape *arg1 = (FXGLShape *) 0 ;
    FXGLViewer *arg2 = (FXGLViewer *) 0 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLShape, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXGLViewer, 1); FXGLShape_hit(arg1,arg2); return Qnil; }
static VALUE _wrap_FXGLShape_canDrag(int argc, VALUE *argv, VALUE self) { FXGLShape *arg1 = (FXGLShape *) 0 ; FXbool result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLShape, 1);
    result = (FXbool)FXGLShape_canDrag((FXGLShape const *)arg1); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXGLShape_canDelete(int argc, VALUE *argv, VALUE self) { FXGLShape *arg1 = (FXGLShape *) 0 ; FXbool result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLShape, 1);
    result = (FXbool)FXGLShape_canDelete((FXGLShape const *)arg1); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXGLShape_drag(int argc, VALUE *argv, VALUE self) { FXGLShape *arg1 = (FXGLShape *) 0 ;
    FXGLViewer *arg2 = (FXGLViewer *) 0 ; FXint arg3 ; FXint arg4 ; FXint arg5 ; FXint arg6 ; FXbool result;
    VALUE vresult = Qnil; if ((argc < 5) || (argc > 5)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 5)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLShape, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXGLViewer, 1); arg3 = NUM2INT(argv[1]); arg4 = NUM2INT(argv[2]);
    arg5 = NUM2INT(argv[3]); arg6 = NUM2INT(argv[4]); result = (FXbool)FXGLShape_drag(arg1,arg2,arg3,arg4,arg5,arg6);
    vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXGLShape_drawshape(int argc, VALUE *argv, VALUE self) { FXGLShape *arg1 = (FXGLShape *) 0 ;
    FXGLViewer *arg2 = (FXGLViewer *) 0 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGLShape, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXGLViewer, 1); FXGLShape_drawshape(arg1,arg2); return Qnil; }

/* -------- TYPE CONVERSION AND EQUIVALENCE RULES (BEGIN) -------- */

static void *_p_FXQuatdTo_p_FXVec4d(void *x) {
    return (void *)((FXVec4d *)  ((FXQuatd *) x));
}
static void *_p_FXQuatfTo_p_FXVec4f(void *x) {
    return (void *)((FXVec4f *)  ((FXQuatf *) x));
}
static void *_p_FXDriveBoxTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXPacker *)(FXListBox *) ((FXDriveBox *) x));
}
static void *_p_FXToolBarTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXPacker *) ((FXToolBar *) x));
}
static void *_p_FXToolTipTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXShell *) ((FXToolTip *) x));
}
static void *_p_FXTabBookTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXPacker *)(FXTabBar *) ((FXTabBook *) x));
}
static void *_p_FXGroupBoxTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXPacker *) ((FXGroupBox *) x));
}
static void *_p_FXShellTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *)  ((FXShell *) x));
}
static void *_p_FXStatusBarTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXPacker *)(FXHorizontalFrame *) ((FXStatusBar *) x));
}
static void *_p_FXScrollAreaTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *)  ((FXScrollArea *) x));
}
static void *_p_FXPopupTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXShell *) ((FXPopup *) x));
}
static void *_p_FXScrollWindowTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXScrollArea *) ((FXScrollWindow *) x));
}
static void *_p_FXRootWindowTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *)  ((FXRootWindow *) x));
}
static void *_p_FXTopWindowTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXShell *) ((FXTopWindow *) x));
}
static void *_p_FXMainWindowTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXShell *)(FXTopWindow *) ((FXMainWindow *) x));
}
static void *_p_FXComboBoxTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXPacker *) ((FXComboBox *) x));
}
static void *_p_FXHorizontalFrameTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXPacker *) ((FXHorizontalFrame *) x));
}
static void *_p_FXVerticalFrameTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXPacker *) ((FXVerticalFrame *) x));
}
static void *_p_FX4SplitterTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *)  ((FX4Splitter *) x));
}
static void *_p_FXSplitterTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *)  ((FXSplitter *) x));
}
static void *_p_FXRealSpinnerTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXPacker *) ((FXRealSpinner *) x));
}
static void *_p_FXSpinnerTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXPacker *) ((FXSpinner *) x));
}
static void *_p_FXPackerTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *)  ((FXPacker *) x));
}
static void *_p_FXDirBoxTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXPacker *)(FXTreeListBox *) ((FXDirBox *) x));
}
static void *_p_FXSwitcherTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXPacker *) ((FXSwitcher *) x));
}
static void *_p_FXColorSelectorTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXPacker *) ((FXColorSelector *) x));
}
static void *_p_FXFileSelectorTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXPacker *) ((FXFileSelector *) x));
}
static void *_p_FXDirSelectorTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXPacker *) ((FXDirSelector *) x));
}
static void *_p_FXFontSelectorTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXPacker *) ((FXFontSelector *) x));
}
static void *_p_FXShutterTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXPacker *)(FXVerticalFrame *) ((FXShutter *) x));
}
static void *_p_FXTreeListBoxTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXPacker *) ((FXTreeListBox *) x));
}
static void *_p_FXListBoxTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXPacker *) ((FXListBox *) x));
}
static void *_p_FXMatrixTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXPacker *) ((FXMatrix *) x));
}
static void *_p_FXShutterItemTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXPacker *)(FXVerticalFrame *) ((FXShutterItem *) x));
}
static void *_p_FXTabBarTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXPacker *) ((FXTabBar *) x));
}
static void *_p_FXImageViewTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXScrollArea *) ((FXImageView *) x));
}
static void *_p_FXSpringTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXPacker *) ((FXSpring *) x));
}
static void *_p_FXToolBarShellTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXShell *)(FXTopWindow *) ((FXToolBarShell *) x));
}
static void *_p_FXDriveBoxTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXPacker *)(FXListBox *) ((FXDriveBox *) x));
}
static void *_p_FXToolBarTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXPacker *) ((FXToolBar *) x));
}
static void *_p_FXCompositeTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *)  ((FXComposite *) x));
}
static void *_p_FXToolTipTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXShell *) ((FXToolTip *) x));
}
static void *_p_FXTextFieldTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXFrame *) ((FXTextField *) x));
}
static void *_p_FXTabBookTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXPacker *)(FXTabBar *) ((FXTabBook *) x));
}
static void *_p_FXGLViewerTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXCanvas *)(FXGLCanvas *) ((FXGLViewer *) x));
}
static void *_p_FXArrowButtonTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXFrame *) ((FXArrowButton *) x));
}
static void *_p_FXGroupBoxTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXPacker *) ((FXGroupBox *) x));
}
static void *_p_FXShellTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *) ((FXShell *) x));
}
static void *_p_FXStatusBarTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXPacker *)(FXHorizontalFrame *) ((FXStatusBar *) x));
}
static void *_p_FXScrollAreaTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *) ((FXScrollArea *) x));
}
static void *_p_FXPopupTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXShell *) ((FXPopup *) x));
}
static void *_p_FXScrollWindowTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXScrollArea *) ((FXScrollWindow *) x));
}
static void *_p_FXRootWindowTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *) ((FXRootWindow *) x));
}
static void *_p_FXTopWindowTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXShell *) ((FXTopWindow *) x));
}
static void *_p_FXMainWindowTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXShell *)(FXTopWindow *) ((FXMainWindow *) x));
}
static void *_p_FXRulerTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXFrame *) ((FXRuler *) x));
}
static void *_p_FXCanvasTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *)  ((FXCanvas *) x));
}
static void *_p_FXScrollCornerTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *)  ((FXScrollCorner *) x));
}
static void *_p_FXGLCanvasTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXCanvas *) ((FXGLCanvas *) x));
}
static void *_p_FXVerticalSeparatorTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXFrame *)(FXSeparator *) ((FXVerticalSeparator *) x));
}
static void *_p_FXHorizontalSeparatorTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXFrame *)(FXSeparator *) ((FXHorizontalSeparator *) x));
}
static void *_p_FXSeparatorTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXFrame *) ((FXSeparator *) x));
}
static void *_p_FXStatusLineTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXFrame *) ((FXStatusLine *) x));
}
static void *_p_FXComboBoxTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXPacker *) ((FXComboBox *) x));
}
static void *_p_FXHorizontalFrameTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXPacker *) ((FXHorizontalFrame *) x));
}
static void *_p_FXVerticalFrameTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXPacker *) ((FXVerticalFrame *) x));
}
static void *_p_FX4SplitterTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *) ((FX4Splitter *) x));
}
static void *_p_FXSplitterTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *) ((FXSplitter *) x));
}
static void *_p_FXPackerTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *) ((FXPacker *) x));
}
static void *_p_FXSpinnerTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXPacker *) ((FXSpinner *) x));
}
static void *_p_FXRealSpinnerTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXPacker *) ((FXRealSpinner *) x));
}
static void *_p_FXScrollBarTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *)  ((FXScrollBar *) x));
}
static void *_p_FXColorWheelTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXFrame *) ((FXColorWheel *) x));
}
static void *_p_FXBitmapFrameTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXFrame *) ((FXBitmapFrame *) x));
}
static void *_p_FXDirBoxTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXPacker *)(FXTreeListBox *) ((FXDirBox *) x));
}
static void *_p_FXToolBarGripTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *)  ((FXToolBarGrip *) x));
}
static void *_p_FXImageFrameTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXFrame *) ((FXImageFrame *) x));
}
static void *_p_FXDragCornerTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *)  ((FXDragCorner *) x));
}
static void *_p_FXSwitcherTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXPacker *) ((FXSwitcher *) x));
}
static void *_p_FXDirSelectorTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXPacker *) ((FXDirSelector *) x));
}
static void *_p_FXFileSelectorTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXPacker *) ((FXFileSelector *) x));
}
static void *_p_FXColorSelectorTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXPacker *) ((FXColorSelector *) x));
}
static void *_p_FXFontSelectorTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXPacker *) ((FXFontSelector *) x));
}
static void *_p_FXShutterTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXPacker *)(FXVerticalFrame *) ((FXShutter *) x));
}
static void *_p_FXProgressBarTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXFrame *) ((FXProgressBar *) x));
}
static void *_p_FXListBoxTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXPacker *) ((FXListBox *) x));
}
static void *_p_FXTreeListBoxTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXPacker *) ((FXTreeListBox *) x));
}
static void *_p_FXHeaderTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXFrame *) ((FXHeader *) x));
}
static void *_p_FXMatrixTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXPacker *) ((FXMatrix *) x));
}
static void *_p_FXColorWellTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXFrame *) ((FXColorWell *) x));
}
static void *_p_FXShutterItemTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXPacker *)(FXVerticalFrame *) ((FXShutterItem *) x));
}
static void *_p_FXDialTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXFrame *) ((FXDial *) x));
}
static void *_p_FXToolBarTabTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXFrame *) ((FXToolBarTab *) x));
}
static void *_p_FXFrameTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *)  ((FXFrame *) x));
}
static void *_p_FXTabBarTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXPacker *) ((FXTabBar *) x));
}
static void *_p_FXImageViewTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXScrollArea *) ((FXImageView *) x));
}
static void *_p_FXSliderTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXFrame *) ((FXSlider *) x));
}
static void *_p_FXRealSliderTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXFrame *) ((FXRealSlider *) x));
}
static void *_p_FXSpringTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXPacker *) ((FXSpring *) x));
}
static void *_p_FXColorBarTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXFrame *) ((FXColorBar *) x));
}
static void *_p_FXToolBarShellTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXShell *)(FXTopWindow *) ((FXToolBarShell *) x));
}
static void *_p_FXGLCanvasTo_p_FXCanvas(void *x) {
    return (void *)((FXCanvas *)  ((FXGLCanvas *) x));
}
static void *_p_FXGLViewerTo_p_FXCanvas(void *x) {
    return (void *)((FXCanvas *) (FXGLCanvas *) ((FXGLViewer *) x));
}
static void *_p_FXGLViewerTo_p_FXGLCanvas(void *x) {
    return (void *)((FXGLCanvas *)  ((FXGLViewer *) x));
}
static void *_p_FXDocumentTo_p_FXObject(void *x) {
    return (void *)((FXObject *)  ((FXDocument *) x));
}
static void *_p_FXRegistryTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXDict *)(FXSettings *) ((FXRegistry *) x));
}
static void *_p_FXHeaderItemTo_p_FXObject(void *x) {
    return (void *)((FXObject *)  ((FXHeaderItem *) x));
}
static void *_p_FXShutterItemTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *)(FXVerticalFrame *) ((FXShutterItem *) x));
}
static void *_p_FXColorBarTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXFrame *) ((FXColorBar *) x));
}
static void *_p_FXTabBarTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXTabBar *) x));
}
static void *_p_FXSwitcherTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXSwitcher *) x));
}
static void *_p_FXTextFieldTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXFrame *) ((FXTextField *) x));
}
static void *_p_FXToolBarTabTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXFrame *) ((FXToolBarTab *) x));
}
static void *_p_FXDriveBoxTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *)(FXListBox *) ((FXDriveBox *) x));
}
static void *_p_FXIconDictTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXDict *) ((FXIconDict *) x));
}
static void *_p_FXMatrixTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXMatrix *) x));
}
static void *_p_FXFileDictTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXDict *) ((FXFileDict *) x));
}
static void *_p_FXRecentFilesTo_p_FXObject(void *x) {
    return (void *)((FXObject *)  ((FXRecentFiles *) x));
}
static void *_p_FXScrollCornerTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *) ((FXScrollCorner *) x));
}
static void *_p_FXArrowButtonTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXFrame *) ((FXArrowButton *) x));
}
static void *_p_FXGLViewerTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXCanvas *)(FXGLCanvas *) ((FXGLViewer *) x));
}
static void *_p_FXPopupTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXShell *) ((FXPopup *) x));
}
static void *_p_FXDrawableTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *) ((FXDrawable *) x));
}
static void *_p_FXAppTo_p_FXObject(void *x) {
    return (void *)((FXObject *)  ((FXApp *) x));
}
static void *_p_FXHeaderTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXFrame *) ((FXHeader *) x));
}
static void *_p_FX4SplitterTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *) ((FX4Splitter *) x));
}
static void *_p_FXSplitterTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *) ((FXSplitter *) x));
}
static void *_p_FXSpringTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXSpring *) x));
}
static void *_p_FXPackerTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *) ((FXPacker *) x));
}
static void *_p_FXTabBookTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *)(FXTabBar *) ((FXTabBook *) x));
}
static void *_p_FXImageFrameTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXFrame *) ((FXImageFrame *) x));
}
static void *_p_FXVerticalSeparatorTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXFrame *)(FXSeparator *) ((FXVerticalSeparator *) x));
}
static void *_p_FXHorizontalSeparatorTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXFrame *)(FXSeparator *) ((FXHorizontalSeparator *) x));
}
static void *_p_FXSeparatorTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXFrame *) ((FXSeparator *) x));
}
static void *_p_FXIdTo_p_FXObject(void *x) {
    return (void *)((FXObject *)  ((FXId *) x));
}
static void *_p_FXGLShapeTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXGLObject *) ((FXGLShape *) x));
}
static void *_p_FXProgressBarTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXFrame *) ((FXProgressBar *) x));
}
static void *_p_FXShutterTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *)(FXVerticalFrame *) ((FXShutter *) x));
}
static void *_p_FXGLContextTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *) ((FXGLContext *) x));
}
static void *_p_FXToolTipTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXShell *) ((FXToolTip *) x));
}
static void *_p_FXCompositeTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *) ((FXComposite *) x));
}
static void *_p_FXBitmapFrameTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXFrame *) ((FXBitmapFrame *) x));
}
static void *_p_FXRealSliderTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXFrame *) ((FXRealSlider *) x));
}
static void *_p_FXSliderTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXFrame *) ((FXSlider *) x));
}
static void *_p_FXSettingsTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXDict *) ((FXSettings *) x));
}
static void *_p_FXGroupBoxTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXGroupBox *) x));
}
static void *_p_FXDebugTargetTo_p_FXObject(void *x) {
    return (void *)((FXObject *)  ((FXDebugTarget *) x));
}
static void *_p_FXDataTargetTo_p_FXObject(void *x) {
    return (void *)((FXObject *)  ((FXDataTarget *) x));
}
static void *_p_FXTreeListBoxTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXTreeListBox *) x));
}
static void *_p_FXListBoxTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXListBox *) x));
}
static void *_p_FXCanvasTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *) ((FXCanvas *) x));
}
static void *_p_FXGLCanvasTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXCanvas *) ((FXGLCanvas *) x));
}
static void *_p_FXColorWheelTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXFrame *) ((FXColorWheel *) x));
}
static void *_p_FXVisualTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *) ((FXVisual *) x));
}
static void *_p_FXScrollBarTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *) ((FXScrollBar *) x));
}
static void *_p_FXToolBarGripTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *) ((FXToolBarGrip *) x));
}
static void *_p_FXGLVisualTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXVisual *) ((FXGLVisual *) x));
}
static void *_p_FXFontTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *) ((FXFont *) x));
}
static void *_p_FXComboBoxTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXComboBox *) x));
}
static void *_p_FXFrameTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *) ((FXFrame *) x));
}
static void *_p_FXStringDictTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXDict *) ((FXStringDict *) x));
}
static void *_p_FXStatusBarTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *)(FXHorizontalFrame *) ((FXStatusBar *) x));
}
static void *_p_FXDelegatorTo_p_FXObject(void *x) {
    return (void *)((FXObject *)  ((FXDelegator *) x));
}
static void *_p_FXAccelTableTo_p_FXObject(void *x) {
    return (void *)((FXObject *)  ((FXAccelTable *) x));
}
static void *_p_FXCursorTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *) ((FXCursor *) x));
}
static void *_p_FXCURCursorTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXCursor *) ((FXCURCursor *) x));
}
static void *_p_FXGIFCursorTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXCursor *) ((FXGIFCursor *) x));
}
static void *_p_FXGLObjectTo_p_FXObject(void *x) {
    return (void *)((FXObject *)  ((FXGLObject *) x));
}
static void *_p_FXRealSpinnerTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXRealSpinner *) x));
}
static void *_p_FXSpinnerTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXSpinner *) x));
}
static void *_p_FXStatusLineTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXFrame *) ((FXStatusLine *) x));
}
static void *_p_FXScrollWindowTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXScrollArea *) ((FXScrollWindow *) x));
}
static void *_p_FXWindowTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *) ((FXWindow *) x));
}
static void *_p_FXRootWindowTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *) ((FXRootWindow *) x));
}
static void *_p_FXTopWindowTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXShell *) ((FXTopWindow *) x));
}
static void *_p_FXMainWindowTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXShell *)(FXTopWindow *) ((FXMainWindow *) x));
}
static void *_p_FXDictTo_p_FXObject(void *x) {
    return (void *)((FXObject *)  ((FXDict *) x));
}
static void *_p_FXShellTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *) ((FXShell *) x));
}
static void *_p_FXScrollAreaTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *) ((FXScrollArea *) x));
}
static void *_p_FXColorWellTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXFrame *) ((FXColorWell *) x));
}
static void *_p_FXDragCornerTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *) ((FXDragCorner *) x));
}
static void *_p_FXRulerTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXFrame *) ((FXRuler *) x));
}
static void *_p_FXDialTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXFrame *) ((FXDial *) x));
}
static void *_p_FXHorizontalFrameTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXHorizontalFrame *) x));
}
static void *_p_FXVerticalFrameTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXVerticalFrame *) x));
}
static void *_p_FXImageViewTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXScrollArea *) ((FXImageView *) x));
}
static void *_p_FXDirSelectorTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXDirSelector *) x));
}
static void *_p_FXFileSelectorTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXFileSelector *) x));
}
static void *_p_FXColorSelectorTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXColorSelector *) x));
}
static void *_p_FXFontSelectorTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXFontSelector *) x));
}
static void *_p_FXToolBarTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXToolBar *) x));
}
static void *_p_FXToolBarShellTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXShell *)(FXTopWindow *) ((FXToolBarShell *) x));
}
static void *_p_FXDirBoxTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *)(FXTreeListBox *) ((FXDirBox *) x));
}
static void *_p_FXGLShapeTo_p_FXGLObject(void *x) {
    return (void *)((FXGLObject *)  ((FXGLShape *) x));
}
static void *_p_FXDriveBoxTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *)(FXListBox *) ((FXDriveBox *) x));
}
static void *_p_FXToolBarTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *) ((FXToolBar *) x));
}
static void *_p_FXCompositeTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *) ((FXComposite *) x));
}
static void *_p_FXToolTipTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXShell *) ((FXToolTip *) x));
}
static void *_p_FXTextFieldTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXFrame *) ((FXTextField *) x));
}
static void *_p_FXTabBookTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *)(FXTabBar *) ((FXTabBook *) x));
}
static void *_p_FXGLViewerTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXCanvas *)(FXGLCanvas *) ((FXGLViewer *) x));
}
static void *_p_FXArrowButtonTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXFrame *) ((FXArrowButton *) x));
}
static void *_p_FXGroupBoxTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *) ((FXGroupBox *) x));
}
static void *_p_FXShellTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *) ((FXShell *) x));
}
static void *_p_FXStatusBarTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *)(FXHorizontalFrame *) ((FXStatusBar *) x));
}
static void *_p_FXScrollAreaTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *) ((FXScrollArea *) x));
}
static void *_p_FXPopupTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXShell *) ((FXPopup *) x));
}
static void *_p_FXScrollWindowTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXScrollArea *) ((FXScrollWindow *) x));
}
static void *_p_FXWindowTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *)  ((FXWindow *) x));
}
static void *_p_FXRootWindowTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *) ((FXRootWindow *) x));
}
static void *_p_FXTopWindowTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXShell *) ((FXTopWindow *) x));
}
static void *_p_FXMainWindowTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXShell *)(FXTopWindow *) ((FXMainWindow *) x));
}
static void *_p_FXRulerTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXFrame *) ((FXRuler *) x));
}
static void *_p_FXCanvasTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *) ((FXCanvas *) x));
}
static void *_p_FXScrollCornerTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *) ((FXScrollCorner *) x));
}
static void *_p_FXGLCanvasTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXCanvas *) ((FXGLCanvas *) x));
}
static void *_p_FXHorizontalSeparatorTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXFrame *)(FXSeparator *) ((FXHorizontalSeparator *) x));
}
static void *_p_FXSeparatorTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXFrame *) ((FXSeparator *) x));
}
static void *_p_FXVerticalSeparatorTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXFrame *)(FXSeparator *) ((FXVerticalSeparator *) x));
}
static void *_p_FXStatusLineTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXFrame *) ((FXStatusLine *) x));
}
static void *_p_FXComboBoxTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *) ((FXComboBox *) x));
}
static void *_p_FXHorizontalFrameTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *) ((FXHorizontalFrame *) x));
}
static void *_p_FXVerticalFrameTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *) ((FXVerticalFrame *) x));
}
static void *_p_FX4SplitterTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *) ((FX4Splitter *) x));
}
static void *_p_FXSplitterTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *) ((FXSplitter *) x));
}
static void *_p_FXPackerTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *) ((FXPacker *) x));
}
static void *_p_FXSpinnerTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *) ((FXSpinner *) x));
}
static void *_p_FXRealSpinnerTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *) ((FXRealSpinner *) x));
}
static void *_p_FXScrollBarTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *) ((FXScrollBar *) x));
}
static void *_p_FXColorWheelTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXFrame *) ((FXColorWheel *) x));
}
static void *_p_FXBitmapFrameTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXFrame *) ((FXBitmapFrame *) x));
}
static void *_p_FXDirBoxTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *)(FXTreeListBox *) ((FXDirBox *) x));
}
static void *_p_FXToolBarGripTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *) ((FXToolBarGrip *) x));
}
static void *_p_FXImageFrameTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXFrame *) ((FXImageFrame *) x));
}
static void *_p_FXDragCornerTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *) ((FXDragCorner *) x));
}
static void *_p_FXSwitcherTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *) ((FXSwitcher *) x));
}
static void *_p_FXDirSelectorTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *) ((FXDirSelector *) x));
}
static void *_p_FXFileSelectorTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *) ((FXFileSelector *) x));
}
static void *_p_FXColorSelectorTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *) ((FXColorSelector *) x));
}
static void *_p_FXFontSelectorTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *) ((FXFontSelector *) x));
}
static void *_p_FXShutterTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *)(FXVerticalFrame *) ((FXShutter *) x));
}
static void *_p_FXProgressBarTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXFrame *) ((FXProgressBar *) x));
}
static void *_p_FXListBoxTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *) ((FXListBox *) x));
}
static void *_p_FXTreeListBoxTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *) ((FXTreeListBox *) x));
}
static void *_p_FXHeaderTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXFrame *) ((FXHeader *) x));
}
static void *_p_FXMatrixTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *) ((FXMatrix *) x));
}
static void *_p_FXColorWellTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXFrame *) ((FXColorWell *) x));
}
static void *_p_FXShutterItemTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *)(FXVerticalFrame *) ((FXShutterItem *) x));
}
static void *_p_FXDialTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXFrame *) ((FXDial *) x));
}
static void *_p_FXToolBarTabTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXFrame *) ((FXToolBarTab *) x));
}
static void *_p_FXFrameTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *) ((FXFrame *) x));
}
static void *_p_FXTabBarTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *) ((FXTabBar *) x));
}
static void *_p_FXImageViewTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXScrollArea *) ((FXImageView *) x));
}
static void *_p_FXSliderTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXFrame *) ((FXSlider *) x));
}
static void *_p_FXRealSliderTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXFrame *) ((FXRealSlider *) x));
}
static void *_p_FXSpringTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *) ((FXSpring *) x));
}
static void *_p_FXColorBarTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXFrame *) ((FXColorBar *) x));
}
static void *_p_FXToolBarShellTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXShell *)(FXTopWindow *) ((FXToolBarShell *) x));
}
static void *_p_FXFileStreamTo_p_FXStream(void *x) {
    return (void *)((FXStream *)  ((FXFileStream *) x));
}
static void *_p_FXMemoryStreamTo_p_FXStream(void *x) {
    return (void *)((FXStream *)  ((FXMemoryStream *) x));
}
static void *_p_FXDriveBoxTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *)(FXListBox *) ((FXDriveBox *) x));
}
static void *_p_FXToolBarTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXToolBar *) x));
}
static void *_p_FXCompositeTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *) ((FXComposite *) x));
}
static void *_p_FXToolTipTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXShell *) ((FXToolTip *) x));
}
static void *_p_FXTextFieldTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXFrame *) ((FXTextField *) x));
}
static void *_p_FXTabBookTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *)(FXTabBar *) ((FXTabBook *) x));
}
static void *_p_FXGLViewerTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXCanvas *)(FXGLCanvas *) ((FXGLViewer *) x));
}
static void *_p_FXArrowButtonTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXFrame *) ((FXArrowButton *) x));
}
static void *_p_FXGroupBoxTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXGroupBox *) x));
}
static void *_p_FXShellTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *) ((FXShell *) x));
}
static void *_p_FXStatusBarTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *)(FXHorizontalFrame *) ((FXStatusBar *) x));
}
static void *_p_FXScrollAreaTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *) ((FXScrollArea *) x));
}
static void *_p_FXPopupTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXShell *) ((FXPopup *) x));
}
static void *_p_FXScrollWindowTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXScrollArea *) ((FXScrollWindow *) x));
}
static void *_p_FXWindowTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *) ((FXWindow *) x));
}
static void *_p_FXRootWindowTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *) ((FXRootWindow *) x));
}
static void *_p_FXTopWindowTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXShell *) ((FXTopWindow *) x));
}
static void *_p_FXMainWindowTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXShell *)(FXTopWindow *) ((FXMainWindow *) x));
}
static void *_p_FXRulerTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXFrame *) ((FXRuler *) x));
}
static void *_p_FXCanvasTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *) ((FXCanvas *) x));
}
static void *_p_FXScrollCornerTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *) ((FXScrollCorner *) x));
}
static void *_p_FXGLCanvasTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXCanvas *) ((FXGLCanvas *) x));
}
static void *_p_FXSeparatorTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXFrame *) ((FXSeparator *) x));
}
static void *_p_FXHorizontalSeparatorTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXFrame *)(FXSeparator *) ((FXHorizontalSeparator *) x));
}
static void *_p_FXVerticalSeparatorTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXFrame *)(FXSeparator *) ((FXVerticalSeparator *) x));
}
static void *_p_FXStatusLineTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXFrame *) ((FXStatusLine *) x));
}
static void *_p_FXComboBoxTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXComboBox *) x));
}
static void *_p_FXVerticalFrameTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXVerticalFrame *) x));
}
static void *_p_FXHorizontalFrameTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXHorizontalFrame *) x));
}
static void *_p_FX4SplitterTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *) ((FX4Splitter *) x));
}
static void *_p_FXSplitterTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *) ((FXSplitter *) x));
}
static void *_p_FXPackerTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *) ((FXPacker *) x));
}
static void *_p_FXSpinnerTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXSpinner *) x));
}
static void *_p_FXRealSpinnerTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXRealSpinner *) x));
}
static void *_p_FXScrollBarTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *) ((FXScrollBar *) x));
}
static void *_p_FXColorWheelTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXFrame *) ((FXColorWheel *) x));
}
static void *_p_FXBitmapFrameTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXFrame *) ((FXBitmapFrame *) x));
}
static void *_p_FXGLContextTo_p_FXId(void *x) {
    return (void *)((FXId *)  ((FXGLContext *) x));
}
static void *_p_FXFontTo_p_FXId(void *x) {
    return (void *)((FXId *)  ((FXFont *) x));
}
static void *_p_FXDirBoxTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *)(FXTreeListBox *) ((FXDirBox *) x));
}
static void *_p_FXToolBarGripTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *) ((FXToolBarGrip *) x));
}
static void *_p_FXImageFrameTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXFrame *) ((FXImageFrame *) x));
}
static void *_p_FXDragCornerTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *) ((FXDragCorner *) x));
}
static void *_p_FXSwitcherTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXSwitcher *) x));
}
static void *_p_FXDirSelectorTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXDirSelector *) x));
}
static void *_p_FXFileSelectorTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXFileSelector *) x));
}
static void *_p_FXColorSelectorTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXColorSelector *) x));
}
static void *_p_FXFontSelectorTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXFontSelector *) x));
}
static void *_p_FXShutterTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *)(FXVerticalFrame *) ((FXShutter *) x));
}
static void *_p_FXDrawableTo_p_FXId(void *x) {
    return (void *)((FXId *)  ((FXDrawable *) x));
}
static void *_p_FXCursorTo_p_FXId(void *x) {
    return (void *)((FXId *)  ((FXCursor *) x));
}
static void *_p_FXCURCursorTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXCursor *) ((FXCURCursor *) x));
}
static void *_p_FXGIFCursorTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXCursor *) ((FXGIFCursor *) x));
}
static void *_p_FXProgressBarTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXFrame *) ((FXProgressBar *) x));
}
static void *_p_FXListBoxTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXListBox *) x));
}
static void *_p_FXTreeListBoxTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXTreeListBox *) x));
}
static void *_p_FXHeaderTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXFrame *) ((FXHeader *) x));
}
static void *_p_FXMatrixTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXMatrix *) x));
}
static void *_p_FXColorWellTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXFrame *) ((FXColorWell *) x));
}
static void *_p_FXShutterItemTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *)(FXVerticalFrame *) ((FXShutterItem *) x));
}
static void *_p_FXDialTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXFrame *) ((FXDial *) x));
}
static void *_p_FXToolBarTabTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXFrame *) ((FXToolBarTab *) x));
}
static void *_p_FXFrameTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *) ((FXFrame *) x));
}
static void *_p_FXTabBarTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXTabBar *) x));
}
static void *_p_FXImageViewTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXScrollArea *) ((FXImageView *) x));
}
static void *_p_FXSliderTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXFrame *) ((FXSlider *) x));
}
static void *_p_FXRealSliderTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXFrame *) ((FXRealSlider *) x));
}
static void *_p_FXSpringTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXSpring *) x));
}
static void *_p_FXVisualTo_p_FXId(void *x) {
    return (void *)((FXId *)  ((FXVisual *) x));
}
static void *_p_FXGLVisualTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXVisual *) ((FXGLVisual *) x));
}
static void *_p_FXColorBarTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXFrame *) ((FXColorBar *) x));
}
static void *_p_FXToolBarShellTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXShell *)(FXTopWindow *) ((FXToolBarShell *) x));
}
static void *_p_FXGLVisualTo_p_FXVisual(void *x) {
    return (void *)((FXVisual *)  ((FXGLVisual *) x));
}
static swig_type_info _swigt__p_FXMat4d[] = {{"_p_FXMat4d", 0, "FXMat4d *", 0, 0, 0, 0},{"_p_FXMat4d", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXVec4d[] = {{"_p_FXVec4d", 0, "FXVec4d *", 0, 0, 0, 0},{"_p_FXQuatd", _p_FXQuatdTo_p_FXVec4d, 0, 0, 0, 0, 0},{"_p_FXVec4d", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXMat4f[] = {{"_p_FXMat4f", 0, "FXMat4f *", 0, 0, 0, 0},{"_p_FXMat4f", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXVec4f[] = {{"_p_FXVec4f", 0, "FXVec4f *", 0, 0, 0, 0},{"_p_FXVec4f", 0, 0, 0, 0, 0, 0},{"_p_FXQuatf", _p_FXQuatfTo_p_FXVec4f, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXfloat[] = {{"_p_FXfloat", 0, "float const []|FXfloat const []", 0, 0, 0, 0},{"_p_FXfloat", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXMat3d[] = {{"_p_FXMat3d", 0, "FXMat3d *", 0, 0, 0, 0},{"_p_FXMat3d", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXComposite[] = {{"_p_FXComposite", 0, "FXComposite *", 0, 0, 0, 0},{"_p_FXDriveBox", _p_FXDriveBoxTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXToolBar", _p_FXToolBarTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXComposite", 0, 0, 0, 0, 0, 0},{"_p_FXToolTip", _p_FXToolTipTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXTabBook", _p_FXTabBookTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXGroupBox", _p_FXGroupBoxTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXShell", _p_FXShellTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXStatusBar", _p_FXStatusBarTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXScrollArea", _p_FXScrollAreaTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXPopup", _p_FXPopupTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXScrollWindow", _p_FXScrollWindowTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXRootWindow", _p_FXRootWindowTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXTopWindow", _p_FXTopWindowTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXMainWindow", _p_FXMainWindowTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXComboBox", _p_FXComboBoxTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXHorizontalFrame", _p_FXHorizontalFrameTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXVerticalFrame", _p_FXVerticalFrameTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FX4Splitter", _p_FX4SplitterTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXSplitter", _p_FXSplitterTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXRealSpinner", _p_FXRealSpinnerTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXSpinner", _p_FXSpinnerTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXPacker", _p_FXPackerTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXDirBox", _p_FXDirBoxTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXSwitcher", _p_FXSwitcherTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXColorSelector", _p_FXColorSelectorTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXFileSelector", _p_FXFileSelectorTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXDirSelector", _p_FXDirSelectorTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXFontSelector", _p_FXFontSelectorTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXShutter", _p_FXShutterTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXTreeListBox", _p_FXTreeListBoxTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXListBox", _p_FXListBoxTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXMatrix", _p_FXMatrixTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXShutterItem", _p_FXShutterItemTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXTabBar", _p_FXTabBarTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXImageView", _p_FXImageViewTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXSpring", _p_FXSpringTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXToolBarShell", _p_FXToolBarShellTo_p_FXComposite, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXVec3d[] = {{"_p_FXVec3d", 0, "FXVec3d *", 0, 0, 0, 0},{"_p_FXVec3d", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXGLViewer[] = {{"_p_FXGLViewer", 0, "FXGLViewer *", 0, 0, 0, 0},{"_p_FXGLViewer", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXMat3f[] = {{"_p_FXMat3f", 0, "FXMat3f *", 0, 0, 0, 0},{"_p_FXMat3f", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXViewport[] = {{"_p_FXViewport", 0, "FXViewport *", 0, 0, 0, 0},{"_p_FXViewport", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXId[] = {{"_p_FXId", 0, "FXId *", 0, 0, 0, 0},{"_p_FXDriveBox", _p_FXDriveBoxTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXDial", _p_FXDialTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXToolBar", _p_FXToolBarTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXComposite", _p_FXCompositeTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXToolTip", _p_FXToolTipTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXTabBook", _p_FXTabBookTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXGLViewer", _p_FXGLViewerTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXTextField", _p_FXTextFieldTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXId", 0, 0, 0, 0, 0, 0},{"_p_FXArrowButton", _p_FXArrowButtonTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXGroupBox", _p_FXGroupBoxTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXShell", _p_FXShellTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXStatusBar", _p_FXStatusBarTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXScrollArea", _p_FXScrollAreaTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXPopup", _p_FXPopupTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXMainWindow", _p_FXMainWindowTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXTopWindow", _p_FXTopWindowTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXScrollWindow", _p_FXScrollWindowTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXRootWindow", _p_FXRootWindowTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXScrollCorner", _p_FXScrollCornerTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXWindow", _p_FXWindowTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXRuler", _p_FXRulerTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXGLCanvas", _p_FXGLCanvasTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXCanvas", _p_FXCanvasTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXComboBox", _p_FXComboBoxTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXSeparator", _p_FXSeparatorTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXHorizontalSeparator", _p_FXHorizontalSeparatorTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXVerticalSeparator", _p_FXVerticalSeparatorTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXStatusLine", _p_FXStatusLineTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXHorizontalFrame", _p_FXHorizontalFrameTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXVerticalFrame", _p_FXVerticalFrameTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FX4Splitter", _p_FX4SplitterTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXSplitter", _p_FXSplitterTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXRealSpinner", _p_FXRealSpinnerTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXSpinner", _p_FXSpinnerTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXPacker", _p_FXPackerTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXScrollBar", _p_FXScrollBarTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXColorWheel", _p_FXColorWheelTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXBitmapFrame", _p_FXBitmapFrameTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXGLContext", _p_FXGLContextTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXDirBox", _p_FXDirBoxTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXToolBarGrip", _p_FXToolBarGripTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXImageFrame", _p_FXImageFrameTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXDragCorner", _p_FXDragCornerTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXSwitcher", _p_FXSwitcherTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXColorSelector", _p_FXColorSelectorTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXFileSelector", _p_FXFileSelectorTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXDirSelector", _p_FXDirSelectorTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXFontSelector", _p_FXFontSelectorTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXShutter", _p_FXShutterTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXProgressBar", _p_FXProgressBarTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXDrawable", _p_FXDrawableTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXCursor", _p_FXCursorTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXCURCursor", _p_FXCURCursorTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXGIFCursor", _p_FXGIFCursorTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXTreeListBox", _p_FXTreeListBoxTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXListBox", _p_FXListBoxTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXHeader", _p_FXHeaderTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXMatrix", _p_FXMatrixTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXShutterItem", _p_FXShutterItemTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXColorWell", _p_FXColorWellTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXToolBarTab", _p_FXToolBarTabTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXTabBar", _p_FXTabBarTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXFrame", _p_FXFrameTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXFont", _p_FXFontTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXImageView", _p_FXImageViewTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXSlider", _p_FXSliderTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXRealSlider", _p_FXRealSliderTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXSpring", _p_FXSpringTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXVisual", _p_FXVisualTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXGLVisual", _p_FXGLVisualTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXColorBar", _p_FXColorBarTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXToolBarShell", _p_FXToolBarShellTo_p_FXId, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXVec3f[] = {{"_p_FXVec3f", 0, "FXVec3f *", 0, 0, 0, 0},{"_p_FXVec3f", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXWindow[] = {{"_p_FXWindow", 0, "FXWindow *", 0, 0, 0, 0},{"_p_FXDriveBox", _p_FXDriveBoxTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXDial", _p_FXDialTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXToolBar", _p_FXToolBarTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXComposite", _p_FXCompositeTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXToolTip", _p_FXToolTipTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXTabBook", _p_FXTabBookTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXGLViewer", _p_FXGLViewerTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXTextField", _p_FXTextFieldTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXArrowButton", _p_FXArrowButtonTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXGroupBox", _p_FXGroupBoxTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXShell", _p_FXShellTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXStatusBar", _p_FXStatusBarTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXScrollArea", _p_FXScrollAreaTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXPopup", _p_FXPopupTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXMainWindow", _p_FXMainWindowTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXTopWindow", _p_FXTopWindowTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXWindow", 0, 0, 0, 0, 0, 0},{"_p_FXScrollWindow", _p_FXScrollWindowTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXRootWindow", _p_FXRootWindowTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXScrollCorner", _p_FXScrollCornerTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXRuler", _p_FXRulerTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXGLCanvas", _p_FXGLCanvasTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXCanvas", _p_FXCanvasTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXComboBox", _p_FXComboBoxTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXSeparator", _p_FXSeparatorTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXHorizontalSeparator", _p_FXHorizontalSeparatorTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXVerticalSeparator", _p_FXVerticalSeparatorTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXStatusLine", _p_FXStatusLineTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXHorizontalFrame", _p_FXHorizontalFrameTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXVerticalFrame", _p_FXVerticalFrameTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FX4Splitter", _p_FX4SplitterTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXSplitter", _p_FXSplitterTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXRealSpinner", _p_FXRealSpinnerTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXSpinner", _p_FXSpinnerTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXPacker", _p_FXPackerTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXScrollBar", _p_FXScrollBarTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXColorWheel", _p_FXColorWheelTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXBitmapFrame", _p_FXBitmapFrameTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXDirBox", _p_FXDirBoxTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXToolBarGrip", _p_FXToolBarGripTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXImageFrame", _p_FXImageFrameTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXDragCorner", _p_FXDragCornerTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXSwitcher", _p_FXSwitcherTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXColorSelector", _p_FXColorSelectorTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXFileSelector", _p_FXFileSelectorTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXDirSelector", _p_FXDirSelectorTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXFontSelector", _p_FXFontSelectorTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXShutter", _p_FXShutterTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXProgressBar", _p_FXProgressBarTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXTreeListBox", _p_FXTreeListBoxTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXListBox", _p_FXListBoxTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXHeader", _p_FXHeaderTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXMatrix", _p_FXMatrixTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXShutterItem", _p_FXShutterItemTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXColorWell", _p_FXColorWellTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXToolBarTab", _p_FXToolBarTabTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXTabBar", _p_FXTabBarTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXFrame", _p_FXFrameTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXImageView", _p_FXImageViewTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXSlider", _p_FXSliderTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXRealSlider", _p_FXRealSliderTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXSpring", _p_FXSpringTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXColorBar", _p_FXColorBarTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXToolBarShell", _p_FXToolBarShellTo_p_FXWindow, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXCanvas[] = {{"_p_FXCanvas", 0, "FXCanvas *", 0, 0, 0, 0},{"_p_FXCanvas", 0, 0, 0, 0, 0, 0},{"_p_FXGLCanvas", _p_FXGLCanvasTo_p_FXCanvas, 0, 0, 0, 0, 0},{"_p_FXGLViewer", _p_FXGLViewerTo_p_FXCanvas, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXGLCanvas[] = {{"_p_FXGLCanvas", 0, "FXGLCanvas *", 0, 0, 0, 0},{"_p_FXGLCanvas", 0, 0, 0, 0, 0, 0},{"_p_FXGLViewer", _p_FXGLViewerTo_p_FXGLCanvas, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXRanged[] = {{"_p_FXRanged", 0, "FXRanged *", 0, 0, 0, 0},{"_p_FXRanged", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXSphered[] = {{"_p_FXSphered", 0, "FXSphered *", 0, 0, 0, 0},{"_p_FXSphered", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXVec2d[] = {{"_p_FXVec2d", 0, "FXVec2d *", 0, 0, 0, 0},{"_p_FXVec2d", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXSpheref[] = {{"_p_FXSpheref", 0, "FXSpheref *", 0, 0, 0, 0},{"_p_FXSpheref", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXRangef[] = {{"_p_FXRangef", 0, "FXRangef *", 0, 0, 0, 0},{"_p_FXRangef", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXVec2f[] = {{"_p_FXVec2f", 0, "FXVec2f *", 0, 0, 0, 0},{"_p_FXVec2f", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXObject[] = {{"_p_FXObject", 0, "FXObject *", 0, 0, 0, 0},{"_p_FXDocument", _p_FXDocumentTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXRegistry", _p_FXRegistryTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXHeaderItem", _p_FXHeaderItemTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXShutterItem", _p_FXShutterItemTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXColorBar", _p_FXColorBarTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXTabBar", _p_FXTabBarTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXSwitcher", _p_FXSwitcherTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXTextField", _p_FXTextFieldTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXToolBarTab", _p_FXToolBarTabTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXDriveBox", _p_FXDriveBoxTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXIconDict", _p_FXIconDictTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXMatrix", _p_FXMatrixTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXFileDict", _p_FXFileDictTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXRecentFiles", _p_FXRecentFilesTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXScrollCorner", _p_FXScrollCornerTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXArrowButton", _p_FXArrowButtonTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXGLViewer", _p_FXGLViewerTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXPopup", _p_FXPopupTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXDrawable", _p_FXDrawableTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXFont", _p_FXFontTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXHeader", _p_FXHeaderTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FX4Splitter", _p_FX4SplitterTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXSplitter", _p_FXSplitterTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXSpring", _p_FXSpringTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXApp", _p_FXAppTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXPacker", _p_FXPackerTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXTabBook", _p_FXTabBookTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXImageFrame", _p_FXImageFrameTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXVerticalSeparator", _p_FXVerticalSeparatorTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXHorizontalSeparator", _p_FXHorizontalSeparatorTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXSeparator", _p_FXSeparatorTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXGLShape", _p_FXGLShapeTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXProgressBar", _p_FXProgressBarTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXShutter", _p_FXShutterTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXGLContext", _p_FXGLContextTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXToolTip", _p_FXToolTipTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXComposite", _p_FXCompositeTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXDict", _p_FXDictTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXBitmapFrame", _p_FXBitmapFrameTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXRealSlider", _p_FXRealSliderTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXSlider", _p_FXSliderTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXSettings", _p_FXSettingsTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXGroupBox", _p_FXGroupBoxTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXDataTarget", _p_FXDataTargetTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXDebugTarget", _p_FXDebugTargetTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXTreeListBox", _p_FXTreeListBoxTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXListBox", _p_FXListBoxTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXCanvas", _p_FXCanvasTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXGLCanvas", _p_FXGLCanvasTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXId", _p_FXIdTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXColorWheel", _p_FXColorWheelTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXDial", _p_FXDialTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXToolBarGrip", _p_FXToolBarGripTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXScrollBar", _p_FXScrollBarTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXVisual", _p_FXVisualTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXGLVisual", _p_FXGLVisualTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXComboBox", _p_FXComboBoxTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXFrame", _p_FXFrameTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXStatusBar", _p_FXStatusBarTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXStringDict", _p_FXStringDictTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXDelegator", _p_FXDelegatorTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXAccelTable", _p_FXAccelTableTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXObject", 0, 0, 0, 0, 0, 0},{"_p_FXCursor", _p_FXCursorTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXCURCursor", _p_FXCURCursorTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXGIFCursor", _p_FXGIFCursorTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXGLObject", _p_FXGLObjectTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXRealSpinner", _p_FXRealSpinnerTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXSpinner", _p_FXSpinnerTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXStatusLine", _p_FXStatusLineTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXWindow", _p_FXWindowTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXScrollWindow", _p_FXScrollWindowTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXRootWindow", _p_FXRootWindowTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXTopWindow", _p_FXTopWindowTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXMainWindow", _p_FXMainWindowTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXShell", _p_FXShellTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXScrollArea", _p_FXScrollAreaTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXColorWell", _p_FXColorWellTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXDragCorner", _p_FXDragCornerTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXRuler", _p_FXRulerTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXHorizontalFrame", _p_FXHorizontalFrameTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXVerticalFrame", _p_FXVerticalFrameTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXImageView", _p_FXImageViewTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXColorSelector", _p_FXColorSelectorTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXFileSelector", _p_FXFileSelectorTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXDirSelector", _p_FXDirSelectorTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXFontSelector", _p_FXFontSelectorTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXToolBarShell", _p_FXToolBarShellTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXToolBar", _p_FXToolBarTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXDirBox", _p_FXDirBoxTo_p_FXObject, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXGLObject[] = {{"_p_FXGLObject", 0, "FXGLObject *", 0, 0, 0, 0},{"_p_FXGLShape", _p_FXGLShapeTo_p_FXGLObject, 0, 0, 0, 0, 0},{"_p_FXGLObject", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXGLContext[] = {{"_p_FXGLContext", 0, "FXGLContext *", 0, 0, 0, 0},{"_p_FXGLContext", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXMaterial[] = {{"_p_FXMaterial", 0, "FXMaterial *", 0, 0, 0, 0},{"_p_FXMaterial", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXQuatd[] = {{"_p_FXQuatd", 0, "FXQuatd *", 0, 0, 0, 0},{"_p_FXQuatd", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXQuatf[] = {{"_p_FXQuatf", 0, "FXQuatf *", 0, 0, 0, 0},{"_p_FXQuatf", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXGLShape[] = {{"_p_FXGLShape", 0, "FXGLShape *", 0, 0, 0, 0},{"_p_FXGLShape", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXDrawable[] = {{"_p_FXDrawable", 0, "FXDrawable *", 0, 0, 0, 0},{"_p_FXDriveBox", _p_FXDriveBoxTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXDial", _p_FXDialTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXToolBar", _p_FXToolBarTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXComposite", _p_FXCompositeTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXToolTip", _p_FXToolTipTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXTabBook", _p_FXTabBookTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXGLViewer", _p_FXGLViewerTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXTextField", _p_FXTextFieldTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXArrowButton", _p_FXArrowButtonTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXGroupBox", _p_FXGroupBoxTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXShell", _p_FXShellTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXStatusBar", _p_FXStatusBarTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXScrollArea", _p_FXScrollAreaTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXPopup", _p_FXPopupTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXMainWindow", _p_FXMainWindowTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXTopWindow", _p_FXTopWindowTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXScrollWindow", _p_FXScrollWindowTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXRootWindow", _p_FXRootWindowTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXScrollCorner", _p_FXScrollCornerTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXWindow", _p_FXWindowTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXRuler", _p_FXRulerTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXGLCanvas", _p_FXGLCanvasTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXCanvas", _p_FXCanvasTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXComboBox", _p_FXComboBoxTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXSeparator", _p_FXSeparatorTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXHorizontalSeparator", _p_FXHorizontalSeparatorTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXVerticalSeparator", _p_FXVerticalSeparatorTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXStatusLine", _p_FXStatusLineTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXHorizontalFrame", _p_FXHorizontalFrameTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXVerticalFrame", _p_FXVerticalFrameTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FX4Splitter", _p_FX4SplitterTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXSplitter", _p_FXSplitterTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXRealSpinner", _p_FXRealSpinnerTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXSpinner", _p_FXSpinnerTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXPacker", _p_FXPackerTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXScrollBar", _p_FXScrollBarTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXColorWheel", _p_FXColorWheelTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXBitmapFrame", _p_FXBitmapFrameTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXDirBox", _p_FXDirBoxTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXToolBarGrip", _p_FXToolBarGripTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXImageFrame", _p_FXImageFrameTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXDragCorner", _p_FXDragCornerTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXSwitcher", _p_FXSwitcherTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXColorSelector", _p_FXColorSelectorTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXFileSelector", _p_FXFileSelectorTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXDirSelector", _p_FXDirSelectorTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXFontSelector", _p_FXFontSelectorTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXShutter", _p_FXShutterTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXDrawable", 0, 0, 0, 0, 0, 0},{"_p_FXProgressBar", _p_FXProgressBarTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXTreeListBox", _p_FXTreeListBoxTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXListBox", _p_FXListBoxTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXHeader", _p_FXHeaderTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXMatrix", _p_FXMatrixTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXShutterItem", _p_FXShutterItemTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXColorWell", _p_FXColorWellTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXToolBarTab", _p_FXToolBarTabTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXTabBar", _p_FXTabBarTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXFrame", _p_FXFrameTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXImageView", _p_FXImageViewTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXSlider", _p_FXSliderTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXRealSlider", _p_FXRealSliderTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXSpring", _p_FXSpringTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXColorBar", _p_FXColorBarTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXToolBarShell", _p_FXToolBarShellTo_p_FXDrawable, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXStream[] = {{"_p_FXStream", 0, "FXStream *", 0, 0, 0, 0},{"_p_FXFileStream", _p_FXFileStreamTo_p_FXStream, 0, 0, 0, 0, 0},{"_p_FXMemoryStream", _p_FXMemoryStreamTo_p_FXStream, 0, 0, 0, 0, 0},{"_p_FXStream", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXApp[] = {{"_p_FXApp", 0, "FXApp *", 0, 0, 0, 0},{"_p_FXApp", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXLight[] = {{"_p_FXLight", 0, "FXLight *", 0, 0, 0, 0},{"_p_FXLight", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXFont[] = {{"_p_FXFont", 0, "FXFont *", 0, 0, 0, 0},{"_p_FXFont", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXGLVisual[] = {{"_p_FXGLVisual", 0, "FXGLVisual *", 0, 0, 0, 0},{"_p_FXGLVisual", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXVisual[] = {{"_p_FXVisual", 0, "FXVisual *", 0, 0, 0, 0},{"_p_FXVisual", 0, 0, 0, 0, 0, 0},{"_p_FXGLVisual", _p_FXGLVisualTo_p_FXVisual, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXuint[] = {{"_p_FXuint", 0, "unsigned int *|FXuint *", 0, 0, 0, 0},{"_p_FXuint", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};

static swig_type_info *swig_types_initial[] = {
_swigt__p_FXMat4d, 
_swigt__p_FXVec4d, 
_swigt__p_FXMat4f, 
_swigt__p_FXVec4f, 
_swigt__p_FXfloat, 
_swigt__p_FXMat3d, 
_swigt__p_FXComposite, 
_swigt__p_FXVec3d, 
_swigt__p_FXGLViewer, 
_swigt__p_FXMat3f, 
_swigt__p_FXViewport, 
_swigt__p_FXId, 
_swigt__p_FXVec3f, 
_swigt__p_FXWindow, 
_swigt__p_FXCanvas, 
_swigt__p_FXGLCanvas, 
_swigt__p_FXRanged, 
_swigt__p_FXSphered, 
_swigt__p_FXVec2d, 
_swigt__p_FXSpheref, 
_swigt__p_FXRangef, 
_swigt__p_FXVec2f, 
_swigt__p_FXObject, 
_swigt__p_FXGLObject, 
_swigt__p_FXGLContext, 
_swigt__p_FXMaterial, 
_swigt__p_FXQuatd, 
_swigt__p_FXQuatf, 
_swigt__p_FXGLShape, 
_swigt__p_FXDrawable, 
_swigt__p_FXStream, 
_swigt__p_FXApp, 
_swigt__p_FXLight, 
_swigt__p_FXFont, 
_swigt__p_FXGLVisual, 
_swigt__p_FXVisual, 
_swigt__p_FXuint, 
0
};


/* -------- TYPE CONVERSION AND EQUIVALENCE RULES (END) -------- */


#ifdef __cplusplus
extern "C"
#endif
SWIGEXPORT(void) Init_fx3d(void) {
    int i;
    
    SWIG_InitRuntime();
    
    for (i = 0; swig_types_initial[i]; i++) {
        swig_types[i] = SWIG_TypeRegister(swig_types_initial[i]);
        SWIG_define_class(swig_types[i]);
    }
    
    
    cFXVec2f.klass = rb_define_class_under(mFox, "FXVec2f", rb_cObject);
    SWIG_TypeClientData(SWIGTYPE_p_FXVec2f, (void *) &cFXVec2f);
    rb_define_alloc_func(cFXVec2f.klass, _wrap_FXVec2f_allocate);
    rb_define_method(cFXVec2f.klass, "initialize", VALUEFUNC(_wrap_new_FXVec2f), -1);
    rb_define_method(cFXVec2f.klass, "x=", VALUEFUNC(_wrap_FXVec2f_x_set), -1);
    rb_define_method(cFXVec2f.klass, "x", VALUEFUNC(_wrap_FXVec2f_x_get), -1);
    rb_define_method(cFXVec2f.klass, "y=", VALUEFUNC(_wrap_FXVec2f_y_set), -1);
    rb_define_method(cFXVec2f.klass, "y", VALUEFUNC(_wrap_FXVec2f_y_get), -1);
    rb_define_method(cFXVec2f.klass, "[]", VALUEFUNC(_wrap_FXVec2f___getitem__), -1);
    rb_define_method(cFXVec2f.klass, "[]=", VALUEFUNC(_wrap_FXVec2f___setitem__), -1);
    rb_define_method(cFXVec2f.klass, "-@", VALUEFUNC(_wrap_FXVec2f___neg__), -1);
    rb_define_method(cFXVec2f.klass, "+", VALUEFUNC(_wrap_FXVec2f___add__), -1);
    rb_define_method(cFXVec2f.klass, "-", VALUEFUNC(_wrap_FXVec2f___sub__), -1);
    rb_define_method(cFXVec2f.klass, "/", VALUEFUNC(_wrap_FXVec2f___div__), -1);
    rb_define_method(cFXVec2f.klass, "*", VALUEFUNC(_wrap_FXVec2f___mul__), -1);
    rb_define_method(cFXVec2f.klass, "dot", VALUEFUNC(_wrap_FXVec2f_dot), -1);
    rb_define_method(cFXVec2f.klass, "==", VALUEFUNC(_wrap_FXVec2f___eq__), -1);
    rb_define_method(cFXVec2f.klass, "len2", VALUEFUNC(_wrap_FXVec2f_len2), -1);
    rb_define_method(cFXVec2f.klass, "len", VALUEFUNC(_wrap_FXVec2f_len), -1);
    rb_define_method(cFXVec2f.klass, "normalize", VALUEFUNC(_wrap_FXVec2f_normalize), -1);
    rb_define_method(cFXVec2f.klass, "lo", VALUEFUNC(_wrap_FXVec2f_lo), -1);
    rb_define_method(cFXVec2f.klass, "hi", VALUEFUNC(_wrap_FXVec2f_hi), -1);
    rb_define_method(cFXVec2f.klass, "to_a", VALUEFUNC(_wrap_FXVec2f_to_a), -1);
    rb_define_method(cFXVec2f.klass, "to_s", VALUEFUNC(_wrap_FXVec2f_to_s), -1);
    cFXVec2f.mark = 0;
    cFXVec2f.destroy = (void (*)(void *)) FXRbUnregisterRubyObj;
    
    cFXVec2d.klass = rb_define_class_under(mFox, "FXVec2d", rb_cObject);
    SWIG_TypeClientData(SWIGTYPE_p_FXVec2d, (void *) &cFXVec2d);
    rb_define_alloc_func(cFXVec2d.klass, _wrap_FXVec2d_allocate);
    rb_define_method(cFXVec2d.klass, "initialize", VALUEFUNC(_wrap_new_FXVec2d), -1);
    rb_define_method(cFXVec2d.klass, "x=", VALUEFUNC(_wrap_FXVec2d_x_set), -1);
    rb_define_method(cFXVec2d.klass, "x", VALUEFUNC(_wrap_FXVec2d_x_get), -1);
    rb_define_method(cFXVec2d.klass, "y=", VALUEFUNC(_wrap_FXVec2d_y_set), -1);
    rb_define_method(cFXVec2d.klass, "y", VALUEFUNC(_wrap_FXVec2d_y_get), -1);
    rb_define_method(cFXVec2d.klass, "[]", VALUEFUNC(_wrap_FXVec2d___getitem__), -1);
    rb_define_method(cFXVec2d.klass, "[]=", VALUEFUNC(_wrap_FXVec2d___setitem__), -1);
    rb_define_method(cFXVec2d.klass, "-@", VALUEFUNC(_wrap_FXVec2d___neg__), -1);
    rb_define_method(cFXVec2d.klass, "+", VALUEFUNC(_wrap_FXVec2d___add__), -1);
    rb_define_method(cFXVec2d.klass, "-", VALUEFUNC(_wrap_FXVec2d___sub__), -1);
    rb_define_method(cFXVec2d.klass, "/", VALUEFUNC(_wrap_FXVec2d___div__), -1);
    rb_define_method(cFXVec2d.klass, "*", VALUEFUNC(_wrap_FXVec2d___mul__), -1);
    rb_define_method(cFXVec2d.klass, "dot", VALUEFUNC(_wrap_FXVec2d_dot), -1);
    rb_define_method(cFXVec2d.klass, "==", VALUEFUNC(_wrap_FXVec2d___eq__), -1);
    rb_define_method(cFXVec2d.klass, "len2", VALUEFUNC(_wrap_FXVec2d_len2), -1);
    rb_define_method(cFXVec2d.klass, "len", VALUEFUNC(_wrap_FXVec2d_len), -1);
    rb_define_method(cFXVec2d.klass, "normalize", VALUEFUNC(_wrap_FXVec2d_normalize), -1);
    rb_define_method(cFXVec2d.klass, "lo", VALUEFUNC(_wrap_FXVec2d_lo), -1);
    rb_define_method(cFXVec2d.klass, "hi", VALUEFUNC(_wrap_FXVec2d_hi), -1);
    rb_define_method(cFXVec2d.klass, "to_a", VALUEFUNC(_wrap_FXVec2d_to_a), -1);
    rb_define_method(cFXVec2d.klass, "to_s", VALUEFUNC(_wrap_FXVec2d_to_s), -1);
    cFXVec2d.mark = 0;
    cFXVec2d.destroy = (void (*)(void *)) FXRbUnregisterRubyObj;
    
    cFXVec3f.klass = rb_define_class_under(mFox, "FXVec3f", rb_cObject);
    SWIG_TypeClientData(SWIGTYPE_p_FXVec3f, (void *) &cFXVec3f);
    rb_define_alloc_func(cFXVec3f.klass, _wrap_FXVec3f_allocate);
    rb_define_method(cFXVec3f.klass, "initialize", VALUEFUNC(_wrap_new_FXVec3f), -1);
    rb_define_method(cFXVec3f.klass, "x=", VALUEFUNC(_wrap_FXVec3f_x_set), -1);
    rb_define_method(cFXVec3f.klass, "x", VALUEFUNC(_wrap_FXVec3f_x_get), -1);
    rb_define_method(cFXVec3f.klass, "y=", VALUEFUNC(_wrap_FXVec3f_y_set), -1);
    rb_define_method(cFXVec3f.klass, "y", VALUEFUNC(_wrap_FXVec3f_y_get), -1);
    rb_define_method(cFXVec3f.klass, "z=", VALUEFUNC(_wrap_FXVec3f_z_set), -1);
    rb_define_method(cFXVec3f.klass, "z", VALUEFUNC(_wrap_FXVec3f_z_get), -1);
    rb_define_method(cFXVec3f.klass, "[]", VALUEFUNC(_wrap_FXVec3f___getitem__), -1);
    rb_define_method(cFXVec3f.klass, "[]=", VALUEFUNC(_wrap_FXVec3f___setitem__), -1);
    rb_define_method(cFXVec3f.klass, "-@", VALUEFUNC(_wrap_FXVec3f___neg__), -1);
    rb_define_method(cFXVec3f.klass, "+", VALUEFUNC(_wrap_FXVec3f___add__), -1);
    rb_define_method(cFXVec3f.klass, "-", VALUEFUNC(_wrap_FXVec3f___sub__), -1);
    rb_define_method(cFXVec3f.klass, "/", VALUEFUNC(_wrap_FXVec3f___div__), -1);
    rb_define_method(cFXVec3f.klass, "*", VALUEFUNC(_wrap_FXVec3f___mul__), -1);
    rb_define_method(cFXVec3f.klass, "dot", VALUEFUNC(_wrap_FXVec3f_dot), -1);
    rb_define_method(cFXVec3f.klass, "^", VALUEFUNC(_wrap_FXVec3f___xor__), -1);
    rb_define_method(cFXVec3f.klass, "cross", VALUEFUNC(_wrap_FXVec3f_cross), -1);
    rb_define_method(cFXVec3f.klass, "==", VALUEFUNC(_wrap_FXVec3f___eq__), -1);
    rb_define_method(cFXVec3f.klass, "len2", VALUEFUNC(_wrap_FXVec3f_len2), -1);
    rb_define_method(cFXVec3f.klass, "len", VALUEFUNC(_wrap_FXVec3f_len), -1);
    rb_define_method(cFXVec3f.klass, "normalize", VALUEFUNC(_wrap_FXVec3f_normalize), -1);
    rb_define_method(cFXVec3f.klass, "lo", VALUEFUNC(_wrap_FXVec3f_lo), -1);
    rb_define_method(cFXVec3f.klass, "hi", VALUEFUNC(_wrap_FXVec3f_hi), -1);
    rb_define_method(cFXVec3f.klass, "to_a", VALUEFUNC(_wrap_FXVec3f_to_a), -1);
    rb_define_method(cFXVec3f.klass, "to_s", VALUEFUNC(_wrap_FXVec3f_to_s), -1);
    cFXVec3f.mark = 0;
    cFXVec3f.destroy = (void (*)(void *)) FXRbUnregisterRubyObj;
    
    cFXVec3d.klass = rb_define_class_under(mFox, "FXVec3d", rb_cObject);
    SWIG_TypeClientData(SWIGTYPE_p_FXVec3d, (void *) &cFXVec3d);
    rb_define_alloc_func(cFXVec3d.klass, _wrap_FXVec3d_allocate);
    rb_define_method(cFXVec3d.klass, "initialize", VALUEFUNC(_wrap_new_FXVec3d), -1);
    rb_define_method(cFXVec3d.klass, "x=", VALUEFUNC(_wrap_FXVec3d_x_set), -1);
    rb_define_method(cFXVec3d.klass, "x", VALUEFUNC(_wrap_FXVec3d_x_get), -1);
    rb_define_method(cFXVec3d.klass, "y=", VALUEFUNC(_wrap_FXVec3d_y_set), -1);
    rb_define_method(cFXVec3d.klass, "y", VALUEFUNC(_wrap_FXVec3d_y_get), -1);
    rb_define_method(cFXVec3d.klass, "z=", VALUEFUNC(_wrap_FXVec3d_z_set), -1);
    rb_define_method(cFXVec3d.klass, "z", VALUEFUNC(_wrap_FXVec3d_z_get), -1);
    rb_define_method(cFXVec3d.klass, "[]", VALUEFUNC(_wrap_FXVec3d___getitem__), -1);
    rb_define_method(cFXVec3d.klass, "[]=", VALUEFUNC(_wrap_FXVec3d___setitem__), -1);
    rb_define_method(cFXVec3d.klass, "-@", VALUEFUNC(_wrap_FXVec3d___neg__), -1);
    rb_define_method(cFXVec3d.klass, "+", VALUEFUNC(_wrap_FXVec3d___add__), -1);
    rb_define_method(cFXVec3d.klass, "-", VALUEFUNC(_wrap_FXVec3d___sub__), -1);
    rb_define_method(cFXVec3d.klass, "/", VALUEFUNC(_wrap_FXVec3d___div__), -1);
    rb_define_method(cFXVec3d.klass, "*", VALUEFUNC(_wrap_FXVec3d___mul__), -1);
    rb_define_method(cFXVec3d.klass, "dot", VALUEFUNC(_wrap_FXVec3d_dot), -1);
    rb_define_method(cFXVec3d.klass, "^", VALUEFUNC(_wrap_FXVec3d___xor__), -1);
    rb_define_method(cFXVec3d.klass, "cross", VALUEFUNC(_wrap_FXVec3d_cross), -1);
    rb_define_method(cFXVec3d.klass, "==", VALUEFUNC(_wrap_FXVec3d___eq__), -1);
    rb_define_method(cFXVec3d.klass, "len2", VALUEFUNC(_wrap_FXVec3d_len2), -1);
    rb_define_method(cFXVec3d.klass, "len", VALUEFUNC(_wrap_FXVec3d_len), -1);
    rb_define_method(cFXVec3d.klass, "normalize", VALUEFUNC(_wrap_FXVec3d_normalize), -1);
    rb_define_method(cFXVec3d.klass, "lo", VALUEFUNC(_wrap_FXVec3d_lo), -1);
    rb_define_method(cFXVec3d.klass, "hi", VALUEFUNC(_wrap_FXVec3d_hi), -1);
    rb_define_method(cFXVec3d.klass, "to_a", VALUEFUNC(_wrap_FXVec3d_to_a), -1);
    rb_define_method(cFXVec3d.klass, "to_s", VALUEFUNC(_wrap_FXVec3d_to_s), -1);
    cFXVec3d.mark = 0;
    cFXVec3d.destroy = (void (*)(void *)) FXRbUnregisterRubyObj;
    
    cFXVec4f.klass = rb_define_class_under(mFox, "FXVec4f", rb_cObject);
    SWIG_TypeClientData(SWIGTYPE_p_FXVec4f, (void *) &cFXVec4f);
    rb_define_alloc_func(cFXVec4f.klass, _wrap_FXVec4f_allocate);
    rb_define_method(cFXVec4f.klass, "initialize", VALUEFUNC(_wrap_new_FXVec4f), -1);
    rb_define_method(cFXVec4f.klass, "x=", VALUEFUNC(_wrap_FXVec4f_x_set), -1);
    rb_define_method(cFXVec4f.klass, "x", VALUEFUNC(_wrap_FXVec4f_x_get), -1);
    rb_define_method(cFXVec4f.klass, "y=", VALUEFUNC(_wrap_FXVec4f_y_set), -1);
    rb_define_method(cFXVec4f.klass, "y", VALUEFUNC(_wrap_FXVec4f_y_get), -1);
    rb_define_method(cFXVec4f.klass, "z=", VALUEFUNC(_wrap_FXVec4f_z_set), -1);
    rb_define_method(cFXVec4f.klass, "z", VALUEFUNC(_wrap_FXVec4f_z_get), -1);
    rb_define_method(cFXVec4f.klass, "w=", VALUEFUNC(_wrap_FXVec4f_w_set), -1);
    rb_define_method(cFXVec4f.klass, "w", VALUEFUNC(_wrap_FXVec4f_w_get), -1);
    rb_define_method(cFXVec4f.klass, "[]", VALUEFUNC(_wrap_FXVec4f___getitem__), -1);
    rb_define_method(cFXVec4f.klass, "[]=", VALUEFUNC(_wrap_FXVec4f___setitem__), -1);
    rb_define_method(cFXVec4f.klass, "-@", VALUEFUNC(_wrap_FXVec4f___neg__), -1);
    rb_define_method(cFXVec4f.klass, "+", VALUEFUNC(_wrap_FXVec4f___add__), -1);
    rb_define_method(cFXVec4f.klass, "-", VALUEFUNC(_wrap_FXVec4f___sub__), -1);
    rb_define_method(cFXVec4f.klass, "/", VALUEFUNC(_wrap_FXVec4f___div__), -1);
    rb_define_method(cFXVec4f.klass, "*", VALUEFUNC(_wrap_FXVec4f___mul__), -1);
    rb_define_method(cFXVec4f.klass, "dot", VALUEFUNC(_wrap_FXVec4f_dot), -1);
    rb_define_method(cFXVec4f.klass, "==", VALUEFUNC(_wrap_FXVec4f___eq__), -1);
    rb_define_method(cFXVec4f.klass, "len", VALUEFUNC(_wrap_FXVec4f_len), -1);
    rb_define_method(cFXVec4f.klass, "len2", VALUEFUNC(_wrap_FXVec4f_len2), -1);
    rb_define_method(cFXVec4f.klass, "normalize", VALUEFUNC(_wrap_FXVec4f_normalize), -1);
    rb_define_method(cFXVec4f.klass, "lo", VALUEFUNC(_wrap_FXVec4f_lo), -1);
    rb_define_method(cFXVec4f.klass, "hi", VALUEFUNC(_wrap_FXVec4f_hi), -1);
    rb_define_method(cFXVec4f.klass, "to_a", VALUEFUNC(_wrap_FXVec4f_to_a), -1);
    rb_define_method(cFXVec4f.klass, "to_s", VALUEFUNC(_wrap_FXVec4f_to_s), -1);
    cFXVec4f.mark = 0;
    cFXVec4f.destroy = (void (*)(void *)) FXRbUnregisterRubyObj;
    
    cFXVec4d.klass = rb_define_class_under(mFox, "FXVec4d", rb_cObject);
    SWIG_TypeClientData(SWIGTYPE_p_FXVec4d, (void *) &cFXVec4d);
    rb_define_alloc_func(cFXVec4d.klass, _wrap_FXVec4d_allocate);
    rb_define_method(cFXVec4d.klass, "initialize", VALUEFUNC(_wrap_new_FXVec4d), -1);
    rb_define_method(cFXVec4d.klass, "x=", VALUEFUNC(_wrap_FXVec4d_x_set), -1);
    rb_define_method(cFXVec4d.klass, "x", VALUEFUNC(_wrap_FXVec4d_x_get), -1);
    rb_define_method(cFXVec4d.klass, "y=", VALUEFUNC(_wrap_FXVec4d_y_set), -1);
    rb_define_method(cFXVec4d.klass, "y", VALUEFUNC(_wrap_FXVec4d_y_get), -1);
    rb_define_method(cFXVec4d.klass, "z=", VALUEFUNC(_wrap_FXVec4d_z_set), -1);
    rb_define_method(cFXVec4d.klass, "z", VALUEFUNC(_wrap_FXVec4d_z_get), -1);
    rb_define_method(cFXVec4d.klass, "w=", VALUEFUNC(_wrap_FXVec4d_w_set), -1);
    rb_define_method(cFXVec4d.klass, "w", VALUEFUNC(_wrap_FXVec4d_w_get), -1);
    rb_define_method(cFXVec4d.klass, "[]", VALUEFUNC(_wrap_FXVec4d___getitem__), -1);
    rb_define_method(cFXVec4d.klass, "[]=", VALUEFUNC(_wrap_FXVec4d___setitem__), -1);
    rb_define_method(cFXVec4d.klass, "-@", VALUEFUNC(_wrap_FXVec4d___neg__), -1);
    rb_define_method(cFXVec4d.klass, "+", VALUEFUNC(_wrap_FXVec4d___add__), -1);
    rb_define_method(cFXVec4d.klass, "-", VALUEFUNC(_wrap_FXVec4d___sub__), -1);
    rb_define_method(cFXVec4d.klass, "/", VALUEFUNC(_wrap_FXVec4d___div__), -1);
    rb_define_method(cFXVec4d.klass, "*", VALUEFUNC(_wrap_FXVec4d___mul__), -1);
    rb_define_method(cFXVec4d.klass, "dot", VALUEFUNC(_wrap_FXVec4d_dot), -1);
    rb_define_method(cFXVec4d.klass, "==", VALUEFUNC(_wrap_FXVec4d___eq__), -1);
    rb_define_method(cFXVec4d.klass, "len2", VALUEFUNC(_wrap_FXVec4d_len2), -1);
    rb_define_method(cFXVec4d.klass, "len", VALUEFUNC(_wrap_FXVec4d_len), -1);
    rb_define_method(cFXVec4d.klass, "normalize", VALUEFUNC(_wrap_FXVec4d_normalize), -1);
    rb_define_method(cFXVec4d.klass, "lo", VALUEFUNC(_wrap_FXVec4d_lo), -1);
    rb_define_method(cFXVec4d.klass, "hi", VALUEFUNC(_wrap_FXVec4d_hi), -1);
    rb_define_method(cFXVec4d.klass, "to_a", VALUEFUNC(_wrap_FXVec4d_to_a), -1);
    rb_define_method(cFXVec4d.klass, "to_s", VALUEFUNC(_wrap_FXVec4d_to_s), -1);
    cFXVec4d.mark = 0;
    cFXVec4d.destroy = (void (*)(void *)) FXRbUnregisterRubyObj;
    
    cFXQuatf.klass = rb_define_class_under(mFox, "FXQuatf", ((swig_class *) SWIGTYPE_p_FXVec4f->clientdata)->klass);
    SWIG_TypeClientData(SWIGTYPE_p_FXQuatf, (void *) &cFXQuatf);
    rb_define_alloc_func(cFXQuatf.klass, _wrap_FXQuatf_allocate);
    rb_define_method(cFXQuatf.klass, "initialize", VALUEFUNC(_wrap_new_FXQuatf), -1);
    rb_define_method(cFXQuatf.klass, "adjust!", VALUEFUNC(_wrap_FXQuatf_adjustN___), -1);
    rb_define_method(cFXQuatf.klass, "setAxisAngle", VALUEFUNC(_wrap_FXQuatf_setAxisAngle), -1);
    rb_define_method(cFXQuatf.klass, "getAxisAngle", VALUEFUNC(_wrap_FXQuatf_getAxisAngle), -1);
    rb_define_method(cFXQuatf.klass, "setRollPitchYaw", VALUEFUNC(_wrap_FXQuatf_setRollPitchYaw), -1);
    rb_define_method(cFXQuatf.klass, "getRollPitchYaw", VALUEFUNC(_wrap_FXQuatf_getRollPitchYaw), -1);
    rb_define_method(cFXQuatf.klass, "exp", VALUEFUNC(_wrap_FXQuatf_exp), -1);
    rb_define_method(cFXQuatf.klass, "log", VALUEFUNC(_wrap_FXQuatf_log), -1);
    rb_define_method(cFXQuatf.klass, "invert", VALUEFUNC(_wrap_FXQuatf_invert), -1);
    rb_define_method(cFXQuatf.klass, "unitinvert", VALUEFUNC(_wrap_FXQuatf_unitinvert), -1);
    rb_define_method(cFXQuatf.klass, "conj", VALUEFUNC(_wrap_FXQuatf_conj), -1);
    rb_define_method(cFXQuatf.klass, "*", VALUEFUNC(_wrap_FXQuatf___mul__), -1);
    rb_define_singleton_method(cFXQuatf.klass, "arc", VALUEFUNC(_wrap_FXQuatf_arc), -1);
    rb_define_singleton_method(cFXQuatf.klass, "lerp", VALUEFUNC(_wrap_FXQuatf_lerp), -1);
    cFXQuatf.mark = 0;
    cFXQuatf.destroy = (void (*)(void *)) FXRbUnregisterRubyObj;
    
    cFXQuatd.klass = rb_define_class_under(mFox, "FXQuatd", ((swig_class *) SWIGTYPE_p_FXVec4d->clientdata)->klass);
    SWIG_TypeClientData(SWIGTYPE_p_FXQuatd, (void *) &cFXQuatd);
    rb_define_alloc_func(cFXQuatd.klass, _wrap_FXQuatd_allocate);
    rb_define_method(cFXQuatd.klass, "initialize", VALUEFUNC(_wrap_new_FXQuatd), -1);
    rb_define_method(cFXQuatd.klass, "adjust", VALUEFUNC(_wrap_FXQuatd_adjust), -1);
    rb_define_method(cFXQuatd.klass, "setAxisAngle", VALUEFUNC(_wrap_FXQuatd_setAxisAngle), -1);
    rb_define_method(cFXQuatd.klass, "getAxisAngle", VALUEFUNC(_wrap_FXQuatd_getAxisAngle), -1);
    rb_define_method(cFXQuatd.klass, "setRollPitchYaw", VALUEFUNC(_wrap_FXQuatd_setRollPitchYaw), -1);
    rb_define_method(cFXQuatd.klass, "getRollPitchYaw", VALUEFUNC(_wrap_FXQuatd_getRollPitchYaw), -1);
    rb_define_method(cFXQuatd.klass, "exp", VALUEFUNC(_wrap_FXQuatd_exp), -1);
    rb_define_method(cFXQuatd.klass, "log", VALUEFUNC(_wrap_FXQuatd_log), -1);
    rb_define_method(cFXQuatd.klass, "invert", VALUEFUNC(_wrap_FXQuatd_invert), -1);
    rb_define_method(cFXQuatd.klass, "unitinvert", VALUEFUNC(_wrap_FXQuatd_unitinvert), -1);
    rb_define_method(cFXQuatd.klass, "conj", VALUEFUNC(_wrap_FXQuatd_conj), -1);
    rb_define_method(cFXQuatd.klass, "*", VALUEFUNC(_wrap_FXQuatd___mul__), -1);
    rb_define_singleton_method(cFXQuatd.klass, "arc", VALUEFUNC(_wrap_FXQuatd_arc), -1);
    rb_define_singleton_method(cFXQuatd.klass, "lerp", VALUEFUNC(_wrap_FXQuatd_lerp), -1);
    cFXQuatd.mark = 0;
    cFXQuatd.destroy = (void (*)(void *)) FXRbUnregisterRubyObj;
    
    cFXMat3f.klass = rb_define_class_under(mFox, "FXMat3f", rb_cObject);
    SWIG_TypeClientData(SWIGTYPE_p_FXMat3f, (void *) &cFXMat3f);
    rb_define_alloc_func(cFXMat3f.klass, _wrap_FXMat3f_allocate);
    rb_define_method(cFXMat3f.klass, "initialize", VALUEFUNC(_wrap_new_FXMat3f), -1);
    rb_define_method(cFXMat3f.klass, "[]", VALUEFUNC(_wrap_FXMat3f___getitem__), -1);
    rb_define_method(cFXMat3f.klass, "[]=", VALUEFUNC(_wrap_FXMat3f___setitem__), -1);
    rb_define_method(cFXMat3f.klass, "+", VALUEFUNC(_wrap_FXMat3f___add__), -1);
    rb_define_method(cFXMat3f.klass, "-", VALUEFUNC(_wrap_FXMat3f___sub__), -1);
    rb_define_method(cFXMat3f.klass, "-@", VALUEFUNC(_wrap_FXMat3f___neg__), -1);
    rb_define_method(cFXMat3f.klass, "/", VALUEFUNC(_wrap_FXMat3f___div__), -1);
    rb_define_method(cFXMat3f.klass, "*", VALUEFUNC(_wrap_FXMat3f___mul__), -1);
    rb_define_method(cFXMat3f.klass, "eye", VALUEFUNC(_wrap_FXMat3f_eye), -1);
    rb_define_method(cFXMat3f.klass, "rot", VALUEFUNC(_wrap_FXMat3f_rot), -1);
    rb_define_method(cFXMat3f.klass, "trans", VALUEFUNC(_wrap_FXMat3f_trans), -1);
    rb_define_method(cFXMat3f.klass, "scale", VALUEFUNC(_wrap_FXMat3f_scale), -1);
    rb_define_method(cFXMat3f.klass, "det", VALUEFUNC(_wrap_FXMat3f_det), -1);
    rb_define_method(cFXMat3f.klass, "transpose", VALUEFUNC(_wrap_FXMat3f_transpose), -1);
    rb_define_method(cFXMat3f.klass, "invert", VALUEFUNC(_wrap_FXMat3f_invert), -1);
    cFXMat3f.mark = 0;
    cFXMat3f.destroy = (void (*)(void *)) FXRbUnregisterRubyObj;
    
    cFXMat3d.klass = rb_define_class_under(mFox, "FXMat3d", rb_cObject);
    SWIG_TypeClientData(SWIGTYPE_p_FXMat3d, (void *) &cFXMat3d);
    rb_define_alloc_func(cFXMat3d.klass, _wrap_FXMat3d_allocate);
    rb_define_method(cFXMat3d.klass, "initialize", VALUEFUNC(_wrap_new_FXMat3d), -1);
    rb_define_method(cFXMat3d.klass, "[]", VALUEFUNC(_wrap_FXMat3d___getitem__), -1);
    rb_define_method(cFXMat3d.klass, "[]=", VALUEFUNC(_wrap_FXMat3d___setitem__), -1);
    rb_define_method(cFXMat3d.klass, "+", VALUEFUNC(_wrap_FXMat3d___add__), -1);
    rb_define_method(cFXMat3d.klass, "-", VALUEFUNC(_wrap_FXMat3d___sub__), -1);
    rb_define_method(cFXMat3d.klass, "-@", VALUEFUNC(_wrap_FXMat3d___neg__), -1);
    rb_define_method(cFXMat3d.klass, "/", VALUEFUNC(_wrap_FXMat3d___div__), -1);
    rb_define_method(cFXMat3d.klass, "*", VALUEFUNC(_wrap_FXMat3d___mul__), -1);
    rb_define_method(cFXMat3d.klass, "eye", VALUEFUNC(_wrap_FXMat3d_eye), -1);
    rb_define_method(cFXMat3d.klass, "rot", VALUEFUNC(_wrap_FXMat3d_rot), -1);
    rb_define_method(cFXMat3d.klass, "trans", VALUEFUNC(_wrap_FXMat3d_trans), -1);
    rb_define_method(cFXMat3d.klass, "scale", VALUEFUNC(_wrap_FXMat3d_scale), -1);
    rb_define_method(cFXMat3d.klass, "det", VALUEFUNC(_wrap_FXMat3d_det), -1);
    rb_define_method(cFXMat3d.klass, "transpose", VALUEFUNC(_wrap_FXMat3d_transpose), -1);
    rb_define_method(cFXMat3d.klass, "invert", VALUEFUNC(_wrap_FXMat3d_invert), -1);
    cFXMat3d.mark = 0;
    cFXMat3d.destroy = (void (*)(void *)) FXRbUnregisterRubyObj;
    
    cFXMat4f.klass = rb_define_class_under(mFox, "FXMat4f", rb_cObject);
    SWIG_TypeClientData(SWIGTYPE_p_FXMat4f, (void *) &cFXMat4f);
    rb_define_alloc_func(cFXMat4f.klass, _wrap_FXMat4f_allocate);
    rb_define_method(cFXMat4f.klass, "initialize", VALUEFUNC(_wrap_new_FXMat4f), -1);
    rb_define_method(cFXMat4f.klass, "[]", VALUEFUNC(_wrap_FXMat4f___getitem__), -1);
    rb_define_method(cFXMat4f.klass, "[]=", VALUEFUNC(_wrap_FXMat4f___setitem__), -1);
    rb_define_method(cFXMat4f.klass, "+", VALUEFUNC(_wrap_FXMat4f___add__), -1);
    rb_define_method(cFXMat4f.klass, "-", VALUEFUNC(_wrap_FXMat4f___sub__), -1);
    rb_define_method(cFXMat4f.klass, "*", VALUEFUNC(_wrap_FXMat4f___mul__), -1);
    rb_define_method(cFXMat4f.klass, "/", VALUEFUNC(_wrap_FXMat4f___div__), -1);
    rb_define_method(cFXMat4f.klass, "-@", VALUEFUNC(_wrap_FXMat4f___neg__), -1);
    rb_define_method(cFXMat4f.klass, "det", VALUEFUNC(_wrap_FXMat4f_det), -1);
    rb_define_method(cFXMat4f.klass, "transpose", VALUEFUNC(_wrap_FXMat4f_transpose), -1);
    rb_define_method(cFXMat4f.klass, "invert", VALUEFUNC(_wrap_FXMat4f_invert), -1);
    rb_define_method(cFXMat4f.klass, "to_s", VALUEFUNC(_wrap_FXMat4f_to_s), -1);
    rb_define_method(cFXMat4f.klass, "eye", VALUEFUNC(_wrap_FXMat4f_eye), -1);
    rb_define_method(cFXMat4f.klass, "ortho", VALUEFUNC(_wrap_FXMat4f_ortho), -1);
    rb_define_method(cFXMat4f.klass, "frustum", VALUEFUNC(_wrap_FXMat4f_frustum), -1);
    rb_define_method(cFXMat4f.klass, "left", VALUEFUNC(_wrap_FXMat4f_left), -1);
    rb_define_method(cFXMat4f.klass, "rot", VALUEFUNC(_wrap_FXMat4f_rot), -1);
    rb_define_method(cFXMat4f.klass, "xrot", VALUEFUNC(_wrap_FXMat4f_xrot), -1);
    rb_define_method(cFXMat4f.klass, "yrot", VALUEFUNC(_wrap_FXMat4f_yrot), -1);
    rb_define_method(cFXMat4f.klass, "zrot", VALUEFUNC(_wrap_FXMat4f_zrot), -1);
    rb_define_method(cFXMat4f.klass, "look", VALUEFUNC(_wrap_FXMat4f_look), -1);
    rb_define_method(cFXMat4f.klass, "trans", VALUEFUNC(_wrap_FXMat4f_trans), -1);
    rb_define_method(cFXMat4f.klass, "scale", VALUEFUNC(_wrap_FXMat4f_scale), -1);
    cFXMat4f.mark = 0;
    cFXMat4f.destroy = (void (*)(void *)) FXRbUnregisterRubyObj;
    
    cFXMat4d.klass = rb_define_class_under(mFox, "FXMat4d", rb_cObject);
    SWIG_TypeClientData(SWIGTYPE_p_FXMat4d, (void *) &cFXMat4d);
    rb_define_alloc_func(cFXMat4d.klass, _wrap_FXMat4d_allocate);
    rb_define_method(cFXMat4d.klass, "initialize", VALUEFUNC(_wrap_new_FXMat4d), -1);
    rb_define_method(cFXMat4d.klass, "[]", VALUEFUNC(_wrap_FXMat4d___getitem__), -1);
    rb_define_method(cFXMat4d.klass, "[]=", VALUEFUNC(_wrap_FXMat4d___setitem__), -1);
    rb_define_method(cFXMat4d.klass, "+", VALUEFUNC(_wrap_FXMat4d___add__), -1);
    rb_define_method(cFXMat4d.klass, "-", VALUEFUNC(_wrap_FXMat4d___sub__), -1);
    rb_define_method(cFXMat4d.klass, "-@", VALUEFUNC(_wrap_FXMat4d___neg__), -1);
    rb_define_method(cFXMat4d.klass, "/", VALUEFUNC(_wrap_FXMat4d___div__), -1);
    rb_define_method(cFXMat4d.klass, "*", VALUEFUNC(_wrap_FXMat4d___mul__), -1);
    rb_define_method(cFXMat4d.klass, "eye", VALUEFUNC(_wrap_FXMat4d_eye), -1);
    rb_define_method(cFXMat4d.klass, "ortho", VALUEFUNC(_wrap_FXMat4d_ortho), -1);
    rb_define_method(cFXMat4d.klass, "frustum", VALUEFUNC(_wrap_FXMat4d_frustum), -1);
    rb_define_method(cFXMat4d.klass, "left", VALUEFUNC(_wrap_FXMat4d_left), -1);
    rb_define_method(cFXMat4d.klass, "rot", VALUEFUNC(_wrap_FXMat4d_rot), -1);
    rb_define_method(cFXMat4d.klass, "xrot", VALUEFUNC(_wrap_FXMat4d_xrot), -1);
    rb_define_method(cFXMat4d.klass, "yrot", VALUEFUNC(_wrap_FXMat4d_yrot), -1);
    rb_define_method(cFXMat4d.klass, "zrot", VALUEFUNC(_wrap_FXMat4d_zrot), -1);
    rb_define_method(cFXMat4d.klass, "look", VALUEFUNC(_wrap_FXMat4d_look), -1);
    rb_define_method(cFXMat4d.klass, "trans", VALUEFUNC(_wrap_FXMat4d_trans), -1);
    rb_define_method(cFXMat4d.klass, "scale", VALUEFUNC(_wrap_FXMat4d_scale), -1);
    rb_define_method(cFXMat4d.klass, "det", VALUEFUNC(_wrap_FXMat4d_det), -1);
    rb_define_method(cFXMat4d.klass, "transpose", VALUEFUNC(_wrap_FXMat4d_transpose), -1);
    rb_define_method(cFXMat4d.klass, "invert", VALUEFUNC(_wrap_FXMat4d_invert), -1);
    cFXMat4d.mark = 0;
    cFXMat4d.destroy = (void (*)(void *)) FXRbUnregisterRubyObj;
    
    cFXRangef.klass = rb_define_class_under(mFox, "FXRangef", rb_cObject);
    SWIG_TypeClientData(SWIGTYPE_p_FXRangef, (void *) &cFXRangef);
    rb_define_alloc_func(cFXRangef.klass, _wrap_FXRangef_allocate);
    rb_define_method(cFXRangef.klass, "initialize", VALUEFUNC(_wrap_new_FXRangef), -1);
    rb_define_method(cFXRangef.klass, "lower=", VALUEFUNC(_wrap_FXRangef_lower_set), -1);
    rb_define_method(cFXRangef.klass, "lower", VALUEFUNC(_wrap_FXRangef_lower_get), -1);
    rb_define_method(cFXRangef.klass, "upper=", VALUEFUNC(_wrap_FXRangef_upper_set), -1);
    rb_define_method(cFXRangef.klass, "upper", VALUEFUNC(_wrap_FXRangef_upper_get), -1);
    rb_define_method(cFXRangef.klass, "[]", VALUEFUNC(_wrap_FXRangef___getitem__), -1);
    rb_define_method(cFXRangef.klass, "[]=", VALUEFUNC(_wrap_FXRangef___setitem__), -1);
    rb_define_method(cFXRangef.klass, "width", VALUEFUNC(_wrap_FXRangef_width), -1);
    rb_define_method(cFXRangef.klass, "height", VALUEFUNC(_wrap_FXRangef_height), -1);
    rb_define_method(cFXRangef.klass, "depth", VALUEFUNC(_wrap_FXRangef_depth), -1);
    rb_define_method(cFXRangef.klass, "longest", VALUEFUNC(_wrap_FXRangef_longest), -1);
    rb_define_method(cFXRangef.klass, "shortest", VALUEFUNC(_wrap_FXRangef_shortest), -1);
    rb_define_method(cFXRangef.klass, "diameter", VALUEFUNC(_wrap_FXRangef_diameter), -1);
    rb_define_method(cFXRangef.klass, "diagonal", VALUEFUNC(_wrap_FXRangef_diagonal), -1);
    rb_define_method(cFXRangef.klass, "center", VALUEFUNC(_wrap_FXRangef_center), -1);
    rb_define_method(cFXRangef.klass, "empty?", VALUEFUNC(_wrap_FXRangef_emptyq___), -1);
    rb_define_method(cFXRangef.klass, "contains?", VALUEFUNC(_wrap_FXRangef_containsq___), -1);
    rb_define_method(cFXRangef.klass, "include!", VALUEFUNC(_wrap_FXRangef_includeN___), -1);
    rb_define_method(cFXRangef.klass, "intersect", VALUEFUNC(_wrap_FXRangef_intersect), -1);
    rb_define_method(cFXRangef.klass, "overlaps?", VALUEFUNC(_wrap_FXRangef_overlapsq___), -1);
    rb_define_method(cFXRangef.klass, "corner", VALUEFUNC(_wrap_FXRangef_corner), -1);
    rb_define_method(cFXRangef.klass, "union", VALUEFUNC(_wrap_FXRangef_union), -1);
    rb_define_method(cFXRangef.klass, "intersection", VALUEFUNC(_wrap_FXRangef_intersection), -1);
    cFXRangef.mark = 0;
    cFXRangef.destroy = (void (*)(void *)) FXRbUnregisterRubyObj;
    
    cFXRanged.klass = rb_define_class_under(mFox, "FXRanged", rb_cObject);
    SWIG_TypeClientData(SWIGTYPE_p_FXRanged, (void *) &cFXRanged);
    rb_define_alloc_func(cFXRanged.klass, _wrap_FXRanged_allocate);
    rb_define_method(cFXRanged.klass, "initialize", VALUEFUNC(_wrap_new_FXRanged), -1);
    rb_define_method(cFXRanged.klass, "lower=", VALUEFUNC(_wrap_FXRanged_lower_set), -1);
    rb_define_method(cFXRanged.klass, "lower", VALUEFUNC(_wrap_FXRanged_lower_get), -1);
    rb_define_method(cFXRanged.klass, "upper=", VALUEFUNC(_wrap_FXRanged_upper_set), -1);
    rb_define_method(cFXRanged.klass, "upper", VALUEFUNC(_wrap_FXRanged_upper_get), -1);
    rb_define_method(cFXRanged.klass, "[]", VALUEFUNC(_wrap_FXRanged___getitem__), -1);
    rb_define_method(cFXRanged.klass, "[]=", VALUEFUNC(_wrap_FXRanged___setitem__), -1);
    rb_define_method(cFXRanged.klass, "width", VALUEFUNC(_wrap_FXRanged_width), -1);
    rb_define_method(cFXRanged.klass, "height", VALUEFUNC(_wrap_FXRanged_height), -1);
    rb_define_method(cFXRanged.klass, "depth", VALUEFUNC(_wrap_FXRanged_depth), -1);
    rb_define_method(cFXRanged.klass, "longest", VALUEFUNC(_wrap_FXRanged_longest), -1);
    rb_define_method(cFXRanged.klass, "shortest", VALUEFUNC(_wrap_FXRanged_shortest), -1);
    rb_define_method(cFXRanged.klass, "diameter", VALUEFUNC(_wrap_FXRanged_diameter), -1);
    rb_define_method(cFXRanged.klass, "diagonal", VALUEFUNC(_wrap_FXRanged_diagonal), -1);
    rb_define_method(cFXRanged.klass, "center", VALUEFUNC(_wrap_FXRanged_center), -1);
    rb_define_method(cFXRanged.klass, "empty?", VALUEFUNC(_wrap_FXRanged_emptyq___), -1);
    rb_define_method(cFXRanged.klass, "contains", VALUEFUNC(_wrap_FXRanged_contains), -1);
    rb_define_method(cFXRanged.klass, "contains?", VALUEFUNC(_wrap_FXRanged_containsq___), -1);
    rb_define_method(cFXRanged.klass, "include", VALUEFUNC(_wrap_FXRanged_include), -1);
    rb_define_method(cFXRanged.klass, "intersect", VALUEFUNC(_wrap_FXRanged_intersect), -1);
    rb_define_method(cFXRanged.klass, "overlaps?", VALUEFUNC(_wrap_FXRanged_overlapsq___), -1);
    rb_define_method(cFXRanged.klass, "corner", VALUEFUNC(_wrap_FXRanged_corner), -1);
    rb_define_method(cFXRanged.klass, "union", VALUEFUNC(_wrap_FXRanged_union), -1);
    rb_define_method(cFXRanged.klass, "intersection", VALUEFUNC(_wrap_FXRanged_intersection), -1);
    cFXRanged.mark = 0;
    cFXRanged.destroy = (void (*)(void *)) FXRbUnregisterRubyObj;
    
    cFXSpheref.klass = rb_define_class_under(mFox, "FXSpheref", rb_cObject);
    SWIG_TypeClientData(SWIGTYPE_p_FXSpheref, (void *) &cFXSpheref);
    rb_define_alloc_func(cFXSpheref.klass, _wrap_FXSpheref_allocate);
    rb_define_method(cFXSpheref.klass, "initialize", VALUEFUNC(_wrap_new_FXSpheref), -1);
    rb_define_method(cFXSpheref.klass, "center=", VALUEFUNC(_wrap_FXSpheref_center_set), -1);
    rb_define_method(cFXSpheref.klass, "center", VALUEFUNC(_wrap_FXSpheref_center_get), -1);
    rb_define_method(cFXSpheref.klass, "radius=", VALUEFUNC(_wrap_FXSpheref_radius_set), -1);
    rb_define_method(cFXSpheref.klass, "radius", VALUEFUNC(_wrap_FXSpheref_radius_get), -1);
    rb_define_method(cFXSpheref.klass, "diameter", VALUEFUNC(_wrap_FXSpheref_diameter), -1);
    rb_define_method(cFXSpheref.klass, "empty?", VALUEFUNC(_wrap_FXSpheref_emptyq___), -1);
    rb_define_method(cFXSpheref.klass, "contains?", VALUEFUNC(_wrap_FXSpheref_containsq___), -1);
    rb_define_method(cFXSpheref.klass, "include!", VALUEFUNC(_wrap_FXSpheref_includeN___), -1);
    rb_define_method(cFXSpheref.klass, "intersect", VALUEFUNC(_wrap_FXSpheref_intersect), -1);
    rb_define_method(cFXSpheref.klass, "intersects?", VALUEFUNC(_wrap_FXSpheref_intersectsq___), -1);
    rb_define_method(cFXSpheref.klass, "overlaps?", VALUEFUNC(_wrap_FXSpheref_overlapsq___), -1);
    cFXSpheref.mark = 0;
    
    cFXSphered.klass = rb_define_class_under(mFox, "FXSphered", rb_cObject);
    SWIG_TypeClientData(SWIGTYPE_p_FXSphered, (void *) &cFXSphered);
    rb_define_alloc_func(cFXSphered.klass, _wrap_FXSphered_allocate);
    rb_define_method(cFXSphered.klass, "initialize", VALUEFUNC(_wrap_new_FXSphered), -1);
    rb_define_method(cFXSphered.klass, "center=", VALUEFUNC(_wrap_FXSphered_center_set), -1);
    rb_define_method(cFXSphered.klass, "center", VALUEFUNC(_wrap_FXSphered_center_get), -1);
    rb_define_method(cFXSphered.klass, "radius=", VALUEFUNC(_wrap_FXSphered_radius_set), -1);
    rb_define_method(cFXSphered.klass, "radius", VALUEFUNC(_wrap_FXSphered_radius_get), -1);
    rb_define_method(cFXSphered.klass, "diameter", VALUEFUNC(_wrap_FXSphered_diameter), -1);
    rb_define_method(cFXSphered.klass, "empty?", VALUEFUNC(_wrap_FXSphered_emptyq___), -1);
    rb_define_method(cFXSphered.klass, "contains?", VALUEFUNC(_wrap_FXSphered_containsq___), -1);
    rb_define_method(cFXSphered.klass, "include!", VALUEFUNC(_wrap_FXSphered_includeN___), -1);
    rb_define_method(cFXSphered.klass, "intersect", VALUEFUNC(_wrap_FXSphered_intersect), -1);
    rb_define_method(cFXSphered.klass, "intersects?", VALUEFUNC(_wrap_FXSphered_intersectsq___), -1);
    rb_define_method(cFXSphered.klass, "overlaps?", VALUEFUNC(_wrap_FXSphered_overlapsq___), -1);
    cFXSphered.mark = 0;
    
    cFXGLVisual.klass = rb_define_class_under(mFox, "FXGLVisual", ((swig_class *) SWIGTYPE_p_FXVisual->clientdata)->klass);
    SWIG_TypeClientData(SWIGTYPE_p_FXGLVisual, (void *) &cFXGLVisual);
    rb_define_alloc_func(cFXGLVisual.klass, _wrap_FXGLVisual_allocate);
    rb_define_method(cFXGLVisual.klass, "initialize", VALUEFUNC(_wrap_new_FXGLVisual), -1);
    rb_define_singleton_method(cFXGLVisual.klass, "supported", VALUEFUNC(_wrap_FXGLVisual_supported), -1);
    rb_define_method(cFXGLVisual.klass, "getRedSize", VALUEFUNC(_wrap_FXGLVisual_getRedSize), -1);
    rb_define_method(cFXGLVisual.klass, "getGreenSize", VALUEFUNC(_wrap_FXGLVisual_getGreenSize), -1);
    rb_define_method(cFXGLVisual.klass, "getBlueSize", VALUEFUNC(_wrap_FXGLVisual_getBlueSize), -1);
    rb_define_method(cFXGLVisual.klass, "getAlphaSize", VALUEFUNC(_wrap_FXGLVisual_getAlphaSize), -1);
    rb_define_method(cFXGLVisual.klass, "getDepthSize", VALUEFUNC(_wrap_FXGLVisual_getDepthSize), -1);
    rb_define_method(cFXGLVisual.klass, "getStencilSize", VALUEFUNC(_wrap_FXGLVisual_getStencilSize), -1);
    rb_define_method(cFXGLVisual.klass, "getAccumRedSize", VALUEFUNC(_wrap_FXGLVisual_getAccumRedSize), -1);
    rb_define_method(cFXGLVisual.klass, "getAccumGreenSize", VALUEFUNC(_wrap_FXGLVisual_getAccumGreenSize), -1);
    rb_define_method(cFXGLVisual.klass, "getAccumBlueSize", VALUEFUNC(_wrap_FXGLVisual_getAccumBlueSize), -1);
    rb_define_method(cFXGLVisual.klass, "getAccumAlphaSize", VALUEFUNC(_wrap_FXGLVisual_getAccumAlphaSize), -1);
    rb_define_method(cFXGLVisual.klass, "setRedSize", VALUEFUNC(_wrap_FXGLVisual_setRedSize), -1);
    rb_define_method(cFXGLVisual.klass, "setGreenSize", VALUEFUNC(_wrap_FXGLVisual_setGreenSize), -1);
    rb_define_method(cFXGLVisual.klass, "setBlueSize", VALUEFUNC(_wrap_FXGLVisual_setBlueSize), -1);
    rb_define_method(cFXGLVisual.klass, "setAlphaSize", VALUEFUNC(_wrap_FXGLVisual_setAlphaSize), -1);
    rb_define_method(cFXGLVisual.klass, "setDepthSize", VALUEFUNC(_wrap_FXGLVisual_setDepthSize), -1);
    rb_define_method(cFXGLVisual.klass, "setStencilSize", VALUEFUNC(_wrap_FXGLVisual_setStencilSize), -1);
    rb_define_method(cFXGLVisual.klass, "setAccumRedSize", VALUEFUNC(_wrap_FXGLVisual_setAccumRedSize), -1);
    rb_define_method(cFXGLVisual.klass, "setAccumGreenSize", VALUEFUNC(_wrap_FXGLVisual_setAccumGreenSize), -1);
    rb_define_method(cFXGLVisual.klass, "setAccumBlueSize", VALUEFUNC(_wrap_FXGLVisual_setAccumBlueSize), -1);
    rb_define_method(cFXGLVisual.klass, "setAccumAlphaSize", VALUEFUNC(_wrap_FXGLVisual_setAccumAlphaSize), -1);
    rb_define_method(cFXGLVisual.klass, "getActualRedSize", VALUEFUNC(_wrap_FXGLVisual_getActualRedSize), -1);
    rb_define_method(cFXGLVisual.klass, "getActualGreenSize", VALUEFUNC(_wrap_FXGLVisual_getActualGreenSize), -1);
    rb_define_method(cFXGLVisual.klass, "getActualBlueSize", VALUEFUNC(_wrap_FXGLVisual_getActualBlueSize), -1);
    rb_define_method(cFXGLVisual.klass, "getActualAlphaSize", VALUEFUNC(_wrap_FXGLVisual_getActualAlphaSize), -1);
    rb_define_method(cFXGLVisual.klass, "getActualDepthSize", VALUEFUNC(_wrap_FXGLVisual_getActualDepthSize), -1);
    rb_define_method(cFXGLVisual.klass, "getActualStencilSize", VALUEFUNC(_wrap_FXGLVisual_getActualStencilSize), -1);
    rb_define_method(cFXGLVisual.klass, "getActualAccumRedSize", VALUEFUNC(_wrap_FXGLVisual_getActualAccumRedSize), -1);
    rb_define_method(cFXGLVisual.klass, "getActualAccumGreenSize", VALUEFUNC(_wrap_FXGLVisual_getActualAccumGreenSize), -1);
    rb_define_method(cFXGLVisual.klass, "getActualAccumBlueSize", VALUEFUNC(_wrap_FXGLVisual_getActualAccumBlueSize), -1);
    rb_define_method(cFXGLVisual.klass, "getActualAccumAlphaSize", VALUEFUNC(_wrap_FXGLVisual_getActualAccumAlphaSize), -1);
    rb_define_method(cFXGLVisual.klass, "isDoubleBuffer", VALUEFUNC(_wrap_FXGLVisual_isDoubleBuffer), -1);
    rb_define_method(cFXGLVisual.klass, "isStereo", VALUEFUNC(_wrap_FXGLVisual_isStereo), -1);
    rb_define_method(cFXGLVisual.klass, "isAccelerated", VALUEFUNC(_wrap_FXGLVisual_isAccelerated), -1);
    rb_define_method(cFXGLVisual.klass, "isBufferSwapCopy", VALUEFUNC(_wrap_FXGLVisual_isBufferSwapCopy), -1);
    rb_define_method(cFXGLVisual.klass, "save", VALUEFUNC(_wrap_FXGLVisual_save), -1);
    rb_define_method(cFXGLVisual.klass, "load", VALUEFUNC(_wrap_FXGLVisual_load), -1);
    rb_define_method(cFXGLVisual.klass, "create", VALUEFUNC(_wrap_FXGLVisual_create), -1);
    rb_define_method(cFXGLVisual.klass, "detach", VALUEFUNC(_wrap_FXGLVisual_detach), -1);
    rb_define_method(cFXGLVisual.klass, "destroy", VALUEFUNC(_wrap_FXGLVisual_destroy), -1);
    cFXGLVisual.mark = (void (*)(void *)) FXRbGLVisual::markfunc;
    cFXGLVisual.destroy = (void (*)(void *)) FXRbGLVisual::freefunc;
    rb_define_module_function(mFox, "glUseFXFont", VALUEFUNC(_wrap_glUseFXFont), -1);
    
    cFXGLContext.klass = rb_define_class_under(mFox, "FXGLContext", ((swig_class *) SWIGTYPE_p_FXId->clientdata)->klass);
    SWIG_TypeClientData(SWIGTYPE_p_FXGLContext, (void *) &cFXGLContext);
    rb_define_alloc_func(cFXGLContext.klass, _wrap_FXGLContext_allocate);
    rb_define_method(cFXGLContext.klass, "initialize", VALUEFUNC(_wrap_new_FXGLContext), -1);
    rb_define_method(cFXGLContext.klass, "isShared", VALUEFUNC(_wrap_FXGLContext_isShared), -1);
    rb_define_method(cFXGLContext.klass, "getVisual", VALUEFUNC(_wrap_FXGLContext_getVisual), -1);
    rb_define_method(cFXGLContext.klass, "begin", VALUEFUNC(_wrap_FXGLContext_begin), -1);
    rb_define_method(cFXGLContext.klass, "end", VALUEFUNC(_wrap_FXGLContext_end), -1);
    rb_define_method(cFXGLContext.klass, "swapBuffers", VALUEFUNC(_wrap_FXGLContext_swapBuffers), -1);
    rb_define_method(cFXGLContext.klass, "swapSubBuffers", VALUEFUNC(_wrap_FXGLContext_swapSubBuffers), -1);
    rb_define_method(cFXGLContext.klass, "save", VALUEFUNC(_wrap_FXGLContext_save), -1);
    rb_define_method(cFXGLContext.klass, "load", VALUEFUNC(_wrap_FXGLContext_load), -1);
    rb_define_method(cFXGLContext.klass, "create", VALUEFUNC(_wrap_FXGLContext_create), -1);
    rb_define_method(cFXGLContext.klass, "detach", VALUEFUNC(_wrap_FXGLContext_detach), -1);
    rb_define_method(cFXGLContext.klass, "destroy", VALUEFUNC(_wrap_FXGLContext_destroy), -1);
    cFXGLContext.mark = (void (*)(void *)) FXRbGLContext::markfunc;
    cFXGLContext.destroy = (void (*)(void *)) FXRbObject::freefunc;
    
    cFXGLCanvas.klass = rb_define_class_under(mFox, "FXGLCanvas", ((swig_class *) SWIGTYPE_p_FXCanvas->clientdata)->klass);
    SWIG_TypeClientData(SWIGTYPE_p_FXGLCanvas, (void *) &cFXGLCanvas);
    rb_define_alloc_func(cFXGLCanvas.klass, _wrap_FXGLCanvas_allocate);
    rb_define_method(cFXGLCanvas.klass, "initialize", VALUEFUNC(_wrap_new_FXGLCanvas), -1);
    rb_define_method(cFXGLCanvas.klass, "isShared", VALUEFUNC(_wrap_FXGLCanvas_isShared), -1);
    rb_define_singleton_method(cFXGLCanvas.klass, "getCurrentContext", VALUEFUNC(_wrap_FXGLCanvas_getCurrentContext), -1);
    rb_define_method(cFXGLCanvas.klass, "getContext", VALUEFUNC(_wrap_FXGLCanvas_getContext), -1);
    rb_define_method(cFXGLCanvas.klass, "save", VALUEFUNC(_wrap_FXGLCanvas_save), -1);
    rb_define_method(cFXGLCanvas.klass, "load", VALUEFUNC(_wrap_FXGLCanvas_load), -1);
    rb_define_method(cFXGLCanvas.klass, "create", VALUEFUNC(_wrap_FXGLCanvas_create), -1);
    rb_define_method(cFXGLCanvas.klass, "detach", VALUEFUNC(_wrap_FXGLCanvas_detach), -1);
    rb_define_method(cFXGLCanvas.klass, "destroy", VALUEFUNC(_wrap_FXGLCanvas_destroy), -1);
    rb_define_method(cFXGLCanvas.klass, "resize", VALUEFUNC(_wrap_FXGLCanvas_resize), -1);
    rb_define_method(cFXGLCanvas.klass, "getDefaultWidth", VALUEFUNC(_wrap_FXGLCanvas_getDefaultWidth), -1);
    rb_define_method(cFXGLCanvas.klass, "getDefaultHeight", VALUEFUNC(_wrap_FXGLCanvas_getDefaultHeight), -1);
    rb_define_method(cFXGLCanvas.klass, "getWidthForHeight", VALUEFUNC(_wrap_FXGLCanvas_getWidthForHeight), -1);
    rb_define_method(cFXGLCanvas.klass, "getHeightForWidth", VALUEFUNC(_wrap_FXGLCanvas_getHeightForWidth), -1);
    rb_define_method(cFXGLCanvas.klass, "canFocus", VALUEFUNC(_wrap_FXGLCanvas_canFocus), -1);
    rb_define_method(cFXGLCanvas.klass, "setFocus", VALUEFUNC(_wrap_FXGLCanvas_setFocus), -1);
    rb_define_method(cFXGLCanvas.klass, "killFocus", VALUEFUNC(_wrap_FXGLCanvas_killFocus), -1);
    rb_define_method(cFXGLCanvas.klass, "setDefault", VALUEFUNC(_wrap_FXGLCanvas_setDefault), -1);
    rb_define_method(cFXGLCanvas.klass, "enable", VALUEFUNC(_wrap_FXGLCanvas_enable), -1);
    rb_define_method(cFXGLCanvas.klass, "disable", VALUEFUNC(_wrap_FXGLCanvas_disable), -1);
    rb_define_method(cFXGLCanvas.klass, "raiseWindow", VALUEFUNC(_wrap_FXGLCanvas_raiseWindow), -1);
    rb_define_method(cFXGLCanvas.klass, "lower", VALUEFUNC(_wrap_FXGLCanvas_lower), -1);
    rb_define_method(cFXGLCanvas.klass, "move", VALUEFUNC(_wrap_FXGLCanvas_move), -1);
    rb_define_method(cFXGLCanvas.klass, "position", VALUEFUNC(_wrap_FXGLCanvas_position), -1);
    rb_define_method(cFXGLCanvas.klass, "layout", VALUEFUNC(_wrap_FXGLCanvas_layout), -1);
    rb_define_method(cFXGLCanvas.klass, "recalc", VALUEFUNC(_wrap_FXGLCanvas_recalc), -1);
    rb_define_method(cFXGLCanvas.klass, "reparent", VALUEFUNC(_wrap_FXGLCanvas_reparent), -1);
    rb_define_method(cFXGLCanvas.klass, "show", VALUEFUNC(_wrap_FXGLCanvas_show), -1);
    rb_define_method(cFXGLCanvas.klass, "hide", VALUEFUNC(_wrap_FXGLCanvas_hide), -1);
    rb_define_method(cFXGLCanvas.klass, "isComposite", VALUEFUNC(_wrap_FXGLCanvas_isComposite), -1);
    rb_define_method(cFXGLCanvas.klass, "contains", VALUEFUNC(_wrap_FXGLCanvas_contains), -1);
    rb_define_method(cFXGLCanvas.klass, "doesSaveUnder", VALUEFUNC(_wrap_FXGLCanvas_doesSaveUnder), -1);
    rb_define_method(cFXGLCanvas.klass, "setBackColor", VALUEFUNC(_wrap_FXGLCanvas_setBackColor), -1);
    rb_define_method(cFXGLCanvas.klass, "makeCurrent", VALUEFUNC(_wrap_FXGLCanvas_makeCurrent), -1);
    rb_define_method(cFXGLCanvas.klass, "makeNonCurrent", VALUEFUNC(_wrap_FXGLCanvas_makeNonCurrent), -1);
    rb_define_method(cFXGLCanvas.klass, "isCurrent", VALUEFUNC(_wrap_FXGLCanvas_isCurrent), -1);
    rb_define_method(cFXGLCanvas.klass, "swapBuffers", VALUEFUNC(_wrap_FXGLCanvas_swapBuffers), -1);
    cFXGLCanvas.mark = (void (*)(void *)) FXRbGLCanvas::markfunc;
    cFXGLCanvas.destroy = (void (*)(void *)) FXRbObject::freefunc;
    
    SWIGTYPE_p_FXGLCanvas->dcast = (swig_dycast_func) FXGLCanvas_dynamic_cast;
    
    rb_define_const(mFox,"VIEWER_LIGHTING", INT2NUM(VIEWER_LIGHTING));
    rb_define_const(mFox,"VIEWER_FOG", INT2NUM(VIEWER_FOG));
    rb_define_const(mFox,"VIEWER_DITHER", INT2NUM(VIEWER_DITHER));
    
    cFXViewport.klass = rb_define_class_under(mFox, "FXViewport", rb_cObject);
    SWIG_TypeClientData(SWIGTYPE_p_FXViewport, (void *) &cFXViewport);
    rb_define_alloc_func(cFXViewport.klass, _wrap_FXViewport_allocate);
    rb_define_method(cFXViewport.klass, "initialize", VALUEFUNC(_wrap_new_FXViewport), -1);
    rb_define_method(cFXViewport.klass, "w=", VALUEFUNC(_wrap_FXViewport_w_set), -1);
    rb_define_method(cFXViewport.klass, "w", VALUEFUNC(_wrap_FXViewport_w_get), -1);
    rb_define_method(cFXViewport.klass, "h=", VALUEFUNC(_wrap_FXViewport_h_set), -1);
    rb_define_method(cFXViewport.klass, "h", VALUEFUNC(_wrap_FXViewport_h_get), -1);
    rb_define_method(cFXViewport.klass, "left=", VALUEFUNC(_wrap_FXViewport_left_set), -1);
    rb_define_method(cFXViewport.klass, "left", VALUEFUNC(_wrap_FXViewport_left_get), -1);
    rb_define_method(cFXViewport.klass, "right=", VALUEFUNC(_wrap_FXViewport_right_set), -1);
    rb_define_method(cFXViewport.klass, "right", VALUEFUNC(_wrap_FXViewport_right_get), -1);
    rb_define_method(cFXViewport.klass, "bottom=", VALUEFUNC(_wrap_FXViewport_bottom_set), -1);
    rb_define_method(cFXViewport.klass, "bottom", VALUEFUNC(_wrap_FXViewport_bottom_get), -1);
    rb_define_method(cFXViewport.klass, "top=", VALUEFUNC(_wrap_FXViewport_top_set), -1);
    rb_define_method(cFXViewport.klass, "top", VALUEFUNC(_wrap_FXViewport_top_get), -1);
    rb_define_method(cFXViewport.klass, "hither=", VALUEFUNC(_wrap_FXViewport_hither_set), -1);
    rb_define_method(cFXViewport.klass, "hither", VALUEFUNC(_wrap_FXViewport_hither_get), -1);
    rb_define_method(cFXViewport.klass, "yon=", VALUEFUNC(_wrap_FXViewport_yon_set), -1);
    rb_define_method(cFXViewport.klass, "yon", VALUEFUNC(_wrap_FXViewport_yon_get), -1);
    cFXViewport.mark = 0;
    cFXViewport.destroy = (void (*)(void *)) FXRbUnregisterRubyObj;
    
    cFXLight.klass = rb_define_class_under(mFox, "FXLight", rb_cObject);
    SWIG_TypeClientData(SWIGTYPE_p_FXLight, (void *) &cFXLight);
    rb_define_alloc_func(cFXLight.klass, _wrap_FXLight_allocate);
    rb_define_method(cFXLight.klass, "initialize", VALUEFUNC(_wrap_new_FXLight), -1);
    rb_define_method(cFXLight.klass, "ambient=", VALUEFUNC(_wrap_FXLight_ambient_set), -1);
    rb_define_method(cFXLight.klass, "ambient", VALUEFUNC(_wrap_FXLight_ambient_get), -1);
    rb_define_method(cFXLight.klass, "diffuse=", VALUEFUNC(_wrap_FXLight_diffuse_set), -1);
    rb_define_method(cFXLight.klass, "diffuse", VALUEFUNC(_wrap_FXLight_diffuse_get), -1);
    rb_define_method(cFXLight.klass, "specular=", VALUEFUNC(_wrap_FXLight_specular_set), -1);
    rb_define_method(cFXLight.klass, "specular", VALUEFUNC(_wrap_FXLight_specular_get), -1);
    rb_define_method(cFXLight.klass, "position=", VALUEFUNC(_wrap_FXLight_position_set), -1);
    rb_define_method(cFXLight.klass, "position", VALUEFUNC(_wrap_FXLight_position_get), -1);
    rb_define_method(cFXLight.klass, "direction=", VALUEFUNC(_wrap_FXLight_direction_set), -1);
    rb_define_method(cFXLight.klass, "direction", VALUEFUNC(_wrap_FXLight_direction_get), -1);
    rb_define_method(cFXLight.klass, "exponent=", VALUEFUNC(_wrap_FXLight_exponent_set), -1);
    rb_define_method(cFXLight.klass, "exponent", VALUEFUNC(_wrap_FXLight_exponent_get), -1);
    rb_define_method(cFXLight.klass, "cutoff=", VALUEFUNC(_wrap_FXLight_cutoff_set), -1);
    rb_define_method(cFXLight.klass, "cutoff", VALUEFUNC(_wrap_FXLight_cutoff_get), -1);
    rb_define_method(cFXLight.klass, "c_attn=", VALUEFUNC(_wrap_FXLight_c_attn_set), -1);
    rb_define_method(cFXLight.klass, "c_attn", VALUEFUNC(_wrap_FXLight_c_attn_get), -1);
    rb_define_method(cFXLight.klass, "l_attn=", VALUEFUNC(_wrap_FXLight_l_attn_set), -1);
    rb_define_method(cFXLight.klass, "l_attn", VALUEFUNC(_wrap_FXLight_l_attn_get), -1);
    rb_define_method(cFXLight.klass, "q_attn=", VALUEFUNC(_wrap_FXLight_q_attn_set), -1);
    rb_define_method(cFXLight.klass, "q_attn", VALUEFUNC(_wrap_FXLight_q_attn_get), -1);
    cFXLight.mark = 0;
    cFXLight.destroy = (void (*)(void *)) FXRbUnregisterRubyObj;
    
    cFXMaterial.klass = rb_define_class_under(mFox, "FXMaterial", rb_cObject);
    SWIG_TypeClientData(SWIGTYPE_p_FXMaterial, (void *) &cFXMaterial);
    rb_define_alloc_func(cFXMaterial.klass, _wrap_FXMaterial_allocate);
    rb_define_method(cFXMaterial.klass, "initialize", VALUEFUNC(_wrap_new_FXMaterial), -1);
    rb_define_method(cFXMaterial.klass, "ambient=", VALUEFUNC(_wrap_FXMaterial_ambient_set), -1);
    rb_define_method(cFXMaterial.klass, "ambient", VALUEFUNC(_wrap_FXMaterial_ambient_get), -1);
    rb_define_method(cFXMaterial.klass, "diffuse=", VALUEFUNC(_wrap_FXMaterial_diffuse_set), -1);
    rb_define_method(cFXMaterial.klass, "diffuse", VALUEFUNC(_wrap_FXMaterial_diffuse_get), -1);
    rb_define_method(cFXMaterial.klass, "specular=", VALUEFUNC(_wrap_FXMaterial_specular_set), -1);
    rb_define_method(cFXMaterial.klass, "specular", VALUEFUNC(_wrap_FXMaterial_specular_get), -1);
    rb_define_method(cFXMaterial.klass, "emission=", VALUEFUNC(_wrap_FXMaterial_emission_set), -1);
    rb_define_method(cFXMaterial.klass, "emission", VALUEFUNC(_wrap_FXMaterial_emission_get), -1);
    rb_define_method(cFXMaterial.klass, "shininess=", VALUEFUNC(_wrap_FXMaterial_shininess_set), -1);
    rb_define_method(cFXMaterial.klass, "shininess", VALUEFUNC(_wrap_FXMaterial_shininess_get), -1);
    cFXMaterial.mark = 0;
    cFXMaterial.destroy = (void (*)(void *)) FXRbUnregisterRubyObj;
    
    cFXGLViewer.klass = rb_define_class_under(mFox, "FXGLViewer", ((swig_class *) SWIGTYPE_p_FXGLCanvas->clientdata)->klass);
    SWIG_TypeClientData(SWIGTYPE_p_FXGLViewer, (void *) &cFXGLViewer);
    rb_define_alloc_func(cFXGLViewer.klass, _wrap_FXGLViewer_allocate);
    rb_define_method(cFXGLViewer.klass, "initialize", VALUEFUNC(_wrap_new_FXGLViewer), -1);
    rb_define_singleton_method(cFXGLViewer.klass, "objectType", VALUEFUNC(FXGLViewer_objectType_get), 0);
    rb_define_singleton_method(cFXGLViewer.klass, "objectType=", VALUEFUNC(FXGLViewer_objectType_set), 1);
    rb_define_method(cFXGLViewer.klass, "onPaint", VALUEFUNC(_wrap_FXGLViewer_onPaint), -1);
    rb_define_method(cFXGLViewer.klass, "onEnter", VALUEFUNC(_wrap_FXGLViewer_onEnter), -1);
    rb_define_method(cFXGLViewer.klass, "onLeave", VALUEFUNC(_wrap_FXGLViewer_onLeave), -1);
    rb_define_method(cFXGLViewer.klass, "onMotion", VALUEFUNC(_wrap_FXGLViewer_onMotion), -1);
    rb_define_method(cFXGLViewer.klass, "onMouseWheel", VALUEFUNC(_wrap_FXGLViewer_onMouseWheel), -1);
    rb_define_method(cFXGLViewer.klass, "onChanged", VALUEFUNC(_wrap_FXGLViewer_onChanged), -1);
    rb_define_method(cFXGLViewer.klass, "onPick", VALUEFUNC(_wrap_FXGLViewer_onPick), -1);
    rb_define_method(cFXGLViewer.klass, "onClicked", VALUEFUNC(_wrap_FXGLViewer_onClicked), -1);
    rb_define_method(cFXGLViewer.klass, "onDoubleClicked", VALUEFUNC(_wrap_FXGLViewer_onDoubleClicked), -1);
    rb_define_method(cFXGLViewer.klass, "onTripleClicked", VALUEFUNC(_wrap_FXGLViewer_onTripleClicked), -1);
    rb_define_method(cFXGLViewer.klass, "onLassoed", VALUEFUNC(_wrap_FXGLViewer_onLassoed), -1);
    rb_define_method(cFXGLViewer.klass, "onSelected", VALUEFUNC(_wrap_FXGLViewer_onSelected), -1);
    rb_define_method(cFXGLViewer.klass, "onDeselected", VALUEFUNC(_wrap_FXGLViewer_onDeselected), -1);
    rb_define_method(cFXGLViewer.klass, "onInserted", VALUEFUNC(_wrap_FXGLViewer_onInserted), -1);
    rb_define_method(cFXGLViewer.klass, "onDeleted", VALUEFUNC(_wrap_FXGLViewer_onDeleted), -1);
    rb_define_method(cFXGLViewer.klass, "onLeftBtnPress", VALUEFUNC(_wrap_FXGLViewer_onLeftBtnPress), -1);
    rb_define_method(cFXGLViewer.klass, "onLeftBtnRelease", VALUEFUNC(_wrap_FXGLViewer_onLeftBtnRelease), -1);
    rb_define_method(cFXGLViewer.klass, "onMiddleBtnPress", VALUEFUNC(_wrap_FXGLViewer_onMiddleBtnPress), -1);
    rb_define_method(cFXGLViewer.klass, "onMiddleBtnRelease", VALUEFUNC(_wrap_FXGLViewer_onMiddleBtnRelease), -1);
    rb_define_method(cFXGLViewer.klass, "onRightBtnPress", VALUEFUNC(_wrap_FXGLViewer_onRightBtnPress), -1);
    rb_define_method(cFXGLViewer.klass, "onRightBtnRelease", VALUEFUNC(_wrap_FXGLViewer_onRightBtnRelease), -1);
    rb_define_method(cFXGLViewer.klass, "onUngrabbed", VALUEFUNC(_wrap_FXGLViewer_onUngrabbed), -1);
    rb_define_method(cFXGLViewer.klass, "onKeyPress", VALUEFUNC(_wrap_FXGLViewer_onKeyPress), -1);
    rb_define_method(cFXGLViewer.klass, "onKeyRelease", VALUEFUNC(_wrap_FXGLViewer_onKeyRelease), -1);
    rb_define_method(cFXGLViewer.klass, "onFocusIn", VALUEFUNC(_wrap_FXGLViewer_onFocusIn), -1);
    rb_define_method(cFXGLViewer.klass, "onFocusOut", VALUEFUNC(_wrap_FXGLViewer_onFocusOut), -1);
    rb_define_method(cFXGLViewer.klass, "onClipboardLost", VALUEFUNC(_wrap_FXGLViewer_onClipboardLost), -1);
    rb_define_method(cFXGLViewer.klass, "onClipboardGained", VALUEFUNC(_wrap_FXGLViewer_onClipboardGained), -1);
    rb_define_method(cFXGLViewer.klass, "onClipboardRequest", VALUEFUNC(_wrap_FXGLViewer_onClipboardRequest), -1);
    rb_define_method(cFXGLViewer.klass, "onCmdPerspective", VALUEFUNC(_wrap_FXGLViewer_onCmdPerspective), -1);
    rb_define_method(cFXGLViewer.klass, "onUpdPerspective", VALUEFUNC(_wrap_FXGLViewer_onUpdPerspective), -1);
    rb_define_method(cFXGLViewer.klass, "onCmdParallel", VALUEFUNC(_wrap_FXGLViewer_onCmdParallel), -1);
    rb_define_method(cFXGLViewer.klass, "onUpdParallel", VALUEFUNC(_wrap_FXGLViewer_onUpdParallel), -1);
    rb_define_method(cFXGLViewer.klass, "onCmdFront", VALUEFUNC(_wrap_FXGLViewer_onCmdFront), -1);
    rb_define_method(cFXGLViewer.klass, "onUpdFront", VALUEFUNC(_wrap_FXGLViewer_onUpdFront), -1);
    rb_define_method(cFXGLViewer.klass, "onCmdBack", VALUEFUNC(_wrap_FXGLViewer_onCmdBack), -1);
    rb_define_method(cFXGLViewer.klass, "onUpdBack", VALUEFUNC(_wrap_FXGLViewer_onUpdBack), -1);
    rb_define_method(cFXGLViewer.klass, "onCmdLeft", VALUEFUNC(_wrap_FXGLViewer_onCmdLeft), -1);
    rb_define_method(cFXGLViewer.klass, "onUpdLeft", VALUEFUNC(_wrap_FXGLViewer_onUpdLeft), -1);
    rb_define_method(cFXGLViewer.klass, "onCmdRight", VALUEFUNC(_wrap_FXGLViewer_onCmdRight), -1);
    rb_define_method(cFXGLViewer.klass, "onUpdRight", VALUEFUNC(_wrap_FXGLViewer_onUpdRight), -1);
    rb_define_method(cFXGLViewer.klass, "onCmdTop", VALUEFUNC(_wrap_FXGLViewer_onCmdTop), -1);
    rb_define_method(cFXGLViewer.klass, "onUpdTop", VALUEFUNC(_wrap_FXGLViewer_onUpdTop), -1);
    rb_define_method(cFXGLViewer.klass, "onCmdBottom", VALUEFUNC(_wrap_FXGLViewer_onCmdBottom), -1);
    rb_define_method(cFXGLViewer.klass, "onUpdBottom", VALUEFUNC(_wrap_FXGLViewer_onUpdBottom), -1);
    rb_define_method(cFXGLViewer.klass, "onCmdResetView", VALUEFUNC(_wrap_FXGLViewer_onCmdResetView), -1);
    rb_define_method(cFXGLViewer.klass, "onCmdFitView", VALUEFUNC(_wrap_FXGLViewer_onCmdFitView), -1);
    rb_define_method(cFXGLViewer.klass, "onDNDEnter", VALUEFUNC(_wrap_FXGLViewer_onDNDEnter), -1);
    rb_define_method(cFXGLViewer.klass, "onDNDLeave", VALUEFUNC(_wrap_FXGLViewer_onDNDLeave), -1);
    rb_define_method(cFXGLViewer.klass, "onDNDMotion", VALUEFUNC(_wrap_FXGLViewer_onDNDMotion), -1);
    rb_define_method(cFXGLViewer.klass, "onDNDDrop", VALUEFUNC(_wrap_FXGLViewer_onDNDDrop), -1);
    rb_define_method(cFXGLViewer.klass, "onTipTimer", VALUEFUNC(_wrap_FXGLViewer_onTipTimer), -1);
    rb_define_method(cFXGLViewer.klass, "onCmdXYZDial", VALUEFUNC(_wrap_FXGLViewer_onCmdXYZDial), -1);
    rb_define_method(cFXGLViewer.klass, "onUpdXYZDial", VALUEFUNC(_wrap_FXGLViewer_onUpdXYZDial), -1);
    rb_define_method(cFXGLViewer.klass, "onCmdRollPitchYaw", VALUEFUNC(_wrap_FXGLViewer_onCmdRollPitchYaw), -1);
    rb_define_method(cFXGLViewer.klass, "onUpdRollPitchYaw", VALUEFUNC(_wrap_FXGLViewer_onUpdRollPitchYaw), -1);
    rb_define_method(cFXGLViewer.klass, "onCmdXYZScale", VALUEFUNC(_wrap_FXGLViewer_onCmdXYZScale), -1);
    rb_define_method(cFXGLViewer.klass, "onUpdXYZScale", VALUEFUNC(_wrap_FXGLViewer_onUpdXYZScale), -1);
    rb_define_method(cFXGLViewer.klass, "onUpdCurrent", VALUEFUNC(_wrap_FXGLViewer_onUpdCurrent), -1);
    rb_define_method(cFXGLViewer.klass, "onCmdCutSel", VALUEFUNC(_wrap_FXGLViewer_onCmdCutSel), -1);
    rb_define_method(cFXGLViewer.klass, "onCmdCopySel", VALUEFUNC(_wrap_FXGLViewer_onCmdCopySel), -1);
    rb_define_method(cFXGLViewer.klass, "onCmdPasteSel", VALUEFUNC(_wrap_FXGLViewer_onCmdPasteSel), -1);
    rb_define_method(cFXGLViewer.klass, "onCmdDeleteSel", VALUEFUNC(_wrap_FXGLViewer_onCmdDeleteSel), -1);
    rb_define_method(cFXGLViewer.klass, "onUpdDeleteSel", VALUEFUNC(_wrap_FXGLViewer_onUpdDeleteSel), -1);
    rb_define_method(cFXGLViewer.klass, "onCmdBackColor", VALUEFUNC(_wrap_FXGLViewer_onCmdBackColor), -1);
    rb_define_method(cFXGLViewer.klass, "onUpdBackColor", VALUEFUNC(_wrap_FXGLViewer_onUpdBackColor), -1);
    rb_define_method(cFXGLViewer.klass, "onCmdGradientBackColor", VALUEFUNC(_wrap_FXGLViewer_onCmdGradientBackColor), -1);
    rb_define_method(cFXGLViewer.klass, "onUpdGradientBackColor", VALUEFUNC(_wrap_FXGLViewer_onUpdGradientBackColor), -1);
    rb_define_method(cFXGLViewer.klass, "onCmdAmbientColor", VALUEFUNC(_wrap_FXGLViewer_onCmdAmbientColor), -1);
    rb_define_method(cFXGLViewer.klass, "onUpdAmbientColor", VALUEFUNC(_wrap_FXGLViewer_onUpdAmbientColor), -1);
    rb_define_method(cFXGLViewer.klass, "onCmdLighting", VALUEFUNC(_wrap_FXGLViewer_onCmdLighting), -1);
    rb_define_method(cFXGLViewer.klass, "onUpdLighting", VALUEFUNC(_wrap_FXGLViewer_onUpdLighting), -1);
    rb_define_method(cFXGLViewer.klass, "onCmdFog", VALUEFUNC(_wrap_FXGLViewer_onCmdFog), -1);
    rb_define_method(cFXGLViewer.klass, "onUpdFog", VALUEFUNC(_wrap_FXGLViewer_onUpdFog), -1);
    rb_define_method(cFXGLViewer.klass, "onCmdDither", VALUEFUNC(_wrap_FXGLViewer_onCmdDither), -1);
    rb_define_method(cFXGLViewer.klass, "onUpdDither", VALUEFUNC(_wrap_FXGLViewer_onUpdDither), -1);
    rb_define_method(cFXGLViewer.klass, "onCmdFov", VALUEFUNC(_wrap_FXGLViewer_onCmdFov), -1);
    rb_define_method(cFXGLViewer.klass, "onUpdFov", VALUEFUNC(_wrap_FXGLViewer_onUpdFov), -1);
    rb_define_method(cFXGLViewer.klass, "onCmdZoom", VALUEFUNC(_wrap_FXGLViewer_onCmdZoom), -1);
    rb_define_method(cFXGLViewer.klass, "onUpdZoom", VALUEFUNC(_wrap_FXGLViewer_onUpdZoom), -1);
    rb_define_method(cFXGLViewer.klass, "onCmdLightAmbient", VALUEFUNC(_wrap_FXGLViewer_onCmdLightAmbient), -1);
    rb_define_method(cFXGLViewer.klass, "onUpdLightAmbient", VALUEFUNC(_wrap_FXGLViewer_onUpdLightAmbient), -1);
    rb_define_method(cFXGLViewer.klass, "onCmdLightDiffuse", VALUEFUNC(_wrap_FXGLViewer_onCmdLightDiffuse), -1);
    rb_define_method(cFXGLViewer.klass, "onUpdLightDiffuse", VALUEFUNC(_wrap_FXGLViewer_onUpdLightDiffuse), -1);
    rb_define_method(cFXGLViewer.klass, "onCmdLightSpecular", VALUEFUNC(_wrap_FXGLViewer_onCmdLightSpecular), -1);
    rb_define_method(cFXGLViewer.klass, "onUpdLightSpecular", VALUEFUNC(_wrap_FXGLViewer_onUpdLightSpecular), -1);
    rb_define_method(cFXGLViewer.klass, "onCmdTurbo", VALUEFUNC(_wrap_FXGLViewer_onCmdTurbo), -1);
    rb_define_method(cFXGLViewer.klass, "onUpdTurbo", VALUEFUNC(_wrap_FXGLViewer_onUpdTurbo), -1);
    rb_define_method(cFXGLViewer.klass, "onCmdPrintImage", VALUEFUNC(_wrap_FXGLViewer_onCmdPrintImage), -1);
    rb_define_method(cFXGLViewer.klass, "onCmdPrintVector", VALUEFUNC(_wrap_FXGLViewer_onCmdPrintVector), -1);
    rb_define_method(cFXGLViewer.klass, "onCmdLassoZoom", VALUEFUNC(_wrap_FXGLViewer_onCmdLassoZoom), -1);
    rb_define_method(cFXGLViewer.klass, "onCmdLassoSelect", VALUEFUNC(_wrap_FXGLViewer_onCmdLassoSelect), -1);
    rb_define_method(cFXGLViewer.klass, "onQueryHelp", VALUEFUNC(_wrap_FXGLViewer_onQueryHelp), -1);
    rb_define_method(cFXGLViewer.klass, "onQueryTip", VALUEFUNC(_wrap_FXGLViewer_onQueryTip), -1);
    rb_define_const(cFXGLViewer.klass,"PARALLEL", INT2NUM(FXGLViewer::PARALLEL));
    rb_define_const(cFXGLViewer.klass,"PERSPECTIVE", INT2NUM(FXGLViewer::PERSPECTIVE));
    rb_define_const(cFXGLViewer.klass,"ID_PERSPECTIVE", INT2NUM(FXGLViewer::ID_PERSPECTIVE));
    rb_define_const(cFXGLViewer.klass,"ID_PARALLEL", INT2NUM(FXGLViewer::ID_PARALLEL));
    rb_define_const(cFXGLViewer.klass,"ID_FRONT", INT2NUM(FXGLViewer::ID_FRONT));
    rb_define_const(cFXGLViewer.klass,"ID_BACK", INT2NUM(FXGLViewer::ID_BACK));
    rb_define_const(cFXGLViewer.klass,"ID_LEFT", INT2NUM(FXGLViewer::ID_LEFT));
    rb_define_const(cFXGLViewer.klass,"ID_RIGHT", INT2NUM(FXGLViewer::ID_RIGHT));
    rb_define_const(cFXGLViewer.klass,"ID_TOP", INT2NUM(FXGLViewer::ID_TOP));
    rb_define_const(cFXGLViewer.klass,"ID_BOTTOM", INT2NUM(FXGLViewer::ID_BOTTOM));
    rb_define_const(cFXGLViewer.klass,"ID_RESETVIEW", INT2NUM(FXGLViewer::ID_RESETVIEW));
    rb_define_const(cFXGLViewer.klass,"ID_FITVIEW", INT2NUM(FXGLViewer::ID_FITVIEW));
    rb_define_const(cFXGLViewer.klass,"ID_TOP_COLOR", INT2NUM(FXGLViewer::ID_TOP_COLOR));
    rb_define_const(cFXGLViewer.klass,"ID_BOTTOM_COLOR", INT2NUM(FXGLViewer::ID_BOTTOM_COLOR));
    rb_define_const(cFXGLViewer.klass,"ID_BACK_COLOR", INT2NUM(FXGLViewer::ID_BACK_COLOR));
    rb_define_const(cFXGLViewer.klass,"ID_AMBIENT_COLOR", INT2NUM(FXGLViewer::ID_AMBIENT_COLOR));
    rb_define_const(cFXGLViewer.klass,"ID_LIGHT_AMBIENT", INT2NUM(FXGLViewer::ID_LIGHT_AMBIENT));
    rb_define_const(cFXGLViewer.klass,"ID_LIGHT_DIFFUSE", INT2NUM(FXGLViewer::ID_LIGHT_DIFFUSE));
    rb_define_const(cFXGLViewer.klass,"ID_LIGHT_SPECULAR", INT2NUM(FXGLViewer::ID_LIGHT_SPECULAR));
    rb_define_const(cFXGLViewer.klass,"ID_LIGHTING", INT2NUM(FXGLViewer::ID_LIGHTING));
    rb_define_const(cFXGLViewer.klass,"ID_TURBO", INT2NUM(FXGLViewer::ID_TURBO));
    rb_define_const(cFXGLViewer.klass,"ID_FOG", INT2NUM(FXGLViewer::ID_FOG));
    rb_define_const(cFXGLViewer.klass,"ID_DITHER", INT2NUM(FXGLViewer::ID_DITHER));
    rb_define_const(cFXGLViewer.klass,"ID_SCALE_X", INT2NUM(FXGLViewer::ID_SCALE_X));
    rb_define_const(cFXGLViewer.klass,"ID_SCALE_Y", INT2NUM(FXGLViewer::ID_SCALE_Y));
    rb_define_const(cFXGLViewer.klass,"ID_SCALE_Z", INT2NUM(FXGLViewer::ID_SCALE_Z));
    rb_define_const(cFXGLViewer.klass,"ID_DIAL_X", INT2NUM(FXGLViewer::ID_DIAL_X));
    rb_define_const(cFXGLViewer.klass,"ID_DIAL_Y", INT2NUM(FXGLViewer::ID_DIAL_Y));
    rb_define_const(cFXGLViewer.klass,"ID_DIAL_Z", INT2NUM(FXGLViewer::ID_DIAL_Z));
    rb_define_const(cFXGLViewer.klass,"ID_ROLL", INT2NUM(FXGLViewer::ID_ROLL));
    rb_define_const(cFXGLViewer.klass,"ID_PITCH", INT2NUM(FXGLViewer::ID_PITCH));
    rb_define_const(cFXGLViewer.klass,"ID_YAW", INT2NUM(FXGLViewer::ID_YAW));
    rb_define_const(cFXGLViewer.klass,"ID_FOV", INT2NUM(FXGLViewer::ID_FOV));
    rb_define_const(cFXGLViewer.klass,"ID_ZOOM", INT2NUM(FXGLViewer::ID_ZOOM));
    rb_define_const(cFXGLViewer.klass,"ID_CUT_SEL", INT2NUM(FXGLViewer::ID_CUT_SEL));
    rb_define_const(cFXGLViewer.klass,"ID_COPY_SEL", INT2NUM(FXGLViewer::ID_COPY_SEL));
    rb_define_const(cFXGLViewer.klass,"ID_PASTE_SEL", INT2NUM(FXGLViewer::ID_PASTE_SEL));
    rb_define_const(cFXGLViewer.klass,"ID_DELETE_SEL", INT2NUM(FXGLViewer::ID_DELETE_SEL));
    rb_define_const(cFXGLViewer.klass,"ID_PRINT_IMAGE", INT2NUM(FXGLViewer::ID_PRINT_IMAGE));
    rb_define_const(cFXGLViewer.klass,"ID_PRINT_VECTOR", INT2NUM(FXGLViewer::ID_PRINT_VECTOR));
    rb_define_const(cFXGLViewer.klass,"ID_LASSO_ZOOM", INT2NUM(FXGLViewer::ID_LASSO_ZOOM));
    rb_define_const(cFXGLViewer.klass,"ID_LASSO_SELECT", INT2NUM(FXGLViewer::ID_LASSO_SELECT));
    rb_define_const(cFXGLViewer.klass,"ID_LAST", INT2NUM(FXGLViewer::ID_LAST));
    rb_define_singleton_method(cFXGLViewer.klass, "objectTypeName", VALUEFUNC(_wrap_FXGLViewer_objectTypeName), -1);
    rb_define_method(cFXGLViewer.klass, "worldPix", VALUEFUNC(_wrap_FXGLViewer_worldPix), -1);
    rb_define_method(cFXGLViewer.klass, "modelPix", VALUEFUNC(_wrap_FXGLViewer_modelPix), -1);
    rb_define_method(cFXGLViewer.klass, "lasso", VALUEFUNC(_wrap_FXGLViewer_lasso), -1);
    rb_define_method(cFXGLViewer.klass, "setBounds", VALUEFUNC(_wrap_FXGLViewer_setBounds), -1);
    rb_define_method(cFXGLViewer.klass, "fitToBounds", VALUEFUNC(_wrap_FXGLViewer_fitToBounds), -1);
    rb_define_method(cFXGLViewer.klass, "getViewport", VALUEFUNC(_wrap_FXGLViewer_getViewport), -1);
    rb_define_method(cFXGLViewer.klass, "eyeToScreen", VALUEFUNC(_wrap_FXGLViewer_eyeToScreen), -1);
    rb_define_method(cFXGLViewer.klass, "screenToEye", VALUEFUNC(_wrap_FXGLViewer_screenToEye), -1);
    rb_define_method(cFXGLViewer.klass, "screenToTarget", VALUEFUNC(_wrap_FXGLViewer_screenToTarget), -1);
    rb_define_method(cFXGLViewer.klass, "worldToEye", VALUEFUNC(_wrap_FXGLViewer_worldToEye), -1);
    rb_define_method(cFXGLViewer.klass, "worldToEyeZ", VALUEFUNC(_wrap_FXGLViewer_worldToEyeZ), -1);
    rb_define_method(cFXGLViewer.klass, "eyeToWorld", VALUEFUNC(_wrap_FXGLViewer_eyeToWorld), -1);
    rb_define_method(cFXGLViewer.klass, "worldVector", VALUEFUNC(_wrap_FXGLViewer_worldVector), -1);
    rb_define_method(cFXGLViewer.klass, "setMaterial", VALUEFUNC(_wrap_FXGLViewer_setMaterial), -1);
    rb_define_method(cFXGLViewer.klass, "getMaterial", VALUEFUNC(_wrap_FXGLViewer_getMaterial), -1);
    rb_define_method(cFXGLViewer.klass, "setFieldOfView", VALUEFUNC(_wrap_FXGLViewer_setFieldOfView), -1);
    rb_define_method(cFXGLViewer.klass, "getFieldOfView", VALUEFUNC(_wrap_FXGLViewer_getFieldOfView), -1);
    rb_define_method(cFXGLViewer.klass, "setZoom", VALUEFUNC(_wrap_FXGLViewer_setZoom), -1);
    rb_define_method(cFXGLViewer.klass, "getZoom", VALUEFUNC(_wrap_FXGLViewer_getZoom), -1);
    rb_define_method(cFXGLViewer.klass, "setDistance", VALUEFUNC(_wrap_FXGLViewer_setDistance), -1);
    rb_define_method(cFXGLViewer.klass, "getDistance", VALUEFUNC(_wrap_FXGLViewer_getDistance), -1);
    rb_define_method(cFXGLViewer.klass, "setScale", VALUEFUNC(_wrap_FXGLViewer_setScale), -1);
    rb_define_method(cFXGLViewer.klass, "getScale", VALUEFUNC(_wrap_FXGLViewer_getScale), -1);
    rb_define_method(cFXGLViewer.klass, "setOrientation", VALUEFUNC(_wrap_FXGLViewer_setOrientation), -1);
    rb_define_method(cFXGLViewer.klass, "getOrientation", VALUEFUNC(_wrap_FXGLViewer_getOrientation), -1);
    rb_define_method(cFXGLViewer.klass, "setCenter", VALUEFUNC(_wrap_FXGLViewer_setCenter), -1);
    rb_define_method(cFXGLViewer.klass, "getCenter", VALUEFUNC(_wrap_FXGLViewer_getCenter), -1);
    rb_define_method(cFXGLViewer.klass, "translate", VALUEFUNC(_wrap_FXGLViewer_translate), -1);
    rb_define_method(cFXGLViewer.klass, "getBoreVector", VALUEFUNC(_wrap_FXGLViewer_getBoreVector), -1);
    rb_define_method(cFXGLViewer.klass, "getEyeVector", VALUEFUNC(_wrap_FXGLViewer_getEyeVector), -1);
    rb_define_method(cFXGLViewer.klass, "getEyePosition", VALUEFUNC(_wrap_FXGLViewer_getEyePosition), -1);
    rb_define_method(cFXGLViewer.klass, "setHelpText", VALUEFUNC(_wrap_FXGLViewer_setHelpText), -1);
    rb_define_method(cFXGLViewer.klass, "getHelpText", VALUEFUNC(_wrap_FXGLViewer_getHelpText), -1);
    rb_define_method(cFXGLViewer.klass, "setTipText", VALUEFUNC(_wrap_FXGLViewer_setTipText), -1);
    rb_define_method(cFXGLViewer.klass, "getTipText", VALUEFUNC(_wrap_FXGLViewer_getTipText), -1);
    rb_define_method(cFXGLViewer.klass, "getTransform", VALUEFUNC(_wrap_FXGLViewer_getTransform), -1);
    rb_define_method(cFXGLViewer.klass, "getInvTransform", VALUEFUNC(_wrap_FXGLViewer_getInvTransform), -1);
    rb_define_method(cFXGLViewer.klass, "setScene", VALUEFUNC(_wrap_FXGLViewer_setScene), -1);
    rb_define_method(cFXGLViewer.klass, "getScene", VALUEFUNC(_wrap_FXGLViewer_getScene), -1);
    rb_define_method(cFXGLViewer.klass, "setSelection", VALUEFUNC(_wrap_FXGLViewer_setSelection), -1);
    rb_define_method(cFXGLViewer.klass, "getSelection", VALUEFUNC(_wrap_FXGLViewer_getSelection), -1);
    rb_define_method(cFXGLViewer.klass, "setProjection", VALUEFUNC(_wrap_FXGLViewer_setProjection), -1);
    rb_define_method(cFXGLViewer.klass, "getProjection", VALUEFUNC(_wrap_FXGLViewer_getProjection), -1);
    rb_define_method(cFXGLViewer.klass, "setBackgroundColor", VALUEFUNC(_wrap_FXGLViewer_setBackgroundColor), -1);
    rb_define_method(cFXGLViewer.klass, "getBackgroundColor", VALUEFUNC(_wrap_FXGLViewer_getBackgroundColor), -1);
    rb_define_method(cFXGLViewer.klass, "setAmbientColor", VALUEFUNC(_wrap_FXGLViewer_setAmbientColor), -1);
    rb_define_method(cFXGLViewer.klass, "getAmbientColor", VALUEFUNC(_wrap_FXGLViewer_getAmbientColor), -1);
    rb_define_method(cFXGLViewer.klass, "readPixels", VALUEFUNC(_wrap_FXGLViewer_readPixels), -1);
    rb_define_method(cFXGLViewer.klass, "readFeedback", VALUEFUNC(_wrap_FXGLViewer_readFeedback), -1);
    rb_define_method(cFXGLViewer.klass, "setZSortFunc", VALUEFUNC(_wrap_FXGLViewer_setZSortFunc), -1);
    rb_define_method(cFXGLViewer.klass, "getZSortFunc", VALUEFUNC(_wrap_FXGLViewer_getZSortFunc), -1);
    rb_define_method(cFXGLViewer.klass, "setMaxHits", VALUEFUNC(_wrap_FXGLViewer_setMaxHits), -1);
    rb_define_method(cFXGLViewer.klass, "getMaxHits", VALUEFUNC(_wrap_FXGLViewer_getMaxHits), -1);
    rb_define_method(cFXGLViewer.klass, "doesTurbo", VALUEFUNC(_wrap_FXGLViewer_doesTurbo), -1);
    rb_define_method(cFXGLViewer.klass, "getTurboMode", VALUEFUNC(_wrap_FXGLViewer_getTurboMode), -1);
    rb_define_method(cFXGLViewer.klass, "setTurboMode", VALUEFUNC(_wrap_FXGLViewer_setTurboMode), -1);
    rb_define_method(cFXGLViewer.klass, "getLight", VALUEFUNC(_wrap_FXGLViewer_getLight), -1);
    rb_define_method(cFXGLViewer.klass, "setLight", VALUEFUNC(_wrap_FXGLViewer_setLight), -1);
    rb_define_method(cFXGLViewer.klass, "save", VALUEFUNC(_wrap_FXGLViewer_save), -1);
    rb_define_method(cFXGLViewer.klass, "load", VALUEFUNC(_wrap_FXGLViewer_load), -1);
    rb_define_method(cFXGLViewer.klass, "create", VALUEFUNC(_wrap_FXGLViewer_create), -1);
    rb_define_method(cFXGLViewer.klass, "detach", VALUEFUNC(_wrap_FXGLViewer_detach), -1);
    rb_define_method(cFXGLViewer.klass, "destroy", VALUEFUNC(_wrap_FXGLViewer_destroy), -1);
    rb_define_method(cFXGLViewer.klass, "resize", VALUEFUNC(_wrap_FXGLViewer_resize), -1);
    rb_define_method(cFXGLViewer.klass, "getDefaultWidth", VALUEFUNC(_wrap_FXGLViewer_getDefaultWidth), -1);
    rb_define_method(cFXGLViewer.klass, "getDefaultHeight", VALUEFUNC(_wrap_FXGLViewer_getDefaultHeight), -1);
    rb_define_method(cFXGLViewer.klass, "getWidthForHeight", VALUEFUNC(_wrap_FXGLViewer_getWidthForHeight), -1);
    rb_define_method(cFXGLViewer.klass, "getHeightForWidth", VALUEFUNC(_wrap_FXGLViewer_getHeightForWidth), -1);
    rb_define_method(cFXGLViewer.klass, "canFocus", VALUEFUNC(_wrap_FXGLViewer_canFocus), -1);
    rb_define_method(cFXGLViewer.klass, "setFocus", VALUEFUNC(_wrap_FXGLViewer_setFocus), -1);
    rb_define_method(cFXGLViewer.klass, "killFocus", VALUEFUNC(_wrap_FXGLViewer_killFocus), -1);
    rb_define_method(cFXGLViewer.klass, "setDefault", VALUEFUNC(_wrap_FXGLViewer_setDefault), -1);
    rb_define_method(cFXGLViewer.klass, "enable", VALUEFUNC(_wrap_FXGLViewer_enable), -1);
    rb_define_method(cFXGLViewer.klass, "disable", VALUEFUNC(_wrap_FXGLViewer_disable), -1);
    rb_define_method(cFXGLViewer.klass, "raiseWindow", VALUEFUNC(_wrap_FXGLViewer_raiseWindow), -1);
    rb_define_method(cFXGLViewer.klass, "lower", VALUEFUNC(_wrap_FXGLViewer_lower), -1);
    rb_define_method(cFXGLViewer.klass, "move", VALUEFUNC(_wrap_FXGLViewer_move), -1);
    rb_define_method(cFXGLViewer.klass, "position", VALUEFUNC(_wrap_FXGLViewer_position), -1);
    rb_define_method(cFXGLViewer.klass, "layout", VALUEFUNC(_wrap_FXGLViewer_layout), -1);
    rb_define_method(cFXGLViewer.klass, "recalc", VALUEFUNC(_wrap_FXGLViewer_recalc), -1);
    rb_define_method(cFXGLViewer.klass, "reparent", VALUEFUNC(_wrap_FXGLViewer_reparent), -1);
    rb_define_method(cFXGLViewer.klass, "show", VALUEFUNC(_wrap_FXGLViewer_show), -1);
    rb_define_method(cFXGLViewer.klass, "hide", VALUEFUNC(_wrap_FXGLViewer_hide), -1);
    rb_define_method(cFXGLViewer.klass, "isComposite", VALUEFUNC(_wrap_FXGLViewer_isComposite), -1);
    rb_define_method(cFXGLViewer.klass, "contains", VALUEFUNC(_wrap_FXGLViewer_contains), -1);
    rb_define_method(cFXGLViewer.klass, "doesSaveUnder", VALUEFUNC(_wrap_FXGLViewer_doesSaveUnder), -1);
    rb_define_method(cFXGLViewer.klass, "setBackColor", VALUEFUNC(_wrap_FXGLViewer_setBackColor), -1);
    rb_define_method(cFXGLViewer.klass, "makeCurrent", VALUEFUNC(_wrap_FXGLViewer_makeCurrent), -1);
    rb_define_method(cFXGLViewer.klass, "makeNonCurrent", VALUEFUNC(_wrap_FXGLViewer_makeNonCurrent), -1);
    rb_define_method(cFXGLViewer.klass, "isCurrent", VALUEFUNC(_wrap_FXGLViewer_isCurrent), -1);
    rb_define_method(cFXGLViewer.klass, "swapBuffers", VALUEFUNC(_wrap_FXGLViewer_swapBuffers), -1);
    rb_define_method(cFXGLViewer.klass, "select", VALUEFUNC(_wrap_FXGLViewer_select), -1);
    rb_define_method(cFXGLViewer.klass, "pick", VALUEFUNC(_wrap_FXGLViewer_pick), -1);
    cFXGLViewer.mark = (void (*)(void *)) FXRbGLViewer::markfunc;
    cFXGLViewer.destroy = (void (*)(void *)) FXRbObject::freefunc;
    
    cFXGLObject.klass = rb_define_class_under(mFox, "FXGLObject", ((swig_class *) SWIGTYPE_p_FXObject->clientdata)->klass);
    SWIG_TypeClientData(SWIGTYPE_p_FXGLObject, (void *) &cFXGLObject);
    rb_define_alloc_func(cFXGLObject.klass, _wrap_FXGLObject_allocate);
    rb_define_method(cFXGLObject.klass, "initialize", VALUEFUNC(_wrap_new_FXGLObject), -1);
    rb_define_const(cFXGLObject.klass,"ID_LAST", INT2NUM(FXGLObject::ID_LAST));
    rb_define_method(cFXGLObject.klass, "identify", VALUEFUNC(_wrap_FXGLObject_identify), -1);
    rb_define_method(cFXGLObject.klass, "save", VALUEFUNC(_wrap_FXGLObject_save), -1);
    rb_define_method(cFXGLObject.klass, "load", VALUEFUNC(_wrap_FXGLObject_load), -1);
    rb_define_method(cFXGLObject.klass, "copy", VALUEFUNC(_wrap_FXGLObject_copy), -1);
    rb_define_method(cFXGLObject.klass, "bounds", VALUEFUNC(_wrap_FXGLObject_bounds), -1);
    rb_define_method(cFXGLObject.klass, "draw", VALUEFUNC(_wrap_FXGLObject_draw), -1);
    rb_define_method(cFXGLObject.klass, "hit", VALUEFUNC(_wrap_FXGLObject_hit), -1);
    rb_define_method(cFXGLObject.klass, "canDrag", VALUEFUNC(_wrap_FXGLObject_canDrag), -1);
    rb_define_method(cFXGLObject.klass, "canDelete", VALUEFUNC(_wrap_FXGLObject_canDelete), -1);
    rb_define_method(cFXGLObject.klass, "drag", VALUEFUNC(_wrap_FXGLObject_drag), -1);
    cFXGLObject.mark = (void (*)(void *)) FXRbGLObject::markfunc;
    cFXGLObject.destroy = (void (*)(void *)) FXRbObject::freefunc;
    
    SWIGTYPE_p_FXGLObject->dcast = (swig_dycast_func) FXGLObject_dynamic_cast;
    
    rb_define_const(mFox,"SURFACE_SINGLESIDED", INT2NUM(SURFACE_SINGLESIDED));
    rb_define_const(mFox,"SURFACE_DUALSIDED", INT2NUM(SURFACE_DUALSIDED));
    rb_define_const(mFox,"SHADING_NONE", INT2NUM(SHADING_NONE));
    rb_define_const(mFox,"SHADING_SMOOTH", INT2NUM(SHADING_SMOOTH));
    rb_define_const(mFox,"SHADING_FLAT", INT2NUM(SHADING_FLAT));
    rb_define_const(mFox,"FACECULLING_OFF", INT2NUM(FACECULLING_OFF));
    rb_define_const(mFox,"FACECULLING_ON", INT2NUM(FACECULLING_ON));
    rb_define_const(mFox,"STYLE_SURFACE", INT2NUM(STYLE_SURFACE));
    rb_define_const(mFox,"STYLE_WIREFRAME", INT2NUM(STYLE_WIREFRAME));
    rb_define_const(mFox,"STYLE_POINTS", INT2NUM(STYLE_POINTS));
    rb_define_const(mFox,"STYLE_BOUNDBOX", INT2NUM(STYLE_BOUNDBOX));
    
    cFXGLShape.klass = rb_define_class_under(mFox, "FXGLShape", ((swig_class *) SWIGTYPE_p_FXGLObject->clientdata)->klass);
    SWIG_TypeClientData(SWIGTYPE_p_FXGLShape, (void *) &cFXGLShape);
    rb_define_alloc_func(cFXGLShape.klass, _wrap_FXGLShape_allocate);
    rb_define_method(cFXGLShape.klass, "initialize", VALUEFUNC(_wrap_new_FXGLShape), -1);
    rb_define_method(cFXGLShape.klass, "onDNDDrop", VALUEFUNC(_wrap_FXGLShape_onDNDDrop), -1);
    rb_define_method(cFXGLShape.klass, "onDNDMotion", VALUEFUNC(_wrap_FXGLShape_onDNDMotion), -1);
    rb_define_method(cFXGLShape.klass, "onQueryTip", VALUEFUNC(_wrap_FXGLShape_onQueryTip), -1);
    rb_define_method(cFXGLShape.klass, "onCmdShadeOff", VALUEFUNC(_wrap_FXGLShape_onCmdShadeOff), -1);
    rb_define_method(cFXGLShape.klass, "onUpdShadeOff", VALUEFUNC(_wrap_FXGLShape_onUpdShadeOff), -1);
    rb_define_method(cFXGLShape.klass, "onCmdShadeOn", VALUEFUNC(_wrap_FXGLShape_onCmdShadeOn), -1);
    rb_define_method(cFXGLShape.klass, "onUpdShadeOn", VALUEFUNC(_wrap_FXGLShape_onUpdShadeOn), -1);
    rb_define_method(cFXGLShape.klass, "onCmdShadeSmooth", VALUEFUNC(_wrap_FXGLShape_onCmdShadeSmooth), -1);
    rb_define_method(cFXGLShape.klass, "onUpdShadeSmooth", VALUEFUNC(_wrap_FXGLShape_onUpdShadeSmooth), -1);
    rb_define_method(cFXGLShape.klass, "onCmdFrontMaterial", VALUEFUNC(_wrap_FXGLShape_onCmdFrontMaterial), -1);
    rb_define_method(cFXGLShape.klass, "onUpdFrontMaterial", VALUEFUNC(_wrap_FXGLShape_onUpdFrontMaterial), -1);
    rb_define_method(cFXGLShape.klass, "onCmdBackMaterial", VALUEFUNC(_wrap_FXGLShape_onCmdBackMaterial), -1);
    rb_define_method(cFXGLShape.klass, "onUpdBackMaterial", VALUEFUNC(_wrap_FXGLShape_onUpdBackMaterial), -1);
    rb_define_method(cFXGLShape.klass, "onCmdDrawingStyle", VALUEFUNC(_wrap_FXGLShape_onCmdDrawingStyle), -1);
    rb_define_method(cFXGLShape.klass, "onUpdDrawingStyle", VALUEFUNC(_wrap_FXGLShape_onUpdDrawingStyle), -1);
    rb_define_const(cFXGLShape.klass,"ID_SHADEOFF", INT2NUM(FXGLShape::ID_SHADEOFF));
    rb_define_const(cFXGLShape.klass,"ID_SHADEON", INT2NUM(FXGLShape::ID_SHADEON));
    rb_define_const(cFXGLShape.klass,"ID_SHADESMOOTH", INT2NUM(FXGLShape::ID_SHADESMOOTH));
    rb_define_const(cFXGLShape.klass,"ID_TOGGLE_SIDED", INT2NUM(FXGLShape::ID_TOGGLE_SIDED));
    rb_define_const(cFXGLShape.klass,"ID_TOGGLE_CULLING", INT2NUM(FXGLShape::ID_TOGGLE_CULLING));
    rb_define_const(cFXGLShape.klass,"ID_STYLE_POINTS", INT2NUM(FXGLShape::ID_STYLE_POINTS));
    rb_define_const(cFXGLShape.klass,"ID_STYLE_WIREFRAME", INT2NUM(FXGLShape::ID_STYLE_WIREFRAME));
    rb_define_const(cFXGLShape.klass,"ID_STYLE_SURFACE", INT2NUM(FXGLShape::ID_STYLE_SURFACE));
    rb_define_const(cFXGLShape.klass,"ID_STYLE_BOUNDINGBOX", INT2NUM(FXGLShape::ID_STYLE_BOUNDINGBOX));
    rb_define_const(cFXGLShape.klass,"ID_FRONT_MATERIAL", INT2NUM(FXGLShape::ID_FRONT_MATERIAL));
    rb_define_const(cFXGLShape.klass,"ID_BACK_MATERIAL", INT2NUM(FXGLShape::ID_BACK_MATERIAL));
    rb_define_const(cFXGLShape.klass,"ID_LAST", INT2NUM(FXGLShape::ID_LAST));
    rb_define_method(cFXGLShape.klass, "identify", VALUEFUNC(_wrap_FXGLShape_identify), -1);
    rb_define_method(cFXGLShape.klass, "setTipText", VALUEFUNC(_wrap_FXGLShape_setTipText), -1);
    rb_define_method(cFXGLShape.klass, "getTipText", VALUEFUNC(_wrap_FXGLShape_getTipText), -1);
    rb_define_method(cFXGLShape.klass, "setMaterial", VALUEFUNC(_wrap_FXGLShape_setMaterial), -1);
    rb_define_method(cFXGLShape.klass, "getPosition", VALUEFUNC(_wrap_FXGLShape_getPosition), -1);
    rb_define_method(cFXGLShape.klass, "setPosition", VALUEFUNC(_wrap_FXGLShape_setPosition), -1);
    rb_define_method(cFXGLShape.klass, "getMaterial", VALUEFUNC(_wrap_FXGLShape_getMaterial), -1);
    rb_define_method(cFXGLShape.klass, "setRange", VALUEFUNC(_wrap_FXGLShape_setRange), -1);
    rb_define_method(cFXGLShape.klass, "save", VALUEFUNC(_wrap_FXGLShape_save), -1);
    rb_define_method(cFXGLShape.klass, "load", VALUEFUNC(_wrap_FXGLShape_load), -1);
    rb_define_method(cFXGLShape.klass, "copy", VALUEFUNC(_wrap_FXGLShape_copy), -1);
    rb_define_method(cFXGLShape.klass, "bounds", VALUEFUNC(_wrap_FXGLShape_bounds), -1);
    rb_define_method(cFXGLShape.klass, "draw", VALUEFUNC(_wrap_FXGLShape_draw), -1);
    rb_define_method(cFXGLShape.klass, "hit", VALUEFUNC(_wrap_FXGLShape_hit), -1);
    rb_define_method(cFXGLShape.klass, "canDrag", VALUEFUNC(_wrap_FXGLShape_canDrag), -1);
    rb_define_method(cFXGLShape.klass, "canDelete", VALUEFUNC(_wrap_FXGLShape_canDelete), -1);
    rb_define_method(cFXGLShape.klass, "drag", VALUEFUNC(_wrap_FXGLShape_drag), -1);
    rb_define_method(cFXGLShape.klass, "drawshape", VALUEFUNC(_wrap_FXGLShape_drawshape), -1);
    cFXGLShape.mark = (void (*)(void *)) FXRbGLShape::markfunc;
    cFXGLShape.destroy = (void (*)(void *)) FXRbObject::freefunc;
}

