/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 1.3.22
 * 
 * This file is not intended to be easily readable and contains a number of 
 * coding conventions designed to improve portability and efficiency. Do not make
 * changes to this file unless you know what you are doing--modify the SWIG 
 * interface file instead. 
 * ----------------------------------------------------------------------------- */

#define SWIG_NOINCLUDE

#ifdef __cplusplus
template<class T> class SwigValueWrapper {
    T *tt;
public:
    SwigValueWrapper() : tt(0) { }
    SwigValueWrapper(const SwigValueWrapper<T>& rhs) : tt(new T(*rhs.tt)) { }
    SwigValueWrapper(const T& t) : tt(new T(t)) { }
    ~SwigValueWrapper() { delete tt; } 
    SwigValueWrapper& operator=(const T& t) { delete tt; tt = new T(t); return *this; }
    operator T&() const { return *tt; }
    T *operator&() { return tt; }
private:
    SwigValueWrapper& operator=(const SwigValueWrapper<T>& rhs);
};                                                    
#endif

/* ruby.swg */
/* Implementation : RUBY */
#define SWIGRUBY 1

#include "ruby.h"

/* Flags for pointer conversion */
#define SWIG_POINTER_EXCEPTION     0x1
#define SWIG_POINTER_DISOWN        0x2

#define NUM2USHRT(n) (\
    (0 <= NUM2UINT(n) && NUM2UINT(n) <= USHRT_MAX)\
    ? (unsigned short) NUM2UINT(n) \
    : (rb_raise(rb_eArgError, "integer %d out of range of `unsigned short'",\
               NUM2UINT(n)), (short)0)\
)

#define NUM2SHRT(n) (\
    (SHRT_MIN <= NUM2INT(n) && NUM2INT(n) <= SHRT_MAX)\
    ? (short)NUM2INT(n)\
    : (rb_raise(rb_eArgError, "integer %d out of range of `short'",\
               NUM2INT(n)), (short)0)\
)

/* Ruby 1.7 defines NUM2LL(), LL2NUM() and ULL2NUM() macros */
#ifndef NUM2LL
#define NUM2LL(x) NUM2LONG((x))
#endif
#ifndef LL2NUM
#define LL2NUM(x) INT2NUM((long) (x))
#endif
#ifndef ULL2NUM
#define ULL2NUM(x) UINT2NUM((unsigned long) (x))
#endif

/* Ruby 1.7 doesn't (yet) define NUM2ULL() */
#ifndef NUM2ULL
#ifdef HAVE_LONG_LONG
#define NUM2ULL(x) rb_num2ull((x))
#else
#define NUM2ULL(x) NUM2ULONG(x)
#endif
#endif

/*
 * Need to be very careful about how these macros are defined, especially
 * when compiling C++ code or C code with an ANSI C compiler.
 *
 * VALUEFUNC(f) is a macro used to typecast a C function that implements
 * a Ruby method so that it can be passed as an argument to API functions
 * like rb_define_method() and rb_define_singleton_method().
 *
 * VOIDFUNC(f) is a macro used to typecast a C function that implements
 * either the "mark" or "free" stuff for a Ruby Data object, so that it
 * can be passed as an argument to API functions like Data_Wrap_Struct()
 * and Data_Make_Struct().
 */
 
#ifdef __cplusplus
#  ifndef RUBY_METHOD_FUNC /* These definitions should work for Ruby 1.4.6 */
#    define PROTECTFUNC(f) ((VALUE (*)()) f)
#    define VALUEFUNC(f) ((VALUE (*)()) f)
#    define VOIDFUNC(f)  ((void (*)()) f)
#  else
#    ifndef ANYARGS /* These definitions should work for Ruby 1.6 */
#      define PROTECTFUNC(f) ((VALUE (*)()) f)
#      define VALUEFUNC(f) ((VALUE (*)()) f)
#      define VOIDFUNC(f)  ((RUBY_DATA_FUNC) f)
#    else /* These definitions should work for Ruby 1.7+ */
#      define PROTECTFUNC(f) ((VALUE (*)(VALUE)) f)
#      define VALUEFUNC(f) ((VALUE (*)(ANYARGS)) f)
#      define VOIDFUNC(f)  ((RUBY_DATA_FUNC) f)
#    endif
#  endif
#else
#  define VALUEFUNC(f) (f)
#  define VOIDFUNC(f) (f)
#endif

typedef struct {
  VALUE klass;
  VALUE mImpl;
  void  (*mark)(void *);
  void  (*destroy)(void *);
} swig_class;

/* Don't use for expressions have side effect */
#ifndef RB_STRING_VALUE
#define RB_STRING_VALUE(s) (TYPE(s) == T_STRING ? (s) : (*(volatile VALUE *)&(s) = rb_str_to_str(s)))
#endif
#ifndef StringValue
#define StringValue(s) RB_STRING_VALUE(s)
#endif
#ifndef StringValuePtr
#define StringValuePtr(s) RSTRING(RB_STRING_VALUE(s))->ptr
#endif
#ifndef StringValueLen
#define StringValueLen(s) RSTRING(RB_STRING_VALUE(s))->len
#endif
#ifndef SafeStringValue
#define SafeStringValue(v) do {\
    StringValue(v);\
    rb_check_safe_str(v);\
} while (0)
#endif

#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
#define rb_define_alloc_func(klass, func) rb_define_singleton_method((klass), "new", VALUEFUNC((func)), -1)
#define rb_undef_alloc_func(klass) rb_undef_method(CLASS_OF((klass)), "new")
#endif

/* Contract support */

#define SWIG_contract_assert(expr, msg) if (!(expr)) { rb_raise(rb_eRuntimeError, (char *) msg ); } else


/*************************************************************** -*- c -*-
 * ruby/precommon.swg
 *
 * Rename all exported symbols from common.swg, to avoid symbol
 * clashes if multiple interpreters are included
 *
 ************************************************************************/

#define SWIG_TypeRegister    SWIG_Ruby_TypeRegister
#define SWIG_TypeCheck       SWIG_Ruby_TypeCheck
#define SWIG_TypeCast        SWIG_Ruby_TypeCast
#define SWIG_TypeDynamicCast SWIG_Ruby_TypeDynamicCast
#define SWIG_TypeName        SWIG_Ruby_TypeName
#define SWIG_TypePrettyName  SWIG_Ruby_TypePrettyName
#define SWIG_TypeQuery       SWIG_Ruby_TypeQuery
#define SWIG_TypeClientData  SWIG_Ruby_TypeClientData
#define SWIG_PackData        SWIG_Ruby_PackData 
#define SWIG_UnpackData      SWIG_Ruby_UnpackData 

/* Also rename all exported symbols from rubydef.swig */

/* Common SWIG API */
#define SWIG_ConvertPtr(obj, pp, type, flags) \
  SWIG_Ruby_ConvertPtr(obj, pp, type, flags)
#define SWIG_NewPointerObj(p, type, flags) \
  SWIG_Ruby_NewPointerObj(p, type, flags)
#define SWIG_MustGetPtr(p, type, argnum, flags) \
  SWIG_Ruby_MustGetPtr(p, type, argnum, flags)

/* Ruby-specific SWIG API */

#define SWIG_InitRuntime() \
  SWIG_Ruby_InitRuntime()
#define SWIG_define_class(ty) \
  SWIG_Ruby_define_class(ty)
#define SWIG_NewClassInstance(value, ty) \
  SWIG_Ruby_NewClassInstance(value, ty)
#define SWIG_MangleStr(value) \
  SWIG_Ruby_MangleStr(value)
#define SWIG_CheckConvert(value, ty) \
  SWIG_Ruby_CheckConvert(value, ty)
#define SWIG_NewPackedObj(ptr, sz, ty) \
  SWIG_Ruby_NewPackedObj(ptr, sz, ty)
#define SWIG_ConvertPacked(obj, ptr, sz, ty, flags) \
  SWIG_Ruby_ConvertPacked(obj, ptr, sz, ty, flags)


/***********************************************************************
 * common.swg
 *
 *     This file contains generic SWIG runtime support for pointer
 *     type checking as well as a few commonly used macros to control
 *     external linkage.
 *
 * Author : David Beazley (beazley@cs.uchicago.edu)
 *
 * Copyright (c) 1999-2000, The University of Chicago
 * 
 * This file may be freely redistributed without license or fee provided
 * this copyright message remains intact.
 ************************************************************************/

#include <string.h>

#if defined(_WIN32) || defined(__WIN32__) || defined(__CYGWIN__)
#  if defined(_MSC_VER) || defined(__GNUC__)
#    if defined(STATIC_LINKED)
#      define SWIGEXPORT(a) a
#      define SWIGIMPORT(a) extern a
#    else
#      define SWIGEXPORT(a) __declspec(dllexport) a
#      define SWIGIMPORT(a) extern a
#    endif
#  else
#    if defined(__BORLANDC__)
#      define SWIGEXPORT(a) a _export
#      define SWIGIMPORT(a) a _export
#    else
#      define SWIGEXPORT(a) a
#      define SWIGIMPORT(a) a
#    endif
#  endif
#else
#  define SWIGEXPORT(a) a
#  define SWIGIMPORT(a) a
#endif

#ifdef SWIG_GLOBAL
#  define SWIGRUNTIME(a) SWIGEXPORT(a)
#else
#  define SWIGRUNTIME(a) static a
#endif

#ifdef __cplusplus
extern "C" {
#endif

typedef void *(*swig_converter_func)(void *);
typedef struct swig_type_info *(*swig_dycast_func)(void **);

typedef struct swig_type_info {
  const char             *name;
  swig_converter_func     converter;
  const char             *str;
  void                   *clientdata;
  swig_dycast_func        dcast;
  struct swig_type_info  *next;
  struct swig_type_info  *prev;
} swig_type_info;

#ifdef SWIG_NOINCLUDE

SWIGIMPORT(swig_type_info *) SWIG_TypeRegister(swig_type_info *);
SWIGIMPORT(swig_type_info *) SWIG_TypeCheck(char *c, swig_type_info *);
SWIGIMPORT(void *)           SWIG_TypeCast(swig_type_info *, void *);
SWIGIMPORT(swig_type_info *) SWIG_TypeDynamicCast(swig_type_info *, void **);
SWIGIMPORT(const char *)     SWIG_TypeName(const swig_type_info *);
SWIGIMPORT(const char *)     SWIG_TypePrettyName(const swig_type_info *);
SWIGIMPORT(swig_type_info *) SWIG_TypeQuery(const char *);
SWIGIMPORT(void)             SWIG_TypeClientData(swig_type_info *, void *);
SWIGIMPORT(char *)           SWIG_PackData(char *, void *, int);
SWIGIMPORT(char *)           SWIG_UnpackData(char *, void *, int);

#else

static swig_type_info *swig_type_list = 0;
static swig_type_info **swig_type_list_handle = &swig_type_list;

/* Register a type mapping with the type-checking */
SWIGRUNTIME(swig_type_info *)
SWIG_TypeRegister(swig_type_info *ti) {
  swig_type_info *tc, *head, *ret, *next;
  /* Check to see if this type has already been registered */
  tc = *swig_type_list_handle;
  while (tc) {
    if (strcmp(tc->name, ti->name) == 0) {
      /* Already exists in the table.  Just add additional types to the list */
      if (tc->clientdata) ti->clientdata = tc->clientdata;
      head = tc;
      next = tc->next;
      goto l1;
    }
    tc = tc->prev;
  }
  head = ti;
  next = 0;

  /* Place in list */
  ti->prev = *swig_type_list_handle;
  *swig_type_list_handle = ti;

  /* Build linked lists */
  l1:
  ret = head;
  tc = ti + 1;
  /* Patch up the rest of the links */
  while (tc->name) {
    head->next = tc;
    tc->prev = head;
    head = tc;
    tc++;
  }
  if (next) next->prev = head;
  head->next = next;
  return ret;
}

/* Check the typename */
SWIGRUNTIME(swig_type_info *) 
SWIG_TypeCheck(char *c, swig_type_info *ty) {
  swig_type_info *s;
  if (!ty) return 0;        /* Void pointer */
  s = ty->next;             /* First element always just a name */
  do {
    if (strcmp(s->name,c) == 0) {
      if (s == ty->next) return s;
      /* Move s to the top of the linked list */
      s->prev->next = s->next;
      if (s->next) {
        s->next->prev = s->prev;
      }
      /* Insert s as second element in the list */
      s->next = ty->next;
      if (ty->next) ty->next->prev = s;
      ty->next = s;
      s->prev = ty;
      return s;
    }
    s = s->next;
  } while (s && (s != ty->next));
  return 0;
}

/* Cast a pointer up an inheritance hierarchy */
SWIGRUNTIME(void *) 
SWIG_TypeCast(swig_type_info *ty, void *ptr) {
  if ((!ty) || (!ty->converter)) return ptr;
  return (*ty->converter)(ptr);
}

/* Dynamic pointer casting. Down an inheritance hierarchy */
SWIGRUNTIME(swig_type_info *) 
SWIG_TypeDynamicCast(swig_type_info *ty, void **ptr) {
  swig_type_info *lastty = ty;
  if (!ty || !ty->dcast) return ty;
  while (ty && (ty->dcast)) {
    ty = (*ty->dcast)(ptr);
    if (ty) lastty = ty;
  }
  return lastty;
}

/* Return the name associated with this type */
SWIGRUNTIME(const char *)
SWIG_TypeName(const swig_type_info *ty) {
  return ty->name;
}

/* Return the pretty name associated with this type,
   that is an unmangled type name in a form presentable to the user.
*/
SWIGRUNTIME(const char *)
SWIG_TypePrettyName(const swig_type_info *type) {
  /* The "str" field contains the equivalent pretty names of the
     type, separated by vertical-bar characters.  We choose
     to print the last name, as it is often (?) the most
     specific. */
  if (type->str != NULL) {
    const char *last_name = type->str;
    const char *s;
    for (s = type->str; *s; s++)
      if (*s == '|') last_name = s+1;
    return last_name;
  }
  else
    return type->name;
}

/* 
   Compare two type names skipping the space characters, therefore
   "char*" == "char *" and "Class<int>" == "Class<int >", etc.

   Return 0 when the two name types are equivalent, as in
   strncmp, but skipping ' '.
*/
static int
SWIG_TypeNameComp(const char *f1, const char *l1,
		  const char *f2, const char *l2) {
  for (;(f1 != l1) && (f2 != l2); ++f1, ++f2) {
    while ((*f1 == ' ') && (f1 != l1)) ++f1;
    while ((*f2 == ' ') && (f2 != l2)) ++f2;
    if (*f1 != *f2) return *f1 - *f2;
  }
  return (l1 - f1) - (l2 - f2);
}

/*
  Check type equivalence in a name list like <name1>|<name2>|...
*/
static int
SWIG_TypeEquiv(const char *nb, const char *tb) {
  int equiv = 0;
  const char* te = tb + strlen(tb);
  const char* ne = nb;
  while (!equiv && *ne) {
    for (nb = ne; *ne; ++ne) {
      if (*ne == '|') break;
    }
    equiv = SWIG_TypeNameComp(nb, ne, tb, te) == 0;
    if (*ne) ++ne;
  }
  return equiv;
}
  

/* Search for a swig_type_info structure */
SWIGRUNTIME(swig_type_info *)
SWIG_TypeQuery(const char *name) {
  swig_type_info *ty = *swig_type_list_handle;
  while (ty) {
    if (ty->str && (SWIG_TypeEquiv(ty->str,name))) return ty;
    if (ty->name && (strcmp(name,ty->name) == 0)) return ty;
    ty = ty->prev;
  }
  return 0;
}

/* Set the clientdata field for a type */
SWIGRUNTIME(void)
SWIG_TypeClientData(swig_type_info *ti, void *clientdata) {
  swig_type_info *tc, *equiv;
  if (ti->clientdata == clientdata) return;
  ti->clientdata = clientdata;
  equiv = ti->next;
  while (equiv) {
    if (!equiv->converter) {
      tc = *swig_type_list_handle;
      while (tc) {
        if ((strcmp(tc->name, equiv->name) == 0))
          SWIG_TypeClientData(tc,clientdata);
        tc = tc->prev;
      }
    }
    equiv = equiv->next;
  }
}

/* Pack binary data into a string */
SWIGRUNTIME(char *)
SWIG_PackData(char *c, void *ptr, int sz) {
  static char hex[17] = "0123456789abcdef";
  unsigned char *u = (unsigned char *) ptr;
  const unsigned char *eu =  u + sz;
  register unsigned char uu;
  for (; u != eu; ++u) {
    uu = *u;
    *(c++) = hex[(uu & 0xf0) >> 4];
    *(c++) = hex[uu & 0xf];
  }
  return c;
}

/* Unpack binary data from a string */
SWIGRUNTIME(char *)
SWIG_UnpackData(char *c, void *ptr, int sz) {
  register unsigned char uu = 0;
  register int d;
  unsigned char *u = (unsigned char *) ptr;
  const unsigned char *eu =  u + sz;
  for (; u != eu; ++u) {
    d = *(c++);
    if ((d >= '0') && (d <= '9'))
      uu = ((d - '0') << 4);
    else if ((d >= 'a') && (d <= 'f'))
      uu = ((d - ('a'-10)) << 4);
    d = *(c++);
    if ((d >= '0') && (d <= '9'))
      uu |= (d - '0');
    else if ((d >= 'a') && (d <= 'f'))
      uu |= (d - ('a'-10));
    *u = uu;
  }
  return c;
}

#endif

#ifdef __cplusplus
}
#endif

/* rubydec.swg -*- c -*- */
#ifdef __cplusplus
extern "C" {
#endif

SWIGIMPORT(void)   SWIG_Ruby_InitRuntime(void);
SWIGIMPORT(void)   SWIG_Ruby_define_class(swig_type_info *);
SWIGIMPORT(VALUE)  SWIG_Ruby_NewPointerObj(void *, swig_type_info *, int);
SWIGIMPORT(VALUE)  SWIG_Ruby_NewClassInstance(VALUE, swig_type_info *);
SWIGIMPORT(char *) SWIG_Ruby_MangleStr(VALUE);
SWIGIMPORT(int)    SWIG_Ruby_ConvertPtr(VALUE, void**, swig_type_info *, int);
SWIGIMPORT(void *) SWIG_Ruby_MustGetPtr(VALUE, swig_type_info *, int, int);
SWIGIMPORT(int)    SWIG_Ruby_CheckConvert(VALUE, swig_type_info *);
SWIGIMPORT(VALUE)  SWIG_Ruby_NewPackedObj(void *ptr, int sz, swig_type_info *type);
SWIGIMPORT(void)   SWIG_Ruby_ConvertPacked(VALUE obj, void *ptr, int sz, swig_type_info *ty, int flags);

#ifdef __cplusplus
}
#endif


/* -------- TYPES TABLE (BEGIN) -------- */

#define  SWIGTYPE_p_FXGIFIcon swig_types[0] 
#define  SWIGTYPE_p_FXObject swig_types[1] 
#define  SWIGTYPE_p_FXJPGIcon swig_types[2] 
#define  SWIGTYPE_p_FXXBMIcon swig_types[3] 
#define  SWIGTYPE_p_FXuchar swig_types[4] 
#define  SWIGTYPE_p_FXBMPIcon swig_types[5] 
#define  SWIGTYPE_p_FXRGBIcon swig_types[6] 
#define  SWIGTYPE_p_FXTIFIcon swig_types[7] 
#define  SWIGTYPE_p_FXId swig_types[8] 
#define  SWIGTYPE_p_FXTGAIcon swig_types[9] 
#define  SWIGTYPE_p_p_FXchar swig_types[10] 
#define  SWIGTYPE_p_FXStream swig_types[11] 
#define  SWIGTYPE_p_FXDrawable swig_types[12] 
#define  SWIGTYPE_p_FXPCXIcon swig_types[13] 
#define  SWIGTYPE_p_FXIcon swig_types[14] 
#define  SWIGTYPE_p_FXColor swig_types[15] 
#define  SWIGTYPE_p_FXPPMIcon swig_types[16] 
#define  SWIGTYPE_p_FXXPMIcon swig_types[17] 
#define  SWIGTYPE_p_FXPNGIcon swig_types[18] 
#define  SWIGTYPE_p_FXICOIcon swig_types[19] 
#define  SWIGTYPE_p_FXApp swig_types[20] 
#define  SWIGTYPE_p_FXImage swig_types[21] 
static swig_type_info *swig_types[23];

/* -------- TYPES TABLE (END) -------- */

#define SWIG_init    Init_icons
#define SWIG_name    "Icons"


static void SWIG_AsVal(VALUE obj, int *val)
{
    *val = (int) NUM2INT(obj);
}


#include "FXRbCommon.h"


inline FXColor to_FXColor(VALUE obj){
  if(TYPE(obj)==T_STRING){
    return fxcolorfromname(StringValuePtr(obj));
    }
  else if(TYPE(obj)==T_SYMBOL){
    return fxcolorfromname(rb_id2name(SYM2ID(obj)));
    }
  else{
    return NUM2ULONG(obj);
    }
  }


inline FXString to_FXString(VALUE obj){
  if(!NIL_P(obj)){
    Check_Type(obj,T_STRING);
    return FXString(STR2CSTR(obj));
    }
  else{
    return FXString::null;
    }
  }


inline FXbool to_FXbool(VALUE obj){
  if (obj == Qtrue || obj == Qfalse){
    return (obj == Qtrue) ? TRUE : FALSE;
    }
  else{
    return static_cast<FXbool>(NUM2UINT(obj));
    }
  }


static swig_type_info* FXEventTypeInfo=0;

inline void* to_FXEvent(VALUE obj){
  void* ptr;
  if(!FXEventTypeInfo){
    FXEventTypeInfo=SWIG_TypeQuery("FXEvent *");
    FXASSERT(FXEventTypeInfo!=0);
    }
  SWIG_ConvertPtr(obj,&ptr,FXEventTypeInfo,1);
  return ptr;
  }

FXIcon *new_FXIcon(FXApp *a,FXColor const *PIXELS,FXColor clr,FXuint opts,FXint w,FXint h){
      return new FXRbIcon(a,PIXELS,clr,opts,w,h);
      }

swig_class cFXIcon;
static void free_FXIcon(FXIcon *);

static swig_type_info *FXIcon_dynamic_cast(void **ptr) {
    FXIcon **ppIcon = reinterpret_cast<FXIcon **>(ptr);
    FXBMPIcon *pBMPIcon=dynamic_cast<FXBMPIcon*>(*ppIcon);
    if(pBMPIcon){
      *ptr=reinterpret_cast<void*>(pBMPIcon);
      return SWIG_TypeQuery("FXBMPIcon *");
      }
    FXGIFIcon *pGIFIcon=dynamic_cast<FXGIFIcon*>(*ppIcon);
    if(pGIFIcon){
      *ptr=reinterpret_cast<void*>(pGIFIcon);
      return SWIG_TypeQuery("FXGIFIcon *");
      }
    FXICOIcon *pICOIcon=dynamic_cast<FXICOIcon*>(*ppIcon);
    if(pICOIcon){
      *ptr=reinterpret_cast<void*>(pICOIcon);
      return SWIG_TypeQuery("FXICOIcon *");
      }
    FXJPGIcon *pJPGIcon=dynamic_cast<FXJPGIcon*>(*ppIcon);
    if(pJPGIcon){
      *ptr=reinterpret_cast<void*>(pJPGIcon);
      return SWIG_TypeQuery("FXJPGIcon *");
      }
    FXPCXIcon *pPCXIcon=dynamic_cast<FXPCXIcon*>(*ppIcon);
    if(pPCXIcon){
      *ptr=reinterpret_cast<void*>(pPCXIcon);
      return SWIG_TypeQuery("FXPCXIcon *");
      }
    FXPNGIcon *pPNGIcon=dynamic_cast<FXPNGIcon*>(*ppIcon);
    if(pPNGIcon){
      *ptr=reinterpret_cast<void*>(pPNGIcon);
      return SWIG_TypeQuery("FXPNGIcon *");
      }
    FXPPMIcon *pPPMIcon=dynamic_cast<FXPPMIcon*>(*ppIcon);
    if(pPPMIcon){
      *ptr=reinterpret_cast<void*>(pPPMIcon);
      return SWIG_TypeQuery("FXPPMIcon *");
      }
    FXRGBIcon *pRGBIcon=dynamic_cast<FXRGBIcon*>(*ppIcon);
    if(pRGBIcon){
      *ptr=reinterpret_cast<void*>(pRGBIcon);
      return SWIG_TypeQuery("FXRGBIcon *");
      }
    FXTGAIcon *pTGAIcon=dynamic_cast<FXTGAIcon*>(*ppIcon);
    if(pTGAIcon){
      *ptr=reinterpret_cast<void*>(pTGAIcon);
      return SWIG_TypeQuery("FXTGAIcon *");
      }
    FXTIFIcon *pTIFIcon=dynamic_cast<FXTIFIcon*>(*ppIcon);
    if(pTIFIcon){
      *ptr=reinterpret_cast<void*>(pTIFIcon);
      return SWIG_TypeQuery("FXTIFIcon *");
      }
    FXXBMIcon *pXBMIcon=dynamic_cast<FXXBMIcon*>(*ppIcon);
    if(pXBMIcon){
      *ptr=reinterpret_cast<void*>(pXBMIcon);
      return SWIG_TypeQuery("FXXBMIcon *");
      }
    FXXPMIcon *pXPMIcon=dynamic_cast<FXXPMIcon*>(*ppIcon);
    if(pXPMIcon){
      *ptr=reinterpret_cast<void*>(pXPMIcon);
      return SWIG_TypeQuery("FXXPMIcon *");
      }
    return 0;
}

FXBMPIcon *new_FXBMPIcon(FXApp *a,void const *pix,FXColor clr,FXuint opts,FXint w,FXint h){
      return new FXRbBMPIcon(a,pix,clr,opts,w,h);
      }

swig_class cFXBMPIcon;
static void free_FXBMPIcon(FXBMPIcon *);

  /**
   * Load an BMP (Microsoft Bitmap) file from a stream.
   * Upon successful return, the pixel array and size are returned.
   * If an error occurred, the pixel array is set to NULL.
   */
  VALUE fxloadBMP(FXStream& store){
    FXColor* data;
    FXint width;
    FXint height;
    if(fxloadBMP(store,data,width,height)){
      VALUE ary=rb_ary_new();
      rb_ary_push(ary,FXRbMakeColorArray(data,width,height));
      FXFREE(&data);
      rb_ary_push(ary,to_ruby(width));
      rb_ary_push(ary,to_ruby(height));
      return ary;
      }
    else{
      return Qnil;
      }
    }

FXGIFIcon *new_FXGIFIcon(FXApp *a,void const *pix,FXColor clr,FXuint opts,FXint w,FXint h){
      return new FXRbGIFIcon(a,pix,clr,opts,w,h);
      }

swig_class cFXGIFIcon;
static void free_FXGIFIcon(FXGIFIcon *);
FXICOIcon *new_FXICOIcon(FXApp *a,void const *pix,FXColor clr,FXuint opts,FXint w,FXint h){
      return new FXRbICOIcon(a,pix,clr,opts,w,h);
      }

swig_class cFXICOIcon;
static void free_FXICOIcon(FXICOIcon *);

/**
 * Load an ICO (Microsoft icon format) file from a stream.
 * Upon successful return, the pixel array and size are returned.
 * If an error occurred, the pixel array is set to NULL.
 */
VALUE fxloadICO(FXStream& store){
  FXColor* data;
  FXint width;
  FXint height;
  FXint xspot;
  FXint yspot;
  if(fxloadICO(store,data,width,height,xspot,yspot)){
    VALUE ary=rb_ary_new();
    rb_ary_push(ary,FXRbMakeColorArray(data,width,height));
    FXFREE(&data);
    rb_ary_push(ary,to_ruby(width));
    rb_ary_push(ary,to_ruby(height));
    rb_ary_push(ary,to_ruby(xspot));
    rb_ary_push(ary,to_ruby(yspot));
    return ary;
    }
  else{
    return Qnil;
    }
  }

FXJPGIcon *new_FXJPGIcon(FXApp *a,void const *pix,FXColor clr,FXuint opts,FXint w,FXint h){
      return new FXRbJPGIcon(a,pix,clr,opts,w,h);
      }

swig_class cFXJPGIcon;
static void free_FXJPGIcon(FXJPGIcon *);
FXPCXIcon *new_FXPCXIcon(FXApp *a,void const *pix,FXColor clr,FXuint opts,FXint w,FXint h){
      return new FXRbPCXIcon(a,pix,clr,opts,w,h);
      }

swig_class cFXPCXIcon;
static void free_FXPCXIcon(FXPCXIcon *);

  /**
   * Load an PCX (PC Paintbrush) file from a stream.
   * Upon successful return, the pixel array and size are returned.
   * If an error occurred, the pixel array is set to NULL.
   */
  VALUE fxloadPCX(FXStream& store){
    FXColor* data;
    FXint width;
    FXint height;
    if(fxloadPCX(store,data,width,height)){
      VALUE ary=rb_ary_new();
      rb_ary_push(ary,FXRbMakeColorArray(data,width,height));
      FXFREE(&data);
      rb_ary_push(ary,to_ruby(width));
      rb_ary_push(ary,to_ruby(height));
      return ary;
      }
    else{
      return Qnil;
      }
    }

FXPNGIcon *new_FXPNGIcon(FXApp *a,void const *pix,FXColor clr,FXuint opts,FXint w,FXint h){
      return new FXRbPNGIcon(a,pix,clr,opts,w,h);
      }

swig_class cFXPNGIcon;
static void free_FXPNGIcon(FXPNGIcon *);

  /**
   * Load an PNG (Portable Network Graphics) file from a stream.
   * Upon successful return, the pixel array and size are returned.
   * If an error occurred, the pixel array is set to NULL.
   */
  VALUE fxloadPNG(FXStream& store){
    FXColor* data;
    FXint width;
    FXint height;
    if(fxloadPNG(store,data,width,height)){
      VALUE ary=rb_ary_new();
      rb_ary_push(ary,FXRbMakeColorArray(data,width,height));
      FXFREE(&data);
      rb_ary_push(ary,to_ruby(width));
      rb_ary_push(ary,to_ruby(height));
      return ary;
      }
    else{
      return Qnil;
      }
    }

FXPPMIcon *new_FXPPMIcon(FXApp *a,void const *pix,FXColor clr,FXuint opts,FXint w,FXint h){
      return new FXRbPPMIcon(a,pix,clr,opts,w,h);
      }

swig_class cFXPPMIcon;
static void free_FXPPMIcon(FXPPMIcon *);

  /**
   * Load an PPM (Portable Pixmap Format) file from a stream.
   * Upon successful return, the pixel array and size are returned.
   * If an error occurred, the pixel array is set to NULL.
   */
  VALUE fxloadPPM(FXStream& store){
    FXColor* data;
    FXint width;
    FXint height;
    if(fxloadPPM(store,data,width,height)){
      VALUE ary=rb_ary_new();
      rb_ary_push(ary,FXRbMakeColorArray(data,width,height));
      FXFREE(&data);
      rb_ary_push(ary,to_ruby(width));
      rb_ary_push(ary,to_ruby(height));
      return ary;
      }
    else{
      return Qnil;
      }
    }

FXRGBIcon *new_FXRGBIcon(FXApp *a,void const *pix,FXColor clr,FXuint opts,FXint w,FXint h){
      return new FXRbRGBIcon(a,pix,clr,opts,w,h);
      }

swig_class cFXRGBIcon;
static void free_FXRGBIcon(FXRGBIcon *);
FXTGAIcon *new_FXTGAIcon(FXApp *a,void const *pix,FXColor clr,FXuint opts,FXint w,FXint h){
      return new FXRbTGAIcon(a,pix,clr,opts,w,h);
      }

swig_class cFXTGAIcon;
static void free_FXTGAIcon(FXTGAIcon *);
FXTIFIcon *new_FXTIFIcon(FXApp *a,void const *pix,FXColor clr,FXuint opts,FXint w,FXint h){
      return new FXRbTIFIcon(a,pix,clr,opts,w,h);
      }

swig_class cFXTIFIcon;
static void free_FXTIFIcon(FXTIFIcon *);
FXXBMIcon *new_FXXBMIcon(FXApp *a,FXuchar const *pixels,FXuchar const *mask,FXColor clr,FXuint opts,FXint w,FXint h){
      return new FXRbXBMIcon(a,pixels,mask,clr,opts,w,h);
      }

swig_class cFXXBMIcon;
static void free_FXXBMIcon(FXXBMIcon *);
FXXPMIcon *new_FXXPMIcon(FXApp *a,FXchar const **pix,FXColor clr,FXuint opts,FXint w,FXint h){
      return new FXRbXPMIcon(a,pix,clr,opts,w,h);
      }

swig_class cFXXPMIcon;
static void free_FXXPMIcon(FXXPMIcon *);

  /// Load an X Pixmap file from a stream
  VALUE fxloadXPM(FXStream& store){
    FXColor* data;
    FXint width;
    FXint height;
    if(fxloadXPM(store,data,width,height)){
      VALUE ary=rb_ary_new();
      rb_ary_push(ary,FXRbMakeColorArray(data,width,height));
      FXFREE(&data);
      rb_ary_push(ary,to_ruby(width));
      rb_ary_push(ary,to_ruby(height));
      return ary;
      }
    else{
      return Qnil;
      }
    }

  /// Load an X Pixmap file from an array of strings
  VALUE fxloadXPM(VALUE strArray){
    long len,i;
    VALUE str;
    const FXchar **pix;
    FXColor* data;
    FXint width;
    FXint height;
    VALUE ary=Qnil;
    
    // Confirm that the input is an array of strings
    Check_Type(strArray,T_ARRAY);
    len=RARRAY(strArray)->len;
    for(i=0; i<len; i++){
      str=rb_ary_entry(strArray,i);
      Check_Type(str,T_STRING);
      }

    // Convert to a C array
    if(FXMALLOC(&pix,FXchar*,len)){
      for(i=0; i<len; i++){
        str=rb_ary_entry(strArray,i);
	pix[i]=StringValuePtr(str);
	}
      if(fxloadXPM(pix,data,width,height)){
	ary=rb_ary_new();
	rb_ary_push(ary,FXRbMakeColorArray(data,width,height));
	FXFREE(&data);
	rb_ary_push(ary,to_ruby(width));
	rb_ary_push(ary,to_ruby(height));
	}
      FXFREE(&pix);
      }
    return ary;
    }

#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE _wrap_FXIcon_allocate(VALUE self) {
#else
     static VALUE _wrap_FXIcon_allocate(int argc, VALUE *argv, VALUE self) {
#endif
         VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_FXIcon);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
         return vresult; }
static VALUE _wrap_new_FXIcon(int argc, VALUE *argv, VALUE self) { FXApp *arg1 = (FXApp *) 0 ; FXColor *arg2 = (FXColor *) 0 ;
    FXColor arg3 = (FXColor) 0 ; FXuint arg4 = (FXuint) 0 ; FXint arg5 = (FXint) 1 ; FXint arg6 = (FXint) 1 ; FXIcon *result;
    if ((argc < 1) || (argc > 6)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXApp, 1); if (argc > 1) { { arg2=NULL; if(argv[1]!=Qnil){
                Check_Type(argv[1],T_ARRAY); if(FXMALLOC(&arg2,FXColor,RARRAY(argv[1])->len)){
                    for(long i=0; i<RARRAY(argv[1])->len; i++){
                        arg2[i]=static_cast<FXColor>(NUM2UINT(rb_ary_entry(argv[1],i))); }  }  }  }  }  if (argc > 2) {
        arg3 = to_FXColor(argv[2]); }  if (argc > 3) { arg4 = NUM2UINT(argv[3]); }  if (argc > 4) { arg5 = NUM2INT(argv[4]); } 
    if (argc > 5) { arg6 = NUM2INT(argv[5]); }  { result = (FXIcon *)new_FXIcon(arg1,(FXColor const *)arg2,arg3,arg4,arg5,arg6);
        DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result); if(rb_block_given_p()){ rb_yield(self); }  }  FXFREE(&arg2);
    return self; }
static VALUE _wrap_FXIcon_getTransparentColor(int argc, VALUE *argv, VALUE self) { FXIcon *arg1 = (FXIcon *) 0 ; FXColor result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXIcon, 1);
    result = (FXColor)((FXIcon const *)arg1)->getTransparentColor(); vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXIcon_setTransparentColor(int argc, VALUE *argv, VALUE self) { FXIcon *arg1 = (FXIcon *) 0 ; FXColor arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXIcon, 1); arg2 = to_FXColor(argv[0]); (arg1)->setTransparentColor(arg2);
    return Qnil; }
static void
free_FXIcon(FXIcon *arg1) {
    delete arg1;
}
static VALUE _wrap_FXIcon_save(int argc, VALUE *argv, VALUE self) { FXIcon *arg1 = (FXIcon *) 0 ; FXStream *arg2 = 0 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXIcon, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXIcon_save((FXIcon const *)arg1,*arg2); return Qnil; }
static VALUE _wrap_FXIcon_load(int argc, VALUE *argv, VALUE self) { FXIcon *arg1 = (FXIcon *) 0 ; FXStream *arg2 = 0 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXIcon, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXIcon_load(arg1,*arg2); return Qnil; }
static VALUE _wrap_FXIcon_create(int argc, VALUE *argv, VALUE self) { FXIcon *arg1 = (FXIcon *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXIcon, 1); FXIcon_create(arg1); return Qnil; }
static VALUE _wrap_FXIcon_detach(int argc, VALUE *argv, VALUE self) { FXIcon *arg1 = (FXIcon *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXIcon, 1); FXIcon_detach(arg1); return Qnil; }
static VALUE _wrap_FXIcon_destroy(int argc, VALUE *argv, VALUE self) { FXIcon *arg1 = (FXIcon *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXIcon, 1); FXIcon_destroy(arg1); return Qnil; }
static VALUE _wrap_FXIcon_resize(int argc, VALUE *argv, VALUE self) { FXIcon *arg1 = (FXIcon *) 0 ; FXint arg2 ; FXint arg3 ;
    if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXIcon, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    FXIcon_resize(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXIcon_restore(int argc, VALUE *argv, VALUE self) { FXIcon *arg1 = (FXIcon *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXIcon, 1); FXIcon_restore(arg1); return Qnil; }
static VALUE _wrap_FXIcon_render(int argc, VALUE *argv, VALUE self) { FXIcon *arg1 = (FXIcon *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXIcon, 1); FXIcon_render(arg1); return Qnil; }
static VALUE _wrap_FXIcon_release(int argc, VALUE *argv, VALUE self) { FXIcon *arg1 = (FXIcon *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXIcon, 1); FXIcon_release(arg1); return Qnil; }
static VALUE _wrap_FXIcon_scale(int argc, VALUE *argv, VALUE self) { FXIcon *arg1 = (FXIcon *) 0 ; FXint arg2 ; FXint arg3 ;
    FXint arg4 = (FXint) 0 ; if ((argc < 2) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXIcon, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    if (argc > 2) { arg4 = NUM2INT(argv[2]); }  FXIcon_scale(arg1,arg2,arg3,arg4); return Qnil; }
static VALUE _wrap_FXIcon_mirror(int argc, VALUE *argv, VALUE self) { FXIcon *arg1 = (FXIcon *) 0 ; FXbool arg2 ; FXbool arg3 ;
    if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXIcon, 1); arg2 = to_FXbool(argv[0]); arg3 = to_FXbool(argv[1]);
    FXIcon_mirror(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXIcon_rotate(int argc, VALUE *argv, VALUE self) { FXIcon *arg1 = (FXIcon *) 0 ; FXint arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXIcon, 1); arg2 = NUM2INT(argv[0]); FXIcon_rotate(arg1,arg2);
    return Qnil; }
static VALUE _wrap_FXIcon_crop(int argc, VALUE *argv, VALUE self) { FXIcon *arg1 = (FXIcon *) 0 ; FXint arg2 ; FXint arg3 ;
    FXint arg4 ; FXint arg5 ; if ((argc < 4) || (argc > 4)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXIcon, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    arg4 = NUM2INT(argv[2]); arg5 = NUM2INT(argv[3]); FXIcon_crop(arg1,arg2,arg3,arg4,arg5); return Qnil; }
static VALUE _wrap_FXIcon_fill(int argc, VALUE *argv, VALUE self) { FXIcon *arg1 = (FXIcon *) 0 ; FXColor arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXIcon, 1); arg2 = to_FXColor(argv[0]); FXIcon_fill(arg1,arg2);
    return Qnil; }
static VALUE _wrap_FXIcon_fade(int argc, VALUE *argv, VALUE self) { FXIcon *arg1 = (FXIcon *) 0 ; FXColor arg2 ;
    FXint arg3 = (FXint) 255 ; if ((argc < 1) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXIcon, 1); arg2 = to_FXColor(argv[0]); if (argc > 1) {
        arg3 = NUM2INT(argv[1]); }  FXIcon_fade(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXIcon_xshear(int argc, VALUE *argv, VALUE self) { FXIcon *arg1 = (FXIcon *) 0 ; FXint arg2 ;
    FXColor arg3 = (FXColor) 0 ; if ((argc < 1) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXIcon, 1); arg2 = NUM2INT(argv[0]); if (argc > 1) {
        arg3 = to_FXColor(argv[1]); }  FXIcon_xshear(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXIcon_yshear(int argc, VALUE *argv, VALUE self) { FXIcon *arg1 = (FXIcon *) 0 ; FXint arg2 ;
    FXColor arg3 = (FXColor) 0 ; if ((argc < 1) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXIcon, 1); arg2 = NUM2INT(argv[0]); if (argc > 1) {
        arg3 = to_FXColor(argv[1]); }  FXIcon_yshear(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXIcon_hgradient(int argc, VALUE *argv, VALUE self) { FXIcon *arg1 = (FXIcon *) 0 ; FXColor arg2 ;
    FXColor arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXIcon, 1); arg2 = to_FXColor(argv[0]); arg3 = to_FXColor(argv[1]);
    FXIcon_hgradient(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXIcon_vgradient(int argc, VALUE *argv, VALUE self) { FXIcon *arg1 = (FXIcon *) 0 ; FXColor arg2 ;
    FXColor arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXIcon, 1); arg2 = to_FXColor(argv[0]); arg3 = to_FXColor(argv[1]);
    FXIcon_vgradient(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXIcon_gradient(int argc, VALUE *argv, VALUE self) { FXIcon *arg1 = (FXIcon *) 0 ; FXColor arg2 ;
    FXColor arg3 ; FXColor arg4 ; FXColor arg5 ; if ((argc < 4) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc); SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXIcon, 1);
    arg2 = to_FXColor(argv[0]); arg3 = to_FXColor(argv[1]); arg4 = to_FXColor(argv[2]); arg5 = to_FXColor(argv[3]);
    FXIcon_gradient(arg1,arg2,arg3,arg4,arg5); return Qnil; }
static VALUE _wrap_FXIcon_blend(int argc, VALUE *argv, VALUE self) { FXIcon *arg1 = (FXIcon *) 0 ; FXColor arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXIcon, 1); arg2 = to_FXColor(argv[0]); FXIcon_blend(arg1,arg2);
    return Qnil; }
static VALUE _wrap_FXIcon_savePixels(int argc, VALUE *argv, VALUE self) { FXIcon *arg1 = (FXIcon *) 0 ; FXStream *arg2 = 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc); SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXIcon, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    result = (FXbool)FXIcon_savePixels((FXIcon const *)arg1,*arg2); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXIcon_loadPixels(int argc, VALUE *argv, VALUE self) { FXIcon *arg1 = (FXIcon *) 0 ; FXStream *arg2 = 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc); SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXIcon, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    result = (FXbool)FXIcon_loadPixels(arg1,*arg2); vresult = result ? Qtrue : Qfalse; return vresult; }
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE _wrap_FXBMPIcon_allocate(VALUE self) {
#else
     static VALUE _wrap_FXBMPIcon_allocate(int argc, VALUE *argv, VALUE self) {
#endif
         VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_FXBMPIcon);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
         return vresult; }
static VALUE _wrap_new_FXBMPIcon(int argc, VALUE *argv, VALUE self) { FXApp *arg1 = (FXApp *) 0 ; void *arg2 = (void *) 0 ;
    FXColor arg3 = (FXColor) 0 ; FXuint arg4 = (FXuint) 0 ; FXint arg5 = (FXint) 1 ; FXint arg6 = (FXint) 1 ; FXBMPIcon *result;
    if ((argc < 1) || (argc > 6)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXApp, 1); if (argc > 1) { { if (argv[1] != Qnil) {
                Check_Type(argv[1], T_STRING); arg2 = reinterpret_cast<void *>(RSTRING(argv[1])->ptr); }  else { arg2 = NULL; }
             }  }  if (argc > 2) { arg3 = to_FXColor(argv[2]); }  if (argc > 3) { arg4 = NUM2UINT(argv[3]); }  if (argc > 4) {
        arg5 = NUM2INT(argv[4]); }  if (argc > 5) { arg6 = NUM2INT(argv[5]); }  {
        result = (FXBMPIcon *)new_FXBMPIcon(arg1,(void const *)arg2,arg3,arg4,arg5,arg6);
        DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result); if(rb_block_given_p()){ rb_yield(self); }  }  return self; }
static void
free_FXBMPIcon(FXBMPIcon *arg1) {
    delete arg1;
}
static VALUE _wrap_FXBMPIcon_save(int argc, VALUE *argv, VALUE self) { FXBMPIcon *arg1 = (FXBMPIcon *) 0 ; FXStream *arg2 = 0 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXBMPIcon, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXBMPIcon_save((FXBMPIcon const *)arg1,*arg2); return Qnil; }
static VALUE _wrap_FXBMPIcon_load(int argc, VALUE *argv, VALUE self) { FXBMPIcon *arg1 = (FXBMPIcon *) 0 ; FXStream *arg2 = 0 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXBMPIcon, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXBMPIcon_load(arg1,*arg2); return Qnil; }
static VALUE _wrap_FXBMPIcon_create(int argc, VALUE *argv, VALUE self) { FXBMPIcon *arg1 = (FXBMPIcon *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXBMPIcon, 1); FXBMPIcon_create(arg1); return Qnil; }
static VALUE _wrap_FXBMPIcon_detach(int argc, VALUE *argv, VALUE self) { FXBMPIcon *arg1 = (FXBMPIcon *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXBMPIcon, 1); FXBMPIcon_detach(arg1); return Qnil; }
static VALUE _wrap_FXBMPIcon_destroy(int argc, VALUE *argv, VALUE self) { FXBMPIcon *arg1 = (FXBMPIcon *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXBMPIcon, 1); FXBMPIcon_destroy(arg1); return Qnil; }
static VALUE _wrap_FXBMPIcon_resize(int argc, VALUE *argv, VALUE self) { FXBMPIcon *arg1 = (FXBMPIcon *) 0 ; FXint arg2 ;
    FXint arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXBMPIcon, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    FXBMPIcon_resize(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXBMPIcon_restore(int argc, VALUE *argv, VALUE self) { FXBMPIcon *arg1 = (FXBMPIcon *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXBMPIcon, 1); FXBMPIcon_restore(arg1); return Qnil; }
static VALUE _wrap_FXBMPIcon_render(int argc, VALUE *argv, VALUE self) { FXBMPIcon *arg1 = (FXBMPIcon *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXBMPIcon, 1); FXBMPIcon_render(arg1); return Qnil; }
static VALUE _wrap_FXBMPIcon_release(int argc, VALUE *argv, VALUE self) { FXBMPIcon *arg1 = (FXBMPIcon *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXBMPIcon, 1); FXBMPIcon_release(arg1); return Qnil; }
static VALUE _wrap_FXBMPIcon_scale(int argc, VALUE *argv, VALUE self) { FXBMPIcon *arg1 = (FXBMPIcon *) 0 ; FXint arg2 ;
    FXint arg3 ; FXint arg4 = (FXint) 0 ; if ((argc < 2) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXBMPIcon, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    if (argc > 2) { arg4 = NUM2INT(argv[2]); }  FXBMPIcon_scale(arg1,arg2,arg3,arg4); return Qnil; }
static VALUE _wrap_FXBMPIcon_mirror(int argc, VALUE *argv, VALUE self) { FXBMPIcon *arg1 = (FXBMPIcon *) 0 ; FXbool arg2 ;
    FXbool arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXBMPIcon, 1); arg2 = to_FXbool(argv[0]); arg3 = to_FXbool(argv[1]);
    FXBMPIcon_mirror(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXBMPIcon_rotate(int argc, VALUE *argv, VALUE self) { FXBMPIcon *arg1 = (FXBMPIcon *) 0 ; FXint arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXBMPIcon, 1); arg2 = NUM2INT(argv[0]); FXBMPIcon_rotate(arg1,arg2);
    return Qnil; }
static VALUE _wrap_FXBMPIcon_crop(int argc, VALUE *argv, VALUE self) { FXBMPIcon *arg1 = (FXBMPIcon *) 0 ; FXint arg2 ;
    FXint arg3 ; FXint arg4 ; FXint arg5 ; if ((argc < 4) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXBMPIcon, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    arg4 = NUM2INT(argv[2]); arg5 = NUM2INT(argv[3]); FXBMPIcon_crop(arg1,arg2,arg3,arg4,arg5); return Qnil; }
static VALUE _wrap_FXBMPIcon_fill(int argc, VALUE *argv, VALUE self) { FXBMPIcon *arg1 = (FXBMPIcon *) 0 ; FXColor arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXBMPIcon, 1); arg2 = to_FXColor(argv[0]); FXBMPIcon_fill(arg1,arg2);
    return Qnil; }
static VALUE _wrap_FXBMPIcon_fade(int argc, VALUE *argv, VALUE self) { FXBMPIcon *arg1 = (FXBMPIcon *) 0 ; FXColor arg2 ;
    FXint arg3 = (FXint) 255 ; if ((argc < 1) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXBMPIcon, 1); arg2 = to_FXColor(argv[0]); if (argc > 1) {
        arg3 = NUM2INT(argv[1]); }  FXBMPIcon_fade(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXBMPIcon_xshear(int argc, VALUE *argv, VALUE self) { FXBMPIcon *arg1 = (FXBMPIcon *) 0 ; FXint arg2 ;
    FXColor arg3 = (FXColor) 0 ; if ((argc < 1) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXBMPIcon, 1); arg2 = NUM2INT(argv[0]); if (argc > 1) {
        arg3 = to_FXColor(argv[1]); }  FXBMPIcon_xshear(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXBMPIcon_yshear(int argc, VALUE *argv, VALUE self) { FXBMPIcon *arg1 = (FXBMPIcon *) 0 ; FXint arg2 ;
    FXColor arg3 = (FXColor) 0 ; if ((argc < 1) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXBMPIcon, 1); arg2 = NUM2INT(argv[0]); if (argc > 1) {
        arg3 = to_FXColor(argv[1]); }  FXBMPIcon_yshear(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXBMPIcon_hgradient(int argc, VALUE *argv, VALUE self) { FXBMPIcon *arg1 = (FXBMPIcon *) 0 ; FXColor arg2 ;
    FXColor arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXBMPIcon, 1); arg2 = to_FXColor(argv[0]); arg3 = to_FXColor(argv[1]);
    FXBMPIcon_hgradient(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXBMPIcon_vgradient(int argc, VALUE *argv, VALUE self) { FXBMPIcon *arg1 = (FXBMPIcon *) 0 ; FXColor arg2 ;
    FXColor arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXBMPIcon, 1); arg2 = to_FXColor(argv[0]); arg3 = to_FXColor(argv[1]);
    FXBMPIcon_vgradient(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXBMPIcon_gradient(int argc, VALUE *argv, VALUE self) { FXBMPIcon *arg1 = (FXBMPIcon *) 0 ; FXColor arg2 ;
    FXColor arg3 ; FXColor arg4 ; FXColor arg5 ; if ((argc < 4) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXBMPIcon, 1); arg2 = to_FXColor(argv[0]); arg3 = to_FXColor(argv[1]);
    arg4 = to_FXColor(argv[2]); arg5 = to_FXColor(argv[3]); FXBMPIcon_gradient(arg1,arg2,arg3,arg4,arg5); return Qnil; }
static VALUE _wrap_FXBMPIcon_blend(int argc, VALUE *argv, VALUE self) { FXBMPIcon *arg1 = (FXBMPIcon *) 0 ; FXColor arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXBMPIcon, 1); arg2 = to_FXColor(argv[0]); FXBMPIcon_blend(arg1,arg2);
    return Qnil; }
static VALUE _wrap_FXBMPIcon_savePixels(int argc, VALUE *argv, VALUE self) { FXBMPIcon *arg1 = (FXBMPIcon *) 0 ;
    FXStream *arg2 = 0 ; FXbool result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXBMPIcon, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    result = (FXbool)FXBMPIcon_savePixels((FXBMPIcon const *)arg1,*arg2); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXBMPIcon_loadPixels(int argc, VALUE *argv, VALUE self) { FXBMPIcon *arg1 = (FXBMPIcon *) 0 ;
    FXStream *arg2 = 0 ; FXbool result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXBMPIcon, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    result = (FXbool)FXBMPIcon_loadPixels(arg1,*arg2); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_fxloadBMP(int argc, VALUE *argv, VALUE self) { FXStream *arg1 = 0 ; VALUE result; VALUE vresult = Qnil;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXStream, 1); if (arg1 == NULL) rb_raise(rb_eTypeError, "null reference");
    result = (VALUE)fxloadBMP(*arg1); vresult = result; return vresult; }
static VALUE _wrap_fxsaveBMP(int argc, VALUE *argv, VALUE self) { FXStream *arg1 = 0 ; FXColor *arg2 = (FXColor *) 0 ;
    FXint arg3 ; FXint arg4 ; FXbool result; VALUE vresult = Qnil; if ((argc < 4) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXStream, 1); if (arg1 == NULL) rb_raise(rb_eTypeError, "null reference");
    { arg2=NULL; if(argv[1]!=Qnil){ Check_Type(argv[1],T_ARRAY); if(FXMALLOC(&arg2,FXColor,RARRAY(argv[1])->len)){
                for(long i=0; i<RARRAY(argv[1])->len; i++){ arg2[i]=static_cast<FXColor>(NUM2UINT(rb_ary_entry(argv[1],i))); }  }
             }  }  arg3 = NUM2INT(argv[2]); arg4 = NUM2INT(argv[3]);
    result = (FXbool)fxsaveBMP(*arg1,(FXColor const *)arg2,arg3,arg4); vresult = result ? Qtrue : Qfalse; FXFREE(&arg2);
    return vresult; }
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE _wrap_FXGIFIcon_allocate(VALUE self) {
#else
     static VALUE _wrap_FXGIFIcon_allocate(int argc, VALUE *argv, VALUE self) {
#endif
         VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_FXGIFIcon);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
         return vresult; }
static VALUE _wrap_new_FXGIFIcon(int argc, VALUE *argv, VALUE self) { FXApp *arg1 = (FXApp *) 0 ; void *arg2 = (void *) 0 ;
    FXColor arg3 = (FXColor) 0 ; FXuint arg4 = (FXuint) 0 ; FXint arg5 = (FXint) 1 ; FXint arg6 = (FXint) 1 ; FXGIFIcon *result;
    if ((argc < 1) || (argc > 6)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXApp, 1); if (argc > 1) { { if (argv[1] != Qnil) {
                Check_Type(argv[1], T_STRING); arg2 = reinterpret_cast<void *>(RSTRING(argv[1])->ptr); }  else { arg2 = NULL; }
             }  }  if (argc > 2) { arg3 = to_FXColor(argv[2]); }  if (argc > 3) { arg4 = NUM2UINT(argv[3]); }  if (argc > 4) {
        arg5 = NUM2INT(argv[4]); }  if (argc > 5) { arg6 = NUM2INT(argv[5]); }  {
        result = (FXGIFIcon *)new_FXGIFIcon(arg1,(void const *)arg2,arg3,arg4,arg5,arg6);
        DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result); if(rb_block_given_p()){ rb_yield(self); }  }  return self; }
static void
free_FXGIFIcon(FXGIFIcon *arg1) {
    delete arg1;
}
static VALUE _wrap_FXGIFIcon_save(int argc, VALUE *argv, VALUE self) { FXGIFIcon *arg1 = (FXGIFIcon *) 0 ; FXStream *arg2 = 0 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGIFIcon, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXGIFIcon_save((FXGIFIcon const *)arg1,*arg2); return Qnil; }
static VALUE _wrap_FXGIFIcon_load(int argc, VALUE *argv, VALUE self) { FXGIFIcon *arg1 = (FXGIFIcon *) 0 ; FXStream *arg2 = 0 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGIFIcon, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXGIFIcon_load(arg1,*arg2); return Qnil; }
static VALUE _wrap_FXGIFIcon_create(int argc, VALUE *argv, VALUE self) { FXGIFIcon *arg1 = (FXGIFIcon *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGIFIcon, 1); FXGIFIcon_create(arg1); return Qnil; }
static VALUE _wrap_FXGIFIcon_detach(int argc, VALUE *argv, VALUE self) { FXGIFIcon *arg1 = (FXGIFIcon *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGIFIcon, 1); FXGIFIcon_detach(arg1); return Qnil; }
static VALUE _wrap_FXGIFIcon_destroy(int argc, VALUE *argv, VALUE self) { FXGIFIcon *arg1 = (FXGIFIcon *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGIFIcon, 1); FXGIFIcon_destroy(arg1); return Qnil; }
static VALUE _wrap_FXGIFIcon_resize(int argc, VALUE *argv, VALUE self) { FXGIFIcon *arg1 = (FXGIFIcon *) 0 ; FXint arg2 ;
    FXint arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGIFIcon, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    FXGIFIcon_resize(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXGIFIcon_restore(int argc, VALUE *argv, VALUE self) { FXGIFIcon *arg1 = (FXGIFIcon *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGIFIcon, 1); FXGIFIcon_restore(arg1); return Qnil; }
static VALUE _wrap_FXGIFIcon_render(int argc, VALUE *argv, VALUE self) { FXGIFIcon *arg1 = (FXGIFIcon *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGIFIcon, 1); FXGIFIcon_render(arg1); return Qnil; }
static VALUE _wrap_FXGIFIcon_release(int argc, VALUE *argv, VALUE self) { FXGIFIcon *arg1 = (FXGIFIcon *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGIFIcon, 1); FXGIFIcon_release(arg1); return Qnil; }
static VALUE _wrap_FXGIFIcon_scale(int argc, VALUE *argv, VALUE self) { FXGIFIcon *arg1 = (FXGIFIcon *) 0 ; FXint arg2 ;
    FXint arg3 ; FXint arg4 = (FXint) 0 ; if ((argc < 2) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGIFIcon, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    if (argc > 2) { arg4 = NUM2INT(argv[2]); }  FXGIFIcon_scale(arg1,arg2,arg3,arg4); return Qnil; }
static VALUE _wrap_FXGIFIcon_mirror(int argc, VALUE *argv, VALUE self) { FXGIFIcon *arg1 = (FXGIFIcon *) 0 ; FXbool arg2 ;
    FXbool arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGIFIcon, 1); arg2 = to_FXbool(argv[0]); arg3 = to_FXbool(argv[1]);
    FXGIFIcon_mirror(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXGIFIcon_rotate(int argc, VALUE *argv, VALUE self) { FXGIFIcon *arg1 = (FXGIFIcon *) 0 ; FXint arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGIFIcon, 1); arg2 = NUM2INT(argv[0]); FXGIFIcon_rotate(arg1,arg2);
    return Qnil; }
static VALUE _wrap_FXGIFIcon_crop(int argc, VALUE *argv, VALUE self) { FXGIFIcon *arg1 = (FXGIFIcon *) 0 ; FXint arg2 ;
    FXint arg3 ; FXint arg4 ; FXint arg5 ; if ((argc < 4) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGIFIcon, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    arg4 = NUM2INT(argv[2]); arg5 = NUM2INT(argv[3]); FXGIFIcon_crop(arg1,arg2,arg3,arg4,arg5); return Qnil; }
static VALUE _wrap_FXGIFIcon_fill(int argc, VALUE *argv, VALUE self) { FXGIFIcon *arg1 = (FXGIFIcon *) 0 ; FXColor arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGIFIcon, 1); arg2 = to_FXColor(argv[0]); FXGIFIcon_fill(arg1,arg2);
    return Qnil; }
static VALUE _wrap_FXGIFIcon_fade(int argc, VALUE *argv, VALUE self) { FXGIFIcon *arg1 = (FXGIFIcon *) 0 ; FXColor arg2 ;
    FXint arg3 = (FXint) 255 ; if ((argc < 1) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGIFIcon, 1); arg2 = to_FXColor(argv[0]); if (argc > 1) {
        arg3 = NUM2INT(argv[1]); }  FXGIFIcon_fade(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXGIFIcon_xshear(int argc, VALUE *argv, VALUE self) { FXGIFIcon *arg1 = (FXGIFIcon *) 0 ; FXint arg2 ;
    FXColor arg3 = (FXColor) 0 ; if ((argc < 1) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGIFIcon, 1); arg2 = NUM2INT(argv[0]); if (argc > 1) {
        arg3 = to_FXColor(argv[1]); }  FXGIFIcon_xshear(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXGIFIcon_yshear(int argc, VALUE *argv, VALUE self) { FXGIFIcon *arg1 = (FXGIFIcon *) 0 ; FXint arg2 ;
    FXColor arg3 = (FXColor) 0 ; if ((argc < 1) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGIFIcon, 1); arg2 = NUM2INT(argv[0]); if (argc > 1) {
        arg3 = to_FXColor(argv[1]); }  FXGIFIcon_yshear(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXGIFIcon_hgradient(int argc, VALUE *argv, VALUE self) { FXGIFIcon *arg1 = (FXGIFIcon *) 0 ; FXColor arg2 ;
    FXColor arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGIFIcon, 1); arg2 = to_FXColor(argv[0]); arg3 = to_FXColor(argv[1]);
    FXGIFIcon_hgradient(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXGIFIcon_vgradient(int argc, VALUE *argv, VALUE self) { FXGIFIcon *arg1 = (FXGIFIcon *) 0 ; FXColor arg2 ;
    FXColor arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGIFIcon, 1); arg2 = to_FXColor(argv[0]); arg3 = to_FXColor(argv[1]);
    FXGIFIcon_vgradient(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXGIFIcon_gradient(int argc, VALUE *argv, VALUE self) { FXGIFIcon *arg1 = (FXGIFIcon *) 0 ; FXColor arg2 ;
    FXColor arg3 ; FXColor arg4 ; FXColor arg5 ; if ((argc < 4) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGIFIcon, 1); arg2 = to_FXColor(argv[0]); arg3 = to_FXColor(argv[1]);
    arg4 = to_FXColor(argv[2]); arg5 = to_FXColor(argv[3]); FXGIFIcon_gradient(arg1,arg2,arg3,arg4,arg5); return Qnil; }
static VALUE _wrap_FXGIFIcon_blend(int argc, VALUE *argv, VALUE self) { FXGIFIcon *arg1 = (FXGIFIcon *) 0 ; FXColor arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGIFIcon, 1); arg2 = to_FXColor(argv[0]); FXGIFIcon_blend(arg1,arg2);
    return Qnil; }
static VALUE _wrap_FXGIFIcon_savePixels(int argc, VALUE *argv, VALUE self) { FXGIFIcon *arg1 = (FXGIFIcon *) 0 ;
    FXStream *arg2 = 0 ; FXbool result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGIFIcon, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    result = (FXbool)FXGIFIcon_savePixels((FXGIFIcon const *)arg1,*arg2); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXGIFIcon_loadPixels(int argc, VALUE *argv, VALUE self) { FXGIFIcon *arg1 = (FXGIFIcon *) 0 ;
    FXStream *arg2 = 0 ; FXbool result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGIFIcon, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    result = (FXbool)FXGIFIcon_loadPixels(arg1,*arg2); vresult = result ? Qtrue : Qfalse; return vresult; }
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE _wrap_FXICOIcon_allocate(VALUE self) {
#else
     static VALUE _wrap_FXICOIcon_allocate(int argc, VALUE *argv, VALUE self) {
#endif
         VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_FXICOIcon);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
         return vresult; }
static VALUE _wrap_new_FXICOIcon(int argc, VALUE *argv, VALUE self) { FXApp *arg1 = (FXApp *) 0 ; void *arg2 = (void *) 0 ;
    FXColor arg3 = (FXColor) 0 ; FXuint arg4 = (FXuint) 0 ; FXint arg5 = (FXint) 1 ; FXint arg6 = (FXint) 1 ; FXICOIcon *result;
    if ((argc < 1) || (argc > 6)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXApp, 1); if (argc > 1) { { if (argv[1] != Qnil) {
                Check_Type(argv[1], T_STRING); arg2 = reinterpret_cast<void *>(RSTRING(argv[1])->ptr); }  else { arg2 = NULL; }
             }  }  if (argc > 2) { arg3 = to_FXColor(argv[2]); }  if (argc > 3) { arg4 = NUM2UINT(argv[3]); }  if (argc > 4) {
        arg5 = NUM2INT(argv[4]); }  if (argc > 5) { arg6 = NUM2INT(argv[5]); }  {
        result = (FXICOIcon *)new_FXICOIcon(arg1,(void const *)arg2,arg3,arg4,arg5,arg6);
        DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result); if(rb_block_given_p()){ rb_yield(self); }  }  return self; }
static void
free_FXICOIcon(FXICOIcon *arg1) {
    delete arg1;
}
static VALUE _wrap_FXICOIcon_save(int argc, VALUE *argv, VALUE self) { FXICOIcon *arg1 = (FXICOIcon *) 0 ; FXStream *arg2 = 0 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXICOIcon, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXICOIcon_save((FXICOIcon const *)arg1,*arg2); return Qnil; }
static VALUE _wrap_FXICOIcon_load(int argc, VALUE *argv, VALUE self) { FXICOIcon *arg1 = (FXICOIcon *) 0 ; FXStream *arg2 = 0 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXICOIcon, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXICOIcon_load(arg1,*arg2); return Qnil; }
static VALUE _wrap_FXICOIcon_create(int argc, VALUE *argv, VALUE self) { FXICOIcon *arg1 = (FXICOIcon *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXICOIcon, 1); FXICOIcon_create(arg1); return Qnil; }
static VALUE _wrap_FXICOIcon_detach(int argc, VALUE *argv, VALUE self) { FXICOIcon *arg1 = (FXICOIcon *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXICOIcon, 1); FXICOIcon_detach(arg1); return Qnil; }
static VALUE _wrap_FXICOIcon_destroy(int argc, VALUE *argv, VALUE self) { FXICOIcon *arg1 = (FXICOIcon *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXICOIcon, 1); FXICOIcon_destroy(arg1); return Qnil; }
static VALUE _wrap_FXICOIcon_resize(int argc, VALUE *argv, VALUE self) { FXICOIcon *arg1 = (FXICOIcon *) 0 ; FXint arg2 ;
    FXint arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXICOIcon, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    FXICOIcon_resize(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXICOIcon_restore(int argc, VALUE *argv, VALUE self) { FXICOIcon *arg1 = (FXICOIcon *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXICOIcon, 1); FXICOIcon_restore(arg1); return Qnil; }
static VALUE _wrap_FXICOIcon_render(int argc, VALUE *argv, VALUE self) { FXICOIcon *arg1 = (FXICOIcon *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXICOIcon, 1); FXICOIcon_render(arg1); return Qnil; }
static VALUE _wrap_FXICOIcon_release(int argc, VALUE *argv, VALUE self) { FXICOIcon *arg1 = (FXICOIcon *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXICOIcon, 1); FXICOIcon_release(arg1); return Qnil; }
static VALUE _wrap_FXICOIcon_scale(int argc, VALUE *argv, VALUE self) { FXICOIcon *arg1 = (FXICOIcon *) 0 ; FXint arg2 ;
    FXint arg3 ; FXint arg4 = (FXint) 0 ; if ((argc < 2) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXICOIcon, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    if (argc > 2) { arg4 = NUM2INT(argv[2]); }  FXICOIcon_scale(arg1,arg2,arg3,arg4); return Qnil; }
static VALUE _wrap_FXICOIcon_mirror(int argc, VALUE *argv, VALUE self) { FXICOIcon *arg1 = (FXICOIcon *) 0 ; FXbool arg2 ;
    FXbool arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXICOIcon, 1); arg2 = to_FXbool(argv[0]); arg3 = to_FXbool(argv[1]);
    FXICOIcon_mirror(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXICOIcon_rotate(int argc, VALUE *argv, VALUE self) { FXICOIcon *arg1 = (FXICOIcon *) 0 ; FXint arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXICOIcon, 1); arg2 = NUM2INT(argv[0]); FXICOIcon_rotate(arg1,arg2);
    return Qnil; }
static VALUE _wrap_FXICOIcon_crop(int argc, VALUE *argv, VALUE self) { FXICOIcon *arg1 = (FXICOIcon *) 0 ; FXint arg2 ;
    FXint arg3 ; FXint arg4 ; FXint arg5 ; if ((argc < 4) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXICOIcon, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    arg4 = NUM2INT(argv[2]); arg5 = NUM2INT(argv[3]); FXICOIcon_crop(arg1,arg2,arg3,arg4,arg5); return Qnil; }
static VALUE _wrap_FXICOIcon_fill(int argc, VALUE *argv, VALUE self) { FXICOIcon *arg1 = (FXICOIcon *) 0 ; FXColor arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXICOIcon, 1); arg2 = to_FXColor(argv[0]); FXICOIcon_fill(arg1,arg2);
    return Qnil; }
static VALUE _wrap_FXICOIcon_fade(int argc, VALUE *argv, VALUE self) { FXICOIcon *arg1 = (FXICOIcon *) 0 ; FXColor arg2 ;
    FXint arg3 = (FXint) 255 ; if ((argc < 1) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXICOIcon, 1); arg2 = to_FXColor(argv[0]); if (argc > 1) {
        arg3 = NUM2INT(argv[1]); }  FXICOIcon_fade(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXICOIcon_xshear(int argc, VALUE *argv, VALUE self) { FXICOIcon *arg1 = (FXICOIcon *) 0 ; FXint arg2 ;
    FXColor arg3 = (FXColor) 0 ; if ((argc < 1) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXICOIcon, 1); arg2 = NUM2INT(argv[0]); if (argc > 1) {
        arg3 = to_FXColor(argv[1]); }  FXICOIcon_xshear(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXICOIcon_yshear(int argc, VALUE *argv, VALUE self) { FXICOIcon *arg1 = (FXICOIcon *) 0 ; FXint arg2 ;
    FXColor arg3 = (FXColor) 0 ; if ((argc < 1) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXICOIcon, 1); arg2 = NUM2INT(argv[0]); if (argc > 1) {
        arg3 = to_FXColor(argv[1]); }  FXICOIcon_yshear(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXICOIcon_hgradient(int argc, VALUE *argv, VALUE self) { FXICOIcon *arg1 = (FXICOIcon *) 0 ; FXColor arg2 ;
    FXColor arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXICOIcon, 1); arg2 = to_FXColor(argv[0]); arg3 = to_FXColor(argv[1]);
    FXICOIcon_hgradient(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXICOIcon_vgradient(int argc, VALUE *argv, VALUE self) { FXICOIcon *arg1 = (FXICOIcon *) 0 ; FXColor arg2 ;
    FXColor arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXICOIcon, 1); arg2 = to_FXColor(argv[0]); arg3 = to_FXColor(argv[1]);
    FXICOIcon_vgradient(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXICOIcon_gradient(int argc, VALUE *argv, VALUE self) { FXICOIcon *arg1 = (FXICOIcon *) 0 ; FXColor arg2 ;
    FXColor arg3 ; FXColor arg4 ; FXColor arg5 ; if ((argc < 4) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXICOIcon, 1); arg2 = to_FXColor(argv[0]); arg3 = to_FXColor(argv[1]);
    arg4 = to_FXColor(argv[2]); arg5 = to_FXColor(argv[3]); FXICOIcon_gradient(arg1,arg2,arg3,arg4,arg5); return Qnil; }
static VALUE _wrap_FXICOIcon_blend(int argc, VALUE *argv, VALUE self) { FXICOIcon *arg1 = (FXICOIcon *) 0 ; FXColor arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXICOIcon, 1); arg2 = to_FXColor(argv[0]); FXICOIcon_blend(arg1,arg2);
    return Qnil; }
static VALUE _wrap_FXICOIcon_savePixels(int argc, VALUE *argv, VALUE self) { FXICOIcon *arg1 = (FXICOIcon *) 0 ;
    FXStream *arg2 = 0 ; FXbool result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXICOIcon, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    result = (FXbool)FXICOIcon_savePixels((FXICOIcon const *)arg1,*arg2); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXICOIcon_loadPixels(int argc, VALUE *argv, VALUE self) { FXICOIcon *arg1 = (FXICOIcon *) 0 ;
    FXStream *arg2 = 0 ; FXbool result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXICOIcon, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    result = (FXbool)FXICOIcon_loadPixels(arg1,*arg2); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_fxloadICO(int argc, VALUE *argv, VALUE self) { FXStream *arg1 = 0 ; VALUE result; VALUE vresult = Qnil;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXStream, 1); if (arg1 == NULL) rb_raise(rb_eTypeError, "null reference");
    result = (VALUE)fxloadICO(*arg1); vresult = result; return vresult; }
static VALUE _wrap_fxsaveICO(int argc, VALUE *argv, VALUE self) { FXStream *arg1 = 0 ; FXColor *arg2 = (FXColor *) 0 ;
    FXint arg3 ; FXint arg4 ; FXint arg5 = (FXint) -1 ; FXint arg6 = (FXint) -1 ; FXbool result; VALUE vresult = Qnil;
    if ((argc < 4) || (argc > 6)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXStream, 1); if (arg1 == NULL) rb_raise(rb_eTypeError, "null reference");
    { arg2=NULL; if(argv[1]!=Qnil){ Check_Type(argv[1],T_ARRAY); if(FXMALLOC(&arg2,FXColor,RARRAY(argv[1])->len)){
                for(long i=0; i<RARRAY(argv[1])->len; i++){ arg2[i]=static_cast<FXColor>(NUM2UINT(rb_ary_entry(argv[1],i))); }  }
             }  }  arg3 = NUM2INT(argv[2]); arg4 = NUM2INT(argv[3]); if (argc > 4) { arg5 = NUM2INT(argv[4]); }  if (argc > 5) {
        arg6 = NUM2INT(argv[5]); }  result = (FXbool)fxsaveICO(*arg1,(FXColor const *)arg2,arg3,arg4,arg5,arg6);
    vresult = result ? Qtrue : Qfalse; FXFREE(&arg2); return vresult; }
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE _wrap_FXJPGIcon_allocate(VALUE self) {
#else
     static VALUE _wrap_FXJPGIcon_allocate(int argc, VALUE *argv, VALUE self) {
#endif
         VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_FXJPGIcon);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
         return vresult; }
static VALUE _wrap_new_FXJPGIcon(int argc, VALUE *argv, VALUE self) { FXApp *arg1 = (FXApp *) 0 ; void *arg2 = (void *) 0 ;
    FXColor arg3 = (FXColor) 0 ; FXuint arg4 = (FXuint) 0 ; FXint arg5 = (FXint) 1 ; FXint arg6 = (FXint) 1 ; FXJPGIcon *result;
    if ((argc < 1) || (argc > 6)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXApp, 1); if (argc > 1) { { if (argv[1] != Qnil) {
                Check_Type(argv[1], T_STRING); arg2 = reinterpret_cast<void *>(RSTRING(argv[1])->ptr); }  else { arg2 = NULL; }
             }  }  if (argc > 2) { arg3 = to_FXColor(argv[2]); }  if (argc > 3) { arg4 = NUM2UINT(argv[3]); }  if (argc > 4) {
        arg5 = NUM2INT(argv[4]); }  if (argc > 5) { arg6 = NUM2INT(argv[5]); }  {
        result = (FXJPGIcon *)new_FXJPGIcon(arg1,(void const *)arg2,arg3,arg4,arg5,arg6);
        DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result); if(rb_block_given_p()){ rb_yield(self); }  }  return self; }
static VALUE _wrap_FXJPGIcon_setQuality(int argc, VALUE *argv, VALUE self) { FXJPGIcon *arg1 = (FXJPGIcon *) 0 ; FXint arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXJPGIcon, 1); arg2 = NUM2INT(argv[0]); (arg1)->setQuality(arg2);
    return Qnil; }
static VALUE _wrap_FXJPGIcon_getQuality(int argc, VALUE *argv, VALUE self) { FXJPGIcon *arg1 = (FXJPGIcon *) 0 ; FXint result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXJPGIcon, 1); result = (FXint)((FXJPGIcon const *)arg1)->getQuality();
    vresult = INT2NUM(result); return vresult; }
static void
free_FXJPGIcon(FXJPGIcon *arg1) {
    delete arg1;
}
static VALUE _wrap_FXJPGIcon_save(int argc, VALUE *argv, VALUE self) { FXJPGIcon *arg1 = (FXJPGIcon *) 0 ; FXStream *arg2 = 0 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXJPGIcon, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXJPGIcon_save((FXJPGIcon const *)arg1,*arg2); return Qnil; }
static VALUE _wrap_FXJPGIcon_load(int argc, VALUE *argv, VALUE self) { FXJPGIcon *arg1 = (FXJPGIcon *) 0 ; FXStream *arg2 = 0 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXJPGIcon, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXJPGIcon_load(arg1,*arg2); return Qnil; }
static VALUE _wrap_FXJPGIcon_create(int argc, VALUE *argv, VALUE self) { FXJPGIcon *arg1 = (FXJPGIcon *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXJPGIcon, 1); FXJPGIcon_create(arg1); return Qnil; }
static VALUE _wrap_FXJPGIcon_detach(int argc, VALUE *argv, VALUE self) { FXJPGIcon *arg1 = (FXJPGIcon *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXJPGIcon, 1); FXJPGIcon_detach(arg1); return Qnil; }
static VALUE _wrap_FXJPGIcon_destroy(int argc, VALUE *argv, VALUE self) { FXJPGIcon *arg1 = (FXJPGIcon *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXJPGIcon, 1); FXJPGIcon_destroy(arg1); return Qnil; }
static VALUE _wrap_FXJPGIcon_resize(int argc, VALUE *argv, VALUE self) { FXJPGIcon *arg1 = (FXJPGIcon *) 0 ; FXint arg2 ;
    FXint arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXJPGIcon, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    FXJPGIcon_resize(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXJPGIcon_restore(int argc, VALUE *argv, VALUE self) { FXJPGIcon *arg1 = (FXJPGIcon *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXJPGIcon, 1); FXJPGIcon_restore(arg1); return Qnil; }
static VALUE _wrap_FXJPGIcon_render(int argc, VALUE *argv, VALUE self) { FXJPGIcon *arg1 = (FXJPGIcon *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXJPGIcon, 1); FXJPGIcon_render(arg1); return Qnil; }
static VALUE _wrap_FXJPGIcon_release(int argc, VALUE *argv, VALUE self) { FXJPGIcon *arg1 = (FXJPGIcon *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXJPGIcon, 1); FXJPGIcon_release(arg1); return Qnil; }
static VALUE _wrap_FXJPGIcon_scale(int argc, VALUE *argv, VALUE self) { FXJPGIcon *arg1 = (FXJPGIcon *) 0 ; FXint arg2 ;
    FXint arg3 ; FXint arg4 = (FXint) 0 ; if ((argc < 2) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXJPGIcon, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    if (argc > 2) { arg4 = NUM2INT(argv[2]); }  FXJPGIcon_scale(arg1,arg2,arg3,arg4); return Qnil; }
static VALUE _wrap_FXJPGIcon_mirror(int argc, VALUE *argv, VALUE self) { FXJPGIcon *arg1 = (FXJPGIcon *) 0 ; FXbool arg2 ;
    FXbool arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXJPGIcon, 1); arg2 = to_FXbool(argv[0]); arg3 = to_FXbool(argv[1]);
    FXJPGIcon_mirror(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXJPGIcon_rotate(int argc, VALUE *argv, VALUE self) { FXJPGIcon *arg1 = (FXJPGIcon *) 0 ; FXint arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXJPGIcon, 1); arg2 = NUM2INT(argv[0]); FXJPGIcon_rotate(arg1,arg2);
    return Qnil; }
static VALUE _wrap_FXJPGIcon_crop(int argc, VALUE *argv, VALUE self) { FXJPGIcon *arg1 = (FXJPGIcon *) 0 ; FXint arg2 ;
    FXint arg3 ; FXint arg4 ; FXint arg5 ; if ((argc < 4) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXJPGIcon, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    arg4 = NUM2INT(argv[2]); arg5 = NUM2INT(argv[3]); FXJPGIcon_crop(arg1,arg2,arg3,arg4,arg5); return Qnil; }
static VALUE _wrap_FXJPGIcon_fill(int argc, VALUE *argv, VALUE self) { FXJPGIcon *arg1 = (FXJPGIcon *) 0 ; FXColor arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXJPGIcon, 1); arg2 = to_FXColor(argv[0]); FXJPGIcon_fill(arg1,arg2);
    return Qnil; }
static VALUE _wrap_FXJPGIcon_fade(int argc, VALUE *argv, VALUE self) { FXJPGIcon *arg1 = (FXJPGIcon *) 0 ; FXColor arg2 ;
    FXint arg3 = (FXint) 255 ; if ((argc < 1) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXJPGIcon, 1); arg2 = to_FXColor(argv[0]); if (argc > 1) {
        arg3 = NUM2INT(argv[1]); }  FXJPGIcon_fade(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXJPGIcon_xshear(int argc, VALUE *argv, VALUE self) { FXJPGIcon *arg1 = (FXJPGIcon *) 0 ; FXint arg2 ;
    FXColor arg3 = (FXColor) 0 ; if ((argc < 1) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXJPGIcon, 1); arg2 = NUM2INT(argv[0]); if (argc > 1) {
        arg3 = to_FXColor(argv[1]); }  FXJPGIcon_xshear(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXJPGIcon_yshear(int argc, VALUE *argv, VALUE self) { FXJPGIcon *arg1 = (FXJPGIcon *) 0 ; FXint arg2 ;
    FXColor arg3 = (FXColor) 0 ; if ((argc < 1) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXJPGIcon, 1); arg2 = NUM2INT(argv[0]); if (argc > 1) {
        arg3 = to_FXColor(argv[1]); }  FXJPGIcon_yshear(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXJPGIcon_hgradient(int argc, VALUE *argv, VALUE self) { FXJPGIcon *arg1 = (FXJPGIcon *) 0 ; FXColor arg2 ;
    FXColor arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXJPGIcon, 1); arg2 = to_FXColor(argv[0]); arg3 = to_FXColor(argv[1]);
    FXJPGIcon_hgradient(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXJPGIcon_vgradient(int argc, VALUE *argv, VALUE self) { FXJPGIcon *arg1 = (FXJPGIcon *) 0 ; FXColor arg2 ;
    FXColor arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXJPGIcon, 1); arg2 = to_FXColor(argv[0]); arg3 = to_FXColor(argv[1]);
    FXJPGIcon_vgradient(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXJPGIcon_gradient(int argc, VALUE *argv, VALUE self) { FXJPGIcon *arg1 = (FXJPGIcon *) 0 ; FXColor arg2 ;
    FXColor arg3 ; FXColor arg4 ; FXColor arg5 ; if ((argc < 4) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXJPGIcon, 1); arg2 = to_FXColor(argv[0]); arg3 = to_FXColor(argv[1]);
    arg4 = to_FXColor(argv[2]); arg5 = to_FXColor(argv[3]); FXJPGIcon_gradient(arg1,arg2,arg3,arg4,arg5); return Qnil; }
static VALUE _wrap_FXJPGIcon_blend(int argc, VALUE *argv, VALUE self) { FXJPGIcon *arg1 = (FXJPGIcon *) 0 ; FXColor arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXJPGIcon, 1); arg2 = to_FXColor(argv[0]); FXJPGIcon_blend(arg1,arg2);
    return Qnil; }
static VALUE _wrap_FXJPGIcon_savePixels(int argc, VALUE *argv, VALUE self) { FXJPGIcon *arg1 = (FXJPGIcon *) 0 ;
    FXStream *arg2 = 0 ; FXbool result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXJPGIcon, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    result = (FXbool)FXJPGIcon_savePixels((FXJPGIcon const *)arg1,*arg2); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXJPGIcon_loadPixels(int argc, VALUE *argv, VALUE self) { FXJPGIcon *arg1 = (FXJPGIcon *) 0 ;
    FXStream *arg2 = 0 ; FXbool result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXJPGIcon, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    result = (FXbool)FXJPGIcon_loadPixels(arg1,*arg2); vresult = result ? Qtrue : Qfalse; return vresult; }
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE _wrap_FXPCXIcon_allocate(VALUE self) {
#else
     static VALUE _wrap_FXPCXIcon_allocate(int argc, VALUE *argv, VALUE self) {
#endif
         VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_FXPCXIcon);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
         return vresult; }
static VALUE _wrap_new_FXPCXIcon(int argc, VALUE *argv, VALUE self) { FXApp *arg1 = (FXApp *) 0 ; void *arg2 = (void *) 0 ;
    FXColor arg3 = (FXColor) 0 ; FXuint arg4 = (FXuint) 0 ; FXint arg5 = (FXint) 1 ; FXint arg6 = (FXint) 1 ; FXPCXIcon *result;
    if ((argc < 1) || (argc > 6)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXApp, 1); if (argc > 1) { { if (argv[1] != Qnil) {
                Check_Type(argv[1], T_STRING); arg2 = reinterpret_cast<void *>(RSTRING(argv[1])->ptr); }  else { arg2 = NULL; }
             }  }  if (argc > 2) { arg3 = to_FXColor(argv[2]); }  if (argc > 3) { arg4 = NUM2UINT(argv[3]); }  if (argc > 4) {
        arg5 = NUM2INT(argv[4]); }  if (argc > 5) { arg6 = NUM2INT(argv[5]); }  {
        result = (FXPCXIcon *)new_FXPCXIcon(arg1,(void const *)arg2,arg3,arg4,arg5,arg6);
        DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result); if(rb_block_given_p()){ rb_yield(self); }  }  return self; }
static void
free_FXPCXIcon(FXPCXIcon *arg1) {
    delete arg1;
}
static VALUE _wrap_FXPCXIcon_save(int argc, VALUE *argv, VALUE self) { FXPCXIcon *arg1 = (FXPCXIcon *) 0 ; FXStream *arg2 = 0 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPCXIcon, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXPCXIcon_save((FXPCXIcon const *)arg1,*arg2); return Qnil; }
static VALUE _wrap_FXPCXIcon_load(int argc, VALUE *argv, VALUE self) { FXPCXIcon *arg1 = (FXPCXIcon *) 0 ; FXStream *arg2 = 0 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPCXIcon, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXPCXIcon_load(arg1,*arg2); return Qnil; }
static VALUE _wrap_FXPCXIcon_create(int argc, VALUE *argv, VALUE self) { FXPCXIcon *arg1 = (FXPCXIcon *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPCXIcon, 1); FXPCXIcon_create(arg1); return Qnil; }
static VALUE _wrap_FXPCXIcon_detach(int argc, VALUE *argv, VALUE self) { FXPCXIcon *arg1 = (FXPCXIcon *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPCXIcon, 1); FXPCXIcon_detach(arg1); return Qnil; }
static VALUE _wrap_FXPCXIcon_destroy(int argc, VALUE *argv, VALUE self) { FXPCXIcon *arg1 = (FXPCXIcon *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPCXIcon, 1); FXPCXIcon_destroy(arg1); return Qnil; }
static VALUE _wrap_FXPCXIcon_resize(int argc, VALUE *argv, VALUE self) { FXPCXIcon *arg1 = (FXPCXIcon *) 0 ; FXint arg2 ;
    FXint arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPCXIcon, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    FXPCXIcon_resize(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXPCXIcon_restore(int argc, VALUE *argv, VALUE self) { FXPCXIcon *arg1 = (FXPCXIcon *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPCXIcon, 1); FXPCXIcon_restore(arg1); return Qnil; }
static VALUE _wrap_FXPCXIcon_render(int argc, VALUE *argv, VALUE self) { FXPCXIcon *arg1 = (FXPCXIcon *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPCXIcon, 1); FXPCXIcon_render(arg1); return Qnil; }
static VALUE _wrap_FXPCXIcon_release(int argc, VALUE *argv, VALUE self) { FXPCXIcon *arg1 = (FXPCXIcon *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPCXIcon, 1); FXPCXIcon_release(arg1); return Qnil; }
static VALUE _wrap_FXPCXIcon_scale(int argc, VALUE *argv, VALUE self) { FXPCXIcon *arg1 = (FXPCXIcon *) 0 ; FXint arg2 ;
    FXint arg3 ; FXint arg4 = (FXint) 0 ; if ((argc < 2) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPCXIcon, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    if (argc > 2) { arg4 = NUM2INT(argv[2]); }  FXPCXIcon_scale(arg1,arg2,arg3,arg4); return Qnil; }
static VALUE _wrap_FXPCXIcon_mirror(int argc, VALUE *argv, VALUE self) { FXPCXIcon *arg1 = (FXPCXIcon *) 0 ; FXbool arg2 ;
    FXbool arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPCXIcon, 1); arg2 = to_FXbool(argv[0]); arg3 = to_FXbool(argv[1]);
    FXPCXIcon_mirror(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXPCXIcon_rotate(int argc, VALUE *argv, VALUE self) { FXPCXIcon *arg1 = (FXPCXIcon *) 0 ; FXint arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPCXIcon, 1); arg2 = NUM2INT(argv[0]); FXPCXIcon_rotate(arg1,arg2);
    return Qnil; }
static VALUE _wrap_FXPCXIcon_crop(int argc, VALUE *argv, VALUE self) { FXPCXIcon *arg1 = (FXPCXIcon *) 0 ; FXint arg2 ;
    FXint arg3 ; FXint arg4 ; FXint arg5 ; if ((argc < 4) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPCXIcon, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    arg4 = NUM2INT(argv[2]); arg5 = NUM2INT(argv[3]); FXPCXIcon_crop(arg1,arg2,arg3,arg4,arg5); return Qnil; }
static VALUE _wrap_FXPCXIcon_fill(int argc, VALUE *argv, VALUE self) { FXPCXIcon *arg1 = (FXPCXIcon *) 0 ; FXColor arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPCXIcon, 1); arg2 = to_FXColor(argv[0]); FXPCXIcon_fill(arg1,arg2);
    return Qnil; }
static VALUE _wrap_FXPCXIcon_fade(int argc, VALUE *argv, VALUE self) { FXPCXIcon *arg1 = (FXPCXIcon *) 0 ; FXColor arg2 ;
    FXint arg3 = (FXint) 255 ; if ((argc < 1) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPCXIcon, 1); arg2 = to_FXColor(argv[0]); if (argc > 1) {
        arg3 = NUM2INT(argv[1]); }  FXPCXIcon_fade(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXPCXIcon_xshear(int argc, VALUE *argv, VALUE self) { FXPCXIcon *arg1 = (FXPCXIcon *) 0 ; FXint arg2 ;
    FXColor arg3 = (FXColor) 0 ; if ((argc < 1) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPCXIcon, 1); arg2 = NUM2INT(argv[0]); if (argc > 1) {
        arg3 = to_FXColor(argv[1]); }  FXPCXIcon_xshear(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXPCXIcon_yshear(int argc, VALUE *argv, VALUE self) { FXPCXIcon *arg1 = (FXPCXIcon *) 0 ; FXint arg2 ;
    FXColor arg3 = (FXColor) 0 ; if ((argc < 1) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPCXIcon, 1); arg2 = NUM2INT(argv[0]); if (argc > 1) {
        arg3 = to_FXColor(argv[1]); }  FXPCXIcon_yshear(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXPCXIcon_hgradient(int argc, VALUE *argv, VALUE self) { FXPCXIcon *arg1 = (FXPCXIcon *) 0 ; FXColor arg2 ;
    FXColor arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPCXIcon, 1); arg2 = to_FXColor(argv[0]); arg3 = to_FXColor(argv[1]);
    FXPCXIcon_hgradient(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXPCXIcon_vgradient(int argc, VALUE *argv, VALUE self) { FXPCXIcon *arg1 = (FXPCXIcon *) 0 ; FXColor arg2 ;
    FXColor arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPCXIcon, 1); arg2 = to_FXColor(argv[0]); arg3 = to_FXColor(argv[1]);
    FXPCXIcon_vgradient(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXPCXIcon_gradient(int argc, VALUE *argv, VALUE self) { FXPCXIcon *arg1 = (FXPCXIcon *) 0 ; FXColor arg2 ;
    FXColor arg3 ; FXColor arg4 ; FXColor arg5 ; if ((argc < 4) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPCXIcon, 1); arg2 = to_FXColor(argv[0]); arg3 = to_FXColor(argv[1]);
    arg4 = to_FXColor(argv[2]); arg5 = to_FXColor(argv[3]); FXPCXIcon_gradient(arg1,arg2,arg3,arg4,arg5); return Qnil; }
static VALUE _wrap_FXPCXIcon_blend(int argc, VALUE *argv, VALUE self) { FXPCXIcon *arg1 = (FXPCXIcon *) 0 ; FXColor arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPCXIcon, 1); arg2 = to_FXColor(argv[0]); FXPCXIcon_blend(arg1,arg2);
    return Qnil; }
static VALUE _wrap_FXPCXIcon_savePixels(int argc, VALUE *argv, VALUE self) { FXPCXIcon *arg1 = (FXPCXIcon *) 0 ;
    FXStream *arg2 = 0 ; FXbool result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPCXIcon, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    result = (FXbool)FXPCXIcon_savePixels((FXPCXIcon const *)arg1,*arg2); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXPCXIcon_loadPixels(int argc, VALUE *argv, VALUE self) { FXPCXIcon *arg1 = (FXPCXIcon *) 0 ;
    FXStream *arg2 = 0 ; FXbool result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPCXIcon, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    result = (FXbool)FXPCXIcon_loadPixels(arg1,*arg2); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_fxloadPCX(int argc, VALUE *argv, VALUE self) { FXStream *arg1 = 0 ; VALUE result; VALUE vresult = Qnil;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXStream, 1); if (arg1 == NULL) rb_raise(rb_eTypeError, "null reference");
    result = (VALUE)fxloadPCX(*arg1); vresult = result; return vresult; }
static VALUE _wrap_fxsavePCX(int argc, VALUE *argv, VALUE self) { FXStream *arg1 = 0 ; FXColor *arg2 = (FXColor *) 0 ;
    FXint arg3 ; FXint arg4 ; FXbool result; VALUE vresult = Qnil; if ((argc < 4) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXStream, 1); if (arg1 == NULL) rb_raise(rb_eTypeError, "null reference");
    { arg2=NULL; if(argv[1]!=Qnil){ Check_Type(argv[1],T_ARRAY); if(FXMALLOC(&arg2,FXColor,RARRAY(argv[1])->len)){
                for(long i=0; i<RARRAY(argv[1])->len; i++){ arg2[i]=static_cast<FXColor>(NUM2UINT(rb_ary_entry(argv[1],i))); }  }
             }  }  arg3 = NUM2INT(argv[2]); arg4 = NUM2INT(argv[3]);
    result = (FXbool)fxsavePCX(*arg1,(FXColor const *)arg2,arg3,arg4); vresult = result ? Qtrue : Qfalse; FXFREE(&arg2);
    return vresult; }
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE _wrap_FXPNGIcon_allocate(VALUE self) {
#else
     static VALUE _wrap_FXPNGIcon_allocate(int argc, VALUE *argv, VALUE self) {
#endif
         VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_FXPNGIcon);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
         return vresult; }
static VALUE _wrap_new_FXPNGIcon(int argc, VALUE *argv, VALUE self) { FXApp *arg1 = (FXApp *) 0 ; void *arg2 = (void *) 0 ;
    FXColor arg3 = (FXColor) 0 ; FXuint arg4 = (FXuint) 0 ; FXint arg5 = (FXint) 1 ; FXint arg6 = (FXint) 1 ; FXPNGIcon *result;
    if ((argc < 1) || (argc > 6)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXApp, 1); if (argc > 1) { { if (argv[1] != Qnil) {
                Check_Type(argv[1], T_STRING); arg2 = reinterpret_cast<void *>(RSTRING(argv[1])->ptr); }  else { arg2 = NULL; }
             }  }  if (argc > 2) { arg3 = to_FXColor(argv[2]); }  if (argc > 3) { arg4 = NUM2UINT(argv[3]); }  if (argc > 4) {
        arg5 = NUM2INT(argv[4]); }  if (argc > 5) { arg6 = NUM2INT(argv[5]); }  {
        result = (FXPNGIcon *)new_FXPNGIcon(arg1,(void const *)arg2,arg3,arg4,arg5,arg6);
        DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result); if(rb_block_given_p()){ rb_yield(self); }  }  return self; }
static void
free_FXPNGIcon(FXPNGIcon *arg1) {
    delete arg1;
}
static VALUE _wrap_FXPNGIcon_save(int argc, VALUE *argv, VALUE self) { FXPNGIcon *arg1 = (FXPNGIcon *) 0 ; FXStream *arg2 = 0 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPNGIcon, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXPNGIcon_save((FXPNGIcon const *)arg1,*arg2); return Qnil; }
static VALUE _wrap_FXPNGIcon_load(int argc, VALUE *argv, VALUE self) { FXPNGIcon *arg1 = (FXPNGIcon *) 0 ; FXStream *arg2 = 0 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPNGIcon, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXPNGIcon_load(arg1,*arg2); return Qnil; }
static VALUE _wrap_FXPNGIcon_create(int argc, VALUE *argv, VALUE self) { FXPNGIcon *arg1 = (FXPNGIcon *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPNGIcon, 1); FXPNGIcon_create(arg1); return Qnil; }
static VALUE _wrap_FXPNGIcon_detach(int argc, VALUE *argv, VALUE self) { FXPNGIcon *arg1 = (FXPNGIcon *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPNGIcon, 1); FXPNGIcon_detach(arg1); return Qnil; }
static VALUE _wrap_FXPNGIcon_destroy(int argc, VALUE *argv, VALUE self) { FXPNGIcon *arg1 = (FXPNGIcon *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPNGIcon, 1); FXPNGIcon_destroy(arg1); return Qnil; }
static VALUE _wrap_FXPNGIcon_resize(int argc, VALUE *argv, VALUE self) { FXPNGIcon *arg1 = (FXPNGIcon *) 0 ; FXint arg2 ;
    FXint arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPNGIcon, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    FXPNGIcon_resize(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXPNGIcon_restore(int argc, VALUE *argv, VALUE self) { FXPNGIcon *arg1 = (FXPNGIcon *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPNGIcon, 1); FXPNGIcon_restore(arg1); return Qnil; }
static VALUE _wrap_FXPNGIcon_render(int argc, VALUE *argv, VALUE self) { FXPNGIcon *arg1 = (FXPNGIcon *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPNGIcon, 1); FXPNGIcon_render(arg1); return Qnil; }
static VALUE _wrap_FXPNGIcon_release(int argc, VALUE *argv, VALUE self) { FXPNGIcon *arg1 = (FXPNGIcon *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPNGIcon, 1); FXPNGIcon_release(arg1); return Qnil; }
static VALUE _wrap_FXPNGIcon_scale(int argc, VALUE *argv, VALUE self) { FXPNGIcon *arg1 = (FXPNGIcon *) 0 ; FXint arg2 ;
    FXint arg3 ; FXint arg4 = (FXint) 0 ; if ((argc < 2) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPNGIcon, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    if (argc > 2) { arg4 = NUM2INT(argv[2]); }  FXPNGIcon_scale(arg1,arg2,arg3,arg4); return Qnil; }
static VALUE _wrap_FXPNGIcon_mirror(int argc, VALUE *argv, VALUE self) { FXPNGIcon *arg1 = (FXPNGIcon *) 0 ; FXbool arg2 ;
    FXbool arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPNGIcon, 1); arg2 = to_FXbool(argv[0]); arg3 = to_FXbool(argv[1]);
    FXPNGIcon_mirror(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXPNGIcon_rotate(int argc, VALUE *argv, VALUE self) { FXPNGIcon *arg1 = (FXPNGIcon *) 0 ; FXint arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPNGIcon, 1); arg2 = NUM2INT(argv[0]); FXPNGIcon_rotate(arg1,arg2);
    return Qnil; }
static VALUE _wrap_FXPNGIcon_crop(int argc, VALUE *argv, VALUE self) { FXPNGIcon *arg1 = (FXPNGIcon *) 0 ; FXint arg2 ;
    FXint arg3 ; FXint arg4 ; FXint arg5 ; if ((argc < 4) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPNGIcon, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    arg4 = NUM2INT(argv[2]); arg5 = NUM2INT(argv[3]); FXPNGIcon_crop(arg1,arg2,arg3,arg4,arg5); return Qnil; }
static VALUE _wrap_FXPNGIcon_fill(int argc, VALUE *argv, VALUE self) { FXPNGIcon *arg1 = (FXPNGIcon *) 0 ; FXColor arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPNGIcon, 1); arg2 = to_FXColor(argv[0]); FXPNGIcon_fill(arg1,arg2);
    return Qnil; }
static VALUE _wrap_FXPNGIcon_fade(int argc, VALUE *argv, VALUE self) { FXPNGIcon *arg1 = (FXPNGIcon *) 0 ; FXColor arg2 ;
    FXint arg3 = (FXint) 255 ; if ((argc < 1) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPNGIcon, 1); arg2 = to_FXColor(argv[0]); if (argc > 1) {
        arg3 = NUM2INT(argv[1]); }  FXPNGIcon_fade(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXPNGIcon_xshear(int argc, VALUE *argv, VALUE self) { FXPNGIcon *arg1 = (FXPNGIcon *) 0 ; FXint arg2 ;
    FXColor arg3 = (FXColor) 0 ; if ((argc < 1) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPNGIcon, 1); arg2 = NUM2INT(argv[0]); if (argc > 1) {
        arg3 = to_FXColor(argv[1]); }  FXPNGIcon_xshear(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXPNGIcon_yshear(int argc, VALUE *argv, VALUE self) { FXPNGIcon *arg1 = (FXPNGIcon *) 0 ; FXint arg2 ;
    FXColor arg3 = (FXColor) 0 ; if ((argc < 1) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPNGIcon, 1); arg2 = NUM2INT(argv[0]); if (argc > 1) {
        arg3 = to_FXColor(argv[1]); }  FXPNGIcon_yshear(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXPNGIcon_hgradient(int argc, VALUE *argv, VALUE self) { FXPNGIcon *arg1 = (FXPNGIcon *) 0 ; FXColor arg2 ;
    FXColor arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPNGIcon, 1); arg2 = to_FXColor(argv[0]); arg3 = to_FXColor(argv[1]);
    FXPNGIcon_hgradient(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXPNGIcon_vgradient(int argc, VALUE *argv, VALUE self) { FXPNGIcon *arg1 = (FXPNGIcon *) 0 ; FXColor arg2 ;
    FXColor arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPNGIcon, 1); arg2 = to_FXColor(argv[0]); arg3 = to_FXColor(argv[1]);
    FXPNGIcon_vgradient(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXPNGIcon_gradient(int argc, VALUE *argv, VALUE self) { FXPNGIcon *arg1 = (FXPNGIcon *) 0 ; FXColor arg2 ;
    FXColor arg3 ; FXColor arg4 ; FXColor arg5 ; if ((argc < 4) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPNGIcon, 1); arg2 = to_FXColor(argv[0]); arg3 = to_FXColor(argv[1]);
    arg4 = to_FXColor(argv[2]); arg5 = to_FXColor(argv[3]); FXPNGIcon_gradient(arg1,arg2,arg3,arg4,arg5); return Qnil; }
static VALUE _wrap_FXPNGIcon_blend(int argc, VALUE *argv, VALUE self) { FXPNGIcon *arg1 = (FXPNGIcon *) 0 ; FXColor arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPNGIcon, 1); arg2 = to_FXColor(argv[0]); FXPNGIcon_blend(arg1,arg2);
    return Qnil; }
static VALUE _wrap_FXPNGIcon_savePixels(int argc, VALUE *argv, VALUE self) { FXPNGIcon *arg1 = (FXPNGIcon *) 0 ;
    FXStream *arg2 = 0 ; FXbool result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPNGIcon, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    result = (FXbool)FXPNGIcon_savePixels((FXPNGIcon const *)arg1,*arg2); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXPNGIcon_loadPixels(int argc, VALUE *argv, VALUE self) { FXPNGIcon *arg1 = (FXPNGIcon *) 0 ;
    FXStream *arg2 = 0 ; FXbool result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPNGIcon, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    result = (FXbool)FXPNGIcon_loadPixels(arg1,*arg2); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_fxloadPNG(int argc, VALUE *argv, VALUE self) { FXStream *arg1 = 0 ; VALUE result; VALUE vresult = Qnil;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXStream, 1); if (arg1 == NULL) rb_raise(rb_eTypeError, "null reference");
    result = (VALUE)fxloadPNG(*arg1); vresult = result; return vresult; }
static VALUE _wrap_fxsavePNG(int argc, VALUE *argv, VALUE self) { FXStream *arg1 = 0 ; FXColor *arg2 = (FXColor *) 0 ;
    FXint arg3 ; FXint arg4 ; FXbool result; VALUE vresult = Qnil; if ((argc < 4) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXStream, 1); if (arg1 == NULL) rb_raise(rb_eTypeError, "null reference");
    { arg2=NULL; if(argv[1]!=Qnil){ Check_Type(argv[1],T_ARRAY); if(FXMALLOC(&arg2,FXColor,RARRAY(argv[1])->len)){
                for(long i=0; i<RARRAY(argv[1])->len; i++){ arg2[i]=static_cast<FXColor>(NUM2UINT(rb_ary_entry(argv[1],i))); }  }
             }  }  arg3 = NUM2INT(argv[2]); arg4 = NUM2INT(argv[3]);
    result = (FXbool)fxsavePNG(*arg1,(FXColor const *)arg2,arg3,arg4); vresult = result ? Qtrue : Qfalse; FXFREE(&arg2);
    return vresult; }
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE _wrap_FXPPMIcon_allocate(VALUE self) {
#else
     static VALUE _wrap_FXPPMIcon_allocate(int argc, VALUE *argv, VALUE self) {
#endif
         VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_FXPPMIcon);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
         return vresult; }
static VALUE _wrap_new_FXPPMIcon(int argc, VALUE *argv, VALUE self) { FXApp *arg1 = (FXApp *) 0 ; void *arg2 = (void *) 0 ;
    FXColor arg3 = (FXColor) FXRGB(192,192,192) ; FXuint arg4 = (FXuint) 0 ; FXint arg5 = (FXint) 1 ; FXint arg6 = (FXint) 1 ;
    FXPPMIcon *result; if ((argc < 1) || (argc > 6)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXApp, 1); if (argc > 1) { { if (argv[1] != Qnil) {
                Check_Type(argv[1], T_STRING); arg2 = reinterpret_cast<void *>(RSTRING(argv[1])->ptr); }  else { arg2 = NULL; }
             }  }  if (argc > 2) { arg3 = to_FXColor(argv[2]); }  if (argc > 3) { arg4 = NUM2UINT(argv[3]); }  if (argc > 4) {
        arg5 = NUM2INT(argv[4]); }  if (argc > 5) { arg6 = NUM2INT(argv[5]); }  {
        result = (FXPPMIcon *)new_FXPPMIcon(arg1,(void const *)arg2,arg3,arg4,arg5,arg6);
        DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result); if(rb_block_given_p()){ rb_yield(self); }  }  return self; }
static void
free_FXPPMIcon(FXPPMIcon *arg1) {
    delete arg1;
}
static VALUE _wrap_FXPPMIcon_save(int argc, VALUE *argv, VALUE self) { FXPPMIcon *arg1 = (FXPPMIcon *) 0 ; FXStream *arg2 = 0 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPPMIcon, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXPPMIcon_save((FXPPMIcon const *)arg1,*arg2); return Qnil; }
static VALUE _wrap_FXPPMIcon_load(int argc, VALUE *argv, VALUE self) { FXPPMIcon *arg1 = (FXPPMIcon *) 0 ; FXStream *arg2 = 0 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPPMIcon, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXPPMIcon_load(arg1,*arg2); return Qnil; }
static VALUE _wrap_FXPPMIcon_create(int argc, VALUE *argv, VALUE self) { FXPPMIcon *arg1 = (FXPPMIcon *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPPMIcon, 1); FXPPMIcon_create(arg1); return Qnil; }
static VALUE _wrap_FXPPMIcon_detach(int argc, VALUE *argv, VALUE self) { FXPPMIcon *arg1 = (FXPPMIcon *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPPMIcon, 1); FXPPMIcon_detach(arg1); return Qnil; }
static VALUE _wrap_FXPPMIcon_destroy(int argc, VALUE *argv, VALUE self) { FXPPMIcon *arg1 = (FXPPMIcon *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPPMIcon, 1); FXPPMIcon_destroy(arg1); return Qnil; }
static VALUE _wrap_FXPPMIcon_resize(int argc, VALUE *argv, VALUE self) { FXPPMIcon *arg1 = (FXPPMIcon *) 0 ; FXint arg2 ;
    FXint arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPPMIcon, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    FXPPMIcon_resize(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXPPMIcon_restore(int argc, VALUE *argv, VALUE self) { FXPPMIcon *arg1 = (FXPPMIcon *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPPMIcon, 1); FXPPMIcon_restore(arg1); return Qnil; }
static VALUE _wrap_FXPPMIcon_render(int argc, VALUE *argv, VALUE self) { FXPPMIcon *arg1 = (FXPPMIcon *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPPMIcon, 1); FXPPMIcon_render(arg1); return Qnil; }
static VALUE _wrap_FXPPMIcon_release(int argc, VALUE *argv, VALUE self) { FXPPMIcon *arg1 = (FXPPMIcon *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPPMIcon, 1); FXPPMIcon_release(arg1); return Qnil; }
static VALUE _wrap_FXPPMIcon_scale(int argc, VALUE *argv, VALUE self) { FXPPMIcon *arg1 = (FXPPMIcon *) 0 ; FXint arg2 ;
    FXint arg3 ; FXint arg4 = (FXint) 0 ; if ((argc < 2) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPPMIcon, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    if (argc > 2) { arg4 = NUM2INT(argv[2]); }  FXPPMIcon_scale(arg1,arg2,arg3,arg4); return Qnil; }
static VALUE _wrap_FXPPMIcon_mirror(int argc, VALUE *argv, VALUE self) { FXPPMIcon *arg1 = (FXPPMIcon *) 0 ; FXbool arg2 ;
    FXbool arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPPMIcon, 1); arg2 = to_FXbool(argv[0]); arg3 = to_FXbool(argv[1]);
    FXPPMIcon_mirror(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXPPMIcon_rotate(int argc, VALUE *argv, VALUE self) { FXPPMIcon *arg1 = (FXPPMIcon *) 0 ; FXint arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPPMIcon, 1); arg2 = NUM2INT(argv[0]); FXPPMIcon_rotate(arg1,arg2);
    return Qnil; }
static VALUE _wrap_FXPPMIcon_crop(int argc, VALUE *argv, VALUE self) { FXPPMIcon *arg1 = (FXPPMIcon *) 0 ; FXint arg2 ;
    FXint arg3 ; FXint arg4 ; FXint arg5 ; if ((argc < 4) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPPMIcon, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    arg4 = NUM2INT(argv[2]); arg5 = NUM2INT(argv[3]); FXPPMIcon_crop(arg1,arg2,arg3,arg4,arg5); return Qnil; }
static VALUE _wrap_FXPPMIcon_fill(int argc, VALUE *argv, VALUE self) { FXPPMIcon *arg1 = (FXPPMIcon *) 0 ; FXColor arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPPMIcon, 1); arg2 = to_FXColor(argv[0]); FXPPMIcon_fill(arg1,arg2);
    return Qnil; }
static VALUE _wrap_FXPPMIcon_fade(int argc, VALUE *argv, VALUE self) { FXPPMIcon *arg1 = (FXPPMIcon *) 0 ; FXColor arg2 ;
    FXint arg3 = (FXint) 255 ; if ((argc < 1) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPPMIcon, 1); arg2 = to_FXColor(argv[0]); if (argc > 1) {
        arg3 = NUM2INT(argv[1]); }  FXPPMIcon_fade(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXPPMIcon_xshear(int argc, VALUE *argv, VALUE self) { FXPPMIcon *arg1 = (FXPPMIcon *) 0 ; FXint arg2 ;
    FXColor arg3 = (FXColor) 0 ; if ((argc < 1) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPPMIcon, 1); arg2 = NUM2INT(argv[0]); if (argc > 1) {
        arg3 = to_FXColor(argv[1]); }  FXPPMIcon_xshear(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXPPMIcon_yshear(int argc, VALUE *argv, VALUE self) { FXPPMIcon *arg1 = (FXPPMIcon *) 0 ; FXint arg2 ;
    FXColor arg3 = (FXColor) 0 ; if ((argc < 1) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPPMIcon, 1); arg2 = NUM2INT(argv[0]); if (argc > 1) {
        arg3 = to_FXColor(argv[1]); }  FXPPMIcon_yshear(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXPPMIcon_hgradient(int argc, VALUE *argv, VALUE self) { FXPPMIcon *arg1 = (FXPPMIcon *) 0 ; FXColor arg2 ;
    FXColor arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPPMIcon, 1); arg2 = to_FXColor(argv[0]); arg3 = to_FXColor(argv[1]);
    FXPPMIcon_hgradient(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXPPMIcon_vgradient(int argc, VALUE *argv, VALUE self) { FXPPMIcon *arg1 = (FXPPMIcon *) 0 ; FXColor arg2 ;
    FXColor arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPPMIcon, 1); arg2 = to_FXColor(argv[0]); arg3 = to_FXColor(argv[1]);
    FXPPMIcon_vgradient(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXPPMIcon_gradient(int argc, VALUE *argv, VALUE self) { FXPPMIcon *arg1 = (FXPPMIcon *) 0 ; FXColor arg2 ;
    FXColor arg3 ; FXColor arg4 ; FXColor arg5 ; if ((argc < 4) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPPMIcon, 1); arg2 = to_FXColor(argv[0]); arg3 = to_FXColor(argv[1]);
    arg4 = to_FXColor(argv[2]); arg5 = to_FXColor(argv[3]); FXPPMIcon_gradient(arg1,arg2,arg3,arg4,arg5); return Qnil; }
static VALUE _wrap_FXPPMIcon_blend(int argc, VALUE *argv, VALUE self) { FXPPMIcon *arg1 = (FXPPMIcon *) 0 ; FXColor arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPPMIcon, 1); arg2 = to_FXColor(argv[0]); FXPPMIcon_blend(arg1,arg2);
    return Qnil; }
static VALUE _wrap_FXPPMIcon_savePixels(int argc, VALUE *argv, VALUE self) { FXPPMIcon *arg1 = (FXPPMIcon *) 0 ;
    FXStream *arg2 = 0 ; FXbool result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPPMIcon, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    result = (FXbool)FXPPMIcon_savePixels((FXPPMIcon const *)arg1,*arg2); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXPPMIcon_loadPixels(int argc, VALUE *argv, VALUE self) { FXPPMIcon *arg1 = (FXPPMIcon *) 0 ;
    FXStream *arg2 = 0 ; FXbool result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPPMIcon, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    result = (FXbool)FXPPMIcon_loadPixels(arg1,*arg2); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_fxloadPPM(int argc, VALUE *argv, VALUE self) { FXStream *arg1 = 0 ; VALUE result; VALUE vresult = Qnil;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXStream, 1); if (arg1 == NULL) rb_raise(rb_eTypeError, "null reference");
    result = (VALUE)fxloadPPM(*arg1); vresult = result; return vresult; }
static VALUE _wrap_fxsavePPM(int argc, VALUE *argv, VALUE self) { FXStream *arg1 = 0 ; FXColor *arg2 = (FXColor *) 0 ;
    FXint arg3 ; FXint arg4 ; FXbool result; VALUE vresult = Qnil; if ((argc < 4) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXStream, 1); if (arg1 == NULL) rb_raise(rb_eTypeError, "null reference");
    { arg2=NULL; if(argv[1]!=Qnil){ Check_Type(argv[1],T_ARRAY); if(FXMALLOC(&arg2,FXColor,RARRAY(argv[1])->len)){
                for(long i=0; i<RARRAY(argv[1])->len; i++){ arg2[i]=static_cast<FXColor>(NUM2UINT(rb_ary_entry(argv[1],i))); }  }
             }  }  arg3 = NUM2INT(argv[2]); arg4 = NUM2INT(argv[3]);
    result = (FXbool)fxsavePPM(*arg1,(FXColor const *)arg2,arg3,arg4); vresult = result ? Qtrue : Qfalse; FXFREE(&arg2);
    return vresult; }
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE _wrap_FXRGBIcon_allocate(VALUE self) {
#else
     static VALUE _wrap_FXRGBIcon_allocate(int argc, VALUE *argv, VALUE self) {
#endif
         VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_FXRGBIcon);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
         return vresult; }
static VALUE _wrap_new_FXRGBIcon(int argc, VALUE *argv, VALUE self) { FXApp *arg1 = (FXApp *) 0 ; void *arg2 = (void *) 0 ;
    FXColor arg3 = (FXColor) 0 ; FXuint arg4 = (FXuint) 0 ; FXint arg5 = (FXint) 1 ; FXint arg6 = (FXint) 1 ; FXRGBIcon *result;
    if ((argc < 1) || (argc > 6)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXApp, 1); if (argc > 1) { { if (argv[1] != Qnil) {
                Check_Type(argv[1], T_STRING); arg2 = reinterpret_cast<void *>(RSTRING(argv[1])->ptr); }  else { arg2 = NULL; }
             }  }  if (argc > 2) { arg3 = to_FXColor(argv[2]); }  if (argc > 3) { arg4 = NUM2UINT(argv[3]); }  if (argc > 4) {
        arg5 = NUM2INT(argv[4]); }  if (argc > 5) { arg6 = NUM2INT(argv[5]); }  {
        result = (FXRGBIcon *)new_FXRGBIcon(arg1,(void const *)arg2,arg3,arg4,arg5,arg6);
        DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result); if(rb_block_given_p()){ rb_yield(self); }  }  return self; }
static void
free_FXRGBIcon(FXRGBIcon *arg1) {
    delete arg1;
}
static VALUE _wrap_FXRGBIcon_save(int argc, VALUE *argv, VALUE self) { FXRGBIcon *arg1 = (FXRGBIcon *) 0 ; FXStream *arg2 = 0 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRGBIcon, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXRGBIcon_save((FXRGBIcon const *)arg1,*arg2); return Qnil; }
static VALUE _wrap_FXRGBIcon_load(int argc, VALUE *argv, VALUE self) { FXRGBIcon *arg1 = (FXRGBIcon *) 0 ; FXStream *arg2 = 0 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRGBIcon, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXRGBIcon_load(arg1,*arg2); return Qnil; }
static VALUE _wrap_FXRGBIcon_create(int argc, VALUE *argv, VALUE self) { FXRGBIcon *arg1 = (FXRGBIcon *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRGBIcon, 1); FXRGBIcon_create(arg1); return Qnil; }
static VALUE _wrap_FXRGBIcon_detach(int argc, VALUE *argv, VALUE self) { FXRGBIcon *arg1 = (FXRGBIcon *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRGBIcon, 1); FXRGBIcon_detach(arg1); return Qnil; }
static VALUE _wrap_FXRGBIcon_destroy(int argc, VALUE *argv, VALUE self) { FXRGBIcon *arg1 = (FXRGBIcon *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRGBIcon, 1); FXRGBIcon_destroy(arg1); return Qnil; }
static VALUE _wrap_FXRGBIcon_resize(int argc, VALUE *argv, VALUE self) { FXRGBIcon *arg1 = (FXRGBIcon *) 0 ; FXint arg2 ;
    FXint arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRGBIcon, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    FXRGBIcon_resize(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXRGBIcon_restore(int argc, VALUE *argv, VALUE self) { FXRGBIcon *arg1 = (FXRGBIcon *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRGBIcon, 1); FXRGBIcon_restore(arg1); return Qnil; }
static VALUE _wrap_FXRGBIcon_render(int argc, VALUE *argv, VALUE self) { FXRGBIcon *arg1 = (FXRGBIcon *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRGBIcon, 1); FXRGBIcon_render(arg1); return Qnil; }
static VALUE _wrap_FXRGBIcon_release(int argc, VALUE *argv, VALUE self) { FXRGBIcon *arg1 = (FXRGBIcon *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRGBIcon, 1); FXRGBIcon_release(arg1); return Qnil; }
static VALUE _wrap_FXRGBIcon_scale(int argc, VALUE *argv, VALUE self) { FXRGBIcon *arg1 = (FXRGBIcon *) 0 ; FXint arg2 ;
    FXint arg3 ; FXint arg4 = (FXint) 0 ; if ((argc < 2) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRGBIcon, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    if (argc > 2) { arg4 = NUM2INT(argv[2]); }  FXRGBIcon_scale(arg1,arg2,arg3,arg4); return Qnil; }
static VALUE _wrap_FXRGBIcon_mirror(int argc, VALUE *argv, VALUE self) { FXRGBIcon *arg1 = (FXRGBIcon *) 0 ; FXbool arg2 ;
    FXbool arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRGBIcon, 1); arg2 = to_FXbool(argv[0]); arg3 = to_FXbool(argv[1]);
    FXRGBIcon_mirror(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXRGBIcon_rotate(int argc, VALUE *argv, VALUE self) { FXRGBIcon *arg1 = (FXRGBIcon *) 0 ; FXint arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRGBIcon, 1); arg2 = NUM2INT(argv[0]); FXRGBIcon_rotate(arg1,arg2);
    return Qnil; }
static VALUE _wrap_FXRGBIcon_crop(int argc, VALUE *argv, VALUE self) { FXRGBIcon *arg1 = (FXRGBIcon *) 0 ; FXint arg2 ;
    FXint arg3 ; FXint arg4 ; FXint arg5 ; if ((argc < 4) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRGBIcon, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    arg4 = NUM2INT(argv[2]); arg5 = NUM2INT(argv[3]); FXRGBIcon_crop(arg1,arg2,arg3,arg4,arg5); return Qnil; }
static VALUE _wrap_FXRGBIcon_fill(int argc, VALUE *argv, VALUE self) { FXRGBIcon *arg1 = (FXRGBIcon *) 0 ; FXColor arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRGBIcon, 1); arg2 = to_FXColor(argv[0]); FXRGBIcon_fill(arg1,arg2);
    return Qnil; }
static VALUE _wrap_FXRGBIcon_fade(int argc, VALUE *argv, VALUE self) { FXRGBIcon *arg1 = (FXRGBIcon *) 0 ; FXColor arg2 ;
    FXint arg3 = (FXint) 255 ; if ((argc < 1) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRGBIcon, 1); arg2 = to_FXColor(argv[0]); if (argc > 1) {
        arg3 = NUM2INT(argv[1]); }  FXRGBIcon_fade(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXRGBIcon_xshear(int argc, VALUE *argv, VALUE self) { FXRGBIcon *arg1 = (FXRGBIcon *) 0 ; FXint arg2 ;
    FXColor arg3 = (FXColor) 0 ; if ((argc < 1) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRGBIcon, 1); arg2 = NUM2INT(argv[0]); if (argc > 1) {
        arg3 = to_FXColor(argv[1]); }  FXRGBIcon_xshear(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXRGBIcon_yshear(int argc, VALUE *argv, VALUE self) { FXRGBIcon *arg1 = (FXRGBIcon *) 0 ; FXint arg2 ;
    FXColor arg3 = (FXColor) 0 ; if ((argc < 1) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRGBIcon, 1); arg2 = NUM2INT(argv[0]); if (argc > 1) {
        arg3 = to_FXColor(argv[1]); }  FXRGBIcon_yshear(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXRGBIcon_hgradient(int argc, VALUE *argv, VALUE self) { FXRGBIcon *arg1 = (FXRGBIcon *) 0 ; FXColor arg2 ;
    FXColor arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRGBIcon, 1); arg2 = to_FXColor(argv[0]); arg3 = to_FXColor(argv[1]);
    FXRGBIcon_hgradient(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXRGBIcon_vgradient(int argc, VALUE *argv, VALUE self) { FXRGBIcon *arg1 = (FXRGBIcon *) 0 ; FXColor arg2 ;
    FXColor arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRGBIcon, 1); arg2 = to_FXColor(argv[0]); arg3 = to_FXColor(argv[1]);
    FXRGBIcon_vgradient(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXRGBIcon_gradient(int argc, VALUE *argv, VALUE self) { FXRGBIcon *arg1 = (FXRGBIcon *) 0 ; FXColor arg2 ;
    FXColor arg3 ; FXColor arg4 ; FXColor arg5 ; if ((argc < 4) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRGBIcon, 1); arg2 = to_FXColor(argv[0]); arg3 = to_FXColor(argv[1]);
    arg4 = to_FXColor(argv[2]); arg5 = to_FXColor(argv[3]); FXRGBIcon_gradient(arg1,arg2,arg3,arg4,arg5); return Qnil; }
static VALUE _wrap_FXRGBIcon_blend(int argc, VALUE *argv, VALUE self) { FXRGBIcon *arg1 = (FXRGBIcon *) 0 ; FXColor arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRGBIcon, 1); arg2 = to_FXColor(argv[0]); FXRGBIcon_blend(arg1,arg2);
    return Qnil; }
static VALUE _wrap_FXRGBIcon_savePixels(int argc, VALUE *argv, VALUE self) { FXRGBIcon *arg1 = (FXRGBIcon *) 0 ;
    FXStream *arg2 = 0 ; FXbool result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRGBIcon, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    result = (FXbool)FXRGBIcon_savePixels((FXRGBIcon const *)arg1,*arg2); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXRGBIcon_loadPixels(int argc, VALUE *argv, VALUE self) { FXRGBIcon *arg1 = (FXRGBIcon *) 0 ;
    FXStream *arg2 = 0 ; FXbool result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXRGBIcon, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    result = (FXbool)FXRGBIcon_loadPixels(arg1,*arg2); vresult = result ? Qtrue : Qfalse; return vresult; }
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE _wrap_FXTGAIcon_allocate(VALUE self) {
#else
     static VALUE _wrap_FXTGAIcon_allocate(int argc, VALUE *argv, VALUE self) {
#endif
         VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_FXTGAIcon);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
         return vresult; }
static VALUE _wrap_new_FXTGAIcon(int argc, VALUE *argv, VALUE self) { FXApp *arg1 = (FXApp *) 0 ; void *arg2 = (void *) 0 ;
    FXColor arg3 = (FXColor) 0 ; FXuint arg4 = (FXuint) 0 ; FXint arg5 = (FXint) 1 ; FXint arg6 = (FXint) 1 ; FXTGAIcon *result;
    if ((argc < 1) || (argc > 6)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXApp, 1); if (argc > 1) { { if (argv[1] != Qnil) {
                Check_Type(argv[1], T_STRING); arg2 = reinterpret_cast<void *>(RSTRING(argv[1])->ptr); }  else { arg2 = NULL; }
             }  }  if (argc > 2) { arg3 = to_FXColor(argv[2]); }  if (argc > 3) { arg4 = NUM2UINT(argv[3]); }  if (argc > 4) {
        arg5 = NUM2INT(argv[4]); }  if (argc > 5) { arg6 = NUM2INT(argv[5]); }  {
        result = (FXTGAIcon *)new_FXTGAIcon(arg1,(void const *)arg2,arg3,arg4,arg5,arg6);
        DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result); if(rb_block_given_p()){ rb_yield(self); }  }  return self; }
static void
free_FXTGAIcon(FXTGAIcon *arg1) {
    delete arg1;
}
static VALUE _wrap_FXTGAIcon_save(int argc, VALUE *argv, VALUE self) { FXTGAIcon *arg1 = (FXTGAIcon *) 0 ; FXStream *arg2 = 0 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTGAIcon, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXTGAIcon_save((FXTGAIcon const *)arg1,*arg2); return Qnil; }
static VALUE _wrap_FXTGAIcon_load(int argc, VALUE *argv, VALUE self) { FXTGAIcon *arg1 = (FXTGAIcon *) 0 ; FXStream *arg2 = 0 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTGAIcon, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXTGAIcon_load(arg1,*arg2); return Qnil; }
static VALUE _wrap_FXTGAIcon_create(int argc, VALUE *argv, VALUE self) { FXTGAIcon *arg1 = (FXTGAIcon *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTGAIcon, 1); FXTGAIcon_create(arg1); return Qnil; }
static VALUE _wrap_FXTGAIcon_detach(int argc, VALUE *argv, VALUE self) { FXTGAIcon *arg1 = (FXTGAIcon *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTGAIcon, 1); FXTGAIcon_detach(arg1); return Qnil; }
static VALUE _wrap_FXTGAIcon_destroy(int argc, VALUE *argv, VALUE self) { FXTGAIcon *arg1 = (FXTGAIcon *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTGAIcon, 1); FXTGAIcon_destroy(arg1); return Qnil; }
static VALUE _wrap_FXTGAIcon_resize(int argc, VALUE *argv, VALUE self) { FXTGAIcon *arg1 = (FXTGAIcon *) 0 ; FXint arg2 ;
    FXint arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTGAIcon, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    FXTGAIcon_resize(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXTGAIcon_restore(int argc, VALUE *argv, VALUE self) { FXTGAIcon *arg1 = (FXTGAIcon *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTGAIcon, 1); FXTGAIcon_restore(arg1); return Qnil; }
static VALUE _wrap_FXTGAIcon_render(int argc, VALUE *argv, VALUE self) { FXTGAIcon *arg1 = (FXTGAIcon *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTGAIcon, 1); FXTGAIcon_render(arg1); return Qnil; }
static VALUE _wrap_FXTGAIcon_release(int argc, VALUE *argv, VALUE self) { FXTGAIcon *arg1 = (FXTGAIcon *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTGAIcon, 1); FXTGAIcon_release(arg1); return Qnil; }
static VALUE _wrap_FXTGAIcon_scale(int argc, VALUE *argv, VALUE self) { FXTGAIcon *arg1 = (FXTGAIcon *) 0 ; FXint arg2 ;
    FXint arg3 ; FXint arg4 = (FXint) 0 ; if ((argc < 2) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTGAIcon, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    if (argc > 2) { arg4 = NUM2INT(argv[2]); }  FXTGAIcon_scale(arg1,arg2,arg3,arg4); return Qnil; }
static VALUE _wrap_FXTGAIcon_mirror(int argc, VALUE *argv, VALUE self) { FXTGAIcon *arg1 = (FXTGAIcon *) 0 ; FXbool arg2 ;
    FXbool arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTGAIcon, 1); arg2 = to_FXbool(argv[0]); arg3 = to_FXbool(argv[1]);
    FXTGAIcon_mirror(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXTGAIcon_rotate(int argc, VALUE *argv, VALUE self) { FXTGAIcon *arg1 = (FXTGAIcon *) 0 ; FXint arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTGAIcon, 1); arg2 = NUM2INT(argv[0]); FXTGAIcon_rotate(arg1,arg2);
    return Qnil; }
static VALUE _wrap_FXTGAIcon_crop(int argc, VALUE *argv, VALUE self) { FXTGAIcon *arg1 = (FXTGAIcon *) 0 ; FXint arg2 ;
    FXint arg3 ; FXint arg4 ; FXint arg5 ; if ((argc < 4) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTGAIcon, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    arg4 = NUM2INT(argv[2]); arg5 = NUM2INT(argv[3]); FXTGAIcon_crop(arg1,arg2,arg3,arg4,arg5); return Qnil; }
static VALUE _wrap_FXTGAIcon_fill(int argc, VALUE *argv, VALUE self) { FXTGAIcon *arg1 = (FXTGAIcon *) 0 ; FXColor arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTGAIcon, 1); arg2 = to_FXColor(argv[0]); FXTGAIcon_fill(arg1,arg2);
    return Qnil; }
static VALUE _wrap_FXTGAIcon_fade(int argc, VALUE *argv, VALUE self) { FXTGAIcon *arg1 = (FXTGAIcon *) 0 ; FXColor arg2 ;
    FXint arg3 = (FXint) 255 ; if ((argc < 1) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTGAIcon, 1); arg2 = to_FXColor(argv[0]); if (argc > 1) {
        arg3 = NUM2INT(argv[1]); }  FXTGAIcon_fade(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXTGAIcon_xshear(int argc, VALUE *argv, VALUE self) { FXTGAIcon *arg1 = (FXTGAIcon *) 0 ; FXint arg2 ;
    FXColor arg3 = (FXColor) 0 ; if ((argc < 1) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTGAIcon, 1); arg2 = NUM2INT(argv[0]); if (argc > 1) {
        arg3 = to_FXColor(argv[1]); }  FXTGAIcon_xshear(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXTGAIcon_yshear(int argc, VALUE *argv, VALUE self) { FXTGAIcon *arg1 = (FXTGAIcon *) 0 ; FXint arg2 ;
    FXColor arg3 = (FXColor) 0 ; if ((argc < 1) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTGAIcon, 1); arg2 = NUM2INT(argv[0]); if (argc > 1) {
        arg3 = to_FXColor(argv[1]); }  FXTGAIcon_yshear(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXTGAIcon_hgradient(int argc, VALUE *argv, VALUE self) { FXTGAIcon *arg1 = (FXTGAIcon *) 0 ; FXColor arg2 ;
    FXColor arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTGAIcon, 1); arg2 = to_FXColor(argv[0]); arg3 = to_FXColor(argv[1]);
    FXTGAIcon_hgradient(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXTGAIcon_vgradient(int argc, VALUE *argv, VALUE self) { FXTGAIcon *arg1 = (FXTGAIcon *) 0 ; FXColor arg2 ;
    FXColor arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTGAIcon, 1); arg2 = to_FXColor(argv[0]); arg3 = to_FXColor(argv[1]);
    FXTGAIcon_vgradient(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXTGAIcon_gradient(int argc, VALUE *argv, VALUE self) { FXTGAIcon *arg1 = (FXTGAIcon *) 0 ; FXColor arg2 ;
    FXColor arg3 ; FXColor arg4 ; FXColor arg5 ; if ((argc < 4) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTGAIcon, 1); arg2 = to_FXColor(argv[0]); arg3 = to_FXColor(argv[1]);
    arg4 = to_FXColor(argv[2]); arg5 = to_FXColor(argv[3]); FXTGAIcon_gradient(arg1,arg2,arg3,arg4,arg5); return Qnil; }
static VALUE _wrap_FXTGAIcon_blend(int argc, VALUE *argv, VALUE self) { FXTGAIcon *arg1 = (FXTGAIcon *) 0 ; FXColor arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTGAIcon, 1); arg2 = to_FXColor(argv[0]); FXTGAIcon_blend(arg1,arg2);
    return Qnil; }
static VALUE _wrap_FXTGAIcon_savePixels(int argc, VALUE *argv, VALUE self) { FXTGAIcon *arg1 = (FXTGAIcon *) 0 ;
    FXStream *arg2 = 0 ; FXbool result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTGAIcon, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    result = (FXbool)FXTGAIcon_savePixels((FXTGAIcon const *)arg1,*arg2); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXTGAIcon_loadPixels(int argc, VALUE *argv, VALUE self) { FXTGAIcon *arg1 = (FXTGAIcon *) 0 ;
    FXStream *arg2 = 0 ; FXbool result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTGAIcon, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    result = (FXbool)FXTGAIcon_loadPixels(arg1,*arg2); vresult = result ? Qtrue : Qfalse; return vresult; }
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE _wrap_FXTIFIcon_allocate(VALUE self) {
#else
     static VALUE _wrap_FXTIFIcon_allocate(int argc, VALUE *argv, VALUE self) {
#endif
         VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_FXTIFIcon);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
         return vresult; }
static VALUE _wrap_new_FXTIFIcon(int argc, VALUE *argv, VALUE self) { FXApp *arg1 = (FXApp *) 0 ; void *arg2 = (void *) 0 ;
    FXColor arg3 = (FXColor) 0 ; FXuint arg4 = (FXuint) 0 ; FXint arg5 = (FXint) 1 ; FXint arg6 = (FXint) 1 ; FXTIFIcon *result;
    if ((argc < 1) || (argc > 6)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXApp, 1); if (argc > 1) { { if (argv[1] != Qnil) {
                Check_Type(argv[1], T_STRING); arg2 = reinterpret_cast<void *>(RSTRING(argv[1])->ptr); }  else { arg2 = NULL; }
             }  }  if (argc > 2) { arg3 = to_FXColor(argv[2]); }  if (argc > 3) { arg4 = NUM2UINT(argv[3]); }  if (argc > 4) {
        arg5 = NUM2INT(argv[4]); }  if (argc > 5) { arg6 = NUM2INT(argv[5]); }  {
        result = (FXTIFIcon *)new_FXTIFIcon(arg1,(void const *)arg2,arg3,arg4,arg5,arg6);
        DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result); if(rb_block_given_p()){ rb_yield(self); }  }  return self; }
static VALUE _wrap_FXTIFIcon_setCodec(int argc, VALUE *argv, VALUE self) { FXTIFIcon *arg1 = (FXTIFIcon *) 0 ; FXuint arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTIFIcon, 1); arg2 = NUM2UINT(argv[0]); (arg1)->setCodec(arg2);
    return Qnil; }
static VALUE _wrap_FXTIFIcon_getCodec(int argc, VALUE *argv, VALUE self) { FXTIFIcon *arg1 = (FXTIFIcon *) 0 ; FXuint result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTIFIcon, 1); result = (FXuint)((FXTIFIcon const *)arg1)->getCodec();
    vresult = UINT2NUM(result); return vresult; }
static void
free_FXTIFIcon(FXTIFIcon *arg1) {
    delete arg1;
}
static VALUE _wrap_FXTIFIcon_save(int argc, VALUE *argv, VALUE self) { FXTIFIcon *arg1 = (FXTIFIcon *) 0 ; FXStream *arg2 = 0 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTIFIcon, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXTIFIcon_save((FXTIFIcon const *)arg1,*arg2); return Qnil; }
static VALUE _wrap_FXTIFIcon_load(int argc, VALUE *argv, VALUE self) { FXTIFIcon *arg1 = (FXTIFIcon *) 0 ; FXStream *arg2 = 0 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTIFIcon, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXTIFIcon_load(arg1,*arg2); return Qnil; }
static VALUE _wrap_FXTIFIcon_create(int argc, VALUE *argv, VALUE self) { FXTIFIcon *arg1 = (FXTIFIcon *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTIFIcon, 1); FXTIFIcon_create(arg1); return Qnil; }
static VALUE _wrap_FXTIFIcon_detach(int argc, VALUE *argv, VALUE self) { FXTIFIcon *arg1 = (FXTIFIcon *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTIFIcon, 1); FXTIFIcon_detach(arg1); return Qnil; }
static VALUE _wrap_FXTIFIcon_destroy(int argc, VALUE *argv, VALUE self) { FXTIFIcon *arg1 = (FXTIFIcon *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTIFIcon, 1); FXTIFIcon_destroy(arg1); return Qnil; }
static VALUE _wrap_FXTIFIcon_resize(int argc, VALUE *argv, VALUE self) { FXTIFIcon *arg1 = (FXTIFIcon *) 0 ; FXint arg2 ;
    FXint arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTIFIcon, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    FXTIFIcon_resize(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXTIFIcon_restore(int argc, VALUE *argv, VALUE self) { FXTIFIcon *arg1 = (FXTIFIcon *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTIFIcon, 1); FXTIFIcon_restore(arg1); return Qnil; }
static VALUE _wrap_FXTIFIcon_render(int argc, VALUE *argv, VALUE self) { FXTIFIcon *arg1 = (FXTIFIcon *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTIFIcon, 1); FXTIFIcon_render(arg1); return Qnil; }
static VALUE _wrap_FXTIFIcon_release(int argc, VALUE *argv, VALUE self) { FXTIFIcon *arg1 = (FXTIFIcon *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTIFIcon, 1); FXTIFIcon_release(arg1); return Qnil; }
static VALUE _wrap_FXTIFIcon_scale(int argc, VALUE *argv, VALUE self) { FXTIFIcon *arg1 = (FXTIFIcon *) 0 ; FXint arg2 ;
    FXint arg3 ; FXint arg4 = (FXint) 0 ; if ((argc < 2) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTIFIcon, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    if (argc > 2) { arg4 = NUM2INT(argv[2]); }  FXTIFIcon_scale(arg1,arg2,arg3,arg4); return Qnil; }
static VALUE _wrap_FXTIFIcon_mirror(int argc, VALUE *argv, VALUE self) { FXTIFIcon *arg1 = (FXTIFIcon *) 0 ; FXbool arg2 ;
    FXbool arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTIFIcon, 1); arg2 = to_FXbool(argv[0]); arg3 = to_FXbool(argv[1]);
    FXTIFIcon_mirror(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXTIFIcon_rotate(int argc, VALUE *argv, VALUE self) { FXTIFIcon *arg1 = (FXTIFIcon *) 0 ; FXint arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTIFIcon, 1); arg2 = NUM2INT(argv[0]); FXTIFIcon_rotate(arg1,arg2);
    return Qnil; }
static VALUE _wrap_FXTIFIcon_crop(int argc, VALUE *argv, VALUE self) { FXTIFIcon *arg1 = (FXTIFIcon *) 0 ; FXint arg2 ;
    FXint arg3 ; FXint arg4 ; FXint arg5 ; if ((argc < 4) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTIFIcon, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    arg4 = NUM2INT(argv[2]); arg5 = NUM2INT(argv[3]); FXTIFIcon_crop(arg1,arg2,arg3,arg4,arg5); return Qnil; }
static VALUE _wrap_FXTIFIcon_fill(int argc, VALUE *argv, VALUE self) { FXTIFIcon *arg1 = (FXTIFIcon *) 0 ; FXColor arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTIFIcon, 1); arg2 = to_FXColor(argv[0]); FXTIFIcon_fill(arg1,arg2);
    return Qnil; }
static VALUE _wrap_FXTIFIcon_fade(int argc, VALUE *argv, VALUE self) { FXTIFIcon *arg1 = (FXTIFIcon *) 0 ; FXColor arg2 ;
    FXint arg3 = (FXint) 255 ; if ((argc < 1) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTIFIcon, 1); arg2 = to_FXColor(argv[0]); if (argc > 1) {
        arg3 = NUM2INT(argv[1]); }  FXTIFIcon_fade(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXTIFIcon_xshear(int argc, VALUE *argv, VALUE self) { FXTIFIcon *arg1 = (FXTIFIcon *) 0 ; FXint arg2 ;
    FXColor arg3 = (FXColor) 0 ; if ((argc < 1) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTIFIcon, 1); arg2 = NUM2INT(argv[0]); if (argc > 1) {
        arg3 = to_FXColor(argv[1]); }  FXTIFIcon_xshear(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXTIFIcon_yshear(int argc, VALUE *argv, VALUE self) { FXTIFIcon *arg1 = (FXTIFIcon *) 0 ; FXint arg2 ;
    FXColor arg3 = (FXColor) 0 ; if ((argc < 1) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTIFIcon, 1); arg2 = NUM2INT(argv[0]); if (argc > 1) {
        arg3 = to_FXColor(argv[1]); }  FXTIFIcon_yshear(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXTIFIcon_hgradient(int argc, VALUE *argv, VALUE self) { FXTIFIcon *arg1 = (FXTIFIcon *) 0 ; FXColor arg2 ;
    FXColor arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTIFIcon, 1); arg2 = to_FXColor(argv[0]); arg3 = to_FXColor(argv[1]);
    FXTIFIcon_hgradient(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXTIFIcon_vgradient(int argc, VALUE *argv, VALUE self) { FXTIFIcon *arg1 = (FXTIFIcon *) 0 ; FXColor arg2 ;
    FXColor arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTIFIcon, 1); arg2 = to_FXColor(argv[0]); arg3 = to_FXColor(argv[1]);
    FXTIFIcon_vgradient(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXTIFIcon_gradient(int argc, VALUE *argv, VALUE self) { FXTIFIcon *arg1 = (FXTIFIcon *) 0 ; FXColor arg2 ;
    FXColor arg3 ; FXColor arg4 ; FXColor arg5 ; if ((argc < 4) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTIFIcon, 1); arg2 = to_FXColor(argv[0]); arg3 = to_FXColor(argv[1]);
    arg4 = to_FXColor(argv[2]); arg5 = to_FXColor(argv[3]); FXTIFIcon_gradient(arg1,arg2,arg3,arg4,arg5); return Qnil; }
static VALUE _wrap_FXTIFIcon_blend(int argc, VALUE *argv, VALUE self) { FXTIFIcon *arg1 = (FXTIFIcon *) 0 ; FXColor arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTIFIcon, 1); arg2 = to_FXColor(argv[0]); FXTIFIcon_blend(arg1,arg2);
    return Qnil; }
static VALUE _wrap_FXTIFIcon_savePixels(int argc, VALUE *argv, VALUE self) { FXTIFIcon *arg1 = (FXTIFIcon *) 0 ;
    FXStream *arg2 = 0 ; FXbool result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTIFIcon, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    result = (FXbool)FXTIFIcon_savePixels((FXTIFIcon const *)arg1,*arg2); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXTIFIcon_loadPixels(int argc, VALUE *argv, VALUE self) { FXTIFIcon *arg1 = (FXTIFIcon *) 0 ;
    FXStream *arg2 = 0 ; FXbool result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTIFIcon, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    result = (FXbool)FXTIFIcon_loadPixels(arg1,*arg2); vresult = result ? Qtrue : Qfalse; return vresult; }
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE _wrap_FXXBMIcon_allocate(VALUE self) {
#else
     static VALUE _wrap_FXXBMIcon_allocate(int argc, VALUE *argv, VALUE self) {
#endif
         VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_FXXBMIcon);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
         return vresult; }
static VALUE _wrap_new_FXXBMIcon(int argc, VALUE *argv, VALUE self) { FXApp *arg1 = (FXApp *) 0 ;
    FXuchar *arg2 = (FXuchar *) 0 ; FXuchar *arg3 = (FXuchar *) 0 ; FXColor arg4 = (FXColor) FXRGB(192,192,192) ;
    FXuint arg5 = (FXuint) 0 ; FXint arg6 = (FXint) 1 ; FXint arg7 = (FXint) 1 ; FXXBMIcon *result;
    if ((argc < 1) || (argc > 7)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXApp, 1); if (argc > 1) {
        SWIG_ConvertPtr(argv[1], (void **) &arg2, SWIGTYPE_p_FXuchar, 1); }  if (argc > 2) {
        SWIG_ConvertPtr(argv[2], (void **) &arg3, SWIGTYPE_p_FXuchar, 1); }  if (argc > 3) { arg4 = to_FXColor(argv[3]); } 
    if (argc > 4) { arg5 = NUM2UINT(argv[4]); }  if (argc > 5) { arg6 = NUM2INT(argv[5]); }  if (argc > 6) {
        arg7 = NUM2INT(argv[6]); }  {
        result = (FXXBMIcon *)new_FXXBMIcon(arg1,(FXuchar const *)arg2,(FXuchar const *)arg3,arg4,arg5,arg6,arg7);
        DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result); if(rb_block_given_p()){ rb_yield(self); }  }  return self; }
static void
free_FXXBMIcon(FXXBMIcon *arg1) {
    delete arg1;
}
static VALUE _wrap_FXXBMIcon_save(int argc, VALUE *argv, VALUE self) { FXXBMIcon *arg1 = (FXXBMIcon *) 0 ; FXStream *arg2 = 0 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXXBMIcon, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXXBMIcon_save((FXXBMIcon const *)arg1,*arg2); return Qnil; }
static VALUE _wrap_FXXBMIcon_load(int argc, VALUE *argv, VALUE self) { FXXBMIcon *arg1 = (FXXBMIcon *) 0 ; FXStream *arg2 = 0 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXXBMIcon, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXXBMIcon_load(arg1,*arg2); return Qnil; }
static VALUE _wrap_FXXBMIcon_create(int argc, VALUE *argv, VALUE self) { FXXBMIcon *arg1 = (FXXBMIcon *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXXBMIcon, 1); FXXBMIcon_create(arg1); return Qnil; }
static VALUE _wrap_FXXBMIcon_detach(int argc, VALUE *argv, VALUE self) { FXXBMIcon *arg1 = (FXXBMIcon *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXXBMIcon, 1); FXXBMIcon_detach(arg1); return Qnil; }
static VALUE _wrap_FXXBMIcon_destroy(int argc, VALUE *argv, VALUE self) { FXXBMIcon *arg1 = (FXXBMIcon *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXXBMIcon, 1); FXXBMIcon_destroy(arg1); return Qnil; }
static VALUE _wrap_FXXBMIcon_resize(int argc, VALUE *argv, VALUE self) { FXXBMIcon *arg1 = (FXXBMIcon *) 0 ; FXint arg2 ;
    FXint arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXXBMIcon, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    FXXBMIcon_resize(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXXBMIcon_restore(int argc, VALUE *argv, VALUE self) { FXXBMIcon *arg1 = (FXXBMIcon *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXXBMIcon, 1); FXXBMIcon_restore(arg1); return Qnil; }
static VALUE _wrap_FXXBMIcon_render(int argc, VALUE *argv, VALUE self) { FXXBMIcon *arg1 = (FXXBMIcon *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXXBMIcon, 1); FXXBMIcon_render(arg1); return Qnil; }
static VALUE _wrap_FXXBMIcon_release(int argc, VALUE *argv, VALUE self) { FXXBMIcon *arg1 = (FXXBMIcon *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXXBMIcon, 1); FXXBMIcon_release(arg1); return Qnil; }
static VALUE _wrap_FXXBMIcon_scale(int argc, VALUE *argv, VALUE self) { FXXBMIcon *arg1 = (FXXBMIcon *) 0 ; FXint arg2 ;
    FXint arg3 ; FXint arg4 = (FXint) 0 ; if ((argc < 2) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXXBMIcon, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    if (argc > 2) { arg4 = NUM2INT(argv[2]); }  FXXBMIcon_scale(arg1,arg2,arg3,arg4); return Qnil; }
static VALUE _wrap_FXXBMIcon_mirror(int argc, VALUE *argv, VALUE self) { FXXBMIcon *arg1 = (FXXBMIcon *) 0 ; FXbool arg2 ;
    FXbool arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXXBMIcon, 1); arg2 = to_FXbool(argv[0]); arg3 = to_FXbool(argv[1]);
    FXXBMIcon_mirror(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXXBMIcon_rotate(int argc, VALUE *argv, VALUE self) { FXXBMIcon *arg1 = (FXXBMIcon *) 0 ; FXint arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXXBMIcon, 1); arg2 = NUM2INT(argv[0]); FXXBMIcon_rotate(arg1,arg2);
    return Qnil; }
static VALUE _wrap_FXXBMIcon_crop(int argc, VALUE *argv, VALUE self) { FXXBMIcon *arg1 = (FXXBMIcon *) 0 ; FXint arg2 ;
    FXint arg3 ; FXint arg4 ; FXint arg5 ; if ((argc < 4) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXXBMIcon, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    arg4 = NUM2INT(argv[2]); arg5 = NUM2INT(argv[3]); FXXBMIcon_crop(arg1,arg2,arg3,arg4,arg5); return Qnil; }
static VALUE _wrap_FXXBMIcon_fill(int argc, VALUE *argv, VALUE self) { FXXBMIcon *arg1 = (FXXBMIcon *) 0 ; FXColor arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXXBMIcon, 1); arg2 = to_FXColor(argv[0]); FXXBMIcon_fill(arg1,arg2);
    return Qnil; }
static VALUE _wrap_FXXBMIcon_fade(int argc, VALUE *argv, VALUE self) { FXXBMIcon *arg1 = (FXXBMIcon *) 0 ; FXColor arg2 ;
    FXint arg3 = (FXint) 255 ; if ((argc < 1) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXXBMIcon, 1); arg2 = to_FXColor(argv[0]); if (argc > 1) {
        arg3 = NUM2INT(argv[1]); }  FXXBMIcon_fade(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXXBMIcon_xshear(int argc, VALUE *argv, VALUE self) { FXXBMIcon *arg1 = (FXXBMIcon *) 0 ; FXint arg2 ;
    FXColor arg3 = (FXColor) 0 ; if ((argc < 1) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXXBMIcon, 1); arg2 = NUM2INT(argv[0]); if (argc > 1) {
        arg3 = to_FXColor(argv[1]); }  FXXBMIcon_xshear(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXXBMIcon_yshear(int argc, VALUE *argv, VALUE self) { FXXBMIcon *arg1 = (FXXBMIcon *) 0 ; FXint arg2 ;
    FXColor arg3 = (FXColor) 0 ; if ((argc < 1) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXXBMIcon, 1); arg2 = NUM2INT(argv[0]); if (argc > 1) {
        arg3 = to_FXColor(argv[1]); }  FXXBMIcon_yshear(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXXBMIcon_hgradient(int argc, VALUE *argv, VALUE self) { FXXBMIcon *arg1 = (FXXBMIcon *) 0 ; FXColor arg2 ;
    FXColor arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXXBMIcon, 1); arg2 = to_FXColor(argv[0]); arg3 = to_FXColor(argv[1]);
    FXXBMIcon_hgradient(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXXBMIcon_vgradient(int argc, VALUE *argv, VALUE self) { FXXBMIcon *arg1 = (FXXBMIcon *) 0 ; FXColor arg2 ;
    FXColor arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXXBMIcon, 1); arg2 = to_FXColor(argv[0]); arg3 = to_FXColor(argv[1]);
    FXXBMIcon_vgradient(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXXBMIcon_gradient(int argc, VALUE *argv, VALUE self) { FXXBMIcon *arg1 = (FXXBMIcon *) 0 ; FXColor arg2 ;
    FXColor arg3 ; FXColor arg4 ; FXColor arg5 ; if ((argc < 4) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXXBMIcon, 1); arg2 = to_FXColor(argv[0]); arg3 = to_FXColor(argv[1]);
    arg4 = to_FXColor(argv[2]); arg5 = to_FXColor(argv[3]); FXXBMIcon_gradient(arg1,arg2,arg3,arg4,arg5); return Qnil; }
static VALUE _wrap_FXXBMIcon_blend(int argc, VALUE *argv, VALUE self) { FXXBMIcon *arg1 = (FXXBMIcon *) 0 ; FXColor arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXXBMIcon, 1); arg2 = to_FXColor(argv[0]); FXXBMIcon_blend(arg1,arg2);
    return Qnil; }
static VALUE _wrap_FXXBMIcon_savePixels(int argc, VALUE *argv, VALUE self) { FXXBMIcon *arg1 = (FXXBMIcon *) 0 ;
    FXStream *arg2 = 0 ; FXbool result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXXBMIcon, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    result = (FXbool)FXXBMIcon_savePixels((FXXBMIcon const *)arg1,*arg2); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXXBMIcon_loadPixels(int argc, VALUE *argv, VALUE self) { FXXBMIcon *arg1 = (FXXBMIcon *) 0 ;
    FXStream *arg2 = 0 ; FXbool result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXXBMIcon, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    result = (FXbool)FXXBMIcon_loadPixels(arg1,*arg2); vresult = result ? Qtrue : Qfalse; return vresult; }
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE _wrap_FXXPMIcon_allocate(VALUE self) {
#else
     static VALUE _wrap_FXXPMIcon_allocate(int argc, VALUE *argv, VALUE self) {
#endif
         VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_FXXPMIcon);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
         return vresult; }
static VALUE _wrap_new_FXXPMIcon(int argc, VALUE *argv, VALUE self) { FXApp *arg1 = (FXApp *) 0 ;
    FXchar **arg2 = (FXchar **) 0 ; FXColor arg3 = (FXColor) 0 ; FXuint arg4 = (FXuint) 0 ; FXint arg5 = (FXint) 1 ;
    FXint arg6 = (FXint) 1 ; FXXPMIcon *result; if ((argc < 1) || (argc > 6))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXApp, 1); if (argc > 1) { { arg2 = NULL; if (argv[1] != Qnil) {
                Check_Type(argv[1], T_ARRAY); if (FXMALLOC(&arg2, FXchar *, RARRAY(argv[1])->len)) {
                    for (long i = 0; i < RARRAY(argv[1])->len; i++) { arg2[i] = (FXchar *) STR2CSTR(rb_ary_entry(argv[1], i)); }
                     }  }  }  }  if (argc > 2) { arg3 = to_FXColor(argv[2]); }  if (argc > 3) { arg4 = NUM2UINT(argv[3]); } 
    if (argc > 4) { arg5 = NUM2INT(argv[4]); }  if (argc > 5) { arg6 = NUM2INT(argv[5]); }  {
        result = (FXXPMIcon *)new_FXXPMIcon(arg1,(FXchar const **)arg2,arg3,arg4,arg5,arg6);
        DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result); if(rb_block_given_p()){ rb_yield(self); }  }  FXFREE(&arg2);
    return self; }
static void
free_FXXPMIcon(FXXPMIcon *arg1) {
    delete arg1;
}
static VALUE _wrap_FXXPMIcon_save(int argc, VALUE *argv, VALUE self) { FXXPMIcon *arg1 = (FXXPMIcon *) 0 ; FXStream *arg2 = 0 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXXPMIcon, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXXPMIcon_save((FXXPMIcon const *)arg1,*arg2); return Qnil; }
static VALUE _wrap_FXXPMIcon_load(int argc, VALUE *argv, VALUE self) { FXXPMIcon *arg1 = (FXXPMIcon *) 0 ; FXStream *arg2 = 0 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXXPMIcon, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXXPMIcon_load(arg1,*arg2); return Qnil; }
static VALUE _wrap_FXXPMIcon_create(int argc, VALUE *argv, VALUE self) { FXXPMIcon *arg1 = (FXXPMIcon *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXXPMIcon, 1); FXXPMIcon_create(arg1); return Qnil; }
static VALUE _wrap_FXXPMIcon_detach(int argc, VALUE *argv, VALUE self) { FXXPMIcon *arg1 = (FXXPMIcon *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXXPMIcon, 1); FXXPMIcon_detach(arg1); return Qnil; }
static VALUE _wrap_FXXPMIcon_destroy(int argc, VALUE *argv, VALUE self) { FXXPMIcon *arg1 = (FXXPMIcon *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXXPMIcon, 1); FXXPMIcon_destroy(arg1); return Qnil; }
static VALUE _wrap_FXXPMIcon_resize(int argc, VALUE *argv, VALUE self) { FXXPMIcon *arg1 = (FXXPMIcon *) 0 ; FXint arg2 ;
    FXint arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXXPMIcon, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    FXXPMIcon_resize(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXXPMIcon_restore(int argc, VALUE *argv, VALUE self) { FXXPMIcon *arg1 = (FXXPMIcon *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXXPMIcon, 1); FXXPMIcon_restore(arg1); return Qnil; }
static VALUE _wrap_FXXPMIcon_render(int argc, VALUE *argv, VALUE self) { FXXPMIcon *arg1 = (FXXPMIcon *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXXPMIcon, 1); FXXPMIcon_render(arg1); return Qnil; }
static VALUE _wrap_FXXPMIcon_release(int argc, VALUE *argv, VALUE self) { FXXPMIcon *arg1 = (FXXPMIcon *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXXPMIcon, 1); FXXPMIcon_release(arg1); return Qnil; }
static VALUE _wrap_FXXPMIcon_scale(int argc, VALUE *argv, VALUE self) { FXXPMIcon *arg1 = (FXXPMIcon *) 0 ; FXint arg2 ;
    FXint arg3 ; FXint arg4 = (FXint) 0 ; if ((argc < 2) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXXPMIcon, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    if (argc > 2) { arg4 = NUM2INT(argv[2]); }  FXXPMIcon_scale(arg1,arg2,arg3,arg4); return Qnil; }
static VALUE _wrap_FXXPMIcon_mirror(int argc, VALUE *argv, VALUE self) { FXXPMIcon *arg1 = (FXXPMIcon *) 0 ; FXbool arg2 ;
    FXbool arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXXPMIcon, 1); arg2 = to_FXbool(argv[0]); arg3 = to_FXbool(argv[1]);
    FXXPMIcon_mirror(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXXPMIcon_rotate(int argc, VALUE *argv, VALUE self) { FXXPMIcon *arg1 = (FXXPMIcon *) 0 ; FXint arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXXPMIcon, 1); arg2 = NUM2INT(argv[0]); FXXPMIcon_rotate(arg1,arg2);
    return Qnil; }
static VALUE _wrap_FXXPMIcon_crop(int argc, VALUE *argv, VALUE self) { FXXPMIcon *arg1 = (FXXPMIcon *) 0 ; FXint arg2 ;
    FXint arg3 ; FXint arg4 ; FXint arg5 ; if ((argc < 4) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXXPMIcon, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    arg4 = NUM2INT(argv[2]); arg5 = NUM2INT(argv[3]); FXXPMIcon_crop(arg1,arg2,arg3,arg4,arg5); return Qnil; }
static VALUE _wrap_FXXPMIcon_fill(int argc, VALUE *argv, VALUE self) { FXXPMIcon *arg1 = (FXXPMIcon *) 0 ; FXColor arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXXPMIcon, 1); arg2 = to_FXColor(argv[0]); FXXPMIcon_fill(arg1,arg2);
    return Qnil; }
static VALUE _wrap_FXXPMIcon_fade(int argc, VALUE *argv, VALUE self) { FXXPMIcon *arg1 = (FXXPMIcon *) 0 ; FXColor arg2 ;
    FXint arg3 = (FXint) 255 ; if ((argc < 1) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXXPMIcon, 1); arg2 = to_FXColor(argv[0]); if (argc > 1) {
        arg3 = NUM2INT(argv[1]); }  FXXPMIcon_fade(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXXPMIcon_xshear(int argc, VALUE *argv, VALUE self) { FXXPMIcon *arg1 = (FXXPMIcon *) 0 ; FXint arg2 ;
    FXColor arg3 = (FXColor) 0 ; if ((argc < 1) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXXPMIcon, 1); arg2 = NUM2INT(argv[0]); if (argc > 1) {
        arg3 = to_FXColor(argv[1]); }  FXXPMIcon_xshear(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXXPMIcon_yshear(int argc, VALUE *argv, VALUE self) { FXXPMIcon *arg1 = (FXXPMIcon *) 0 ; FXint arg2 ;
    FXColor arg3 = (FXColor) 0 ; if ((argc < 1) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXXPMIcon, 1); arg2 = NUM2INT(argv[0]); if (argc > 1) {
        arg3 = to_FXColor(argv[1]); }  FXXPMIcon_yshear(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXXPMIcon_hgradient(int argc, VALUE *argv, VALUE self) { FXXPMIcon *arg1 = (FXXPMIcon *) 0 ; FXColor arg2 ;
    FXColor arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXXPMIcon, 1); arg2 = to_FXColor(argv[0]); arg3 = to_FXColor(argv[1]);
    FXXPMIcon_hgradient(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXXPMIcon_vgradient(int argc, VALUE *argv, VALUE self) { FXXPMIcon *arg1 = (FXXPMIcon *) 0 ; FXColor arg2 ;
    FXColor arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXXPMIcon, 1); arg2 = to_FXColor(argv[0]); arg3 = to_FXColor(argv[1]);
    FXXPMIcon_vgradient(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXXPMIcon_gradient(int argc, VALUE *argv, VALUE self) { FXXPMIcon *arg1 = (FXXPMIcon *) 0 ; FXColor arg2 ;
    FXColor arg3 ; FXColor arg4 ; FXColor arg5 ; if ((argc < 4) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXXPMIcon, 1); arg2 = to_FXColor(argv[0]); arg3 = to_FXColor(argv[1]);
    arg4 = to_FXColor(argv[2]); arg5 = to_FXColor(argv[3]); FXXPMIcon_gradient(arg1,arg2,arg3,arg4,arg5); return Qnil; }
static VALUE _wrap_FXXPMIcon_blend(int argc, VALUE *argv, VALUE self) { FXXPMIcon *arg1 = (FXXPMIcon *) 0 ; FXColor arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXXPMIcon, 1); arg2 = to_FXColor(argv[0]); FXXPMIcon_blend(arg1,arg2);
    return Qnil; }
static VALUE _wrap_FXXPMIcon_savePixels(int argc, VALUE *argv, VALUE self) { FXXPMIcon *arg1 = (FXXPMIcon *) 0 ;
    FXStream *arg2 = 0 ; FXbool result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXXPMIcon, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    result = (FXbool)FXXPMIcon_savePixels((FXXPMIcon const *)arg1,*arg2); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXXPMIcon_loadPixels(int argc, VALUE *argv, VALUE self) { FXXPMIcon *arg1 = (FXXPMIcon *) 0 ;
    FXStream *arg2 = 0 ; FXbool result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXXPMIcon, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    result = (FXbool)FXXPMIcon_loadPixels(arg1,*arg2); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_fxloadXPM__SWIG_0(int argc, VALUE *argv, VALUE self) { FXStream *arg1 = 0 ; VALUE result;
    VALUE vresult = Qnil; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXStream, 1); if (arg1 == NULL) rb_raise(rb_eTypeError, "null reference");
    result = (VALUE)fxloadXPM(*arg1); vresult = result; return vresult; }
static VALUE _wrap_fxloadXPM__SWIG_1(int argc, VALUE *argv, VALUE self) { VALUE arg1 ; VALUE result; VALUE vresult = Qnil;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc); arg1 = argv[0];
    result = (VALUE)fxloadXPM(arg1); vresult = result; return vresult; }
static VALUE _wrap_fxloadXPM(int nargs, VALUE *args, VALUE self) { int argc; VALUE argv[1]; int ii; argc = nargs;
    for (ii = 0; (ii < argc) && (ii < 1); ii++) { argv[ii] = args[ii]; }  if (argc == 1) { int _v; { void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXStream, 0) != -1)) ? 1 : 0; }
         if (_v) { return _wrap_fxloadXPM__SWIG_0(nargs, args, self);}  }  if (argc == 1) { int _v; {
            _v = ((TYPE(argv[0]) == T_FIXNUM) || (TYPE(argv[0]) == T_BIGNUM)) ? 1 : 0; }  if (_v) {
            return _wrap_fxloadXPM__SWIG_1(nargs, args, self);}  } 
    rb_raise(rb_eArgError, "No matching function for overloaded 'fxloadXPM'"); return Qnil; }
static VALUE _wrap_fxsaveXPM(int argc, VALUE *argv, VALUE self) { FXStream *arg1 = 0 ; FXColor *arg2 = (FXColor *) 0 ;
    FXint arg3 ; FXint arg4 ; FXbool arg5 = (FXbool) 1 ; FXbool result; VALUE vresult = Qnil; if ((argc < 4) || (argc > 5))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXStream, 1); if (arg1 == NULL) rb_raise(rb_eTypeError, "null reference");
    { arg2=NULL; if(argv[1]!=Qnil){ Check_Type(argv[1],T_ARRAY); if(FXMALLOC(&arg2,FXColor,RARRAY(argv[1])->len)){
                for(long i=0; i<RARRAY(argv[1])->len; i++){ arg2[i]=static_cast<FXColor>(NUM2UINT(rb_ary_entry(argv[1],i))); }  }
             }  }  arg3 = NUM2INT(argv[2]); arg4 = NUM2INT(argv[3]); if (argc > 4) { arg5 = to_FXbool(argv[4]); } 
    result = (FXbool)fxsaveXPM(*arg1,(FXColor const *)arg2,arg3,arg4,arg5); vresult = result ? Qtrue : Qfalse; FXFREE(&arg2);
    return vresult; }

/* -------- TYPE CONVERSION AND EQUIVALENCE RULES (BEGIN) -------- */

static void *_p_FXPNGIconTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXImage *)(FXIcon *) ((FXPNGIcon *) x));
}
static void *_p_FXShutterItemTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *)(FXVerticalFrame *) ((FXShutterItem *) x));
}
static void *_p_FXColorBarTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXFrame *) ((FXColorBar *) x));
}
static void *_p_FXTabBarTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXTabBar *) x));
}
static void *_p_FXSwitcherTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXSwitcher *) x));
}
static void *_p_FXTextFieldTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXFrame *) ((FXTextField *) x));
}
static void *_p_FXRGBImageTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXImage *) ((FXRGBImage *) x));
}
static void *_p_FXToolBarTabTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXFrame *) ((FXToolBarTab *) x));
}
static void *_p_FXDriveBoxTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *)(FXListBox *) ((FXDriveBox *) x));
}
static void *_p_FXBMPImageTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXImage *) ((FXBMPImage *) x));
}
static void *_p_FXMatrixTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXMatrix *) x));
}
static void *_p_FXScrollCornerTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *) ((FXScrollCorner *) x));
}
static void *_p_FXArrowButtonTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXFrame *) ((FXArrowButton *) x));
}
static void *_p_FXPopupTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXShell *) ((FXPopup *) x));
}
static void *_p_FXDrawableTo_p_FXId(void *x) {
    return (void *)((FXId *)  ((FXDrawable *) x));
}
static void *_p_FXJPGIconTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXImage *)(FXIcon *) ((FXJPGIcon *) x));
}
static void *_p_FXPCXImageTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXImage *) ((FXPCXImage *) x));
}
static void *_p_FXGIFIconTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXImage *)(FXIcon *) ((FXGIFIcon *) x));
}
static void *_p_FXHeaderTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXFrame *) ((FXHeader *) x));
}
static void *_p_FXSplitterTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *) ((FXSplitter *) x));
}
static void *_p_FX4SplitterTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *) ((FX4Splitter *) x));
}
static void *_p_FXSpringTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXSpring *) x));
}
static void *_p_FXPackerTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *) ((FXPacker *) x));
}
static void *_p_FXTabBookTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *)(FXTabBar *) ((FXTabBook *) x));
}
static void *_p_FXBMPIconTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXImage *)(FXIcon *) ((FXBMPIcon *) x));
}
static void *_p_FXImageFrameTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXFrame *) ((FXImageFrame *) x));
}
static void *_p_FXVerticalSeparatorTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXFrame *)(FXSeparator *) ((FXVerticalSeparator *) x));
}
static void *_p_FXHorizontalSeparatorTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXFrame *)(FXSeparator *) ((FXHorizontalSeparator *) x));
}
static void *_p_FXSeparatorTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXFrame *) ((FXSeparator *) x));
}
static void *_p_FXProgressBarTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXFrame *) ((FXProgressBar *) x));
}
static void *_p_FXShutterTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *)(FXVerticalFrame *) ((FXShutter *) x));
}
static void *_p_FXTGAImageTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXImage *) ((FXTGAImage *) x));
}
static void *_p_FXICOIconTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXImage *)(FXIcon *) ((FXICOIcon *) x));
}
static void *_p_FXToolTipTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXShell *) ((FXToolTip *) x));
}
static void *_p_FXCompositeTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *) ((FXComposite *) x));
}
static void *_p_FXICOImageTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXImage *) ((FXICOImage *) x));
}
static void *_p_FXBitmapFrameTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXFrame *) ((FXBitmapFrame *) x));
}
static void *_p_FXRealSliderTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXFrame *) ((FXRealSlider *) x));
}
static void *_p_FXSliderTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXFrame *) ((FXSlider *) x));
}
static void *_p_FXGroupBoxTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXGroupBox *) x));
}
static void *_p_FXPPMImageTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXImage *) ((FXPPMImage *) x));
}
static void *_p_FXXBMImageTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXImage *) ((FXXBMImage *) x));
}
static void *_p_FXXPMImageTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXImage *) ((FXXPMImage *) x));
}
static void *_p_FXTreeListBoxTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXTreeListBox *) x));
}
static void *_p_FXListBoxTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXListBox *) x));
}
static void *_p_FXCanvasTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *) ((FXCanvas *) x));
}
static void *_p_FXColorWheelTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXFrame *) ((FXColorWheel *) x));
}
static void *_p_FXVisualTo_p_FXId(void *x) {
    return (void *)((FXId *)  ((FXVisual *) x));
}
static void *_p_FXToolBarGripTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *) ((FXToolBarGrip *) x));
}
static void *_p_FXScrollBarTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *) ((FXScrollBar *) x));
}
static void *_p_FXFontTo_p_FXId(void *x) {
    return (void *)((FXId *)  ((FXFont *) x));
}
static void *_p_FXComboBoxTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXComboBox *) x));
}
static void *_p_FXImageTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *) ((FXImage *) x));
}
static void *_p_FXTIFIconTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXImage *)(FXIcon *) ((FXTIFIcon *) x));
}
static void *_p_FXFrameTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *) ((FXFrame *) x));
}
static void *_p_FXJPGImageTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXImage *) ((FXJPGImage *) x));
}
static void *_p_FXPNGImageTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXImage *) ((FXPNGImage *) x));
}
static void *_p_FXGIFImageTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXImage *) ((FXGIFImage *) x));
}
static void *_p_FXTIFImageTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXImage *) ((FXTIFImage *) x));
}
static void *_p_FXStatusBarTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *)(FXHorizontalFrame *) ((FXStatusBar *) x));
}
static void *_p_FXGIFCursorTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXCursor *) ((FXGIFCursor *) x));
}
static void *_p_FXCURCursorTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXCursor *) ((FXCURCursor *) x));
}
static void *_p_FXCursorTo_p_FXId(void *x) {
    return (void *)((FXId *)  ((FXCursor *) x));
}
static void *_p_FXIconTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXImage *) ((FXIcon *) x));
}
static void *_p_FXRealSpinnerTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXRealSpinner *) x));
}
static void *_p_FXSpinnerTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXSpinner *) x));
}
static void *_p_FXStatusLineTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXFrame *) ((FXStatusLine *) x));
}
static void *_p_FXMainWindowTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXShell *)(FXTopWindow *) ((FXMainWindow *) x));
}
static void *_p_FXTopWindowTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXShell *) ((FXTopWindow *) x));
}
static void *_p_FXRootWindowTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *) ((FXRootWindow *) x));
}
static void *_p_FXWindowTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *) ((FXWindow *) x));
}
static void *_p_FXScrollWindowTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXScrollArea *) ((FXScrollWindow *) x));
}
static void *_p_FXTGAIconTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXImage *)(FXIcon *) ((FXTGAIcon *) x));
}
static void *_p_FXShellTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *) ((FXShell *) x));
}
static void *_p_FXPCXIconTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXImage *)(FXIcon *) ((FXPCXIcon *) x));
}
static void *_p_FXBitmapTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *) ((FXBitmap *) x));
}
static void *_p_FXScrollAreaTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *) ((FXScrollArea *) x));
}
static void *_p_FXColorWellTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXFrame *) ((FXColorWell *) x));
}
static void *_p_FXDragCornerTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *) ((FXDragCorner *) x));
}
static void *_p_FXRulerTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXFrame *) ((FXRuler *) x));
}
static void *_p_FXRGBIconTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXImage *)(FXIcon *) ((FXRGBIcon *) x));
}
static void *_p_FXDialTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXFrame *) ((FXDial *) x));
}
static void *_p_FXHorizontalFrameTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXHorizontalFrame *) x));
}
static void *_p_FXVerticalFrameTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXVerticalFrame *) x));
}
static void *_p_FXImageViewTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXScrollArea *) ((FXImageView *) x));
}
static void *_p_FXFontSelectorTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXFontSelector *) x));
}
static void *_p_FXColorSelectorTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXColorSelector *) x));
}
static void *_p_FXFileSelectorTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXFileSelector *) x));
}
static void *_p_FXDirSelectorTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXDirSelector *) x));
}
static void *_p_FXXBMIconTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXImage *)(FXIcon *) ((FXXBMIcon *) x));
}
static void *_p_FXToolBarShellTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXShell *)(FXTopWindow *) ((FXToolBarShell *) x));
}
static void *_p_FXToolBarTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXToolBar *) x));
}
static void *_p_FXDirBoxTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *)(FXTreeListBox *) ((FXDirBox *) x));
}
static void *_p_FXPPMIconTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXImage *)(FXIcon *) ((FXPPMIcon *) x));
}
static void *_p_FXXPMIconTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXImage *)(FXIcon *) ((FXXPMIcon *) x));
}
static void *_p_FXDocumentTo_p_FXObject(void *x) {
    return (void *)((FXObject *)  ((FXDocument *) x));
}
static void *_p_FXPNGIconTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXImage *)(FXIcon *) ((FXPNGIcon *) x));
}
static void *_p_FXRegistryTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXDict *)(FXSettings *) ((FXRegistry *) x));
}
static void *_p_FXHeaderItemTo_p_FXObject(void *x) {
    return (void *)((FXObject *)  ((FXHeaderItem *) x));
}
static void *_p_FXShutterItemTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *)(FXVerticalFrame *) ((FXShutterItem *) x));
}
static void *_p_FXColorBarTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXFrame *) ((FXColorBar *) x));
}
static void *_p_FXTabBarTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXTabBar *) x));
}
static void *_p_FXSwitcherTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXSwitcher *) x));
}
static void *_p_FXTextFieldTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXFrame *) ((FXTextField *) x));
}
static void *_p_FXRGBImageTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXImage *) ((FXRGBImage *) x));
}
static void *_p_FXToolBarTabTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXFrame *) ((FXToolBarTab *) x));
}
static void *_p_FXDriveBoxTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *)(FXListBox *) ((FXDriveBox *) x));
}
static void *_p_FXIconDictTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXDict *) ((FXIconDict *) x));
}
static void *_p_FXBMPImageTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXImage *) ((FXBMPImage *) x));
}
static void *_p_FXMatrixTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXMatrix *) x));
}
static void *_p_FXFileDictTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXDict *) ((FXFileDict *) x));
}
static void *_p_FXRecentFilesTo_p_FXObject(void *x) {
    return (void *)((FXObject *)  ((FXRecentFiles *) x));
}
static void *_p_FXScrollCornerTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *) ((FXScrollCorner *) x));
}
static void *_p_FXArrowButtonTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXFrame *) ((FXArrowButton *) x));
}
static void *_p_FXPopupTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXShell *) ((FXPopup *) x));
}
static void *_p_FXDrawableTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *) ((FXDrawable *) x));
}
static void *_p_FXJPGIconTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXImage *)(FXIcon *) ((FXJPGIcon *) x));
}
static void *_p_FXPCXImageTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXImage *) ((FXPCXImage *) x));
}
static void *_p_FXGIFIconTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXImage *)(FXIcon *) ((FXGIFIcon *) x));
}
static void *_p_FXAppTo_p_FXObject(void *x) {
    return (void *)((FXObject *)  ((FXApp *) x));
}
static void *_p_FXHeaderTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXFrame *) ((FXHeader *) x));
}
static void *_p_FX4SplitterTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *) ((FX4Splitter *) x));
}
static void *_p_FXSplitterTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *) ((FXSplitter *) x));
}
static void *_p_FXSpringTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXSpring *) x));
}
static void *_p_FXPackerTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *) ((FXPacker *) x));
}
static void *_p_FXTabBookTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *)(FXTabBar *) ((FXTabBook *) x));
}
static void *_p_FXBMPIconTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXImage *)(FXIcon *) ((FXBMPIcon *) x));
}
static void *_p_FXImageFrameTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXFrame *) ((FXImageFrame *) x));
}
static void *_p_FXVerticalSeparatorTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXFrame *)(FXSeparator *) ((FXVerticalSeparator *) x));
}
static void *_p_FXHorizontalSeparatorTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXFrame *)(FXSeparator *) ((FXHorizontalSeparator *) x));
}
static void *_p_FXSeparatorTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXFrame *) ((FXSeparator *) x));
}
static void *_p_FXIdTo_p_FXObject(void *x) {
    return (void *)((FXObject *)  ((FXId *) x));
}
static void *_p_FXProgressBarTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXFrame *) ((FXProgressBar *) x));
}
static void *_p_FXShutterTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *)(FXVerticalFrame *) ((FXShutter *) x));
}
static void *_p_FXTGAImageTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXImage *) ((FXTGAImage *) x));
}
static void *_p_FXICOIconTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXImage *)(FXIcon *) ((FXICOIcon *) x));
}
static void *_p_FXToolTipTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXShell *) ((FXToolTip *) x));
}
static void *_p_FXCompositeTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *) ((FXComposite *) x));
}
static void *_p_FXBitmapFrameTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXFrame *) ((FXBitmapFrame *) x));
}
static void *_p_FXICOImageTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXImage *) ((FXICOImage *) x));
}
static void *_p_FXRealSliderTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXFrame *) ((FXRealSlider *) x));
}
static void *_p_FXSliderTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXFrame *) ((FXSlider *) x));
}
static void *_p_FXSettingsTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXDict *) ((FXSettings *) x));
}
static void *_p_FXGroupBoxTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXGroupBox *) x));
}
static void *_p_FXDebugTargetTo_p_FXObject(void *x) {
    return (void *)((FXObject *)  ((FXDebugTarget *) x));
}
static void *_p_FXDataTargetTo_p_FXObject(void *x) {
    return (void *)((FXObject *)  ((FXDataTarget *) x));
}
static void *_p_FXPPMImageTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXImage *) ((FXPPMImage *) x));
}
static void *_p_FXXBMImageTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXImage *) ((FXXBMImage *) x));
}
static void *_p_FXXPMImageTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXImage *) ((FXXPMImage *) x));
}
static void *_p_FXTreeListBoxTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXTreeListBox *) x));
}
static void *_p_FXListBoxTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXListBox *) x));
}
static void *_p_FXCanvasTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *) ((FXCanvas *) x));
}
static void *_p_FXColorWheelTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXFrame *) ((FXColorWheel *) x));
}
static void *_p_FXVisualTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *) ((FXVisual *) x));
}
static void *_p_FXScrollBarTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *) ((FXScrollBar *) x));
}
static void *_p_FXToolBarGripTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *) ((FXToolBarGrip *) x));
}
static void *_p_FXFontTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *) ((FXFont *) x));
}
static void *_p_FXComboBoxTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXComboBox *) x));
}
static void *_p_FXImageTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *) ((FXImage *) x));
}
static void *_p_FXTIFIconTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXImage *)(FXIcon *) ((FXTIFIcon *) x));
}
static void *_p_FXFrameTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *) ((FXFrame *) x));
}
static void *_p_FXJPGImageTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXImage *) ((FXJPGImage *) x));
}
static void *_p_FXPNGImageTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXImage *) ((FXPNGImage *) x));
}
static void *_p_FXGIFImageTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXImage *) ((FXGIFImage *) x));
}
static void *_p_FXTIFImageTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXImage *) ((FXTIFImage *) x));
}
static void *_p_FXStringDictTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXDict *) ((FXStringDict *) x));
}
static void *_p_FXStatusBarTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *)(FXHorizontalFrame *) ((FXStatusBar *) x));
}
static void *_p_FXDelegatorTo_p_FXObject(void *x) {
    return (void *)((FXObject *)  ((FXDelegator *) x));
}
static void *_p_FXAccelTableTo_p_FXObject(void *x) {
    return (void *)((FXObject *)  ((FXAccelTable *) x));
}
static void *_p_FXCursorTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *) ((FXCursor *) x));
}
static void *_p_FXCURCursorTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXCursor *) ((FXCURCursor *) x));
}
static void *_p_FXGIFCursorTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXCursor *) ((FXGIFCursor *) x));
}
static void *_p_FXIconTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXImage *) ((FXIcon *) x));
}
static void *_p_FXRealSpinnerTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXRealSpinner *) x));
}
static void *_p_FXSpinnerTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXSpinner *) x));
}
static void *_p_FXStatusLineTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXFrame *) ((FXStatusLine *) x));
}
static void *_p_FXScrollWindowTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXScrollArea *) ((FXScrollWindow *) x));
}
static void *_p_FXWindowTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *) ((FXWindow *) x));
}
static void *_p_FXRootWindowTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *) ((FXRootWindow *) x));
}
static void *_p_FXTopWindowTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXShell *) ((FXTopWindow *) x));
}
static void *_p_FXMainWindowTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXShell *)(FXTopWindow *) ((FXMainWindow *) x));
}
static void *_p_FXTGAIconTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXImage *)(FXIcon *) ((FXTGAIcon *) x));
}
static void *_p_FXDictTo_p_FXObject(void *x) {
    return (void *)((FXObject *)  ((FXDict *) x));
}
static void *_p_FXShellTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *) ((FXShell *) x));
}
static void *_p_FXPCXIconTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXImage *)(FXIcon *) ((FXPCXIcon *) x));
}
static void *_p_FXBitmapTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *) ((FXBitmap *) x));
}
static void *_p_FXScrollAreaTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *) ((FXScrollArea *) x));
}
static void *_p_FXColorWellTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXFrame *) ((FXColorWell *) x));
}
static void *_p_FXDragCornerTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *) ((FXDragCorner *) x));
}
static void *_p_FXRulerTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXFrame *) ((FXRuler *) x));
}
static void *_p_FXRGBIconTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXImage *)(FXIcon *) ((FXRGBIcon *) x));
}
static void *_p_FXDialTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXFrame *) ((FXDial *) x));
}
static void *_p_FXHorizontalFrameTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXHorizontalFrame *) x));
}
static void *_p_FXVerticalFrameTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXVerticalFrame *) x));
}
static void *_p_FXImageViewTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXScrollArea *) ((FXImageView *) x));
}
static void *_p_FXDirSelectorTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXDirSelector *) x));
}
static void *_p_FXFileSelectorTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXFileSelector *) x));
}
static void *_p_FXColorSelectorTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXColorSelector *) x));
}
static void *_p_FXFontSelectorTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXFontSelector *) x));
}
static void *_p_FXXBMIconTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXImage *)(FXIcon *) ((FXXBMIcon *) x));
}
static void *_p_FXToolBarTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXToolBar *) x));
}
static void *_p_FXToolBarShellTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXShell *)(FXTopWindow *) ((FXToolBarShell *) x));
}
static void *_p_FXDirBoxTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *)(FXTreeListBox *) ((FXDirBox *) x));
}
static void *_p_FXPPMIconTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXImage *)(FXIcon *) ((FXPPMIcon *) x));
}
static void *_p_FXXPMIconTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXImage *)(FXIcon *) ((FXXPMIcon *) x));
}
static void *_p_FXFileStreamTo_p_FXStream(void *x) {
    return (void *)((FXStream *)  ((FXFileStream *) x));
}
static void *_p_FXMemoryStreamTo_p_FXStream(void *x) {
    return (void *)((FXStream *)  ((FXMemoryStream *) x));
}
static void *_p_FXPNGIconTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXImage *)(FXIcon *) ((FXPNGIcon *) x));
}
static void *_p_FXShutterItemTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *)(FXVerticalFrame *) ((FXShutterItem *) x));
}
static void *_p_FXColorBarTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXFrame *) ((FXColorBar *) x));
}
static void *_p_FXTabBarTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *) ((FXTabBar *) x));
}
static void *_p_FXRGBImageTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXImage *) ((FXRGBImage *) x));
}
static void *_p_FXSwitcherTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *) ((FXSwitcher *) x));
}
static void *_p_FXTextFieldTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXFrame *) ((FXTextField *) x));
}
static void *_p_FXToolBarTabTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXFrame *) ((FXToolBarTab *) x));
}
static void *_p_FXDriveBoxTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *)(FXListBox *) ((FXDriveBox *) x));
}
static void *_p_FXBMPImageTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXImage *) ((FXBMPImage *) x));
}
static void *_p_FXMatrixTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *) ((FXMatrix *) x));
}
static void *_p_FXScrollCornerTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *) ((FXScrollCorner *) x));
}
static void *_p_FXArrowButtonTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXFrame *) ((FXArrowButton *) x));
}
static void *_p_FXPopupTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXShell *) ((FXPopup *) x));
}
static void *_p_FXJPGIconTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXImage *)(FXIcon *) ((FXJPGIcon *) x));
}
static void *_p_FXPCXImageTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXImage *) ((FXPCXImage *) x));
}
static void *_p_FXGIFIconTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXImage *)(FXIcon *) ((FXGIFIcon *) x));
}
static void *_p_FXHeaderTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXFrame *) ((FXHeader *) x));
}
static void *_p_FXSplitterTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *) ((FXSplitter *) x));
}
static void *_p_FX4SplitterTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *) ((FX4Splitter *) x));
}
static void *_p_FXSpringTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *) ((FXSpring *) x));
}
static void *_p_FXPackerTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *) ((FXPacker *) x));
}
static void *_p_FXTabBookTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *)(FXTabBar *) ((FXTabBook *) x));
}
static void *_p_FXBMPIconTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXImage *)(FXIcon *) ((FXBMPIcon *) x));
}
static void *_p_FXImageFrameTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXFrame *) ((FXImageFrame *) x));
}
static void *_p_FXVerticalSeparatorTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXFrame *)(FXSeparator *) ((FXVerticalSeparator *) x));
}
static void *_p_FXSeparatorTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXFrame *) ((FXSeparator *) x));
}
static void *_p_FXHorizontalSeparatorTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXFrame *)(FXSeparator *) ((FXHorizontalSeparator *) x));
}
static void *_p_FXProgressBarTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXFrame *) ((FXProgressBar *) x));
}
static void *_p_FXShutterTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *)(FXVerticalFrame *) ((FXShutter *) x));
}
static void *_p_FXTGAImageTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXImage *) ((FXTGAImage *) x));
}
static void *_p_FXICOIconTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXImage *)(FXIcon *) ((FXICOIcon *) x));
}
static void *_p_FXToolTipTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXShell *) ((FXToolTip *) x));
}
static void *_p_FXCompositeTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *) ((FXComposite *) x));
}
static void *_p_FXICOImageTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXImage *) ((FXICOImage *) x));
}
static void *_p_FXBitmapFrameTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXFrame *) ((FXBitmapFrame *) x));
}
static void *_p_FXRealSliderTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXFrame *) ((FXRealSlider *) x));
}
static void *_p_FXSliderTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXFrame *) ((FXSlider *) x));
}
static void *_p_FXGroupBoxTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *) ((FXGroupBox *) x));
}
static void *_p_FXPPMImageTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXImage *) ((FXPPMImage *) x));
}
static void *_p_FXXBMImageTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXImage *) ((FXXBMImage *) x));
}
static void *_p_FXXPMImageTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXImage *) ((FXXPMImage *) x));
}
static void *_p_FXTreeListBoxTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *) ((FXTreeListBox *) x));
}
static void *_p_FXListBoxTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *) ((FXListBox *) x));
}
static void *_p_FXCanvasTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *) ((FXCanvas *) x));
}
static void *_p_FXColorWheelTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXFrame *) ((FXColorWheel *) x));
}
static void *_p_FXToolBarGripTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *) ((FXToolBarGrip *) x));
}
static void *_p_FXScrollBarTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *) ((FXScrollBar *) x));
}
static void *_p_FXComboBoxTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *) ((FXComboBox *) x));
}
static void *_p_FXImageTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *)  ((FXImage *) x));
}
static void *_p_FXTIFIconTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXImage *)(FXIcon *) ((FXTIFIcon *) x));
}
static void *_p_FXFrameTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *) ((FXFrame *) x));
}
static void *_p_FXPNGImageTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXImage *) ((FXPNGImage *) x));
}
static void *_p_FXJPGImageTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXImage *) ((FXJPGImage *) x));
}
static void *_p_FXTIFImageTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXImage *) ((FXTIFImage *) x));
}
static void *_p_FXGIFImageTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXImage *) ((FXGIFImage *) x));
}
static void *_p_FXStatusBarTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *)(FXHorizontalFrame *) ((FXStatusBar *) x));
}
static void *_p_FXIconTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXImage *) ((FXIcon *) x));
}
static void *_p_FXRealSpinnerTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *) ((FXRealSpinner *) x));
}
static void *_p_FXSpinnerTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *) ((FXSpinner *) x));
}
static void *_p_FXStatusLineTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXFrame *) ((FXStatusLine *) x));
}
static void *_p_FXMainWindowTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXShell *)(FXTopWindow *) ((FXMainWindow *) x));
}
static void *_p_FXTopWindowTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXShell *) ((FXTopWindow *) x));
}
static void *_p_FXRootWindowTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *) ((FXRootWindow *) x));
}
static void *_p_FXWindowTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *)  ((FXWindow *) x));
}
static void *_p_FXScrollWindowTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXScrollArea *) ((FXScrollWindow *) x));
}
static void *_p_FXTGAIconTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXImage *)(FXIcon *) ((FXTGAIcon *) x));
}
static void *_p_FXShellTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *) ((FXShell *) x));
}
static void *_p_FXPCXIconTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXImage *)(FXIcon *) ((FXPCXIcon *) x));
}
static void *_p_FXBitmapTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *)  ((FXBitmap *) x));
}
static void *_p_FXScrollAreaTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *) ((FXScrollArea *) x));
}
static void *_p_FXColorWellTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXFrame *) ((FXColorWell *) x));
}
static void *_p_FXDragCornerTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *) ((FXDragCorner *) x));
}
static void *_p_FXRulerTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXFrame *) ((FXRuler *) x));
}
static void *_p_FXRGBIconTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXImage *)(FXIcon *) ((FXRGBIcon *) x));
}
static void *_p_FXDialTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXFrame *) ((FXDial *) x));
}
static void *_p_FXVerticalFrameTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *) ((FXVerticalFrame *) x));
}
static void *_p_FXHorizontalFrameTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *) ((FXHorizontalFrame *) x));
}
static void *_p_FXImageViewTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXScrollArea *) ((FXImageView *) x));
}
static void *_p_FXFontSelectorTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *) ((FXFontSelector *) x));
}
static void *_p_FXColorSelectorTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *) ((FXColorSelector *) x));
}
static void *_p_FXFileSelectorTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *) ((FXFileSelector *) x));
}
static void *_p_FXDirSelectorTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *) ((FXDirSelector *) x));
}
static void *_p_FXXBMIconTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXImage *)(FXIcon *) ((FXXBMIcon *) x));
}
static void *_p_FXToolBarShellTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXShell *)(FXTopWindow *) ((FXToolBarShell *) x));
}
static void *_p_FXToolBarTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *) ((FXToolBar *) x));
}
static void *_p_FXDirBoxTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *)(FXTreeListBox *) ((FXDirBox *) x));
}
static void *_p_FXPPMIconTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXImage *)(FXIcon *) ((FXPPMIcon *) x));
}
static void *_p_FXXPMIconTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXImage *)(FXIcon *) ((FXXPMIcon *) x));
}
static void *_p_FXICOIconTo_p_FXIcon(void *x) {
    return (void *)((FXIcon *)  ((FXICOIcon *) x));
}
static void *_p_FXJPGIconTo_p_FXIcon(void *x) {
    return (void *)((FXIcon *)  ((FXJPGIcon *) x));
}
static void *_p_FXPCXIconTo_p_FXIcon(void *x) {
    return (void *)((FXIcon *)  ((FXPCXIcon *) x));
}
static void *_p_FXTGAIconTo_p_FXIcon(void *x) {
    return (void *)((FXIcon *)  ((FXTGAIcon *) x));
}
static void *_p_FXBMPIconTo_p_FXIcon(void *x) {
    return (void *)((FXIcon *)  ((FXBMPIcon *) x));
}
static void *_p_FXPNGIconTo_p_FXIcon(void *x) {
    return (void *)((FXIcon *)  ((FXPNGIcon *) x));
}
static void *_p_FXPPMIconTo_p_FXIcon(void *x) {
    return (void *)((FXIcon *)  ((FXPPMIcon *) x));
}
static void *_p_FXTIFIconTo_p_FXIcon(void *x) {
    return (void *)((FXIcon *)  ((FXTIFIcon *) x));
}
static void *_p_FXXBMIconTo_p_FXIcon(void *x) {
    return (void *)((FXIcon *)  ((FXXBMIcon *) x));
}
static void *_p_FXXPMIconTo_p_FXIcon(void *x) {
    return (void *)((FXIcon *)  ((FXXPMIcon *) x));
}
static void *_p_FXGIFIconTo_p_FXIcon(void *x) {
    return (void *)((FXIcon *)  ((FXGIFIcon *) x));
}
static void *_p_FXRGBIconTo_p_FXIcon(void *x) {
    return (void *)((FXIcon *)  ((FXRGBIcon *) x));
}
static void *_p_FXRGBImageTo_p_FXImage(void *x) {
    return (void *)((FXImage *)  ((FXRGBImage *) x));
}
static void *_p_FXGIFIconTo_p_FXImage(void *x) {
    return (void *)((FXImage *) (FXIcon *) ((FXGIFIcon *) x));
}
static void *_p_FXJPGIconTo_p_FXImage(void *x) {
    return (void *)((FXImage *) (FXIcon *) ((FXJPGIcon *) x));
}
static void *_p_FXXBMIconTo_p_FXImage(void *x) {
    return (void *)((FXImage *) (FXIcon *) ((FXXBMIcon *) x));
}
static void *_p_FXBMPIconTo_p_FXImage(void *x) {
    return (void *)((FXImage *) (FXIcon *) ((FXBMPIcon *) x));
}
static void *_p_FXRGBIconTo_p_FXImage(void *x) {
    return (void *)((FXImage *) (FXIcon *) ((FXRGBIcon *) x));
}
static void *_p_FXTIFIconTo_p_FXImage(void *x) {
    return (void *)((FXImage *) (FXIcon *) ((FXTIFIcon *) x));
}
static void *_p_FXTGAIconTo_p_FXImage(void *x) {
    return (void *)((FXImage *) (FXIcon *) ((FXTGAIcon *) x));
}
static void *_p_FXTIFImageTo_p_FXImage(void *x) {
    return (void *)((FXImage *)  ((FXTIFImage *) x));
}
static void *_p_FXGIFImageTo_p_FXImage(void *x) {
    return (void *)((FXImage *)  ((FXGIFImage *) x));
}
static void *_p_FXPCXIconTo_p_FXImage(void *x) {
    return (void *)((FXImage *) (FXIcon *) ((FXPCXIcon *) x));
}
static void *_p_FXICOImageTo_p_FXImage(void *x) {
    return (void *)((FXImage *)  ((FXICOImage *) x));
}
static void *_p_FXXPMImageTo_p_FXImage(void *x) {
    return (void *)((FXImage *)  ((FXXPMImage *) x));
}
static void *_p_FXXBMImageTo_p_FXImage(void *x) {
    return (void *)((FXImage *)  ((FXXBMImage *) x));
}
static void *_p_FXPPMImageTo_p_FXImage(void *x) {
    return (void *)((FXImage *)  ((FXPPMImage *) x));
}
static void *_p_FXPCXImageTo_p_FXImage(void *x) {
    return (void *)((FXImage *)  ((FXPCXImage *) x));
}
static void *_p_FXBMPImageTo_p_FXImage(void *x) {
    return (void *)((FXImage *)  ((FXBMPImage *) x));
}
static void *_p_FXPPMIconTo_p_FXImage(void *x) {
    return (void *)((FXImage *) (FXIcon *) ((FXPPMIcon *) x));
}
static void *_p_FXXPMIconTo_p_FXImage(void *x) {
    return (void *)((FXImage *) (FXIcon *) ((FXXPMIcon *) x));
}
static void *_p_FXICOIconTo_p_FXImage(void *x) {
    return (void *)((FXImage *) (FXIcon *) ((FXICOIcon *) x));
}
static void *_p_FXPNGIconTo_p_FXImage(void *x) {
    return (void *)((FXImage *) (FXIcon *) ((FXPNGIcon *) x));
}
static void *_p_FXIconTo_p_FXImage(void *x) {
    return (void *)((FXImage *)  ((FXIcon *) x));
}
static void *_p_FXPNGImageTo_p_FXImage(void *x) {
    return (void *)((FXImage *)  ((FXPNGImage *) x));
}
static void *_p_FXJPGImageTo_p_FXImage(void *x) {
    return (void *)((FXImage *)  ((FXJPGImage *) x));
}
static void *_p_FXTGAImageTo_p_FXImage(void *x) {
    return (void *)((FXImage *)  ((FXTGAImage *) x));
}
static swig_type_info _swigt__p_FXGIFIcon[] = {{"_p_FXGIFIcon", 0, "FXGIFIcon *", 0, 0, 0, 0},{"_p_FXGIFIcon", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXObject[] = {{"_p_FXObject", 0, "FXObject *", 0, 0, 0, 0},{"_p_FXDocument", _p_FXDocumentTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXPNGIcon", _p_FXPNGIconTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXRegistry", _p_FXRegistryTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXHeaderItem", _p_FXHeaderItemTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXShutterItem", _p_FXShutterItemTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXColorBar", _p_FXColorBarTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXTabBar", _p_FXTabBarTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXRGBImage", _p_FXRGBImageTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXSwitcher", _p_FXSwitcherTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXTextField", _p_FXTextFieldTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXToolBarTab", _p_FXToolBarTabTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXDriveBox", _p_FXDriveBoxTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXIconDict", _p_FXIconDictTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXBMPImage", _p_FXBMPImageTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXMatrix", _p_FXMatrixTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXFileDict", _p_FXFileDictTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXRecentFiles", _p_FXRecentFilesTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXScrollCorner", _p_FXScrollCornerTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXArrowButton", _p_FXArrowButtonTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXPopup", _p_FXPopupTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXDrawable", _p_FXDrawableTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXJPGIcon", _p_FXJPGIconTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXFont", _p_FXFontTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXGIFIcon", _p_FXGIFIconTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXPCXImage", _p_FXPCXImageTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXHeader", _p_FXHeaderTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXSplitter", _p_FXSplitterTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FX4Splitter", _p_FX4SplitterTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXSpring", _p_FXSpringTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXPacker", _p_FXPackerTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXTabBook", _p_FXTabBookTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXApp", _p_FXAppTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXBMPIcon", _p_FXBMPIconTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXImageFrame", _p_FXImageFrameTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXHorizontalSeparator", _p_FXHorizontalSeparatorTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXSeparator", _p_FXSeparatorTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXVerticalSeparator", _p_FXVerticalSeparatorTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXIcon", _p_FXIconTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXProgressBar", _p_FXProgressBarTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXICOIcon", _p_FXICOIconTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXShutter", _p_FXShutterTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXTGAImage", _p_FXTGAImageTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXToolTip", _p_FXToolTipTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXComposite", _p_FXCompositeTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXDict", _p_FXDictTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXICOImage", _p_FXICOImageTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXBitmapFrame", _p_FXBitmapFrameTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXRealSlider", _p_FXRealSliderTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXSlider", _p_FXSliderTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXSettings", _p_FXSettingsTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXGroupBox", _p_FXGroupBoxTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXDataTarget", _p_FXDataTargetTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXDebugTarget", _p_FXDebugTargetTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXPPMImage", _p_FXPPMImageTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXXBMImage", _p_FXXBMImageTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXXPMImage", _p_FXXPMImageTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXTreeListBox", _p_FXTreeListBoxTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXListBox", _p_FXListBoxTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXCanvas", _p_FXCanvasTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXId", _p_FXIdTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXColorWheel", _p_FXColorWheelTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXDial", _p_FXDialTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXToolBarGrip", _p_FXToolBarGripTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXScrollBar", _p_FXScrollBarTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXVisual", _p_FXVisualTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXComboBox", _p_FXComboBoxTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXTIFIcon", _p_FXTIFIconTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXImage", _p_FXImageTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXFrame", _p_FXFrameTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXJPGImage", _p_FXJPGImageTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXPNGImage", _p_FXPNGImageTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXTIFImage", _p_FXTIFImageTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXGIFImage", _p_FXGIFImageTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXStatusBar", _p_FXStatusBarTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXStringDict", _p_FXStringDictTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXDelegator", _p_FXDelegatorTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXAccelTable", _p_FXAccelTableTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXObject", 0, 0, 0, 0, 0, 0},{"_p_FXCursor", _p_FXCursorTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXCURCursor", _p_FXCURCursorTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXGIFCursor", _p_FXGIFCursorTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXSpinner", _p_FXSpinnerTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXRealSpinner", _p_FXRealSpinnerTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXTGAIcon", _p_FXTGAIconTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXStatusLine", _p_FXStatusLineTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXScrollWindow", _p_FXScrollWindowTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXWindow", _p_FXWindowTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXRootWindow", _p_FXRootWindowTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXTopWindow", _p_FXTopWindowTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXMainWindow", _p_FXMainWindowTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXPCXIcon", _p_FXPCXIconTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXShell", _p_FXShellTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXBitmap", _p_FXBitmapTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXScrollArea", _p_FXScrollAreaTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXColorWell", _p_FXColorWellTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXDragCorner", _p_FXDragCornerTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXRuler", _p_FXRulerTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXRGBIcon", _p_FXRGBIconTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXVerticalFrame", _p_FXVerticalFrameTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXHorizontalFrame", _p_FXHorizontalFrameTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXXBMIcon", _p_FXXBMIconTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXImageView", _p_FXImageViewTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXFontSelector", _p_FXFontSelectorTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXColorSelector", _p_FXColorSelectorTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXFileSelector", _p_FXFileSelectorTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXDirSelector", _p_FXDirSelectorTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXToolBarShell", _p_FXToolBarShellTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXToolBar", _p_FXToolBarTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXXPMIcon", _p_FXXPMIconTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXPPMIcon", _p_FXPPMIconTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXDirBox", _p_FXDirBoxTo_p_FXObject, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXJPGIcon[] = {{"_p_FXJPGIcon", 0, "FXJPGIcon *", 0, 0, 0, 0},{"_p_FXJPGIcon", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXXBMIcon[] = {{"_p_FXXBMIcon", 0, "FXXBMIcon *", 0, 0, 0, 0},{"_p_FXXBMIcon", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXuchar[] = {{"_p_FXuchar", 0, "unsigned char const *|FXuchar const *", 0, 0, 0, 0},{"_p_FXuchar", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXBMPIcon[] = {{"_p_FXBMPIcon", 0, "FXBMPIcon *", 0, 0, 0, 0},{"_p_FXBMPIcon", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXRGBIcon[] = {{"_p_FXRGBIcon", 0, "FXRGBIcon *", 0, 0, 0, 0},{"_p_FXRGBIcon", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXTIFIcon[] = {{"_p_FXTIFIcon", 0, "FXTIFIcon *", 0, 0, 0, 0},{"_p_FXTIFIcon", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXId[] = {{"_p_FXId", 0, "FXId *", 0, 0, 0, 0},{"_p_FXPNGIcon", _p_FXPNGIconTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXShutterItem", _p_FXShutterItemTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXColorBar", _p_FXColorBarTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXTabBar", _p_FXTabBarTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXRGBImage", _p_FXRGBImageTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXSwitcher", _p_FXSwitcherTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXTextField", _p_FXTextFieldTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXToolBarTab", _p_FXToolBarTabTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXDriveBox", _p_FXDriveBoxTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXBMPImage", _p_FXBMPImageTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXMatrix", _p_FXMatrixTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXScrollCorner", _p_FXScrollCornerTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXArrowButton", _p_FXArrowButtonTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXPopup", _p_FXPopupTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXDrawable", _p_FXDrawableTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXJPGIcon", _p_FXJPGIconTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXFont", _p_FXFontTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXGIFIcon", _p_FXGIFIconTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXPCXImage", _p_FXPCXImageTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXHeader", _p_FXHeaderTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXSplitter", _p_FXSplitterTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FX4Splitter", _p_FX4SplitterTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXSpring", _p_FXSpringTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXPacker", _p_FXPackerTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXTabBook", _p_FXTabBookTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXBMPIcon", _p_FXBMPIconTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXImageFrame", _p_FXImageFrameTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXVerticalSeparator", _p_FXVerticalSeparatorTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXSeparator", _p_FXSeparatorTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXHorizontalSeparator", _p_FXHorizontalSeparatorTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXIcon", _p_FXIconTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXProgressBar", _p_FXProgressBarTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXICOIcon", _p_FXICOIconTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXShutter", _p_FXShutterTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXTGAImage", _p_FXTGAImageTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXToolTip", _p_FXToolTipTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXComposite", _p_FXCompositeTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXICOImage", _p_FXICOImageTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXBitmapFrame", _p_FXBitmapFrameTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXRealSlider", _p_FXRealSliderTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXSlider", _p_FXSliderTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXGroupBox", _p_FXGroupBoxTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXPPMImage", _p_FXPPMImageTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXXBMImage", _p_FXXBMImageTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXXPMImage", _p_FXXPMImageTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXTreeListBox", _p_FXTreeListBoxTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXListBox", _p_FXListBoxTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXCanvas", _p_FXCanvasTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXId", 0, 0, 0, 0, 0, 0},{"_p_FXColorWheel", _p_FXColorWheelTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXDial", _p_FXDialTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXToolBarGrip", _p_FXToolBarGripTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXScrollBar", _p_FXScrollBarTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXVisual", _p_FXVisualTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXComboBox", _p_FXComboBoxTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXTIFIcon", _p_FXTIFIconTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXImage", _p_FXImageTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXFrame", _p_FXFrameTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXJPGImage", _p_FXJPGImageTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXPNGImage", _p_FXPNGImageTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXTIFImage", _p_FXTIFImageTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXGIFImage", _p_FXGIFImageTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXStatusBar", _p_FXStatusBarTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXCursor", _p_FXCursorTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXCURCursor", _p_FXCURCursorTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXGIFCursor", _p_FXGIFCursorTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXRealSpinner", _p_FXRealSpinnerTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXSpinner", _p_FXSpinnerTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXStatusLine", _p_FXStatusLineTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXTopWindow", _p_FXTopWindowTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXRootWindow", _p_FXRootWindowTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXWindow", _p_FXWindowTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXScrollWindow", _p_FXScrollWindowTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXTGAIcon", _p_FXTGAIconTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXMainWindow", _p_FXMainWindowTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXPCXIcon", _p_FXPCXIconTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXShell", _p_FXShellTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXBitmap", _p_FXBitmapTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXScrollArea", _p_FXScrollAreaTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXColorWell", _p_FXColorWellTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXDragCorner", _p_FXDragCornerTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXRuler", _p_FXRulerTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXRGBIcon", _p_FXRGBIconTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXVerticalFrame", _p_FXVerticalFrameTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXHorizontalFrame", _p_FXHorizontalFrameTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXXBMIcon", _p_FXXBMIconTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXImageView", _p_FXImageViewTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXFontSelector", _p_FXFontSelectorTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXColorSelector", _p_FXColorSelectorTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXFileSelector", _p_FXFileSelectorTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXDirSelector", _p_FXDirSelectorTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXToolBarShell", _p_FXToolBarShellTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXToolBar", _p_FXToolBarTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXXPMIcon", _p_FXXPMIconTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXPPMIcon", _p_FXPPMIconTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXDirBox", _p_FXDirBoxTo_p_FXId, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXTGAIcon[] = {{"_p_FXTGAIcon", 0, "FXTGAIcon *", 0, 0, 0, 0},{"_p_FXTGAIcon", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_p_FXchar[] = {{"_p_p_FXchar", 0, "char const **|FXchar const **", 0, 0, 0, 0},{"_p_p_FXchar", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXStream[] = {{"_p_FXStream", 0, "FXStream *", 0, 0, 0, 0},{"_p_FXFileStream", _p_FXFileStreamTo_p_FXStream, 0, 0, 0, 0, 0},{"_p_FXMemoryStream", _p_FXMemoryStreamTo_p_FXStream, 0, 0, 0, 0, 0},{"_p_FXStream", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXDrawable[] = {{"_p_FXDrawable", 0, "FXDrawable *", 0, 0, 0, 0},{"_p_FXPNGIcon", _p_FXPNGIconTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXShutterItem", _p_FXShutterItemTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXColorBar", _p_FXColorBarTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXTabBar", _p_FXTabBarTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXRGBImage", _p_FXRGBImageTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXSwitcher", _p_FXSwitcherTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXTextField", _p_FXTextFieldTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXToolBarTab", _p_FXToolBarTabTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXDriveBox", _p_FXDriveBoxTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXBMPImage", _p_FXBMPImageTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXMatrix", _p_FXMatrixTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXScrollCorner", _p_FXScrollCornerTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXArrowButton", _p_FXArrowButtonTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXPopup", _p_FXPopupTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXDrawable", 0, 0, 0, 0, 0, 0},{"_p_FXJPGIcon", _p_FXJPGIconTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXGIFIcon", _p_FXGIFIconTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXPCXImage", _p_FXPCXImageTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXHeader", _p_FXHeaderTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXSplitter", _p_FXSplitterTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FX4Splitter", _p_FX4SplitterTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXSpring", _p_FXSpringTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXPacker", _p_FXPackerTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXTabBook", _p_FXTabBookTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXBMPIcon", _p_FXBMPIconTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXImageFrame", _p_FXImageFrameTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXVerticalSeparator", _p_FXVerticalSeparatorTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXSeparator", _p_FXSeparatorTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXHorizontalSeparator", _p_FXHorizontalSeparatorTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXIcon", _p_FXIconTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXProgressBar", _p_FXProgressBarTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXICOIcon", _p_FXICOIconTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXShutter", _p_FXShutterTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXTGAImage", _p_FXTGAImageTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXToolTip", _p_FXToolTipTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXComposite", _p_FXCompositeTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXICOImage", _p_FXICOImageTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXBitmapFrame", _p_FXBitmapFrameTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXRealSlider", _p_FXRealSliderTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXSlider", _p_FXSliderTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXGroupBox", _p_FXGroupBoxTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXPPMImage", _p_FXPPMImageTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXXBMImage", _p_FXXBMImageTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXXPMImage", _p_FXXPMImageTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXTreeListBox", _p_FXTreeListBoxTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXListBox", _p_FXListBoxTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXCanvas", _p_FXCanvasTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXColorWheel", _p_FXColorWheelTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXDial", _p_FXDialTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXToolBarGrip", _p_FXToolBarGripTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXScrollBar", _p_FXScrollBarTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXComboBox", _p_FXComboBoxTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXTIFIcon", _p_FXTIFIconTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXImage", _p_FXImageTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXFrame", _p_FXFrameTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXJPGImage", _p_FXJPGImageTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXPNGImage", _p_FXPNGImageTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXTIFImage", _p_FXTIFImageTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXGIFImage", _p_FXGIFImageTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXStatusBar", _p_FXStatusBarTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXRealSpinner", _p_FXRealSpinnerTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXSpinner", _p_FXSpinnerTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXStatusLine", _p_FXStatusLineTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXMainWindow", _p_FXMainWindowTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXTopWindow", _p_FXTopWindowTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXRootWindow", _p_FXRootWindowTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXWindow", _p_FXWindowTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXScrollWindow", _p_FXScrollWindowTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXTGAIcon", _p_FXTGAIconTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXPCXIcon", _p_FXPCXIconTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXShell", _p_FXShellTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXBitmap", _p_FXBitmapTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXScrollArea", _p_FXScrollAreaTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXColorWell", _p_FXColorWellTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXDragCorner", _p_FXDragCornerTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXRuler", _p_FXRulerTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXRGBIcon", _p_FXRGBIconTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXVerticalFrame", _p_FXVerticalFrameTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXHorizontalFrame", _p_FXHorizontalFrameTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXXBMIcon", _p_FXXBMIconTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXImageView", _p_FXImageViewTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXFontSelector", _p_FXFontSelectorTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXColorSelector", _p_FXColorSelectorTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXFileSelector", _p_FXFileSelectorTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXDirSelector", _p_FXDirSelectorTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXToolBarShell", _p_FXToolBarShellTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXToolBar", _p_FXToolBarTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXXPMIcon", _p_FXXPMIconTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXPPMIcon", _p_FXPPMIconTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXDirBox", _p_FXDirBoxTo_p_FXDrawable, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXPCXIcon[] = {{"_p_FXPCXIcon", 0, "FXPCXIcon *", 0, 0, 0, 0},{"_p_FXPCXIcon", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXIcon[] = {{"_p_FXIcon", 0, "FXIcon *", 0, 0, 0, 0},{"_p_FXIcon", 0, 0, 0, 0, 0, 0},{"_p_FXICOIcon", _p_FXICOIconTo_p_FXIcon, 0, 0, 0, 0, 0},{"_p_FXJPGIcon", _p_FXJPGIconTo_p_FXIcon, 0, 0, 0, 0, 0},{"_p_FXPCXIcon", _p_FXPCXIconTo_p_FXIcon, 0, 0, 0, 0, 0},{"_p_FXTGAIcon", _p_FXTGAIconTo_p_FXIcon, 0, 0, 0, 0, 0},{"_p_FXBMPIcon", _p_FXBMPIconTo_p_FXIcon, 0, 0, 0, 0, 0},{"_p_FXPNGIcon", _p_FXPNGIconTo_p_FXIcon, 0, 0, 0, 0, 0},{"_p_FXPPMIcon", _p_FXPPMIconTo_p_FXIcon, 0, 0, 0, 0, 0},{"_p_FXTIFIcon", _p_FXTIFIconTo_p_FXIcon, 0, 0, 0, 0, 0},{"_p_FXXBMIcon", _p_FXXBMIconTo_p_FXIcon, 0, 0, 0, 0, 0},{"_p_FXXPMIcon", _p_FXXPMIconTo_p_FXIcon, 0, 0, 0, 0, 0},{"_p_FXGIFIcon", _p_FXGIFIconTo_p_FXIcon, 0, 0, 0, 0, 0},{"_p_FXRGBIcon", _p_FXRGBIconTo_p_FXIcon, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXColor[] = {{"_p_FXColor", 0, "unsigned int const *|FXColor const *", 0, 0, 0, 0},{"_p_FXColor", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXPPMIcon[] = {{"_p_FXPPMIcon", 0, "FXPPMIcon *", 0, 0, 0, 0},{"_p_FXPPMIcon", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXXPMIcon[] = {{"_p_FXXPMIcon", 0, "FXXPMIcon *", 0, 0, 0, 0},{"_p_FXXPMIcon", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXPNGIcon[] = {{"_p_FXPNGIcon", 0, "FXPNGIcon *", 0, 0, 0, 0},{"_p_FXPNGIcon", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXICOIcon[] = {{"_p_FXICOIcon", 0, "FXICOIcon *", 0, 0, 0, 0},{"_p_FXICOIcon", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXApp[] = {{"_p_FXApp", 0, "FXApp *", 0, 0, 0, 0},{"_p_FXApp", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXImage[] = {{"_p_FXImage", 0, "FXImage *", 0, 0, 0, 0},{"_p_FXGIFIcon", _p_FXGIFIconTo_p_FXImage, 0, 0, 0, 0, 0},{"_p_FXXBMIcon", _p_FXXBMIconTo_p_FXImage, 0, 0, 0, 0, 0},{"_p_FXRGBImage", _p_FXRGBImageTo_p_FXImage, 0, 0, 0, 0, 0},{"_p_FXJPGIcon", _p_FXJPGIconTo_p_FXImage, 0, 0, 0, 0, 0},{"_p_FXBMPIcon", _p_FXBMPIconTo_p_FXImage, 0, 0, 0, 0, 0},{"_p_FXRGBIcon", _p_FXRGBIconTo_p_FXImage, 0, 0, 0, 0, 0},{"_p_FXTIFIcon", _p_FXTIFIconTo_p_FXImage, 0, 0, 0, 0, 0},{"_p_FXTGAIcon", _p_FXTGAIconTo_p_FXImage, 0, 0, 0, 0, 0},{"_p_FXTIFImage", _p_FXTIFImageTo_p_FXImage, 0, 0, 0, 0, 0},{"_p_FXGIFImage", _p_FXGIFImageTo_p_FXImage, 0, 0, 0, 0, 0},{"_p_FXPCXIcon", _p_FXPCXIconTo_p_FXImage, 0, 0, 0, 0, 0},{"_p_FXICOImage", _p_FXICOImageTo_p_FXImage, 0, 0, 0, 0, 0},{"_p_FXXPMImage", _p_FXXPMImageTo_p_FXImage, 0, 0, 0, 0, 0},{"_p_FXXBMImage", _p_FXXBMImageTo_p_FXImage, 0, 0, 0, 0, 0},{"_p_FXPPMImage", _p_FXPPMImageTo_p_FXImage, 0, 0, 0, 0, 0},{"_p_FXPCXImage", _p_FXPCXImageTo_p_FXImage, 0, 0, 0, 0, 0},{"_p_FXIcon", _p_FXIconTo_p_FXImage, 0, 0, 0, 0, 0},{"_p_FXPPMIcon", _p_FXPPMIconTo_p_FXImage, 0, 0, 0, 0, 0},{"_p_FXXPMIcon", _p_FXXPMIconTo_p_FXImage, 0, 0, 0, 0, 0},{"_p_FXBMPImage", _p_FXBMPImageTo_p_FXImage, 0, 0, 0, 0, 0},{"_p_FXICOIcon", _p_FXICOIconTo_p_FXImage, 0, 0, 0, 0, 0},{"_p_FXPNGIcon", _p_FXPNGIconTo_p_FXImage, 0, 0, 0, 0, 0},{"_p_FXImage", 0, 0, 0, 0, 0, 0},{"_p_FXPNGImage", _p_FXPNGImageTo_p_FXImage, 0, 0, 0, 0, 0},{"_p_FXJPGImage", _p_FXJPGImageTo_p_FXImage, 0, 0, 0, 0, 0},{"_p_FXTGAImage", _p_FXTGAImageTo_p_FXImage, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};

static swig_type_info *swig_types_initial[] = {
_swigt__p_FXGIFIcon, 
_swigt__p_FXObject, 
_swigt__p_FXJPGIcon, 
_swigt__p_FXXBMIcon, 
_swigt__p_FXuchar, 
_swigt__p_FXBMPIcon, 
_swigt__p_FXRGBIcon, 
_swigt__p_FXTIFIcon, 
_swigt__p_FXId, 
_swigt__p_FXTGAIcon, 
_swigt__p_p_FXchar, 
_swigt__p_FXStream, 
_swigt__p_FXDrawable, 
_swigt__p_FXPCXIcon, 
_swigt__p_FXIcon, 
_swigt__p_FXColor, 
_swigt__p_FXPPMIcon, 
_swigt__p_FXXPMIcon, 
_swigt__p_FXPNGIcon, 
_swigt__p_FXICOIcon, 
_swigt__p_FXApp, 
_swigt__p_FXImage, 
0
};


/* -------- TYPE CONVERSION AND EQUIVALENCE RULES (END) -------- */


#ifdef __cplusplus
extern "C"
#endif
SWIGEXPORT(void) Init_icons(void) {
    int i;
    
    SWIG_InitRuntime();
    
    for (i = 0; swig_types_initial[i]; i++) {
        swig_types[i] = SWIG_TypeRegister(swig_types_initial[i]);
        SWIG_define_class(swig_types[i]);
    }
    
    
    cFXIcon.klass = rb_define_class_under(mFox, "FXIcon", ((swig_class *) SWIGTYPE_p_FXImage->clientdata)->klass);
    SWIG_TypeClientData(SWIGTYPE_p_FXIcon, (void *) &cFXIcon);
    rb_define_alloc_func(cFXIcon.klass, _wrap_FXIcon_allocate);
    rb_define_method(cFXIcon.klass, "initialize", VALUEFUNC(_wrap_new_FXIcon), -1);
    rb_define_method(cFXIcon.klass, "getTransparentColor", VALUEFUNC(_wrap_FXIcon_getTransparentColor), -1);
    rb_define_method(cFXIcon.klass, "setTransparentColor", VALUEFUNC(_wrap_FXIcon_setTransparentColor), -1);
    rb_define_method(cFXIcon.klass, "save", VALUEFUNC(_wrap_FXIcon_save), -1);
    rb_define_method(cFXIcon.klass, "load", VALUEFUNC(_wrap_FXIcon_load), -1);
    rb_define_method(cFXIcon.klass, "create", VALUEFUNC(_wrap_FXIcon_create), -1);
    rb_define_method(cFXIcon.klass, "detach", VALUEFUNC(_wrap_FXIcon_detach), -1);
    rb_define_method(cFXIcon.klass, "destroy", VALUEFUNC(_wrap_FXIcon_destroy), -1);
    rb_define_method(cFXIcon.klass, "resize", VALUEFUNC(_wrap_FXIcon_resize), -1);
    rb_define_method(cFXIcon.klass, "restore", VALUEFUNC(_wrap_FXIcon_restore), -1);
    rb_define_method(cFXIcon.klass, "render", VALUEFUNC(_wrap_FXIcon_render), -1);
    rb_define_method(cFXIcon.klass, "release", VALUEFUNC(_wrap_FXIcon_release), -1);
    rb_define_method(cFXIcon.klass, "scale", VALUEFUNC(_wrap_FXIcon_scale), -1);
    rb_define_method(cFXIcon.klass, "mirror", VALUEFUNC(_wrap_FXIcon_mirror), -1);
    rb_define_method(cFXIcon.klass, "rotate", VALUEFUNC(_wrap_FXIcon_rotate), -1);
    rb_define_method(cFXIcon.klass, "crop", VALUEFUNC(_wrap_FXIcon_crop), -1);
    rb_define_method(cFXIcon.klass, "fill", VALUEFUNC(_wrap_FXIcon_fill), -1);
    rb_define_method(cFXIcon.klass, "fade", VALUEFUNC(_wrap_FXIcon_fade), -1);
    rb_define_method(cFXIcon.klass, "xshear", VALUEFUNC(_wrap_FXIcon_xshear), -1);
    rb_define_method(cFXIcon.klass, "yshear", VALUEFUNC(_wrap_FXIcon_yshear), -1);
    rb_define_method(cFXIcon.klass, "hgradient", VALUEFUNC(_wrap_FXIcon_hgradient), -1);
    rb_define_method(cFXIcon.klass, "vgradient", VALUEFUNC(_wrap_FXIcon_vgradient), -1);
    rb_define_method(cFXIcon.klass, "gradient", VALUEFUNC(_wrap_FXIcon_gradient), -1);
    rb_define_method(cFXIcon.klass, "blend", VALUEFUNC(_wrap_FXIcon_blend), -1);
    rb_define_method(cFXIcon.klass, "savePixels", VALUEFUNC(_wrap_FXIcon_savePixels), -1);
    rb_define_method(cFXIcon.klass, "loadPixels", VALUEFUNC(_wrap_FXIcon_loadPixels), -1);
    cFXIcon.mark = (void (*)(void *)) FXRbIcon::markfunc;
    cFXIcon.destroy = (void (*)(void *)) FXRbObject::freefunc;
    
    SWIGTYPE_p_FXIcon->dcast = (swig_dycast_func) FXIcon_dynamic_cast;
    
    
    cFXBMPIcon.klass = rb_define_class_under(mFox, "FXBMPIcon", ((swig_class *) SWIGTYPE_p_FXIcon->clientdata)->klass);
    SWIG_TypeClientData(SWIGTYPE_p_FXBMPIcon, (void *) &cFXBMPIcon);
    rb_define_alloc_func(cFXBMPIcon.klass, _wrap_FXBMPIcon_allocate);
    rb_define_method(cFXBMPIcon.klass, "initialize", VALUEFUNC(_wrap_new_FXBMPIcon), -1);
    rb_define_method(cFXBMPIcon.klass, "save", VALUEFUNC(_wrap_FXBMPIcon_save), -1);
    rb_define_method(cFXBMPIcon.klass, "load", VALUEFUNC(_wrap_FXBMPIcon_load), -1);
    rb_define_method(cFXBMPIcon.klass, "create", VALUEFUNC(_wrap_FXBMPIcon_create), -1);
    rb_define_method(cFXBMPIcon.klass, "detach", VALUEFUNC(_wrap_FXBMPIcon_detach), -1);
    rb_define_method(cFXBMPIcon.klass, "destroy", VALUEFUNC(_wrap_FXBMPIcon_destroy), -1);
    rb_define_method(cFXBMPIcon.klass, "resize", VALUEFUNC(_wrap_FXBMPIcon_resize), -1);
    rb_define_method(cFXBMPIcon.klass, "restore", VALUEFUNC(_wrap_FXBMPIcon_restore), -1);
    rb_define_method(cFXBMPIcon.klass, "render", VALUEFUNC(_wrap_FXBMPIcon_render), -1);
    rb_define_method(cFXBMPIcon.klass, "release", VALUEFUNC(_wrap_FXBMPIcon_release), -1);
    rb_define_method(cFXBMPIcon.klass, "scale", VALUEFUNC(_wrap_FXBMPIcon_scale), -1);
    rb_define_method(cFXBMPIcon.klass, "mirror", VALUEFUNC(_wrap_FXBMPIcon_mirror), -1);
    rb_define_method(cFXBMPIcon.klass, "rotate", VALUEFUNC(_wrap_FXBMPIcon_rotate), -1);
    rb_define_method(cFXBMPIcon.klass, "crop", VALUEFUNC(_wrap_FXBMPIcon_crop), -1);
    rb_define_method(cFXBMPIcon.klass, "fill", VALUEFUNC(_wrap_FXBMPIcon_fill), -1);
    rb_define_method(cFXBMPIcon.klass, "fade", VALUEFUNC(_wrap_FXBMPIcon_fade), -1);
    rb_define_method(cFXBMPIcon.klass, "xshear", VALUEFUNC(_wrap_FXBMPIcon_xshear), -1);
    rb_define_method(cFXBMPIcon.klass, "yshear", VALUEFUNC(_wrap_FXBMPIcon_yshear), -1);
    rb_define_method(cFXBMPIcon.klass, "hgradient", VALUEFUNC(_wrap_FXBMPIcon_hgradient), -1);
    rb_define_method(cFXBMPIcon.klass, "vgradient", VALUEFUNC(_wrap_FXBMPIcon_vgradient), -1);
    rb_define_method(cFXBMPIcon.klass, "gradient", VALUEFUNC(_wrap_FXBMPIcon_gradient), -1);
    rb_define_method(cFXBMPIcon.klass, "blend", VALUEFUNC(_wrap_FXBMPIcon_blend), -1);
    rb_define_method(cFXBMPIcon.klass, "savePixels", VALUEFUNC(_wrap_FXBMPIcon_savePixels), -1);
    rb_define_method(cFXBMPIcon.klass, "loadPixels", VALUEFUNC(_wrap_FXBMPIcon_loadPixels), -1);
    cFXBMPIcon.mark = (void (*)(void *)) FXRbBMPIcon::markfunc;
    cFXBMPIcon.destroy = (void (*)(void *)) FXRbObject::freefunc;
    rb_define_module_function(mFox, "fxloadBMP", VALUEFUNC(_wrap_fxloadBMP), -1);
    rb_define_module_function(mFox, "fxsaveBMP", VALUEFUNC(_wrap_fxsaveBMP), -1);
    
    cFXGIFIcon.klass = rb_define_class_under(mFox, "FXGIFIcon", ((swig_class *) SWIGTYPE_p_FXIcon->clientdata)->klass);
    SWIG_TypeClientData(SWIGTYPE_p_FXGIFIcon, (void *) &cFXGIFIcon);
    rb_define_alloc_func(cFXGIFIcon.klass, _wrap_FXGIFIcon_allocate);
    rb_define_method(cFXGIFIcon.klass, "initialize", VALUEFUNC(_wrap_new_FXGIFIcon), -1);
    rb_define_method(cFXGIFIcon.klass, "save", VALUEFUNC(_wrap_FXGIFIcon_save), -1);
    rb_define_method(cFXGIFIcon.klass, "load", VALUEFUNC(_wrap_FXGIFIcon_load), -1);
    rb_define_method(cFXGIFIcon.klass, "create", VALUEFUNC(_wrap_FXGIFIcon_create), -1);
    rb_define_method(cFXGIFIcon.klass, "detach", VALUEFUNC(_wrap_FXGIFIcon_detach), -1);
    rb_define_method(cFXGIFIcon.klass, "destroy", VALUEFUNC(_wrap_FXGIFIcon_destroy), -1);
    rb_define_method(cFXGIFIcon.klass, "resize", VALUEFUNC(_wrap_FXGIFIcon_resize), -1);
    rb_define_method(cFXGIFIcon.klass, "restore", VALUEFUNC(_wrap_FXGIFIcon_restore), -1);
    rb_define_method(cFXGIFIcon.klass, "render", VALUEFUNC(_wrap_FXGIFIcon_render), -1);
    rb_define_method(cFXGIFIcon.klass, "release", VALUEFUNC(_wrap_FXGIFIcon_release), -1);
    rb_define_method(cFXGIFIcon.klass, "scale", VALUEFUNC(_wrap_FXGIFIcon_scale), -1);
    rb_define_method(cFXGIFIcon.klass, "mirror", VALUEFUNC(_wrap_FXGIFIcon_mirror), -1);
    rb_define_method(cFXGIFIcon.klass, "rotate", VALUEFUNC(_wrap_FXGIFIcon_rotate), -1);
    rb_define_method(cFXGIFIcon.klass, "crop", VALUEFUNC(_wrap_FXGIFIcon_crop), -1);
    rb_define_method(cFXGIFIcon.klass, "fill", VALUEFUNC(_wrap_FXGIFIcon_fill), -1);
    rb_define_method(cFXGIFIcon.klass, "fade", VALUEFUNC(_wrap_FXGIFIcon_fade), -1);
    rb_define_method(cFXGIFIcon.klass, "xshear", VALUEFUNC(_wrap_FXGIFIcon_xshear), -1);
    rb_define_method(cFXGIFIcon.klass, "yshear", VALUEFUNC(_wrap_FXGIFIcon_yshear), -1);
    rb_define_method(cFXGIFIcon.klass, "hgradient", VALUEFUNC(_wrap_FXGIFIcon_hgradient), -1);
    rb_define_method(cFXGIFIcon.klass, "vgradient", VALUEFUNC(_wrap_FXGIFIcon_vgradient), -1);
    rb_define_method(cFXGIFIcon.klass, "gradient", VALUEFUNC(_wrap_FXGIFIcon_gradient), -1);
    rb_define_method(cFXGIFIcon.klass, "blend", VALUEFUNC(_wrap_FXGIFIcon_blend), -1);
    rb_define_method(cFXGIFIcon.klass, "savePixels", VALUEFUNC(_wrap_FXGIFIcon_savePixels), -1);
    rb_define_method(cFXGIFIcon.klass, "loadPixels", VALUEFUNC(_wrap_FXGIFIcon_loadPixels), -1);
    cFXGIFIcon.mark = (void (*)(void *)) FXRbGIFIcon::markfunc;
    cFXGIFIcon.destroy = (void (*)(void *)) FXRbObject::freefunc;
    
    cFXICOIcon.klass = rb_define_class_under(mFox, "FXICOIcon", ((swig_class *) SWIGTYPE_p_FXIcon->clientdata)->klass);
    SWIG_TypeClientData(SWIGTYPE_p_FXICOIcon, (void *) &cFXICOIcon);
    rb_define_alloc_func(cFXICOIcon.klass, _wrap_FXICOIcon_allocate);
    rb_define_method(cFXICOIcon.klass, "initialize", VALUEFUNC(_wrap_new_FXICOIcon), -1);
    rb_define_method(cFXICOIcon.klass, "save", VALUEFUNC(_wrap_FXICOIcon_save), -1);
    rb_define_method(cFXICOIcon.klass, "load", VALUEFUNC(_wrap_FXICOIcon_load), -1);
    rb_define_method(cFXICOIcon.klass, "create", VALUEFUNC(_wrap_FXICOIcon_create), -1);
    rb_define_method(cFXICOIcon.klass, "detach", VALUEFUNC(_wrap_FXICOIcon_detach), -1);
    rb_define_method(cFXICOIcon.klass, "destroy", VALUEFUNC(_wrap_FXICOIcon_destroy), -1);
    rb_define_method(cFXICOIcon.klass, "resize", VALUEFUNC(_wrap_FXICOIcon_resize), -1);
    rb_define_method(cFXICOIcon.klass, "restore", VALUEFUNC(_wrap_FXICOIcon_restore), -1);
    rb_define_method(cFXICOIcon.klass, "render", VALUEFUNC(_wrap_FXICOIcon_render), -1);
    rb_define_method(cFXICOIcon.klass, "release", VALUEFUNC(_wrap_FXICOIcon_release), -1);
    rb_define_method(cFXICOIcon.klass, "scale", VALUEFUNC(_wrap_FXICOIcon_scale), -1);
    rb_define_method(cFXICOIcon.klass, "mirror", VALUEFUNC(_wrap_FXICOIcon_mirror), -1);
    rb_define_method(cFXICOIcon.klass, "rotate", VALUEFUNC(_wrap_FXICOIcon_rotate), -1);
    rb_define_method(cFXICOIcon.klass, "crop", VALUEFUNC(_wrap_FXICOIcon_crop), -1);
    rb_define_method(cFXICOIcon.klass, "fill", VALUEFUNC(_wrap_FXICOIcon_fill), -1);
    rb_define_method(cFXICOIcon.klass, "fade", VALUEFUNC(_wrap_FXICOIcon_fade), -1);
    rb_define_method(cFXICOIcon.klass, "xshear", VALUEFUNC(_wrap_FXICOIcon_xshear), -1);
    rb_define_method(cFXICOIcon.klass, "yshear", VALUEFUNC(_wrap_FXICOIcon_yshear), -1);
    rb_define_method(cFXICOIcon.klass, "hgradient", VALUEFUNC(_wrap_FXICOIcon_hgradient), -1);
    rb_define_method(cFXICOIcon.klass, "vgradient", VALUEFUNC(_wrap_FXICOIcon_vgradient), -1);
    rb_define_method(cFXICOIcon.klass, "gradient", VALUEFUNC(_wrap_FXICOIcon_gradient), -1);
    rb_define_method(cFXICOIcon.klass, "blend", VALUEFUNC(_wrap_FXICOIcon_blend), -1);
    rb_define_method(cFXICOIcon.klass, "savePixels", VALUEFUNC(_wrap_FXICOIcon_savePixels), -1);
    rb_define_method(cFXICOIcon.klass, "loadPixels", VALUEFUNC(_wrap_FXICOIcon_loadPixels), -1);
    cFXICOIcon.mark = (void (*)(void *)) FXRbICOIcon::markfunc;
    cFXICOIcon.destroy = (void (*)(void *)) FXRbObject::freefunc;
    rb_define_module_function(mFox, "fxloadICO", VALUEFUNC(_wrap_fxloadICO), -1);
    rb_define_module_function(mFox, "fxsaveICO", VALUEFUNC(_wrap_fxsaveICO), -1);
    
    cFXJPGIcon.klass = rb_define_class_under(mFox, "FXJPGIcon", ((swig_class *) SWIGTYPE_p_FXIcon->clientdata)->klass);
    SWIG_TypeClientData(SWIGTYPE_p_FXJPGIcon, (void *) &cFXJPGIcon);
    rb_define_alloc_func(cFXJPGIcon.klass, _wrap_FXJPGIcon_allocate);
    rb_define_method(cFXJPGIcon.klass, "initialize", VALUEFUNC(_wrap_new_FXJPGIcon), -1);
    rb_define_method(cFXJPGIcon.klass, "setQuality", VALUEFUNC(_wrap_FXJPGIcon_setQuality), -1);
    rb_define_method(cFXJPGIcon.klass, "getQuality", VALUEFUNC(_wrap_FXJPGIcon_getQuality), -1);
    rb_define_method(cFXJPGIcon.klass, "save", VALUEFUNC(_wrap_FXJPGIcon_save), -1);
    rb_define_method(cFXJPGIcon.klass, "load", VALUEFUNC(_wrap_FXJPGIcon_load), -1);
    rb_define_method(cFXJPGIcon.klass, "create", VALUEFUNC(_wrap_FXJPGIcon_create), -1);
    rb_define_method(cFXJPGIcon.klass, "detach", VALUEFUNC(_wrap_FXJPGIcon_detach), -1);
    rb_define_method(cFXJPGIcon.klass, "destroy", VALUEFUNC(_wrap_FXJPGIcon_destroy), -1);
    rb_define_method(cFXJPGIcon.klass, "resize", VALUEFUNC(_wrap_FXJPGIcon_resize), -1);
    rb_define_method(cFXJPGIcon.klass, "restore", VALUEFUNC(_wrap_FXJPGIcon_restore), -1);
    rb_define_method(cFXJPGIcon.klass, "render", VALUEFUNC(_wrap_FXJPGIcon_render), -1);
    rb_define_method(cFXJPGIcon.klass, "release", VALUEFUNC(_wrap_FXJPGIcon_release), -1);
    rb_define_method(cFXJPGIcon.klass, "scale", VALUEFUNC(_wrap_FXJPGIcon_scale), -1);
    rb_define_method(cFXJPGIcon.klass, "mirror", VALUEFUNC(_wrap_FXJPGIcon_mirror), -1);
    rb_define_method(cFXJPGIcon.klass, "rotate", VALUEFUNC(_wrap_FXJPGIcon_rotate), -1);
    rb_define_method(cFXJPGIcon.klass, "crop", VALUEFUNC(_wrap_FXJPGIcon_crop), -1);
    rb_define_method(cFXJPGIcon.klass, "fill", VALUEFUNC(_wrap_FXJPGIcon_fill), -1);
    rb_define_method(cFXJPGIcon.klass, "fade", VALUEFUNC(_wrap_FXJPGIcon_fade), -1);
    rb_define_method(cFXJPGIcon.klass, "xshear", VALUEFUNC(_wrap_FXJPGIcon_xshear), -1);
    rb_define_method(cFXJPGIcon.klass, "yshear", VALUEFUNC(_wrap_FXJPGIcon_yshear), -1);
    rb_define_method(cFXJPGIcon.klass, "hgradient", VALUEFUNC(_wrap_FXJPGIcon_hgradient), -1);
    rb_define_method(cFXJPGIcon.klass, "vgradient", VALUEFUNC(_wrap_FXJPGIcon_vgradient), -1);
    rb_define_method(cFXJPGIcon.klass, "gradient", VALUEFUNC(_wrap_FXJPGIcon_gradient), -1);
    rb_define_method(cFXJPGIcon.klass, "blend", VALUEFUNC(_wrap_FXJPGIcon_blend), -1);
    rb_define_method(cFXJPGIcon.klass, "savePixels", VALUEFUNC(_wrap_FXJPGIcon_savePixels), -1);
    rb_define_method(cFXJPGIcon.klass, "loadPixels", VALUEFUNC(_wrap_FXJPGIcon_loadPixels), -1);
    cFXJPGIcon.mark = (void (*)(void *)) FXRbJPGIcon::markfunc;
    cFXJPGIcon.destroy = (void (*)(void *)) FXRbObject::freefunc;
    
    cFXPCXIcon.klass = rb_define_class_under(mFox, "FXPCXIcon", ((swig_class *) SWIGTYPE_p_FXIcon->clientdata)->klass);
    SWIG_TypeClientData(SWIGTYPE_p_FXPCXIcon, (void *) &cFXPCXIcon);
    rb_define_alloc_func(cFXPCXIcon.klass, _wrap_FXPCXIcon_allocate);
    rb_define_method(cFXPCXIcon.klass, "initialize", VALUEFUNC(_wrap_new_FXPCXIcon), -1);
    rb_define_method(cFXPCXIcon.klass, "save", VALUEFUNC(_wrap_FXPCXIcon_save), -1);
    rb_define_method(cFXPCXIcon.klass, "load", VALUEFUNC(_wrap_FXPCXIcon_load), -1);
    rb_define_method(cFXPCXIcon.klass, "create", VALUEFUNC(_wrap_FXPCXIcon_create), -1);
    rb_define_method(cFXPCXIcon.klass, "detach", VALUEFUNC(_wrap_FXPCXIcon_detach), -1);
    rb_define_method(cFXPCXIcon.klass, "destroy", VALUEFUNC(_wrap_FXPCXIcon_destroy), -1);
    rb_define_method(cFXPCXIcon.klass, "resize", VALUEFUNC(_wrap_FXPCXIcon_resize), -1);
    rb_define_method(cFXPCXIcon.klass, "restore", VALUEFUNC(_wrap_FXPCXIcon_restore), -1);
    rb_define_method(cFXPCXIcon.klass, "render", VALUEFUNC(_wrap_FXPCXIcon_render), -1);
    rb_define_method(cFXPCXIcon.klass, "release", VALUEFUNC(_wrap_FXPCXIcon_release), -1);
    rb_define_method(cFXPCXIcon.klass, "scale", VALUEFUNC(_wrap_FXPCXIcon_scale), -1);
    rb_define_method(cFXPCXIcon.klass, "mirror", VALUEFUNC(_wrap_FXPCXIcon_mirror), -1);
    rb_define_method(cFXPCXIcon.klass, "rotate", VALUEFUNC(_wrap_FXPCXIcon_rotate), -1);
    rb_define_method(cFXPCXIcon.klass, "crop", VALUEFUNC(_wrap_FXPCXIcon_crop), -1);
    rb_define_method(cFXPCXIcon.klass, "fill", VALUEFUNC(_wrap_FXPCXIcon_fill), -1);
    rb_define_method(cFXPCXIcon.klass, "fade", VALUEFUNC(_wrap_FXPCXIcon_fade), -1);
    rb_define_method(cFXPCXIcon.klass, "xshear", VALUEFUNC(_wrap_FXPCXIcon_xshear), -1);
    rb_define_method(cFXPCXIcon.klass, "yshear", VALUEFUNC(_wrap_FXPCXIcon_yshear), -1);
    rb_define_method(cFXPCXIcon.klass, "hgradient", VALUEFUNC(_wrap_FXPCXIcon_hgradient), -1);
    rb_define_method(cFXPCXIcon.klass, "vgradient", VALUEFUNC(_wrap_FXPCXIcon_vgradient), -1);
    rb_define_method(cFXPCXIcon.klass, "gradient", VALUEFUNC(_wrap_FXPCXIcon_gradient), -1);
    rb_define_method(cFXPCXIcon.klass, "blend", VALUEFUNC(_wrap_FXPCXIcon_blend), -1);
    rb_define_method(cFXPCXIcon.klass, "savePixels", VALUEFUNC(_wrap_FXPCXIcon_savePixels), -1);
    rb_define_method(cFXPCXIcon.klass, "loadPixels", VALUEFUNC(_wrap_FXPCXIcon_loadPixels), -1);
    cFXPCXIcon.mark = (void (*)(void *)) FXRbPCXIcon::markfunc;
    cFXPCXIcon.destroy = (void (*)(void *)) FXRbObject::freefunc;
    rb_define_module_function(mFox, "fxloadPCX", VALUEFUNC(_wrap_fxloadPCX), -1);
    rb_define_module_function(mFox, "fxsavePCX", VALUEFUNC(_wrap_fxsavePCX), -1);
    
    cFXPNGIcon.klass = rb_define_class_under(mFox, "FXPNGIcon", ((swig_class *) SWIGTYPE_p_FXIcon->clientdata)->klass);
    SWIG_TypeClientData(SWIGTYPE_p_FXPNGIcon, (void *) &cFXPNGIcon);
    rb_define_alloc_func(cFXPNGIcon.klass, _wrap_FXPNGIcon_allocate);
    rb_define_method(cFXPNGIcon.klass, "initialize", VALUEFUNC(_wrap_new_FXPNGIcon), -1);
    rb_define_method(cFXPNGIcon.klass, "save", VALUEFUNC(_wrap_FXPNGIcon_save), -1);
    rb_define_method(cFXPNGIcon.klass, "load", VALUEFUNC(_wrap_FXPNGIcon_load), -1);
    rb_define_method(cFXPNGIcon.klass, "create", VALUEFUNC(_wrap_FXPNGIcon_create), -1);
    rb_define_method(cFXPNGIcon.klass, "detach", VALUEFUNC(_wrap_FXPNGIcon_detach), -1);
    rb_define_method(cFXPNGIcon.klass, "destroy", VALUEFUNC(_wrap_FXPNGIcon_destroy), -1);
    rb_define_method(cFXPNGIcon.klass, "resize", VALUEFUNC(_wrap_FXPNGIcon_resize), -1);
    rb_define_method(cFXPNGIcon.klass, "restore", VALUEFUNC(_wrap_FXPNGIcon_restore), -1);
    rb_define_method(cFXPNGIcon.klass, "render", VALUEFUNC(_wrap_FXPNGIcon_render), -1);
    rb_define_method(cFXPNGIcon.klass, "release", VALUEFUNC(_wrap_FXPNGIcon_release), -1);
    rb_define_method(cFXPNGIcon.klass, "scale", VALUEFUNC(_wrap_FXPNGIcon_scale), -1);
    rb_define_method(cFXPNGIcon.klass, "mirror", VALUEFUNC(_wrap_FXPNGIcon_mirror), -1);
    rb_define_method(cFXPNGIcon.klass, "rotate", VALUEFUNC(_wrap_FXPNGIcon_rotate), -1);
    rb_define_method(cFXPNGIcon.klass, "crop", VALUEFUNC(_wrap_FXPNGIcon_crop), -1);
    rb_define_method(cFXPNGIcon.klass, "fill", VALUEFUNC(_wrap_FXPNGIcon_fill), -1);
    rb_define_method(cFXPNGIcon.klass, "fade", VALUEFUNC(_wrap_FXPNGIcon_fade), -1);
    rb_define_method(cFXPNGIcon.klass, "xshear", VALUEFUNC(_wrap_FXPNGIcon_xshear), -1);
    rb_define_method(cFXPNGIcon.klass, "yshear", VALUEFUNC(_wrap_FXPNGIcon_yshear), -1);
    rb_define_method(cFXPNGIcon.klass, "hgradient", VALUEFUNC(_wrap_FXPNGIcon_hgradient), -1);
    rb_define_method(cFXPNGIcon.klass, "vgradient", VALUEFUNC(_wrap_FXPNGIcon_vgradient), -1);
    rb_define_method(cFXPNGIcon.klass, "gradient", VALUEFUNC(_wrap_FXPNGIcon_gradient), -1);
    rb_define_method(cFXPNGIcon.klass, "blend", VALUEFUNC(_wrap_FXPNGIcon_blend), -1);
    rb_define_method(cFXPNGIcon.klass, "savePixels", VALUEFUNC(_wrap_FXPNGIcon_savePixels), -1);
    rb_define_method(cFXPNGIcon.klass, "loadPixels", VALUEFUNC(_wrap_FXPNGIcon_loadPixels), -1);
    cFXPNGIcon.mark = (void (*)(void *)) FXRbPNGIcon::markfunc;
    cFXPNGIcon.destroy = (void (*)(void *)) FXRbObject::freefunc;
    rb_define_module_function(mFox, "fxloadPNG", VALUEFUNC(_wrap_fxloadPNG), -1);
    rb_define_module_function(mFox, "fxsavePNG", VALUEFUNC(_wrap_fxsavePNG), -1);
    
    cFXPPMIcon.klass = rb_define_class_under(mFox, "FXPPMIcon", ((swig_class *) SWIGTYPE_p_FXIcon->clientdata)->klass);
    SWIG_TypeClientData(SWIGTYPE_p_FXPPMIcon, (void *) &cFXPPMIcon);
    rb_define_alloc_func(cFXPPMIcon.klass, _wrap_FXPPMIcon_allocate);
    rb_define_method(cFXPPMIcon.klass, "initialize", VALUEFUNC(_wrap_new_FXPPMIcon), -1);
    rb_define_method(cFXPPMIcon.klass, "save", VALUEFUNC(_wrap_FXPPMIcon_save), -1);
    rb_define_method(cFXPPMIcon.klass, "load", VALUEFUNC(_wrap_FXPPMIcon_load), -1);
    rb_define_method(cFXPPMIcon.klass, "create", VALUEFUNC(_wrap_FXPPMIcon_create), -1);
    rb_define_method(cFXPPMIcon.klass, "detach", VALUEFUNC(_wrap_FXPPMIcon_detach), -1);
    rb_define_method(cFXPPMIcon.klass, "destroy", VALUEFUNC(_wrap_FXPPMIcon_destroy), -1);
    rb_define_method(cFXPPMIcon.klass, "resize", VALUEFUNC(_wrap_FXPPMIcon_resize), -1);
    rb_define_method(cFXPPMIcon.klass, "restore", VALUEFUNC(_wrap_FXPPMIcon_restore), -1);
    rb_define_method(cFXPPMIcon.klass, "render", VALUEFUNC(_wrap_FXPPMIcon_render), -1);
    rb_define_method(cFXPPMIcon.klass, "release", VALUEFUNC(_wrap_FXPPMIcon_release), -1);
    rb_define_method(cFXPPMIcon.klass, "scale", VALUEFUNC(_wrap_FXPPMIcon_scale), -1);
    rb_define_method(cFXPPMIcon.klass, "mirror", VALUEFUNC(_wrap_FXPPMIcon_mirror), -1);
    rb_define_method(cFXPPMIcon.klass, "rotate", VALUEFUNC(_wrap_FXPPMIcon_rotate), -1);
    rb_define_method(cFXPPMIcon.klass, "crop", VALUEFUNC(_wrap_FXPPMIcon_crop), -1);
    rb_define_method(cFXPPMIcon.klass, "fill", VALUEFUNC(_wrap_FXPPMIcon_fill), -1);
    rb_define_method(cFXPPMIcon.klass, "fade", VALUEFUNC(_wrap_FXPPMIcon_fade), -1);
    rb_define_method(cFXPPMIcon.klass, "xshear", VALUEFUNC(_wrap_FXPPMIcon_xshear), -1);
    rb_define_method(cFXPPMIcon.klass, "yshear", VALUEFUNC(_wrap_FXPPMIcon_yshear), -1);
    rb_define_method(cFXPPMIcon.klass, "hgradient", VALUEFUNC(_wrap_FXPPMIcon_hgradient), -1);
    rb_define_method(cFXPPMIcon.klass, "vgradient", VALUEFUNC(_wrap_FXPPMIcon_vgradient), -1);
    rb_define_method(cFXPPMIcon.klass, "gradient", VALUEFUNC(_wrap_FXPPMIcon_gradient), -1);
    rb_define_method(cFXPPMIcon.klass, "blend", VALUEFUNC(_wrap_FXPPMIcon_blend), -1);
    rb_define_method(cFXPPMIcon.klass, "savePixels", VALUEFUNC(_wrap_FXPPMIcon_savePixels), -1);
    rb_define_method(cFXPPMIcon.klass, "loadPixels", VALUEFUNC(_wrap_FXPPMIcon_loadPixels), -1);
    cFXPPMIcon.mark = 0;
    cFXPPMIcon.destroy = (void (*)(void *)) FXRbObject::freefunc;
    rb_define_module_function(mFox, "fxloadPPM", VALUEFUNC(_wrap_fxloadPPM), -1);
    rb_define_module_function(mFox, "fxsavePPM", VALUEFUNC(_wrap_fxsavePPM), -1);
    
    cFXRGBIcon.klass = rb_define_class_under(mFox, "FXRGBIcon", ((swig_class *) SWIGTYPE_p_FXIcon->clientdata)->klass);
    SWIG_TypeClientData(SWIGTYPE_p_FXRGBIcon, (void *) &cFXRGBIcon);
    rb_define_alloc_func(cFXRGBIcon.klass, _wrap_FXRGBIcon_allocate);
    rb_define_method(cFXRGBIcon.klass, "initialize", VALUEFUNC(_wrap_new_FXRGBIcon), -1);
    rb_define_method(cFXRGBIcon.klass, "save", VALUEFUNC(_wrap_FXRGBIcon_save), -1);
    rb_define_method(cFXRGBIcon.klass, "load", VALUEFUNC(_wrap_FXRGBIcon_load), -1);
    rb_define_method(cFXRGBIcon.klass, "create", VALUEFUNC(_wrap_FXRGBIcon_create), -1);
    rb_define_method(cFXRGBIcon.klass, "detach", VALUEFUNC(_wrap_FXRGBIcon_detach), -1);
    rb_define_method(cFXRGBIcon.klass, "destroy", VALUEFUNC(_wrap_FXRGBIcon_destroy), -1);
    rb_define_method(cFXRGBIcon.klass, "resize", VALUEFUNC(_wrap_FXRGBIcon_resize), -1);
    rb_define_method(cFXRGBIcon.klass, "restore", VALUEFUNC(_wrap_FXRGBIcon_restore), -1);
    rb_define_method(cFXRGBIcon.klass, "render", VALUEFUNC(_wrap_FXRGBIcon_render), -1);
    rb_define_method(cFXRGBIcon.klass, "release", VALUEFUNC(_wrap_FXRGBIcon_release), -1);
    rb_define_method(cFXRGBIcon.klass, "scale", VALUEFUNC(_wrap_FXRGBIcon_scale), -1);
    rb_define_method(cFXRGBIcon.klass, "mirror", VALUEFUNC(_wrap_FXRGBIcon_mirror), -1);
    rb_define_method(cFXRGBIcon.klass, "rotate", VALUEFUNC(_wrap_FXRGBIcon_rotate), -1);
    rb_define_method(cFXRGBIcon.klass, "crop", VALUEFUNC(_wrap_FXRGBIcon_crop), -1);
    rb_define_method(cFXRGBIcon.klass, "fill", VALUEFUNC(_wrap_FXRGBIcon_fill), -1);
    rb_define_method(cFXRGBIcon.klass, "fade", VALUEFUNC(_wrap_FXRGBIcon_fade), -1);
    rb_define_method(cFXRGBIcon.klass, "xshear", VALUEFUNC(_wrap_FXRGBIcon_xshear), -1);
    rb_define_method(cFXRGBIcon.klass, "yshear", VALUEFUNC(_wrap_FXRGBIcon_yshear), -1);
    rb_define_method(cFXRGBIcon.klass, "hgradient", VALUEFUNC(_wrap_FXRGBIcon_hgradient), -1);
    rb_define_method(cFXRGBIcon.klass, "vgradient", VALUEFUNC(_wrap_FXRGBIcon_vgradient), -1);
    rb_define_method(cFXRGBIcon.klass, "gradient", VALUEFUNC(_wrap_FXRGBIcon_gradient), -1);
    rb_define_method(cFXRGBIcon.klass, "blend", VALUEFUNC(_wrap_FXRGBIcon_blend), -1);
    rb_define_method(cFXRGBIcon.klass, "savePixels", VALUEFUNC(_wrap_FXRGBIcon_savePixels), -1);
    rb_define_method(cFXRGBIcon.klass, "loadPixels", VALUEFUNC(_wrap_FXRGBIcon_loadPixels), -1);
    cFXRGBIcon.mark = (void (*)(void *)) FXRbRGBIcon::markfunc;
    cFXRGBIcon.destroy = (void (*)(void *)) FXRbObject::freefunc;
    
    cFXTGAIcon.klass = rb_define_class_under(mFox, "FXTGAIcon", ((swig_class *) SWIGTYPE_p_FXIcon->clientdata)->klass);
    SWIG_TypeClientData(SWIGTYPE_p_FXTGAIcon, (void *) &cFXTGAIcon);
    rb_define_alloc_func(cFXTGAIcon.klass, _wrap_FXTGAIcon_allocate);
    rb_define_method(cFXTGAIcon.klass, "initialize", VALUEFUNC(_wrap_new_FXTGAIcon), -1);
    rb_define_method(cFXTGAIcon.klass, "save", VALUEFUNC(_wrap_FXTGAIcon_save), -1);
    rb_define_method(cFXTGAIcon.klass, "load", VALUEFUNC(_wrap_FXTGAIcon_load), -1);
    rb_define_method(cFXTGAIcon.klass, "create", VALUEFUNC(_wrap_FXTGAIcon_create), -1);
    rb_define_method(cFXTGAIcon.klass, "detach", VALUEFUNC(_wrap_FXTGAIcon_detach), -1);
    rb_define_method(cFXTGAIcon.klass, "destroy", VALUEFUNC(_wrap_FXTGAIcon_destroy), -1);
    rb_define_method(cFXTGAIcon.klass, "resize", VALUEFUNC(_wrap_FXTGAIcon_resize), -1);
    rb_define_method(cFXTGAIcon.klass, "restore", VALUEFUNC(_wrap_FXTGAIcon_restore), -1);
    rb_define_method(cFXTGAIcon.klass, "render", VALUEFUNC(_wrap_FXTGAIcon_render), -1);
    rb_define_method(cFXTGAIcon.klass, "release", VALUEFUNC(_wrap_FXTGAIcon_release), -1);
    rb_define_method(cFXTGAIcon.klass, "scale", VALUEFUNC(_wrap_FXTGAIcon_scale), -1);
    rb_define_method(cFXTGAIcon.klass, "mirror", VALUEFUNC(_wrap_FXTGAIcon_mirror), -1);
    rb_define_method(cFXTGAIcon.klass, "rotate", VALUEFUNC(_wrap_FXTGAIcon_rotate), -1);
    rb_define_method(cFXTGAIcon.klass, "crop", VALUEFUNC(_wrap_FXTGAIcon_crop), -1);
    rb_define_method(cFXTGAIcon.klass, "fill", VALUEFUNC(_wrap_FXTGAIcon_fill), -1);
    rb_define_method(cFXTGAIcon.klass, "fade", VALUEFUNC(_wrap_FXTGAIcon_fade), -1);
    rb_define_method(cFXTGAIcon.klass, "xshear", VALUEFUNC(_wrap_FXTGAIcon_xshear), -1);
    rb_define_method(cFXTGAIcon.klass, "yshear", VALUEFUNC(_wrap_FXTGAIcon_yshear), -1);
    rb_define_method(cFXTGAIcon.klass, "hgradient", VALUEFUNC(_wrap_FXTGAIcon_hgradient), -1);
    rb_define_method(cFXTGAIcon.klass, "vgradient", VALUEFUNC(_wrap_FXTGAIcon_vgradient), -1);
    rb_define_method(cFXTGAIcon.klass, "gradient", VALUEFUNC(_wrap_FXTGAIcon_gradient), -1);
    rb_define_method(cFXTGAIcon.klass, "blend", VALUEFUNC(_wrap_FXTGAIcon_blend), -1);
    rb_define_method(cFXTGAIcon.klass, "savePixels", VALUEFUNC(_wrap_FXTGAIcon_savePixels), -1);
    rb_define_method(cFXTGAIcon.klass, "loadPixels", VALUEFUNC(_wrap_FXTGAIcon_loadPixels), -1);
    cFXTGAIcon.mark = (void (*)(void *)) FXRbTGAIcon::markfunc;
    cFXTGAIcon.destroy = (void (*)(void *)) FXRbObject::freefunc;
    
    cFXTIFIcon.klass = rb_define_class_under(mFox, "FXTIFIcon", ((swig_class *) SWIGTYPE_p_FXIcon->clientdata)->klass);
    SWIG_TypeClientData(SWIGTYPE_p_FXTIFIcon, (void *) &cFXTIFIcon);
    rb_define_alloc_func(cFXTIFIcon.klass, _wrap_FXTIFIcon_allocate);
    rb_define_method(cFXTIFIcon.klass, "initialize", VALUEFUNC(_wrap_new_FXTIFIcon), -1);
    rb_define_method(cFXTIFIcon.klass, "setCodec", VALUEFUNC(_wrap_FXTIFIcon_setCodec), -1);
    rb_define_method(cFXTIFIcon.klass, "getCodec", VALUEFUNC(_wrap_FXTIFIcon_getCodec), -1);
    rb_define_method(cFXTIFIcon.klass, "save", VALUEFUNC(_wrap_FXTIFIcon_save), -1);
    rb_define_method(cFXTIFIcon.klass, "load", VALUEFUNC(_wrap_FXTIFIcon_load), -1);
    rb_define_method(cFXTIFIcon.klass, "create", VALUEFUNC(_wrap_FXTIFIcon_create), -1);
    rb_define_method(cFXTIFIcon.klass, "detach", VALUEFUNC(_wrap_FXTIFIcon_detach), -1);
    rb_define_method(cFXTIFIcon.klass, "destroy", VALUEFUNC(_wrap_FXTIFIcon_destroy), -1);
    rb_define_method(cFXTIFIcon.klass, "resize", VALUEFUNC(_wrap_FXTIFIcon_resize), -1);
    rb_define_method(cFXTIFIcon.klass, "restore", VALUEFUNC(_wrap_FXTIFIcon_restore), -1);
    rb_define_method(cFXTIFIcon.klass, "render", VALUEFUNC(_wrap_FXTIFIcon_render), -1);
    rb_define_method(cFXTIFIcon.klass, "release", VALUEFUNC(_wrap_FXTIFIcon_release), -1);
    rb_define_method(cFXTIFIcon.klass, "scale", VALUEFUNC(_wrap_FXTIFIcon_scale), -1);
    rb_define_method(cFXTIFIcon.klass, "mirror", VALUEFUNC(_wrap_FXTIFIcon_mirror), -1);
    rb_define_method(cFXTIFIcon.klass, "rotate", VALUEFUNC(_wrap_FXTIFIcon_rotate), -1);
    rb_define_method(cFXTIFIcon.klass, "crop", VALUEFUNC(_wrap_FXTIFIcon_crop), -1);
    rb_define_method(cFXTIFIcon.klass, "fill", VALUEFUNC(_wrap_FXTIFIcon_fill), -1);
    rb_define_method(cFXTIFIcon.klass, "fade", VALUEFUNC(_wrap_FXTIFIcon_fade), -1);
    rb_define_method(cFXTIFIcon.klass, "xshear", VALUEFUNC(_wrap_FXTIFIcon_xshear), -1);
    rb_define_method(cFXTIFIcon.klass, "yshear", VALUEFUNC(_wrap_FXTIFIcon_yshear), -1);
    rb_define_method(cFXTIFIcon.klass, "hgradient", VALUEFUNC(_wrap_FXTIFIcon_hgradient), -1);
    rb_define_method(cFXTIFIcon.klass, "vgradient", VALUEFUNC(_wrap_FXTIFIcon_vgradient), -1);
    rb_define_method(cFXTIFIcon.klass, "gradient", VALUEFUNC(_wrap_FXTIFIcon_gradient), -1);
    rb_define_method(cFXTIFIcon.klass, "blend", VALUEFUNC(_wrap_FXTIFIcon_blend), -1);
    rb_define_method(cFXTIFIcon.klass, "savePixels", VALUEFUNC(_wrap_FXTIFIcon_savePixels), -1);
    rb_define_method(cFXTIFIcon.klass, "loadPixels", VALUEFUNC(_wrap_FXTIFIcon_loadPixels), -1);
    cFXTIFIcon.mark = (void (*)(void *)) FXRbTIFIcon::markfunc;
    cFXTIFIcon.destroy = (void (*)(void *)) FXRbObject::freefunc;
    
    cFXXBMIcon.klass = rb_define_class_under(mFox, "FXXBMIcon", ((swig_class *) SWIGTYPE_p_FXIcon->clientdata)->klass);
    SWIG_TypeClientData(SWIGTYPE_p_FXXBMIcon, (void *) &cFXXBMIcon);
    rb_define_alloc_func(cFXXBMIcon.klass, _wrap_FXXBMIcon_allocate);
    rb_define_method(cFXXBMIcon.klass, "initialize", VALUEFUNC(_wrap_new_FXXBMIcon), -1);
    rb_define_method(cFXXBMIcon.klass, "save", VALUEFUNC(_wrap_FXXBMIcon_save), -1);
    rb_define_method(cFXXBMIcon.klass, "load", VALUEFUNC(_wrap_FXXBMIcon_load), -1);
    rb_define_method(cFXXBMIcon.klass, "create", VALUEFUNC(_wrap_FXXBMIcon_create), -1);
    rb_define_method(cFXXBMIcon.klass, "detach", VALUEFUNC(_wrap_FXXBMIcon_detach), -1);
    rb_define_method(cFXXBMIcon.klass, "destroy", VALUEFUNC(_wrap_FXXBMIcon_destroy), -1);
    rb_define_method(cFXXBMIcon.klass, "resize", VALUEFUNC(_wrap_FXXBMIcon_resize), -1);
    rb_define_method(cFXXBMIcon.klass, "restore", VALUEFUNC(_wrap_FXXBMIcon_restore), -1);
    rb_define_method(cFXXBMIcon.klass, "render", VALUEFUNC(_wrap_FXXBMIcon_render), -1);
    rb_define_method(cFXXBMIcon.klass, "release", VALUEFUNC(_wrap_FXXBMIcon_release), -1);
    rb_define_method(cFXXBMIcon.klass, "scale", VALUEFUNC(_wrap_FXXBMIcon_scale), -1);
    rb_define_method(cFXXBMIcon.klass, "mirror", VALUEFUNC(_wrap_FXXBMIcon_mirror), -1);
    rb_define_method(cFXXBMIcon.klass, "rotate", VALUEFUNC(_wrap_FXXBMIcon_rotate), -1);
    rb_define_method(cFXXBMIcon.klass, "crop", VALUEFUNC(_wrap_FXXBMIcon_crop), -1);
    rb_define_method(cFXXBMIcon.klass, "fill", VALUEFUNC(_wrap_FXXBMIcon_fill), -1);
    rb_define_method(cFXXBMIcon.klass, "fade", VALUEFUNC(_wrap_FXXBMIcon_fade), -1);
    rb_define_method(cFXXBMIcon.klass, "xshear", VALUEFUNC(_wrap_FXXBMIcon_xshear), -1);
    rb_define_method(cFXXBMIcon.klass, "yshear", VALUEFUNC(_wrap_FXXBMIcon_yshear), -1);
    rb_define_method(cFXXBMIcon.klass, "hgradient", VALUEFUNC(_wrap_FXXBMIcon_hgradient), -1);
    rb_define_method(cFXXBMIcon.klass, "vgradient", VALUEFUNC(_wrap_FXXBMIcon_vgradient), -1);
    rb_define_method(cFXXBMIcon.klass, "gradient", VALUEFUNC(_wrap_FXXBMIcon_gradient), -1);
    rb_define_method(cFXXBMIcon.klass, "blend", VALUEFUNC(_wrap_FXXBMIcon_blend), -1);
    rb_define_method(cFXXBMIcon.klass, "savePixels", VALUEFUNC(_wrap_FXXBMIcon_savePixels), -1);
    rb_define_method(cFXXBMIcon.klass, "loadPixels", VALUEFUNC(_wrap_FXXBMIcon_loadPixels), -1);
    cFXXBMIcon.mark = 0;
    cFXXBMIcon.destroy = (void (*)(void *)) FXRbObject::freefunc;
    
    cFXXPMIcon.klass = rb_define_class_under(mFox, "FXXPMIcon", ((swig_class *) SWIGTYPE_p_FXIcon->clientdata)->klass);
    SWIG_TypeClientData(SWIGTYPE_p_FXXPMIcon, (void *) &cFXXPMIcon);
    rb_define_alloc_func(cFXXPMIcon.klass, _wrap_FXXPMIcon_allocate);
    rb_define_method(cFXXPMIcon.klass, "initialize", VALUEFUNC(_wrap_new_FXXPMIcon), -1);
    rb_define_method(cFXXPMIcon.klass, "save", VALUEFUNC(_wrap_FXXPMIcon_save), -1);
    rb_define_method(cFXXPMIcon.klass, "load", VALUEFUNC(_wrap_FXXPMIcon_load), -1);
    rb_define_method(cFXXPMIcon.klass, "create", VALUEFUNC(_wrap_FXXPMIcon_create), -1);
    rb_define_method(cFXXPMIcon.klass, "detach", VALUEFUNC(_wrap_FXXPMIcon_detach), -1);
    rb_define_method(cFXXPMIcon.klass, "destroy", VALUEFUNC(_wrap_FXXPMIcon_destroy), -1);
    rb_define_method(cFXXPMIcon.klass, "resize", VALUEFUNC(_wrap_FXXPMIcon_resize), -1);
    rb_define_method(cFXXPMIcon.klass, "restore", VALUEFUNC(_wrap_FXXPMIcon_restore), -1);
    rb_define_method(cFXXPMIcon.klass, "render", VALUEFUNC(_wrap_FXXPMIcon_render), -1);
    rb_define_method(cFXXPMIcon.klass, "release", VALUEFUNC(_wrap_FXXPMIcon_release), -1);
    rb_define_method(cFXXPMIcon.klass, "scale", VALUEFUNC(_wrap_FXXPMIcon_scale), -1);
    rb_define_method(cFXXPMIcon.klass, "mirror", VALUEFUNC(_wrap_FXXPMIcon_mirror), -1);
    rb_define_method(cFXXPMIcon.klass, "rotate", VALUEFUNC(_wrap_FXXPMIcon_rotate), -1);
    rb_define_method(cFXXPMIcon.klass, "crop", VALUEFUNC(_wrap_FXXPMIcon_crop), -1);
    rb_define_method(cFXXPMIcon.klass, "fill", VALUEFUNC(_wrap_FXXPMIcon_fill), -1);
    rb_define_method(cFXXPMIcon.klass, "fade", VALUEFUNC(_wrap_FXXPMIcon_fade), -1);
    rb_define_method(cFXXPMIcon.klass, "xshear", VALUEFUNC(_wrap_FXXPMIcon_xshear), -1);
    rb_define_method(cFXXPMIcon.klass, "yshear", VALUEFUNC(_wrap_FXXPMIcon_yshear), -1);
    rb_define_method(cFXXPMIcon.klass, "hgradient", VALUEFUNC(_wrap_FXXPMIcon_hgradient), -1);
    rb_define_method(cFXXPMIcon.klass, "vgradient", VALUEFUNC(_wrap_FXXPMIcon_vgradient), -1);
    rb_define_method(cFXXPMIcon.klass, "gradient", VALUEFUNC(_wrap_FXXPMIcon_gradient), -1);
    rb_define_method(cFXXPMIcon.klass, "blend", VALUEFUNC(_wrap_FXXPMIcon_blend), -1);
    rb_define_method(cFXXPMIcon.klass, "savePixels", VALUEFUNC(_wrap_FXXPMIcon_savePixels), -1);
    rb_define_method(cFXXPMIcon.klass, "loadPixels", VALUEFUNC(_wrap_FXXPMIcon_loadPixels), -1);
    cFXXPMIcon.mark = (void (*)(void *)) FXRbXPMIcon::markfunc;
    cFXXPMIcon.destroy = (void (*)(void *)) FXRbObject::freefunc;
    rb_define_module_function(mFox, "fxloadXPM", VALUEFUNC(_wrap_fxloadXPM), -1);
    rb_define_module_function(mFox, "fxsaveXPM", VALUEFUNC(_wrap_fxsaveXPM), -1);
}

