public:
  // Overrides the base class version of render()
  virtual void render();
  
  // Overrides the base class version of release()
  virtual void release();

  // Overrides the base class version of savePixels()
  virtual FXbool savePixels(FXStream& store) const;

  // Overrides the base class version of loadPixels()
  virtual FXbool loadPixels(FXStream& store);

  /// Rescale pixels to the specified width and height
  virtual void scale(FXint w,FXint h);

  /// Mirror bitmap horizontally and/or vertically
  virtual void mirror(FXbool horizontal,FXbool vertical);

  /// Rotate bitmap by degrees ccw
  virtual void rotate(FXint degrees);

  /// Crop bitmap to given rectangle
  virtual void crop(FXint x,FXint y,FXint w,FXint h);

  /// Fill bitmap with uniform value
  virtual void fill(FXbool color);
