/***********************************************************************
 * FXRuby -- the Ruby language bindings for the FOX GUI toolkit.
 * Copyright (c) 2001-2003 by J. Lyle Johnson. All Rights Reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * For further information please contact the author by e-mail
 * at "lyle@users.sourceforge.net".
 ***********************************************************************/

/***********************************************************************
 * $Id: FXRbFont.h,v 1.1 2004/08/07 10:55:26 lyle Exp $
 ***********************************************************************/

#ifndef FXRBFONT_H
#define FXRBFONT_H

class FXRbFont : public FXFont {
  FXDECLARE(FXRbFont)
protected:
  FXRbFont(){}
#include "FXRbObjectVirtuals.h"
#include "FXRbIdVirtuals.h"
public:
  // Is this font owned by the FXApp?
  FXbool ownedByApp;

public:
  /// Construct font from font description
  FXRbFont(FXApp* a,const FXFontDesc& fontdesc) : FXFont(a,fontdesc),ownedByApp(FALSE){
    FXRbRegisterAppSensitiveObject(this);
    }

  /// Construct a font with given face name, size in points(pixels), weight, slant, character set encoding, setwidth, and hints
  FXRbFont(FXApp* a,const FXString& face,FXuint sz,FXuint wt=FONTWEIGHT_NORMAL,FXuint sl=FONTSLANT_REGULAR,FXuint enc=FONTENCODING_DEFAULT,FXuint setw=FONTSETWIDTH_DONTCARE,FXuint h=0) : FXFont(a,face,sz,wt,sl,enc,setw,h),ownedByApp(FALSE){
    FXRbRegisterAppSensitiveObject(this);
    }

  /// Construct a font with given X11 font string
  FXRbFont(FXApp* a,const FXString& nm) : FXFont(a,nm),ownedByApp(FALSE){
    FXRbRegisterAppSensitiveObject(this);
    }

  // Mark dependencies for the GC
  static void markfunc(FXFont* self);

  // Destroy this object if it's not owned
  static void freefunc(FXFont* self);

  // Destructor
  virtual ~FXRbFont(){
    FXTRACE((100,"FXRbFont::~FXRbFont() 0x%08x\n",this));
    FXRbUnregisterRubyObj(this);
    FXRbUnregisterAppSensitiveObject(this);
    }
  };

#endif
