/***********************************************************************
 * FXRuby -- the Ruby language bindings for the FOX GUI toolkit.
 * Copyright (c) 2001-2003 by J. Lyle Johnson. All Rights Reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * For further information please contact the author by e-mail
 * at "lyle@users.sourceforge.net".
 ***********************************************************************/

/***********************************************************************
 * $Id: FXRbText.h,v 1.2 2005/02/27 21:05:22 lyle Exp $
 ***********************************************************************/

#ifndef FXRBTEXT_H
#define FXRBTEXT_H

#define DECLARE_FXTEXT_STUBS(klass) \
inline void klass ## _setCursorPos(klass* self,FXint pos,FXbool notify){ \
  self->klass::setCursorPos(pos,notify); \
  } \
inline FXbool klass ## _extendSelection(klass* self,FXint pos,FXTextSelectionMode mode=SELECT_CHARS,FXbool notify=FALSE){ \
  return self->klass::extendSelection(pos,mode,notify); \
  } \
inline FXbool klass ## _killSelection(klass* self,FXbool notify=FALSE){ \
  return self->klass::killSelection(notify); \
  }


#define IMPLEMENT_FXTEXT_STUBS(cls) \
  void cls::setCursorPos(FXint pos,FXbool notify){ \
    FXRbCallVoidMethod(this,rb_intern("setCursorPos"),pos,notify); \
    } \
  FXbool cls::extendSelection(FXint pos,FXTextSelectionMode mode,FXbool notify){ \
    return FXRbCallBoolMethod(this,rb_intern("extendSelection"),pos,mode,notify); \
    } \
  FXbool cls::killSelection(FXbool notify){ \
    return FXRbCallBoolMethod(this,rb_intern("killSelection"),notify); \
    }


class FXRbText : public FXText {
  FXDECLARE(FXRbText)
protected:
  FXRbText(){}
#include "FXRbObjectVirtuals.h"
#include "FXRbIdVirtuals.h"
#include "FXRbDrawableVirtuals.h"
#include "FXRbWindowVirtuals.h"
#include "FXRbScrollAreaVirtuals.h"
#include "FXRbTextVirtuals.h"
public:
  /// Construct multi-line text widget
  FXRbText(FXComposite *p,FXObject* tgt=NULL,FXSelector sel=0,FXuint opts=0,FXint x=0,FXint y=0,FXint w=0,FXint h=0) : FXText(p,tgt,sel,opts,x,y,w,h){
    numStyles=0;
    styles=0;
    }
  
  // Number of styles in style array
  FXint numStyles;

  // Style array
  FXHiliteStyle *styles;
  

  // Mark dependencies for the GC
  static void markfunc(FXText* self);

  // Unregister objects that this text owns and is about to destroy
  static void unregisterOwnedObjects(FXText *pText);

  // Destructor
  virtual ~FXRbText(){
    numStyles=0;
    delete [] styles;
    styles=(FXHiliteStyle*)-1;
    FXRbText::unregisterOwnedObjects(this);
    FXRbUnregisterRubyObj(this);
    }
  };

#endif
