/***********************************************************************
 * FXRuby -- the Ruby language bindings for the FOX GUI toolkit.
 * Copyright (c) 2001-2003 by J. Lyle Johnson. All Rights Reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * For further information please contact the author by e-mail
 * at "lyle@users.sourceforge.net".
 ***********************************************************************/

/***********************************************************************
 * $Id: FXRbWindow.h,v 1.1 2004/08/07 10:55:26 lyle Exp $
 ***********************************************************************/

#ifndef FXRBWINDOW_H
#define FXRBWINDOW_H

#define DECLARE_FXWINDOW_STUBS(klass) \
inline void klass ## _layout(klass* self){ \
  self->klass::layout(); \
  } \
inline FXint klass ## _getDefaultWidth(klass* self){ \
  return self->klass::getDefaultWidth(); \
  } \
inline FXint klass ## _getDefaultHeight(klass* self){ \
  return self->klass::getDefaultHeight(); \
  } \
inline FXint klass ## _getWidthForHeight(klass* self,FXint givenheight){ \
  return self->klass::getWidthForHeight(givenheight); \
  } \
inline FXint klass ## _getHeightForWidth(klass* self,FXint givenwidth){ \
  return self->klass::getHeightForWidth(givenwidth); \
  } \
inline FXbool klass ## _canFocus(const klass* self){ \
  return self->klass::canFocus(); \
  } \
inline void klass ## _setFocus(klass* self){ \
  self->klass::setFocus(); \
  } \
inline void klass ## _killFocus(klass* self){ \
  self->klass::killFocus(); \
  } \
inline void klass ## _setDefault(klass* self,FXbool enable){ \
  self->klass::setDefault(enable); \
  } \
inline void klass ## _enable(klass* self){ \
  self->klass::enable(); \
  } \
inline void klass ## _disable(klass* self){ \
  self->klass::disable(); \
  } \
inline void klass ## _raise(klass* self){ \
  self->klass::raise(); \
  } \
inline void klass ## _lower(klass* self){ \
  self->klass::lower(); \
  } \
inline void klass ## _move(klass* self,FXint x,FXint y){ \
  self->klass::move(x,y); \
  } \
inline void klass ## _position(klass* self,FXint x,FXint y,FXint w,FXint h){ \
  self->klass::position(x,y,w,h); \
  } \
inline void klass ## _recalc(klass* self){ \
  self->klass::recalc(); \
  } \
inline void klass ## _reparent(klass* self,FXComposite* newparent){ \
  self->klass::reparent(newparent); \
  } \
inline void klass ## _show(klass* self){ \
  self->klass::show(); \
  } \
inline void klass ## _hide(klass* self){ \
  self->klass::hide(); \
  } \
inline FXbool klass ## _isComposite(const klass* self) { \
  return self->klass::isComposite(); \
  } \
inline FXbool klass ## _contains(const klass* self,FXint parentx,FXint parenty) { \
  return self->klass::contains(parentx,parenty); \
  } \
inline FXbool klass ## _doesSaveUnder(const klass* self) { \
  return self->klass::doesSaveUnder(); \
  } \
inline void klass ## _setBackColor(klass* self,FXColor clr){ \
  self->klass::setBackColor(clr); \
  }


#define IMPLEMENT_FXWINDOW_STUBS(cls) \
  void cls::layout(){ \
    FXRbCallVoidMethod(this,rb_intern("layout")); \
    } \
  FXint cls::getDefaultWidth(){ \
    return FXRbCallIntMethod(this,rb_intern("getDefaultWidth")); \
    } \
  FXint cls::getDefaultHeight(){ \
    return FXRbCallIntMethod(this,rb_intern("getDefaultHeight")); \
    } \
  FXint cls::getWidthForHeight(FXint givenheight){ \
    return FXRbCallIntMethod(this,rb_intern("getWidthForHeight"),givenheight); \
    } \
  FXint cls::getHeightForWidth(FXint givenwidth){ \
    return FXRbCallIntMethod(this,rb_intern("getHeightForWidth"),givenwidth); \
    } \
  FXbool cls::canFocus() const { \
    return FXRbCallBoolMethod(this,rb_intern("canFocus")); \
    } \
  void cls::setFocus(){ \
    FXRbCallVoidMethod(this,rb_intern("setFocus")); \
    } \
  void cls::killFocus(){ \
    FXRbCallVoidMethod(this,rb_intern("killFocus")); \
    } \
  void cls::setDefault(FXbool enable){ \
    FXRbCallVoidMethod(this,rb_intern("setDefault"),enable); \
    } \
  void cls::enable(){ \
    FXRbCallVoidMethod(this,rb_intern("enable")); \
    } \
  void cls::disable(){ \
    FXRbCallVoidMethod(this,rb_intern("disable")); \
    } \
  void cls::raise(){ \
    FXRbCallVoidMethod(this,rb_intern("raiseWindow")); \
    } \
  void cls::lower(){ \
    FXRbCallVoidMethod(this,rb_intern("lower")); \
    } \
  void cls::move(FXint x,FXint y){ \
    FXRbCallVoidMethod(this,rb_intern("move"),x,y); \
    } \
  void cls::position(FXint x,FXint y,FXint w,FXint h){ \
    FXRbCallVoidMethod(this,rb_intern("position"),x,y,w,h); \
    } \
  void cls::recalc(){ \
    FXRbCallVoidMethod(this,rb_intern("recalc")); \
    } \
  void cls::reparent(FXComposite* newparent){ \
    FXRbCallVoidMethod(this,rb_intern("reparent"),newparent); \
    } \
  void cls::show(){ \
    FXRbCallVoidMethod(this,rb_intern("show")); \
    } \
  void cls::hide(){ \
    FXRbCallVoidMethod(this,rb_intern("hide")); \
    } \
  FXbool cls::isComposite() const { \
    return FXRbCallBoolMethod(this,rb_intern("isComposite")); \
    } \
  FXbool cls::contains(FXint parentx,FXint parenty) const{ \
    return FXRbCallBoolMethod(this,rb_intern("contains"),parentx,parenty); \
    } \
  FXbool cls::doesSaveUnder() const { \
    return FXRbCallBoolMethod(this,rb_intern("doesSaveUnder")); \
    } \
  void cls::setBackColor(FXColor clr) { \
    FXRbCallVoidMethod(this,rb_intern("setBackColor"),clr); \
    }

class FXRbWindow : public FXWindow {
  FXDECLARE(FXRbWindow)
#include "FXRbObjectVirtuals.h"
#include "FXRbIdVirtuals.h"
#include "FXRbDrawableVirtuals.h"
#include "FXRbWindowVirtuals.h"
protected:
  FXRbWindow(){}
public:
  // Constructor
  FXRbWindow(FXComposite* p,FXuint opts=0,FXint x=0,FXint y=0,FXint w=0,FXint h=0) : FXWindow(p,opts,x,y,w,h){}

  // Another constructor
  FXRbWindow(FXApp* a,FXVisual *vis):FXWindow(a,vis){}
  
  // Yet another constructor
  FXRbWindow(FXApp* a,FXWindow* own,FXuint opts,FXint x,FXint y,FXint w,FXint h):FXWindow(a,own,opts,x,y,w,h){}

  // Mark dependencies for the GC
  static void markfunc(FXWindow* win);

  // Destructor
  virtual ~FXRbWindow(){
    FXRbUnregisterRubyObj(this);
    }
  };

#endif
