/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 1.3.22
 * 
 * This file is not intended to be easily readable and contains a number of 
 * coding conventions designed to improve portability and efficiency. Do not make
 * changes to this file unless you know what you are doing--modify the SWIG 
 * interface file instead. 
 * ----------------------------------------------------------------------------- */

#define SWIG_NOINCLUDE

#ifdef __cplusplus
template<class T> class SwigValueWrapper {
    T *tt;
public:
    SwigValueWrapper() : tt(0) { }
    SwigValueWrapper(const SwigValueWrapper<T>& rhs) : tt(new T(*rhs.tt)) { }
    SwigValueWrapper(const T& t) : tt(new T(t)) { }
    ~SwigValueWrapper() { delete tt; } 
    SwigValueWrapper& operator=(const T& t) { delete tt; tt = new T(t); return *this; }
    operator T&() const { return *tt; }
    T *operator&() { return tt; }
private:
    SwigValueWrapper& operator=(const SwigValueWrapper<T>& rhs);
};                                                    
#endif

/* ruby.swg */
/* Implementation : RUBY */
#define SWIGRUBY 1

#include "ruby.h"

/* Flags for pointer conversion */
#define SWIG_POINTER_EXCEPTION     0x1
#define SWIG_POINTER_DISOWN        0x2

#define NUM2USHRT(n) (\
    (0 <= NUM2UINT(n) && NUM2UINT(n) <= USHRT_MAX)\
    ? (unsigned short) NUM2UINT(n) \
    : (rb_raise(rb_eArgError, "integer %d out of range of `unsigned short'",\
               NUM2UINT(n)), (short)0)\
)

#define NUM2SHRT(n) (\
    (SHRT_MIN <= NUM2INT(n) && NUM2INT(n) <= SHRT_MAX)\
    ? (short)NUM2INT(n)\
    : (rb_raise(rb_eArgError, "integer %d out of range of `short'",\
               NUM2INT(n)), (short)0)\
)

/* Ruby 1.7 defines NUM2LL(), LL2NUM() and ULL2NUM() macros */
#ifndef NUM2LL
#define NUM2LL(x) NUM2LONG((x))
#endif
#ifndef LL2NUM
#define LL2NUM(x) INT2NUM((long) (x))
#endif
#ifndef ULL2NUM
#define ULL2NUM(x) UINT2NUM((unsigned long) (x))
#endif

/* Ruby 1.7 doesn't (yet) define NUM2ULL() */
#ifndef NUM2ULL
#ifdef HAVE_LONG_LONG
#define NUM2ULL(x) rb_num2ull((x))
#else
#define NUM2ULL(x) NUM2ULONG(x)
#endif
#endif

/*
 * Need to be very careful about how these macros are defined, especially
 * when compiling C++ code or C code with an ANSI C compiler.
 *
 * VALUEFUNC(f) is a macro used to typecast a C function that implements
 * a Ruby method so that it can be passed as an argument to API functions
 * like rb_define_method() and rb_define_singleton_method().
 *
 * VOIDFUNC(f) is a macro used to typecast a C function that implements
 * either the "mark" or "free" stuff for a Ruby Data object, so that it
 * can be passed as an argument to API functions like Data_Wrap_Struct()
 * and Data_Make_Struct().
 */
 
#ifdef __cplusplus
#  ifndef RUBY_METHOD_FUNC /* These definitions should work for Ruby 1.4.6 */
#    define PROTECTFUNC(f) ((VALUE (*)()) f)
#    define VALUEFUNC(f) ((VALUE (*)()) f)
#    define VOIDFUNC(f)  ((void (*)()) f)
#  else
#    ifndef ANYARGS /* These definitions should work for Ruby 1.6 */
#      define PROTECTFUNC(f) ((VALUE (*)()) f)
#      define VALUEFUNC(f) ((VALUE (*)()) f)
#      define VOIDFUNC(f)  ((RUBY_DATA_FUNC) f)
#    else /* These definitions should work for Ruby 1.7+ */
#      define PROTECTFUNC(f) ((VALUE (*)(VALUE)) f)
#      define VALUEFUNC(f) ((VALUE (*)(ANYARGS)) f)
#      define VOIDFUNC(f)  ((RUBY_DATA_FUNC) f)
#    endif
#  endif
#else
#  define VALUEFUNC(f) (f)
#  define VOIDFUNC(f) (f)
#endif

typedef struct {
  VALUE klass;
  VALUE mImpl;
  void  (*mark)(void *);
  void  (*destroy)(void *);
} swig_class;

/* Don't use for expressions have side effect */
#ifndef RB_STRING_VALUE
#define RB_STRING_VALUE(s) (TYPE(s) == T_STRING ? (s) : (*(volatile VALUE *)&(s) = rb_str_to_str(s)))
#endif
#ifndef StringValue
#define StringValue(s) RB_STRING_VALUE(s)
#endif
#ifndef StringValuePtr
#define StringValuePtr(s) RSTRING(RB_STRING_VALUE(s))->ptr
#endif
#ifndef StringValueLen
#define StringValueLen(s) RSTRING(RB_STRING_VALUE(s))->len
#endif
#ifndef SafeStringValue
#define SafeStringValue(v) do {\
    StringValue(v);\
    rb_check_safe_str(v);\
} while (0)
#endif

#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
#define rb_define_alloc_func(klass, func) rb_define_singleton_method((klass), "new", VALUEFUNC((func)), -1)
#define rb_undef_alloc_func(klass) rb_undef_method(CLASS_OF((klass)), "new")
#endif

/* Contract support */

#define SWIG_contract_assert(expr, msg) if (!(expr)) { rb_raise(rb_eRuntimeError, (char *) msg ); } else


/*************************************************************** -*- c -*-
 * ruby/precommon.swg
 *
 * Rename all exported symbols from common.swg, to avoid symbol
 * clashes if multiple interpreters are included
 *
 ************************************************************************/

#define SWIG_TypeRegister    SWIG_Ruby_TypeRegister
#define SWIG_TypeCheck       SWIG_Ruby_TypeCheck
#define SWIG_TypeCast        SWIG_Ruby_TypeCast
#define SWIG_TypeDynamicCast SWIG_Ruby_TypeDynamicCast
#define SWIG_TypeName        SWIG_Ruby_TypeName
#define SWIG_TypePrettyName  SWIG_Ruby_TypePrettyName
#define SWIG_TypeQuery       SWIG_Ruby_TypeQuery
#define SWIG_TypeClientData  SWIG_Ruby_TypeClientData
#define SWIG_PackData        SWIG_Ruby_PackData 
#define SWIG_UnpackData      SWIG_Ruby_UnpackData 

/* Also rename all exported symbols from rubydef.swig */

/* Common SWIG API */
#define SWIG_ConvertPtr(obj, pp, type, flags) \
  SWIG_Ruby_ConvertPtr(obj, pp, type, flags)
#define SWIG_NewPointerObj(p, type, flags) \
  SWIG_Ruby_NewPointerObj(p, type, flags)
#define SWIG_MustGetPtr(p, type, argnum, flags) \
  SWIG_Ruby_MustGetPtr(p, type, argnum, flags)

/* Ruby-specific SWIG API */

#define SWIG_InitRuntime() \
  SWIG_Ruby_InitRuntime()
#define SWIG_define_class(ty) \
  SWIG_Ruby_define_class(ty)
#define SWIG_NewClassInstance(value, ty) \
  SWIG_Ruby_NewClassInstance(value, ty)
#define SWIG_MangleStr(value) \
  SWIG_Ruby_MangleStr(value)
#define SWIG_CheckConvert(value, ty) \
  SWIG_Ruby_CheckConvert(value, ty)
#define SWIG_NewPackedObj(ptr, sz, ty) \
  SWIG_Ruby_NewPackedObj(ptr, sz, ty)
#define SWIG_ConvertPacked(obj, ptr, sz, ty, flags) \
  SWIG_Ruby_ConvertPacked(obj, ptr, sz, ty, flags)


/***********************************************************************
 * common.swg
 *
 *     This file contains generic SWIG runtime support for pointer
 *     type checking as well as a few commonly used macros to control
 *     external linkage.
 *
 * Author : David Beazley (beazley@cs.uchicago.edu)
 *
 * Copyright (c) 1999-2000, The University of Chicago
 * 
 * This file may be freely redistributed without license or fee provided
 * this copyright message remains intact.
 ************************************************************************/

#include <string.h>

#if defined(_WIN32) || defined(__WIN32__) || defined(__CYGWIN__)
#  if defined(_MSC_VER) || defined(__GNUC__)
#    if defined(STATIC_LINKED)
#      define SWIGEXPORT(a) a
#      define SWIGIMPORT(a) extern a
#    else
#      define SWIGEXPORT(a) __declspec(dllexport) a
#      define SWIGIMPORT(a) extern a
#    endif
#  else
#    if defined(__BORLANDC__)
#      define SWIGEXPORT(a) a _export
#      define SWIGIMPORT(a) a _export
#    else
#      define SWIGEXPORT(a) a
#      define SWIGIMPORT(a) a
#    endif
#  endif
#else
#  define SWIGEXPORT(a) a
#  define SWIGIMPORT(a) a
#endif

#ifdef SWIG_GLOBAL
#  define SWIGRUNTIME(a) SWIGEXPORT(a)
#else
#  define SWIGRUNTIME(a) static a
#endif

#ifdef __cplusplus
extern "C" {
#endif

typedef void *(*swig_converter_func)(void *);
typedef struct swig_type_info *(*swig_dycast_func)(void **);

typedef struct swig_type_info {
  const char             *name;
  swig_converter_func     converter;
  const char             *str;
  void                   *clientdata;
  swig_dycast_func        dcast;
  struct swig_type_info  *next;
  struct swig_type_info  *prev;
} swig_type_info;

#ifdef SWIG_NOINCLUDE

SWIGIMPORT(swig_type_info *) SWIG_TypeRegister(swig_type_info *);
SWIGIMPORT(swig_type_info *) SWIG_TypeCheck(char *c, swig_type_info *);
SWIGIMPORT(void *)           SWIG_TypeCast(swig_type_info *, void *);
SWIGIMPORT(swig_type_info *) SWIG_TypeDynamicCast(swig_type_info *, void **);
SWIGIMPORT(const char *)     SWIG_TypeName(const swig_type_info *);
SWIGIMPORT(const char *)     SWIG_TypePrettyName(const swig_type_info *);
SWIGIMPORT(swig_type_info *) SWIG_TypeQuery(const char *);
SWIGIMPORT(void)             SWIG_TypeClientData(swig_type_info *, void *);
SWIGIMPORT(char *)           SWIG_PackData(char *, void *, int);
SWIGIMPORT(char *)           SWIG_UnpackData(char *, void *, int);

#else

static swig_type_info *swig_type_list = 0;
static swig_type_info **swig_type_list_handle = &swig_type_list;

/* Register a type mapping with the type-checking */
SWIGRUNTIME(swig_type_info *)
SWIG_TypeRegister(swig_type_info *ti) {
  swig_type_info *tc, *head, *ret, *next;
  /* Check to see if this type has already been registered */
  tc = *swig_type_list_handle;
  while (tc) {
    if (strcmp(tc->name, ti->name) == 0) {
      /* Already exists in the table.  Just add additional types to the list */
      if (tc->clientdata) ti->clientdata = tc->clientdata;
      head = tc;
      next = tc->next;
      goto l1;
    }
    tc = tc->prev;
  }
  head = ti;
  next = 0;

  /* Place in list */
  ti->prev = *swig_type_list_handle;
  *swig_type_list_handle = ti;

  /* Build linked lists */
  l1:
  ret = head;
  tc = ti + 1;
  /* Patch up the rest of the links */
  while (tc->name) {
    head->next = tc;
    tc->prev = head;
    head = tc;
    tc++;
  }
  if (next) next->prev = head;
  head->next = next;
  return ret;
}

/* Check the typename */
SWIGRUNTIME(swig_type_info *) 
SWIG_TypeCheck(char *c, swig_type_info *ty) {
  swig_type_info *s;
  if (!ty) return 0;        /* Void pointer */
  s = ty->next;             /* First element always just a name */
  do {
    if (strcmp(s->name,c) == 0) {
      if (s == ty->next) return s;
      /* Move s to the top of the linked list */
      s->prev->next = s->next;
      if (s->next) {
        s->next->prev = s->prev;
      }
      /* Insert s as second element in the list */
      s->next = ty->next;
      if (ty->next) ty->next->prev = s;
      ty->next = s;
      s->prev = ty;
      return s;
    }
    s = s->next;
  } while (s && (s != ty->next));
  return 0;
}

/* Cast a pointer up an inheritance hierarchy */
SWIGRUNTIME(void *) 
SWIG_TypeCast(swig_type_info *ty, void *ptr) {
  if ((!ty) || (!ty->converter)) return ptr;
  return (*ty->converter)(ptr);
}

/* Dynamic pointer casting. Down an inheritance hierarchy */
SWIGRUNTIME(swig_type_info *) 
SWIG_TypeDynamicCast(swig_type_info *ty, void **ptr) {
  swig_type_info *lastty = ty;
  if (!ty || !ty->dcast) return ty;
  while (ty && (ty->dcast)) {
    ty = (*ty->dcast)(ptr);
    if (ty) lastty = ty;
  }
  return lastty;
}

/* Return the name associated with this type */
SWIGRUNTIME(const char *)
SWIG_TypeName(const swig_type_info *ty) {
  return ty->name;
}

/* Return the pretty name associated with this type,
   that is an unmangled type name in a form presentable to the user.
*/
SWIGRUNTIME(const char *)
SWIG_TypePrettyName(const swig_type_info *type) {
  /* The "str" field contains the equivalent pretty names of the
     type, separated by vertical-bar characters.  We choose
     to print the last name, as it is often (?) the most
     specific. */
  if (type->str != NULL) {
    const char *last_name = type->str;
    const char *s;
    for (s = type->str; *s; s++)
      if (*s == '|') last_name = s+1;
    return last_name;
  }
  else
    return type->name;
}

/* 
   Compare two type names skipping the space characters, therefore
   "char*" == "char *" and "Class<int>" == "Class<int >", etc.

   Return 0 when the two name types are equivalent, as in
   strncmp, but skipping ' '.
*/
static int
SWIG_TypeNameComp(const char *f1, const char *l1,
		  const char *f2, const char *l2) {
  for (;(f1 != l1) && (f2 != l2); ++f1, ++f2) {
    while ((*f1 == ' ') && (f1 != l1)) ++f1;
    while ((*f2 == ' ') && (f2 != l2)) ++f2;
    if (*f1 != *f2) return *f1 - *f2;
  }
  return (l1 - f1) - (l2 - f2);
}

/*
  Check type equivalence in a name list like <name1>|<name2>|...
*/
static int
SWIG_TypeEquiv(const char *nb, const char *tb) {
  int equiv = 0;
  const char* te = tb + strlen(tb);
  const char* ne = nb;
  while (!equiv && *ne) {
    for (nb = ne; *ne; ++ne) {
      if (*ne == '|') break;
    }
    equiv = SWIG_TypeNameComp(nb, ne, tb, te) == 0;
    if (*ne) ++ne;
  }
  return equiv;
}
  

/* Search for a swig_type_info structure */
SWIGRUNTIME(swig_type_info *)
SWIG_TypeQuery(const char *name) {
  swig_type_info *ty = *swig_type_list_handle;
  while (ty) {
    if (ty->str && (SWIG_TypeEquiv(ty->str,name))) return ty;
    if (ty->name && (strcmp(name,ty->name) == 0)) return ty;
    ty = ty->prev;
  }
  return 0;
}

/* Set the clientdata field for a type */
SWIGRUNTIME(void)
SWIG_TypeClientData(swig_type_info *ti, void *clientdata) {
  swig_type_info *tc, *equiv;
  if (ti->clientdata == clientdata) return;
  ti->clientdata = clientdata;
  equiv = ti->next;
  while (equiv) {
    if (!equiv->converter) {
      tc = *swig_type_list_handle;
      while (tc) {
        if ((strcmp(tc->name, equiv->name) == 0))
          SWIG_TypeClientData(tc,clientdata);
        tc = tc->prev;
      }
    }
    equiv = equiv->next;
  }
}

/* Pack binary data into a string */
SWIGRUNTIME(char *)
SWIG_PackData(char *c, void *ptr, int sz) {
  static char hex[17] = "0123456789abcdef";
  unsigned char *u = (unsigned char *) ptr;
  const unsigned char *eu =  u + sz;
  register unsigned char uu;
  for (; u != eu; ++u) {
    uu = *u;
    *(c++) = hex[(uu & 0xf0) >> 4];
    *(c++) = hex[uu & 0xf];
  }
  return c;
}

/* Unpack binary data from a string */
SWIGRUNTIME(char *)
SWIG_UnpackData(char *c, void *ptr, int sz) {
  register unsigned char uu = 0;
  register int d;
  unsigned char *u = (unsigned char *) ptr;
  const unsigned char *eu =  u + sz;
  for (; u != eu; ++u) {
    d = *(c++);
    if ((d >= '0') && (d <= '9'))
      uu = ((d - '0') << 4);
    else if ((d >= 'a') && (d <= 'f'))
      uu = ((d - ('a'-10)) << 4);
    d = *(c++);
    if ((d >= '0') && (d <= '9'))
      uu |= (d - '0');
    else if ((d >= 'a') && (d <= 'f'))
      uu |= (d - ('a'-10));
    *u = uu;
  }
  return c;
}

#endif

#ifdef __cplusplus
}
#endif

/* rubydec.swg -*- c -*- */
#ifdef __cplusplus
extern "C" {
#endif

SWIGIMPORT(void)   SWIG_Ruby_InitRuntime(void);
SWIGIMPORT(void)   SWIG_Ruby_define_class(swig_type_info *);
SWIGIMPORT(VALUE)  SWIG_Ruby_NewPointerObj(void *, swig_type_info *, int);
SWIGIMPORT(VALUE)  SWIG_Ruby_NewClassInstance(VALUE, swig_type_info *);
SWIGIMPORT(char *) SWIG_Ruby_MangleStr(VALUE);
SWIGIMPORT(int)    SWIG_Ruby_ConvertPtr(VALUE, void**, swig_type_info *, int);
SWIGIMPORT(void *) SWIG_Ruby_MustGetPtr(VALUE, swig_type_info *, int, int);
SWIGIMPORT(int)    SWIG_Ruby_CheckConvert(VALUE, swig_type_info *);
SWIGIMPORT(VALUE)  SWIG_Ruby_NewPackedObj(void *ptr, int sz, swig_type_info *type);
SWIGIMPORT(void)   SWIG_Ruby_ConvertPacked(VALUE obj, void *ptr, int sz, swig_type_info *ty, int flags);

#ifdef __cplusplus
}
#endif


/* -------- TYPES TABLE (BEGIN) -------- */

#define  SWIGTYPE_p_FXObject swig_types[0] 
#define  SWIGTYPE_p_FXScrollArea swig_types[1] 
#define  SWIGTYPE_p_FXShutterItem swig_types[2] 
#define  SWIGTYPE_p_FXStatusBar swig_types[3] 
#define  SWIGTYPE_p_FXScrollBar swig_types[4] 
#define  SWIGTYPE_p_FXWindow swig_types[5] 
#define  SWIGTYPE_p_FXComposite swig_types[6] 
#define  SWIGTYPE_p_FXScrollWindow swig_types[7] 
#define  SWIGTYPE_p_FXFont swig_types[8] 
#define  SWIGTYPE_p_FXId swig_types[9] 
#define  SWIGTYPE_p_FXStatusLine swig_types[10] 
#define  SWIGTYPE_p_FXGroupBox swig_types[11] 
#define  SWIGTYPE_p_FXButton swig_types[12] 
#define  SWIGTYPE_p_FXStream swig_types[13] 
#define  SWIGTYPE_p_FXDrawable swig_types[14] 
#define  SWIGTYPE_p_FXSplitter swig_types[15] 
#define  SWIGTYPE_p_FX4Splitter swig_types[16] 
#define  SWIGTYPE_p_FXPacker swig_types[17] 
#define  SWIGTYPE_p_FXHorizontalFrame swig_types[18] 
#define  SWIGTYPE_p_FXVerticalFrame swig_types[19] 
#define  SWIGTYPE_p_FXShutter swig_types[20] 
#define  SWIGTYPE_p_FXIcon swig_types[21] 
#define  SWIGTYPE_p_FXDragCorner swig_types[22] 
#define  SWIGTYPE_p_FXMatrix swig_types[23] 
#define  SWIGTYPE_p_FXSpring swig_types[24] 
#define  SWIGTYPE_p_FXSwitcher swig_types[25] 
static swig_type_info *swig_types[27];

/* -------- TYPES TABLE (END) -------- */

#define SWIG_init    Init_layout
#define SWIG_name    "Layout"


static void SWIG_AsVal(VALUE obj, int *val)
{
    *val = (int) NUM2INT(obj);
}


#include "FXRbCommon.h"


inline FXColor to_FXColor(VALUE obj){
  if(TYPE(obj)==T_STRING){
    return fxcolorfromname(StringValuePtr(obj));
    }
  else if(TYPE(obj)==T_SYMBOL){
    return fxcolorfromname(rb_id2name(SYM2ID(obj)));
    }
  else{
    return NUM2ULONG(obj);
    }
  }


inline FXString to_FXString(VALUE obj){
  if(!NIL_P(obj)){
    Check_Type(obj,T_STRING);
    return FXString(STR2CSTR(obj));
    }
  else{
    return FXString::null;
    }
  }


inline FXbool to_FXbool(VALUE obj){
  if (obj == Qtrue || obj == Qfalse){
    return (obj == Qtrue) ? TRUE : FALSE;
    }
  else{
    return static_cast<FXbool>(NUM2UINT(obj));
    }
  }


static swig_type_info* FXEventTypeInfo=0;

inline void* to_FXEvent(VALUE obj){
  void* ptr;
  if(!FXEventTypeInfo){
    FXEventTypeInfo=SWIG_TypeQuery("FXEvent *");
    FXASSERT(FXEventTypeInfo!=0);
    }
  SWIG_ConvertPtr(obj,&ptr,FXEventTypeInfo,1);
  return ptr;
  }

FXPacker *new_FXPacker(FXComposite *p,FXuint opts,FXint x,FXint y,FXint w,FXint h,FXint pl,FXint pr,FXint pt,FXint pb,FXint hs,FXint vs){
      return new FXRbPacker(p,opts,x,y,w,h,pl,pr,pt,pb,hs,vs);
      }

swig_class cFXPacker;
static void free_FXPacker(FXPacker *);

static swig_type_info *FXPacker_dynamic_cast(void **ptr) {
    FXPacker **ppPacker = reinterpret_cast<FXPacker **>(ptr);
    FXColorSelector *pColorSelector=dynamic_cast<FXColorSelector*>(*ppPacker);
    if(pColorSelector){
      *ptr=reinterpret_cast<void*>(pColorSelector);
      return SWIG_TypeQuery("FXColorSelector *");
      }
    FXComboBox *pComboBox=dynamic_cast<FXComboBox*>(*ppPacker);
    if(pComboBox){
      *ptr=reinterpret_cast<void*>(pComboBox);
      return SWIG_TypeQuery("FXComboBox *");
      }
    FXDirSelector *pDirSelector=dynamic_cast<FXDirSelector*>(*ppPacker);
    if(pDirSelector){
      *ptr=reinterpret_cast<void*>(pDirSelector);
      return SWIG_TypeQuery("FXDirSelector *");
      }
    FXFileSelector *pFileSelector=dynamic_cast<FXFileSelector*>(*ppPacker);
    if(pFileSelector){
      *ptr=reinterpret_cast<void*>(pFileSelector);
      return SWIG_TypeQuery("FXFileSelector *");
      }
    FXFontSelector *pFontSelector=dynamic_cast<FXFontSelector*>(*ppPacker);
    if(pFontSelector){
      *ptr=reinterpret_cast<void*>(pFontSelector);
      return SWIG_TypeQuery("FXFontSelector *");
      }
    FXGroupBox *pGroupBox=dynamic_cast<FXGroupBox*>(*ppPacker);
    if(pGroupBox){
      *ptr=reinterpret_cast<void*>(pGroupBox);
      return SWIG_TypeQuery("FXGroupBox *");
      }
    FXHorizontalFrame *pHorizontalFrame=dynamic_cast<FXHorizontalFrame*>(*ppPacker);
    if(pHorizontalFrame){
      *ptr=reinterpret_cast<void*>(pHorizontalFrame);
      return SWIG_TypeQuery("FXHorizontalFrame *");
      }
    FXListBox *pListBox=dynamic_cast<FXListBox*>(*ppPacker);
    if(pListBox){
      *ptr=reinterpret_cast<void*>(pListBox);
      return SWIG_TypeQuery("FXListBox *");
      }
    FXMatrix *pMatrix=dynamic_cast<FXMatrix*>(*ppPacker);
    if(pMatrix){
      *ptr=reinterpret_cast<void*>(pMatrix);
      return SWIG_TypeQuery("FXMatrix *");
      }
    FXRealSpinner *pRealSpinner=dynamic_cast<FXRealSpinner*>(*ppPacker);
    if(pRealSpinner){
      *ptr=reinterpret_cast<void*>(pRealSpinner);
      return SWIG_TypeQuery("FXRealSpinner *");
      }
    FXSpinner *pSpinner=dynamic_cast<FXSpinner*>(*ppPacker);
    if(pSpinner){
      *ptr=reinterpret_cast<void*>(pSpinner);
      return SWIG_TypeQuery("FXSpinner *");
      }
    FXSwitcher *pSwitcher=dynamic_cast<FXSwitcher*>(*ppPacker);
    if(pSwitcher){
      *ptr=reinterpret_cast<void*>(pSwitcher);
      return SWIG_TypeQuery("FXSwitcher *");
      }
    FXTabBar *pTabBar=dynamic_cast<FXTabBar*>(*ppPacker);
    if(pTabBar){
      *ptr=reinterpret_cast<void*>(pTabBar);
      return SWIG_TypeQuery("FXTabBar *");
      }
    FXToolBar *pToolBar=dynamic_cast<FXToolBar*>(*ppPacker);
    if(pToolBar){
      *ptr=reinterpret_cast<void*>(pToolBar);
      return SWIG_TypeQuery("FXToolBar *");
      }
    FXTreeListBox *pTreeListBox=dynamic_cast<FXTreeListBox*>(*ppPacker);
    if(pTreeListBox){
      *ptr=reinterpret_cast<void*>(pTreeListBox);
      return SWIG_TypeQuery("FXTreeListBox *");
      }
    FXVerticalFrame *pVerticalFrame=dynamic_cast<FXVerticalFrame*>(*ppPacker);
    if(pVerticalFrame){
      *ptr=reinterpret_cast<void*>(pVerticalFrame);
      return SWIG_TypeQuery("FXVerticalFrame *");
      }
    return 0;
}

FXSpring *new_FXSpring(FXComposite *p,FXuint opts,FXint relw,FXint relh,FXint x,FXint y,FXint w,FXint h,FXint pl,FXint pr,FXint pt,FXint pb,FXint hs,FXint vs){
      return new FXRbSpring(p,opts,relw,relh,x,y,w,h,pl,pr,pt,pb,hs,vs);
      }

swig_class cFXSpring;
FXHorizontalFrame *new_FXHorizontalFrame(FXComposite *p,FXuint opts,FXint x,FXint y,FXint w,FXint h,FXint pl,FXint pr,FXint pt,FXint pb,FXint hs,FXint vs){
      return new FXRbHorizontalFrame(p,opts,x,y,w,h,pl,pr,pt,pb,hs,vs);
      }

swig_class cFXHorizontalFrame;

static swig_type_info *FXHorizontalFrame_dynamic_cast(void **ptr) {
    FXHorizontalFrame **ppHorizontalFrame = reinterpret_cast<FXHorizontalFrame **>(ptr);
    FXStatusBar *pStatusBar=dynamic_cast<FXStatusBar*>(*ppHorizontalFrame);
    if(pStatusBar){
      *ptr=reinterpret_cast<void*>(pStatusBar);
      return SWIG_TypeQuery("FXStatusBar *");
      }
    return 0;
}

FXVerticalFrame *new_FXVerticalFrame(FXComposite *p,FXuint opts,FXint x,FXint y,FXint w,FXint h,FXint pl,FXint pr,FXint pt,FXint pb,FXint hs,FXint vs){
      return new FXRbVerticalFrame(p,opts,x,y,w,h,pl,pr,pt,pb,hs,vs);
      }

swig_class cFXVerticalFrame;
static void free_FXVerticalFrame(FXVerticalFrame *);

static swig_type_info *FXVerticalFrame_dynamic_cast(void **ptr) {
    FXVerticalFrame **ppVerticalFrame = reinterpret_cast<FXVerticalFrame **>(ptr);
    FXShutter *pShutter=dynamic_cast<FXShutter*>(*ppVerticalFrame);
    if(pShutter){
      *ptr=reinterpret_cast<void*>(pShutter);
      return SWIG_TypeQuery("FXShutter *");
      }
    FXShutterItem *pShutterItem=dynamic_cast<FXShutterItem*>(*ppVerticalFrame);
    if(pShutterItem){
      *ptr=reinterpret_cast<void*>(pShutterItem);
      return SWIG_TypeQuery("FXShutterItem *");
      }
    return 0;
}

FXMatrix *new_FXMatrix(FXComposite *p,FXint n,FXuint opts,FXint x,FXint y,FXint w,FXint h,FXint pl,FXint pr,FXint pt,FXint pb,FXint hs,FXint vs){
      return new FXRbMatrix(p,n,opts,x,y,w,h,pl,pr,pt,pb,hs,vs);
      }

swig_class cFXMatrix;
static void free_FXMatrix(FXMatrix *);
FXGroupBox *new_FXGroupBox(FXComposite *p,FXString const &text,FXuint opts,FXint x,FXint y,FXint w,FXint h,FXint pl,FXint pr,FXint pt,FXint pb,FXint hs,FXint vs){
      return new FXRbGroupBox(p,text,opts,x,y,w,h,pl,pr,pt,pb,hs,vs);
      }

swig_class cFXGroupBox;
static void free_FXGroupBox(FXGroupBox *);
FXSwitcher *new_FXSwitcher(FXComposite *p,FXuint opts,FXint x,FXint y,FXint w,FXint h,FXint pl,FXint pr,FXint pt,FXint pb){
      return new FXRbSwitcher(p,opts,x,y,w,h,pl,pr,pt,pb);
      }

swig_class cFXSwitcher;
static void free_FXSwitcher(FXSwitcher *);
FXShutterItem *new_FXShutterItem(FXShutter *p,FXString const &text,FXIcon *icon,FXuint opts,FXint x,FXint y,FXint w,FXint h,FXint pl,FXint pr,FXint pt,FXint pb,FXint hs,FXint vs){
      return new FXRbShutterItem(p,text,icon,opts,x,y,w,h,pl,pr,pt,pb,hs,vs);
      }

swig_class cFXShutterItem;
static void free_FXShutterItem(FXShutterItem *);
FXShutter *new_FXShutter(FXComposite *p,FXObject *tgt,FXSelector sel,FXuint opts,FXint x,FXint y,FXint w,FXint h,FXint pl,FXint pr,FXint pt,FXint pb,FXint hs,FXint vs){
      return new FXRbShutter(p,tgt,sel,opts,x,y,w,h,pl,pr,pt,pb,hs,vs);
      }

swig_class cFXShutter;
static void free_FXShutter(FXShutter *);
FXSplitter *new_FXSplitter__SWIG_0(FXComposite *p,FXuint opts,FXint x,FXint y,FXint w,FXint h){
      return new FXRbSplitter(p,opts,x,y,w,h);
      }
FXSplitter *new_FXSplitter__SWIG_1(FXComposite *p,FXObject *tgt,FXSelector sel,FXuint opts,FXint x,FXint y,FXint w,FXint h){
      return new FXRbSplitter(p,tgt,sel,opts,x,y,w,h);
      }

swig_class cFXSplitter;
static void free_FXSplitter(FXSplitter *);
FX4Splitter *new_FX4Splitter__SWIG_0(FXComposite *p,FXuint opts,FXint x,FXint y,FXint w,FXint h){
      return new FXRb4Splitter(p,opts,x,y,w,h);
      }
FX4Splitter *new_FX4Splitter__SWIG_1(FXComposite *p,FXObject *tgt,FXSelector sel,FXuint opts,FXint x,FXint y,FXint w,FXint h){
      return new FXRb4Splitter(p,tgt,sel,opts,x,y,w,h);
      }

swig_class cFX4Splitter;
static void free_FX4Splitter(FX4Splitter *);
FXStatusBar *new_FXStatusBar(FXComposite *p,FXuint opts,FXint x,FXint y,FXint w,FXint h,FXint pl,FXint pr,FXint pt,FXint pb,FXint hs,FXint vs){
      return new FXRbStatusBar(p,opts,x,y,w,h,pl,pr,pt,pb,hs,vs);
      }

swig_class cFXStatusBar;
static void free_FXStatusBar(FXStatusBar *);
FXScrollArea *new_FXScrollArea(FXComposite *p,FXuint opts,FXint x,FXint y,FXint w,FXint h){
      return new FXRbScrollArea(p,opts,x,y,w,h);
      }
VALUE FXScrollArea_position__SWIG_1(FXScrollArea const *self){
    FXint x, y;
    self->getPosition(x, y);
    VALUE pos = rb_ary_new();
    rb_ary_push(pos, INT2NUM(x));
    rb_ary_push(pos, INT2NUM(y));
    return pos;
  }

swig_class cFXScrollArea;
static void free_FXScrollArea(FXScrollArea *);

static swig_type_info *FXScrollArea_dynamic_cast(void **ptr) {
    FXScrollArea **ppScrollArea = reinterpret_cast<FXScrollArea **>(ptr);
    FXBitmapView *pBitmapView=dynamic_cast<FXBitmapView*>(*ppScrollArea);
    if(pBitmapView){
      *ptr=reinterpret_cast<void*>(pBitmapView);
      return SWIG_TypeQuery("FXBitmapView *");
      }
    FXFoldingList *pFoldingList=dynamic_cast<FXFoldingList*>(*ppScrollArea);
    if(pFoldingList){
      *ptr=reinterpret_cast<void*>(pFoldingList);
      return SWIG_TypeQuery("FXFoldingList *");
      }
    FXIconList *pIconList=dynamic_cast<FXIconList*>(*ppScrollArea);
    if(pIconList){
      *ptr=reinterpret_cast<void*>(pIconList);
      return SWIG_TypeQuery("FXIconList *");
      }
    FXImageView *pImageView=dynamic_cast<FXImageView*>(*ppScrollArea);
    if(pImageView){
      *ptr=reinterpret_cast<void*>(pImageView);
      return SWIG_TypeQuery("FXImageView *");
      }
    FXList *pList=dynamic_cast<FXList*>(*ppScrollArea);
    if(pList){
      *ptr=reinterpret_cast<void*>(pList);
      return SWIG_TypeQuery("FXList *");
      }
    FXMDIClient *pMDIClient=dynamic_cast<FXMDIClient*>(*ppScrollArea);
    if(pMDIClient){
      *ptr=reinterpret_cast<void*>(pMDIClient);
      return SWIG_TypeQuery("FXMDIClient *");
      }
    FXScrollWindow *pScrollWindow=dynamic_cast<FXScrollWindow*>(*ppScrollArea);
    if(pScrollWindow){
      *ptr=reinterpret_cast<void*>(pScrollWindow);
      return SWIG_TypeQuery("FXScrollWindow *");
      }
    FXTable *pTable=dynamic_cast<FXTable*>(*ppScrollArea);
    if(pTable){
      *ptr=reinterpret_cast<void*>(pTable);
      return SWIG_TypeQuery("FXTable *");
      }
    FXText *pText=dynamic_cast<FXText*>(*ppScrollArea);
    if(pText){
      *ptr=reinterpret_cast<void*>(pText);
      return SWIG_TypeQuery("FXText *");
      }
    FXTreeList *pTreeList=dynamic_cast<FXTreeList*>(*ppScrollArea);
    if(pTreeList){
      *ptr=reinterpret_cast<void*>(pTreeList);
      return SWIG_TypeQuery("FXTreeList *");
      }
    return 0;
}

FXScrollWindow *new_FXScrollWindow(FXComposite *p,FXuint opts,FXint x,FXint y,FXint w,FXint h){
      return new FXRbScrollWindow(p,opts,x,y,w,h);
      }
VALUE FXScrollWindow_position__SWIG_1(FXScrollWindow const *self){
    FXint x, y;
    self->getPosition(x, y);
    VALUE pos = rb_ary_new();
    rb_ary_push(pos, INT2NUM(x));
    rb_ary_push(pos, INT2NUM(y));
    return pos;
  }

swig_class cFXScrollWindow;
static void free_FXScrollWindow(FXScrollWindow *);
static VALUE _wrap_FXPacker_onPaint(int argc, VALUE *argv, VALUE self) { FXPacker *arg1 = (FXPacker *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPacker, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onPaint(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXPacker_onFocusUp(int argc, VALUE *argv, VALUE self) { FXPacker *arg1 = (FXPacker *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPacker, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onFocusUp(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXPacker_onFocusDown(int argc, VALUE *argv, VALUE self) { FXPacker *arg1 = (FXPacker *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPacker, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onFocusDown(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXPacker_onFocusLeft(int argc, VALUE *argv, VALUE self) { FXPacker *arg1 = (FXPacker *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPacker, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onFocusLeft(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXPacker_onFocusRight(int argc, VALUE *argv, VALUE self) { FXPacker *arg1 = (FXPacker *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPacker, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onFocusRight(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE _wrap_FXPacker_allocate(VALUE self) {
#else
     static VALUE _wrap_FXPacker_allocate(int argc, VALUE *argv, VALUE self) {
#endif
         VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_FXPacker);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
         return vresult; }
static VALUE _wrap_new_FXPacker(int argc, VALUE *argv, VALUE self) { FXComposite *arg1 = (FXComposite *) 0 ;
    FXuint arg2 = (FXuint) 0 ; FXint arg3 = (FXint) 0 ; FXint arg4 = (FXint) 0 ; FXint arg5 = (FXint) 0 ;
    FXint arg6 = (FXint) 0 ; FXint arg7 = (FXint) DEFAULT_SPACING ; FXint arg8 = (FXint) DEFAULT_SPACING ;
    FXint arg9 = (FXint) DEFAULT_SPACING ; FXint arg10 = (FXint) DEFAULT_SPACING ; FXint arg11 = (FXint) DEFAULT_SPACING ;
    FXint arg12 = (FXint) DEFAULT_SPACING ; FXPacker *result; if ((argc < 1) || (argc > 12))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXComposite, 1); if (argc > 1) { arg2 = NUM2UINT(argv[1]); } 
    if (argc > 2) { arg3 = NUM2INT(argv[2]); }  if (argc > 3) { arg4 = NUM2INT(argv[3]); }  if (argc > 4) {
        arg5 = NUM2INT(argv[4]); }  if (argc > 5) { arg6 = NUM2INT(argv[5]); }  if (argc > 6) { arg7 = NUM2INT(argv[6]); } 
    if (argc > 7) { arg8 = NUM2INT(argv[7]); }  if (argc > 8) { arg9 = NUM2INT(argv[8]); }  if (argc > 9) {
        arg10 = NUM2INT(argv[9]); }  if (argc > 10) { arg11 = NUM2INT(argv[10]); }  if (argc > 11) { arg12 = NUM2INT(argv[11]); }
     { result = (FXPacker *)new_FXPacker(arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8,arg9,arg10,arg11,arg12);
        DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result); if(rb_block_given_p()){ rb_yield(self); }  }  return self; }
static VALUE _wrap_FXPacker_setFrameStyle(int argc, VALUE *argv, VALUE self) { FXPacker *arg1 = (FXPacker *) 0 ; FXuint arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPacker, 1); arg2 = NUM2UINT(argv[0]); (arg1)->setFrameStyle(arg2);
    return Qnil; }
static VALUE _wrap_FXPacker_getFrameStyle(int argc, VALUE *argv, VALUE self) { FXPacker *arg1 = (FXPacker *) 0 ; FXuint result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPacker, 1); result = (FXuint)((FXPacker const *)arg1)->getFrameStyle();
    vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXPacker_setPackingHints(int argc, VALUE *argv, VALUE self) { FXPacker *arg1 = (FXPacker *) 0 ; FXuint arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPacker, 1); arg2 = NUM2UINT(argv[0]); (arg1)->setPackingHints(arg2);
    return Qnil; }
static VALUE _wrap_FXPacker_getPackingHints(int argc, VALUE *argv, VALUE self) { FXPacker *arg1 = (FXPacker *) 0 ;
    FXuint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPacker, 1);
    result = (FXuint)((FXPacker const *)arg1)->getPackingHints(); vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXPacker_getBorderWidth(int argc, VALUE *argv, VALUE self) { FXPacker *arg1 = (FXPacker *) 0 ; FXint result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPacker, 1); result = (FXint)((FXPacker const *)arg1)->getBorderWidth();
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXPacker_setPadTop(int argc, VALUE *argv, VALUE self) { FXPacker *arg1 = (FXPacker *) 0 ; FXint arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPacker, 1); arg2 = NUM2INT(argv[0]); (arg1)->setPadTop(arg2);
    return Qnil; }
static VALUE _wrap_FXPacker_getPadTop(int argc, VALUE *argv, VALUE self) { FXPacker *arg1 = (FXPacker *) 0 ; FXint result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPacker, 1); result = (FXint)((FXPacker const *)arg1)->getPadTop();
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXPacker_setPadBottom(int argc, VALUE *argv, VALUE self) { FXPacker *arg1 = (FXPacker *) 0 ; FXint arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPacker, 1); arg2 = NUM2INT(argv[0]); (arg1)->setPadBottom(arg2);
    return Qnil; }
static VALUE _wrap_FXPacker_getPadBottom(int argc, VALUE *argv, VALUE self) { FXPacker *arg1 = (FXPacker *) 0 ; FXint result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPacker, 1); result = (FXint)((FXPacker const *)arg1)->getPadBottom();
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXPacker_setPadLeft(int argc, VALUE *argv, VALUE self) { FXPacker *arg1 = (FXPacker *) 0 ; FXint arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPacker, 1); arg2 = NUM2INT(argv[0]); (arg1)->setPadLeft(arg2);
    return Qnil; }
static VALUE _wrap_FXPacker_getPadLeft(int argc, VALUE *argv, VALUE self) { FXPacker *arg1 = (FXPacker *) 0 ; FXint result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPacker, 1); result = (FXint)((FXPacker const *)arg1)->getPadLeft();
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXPacker_setPadRight(int argc, VALUE *argv, VALUE self) { FXPacker *arg1 = (FXPacker *) 0 ; FXint arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPacker, 1); arg2 = NUM2INT(argv[0]); (arg1)->setPadRight(arg2);
    return Qnil; }
static VALUE _wrap_FXPacker_getPadRight(int argc, VALUE *argv, VALUE self) { FXPacker *arg1 = (FXPacker *) 0 ; FXint result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPacker, 1); result = (FXint)((FXPacker const *)arg1)->getPadRight();
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXPacker_setHiliteColor(int argc, VALUE *argv, VALUE self) { FXPacker *arg1 = (FXPacker *) 0 ; FXColor arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPacker, 1); arg2 = to_FXColor(argv[0]); (arg1)->setHiliteColor(arg2);
    return Qnil; }
static VALUE _wrap_FXPacker_getHiliteColor(int argc, VALUE *argv, VALUE self) { FXPacker *arg1 = (FXPacker *) 0 ;
    FXColor result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPacker, 1);
    result = (FXColor)((FXPacker const *)arg1)->getHiliteColor(); vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXPacker_setShadowColor(int argc, VALUE *argv, VALUE self) { FXPacker *arg1 = (FXPacker *) 0 ; FXColor arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPacker, 1); arg2 = to_FXColor(argv[0]); (arg1)->setShadowColor(arg2);
    return Qnil; }
static VALUE _wrap_FXPacker_getShadowColor(int argc, VALUE *argv, VALUE self) { FXPacker *arg1 = (FXPacker *) 0 ;
    FXColor result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPacker, 1);
    result = (FXColor)((FXPacker const *)arg1)->getShadowColor(); vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXPacker_setBorderColor(int argc, VALUE *argv, VALUE self) { FXPacker *arg1 = (FXPacker *) 0 ; FXColor arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPacker, 1); arg2 = to_FXColor(argv[0]); (arg1)->setBorderColor(arg2);
    return Qnil; }
static VALUE _wrap_FXPacker_getBorderColor(int argc, VALUE *argv, VALUE self) { FXPacker *arg1 = (FXPacker *) 0 ;
    FXColor result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPacker, 1);
    result = (FXColor)((FXPacker const *)arg1)->getBorderColor(); vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXPacker_setBaseColor(int argc, VALUE *argv, VALUE self) { FXPacker *arg1 = (FXPacker *) 0 ; FXColor arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPacker, 1); arg2 = to_FXColor(argv[0]); (arg1)->setBaseColor(arg2);
    return Qnil; }
static VALUE _wrap_FXPacker_getBaseColor(int argc, VALUE *argv, VALUE self) { FXPacker *arg1 = (FXPacker *) 0 ; FXColor result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPacker, 1); result = (FXColor)((FXPacker const *)arg1)->getBaseColor();
    vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXPacker_setHSpacing(int argc, VALUE *argv, VALUE self) { FXPacker *arg1 = (FXPacker *) 0 ; FXint arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPacker, 1); arg2 = NUM2INT(argv[0]); (arg1)->setHSpacing(arg2);
    return Qnil; }
static VALUE _wrap_FXPacker_getHSpacing(int argc, VALUE *argv, VALUE self) { FXPacker *arg1 = (FXPacker *) 0 ; FXint result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPacker, 1); result = (FXint)((FXPacker const *)arg1)->getHSpacing();
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXPacker_setVSpacing(int argc, VALUE *argv, VALUE self) { FXPacker *arg1 = (FXPacker *) 0 ; FXint arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPacker, 1); arg2 = NUM2INT(argv[0]); (arg1)->setVSpacing(arg2);
    return Qnil; }
static VALUE _wrap_FXPacker_getVSpacing(int argc, VALUE *argv, VALUE self) { FXPacker *arg1 = (FXPacker *) 0 ; FXint result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPacker, 1); result = (FXint)((FXPacker const *)arg1)->getVSpacing();
    vresult = INT2NUM(result); return vresult; }
static void
free_FXPacker(FXPacker *arg1) {
    delete arg1;
}
static VALUE _wrap_FXPacker_save(int argc, VALUE *argv, VALUE self) { FXPacker *arg1 = (FXPacker *) 0 ; FXStream *arg2 = 0 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPacker, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXPacker_save((FXPacker const *)arg1,*arg2); return Qnil; }
static VALUE _wrap_FXPacker_load(int argc, VALUE *argv, VALUE self) { FXPacker *arg1 = (FXPacker *) 0 ; FXStream *arg2 = 0 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPacker, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXPacker_load(arg1,*arg2); return Qnil; }
static VALUE _wrap_FXPacker_create(int argc, VALUE *argv, VALUE self) { FXPacker *arg1 = (FXPacker *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPacker, 1); FXPacker_create(arg1); return Qnil; }
static VALUE _wrap_FXPacker_detach(int argc, VALUE *argv, VALUE self) { FXPacker *arg1 = (FXPacker *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPacker, 1); FXPacker_detach(arg1); return Qnil; }
static VALUE _wrap_FXPacker_destroy(int argc, VALUE *argv, VALUE self) { FXPacker *arg1 = (FXPacker *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPacker, 1); FXPacker_destroy(arg1); return Qnil; }
static VALUE _wrap_FXPacker_resize(int argc, VALUE *argv, VALUE self) { FXPacker *arg1 = (FXPacker *) 0 ; FXint arg2 ;
    FXint arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPacker, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    FXPacker_resize(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXPacker_getDefaultWidth(int argc, VALUE *argv, VALUE self) { FXPacker *arg1 = (FXPacker *) 0 ; FXint result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPacker, 1); result = (FXint)FXPacker_getDefaultWidth(arg1);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXPacker_getDefaultHeight(int argc, VALUE *argv, VALUE self) { FXPacker *arg1 = (FXPacker *) 0 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPacker, 1); result = (FXint)FXPacker_getDefaultHeight(arg1);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXPacker_getWidthForHeight(int argc, VALUE *argv, VALUE self) { FXPacker *arg1 = (FXPacker *) 0 ;
    FXint arg2 ; FXint result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPacker, 1); arg2 = NUM2INT(argv[0]);
    result = (FXint)FXPacker_getWidthForHeight(arg1,arg2); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXPacker_getHeightForWidth(int argc, VALUE *argv, VALUE self) { FXPacker *arg1 = (FXPacker *) 0 ;
    FXint arg2 ; FXint result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPacker, 1); arg2 = NUM2INT(argv[0]);
    result = (FXint)FXPacker_getHeightForWidth(arg1,arg2); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXPacker_canFocus(int argc, VALUE *argv, VALUE self) { FXPacker *arg1 = (FXPacker *) 0 ; FXbool result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPacker, 1); result = (FXbool)FXPacker_canFocus((FXPacker const *)arg1);
    vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXPacker_setFocus(int argc, VALUE *argv, VALUE self) { FXPacker *arg1 = (FXPacker *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPacker, 1); FXPacker_setFocus(arg1); return Qnil; }
static VALUE _wrap_FXPacker_killFocus(int argc, VALUE *argv, VALUE self) { FXPacker *arg1 = (FXPacker *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPacker, 1); FXPacker_killFocus(arg1); return Qnil; }
static VALUE _wrap_FXPacker_setDefault(int argc, VALUE *argv, VALUE self) { FXPacker *arg1 = (FXPacker *) 0 ;
    FXbool arg2 = (FXbool) 1 ; if ((argc < 0) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPacker, 1); if (argc > 0) { arg2 = to_FXbool(argv[0]); } 
    FXPacker_setDefault(arg1,arg2); return Qnil; }
static VALUE _wrap_FXPacker_enable(int argc, VALUE *argv, VALUE self) { FXPacker *arg1 = (FXPacker *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPacker, 1); FXPacker_enable(arg1); return Qnil; }
static VALUE _wrap_FXPacker_disable(int argc, VALUE *argv, VALUE self) { FXPacker *arg1 = (FXPacker *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPacker, 1); FXPacker_disable(arg1); return Qnil; }
static VALUE _wrap_FXPacker_raiseWindow(int argc, VALUE *argv, VALUE self) { FXPacker *arg1 = (FXPacker *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPacker, 1); FXPacker_raise(arg1); return Qnil; }
static VALUE _wrap_FXPacker_lower(int argc, VALUE *argv, VALUE self) { FXPacker *arg1 = (FXPacker *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPacker, 1); FXPacker_lower(arg1); return Qnil; }
static VALUE _wrap_FXPacker_move(int argc, VALUE *argv, VALUE self) { FXPacker *arg1 = (FXPacker *) 0 ; FXint arg2 ;
    FXint arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPacker, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    FXPacker_move(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXPacker_position(int argc, VALUE *argv, VALUE self) { FXPacker *arg1 = (FXPacker *) 0 ; FXint arg2 ;
    FXint arg3 ; FXint arg4 ; FXint arg5 ; if ((argc < 4) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPacker, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    arg4 = NUM2INT(argv[2]); arg5 = NUM2INT(argv[3]); FXPacker_position(arg1,arg2,arg3,arg4,arg5); return Qnil; }
static VALUE _wrap_FXPacker_layout(int argc, VALUE *argv, VALUE self) { FXPacker *arg1 = (FXPacker *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPacker, 1); FXPacker_layout(arg1); return Qnil; }
static VALUE _wrap_FXPacker_recalc(int argc, VALUE *argv, VALUE self) { FXPacker *arg1 = (FXPacker *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPacker, 1); FXPacker_recalc(arg1); return Qnil; }
static VALUE _wrap_FXPacker_reparent(int argc, VALUE *argv, VALUE self) { FXPacker *arg1 = (FXPacker *) 0 ;
    FXComposite *arg2 = (FXComposite *) 0 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPacker, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXComposite, 1); FXPacker_reparent(arg1,arg2); return Qnil; }
static VALUE _wrap_FXPacker_show(int argc, VALUE *argv, VALUE self) { FXPacker *arg1 = (FXPacker *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPacker, 1); FXPacker_show(arg1); return Qnil; }
static VALUE _wrap_FXPacker_hide(int argc, VALUE *argv, VALUE self) { FXPacker *arg1 = (FXPacker *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPacker, 1); FXPacker_hide(arg1); return Qnil; }
static VALUE _wrap_FXPacker_isComposite(int argc, VALUE *argv, VALUE self) { FXPacker *arg1 = (FXPacker *) 0 ; FXbool result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPacker, 1);
    result = (FXbool)FXPacker_isComposite((FXPacker const *)arg1); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXPacker_contains(int argc, VALUE *argv, VALUE self) { FXPacker *arg1 = (FXPacker *) 0 ; FXint arg2 ;
    FXint arg3 ; FXbool result; VALUE vresult = Qnil; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPacker, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    result = (FXbool)FXPacker_contains((FXPacker const *)arg1,arg2,arg3); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXPacker_doesSaveUnder(int argc, VALUE *argv, VALUE self) { FXPacker *arg1 = (FXPacker *) 0 ; FXbool result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPacker, 1);
    result = (FXbool)FXPacker_doesSaveUnder((FXPacker const *)arg1); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXPacker_setBackColor(int argc, VALUE *argv, VALUE self) { FXPacker *arg1 = (FXPacker *) 0 ; FXColor arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXPacker, 1); arg2 = to_FXColor(argv[0]);
    FXPacker_setBackColor(arg1,arg2); return Qnil; }
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE _wrap_FXSpring_allocate(VALUE self) {
#else
     static VALUE _wrap_FXSpring_allocate(int argc, VALUE *argv, VALUE self) {
#endif
         VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_FXSpring);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
         return vresult; }
static VALUE _wrap_new_FXSpring(int argc, VALUE *argv, VALUE self) { FXComposite *arg1 = (FXComposite *) 0 ;
    FXuint arg2 = (FXuint) 0 ; FXint arg3 = (FXint) 0 ; FXint arg4 = (FXint) 0 ; FXint arg5 = (FXint) 0 ;
    FXint arg6 = (FXint) 0 ; FXint arg7 = (FXint) 0 ; FXint arg8 = (FXint) 0 ; FXint arg9 = (FXint) DEFAULT_SPACING ;
    FXint arg10 = (FXint) DEFAULT_SPACING ; FXint arg11 = (FXint) DEFAULT_SPACING ; FXint arg12 = (FXint) DEFAULT_SPACING ;
    FXint arg13 = (FXint) DEFAULT_SPACING ; FXint arg14 = (FXint) DEFAULT_SPACING ; FXSpring *result;
    if ((argc < 1) || (argc > 14)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXComposite, 1); if (argc > 1) { arg2 = NUM2UINT(argv[1]); } 
    if (argc > 2) { arg3 = NUM2INT(argv[2]); }  if (argc > 3) { arg4 = NUM2INT(argv[3]); }  if (argc > 4) {
        arg5 = NUM2INT(argv[4]); }  if (argc > 5) { arg6 = NUM2INT(argv[5]); }  if (argc > 6) { arg7 = NUM2INT(argv[6]); } 
    if (argc > 7) { arg8 = NUM2INT(argv[7]); }  if (argc > 8) { arg9 = NUM2INT(argv[8]); }  if (argc > 9) {
        arg10 = NUM2INT(argv[9]); }  if (argc > 10) { arg11 = NUM2INT(argv[10]); }  if (argc > 11) { arg12 = NUM2INT(argv[11]); }
     if (argc > 12) { arg13 = NUM2INT(argv[12]); }  if (argc > 13) { arg14 = NUM2INT(argv[13]); }  {
        result = (FXSpring *)new_FXSpring(arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8,arg9,arg10,arg11,arg12,arg13,arg14);
        DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result); if(rb_block_given_p()){ rb_yield(self); }  }  return self; }
static VALUE _wrap_FXSpring_setRelativeWidth(int argc, VALUE *argv, VALUE self) { FXSpring *arg1 = (FXSpring *) 0 ; FXint arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSpring, 1); arg2 = NUM2INT(argv[0]); (arg1)->setRelativeWidth(arg2);
    return Qnil; }
static VALUE _wrap_FXSpring_getRelativeWidth(int argc, VALUE *argv, VALUE self) { FXSpring *arg1 = (FXSpring *) 0 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSpring, 1);
    result = (FXint)((FXSpring const *)arg1)->getRelativeWidth(); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXSpring_setRelativeHeight(int argc, VALUE *argv, VALUE self) { FXSpring *arg1 = (FXSpring *) 0 ;
    FXint arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSpring, 1); arg2 = NUM2INT(argv[0]); (arg1)->setRelativeHeight(arg2);
    return Qnil; }
static VALUE _wrap_FXSpring_getRelativeHeight(int argc, VALUE *argv, VALUE self) { FXSpring *arg1 = (FXSpring *) 0 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSpring, 1);
    result = (FXint)((FXSpring const *)arg1)->getRelativeHeight(); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXSpring_save(int argc, VALUE *argv, VALUE self) { FXSpring *arg1 = (FXSpring *) 0 ; FXStream *arg2 = 0 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSpring, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXSpring_save((FXSpring const *)arg1,*arg2); return Qnil; }
static VALUE _wrap_FXSpring_load(int argc, VALUE *argv, VALUE self) { FXSpring *arg1 = (FXSpring *) 0 ; FXStream *arg2 = 0 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSpring, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXSpring_load(arg1,*arg2); return Qnil; }
static VALUE _wrap_FXSpring_create(int argc, VALUE *argv, VALUE self) { FXSpring *arg1 = (FXSpring *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSpring, 1); FXSpring_create(arg1); return Qnil; }
static VALUE _wrap_FXSpring_detach(int argc, VALUE *argv, VALUE self) { FXSpring *arg1 = (FXSpring *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSpring, 1); FXSpring_detach(arg1); return Qnil; }
static VALUE _wrap_FXSpring_destroy(int argc, VALUE *argv, VALUE self) { FXSpring *arg1 = (FXSpring *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSpring, 1); FXSpring_destroy(arg1); return Qnil; }
static VALUE _wrap_FXSpring_resize(int argc, VALUE *argv, VALUE self) { FXSpring *arg1 = (FXSpring *) 0 ; FXint arg2 ;
    FXint arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSpring, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    FXSpring_resize(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXSpring_getDefaultWidth(int argc, VALUE *argv, VALUE self) { FXSpring *arg1 = (FXSpring *) 0 ; FXint result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSpring, 1); result = (FXint)FXSpring_getDefaultWidth(arg1);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXSpring_getDefaultHeight(int argc, VALUE *argv, VALUE self) { FXSpring *arg1 = (FXSpring *) 0 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSpring, 1); result = (FXint)FXSpring_getDefaultHeight(arg1);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXSpring_getWidthForHeight(int argc, VALUE *argv, VALUE self) { FXSpring *arg1 = (FXSpring *) 0 ;
    FXint arg2 ; FXint result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSpring, 1); arg2 = NUM2INT(argv[0]);
    result = (FXint)FXSpring_getWidthForHeight(arg1,arg2); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXSpring_getHeightForWidth(int argc, VALUE *argv, VALUE self) { FXSpring *arg1 = (FXSpring *) 0 ;
    FXint arg2 ; FXint result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSpring, 1); arg2 = NUM2INT(argv[0]);
    result = (FXint)FXSpring_getHeightForWidth(arg1,arg2); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXSpring_canFocus(int argc, VALUE *argv, VALUE self) { FXSpring *arg1 = (FXSpring *) 0 ; FXbool result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSpring, 1); result = (FXbool)FXSpring_canFocus((FXSpring const *)arg1);
    vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXSpring_setFocus(int argc, VALUE *argv, VALUE self) { FXSpring *arg1 = (FXSpring *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSpring, 1); FXSpring_setFocus(arg1); return Qnil; }
static VALUE _wrap_FXSpring_killFocus(int argc, VALUE *argv, VALUE self) { FXSpring *arg1 = (FXSpring *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSpring, 1); FXSpring_killFocus(arg1); return Qnil; }
static VALUE _wrap_FXSpring_setDefault(int argc, VALUE *argv, VALUE self) { FXSpring *arg1 = (FXSpring *) 0 ;
    FXbool arg2 = (FXbool) 1 ; if ((argc < 0) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSpring, 1); if (argc > 0) { arg2 = to_FXbool(argv[0]); } 
    FXSpring_setDefault(arg1,arg2); return Qnil; }
static VALUE _wrap_FXSpring_enable(int argc, VALUE *argv, VALUE self) { FXSpring *arg1 = (FXSpring *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSpring, 1); FXSpring_enable(arg1); return Qnil; }
static VALUE _wrap_FXSpring_disable(int argc, VALUE *argv, VALUE self) { FXSpring *arg1 = (FXSpring *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSpring, 1); FXSpring_disable(arg1); return Qnil; }
static VALUE _wrap_FXSpring_raiseWindow(int argc, VALUE *argv, VALUE self) { FXSpring *arg1 = (FXSpring *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSpring, 1); FXSpring_raise(arg1); return Qnil; }
static VALUE _wrap_FXSpring_lower(int argc, VALUE *argv, VALUE self) { FXSpring *arg1 = (FXSpring *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSpring, 1); FXSpring_lower(arg1); return Qnil; }
static VALUE _wrap_FXSpring_move(int argc, VALUE *argv, VALUE self) { FXSpring *arg1 = (FXSpring *) 0 ; FXint arg2 ;
    FXint arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSpring, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    FXSpring_move(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXSpring_position(int argc, VALUE *argv, VALUE self) { FXSpring *arg1 = (FXSpring *) 0 ; FXint arg2 ;
    FXint arg3 ; FXint arg4 ; FXint arg5 ; if ((argc < 4) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSpring, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    arg4 = NUM2INT(argv[2]); arg5 = NUM2INT(argv[3]); FXSpring_position(arg1,arg2,arg3,arg4,arg5); return Qnil; }
static VALUE _wrap_FXSpring_layout(int argc, VALUE *argv, VALUE self) { FXSpring *arg1 = (FXSpring *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSpring, 1); FXSpring_layout(arg1); return Qnil; }
static VALUE _wrap_FXSpring_recalc(int argc, VALUE *argv, VALUE self) { FXSpring *arg1 = (FXSpring *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSpring, 1); FXSpring_recalc(arg1); return Qnil; }
static VALUE _wrap_FXSpring_reparent(int argc, VALUE *argv, VALUE self) { FXSpring *arg1 = (FXSpring *) 0 ;
    FXComposite *arg2 = (FXComposite *) 0 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSpring, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXComposite, 1); FXSpring_reparent(arg1,arg2); return Qnil; }
static VALUE _wrap_FXSpring_show(int argc, VALUE *argv, VALUE self) { FXSpring *arg1 = (FXSpring *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSpring, 1); FXSpring_show(arg1); return Qnil; }
static VALUE _wrap_FXSpring_hide(int argc, VALUE *argv, VALUE self) { FXSpring *arg1 = (FXSpring *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSpring, 1); FXSpring_hide(arg1); return Qnil; }
static VALUE _wrap_FXSpring_isComposite(int argc, VALUE *argv, VALUE self) { FXSpring *arg1 = (FXSpring *) 0 ; FXbool result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSpring, 1);
    result = (FXbool)FXSpring_isComposite((FXSpring const *)arg1); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXSpring_contains(int argc, VALUE *argv, VALUE self) { FXSpring *arg1 = (FXSpring *) 0 ; FXint arg2 ;
    FXint arg3 ; FXbool result; VALUE vresult = Qnil; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSpring, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    result = (FXbool)FXSpring_contains((FXSpring const *)arg1,arg2,arg3); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXSpring_doesSaveUnder(int argc, VALUE *argv, VALUE self) { FXSpring *arg1 = (FXSpring *) 0 ; FXbool result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSpring, 1);
    result = (FXbool)FXSpring_doesSaveUnder((FXSpring const *)arg1); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXSpring_setBackColor(int argc, VALUE *argv, VALUE self) { FXSpring *arg1 = (FXSpring *) 0 ; FXColor arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSpring, 1); arg2 = to_FXColor(argv[0]);
    FXSpring_setBackColor(arg1,arg2); return Qnil; }
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE _wrap_FXHorizontalFrame_allocate(VALUE self) {
#else
     static VALUE _wrap_FXHorizontalFrame_allocate(int argc, VALUE *argv, VALUE self) {
#endif
         VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_FXHorizontalFrame);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
         return vresult; }
static VALUE _wrap_new_FXHorizontalFrame(int argc, VALUE *argv, VALUE self) { FXComposite *arg1 = (FXComposite *) 0 ;
    FXuint arg2 = (FXuint) 0 ; FXint arg3 = (FXint) 0 ; FXint arg4 = (FXint) 0 ; FXint arg5 = (FXint) 0 ;
    FXint arg6 = (FXint) 0 ; FXint arg7 = (FXint) DEFAULT_SPACING ; FXint arg8 = (FXint) DEFAULT_SPACING ;
    FXint arg9 = (FXint) DEFAULT_SPACING ; FXint arg10 = (FXint) DEFAULT_SPACING ; FXint arg11 = (FXint) DEFAULT_SPACING ;
    FXint arg12 = (FXint) DEFAULT_SPACING ; FXHorizontalFrame *result; if ((argc < 1) || (argc > 12))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXComposite, 1); if (argc > 1) { arg2 = NUM2UINT(argv[1]); } 
    if (argc > 2) { arg3 = NUM2INT(argv[2]); }  if (argc > 3) { arg4 = NUM2INT(argv[3]); }  if (argc > 4) {
        arg5 = NUM2INT(argv[4]); }  if (argc > 5) { arg6 = NUM2INT(argv[5]); }  if (argc > 6) { arg7 = NUM2INT(argv[6]); } 
    if (argc > 7) { arg8 = NUM2INT(argv[7]); }  if (argc > 8) { arg9 = NUM2INT(argv[8]); }  if (argc > 9) {
        arg10 = NUM2INT(argv[9]); }  if (argc > 10) { arg11 = NUM2INT(argv[10]); }  if (argc > 11) { arg12 = NUM2INT(argv[11]); }
     { result = (FXHorizontalFrame *)new_FXHorizontalFrame(arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8,arg9,arg10,arg11,arg12);
        DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result); if(rb_block_given_p()){ rb_yield(self); }  }  return self; }
static VALUE _wrap_FXHorizontalFrame_save(int argc, VALUE *argv, VALUE self) {
    FXHorizontalFrame *arg1 = (FXHorizontalFrame *) 0 ; FXStream *arg2 = 0 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXHorizontalFrame, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXHorizontalFrame_save((FXHorizontalFrame const *)arg1,*arg2); return Qnil; }
static VALUE _wrap_FXHorizontalFrame_load(int argc, VALUE *argv, VALUE self) {
    FXHorizontalFrame *arg1 = (FXHorizontalFrame *) 0 ; FXStream *arg2 = 0 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXHorizontalFrame, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXHorizontalFrame_load(arg1,*arg2); return Qnil; }
static VALUE _wrap_FXHorizontalFrame_create(int argc, VALUE *argv, VALUE self) {
    FXHorizontalFrame *arg1 = (FXHorizontalFrame *) 0 ; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXHorizontalFrame, 1); FXHorizontalFrame_create(arg1); return Qnil; }
static VALUE _wrap_FXHorizontalFrame_detach(int argc, VALUE *argv, VALUE self) {
    FXHorizontalFrame *arg1 = (FXHorizontalFrame *) 0 ; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXHorizontalFrame, 1); FXHorizontalFrame_detach(arg1); return Qnil; }
static VALUE _wrap_FXHorizontalFrame_destroy(int argc, VALUE *argv, VALUE self) {
    FXHorizontalFrame *arg1 = (FXHorizontalFrame *) 0 ; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXHorizontalFrame, 1); FXHorizontalFrame_destroy(arg1); return Qnil; }
static VALUE _wrap_FXHorizontalFrame_resize(int argc, VALUE *argv, VALUE self) {
    FXHorizontalFrame *arg1 = (FXHorizontalFrame *) 0 ; FXint arg2 ; FXint arg3 ; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXHorizontalFrame, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    FXHorizontalFrame_resize(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXHorizontalFrame_getDefaultWidth(int argc, VALUE *argv, VALUE self) {
    FXHorizontalFrame *arg1 = (FXHorizontalFrame *) 0 ; FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXHorizontalFrame, 1);
    result = (FXint)FXHorizontalFrame_getDefaultWidth(arg1); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXHorizontalFrame_getDefaultHeight(int argc, VALUE *argv, VALUE self) {
    FXHorizontalFrame *arg1 = (FXHorizontalFrame *) 0 ; FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXHorizontalFrame, 1);
    result = (FXint)FXHorizontalFrame_getDefaultHeight(arg1); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXHorizontalFrame_getWidthForHeight(int argc, VALUE *argv, VALUE self) {
    FXHorizontalFrame *arg1 = (FXHorizontalFrame *) 0 ; FXint arg2 ; FXint result; VALUE vresult = Qnil;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXHorizontalFrame, 1); arg2 = NUM2INT(argv[0]);
    result = (FXint)FXHorizontalFrame_getWidthForHeight(arg1,arg2); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXHorizontalFrame_getHeightForWidth(int argc, VALUE *argv, VALUE self) {
    FXHorizontalFrame *arg1 = (FXHorizontalFrame *) 0 ; FXint arg2 ; FXint result; VALUE vresult = Qnil;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXHorizontalFrame, 1); arg2 = NUM2INT(argv[0]);
    result = (FXint)FXHorizontalFrame_getHeightForWidth(arg1,arg2); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXHorizontalFrame_canFocus(int argc, VALUE *argv, VALUE self) {
    FXHorizontalFrame *arg1 = (FXHorizontalFrame *) 0 ; FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXHorizontalFrame, 1);
    result = (FXbool)FXHorizontalFrame_canFocus((FXHorizontalFrame const *)arg1); vresult = result ? Qtrue : Qfalse;
    return vresult; }
static VALUE _wrap_FXHorizontalFrame_setFocus(int argc, VALUE *argv, VALUE self) {
    FXHorizontalFrame *arg1 = (FXHorizontalFrame *) 0 ; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXHorizontalFrame, 1); FXHorizontalFrame_setFocus(arg1); return Qnil; }
static VALUE _wrap_FXHorizontalFrame_killFocus(int argc, VALUE *argv, VALUE self) {
    FXHorizontalFrame *arg1 = (FXHorizontalFrame *) 0 ; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXHorizontalFrame, 1); FXHorizontalFrame_killFocus(arg1); return Qnil; }
static VALUE _wrap_FXHorizontalFrame_setDefault(int argc, VALUE *argv, VALUE self) {
    FXHorizontalFrame *arg1 = (FXHorizontalFrame *) 0 ; FXbool arg2 = (FXbool) 1 ; if ((argc < 0) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXHorizontalFrame, 1); if (argc > 0) { arg2 = to_FXbool(argv[0]); } 
    FXHorizontalFrame_setDefault(arg1,arg2); return Qnil; }
static VALUE _wrap_FXHorizontalFrame_enable(int argc, VALUE *argv, VALUE self) {
    FXHorizontalFrame *arg1 = (FXHorizontalFrame *) 0 ; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXHorizontalFrame, 1); FXHorizontalFrame_enable(arg1); return Qnil; }
static VALUE _wrap_FXHorizontalFrame_disable(int argc, VALUE *argv, VALUE self) {
    FXHorizontalFrame *arg1 = (FXHorizontalFrame *) 0 ; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXHorizontalFrame, 1); FXHorizontalFrame_disable(arg1); return Qnil; }
static VALUE _wrap_FXHorizontalFrame_raiseWindow(int argc, VALUE *argv, VALUE self) {
    FXHorizontalFrame *arg1 = (FXHorizontalFrame *) 0 ; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXHorizontalFrame, 1); FXHorizontalFrame_raise(arg1); return Qnil; }
static VALUE _wrap_FXHorizontalFrame_lower(int argc, VALUE *argv, VALUE self) {
    FXHorizontalFrame *arg1 = (FXHorizontalFrame *) 0 ; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXHorizontalFrame, 1); FXHorizontalFrame_lower(arg1); return Qnil; }
static VALUE _wrap_FXHorizontalFrame_move(int argc, VALUE *argv, VALUE self) {
    FXHorizontalFrame *arg1 = (FXHorizontalFrame *) 0 ; FXint arg2 ; FXint arg3 ; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXHorizontalFrame, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    FXHorizontalFrame_move(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXHorizontalFrame_position(int argc, VALUE *argv, VALUE self) {
    FXHorizontalFrame *arg1 = (FXHorizontalFrame *) 0 ; FXint arg2 ; FXint arg3 ; FXint arg4 ; FXint arg5 ;
    if ((argc < 4) || (argc > 4)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXHorizontalFrame, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    arg4 = NUM2INT(argv[2]); arg5 = NUM2INT(argv[3]); FXHorizontalFrame_position(arg1,arg2,arg3,arg4,arg5); return Qnil; }
static VALUE _wrap_FXHorizontalFrame_layout(int argc, VALUE *argv, VALUE self) {
    FXHorizontalFrame *arg1 = (FXHorizontalFrame *) 0 ; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXHorizontalFrame, 1); FXHorizontalFrame_layout(arg1); return Qnil; }
static VALUE _wrap_FXHorizontalFrame_recalc(int argc, VALUE *argv, VALUE self) {
    FXHorizontalFrame *arg1 = (FXHorizontalFrame *) 0 ; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXHorizontalFrame, 1); FXHorizontalFrame_recalc(arg1); return Qnil; }
static VALUE _wrap_FXHorizontalFrame_reparent(int argc, VALUE *argv, VALUE self) {
    FXHorizontalFrame *arg1 = (FXHorizontalFrame *) 0 ; FXComposite *arg2 = (FXComposite *) 0 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXHorizontalFrame, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXComposite, 1); FXHorizontalFrame_reparent(arg1,arg2); return Qnil; }
static VALUE _wrap_FXHorizontalFrame_show(int argc, VALUE *argv, VALUE self) {
    FXHorizontalFrame *arg1 = (FXHorizontalFrame *) 0 ; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXHorizontalFrame, 1); FXHorizontalFrame_show(arg1); return Qnil; }
static VALUE _wrap_FXHorizontalFrame_hide(int argc, VALUE *argv, VALUE self) {
    FXHorizontalFrame *arg1 = (FXHorizontalFrame *) 0 ; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXHorizontalFrame, 1); FXHorizontalFrame_hide(arg1); return Qnil; }
static VALUE _wrap_FXHorizontalFrame_isComposite(int argc, VALUE *argv, VALUE self) {
    FXHorizontalFrame *arg1 = (FXHorizontalFrame *) 0 ; FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXHorizontalFrame, 1);
    result = (FXbool)FXHorizontalFrame_isComposite((FXHorizontalFrame const *)arg1); vresult = result ? Qtrue : Qfalse;
    return vresult; }
static VALUE _wrap_FXHorizontalFrame_contains(int argc, VALUE *argv, VALUE self) {
    FXHorizontalFrame *arg1 = (FXHorizontalFrame *) 0 ; FXint arg2 ; FXint arg3 ; FXbool result; VALUE vresult = Qnil;
    if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXHorizontalFrame, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    result = (FXbool)FXHorizontalFrame_contains((FXHorizontalFrame const *)arg1,arg2,arg3); vresult = result ? Qtrue : Qfalse;
    return vresult; }
static VALUE _wrap_FXHorizontalFrame_doesSaveUnder(int argc, VALUE *argv, VALUE self) {
    FXHorizontalFrame *arg1 = (FXHorizontalFrame *) 0 ; FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXHorizontalFrame, 1);
    result = (FXbool)FXHorizontalFrame_doesSaveUnder((FXHorizontalFrame const *)arg1); vresult = result ? Qtrue : Qfalse;
    return vresult; }
static VALUE _wrap_FXHorizontalFrame_setBackColor(int argc, VALUE *argv, VALUE self) {
    FXHorizontalFrame *arg1 = (FXHorizontalFrame *) 0 ; FXColor arg2 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXHorizontalFrame, 1); arg2 = to_FXColor(argv[0]);
    FXHorizontalFrame_setBackColor(arg1,arg2); return Qnil; }
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE _wrap_FXVerticalFrame_allocate(VALUE self) {
#else
     static VALUE _wrap_FXVerticalFrame_allocate(int argc, VALUE *argv, VALUE self) {
#endif
         VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_FXVerticalFrame);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
         return vresult; }
static VALUE _wrap_new_FXVerticalFrame(int argc, VALUE *argv, VALUE self) { FXComposite *arg1 = (FXComposite *) 0 ;
    FXuint arg2 = (FXuint) 0 ; FXint arg3 = (FXint) 0 ; FXint arg4 = (FXint) 0 ; FXint arg5 = (FXint) 0 ;
    FXint arg6 = (FXint) 0 ; FXint arg7 = (FXint) DEFAULT_SPACING ; FXint arg8 = (FXint) DEFAULT_SPACING ;
    FXint arg9 = (FXint) DEFAULT_SPACING ; FXint arg10 = (FXint) DEFAULT_SPACING ; FXint arg11 = (FXint) DEFAULT_SPACING ;
    FXint arg12 = (FXint) DEFAULT_SPACING ; FXVerticalFrame *result; if ((argc < 1) || (argc > 12))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXComposite, 1); if (argc > 1) { arg2 = NUM2UINT(argv[1]); } 
    if (argc > 2) { arg3 = NUM2INT(argv[2]); }  if (argc > 3) { arg4 = NUM2INT(argv[3]); }  if (argc > 4) {
        arg5 = NUM2INT(argv[4]); }  if (argc > 5) { arg6 = NUM2INT(argv[5]); }  if (argc > 6) { arg7 = NUM2INT(argv[6]); } 
    if (argc > 7) { arg8 = NUM2INT(argv[7]); }  if (argc > 8) { arg9 = NUM2INT(argv[8]); }  if (argc > 9) {
        arg10 = NUM2INT(argv[9]); }  if (argc > 10) { arg11 = NUM2INT(argv[10]); }  if (argc > 11) { arg12 = NUM2INT(argv[11]); }
     { result = (FXVerticalFrame *)new_FXVerticalFrame(arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8,arg9,arg10,arg11,arg12);
        DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result); if(rb_block_given_p()){ rb_yield(self); }  }  return self; }
static void
free_FXVerticalFrame(FXVerticalFrame *arg1) {
    delete arg1;
}
static VALUE _wrap_FXVerticalFrame_save(int argc, VALUE *argv, VALUE self) { FXVerticalFrame *arg1 = (FXVerticalFrame *) 0 ;
    FXStream *arg2 = 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXVerticalFrame, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXVerticalFrame_save((FXVerticalFrame const *)arg1,*arg2); return Qnil; }
static VALUE _wrap_FXVerticalFrame_load(int argc, VALUE *argv, VALUE self) { FXVerticalFrame *arg1 = (FXVerticalFrame *) 0 ;
    FXStream *arg2 = 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXVerticalFrame, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXVerticalFrame_load(arg1,*arg2); return Qnil; }
static VALUE _wrap_FXVerticalFrame_create(int argc, VALUE *argv, VALUE self) { FXVerticalFrame *arg1 = (FXVerticalFrame *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXVerticalFrame, 1); FXVerticalFrame_create(arg1); return Qnil; }
static VALUE _wrap_FXVerticalFrame_detach(int argc, VALUE *argv, VALUE self) { FXVerticalFrame *arg1 = (FXVerticalFrame *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXVerticalFrame, 1); FXVerticalFrame_detach(arg1); return Qnil; }
static VALUE _wrap_FXVerticalFrame_destroy(int argc, VALUE *argv, VALUE self) { FXVerticalFrame *arg1 = (FXVerticalFrame *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXVerticalFrame, 1); FXVerticalFrame_destroy(arg1); return Qnil; }
static VALUE _wrap_FXVerticalFrame_resize(int argc, VALUE *argv, VALUE self) { FXVerticalFrame *arg1 = (FXVerticalFrame *) 0 ;
    FXint arg2 ; FXint arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXVerticalFrame, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    FXVerticalFrame_resize(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXVerticalFrame_getDefaultWidth(int argc, VALUE *argv, VALUE self) {
    FXVerticalFrame *arg1 = (FXVerticalFrame *) 0 ; FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXVerticalFrame, 1);
    result = (FXint)FXVerticalFrame_getDefaultWidth(arg1); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXVerticalFrame_getDefaultHeight(int argc, VALUE *argv, VALUE self) {
    FXVerticalFrame *arg1 = (FXVerticalFrame *) 0 ; FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXVerticalFrame, 1);
    result = (FXint)FXVerticalFrame_getDefaultHeight(arg1); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXVerticalFrame_getWidthForHeight(int argc, VALUE *argv, VALUE self) {
    FXVerticalFrame *arg1 = (FXVerticalFrame *) 0 ; FXint arg2 ; FXint result; VALUE vresult = Qnil;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXVerticalFrame, 1); arg2 = NUM2INT(argv[0]);
    result = (FXint)FXVerticalFrame_getWidthForHeight(arg1,arg2); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXVerticalFrame_getHeightForWidth(int argc, VALUE *argv, VALUE self) {
    FXVerticalFrame *arg1 = (FXVerticalFrame *) 0 ; FXint arg2 ; FXint result; VALUE vresult = Qnil;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXVerticalFrame, 1); arg2 = NUM2INT(argv[0]);
    result = (FXint)FXVerticalFrame_getHeightForWidth(arg1,arg2); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXVerticalFrame_canFocus(int argc, VALUE *argv, VALUE self) { FXVerticalFrame *arg1 = (FXVerticalFrame *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXVerticalFrame, 1);
    result = (FXbool)FXVerticalFrame_canFocus((FXVerticalFrame const *)arg1); vresult = result ? Qtrue : Qfalse;
    return vresult; }
static VALUE _wrap_FXVerticalFrame_setFocus(int argc, VALUE *argv, VALUE self) { FXVerticalFrame *arg1 = (FXVerticalFrame *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXVerticalFrame, 1); FXVerticalFrame_setFocus(arg1); return Qnil; }
static VALUE _wrap_FXVerticalFrame_killFocus(int argc, VALUE *argv, VALUE self) {
    FXVerticalFrame *arg1 = (FXVerticalFrame *) 0 ; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXVerticalFrame, 1); FXVerticalFrame_killFocus(arg1); return Qnil; }
static VALUE _wrap_FXVerticalFrame_setDefault(int argc, VALUE *argv, VALUE self) {
    FXVerticalFrame *arg1 = (FXVerticalFrame *) 0 ; FXbool arg2 = (FXbool) 1 ; if ((argc < 0) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXVerticalFrame, 1); if (argc > 0) { arg2 = to_FXbool(argv[0]); } 
    FXVerticalFrame_setDefault(arg1,arg2); return Qnil; }
static VALUE _wrap_FXVerticalFrame_enable(int argc, VALUE *argv, VALUE self) { FXVerticalFrame *arg1 = (FXVerticalFrame *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXVerticalFrame, 1); FXVerticalFrame_enable(arg1); return Qnil; }
static VALUE _wrap_FXVerticalFrame_disable(int argc, VALUE *argv, VALUE self) { FXVerticalFrame *arg1 = (FXVerticalFrame *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXVerticalFrame, 1); FXVerticalFrame_disable(arg1); return Qnil; }
static VALUE _wrap_FXVerticalFrame_raiseWindow(int argc, VALUE *argv, VALUE self) {
    FXVerticalFrame *arg1 = (FXVerticalFrame *) 0 ; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXVerticalFrame, 1); FXVerticalFrame_raise(arg1); return Qnil; }
static VALUE _wrap_FXVerticalFrame_lower(int argc, VALUE *argv, VALUE self) { FXVerticalFrame *arg1 = (FXVerticalFrame *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXVerticalFrame, 1); FXVerticalFrame_lower(arg1); return Qnil; }
static VALUE _wrap_FXVerticalFrame_move(int argc, VALUE *argv, VALUE self) { FXVerticalFrame *arg1 = (FXVerticalFrame *) 0 ;
    FXint arg2 ; FXint arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXVerticalFrame, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    FXVerticalFrame_move(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXVerticalFrame_position(int argc, VALUE *argv, VALUE self) { FXVerticalFrame *arg1 = (FXVerticalFrame *) 0 ;
    FXint arg2 ; FXint arg3 ; FXint arg4 ; FXint arg5 ; if ((argc < 4) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXVerticalFrame, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    arg4 = NUM2INT(argv[2]); arg5 = NUM2INT(argv[3]); FXVerticalFrame_position(arg1,arg2,arg3,arg4,arg5); return Qnil; }
static VALUE _wrap_FXVerticalFrame_layout(int argc, VALUE *argv, VALUE self) { FXVerticalFrame *arg1 = (FXVerticalFrame *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXVerticalFrame, 1); FXVerticalFrame_layout(arg1); return Qnil; }
static VALUE _wrap_FXVerticalFrame_recalc(int argc, VALUE *argv, VALUE self) { FXVerticalFrame *arg1 = (FXVerticalFrame *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXVerticalFrame, 1); FXVerticalFrame_recalc(arg1); return Qnil; }
static VALUE _wrap_FXVerticalFrame_reparent(int argc, VALUE *argv, VALUE self) { FXVerticalFrame *arg1 = (FXVerticalFrame *) 0 ;
    FXComposite *arg2 = (FXComposite *) 0 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXVerticalFrame, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXComposite, 1); FXVerticalFrame_reparent(arg1,arg2); return Qnil; }
static VALUE _wrap_FXVerticalFrame_show(int argc, VALUE *argv, VALUE self) { FXVerticalFrame *arg1 = (FXVerticalFrame *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXVerticalFrame, 1); FXVerticalFrame_show(arg1); return Qnil; }
static VALUE _wrap_FXVerticalFrame_hide(int argc, VALUE *argv, VALUE self) { FXVerticalFrame *arg1 = (FXVerticalFrame *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXVerticalFrame, 1); FXVerticalFrame_hide(arg1); return Qnil; }
static VALUE _wrap_FXVerticalFrame_isComposite(int argc, VALUE *argv, VALUE self) {
    FXVerticalFrame *arg1 = (FXVerticalFrame *) 0 ; FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXVerticalFrame, 1);
    result = (FXbool)FXVerticalFrame_isComposite((FXVerticalFrame const *)arg1); vresult = result ? Qtrue : Qfalse;
    return vresult; }
static VALUE _wrap_FXVerticalFrame_contains(int argc, VALUE *argv, VALUE self) { FXVerticalFrame *arg1 = (FXVerticalFrame *) 0 ;
    FXint arg2 ; FXint arg3 ; FXbool result; VALUE vresult = Qnil; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXVerticalFrame, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    result = (FXbool)FXVerticalFrame_contains((FXVerticalFrame const *)arg1,arg2,arg3); vresult = result ? Qtrue : Qfalse;
    return vresult; }
static VALUE _wrap_FXVerticalFrame_doesSaveUnder(int argc, VALUE *argv, VALUE self) {
    FXVerticalFrame *arg1 = (FXVerticalFrame *) 0 ; FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXVerticalFrame, 1);
    result = (FXbool)FXVerticalFrame_doesSaveUnder((FXVerticalFrame const *)arg1); vresult = result ? Qtrue : Qfalse;
    return vresult; }
static VALUE _wrap_FXVerticalFrame_setBackColor(int argc, VALUE *argv, VALUE self) {
    FXVerticalFrame *arg1 = (FXVerticalFrame *) 0 ; FXColor arg2 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXVerticalFrame, 1); arg2 = to_FXColor(argv[0]);
    FXVerticalFrame_setBackColor(arg1,arg2); return Qnil; }
static VALUE _wrap_FXMatrix_onFocusUp(int argc, VALUE *argv, VALUE self) { FXMatrix *arg1 = (FXMatrix *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMatrix, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onFocusUp(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXMatrix_onFocusDown(int argc, VALUE *argv, VALUE self) { FXMatrix *arg1 = (FXMatrix *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMatrix, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onFocusDown(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXMatrix_onFocusLeft(int argc, VALUE *argv, VALUE self) { FXMatrix *arg1 = (FXMatrix *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMatrix, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onFocusLeft(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXMatrix_onFocusRight(int argc, VALUE *argv, VALUE self) { FXMatrix *arg1 = (FXMatrix *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMatrix, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onFocusRight(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE _wrap_FXMatrix_allocate(VALUE self) {
#else
     static VALUE _wrap_FXMatrix_allocate(int argc, VALUE *argv, VALUE self) {
#endif
         VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_FXMatrix);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
         return vresult; }
static VALUE _wrap_new_FXMatrix(int argc, VALUE *argv, VALUE self) { FXComposite *arg1 = (FXComposite *) 0 ;
    FXint arg2 = (FXint) 1 ; FXuint arg3 = (FXuint) MATRIX_BY_ROWS ; FXint arg4 = (FXint) 0 ; FXint arg5 = (FXint) 0 ;
    FXint arg6 = (FXint) 0 ; FXint arg7 = (FXint) 0 ; FXint arg8 = (FXint) DEFAULT_SPACING ;
    FXint arg9 = (FXint) DEFAULT_SPACING ; FXint arg10 = (FXint) DEFAULT_SPACING ; FXint arg11 = (FXint) DEFAULT_SPACING ;
    FXint arg12 = (FXint) DEFAULT_SPACING ; FXint arg13 = (FXint) DEFAULT_SPACING ; FXMatrix *result;
    if ((argc < 1) || (argc > 13)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXComposite, 1); if (argc > 1) { arg2 = NUM2INT(argv[1]); } 
    if (argc > 2) { arg3 = NUM2UINT(argv[2]); }  if (argc > 3) { arg4 = NUM2INT(argv[3]); }  if (argc > 4) {
        arg5 = NUM2INT(argv[4]); }  if (argc > 5) { arg6 = NUM2INT(argv[5]); }  if (argc > 6) { arg7 = NUM2INT(argv[6]); } 
    if (argc > 7) { arg8 = NUM2INT(argv[7]); }  if (argc > 8) { arg9 = NUM2INT(argv[8]); }  if (argc > 9) {
        arg10 = NUM2INT(argv[9]); }  if (argc > 10) { arg11 = NUM2INT(argv[10]); }  if (argc > 11) { arg12 = NUM2INT(argv[11]); }
     if (argc > 12) { arg13 = NUM2INT(argv[12]); }  {
        result = (FXMatrix *)new_FXMatrix(arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8,arg9,arg10,arg11,arg12,arg13);
        DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result); if(rb_block_given_p()){ rb_yield(self); }  }  return self; }
static VALUE _wrap_FXMatrix_childAtRowCol(int argc, VALUE *argv, VALUE self) { FXMatrix *arg1 = (FXMatrix *) 0 ; FXint arg2 ;
    FXint arg3 ; FXWindow *result; VALUE vresult = Qnil; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMatrix, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    result = (FXWindow *)((FXMatrix const *)arg1)->childAtRowCol(arg2,arg3); {
        swig_type_info *ty = SWIG_TypeDynamicCast(SWIGTYPE_p_FXWindow, (void **) &result);
        vresult = FXRbGetRubyObj(result, ty); }  return vresult; }
static VALUE _wrap_FXMatrix_rowOfChild(int argc, VALUE *argv, VALUE self) { FXMatrix *arg1 = (FXMatrix *) 0 ;
    FXWindow *arg2 = (FXWindow *) 0 ; FXint result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMatrix, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXWindow, 1);
    result = (FXint)((FXMatrix const *)arg1)->rowOfChild((FXWindow const *)arg2); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXMatrix_colOfChild(int argc, VALUE *argv, VALUE self) { FXMatrix *arg1 = (FXMatrix *) 0 ;
    FXWindow *arg2 = (FXWindow *) 0 ; FXint result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMatrix, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXWindow, 1);
    result = (FXint)((FXMatrix const *)arg1)->colOfChild((FXWindow const *)arg2); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXMatrix_setMatrixStyle(int argc, VALUE *argv, VALUE self) { FXMatrix *arg1 = (FXMatrix *) 0 ; FXuint arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMatrix, 1); arg2 = NUM2UINT(argv[0]); (arg1)->setMatrixStyle(arg2);
    return Qnil; }
static VALUE _wrap_FXMatrix_getMatrixStyle(int argc, VALUE *argv, VALUE self) { FXMatrix *arg1 = (FXMatrix *) 0 ; FXuint result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMatrix, 1); result = (FXuint)((FXMatrix const *)arg1)->getMatrixStyle();
    vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXMatrix_setNumRows(int argc, VALUE *argv, VALUE self) { FXMatrix *arg1 = (FXMatrix *) 0 ; FXint arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMatrix, 1); arg2 = NUM2INT(argv[0]); (arg1)->setNumRows(arg2);
    return Qnil; }
static VALUE _wrap_FXMatrix_getNumRows(int argc, VALUE *argv, VALUE self) { FXMatrix *arg1 = (FXMatrix *) 0 ; FXint result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMatrix, 1); result = (FXint)((FXMatrix const *)arg1)->getNumRows();
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXMatrix_setNumColumns(int argc, VALUE *argv, VALUE self) { FXMatrix *arg1 = (FXMatrix *) 0 ; FXint arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMatrix, 1); arg2 = NUM2INT(argv[0]); (arg1)->setNumColumns(arg2);
    return Qnil; }
static VALUE _wrap_FXMatrix_getNumColumns(int argc, VALUE *argv, VALUE self) { FXMatrix *arg1 = (FXMatrix *) 0 ; FXint result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMatrix, 1); result = (FXint)((FXMatrix const *)arg1)->getNumColumns();
    vresult = INT2NUM(result); return vresult; }
static void
free_FXMatrix(FXMatrix *arg1) {
    delete arg1;
}
static VALUE _wrap_FXMatrix_save(int argc, VALUE *argv, VALUE self) { FXMatrix *arg1 = (FXMatrix *) 0 ; FXStream *arg2 = 0 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMatrix, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXMatrix_save((FXMatrix const *)arg1,*arg2); return Qnil; }
static VALUE _wrap_FXMatrix_load(int argc, VALUE *argv, VALUE self) { FXMatrix *arg1 = (FXMatrix *) 0 ; FXStream *arg2 = 0 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMatrix, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXMatrix_load(arg1,*arg2); return Qnil; }
static VALUE _wrap_FXMatrix_create(int argc, VALUE *argv, VALUE self) { FXMatrix *arg1 = (FXMatrix *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMatrix, 1); FXMatrix_create(arg1); return Qnil; }
static VALUE _wrap_FXMatrix_detach(int argc, VALUE *argv, VALUE self) { FXMatrix *arg1 = (FXMatrix *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMatrix, 1); FXMatrix_detach(arg1); return Qnil; }
static VALUE _wrap_FXMatrix_destroy(int argc, VALUE *argv, VALUE self) { FXMatrix *arg1 = (FXMatrix *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMatrix, 1); FXMatrix_destroy(arg1); return Qnil; }
static VALUE _wrap_FXMatrix_resize(int argc, VALUE *argv, VALUE self) { FXMatrix *arg1 = (FXMatrix *) 0 ; FXint arg2 ;
    FXint arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMatrix, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    FXMatrix_resize(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXMatrix_getDefaultWidth(int argc, VALUE *argv, VALUE self) { FXMatrix *arg1 = (FXMatrix *) 0 ; FXint result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMatrix, 1); result = (FXint)FXMatrix_getDefaultWidth(arg1);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXMatrix_getDefaultHeight(int argc, VALUE *argv, VALUE self) { FXMatrix *arg1 = (FXMatrix *) 0 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMatrix, 1); result = (FXint)FXMatrix_getDefaultHeight(arg1);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXMatrix_getWidthForHeight(int argc, VALUE *argv, VALUE self) { FXMatrix *arg1 = (FXMatrix *) 0 ;
    FXint arg2 ; FXint result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMatrix, 1); arg2 = NUM2INT(argv[0]);
    result = (FXint)FXMatrix_getWidthForHeight(arg1,arg2); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXMatrix_getHeightForWidth(int argc, VALUE *argv, VALUE self) { FXMatrix *arg1 = (FXMatrix *) 0 ;
    FXint arg2 ; FXint result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMatrix, 1); arg2 = NUM2INT(argv[0]);
    result = (FXint)FXMatrix_getHeightForWidth(arg1,arg2); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXMatrix_canFocus(int argc, VALUE *argv, VALUE self) { FXMatrix *arg1 = (FXMatrix *) 0 ; FXbool result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMatrix, 1); result = (FXbool)FXMatrix_canFocus((FXMatrix const *)arg1);
    vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXMatrix_setFocus(int argc, VALUE *argv, VALUE self) { FXMatrix *arg1 = (FXMatrix *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMatrix, 1); FXMatrix_setFocus(arg1); return Qnil; }
static VALUE _wrap_FXMatrix_killFocus(int argc, VALUE *argv, VALUE self) { FXMatrix *arg1 = (FXMatrix *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMatrix, 1); FXMatrix_killFocus(arg1); return Qnil; }
static VALUE _wrap_FXMatrix_setDefault(int argc, VALUE *argv, VALUE self) { FXMatrix *arg1 = (FXMatrix *) 0 ;
    FXbool arg2 = (FXbool) 1 ; if ((argc < 0) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMatrix, 1); if (argc > 0) { arg2 = to_FXbool(argv[0]); } 
    FXMatrix_setDefault(arg1,arg2); return Qnil; }
static VALUE _wrap_FXMatrix_enable(int argc, VALUE *argv, VALUE self) { FXMatrix *arg1 = (FXMatrix *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMatrix, 1); FXMatrix_enable(arg1); return Qnil; }
static VALUE _wrap_FXMatrix_disable(int argc, VALUE *argv, VALUE self) { FXMatrix *arg1 = (FXMatrix *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMatrix, 1); FXMatrix_disable(arg1); return Qnil; }
static VALUE _wrap_FXMatrix_raiseWindow(int argc, VALUE *argv, VALUE self) { FXMatrix *arg1 = (FXMatrix *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMatrix, 1); FXMatrix_raise(arg1); return Qnil; }
static VALUE _wrap_FXMatrix_lower(int argc, VALUE *argv, VALUE self) { FXMatrix *arg1 = (FXMatrix *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMatrix, 1); FXMatrix_lower(arg1); return Qnil; }
static VALUE _wrap_FXMatrix_move(int argc, VALUE *argv, VALUE self) { FXMatrix *arg1 = (FXMatrix *) 0 ; FXint arg2 ;
    FXint arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMatrix, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    FXMatrix_move(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXMatrix_position(int argc, VALUE *argv, VALUE self) { FXMatrix *arg1 = (FXMatrix *) 0 ; FXint arg2 ;
    FXint arg3 ; FXint arg4 ; FXint arg5 ; if ((argc < 4) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMatrix, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    arg4 = NUM2INT(argv[2]); arg5 = NUM2INT(argv[3]); FXMatrix_position(arg1,arg2,arg3,arg4,arg5); return Qnil; }
static VALUE _wrap_FXMatrix_layout(int argc, VALUE *argv, VALUE self) { FXMatrix *arg1 = (FXMatrix *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMatrix, 1); FXMatrix_layout(arg1); return Qnil; }
static VALUE _wrap_FXMatrix_recalc(int argc, VALUE *argv, VALUE self) { FXMatrix *arg1 = (FXMatrix *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMatrix, 1); FXMatrix_recalc(arg1); return Qnil; }
static VALUE _wrap_FXMatrix_reparent(int argc, VALUE *argv, VALUE self) { FXMatrix *arg1 = (FXMatrix *) 0 ;
    FXComposite *arg2 = (FXComposite *) 0 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMatrix, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXComposite, 1); FXMatrix_reparent(arg1,arg2); return Qnil; }
static VALUE _wrap_FXMatrix_show(int argc, VALUE *argv, VALUE self) { FXMatrix *arg1 = (FXMatrix *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMatrix, 1); FXMatrix_show(arg1); return Qnil; }
static VALUE _wrap_FXMatrix_hide(int argc, VALUE *argv, VALUE self) { FXMatrix *arg1 = (FXMatrix *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMatrix, 1); FXMatrix_hide(arg1); return Qnil; }
static VALUE _wrap_FXMatrix_isComposite(int argc, VALUE *argv, VALUE self) { FXMatrix *arg1 = (FXMatrix *) 0 ; FXbool result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMatrix, 1);
    result = (FXbool)FXMatrix_isComposite((FXMatrix const *)arg1); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXMatrix_contains(int argc, VALUE *argv, VALUE self) { FXMatrix *arg1 = (FXMatrix *) 0 ; FXint arg2 ;
    FXint arg3 ; FXbool result; VALUE vresult = Qnil; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMatrix, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    result = (FXbool)FXMatrix_contains((FXMatrix const *)arg1,arg2,arg3); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXMatrix_doesSaveUnder(int argc, VALUE *argv, VALUE self) { FXMatrix *arg1 = (FXMatrix *) 0 ; FXbool result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMatrix, 1);
    result = (FXbool)FXMatrix_doesSaveUnder((FXMatrix const *)arg1); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXMatrix_setBackColor(int argc, VALUE *argv, VALUE self) { FXMatrix *arg1 = (FXMatrix *) 0 ; FXColor arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMatrix, 1); arg2 = to_FXColor(argv[0]);
    FXMatrix_setBackColor(arg1,arg2); return Qnil; }
static VALUE _wrap_FXGroupBox_onPaint(int argc, VALUE *argv, VALUE self) { FXGroupBox *arg1 = (FXGroupBox *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGroupBox, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onPaint(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE _wrap_FXGroupBox_allocate(VALUE self) {
#else
     static VALUE _wrap_FXGroupBox_allocate(int argc, VALUE *argv, VALUE self) {
#endif
         VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_FXGroupBox);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
         return vresult; }
static VALUE _wrap_new_FXGroupBox(int argc, VALUE *argv, VALUE self) { FXComposite *arg1 = (FXComposite *) 0 ;
    FXString *arg2 = 0 ; FXuint arg3 = (FXuint) GROUPBOX_NORMAL ; FXint arg4 = (FXint) 0 ; FXint arg5 = (FXint) 0 ;
    FXint arg6 = (FXint) 0 ; FXint arg7 = (FXint) 0 ; FXint arg8 = (FXint) DEFAULT_SPACING ;
    FXint arg9 = (FXint) DEFAULT_SPACING ; FXint arg10 = (FXint) DEFAULT_SPACING ; FXint arg11 = (FXint) DEFAULT_SPACING ;
    FXint arg12 = (FXint) DEFAULT_SPACING ; FXint arg13 = (FXint) DEFAULT_SPACING ; FXGroupBox *result;
    SwigValueWrapper<FXString > p2 ; if ((argc < 2) || (argc > 13))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXComposite, 1); p2 = to_FXString(argv[1]); arg2 = &p2; if (argc > 2) {
        arg3 = NUM2UINT(argv[2]); }  if (argc > 3) { arg4 = NUM2INT(argv[3]); }  if (argc > 4) { arg5 = NUM2INT(argv[4]); } 
    if (argc > 5) { arg6 = NUM2INT(argv[5]); }  if (argc > 6) { arg7 = NUM2INT(argv[6]); }  if (argc > 7) {
        arg8 = NUM2INT(argv[7]); }  if (argc > 8) { arg9 = NUM2INT(argv[8]); }  if (argc > 9) { arg10 = NUM2INT(argv[9]); } 
    if (argc > 10) { arg11 = NUM2INT(argv[10]); }  if (argc > 11) { arg12 = NUM2INT(argv[11]); }  if (argc > 12) {
        arg13 = NUM2INT(argv[12]); }  {
        result = (FXGroupBox *)new_FXGroupBox(arg1,(FXString const &)*arg2,arg3,arg4,arg5,arg6,arg7,arg8,arg9,arg10,arg11,arg12,arg13);
        DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result); if(rb_block_given_p()){ rb_yield(self); }  }  return self; }
static VALUE _wrap_FXGroupBox_setText(int argc, VALUE *argv, VALUE self) { FXGroupBox *arg1 = (FXGroupBox *) 0 ;
    FXString *arg2 = 0 ; SwigValueWrapper<FXString > p2 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGroupBox, 1); p2 = to_FXString(argv[0]); arg2 = &p2;
    (arg1)->setText((FXString const &)*arg2); return Qnil; }
static VALUE _wrap_FXGroupBox_getText(int argc, VALUE *argv, VALUE self) { FXGroupBox *arg1 = (FXGroupBox *) 0 ;
    FXString result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGroupBox, 1); result = ((FXGroupBox const *)arg1)->getText();
    vresult = rb_str_new2((&result)->text()); return vresult; }
static VALUE _wrap_FXGroupBox_setGroupBoxStyle(int argc, VALUE *argv, VALUE self) { FXGroupBox *arg1 = (FXGroupBox *) 0 ;
    FXuint arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGroupBox, 1); arg2 = NUM2UINT(argv[0]); (arg1)->setGroupBoxStyle(arg2);
    return Qnil; }
static VALUE _wrap_FXGroupBox_getGroupBoxStyle(int argc, VALUE *argv, VALUE self) { FXGroupBox *arg1 = (FXGroupBox *) 0 ;
    FXuint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGroupBox, 1);
    result = (FXuint)((FXGroupBox const *)arg1)->getGroupBoxStyle(); vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXGroupBox_setFont(int argc, VALUE *argv, VALUE self) { FXGroupBox *arg1 = (FXGroupBox *) 0 ;
    FXFont *arg2 = (FXFont *) 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGroupBox, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXFont, 1); (arg1)->setFont(arg2); return Qnil; }
static VALUE _wrap_FXGroupBox_getFont(int argc, VALUE *argv, VALUE self) { FXGroupBox *arg1 = (FXGroupBox *) 0 ; FXFont *result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGroupBox, 1); result = (FXFont *)((FXGroupBox const *)arg1)->getFont();
    { swig_type_info *ty = SWIG_TypeDynamicCast(SWIGTYPE_p_FXFont, (void **) &result); vresult = FXRbGetRubyObj(result, ty); } 
    return vresult; }
static VALUE _wrap_FXGroupBox_setTextColor(int argc, VALUE *argv, VALUE self) { FXGroupBox *arg1 = (FXGroupBox *) 0 ;
    FXColor arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGroupBox, 1); arg2 = to_FXColor(argv[0]); (arg1)->setTextColor(arg2);
    return Qnil; }
static VALUE _wrap_FXGroupBox_getTextColor(int argc, VALUE *argv, VALUE self) { FXGroupBox *arg1 = (FXGroupBox *) 0 ;
    FXColor result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGroupBox, 1);
    result = (FXColor)((FXGroupBox const *)arg1)->getTextColor(); vresult = UINT2NUM(result); return vresult; }
static void
free_FXGroupBox(FXGroupBox *arg1) {
    delete arg1;
}
static VALUE _wrap_FXGroupBox_save(int argc, VALUE *argv, VALUE self) { FXGroupBox *arg1 = (FXGroupBox *) 0 ;
    FXStream *arg2 = 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGroupBox, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXGroupBox_save((FXGroupBox const *)arg1,*arg2); return Qnil; }
static VALUE _wrap_FXGroupBox_load(int argc, VALUE *argv, VALUE self) { FXGroupBox *arg1 = (FXGroupBox *) 0 ;
    FXStream *arg2 = 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGroupBox, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXGroupBox_load(arg1,*arg2); return Qnil; }
static VALUE _wrap_FXGroupBox_create(int argc, VALUE *argv, VALUE self) { FXGroupBox *arg1 = (FXGroupBox *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGroupBox, 1); FXGroupBox_create(arg1); return Qnil; }
static VALUE _wrap_FXGroupBox_detach(int argc, VALUE *argv, VALUE self) { FXGroupBox *arg1 = (FXGroupBox *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGroupBox, 1); FXGroupBox_detach(arg1); return Qnil; }
static VALUE _wrap_FXGroupBox_destroy(int argc, VALUE *argv, VALUE self) { FXGroupBox *arg1 = (FXGroupBox *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGroupBox, 1); FXGroupBox_destroy(arg1); return Qnil; }
static VALUE _wrap_FXGroupBox_resize(int argc, VALUE *argv, VALUE self) { FXGroupBox *arg1 = (FXGroupBox *) 0 ; FXint arg2 ;
    FXint arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGroupBox, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    FXGroupBox_resize(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXGroupBox_getDefaultWidth(int argc, VALUE *argv, VALUE self) { FXGroupBox *arg1 = (FXGroupBox *) 0 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGroupBox, 1); result = (FXint)FXGroupBox_getDefaultWidth(arg1);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXGroupBox_getDefaultHeight(int argc, VALUE *argv, VALUE self) { FXGroupBox *arg1 = (FXGroupBox *) 0 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGroupBox, 1); result = (FXint)FXGroupBox_getDefaultHeight(arg1);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXGroupBox_getWidthForHeight(int argc, VALUE *argv, VALUE self) { FXGroupBox *arg1 = (FXGroupBox *) 0 ;
    FXint arg2 ; FXint result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGroupBox, 1); arg2 = NUM2INT(argv[0]);
    result = (FXint)FXGroupBox_getWidthForHeight(arg1,arg2); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXGroupBox_getHeightForWidth(int argc, VALUE *argv, VALUE self) { FXGroupBox *arg1 = (FXGroupBox *) 0 ;
    FXint arg2 ; FXint result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGroupBox, 1); arg2 = NUM2INT(argv[0]);
    result = (FXint)FXGroupBox_getHeightForWidth(arg1,arg2); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXGroupBox_canFocus(int argc, VALUE *argv, VALUE self) { FXGroupBox *arg1 = (FXGroupBox *) 0 ; FXbool result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGroupBox, 1);
    result = (FXbool)FXGroupBox_canFocus((FXGroupBox const *)arg1); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXGroupBox_setFocus(int argc, VALUE *argv, VALUE self) { FXGroupBox *arg1 = (FXGroupBox *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGroupBox, 1); FXGroupBox_setFocus(arg1); return Qnil; }
static VALUE _wrap_FXGroupBox_killFocus(int argc, VALUE *argv, VALUE self) { FXGroupBox *arg1 = (FXGroupBox *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGroupBox, 1); FXGroupBox_killFocus(arg1); return Qnil; }
static VALUE _wrap_FXGroupBox_setDefault(int argc, VALUE *argv, VALUE self) { FXGroupBox *arg1 = (FXGroupBox *) 0 ;
    FXbool arg2 = (FXbool) 1 ; if ((argc < 0) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGroupBox, 1); if (argc > 0) { arg2 = to_FXbool(argv[0]); } 
    FXGroupBox_setDefault(arg1,arg2); return Qnil; }
static VALUE _wrap_FXGroupBox_enable(int argc, VALUE *argv, VALUE self) { FXGroupBox *arg1 = (FXGroupBox *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGroupBox, 1); FXGroupBox_enable(arg1); return Qnil; }
static VALUE _wrap_FXGroupBox_disable(int argc, VALUE *argv, VALUE self) { FXGroupBox *arg1 = (FXGroupBox *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGroupBox, 1); FXGroupBox_disable(arg1); return Qnil; }
static VALUE _wrap_FXGroupBox_raiseWindow(int argc, VALUE *argv, VALUE self) { FXGroupBox *arg1 = (FXGroupBox *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGroupBox, 1); FXGroupBox_raise(arg1); return Qnil; }
static VALUE _wrap_FXGroupBox_lower(int argc, VALUE *argv, VALUE self) { FXGroupBox *arg1 = (FXGroupBox *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGroupBox, 1); FXGroupBox_lower(arg1); return Qnil; }
static VALUE _wrap_FXGroupBox_move(int argc, VALUE *argv, VALUE self) { FXGroupBox *arg1 = (FXGroupBox *) 0 ; FXint arg2 ;
    FXint arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGroupBox, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    FXGroupBox_move(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXGroupBox_position(int argc, VALUE *argv, VALUE self) { FXGroupBox *arg1 = (FXGroupBox *) 0 ; FXint arg2 ;
    FXint arg3 ; FXint arg4 ; FXint arg5 ; if ((argc < 4) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGroupBox, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    arg4 = NUM2INT(argv[2]); arg5 = NUM2INT(argv[3]); FXGroupBox_position(arg1,arg2,arg3,arg4,arg5); return Qnil; }
static VALUE _wrap_FXGroupBox_layout(int argc, VALUE *argv, VALUE self) { FXGroupBox *arg1 = (FXGroupBox *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGroupBox, 1); FXGroupBox_layout(arg1); return Qnil; }
static VALUE _wrap_FXGroupBox_recalc(int argc, VALUE *argv, VALUE self) { FXGroupBox *arg1 = (FXGroupBox *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGroupBox, 1); FXGroupBox_recalc(arg1); return Qnil; }
static VALUE _wrap_FXGroupBox_reparent(int argc, VALUE *argv, VALUE self) { FXGroupBox *arg1 = (FXGroupBox *) 0 ;
    FXComposite *arg2 = (FXComposite *) 0 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGroupBox, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXComposite, 1); FXGroupBox_reparent(arg1,arg2); return Qnil; }
static VALUE _wrap_FXGroupBox_show(int argc, VALUE *argv, VALUE self) { FXGroupBox *arg1 = (FXGroupBox *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGroupBox, 1); FXGroupBox_show(arg1); return Qnil; }
static VALUE _wrap_FXGroupBox_hide(int argc, VALUE *argv, VALUE self) { FXGroupBox *arg1 = (FXGroupBox *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGroupBox, 1); FXGroupBox_hide(arg1); return Qnil; }
static VALUE _wrap_FXGroupBox_isComposite(int argc, VALUE *argv, VALUE self) { FXGroupBox *arg1 = (FXGroupBox *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGroupBox, 1);
    result = (FXbool)FXGroupBox_isComposite((FXGroupBox const *)arg1); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXGroupBox_contains(int argc, VALUE *argv, VALUE self) { FXGroupBox *arg1 = (FXGroupBox *) 0 ; FXint arg2 ;
    FXint arg3 ; FXbool result; VALUE vresult = Qnil; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGroupBox, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    result = (FXbool)FXGroupBox_contains((FXGroupBox const *)arg1,arg2,arg3); vresult = result ? Qtrue : Qfalse;
    return vresult; }
static VALUE _wrap_FXGroupBox_doesSaveUnder(int argc, VALUE *argv, VALUE self) { FXGroupBox *arg1 = (FXGroupBox *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGroupBox, 1);
    result = (FXbool)FXGroupBox_doesSaveUnder((FXGroupBox const *)arg1); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXGroupBox_setBackColor(int argc, VALUE *argv, VALUE self) { FXGroupBox *arg1 = (FXGroupBox *) 0 ;
    FXColor arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXGroupBox, 1); arg2 = to_FXColor(argv[0]);
    FXGroupBox_setBackColor(arg1,arg2); return Qnil; }
static VALUE _wrap_FXSwitcher_onPaint(int argc, VALUE *argv, VALUE self) { FXSwitcher *arg1 = (FXSwitcher *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSwitcher, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onPaint(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXSwitcher_onCmdSetValue(int argc, VALUE *argv, VALUE self) { FXSwitcher *arg1 = (FXSwitcher *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSwitcher, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]);
    arg4 = reinterpret_cast<void*>(NUM2INT(argv[2])); result = (long)(arg1)->onCmdSetValue(arg2,arg3,arg4);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXSwitcher_onCmdSetIntValue(int argc, VALUE *argv, VALUE self) { FXSwitcher *arg1 = (FXSwitcher *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; FXint value4 ;
    VALUE vresult = Qnil; if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSwitcher, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); {
        value4 = (FXint) NUM2INT(argv[2]); arg4 = static_cast<void*>(&value4); } 
    result = (long)(arg1)->onCmdSetIntValue(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXSwitcher_onCmdGetIntValue(int argc, VALUE *argv, VALUE self) { FXSwitcher *arg1 = (FXSwitcher *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSwitcher, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdGetIntValue(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXSwitcher_onCmdOpen(int argc, VALUE *argv, VALUE self) { FXSwitcher *arg1 = (FXSwitcher *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSwitcher, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdOpen(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXSwitcher_onUpdOpen(int argc, VALUE *argv, VALUE self) { FXSwitcher *arg1 = (FXSwitcher *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSwitcher, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onUpdOpen(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE _wrap_FXSwitcher_allocate(VALUE self) {
#else
     static VALUE _wrap_FXSwitcher_allocate(int argc, VALUE *argv, VALUE self) {
#endif
         VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_FXSwitcher);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
         return vresult; }
static VALUE _wrap_new_FXSwitcher(int argc, VALUE *argv, VALUE self) { FXComposite *arg1 = (FXComposite *) 0 ;
    FXuint arg2 = (FXuint) 0 ; FXint arg3 = (FXint) 0 ; FXint arg4 = (FXint) 0 ; FXint arg5 = (FXint) 0 ;
    FXint arg6 = (FXint) 0 ; FXint arg7 = (FXint) DEFAULT_SPACING ; FXint arg8 = (FXint) DEFAULT_SPACING ;
    FXint arg9 = (FXint) DEFAULT_SPACING ; FXint arg10 = (FXint) DEFAULT_SPACING ; FXSwitcher *result;
    if ((argc < 1) || (argc > 10)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXComposite, 1); if (argc > 1) { arg2 = NUM2UINT(argv[1]); } 
    if (argc > 2) { arg3 = NUM2INT(argv[2]); }  if (argc > 3) { arg4 = NUM2INT(argv[3]); }  if (argc > 4) {
        arg5 = NUM2INT(argv[4]); }  if (argc > 5) { arg6 = NUM2INT(argv[5]); }  if (argc > 6) { arg7 = NUM2INT(argv[6]); } 
    if (argc > 7) { arg8 = NUM2INT(argv[7]); }  if (argc > 8) { arg9 = NUM2INT(argv[8]); }  if (argc > 9) {
        arg10 = NUM2INT(argv[9]); }  {
        result = (FXSwitcher *)new_FXSwitcher(arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8,arg9,arg10);
        DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result); if(rb_block_given_p()){ rb_yield(self); }  }  return self; }
static VALUE _wrap_FXSwitcher_setCurrent(int argc, VALUE *argv, VALUE self) { FXSwitcher *arg1 = (FXSwitcher *) 0 ; FXint arg2 ;
    FXbool arg3 = (FXbool) 0 ; if ((argc < 1) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSwitcher, 1); arg2 = NUM2INT(argv[0]); if (argc > 1) {
        arg3 = to_FXbool(argv[1]); }  { if (arg2 < 0 || arg2 >= arg1->numChildren()) {
            rb_raise(rb_eIndexError, "switcher item index out of bounds"); }  }  (arg1)->setCurrent(arg2,arg3); return Qnil; }
static VALUE _wrap_FXSwitcher_getCurrent(int argc, VALUE *argv, VALUE self) { FXSwitcher *arg1 = (FXSwitcher *) 0 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSwitcher, 1); result = (FXint)((FXSwitcher const *)arg1)->getCurrent();
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXSwitcher_setSwitcherStyle(int argc, VALUE *argv, VALUE self) { FXSwitcher *arg1 = (FXSwitcher *) 0 ;
    FXuint arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSwitcher, 1); arg2 = NUM2UINT(argv[0]); (arg1)->setSwitcherStyle(arg2);
    return Qnil; }
static VALUE _wrap_FXSwitcher_getSwitcherStyle(int argc, VALUE *argv, VALUE self) { FXSwitcher *arg1 = (FXSwitcher *) 0 ;
    FXuint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSwitcher, 1);
    result = (FXuint)((FXSwitcher const *)arg1)->getSwitcherStyle(); vresult = UINT2NUM(result); return vresult; }
static void
free_FXSwitcher(FXSwitcher *arg1) {
    delete arg1;
}
static VALUE _wrap_FXSwitcher_save(int argc, VALUE *argv, VALUE self) { FXSwitcher *arg1 = (FXSwitcher *) 0 ;
    FXStream *arg2 = 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSwitcher, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXSwitcher_save((FXSwitcher const *)arg1,*arg2); return Qnil; }
static VALUE _wrap_FXSwitcher_load(int argc, VALUE *argv, VALUE self) { FXSwitcher *arg1 = (FXSwitcher *) 0 ;
    FXStream *arg2 = 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSwitcher, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXSwitcher_load(arg1,*arg2); return Qnil; }
static VALUE _wrap_FXSwitcher_create(int argc, VALUE *argv, VALUE self) { FXSwitcher *arg1 = (FXSwitcher *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSwitcher, 1); FXSwitcher_create(arg1); return Qnil; }
static VALUE _wrap_FXSwitcher_detach(int argc, VALUE *argv, VALUE self) { FXSwitcher *arg1 = (FXSwitcher *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSwitcher, 1); FXSwitcher_detach(arg1); return Qnil; }
static VALUE _wrap_FXSwitcher_destroy(int argc, VALUE *argv, VALUE self) { FXSwitcher *arg1 = (FXSwitcher *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSwitcher, 1); FXSwitcher_destroy(arg1); return Qnil; }
static VALUE _wrap_FXSwitcher_resize(int argc, VALUE *argv, VALUE self) { FXSwitcher *arg1 = (FXSwitcher *) 0 ; FXint arg2 ;
    FXint arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSwitcher, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    FXSwitcher_resize(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXSwitcher_getDefaultWidth(int argc, VALUE *argv, VALUE self) { FXSwitcher *arg1 = (FXSwitcher *) 0 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSwitcher, 1); result = (FXint)FXSwitcher_getDefaultWidth(arg1);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXSwitcher_getDefaultHeight(int argc, VALUE *argv, VALUE self) { FXSwitcher *arg1 = (FXSwitcher *) 0 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSwitcher, 1); result = (FXint)FXSwitcher_getDefaultHeight(arg1);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXSwitcher_getWidthForHeight(int argc, VALUE *argv, VALUE self) { FXSwitcher *arg1 = (FXSwitcher *) 0 ;
    FXint arg2 ; FXint result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSwitcher, 1); arg2 = NUM2INT(argv[0]);
    result = (FXint)FXSwitcher_getWidthForHeight(arg1,arg2); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXSwitcher_getHeightForWidth(int argc, VALUE *argv, VALUE self) { FXSwitcher *arg1 = (FXSwitcher *) 0 ;
    FXint arg2 ; FXint result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSwitcher, 1); arg2 = NUM2INT(argv[0]);
    result = (FXint)FXSwitcher_getHeightForWidth(arg1,arg2); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXSwitcher_canFocus(int argc, VALUE *argv, VALUE self) { FXSwitcher *arg1 = (FXSwitcher *) 0 ; FXbool result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSwitcher, 1);
    result = (FXbool)FXSwitcher_canFocus((FXSwitcher const *)arg1); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXSwitcher_setFocus(int argc, VALUE *argv, VALUE self) { FXSwitcher *arg1 = (FXSwitcher *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSwitcher, 1); FXSwitcher_setFocus(arg1); return Qnil; }
static VALUE _wrap_FXSwitcher_killFocus(int argc, VALUE *argv, VALUE self) { FXSwitcher *arg1 = (FXSwitcher *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSwitcher, 1); FXSwitcher_killFocus(arg1); return Qnil; }
static VALUE _wrap_FXSwitcher_setDefault(int argc, VALUE *argv, VALUE self) { FXSwitcher *arg1 = (FXSwitcher *) 0 ;
    FXbool arg2 = (FXbool) 1 ; if ((argc < 0) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSwitcher, 1); if (argc > 0) { arg2 = to_FXbool(argv[0]); } 
    FXSwitcher_setDefault(arg1,arg2); return Qnil; }
static VALUE _wrap_FXSwitcher_enable(int argc, VALUE *argv, VALUE self) { FXSwitcher *arg1 = (FXSwitcher *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSwitcher, 1); FXSwitcher_enable(arg1); return Qnil; }
static VALUE _wrap_FXSwitcher_disable(int argc, VALUE *argv, VALUE self) { FXSwitcher *arg1 = (FXSwitcher *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSwitcher, 1); FXSwitcher_disable(arg1); return Qnil; }
static VALUE _wrap_FXSwitcher_raiseWindow(int argc, VALUE *argv, VALUE self) { FXSwitcher *arg1 = (FXSwitcher *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSwitcher, 1); FXSwitcher_raise(arg1); return Qnil; }
static VALUE _wrap_FXSwitcher_lower(int argc, VALUE *argv, VALUE self) { FXSwitcher *arg1 = (FXSwitcher *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSwitcher, 1); FXSwitcher_lower(arg1); return Qnil; }
static VALUE _wrap_FXSwitcher_move(int argc, VALUE *argv, VALUE self) { FXSwitcher *arg1 = (FXSwitcher *) 0 ; FXint arg2 ;
    FXint arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSwitcher, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    FXSwitcher_move(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXSwitcher_position(int argc, VALUE *argv, VALUE self) { FXSwitcher *arg1 = (FXSwitcher *) 0 ; FXint arg2 ;
    FXint arg3 ; FXint arg4 ; FXint arg5 ; if ((argc < 4) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSwitcher, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    arg4 = NUM2INT(argv[2]); arg5 = NUM2INT(argv[3]); FXSwitcher_position(arg1,arg2,arg3,arg4,arg5); return Qnil; }
static VALUE _wrap_FXSwitcher_layout(int argc, VALUE *argv, VALUE self) { FXSwitcher *arg1 = (FXSwitcher *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSwitcher, 1); FXSwitcher_layout(arg1); return Qnil; }
static VALUE _wrap_FXSwitcher_recalc(int argc, VALUE *argv, VALUE self) { FXSwitcher *arg1 = (FXSwitcher *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSwitcher, 1); FXSwitcher_recalc(arg1); return Qnil; }
static VALUE _wrap_FXSwitcher_reparent(int argc, VALUE *argv, VALUE self) { FXSwitcher *arg1 = (FXSwitcher *) 0 ;
    FXComposite *arg2 = (FXComposite *) 0 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSwitcher, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXComposite, 1); FXSwitcher_reparent(arg1,arg2); return Qnil; }
static VALUE _wrap_FXSwitcher_show(int argc, VALUE *argv, VALUE self) { FXSwitcher *arg1 = (FXSwitcher *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSwitcher, 1); FXSwitcher_show(arg1); return Qnil; }
static VALUE _wrap_FXSwitcher_hide(int argc, VALUE *argv, VALUE self) { FXSwitcher *arg1 = (FXSwitcher *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSwitcher, 1); FXSwitcher_hide(arg1); return Qnil; }
static VALUE _wrap_FXSwitcher_isComposite(int argc, VALUE *argv, VALUE self) { FXSwitcher *arg1 = (FXSwitcher *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSwitcher, 1);
    result = (FXbool)FXSwitcher_isComposite((FXSwitcher const *)arg1); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXSwitcher_contains(int argc, VALUE *argv, VALUE self) { FXSwitcher *arg1 = (FXSwitcher *) 0 ; FXint arg2 ;
    FXint arg3 ; FXbool result; VALUE vresult = Qnil; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSwitcher, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    result = (FXbool)FXSwitcher_contains((FXSwitcher const *)arg1,arg2,arg3); vresult = result ? Qtrue : Qfalse;
    return vresult; }
static VALUE _wrap_FXSwitcher_doesSaveUnder(int argc, VALUE *argv, VALUE self) { FXSwitcher *arg1 = (FXSwitcher *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSwitcher, 1);
    result = (FXbool)FXSwitcher_doesSaveUnder((FXSwitcher const *)arg1); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXSwitcher_setBackColor(int argc, VALUE *argv, VALUE self) { FXSwitcher *arg1 = (FXSwitcher *) 0 ;
    FXColor arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSwitcher, 1); arg2 = to_FXColor(argv[0]);
    FXSwitcher_setBackColor(arg1,arg2); return Qnil; }
static VALUE _wrap_FXShutterItem_onFocusUp(int argc, VALUE *argv, VALUE self) { FXShutterItem *arg1 = (FXShutterItem *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXShutterItem, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onFocusUp(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXShutterItem_onFocusDown(int argc, VALUE *argv, VALUE self) { FXShutterItem *arg1 = (FXShutterItem *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXShutterItem, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onFocusDown(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXShutterItem_onCmdButton(int argc, VALUE *argv, VALUE self) { FXShutterItem *arg1 = (FXShutterItem *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXShutterItem, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdButton(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE _wrap_FXShutterItem_allocate(VALUE self) {
#else
     static VALUE _wrap_FXShutterItem_allocate(int argc, VALUE *argv, VALUE self) {
#endif
         VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_FXShutterItem);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
         return vresult; }
static VALUE _wrap_new_FXShutterItem(int argc, VALUE *argv, VALUE self) { FXShutter *arg1 = (FXShutter *) 0 ;
    FXString *arg2 = 0 ; FXIcon *arg3 = (FXIcon *) 0 ; FXuint arg4 = (FXuint) 0 ; FXint arg5 = (FXint) 0 ;
    FXint arg6 = (FXint) 0 ; FXint arg7 = (FXint) 0 ; FXint arg8 = (FXint) 0 ; FXint arg9 = (FXint) DEFAULT_SPACING ;
    FXint arg10 = (FXint) DEFAULT_SPACING ; FXint arg11 = (FXint) DEFAULT_SPACING ; FXint arg12 = (FXint) DEFAULT_SPACING ;
    FXint arg13 = (FXint) DEFAULT_SPACING ; FXint arg14 = (FXint) DEFAULT_SPACING ; FXShutterItem *result;
    SwigValueWrapper<FXString > p2 ; if ((argc < 2) || (argc > 14))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXShutter, 1); p2 = to_FXString(argv[1]); arg2 = &p2; if (argc > 2) {
        SWIG_ConvertPtr(argv[2], (void **) &arg3, SWIGTYPE_p_FXIcon, 1); }  if (argc > 3) { arg4 = NUM2UINT(argv[3]); } 
    if (argc > 4) { arg5 = NUM2INT(argv[4]); }  if (argc > 5) { arg6 = NUM2INT(argv[5]); }  if (argc > 6) {
        arg7 = NUM2INT(argv[6]); }  if (argc > 7) { arg8 = NUM2INT(argv[7]); }  if (argc > 8) { arg9 = NUM2INT(argv[8]); } 
    if (argc > 9) { arg10 = NUM2INT(argv[9]); }  if (argc > 10) { arg11 = NUM2INT(argv[10]); }  if (argc > 11) {
        arg12 = NUM2INT(argv[11]); }  if (argc > 12) { arg13 = NUM2INT(argv[12]); }  if (argc > 13) {
        arg14 = NUM2INT(argv[13]); }  {
        result = (FXShutterItem *)new_FXShutterItem(arg1,(FXString const &)*arg2,arg3,arg4,arg5,arg6,arg7,arg8,arg9,arg10,arg11,arg12,arg13,arg14);
        DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result); if(rb_block_given_p()){ rb_yield(self); }  }  return self; }
static VALUE _wrap_FXShutterItem_getButton(int argc, VALUE *argv, VALUE self) { FXShutterItem *arg1 = (FXShutterItem *) 0 ;
    FXButton *result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXShutterItem, 1);
    result = (FXButton *)((FXShutterItem const *)arg1)->getButton(); {
        swig_type_info *ty = SWIG_TypeDynamicCast(SWIGTYPE_p_FXButton, (void **) &result);
        vresult = FXRbGetRubyObj(result, ty); }  return vresult; }
static VALUE _wrap_FXShutterItem_getContent(int argc, VALUE *argv, VALUE self) { FXShutterItem *arg1 = (FXShutterItem *) 0 ;
    FXVerticalFrame *result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXShutterItem, 1);
    result = (FXVerticalFrame *)((FXShutterItem const *)arg1)->getContent(); {
        swig_type_info *ty = SWIG_TypeDynamicCast(SWIGTYPE_p_FXVerticalFrame, (void **) &result);
        vresult = FXRbGetRubyObj(result, ty); }  return vresult; }
static VALUE _wrap_FXShutterItem_setHelpText(int argc, VALUE *argv, VALUE self) { FXShutterItem *arg1 = (FXShutterItem *) 0 ;
    FXString *arg2 = 0 ; SwigValueWrapper<FXString > p2 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXShutterItem, 1); p2 = to_FXString(argv[0]); arg2 = &p2;
    (arg1)->setHelpText((FXString const &)*arg2); return Qnil; }
static VALUE _wrap_FXShutterItem_getHelpText(int argc, VALUE *argv, VALUE self) { FXShutterItem *arg1 = (FXShutterItem *) 0 ;
    FXString result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXShutterItem, 1); result = ((FXShutterItem const *)arg1)->getHelpText();
    vresult = rb_str_new2((&result)->text()); return vresult; }
static VALUE _wrap_FXShutterItem_setTipText(int argc, VALUE *argv, VALUE self) { FXShutterItem *arg1 = (FXShutterItem *) 0 ;
    FXString *arg2 = 0 ; SwigValueWrapper<FXString > p2 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXShutterItem, 1); p2 = to_FXString(argv[0]); arg2 = &p2;
    (arg1)->setTipText((FXString const &)*arg2); return Qnil; }
static VALUE _wrap_FXShutterItem_getTipText(int argc, VALUE *argv, VALUE self) { FXShutterItem *arg1 = (FXShutterItem *) 0 ;
    FXString result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXShutterItem, 1); result = ((FXShutterItem const *)arg1)->getTipText();
    vresult = rb_str_new2((&result)->text()); return vresult; }
static void
free_FXShutterItem(FXShutterItem *arg1) {
    delete arg1;
}
static VALUE _wrap_FXShutterItem_save(int argc, VALUE *argv, VALUE self) { FXShutterItem *arg1 = (FXShutterItem *) 0 ;
    FXStream *arg2 = 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXShutterItem, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXShutterItem_save((FXShutterItem const *)arg1,*arg2); return Qnil; }
static VALUE _wrap_FXShutterItem_load(int argc, VALUE *argv, VALUE self) { FXShutterItem *arg1 = (FXShutterItem *) 0 ;
    FXStream *arg2 = 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXShutterItem, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXShutterItem_load(arg1,*arg2); return Qnil; }
static VALUE _wrap_FXShutterItem_create(int argc, VALUE *argv, VALUE self) { FXShutterItem *arg1 = (FXShutterItem *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXShutterItem, 1); FXShutterItem_create(arg1); return Qnil; }
static VALUE _wrap_FXShutterItem_detach(int argc, VALUE *argv, VALUE self) { FXShutterItem *arg1 = (FXShutterItem *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXShutterItem, 1); FXShutterItem_detach(arg1); return Qnil; }
static VALUE _wrap_FXShutterItem_destroy(int argc, VALUE *argv, VALUE self) { FXShutterItem *arg1 = (FXShutterItem *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXShutterItem, 1); FXShutterItem_destroy(arg1); return Qnil; }
static VALUE _wrap_FXShutterItem_resize(int argc, VALUE *argv, VALUE self) { FXShutterItem *arg1 = (FXShutterItem *) 0 ;
    FXint arg2 ; FXint arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXShutterItem, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    FXShutterItem_resize(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXShutterItem_getDefaultWidth(int argc, VALUE *argv, VALUE self) {
    FXShutterItem *arg1 = (FXShutterItem *) 0 ; FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXShutterItem, 1); result = (FXint)FXShutterItem_getDefaultWidth(arg1);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXShutterItem_getDefaultHeight(int argc, VALUE *argv, VALUE self) {
    FXShutterItem *arg1 = (FXShutterItem *) 0 ; FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXShutterItem, 1); result = (FXint)FXShutterItem_getDefaultHeight(arg1);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXShutterItem_getWidthForHeight(int argc, VALUE *argv, VALUE self) {
    FXShutterItem *arg1 = (FXShutterItem *) 0 ; FXint arg2 ; FXint result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXShutterItem, 1); arg2 = NUM2INT(argv[0]);
    result = (FXint)FXShutterItem_getWidthForHeight(arg1,arg2); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXShutterItem_getHeightForWidth(int argc, VALUE *argv, VALUE self) {
    FXShutterItem *arg1 = (FXShutterItem *) 0 ; FXint arg2 ; FXint result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXShutterItem, 1); arg2 = NUM2INT(argv[0]);
    result = (FXint)FXShutterItem_getHeightForWidth(arg1,arg2); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXShutterItem_canFocus(int argc, VALUE *argv, VALUE self) { FXShutterItem *arg1 = (FXShutterItem *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXShutterItem, 1);
    result = (FXbool)FXShutterItem_canFocus((FXShutterItem const *)arg1); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXShutterItem_setFocus(int argc, VALUE *argv, VALUE self) { FXShutterItem *arg1 = (FXShutterItem *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXShutterItem, 1); FXShutterItem_setFocus(arg1); return Qnil; }
static VALUE _wrap_FXShutterItem_killFocus(int argc, VALUE *argv, VALUE self) { FXShutterItem *arg1 = (FXShutterItem *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXShutterItem, 1); FXShutterItem_killFocus(arg1); return Qnil; }
static VALUE _wrap_FXShutterItem_setDefault(int argc, VALUE *argv, VALUE self) { FXShutterItem *arg1 = (FXShutterItem *) 0 ;
    FXbool arg2 = (FXbool) 1 ; if ((argc < 0) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXShutterItem, 1); if (argc > 0) { arg2 = to_FXbool(argv[0]); } 
    FXShutterItem_setDefault(arg1,arg2); return Qnil; }
static VALUE _wrap_FXShutterItem_enable(int argc, VALUE *argv, VALUE self) { FXShutterItem *arg1 = (FXShutterItem *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXShutterItem, 1); FXShutterItem_enable(arg1); return Qnil; }
static VALUE _wrap_FXShutterItem_disable(int argc, VALUE *argv, VALUE self) { FXShutterItem *arg1 = (FXShutterItem *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXShutterItem, 1); FXShutterItem_disable(arg1); return Qnil; }
static VALUE _wrap_FXShutterItem_raiseWindow(int argc, VALUE *argv, VALUE self) { FXShutterItem *arg1 = (FXShutterItem *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXShutterItem, 1); FXShutterItem_raise(arg1); return Qnil; }
static VALUE _wrap_FXShutterItem_lower(int argc, VALUE *argv, VALUE self) { FXShutterItem *arg1 = (FXShutterItem *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXShutterItem, 1); FXShutterItem_lower(arg1); return Qnil; }
static VALUE _wrap_FXShutterItem_move(int argc, VALUE *argv, VALUE self) { FXShutterItem *arg1 = (FXShutterItem *) 0 ;
    FXint arg2 ; FXint arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXShutterItem, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    FXShutterItem_move(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXShutterItem_position(int argc, VALUE *argv, VALUE self) { FXShutterItem *arg1 = (FXShutterItem *) 0 ;
    FXint arg2 ; FXint arg3 ; FXint arg4 ; FXint arg5 ; if ((argc < 4) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXShutterItem, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    arg4 = NUM2INT(argv[2]); arg5 = NUM2INT(argv[3]); FXShutterItem_position(arg1,arg2,arg3,arg4,arg5); return Qnil; }
static VALUE _wrap_FXShutterItem_layout(int argc, VALUE *argv, VALUE self) { FXShutterItem *arg1 = (FXShutterItem *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXShutterItem, 1); FXShutterItem_layout(arg1); return Qnil; }
static VALUE _wrap_FXShutterItem_recalc(int argc, VALUE *argv, VALUE self) { FXShutterItem *arg1 = (FXShutterItem *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXShutterItem, 1); FXShutterItem_recalc(arg1); return Qnil; }
static VALUE _wrap_FXShutterItem_reparent(int argc, VALUE *argv, VALUE self) { FXShutterItem *arg1 = (FXShutterItem *) 0 ;
    FXComposite *arg2 = (FXComposite *) 0 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXShutterItem, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXComposite, 1); FXShutterItem_reparent(arg1,arg2); return Qnil; }
static VALUE _wrap_FXShutterItem_show(int argc, VALUE *argv, VALUE self) { FXShutterItem *arg1 = (FXShutterItem *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXShutterItem, 1); FXShutterItem_show(arg1); return Qnil; }
static VALUE _wrap_FXShutterItem_hide(int argc, VALUE *argv, VALUE self) { FXShutterItem *arg1 = (FXShutterItem *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXShutterItem, 1); FXShutterItem_hide(arg1); return Qnil; }
static VALUE _wrap_FXShutterItem_isComposite(int argc, VALUE *argv, VALUE self) { FXShutterItem *arg1 = (FXShutterItem *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXShutterItem, 1);
    result = (FXbool)FXShutterItem_isComposite((FXShutterItem const *)arg1); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXShutterItem_contains(int argc, VALUE *argv, VALUE self) { FXShutterItem *arg1 = (FXShutterItem *) 0 ;
    FXint arg2 ; FXint arg3 ; FXbool result; VALUE vresult = Qnil; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXShutterItem, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    result = (FXbool)FXShutterItem_contains((FXShutterItem const *)arg1,arg2,arg3); vresult = result ? Qtrue : Qfalse;
    return vresult; }
static VALUE _wrap_FXShutterItem_doesSaveUnder(int argc, VALUE *argv, VALUE self) { FXShutterItem *arg1 = (FXShutterItem *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXShutterItem, 1);
    result = (FXbool)FXShutterItem_doesSaveUnder((FXShutterItem const *)arg1); vresult = result ? Qtrue : Qfalse;
    return vresult; }
static VALUE _wrap_FXShutterItem_setBackColor(int argc, VALUE *argv, VALUE self) { FXShutterItem *arg1 = (FXShutterItem *) 0 ;
    FXColor arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXShutterItem, 1); arg2 = to_FXColor(argv[0]);
    FXShutterItem_setBackColor(arg1,arg2); return Qnil; }
static VALUE _wrap_FXShutter_onFocusUp(int argc, VALUE *argv, VALUE self) { FXShutter *arg1 = (FXShutter *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXShutter, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onFocusUp(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXShutter_onFocusDown(int argc, VALUE *argv, VALUE self) { FXShutter *arg1 = (FXShutter *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXShutter, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onFocusDown(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXShutter_onTimeout(int argc, VALUE *argv, VALUE self) { FXShutter *arg1 = (FXShutter *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXShutter, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onTimeout(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXShutter_onOpenItem(int argc, VALUE *argv, VALUE self) { FXShutter *arg1 = (FXShutter *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXShutter, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onOpenItem(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXShutter_onCmdSetValue(int argc, VALUE *argv, VALUE self) { FXShutter *arg1 = (FXShutter *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXShutter, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]);
    arg4 = reinterpret_cast<void*>(NUM2INT(argv[2])); result = (long)(arg1)->onCmdSetValue(arg2,arg3,arg4);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXShutter_onCmdSetIntValue(int argc, VALUE *argv, VALUE self) { FXShutter *arg1 = (FXShutter *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; FXint value4 ;
    VALUE vresult = Qnil; if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXShutter, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); {
        value4 = (FXint) NUM2INT(argv[2]); arg4 = static_cast<void*>(&value4); } 
    result = (long)(arg1)->onCmdSetIntValue(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXShutter_onCmdGetIntValue(int argc, VALUE *argv, VALUE self) { FXShutter *arg1 = (FXShutter *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXShutter, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdGetIntValue(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXShutter_onCmdOpen(int argc, VALUE *argv, VALUE self) { FXShutter *arg1 = (FXShutter *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXShutter, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdOpen(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXShutter_onUpdOpen(int argc, VALUE *argv, VALUE self) { FXShutter *arg1 = (FXShutter *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXShutter, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onUpdOpen(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE _wrap_FXShutter_allocate(VALUE self) {
#else
     static VALUE _wrap_FXShutter_allocate(int argc, VALUE *argv, VALUE self) {
#endif
         VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_FXShutter);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
         return vresult; }
static VALUE _wrap_new_FXShutter(int argc, VALUE *argv, VALUE self) { FXComposite *arg1 = (FXComposite *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 = (FXSelector) 0 ; FXuint arg4 = (FXuint) 0 ; FXint arg5 = (FXint) 0 ;
    FXint arg6 = (FXint) 0 ; FXint arg7 = (FXint) 0 ; FXint arg8 = (FXint) 0 ; FXint arg9 = (FXint) DEFAULT_SPACING ;
    FXint arg10 = (FXint) DEFAULT_SPACING ; FXint arg11 = (FXint) DEFAULT_SPACING ; FXint arg12 = (FXint) DEFAULT_SPACING ;
    FXint arg13 = (FXint) DEFAULT_SPACING ; FXint arg14 = (FXint) DEFAULT_SPACING ; FXShutter *result;
    if ((argc < 1) || (argc > 14)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXComposite, 1); if (argc > 1) {
        SWIG_ConvertPtr(argv[1], (void **) &arg2, SWIGTYPE_p_FXObject, 1); }  if (argc > 2) { arg3 = NUM2UINT(argv[2]); } 
    if (argc > 3) { arg4 = NUM2UINT(argv[3]); }  if (argc > 4) { arg5 = NUM2INT(argv[4]); }  if (argc > 5) {
        arg6 = NUM2INT(argv[5]); }  if (argc > 6) { arg7 = NUM2INT(argv[6]); }  if (argc > 7) { arg8 = NUM2INT(argv[7]); } 
    if (argc > 8) { arg9 = NUM2INT(argv[8]); }  if (argc > 9) { arg10 = NUM2INT(argv[9]); }  if (argc > 10) {
        arg11 = NUM2INT(argv[10]); }  if (argc > 11) { arg12 = NUM2INT(argv[11]); }  if (argc > 12) {
        arg13 = NUM2INT(argv[12]); }  if (argc > 13) { arg14 = NUM2INT(argv[13]); }  {
        result = (FXShutter *)new_FXShutter(arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8,arg9,arg10,arg11,arg12,arg13,arg14);
        DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result); if(rb_block_given_p()){ rb_yield(self); }  }  return self; }
static VALUE _wrap_FXShutter_getCurrent(int argc, VALUE *argv, VALUE self) { FXShutter *arg1 = (FXShutter *) 0 ; FXint result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXShutter, 1); result = (FXint)((FXShutter const *)arg1)->getCurrent();
    vresult = INT2NUM(result); return vresult; }
static void
free_FXShutter(FXShutter *arg1) {
    delete arg1;
}
static VALUE _wrap_FXShutter_save(int argc, VALUE *argv, VALUE self) { FXShutter *arg1 = (FXShutter *) 0 ; FXStream *arg2 = 0 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXShutter, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXShutter_save((FXShutter const *)arg1,*arg2); return Qnil; }
static VALUE _wrap_FXShutter_load(int argc, VALUE *argv, VALUE self) { FXShutter *arg1 = (FXShutter *) 0 ; FXStream *arg2 = 0 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXShutter, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXShutter_load(arg1,*arg2); return Qnil; }
static VALUE _wrap_FXShutter_create(int argc, VALUE *argv, VALUE self) { FXShutter *arg1 = (FXShutter *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXShutter, 1); FXShutter_create(arg1); return Qnil; }
static VALUE _wrap_FXShutter_detach(int argc, VALUE *argv, VALUE self) { FXShutter *arg1 = (FXShutter *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXShutter, 1); FXShutter_detach(arg1); return Qnil; }
static VALUE _wrap_FXShutter_destroy(int argc, VALUE *argv, VALUE self) { FXShutter *arg1 = (FXShutter *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXShutter, 1); FXShutter_destroy(arg1); return Qnil; }
static VALUE _wrap_FXShutter_resize(int argc, VALUE *argv, VALUE self) { FXShutter *arg1 = (FXShutter *) 0 ; FXint arg2 ;
    FXint arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXShutter, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    FXShutter_resize(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXShutter_getDefaultWidth(int argc, VALUE *argv, VALUE self) { FXShutter *arg1 = (FXShutter *) 0 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXShutter, 1); result = (FXint)FXShutter_getDefaultWidth(arg1);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXShutter_getDefaultHeight(int argc, VALUE *argv, VALUE self) { FXShutter *arg1 = (FXShutter *) 0 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXShutter, 1); result = (FXint)FXShutter_getDefaultHeight(arg1);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXShutter_getWidthForHeight(int argc, VALUE *argv, VALUE self) { FXShutter *arg1 = (FXShutter *) 0 ;
    FXint arg2 ; FXint result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXShutter, 1); arg2 = NUM2INT(argv[0]);
    result = (FXint)FXShutter_getWidthForHeight(arg1,arg2); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXShutter_getHeightForWidth(int argc, VALUE *argv, VALUE self) { FXShutter *arg1 = (FXShutter *) 0 ;
    FXint arg2 ; FXint result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXShutter, 1); arg2 = NUM2INT(argv[0]);
    result = (FXint)FXShutter_getHeightForWidth(arg1,arg2); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXShutter_canFocus(int argc, VALUE *argv, VALUE self) { FXShutter *arg1 = (FXShutter *) 0 ; FXbool result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXShutter, 1);
    result = (FXbool)FXShutter_canFocus((FXShutter const *)arg1); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXShutter_setFocus(int argc, VALUE *argv, VALUE self) { FXShutter *arg1 = (FXShutter *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXShutter, 1); FXShutter_setFocus(arg1); return Qnil; }
static VALUE _wrap_FXShutter_killFocus(int argc, VALUE *argv, VALUE self) { FXShutter *arg1 = (FXShutter *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXShutter, 1); FXShutter_killFocus(arg1); return Qnil; }
static VALUE _wrap_FXShutter_setDefault(int argc, VALUE *argv, VALUE self) { FXShutter *arg1 = (FXShutter *) 0 ;
    FXbool arg2 = (FXbool) 1 ; if ((argc < 0) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXShutter, 1); if (argc > 0) { arg2 = to_FXbool(argv[0]); } 
    FXShutter_setDefault(arg1,arg2); return Qnil; }
static VALUE _wrap_FXShutter_enable(int argc, VALUE *argv, VALUE self) { FXShutter *arg1 = (FXShutter *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXShutter, 1); FXShutter_enable(arg1); return Qnil; }
static VALUE _wrap_FXShutter_disable(int argc, VALUE *argv, VALUE self) { FXShutter *arg1 = (FXShutter *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXShutter, 1); FXShutter_disable(arg1); return Qnil; }
static VALUE _wrap_FXShutter_raiseWindow(int argc, VALUE *argv, VALUE self) { FXShutter *arg1 = (FXShutter *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXShutter, 1); FXShutter_raise(arg1); return Qnil; }
static VALUE _wrap_FXShutter_lower(int argc, VALUE *argv, VALUE self) { FXShutter *arg1 = (FXShutter *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXShutter, 1); FXShutter_lower(arg1); return Qnil; }
static VALUE _wrap_FXShutter_move(int argc, VALUE *argv, VALUE self) { FXShutter *arg1 = (FXShutter *) 0 ; FXint arg2 ;
    FXint arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXShutter, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    FXShutter_move(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXShutter_position(int argc, VALUE *argv, VALUE self) { FXShutter *arg1 = (FXShutter *) 0 ; FXint arg2 ;
    FXint arg3 ; FXint arg4 ; FXint arg5 ; if ((argc < 4) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXShutter, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    arg4 = NUM2INT(argv[2]); arg5 = NUM2INT(argv[3]); FXShutter_position(arg1,arg2,arg3,arg4,arg5); return Qnil; }
static VALUE _wrap_FXShutter_layout(int argc, VALUE *argv, VALUE self) { FXShutter *arg1 = (FXShutter *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXShutter, 1); FXShutter_layout(arg1); return Qnil; }
static VALUE _wrap_FXShutter_recalc(int argc, VALUE *argv, VALUE self) { FXShutter *arg1 = (FXShutter *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXShutter, 1); FXShutter_recalc(arg1); return Qnil; }
static VALUE _wrap_FXShutter_reparent(int argc, VALUE *argv, VALUE self) { FXShutter *arg1 = (FXShutter *) 0 ;
    FXComposite *arg2 = (FXComposite *) 0 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXShutter, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXComposite, 1); FXShutter_reparent(arg1,arg2); return Qnil; }
static VALUE _wrap_FXShutter_show(int argc, VALUE *argv, VALUE self) { FXShutter *arg1 = (FXShutter *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXShutter, 1); FXShutter_show(arg1); return Qnil; }
static VALUE _wrap_FXShutter_hide(int argc, VALUE *argv, VALUE self) { FXShutter *arg1 = (FXShutter *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXShutter, 1); FXShutter_hide(arg1); return Qnil; }
static VALUE _wrap_FXShutter_isComposite(int argc, VALUE *argv, VALUE self) { FXShutter *arg1 = (FXShutter *) 0 ; FXbool result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXShutter, 1);
    result = (FXbool)FXShutter_isComposite((FXShutter const *)arg1); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXShutter_contains(int argc, VALUE *argv, VALUE self) { FXShutter *arg1 = (FXShutter *) 0 ; FXint arg2 ;
    FXint arg3 ; FXbool result; VALUE vresult = Qnil; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXShutter, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    result = (FXbool)FXShutter_contains((FXShutter const *)arg1,arg2,arg3); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXShutter_doesSaveUnder(int argc, VALUE *argv, VALUE self) { FXShutter *arg1 = (FXShutter *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXShutter, 1);
    result = (FXbool)FXShutter_doesSaveUnder((FXShutter const *)arg1); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXShutter_setBackColor(int argc, VALUE *argv, VALUE self) { FXShutter *arg1 = (FXShutter *) 0 ;
    FXColor arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXShutter, 1); arg2 = to_FXColor(argv[0]);
    FXShutter_setBackColor(arg1,arg2); return Qnil; }
static VALUE _wrap_FXShutter_setCurrent(int argc, VALUE *argv, VALUE self) { FXShutter *arg1 = (FXShutter *) 0 ; FXint arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXShutter, 1); arg2 = NUM2INT(argv[0]); FXShutter_setCurrent(arg1,arg2);
    return Qnil; }
static VALUE _wrap_FXSplitter_onLeftBtnPress(int argc, VALUE *argv, VALUE self) { FXSplitter *arg1 = (FXSplitter *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSplitter, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onLeftBtnPress(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXSplitter_onLeftBtnRelease(int argc, VALUE *argv, VALUE self) { FXSplitter *arg1 = (FXSplitter *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSplitter, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onLeftBtnRelease(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXSplitter_onMotion(int argc, VALUE *argv, VALUE self) { FXSplitter *arg1 = (FXSplitter *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSplitter, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onMotion(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXSplitter_onFocusNext(int argc, VALUE *argv, VALUE self) { FXSplitter *arg1 = (FXSplitter *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSplitter, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onFocusNext(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXSplitter_onFocusPrev(int argc, VALUE *argv, VALUE self) { FXSplitter *arg1 = (FXSplitter *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSplitter, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onFocusPrev(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXSplitter_onFocusUp(int argc, VALUE *argv, VALUE self) { FXSplitter *arg1 = (FXSplitter *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSplitter, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onFocusUp(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXSplitter_onFocusDown(int argc, VALUE *argv, VALUE self) { FXSplitter *arg1 = (FXSplitter *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSplitter, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onFocusDown(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXSplitter_onFocusLeft(int argc, VALUE *argv, VALUE self) { FXSplitter *arg1 = (FXSplitter *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSplitter, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onFocusLeft(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXSplitter_onFocusRight(int argc, VALUE *argv, VALUE self) { FXSplitter *arg1 = (FXSplitter *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSplitter, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onFocusRight(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_new_FXSplitter__SWIG_0(int argc, VALUE *argv, VALUE self) { FXComposite *arg1 = (FXComposite *) 0 ;
    FXuint arg2 = (FXuint) SPLITTER_NORMAL ; FXint arg3 = (FXint) 0 ; FXint arg4 = (FXint) 0 ; FXint arg5 = (FXint) 0 ;
    FXint arg6 = (FXint) 0 ; FXSplitter *result; if ((argc < 1) || (argc > 6))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXComposite, 1); if (argc > 1) { arg2 = NUM2UINT(argv[1]); } 
    if (argc > 2) { arg3 = NUM2INT(argv[2]); }  if (argc > 3) { arg4 = NUM2INT(argv[3]); }  if (argc > 4) {
        arg5 = NUM2INT(argv[4]); }  if (argc > 5) { arg6 = NUM2INT(argv[5]); }  {
        result = (FXSplitter *)new_FXSplitter__SWIG_0(arg1,arg2,arg3,arg4,arg5,arg6);
        DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result); if(rb_block_given_p()){ rb_yield(self); }  }  return self; }
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE _wrap_FXSplitter_allocate(VALUE self) {
#else
     static VALUE _wrap_FXSplitter_allocate(int argc, VALUE *argv, VALUE self) {
#endif
         VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_FXSplitter);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
         return vresult; }
static VALUE _wrap_new_FXSplitter__SWIG_1(int argc, VALUE *argv, VALUE self) { FXComposite *arg1 = (FXComposite *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; FXuint arg4 = (FXuint) SPLITTER_NORMAL ; FXint arg5 = (FXint) 0 ;
    FXint arg6 = (FXint) 0 ; FXint arg7 = (FXint) 0 ; FXint arg8 = (FXint) 0 ; FXSplitter *result; if ((argc < 3) || (argc > 8))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXComposite, 1);
    SWIG_ConvertPtr(argv[1], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[2]); if (argc > 3) {
        arg4 = NUM2UINT(argv[3]); }  if (argc > 4) { arg5 = NUM2INT(argv[4]); }  if (argc > 5) { arg6 = NUM2INT(argv[5]); } 
    if (argc > 6) { arg7 = NUM2INT(argv[6]); }  if (argc > 7) { arg8 = NUM2INT(argv[7]); }  {
        result = (FXSplitter *)new_FXSplitter__SWIG_1(arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8);
        DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result); if(rb_block_given_p()){ rb_yield(self); }  }  return self; }
static VALUE _wrap_new_FXSplitter(int nargs, VALUE *args, VALUE self) { int argc; VALUE argv[8]; int ii; argc = nargs;
    for (ii = 0; (ii < argc) && (ii < 8); ii++) { argv[ii] = args[ii]; }  if ((argc >= 1) && (argc <= 6)) { int _v; { void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXComposite, 0) != -1)) ? 1 : 0; }
         if (_v) { if (argc <= 1) { return _wrap_new_FXSplitter__SWIG_0(nargs, args, self);}  {
                _v = ((TYPE(argv[1]) == T_FIXNUM) || (TYPE(argv[1]) == T_BIGNUM)) ? 1 : 0; }  if (_v) { if (argc <= 2) {
                    return _wrap_new_FXSplitter__SWIG_0(nargs, args, self);}  {
                    _v = ((TYPE(argv[2]) == T_FIXNUM) || (TYPE(argv[2]) == T_BIGNUM)) ? 1 : 0; }  if (_v) { if (argc <= 3) {
                        return _wrap_new_FXSplitter__SWIG_0(nargs, args, self);}  {
                        _v = ((TYPE(argv[3]) == T_FIXNUM) || (TYPE(argv[3]) == T_BIGNUM)) ? 1 : 0; }  if (_v) { if (argc <= 4) {
                            return _wrap_new_FXSplitter__SWIG_0(nargs, args, self);}  {
                            _v = ((TYPE(argv[4]) == T_FIXNUM) || (TYPE(argv[4]) == T_BIGNUM)) ? 1 : 0; }  if (_v) {
                            if (argc <= 5) { return _wrap_new_FXSplitter__SWIG_0(nargs, args, self);}  {
                                _v = ((TYPE(argv[5]) == T_FIXNUM) || (TYPE(argv[5]) == T_BIGNUM)) ? 1 : 0; }  if (_v) {
                                return _wrap_new_FXSplitter__SWIG_0(nargs, args, self);}  }  }  }  }  }  } 
    if ((argc >= 3) && (argc <= 8)) { int _v; { void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXComposite, 0) != -1)) ? 1 : 0; }
         if (_v) { { void *ptr;
                _v = (NIL_P(argv[1]) || (TYPE(argv[1]) == T_DATA && SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_FXObject, 0) != -1)) ? 1 : 0; }
             if (_v) { { _v = ((TYPE(argv[2]) == T_FIXNUM) || (TYPE(argv[2]) == T_BIGNUM)) ? 1 : 0; }  if (_v) {
                    if (argc <= 3) { return _wrap_new_FXSplitter__SWIG_1(nargs, args, self);}  {
                        _v = ((TYPE(argv[3]) == T_FIXNUM) || (TYPE(argv[3]) == T_BIGNUM)) ? 1 : 0; }  if (_v) { if (argc <= 4) {
                            return _wrap_new_FXSplitter__SWIG_1(nargs, args, self);}  {
                            _v = ((TYPE(argv[4]) == T_FIXNUM) || (TYPE(argv[4]) == T_BIGNUM)) ? 1 : 0; }  if (_v) {
                            if (argc <= 5) { return _wrap_new_FXSplitter__SWIG_1(nargs, args, self);}  {
                                _v = ((TYPE(argv[5]) == T_FIXNUM) || (TYPE(argv[5]) == T_BIGNUM)) ? 1 : 0; }  if (_v) {
                                if (argc <= 6) { return _wrap_new_FXSplitter__SWIG_1(nargs, args, self);}  {
                                    _v = ((TYPE(argv[6]) == T_FIXNUM) || (TYPE(argv[6]) == T_BIGNUM)) ? 1 : 0; }  if (_v) {
                                    if (argc <= 7) { return _wrap_new_FXSplitter__SWIG_1(nargs, args, self);}  {
                                        _v = ((TYPE(argv[7]) == T_FIXNUM) || (TYPE(argv[7]) == T_BIGNUM)) ? 1 : 0; }  if (_v) {
                                        return _wrap_new_FXSplitter__SWIG_1(nargs, args, self);}  }  }  }  }  }  }  }  } 
    rb_raise(rb_eArgError, "No matching function for overloaded 'new_FXSplitter'"); return Qnil; }
static VALUE _wrap_FXSplitter_getSplit(int argc, VALUE *argv, VALUE self) { FXSplitter *arg1 = (FXSplitter *) 0 ; FXint arg2 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSplitter, 1); arg2 = NUM2INT(argv[0]); {
        if (arg2 < 0 || arg2 >= arg1->numChildren()) { rb_raise(rb_eIndexError, "splitter panel index out of bounds"); }  } 
    result = (FXint)((FXSplitter const *)arg1)->getSplit(arg2); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXSplitter_setSplit(int argc, VALUE *argv, VALUE self) { FXSplitter *arg1 = (FXSplitter *) 0 ; FXint arg2 ;
    FXint arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSplitter, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]); {
        if (arg2 < 0 || arg2 >= arg1->numChildren()) { rb_raise(rb_eIndexError, "splitter panel index out of bounds"); }  } 
    (arg1)->setSplit(arg2,arg3); return Qnil; }
static VALUE _wrap_FXSplitter_setSplitterStyle(int argc, VALUE *argv, VALUE self) { FXSplitter *arg1 = (FXSplitter *) 0 ;
    FXuint arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSplitter, 1); arg2 = NUM2UINT(argv[0]); (arg1)->setSplitterStyle(arg2);
    return Qnil; }
static VALUE _wrap_FXSplitter_getSplitterStyle(int argc, VALUE *argv, VALUE self) { FXSplitter *arg1 = (FXSplitter *) 0 ;
    FXuint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSplitter, 1);
    result = (FXuint)((FXSplitter const *)arg1)->getSplitterStyle(); vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXSplitter_setBarSize(int argc, VALUE *argv, VALUE self) { FXSplitter *arg1 = (FXSplitter *) 0 ; FXint arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSplitter, 1); arg2 = NUM2INT(argv[0]); (arg1)->setBarSize(arg2);
    return Qnil; }
static VALUE _wrap_FXSplitter_getBarSize(int argc, VALUE *argv, VALUE self) { FXSplitter *arg1 = (FXSplitter *) 0 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSplitter, 1); result = (FXint)((FXSplitter const *)arg1)->getBarSize();
    vresult = INT2NUM(result); return vresult; }
static void
free_FXSplitter(FXSplitter *arg1) {
    delete arg1;
}
static VALUE _wrap_FXSplitter_save(int argc, VALUE *argv, VALUE self) { FXSplitter *arg1 = (FXSplitter *) 0 ;
    FXStream *arg2 = 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSplitter, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXSplitter_save((FXSplitter const *)arg1,*arg2); return Qnil; }
static VALUE _wrap_FXSplitter_load(int argc, VALUE *argv, VALUE self) { FXSplitter *arg1 = (FXSplitter *) 0 ;
    FXStream *arg2 = 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSplitter, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXSplitter_load(arg1,*arg2); return Qnil; }
static VALUE _wrap_FXSplitter_create(int argc, VALUE *argv, VALUE self) { FXSplitter *arg1 = (FXSplitter *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSplitter, 1); FXSplitter_create(arg1); return Qnil; }
static VALUE _wrap_FXSplitter_detach(int argc, VALUE *argv, VALUE self) { FXSplitter *arg1 = (FXSplitter *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSplitter, 1); FXSplitter_detach(arg1); return Qnil; }
static VALUE _wrap_FXSplitter_destroy(int argc, VALUE *argv, VALUE self) { FXSplitter *arg1 = (FXSplitter *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSplitter, 1); FXSplitter_destroy(arg1); return Qnil; }
static VALUE _wrap_FXSplitter_resize(int argc, VALUE *argv, VALUE self) { FXSplitter *arg1 = (FXSplitter *) 0 ; FXint arg2 ;
    FXint arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSplitter, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    FXSplitter_resize(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXSplitter_getDefaultWidth(int argc, VALUE *argv, VALUE self) { FXSplitter *arg1 = (FXSplitter *) 0 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSplitter, 1); result = (FXint)FXSplitter_getDefaultWidth(arg1);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXSplitter_getDefaultHeight(int argc, VALUE *argv, VALUE self) { FXSplitter *arg1 = (FXSplitter *) 0 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSplitter, 1); result = (FXint)FXSplitter_getDefaultHeight(arg1);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXSplitter_getWidthForHeight(int argc, VALUE *argv, VALUE self) { FXSplitter *arg1 = (FXSplitter *) 0 ;
    FXint arg2 ; FXint result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSplitter, 1); arg2 = NUM2INT(argv[0]);
    result = (FXint)FXSplitter_getWidthForHeight(arg1,arg2); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXSplitter_getHeightForWidth(int argc, VALUE *argv, VALUE self) { FXSplitter *arg1 = (FXSplitter *) 0 ;
    FXint arg2 ; FXint result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSplitter, 1); arg2 = NUM2INT(argv[0]);
    result = (FXint)FXSplitter_getHeightForWidth(arg1,arg2); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXSplitter_canFocus(int argc, VALUE *argv, VALUE self) { FXSplitter *arg1 = (FXSplitter *) 0 ; FXbool result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSplitter, 1);
    result = (FXbool)FXSplitter_canFocus((FXSplitter const *)arg1); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXSplitter_setFocus(int argc, VALUE *argv, VALUE self) { FXSplitter *arg1 = (FXSplitter *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSplitter, 1); FXSplitter_setFocus(arg1); return Qnil; }
static VALUE _wrap_FXSplitter_killFocus(int argc, VALUE *argv, VALUE self) { FXSplitter *arg1 = (FXSplitter *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSplitter, 1); FXSplitter_killFocus(arg1); return Qnil; }
static VALUE _wrap_FXSplitter_setDefault(int argc, VALUE *argv, VALUE self) { FXSplitter *arg1 = (FXSplitter *) 0 ;
    FXbool arg2 = (FXbool) 1 ; if ((argc < 0) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSplitter, 1); if (argc > 0) { arg2 = to_FXbool(argv[0]); } 
    FXSplitter_setDefault(arg1,arg2); return Qnil; }
static VALUE _wrap_FXSplitter_enable(int argc, VALUE *argv, VALUE self) { FXSplitter *arg1 = (FXSplitter *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSplitter, 1); FXSplitter_enable(arg1); return Qnil; }
static VALUE _wrap_FXSplitter_disable(int argc, VALUE *argv, VALUE self) { FXSplitter *arg1 = (FXSplitter *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSplitter, 1); FXSplitter_disable(arg1); return Qnil; }
static VALUE _wrap_FXSplitter_raiseWindow(int argc, VALUE *argv, VALUE self) { FXSplitter *arg1 = (FXSplitter *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSplitter, 1); FXSplitter_raise(arg1); return Qnil; }
static VALUE _wrap_FXSplitter_lower(int argc, VALUE *argv, VALUE self) { FXSplitter *arg1 = (FXSplitter *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSplitter, 1); FXSplitter_lower(arg1); return Qnil; }
static VALUE _wrap_FXSplitter_move(int argc, VALUE *argv, VALUE self) { FXSplitter *arg1 = (FXSplitter *) 0 ; FXint arg2 ;
    FXint arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSplitter, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    FXSplitter_move(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXSplitter_position(int argc, VALUE *argv, VALUE self) { FXSplitter *arg1 = (FXSplitter *) 0 ; FXint arg2 ;
    FXint arg3 ; FXint arg4 ; FXint arg5 ; if ((argc < 4) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSplitter, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    arg4 = NUM2INT(argv[2]); arg5 = NUM2INT(argv[3]); FXSplitter_position(arg1,arg2,arg3,arg4,arg5); return Qnil; }
static VALUE _wrap_FXSplitter_layout(int argc, VALUE *argv, VALUE self) { FXSplitter *arg1 = (FXSplitter *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSplitter, 1); FXSplitter_layout(arg1); return Qnil; }
static VALUE _wrap_FXSplitter_recalc(int argc, VALUE *argv, VALUE self) { FXSplitter *arg1 = (FXSplitter *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSplitter, 1); FXSplitter_recalc(arg1); return Qnil; }
static VALUE _wrap_FXSplitter_reparent(int argc, VALUE *argv, VALUE self) { FXSplitter *arg1 = (FXSplitter *) 0 ;
    FXComposite *arg2 = (FXComposite *) 0 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSplitter, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXComposite, 1); FXSplitter_reparent(arg1,arg2); return Qnil; }
static VALUE _wrap_FXSplitter_show(int argc, VALUE *argv, VALUE self) { FXSplitter *arg1 = (FXSplitter *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSplitter, 1); FXSplitter_show(arg1); return Qnil; }
static VALUE _wrap_FXSplitter_hide(int argc, VALUE *argv, VALUE self) { FXSplitter *arg1 = (FXSplitter *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSplitter, 1); FXSplitter_hide(arg1); return Qnil; }
static VALUE _wrap_FXSplitter_isComposite(int argc, VALUE *argv, VALUE self) { FXSplitter *arg1 = (FXSplitter *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSplitter, 1);
    result = (FXbool)FXSplitter_isComposite((FXSplitter const *)arg1); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXSplitter_contains(int argc, VALUE *argv, VALUE self) { FXSplitter *arg1 = (FXSplitter *) 0 ; FXint arg2 ;
    FXint arg3 ; FXbool result; VALUE vresult = Qnil; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSplitter, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    result = (FXbool)FXSplitter_contains((FXSplitter const *)arg1,arg2,arg3); vresult = result ? Qtrue : Qfalse;
    return vresult; }
static VALUE _wrap_FXSplitter_doesSaveUnder(int argc, VALUE *argv, VALUE self) { FXSplitter *arg1 = (FXSplitter *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSplitter, 1);
    result = (FXbool)FXSplitter_doesSaveUnder((FXSplitter const *)arg1); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXSplitter_setBackColor(int argc, VALUE *argv, VALUE self) { FXSplitter *arg1 = (FXSplitter *) 0 ;
    FXColor arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXSplitter, 1); arg2 = to_FXColor(argv[0]);
    FXSplitter_setBackColor(arg1,arg2); return Qnil; }
static VALUE _wrap_FX4Splitter_onLeftBtnPress(int argc, VALUE *argv, VALUE self) { FX4Splitter *arg1 = (FX4Splitter *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FX4Splitter, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onLeftBtnPress(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FX4Splitter_onLeftBtnRelease(int argc, VALUE *argv, VALUE self) { FX4Splitter *arg1 = (FX4Splitter *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FX4Splitter, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onLeftBtnRelease(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FX4Splitter_onMotion(int argc, VALUE *argv, VALUE self) { FX4Splitter *arg1 = (FX4Splitter *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FX4Splitter, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onMotion(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FX4Splitter_onFocusUp(int argc, VALUE *argv, VALUE self) { FX4Splitter *arg1 = (FX4Splitter *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FX4Splitter, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onFocusUp(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FX4Splitter_onFocusDown(int argc, VALUE *argv, VALUE self) { FX4Splitter *arg1 = (FX4Splitter *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FX4Splitter, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onFocusDown(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FX4Splitter_onFocusLeft(int argc, VALUE *argv, VALUE self) { FX4Splitter *arg1 = (FX4Splitter *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FX4Splitter, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onFocusLeft(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FX4Splitter_onFocusRight(int argc, VALUE *argv, VALUE self) { FX4Splitter *arg1 = (FX4Splitter *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FX4Splitter, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onFocusRight(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FX4Splitter_onCmdExpand(int argc, VALUE *argv, VALUE self) { FX4Splitter *arg1 = (FX4Splitter *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FX4Splitter, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]);
    SWIG_ConvertPtr(argv[2], (void **) &arg4, 0, 1); result = (long)(arg1)->onCmdExpand(arg2,arg3,arg4);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FX4Splitter_onUpdExpand(int argc, VALUE *argv, VALUE self) { FX4Splitter *arg1 = (FX4Splitter *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FX4Splitter, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]);
    SWIG_ConvertPtr(argv[2], (void **) &arg4, 0, 1); result = (long)(arg1)->onUpdExpand(arg2,arg3,arg4);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_new_FX4Splitter__SWIG_0(int argc, VALUE *argv, VALUE self) { FXComposite *arg1 = (FXComposite *) 0 ;
    FXuint arg2 = (FXuint) FOURSPLITTER_NORMAL ; FXint arg3 = (FXint) 0 ; FXint arg4 = (FXint) 0 ; FXint arg5 = (FXint) 0 ;
    FXint arg6 = (FXint) 0 ; FX4Splitter *result; if ((argc < 1) || (argc > 6))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXComposite, 1); if (argc > 1) { arg2 = NUM2UINT(argv[1]); } 
    if (argc > 2) { arg3 = NUM2INT(argv[2]); }  if (argc > 3) { arg4 = NUM2INT(argv[3]); }  if (argc > 4) {
        arg5 = NUM2INT(argv[4]); }  if (argc > 5) { arg6 = NUM2INT(argv[5]); }  {
        result = (FX4Splitter *)new_FX4Splitter__SWIG_0(arg1,arg2,arg3,arg4,arg5,arg6);
        DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result); if(rb_block_given_p()){ rb_yield(self); }  }  return self; }
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE _wrap_FX4Splitter_allocate(VALUE self) {
#else
     static VALUE _wrap_FX4Splitter_allocate(int argc, VALUE *argv, VALUE self) {
#endif
         VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_FX4Splitter);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
         return vresult; }
static VALUE _wrap_new_FX4Splitter__SWIG_1(int argc, VALUE *argv, VALUE self) { FXComposite *arg1 = (FXComposite *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; FXuint arg4 = (FXuint) FOURSPLITTER_NORMAL ; FXint arg5 = (FXint) 0 ;
    FXint arg6 = (FXint) 0 ; FXint arg7 = (FXint) 0 ; FXint arg8 = (FXint) 0 ; FX4Splitter *result;
    if ((argc < 3) || (argc > 8)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXComposite, 1);
    SWIG_ConvertPtr(argv[1], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[2]); if (argc > 3) {
        arg4 = NUM2UINT(argv[3]); }  if (argc > 4) { arg5 = NUM2INT(argv[4]); }  if (argc > 5) { arg6 = NUM2INT(argv[5]); } 
    if (argc > 6) { arg7 = NUM2INT(argv[6]); }  if (argc > 7) { arg8 = NUM2INT(argv[7]); }  {
        result = (FX4Splitter *)new_FX4Splitter__SWIG_1(arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8);
        DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result); if(rb_block_given_p()){ rb_yield(self); }  }  return self; }
static VALUE _wrap_new_FX4Splitter(int nargs, VALUE *args, VALUE self) { int argc; VALUE argv[8]; int ii; argc = nargs;
    for (ii = 0; (ii < argc) && (ii < 8); ii++) { argv[ii] = args[ii]; }  if ((argc >= 1) && (argc <= 6)) { int _v; { void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXComposite, 0) != -1)) ? 1 : 0; }
         if (_v) { if (argc <= 1) { return _wrap_new_FX4Splitter__SWIG_0(nargs, args, self);}  {
                _v = ((TYPE(argv[1]) == T_FIXNUM) || (TYPE(argv[1]) == T_BIGNUM)) ? 1 : 0; }  if (_v) { if (argc <= 2) {
                    return _wrap_new_FX4Splitter__SWIG_0(nargs, args, self);}  {
                    _v = ((TYPE(argv[2]) == T_FIXNUM) || (TYPE(argv[2]) == T_BIGNUM)) ? 1 : 0; }  if (_v) { if (argc <= 3) {
                        return _wrap_new_FX4Splitter__SWIG_0(nargs, args, self);}  {
                        _v = ((TYPE(argv[3]) == T_FIXNUM) || (TYPE(argv[3]) == T_BIGNUM)) ? 1 : 0; }  if (_v) { if (argc <= 4) {
                            return _wrap_new_FX4Splitter__SWIG_0(nargs, args, self);}  {
                            _v = ((TYPE(argv[4]) == T_FIXNUM) || (TYPE(argv[4]) == T_BIGNUM)) ? 1 : 0; }  if (_v) {
                            if (argc <= 5) { return _wrap_new_FX4Splitter__SWIG_0(nargs, args, self);}  {
                                _v = ((TYPE(argv[5]) == T_FIXNUM) || (TYPE(argv[5]) == T_BIGNUM)) ? 1 : 0; }  if (_v) {
                                return _wrap_new_FX4Splitter__SWIG_0(nargs, args, self);}  }  }  }  }  }  } 
    if ((argc >= 3) && (argc <= 8)) { int _v; { void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXComposite, 0) != -1)) ? 1 : 0; }
         if (_v) { { void *ptr;
                _v = (NIL_P(argv[1]) || (TYPE(argv[1]) == T_DATA && SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_FXObject, 0) != -1)) ? 1 : 0; }
             if (_v) { { _v = ((TYPE(argv[2]) == T_FIXNUM) || (TYPE(argv[2]) == T_BIGNUM)) ? 1 : 0; }  if (_v) {
                    if (argc <= 3) { return _wrap_new_FX4Splitter__SWIG_1(nargs, args, self);}  {
                        _v = ((TYPE(argv[3]) == T_FIXNUM) || (TYPE(argv[3]) == T_BIGNUM)) ? 1 : 0; }  if (_v) { if (argc <= 4) {
                            return _wrap_new_FX4Splitter__SWIG_1(nargs, args, self);}  {
                            _v = ((TYPE(argv[4]) == T_FIXNUM) || (TYPE(argv[4]) == T_BIGNUM)) ? 1 : 0; }  if (_v) {
                            if (argc <= 5) { return _wrap_new_FX4Splitter__SWIG_1(nargs, args, self);}  {
                                _v = ((TYPE(argv[5]) == T_FIXNUM) || (TYPE(argv[5]) == T_BIGNUM)) ? 1 : 0; }  if (_v) {
                                if (argc <= 6) { return _wrap_new_FX4Splitter__SWIG_1(nargs, args, self);}  {
                                    _v = ((TYPE(argv[6]) == T_FIXNUM) || (TYPE(argv[6]) == T_BIGNUM)) ? 1 : 0; }  if (_v) {
                                    if (argc <= 7) { return _wrap_new_FX4Splitter__SWIG_1(nargs, args, self);}  {
                                        _v = ((TYPE(argv[7]) == T_FIXNUM) || (TYPE(argv[7]) == T_BIGNUM)) ? 1 : 0; }  if (_v) {
                                        return _wrap_new_FX4Splitter__SWIG_1(nargs, args, self);}  }  }  }  }  }  }  }  } 
    rb_raise(rb_eArgError, "No matching function for overloaded 'new_FX4Splitter'"); return Qnil; }
static VALUE _wrap_FX4Splitter_getTopLeft(int argc, VALUE *argv, VALUE self) { FX4Splitter *arg1 = (FX4Splitter *) 0 ;
    FXWindow *result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FX4Splitter, 1);
    result = (FXWindow *)((FX4Splitter const *)arg1)->getTopLeft(); {
        swig_type_info *ty = SWIG_TypeDynamicCast(SWIGTYPE_p_FXWindow, (void **) &result);
        vresult = FXRbGetRubyObj(result, ty); }  return vresult; }
static VALUE _wrap_FX4Splitter_getTopRight(int argc, VALUE *argv, VALUE self) { FX4Splitter *arg1 = (FX4Splitter *) 0 ;
    FXWindow *result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FX4Splitter, 1);
    result = (FXWindow *)((FX4Splitter const *)arg1)->getTopRight(); {
        swig_type_info *ty = SWIG_TypeDynamicCast(SWIGTYPE_p_FXWindow, (void **) &result);
        vresult = FXRbGetRubyObj(result, ty); }  return vresult; }
static VALUE _wrap_FX4Splitter_getBottomLeft(int argc, VALUE *argv, VALUE self) { FX4Splitter *arg1 = (FX4Splitter *) 0 ;
    FXWindow *result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FX4Splitter, 1);
    result = (FXWindow *)((FX4Splitter const *)arg1)->getBottomLeft(); {
        swig_type_info *ty = SWIG_TypeDynamicCast(SWIGTYPE_p_FXWindow, (void **) &result);
        vresult = FXRbGetRubyObj(result, ty); }  return vresult; }
static VALUE _wrap_FX4Splitter_getBottomRight(int argc, VALUE *argv, VALUE self) { FX4Splitter *arg1 = (FX4Splitter *) 0 ;
    FXWindow *result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FX4Splitter, 1);
    result = (FXWindow *)((FX4Splitter const *)arg1)->getBottomRight(); {
        swig_type_info *ty = SWIG_TypeDynamicCast(SWIGTYPE_p_FXWindow, (void **) &result);
        vresult = FXRbGetRubyObj(result, ty); }  return vresult; }
static VALUE _wrap_FX4Splitter_getHSplit(int argc, VALUE *argv, VALUE self) { FX4Splitter *arg1 = (FX4Splitter *) 0 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FX4Splitter, 1); result = (FXint)((FX4Splitter const *)arg1)->getHSplit();
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FX4Splitter_getVSplit(int argc, VALUE *argv, VALUE self) { FX4Splitter *arg1 = (FX4Splitter *) 0 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FX4Splitter, 1); result = (FXint)((FX4Splitter const *)arg1)->getVSplit();
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FX4Splitter_setHSplit(int argc, VALUE *argv, VALUE self) { FX4Splitter *arg1 = (FX4Splitter *) 0 ;
    FXint arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FX4Splitter, 1); arg2 = NUM2INT(argv[0]); (arg1)->setHSplit(arg2);
    return Qnil; }
static VALUE _wrap_FX4Splitter_setVSplit(int argc, VALUE *argv, VALUE self) { FX4Splitter *arg1 = (FX4Splitter *) 0 ;
    FXint arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FX4Splitter, 1); arg2 = NUM2INT(argv[0]); (arg1)->setVSplit(arg2);
    return Qnil; }
static VALUE _wrap_FX4Splitter_getSplitterStyle(int argc, VALUE *argv, VALUE self) { FX4Splitter *arg1 = (FX4Splitter *) 0 ;
    FXuint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FX4Splitter, 1);
    result = (FXuint)((FX4Splitter const *)arg1)->getSplitterStyle(); vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FX4Splitter_setSplitterStyle(int argc, VALUE *argv, VALUE self) { FX4Splitter *arg1 = (FX4Splitter *) 0 ;
    FXuint arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FX4Splitter, 1); arg2 = NUM2UINT(argv[0]); (arg1)->setSplitterStyle(arg2);
    return Qnil; }
static VALUE _wrap_FX4Splitter_setBarSize(int argc, VALUE *argv, VALUE self) { FX4Splitter *arg1 = (FX4Splitter *) 0 ;
    FXint arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FX4Splitter, 1); arg2 = NUM2INT(argv[0]); (arg1)->setBarSize(arg2);
    return Qnil; }
static VALUE _wrap_FX4Splitter_getBarSize(int argc, VALUE *argv, VALUE self) { FX4Splitter *arg1 = (FX4Splitter *) 0 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FX4Splitter, 1);
    result = (FXint)((FX4Splitter const *)arg1)->getBarSize(); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FX4Splitter_setExpanded(int argc, VALUE *argv, VALUE self) { FX4Splitter *arg1 = (FX4Splitter *) 0 ;
    FXint arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FX4Splitter, 1); arg2 = NUM2INT(argv[0]); (arg1)->setExpanded(arg2);
    return Qnil; }
static VALUE _wrap_FX4Splitter_getExpanded(int argc, VALUE *argv, VALUE self) { FX4Splitter *arg1 = (FX4Splitter *) 0 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FX4Splitter, 1);
    result = (FXint)((FX4Splitter const *)arg1)->getExpanded(); vresult = INT2NUM(result); return vresult; }
static void
free_FX4Splitter(FX4Splitter *arg1) {
    delete arg1;
}
static VALUE _wrap_FX4Splitter_save(int argc, VALUE *argv, VALUE self) { FX4Splitter *arg1 = (FX4Splitter *) 0 ;
    FXStream *arg2 = 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FX4Splitter, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FX4Splitter_save((FX4Splitter const *)arg1,*arg2); return Qnil; }
static VALUE _wrap_FX4Splitter_load(int argc, VALUE *argv, VALUE self) { FX4Splitter *arg1 = (FX4Splitter *) 0 ;
    FXStream *arg2 = 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FX4Splitter, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FX4Splitter_load(arg1,*arg2); return Qnil; }
static VALUE _wrap_FX4Splitter_create(int argc, VALUE *argv, VALUE self) { FX4Splitter *arg1 = (FX4Splitter *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FX4Splitter, 1); FX4Splitter_create(arg1); return Qnil; }
static VALUE _wrap_FX4Splitter_detach(int argc, VALUE *argv, VALUE self) { FX4Splitter *arg1 = (FX4Splitter *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FX4Splitter, 1); FX4Splitter_detach(arg1); return Qnil; }
static VALUE _wrap_FX4Splitter_destroy(int argc, VALUE *argv, VALUE self) { FX4Splitter *arg1 = (FX4Splitter *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FX4Splitter, 1); FX4Splitter_destroy(arg1); return Qnil; }
static VALUE _wrap_FX4Splitter_resize(int argc, VALUE *argv, VALUE self) { FX4Splitter *arg1 = (FX4Splitter *) 0 ; FXint arg2 ;
    FXint arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FX4Splitter, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    FX4Splitter_resize(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FX4Splitter_getDefaultWidth(int argc, VALUE *argv, VALUE self) { FX4Splitter *arg1 = (FX4Splitter *) 0 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FX4Splitter, 1); result = (FXint)FX4Splitter_getDefaultWidth(arg1);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FX4Splitter_getDefaultHeight(int argc, VALUE *argv, VALUE self) { FX4Splitter *arg1 = (FX4Splitter *) 0 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FX4Splitter, 1); result = (FXint)FX4Splitter_getDefaultHeight(arg1);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FX4Splitter_getWidthForHeight(int argc, VALUE *argv, VALUE self) { FX4Splitter *arg1 = (FX4Splitter *) 0 ;
    FXint arg2 ; FXint result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FX4Splitter, 1); arg2 = NUM2INT(argv[0]);
    result = (FXint)FX4Splitter_getWidthForHeight(arg1,arg2); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FX4Splitter_getHeightForWidth(int argc, VALUE *argv, VALUE self) { FX4Splitter *arg1 = (FX4Splitter *) 0 ;
    FXint arg2 ; FXint result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FX4Splitter, 1); arg2 = NUM2INT(argv[0]);
    result = (FXint)FX4Splitter_getHeightForWidth(arg1,arg2); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FX4Splitter_canFocus(int argc, VALUE *argv, VALUE self) { FX4Splitter *arg1 = (FX4Splitter *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FX4Splitter, 1);
    result = (FXbool)FX4Splitter_canFocus((FX4Splitter const *)arg1); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FX4Splitter_setFocus(int argc, VALUE *argv, VALUE self) { FX4Splitter *arg1 = (FX4Splitter *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FX4Splitter, 1); FX4Splitter_setFocus(arg1); return Qnil; }
static VALUE _wrap_FX4Splitter_killFocus(int argc, VALUE *argv, VALUE self) { FX4Splitter *arg1 = (FX4Splitter *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FX4Splitter, 1); FX4Splitter_killFocus(arg1); return Qnil; }
static VALUE _wrap_FX4Splitter_setDefault(int argc, VALUE *argv, VALUE self) { FX4Splitter *arg1 = (FX4Splitter *) 0 ;
    FXbool arg2 = (FXbool) 1 ; if ((argc < 0) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FX4Splitter, 1); if (argc > 0) { arg2 = to_FXbool(argv[0]); } 
    FX4Splitter_setDefault(arg1,arg2); return Qnil; }
static VALUE _wrap_FX4Splitter_enable(int argc, VALUE *argv, VALUE self) { FX4Splitter *arg1 = (FX4Splitter *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FX4Splitter, 1); FX4Splitter_enable(arg1); return Qnil; }
static VALUE _wrap_FX4Splitter_disable(int argc, VALUE *argv, VALUE self) { FX4Splitter *arg1 = (FX4Splitter *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FX4Splitter, 1); FX4Splitter_disable(arg1); return Qnil; }
static VALUE _wrap_FX4Splitter_raiseWindow(int argc, VALUE *argv, VALUE self) { FX4Splitter *arg1 = (FX4Splitter *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FX4Splitter, 1); FX4Splitter_raise(arg1); return Qnil; }
static VALUE _wrap_FX4Splitter_lower(int argc, VALUE *argv, VALUE self) { FX4Splitter *arg1 = (FX4Splitter *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FX4Splitter, 1); FX4Splitter_lower(arg1); return Qnil; }
static VALUE _wrap_FX4Splitter_move(int argc, VALUE *argv, VALUE self) { FX4Splitter *arg1 = (FX4Splitter *) 0 ; FXint arg2 ;
    FXint arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FX4Splitter, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    FX4Splitter_move(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FX4Splitter_position(int argc, VALUE *argv, VALUE self) { FX4Splitter *arg1 = (FX4Splitter *) 0 ;
    FXint arg2 ; FXint arg3 ; FXint arg4 ; FXint arg5 ; if ((argc < 4) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FX4Splitter, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    arg4 = NUM2INT(argv[2]); arg5 = NUM2INT(argv[3]); FX4Splitter_position(arg1,arg2,arg3,arg4,arg5); return Qnil; }
static VALUE _wrap_FX4Splitter_layout(int argc, VALUE *argv, VALUE self) { FX4Splitter *arg1 = (FX4Splitter *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FX4Splitter, 1); FX4Splitter_layout(arg1); return Qnil; }
static VALUE _wrap_FX4Splitter_recalc(int argc, VALUE *argv, VALUE self) { FX4Splitter *arg1 = (FX4Splitter *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FX4Splitter, 1); FX4Splitter_recalc(arg1); return Qnil; }
static VALUE _wrap_FX4Splitter_reparent(int argc, VALUE *argv, VALUE self) { FX4Splitter *arg1 = (FX4Splitter *) 0 ;
    FXComposite *arg2 = (FXComposite *) 0 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FX4Splitter, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXComposite, 1); FX4Splitter_reparent(arg1,arg2); return Qnil; }
static VALUE _wrap_FX4Splitter_show(int argc, VALUE *argv, VALUE self) { FX4Splitter *arg1 = (FX4Splitter *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FX4Splitter, 1); FX4Splitter_show(arg1); return Qnil; }
static VALUE _wrap_FX4Splitter_hide(int argc, VALUE *argv, VALUE self) { FX4Splitter *arg1 = (FX4Splitter *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FX4Splitter, 1); FX4Splitter_hide(arg1); return Qnil; }
static VALUE _wrap_FX4Splitter_isComposite(int argc, VALUE *argv, VALUE self) { FX4Splitter *arg1 = (FX4Splitter *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FX4Splitter, 1);
    result = (FXbool)FX4Splitter_isComposite((FX4Splitter const *)arg1); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FX4Splitter_contains(int argc, VALUE *argv, VALUE self) { FX4Splitter *arg1 = (FX4Splitter *) 0 ;
    FXint arg2 ; FXint arg3 ; FXbool result; VALUE vresult = Qnil; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FX4Splitter, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    result = (FXbool)FX4Splitter_contains((FX4Splitter const *)arg1,arg2,arg3); vresult = result ? Qtrue : Qfalse;
    return vresult; }
static VALUE _wrap_FX4Splitter_doesSaveUnder(int argc, VALUE *argv, VALUE self) { FX4Splitter *arg1 = (FX4Splitter *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FX4Splitter, 1);
    result = (FXbool)FX4Splitter_doesSaveUnder((FX4Splitter const *)arg1); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FX4Splitter_setBackColor(int argc, VALUE *argv, VALUE self) { FX4Splitter *arg1 = (FX4Splitter *) 0 ;
    FXColor arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FX4Splitter, 1); arg2 = to_FXColor(argv[0]);
    FX4Splitter_setBackColor(arg1,arg2); return Qnil; }
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE _wrap_FXStatusBar_allocate(VALUE self) {
#else
     static VALUE _wrap_FXStatusBar_allocate(int argc, VALUE *argv, VALUE self) {
#endif
         VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_FXStatusBar);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
         return vresult; }
static VALUE _wrap_new_FXStatusBar(int argc, VALUE *argv, VALUE self) { FXComposite *arg1 = (FXComposite *) 0 ;
    FXuint arg2 = (FXuint) 0 ; FXint arg3 = (FXint) 0 ; FXint arg4 = (FXint) 0 ; FXint arg5 = (FXint) 0 ;
    FXint arg6 = (FXint) 0 ; FXint arg7 = (FXint) 3 ; FXint arg8 = (FXint) 3 ; FXint arg9 = (FXint) 2 ;
    FXint arg10 = (FXint) 2 ; FXint arg11 = (FXint) 4 ; FXint arg12 = (FXint) 0 ; FXStatusBar *result;
    if ((argc < 1) || (argc > 12)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXComposite, 1); if (argc > 1) { arg2 = NUM2UINT(argv[1]); } 
    if (argc > 2) { arg3 = NUM2INT(argv[2]); }  if (argc > 3) { arg4 = NUM2INT(argv[3]); }  if (argc > 4) {
        arg5 = NUM2INT(argv[4]); }  if (argc > 5) { arg6 = NUM2INT(argv[5]); }  if (argc > 6) { arg7 = NUM2INT(argv[6]); } 
    if (argc > 7) { arg8 = NUM2INT(argv[7]); }  if (argc > 8) { arg9 = NUM2INT(argv[8]); }  if (argc > 9) {
        arg10 = NUM2INT(argv[9]); }  if (argc > 10) { arg11 = NUM2INT(argv[10]); }  if (argc > 11) { arg12 = NUM2INT(argv[11]); }
     { result = (FXStatusBar *)new_FXStatusBar(arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8,arg9,arg10,arg11,arg12);
        DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result); if(rb_block_given_p()){ rb_yield(self); }  }  return self; }
static VALUE _wrap_FXStatusBar_setCornerStyle(int argc, VALUE *argv, VALUE self) { FXStatusBar *arg1 = (FXStatusBar *) 0 ;
    FXbool arg2 = (FXbool) 1 ; if ((argc < 0) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXStatusBar, 1); if (argc > 0) { arg2 = to_FXbool(argv[0]); } 
    (arg1)->setCornerStyle(arg2); return Qnil; }
static VALUE _wrap_FXStatusBar_getCornerStyle(int argc, VALUE *argv, VALUE self) { FXStatusBar *arg1 = (FXStatusBar *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXStatusBar, 1);
    result = (FXbool)((FXStatusBar const *)arg1)->getCornerStyle(); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXStatusBar_getStatusLine(int argc, VALUE *argv, VALUE self) { FXStatusBar *arg1 = (FXStatusBar *) 0 ;
    FXStatusLine *result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXStatusBar, 1);
    result = (FXStatusLine *)((FXStatusBar const *)arg1)->getStatusLine(); {
        swig_type_info *ty = SWIG_TypeDynamicCast(SWIGTYPE_p_FXStatusLine, (void **) &result);
        vresult = FXRbGetRubyObj(result, ty); }  return vresult; }
static VALUE _wrap_FXStatusBar_getDragCorner(int argc, VALUE *argv, VALUE self) { FXStatusBar *arg1 = (FXStatusBar *) 0 ;
    FXDragCorner *result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXStatusBar, 1);
    result = (FXDragCorner *)((FXStatusBar const *)arg1)->getDragCorner(); {
        swig_type_info *ty = SWIG_TypeDynamicCast(SWIGTYPE_p_FXDragCorner, (void **) &result);
        vresult = FXRbGetRubyObj(result, ty); }  return vresult; }
static void
free_FXStatusBar(FXStatusBar *arg1) {
    delete arg1;
}
static VALUE _wrap_FXStatusBar_save(int argc, VALUE *argv, VALUE self) { FXStatusBar *arg1 = (FXStatusBar *) 0 ;
    FXStream *arg2 = 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXStatusBar, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXStatusBar_save((FXStatusBar const *)arg1,*arg2); return Qnil; }
static VALUE _wrap_FXStatusBar_load(int argc, VALUE *argv, VALUE self) { FXStatusBar *arg1 = (FXStatusBar *) 0 ;
    FXStream *arg2 = 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXStatusBar, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXStatusBar_load(arg1,*arg2); return Qnil; }
static VALUE _wrap_FXStatusBar_create(int argc, VALUE *argv, VALUE self) { FXStatusBar *arg1 = (FXStatusBar *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXStatusBar, 1); FXStatusBar_create(arg1); return Qnil; }
static VALUE _wrap_FXStatusBar_detach(int argc, VALUE *argv, VALUE self) { FXStatusBar *arg1 = (FXStatusBar *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXStatusBar, 1); FXStatusBar_detach(arg1); return Qnil; }
static VALUE _wrap_FXStatusBar_destroy(int argc, VALUE *argv, VALUE self) { FXStatusBar *arg1 = (FXStatusBar *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXStatusBar, 1); FXStatusBar_destroy(arg1); return Qnil; }
static VALUE _wrap_FXStatusBar_resize(int argc, VALUE *argv, VALUE self) { FXStatusBar *arg1 = (FXStatusBar *) 0 ; FXint arg2 ;
    FXint arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXStatusBar, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    FXStatusBar_resize(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXStatusBar_getDefaultWidth(int argc, VALUE *argv, VALUE self) { FXStatusBar *arg1 = (FXStatusBar *) 0 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXStatusBar, 1); result = (FXint)FXStatusBar_getDefaultWidth(arg1);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXStatusBar_getDefaultHeight(int argc, VALUE *argv, VALUE self) { FXStatusBar *arg1 = (FXStatusBar *) 0 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXStatusBar, 1); result = (FXint)FXStatusBar_getDefaultHeight(arg1);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXStatusBar_getWidthForHeight(int argc, VALUE *argv, VALUE self) { FXStatusBar *arg1 = (FXStatusBar *) 0 ;
    FXint arg2 ; FXint result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXStatusBar, 1); arg2 = NUM2INT(argv[0]);
    result = (FXint)FXStatusBar_getWidthForHeight(arg1,arg2); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXStatusBar_getHeightForWidth(int argc, VALUE *argv, VALUE self) { FXStatusBar *arg1 = (FXStatusBar *) 0 ;
    FXint arg2 ; FXint result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXStatusBar, 1); arg2 = NUM2INT(argv[0]);
    result = (FXint)FXStatusBar_getHeightForWidth(arg1,arg2); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXStatusBar_canFocus(int argc, VALUE *argv, VALUE self) { FXStatusBar *arg1 = (FXStatusBar *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXStatusBar, 1);
    result = (FXbool)FXStatusBar_canFocus((FXStatusBar const *)arg1); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXStatusBar_setFocus(int argc, VALUE *argv, VALUE self) { FXStatusBar *arg1 = (FXStatusBar *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXStatusBar, 1); FXStatusBar_setFocus(arg1); return Qnil; }
static VALUE _wrap_FXStatusBar_killFocus(int argc, VALUE *argv, VALUE self) { FXStatusBar *arg1 = (FXStatusBar *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXStatusBar, 1); FXStatusBar_killFocus(arg1); return Qnil; }
static VALUE _wrap_FXStatusBar_setDefault(int argc, VALUE *argv, VALUE self) { FXStatusBar *arg1 = (FXStatusBar *) 0 ;
    FXbool arg2 = (FXbool) 1 ; if ((argc < 0) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXStatusBar, 1); if (argc > 0) { arg2 = to_FXbool(argv[0]); } 
    FXStatusBar_setDefault(arg1,arg2); return Qnil; }
static VALUE _wrap_FXStatusBar_enable(int argc, VALUE *argv, VALUE self) { FXStatusBar *arg1 = (FXStatusBar *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXStatusBar, 1); FXStatusBar_enable(arg1); return Qnil; }
static VALUE _wrap_FXStatusBar_disable(int argc, VALUE *argv, VALUE self) { FXStatusBar *arg1 = (FXStatusBar *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXStatusBar, 1); FXStatusBar_disable(arg1); return Qnil; }
static VALUE _wrap_FXStatusBar_raiseWindow(int argc, VALUE *argv, VALUE self) { FXStatusBar *arg1 = (FXStatusBar *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXStatusBar, 1); FXStatusBar_raise(arg1); return Qnil; }
static VALUE _wrap_FXStatusBar_lower(int argc, VALUE *argv, VALUE self) { FXStatusBar *arg1 = (FXStatusBar *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXStatusBar, 1); FXStatusBar_lower(arg1); return Qnil; }
static VALUE _wrap_FXStatusBar_move(int argc, VALUE *argv, VALUE self) { FXStatusBar *arg1 = (FXStatusBar *) 0 ; FXint arg2 ;
    FXint arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXStatusBar, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    FXStatusBar_move(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXStatusBar_position(int argc, VALUE *argv, VALUE self) { FXStatusBar *arg1 = (FXStatusBar *) 0 ;
    FXint arg2 ; FXint arg3 ; FXint arg4 ; FXint arg5 ; if ((argc < 4) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXStatusBar, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    arg4 = NUM2INT(argv[2]); arg5 = NUM2INT(argv[3]); FXStatusBar_position(arg1,arg2,arg3,arg4,arg5); return Qnil; }
static VALUE _wrap_FXStatusBar_layout(int argc, VALUE *argv, VALUE self) { FXStatusBar *arg1 = (FXStatusBar *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXStatusBar, 1); FXStatusBar_layout(arg1); return Qnil; }
static VALUE _wrap_FXStatusBar_recalc(int argc, VALUE *argv, VALUE self) { FXStatusBar *arg1 = (FXStatusBar *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXStatusBar, 1); FXStatusBar_recalc(arg1); return Qnil; }
static VALUE _wrap_FXStatusBar_reparent(int argc, VALUE *argv, VALUE self) { FXStatusBar *arg1 = (FXStatusBar *) 0 ;
    FXComposite *arg2 = (FXComposite *) 0 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXStatusBar, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXComposite, 1); FXStatusBar_reparent(arg1,arg2); return Qnil; }
static VALUE _wrap_FXStatusBar_show(int argc, VALUE *argv, VALUE self) { FXStatusBar *arg1 = (FXStatusBar *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXStatusBar, 1); FXStatusBar_show(arg1); return Qnil; }
static VALUE _wrap_FXStatusBar_hide(int argc, VALUE *argv, VALUE self) { FXStatusBar *arg1 = (FXStatusBar *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXStatusBar, 1); FXStatusBar_hide(arg1); return Qnil; }
static VALUE _wrap_FXStatusBar_isComposite(int argc, VALUE *argv, VALUE self) { FXStatusBar *arg1 = (FXStatusBar *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXStatusBar, 1);
    result = (FXbool)FXStatusBar_isComposite((FXStatusBar const *)arg1); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXStatusBar_contains(int argc, VALUE *argv, VALUE self) { FXStatusBar *arg1 = (FXStatusBar *) 0 ;
    FXint arg2 ; FXint arg3 ; FXbool result; VALUE vresult = Qnil; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXStatusBar, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    result = (FXbool)FXStatusBar_contains((FXStatusBar const *)arg1,arg2,arg3); vresult = result ? Qtrue : Qfalse;
    return vresult; }
static VALUE _wrap_FXStatusBar_doesSaveUnder(int argc, VALUE *argv, VALUE self) { FXStatusBar *arg1 = (FXStatusBar *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXStatusBar, 1);
    result = (FXbool)FXStatusBar_doesSaveUnder((FXStatusBar const *)arg1); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXStatusBar_setBackColor(int argc, VALUE *argv, VALUE self) { FXStatusBar *arg1 = (FXStatusBar *) 0 ;
    FXColor arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXStatusBar, 1); arg2 = to_FXColor(argv[0]);
    FXStatusBar_setBackColor(arg1,arg2); return Qnil; }
static VALUE _wrap_FXScrollArea_onHMouseWheel(int argc, VALUE *argv, VALUE self) { FXScrollArea *arg1 = (FXScrollArea *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScrollArea, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onHMouseWheel(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXScrollArea_onVMouseWheel(int argc, VALUE *argv, VALUE self) { FXScrollArea *arg1 = (FXScrollArea *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScrollArea, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onVMouseWheel(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXScrollArea_onHScrollerChanged(int argc, VALUE *argv, VALUE self) {
    FXScrollArea *arg1 = (FXScrollArea *) 0 ; FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ;
    long result; VALUE vresult = Qnil; if ((argc < 3) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScrollArea, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]);
    arg4 = reinterpret_cast<void*>(NUM2INT(argv[2])); result = (long)(arg1)->onHScrollerChanged(arg2,arg3,arg4);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXScrollArea_onVScrollerChanged(int argc, VALUE *argv, VALUE self) {
    FXScrollArea *arg1 = (FXScrollArea *) 0 ; FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ;
    long result; VALUE vresult = Qnil; if ((argc < 3) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScrollArea, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]);
    arg4 = reinterpret_cast<void*>(NUM2INT(argv[2])); result = (long)(arg1)->onVScrollerChanged(arg2,arg3,arg4);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXScrollArea_onHScrollerDragged(int argc, VALUE *argv, VALUE self) {
    FXScrollArea *arg1 = (FXScrollArea *) 0 ; FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ;
    long result; VALUE vresult = Qnil; if ((argc < 3) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScrollArea, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]);
    arg4 = reinterpret_cast<void*>(NUM2INT(argv[2])); result = (long)(arg1)->onHScrollerDragged(arg2,arg3,arg4);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXScrollArea_onVScrollerDragged(int argc, VALUE *argv, VALUE self) {
    FXScrollArea *arg1 = (FXScrollArea *) 0 ; FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ;
    long result; VALUE vresult = Qnil; if ((argc < 3) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScrollArea, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]);
    arg4 = reinterpret_cast<void*>(NUM2INT(argv[2])); result = (long)(arg1)->onVScrollerDragged(arg2,arg3,arg4);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXScrollArea_onAutoScroll(int argc, VALUE *argv, VALUE self) { FXScrollArea *arg1 = (FXScrollArea *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScrollArea, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onAutoScroll(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE _wrap_FXScrollArea_allocate(VALUE self) {
#else
     static VALUE _wrap_FXScrollArea_allocate(int argc, VALUE *argv, VALUE self) {
#endif
         VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_FXScrollArea);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
         return vresult; }
static VALUE _wrap_new_FXScrollArea(int argc, VALUE *argv, VALUE self) { FXComposite *arg1 = (FXComposite *) 0 ;
    FXuint arg2 = (FXuint) 0 ; FXint arg3 = (FXint) 0 ; FXint arg4 = (FXint) 0 ; FXint arg5 = (FXint) 0 ;
    FXint arg6 = (FXint) 0 ; FXScrollArea *result; if ((argc < 1) || (argc > 6))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXComposite, 1); if (argc > 1) { arg2 = NUM2UINT(argv[1]); } 
    if (argc > 2) { arg3 = NUM2INT(argv[2]); }  if (argc > 3) { arg4 = NUM2INT(argv[3]); }  if (argc > 4) {
        arg5 = NUM2INT(argv[4]); }  if (argc > 5) { arg6 = NUM2INT(argv[5]); }  {
        result = (FXScrollArea *)new_FXScrollArea(arg1,arg2,arg3,arg4,arg5,arg6);
        DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result); if(rb_block_given_p()){ rb_yield(self); }  }  return self; }
static VALUE _wrap_FXScrollArea_setScrollStyle(int argc, VALUE *argv, VALUE self) { FXScrollArea *arg1 = (FXScrollArea *) 0 ;
    FXuint arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScrollArea, 1); arg2 = NUM2UINT(argv[0]); (arg1)->setScrollStyle(arg2);
    return Qnil; }
static VALUE _wrap_FXScrollArea_getScrollStyle(int argc, VALUE *argv, VALUE self) { FXScrollArea *arg1 = (FXScrollArea *) 0 ;
    FXuint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScrollArea, 1);
    result = (FXuint)((FXScrollArea const *)arg1)->getScrollStyle(); vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXScrollArea_isHorizontalScrollable(int argc, VALUE *argv, VALUE self) {
    FXScrollArea *arg1 = (FXScrollArea *) 0 ; FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScrollArea, 1);
    result = (FXbool)((FXScrollArea const *)arg1)->isHorizontalScrollable(); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXScrollArea_isVerticalScrollable(int argc, VALUE *argv, VALUE self) {
    FXScrollArea *arg1 = (FXScrollArea *) 0 ; FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScrollArea, 1);
    result = (FXbool)((FXScrollArea const *)arg1)->isVerticalScrollable(); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXScrollArea_horizontalScrollBar(int argc, VALUE *argv, VALUE self) {
    FXScrollArea *arg1 = (FXScrollArea *) 0 ; FXScrollBar *result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScrollArea, 1);
    result = (FXScrollBar *)((FXScrollArea const *)arg1)->horizontalScrollBar(); {
        swig_type_info *ty = SWIG_TypeDynamicCast(SWIGTYPE_p_FXScrollBar, (void **) &result);
        vresult = FXRbGetRubyObj(result, ty); }  return vresult; }
static VALUE _wrap_FXScrollArea_verticalScrollBar(int argc, VALUE *argv, VALUE self) { FXScrollArea *arg1 = (FXScrollArea *) 0 ;
    FXScrollBar *result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScrollArea, 1);
    result = (FXScrollBar *)((FXScrollArea const *)arg1)->verticalScrollBar(); {
        swig_type_info *ty = SWIG_TypeDynamicCast(SWIGTYPE_p_FXScrollBar, (void **) &result);
        vresult = FXRbGetRubyObj(result, ty); }  return vresult; }
static VALUE _wrap_FXScrollArea_getXPosition(int argc, VALUE *argv, VALUE self) { FXScrollArea *arg1 = (FXScrollArea *) 0 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScrollArea, 1);
    result = (FXint)((FXScrollArea const *)arg1)->getXPosition(); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXScrollArea_getYPosition(int argc, VALUE *argv, VALUE self) { FXScrollArea *arg1 = (FXScrollArea *) 0 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScrollArea, 1);
    result = (FXint)((FXScrollArea const *)arg1)->getYPosition(); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXScrollArea_setPosition(int argc, VALUE *argv, VALUE self) { FXScrollArea *arg1 = (FXScrollArea *) 0 ;
    FXint arg2 ; FXint arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScrollArea, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    (arg1)->setPosition(arg2,arg3); return Qnil; }
static void
free_FXScrollArea(FXScrollArea *arg1) {
    delete arg1;
}
static VALUE _wrap_FXScrollArea_save(int argc, VALUE *argv, VALUE self) { FXScrollArea *arg1 = (FXScrollArea *) 0 ;
    FXStream *arg2 = 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScrollArea, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXScrollArea_save((FXScrollArea const *)arg1,*arg2); return Qnil; }
static VALUE _wrap_FXScrollArea_load(int argc, VALUE *argv, VALUE self) { FXScrollArea *arg1 = (FXScrollArea *) 0 ;
    FXStream *arg2 = 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScrollArea, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXScrollArea_load(arg1,*arg2); return Qnil; }
static VALUE _wrap_FXScrollArea_create(int argc, VALUE *argv, VALUE self) { FXScrollArea *arg1 = (FXScrollArea *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScrollArea, 1); FXScrollArea_create(arg1); return Qnil; }
static VALUE _wrap_FXScrollArea_detach(int argc, VALUE *argv, VALUE self) { FXScrollArea *arg1 = (FXScrollArea *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScrollArea, 1); FXScrollArea_detach(arg1); return Qnil; }
static VALUE _wrap_FXScrollArea_destroy(int argc, VALUE *argv, VALUE self) { FXScrollArea *arg1 = (FXScrollArea *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScrollArea, 1); FXScrollArea_destroy(arg1); return Qnil; }
static VALUE _wrap_FXScrollArea_resize(int argc, VALUE *argv, VALUE self) { FXScrollArea *arg1 = (FXScrollArea *) 0 ;
    FXint arg2 ; FXint arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScrollArea, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    FXScrollArea_resize(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXScrollArea_getDefaultWidth(int argc, VALUE *argv, VALUE self) { FXScrollArea *arg1 = (FXScrollArea *) 0 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScrollArea, 1); result = (FXint)FXScrollArea_getDefaultWidth(arg1);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXScrollArea_getDefaultHeight(int argc, VALUE *argv, VALUE self) { FXScrollArea *arg1 = (FXScrollArea *) 0 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScrollArea, 1); result = (FXint)FXScrollArea_getDefaultHeight(arg1);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXScrollArea_getWidthForHeight(int argc, VALUE *argv, VALUE self) { FXScrollArea *arg1 = (FXScrollArea *) 0 ;
    FXint arg2 ; FXint result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScrollArea, 1); arg2 = NUM2INT(argv[0]);
    result = (FXint)FXScrollArea_getWidthForHeight(arg1,arg2); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXScrollArea_getHeightForWidth(int argc, VALUE *argv, VALUE self) { FXScrollArea *arg1 = (FXScrollArea *) 0 ;
    FXint arg2 ; FXint result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScrollArea, 1); arg2 = NUM2INT(argv[0]);
    result = (FXint)FXScrollArea_getHeightForWidth(arg1,arg2); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXScrollArea_canFocus(int argc, VALUE *argv, VALUE self) { FXScrollArea *arg1 = (FXScrollArea *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScrollArea, 1);
    result = (FXbool)FXScrollArea_canFocus((FXScrollArea const *)arg1); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXScrollArea_setFocus(int argc, VALUE *argv, VALUE self) { FXScrollArea *arg1 = (FXScrollArea *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScrollArea, 1); FXScrollArea_setFocus(arg1); return Qnil; }
static VALUE _wrap_FXScrollArea_killFocus(int argc, VALUE *argv, VALUE self) { FXScrollArea *arg1 = (FXScrollArea *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScrollArea, 1); FXScrollArea_killFocus(arg1); return Qnil; }
static VALUE _wrap_FXScrollArea_setDefault(int argc, VALUE *argv, VALUE self) { FXScrollArea *arg1 = (FXScrollArea *) 0 ;
    FXbool arg2 = (FXbool) 1 ; if ((argc < 0) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScrollArea, 1); if (argc > 0) { arg2 = to_FXbool(argv[0]); } 
    FXScrollArea_setDefault(arg1,arg2); return Qnil; }
static VALUE _wrap_FXScrollArea_enable(int argc, VALUE *argv, VALUE self) { FXScrollArea *arg1 = (FXScrollArea *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScrollArea, 1); FXScrollArea_enable(arg1); return Qnil; }
static VALUE _wrap_FXScrollArea_disable(int argc, VALUE *argv, VALUE self) { FXScrollArea *arg1 = (FXScrollArea *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScrollArea, 1); FXScrollArea_disable(arg1); return Qnil; }
static VALUE _wrap_FXScrollArea_raiseWindow(int argc, VALUE *argv, VALUE self) { FXScrollArea *arg1 = (FXScrollArea *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScrollArea, 1); FXScrollArea_raise(arg1); return Qnil; }
static VALUE _wrap_FXScrollArea_lower(int argc, VALUE *argv, VALUE self) { FXScrollArea *arg1 = (FXScrollArea *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScrollArea, 1); FXScrollArea_lower(arg1); return Qnil; }
static VALUE _wrap_FXScrollArea_move(int argc, VALUE *argv, VALUE self) { FXScrollArea *arg1 = (FXScrollArea *) 0 ; FXint arg2 ;
    FXint arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScrollArea, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    FXScrollArea_move(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXScrollArea_position__SWIG_0(int argc, VALUE *argv, VALUE self) { FXScrollArea *arg1 = (FXScrollArea *) 0 ;
    FXint arg2 ; FXint arg3 ; FXint arg4 ; FXint arg5 ; if ((argc < 4) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScrollArea, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    arg4 = NUM2INT(argv[2]); arg5 = NUM2INT(argv[3]); FXScrollArea_position(arg1,arg2,arg3,arg4,arg5); return Qnil; }
static VALUE _wrap_FXScrollArea_layout(int argc, VALUE *argv, VALUE self) { FXScrollArea *arg1 = (FXScrollArea *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScrollArea, 1); FXScrollArea_layout(arg1); return Qnil; }
static VALUE _wrap_FXScrollArea_recalc(int argc, VALUE *argv, VALUE self) { FXScrollArea *arg1 = (FXScrollArea *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScrollArea, 1); FXScrollArea_recalc(arg1); return Qnil; }
static VALUE _wrap_FXScrollArea_reparent(int argc, VALUE *argv, VALUE self) { FXScrollArea *arg1 = (FXScrollArea *) 0 ;
    FXComposite *arg2 = (FXComposite *) 0 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScrollArea, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXComposite, 1); FXScrollArea_reparent(arg1,arg2); return Qnil; }
static VALUE _wrap_FXScrollArea_show(int argc, VALUE *argv, VALUE self) { FXScrollArea *arg1 = (FXScrollArea *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScrollArea, 1); FXScrollArea_show(arg1); return Qnil; }
static VALUE _wrap_FXScrollArea_hide(int argc, VALUE *argv, VALUE self) { FXScrollArea *arg1 = (FXScrollArea *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScrollArea, 1); FXScrollArea_hide(arg1); return Qnil; }
static VALUE _wrap_FXScrollArea_isComposite(int argc, VALUE *argv, VALUE self) { FXScrollArea *arg1 = (FXScrollArea *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScrollArea, 1);
    result = (FXbool)FXScrollArea_isComposite((FXScrollArea const *)arg1); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXScrollArea_contains(int argc, VALUE *argv, VALUE self) { FXScrollArea *arg1 = (FXScrollArea *) 0 ;
    FXint arg2 ; FXint arg3 ; FXbool result; VALUE vresult = Qnil; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScrollArea, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    result = (FXbool)FXScrollArea_contains((FXScrollArea const *)arg1,arg2,arg3); vresult = result ? Qtrue : Qfalse;
    return vresult; }
static VALUE _wrap_FXScrollArea_doesSaveUnder(int argc, VALUE *argv, VALUE self) { FXScrollArea *arg1 = (FXScrollArea *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScrollArea, 1);
    result = (FXbool)FXScrollArea_doesSaveUnder((FXScrollArea const *)arg1); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXScrollArea_setBackColor(int argc, VALUE *argv, VALUE self) { FXScrollArea *arg1 = (FXScrollArea *) 0 ;
    FXColor arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScrollArea, 1); arg2 = to_FXColor(argv[0]);
    FXScrollArea_setBackColor(arg1,arg2); return Qnil; }
static VALUE _wrap_FXScrollArea_getViewportHeight(int argc, VALUE *argv, VALUE self) { FXScrollArea *arg1 = (FXScrollArea *) 0 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScrollArea, 1); result = (FXint)FXScrollArea_getViewportHeight(arg1);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXScrollArea_getViewportWidth(int argc, VALUE *argv, VALUE self) { FXScrollArea *arg1 = (FXScrollArea *) 0 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScrollArea, 1); result = (FXint)FXScrollArea_getViewportWidth(arg1);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXScrollArea_getContentHeight(int argc, VALUE *argv, VALUE self) { FXScrollArea *arg1 = (FXScrollArea *) 0 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScrollArea, 1); result = (FXint)FXScrollArea_getContentHeight(arg1);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXScrollArea_getContentWidth(int argc, VALUE *argv, VALUE self) { FXScrollArea *arg1 = (FXScrollArea *) 0 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScrollArea, 1); result = (FXint)FXScrollArea_getContentWidth(arg1);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXScrollArea_position__SWIG_1(int argc, VALUE *argv, VALUE self) { FXScrollArea *arg1 = (FXScrollArea *) 0 ;
    VALUE result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScrollArea, 1);
    result = (VALUE)FXScrollArea_position__SWIG_1((FXScrollArea const *)arg1); vresult = result; return vresult; }
static VALUE _wrap_FXScrollArea_position(int nargs, VALUE *args, VALUE self) { int argc; VALUE argv[6]; int ii;
    argc = nargs + 1; argv[0] = self; for (ii = 1; (ii < argc) && (ii < 5); ii++) { argv[ii] = args[ii-1]; }  if (argc == 1) {
        int _v; { void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXScrollArea, 0) != -1)) ? 1 : 0; }
         if (_v) { return _wrap_FXScrollArea_position__SWIG_1(nargs, args, self);}  }  if (argc == 5) { int _v; { void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXScrollArea, 0) != -1)) ? 1 : 0; }
         if (_v) { { _v = ((TYPE(argv[1]) == T_FIXNUM) || (TYPE(argv[1]) == T_BIGNUM)) ? 1 : 0; }  if (_v) { {
                    _v = ((TYPE(argv[2]) == T_FIXNUM) || (TYPE(argv[2]) == T_BIGNUM)) ? 1 : 0; }  if (_v) { {
                        _v = ((TYPE(argv[3]) == T_FIXNUM) || (TYPE(argv[3]) == T_BIGNUM)) ? 1 : 0; }  if (_v) { {
                            _v = ((TYPE(argv[4]) == T_FIXNUM) || (TYPE(argv[4]) == T_BIGNUM)) ? 1 : 0; }  if (_v) {
                            return _wrap_FXScrollArea_position__SWIG_0(nargs, args, self);}  }  }  }  }  } 
    rb_raise(rb_eArgError, "No matching function for overloaded 'FXScrollArea_position'"); return Qnil; }
static VALUE _wrap_FXScrollWindow_onKeyPress(int argc, VALUE *argv, VALUE self) { FXScrollWindow *arg1 = (FXScrollWindow *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScrollWindow, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onKeyPress(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXScrollWindow_onKeyRelease(int argc, VALUE *argv, VALUE self) {
    FXScrollWindow *arg1 = (FXScrollWindow *) 0 ; FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ;
    long result; VALUE vresult = Qnil; if ((argc < 3) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScrollWindow, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onKeyRelease(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXScrollWindow_onFocusSelf(int argc, VALUE *argv, VALUE self) { FXScrollWindow *arg1 = (FXScrollWindow *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScrollWindow, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onFocusSelf(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE _wrap_FXScrollWindow_allocate(VALUE self) {
#else
     static VALUE _wrap_FXScrollWindow_allocate(int argc, VALUE *argv, VALUE self) {
#endif
         VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_FXScrollWindow);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
         return vresult; }
static VALUE _wrap_new_FXScrollWindow(int argc, VALUE *argv, VALUE self) { FXComposite *arg1 = (FXComposite *) 0 ;
    FXuint arg2 = (FXuint) 0 ; FXint arg3 = (FXint) 0 ; FXint arg4 = (FXint) 0 ; FXint arg5 = (FXint) 0 ;
    FXint arg6 = (FXint) 0 ; FXScrollWindow *result; if ((argc < 1) || (argc > 6))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXComposite, 1); if (argc > 1) { arg2 = NUM2UINT(argv[1]); } 
    if (argc > 2) { arg3 = NUM2INT(argv[2]); }  if (argc > 3) { arg4 = NUM2INT(argv[3]); }  if (argc > 4) {
        arg5 = NUM2INT(argv[4]); }  if (argc > 5) { arg6 = NUM2INT(argv[5]); }  {
        result = (FXScrollWindow *)new_FXScrollWindow(arg1,arg2,arg3,arg4,arg5,arg6);
        DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result); if(rb_block_given_p()){ rb_yield(self); }  }  return self; }
static VALUE _wrap_FXScrollWindow_contentWindow(int argc, VALUE *argv, VALUE self) {
    FXScrollWindow *arg1 = (FXScrollWindow *) 0 ; FXWindow *result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScrollWindow, 1);
    result = (FXWindow *)((FXScrollWindow const *)arg1)->contentWindow(); {
        swig_type_info *ty = SWIG_TypeDynamicCast(SWIGTYPE_p_FXWindow, (void **) &result);
        vresult = FXRbGetRubyObj(result, ty); }  return vresult; }
static void
free_FXScrollWindow(FXScrollWindow *arg1) {
    delete arg1;
}
static VALUE _wrap_FXScrollWindow_save(int argc, VALUE *argv, VALUE self) { FXScrollWindow *arg1 = (FXScrollWindow *) 0 ;
    FXStream *arg2 = 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScrollWindow, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXScrollWindow_save((FXScrollWindow const *)arg1,*arg2); return Qnil; }
static VALUE _wrap_FXScrollWindow_load(int argc, VALUE *argv, VALUE self) { FXScrollWindow *arg1 = (FXScrollWindow *) 0 ;
    FXStream *arg2 = 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScrollWindow, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXScrollWindow_load(arg1,*arg2); return Qnil; }
static VALUE _wrap_FXScrollWindow_create(int argc, VALUE *argv, VALUE self) { FXScrollWindow *arg1 = (FXScrollWindow *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScrollWindow, 1); FXScrollWindow_create(arg1); return Qnil; }
static VALUE _wrap_FXScrollWindow_detach(int argc, VALUE *argv, VALUE self) { FXScrollWindow *arg1 = (FXScrollWindow *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScrollWindow, 1); FXScrollWindow_detach(arg1); return Qnil; }
static VALUE _wrap_FXScrollWindow_destroy(int argc, VALUE *argv, VALUE self) { FXScrollWindow *arg1 = (FXScrollWindow *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScrollWindow, 1); FXScrollWindow_destroy(arg1); return Qnil; }
static VALUE _wrap_FXScrollWindow_resize(int argc, VALUE *argv, VALUE self) { FXScrollWindow *arg1 = (FXScrollWindow *) 0 ;
    FXint arg2 ; FXint arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScrollWindow, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    FXScrollWindow_resize(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXScrollWindow_getDefaultWidth(int argc, VALUE *argv, VALUE self) {
    FXScrollWindow *arg1 = (FXScrollWindow *) 0 ; FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScrollWindow, 1); result = (FXint)FXScrollWindow_getDefaultWidth(arg1);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXScrollWindow_getDefaultHeight(int argc, VALUE *argv, VALUE self) {
    FXScrollWindow *arg1 = (FXScrollWindow *) 0 ; FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScrollWindow, 1); result = (FXint)FXScrollWindow_getDefaultHeight(arg1);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXScrollWindow_getWidthForHeight(int argc, VALUE *argv, VALUE self) {
    FXScrollWindow *arg1 = (FXScrollWindow *) 0 ; FXint arg2 ; FXint result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScrollWindow, 1); arg2 = NUM2INT(argv[0]);
    result = (FXint)FXScrollWindow_getWidthForHeight(arg1,arg2); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXScrollWindow_getHeightForWidth(int argc, VALUE *argv, VALUE self) {
    FXScrollWindow *arg1 = (FXScrollWindow *) 0 ; FXint arg2 ; FXint result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScrollWindow, 1); arg2 = NUM2INT(argv[0]);
    result = (FXint)FXScrollWindow_getHeightForWidth(arg1,arg2); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXScrollWindow_canFocus(int argc, VALUE *argv, VALUE self) { FXScrollWindow *arg1 = (FXScrollWindow *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScrollWindow, 1);
    result = (FXbool)FXScrollWindow_canFocus((FXScrollWindow const *)arg1); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXScrollWindow_setFocus(int argc, VALUE *argv, VALUE self) { FXScrollWindow *arg1 = (FXScrollWindow *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScrollWindow, 1); FXScrollWindow_setFocus(arg1); return Qnil; }
static VALUE _wrap_FXScrollWindow_killFocus(int argc, VALUE *argv, VALUE self) { FXScrollWindow *arg1 = (FXScrollWindow *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScrollWindow, 1); FXScrollWindow_killFocus(arg1); return Qnil; }
static VALUE _wrap_FXScrollWindow_setDefault(int argc, VALUE *argv, VALUE self) { FXScrollWindow *arg1 = (FXScrollWindow *) 0 ;
    FXbool arg2 = (FXbool) 1 ; if ((argc < 0) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScrollWindow, 1); if (argc > 0) { arg2 = to_FXbool(argv[0]); } 
    FXScrollWindow_setDefault(arg1,arg2); return Qnil; }
static VALUE _wrap_FXScrollWindow_enable(int argc, VALUE *argv, VALUE self) { FXScrollWindow *arg1 = (FXScrollWindow *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScrollWindow, 1); FXScrollWindow_enable(arg1); return Qnil; }
static VALUE _wrap_FXScrollWindow_disable(int argc, VALUE *argv, VALUE self) { FXScrollWindow *arg1 = (FXScrollWindow *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScrollWindow, 1); FXScrollWindow_disable(arg1); return Qnil; }
static VALUE _wrap_FXScrollWindow_raiseWindow(int argc, VALUE *argv, VALUE self) { FXScrollWindow *arg1 = (FXScrollWindow *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScrollWindow, 1); FXScrollWindow_raise(arg1); return Qnil; }
static VALUE _wrap_FXScrollWindow_lower(int argc, VALUE *argv, VALUE self) { FXScrollWindow *arg1 = (FXScrollWindow *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScrollWindow, 1); FXScrollWindow_lower(arg1); return Qnil; }
static VALUE _wrap_FXScrollWindow_move(int argc, VALUE *argv, VALUE self) { FXScrollWindow *arg1 = (FXScrollWindow *) 0 ;
    FXint arg2 ; FXint arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScrollWindow, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    FXScrollWindow_move(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXScrollWindow_position__SWIG_0(int argc, VALUE *argv, VALUE self) {
    FXScrollWindow *arg1 = (FXScrollWindow *) 0 ; FXint arg2 ; FXint arg3 ; FXint arg4 ; FXint arg5 ;
    if ((argc < 4) || (argc > 4)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScrollWindow, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    arg4 = NUM2INT(argv[2]); arg5 = NUM2INT(argv[3]); FXScrollWindow_position(arg1,arg2,arg3,arg4,arg5); return Qnil; }
static VALUE _wrap_FXScrollWindow_layout(int argc, VALUE *argv, VALUE self) { FXScrollWindow *arg1 = (FXScrollWindow *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScrollWindow, 1); FXScrollWindow_layout(arg1); return Qnil; }
static VALUE _wrap_FXScrollWindow_recalc(int argc, VALUE *argv, VALUE self) { FXScrollWindow *arg1 = (FXScrollWindow *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScrollWindow, 1); FXScrollWindow_recalc(arg1); return Qnil; }
static VALUE _wrap_FXScrollWindow_reparent(int argc, VALUE *argv, VALUE self) { FXScrollWindow *arg1 = (FXScrollWindow *) 0 ;
    FXComposite *arg2 = (FXComposite *) 0 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScrollWindow, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXComposite, 1); FXScrollWindow_reparent(arg1,arg2); return Qnil; }
static VALUE _wrap_FXScrollWindow_show(int argc, VALUE *argv, VALUE self) { FXScrollWindow *arg1 = (FXScrollWindow *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScrollWindow, 1); FXScrollWindow_show(arg1); return Qnil; }
static VALUE _wrap_FXScrollWindow_hide(int argc, VALUE *argv, VALUE self) { FXScrollWindow *arg1 = (FXScrollWindow *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScrollWindow, 1); FXScrollWindow_hide(arg1); return Qnil; }
static VALUE _wrap_FXScrollWindow_isComposite(int argc, VALUE *argv, VALUE self) { FXScrollWindow *arg1 = (FXScrollWindow *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScrollWindow, 1);
    result = (FXbool)FXScrollWindow_isComposite((FXScrollWindow const *)arg1); vresult = result ? Qtrue : Qfalse;
    return vresult; }
static VALUE _wrap_FXScrollWindow_contains(int argc, VALUE *argv, VALUE self) { FXScrollWindow *arg1 = (FXScrollWindow *) 0 ;
    FXint arg2 ; FXint arg3 ; FXbool result; VALUE vresult = Qnil; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScrollWindow, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    result = (FXbool)FXScrollWindow_contains((FXScrollWindow const *)arg1,arg2,arg3); vresult = result ? Qtrue : Qfalse;
    return vresult; }
static VALUE _wrap_FXScrollWindow_doesSaveUnder(int argc, VALUE *argv, VALUE self) {
    FXScrollWindow *arg1 = (FXScrollWindow *) 0 ; FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScrollWindow, 1);
    result = (FXbool)FXScrollWindow_doesSaveUnder((FXScrollWindow const *)arg1); vresult = result ? Qtrue : Qfalse;
    return vresult; }
static VALUE _wrap_FXScrollWindow_setBackColor(int argc, VALUE *argv, VALUE self) {
    FXScrollWindow *arg1 = (FXScrollWindow *) 0 ; FXColor arg2 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScrollWindow, 1); arg2 = to_FXColor(argv[0]);
    FXScrollWindow_setBackColor(arg1,arg2); return Qnil; }
static VALUE _wrap_FXScrollWindow_getViewportHeight(int argc, VALUE *argv, VALUE self) {
    FXScrollWindow *arg1 = (FXScrollWindow *) 0 ; FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScrollWindow, 1);
    result = (FXint)FXScrollWindow_getViewportHeight(arg1); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXScrollWindow_getViewportWidth(int argc, VALUE *argv, VALUE self) {
    FXScrollWindow *arg1 = (FXScrollWindow *) 0 ; FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScrollWindow, 1); result = (FXint)FXScrollWindow_getViewportWidth(arg1);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXScrollWindow_getContentHeight(int argc, VALUE *argv, VALUE self) {
    FXScrollWindow *arg1 = (FXScrollWindow *) 0 ; FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScrollWindow, 1); result = (FXint)FXScrollWindow_getContentHeight(arg1);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXScrollWindow_getContentWidth(int argc, VALUE *argv, VALUE self) {
    FXScrollWindow *arg1 = (FXScrollWindow *) 0 ; FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScrollWindow, 1); result = (FXint)FXScrollWindow_getContentWidth(arg1);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXScrollWindow_position__SWIG_1(int argc, VALUE *argv, VALUE self) {
    FXScrollWindow *arg1 = (FXScrollWindow *) 0 ; VALUE result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScrollWindow, 1);
    result = (VALUE)FXScrollWindow_position__SWIG_1((FXScrollWindow const *)arg1); vresult = result; return vresult; }
static VALUE _wrap_FXScrollWindow_position(int nargs, VALUE *args, VALUE self) { int argc; VALUE argv[6]; int ii;
    argc = nargs + 1; argv[0] = self; for (ii = 1; (ii < argc) && (ii < 5); ii++) { argv[ii] = args[ii-1]; }  if (argc == 1) {
        int _v; { void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXScrollWindow, 0) != -1)) ? 1 : 0; }
         if (_v) { return _wrap_FXScrollWindow_position__SWIG_1(nargs, args, self);}  }  if (argc == 5) { int _v; { void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXScrollWindow, 0) != -1)) ? 1 : 0; }
         if (_v) { { _v = ((TYPE(argv[1]) == T_FIXNUM) || (TYPE(argv[1]) == T_BIGNUM)) ? 1 : 0; }  if (_v) { {
                    _v = ((TYPE(argv[2]) == T_FIXNUM) || (TYPE(argv[2]) == T_BIGNUM)) ? 1 : 0; }  if (_v) { {
                        _v = ((TYPE(argv[3]) == T_FIXNUM) || (TYPE(argv[3]) == T_BIGNUM)) ? 1 : 0; }  if (_v) { {
                            _v = ((TYPE(argv[4]) == T_FIXNUM) || (TYPE(argv[4]) == T_BIGNUM)) ? 1 : 0; }  if (_v) {
                            return _wrap_FXScrollWindow_position__SWIG_0(nargs, args, self);}  }  }  }  }  } 
    rb_raise(rb_eArgError, "No matching function for overloaded 'FXScrollWindow_position'"); return Qnil; }

/* -------- TYPE CONVERSION AND EQUIVALENCE RULES (BEGIN) -------- */

static void *_p_FXFrameTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *) ((FXFrame *) x));
}
static void *_p_FXPopupTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXShell *) ((FXPopup *) x));
}
static void *_p_FXShutterItemTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *)(FXVerticalFrame *) ((FXShutterItem *) x));
}
static void *_p_FXScrollAreaTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *) ((FXScrollArea *) x));
}
static void *_p_FXStatusBarTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *)(FXHorizontalFrame *) ((FXStatusBar *) x));
}
static void *_p_FXMainWindowTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXShell *)(FXTopWindow *) ((FXMainWindow *) x));
}
static void *_p_FXTopWindowTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXShell *) ((FXTopWindow *) x));
}
static void *_p_FXRootWindowTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *) ((FXRootWindow *) x));
}
static void *_p_FXWindowTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *) ((FXWindow *) x));
}
static void *_p_FXCompositeTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *) ((FXComposite *) x));
}
static void *_p_FXScrollWindowTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXScrollArea *) ((FXScrollWindow *) x));
}
static void *_p_FXShellTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *) ((FXShell *) x));
}
static void *_p_FXGroupBoxTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXGroupBox *) x));
}
static void *_p_FXGIFCursorTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXCursor *) ((FXGIFCursor *) x));
}
static void *_p_FXCURCursorTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXCursor *) ((FXCURCursor *) x));
}
static void *_p_FXCursorTo_p_FXId(void *x) {
    return (void *)((FXId *)  ((FXCursor *) x));
}
static void *_p_FXDrawableTo_p_FXId(void *x) {
    return (void *)((FXId *)  ((FXDrawable *) x));
}
static void *_p_FXSplitterTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *) ((FXSplitter *) x));
}
static void *_p_FX4SplitterTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *) ((FX4Splitter *) x));
}
static void *_p_FXFontTo_p_FXId(void *x) {
    return (void *)((FXId *)  ((FXFont *) x));
}
static void *_p_FXPackerTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *) ((FXPacker *) x));
}
static void *_p_FXHorizontalFrameTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXHorizontalFrame *) x));
}
static void *_p_FXVerticalFrameTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXVerticalFrame *) x));
}
static void *_p_FXShutterTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *)(FXVerticalFrame *) ((FXShutter *) x));
}
static void *_p_FXVisualTo_p_FXId(void *x) {
    return (void *)((FXId *)  ((FXVisual *) x));
}
static void *_p_FXMatrixTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXMatrix *) x));
}
static void *_p_FXSpringTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXSpring *) x));
}
static void *_p_FXSwitcherTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXSwitcher *) x));
}
static void *_p_FXSettingsTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXDict *) ((FXSettings *) x));
}
static void *_p_FXAccelTableTo_p_FXObject(void *x) {
    return (void *)((FXObject *)  ((FXAccelTable *) x));
}
static void *_p_FXCompositeTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *) ((FXComposite *) x));
}
static void *_p_FXRegistryTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXDict *)(FXSettings *) ((FXRegistry *) x));
}
static void *_p_FXIconDictTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXDict *) ((FXIconDict *) x));
}
static void *_p_FXGroupBoxTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXGroupBox *) x));
}
static void *_p_FXShellTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *) ((FXShell *) x));
}
static void *_p_FXPopupTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXShell *) ((FXPopup *) x));
}
static void *_p_FXStatusBarTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *)(FXHorizontalFrame *) ((FXStatusBar *) x));
}
static void *_p_FXScrollAreaTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *) ((FXScrollArea *) x));
}
static void *_p_FXRecentFilesTo_p_FXObject(void *x) {
    return (void *)((FXObject *)  ((FXRecentFiles *) x));
}
static void *_p_FXDocumentTo_p_FXObject(void *x) {
    return (void *)((FXObject *)  ((FXDocument *) x));
}
static void *_p_FXMainWindowTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXShell *)(FXTopWindow *) ((FXMainWindow *) x));
}
static void *_p_FXTopWindowTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXShell *) ((FXTopWindow *) x));
}
static void *_p_FXRootWindowTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *) ((FXRootWindow *) x));
}
static void *_p_FXWindowTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *) ((FXWindow *) x));
}
static void *_p_FXScrollWindowTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXScrollArea *) ((FXScrollWindow *) x));
}
static void *_p_FXVerticalFrameTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXVerticalFrame *) x));
}
static void *_p_FXHorizontalFrameTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXHorizontalFrame *) x));
}
static void *_p_FXSplitterTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *) ((FXSplitter *) x));
}
static void *_p_FX4SplitterTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *) ((FX4Splitter *) x));
}
static void *_p_FXStringDictTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXDict *) ((FXStringDict *) x));
}
static void *_p_FXPackerTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *) ((FXPacker *) x));
}
static void *_p_FXFontTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *) ((FXFont *) x));
}
static void *_p_FXFileDictTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXDict *) ((FXFileDict *) x));
}
static void *_p_FXDataTargetTo_p_FXObject(void *x) {
    return (void *)((FXObject *)  ((FXDataTarget *) x));
}
static void *_p_FXDebugTargetTo_p_FXObject(void *x) {
    return (void *)((FXObject *)  ((FXDebugTarget *) x));
}
static void *_p_FXSwitcherTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXSwitcher *) x));
}
static void *_p_FXShutterTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *)(FXVerticalFrame *) ((FXShutter *) x));
}
static void *_p_FXDelegatorTo_p_FXObject(void *x) {
    return (void *)((FXObject *)  ((FXDelegator *) x));
}
static void *_p_FXDrawableTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *) ((FXDrawable *) x));
}
static void *_p_FXGIFCursorTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXCursor *) ((FXGIFCursor *) x));
}
static void *_p_FXCURCursorTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXCursor *) ((FXCURCursor *) x));
}
static void *_p_FXCursorTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *) ((FXCursor *) x));
}
static void *_p_FXDictTo_p_FXObject(void *x) {
    return (void *)((FXObject *)  ((FXDict *) x));
}
static void *_p_FXMatrixTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXMatrix *) x));
}
static void *_p_FXShutterItemTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *)(FXVerticalFrame *) ((FXShutterItem *) x));
}
static void *_p_FXIdTo_p_FXObject(void *x) {
    return (void *)((FXObject *)  ((FXId *) x));
}
static void *_p_FXFrameTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *) ((FXFrame *) x));
}
static void *_p_FXSpringTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXSpring *) x));
}
static void *_p_FXVisualTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *) ((FXVisual *) x));
}
static void *_p_FXAppTo_p_FXObject(void *x) {
    return (void *)((FXObject *)  ((FXApp *) x));
}
static void *_p_FXScrollWindowTo_p_FXScrollArea(void *x) {
    return (void *)((FXScrollArea *)  ((FXScrollWindow *) x));
}
static void *_p_FXFrameTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *)  ((FXFrame *) x));
}
static void *_p_FXPopupTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXShell *) ((FXPopup *) x));
}
static void *_p_FXShutterItemTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXPacker *)(FXVerticalFrame *) ((FXShutterItem *) x));
}
static void *_p_FXScrollAreaTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *) ((FXScrollArea *) x));
}
static void *_p_FXStatusBarTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXPacker *)(FXHorizontalFrame *) ((FXStatusBar *) x));
}
static void *_p_FXMainWindowTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXShell *)(FXTopWindow *) ((FXMainWindow *) x));
}
static void *_p_FXTopWindowTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXShell *) ((FXTopWindow *) x));
}
static void *_p_FXRootWindowTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *) ((FXRootWindow *) x));
}
static void *_p_FXCompositeTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *)  ((FXComposite *) x));
}
static void *_p_FXScrollWindowTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXScrollArea *) ((FXScrollWindow *) x));
}
static void *_p_FXShellTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *) ((FXShell *) x));
}
static void *_p_FXGroupBoxTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXPacker *) ((FXGroupBox *) x));
}
static void *_p_FXSplitterTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *) ((FXSplitter *) x));
}
static void *_p_FX4SplitterTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *) ((FX4Splitter *) x));
}
static void *_p_FXPackerTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *) ((FXPacker *) x));
}
static void *_p_FXVerticalFrameTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXPacker *) ((FXVerticalFrame *) x));
}
static void *_p_FXHorizontalFrameTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXPacker *) ((FXHorizontalFrame *) x));
}
static void *_p_FXShutterTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXPacker *)(FXVerticalFrame *) ((FXShutter *) x));
}
static void *_p_FXMatrixTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXPacker *) ((FXMatrix *) x));
}
static void *_p_FXSpringTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXPacker *) ((FXSpring *) x));
}
static void *_p_FXSwitcherTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXPacker *) ((FXSwitcher *) x));
}
static void *_p_FXPopupTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXShell *) ((FXPopup *) x));
}
static void *_p_FXShutterItemTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXPacker *)(FXVerticalFrame *) ((FXShutterItem *) x));
}
static void *_p_FXScrollAreaTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *)  ((FXScrollArea *) x));
}
static void *_p_FXStatusBarTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXPacker *)(FXHorizontalFrame *) ((FXStatusBar *) x));
}
static void *_p_FXMainWindowTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXShell *)(FXTopWindow *) ((FXMainWindow *) x));
}
static void *_p_FXTopWindowTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXShell *) ((FXTopWindow *) x));
}
static void *_p_FXRootWindowTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *)  ((FXRootWindow *) x));
}
static void *_p_FXScrollWindowTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXScrollArea *) ((FXScrollWindow *) x));
}
static void *_p_FXShellTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *)  ((FXShell *) x));
}
static void *_p_FXGroupBoxTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXPacker *) ((FXGroupBox *) x));
}
static void *_p_FXSplitterTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *)  ((FXSplitter *) x));
}
static void *_p_FX4SplitterTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *)  ((FX4Splitter *) x));
}
static void *_p_FXShutterTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXPacker *)(FXVerticalFrame *) ((FXShutter *) x));
}
static void *_p_FXPackerTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *)  ((FXPacker *) x));
}
static void *_p_FXVerticalFrameTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXPacker *) ((FXVerticalFrame *) x));
}
static void *_p_FXHorizontalFrameTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXPacker *) ((FXHorizontalFrame *) x));
}
static void *_p_FXMatrixTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXPacker *) ((FXMatrix *) x));
}
static void *_p_FXSpringTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXPacker *) ((FXSpring *) x));
}
static void *_p_FXSwitcherTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXPacker *) ((FXSwitcher *) x));
}
static void *_p_FXFileStreamTo_p_FXStream(void *x) {
    return (void *)((FXStream *)  ((FXFileStream *) x));
}
static void *_p_FXMemoryStreamTo_p_FXStream(void *x) {
    return (void *)((FXStream *)  ((FXMemoryStream *) x));
}
static void *_p_FXFrameTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *) ((FXFrame *) x));
}
static void *_p_FXPopupTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXShell *) ((FXPopup *) x));
}
static void *_p_FXShutterItemTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *)(FXVerticalFrame *) ((FXShutterItem *) x));
}
static void *_p_FXScrollAreaTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *) ((FXScrollArea *) x));
}
static void *_p_FXStatusBarTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *)(FXHorizontalFrame *) ((FXStatusBar *) x));
}
static void *_p_FXMainWindowTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXShell *)(FXTopWindow *) ((FXMainWindow *) x));
}
static void *_p_FXTopWindowTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXShell *) ((FXTopWindow *) x));
}
static void *_p_FXRootWindowTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *) ((FXRootWindow *) x));
}
static void *_p_FXWindowTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *)  ((FXWindow *) x));
}
static void *_p_FXCompositeTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *) ((FXComposite *) x));
}
static void *_p_FXScrollWindowTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXScrollArea *) ((FXScrollWindow *) x));
}
static void *_p_FXShellTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *) ((FXShell *) x));
}
static void *_p_FXGroupBoxTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *) ((FXGroupBox *) x));
}
static void *_p_FXSplitterTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *) ((FXSplitter *) x));
}
static void *_p_FX4SplitterTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *) ((FX4Splitter *) x));
}
static void *_p_FXPackerTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *) ((FXPacker *) x));
}
static void *_p_FXVerticalFrameTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *) ((FXVerticalFrame *) x));
}
static void *_p_FXHorizontalFrameTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *) ((FXHorizontalFrame *) x));
}
static void *_p_FXShutterTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *)(FXVerticalFrame *) ((FXShutter *) x));
}
static void *_p_FXMatrixTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *) ((FXMatrix *) x));
}
static void *_p_FXSpringTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *) ((FXSpring *) x));
}
static void *_p_FXSwitcherTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *) ((FXSwitcher *) x));
}
static void *_p_FXHorizontalFrameTo_p_FXPacker(void *x) {
    return (void *)((FXPacker *)  ((FXHorizontalFrame *) x));
}
static void *_p_FXVerticalFrameTo_p_FXPacker(void *x) {
    return (void *)((FXPacker *)  ((FXVerticalFrame *) x));
}
static void *_p_FXSpringTo_p_FXPacker(void *x) {
    return (void *)((FXPacker *)  ((FXSpring *) x));
}
static void *_p_FXMatrixTo_p_FXPacker(void *x) {
    return (void *)((FXPacker *)  ((FXMatrix *) x));
}
static void *_p_FXShutterItemTo_p_FXPacker(void *x) {
    return (void *)((FXPacker *) (FXVerticalFrame *) ((FXShutterItem *) x));
}
static void *_p_FXStatusBarTo_p_FXPacker(void *x) {
    return (void *)((FXPacker *) (FXHorizontalFrame *) ((FXStatusBar *) x));
}
static void *_p_FXGroupBoxTo_p_FXPacker(void *x) {
    return (void *)((FXPacker *)  ((FXGroupBox *) x));
}
static void *_p_FXSwitcherTo_p_FXPacker(void *x) {
    return (void *)((FXPacker *)  ((FXSwitcher *) x));
}
static void *_p_FXShutterTo_p_FXPacker(void *x) {
    return (void *)((FXPacker *) (FXVerticalFrame *) ((FXShutter *) x));
}
static void *_p_FXStatusBarTo_p_FXHorizontalFrame(void *x) {
    return (void *)((FXHorizontalFrame *)  ((FXStatusBar *) x));
}
static void *_p_FXShutterItemTo_p_FXVerticalFrame(void *x) {
    return (void *)((FXVerticalFrame *)  ((FXShutterItem *) x));
}
static void *_p_FXShutterTo_p_FXVerticalFrame(void *x) {
    return (void *)((FXVerticalFrame *)  ((FXShutter *) x));
}
static swig_type_info _swigt__p_FXObject[] = {{"_p_FXObject", 0, "FXObject *", 0, 0, 0, 0},{"_p_FXDict", _p_FXDictTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXSettings", _p_FXSettingsTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXAccelTable", _p_FXAccelTableTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXComposite", _p_FXCompositeTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXRegistry", _p_FXRegistryTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXId", _p_FXIdTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXIconDict", _p_FXIconDictTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXGroupBox", _p_FXGroupBoxTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXShell", _p_FXShellTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXStatusBar", _p_FXStatusBarTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXScrollArea", _p_FXScrollAreaTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXPopup", _p_FXPopupTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXWindow", _p_FXWindowTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXScrollWindow", _p_FXScrollWindowTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXRootWindow", _p_FXRootWindowTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXTopWindow", _p_FXTopWindowTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXMainWindow", _p_FXMainWindowTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXRecentFiles", _p_FXRecentFilesTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXDocument", _p_FXDocumentTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXVerticalFrame", _p_FXVerticalFrameTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXHorizontalFrame", _p_FXHorizontalFrameTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXSplitter", _p_FXSplitterTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FX4Splitter", _p_FX4SplitterTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXObject", 0, 0, 0, 0, 0, 0},{"_p_FXStringDict", _p_FXStringDictTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXPacker", _p_FXPackerTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXFileDict", _p_FXFileDictTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXSwitcher", _p_FXSwitcherTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXDebugTarget", _p_FXDebugTargetTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXDataTarget", _p_FXDataTargetTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXShutter", _p_FXShutterTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXDrawable", _p_FXDrawableTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXCursor", _p_FXCursorTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXCURCursor", _p_FXCURCursorTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXGIFCursor", _p_FXGIFCursorTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXDelegator", _p_FXDelegatorTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXApp", _p_FXAppTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXMatrix", _p_FXMatrixTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXShutterItem", _p_FXShutterItemTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXFont", _p_FXFontTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXFrame", _p_FXFrameTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXSpring", _p_FXSpringTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXVisual", _p_FXVisualTo_p_FXObject, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXScrollArea[] = {{"_p_FXScrollArea", 0, "FXScrollArea *", 0, 0, 0, 0},{"_p_FXScrollWindow", _p_FXScrollWindowTo_p_FXScrollArea, 0, 0, 0, 0, 0},{"_p_FXScrollArea", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXShutterItem[] = {{"_p_FXShutterItem", 0, "FXShutterItem *", 0, 0, 0, 0},{"_p_FXShutterItem", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXStatusBar[] = {{"_p_FXStatusBar", 0, "FXStatusBar *", 0, 0, 0, 0},{"_p_FXStatusBar", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXScrollBar[] = {{"_p_FXScrollBar", 0, "FXScrollBar *", 0, 0, 0, 0},{"_p_FXScrollBar", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXWindow[] = {{"_p_FXWindow", 0, "FXWindow *", 0, 0, 0, 0},{"_p_FXFrame", _p_FXFrameTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXPopup", _p_FXPopupTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXShutterItem", _p_FXShutterItemTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXScrollArea", _p_FXScrollAreaTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXStatusBar", _p_FXStatusBarTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXMainWindow", _p_FXMainWindowTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXTopWindow", _p_FXTopWindowTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXRootWindow", _p_FXRootWindowTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXScrollWindow", _p_FXScrollWindowTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXWindow", 0, 0, 0, 0, 0, 0},{"_p_FXComposite", _p_FXCompositeTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXShell", _p_FXShellTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXGroupBox", _p_FXGroupBoxTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FX4Splitter", _p_FX4SplitterTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXSplitter", _p_FXSplitterTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXShutter", _p_FXShutterTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXPacker", _p_FXPackerTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXHorizontalFrame", _p_FXHorizontalFrameTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXVerticalFrame", _p_FXVerticalFrameTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXMatrix", _p_FXMatrixTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXSpring", _p_FXSpringTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXSwitcher", _p_FXSwitcherTo_p_FXWindow, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXComposite[] = {{"_p_FXComposite", 0, "FXComposite *", 0, 0, 0, 0},{"_p_FXPopup", _p_FXPopupTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXShutterItem", _p_FXShutterItemTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXScrollArea", _p_FXScrollAreaTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXStatusBar", _p_FXStatusBarTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXMainWindow", _p_FXMainWindowTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXTopWindow", _p_FXTopWindowTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXRootWindow", _p_FXRootWindowTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXScrollWindow", _p_FXScrollWindowTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXComposite", 0, 0, 0, 0, 0, 0},{"_p_FXShell", _p_FXShellTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXGroupBox", _p_FXGroupBoxTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXSplitter", _p_FXSplitterTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FX4Splitter", _p_FX4SplitterTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXShutter", _p_FXShutterTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXPacker", _p_FXPackerTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXHorizontalFrame", _p_FXHorizontalFrameTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXVerticalFrame", _p_FXVerticalFrameTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXMatrix", _p_FXMatrixTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXSpring", _p_FXSpringTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXSwitcher", _p_FXSwitcherTo_p_FXComposite, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXScrollWindow[] = {{"_p_FXScrollWindow", 0, "FXScrollWindow *", 0, 0, 0, 0},{"_p_FXScrollWindow", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXFont[] = {{"_p_FXFont", 0, "FXFont *", 0, 0, 0, 0},{"_p_FXFont", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXId[] = {{"_p_FXId", 0, "FXId *", 0, 0, 0, 0},{"_p_FXFrame", _p_FXFrameTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXPopup", _p_FXPopupTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXShutterItem", _p_FXShutterItemTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXScrollArea", _p_FXScrollAreaTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXStatusBar", _p_FXStatusBarTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXMainWindow", _p_FXMainWindowTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXTopWindow", _p_FXTopWindowTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXRootWindow", _p_FXRootWindowTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXWindow", _p_FXWindowTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXScrollWindow", _p_FXScrollWindowTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXComposite", _p_FXCompositeTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXId", 0, 0, 0, 0, 0, 0},{"_p_FXFont", _p_FXFontTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXShell", _p_FXShellTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXGroupBox", _p_FXGroupBoxTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FX4Splitter", _p_FX4SplitterTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXSplitter", _p_FXSplitterTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXGIFCursor", _p_FXGIFCursorTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXCURCursor", _p_FXCURCursorTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXCursor", _p_FXCursorTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXDrawable", _p_FXDrawableTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXShutter", _p_FXShutterTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXPacker", _p_FXPackerTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXHorizontalFrame", _p_FXHorizontalFrameTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXVerticalFrame", _p_FXVerticalFrameTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXMatrix", _p_FXMatrixTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXVisual", _p_FXVisualTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXSpring", _p_FXSpringTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXSwitcher", _p_FXSwitcherTo_p_FXId, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXStatusLine[] = {{"_p_FXStatusLine", 0, "FXStatusLine *", 0, 0, 0, 0},{"_p_FXStatusLine", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXGroupBox[] = {{"_p_FXGroupBox", 0, "FXGroupBox *", 0, 0, 0, 0},{"_p_FXGroupBox", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXButton[] = {{"_p_FXButton", 0, "FXButton *", 0, 0, 0, 0},{"_p_FXButton", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXStream[] = {{"_p_FXStream", 0, "FXStream *", 0, 0, 0, 0},{"_p_FXFileStream", _p_FXFileStreamTo_p_FXStream, 0, 0, 0, 0, 0},{"_p_FXMemoryStream", _p_FXMemoryStreamTo_p_FXStream, 0, 0, 0, 0, 0},{"_p_FXStream", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXDrawable[] = {{"_p_FXDrawable", 0, "FXDrawable *", 0, 0, 0, 0},{"_p_FXFrame", _p_FXFrameTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXPopup", _p_FXPopupTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXShutterItem", _p_FXShutterItemTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXScrollArea", _p_FXScrollAreaTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXStatusBar", _p_FXStatusBarTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXMainWindow", _p_FXMainWindowTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXTopWindow", _p_FXTopWindowTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXRootWindow", _p_FXRootWindowTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXWindow", _p_FXWindowTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXScrollWindow", _p_FXScrollWindowTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXComposite", _p_FXCompositeTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXShell", _p_FXShellTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXGroupBox", _p_FXGroupBoxTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXDrawable", 0, 0, 0, 0, 0, 0},{"_p_FX4Splitter", _p_FX4SplitterTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXSplitter", _p_FXSplitterTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXShutter", _p_FXShutterTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXPacker", _p_FXPackerTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXHorizontalFrame", _p_FXHorizontalFrameTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXVerticalFrame", _p_FXVerticalFrameTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXMatrix", _p_FXMatrixTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXSpring", _p_FXSpringTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXSwitcher", _p_FXSwitcherTo_p_FXDrawable, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXSplitter[] = {{"_p_FXSplitter", 0, "FXSplitter *", 0, 0, 0, 0},{"_p_FXSplitter", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FX4Splitter[] = {{"_p_FX4Splitter", 0, "FX4Splitter *", 0, 0, 0, 0},{"_p_FX4Splitter", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXPacker[] = {{"_p_FXPacker", 0, "FXPacker *", 0, 0, 0, 0},{"_p_FXHorizontalFrame", _p_FXHorizontalFrameTo_p_FXPacker, 0, 0, 0, 0, 0},{"_p_FXVerticalFrame", _p_FXVerticalFrameTo_p_FXPacker, 0, 0, 0, 0, 0},{"_p_FXSpring", _p_FXSpringTo_p_FXPacker, 0, 0, 0, 0, 0},{"_p_FXMatrix", _p_FXMatrixTo_p_FXPacker, 0, 0, 0, 0, 0},{"_p_FXStatusBar", _p_FXStatusBarTo_p_FXPacker, 0, 0, 0, 0, 0},{"_p_FXShutterItem", _p_FXShutterItemTo_p_FXPacker, 0, 0, 0, 0, 0},{"_p_FXPacker", 0, 0, 0, 0, 0, 0},{"_p_FXGroupBox", _p_FXGroupBoxTo_p_FXPacker, 0, 0, 0, 0, 0},{"_p_FXSwitcher", _p_FXSwitcherTo_p_FXPacker, 0, 0, 0, 0, 0},{"_p_FXShutter", _p_FXShutterTo_p_FXPacker, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXHorizontalFrame[] = {{"_p_FXHorizontalFrame", 0, "FXHorizontalFrame *", 0, 0, 0, 0},{"_p_FXHorizontalFrame", 0, 0, 0, 0, 0, 0},{"_p_FXStatusBar", _p_FXStatusBarTo_p_FXHorizontalFrame, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXVerticalFrame[] = {{"_p_FXVerticalFrame", 0, "FXVerticalFrame *", 0, 0, 0, 0},{"_p_FXVerticalFrame", 0, 0, 0, 0, 0, 0},{"_p_FXShutterItem", _p_FXShutterItemTo_p_FXVerticalFrame, 0, 0, 0, 0, 0},{"_p_FXShutter", _p_FXShutterTo_p_FXVerticalFrame, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXShutter[] = {{"_p_FXShutter", 0, "FXShutter *", 0, 0, 0, 0},{"_p_FXShutter", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXIcon[] = {{"_p_FXIcon", 0, "FXIcon *", 0, 0, 0, 0},{"_p_FXIcon", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXDragCorner[] = {{"_p_FXDragCorner", 0, "FXDragCorner *", 0, 0, 0, 0},{"_p_FXDragCorner", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXMatrix[] = {{"_p_FXMatrix", 0, "FXMatrix *", 0, 0, 0, 0},{"_p_FXMatrix", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXSpring[] = {{"_p_FXSpring", 0, "FXSpring *", 0, 0, 0, 0},{"_p_FXSpring", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXSwitcher[] = {{"_p_FXSwitcher", 0, "FXSwitcher *", 0, 0, 0, 0},{"_p_FXSwitcher", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};

static swig_type_info *swig_types_initial[] = {
_swigt__p_FXObject, 
_swigt__p_FXScrollArea, 
_swigt__p_FXShutterItem, 
_swigt__p_FXStatusBar, 
_swigt__p_FXScrollBar, 
_swigt__p_FXWindow, 
_swigt__p_FXComposite, 
_swigt__p_FXScrollWindow, 
_swigt__p_FXFont, 
_swigt__p_FXId, 
_swigt__p_FXStatusLine, 
_swigt__p_FXGroupBox, 
_swigt__p_FXButton, 
_swigt__p_FXStream, 
_swigt__p_FXDrawable, 
_swigt__p_FXSplitter, 
_swigt__p_FX4Splitter, 
_swigt__p_FXPacker, 
_swigt__p_FXHorizontalFrame, 
_swigt__p_FXVerticalFrame, 
_swigt__p_FXShutter, 
_swigt__p_FXIcon, 
_swigt__p_FXDragCorner, 
_swigt__p_FXMatrix, 
_swigt__p_FXSpring, 
_swigt__p_FXSwitcher, 
0
};


/* -------- TYPE CONVERSION AND EQUIVALENCE RULES (END) -------- */


#ifdef __cplusplus
extern "C"
#endif
SWIGEXPORT(void) Init_layout(void) {
    int i;
    
    SWIG_InitRuntime();
    
    for (i = 0; swig_types_initial[i]; i++) {
        swig_types[i] = SWIG_TypeRegister(swig_types_initial[i]);
        SWIG_define_class(swig_types[i]);
    }
    
    rb_define_const(mFox,"DEFAULT_SPACING", INT2NUM(DEFAULT_SPACING));
    
    cFXPacker.klass = rb_define_class_under(mFox, "FXPacker", ((swig_class *) SWIGTYPE_p_FXComposite->clientdata)->klass);
    SWIG_TypeClientData(SWIGTYPE_p_FXPacker, (void *) &cFXPacker);
    rb_define_alloc_func(cFXPacker.klass, _wrap_FXPacker_allocate);
    rb_define_method(cFXPacker.klass, "initialize", VALUEFUNC(_wrap_new_FXPacker), -1);
    rb_define_method(cFXPacker.klass, "onPaint", VALUEFUNC(_wrap_FXPacker_onPaint), -1);
    rb_define_method(cFXPacker.klass, "onFocusUp", VALUEFUNC(_wrap_FXPacker_onFocusUp), -1);
    rb_define_method(cFXPacker.klass, "onFocusDown", VALUEFUNC(_wrap_FXPacker_onFocusDown), -1);
    rb_define_method(cFXPacker.klass, "onFocusLeft", VALUEFUNC(_wrap_FXPacker_onFocusLeft), -1);
    rb_define_method(cFXPacker.klass, "onFocusRight", VALUEFUNC(_wrap_FXPacker_onFocusRight), -1);
    rb_define_method(cFXPacker.klass, "setFrameStyle", VALUEFUNC(_wrap_FXPacker_setFrameStyle), -1);
    rb_define_method(cFXPacker.klass, "getFrameStyle", VALUEFUNC(_wrap_FXPacker_getFrameStyle), -1);
    rb_define_method(cFXPacker.klass, "setPackingHints", VALUEFUNC(_wrap_FXPacker_setPackingHints), -1);
    rb_define_method(cFXPacker.klass, "getPackingHints", VALUEFUNC(_wrap_FXPacker_getPackingHints), -1);
    rb_define_method(cFXPacker.klass, "getBorderWidth", VALUEFUNC(_wrap_FXPacker_getBorderWidth), -1);
    rb_define_method(cFXPacker.klass, "setPadTop", VALUEFUNC(_wrap_FXPacker_setPadTop), -1);
    rb_define_method(cFXPacker.klass, "getPadTop", VALUEFUNC(_wrap_FXPacker_getPadTop), -1);
    rb_define_method(cFXPacker.klass, "setPadBottom", VALUEFUNC(_wrap_FXPacker_setPadBottom), -1);
    rb_define_method(cFXPacker.klass, "getPadBottom", VALUEFUNC(_wrap_FXPacker_getPadBottom), -1);
    rb_define_method(cFXPacker.klass, "setPadLeft", VALUEFUNC(_wrap_FXPacker_setPadLeft), -1);
    rb_define_method(cFXPacker.klass, "getPadLeft", VALUEFUNC(_wrap_FXPacker_getPadLeft), -1);
    rb_define_method(cFXPacker.klass, "setPadRight", VALUEFUNC(_wrap_FXPacker_setPadRight), -1);
    rb_define_method(cFXPacker.klass, "getPadRight", VALUEFUNC(_wrap_FXPacker_getPadRight), -1);
    rb_define_method(cFXPacker.klass, "setHiliteColor", VALUEFUNC(_wrap_FXPacker_setHiliteColor), -1);
    rb_define_method(cFXPacker.klass, "getHiliteColor", VALUEFUNC(_wrap_FXPacker_getHiliteColor), -1);
    rb_define_method(cFXPacker.klass, "setShadowColor", VALUEFUNC(_wrap_FXPacker_setShadowColor), -1);
    rb_define_method(cFXPacker.klass, "getShadowColor", VALUEFUNC(_wrap_FXPacker_getShadowColor), -1);
    rb_define_method(cFXPacker.klass, "setBorderColor", VALUEFUNC(_wrap_FXPacker_setBorderColor), -1);
    rb_define_method(cFXPacker.klass, "getBorderColor", VALUEFUNC(_wrap_FXPacker_getBorderColor), -1);
    rb_define_method(cFXPacker.klass, "setBaseColor", VALUEFUNC(_wrap_FXPacker_setBaseColor), -1);
    rb_define_method(cFXPacker.klass, "getBaseColor", VALUEFUNC(_wrap_FXPacker_getBaseColor), -1);
    rb_define_method(cFXPacker.klass, "setHSpacing", VALUEFUNC(_wrap_FXPacker_setHSpacing), -1);
    rb_define_method(cFXPacker.klass, "getHSpacing", VALUEFUNC(_wrap_FXPacker_getHSpacing), -1);
    rb_define_method(cFXPacker.klass, "setVSpacing", VALUEFUNC(_wrap_FXPacker_setVSpacing), -1);
    rb_define_method(cFXPacker.klass, "getVSpacing", VALUEFUNC(_wrap_FXPacker_getVSpacing), -1);
    rb_define_method(cFXPacker.klass, "save", VALUEFUNC(_wrap_FXPacker_save), -1);
    rb_define_method(cFXPacker.klass, "load", VALUEFUNC(_wrap_FXPacker_load), -1);
    rb_define_method(cFXPacker.klass, "create", VALUEFUNC(_wrap_FXPacker_create), -1);
    rb_define_method(cFXPacker.klass, "detach", VALUEFUNC(_wrap_FXPacker_detach), -1);
    rb_define_method(cFXPacker.klass, "destroy", VALUEFUNC(_wrap_FXPacker_destroy), -1);
    rb_define_method(cFXPacker.klass, "resize", VALUEFUNC(_wrap_FXPacker_resize), -1);
    rb_define_method(cFXPacker.klass, "getDefaultWidth", VALUEFUNC(_wrap_FXPacker_getDefaultWidth), -1);
    rb_define_method(cFXPacker.klass, "getDefaultHeight", VALUEFUNC(_wrap_FXPacker_getDefaultHeight), -1);
    rb_define_method(cFXPacker.klass, "getWidthForHeight", VALUEFUNC(_wrap_FXPacker_getWidthForHeight), -1);
    rb_define_method(cFXPacker.klass, "getHeightForWidth", VALUEFUNC(_wrap_FXPacker_getHeightForWidth), -1);
    rb_define_method(cFXPacker.klass, "canFocus", VALUEFUNC(_wrap_FXPacker_canFocus), -1);
    rb_define_method(cFXPacker.klass, "setFocus", VALUEFUNC(_wrap_FXPacker_setFocus), -1);
    rb_define_method(cFXPacker.klass, "killFocus", VALUEFUNC(_wrap_FXPacker_killFocus), -1);
    rb_define_method(cFXPacker.klass, "setDefault", VALUEFUNC(_wrap_FXPacker_setDefault), -1);
    rb_define_method(cFXPacker.klass, "enable", VALUEFUNC(_wrap_FXPacker_enable), -1);
    rb_define_method(cFXPacker.klass, "disable", VALUEFUNC(_wrap_FXPacker_disable), -1);
    rb_define_method(cFXPacker.klass, "raiseWindow", VALUEFUNC(_wrap_FXPacker_raiseWindow), -1);
    rb_define_method(cFXPacker.klass, "lower", VALUEFUNC(_wrap_FXPacker_lower), -1);
    rb_define_method(cFXPacker.klass, "move", VALUEFUNC(_wrap_FXPacker_move), -1);
    rb_define_method(cFXPacker.klass, "position", VALUEFUNC(_wrap_FXPacker_position), -1);
    rb_define_method(cFXPacker.klass, "layout", VALUEFUNC(_wrap_FXPacker_layout), -1);
    rb_define_method(cFXPacker.klass, "recalc", VALUEFUNC(_wrap_FXPacker_recalc), -1);
    rb_define_method(cFXPacker.klass, "reparent", VALUEFUNC(_wrap_FXPacker_reparent), -1);
    rb_define_method(cFXPacker.klass, "show", VALUEFUNC(_wrap_FXPacker_show), -1);
    rb_define_method(cFXPacker.klass, "hide", VALUEFUNC(_wrap_FXPacker_hide), -1);
    rb_define_method(cFXPacker.klass, "isComposite", VALUEFUNC(_wrap_FXPacker_isComposite), -1);
    rb_define_method(cFXPacker.klass, "contains", VALUEFUNC(_wrap_FXPacker_contains), -1);
    rb_define_method(cFXPacker.klass, "doesSaveUnder", VALUEFUNC(_wrap_FXPacker_doesSaveUnder), -1);
    rb_define_method(cFXPacker.klass, "setBackColor", VALUEFUNC(_wrap_FXPacker_setBackColor), -1);
    cFXPacker.mark = (void (*)(void *)) FXRbPacker::markfunc;
    cFXPacker.destroy = (void (*)(void *)) FXRbObject::freefunc;
    
    SWIGTYPE_p_FXPacker->dcast = (swig_dycast_func) FXPacker_dynamic_cast;
    
    
    cFXSpring.klass = rb_define_class_under(mFox, "FXSpring", ((swig_class *) SWIGTYPE_p_FXPacker->clientdata)->klass);
    SWIG_TypeClientData(SWIGTYPE_p_FXSpring, (void *) &cFXSpring);
    rb_define_alloc_func(cFXSpring.klass, _wrap_FXSpring_allocate);
    rb_define_method(cFXSpring.klass, "initialize", VALUEFUNC(_wrap_new_FXSpring), -1);
    rb_define_method(cFXSpring.klass, "setRelativeWidth", VALUEFUNC(_wrap_FXSpring_setRelativeWidth), -1);
    rb_define_method(cFXSpring.klass, "getRelativeWidth", VALUEFUNC(_wrap_FXSpring_getRelativeWidth), -1);
    rb_define_method(cFXSpring.klass, "setRelativeHeight", VALUEFUNC(_wrap_FXSpring_setRelativeHeight), -1);
    rb_define_method(cFXSpring.klass, "getRelativeHeight", VALUEFUNC(_wrap_FXSpring_getRelativeHeight), -1);
    rb_define_method(cFXSpring.klass, "save", VALUEFUNC(_wrap_FXSpring_save), -1);
    rb_define_method(cFXSpring.klass, "load", VALUEFUNC(_wrap_FXSpring_load), -1);
    rb_define_method(cFXSpring.klass, "create", VALUEFUNC(_wrap_FXSpring_create), -1);
    rb_define_method(cFXSpring.klass, "detach", VALUEFUNC(_wrap_FXSpring_detach), -1);
    rb_define_method(cFXSpring.klass, "destroy", VALUEFUNC(_wrap_FXSpring_destroy), -1);
    rb_define_method(cFXSpring.klass, "resize", VALUEFUNC(_wrap_FXSpring_resize), -1);
    rb_define_method(cFXSpring.klass, "getDefaultWidth", VALUEFUNC(_wrap_FXSpring_getDefaultWidth), -1);
    rb_define_method(cFXSpring.klass, "getDefaultHeight", VALUEFUNC(_wrap_FXSpring_getDefaultHeight), -1);
    rb_define_method(cFXSpring.klass, "getWidthForHeight", VALUEFUNC(_wrap_FXSpring_getWidthForHeight), -1);
    rb_define_method(cFXSpring.klass, "getHeightForWidth", VALUEFUNC(_wrap_FXSpring_getHeightForWidth), -1);
    rb_define_method(cFXSpring.klass, "canFocus", VALUEFUNC(_wrap_FXSpring_canFocus), -1);
    rb_define_method(cFXSpring.klass, "setFocus", VALUEFUNC(_wrap_FXSpring_setFocus), -1);
    rb_define_method(cFXSpring.klass, "killFocus", VALUEFUNC(_wrap_FXSpring_killFocus), -1);
    rb_define_method(cFXSpring.klass, "setDefault", VALUEFUNC(_wrap_FXSpring_setDefault), -1);
    rb_define_method(cFXSpring.klass, "enable", VALUEFUNC(_wrap_FXSpring_enable), -1);
    rb_define_method(cFXSpring.klass, "disable", VALUEFUNC(_wrap_FXSpring_disable), -1);
    rb_define_method(cFXSpring.klass, "raiseWindow", VALUEFUNC(_wrap_FXSpring_raiseWindow), -1);
    rb_define_method(cFXSpring.klass, "lower", VALUEFUNC(_wrap_FXSpring_lower), -1);
    rb_define_method(cFXSpring.klass, "move", VALUEFUNC(_wrap_FXSpring_move), -1);
    rb_define_method(cFXSpring.klass, "position", VALUEFUNC(_wrap_FXSpring_position), -1);
    rb_define_method(cFXSpring.klass, "layout", VALUEFUNC(_wrap_FXSpring_layout), -1);
    rb_define_method(cFXSpring.klass, "recalc", VALUEFUNC(_wrap_FXSpring_recalc), -1);
    rb_define_method(cFXSpring.klass, "reparent", VALUEFUNC(_wrap_FXSpring_reparent), -1);
    rb_define_method(cFXSpring.klass, "show", VALUEFUNC(_wrap_FXSpring_show), -1);
    rb_define_method(cFXSpring.klass, "hide", VALUEFUNC(_wrap_FXSpring_hide), -1);
    rb_define_method(cFXSpring.klass, "isComposite", VALUEFUNC(_wrap_FXSpring_isComposite), -1);
    rb_define_method(cFXSpring.klass, "contains", VALUEFUNC(_wrap_FXSpring_contains), -1);
    rb_define_method(cFXSpring.klass, "doesSaveUnder", VALUEFUNC(_wrap_FXSpring_doesSaveUnder), -1);
    rb_define_method(cFXSpring.klass, "setBackColor", VALUEFUNC(_wrap_FXSpring_setBackColor), -1);
    cFXSpring.mark = (void (*)(void *)) FXRbSpring::markfunc;
    cFXSpring.destroy = (void (*)(void *)) FXRbObject::freefunc;
    
    cFXHorizontalFrame.klass = rb_define_class_under(mFox, "FXHorizontalFrame", ((swig_class *) SWIGTYPE_p_FXPacker->clientdata)->klass);
    SWIG_TypeClientData(SWIGTYPE_p_FXHorizontalFrame, (void *) &cFXHorizontalFrame);
    rb_define_alloc_func(cFXHorizontalFrame.klass, _wrap_FXHorizontalFrame_allocate);
    rb_define_method(cFXHorizontalFrame.klass, "initialize", VALUEFUNC(_wrap_new_FXHorizontalFrame), -1);
    rb_define_method(cFXHorizontalFrame.klass, "save", VALUEFUNC(_wrap_FXHorizontalFrame_save), -1);
    rb_define_method(cFXHorizontalFrame.klass, "load", VALUEFUNC(_wrap_FXHorizontalFrame_load), -1);
    rb_define_method(cFXHorizontalFrame.klass, "create", VALUEFUNC(_wrap_FXHorizontalFrame_create), -1);
    rb_define_method(cFXHorizontalFrame.klass, "detach", VALUEFUNC(_wrap_FXHorizontalFrame_detach), -1);
    rb_define_method(cFXHorizontalFrame.klass, "destroy", VALUEFUNC(_wrap_FXHorizontalFrame_destroy), -1);
    rb_define_method(cFXHorizontalFrame.klass, "resize", VALUEFUNC(_wrap_FXHorizontalFrame_resize), -1);
    rb_define_method(cFXHorizontalFrame.klass, "getDefaultWidth", VALUEFUNC(_wrap_FXHorizontalFrame_getDefaultWidth), -1);
    rb_define_method(cFXHorizontalFrame.klass, "getDefaultHeight", VALUEFUNC(_wrap_FXHorizontalFrame_getDefaultHeight), -1);
    rb_define_method(cFXHorizontalFrame.klass, "getWidthForHeight", VALUEFUNC(_wrap_FXHorizontalFrame_getWidthForHeight), -1);
    rb_define_method(cFXHorizontalFrame.klass, "getHeightForWidth", VALUEFUNC(_wrap_FXHorizontalFrame_getHeightForWidth), -1);
    rb_define_method(cFXHorizontalFrame.klass, "canFocus", VALUEFUNC(_wrap_FXHorizontalFrame_canFocus), -1);
    rb_define_method(cFXHorizontalFrame.klass, "setFocus", VALUEFUNC(_wrap_FXHorizontalFrame_setFocus), -1);
    rb_define_method(cFXHorizontalFrame.klass, "killFocus", VALUEFUNC(_wrap_FXHorizontalFrame_killFocus), -1);
    rb_define_method(cFXHorizontalFrame.klass, "setDefault", VALUEFUNC(_wrap_FXHorizontalFrame_setDefault), -1);
    rb_define_method(cFXHorizontalFrame.klass, "enable", VALUEFUNC(_wrap_FXHorizontalFrame_enable), -1);
    rb_define_method(cFXHorizontalFrame.klass, "disable", VALUEFUNC(_wrap_FXHorizontalFrame_disable), -1);
    rb_define_method(cFXHorizontalFrame.klass, "raiseWindow", VALUEFUNC(_wrap_FXHorizontalFrame_raiseWindow), -1);
    rb_define_method(cFXHorizontalFrame.klass, "lower", VALUEFUNC(_wrap_FXHorizontalFrame_lower), -1);
    rb_define_method(cFXHorizontalFrame.klass, "move", VALUEFUNC(_wrap_FXHorizontalFrame_move), -1);
    rb_define_method(cFXHorizontalFrame.klass, "position", VALUEFUNC(_wrap_FXHorizontalFrame_position), -1);
    rb_define_method(cFXHorizontalFrame.klass, "layout", VALUEFUNC(_wrap_FXHorizontalFrame_layout), -1);
    rb_define_method(cFXHorizontalFrame.klass, "recalc", VALUEFUNC(_wrap_FXHorizontalFrame_recalc), -1);
    rb_define_method(cFXHorizontalFrame.klass, "reparent", VALUEFUNC(_wrap_FXHorizontalFrame_reparent), -1);
    rb_define_method(cFXHorizontalFrame.klass, "show", VALUEFUNC(_wrap_FXHorizontalFrame_show), -1);
    rb_define_method(cFXHorizontalFrame.klass, "hide", VALUEFUNC(_wrap_FXHorizontalFrame_hide), -1);
    rb_define_method(cFXHorizontalFrame.klass, "isComposite", VALUEFUNC(_wrap_FXHorizontalFrame_isComposite), -1);
    rb_define_method(cFXHorizontalFrame.klass, "contains", VALUEFUNC(_wrap_FXHorizontalFrame_contains), -1);
    rb_define_method(cFXHorizontalFrame.klass, "doesSaveUnder", VALUEFUNC(_wrap_FXHorizontalFrame_doesSaveUnder), -1);
    rb_define_method(cFXHorizontalFrame.klass, "setBackColor", VALUEFUNC(_wrap_FXHorizontalFrame_setBackColor), -1);
    cFXHorizontalFrame.mark = (void (*)(void *)) FXRbHorizontalFrame::markfunc;
    cFXHorizontalFrame.destroy = (void (*)(void *)) FXRbObject::freefunc;
    
    SWIGTYPE_p_FXHorizontalFrame->dcast = (swig_dycast_func) FXHorizontalFrame_dynamic_cast;
    
    
    cFXVerticalFrame.klass = rb_define_class_under(mFox, "FXVerticalFrame", ((swig_class *) SWIGTYPE_p_FXPacker->clientdata)->klass);
    SWIG_TypeClientData(SWIGTYPE_p_FXVerticalFrame, (void *) &cFXVerticalFrame);
    rb_define_alloc_func(cFXVerticalFrame.klass, _wrap_FXVerticalFrame_allocate);
    rb_define_method(cFXVerticalFrame.klass, "initialize", VALUEFUNC(_wrap_new_FXVerticalFrame), -1);
    rb_define_method(cFXVerticalFrame.klass, "save", VALUEFUNC(_wrap_FXVerticalFrame_save), -1);
    rb_define_method(cFXVerticalFrame.klass, "load", VALUEFUNC(_wrap_FXVerticalFrame_load), -1);
    rb_define_method(cFXVerticalFrame.klass, "create", VALUEFUNC(_wrap_FXVerticalFrame_create), -1);
    rb_define_method(cFXVerticalFrame.klass, "detach", VALUEFUNC(_wrap_FXVerticalFrame_detach), -1);
    rb_define_method(cFXVerticalFrame.klass, "destroy", VALUEFUNC(_wrap_FXVerticalFrame_destroy), -1);
    rb_define_method(cFXVerticalFrame.klass, "resize", VALUEFUNC(_wrap_FXVerticalFrame_resize), -1);
    rb_define_method(cFXVerticalFrame.klass, "getDefaultWidth", VALUEFUNC(_wrap_FXVerticalFrame_getDefaultWidth), -1);
    rb_define_method(cFXVerticalFrame.klass, "getDefaultHeight", VALUEFUNC(_wrap_FXVerticalFrame_getDefaultHeight), -1);
    rb_define_method(cFXVerticalFrame.klass, "getWidthForHeight", VALUEFUNC(_wrap_FXVerticalFrame_getWidthForHeight), -1);
    rb_define_method(cFXVerticalFrame.klass, "getHeightForWidth", VALUEFUNC(_wrap_FXVerticalFrame_getHeightForWidth), -1);
    rb_define_method(cFXVerticalFrame.klass, "canFocus", VALUEFUNC(_wrap_FXVerticalFrame_canFocus), -1);
    rb_define_method(cFXVerticalFrame.klass, "setFocus", VALUEFUNC(_wrap_FXVerticalFrame_setFocus), -1);
    rb_define_method(cFXVerticalFrame.klass, "killFocus", VALUEFUNC(_wrap_FXVerticalFrame_killFocus), -1);
    rb_define_method(cFXVerticalFrame.klass, "setDefault", VALUEFUNC(_wrap_FXVerticalFrame_setDefault), -1);
    rb_define_method(cFXVerticalFrame.klass, "enable", VALUEFUNC(_wrap_FXVerticalFrame_enable), -1);
    rb_define_method(cFXVerticalFrame.klass, "disable", VALUEFUNC(_wrap_FXVerticalFrame_disable), -1);
    rb_define_method(cFXVerticalFrame.klass, "raiseWindow", VALUEFUNC(_wrap_FXVerticalFrame_raiseWindow), -1);
    rb_define_method(cFXVerticalFrame.klass, "lower", VALUEFUNC(_wrap_FXVerticalFrame_lower), -1);
    rb_define_method(cFXVerticalFrame.klass, "move", VALUEFUNC(_wrap_FXVerticalFrame_move), -1);
    rb_define_method(cFXVerticalFrame.klass, "position", VALUEFUNC(_wrap_FXVerticalFrame_position), -1);
    rb_define_method(cFXVerticalFrame.klass, "layout", VALUEFUNC(_wrap_FXVerticalFrame_layout), -1);
    rb_define_method(cFXVerticalFrame.klass, "recalc", VALUEFUNC(_wrap_FXVerticalFrame_recalc), -1);
    rb_define_method(cFXVerticalFrame.klass, "reparent", VALUEFUNC(_wrap_FXVerticalFrame_reparent), -1);
    rb_define_method(cFXVerticalFrame.klass, "show", VALUEFUNC(_wrap_FXVerticalFrame_show), -1);
    rb_define_method(cFXVerticalFrame.klass, "hide", VALUEFUNC(_wrap_FXVerticalFrame_hide), -1);
    rb_define_method(cFXVerticalFrame.klass, "isComposite", VALUEFUNC(_wrap_FXVerticalFrame_isComposite), -1);
    rb_define_method(cFXVerticalFrame.klass, "contains", VALUEFUNC(_wrap_FXVerticalFrame_contains), -1);
    rb_define_method(cFXVerticalFrame.klass, "doesSaveUnder", VALUEFUNC(_wrap_FXVerticalFrame_doesSaveUnder), -1);
    rb_define_method(cFXVerticalFrame.klass, "setBackColor", VALUEFUNC(_wrap_FXVerticalFrame_setBackColor), -1);
    cFXVerticalFrame.mark = (void (*)(void *)) FXRbVerticalFrame::markfunc;
    cFXVerticalFrame.destroy = (void (*)(void *)) FXRbObject::freefunc;
    
    SWIGTYPE_p_FXVerticalFrame->dcast = (swig_dycast_func) FXVerticalFrame_dynamic_cast;
    
    rb_define_const(mFox,"MATRIX_BY_ROWS", INT2NUM(MATRIX_BY_ROWS));
    rb_define_const(mFox,"MATRIX_BY_COLUMNS", INT2NUM(MATRIX_BY_COLUMNS));
    
    cFXMatrix.klass = rb_define_class_under(mFox, "FXMatrix", ((swig_class *) SWIGTYPE_p_FXPacker->clientdata)->klass);
    SWIG_TypeClientData(SWIGTYPE_p_FXMatrix, (void *) &cFXMatrix);
    rb_define_alloc_func(cFXMatrix.klass, _wrap_FXMatrix_allocate);
    rb_define_method(cFXMatrix.klass, "initialize", VALUEFUNC(_wrap_new_FXMatrix), -1);
    rb_define_method(cFXMatrix.klass, "onFocusUp", VALUEFUNC(_wrap_FXMatrix_onFocusUp), -1);
    rb_define_method(cFXMatrix.klass, "onFocusDown", VALUEFUNC(_wrap_FXMatrix_onFocusDown), -1);
    rb_define_method(cFXMatrix.klass, "onFocusLeft", VALUEFUNC(_wrap_FXMatrix_onFocusLeft), -1);
    rb_define_method(cFXMatrix.klass, "onFocusRight", VALUEFUNC(_wrap_FXMatrix_onFocusRight), -1);
    rb_define_method(cFXMatrix.klass, "childAtRowCol", VALUEFUNC(_wrap_FXMatrix_childAtRowCol), -1);
    rb_define_method(cFXMatrix.klass, "rowOfChild", VALUEFUNC(_wrap_FXMatrix_rowOfChild), -1);
    rb_define_method(cFXMatrix.klass, "colOfChild", VALUEFUNC(_wrap_FXMatrix_colOfChild), -1);
    rb_define_method(cFXMatrix.klass, "setMatrixStyle", VALUEFUNC(_wrap_FXMatrix_setMatrixStyle), -1);
    rb_define_method(cFXMatrix.klass, "getMatrixStyle", VALUEFUNC(_wrap_FXMatrix_getMatrixStyle), -1);
    rb_define_method(cFXMatrix.klass, "setNumRows", VALUEFUNC(_wrap_FXMatrix_setNumRows), -1);
    rb_define_method(cFXMatrix.klass, "getNumRows", VALUEFUNC(_wrap_FXMatrix_getNumRows), -1);
    rb_define_method(cFXMatrix.klass, "setNumColumns", VALUEFUNC(_wrap_FXMatrix_setNumColumns), -1);
    rb_define_method(cFXMatrix.klass, "getNumColumns", VALUEFUNC(_wrap_FXMatrix_getNumColumns), -1);
    rb_define_method(cFXMatrix.klass, "save", VALUEFUNC(_wrap_FXMatrix_save), -1);
    rb_define_method(cFXMatrix.klass, "load", VALUEFUNC(_wrap_FXMatrix_load), -1);
    rb_define_method(cFXMatrix.klass, "create", VALUEFUNC(_wrap_FXMatrix_create), -1);
    rb_define_method(cFXMatrix.klass, "detach", VALUEFUNC(_wrap_FXMatrix_detach), -1);
    rb_define_method(cFXMatrix.klass, "destroy", VALUEFUNC(_wrap_FXMatrix_destroy), -1);
    rb_define_method(cFXMatrix.klass, "resize", VALUEFUNC(_wrap_FXMatrix_resize), -1);
    rb_define_method(cFXMatrix.klass, "getDefaultWidth", VALUEFUNC(_wrap_FXMatrix_getDefaultWidth), -1);
    rb_define_method(cFXMatrix.klass, "getDefaultHeight", VALUEFUNC(_wrap_FXMatrix_getDefaultHeight), -1);
    rb_define_method(cFXMatrix.klass, "getWidthForHeight", VALUEFUNC(_wrap_FXMatrix_getWidthForHeight), -1);
    rb_define_method(cFXMatrix.klass, "getHeightForWidth", VALUEFUNC(_wrap_FXMatrix_getHeightForWidth), -1);
    rb_define_method(cFXMatrix.klass, "canFocus", VALUEFUNC(_wrap_FXMatrix_canFocus), -1);
    rb_define_method(cFXMatrix.klass, "setFocus", VALUEFUNC(_wrap_FXMatrix_setFocus), -1);
    rb_define_method(cFXMatrix.klass, "killFocus", VALUEFUNC(_wrap_FXMatrix_killFocus), -1);
    rb_define_method(cFXMatrix.klass, "setDefault", VALUEFUNC(_wrap_FXMatrix_setDefault), -1);
    rb_define_method(cFXMatrix.klass, "enable", VALUEFUNC(_wrap_FXMatrix_enable), -1);
    rb_define_method(cFXMatrix.klass, "disable", VALUEFUNC(_wrap_FXMatrix_disable), -1);
    rb_define_method(cFXMatrix.klass, "raiseWindow", VALUEFUNC(_wrap_FXMatrix_raiseWindow), -1);
    rb_define_method(cFXMatrix.klass, "lower", VALUEFUNC(_wrap_FXMatrix_lower), -1);
    rb_define_method(cFXMatrix.klass, "move", VALUEFUNC(_wrap_FXMatrix_move), -1);
    rb_define_method(cFXMatrix.klass, "position", VALUEFUNC(_wrap_FXMatrix_position), -1);
    rb_define_method(cFXMatrix.klass, "layout", VALUEFUNC(_wrap_FXMatrix_layout), -1);
    rb_define_method(cFXMatrix.klass, "recalc", VALUEFUNC(_wrap_FXMatrix_recalc), -1);
    rb_define_method(cFXMatrix.klass, "reparent", VALUEFUNC(_wrap_FXMatrix_reparent), -1);
    rb_define_method(cFXMatrix.klass, "show", VALUEFUNC(_wrap_FXMatrix_show), -1);
    rb_define_method(cFXMatrix.klass, "hide", VALUEFUNC(_wrap_FXMatrix_hide), -1);
    rb_define_method(cFXMatrix.klass, "isComposite", VALUEFUNC(_wrap_FXMatrix_isComposite), -1);
    rb_define_method(cFXMatrix.klass, "contains", VALUEFUNC(_wrap_FXMatrix_contains), -1);
    rb_define_method(cFXMatrix.klass, "doesSaveUnder", VALUEFUNC(_wrap_FXMatrix_doesSaveUnder), -1);
    rb_define_method(cFXMatrix.klass, "setBackColor", VALUEFUNC(_wrap_FXMatrix_setBackColor), -1);
    cFXMatrix.mark = (void (*)(void *)) FXRbMatrix::markfunc;
    cFXMatrix.destroy = (void (*)(void *)) FXRbObject::freefunc;
    rb_define_const(mFox,"GROUPBOX_TITLE_LEFT", INT2NUM(GROUPBOX_TITLE_LEFT));
    rb_define_const(mFox,"GROUPBOX_TITLE_CENTER", INT2NUM(GROUPBOX_TITLE_CENTER));
    rb_define_const(mFox,"GROUPBOX_TITLE_RIGHT", INT2NUM(GROUPBOX_TITLE_RIGHT));
    rb_define_const(mFox,"GROUPBOX_NORMAL", INT2NUM(GROUPBOX_NORMAL));
    
    cFXGroupBox.klass = rb_define_class_under(mFox, "FXGroupBox", ((swig_class *) SWIGTYPE_p_FXPacker->clientdata)->klass);
    SWIG_TypeClientData(SWIGTYPE_p_FXGroupBox, (void *) &cFXGroupBox);
    rb_define_alloc_func(cFXGroupBox.klass, _wrap_FXGroupBox_allocate);
    rb_define_method(cFXGroupBox.klass, "initialize", VALUEFUNC(_wrap_new_FXGroupBox), -1);
    rb_define_method(cFXGroupBox.klass, "onPaint", VALUEFUNC(_wrap_FXGroupBox_onPaint), -1);
    rb_define_method(cFXGroupBox.klass, "setText", VALUEFUNC(_wrap_FXGroupBox_setText), -1);
    rb_define_method(cFXGroupBox.klass, "getText", VALUEFUNC(_wrap_FXGroupBox_getText), -1);
    rb_define_method(cFXGroupBox.klass, "setGroupBoxStyle", VALUEFUNC(_wrap_FXGroupBox_setGroupBoxStyle), -1);
    rb_define_method(cFXGroupBox.klass, "getGroupBoxStyle", VALUEFUNC(_wrap_FXGroupBox_getGroupBoxStyle), -1);
    rb_define_method(cFXGroupBox.klass, "setFont", VALUEFUNC(_wrap_FXGroupBox_setFont), -1);
    rb_define_method(cFXGroupBox.klass, "getFont", VALUEFUNC(_wrap_FXGroupBox_getFont), -1);
    rb_define_method(cFXGroupBox.klass, "setTextColor", VALUEFUNC(_wrap_FXGroupBox_setTextColor), -1);
    rb_define_method(cFXGroupBox.klass, "getTextColor", VALUEFUNC(_wrap_FXGroupBox_getTextColor), -1);
    rb_define_method(cFXGroupBox.klass, "save", VALUEFUNC(_wrap_FXGroupBox_save), -1);
    rb_define_method(cFXGroupBox.klass, "load", VALUEFUNC(_wrap_FXGroupBox_load), -1);
    rb_define_method(cFXGroupBox.klass, "create", VALUEFUNC(_wrap_FXGroupBox_create), -1);
    rb_define_method(cFXGroupBox.klass, "detach", VALUEFUNC(_wrap_FXGroupBox_detach), -1);
    rb_define_method(cFXGroupBox.klass, "destroy", VALUEFUNC(_wrap_FXGroupBox_destroy), -1);
    rb_define_method(cFXGroupBox.klass, "resize", VALUEFUNC(_wrap_FXGroupBox_resize), -1);
    rb_define_method(cFXGroupBox.klass, "getDefaultWidth", VALUEFUNC(_wrap_FXGroupBox_getDefaultWidth), -1);
    rb_define_method(cFXGroupBox.klass, "getDefaultHeight", VALUEFUNC(_wrap_FXGroupBox_getDefaultHeight), -1);
    rb_define_method(cFXGroupBox.klass, "getWidthForHeight", VALUEFUNC(_wrap_FXGroupBox_getWidthForHeight), -1);
    rb_define_method(cFXGroupBox.klass, "getHeightForWidth", VALUEFUNC(_wrap_FXGroupBox_getHeightForWidth), -1);
    rb_define_method(cFXGroupBox.klass, "canFocus", VALUEFUNC(_wrap_FXGroupBox_canFocus), -1);
    rb_define_method(cFXGroupBox.klass, "setFocus", VALUEFUNC(_wrap_FXGroupBox_setFocus), -1);
    rb_define_method(cFXGroupBox.klass, "killFocus", VALUEFUNC(_wrap_FXGroupBox_killFocus), -1);
    rb_define_method(cFXGroupBox.klass, "setDefault", VALUEFUNC(_wrap_FXGroupBox_setDefault), -1);
    rb_define_method(cFXGroupBox.klass, "enable", VALUEFUNC(_wrap_FXGroupBox_enable), -1);
    rb_define_method(cFXGroupBox.klass, "disable", VALUEFUNC(_wrap_FXGroupBox_disable), -1);
    rb_define_method(cFXGroupBox.klass, "raiseWindow", VALUEFUNC(_wrap_FXGroupBox_raiseWindow), -1);
    rb_define_method(cFXGroupBox.klass, "lower", VALUEFUNC(_wrap_FXGroupBox_lower), -1);
    rb_define_method(cFXGroupBox.klass, "move", VALUEFUNC(_wrap_FXGroupBox_move), -1);
    rb_define_method(cFXGroupBox.klass, "position", VALUEFUNC(_wrap_FXGroupBox_position), -1);
    rb_define_method(cFXGroupBox.klass, "layout", VALUEFUNC(_wrap_FXGroupBox_layout), -1);
    rb_define_method(cFXGroupBox.klass, "recalc", VALUEFUNC(_wrap_FXGroupBox_recalc), -1);
    rb_define_method(cFXGroupBox.klass, "reparent", VALUEFUNC(_wrap_FXGroupBox_reparent), -1);
    rb_define_method(cFXGroupBox.klass, "show", VALUEFUNC(_wrap_FXGroupBox_show), -1);
    rb_define_method(cFXGroupBox.klass, "hide", VALUEFUNC(_wrap_FXGroupBox_hide), -1);
    rb_define_method(cFXGroupBox.klass, "isComposite", VALUEFUNC(_wrap_FXGroupBox_isComposite), -1);
    rb_define_method(cFXGroupBox.klass, "contains", VALUEFUNC(_wrap_FXGroupBox_contains), -1);
    rb_define_method(cFXGroupBox.klass, "doesSaveUnder", VALUEFUNC(_wrap_FXGroupBox_doesSaveUnder), -1);
    rb_define_method(cFXGroupBox.klass, "setBackColor", VALUEFUNC(_wrap_FXGroupBox_setBackColor), -1);
    cFXGroupBox.mark = (void (*)(void *)) FXRbGroupBox::markfunc;
    cFXGroupBox.destroy = (void (*)(void *)) FXRbObject::freefunc;
    rb_define_const(mFox,"SWITCHER_HCOLLAPSE", INT2NUM(SWITCHER_HCOLLAPSE));
    rb_define_const(mFox,"SWITCHER_VCOLLAPSE", INT2NUM(SWITCHER_VCOLLAPSE));
    
    cFXSwitcher.klass = rb_define_class_under(mFox, "FXSwitcher", ((swig_class *) SWIGTYPE_p_FXPacker->clientdata)->klass);
    SWIG_TypeClientData(SWIGTYPE_p_FXSwitcher, (void *) &cFXSwitcher);
    rb_define_alloc_func(cFXSwitcher.klass, _wrap_FXSwitcher_allocate);
    rb_define_method(cFXSwitcher.klass, "initialize", VALUEFUNC(_wrap_new_FXSwitcher), -1);
    rb_define_method(cFXSwitcher.klass, "onPaint", VALUEFUNC(_wrap_FXSwitcher_onPaint), -1);
    rb_define_method(cFXSwitcher.klass, "onCmdSetValue", VALUEFUNC(_wrap_FXSwitcher_onCmdSetValue), -1);
    rb_define_method(cFXSwitcher.klass, "onCmdSetIntValue", VALUEFUNC(_wrap_FXSwitcher_onCmdSetIntValue), -1);
    rb_define_method(cFXSwitcher.klass, "onCmdGetIntValue", VALUEFUNC(_wrap_FXSwitcher_onCmdGetIntValue), -1);
    rb_define_method(cFXSwitcher.klass, "onCmdOpen", VALUEFUNC(_wrap_FXSwitcher_onCmdOpen), -1);
    rb_define_method(cFXSwitcher.klass, "onUpdOpen", VALUEFUNC(_wrap_FXSwitcher_onUpdOpen), -1);
    rb_define_const(cFXSwitcher.klass,"ID_OPEN_FIRST", INT2NUM(FXSwitcher::ID_OPEN_FIRST));
    rb_define_const(cFXSwitcher.klass,"ID_OPEN_SECOND", INT2NUM(FXSwitcher::ID_OPEN_SECOND));
    rb_define_const(cFXSwitcher.klass,"ID_OPEN_THIRD", INT2NUM(FXSwitcher::ID_OPEN_THIRD));
    rb_define_const(cFXSwitcher.klass,"ID_OPEN_FOURTH", INT2NUM(FXSwitcher::ID_OPEN_FOURTH));
    rb_define_const(cFXSwitcher.klass,"ID_OPEN_FIFTH", INT2NUM(FXSwitcher::ID_OPEN_FIFTH));
    rb_define_const(cFXSwitcher.klass,"ID_OPEN_SIXTH", INT2NUM(FXSwitcher::ID_OPEN_SIXTH));
    rb_define_const(cFXSwitcher.klass,"ID_OPEN_SEVENTH", INT2NUM(FXSwitcher::ID_OPEN_SEVENTH));
    rb_define_const(cFXSwitcher.klass,"ID_OPEN_EIGHTH", INT2NUM(FXSwitcher::ID_OPEN_EIGHTH));
    rb_define_const(cFXSwitcher.klass,"ID_OPEN_NINETH", INT2NUM(FXSwitcher::ID_OPEN_NINETH));
    rb_define_const(cFXSwitcher.klass,"ID_OPEN_TENTH", INT2NUM(FXSwitcher::ID_OPEN_TENTH));
    rb_define_const(cFXSwitcher.klass,"ID_OPEN_LAST", INT2NUM(FXSwitcher::ID_OPEN_LAST));
    rb_define_const(cFXSwitcher.klass,"ID_LAST", INT2NUM(FXSwitcher::ID_LAST));
    rb_define_method(cFXSwitcher.klass, "setCurrent", VALUEFUNC(_wrap_FXSwitcher_setCurrent), -1);
    rb_define_method(cFXSwitcher.klass, "getCurrent", VALUEFUNC(_wrap_FXSwitcher_getCurrent), -1);
    rb_define_method(cFXSwitcher.klass, "setSwitcherStyle", VALUEFUNC(_wrap_FXSwitcher_setSwitcherStyle), -1);
    rb_define_method(cFXSwitcher.klass, "getSwitcherStyle", VALUEFUNC(_wrap_FXSwitcher_getSwitcherStyle), -1);
    rb_define_method(cFXSwitcher.klass, "save", VALUEFUNC(_wrap_FXSwitcher_save), -1);
    rb_define_method(cFXSwitcher.klass, "load", VALUEFUNC(_wrap_FXSwitcher_load), -1);
    rb_define_method(cFXSwitcher.klass, "create", VALUEFUNC(_wrap_FXSwitcher_create), -1);
    rb_define_method(cFXSwitcher.klass, "detach", VALUEFUNC(_wrap_FXSwitcher_detach), -1);
    rb_define_method(cFXSwitcher.klass, "destroy", VALUEFUNC(_wrap_FXSwitcher_destroy), -1);
    rb_define_method(cFXSwitcher.klass, "resize", VALUEFUNC(_wrap_FXSwitcher_resize), -1);
    rb_define_method(cFXSwitcher.klass, "getDefaultWidth", VALUEFUNC(_wrap_FXSwitcher_getDefaultWidth), -1);
    rb_define_method(cFXSwitcher.klass, "getDefaultHeight", VALUEFUNC(_wrap_FXSwitcher_getDefaultHeight), -1);
    rb_define_method(cFXSwitcher.klass, "getWidthForHeight", VALUEFUNC(_wrap_FXSwitcher_getWidthForHeight), -1);
    rb_define_method(cFXSwitcher.klass, "getHeightForWidth", VALUEFUNC(_wrap_FXSwitcher_getHeightForWidth), -1);
    rb_define_method(cFXSwitcher.klass, "canFocus", VALUEFUNC(_wrap_FXSwitcher_canFocus), -1);
    rb_define_method(cFXSwitcher.klass, "setFocus", VALUEFUNC(_wrap_FXSwitcher_setFocus), -1);
    rb_define_method(cFXSwitcher.klass, "killFocus", VALUEFUNC(_wrap_FXSwitcher_killFocus), -1);
    rb_define_method(cFXSwitcher.klass, "setDefault", VALUEFUNC(_wrap_FXSwitcher_setDefault), -1);
    rb_define_method(cFXSwitcher.klass, "enable", VALUEFUNC(_wrap_FXSwitcher_enable), -1);
    rb_define_method(cFXSwitcher.klass, "disable", VALUEFUNC(_wrap_FXSwitcher_disable), -1);
    rb_define_method(cFXSwitcher.klass, "raiseWindow", VALUEFUNC(_wrap_FXSwitcher_raiseWindow), -1);
    rb_define_method(cFXSwitcher.klass, "lower", VALUEFUNC(_wrap_FXSwitcher_lower), -1);
    rb_define_method(cFXSwitcher.klass, "move", VALUEFUNC(_wrap_FXSwitcher_move), -1);
    rb_define_method(cFXSwitcher.klass, "position", VALUEFUNC(_wrap_FXSwitcher_position), -1);
    rb_define_method(cFXSwitcher.klass, "layout", VALUEFUNC(_wrap_FXSwitcher_layout), -1);
    rb_define_method(cFXSwitcher.klass, "recalc", VALUEFUNC(_wrap_FXSwitcher_recalc), -1);
    rb_define_method(cFXSwitcher.klass, "reparent", VALUEFUNC(_wrap_FXSwitcher_reparent), -1);
    rb_define_method(cFXSwitcher.klass, "show", VALUEFUNC(_wrap_FXSwitcher_show), -1);
    rb_define_method(cFXSwitcher.klass, "hide", VALUEFUNC(_wrap_FXSwitcher_hide), -1);
    rb_define_method(cFXSwitcher.klass, "isComposite", VALUEFUNC(_wrap_FXSwitcher_isComposite), -1);
    rb_define_method(cFXSwitcher.klass, "contains", VALUEFUNC(_wrap_FXSwitcher_contains), -1);
    rb_define_method(cFXSwitcher.klass, "doesSaveUnder", VALUEFUNC(_wrap_FXSwitcher_doesSaveUnder), -1);
    rb_define_method(cFXSwitcher.klass, "setBackColor", VALUEFUNC(_wrap_FXSwitcher_setBackColor), -1);
    cFXSwitcher.mark = (void (*)(void *)) FXRbSwitcher::markfunc;
    cFXSwitcher.destroy = (void (*)(void *)) FXRbObject::freefunc;
    
    cFXShutterItem.klass = rb_define_class_under(mFox, "FXShutterItem", ((swig_class *) SWIGTYPE_p_FXVerticalFrame->clientdata)->klass);
    SWIG_TypeClientData(SWIGTYPE_p_FXShutterItem, (void *) &cFXShutterItem);
    rb_define_alloc_func(cFXShutterItem.klass, _wrap_FXShutterItem_allocate);
    rb_define_method(cFXShutterItem.klass, "initialize", VALUEFUNC(_wrap_new_FXShutterItem), -1);
    rb_define_method(cFXShutterItem.klass, "onFocusUp", VALUEFUNC(_wrap_FXShutterItem_onFocusUp), -1);
    rb_define_method(cFXShutterItem.klass, "onFocusDown", VALUEFUNC(_wrap_FXShutterItem_onFocusDown), -1);
    rb_define_method(cFXShutterItem.klass, "onCmdButton", VALUEFUNC(_wrap_FXShutterItem_onCmdButton), -1);
    rb_define_const(cFXShutterItem.klass,"ID_SHUTTERITEM_BUTTON", INT2NUM(FXShutterItem::ID_SHUTTERITEM_BUTTON));
    rb_define_const(cFXShutterItem.klass,"ID_LAST", INT2NUM(FXShutterItem::ID_LAST));
    rb_define_method(cFXShutterItem.klass, "getButton", VALUEFUNC(_wrap_FXShutterItem_getButton), -1);
    rb_define_method(cFXShutterItem.klass, "getContent", VALUEFUNC(_wrap_FXShutterItem_getContent), -1);
    rb_define_method(cFXShutterItem.klass, "setHelpText", VALUEFUNC(_wrap_FXShutterItem_setHelpText), -1);
    rb_define_method(cFXShutterItem.klass, "getHelpText", VALUEFUNC(_wrap_FXShutterItem_getHelpText), -1);
    rb_define_method(cFXShutterItem.klass, "setTipText", VALUEFUNC(_wrap_FXShutterItem_setTipText), -1);
    rb_define_method(cFXShutterItem.klass, "getTipText", VALUEFUNC(_wrap_FXShutterItem_getTipText), -1);
    rb_define_method(cFXShutterItem.klass, "save", VALUEFUNC(_wrap_FXShutterItem_save), -1);
    rb_define_method(cFXShutterItem.klass, "load", VALUEFUNC(_wrap_FXShutterItem_load), -1);
    rb_define_method(cFXShutterItem.klass, "create", VALUEFUNC(_wrap_FXShutterItem_create), -1);
    rb_define_method(cFXShutterItem.klass, "detach", VALUEFUNC(_wrap_FXShutterItem_detach), -1);
    rb_define_method(cFXShutterItem.klass, "destroy", VALUEFUNC(_wrap_FXShutterItem_destroy), -1);
    rb_define_method(cFXShutterItem.klass, "resize", VALUEFUNC(_wrap_FXShutterItem_resize), -1);
    rb_define_method(cFXShutterItem.klass, "getDefaultWidth", VALUEFUNC(_wrap_FXShutterItem_getDefaultWidth), -1);
    rb_define_method(cFXShutterItem.klass, "getDefaultHeight", VALUEFUNC(_wrap_FXShutterItem_getDefaultHeight), -1);
    rb_define_method(cFXShutterItem.klass, "getWidthForHeight", VALUEFUNC(_wrap_FXShutterItem_getWidthForHeight), -1);
    rb_define_method(cFXShutterItem.klass, "getHeightForWidth", VALUEFUNC(_wrap_FXShutterItem_getHeightForWidth), -1);
    rb_define_method(cFXShutterItem.klass, "canFocus", VALUEFUNC(_wrap_FXShutterItem_canFocus), -1);
    rb_define_method(cFXShutterItem.klass, "setFocus", VALUEFUNC(_wrap_FXShutterItem_setFocus), -1);
    rb_define_method(cFXShutterItem.klass, "killFocus", VALUEFUNC(_wrap_FXShutterItem_killFocus), -1);
    rb_define_method(cFXShutterItem.klass, "setDefault", VALUEFUNC(_wrap_FXShutterItem_setDefault), -1);
    rb_define_method(cFXShutterItem.klass, "enable", VALUEFUNC(_wrap_FXShutterItem_enable), -1);
    rb_define_method(cFXShutterItem.klass, "disable", VALUEFUNC(_wrap_FXShutterItem_disable), -1);
    rb_define_method(cFXShutterItem.klass, "raiseWindow", VALUEFUNC(_wrap_FXShutterItem_raiseWindow), -1);
    rb_define_method(cFXShutterItem.klass, "lower", VALUEFUNC(_wrap_FXShutterItem_lower), -1);
    rb_define_method(cFXShutterItem.klass, "move", VALUEFUNC(_wrap_FXShutterItem_move), -1);
    rb_define_method(cFXShutterItem.klass, "position", VALUEFUNC(_wrap_FXShutterItem_position), -1);
    rb_define_method(cFXShutterItem.klass, "layout", VALUEFUNC(_wrap_FXShutterItem_layout), -1);
    rb_define_method(cFXShutterItem.klass, "recalc", VALUEFUNC(_wrap_FXShutterItem_recalc), -1);
    rb_define_method(cFXShutterItem.klass, "reparent", VALUEFUNC(_wrap_FXShutterItem_reparent), -1);
    rb_define_method(cFXShutterItem.klass, "show", VALUEFUNC(_wrap_FXShutterItem_show), -1);
    rb_define_method(cFXShutterItem.klass, "hide", VALUEFUNC(_wrap_FXShutterItem_hide), -1);
    rb_define_method(cFXShutterItem.klass, "isComposite", VALUEFUNC(_wrap_FXShutterItem_isComposite), -1);
    rb_define_method(cFXShutterItem.klass, "contains", VALUEFUNC(_wrap_FXShutterItem_contains), -1);
    rb_define_method(cFXShutterItem.klass, "doesSaveUnder", VALUEFUNC(_wrap_FXShutterItem_doesSaveUnder), -1);
    rb_define_method(cFXShutterItem.klass, "setBackColor", VALUEFUNC(_wrap_FXShutterItem_setBackColor), -1);
    cFXShutterItem.mark = (void (*)(void *)) FXRbShutterItem::markfunc;
    cFXShutterItem.destroy = (void (*)(void *)) FXRbObject::freefunc;
    
    cFXShutter.klass = rb_define_class_under(mFox, "FXShutter", ((swig_class *) SWIGTYPE_p_FXVerticalFrame->clientdata)->klass);
    SWIG_TypeClientData(SWIGTYPE_p_FXShutter, (void *) &cFXShutter);
    rb_define_alloc_func(cFXShutter.klass, _wrap_FXShutter_allocate);
    rb_define_method(cFXShutter.klass, "initialize", VALUEFUNC(_wrap_new_FXShutter), -1);
    rb_define_method(cFXShutter.klass, "onFocusUp", VALUEFUNC(_wrap_FXShutter_onFocusUp), -1);
    rb_define_method(cFXShutter.klass, "onFocusDown", VALUEFUNC(_wrap_FXShutter_onFocusDown), -1);
    rb_define_method(cFXShutter.klass, "onTimeout", VALUEFUNC(_wrap_FXShutter_onTimeout), -1);
    rb_define_method(cFXShutter.klass, "onOpenItem", VALUEFUNC(_wrap_FXShutter_onOpenItem), -1);
    rb_define_method(cFXShutter.klass, "onCmdSetValue", VALUEFUNC(_wrap_FXShutter_onCmdSetValue), -1);
    rb_define_method(cFXShutter.klass, "onCmdSetIntValue", VALUEFUNC(_wrap_FXShutter_onCmdSetIntValue), -1);
    rb_define_method(cFXShutter.klass, "onCmdGetIntValue", VALUEFUNC(_wrap_FXShutter_onCmdGetIntValue), -1);
    rb_define_method(cFXShutter.klass, "onCmdOpen", VALUEFUNC(_wrap_FXShutter_onCmdOpen), -1);
    rb_define_method(cFXShutter.klass, "onUpdOpen", VALUEFUNC(_wrap_FXShutter_onUpdOpen), -1);
    rb_define_const(cFXShutter.klass,"ID_SHUTTER_TIMEOUT", INT2NUM(FXShutter::ID_SHUTTER_TIMEOUT));
    rb_define_const(cFXShutter.klass,"ID_OPEN_SHUTTERITEM", INT2NUM(FXShutter::ID_OPEN_SHUTTERITEM));
    rb_define_const(cFXShutter.klass,"ID_OPEN_FIRST", INT2NUM(FXShutter::ID_OPEN_FIRST));
    rb_define_const(cFXShutter.klass,"ID_OPEN_LAST", INT2NUM(FXShutter::ID_OPEN_LAST));
    rb_define_const(cFXShutter.klass,"ID_LAST", INT2NUM(FXShutter::ID_LAST));
    rb_define_method(cFXShutter.klass, "getCurrent", VALUEFUNC(_wrap_FXShutter_getCurrent), -1);
    rb_define_method(cFXShutter.klass, "save", VALUEFUNC(_wrap_FXShutter_save), -1);
    rb_define_method(cFXShutter.klass, "load", VALUEFUNC(_wrap_FXShutter_load), -1);
    rb_define_method(cFXShutter.klass, "create", VALUEFUNC(_wrap_FXShutter_create), -1);
    rb_define_method(cFXShutter.klass, "detach", VALUEFUNC(_wrap_FXShutter_detach), -1);
    rb_define_method(cFXShutter.klass, "destroy", VALUEFUNC(_wrap_FXShutter_destroy), -1);
    rb_define_method(cFXShutter.klass, "resize", VALUEFUNC(_wrap_FXShutter_resize), -1);
    rb_define_method(cFXShutter.klass, "getDefaultWidth", VALUEFUNC(_wrap_FXShutter_getDefaultWidth), -1);
    rb_define_method(cFXShutter.klass, "getDefaultHeight", VALUEFUNC(_wrap_FXShutter_getDefaultHeight), -1);
    rb_define_method(cFXShutter.klass, "getWidthForHeight", VALUEFUNC(_wrap_FXShutter_getWidthForHeight), -1);
    rb_define_method(cFXShutter.klass, "getHeightForWidth", VALUEFUNC(_wrap_FXShutter_getHeightForWidth), -1);
    rb_define_method(cFXShutter.klass, "canFocus", VALUEFUNC(_wrap_FXShutter_canFocus), -1);
    rb_define_method(cFXShutter.klass, "setFocus", VALUEFUNC(_wrap_FXShutter_setFocus), -1);
    rb_define_method(cFXShutter.klass, "killFocus", VALUEFUNC(_wrap_FXShutter_killFocus), -1);
    rb_define_method(cFXShutter.klass, "setDefault", VALUEFUNC(_wrap_FXShutter_setDefault), -1);
    rb_define_method(cFXShutter.klass, "enable", VALUEFUNC(_wrap_FXShutter_enable), -1);
    rb_define_method(cFXShutter.klass, "disable", VALUEFUNC(_wrap_FXShutter_disable), -1);
    rb_define_method(cFXShutter.klass, "raiseWindow", VALUEFUNC(_wrap_FXShutter_raiseWindow), -1);
    rb_define_method(cFXShutter.klass, "lower", VALUEFUNC(_wrap_FXShutter_lower), -1);
    rb_define_method(cFXShutter.klass, "move", VALUEFUNC(_wrap_FXShutter_move), -1);
    rb_define_method(cFXShutter.klass, "position", VALUEFUNC(_wrap_FXShutter_position), -1);
    rb_define_method(cFXShutter.klass, "layout", VALUEFUNC(_wrap_FXShutter_layout), -1);
    rb_define_method(cFXShutter.klass, "recalc", VALUEFUNC(_wrap_FXShutter_recalc), -1);
    rb_define_method(cFXShutter.klass, "reparent", VALUEFUNC(_wrap_FXShutter_reparent), -1);
    rb_define_method(cFXShutter.klass, "show", VALUEFUNC(_wrap_FXShutter_show), -1);
    rb_define_method(cFXShutter.klass, "hide", VALUEFUNC(_wrap_FXShutter_hide), -1);
    rb_define_method(cFXShutter.klass, "isComposite", VALUEFUNC(_wrap_FXShutter_isComposite), -1);
    rb_define_method(cFXShutter.klass, "contains", VALUEFUNC(_wrap_FXShutter_contains), -1);
    rb_define_method(cFXShutter.klass, "doesSaveUnder", VALUEFUNC(_wrap_FXShutter_doesSaveUnder), -1);
    rb_define_method(cFXShutter.klass, "setBackColor", VALUEFUNC(_wrap_FXShutter_setBackColor), -1);
    rb_define_method(cFXShutter.klass, "setCurrent", VALUEFUNC(_wrap_FXShutter_setCurrent), -1);
    cFXShutter.mark = (void (*)(void *)) FXRbShutter::markfunc;
    cFXShutter.destroy = (void (*)(void *)) FXRbObject::freefunc;
    rb_define_const(mFox,"SPLITTER_HORIZONTAL", INT2NUM(SPLITTER_HORIZONTAL));
    rb_define_const(mFox,"SPLITTER_VERTICAL", INT2NUM(SPLITTER_VERTICAL));
    rb_define_const(mFox,"SPLITTER_REVERSED", INT2NUM(SPLITTER_REVERSED));
    rb_define_const(mFox,"SPLITTER_TRACKING", INT2NUM(SPLITTER_TRACKING));
    rb_define_const(mFox,"SPLITTER_NORMAL", INT2NUM(SPLITTER_NORMAL));
    
    cFXSplitter.klass = rb_define_class_under(mFox, "FXSplitter", ((swig_class *) SWIGTYPE_p_FXComposite->clientdata)->klass);
    SWIG_TypeClientData(SWIGTYPE_p_FXSplitter, (void *) &cFXSplitter);
    rb_define_alloc_func(cFXSplitter.klass, _wrap_FXSplitter_allocate);
    rb_define_method(cFXSplitter.klass, "initialize", VALUEFUNC(_wrap_new_FXSplitter), -1);
    rb_define_method(cFXSplitter.klass, "onLeftBtnPress", VALUEFUNC(_wrap_FXSplitter_onLeftBtnPress), -1);
    rb_define_method(cFXSplitter.klass, "onLeftBtnRelease", VALUEFUNC(_wrap_FXSplitter_onLeftBtnRelease), -1);
    rb_define_method(cFXSplitter.klass, "onMotion", VALUEFUNC(_wrap_FXSplitter_onMotion), -1);
    rb_define_method(cFXSplitter.klass, "onFocusNext", VALUEFUNC(_wrap_FXSplitter_onFocusNext), -1);
    rb_define_method(cFXSplitter.klass, "onFocusPrev", VALUEFUNC(_wrap_FXSplitter_onFocusPrev), -1);
    rb_define_method(cFXSplitter.klass, "onFocusUp", VALUEFUNC(_wrap_FXSplitter_onFocusUp), -1);
    rb_define_method(cFXSplitter.klass, "onFocusDown", VALUEFUNC(_wrap_FXSplitter_onFocusDown), -1);
    rb_define_method(cFXSplitter.klass, "onFocusLeft", VALUEFUNC(_wrap_FXSplitter_onFocusLeft), -1);
    rb_define_method(cFXSplitter.klass, "onFocusRight", VALUEFUNC(_wrap_FXSplitter_onFocusRight), -1);
    rb_define_method(cFXSplitter.klass, "getSplit", VALUEFUNC(_wrap_FXSplitter_getSplit), -1);
    rb_define_method(cFXSplitter.klass, "setSplit", VALUEFUNC(_wrap_FXSplitter_setSplit), -1);
    rb_define_method(cFXSplitter.klass, "setSplitterStyle", VALUEFUNC(_wrap_FXSplitter_setSplitterStyle), -1);
    rb_define_method(cFXSplitter.klass, "getSplitterStyle", VALUEFUNC(_wrap_FXSplitter_getSplitterStyle), -1);
    rb_define_method(cFXSplitter.klass, "setBarSize", VALUEFUNC(_wrap_FXSplitter_setBarSize), -1);
    rb_define_method(cFXSplitter.klass, "getBarSize", VALUEFUNC(_wrap_FXSplitter_getBarSize), -1);
    rb_define_method(cFXSplitter.klass, "save", VALUEFUNC(_wrap_FXSplitter_save), -1);
    rb_define_method(cFXSplitter.klass, "load", VALUEFUNC(_wrap_FXSplitter_load), -1);
    rb_define_method(cFXSplitter.klass, "create", VALUEFUNC(_wrap_FXSplitter_create), -1);
    rb_define_method(cFXSplitter.klass, "detach", VALUEFUNC(_wrap_FXSplitter_detach), -1);
    rb_define_method(cFXSplitter.klass, "destroy", VALUEFUNC(_wrap_FXSplitter_destroy), -1);
    rb_define_method(cFXSplitter.klass, "resize", VALUEFUNC(_wrap_FXSplitter_resize), -1);
    rb_define_method(cFXSplitter.klass, "getDefaultWidth", VALUEFUNC(_wrap_FXSplitter_getDefaultWidth), -1);
    rb_define_method(cFXSplitter.klass, "getDefaultHeight", VALUEFUNC(_wrap_FXSplitter_getDefaultHeight), -1);
    rb_define_method(cFXSplitter.klass, "getWidthForHeight", VALUEFUNC(_wrap_FXSplitter_getWidthForHeight), -1);
    rb_define_method(cFXSplitter.klass, "getHeightForWidth", VALUEFUNC(_wrap_FXSplitter_getHeightForWidth), -1);
    rb_define_method(cFXSplitter.klass, "canFocus", VALUEFUNC(_wrap_FXSplitter_canFocus), -1);
    rb_define_method(cFXSplitter.klass, "setFocus", VALUEFUNC(_wrap_FXSplitter_setFocus), -1);
    rb_define_method(cFXSplitter.klass, "killFocus", VALUEFUNC(_wrap_FXSplitter_killFocus), -1);
    rb_define_method(cFXSplitter.klass, "setDefault", VALUEFUNC(_wrap_FXSplitter_setDefault), -1);
    rb_define_method(cFXSplitter.klass, "enable", VALUEFUNC(_wrap_FXSplitter_enable), -1);
    rb_define_method(cFXSplitter.klass, "disable", VALUEFUNC(_wrap_FXSplitter_disable), -1);
    rb_define_method(cFXSplitter.klass, "raiseWindow", VALUEFUNC(_wrap_FXSplitter_raiseWindow), -1);
    rb_define_method(cFXSplitter.klass, "lower", VALUEFUNC(_wrap_FXSplitter_lower), -1);
    rb_define_method(cFXSplitter.klass, "move", VALUEFUNC(_wrap_FXSplitter_move), -1);
    rb_define_method(cFXSplitter.klass, "position", VALUEFUNC(_wrap_FXSplitter_position), -1);
    rb_define_method(cFXSplitter.klass, "layout", VALUEFUNC(_wrap_FXSplitter_layout), -1);
    rb_define_method(cFXSplitter.klass, "recalc", VALUEFUNC(_wrap_FXSplitter_recalc), -1);
    rb_define_method(cFXSplitter.klass, "reparent", VALUEFUNC(_wrap_FXSplitter_reparent), -1);
    rb_define_method(cFXSplitter.klass, "show", VALUEFUNC(_wrap_FXSplitter_show), -1);
    rb_define_method(cFXSplitter.klass, "hide", VALUEFUNC(_wrap_FXSplitter_hide), -1);
    rb_define_method(cFXSplitter.klass, "isComposite", VALUEFUNC(_wrap_FXSplitter_isComposite), -1);
    rb_define_method(cFXSplitter.klass, "contains", VALUEFUNC(_wrap_FXSplitter_contains), -1);
    rb_define_method(cFXSplitter.klass, "doesSaveUnder", VALUEFUNC(_wrap_FXSplitter_doesSaveUnder), -1);
    rb_define_method(cFXSplitter.klass, "setBackColor", VALUEFUNC(_wrap_FXSplitter_setBackColor), -1);
    cFXSplitter.mark = (void (*)(void *)) FXRbSplitter::markfunc;
    cFXSplitter.destroy = (void (*)(void *)) FXRbObject::freefunc;
    rb_define_const(mFox,"FOURSPLITTER_TRACKING", INT2NUM(FOURSPLITTER_TRACKING));
    rb_define_const(mFox,"FOURSPLITTER_NORMAL", INT2NUM(FOURSPLITTER_NORMAL));
    
    cFX4Splitter.klass = rb_define_class_under(mFox, "FX4Splitter", ((swig_class *) SWIGTYPE_p_FXComposite->clientdata)->klass);
    SWIG_TypeClientData(SWIGTYPE_p_FX4Splitter, (void *) &cFX4Splitter);
    rb_define_alloc_func(cFX4Splitter.klass, _wrap_FX4Splitter_allocate);
    rb_define_method(cFX4Splitter.klass, "initialize", VALUEFUNC(_wrap_new_FX4Splitter), -1);
    rb_define_method(cFX4Splitter.klass, "onLeftBtnPress", VALUEFUNC(_wrap_FX4Splitter_onLeftBtnPress), -1);
    rb_define_method(cFX4Splitter.klass, "onLeftBtnRelease", VALUEFUNC(_wrap_FX4Splitter_onLeftBtnRelease), -1);
    rb_define_method(cFX4Splitter.klass, "onMotion", VALUEFUNC(_wrap_FX4Splitter_onMotion), -1);
    rb_define_method(cFX4Splitter.klass, "onFocusUp", VALUEFUNC(_wrap_FX4Splitter_onFocusUp), -1);
    rb_define_method(cFX4Splitter.klass, "onFocusDown", VALUEFUNC(_wrap_FX4Splitter_onFocusDown), -1);
    rb_define_method(cFX4Splitter.klass, "onFocusLeft", VALUEFUNC(_wrap_FX4Splitter_onFocusLeft), -1);
    rb_define_method(cFX4Splitter.klass, "onFocusRight", VALUEFUNC(_wrap_FX4Splitter_onFocusRight), -1);
    rb_define_method(cFX4Splitter.klass, "onCmdExpand", VALUEFUNC(_wrap_FX4Splitter_onCmdExpand), -1);
    rb_define_method(cFX4Splitter.klass, "onUpdExpand", VALUEFUNC(_wrap_FX4Splitter_onUpdExpand), -1);
    rb_define_const(cFX4Splitter.klass,"ID_EXPAND_ALL", INT2NUM(FX4Splitter::ID_EXPAND_ALL));
    rb_define_const(cFX4Splitter.klass,"ID_EXPAND_TOPLEFT", INT2NUM(FX4Splitter::ID_EXPAND_TOPLEFT));
    rb_define_const(cFX4Splitter.klass,"ID_EXPAND_TOPRIGHT", INT2NUM(FX4Splitter::ID_EXPAND_TOPRIGHT));
    rb_define_const(cFX4Splitter.klass,"ID_EXPAND_BOTTOMLEFT", INT2NUM(FX4Splitter::ID_EXPAND_BOTTOMLEFT));
    rb_define_const(cFX4Splitter.klass,"ID_EXPAND_BOTTOMRIGHT", INT2NUM(FX4Splitter::ID_EXPAND_BOTTOMRIGHT));
    rb_define_const(cFX4Splitter.klass,"ID_LAST", INT2NUM(FX4Splitter::ID_LAST));
    rb_define_method(cFX4Splitter.klass, "getTopLeft", VALUEFUNC(_wrap_FX4Splitter_getTopLeft), -1);
    rb_define_method(cFX4Splitter.klass, "getTopRight", VALUEFUNC(_wrap_FX4Splitter_getTopRight), -1);
    rb_define_method(cFX4Splitter.klass, "getBottomLeft", VALUEFUNC(_wrap_FX4Splitter_getBottomLeft), -1);
    rb_define_method(cFX4Splitter.klass, "getBottomRight", VALUEFUNC(_wrap_FX4Splitter_getBottomRight), -1);
    rb_define_method(cFX4Splitter.klass, "getHSplit", VALUEFUNC(_wrap_FX4Splitter_getHSplit), -1);
    rb_define_method(cFX4Splitter.klass, "getVSplit", VALUEFUNC(_wrap_FX4Splitter_getVSplit), -1);
    rb_define_method(cFX4Splitter.klass, "setHSplit", VALUEFUNC(_wrap_FX4Splitter_setHSplit), -1);
    rb_define_method(cFX4Splitter.klass, "setVSplit", VALUEFUNC(_wrap_FX4Splitter_setVSplit), -1);
    rb_define_method(cFX4Splitter.klass, "getSplitterStyle", VALUEFUNC(_wrap_FX4Splitter_getSplitterStyle), -1);
    rb_define_method(cFX4Splitter.klass, "setSplitterStyle", VALUEFUNC(_wrap_FX4Splitter_setSplitterStyle), -1);
    rb_define_method(cFX4Splitter.klass, "setBarSize", VALUEFUNC(_wrap_FX4Splitter_setBarSize), -1);
    rb_define_method(cFX4Splitter.klass, "getBarSize", VALUEFUNC(_wrap_FX4Splitter_getBarSize), -1);
    rb_define_method(cFX4Splitter.klass, "setExpanded", VALUEFUNC(_wrap_FX4Splitter_setExpanded), -1);
    rb_define_method(cFX4Splitter.klass, "getExpanded", VALUEFUNC(_wrap_FX4Splitter_getExpanded), -1);
    rb_define_method(cFX4Splitter.klass, "save", VALUEFUNC(_wrap_FX4Splitter_save), -1);
    rb_define_method(cFX4Splitter.klass, "load", VALUEFUNC(_wrap_FX4Splitter_load), -1);
    rb_define_method(cFX4Splitter.klass, "create", VALUEFUNC(_wrap_FX4Splitter_create), -1);
    rb_define_method(cFX4Splitter.klass, "detach", VALUEFUNC(_wrap_FX4Splitter_detach), -1);
    rb_define_method(cFX4Splitter.klass, "destroy", VALUEFUNC(_wrap_FX4Splitter_destroy), -1);
    rb_define_method(cFX4Splitter.klass, "resize", VALUEFUNC(_wrap_FX4Splitter_resize), -1);
    rb_define_method(cFX4Splitter.klass, "getDefaultWidth", VALUEFUNC(_wrap_FX4Splitter_getDefaultWidth), -1);
    rb_define_method(cFX4Splitter.klass, "getDefaultHeight", VALUEFUNC(_wrap_FX4Splitter_getDefaultHeight), -1);
    rb_define_method(cFX4Splitter.klass, "getWidthForHeight", VALUEFUNC(_wrap_FX4Splitter_getWidthForHeight), -1);
    rb_define_method(cFX4Splitter.klass, "getHeightForWidth", VALUEFUNC(_wrap_FX4Splitter_getHeightForWidth), -1);
    rb_define_method(cFX4Splitter.klass, "canFocus", VALUEFUNC(_wrap_FX4Splitter_canFocus), -1);
    rb_define_method(cFX4Splitter.klass, "setFocus", VALUEFUNC(_wrap_FX4Splitter_setFocus), -1);
    rb_define_method(cFX4Splitter.klass, "killFocus", VALUEFUNC(_wrap_FX4Splitter_killFocus), -1);
    rb_define_method(cFX4Splitter.klass, "setDefault", VALUEFUNC(_wrap_FX4Splitter_setDefault), -1);
    rb_define_method(cFX4Splitter.klass, "enable", VALUEFUNC(_wrap_FX4Splitter_enable), -1);
    rb_define_method(cFX4Splitter.klass, "disable", VALUEFUNC(_wrap_FX4Splitter_disable), -1);
    rb_define_method(cFX4Splitter.klass, "raiseWindow", VALUEFUNC(_wrap_FX4Splitter_raiseWindow), -1);
    rb_define_method(cFX4Splitter.klass, "lower", VALUEFUNC(_wrap_FX4Splitter_lower), -1);
    rb_define_method(cFX4Splitter.klass, "move", VALUEFUNC(_wrap_FX4Splitter_move), -1);
    rb_define_method(cFX4Splitter.klass, "position", VALUEFUNC(_wrap_FX4Splitter_position), -1);
    rb_define_method(cFX4Splitter.klass, "layout", VALUEFUNC(_wrap_FX4Splitter_layout), -1);
    rb_define_method(cFX4Splitter.klass, "recalc", VALUEFUNC(_wrap_FX4Splitter_recalc), -1);
    rb_define_method(cFX4Splitter.klass, "reparent", VALUEFUNC(_wrap_FX4Splitter_reparent), -1);
    rb_define_method(cFX4Splitter.klass, "show", VALUEFUNC(_wrap_FX4Splitter_show), -1);
    rb_define_method(cFX4Splitter.klass, "hide", VALUEFUNC(_wrap_FX4Splitter_hide), -1);
    rb_define_method(cFX4Splitter.klass, "isComposite", VALUEFUNC(_wrap_FX4Splitter_isComposite), -1);
    rb_define_method(cFX4Splitter.klass, "contains", VALUEFUNC(_wrap_FX4Splitter_contains), -1);
    rb_define_method(cFX4Splitter.klass, "doesSaveUnder", VALUEFUNC(_wrap_FX4Splitter_doesSaveUnder), -1);
    rb_define_method(cFX4Splitter.klass, "setBackColor", VALUEFUNC(_wrap_FX4Splitter_setBackColor), -1);
    cFX4Splitter.mark = (void (*)(void *)) FXRb4Splitter::markfunc;
    cFX4Splitter.destroy = (void (*)(void *)) FXRbObject::freefunc;
    rb_define_const(mFox,"STATUSBAR_WITH_DRAGCORNER", INT2NUM(STATUSBAR_WITH_DRAGCORNER));
    
    cFXStatusBar.klass = rb_define_class_under(mFox, "FXStatusBar", ((swig_class *) SWIGTYPE_p_FXHorizontalFrame->clientdata)->klass);
    SWIG_TypeClientData(SWIGTYPE_p_FXStatusBar, (void *) &cFXStatusBar);
    rb_define_alloc_func(cFXStatusBar.klass, _wrap_FXStatusBar_allocate);
    rb_define_method(cFXStatusBar.klass, "initialize", VALUEFUNC(_wrap_new_FXStatusBar), -1);
    rb_define_method(cFXStatusBar.klass, "setCornerStyle", VALUEFUNC(_wrap_FXStatusBar_setCornerStyle), -1);
    rb_define_method(cFXStatusBar.klass, "getCornerStyle", VALUEFUNC(_wrap_FXStatusBar_getCornerStyle), -1);
    rb_define_method(cFXStatusBar.klass, "getStatusLine", VALUEFUNC(_wrap_FXStatusBar_getStatusLine), -1);
    rb_define_method(cFXStatusBar.klass, "getDragCorner", VALUEFUNC(_wrap_FXStatusBar_getDragCorner), -1);
    rb_define_method(cFXStatusBar.klass, "save", VALUEFUNC(_wrap_FXStatusBar_save), -1);
    rb_define_method(cFXStatusBar.klass, "load", VALUEFUNC(_wrap_FXStatusBar_load), -1);
    rb_define_method(cFXStatusBar.klass, "create", VALUEFUNC(_wrap_FXStatusBar_create), -1);
    rb_define_method(cFXStatusBar.klass, "detach", VALUEFUNC(_wrap_FXStatusBar_detach), -1);
    rb_define_method(cFXStatusBar.klass, "destroy", VALUEFUNC(_wrap_FXStatusBar_destroy), -1);
    rb_define_method(cFXStatusBar.klass, "resize", VALUEFUNC(_wrap_FXStatusBar_resize), -1);
    rb_define_method(cFXStatusBar.klass, "getDefaultWidth", VALUEFUNC(_wrap_FXStatusBar_getDefaultWidth), -1);
    rb_define_method(cFXStatusBar.klass, "getDefaultHeight", VALUEFUNC(_wrap_FXStatusBar_getDefaultHeight), -1);
    rb_define_method(cFXStatusBar.klass, "getWidthForHeight", VALUEFUNC(_wrap_FXStatusBar_getWidthForHeight), -1);
    rb_define_method(cFXStatusBar.klass, "getHeightForWidth", VALUEFUNC(_wrap_FXStatusBar_getHeightForWidth), -1);
    rb_define_method(cFXStatusBar.klass, "canFocus", VALUEFUNC(_wrap_FXStatusBar_canFocus), -1);
    rb_define_method(cFXStatusBar.klass, "setFocus", VALUEFUNC(_wrap_FXStatusBar_setFocus), -1);
    rb_define_method(cFXStatusBar.klass, "killFocus", VALUEFUNC(_wrap_FXStatusBar_killFocus), -1);
    rb_define_method(cFXStatusBar.klass, "setDefault", VALUEFUNC(_wrap_FXStatusBar_setDefault), -1);
    rb_define_method(cFXStatusBar.klass, "enable", VALUEFUNC(_wrap_FXStatusBar_enable), -1);
    rb_define_method(cFXStatusBar.klass, "disable", VALUEFUNC(_wrap_FXStatusBar_disable), -1);
    rb_define_method(cFXStatusBar.klass, "raiseWindow", VALUEFUNC(_wrap_FXStatusBar_raiseWindow), -1);
    rb_define_method(cFXStatusBar.klass, "lower", VALUEFUNC(_wrap_FXStatusBar_lower), -1);
    rb_define_method(cFXStatusBar.klass, "move", VALUEFUNC(_wrap_FXStatusBar_move), -1);
    rb_define_method(cFXStatusBar.klass, "position", VALUEFUNC(_wrap_FXStatusBar_position), -1);
    rb_define_method(cFXStatusBar.klass, "layout", VALUEFUNC(_wrap_FXStatusBar_layout), -1);
    rb_define_method(cFXStatusBar.klass, "recalc", VALUEFUNC(_wrap_FXStatusBar_recalc), -1);
    rb_define_method(cFXStatusBar.klass, "reparent", VALUEFUNC(_wrap_FXStatusBar_reparent), -1);
    rb_define_method(cFXStatusBar.klass, "show", VALUEFUNC(_wrap_FXStatusBar_show), -1);
    rb_define_method(cFXStatusBar.klass, "hide", VALUEFUNC(_wrap_FXStatusBar_hide), -1);
    rb_define_method(cFXStatusBar.klass, "isComposite", VALUEFUNC(_wrap_FXStatusBar_isComposite), -1);
    rb_define_method(cFXStatusBar.klass, "contains", VALUEFUNC(_wrap_FXStatusBar_contains), -1);
    rb_define_method(cFXStatusBar.klass, "doesSaveUnder", VALUEFUNC(_wrap_FXStatusBar_doesSaveUnder), -1);
    rb_define_method(cFXStatusBar.klass, "setBackColor", VALUEFUNC(_wrap_FXStatusBar_setBackColor), -1);
    cFXStatusBar.mark = (void (*)(void *)) FXRbStatusBar::markfunc;
    cFXStatusBar.destroy = (void (*)(void *)) FXRbObject::freefunc;
    rb_define_const(mFox,"SCROLLERS_NORMAL", INT2NUM(SCROLLERS_NORMAL));
    rb_define_const(mFox,"HSCROLLER_ALWAYS", INT2NUM(HSCROLLER_ALWAYS));
    rb_define_const(mFox,"HSCROLLER_NEVER", INT2NUM(HSCROLLER_NEVER));
    rb_define_const(mFox,"VSCROLLER_ALWAYS", INT2NUM(VSCROLLER_ALWAYS));
    rb_define_const(mFox,"VSCROLLER_NEVER", INT2NUM(VSCROLLER_NEVER));
    rb_define_const(mFox,"HSCROLLING_ON", INT2NUM(HSCROLLING_ON));
    rb_define_const(mFox,"HSCROLLING_OFF", INT2NUM(HSCROLLING_OFF));
    rb_define_const(mFox,"VSCROLLING_ON", INT2NUM(VSCROLLING_ON));
    rb_define_const(mFox,"VSCROLLING_OFF", INT2NUM(VSCROLLING_OFF));
    rb_define_const(mFox,"SCROLLERS_TRACK", INT2NUM(SCROLLERS_TRACK));
    rb_define_const(mFox,"SCROLLERS_DONT_TRACK", INT2NUM(SCROLLERS_DONT_TRACK));
    
    cFXScrollArea.klass = rb_define_class_under(mFox, "FXScrollArea", ((swig_class *) SWIGTYPE_p_FXComposite->clientdata)->klass);
    SWIG_TypeClientData(SWIGTYPE_p_FXScrollArea, (void *) &cFXScrollArea);
    rb_define_alloc_func(cFXScrollArea.klass, _wrap_FXScrollArea_allocate);
    rb_define_method(cFXScrollArea.klass, "initialize", VALUEFUNC(_wrap_new_FXScrollArea), -1);
    rb_define_method(cFXScrollArea.klass, "onHMouseWheel", VALUEFUNC(_wrap_FXScrollArea_onHMouseWheel), -1);
    rb_define_method(cFXScrollArea.klass, "onVMouseWheel", VALUEFUNC(_wrap_FXScrollArea_onVMouseWheel), -1);
    rb_define_method(cFXScrollArea.klass, "onHScrollerChanged", VALUEFUNC(_wrap_FXScrollArea_onHScrollerChanged), -1);
    rb_define_method(cFXScrollArea.klass, "onVScrollerChanged", VALUEFUNC(_wrap_FXScrollArea_onVScrollerChanged), -1);
    rb_define_method(cFXScrollArea.klass, "onHScrollerDragged", VALUEFUNC(_wrap_FXScrollArea_onHScrollerDragged), -1);
    rb_define_method(cFXScrollArea.klass, "onVScrollerDragged", VALUEFUNC(_wrap_FXScrollArea_onVScrollerDragged), -1);
    rb_define_method(cFXScrollArea.klass, "onAutoScroll", VALUEFUNC(_wrap_FXScrollArea_onAutoScroll), -1);
    rb_define_method(cFXScrollArea.klass, "setScrollStyle", VALUEFUNC(_wrap_FXScrollArea_setScrollStyle), -1);
    rb_define_method(cFXScrollArea.klass, "getScrollStyle", VALUEFUNC(_wrap_FXScrollArea_getScrollStyle), -1);
    rb_define_method(cFXScrollArea.klass, "isHorizontalScrollable", VALUEFUNC(_wrap_FXScrollArea_isHorizontalScrollable), -1);
    rb_define_method(cFXScrollArea.klass, "isVerticalScrollable", VALUEFUNC(_wrap_FXScrollArea_isVerticalScrollable), -1);
    rb_define_method(cFXScrollArea.klass, "horizontalScrollBar", VALUEFUNC(_wrap_FXScrollArea_horizontalScrollBar), -1);
    rb_define_method(cFXScrollArea.klass, "verticalScrollBar", VALUEFUNC(_wrap_FXScrollArea_verticalScrollBar), -1);
    rb_define_method(cFXScrollArea.klass, "getXPosition", VALUEFUNC(_wrap_FXScrollArea_getXPosition), -1);
    rb_define_method(cFXScrollArea.klass, "getYPosition", VALUEFUNC(_wrap_FXScrollArea_getYPosition), -1);
    rb_define_method(cFXScrollArea.klass, "setPosition", VALUEFUNC(_wrap_FXScrollArea_setPosition), -1);
    rb_define_method(cFXScrollArea.klass, "save", VALUEFUNC(_wrap_FXScrollArea_save), -1);
    rb_define_method(cFXScrollArea.klass, "load", VALUEFUNC(_wrap_FXScrollArea_load), -1);
    rb_define_method(cFXScrollArea.klass, "create", VALUEFUNC(_wrap_FXScrollArea_create), -1);
    rb_define_method(cFXScrollArea.klass, "detach", VALUEFUNC(_wrap_FXScrollArea_detach), -1);
    rb_define_method(cFXScrollArea.klass, "destroy", VALUEFUNC(_wrap_FXScrollArea_destroy), -1);
    rb_define_method(cFXScrollArea.klass, "resize", VALUEFUNC(_wrap_FXScrollArea_resize), -1);
    rb_define_method(cFXScrollArea.klass, "getDefaultWidth", VALUEFUNC(_wrap_FXScrollArea_getDefaultWidth), -1);
    rb_define_method(cFXScrollArea.klass, "getDefaultHeight", VALUEFUNC(_wrap_FXScrollArea_getDefaultHeight), -1);
    rb_define_method(cFXScrollArea.klass, "getWidthForHeight", VALUEFUNC(_wrap_FXScrollArea_getWidthForHeight), -1);
    rb_define_method(cFXScrollArea.klass, "getHeightForWidth", VALUEFUNC(_wrap_FXScrollArea_getHeightForWidth), -1);
    rb_define_method(cFXScrollArea.klass, "canFocus", VALUEFUNC(_wrap_FXScrollArea_canFocus), -1);
    rb_define_method(cFXScrollArea.klass, "setFocus", VALUEFUNC(_wrap_FXScrollArea_setFocus), -1);
    rb_define_method(cFXScrollArea.klass, "killFocus", VALUEFUNC(_wrap_FXScrollArea_killFocus), -1);
    rb_define_method(cFXScrollArea.klass, "setDefault", VALUEFUNC(_wrap_FXScrollArea_setDefault), -1);
    rb_define_method(cFXScrollArea.klass, "enable", VALUEFUNC(_wrap_FXScrollArea_enable), -1);
    rb_define_method(cFXScrollArea.klass, "disable", VALUEFUNC(_wrap_FXScrollArea_disable), -1);
    rb_define_method(cFXScrollArea.klass, "raiseWindow", VALUEFUNC(_wrap_FXScrollArea_raiseWindow), -1);
    rb_define_method(cFXScrollArea.klass, "lower", VALUEFUNC(_wrap_FXScrollArea_lower), -1);
    rb_define_method(cFXScrollArea.klass, "move", VALUEFUNC(_wrap_FXScrollArea_move), -1);
    rb_define_method(cFXScrollArea.klass, "layout", VALUEFUNC(_wrap_FXScrollArea_layout), -1);
    rb_define_method(cFXScrollArea.klass, "recalc", VALUEFUNC(_wrap_FXScrollArea_recalc), -1);
    rb_define_method(cFXScrollArea.klass, "reparent", VALUEFUNC(_wrap_FXScrollArea_reparent), -1);
    rb_define_method(cFXScrollArea.klass, "show", VALUEFUNC(_wrap_FXScrollArea_show), -1);
    rb_define_method(cFXScrollArea.klass, "hide", VALUEFUNC(_wrap_FXScrollArea_hide), -1);
    rb_define_method(cFXScrollArea.klass, "isComposite", VALUEFUNC(_wrap_FXScrollArea_isComposite), -1);
    rb_define_method(cFXScrollArea.klass, "contains", VALUEFUNC(_wrap_FXScrollArea_contains), -1);
    rb_define_method(cFXScrollArea.klass, "doesSaveUnder", VALUEFUNC(_wrap_FXScrollArea_doesSaveUnder), -1);
    rb_define_method(cFXScrollArea.klass, "setBackColor", VALUEFUNC(_wrap_FXScrollArea_setBackColor), -1);
    rb_define_method(cFXScrollArea.klass, "getViewportHeight", VALUEFUNC(_wrap_FXScrollArea_getViewportHeight), -1);
    rb_define_method(cFXScrollArea.klass, "getViewportWidth", VALUEFUNC(_wrap_FXScrollArea_getViewportWidth), -1);
    rb_define_method(cFXScrollArea.klass, "getContentHeight", VALUEFUNC(_wrap_FXScrollArea_getContentHeight), -1);
    rb_define_method(cFXScrollArea.klass, "getContentWidth", VALUEFUNC(_wrap_FXScrollArea_getContentWidth), -1);
    rb_define_method(cFXScrollArea.klass, "position", VALUEFUNC(_wrap_FXScrollArea_position), -1);
    cFXScrollArea.mark = (void (*)(void *)) FXRbScrollArea::markfunc;
    cFXScrollArea.destroy = (void (*)(void *)) FXRbObject::freefunc;
    
    SWIGTYPE_p_FXScrollArea->dcast = (swig_dycast_func) FXScrollArea_dynamic_cast;
    
    
    cFXScrollWindow.klass = rb_define_class_under(mFox, "FXScrollWindow", ((swig_class *) SWIGTYPE_p_FXScrollArea->clientdata)->klass);
    SWIG_TypeClientData(SWIGTYPE_p_FXScrollWindow, (void *) &cFXScrollWindow);
    rb_define_alloc_func(cFXScrollWindow.klass, _wrap_FXScrollWindow_allocate);
    rb_define_method(cFXScrollWindow.klass, "initialize", VALUEFUNC(_wrap_new_FXScrollWindow), -1);
    rb_define_method(cFXScrollWindow.klass, "onKeyPress", VALUEFUNC(_wrap_FXScrollWindow_onKeyPress), -1);
    rb_define_method(cFXScrollWindow.klass, "onKeyRelease", VALUEFUNC(_wrap_FXScrollWindow_onKeyRelease), -1);
    rb_define_method(cFXScrollWindow.klass, "onFocusSelf", VALUEFUNC(_wrap_FXScrollWindow_onFocusSelf), -1);
    rb_define_method(cFXScrollWindow.klass, "contentWindow", VALUEFUNC(_wrap_FXScrollWindow_contentWindow), -1);
    rb_define_method(cFXScrollWindow.klass, "save", VALUEFUNC(_wrap_FXScrollWindow_save), -1);
    rb_define_method(cFXScrollWindow.klass, "load", VALUEFUNC(_wrap_FXScrollWindow_load), -1);
    rb_define_method(cFXScrollWindow.klass, "create", VALUEFUNC(_wrap_FXScrollWindow_create), -1);
    rb_define_method(cFXScrollWindow.klass, "detach", VALUEFUNC(_wrap_FXScrollWindow_detach), -1);
    rb_define_method(cFXScrollWindow.klass, "destroy", VALUEFUNC(_wrap_FXScrollWindow_destroy), -1);
    rb_define_method(cFXScrollWindow.klass, "resize", VALUEFUNC(_wrap_FXScrollWindow_resize), -1);
    rb_define_method(cFXScrollWindow.klass, "getDefaultWidth", VALUEFUNC(_wrap_FXScrollWindow_getDefaultWidth), -1);
    rb_define_method(cFXScrollWindow.klass, "getDefaultHeight", VALUEFUNC(_wrap_FXScrollWindow_getDefaultHeight), -1);
    rb_define_method(cFXScrollWindow.klass, "getWidthForHeight", VALUEFUNC(_wrap_FXScrollWindow_getWidthForHeight), -1);
    rb_define_method(cFXScrollWindow.klass, "getHeightForWidth", VALUEFUNC(_wrap_FXScrollWindow_getHeightForWidth), -1);
    rb_define_method(cFXScrollWindow.klass, "canFocus", VALUEFUNC(_wrap_FXScrollWindow_canFocus), -1);
    rb_define_method(cFXScrollWindow.klass, "setFocus", VALUEFUNC(_wrap_FXScrollWindow_setFocus), -1);
    rb_define_method(cFXScrollWindow.klass, "killFocus", VALUEFUNC(_wrap_FXScrollWindow_killFocus), -1);
    rb_define_method(cFXScrollWindow.klass, "setDefault", VALUEFUNC(_wrap_FXScrollWindow_setDefault), -1);
    rb_define_method(cFXScrollWindow.klass, "enable", VALUEFUNC(_wrap_FXScrollWindow_enable), -1);
    rb_define_method(cFXScrollWindow.klass, "disable", VALUEFUNC(_wrap_FXScrollWindow_disable), -1);
    rb_define_method(cFXScrollWindow.klass, "raiseWindow", VALUEFUNC(_wrap_FXScrollWindow_raiseWindow), -1);
    rb_define_method(cFXScrollWindow.klass, "lower", VALUEFUNC(_wrap_FXScrollWindow_lower), -1);
    rb_define_method(cFXScrollWindow.klass, "move", VALUEFUNC(_wrap_FXScrollWindow_move), -1);
    rb_define_method(cFXScrollWindow.klass, "layout", VALUEFUNC(_wrap_FXScrollWindow_layout), -1);
    rb_define_method(cFXScrollWindow.klass, "recalc", VALUEFUNC(_wrap_FXScrollWindow_recalc), -1);
    rb_define_method(cFXScrollWindow.klass, "reparent", VALUEFUNC(_wrap_FXScrollWindow_reparent), -1);
    rb_define_method(cFXScrollWindow.klass, "show", VALUEFUNC(_wrap_FXScrollWindow_show), -1);
    rb_define_method(cFXScrollWindow.klass, "hide", VALUEFUNC(_wrap_FXScrollWindow_hide), -1);
    rb_define_method(cFXScrollWindow.klass, "isComposite", VALUEFUNC(_wrap_FXScrollWindow_isComposite), -1);
    rb_define_method(cFXScrollWindow.klass, "contains", VALUEFUNC(_wrap_FXScrollWindow_contains), -1);
    rb_define_method(cFXScrollWindow.klass, "doesSaveUnder", VALUEFUNC(_wrap_FXScrollWindow_doesSaveUnder), -1);
    rb_define_method(cFXScrollWindow.klass, "setBackColor", VALUEFUNC(_wrap_FXScrollWindow_setBackColor), -1);
    rb_define_method(cFXScrollWindow.klass, "getViewportHeight", VALUEFUNC(_wrap_FXScrollWindow_getViewportHeight), -1);
    rb_define_method(cFXScrollWindow.klass, "getViewportWidth", VALUEFUNC(_wrap_FXScrollWindow_getViewportWidth), -1);
    rb_define_method(cFXScrollWindow.klass, "getContentHeight", VALUEFUNC(_wrap_FXScrollWindow_getContentHeight), -1);
    rb_define_method(cFXScrollWindow.klass, "getContentWidth", VALUEFUNC(_wrap_FXScrollWindow_getContentWidth), -1);
    rb_define_method(cFXScrollWindow.klass, "position", VALUEFUNC(_wrap_FXScrollWindow_position), -1);
    cFXScrollWindow.mark = (void (*)(void *)) FXRbScrollWindow::markfunc;
    cFXScrollWindow.destroy = (void (*)(void *)) FXRbObject::freefunc;
}

