/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 1.3.22
 * 
 * This file is not intended to be easily readable and contains a number of 
 * coding conventions designed to improve portability and efficiency. Do not make
 * changes to this file unless you know what you are doing--modify the SWIG 
 * interface file instead. 
 * ----------------------------------------------------------------------------- */

#define SWIG_NOINCLUDE

#ifdef __cplusplus
template<class T> class SwigValueWrapper {
    T *tt;
public:
    SwigValueWrapper() : tt(0) { }
    SwigValueWrapper(const SwigValueWrapper<T>& rhs) : tt(new T(*rhs.tt)) { }
    SwigValueWrapper(const T& t) : tt(new T(t)) { }
    ~SwigValueWrapper() { delete tt; } 
    SwigValueWrapper& operator=(const T& t) { delete tt; tt = new T(t); return *this; }
    operator T&() const { return *tt; }
    T *operator&() { return tt; }
private:
    SwigValueWrapper& operator=(const SwigValueWrapper<T>& rhs);
};                                                    
#endif

/* ruby.swg */
/* Implementation : RUBY */
#define SWIGRUBY 1

#include "ruby.h"

/* Flags for pointer conversion */
#define SWIG_POINTER_EXCEPTION     0x1
#define SWIG_POINTER_DISOWN        0x2

#define NUM2USHRT(n) (\
    (0 <= NUM2UINT(n) && NUM2UINT(n) <= USHRT_MAX)\
    ? (unsigned short) NUM2UINT(n) \
    : (rb_raise(rb_eArgError, "integer %d out of range of `unsigned short'",\
               NUM2UINT(n)), (short)0)\
)

#define NUM2SHRT(n) (\
    (SHRT_MIN <= NUM2INT(n) && NUM2INT(n) <= SHRT_MAX)\
    ? (short)NUM2INT(n)\
    : (rb_raise(rb_eArgError, "integer %d out of range of `short'",\
               NUM2INT(n)), (short)0)\
)

/* Ruby 1.7 defines NUM2LL(), LL2NUM() and ULL2NUM() macros */
#ifndef NUM2LL
#define NUM2LL(x) NUM2LONG((x))
#endif
#ifndef LL2NUM
#define LL2NUM(x) INT2NUM((long) (x))
#endif
#ifndef ULL2NUM
#define ULL2NUM(x) UINT2NUM((unsigned long) (x))
#endif

/* Ruby 1.7 doesn't (yet) define NUM2ULL() */
#ifndef NUM2ULL
#ifdef HAVE_LONG_LONG
#define NUM2ULL(x) rb_num2ull((x))
#else
#define NUM2ULL(x) NUM2ULONG(x)
#endif
#endif

/*
 * Need to be very careful about how these macros are defined, especially
 * when compiling C++ code or C code with an ANSI C compiler.
 *
 * VALUEFUNC(f) is a macro used to typecast a C function that implements
 * a Ruby method so that it can be passed as an argument to API functions
 * like rb_define_method() and rb_define_singleton_method().
 *
 * VOIDFUNC(f) is a macro used to typecast a C function that implements
 * either the "mark" or "free" stuff for a Ruby Data object, so that it
 * can be passed as an argument to API functions like Data_Wrap_Struct()
 * and Data_Make_Struct().
 */
 
#ifdef __cplusplus
#  ifndef RUBY_METHOD_FUNC /* These definitions should work for Ruby 1.4.6 */
#    define PROTECTFUNC(f) ((VALUE (*)()) f)
#    define VALUEFUNC(f) ((VALUE (*)()) f)
#    define VOIDFUNC(f)  ((void (*)()) f)
#  else
#    ifndef ANYARGS /* These definitions should work for Ruby 1.6 */
#      define PROTECTFUNC(f) ((VALUE (*)()) f)
#      define VALUEFUNC(f) ((VALUE (*)()) f)
#      define VOIDFUNC(f)  ((RUBY_DATA_FUNC) f)
#    else /* These definitions should work for Ruby 1.7+ */
#      define PROTECTFUNC(f) ((VALUE (*)(VALUE)) f)
#      define VALUEFUNC(f) ((VALUE (*)(ANYARGS)) f)
#      define VOIDFUNC(f)  ((RUBY_DATA_FUNC) f)
#    endif
#  endif
#else
#  define VALUEFUNC(f) (f)
#  define VOIDFUNC(f) (f)
#endif

typedef struct {
  VALUE klass;
  VALUE mImpl;
  void  (*mark)(void *);
  void  (*destroy)(void *);
} swig_class;

/* Don't use for expressions have side effect */
#ifndef RB_STRING_VALUE
#define RB_STRING_VALUE(s) (TYPE(s) == T_STRING ? (s) : (*(volatile VALUE *)&(s) = rb_str_to_str(s)))
#endif
#ifndef StringValue
#define StringValue(s) RB_STRING_VALUE(s)
#endif
#ifndef StringValuePtr
#define StringValuePtr(s) RSTRING(RB_STRING_VALUE(s))->ptr
#endif
#ifndef StringValueLen
#define StringValueLen(s) RSTRING(RB_STRING_VALUE(s))->len
#endif
#ifndef SafeStringValue
#define SafeStringValue(v) do {\
    StringValue(v);\
    rb_check_safe_str(v);\
} while (0)
#endif

#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
#define rb_define_alloc_func(klass, func) rb_define_singleton_method((klass), "new", VALUEFUNC((func)), -1)
#define rb_undef_alloc_func(klass) rb_undef_method(CLASS_OF((klass)), "new")
#endif

/* Contract support */

#define SWIG_contract_assert(expr, msg) if (!(expr)) { rb_raise(rb_eRuntimeError, (char *) msg ); } else


/*************************************************************** -*- c -*-
 * ruby/precommon.swg
 *
 * Rename all exported symbols from common.swg, to avoid symbol
 * clashes if multiple interpreters are included
 *
 ************************************************************************/

#define SWIG_TypeRegister    SWIG_Ruby_TypeRegister
#define SWIG_TypeCheck       SWIG_Ruby_TypeCheck
#define SWIG_TypeCast        SWIG_Ruby_TypeCast
#define SWIG_TypeDynamicCast SWIG_Ruby_TypeDynamicCast
#define SWIG_TypeName        SWIG_Ruby_TypeName
#define SWIG_TypePrettyName  SWIG_Ruby_TypePrettyName
#define SWIG_TypeQuery       SWIG_Ruby_TypeQuery
#define SWIG_TypeClientData  SWIG_Ruby_TypeClientData
#define SWIG_PackData        SWIG_Ruby_PackData 
#define SWIG_UnpackData      SWIG_Ruby_UnpackData 

/* Also rename all exported symbols from rubydef.swig */

/* Common SWIG API */
#define SWIG_ConvertPtr(obj, pp, type, flags) \
  SWIG_Ruby_ConvertPtr(obj, pp, type, flags)
#define SWIG_NewPointerObj(p, type, flags) \
  SWIG_Ruby_NewPointerObj(p, type, flags)
#define SWIG_MustGetPtr(p, type, argnum, flags) \
  SWIG_Ruby_MustGetPtr(p, type, argnum, flags)

/* Ruby-specific SWIG API */

#define SWIG_InitRuntime() \
  SWIG_Ruby_InitRuntime()
#define SWIG_define_class(ty) \
  SWIG_Ruby_define_class(ty)
#define SWIG_NewClassInstance(value, ty) \
  SWIG_Ruby_NewClassInstance(value, ty)
#define SWIG_MangleStr(value) \
  SWIG_Ruby_MangleStr(value)
#define SWIG_CheckConvert(value, ty) \
  SWIG_Ruby_CheckConvert(value, ty)
#define SWIG_NewPackedObj(ptr, sz, ty) \
  SWIG_Ruby_NewPackedObj(ptr, sz, ty)
#define SWIG_ConvertPacked(obj, ptr, sz, ty, flags) \
  SWIG_Ruby_ConvertPacked(obj, ptr, sz, ty, flags)


/***********************************************************************
 * common.swg
 *
 *     This file contains generic SWIG runtime support for pointer
 *     type checking as well as a few commonly used macros to control
 *     external linkage.
 *
 * Author : David Beazley (beazley@cs.uchicago.edu)
 *
 * Copyright (c) 1999-2000, The University of Chicago
 * 
 * This file may be freely redistributed without license or fee provided
 * this copyright message remains intact.
 ************************************************************************/

#include <string.h>

#if defined(_WIN32) || defined(__WIN32__) || defined(__CYGWIN__)
#  if defined(_MSC_VER) || defined(__GNUC__)
#    if defined(STATIC_LINKED)
#      define SWIGEXPORT(a) a
#      define SWIGIMPORT(a) extern a
#    else
#      define SWIGEXPORT(a) __declspec(dllexport) a
#      define SWIGIMPORT(a) extern a
#    endif
#  else
#    if defined(__BORLANDC__)
#      define SWIGEXPORT(a) a _export
#      define SWIGIMPORT(a) a _export
#    else
#      define SWIGEXPORT(a) a
#      define SWIGIMPORT(a) a
#    endif
#  endif
#else
#  define SWIGEXPORT(a) a
#  define SWIGIMPORT(a) a
#endif

#ifdef SWIG_GLOBAL
#  define SWIGRUNTIME(a) SWIGEXPORT(a)
#else
#  define SWIGRUNTIME(a) static a
#endif

#ifdef __cplusplus
extern "C" {
#endif

typedef void *(*swig_converter_func)(void *);
typedef struct swig_type_info *(*swig_dycast_func)(void **);

typedef struct swig_type_info {
  const char             *name;
  swig_converter_func     converter;
  const char             *str;
  void                   *clientdata;
  swig_dycast_func        dcast;
  struct swig_type_info  *next;
  struct swig_type_info  *prev;
} swig_type_info;

#ifdef SWIG_NOINCLUDE

SWIGIMPORT(swig_type_info *) SWIG_TypeRegister(swig_type_info *);
SWIGIMPORT(swig_type_info *) SWIG_TypeCheck(char *c, swig_type_info *);
SWIGIMPORT(void *)           SWIG_TypeCast(swig_type_info *, void *);
SWIGIMPORT(swig_type_info *) SWIG_TypeDynamicCast(swig_type_info *, void **);
SWIGIMPORT(const char *)     SWIG_TypeName(const swig_type_info *);
SWIGIMPORT(const char *)     SWIG_TypePrettyName(const swig_type_info *);
SWIGIMPORT(swig_type_info *) SWIG_TypeQuery(const char *);
SWIGIMPORT(void)             SWIG_TypeClientData(swig_type_info *, void *);
SWIGIMPORT(char *)           SWIG_PackData(char *, void *, int);
SWIGIMPORT(char *)           SWIG_UnpackData(char *, void *, int);

#else

static swig_type_info *swig_type_list = 0;
static swig_type_info **swig_type_list_handle = &swig_type_list;

/* Register a type mapping with the type-checking */
SWIGRUNTIME(swig_type_info *)
SWIG_TypeRegister(swig_type_info *ti) {
  swig_type_info *tc, *head, *ret, *next;
  /* Check to see if this type has already been registered */
  tc = *swig_type_list_handle;
  while (tc) {
    if (strcmp(tc->name, ti->name) == 0) {
      /* Already exists in the table.  Just add additional types to the list */
      if (tc->clientdata) ti->clientdata = tc->clientdata;
      head = tc;
      next = tc->next;
      goto l1;
    }
    tc = tc->prev;
  }
  head = ti;
  next = 0;

  /* Place in list */
  ti->prev = *swig_type_list_handle;
  *swig_type_list_handle = ti;

  /* Build linked lists */
  l1:
  ret = head;
  tc = ti + 1;
  /* Patch up the rest of the links */
  while (tc->name) {
    head->next = tc;
    tc->prev = head;
    head = tc;
    tc++;
  }
  if (next) next->prev = head;
  head->next = next;
  return ret;
}

/* Check the typename */
SWIGRUNTIME(swig_type_info *) 
SWIG_TypeCheck(char *c, swig_type_info *ty) {
  swig_type_info *s;
  if (!ty) return 0;        /* Void pointer */
  s = ty->next;             /* First element always just a name */
  do {
    if (strcmp(s->name,c) == 0) {
      if (s == ty->next) return s;
      /* Move s to the top of the linked list */
      s->prev->next = s->next;
      if (s->next) {
        s->next->prev = s->prev;
      }
      /* Insert s as second element in the list */
      s->next = ty->next;
      if (ty->next) ty->next->prev = s;
      ty->next = s;
      s->prev = ty;
      return s;
    }
    s = s->next;
  } while (s && (s != ty->next));
  return 0;
}

/* Cast a pointer up an inheritance hierarchy */
SWIGRUNTIME(void *) 
SWIG_TypeCast(swig_type_info *ty, void *ptr) {
  if ((!ty) || (!ty->converter)) return ptr;
  return (*ty->converter)(ptr);
}

/* Dynamic pointer casting. Down an inheritance hierarchy */
SWIGRUNTIME(swig_type_info *) 
SWIG_TypeDynamicCast(swig_type_info *ty, void **ptr) {
  swig_type_info *lastty = ty;
  if (!ty || !ty->dcast) return ty;
  while (ty && (ty->dcast)) {
    ty = (*ty->dcast)(ptr);
    if (ty) lastty = ty;
  }
  return lastty;
}

/* Return the name associated with this type */
SWIGRUNTIME(const char *)
SWIG_TypeName(const swig_type_info *ty) {
  return ty->name;
}

/* Return the pretty name associated with this type,
   that is an unmangled type name in a form presentable to the user.
*/
SWIGRUNTIME(const char *)
SWIG_TypePrettyName(const swig_type_info *type) {
  /* The "str" field contains the equivalent pretty names of the
     type, separated by vertical-bar characters.  We choose
     to print the last name, as it is often (?) the most
     specific. */
  if (type->str != NULL) {
    const char *last_name = type->str;
    const char *s;
    for (s = type->str; *s; s++)
      if (*s == '|') last_name = s+1;
    return last_name;
  }
  else
    return type->name;
}

/* 
   Compare two type names skipping the space characters, therefore
   "char*" == "char *" and "Class<int>" == "Class<int >", etc.

   Return 0 when the two name types are equivalent, as in
   strncmp, but skipping ' '.
*/
static int
SWIG_TypeNameComp(const char *f1, const char *l1,
		  const char *f2, const char *l2) {
  for (;(f1 != l1) && (f2 != l2); ++f1, ++f2) {
    while ((*f1 == ' ') && (f1 != l1)) ++f1;
    while ((*f2 == ' ') && (f2 != l2)) ++f2;
    if (*f1 != *f2) return *f1 - *f2;
  }
  return (l1 - f1) - (l2 - f2);
}

/*
  Check type equivalence in a name list like <name1>|<name2>|...
*/
static int
SWIG_TypeEquiv(const char *nb, const char *tb) {
  int equiv = 0;
  const char* te = tb + strlen(tb);
  const char* ne = nb;
  while (!equiv && *ne) {
    for (nb = ne; *ne; ++ne) {
      if (*ne == '|') break;
    }
    equiv = SWIG_TypeNameComp(nb, ne, tb, te) == 0;
    if (*ne) ++ne;
  }
  return equiv;
}
  

/* Search for a swig_type_info structure */
SWIGRUNTIME(swig_type_info *)
SWIG_TypeQuery(const char *name) {
  swig_type_info *ty = *swig_type_list_handle;
  while (ty) {
    if (ty->str && (SWIG_TypeEquiv(ty->str,name))) return ty;
    if (ty->name && (strcmp(name,ty->name) == 0)) return ty;
    ty = ty->prev;
  }
  return 0;
}

/* Set the clientdata field for a type */
SWIGRUNTIME(void)
SWIG_TypeClientData(swig_type_info *ti, void *clientdata) {
  swig_type_info *tc, *equiv;
  if (ti->clientdata == clientdata) return;
  ti->clientdata = clientdata;
  equiv = ti->next;
  while (equiv) {
    if (!equiv->converter) {
      tc = *swig_type_list_handle;
      while (tc) {
        if ((strcmp(tc->name, equiv->name) == 0))
          SWIG_TypeClientData(tc,clientdata);
        tc = tc->prev;
      }
    }
    equiv = equiv->next;
  }
}

/* Pack binary data into a string */
SWIGRUNTIME(char *)
SWIG_PackData(char *c, void *ptr, int sz) {
  static char hex[17] = "0123456789abcdef";
  unsigned char *u = (unsigned char *) ptr;
  const unsigned char *eu =  u + sz;
  register unsigned char uu;
  for (; u != eu; ++u) {
    uu = *u;
    *(c++) = hex[(uu & 0xf0) >> 4];
    *(c++) = hex[uu & 0xf];
  }
  return c;
}

/* Unpack binary data from a string */
SWIGRUNTIME(char *)
SWIG_UnpackData(char *c, void *ptr, int sz) {
  register unsigned char uu = 0;
  register int d;
  unsigned char *u = (unsigned char *) ptr;
  const unsigned char *eu =  u + sz;
  for (; u != eu; ++u) {
    d = *(c++);
    if ((d >= '0') && (d <= '9'))
      uu = ((d - '0') << 4);
    else if ((d >= 'a') && (d <= 'f'))
      uu = ((d - ('a'-10)) << 4);
    d = *(c++);
    if ((d >= '0') && (d <= '9'))
      uu |= (d - '0');
    else if ((d >= 'a') && (d <= 'f'))
      uu |= (d - ('a'-10));
    *u = uu;
  }
  return c;
}

#endif

#ifdef __cplusplus
}
#endif

/* rubydec.swg -*- c -*- */
#ifdef __cplusplus
extern "C" {
#endif

SWIGIMPORT(void)   SWIG_Ruby_InitRuntime(void);
SWIGIMPORT(void)   SWIG_Ruby_define_class(swig_type_info *);
SWIGIMPORT(VALUE)  SWIG_Ruby_NewPointerObj(void *, swig_type_info *, int);
SWIGIMPORT(VALUE)  SWIG_Ruby_NewClassInstance(VALUE, swig_type_info *);
SWIGIMPORT(char *) SWIG_Ruby_MangleStr(VALUE);
SWIGIMPORT(int)    SWIG_Ruby_ConvertPtr(VALUE, void**, swig_type_info *, int);
SWIGIMPORT(void *) SWIG_Ruby_MustGetPtr(VALUE, swig_type_info *, int, int);
SWIGIMPORT(int)    SWIG_Ruby_CheckConvert(VALUE, swig_type_info *);
SWIGIMPORT(VALUE)  SWIG_Ruby_NewPackedObj(void *ptr, int sz, swig_type_info *type);
SWIGIMPORT(void)   SWIG_Ruby_ConvertPacked(VALUE obj, void *ptr, int sz, swig_type_info *ty, int flags);

#ifdef __cplusplus
}
#endif


/* -------- TYPES TABLE (BEGIN) -------- */

#define  SWIGTYPE_p_FXId swig_types[0] 
#define  SWIGTYPE_p_FXIcon swig_types[1] 
#define  SWIGTYPE_p_FXComposite swig_types[2] 
#define  SWIGTYPE_p_FXWindow swig_types[3] 
#define  SWIGTYPE_p_FXList swig_types[4] 
#define  SWIGTYPE_p_FXFont swig_types[5] 
#define  SWIGTYPE_p_FXObject swig_types[6] 
#define  SWIGTYPE_p_FXDrawable swig_types[7] 
#define  SWIGTYPE_p_FXScrollArea swig_types[8] 
#define  SWIGTYPE_p_FXListItem swig_types[9] 
#define  SWIGTYPE_p_FXStream swig_types[10] 
static swig_type_info *swig_types[12];

/* -------- TYPES TABLE (END) -------- */

#define SWIG_init    Init_list
#define SWIG_name    "List"


static void SWIG_AsVal(VALUE obj, int *val)
{
    *val = (int) NUM2INT(obj);
}


#include "FXRbCommon.h"


inline FXColor to_FXColor(VALUE obj){
  if(TYPE(obj)==T_STRING){
    return fxcolorfromname(StringValuePtr(obj));
    }
  else if(TYPE(obj)==T_SYMBOL){
    return fxcolorfromname(rb_id2name(SYM2ID(obj)));
    }
  else{
    return NUM2ULONG(obj);
    }
  }


inline FXString to_FXString(VALUE obj){
  if(!NIL_P(obj)){
    Check_Type(obj,T_STRING);
    return FXString(STR2CSTR(obj));
    }
  else{
    return FXString::null;
    }
  }


inline FXbool to_FXbool(VALUE obj){
  if (obj == Qtrue || obj == Qfalse){
    return (obj == Qtrue) ? TRUE : FALSE;
    }
  else{
    return static_cast<FXbool>(NUM2UINT(obj));
    }
  }


static swig_type_info* FXEventTypeInfo=0;

inline void* to_FXEvent(VALUE obj){
  void* ptr;
  if(!FXEventTypeInfo){
    FXEventTypeInfo=SWIG_TypeQuery("FXEvent *");
    FXASSERT(FXEventTypeInfo!=0);
    }
  SWIG_ConvertPtr(obj,&ptr,FXEventTypeInfo,1);
  return ptr;
  }

FXListItem *new_FXListItem(FXString const &text,FXIcon *ic,void *ptr){
      return new FXRbListItem(text,ic,ptr);
      }
void FXListItem_setData(FXListItem *self,VALUE ptr){
      self->setData((void*) ptr);
      }
VALUE FXListItem_getData(FXListItem const *self){
      return self->getData() ? (VALUE) self->getData() : Qnil;
      }

swig_class cFXListItem;
static void free_FXListItem(FXListItem *);
FXList *new_FXList(FXComposite *p,FXObject *tgt,FXSelector sel,FXuint opts,FXint x,FXint y,FXint w,FXint h){
      return new FXRbList(p,tgt,sel,opts,x,y,w,h);
      }
FXint FXList_setItem__SWIG_0(FXList *self,FXint index,FXListItem *item,FXbool notify){
      // Save pointer to the soon-to-be-destroyed item
      FXListItem* oldItem=self->getItem(index);

      // Do the deed
      if(item->isMemberOf(FXMETACLASS(FXRbListItem)))
        dynamic_cast<FXRbListItem*>(item)->owned=1;
      FXint result=self->setItem(index,item,notify);

      // Now zero-out pointers held by still-alive Ruby objects
      FXRbUnregisterRubyObj(oldItem);

      // Done
      return result;
      }
FXint FXList_setItem__SWIG_1(FXList *self,FXint index,FXString const &text,FXIcon *icon,void *ITEMDATA,FXbool notify){
      // Save pointer to the soon-to-be-destroyed item
      FXListItem* oldItem=self->getItem(index);

      // Do the deed
      FXint result=self->setItem(index,text,icon,ITEMDATA,notify);
      
      // Now zero-out pointers held by still-alive Ruby objects
      FXRbUnregisterRubyObj(oldItem);

      // Done
      return result;
      }
FXint FXList_insertItem__SWIG_0(FXList *self,FXint index,FXListItem *item,FXbool notify){
      if(item->isMemberOf(FXMETACLASS(FXRbListItem)))
        dynamic_cast<FXRbListItem*>(item)->owned=1;
      return self->insertItem(index,item,notify);
      }
FXint FXList_appendItem__SWIG_0(FXList *self,FXListItem *item,FXbool notify){
      if(item->isMemberOf(FXMETACLASS(FXRbListItem)))
        dynamic_cast<FXRbListItem*>(item)->owned=1;
      return self->appendItem(item,notify);
      }
FXint FXList_prependItem__SWIG_0(FXList *self,FXListItem *item,FXbool notify){
      if(item->isMemberOf(FXMETACLASS(FXRbListItem)))
        dynamic_cast<FXRbListItem*>(item)->owned=1;
      return self->prependItem(item,notify);
      }
void FXList_removeItem(FXList *self,FXint index,FXbool notify){
      // Save pointer to the soon-to-be-destroyed item
      FXListItem* item=self->getItem(index);

      // Do the deed
      self->removeItem(index,notify);

      // Now zero-out pointers held by still-alive Ruby objects
      FXRbUnregisterRubyObj(item);
      }
void FXList_clearItems(FXList *self,FXbool notify){
      // Save pointers to the soon-to-be-destroyed items
      FXObjectListOf<FXListItem> items;
      for(FXint i=0; i<self->getNumItems(); i++) items.append(self->getItem(i));

      // Do the deed
      self->clearItems(notify);

      // Now zero-out pointers held by still-alive Ruby objects
      for(FXint j=0; j<items.no(); j++) FXRbUnregisterRubyObj(items[j]);
      }
void FXList_makeItemVisible__SWIG_1(FXList *self,FXListItem *item){
      FXint numItems=self->getNumItems();
      for(FXint i=0; i<numItems; i++){
        if(self->getItem(i)==item){
          self->makeItemVisible(i);
	  break;
	  }
	}
      }
void FXList_setItemData(FXList *self,FXint index,VALUE ptr){
      self->setItemData(index, (void*) ptr);
      }
VALUE FXList_getItemData(FXList const *self,FXint index){
      return self->getItemData(index) ? (VALUE) self->getItemData(index) : Qnil;
      }
VALUE FXList_position__SWIG_1(FXList const *self){
    FXint x, y;
    self->getPosition(x, y);
    VALUE pos = rb_ary_new();
    rb_ary_push(pos, INT2NUM(x));
    rb_ary_push(pos, INT2NUM(y));
    return pos;
  }

swig_class cFXList;
static void free_FXList(FXList *);
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE _wrap_FXListItem_allocate(VALUE self) {
#else
     static VALUE _wrap_FXListItem_allocate(int argc, VALUE *argv, VALUE self) {
#endif
         VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_FXListItem);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
         return vresult; }
static VALUE _wrap_new_FXListItem(int argc, VALUE *argv, VALUE self) { FXString *arg1 = 0 ; FXIcon *arg2 = (FXIcon *) 0 ;
    void *arg3 = (void *) 0 ; FXListItem *result; SwigValueWrapper<FXString > p1 ; if ((argc < 1) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc); p1 = to_FXString(argv[0]); arg1 = &p1; if (argc > 1) {
        SWIG_ConvertPtr(argv[1], (void **) &arg2, SWIGTYPE_p_FXIcon, 1); }  if (argc > 2) {
        SWIG_ConvertPtr(argv[2], (void **) &arg3, 0, 1); }  {
        result = (FXListItem *)new_FXListItem((FXString const &)*arg1,arg2,arg3);
        DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result); if(rb_block_given_p()){ rb_yield(self); }  }  return self; }
static VALUE _wrap_FXListItem_getText(int argc, VALUE *argv, VALUE self) { FXListItem *arg1 = (FXListItem *) 0 ;
    FXString *result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXListItem, 1); {
        FXString const &_result_ref = ((FXListItem const *)arg1)->getText(); result = (FXString *) &_result_ref; } 
    vresult = rb_str_new2(result->text()); return vresult; }
static VALUE _wrap_FXListItem_getIcon(int argc, VALUE *argv, VALUE self) { FXListItem *arg1 = (FXListItem *) 0 ; FXIcon *result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXListItem, 1); result = (FXIcon *)((FXListItem const *)arg1)->getIcon();
    { swig_type_info *ty = SWIG_TypeDynamicCast(SWIGTYPE_p_FXIcon, (void **) &result); vresult = FXRbGetRubyObj(result, ty); } 
    return vresult; }
static VALUE _wrap_FXListItem_setData(int argc, VALUE *argv, VALUE self) { FXListItem *arg1 = (FXListItem *) 0 ; VALUE arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXListItem, 1); arg2 = argv[0]; FXListItem_setData(arg1,arg2);
    return Qnil; }
static VALUE _wrap_FXListItem_getData(int argc, VALUE *argv, VALUE self) { FXListItem *arg1 = (FXListItem *) 0 ; VALUE result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXListItem, 1);
    result = (VALUE)FXListItem_getData((FXListItem const *)arg1); vresult = result; return vresult; }
static VALUE _wrap_FXListItem_hasFocus(int argc, VALUE *argv, VALUE self) { FXListItem *arg1 = (FXListItem *) 0 ; FXbool result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXListItem, 1); result = (FXbool)((FXListItem const *)arg1)->hasFocus();
    vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXListItem_isSelected(int argc, VALUE *argv, VALUE self) { FXListItem *arg1 = (FXListItem *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXListItem, 1); result = (FXbool)((FXListItem const *)arg1)->isSelected();
    vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXListItem_isEnabled(int argc, VALUE *argv, VALUE self) { FXListItem *arg1 = (FXListItem *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXListItem, 1); result = (FXbool)((FXListItem const *)arg1)->isEnabled();
    vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXListItem_isDraggable(int argc, VALUE *argv, VALUE self) { FXListItem *arg1 = (FXListItem *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXListItem, 1);
    result = (FXbool)((FXListItem const *)arg1)->isDraggable(); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXListItem_isIconOwned(int argc, VALUE *argv, VALUE self) { FXListItem *arg1 = (FXListItem *) 0 ;
    FXuint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXListItem, 1);
    result = (FXuint)((FXListItem const *)arg1)->isIconOwned(); vresult = UINT2NUM(result); return vresult; }
static void
free_FXListItem(FXListItem *arg1) {
    delete arg1;
}
static VALUE _wrap_FXListItem_save(int argc, VALUE *argv, VALUE self) { FXListItem *arg1 = (FXListItem *) 0 ;
    FXStream *arg2 = 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXListItem, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXListItem_save((FXListItem const *)arg1,*arg2); return Qnil; }
static VALUE _wrap_FXListItem_load(int argc, VALUE *argv, VALUE self) { FXListItem *arg1 = (FXListItem *) 0 ;
    FXStream *arg2 = 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXListItem, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXListItem_load(arg1,*arg2); return Qnil; }
static VALUE _wrap_FXListItem_setText(int argc, VALUE *argv, VALUE self) { FXListItem *arg1 = (FXListItem *) 0 ;
    FXString *arg2 = 0 ; SwigValueWrapper<FXString > p2 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXListItem, 1); p2 = to_FXString(argv[0]); arg2 = &p2;
    FXListItem_setText(arg1,(FXString const &)*arg2); return Qnil; }
static VALUE _wrap_FXListItem_setIcon(int argc, VALUE *argv, VALUE self) { FXListItem *arg1 = (FXListItem *) 0 ;
    FXIcon *arg2 = (FXIcon *) 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXListItem, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXIcon, 1); FXListItem_setIcon(arg1,arg2); return Qnil; }
static VALUE _wrap_FXListItem_setFocus(int argc, VALUE *argv, VALUE self) { FXListItem *arg1 = (FXListItem *) 0 ; FXbool arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXListItem, 1); arg2 = to_FXbool(argv[0]); FXListItem_setFocus(arg1,arg2);
    return Qnil; }
static VALUE _wrap_FXListItem_setSelected(int argc, VALUE *argv, VALUE self) { FXListItem *arg1 = (FXListItem *) 0 ;
    FXbool arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXListItem, 1); arg2 = to_FXbool(argv[0]);
    FXListItem_setSelected(arg1,arg2); return Qnil; }
static VALUE _wrap_FXListItem_setEnabled(int argc, VALUE *argv, VALUE self) { FXListItem *arg1 = (FXListItem *) 0 ;
    FXbool arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXListItem, 1); arg2 = to_FXbool(argv[0]);
    FXListItem_setEnabled(arg1,arg2); return Qnil; }
static VALUE _wrap_FXListItem_setDraggable(int argc, VALUE *argv, VALUE self) { FXListItem *arg1 = (FXListItem *) 0 ;
    FXbool arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXListItem, 1); arg2 = to_FXbool(argv[0]);
    FXListItem_setDraggable(arg1,arg2); return Qnil; }
static VALUE _wrap_FXListItem_setIconOwned(int argc, VALUE *argv, VALUE self) { FXListItem *arg1 = (FXListItem *) 0 ;
    FXuint arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXListItem, 1); arg2 = NUM2UINT(argv[0]);
    FXListItem_setIconOwned(arg1,arg2); return Qnil; }
static VALUE _wrap_FXListItem_getWidth(int argc, VALUE *argv, VALUE self) { FXListItem *arg1 = (FXListItem *) 0 ;
    FXList *arg2 = (FXList *) 0 ; FXint result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXListItem, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXList, 1);
    result = (FXint)FXListItem_getWidth((FXListItem const *)arg1,(FXList const *)arg2); vresult = INT2NUM(result);
    return vresult; }
static VALUE _wrap_FXListItem_getHeight(int argc, VALUE *argv, VALUE self) { FXListItem *arg1 = (FXListItem *) 0 ;
    FXList *arg2 = (FXList *) 0 ; FXint result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXListItem, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXList, 1);
    result = (FXint)FXListItem_getHeight((FXListItem const *)arg1,(FXList const *)arg2); vresult = INT2NUM(result);
    return vresult; }
static VALUE _wrap_FXListItem_create(int argc, VALUE *argv, VALUE self) { FXListItem *arg1 = (FXListItem *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXListItem, 1); FXListItem_create(arg1); return Qnil; }
static VALUE _wrap_FXListItem_detach(int argc, VALUE *argv, VALUE self) { FXListItem *arg1 = (FXListItem *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXListItem, 1); FXListItem_detach(arg1); return Qnil; }
static VALUE _wrap_FXListItem_destroy(int argc, VALUE *argv, VALUE self) { FXListItem *arg1 = (FXListItem *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXListItem, 1); FXListItem_destroy(arg1); return Qnil; }
static VALUE _wrap_FXList_onPaint(int argc, VALUE *argv, VALUE self) { FXList *arg1 = (FXList *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onPaint(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXList_onEnter(int argc, VALUE *argv, VALUE self) { FXList *arg1 = (FXList *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onEnter(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXList_onLeave(int argc, VALUE *argv, VALUE self) { FXList *arg1 = (FXList *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onLeave(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXList_onUngrabbed(int argc, VALUE *argv, VALUE self) { FXList *arg1 = (FXList *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onUngrabbed(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXList_onKeyPress(int argc, VALUE *argv, VALUE self) { FXList *arg1 = (FXList *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onKeyPress(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXList_onKeyRelease(int argc, VALUE *argv, VALUE self) { FXList *arg1 = (FXList *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onKeyRelease(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXList_onLeftBtnPress(int argc, VALUE *argv, VALUE self) { FXList *arg1 = (FXList *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onLeftBtnPress(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXList_onLeftBtnRelease(int argc, VALUE *argv, VALUE self) { FXList *arg1 = (FXList *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onLeftBtnRelease(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXList_onRightBtnPress(int argc, VALUE *argv, VALUE self) { FXList *arg1 = (FXList *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onRightBtnPress(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXList_onRightBtnRelease(int argc, VALUE *argv, VALUE self) { FXList *arg1 = (FXList *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onRightBtnRelease(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXList_onMotion(int argc, VALUE *argv, VALUE self) { FXList *arg1 = (FXList *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onMotion(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXList_onFocusIn(int argc, VALUE *argv, VALUE self) { FXList *arg1 = (FXList *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onFocusIn(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXList_onFocusOut(int argc, VALUE *argv, VALUE self) { FXList *arg1 = (FXList *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onFocusOut(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXList_onAutoScroll(int argc, VALUE *argv, VALUE self) { FXList *arg1 = (FXList *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onAutoScroll(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXList_onClicked(int argc, VALUE *argv, VALUE self) { FXList *arg1 = (FXList *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]);
    arg4 = reinterpret_cast<void*>(NUM2INT(argv[2])); result = (long)(arg1)->onClicked(arg2,arg3,arg4);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXList_onDoubleClicked(int argc, VALUE *argv, VALUE self) { FXList *arg1 = (FXList *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]);
    arg4 = reinterpret_cast<void*>(NUM2INT(argv[2])); result = (long)(arg1)->onDoubleClicked(arg2,arg3,arg4);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXList_onTripleClicked(int argc, VALUE *argv, VALUE self) { FXList *arg1 = (FXList *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]);
    arg4 = reinterpret_cast<void*>(NUM2INT(argv[2])); result = (long)(arg1)->onTripleClicked(arg2,arg3,arg4);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXList_onCommand(int argc, VALUE *argv, VALUE self) { FXList *arg1 = (FXList *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]);
    arg4 = reinterpret_cast<void*>(NUM2INT(argv[2])); result = (long)(arg1)->onCommand(arg2,arg3,arg4);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXList_onQueryTip(int argc, VALUE *argv, VALUE self) { FXList *arg1 = (FXList *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onQueryTip(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXList_onQueryHelp(int argc, VALUE *argv, VALUE self) { FXList *arg1 = (FXList *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onQueryHelp(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXList_onTipTimer(int argc, VALUE *argv, VALUE self) { FXList *arg1 = (FXList *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onTipTimer(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXList_onLookupTimer(int argc, VALUE *argv, VALUE self) { FXList *arg1 = (FXList *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onLookupTimer(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXList_onCmdSetValue(int argc, VALUE *argv, VALUE self) { FXList *arg1 = (FXList *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]);
    arg4 = reinterpret_cast<void*>(NUM2INT(argv[2])); result = (long)(arg1)->onCmdSetValue(arg2,arg3,arg4);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXList_onCmdGetIntValue(int argc, VALUE *argv, VALUE self) { FXList *arg1 = (FXList *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdGetIntValue(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXList_onCmdSetIntValue(int argc, VALUE *argv, VALUE self) { FXList *arg1 = (FXList *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; FXint value4 ;
    VALUE vresult = Qnil; if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); {
        value4 = (FXint) NUM2INT(argv[2]); arg4 = static_cast<void*>(&value4); } 
    result = (long)(arg1)->onCmdSetIntValue(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXList_ascending(int argc, VALUE *argv, VALUE self) { FXListItem *arg1 = (FXListItem *) 0 ;
    FXListItem *arg2 = (FXListItem *) 0 ; FXint result; VALUE vresult = Qnil; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXListItem, 1);
    SWIG_ConvertPtr(argv[1], (void **) &arg2, SWIGTYPE_p_FXListItem, 1);
    result = (FXint)FXList::ascending((FXListItem const *)arg1,(FXListItem const *)arg2); vresult = INT2NUM(result);
    return vresult; }
static VALUE _wrap_FXList_descending(int argc, VALUE *argv, VALUE self) { FXListItem *arg1 = (FXListItem *) 0 ;
    FXListItem *arg2 = (FXListItem *) 0 ; FXint result; VALUE vresult = Qnil; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXListItem, 1);
    SWIG_ConvertPtr(argv[1], (void **) &arg2, SWIGTYPE_p_FXListItem, 1);
    result = (FXint)FXList::descending((FXListItem const *)arg1,(FXListItem const *)arg2); vresult = INT2NUM(result);
    return vresult; }
static VALUE _wrap_FXList_ascendingCase(int argc, VALUE *argv, VALUE self) { FXListItem *arg1 = (FXListItem *) 0 ;
    FXListItem *arg2 = (FXListItem *) 0 ; FXint result; VALUE vresult = Qnil; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXListItem, 1);
    SWIG_ConvertPtr(argv[1], (void **) &arg2, SWIGTYPE_p_FXListItem, 1);
    result = (FXint)FXList::ascendingCase((FXListItem const *)arg1,(FXListItem const *)arg2); vresult = INT2NUM(result);
    return vresult; }
static VALUE _wrap_FXList_descendingCase(int argc, VALUE *argv, VALUE self) { FXListItem *arg1 = (FXListItem *) 0 ;
    FXListItem *arg2 = (FXListItem *) 0 ; FXint result; VALUE vresult = Qnil; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXListItem, 1);
    SWIG_ConvertPtr(argv[1], (void **) &arg2, SWIGTYPE_p_FXListItem, 1);
    result = (FXint)FXList::descendingCase((FXListItem const *)arg1,(FXListItem const *)arg2); vresult = INT2NUM(result);
    return vresult; }
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE _wrap_FXList_allocate(VALUE self) {
#else
     static VALUE _wrap_FXList_allocate(int argc, VALUE *argv, VALUE self) {
#endif
         VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_FXList);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
         return vresult; }
static VALUE _wrap_new_FXList(int argc, VALUE *argv, VALUE self) { FXComposite *arg1 = (FXComposite *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 = (FXSelector) 0 ; FXuint arg4 = (FXuint) LIST_NORMAL ;
    FXint arg5 = (FXint) 0 ; FXint arg6 = (FXint) 0 ; FXint arg7 = (FXint) 0 ; FXint arg8 = (FXint) 0 ; FXList *result;
    if ((argc < 1) || (argc > 8)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXComposite, 1); if (argc > 1) {
        SWIG_ConvertPtr(argv[1], (void **) &arg2, SWIGTYPE_p_FXObject, 1); }  if (argc > 2) { arg3 = NUM2UINT(argv[2]); } 
    if (argc > 3) { arg4 = NUM2UINT(argv[3]); }  if (argc > 4) { arg5 = NUM2INT(argv[4]); }  if (argc > 5) {
        arg6 = NUM2INT(argv[5]); }  if (argc > 6) { arg7 = NUM2INT(argv[6]); }  if (argc > 7) { arg8 = NUM2INT(argv[7]); }  {
        result = (FXList *)new_FXList(arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8);
        DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result); if(rb_block_given_p()){ rb_yield(self); }  }  return self; }
static VALUE _wrap_FXList_getNumItems(int argc, VALUE *argv, VALUE self) { FXList *arg1 = (FXList *) 0 ; FXint result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXList, 1); result = (FXint)((FXList const *)arg1)->getNumItems();
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXList_getNumVisible(int argc, VALUE *argv, VALUE self) { FXList *arg1 = (FXList *) 0 ; FXint result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXList, 1); result = (FXint)((FXList const *)arg1)->getNumVisible();
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXList_setNumVisible(int argc, VALUE *argv, VALUE self) { FXList *arg1 = (FXList *) 0 ; FXint arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXList, 1); arg2 = NUM2INT(argv[0]); (arg1)->setNumVisible(arg2);
    return Qnil; }
static VALUE _wrap_FXList_getItem(int argc, VALUE *argv, VALUE self) { FXList *arg1 = (FXList *) 0 ; FXint arg2 ;
    FXListItem *result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc); SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXList, 1);
    arg2 = NUM2INT(argv[0]); { if (arg2 < 0 || arg2 >= arg1->getNumItems()) {
            rb_raise(rb_eIndexError, "list item index out of bounds"); }  } 
    result = (FXListItem *)((FXList const *)arg1)->getItem(arg2); {
        swig_type_info *ty = SWIG_TypeDynamicCast(SWIGTYPE_p_FXListItem, (void **) &result);
        vresult = FXRbGetRubyObj(result, ty); }  return vresult; }
static VALUE _wrap_FXList_setItem__SWIG_0(int argc, VALUE *argv, VALUE self) { FXList *arg1 = (FXList *) 0 ; FXint arg2 ;
    FXListItem *arg3 = (FXListItem *) 0 ; FXbool arg4 = (FXbool) 0 ; FXint result; VALUE vresult = Qnil;
    if ((argc < 2) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXList, 1); arg2 = NUM2INT(argv[0]);
    SWIG_ConvertPtr(argv[1], (void **) &arg3, SWIGTYPE_p_FXListItem, 1); if (argc > 2) { arg4 = to_FXbool(argv[2]); }  {
        if (arg2 < 0 || arg2 >= arg1->getNumItems()) { rb_raise(rb_eIndexError, "list item index out of bounds"); }  } 
    result = (FXint)FXList_setItem__SWIG_0(arg1,arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXList_setItem__SWIG_1(int argc, VALUE *argv, VALUE self) { FXList *arg1 = (FXList *) 0 ; FXint arg2 ;
    FXString *arg3 = 0 ; FXIcon *arg4 = (FXIcon *) 0 ; void *arg5 = (void *) 0 ; FXbool arg6 = (FXbool) 0 ; FXint result;
    SwigValueWrapper<FXString > p3 ; VALUE vresult = Qnil; if ((argc < 2) || (argc > 5))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc); SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXList, 1);
    arg2 = NUM2INT(argv[0]); p3 = to_FXString(argv[1]); arg3 = &p3; if (argc > 2) {
        SWIG_ConvertPtr(argv[2], (void **) &arg4, SWIGTYPE_p_FXIcon, 1); }  if (argc > 3) {
        arg5 = (argv[3] == Qnil) ? NULL : (void *) argv[3]; }  if (argc > 4) { arg6 = to_FXbool(argv[4]); }  {
        if (arg2 < 0 || arg2 >= arg1->getNumItems()) { rb_raise(rb_eIndexError, "list item index out of bounds"); }  } 
    result = (FXint)FXList_setItem__SWIG_1(arg1,arg2,(FXString const &)*arg3,arg4,arg5,arg6); vresult = INT2NUM(result);
    return vresult; }
static VALUE _wrap_FXList_setItem(int nargs, VALUE *args, VALUE self) { int argc; VALUE argv[7]; int ii; argc = nargs + 1;
    argv[0] = self; for (ii = 1; (ii < argc) && (ii < 6); ii++) { argv[ii] = args[ii-1]; }  if ((argc >= 3) && (argc <= 4)) {
        int _v; { void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXList, 0) != -1)) ? 1 : 0; }
         if (_v) { { _v = ((TYPE(argv[1]) == T_FIXNUM) || (TYPE(argv[1]) == T_BIGNUM)) ? 1 : 0; }  if (_v) { { void *ptr;
                    _v = (NIL_P(argv[2]) || (TYPE(argv[2]) == T_DATA && SWIG_ConvertPtr(argv[2], &ptr, SWIGTYPE_p_FXListItem, 0) != -1)) ? 1 : 0; }
                 if (_v) { if (argc <= 3) { return _wrap_FXList_setItem__SWIG_0(nargs, args, self);}  {
                        _v = (argv[3] == Qtrue || argv[3] == Qfalse) ? 1 : 0; }  if (_v) {
                        return _wrap_FXList_setItem__SWIG_0(nargs, args, self);}  }  }  }  }  if ((argc >= 3) && (argc <= 6)) {
        int _v; { void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXList, 0) != -1)) ? 1 : 0; }
         if (_v) { { _v = ((TYPE(argv[1]) == T_FIXNUM) || (TYPE(argv[1]) == T_BIGNUM)) ? 1 : 0; }  if (_v) { {
                    _v = (NIL_P(argv[2]) || TYPE(argv[2]) == T_STRING) ? 1 : 0; }  if (_v) { if (argc <= 3) {
                        return _wrap_FXList_setItem__SWIG_1(nargs, args, self);}  { void *ptr;
                        _v = (NIL_P(argv[3]) || (TYPE(argv[3]) == T_DATA && SWIG_ConvertPtr(argv[3], &ptr, SWIGTYPE_p_FXIcon, 0) != -1)) ? 1 : 0; }
                     if (_v) { if (argc <= 4) { return _wrap_FXList_setItem__SWIG_1(nargs, args, self);}  { _v = 1; }  if (_v) {
                            if (argc <= 5) { return _wrap_FXList_setItem__SWIG_1(nargs, args, self);}  {
                                _v = (argv[5] == Qtrue || argv[5] == Qfalse) ? 1 : 0; }  if (_v) {
                                return _wrap_FXList_setItem__SWIG_1(nargs, args, self);}  }  }  }  }  }  } 
    rb_raise(rb_eArgError, "No matching function for overloaded 'FXList_setItem'"); return Qnil; }
static VALUE _wrap_FXList_insertItem__SWIG_0(int argc, VALUE *argv, VALUE self) { FXList *arg1 = (FXList *) 0 ; FXint arg2 ;
    FXListItem *arg3 = (FXListItem *) 0 ; FXbool arg4 = (FXbool) 0 ; FXint result; VALUE vresult = Qnil;
    if ((argc < 2) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXList, 1); arg2 = NUM2INT(argv[0]);
    SWIG_ConvertPtr(argv[1], (void **) &arg3, SWIGTYPE_p_FXListItem, 1); if (argc > 2) { arg4 = to_FXbool(argv[2]); }  {
        if (arg2 < 0 || arg2 >= arg1->getNumItems()) { rb_raise(rb_eIndexError, "list item index out of bounds"); }  } 
    result = (FXint)FXList_insertItem__SWIG_0(arg1,arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXList_insertItem__SWIG_1(int argc, VALUE *argv, VALUE self) { FXList *arg1 = (FXList *) 0 ; FXint arg2 ;
    FXString *arg3 = 0 ; FXIcon *arg4 = (FXIcon *) 0 ; void *arg5 = (void *) 0 ; FXbool arg6 = (FXbool) 0 ; FXint result;
    SwigValueWrapper<FXString > p3 ; VALUE vresult = Qnil; if ((argc < 2) || (argc > 5))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc); SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXList, 1);
    arg2 = NUM2INT(argv[0]); p3 = to_FXString(argv[1]); arg3 = &p3; if (argc > 2) {
        SWIG_ConvertPtr(argv[2], (void **) &arg4, SWIGTYPE_p_FXIcon, 1); }  if (argc > 3) {
        arg5 = (argv[3] == Qnil) ? NULL : (void *) argv[3]; }  if (argc > 4) { arg6 = to_FXbool(argv[4]); }  {
        if (arg2 < 0 || arg2 >= arg1->getNumItems()) { rb_raise(rb_eIndexError, "list item index out of bounds"); }  } 
    result = (FXint)(arg1)->insertItem(arg2,(FXString const &)*arg3,arg4,arg5,arg6); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXList_insertItem(int nargs, VALUE *args, VALUE self) { int argc; VALUE argv[7]; int ii; argc = nargs + 1;
    argv[0] = self; for (ii = 1; (ii < argc) && (ii < 6); ii++) { argv[ii] = args[ii-1]; }  if ((argc >= 3) && (argc <= 4)) {
        int _v; { void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXList, 0) != -1)) ? 1 : 0; }
         if (_v) { { _v = ((TYPE(argv[1]) == T_FIXNUM) || (TYPE(argv[1]) == T_BIGNUM)) ? 1 : 0; }  if (_v) { { void *ptr;
                    _v = (NIL_P(argv[2]) || (TYPE(argv[2]) == T_DATA && SWIG_ConvertPtr(argv[2], &ptr, SWIGTYPE_p_FXListItem, 0) != -1)) ? 1 : 0; }
                 if (_v) { if (argc <= 3) { return _wrap_FXList_insertItem__SWIG_0(nargs, args, self);}  {
                        _v = (argv[3] == Qtrue || argv[3] == Qfalse) ? 1 : 0; }  if (_v) {
                        return _wrap_FXList_insertItem__SWIG_0(nargs, args, self);}  }  }  }  } 
    if ((argc >= 3) && (argc <= 6)) { int _v; { void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXList, 0) != -1)) ? 1 : 0; }
         if (_v) { { _v = ((TYPE(argv[1]) == T_FIXNUM) || (TYPE(argv[1]) == T_BIGNUM)) ? 1 : 0; }  if (_v) { {
                    _v = (NIL_P(argv[2]) || TYPE(argv[2]) == T_STRING) ? 1 : 0; }  if (_v) { if (argc <= 3) {
                        return _wrap_FXList_insertItem__SWIG_1(nargs, args, self);}  { void *ptr;
                        _v = (NIL_P(argv[3]) || (TYPE(argv[3]) == T_DATA && SWIG_ConvertPtr(argv[3], &ptr, SWIGTYPE_p_FXIcon, 0) != -1)) ? 1 : 0; }
                     if (_v) { if (argc <= 4) { return _wrap_FXList_insertItem__SWIG_1(nargs, args, self);}  { _v = 1; } 
                        if (_v) { if (argc <= 5) { return _wrap_FXList_insertItem__SWIG_1(nargs, args, self);}  {
                                _v = (argv[5] == Qtrue || argv[5] == Qfalse) ? 1 : 0; }  if (_v) {
                                return _wrap_FXList_insertItem__SWIG_1(nargs, args, self);}  }  }  }  }  }  } 
    rb_raise(rb_eArgError, "No matching function for overloaded 'FXList_insertItem'"); return Qnil; }
static VALUE _wrap_FXList_appendItem__SWIG_0(int argc, VALUE *argv, VALUE self) { FXList *arg1 = (FXList *) 0 ;
    FXListItem *arg2 = (FXListItem *) 0 ; FXbool arg3 = (FXbool) 0 ; FXint result; VALUE vresult = Qnil;
    if ((argc < 1) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXListItem, 1); if (argc > 1) { arg3 = to_FXbool(argv[1]); } 
    result = (FXint)FXList_appendItem__SWIG_0(arg1,arg2,arg3); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXList_appendItem__SWIG_1(int argc, VALUE *argv, VALUE self) { FXList *arg1 = (FXList *) 0 ;
    FXString *arg2 = 0 ; FXIcon *arg3 = (FXIcon *) 0 ; void *arg4 = (void *) 0 ; FXbool arg5 = (FXbool) 0 ; FXint result;
    SwigValueWrapper<FXString > p2 ; VALUE vresult = Qnil; if ((argc < 1) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc); SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXList, 1);
    p2 = to_FXString(argv[0]); arg2 = &p2; if (argc > 1) { SWIG_ConvertPtr(argv[1], (void **) &arg3, SWIGTYPE_p_FXIcon, 1); } 
    if (argc > 2) { arg4 = (argv[2] == Qnil) ? NULL : (void *) argv[2]; }  if (argc > 3) { arg5 = to_FXbool(argv[3]); } 
    result = (FXint)(arg1)->appendItem((FXString const &)*arg2,arg3,arg4,arg5); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXList_appendItem(int nargs, VALUE *args, VALUE self) { int argc; VALUE argv[6]; int ii; argc = nargs + 1;
    argv[0] = self; for (ii = 1; (ii < argc) && (ii < 5); ii++) { argv[ii] = args[ii-1]; }  if ((argc >= 2) && (argc <= 3)) {
        int _v; { void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXList, 0) != -1)) ? 1 : 0; }
         if (_v) { { void *ptr;
                _v = (NIL_P(argv[1]) || (TYPE(argv[1]) == T_DATA && SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_FXListItem, 0) != -1)) ? 1 : 0; }
             if (_v) { if (argc <= 2) { return _wrap_FXList_appendItem__SWIG_0(nargs, args, self);}  {
                    _v = (argv[2] == Qtrue || argv[2] == Qfalse) ? 1 : 0; }  if (_v) {
                    return _wrap_FXList_appendItem__SWIG_0(nargs, args, self);}  }  }  }  if ((argc >= 2) && (argc <= 5)) {
        int _v; { void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXList, 0) != -1)) ? 1 : 0; }
         if (_v) { { _v = (NIL_P(argv[1]) || TYPE(argv[1]) == T_STRING) ? 1 : 0; }  if (_v) { if (argc <= 2) {
                    return _wrap_FXList_appendItem__SWIG_1(nargs, args, self);}  { void *ptr;
                    _v = (NIL_P(argv[2]) || (TYPE(argv[2]) == T_DATA && SWIG_ConvertPtr(argv[2], &ptr, SWIGTYPE_p_FXIcon, 0) != -1)) ? 1 : 0; }
                 if (_v) { if (argc <= 3) { return _wrap_FXList_appendItem__SWIG_1(nargs, args, self);}  { _v = 1; }  if (_v) {
                        if (argc <= 4) { return _wrap_FXList_appendItem__SWIG_1(nargs, args, self);}  {
                            _v = (argv[4] == Qtrue || argv[4] == Qfalse) ? 1 : 0; }  if (_v) {
                            return _wrap_FXList_appendItem__SWIG_1(nargs, args, self);}  }  }  }  }  } 
    rb_raise(rb_eArgError, "No matching function for overloaded 'FXList_appendItem'"); return Qnil; }
static VALUE _wrap_FXList_prependItem__SWIG_0(int argc, VALUE *argv, VALUE self) { FXList *arg1 = (FXList *) 0 ;
    FXListItem *arg2 = (FXListItem *) 0 ; FXbool arg3 = (FXbool) 0 ; FXint result; VALUE vresult = Qnil;
    if ((argc < 1) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXListItem, 1); if (argc > 1) { arg3 = to_FXbool(argv[1]); } 
    result = (FXint)FXList_prependItem__SWIG_0(arg1,arg2,arg3); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXList_prependItem__SWIG_1(int argc, VALUE *argv, VALUE self) { FXList *arg1 = (FXList *) 0 ;
    FXString *arg2 = 0 ; FXIcon *arg3 = (FXIcon *) 0 ; void *arg4 = (void *) 0 ; FXbool arg5 = (FXbool) 0 ; FXint result;
    SwigValueWrapper<FXString > p2 ; VALUE vresult = Qnil; if ((argc < 1) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc); SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXList, 1);
    p2 = to_FXString(argv[0]); arg2 = &p2; if (argc > 1) { SWIG_ConvertPtr(argv[1], (void **) &arg3, SWIGTYPE_p_FXIcon, 1); } 
    if (argc > 2) { arg4 = (argv[2] == Qnil) ? NULL : (void *) argv[2]; }  if (argc > 3) { arg5 = to_FXbool(argv[3]); } 
    result = (FXint)(arg1)->prependItem((FXString const &)*arg2,arg3,arg4,arg5); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXList_prependItem(int nargs, VALUE *args, VALUE self) { int argc; VALUE argv[6]; int ii; argc = nargs + 1;
    argv[0] = self; for (ii = 1; (ii < argc) && (ii < 5); ii++) { argv[ii] = args[ii-1]; }  if ((argc >= 2) && (argc <= 3)) {
        int _v; { void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXList, 0) != -1)) ? 1 : 0; }
         if (_v) { { void *ptr;
                _v = (NIL_P(argv[1]) || (TYPE(argv[1]) == T_DATA && SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_FXListItem, 0) != -1)) ? 1 : 0; }
             if (_v) { if (argc <= 2) { return _wrap_FXList_prependItem__SWIG_0(nargs, args, self);}  {
                    _v = (argv[2] == Qtrue || argv[2] == Qfalse) ? 1 : 0; }  if (_v) {
                    return _wrap_FXList_prependItem__SWIG_0(nargs, args, self);}  }  }  }  if ((argc >= 2) && (argc <= 5)) {
        int _v; { void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXList, 0) != -1)) ? 1 : 0; }
         if (_v) { { _v = (NIL_P(argv[1]) || TYPE(argv[1]) == T_STRING) ? 1 : 0; }  if (_v) { if (argc <= 2) {
                    return _wrap_FXList_prependItem__SWIG_1(nargs, args, self);}  { void *ptr;
                    _v = (NIL_P(argv[2]) || (TYPE(argv[2]) == T_DATA && SWIG_ConvertPtr(argv[2], &ptr, SWIGTYPE_p_FXIcon, 0) != -1)) ? 1 : 0; }
                 if (_v) { if (argc <= 3) { return _wrap_FXList_prependItem__SWIG_1(nargs, args, self);}  { _v = 1; }  if (_v) {
                        if (argc <= 4) { return _wrap_FXList_prependItem__SWIG_1(nargs, args, self);}  {
                            _v = (argv[4] == Qtrue || argv[4] == Qfalse) ? 1 : 0; }  if (_v) {
                            return _wrap_FXList_prependItem__SWIG_1(nargs, args, self);}  }  }  }  }  } 
    rb_raise(rb_eArgError, "No matching function for overloaded 'FXList_prependItem'"); return Qnil; }
static VALUE _wrap_FXList_moveItem(int argc, VALUE *argv, VALUE self) { FXList *arg1 = (FXList *) 0 ; FXint arg2 ; FXint arg3 ;
    FXbool arg4 = (FXbool) 0 ; FXint result; VALUE vresult = Qnil; if ((argc < 2) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc); SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXList, 1);
    arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]); if (argc > 2) { arg4 = to_FXbool(argv[2]); }  {
        if (arg2 < 0 || arg2 >= arg1->getNumItems()) { rb_raise(rb_eIndexError, "list item index out of bounds"); }  }  {
        if (arg3 < 0 || arg3 >= arg1->getNumItems()) { rb_raise(rb_eIndexError, "list item index out of bounds"); }  } 
    result = (FXint)(arg1)->moveItem(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXList_removeItem(int argc, VALUE *argv, VALUE self) { FXList *arg1 = (FXList *) 0 ; FXint arg2 ;
    FXbool arg3 = (FXbool) 0 ; if ((argc < 1) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXList, 1); arg2 = NUM2INT(argv[0]); if (argc > 1) {
        arg3 = to_FXbool(argv[1]); }  { if (arg2 < 0 || arg2 >= arg1->getNumItems()) {
            rb_raise(rb_eIndexError, "list item index out of bounds"); }  }  FXList_removeItem(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXList_clearItems(int argc, VALUE *argv, VALUE self) { FXList *arg1 = (FXList *) 0 ;
    FXbool arg2 = (FXbool) 0 ; if ((argc < 0) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXList, 1); if (argc > 0) { arg2 = to_FXbool(argv[0]); } 
    FXList_clearItems(arg1,arg2); return Qnil; }
static VALUE _wrap_FXList_getItemWidth(int argc, VALUE *argv, VALUE self) { FXList *arg1 = (FXList *) 0 ; FXint arg2 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc); SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXList, 1);
    arg2 = NUM2INT(argv[0]); { if (arg2 < 0 || arg2 >= arg1->getNumItems()) {
            rb_raise(rb_eIndexError, "list item index out of bounds"); }  } 
    result = (FXint)((FXList const *)arg1)->getItemWidth(arg2); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXList_getItemHeight(int argc, VALUE *argv, VALUE self) { FXList *arg1 = (FXList *) 0 ; FXint arg2 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc); SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXList, 1);
    arg2 = NUM2INT(argv[0]); { if (arg2 < 0 || arg2 >= arg1->getNumItems()) {
            rb_raise(rb_eIndexError, "list item index out of bounds"); }  } 
    result = (FXint)((FXList const *)arg1)->getItemHeight(arg2); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXList_getItemAt(int argc, VALUE *argv, VALUE self) { FXList *arg1 = (FXList *) 0 ; FXint arg2 ; FXint arg3 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc); SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXList, 1);
    arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]); result = (FXint)((FXList const *)arg1)->getItemAt(arg2,arg3);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXList_hitItem(int argc, VALUE *argv, VALUE self) { FXList *arg1 = (FXList *) 0 ; FXint arg2 ; FXint arg3 ;
    FXint arg4 ; FXint result; VALUE vresult = Qnil; if ((argc < 3) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc); SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXList, 1);
    arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]); arg4 = NUM2INT(argv[2]); { if (arg2 < 0 || arg2 >= arg1->getNumItems()) {
            rb_raise(rb_eIndexError, "list item index out of bounds"); }  } 
    result = (FXint)((FXList const *)arg1)->hitItem(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXList_findItem(int argc, VALUE *argv, VALUE self) { FXList *arg1 = (FXList *) 0 ; FXString *arg2 = 0 ;
    FXint arg3 = (FXint) -1 ; FXuint arg4 = (FXuint) SEARCH_FORWARD|SEARCH_WRAP ; FXint result; SwigValueWrapper<FXString > p2 ;
    VALUE vresult = Qnil; if ((argc < 1) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXList, 1); p2 = to_FXString(argv[0]); arg2 = &p2; if (argc > 1) {
        arg3 = NUM2INT(argv[1]); }  if (argc > 2) { arg4 = NUM2UINT(argv[2]); } 
    result = (FXint)((FXList const *)arg1)->findItem((FXString const &)*arg2,arg3,arg4); vresult = INT2NUM(result);
    return vresult; }
static VALUE _wrap_FXList_makeItemVisible__SWIG_0(int argc, VALUE *argv, VALUE self) { FXList *arg1 = (FXList *) 0 ;
    FXint arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXList, 1); arg2 = NUM2INT(argv[0]); {
        if (arg2 < 0 || arg2 >= arg1->getNumItems()) { rb_raise(rb_eIndexError, "list item index out of bounds"); }  } 
    (arg1)->makeItemVisible(arg2); return Qnil; }
static VALUE _wrap_FXList_makeItemVisible__SWIG_1(int argc, VALUE *argv, VALUE self) { FXList *arg1 = (FXList *) 0 ;
    FXListItem *arg2 = (FXListItem *) 0 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc); SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXListItem, 1); FXList_makeItemVisible__SWIG_1(arg1,arg2);
    return Qnil; }
static VALUE _wrap_FXList_makeItemVisible(int nargs, VALUE *args, VALUE self) { int argc; VALUE argv[3]; int ii;
    argc = nargs + 1; argv[0] = self; for (ii = 1; (ii < argc) && (ii < 2); ii++) { argv[ii] = args[ii-1]; }  if (argc == 2) {
        int _v; { void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXList, 0) != -1)) ? 1 : 0; }
         if (_v) { { void *ptr;
                _v = (NIL_P(argv[1]) || (TYPE(argv[1]) == T_DATA && SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_FXListItem, 0) != -1)) ? 1 : 0; }
             if (_v) { return _wrap_FXList_makeItemVisible__SWIG_1(nargs, args, self);}  }  }  if (argc == 2) { int _v; {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXList, 0) != -1)) ? 1 : 0; }
         if (_v) { { _v = ((TYPE(argv[1]) == T_FIXNUM) || (TYPE(argv[1]) == T_BIGNUM)) ? 1 : 0; }  if (_v) {
                return _wrap_FXList_makeItemVisible__SWIG_0(nargs, args, self);}  }  } 
    rb_raise(rb_eArgError, "No matching function for overloaded 'FXList_makeItemVisible'"); return Qnil; }
static VALUE _wrap_FXList_setItemText(int argc, VALUE *argv, VALUE self) { FXList *arg1 = (FXList *) 0 ; FXint arg2 ;
    FXString *arg3 = 0 ; SwigValueWrapper<FXString > p3 ; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc); SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXList, 1);
    arg2 = NUM2INT(argv[0]); p3 = to_FXString(argv[1]); arg3 = &p3; { if (arg2 < 0 || arg2 >= arg1->getNumItems()) {
            rb_raise(rb_eIndexError, "list item index out of bounds"); }  }  (arg1)->setItemText(arg2,(FXString const &)*arg3);
    return Qnil; }
static VALUE _wrap_FXList_getItemText(int argc, VALUE *argv, VALUE self) { FXList *arg1 = (FXList *) 0 ; FXint arg2 ;
    FXString result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc); SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXList, 1);
    arg2 = NUM2INT(argv[0]); { if (arg2 < 0 || arg2 >= arg1->getNumItems()) {
            rb_raise(rb_eIndexError, "list item index out of bounds"); }  }  result = ((FXList const *)arg1)->getItemText(arg2);
    vresult = rb_str_new2((&result)->text()); return vresult; }
static VALUE _wrap_FXList_setItemIcon(int argc, VALUE *argv, VALUE self) { FXList *arg1 = (FXList *) 0 ; FXint arg2 ;
    FXIcon *arg3 = (FXIcon *) 0 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXList, 1); arg2 = NUM2INT(argv[0]);
    SWIG_ConvertPtr(argv[1], (void **) &arg3, SWIGTYPE_p_FXIcon, 1); { if (arg2 < 0 || arg2 >= arg1->getNumItems()) {
            rb_raise(rb_eIndexError, "list item index out of bounds"); }  }  (arg1)->setItemIcon(arg2,arg3); return Qnil; }
static VALUE _wrap_FXList_getItemIcon(int argc, VALUE *argv, VALUE self) { FXList *arg1 = (FXList *) 0 ; FXint arg2 ;
    FXIcon *result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc); SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXList, 1);
    arg2 = NUM2INT(argv[0]); { if (arg2 < 0 || arg2 >= arg1->getNumItems()) {
            rb_raise(rb_eIndexError, "list item index out of bounds"); }  } 
    result = (FXIcon *)((FXList const *)arg1)->getItemIcon(arg2); {
        swig_type_info *ty = SWIG_TypeDynamicCast(SWIGTYPE_p_FXIcon, (void **) &result); vresult = FXRbGetRubyObj(result, ty); }
     return vresult; }
static VALUE _wrap_FXList_setItemData(int argc, VALUE *argv, VALUE self) { FXList *arg1 = (FXList *) 0 ; FXint arg2 ;
    VALUE arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXList, 1); arg2 = NUM2INT(argv[0]); arg3 = argv[1]; {
        if (arg2 < 0 || arg2 >= arg1->getNumItems()) { rb_raise(rb_eIndexError, "list item index out of bounds"); }  } 
    FXList_setItemData(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXList_getItemData(int argc, VALUE *argv, VALUE self) { FXList *arg1 = (FXList *) 0 ; FXint arg2 ;
    VALUE result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc); SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXList, 1);
    arg2 = NUM2INT(argv[0]); { if (arg2 < 0 || arg2 >= arg1->getNumItems()) {
            rb_raise(rb_eIndexError, "list item index out of bounds"); }  } 
    result = (VALUE)FXList_getItemData((FXList const *)arg1,arg2); vresult = result; return vresult; }
static VALUE _wrap_FXList_isItemSelected(int argc, VALUE *argv, VALUE self) { FXList *arg1 = (FXList *) 0 ; FXint arg2 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc); SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXList, 1);
    arg2 = NUM2INT(argv[0]); { if (arg2 < 0 || arg2 >= arg1->getNumItems()) {
            rb_raise(rb_eIndexError, "list item index out of bounds"); }  } 
    result = (FXbool)((FXList const *)arg1)->isItemSelected(arg2); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXList_isItemCurrent(int argc, VALUE *argv, VALUE self) { FXList *arg1 = (FXList *) 0 ; FXint arg2 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc); SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXList, 1);
    arg2 = NUM2INT(argv[0]); { if (arg2 < 0 || arg2 >= arg1->getNumItems()) {
            rb_raise(rb_eIndexError, "list item index out of bounds"); }  } 
    result = (FXbool)((FXList const *)arg1)->isItemCurrent(arg2); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXList_isItemVisible(int argc, VALUE *argv, VALUE self) { FXList *arg1 = (FXList *) 0 ; FXint arg2 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc); SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXList, 1);
    arg2 = NUM2INT(argv[0]); { if (arg2 < 0 || arg2 >= arg1->getNumItems()) {
            rb_raise(rb_eIndexError, "list item index out of bounds"); }  } 
    result = (FXbool)((FXList const *)arg1)->isItemVisible(arg2); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXList_isItemEnabled(int argc, VALUE *argv, VALUE self) { FXList *arg1 = (FXList *) 0 ; FXint arg2 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc); SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXList, 1);
    arg2 = NUM2INT(argv[0]); { if (arg2 < 0 || arg2 >= arg1->getNumItems()) {
            rb_raise(rb_eIndexError, "list item index out of bounds"); }  } 
    result = (FXbool)((FXList const *)arg1)->isItemEnabled(arg2); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXList_updateItem(int argc, VALUE *argv, VALUE self) { FXList *arg1 = (FXList *) 0 ; FXint arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXList, 1); arg2 = NUM2INT(argv[0]); {
        if (arg2 < 0 || arg2 >= arg1->getNumItems()) { rb_raise(rb_eIndexError, "list item index out of bounds"); }  } 
    ((FXList const *)arg1)->updateItem(arg2); return Qnil; }
static VALUE _wrap_FXList_enableItem(int argc, VALUE *argv, VALUE self) { FXList *arg1 = (FXList *) 0 ; FXint arg2 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc); SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXList, 1);
    arg2 = NUM2INT(argv[0]); { if (arg2 < 0 || arg2 >= arg1->getNumItems()) {
            rb_raise(rb_eIndexError, "list item index out of bounds"); }  }  result = (FXbool)(arg1)->enableItem(arg2);
    vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXList_disableItem(int argc, VALUE *argv, VALUE self) { FXList *arg1 = (FXList *) 0 ; FXint arg2 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc); SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXList, 1);
    arg2 = NUM2INT(argv[0]); { if (arg2 < 0 || arg2 >= arg1->getNumItems()) {
            rb_raise(rb_eIndexError, "list item index out of bounds"); }  }  result = (FXbool)(arg1)->disableItem(arg2);
    vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXList_getCurrentItem(int argc, VALUE *argv, VALUE self) { FXList *arg1 = (FXList *) 0 ; FXint result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXList, 1); result = (FXint)((FXList const *)arg1)->getCurrentItem();
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXList_setAnchorItem(int argc, VALUE *argv, VALUE self) { FXList *arg1 = (FXList *) 0 ; FXint arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXList, 1); arg2 = NUM2INT(argv[0]); {
        if (arg2 < 0 || arg2 >= arg1->getNumItems()) { rb_raise(rb_eIndexError, "list item index out of bounds"); }  } 
    (arg1)->setAnchorItem(arg2); return Qnil; }
static VALUE _wrap_FXList_getAnchorItem(int argc, VALUE *argv, VALUE self) { FXList *arg1 = (FXList *) 0 ; FXint result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXList, 1); result = (FXint)((FXList const *)arg1)->getAnchorItem();
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXList_getCursorItem(int argc, VALUE *argv, VALUE self) { FXList *arg1 = (FXList *) 0 ; FXint result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXList, 1); result = (FXint)((FXList const *)arg1)->getCursorItem();
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXList_sortItems(int argc, VALUE *argv, VALUE self) { FXList *arg1 = (FXList *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXList, 1); (arg1)->sortItems(); return Qnil; }
static VALUE _wrap_FXList_setFont(int argc, VALUE *argv, VALUE self) { FXList *arg1 = (FXList *) 0 ;
    FXFont *arg2 = (FXFont *) 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXFont, 1); (arg1)->setFont(arg2); return Qnil; }
static VALUE _wrap_FXList_getFont(int argc, VALUE *argv, VALUE self) { FXList *arg1 = (FXList *) 0 ; FXFont *result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXList, 1); result = (FXFont *)((FXList const *)arg1)->getFont(); {
        swig_type_info *ty = SWIG_TypeDynamicCast(SWIGTYPE_p_FXFont, (void **) &result); vresult = FXRbGetRubyObj(result, ty); }
     return vresult; }
static VALUE _wrap_FXList_getTextColor(int argc, VALUE *argv, VALUE self) { FXList *arg1 = (FXList *) 0 ; FXColor result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXList, 1); result = (FXColor)((FXList const *)arg1)->getTextColor();
    vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXList_setTextColor(int argc, VALUE *argv, VALUE self) { FXList *arg1 = (FXList *) 0 ; FXColor arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXList, 1); arg2 = to_FXColor(argv[0]); (arg1)->setTextColor(arg2);
    return Qnil; }
static VALUE _wrap_FXList_getSelBackColor(int argc, VALUE *argv, VALUE self) { FXList *arg1 = (FXList *) 0 ; FXColor result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXList, 1); result = (FXColor)((FXList const *)arg1)->getSelBackColor();
    vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXList_setSelBackColor(int argc, VALUE *argv, VALUE self) { FXList *arg1 = (FXList *) 0 ; FXColor arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXList, 1); arg2 = to_FXColor(argv[0]); (arg1)->setSelBackColor(arg2);
    return Qnil; }
static VALUE _wrap_FXList_getSelTextColor(int argc, VALUE *argv, VALUE self) { FXList *arg1 = (FXList *) 0 ; FXColor result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXList, 1); result = (FXColor)((FXList const *)arg1)->getSelTextColor();
    vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXList_setSelTextColor(int argc, VALUE *argv, VALUE self) { FXList *arg1 = (FXList *) 0 ; FXColor arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXList, 1); arg2 = to_FXColor(argv[0]); (arg1)->setSelTextColor(arg2);
    return Qnil; }
static VALUE _wrap_FXList_getListStyle(int argc, VALUE *argv, VALUE self) { FXList *arg1 = (FXList *) 0 ; FXuint result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXList, 1); result = (FXuint)((FXList const *)arg1)->getListStyle();
    vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXList_setListStyle(int argc, VALUE *argv, VALUE self) { FXList *arg1 = (FXList *) 0 ; FXuint arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXList, 1); arg2 = NUM2UINT(argv[0]); (arg1)->setListStyle(arg2);
    return Qnil; }
static VALUE _wrap_FXList_setHelpText(int argc, VALUE *argv, VALUE self) { FXList *arg1 = (FXList *) 0 ; FXString *arg2 = 0 ;
    SwigValueWrapper<FXString > p2 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc); SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXList, 1);
    p2 = to_FXString(argv[0]); arg2 = &p2; (arg1)->setHelpText((FXString const &)*arg2); return Qnil; }
static VALUE _wrap_FXList_getHelpText(int argc, VALUE *argv, VALUE self) { FXList *arg1 = (FXList *) 0 ; FXString result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXList, 1); result = ((FXList const *)arg1)->getHelpText();
    vresult = rb_str_new2((&result)->text()); return vresult; }
static void
free_FXList(FXList *arg1) {
    delete arg1;
}
static VALUE _wrap_FXList_save(int argc, VALUE *argv, VALUE self) { FXList *arg1 = (FXList *) 0 ; FXStream *arg2 = 0 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXList_save((FXList const *)arg1,*arg2); return Qnil; }
static VALUE _wrap_FXList_load(int argc, VALUE *argv, VALUE self) { FXList *arg1 = (FXList *) 0 ; FXStream *arg2 = 0 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXList_load(arg1,*arg2); return Qnil; }
static VALUE _wrap_FXList_create(int argc, VALUE *argv, VALUE self) { FXList *arg1 = (FXList *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXList, 1); FXList_create(arg1); return Qnil; }
static VALUE _wrap_FXList_detach(int argc, VALUE *argv, VALUE self) { FXList *arg1 = (FXList *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXList, 1); FXList_detach(arg1); return Qnil; }
static VALUE _wrap_FXList_destroy(int argc, VALUE *argv, VALUE self) { FXList *arg1 = (FXList *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXList, 1); FXList_destroy(arg1); return Qnil; }
static VALUE _wrap_FXList_resize(int argc, VALUE *argv, VALUE self) { FXList *arg1 = (FXList *) 0 ; FXint arg2 ; FXint arg3 ;
    if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXList, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    FXList_resize(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXList_getDefaultWidth(int argc, VALUE *argv, VALUE self) { FXList *arg1 = (FXList *) 0 ; FXint result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXList, 1); result = (FXint)FXList_getDefaultWidth(arg1);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXList_getDefaultHeight(int argc, VALUE *argv, VALUE self) { FXList *arg1 = (FXList *) 0 ; FXint result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXList, 1); result = (FXint)FXList_getDefaultHeight(arg1);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXList_getWidthForHeight(int argc, VALUE *argv, VALUE self) { FXList *arg1 = (FXList *) 0 ; FXint arg2 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc); SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXList, 1);
    arg2 = NUM2INT(argv[0]); result = (FXint)FXList_getWidthForHeight(arg1,arg2); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXList_getHeightForWidth(int argc, VALUE *argv, VALUE self) { FXList *arg1 = (FXList *) 0 ; FXint arg2 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc); SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXList, 1);
    arg2 = NUM2INT(argv[0]); result = (FXint)FXList_getHeightForWidth(arg1,arg2); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXList_canFocus(int argc, VALUE *argv, VALUE self) { FXList *arg1 = (FXList *) 0 ; FXbool result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXList, 1); result = (FXbool)FXList_canFocus((FXList const *)arg1);
    vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXList_setFocus(int argc, VALUE *argv, VALUE self) { FXList *arg1 = (FXList *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXList, 1); FXList_setFocus(arg1); return Qnil; }
static VALUE _wrap_FXList_killFocus(int argc, VALUE *argv, VALUE self) { FXList *arg1 = (FXList *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXList, 1); FXList_killFocus(arg1); return Qnil; }
static VALUE _wrap_FXList_setDefault(int argc, VALUE *argv, VALUE self) { FXList *arg1 = (FXList *) 0 ;
    FXbool arg2 = (FXbool) 1 ; if ((argc < 0) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXList, 1); if (argc > 0) { arg2 = to_FXbool(argv[0]); } 
    FXList_setDefault(arg1,arg2); return Qnil; }
static VALUE _wrap_FXList_enable(int argc, VALUE *argv, VALUE self) { FXList *arg1 = (FXList *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXList, 1); FXList_enable(arg1); return Qnil; }
static VALUE _wrap_FXList_disable(int argc, VALUE *argv, VALUE self) { FXList *arg1 = (FXList *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXList, 1); FXList_disable(arg1); return Qnil; }
static VALUE _wrap_FXList_raiseWindow(int argc, VALUE *argv, VALUE self) { FXList *arg1 = (FXList *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXList, 1); FXList_raise(arg1); return Qnil; }
static VALUE _wrap_FXList_lower(int argc, VALUE *argv, VALUE self) { FXList *arg1 = (FXList *) 0 ; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc); SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXList, 1);
    FXList_lower(arg1); return Qnil; }
static VALUE _wrap_FXList_move(int argc, VALUE *argv, VALUE self) { FXList *arg1 = (FXList *) 0 ; FXint arg2 ; FXint arg3 ;
    if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXList, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    FXList_move(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXList_position__SWIG_0(int argc, VALUE *argv, VALUE self) { FXList *arg1 = (FXList *) 0 ; FXint arg2 ;
    FXint arg3 ; FXint arg4 ; FXint arg5 ; if ((argc < 4) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc); SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXList, 1);
    arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]); arg4 = NUM2INT(argv[2]); arg5 = NUM2INT(argv[3]);
    FXList_position(arg1,arg2,arg3,arg4,arg5); return Qnil; }
static VALUE _wrap_FXList_layout(int argc, VALUE *argv, VALUE self) { FXList *arg1 = (FXList *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXList, 1); FXList_layout(arg1); return Qnil; }
static VALUE _wrap_FXList_recalc(int argc, VALUE *argv, VALUE self) { FXList *arg1 = (FXList *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXList, 1); FXList_recalc(arg1); return Qnil; }
static VALUE _wrap_FXList_reparent(int argc, VALUE *argv, VALUE self) { FXList *arg1 = (FXList *) 0 ;
    FXComposite *arg2 = (FXComposite *) 0 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc); SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXList, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXComposite, 1); FXList_reparent(arg1,arg2); return Qnil; }
static VALUE _wrap_FXList_show(int argc, VALUE *argv, VALUE self) { FXList *arg1 = (FXList *) 0 ; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc); SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXList, 1);
    FXList_show(arg1); return Qnil; }
static VALUE _wrap_FXList_hide(int argc, VALUE *argv, VALUE self) { FXList *arg1 = (FXList *) 0 ; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc); SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXList, 1);
    FXList_hide(arg1); return Qnil; }
static VALUE _wrap_FXList_isComposite(int argc, VALUE *argv, VALUE self) { FXList *arg1 = (FXList *) 0 ; FXbool result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXList, 1); result = (FXbool)FXList_isComposite((FXList const *)arg1);
    vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXList_contains(int argc, VALUE *argv, VALUE self) { FXList *arg1 = (FXList *) 0 ; FXint arg2 ; FXint arg3 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc); SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXList, 1);
    arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]); result = (FXbool)FXList_contains((FXList const *)arg1,arg2,arg3);
    vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXList_doesSaveUnder(int argc, VALUE *argv, VALUE self) { FXList *arg1 = (FXList *) 0 ; FXbool result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXList, 1); result = (FXbool)FXList_doesSaveUnder((FXList const *)arg1);
    vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXList_setBackColor(int argc, VALUE *argv, VALUE self) { FXList *arg1 = (FXList *) 0 ; FXColor arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXList, 1); arg2 = to_FXColor(argv[0]); FXList_setBackColor(arg1,arg2);
    return Qnil; }
static VALUE _wrap_FXList_getViewportHeight(int argc, VALUE *argv, VALUE self) { FXList *arg1 = (FXList *) 0 ; FXint result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXList, 1); result = (FXint)FXList_getViewportHeight(arg1);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXList_getViewportWidth(int argc, VALUE *argv, VALUE self) { FXList *arg1 = (FXList *) 0 ; FXint result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXList, 1); result = (FXint)FXList_getViewportWidth(arg1);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXList_getContentHeight(int argc, VALUE *argv, VALUE self) { FXList *arg1 = (FXList *) 0 ; FXint result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXList, 1); result = (FXint)FXList_getContentHeight(arg1);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXList_getContentWidth(int argc, VALUE *argv, VALUE self) { FXList *arg1 = (FXList *) 0 ; FXint result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXList, 1); result = (FXint)FXList_getContentWidth(arg1);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXList_position__SWIG_1(int argc, VALUE *argv, VALUE self) { FXList *arg1 = (FXList *) 0 ; VALUE result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXList, 1); result = (VALUE)FXList_position__SWIG_1((FXList const *)arg1);
    vresult = result; return vresult; }
static VALUE _wrap_FXList_position(int nargs, VALUE *args, VALUE self) { int argc; VALUE argv[6]; int ii; argc = nargs + 1;
    argv[0] = self; for (ii = 1; (ii < argc) && (ii < 5); ii++) { argv[ii] = args[ii-1]; }  if (argc == 1) { int _v; {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXList, 0) != -1)) ? 1 : 0; }
         if (_v) { return _wrap_FXList_position__SWIG_1(nargs, args, self);}  }  if (argc == 5) { int _v; { void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXList, 0) != -1)) ? 1 : 0; }
         if (_v) { { _v = ((TYPE(argv[1]) == T_FIXNUM) || (TYPE(argv[1]) == T_BIGNUM)) ? 1 : 0; }  if (_v) { {
                    _v = ((TYPE(argv[2]) == T_FIXNUM) || (TYPE(argv[2]) == T_BIGNUM)) ? 1 : 0; }  if (_v) { {
                        _v = ((TYPE(argv[3]) == T_FIXNUM) || (TYPE(argv[3]) == T_BIGNUM)) ? 1 : 0; }  if (_v) { {
                            _v = ((TYPE(argv[4]) == T_FIXNUM) || (TYPE(argv[4]) == T_BIGNUM)) ? 1 : 0; }  if (_v) {
                            return _wrap_FXList_position__SWIG_0(nargs, args, self);}  }  }  }  }  } 
    rb_raise(rb_eArgError, "No matching function for overloaded 'FXList_position'"); return Qnil; }
static VALUE _wrap_FXList_selectItem(int argc, VALUE *argv, VALUE self) { FXList *arg1 = (FXList *) 0 ; FXint arg2 ;
    FXbool arg3 = (FXbool) 0 ; FXbool result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc); SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXList, 1);
    arg2 = NUM2INT(argv[0]); if (argc > 1) { arg3 = to_FXbool(argv[1]); }  { if (arg2 < 0 || arg2 >= arg1->getNumItems()) {
            rb_raise(rb_eIndexError, "list item index out of bounds"); }  }  result = (FXbool)FXList_selectItem(arg1,arg2,arg3);
    vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXList_deselectItem(int argc, VALUE *argv, VALUE self) { FXList *arg1 = (FXList *) 0 ; FXint arg2 ;
    FXbool arg3 = (FXbool) 0 ; FXbool result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc); SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXList, 1);
    arg2 = NUM2INT(argv[0]); if (argc > 1) { arg3 = to_FXbool(argv[1]); }  { if (arg2 < 0 || arg2 >= arg1->getNumItems()) {
            rb_raise(rb_eIndexError, "list item index out of bounds"); }  } 
    result = (FXbool)FXList_deselectItem(arg1,arg2,arg3); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXList_toggleItem(int argc, VALUE *argv, VALUE self) { FXList *arg1 = (FXList *) 0 ; FXint arg2 ;
    FXbool arg3 = (FXbool) 0 ; FXbool result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc); SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXList, 1);
    arg2 = NUM2INT(argv[0]); if (argc > 1) { arg3 = to_FXbool(argv[1]); }  { if (arg2 < 0 || arg2 >= arg1->getNumItems()) {
            rb_raise(rb_eIndexError, "list item index out of bounds"); }  }  result = (FXbool)FXList_toggleItem(arg1,arg2,arg3);
    vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXList_extendSelection(int argc, VALUE *argv, VALUE self) { FXList *arg1 = (FXList *) 0 ; FXint arg2 ;
    FXbool arg3 = (FXbool) 0 ; FXbool result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc); SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXList, 1);
    arg2 = NUM2INT(argv[0]); if (argc > 1) { arg3 = to_FXbool(argv[1]); }  { if (arg2 < 0 || arg2 >= arg1->getNumItems()) {
            rb_raise(rb_eIndexError, "list item index out of bounds"); }  } 
    result = (FXbool)FXList_extendSelection(arg1,arg2,arg3); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXList_killSelection(int argc, VALUE *argv, VALUE self) { FXList *arg1 = (FXList *) 0 ;
    FXbool arg2 = (FXbool) 0 ; FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc); SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXList, 1);
    if (argc > 0) { arg2 = to_FXbool(argv[0]); }  result = (FXbool)FXList_killSelection(arg1,arg2);
    vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXList_setCurrentItem(int argc, VALUE *argv, VALUE self) { FXList *arg1 = (FXList *) 0 ; FXint arg2 ;
    FXbool arg3 = (FXbool) 0 ; if ((argc < 1) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXList, 1); arg2 = NUM2INT(argv[0]); if (argc > 1) {
        arg3 = to_FXbool(argv[1]); }  { if (arg2 < 0 || arg2 >= arg1->getNumItems()) {
            rb_raise(rb_eIndexError, "list item index out of bounds"); }  }  FXList_setCurrentItem(arg1,arg2,arg3);
    return Qnil; }

/* -------- TYPE CONVERSION AND EQUIVALENCE RULES (BEGIN) -------- */

static void *_p_FXPopupTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXShell *) ((FXPopup *) x));
}
static void *_p_FXShutterItemTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXPacker *)(FXVerticalFrame *) ((FXShutterItem *) x));
}
static void *_p_FXScrollAreaTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *)  ((FXScrollArea *) x));
}
static void *_p_FXStatusBarTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXPacker *)(FXHorizontalFrame *) ((FXStatusBar *) x));
}
static void *_p_FXMainWindowTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXShell *)(FXTopWindow *) ((FXMainWindow *) x));
}
static void *_p_FXTopWindowTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXShell *) ((FXTopWindow *) x));
}
static void *_p_FXRootWindowTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *)  ((FXRootWindow *) x));
}
static void *_p_FXScrollWindowTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXScrollArea *) ((FXScrollWindow *) x));
}
static void *_p_FXShellTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *)  ((FXShell *) x));
}
static void *_p_FXGroupBoxTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXPacker *) ((FXGroupBox *) x));
}
static void *_p_FXSplitterTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *)  ((FXSplitter *) x));
}
static void *_p_FX4SplitterTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *)  ((FX4Splitter *) x));
}
static void *_p_FXShutterTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXPacker *)(FXVerticalFrame *) ((FXShutter *) x));
}
static void *_p_FXPackerTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *)  ((FXPacker *) x));
}
static void *_p_FXVerticalFrameTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXPacker *) ((FXVerticalFrame *) x));
}
static void *_p_FXHorizontalFrameTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXPacker *) ((FXHorizontalFrame *) x));
}
static void *_p_FXMatrixTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXPacker *) ((FXMatrix *) x));
}
static void *_p_FXListTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXScrollArea *) ((FXList *) x));
}
static void *_p_FXSpringTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXPacker *) ((FXSpring *) x));
}
static void *_p_FXSwitcherTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXPacker *) ((FXSwitcher *) x));
}
static void *_p_FXFrameTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *) ((FXFrame *) x));
}
static void *_p_FXPopupTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXShell *) ((FXPopup *) x));
}
static void *_p_FXShutterItemTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *)(FXVerticalFrame *) ((FXShutterItem *) x));
}
static void *_p_FXScrollAreaTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *) ((FXScrollArea *) x));
}
static void *_p_FXStatusBarTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *)(FXHorizontalFrame *) ((FXStatusBar *) x));
}
static void *_p_FXMainWindowTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXShell *)(FXTopWindow *) ((FXMainWindow *) x));
}
static void *_p_FXTopWindowTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXShell *) ((FXTopWindow *) x));
}
static void *_p_FXRootWindowTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *) ((FXRootWindow *) x));
}
static void *_p_FXWindowTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *) ((FXWindow *) x));
}
static void *_p_FXCompositeTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *) ((FXComposite *) x));
}
static void *_p_FXScrollWindowTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXScrollArea *) ((FXScrollWindow *) x));
}
static void *_p_FXShellTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *) ((FXShell *) x));
}
static void *_p_FXGroupBoxTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXGroupBox *) x));
}
static void *_p_FXGIFCursorTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXCursor *) ((FXGIFCursor *) x));
}
static void *_p_FXCURCursorTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXCursor *) ((FXCURCursor *) x));
}
static void *_p_FXCursorTo_p_FXId(void *x) {
    return (void *)((FXId *)  ((FXCursor *) x));
}
static void *_p_FXDrawableTo_p_FXId(void *x) {
    return (void *)((FXId *)  ((FXDrawable *) x));
}
static void *_p_FXSplitterTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *) ((FXSplitter *) x));
}
static void *_p_FX4SplitterTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *) ((FX4Splitter *) x));
}
static void *_p_FXFontTo_p_FXId(void *x) {
    return (void *)((FXId *)  ((FXFont *) x));
}
static void *_p_FXPackerTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *) ((FXPacker *) x));
}
static void *_p_FXHorizontalFrameTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXHorizontalFrame *) x));
}
static void *_p_FXVerticalFrameTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXVerticalFrame *) x));
}
static void *_p_FXShutterTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *)(FXVerticalFrame *) ((FXShutter *) x));
}
static void *_p_FXVisualTo_p_FXId(void *x) {
    return (void *)((FXId *)  ((FXVisual *) x));
}
static void *_p_FXMatrixTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXMatrix *) x));
}
static void *_p_FXListTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXScrollArea *) ((FXList *) x));
}
static void *_p_FXSpringTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXSpring *) x));
}
static void *_p_FXSwitcherTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXSwitcher *) x));
}
static void *_p_FXFrameTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *)  ((FXFrame *) x));
}
static void *_p_FXPopupTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXShell *) ((FXPopup *) x));
}
static void *_p_FXShutterItemTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXPacker *)(FXVerticalFrame *) ((FXShutterItem *) x));
}
static void *_p_FXScrollAreaTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *) ((FXScrollArea *) x));
}
static void *_p_FXStatusBarTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXPacker *)(FXHorizontalFrame *) ((FXStatusBar *) x));
}
static void *_p_FXMainWindowTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXShell *)(FXTopWindow *) ((FXMainWindow *) x));
}
static void *_p_FXTopWindowTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXShell *) ((FXTopWindow *) x));
}
static void *_p_FXRootWindowTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *) ((FXRootWindow *) x));
}
static void *_p_FXCompositeTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *)  ((FXComposite *) x));
}
static void *_p_FXScrollWindowTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXScrollArea *) ((FXScrollWindow *) x));
}
static void *_p_FXShellTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *) ((FXShell *) x));
}
static void *_p_FXGroupBoxTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXPacker *) ((FXGroupBox *) x));
}
static void *_p_FXSplitterTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *) ((FXSplitter *) x));
}
static void *_p_FX4SplitterTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *) ((FX4Splitter *) x));
}
static void *_p_FXPackerTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *) ((FXPacker *) x));
}
static void *_p_FXVerticalFrameTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXPacker *) ((FXVerticalFrame *) x));
}
static void *_p_FXHorizontalFrameTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXPacker *) ((FXHorizontalFrame *) x));
}
static void *_p_FXShutterTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXPacker *)(FXVerticalFrame *) ((FXShutter *) x));
}
static void *_p_FXMatrixTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXPacker *) ((FXMatrix *) x));
}
static void *_p_FXListTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXScrollArea *) ((FXList *) x));
}
static void *_p_FXSpringTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXPacker *) ((FXSpring *) x));
}
static void *_p_FXSwitcherTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXPacker *) ((FXSwitcher *) x));
}
static void *_p_FXSettingsTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXDict *) ((FXSettings *) x));
}
static void *_p_FXAccelTableTo_p_FXObject(void *x) {
    return (void *)((FXObject *)  ((FXAccelTable *) x));
}
static void *_p_FXCompositeTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *) ((FXComposite *) x));
}
static void *_p_FXRegistryTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXDict *)(FXSettings *) ((FXRegistry *) x));
}
static void *_p_FXIconDictTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXDict *) ((FXIconDict *) x));
}
static void *_p_FXGroupBoxTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXGroupBox *) x));
}
static void *_p_FXShellTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *) ((FXShell *) x));
}
static void *_p_FXPopupTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXShell *) ((FXPopup *) x));
}
static void *_p_FXStatusBarTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *)(FXHorizontalFrame *) ((FXStatusBar *) x));
}
static void *_p_FXScrollAreaTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *) ((FXScrollArea *) x));
}
static void *_p_FXRecentFilesTo_p_FXObject(void *x) {
    return (void *)((FXObject *)  ((FXRecentFiles *) x));
}
static void *_p_FXDocumentTo_p_FXObject(void *x) {
    return (void *)((FXObject *)  ((FXDocument *) x));
}
static void *_p_FXMainWindowTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXShell *)(FXTopWindow *) ((FXMainWindow *) x));
}
static void *_p_FXTopWindowTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXShell *) ((FXTopWindow *) x));
}
static void *_p_FXRootWindowTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *) ((FXRootWindow *) x));
}
static void *_p_FXWindowTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *) ((FXWindow *) x));
}
static void *_p_FXScrollWindowTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXScrollArea *) ((FXScrollWindow *) x));
}
static void *_p_FXVerticalFrameTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXVerticalFrame *) x));
}
static void *_p_FXHorizontalFrameTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXHorizontalFrame *) x));
}
static void *_p_FXSplitterTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *) ((FXSplitter *) x));
}
static void *_p_FX4SplitterTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *) ((FX4Splitter *) x));
}
static void *_p_FXStringDictTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXDict *) ((FXStringDict *) x));
}
static void *_p_FXPackerTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *) ((FXPacker *) x));
}
static void *_p_FXFontTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *) ((FXFont *) x));
}
static void *_p_FXListTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXScrollArea *) ((FXList *) x));
}
static void *_p_FXFileDictTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXDict *) ((FXFileDict *) x));
}
static void *_p_FXDataTargetTo_p_FXObject(void *x) {
    return (void *)((FXObject *)  ((FXDataTarget *) x));
}
static void *_p_FXDebugTargetTo_p_FXObject(void *x) {
    return (void *)((FXObject *)  ((FXDebugTarget *) x));
}
static void *_p_FXSwitcherTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXSwitcher *) x));
}
static void *_p_FXShutterTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *)(FXVerticalFrame *) ((FXShutter *) x));
}
static void *_p_FXDelegatorTo_p_FXObject(void *x) {
    return (void *)((FXObject *)  ((FXDelegator *) x));
}
static void *_p_FXDrawableTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *) ((FXDrawable *) x));
}
static void *_p_FXGIFCursorTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXCursor *) ((FXGIFCursor *) x));
}
static void *_p_FXCURCursorTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXCursor *) ((FXCURCursor *) x));
}
static void *_p_FXCursorTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *) ((FXCursor *) x));
}
static void *_p_FXDictTo_p_FXObject(void *x) {
    return (void *)((FXObject *)  ((FXDict *) x));
}
static void *_p_FXMatrixTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXMatrix *) x));
}
static void *_p_FXShutterItemTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *)(FXVerticalFrame *) ((FXShutterItem *) x));
}
static void *_p_FXListItemTo_p_FXObject(void *x) {
    return (void *)((FXObject *)  ((FXListItem *) x));
}
static void *_p_FXIdTo_p_FXObject(void *x) {
    return (void *)((FXObject *)  ((FXId *) x));
}
static void *_p_FXFrameTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *) ((FXFrame *) x));
}
static void *_p_FXSpringTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXSpring *) x));
}
static void *_p_FXVisualTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *) ((FXVisual *) x));
}
static void *_p_FXAppTo_p_FXObject(void *x) {
    return (void *)((FXObject *)  ((FXApp *) x));
}
static void *_p_FXFrameTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *) ((FXFrame *) x));
}
static void *_p_FXPopupTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXShell *) ((FXPopup *) x));
}
static void *_p_FXShutterItemTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *)(FXVerticalFrame *) ((FXShutterItem *) x));
}
static void *_p_FXScrollAreaTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *) ((FXScrollArea *) x));
}
static void *_p_FXStatusBarTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *)(FXHorizontalFrame *) ((FXStatusBar *) x));
}
static void *_p_FXMainWindowTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXShell *)(FXTopWindow *) ((FXMainWindow *) x));
}
static void *_p_FXTopWindowTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXShell *) ((FXTopWindow *) x));
}
static void *_p_FXRootWindowTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *) ((FXRootWindow *) x));
}
static void *_p_FXWindowTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *)  ((FXWindow *) x));
}
static void *_p_FXCompositeTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *) ((FXComposite *) x));
}
static void *_p_FXScrollWindowTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXScrollArea *) ((FXScrollWindow *) x));
}
static void *_p_FXShellTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *) ((FXShell *) x));
}
static void *_p_FXGroupBoxTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *) ((FXGroupBox *) x));
}
static void *_p_FXSplitterTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *) ((FXSplitter *) x));
}
static void *_p_FX4SplitterTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *) ((FX4Splitter *) x));
}
static void *_p_FXPackerTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *) ((FXPacker *) x));
}
static void *_p_FXVerticalFrameTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *) ((FXVerticalFrame *) x));
}
static void *_p_FXHorizontalFrameTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *) ((FXHorizontalFrame *) x));
}
static void *_p_FXShutterTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *)(FXVerticalFrame *) ((FXShutter *) x));
}
static void *_p_FXMatrixTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *) ((FXMatrix *) x));
}
static void *_p_FXListTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXScrollArea *) ((FXList *) x));
}
static void *_p_FXSpringTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *) ((FXSpring *) x));
}
static void *_p_FXSwitcherTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *) ((FXSwitcher *) x));
}
static void *_p_FXListTo_p_FXScrollArea(void *x) {
    return (void *)((FXScrollArea *)  ((FXList *) x));
}
static void *_p_FXScrollWindowTo_p_FXScrollArea(void *x) {
    return (void *)((FXScrollArea *)  ((FXScrollWindow *) x));
}
static void *_p_FXFileStreamTo_p_FXStream(void *x) {
    return (void *)((FXStream *)  ((FXFileStream *) x));
}
static void *_p_FXMemoryStreamTo_p_FXStream(void *x) {
    return (void *)((FXStream *)  ((FXMemoryStream *) x));
}
static swig_type_info _swigt__p_FXId[] = {{"_p_FXId", 0, "FXId *", 0, 0, 0, 0},{"_p_FXFrame", _p_FXFrameTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXPopup", _p_FXPopupTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXShutterItem", _p_FXShutterItemTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXScrollArea", _p_FXScrollAreaTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXStatusBar", _p_FXStatusBarTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXMainWindow", _p_FXMainWindowTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXTopWindow", _p_FXTopWindowTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXRootWindow", _p_FXRootWindowTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXWindow", _p_FXWindowTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXScrollWindow", _p_FXScrollWindowTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXComposite", _p_FXCompositeTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXId", 0, 0, 0, 0, 0, 0},{"_p_FXFont", _p_FXFontTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXShell", _p_FXShellTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXGroupBox", _p_FXGroupBoxTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXList", _p_FXListTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FX4Splitter", _p_FX4SplitterTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXSplitter", _p_FXSplitterTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXGIFCursor", _p_FXGIFCursorTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXCURCursor", _p_FXCURCursorTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXCursor", _p_FXCursorTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXDrawable", _p_FXDrawableTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXShutter", _p_FXShutterTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXPacker", _p_FXPackerTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXVerticalFrame", _p_FXVerticalFrameTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXHorizontalFrame", _p_FXHorizontalFrameTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXMatrix", _p_FXMatrixTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXVisual", _p_FXVisualTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXSpring", _p_FXSpringTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXSwitcher", _p_FXSwitcherTo_p_FXId, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXIcon[] = {{"_p_FXIcon", 0, "FXIcon *", 0, 0, 0, 0},{"_p_FXIcon", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXComposite[] = {{"_p_FXComposite", 0, "FXComposite *", 0, 0, 0, 0},{"_p_FXPopup", _p_FXPopupTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXShutterItem", _p_FXShutterItemTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXScrollArea", _p_FXScrollAreaTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXStatusBar", _p_FXStatusBarTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXMainWindow", _p_FXMainWindowTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXTopWindow", _p_FXTopWindowTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXRootWindow", _p_FXRootWindowTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXScrollWindow", _p_FXScrollWindowTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXComposite", 0, 0, 0, 0, 0, 0},{"_p_FXShell", _p_FXShellTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXGroupBox", _p_FXGroupBoxTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXSplitter", _p_FXSplitterTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FX4Splitter", _p_FX4SplitterTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXList", _p_FXListTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXShutter", _p_FXShutterTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXPacker", _p_FXPackerTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXVerticalFrame", _p_FXVerticalFrameTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXHorizontalFrame", _p_FXHorizontalFrameTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXMatrix", _p_FXMatrixTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXSpring", _p_FXSpringTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXSwitcher", _p_FXSwitcherTo_p_FXComposite, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXWindow[] = {{"_p_FXWindow", 0, "FXWindow *", 0, 0, 0, 0},{"_p_FXFrame", _p_FXFrameTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXPopup", _p_FXPopupTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXShutterItem", _p_FXShutterItemTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXScrollArea", _p_FXScrollAreaTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXStatusBar", _p_FXStatusBarTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXMainWindow", _p_FXMainWindowTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXTopWindow", _p_FXTopWindowTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXRootWindow", _p_FXRootWindowTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXScrollWindow", _p_FXScrollWindowTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXWindow", 0, 0, 0, 0, 0, 0},{"_p_FXComposite", _p_FXCompositeTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXShell", _p_FXShellTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXGroupBox", _p_FXGroupBoxTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXList", _p_FXListTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FX4Splitter", _p_FX4SplitterTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXSplitter", _p_FXSplitterTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXShutter", _p_FXShutterTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXPacker", _p_FXPackerTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXVerticalFrame", _p_FXVerticalFrameTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXHorizontalFrame", _p_FXHorizontalFrameTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXMatrix", _p_FXMatrixTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXSpring", _p_FXSpringTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXSwitcher", _p_FXSwitcherTo_p_FXWindow, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXList[] = {{"_p_FXList", 0, "FXList *", 0, 0, 0, 0},{"_p_FXList", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXFont[] = {{"_p_FXFont", 0, "FXFont *", 0, 0, 0, 0},{"_p_FXFont", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXObject[] = {{"_p_FXObject", 0, "FXObject *", 0, 0, 0, 0},{"_p_FXDict", _p_FXDictTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXSettings", _p_FXSettingsTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXAccelTable", _p_FXAccelTableTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXComposite", _p_FXCompositeTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXRegistry", _p_FXRegistryTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXId", _p_FXIdTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXIconDict", _p_FXIconDictTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXGroupBox", _p_FXGroupBoxTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXShell", _p_FXShellTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXStatusBar", _p_FXStatusBarTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXScrollArea", _p_FXScrollAreaTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXPopup", _p_FXPopupTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXWindow", _p_FXWindowTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXScrollWindow", _p_FXScrollWindowTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXRootWindow", _p_FXRootWindowTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXTopWindow", _p_FXTopWindowTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXMainWindow", _p_FXMainWindowTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXRecentFiles", _p_FXRecentFilesTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXDocument", _p_FXDocumentTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXHorizontalFrame", _p_FXHorizontalFrameTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXVerticalFrame", _p_FXVerticalFrameTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXSplitter", _p_FXSplitterTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FX4Splitter", _p_FX4SplitterTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXObject", 0, 0, 0, 0, 0, 0},{"_p_FXStringDict", _p_FXStringDictTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXPacker", _p_FXPackerTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXFileDict", _p_FXFileDictTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXSwitcher", _p_FXSwitcherTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXDebugTarget", _p_FXDebugTargetTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXDataTarget", _p_FXDataTargetTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXShutter", _p_FXShutterTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXCursor", _p_FXCursorTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXCURCursor", _p_FXCURCursorTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXGIFCursor", _p_FXGIFCursorTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXDrawable", _p_FXDrawableTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXDelegator", _p_FXDelegatorTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXApp", _p_FXAppTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXMatrix", _p_FXMatrixTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXShutterItem", _p_FXShutterItemTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXListItem", _p_FXListItemTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXList", _p_FXListTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXFont", _p_FXFontTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXFrame", _p_FXFrameTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXSpring", _p_FXSpringTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXVisual", _p_FXVisualTo_p_FXObject, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXDrawable[] = {{"_p_FXDrawable", 0, "FXDrawable *", 0, 0, 0, 0},{"_p_FXFrame", _p_FXFrameTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXPopup", _p_FXPopupTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXShutterItem", _p_FXShutterItemTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXScrollArea", _p_FXScrollAreaTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXStatusBar", _p_FXStatusBarTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXMainWindow", _p_FXMainWindowTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXTopWindow", _p_FXTopWindowTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXRootWindow", _p_FXRootWindowTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXWindow", _p_FXWindowTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXScrollWindow", _p_FXScrollWindowTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXComposite", _p_FXCompositeTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXShell", _p_FXShellTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXGroupBox", _p_FXGroupBoxTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXDrawable", 0, 0, 0, 0, 0, 0},{"_p_FXList", _p_FXListTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FX4Splitter", _p_FX4SplitterTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXSplitter", _p_FXSplitterTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXShutter", _p_FXShutterTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXPacker", _p_FXPackerTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXVerticalFrame", _p_FXVerticalFrameTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXHorizontalFrame", _p_FXHorizontalFrameTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXMatrix", _p_FXMatrixTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXSpring", _p_FXSpringTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXSwitcher", _p_FXSwitcherTo_p_FXDrawable, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXScrollArea[] = {{"_p_FXScrollArea", 0, "FXScrollArea *", 0, 0, 0, 0},{"_p_FXList", _p_FXListTo_p_FXScrollArea, 0, 0, 0, 0, 0},{"_p_FXScrollWindow", _p_FXScrollWindowTo_p_FXScrollArea, 0, 0, 0, 0, 0},{"_p_FXScrollArea", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXListItem[] = {{"_p_FXListItem", 0, "FXListItem *", 0, 0, 0, 0},{"_p_FXListItem", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXStream[] = {{"_p_FXStream", 0, "FXStream *", 0, 0, 0, 0},{"_p_FXFileStream", _p_FXFileStreamTo_p_FXStream, 0, 0, 0, 0, 0},{"_p_FXMemoryStream", _p_FXMemoryStreamTo_p_FXStream, 0, 0, 0, 0, 0},{"_p_FXStream", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};

static swig_type_info *swig_types_initial[] = {
_swigt__p_FXId, 
_swigt__p_FXIcon, 
_swigt__p_FXComposite, 
_swigt__p_FXWindow, 
_swigt__p_FXList, 
_swigt__p_FXFont, 
_swigt__p_FXObject, 
_swigt__p_FXDrawable, 
_swigt__p_FXScrollArea, 
_swigt__p_FXListItem, 
_swigt__p_FXStream, 
0
};


/* -------- TYPE CONVERSION AND EQUIVALENCE RULES (END) -------- */


#ifdef __cplusplus
extern "C"
#endif
SWIGEXPORT(void) Init_list(void) {
    int i;
    
    SWIG_InitRuntime();
    
    for (i = 0; swig_types_initial[i]; i++) {
        swig_types[i] = SWIG_TypeRegister(swig_types_initial[i]);
        SWIG_define_class(swig_types[i]);
    }
    
    rb_define_const(mFox,"LIST_EXTENDEDSELECT", INT2NUM(LIST_EXTENDEDSELECT));
    rb_define_const(mFox,"LIST_SINGLESELECT", INT2NUM(LIST_SINGLESELECT));
    rb_define_const(mFox,"LIST_BROWSESELECT", INT2NUM(LIST_BROWSESELECT));
    rb_define_const(mFox,"LIST_MULTIPLESELECT", INT2NUM(LIST_MULTIPLESELECT));
    rb_define_const(mFox,"LIST_AUTOSELECT", INT2NUM(LIST_AUTOSELECT));
    rb_define_const(mFox,"LIST_NORMAL", INT2NUM(LIST_NORMAL));
    
    cFXListItem.klass = rb_define_class_under(mFox, "FXListItem", ((swig_class *) SWIGTYPE_p_FXObject->clientdata)->klass);
    SWIG_TypeClientData(SWIGTYPE_p_FXListItem, (void *) &cFXListItem);
    rb_define_alloc_func(cFXListItem.klass, _wrap_FXListItem_allocate);
    rb_define_method(cFXListItem.klass, "initialize", VALUEFUNC(_wrap_new_FXListItem), -1);
    rb_define_method(cFXListItem.klass, "getText", VALUEFUNC(_wrap_FXListItem_getText), -1);
    rb_define_method(cFXListItem.klass, "getIcon", VALUEFUNC(_wrap_FXListItem_getIcon), -1);
    rb_define_method(cFXListItem.klass, "setData", VALUEFUNC(_wrap_FXListItem_setData), -1);
    rb_define_method(cFXListItem.klass, "getData", VALUEFUNC(_wrap_FXListItem_getData), -1);
    rb_define_method(cFXListItem.klass, "hasFocus", VALUEFUNC(_wrap_FXListItem_hasFocus), -1);
    rb_define_method(cFXListItem.klass, "isSelected", VALUEFUNC(_wrap_FXListItem_isSelected), -1);
    rb_define_method(cFXListItem.klass, "isEnabled", VALUEFUNC(_wrap_FXListItem_isEnabled), -1);
    rb_define_method(cFXListItem.klass, "isDraggable", VALUEFUNC(_wrap_FXListItem_isDraggable), -1);
    rb_define_method(cFXListItem.klass, "isIconOwned", VALUEFUNC(_wrap_FXListItem_isIconOwned), -1);
    rb_define_method(cFXListItem.klass, "save", VALUEFUNC(_wrap_FXListItem_save), -1);
    rb_define_method(cFXListItem.klass, "load", VALUEFUNC(_wrap_FXListItem_load), -1);
    rb_define_method(cFXListItem.klass, "setText", VALUEFUNC(_wrap_FXListItem_setText), -1);
    rb_define_method(cFXListItem.klass, "setIcon", VALUEFUNC(_wrap_FXListItem_setIcon), -1);
    rb_define_method(cFXListItem.klass, "setFocus", VALUEFUNC(_wrap_FXListItem_setFocus), -1);
    rb_define_method(cFXListItem.klass, "setSelected", VALUEFUNC(_wrap_FXListItem_setSelected), -1);
    rb_define_method(cFXListItem.klass, "setEnabled", VALUEFUNC(_wrap_FXListItem_setEnabled), -1);
    rb_define_method(cFXListItem.klass, "setDraggable", VALUEFUNC(_wrap_FXListItem_setDraggable), -1);
    rb_define_method(cFXListItem.klass, "setIconOwned", VALUEFUNC(_wrap_FXListItem_setIconOwned), -1);
    rb_define_method(cFXListItem.klass, "getWidth", VALUEFUNC(_wrap_FXListItem_getWidth), -1);
    rb_define_method(cFXListItem.klass, "getHeight", VALUEFUNC(_wrap_FXListItem_getHeight), -1);
    rb_define_method(cFXListItem.klass, "create", VALUEFUNC(_wrap_FXListItem_create), -1);
    rb_define_method(cFXListItem.klass, "detach", VALUEFUNC(_wrap_FXListItem_detach), -1);
    rb_define_method(cFXListItem.klass, "destroy", VALUEFUNC(_wrap_FXListItem_destroy), -1);
    cFXListItem.mark = (void (*)(void *)) FXRbListItem::markfunc;
    cFXListItem.destroy = (void (*)(void *)) FXRbListItem::freefunc;
    
    cFXList.klass = rb_define_class_under(mFox, "FXList", ((swig_class *) SWIGTYPE_p_FXScrollArea->clientdata)->klass);
    SWIG_TypeClientData(SWIGTYPE_p_FXList, (void *) &cFXList);
    rb_define_alloc_func(cFXList.klass, _wrap_FXList_allocate);
    rb_define_method(cFXList.klass, "initialize", VALUEFUNC(_wrap_new_FXList), -1);
    rb_define_method(cFXList.klass, "onPaint", VALUEFUNC(_wrap_FXList_onPaint), -1);
    rb_define_method(cFXList.klass, "onEnter", VALUEFUNC(_wrap_FXList_onEnter), -1);
    rb_define_method(cFXList.klass, "onLeave", VALUEFUNC(_wrap_FXList_onLeave), -1);
    rb_define_method(cFXList.klass, "onUngrabbed", VALUEFUNC(_wrap_FXList_onUngrabbed), -1);
    rb_define_method(cFXList.klass, "onKeyPress", VALUEFUNC(_wrap_FXList_onKeyPress), -1);
    rb_define_method(cFXList.klass, "onKeyRelease", VALUEFUNC(_wrap_FXList_onKeyRelease), -1);
    rb_define_method(cFXList.klass, "onLeftBtnPress", VALUEFUNC(_wrap_FXList_onLeftBtnPress), -1);
    rb_define_method(cFXList.klass, "onLeftBtnRelease", VALUEFUNC(_wrap_FXList_onLeftBtnRelease), -1);
    rb_define_method(cFXList.klass, "onRightBtnPress", VALUEFUNC(_wrap_FXList_onRightBtnPress), -1);
    rb_define_method(cFXList.klass, "onRightBtnRelease", VALUEFUNC(_wrap_FXList_onRightBtnRelease), -1);
    rb_define_method(cFXList.klass, "onMotion", VALUEFUNC(_wrap_FXList_onMotion), -1);
    rb_define_method(cFXList.klass, "onFocusIn", VALUEFUNC(_wrap_FXList_onFocusIn), -1);
    rb_define_method(cFXList.klass, "onFocusOut", VALUEFUNC(_wrap_FXList_onFocusOut), -1);
    rb_define_method(cFXList.klass, "onAutoScroll", VALUEFUNC(_wrap_FXList_onAutoScroll), -1);
    rb_define_method(cFXList.klass, "onClicked", VALUEFUNC(_wrap_FXList_onClicked), -1);
    rb_define_method(cFXList.klass, "onDoubleClicked", VALUEFUNC(_wrap_FXList_onDoubleClicked), -1);
    rb_define_method(cFXList.klass, "onTripleClicked", VALUEFUNC(_wrap_FXList_onTripleClicked), -1);
    rb_define_method(cFXList.klass, "onCommand", VALUEFUNC(_wrap_FXList_onCommand), -1);
    rb_define_method(cFXList.klass, "onQueryTip", VALUEFUNC(_wrap_FXList_onQueryTip), -1);
    rb_define_method(cFXList.klass, "onQueryHelp", VALUEFUNC(_wrap_FXList_onQueryHelp), -1);
    rb_define_method(cFXList.klass, "onTipTimer", VALUEFUNC(_wrap_FXList_onTipTimer), -1);
    rb_define_method(cFXList.klass, "onLookupTimer", VALUEFUNC(_wrap_FXList_onLookupTimer), -1);
    rb_define_method(cFXList.klass, "onCmdSetValue", VALUEFUNC(_wrap_FXList_onCmdSetValue), -1);
    rb_define_method(cFXList.klass, "onCmdGetIntValue", VALUEFUNC(_wrap_FXList_onCmdGetIntValue), -1);
    rb_define_method(cFXList.klass, "onCmdSetIntValue", VALUEFUNC(_wrap_FXList_onCmdSetIntValue), -1);
    rb_define_singleton_method(cFXList.klass, "ascending", VALUEFUNC(_wrap_FXList_ascending), -1);
    rb_define_singleton_method(cFXList.klass, "descending", VALUEFUNC(_wrap_FXList_descending), -1);
    rb_define_singleton_method(cFXList.klass, "ascendingCase", VALUEFUNC(_wrap_FXList_ascendingCase), -1);
    rb_define_singleton_method(cFXList.klass, "descendingCase", VALUEFUNC(_wrap_FXList_descendingCase), -1);
    rb_define_const(cFXList.klass,"ID_LOOKUPTIMER", INT2NUM(FXList::ID_LOOKUPTIMER));
    rb_define_const(cFXList.klass,"ID_LAST", INT2NUM(FXList::ID_LAST));
    rb_define_method(cFXList.klass, "getNumItems", VALUEFUNC(_wrap_FXList_getNumItems), -1);
    rb_define_method(cFXList.klass, "getNumVisible", VALUEFUNC(_wrap_FXList_getNumVisible), -1);
    rb_define_method(cFXList.klass, "setNumVisible", VALUEFUNC(_wrap_FXList_setNumVisible), -1);
    rb_define_method(cFXList.klass, "getItem", VALUEFUNC(_wrap_FXList_getItem), -1);
    rb_define_method(cFXList.klass, "setItem", VALUEFUNC(_wrap_FXList_setItem), -1);
    rb_define_method(cFXList.klass, "insertItem", VALUEFUNC(_wrap_FXList_insertItem), -1);
    rb_define_method(cFXList.klass, "appendItem", VALUEFUNC(_wrap_FXList_appendItem), -1);
    rb_define_alias(cFXList.klass, "<<", "appendItem");
    rb_define_method(cFXList.klass, "prependItem", VALUEFUNC(_wrap_FXList_prependItem), -1);
    rb_define_method(cFXList.klass, "moveItem", VALUEFUNC(_wrap_FXList_moveItem), -1);
    rb_define_method(cFXList.klass, "removeItem", VALUEFUNC(_wrap_FXList_removeItem), -1);
    rb_define_method(cFXList.klass, "clearItems", VALUEFUNC(_wrap_FXList_clearItems), -1);
    rb_define_method(cFXList.klass, "getItemWidth", VALUEFUNC(_wrap_FXList_getItemWidth), -1);
    rb_define_method(cFXList.klass, "getItemHeight", VALUEFUNC(_wrap_FXList_getItemHeight), -1);
    rb_define_method(cFXList.klass, "getItemAt", VALUEFUNC(_wrap_FXList_getItemAt), -1);
    rb_define_method(cFXList.klass, "hitItem", VALUEFUNC(_wrap_FXList_hitItem), -1);
    rb_define_method(cFXList.klass, "findItem", VALUEFUNC(_wrap_FXList_findItem), -1);
    rb_define_method(cFXList.klass, "makeItemVisible", VALUEFUNC(_wrap_FXList_makeItemVisible), -1);
    rb_define_method(cFXList.klass, "setItemText", VALUEFUNC(_wrap_FXList_setItemText), -1);
    rb_define_method(cFXList.klass, "getItemText", VALUEFUNC(_wrap_FXList_getItemText), -1);
    rb_define_method(cFXList.klass, "setItemIcon", VALUEFUNC(_wrap_FXList_setItemIcon), -1);
    rb_define_method(cFXList.klass, "getItemIcon", VALUEFUNC(_wrap_FXList_getItemIcon), -1);
    rb_define_method(cFXList.klass, "setItemData", VALUEFUNC(_wrap_FXList_setItemData), -1);
    rb_define_method(cFXList.klass, "getItemData", VALUEFUNC(_wrap_FXList_getItemData), -1);
    rb_define_method(cFXList.klass, "isItemSelected", VALUEFUNC(_wrap_FXList_isItemSelected), -1);
    rb_define_method(cFXList.klass, "isItemCurrent", VALUEFUNC(_wrap_FXList_isItemCurrent), -1);
    rb_define_method(cFXList.klass, "isItemVisible", VALUEFUNC(_wrap_FXList_isItemVisible), -1);
    rb_define_method(cFXList.klass, "isItemEnabled", VALUEFUNC(_wrap_FXList_isItemEnabled), -1);
    rb_define_method(cFXList.klass, "updateItem", VALUEFUNC(_wrap_FXList_updateItem), -1);
    rb_define_method(cFXList.klass, "enableItem", VALUEFUNC(_wrap_FXList_enableItem), -1);
    rb_define_method(cFXList.klass, "disableItem", VALUEFUNC(_wrap_FXList_disableItem), -1);
    rb_define_method(cFXList.klass, "getCurrentItem", VALUEFUNC(_wrap_FXList_getCurrentItem), -1);
    rb_define_method(cFXList.klass, "setAnchorItem", VALUEFUNC(_wrap_FXList_setAnchorItem), -1);
    rb_define_method(cFXList.klass, "getAnchorItem", VALUEFUNC(_wrap_FXList_getAnchorItem), -1);
    rb_define_method(cFXList.klass, "getCursorItem", VALUEFUNC(_wrap_FXList_getCursorItem), -1);
    rb_define_method(cFXList.klass, "sortItems", VALUEFUNC(_wrap_FXList_sortItems), -1);
    rb_define_method(cFXList.klass, "setFont", VALUEFUNC(_wrap_FXList_setFont), -1);
    rb_define_method(cFXList.klass, "getFont", VALUEFUNC(_wrap_FXList_getFont), -1);
    rb_define_method(cFXList.klass, "getTextColor", VALUEFUNC(_wrap_FXList_getTextColor), -1);
    rb_define_method(cFXList.klass, "setTextColor", VALUEFUNC(_wrap_FXList_setTextColor), -1);
    rb_define_method(cFXList.klass, "getSelBackColor", VALUEFUNC(_wrap_FXList_getSelBackColor), -1);
    rb_define_method(cFXList.klass, "setSelBackColor", VALUEFUNC(_wrap_FXList_setSelBackColor), -1);
    rb_define_method(cFXList.klass, "getSelTextColor", VALUEFUNC(_wrap_FXList_getSelTextColor), -1);
    rb_define_method(cFXList.klass, "setSelTextColor", VALUEFUNC(_wrap_FXList_setSelTextColor), -1);
    rb_define_method(cFXList.klass, "getListStyle", VALUEFUNC(_wrap_FXList_getListStyle), -1);
    rb_define_method(cFXList.klass, "setListStyle", VALUEFUNC(_wrap_FXList_setListStyle), -1);
    rb_define_method(cFXList.klass, "setHelpText", VALUEFUNC(_wrap_FXList_setHelpText), -1);
    rb_define_method(cFXList.klass, "getHelpText", VALUEFUNC(_wrap_FXList_getHelpText), -1);
    rb_define_method(cFXList.klass, "save", VALUEFUNC(_wrap_FXList_save), -1);
    rb_define_method(cFXList.klass, "load", VALUEFUNC(_wrap_FXList_load), -1);
    rb_define_method(cFXList.klass, "create", VALUEFUNC(_wrap_FXList_create), -1);
    rb_define_method(cFXList.klass, "detach", VALUEFUNC(_wrap_FXList_detach), -1);
    rb_define_method(cFXList.klass, "destroy", VALUEFUNC(_wrap_FXList_destroy), -1);
    rb_define_method(cFXList.klass, "resize", VALUEFUNC(_wrap_FXList_resize), -1);
    rb_define_method(cFXList.klass, "getDefaultWidth", VALUEFUNC(_wrap_FXList_getDefaultWidth), -1);
    rb_define_method(cFXList.klass, "getDefaultHeight", VALUEFUNC(_wrap_FXList_getDefaultHeight), -1);
    rb_define_method(cFXList.klass, "getWidthForHeight", VALUEFUNC(_wrap_FXList_getWidthForHeight), -1);
    rb_define_method(cFXList.klass, "getHeightForWidth", VALUEFUNC(_wrap_FXList_getHeightForWidth), -1);
    rb_define_method(cFXList.klass, "canFocus", VALUEFUNC(_wrap_FXList_canFocus), -1);
    rb_define_method(cFXList.klass, "setFocus", VALUEFUNC(_wrap_FXList_setFocus), -1);
    rb_define_method(cFXList.klass, "killFocus", VALUEFUNC(_wrap_FXList_killFocus), -1);
    rb_define_method(cFXList.klass, "setDefault", VALUEFUNC(_wrap_FXList_setDefault), -1);
    rb_define_method(cFXList.klass, "enable", VALUEFUNC(_wrap_FXList_enable), -1);
    rb_define_method(cFXList.klass, "disable", VALUEFUNC(_wrap_FXList_disable), -1);
    rb_define_method(cFXList.klass, "raiseWindow", VALUEFUNC(_wrap_FXList_raiseWindow), -1);
    rb_define_method(cFXList.klass, "lower", VALUEFUNC(_wrap_FXList_lower), -1);
    rb_define_method(cFXList.klass, "move", VALUEFUNC(_wrap_FXList_move), -1);
    rb_define_method(cFXList.klass, "layout", VALUEFUNC(_wrap_FXList_layout), -1);
    rb_define_method(cFXList.klass, "recalc", VALUEFUNC(_wrap_FXList_recalc), -1);
    rb_define_method(cFXList.klass, "reparent", VALUEFUNC(_wrap_FXList_reparent), -1);
    rb_define_method(cFXList.klass, "show", VALUEFUNC(_wrap_FXList_show), -1);
    rb_define_method(cFXList.klass, "hide", VALUEFUNC(_wrap_FXList_hide), -1);
    rb_define_method(cFXList.klass, "isComposite", VALUEFUNC(_wrap_FXList_isComposite), -1);
    rb_define_method(cFXList.klass, "contains", VALUEFUNC(_wrap_FXList_contains), -1);
    rb_define_method(cFXList.klass, "doesSaveUnder", VALUEFUNC(_wrap_FXList_doesSaveUnder), -1);
    rb_define_method(cFXList.klass, "setBackColor", VALUEFUNC(_wrap_FXList_setBackColor), -1);
    rb_define_method(cFXList.klass, "getViewportHeight", VALUEFUNC(_wrap_FXList_getViewportHeight), -1);
    rb_define_method(cFXList.klass, "getViewportWidth", VALUEFUNC(_wrap_FXList_getViewportWidth), -1);
    rb_define_method(cFXList.klass, "getContentHeight", VALUEFUNC(_wrap_FXList_getContentHeight), -1);
    rb_define_method(cFXList.klass, "getContentWidth", VALUEFUNC(_wrap_FXList_getContentWidth), -1);
    rb_define_method(cFXList.klass, "position", VALUEFUNC(_wrap_FXList_position), -1);
    rb_define_method(cFXList.klass, "selectItem", VALUEFUNC(_wrap_FXList_selectItem), -1);
    rb_define_method(cFXList.klass, "deselectItem", VALUEFUNC(_wrap_FXList_deselectItem), -1);
    rb_define_method(cFXList.klass, "toggleItem", VALUEFUNC(_wrap_FXList_toggleItem), -1);
    rb_define_method(cFXList.klass, "extendSelection", VALUEFUNC(_wrap_FXList_extendSelection), -1);
    rb_define_method(cFXList.klass, "killSelection", VALUEFUNC(_wrap_FXList_killSelection), -1);
    rb_define_method(cFXList.klass, "setCurrentItem", VALUEFUNC(_wrap_FXList_setCurrentItem), -1);
    cFXList.mark = (void (*)(void *)) FXRbList::markfunc;
    cFXList.destroy = (void (*)(void *)) FXRbObject::freefunc;
}

