/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 1.3.22
 * 
 * This file is not intended to be easily readable and contains a number of 
 * coding conventions designed to improve portability and efficiency. Do not make
 * changes to this file unless you know what you are doing--modify the SWIG 
 * interface file instead. 
 * ----------------------------------------------------------------------------- */

#define SWIG_NOINCLUDE

#ifdef __cplusplus
template<class T> class SwigValueWrapper {
    T *tt;
public:
    SwigValueWrapper() : tt(0) { }
    SwigValueWrapper(const SwigValueWrapper<T>& rhs) : tt(new T(*rhs.tt)) { }
    SwigValueWrapper(const T& t) : tt(new T(t)) { }
    ~SwigValueWrapper() { delete tt; } 
    SwigValueWrapper& operator=(const T& t) { delete tt; tt = new T(t); return *this; }
    operator T&() const { return *tt; }
    T *operator&() { return tt; }
private:
    SwigValueWrapper& operator=(const SwigValueWrapper<T>& rhs);
};                                                    
#endif

/* ruby.swg */
/* Implementation : RUBY */
#define SWIGRUBY 1

#include "ruby.h"

/* Flags for pointer conversion */
#define SWIG_POINTER_EXCEPTION     0x1
#define SWIG_POINTER_DISOWN        0x2

#define NUM2USHRT(n) (\
    (0 <= NUM2UINT(n) && NUM2UINT(n) <= USHRT_MAX)\
    ? (unsigned short) NUM2UINT(n) \
    : (rb_raise(rb_eArgError, "integer %d out of range of `unsigned short'",\
               NUM2UINT(n)), (short)0)\
)

#define NUM2SHRT(n) (\
    (SHRT_MIN <= NUM2INT(n) && NUM2INT(n) <= SHRT_MAX)\
    ? (short)NUM2INT(n)\
    : (rb_raise(rb_eArgError, "integer %d out of range of `short'",\
               NUM2INT(n)), (short)0)\
)

/* Ruby 1.7 defines NUM2LL(), LL2NUM() and ULL2NUM() macros */
#ifndef NUM2LL
#define NUM2LL(x) NUM2LONG((x))
#endif
#ifndef LL2NUM
#define LL2NUM(x) INT2NUM((long) (x))
#endif
#ifndef ULL2NUM
#define ULL2NUM(x) UINT2NUM((unsigned long) (x))
#endif

/* Ruby 1.7 doesn't (yet) define NUM2ULL() */
#ifndef NUM2ULL
#ifdef HAVE_LONG_LONG
#define NUM2ULL(x) rb_num2ull((x))
#else
#define NUM2ULL(x) NUM2ULONG(x)
#endif
#endif

/*
 * Need to be very careful about how these macros are defined, especially
 * when compiling C++ code or C code with an ANSI C compiler.
 *
 * VALUEFUNC(f) is a macro used to typecast a C function that implements
 * a Ruby method so that it can be passed as an argument to API functions
 * like rb_define_method() and rb_define_singleton_method().
 *
 * VOIDFUNC(f) is a macro used to typecast a C function that implements
 * either the "mark" or "free" stuff for a Ruby Data object, so that it
 * can be passed as an argument to API functions like Data_Wrap_Struct()
 * and Data_Make_Struct().
 */
 
#ifdef __cplusplus
#  ifndef RUBY_METHOD_FUNC /* These definitions should work for Ruby 1.4.6 */
#    define PROTECTFUNC(f) ((VALUE (*)()) f)
#    define VALUEFUNC(f) ((VALUE (*)()) f)
#    define VOIDFUNC(f)  ((void (*)()) f)
#  else
#    ifndef ANYARGS /* These definitions should work for Ruby 1.6 */
#      define PROTECTFUNC(f) ((VALUE (*)()) f)
#      define VALUEFUNC(f) ((VALUE (*)()) f)
#      define VOIDFUNC(f)  ((RUBY_DATA_FUNC) f)
#    else /* These definitions should work for Ruby 1.7+ */
#      define PROTECTFUNC(f) ((VALUE (*)(VALUE)) f)
#      define VALUEFUNC(f) ((VALUE (*)(ANYARGS)) f)
#      define VOIDFUNC(f)  ((RUBY_DATA_FUNC) f)
#    endif
#  endif
#else
#  define VALUEFUNC(f) (f)
#  define VOIDFUNC(f) (f)
#endif

typedef struct {
  VALUE klass;
  VALUE mImpl;
  void  (*mark)(void *);
  void  (*destroy)(void *);
} swig_class;

/* Don't use for expressions have side effect */
#ifndef RB_STRING_VALUE
#define RB_STRING_VALUE(s) (TYPE(s) == T_STRING ? (s) : (*(volatile VALUE *)&(s) = rb_str_to_str(s)))
#endif
#ifndef StringValue
#define StringValue(s) RB_STRING_VALUE(s)
#endif
#ifndef StringValuePtr
#define StringValuePtr(s) RSTRING(RB_STRING_VALUE(s))->ptr
#endif
#ifndef StringValueLen
#define StringValueLen(s) RSTRING(RB_STRING_VALUE(s))->len
#endif
#ifndef SafeStringValue
#define SafeStringValue(v) do {\
    StringValue(v);\
    rb_check_safe_str(v);\
} while (0)
#endif

#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
#define rb_define_alloc_func(klass, func) rb_define_singleton_method((klass), "new", VALUEFUNC((func)), -1)
#define rb_undef_alloc_func(klass) rb_undef_method(CLASS_OF((klass)), "new")
#endif

/* Contract support */

#define SWIG_contract_assert(expr, msg) if (!(expr)) { rb_raise(rb_eRuntimeError, (char *) msg ); } else


/*************************************************************** -*- c -*-
 * ruby/precommon.swg
 *
 * Rename all exported symbols from common.swg, to avoid symbol
 * clashes if multiple interpreters are included
 *
 ************************************************************************/

#define SWIG_TypeRegister    SWIG_Ruby_TypeRegister
#define SWIG_TypeCheck       SWIG_Ruby_TypeCheck
#define SWIG_TypeCast        SWIG_Ruby_TypeCast
#define SWIG_TypeDynamicCast SWIG_Ruby_TypeDynamicCast
#define SWIG_TypeName        SWIG_Ruby_TypeName
#define SWIG_TypePrettyName  SWIG_Ruby_TypePrettyName
#define SWIG_TypeQuery       SWIG_Ruby_TypeQuery
#define SWIG_TypeClientData  SWIG_Ruby_TypeClientData
#define SWIG_PackData        SWIG_Ruby_PackData 
#define SWIG_UnpackData      SWIG_Ruby_UnpackData 

/* Also rename all exported symbols from rubydef.swig */

/* Common SWIG API */
#define SWIG_ConvertPtr(obj, pp, type, flags) \
  SWIG_Ruby_ConvertPtr(obj, pp, type, flags)
#define SWIG_NewPointerObj(p, type, flags) \
  SWIG_Ruby_NewPointerObj(p, type, flags)
#define SWIG_MustGetPtr(p, type, argnum, flags) \
  SWIG_Ruby_MustGetPtr(p, type, argnum, flags)

/* Ruby-specific SWIG API */

#define SWIG_InitRuntime() \
  SWIG_Ruby_InitRuntime()
#define SWIG_define_class(ty) \
  SWIG_Ruby_define_class(ty)
#define SWIG_NewClassInstance(value, ty) \
  SWIG_Ruby_NewClassInstance(value, ty)
#define SWIG_MangleStr(value) \
  SWIG_Ruby_MangleStr(value)
#define SWIG_CheckConvert(value, ty) \
  SWIG_Ruby_CheckConvert(value, ty)
#define SWIG_NewPackedObj(ptr, sz, ty) \
  SWIG_Ruby_NewPackedObj(ptr, sz, ty)
#define SWIG_ConvertPacked(obj, ptr, sz, ty, flags) \
  SWIG_Ruby_ConvertPacked(obj, ptr, sz, ty, flags)


/***********************************************************************
 * common.swg
 *
 *     This file contains generic SWIG runtime support for pointer
 *     type checking as well as a few commonly used macros to control
 *     external linkage.
 *
 * Author : David Beazley (beazley@cs.uchicago.edu)
 *
 * Copyright (c) 1999-2000, The University of Chicago
 * 
 * This file may be freely redistributed without license or fee provided
 * this copyright message remains intact.
 ************************************************************************/

#include <string.h>

#if defined(_WIN32) || defined(__WIN32__) || defined(__CYGWIN__)
#  if defined(_MSC_VER) || defined(__GNUC__)
#    if defined(STATIC_LINKED)
#      define SWIGEXPORT(a) a
#      define SWIGIMPORT(a) extern a
#    else
#      define SWIGEXPORT(a) __declspec(dllexport) a
#      define SWIGIMPORT(a) extern a
#    endif
#  else
#    if defined(__BORLANDC__)
#      define SWIGEXPORT(a) a _export
#      define SWIGIMPORT(a) a _export
#    else
#      define SWIGEXPORT(a) a
#      define SWIGIMPORT(a) a
#    endif
#  endif
#else
#  define SWIGEXPORT(a) a
#  define SWIGIMPORT(a) a
#endif

#ifdef SWIG_GLOBAL
#  define SWIGRUNTIME(a) SWIGEXPORT(a)
#else
#  define SWIGRUNTIME(a) static a
#endif

#ifdef __cplusplus
extern "C" {
#endif

typedef void *(*swig_converter_func)(void *);
typedef struct swig_type_info *(*swig_dycast_func)(void **);

typedef struct swig_type_info {
  const char             *name;
  swig_converter_func     converter;
  const char             *str;
  void                   *clientdata;
  swig_dycast_func        dcast;
  struct swig_type_info  *next;
  struct swig_type_info  *prev;
} swig_type_info;

#ifdef SWIG_NOINCLUDE

SWIGIMPORT(swig_type_info *) SWIG_TypeRegister(swig_type_info *);
SWIGIMPORT(swig_type_info *) SWIG_TypeCheck(char *c, swig_type_info *);
SWIGIMPORT(void *)           SWIG_TypeCast(swig_type_info *, void *);
SWIGIMPORT(swig_type_info *) SWIG_TypeDynamicCast(swig_type_info *, void **);
SWIGIMPORT(const char *)     SWIG_TypeName(const swig_type_info *);
SWIGIMPORT(const char *)     SWIG_TypePrettyName(const swig_type_info *);
SWIGIMPORT(swig_type_info *) SWIG_TypeQuery(const char *);
SWIGIMPORT(void)             SWIG_TypeClientData(swig_type_info *, void *);
SWIGIMPORT(char *)           SWIG_PackData(char *, void *, int);
SWIGIMPORT(char *)           SWIG_UnpackData(char *, void *, int);

#else

static swig_type_info *swig_type_list = 0;
static swig_type_info **swig_type_list_handle = &swig_type_list;

/* Register a type mapping with the type-checking */
SWIGRUNTIME(swig_type_info *)
SWIG_TypeRegister(swig_type_info *ti) {
  swig_type_info *tc, *head, *ret, *next;
  /* Check to see if this type has already been registered */
  tc = *swig_type_list_handle;
  while (tc) {
    if (strcmp(tc->name, ti->name) == 0) {
      /* Already exists in the table.  Just add additional types to the list */
      if (tc->clientdata) ti->clientdata = tc->clientdata;
      head = tc;
      next = tc->next;
      goto l1;
    }
    tc = tc->prev;
  }
  head = ti;
  next = 0;

  /* Place in list */
  ti->prev = *swig_type_list_handle;
  *swig_type_list_handle = ti;

  /* Build linked lists */
  l1:
  ret = head;
  tc = ti + 1;
  /* Patch up the rest of the links */
  while (tc->name) {
    head->next = tc;
    tc->prev = head;
    head = tc;
    tc++;
  }
  if (next) next->prev = head;
  head->next = next;
  return ret;
}

/* Check the typename */
SWIGRUNTIME(swig_type_info *) 
SWIG_TypeCheck(char *c, swig_type_info *ty) {
  swig_type_info *s;
  if (!ty) return 0;        /* Void pointer */
  s = ty->next;             /* First element always just a name */
  do {
    if (strcmp(s->name,c) == 0) {
      if (s == ty->next) return s;
      /* Move s to the top of the linked list */
      s->prev->next = s->next;
      if (s->next) {
        s->next->prev = s->prev;
      }
      /* Insert s as second element in the list */
      s->next = ty->next;
      if (ty->next) ty->next->prev = s;
      ty->next = s;
      s->prev = ty;
      return s;
    }
    s = s->next;
  } while (s && (s != ty->next));
  return 0;
}

/* Cast a pointer up an inheritance hierarchy */
SWIGRUNTIME(void *) 
SWIG_TypeCast(swig_type_info *ty, void *ptr) {
  if ((!ty) || (!ty->converter)) return ptr;
  return (*ty->converter)(ptr);
}

/* Dynamic pointer casting. Down an inheritance hierarchy */
SWIGRUNTIME(swig_type_info *) 
SWIG_TypeDynamicCast(swig_type_info *ty, void **ptr) {
  swig_type_info *lastty = ty;
  if (!ty || !ty->dcast) return ty;
  while (ty && (ty->dcast)) {
    ty = (*ty->dcast)(ptr);
    if (ty) lastty = ty;
  }
  return lastty;
}

/* Return the name associated with this type */
SWIGRUNTIME(const char *)
SWIG_TypeName(const swig_type_info *ty) {
  return ty->name;
}

/* Return the pretty name associated with this type,
   that is an unmangled type name in a form presentable to the user.
*/
SWIGRUNTIME(const char *)
SWIG_TypePrettyName(const swig_type_info *type) {
  /* The "str" field contains the equivalent pretty names of the
     type, separated by vertical-bar characters.  We choose
     to print the last name, as it is often (?) the most
     specific. */
  if (type->str != NULL) {
    const char *last_name = type->str;
    const char *s;
    for (s = type->str; *s; s++)
      if (*s == '|') last_name = s+1;
    return last_name;
  }
  else
    return type->name;
}

/* 
   Compare two type names skipping the space characters, therefore
   "char*" == "char *" and "Class<int>" == "Class<int >", etc.

   Return 0 when the two name types are equivalent, as in
   strncmp, but skipping ' '.
*/
static int
SWIG_TypeNameComp(const char *f1, const char *l1,
		  const char *f2, const char *l2) {
  for (;(f1 != l1) && (f2 != l2); ++f1, ++f2) {
    while ((*f1 == ' ') && (f1 != l1)) ++f1;
    while ((*f2 == ' ') && (f2 != l2)) ++f2;
    if (*f1 != *f2) return *f1 - *f2;
  }
  return (l1 - f1) - (l2 - f2);
}

/*
  Check type equivalence in a name list like <name1>|<name2>|...
*/
static int
SWIG_TypeEquiv(const char *nb, const char *tb) {
  int equiv = 0;
  const char* te = tb + strlen(tb);
  const char* ne = nb;
  while (!equiv && *ne) {
    for (nb = ne; *ne; ++ne) {
      if (*ne == '|') break;
    }
    equiv = SWIG_TypeNameComp(nb, ne, tb, te) == 0;
    if (*ne) ++ne;
  }
  return equiv;
}
  

/* Search for a swig_type_info structure */
SWIGRUNTIME(swig_type_info *)
SWIG_TypeQuery(const char *name) {
  swig_type_info *ty = *swig_type_list_handle;
  while (ty) {
    if (ty->str && (SWIG_TypeEquiv(ty->str,name))) return ty;
    if (ty->name && (strcmp(name,ty->name) == 0)) return ty;
    ty = ty->prev;
  }
  return 0;
}

/* Set the clientdata field for a type */
SWIGRUNTIME(void)
SWIG_TypeClientData(swig_type_info *ti, void *clientdata) {
  swig_type_info *tc, *equiv;
  if (ti->clientdata == clientdata) return;
  ti->clientdata = clientdata;
  equiv = ti->next;
  while (equiv) {
    if (!equiv->converter) {
      tc = *swig_type_list_handle;
      while (tc) {
        if ((strcmp(tc->name, equiv->name) == 0))
          SWIG_TypeClientData(tc,clientdata);
        tc = tc->prev;
      }
    }
    equiv = equiv->next;
  }
}

/* Pack binary data into a string */
SWIGRUNTIME(char *)
SWIG_PackData(char *c, void *ptr, int sz) {
  static char hex[17] = "0123456789abcdef";
  unsigned char *u = (unsigned char *) ptr;
  const unsigned char *eu =  u + sz;
  register unsigned char uu;
  for (; u != eu; ++u) {
    uu = *u;
    *(c++) = hex[(uu & 0xf0) >> 4];
    *(c++) = hex[uu & 0xf];
  }
  return c;
}

/* Unpack binary data from a string */
SWIGRUNTIME(char *)
SWIG_UnpackData(char *c, void *ptr, int sz) {
  register unsigned char uu = 0;
  register int d;
  unsigned char *u = (unsigned char *) ptr;
  const unsigned char *eu =  u + sz;
  for (; u != eu; ++u) {
    d = *(c++);
    if ((d >= '0') && (d <= '9'))
      uu = ((d - '0') << 4);
    else if ((d >= 'a') && (d <= 'f'))
      uu = ((d - ('a'-10)) << 4);
    d = *(c++);
    if ((d >= '0') && (d <= '9'))
      uu |= (d - '0');
    else if ((d >= 'a') && (d <= 'f'))
      uu |= (d - ('a'-10));
    *u = uu;
  }
  return c;
}

#endif

#ifdef __cplusplus
}
#endif

/* rubydec.swg -*- c -*- */
#ifdef __cplusplus
extern "C" {
#endif

SWIGIMPORT(void)   SWIG_Ruby_InitRuntime(void);
SWIGIMPORT(void)   SWIG_Ruby_define_class(swig_type_info *);
SWIGIMPORT(VALUE)  SWIG_Ruby_NewPointerObj(void *, swig_type_info *, int);
SWIGIMPORT(VALUE)  SWIG_Ruby_NewClassInstance(VALUE, swig_type_info *);
SWIGIMPORT(char *) SWIG_Ruby_MangleStr(VALUE);
SWIGIMPORT(int)    SWIG_Ruby_ConvertPtr(VALUE, void**, swig_type_info *, int);
SWIGIMPORT(void *) SWIG_Ruby_MustGetPtr(VALUE, swig_type_info *, int, int);
SWIGIMPORT(int)    SWIG_Ruby_CheckConvert(VALUE, swig_type_info *);
SWIGIMPORT(VALUE)  SWIG_Ruby_NewPackedObj(void *ptr, int sz, swig_type_info *type);
SWIGIMPORT(void)   SWIG_Ruby_ConvertPacked(VALUE obj, void *ptr, int sz, swig_type_info *ty, int flags);

#ifdef __cplusplus
}
#endif


/* -------- TYPES TABLE (BEGIN) -------- */

#define  SWIGTYPE_p_FXToolBar swig_types[0] 
#define  SWIGTYPE_p_FXObject swig_types[1] 
#define  SWIGTYPE_p_FXPopup swig_types[2] 
#define  SWIGTYPE_p_FXMenuCaption swig_types[3] 
#define  SWIGTYPE_p_FXScrollPane swig_types[4] 
#define  SWIGTYPE_p_FXWindow swig_types[5] 
#define  SWIGTYPE_p_FXComposite swig_types[6] 
#define  SWIGTYPE_p_FXId swig_types[7] 
#define  SWIGTYPE_p_FXFont swig_types[8] 
#define  SWIGTYPE_p_FXShell swig_types[9] 
#define  SWIGTYPE_p_FXMenuTitle swig_types[10] 
#define  SWIGTYPE_p_FXMenuSeparator swig_types[11] 
#define  SWIGTYPE_p_FXMenuRadio swig_types[12] 
#define  SWIGTYPE_p_FXStream swig_types[13] 
#define  SWIGTYPE_p_FXDrawable swig_types[14] 
#define  SWIGTYPE_p_FXPacker swig_types[15] 
#define  SWIGTYPE_p_FXIcon swig_types[16] 
#define  SWIGTYPE_p_FXMenuCascade swig_types[17] 
#define  SWIGTYPE_p_FXMenuCheck swig_types[18] 
#define  SWIGTYPE_p_FXMenuCommand swig_types[19] 
#define  SWIGTYPE_p_FXMenuBar swig_types[20] 
#define  SWIGTYPE_p_FXMenuPane swig_types[21] 
static swig_type_info *swig_types[23];

/* -------- TYPES TABLE (END) -------- */

#define SWIG_init    Init_menu
#define SWIG_name    "Menu"


static void SWIG_AsVal(VALUE obj, int *val)
{
    *val = (int) NUM2INT(obj);
}


#include "FXRbCommon.h"


inline FXColor to_FXColor(VALUE obj){
  if(TYPE(obj)==T_STRING){
    return fxcolorfromname(StringValuePtr(obj));
    }
  else if(TYPE(obj)==T_SYMBOL){
    return fxcolorfromname(rb_id2name(SYM2ID(obj)));
    }
  else{
    return NUM2ULONG(obj);
    }
  }


inline FXString to_FXString(VALUE obj){
  if(!NIL_P(obj)){
    Check_Type(obj,T_STRING);
    return FXString(STR2CSTR(obj));
    }
  else{
    return FXString::null;
    }
  }


inline FXbool to_FXbool(VALUE obj){
  if (obj == Qtrue || obj == Qfalse){
    return (obj == Qtrue) ? TRUE : FALSE;
    }
  else{
    return static_cast<FXbool>(NUM2UINT(obj));
    }
  }


static swig_type_info* FXEventTypeInfo=0;

inline void* to_FXEvent(VALUE obj){
  void* ptr;
  if(!FXEventTypeInfo){
    FXEventTypeInfo=SWIG_TypeQuery("FXEvent *");
    FXASSERT(FXEventTypeInfo!=0);
    }
  SWIG_ConvertPtr(obj,&ptr,FXEventTypeInfo,1);
  return ptr;
  }

FXMenuPane *new_FXMenuPane(FXWindow *owner,FXuint opts){
      return new FXRbMenuPane(owner,opts);
      }

swig_class cFXMenuPane;
static void free_FXMenuPane(FXMenuPane *);

static swig_type_info *FXMenuPane_dynamic_cast(void **ptr) {
    FXMenuPane **ppMenuPane = reinterpret_cast<FXMenuPane **>(ptr);
    FXMDIMenu *pMDIMenu=dynamic_cast<FXMDIMenu*>(*ppMenuPane);
    if(pMDIMenu){
      *ptr=reinterpret_cast<void*>(pMDIMenu);
      return SWIG_TypeQuery("FXMDIMenu *");
      }
    return 0;
}

FXScrollPane *new_FXScrollPane(FXWindow *owner,FXint nvis,FXuint opts){
      return new FXRbScrollPane(owner,nvis,opts);
      }

swig_class cFXScrollPane;
static void free_FXScrollPane(FXScrollPane *);
FXMenuCaption *new_FXMenuCaption(FXComposite *p,FXString const &text,FXIcon *ic,FXuint opts){
      return new FXRbMenuCaption(p,text,ic,opts);
      }

swig_class cFXMenuCaption;
static void free_FXMenuCaption(FXMenuCaption *);

static swig_type_info *FXMenuCaption_dynamic_cast(void **ptr) {
    FXMenuCaption **ppMenuCaption = reinterpret_cast<FXMenuCaption **>(ptr);
    FXMenuCascade *pMenuCascade=dynamic_cast<FXMenuCascade*>(*ppMenuCaption);
    if(pMenuCascade){
      *ptr=reinterpret_cast<void*>(pMenuCascade);
      return SWIG_TypeQuery("FXMenuCascade *");
      }
    FXMenuCommand *pMenuCommand=dynamic_cast<FXMenuCommand*>(*ppMenuCaption);
    if(pMenuCommand){
      *ptr=reinterpret_cast<void*>(pMenuCommand);
      return SWIG_TypeQuery("FXMenuCommand *");
      }
    FXMenuTitle *pMenuTitle=dynamic_cast<FXMenuTitle*>(*ppMenuCaption);
    if(pMenuTitle){
      *ptr=reinterpret_cast<void*>(pMenuTitle);
      return SWIG_TypeQuery("FXMenuTitle *");
      }
    return 0;
}

FXMenuSeparator *new_FXMenuSeparator(FXComposite *p,FXuint opts){
      return new FXRbMenuSeparator(p,opts);
      }

swig_class cFXMenuSeparator;
static void free_FXMenuSeparator(FXMenuSeparator *);
FXMenuTitle *new_FXMenuTitle(FXComposite *p,FXString const &text,FXIcon *ic,FXPopup *pup,FXuint opts){
      return new FXRbMenuTitle(p,text,ic,pup,opts);
      }

swig_class cFXMenuTitle;
static void free_FXMenuTitle(FXMenuTitle *);
FXMenuCascade *new_FXMenuCascade(FXComposite *p,FXString const &text,FXIcon *ic,FXPopup *pup,FXuint opts){
      return new FXRbMenuCascade(p,text,ic,pup,opts);
      }

swig_class cFXMenuCascade;
static void free_FXMenuCascade(FXMenuCascade *);
FXMenuCommand *new_FXMenuCommand(FXComposite *p,FXString const &text,FXIcon *ic,FXObject *tgt,FXSelector sel,FXuint opts){
      return new FXRbMenuCommand(p,text,ic,tgt,sel,opts);
      }

swig_class cFXMenuCommand;
static void free_FXMenuCommand(FXMenuCommand *);
FXMenuBar *new_FXMenuBar__SWIG_0(FXComposite *p,FXComposite *q,FXuint opts,FXint x,FXint y,FXint w,FXint h,FXint pl,FXint pr,FXint pt,FXint pb,FXint hs,FXint vs){
      return new FXRbMenuBar(p,q,opts,x,y,w,h,pl,pr,pt,pb,hs,vs);
      }
FXMenuBar *new_FXMenuBar__SWIG_1(FXComposite *p,FXuint opts,FXint x,FXint y,FXint w,FXint h,FXint pl,FXint pr,FXint pt,FXint pb,FXint hs,FXint vs){
      return new FXRbMenuBar(p,opts,x,y,w,h,pl,pr,pt,pb,hs,vs);
      }

swig_class cFXMenuBar;
static void free_FXMenuBar(FXMenuBar *);
FXMenuCheck *new_FXMenuCheck(FXComposite *p,FXString const &text,FXObject *tgt,FXSelector sel,FXuint opts){
      return new FXRbMenuCheck(p,text,tgt,sel,opts);
      }

swig_class cFXMenuCheck;
static void free_FXMenuCheck(FXMenuCheck *);
FXMenuRadio *new_FXMenuRadio(FXComposite *p,FXString const &text,FXObject *tgt,FXSelector sel,FXuint opts){
      return new FXRbMenuRadio(p,text,tgt,sel,opts);
      }

swig_class cFXMenuRadio;
static void free_FXMenuRadio(FXMenuRadio *);
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE _wrap_FXMenuPane_allocate(VALUE self) {
#else
     static VALUE _wrap_FXMenuPane_allocate(int argc, VALUE *argv, VALUE self) {
#endif
         VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_FXMenuPane);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
         return vresult; }
static VALUE _wrap_new_FXMenuPane(int argc, VALUE *argv, VALUE self) { FXWindow *arg1 = (FXWindow *) 0 ;
    FXuint arg2 = (FXuint) 0 ; FXMenuPane *result; if ((argc < 1) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXWindow, 1); if (argc > 1) { arg2 = NUM2UINT(argv[1]); }  {
        result = (FXMenuPane *)new_FXMenuPane(arg1,arg2); DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result);
        if(rb_block_given_p()){ rb_yield(self); }  }  return self; }
static void
free_FXMenuPane(FXMenuPane *arg1) {
    delete arg1;
}
static VALUE _wrap_FXMenuPane_save(int argc, VALUE *argv, VALUE self) { FXMenuPane *arg1 = (FXMenuPane *) 0 ;
    FXStream *arg2 = 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuPane, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXMenuPane_save((FXMenuPane const *)arg1,*arg2); return Qnil; }
static VALUE _wrap_FXMenuPane_load(int argc, VALUE *argv, VALUE self) { FXMenuPane *arg1 = (FXMenuPane *) 0 ;
    FXStream *arg2 = 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuPane, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXMenuPane_load(arg1,*arg2); return Qnil; }
static VALUE _wrap_FXMenuPane_create(int argc, VALUE *argv, VALUE self) { FXMenuPane *arg1 = (FXMenuPane *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuPane, 1); FXMenuPane_create(arg1); return Qnil; }
static VALUE _wrap_FXMenuPane_detach(int argc, VALUE *argv, VALUE self) { FXMenuPane *arg1 = (FXMenuPane *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuPane, 1); FXMenuPane_detach(arg1); return Qnil; }
static VALUE _wrap_FXMenuPane_destroy(int argc, VALUE *argv, VALUE self) { FXMenuPane *arg1 = (FXMenuPane *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuPane, 1); FXMenuPane_destroy(arg1); return Qnil; }
static VALUE _wrap_FXMenuPane_resize(int argc, VALUE *argv, VALUE self) { FXMenuPane *arg1 = (FXMenuPane *) 0 ; FXint arg2 ;
    FXint arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuPane, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    FXMenuPane_resize(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXMenuPane_getDefaultWidth(int argc, VALUE *argv, VALUE self) { FXMenuPane *arg1 = (FXMenuPane *) 0 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuPane, 1); result = (FXint)FXMenuPane_getDefaultWidth(arg1);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXMenuPane_getDefaultHeight(int argc, VALUE *argv, VALUE self) { FXMenuPane *arg1 = (FXMenuPane *) 0 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuPane, 1); result = (FXint)FXMenuPane_getDefaultHeight(arg1);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXMenuPane_getWidthForHeight(int argc, VALUE *argv, VALUE self) { FXMenuPane *arg1 = (FXMenuPane *) 0 ;
    FXint arg2 ; FXint result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuPane, 1); arg2 = NUM2INT(argv[0]);
    result = (FXint)FXMenuPane_getWidthForHeight(arg1,arg2); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXMenuPane_getHeightForWidth(int argc, VALUE *argv, VALUE self) { FXMenuPane *arg1 = (FXMenuPane *) 0 ;
    FXint arg2 ; FXint result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuPane, 1); arg2 = NUM2INT(argv[0]);
    result = (FXint)FXMenuPane_getHeightForWidth(arg1,arg2); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXMenuPane_canFocus(int argc, VALUE *argv, VALUE self) { FXMenuPane *arg1 = (FXMenuPane *) 0 ; FXbool result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuPane, 1);
    result = (FXbool)FXMenuPane_canFocus((FXMenuPane const *)arg1); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXMenuPane_setFocus(int argc, VALUE *argv, VALUE self) { FXMenuPane *arg1 = (FXMenuPane *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuPane, 1); FXMenuPane_setFocus(arg1); return Qnil; }
static VALUE _wrap_FXMenuPane_killFocus(int argc, VALUE *argv, VALUE self) { FXMenuPane *arg1 = (FXMenuPane *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuPane, 1); FXMenuPane_killFocus(arg1); return Qnil; }
static VALUE _wrap_FXMenuPane_setDefault(int argc, VALUE *argv, VALUE self) { FXMenuPane *arg1 = (FXMenuPane *) 0 ;
    FXbool arg2 = (FXbool) 1 ; if ((argc < 0) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuPane, 1); if (argc > 0) { arg2 = to_FXbool(argv[0]); } 
    FXMenuPane_setDefault(arg1,arg2); return Qnil; }
static VALUE _wrap_FXMenuPane_enable(int argc, VALUE *argv, VALUE self) { FXMenuPane *arg1 = (FXMenuPane *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuPane, 1); FXMenuPane_enable(arg1); return Qnil; }
static VALUE _wrap_FXMenuPane_disable(int argc, VALUE *argv, VALUE self) { FXMenuPane *arg1 = (FXMenuPane *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuPane, 1); FXMenuPane_disable(arg1); return Qnil; }
static VALUE _wrap_FXMenuPane_raiseWindow(int argc, VALUE *argv, VALUE self) { FXMenuPane *arg1 = (FXMenuPane *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuPane, 1); FXMenuPane_raise(arg1); return Qnil; }
static VALUE _wrap_FXMenuPane_lower(int argc, VALUE *argv, VALUE self) { FXMenuPane *arg1 = (FXMenuPane *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuPane, 1); FXMenuPane_lower(arg1); return Qnil; }
static VALUE _wrap_FXMenuPane_move(int argc, VALUE *argv, VALUE self) { FXMenuPane *arg1 = (FXMenuPane *) 0 ; FXint arg2 ;
    FXint arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuPane, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    FXMenuPane_move(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXMenuPane_position(int argc, VALUE *argv, VALUE self) { FXMenuPane *arg1 = (FXMenuPane *) 0 ; FXint arg2 ;
    FXint arg3 ; FXint arg4 ; FXint arg5 ; if ((argc < 4) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuPane, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    arg4 = NUM2INT(argv[2]); arg5 = NUM2INT(argv[3]); FXMenuPane_position(arg1,arg2,arg3,arg4,arg5); return Qnil; }
static VALUE _wrap_FXMenuPane_layout(int argc, VALUE *argv, VALUE self) { FXMenuPane *arg1 = (FXMenuPane *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuPane, 1); FXMenuPane_layout(arg1); return Qnil; }
static VALUE _wrap_FXMenuPane_recalc(int argc, VALUE *argv, VALUE self) { FXMenuPane *arg1 = (FXMenuPane *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuPane, 1); FXMenuPane_recalc(arg1); return Qnil; }
static VALUE _wrap_FXMenuPane_reparent(int argc, VALUE *argv, VALUE self) { FXMenuPane *arg1 = (FXMenuPane *) 0 ;
    FXComposite *arg2 = (FXComposite *) 0 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuPane, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXComposite, 1); FXMenuPane_reparent(arg1,arg2); return Qnil; }
static VALUE _wrap_FXMenuPane_show(int argc, VALUE *argv, VALUE self) { FXMenuPane *arg1 = (FXMenuPane *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuPane, 1); FXMenuPane_show(arg1); return Qnil; }
static VALUE _wrap_FXMenuPane_hide(int argc, VALUE *argv, VALUE self) { FXMenuPane *arg1 = (FXMenuPane *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuPane, 1); FXMenuPane_hide(arg1); return Qnil; }
static VALUE _wrap_FXMenuPane_isComposite(int argc, VALUE *argv, VALUE self) { FXMenuPane *arg1 = (FXMenuPane *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuPane, 1);
    result = (FXbool)FXMenuPane_isComposite((FXMenuPane const *)arg1); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXMenuPane_contains(int argc, VALUE *argv, VALUE self) { FXMenuPane *arg1 = (FXMenuPane *) 0 ; FXint arg2 ;
    FXint arg3 ; FXbool result; VALUE vresult = Qnil; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuPane, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    result = (FXbool)FXMenuPane_contains((FXMenuPane const *)arg1,arg2,arg3); vresult = result ? Qtrue : Qfalse;
    return vresult; }
static VALUE _wrap_FXMenuPane_doesSaveUnder(int argc, VALUE *argv, VALUE self) { FXMenuPane *arg1 = (FXMenuPane *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuPane, 1);
    result = (FXbool)FXMenuPane_doesSaveUnder((FXMenuPane const *)arg1); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXMenuPane_setBackColor(int argc, VALUE *argv, VALUE self) { FXMenuPane *arg1 = (FXMenuPane *) 0 ;
    FXColor arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuPane, 1); arg2 = to_FXColor(argv[0]);
    FXMenuPane_setBackColor(arg1,arg2); return Qnil; }
static VALUE _wrap_FXMenuPane_popup(int argc, VALUE *argv, VALUE self) { FXMenuPane *arg1 = (FXMenuPane *) 0 ;
    FXWindow *arg2 = (FXWindow *) 0 ; FXint arg3 ; FXint arg4 ; FXint arg5 = (FXint) 0 ; FXint arg6 = (FXint) 0 ;
    if ((argc < 3) || (argc > 5)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuPane, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXWindow, 1); arg3 = NUM2INT(argv[1]); arg4 = NUM2INT(argv[2]);
    if (argc > 3) { arg5 = NUM2INT(argv[3]); }  if (argc > 4) { arg6 = NUM2INT(argv[4]); } 
    FXMenuPane_popup(arg1,arg2,arg3,arg4,arg5,arg6); return Qnil; }
static VALUE _wrap_FXMenuPane_popdown(int argc, VALUE *argv, VALUE self) { FXMenuPane *arg1 = (FXMenuPane *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuPane, 1); FXMenuPane_popdown(arg1); return Qnil; }
static VALUE _wrap_FXScrollPane_onUpdIncrement(int argc, VALUE *argv, VALUE self) { FXScrollPane *arg1 = (FXScrollPane *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScrollPane, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onUpdIncrement(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXScrollPane_onCmdIncrement(int argc, VALUE *argv, VALUE self) { FXScrollPane *arg1 = (FXScrollPane *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScrollPane, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdIncrement(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXScrollPane_onUpdDecrement(int argc, VALUE *argv, VALUE self) { FXScrollPane *arg1 = (FXScrollPane *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScrollPane, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onUpdDecrement(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXScrollPane_onCmdDecrement(int argc, VALUE *argv, VALUE self) { FXScrollPane *arg1 = (FXScrollPane *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScrollPane, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdDecrement(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE _wrap_FXScrollPane_allocate(VALUE self) {
#else
     static VALUE _wrap_FXScrollPane_allocate(int argc, VALUE *argv, VALUE self) {
#endif
         VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_FXScrollPane);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
         return vresult; }
static VALUE _wrap_new_FXScrollPane(int argc, VALUE *argv, VALUE self) { FXWindow *arg1 = (FXWindow *) 0 ; FXint arg2 ;
    FXuint arg3 = (FXuint) 0 ; FXScrollPane *result; if ((argc < 2) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXWindow, 1); arg2 = NUM2INT(argv[1]); if (argc > 2) {
        arg3 = NUM2UINT(argv[2]); }  { result = (FXScrollPane *)new_FXScrollPane(arg1,arg2,arg3);
        DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result); if(rb_block_given_p()){ rb_yield(self); }  }  return self; }
static VALUE _wrap_FXScrollPane_getTopItem(int argc, VALUE *argv, VALUE self) { FXScrollPane *arg1 = (FXScrollPane *) 0 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScrollPane, 1);
    result = (FXint)((FXScrollPane const *)arg1)->getTopItem(); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXScrollPane_setTopItem(int argc, VALUE *argv, VALUE self) { FXScrollPane *arg1 = (FXScrollPane *) 0 ;
    FXint arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScrollPane, 1); arg2 = NUM2INT(argv[0]); (arg1)->setTopItem(arg2);
    return Qnil; }
static void
free_FXScrollPane(FXScrollPane *arg1) {
    delete arg1;
}
static VALUE _wrap_FXScrollPane_save(int argc, VALUE *argv, VALUE self) { FXScrollPane *arg1 = (FXScrollPane *) 0 ;
    FXStream *arg2 = 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScrollPane, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXScrollPane_save((FXScrollPane const *)arg1,*arg2); return Qnil; }
static VALUE _wrap_FXScrollPane_load(int argc, VALUE *argv, VALUE self) { FXScrollPane *arg1 = (FXScrollPane *) 0 ;
    FXStream *arg2 = 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScrollPane, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXScrollPane_load(arg1,*arg2); return Qnil; }
static VALUE _wrap_FXScrollPane_create(int argc, VALUE *argv, VALUE self) { FXScrollPane *arg1 = (FXScrollPane *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScrollPane, 1); FXScrollPane_create(arg1); return Qnil; }
static VALUE _wrap_FXScrollPane_detach(int argc, VALUE *argv, VALUE self) { FXScrollPane *arg1 = (FXScrollPane *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScrollPane, 1); FXScrollPane_detach(arg1); return Qnil; }
static VALUE _wrap_FXScrollPane_destroy(int argc, VALUE *argv, VALUE self) { FXScrollPane *arg1 = (FXScrollPane *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScrollPane, 1); FXScrollPane_destroy(arg1); return Qnil; }
static VALUE _wrap_FXScrollPane_resize(int argc, VALUE *argv, VALUE self) { FXScrollPane *arg1 = (FXScrollPane *) 0 ;
    FXint arg2 ; FXint arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScrollPane, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    FXScrollPane_resize(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXScrollPane_getDefaultWidth(int argc, VALUE *argv, VALUE self) { FXScrollPane *arg1 = (FXScrollPane *) 0 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScrollPane, 1); result = (FXint)FXScrollPane_getDefaultWidth(arg1);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXScrollPane_getDefaultHeight(int argc, VALUE *argv, VALUE self) { FXScrollPane *arg1 = (FXScrollPane *) 0 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScrollPane, 1); result = (FXint)FXScrollPane_getDefaultHeight(arg1);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXScrollPane_getWidthForHeight(int argc, VALUE *argv, VALUE self) { FXScrollPane *arg1 = (FXScrollPane *) 0 ;
    FXint arg2 ; FXint result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScrollPane, 1); arg2 = NUM2INT(argv[0]);
    result = (FXint)FXScrollPane_getWidthForHeight(arg1,arg2); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXScrollPane_getHeightForWidth(int argc, VALUE *argv, VALUE self) { FXScrollPane *arg1 = (FXScrollPane *) 0 ;
    FXint arg2 ; FXint result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScrollPane, 1); arg2 = NUM2INT(argv[0]);
    result = (FXint)FXScrollPane_getHeightForWidth(arg1,arg2); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXScrollPane_canFocus(int argc, VALUE *argv, VALUE self) { FXScrollPane *arg1 = (FXScrollPane *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScrollPane, 1);
    result = (FXbool)FXScrollPane_canFocus((FXScrollPane const *)arg1); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXScrollPane_setFocus(int argc, VALUE *argv, VALUE self) { FXScrollPane *arg1 = (FXScrollPane *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScrollPane, 1); FXScrollPane_setFocus(arg1); return Qnil; }
static VALUE _wrap_FXScrollPane_killFocus(int argc, VALUE *argv, VALUE self) { FXScrollPane *arg1 = (FXScrollPane *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScrollPane, 1); FXScrollPane_killFocus(arg1); return Qnil; }
static VALUE _wrap_FXScrollPane_setDefault(int argc, VALUE *argv, VALUE self) { FXScrollPane *arg1 = (FXScrollPane *) 0 ;
    FXbool arg2 = (FXbool) 1 ; if ((argc < 0) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScrollPane, 1); if (argc > 0) { arg2 = to_FXbool(argv[0]); } 
    FXScrollPane_setDefault(arg1,arg2); return Qnil; }
static VALUE _wrap_FXScrollPane_enable(int argc, VALUE *argv, VALUE self) { FXScrollPane *arg1 = (FXScrollPane *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScrollPane, 1); FXScrollPane_enable(arg1); return Qnil; }
static VALUE _wrap_FXScrollPane_disable(int argc, VALUE *argv, VALUE self) { FXScrollPane *arg1 = (FXScrollPane *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScrollPane, 1); FXScrollPane_disable(arg1); return Qnil; }
static VALUE _wrap_FXScrollPane_raiseWindow(int argc, VALUE *argv, VALUE self) { FXScrollPane *arg1 = (FXScrollPane *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScrollPane, 1); FXScrollPane_raise(arg1); return Qnil; }
static VALUE _wrap_FXScrollPane_lower(int argc, VALUE *argv, VALUE self) { FXScrollPane *arg1 = (FXScrollPane *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScrollPane, 1); FXScrollPane_lower(arg1); return Qnil; }
static VALUE _wrap_FXScrollPane_move(int argc, VALUE *argv, VALUE self) { FXScrollPane *arg1 = (FXScrollPane *) 0 ; FXint arg2 ;
    FXint arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScrollPane, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    FXScrollPane_move(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXScrollPane_position(int argc, VALUE *argv, VALUE self) { FXScrollPane *arg1 = (FXScrollPane *) 0 ;
    FXint arg2 ; FXint arg3 ; FXint arg4 ; FXint arg5 ; if ((argc < 4) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScrollPane, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    arg4 = NUM2INT(argv[2]); arg5 = NUM2INT(argv[3]); FXScrollPane_position(arg1,arg2,arg3,arg4,arg5); return Qnil; }
static VALUE _wrap_FXScrollPane_layout(int argc, VALUE *argv, VALUE self) { FXScrollPane *arg1 = (FXScrollPane *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScrollPane, 1); FXScrollPane_layout(arg1); return Qnil; }
static VALUE _wrap_FXScrollPane_recalc(int argc, VALUE *argv, VALUE self) { FXScrollPane *arg1 = (FXScrollPane *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScrollPane, 1); FXScrollPane_recalc(arg1); return Qnil; }
static VALUE _wrap_FXScrollPane_reparent(int argc, VALUE *argv, VALUE self) { FXScrollPane *arg1 = (FXScrollPane *) 0 ;
    FXComposite *arg2 = (FXComposite *) 0 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScrollPane, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXComposite, 1); FXScrollPane_reparent(arg1,arg2); return Qnil; }
static VALUE _wrap_FXScrollPane_show(int argc, VALUE *argv, VALUE self) { FXScrollPane *arg1 = (FXScrollPane *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScrollPane, 1); FXScrollPane_show(arg1); return Qnil; }
static VALUE _wrap_FXScrollPane_hide(int argc, VALUE *argv, VALUE self) { FXScrollPane *arg1 = (FXScrollPane *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScrollPane, 1); FXScrollPane_hide(arg1); return Qnil; }
static VALUE _wrap_FXScrollPane_isComposite(int argc, VALUE *argv, VALUE self) { FXScrollPane *arg1 = (FXScrollPane *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScrollPane, 1);
    result = (FXbool)FXScrollPane_isComposite((FXScrollPane const *)arg1); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXScrollPane_contains(int argc, VALUE *argv, VALUE self) { FXScrollPane *arg1 = (FXScrollPane *) 0 ;
    FXint arg2 ; FXint arg3 ; FXbool result; VALUE vresult = Qnil; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScrollPane, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    result = (FXbool)FXScrollPane_contains((FXScrollPane const *)arg1,arg2,arg3); vresult = result ? Qtrue : Qfalse;
    return vresult; }
static VALUE _wrap_FXScrollPane_doesSaveUnder(int argc, VALUE *argv, VALUE self) { FXScrollPane *arg1 = (FXScrollPane *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScrollPane, 1);
    result = (FXbool)FXScrollPane_doesSaveUnder((FXScrollPane const *)arg1); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXScrollPane_setBackColor(int argc, VALUE *argv, VALUE self) { FXScrollPane *arg1 = (FXScrollPane *) 0 ;
    FXColor arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScrollPane, 1); arg2 = to_FXColor(argv[0]);
    FXScrollPane_setBackColor(arg1,arg2); return Qnil; }
static VALUE _wrap_FXScrollPane_popup(int argc, VALUE *argv, VALUE self) { FXScrollPane *arg1 = (FXScrollPane *) 0 ;
    FXWindow *arg2 = (FXWindow *) 0 ; FXint arg3 ; FXint arg4 ; FXint arg5 = (FXint) 0 ; FXint arg6 = (FXint) 0 ;
    if ((argc < 3) || (argc > 5)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScrollPane, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXWindow, 1); arg3 = NUM2INT(argv[1]); arg4 = NUM2INT(argv[2]);
    if (argc > 3) { arg5 = NUM2INT(argv[3]); }  if (argc > 4) { arg6 = NUM2INT(argv[4]); } 
    FXScrollPane_popup(arg1,arg2,arg3,arg4,arg5,arg6); return Qnil; }
static VALUE _wrap_FXScrollPane_popdown(int argc, VALUE *argv, VALUE self) { FXScrollPane *arg1 = (FXScrollPane *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXScrollPane, 1); FXScrollPane_popdown(arg1); return Qnil; }
static VALUE _wrap_FXMenuCaption_onPaint(int argc, VALUE *argv, VALUE self) { FXMenuCaption *arg1 = (FXMenuCaption *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuCaption, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onPaint(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXMenuCaption_onUpdate(int argc, VALUE *argv, VALUE self) { FXMenuCaption *arg1 = (FXMenuCaption *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuCaption, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onUpdate(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXMenuCaption_onCmdSetStringValue(int argc, VALUE *argv, VALUE self) {
    FXMenuCaption *arg1 = (FXMenuCaption *) 0 ; FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ;
    long result; FXString value4 ; VALUE vresult = Qnil; if ((argc < 3) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuCaption, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); {
        value4 = FXString(STR2CSTR(argv[2])); arg4 = (void *) &value4; } 
    result = (long)(arg1)->onCmdSetStringValue(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXMenuCaption_onCmdGetStringValue(int argc, VALUE *argv, VALUE self) {
    FXMenuCaption *arg1 = (FXMenuCaption *) 0 ; FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ;
    long result; VALUE vresult = Qnil; if ((argc < 3) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuCaption, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdGetStringValue(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXMenuCaption_onCmdSetIconValue(int argc, VALUE *argv, VALUE self) {
    FXMenuCaption *arg1 = (FXMenuCaption *) 0 ; FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ;
    long result; void *tmp4 ; VALUE vresult = Qnil; if ((argc < 3) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuCaption, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); {
        tmp4 = FXRbConvertPtr(argv[2], FXRbTypeQuery("FXIcon *")); arg4 = (void *) &tmp4; } 
    result = (long)(arg1)->onCmdSetIconValue(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXMenuCaption_onCmdGetIconValue(int argc, VALUE *argv, VALUE self) {
    FXMenuCaption *arg1 = (FXMenuCaption *) 0 ; FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ;
    long result; VALUE vresult = Qnil; if ((argc < 3) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuCaption, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdGetIconValue(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXMenuCaption_onCmdSetHelp(int argc, VALUE *argv, VALUE self) { FXMenuCaption *arg1 = (FXMenuCaption *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; FXString value4 ;
    VALUE vresult = Qnil; if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuCaption, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); {
        value4 = FXString(STR2CSTR(argv[2])); arg4 = (void *) &value4; }  result = (long)(arg1)->onCmdSetHelp(arg2,arg3,arg4);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXMenuCaption_onCmdGetHelp(int argc, VALUE *argv, VALUE self) { FXMenuCaption *arg1 = (FXMenuCaption *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuCaption, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdGetHelp(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXMenuCaption_onQueryHelp(int argc, VALUE *argv, VALUE self) { FXMenuCaption *arg1 = (FXMenuCaption *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuCaption, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onQueryHelp(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE _wrap_FXMenuCaption_allocate(VALUE self) {
#else
     static VALUE _wrap_FXMenuCaption_allocate(int argc, VALUE *argv, VALUE self) {
#endif
         VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_FXMenuCaption);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
         return vresult; }
static VALUE _wrap_new_FXMenuCaption(int argc, VALUE *argv, VALUE self) { FXComposite *arg1 = (FXComposite *) 0 ;
    FXString *arg2 = 0 ; FXIcon *arg3 = (FXIcon *) 0 ; FXuint arg4 = (FXuint) 0 ; FXMenuCaption *result;
    SwigValueWrapper<FXString > p2 ; if ((argc < 2) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXComposite, 1); p2 = to_FXString(argv[1]); arg2 = &p2; if (argc > 2) {
        SWIG_ConvertPtr(argv[2], (void **) &arg3, SWIGTYPE_p_FXIcon, 1); }  if (argc > 3) { arg4 = NUM2UINT(argv[3]); }  {
        result = (FXMenuCaption *)new_FXMenuCaption(arg1,(FXString const &)*arg2,arg3,arg4);
        DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result); if(rb_block_given_p()){ rb_yield(self); }  }  return self; }
static VALUE _wrap_FXMenuCaption_setText(int argc, VALUE *argv, VALUE self) { FXMenuCaption *arg1 = (FXMenuCaption *) 0 ;
    FXString *arg2 = 0 ; SwigValueWrapper<FXString > p2 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuCaption, 1); p2 = to_FXString(argv[0]); arg2 = &p2;
    (arg1)->setText((FXString const &)*arg2); return Qnil; }
static VALUE _wrap_FXMenuCaption_getText(int argc, VALUE *argv, VALUE self) { FXMenuCaption *arg1 = (FXMenuCaption *) 0 ;
    FXString result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuCaption, 1); result = ((FXMenuCaption const *)arg1)->getText();
    vresult = rb_str_new2((&result)->text()); return vresult; }
static VALUE _wrap_FXMenuCaption_setIcon(int argc, VALUE *argv, VALUE self) { FXMenuCaption *arg1 = (FXMenuCaption *) 0 ;
    FXIcon *arg2 = (FXIcon *) 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuCaption, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXIcon, 1); (arg1)->setIcon(arg2); return Qnil; }
static VALUE _wrap_FXMenuCaption_getIcon(int argc, VALUE *argv, VALUE self) { FXMenuCaption *arg1 = (FXMenuCaption *) 0 ;
    FXIcon *result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuCaption, 1);
    result = (FXIcon *)((FXMenuCaption const *)arg1)->getIcon(); {
        swig_type_info *ty = SWIG_TypeDynamicCast(SWIGTYPE_p_FXIcon, (void **) &result); vresult = FXRbGetRubyObj(result, ty); }
     return vresult; }
static VALUE _wrap_FXMenuCaption_setFont(int argc, VALUE *argv, VALUE self) { FXMenuCaption *arg1 = (FXMenuCaption *) 0 ;
    FXFont *arg2 = (FXFont *) 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuCaption, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXFont, 1); (arg1)->setFont(arg2); return Qnil; }
static VALUE _wrap_FXMenuCaption_getFont(int argc, VALUE *argv, VALUE self) { FXMenuCaption *arg1 = (FXMenuCaption *) 0 ;
    FXFont *result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuCaption, 1);
    result = (FXFont *)((FXMenuCaption const *)arg1)->getFont(); {
        swig_type_info *ty = SWIG_TypeDynamicCast(SWIGTYPE_p_FXFont, (void **) &result); vresult = FXRbGetRubyObj(result, ty); }
     return vresult; }
static VALUE _wrap_FXMenuCaption_setMenuStyle(int argc, VALUE *argv, VALUE self) { FXMenuCaption *arg1 = (FXMenuCaption *) 0 ;
    FXuint arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuCaption, 1); arg2 = NUM2UINT(argv[0]); (arg1)->setMenuStyle(arg2);
    return Qnil; }
static VALUE _wrap_FXMenuCaption_getMenuStyle(int argc, VALUE *argv, VALUE self) { FXMenuCaption *arg1 = (FXMenuCaption *) 0 ;
    FXuint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuCaption, 1);
    result = (FXuint)((FXMenuCaption const *)arg1)->getMenuStyle(); vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXMenuCaption_getTextColor(int argc, VALUE *argv, VALUE self) { FXMenuCaption *arg1 = (FXMenuCaption *) 0 ;
    FXColor result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuCaption, 1);
    result = (FXColor)((FXMenuCaption const *)arg1)->getTextColor(); vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXMenuCaption_setTextColor(int argc, VALUE *argv, VALUE self) { FXMenuCaption *arg1 = (FXMenuCaption *) 0 ;
    FXColor arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuCaption, 1); arg2 = to_FXColor(argv[0]); (arg1)->setTextColor(arg2);
    return Qnil; }
static VALUE _wrap_FXMenuCaption_getSelBackColor(int argc, VALUE *argv, VALUE self) {
    FXMenuCaption *arg1 = (FXMenuCaption *) 0 ; FXColor result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuCaption, 1);
    result = (FXColor)((FXMenuCaption const *)arg1)->getSelBackColor(); vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXMenuCaption_setSelBackColor(int argc, VALUE *argv, VALUE self) {
    FXMenuCaption *arg1 = (FXMenuCaption *) 0 ; FXColor arg2 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuCaption, 1); arg2 = to_FXColor(argv[0]);
    (arg1)->setSelBackColor(arg2); return Qnil; }
static VALUE _wrap_FXMenuCaption_getSelTextColor(int argc, VALUE *argv, VALUE self) {
    FXMenuCaption *arg1 = (FXMenuCaption *) 0 ; FXColor result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuCaption, 1);
    result = (FXColor)((FXMenuCaption const *)arg1)->getSelTextColor(); vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXMenuCaption_setSelTextColor(int argc, VALUE *argv, VALUE self) {
    FXMenuCaption *arg1 = (FXMenuCaption *) 0 ; FXColor arg2 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuCaption, 1); arg2 = to_FXColor(argv[0]);
    (arg1)->setSelTextColor(arg2); return Qnil; }
static VALUE _wrap_FXMenuCaption_setHiliteColor(int argc, VALUE *argv, VALUE self) { FXMenuCaption *arg1 = (FXMenuCaption *) 0 ;
    FXColor arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuCaption, 1); arg2 = to_FXColor(argv[0]);
    (arg1)->setHiliteColor(arg2); return Qnil; }
static VALUE _wrap_FXMenuCaption_getHiliteColor(int argc, VALUE *argv, VALUE self) { FXMenuCaption *arg1 = (FXMenuCaption *) 0 ;
    FXColor result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuCaption, 1);
    result = (FXColor)((FXMenuCaption const *)arg1)->getHiliteColor(); vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXMenuCaption_setShadowColor(int argc, VALUE *argv, VALUE self) { FXMenuCaption *arg1 = (FXMenuCaption *) 0 ;
    FXColor arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuCaption, 1); arg2 = to_FXColor(argv[0]);
    (arg1)->setShadowColor(arg2); return Qnil; }
static VALUE _wrap_FXMenuCaption_getShadowColor(int argc, VALUE *argv, VALUE self) { FXMenuCaption *arg1 = (FXMenuCaption *) 0 ;
    FXColor result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuCaption, 1);
    result = (FXColor)((FXMenuCaption const *)arg1)->getShadowColor(); vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXMenuCaption_setHelpText(int argc, VALUE *argv, VALUE self) { FXMenuCaption *arg1 = (FXMenuCaption *) 0 ;
    FXString *arg2 = 0 ; SwigValueWrapper<FXString > p2 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuCaption, 1); p2 = to_FXString(argv[0]); arg2 = &p2;
    (arg1)->setHelpText((FXString const &)*arg2); return Qnil; }
static VALUE _wrap_FXMenuCaption_getHelpText(int argc, VALUE *argv, VALUE self) { FXMenuCaption *arg1 = (FXMenuCaption *) 0 ;
    FXString result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuCaption, 1); result = ((FXMenuCaption const *)arg1)->getHelpText();
    vresult = rb_str_new2((&result)->text()); return vresult; }
static void
free_FXMenuCaption(FXMenuCaption *arg1) {
    delete arg1;
}
static VALUE _wrap_FXMenuCaption_save(int argc, VALUE *argv, VALUE self) { FXMenuCaption *arg1 = (FXMenuCaption *) 0 ;
    FXStream *arg2 = 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuCaption, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXMenuCaption_save((FXMenuCaption const *)arg1,*arg2); return Qnil; }
static VALUE _wrap_FXMenuCaption_load(int argc, VALUE *argv, VALUE self) { FXMenuCaption *arg1 = (FXMenuCaption *) 0 ;
    FXStream *arg2 = 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuCaption, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXMenuCaption_load(arg1,*arg2); return Qnil; }
static VALUE _wrap_FXMenuCaption_create(int argc, VALUE *argv, VALUE self) { FXMenuCaption *arg1 = (FXMenuCaption *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuCaption, 1); FXMenuCaption_create(arg1); return Qnil; }
static VALUE _wrap_FXMenuCaption_detach(int argc, VALUE *argv, VALUE self) { FXMenuCaption *arg1 = (FXMenuCaption *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuCaption, 1); FXMenuCaption_detach(arg1); return Qnil; }
static VALUE _wrap_FXMenuCaption_destroy(int argc, VALUE *argv, VALUE self) { FXMenuCaption *arg1 = (FXMenuCaption *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuCaption, 1); FXMenuCaption_destroy(arg1); return Qnil; }
static VALUE _wrap_FXMenuCaption_resize(int argc, VALUE *argv, VALUE self) { FXMenuCaption *arg1 = (FXMenuCaption *) 0 ;
    FXint arg2 ; FXint arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuCaption, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    FXMenuCaption_resize(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXMenuCaption_getDefaultWidth(int argc, VALUE *argv, VALUE self) {
    FXMenuCaption *arg1 = (FXMenuCaption *) 0 ; FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuCaption, 1); result = (FXint)FXMenuCaption_getDefaultWidth(arg1);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXMenuCaption_getDefaultHeight(int argc, VALUE *argv, VALUE self) {
    FXMenuCaption *arg1 = (FXMenuCaption *) 0 ; FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuCaption, 1); result = (FXint)FXMenuCaption_getDefaultHeight(arg1);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXMenuCaption_getWidthForHeight(int argc, VALUE *argv, VALUE self) {
    FXMenuCaption *arg1 = (FXMenuCaption *) 0 ; FXint arg2 ; FXint result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuCaption, 1); arg2 = NUM2INT(argv[0]);
    result = (FXint)FXMenuCaption_getWidthForHeight(arg1,arg2); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXMenuCaption_getHeightForWidth(int argc, VALUE *argv, VALUE self) {
    FXMenuCaption *arg1 = (FXMenuCaption *) 0 ; FXint arg2 ; FXint result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuCaption, 1); arg2 = NUM2INT(argv[0]);
    result = (FXint)FXMenuCaption_getHeightForWidth(arg1,arg2); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXMenuCaption_canFocus(int argc, VALUE *argv, VALUE self) { FXMenuCaption *arg1 = (FXMenuCaption *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuCaption, 1);
    result = (FXbool)FXMenuCaption_canFocus((FXMenuCaption const *)arg1); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXMenuCaption_setFocus(int argc, VALUE *argv, VALUE self) { FXMenuCaption *arg1 = (FXMenuCaption *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuCaption, 1); FXMenuCaption_setFocus(arg1); return Qnil; }
static VALUE _wrap_FXMenuCaption_killFocus(int argc, VALUE *argv, VALUE self) { FXMenuCaption *arg1 = (FXMenuCaption *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuCaption, 1); FXMenuCaption_killFocus(arg1); return Qnil; }
static VALUE _wrap_FXMenuCaption_setDefault(int argc, VALUE *argv, VALUE self) { FXMenuCaption *arg1 = (FXMenuCaption *) 0 ;
    FXbool arg2 = (FXbool) 1 ; if ((argc < 0) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuCaption, 1); if (argc > 0) { arg2 = to_FXbool(argv[0]); } 
    FXMenuCaption_setDefault(arg1,arg2); return Qnil; }
static VALUE _wrap_FXMenuCaption_enable(int argc, VALUE *argv, VALUE self) { FXMenuCaption *arg1 = (FXMenuCaption *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuCaption, 1); FXMenuCaption_enable(arg1); return Qnil; }
static VALUE _wrap_FXMenuCaption_disable(int argc, VALUE *argv, VALUE self) { FXMenuCaption *arg1 = (FXMenuCaption *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuCaption, 1); FXMenuCaption_disable(arg1); return Qnil; }
static VALUE _wrap_FXMenuCaption_raiseWindow(int argc, VALUE *argv, VALUE self) { FXMenuCaption *arg1 = (FXMenuCaption *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuCaption, 1); FXMenuCaption_raise(arg1); return Qnil; }
static VALUE _wrap_FXMenuCaption_lower(int argc, VALUE *argv, VALUE self) { FXMenuCaption *arg1 = (FXMenuCaption *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuCaption, 1); FXMenuCaption_lower(arg1); return Qnil; }
static VALUE _wrap_FXMenuCaption_move(int argc, VALUE *argv, VALUE self) { FXMenuCaption *arg1 = (FXMenuCaption *) 0 ;
    FXint arg2 ; FXint arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuCaption, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    FXMenuCaption_move(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXMenuCaption_position(int argc, VALUE *argv, VALUE self) { FXMenuCaption *arg1 = (FXMenuCaption *) 0 ;
    FXint arg2 ; FXint arg3 ; FXint arg4 ; FXint arg5 ; if ((argc < 4) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuCaption, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    arg4 = NUM2INT(argv[2]); arg5 = NUM2INT(argv[3]); FXMenuCaption_position(arg1,arg2,arg3,arg4,arg5); return Qnil; }
static VALUE _wrap_FXMenuCaption_layout(int argc, VALUE *argv, VALUE self) { FXMenuCaption *arg1 = (FXMenuCaption *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuCaption, 1); FXMenuCaption_layout(arg1); return Qnil; }
static VALUE _wrap_FXMenuCaption_recalc(int argc, VALUE *argv, VALUE self) { FXMenuCaption *arg1 = (FXMenuCaption *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuCaption, 1); FXMenuCaption_recalc(arg1); return Qnil; }
static VALUE _wrap_FXMenuCaption_reparent(int argc, VALUE *argv, VALUE self) { FXMenuCaption *arg1 = (FXMenuCaption *) 0 ;
    FXComposite *arg2 = (FXComposite *) 0 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuCaption, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXComposite, 1); FXMenuCaption_reparent(arg1,arg2); return Qnil; }
static VALUE _wrap_FXMenuCaption_show(int argc, VALUE *argv, VALUE self) { FXMenuCaption *arg1 = (FXMenuCaption *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuCaption, 1); FXMenuCaption_show(arg1); return Qnil; }
static VALUE _wrap_FXMenuCaption_hide(int argc, VALUE *argv, VALUE self) { FXMenuCaption *arg1 = (FXMenuCaption *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuCaption, 1); FXMenuCaption_hide(arg1); return Qnil; }
static VALUE _wrap_FXMenuCaption_isComposite(int argc, VALUE *argv, VALUE self) { FXMenuCaption *arg1 = (FXMenuCaption *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuCaption, 1);
    result = (FXbool)FXMenuCaption_isComposite((FXMenuCaption const *)arg1); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXMenuCaption_contains(int argc, VALUE *argv, VALUE self) { FXMenuCaption *arg1 = (FXMenuCaption *) 0 ;
    FXint arg2 ; FXint arg3 ; FXbool result; VALUE vresult = Qnil; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuCaption, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    result = (FXbool)FXMenuCaption_contains((FXMenuCaption const *)arg1,arg2,arg3); vresult = result ? Qtrue : Qfalse;
    return vresult; }
static VALUE _wrap_FXMenuCaption_doesSaveUnder(int argc, VALUE *argv, VALUE self) { FXMenuCaption *arg1 = (FXMenuCaption *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuCaption, 1);
    result = (FXbool)FXMenuCaption_doesSaveUnder((FXMenuCaption const *)arg1); vresult = result ? Qtrue : Qfalse;
    return vresult; }
static VALUE _wrap_FXMenuCaption_setBackColor(int argc, VALUE *argv, VALUE self) { FXMenuCaption *arg1 = (FXMenuCaption *) 0 ;
    FXColor arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuCaption, 1); arg2 = to_FXColor(argv[0]);
    FXMenuCaption_setBackColor(arg1,arg2); return Qnil; }
static VALUE _wrap_FXMenuSeparator_onPaint(int argc, VALUE *argv, VALUE self) { FXMenuSeparator *arg1 = (FXMenuSeparator *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuSeparator, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onPaint(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE _wrap_FXMenuSeparator_allocate(VALUE self) {
#else
     static VALUE _wrap_FXMenuSeparator_allocate(int argc, VALUE *argv, VALUE self) {
#endif
         VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_FXMenuSeparator);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
         return vresult; }
static VALUE _wrap_new_FXMenuSeparator(int argc, VALUE *argv, VALUE self) { FXComposite *arg1 = (FXComposite *) 0 ;
    FXuint arg2 = (FXuint) 0 ; FXMenuSeparator *result; if ((argc < 1) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXComposite, 1); if (argc > 1) { arg2 = NUM2UINT(argv[1]); }  {
        result = (FXMenuSeparator *)new_FXMenuSeparator(arg1,arg2); DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result);
        if(rb_block_given_p()){ rb_yield(self); }  }  return self; }
static VALUE _wrap_FXMenuSeparator_setHiliteColor(int argc, VALUE *argv, VALUE self) {
    FXMenuSeparator *arg1 = (FXMenuSeparator *) 0 ; FXColor arg2 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuSeparator, 1); arg2 = to_FXColor(argv[0]);
    (arg1)->setHiliteColor(arg2); return Qnil; }
static VALUE _wrap_FXMenuSeparator_getHiliteColor(int argc, VALUE *argv, VALUE self) {
    FXMenuSeparator *arg1 = (FXMenuSeparator *) 0 ; FXColor result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuSeparator, 1);
    result = (FXColor)((FXMenuSeparator const *)arg1)->getHiliteColor(); vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXMenuSeparator_setShadowColor(int argc, VALUE *argv, VALUE self) {
    FXMenuSeparator *arg1 = (FXMenuSeparator *) 0 ; FXColor arg2 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuSeparator, 1); arg2 = to_FXColor(argv[0]);
    (arg1)->setShadowColor(arg2); return Qnil; }
static VALUE _wrap_FXMenuSeparator_getShadowColor(int argc, VALUE *argv, VALUE self) {
    FXMenuSeparator *arg1 = (FXMenuSeparator *) 0 ; FXColor result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuSeparator, 1);
    result = (FXColor)((FXMenuSeparator const *)arg1)->getShadowColor(); vresult = UINT2NUM(result); return vresult; }
static void
free_FXMenuSeparator(FXMenuSeparator *arg1) {
    delete arg1;
}
static VALUE _wrap_FXMenuSeparator_save(int argc, VALUE *argv, VALUE self) { FXMenuSeparator *arg1 = (FXMenuSeparator *) 0 ;
    FXStream *arg2 = 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuSeparator, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXMenuSeparator_save((FXMenuSeparator const *)arg1,*arg2); return Qnil; }
static VALUE _wrap_FXMenuSeparator_load(int argc, VALUE *argv, VALUE self) { FXMenuSeparator *arg1 = (FXMenuSeparator *) 0 ;
    FXStream *arg2 = 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuSeparator, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXMenuSeparator_load(arg1,*arg2); return Qnil; }
static VALUE _wrap_FXMenuSeparator_create(int argc, VALUE *argv, VALUE self) { FXMenuSeparator *arg1 = (FXMenuSeparator *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuSeparator, 1); FXMenuSeparator_create(arg1); return Qnil; }
static VALUE _wrap_FXMenuSeparator_detach(int argc, VALUE *argv, VALUE self) { FXMenuSeparator *arg1 = (FXMenuSeparator *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuSeparator, 1); FXMenuSeparator_detach(arg1); return Qnil; }
static VALUE _wrap_FXMenuSeparator_destroy(int argc, VALUE *argv, VALUE self) { FXMenuSeparator *arg1 = (FXMenuSeparator *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuSeparator, 1); FXMenuSeparator_destroy(arg1); return Qnil; }
static VALUE _wrap_FXMenuSeparator_resize(int argc, VALUE *argv, VALUE self) { FXMenuSeparator *arg1 = (FXMenuSeparator *) 0 ;
    FXint arg2 ; FXint arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuSeparator, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    FXMenuSeparator_resize(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXMenuSeparator_getDefaultWidth(int argc, VALUE *argv, VALUE self) {
    FXMenuSeparator *arg1 = (FXMenuSeparator *) 0 ; FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuSeparator, 1);
    result = (FXint)FXMenuSeparator_getDefaultWidth(arg1); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXMenuSeparator_getDefaultHeight(int argc, VALUE *argv, VALUE self) {
    FXMenuSeparator *arg1 = (FXMenuSeparator *) 0 ; FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuSeparator, 1);
    result = (FXint)FXMenuSeparator_getDefaultHeight(arg1); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXMenuSeparator_getWidthForHeight(int argc, VALUE *argv, VALUE self) {
    FXMenuSeparator *arg1 = (FXMenuSeparator *) 0 ; FXint arg2 ; FXint result; VALUE vresult = Qnil;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuSeparator, 1); arg2 = NUM2INT(argv[0]);
    result = (FXint)FXMenuSeparator_getWidthForHeight(arg1,arg2); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXMenuSeparator_getHeightForWidth(int argc, VALUE *argv, VALUE self) {
    FXMenuSeparator *arg1 = (FXMenuSeparator *) 0 ; FXint arg2 ; FXint result; VALUE vresult = Qnil;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuSeparator, 1); arg2 = NUM2INT(argv[0]);
    result = (FXint)FXMenuSeparator_getHeightForWidth(arg1,arg2); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXMenuSeparator_canFocus(int argc, VALUE *argv, VALUE self) { FXMenuSeparator *arg1 = (FXMenuSeparator *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuSeparator, 1);
    result = (FXbool)FXMenuSeparator_canFocus((FXMenuSeparator const *)arg1); vresult = result ? Qtrue : Qfalse;
    return vresult; }
static VALUE _wrap_FXMenuSeparator_setFocus(int argc, VALUE *argv, VALUE self) { FXMenuSeparator *arg1 = (FXMenuSeparator *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuSeparator, 1); FXMenuSeparator_setFocus(arg1); return Qnil; }
static VALUE _wrap_FXMenuSeparator_killFocus(int argc, VALUE *argv, VALUE self) {
    FXMenuSeparator *arg1 = (FXMenuSeparator *) 0 ; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuSeparator, 1); FXMenuSeparator_killFocus(arg1); return Qnil; }
static VALUE _wrap_FXMenuSeparator_setDefault(int argc, VALUE *argv, VALUE self) {
    FXMenuSeparator *arg1 = (FXMenuSeparator *) 0 ; FXbool arg2 = (FXbool) 1 ; if ((argc < 0) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuSeparator, 1); if (argc > 0) { arg2 = to_FXbool(argv[0]); } 
    FXMenuSeparator_setDefault(arg1,arg2); return Qnil; }
static VALUE _wrap_FXMenuSeparator_enable(int argc, VALUE *argv, VALUE self) { FXMenuSeparator *arg1 = (FXMenuSeparator *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuSeparator, 1); FXMenuSeparator_enable(arg1); return Qnil; }
static VALUE _wrap_FXMenuSeparator_disable(int argc, VALUE *argv, VALUE self) { FXMenuSeparator *arg1 = (FXMenuSeparator *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuSeparator, 1); FXMenuSeparator_disable(arg1); return Qnil; }
static VALUE _wrap_FXMenuSeparator_raiseWindow(int argc, VALUE *argv, VALUE self) {
    FXMenuSeparator *arg1 = (FXMenuSeparator *) 0 ; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuSeparator, 1); FXMenuSeparator_raise(arg1); return Qnil; }
static VALUE _wrap_FXMenuSeparator_lower(int argc, VALUE *argv, VALUE self) { FXMenuSeparator *arg1 = (FXMenuSeparator *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuSeparator, 1); FXMenuSeparator_lower(arg1); return Qnil; }
static VALUE _wrap_FXMenuSeparator_move(int argc, VALUE *argv, VALUE self) { FXMenuSeparator *arg1 = (FXMenuSeparator *) 0 ;
    FXint arg2 ; FXint arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuSeparator, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    FXMenuSeparator_move(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXMenuSeparator_position(int argc, VALUE *argv, VALUE self) { FXMenuSeparator *arg1 = (FXMenuSeparator *) 0 ;
    FXint arg2 ; FXint arg3 ; FXint arg4 ; FXint arg5 ; if ((argc < 4) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuSeparator, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    arg4 = NUM2INT(argv[2]); arg5 = NUM2INT(argv[3]); FXMenuSeparator_position(arg1,arg2,arg3,arg4,arg5); return Qnil; }
static VALUE _wrap_FXMenuSeparator_layout(int argc, VALUE *argv, VALUE self) { FXMenuSeparator *arg1 = (FXMenuSeparator *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuSeparator, 1); FXMenuSeparator_layout(arg1); return Qnil; }
static VALUE _wrap_FXMenuSeparator_recalc(int argc, VALUE *argv, VALUE self) { FXMenuSeparator *arg1 = (FXMenuSeparator *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuSeparator, 1); FXMenuSeparator_recalc(arg1); return Qnil; }
static VALUE _wrap_FXMenuSeparator_reparent(int argc, VALUE *argv, VALUE self) { FXMenuSeparator *arg1 = (FXMenuSeparator *) 0 ;
    FXComposite *arg2 = (FXComposite *) 0 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuSeparator, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXComposite, 1); FXMenuSeparator_reparent(arg1,arg2); return Qnil; }
static VALUE _wrap_FXMenuSeparator_show(int argc, VALUE *argv, VALUE self) { FXMenuSeparator *arg1 = (FXMenuSeparator *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuSeparator, 1); FXMenuSeparator_show(arg1); return Qnil; }
static VALUE _wrap_FXMenuSeparator_hide(int argc, VALUE *argv, VALUE self) { FXMenuSeparator *arg1 = (FXMenuSeparator *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuSeparator, 1); FXMenuSeparator_hide(arg1); return Qnil; }
static VALUE _wrap_FXMenuSeparator_isComposite(int argc, VALUE *argv, VALUE self) {
    FXMenuSeparator *arg1 = (FXMenuSeparator *) 0 ; FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuSeparator, 1);
    result = (FXbool)FXMenuSeparator_isComposite((FXMenuSeparator const *)arg1); vresult = result ? Qtrue : Qfalse;
    return vresult; }
static VALUE _wrap_FXMenuSeparator_contains(int argc, VALUE *argv, VALUE self) { FXMenuSeparator *arg1 = (FXMenuSeparator *) 0 ;
    FXint arg2 ; FXint arg3 ; FXbool result; VALUE vresult = Qnil; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuSeparator, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    result = (FXbool)FXMenuSeparator_contains((FXMenuSeparator const *)arg1,arg2,arg3); vresult = result ? Qtrue : Qfalse;
    return vresult; }
static VALUE _wrap_FXMenuSeparator_doesSaveUnder(int argc, VALUE *argv, VALUE self) {
    FXMenuSeparator *arg1 = (FXMenuSeparator *) 0 ; FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuSeparator, 1);
    result = (FXbool)FXMenuSeparator_doesSaveUnder((FXMenuSeparator const *)arg1); vresult = result ? Qtrue : Qfalse;
    return vresult; }
static VALUE _wrap_FXMenuSeparator_setBackColor(int argc, VALUE *argv, VALUE self) {
    FXMenuSeparator *arg1 = (FXMenuSeparator *) 0 ; FXColor arg2 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuSeparator, 1); arg2 = to_FXColor(argv[0]);
    FXMenuSeparator_setBackColor(arg1,arg2); return Qnil; }
static VALUE _wrap_FXMenuTitle_onPaint(int argc, VALUE *argv, VALUE self) { FXMenuTitle *arg1 = (FXMenuTitle *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuTitle, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onPaint(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXMenuTitle_onEnter(int argc, VALUE *argv, VALUE self) { FXMenuTitle *arg1 = (FXMenuTitle *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuTitle, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onEnter(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXMenuTitle_onLeave(int argc, VALUE *argv, VALUE self) { FXMenuTitle *arg1 = (FXMenuTitle *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuTitle, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onLeave(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXMenuTitle_onLeftBtnPress(int argc, VALUE *argv, VALUE self) { FXMenuTitle *arg1 = (FXMenuTitle *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuTitle, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onLeftBtnPress(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXMenuTitle_onLeftBtnRelease(int argc, VALUE *argv, VALUE self) { FXMenuTitle *arg1 = (FXMenuTitle *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuTitle, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onLeftBtnRelease(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXMenuTitle_onKeyPress(int argc, VALUE *argv, VALUE self) { FXMenuTitle *arg1 = (FXMenuTitle *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuTitle, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onKeyPress(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXMenuTitle_onKeyRelease(int argc, VALUE *argv, VALUE self) { FXMenuTitle *arg1 = (FXMenuTitle *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuTitle, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onKeyRelease(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXMenuTitle_onHotKeyPress(int argc, VALUE *argv, VALUE self) { FXMenuTitle *arg1 = (FXMenuTitle *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuTitle, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onHotKeyPress(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXMenuTitle_onHotKeyRelease(int argc, VALUE *argv, VALUE self) { FXMenuTitle *arg1 = (FXMenuTitle *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuTitle, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onHotKeyRelease(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXMenuTitle_onFocusUp(int argc, VALUE *argv, VALUE self) { FXMenuTitle *arg1 = (FXMenuTitle *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuTitle, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onFocusUp(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXMenuTitle_onFocusDown(int argc, VALUE *argv, VALUE self) { FXMenuTitle *arg1 = (FXMenuTitle *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuTitle, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onFocusDown(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXMenuTitle_onFocusIn(int argc, VALUE *argv, VALUE self) { FXMenuTitle *arg1 = (FXMenuTitle *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuTitle, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onFocusIn(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXMenuTitle_onFocusOut(int argc, VALUE *argv, VALUE self) { FXMenuTitle *arg1 = (FXMenuTitle *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuTitle, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onFocusOut(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXMenuTitle_onCmdPost(int argc, VALUE *argv, VALUE self) { FXMenuTitle *arg1 = (FXMenuTitle *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuTitle, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdPost(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXMenuTitle_onCmdUnpost(int argc, VALUE *argv, VALUE self) { FXMenuTitle *arg1 = (FXMenuTitle *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuTitle, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdUnpost(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE _wrap_FXMenuTitle_allocate(VALUE self) {
#else
     static VALUE _wrap_FXMenuTitle_allocate(int argc, VALUE *argv, VALUE self) {
#endif
         VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_FXMenuTitle);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
         return vresult; }
static VALUE _wrap_new_FXMenuTitle(int argc, VALUE *argv, VALUE self) { FXComposite *arg1 = (FXComposite *) 0 ;
    FXString *arg2 = 0 ; FXIcon *arg3 = (FXIcon *) 0 ; FXPopup *arg4 = (FXPopup *) 0 ; FXuint arg5 = (FXuint) 0 ;
    FXMenuTitle *result; SwigValueWrapper<FXString > p2 ; if ((argc < 2) || (argc > 5))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXComposite, 1); p2 = to_FXString(argv[1]); arg2 = &p2; if (argc > 2) {
        SWIG_ConvertPtr(argv[2], (void **) &arg3, SWIGTYPE_p_FXIcon, 1); }  if (argc > 3) {
        SWIG_ConvertPtr(argv[3], (void **) &arg4, SWIGTYPE_p_FXPopup, 1); }  if (argc > 4) { arg5 = NUM2UINT(argv[4]); }  {
        result = (FXMenuTitle *)new_FXMenuTitle(arg1,(FXString const &)*arg2,arg3,arg4,arg5);
        DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result); if(rb_block_given_p()){ rb_yield(self); }  }  return self; }
static VALUE _wrap_FXMenuTitle_setMenu(int argc, VALUE *argv, VALUE self) { FXMenuTitle *arg1 = (FXMenuTitle *) 0 ;
    FXPopup *arg2 = (FXPopup *) 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuTitle, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXPopup, 1); (arg1)->setMenu(arg2); return Qnil; }
static VALUE _wrap_FXMenuTitle_getMenu(int argc, VALUE *argv, VALUE self) { FXMenuTitle *arg1 = (FXMenuTitle *) 0 ;
    FXPopup *result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuTitle, 1);
    result = (FXPopup *)((FXMenuTitle const *)arg1)->getMenu(); {
        swig_type_info *ty = SWIG_TypeDynamicCast(SWIGTYPE_p_FXPopup, (void **) &result); vresult = FXRbGetRubyObj(result, ty); }
     return vresult; }
static void
free_FXMenuTitle(FXMenuTitle *arg1) {
    delete arg1;
}
static VALUE _wrap_FXMenuTitle_save(int argc, VALUE *argv, VALUE self) { FXMenuTitle *arg1 = (FXMenuTitle *) 0 ;
    FXStream *arg2 = 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuTitle, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXMenuTitle_save((FXMenuTitle const *)arg1,*arg2); return Qnil; }
static VALUE _wrap_FXMenuTitle_load(int argc, VALUE *argv, VALUE self) { FXMenuTitle *arg1 = (FXMenuTitle *) 0 ;
    FXStream *arg2 = 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuTitle, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXMenuTitle_load(arg1,*arg2); return Qnil; }
static VALUE _wrap_FXMenuTitle_create(int argc, VALUE *argv, VALUE self) { FXMenuTitle *arg1 = (FXMenuTitle *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuTitle, 1); FXMenuTitle_create(arg1); return Qnil; }
static VALUE _wrap_FXMenuTitle_detach(int argc, VALUE *argv, VALUE self) { FXMenuTitle *arg1 = (FXMenuTitle *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuTitle, 1); FXMenuTitle_detach(arg1); return Qnil; }
static VALUE _wrap_FXMenuTitle_destroy(int argc, VALUE *argv, VALUE self) { FXMenuTitle *arg1 = (FXMenuTitle *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuTitle, 1); FXMenuTitle_destroy(arg1); return Qnil; }
static VALUE _wrap_FXMenuTitle_resize(int argc, VALUE *argv, VALUE self) { FXMenuTitle *arg1 = (FXMenuTitle *) 0 ; FXint arg2 ;
    FXint arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuTitle, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    FXMenuTitle_resize(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXMenuTitle_getDefaultWidth(int argc, VALUE *argv, VALUE self) { FXMenuTitle *arg1 = (FXMenuTitle *) 0 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuTitle, 1); result = (FXint)FXMenuTitle_getDefaultWidth(arg1);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXMenuTitle_getDefaultHeight(int argc, VALUE *argv, VALUE self) { FXMenuTitle *arg1 = (FXMenuTitle *) 0 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuTitle, 1); result = (FXint)FXMenuTitle_getDefaultHeight(arg1);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXMenuTitle_getWidthForHeight(int argc, VALUE *argv, VALUE self) { FXMenuTitle *arg1 = (FXMenuTitle *) 0 ;
    FXint arg2 ; FXint result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuTitle, 1); arg2 = NUM2INT(argv[0]);
    result = (FXint)FXMenuTitle_getWidthForHeight(arg1,arg2); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXMenuTitle_getHeightForWidth(int argc, VALUE *argv, VALUE self) { FXMenuTitle *arg1 = (FXMenuTitle *) 0 ;
    FXint arg2 ; FXint result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuTitle, 1); arg2 = NUM2INT(argv[0]);
    result = (FXint)FXMenuTitle_getHeightForWidth(arg1,arg2); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXMenuTitle_canFocus(int argc, VALUE *argv, VALUE self) { FXMenuTitle *arg1 = (FXMenuTitle *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuTitle, 1);
    result = (FXbool)FXMenuTitle_canFocus((FXMenuTitle const *)arg1); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXMenuTitle_setFocus(int argc, VALUE *argv, VALUE self) { FXMenuTitle *arg1 = (FXMenuTitle *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuTitle, 1); FXMenuTitle_setFocus(arg1); return Qnil; }
static VALUE _wrap_FXMenuTitle_killFocus(int argc, VALUE *argv, VALUE self) { FXMenuTitle *arg1 = (FXMenuTitle *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuTitle, 1); FXMenuTitle_killFocus(arg1); return Qnil; }
static VALUE _wrap_FXMenuTitle_setDefault(int argc, VALUE *argv, VALUE self) { FXMenuTitle *arg1 = (FXMenuTitle *) 0 ;
    FXbool arg2 = (FXbool) 1 ; if ((argc < 0) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuTitle, 1); if (argc > 0) { arg2 = to_FXbool(argv[0]); } 
    FXMenuTitle_setDefault(arg1,arg2); return Qnil; }
static VALUE _wrap_FXMenuTitle_enable(int argc, VALUE *argv, VALUE self) { FXMenuTitle *arg1 = (FXMenuTitle *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuTitle, 1); FXMenuTitle_enable(arg1); return Qnil; }
static VALUE _wrap_FXMenuTitle_disable(int argc, VALUE *argv, VALUE self) { FXMenuTitle *arg1 = (FXMenuTitle *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuTitle, 1); FXMenuTitle_disable(arg1); return Qnil; }
static VALUE _wrap_FXMenuTitle_raiseWindow(int argc, VALUE *argv, VALUE self) { FXMenuTitle *arg1 = (FXMenuTitle *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuTitle, 1); FXMenuTitle_raise(arg1); return Qnil; }
static VALUE _wrap_FXMenuTitle_lower(int argc, VALUE *argv, VALUE self) { FXMenuTitle *arg1 = (FXMenuTitle *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuTitle, 1); FXMenuTitle_lower(arg1); return Qnil; }
static VALUE _wrap_FXMenuTitle_move(int argc, VALUE *argv, VALUE self) { FXMenuTitle *arg1 = (FXMenuTitle *) 0 ; FXint arg2 ;
    FXint arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuTitle, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    FXMenuTitle_move(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXMenuTitle_position(int argc, VALUE *argv, VALUE self) { FXMenuTitle *arg1 = (FXMenuTitle *) 0 ;
    FXint arg2 ; FXint arg3 ; FXint arg4 ; FXint arg5 ; if ((argc < 4) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuTitle, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    arg4 = NUM2INT(argv[2]); arg5 = NUM2INT(argv[3]); FXMenuTitle_position(arg1,arg2,arg3,arg4,arg5); return Qnil; }
static VALUE _wrap_FXMenuTitle_layout(int argc, VALUE *argv, VALUE self) { FXMenuTitle *arg1 = (FXMenuTitle *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuTitle, 1); FXMenuTitle_layout(arg1); return Qnil; }
static VALUE _wrap_FXMenuTitle_recalc(int argc, VALUE *argv, VALUE self) { FXMenuTitle *arg1 = (FXMenuTitle *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuTitle, 1); FXMenuTitle_recalc(arg1); return Qnil; }
static VALUE _wrap_FXMenuTitle_reparent(int argc, VALUE *argv, VALUE self) { FXMenuTitle *arg1 = (FXMenuTitle *) 0 ;
    FXComposite *arg2 = (FXComposite *) 0 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuTitle, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXComposite, 1); FXMenuTitle_reparent(arg1,arg2); return Qnil; }
static VALUE _wrap_FXMenuTitle_show(int argc, VALUE *argv, VALUE self) { FXMenuTitle *arg1 = (FXMenuTitle *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuTitle, 1); FXMenuTitle_show(arg1); return Qnil; }
static VALUE _wrap_FXMenuTitle_hide(int argc, VALUE *argv, VALUE self) { FXMenuTitle *arg1 = (FXMenuTitle *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuTitle, 1); FXMenuTitle_hide(arg1); return Qnil; }
static VALUE _wrap_FXMenuTitle_isComposite(int argc, VALUE *argv, VALUE self) { FXMenuTitle *arg1 = (FXMenuTitle *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuTitle, 1);
    result = (FXbool)FXMenuTitle_isComposite((FXMenuTitle const *)arg1); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXMenuTitle_contains(int argc, VALUE *argv, VALUE self) { FXMenuTitle *arg1 = (FXMenuTitle *) 0 ;
    FXint arg2 ; FXint arg3 ; FXbool result; VALUE vresult = Qnil; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuTitle, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    result = (FXbool)FXMenuTitle_contains((FXMenuTitle const *)arg1,arg2,arg3); vresult = result ? Qtrue : Qfalse;
    return vresult; }
static VALUE _wrap_FXMenuTitle_doesSaveUnder(int argc, VALUE *argv, VALUE self) { FXMenuTitle *arg1 = (FXMenuTitle *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuTitle, 1);
    result = (FXbool)FXMenuTitle_doesSaveUnder((FXMenuTitle const *)arg1); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXMenuTitle_setBackColor(int argc, VALUE *argv, VALUE self) { FXMenuTitle *arg1 = (FXMenuTitle *) 0 ;
    FXColor arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuTitle, 1); arg2 = to_FXColor(argv[0]);
    FXMenuTitle_setBackColor(arg1,arg2); return Qnil; }
static VALUE _wrap_FXMenuCascade_onPaint(int argc, VALUE *argv, VALUE self) { FXMenuCascade *arg1 = (FXMenuCascade *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuCascade, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onPaint(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXMenuCascade_onEnter(int argc, VALUE *argv, VALUE self) { FXMenuCascade *arg1 = (FXMenuCascade *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuCascade, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onEnter(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXMenuCascade_onLeave(int argc, VALUE *argv, VALUE self) { FXMenuCascade *arg1 = (FXMenuCascade *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuCascade, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onLeave(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXMenuCascade_onButtonPress(int argc, VALUE *argv, VALUE self) { FXMenuCascade *arg1 = (FXMenuCascade *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuCascade, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onButtonPress(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXMenuCascade_onButtonRelease(int argc, VALUE *argv, VALUE self) {
    FXMenuCascade *arg1 = (FXMenuCascade *) 0 ; FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ;
    long result; VALUE vresult = Qnil; if ((argc < 3) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuCascade, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onButtonRelease(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXMenuCascade_onKeyPress(int argc, VALUE *argv, VALUE self) { FXMenuCascade *arg1 = (FXMenuCascade *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuCascade, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onKeyPress(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXMenuCascade_onKeyRelease(int argc, VALUE *argv, VALUE self) { FXMenuCascade *arg1 = (FXMenuCascade *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuCascade, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onKeyRelease(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXMenuCascade_onHotKeyPress(int argc, VALUE *argv, VALUE self) { FXMenuCascade *arg1 = (FXMenuCascade *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuCascade, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onHotKeyPress(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXMenuCascade_onHotKeyRelease(int argc, VALUE *argv, VALUE self) {
    FXMenuCascade *arg1 = (FXMenuCascade *) 0 ; FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ;
    long result; VALUE vresult = Qnil; if ((argc < 3) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuCascade, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onHotKeyRelease(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXMenuCascade_onCmdPost(int argc, VALUE *argv, VALUE self) { FXMenuCascade *arg1 = (FXMenuCascade *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuCascade, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdPost(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXMenuCascade_onCmdUnpost(int argc, VALUE *argv, VALUE self) { FXMenuCascade *arg1 = (FXMenuCascade *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuCascade, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdUnpost(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE _wrap_FXMenuCascade_allocate(VALUE self) {
#else
     static VALUE _wrap_FXMenuCascade_allocate(int argc, VALUE *argv, VALUE self) {
#endif
         VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_FXMenuCascade);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
         return vresult; }
static VALUE _wrap_new_FXMenuCascade(int argc, VALUE *argv, VALUE self) { FXComposite *arg1 = (FXComposite *) 0 ;
    FXString *arg2 = 0 ; FXIcon *arg3 = (FXIcon *) 0 ; FXPopup *arg4 = (FXPopup *) 0 ; FXuint arg5 = (FXuint) 0 ;
    FXMenuCascade *result; SwigValueWrapper<FXString > p2 ; if ((argc < 2) || (argc > 5))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXComposite, 1); p2 = to_FXString(argv[1]); arg2 = &p2; if (argc > 2) {
        SWIG_ConvertPtr(argv[2], (void **) &arg3, SWIGTYPE_p_FXIcon, 1); }  if (argc > 3) {
        SWIG_ConvertPtr(argv[3], (void **) &arg4, SWIGTYPE_p_FXPopup, 1); }  if (argc > 4) { arg5 = NUM2UINT(argv[4]); }  {
        result = (FXMenuCascade *)new_FXMenuCascade(arg1,(FXString const &)*arg2,arg3,arg4,arg5);
        DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result); if(rb_block_given_p()){ rb_yield(self); }  }  return self; }
static VALUE _wrap_FXMenuCascade_setMenu(int argc, VALUE *argv, VALUE self) { FXMenuCascade *arg1 = (FXMenuCascade *) 0 ;
    FXPopup *arg2 = (FXPopup *) 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuCascade, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXPopup, 1); (arg1)->setMenu(arg2); return Qnil; }
static VALUE _wrap_FXMenuCascade_getMenu(int argc, VALUE *argv, VALUE self) { FXMenuCascade *arg1 = (FXMenuCascade *) 0 ;
    FXPopup *result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuCascade, 1);
    result = (FXPopup *)((FXMenuCascade const *)arg1)->getMenu(); {
        swig_type_info *ty = SWIG_TypeDynamicCast(SWIGTYPE_p_FXPopup, (void **) &result); vresult = FXRbGetRubyObj(result, ty); }
     return vresult; }
static void
free_FXMenuCascade(FXMenuCascade *arg1) {
    delete arg1;
}
static VALUE _wrap_FXMenuCascade_save(int argc, VALUE *argv, VALUE self) { FXMenuCascade *arg1 = (FXMenuCascade *) 0 ;
    FXStream *arg2 = 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuCascade, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXMenuCascade_save((FXMenuCascade const *)arg1,*arg2); return Qnil; }
static VALUE _wrap_FXMenuCascade_load(int argc, VALUE *argv, VALUE self) { FXMenuCascade *arg1 = (FXMenuCascade *) 0 ;
    FXStream *arg2 = 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuCascade, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXMenuCascade_load(arg1,*arg2); return Qnil; }
static VALUE _wrap_FXMenuCascade_create(int argc, VALUE *argv, VALUE self) { FXMenuCascade *arg1 = (FXMenuCascade *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuCascade, 1); FXMenuCascade_create(arg1); return Qnil; }
static VALUE _wrap_FXMenuCascade_detach(int argc, VALUE *argv, VALUE self) { FXMenuCascade *arg1 = (FXMenuCascade *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuCascade, 1); FXMenuCascade_detach(arg1); return Qnil; }
static VALUE _wrap_FXMenuCascade_destroy(int argc, VALUE *argv, VALUE self) { FXMenuCascade *arg1 = (FXMenuCascade *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuCascade, 1); FXMenuCascade_destroy(arg1); return Qnil; }
static VALUE _wrap_FXMenuCascade_resize(int argc, VALUE *argv, VALUE self) { FXMenuCascade *arg1 = (FXMenuCascade *) 0 ;
    FXint arg2 ; FXint arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuCascade, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    FXMenuCascade_resize(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXMenuCascade_getDefaultWidth(int argc, VALUE *argv, VALUE self) {
    FXMenuCascade *arg1 = (FXMenuCascade *) 0 ; FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuCascade, 1); result = (FXint)FXMenuCascade_getDefaultWidth(arg1);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXMenuCascade_getDefaultHeight(int argc, VALUE *argv, VALUE self) {
    FXMenuCascade *arg1 = (FXMenuCascade *) 0 ; FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuCascade, 1); result = (FXint)FXMenuCascade_getDefaultHeight(arg1);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXMenuCascade_getWidthForHeight(int argc, VALUE *argv, VALUE self) {
    FXMenuCascade *arg1 = (FXMenuCascade *) 0 ; FXint arg2 ; FXint result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuCascade, 1); arg2 = NUM2INT(argv[0]);
    result = (FXint)FXMenuCascade_getWidthForHeight(arg1,arg2); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXMenuCascade_getHeightForWidth(int argc, VALUE *argv, VALUE self) {
    FXMenuCascade *arg1 = (FXMenuCascade *) 0 ; FXint arg2 ; FXint result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuCascade, 1); arg2 = NUM2INT(argv[0]);
    result = (FXint)FXMenuCascade_getHeightForWidth(arg1,arg2); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXMenuCascade_canFocus(int argc, VALUE *argv, VALUE self) { FXMenuCascade *arg1 = (FXMenuCascade *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuCascade, 1);
    result = (FXbool)FXMenuCascade_canFocus((FXMenuCascade const *)arg1); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXMenuCascade_setFocus(int argc, VALUE *argv, VALUE self) { FXMenuCascade *arg1 = (FXMenuCascade *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuCascade, 1); FXMenuCascade_setFocus(arg1); return Qnil; }
static VALUE _wrap_FXMenuCascade_killFocus(int argc, VALUE *argv, VALUE self) { FXMenuCascade *arg1 = (FXMenuCascade *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuCascade, 1); FXMenuCascade_killFocus(arg1); return Qnil; }
static VALUE _wrap_FXMenuCascade_setDefault(int argc, VALUE *argv, VALUE self) { FXMenuCascade *arg1 = (FXMenuCascade *) 0 ;
    FXbool arg2 = (FXbool) 1 ; if ((argc < 0) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuCascade, 1); if (argc > 0) { arg2 = to_FXbool(argv[0]); } 
    FXMenuCascade_setDefault(arg1,arg2); return Qnil; }
static VALUE _wrap_FXMenuCascade_enable(int argc, VALUE *argv, VALUE self) { FXMenuCascade *arg1 = (FXMenuCascade *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuCascade, 1); FXMenuCascade_enable(arg1); return Qnil; }
static VALUE _wrap_FXMenuCascade_disable(int argc, VALUE *argv, VALUE self) { FXMenuCascade *arg1 = (FXMenuCascade *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuCascade, 1); FXMenuCascade_disable(arg1); return Qnil; }
static VALUE _wrap_FXMenuCascade_raiseWindow(int argc, VALUE *argv, VALUE self) { FXMenuCascade *arg1 = (FXMenuCascade *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuCascade, 1); FXMenuCascade_raise(arg1); return Qnil; }
static VALUE _wrap_FXMenuCascade_lower(int argc, VALUE *argv, VALUE self) { FXMenuCascade *arg1 = (FXMenuCascade *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuCascade, 1); FXMenuCascade_lower(arg1); return Qnil; }
static VALUE _wrap_FXMenuCascade_move(int argc, VALUE *argv, VALUE self) { FXMenuCascade *arg1 = (FXMenuCascade *) 0 ;
    FXint arg2 ; FXint arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuCascade, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    FXMenuCascade_move(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXMenuCascade_position(int argc, VALUE *argv, VALUE self) { FXMenuCascade *arg1 = (FXMenuCascade *) 0 ;
    FXint arg2 ; FXint arg3 ; FXint arg4 ; FXint arg5 ; if ((argc < 4) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuCascade, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    arg4 = NUM2INT(argv[2]); arg5 = NUM2INT(argv[3]); FXMenuCascade_position(arg1,arg2,arg3,arg4,arg5); return Qnil; }
static VALUE _wrap_FXMenuCascade_layout(int argc, VALUE *argv, VALUE self) { FXMenuCascade *arg1 = (FXMenuCascade *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuCascade, 1); FXMenuCascade_layout(arg1); return Qnil; }
static VALUE _wrap_FXMenuCascade_recalc(int argc, VALUE *argv, VALUE self) { FXMenuCascade *arg1 = (FXMenuCascade *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuCascade, 1); FXMenuCascade_recalc(arg1); return Qnil; }
static VALUE _wrap_FXMenuCascade_reparent(int argc, VALUE *argv, VALUE self) { FXMenuCascade *arg1 = (FXMenuCascade *) 0 ;
    FXComposite *arg2 = (FXComposite *) 0 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuCascade, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXComposite, 1); FXMenuCascade_reparent(arg1,arg2); return Qnil; }
static VALUE _wrap_FXMenuCascade_show(int argc, VALUE *argv, VALUE self) { FXMenuCascade *arg1 = (FXMenuCascade *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuCascade, 1); FXMenuCascade_show(arg1); return Qnil; }
static VALUE _wrap_FXMenuCascade_hide(int argc, VALUE *argv, VALUE self) { FXMenuCascade *arg1 = (FXMenuCascade *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuCascade, 1); FXMenuCascade_hide(arg1); return Qnil; }
static VALUE _wrap_FXMenuCascade_isComposite(int argc, VALUE *argv, VALUE self) { FXMenuCascade *arg1 = (FXMenuCascade *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuCascade, 1);
    result = (FXbool)FXMenuCascade_isComposite((FXMenuCascade const *)arg1); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXMenuCascade_contains(int argc, VALUE *argv, VALUE self) { FXMenuCascade *arg1 = (FXMenuCascade *) 0 ;
    FXint arg2 ; FXint arg3 ; FXbool result; VALUE vresult = Qnil; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuCascade, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    result = (FXbool)FXMenuCascade_contains((FXMenuCascade const *)arg1,arg2,arg3); vresult = result ? Qtrue : Qfalse;
    return vresult; }
static VALUE _wrap_FXMenuCascade_doesSaveUnder(int argc, VALUE *argv, VALUE self) { FXMenuCascade *arg1 = (FXMenuCascade *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuCascade, 1);
    result = (FXbool)FXMenuCascade_doesSaveUnder((FXMenuCascade const *)arg1); vresult = result ? Qtrue : Qfalse;
    return vresult; }
static VALUE _wrap_FXMenuCascade_setBackColor(int argc, VALUE *argv, VALUE self) { FXMenuCascade *arg1 = (FXMenuCascade *) 0 ;
    FXColor arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuCascade, 1); arg2 = to_FXColor(argv[0]);
    FXMenuCascade_setBackColor(arg1,arg2); return Qnil; }
static VALUE _wrap_FXMenuCommand_onPaint(int argc, VALUE *argv, VALUE self) { FXMenuCommand *arg1 = (FXMenuCommand *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuCommand, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onPaint(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXMenuCommand_onEnter(int argc, VALUE *argv, VALUE self) { FXMenuCommand *arg1 = (FXMenuCommand *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuCommand, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onEnter(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXMenuCommand_onLeave(int argc, VALUE *argv, VALUE self) { FXMenuCommand *arg1 = (FXMenuCommand *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuCommand, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onLeave(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXMenuCommand_onButtonPress(int argc, VALUE *argv, VALUE self) { FXMenuCommand *arg1 = (FXMenuCommand *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuCommand, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onButtonPress(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXMenuCommand_onButtonRelease(int argc, VALUE *argv, VALUE self) {
    FXMenuCommand *arg1 = (FXMenuCommand *) 0 ; FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ;
    long result; VALUE vresult = Qnil; if ((argc < 3) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuCommand, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onButtonRelease(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXMenuCommand_onKeyPress(int argc, VALUE *argv, VALUE self) { FXMenuCommand *arg1 = (FXMenuCommand *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuCommand, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onKeyPress(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXMenuCommand_onKeyRelease(int argc, VALUE *argv, VALUE self) { FXMenuCommand *arg1 = (FXMenuCommand *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuCommand, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onKeyRelease(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXMenuCommand_onHotKeyPress(int argc, VALUE *argv, VALUE self) { FXMenuCommand *arg1 = (FXMenuCommand *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuCommand, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onHotKeyPress(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXMenuCommand_onHotKeyRelease(int argc, VALUE *argv, VALUE self) {
    FXMenuCommand *arg1 = (FXMenuCommand *) 0 ; FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ;
    long result; VALUE vresult = Qnil; if ((argc < 3) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuCommand, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onHotKeyRelease(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXMenuCommand_onCmdAccel(int argc, VALUE *argv, VALUE self) { FXMenuCommand *arg1 = (FXMenuCommand *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuCommand, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdAccel(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE _wrap_FXMenuCommand_allocate(VALUE self) {
#else
     static VALUE _wrap_FXMenuCommand_allocate(int argc, VALUE *argv, VALUE self) {
#endif
         VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_FXMenuCommand);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
         return vresult; }
static VALUE _wrap_new_FXMenuCommand(int argc, VALUE *argv, VALUE self) { FXComposite *arg1 = (FXComposite *) 0 ;
    FXString *arg2 = 0 ; FXIcon *arg3 = (FXIcon *) 0 ; FXObject *arg4 = (FXObject *) 0 ; FXSelector arg5 = (FXSelector) 0 ;
    FXuint arg6 = (FXuint) 0 ; FXMenuCommand *result; SwigValueWrapper<FXString > p2 ; if ((argc < 2) || (argc > 6))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXComposite, 1); p2 = to_FXString(argv[1]); arg2 = &p2; if (argc > 2) {
        SWIG_ConvertPtr(argv[2], (void **) &arg3, SWIGTYPE_p_FXIcon, 1); }  if (argc > 3) {
        SWIG_ConvertPtr(argv[3], (void **) &arg4, SWIGTYPE_p_FXObject, 1); }  if (argc > 4) { arg5 = NUM2UINT(argv[4]); } 
    if (argc > 5) { arg6 = NUM2UINT(argv[5]); }  {
        result = (FXMenuCommand *)new_FXMenuCommand(arg1,(FXString const &)*arg2,arg3,arg4,arg5,arg6);
        DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result); if(rb_block_given_p()){ rb_yield(self); }  }  return self; }
static VALUE _wrap_FXMenuCommand_setAccelText(int argc, VALUE *argv, VALUE self) { FXMenuCommand *arg1 = (FXMenuCommand *) 0 ;
    FXString *arg2 = 0 ; SwigValueWrapper<FXString > p2 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuCommand, 1); p2 = to_FXString(argv[0]); arg2 = &p2;
    (arg1)->setAccelText((FXString const &)*arg2); return Qnil; }
static VALUE _wrap_FXMenuCommand_getAccelText(int argc, VALUE *argv, VALUE self) { FXMenuCommand *arg1 = (FXMenuCommand *) 0 ;
    FXString result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuCommand, 1); result = ((FXMenuCommand const *)arg1)->getAccelText();
    vresult = rb_str_new2((&result)->text()); return vresult; }
static void
free_FXMenuCommand(FXMenuCommand *arg1) {
    delete arg1;
}
static VALUE _wrap_FXMenuCommand_save(int argc, VALUE *argv, VALUE self) { FXMenuCommand *arg1 = (FXMenuCommand *) 0 ;
    FXStream *arg2 = 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuCommand, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXMenuCommand_save((FXMenuCommand const *)arg1,*arg2); return Qnil; }
static VALUE _wrap_FXMenuCommand_load(int argc, VALUE *argv, VALUE self) { FXMenuCommand *arg1 = (FXMenuCommand *) 0 ;
    FXStream *arg2 = 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuCommand, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXMenuCommand_load(arg1,*arg2); return Qnil; }
static VALUE _wrap_FXMenuCommand_create(int argc, VALUE *argv, VALUE self) { FXMenuCommand *arg1 = (FXMenuCommand *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuCommand, 1); FXMenuCommand_create(arg1); return Qnil; }
static VALUE _wrap_FXMenuCommand_detach(int argc, VALUE *argv, VALUE self) { FXMenuCommand *arg1 = (FXMenuCommand *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuCommand, 1); FXMenuCommand_detach(arg1); return Qnil; }
static VALUE _wrap_FXMenuCommand_destroy(int argc, VALUE *argv, VALUE self) { FXMenuCommand *arg1 = (FXMenuCommand *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuCommand, 1); FXMenuCommand_destroy(arg1); return Qnil; }
static VALUE _wrap_FXMenuCommand_resize(int argc, VALUE *argv, VALUE self) { FXMenuCommand *arg1 = (FXMenuCommand *) 0 ;
    FXint arg2 ; FXint arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuCommand, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    FXMenuCommand_resize(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXMenuCommand_getDefaultWidth(int argc, VALUE *argv, VALUE self) {
    FXMenuCommand *arg1 = (FXMenuCommand *) 0 ; FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuCommand, 1); result = (FXint)FXMenuCommand_getDefaultWidth(arg1);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXMenuCommand_getDefaultHeight(int argc, VALUE *argv, VALUE self) {
    FXMenuCommand *arg1 = (FXMenuCommand *) 0 ; FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuCommand, 1); result = (FXint)FXMenuCommand_getDefaultHeight(arg1);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXMenuCommand_getWidthForHeight(int argc, VALUE *argv, VALUE self) {
    FXMenuCommand *arg1 = (FXMenuCommand *) 0 ; FXint arg2 ; FXint result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuCommand, 1); arg2 = NUM2INT(argv[0]);
    result = (FXint)FXMenuCommand_getWidthForHeight(arg1,arg2); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXMenuCommand_getHeightForWidth(int argc, VALUE *argv, VALUE self) {
    FXMenuCommand *arg1 = (FXMenuCommand *) 0 ; FXint arg2 ; FXint result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuCommand, 1); arg2 = NUM2INT(argv[0]);
    result = (FXint)FXMenuCommand_getHeightForWidth(arg1,arg2); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXMenuCommand_canFocus(int argc, VALUE *argv, VALUE self) { FXMenuCommand *arg1 = (FXMenuCommand *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuCommand, 1);
    result = (FXbool)FXMenuCommand_canFocus((FXMenuCommand const *)arg1); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXMenuCommand_setFocus(int argc, VALUE *argv, VALUE self) { FXMenuCommand *arg1 = (FXMenuCommand *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuCommand, 1); FXMenuCommand_setFocus(arg1); return Qnil; }
static VALUE _wrap_FXMenuCommand_killFocus(int argc, VALUE *argv, VALUE self) { FXMenuCommand *arg1 = (FXMenuCommand *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuCommand, 1); FXMenuCommand_killFocus(arg1); return Qnil; }
static VALUE _wrap_FXMenuCommand_setDefault(int argc, VALUE *argv, VALUE self) { FXMenuCommand *arg1 = (FXMenuCommand *) 0 ;
    FXbool arg2 = (FXbool) 1 ; if ((argc < 0) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuCommand, 1); if (argc > 0) { arg2 = to_FXbool(argv[0]); } 
    FXMenuCommand_setDefault(arg1,arg2); return Qnil; }
static VALUE _wrap_FXMenuCommand_enable(int argc, VALUE *argv, VALUE self) { FXMenuCommand *arg1 = (FXMenuCommand *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuCommand, 1); FXMenuCommand_enable(arg1); return Qnil; }
static VALUE _wrap_FXMenuCommand_disable(int argc, VALUE *argv, VALUE self) { FXMenuCommand *arg1 = (FXMenuCommand *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuCommand, 1); FXMenuCommand_disable(arg1); return Qnil; }
static VALUE _wrap_FXMenuCommand_raiseWindow(int argc, VALUE *argv, VALUE self) { FXMenuCommand *arg1 = (FXMenuCommand *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuCommand, 1); FXMenuCommand_raise(arg1); return Qnil; }
static VALUE _wrap_FXMenuCommand_lower(int argc, VALUE *argv, VALUE self) { FXMenuCommand *arg1 = (FXMenuCommand *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuCommand, 1); FXMenuCommand_lower(arg1); return Qnil; }
static VALUE _wrap_FXMenuCommand_move(int argc, VALUE *argv, VALUE self) { FXMenuCommand *arg1 = (FXMenuCommand *) 0 ;
    FXint arg2 ; FXint arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuCommand, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    FXMenuCommand_move(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXMenuCommand_position(int argc, VALUE *argv, VALUE self) { FXMenuCommand *arg1 = (FXMenuCommand *) 0 ;
    FXint arg2 ; FXint arg3 ; FXint arg4 ; FXint arg5 ; if ((argc < 4) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuCommand, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    arg4 = NUM2INT(argv[2]); arg5 = NUM2INT(argv[3]); FXMenuCommand_position(arg1,arg2,arg3,arg4,arg5); return Qnil; }
static VALUE _wrap_FXMenuCommand_layout(int argc, VALUE *argv, VALUE self) { FXMenuCommand *arg1 = (FXMenuCommand *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuCommand, 1); FXMenuCommand_layout(arg1); return Qnil; }
static VALUE _wrap_FXMenuCommand_recalc(int argc, VALUE *argv, VALUE self) { FXMenuCommand *arg1 = (FXMenuCommand *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuCommand, 1); FXMenuCommand_recalc(arg1); return Qnil; }
static VALUE _wrap_FXMenuCommand_reparent(int argc, VALUE *argv, VALUE self) { FXMenuCommand *arg1 = (FXMenuCommand *) 0 ;
    FXComposite *arg2 = (FXComposite *) 0 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuCommand, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXComposite, 1); FXMenuCommand_reparent(arg1,arg2); return Qnil; }
static VALUE _wrap_FXMenuCommand_show(int argc, VALUE *argv, VALUE self) { FXMenuCommand *arg1 = (FXMenuCommand *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuCommand, 1); FXMenuCommand_show(arg1); return Qnil; }
static VALUE _wrap_FXMenuCommand_hide(int argc, VALUE *argv, VALUE self) { FXMenuCommand *arg1 = (FXMenuCommand *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuCommand, 1); FXMenuCommand_hide(arg1); return Qnil; }
static VALUE _wrap_FXMenuCommand_isComposite(int argc, VALUE *argv, VALUE self) { FXMenuCommand *arg1 = (FXMenuCommand *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuCommand, 1);
    result = (FXbool)FXMenuCommand_isComposite((FXMenuCommand const *)arg1); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXMenuCommand_contains(int argc, VALUE *argv, VALUE self) { FXMenuCommand *arg1 = (FXMenuCommand *) 0 ;
    FXint arg2 ; FXint arg3 ; FXbool result; VALUE vresult = Qnil; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuCommand, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    result = (FXbool)FXMenuCommand_contains((FXMenuCommand const *)arg1,arg2,arg3); vresult = result ? Qtrue : Qfalse;
    return vresult; }
static VALUE _wrap_FXMenuCommand_doesSaveUnder(int argc, VALUE *argv, VALUE self) { FXMenuCommand *arg1 = (FXMenuCommand *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuCommand, 1);
    result = (FXbool)FXMenuCommand_doesSaveUnder((FXMenuCommand const *)arg1); vresult = result ? Qtrue : Qfalse;
    return vresult; }
static VALUE _wrap_FXMenuCommand_setBackColor(int argc, VALUE *argv, VALUE self) { FXMenuCommand *arg1 = (FXMenuCommand *) 0 ;
    FXColor arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuCommand, 1); arg2 = to_FXColor(argv[0]);
    FXMenuCommand_setBackColor(arg1,arg2); return Qnil; }
static VALUE _wrap_FXMenuBar_onFocusLeft(int argc, VALUE *argv, VALUE self) { FXMenuBar *arg1 = (FXMenuBar *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuBar, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onFocusLeft(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXMenuBar_onFocusRight(int argc, VALUE *argv, VALUE self) { FXMenuBar *arg1 = (FXMenuBar *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuBar, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onFocusRight(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXMenuBar_onEnter(int argc, VALUE *argv, VALUE self) { FXMenuBar *arg1 = (FXMenuBar *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuBar, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onEnter(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXMenuBar_onLeave(int argc, VALUE *argv, VALUE self) { FXMenuBar *arg1 = (FXMenuBar *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuBar, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onLeave(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXMenuBar_onMotion(int argc, VALUE *argv, VALUE self) { FXMenuBar *arg1 = (FXMenuBar *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuBar, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onMotion(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXMenuBar_onButtonPress(int argc, VALUE *argv, VALUE self) { FXMenuBar *arg1 = (FXMenuBar *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuBar, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onButtonPress(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXMenuBar_onButtonRelease(int argc, VALUE *argv, VALUE self) { FXMenuBar *arg1 = (FXMenuBar *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuBar, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onButtonRelease(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXMenuBar_onCmdUnpost(int argc, VALUE *argv, VALUE self) { FXMenuBar *arg1 = (FXMenuBar *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuBar, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdUnpost(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_new_FXMenuBar__SWIG_0(int argc, VALUE *argv, VALUE self) { FXComposite *arg1 = (FXComposite *) 0 ;
    FXComposite *arg2 = (FXComposite *) 0 ; FXuint arg3 = (FXuint) LAYOUT_TOP|LAYOUT_LEFT|LAYOUT_FILL_X ;
    FXint arg4 = (FXint) 0 ; FXint arg5 = (FXint) 0 ; FXint arg6 = (FXint) 0 ; FXint arg7 = (FXint) 0 ; FXint arg8 = (FXint) 3 ;
    FXint arg9 = (FXint) 3 ; FXint arg10 = (FXint) 2 ; FXint arg11 = (FXint) 2 ; FXint arg12 = (FXint) DEFAULT_SPACING ;
    FXint arg13 = (FXint) DEFAULT_SPACING ; FXMenuBar *result; if ((argc < 2) || (argc > 13))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXComposite, 1);
    SWIG_ConvertPtr(argv[1], (void **) &arg2, SWIGTYPE_p_FXComposite, 1); if (argc > 2) { arg3 = NUM2UINT(argv[2]); } 
    if (argc > 3) { arg4 = NUM2INT(argv[3]); }  if (argc > 4) { arg5 = NUM2INT(argv[4]); }  if (argc > 5) {
        arg6 = NUM2INT(argv[5]); }  if (argc > 6) { arg7 = NUM2INT(argv[6]); }  if (argc > 7) { arg8 = NUM2INT(argv[7]); } 
    if (argc > 8) { arg9 = NUM2INT(argv[8]); }  if (argc > 9) { arg10 = NUM2INT(argv[9]); }  if (argc > 10) {
        arg11 = NUM2INT(argv[10]); }  if (argc > 11) { arg12 = NUM2INT(argv[11]); }  if (argc > 12) {
        arg13 = NUM2INT(argv[12]); }  {
        result = (FXMenuBar *)new_FXMenuBar__SWIG_0(arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8,arg9,arg10,arg11,arg12,arg13);
        DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result); if(rb_block_given_p()){ rb_yield(self); }  }  return self; }
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE _wrap_FXMenuBar_allocate(VALUE self) {
#else
     static VALUE _wrap_FXMenuBar_allocate(int argc, VALUE *argv, VALUE self) {
#endif
         VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_FXMenuBar);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
         return vresult; }
static VALUE _wrap_new_FXMenuBar__SWIG_1(int argc, VALUE *argv, VALUE self) { FXComposite *arg1 = (FXComposite *) 0 ;
    FXuint arg2 = (FXuint) LAYOUT_TOP|LAYOUT_LEFT|LAYOUT_FILL_X ; FXint arg3 = (FXint) 0 ; FXint arg4 = (FXint) 0 ;
    FXint arg5 = (FXint) 0 ; FXint arg6 = (FXint) 0 ; FXint arg7 = (FXint) 3 ; FXint arg8 = (FXint) 3 ; FXint arg9 = (FXint) 2 ;
    FXint arg10 = (FXint) 2 ; FXint arg11 = (FXint) DEFAULT_SPACING ; FXint arg12 = (FXint) DEFAULT_SPACING ; FXMenuBar *result;
    if ((argc < 1) || (argc > 12)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXComposite, 1); if (argc > 1) { arg2 = NUM2UINT(argv[1]); } 
    if (argc > 2) { arg3 = NUM2INT(argv[2]); }  if (argc > 3) { arg4 = NUM2INT(argv[3]); }  if (argc > 4) {
        arg5 = NUM2INT(argv[4]); }  if (argc > 5) { arg6 = NUM2INT(argv[5]); }  if (argc > 6) { arg7 = NUM2INT(argv[6]); } 
    if (argc > 7) { arg8 = NUM2INT(argv[7]); }  if (argc > 8) { arg9 = NUM2INT(argv[8]); }  if (argc > 9) {
        arg10 = NUM2INT(argv[9]); }  if (argc > 10) { arg11 = NUM2INT(argv[10]); }  if (argc > 11) { arg12 = NUM2INT(argv[11]); }
     { result = (FXMenuBar *)new_FXMenuBar__SWIG_1(arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8,arg9,arg10,arg11,arg12);
        DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result); if(rb_block_given_p()){ rb_yield(self); }  }  return self; }
static VALUE _wrap_new_FXMenuBar(int nargs, VALUE *args, VALUE self) { int argc; VALUE argv[13]; int ii; argc = nargs;
    for (ii = 0; (ii < argc) && (ii < 13); ii++) { argv[ii] = args[ii]; }  if ((argc >= 1) && (argc <= 12)) { int _v; {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXComposite, 0) != -1)) ? 1 : 0; }
         if (_v) { if (argc <= 1) { return _wrap_new_FXMenuBar__SWIG_1(nargs, args, self);}  {
                _v = ((TYPE(argv[1]) == T_FIXNUM) || (TYPE(argv[1]) == T_BIGNUM)) ? 1 : 0; }  if (_v) { if (argc <= 2) {
                    return _wrap_new_FXMenuBar__SWIG_1(nargs, args, self);}  {
                    _v = ((TYPE(argv[2]) == T_FIXNUM) || (TYPE(argv[2]) == T_BIGNUM)) ? 1 : 0; }  if (_v) { if (argc <= 3) {
                        return _wrap_new_FXMenuBar__SWIG_1(nargs, args, self);}  {
                        _v = ((TYPE(argv[3]) == T_FIXNUM) || (TYPE(argv[3]) == T_BIGNUM)) ? 1 : 0; }  if (_v) { if (argc <= 4) {
                            return _wrap_new_FXMenuBar__SWIG_1(nargs, args, self);}  {
                            _v = ((TYPE(argv[4]) == T_FIXNUM) || (TYPE(argv[4]) == T_BIGNUM)) ? 1 : 0; }  if (_v) {
                            if (argc <= 5) { return _wrap_new_FXMenuBar__SWIG_1(nargs, args, self);}  {
                                _v = ((TYPE(argv[5]) == T_FIXNUM) || (TYPE(argv[5]) == T_BIGNUM)) ? 1 : 0; }  if (_v) {
                                if (argc <= 6) { return _wrap_new_FXMenuBar__SWIG_1(nargs, args, self);}  {
                                    _v = ((TYPE(argv[6]) == T_FIXNUM) || (TYPE(argv[6]) == T_BIGNUM)) ? 1 : 0; }  if (_v) {
                                    if (argc <= 7) { return _wrap_new_FXMenuBar__SWIG_1(nargs, args, self);}  {
                                        _v = ((TYPE(argv[7]) == T_FIXNUM) || (TYPE(argv[7]) == T_BIGNUM)) ? 1 : 0; }  if (_v) {
                                        if (argc <= 8) { return _wrap_new_FXMenuBar__SWIG_1(nargs, args, self);}  {
                                            _v = ((TYPE(argv[8]) == T_FIXNUM) || (TYPE(argv[8]) == T_BIGNUM)) ? 1 : 0; } 
                                        if (_v) { if (argc <= 9) { return _wrap_new_FXMenuBar__SWIG_1(nargs, args, self);}  {
                                                _v = ((TYPE(argv[9]) == T_FIXNUM) || (TYPE(argv[9]) == T_BIGNUM)) ? 1 : 0; } 
                                            if (_v) { if (argc <= 10) { return _wrap_new_FXMenuBar__SWIG_1(nargs, args, self);} 
                                                { _v = ((TYPE(argv[10]) == T_FIXNUM) || (TYPE(argv[10]) == T_BIGNUM)) ? 1 : 0; }
                                                 if (_v) { if (argc <= 11) {
                                                        return _wrap_new_FXMenuBar__SWIG_1(nargs, args, self);}  {
                                                        _v = ((TYPE(argv[11]) == T_FIXNUM) || (TYPE(argv[11]) == T_BIGNUM)) ? 1 : 0; }
                                                     if (_v) { return _wrap_new_FXMenuBar__SWIG_1(nargs, args, self);}  }  }  }
                                         }  }  }  }  }  }  }  }  }  if ((argc >= 2) && (argc <= 13)) { int _v; { void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXComposite, 0) != -1)) ? 1 : 0; }
         if (_v) { { void *ptr;
                _v = (NIL_P(argv[1]) || (TYPE(argv[1]) == T_DATA && SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_FXComposite, 0) != -1)) ? 1 : 0; }
             if (_v) { if (argc <= 2) { return _wrap_new_FXMenuBar__SWIG_0(nargs, args, self);}  {
                    _v = ((TYPE(argv[2]) == T_FIXNUM) || (TYPE(argv[2]) == T_BIGNUM)) ? 1 : 0; }  if (_v) { if (argc <= 3) {
                        return _wrap_new_FXMenuBar__SWIG_0(nargs, args, self);}  {
                        _v = ((TYPE(argv[3]) == T_FIXNUM) || (TYPE(argv[3]) == T_BIGNUM)) ? 1 : 0; }  if (_v) { if (argc <= 4) {
                            return _wrap_new_FXMenuBar__SWIG_0(nargs, args, self);}  {
                            _v = ((TYPE(argv[4]) == T_FIXNUM) || (TYPE(argv[4]) == T_BIGNUM)) ? 1 : 0; }  if (_v) {
                            if (argc <= 5) { return _wrap_new_FXMenuBar__SWIG_0(nargs, args, self);}  {
                                _v = ((TYPE(argv[5]) == T_FIXNUM) || (TYPE(argv[5]) == T_BIGNUM)) ? 1 : 0; }  if (_v) {
                                if (argc <= 6) { return _wrap_new_FXMenuBar__SWIG_0(nargs, args, self);}  {
                                    _v = ((TYPE(argv[6]) == T_FIXNUM) || (TYPE(argv[6]) == T_BIGNUM)) ? 1 : 0; }  if (_v) {
                                    if (argc <= 7) { return _wrap_new_FXMenuBar__SWIG_0(nargs, args, self);}  {
                                        _v = ((TYPE(argv[7]) == T_FIXNUM) || (TYPE(argv[7]) == T_BIGNUM)) ? 1 : 0; }  if (_v) {
                                        if (argc <= 8) { return _wrap_new_FXMenuBar__SWIG_0(nargs, args, self);}  {
                                            _v = ((TYPE(argv[8]) == T_FIXNUM) || (TYPE(argv[8]) == T_BIGNUM)) ? 1 : 0; } 
                                        if (_v) { if (argc <= 9) { return _wrap_new_FXMenuBar__SWIG_0(nargs, args, self);}  {
                                                _v = ((TYPE(argv[9]) == T_FIXNUM) || (TYPE(argv[9]) == T_BIGNUM)) ? 1 : 0; } 
                                            if (_v) { if (argc <= 10) { return _wrap_new_FXMenuBar__SWIG_0(nargs, args, self);} 
                                                { _v = ((TYPE(argv[10]) == T_FIXNUM) || (TYPE(argv[10]) == T_BIGNUM)) ? 1 : 0; }
                                                 if (_v) { if (argc <= 11) {
                                                        return _wrap_new_FXMenuBar__SWIG_0(nargs, args, self);}  {
                                                        _v = ((TYPE(argv[11]) == T_FIXNUM) || (TYPE(argv[11]) == T_BIGNUM)) ? 1 : 0; }
                                                     if (_v) { if (argc <= 12) {
                                                            return _wrap_new_FXMenuBar__SWIG_0(nargs, args, self);}  {
                                                            _v = ((TYPE(argv[12]) == T_FIXNUM) || (TYPE(argv[12]) == T_BIGNUM)) ? 1 : 0; }
                                                         if (_v) { return _wrap_new_FXMenuBar__SWIG_0(nargs, args, self);}  }  }
                                                 }  }  }  }  }  }  }  }  }  }  } 
    rb_raise(rb_eArgError, "No matching function for overloaded 'new_FXMenuBar'"); return Qnil; }
static void
free_FXMenuBar(FXMenuBar *arg1) {
    delete arg1;
}
static VALUE _wrap_FXMenuBar_save(int argc, VALUE *argv, VALUE self) { FXMenuBar *arg1 = (FXMenuBar *) 0 ; FXStream *arg2 = 0 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuBar, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXMenuBar_save((FXMenuBar const *)arg1,*arg2); return Qnil; }
static VALUE _wrap_FXMenuBar_load(int argc, VALUE *argv, VALUE self) { FXMenuBar *arg1 = (FXMenuBar *) 0 ; FXStream *arg2 = 0 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuBar, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXMenuBar_load(arg1,*arg2); return Qnil; }
static VALUE _wrap_FXMenuBar_create(int argc, VALUE *argv, VALUE self) { FXMenuBar *arg1 = (FXMenuBar *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuBar, 1); FXMenuBar_create(arg1); return Qnil; }
static VALUE _wrap_FXMenuBar_detach(int argc, VALUE *argv, VALUE self) { FXMenuBar *arg1 = (FXMenuBar *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuBar, 1); FXMenuBar_detach(arg1); return Qnil; }
static VALUE _wrap_FXMenuBar_destroy(int argc, VALUE *argv, VALUE self) { FXMenuBar *arg1 = (FXMenuBar *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuBar, 1); FXMenuBar_destroy(arg1); return Qnil; }
static VALUE _wrap_FXMenuBar_resize(int argc, VALUE *argv, VALUE self) { FXMenuBar *arg1 = (FXMenuBar *) 0 ; FXint arg2 ;
    FXint arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuBar, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    FXMenuBar_resize(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXMenuBar_getDefaultWidth(int argc, VALUE *argv, VALUE self) { FXMenuBar *arg1 = (FXMenuBar *) 0 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuBar, 1); result = (FXint)FXMenuBar_getDefaultWidth(arg1);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXMenuBar_getDefaultHeight(int argc, VALUE *argv, VALUE self) { FXMenuBar *arg1 = (FXMenuBar *) 0 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuBar, 1); result = (FXint)FXMenuBar_getDefaultHeight(arg1);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXMenuBar_getWidthForHeight(int argc, VALUE *argv, VALUE self) { FXMenuBar *arg1 = (FXMenuBar *) 0 ;
    FXint arg2 ; FXint result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuBar, 1); arg2 = NUM2INT(argv[0]);
    result = (FXint)FXMenuBar_getWidthForHeight(arg1,arg2); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXMenuBar_getHeightForWidth(int argc, VALUE *argv, VALUE self) { FXMenuBar *arg1 = (FXMenuBar *) 0 ;
    FXint arg2 ; FXint result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuBar, 1); arg2 = NUM2INT(argv[0]);
    result = (FXint)FXMenuBar_getHeightForWidth(arg1,arg2); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXMenuBar_canFocus(int argc, VALUE *argv, VALUE self) { FXMenuBar *arg1 = (FXMenuBar *) 0 ; FXbool result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuBar, 1);
    result = (FXbool)FXMenuBar_canFocus((FXMenuBar const *)arg1); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXMenuBar_setFocus(int argc, VALUE *argv, VALUE self) { FXMenuBar *arg1 = (FXMenuBar *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuBar, 1); FXMenuBar_setFocus(arg1); return Qnil; }
static VALUE _wrap_FXMenuBar_killFocus(int argc, VALUE *argv, VALUE self) { FXMenuBar *arg1 = (FXMenuBar *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuBar, 1); FXMenuBar_killFocus(arg1); return Qnil; }
static VALUE _wrap_FXMenuBar_setDefault(int argc, VALUE *argv, VALUE self) { FXMenuBar *arg1 = (FXMenuBar *) 0 ;
    FXbool arg2 = (FXbool) 1 ; if ((argc < 0) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuBar, 1); if (argc > 0) { arg2 = to_FXbool(argv[0]); } 
    FXMenuBar_setDefault(arg1,arg2); return Qnil; }
static VALUE _wrap_FXMenuBar_enable(int argc, VALUE *argv, VALUE self) { FXMenuBar *arg1 = (FXMenuBar *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuBar, 1); FXMenuBar_enable(arg1); return Qnil; }
static VALUE _wrap_FXMenuBar_disable(int argc, VALUE *argv, VALUE self) { FXMenuBar *arg1 = (FXMenuBar *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuBar, 1); FXMenuBar_disable(arg1); return Qnil; }
static VALUE _wrap_FXMenuBar_raiseWindow(int argc, VALUE *argv, VALUE self) { FXMenuBar *arg1 = (FXMenuBar *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuBar, 1); FXMenuBar_raise(arg1); return Qnil; }
static VALUE _wrap_FXMenuBar_lower(int argc, VALUE *argv, VALUE self) { FXMenuBar *arg1 = (FXMenuBar *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuBar, 1); FXMenuBar_lower(arg1); return Qnil; }
static VALUE _wrap_FXMenuBar_move(int argc, VALUE *argv, VALUE self) { FXMenuBar *arg1 = (FXMenuBar *) 0 ; FXint arg2 ;
    FXint arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuBar, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    FXMenuBar_move(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXMenuBar_position(int argc, VALUE *argv, VALUE self) { FXMenuBar *arg1 = (FXMenuBar *) 0 ; FXint arg2 ;
    FXint arg3 ; FXint arg4 ; FXint arg5 ; if ((argc < 4) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuBar, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    arg4 = NUM2INT(argv[2]); arg5 = NUM2INT(argv[3]); FXMenuBar_position(arg1,arg2,arg3,arg4,arg5); return Qnil; }
static VALUE _wrap_FXMenuBar_layout(int argc, VALUE *argv, VALUE self) { FXMenuBar *arg1 = (FXMenuBar *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuBar, 1); FXMenuBar_layout(arg1); return Qnil; }
static VALUE _wrap_FXMenuBar_recalc(int argc, VALUE *argv, VALUE self) { FXMenuBar *arg1 = (FXMenuBar *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuBar, 1); FXMenuBar_recalc(arg1); return Qnil; }
static VALUE _wrap_FXMenuBar_reparent(int argc, VALUE *argv, VALUE self) { FXMenuBar *arg1 = (FXMenuBar *) 0 ;
    FXComposite *arg2 = (FXComposite *) 0 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuBar, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXComposite, 1); FXMenuBar_reparent(arg1,arg2); return Qnil; }
static VALUE _wrap_FXMenuBar_show(int argc, VALUE *argv, VALUE self) { FXMenuBar *arg1 = (FXMenuBar *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuBar, 1); FXMenuBar_show(arg1); return Qnil; }
static VALUE _wrap_FXMenuBar_hide(int argc, VALUE *argv, VALUE self) { FXMenuBar *arg1 = (FXMenuBar *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuBar, 1); FXMenuBar_hide(arg1); return Qnil; }
static VALUE _wrap_FXMenuBar_isComposite(int argc, VALUE *argv, VALUE self) { FXMenuBar *arg1 = (FXMenuBar *) 0 ; FXbool result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuBar, 1);
    result = (FXbool)FXMenuBar_isComposite((FXMenuBar const *)arg1); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXMenuBar_contains(int argc, VALUE *argv, VALUE self) { FXMenuBar *arg1 = (FXMenuBar *) 0 ; FXint arg2 ;
    FXint arg3 ; FXbool result; VALUE vresult = Qnil; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuBar, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    result = (FXbool)FXMenuBar_contains((FXMenuBar const *)arg1,arg2,arg3); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXMenuBar_doesSaveUnder(int argc, VALUE *argv, VALUE self) { FXMenuBar *arg1 = (FXMenuBar *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuBar, 1);
    result = (FXbool)FXMenuBar_doesSaveUnder((FXMenuBar const *)arg1); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXMenuBar_setBackColor(int argc, VALUE *argv, VALUE self) { FXMenuBar *arg1 = (FXMenuBar *) 0 ;
    FXColor arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuBar, 1); arg2 = to_FXColor(argv[0]);
    FXMenuBar_setBackColor(arg1,arg2); return Qnil; }
static VALUE _wrap_FXMenuBar_dock(int argc, VALUE *argv, VALUE self) { FXMenuBar *arg1 = (FXMenuBar *) 0 ;
    FXuint arg2 = (FXuint) LAYOUT_SIDE_TOP ; FXWindow *arg3 = (FXWindow *) (FXWindow *) -1 ; if ((argc < 0) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuBar, 1); if (argc > 0) { arg2 = NUM2UINT(argv[0]); } 
    if (argc > 1) { { if (TYPE(argv[1]) == T_FIXNUM) {
                arg3 = reinterpret_cast<FXWindow *>(static_cast<long>(NUM2INT(argv[1]))); }  else {
                SWIG_ConvertPtr(argv[1], (void **) &arg3, SWIGTYPE_p_FXWindow, 1); }  }  }  FXMenuBar_dock(arg1,arg2,arg3);
    return Qnil; }
static VALUE _wrap_FXMenuBar_undock(int argc, VALUE *argv, VALUE self) { FXMenuBar *arg1 = (FXMenuBar *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuBar, 1); FXMenuBar_undock(arg1); return Qnil; }
static VALUE _wrap_FXMenuCheck_onPaint(int argc, VALUE *argv, VALUE self) { FXMenuCheck *arg1 = (FXMenuCheck *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuCheck, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onPaint(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXMenuCheck_onButtonPress(int argc, VALUE *argv, VALUE self) { FXMenuCheck *arg1 = (FXMenuCheck *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuCheck, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onButtonPress(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXMenuCheck_onButtonRelease(int argc, VALUE *argv, VALUE self) { FXMenuCheck *arg1 = (FXMenuCheck *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuCheck, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onButtonRelease(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXMenuCheck_onKeyPress(int argc, VALUE *argv, VALUE self) { FXMenuCheck *arg1 = (FXMenuCheck *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuCheck, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onKeyPress(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXMenuCheck_onKeyRelease(int argc, VALUE *argv, VALUE self) { FXMenuCheck *arg1 = (FXMenuCheck *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuCheck, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onKeyRelease(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXMenuCheck_onHotKeyPress(int argc, VALUE *argv, VALUE self) { FXMenuCheck *arg1 = (FXMenuCheck *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuCheck, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onHotKeyPress(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXMenuCheck_onHotKeyRelease(int argc, VALUE *argv, VALUE self) { FXMenuCheck *arg1 = (FXMenuCheck *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuCheck, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onHotKeyRelease(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXMenuCheck_onCheck(int argc, VALUE *argv, VALUE self) { FXMenuCheck *arg1 = (FXMenuCheck *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuCheck, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCheck(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXMenuCheck_onUncheck(int argc, VALUE *argv, VALUE self) { FXMenuCheck *arg1 = (FXMenuCheck *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuCheck, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onUncheck(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXMenuCheck_onUnknown(int argc, VALUE *argv, VALUE self) { FXMenuCheck *arg1 = (FXMenuCheck *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuCheck, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onUnknown(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXMenuCheck_onCmdSetValue(int argc, VALUE *argv, VALUE self) { FXMenuCheck *arg1 = (FXMenuCheck *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuCheck, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdSetValue(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXMenuCheck_onCmdSetIntValue(int argc, VALUE *argv, VALUE self) { FXMenuCheck *arg1 = (FXMenuCheck *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuCheck, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdSetIntValue(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXMenuCheck_onCmdGetIntValue(int argc, VALUE *argv, VALUE self) { FXMenuCheck *arg1 = (FXMenuCheck *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuCheck, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdGetIntValue(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXMenuCheck_onCmdAccel(int argc, VALUE *argv, VALUE self) { FXMenuCheck *arg1 = (FXMenuCheck *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuCheck, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdAccel(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE _wrap_FXMenuCheck_allocate(VALUE self) {
#else
     static VALUE _wrap_FXMenuCheck_allocate(int argc, VALUE *argv, VALUE self) {
#endif
         VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_FXMenuCheck);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
         return vresult; }
static VALUE _wrap_new_FXMenuCheck(int argc, VALUE *argv, VALUE self) { FXComposite *arg1 = (FXComposite *) 0 ;
    FXString *arg2 = 0 ; FXObject *arg3 = (FXObject *) 0 ; FXSelector arg4 = (FXSelector) 0 ; FXuint arg5 = (FXuint) 0 ;
    FXMenuCheck *result; SwigValueWrapper<FXString > p2 ; if ((argc < 2) || (argc > 5))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXComposite, 1); p2 = to_FXString(argv[1]); arg2 = &p2; if (argc > 2) {
        SWIG_ConvertPtr(argv[2], (void **) &arg3, SWIGTYPE_p_FXObject, 1); }  if (argc > 3) { arg4 = NUM2UINT(argv[3]); } 
    if (argc > 4) { arg5 = NUM2UINT(argv[4]); }  {
        result = (FXMenuCheck *)new_FXMenuCheck(arg1,(FXString const &)*arg2,arg3,arg4,arg5);
        DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result); if(rb_block_given_p()){ rb_yield(self); }  }  return self; }
static VALUE _wrap_FXMenuCheck_setCheck(int argc, VALUE *argv, VALUE self) { FXMenuCheck *arg1 = (FXMenuCheck *) 0 ;
    FXbool arg2 = (FXbool) 1 ; if ((argc < 0) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuCheck, 1); if (argc > 0) { arg2 = to_FXbool(argv[0]); } 
    (arg1)->setCheck(arg2); return Qnil; }
static VALUE _wrap_FXMenuCheck_getCheck(int argc, VALUE *argv, VALUE self) { FXMenuCheck *arg1 = (FXMenuCheck *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuCheck, 1); result = (FXbool)((FXMenuCheck const *)arg1)->getCheck();
    vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXMenuCheck_getBoxColor(int argc, VALUE *argv, VALUE self) { FXMenuCheck *arg1 = (FXMenuCheck *) 0 ;
    FXColor result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuCheck, 1);
    result = (FXColor)((FXMenuCheck const *)arg1)->getBoxColor(); vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXMenuCheck_setBoxColor(int argc, VALUE *argv, VALUE self) { FXMenuCheck *arg1 = (FXMenuCheck *) 0 ;
    FXColor arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuCheck, 1); arg2 = to_FXColor(argv[0]); (arg1)->setBoxColor(arg2);
    return Qnil; }
static void
free_FXMenuCheck(FXMenuCheck *arg1) {
    delete arg1;
}
static VALUE _wrap_FXMenuCheck_save(int argc, VALUE *argv, VALUE self) { FXMenuCheck *arg1 = (FXMenuCheck *) 0 ;
    FXStream *arg2 = 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuCheck, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXMenuCheck_save((FXMenuCheck const *)arg1,*arg2); return Qnil; }
static VALUE _wrap_FXMenuCheck_load(int argc, VALUE *argv, VALUE self) { FXMenuCheck *arg1 = (FXMenuCheck *) 0 ;
    FXStream *arg2 = 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuCheck, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXMenuCheck_load(arg1,*arg2); return Qnil; }
static VALUE _wrap_FXMenuCheck_create(int argc, VALUE *argv, VALUE self) { FXMenuCheck *arg1 = (FXMenuCheck *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuCheck, 1); FXMenuCheck_create(arg1); return Qnil; }
static VALUE _wrap_FXMenuCheck_detach(int argc, VALUE *argv, VALUE self) { FXMenuCheck *arg1 = (FXMenuCheck *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuCheck, 1); FXMenuCheck_detach(arg1); return Qnil; }
static VALUE _wrap_FXMenuCheck_destroy(int argc, VALUE *argv, VALUE self) { FXMenuCheck *arg1 = (FXMenuCheck *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuCheck, 1); FXMenuCheck_destroy(arg1); return Qnil; }
static VALUE _wrap_FXMenuCheck_resize(int argc, VALUE *argv, VALUE self) { FXMenuCheck *arg1 = (FXMenuCheck *) 0 ; FXint arg2 ;
    FXint arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuCheck, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    FXMenuCheck_resize(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXMenuCheck_getDefaultWidth(int argc, VALUE *argv, VALUE self) { FXMenuCheck *arg1 = (FXMenuCheck *) 0 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuCheck, 1); result = (FXint)FXMenuCheck_getDefaultWidth(arg1);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXMenuCheck_getDefaultHeight(int argc, VALUE *argv, VALUE self) { FXMenuCheck *arg1 = (FXMenuCheck *) 0 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuCheck, 1); result = (FXint)FXMenuCheck_getDefaultHeight(arg1);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXMenuCheck_getWidthForHeight(int argc, VALUE *argv, VALUE self) { FXMenuCheck *arg1 = (FXMenuCheck *) 0 ;
    FXint arg2 ; FXint result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuCheck, 1); arg2 = NUM2INT(argv[0]);
    result = (FXint)FXMenuCheck_getWidthForHeight(arg1,arg2); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXMenuCheck_getHeightForWidth(int argc, VALUE *argv, VALUE self) { FXMenuCheck *arg1 = (FXMenuCheck *) 0 ;
    FXint arg2 ; FXint result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuCheck, 1); arg2 = NUM2INT(argv[0]);
    result = (FXint)FXMenuCheck_getHeightForWidth(arg1,arg2); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXMenuCheck_canFocus(int argc, VALUE *argv, VALUE self) { FXMenuCheck *arg1 = (FXMenuCheck *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuCheck, 1);
    result = (FXbool)FXMenuCheck_canFocus((FXMenuCheck const *)arg1); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXMenuCheck_setFocus(int argc, VALUE *argv, VALUE self) { FXMenuCheck *arg1 = (FXMenuCheck *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuCheck, 1); FXMenuCheck_setFocus(arg1); return Qnil; }
static VALUE _wrap_FXMenuCheck_killFocus(int argc, VALUE *argv, VALUE self) { FXMenuCheck *arg1 = (FXMenuCheck *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuCheck, 1); FXMenuCheck_killFocus(arg1); return Qnil; }
static VALUE _wrap_FXMenuCheck_setDefault(int argc, VALUE *argv, VALUE self) { FXMenuCheck *arg1 = (FXMenuCheck *) 0 ;
    FXbool arg2 = (FXbool) 1 ; if ((argc < 0) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuCheck, 1); if (argc > 0) { arg2 = to_FXbool(argv[0]); } 
    FXMenuCheck_setDefault(arg1,arg2); return Qnil; }
static VALUE _wrap_FXMenuCheck_enable(int argc, VALUE *argv, VALUE self) { FXMenuCheck *arg1 = (FXMenuCheck *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuCheck, 1); FXMenuCheck_enable(arg1); return Qnil; }
static VALUE _wrap_FXMenuCheck_disable(int argc, VALUE *argv, VALUE self) { FXMenuCheck *arg1 = (FXMenuCheck *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuCheck, 1); FXMenuCheck_disable(arg1); return Qnil; }
static VALUE _wrap_FXMenuCheck_raiseWindow(int argc, VALUE *argv, VALUE self) { FXMenuCheck *arg1 = (FXMenuCheck *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuCheck, 1); FXMenuCheck_raise(arg1); return Qnil; }
static VALUE _wrap_FXMenuCheck_lower(int argc, VALUE *argv, VALUE self) { FXMenuCheck *arg1 = (FXMenuCheck *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuCheck, 1); FXMenuCheck_lower(arg1); return Qnil; }
static VALUE _wrap_FXMenuCheck_move(int argc, VALUE *argv, VALUE self) { FXMenuCheck *arg1 = (FXMenuCheck *) 0 ; FXint arg2 ;
    FXint arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuCheck, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    FXMenuCheck_move(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXMenuCheck_position(int argc, VALUE *argv, VALUE self) { FXMenuCheck *arg1 = (FXMenuCheck *) 0 ;
    FXint arg2 ; FXint arg3 ; FXint arg4 ; FXint arg5 ; if ((argc < 4) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuCheck, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    arg4 = NUM2INT(argv[2]); arg5 = NUM2INT(argv[3]); FXMenuCheck_position(arg1,arg2,arg3,arg4,arg5); return Qnil; }
static VALUE _wrap_FXMenuCheck_layout(int argc, VALUE *argv, VALUE self) { FXMenuCheck *arg1 = (FXMenuCheck *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuCheck, 1); FXMenuCheck_layout(arg1); return Qnil; }
static VALUE _wrap_FXMenuCheck_recalc(int argc, VALUE *argv, VALUE self) { FXMenuCheck *arg1 = (FXMenuCheck *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuCheck, 1); FXMenuCheck_recalc(arg1); return Qnil; }
static VALUE _wrap_FXMenuCheck_reparent(int argc, VALUE *argv, VALUE self) { FXMenuCheck *arg1 = (FXMenuCheck *) 0 ;
    FXComposite *arg2 = (FXComposite *) 0 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuCheck, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXComposite, 1); FXMenuCheck_reparent(arg1,arg2); return Qnil; }
static VALUE _wrap_FXMenuCheck_show(int argc, VALUE *argv, VALUE self) { FXMenuCheck *arg1 = (FXMenuCheck *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuCheck, 1); FXMenuCheck_show(arg1); return Qnil; }
static VALUE _wrap_FXMenuCheck_hide(int argc, VALUE *argv, VALUE self) { FXMenuCheck *arg1 = (FXMenuCheck *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuCheck, 1); FXMenuCheck_hide(arg1); return Qnil; }
static VALUE _wrap_FXMenuCheck_isComposite(int argc, VALUE *argv, VALUE self) { FXMenuCheck *arg1 = (FXMenuCheck *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuCheck, 1);
    result = (FXbool)FXMenuCheck_isComposite((FXMenuCheck const *)arg1); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXMenuCheck_contains(int argc, VALUE *argv, VALUE self) { FXMenuCheck *arg1 = (FXMenuCheck *) 0 ;
    FXint arg2 ; FXint arg3 ; FXbool result; VALUE vresult = Qnil; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuCheck, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    result = (FXbool)FXMenuCheck_contains((FXMenuCheck const *)arg1,arg2,arg3); vresult = result ? Qtrue : Qfalse;
    return vresult; }
static VALUE _wrap_FXMenuCheck_doesSaveUnder(int argc, VALUE *argv, VALUE self) { FXMenuCheck *arg1 = (FXMenuCheck *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuCheck, 1);
    result = (FXbool)FXMenuCheck_doesSaveUnder((FXMenuCheck const *)arg1); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXMenuCheck_setBackColor(int argc, VALUE *argv, VALUE self) { FXMenuCheck *arg1 = (FXMenuCheck *) 0 ;
    FXColor arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuCheck, 1); arg2 = to_FXColor(argv[0]);
    FXMenuCheck_setBackColor(arg1,arg2); return Qnil; }
static VALUE _wrap_FXMenuRadio_onPaint(int argc, VALUE *argv, VALUE self) { FXMenuRadio *arg1 = (FXMenuRadio *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuRadio, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onPaint(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXMenuRadio_onButtonPress(int argc, VALUE *argv, VALUE self) { FXMenuRadio *arg1 = (FXMenuRadio *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuRadio, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onButtonPress(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXMenuRadio_onButtonRelease(int argc, VALUE *argv, VALUE self) { FXMenuRadio *arg1 = (FXMenuRadio *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuRadio, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onButtonRelease(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXMenuRadio_onKeyPress(int argc, VALUE *argv, VALUE self) { FXMenuRadio *arg1 = (FXMenuRadio *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuRadio, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onKeyPress(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXMenuRadio_onKeyRelease(int argc, VALUE *argv, VALUE self) { FXMenuRadio *arg1 = (FXMenuRadio *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuRadio, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onKeyRelease(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXMenuRadio_onHotKeyPress(int argc, VALUE *argv, VALUE self) { FXMenuRadio *arg1 = (FXMenuRadio *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuRadio, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onHotKeyPress(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXMenuRadio_onHotKeyRelease(int argc, VALUE *argv, VALUE self) { FXMenuRadio *arg1 = (FXMenuRadio *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuRadio, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onHotKeyRelease(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXMenuRadio_onCheck(int argc, VALUE *argv, VALUE self) { FXMenuRadio *arg1 = (FXMenuRadio *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuRadio, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCheck(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXMenuRadio_onUncheck(int argc, VALUE *argv, VALUE self) { FXMenuRadio *arg1 = (FXMenuRadio *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuRadio, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onUncheck(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXMenuRadio_onUnknown(int argc, VALUE *argv, VALUE self) { FXMenuRadio *arg1 = (FXMenuRadio *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuRadio, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onUnknown(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXMenuRadio_onCmdSetValue(int argc, VALUE *argv, VALUE self) { FXMenuRadio *arg1 = (FXMenuRadio *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuRadio, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdSetValue(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXMenuRadio_onCmdSetIntValue(int argc, VALUE *argv, VALUE self) { FXMenuRadio *arg1 = (FXMenuRadio *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; FXint value4 ;
    VALUE vresult = Qnil; if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuRadio, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); {
        value4 = (FXint) NUM2INT(argv[2]); arg4 = static_cast<void*>(&value4); } 
    result = (long)(arg1)->onCmdSetIntValue(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXMenuRadio_onCmdGetIntValue(int argc, VALUE *argv, VALUE self) { FXMenuRadio *arg1 = (FXMenuRadio *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuRadio, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdGetIntValue(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXMenuRadio_onCmdAccel(int argc, VALUE *argv, VALUE self) { FXMenuRadio *arg1 = (FXMenuRadio *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuRadio, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdAccel(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE _wrap_FXMenuRadio_allocate(VALUE self) {
#else
     static VALUE _wrap_FXMenuRadio_allocate(int argc, VALUE *argv, VALUE self) {
#endif
         VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_FXMenuRadio);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
         return vresult; }
static VALUE _wrap_new_FXMenuRadio(int argc, VALUE *argv, VALUE self) { FXComposite *arg1 = (FXComposite *) 0 ;
    FXString *arg2 = 0 ; FXObject *arg3 = (FXObject *) 0 ; FXSelector arg4 = (FXSelector) 0 ; FXuint arg5 = (FXuint) 0 ;
    FXMenuRadio *result; SwigValueWrapper<FXString > p2 ; if ((argc < 2) || (argc > 5))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXComposite, 1); p2 = to_FXString(argv[1]); arg2 = &p2; if (argc > 2) {
        SWIG_ConvertPtr(argv[2], (void **) &arg3, SWIGTYPE_p_FXObject, 1); }  if (argc > 3) { arg4 = NUM2UINT(argv[3]); } 
    if (argc > 4) { arg5 = NUM2UINT(argv[4]); }  {
        result = (FXMenuRadio *)new_FXMenuRadio(arg1,(FXString const &)*arg2,arg3,arg4,arg5);
        DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result); if(rb_block_given_p()){ rb_yield(self); }  }  return self; }
static VALUE _wrap_FXMenuRadio_setCheck(int argc, VALUE *argv, VALUE self) { FXMenuRadio *arg1 = (FXMenuRadio *) 0 ;
    FXbool arg2 = (FXbool) 1 ; if ((argc < 0) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuRadio, 1); if (argc > 0) { arg2 = to_FXbool(argv[0]); } 
    (arg1)->setCheck(arg2); return Qnil; }
static VALUE _wrap_FXMenuRadio_getCheck(int argc, VALUE *argv, VALUE self) { FXMenuRadio *arg1 = (FXMenuRadio *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuRadio, 1); result = (FXbool)((FXMenuRadio const *)arg1)->getCheck();
    vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXMenuRadio_getRadioColor(int argc, VALUE *argv, VALUE self) { FXMenuRadio *arg1 = (FXMenuRadio *) 0 ;
    FXColor result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuRadio, 1);
    result = (FXColor)((FXMenuRadio const *)arg1)->getRadioColor(); vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXMenuRadio_setRadioColor(int argc, VALUE *argv, VALUE self) { FXMenuRadio *arg1 = (FXMenuRadio *) 0 ;
    FXColor arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuRadio, 1); arg2 = to_FXColor(argv[0]); (arg1)->setRadioColor(arg2);
    return Qnil; }
static void
free_FXMenuRadio(FXMenuRadio *arg1) {
    delete arg1;
}
static VALUE _wrap_FXMenuRadio_save(int argc, VALUE *argv, VALUE self) { FXMenuRadio *arg1 = (FXMenuRadio *) 0 ;
    FXStream *arg2 = 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuRadio, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXMenuRadio_save((FXMenuRadio const *)arg1,*arg2); return Qnil; }
static VALUE _wrap_FXMenuRadio_load(int argc, VALUE *argv, VALUE self) { FXMenuRadio *arg1 = (FXMenuRadio *) 0 ;
    FXStream *arg2 = 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuRadio, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXMenuRadio_load(arg1,*arg2); return Qnil; }
static VALUE _wrap_FXMenuRadio_create(int argc, VALUE *argv, VALUE self) { FXMenuRadio *arg1 = (FXMenuRadio *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuRadio, 1); FXMenuRadio_create(arg1); return Qnil; }
static VALUE _wrap_FXMenuRadio_detach(int argc, VALUE *argv, VALUE self) { FXMenuRadio *arg1 = (FXMenuRadio *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuRadio, 1); FXMenuRadio_detach(arg1); return Qnil; }
static VALUE _wrap_FXMenuRadio_destroy(int argc, VALUE *argv, VALUE self) { FXMenuRadio *arg1 = (FXMenuRadio *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuRadio, 1); FXMenuRadio_destroy(arg1); return Qnil; }
static VALUE _wrap_FXMenuRadio_resize(int argc, VALUE *argv, VALUE self) { FXMenuRadio *arg1 = (FXMenuRadio *) 0 ; FXint arg2 ;
    FXint arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuRadio, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    FXMenuRadio_resize(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXMenuRadio_getDefaultWidth(int argc, VALUE *argv, VALUE self) { FXMenuRadio *arg1 = (FXMenuRadio *) 0 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuRadio, 1); result = (FXint)FXMenuRadio_getDefaultWidth(arg1);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXMenuRadio_getDefaultHeight(int argc, VALUE *argv, VALUE self) { FXMenuRadio *arg1 = (FXMenuRadio *) 0 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuRadio, 1); result = (FXint)FXMenuRadio_getDefaultHeight(arg1);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXMenuRadio_getWidthForHeight(int argc, VALUE *argv, VALUE self) { FXMenuRadio *arg1 = (FXMenuRadio *) 0 ;
    FXint arg2 ; FXint result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuRadio, 1); arg2 = NUM2INT(argv[0]);
    result = (FXint)FXMenuRadio_getWidthForHeight(arg1,arg2); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXMenuRadio_getHeightForWidth(int argc, VALUE *argv, VALUE self) { FXMenuRadio *arg1 = (FXMenuRadio *) 0 ;
    FXint arg2 ; FXint result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuRadio, 1); arg2 = NUM2INT(argv[0]);
    result = (FXint)FXMenuRadio_getHeightForWidth(arg1,arg2); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXMenuRadio_canFocus(int argc, VALUE *argv, VALUE self) { FXMenuRadio *arg1 = (FXMenuRadio *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuRadio, 1);
    result = (FXbool)FXMenuRadio_canFocus((FXMenuRadio const *)arg1); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXMenuRadio_setFocus(int argc, VALUE *argv, VALUE self) { FXMenuRadio *arg1 = (FXMenuRadio *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuRadio, 1); FXMenuRadio_setFocus(arg1); return Qnil; }
static VALUE _wrap_FXMenuRadio_killFocus(int argc, VALUE *argv, VALUE self) { FXMenuRadio *arg1 = (FXMenuRadio *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuRadio, 1); FXMenuRadio_killFocus(arg1); return Qnil; }
static VALUE _wrap_FXMenuRadio_setDefault(int argc, VALUE *argv, VALUE self) { FXMenuRadio *arg1 = (FXMenuRadio *) 0 ;
    FXbool arg2 = (FXbool) 1 ; if ((argc < 0) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuRadio, 1); if (argc > 0) { arg2 = to_FXbool(argv[0]); } 
    FXMenuRadio_setDefault(arg1,arg2); return Qnil; }
static VALUE _wrap_FXMenuRadio_enable(int argc, VALUE *argv, VALUE self) { FXMenuRadio *arg1 = (FXMenuRadio *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuRadio, 1); FXMenuRadio_enable(arg1); return Qnil; }
static VALUE _wrap_FXMenuRadio_disable(int argc, VALUE *argv, VALUE self) { FXMenuRadio *arg1 = (FXMenuRadio *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuRadio, 1); FXMenuRadio_disable(arg1); return Qnil; }
static VALUE _wrap_FXMenuRadio_raiseWindow(int argc, VALUE *argv, VALUE self) { FXMenuRadio *arg1 = (FXMenuRadio *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuRadio, 1); FXMenuRadio_raise(arg1); return Qnil; }
static VALUE _wrap_FXMenuRadio_lower(int argc, VALUE *argv, VALUE self) { FXMenuRadio *arg1 = (FXMenuRadio *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuRadio, 1); FXMenuRadio_lower(arg1); return Qnil; }
static VALUE _wrap_FXMenuRadio_move(int argc, VALUE *argv, VALUE self) { FXMenuRadio *arg1 = (FXMenuRadio *) 0 ; FXint arg2 ;
    FXint arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuRadio, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    FXMenuRadio_move(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXMenuRadio_position(int argc, VALUE *argv, VALUE self) { FXMenuRadio *arg1 = (FXMenuRadio *) 0 ;
    FXint arg2 ; FXint arg3 ; FXint arg4 ; FXint arg5 ; if ((argc < 4) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuRadio, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    arg4 = NUM2INT(argv[2]); arg5 = NUM2INT(argv[3]); FXMenuRadio_position(arg1,arg2,arg3,arg4,arg5); return Qnil; }
static VALUE _wrap_FXMenuRadio_layout(int argc, VALUE *argv, VALUE self) { FXMenuRadio *arg1 = (FXMenuRadio *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuRadio, 1); FXMenuRadio_layout(arg1); return Qnil; }
static VALUE _wrap_FXMenuRadio_recalc(int argc, VALUE *argv, VALUE self) { FXMenuRadio *arg1 = (FXMenuRadio *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuRadio, 1); FXMenuRadio_recalc(arg1); return Qnil; }
static VALUE _wrap_FXMenuRadio_reparent(int argc, VALUE *argv, VALUE self) { FXMenuRadio *arg1 = (FXMenuRadio *) 0 ;
    FXComposite *arg2 = (FXComposite *) 0 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuRadio, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXComposite, 1); FXMenuRadio_reparent(arg1,arg2); return Qnil; }
static VALUE _wrap_FXMenuRadio_show(int argc, VALUE *argv, VALUE self) { FXMenuRadio *arg1 = (FXMenuRadio *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuRadio, 1); FXMenuRadio_show(arg1); return Qnil; }
static VALUE _wrap_FXMenuRadio_hide(int argc, VALUE *argv, VALUE self) { FXMenuRadio *arg1 = (FXMenuRadio *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuRadio, 1); FXMenuRadio_hide(arg1); return Qnil; }
static VALUE _wrap_FXMenuRadio_isComposite(int argc, VALUE *argv, VALUE self) { FXMenuRadio *arg1 = (FXMenuRadio *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuRadio, 1);
    result = (FXbool)FXMenuRadio_isComposite((FXMenuRadio const *)arg1); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXMenuRadio_contains(int argc, VALUE *argv, VALUE self) { FXMenuRadio *arg1 = (FXMenuRadio *) 0 ;
    FXint arg2 ; FXint arg3 ; FXbool result; VALUE vresult = Qnil; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuRadio, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    result = (FXbool)FXMenuRadio_contains((FXMenuRadio const *)arg1,arg2,arg3); vresult = result ? Qtrue : Qfalse;
    return vresult; }
static VALUE _wrap_FXMenuRadio_doesSaveUnder(int argc, VALUE *argv, VALUE self) { FXMenuRadio *arg1 = (FXMenuRadio *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuRadio, 1);
    result = (FXbool)FXMenuRadio_doesSaveUnder((FXMenuRadio const *)arg1); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXMenuRadio_setBackColor(int argc, VALUE *argv, VALUE self) { FXMenuRadio *arg1 = (FXMenuRadio *) 0 ;
    FXColor arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXMenuRadio, 1); arg2 = to_FXColor(argv[0]);
    FXMenuRadio_setBackColor(arg1,arg2); return Qnil; }

/* -------- TYPE CONVERSION AND EQUIVALENCE RULES (BEGIN) -------- */

static void *_p_FXMenuBarTo_p_FXToolBar(void *x) {
    return (void *)((FXToolBar *)  ((FXMenuBar *) x));
}
static void *_p_FXShutterItemTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *)(FXVerticalFrame *) ((FXShutterItem *) x));
}
static void *_p_FXColorBarTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXFrame *) ((FXColorBar *) x));
}
static void *_p_FXMenuCheckTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXMenuCaption *)(FXMenuCommand *) ((FXMenuCheck *) x));
}
static void *_p_FXTabBarTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXTabBar *) x));
}
static void *_p_FXSwitcherTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXSwitcher *) x));
}
static void *_p_FXTextFieldTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXFrame *) ((FXTextField *) x));
}
static void *_p_FXToolBarTabTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXFrame *) ((FXToolBarTab *) x));
}
static void *_p_FXDriveBoxTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *)(FXListBox *) ((FXDriveBox *) x));
}
static void *_p_FXMatrixTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXMatrix *) x));
}
static void *_p_FXScrollCornerTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *) ((FXScrollCorner *) x));
}
static void *_p_FXArrowButtonTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXFrame *) ((FXArrowButton *) x));
}
static void *_p_FXPopupTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXShell *) ((FXPopup *) x));
}
static void *_p_FXDrawableTo_p_FXId(void *x) {
    return (void *)((FXId *)  ((FXDrawable *) x));
}
static void *_p_FXMenuPaneTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXShell *)(FXPopup *) ((FXMenuPane *) x));
}
static void *_p_FXHeaderTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXFrame *) ((FXHeader *) x));
}
static void *_p_FXSplitterTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *) ((FXSplitter *) x));
}
static void *_p_FX4SplitterTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *) ((FX4Splitter *) x));
}
static void *_p_FXSpringTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXSpring *) x));
}
static void *_p_FXPackerTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *) ((FXPacker *) x));
}
static void *_p_FXTabBookTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *)(FXTabBar *) ((FXTabBook *) x));
}
static void *_p_FXImageFrameTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXFrame *) ((FXImageFrame *) x));
}
static void *_p_FXMenuSeparatorTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *) ((FXMenuSeparator *) x));
}
static void *_p_FXVerticalSeparatorTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXFrame *)(FXSeparator *) ((FXVerticalSeparator *) x));
}
static void *_p_FXHorizontalSeparatorTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXFrame *)(FXSeparator *) ((FXHorizontalSeparator *) x));
}
static void *_p_FXSeparatorTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXFrame *) ((FXSeparator *) x));
}
static void *_p_FXProgressBarTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXFrame *) ((FXProgressBar *) x));
}
static void *_p_FXShutterTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *)(FXVerticalFrame *) ((FXShutter *) x));
}
static void *_p_FXToolTipTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXShell *) ((FXToolTip *) x));
}
static void *_p_FXCompositeTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *) ((FXComposite *) x));
}
static void *_p_FXBitmapFrameTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXFrame *) ((FXBitmapFrame *) x));
}
static void *_p_FXRealSliderTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXFrame *) ((FXRealSlider *) x));
}
static void *_p_FXSliderTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXFrame *) ((FXSlider *) x));
}
static void *_p_FXMenuCascadeTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXMenuCaption *) ((FXMenuCascade *) x));
}
static void *_p_FXGroupBoxTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXGroupBox *) x));
}
static void *_p_FXTreeListBoxTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXTreeListBox *) x));
}
static void *_p_FXListBoxTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXListBox *) x));
}
static void *_p_FXCanvasTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *) ((FXCanvas *) x));
}
static void *_p_FXColorWheelTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXFrame *) ((FXColorWheel *) x));
}
static void *_p_FXVisualTo_p_FXId(void *x) {
    return (void *)((FXId *)  ((FXVisual *) x));
}
static void *_p_FXToolBarGripTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *) ((FXToolBarGrip *) x));
}
static void *_p_FXScrollBarTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *) ((FXScrollBar *) x));
}
static void *_p_FXFontTo_p_FXId(void *x) {
    return (void *)((FXId *)  ((FXFont *) x));
}
static void *_p_FXComboBoxTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXComboBox *) x));
}
static void *_p_FXFrameTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *) ((FXFrame *) x));
}
static void *_p_FXStatusBarTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *)(FXHorizontalFrame *) ((FXStatusBar *) x));
}
static void *_p_FXGIFCursorTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXCursor *) ((FXGIFCursor *) x));
}
static void *_p_FXCURCursorTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXCursor *) ((FXCURCursor *) x));
}
static void *_p_FXCursorTo_p_FXId(void *x) {
    return (void *)((FXId *)  ((FXCursor *) x));
}
static void *_p_FXMenuCommandTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXMenuCaption *) ((FXMenuCommand *) x));
}
static void *_p_FXRealSpinnerTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXRealSpinner *) x));
}
static void *_p_FXSpinnerTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXSpinner *) x));
}
static void *_p_FXMenuCaptionTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *) ((FXMenuCaption *) x));
}
static void *_p_FXMenuTitleTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXMenuCaption *) ((FXMenuTitle *) x));
}
static void *_p_FXStatusLineTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXFrame *) ((FXStatusLine *) x));
}
static void *_p_FXMainWindowTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXShell *)(FXTopWindow *) ((FXMainWindow *) x));
}
static void *_p_FXTopWindowTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXShell *) ((FXTopWindow *) x));
}
static void *_p_FXRootWindowTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *) ((FXRootWindow *) x));
}
static void *_p_FXWindowTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *) ((FXWindow *) x));
}
static void *_p_FXScrollWindowTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXScrollArea *) ((FXScrollWindow *) x));
}
static void *_p_FXMenuBarTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *)(FXToolBar *) ((FXMenuBar *) x));
}
static void *_p_FXMenuRadioTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXMenuCaption *)(FXMenuCommand *) ((FXMenuRadio *) x));
}
static void *_p_FXShellTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *) ((FXShell *) x));
}
static void *_p_FXScrollAreaTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *) ((FXScrollArea *) x));
}
static void *_p_FXColorWellTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXFrame *) ((FXColorWell *) x));
}
static void *_p_FXDragCornerTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *) ((FXDragCorner *) x));
}
static void *_p_FXRulerTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXFrame *) ((FXRuler *) x));
}
static void *_p_FXDialTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXFrame *) ((FXDial *) x));
}
static void *_p_FXHorizontalFrameTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXHorizontalFrame *) x));
}
static void *_p_FXVerticalFrameTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXVerticalFrame *) x));
}
static void *_p_FXImageViewTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXScrollArea *) ((FXImageView *) x));
}
static void *_p_FXFontSelectorTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXFontSelector *) x));
}
static void *_p_FXColorSelectorTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXColorSelector *) x));
}
static void *_p_FXFileSelectorTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXFileSelector *) x));
}
static void *_p_FXDirSelectorTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXDirSelector *) x));
}
static void *_p_FXToolBarShellTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXShell *)(FXTopWindow *) ((FXToolBarShell *) x));
}
static void *_p_FXToolBarTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXToolBar *) x));
}
static void *_p_FXScrollPaneTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXShell *)(FXPopup *)(FXMenuPane *) ((FXScrollPane *) x));
}
static void *_p_FXDirBoxTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *)(FXTreeListBox *) ((FXDirBox *) x));
}
static void *_p_FXDocumentTo_p_FXObject(void *x) {
    return (void *)((FXObject *)  ((FXDocument *) x));
}
static void *_p_FXRegistryTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXDict *)(FXSettings *) ((FXRegistry *) x));
}
static void *_p_FXHeaderItemTo_p_FXObject(void *x) {
    return (void *)((FXObject *)  ((FXHeaderItem *) x));
}
static void *_p_FXShutterItemTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *)(FXVerticalFrame *) ((FXShutterItem *) x));
}
static void *_p_FXColorBarTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXFrame *) ((FXColorBar *) x));
}
static void *_p_FXMenuCheckTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXMenuCaption *)(FXMenuCommand *) ((FXMenuCheck *) x));
}
static void *_p_FXTabBarTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXTabBar *) x));
}
static void *_p_FXSwitcherTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXSwitcher *) x));
}
static void *_p_FXTextFieldTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXFrame *) ((FXTextField *) x));
}
static void *_p_FXToolBarTabTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXFrame *) ((FXToolBarTab *) x));
}
static void *_p_FXDriveBoxTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *)(FXListBox *) ((FXDriveBox *) x));
}
static void *_p_FXIconDictTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXDict *) ((FXIconDict *) x));
}
static void *_p_FXMatrixTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXMatrix *) x));
}
static void *_p_FXFileDictTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXDict *) ((FXFileDict *) x));
}
static void *_p_FXRecentFilesTo_p_FXObject(void *x) {
    return (void *)((FXObject *)  ((FXRecentFiles *) x));
}
static void *_p_FXScrollCornerTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *) ((FXScrollCorner *) x));
}
static void *_p_FXArrowButtonTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXFrame *) ((FXArrowButton *) x));
}
static void *_p_FXPopupTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXShell *) ((FXPopup *) x));
}
static void *_p_FXDrawableTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *) ((FXDrawable *) x));
}
static void *_p_FXMenuPaneTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXShell *)(FXPopup *) ((FXMenuPane *) x));
}
static void *_p_FXAppTo_p_FXObject(void *x) {
    return (void *)((FXObject *)  ((FXApp *) x));
}
static void *_p_FXHeaderTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXFrame *) ((FXHeader *) x));
}
static void *_p_FX4SplitterTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *) ((FX4Splitter *) x));
}
static void *_p_FXSplitterTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *) ((FXSplitter *) x));
}
static void *_p_FXSpringTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXSpring *) x));
}
static void *_p_FXPackerTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *) ((FXPacker *) x));
}
static void *_p_FXTabBookTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *)(FXTabBar *) ((FXTabBook *) x));
}
static void *_p_FXImageFrameTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXFrame *) ((FXImageFrame *) x));
}
static void *_p_FXVerticalSeparatorTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXFrame *)(FXSeparator *) ((FXVerticalSeparator *) x));
}
static void *_p_FXHorizontalSeparatorTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXFrame *)(FXSeparator *) ((FXHorizontalSeparator *) x));
}
static void *_p_FXSeparatorTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXFrame *) ((FXSeparator *) x));
}
static void *_p_FXMenuSeparatorTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *) ((FXMenuSeparator *) x));
}
static void *_p_FXIdTo_p_FXObject(void *x) {
    return (void *)((FXObject *)  ((FXId *) x));
}
static void *_p_FXProgressBarTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXFrame *) ((FXProgressBar *) x));
}
static void *_p_FXShutterTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *)(FXVerticalFrame *) ((FXShutter *) x));
}
static void *_p_FXToolTipTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXShell *) ((FXToolTip *) x));
}
static void *_p_FXCompositeTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *) ((FXComposite *) x));
}
static void *_p_FXBitmapFrameTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXFrame *) ((FXBitmapFrame *) x));
}
static void *_p_FXRealSliderTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXFrame *) ((FXRealSlider *) x));
}
static void *_p_FXSliderTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXFrame *) ((FXSlider *) x));
}
static void *_p_FXSettingsTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXDict *) ((FXSettings *) x));
}
static void *_p_FXGroupBoxTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXGroupBox *) x));
}
static void *_p_FXMenuCascadeTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXMenuCaption *) ((FXMenuCascade *) x));
}
static void *_p_FXDebugTargetTo_p_FXObject(void *x) {
    return (void *)((FXObject *)  ((FXDebugTarget *) x));
}
static void *_p_FXDataTargetTo_p_FXObject(void *x) {
    return (void *)((FXObject *)  ((FXDataTarget *) x));
}
static void *_p_FXTreeListBoxTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXTreeListBox *) x));
}
static void *_p_FXListBoxTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXListBox *) x));
}
static void *_p_FXCanvasTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *) ((FXCanvas *) x));
}
static void *_p_FXColorWheelTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXFrame *) ((FXColorWheel *) x));
}
static void *_p_FXVisualTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *) ((FXVisual *) x));
}
static void *_p_FXScrollBarTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *) ((FXScrollBar *) x));
}
static void *_p_FXToolBarGripTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *) ((FXToolBarGrip *) x));
}
static void *_p_FXFontTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *) ((FXFont *) x));
}
static void *_p_FXComboBoxTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXComboBox *) x));
}
static void *_p_FXFrameTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *) ((FXFrame *) x));
}
static void *_p_FXStringDictTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXDict *) ((FXStringDict *) x));
}
static void *_p_FXStatusBarTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *)(FXHorizontalFrame *) ((FXStatusBar *) x));
}
static void *_p_FXDelegatorTo_p_FXObject(void *x) {
    return (void *)((FXObject *)  ((FXDelegator *) x));
}
static void *_p_FXAccelTableTo_p_FXObject(void *x) {
    return (void *)((FXObject *)  ((FXAccelTable *) x));
}
static void *_p_FXCursorTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *) ((FXCursor *) x));
}
static void *_p_FXCURCursorTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXCursor *) ((FXCURCursor *) x));
}
static void *_p_FXGIFCursorTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXCursor *) ((FXGIFCursor *) x));
}
static void *_p_FXMenuCommandTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXMenuCaption *) ((FXMenuCommand *) x));
}
static void *_p_FXRealSpinnerTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXRealSpinner *) x));
}
static void *_p_FXSpinnerTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXSpinner *) x));
}
static void *_p_FXStatusLineTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXFrame *) ((FXStatusLine *) x));
}
static void *_p_FXScrollWindowTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXScrollArea *) ((FXScrollWindow *) x));
}
static void *_p_FXWindowTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *) ((FXWindow *) x));
}
static void *_p_FXRootWindowTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *) ((FXRootWindow *) x));
}
static void *_p_FXTopWindowTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXShell *) ((FXTopWindow *) x));
}
static void *_p_FXMainWindowTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXShell *)(FXTopWindow *) ((FXMainWindow *) x));
}
static void *_p_FXMenuCaptionTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *) ((FXMenuCaption *) x));
}
static void *_p_FXMenuTitleTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXMenuCaption *) ((FXMenuTitle *) x));
}
static void *_p_FXMenuBarTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *)(FXToolBar *) ((FXMenuBar *) x));
}
static void *_p_FXMenuRadioTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXMenuCaption *)(FXMenuCommand *) ((FXMenuRadio *) x));
}
static void *_p_FXDictTo_p_FXObject(void *x) {
    return (void *)((FXObject *)  ((FXDict *) x));
}
static void *_p_FXShellTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *) ((FXShell *) x));
}
static void *_p_FXScrollAreaTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *) ((FXScrollArea *) x));
}
static void *_p_FXColorWellTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXFrame *) ((FXColorWell *) x));
}
static void *_p_FXDragCornerTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *) ((FXDragCorner *) x));
}
static void *_p_FXRulerTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXFrame *) ((FXRuler *) x));
}
static void *_p_FXDialTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXFrame *) ((FXDial *) x));
}
static void *_p_FXHorizontalFrameTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXHorizontalFrame *) x));
}
static void *_p_FXVerticalFrameTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXVerticalFrame *) x));
}
static void *_p_FXImageViewTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXScrollArea *) ((FXImageView *) x));
}
static void *_p_FXDirSelectorTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXDirSelector *) x));
}
static void *_p_FXFileSelectorTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXFileSelector *) x));
}
static void *_p_FXColorSelectorTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXColorSelector *) x));
}
static void *_p_FXFontSelectorTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXFontSelector *) x));
}
static void *_p_FXToolBarTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXToolBar *) x));
}
static void *_p_FXToolBarShellTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXShell *)(FXTopWindow *) ((FXToolBarShell *) x));
}
static void *_p_FXDirBoxTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *)(FXTreeListBox *) ((FXDirBox *) x));
}
static void *_p_FXScrollPaneTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXShell *)(FXPopup *)(FXMenuPane *) ((FXScrollPane *) x));
}
static void *_p_FXMenuPaneTo_p_FXPopup(void *x) {
    return (void *)((FXPopup *)  ((FXMenuPane *) x));
}
static void *_p_FXScrollPaneTo_p_FXPopup(void *x) {
    return (void *)((FXPopup *) (FXMenuPane *) ((FXScrollPane *) x));
}
static void *_p_FXMenuCommandTo_p_FXMenuCaption(void *x) {
    return (void *)((FXMenuCaption *)  ((FXMenuCommand *) x));
}
static void *_p_FXMenuCheckTo_p_FXMenuCaption(void *x) {
    return (void *)((FXMenuCaption *) (FXMenuCommand *) ((FXMenuCheck *) x));
}
static void *_p_FXMenuRadioTo_p_FXMenuCaption(void *x) {
    return (void *)((FXMenuCaption *) (FXMenuCommand *) ((FXMenuRadio *) x));
}
static void *_p_FXMenuTitleTo_p_FXMenuCaption(void *x) {
    return (void *)((FXMenuCaption *)  ((FXMenuTitle *) x));
}
static void *_p_FXMenuCascadeTo_p_FXMenuCaption(void *x) {
    return (void *)((FXMenuCaption *)  ((FXMenuCascade *) x));
}
static void *_p_FXDriveBoxTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXPacker *)(FXListBox *) ((FXDriveBox *) x));
}
static void *_p_FXMenuPaneTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXShell *)(FXPopup *) ((FXMenuPane *) x));
}
static void *_p_FXToolBarTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXPacker *) ((FXToolBar *) x));
}
static void *_p_FXMenuBarTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXPacker *)(FXToolBar *) ((FXMenuBar *) x));
}
static void *_p_FXCompositeTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *)  ((FXComposite *) x));
}
static void *_p_FXToolTipTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXShell *) ((FXToolTip *) x));
}
static void *_p_FXTextFieldTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXFrame *) ((FXTextField *) x));
}
static void *_p_FXTabBookTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXPacker *)(FXTabBar *) ((FXTabBook *) x));
}
static void *_p_FXArrowButtonTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXFrame *) ((FXArrowButton *) x));
}
static void *_p_FXGroupBoxTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXPacker *) ((FXGroupBox *) x));
}
static void *_p_FXShellTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *) ((FXShell *) x));
}
static void *_p_FXStatusBarTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXPacker *)(FXHorizontalFrame *) ((FXStatusBar *) x));
}
static void *_p_FXScrollAreaTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *) ((FXScrollArea *) x));
}
static void *_p_FXPopupTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXShell *) ((FXPopup *) x));
}
static void *_p_FXScrollWindowTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXScrollArea *) ((FXScrollWindow *) x));
}
static void *_p_FXRootWindowTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *) ((FXRootWindow *) x));
}
static void *_p_FXTopWindowTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXShell *) ((FXTopWindow *) x));
}
static void *_p_FXMainWindowTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXShell *)(FXTopWindow *) ((FXMainWindow *) x));
}
static void *_p_FXRulerTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXFrame *) ((FXRuler *) x));
}
static void *_p_FXCanvasTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *)  ((FXCanvas *) x));
}
static void *_p_FXScrollCornerTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *)  ((FXScrollCorner *) x));
}
static void *_p_FXVerticalSeparatorTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXFrame *)(FXSeparator *) ((FXVerticalSeparator *) x));
}
static void *_p_FXHorizontalSeparatorTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXFrame *)(FXSeparator *) ((FXHorizontalSeparator *) x));
}
static void *_p_FXSeparatorTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXFrame *) ((FXSeparator *) x));
}
static void *_p_FXStatusLineTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXFrame *) ((FXStatusLine *) x));
}
static void *_p_FXComboBoxTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXPacker *) ((FXComboBox *) x));
}
static void *_p_FXMenuSeparatorTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *)  ((FXMenuSeparator *) x));
}
static void *_p_FXHorizontalFrameTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXPacker *) ((FXHorizontalFrame *) x));
}
static void *_p_FXVerticalFrameTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXPacker *) ((FXVerticalFrame *) x));
}
static void *_p_FX4SplitterTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *) ((FX4Splitter *) x));
}
static void *_p_FXSplitterTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *) ((FXSplitter *) x));
}
static void *_p_FXMenuTitleTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXMenuCaption *) ((FXMenuTitle *) x));
}
static void *_p_FXMenuCascadeTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXMenuCaption *) ((FXMenuCascade *) x));
}
static void *_p_FXPackerTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *) ((FXPacker *) x));
}
static void *_p_FXSpinnerTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXPacker *) ((FXSpinner *) x));
}
static void *_p_FXRealSpinnerTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXPacker *) ((FXRealSpinner *) x));
}
static void *_p_FXScrollBarTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *)  ((FXScrollBar *) x));
}
static void *_p_FXMenuCaptionTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *)  ((FXMenuCaption *) x));
}
static void *_p_FXMenuCommandTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXMenuCaption *) ((FXMenuCommand *) x));
}
static void *_p_FXMenuRadioTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXMenuCaption *)(FXMenuCommand *) ((FXMenuRadio *) x));
}
static void *_p_FXColorWheelTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXFrame *) ((FXColorWheel *) x));
}
static void *_p_FXBitmapFrameTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXFrame *) ((FXBitmapFrame *) x));
}
static void *_p_FXDirBoxTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXPacker *)(FXTreeListBox *) ((FXDirBox *) x));
}
static void *_p_FXToolBarGripTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *)  ((FXToolBarGrip *) x));
}
static void *_p_FXImageFrameTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXFrame *) ((FXImageFrame *) x));
}
static void *_p_FXDragCornerTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *)  ((FXDragCorner *) x));
}
static void *_p_FXSwitcherTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXPacker *) ((FXSwitcher *) x));
}
static void *_p_FXDirSelectorTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXPacker *) ((FXDirSelector *) x));
}
static void *_p_FXFileSelectorTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXPacker *) ((FXFileSelector *) x));
}
static void *_p_FXColorSelectorTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXPacker *) ((FXColorSelector *) x));
}
static void *_p_FXFontSelectorTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXPacker *) ((FXFontSelector *) x));
}
static void *_p_FXShutterTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXPacker *)(FXVerticalFrame *) ((FXShutter *) x));
}
static void *_p_FXProgressBarTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXFrame *) ((FXProgressBar *) x));
}
static void *_p_FXListBoxTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXPacker *) ((FXListBox *) x));
}
static void *_p_FXTreeListBoxTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXPacker *) ((FXTreeListBox *) x));
}
static void *_p_FXHeaderTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXFrame *) ((FXHeader *) x));
}
static void *_p_FXMatrixTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXPacker *) ((FXMatrix *) x));
}
static void *_p_FXColorWellTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXFrame *) ((FXColorWell *) x));
}
static void *_p_FXShutterItemTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXPacker *)(FXVerticalFrame *) ((FXShutterItem *) x));
}
static void *_p_FXDialTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXFrame *) ((FXDial *) x));
}
static void *_p_FXToolBarTabTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXFrame *) ((FXToolBarTab *) x));
}
static void *_p_FXFrameTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *)  ((FXFrame *) x));
}
static void *_p_FXTabBarTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXPacker *) ((FXTabBar *) x));
}
static void *_p_FXMenuCheckTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXMenuCaption *)(FXMenuCommand *) ((FXMenuCheck *) x));
}
static void *_p_FXImageViewTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXScrollArea *) ((FXImageView *) x));
}
static void *_p_FXSliderTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXFrame *) ((FXSlider *) x));
}
static void *_p_FXRealSliderTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXFrame *) ((FXRealSlider *) x));
}
static void *_p_FXSpringTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXPacker *) ((FXSpring *) x));
}
static void *_p_FXColorBarTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXFrame *) ((FXColorBar *) x));
}
static void *_p_FXScrollPaneTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXShell *)(FXPopup *)(FXMenuPane *) ((FXScrollPane *) x));
}
static void *_p_FXToolBarShellTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXShell *)(FXTopWindow *) ((FXToolBarShell *) x));
}
static void *_p_FXDriveBoxTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXPacker *)(FXListBox *) ((FXDriveBox *) x));
}
static void *_p_FXMenuPaneTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXShell *)(FXPopup *) ((FXMenuPane *) x));
}
static void *_p_FXToolBarTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXPacker *) ((FXToolBar *) x));
}
static void *_p_FXMenuBarTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXPacker *)(FXToolBar *) ((FXMenuBar *) x));
}
static void *_p_FXToolTipTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXShell *) ((FXToolTip *) x));
}
static void *_p_FXTabBookTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXPacker *)(FXTabBar *) ((FXTabBook *) x));
}
static void *_p_FXGroupBoxTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXPacker *) ((FXGroupBox *) x));
}
static void *_p_FXShellTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *)  ((FXShell *) x));
}
static void *_p_FXStatusBarTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXPacker *)(FXHorizontalFrame *) ((FXStatusBar *) x));
}
static void *_p_FXScrollAreaTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *)  ((FXScrollArea *) x));
}
static void *_p_FXPopupTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXShell *) ((FXPopup *) x));
}
static void *_p_FXScrollWindowTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXScrollArea *) ((FXScrollWindow *) x));
}
static void *_p_FXRootWindowTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *)  ((FXRootWindow *) x));
}
static void *_p_FXTopWindowTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXShell *) ((FXTopWindow *) x));
}
static void *_p_FXMainWindowTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXShell *)(FXTopWindow *) ((FXMainWindow *) x));
}
static void *_p_FXComboBoxTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXPacker *) ((FXComboBox *) x));
}
static void *_p_FXHorizontalFrameTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXPacker *) ((FXHorizontalFrame *) x));
}
static void *_p_FXVerticalFrameTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXPacker *) ((FXVerticalFrame *) x));
}
static void *_p_FX4SplitterTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *)  ((FX4Splitter *) x));
}
static void *_p_FXSplitterTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *)  ((FXSplitter *) x));
}
static void *_p_FXRealSpinnerTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXPacker *) ((FXRealSpinner *) x));
}
static void *_p_FXSpinnerTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXPacker *) ((FXSpinner *) x));
}
static void *_p_FXPackerTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *)  ((FXPacker *) x));
}
static void *_p_FXDirBoxTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXPacker *)(FXTreeListBox *) ((FXDirBox *) x));
}
static void *_p_FXSwitcherTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXPacker *) ((FXSwitcher *) x));
}
static void *_p_FXColorSelectorTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXPacker *) ((FXColorSelector *) x));
}
static void *_p_FXFileSelectorTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXPacker *) ((FXFileSelector *) x));
}
static void *_p_FXDirSelectorTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXPacker *) ((FXDirSelector *) x));
}
static void *_p_FXFontSelectorTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXPacker *) ((FXFontSelector *) x));
}
static void *_p_FXShutterTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXPacker *)(FXVerticalFrame *) ((FXShutter *) x));
}
static void *_p_FXTreeListBoxTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXPacker *) ((FXTreeListBox *) x));
}
static void *_p_FXListBoxTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXPacker *) ((FXListBox *) x));
}
static void *_p_FXMatrixTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXPacker *) ((FXMatrix *) x));
}
static void *_p_FXShutterItemTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXPacker *)(FXVerticalFrame *) ((FXShutterItem *) x));
}
static void *_p_FXTabBarTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXPacker *) ((FXTabBar *) x));
}
static void *_p_FXImageViewTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXScrollArea *) ((FXImageView *) x));
}
static void *_p_FXSpringTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXPacker *) ((FXSpring *) x));
}
static void *_p_FXScrollPaneTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXShell *)(FXPopup *)(FXMenuPane *) ((FXScrollPane *) x));
}
static void *_p_FXToolBarShellTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXShell *)(FXTopWindow *) ((FXToolBarShell *) x));
}
static void *_p_FXPopupTo_p_FXShell(void *x) {
    return (void *)((FXShell *)  ((FXPopup *) x));
}
static void *_p_FXTopWindowTo_p_FXShell(void *x) {
    return (void *)((FXShell *)  ((FXTopWindow *) x));
}
static void *_p_FXMainWindowTo_p_FXShell(void *x) {
    return (void *)((FXShell *) (FXTopWindow *) ((FXMainWindow *) x));
}
static void *_p_FXToolTipTo_p_FXShell(void *x) {
    return (void *)((FXShell *)  ((FXToolTip *) x));
}
static void *_p_FXMenuPaneTo_p_FXShell(void *x) {
    return (void *)((FXShell *) (FXPopup *) ((FXMenuPane *) x));
}
static void *_p_FXToolBarShellTo_p_FXShell(void *x) {
    return (void *)((FXShell *) (FXTopWindow *) ((FXToolBarShell *) x));
}
static void *_p_FXScrollPaneTo_p_FXShell(void *x) {
    return (void *)((FXShell *) (FXPopup *)(FXMenuPane *) ((FXScrollPane *) x));
}
static void *_p_FXFileStreamTo_p_FXStream(void *x) {
    return (void *)((FXStream *)  ((FXFileStream *) x));
}
static void *_p_FXMemoryStreamTo_p_FXStream(void *x) {
    return (void *)((FXStream *)  ((FXMemoryStream *) x));
}
static void *_p_FXDriveBoxTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *)(FXListBox *) ((FXDriveBox *) x));
}
static void *_p_FXMenuPaneTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXShell *)(FXPopup *) ((FXMenuPane *) x));
}
static void *_p_FXToolBarTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *) ((FXToolBar *) x));
}
static void *_p_FXMenuBarTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *)(FXToolBar *) ((FXMenuBar *) x));
}
static void *_p_FXCompositeTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *) ((FXComposite *) x));
}
static void *_p_FXToolTipTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXShell *) ((FXToolTip *) x));
}
static void *_p_FXTextFieldTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXFrame *) ((FXTextField *) x));
}
static void *_p_FXTabBookTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *)(FXTabBar *) ((FXTabBook *) x));
}
static void *_p_FXArrowButtonTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXFrame *) ((FXArrowButton *) x));
}
static void *_p_FXGroupBoxTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *) ((FXGroupBox *) x));
}
static void *_p_FXShellTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *) ((FXShell *) x));
}
static void *_p_FXStatusBarTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *)(FXHorizontalFrame *) ((FXStatusBar *) x));
}
static void *_p_FXScrollAreaTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *) ((FXScrollArea *) x));
}
static void *_p_FXPopupTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXShell *) ((FXPopup *) x));
}
static void *_p_FXScrollWindowTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXScrollArea *) ((FXScrollWindow *) x));
}
static void *_p_FXWindowTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *)  ((FXWindow *) x));
}
static void *_p_FXRootWindowTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *) ((FXRootWindow *) x));
}
static void *_p_FXTopWindowTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXShell *) ((FXTopWindow *) x));
}
static void *_p_FXMainWindowTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXShell *)(FXTopWindow *) ((FXMainWindow *) x));
}
static void *_p_FXRulerTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXFrame *) ((FXRuler *) x));
}
static void *_p_FXCanvasTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *) ((FXCanvas *) x));
}
static void *_p_FXScrollCornerTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *) ((FXScrollCorner *) x));
}
static void *_p_FXHorizontalSeparatorTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXFrame *)(FXSeparator *) ((FXHorizontalSeparator *) x));
}
static void *_p_FXSeparatorTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXFrame *) ((FXSeparator *) x));
}
static void *_p_FXVerticalSeparatorTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXFrame *)(FXSeparator *) ((FXVerticalSeparator *) x));
}
static void *_p_FXStatusLineTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXFrame *) ((FXStatusLine *) x));
}
static void *_p_FXComboBoxTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *) ((FXComboBox *) x));
}
static void *_p_FXMenuSeparatorTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *) ((FXMenuSeparator *) x));
}
static void *_p_FXHorizontalFrameTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *) ((FXHorizontalFrame *) x));
}
static void *_p_FXVerticalFrameTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *) ((FXVerticalFrame *) x));
}
static void *_p_FX4SplitterTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *) ((FX4Splitter *) x));
}
static void *_p_FXSplitterTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *) ((FXSplitter *) x));
}
static void *_p_FXMenuTitleTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXMenuCaption *) ((FXMenuTitle *) x));
}
static void *_p_FXMenuCascadeTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXMenuCaption *) ((FXMenuCascade *) x));
}
static void *_p_FXPackerTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *) ((FXPacker *) x));
}
static void *_p_FXSpinnerTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *) ((FXSpinner *) x));
}
static void *_p_FXRealSpinnerTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *) ((FXRealSpinner *) x));
}
static void *_p_FXScrollBarTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *) ((FXScrollBar *) x));
}
static void *_p_FXMenuCaptionTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *) ((FXMenuCaption *) x));
}
static void *_p_FXMenuCommandTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXMenuCaption *) ((FXMenuCommand *) x));
}
static void *_p_FXMenuRadioTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXMenuCaption *)(FXMenuCommand *) ((FXMenuRadio *) x));
}
static void *_p_FXColorWheelTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXFrame *) ((FXColorWheel *) x));
}
static void *_p_FXBitmapFrameTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXFrame *) ((FXBitmapFrame *) x));
}
static void *_p_FXDirBoxTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *)(FXTreeListBox *) ((FXDirBox *) x));
}
static void *_p_FXToolBarGripTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *) ((FXToolBarGrip *) x));
}
static void *_p_FXImageFrameTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXFrame *) ((FXImageFrame *) x));
}
static void *_p_FXDragCornerTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *) ((FXDragCorner *) x));
}
static void *_p_FXSwitcherTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *) ((FXSwitcher *) x));
}
static void *_p_FXDirSelectorTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *) ((FXDirSelector *) x));
}
static void *_p_FXFileSelectorTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *) ((FXFileSelector *) x));
}
static void *_p_FXColorSelectorTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *) ((FXColorSelector *) x));
}
static void *_p_FXFontSelectorTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *) ((FXFontSelector *) x));
}
static void *_p_FXShutterTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *)(FXVerticalFrame *) ((FXShutter *) x));
}
static void *_p_FXProgressBarTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXFrame *) ((FXProgressBar *) x));
}
static void *_p_FXListBoxTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *) ((FXListBox *) x));
}
static void *_p_FXTreeListBoxTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *) ((FXTreeListBox *) x));
}
static void *_p_FXHeaderTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXFrame *) ((FXHeader *) x));
}
static void *_p_FXMatrixTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *) ((FXMatrix *) x));
}
static void *_p_FXColorWellTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXFrame *) ((FXColorWell *) x));
}
static void *_p_FXShutterItemTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *)(FXVerticalFrame *) ((FXShutterItem *) x));
}
static void *_p_FXDialTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXFrame *) ((FXDial *) x));
}
static void *_p_FXToolBarTabTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXFrame *) ((FXToolBarTab *) x));
}
static void *_p_FXFrameTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *) ((FXFrame *) x));
}
static void *_p_FXTabBarTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *) ((FXTabBar *) x));
}
static void *_p_FXMenuCheckTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXMenuCaption *)(FXMenuCommand *) ((FXMenuCheck *) x));
}
static void *_p_FXImageViewTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXScrollArea *) ((FXImageView *) x));
}
static void *_p_FXSliderTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXFrame *) ((FXSlider *) x));
}
static void *_p_FXRealSliderTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXFrame *) ((FXRealSlider *) x));
}
static void *_p_FXSpringTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *) ((FXSpring *) x));
}
static void *_p_FXColorBarTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXFrame *) ((FXColorBar *) x));
}
static void *_p_FXScrollPaneTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXShell *)(FXPopup *)(FXMenuPane *) ((FXScrollPane *) x));
}
static void *_p_FXToolBarShellTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXShell *)(FXTopWindow *) ((FXToolBarShell *) x));
}
static void *_p_FXToolBarTo_p_FXPacker(void *x) {
    return (void *)((FXPacker *)  ((FXToolBar *) x));
}
static void *_p_FXListBoxTo_p_FXPacker(void *x) {
    return (void *)((FXPacker *)  ((FXListBox *) x));
}
static void *_p_FXTreeListBoxTo_p_FXPacker(void *x) {
    return (void *)((FXPacker *)  ((FXTreeListBox *) x));
}
static void *_p_FXComboBoxTo_p_FXPacker(void *x) {
    return (void *)((FXPacker *)  ((FXComboBox *) x));
}
static void *_p_FXShutterItemTo_p_FXPacker(void *x) {
    return (void *)((FXPacker *) (FXVerticalFrame *) ((FXShutterItem *) x));
}
static void *_p_FXStatusBarTo_p_FXPacker(void *x) {
    return (void *)((FXPacker *) (FXHorizontalFrame *) ((FXStatusBar *) x));
}
static void *_p_FXDirBoxTo_p_FXPacker(void *x) {
    return (void *)((FXPacker *) (FXTreeListBox *) ((FXDirBox *) x));
}
static void *_p_FXTabBarTo_p_FXPacker(void *x) {
    return (void *)((FXPacker *)  ((FXTabBar *) x));
}
static void *_p_FXTabBookTo_p_FXPacker(void *x) {
    return (void *)((FXPacker *) (FXTabBar *) ((FXTabBook *) x));
}
static void *_p_FXGroupBoxTo_p_FXPacker(void *x) {
    return (void *)((FXPacker *)  ((FXGroupBox *) x));
}
static void *_p_FXShutterTo_p_FXPacker(void *x) {
    return (void *)((FXPacker *) (FXVerticalFrame *) ((FXShutter *) x));
}
static void *_p_FXVerticalFrameTo_p_FXPacker(void *x) {
    return (void *)((FXPacker *)  ((FXVerticalFrame *) x));
}
static void *_p_FXHorizontalFrameTo_p_FXPacker(void *x) {
    return (void *)((FXPacker *)  ((FXHorizontalFrame *) x));
}
static void *_p_FXRealSpinnerTo_p_FXPacker(void *x) {
    return (void *)((FXPacker *)  ((FXRealSpinner *) x));
}
static void *_p_FXSpinnerTo_p_FXPacker(void *x) {
    return (void *)((FXPacker *)  ((FXSpinner *) x));
}
static void *_p_FXMatrixTo_p_FXPacker(void *x) {
    return (void *)((FXPacker *)  ((FXMatrix *) x));
}
static void *_p_FXSpringTo_p_FXPacker(void *x) {
    return (void *)((FXPacker *)  ((FXSpring *) x));
}
static void *_p_FXDirSelectorTo_p_FXPacker(void *x) {
    return (void *)((FXPacker *)  ((FXDirSelector *) x));
}
static void *_p_FXFileSelectorTo_p_FXPacker(void *x) {
    return (void *)((FXPacker *)  ((FXFileSelector *) x));
}
static void *_p_FXColorSelectorTo_p_FXPacker(void *x) {
    return (void *)((FXPacker *)  ((FXColorSelector *) x));
}
static void *_p_FXFontSelectorTo_p_FXPacker(void *x) {
    return (void *)((FXPacker *)  ((FXFontSelector *) x));
}
static void *_p_FXDriveBoxTo_p_FXPacker(void *x) {
    return (void *)((FXPacker *) (FXListBox *) ((FXDriveBox *) x));
}
static void *_p_FXMenuBarTo_p_FXPacker(void *x) {
    return (void *)((FXPacker *) (FXToolBar *) ((FXMenuBar *) x));
}
static void *_p_FXSwitcherTo_p_FXPacker(void *x) {
    return (void *)((FXPacker *)  ((FXSwitcher *) x));
}
static void *_p_FXMenuCheckTo_p_FXMenuCommand(void *x) {
    return (void *)((FXMenuCommand *)  ((FXMenuCheck *) x));
}
static void *_p_FXMenuRadioTo_p_FXMenuCommand(void *x) {
    return (void *)((FXMenuCommand *)  ((FXMenuRadio *) x));
}
static void *_p_FXScrollPaneTo_p_FXMenuPane(void *x) {
    return (void *)((FXMenuPane *)  ((FXScrollPane *) x));
}
static swig_type_info _swigt__p_FXToolBar[] = {{"_p_FXToolBar", 0, "FXToolBar *", 0, 0, 0, 0},{"_p_FXMenuBar", _p_FXMenuBarTo_p_FXToolBar, 0, 0, 0, 0, 0},{"_p_FXToolBar", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXObject[] = {{"_p_FXObject", 0, "FXObject *", 0, 0, 0, 0},{"_p_FXDocument", _p_FXDocumentTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXRegistry", _p_FXRegistryTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXHeaderItem", _p_FXHeaderItemTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXShutterItem", _p_FXShutterItemTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXColorBar", _p_FXColorBarTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXMenuCheck", _p_FXMenuCheckTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXTabBar", _p_FXTabBarTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXSwitcher", _p_FXSwitcherTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXTextField", _p_FXTextFieldTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXToolBarTab", _p_FXToolBarTabTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXDriveBox", _p_FXDriveBoxTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXIconDict", _p_FXIconDictTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXMatrix", _p_FXMatrixTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXFileDict", _p_FXFileDictTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXRecentFiles", _p_FXRecentFilesTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXScrollCorner", _p_FXScrollCornerTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXArrowButton", _p_FXArrowButtonTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXPopup", _p_FXPopupTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXDrawable", _p_FXDrawableTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXMenuPane", _p_FXMenuPaneTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXFont", _p_FXFontTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FX4Splitter", _p_FX4SplitterTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXSplitter", _p_FXSplitterTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXHeader", _p_FXHeaderTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXSpring", _p_FXSpringTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXPacker", _p_FXPackerTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXTabBook", _p_FXTabBookTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXApp", _p_FXAppTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXImageFrame", _p_FXImageFrameTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXVerticalSeparator", _p_FXVerticalSeparatorTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXHorizontalSeparator", _p_FXHorizontalSeparatorTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXSeparator", _p_FXSeparatorTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXMenuSeparator", _p_FXMenuSeparatorTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXProgressBar", _p_FXProgressBarTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXShutter", _p_FXShutterTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXToolTip", _p_FXToolTipTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXComposite", _p_FXCompositeTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXDict", _p_FXDictTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXBitmapFrame", _p_FXBitmapFrameTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXSlider", _p_FXSliderTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXRealSlider", _p_FXRealSliderTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXSettings", _p_FXSettingsTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXMenuCascade", _p_FXMenuCascadeTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXGroupBox", _p_FXGroupBoxTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXDataTarget", _p_FXDataTargetTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXDebugTarget", _p_FXDebugTargetTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXListBox", _p_FXListBoxTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXTreeListBox", _p_FXTreeListBoxTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXCanvas", _p_FXCanvasTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXId", _p_FXIdTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXColorWheel", _p_FXColorWheelTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXDial", _p_FXDialTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXToolBarGrip", _p_FXToolBarGripTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXScrollBar", _p_FXScrollBarTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXVisual", _p_FXVisualTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXComboBox", _p_FXComboBoxTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXFrame", _p_FXFrameTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXStatusBar", _p_FXStatusBarTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXStringDict", _p_FXStringDictTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXDelegator", _p_FXDelegatorTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXAccelTable", _p_FXAccelTableTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXObject", 0, 0, 0, 0, 0, 0},{"_p_FXCursor", _p_FXCursorTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXCURCursor", _p_FXCURCursorTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXGIFCursor", _p_FXGIFCursorTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXMenuCommand", _p_FXMenuCommandTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXRealSpinner", _p_FXRealSpinnerTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXSpinner", _p_FXSpinnerTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXMenuCaption", _p_FXMenuCaptionTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXMenuTitle", _p_FXMenuTitleTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXStatusLine", _p_FXStatusLineTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXWindow", _p_FXWindowTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXRootWindow", _p_FXRootWindowTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXScrollWindow", _p_FXScrollWindowTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXTopWindow", _p_FXTopWindowTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXMainWindow", _p_FXMainWindowTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXMenuBar", _p_FXMenuBarTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXMenuRadio", _p_FXMenuRadioTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXShell", _p_FXShellTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXScrollArea", _p_FXScrollAreaTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXDragCorner", _p_FXDragCornerTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXColorWell", _p_FXColorWellTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXRuler", _p_FXRulerTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXHorizontalFrame", _p_FXHorizontalFrameTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXVerticalFrame", _p_FXVerticalFrameTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXImageView", _p_FXImageViewTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXFontSelector", _p_FXFontSelectorTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXColorSelector", _p_FXColorSelectorTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXFileSelector", _p_FXFileSelectorTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXDirSelector", _p_FXDirSelectorTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXToolBarShell", _p_FXToolBarShellTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXToolBar", _p_FXToolBarTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXScrollPane", _p_FXScrollPaneTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXDirBox", _p_FXDirBoxTo_p_FXObject, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXPopup[] = {{"_p_FXPopup", 0, "FXPopup *", 0, 0, 0, 0},{"_p_FXPopup", 0, 0, 0, 0, 0, 0},{"_p_FXMenuPane", _p_FXMenuPaneTo_p_FXPopup, 0, 0, 0, 0, 0},{"_p_FXScrollPane", _p_FXScrollPaneTo_p_FXPopup, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXMenuCaption[] = {{"_p_FXMenuCaption", 0, "FXMenuCaption *", 0, 0, 0, 0},{"_p_FXMenuCaption", 0, 0, 0, 0, 0, 0},{"_p_FXMenuCommand", _p_FXMenuCommandTo_p_FXMenuCaption, 0, 0, 0, 0, 0},{"_p_FXMenuCheck", _p_FXMenuCheckTo_p_FXMenuCaption, 0, 0, 0, 0, 0},{"_p_FXMenuRadio", _p_FXMenuRadioTo_p_FXMenuCaption, 0, 0, 0, 0, 0},{"_p_FXMenuTitle", _p_FXMenuTitleTo_p_FXMenuCaption, 0, 0, 0, 0, 0},{"_p_FXMenuCascade", _p_FXMenuCascadeTo_p_FXMenuCaption, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXScrollPane[] = {{"_p_FXScrollPane", 0, "FXScrollPane *", 0, 0, 0, 0},{"_p_FXScrollPane", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXWindow[] = {{"_p_FXWindow", 0, "FXWindow *", 0, 0, 0, 0},{"_p_FXDriveBox", _p_FXDriveBoxTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXMenuPane", _p_FXMenuPaneTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXDial", _p_FXDialTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXMenuBar", _p_FXMenuBarTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXToolBar", _p_FXToolBarTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXComposite", _p_FXCompositeTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXToolTip", _p_FXToolTipTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXTabBook", _p_FXTabBookTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXTextField", _p_FXTextFieldTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXArrowButton", _p_FXArrowButtonTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXGroupBox", _p_FXGroupBoxTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXShell", _p_FXShellTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXStatusBar", _p_FXStatusBarTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXScrollArea", _p_FXScrollAreaTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXPopup", _p_FXPopupTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXRootWindow", _p_FXRootWindowTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXScrollWindow", _p_FXScrollWindowTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXMainWindow", _p_FXMainWindowTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXWindow", 0, 0, 0, 0, 0, 0},{"_p_FXTopWindow", _p_FXTopWindowTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXScrollCorner", _p_FXScrollCornerTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXRuler", _p_FXRulerTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXCanvas", _p_FXCanvasTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXComboBox", _p_FXComboBoxTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXMenuSeparator", _p_FXMenuSeparatorTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXSeparator", _p_FXSeparatorTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXHorizontalSeparator", _p_FXHorizontalSeparatorTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXVerticalSeparator", _p_FXVerticalSeparatorTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXStatusLine", _p_FXStatusLineTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXHorizontalFrame", _p_FXHorizontalFrameTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXVerticalFrame", _p_FXVerticalFrameTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FX4Splitter", _p_FX4SplitterTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXSplitter", _p_FXSplitterTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXMenuTitle", _p_FXMenuTitleTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXMenuCascade", _p_FXMenuCascadeTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXRealSpinner", _p_FXRealSpinnerTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXSpinner", _p_FXSpinnerTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXPacker", _p_FXPackerTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXScrollBar", _p_FXScrollBarTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXMenuCaption", _p_FXMenuCaptionTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXMenuCommand", _p_FXMenuCommandTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXMenuRadio", _p_FXMenuRadioTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXColorWheel", _p_FXColorWheelTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXBitmapFrame", _p_FXBitmapFrameTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXDirBox", _p_FXDirBoxTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXToolBarGrip", _p_FXToolBarGripTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXImageFrame", _p_FXImageFrameTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXDragCorner", _p_FXDragCornerTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXDirSelector", _p_FXDirSelectorTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXFileSelector", _p_FXFileSelectorTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXColorSelector", _p_FXColorSelectorTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXFontSelector", _p_FXFontSelectorTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXSwitcher", _p_FXSwitcherTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXShutter", _p_FXShutterTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXProgressBar", _p_FXProgressBarTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXListBox", _p_FXListBoxTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXTreeListBox", _p_FXTreeListBoxTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXHeader", _p_FXHeaderTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXShutterItem", _p_FXShutterItemTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXMatrix", _p_FXMatrixTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXColorWell", _p_FXColorWellTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXToolBarTab", _p_FXToolBarTabTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXTabBar", _p_FXTabBarTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXMenuCheck", _p_FXMenuCheckTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXFrame", _p_FXFrameTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXImageView", _p_FXImageViewTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXSlider", _p_FXSliderTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXRealSlider", _p_FXRealSliderTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXSpring", _p_FXSpringTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXColorBar", _p_FXColorBarTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXScrollPane", _p_FXScrollPaneTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXToolBarShell", _p_FXToolBarShellTo_p_FXWindow, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXComposite[] = {{"_p_FXComposite", 0, "FXComposite *", 0, 0, 0, 0},{"_p_FXDriveBox", _p_FXDriveBoxTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXMenuPane", _p_FXMenuPaneTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXMenuBar", _p_FXMenuBarTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXToolBar", _p_FXToolBarTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXComposite", 0, 0, 0, 0, 0, 0},{"_p_FXToolTip", _p_FXToolTipTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXTabBook", _p_FXTabBookTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXGroupBox", _p_FXGroupBoxTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXShell", _p_FXShellTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXStatusBar", _p_FXStatusBarTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXScrollArea", _p_FXScrollAreaTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXPopup", _p_FXPopupTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXRootWindow", _p_FXRootWindowTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXScrollWindow", _p_FXScrollWindowTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXTopWindow", _p_FXTopWindowTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXMainWindow", _p_FXMainWindowTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXComboBox", _p_FXComboBoxTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXHorizontalFrame", _p_FXHorizontalFrameTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXVerticalFrame", _p_FXVerticalFrameTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FX4Splitter", _p_FX4SplitterTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXSplitter", _p_FXSplitterTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXRealSpinner", _p_FXRealSpinnerTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXSpinner", _p_FXSpinnerTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXPacker", _p_FXPackerTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXDirBox", _p_FXDirBoxTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXDirSelector", _p_FXDirSelectorTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXFileSelector", _p_FXFileSelectorTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXColorSelector", _p_FXColorSelectorTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXFontSelector", _p_FXFontSelectorTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXSwitcher", _p_FXSwitcherTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXShutter", _p_FXShutterTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXListBox", _p_FXListBoxTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXTreeListBox", _p_FXTreeListBoxTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXMatrix", _p_FXMatrixTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXShutterItem", _p_FXShutterItemTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXTabBar", _p_FXTabBarTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXImageView", _p_FXImageViewTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXSpring", _p_FXSpringTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXScrollPane", _p_FXScrollPaneTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXToolBarShell", _p_FXToolBarShellTo_p_FXComposite, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXId[] = {{"_p_FXId", 0, "FXId *", 0, 0, 0, 0},{"_p_FXShutterItem", _p_FXShutterItemTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXColorBar", _p_FXColorBarTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXMenuCheck", _p_FXMenuCheckTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXTabBar", _p_FXTabBarTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXSwitcher", _p_FXSwitcherTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXTextField", _p_FXTextFieldTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXToolBarTab", _p_FXToolBarTabTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXDriveBox", _p_FXDriveBoxTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXMatrix", _p_FXMatrixTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXScrollCorner", _p_FXScrollCornerTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXArrowButton", _p_FXArrowButtonTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXPopup", _p_FXPopupTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXDrawable", _p_FXDrawableTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXMenuPane", _p_FXMenuPaneTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXFont", _p_FXFontTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXHeader", _p_FXHeaderTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FX4Splitter", _p_FX4SplitterTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXSplitter", _p_FXSplitterTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXSpring", _p_FXSpringTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXPacker", _p_FXPackerTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXTabBook", _p_FXTabBookTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXImageFrame", _p_FXImageFrameTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXVerticalSeparator", _p_FXVerticalSeparatorTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXHorizontalSeparator", _p_FXHorizontalSeparatorTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXSeparator", _p_FXSeparatorTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXMenuSeparator", _p_FXMenuSeparatorTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXProgressBar", _p_FXProgressBarTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXShutter", _p_FXShutterTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXToolTip", _p_FXToolTipTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXComposite", _p_FXCompositeTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXBitmapFrame", _p_FXBitmapFrameTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXRealSlider", _p_FXRealSliderTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXSlider", _p_FXSliderTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXMenuCascade", _p_FXMenuCascadeTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXGroupBox", _p_FXGroupBoxTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXListBox", _p_FXListBoxTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXTreeListBox", _p_FXTreeListBoxTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXCanvas", _p_FXCanvasTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXId", 0, 0, 0, 0, 0, 0},{"_p_FXColorWheel", _p_FXColorWheelTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXDial", _p_FXDialTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXToolBarGrip", _p_FXToolBarGripTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXScrollBar", _p_FXScrollBarTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXVisual", _p_FXVisualTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXComboBox", _p_FXComboBoxTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXFrame", _p_FXFrameTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXStatusBar", _p_FXStatusBarTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXCursor", _p_FXCursorTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXCURCursor", _p_FXCURCursorTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXGIFCursor", _p_FXGIFCursorTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXMenuCommand", _p_FXMenuCommandTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXRealSpinner", _p_FXRealSpinnerTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXSpinner", _p_FXSpinnerTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXMenuCaption", _p_FXMenuCaptionTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXMenuTitle", _p_FXMenuTitleTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXStatusLine", _p_FXStatusLineTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXWindow", _p_FXWindowTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXTopWindow", _p_FXTopWindowTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXMainWindow", _p_FXMainWindowTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXScrollWindow", _p_FXScrollWindowTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXRootWindow", _p_FXRootWindowTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXMenuBar", _p_FXMenuBarTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXMenuRadio", _p_FXMenuRadioTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXShell", _p_FXShellTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXScrollArea", _p_FXScrollAreaTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXColorWell", _p_FXColorWellTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXDragCorner", _p_FXDragCornerTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXRuler", _p_FXRulerTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXVerticalFrame", _p_FXVerticalFrameTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXHorizontalFrame", _p_FXHorizontalFrameTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXImageView", _p_FXImageViewTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXFontSelector", _p_FXFontSelectorTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXColorSelector", _p_FXColorSelectorTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXFileSelector", _p_FXFileSelectorTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXDirSelector", _p_FXDirSelectorTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXToolBarShell", _p_FXToolBarShellTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXToolBar", _p_FXToolBarTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXScrollPane", _p_FXScrollPaneTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXDirBox", _p_FXDirBoxTo_p_FXId, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXFont[] = {{"_p_FXFont", 0, "FXFont *", 0, 0, 0, 0},{"_p_FXFont", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXShell[] = {{"_p_FXShell", 0, "FXShell *", 0, 0, 0, 0},{"_p_FXShell", 0, 0, 0, 0, 0, 0},{"_p_FXPopup", _p_FXPopupTo_p_FXShell, 0, 0, 0, 0, 0},{"_p_FXMenuPane", _p_FXMenuPaneTo_p_FXShell, 0, 0, 0, 0, 0},{"_p_FXTopWindow", _p_FXTopWindowTo_p_FXShell, 0, 0, 0, 0, 0},{"_p_FXMainWindow", _p_FXMainWindowTo_p_FXShell, 0, 0, 0, 0, 0},{"_p_FXToolTip", _p_FXToolTipTo_p_FXShell, 0, 0, 0, 0, 0},{"_p_FXToolBarShell", _p_FXToolBarShellTo_p_FXShell, 0, 0, 0, 0, 0},{"_p_FXScrollPane", _p_FXScrollPaneTo_p_FXShell, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXMenuTitle[] = {{"_p_FXMenuTitle", 0, "FXMenuTitle *", 0, 0, 0, 0},{"_p_FXMenuTitle", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXMenuSeparator[] = {{"_p_FXMenuSeparator", 0, "FXMenuSeparator *", 0, 0, 0, 0},{"_p_FXMenuSeparator", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXMenuRadio[] = {{"_p_FXMenuRadio", 0, "FXMenuRadio *", 0, 0, 0, 0},{"_p_FXMenuRadio", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXStream[] = {{"_p_FXStream", 0, "FXStream *", 0, 0, 0, 0},{"_p_FXFileStream", _p_FXFileStreamTo_p_FXStream, 0, 0, 0, 0, 0},{"_p_FXMemoryStream", _p_FXMemoryStreamTo_p_FXStream, 0, 0, 0, 0, 0},{"_p_FXStream", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXDrawable[] = {{"_p_FXDrawable", 0, "FXDrawable *", 0, 0, 0, 0},{"_p_FXDriveBox", _p_FXDriveBoxTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXMenuPane", _p_FXMenuPaneTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXDial", _p_FXDialTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXMenuBar", _p_FXMenuBarTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXToolBar", _p_FXToolBarTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXComposite", _p_FXCompositeTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXToolTip", _p_FXToolTipTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXTabBook", _p_FXTabBookTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXTextField", _p_FXTextFieldTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXArrowButton", _p_FXArrowButtonTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXGroupBox", _p_FXGroupBoxTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXShell", _p_FXShellTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXStatusBar", _p_FXStatusBarTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXScrollArea", _p_FXScrollAreaTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXPopup", _p_FXPopupTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXRootWindow", _p_FXRootWindowTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXScrollWindow", _p_FXScrollWindowTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXMainWindow", _p_FXMainWindowTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXTopWindow", _p_FXTopWindowTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXScrollCorner", _p_FXScrollCornerTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXWindow", _p_FXWindowTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXRuler", _p_FXRulerTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXCanvas", _p_FXCanvasTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXComboBox", _p_FXComboBoxTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXMenuSeparator", _p_FXMenuSeparatorTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXSeparator", _p_FXSeparatorTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXHorizontalSeparator", _p_FXHorizontalSeparatorTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXVerticalSeparator", _p_FXVerticalSeparatorTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXStatusLine", _p_FXStatusLineTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXHorizontalFrame", _p_FXHorizontalFrameTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXVerticalFrame", _p_FXVerticalFrameTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FX4Splitter", _p_FX4SplitterTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXSplitter", _p_FXSplitterTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXMenuTitle", _p_FXMenuTitleTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXMenuCascade", _p_FXMenuCascadeTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXRealSpinner", _p_FXRealSpinnerTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXSpinner", _p_FXSpinnerTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXPacker", _p_FXPackerTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXScrollBar", _p_FXScrollBarTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXMenuCaption", _p_FXMenuCaptionTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXMenuCommand", _p_FXMenuCommandTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXMenuRadio", _p_FXMenuRadioTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXColorWheel", _p_FXColorWheelTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXBitmapFrame", _p_FXBitmapFrameTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXDirBox", _p_FXDirBoxTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXToolBarGrip", _p_FXToolBarGripTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXImageFrame", _p_FXImageFrameTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXDragCorner", _p_FXDragCornerTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXDirSelector", _p_FXDirSelectorTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXFileSelector", _p_FXFileSelectorTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXColorSelector", _p_FXColorSelectorTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXFontSelector", _p_FXFontSelectorTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXSwitcher", _p_FXSwitcherTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXShutter", _p_FXShutterTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXDrawable", 0, 0, 0, 0, 0, 0},{"_p_FXProgressBar", _p_FXProgressBarTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXListBox", _p_FXListBoxTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXTreeListBox", _p_FXTreeListBoxTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXHeader", _p_FXHeaderTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXShutterItem", _p_FXShutterItemTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXMatrix", _p_FXMatrixTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXColorWell", _p_FXColorWellTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXToolBarTab", _p_FXToolBarTabTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXTabBar", _p_FXTabBarTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXMenuCheck", _p_FXMenuCheckTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXFrame", _p_FXFrameTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXImageView", _p_FXImageViewTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXSlider", _p_FXSliderTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXRealSlider", _p_FXRealSliderTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXSpring", _p_FXSpringTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXColorBar", _p_FXColorBarTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXScrollPane", _p_FXScrollPaneTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXToolBarShell", _p_FXToolBarShellTo_p_FXDrawable, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXPacker[] = {{"_p_FXPacker", 0, "FXPacker *", 0, 0, 0, 0},{"_p_FXToolBar", _p_FXToolBarTo_p_FXPacker, 0, 0, 0, 0, 0},{"_p_FXListBox", _p_FXListBoxTo_p_FXPacker, 0, 0, 0, 0, 0},{"_p_FXTreeListBox", _p_FXTreeListBoxTo_p_FXPacker, 0, 0, 0, 0, 0},{"_p_FXComboBox", _p_FXComboBoxTo_p_FXPacker, 0, 0, 0, 0, 0},{"_p_FXShutterItem", _p_FXShutterItemTo_p_FXPacker, 0, 0, 0, 0, 0},{"_p_FXDirBox", _p_FXDirBoxTo_p_FXPacker, 0, 0, 0, 0, 0},{"_p_FXStatusBar", _p_FXStatusBarTo_p_FXPacker, 0, 0, 0, 0, 0},{"_p_FXTabBar", _p_FXTabBarTo_p_FXPacker, 0, 0, 0, 0, 0},{"_p_FXTabBook", _p_FXTabBookTo_p_FXPacker, 0, 0, 0, 0, 0},{"_p_FXGroupBox", _p_FXGroupBoxTo_p_FXPacker, 0, 0, 0, 0, 0},{"_p_FXShutter", _p_FXShutterTo_p_FXPacker, 0, 0, 0, 0, 0},{"_p_FXPacker", 0, 0, 0, 0, 0, 0},{"_p_FXHorizontalFrame", _p_FXHorizontalFrameTo_p_FXPacker, 0, 0, 0, 0, 0},{"_p_FXVerticalFrame", _p_FXVerticalFrameTo_p_FXPacker, 0, 0, 0, 0, 0},{"_p_FXRealSpinner", _p_FXRealSpinnerTo_p_FXPacker, 0, 0, 0, 0, 0},{"_p_FXSpinner", _p_FXSpinnerTo_p_FXPacker, 0, 0, 0, 0, 0},{"_p_FXMatrix", _p_FXMatrixTo_p_FXPacker, 0, 0, 0, 0, 0},{"_p_FXSpring", _p_FXSpringTo_p_FXPacker, 0, 0, 0, 0, 0},{"_p_FXDirSelector", _p_FXDirSelectorTo_p_FXPacker, 0, 0, 0, 0, 0},{"_p_FXFileSelector", _p_FXFileSelectorTo_p_FXPacker, 0, 0, 0, 0, 0},{"_p_FXColorSelector", _p_FXColorSelectorTo_p_FXPacker, 0, 0, 0, 0, 0},{"_p_FXFontSelector", _p_FXFontSelectorTo_p_FXPacker, 0, 0, 0, 0, 0},{"_p_FXMenuBar", _p_FXMenuBarTo_p_FXPacker, 0, 0, 0, 0, 0},{"_p_FXDriveBox", _p_FXDriveBoxTo_p_FXPacker, 0, 0, 0, 0, 0},{"_p_FXSwitcher", _p_FXSwitcherTo_p_FXPacker, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXIcon[] = {{"_p_FXIcon", 0, "FXIcon *", 0, 0, 0, 0},{"_p_FXIcon", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXMenuCascade[] = {{"_p_FXMenuCascade", 0, "FXMenuCascade *", 0, 0, 0, 0},{"_p_FXMenuCascade", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXMenuCheck[] = {{"_p_FXMenuCheck", 0, "FXMenuCheck *", 0, 0, 0, 0},{"_p_FXMenuCheck", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXMenuCommand[] = {{"_p_FXMenuCommand", 0, "FXMenuCommand *", 0, 0, 0, 0},{"_p_FXMenuCommand", 0, 0, 0, 0, 0, 0},{"_p_FXMenuCheck", _p_FXMenuCheckTo_p_FXMenuCommand, 0, 0, 0, 0, 0},{"_p_FXMenuRadio", _p_FXMenuRadioTo_p_FXMenuCommand, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXMenuBar[] = {{"_p_FXMenuBar", 0, "FXMenuBar *", 0, 0, 0, 0},{"_p_FXMenuBar", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXMenuPane[] = {{"_p_FXMenuPane", 0, "FXMenuPane *", 0, 0, 0, 0},{"_p_FXMenuPane", 0, 0, 0, 0, 0, 0},{"_p_FXScrollPane", _p_FXScrollPaneTo_p_FXMenuPane, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};

static swig_type_info *swig_types_initial[] = {
_swigt__p_FXToolBar, 
_swigt__p_FXObject, 
_swigt__p_FXPopup, 
_swigt__p_FXMenuCaption, 
_swigt__p_FXScrollPane, 
_swigt__p_FXWindow, 
_swigt__p_FXComposite, 
_swigt__p_FXId, 
_swigt__p_FXFont, 
_swigt__p_FXShell, 
_swigt__p_FXMenuTitle, 
_swigt__p_FXMenuSeparator, 
_swigt__p_FXMenuRadio, 
_swigt__p_FXStream, 
_swigt__p_FXDrawable, 
_swigt__p_FXPacker, 
_swigt__p_FXIcon, 
_swigt__p_FXMenuCascade, 
_swigt__p_FXMenuCheck, 
_swigt__p_FXMenuCommand, 
_swigt__p_FXMenuBar, 
_swigt__p_FXMenuPane, 
0
};


/* -------- TYPE CONVERSION AND EQUIVALENCE RULES (END) -------- */


#ifdef __cplusplus
extern "C"
#endif
SWIGEXPORT(void) Init_menu(void) {
    int i;
    
    SWIG_InitRuntime();
    
    for (i = 0; swig_types_initial[i]; i++) {
        swig_types[i] = SWIG_TypeRegister(swig_types_initial[i]);
        SWIG_define_class(swig_types[i]);
    }
    
    
    cFXMenuPane.klass = rb_define_class_under(mFox, "FXMenuPane", ((swig_class *) SWIGTYPE_p_FXPopup->clientdata)->klass);
    SWIG_TypeClientData(SWIGTYPE_p_FXMenuPane, (void *) &cFXMenuPane);
    rb_define_alloc_func(cFXMenuPane.klass, _wrap_FXMenuPane_allocate);
    rb_define_method(cFXMenuPane.klass, "initialize", VALUEFUNC(_wrap_new_FXMenuPane), -1);
    rb_define_method(cFXMenuPane.klass, "save", VALUEFUNC(_wrap_FXMenuPane_save), -1);
    rb_define_method(cFXMenuPane.klass, "load", VALUEFUNC(_wrap_FXMenuPane_load), -1);
    rb_define_method(cFXMenuPane.klass, "create", VALUEFUNC(_wrap_FXMenuPane_create), -1);
    rb_define_method(cFXMenuPane.klass, "detach", VALUEFUNC(_wrap_FXMenuPane_detach), -1);
    rb_define_method(cFXMenuPane.klass, "destroy", VALUEFUNC(_wrap_FXMenuPane_destroy), -1);
    rb_define_method(cFXMenuPane.klass, "resize", VALUEFUNC(_wrap_FXMenuPane_resize), -1);
    rb_define_method(cFXMenuPane.klass, "getDefaultWidth", VALUEFUNC(_wrap_FXMenuPane_getDefaultWidth), -1);
    rb_define_method(cFXMenuPane.klass, "getDefaultHeight", VALUEFUNC(_wrap_FXMenuPane_getDefaultHeight), -1);
    rb_define_method(cFXMenuPane.klass, "getWidthForHeight", VALUEFUNC(_wrap_FXMenuPane_getWidthForHeight), -1);
    rb_define_method(cFXMenuPane.klass, "getHeightForWidth", VALUEFUNC(_wrap_FXMenuPane_getHeightForWidth), -1);
    rb_define_method(cFXMenuPane.klass, "canFocus", VALUEFUNC(_wrap_FXMenuPane_canFocus), -1);
    rb_define_method(cFXMenuPane.klass, "setFocus", VALUEFUNC(_wrap_FXMenuPane_setFocus), -1);
    rb_define_method(cFXMenuPane.klass, "killFocus", VALUEFUNC(_wrap_FXMenuPane_killFocus), -1);
    rb_define_method(cFXMenuPane.klass, "setDefault", VALUEFUNC(_wrap_FXMenuPane_setDefault), -1);
    rb_define_method(cFXMenuPane.klass, "enable", VALUEFUNC(_wrap_FXMenuPane_enable), -1);
    rb_define_method(cFXMenuPane.klass, "disable", VALUEFUNC(_wrap_FXMenuPane_disable), -1);
    rb_define_method(cFXMenuPane.klass, "raiseWindow", VALUEFUNC(_wrap_FXMenuPane_raiseWindow), -1);
    rb_define_method(cFXMenuPane.klass, "lower", VALUEFUNC(_wrap_FXMenuPane_lower), -1);
    rb_define_method(cFXMenuPane.klass, "move", VALUEFUNC(_wrap_FXMenuPane_move), -1);
    rb_define_method(cFXMenuPane.klass, "position", VALUEFUNC(_wrap_FXMenuPane_position), -1);
    rb_define_method(cFXMenuPane.klass, "layout", VALUEFUNC(_wrap_FXMenuPane_layout), -1);
    rb_define_method(cFXMenuPane.klass, "recalc", VALUEFUNC(_wrap_FXMenuPane_recalc), -1);
    rb_define_method(cFXMenuPane.klass, "reparent", VALUEFUNC(_wrap_FXMenuPane_reparent), -1);
    rb_define_method(cFXMenuPane.klass, "show", VALUEFUNC(_wrap_FXMenuPane_show), -1);
    rb_define_method(cFXMenuPane.klass, "hide", VALUEFUNC(_wrap_FXMenuPane_hide), -1);
    rb_define_method(cFXMenuPane.klass, "isComposite", VALUEFUNC(_wrap_FXMenuPane_isComposite), -1);
    rb_define_method(cFXMenuPane.klass, "contains", VALUEFUNC(_wrap_FXMenuPane_contains), -1);
    rb_define_method(cFXMenuPane.klass, "doesSaveUnder", VALUEFUNC(_wrap_FXMenuPane_doesSaveUnder), -1);
    rb_define_method(cFXMenuPane.klass, "setBackColor", VALUEFUNC(_wrap_FXMenuPane_setBackColor), -1);
    rb_define_method(cFXMenuPane.klass, "popup", VALUEFUNC(_wrap_FXMenuPane_popup), -1);
    rb_define_method(cFXMenuPane.klass, "popdown", VALUEFUNC(_wrap_FXMenuPane_popdown), -1);
    cFXMenuPane.mark = (void (*)(void *)) FXRbMenuPane::markfunc;
    cFXMenuPane.destroy = (void (*)(void *)) FXRbObject::freefunc;
    
    SWIGTYPE_p_FXMenuPane->dcast = (swig_dycast_func) FXMenuPane_dynamic_cast;
    
    
    cFXScrollPane.klass = rb_define_class_under(mFox, "FXScrollPane", ((swig_class *) SWIGTYPE_p_FXMenuPane->clientdata)->klass);
    SWIG_TypeClientData(SWIGTYPE_p_FXScrollPane, (void *) &cFXScrollPane);
    rb_define_alloc_func(cFXScrollPane.klass, _wrap_FXScrollPane_allocate);
    rb_define_method(cFXScrollPane.klass, "initialize", VALUEFUNC(_wrap_new_FXScrollPane), -1);
    rb_define_method(cFXScrollPane.klass, "onUpdIncrement", VALUEFUNC(_wrap_FXScrollPane_onUpdIncrement), -1);
    rb_define_method(cFXScrollPane.klass, "onCmdIncrement", VALUEFUNC(_wrap_FXScrollPane_onCmdIncrement), -1);
    rb_define_method(cFXScrollPane.klass, "onUpdDecrement", VALUEFUNC(_wrap_FXScrollPane_onUpdDecrement), -1);
    rb_define_method(cFXScrollPane.klass, "onCmdDecrement", VALUEFUNC(_wrap_FXScrollPane_onCmdDecrement), -1);
    rb_define_const(cFXScrollPane.klass,"ID_SCROLL_DN", INT2NUM(FXScrollPane::ID_SCROLL_DN));
    rb_define_const(cFXScrollPane.klass,"ID_SCROLL_UP", INT2NUM(FXScrollPane::ID_SCROLL_UP));
    rb_define_const(cFXScrollPane.klass,"ID_LAST", INT2NUM(FXScrollPane::ID_LAST));
    rb_define_method(cFXScrollPane.klass, "getTopItem", VALUEFUNC(_wrap_FXScrollPane_getTopItem), -1);
    rb_define_method(cFXScrollPane.klass, "setTopItem", VALUEFUNC(_wrap_FXScrollPane_setTopItem), -1);
    rb_define_method(cFXScrollPane.klass, "save", VALUEFUNC(_wrap_FXScrollPane_save), -1);
    rb_define_method(cFXScrollPane.klass, "load", VALUEFUNC(_wrap_FXScrollPane_load), -1);
    rb_define_method(cFXScrollPane.klass, "create", VALUEFUNC(_wrap_FXScrollPane_create), -1);
    rb_define_method(cFXScrollPane.klass, "detach", VALUEFUNC(_wrap_FXScrollPane_detach), -1);
    rb_define_method(cFXScrollPane.klass, "destroy", VALUEFUNC(_wrap_FXScrollPane_destroy), -1);
    rb_define_method(cFXScrollPane.klass, "resize", VALUEFUNC(_wrap_FXScrollPane_resize), -1);
    rb_define_method(cFXScrollPane.klass, "getDefaultWidth", VALUEFUNC(_wrap_FXScrollPane_getDefaultWidth), -1);
    rb_define_method(cFXScrollPane.klass, "getDefaultHeight", VALUEFUNC(_wrap_FXScrollPane_getDefaultHeight), -1);
    rb_define_method(cFXScrollPane.klass, "getWidthForHeight", VALUEFUNC(_wrap_FXScrollPane_getWidthForHeight), -1);
    rb_define_method(cFXScrollPane.klass, "getHeightForWidth", VALUEFUNC(_wrap_FXScrollPane_getHeightForWidth), -1);
    rb_define_method(cFXScrollPane.klass, "canFocus", VALUEFUNC(_wrap_FXScrollPane_canFocus), -1);
    rb_define_method(cFXScrollPane.klass, "setFocus", VALUEFUNC(_wrap_FXScrollPane_setFocus), -1);
    rb_define_method(cFXScrollPane.klass, "killFocus", VALUEFUNC(_wrap_FXScrollPane_killFocus), -1);
    rb_define_method(cFXScrollPane.klass, "setDefault", VALUEFUNC(_wrap_FXScrollPane_setDefault), -1);
    rb_define_method(cFXScrollPane.klass, "enable", VALUEFUNC(_wrap_FXScrollPane_enable), -1);
    rb_define_method(cFXScrollPane.klass, "disable", VALUEFUNC(_wrap_FXScrollPane_disable), -1);
    rb_define_method(cFXScrollPane.klass, "raiseWindow", VALUEFUNC(_wrap_FXScrollPane_raiseWindow), -1);
    rb_define_method(cFXScrollPane.klass, "lower", VALUEFUNC(_wrap_FXScrollPane_lower), -1);
    rb_define_method(cFXScrollPane.klass, "move", VALUEFUNC(_wrap_FXScrollPane_move), -1);
    rb_define_method(cFXScrollPane.klass, "position", VALUEFUNC(_wrap_FXScrollPane_position), -1);
    rb_define_method(cFXScrollPane.klass, "layout", VALUEFUNC(_wrap_FXScrollPane_layout), -1);
    rb_define_method(cFXScrollPane.klass, "recalc", VALUEFUNC(_wrap_FXScrollPane_recalc), -1);
    rb_define_method(cFXScrollPane.klass, "reparent", VALUEFUNC(_wrap_FXScrollPane_reparent), -1);
    rb_define_method(cFXScrollPane.klass, "show", VALUEFUNC(_wrap_FXScrollPane_show), -1);
    rb_define_method(cFXScrollPane.klass, "hide", VALUEFUNC(_wrap_FXScrollPane_hide), -1);
    rb_define_method(cFXScrollPane.klass, "isComposite", VALUEFUNC(_wrap_FXScrollPane_isComposite), -1);
    rb_define_method(cFXScrollPane.klass, "contains", VALUEFUNC(_wrap_FXScrollPane_contains), -1);
    rb_define_method(cFXScrollPane.klass, "doesSaveUnder", VALUEFUNC(_wrap_FXScrollPane_doesSaveUnder), -1);
    rb_define_method(cFXScrollPane.klass, "setBackColor", VALUEFUNC(_wrap_FXScrollPane_setBackColor), -1);
    rb_define_method(cFXScrollPane.klass, "popup", VALUEFUNC(_wrap_FXScrollPane_popup), -1);
    rb_define_method(cFXScrollPane.klass, "popdown", VALUEFUNC(_wrap_FXScrollPane_popdown), -1);
    cFXScrollPane.mark = (void (*)(void *)) FXRbScrollPane::markfunc;
    cFXScrollPane.destroy = (void (*)(void *)) FXRbObject::freefunc;
    rb_define_const(mFox,"MENU_AUTOGRAY", INT2NUM(MENU_AUTOGRAY));
    rb_define_const(mFox,"MENU_AUTOHIDE", INT2NUM(MENU_AUTOHIDE));
    
    cFXMenuCaption.klass = rb_define_class_under(mFox, "FXMenuCaption", ((swig_class *) SWIGTYPE_p_FXWindow->clientdata)->klass);
    SWIG_TypeClientData(SWIGTYPE_p_FXMenuCaption, (void *) &cFXMenuCaption);
    rb_define_alloc_func(cFXMenuCaption.klass, _wrap_FXMenuCaption_allocate);
    rb_define_method(cFXMenuCaption.klass, "initialize", VALUEFUNC(_wrap_new_FXMenuCaption), -1);
    rb_define_method(cFXMenuCaption.klass, "onPaint", VALUEFUNC(_wrap_FXMenuCaption_onPaint), -1);
    rb_define_method(cFXMenuCaption.klass, "onUpdate", VALUEFUNC(_wrap_FXMenuCaption_onUpdate), -1);
    rb_define_method(cFXMenuCaption.klass, "onCmdSetStringValue", VALUEFUNC(_wrap_FXMenuCaption_onCmdSetStringValue), -1);
    rb_define_method(cFXMenuCaption.klass, "onCmdGetStringValue", VALUEFUNC(_wrap_FXMenuCaption_onCmdGetStringValue), -1);
    rb_define_method(cFXMenuCaption.klass, "onCmdSetIconValue", VALUEFUNC(_wrap_FXMenuCaption_onCmdSetIconValue), -1);
    rb_define_method(cFXMenuCaption.klass, "onCmdGetIconValue", VALUEFUNC(_wrap_FXMenuCaption_onCmdGetIconValue), -1);
    rb_define_method(cFXMenuCaption.klass, "onCmdSetHelp", VALUEFUNC(_wrap_FXMenuCaption_onCmdSetHelp), -1);
    rb_define_method(cFXMenuCaption.klass, "onCmdGetHelp", VALUEFUNC(_wrap_FXMenuCaption_onCmdGetHelp), -1);
    rb_define_method(cFXMenuCaption.klass, "onQueryHelp", VALUEFUNC(_wrap_FXMenuCaption_onQueryHelp), -1);
    rb_define_method(cFXMenuCaption.klass, "setText", VALUEFUNC(_wrap_FXMenuCaption_setText), -1);
    rb_define_method(cFXMenuCaption.klass, "getText", VALUEFUNC(_wrap_FXMenuCaption_getText), -1);
    rb_define_method(cFXMenuCaption.klass, "setIcon", VALUEFUNC(_wrap_FXMenuCaption_setIcon), -1);
    rb_define_method(cFXMenuCaption.klass, "getIcon", VALUEFUNC(_wrap_FXMenuCaption_getIcon), -1);
    rb_define_method(cFXMenuCaption.klass, "setFont", VALUEFUNC(_wrap_FXMenuCaption_setFont), -1);
    rb_define_method(cFXMenuCaption.klass, "getFont", VALUEFUNC(_wrap_FXMenuCaption_getFont), -1);
    rb_define_method(cFXMenuCaption.klass, "setMenuStyle", VALUEFUNC(_wrap_FXMenuCaption_setMenuStyle), -1);
    rb_define_method(cFXMenuCaption.klass, "getMenuStyle", VALUEFUNC(_wrap_FXMenuCaption_getMenuStyle), -1);
    rb_define_method(cFXMenuCaption.klass, "getTextColor", VALUEFUNC(_wrap_FXMenuCaption_getTextColor), -1);
    rb_define_method(cFXMenuCaption.klass, "setTextColor", VALUEFUNC(_wrap_FXMenuCaption_setTextColor), -1);
    rb_define_method(cFXMenuCaption.klass, "getSelBackColor", VALUEFUNC(_wrap_FXMenuCaption_getSelBackColor), -1);
    rb_define_method(cFXMenuCaption.klass, "setSelBackColor", VALUEFUNC(_wrap_FXMenuCaption_setSelBackColor), -1);
    rb_define_method(cFXMenuCaption.klass, "getSelTextColor", VALUEFUNC(_wrap_FXMenuCaption_getSelTextColor), -1);
    rb_define_method(cFXMenuCaption.klass, "setSelTextColor", VALUEFUNC(_wrap_FXMenuCaption_setSelTextColor), -1);
    rb_define_method(cFXMenuCaption.klass, "setHiliteColor", VALUEFUNC(_wrap_FXMenuCaption_setHiliteColor), -1);
    rb_define_method(cFXMenuCaption.klass, "getHiliteColor", VALUEFUNC(_wrap_FXMenuCaption_getHiliteColor), -1);
    rb_define_method(cFXMenuCaption.klass, "setShadowColor", VALUEFUNC(_wrap_FXMenuCaption_setShadowColor), -1);
    rb_define_method(cFXMenuCaption.klass, "getShadowColor", VALUEFUNC(_wrap_FXMenuCaption_getShadowColor), -1);
    rb_define_method(cFXMenuCaption.klass, "setHelpText", VALUEFUNC(_wrap_FXMenuCaption_setHelpText), -1);
    rb_define_method(cFXMenuCaption.klass, "getHelpText", VALUEFUNC(_wrap_FXMenuCaption_getHelpText), -1);
    rb_define_method(cFXMenuCaption.klass, "save", VALUEFUNC(_wrap_FXMenuCaption_save), -1);
    rb_define_method(cFXMenuCaption.klass, "load", VALUEFUNC(_wrap_FXMenuCaption_load), -1);
    rb_define_method(cFXMenuCaption.klass, "create", VALUEFUNC(_wrap_FXMenuCaption_create), -1);
    rb_define_method(cFXMenuCaption.klass, "detach", VALUEFUNC(_wrap_FXMenuCaption_detach), -1);
    rb_define_method(cFXMenuCaption.klass, "destroy", VALUEFUNC(_wrap_FXMenuCaption_destroy), -1);
    rb_define_method(cFXMenuCaption.klass, "resize", VALUEFUNC(_wrap_FXMenuCaption_resize), -1);
    rb_define_method(cFXMenuCaption.klass, "getDefaultWidth", VALUEFUNC(_wrap_FXMenuCaption_getDefaultWidth), -1);
    rb_define_method(cFXMenuCaption.klass, "getDefaultHeight", VALUEFUNC(_wrap_FXMenuCaption_getDefaultHeight), -1);
    rb_define_method(cFXMenuCaption.klass, "getWidthForHeight", VALUEFUNC(_wrap_FXMenuCaption_getWidthForHeight), -1);
    rb_define_method(cFXMenuCaption.klass, "getHeightForWidth", VALUEFUNC(_wrap_FXMenuCaption_getHeightForWidth), -1);
    rb_define_method(cFXMenuCaption.klass, "canFocus", VALUEFUNC(_wrap_FXMenuCaption_canFocus), -1);
    rb_define_method(cFXMenuCaption.klass, "setFocus", VALUEFUNC(_wrap_FXMenuCaption_setFocus), -1);
    rb_define_method(cFXMenuCaption.klass, "killFocus", VALUEFUNC(_wrap_FXMenuCaption_killFocus), -1);
    rb_define_method(cFXMenuCaption.klass, "setDefault", VALUEFUNC(_wrap_FXMenuCaption_setDefault), -1);
    rb_define_method(cFXMenuCaption.klass, "enable", VALUEFUNC(_wrap_FXMenuCaption_enable), -1);
    rb_define_method(cFXMenuCaption.klass, "disable", VALUEFUNC(_wrap_FXMenuCaption_disable), -1);
    rb_define_method(cFXMenuCaption.klass, "raiseWindow", VALUEFUNC(_wrap_FXMenuCaption_raiseWindow), -1);
    rb_define_method(cFXMenuCaption.klass, "lower", VALUEFUNC(_wrap_FXMenuCaption_lower), -1);
    rb_define_method(cFXMenuCaption.klass, "move", VALUEFUNC(_wrap_FXMenuCaption_move), -1);
    rb_define_method(cFXMenuCaption.klass, "position", VALUEFUNC(_wrap_FXMenuCaption_position), -1);
    rb_define_method(cFXMenuCaption.klass, "layout", VALUEFUNC(_wrap_FXMenuCaption_layout), -1);
    rb_define_method(cFXMenuCaption.klass, "recalc", VALUEFUNC(_wrap_FXMenuCaption_recalc), -1);
    rb_define_method(cFXMenuCaption.klass, "reparent", VALUEFUNC(_wrap_FXMenuCaption_reparent), -1);
    rb_define_method(cFXMenuCaption.klass, "show", VALUEFUNC(_wrap_FXMenuCaption_show), -1);
    rb_define_method(cFXMenuCaption.klass, "hide", VALUEFUNC(_wrap_FXMenuCaption_hide), -1);
    rb_define_method(cFXMenuCaption.klass, "isComposite", VALUEFUNC(_wrap_FXMenuCaption_isComposite), -1);
    rb_define_method(cFXMenuCaption.klass, "contains", VALUEFUNC(_wrap_FXMenuCaption_contains), -1);
    rb_define_method(cFXMenuCaption.klass, "doesSaveUnder", VALUEFUNC(_wrap_FXMenuCaption_doesSaveUnder), -1);
    rb_define_method(cFXMenuCaption.klass, "setBackColor", VALUEFUNC(_wrap_FXMenuCaption_setBackColor), -1);
    cFXMenuCaption.mark = (void (*)(void *)) FXRbMenuCaption::markfunc;
    cFXMenuCaption.destroy = (void (*)(void *)) FXRbObject::freefunc;
    
    SWIGTYPE_p_FXMenuCaption->dcast = (swig_dycast_func) FXMenuCaption_dynamic_cast;
    
    
    cFXMenuSeparator.klass = rb_define_class_under(mFox, "FXMenuSeparator", ((swig_class *) SWIGTYPE_p_FXWindow->clientdata)->klass);
    SWIG_TypeClientData(SWIGTYPE_p_FXMenuSeparator, (void *) &cFXMenuSeparator);
    rb_define_alloc_func(cFXMenuSeparator.klass, _wrap_FXMenuSeparator_allocate);
    rb_define_method(cFXMenuSeparator.klass, "initialize", VALUEFUNC(_wrap_new_FXMenuSeparator), -1);
    rb_define_method(cFXMenuSeparator.klass, "onPaint", VALUEFUNC(_wrap_FXMenuSeparator_onPaint), -1);
    rb_define_method(cFXMenuSeparator.klass, "setHiliteColor", VALUEFUNC(_wrap_FXMenuSeparator_setHiliteColor), -1);
    rb_define_method(cFXMenuSeparator.klass, "getHiliteColor", VALUEFUNC(_wrap_FXMenuSeparator_getHiliteColor), -1);
    rb_define_method(cFXMenuSeparator.klass, "setShadowColor", VALUEFUNC(_wrap_FXMenuSeparator_setShadowColor), -1);
    rb_define_method(cFXMenuSeparator.klass, "getShadowColor", VALUEFUNC(_wrap_FXMenuSeparator_getShadowColor), -1);
    rb_define_method(cFXMenuSeparator.klass, "save", VALUEFUNC(_wrap_FXMenuSeparator_save), -1);
    rb_define_method(cFXMenuSeparator.klass, "load", VALUEFUNC(_wrap_FXMenuSeparator_load), -1);
    rb_define_method(cFXMenuSeparator.klass, "create", VALUEFUNC(_wrap_FXMenuSeparator_create), -1);
    rb_define_method(cFXMenuSeparator.klass, "detach", VALUEFUNC(_wrap_FXMenuSeparator_detach), -1);
    rb_define_method(cFXMenuSeparator.klass, "destroy", VALUEFUNC(_wrap_FXMenuSeparator_destroy), -1);
    rb_define_method(cFXMenuSeparator.klass, "resize", VALUEFUNC(_wrap_FXMenuSeparator_resize), -1);
    rb_define_method(cFXMenuSeparator.klass, "getDefaultWidth", VALUEFUNC(_wrap_FXMenuSeparator_getDefaultWidth), -1);
    rb_define_method(cFXMenuSeparator.klass, "getDefaultHeight", VALUEFUNC(_wrap_FXMenuSeparator_getDefaultHeight), -1);
    rb_define_method(cFXMenuSeparator.klass, "getWidthForHeight", VALUEFUNC(_wrap_FXMenuSeparator_getWidthForHeight), -1);
    rb_define_method(cFXMenuSeparator.klass, "getHeightForWidth", VALUEFUNC(_wrap_FXMenuSeparator_getHeightForWidth), -1);
    rb_define_method(cFXMenuSeparator.klass, "canFocus", VALUEFUNC(_wrap_FXMenuSeparator_canFocus), -1);
    rb_define_method(cFXMenuSeparator.klass, "setFocus", VALUEFUNC(_wrap_FXMenuSeparator_setFocus), -1);
    rb_define_method(cFXMenuSeparator.klass, "killFocus", VALUEFUNC(_wrap_FXMenuSeparator_killFocus), -1);
    rb_define_method(cFXMenuSeparator.klass, "setDefault", VALUEFUNC(_wrap_FXMenuSeparator_setDefault), -1);
    rb_define_method(cFXMenuSeparator.klass, "enable", VALUEFUNC(_wrap_FXMenuSeparator_enable), -1);
    rb_define_method(cFXMenuSeparator.klass, "disable", VALUEFUNC(_wrap_FXMenuSeparator_disable), -1);
    rb_define_method(cFXMenuSeparator.klass, "raiseWindow", VALUEFUNC(_wrap_FXMenuSeparator_raiseWindow), -1);
    rb_define_method(cFXMenuSeparator.klass, "lower", VALUEFUNC(_wrap_FXMenuSeparator_lower), -1);
    rb_define_method(cFXMenuSeparator.klass, "move", VALUEFUNC(_wrap_FXMenuSeparator_move), -1);
    rb_define_method(cFXMenuSeparator.klass, "position", VALUEFUNC(_wrap_FXMenuSeparator_position), -1);
    rb_define_method(cFXMenuSeparator.klass, "layout", VALUEFUNC(_wrap_FXMenuSeparator_layout), -1);
    rb_define_method(cFXMenuSeparator.klass, "recalc", VALUEFUNC(_wrap_FXMenuSeparator_recalc), -1);
    rb_define_method(cFXMenuSeparator.klass, "reparent", VALUEFUNC(_wrap_FXMenuSeparator_reparent), -1);
    rb_define_method(cFXMenuSeparator.klass, "show", VALUEFUNC(_wrap_FXMenuSeparator_show), -1);
    rb_define_method(cFXMenuSeparator.klass, "hide", VALUEFUNC(_wrap_FXMenuSeparator_hide), -1);
    rb_define_method(cFXMenuSeparator.klass, "isComposite", VALUEFUNC(_wrap_FXMenuSeparator_isComposite), -1);
    rb_define_method(cFXMenuSeparator.klass, "contains", VALUEFUNC(_wrap_FXMenuSeparator_contains), -1);
    rb_define_method(cFXMenuSeparator.klass, "doesSaveUnder", VALUEFUNC(_wrap_FXMenuSeparator_doesSaveUnder), -1);
    rb_define_method(cFXMenuSeparator.klass, "setBackColor", VALUEFUNC(_wrap_FXMenuSeparator_setBackColor), -1);
    cFXMenuSeparator.mark = (void (*)(void *)) FXRbMenuSeparator::markfunc;
    cFXMenuSeparator.destroy = (void (*)(void *)) FXRbObject::freefunc;
    
    cFXMenuTitle.klass = rb_define_class_under(mFox, "FXMenuTitle", ((swig_class *) SWIGTYPE_p_FXMenuCaption->clientdata)->klass);
    SWIG_TypeClientData(SWIGTYPE_p_FXMenuTitle, (void *) &cFXMenuTitle);
    rb_define_alloc_func(cFXMenuTitle.klass, _wrap_FXMenuTitle_allocate);
    rb_define_method(cFXMenuTitle.klass, "initialize", VALUEFUNC(_wrap_new_FXMenuTitle), -1);
    rb_define_method(cFXMenuTitle.klass, "onPaint", VALUEFUNC(_wrap_FXMenuTitle_onPaint), -1);
    rb_define_method(cFXMenuTitle.klass, "onEnter", VALUEFUNC(_wrap_FXMenuTitle_onEnter), -1);
    rb_define_method(cFXMenuTitle.klass, "onLeave", VALUEFUNC(_wrap_FXMenuTitle_onLeave), -1);
    rb_define_method(cFXMenuTitle.klass, "onLeftBtnPress", VALUEFUNC(_wrap_FXMenuTitle_onLeftBtnPress), -1);
    rb_define_method(cFXMenuTitle.klass, "onLeftBtnRelease", VALUEFUNC(_wrap_FXMenuTitle_onLeftBtnRelease), -1);
    rb_define_method(cFXMenuTitle.klass, "onKeyPress", VALUEFUNC(_wrap_FXMenuTitle_onKeyPress), -1);
    rb_define_method(cFXMenuTitle.klass, "onKeyRelease", VALUEFUNC(_wrap_FXMenuTitle_onKeyRelease), -1);
    rb_define_method(cFXMenuTitle.klass, "onHotKeyPress", VALUEFUNC(_wrap_FXMenuTitle_onHotKeyPress), -1);
    rb_define_method(cFXMenuTitle.klass, "onHotKeyRelease", VALUEFUNC(_wrap_FXMenuTitle_onHotKeyRelease), -1);
    rb_define_method(cFXMenuTitle.klass, "onFocusUp", VALUEFUNC(_wrap_FXMenuTitle_onFocusUp), -1);
    rb_define_method(cFXMenuTitle.klass, "onFocusDown", VALUEFUNC(_wrap_FXMenuTitle_onFocusDown), -1);
    rb_define_method(cFXMenuTitle.klass, "onFocusIn", VALUEFUNC(_wrap_FXMenuTitle_onFocusIn), -1);
    rb_define_method(cFXMenuTitle.klass, "onFocusOut", VALUEFUNC(_wrap_FXMenuTitle_onFocusOut), -1);
    rb_define_method(cFXMenuTitle.klass, "onCmdPost", VALUEFUNC(_wrap_FXMenuTitle_onCmdPost), -1);
    rb_define_method(cFXMenuTitle.klass, "onCmdUnpost", VALUEFUNC(_wrap_FXMenuTitle_onCmdUnpost), -1);
    rb_define_method(cFXMenuTitle.klass, "setMenu", VALUEFUNC(_wrap_FXMenuTitle_setMenu), -1);
    rb_define_method(cFXMenuTitle.klass, "getMenu", VALUEFUNC(_wrap_FXMenuTitle_getMenu), -1);
    rb_define_method(cFXMenuTitle.klass, "save", VALUEFUNC(_wrap_FXMenuTitle_save), -1);
    rb_define_method(cFXMenuTitle.klass, "load", VALUEFUNC(_wrap_FXMenuTitle_load), -1);
    rb_define_method(cFXMenuTitle.klass, "create", VALUEFUNC(_wrap_FXMenuTitle_create), -1);
    rb_define_method(cFXMenuTitle.klass, "detach", VALUEFUNC(_wrap_FXMenuTitle_detach), -1);
    rb_define_method(cFXMenuTitle.klass, "destroy", VALUEFUNC(_wrap_FXMenuTitle_destroy), -1);
    rb_define_method(cFXMenuTitle.klass, "resize", VALUEFUNC(_wrap_FXMenuTitle_resize), -1);
    rb_define_method(cFXMenuTitle.klass, "getDefaultWidth", VALUEFUNC(_wrap_FXMenuTitle_getDefaultWidth), -1);
    rb_define_method(cFXMenuTitle.klass, "getDefaultHeight", VALUEFUNC(_wrap_FXMenuTitle_getDefaultHeight), -1);
    rb_define_method(cFXMenuTitle.klass, "getWidthForHeight", VALUEFUNC(_wrap_FXMenuTitle_getWidthForHeight), -1);
    rb_define_method(cFXMenuTitle.klass, "getHeightForWidth", VALUEFUNC(_wrap_FXMenuTitle_getHeightForWidth), -1);
    rb_define_method(cFXMenuTitle.klass, "canFocus", VALUEFUNC(_wrap_FXMenuTitle_canFocus), -1);
    rb_define_method(cFXMenuTitle.klass, "setFocus", VALUEFUNC(_wrap_FXMenuTitle_setFocus), -1);
    rb_define_method(cFXMenuTitle.klass, "killFocus", VALUEFUNC(_wrap_FXMenuTitle_killFocus), -1);
    rb_define_method(cFXMenuTitle.klass, "setDefault", VALUEFUNC(_wrap_FXMenuTitle_setDefault), -1);
    rb_define_method(cFXMenuTitle.klass, "enable", VALUEFUNC(_wrap_FXMenuTitle_enable), -1);
    rb_define_method(cFXMenuTitle.klass, "disable", VALUEFUNC(_wrap_FXMenuTitle_disable), -1);
    rb_define_method(cFXMenuTitle.klass, "raiseWindow", VALUEFUNC(_wrap_FXMenuTitle_raiseWindow), -1);
    rb_define_method(cFXMenuTitle.klass, "lower", VALUEFUNC(_wrap_FXMenuTitle_lower), -1);
    rb_define_method(cFXMenuTitle.klass, "move", VALUEFUNC(_wrap_FXMenuTitle_move), -1);
    rb_define_method(cFXMenuTitle.klass, "position", VALUEFUNC(_wrap_FXMenuTitle_position), -1);
    rb_define_method(cFXMenuTitle.klass, "layout", VALUEFUNC(_wrap_FXMenuTitle_layout), -1);
    rb_define_method(cFXMenuTitle.klass, "recalc", VALUEFUNC(_wrap_FXMenuTitle_recalc), -1);
    rb_define_method(cFXMenuTitle.klass, "reparent", VALUEFUNC(_wrap_FXMenuTitle_reparent), -1);
    rb_define_method(cFXMenuTitle.klass, "show", VALUEFUNC(_wrap_FXMenuTitle_show), -1);
    rb_define_method(cFXMenuTitle.klass, "hide", VALUEFUNC(_wrap_FXMenuTitle_hide), -1);
    rb_define_method(cFXMenuTitle.klass, "isComposite", VALUEFUNC(_wrap_FXMenuTitle_isComposite), -1);
    rb_define_method(cFXMenuTitle.klass, "contains", VALUEFUNC(_wrap_FXMenuTitle_contains), -1);
    rb_define_method(cFXMenuTitle.klass, "doesSaveUnder", VALUEFUNC(_wrap_FXMenuTitle_doesSaveUnder), -1);
    rb_define_method(cFXMenuTitle.klass, "setBackColor", VALUEFUNC(_wrap_FXMenuTitle_setBackColor), -1);
    cFXMenuTitle.mark = (void (*)(void *)) FXRbMenuTitle::markfunc;
    cFXMenuTitle.destroy = (void (*)(void *)) FXRbObject::freefunc;
    
    cFXMenuCascade.klass = rb_define_class_under(mFox, "FXMenuCascade", ((swig_class *) SWIGTYPE_p_FXMenuCaption->clientdata)->klass);
    SWIG_TypeClientData(SWIGTYPE_p_FXMenuCascade, (void *) &cFXMenuCascade);
    rb_define_alloc_func(cFXMenuCascade.klass, _wrap_FXMenuCascade_allocate);
    rb_define_method(cFXMenuCascade.klass, "initialize", VALUEFUNC(_wrap_new_FXMenuCascade), -1);
    rb_define_method(cFXMenuCascade.klass, "onPaint", VALUEFUNC(_wrap_FXMenuCascade_onPaint), -1);
    rb_define_method(cFXMenuCascade.klass, "onEnter", VALUEFUNC(_wrap_FXMenuCascade_onEnter), -1);
    rb_define_method(cFXMenuCascade.klass, "onLeave", VALUEFUNC(_wrap_FXMenuCascade_onLeave), -1);
    rb_define_method(cFXMenuCascade.klass, "onButtonPress", VALUEFUNC(_wrap_FXMenuCascade_onButtonPress), -1);
    rb_define_method(cFXMenuCascade.klass, "onButtonRelease", VALUEFUNC(_wrap_FXMenuCascade_onButtonRelease), -1);
    rb_define_method(cFXMenuCascade.klass, "onKeyPress", VALUEFUNC(_wrap_FXMenuCascade_onKeyPress), -1);
    rb_define_method(cFXMenuCascade.klass, "onKeyRelease", VALUEFUNC(_wrap_FXMenuCascade_onKeyRelease), -1);
    rb_define_method(cFXMenuCascade.klass, "onHotKeyPress", VALUEFUNC(_wrap_FXMenuCascade_onHotKeyPress), -1);
    rb_define_method(cFXMenuCascade.klass, "onHotKeyRelease", VALUEFUNC(_wrap_FXMenuCascade_onHotKeyRelease), -1);
    rb_define_method(cFXMenuCascade.klass, "onCmdPost", VALUEFUNC(_wrap_FXMenuCascade_onCmdPost), -1);
    rb_define_method(cFXMenuCascade.klass, "onCmdUnpost", VALUEFUNC(_wrap_FXMenuCascade_onCmdUnpost), -1);
    rb_define_const(cFXMenuCascade.klass,"ID_MENUTIMER", INT2NUM(FXMenuCascade::ID_MENUTIMER));
    rb_define_const(cFXMenuCascade.klass,"ID_LAST", INT2NUM(FXMenuCascade::ID_LAST));
    rb_define_method(cFXMenuCascade.klass, "setMenu", VALUEFUNC(_wrap_FXMenuCascade_setMenu), -1);
    rb_define_method(cFXMenuCascade.klass, "getMenu", VALUEFUNC(_wrap_FXMenuCascade_getMenu), -1);
    rb_define_method(cFXMenuCascade.klass, "save", VALUEFUNC(_wrap_FXMenuCascade_save), -1);
    rb_define_method(cFXMenuCascade.klass, "load", VALUEFUNC(_wrap_FXMenuCascade_load), -1);
    rb_define_method(cFXMenuCascade.klass, "create", VALUEFUNC(_wrap_FXMenuCascade_create), -1);
    rb_define_method(cFXMenuCascade.klass, "detach", VALUEFUNC(_wrap_FXMenuCascade_detach), -1);
    rb_define_method(cFXMenuCascade.klass, "destroy", VALUEFUNC(_wrap_FXMenuCascade_destroy), -1);
    rb_define_method(cFXMenuCascade.klass, "resize", VALUEFUNC(_wrap_FXMenuCascade_resize), -1);
    rb_define_method(cFXMenuCascade.klass, "getDefaultWidth", VALUEFUNC(_wrap_FXMenuCascade_getDefaultWidth), -1);
    rb_define_method(cFXMenuCascade.klass, "getDefaultHeight", VALUEFUNC(_wrap_FXMenuCascade_getDefaultHeight), -1);
    rb_define_method(cFXMenuCascade.klass, "getWidthForHeight", VALUEFUNC(_wrap_FXMenuCascade_getWidthForHeight), -1);
    rb_define_method(cFXMenuCascade.klass, "getHeightForWidth", VALUEFUNC(_wrap_FXMenuCascade_getHeightForWidth), -1);
    rb_define_method(cFXMenuCascade.klass, "canFocus", VALUEFUNC(_wrap_FXMenuCascade_canFocus), -1);
    rb_define_method(cFXMenuCascade.klass, "setFocus", VALUEFUNC(_wrap_FXMenuCascade_setFocus), -1);
    rb_define_method(cFXMenuCascade.klass, "killFocus", VALUEFUNC(_wrap_FXMenuCascade_killFocus), -1);
    rb_define_method(cFXMenuCascade.klass, "setDefault", VALUEFUNC(_wrap_FXMenuCascade_setDefault), -1);
    rb_define_method(cFXMenuCascade.klass, "enable", VALUEFUNC(_wrap_FXMenuCascade_enable), -1);
    rb_define_method(cFXMenuCascade.klass, "disable", VALUEFUNC(_wrap_FXMenuCascade_disable), -1);
    rb_define_method(cFXMenuCascade.klass, "raiseWindow", VALUEFUNC(_wrap_FXMenuCascade_raiseWindow), -1);
    rb_define_method(cFXMenuCascade.klass, "lower", VALUEFUNC(_wrap_FXMenuCascade_lower), -1);
    rb_define_method(cFXMenuCascade.klass, "move", VALUEFUNC(_wrap_FXMenuCascade_move), -1);
    rb_define_method(cFXMenuCascade.klass, "position", VALUEFUNC(_wrap_FXMenuCascade_position), -1);
    rb_define_method(cFXMenuCascade.klass, "layout", VALUEFUNC(_wrap_FXMenuCascade_layout), -1);
    rb_define_method(cFXMenuCascade.klass, "recalc", VALUEFUNC(_wrap_FXMenuCascade_recalc), -1);
    rb_define_method(cFXMenuCascade.klass, "reparent", VALUEFUNC(_wrap_FXMenuCascade_reparent), -1);
    rb_define_method(cFXMenuCascade.klass, "show", VALUEFUNC(_wrap_FXMenuCascade_show), -1);
    rb_define_method(cFXMenuCascade.klass, "hide", VALUEFUNC(_wrap_FXMenuCascade_hide), -1);
    rb_define_method(cFXMenuCascade.klass, "isComposite", VALUEFUNC(_wrap_FXMenuCascade_isComposite), -1);
    rb_define_method(cFXMenuCascade.klass, "contains", VALUEFUNC(_wrap_FXMenuCascade_contains), -1);
    rb_define_method(cFXMenuCascade.klass, "doesSaveUnder", VALUEFUNC(_wrap_FXMenuCascade_doesSaveUnder), -1);
    rb_define_method(cFXMenuCascade.klass, "setBackColor", VALUEFUNC(_wrap_FXMenuCascade_setBackColor), -1);
    cFXMenuCascade.mark = (void (*)(void *)) FXRbMenuCascade::markfunc;
    cFXMenuCascade.destroy = (void (*)(void *)) FXRbObject::freefunc;
    
    cFXMenuCommand.klass = rb_define_class_under(mFox, "FXMenuCommand", ((swig_class *) SWIGTYPE_p_FXMenuCaption->clientdata)->klass);
    SWIG_TypeClientData(SWIGTYPE_p_FXMenuCommand, (void *) &cFXMenuCommand);
    rb_define_alloc_func(cFXMenuCommand.klass, _wrap_FXMenuCommand_allocate);
    rb_define_method(cFXMenuCommand.klass, "initialize", VALUEFUNC(_wrap_new_FXMenuCommand), -1);
    rb_define_method(cFXMenuCommand.klass, "onPaint", VALUEFUNC(_wrap_FXMenuCommand_onPaint), -1);
    rb_define_method(cFXMenuCommand.klass, "onEnter", VALUEFUNC(_wrap_FXMenuCommand_onEnter), -1);
    rb_define_method(cFXMenuCommand.klass, "onLeave", VALUEFUNC(_wrap_FXMenuCommand_onLeave), -1);
    rb_define_method(cFXMenuCommand.klass, "onButtonPress", VALUEFUNC(_wrap_FXMenuCommand_onButtonPress), -1);
    rb_define_method(cFXMenuCommand.klass, "onButtonRelease", VALUEFUNC(_wrap_FXMenuCommand_onButtonRelease), -1);
    rb_define_method(cFXMenuCommand.klass, "onKeyPress", VALUEFUNC(_wrap_FXMenuCommand_onKeyPress), -1);
    rb_define_method(cFXMenuCommand.klass, "onKeyRelease", VALUEFUNC(_wrap_FXMenuCommand_onKeyRelease), -1);
    rb_define_method(cFXMenuCommand.klass, "onHotKeyPress", VALUEFUNC(_wrap_FXMenuCommand_onHotKeyPress), -1);
    rb_define_method(cFXMenuCommand.klass, "onHotKeyRelease", VALUEFUNC(_wrap_FXMenuCommand_onHotKeyRelease), -1);
    rb_define_method(cFXMenuCommand.klass, "onCmdAccel", VALUEFUNC(_wrap_FXMenuCommand_onCmdAccel), -1);
    rb_define_method(cFXMenuCommand.klass, "setAccelText", VALUEFUNC(_wrap_FXMenuCommand_setAccelText), -1);
    rb_define_method(cFXMenuCommand.klass, "getAccelText", VALUEFUNC(_wrap_FXMenuCommand_getAccelText), -1);
    rb_define_method(cFXMenuCommand.klass, "save", VALUEFUNC(_wrap_FXMenuCommand_save), -1);
    rb_define_method(cFXMenuCommand.klass, "load", VALUEFUNC(_wrap_FXMenuCommand_load), -1);
    rb_define_method(cFXMenuCommand.klass, "create", VALUEFUNC(_wrap_FXMenuCommand_create), -1);
    rb_define_method(cFXMenuCommand.klass, "detach", VALUEFUNC(_wrap_FXMenuCommand_detach), -1);
    rb_define_method(cFXMenuCommand.klass, "destroy", VALUEFUNC(_wrap_FXMenuCommand_destroy), -1);
    rb_define_method(cFXMenuCommand.klass, "resize", VALUEFUNC(_wrap_FXMenuCommand_resize), -1);
    rb_define_method(cFXMenuCommand.klass, "getDefaultWidth", VALUEFUNC(_wrap_FXMenuCommand_getDefaultWidth), -1);
    rb_define_method(cFXMenuCommand.klass, "getDefaultHeight", VALUEFUNC(_wrap_FXMenuCommand_getDefaultHeight), -1);
    rb_define_method(cFXMenuCommand.klass, "getWidthForHeight", VALUEFUNC(_wrap_FXMenuCommand_getWidthForHeight), -1);
    rb_define_method(cFXMenuCommand.klass, "getHeightForWidth", VALUEFUNC(_wrap_FXMenuCommand_getHeightForWidth), -1);
    rb_define_method(cFXMenuCommand.klass, "canFocus", VALUEFUNC(_wrap_FXMenuCommand_canFocus), -1);
    rb_define_method(cFXMenuCommand.klass, "setFocus", VALUEFUNC(_wrap_FXMenuCommand_setFocus), -1);
    rb_define_method(cFXMenuCommand.klass, "killFocus", VALUEFUNC(_wrap_FXMenuCommand_killFocus), -1);
    rb_define_method(cFXMenuCommand.klass, "setDefault", VALUEFUNC(_wrap_FXMenuCommand_setDefault), -1);
    rb_define_method(cFXMenuCommand.klass, "enable", VALUEFUNC(_wrap_FXMenuCommand_enable), -1);
    rb_define_method(cFXMenuCommand.klass, "disable", VALUEFUNC(_wrap_FXMenuCommand_disable), -1);
    rb_define_method(cFXMenuCommand.klass, "raiseWindow", VALUEFUNC(_wrap_FXMenuCommand_raiseWindow), -1);
    rb_define_method(cFXMenuCommand.klass, "lower", VALUEFUNC(_wrap_FXMenuCommand_lower), -1);
    rb_define_method(cFXMenuCommand.klass, "move", VALUEFUNC(_wrap_FXMenuCommand_move), -1);
    rb_define_method(cFXMenuCommand.klass, "position", VALUEFUNC(_wrap_FXMenuCommand_position), -1);
    rb_define_method(cFXMenuCommand.klass, "layout", VALUEFUNC(_wrap_FXMenuCommand_layout), -1);
    rb_define_method(cFXMenuCommand.klass, "recalc", VALUEFUNC(_wrap_FXMenuCommand_recalc), -1);
    rb_define_method(cFXMenuCommand.klass, "reparent", VALUEFUNC(_wrap_FXMenuCommand_reparent), -1);
    rb_define_method(cFXMenuCommand.klass, "show", VALUEFUNC(_wrap_FXMenuCommand_show), -1);
    rb_define_method(cFXMenuCommand.klass, "hide", VALUEFUNC(_wrap_FXMenuCommand_hide), -1);
    rb_define_method(cFXMenuCommand.klass, "isComposite", VALUEFUNC(_wrap_FXMenuCommand_isComposite), -1);
    rb_define_method(cFXMenuCommand.klass, "contains", VALUEFUNC(_wrap_FXMenuCommand_contains), -1);
    rb_define_method(cFXMenuCommand.klass, "doesSaveUnder", VALUEFUNC(_wrap_FXMenuCommand_doesSaveUnder), -1);
    rb_define_method(cFXMenuCommand.klass, "setBackColor", VALUEFUNC(_wrap_FXMenuCommand_setBackColor), -1);
    cFXMenuCommand.mark = (void (*)(void *)) FXRbMenuCommand::markfunc;
    cFXMenuCommand.destroy = (void (*)(void *)) FXRbObject::freefunc;
    
    cFXMenuBar.klass = rb_define_class_under(mFox, "FXMenuBar", ((swig_class *) SWIGTYPE_p_FXToolBar->clientdata)->klass);
    SWIG_TypeClientData(SWIGTYPE_p_FXMenuBar, (void *) &cFXMenuBar);
    rb_define_alloc_func(cFXMenuBar.klass, _wrap_FXMenuBar_allocate);
    rb_define_method(cFXMenuBar.klass, "initialize", VALUEFUNC(_wrap_new_FXMenuBar), -1);
    rb_define_method(cFXMenuBar.klass, "onFocusLeft", VALUEFUNC(_wrap_FXMenuBar_onFocusLeft), -1);
    rb_define_method(cFXMenuBar.klass, "onFocusRight", VALUEFUNC(_wrap_FXMenuBar_onFocusRight), -1);
    rb_define_method(cFXMenuBar.klass, "onEnter", VALUEFUNC(_wrap_FXMenuBar_onEnter), -1);
    rb_define_method(cFXMenuBar.klass, "onLeave", VALUEFUNC(_wrap_FXMenuBar_onLeave), -1);
    rb_define_method(cFXMenuBar.klass, "onMotion", VALUEFUNC(_wrap_FXMenuBar_onMotion), -1);
    rb_define_method(cFXMenuBar.klass, "onButtonPress", VALUEFUNC(_wrap_FXMenuBar_onButtonPress), -1);
    rb_define_method(cFXMenuBar.klass, "onButtonRelease", VALUEFUNC(_wrap_FXMenuBar_onButtonRelease), -1);
    rb_define_method(cFXMenuBar.klass, "onCmdUnpost", VALUEFUNC(_wrap_FXMenuBar_onCmdUnpost), -1);
    rb_define_method(cFXMenuBar.klass, "save", VALUEFUNC(_wrap_FXMenuBar_save), -1);
    rb_define_method(cFXMenuBar.klass, "load", VALUEFUNC(_wrap_FXMenuBar_load), -1);
    rb_define_method(cFXMenuBar.klass, "create", VALUEFUNC(_wrap_FXMenuBar_create), -1);
    rb_define_method(cFXMenuBar.klass, "detach", VALUEFUNC(_wrap_FXMenuBar_detach), -1);
    rb_define_method(cFXMenuBar.klass, "destroy", VALUEFUNC(_wrap_FXMenuBar_destroy), -1);
    rb_define_method(cFXMenuBar.klass, "resize", VALUEFUNC(_wrap_FXMenuBar_resize), -1);
    rb_define_method(cFXMenuBar.klass, "getDefaultWidth", VALUEFUNC(_wrap_FXMenuBar_getDefaultWidth), -1);
    rb_define_method(cFXMenuBar.klass, "getDefaultHeight", VALUEFUNC(_wrap_FXMenuBar_getDefaultHeight), -1);
    rb_define_method(cFXMenuBar.klass, "getWidthForHeight", VALUEFUNC(_wrap_FXMenuBar_getWidthForHeight), -1);
    rb_define_method(cFXMenuBar.klass, "getHeightForWidth", VALUEFUNC(_wrap_FXMenuBar_getHeightForWidth), -1);
    rb_define_method(cFXMenuBar.klass, "canFocus", VALUEFUNC(_wrap_FXMenuBar_canFocus), -1);
    rb_define_method(cFXMenuBar.klass, "setFocus", VALUEFUNC(_wrap_FXMenuBar_setFocus), -1);
    rb_define_method(cFXMenuBar.klass, "killFocus", VALUEFUNC(_wrap_FXMenuBar_killFocus), -1);
    rb_define_method(cFXMenuBar.klass, "setDefault", VALUEFUNC(_wrap_FXMenuBar_setDefault), -1);
    rb_define_method(cFXMenuBar.klass, "enable", VALUEFUNC(_wrap_FXMenuBar_enable), -1);
    rb_define_method(cFXMenuBar.klass, "disable", VALUEFUNC(_wrap_FXMenuBar_disable), -1);
    rb_define_method(cFXMenuBar.klass, "raiseWindow", VALUEFUNC(_wrap_FXMenuBar_raiseWindow), -1);
    rb_define_method(cFXMenuBar.klass, "lower", VALUEFUNC(_wrap_FXMenuBar_lower), -1);
    rb_define_method(cFXMenuBar.klass, "move", VALUEFUNC(_wrap_FXMenuBar_move), -1);
    rb_define_method(cFXMenuBar.klass, "position", VALUEFUNC(_wrap_FXMenuBar_position), -1);
    rb_define_method(cFXMenuBar.klass, "layout", VALUEFUNC(_wrap_FXMenuBar_layout), -1);
    rb_define_method(cFXMenuBar.klass, "recalc", VALUEFUNC(_wrap_FXMenuBar_recalc), -1);
    rb_define_method(cFXMenuBar.klass, "reparent", VALUEFUNC(_wrap_FXMenuBar_reparent), -1);
    rb_define_method(cFXMenuBar.klass, "show", VALUEFUNC(_wrap_FXMenuBar_show), -1);
    rb_define_method(cFXMenuBar.klass, "hide", VALUEFUNC(_wrap_FXMenuBar_hide), -1);
    rb_define_method(cFXMenuBar.klass, "isComposite", VALUEFUNC(_wrap_FXMenuBar_isComposite), -1);
    rb_define_method(cFXMenuBar.klass, "contains", VALUEFUNC(_wrap_FXMenuBar_contains), -1);
    rb_define_method(cFXMenuBar.klass, "doesSaveUnder", VALUEFUNC(_wrap_FXMenuBar_doesSaveUnder), -1);
    rb_define_method(cFXMenuBar.klass, "setBackColor", VALUEFUNC(_wrap_FXMenuBar_setBackColor), -1);
    rb_define_method(cFXMenuBar.klass, "dock", VALUEFUNC(_wrap_FXMenuBar_dock), -1);
    rb_define_method(cFXMenuBar.klass, "undock", VALUEFUNC(_wrap_FXMenuBar_undock), -1);
    cFXMenuBar.mark = (void (*)(void *)) FXRbMenuBar::markfunc;
    cFXMenuBar.destroy = (void (*)(void *)) FXRbObject::freefunc;
    
    cFXMenuCheck.klass = rb_define_class_under(mFox, "FXMenuCheck", ((swig_class *) SWIGTYPE_p_FXMenuCommand->clientdata)->klass);
    SWIG_TypeClientData(SWIGTYPE_p_FXMenuCheck, (void *) &cFXMenuCheck);
    rb_define_alloc_func(cFXMenuCheck.klass, _wrap_FXMenuCheck_allocate);
    rb_define_method(cFXMenuCheck.klass, "initialize", VALUEFUNC(_wrap_new_FXMenuCheck), -1);
    rb_define_method(cFXMenuCheck.klass, "onPaint", VALUEFUNC(_wrap_FXMenuCheck_onPaint), -1);
    rb_define_method(cFXMenuCheck.klass, "onButtonPress", VALUEFUNC(_wrap_FXMenuCheck_onButtonPress), -1);
    rb_define_method(cFXMenuCheck.klass, "onButtonRelease", VALUEFUNC(_wrap_FXMenuCheck_onButtonRelease), -1);
    rb_define_method(cFXMenuCheck.klass, "onKeyPress", VALUEFUNC(_wrap_FXMenuCheck_onKeyPress), -1);
    rb_define_method(cFXMenuCheck.klass, "onKeyRelease", VALUEFUNC(_wrap_FXMenuCheck_onKeyRelease), -1);
    rb_define_method(cFXMenuCheck.klass, "onHotKeyPress", VALUEFUNC(_wrap_FXMenuCheck_onHotKeyPress), -1);
    rb_define_method(cFXMenuCheck.klass, "onHotKeyRelease", VALUEFUNC(_wrap_FXMenuCheck_onHotKeyRelease), -1);
    rb_define_method(cFXMenuCheck.klass, "onCheck", VALUEFUNC(_wrap_FXMenuCheck_onCheck), -1);
    rb_define_method(cFXMenuCheck.klass, "onUncheck", VALUEFUNC(_wrap_FXMenuCheck_onUncheck), -1);
    rb_define_method(cFXMenuCheck.klass, "onUnknown", VALUEFUNC(_wrap_FXMenuCheck_onUnknown), -1);
    rb_define_method(cFXMenuCheck.klass, "onCmdSetValue", VALUEFUNC(_wrap_FXMenuCheck_onCmdSetValue), -1);
    rb_define_method(cFXMenuCheck.klass, "onCmdSetIntValue", VALUEFUNC(_wrap_FXMenuCheck_onCmdSetIntValue), -1);
    rb_define_method(cFXMenuCheck.klass, "onCmdGetIntValue", VALUEFUNC(_wrap_FXMenuCheck_onCmdGetIntValue), -1);
    rb_define_method(cFXMenuCheck.klass, "onCmdAccel", VALUEFUNC(_wrap_FXMenuCheck_onCmdAccel), -1);
    rb_define_method(cFXMenuCheck.klass, "setCheck", VALUEFUNC(_wrap_FXMenuCheck_setCheck), -1);
    rb_define_method(cFXMenuCheck.klass, "getCheck", VALUEFUNC(_wrap_FXMenuCheck_getCheck), -1);
    rb_define_method(cFXMenuCheck.klass, "getBoxColor", VALUEFUNC(_wrap_FXMenuCheck_getBoxColor), -1);
    rb_define_method(cFXMenuCheck.klass, "setBoxColor", VALUEFUNC(_wrap_FXMenuCheck_setBoxColor), -1);
    rb_define_method(cFXMenuCheck.klass, "save", VALUEFUNC(_wrap_FXMenuCheck_save), -1);
    rb_define_method(cFXMenuCheck.klass, "load", VALUEFUNC(_wrap_FXMenuCheck_load), -1);
    rb_define_method(cFXMenuCheck.klass, "create", VALUEFUNC(_wrap_FXMenuCheck_create), -1);
    rb_define_method(cFXMenuCheck.klass, "detach", VALUEFUNC(_wrap_FXMenuCheck_detach), -1);
    rb_define_method(cFXMenuCheck.klass, "destroy", VALUEFUNC(_wrap_FXMenuCheck_destroy), -1);
    rb_define_method(cFXMenuCheck.klass, "resize", VALUEFUNC(_wrap_FXMenuCheck_resize), -1);
    rb_define_method(cFXMenuCheck.klass, "getDefaultWidth", VALUEFUNC(_wrap_FXMenuCheck_getDefaultWidth), -1);
    rb_define_method(cFXMenuCheck.klass, "getDefaultHeight", VALUEFUNC(_wrap_FXMenuCheck_getDefaultHeight), -1);
    rb_define_method(cFXMenuCheck.klass, "getWidthForHeight", VALUEFUNC(_wrap_FXMenuCheck_getWidthForHeight), -1);
    rb_define_method(cFXMenuCheck.klass, "getHeightForWidth", VALUEFUNC(_wrap_FXMenuCheck_getHeightForWidth), -1);
    rb_define_method(cFXMenuCheck.klass, "canFocus", VALUEFUNC(_wrap_FXMenuCheck_canFocus), -1);
    rb_define_method(cFXMenuCheck.klass, "setFocus", VALUEFUNC(_wrap_FXMenuCheck_setFocus), -1);
    rb_define_method(cFXMenuCheck.klass, "killFocus", VALUEFUNC(_wrap_FXMenuCheck_killFocus), -1);
    rb_define_method(cFXMenuCheck.klass, "setDefault", VALUEFUNC(_wrap_FXMenuCheck_setDefault), -1);
    rb_define_method(cFXMenuCheck.klass, "enable", VALUEFUNC(_wrap_FXMenuCheck_enable), -1);
    rb_define_method(cFXMenuCheck.klass, "disable", VALUEFUNC(_wrap_FXMenuCheck_disable), -1);
    rb_define_method(cFXMenuCheck.klass, "raiseWindow", VALUEFUNC(_wrap_FXMenuCheck_raiseWindow), -1);
    rb_define_method(cFXMenuCheck.klass, "lower", VALUEFUNC(_wrap_FXMenuCheck_lower), -1);
    rb_define_method(cFXMenuCheck.klass, "move", VALUEFUNC(_wrap_FXMenuCheck_move), -1);
    rb_define_method(cFXMenuCheck.klass, "position", VALUEFUNC(_wrap_FXMenuCheck_position), -1);
    rb_define_method(cFXMenuCheck.klass, "layout", VALUEFUNC(_wrap_FXMenuCheck_layout), -1);
    rb_define_method(cFXMenuCheck.klass, "recalc", VALUEFUNC(_wrap_FXMenuCheck_recalc), -1);
    rb_define_method(cFXMenuCheck.klass, "reparent", VALUEFUNC(_wrap_FXMenuCheck_reparent), -1);
    rb_define_method(cFXMenuCheck.klass, "show", VALUEFUNC(_wrap_FXMenuCheck_show), -1);
    rb_define_method(cFXMenuCheck.klass, "hide", VALUEFUNC(_wrap_FXMenuCheck_hide), -1);
    rb_define_method(cFXMenuCheck.klass, "isComposite", VALUEFUNC(_wrap_FXMenuCheck_isComposite), -1);
    rb_define_method(cFXMenuCheck.klass, "contains", VALUEFUNC(_wrap_FXMenuCheck_contains), -1);
    rb_define_method(cFXMenuCheck.klass, "doesSaveUnder", VALUEFUNC(_wrap_FXMenuCheck_doesSaveUnder), -1);
    rb_define_method(cFXMenuCheck.klass, "setBackColor", VALUEFUNC(_wrap_FXMenuCheck_setBackColor), -1);
    cFXMenuCheck.mark = 0;
    cFXMenuCheck.destroy = (void (*)(void *)) FXRbObject::freefunc;
    
    cFXMenuRadio.klass = rb_define_class_under(mFox, "FXMenuRadio", ((swig_class *) SWIGTYPE_p_FXMenuCommand->clientdata)->klass);
    SWIG_TypeClientData(SWIGTYPE_p_FXMenuRadio, (void *) &cFXMenuRadio);
    rb_define_alloc_func(cFXMenuRadio.klass, _wrap_FXMenuRadio_allocate);
    rb_define_method(cFXMenuRadio.klass, "initialize", VALUEFUNC(_wrap_new_FXMenuRadio), -1);
    rb_define_method(cFXMenuRadio.klass, "onPaint", VALUEFUNC(_wrap_FXMenuRadio_onPaint), -1);
    rb_define_method(cFXMenuRadio.klass, "onButtonPress", VALUEFUNC(_wrap_FXMenuRadio_onButtonPress), -1);
    rb_define_method(cFXMenuRadio.klass, "onButtonRelease", VALUEFUNC(_wrap_FXMenuRadio_onButtonRelease), -1);
    rb_define_method(cFXMenuRadio.klass, "onKeyPress", VALUEFUNC(_wrap_FXMenuRadio_onKeyPress), -1);
    rb_define_method(cFXMenuRadio.klass, "onKeyRelease", VALUEFUNC(_wrap_FXMenuRadio_onKeyRelease), -1);
    rb_define_method(cFXMenuRadio.klass, "onHotKeyPress", VALUEFUNC(_wrap_FXMenuRadio_onHotKeyPress), -1);
    rb_define_method(cFXMenuRadio.klass, "onHotKeyRelease", VALUEFUNC(_wrap_FXMenuRadio_onHotKeyRelease), -1);
    rb_define_method(cFXMenuRadio.klass, "onCheck", VALUEFUNC(_wrap_FXMenuRadio_onCheck), -1);
    rb_define_method(cFXMenuRadio.klass, "onUncheck", VALUEFUNC(_wrap_FXMenuRadio_onUncheck), -1);
    rb_define_method(cFXMenuRadio.klass, "onUnknown", VALUEFUNC(_wrap_FXMenuRadio_onUnknown), -1);
    rb_define_method(cFXMenuRadio.klass, "onCmdSetValue", VALUEFUNC(_wrap_FXMenuRadio_onCmdSetValue), -1);
    rb_define_method(cFXMenuRadio.klass, "onCmdSetIntValue", VALUEFUNC(_wrap_FXMenuRadio_onCmdSetIntValue), -1);
    rb_define_method(cFXMenuRadio.klass, "onCmdGetIntValue", VALUEFUNC(_wrap_FXMenuRadio_onCmdGetIntValue), -1);
    rb_define_method(cFXMenuRadio.klass, "onCmdAccel", VALUEFUNC(_wrap_FXMenuRadio_onCmdAccel), -1);
    rb_define_method(cFXMenuRadio.klass, "setCheck", VALUEFUNC(_wrap_FXMenuRadio_setCheck), -1);
    rb_define_method(cFXMenuRadio.klass, "getCheck", VALUEFUNC(_wrap_FXMenuRadio_getCheck), -1);
    rb_define_method(cFXMenuRadio.klass, "getRadioColor", VALUEFUNC(_wrap_FXMenuRadio_getRadioColor), -1);
    rb_define_method(cFXMenuRadio.klass, "setRadioColor", VALUEFUNC(_wrap_FXMenuRadio_setRadioColor), -1);
    rb_define_method(cFXMenuRadio.klass, "save", VALUEFUNC(_wrap_FXMenuRadio_save), -1);
    rb_define_method(cFXMenuRadio.klass, "load", VALUEFUNC(_wrap_FXMenuRadio_load), -1);
    rb_define_method(cFXMenuRadio.klass, "create", VALUEFUNC(_wrap_FXMenuRadio_create), -1);
    rb_define_method(cFXMenuRadio.klass, "detach", VALUEFUNC(_wrap_FXMenuRadio_detach), -1);
    rb_define_method(cFXMenuRadio.klass, "destroy", VALUEFUNC(_wrap_FXMenuRadio_destroy), -1);
    rb_define_method(cFXMenuRadio.klass, "resize", VALUEFUNC(_wrap_FXMenuRadio_resize), -1);
    rb_define_method(cFXMenuRadio.klass, "getDefaultWidth", VALUEFUNC(_wrap_FXMenuRadio_getDefaultWidth), -1);
    rb_define_method(cFXMenuRadio.klass, "getDefaultHeight", VALUEFUNC(_wrap_FXMenuRadio_getDefaultHeight), -1);
    rb_define_method(cFXMenuRadio.klass, "getWidthForHeight", VALUEFUNC(_wrap_FXMenuRadio_getWidthForHeight), -1);
    rb_define_method(cFXMenuRadio.klass, "getHeightForWidth", VALUEFUNC(_wrap_FXMenuRadio_getHeightForWidth), -1);
    rb_define_method(cFXMenuRadio.klass, "canFocus", VALUEFUNC(_wrap_FXMenuRadio_canFocus), -1);
    rb_define_method(cFXMenuRadio.klass, "setFocus", VALUEFUNC(_wrap_FXMenuRadio_setFocus), -1);
    rb_define_method(cFXMenuRadio.klass, "killFocus", VALUEFUNC(_wrap_FXMenuRadio_killFocus), -1);
    rb_define_method(cFXMenuRadio.klass, "setDefault", VALUEFUNC(_wrap_FXMenuRadio_setDefault), -1);
    rb_define_method(cFXMenuRadio.klass, "enable", VALUEFUNC(_wrap_FXMenuRadio_enable), -1);
    rb_define_method(cFXMenuRadio.klass, "disable", VALUEFUNC(_wrap_FXMenuRadio_disable), -1);
    rb_define_method(cFXMenuRadio.klass, "raiseWindow", VALUEFUNC(_wrap_FXMenuRadio_raiseWindow), -1);
    rb_define_method(cFXMenuRadio.klass, "lower", VALUEFUNC(_wrap_FXMenuRadio_lower), -1);
    rb_define_method(cFXMenuRadio.klass, "move", VALUEFUNC(_wrap_FXMenuRadio_move), -1);
    rb_define_method(cFXMenuRadio.klass, "position", VALUEFUNC(_wrap_FXMenuRadio_position), -1);
    rb_define_method(cFXMenuRadio.klass, "layout", VALUEFUNC(_wrap_FXMenuRadio_layout), -1);
    rb_define_method(cFXMenuRadio.klass, "recalc", VALUEFUNC(_wrap_FXMenuRadio_recalc), -1);
    rb_define_method(cFXMenuRadio.klass, "reparent", VALUEFUNC(_wrap_FXMenuRadio_reparent), -1);
    rb_define_method(cFXMenuRadio.klass, "show", VALUEFUNC(_wrap_FXMenuRadio_show), -1);
    rb_define_method(cFXMenuRadio.klass, "hide", VALUEFUNC(_wrap_FXMenuRadio_hide), -1);
    rb_define_method(cFXMenuRadio.klass, "isComposite", VALUEFUNC(_wrap_FXMenuRadio_isComposite), -1);
    rb_define_method(cFXMenuRadio.klass, "contains", VALUEFUNC(_wrap_FXMenuRadio_contains), -1);
    rb_define_method(cFXMenuRadio.klass, "doesSaveUnder", VALUEFUNC(_wrap_FXMenuRadio_doesSaveUnder), -1);
    rb_define_method(cFXMenuRadio.klass, "setBackColor", VALUEFUNC(_wrap_FXMenuRadio_setBackColor), -1);
    cFXMenuRadio.mark = 0;
    cFXMenuRadio.destroy = (void (*)(void *)) FXRbObject::freefunc;
}

